# Help
Here are some tips, solutions to common problems, and guides for testing.

## Tips

### Use default settings

The default settings offer good accuracy that an email address is valid and is performant. If you wish to be stricter,
enable `checkDisposableEmail` to prevent potentially low value users from utilizing your web application.

## Asking for help on Stack Overflow
Be sure when you [ask a question](http://stackoverflow.com/questions/ask?tags=php,email,validation) pertaining to the 
usage of this library be sure to tag your question with the **PHP**, **email**, **validation** tags. Make sure you follow their
[guide for asking a good question](http://stackoverflow.com/help/how-to-ask) as poorly asked questions will be closed, 
and I will not be able to assist you.

A good question will include all the following:
- A description of the problem (what are you trying to do? what results are you expecting? what results are you actually getting?)
- The code you are using (only post the relevant code)
- The output of your method call(s)
- Any error message(s) you are getting

**Do not use Stack Overflow to report bugs.** Bugs may be reported [here](https://github.com/stymiee/email-validator/issues/new).

## Useful Links

- [Going Deeper Into Email Address Validation](https://www.johnconde.net/blog/going-deeper-into-email-address-validation/) (article)
- [Tutorial: PHP Email Address Validator](https://www.johnconde.net/blog/tutorial-php-ema…ddress-validator/)
