<?php
/**
 *
 * @copyright 2008 - https://www.clicshopping.org
 * @Brand : ClicShoppingAI(TM) at Inpi all right Reserved
 * @Licence GPL 2 & MIT
 * @Info : https://www.clicshopping.org/forum/trademark/
 *
 */

namespace ClicShopping\Sites\Shop\Pages\Account\Actions\CreatePro;

use ClicShopping\Apps\Tools\ActionsRecorder\Classes\Shop\ActionRecorder;
use ClicShopping\OM\CLICSHOPPING;
use ClicShopping\OM\DateTime;
use ClicShopping\OM\Hash;
use ClicShopping\OM\HTML;
use ClicShopping\OM\HTTP;
use ClicShopping\OM\Is;
use ClicShopping\OM\Registry;

use ClicShopping\Apps\Configuration\TemplateEmail\Classes\Shop\TemplateEmail;
use ClicShopping\Apps\Customers\Groups\Classes\ClicShoppingAdmin\VatNumber;
use function defined;
use function is_null;
use function strlen;

class Process extends \ClicShopping\OM\PagesActionsAbstract
{
  public function execute()
  {
    $CLICSHOPPING_Db = Registry::get('Db');
    $CLICSHOPPING_Customer = Registry::get('Customer');
    $CLICSHOPPING_MessageStack = Registry::get('MessageStack');
    $CLICSHOPPING_ShoppingCart = Registry::get('ShoppingCart');
    $CLICSHOPPING_Mail = Registry::get('Mail');
    $CLICSHOPPING_Language = Registry::get('Language');
    $CLICSHOPPING_Hooks = Registry::get('Hooks');

    $_SESSION['process'] = false;

    if (isset($_POST['action']) && ($_POST['action'] == 'process') && isset($_POST['formid']) && ($_POST['formid'] === $_SESSION['sessiontoken'])) {
      $error = false;
      $_SESSION['process'] = true;
      $zone_id = false;

      $CLICSHOPPING_Hooks->call('CreatePro', 'PreAction');

      if (isset($_POST['firstname'])) $firstname = HTML::sanitize($_POST['firstname']);
      if (isset($_POST['lastname'])) $lastname = HTML::sanitize($_POST['lastname']);
      if (isset($_POST['email_address'])) $email_address = HTML::sanitize($_POST['email_address']);
      if (isset($_POST['email_address_confirm'])) $email_address_confirmation = HTML::sanitize($_POST['email_address_confirm']);
      if (isset($_POST['postcode'])) $postcode = HTML::sanitize($_POST['postcode']);
      if (isset($_POST['city'])) $city = HTML::sanitize($_POST['city']);

      if (isset($_POST['customer_website_company'])) {
        $customer_website_company = HTML::sanitize($_POST['customer_website_company']);
      } else {
        $customer_website_company = null;
      }
      if (isset($_POST['street_address'])) $street_address = HTML::sanitize($_POST['street_address']);

      if (isset($_POST['dob']) && ACCOUNT_DOB_PRO == 'true') {
        $dob = DateTime::toShortWithoutFormat(HTML::sanitize($_POST['dob']));
      } else {
        $dob = null;
      }

      if (isset($_POST['gender']) && ACCOUNT_GENDER_PRO == 'true') {
        $gender = HTML::sanitize($_POST['gender']);
      } else {
        $gender = null;
      }

      if (isset($_POST['company']) && ACCOUNT_COMPANY_PRO == 'true') {
        $company = HTML::sanitize($_POST['company']);
      } else {
        $company = null;
      }

      if (isset($_POST['siret']) && ACCOUNT_SIRET_PRO == 'true') {
        $siret = HTML::sanitize($_POST['siret']);
      } else {
        $siret = null;
      }

      if (isset($_POST['ape']) && ACCOUNT_APE_PRO == 'true') {
        $ape = HTML::sanitize($_POST['ape']);
      } else {
        $ape = null;
      }

      if (isset($_POST['tva_intracom']) && ACCOUNT_TVA_INTRACOM_PRO == 'true') {
        $tva_intracom = HTML::sanitize($_POST['tva_intracom']);

        $iso = substr($tva_intracom, 0, 2);
        $iso = substr(str_replace(' ', '', $iso), 2);

// webservice check the tva
        if (!empty($iso) && !empty($tva_intracom)) {
          $result = VatNumber::serviceCheckVat($iso, $tva_intracom);

          if ($result === true) {
            $error = true;
            $CLICSHOPPING_MessageStack->add(CLICSHOPPING::getDef('entry_tva_intracom_error'), 'error');
          }
        }
      } else {
        $tva_intracom = null;
        $iso = null;
      }

      if (ACCOUNT_SUBURB_PRO == 'true') {
        $suburb = HTML::sanitize($_POST['suburb']);
      } else {
        $suburb = null;
      }

      if (ACCOUNT_STATE_PRO == 'true') {
        if (isset($_POST['state'])) {
          $state = HTML::sanitize($_POST['state']);
        } else {
          $state = null;
        }

        if (isset($_POST['zone_id'])) {
          $zone_id = HTML::sanitize($_POST['zone_id']);
        }
      }

      if (isset($_POST['country'])) $country = HTML::sanitize($_POST['country']);

      if (isset($_POST['customers_telephone'])) $telephone = HTML::sanitize($_POST['customers_telephone']);

      if (isset($_POST['cellular_phone']) && ACCOUNT_CELLULAR_PHONE_PRO == 'true') {
        $cellular_phone = HTML::sanitize($_POST['cellular_phone']);
      } else {
        $cellular_phone = null;
      }

      if (isset($_POST['newsletter'])) {
        $newsletter = HTML::sanitize($_POST['newsletter']);
      } else {
        $newsletter = 0;
      }

      if (isset($_POST['password'])) {
        $password = HTML::sanitize($_POST['password']);
      } else {
        $password = '';
      }

      if (isset($_POST['confirmation'])) {
        $confirmation = HTML::sanitize($_POST['confirmation']);
      } else {
        $confirmation = '';
      }

      $customer_agree_privacy = HTML::sanitize($_POST['customer_agree_privacy']);

      if (DISPLAY_PRIVACY_CONDITIONS == 'true') {
        if ($customer_agree_privacy != 'on') {
          $error = true;

          $CLICSHOPPING_MessageStack->add(CLICSHOPPING::getDef('entry_agreement_check_error'), 'error');
        }
      }

// Clients B2B : Controle entree de la societe
      if (ACCOUNT_COMPANY_PRO == 'true') {
        if (strlen($company) < ENTRY_COMPANY_PRO_MIN_LENGTH) {
          $error = true;

          $CLICSHOPPING_MessageStack->add(CLICSHOPPING::getDef('entry_company_error_pro', ['min_length' => ENTRY_COMPANY_PRO_MIN_LENGTH]), 'error');
        }
      }

      if (ACCOUNT_SIRET_PRO == 'true') {
        if (strlen($siret) < ENTRY_SIRET_MIN_LENGTH && strlen($siret) > 14) {
          $error = true;

          $CLICSHOPPING_MessageStack->add(CLICSHOPPING::getDef('entry_siret_error', ['min_length' => ENTRY_SIRET_MIN_LENGTH]), 'error');
        }
      }

      if (ACCOUNT_APE_PRO == 'true') {
        if (strlen($ape) < ENTRY_CODE_APE_MIN_LENGTH && strlen($ape) > 4) {
          $error = true;

          $CLICSHOPPING_MessageStack->add(CLICSHOPPING::getDef('entry_code_ape_error', ['min_length' => ENTRY_CODE_APE_MIN_LENGTH]), 'error');
        }
      }

      if (ACCOUNT_TVA_INTRACOM_PRO == 'true') {
        if (strlen($tva_intracom) < ENTRY_TVA_INTRACOM_MIN_LENGTH && strlen($tva_intracom) > 14) {
          $error = true;

          $CLICSHOPPING_MessageStack->add(CLICSHOPPING::getDef('entry_tva_intracom_error', ['min_length' => ENTRY_TVA_INTRACOM_MIN_LENGTH]), 'error');
        }
      }

      if (ACCOUNT_GENDER_PRO == 'true') {
        if (($gender != 'm') && ($gender != 'f')) {
          $error = true;

          $CLICSHOPPING_MessageStack->add(CLICSHOPPING::getDef('entry_gender_error_pro'), 'error');
        }
      }

      if (strlen($firstname) < ENTRY_FIRST_NAME_PRO_MIN_LENGTH) {
        $error = true;

        $CLICSHOPPING_MessageStack->add(CLICSHOPPING::getDef('entry_first_name_error_pro', ['min_length' => ENTRY_FIRST_NAME_PRO_MIN_LENGTH]), 'error');
      }

      if (strlen($lastname) < ENTRY_LAST_NAME_PRO_MIN_LENGTH) {
        $error = true;

        $CLICSHOPPING_MessageStack->add(CLICSHOPPING::getDef('entry_last_name_error_pro', ['min_length' => ENTRY_LAST_NAME_PRO_MIN_LENGTH]), 'error');
      }

      if (ACCOUNT_DOB_PRO == 'true') {
        $dobDateTime = new DateTime($dob);

        if ((strlen($dob) < ENTRY_DOB_MIN_LENGTH) || ($dobDateTime->isValid() === false)) {
          $error = true;

          $CLICSHOPPING_MessageStack->add(CLICSHOPPING::getDef('entry_date_of_birth_error_pro', ['min_length' => ENTRY_DOB_MIN_LENGTH]), 'error');
        }
      }

      if (Is::EmailAddress($email_address) === false) {
        $error = true;

        $CLICSHOPPING_MessageStack->add(CLICSHOPPING::getDef('entry_email_address_check_error_pro'), 'error');

      } elseif ($email_address != $email_address_confirmation) {
        $error = true;
        $CLICSHOPPING_MessageStack->add(CLICSHOPPING::getDef('entry_email_address_confirmation_check_error_pro'), 'error');
      } else {
        $Qcheckemail = $CLICSHOPPING_Db->prepare('select customers_id
                                                    from :table_customers
                                                    where customers_email_address = :customers_email_address
                                                   ');
        $Qcheckemail->bindValue(':customers_email_address', $email_address);

        $Qcheckemail->execute();

        if ($Qcheckemail->fetch() !== false) {
          $error = true;

          $CLICSHOPPING_MessageStack->add(CLICSHOPPING::getDef('entry_email_address_error_exists_pro'), 'error');
        }
      }

      if (strlen($street_address) < ENTRY_STREET_ADDRESS_PRO_MIN_LENGTH) {
        $error = true;

        $CLICSHOPPING_MessageStack->add(CLICSHOPPING::getDef('entry_street_address_error_pro', ['min_length' => ENTRY_STREET_ADDRESS_PRO_MIN_LENGTH]), 'error');
      }

      if (strlen($postcode) < ENTRY_POSTCODE_PRO_MIN_LENGTH) {
        $error = true;

        $CLICSHOPPING_MessageStack->add(CLICSHOPPING::getDef('entry_post_code_error_pro', ['min_length' => ENTRY_POSTCODE_PRO_MIN_LENGTH]), 'error');
      }

      if (strlen($city) < ENTRY_CITY_PRO_MIN_LENGTH) {
        $error = true;

        $CLICSHOPPING_MessageStack->add(CLICSHOPPING::getDef('entry_city_error', ['min_length' => ENTRY_CITY_PRO_MIN_LENGTH]), 'error');
      }

      if (!is_numeric($country)) {
        $Qcheck = $CLICSHOPPING_Db->prepare('select countries_id
                                               from :table_countries
                                               where countries_iso_code_2 = :countries_iso_code_2
                                              ');
        $Qcheck->bindValue(':countries_iso_code_2', $country);
        $Qcheck->execute();

        $country = $Qcheck->valueInt('countries_id');
        $_SESSION['country'] = $country;
      }

      if (ACCOUNT_STATE_PRO == 'true' && is_numeric($country)) {
        $zone_id = 0;

        $Qcheck = $CLICSHOPPING_Db->prepare('select count(*) as total
                                               from :table_zones
                                               where zone_country_id = :zone_country_id
                                              ');
        $Qcheck->bindInt(':zone_country_id', (int)$country);
        $Qcheck->execute();

        $_SESSION['entry_state_has_zones'] = ($Qcheck->valueInt('total') > 0);

        if (isset($_SESSION['entry_state_has_zones']) === true) {
          if (ACCOUNT_STATE_DROPDOWN == 'true') {
            $Qzone = $CLICSHOPPING_Db->prepare('select distinct zone_id
                                                   from :table_zones
                                                   where zone_country_id = :zone_country_id
                                                   and zone_id = :zone_id
                                                   and zone_status = 0
                                                 ');

            $Qzone->bindInt(':zone_country_id', $country);
            $Qzone->bindInt(':zone_id', $state);
            $Qzone->execute();
          } else {
            if (!is_numeric($state)) {
              $Qzone = $CLICSHOPPING_Db->prepare('select distinct zone_id
                                                    from :table_zones
                                                    where zone_country_id = :zone_country_id
                                                    and zone_name = :zone_name
                                                    and zone_status = 0
                                                  ');
              $Qzone->bindInt(':zone_country_id', $country);
              $Qzone->bindValue(':zone_name', $state);

              $Qzone->execute();
            } else {
              $Qzone = $CLICSHOPPING_Db->prepare('select distinct zone_id
                                                  from :table_zones
                                                  where zone_country_id = :zone_country_id
                                                  and zone_id = :zone_id
                                                  and zone_status = 0
                                                ');
              $Qzone->bindInt(':zone_country_id', $country);
              $Qzone->bindValue(':zone_id', $state);

              $Qzone->execute();
            }
          }

          if (!empty($Qzone->valueInt('zone_id')) || !is_null($Qzone->valueInt('zone_id'))) {
            $zone_id = (int)$Qzone->valueInt('zone_id');
          } else {
            $error = true;

            $CLICSHOPPING_MessageStack->add(CLICSHOPPING::getDef('entry_state_error_select_pro'), 'error');
          }
        } else {
          if (strlen($state) < ENTRY_STATE_PRO_MIN_LENGTH) {
            $error = true;

            $CLICSHOPPING_MessageStack->add(CLICSHOPPING::getDef('entry_state_error_pro', ['min_length' => ENTRY_STATE_PRO_MIN_LENGTH]), 'error');
          }
        }
      }

      if (strlen($telephone) < ENTRY_TELEPHONE_PRO_MIN_LENGTH) {
        $error = true;

        $CLICSHOPPING_MessageStack->add(CLICSHOPPING::getDef('entry_telephone_number_error_pro', ['min_length' => ENTRY_TELEPHONE_PRO_MIN_LENGTH]), 'error');
      }

      if (MEMBER == 'false') {
        if (strlen($password) < ENTRY_PASSWORD_PRO_MIN_LENGTH) {
          $error = true;

          $CLICSHOPPING_MessageStack->add(CLICSHOPPING::getDef('entry_password_error_pro', ['min_length' => ENTRY_PASSWORD_PRO_MIN_LENGTH]), 'error');

        } elseif ($password != $confirmation) {
          $error = true;

          $CLICSHOPPING_MessageStack->add(CLICSHOPPING::getDef('entry_password_error_not_matching_pro'), 'error');
        }
      }

      $QcustomersGroup = $CLICSHOPPING_Db->prepare('select group_order_taxe,
                                                             group_payment_unallowed,
                                                             group_shipping_unallowed
                                                       from :table_customers_groups
                                                       where customers_group_id = :customers_group_id
                                                       ');
      $QcustomersGroup->bindInt(':customers_group_id', (int)ACCOUNT_GROUP_DEFAULT_PRO);
      $QcustomersGroup->execute();

      if ($QcustomersGroup->fetch() !== false) {
        $customers_group = $QcustomersGroup->fetch();
      }

      if (MEMBER == 'false') {
        $member_level_approbation = 1;
      } else {
        $member_level_approbation = 0;
      }

      if (ACCOUNT_MODIFY_PRO == 'false') {
        $customers_modify_company = 0;
      } else {
        $customers_modify_company = 1;
      }

      if (ACCOUNT_MODIFY_ADRESS_DEFAULT_PRO == 'false') {
        $customers_modify_address_default = 0;
      } else {
        $customers_modify_address_default = 1;
      }

// Autorisation par defaut au client de pouvoir ajouter des adresses dans son carnet
      if (ACCOUNT_ADRESS_BOOK_PRO == 'false') {
        $customers_add_address = 0;
      } else {
        $customers_add_address = 1;
      }

      Registry::set('ActionRecorder', new ActionRecorder('ar_create_account_pro', ($CLICSHOPPING_Customer->isLoggedOn() ? $CLICSHOPPING_Customer->getID() : null), $lastname));
      $CLICSHOPPING_ActionRecorder = Registry::get('ActionRecorder');

      if (!$CLICSHOPPING_ActionRecorder->canPerform()) {
        $error = true;
        $CLICSHOPPING_ActionRecorder->record(false);

        $CLICSHOPPING_MessageStack->add(CLICSHOPPING::getDef('error_action_recorder', ['module_action_recorder_create_account_email_minutes' => (defined('MODULE_ACTION_RECORDER_CREATE_ACCOUNT_PRO_EMAIL_MINUTES') ? (int)MODULE_ACTION_RECORDER_CREATE_ACCOUNT_PRO_EMAIL_MINUTES : 15)]), 'error');
      }

      if ($error === false) {
        $sql_data_array = [
          'customers_firstname' => Hash::encryptDatatext($firstname),
          'customers_lastname' => Hash::encryptDatatext($lastname),
          'customers_email_address' => $email_address,
          'customers_telephone' => Hash::encryptDatatext($telephone),
          'customers_newsletter' => (int)$newsletter,
          'customers_password' => Hash::encrypt($password),
          'languages_id' => (int)$CLICSHOPPING_Language->getId(),
          'member_level' => $member_level_approbation,
          'customers_modify_company' => $customers_modify_company,
          'customers_modify_address_default' => $customers_modify_address_default,
          'customers_add_address' => $customers_add_address,
          'client_computer_ip' => HTTP::getIPAddress(),
          'provider_name_client' => HTTP::getProviderNameCustomer(),
          'customer_website_company' => $customer_website_company
        ];

        if (ACCOUNT_CELLULAR_PHONE_PRO == 'true') $sql_data_array['customers_cellular_phone'] = Hash::encryptDatatext($cellular_phone);

        if ($QcustomersGroup->fetch() !== false) $sql_data_array['customers_group_id'] = ACCOUNT_GROUP_DEFAULT_PRO;
        if ($QcustomersGroup->fetch() !== false) $sql_data_array['customers_options_order_taxe'] = $customers_group['group_order_taxe'];

        if (ACCOUNT_GENDER_PRO == 'true') $sql_data_array['customers_gender'] = $gender;
        if (ACCOUNT_DOB_PRO == 'true') $sql_data_array['customers_dob'] = $dobDateTime->getRaw(false);
        if (ACCOUNT_COMPANY_PRO == 'true') $sql_data_array['customers_company'] = Hash::encryptDatatext($company);
        if (ACCOUNT_SIRET_PRO == 'true') $sql_data_array['customers_siret'] = $siret;
        if (ACCOUNT_APE_PRO == 'true') $sql_data_array['customers_ape'] = $ape;
        if (ACCOUNT_TVA_INTRACOM_PRO == 'true') $sql_data_array['customers_tva_intracom'] = $tva_intracom;
        if (ACCOUNT_TVA_INTRACOM_PRO == 'true') $sql_data_array['customers_tva_intracom_code_iso'] = $iso;

        $CLICSHOPPING_Db->save('customers', $sql_data_array);

        $customer_id = $CLICSHOPPING_Db->lastInsertId();
// save element in address book
        $sql_data_array = [
          'customers_id' => (int)$customer_id,
          'entry_firstname' => Hash::encryptDatatext($firstname),
          'entry_lastname' => Hash::encryptDatatext($lastname),
          'entry_street_address' => Hash::encryptDatatext($street_address),
          'entry_postcode' => Hash::encryptDatatext($postcode),
          'entry_city' => Hash::encryptDatatext($city),
          'entry_country_id' => (int)$country,
          'entry_telephone' => Hash::encryptDatatext($telephone)
        ];

        if (ACCOUNT_CELLULAR_PHONE_PRO == 'true') $sql_data_array['customers_cellular_phone'] = Hash::encryptDatatext($cellular_phone);
        if (ACCOUNT_GENDER_PRO == 'true') $sql_data_array['entry_gender'] = $gender;
        if (ACCOUNT_COMPANY_PRO == 'true') $sql_data_array['entry_company'] = Hash::encryptDatatext($company);
        if (ACCOUNT_SUBURB_PRO == 'true') $sql_data_array['entry_suburb'] = Hash::encryptDatatext($suburb);
        if (ACCOUNT_STATE_PRO == 'true') {

          if ($zone_id > 0) {
            $sql_data_array['entry_zone_id'] = (int)$zone_id;
            $sql_data_array['entry_state'] = '';
          } else {
            $sql_data_array['entry_zone_id'] = 0;
            $sql_data_array['entry_state'] = $state;
          }
        }

        $CLICSHOPPING_Db->save('address_book', $sql_data_array);

        $address_id = $CLICSHOPPING_Db->lastInsertId();

        $sql_data_array = ['customers_default_address_id' => (int)$address_id];
        $insert_array = ['customers_id' => (int)$customer_id];

        $CLICSHOPPING_Db->save('customers', $sql_data_array, $insert_array);

        $sql_array = [
          'customers_info_id' => (int)$customer_id,
          'customers_info_number_of_logons' => 0,
          'customers_info_date_account_created' => 'now()'
        ];

        $CLICSHOPPING_Db->save('customers_info', $sql_array);

        if (MEMBER == 'false') {
          $CLICSHOPPING_Customer->setData($customer_id);
        }

        Registry::get('Session')->recreate();

// restore cart contents
        $CLICSHOPPING_ShoppingCart->getRestoreContents();

// build the message content
        $name = $firstname . ' ' . $lastname;

        if (MEMBER == 'false') {
          $template_email_welcome_catalog = TemplateEmail::getTemplateEmailWelcomeCatalog();
        } else {
          $template_email_welcome_catalog = CLICSHOPPING::getDef('email_welcome', ['store_name' => STORE_NAME, 'store_owner_email_address' => STORE_OWNER_EMAIL_ADDRESS]);
        }

        if (defined('COUPON_CUSTOMER_B2B') && !empty(COUPON_CUSTOMER_B2B)) {
          $email_coupon = CLICSHOPPING::getDef('email_text_coupon') . ' ' . COUPON_CUSTOMER_B2B;
        } else {
          $email_coupon = '';
        }

// Content email
        $template_email_signature = TemplateEmail::getTemplateEmailSignature();
        $template_email_footer = TemplateEmail::getTemplateEmailTextFooter();
        $email_subject = CLICSHOPPING::getDef('email_subject', ['store_name' => STORE_NAME]);
        $email_gender = CLICSHOPPING::getDef('email_greet_ms', ['lastname' => $lastname]) . ' ' . CLICSHOPPING::getDef('email_greet_mr', ['lastname' => $lastname]);
        $email_text = $email_gender . ',<br /><br />' . $template_email_welcome_catalog . '<br /><br />' . $email_coupon . '<br /><br />' . $template_email_signature . '<br /><br />' . $template_email_footer;

// EEmail send
        $message = $email_text;
        $message = str_replace('src="/', 'src="' . HTTP::typeUrlDomain() . '/', $message);
        $CLICSHOPPING_Mail->addHtmlCkeditor($message);

        $from = STORE_OWNER_EMAIL_ADDRESS;

        $CLICSHOPPING_Mail->send($email_address, $name, null, $from, $email_subject);
// Administrator email
        if (EMAIL_INFORMA_ACCOUNT_ADMIN == 'true') {
          $email_subject_admin = CLICSHOPPING::getDef('admin_email_subject', ['store_name' => STORE_NAME]);
          $admin_email_welcome = CLICSHOPPING::getDef('email_welcome', ['store_name' => STORE_NAME, 'store_owner_email_address' => STORE_OWNER_EMAIL_ADDRESS]);

          $data_array = [
            'customer_name' => HTML::sanitize($_POST['lastname']),
            'customer_firstame' => HTML::sanitize($_POST['firstname']),
            'customer_company' => HTML::sanitize($_POST['company']),
            'customer_mail' => $_POST['email_address']
          ];

          $admin_email_text_admin = CLICSHOPPING::getDef('admin_email_text', $data_array);

          $email_address = STORE_OWNER_EMAIL_ADDRESS;
          $from = STORE_OWNER_EMAIL_ADDRESS;
          $admin_email_text_admin .= $admin_email_welcome . $admin_email_text_admin;
          $CLICSHOPPING_Mail->addHtmlCkeditor($admin_email_text_admin);

          $CLICSHOPPING_Mail->send($email_address, STORE_NAME, null, $from, $email_subject_admin);
        }

        $CLICSHOPPING_ActionRecorder->record();

        $CLICSHOPPING_Hooks->call('Create', 'Process');

        CLICSHOPPING::redirect(null, 'Account&CreatePro&Success');
      }
    }
  }
}
