<?php
/**
 * SettingsApi
 * PHP version 7.4
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 9.1.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\ObjectSerializer;

/**
 * SettingsApi Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class SettingsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createSettings' => [
            'application/json',
        ],
        'deleteGlobalServiceSetting' => [
            'application/json',
        ],
        'deleteOrchdLoginPolicyEmailBlacklist' => [
            'application/json',
        ],
        'deleteOrchdLoginPolicyEmailWhitelist' => [
            'application/json',
        ],
        'deleteOrchdLoginPolicyIpBlacklist' => [
            'application/json',
        ],
        'deleteOrchdLoginPolicyIpWhitelist' => [
            'application/json',
        ],
        'deleteOrchdLoginPolicyTemporaryEmailBlacklist' => [
            'application/json',
        ],
        'deleteOrchdLoginPolicyTemporaryEmailWhitelist' => [
            'application/json',
        ],
        'deleteOrchdLoginPolicyTemporaryIpBlacklist' => [
            'application/json',
        ],
        'deleteOrchdLoginPolicyTemporaryIpWhitelist' => [
            'application/json',
        ],
        'deleteSetting' => [
            'application/json',
        ],
        'getDockerRegistry' => [
            'application/json',
        ],
        'getGlobalServiceSetting' => [
            'application/json',
        ],
        'getOrchdLogSettings' => [
            'application/json',
        ],
        'getOrchdLoginPolicyEmailBlacklist' => [
            'application/json',
        ],
        'getOrchdLoginPolicyEmailWhitelist' => [
            'application/json',
        ],
        'getOrchdLoginPolicyIpBlacklist' => [
            'application/json',
        ],
        'getOrchdLoginPolicyIpWhitelist' => [
            'application/json',
        ],
        'getOrchdLoginPolicySettings' => [
            'application/json',
        ],
        'getOrchdLoginPolicyTemporaryEmailBlacklist' => [
            'application/json',
        ],
        'getOrchdLoginPolicyTemporaryEmailWhitelist' => [
            'application/json',
        ],
        'getOrchdLoginPolicyTemporaryIpBlacklist' => [
            'application/json',
        ],
        'getOrchdLoginPolicyTemporaryIpWhitelist' => [
            'application/json',
        ],
        'getSetting' => [
            'application/json',
        ],
        'getSettings' => [
            'application/json',
        ],
        'setDockerRegistry' => [
            'application/json',
        ],
        'setGlobalServiceSetting' => [
            'application/json',
        ],
        'setOrchdLogSettings' => [
            'application/json',
        ],
        'setOrchdLoginPolicyEmailBlacklist' => [
            'application/json',
        ],
        'setOrchdLoginPolicyEmailWhitelist' => [
            'application/json',
        ],
        'setOrchdLoginPolicyIpBlacklist' => [
            'application/json',
        ],
        'setOrchdLoginPolicyIpWhitelist' => [
            'application/json',
        ],
        'setOrchdLoginPolicySettings' => [
            'application/json',
        ],
        'setOrchdLoginPolicyTemporaryEmailBlacklist' => [
            'application/json',
        ],
        'setOrchdLoginPolicyTemporaryEmailWhitelist' => [
            'application/json',
        ],
        'setOrchdLoginPolicyTemporaryIpBlacklist' => [
            'application/json',
        ],
        'setOrchdLoginPolicyTemporaryIpWhitelist' => [
            'application/json',
        ],
        'updateSetting' => [
            'application/json',
        ],
    ];

/**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createSettings
     *
     * Create settings
     *
     * @param  \OpenAPI\Client\Model\Setting[] $setting setting (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createSettings($setting, string $contentType = self::contentTypes['createSettings'][0])
    {
        $this->createSettingsWithHttpInfo($setting, $contentType);
    }

    /**
     * Operation createSettingsWithHttpInfo
     *
     * Create settings
     *
     * @param  \OpenAPI\Client\Model\Setting[] $setting (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createSettingsWithHttpInfo($setting, string $contentType = self::contentTypes['createSettings'][0])
    {
        $request = $this->createSettingsRequest($setting, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createSettingsAsync
     *
     * Create settings
     *
     * @param  \OpenAPI\Client\Model\Setting[] $setting (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSettingsAsync($setting, string $contentType = self::contentTypes['createSettings'][0])
    {
        return $this->createSettingsAsyncWithHttpInfo($setting, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createSettingsAsyncWithHttpInfo
     *
     * Create settings
     *
     * @param  \OpenAPI\Client\Model\Setting[] $setting (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSettingsAsyncWithHttpInfo($setting, string $contentType = self::contentTypes['createSettings'][0])
    {
        $returnType = '';
        $request = $this->createSettingsRequest($setting, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createSettings'
     *
     * @param  \OpenAPI\Client\Model\Setting[] $setting (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createSettingsRequest($setting, string $contentType = self::contentTypes['createSettings'][0])
    {

        // verify the required parameter 'setting' is set
        if ($setting === null || (is_array($setting) && count($setting) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $setting when calling createSettings'
            );
        }


        $resourcePath = '/settings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($setting)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($setting));
            } else {
                $httpBody = $setting;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteGlobalServiceSetting
     *
     * Delete a single global service setting
     *
     * @param  SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $setting_key A key for updating an existing setting, some known values are - hard_delete_after_secs - letsencrypt_enabled - myhostname - org_websites_same_server - screenshot_driver_pool_size - screenshot_interval - sged_smtp - smtp_smart_host - website_backup (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Outcome|\OpenAPI\Client\Model\Outcome
     */
    public function deleteGlobalServiceSetting($setting_kind, $setting_key, string $contentType = self::contentTypes['deleteGlobalServiceSetting'][0])
    {
        list($response) = $this->deleteGlobalServiceSettingWithHttpInfo($setting_kind, $setting_key, $contentType);
        return $response;
    }

    /**
     * Operation deleteGlobalServiceSettingWithHttpInfo
     *
     * Delete a single global service setting
     *
     * @param  SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $setting_key A key for updating an existing setting, some known values are - hard_delete_after_secs - letsencrypt_enabled - myhostname - org_websites_same_server - screenshot_driver_pool_size - screenshot_interval - sged_smtp - smtp_smart_host - website_backup (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Outcome|\OpenAPI\Client\Model\Outcome, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteGlobalServiceSettingWithHttpInfo($setting_kind, $setting_key, string $contentType = self::contentTypes['deleteGlobalServiceSetting'][0])
    {
        $request = $this->deleteGlobalServiceSettingRequest($setting_kind, $setting_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\Outcome' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\Outcome' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\Outcome', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 202:
                    if ('\OpenAPI\Client\Model\Outcome' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\Outcome' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\Outcome', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\Outcome';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Outcome',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 202:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Outcome',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteGlobalServiceSettingAsync
     *
     * Delete a single global service setting
     *
     * @param  SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $setting_key A key for updating an existing setting, some known values are - hard_delete_after_secs - letsencrypt_enabled - myhostname - org_websites_same_server - screenshot_driver_pool_size - screenshot_interval - sged_smtp - smtp_smart_host - website_backup (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGlobalServiceSettingAsync($setting_kind, $setting_key, string $contentType = self::contentTypes['deleteGlobalServiceSetting'][0])
    {
        return $this->deleteGlobalServiceSettingAsyncWithHttpInfo($setting_kind, $setting_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteGlobalServiceSettingAsyncWithHttpInfo
     *
     * Delete a single global service setting
     *
     * @param  SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $setting_key A key for updating an existing setting, some known values are - hard_delete_after_secs - letsencrypt_enabled - myhostname - org_websites_same_server - screenshot_driver_pool_size - screenshot_interval - sged_smtp - smtp_smart_host - website_backup (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGlobalServiceSettingAsyncWithHttpInfo($setting_kind, $setting_key, string $contentType = self::contentTypes['deleteGlobalServiceSetting'][0])
    {
        $returnType = '\OpenAPI\Client\Model\Outcome';
        $request = $this->deleteGlobalServiceSettingRequest($setting_kind, $setting_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteGlobalServiceSetting'
     *
     * @param  SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $setting_key A key for updating an existing setting, some known values are - hard_delete_after_secs - letsencrypt_enabled - myhostname - org_websites_same_server - screenshot_driver_pool_size - screenshot_interval - sged_smtp - smtp_smart_host - website_backup (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteGlobalServiceSettingRequest($setting_kind, $setting_key, string $contentType = self::contentTypes['deleteGlobalServiceSetting'][0])
    {

        // verify the required parameter 'setting_kind' is set
        if ($setting_kind === null || (is_array($setting_kind) && count($setting_kind) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $setting_kind when calling deleteGlobalServiceSetting'
            );
        }

        // verify the required parameter 'setting_key' is set
        if ($setting_key === null || (is_array($setting_key) && count($setting_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $setting_key when calling deleteGlobalServiceSetting'
            );
        }


        $resourcePath = '/settings/service/{setting_kind}/{setting_key}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($setting_kind !== null) {
            $resourcePath = str_replace(
                '{' . 'setting_kind' . '}',
                ObjectSerializer::toPathValue($setting_kind),
                $resourcePath
            );
        }
        // path params
        if ($setting_key !== null) {
            $resourcePath = str_replace(
                '{' . 'setting_key' . '}',
                ObjectSerializer::toPathValue($setting_key),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteOrchdLoginPolicyEmailBlacklist
     *
     * Delete an orchd login policy email blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteOrchdLoginPolicyEmailBlacklist($orchd_login_policy_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyEmailBlacklist'][0])
    {
        $this->deleteOrchdLoginPolicyEmailBlacklistWithHttpInfo($orchd_login_policy_email_list, $contentType);
    }

    /**
     * Operation deleteOrchdLoginPolicyEmailBlacklistWithHttpInfo
     *
     * Delete an orchd login policy email blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteOrchdLoginPolicyEmailBlacklistWithHttpInfo($orchd_login_policy_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyEmailBlacklist'][0])
    {
        $request = $this->deleteOrchdLoginPolicyEmailBlacklistRequest($orchd_login_policy_email_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteOrchdLoginPolicyEmailBlacklistAsync
     *
     * Delete an orchd login policy email blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyEmailBlacklistAsync($orchd_login_policy_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyEmailBlacklist'][0])
    {
        return $this->deleteOrchdLoginPolicyEmailBlacklistAsyncWithHttpInfo($orchd_login_policy_email_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteOrchdLoginPolicyEmailBlacklistAsyncWithHttpInfo
     *
     * Delete an orchd login policy email blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyEmailBlacklistAsyncWithHttpInfo($orchd_login_policy_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyEmailBlacklist'][0])
    {
        $returnType = '';
        $request = $this->deleteOrchdLoginPolicyEmailBlacklistRequest($orchd_login_policy_email_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteOrchdLoginPolicyEmailBlacklist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteOrchdLoginPolicyEmailBlacklistRequest($orchd_login_policy_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyEmailBlacklist'][0])
    {

        // verify the required parameter 'orchd_login_policy_email_list' is set
        if ($orchd_login_policy_email_list === null || (is_array($orchd_login_policy_email_list) && count($orchd_login_policy_email_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_email_list when calling deleteOrchdLoginPolicyEmailBlacklist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/email-blacklist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_email_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_email_list));
            } else {
                $httpBody = $orchd_login_policy_email_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteOrchdLoginPolicyEmailWhitelist
     *
     * Delete an orchd login policy email whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteOrchdLoginPolicyEmailWhitelist($orchd_login_policy_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyEmailWhitelist'][0])
    {
        $this->deleteOrchdLoginPolicyEmailWhitelistWithHttpInfo($orchd_login_policy_email_list, $contentType);
    }

    /**
     * Operation deleteOrchdLoginPolicyEmailWhitelistWithHttpInfo
     *
     * Delete an orchd login policy email whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteOrchdLoginPolicyEmailWhitelistWithHttpInfo($orchd_login_policy_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyEmailWhitelist'][0])
    {
        $request = $this->deleteOrchdLoginPolicyEmailWhitelistRequest($orchd_login_policy_email_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteOrchdLoginPolicyEmailWhitelistAsync
     *
     * Delete an orchd login policy email whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyEmailWhitelistAsync($orchd_login_policy_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyEmailWhitelist'][0])
    {
        return $this->deleteOrchdLoginPolicyEmailWhitelistAsyncWithHttpInfo($orchd_login_policy_email_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteOrchdLoginPolicyEmailWhitelistAsyncWithHttpInfo
     *
     * Delete an orchd login policy email whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyEmailWhitelistAsyncWithHttpInfo($orchd_login_policy_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyEmailWhitelist'][0])
    {
        $returnType = '';
        $request = $this->deleteOrchdLoginPolicyEmailWhitelistRequest($orchd_login_policy_email_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteOrchdLoginPolicyEmailWhitelist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteOrchdLoginPolicyEmailWhitelistRequest($orchd_login_policy_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyEmailWhitelist'][0])
    {

        // verify the required parameter 'orchd_login_policy_email_list' is set
        if ($orchd_login_policy_email_list === null || (is_array($orchd_login_policy_email_list) && count($orchd_login_policy_email_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_email_list when calling deleteOrchdLoginPolicyEmailWhitelist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/email-whitelist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_email_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_email_list));
            } else {
                $httpBody = $orchd_login_policy_email_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteOrchdLoginPolicyIpBlacklist
     *
     * Delete an orchd login policy ip blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteOrchdLoginPolicyIpBlacklist($orchd_login_policy_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyIpBlacklist'][0])
    {
        $this->deleteOrchdLoginPolicyIpBlacklistWithHttpInfo($orchd_login_policy_ip_list, $contentType);
    }

    /**
     * Operation deleteOrchdLoginPolicyIpBlacklistWithHttpInfo
     *
     * Delete an orchd login policy ip blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteOrchdLoginPolicyIpBlacklistWithHttpInfo($orchd_login_policy_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyIpBlacklist'][0])
    {
        $request = $this->deleteOrchdLoginPolicyIpBlacklistRequest($orchd_login_policy_ip_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteOrchdLoginPolicyIpBlacklistAsync
     *
     * Delete an orchd login policy ip blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyIpBlacklistAsync($orchd_login_policy_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyIpBlacklist'][0])
    {
        return $this->deleteOrchdLoginPolicyIpBlacklistAsyncWithHttpInfo($orchd_login_policy_ip_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteOrchdLoginPolicyIpBlacklistAsyncWithHttpInfo
     *
     * Delete an orchd login policy ip blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyIpBlacklistAsyncWithHttpInfo($orchd_login_policy_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyIpBlacklist'][0])
    {
        $returnType = '';
        $request = $this->deleteOrchdLoginPolicyIpBlacklistRequest($orchd_login_policy_ip_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteOrchdLoginPolicyIpBlacklist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteOrchdLoginPolicyIpBlacklistRequest($orchd_login_policy_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyIpBlacklist'][0])
    {

        // verify the required parameter 'orchd_login_policy_ip_list' is set
        if ($orchd_login_policy_ip_list === null || (is_array($orchd_login_policy_ip_list) && count($orchd_login_policy_ip_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_ip_list when calling deleteOrchdLoginPolicyIpBlacklist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/ip-blacklist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_ip_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_ip_list));
            } else {
                $httpBody = $orchd_login_policy_ip_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteOrchdLoginPolicyIpWhitelist
     *
     * Delete an orchd login policy ip whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteOrchdLoginPolicyIpWhitelist($orchd_login_policy_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyIpWhitelist'][0])
    {
        $this->deleteOrchdLoginPolicyIpWhitelistWithHttpInfo($orchd_login_policy_ip_list, $contentType);
    }

    /**
     * Operation deleteOrchdLoginPolicyIpWhitelistWithHttpInfo
     *
     * Delete an orchd login policy ip whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteOrchdLoginPolicyIpWhitelistWithHttpInfo($orchd_login_policy_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyIpWhitelist'][0])
    {
        $request = $this->deleteOrchdLoginPolicyIpWhitelistRequest($orchd_login_policy_ip_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteOrchdLoginPolicyIpWhitelistAsync
     *
     * Delete an orchd login policy ip whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyIpWhitelistAsync($orchd_login_policy_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyIpWhitelist'][0])
    {
        return $this->deleteOrchdLoginPolicyIpWhitelistAsyncWithHttpInfo($orchd_login_policy_ip_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteOrchdLoginPolicyIpWhitelistAsyncWithHttpInfo
     *
     * Delete an orchd login policy ip whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyIpWhitelistAsyncWithHttpInfo($orchd_login_policy_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyIpWhitelist'][0])
    {
        $returnType = '';
        $request = $this->deleteOrchdLoginPolicyIpWhitelistRequest($orchd_login_policy_ip_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteOrchdLoginPolicyIpWhitelist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteOrchdLoginPolicyIpWhitelistRequest($orchd_login_policy_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyIpWhitelist'][0])
    {

        // verify the required parameter 'orchd_login_policy_ip_list' is set
        if ($orchd_login_policy_ip_list === null || (is_array($orchd_login_policy_ip_list) && count($orchd_login_policy_ip_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_ip_list when calling deleteOrchdLoginPolicyIpWhitelist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/ip-whitelist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_ip_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_ip_list));
            } else {
                $httpBody = $orchd_login_policy_ip_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteOrchdLoginPolicyTemporaryEmailBlacklist
     *
     * Delete an orchd login policy temporary email blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList $orchd_login_policy_temporary_email_list orchd_login_policy_temporary_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyTemporaryEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteOrchdLoginPolicyTemporaryEmailBlacklist($orchd_login_policy_temporary_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyTemporaryEmailBlacklist'][0])
    {
        $this->deleteOrchdLoginPolicyTemporaryEmailBlacklistWithHttpInfo($orchd_login_policy_temporary_email_list, $contentType);
    }

    /**
     * Operation deleteOrchdLoginPolicyTemporaryEmailBlacklistWithHttpInfo
     *
     * Delete an orchd login policy temporary email blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList $orchd_login_policy_temporary_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyTemporaryEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteOrchdLoginPolicyTemporaryEmailBlacklistWithHttpInfo($orchd_login_policy_temporary_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyTemporaryEmailBlacklist'][0])
    {
        $request = $this->deleteOrchdLoginPolicyTemporaryEmailBlacklistRequest($orchd_login_policy_temporary_email_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteOrchdLoginPolicyTemporaryEmailBlacklistAsync
     *
     * Delete an orchd login policy temporary email blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList $orchd_login_policy_temporary_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyTemporaryEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyTemporaryEmailBlacklistAsync($orchd_login_policy_temporary_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyTemporaryEmailBlacklist'][0])
    {
        return $this->deleteOrchdLoginPolicyTemporaryEmailBlacklistAsyncWithHttpInfo($orchd_login_policy_temporary_email_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteOrchdLoginPolicyTemporaryEmailBlacklistAsyncWithHttpInfo
     *
     * Delete an orchd login policy temporary email blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList $orchd_login_policy_temporary_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyTemporaryEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyTemporaryEmailBlacklistAsyncWithHttpInfo($orchd_login_policy_temporary_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyTemporaryEmailBlacklist'][0])
    {
        $returnType = '';
        $request = $this->deleteOrchdLoginPolicyTemporaryEmailBlacklistRequest($orchd_login_policy_temporary_email_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteOrchdLoginPolicyTemporaryEmailBlacklist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList $orchd_login_policy_temporary_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyTemporaryEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteOrchdLoginPolicyTemporaryEmailBlacklistRequest($orchd_login_policy_temporary_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyTemporaryEmailBlacklist'][0])
    {

        // verify the required parameter 'orchd_login_policy_temporary_email_list' is set
        if ($orchd_login_policy_temporary_email_list === null || (is_array($orchd_login_policy_temporary_email_list) && count($orchd_login_policy_temporary_email_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_temporary_email_list when calling deleteOrchdLoginPolicyTemporaryEmailBlacklist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/temporary/email-blacklist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_temporary_email_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_temporary_email_list));
            } else {
                $httpBody = $orchd_login_policy_temporary_email_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteOrchdLoginPolicyTemporaryEmailWhitelist
     *
     * Delete an orchd login policy temporary email whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList $orchd_login_policy_temporary_email_list orchd_login_policy_temporary_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyTemporaryEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteOrchdLoginPolicyTemporaryEmailWhitelist($orchd_login_policy_temporary_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyTemporaryEmailWhitelist'][0])
    {
        $this->deleteOrchdLoginPolicyTemporaryEmailWhitelistWithHttpInfo($orchd_login_policy_temporary_email_list, $contentType);
    }

    /**
     * Operation deleteOrchdLoginPolicyTemporaryEmailWhitelistWithHttpInfo
     *
     * Delete an orchd login policy temporary email whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList $orchd_login_policy_temporary_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyTemporaryEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteOrchdLoginPolicyTemporaryEmailWhitelistWithHttpInfo($orchd_login_policy_temporary_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyTemporaryEmailWhitelist'][0])
    {
        $request = $this->deleteOrchdLoginPolicyTemporaryEmailWhitelistRequest($orchd_login_policy_temporary_email_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteOrchdLoginPolicyTemporaryEmailWhitelistAsync
     *
     * Delete an orchd login policy temporary email whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList $orchd_login_policy_temporary_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyTemporaryEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyTemporaryEmailWhitelistAsync($orchd_login_policy_temporary_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyTemporaryEmailWhitelist'][0])
    {
        return $this->deleteOrchdLoginPolicyTemporaryEmailWhitelistAsyncWithHttpInfo($orchd_login_policy_temporary_email_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteOrchdLoginPolicyTemporaryEmailWhitelistAsyncWithHttpInfo
     *
     * Delete an orchd login policy temporary email whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList $orchd_login_policy_temporary_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyTemporaryEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyTemporaryEmailWhitelistAsyncWithHttpInfo($orchd_login_policy_temporary_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyTemporaryEmailWhitelist'][0])
    {
        $returnType = '';
        $request = $this->deleteOrchdLoginPolicyTemporaryEmailWhitelistRequest($orchd_login_policy_temporary_email_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteOrchdLoginPolicyTemporaryEmailWhitelist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList $orchd_login_policy_temporary_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyTemporaryEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteOrchdLoginPolicyTemporaryEmailWhitelistRequest($orchd_login_policy_temporary_email_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyTemporaryEmailWhitelist'][0])
    {

        // verify the required parameter 'orchd_login_policy_temporary_email_list' is set
        if ($orchd_login_policy_temporary_email_list === null || (is_array($orchd_login_policy_temporary_email_list) && count($orchd_login_policy_temporary_email_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_temporary_email_list when calling deleteOrchdLoginPolicyTemporaryEmailWhitelist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/temporary/email-whitelist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_temporary_email_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_temporary_email_list));
            } else {
                $httpBody = $orchd_login_policy_temporary_email_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteOrchdLoginPolicyTemporaryIpBlacklist
     *
     * Delete an orchd login policy temporary ip blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList $orchd_login_policy_temporary_ip_list orchd_login_policy_temporary_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyTemporaryIpBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteOrchdLoginPolicyTemporaryIpBlacklist($orchd_login_policy_temporary_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyTemporaryIpBlacklist'][0])
    {
        $this->deleteOrchdLoginPolicyTemporaryIpBlacklistWithHttpInfo($orchd_login_policy_temporary_ip_list, $contentType);
    }

    /**
     * Operation deleteOrchdLoginPolicyTemporaryIpBlacklistWithHttpInfo
     *
     * Delete an orchd login policy temporary ip blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList $orchd_login_policy_temporary_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyTemporaryIpBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteOrchdLoginPolicyTemporaryIpBlacklistWithHttpInfo($orchd_login_policy_temporary_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyTemporaryIpBlacklist'][0])
    {
        $request = $this->deleteOrchdLoginPolicyTemporaryIpBlacklistRequest($orchd_login_policy_temporary_ip_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteOrchdLoginPolicyTemporaryIpBlacklistAsync
     *
     * Delete an orchd login policy temporary ip blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList $orchd_login_policy_temporary_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyTemporaryIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyTemporaryIpBlacklistAsync($orchd_login_policy_temporary_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyTemporaryIpBlacklist'][0])
    {
        return $this->deleteOrchdLoginPolicyTemporaryIpBlacklistAsyncWithHttpInfo($orchd_login_policy_temporary_ip_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteOrchdLoginPolicyTemporaryIpBlacklistAsyncWithHttpInfo
     *
     * Delete an orchd login policy temporary ip blacklist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList $orchd_login_policy_temporary_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyTemporaryIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyTemporaryIpBlacklistAsyncWithHttpInfo($orchd_login_policy_temporary_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyTemporaryIpBlacklist'][0])
    {
        $returnType = '';
        $request = $this->deleteOrchdLoginPolicyTemporaryIpBlacklistRequest($orchd_login_policy_temporary_ip_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteOrchdLoginPolicyTemporaryIpBlacklist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList $orchd_login_policy_temporary_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyTemporaryIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteOrchdLoginPolicyTemporaryIpBlacklistRequest($orchd_login_policy_temporary_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyTemporaryIpBlacklist'][0])
    {

        // verify the required parameter 'orchd_login_policy_temporary_ip_list' is set
        if ($orchd_login_policy_temporary_ip_list === null || (is_array($orchd_login_policy_temporary_ip_list) && count($orchd_login_policy_temporary_ip_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_temporary_ip_list when calling deleteOrchdLoginPolicyTemporaryIpBlacklist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/temporary/ip-blacklist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_temporary_ip_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_temporary_ip_list));
            } else {
                $httpBody = $orchd_login_policy_temporary_ip_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteOrchdLoginPolicyTemporaryIpWhitelist
     *
     * Delete an orchd login policy temporary ip whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList $orchd_login_policy_temporary_ip_list orchd_login_policy_temporary_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyTemporaryIpWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteOrchdLoginPolicyTemporaryIpWhitelist($orchd_login_policy_temporary_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyTemporaryIpWhitelist'][0])
    {
        $this->deleteOrchdLoginPolicyTemporaryIpWhitelistWithHttpInfo($orchd_login_policy_temporary_ip_list, $contentType);
    }

    /**
     * Operation deleteOrchdLoginPolicyTemporaryIpWhitelistWithHttpInfo
     *
     * Delete an orchd login policy temporary ip whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList $orchd_login_policy_temporary_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyTemporaryIpWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteOrchdLoginPolicyTemporaryIpWhitelistWithHttpInfo($orchd_login_policy_temporary_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyTemporaryIpWhitelist'][0])
    {
        $request = $this->deleteOrchdLoginPolicyTemporaryIpWhitelistRequest($orchd_login_policy_temporary_ip_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteOrchdLoginPolicyTemporaryIpWhitelistAsync
     *
     * Delete an orchd login policy temporary ip whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList $orchd_login_policy_temporary_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyTemporaryIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyTemporaryIpWhitelistAsync($orchd_login_policy_temporary_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyTemporaryIpWhitelist'][0])
    {
        return $this->deleteOrchdLoginPolicyTemporaryIpWhitelistAsyncWithHttpInfo($orchd_login_policy_temporary_ip_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteOrchdLoginPolicyTemporaryIpWhitelistAsyncWithHttpInfo
     *
     * Delete an orchd login policy temporary ip whitelist
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList $orchd_login_policy_temporary_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyTemporaryIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteOrchdLoginPolicyTemporaryIpWhitelistAsyncWithHttpInfo($orchd_login_policy_temporary_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyTemporaryIpWhitelist'][0])
    {
        $returnType = '';
        $request = $this->deleteOrchdLoginPolicyTemporaryIpWhitelistRequest($orchd_login_policy_temporary_ip_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteOrchdLoginPolicyTemporaryIpWhitelist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList $orchd_login_policy_temporary_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteOrchdLoginPolicyTemporaryIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteOrchdLoginPolicyTemporaryIpWhitelistRequest($orchd_login_policy_temporary_ip_list, string $contentType = self::contentTypes['deleteOrchdLoginPolicyTemporaryIpWhitelist'][0])
    {

        // verify the required parameter 'orchd_login_policy_temporary_ip_list' is set
        if ($orchd_login_policy_temporary_ip_list === null || (is_array($orchd_login_policy_temporary_ip_list) && count($orchd_login_policy_temporary_ip_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_temporary_ip_list when calling deleteOrchdLoginPolicyTemporaryIpWhitelist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/temporary/ip-whitelist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_temporary_ip_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_temporary_ip_list));
            } else {
                $httpBody = $orchd_login_policy_temporary_ip_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteSetting
     *
     * Remove the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteSetting($name, string $contentType = self::contentTypes['deleteSetting'][0])
    {
        $this->deleteSettingWithHttpInfo($name, $contentType);
    }

    /**
     * Operation deleteSettingWithHttpInfo
     *
     * Remove the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSettingWithHttpInfo($name, string $contentType = self::contentTypes['deleteSetting'][0])
    {
        $request = $this->deleteSettingRequest($name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteSettingAsync
     *
     * Remove the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSettingAsync($name, string $contentType = self::contentTypes['deleteSetting'][0])
    {
        return $this->deleteSettingAsyncWithHttpInfo($name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSettingAsyncWithHttpInfo
     *
     * Remove the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSettingAsyncWithHttpInfo($name, string $contentType = self::contentTypes['deleteSetting'][0])
    {
        $returnType = '';
        $request = $this->deleteSettingRequest($name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSetting'
     *
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSettingRequest($name, string $contentType = self::contentTypes['deleteSetting'][0])
    {

        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling deleteSetting'
            );
        }


        $resourcePath = '/settings/{name}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                '{' . 'name' . '}',
                ObjectSerializer::toPathValue($name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getDockerRegistry
     *
     * Gets the Docker registry credentials.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDockerRegistry'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\DockerRegistry
     */
    public function getDockerRegistry(string $contentType = self::contentTypes['getDockerRegistry'][0])
    {
        list($response) = $this->getDockerRegistryWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getDockerRegistryWithHttpInfo
     *
     * Gets the Docker registry credentials.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDockerRegistry'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\DockerRegistry, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDockerRegistryWithHttpInfo(string $contentType = self::contentTypes['getDockerRegistry'][0])
    {
        $request = $this->getDockerRegistryRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\DockerRegistry' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\DockerRegistry' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\DockerRegistry', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\DockerRegistry';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\DockerRegistry',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getDockerRegistryAsync
     *
     * Gets the Docker registry credentials.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDockerRegistry'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDockerRegistryAsync(string $contentType = self::contentTypes['getDockerRegistry'][0])
    {
        return $this->getDockerRegistryAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getDockerRegistryAsyncWithHttpInfo
     *
     * Gets the Docker registry credentials.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDockerRegistry'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDockerRegistryAsyncWithHttpInfo(string $contentType = self::contentTypes['getDockerRegistry'][0])
    {
        $returnType = '\OpenAPI\Client\Model\DockerRegistry';
        $request = $this->getDockerRegistryRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getDockerRegistry'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDockerRegistry'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getDockerRegistryRequest(string $contentType = self::contentTypes['getDockerRegistry'][0])
    {


        $resourcePath = '/settings/registry';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getGlobalServiceSetting
     *
     * Get the value for a particular global service setting
     *
     * @param  SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return mixed
     */
    public function getGlobalServiceSetting($setting_kind, string $contentType = self::contentTypes['getGlobalServiceSetting'][0])
    {
        list($response) = $this->getGlobalServiceSettingWithHttpInfo($setting_kind, $contentType);
        return $response;
    }

    /**
     * Operation getGlobalServiceSettingWithHttpInfo
     *
     * Get the value for a particular global service setting
     *
     * @param  SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of mixed, HTTP status code, HTTP response headers (array of strings)
     */
    public function getGlobalServiceSettingWithHttpInfo($setting_kind, string $contentType = self::contentTypes['getGlobalServiceSetting'][0])
    {
        $request = $this->getGlobalServiceSettingRequest($setting_kind, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('mixed' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('mixed' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'mixed', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'mixed';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'mixed',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getGlobalServiceSettingAsync
     *
     * Get the value for a particular global service setting
     *
     * @param  SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGlobalServiceSettingAsync($setting_kind, string $contentType = self::contentTypes['getGlobalServiceSetting'][0])
    {
        return $this->getGlobalServiceSettingAsyncWithHttpInfo($setting_kind, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getGlobalServiceSettingAsyncWithHttpInfo
     *
     * Get the value for a particular global service setting
     *
     * @param  SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getGlobalServiceSettingAsyncWithHttpInfo($setting_kind, string $contentType = self::contentTypes['getGlobalServiceSetting'][0])
    {
        $returnType = 'mixed';
        $request = $this->getGlobalServiceSettingRequest($setting_kind, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getGlobalServiceSetting'
     *
     * @param  SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getGlobalServiceSettingRequest($setting_kind, string $contentType = self::contentTypes['getGlobalServiceSetting'][0])
    {

        // verify the required parameter 'setting_kind' is set
        if ($setting_kind === null || (is_array($setting_kind) && count($setting_kind) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $setting_kind when calling getGlobalServiceSetting'
            );
        }


        $resourcePath = '/settings/service/{setting_kind}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($setting_kind !== null) {
            $resourcePath = str_replace(
                '{' . 'setting_kind' . '}',
                ObjectSerializer::toPathValue($setting_kind),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrchdLogSettings
     *
     * Get the orchd log settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLogSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\OrchdLogSettings
     */
    public function getOrchdLogSettings(string $contentType = self::contentTypes['getOrchdLogSettings'][0])
    {
        list($response) = $this->getOrchdLogSettingsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getOrchdLogSettingsWithHttpInfo
     *
     * Get the orchd log settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLogSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\OrchdLogSettings, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrchdLogSettingsWithHttpInfo(string $contentType = self::contentTypes['getOrchdLogSettings'][0])
    {
        $request = $this->getOrchdLogSettingsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\OrchdLogSettings' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\OrchdLogSettings' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\OrchdLogSettings', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\OrchdLogSettings';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\OrchdLogSettings',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrchdLogSettingsAsync
     *
     * Get the orchd log settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLogSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLogSettingsAsync(string $contentType = self::contentTypes['getOrchdLogSettings'][0])
    {
        return $this->getOrchdLogSettingsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrchdLogSettingsAsyncWithHttpInfo
     *
     * Get the orchd log settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLogSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLogSettingsAsyncWithHttpInfo(string $contentType = self::contentTypes['getOrchdLogSettings'][0])
    {
        $returnType = '\OpenAPI\Client\Model\OrchdLogSettings';
        $request = $this->getOrchdLogSettingsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrchdLogSettings'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLogSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrchdLogSettingsRequest(string $contentType = self::contentTypes['getOrchdLogSettings'][0])
    {


        $resourcePath = '/settings/orchd/logs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrchdLoginPolicyEmailBlacklist
     *
     * Get the orchd login policy email blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\OrchdLoginPolicyEmailList
     */
    public function getOrchdLoginPolicyEmailBlacklist(string $contentType = self::contentTypes['getOrchdLoginPolicyEmailBlacklist'][0])
    {
        list($response) = $this->getOrchdLoginPolicyEmailBlacklistWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getOrchdLoginPolicyEmailBlacklistWithHttpInfo
     *
     * Get the orchd login policy email blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\OrchdLoginPolicyEmailList, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrchdLoginPolicyEmailBlacklistWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyEmailBlacklist'][0])
    {
        $request = $this->getOrchdLoginPolicyEmailBlacklistRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\OrchdLoginPolicyEmailList' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\OrchdLoginPolicyEmailList' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\OrchdLoginPolicyEmailList', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\OrchdLoginPolicyEmailList';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\OrchdLoginPolicyEmailList',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrchdLoginPolicyEmailBlacklistAsync
     *
     * Get the orchd login policy email blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyEmailBlacklistAsync(string $contentType = self::contentTypes['getOrchdLoginPolicyEmailBlacklist'][0])
    {
        return $this->getOrchdLoginPolicyEmailBlacklistAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrchdLoginPolicyEmailBlacklistAsyncWithHttpInfo
     *
     * Get the orchd login policy email blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyEmailBlacklistAsyncWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyEmailBlacklist'][0])
    {
        $returnType = '\OpenAPI\Client\Model\OrchdLoginPolicyEmailList';
        $request = $this->getOrchdLoginPolicyEmailBlacklistRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrchdLoginPolicyEmailBlacklist'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrchdLoginPolicyEmailBlacklistRequest(string $contentType = self::contentTypes['getOrchdLoginPolicyEmailBlacklist'][0])
    {


        $resourcePath = '/settings/orchd/login-policy/email-blacklist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrchdLoginPolicyEmailWhitelist
     *
     * Get the orchd login policy email whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\OrchdLoginPolicyEmailList
     */
    public function getOrchdLoginPolicyEmailWhitelist(string $contentType = self::contentTypes['getOrchdLoginPolicyEmailWhitelist'][0])
    {
        list($response) = $this->getOrchdLoginPolicyEmailWhitelistWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getOrchdLoginPolicyEmailWhitelistWithHttpInfo
     *
     * Get the orchd login policy email whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\OrchdLoginPolicyEmailList, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrchdLoginPolicyEmailWhitelistWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyEmailWhitelist'][0])
    {
        $request = $this->getOrchdLoginPolicyEmailWhitelistRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\OrchdLoginPolicyEmailList' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\OrchdLoginPolicyEmailList' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\OrchdLoginPolicyEmailList', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\OrchdLoginPolicyEmailList';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\OrchdLoginPolicyEmailList',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrchdLoginPolicyEmailWhitelistAsync
     *
     * Get the orchd login policy email whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyEmailWhitelistAsync(string $contentType = self::contentTypes['getOrchdLoginPolicyEmailWhitelist'][0])
    {
        return $this->getOrchdLoginPolicyEmailWhitelistAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrchdLoginPolicyEmailWhitelistAsyncWithHttpInfo
     *
     * Get the orchd login policy email whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyEmailWhitelistAsyncWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyEmailWhitelist'][0])
    {
        $returnType = '\OpenAPI\Client\Model\OrchdLoginPolicyEmailList';
        $request = $this->getOrchdLoginPolicyEmailWhitelistRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrchdLoginPolicyEmailWhitelist'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrchdLoginPolicyEmailWhitelistRequest(string $contentType = self::contentTypes['getOrchdLoginPolicyEmailWhitelist'][0])
    {


        $resourcePath = '/settings/orchd/login-policy/email-whitelist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrchdLoginPolicyIpBlacklist
     *
     * Get the orchd login policy ip blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\OrchdLoginPolicyIpList
     */
    public function getOrchdLoginPolicyIpBlacklist(string $contentType = self::contentTypes['getOrchdLoginPolicyIpBlacklist'][0])
    {
        list($response) = $this->getOrchdLoginPolicyIpBlacklistWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getOrchdLoginPolicyIpBlacklistWithHttpInfo
     *
     * Get the orchd login policy ip blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\OrchdLoginPolicyIpList, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrchdLoginPolicyIpBlacklistWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyIpBlacklist'][0])
    {
        $request = $this->getOrchdLoginPolicyIpBlacklistRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\OrchdLoginPolicyIpList' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\OrchdLoginPolicyIpList' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\OrchdLoginPolicyIpList', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\OrchdLoginPolicyIpList';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\OrchdLoginPolicyIpList',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrchdLoginPolicyIpBlacklistAsync
     *
     * Get the orchd login policy ip blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyIpBlacklistAsync(string $contentType = self::contentTypes['getOrchdLoginPolicyIpBlacklist'][0])
    {
        return $this->getOrchdLoginPolicyIpBlacklistAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrchdLoginPolicyIpBlacklistAsyncWithHttpInfo
     *
     * Get the orchd login policy ip blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyIpBlacklistAsyncWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyIpBlacklist'][0])
    {
        $returnType = '\OpenAPI\Client\Model\OrchdLoginPolicyIpList';
        $request = $this->getOrchdLoginPolicyIpBlacklistRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrchdLoginPolicyIpBlacklist'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrchdLoginPolicyIpBlacklistRequest(string $contentType = self::contentTypes['getOrchdLoginPolicyIpBlacklist'][0])
    {


        $resourcePath = '/settings/orchd/login-policy/ip-blacklist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrchdLoginPolicyIpWhitelist
     *
     * Get the orchd login policy ip whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\OrchdLoginPolicyIpList
     */
    public function getOrchdLoginPolicyIpWhitelist(string $contentType = self::contentTypes['getOrchdLoginPolicyIpWhitelist'][0])
    {
        list($response) = $this->getOrchdLoginPolicyIpWhitelistWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getOrchdLoginPolicyIpWhitelistWithHttpInfo
     *
     * Get the orchd login policy ip whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\OrchdLoginPolicyIpList, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrchdLoginPolicyIpWhitelistWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyIpWhitelist'][0])
    {
        $request = $this->getOrchdLoginPolicyIpWhitelistRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\OrchdLoginPolicyIpList' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\OrchdLoginPolicyIpList' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\OrchdLoginPolicyIpList', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\OrchdLoginPolicyIpList';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\OrchdLoginPolicyIpList',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrchdLoginPolicyIpWhitelistAsync
     *
     * Get the orchd login policy ip whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyIpWhitelistAsync(string $contentType = self::contentTypes['getOrchdLoginPolicyIpWhitelist'][0])
    {
        return $this->getOrchdLoginPolicyIpWhitelistAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrchdLoginPolicyIpWhitelistAsyncWithHttpInfo
     *
     * Get the orchd login policy ip whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyIpWhitelistAsyncWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyIpWhitelist'][0])
    {
        $returnType = '\OpenAPI\Client\Model\OrchdLoginPolicyIpList';
        $request = $this->getOrchdLoginPolicyIpWhitelistRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrchdLoginPolicyIpWhitelist'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrchdLoginPolicyIpWhitelistRequest(string $contentType = self::contentTypes['getOrchdLoginPolicyIpWhitelist'][0])
    {


        $resourcePath = '/settings/orchd/login-policy/ip-whitelist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrchdLoginPolicySettings
     *
     * Get the orchd login policy settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicySettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\OrchdLoginPolicySettings
     */
    public function getOrchdLoginPolicySettings(string $contentType = self::contentTypes['getOrchdLoginPolicySettings'][0])
    {
        list($response) = $this->getOrchdLoginPolicySettingsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getOrchdLoginPolicySettingsWithHttpInfo
     *
     * Get the orchd login policy settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicySettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\OrchdLoginPolicySettings, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrchdLoginPolicySettingsWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicySettings'][0])
    {
        $request = $this->getOrchdLoginPolicySettingsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\OrchdLoginPolicySettings' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\OrchdLoginPolicySettings' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\OrchdLoginPolicySettings', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\OrchdLoginPolicySettings';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\OrchdLoginPolicySettings',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrchdLoginPolicySettingsAsync
     *
     * Get the orchd login policy settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicySettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicySettingsAsync(string $contentType = self::contentTypes['getOrchdLoginPolicySettings'][0])
    {
        return $this->getOrchdLoginPolicySettingsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrchdLoginPolicySettingsAsyncWithHttpInfo
     *
     * Get the orchd login policy settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicySettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicySettingsAsyncWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicySettings'][0])
    {
        $returnType = '\OpenAPI\Client\Model\OrchdLoginPolicySettings';
        $request = $this->getOrchdLoginPolicySettingsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrchdLoginPolicySettings'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicySettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrchdLoginPolicySettingsRequest(string $contentType = self::contentTypes['getOrchdLoginPolicySettings'][0])
    {


        $resourcePath = '/settings/orchd/login-policy/settings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrchdLoginPolicyTemporaryEmailBlacklist
     *
     * Get the orchd login policy temporary email blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyTemporaryEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList
     */
    public function getOrchdLoginPolicyTemporaryEmailBlacklist(string $contentType = self::contentTypes['getOrchdLoginPolicyTemporaryEmailBlacklist'][0])
    {
        list($response) = $this->getOrchdLoginPolicyTemporaryEmailBlacklistWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getOrchdLoginPolicyTemporaryEmailBlacklistWithHttpInfo
     *
     * Get the orchd login policy temporary email blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyTemporaryEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrchdLoginPolicyTemporaryEmailBlacklistWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyTemporaryEmailBlacklist'][0])
    {
        $request = $this->getOrchdLoginPolicyTemporaryEmailBlacklistRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrchdLoginPolicyTemporaryEmailBlacklistAsync
     *
     * Get the orchd login policy temporary email blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyTemporaryEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyTemporaryEmailBlacklistAsync(string $contentType = self::contentTypes['getOrchdLoginPolicyTemporaryEmailBlacklist'][0])
    {
        return $this->getOrchdLoginPolicyTemporaryEmailBlacklistAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrchdLoginPolicyTemporaryEmailBlacklistAsyncWithHttpInfo
     *
     * Get the orchd login policy temporary email blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyTemporaryEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyTemporaryEmailBlacklistAsyncWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyTemporaryEmailBlacklist'][0])
    {
        $returnType = '\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList';
        $request = $this->getOrchdLoginPolicyTemporaryEmailBlacklistRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrchdLoginPolicyTemporaryEmailBlacklist'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyTemporaryEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrchdLoginPolicyTemporaryEmailBlacklistRequest(string $contentType = self::contentTypes['getOrchdLoginPolicyTemporaryEmailBlacklist'][0])
    {


        $resourcePath = '/settings/orchd/login-policy/temporary/email-blacklist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrchdLoginPolicyTemporaryEmailWhitelist
     *
     * Get the orchd login policy temporary email whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyTemporaryEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList
     */
    public function getOrchdLoginPolicyTemporaryEmailWhitelist(string $contentType = self::contentTypes['getOrchdLoginPolicyTemporaryEmailWhitelist'][0])
    {
        list($response) = $this->getOrchdLoginPolicyTemporaryEmailWhitelistWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getOrchdLoginPolicyTemporaryEmailWhitelistWithHttpInfo
     *
     * Get the orchd login policy temporary email whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyTemporaryEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrchdLoginPolicyTemporaryEmailWhitelistWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyTemporaryEmailWhitelist'][0])
    {
        $request = $this->getOrchdLoginPolicyTemporaryEmailWhitelistRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrchdLoginPolicyTemporaryEmailWhitelistAsync
     *
     * Get the orchd login policy temporary email whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyTemporaryEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyTemporaryEmailWhitelistAsync(string $contentType = self::contentTypes['getOrchdLoginPolicyTemporaryEmailWhitelist'][0])
    {
        return $this->getOrchdLoginPolicyTemporaryEmailWhitelistAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrchdLoginPolicyTemporaryEmailWhitelistAsyncWithHttpInfo
     *
     * Get the orchd login policy temporary email whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyTemporaryEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyTemporaryEmailWhitelistAsyncWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyTemporaryEmailWhitelist'][0])
    {
        $returnType = '\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList';
        $request = $this->getOrchdLoginPolicyTemporaryEmailWhitelistRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrchdLoginPolicyTemporaryEmailWhitelist'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyTemporaryEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrchdLoginPolicyTemporaryEmailWhitelistRequest(string $contentType = self::contentTypes['getOrchdLoginPolicyTemporaryEmailWhitelist'][0])
    {


        $resourcePath = '/settings/orchd/login-policy/temporary/email-whitelist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrchdLoginPolicyTemporaryIpBlacklist
     *
     * Get the orchd login policy temporary ip blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyTemporaryIpBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList
     */
    public function getOrchdLoginPolicyTemporaryIpBlacklist(string $contentType = self::contentTypes['getOrchdLoginPolicyTemporaryIpBlacklist'][0])
    {
        list($response) = $this->getOrchdLoginPolicyTemporaryIpBlacklistWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getOrchdLoginPolicyTemporaryIpBlacklistWithHttpInfo
     *
     * Get the orchd login policy temporary ip blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyTemporaryIpBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrchdLoginPolicyTemporaryIpBlacklistWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyTemporaryIpBlacklist'][0])
    {
        $request = $this->getOrchdLoginPolicyTemporaryIpBlacklistRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrchdLoginPolicyTemporaryIpBlacklistAsync
     *
     * Get the orchd login policy temporary ip blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyTemporaryIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyTemporaryIpBlacklistAsync(string $contentType = self::contentTypes['getOrchdLoginPolicyTemporaryIpBlacklist'][0])
    {
        return $this->getOrchdLoginPolicyTemporaryIpBlacklistAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrchdLoginPolicyTemporaryIpBlacklistAsyncWithHttpInfo
     *
     * Get the orchd login policy temporary ip blacklist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyTemporaryIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyTemporaryIpBlacklistAsyncWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyTemporaryIpBlacklist'][0])
    {
        $returnType = '\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList';
        $request = $this->getOrchdLoginPolicyTemporaryIpBlacklistRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrchdLoginPolicyTemporaryIpBlacklist'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyTemporaryIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrchdLoginPolicyTemporaryIpBlacklistRequest(string $contentType = self::contentTypes['getOrchdLoginPolicyTemporaryIpBlacklist'][0])
    {


        $resourcePath = '/settings/orchd/login-policy/temporary/ip-blacklist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrchdLoginPolicyTemporaryIpWhitelist
     *
     * Get the orchd login policy temporary ip whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyTemporaryIpWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList
     */
    public function getOrchdLoginPolicyTemporaryIpWhitelist(string $contentType = self::contentTypes['getOrchdLoginPolicyTemporaryIpWhitelist'][0])
    {
        list($response) = $this->getOrchdLoginPolicyTemporaryIpWhitelistWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getOrchdLoginPolicyTemporaryIpWhitelistWithHttpInfo
     *
     * Get the orchd login policy temporary ip whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyTemporaryIpWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrchdLoginPolicyTemporaryIpWhitelistWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyTemporaryIpWhitelist'][0])
    {
        $request = $this->getOrchdLoginPolicyTemporaryIpWhitelistRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrchdLoginPolicyTemporaryIpWhitelistAsync
     *
     * Get the orchd login policy temporary ip whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyTemporaryIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyTemporaryIpWhitelistAsync(string $contentType = self::contentTypes['getOrchdLoginPolicyTemporaryIpWhitelist'][0])
    {
        return $this->getOrchdLoginPolicyTemporaryIpWhitelistAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrchdLoginPolicyTemporaryIpWhitelistAsyncWithHttpInfo
     *
     * Get the orchd login policy temporary ip whitelist
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyTemporaryIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrchdLoginPolicyTemporaryIpWhitelistAsyncWithHttpInfo(string $contentType = self::contentTypes['getOrchdLoginPolicyTemporaryIpWhitelist'][0])
    {
        $returnType = '\OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList';
        $request = $this->getOrchdLoginPolicyTemporaryIpWhitelistRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrchdLoginPolicyTemporaryIpWhitelist'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrchdLoginPolicyTemporaryIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrchdLoginPolicyTemporaryIpWhitelistRequest(string $contentType = self::contentTypes['getOrchdLoginPolicyTemporaryIpWhitelist'][0])
    {


        $resourcePath = '/settings/orchd/login-policy/temporary/ip-whitelist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSetting
     *
     * Get the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Setting
     */
    public function getSetting($name, string $contentType = self::contentTypes['getSetting'][0])
    {
        list($response) = $this->getSettingWithHttpInfo($name, $contentType);
        return $response;
    }

    /**
     * Operation getSettingWithHttpInfo
     *
     * Get the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Setting, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSettingWithHttpInfo($name, string $contentType = self::contentTypes['getSetting'][0])
    {
        $request = $this->getSettingRequest($name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\Setting' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\Setting' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\Setting', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\Setting';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Setting',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSettingAsync
     *
     * Get the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSettingAsync($name, string $contentType = self::contentTypes['getSetting'][0])
    {
        return $this->getSettingAsyncWithHttpInfo($name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSettingAsyncWithHttpInfo
     *
     * Get the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSettingAsyncWithHttpInfo($name, string $contentType = self::contentTypes['getSetting'][0])
    {
        $returnType = '\OpenAPI\Client\Model\Setting';
        $request = $this->getSettingRequest($name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSetting'
     *
     * @param  string $name The name of the resource. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSettingRequest($name, string $contentType = self::contentTypes['getSetting'][0])
    {

        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling getSetting'
            );
        }


        $resourcePath = '/settings/{name}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                '{' . 'name' . '}',
                ObjectSerializer::toPathValue($name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSettings
     *
     * Get all current settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\SettingsFullListing
     */
    public function getSettings(string $contentType = self::contentTypes['getSettings'][0])
    {
        list($response) = $this->getSettingsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getSettingsWithHttpInfo
     *
     * Get all current settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\SettingsFullListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSettingsWithHttpInfo(string $contentType = self::contentTypes['getSettings'][0])
    {
        $request = $this->getSettingsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\SettingsFullListing' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\SettingsFullListing' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\SettingsFullListing', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\SettingsFullListing';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\SettingsFullListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSettingsAsync
     *
     * Get all current settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSettingsAsync(string $contentType = self::contentTypes['getSettings'][0])
    {
        return $this->getSettingsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSettingsAsyncWithHttpInfo
     *
     * Get all current settings
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSettingsAsyncWithHttpInfo(string $contentType = self::contentTypes['getSettings'][0])
    {
        $returnType = '\OpenAPI\Client\Model\SettingsFullListing';
        $request = $this->getSettingsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSettings'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSettingsRequest(string $contentType = self::contentTypes['getSettings'][0])
    {


        $resourcePath = '/settings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setDockerRegistry
     *
     * Updates the Docker registry credentials.
     *
     * @param  \OpenAPI\Client\Model\DockerRegistry $docker_registry docker_registry (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setDockerRegistry'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setDockerRegistry($docker_registry = null, string $contentType = self::contentTypes['setDockerRegistry'][0])
    {
        $this->setDockerRegistryWithHttpInfo($docker_registry, $contentType);
    }

    /**
     * Operation setDockerRegistryWithHttpInfo
     *
     * Updates the Docker registry credentials.
     *
     * @param  \OpenAPI\Client\Model\DockerRegistry $docker_registry (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setDockerRegistry'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setDockerRegistryWithHttpInfo($docker_registry = null, string $contentType = self::contentTypes['setDockerRegistry'][0])
    {
        $request = $this->setDockerRegistryRequest($docker_registry, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation setDockerRegistryAsync
     *
     * Updates the Docker registry credentials.
     *
     * @param  \OpenAPI\Client\Model\DockerRegistry $docker_registry (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setDockerRegistry'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setDockerRegistryAsync($docker_registry = null, string $contentType = self::contentTypes['setDockerRegistry'][0])
    {
        return $this->setDockerRegistryAsyncWithHttpInfo($docker_registry, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setDockerRegistryAsyncWithHttpInfo
     *
     * Updates the Docker registry credentials.
     *
     * @param  \OpenAPI\Client\Model\DockerRegistry $docker_registry (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setDockerRegistry'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setDockerRegistryAsyncWithHttpInfo($docker_registry = null, string $contentType = self::contentTypes['setDockerRegistry'][0])
    {
        $returnType = '';
        $request = $this->setDockerRegistryRequest($docker_registry, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setDockerRegistry'
     *
     * @param  \OpenAPI\Client\Model\DockerRegistry $docker_registry (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setDockerRegistry'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setDockerRegistryRequest($docker_registry = null, string $contentType = self::contentTypes['setDockerRegistry'][0])
    {



        $resourcePath = '/settings/registry';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($docker_registry)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($docker_registry));
            } else {
                $httpBody = $docker_registry;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setGlobalServiceSetting
     *
     * Set a single global service setting
     *
     * @param  SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $setting_key A key for updating an existing setting, some known values are - hard_delete_after_secs - letsencrypt_enabled - myhostname - org_websites_same_server - screenshot_driver_pool_size - screenshot_interval - sged_smtp - smtp_smart_host - website_backup (required)
     * @param  \OpenAPI\Client\Model\ServiceSettingValue $service_setting_value service_setting_value (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Outcome|\OpenAPI\Client\Model\Outcome
     */
    public function setGlobalServiceSetting($setting_kind, $setting_key, $service_setting_value, string $contentType = self::contentTypes['setGlobalServiceSetting'][0])
    {
        list($response) = $this->setGlobalServiceSettingWithHttpInfo($setting_kind, $setting_key, $service_setting_value, $contentType);
        return $response;
    }

    /**
     * Operation setGlobalServiceSettingWithHttpInfo
     *
     * Set a single global service setting
     *
     * @param  SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $setting_key A key for updating an existing setting, some known values are - hard_delete_after_secs - letsencrypt_enabled - myhostname - org_websites_same_server - screenshot_driver_pool_size - screenshot_interval - sged_smtp - smtp_smart_host - website_backup (required)
     * @param  \OpenAPI\Client\Model\ServiceSettingValue $service_setting_value (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Outcome|\OpenAPI\Client\Model\Outcome, HTTP status code, HTTP response headers (array of strings)
     */
    public function setGlobalServiceSettingWithHttpInfo($setting_kind, $setting_key, $service_setting_value, string $contentType = self::contentTypes['setGlobalServiceSetting'][0])
    {
        $request = $this->setGlobalServiceSettingRequest($setting_kind, $setting_key, $service_setting_value, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\Outcome' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\Outcome' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\Outcome', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 202:
                    if ('\OpenAPI\Client\Model\Outcome' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\Outcome' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\Outcome', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\Outcome';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Outcome',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 202:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Outcome',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation setGlobalServiceSettingAsync
     *
     * Set a single global service setting
     *
     * @param  SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $setting_key A key for updating an existing setting, some known values are - hard_delete_after_secs - letsencrypt_enabled - myhostname - org_websites_same_server - screenshot_driver_pool_size - screenshot_interval - sged_smtp - smtp_smart_host - website_backup (required)
     * @param  \OpenAPI\Client\Model\ServiceSettingValue $service_setting_value (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setGlobalServiceSettingAsync($setting_kind, $setting_key, $service_setting_value, string $contentType = self::contentTypes['setGlobalServiceSetting'][0])
    {
        return $this->setGlobalServiceSettingAsyncWithHttpInfo($setting_kind, $setting_key, $service_setting_value, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setGlobalServiceSettingAsyncWithHttpInfo
     *
     * Set a single global service setting
     *
     * @param  SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $setting_key A key for updating an existing setting, some known values are - hard_delete_after_secs - letsencrypt_enabled - myhostname - org_websites_same_server - screenshot_driver_pool_size - screenshot_interval - sged_smtp - smtp_smart_host - website_backup (required)
     * @param  \OpenAPI\Client\Model\ServiceSettingValue $service_setting_value (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setGlobalServiceSettingAsyncWithHttpInfo($setting_kind, $setting_key, $service_setting_value, string $contentType = self::contentTypes['setGlobalServiceSetting'][0])
    {
        $returnType = '\OpenAPI\Client\Model\Outcome';
        $request = $this->setGlobalServiceSettingRequest($setting_kind, $setting_key, $service_setting_value, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setGlobalServiceSetting'
     *
     * @param  SettingKind $setting_kind The type of setting being applied (required)
     * @param  string $setting_key A key for updating an existing setting, some known values are - hard_delete_after_secs - letsencrypt_enabled - myhostname - org_websites_same_server - screenshot_driver_pool_size - screenshot_interval - sged_smtp - smtp_smart_host - website_backup (required)
     * @param  \OpenAPI\Client\Model\ServiceSettingValue $service_setting_value (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setGlobalServiceSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setGlobalServiceSettingRequest($setting_kind, $setting_key, $service_setting_value, string $contentType = self::contentTypes['setGlobalServiceSetting'][0])
    {

        // verify the required parameter 'setting_kind' is set
        if ($setting_kind === null || (is_array($setting_kind) && count($setting_kind) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $setting_kind when calling setGlobalServiceSetting'
            );
        }

        // verify the required parameter 'setting_key' is set
        if ($setting_key === null || (is_array($setting_key) && count($setting_key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $setting_key when calling setGlobalServiceSetting'
            );
        }

        // verify the required parameter 'service_setting_value' is set
        if ($service_setting_value === null || (is_array($service_setting_value) && count($service_setting_value) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $service_setting_value when calling setGlobalServiceSetting'
            );
        }


        $resourcePath = '/settings/service/{setting_kind}/{setting_key}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($setting_kind !== null) {
            $resourcePath = str_replace(
                '{' . 'setting_kind' . '}',
                ObjectSerializer::toPathValue($setting_kind),
                $resourcePath
            );
        }
        // path params
        if ($setting_key !== null) {
            $resourcePath = str_replace(
                '{' . 'setting_key' . '}',
                ObjectSerializer::toPathValue($setting_key),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($service_setting_value)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($service_setting_value));
            } else {
                $httpBody = $service_setting_value;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setOrchdLogSettings
     *
     * Set the orchd log settings
     *
     * @param  \OpenAPI\Client\Model\OrchdLogSettings $orchd_log_settings orchd_log_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLogSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setOrchdLogSettings($orchd_log_settings, string $contentType = self::contentTypes['setOrchdLogSettings'][0])
    {
        $this->setOrchdLogSettingsWithHttpInfo($orchd_log_settings, $contentType);
    }

    /**
     * Operation setOrchdLogSettingsWithHttpInfo
     *
     * Set the orchd log settings
     *
     * @param  \OpenAPI\Client\Model\OrchdLogSettings $orchd_log_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLogSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setOrchdLogSettingsWithHttpInfo($orchd_log_settings, string $contentType = self::contentTypes['setOrchdLogSettings'][0])
    {
        $request = $this->setOrchdLogSettingsRequest($orchd_log_settings, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation setOrchdLogSettingsAsync
     *
     * Set the orchd log settings
     *
     * @param  \OpenAPI\Client\Model\OrchdLogSettings $orchd_log_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLogSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setOrchdLogSettingsAsync($orchd_log_settings, string $contentType = self::contentTypes['setOrchdLogSettings'][0])
    {
        return $this->setOrchdLogSettingsAsyncWithHttpInfo($orchd_log_settings, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setOrchdLogSettingsAsyncWithHttpInfo
     *
     * Set the orchd log settings
     *
     * @param  \OpenAPI\Client\Model\OrchdLogSettings $orchd_log_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLogSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setOrchdLogSettingsAsyncWithHttpInfo($orchd_log_settings, string $contentType = self::contentTypes['setOrchdLogSettings'][0])
    {
        $returnType = '';
        $request = $this->setOrchdLogSettingsRequest($orchd_log_settings, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setOrchdLogSettings'
     *
     * @param  \OpenAPI\Client\Model\OrchdLogSettings $orchd_log_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLogSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setOrchdLogSettingsRequest($orchd_log_settings, string $contentType = self::contentTypes['setOrchdLogSettings'][0])
    {

        // verify the required parameter 'orchd_log_settings' is set
        if ($orchd_log_settings === null || (is_array($orchd_log_settings) && count($orchd_log_settings) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_log_settings when calling setOrchdLogSettings'
            );
        }


        $resourcePath = '/settings/orchd/logs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_log_settings)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_log_settings));
            } else {
                $httpBody = $orchd_log_settings;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setOrchdLoginPolicyEmailBlacklist
     *
     * Set the orchd login policy email blacklist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setOrchdLoginPolicyEmailBlacklist($orchd_login_policy_email_list, string $contentType = self::contentTypes['setOrchdLoginPolicyEmailBlacklist'][0])
    {
        $this->setOrchdLoginPolicyEmailBlacklistWithHttpInfo($orchd_login_policy_email_list, $contentType);
    }

    /**
     * Operation setOrchdLoginPolicyEmailBlacklistWithHttpInfo
     *
     * Set the orchd login policy email blacklist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setOrchdLoginPolicyEmailBlacklistWithHttpInfo($orchd_login_policy_email_list, string $contentType = self::contentTypes['setOrchdLoginPolicyEmailBlacklist'][0])
    {
        $request = $this->setOrchdLoginPolicyEmailBlacklistRequest($orchd_login_policy_email_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation setOrchdLoginPolicyEmailBlacklistAsync
     *
     * Set the orchd login policy email blacklist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setOrchdLoginPolicyEmailBlacklistAsync($orchd_login_policy_email_list, string $contentType = self::contentTypes['setOrchdLoginPolicyEmailBlacklist'][0])
    {
        return $this->setOrchdLoginPolicyEmailBlacklistAsyncWithHttpInfo($orchd_login_policy_email_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setOrchdLoginPolicyEmailBlacklistAsyncWithHttpInfo
     *
     * Set the orchd login policy email blacklist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setOrchdLoginPolicyEmailBlacklistAsyncWithHttpInfo($orchd_login_policy_email_list, string $contentType = self::contentTypes['setOrchdLoginPolicyEmailBlacklist'][0])
    {
        $returnType = '';
        $request = $this->setOrchdLoginPolicyEmailBlacklistRequest($orchd_login_policy_email_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setOrchdLoginPolicyEmailBlacklist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setOrchdLoginPolicyEmailBlacklistRequest($orchd_login_policy_email_list, string $contentType = self::contentTypes['setOrchdLoginPolicyEmailBlacklist'][0])
    {

        // verify the required parameter 'orchd_login_policy_email_list' is set
        if ($orchd_login_policy_email_list === null || (is_array($orchd_login_policy_email_list) && count($orchd_login_policy_email_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_email_list when calling setOrchdLoginPolicyEmailBlacklist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/email-blacklist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_email_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_email_list));
            } else {
                $httpBody = $orchd_login_policy_email_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setOrchdLoginPolicyEmailWhitelist
     *
     * Set the orchd login policy email whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setOrchdLoginPolicyEmailWhitelist($orchd_login_policy_email_list, string $contentType = self::contentTypes['setOrchdLoginPolicyEmailWhitelist'][0])
    {
        $this->setOrchdLoginPolicyEmailWhitelistWithHttpInfo($orchd_login_policy_email_list, $contentType);
    }

    /**
     * Operation setOrchdLoginPolicyEmailWhitelistWithHttpInfo
     *
     * Set the orchd login policy email whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setOrchdLoginPolicyEmailWhitelistWithHttpInfo($orchd_login_policy_email_list, string $contentType = self::contentTypes['setOrchdLoginPolicyEmailWhitelist'][0])
    {
        $request = $this->setOrchdLoginPolicyEmailWhitelistRequest($orchd_login_policy_email_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation setOrchdLoginPolicyEmailWhitelistAsync
     *
     * Set the orchd login policy email whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setOrchdLoginPolicyEmailWhitelistAsync($orchd_login_policy_email_list, string $contentType = self::contentTypes['setOrchdLoginPolicyEmailWhitelist'][0])
    {
        return $this->setOrchdLoginPolicyEmailWhitelistAsyncWithHttpInfo($orchd_login_policy_email_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setOrchdLoginPolicyEmailWhitelistAsyncWithHttpInfo
     *
     * Set the orchd login policy email whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setOrchdLoginPolicyEmailWhitelistAsyncWithHttpInfo($orchd_login_policy_email_list, string $contentType = self::contentTypes['setOrchdLoginPolicyEmailWhitelist'][0])
    {
        $returnType = '';
        $request = $this->setOrchdLoginPolicyEmailWhitelistRequest($orchd_login_policy_email_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setOrchdLoginPolicyEmailWhitelist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyEmailList $orchd_login_policy_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setOrchdLoginPolicyEmailWhitelistRequest($orchd_login_policy_email_list, string $contentType = self::contentTypes['setOrchdLoginPolicyEmailWhitelist'][0])
    {

        // verify the required parameter 'orchd_login_policy_email_list' is set
        if ($orchd_login_policy_email_list === null || (is_array($orchd_login_policy_email_list) && count($orchd_login_policy_email_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_email_list when calling setOrchdLoginPolicyEmailWhitelist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/email-whitelist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_email_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_email_list));
            } else {
                $httpBody = $orchd_login_policy_email_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setOrchdLoginPolicyIpBlacklist
     *
     * Set the orchd login policy ip blacklist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setOrchdLoginPolicyIpBlacklist($orchd_login_policy_ip_list, string $contentType = self::contentTypes['setOrchdLoginPolicyIpBlacklist'][0])
    {
        $this->setOrchdLoginPolicyIpBlacklistWithHttpInfo($orchd_login_policy_ip_list, $contentType);
    }

    /**
     * Operation setOrchdLoginPolicyIpBlacklistWithHttpInfo
     *
     * Set the orchd login policy ip blacklist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setOrchdLoginPolicyIpBlacklistWithHttpInfo($orchd_login_policy_ip_list, string $contentType = self::contentTypes['setOrchdLoginPolicyIpBlacklist'][0])
    {
        $request = $this->setOrchdLoginPolicyIpBlacklistRequest($orchd_login_policy_ip_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation setOrchdLoginPolicyIpBlacklistAsync
     *
     * Set the orchd login policy ip blacklist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setOrchdLoginPolicyIpBlacklistAsync($orchd_login_policy_ip_list, string $contentType = self::contentTypes['setOrchdLoginPolicyIpBlacklist'][0])
    {
        return $this->setOrchdLoginPolicyIpBlacklistAsyncWithHttpInfo($orchd_login_policy_ip_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setOrchdLoginPolicyIpBlacklistAsyncWithHttpInfo
     *
     * Set the orchd login policy ip blacklist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setOrchdLoginPolicyIpBlacklistAsyncWithHttpInfo($orchd_login_policy_ip_list, string $contentType = self::contentTypes['setOrchdLoginPolicyIpBlacklist'][0])
    {
        $returnType = '';
        $request = $this->setOrchdLoginPolicyIpBlacklistRequest($orchd_login_policy_ip_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setOrchdLoginPolicyIpBlacklist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setOrchdLoginPolicyIpBlacklistRequest($orchd_login_policy_ip_list, string $contentType = self::contentTypes['setOrchdLoginPolicyIpBlacklist'][0])
    {

        // verify the required parameter 'orchd_login_policy_ip_list' is set
        if ($orchd_login_policy_ip_list === null || (is_array($orchd_login_policy_ip_list) && count($orchd_login_policy_ip_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_ip_list when calling setOrchdLoginPolicyIpBlacklist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/ip-blacklist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_ip_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_ip_list));
            } else {
                $httpBody = $orchd_login_policy_ip_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setOrchdLoginPolicyIpWhitelist
     *
     * Set the orchd login policy ip whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setOrchdLoginPolicyIpWhitelist($orchd_login_policy_ip_list, string $contentType = self::contentTypes['setOrchdLoginPolicyIpWhitelist'][0])
    {
        $this->setOrchdLoginPolicyIpWhitelistWithHttpInfo($orchd_login_policy_ip_list, $contentType);
    }

    /**
     * Operation setOrchdLoginPolicyIpWhitelistWithHttpInfo
     *
     * Set the orchd login policy ip whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setOrchdLoginPolicyIpWhitelistWithHttpInfo($orchd_login_policy_ip_list, string $contentType = self::contentTypes['setOrchdLoginPolicyIpWhitelist'][0])
    {
        $request = $this->setOrchdLoginPolicyIpWhitelistRequest($orchd_login_policy_ip_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation setOrchdLoginPolicyIpWhitelistAsync
     *
     * Set the orchd login policy ip whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setOrchdLoginPolicyIpWhitelistAsync($orchd_login_policy_ip_list, string $contentType = self::contentTypes['setOrchdLoginPolicyIpWhitelist'][0])
    {
        return $this->setOrchdLoginPolicyIpWhitelistAsyncWithHttpInfo($orchd_login_policy_ip_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setOrchdLoginPolicyIpWhitelistAsyncWithHttpInfo
     *
     * Set the orchd login policy ip whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setOrchdLoginPolicyIpWhitelistAsyncWithHttpInfo($orchd_login_policy_ip_list, string $contentType = self::contentTypes['setOrchdLoginPolicyIpWhitelist'][0])
    {
        $returnType = '';
        $request = $this->setOrchdLoginPolicyIpWhitelistRequest($orchd_login_policy_ip_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setOrchdLoginPolicyIpWhitelist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyIpList $orchd_login_policy_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setOrchdLoginPolicyIpWhitelistRequest($orchd_login_policy_ip_list, string $contentType = self::contentTypes['setOrchdLoginPolicyIpWhitelist'][0])
    {

        // verify the required parameter 'orchd_login_policy_ip_list' is set
        if ($orchd_login_policy_ip_list === null || (is_array($orchd_login_policy_ip_list) && count($orchd_login_policy_ip_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_ip_list when calling setOrchdLoginPolicyIpWhitelist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/ip-whitelist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_ip_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_ip_list));
            } else {
                $httpBody = $orchd_login_policy_ip_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setOrchdLoginPolicySettings
     *
     * Set a single orchd login policy setting
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicySettings $orchd_login_policy_settings orchd_login_policy_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicySettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setOrchdLoginPolicySettings($orchd_login_policy_settings, string $contentType = self::contentTypes['setOrchdLoginPolicySettings'][0])
    {
        $this->setOrchdLoginPolicySettingsWithHttpInfo($orchd_login_policy_settings, $contentType);
    }

    /**
     * Operation setOrchdLoginPolicySettingsWithHttpInfo
     *
     * Set a single orchd login policy setting
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicySettings $orchd_login_policy_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicySettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setOrchdLoginPolicySettingsWithHttpInfo($orchd_login_policy_settings, string $contentType = self::contentTypes['setOrchdLoginPolicySettings'][0])
    {
        $request = $this->setOrchdLoginPolicySettingsRequest($orchd_login_policy_settings, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation setOrchdLoginPolicySettingsAsync
     *
     * Set a single orchd login policy setting
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicySettings $orchd_login_policy_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicySettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setOrchdLoginPolicySettingsAsync($orchd_login_policy_settings, string $contentType = self::contentTypes['setOrchdLoginPolicySettings'][0])
    {
        return $this->setOrchdLoginPolicySettingsAsyncWithHttpInfo($orchd_login_policy_settings, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setOrchdLoginPolicySettingsAsyncWithHttpInfo
     *
     * Set a single orchd login policy setting
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicySettings $orchd_login_policy_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicySettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setOrchdLoginPolicySettingsAsyncWithHttpInfo($orchd_login_policy_settings, string $contentType = self::contentTypes['setOrchdLoginPolicySettings'][0])
    {
        $returnType = '';
        $request = $this->setOrchdLoginPolicySettingsRequest($orchd_login_policy_settings, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setOrchdLoginPolicySettings'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicySettings $orchd_login_policy_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicySettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setOrchdLoginPolicySettingsRequest($orchd_login_policy_settings, string $contentType = self::contentTypes['setOrchdLoginPolicySettings'][0])
    {

        // verify the required parameter 'orchd_login_policy_settings' is set
        if ($orchd_login_policy_settings === null || (is_array($orchd_login_policy_settings) && count($orchd_login_policy_settings) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_settings when calling setOrchdLoginPolicySettings'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/settings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_settings)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_settings));
            } else {
                $httpBody = $orchd_login_policy_settings;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setOrchdLoginPolicyTemporaryEmailBlacklist
     *
     * Set the orchd login policy temporary whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList $orchd_login_policy_temporary_email_list orchd_login_policy_temporary_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyTemporaryEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setOrchdLoginPolicyTemporaryEmailBlacklist($orchd_login_policy_temporary_email_list, string $contentType = self::contentTypes['setOrchdLoginPolicyTemporaryEmailBlacklist'][0])
    {
        $this->setOrchdLoginPolicyTemporaryEmailBlacklistWithHttpInfo($orchd_login_policy_temporary_email_list, $contentType);
    }

    /**
     * Operation setOrchdLoginPolicyTemporaryEmailBlacklistWithHttpInfo
     *
     * Set the orchd login policy temporary whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList $orchd_login_policy_temporary_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyTemporaryEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setOrchdLoginPolicyTemporaryEmailBlacklistWithHttpInfo($orchd_login_policy_temporary_email_list, string $contentType = self::contentTypes['setOrchdLoginPolicyTemporaryEmailBlacklist'][0])
    {
        $request = $this->setOrchdLoginPolicyTemporaryEmailBlacklistRequest($orchd_login_policy_temporary_email_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation setOrchdLoginPolicyTemporaryEmailBlacklistAsync
     *
     * Set the orchd login policy temporary whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList $orchd_login_policy_temporary_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyTemporaryEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setOrchdLoginPolicyTemporaryEmailBlacklistAsync($orchd_login_policy_temporary_email_list, string $contentType = self::contentTypes['setOrchdLoginPolicyTemporaryEmailBlacklist'][0])
    {
        return $this->setOrchdLoginPolicyTemporaryEmailBlacklistAsyncWithHttpInfo($orchd_login_policy_temporary_email_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setOrchdLoginPolicyTemporaryEmailBlacklistAsyncWithHttpInfo
     *
     * Set the orchd login policy temporary whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList $orchd_login_policy_temporary_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyTemporaryEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setOrchdLoginPolicyTemporaryEmailBlacklistAsyncWithHttpInfo($orchd_login_policy_temporary_email_list, string $contentType = self::contentTypes['setOrchdLoginPolicyTemporaryEmailBlacklist'][0])
    {
        $returnType = '';
        $request = $this->setOrchdLoginPolicyTemporaryEmailBlacklistRequest($orchd_login_policy_temporary_email_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setOrchdLoginPolicyTemporaryEmailBlacklist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList $orchd_login_policy_temporary_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyTemporaryEmailBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setOrchdLoginPolicyTemporaryEmailBlacklistRequest($orchd_login_policy_temporary_email_list, string $contentType = self::contentTypes['setOrchdLoginPolicyTemporaryEmailBlacklist'][0])
    {

        // verify the required parameter 'orchd_login_policy_temporary_email_list' is set
        if ($orchd_login_policy_temporary_email_list === null || (is_array($orchd_login_policy_temporary_email_list) && count($orchd_login_policy_temporary_email_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_temporary_email_list when calling setOrchdLoginPolicyTemporaryEmailBlacklist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/temporary/email-blacklist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_temporary_email_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_temporary_email_list));
            } else {
                $httpBody = $orchd_login_policy_temporary_email_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setOrchdLoginPolicyTemporaryEmailWhitelist
     *
     * Set the orchd login policy temporary email whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList $orchd_login_policy_temporary_email_list orchd_login_policy_temporary_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyTemporaryEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setOrchdLoginPolicyTemporaryEmailWhitelist($orchd_login_policy_temporary_email_list, string $contentType = self::contentTypes['setOrchdLoginPolicyTemporaryEmailWhitelist'][0])
    {
        $this->setOrchdLoginPolicyTemporaryEmailWhitelistWithHttpInfo($orchd_login_policy_temporary_email_list, $contentType);
    }

    /**
     * Operation setOrchdLoginPolicyTemporaryEmailWhitelistWithHttpInfo
     *
     * Set the orchd login policy temporary email whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList $orchd_login_policy_temporary_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyTemporaryEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setOrchdLoginPolicyTemporaryEmailWhitelistWithHttpInfo($orchd_login_policy_temporary_email_list, string $contentType = self::contentTypes['setOrchdLoginPolicyTemporaryEmailWhitelist'][0])
    {
        $request = $this->setOrchdLoginPolicyTemporaryEmailWhitelistRequest($orchd_login_policy_temporary_email_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation setOrchdLoginPolicyTemporaryEmailWhitelistAsync
     *
     * Set the orchd login policy temporary email whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList $orchd_login_policy_temporary_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyTemporaryEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setOrchdLoginPolicyTemporaryEmailWhitelistAsync($orchd_login_policy_temporary_email_list, string $contentType = self::contentTypes['setOrchdLoginPolicyTemporaryEmailWhitelist'][0])
    {
        return $this->setOrchdLoginPolicyTemporaryEmailWhitelistAsyncWithHttpInfo($orchd_login_policy_temporary_email_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setOrchdLoginPolicyTemporaryEmailWhitelistAsyncWithHttpInfo
     *
     * Set the orchd login policy temporary email whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList $orchd_login_policy_temporary_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyTemporaryEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setOrchdLoginPolicyTemporaryEmailWhitelistAsyncWithHttpInfo($orchd_login_policy_temporary_email_list, string $contentType = self::contentTypes['setOrchdLoginPolicyTemporaryEmailWhitelist'][0])
    {
        $returnType = '';
        $request = $this->setOrchdLoginPolicyTemporaryEmailWhitelistRequest($orchd_login_policy_temporary_email_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setOrchdLoginPolicyTemporaryEmailWhitelist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryEmailList $orchd_login_policy_temporary_email_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyTemporaryEmailWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setOrchdLoginPolicyTemporaryEmailWhitelistRequest($orchd_login_policy_temporary_email_list, string $contentType = self::contentTypes['setOrchdLoginPolicyTemporaryEmailWhitelist'][0])
    {

        // verify the required parameter 'orchd_login_policy_temporary_email_list' is set
        if ($orchd_login_policy_temporary_email_list === null || (is_array($orchd_login_policy_temporary_email_list) && count($orchd_login_policy_temporary_email_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_temporary_email_list when calling setOrchdLoginPolicyTemporaryEmailWhitelist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/temporary/email-whitelist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_temporary_email_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_temporary_email_list));
            } else {
                $httpBody = $orchd_login_policy_temporary_email_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setOrchdLoginPolicyTemporaryIpBlacklist
     *
     * Set the orchd login policy temporary ip blacklist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList $orchd_login_policy_temporary_ip_list orchd_login_policy_temporary_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyTemporaryIpBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setOrchdLoginPolicyTemporaryIpBlacklist($orchd_login_policy_temporary_ip_list, string $contentType = self::contentTypes['setOrchdLoginPolicyTemporaryIpBlacklist'][0])
    {
        $this->setOrchdLoginPolicyTemporaryIpBlacklistWithHttpInfo($orchd_login_policy_temporary_ip_list, $contentType);
    }

    /**
     * Operation setOrchdLoginPolicyTemporaryIpBlacklistWithHttpInfo
     *
     * Set the orchd login policy temporary ip blacklist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList $orchd_login_policy_temporary_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyTemporaryIpBlacklist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setOrchdLoginPolicyTemporaryIpBlacklistWithHttpInfo($orchd_login_policy_temporary_ip_list, string $contentType = self::contentTypes['setOrchdLoginPolicyTemporaryIpBlacklist'][0])
    {
        $request = $this->setOrchdLoginPolicyTemporaryIpBlacklistRequest($orchd_login_policy_temporary_ip_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation setOrchdLoginPolicyTemporaryIpBlacklistAsync
     *
     * Set the orchd login policy temporary ip blacklist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList $orchd_login_policy_temporary_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyTemporaryIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setOrchdLoginPolicyTemporaryIpBlacklistAsync($orchd_login_policy_temporary_ip_list, string $contentType = self::contentTypes['setOrchdLoginPolicyTemporaryIpBlacklist'][0])
    {
        return $this->setOrchdLoginPolicyTemporaryIpBlacklistAsyncWithHttpInfo($orchd_login_policy_temporary_ip_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setOrchdLoginPolicyTemporaryIpBlacklistAsyncWithHttpInfo
     *
     * Set the orchd login policy temporary ip blacklist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList $orchd_login_policy_temporary_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyTemporaryIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setOrchdLoginPolicyTemporaryIpBlacklistAsyncWithHttpInfo($orchd_login_policy_temporary_ip_list, string $contentType = self::contentTypes['setOrchdLoginPolicyTemporaryIpBlacklist'][0])
    {
        $returnType = '';
        $request = $this->setOrchdLoginPolicyTemporaryIpBlacklistRequest($orchd_login_policy_temporary_ip_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setOrchdLoginPolicyTemporaryIpBlacklist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList $orchd_login_policy_temporary_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyTemporaryIpBlacklist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setOrchdLoginPolicyTemporaryIpBlacklistRequest($orchd_login_policy_temporary_ip_list, string $contentType = self::contentTypes['setOrchdLoginPolicyTemporaryIpBlacklist'][0])
    {

        // verify the required parameter 'orchd_login_policy_temporary_ip_list' is set
        if ($orchd_login_policy_temporary_ip_list === null || (is_array($orchd_login_policy_temporary_ip_list) && count($orchd_login_policy_temporary_ip_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_temporary_ip_list when calling setOrchdLoginPolicyTemporaryIpBlacklist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/temporary/ip-blacklist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_temporary_ip_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_temporary_ip_list));
            } else {
                $httpBody = $orchd_login_policy_temporary_ip_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setOrchdLoginPolicyTemporaryIpWhitelist
     *
     * Set the orchd login policy temporary ip whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList $orchd_login_policy_temporary_ip_list orchd_login_policy_temporary_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyTemporaryIpWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setOrchdLoginPolicyTemporaryIpWhitelist($orchd_login_policy_temporary_ip_list, string $contentType = self::contentTypes['setOrchdLoginPolicyTemporaryIpWhitelist'][0])
    {
        $this->setOrchdLoginPolicyTemporaryIpWhitelistWithHttpInfo($orchd_login_policy_temporary_ip_list, $contentType);
    }

    /**
     * Operation setOrchdLoginPolicyTemporaryIpWhitelistWithHttpInfo
     *
     * Set the orchd login policy temporary ip whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList $orchd_login_policy_temporary_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyTemporaryIpWhitelist'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setOrchdLoginPolicyTemporaryIpWhitelistWithHttpInfo($orchd_login_policy_temporary_ip_list, string $contentType = self::contentTypes['setOrchdLoginPolicyTemporaryIpWhitelist'][0])
    {
        $request = $this->setOrchdLoginPolicyTemporaryIpWhitelistRequest($orchd_login_policy_temporary_ip_list, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation setOrchdLoginPolicyTemporaryIpWhitelistAsync
     *
     * Set the orchd login policy temporary ip whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList $orchd_login_policy_temporary_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyTemporaryIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setOrchdLoginPolicyTemporaryIpWhitelistAsync($orchd_login_policy_temporary_ip_list, string $contentType = self::contentTypes['setOrchdLoginPolicyTemporaryIpWhitelist'][0])
    {
        return $this->setOrchdLoginPolicyTemporaryIpWhitelistAsyncWithHttpInfo($orchd_login_policy_temporary_ip_list, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setOrchdLoginPolicyTemporaryIpWhitelistAsyncWithHttpInfo
     *
     * Set the orchd login policy temporary ip whitelist as a whole
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList $orchd_login_policy_temporary_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyTemporaryIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setOrchdLoginPolicyTemporaryIpWhitelistAsyncWithHttpInfo($orchd_login_policy_temporary_ip_list, string $contentType = self::contentTypes['setOrchdLoginPolicyTemporaryIpWhitelist'][0])
    {
        $returnType = '';
        $request = $this->setOrchdLoginPolicyTemporaryIpWhitelistRequest($orchd_login_policy_temporary_ip_list, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setOrchdLoginPolicyTemporaryIpWhitelist'
     *
     * @param  \OpenAPI\Client\Model\OrchdLoginPolicyTemporaryIpList $orchd_login_policy_temporary_ip_list (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setOrchdLoginPolicyTemporaryIpWhitelist'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setOrchdLoginPolicyTemporaryIpWhitelistRequest($orchd_login_policy_temporary_ip_list, string $contentType = self::contentTypes['setOrchdLoginPolicyTemporaryIpWhitelist'][0])
    {

        // verify the required parameter 'orchd_login_policy_temporary_ip_list' is set
        if ($orchd_login_policy_temporary_ip_list === null || (is_array($orchd_login_policy_temporary_ip_list) && count($orchd_login_policy_temporary_ip_list) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $orchd_login_policy_temporary_ip_list when calling setOrchdLoginPolicyTemporaryIpWhitelist'
            );
        }


        $resourcePath = '/settings/orchd/login-policy/temporary/ip-whitelist';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($orchd_login_policy_temporary_ip_list)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($orchd_login_policy_temporary_ip_list));
            } else {
                $httpBody = $orchd_login_policy_temporary_ip_list;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateSetting
     *
     * Create or update the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  \OpenAPI\Client\Model\UpdateSettingRequest $update_setting_request update_setting_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateSetting($name, $update_setting_request, string $contentType = self::contentTypes['updateSetting'][0])
    {
        $this->updateSettingWithHttpInfo($name, $update_setting_request, $contentType);
    }

    /**
     * Operation updateSettingWithHttpInfo
     *
     * Create or update the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  \OpenAPI\Client\Model\UpdateSettingRequest $update_setting_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSetting'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateSettingWithHttpInfo($name, $update_setting_request, string $contentType = self::contentTypes['updateSetting'][0])
    {
        $request = $this->updateSettingRequest($name, $update_setting_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation updateSettingAsync
     *
     * Create or update the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  \OpenAPI\Client\Model\UpdateSettingRequest $update_setting_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateSettingAsync($name, $update_setting_request, string $contentType = self::contentTypes['updateSetting'][0])
    {
        return $this->updateSettingAsyncWithHttpInfo($name, $update_setting_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateSettingAsyncWithHttpInfo
     *
     * Create or update the specified setting
     *
     * @param  string $name The name of the resource. (required)
     * @param  \OpenAPI\Client\Model\UpdateSettingRequest $update_setting_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateSettingAsyncWithHttpInfo($name, $update_setting_request, string $contentType = self::contentTypes['updateSetting'][0])
    {
        $returnType = '';
        $request = $this->updateSettingRequest($name, $update_setting_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateSetting'
     *
     * @param  string $name The name of the resource. (required)
     * @param  \OpenAPI\Client\Model\UpdateSettingRequest $update_setting_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSetting'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateSettingRequest($name, $update_setting_request, string $contentType = self::contentTypes['updateSetting'][0])
    {

        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling updateSetting'
            );
        }

        // verify the required parameter 'update_setting_request' is set
        if ($update_setting_request === null || (is_array($update_setting_request) && count($update_setting_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_setting_request when calling updateSetting'
            );
        }


        $resourcePath = '/settings/{name}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                '{' . 'name' . '}',
                ObjectSerializer::toPathValue($name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($update_setting_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_setting_request));
            } else {
                $httpBody = $update_setting_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
