<?php
/**
 * MysqlApi
 * PHP version 7.4
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 9.1.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\ObjectSerializer;

/**
 * MysqlApi Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class MysqlApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createOrRestoreWebsiteMySQLDBBackup' => [
            'application/json',
        ],
        'createWebsiteMySQLDB' => [
            'application/json',
        ],
        'createWebsiteMySQLUser' => [
            'application/json',
        ],
        'createWebsiteMySQLUserAccessHosts' => [
            'application/json',
        ],
        'createWebsiteMySQLUserPrivileges' => [
            'application/json',
        ],
        'deleteWebsiteMySQLDB' => [
            'application/json',
        ],
        'deleteWebsiteMySQLUser' => [
            'application/json',
        ],
        'deleteWebsiteMySQLUserAccessHosts' => [
            'application/json',
        ],
        'deleteWebsiteMySQLUserPrivileges' => [
            'application/json',
        ],
        'downloadSql' => [
            'application/json',
        ],
        'getOrgMySQLDBs' => [
            'application/json',
        ],
        'getPhpMyAdminSSOUrl' => [
            'application/json',
        ],
        'getWebsiteMySQLDBs' => [
            'application/json',
        ],
        'getWebsiteMySQLUsers' => [
            'application/json',
        ],
        'updateWebsiteMySQLUser' => [
            'application/json',
        ],
        'uploadSql' => [
            'multipart/form-data',
        ],
    ];

/**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createOrRestoreWebsiteMySQLDBBackup
     *
     * Create or restore website MySQL database backup
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $action The action to take. (optional, default to 'create')
     * @param  string $filename The filename of the backup file. Only applicable if the backup action is &#x60;restore&#x60;, otherwise this is ignored. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrRestoreWebsiteMySQLDBBackup'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createOrRestoreWebsiteMySQLDBBackup($org_id, $website_id, $db_id, $action = 'create', $filename = null, string $contentType = self::contentTypes['createOrRestoreWebsiteMySQLDBBackup'][0])
    {
        $this->createOrRestoreWebsiteMySQLDBBackupWithHttpInfo($org_id, $website_id, $db_id, $action, $filename, $contentType);
    }

    /**
     * Operation createOrRestoreWebsiteMySQLDBBackupWithHttpInfo
     *
     * Create or restore website MySQL database backup
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $action The action to take. (optional, default to 'create')
     * @param  string $filename The filename of the backup file. Only applicable if the backup action is &#x60;restore&#x60;, otherwise this is ignored. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrRestoreWebsiteMySQLDBBackup'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createOrRestoreWebsiteMySQLDBBackupWithHttpInfo($org_id, $website_id, $db_id, $action = 'create', $filename = null, string $contentType = self::contentTypes['createOrRestoreWebsiteMySQLDBBackup'][0])
    {
        $request = $this->createOrRestoreWebsiteMySQLDBBackupRequest($org_id, $website_id, $db_id, $action, $filename, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createOrRestoreWebsiteMySQLDBBackupAsync
     *
     * Create or restore website MySQL database backup
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $action The action to take. (optional, default to 'create')
     * @param  string $filename The filename of the backup file. Only applicable if the backup action is &#x60;restore&#x60;, otherwise this is ignored. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrRestoreWebsiteMySQLDBBackup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOrRestoreWebsiteMySQLDBBackupAsync($org_id, $website_id, $db_id, $action = 'create', $filename = null, string $contentType = self::contentTypes['createOrRestoreWebsiteMySQLDBBackup'][0])
    {
        return $this->createOrRestoreWebsiteMySQLDBBackupAsyncWithHttpInfo($org_id, $website_id, $db_id, $action, $filename, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createOrRestoreWebsiteMySQLDBBackupAsyncWithHttpInfo
     *
     * Create or restore website MySQL database backup
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $action The action to take. (optional, default to 'create')
     * @param  string $filename The filename of the backup file. Only applicable if the backup action is &#x60;restore&#x60;, otherwise this is ignored. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrRestoreWebsiteMySQLDBBackup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOrRestoreWebsiteMySQLDBBackupAsyncWithHttpInfo($org_id, $website_id, $db_id, $action = 'create', $filename = null, string $contentType = self::contentTypes['createOrRestoreWebsiteMySQLDBBackup'][0])
    {
        $returnType = '';
        $request = $this->createOrRestoreWebsiteMySQLDBBackupRequest($org_id, $website_id, $db_id, $action, $filename, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createOrRestoreWebsiteMySQLDBBackup'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $action The action to take. (optional, default to 'create')
     * @param  string $filename The filename of the backup file. Only applicable if the backup action is &#x60;restore&#x60;, otherwise this is ignored. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrRestoreWebsiteMySQLDBBackup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createOrRestoreWebsiteMySQLDBBackupRequest($org_id, $website_id, $db_id, $action = 'create', $filename = null, string $contentType = self::contentTypes['createOrRestoreWebsiteMySQLDBBackup'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling createOrRestoreWebsiteMySQLDBBackup'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling createOrRestoreWebsiteMySQLDBBackup'
            );
        }

        // verify the required parameter 'db_id' is set
        if ($db_id === null || (is_array($db_id) && count($db_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $db_id when calling createOrRestoreWebsiteMySQLDBBackup'
            );
        }




        $resourcePath = '/orgs/{org_id}/websites/{website_id}/mysql-dbs/{db_id}/backups';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $action,
            'action', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $filename,
            'filename', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($db_id !== null) {
            $resourcePath = str_replace(
                '{' . 'db_id' . '}',
                ObjectSerializer::toPathValue($db_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createWebsiteMySQLDB
     *
     * Create a MySQL database for website
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  \OpenAPI\Client\Model\NewMySQLDB $new_my_sqldb New database details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteMySQLDB'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\NewResourceUuid
     */
    public function createWebsiteMySQLDB($org_id, $website_id, $new_my_sqldb, string $contentType = self::contentTypes['createWebsiteMySQLDB'][0])
    {
        list($response) = $this->createWebsiteMySQLDBWithHttpInfo($org_id, $website_id, $new_my_sqldb, $contentType);
        return $response;
    }

    /**
     * Operation createWebsiteMySQLDBWithHttpInfo
     *
     * Create a MySQL database for website
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  \OpenAPI\Client\Model\NewMySQLDB $new_my_sqldb New database details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteMySQLDB'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\NewResourceUuid, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWebsiteMySQLDBWithHttpInfo($org_id, $website_id, $new_my_sqldb, string $contentType = self::contentTypes['createWebsiteMySQLDB'][0])
    {
        $request = $this->createWebsiteMySQLDBRequest($org_id, $website_id, $new_my_sqldb, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\OpenAPI\Client\Model\NewResourceUuid' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\NewResourceUuid' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\NewResourceUuid', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\NewResourceUuid';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\NewResourceUuid',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createWebsiteMySQLDBAsync
     *
     * Create a MySQL database for website
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  \OpenAPI\Client\Model\NewMySQLDB $new_my_sqldb New database details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteMySQLDB'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWebsiteMySQLDBAsync($org_id, $website_id, $new_my_sqldb, string $contentType = self::contentTypes['createWebsiteMySQLDB'][0])
    {
        return $this->createWebsiteMySQLDBAsyncWithHttpInfo($org_id, $website_id, $new_my_sqldb, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createWebsiteMySQLDBAsyncWithHttpInfo
     *
     * Create a MySQL database for website
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  \OpenAPI\Client\Model\NewMySQLDB $new_my_sqldb New database details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteMySQLDB'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWebsiteMySQLDBAsyncWithHttpInfo($org_id, $website_id, $new_my_sqldb, string $contentType = self::contentTypes['createWebsiteMySQLDB'][0])
    {
        $returnType = '\OpenAPI\Client\Model\NewResourceUuid';
        $request = $this->createWebsiteMySQLDBRequest($org_id, $website_id, $new_my_sqldb, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createWebsiteMySQLDB'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  \OpenAPI\Client\Model\NewMySQLDB $new_my_sqldb New database details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteMySQLDB'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createWebsiteMySQLDBRequest($org_id, $website_id, $new_my_sqldb, string $contentType = self::contentTypes['createWebsiteMySQLDB'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling createWebsiteMySQLDB'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling createWebsiteMySQLDB'
            );
        }

        // verify the required parameter 'new_my_sqldb' is set
        if ($new_my_sqldb === null || (is_array($new_my_sqldb) && count($new_my_sqldb) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $new_my_sqldb when calling createWebsiteMySQLDB'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/mysql-dbs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($new_my_sqldb)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($new_my_sqldb));
            } else {
                $httpBody = $new_my_sqldb;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createWebsiteMySQLUser
     *
     * Create website MySQL database user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  \OpenAPI\Client\Model\NewMySQLUser $new_my_sql_user New user details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteMySQLUser'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\NewResourceUuid
     */
    public function createWebsiteMySQLUser($org_id, $website_id, $new_my_sql_user, string $contentType = self::contentTypes['createWebsiteMySQLUser'][0])
    {
        list($response) = $this->createWebsiteMySQLUserWithHttpInfo($org_id, $website_id, $new_my_sql_user, $contentType);
        return $response;
    }

    /**
     * Operation createWebsiteMySQLUserWithHttpInfo
     *
     * Create website MySQL database user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  \OpenAPI\Client\Model\NewMySQLUser $new_my_sql_user New user details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteMySQLUser'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\NewResourceUuid, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWebsiteMySQLUserWithHttpInfo($org_id, $website_id, $new_my_sql_user, string $contentType = self::contentTypes['createWebsiteMySQLUser'][0])
    {
        $request = $this->createWebsiteMySQLUserRequest($org_id, $website_id, $new_my_sql_user, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\OpenAPI\Client\Model\NewResourceUuid' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\NewResourceUuid' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\NewResourceUuid', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\NewResourceUuid';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\NewResourceUuid',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createWebsiteMySQLUserAsync
     *
     * Create website MySQL database user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  \OpenAPI\Client\Model\NewMySQLUser $new_my_sql_user New user details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteMySQLUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWebsiteMySQLUserAsync($org_id, $website_id, $new_my_sql_user, string $contentType = self::contentTypes['createWebsiteMySQLUser'][0])
    {
        return $this->createWebsiteMySQLUserAsyncWithHttpInfo($org_id, $website_id, $new_my_sql_user, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createWebsiteMySQLUserAsyncWithHttpInfo
     *
     * Create website MySQL database user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  \OpenAPI\Client\Model\NewMySQLUser $new_my_sql_user New user details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteMySQLUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWebsiteMySQLUserAsyncWithHttpInfo($org_id, $website_id, $new_my_sql_user, string $contentType = self::contentTypes['createWebsiteMySQLUser'][0])
    {
        $returnType = '\OpenAPI\Client\Model\NewResourceUuid';
        $request = $this->createWebsiteMySQLUserRequest($org_id, $website_id, $new_my_sql_user, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createWebsiteMySQLUser'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  \OpenAPI\Client\Model\NewMySQLUser $new_my_sql_user New user details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteMySQLUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createWebsiteMySQLUserRequest($org_id, $website_id, $new_my_sql_user, string $contentType = self::contentTypes['createWebsiteMySQLUser'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling createWebsiteMySQLUser'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling createWebsiteMySQLUser'
            );
        }

        // verify the required parameter 'new_my_sql_user' is set
        if ($new_my_sql_user === null || (is_array($new_my_sql_user) && count($new_my_sql_user) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $new_my_sql_user when calling createWebsiteMySQLUser'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/mysql-users';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($new_my_sql_user)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($new_my_sql_user));
            } else {
                $httpBody = $new_my_sql_user;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createWebsiteMySQLUserAccessHosts
     *
     * Create website MySQL database user access hosts
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserAccessHosts $my_sql_user_access_hosts User access hosts. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteMySQLUserAccessHosts'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createWebsiteMySQLUserAccessHosts($org_id, $website_id, $db_id, $user_id, $my_sql_user_access_hosts, string $contentType = self::contentTypes['createWebsiteMySQLUserAccessHosts'][0])
    {
        $this->createWebsiteMySQLUserAccessHostsWithHttpInfo($org_id, $website_id, $db_id, $user_id, $my_sql_user_access_hosts, $contentType);
    }

    /**
     * Operation createWebsiteMySQLUserAccessHostsWithHttpInfo
     *
     * Create website MySQL database user access hosts
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserAccessHosts $my_sql_user_access_hosts User access hosts. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteMySQLUserAccessHosts'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWebsiteMySQLUserAccessHostsWithHttpInfo($org_id, $website_id, $db_id, $user_id, $my_sql_user_access_hosts, string $contentType = self::contentTypes['createWebsiteMySQLUserAccessHosts'][0])
    {
        $request = $this->createWebsiteMySQLUserAccessHostsRequest($org_id, $website_id, $db_id, $user_id, $my_sql_user_access_hosts, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createWebsiteMySQLUserAccessHostsAsync
     *
     * Create website MySQL database user access hosts
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserAccessHosts $my_sql_user_access_hosts User access hosts. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteMySQLUserAccessHosts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWebsiteMySQLUserAccessHostsAsync($org_id, $website_id, $db_id, $user_id, $my_sql_user_access_hosts, string $contentType = self::contentTypes['createWebsiteMySQLUserAccessHosts'][0])
    {
        return $this->createWebsiteMySQLUserAccessHostsAsyncWithHttpInfo($org_id, $website_id, $db_id, $user_id, $my_sql_user_access_hosts, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createWebsiteMySQLUserAccessHostsAsyncWithHttpInfo
     *
     * Create website MySQL database user access hosts
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserAccessHosts $my_sql_user_access_hosts User access hosts. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteMySQLUserAccessHosts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWebsiteMySQLUserAccessHostsAsyncWithHttpInfo($org_id, $website_id, $db_id, $user_id, $my_sql_user_access_hosts, string $contentType = self::contentTypes['createWebsiteMySQLUserAccessHosts'][0])
    {
        $returnType = '';
        $request = $this->createWebsiteMySQLUserAccessHostsRequest($org_id, $website_id, $db_id, $user_id, $my_sql_user_access_hosts, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createWebsiteMySQLUserAccessHosts'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserAccessHosts $my_sql_user_access_hosts User access hosts. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteMySQLUserAccessHosts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createWebsiteMySQLUserAccessHostsRequest($org_id, $website_id, $db_id, $user_id, $my_sql_user_access_hosts, string $contentType = self::contentTypes['createWebsiteMySQLUserAccessHosts'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling createWebsiteMySQLUserAccessHosts'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling createWebsiteMySQLUserAccessHosts'
            );
        }

        // verify the required parameter 'db_id' is set
        if ($db_id === null || (is_array($db_id) && count($db_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $db_id when calling createWebsiteMySQLUserAccessHosts'
            );
        }

        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling createWebsiteMySQLUserAccessHosts'
            );
        }

        // verify the required parameter 'my_sql_user_access_hosts' is set
        if ($my_sql_user_access_hosts === null || (is_array($my_sql_user_access_hosts) && count($my_sql_user_access_hosts) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $my_sql_user_access_hosts when calling createWebsiteMySQLUserAccessHosts'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/mysql-users/{user_id}/access-hosts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($db_id !== null) {
            $resourcePath = str_replace(
                '{' . 'db_id' . '}',
                ObjectSerializer::toPathValue($db_id),
                $resourcePath
            );
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'user_id' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($my_sql_user_access_hosts)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($my_sql_user_access_hosts));
            } else {
                $httpBody = $my_sql_user_access_hosts;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createWebsiteMySQLUserPrivileges
     *
     * Create website MySQL database user privileges
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserGrants $my_sql_user_grants User privilege grants. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteMySQLUserPrivileges'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createWebsiteMySQLUserPrivileges($org_id, $website_id, $user_id, $my_sql_user_grants, string $contentType = self::contentTypes['createWebsiteMySQLUserPrivileges'][0])
    {
        $this->createWebsiteMySQLUserPrivilegesWithHttpInfo($org_id, $website_id, $user_id, $my_sql_user_grants, $contentType);
    }

    /**
     * Operation createWebsiteMySQLUserPrivilegesWithHttpInfo
     *
     * Create website MySQL database user privileges
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserGrants $my_sql_user_grants User privilege grants. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteMySQLUserPrivileges'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWebsiteMySQLUserPrivilegesWithHttpInfo($org_id, $website_id, $user_id, $my_sql_user_grants, string $contentType = self::contentTypes['createWebsiteMySQLUserPrivileges'][0])
    {
        $request = $this->createWebsiteMySQLUserPrivilegesRequest($org_id, $website_id, $user_id, $my_sql_user_grants, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createWebsiteMySQLUserPrivilegesAsync
     *
     * Create website MySQL database user privileges
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserGrants $my_sql_user_grants User privilege grants. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteMySQLUserPrivileges'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWebsiteMySQLUserPrivilegesAsync($org_id, $website_id, $user_id, $my_sql_user_grants, string $contentType = self::contentTypes['createWebsiteMySQLUserPrivileges'][0])
    {
        return $this->createWebsiteMySQLUserPrivilegesAsyncWithHttpInfo($org_id, $website_id, $user_id, $my_sql_user_grants, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createWebsiteMySQLUserPrivilegesAsyncWithHttpInfo
     *
     * Create website MySQL database user privileges
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserGrants $my_sql_user_grants User privilege grants. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteMySQLUserPrivileges'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWebsiteMySQLUserPrivilegesAsyncWithHttpInfo($org_id, $website_id, $user_id, $my_sql_user_grants, string $contentType = self::contentTypes['createWebsiteMySQLUserPrivileges'][0])
    {
        $returnType = '';
        $request = $this->createWebsiteMySQLUserPrivilegesRequest($org_id, $website_id, $user_id, $my_sql_user_grants, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createWebsiteMySQLUserPrivileges'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserGrants $my_sql_user_grants User privilege grants. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteMySQLUserPrivileges'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createWebsiteMySQLUserPrivilegesRequest($org_id, $website_id, $user_id, $my_sql_user_grants, string $contentType = self::contentTypes['createWebsiteMySQLUserPrivileges'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling createWebsiteMySQLUserPrivileges'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling createWebsiteMySQLUserPrivileges'
            );
        }

        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling createWebsiteMySQLUserPrivileges'
            );
        }

        // verify the required parameter 'my_sql_user_grants' is set
        if ($my_sql_user_grants === null || (is_array($my_sql_user_grants) && count($my_sql_user_grants) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $my_sql_user_grants when calling createWebsiteMySQLUserPrivileges'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/mysql-users/{user_id}/privileges';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'user_id' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($my_sql_user_grants)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($my_sql_user_grants));
            } else {
                $httpBody = $my_sql_user_grants;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteWebsiteMySQLDB
     *
     * Delete website MySQL database
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteMySQLDB'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteWebsiteMySQLDB($org_id, $website_id, $db_id, string $contentType = self::contentTypes['deleteWebsiteMySQLDB'][0])
    {
        $this->deleteWebsiteMySQLDBWithHttpInfo($org_id, $website_id, $db_id, $contentType);
    }

    /**
     * Operation deleteWebsiteMySQLDBWithHttpInfo
     *
     * Delete website MySQL database
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteMySQLDB'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteWebsiteMySQLDBWithHttpInfo($org_id, $website_id, $db_id, string $contentType = self::contentTypes['deleteWebsiteMySQLDB'][0])
    {
        $request = $this->deleteWebsiteMySQLDBRequest($org_id, $website_id, $db_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteWebsiteMySQLDBAsync
     *
     * Delete website MySQL database
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteMySQLDB'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWebsiteMySQLDBAsync($org_id, $website_id, $db_id, string $contentType = self::contentTypes['deleteWebsiteMySQLDB'][0])
    {
        return $this->deleteWebsiteMySQLDBAsyncWithHttpInfo($org_id, $website_id, $db_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteWebsiteMySQLDBAsyncWithHttpInfo
     *
     * Delete website MySQL database
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteMySQLDB'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWebsiteMySQLDBAsyncWithHttpInfo($org_id, $website_id, $db_id, string $contentType = self::contentTypes['deleteWebsiteMySQLDB'][0])
    {
        $returnType = '';
        $request = $this->deleteWebsiteMySQLDBRequest($org_id, $website_id, $db_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteWebsiteMySQLDB'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteMySQLDB'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteWebsiteMySQLDBRequest($org_id, $website_id, $db_id, string $contentType = self::contentTypes['deleteWebsiteMySQLDB'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteWebsiteMySQLDB'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling deleteWebsiteMySQLDB'
            );
        }

        // verify the required parameter 'db_id' is set
        if ($db_id === null || (is_array($db_id) && count($db_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $db_id when calling deleteWebsiteMySQLDB'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/mysql-dbs/{db_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($db_id !== null) {
            $resourcePath = str_replace(
                '{' . 'db_id' . '}',
                ObjectSerializer::toPathValue($db_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteWebsiteMySQLUser
     *
     * Delete website MySQL database user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteMySQLUser'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteWebsiteMySQLUser($org_id, $website_id, $user_id, string $contentType = self::contentTypes['deleteWebsiteMySQLUser'][0])
    {
        $this->deleteWebsiteMySQLUserWithHttpInfo($org_id, $website_id, $user_id, $contentType);
    }

    /**
     * Operation deleteWebsiteMySQLUserWithHttpInfo
     *
     * Delete website MySQL database user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteMySQLUser'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteWebsiteMySQLUserWithHttpInfo($org_id, $website_id, $user_id, string $contentType = self::contentTypes['deleteWebsiteMySQLUser'][0])
    {
        $request = $this->deleteWebsiteMySQLUserRequest($org_id, $website_id, $user_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteWebsiteMySQLUserAsync
     *
     * Delete website MySQL database user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteMySQLUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWebsiteMySQLUserAsync($org_id, $website_id, $user_id, string $contentType = self::contentTypes['deleteWebsiteMySQLUser'][0])
    {
        return $this->deleteWebsiteMySQLUserAsyncWithHttpInfo($org_id, $website_id, $user_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteWebsiteMySQLUserAsyncWithHttpInfo
     *
     * Delete website MySQL database user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteMySQLUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWebsiteMySQLUserAsyncWithHttpInfo($org_id, $website_id, $user_id, string $contentType = self::contentTypes['deleteWebsiteMySQLUser'][0])
    {
        $returnType = '';
        $request = $this->deleteWebsiteMySQLUserRequest($org_id, $website_id, $user_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteWebsiteMySQLUser'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteMySQLUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteWebsiteMySQLUserRequest($org_id, $website_id, $user_id, string $contentType = self::contentTypes['deleteWebsiteMySQLUser'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteWebsiteMySQLUser'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling deleteWebsiteMySQLUser'
            );
        }

        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling deleteWebsiteMySQLUser'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/mysql-users/{user_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'user_id' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteWebsiteMySQLUserAccessHosts
     *
     * Delete website MySQL database user access hosts
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserAccessHosts $my_sql_user_access_hosts User access hosts. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteMySQLUserAccessHosts'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteWebsiteMySQLUserAccessHosts($org_id, $website_id, $db_id, $user_id, $my_sql_user_access_hosts, string $contentType = self::contentTypes['deleteWebsiteMySQLUserAccessHosts'][0])
    {
        $this->deleteWebsiteMySQLUserAccessHostsWithHttpInfo($org_id, $website_id, $db_id, $user_id, $my_sql_user_access_hosts, $contentType);
    }

    /**
     * Operation deleteWebsiteMySQLUserAccessHostsWithHttpInfo
     *
     * Delete website MySQL database user access hosts
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserAccessHosts $my_sql_user_access_hosts User access hosts. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteMySQLUserAccessHosts'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteWebsiteMySQLUserAccessHostsWithHttpInfo($org_id, $website_id, $db_id, $user_id, $my_sql_user_access_hosts, string $contentType = self::contentTypes['deleteWebsiteMySQLUserAccessHosts'][0])
    {
        $request = $this->deleteWebsiteMySQLUserAccessHostsRequest($org_id, $website_id, $db_id, $user_id, $my_sql_user_access_hosts, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteWebsiteMySQLUserAccessHostsAsync
     *
     * Delete website MySQL database user access hosts
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserAccessHosts $my_sql_user_access_hosts User access hosts. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteMySQLUserAccessHosts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWebsiteMySQLUserAccessHostsAsync($org_id, $website_id, $db_id, $user_id, $my_sql_user_access_hosts, string $contentType = self::contentTypes['deleteWebsiteMySQLUserAccessHosts'][0])
    {
        return $this->deleteWebsiteMySQLUserAccessHostsAsyncWithHttpInfo($org_id, $website_id, $db_id, $user_id, $my_sql_user_access_hosts, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteWebsiteMySQLUserAccessHostsAsyncWithHttpInfo
     *
     * Delete website MySQL database user access hosts
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserAccessHosts $my_sql_user_access_hosts User access hosts. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteMySQLUserAccessHosts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWebsiteMySQLUserAccessHostsAsyncWithHttpInfo($org_id, $website_id, $db_id, $user_id, $my_sql_user_access_hosts, string $contentType = self::contentTypes['deleteWebsiteMySQLUserAccessHosts'][0])
    {
        $returnType = '';
        $request = $this->deleteWebsiteMySQLUserAccessHostsRequest($org_id, $website_id, $db_id, $user_id, $my_sql_user_access_hosts, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteWebsiteMySQLUserAccessHosts'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserAccessHosts $my_sql_user_access_hosts User access hosts. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteMySQLUserAccessHosts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteWebsiteMySQLUserAccessHostsRequest($org_id, $website_id, $db_id, $user_id, $my_sql_user_access_hosts, string $contentType = self::contentTypes['deleteWebsiteMySQLUserAccessHosts'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteWebsiteMySQLUserAccessHosts'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling deleteWebsiteMySQLUserAccessHosts'
            );
        }

        // verify the required parameter 'db_id' is set
        if ($db_id === null || (is_array($db_id) && count($db_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $db_id when calling deleteWebsiteMySQLUserAccessHosts'
            );
        }

        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling deleteWebsiteMySQLUserAccessHosts'
            );
        }

        // verify the required parameter 'my_sql_user_access_hosts' is set
        if ($my_sql_user_access_hosts === null || (is_array($my_sql_user_access_hosts) && count($my_sql_user_access_hosts) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $my_sql_user_access_hosts when calling deleteWebsiteMySQLUserAccessHosts'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/mysql-users/{user_id}/access-hosts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($db_id !== null) {
            $resourcePath = str_replace(
                '{' . 'db_id' . '}',
                ObjectSerializer::toPathValue($db_id),
                $resourcePath
            );
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'user_id' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($my_sql_user_access_hosts)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($my_sql_user_access_hosts));
            } else {
                $httpBody = $my_sql_user_access_hosts;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteWebsiteMySQLUserPrivileges
     *
     * Delete website MySQL database user privileges
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserGrants $my_sql_user_grants User privilege grants. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteMySQLUserPrivileges'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteWebsiteMySQLUserPrivileges($org_id, $website_id, $user_id, $my_sql_user_grants, string $contentType = self::contentTypes['deleteWebsiteMySQLUserPrivileges'][0])
    {
        $this->deleteWebsiteMySQLUserPrivilegesWithHttpInfo($org_id, $website_id, $user_id, $my_sql_user_grants, $contentType);
    }

    /**
     * Operation deleteWebsiteMySQLUserPrivilegesWithHttpInfo
     *
     * Delete website MySQL database user privileges
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserGrants $my_sql_user_grants User privilege grants. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteMySQLUserPrivileges'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteWebsiteMySQLUserPrivilegesWithHttpInfo($org_id, $website_id, $user_id, $my_sql_user_grants, string $contentType = self::contentTypes['deleteWebsiteMySQLUserPrivileges'][0])
    {
        $request = $this->deleteWebsiteMySQLUserPrivilegesRequest($org_id, $website_id, $user_id, $my_sql_user_grants, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteWebsiteMySQLUserPrivilegesAsync
     *
     * Delete website MySQL database user privileges
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserGrants $my_sql_user_grants User privilege grants. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteMySQLUserPrivileges'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWebsiteMySQLUserPrivilegesAsync($org_id, $website_id, $user_id, $my_sql_user_grants, string $contentType = self::contentTypes['deleteWebsiteMySQLUserPrivileges'][0])
    {
        return $this->deleteWebsiteMySQLUserPrivilegesAsyncWithHttpInfo($org_id, $website_id, $user_id, $my_sql_user_grants, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteWebsiteMySQLUserPrivilegesAsyncWithHttpInfo
     *
     * Delete website MySQL database user privileges
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserGrants $my_sql_user_grants User privilege grants. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteMySQLUserPrivileges'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWebsiteMySQLUserPrivilegesAsyncWithHttpInfo($org_id, $website_id, $user_id, $my_sql_user_grants, string $contentType = self::contentTypes['deleteWebsiteMySQLUserPrivileges'][0])
    {
        $returnType = '';
        $request = $this->deleteWebsiteMySQLUserPrivilegesRequest($org_id, $website_id, $user_id, $my_sql_user_grants, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteWebsiteMySQLUserPrivileges'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserGrants $my_sql_user_grants User privilege grants. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteMySQLUserPrivileges'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteWebsiteMySQLUserPrivilegesRequest($org_id, $website_id, $user_id, $my_sql_user_grants, string $contentType = self::contentTypes['deleteWebsiteMySQLUserPrivileges'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteWebsiteMySQLUserPrivileges'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling deleteWebsiteMySQLUserPrivileges'
            );
        }

        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling deleteWebsiteMySQLUserPrivileges'
            );
        }

        // verify the required parameter 'my_sql_user_grants' is set
        if ($my_sql_user_grants === null || (is_array($my_sql_user_grants) && count($my_sql_user_grants) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $my_sql_user_grants when calling deleteWebsiteMySQLUserPrivileges'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/mysql-users/{user_id}/privileges';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'user_id' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($my_sql_user_grants)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($my_sql_user_grants));
            } else {
                $httpBody = $my_sql_user_grants;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation downloadSql
     *
     * Takes a backup of given database and returns it gziped
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['downloadSql'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SplFileObject
     */
    public function downloadSql($org_id, $website_id, $db_id, string $contentType = self::contentTypes['downloadSql'][0])
    {
        list($response) = $this->downloadSqlWithHttpInfo($org_id, $website_id, $db_id, $contentType);
        return $response;
    }

    /**
     * Operation downloadSqlWithHttpInfo
     *
     * Takes a backup of given database and returns it gziped
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['downloadSql'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function downloadSqlWithHttpInfo($org_id, $website_id, $db_id, string $contentType = self::contentTypes['downloadSql'][0])
    {
        $request = $this->downloadSqlRequest($org_id, $website_id, $db_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SplFileObject' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SplFileObject' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SplFileObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SplFileObject';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SplFileObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation downloadSqlAsync
     *
     * Takes a backup of given database and returns it gziped
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['downloadSql'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function downloadSqlAsync($org_id, $website_id, $db_id, string $contentType = self::contentTypes['downloadSql'][0])
    {
        return $this->downloadSqlAsyncWithHttpInfo($org_id, $website_id, $db_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation downloadSqlAsyncWithHttpInfo
     *
     * Takes a backup of given database and returns it gziped
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['downloadSql'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function downloadSqlAsyncWithHttpInfo($org_id, $website_id, $db_id, string $contentType = self::contentTypes['downloadSql'][0])
    {
        $returnType = '\SplFileObject';
        $request = $this->downloadSqlRequest($org_id, $website_id, $db_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'downloadSql'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['downloadSql'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function downloadSqlRequest($org_id, $website_id, $db_id, string $contentType = self::contentTypes['downloadSql'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling downloadSql'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling downloadSql'
            );
        }

        // verify the required parameter 'db_id' is set
        if ($db_id === null || (is_array($db_id) && count($db_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $db_id when calling downloadSql'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/mysql-dbs/{db_id}/sql';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($db_id !== null) {
            $resourcePath = str_replace(
                '{' . 'db_id' . '}',
                ObjectSerializer::toPathValue($db_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/octet-stream', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getOrgMySQLDBs
     *
     * Get org&#39;s MySQL databases
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $offset The offset from which to return items. (optional)
     * @param  int $limit The maximum number of items to return. (optional)
     * @param  string $sort_by The field by which to sort. (optional)
     * @param  string $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $search Limit the result set to the resources whose names, partially and case insensitively, match the specified search term. E.g. for websites, this is their domain or tag, for databases the database name, for emails the email address or mailbox name, etc. A website will also be returned if the search term exactly matches the website&#39;s uuid. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrgMySQLDBs'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\MySQLDBsListing
     */
    public function getOrgMySQLDBs($org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, $search = null, string $contentType = self::contentTypes['getOrgMySQLDBs'][0])
    {
        list($response) = $this->getOrgMySQLDBsWithHttpInfo($org_id, $offset, $limit, $sort_by, $sort_order, $search, $contentType);
        return $response;
    }

    /**
     * Operation getOrgMySQLDBsWithHttpInfo
     *
     * Get org&#39;s MySQL databases
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $offset The offset from which to return items. (optional)
     * @param  int $limit The maximum number of items to return. (optional)
     * @param  string $sort_by The field by which to sort. (optional)
     * @param  string $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $search Limit the result set to the resources whose names, partially and case insensitively, match the specified search term. E.g. for websites, this is their domain or tag, for databases the database name, for emails the email address or mailbox name, etc. A website will also be returned if the search term exactly matches the website&#39;s uuid. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrgMySQLDBs'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\MySQLDBsListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOrgMySQLDBsWithHttpInfo($org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, $search = null, string $contentType = self::contentTypes['getOrgMySQLDBs'][0])
    {
        $request = $this->getOrgMySQLDBsRequest($org_id, $offset, $limit, $sort_by, $sort_order, $search, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\MySQLDBsListing' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\MySQLDBsListing' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\MySQLDBsListing', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\MySQLDBsListing';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\MySQLDBsListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getOrgMySQLDBsAsync
     *
     * Get org&#39;s MySQL databases
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $offset The offset from which to return items. (optional)
     * @param  int $limit The maximum number of items to return. (optional)
     * @param  string $sort_by The field by which to sort. (optional)
     * @param  string $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $search Limit the result set to the resources whose names, partially and case insensitively, match the specified search term. E.g. for websites, this is their domain or tag, for databases the database name, for emails the email address or mailbox name, etc. A website will also be returned if the search term exactly matches the website&#39;s uuid. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrgMySQLDBs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrgMySQLDBsAsync($org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, $search = null, string $contentType = self::contentTypes['getOrgMySQLDBs'][0])
    {
        return $this->getOrgMySQLDBsAsyncWithHttpInfo($org_id, $offset, $limit, $sort_by, $sort_order, $search, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOrgMySQLDBsAsyncWithHttpInfo
     *
     * Get org&#39;s MySQL databases
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $offset The offset from which to return items. (optional)
     * @param  int $limit The maximum number of items to return. (optional)
     * @param  string $sort_by The field by which to sort. (optional)
     * @param  string $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $search Limit the result set to the resources whose names, partially and case insensitively, match the specified search term. E.g. for websites, this is their domain or tag, for databases the database name, for emails the email address or mailbox name, etc. A website will also be returned if the search term exactly matches the website&#39;s uuid. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrgMySQLDBs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOrgMySQLDBsAsyncWithHttpInfo($org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, $search = null, string $contentType = self::contentTypes['getOrgMySQLDBs'][0])
    {
        $returnType = '\OpenAPI\Client\Model\MySQLDBsListing';
        $request = $this->getOrgMySQLDBsRequest($org_id, $offset, $limit, $sort_by, $sort_order, $search, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getOrgMySQLDBs'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $offset The offset from which to return items. (optional)
     * @param  int $limit The maximum number of items to return. (optional)
     * @param  string $sort_by The field by which to sort. (optional)
     * @param  string $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $search Limit the result set to the resources whose names, partially and case insensitively, match the specified search term. E.g. for websites, this is their domain or tag, for databases the database name, for emails the email address or mailbox name, etc. A website will also be returned if the search term exactly matches the website&#39;s uuid. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getOrgMySQLDBs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getOrgMySQLDBsRequest($org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, $search = null, string $contentType = self::contentTypes['getOrgMySQLDBs'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getOrgMySQLDBs'
            );
        }







        $resourcePath = '/orgs/{org_id}/mysql-dbs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $offset,
            'offset', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_by,
            'sortBy', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_order,
            'sortOrder', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $search,
            'search', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPhpMyAdminSSOUrl
     *
     * Get phpMyAdmin SSO URL
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPhpMyAdminSSOUrl'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return string
     */
    public function getPhpMyAdminSSOUrl($org_id, $website_id, $db_id, string $contentType = self::contentTypes['getPhpMyAdminSSOUrl'][0])
    {
        list($response) = $this->getPhpMyAdminSSOUrlWithHttpInfo($org_id, $website_id, $db_id, $contentType);
        return $response;
    }

    /**
     * Operation getPhpMyAdminSSOUrlWithHttpInfo
     *
     * Get phpMyAdmin SSO URL
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPhpMyAdminSSOUrl'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPhpMyAdminSSOUrlWithHttpInfo($org_id, $website_id, $db_id, string $contentType = self::contentTypes['getPhpMyAdminSSOUrl'][0])
    {
        $request = $this->getPhpMyAdminSSOUrlRequest($org_id, $website_id, $db_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'string';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPhpMyAdminSSOUrlAsync
     *
     * Get phpMyAdmin SSO URL
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPhpMyAdminSSOUrl'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPhpMyAdminSSOUrlAsync($org_id, $website_id, $db_id, string $contentType = self::contentTypes['getPhpMyAdminSSOUrl'][0])
    {
        return $this->getPhpMyAdminSSOUrlAsyncWithHttpInfo($org_id, $website_id, $db_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPhpMyAdminSSOUrlAsyncWithHttpInfo
     *
     * Get phpMyAdmin SSO URL
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPhpMyAdminSSOUrl'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPhpMyAdminSSOUrlAsyncWithHttpInfo($org_id, $website_id, $db_id, string $contentType = self::contentTypes['getPhpMyAdminSSOUrl'][0])
    {
        $returnType = 'string';
        $request = $this->getPhpMyAdminSSOUrlRequest($org_id, $website_id, $db_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPhpMyAdminSSOUrl'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPhpMyAdminSSOUrl'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPhpMyAdminSSOUrlRequest($org_id, $website_id, $db_id, string $contentType = self::contentTypes['getPhpMyAdminSSOUrl'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getPhpMyAdminSSOUrl'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling getPhpMyAdminSSOUrl'
            );
        }

        // verify the required parameter 'db_id' is set
        if ($db_id === null || (is_array($db_id) && count($db_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $db_id when calling getPhpMyAdminSSOUrl'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/mysql-dbs/{db_id}/sso';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($db_id !== null) {
            $resourcePath = str_replace(
                '{' . 'db_id' . '}',
                ObjectSerializer::toPathValue($db_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWebsiteMySQLDBs
     *
     * Get website MySQL databases
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteMySQLDBs'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\MySQLDBsFullListing
     */
    public function getWebsiteMySQLDBs($org_id, $website_id, string $contentType = self::contentTypes['getWebsiteMySQLDBs'][0])
    {
        list($response) = $this->getWebsiteMySQLDBsWithHttpInfo($org_id, $website_id, $contentType);
        return $response;
    }

    /**
     * Operation getWebsiteMySQLDBsWithHttpInfo
     *
     * Get website MySQL databases
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteMySQLDBs'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\MySQLDBsFullListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWebsiteMySQLDBsWithHttpInfo($org_id, $website_id, string $contentType = self::contentTypes['getWebsiteMySQLDBs'][0])
    {
        $request = $this->getWebsiteMySQLDBsRequest($org_id, $website_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\MySQLDBsFullListing' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\MySQLDBsFullListing' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\MySQLDBsFullListing', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\MySQLDBsFullListing';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\MySQLDBsFullListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getWebsiteMySQLDBsAsync
     *
     * Get website MySQL databases
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteMySQLDBs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteMySQLDBsAsync($org_id, $website_id, string $contentType = self::contentTypes['getWebsiteMySQLDBs'][0])
    {
        return $this->getWebsiteMySQLDBsAsyncWithHttpInfo($org_id, $website_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWebsiteMySQLDBsAsyncWithHttpInfo
     *
     * Get website MySQL databases
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteMySQLDBs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteMySQLDBsAsyncWithHttpInfo($org_id, $website_id, string $contentType = self::contentTypes['getWebsiteMySQLDBs'][0])
    {
        $returnType = '\OpenAPI\Client\Model\MySQLDBsFullListing';
        $request = $this->getWebsiteMySQLDBsRequest($org_id, $website_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWebsiteMySQLDBs'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteMySQLDBs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWebsiteMySQLDBsRequest($org_id, $website_id, string $contentType = self::contentTypes['getWebsiteMySQLDBs'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getWebsiteMySQLDBs'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling getWebsiteMySQLDBs'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/mysql-dbs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWebsiteMySQLUsers
     *
     * Get website MySQL database users
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteMySQLUsers'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\MySQLUsersFullListing
     */
    public function getWebsiteMySQLUsers($org_id, $website_id, string $contentType = self::contentTypes['getWebsiteMySQLUsers'][0])
    {
        list($response) = $this->getWebsiteMySQLUsersWithHttpInfo($org_id, $website_id, $contentType);
        return $response;
    }

    /**
     * Operation getWebsiteMySQLUsersWithHttpInfo
     *
     * Get website MySQL database users
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteMySQLUsers'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\MySQLUsersFullListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWebsiteMySQLUsersWithHttpInfo($org_id, $website_id, string $contentType = self::contentTypes['getWebsiteMySQLUsers'][0])
    {
        $request = $this->getWebsiteMySQLUsersRequest($org_id, $website_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\MySQLUsersFullListing' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\MySQLUsersFullListing' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\MySQLUsersFullListing', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\MySQLUsersFullListing';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\MySQLUsersFullListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getWebsiteMySQLUsersAsync
     *
     * Get website MySQL database users
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteMySQLUsers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteMySQLUsersAsync($org_id, $website_id, string $contentType = self::contentTypes['getWebsiteMySQLUsers'][0])
    {
        return $this->getWebsiteMySQLUsersAsyncWithHttpInfo($org_id, $website_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWebsiteMySQLUsersAsyncWithHttpInfo
     *
     * Get website MySQL database users
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteMySQLUsers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteMySQLUsersAsyncWithHttpInfo($org_id, $website_id, string $contentType = self::contentTypes['getWebsiteMySQLUsers'][0])
    {
        $returnType = '\OpenAPI\Client\Model\MySQLUsersFullListing';
        $request = $this->getWebsiteMySQLUsersRequest($org_id, $website_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWebsiteMySQLUsers'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteMySQLUsers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWebsiteMySQLUsersRequest($org_id, $website_id, string $contentType = self::contentTypes['getWebsiteMySQLUsers'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getWebsiteMySQLUsers'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling getWebsiteMySQLUsers'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/mysql-users';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateWebsiteMySQLUser
     *
     * Update website MySQL database user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserUpdate $my_sql_user_update User update details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsiteMySQLUser'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateWebsiteMySQLUser($org_id, $website_id, $user_id, $my_sql_user_update, string $contentType = self::contentTypes['updateWebsiteMySQLUser'][0])
    {
        $this->updateWebsiteMySQLUserWithHttpInfo($org_id, $website_id, $user_id, $my_sql_user_update, $contentType);
    }

    /**
     * Operation updateWebsiteMySQLUserWithHttpInfo
     *
     * Update website MySQL database user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserUpdate $my_sql_user_update User update details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsiteMySQLUser'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWebsiteMySQLUserWithHttpInfo($org_id, $website_id, $user_id, $my_sql_user_update, string $contentType = self::contentTypes['updateWebsiteMySQLUser'][0])
    {
        $request = $this->updateWebsiteMySQLUserRequest($org_id, $website_id, $user_id, $my_sql_user_update, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation updateWebsiteMySQLUserAsync
     *
     * Update website MySQL database user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserUpdate $my_sql_user_update User update details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsiteMySQLUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWebsiteMySQLUserAsync($org_id, $website_id, $user_id, $my_sql_user_update, string $contentType = self::contentTypes['updateWebsiteMySQLUser'][0])
    {
        return $this->updateWebsiteMySQLUserAsyncWithHttpInfo($org_id, $website_id, $user_id, $my_sql_user_update, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateWebsiteMySQLUserAsyncWithHttpInfo
     *
     * Update website MySQL database user
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserUpdate $my_sql_user_update User update details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsiteMySQLUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWebsiteMySQLUserAsyncWithHttpInfo($org_id, $website_id, $user_id, $my_sql_user_update, string $contentType = self::contentTypes['updateWebsiteMySQLUser'][0])
    {
        $returnType = '';
        $request = $this->updateWebsiteMySQLUserRequest($org_id, $website_id, $user_id, $my_sql_user_update, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateWebsiteMySQLUser'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $user_id The id of the database user. (required)
     * @param  \OpenAPI\Client\Model\MySQLUserUpdate $my_sql_user_update User update details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsiteMySQLUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateWebsiteMySQLUserRequest($org_id, $website_id, $user_id, $my_sql_user_update, string $contentType = self::contentTypes['updateWebsiteMySQLUser'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling updateWebsiteMySQLUser'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling updateWebsiteMySQLUser'
            );
        }

        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling updateWebsiteMySQLUser'
            );
        }

        // verify the required parameter 'my_sql_user_update' is set
        if ($my_sql_user_update === null || (is_array($my_sql_user_update) && count($my_sql_user_update) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $my_sql_user_update when calling updateWebsiteMySQLUser'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/mysql-users/{user_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'user_id' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($my_sql_user_update)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($my_sql_user_update));
            } else {
                $httpBody = $my_sql_user_update;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation uploadSql
     *
     * Uploads sql file and executes it against db
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  \SplFileObject $sql Upload either a raw sql file (must be utf8 valid string) or .zip or .gz file with the sql string. (required)
     * @param  bool $force force (optional, default to false)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadSql'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function uploadSql($org_id, $website_id, $db_id, $sql, $force = false, string $contentType = self::contentTypes['uploadSql'][0])
    {
        $this->uploadSqlWithHttpInfo($org_id, $website_id, $db_id, $sql, $force, $contentType);
    }

    /**
     * Operation uploadSqlWithHttpInfo
     *
     * Uploads sql file and executes it against db
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  \SplFileObject $sql Upload either a raw sql file (must be utf8 valid string) or .zip or .gz file with the sql string. (required)
     * @param  bool $force (optional, default to false)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadSql'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadSqlWithHttpInfo($org_id, $website_id, $db_id, $sql, $force = false, string $contentType = self::contentTypes['uploadSql'][0])
    {
        $request = $this->uploadSqlRequest($org_id, $website_id, $db_id, $sql, $force, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation uploadSqlAsync
     *
     * Uploads sql file and executes it against db
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  \SplFileObject $sql Upload either a raw sql file (must be utf8 valid string) or .zip or .gz file with the sql string. (required)
     * @param  bool $force (optional, default to false)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadSql'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadSqlAsync($org_id, $website_id, $db_id, $sql, $force = false, string $contentType = self::contentTypes['uploadSql'][0])
    {
        return $this->uploadSqlAsyncWithHttpInfo($org_id, $website_id, $db_id, $sql, $force, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation uploadSqlAsyncWithHttpInfo
     *
     * Uploads sql file and executes it against db
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  \SplFileObject $sql Upload either a raw sql file (must be utf8 valid string) or .zip or .gz file with the sql string. (required)
     * @param  bool $force (optional, default to false)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadSql'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadSqlAsyncWithHttpInfo($org_id, $website_id, $db_id, $sql, $force = false, string $contentType = self::contentTypes['uploadSql'][0])
    {
        $returnType = '';
        $request = $this->uploadSqlRequest($org_id, $website_id, $db_id, $sql, $force, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'uploadSql'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $db_id The id of the database. (required)
     * @param  \SplFileObject $sql Upload either a raw sql file (must be utf8 valid string) or .zip or .gz file with the sql string. (required)
     * @param  bool $force (optional, default to false)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadSql'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function uploadSqlRequest($org_id, $website_id, $db_id, $sql, $force = false, string $contentType = self::contentTypes['uploadSql'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling uploadSql'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling uploadSql'
            );
        }

        // verify the required parameter 'db_id' is set
        if ($db_id === null || (is_array($db_id) && count($db_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $db_id when calling uploadSql'
            );
        }

        // verify the required parameter 'sql' is set
        if ($sql === null || (is_array($sql) && count($sql) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $sql when calling uploadSql'
            );
        }



        $resourcePath = '/orgs/{org_id}/websites/{website_id}/mysql-dbs/{db_id}/sql';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $force,
            'force', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($db_id !== null) {
            $resourcePath = str_replace(
                '{' . 'db_id' . '}',
                ObjectSerializer::toPathValue($db_id),
                $resourcePath
            );
        }

        // form params
        if ($sql !== null) {
            $multipart = true;
            $formParams['sql'] = [];
            $paramFiles = is_array($sql) ? $sql : [$sql];
            foreach ($paramFiles as $paramFile) {
                $formParams['sql'][] = \GuzzleHttp\Psr7\Utils::tryFopen(
                    ObjectSerializer::toFormValue($paramFile),
                    'rb'
                );
            }
        }

        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
