<?php
/**
 * PlansApi
 * PHP version 7.4
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 9.1.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\ObjectSerializer;

/**
 * PlansApi Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class PlansApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createPlan' => [
            'application/json',
        ],
        'createPlanAllowances' => [
            'application/json',
        ],
        'createPlanResources' => [
            'application/json',
        ],
        'createPlanSelections' => [
            'application/json',
        ],
        'deletePlan' => [
            'application/json',
        ],
        'deletePlanAllowance' => [
            'application/json',
        ],
        'getPlan' => [
            'application/json',
        ],
        'getPlans' => [
            'application/json',
        ],
        'updatePlan' => [
            'application/json',
        ],
        'updatePlanAllowance' => [
            'application/json',
        ],
        'updatePlanResource' => [
            'application/json',
        ],
        'updatePlanSelection' => [
            'application/json',
        ],
    ];

/**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createPlan
     *
     * Create plan
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewPlan $new_plan New plan details (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPlan'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\NewResourceId
     */
    public function createPlan($org_id, $new_plan, string $contentType = self::contentTypes['createPlan'][0])
    {
        list($response) = $this->createPlanWithHttpInfo($org_id, $new_plan, $contentType);
        return $response;
    }

    /**
     * Operation createPlanWithHttpInfo
     *
     * Create plan
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewPlan $new_plan New plan details (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPlan'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\NewResourceId, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPlanWithHttpInfo($org_id, $new_plan, string $contentType = self::contentTypes['createPlan'][0])
    {
        $request = $this->createPlanRequest($org_id, $new_plan, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\OpenAPI\Client\Model\NewResourceId' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\NewResourceId' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\NewResourceId', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\NewResourceId';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\NewResourceId',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPlanAsync
     *
     * Create plan
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewPlan $new_plan New plan details (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPlan'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPlanAsync($org_id, $new_plan, string $contentType = self::contentTypes['createPlan'][0])
    {
        return $this->createPlanAsyncWithHttpInfo($org_id, $new_plan, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPlanAsyncWithHttpInfo
     *
     * Create plan
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewPlan $new_plan New plan details (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPlan'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPlanAsyncWithHttpInfo($org_id, $new_plan, string $contentType = self::contentTypes['createPlan'][0])
    {
        $returnType = '\OpenAPI\Client\Model\NewResourceId';
        $request = $this->createPlanRequest($org_id, $new_plan, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPlan'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewPlan $new_plan New plan details (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPlan'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createPlanRequest($org_id, $new_plan, string $contentType = self::contentTypes['createPlan'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling createPlan'
            );
        }

        // verify the required parameter 'new_plan' is set
        if ($new_plan === null || (is_array($new_plan) && count($new_plan) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $new_plan when calling createPlan'
            );
        }


        $resourcePath = '/orgs/{org_id}/plans';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($new_plan)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($new_plan));
            } else {
                $httpBody = $new_plan;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPlanAllowances
     *
     * Create plan allowances
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  \OpenAPI\Client\Model\Allowance[] $allowance allowance (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPlanAllowances'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createPlanAllowances($org_id, $plan_id, $allowance, string $contentType = self::contentTypes['createPlanAllowances'][0])
    {
        $this->createPlanAllowancesWithHttpInfo($org_id, $plan_id, $allowance, $contentType);
    }

    /**
     * Operation createPlanAllowancesWithHttpInfo
     *
     * Create plan allowances
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  \OpenAPI\Client\Model\Allowance[] $allowance (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPlanAllowances'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPlanAllowancesWithHttpInfo($org_id, $plan_id, $allowance, string $contentType = self::contentTypes['createPlanAllowances'][0])
    {
        $request = $this->createPlanAllowancesRequest($org_id, $plan_id, $allowance, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createPlanAllowancesAsync
     *
     * Create plan allowances
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  \OpenAPI\Client\Model\Allowance[] $allowance (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPlanAllowances'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPlanAllowancesAsync($org_id, $plan_id, $allowance, string $contentType = self::contentTypes['createPlanAllowances'][0])
    {
        return $this->createPlanAllowancesAsyncWithHttpInfo($org_id, $plan_id, $allowance, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPlanAllowancesAsyncWithHttpInfo
     *
     * Create plan allowances
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  \OpenAPI\Client\Model\Allowance[] $allowance (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPlanAllowances'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPlanAllowancesAsyncWithHttpInfo($org_id, $plan_id, $allowance, string $contentType = self::contentTypes['createPlanAllowances'][0])
    {
        $returnType = '';
        $request = $this->createPlanAllowancesRequest($org_id, $plan_id, $allowance, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPlanAllowances'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  \OpenAPI\Client\Model\Allowance[] $allowance (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPlanAllowances'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createPlanAllowancesRequest($org_id, $plan_id, $allowance, string $contentType = self::contentTypes['createPlanAllowances'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling createPlanAllowances'
            );
        }

        // verify the required parameter 'plan_id' is set
        if ($plan_id === null || (is_array($plan_id) && count($plan_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $plan_id when calling createPlanAllowances'
            );
        }

        // verify the required parameter 'allowance' is set
        if ($allowance === null || (is_array($allowance) && count($allowance) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $allowance when calling createPlanAllowances'
            );
        }


        $resourcePath = '/orgs/{org_id}/plans/{plan_id}/allowances';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($plan_id !== null) {
            $resourcePath = str_replace(
                '{' . 'plan_id' . '}',
                ObjectSerializer::toPathValue($plan_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($allowance)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($allowance));
            } else {
                $httpBody = $allowance;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPlanResources
     *
     * Create plan resources
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  \OpenAPI\Client\Model\Resource[] $resource resource (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPlanResources'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createPlanResources($org_id, $plan_id, $resource, string $contentType = self::contentTypes['createPlanResources'][0])
    {
        $this->createPlanResourcesWithHttpInfo($org_id, $plan_id, $resource, $contentType);
    }

    /**
     * Operation createPlanResourcesWithHttpInfo
     *
     * Create plan resources
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  \OpenAPI\Client\Model\Resource[] $resource (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPlanResources'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPlanResourcesWithHttpInfo($org_id, $plan_id, $resource, string $contentType = self::contentTypes['createPlanResources'][0])
    {
        $request = $this->createPlanResourcesRequest($org_id, $plan_id, $resource, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createPlanResourcesAsync
     *
     * Create plan resources
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  \OpenAPI\Client\Model\Resource[] $resource (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPlanResources'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPlanResourcesAsync($org_id, $plan_id, $resource, string $contentType = self::contentTypes['createPlanResources'][0])
    {
        return $this->createPlanResourcesAsyncWithHttpInfo($org_id, $plan_id, $resource, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPlanResourcesAsyncWithHttpInfo
     *
     * Create plan resources
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  \OpenAPI\Client\Model\Resource[] $resource (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPlanResources'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPlanResourcesAsyncWithHttpInfo($org_id, $plan_id, $resource, string $contentType = self::contentTypes['createPlanResources'][0])
    {
        $returnType = '';
        $request = $this->createPlanResourcesRequest($org_id, $plan_id, $resource, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPlanResources'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  \OpenAPI\Client\Model\Resource[] $resource (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPlanResources'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createPlanResourcesRequest($org_id, $plan_id, $resource, string $contentType = self::contentTypes['createPlanResources'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling createPlanResources'
            );
        }

        // verify the required parameter 'plan_id' is set
        if ($plan_id === null || (is_array($plan_id) && count($plan_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $plan_id when calling createPlanResources'
            );
        }

        // verify the required parameter 'resource' is set
        if ($resource === null || (is_array($resource) && count($resource) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $resource when calling createPlanResources'
            );
        }


        $resourcePath = '/orgs/{org_id}/plans/{plan_id}/resources';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($plan_id !== null) {
            $resourcePath = str_replace(
                '{' . 'plan_id' . '}',
                ObjectSerializer::toPathValue($plan_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($resource)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($resource));
            } else {
                $httpBody = $resource;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPlanSelections
     *
     * Create plan selections
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  \OpenAPI\Client\Model\Selection[] $selection selection (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPlanSelections'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createPlanSelections($org_id, $plan_id, $selection, string $contentType = self::contentTypes['createPlanSelections'][0])
    {
        $this->createPlanSelectionsWithHttpInfo($org_id, $plan_id, $selection, $contentType);
    }

    /**
     * Operation createPlanSelectionsWithHttpInfo
     *
     * Create plan selections
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  \OpenAPI\Client\Model\Selection[] $selection (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPlanSelections'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPlanSelectionsWithHttpInfo($org_id, $plan_id, $selection, string $contentType = self::contentTypes['createPlanSelections'][0])
    {
        $request = $this->createPlanSelectionsRequest($org_id, $plan_id, $selection, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createPlanSelectionsAsync
     *
     * Create plan selections
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  \OpenAPI\Client\Model\Selection[] $selection (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPlanSelections'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPlanSelectionsAsync($org_id, $plan_id, $selection, string $contentType = self::contentTypes['createPlanSelections'][0])
    {
        return $this->createPlanSelectionsAsyncWithHttpInfo($org_id, $plan_id, $selection, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPlanSelectionsAsyncWithHttpInfo
     *
     * Create plan selections
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  \OpenAPI\Client\Model\Selection[] $selection (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPlanSelections'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPlanSelectionsAsyncWithHttpInfo($org_id, $plan_id, $selection, string $contentType = self::contentTypes['createPlanSelections'][0])
    {
        $returnType = '';
        $request = $this->createPlanSelectionsRequest($org_id, $plan_id, $selection, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPlanSelections'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  \OpenAPI\Client\Model\Selection[] $selection (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPlanSelections'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createPlanSelectionsRequest($org_id, $plan_id, $selection, string $contentType = self::contentTypes['createPlanSelections'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling createPlanSelections'
            );
        }

        // verify the required parameter 'plan_id' is set
        if ($plan_id === null || (is_array($plan_id) && count($plan_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $plan_id when calling createPlanSelections'
            );
        }

        // verify the required parameter 'selection' is set
        if ($selection === null || (is_array($selection) && count($selection) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $selection when calling createPlanSelections'
            );
        }


        $resourcePath = '/orgs/{org_id}/plans/{plan_id}/selections';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($plan_id !== null) {
            $resourcePath = str_replace(
                '{' . 'plan_id' . '}',
                ObjectSerializer::toPathValue($plan_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($selection)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($selection));
            } else {
                $httpBody = $selection;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deletePlan
     *
     * Delete plan
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePlan'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deletePlan($org_id, $plan_id, string $contentType = self::contentTypes['deletePlan'][0])
    {
        $this->deletePlanWithHttpInfo($org_id, $plan_id, $contentType);
    }

    /**
     * Operation deletePlanWithHttpInfo
     *
     * Delete plan
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePlan'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePlanWithHttpInfo($org_id, $plan_id, string $contentType = self::contentTypes['deletePlan'][0])
    {
        $request = $this->deletePlanRequest($org_id, $plan_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deletePlanAsync
     *
     * Delete plan
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePlan'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePlanAsync($org_id, $plan_id, string $contentType = self::contentTypes['deletePlan'][0])
    {
        return $this->deletePlanAsyncWithHttpInfo($org_id, $plan_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deletePlanAsyncWithHttpInfo
     *
     * Delete plan
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePlan'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePlanAsyncWithHttpInfo($org_id, $plan_id, string $contentType = self::contentTypes['deletePlan'][0])
    {
        $returnType = '';
        $request = $this->deletePlanRequest($org_id, $plan_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deletePlan'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePlan'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deletePlanRequest($org_id, $plan_id, string $contentType = self::contentTypes['deletePlan'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deletePlan'
            );
        }

        // verify the required parameter 'plan_id' is set
        if ($plan_id === null || (is_array($plan_id) && count($plan_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $plan_id when calling deletePlan'
            );
        }


        $resourcePath = '/orgs/{org_id}/plans/{plan_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($plan_id !== null) {
            $resourcePath = str_replace(
                '{' . 'plan_id' . '}',
                ObjectSerializer::toPathValue($plan_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deletePlanAllowance
     *
     * Delete plan allowance
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $name The name of the allowance. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePlanAllowance'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deletePlanAllowance($org_id, $plan_id, $name, string $contentType = self::contentTypes['deletePlanAllowance'][0])
    {
        $this->deletePlanAllowanceWithHttpInfo($org_id, $plan_id, $name, $contentType);
    }

    /**
     * Operation deletePlanAllowanceWithHttpInfo
     *
     * Delete plan allowance
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $name The name of the allowance. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePlanAllowance'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePlanAllowanceWithHttpInfo($org_id, $plan_id, $name, string $contentType = self::contentTypes['deletePlanAllowance'][0])
    {
        $request = $this->deletePlanAllowanceRequest($org_id, $plan_id, $name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deletePlanAllowanceAsync
     *
     * Delete plan allowance
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $name The name of the allowance. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePlanAllowance'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePlanAllowanceAsync($org_id, $plan_id, $name, string $contentType = self::contentTypes['deletePlanAllowance'][0])
    {
        return $this->deletePlanAllowanceAsyncWithHttpInfo($org_id, $plan_id, $name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deletePlanAllowanceAsyncWithHttpInfo
     *
     * Delete plan allowance
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $name The name of the allowance. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePlanAllowance'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePlanAllowanceAsyncWithHttpInfo($org_id, $plan_id, $name, string $contentType = self::contentTypes['deletePlanAllowance'][0])
    {
        $returnType = '';
        $request = $this->deletePlanAllowanceRequest($org_id, $plan_id, $name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deletePlanAllowance'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $name The name of the allowance. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePlanAllowance'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deletePlanAllowanceRequest($org_id, $plan_id, $name, string $contentType = self::contentTypes['deletePlanAllowance'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deletePlanAllowance'
            );
        }

        // verify the required parameter 'plan_id' is set
        if ($plan_id === null || (is_array($plan_id) && count($plan_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $plan_id when calling deletePlanAllowance'
            );
        }

        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling deletePlanAllowance'
            );
        }


        $resourcePath = '/orgs/{org_id}/plans/{plan_id}/allowances/{name}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($plan_id !== null) {
            $resourcePath = str_replace(
                '{' . 'plan_id' . '}',
                ObjectSerializer::toPathValue($plan_id),
                $resourcePath
            );
        }
        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                '{' . 'name' . '}',
                ObjectSerializer::toPathValue($name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPlan
     *
     * Get plan
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPlan'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Plan
     */
    public function getPlan($org_id, $plan_id, string $contentType = self::contentTypes['getPlan'][0])
    {
        list($response) = $this->getPlanWithHttpInfo($org_id, $plan_id, $contentType);
        return $response;
    }

    /**
     * Operation getPlanWithHttpInfo
     *
     * Get plan
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPlan'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Plan, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPlanWithHttpInfo($org_id, $plan_id, string $contentType = self::contentTypes['getPlan'][0])
    {
        $request = $this->getPlanRequest($org_id, $plan_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\Plan' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\Plan' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\Plan', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\Plan';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Plan',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPlanAsync
     *
     * Get plan
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPlan'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPlanAsync($org_id, $plan_id, string $contentType = self::contentTypes['getPlan'][0])
    {
        return $this->getPlanAsyncWithHttpInfo($org_id, $plan_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPlanAsyncWithHttpInfo
     *
     * Get plan
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPlan'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPlanAsyncWithHttpInfo($org_id, $plan_id, string $contentType = self::contentTypes['getPlan'][0])
    {
        $returnType = '\OpenAPI\Client\Model\Plan';
        $request = $this->getPlanRequest($org_id, $plan_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPlan'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPlan'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPlanRequest($org_id, $plan_id, string $contentType = self::contentTypes['getPlan'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getPlan'
            );
        }

        // verify the required parameter 'plan_id' is set
        if ($plan_id === null || (is_array($plan_id) && count($plan_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $plan_id when calling getPlan'
            );
        }


        $resourcePath = '/orgs/{org_id}/plans/{plan_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($plan_id !== null) {
            $resourcePath = str_replace(
                '{' . 'plan_id' . '}',
                ObjectSerializer::toPathValue($plan_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPlans
     *
     * Get plans
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $offset The offset from which to return items. (optional)
     * @param  int $limit The maximum number of items to return. (optional)
     * @param  string $sort_by The field by which to sort. (optional)
     * @param  string $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPlans'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\PlansListing
     */
    public function getPlans($org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, string $contentType = self::contentTypes['getPlans'][0])
    {
        list($response) = $this->getPlansWithHttpInfo($org_id, $offset, $limit, $sort_by, $sort_order, $contentType);
        return $response;
    }

    /**
     * Operation getPlansWithHttpInfo
     *
     * Get plans
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $offset The offset from which to return items. (optional)
     * @param  int $limit The maximum number of items to return. (optional)
     * @param  string $sort_by The field by which to sort. (optional)
     * @param  string $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPlans'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\PlansListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPlansWithHttpInfo($org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, string $contentType = self::contentTypes['getPlans'][0])
    {
        $request = $this->getPlansRequest($org_id, $offset, $limit, $sort_by, $sort_order, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\OpenAPI\Client\Model\PlansListing' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\OpenAPI\Client\Model\PlansListing' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\OpenAPI\Client\Model\PlansListing', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\OpenAPI\Client\Model\PlansListing';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\PlansListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPlansAsync
     *
     * Get plans
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $offset The offset from which to return items. (optional)
     * @param  int $limit The maximum number of items to return. (optional)
     * @param  string $sort_by The field by which to sort. (optional)
     * @param  string $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPlans'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPlansAsync($org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, string $contentType = self::contentTypes['getPlans'][0])
    {
        return $this->getPlansAsyncWithHttpInfo($org_id, $offset, $limit, $sort_by, $sort_order, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPlansAsyncWithHttpInfo
     *
     * Get plans
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $offset The offset from which to return items. (optional)
     * @param  int $limit The maximum number of items to return. (optional)
     * @param  string $sort_by The field by which to sort. (optional)
     * @param  string $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPlans'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPlansAsyncWithHttpInfo($org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, string $contentType = self::contentTypes['getPlans'][0])
    {
        $returnType = '\OpenAPI\Client\Model\PlansListing';
        $request = $this->getPlansRequest($org_id, $offset, $limit, $sort_by, $sort_order, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPlans'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $offset The offset from which to return items. (optional)
     * @param  int $limit The maximum number of items to return. (optional)
     * @param  string $sort_by The field by which to sort. (optional)
     * @param  string $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPlans'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPlansRequest($org_id, $offset = null, $limit = null, $sort_by = null, $sort_order = null, string $contentType = self::contentTypes['getPlans'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getPlans'
            );
        }






        $resourcePath = '/orgs/{org_id}/plans';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $offset,
            'offset', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_by,
            'sortBy', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_order,
            'sortOrder', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updatePlan
     *
     * Update plan name
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  \OpenAPI\Client\Model\UpdatePlan $update_plan update_plan (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePlan'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updatePlan($org_id, $plan_id, $update_plan, string $contentType = self::contentTypes['updatePlan'][0])
    {
        $this->updatePlanWithHttpInfo($org_id, $plan_id, $update_plan, $contentType);
    }

    /**
     * Operation updatePlanWithHttpInfo
     *
     * Update plan name
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  \OpenAPI\Client\Model\UpdatePlan $update_plan (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePlan'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePlanWithHttpInfo($org_id, $plan_id, $update_plan, string $contentType = self::contentTypes['updatePlan'][0])
    {
        $request = $this->updatePlanRequest($org_id, $plan_id, $update_plan, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation updatePlanAsync
     *
     * Update plan name
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  \OpenAPI\Client\Model\UpdatePlan $update_plan (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePlan'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePlanAsync($org_id, $plan_id, $update_plan, string $contentType = self::contentTypes['updatePlan'][0])
    {
        return $this->updatePlanAsyncWithHttpInfo($org_id, $plan_id, $update_plan, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updatePlanAsyncWithHttpInfo
     *
     * Update plan name
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  \OpenAPI\Client\Model\UpdatePlan $update_plan (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePlan'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePlanAsyncWithHttpInfo($org_id, $plan_id, $update_plan, string $contentType = self::contentTypes['updatePlan'][0])
    {
        $returnType = '';
        $request = $this->updatePlanRequest($org_id, $plan_id, $update_plan, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePlan'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  \OpenAPI\Client\Model\UpdatePlan $update_plan (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePlan'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updatePlanRequest($org_id, $plan_id, $update_plan, string $contentType = self::contentTypes['updatePlan'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling updatePlan'
            );
        }

        // verify the required parameter 'plan_id' is set
        if ($plan_id === null || (is_array($plan_id) && count($plan_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $plan_id when calling updatePlan'
            );
        }

        // verify the required parameter 'update_plan' is set
        if ($update_plan === null || (is_array($update_plan) && count($update_plan) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_plan when calling updatePlan'
            );
        }


        $resourcePath = '/orgs/{org_id}/plans/{plan_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($plan_id !== null) {
            $resourcePath = str_replace(
                '{' . 'plan_id' . '}',
                ObjectSerializer::toPathValue($plan_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($update_plan)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_plan));
            } else {
                $httpBody = $update_plan;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updatePlanAllowance
     *
     * Update plan allowance
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $name The name of the allowance. (required)
     * @param  \OpenAPI\Client\Model\Allowance $allowance allowance (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePlanAllowance'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updatePlanAllowance($org_id, $plan_id, $name, $allowance, string $contentType = self::contentTypes['updatePlanAllowance'][0])
    {
        $this->updatePlanAllowanceWithHttpInfo($org_id, $plan_id, $name, $allowance, $contentType);
    }

    /**
     * Operation updatePlanAllowanceWithHttpInfo
     *
     * Update plan allowance
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $name The name of the allowance. (required)
     * @param  \OpenAPI\Client\Model\Allowance $allowance (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePlanAllowance'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePlanAllowanceWithHttpInfo($org_id, $plan_id, $name, $allowance, string $contentType = self::contentTypes['updatePlanAllowance'][0])
    {
        $request = $this->updatePlanAllowanceRequest($org_id, $plan_id, $name, $allowance, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation updatePlanAllowanceAsync
     *
     * Update plan allowance
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $name The name of the allowance. (required)
     * @param  \OpenAPI\Client\Model\Allowance $allowance (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePlanAllowance'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePlanAllowanceAsync($org_id, $plan_id, $name, $allowance, string $contentType = self::contentTypes['updatePlanAllowance'][0])
    {
        return $this->updatePlanAllowanceAsyncWithHttpInfo($org_id, $plan_id, $name, $allowance, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updatePlanAllowanceAsyncWithHttpInfo
     *
     * Update plan allowance
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $name The name of the allowance. (required)
     * @param  \OpenAPI\Client\Model\Allowance $allowance (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePlanAllowance'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePlanAllowanceAsyncWithHttpInfo($org_id, $plan_id, $name, $allowance, string $contentType = self::contentTypes['updatePlanAllowance'][0])
    {
        $returnType = '';
        $request = $this->updatePlanAllowanceRequest($org_id, $plan_id, $name, $allowance, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePlanAllowance'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $name The name of the allowance. (required)
     * @param  \OpenAPI\Client\Model\Allowance $allowance (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePlanAllowance'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updatePlanAllowanceRequest($org_id, $plan_id, $name, $allowance, string $contentType = self::contentTypes['updatePlanAllowance'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling updatePlanAllowance'
            );
        }

        // verify the required parameter 'plan_id' is set
        if ($plan_id === null || (is_array($plan_id) && count($plan_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $plan_id when calling updatePlanAllowance'
            );
        }

        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling updatePlanAllowance'
            );
        }

        // verify the required parameter 'allowance' is set
        if ($allowance === null || (is_array($allowance) && count($allowance) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $allowance when calling updatePlanAllowance'
            );
        }


        $resourcePath = '/orgs/{org_id}/plans/{plan_id}/allowances/{name}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($plan_id !== null) {
            $resourcePath = str_replace(
                '{' . 'plan_id' . '}',
                ObjectSerializer::toPathValue($plan_id),
                $resourcePath
            );
        }
        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                '{' . 'name' . '}',
                ObjectSerializer::toPathValue($name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($allowance)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($allowance));
            } else {
                $httpBody = $allowance;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updatePlanResource
     *
     * Update plan resource
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $name The name of the resource. (required)
     * @param  \OpenAPI\Client\Model\Resource $resource resource (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePlanResource'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updatePlanResource($org_id, $plan_id, $name, $resource, string $contentType = self::contentTypes['updatePlanResource'][0])
    {
        $this->updatePlanResourceWithHttpInfo($org_id, $plan_id, $name, $resource, $contentType);
    }

    /**
     * Operation updatePlanResourceWithHttpInfo
     *
     * Update plan resource
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $name The name of the resource. (required)
     * @param  \OpenAPI\Client\Model\Resource $resource (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePlanResource'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePlanResourceWithHttpInfo($org_id, $plan_id, $name, $resource, string $contentType = self::contentTypes['updatePlanResource'][0])
    {
        $request = $this->updatePlanResourceRequest($org_id, $plan_id, $name, $resource, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation updatePlanResourceAsync
     *
     * Update plan resource
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $name The name of the resource. (required)
     * @param  \OpenAPI\Client\Model\Resource $resource (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePlanResource'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePlanResourceAsync($org_id, $plan_id, $name, $resource, string $contentType = self::contentTypes['updatePlanResource'][0])
    {
        return $this->updatePlanResourceAsyncWithHttpInfo($org_id, $plan_id, $name, $resource, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updatePlanResourceAsyncWithHttpInfo
     *
     * Update plan resource
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $name The name of the resource. (required)
     * @param  \OpenAPI\Client\Model\Resource $resource (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePlanResource'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePlanResourceAsyncWithHttpInfo($org_id, $plan_id, $name, $resource, string $contentType = self::contentTypes['updatePlanResource'][0])
    {
        $returnType = '';
        $request = $this->updatePlanResourceRequest($org_id, $plan_id, $name, $resource, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePlanResource'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $name The name of the resource. (required)
     * @param  \OpenAPI\Client\Model\Resource $resource (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePlanResource'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updatePlanResourceRequest($org_id, $plan_id, $name, $resource, string $contentType = self::contentTypes['updatePlanResource'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling updatePlanResource'
            );
        }

        // verify the required parameter 'plan_id' is set
        if ($plan_id === null || (is_array($plan_id) && count($plan_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $plan_id when calling updatePlanResource'
            );
        }

        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling updatePlanResource'
            );
        }

        // verify the required parameter 'resource' is set
        if ($resource === null || (is_array($resource) && count($resource) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $resource when calling updatePlanResource'
            );
        }


        $resourcePath = '/orgs/{org_id}/plans/{plan_id}/resources/{name}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($plan_id !== null) {
            $resourcePath = str_replace(
                '{' . 'plan_id' . '}',
                ObjectSerializer::toPathValue($plan_id),
                $resourcePath
            );
        }
        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                '{' . 'name' . '}',
                ObjectSerializer::toPathValue($name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($resource)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($resource));
            } else {
                $httpBody = $resource;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updatePlanSelection
     *
     * Update plan selection
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $name The name of the selection. (required)
     * @param  \OpenAPI\Client\Model\Selection $selection selection (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePlanSelection'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updatePlanSelection($org_id, $plan_id, $name, $selection, string $contentType = self::contentTypes['updatePlanSelection'][0])
    {
        $this->updatePlanSelectionWithHttpInfo($org_id, $plan_id, $name, $selection, $contentType);
    }

    /**
     * Operation updatePlanSelectionWithHttpInfo
     *
     * Update plan selection
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $name The name of the selection. (required)
     * @param  \OpenAPI\Client\Model\Selection $selection (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePlanSelection'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePlanSelectionWithHttpInfo($org_id, $plan_id, $name, $selection, string $contentType = self::contentTypes['updatePlanSelection'][0])
    {
        $request = $this->updatePlanSelectionRequest($org_id, $plan_id, $name, $selection, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation updatePlanSelectionAsync
     *
     * Update plan selection
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $name The name of the selection. (required)
     * @param  \OpenAPI\Client\Model\Selection $selection (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePlanSelection'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePlanSelectionAsync($org_id, $plan_id, $name, $selection, string $contentType = self::contentTypes['updatePlanSelection'][0])
    {
        return $this->updatePlanSelectionAsyncWithHttpInfo($org_id, $plan_id, $name, $selection, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updatePlanSelectionAsyncWithHttpInfo
     *
     * Update plan selection
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $name The name of the selection. (required)
     * @param  \OpenAPI\Client\Model\Selection $selection (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePlanSelection'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePlanSelectionAsyncWithHttpInfo($org_id, $plan_id, $name, $selection, string $contentType = self::contentTypes['updatePlanSelection'][0])
    {
        $returnType = '';
        $request = $this->updatePlanSelectionRequest($org_id, $plan_id, $name, $selection, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePlanSelection'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  int $plan_id The id of the plan. (required)
     * @param  string $name The name of the selection. (required)
     * @param  \OpenAPI\Client\Model\Selection $selection (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePlanSelection'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updatePlanSelectionRequest($org_id, $plan_id, $name, $selection, string $contentType = self::contentTypes['updatePlanSelection'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling updatePlanSelection'
            );
        }

        // verify the required parameter 'plan_id' is set
        if ($plan_id === null || (is_array($plan_id) && count($plan_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $plan_id when calling updatePlanSelection'
            );
        }

        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling updatePlanSelection'
            );
        }

        // verify the required parameter 'selection' is set
        if ($selection === null || (is_array($selection) && count($selection) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $selection when calling updatePlanSelection'
            );
        }


        $resourcePath = '/orgs/{org_id}/plans/{plan_id}/selections/{name}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($plan_id !== null) {
            $resourcePath = str_replace(
                '{' . 'plan_id' . '}',
                ObjectSerializer::toPathValue($plan_id),
                $resourcePath
            );
        }
        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                '{' . 'name' . '}',
                ObjectSerializer::toPathValue($name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($selection)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($selection));
            } else {
                $httpBody = $selection;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
