<?php
/**
 * NOTE: This class is auto generated by the swagger code generator program. 
 * https://github.com/swagger-api/swagger-codegen 
 * Do not edit the class manually.
 */

namespace SquareConnect\Api;

use \SquareConnect\Configuration;
use \SquareConnect\ApiClient;
use \SquareConnect\ApiException;
use \SquareConnect\ObjectSerializer;

/**
 * DisputesApi Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://squareup.com/developers
 */
class DisputesApi
{

    /**
     * API Client
     * @var \SquareConnect\ApiClient instance of the ApiClient
     */
    protected $apiClient;
  
    /**
     * Constructor
     * @param \SquareConnect\ApiClient|null $apiClient The api client to use
     */
    function __construct($apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://connect.squareup.com');
        }
  
        $this->apiClient = $apiClient;
    }
  
    /**
     * Get API client
     * @return \SquareConnect\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }
  
    /**
     * Set the API client
     * @param \SquareConnect\ApiClient $apiClient set the API client
     * @return DisputesApi
     */
    public function setApiClient(ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }
  
    /**
     * acceptDispute
     *
     * AcceptDispute
     * Note: This endpoint is in beta.
     *
     * @param string $dispute_id ID of the dispute you want to accept. (required)
     * @return \SquareConnect\Model\AcceptDisputeResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function acceptDispute($dispute_id)
    {
        list($response, $statusCode, $httpHeader) = $this->acceptDisputeWithHttpInfo ($dispute_id);
        return $response; 
    }


    /**
     * acceptDisputeWithHttpInfo
     *
     * AcceptDispute
     *
     * @param string $dispute_id ID of the dispute you want to accept. (required)
     * @return Array of \SquareConnect\Model\AcceptDisputeResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function acceptDisputeWithHttpInfo($dispute_id)
    {
        
        // verify the required parameter 'dispute_id' is set
        if ($dispute_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $dispute_id when calling acceptDispute');
        }
  
        // parse inputs
        $resourcePath = "/v2/disputes/{dispute_id}/accept";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        // path params
        if ($dispute_id !== null) {
            $resourcePath = str_replace(
                "{" . "dispute_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($dispute_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'POST',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\AcceptDisputeResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\AcceptDisputeResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\AcceptDisputeResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    /**
     * createDisputeEvidenceText
     *
     * CreateDisputeEvidenceText
     * Note: This endpoint is in beta.
     *
     * @param string $dispute_id The ID of the dispute you want to upload evidence for. (required)
     * @param \SquareConnect\Model\CreateDisputeEvidenceTextRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return \SquareConnect\Model\CreateDisputeEvidenceTextResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function createDisputeEvidenceText($dispute_id, $body)
    {
        list($response, $statusCode, $httpHeader) = $this->createDisputeEvidenceTextWithHttpInfo ($dispute_id, $body);
        return $response; 
    }


    /**
     * createDisputeEvidenceTextWithHttpInfo
     *
     * CreateDisputeEvidenceText
     *
     * @param string $dispute_id The ID of the dispute you want to upload evidence for. (required)
     * @param \SquareConnect\Model\CreateDisputeEvidenceTextRequest $body An object containing the fields to POST for the request.  See the corresponding object definition for field details. (required)
     * @return Array of \SquareConnect\Model\CreateDisputeEvidenceTextResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function createDisputeEvidenceTextWithHttpInfo($dispute_id, $body)
    {
        
        // verify the required parameter 'dispute_id' is set
        if ($dispute_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $dispute_id when calling createDisputeEvidenceText');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling createDisputeEvidenceText');
        }
  
        // parse inputs
        $resourcePath = "/v2/disputes/{dispute_id}/evidence_text";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        // path params
        if ($dispute_id !== null) {
            $resourcePath = str_replace(
                "{" . "dispute_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($dispute_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'POST',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\CreateDisputeEvidenceTextResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\CreateDisputeEvidenceTextResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\CreateDisputeEvidenceTextResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    /**
     * listDisputeEvidence
     *
     * ListDisputeEvidence
     * Note: This endpoint is in beta.
     *
     * @param string $dispute_id The ID of the dispute. (required)
     * @return \SquareConnect\Model\ListDisputeEvidenceResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function listDisputeEvidence($dispute_id)
    {
        list($response, $statusCode, $httpHeader) = $this->listDisputeEvidenceWithHttpInfo ($dispute_id);
        return $response; 
    }


    /**
     * listDisputeEvidenceWithHttpInfo
     *
     * ListDisputeEvidence
     *
     * @param string $dispute_id The ID of the dispute. (required)
     * @return Array of \SquareConnect\Model\ListDisputeEvidenceResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function listDisputeEvidenceWithHttpInfo($dispute_id)
    {
        
        // verify the required parameter 'dispute_id' is set
        if ($dispute_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $dispute_id when calling listDisputeEvidence');
        }
  
        // parse inputs
        $resourcePath = "/v2/disputes/{dispute_id}/evidence";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        // path params
        if ($dispute_id !== null) {
            $resourcePath = str_replace(
                "{" . "dispute_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($dispute_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'GET',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\ListDisputeEvidenceResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\ListDisputeEvidenceResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\ListDisputeEvidenceResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    /**
     * listDisputes
     *
     * ListDisputes
     * Note: This endpoint is in beta.
     *
     * @param string $cursor A pagination cursor returned by a previous call to this endpoint. Provide this to retrieve the next set of results for the original query. For more information, see [Paginating](https://developer.squareup.com/docs/basics/api101/pagination). (optional)
     * @param string $states The dispute states to filter the result. If not specified, the endpoint returns all open disputes (dispute status is not &#x60;INQUIRY_CLOSED&#x60;, &#x60;WON&#x60;, or &#x60;LOST&#x60;). (optional)
     * @param string $location_id The ID of the location for which to return  a list of disputes. If not specified, the endpoint returns all open disputes (dispute status is not &#x60;INQUIRY_CLOSED&#x60;, &#x60;WON&#x60;, or  &#x60;LOST&#x60;) associated with all locations. (optional)
     * @return \SquareConnect\Model\ListDisputesResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function listDisputes($cursor = null, $states = null, $location_id = null)
    {
        list($response, $statusCode, $httpHeader) = $this->listDisputesWithHttpInfo ($cursor, $states, $location_id);
        return $response; 
    }


    /**
     * listDisputesWithHttpInfo
     *
     * ListDisputes
     *
     * @param string $cursor A pagination cursor returned by a previous call to this endpoint. Provide this to retrieve the next set of results for the original query. For more information, see [Paginating](https://developer.squareup.com/docs/basics/api101/pagination). (optional)
     * @param string $states The dispute states to filter the result. If not specified, the endpoint returns all open disputes (dispute status is not &#x60;INQUIRY_CLOSED&#x60;, &#x60;WON&#x60;, or &#x60;LOST&#x60;). (optional)
     * @param string $location_id The ID of the location for which to return  a list of disputes. If not specified, the endpoint returns all open disputes (dispute status is not &#x60;INQUIRY_CLOSED&#x60;, &#x60;WON&#x60;, or  &#x60;LOST&#x60;) associated with all locations. (optional)
     * @return Array of \SquareConnect\Model\ListDisputesResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function listDisputesWithHttpInfo($cursor = null, $states = null, $location_id = null)
    {
        
  
        // parse inputs
        $resourcePath = "/v2/disputes";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        // query params
        if ($cursor !== null) {
            $queryParams['cursor'] = $this->apiClient->getSerializer()->toQueryValue($cursor);
        }// query params
        if ($states !== null) {
            $queryParams['states'] = $this->apiClient->getSerializer()->toQueryValue($states);
        }// query params
        if ($location_id !== null) {
            $queryParams['location_id'] = $this->apiClient->getSerializer()->toQueryValue($location_id);
        }
        
        
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'GET',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\ListDisputesResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\ListDisputesResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\ListDisputesResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    /**
     * removeDisputeEvidence
     *
     * RemoveDisputeEvidence
     * Note: This endpoint is in beta.
     *
     * @param string $dispute_id The ID of the dispute you want to remove evidence from. (required)
     * @param string $evidence_id The ID of the evidence you want to remove. (required)
     * @return \SquareConnect\Model\RemoveDisputeEvidenceResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function removeDisputeEvidence($dispute_id, $evidence_id)
    {
        list($response, $statusCode, $httpHeader) = $this->removeDisputeEvidenceWithHttpInfo ($dispute_id, $evidence_id);
        return $response; 
    }


    /**
     * removeDisputeEvidenceWithHttpInfo
     *
     * RemoveDisputeEvidence
     *
     * @param string $dispute_id The ID of the dispute you want to remove evidence from. (required)
     * @param string $evidence_id The ID of the evidence you want to remove. (required)
     * @return Array of \SquareConnect\Model\RemoveDisputeEvidenceResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function removeDisputeEvidenceWithHttpInfo($dispute_id, $evidence_id)
    {
        
        // verify the required parameter 'dispute_id' is set
        if ($dispute_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $dispute_id when calling removeDisputeEvidence');
        }
        // verify the required parameter 'evidence_id' is set
        if ($evidence_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $evidence_id when calling removeDisputeEvidence');
        }
  
        // parse inputs
        $resourcePath = "/v2/disputes/{dispute_id}/evidence/{evidence_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        // path params
        if ($dispute_id !== null) {
            $resourcePath = str_replace(
                "{" . "dispute_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($dispute_id),
                $resourcePath
            );
        }// path params
        if ($evidence_id !== null) {
            $resourcePath = str_replace(
                "{" . "evidence_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($evidence_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'DELETE',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\RemoveDisputeEvidenceResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\RemoveDisputeEvidenceResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\RemoveDisputeEvidenceResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    /**
     * retrieveDispute
     *
     * RetrieveDispute
     * Note: This endpoint is in beta.
     *
     * @param string $dispute_id The ID of the dispute you want more details about. (required)
     * @return \SquareConnect\Model\RetrieveDisputeResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function retrieveDispute($dispute_id)
    {
        list($response, $statusCode, $httpHeader) = $this->retrieveDisputeWithHttpInfo ($dispute_id);
        return $response; 
    }


    /**
     * retrieveDisputeWithHttpInfo
     *
     * RetrieveDispute
     *
     * @param string $dispute_id The ID of the dispute you want more details about. (required)
     * @return Array of \SquareConnect\Model\RetrieveDisputeResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function retrieveDisputeWithHttpInfo($dispute_id)
    {
        
        // verify the required parameter 'dispute_id' is set
        if ($dispute_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $dispute_id when calling retrieveDispute');
        }
  
        // parse inputs
        $resourcePath = "/v2/disputes/{dispute_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        // path params
        if ($dispute_id !== null) {
            $resourcePath = str_replace(
                "{" . "dispute_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($dispute_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'GET',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\RetrieveDisputeResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\RetrieveDisputeResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\RetrieveDisputeResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    /**
     * retrieveDisputeEvidence
     *
     * RetrieveDisputeEvidence
     * Note: This endpoint is in beta.
     *
     * @param string $dispute_id The ID of the dispute that you want to retrieve evidence from. (required)
     * @param string $evidence_id The ID of the evidence to retrieve. (required)
     * @return \SquareConnect\Model\RetrieveDisputeEvidenceResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function retrieveDisputeEvidence($dispute_id, $evidence_id)
    {
        list($response, $statusCode, $httpHeader) = $this->retrieveDisputeEvidenceWithHttpInfo ($dispute_id, $evidence_id);
        return $response; 
    }


    /**
     * retrieveDisputeEvidenceWithHttpInfo
     *
     * RetrieveDisputeEvidence
     *
     * @param string $dispute_id The ID of the dispute that you want to retrieve evidence from. (required)
     * @param string $evidence_id The ID of the evidence to retrieve. (required)
     * @return Array of \SquareConnect\Model\RetrieveDisputeEvidenceResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function retrieveDisputeEvidenceWithHttpInfo($dispute_id, $evidence_id)
    {
        
        // verify the required parameter 'dispute_id' is set
        if ($dispute_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $dispute_id when calling retrieveDisputeEvidence');
        }
        // verify the required parameter 'evidence_id' is set
        if ($evidence_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $evidence_id when calling retrieveDisputeEvidence');
        }
  
        // parse inputs
        $resourcePath = "/v2/disputes/{dispute_id}/evidence/{evidence_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        // path params
        if ($dispute_id !== null) {
            $resourcePath = str_replace(
                "{" . "dispute_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($dispute_id),
                $resourcePath
            );
        }// path params
        if ($evidence_id !== null) {
            $resourcePath = str_replace(
                "{" . "evidence_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($evidence_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'GET',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\RetrieveDisputeEvidenceResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\RetrieveDisputeEvidenceResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\RetrieveDisputeEvidenceResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    /**
     * submitEvidence
     *
     * SubmitEvidence
     * Note: This endpoint is in beta.
     *
     * @param string $dispute_id The ID of the dispute you want to submit evidence for. (required)
     * @return \SquareConnect\Model\SubmitEvidenceResponse
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function submitEvidence($dispute_id)
    {
        list($response, $statusCode, $httpHeader) = $this->submitEvidenceWithHttpInfo ($dispute_id);
        return $response; 
    }


    /**
     * submitEvidenceWithHttpInfo
     *
     * SubmitEvidence
     *
     * @param string $dispute_id The ID of the dispute you want to submit evidence for. (required)
     * @return Array of \SquareConnect\Model\SubmitEvidenceResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws \SquareConnect\ApiException on non-2xx response
     */
    public function submitEvidenceWithHttpInfo($dispute_id)
    {
        
        // verify the required parameter 'dispute_id' is set
        if ($dispute_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $dispute_id when calling submitEvidence');
        }
  
        // parse inputs
        $resourcePath = "/v2/disputes/{dispute_id}/submit-evidence";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/json'));
        $headerParams['Square-Version'] = "2020-05-28";

        
        
        // path params
        if ($dispute_id !== null) {
            $resourcePath = str_replace(
                "{" . "dispute_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($dispute_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'POST',
                $queryParams, $httpBody,
                $headerParams, '\SquareConnect\Model\SubmitEvidenceResponse'
            );
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\SquareConnect\ObjectSerializer::deserialize($response, '\SquareConnect\Model\SubmitEvidenceResponse', $httpHeader), $statusCode, $httpHeader);
                    } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \SquareConnect\ObjectSerializer::deserialize($e->getResponseBody(), '\SquareConnect\Model\SubmitEvidenceResponse', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
}
