<?php

/** 
Normalization values for ClientExec
@created 2017-11-15
@lastUpdated 2023-04-20
@version 1.0.0
*/

namespace Netim {
	$countryCodeToRegex = array(
		'AD' => 'andorr[ae]',
		'AE' => 'UAE|united arab emirates|emirats arabes unis',
		'AF' => 'afghanistan',
		'AG' => 'antigua|barbuda|antigua (and|et) barbuda',
		'AI' => 'anguilla',
		'AL' => 'albani[ae]',
		'AM' => 'nia|armenie',
		'AO' => 'angola',
		'AQ' => 'antarcti(ca|que)',
		'AR' => 'argentin[ae]',
		'AS' => 'american samoa|samoa americaines',
		'AT' => 'austria|autriche',
		'AU' => 'australi[ae]',
		'AW' => 'aruba',
		'AX' => 'aland islands|((les )?iles )?aland',
		'AZ' => 'azerbai(d?j)an',
		'BA' => 'bosnia|bosnia and herzegovina|bosnie|bosnie herzegovine',
		'BB' => 'barbad(os|e)',
		'BD' => 'bangladesh',
		'BE' => 'belgi(um|que)',
		'BF' => 'burkina faso',
		'BG' => 'bulgari[ae]',
		'BH' => 'bahr[ae]in',
		'BI' => 'burundi',
		'BJ' => 'benin',
		'BL' => 'saint barthelemy',
		'BM' => 'bermud(a|es)',
		'BN' => 'brunei',
		'BO' => 'bolivi[ea]',
		'BQ' => 'bonaire sint eustatius and saba|bonaire saint eustache et saba',
		'BR' => 'brazil|bresil',
		'BS' => 'bahamas',
		'BT' => 'bho?utan',
		'BV' => "bouvet island|((l')?ile )?bouvet",
		'BW' => 'botswana',
		'BY' => 'belarus|bielorussie',
		'BZ' => 'belize',
		'CA' => 'canada',
		'CC' => "cocos (\(keeling\) |keeling )?island|((l')?iles )?cocos( \(keeling\)| keeling)?",
		'CD' => '(the )?democratic republic (of )?(the )?congo|(la )?republique democratique (du )?congo',
		'CF' => 'central african republic|republique centrafricaine',
		'CG' => 'congo',
		'CH' => 'switzerland|suisse',
		'CI' => "ivory coast|cote d'ivoire",
		'CK' => 'cook|cook islands|((les )?iles )?cook',
		'CL' => 'chil[ei]',
		'CM' => 'camero[ou]n',
		'CN' => 'chin[ae]',
		'CO' => 'colombi[ae]',
		'CR' => 'costa rica',
		'CU' => 'cuba',
		'CV' => 'cabo verde',
		'CW' => 'curacao',
		'CX' => "christmas island|((l')?ile )?christmas",
		'CY' => 'cyprus|chypre',
		'CZ' => 'czechia|tchequie|republique tcheque',
		'DE' => 'germany|allemagne',
		'DJ' => 'djibouti',
		'DK' => 'denmark|danemark',
		'DM' => 'domini(ca|que)',
		'DO' => 'dominican republic|((la )?republique )?dominicaine',
		'DZ' => 'algeri[ae]',
		'EC' => 'ecuador|equateur',
		'EE' => 'estoni[ae]',
		'EG' => 'egypte?',
		'EH' => 'western sahara|(le )?sahara occidental',
		'ER' => "eritrea|(l')?erythree",
		'ES' => 'spain|espagne',
		'ET' => 'ethiopi[ae]',
		'FI' => 'finlande?',
		'FJ' => 'fid?ji',
		'FK' => '(the )?falkland islands|(the )?malvinas|((les )?iles )?(falkland|malouines)',
		'FM' => '((federated )?states of )?micronesia|(etats (federes )?de )?micronesie',
		'FO' => '(the )?faroe islands|((les )?iles )?feroe',
		'FR' => 'france',
		'GA' => 'gabon',
		'GB' => "(the )?united kingdom|great britain|northern ireland|(the )?united kingdom of great britain|(the )?united kingdom of great britain and northern ireland|great britain and northern ireland|(le )?royaume uni|(de )?grande bretagne|(et (d')?)?irlande du nord|(le )?royaume uni de grande bretagne|(le )?royaume uni de grande bretagne (et (d')?)?irlande du nord|grande bretagne (et (d')?)?irlande du nord",
		'GD' => 'grenad[ae]',
		'GE' => 'georgi[ae]',
		'GF' => 'french guiana|(la )?guyane francaise',
		'GG' => 'guerne?sey',
		'GH' => 'ghana',
		'GI' => 'gibraltar',
		'GL' => 'greenland|groenland',
		'GM' => 'gambi[ae]',
		'GN' => 'guine[ae]',
		'GP' => 'guadeloupe',
		'GQ' => 'equatorial guinea|guinee equatoriale',
		'GR' => 'gre?ece',
		'GS' => '(south georgia and the |the )?south sandwich islands|(georgie du sud et les |les )?iles sandwich du sud',
		'GT' => 'guatemala',
		'GU' => 'guam',
		'GW' => 'guine[ae] bissau',
		'GY' => 'guyana',
		'HK' => 'hong kong',
		'HM' => "(heard (island )?and mcdonald islands|heard island|mcdonald islands)|(l')?ile (heard|macdonald|heard et macdonald)",
		'HN' => 'honduras',
		'HR' => 'croati[ea]',
		'HT' => 'haiti',
		'HU' => 'hungary|hongrie',
		'ID' => 'indonesi[ae]',
		'IE' => 'ireland|irlande',
		'IL' => 'israel',
		'IM' => 'isle of man|ile de man',
		'IN' => 'ind(ia|e)',
		'IO' => "(the )?british indian (ocean )?territory|(le )?territoire britannique (de l'ocean )?indien",
		'IQ' => 'ira[qk]',
		'IR' => "iran|islamic republic( of)? iran|republique islamique (d')?iran",
		'IS' => "iceland|(l')?islande",
		'IT' => "italy|(l')?italie",
		'JE' => 'jersey',
		'JM' => 'jamaica|jamaique',
		'JO' => 'jordan(ie)?',
		'JP' => 'jap[ao]n',
		'KE' => 'kenya',
		'KG' => 'kyrgyzstan|kirghizistan',
		'KH' => 'cambodia|cambodge',
		'KI' => 'kiribati',
		'KM' => '(the|les)?comor[oe]s',
		'KN' => 'saint kitts (and |et )?nevis',
		'KP' => "(the )?democratic (people's )?republic (of )?korea|(la )?republique (populaire )?democratique (de )?coree",
		'KR' => '(the )?republic (of )?korea|(la )?republique (de )?coree',
		'KW' => 'kuwait|koweit',
		'KY' => '(the )?cayman islands|((les )?iles )?caimans',
		'KZ' => 'kazakhstan',
		'LA' => "laos?|(the )?lao (people's )?(democratic )?republic|republique (democratique )?(populaire )?(d[eu] )?lao",
		'LB' => 'lebanon|liban',
		'LC' => 'saint lucia|sainte lucie',
		'LI' => 'liechtenstein',
		'LK' => 'sri lanka',
		'LR' => 'liberia',
		'LS' => 'lesotho',
		'LT' => 'lithuani[ae]',
		'LU' => 'luxembourg',
		'LV' => 'latvia|lettonie',
		'LY' => 'liby[ae]',
		'MA' => 'morocco|maroc',
		'MC' => 'monaco',
		'MD' => '((the )?republic of)?moldova|(republique de)?moldavie',
		'ME' => 'montenegro',
		'MF' => 'saint martin \(?(france|french|french( part| side)?)\)?|saint martin \(?(france|francaise?|(partie |cote )(francaise?|france))\)?',
		'MG' => 'madagascar',
		'MH' => 'marshall islands|(iles )?marshall',
		'MK' => 'macedonia|macedoine',
		'ML' => 'mali',
		'MM' => 'myanmar',
		'MN' => 'mongoli[ae]',
		'MO' => 'macao',
		'MP' => '(the )?(northern )?mariana islands|((les )?iles )?mariannes ((du )?nord)?',
		'MQ' => '(la )?martinique',
		'MR' => 'mauritani[ae]',
		'MS' => 'montserrat',
		'MT' => 'malt[ae]',
		'MU' => '(republic of )?mauritius|(republique de )?maurice',
		'MV' => '(les |the )?maldives',
		'MW' => 'malawi',
		'MX' => 'mexico|mexique',
		'MY' => 'malaysia|(la )?malaisie',
		'MZ' => '(le )?mozambique',
		'NA' => 'namibi[ae]',
		'NC' => 'new caledonia|nouvelle caledonie',
		'NE' => '(the |le )?niger',
		'NF' => "norfolk island|((l')?ile )?norfolk",
		'NG' => 'nigeria',
		'NI' => '(le )?nicaragua',
		'NL' => '(the )?netherlands|(les )?pays bas',
		'NO' => 'norway|(la )?norvege',
		'NP' => '(le )?nepal',
		'NR' => 'nauru',
		'NU' => 'niue',
		'NZ' => 'new zealand|(la )?nouvelle zelande',
		'OM' => 'oman',
		'PA' => '(le )?panama',
		'PE' => 'peru|(le )?perou',
		'PF' => 'french polynesia|(la )?polynesie francaise',
		'PG' => 'papua new guinea|(la )?papouasie nouvelle guinee',
		'PH' => '(the |les )?philippines',
		'PK' => '(le )?pakistan',
		'PL' => 'poland|(la )?pologne',
		'PM' => 'saint pierre (et |and )?miquelon',
		'PN' => 'pitcairn',
		'PR' => 'p(ue|o)rto rico',
		'PS' => '(state of )?palestine|(etat de )?palestine',
		'PT' => '(le )?portugal',
		'PW' => 'palau|(les )?palaos',
		'PY' => '(le )?paraguay',
		'QA' => '(le )?qatar',
		'RE' => '(la )?reunion',
		'RO' => 'romania|(la )?roumanie',
		'RS' => 'serbia|(la )?serbie',
		'RU' => '(the )?russian federation|(la federation de )?russie',
		'RW' => '(le )?rwanda',
		'SA' => "saudi arabia|(l')?arabie saoudite",
		'SB' => 'solomon islands|(iles )?salomon',
		'SC' => '(les )?seychelles',
		'SD' => '(the )?sudan|(le )?soudan',
		'SE' => 'sweden|(la )?suede',
		'SG' => 'singapou?re?',
		'SH' => 'saint helena|sainte helene|ascension|tristan da cunha|sainte? helen[ae] ascension (and |et )?tristan da cunha',
		'SI' => 'sloveni[ae]',
		'SJ' => "svalbard (and |et l'ile )jan mayen?",
		'SK' => 'slovakia|(la )?slovaquie',
		'SL' => '(la )?sierra leone',
		'SM' => 'san marino|saint marin',
		'SN' => '(le )?senegal',
		'SO' => '(la )?somali[ae]',
		'SR' => '(le )?suriname',
		'SS' => 'south sudan|(le )?soudan du sud',
		'ST' => 'sao tome (et |and )?principe',
		'SV' => '(el )?salvador',
		'SX' => 'sint maarten \(?(dutch( part| side)?)\)?|saint martin \(?(pays bas?|(partie |cote )neerlandaise?)\)?',
		'SY' => 'syrian arab republic|(la )?republique (arabe )?syrienne',
		'SZ' => '(le )?swaziland',
		'TC' => '(the )?turks (and )?caicos islands|((les )?iles )?turks (et )?caicos',
		'TD' => '(le )?t?chad',
		'TF' => '(the )?french southern territories|(les )?terres australes francaises',
		'TG' => '(le )?togo',
		'TH' => '(la )?thailande?',
		'TJ' => '(le )?tad?jikistan',
		'TK' => '(les )?tokelau',
		'TL' => '(le )?timor leste',
		'TM' => '(le )?turkmenistan',
		'TN' => '(la )?tunisi[ae]',
		'TO' => '(les )?tonga',
		'TR' => 'turkey|(la )?turquie',
		'TT' => 'trinidad (and )?tobago|(la )?trinite (et )?tobago',
		'TV' => '(les )?tuvalu',
		'TW' => 'taiwan|taiwan \(province of china\)|taiwan \(province de chine\)',
		'TZ' => 'tanzani[ae]|united republic of tanzania|republique unie de tanzanie',
		'UA' => "(l')?ukraine",
		'UG' => "(l')?o?uganda",
		'UM' => '(the )?united states minor outlying islands|(les )?iles mineures eloignees des etats unis',
		'US' => "USA|(the )?united states (of )?america|(les )?etats unis (d')amerique",
		'UY' => "(l')?uruguay",
		'UZ' => "(l')?o?uzbekistan",
		'VA' => '(the )?holy see|(le )?saint siege',
		'VC' => 'saint vincent (and |et )?(the |les )?grenadines',
		'VE' => 'venezuela|bolivarian republic (of )?venezuela|republique bolivarienne (du )?venezuela',
		'VG' => 'virgin islands \(?british\)?|((les )?iles )?vierges britanniques',
		'VI' => 'virgin islands \(?u\.?s\.?a?\.?\)?|((les )?iles )?vierges (des )?(etats unis|\(?u\.?s\.?a?\.?\)?)',
		'VN' => '(le )?viet nam',
		'VU' => '(le )?vanuatu',
		'WF' => 'wallis (and |et )?futuna',
		'WS' => '(le )?samoa',
		'YE' => '(le )?yemen',
		'YT' => 'mayotte',
		'ZA' => "south africa|(l')?afrique (du )?sud",
		'ZM' => '(la )?zambi[ae]',
		'ZW' => '(le )?zimbabwe'
	);

	$countryCodeToCountry = array(
		'AD' => array('en' => 'Andorra', 'fr' => 'Andorre'),
		'AE' => array('en' => 'United Arab Emirates', 'fr' => 'Émirats arabes unis'),
		'AF' => array('en' => 'Afghanistan', 'fr' => 'Afghanistan'),
		'AG' => array('en' => 'Antigua and Barbuda', 'fr' => 'Antigua-et-Barbuda'),
		'AI' => array('en' => 'Anguilla', 'fr' => 'Anguilla'),
		'AL' => array('en' => 'Albania', 'fr' => 'Albanie'),
		'AM' => array('en' => 'Armenia', 'fr' => 'Arménie'),
		'AO' => array('en' => 'Angola', 'fr' => 'Angola'),
		'AQ' => array('en' => 'Antarctica', 'fr' => 'Antarctique'),
		'AR' => array('en' => 'Argentina', 'fr' => 'Argentine'),
		'AS' => array('en' => 'American Samoa', 'fr' => 'Samoa Américaines'),
		'AT' => array('en' => 'Austria', 'fr' => 'Autriche'),
		'AU' => array('en' => 'Australia', 'fr' => 'Australie'),
		'AW' => array('en' => 'Aruba', 'fr' => 'Aruba'),
		'AX' => array('en' => 'Åland Islands', 'fr' => 'les Îles Åland'),
		'AZ' => array('en' => 'Azerbaijan', 'fr' => 'Azerbaidjan'),
		'BA' => array('en' => 'Bosnia and Herzegovina', 'fr' => 'Bosnie-Herzégovine'),
		'BB' => array('en' => 'Barbados', 'fr' => 'Barbade'),
		'BD' => array('en' => 'Bangladesh', 'fr' => 'Bangladesh'),
		'BE' => array('en' => 'Belgium', 'fr' => 'Belgique'),
		'BF' => array('en' => 'Burkina Faso', 'fr' => 'Burkina Faso'),
		'BG' => array('en' => 'Bulgaria', 'fr' => 'Bulgarie'),
		'BH' => array('en' => 'Bahrain', 'fr' => 'Bahreïn'),
		'BI' => array('en' => 'Burundi', 'fr' => 'Burundi'),
		'BJ' => array('en' => 'Benin', 'fr' => 'Bénin'),
		'BL' => array('en' => 'Saint Barthélemy', 'fr' => 'Saint-Barthélemy'),
		'BM' => array('en' => 'Bermuda', 'fr' => 'Bermudes'),
		'BN' => array('en' => 'Brunei Darussalam', 'fr' => 'Brunéi Darussalam'),
		'BO' => array('en' => 'Bolivia', 'fr' => 'Bolivie'),
		'BQ' => array('en' => 'Bonaire, Sint Eustatius and Saba', 'fr' => 'Bonaire, Saint-Eustache et Saba'),
		'BR' => array('en' => 'Brazil', 'fr' => 'Brésil'),
		'BS' => array('en' => 'Bahamas', 'fr' => 'Bahamas'),
		'BT' => array('en' => 'Bhutan', 'fr' => 'Bhoutan'),
		'BV' => array('en' => 'Bouvet Island', 'fr' => "L'île Bouvet"),
		'BW' => array('en' => 'Botswana', 'fr' => 'Botswana'),
		'BY' => array('en' => 'Belarus', 'fr' => 'Bélarus'),
		'BZ' => array('en' => 'Belize', 'fr' => 'Bélize'),
		'CA' => array('en' => 'Canada', 'fr' => 'Canada'),
		'CC' => array('en' => 'Cocos (Keeling) Island', 'fr' => 'Îles Cocos (Keeling)'),
		'CD' => array('en' => 'the Democratic Republic of the Congo', 'fr' => 'la République démocratique du Congo'),
		'CF' => array('en' => 'Central African Republic', 'fr' => 'République centrafricaine'),
		'CG' => array('en' => 'Congo', 'fr' => 'Congo'),
		'CH' => array('en' => 'Switzerland', 'fr' => 'Suisse'),
		'CI' => array('en' => "Côte d'Ivoire", 'fr' => "Côte d'Ivoire"),
		'CK' => array('en' => 'Cook Islands', 'fr' => 'Les Îles Cook'),
		'CL' => array('en' => 'Chile', 'fr' => 'Chili'),
		'CM' => array('en' => 'Cameroon', 'fr' => 'Cameroun'),
		'CN' => array('en' => 'China', 'fr' => 'Chine'),
		'CO' => array('en' => 'Colombia', 'fr' => 'Colombie'),
		'CR' => array('en' => 'Costa Rica', 'fr' => 'Costa Rica'),
		'CU' => array('en' => 'Cuba', 'fr' => 'Cuba'),
		'CV' => array('en' => 'Cabo Verde', 'fr' => 'Cabo Verde'),
		'CW' => array('en' => 'Curaçao', 'fr' => 'Curaçao'),
		'CX' => array('en' => 'Christmas Island', 'fr' => "L'île Christmas"),
		'CY' => array('en' => 'Cyprus', 'fr' => 'Chypre'),
		'CZ' => array('en' => 'Czechia', 'fr' => 'Tchéquie'),
		'DE' => array('en' => 'Germany', 'fr' => 'Allemagne'),
		'DJ' => array('en' => 'Djibouti', 'fr' => 'Djibouti'),
		'DK' => array('en' => 'Denmark', 'fr' => 'Danemark'),
		'DM' => array('en' => 'Dominica', 'fr' => 'Dominique'),
		'DO' => array('en' => 'Dominican Republic', 'fr' => 'République dominicaine'),
		'DZ' => array('en' => 'Algeria', 'fr' => 'Algérie'),
		'EC' => array('en' => 'Ecuador', 'fr' => 'Equateur'),
		'EE' => array('en' => 'Estonia', 'fr' => 'Estonie'),
		'EG' => array('en' => 'Egypt', 'fr' => 'Égypte'),
		'EH' => array('en' => 'Western Sahara', 'fr' => 'Sahara occidental'),
		'ER' => array('en' => 'Eritrea', 'fr' => 'Érythrée'),
		'ES' => array('en' => 'Spain', 'fr' => 'Espagne'),
		'ET' => array('en' => 'Ethiopia', 'fr' => 'Éthiopie'),
		'FI' => array('en' => 'Finland', 'fr' => 'Finlande'),
		'FJ' => array('en' => 'Fiji', 'fr' => 'Fidji'),
		'FK' => array('en' => 'Falkland Islands', 'fr' => 'Les îles Falkland'),
		'FM' => array('en' => 'Micronesia', 'fr' => 'Micronésie'),
		'FO' => array('en' => 'Faroe Islands', 'fr' => 'Les îles Féroé'),
		'FR' => array('en' => 'France', 'fr' => 'France'),
		'GA' => array('en' => 'Gabon', 'fr' => 'Gabon'),
		'GB' => array('en' => 'United Kingdom of Great Britain and Northern Ireland', 'fr' => "Royaume-Uni de Grande-Bretagne et d'Irlande du Nord"),
		'GD' => array('en' => 'Grenada', 'fr' => 'Grenade'),
		'GE' => array('en' => 'Georgia', 'fr' => 'Géorgie'),
		'GF' => array('en' => 'French Guiana', 'fr' => 'Guyane française'),
		'GG' => array('en' => 'Guernsey', 'fr' => 'Guernesey'),
		'GH' => array('en' => 'Ghana', 'fr' => 'Ghana'),
		'GI' => array('en' => 'Gibraltar', 'fr' => 'Gibraltar'),
		'GL' => array('en' => 'Greenland', 'fr' => 'groenland'),
		'GM' => array('en' => 'Gambia', 'fr' => 'Gambie'),
		'GN' => array('en' => 'Guinea', 'fr' => 'Guinée'),
		'GP' => array('en' => 'Guadeloupe', 'fr' => 'Guadeloupe'),
		'GQ' => array('en' => 'Equatorial Guinea', 'fr' => 'Guinée équatoriale'),
		'GR' => array('en' => 'Greece', 'fr' => 'Grèce'),
		'GS' => array('en' => 'South Georgia and the South Sandwich Islands', 'fr' => 'Géorgie du Sud-et-les îles Sandwich du Sud'),
		'GT' => array('en' => 'Guatemala', 'fr' => 'Guatemala'),
		'GU' => array('en' => 'Guam', 'fr' => 'Guam'),
		'GW' => array('en' => 'Guinea-Bissau', 'fr' => 'Guinée-Bissau'),
		'GY' => array('en' => 'Guyana', 'fr' => 'Guyana'),
		'HK' => array('en' => 'Hong Kong', 'fr' => 'Hong Kong'),
		'HM' => array('en' => 'Heard Island and McDonald Islands', 'fr' => "L'Île Heard-et-MacDonald"),
		'HN' => array('en' => 'Honduras', 'fr' => 'Honduras'),
		'HR' => array('en' => 'Croatia', 'fr' => 'Croatie'),
		'HT' => array('en' => 'Haiti', 'fr' => 'Haïti'),
		'HU' => array('en' => 'hungary', 'fr' => 'hongrie'),
		'ID' => array('en' => 'Indonesia', 'fr' => 'Indonésie'),
		'IE' => array('en' => 'Ireland', 'fr' => 'Irlande'),
		'IL' => array('en' => 'Israel', 'fr' => 'Israël'),
		'IM' => array('en' => 'Isle of Man', 'fr' => 'Île de Man'),
		'IN' => array('en' => 'India', 'fr' => 'Inde'),
		'IO' => array('en' => 'British Indian Ocean Territory', 'fr' => "Le Territoire britannique de l'océan Indien"),
		'IQ' => array('en' => 'Iraq', 'fr' => 'Irak'),
		'IR' => array('en' => 'Iran', 'fr' => 'Iran'),
		'IS' => array('en' => 'Iceland', 'fr' => 'Islande'),
		'IT' => array('en' => 'Italy', 'fr' => 'Italie'),
		'JE' => array('en' => 'Jersey', 'fr' => 'Jersey'),
		'JM' => array('en' => 'Jamaica', 'fr' => 'Jamaïque'),
		'JO' => array('en' => 'Jordan', 'fr' => 'Jordanie'),
		'JP' => array('en' => 'Japan', 'fr' => 'Japon'),
		'KE' => array('en' => 'Kenya', 'fr' => 'Kenya'),
		'KG' => array('en' => 'Kyrgyzstan', 'fr' => 'Kirghizistan'),
		'KH' => array('en' => 'Cambodia', 'fr' => 'Cambodge'),
		'KI' => array('en' => 'Kiribati', 'fr' => 'Kiribati'),
		'KM' => array('en' => 'Comoros', 'fr' => 'Comores'),
		'KN' => array('en' => 'Saint Kitts and Nevis', 'fr' => 'Saint-Kitts-et-Nevis'),
		'KP' => array('en' => "The Democratic People's Republic of Korea", 'fr' => 'La République populaire démocratique de Corée'),
		'KR' => array('en' => 'The Republic of Korea', 'fr' => 'La République de Corée'),
		'KW' => array('en' => 'Kuwait', 'fr' => 'Koweit'),
		'KY' => array('en' => 'Cayman Islands', 'fr' => 'Les Îles Caïmans'),
		'KZ' => array('en' => 'Kazakhstan', 'fr' => 'Kazakhstan'),
		'LA' => array('en' => "Lao People's Democratic Republic", 'fr' => 'République démocratique populaire de Lao'),
		'LB' => array('en' => 'Lebanon', 'fr' => 'Liban'),
		'LC' => array('en' => 'Saint Lucia', 'fr' => 'Sainte-Lucie'),
		'LI' => array('en' => 'Liechtenstein', 'fr' => 'Liechtenstein'),
		'LK' => array('en' => 'Sri Lanka', 'fr' => 'Sri Lanka'),
		'LR' => array('en' => 'Liberia', 'fr' => 'Libéria'),
		'LS' => array('en' => 'Lesotho', 'fr' => 'Lesotho'),
		'LT' => array('en' => 'Lithuania', 'fr' => 'Lithuanie'),
		'LU' => array('en' => 'Luxembourg', 'fr' => 'Luxembourg'),
		'LV' => array('en' => 'Latvia', 'fr' => 'Lettonie'),
		'LY' => array('en' => 'Libya', 'fr' => 'Libye'),
		'MA' => array('en' => 'Morocco', 'fr' => 'Maroc'),
		'MC' => array('en' => 'Monaco', 'fr' => 'Monaco'),
		'MD' => array('en' => 'Moldova', 'fr' => 'Moldavie'),
		'ME' => array('en' => 'Montenegro', 'fr' => 'Monténégro'),
		'MF' => array('en' => 'Saint Martin (French Part)', 'fr' => 'Saint-Martin (partie française)'),
		'MG' => array('en' => 'Madagascar', 'fr' => 'Madagascar'),
		'MH' => array('en' => 'Marshall Islands', 'fr' => 'Îles Marshall'),
		'MK' => array('en' => 'Macedonia', 'fr' => 'Macédoine'),
		'ML' => array('en' => 'Mali', 'fr' => 'Mali'),
		'MM' => array('en' => 'Myanmar', 'fr' => 'Myanmar'),
		'MN' => array('en' => 'Mongolia', 'fr' => 'Mongolie'),
		'MO' => array('en' => 'Macao', 'fr' => 'Macao'),
		'MP' => array('en' => 'Northern Mariana Islands', 'fr' => 'Îles Mariannes du Nord'),
		'MQ' => array('en' => 'Martinique', 'fr' => 'Martinique'),
		'MR' => array('en' => 'Mauritania', 'fr' => 'Mauritanie'),
		'MS' => array('en' => 'Montserrat', 'fr' => 'Montserrat'),
		'MT' => array('en' => 'Malta', 'fr' => 'Malte'),
		'MU' => array('en' => 'Mauritius', 'fr' => 'Maurice'),
		'MV' => array('en' => 'Maldives', 'fr' => 'Maldives'),
		'MW' => array('en' => 'Malawi', 'fr' => 'Malawi'),
		'MX' => array('en' => 'Mexico', 'fr' => 'Mexique'),
		'MY' => array('en' => 'Malaysia', 'fr' => 'Malaisie'),
		'MZ' => array('en' => 'Mozambique', 'fr' => 'Mozambique'),
		'NA' => array('en' => 'namibia', 'fr' => 'namibie'),
		'NC' => array('en' => 'New Caledonia', 'fr' => 'Nouvelle-Calédonie'),
		'NE' => array('en' => 'Niger', 'fr' => 'Niger'),
		'NF' => array('en' => 'Norfolk Island', 'fr' => "Île Norfolk"),
		'NG' => array('en' => 'Nigeria', 'fr' => 'Nigéria'),
		'NI' => array('en' => 'Nicaragua', 'fr' => 'Nicaragua'),
		'NL' => array('en' => 'Netherlands', 'fr' => 'Pays-Bas'),
		'NO' => array('en' => 'Norway', 'fr' => 'Norvège'),
		'NP' => array('en' => 'Nepal', 'fr' => 'Népal'),
		'NR' => array('en' => 'Nauru', 'fr' => 'Nauru'),
		'NU' => array('en' => 'Niue', 'fr' => 'Niue'),
		'NZ' => array('en' => 'New Zealand', 'fr' => 'Nouvelle-Zélande'),
		'OM' => array('en' => 'Oman', 'fr' => 'Oman'),
		'PA' => array('en' => 'Panama', 'fr' => 'Panama'),
		'PE' => array('en' => 'Peru', 'fr' => 'Pérou'),
		'PF' => array('en' => 'French Polynesia', 'fr' => 'Polynésie française'),
		'PG' => array('en' => 'Papua New Guinea', 'fr' => 'Papouasie-Nouvelle-Guinée'),
		'PH' => array('en' => 'Philippines', 'fr' => 'Philippines'),
		'PK' => array('en' => 'Pakistan', 'fr' => 'Pakistan'),
		'PL' => array('en' => 'Poland', 'fr' => 'Pologne'),
		'PM' => array('en' => 'Saint Pierre and Miquelon', 'fr' => 'Saint-Pierre-et-Miquelon'),
		'PN' => array('en' => 'Pitcairn', 'fr' => 'Pitcairn'),
		'PR' => array('en' => 'Puerto Rico', 'fr' => 'Porto Rico'),
		'PS' => array('en' => 'Palestine', 'fr' => 'Palestine'),
		'PT' => array('en' => 'Portugal', 'fr' => 'Portugal'),
		'PW' => array('en' => 'Palau', 'fr' => 'Palaos'),
		'PY' => array('en' => 'Paraguay', 'fr' => 'Paraguay'),
		'QA' => array('en' => 'Qatar', 'fr' => 'Qatar'),
		'RE' => array('en' => 'Réunion', 'fr' => 'Réunion'),
		'RO' => array('en' => 'Romania', 'fr' => 'Roumanie'),
		'RS' => array('en' => 'Serbia', 'fr' => 'Serbie'),
		'RU' => array('en' => 'Russian Federation', 'fr' => 'Russie'),
		'RW' => array('en' => 'Rwanda', 'fr' => 'Rwanda'),
		'SA' => array('en' => 'Saudi Arabia', 'fr' => 'Arabie saoudite'),
		'SB' => array('en' => 'Solomon Islands', 'fr' => 'Îles Salomon'),
		'SC' => array('en' => 'Seychelles', 'fr' => 'Seychelles'),
		'SD' => array('en' => 'Sudan', 'fr' => 'Soudan'),
		'SE' => array('en' => 'Sweden', 'fr' => 'Suède'),
		'SG' => array('en' => 'Singapore', 'fr' => 'Singapour'),
		'SH' => array('en' => 'Saint Helena Ascension and Tristan da Cunha', 'fr' => 'Sainte-Héléne Ascension et Tristan da Cunha'),
		'SI' => array('en' => 'Slovenia', 'fr' => 'Slovénie'),
		'SJ' => array('en' => 'Svalbard and Jan Mayen', 'fr' => "Svalbard et l'Île Jan Mayen"),
		'SK' => array('en' => 'Slovakia', 'fr' => 'Slovaquie'),
		'SL' => array('en' => 'Sierra Leone', 'fr' => 'Sierra Leone'),
		'SM' => array('en' => 'San Marino', 'fr' => 'Saint-Marin'),
		'SN' => array('en' => 'Senegal', 'fr' => 'Sénégal'),
		'SO' => array('en' => 'Somalia', 'fr' => 'Somalie'),
		'SR' => array('en' => 'Suriname', 'fr' => 'Suriname'),
		'SS' => array('en' => 'South Sudan', 'fr' => 'Soudan du Sud'),
		'ST' => array('en' => 'Sao Tome and Principe', 'fr' => 'Sao Tomé-et-Principe'),
		'SV' => array('en' => 'El Salvador', 'fr' => 'Salvador'),
		'SX' => array('en' => 'Sint Maarten (Dutch part)', 'fr' => 'Saint-Martin (partie néerlandaise)'),
		'SY' => array('en' => 'Syrian Arab Republic', 'fr' => 'République arabe syrienne'),
		'SZ' => array('en' => 'Swaziland', 'fr' => 'Swaziland'),
		'TC' => array('en' => 'Turks and Caicos Islands', 'fr' => 'Ïles Turks-et-Caïcos'),
		'TD' => array('en' => 'Chad', 'fr' => 'Tchad'),
		'TF' => array('en' => 'French Southern Territories', 'fr' => 'Terres australes françaises'),
		'TG' => array('en' => 'Togo', 'fr' => 'Togo'),
		'TH' => array('en' => 'Thailand', 'fr' => 'Thaïlande'),
		'TJ' => array('en' => 'Tajikistan', 'fr' => 'Tadjikistan'),
		'TK' => array('en' => 'Tokelau', 'fr' => 'Tokelau'),
		'TL' => array('en' => 'Timor-Leste', 'fr' => 'Timor-Leste'),
		'TM' => array('en' => 'Turkmenistan', 'fr' => 'Turkménistan'),
		'TN' => array('en' => 'Tunisia', 'fr' => 'Tunisie'),
		'TO' => array('en' => 'Tonga', 'fr' => 'Tonga'),
		'TR' => array('en' => 'Turkey', 'fr' => 'Turquie'),
		'TT' => array('en' => 'Trinidad and Tobago', 'fr' => 'Trinité-et-Tobago'),
		'TV' => array('en' => 'Tuvalu', 'fr' => 'Tuvalu'),
		'TW' => array('en' => 'Taiwan', 'fr' => 'Taiwan'),
		'TZ' => array('en' => 'Tanzania', 'fr' => 'Tanzanie'),
		'UA' => array('en' => 'Ukraine', 'fr' => 'Ukraine'),
		'UG' => array('en' => 'Uganda', 'fr' => 'Ouganda'),
		'UM' => array('en' => 'United States Minor Outlying Islands', 'fr' => 'Îles mineures éloignées des États-Unis'),
		'US' => array('en' => 'United States of America', 'fr' => "États-Unis d'Amérique"),
		'UY' => array('en' => 'Uruguay', 'fr' => 'Uruguay'),
		'UZ' => array('en' => 'Uzbekistan', 'fr' => 'Ouzbékistan'),
		'VA' => array('en' => 'Holy See', 'fr' => 'Saint-Siège'),
		'VC' => array('en' => 'Saint Vincent and the Grenadines', 'fr' => 'Saint-Vincent-et-les-Grenadines'),
		'VE' => array('en' => 'Venezuela', 'fr' => 'Venezuela'),
		'VG' => array('en' => 'Virgin Islands (British)', 'fr' => 'Îles Vierges britanniques'),
		'VI' => array('en' => 'Virgin Islands (U.S.)', 'fr' => 'Îles Vierges des États-Unis'),
		'VN' => array('en' => 'Viet Nam', 'fr' => 'Viet Nam'),
		'VU' => array('en' => 'Vanuatu', 'fr' => 'Vanuatu'),
		'WF' => array('en' => 'Wallis and Futuna', 'fr' => 'Wallis-et-Futuna'),
		'WS' => array('en' => 'Samoa', 'fr' => 'Samoa'),
		'YE' => array('en' => 'Yemen', 'fr' => 'Yémen'),
		'YT' => array('en' => 'Mayotte', 'fr' => 'Mayotte'),
		'ZA' => array('en' => 'South Africa', 'fr' => 'Afrique du Sud'),
		'ZM' => array('en' => 'Zambia', 'fr' => 'Zambie'),
		'ZW' => array('en' => 'Zimbabwe', 'fr' => 'Zimbabwe')
	);

	//List of country phone codes
	$countryPhoneCode = array(
		"AC" => 247, "AD" => 376, "AE" => 971, "AF" => 93, "AG" => 1268, "AI" => 1264, "AL" => 355, "AM" => 374, "AN" => 599, "AO" => 244, "AQ" => 672, "AR" => 54, "AS" => 1684,
		"AT" => 43, "AU" => 61, "AW" => 297, "AZ" => 994, "BA" => 387, "BB" => 1246, "BD" => 880, "BE" => 32, "BF" => 226, "BG" => 359, "BH" => 973, "BI" => 257, "BJ" => 229,
		"BM" => 1441, "BN" => 673, "BO" => 591, "BR" => 55, "BS" => 1242, "BT" => 975, "BV" => 0, "BW" => 267, "BY" => 375, "BZ" => 501, "CA" => 1, "CC" => 61, "CD" => 243, "CF" => 236,
		"CG" => 242, "CH" => 41, "CI" => 225, "CK" => 682, "CL" => 56, "CM" => 237, "CN" => 86, "CO" => 57, "CR" => 506, "CU" => 53, "CV" => 238, "CX" => 61, "CY" => 357, "CZ" => 420,
		"DE" => 49, "DJ" => 253, "DK" => 45, "DM" => 1767, "DO" => 1, "DZ" => 213, "EC" => 593, "EE" => 372, "EG" => 20, "EH" => 212, "ER" => 291, "ES" => 34, "ET" => 251, "FI" => 358,
		"FJ" => 679, "FK" => 500, "FM" => 691, "FO" => 298, "FR" => 33, "GA" => 241, "GB" => 44, "GD" => 1, "GE" => 995, "GF" => 594, "GG" => 44, "GH" => 233, "GI" => 350,
		"GL" => 299, "GM" => 220, "GN" => 224, "GP" => 590, "GQ" => 240, "GR" => 30, "GS" => 0, "GT" => 502, "GU" => 1671, "GW" => 245, "GY" => 592, "HK" => 852, "HM" => 0,
		"HN" => 504, "HR" => 385, "HT" => 509, "HU" => 36, "ID" => 62, "IE" => 353, "IL" => 972, "IM" => 44, "IN" => 91, "IO" => 246, "IQ" => 964, "IR" => 98, "IS" => 354,
		"IT" => 39, "JE" => 44, "JM" => 1, "JO" => 962, "JP" => 81, "KE" => 254, "KG" => 996, "KH" => 855, "KI" => 686, "KM" => 269, "KN" => 1869, "KP" => 850, "KR" => 82, "KW" => 965,
		"KY" => 1345, "KZ" => 7, "LA" => 856, "LB" => 961, "LC" => 1758, "LI" => 423, "LK" => 94, "LR" => 231, "LS" => 266, "LT" => 370, "LU" => 352, "LV" => 371, "LY" => 218, "MA" => 212,
		"MC" => 377, "MD" => 373, "MG" => 261, "MH" => 692, "MK" => 389, "ML" => 223, "MM" => 95, "MN" => 976, "MO" => 853, "MP" => 1670, "MQ" => 596, "MR" => 222, "MS" => 1664, "MT" => 356,
		"MU" => 230, "MV" => 960, "MW" => 265, "MX" => 52, "MY" => 60, "MZ" => 258, "NA" => 264, "NC" => 687, "NE" => 227, "NF" => 672, "NG" => 234, "NI" => 505, "NL" => 31, "NO" => 47,
		"NP" => 977, "NR" => 674, "NU" => 683, "NZ" => 64, "OM" => 968, "PA" => 507, "PE" => 51, "PF" => 689, "PG" => 675, "PH" => 63, "PK" => 92, "PL" => 48, "PM" => 508, "PN" => 64,
		"PR" => 1, "PS" => 970, "PT" => 351, "PW" => 680, "PY" => 595, "QA" => 974, "RE" => 262, "RO" => 40, "RS" => 381, "RU" => 7, "RW" => 250, "SA" => 966, "SB" => 677, "SC" => 248,
		"SD" => 249, "SE" => 46, "SG" => 65, "SH" => 290, "SI" => 386, "SJ" => 47, "SK" => 421, "SL" => 232, "SM" => 378, "SN" => 221, "SO" => 252, "SR" => 597, "ST" => 239, "SV" => 503, "SX" => 1721,
		"SY" => 963, "SZ" => 268, "TC" => 1649, "TD" => 235, "TF" => 0, "TG" => 228, "TH" => 66, "TJ" => 992, "TK" => 690, "TM" => 993, "TN" => 216, "TO" => 676, "TR" => 90, "TT" => 1868,
		"TV" => 688, "TW" => 886, "TZ" => 255, "UA" => 380, "UG" => 256, "UM" => 0, "US" => 1, "UY" => 598, "UZ" => 998, "VA" => 379, "VC" => 1784, "VE" => 58, "VG" => 1284, "VI" => 1340, "VN" => 84,
		"VU" => 678, "WF" => 681, "WS" => 685, "YE" => 967, "YT" => 269, "ZA" => 27, "ZM" => 260, "ZW" => 263
	);

	//List of state code

	$stateCodeToRegex['AU'] = array(
		'NSW' => 'NSW|NEW SOUTH WALES', 'VIC' => 'VIC|VICTORIA', 'QLD' => 'QLD|QUEENSLAND', 'ACT' => 'ACT|AUSTRALIAN CAPITAL TERRITORY', 'NT' => 'NT|NORTHERN TERRITORY',
		'TAS' => 'TAS|TASMANIA', 'WA'  => 'WA|WESTERN AUSTRALIA', 'SA'  => 'SA|SOUTH AUSTRALIA'
	);

	$stateCodeToState['AU'] = array(
		'NSW' => 'new south wales', 'VIC' => 'victoria', 'QLD' => 'queensland', 'ACT' => 'australian capital territory', 'NT' => 'northern territory',
		'TAS' => 'tasmania', 'WA'  => 'western australia', 'SA'  => 'south australia'
	);

	$stateCodeToRegex['BR'] = array(
		"AC" => "AC|ACRE", "AL" => "AL|ALAGOAS", "AM" => "AM|AMAZONAS", "AP" => "AP|AMAPA", "BA" => "BA|BAHIA", "CE" => "CE|CEARA", "DF" => "DF|DISTRITO FEDERAL",
		"ES" => "ES|ESPIRITO SANTO", "GO" => "GO|GOIAS", "MA" => "MA|MARANHAO", "MG" => "MG|MINAS GERAIS", "MS" => "MS|MATO GROSSO( DO)? SUL", "MT" => "MT|MATO GROSSO",
		"PA" => "PA|PARA", "PB" => "PB|PARAIBA", "PE" => "PE|PERNAMBUCO", "PI" => "PI|PIAUI", "PR" => "PR|PARANA", "RJ" => "RJ|RIO (DE )?JANEIRO", "RN" => "RN|RIO GRANDE (DO )?NORTE",
		"RO" => "RO|RONDONIA", "RR" => "RR|RORAIMA", "RS" => "RS|RIO GRANDE( DO)? SUL", "SC" => "SC|SANTA CATARINA", "SE" => "SE|SERGIPE", "SP" => "SP|SAO PAULO",
		"TO" => "TO|TOCANTINS"
	);

	$stateCodeToState['BR'] = array(
		"AC" => ["en" => "acre","pt" => "acre"], "AL" => ["en" => "alagoas","pt" => "alagoas"], "AM" => ["en" => "amazonas","pt" => "amazonas"],
		"AP" => ["en" => "amapa","pt" => "amapá"],"BA" => ["en" => "bahia","pt" => "bahia"], "CE" => ["en" => "ceara","pt" => "ceará"],
		"DF" => ["en" => "distrito federal","pt" => "distrito federal"], "ES" => ["en" => "espirito santo","pt" => "espírito Santo"], "GO" => ["en" => "goias","pt" => "goiás"],
		'MA' => ["en" => "maranhao","pt" => "maranhão"], "MG" => ["en" => "minas gerais","pt" => "minas gerais"], "MS" => ["en" => "mato grosso do sul","pt" => "mato grosso do sul"],
		"MT" => ["en" => "mato grosso","pt" => "mato grosso"], "PA" => ["en" => "para","pt" => "pará"], "PB" => ["en" => "paraiba","pt" => "paraíba"],
		"PE" => ["en" => "pernambuco","pt" => "pernambuco"], "PI" => ["en" => "piaui","pt" => "piauí"], "PR" => ["en" => "parana","pt" => "paraná"], 
		"RJ" => ["en" => "rio de janeiro","pt" => "rio de janeiro"], "RN" => ["en" => "rio grande do norte","pt" => "rio grande do norte"], "RO" => ["en" => "rondonia","pt" => "rondônia"],
		"RR" => ["en" => "roraima","pt" => "roraima"], "RS" => ["en" => "rio grande do sul","pt" => "rio grande do sul"], "SC" => ["en" => "santa catarina","pt" => "santa catarina"],
		"SE" => ["en" => "sergipe","pt" => "sergipe"], "SP" => ["en" => "sao paulo","pt" => "são paulo"], "TO" => ["en" => "tocantins","pt" => "tocantins"]
	);

	$stateCodeToRegex['CA'] = array(
		'AB' => 'AB|ALBERTA', 'BC' => 'BC|BRITISH COLUMBIA|COLOMBIE BRITANNIQUE', 'MB' => 'MB|MANITOBA', 'NB' => 'NB|(NEW |NOUVEAU )?BRUNSWICK', 'NL' => 'NL|NEWFOUNDLAND( AND LABRADOR)?|TERRE NEUVE( ET)?( LABRADOR)?',
		'NT' => 'NT|NORTHWEST TERRITORIES|TERRITOIRES (DU )?NORD OUEST', 'NS' => 'NS|NOVA SCOTIA|NOUVELLE ECOSSE', 'NU' => 'NU|NUNAVUT', 'ON' => 'ON|ONTARIO',
		'PE' => 'PE|PRINCE EDWARD( ISLAND)?|(ILES? (DU )?)?PRINCE EDOUARD', 'QC' => 'QC|QUEBEC', 'SK' => 'SK|SASKATCHEWAN', 'YT' => 'YT|YUKON( TERRITORY)?'
	);

	$stateCodeToState['CA'] = array(
		'AB' => ["en" => 'alberta',"fr" => "Alberta"], 'BC' => ["en" => 'british columbia',"fr" => "Colombie Britannique"], 'MB' => ["en" => 'manitoba',"fr" => "Manitoba"], 'NB' => ["en" => 'new brunswick',"fr" => "Nouveau Brunswick"],	
		'NL' => ["en" => 'newfoundland and labrador',"fr" => "Terre Neuve et Labrador"], 'NT' => ["en" => 'northwest territories',"fr" => "Territoires du Nord Ouest"], 'NS' => ["en" => 'nova scotia',"fr" => "Nouvelle Écosse"], 
		'NU' => ["en" => 'nunavut',"fr" => "Nunavut"], 'ON' => ["en" => 'ontario',"fr" => "Ontario"], 'PE' => ["en" => 'prince edward island',"fr" => "Île-du-Prince-Édouard"], 'QC' => ["en" => 'quebec',"fr" => "Québec"], 
		'SK' => ["en" => 'saskatchewan',"fr" => "Saskatchewan"], 'YT' => ["en" => 'yukon',"fr" => "Yukon"]
	);

	$stateCodeToRegex["IT"] = array(
		"AG" => "AG|AGRIGENTO", "AL" => "AL|ALESSANDRIA", "AN" => "AN|ANCONA", "AO" => "AO|AOSTA", "AP" => "AP|ASCOLI PICENO", "AQ" => "AQ|(L')?AQUILA",
		"AR" => "AR|AREZZO", "AT" => "AT|ASTI", "AV" => "AV|AVELLINO", "BA" => "BA|BARI", "BG" => "BG|BERGAMO", "BI" => "BI|BIELLA", "BL" => "BL|BELLUNO",
		"BN" => "BN|BENEVENTO", "BO" => "BO|BOLOGNA", "BR" => "BR|BRINDISI", "BS" => "BS|BRESCIA", "BT" => "BT|BARLETTA ANDRIA TRANI", "BZ" => "BZ|BOLZANO", "CA" => "CA|CAGLIARI",
		"CB" => "CB|CAMPOBASSO", "CE" => "CE|CASERTA", "CH" => "CH|CHIETI", "CI" => "CI|CARBONIA IGLESIAS", "CL" => "CL|CALTANISSETTA", "CN" => "CN|CUNEO", "CO" => "CO|COMO",
		"CR" => "CR|CREMONA", "CS" => "CS|COSENZA", "CT" => "CT|CATANIA", "CZ" => "CZ|CATANZARO", "EN" => "EN|ENNA", "FC" => "FC|FORLI CESENA", "FE" => "FE|FERRARA",
		"FG" => "FG|FOGGIA", "FI" => "FI|FLORENCE", "FM" => "FM|FERMO", "FR" => "FR|FROSINONE", "GE" => "GE|GENOA", "GO" => "GO|GORIZIA", "GR" => "GR|GROSSETO", "IM" => "IM|IMPERIA",
		"IS" => "IS|ISERNIA", "KR" => "KR|CROTONE", "LC" => "LC|LECCO", "LE" => "LE|LECCE", "LI" => "LI|LIVORNO", "LO" => "LO|LODI", "LT" => "LT|LATINA", "LU" => "LU|LUCCA",
		"MB" => "MB|MONZA AND BRIANZA", "MC" => "MC|MACERATA", "ME" => "ME|MESSINA", "MI" => "MI|MILAN", "MN" => "MN|MANTUA", "MO" => "MO|MODENA", "MS" => "MS|MASSA (AND )?CARRARA",
		"MT" => "MT|MATERA", "NA" => "NA|NAPLES", "NO" => "NO|NOVARA", "NU" => "NU|NUORO", "OG" => "OG|OGLIASTRA", "OR" => "OR|ORISTANO", "OT" => "OT|OLBIA TEMPLE|OLBIA TEMPIO", "PA" => "PA|PALERMO",
		"PC" => "PC|PIACENZA", "PD" => "PD|PADUA", "PE" => "PE|PESCARA", "PG" => "PG|PERUGIA", "PI" => "PI|PISA", "PN" => "PN|PORDENONE", "PO" => "PO|PRATO", "PR" => "PR|PARMA",
		"PT" => "PT|PISTOIA", "PU" => "PU|PESARO (AND )?URBINO", "PV" => "PV|PAVIA", "PZ" => "PZ|POTENZA", "RA" => "RA|RAVENNA", "RC" => "RC|REGGIO CALABRIA", "RE" => "RE|REGGIO EMILIA",
		"RG" => "RG|RAGUSA", "RI" => "RI|RIETI", "RM" => "RM|ROME", "RN" => "RN|RIMINI", "RO" => "RO|ROVIGO", "SA" => "SA|SALERNO", "SI" => "SI|SIENA", "SO" => "SO|SONDRIO",
		"SP" => "SP|(LA )?SPEZIA", "SR" => "SR|SYRACUSE", "SS" => "SS|SASSARI", "SV" => "SV|SAVONA", "TA" => "TA|TARANTO", "TE" => "TE|TERAMO", "TN" => "TN|TRENTO", "TO" => "TO|TURIN(O)?",
		"TP" => "TP|TRAPANI", "TR" => "TR|TERNI", "TS" => "TS|TRIESTE", "TV" => "TV|TREVISO", "UD" => "UD|UDINE", "VA" => "VA|VARESE", "VB" => "VB|VERBANO CUSIO OSSOLA",
		"VC" => "VC|VERCELLI", "VE" => "VE|VENICE", "VI" => "VI|VICENZA", "VR" => "VR|VERONA", "VS" => "VS|MEDIO CAMPIDANO", "VT" => "VT|VITERBO", "VV" => "VV|VIBO VALENTIA"
	);

	$stateCodeToState["IT"] = array(
		"AG" => ["en" => "agrigento","it" => "agrigento"], "AL" => ["en" => "alexandria","it" => "alessandria"], "AN" => ["en" => "anchor","it" => "ancona"],
		"AO" => ["en" => "aosta","it" => "aosta"], "AP" => ["en" => "ascoli piceno","it" => "ascoli piceno"], "AQ" => ["en" => "L'aquila","it" => "L'aquila"],
		"AR" => ["en" => "arezzo","it" => "arezzo"], "AT" => ["en" => "asti","it" => "asti"], "AV" => ["en" => "avellino","it" => "avellino"],
		"BA" => ["en" => "bari","it" => "bari"], "BG" => ["en" => "bergamo","it" => "bergamo"], "BI" => ["en" => "biella","it" => "biella"],
		"BL" => ["en" => "belluno","it" => "belluno"], "BN" => ["en" => "benevento","it" => "benevento"], "BO" => ["en" => "bologna","it" => "bologna"],
		"BR" => ["en" => "brindisi","it" => "brindisi"], "BS" => ["en" => "brescia","it" => "brescia"], "BT" => ["en" => "barletta andria trani","it" => "barletta andria trani"],
		"BZ" => ["en" => "bozen","it" => "bolzano"], "CA" => ["en" => "cagliari","it" => "cagliari"], "CB" => ["en" => "campobasso","it" => "campobasso"],
		"CE" => ["en" => "caserta","it" => "caserta"], "CH" => ["en" => "chieti","it" => "chieti"], "CI" => ["en" => "carbonia iglesias","it" => "carbonia iglesias"],
		"CL" => ["en" => "caltanissetta","it" => "caltanissetta"], "CN" => ["en" => "cuneo","it" => "cuneo"], "CO" => ["en" => "como","it" => "como"],
		"CR" => ["en" => "cremona","it" => "cremona"], "CS" => ["en" => "cosenza","it" => "cosenza"], "CT" => ["en" => "catania","it" => "catania"],
		"CZ" => ["en" => "catanzaro","it" => "catanzaro"], "EN" => ["en" => "enna","it" => "enna"], "FC" => ["en" => "forli-cesena","it" => "forli cesena"],
		"FE" => ["en" => "ferrara","it" => "ferrara"], "FG" => ["en" => "foggia","it" => "foggia"], "FI" => ["en" => "florence","it" => "florence"],
		"FM" => ["en" => "fermo","it" => "fermo"], "FR" => ["en" => "frosinone","it" => "frosinone"], "GE" => ["en" => "genoa","it" => "genoa"],
		"GO" => ["en" => "gorizia","it" => "gorizia"], "GR" => ["en" => "grosseto","it" => "grosseto"], "IM" => ["en" => "imperia","it" => "imperia"],
		"IS" => ["en" => "isernia","it" => "isernia"], "KR" => ["en" => "croton","it" => "crotone"], "LC" => ["en" => "lecco","it" => "lecco"],
		"LE" => ["en" => "lecce","it" => "lecce"], "LI" => ["en" => "leghorn","it" => "livorno"], "LO" => ["en" => "lodi","it" => "lodi"],
		"LT" => ["en" => "latina","it" => "latina"], "LU" => ["en" => "lucca","it" => "lucca"], "MB" => ["en" => "monza and Brianza","it" => "monza and Brianza"],
		"MC" => ["en" => "macerata","it" => "macerata"], "ME" => ["en" => "messina","it" => "messina"], "MI" => ["en" => "milan","it" => "milan"],
		"MN" => ["en" => "mantua","it" => "mantua"], "MO" => ["en" => "modena","it" => "modena"], "MS" => ["en" => "massa and carrara","it" => "massa and carrara"],
		"MT" => ["en" => "matera","it" => "matera"], "NA" => ["en" => "naples","it" => "naples"], "NO" => ["en" => "novara","it" => "novara"],
		"NU" => ["en" => "nuoro","it" => "nuoro"], "OG" => ["en" => "ogliastra","it" => "ogliastra"], "OR" => ["en" => "oristano","it" => "oristano"],
		"OT" => ["en" => "olbia temple 2","it" => "olbia tempio"], "PA" => ["en" => "palermo","it" => "palermo"], "PC" => ["en" => "piacenza","it" => "piacenza"],
		"PD" => ["en" => "padua","it" => "padua"], "PE" => ["en" => "pescara","it" => "pescara"], "PG" => ["en" => "perugia","it" => "perugia"],
		"PI" => ["en" => "pisa","it" => "pisa"], "PN" => ["en" => "pordenone","it" => "pordenone"], "PO" => ["en" => "prato","it" => "prato"],
		"PR" => ["en" => "parma","it" => "parma"], "PT" => ["en" => "pistoia","it" => "pistoia"], "PU" => ["en" => "pesaro and urbino","it" => "pesaro and urbino"],
		"PV" => ["en" => "pavia","it" => "pavia"], "PZ" => ["en" => "potenza","it" => "potenza"], "RA" => ["en" => "ravenna","it" => "ravenna"],
		"RC" => ["en" => "reggio calabria","it" => "reggio calabria"], "RE" => ["en" => "reggio Emilia","it" => "reggio Emilia"], "RG" => ["en" => "ragusa","it" => "ragusa"],
		"RI" => ["en" => "rieti","it" => "rieti"], "RM" => ["en" => "rome","it" => "rome"], "RN" => ["en" => "rimini","it" => "rimini"],
		"RO" => ["en" => "rovigo","it" => "rovigo"], "SA" => ["en" => "salerno","it" => "salerno"], "SI" => ["en" => "siena","it" => "siena"], 
		"SO" => ["en" => "sondrio","it" => "sondrio"], "SP" => ["en" => "La spezia","it" => "La spezia"], "SR" => ["en" => "syracuse","it" => "syracuse"],
		"SS" => ["en" => "sassari","it" => "sassari"], "SV" => ["en" => "savona","it" => "savona"], "TA" => ["en" => "taranto","it" => "taranto"],
		"TE" => ["en" => "teramo","it" => "teramo"], "TN" => ["en" => "trento","it" => "trento"], "TO" => ["en" => "turin","it" => "turin"],
		"TP" => ["en" => "trapani","it" => "trapani"], "TR" => ["en" => "terni","it" => "terni"], "TS" => ["en" => "trieste","it" => "trieste"],
		"TV" => ["en" => "treviso","it" => "treviso"], "UD" => ["en" => "udine","it" => "udine"], "VA" => ["en" => "varese","it" => "varese"],
		"VB" => ["en" => "verbano cusio ossola","it" => "verbano cusio ossola"], "VC" => ["en" => "vercelli","it" => "vercelli"], "VE" => ["en" => "vercelli","it" => "vercelli"],
		"VI" => ["en" => "vicenza","it" => "vicenza"], "VR" => ["en" => "verona","it" => "verona"], "VS" => ["en" => "medio campidano","it" => "medio campidano"],
		"VT" => ["en" => "viterbo","it" => "viterbo"], "VV" => ["en" => "vibo valentia","it" => "vibo valentia"]
	);

	$stateCodeToRegex['MX'] = array(
		"AG" => "AG|AGUASCALIENTES", "BC" => "BC|BAJA CALIFORNIA", "BS" => "BS|BAJA CALIFORNIA SUR",
		"CO" => "CO|COAHUILA", "CH" => "CH|CHIHUAHUA","CL" => "CL|COLIMA",
		"CM" => "CM|CAMPECHE", "CS" => "CS|CHIAPAS", "DF" => "DF|MEXICO( CITY)?",
		"DG" => "DG|DURANGO", "EM" => "EM|MEXICO STATE","GR" => "GR|GUERRERO",
		"GT" => "GT|GUANAJUATO", "HG" => "HG|HIDALGO", "JA" => "JA|JALISCO",
		"MI" => "MI|MICHOACAN", "MO" => "MO|MORELOS","NA" => "NA|NAYARIT",
		"NL" => "NL|NEW LEON|NUEVO LEON", "OA" => "OA|OAXACA", "PU" => "PU|PUEBLA",
		"QE" => "QE|QUERETARO", "QR" => "QR|QUINTANA ROO","SI" => "SI|SINALOA",
		"SL" => "SL|SAN LUIS POTOSI", "SO" => "SO|SONORA", "TB" => "TB|TABASCO",
		"TL" => "TL|TLAXCALA", "TM" => "TM|TAMAULIPAS","VE" => "VE|VERACRUZ",
		"YU" => "YU|YUCATAN", "ZA" => "ZA|ZACATECAS"
	);

	$stateCodeToState['MX'] = array(
		"AG" => ["en" => "aguascalientes", "es" => "aguascalientes"], "BC" => ["en" => "lower california", "es" => "baja california"], "BS" => ["en" => "lower california south", "es" => "baja california sur"],
		"CO" => ["en" => "coahuila", "es" => "coahuila"], "CH" => ["en" => "chihuahua", "es" => "chihuahua"], "CL" => ["en" => "colima", "es" => "colima"],
		"CM" => ["en" => "campeche", "es" => "campeche"], "CS" => ["en" => "chiapas", "es" => "chiapas"], "DF" => ["en" => "mexico city", "es" => "mexico city"],
		"DG" => ["en" => "durango", "es" => "durango"], "EM" => ["en" => "mexico state", "es" => "mexico state"], "GR" => ["en" => "guerrero", "es" => "guerrero"],
		"GT" => ["en" => "guanajuato", "es" => "guanajuato"], "HG" => ["en" => "hidalgo", "es" => "hidalgo"], "JA" => ["en" => "jalisco", "es" => "jalisco"],
		"MI" => ["en" => "michoacan", "es" => "michoacan"], "MO" => ["en" => "morelos", "es" => "morelos"], "NA" => ["en" => "nayarit", "es" => "nayarit"],
		"NL" => ["en" => "new leon", "es" => "nuevo leon"], "OA" => ["en" => "oaxaca", "es" => "oaxaca"], "PU" => ["en" => "puebla", "es" => "puebla"],
		"QE" => ["en" => "queretaro", "es" => "queretaro"], "QR" => ["en" => "quintana roo", "es" => "quintana roo"], "SI" => ["en" => "sinaloa", "es" => "sinaloa"],
		"SL" => ["en" => "san luis potosi", "es" => "san luis potosi"], "SO" => ["en" => "sonora", "es" => "sonora"], "TB" => ["en" => "tabasco", "es" => "tabasco"],
		"TL" => ["en" => "tlaxcala", "es" => "tlaxcala"], "TM" => ["en" => "tamaulipas", "es" => "tamaulipas"], "VE" => ["en" => "veracruz", "es" => "veracruz"],
		"YU" => ["en" => "yucatan", "es" => "yucatan"], "ZA" => ["en" => "zacatecas", "es" => "zacatecas"]
	);

	$stateCodeToRegex['US'] = array(
		'AL' => 'AL|ALABAMA', 'AK' => 'AK|ALASKA', 'AZ' => 'AZ|ARIZONA', 'AR' => 'AR|ARKANSAS', 'CA' => 'CA|CALIFORNIA', 'CO' => 'CO|COLORADO',
		'CT' => 'CT|CONNECTICUT', 'DE' => 'DE|DELAWARE', 'FL' => 'FL|FLORIDA', 'GA' => 'GA|GEORGIA', 'HI' => 'HI|HAWAII', 'ID' => 'ID|IDAHO', 'IL' => 'IL|ILLINOIS',
		'IN' => 'IN|INDIANA', 'IA' => 'IA|IOWA', 'KS' => 'KS|KANSAS', 'KY' => 'KY|KENTUCKY', 'LA' => 'LA|LOUISIANA', 'ME' => 'ME|MAINE', 'MD' => 'MD|MARYLAND',
		'MA' => 'MA|MASSACHUSETTS', 'MI' => 'MI|MICHIGAN', 'MN' => 'MN|MINNESOTA', 'MS' => 'MS|MISSISSIPPI', 'MO' => 'MO|MISSOURI', 'MT' => 'MT|MONTANA', 'NE' => 'NE|NEBRASKA',
		'NV' => 'NV|NEVADA', 'NH' => 'NH|(NEW )?HAMPSHIRE', 'NJ' => 'NJ|(NEW )?JERSEY', 'NM' => 'NM|(NEW )?MEXICO', 'NY' => 'NY|(NEW )?YORK', 'NC' => 'NC|NORTH CAROLINA',
		'ND' => 'ND|NORTH DAKOTA', 'OH' => 'OH|OHIO', 'OK' => 'OK|OKLAHOMA', 'OR' => 'OR|OREGON', 'PA' => 'PA|PENNSYLVANIA', 'RI' => 'RI|RHODE ISLAND', 'SC' => 'SC|SOUTH CAROLINA',
		'SD' => 'SD|SOUTH DAKOTA', 'TN' => 'TN|TENNESSEE', 'TX' => 'TX|TEXAS', 'UT' => 'UT|UTAH', 'VT' => 'VT|VERMONT', 'VA' => 'VA|VIRGINIA', 'WA' => 'WA|WASHINGTON',
		'WV' => 'WV|WEST VIRGINIA', 'WI' => 'WI|WISCONSIN', 'WY' => 'WY|WYOMING', 'DC' => 'DC|(DISTRICT (OF )?)?COLUMBIA'
	);

	$stateCodeToState['US'] = array(
		'AL' => 'alabama', 'AK' => 'alaska', 'AZ' => 'arizona', 'AR' => 'arkansas', 'CA' => 'california', 'CO' => 'colorado',
		'CT' => 'connecticut', 'DE' => 'delaware', 'FL' => 'florida', 'GA' => 'georgia', 'HI' => 'hawaii', 'ID' => 'idaho', 'IL' => 'illinois',
		'IN' => 'indiana', 'IA' => 'iowa', 'KS' => 'kansas', 'KY' => 'kentucky', 'LA' => 'louisiana', 'ME' => 'maine', 'MD' => 'maryland',
		'MA' => 'massachusetts', 'MI' => 'michigan', 'MN' => 'minnesota', 'MS' => 'mississippi', 'MO' => 'missouri', 'MT' => 'montana', 'NE' => 'nebraska',
		'NV' => 'nevada', 'NH' => 'new hampshire', 'NJ' => 'new jersey', 'NM' => 'new mexico', 'NY' => 'new york', 'NC' => 'north carolina',
		'ND' => 'north dakota', 'OH' => 'ohio', 'OK' => 'oklahoma', 'OR' => 'oregon', 'PA' => 'pennsylvania', 'RI' => 'rhode island', 'SC' => 'south carolina',
		'SD' => 'south dakota', 'TN' => 'tennessee', 'TX' => 'texas', 'UT' => 'utah', 'VT' => 'vermont', 'VA' => 'virginia', 'WA' => 'washington',
		'WV' => 'west virginia', 'WI' => 'wisconsin', 'WY' => 'wyoming', 'DC' => 'district of columbia'
	);

	$stateCodeToRegex['ES'] = array(
		'09' => '09|BU|BURGOS', '13' => '13|CR|CIUDAD REAL', '52' => '52|ML|MELILLA', '21' => '21|H|HUELVA', '15' => '15|C|(A )?CORUÑA|CORUNA', '34' => '34|P|PALENCIA', '38' => '38|TF|SANTA CRUZ DE TENERIFE', '35' => '35|GC|(LAS )?PALMAS',
		'03' => '03|A|ALICANTE', '17' => '17|GI|GIRONA', '27' => '27|LU|LUGO', '31' => '31|NA|NAVARRA', '37' => '37|SA|SALAMANCA', '19' => '19|GU|GUADALAJARA', '32' => '32|OR|OURENSE', '45' => '45|TO|TOLEDO', '48' => '48|BI|BIZKAIA',
		'14' => '14|CO|CORDOBA', '22' => '22|HU|HUESCA', '02' => '02|AB|ALBACETE', '43' => '43|T|TARRAGONA', '16' => '16|CU|CUENCA', '47' => '47|VA|VALLADOLID', '28' => '28|M|MADRID', '08' => '08|B|BARCELONA', '40' => '40|SG|SEGOVIA',
		'49' => '49|ZA|ZAMORA', '26' => '26|RI|(LA )?RIOJA', '23' => '23|J|JAEN', '39' => '39|CB|CANTABRIA', '51' => '51|CE|CEUTA', '05' => '05|AV|AVILA', '01' => '01|ARABA', '29' => '29|MA|MALAGA', '25' => '25|L|LLEIDA', '18' => '18|GR|GRANADA',
		'24' => '24|LE|LEON', '41' => '41|SE|SEVILLA', '10' => '10|CC|CACERES', '06' => '06|BA|BADAJOZ', '20' => '20|SS|GIPUZKOA', '30' => '30|MC|MURCIA', '12' => '12|CA|CASTELLON', '42' => '42|SO|SORIA', '04' => '04|AL|ALMERIA',
		'33' => '33|O|ASTURIAS', '36' => '36|PO|PONTEVEDRA', '44' => '44|TE|TERUEL', '46' => '46|V|VALENCIA', '11' => '11|CA|CADIZ', '50' => '50|Z|ZARAGOZA', '07' => '07|IB|(ILLES)? BALEARS'
	);

	$stateCodeToState['ES'] = array(
		'09' => ["en" => "burgos","es" => "burgos"], '13' => ["en" => "real city","es" => "ciudad real"], '52' => ["en" => "melilla","es" => "melilla"],
		'21' => ["en" => "huelva","es" => "huelva"], '15' => ["en" => "coruna","es" => "a coruña"], '34' => ["en" => "palencia","es" => "palencia"],
		'38' => ["en" => "santa cruz of tenerife","es" => "santa cruz de tenerife"], '35' => ["en" => "las palmas","es" => "las palmas"], '03' => ["en" => "alicante","es" => "alicante"],
		'17' => ["en" => "girona","es" => "girona"], '27' => ["en" => "lugo","es" => "lugo"], '31' => ["en" => "navarra","es" => "navarra"],
		'37' => ["en" => "salamanca","es" => "salamanca"], '19' => ["en" => "guadalajara","es" => "guadalajara"], '32' => ["en" => "ourense","es" => "ourense"],
		'45' => ["en" => "toledo","es" => "toledo"], '48' => ["en" => "bizkaia","es" => "bizkaia"], '14' => ["en" => "cordoba","es" => "cordoba"],
		'22' => ["en" => "huesca","es" => "huesca"], '02' => ["en" => "albacete","es" => "albacete"], '43' => ["en" => "tarragona","es" => "tarragona"],
		'16' => ["en" => "cuenca","es" => "cuenca"], '47' => ["en" => "valladolid","es" => "valladolid"], '28' => ["en" => "madrid","es" => "madrid"],
		'08' => ["en" => "barcelona","es" => "barcelona"], '40' => ["en" => "segovia","es" => "segovia"], '49' => ["en" => "zamora","es" => "zamora"],
		'26' => ["en" => "the rioja","es" => "la rioja"], '23' => ["en" => "jaen","es" => "jaen"], '39' => ["en" => "cantabria","es" => "cantabria"],
		'51' => ["en" => "ceuta","es" => "ceuta"], '05' => ["en" => "avila","es" => "avila"], '01' => ["en" => "araba","es" => "araba"],
		'29' => ["en" => "malaga","es" => "malaga"], '25' => ["en" => "lleida","es" => "lleida"], '18' => ["en" => "grenade","es" => "granada"],
		'24' => ["en" => "lion","es" => "leon"], '41' => ["en" => "sevilla","es" => "seville"], '10' => ["en" => "caceres","es" => "caceres"],
		'06' => ["en" => "badajoz","es" => "badajoz"], '20' => ["en" => "gipuzkoa","es" => "gipuzkoa"], '30' => ["en" => "murcia","es" => "murcia"],
		'12' => ["en" => "castellon","es" => "castellon"], '42' => ["en" => "soria","es" => "soria"], '04' => ["en" => "almeria","es" => "almeria"],
		'33' => ["en" => "asturias","es" => "asturias"], '36' => ["en" => "pontevedra","es" => "pontevedra"], '44' => ["en" => "teruel","es" => "teruel"],
		'46' => ["en" => "valencia","es" => "valencia"], '11' => ["en" => "cadiz","es" => "cadiz"], '50' => ["en" => "saragossa","es" => "zaragoza"],
		'07' => ["en" => "balearic islands","es" => "illes balears"]
	);

	$stateCodeToRegex['GB'] = array(
		'RDG' => 'RDG|READING', 'OXF' => 'OXF|OXFORDSHIRE', 'GWN' => 'GWN|GWYNEDD', 'BNS' => 'BNS|BARNSLEY', 'CGN' => 'CGN|CEREDIGION', 'RIC' => 'RIC|RICHMOND UPON THAMES', 'NEL' => 'NEL|NORTH EAST LINCOLNSHIRE', 
		'ERW' => 'ERW|EAST RENFREWSHIRE', 'GAT' => 'GAT|GATESHEAD', 'WFT' => 'WFT|WALTHAM FOREST', 'ISL' => 'ISL|ISLINGTON', 'KWL' => 'KWL|KNOWSLEY', 'NYK' => 'NYK|NORTH YORKSHIRE', 'ZET' => 'ZET|SHETLAND ISLANDS', 
		'EDH' => 'EDH|EDINBURGH, CITY OF', 'SOM' => 'SOM|SOMERSET', 'RFW' => 'RFW|RENFREWSHIRE', 'ELN' => 'ELN|EAST LOTHIAN', 'RCT' => 'RCT|RHONDDA, CYNON, TAFF', 'IOW' => 'IOW|ISLE OF WIGHT', 'WRT' => 'WRT|WARRINGTON', 
		'ERY' => 'ERY|EAST RIDING OF YORKSHIRE', 'HAM' => 'HAM|HAMPSHIRE', 'CHW' => 'CHW|CHESHIRE WEST AND CHESTER', 'ORK' => 'ORK|ORKNEY ISLANDS', 'WLN' => 'WLN|WEST LOTHIAN', 'ESS' => 'ESS|ESSEX', 
		'BIR' => 'BIR|BIRMINGHAM', 'HRT' => 'HRT|HERTFORDSHIRE', 'CBF' => 'CBF|CENTRAL BEDFORDSHIRE', 'NTY' => 'NTY|NORTH TYNESIDE', 'NET' => 'NET|NEWCASTLE UPON TYNE', 'DOW' => 'DOW|DOWN', 'ABD' => 'ABD|ABERDEENSHIRE', 
		'MRY' => 'MRY|MORAY', 'STT' => 'STT|STOCKTON-ON-TEES', 'SRY' => 'SRY|SURREY', 'ELS' => 'ELS|EILEAN SIAR', 'WRX' => 'WRX|WREXHAM', 'MRT' => 'MRT|MERTON', 'ARM' => 'ARM|ARMAGH', 'SCB' => 'SCB|SCOTTISH BORDERS', 
		'TWH' => 'TWH|TOWER HAMLETS', 'HEF' => 'HEF|HEREFORDSHIRE', 'SAY' => 'SAY|SOUTH AYRSHIRE', 'KEC' => 'KEC|KENSINGTON AND CHELSEA', 'WRL' => 'WRL|WIRRAL', 'HNS' => 'HNS|HOUNSLOW', 'WBK' => 'WBK|WEST BERKSHIRE', 
		'BNE' => 'BNE|BARNET', 'LIV' => 'LIV|LIVERPOOL', 'GLS' => 'GLS|GLOUCESTERSHIRE', 'BRY' => 'BRY|BROMLEY', 'NTH' => 'NTH|NORTHAMPTONSHIRE', 'WSM' => 'WSM|WESTMINSTER', 'MDB' => 'MDB|MIDDLESBROUGH', 
		'NWP' => 'NWP|NEWPORT', 'SHN' => 'SHN|ST. HELENS', 'KIR' => 'KIR|KIRKLEES', 'SWK' => 'SWK|SOUTHWARK', 'FLN' => 'FLN|FLINTSHIRE', 'STN' => 'STN|SUTTON', 'HRY' => 'HRY|HARINGEY', 'CMN' => 'CMN|CARMARTHENSHIRE', 
		'CAY' => 'CAY|CAERPHILLY', 'MTY' => 'MTY|MERTHYR TYDFIL', 'GSY' => 'GSY|GUERNSEY', 'NBL' => 'NBL|NORTHUMBERLAND', 'BDG' => 'BDG|BARKING AND DAGENHAM', 'COV' => 'COV|COVENTRY', 'CLD' => 'CLD|CALDERDALE', 
		'HCK' => 'HCK|HACKNEY', 'NWM' => 'NWM|NEWHAM', 'KHL' => 'KHL|KINGSTON UPON HULL', 'BRC' => 'BRC|BRACKNELL FOREST', 'LEC' => 'LEC|LEICESTERSHIRE', 'DUR' => 'DUR|DURHAM, COUNTY', 'WLL' => 'WLL|WALSALL', 
		'SGC' => 'SGC|SOUTH GLOUCESTERSHIRE', 'DEV' => 'DEV|DEVON', 'MON' => 'MON|MONMOUTHSHIRE', 'LIN' => 'LIN|LINCOLNSHIRE', 'BGE' => 'BGE|BRIDGEND', 'KEN' => 'KEN|KENT', 'TOF' => 'TOF|TORFAEN', 'PKN' => 'PKN|PERTH AND KINROSS', 
		'SAW' => 'SAW|SANDWELL', 'DND' => 'DND|DUNDEE CITY', 'WNM' => 'WNM|WINDSOR AND MAIDENHEAD', 'HIL' => 'HIL|HILLINGDON', 'NFK' => 'NFK|NORFOLK', 'IOM' => 'IOM|ISLE OF MAN', 'BEX' => 'BEX|BEXLEY', 'STY' => 'STY|SOUTH TYNESIDE', 
		'BRD' => 'BRD|BRADFORD', 'ANS' => 'ANS|ANGUS', 'WAR' => 'WAR|WARWICKSHIRE', 'GRE' => 'GRE|GREENWICH', 'LEW' => 'LEW|LEWISHAM', 'TYR' => 'TYR|TYRONE', 'CWY' => 'CWY|CONWY', 'FER' => 'FER|FERMANAGH', 'GLG' => 'GLG|GLASGOW CITY', 
		'ANT' => 'ANT|ANTRIM', 'SHR' => 'SHR|SHROPSHIRE', 'CRF' => 'CRF|CARDIFF', 'CON' => 'CON|CORNWALL', 'SLG' => 'SLG|SLOUGH', 'WIL' => 'WIL|WILTSHIRE', 'HRW' => 'HRW|HARROW', 'HAL' => 'HAL|HALTON', 'DUD' => 'DUD|DUDLEY',
		'DGY' => 'DGY|DUMFRIES AND GALLOWAY', 'SFK' => 'SFK|SUFFOLK', 'DEN' => 'DEN|DENBIGHSHIRE', 'BDF' => 'BDF|BEDFORD', 'DBY' => 'DBY|DERBYSHIRE', 'WSX' => 'WSX|WEST SUSSEX', 'BAS' => 'BAS|BATH AND NORTH EAST SOMERSET', 
		'RDB' => 'RDB|REDBRIDGE', 'WND' => 'WND|WANDSWORTH','WLV' => 'WLV|WOLVERHAMPTON', 'CAM' => 'CAM|CAMBRIDGESHIRE', 'ENF' => 'ENF|ENFIELD', 'BKM' => 'BKM|BUCKINGHAMSHIRE', 'NAY' => 'NAY|NORTH AYRSHIRE', 'ROT' => 'ROT|ROTHERHAM', 
		'FIF' => 'FIF|FIFE', 'POW' => 'POW|POWYS', 'LBH' => 'LBH|LAMBETH', 'CMA' => 'CMA|CUMBRIA', 'ESX' => 'ESX|EAST SUSSEX', 'KTT' => 'KTT|KINGSTON UPON THAMES','DRY' => 'DRY|DERRY', 'SND' => 'SND|SUNDERLAND', 
		'CMD' => 'CMD|CAMDEN', 'NSM' => 'NSM|NORTH SOMERSET', 'DOR' => 'DOR|DORSET', 'NTL' => 'NTL|NEATH PORT TALBOT', 'DNC' => 'DNC|DONCASTER', 'WOK' => 'WOK|WOKINGHAM','HLD' => 'HLD|HIGHLAND', 'BST' => 'BST|BRISTOL, CITY OF','JSY' => 'JSY|JERSEY',
		'LUT' => 'LUT|LUTON','EAL' => 'EAL|EALING','SFT' => 'SFT|SEFTON','LND' => 'LND|LONDON, CITY OF','SHF' => 'SHF|SHEFFIELD','LDS' => 'LDS|LEEDS','SOL' => 'SOL|SOLIHULL','SWA' => 'SWA|SWANSEA','PEM' => 'PEM|PEMBROKESHIRE',
		'BEN' => 'BEN|BRENT','VGL' => 'VGL|VALE OF GLAMORGAN, THE ','STS' => 'STS|STAFFORDSHIRE','WKF' => 'WKF|WAKEFIELD','HPL' => 'HPL|HARTLEPOOL','WDU' => 'WDU|WEST DUNBARTONSHIRE','HMF' => 'HMF|HAMMERSMITH AND FULHAM','MLN' => 'MLN|MIDLOTHIAN',
		'CRY' => 'CRY|CROYDON','SLK' => 'SLK|SOUTH LANARKSHIRE','EAY' => 'EAY|EAST AYRSHIRE','WOR' => 'WOR|WORCESTERSHIRE','LAN' => 'LAN|LANCASHIRE','IOS' => 'IOS|ISLES OF SCILLY','NLN' => 'NLN|NORTH LINCOLNSHIRE',
		'BGW' => 'BGW|BLAENAU GWENT','CHE' => 'CHE|CHESHIRE EAST','NLK' => 'NLK|NORTH LANARKSHIRE','IVC' => 'IVC|INVERCLYDE','RCC' => 'RCC|REDCAR AND CLEVELAND', 'NTT' => 'NTT|NOTTINGHAMSHIRE',
		'AGB' => 'AGB|argyll and bute','ABE' => 'ABE|aberdeen city','HAV' => 'HAV|havering','EDU' => 'EDU|east dunbartonshire'
	);

	$stateCodeToState['GB'] = array(
		'RDG' => 'reading', 'OXF' => 'oxfordshire', 'GWN' => 'gwynedd', 'BNS' => 'barnsley', 'CGN' => 'ceredigion', 'RIC' => 'richmond upon thames', 'NEL' => 'north east lincolnshire', 
		'ERW' => 'east renfrewshire', 'GAT' => 'gateshead', 'WFT' => 'waltham forest', 'ISL' => 'islington', 'KWL' => 'knowsley', 'NYK' => 'north yorkshire', 'ZET' => 'shetland islands', 
		'EDH' => 'edinburgh, city of', 'SOM' => 'somerset', 'RFW' => 'renfrewshire', 'ELN' => 'east lothian', 'RCT' => 'rhondda, cynon, taff', 'IOW' => 'isle of wight', 'WRT' => 'warrington', 
		'ERY' => 'east riding of yorkshire', 'HAM' => 'hampshire', '' => 'cheshire west and chester', 'ORK' => 'orkney islands', 'WLN' => 'west lothian', 'ESS' => 'essex', 
		'BIR' => 'birmingham', 'HRT' => 'hertfordshire', 'CBF' => 'central bedfordshire', 'NTY' => 'north tyneside', 'NET' => 'newcastle upon tyne', 'DOW' => 'down', 'ABD' => 'aberdeenshire', 
		'MRY' => 'moray', 'STT' => 'stockton-on-tees', 'SRY' => 'surrey', 'ELS' => 'eilean siar', 'WRX' => 'wrexham', 'MRT' => 'Merton', 'ARM' => 'armagh', 'SCB' => 'scottish Borders', 
		'TWH' => 'tower hamlets', 'HEF' => 'herefordshire', 'SAY' => 'south ayrshire', 'KEC' => 'kensington and chelsea', 'WRL' => 'wirral', 'HNS' => 'hounslow', 'WBK' => 'west berkshire', 
		'BNE' => 'barnet', 'LIV' => 'liverpool', 'GLS' => 'gloucestershire', 'BRY' => 'bromley', 'NTH' => 'northamptonshire', 'WSM' => 'westminster', 'MDB' => 'middlesbrough', 
		'NWP' => 'newport', 'SHN' => 'st. helens', 'KIR' => 'kirklees', 'SWK' => 'southwark', 'FLN' => 'flintshire', 'STN' => 'sutton', 'HRY' => 'haringey', 'CMN' => 'carmarthenshire', 
		'CAY' => 'caerphilly', 'MTY' => 'merthyr tydfil', 'GSY' => 'guernsey', 'NBL' => 'northumberland', 'BDG' => 'barking and dagenham', 'COV' => 'coventry', 'CLD' => 'calderdale', 
		'HCK' => 'hackney', 'NWM' => 'newham', 'KHL' => 'kingston upon hull', 'BRC' => 'bracknell forest', 'LEC' => 'leicestershire', 'DUR' => 'durham, county', 'WLL' => 'walsall', 
		'SGC' => 'south gloucestershire', 'DEV' => 'devon', 'MON' => 'monmouthshire', 'LIN' => 'lincolnshire', 'BGE' => 'bridgend', 'KEN' => 'kent', 'TOF' => 'torfaen', 'PKN' => 'perth and kinross', 
		'SAW' => 'sandwell', 'DND' => 'dundee City', 'WNM' => 'windsor and maidenhead', 'HIL' => 'hillingdon', 'NFK' => 'norfolk', 'IOM' => 'isle of man', 'BEX' => 'bexley', 'STY' => 'south tyneside', 
		'BRD' => 'bradford', 'ANS' => 'angus', 'WAR' => 'warwickshire', 'GRE' => 'greenwich', 'LEW' => 'lewisham', 'TYR' => 'tyrone', 'CWY' => 'conwy', 'FER' => 'fermanagh', 'GLG' => 'glasgow city', 
		'ANT' => 'antrim', 'SHR' => 'shropshire', 'CRF' => 'cardiff', 'CON' => 'cornwall', 'SLG' => 'slough', 'WIL' => 'wiltshire', 'HRW' => 'harrow', 'HAL' => 'halton', 'DUD' => 'dudley',
		'DGY' => 'dumfries and galloway', 'SFK' => 'suffolk', 'DEN' => 'denbighshire', 'BDF' => 'bedford', 'DBY' => 'derbyshire', 'WSX' => 'west sussex', 'BAS' => 'bath and north east somerset', 
		'RDB' => 'redbridge', 'WND' => 'wandsworth','WLV' => 'wolverhampton', 'CAM' => 'cambridgeshire', 'ENF' => 'enfield', 'BKM' => 'buckinghamshire', 'NAY' => 'north ayrshire', 'ROT' => 'rotherham', 
		'FIF' => 'fife', 'POW' => 'powys', 'LBH' => 'lambeth', 'CMA' => 'cumbria', 'ESX' => 'east sussex', 'KTT' => 'kingston upon thames','DRY' => 'derry', 'SND' => 'sunderland', 
		'CMD' => 'camden', 'NSM' => 'north somerset', 'DOR' => 'dorset', 'NTL' => 'neath port talbot', 'DNC' => 'doncaster', 'WOK' => 'wokingham','HLD' => 'highland', 'BST' => 'bristol, city of','JSY' => 'jersey',
		'LUT' => 'luton','EAL' => 'ealing','SFT' => 'sefton','LND' => 'london, city of','SHF' => 'sheffield','LDS' => 'leeds','SOL' => 'solihull','SWA' => 'swansea','PEM' => 'pembrokeshire',
		'BEN' => 'brent','VGL' => 'vale of glamorgan, the ','STS' => 'staffordshire','WKF' => 'wakefield','HPL' => 'hartlepool','WDU' => 'west dunbartonshire','HMF' => 'hammersmith and fulham','MLN' => 'midlothian',
		'CRY' => 'croydon','SLK' => 'south lanarkshire','EAY' => 'east ayrshire','WOR' => 'worcestershire','LAN' => 'lancashire','IOS' => 'isles of scilly','NLN' => 'north lincolnshire',
		'BGW' => 'blaenau gwent','CHE' => 'cheshire east','NLK' => 'north lanarkshire','IVC' => 'inverclyde','RCC' => 'redcar and cleveland', 'NTT' => 'nottinghamshire',
		'AGB' => 'argyll and bute','ABE' => 'aberdeen city','HAV' => 'havering','EDU' => 'east dunbartonshire'
	);

	$stateCodeToRegex['IE'] = array(
		'CN' => 'CN|CAVAN', 'MO' => 'MO|MAYO', 'WX' => 'WX|WEXFORD', 'LD' => 'LD|LONGFORD', 'WD' => 'WD|WATERFORD', 'LM' => 'LM|LEITRIM', 'CW' => 'CW|CARLOW', 'WW' => 'WW|WICKLOW', 'KK' => 'KK|KILKENNY', 
		'LS' => 'LS|LAOIS', 'G'  => 'G|GALWAY', 'SO' => 'SO|SLIGO', 'RN' => 'RN|ROSCOMMON', 'KE' => 'KE|KILDARE', 'WH' => 'WH|WESTMEATH', 'TA' => 'TA|TIPPERARY', 'CE' => 'CE|CLARE', 'DL' => 'DL|DONEGAL', 
		'KY' => 'KY|KERRY', 'OY' => 'OY|OFFALY', 'LH' => 'LH|LOUTH', 'LK' => 'LK|LIMERICK', 'CO' => 'CO|CORK', 'MH' => 'MH|MEATH', 'D'  => 'D|DUBLIN', 'MN' => 'MN|MONAGHAN' 
	);

	$stateCodeToState['IE'] = array(
		'CN' => 'cavan', 'MO' => 'mayo', 'WX' => 'wexford', 'LD' => 'longford', 'WD' => 'waterford', 'LM' => 'leitrim', 'CW' => 'carlow', 'WW' => 'wicklow', 'KK' => 'kilkenny', 
		'LS' => 'laois', 'G'  => 'galway', 'SO' => 'sligo', 'RN' => 'roscommon', 'KE' => 'kildare', 'WH' => 'westmeath', 'TA' => 'tipperary', 'CE' => 'clare', 'DL' => 'donegal', 
		'KY' => 'kerry', 'OY' => 'offaly', 'LH' => 'louth', 'LK' => 'limerick', 'CO' => 'cork', 'MH' => 'meath', 'D'  => 'dublin', 'MN' => 'monaghan' 
	);

	$stateCodeToRegex['JP'] = array(
		'8'  => '8|IBARAKI', '45' => '45|MIYAZAKI', '18' => '18|HUKUI', '32' => '32|SIMANE', '31' => '31|TOTTORI', '41' => '41|SAGA', '37' => '37|KAGAWA', '19' => '19|YAMANASI', 
		'6'  => '6|YAMAGATA', '39' => '39|KÔTI|KOTI', '4'  => '4|MIYAGI', '42' => '42|NAGASAKI', '1'  => '1|HOKKAIDÔ|HOKKAIDO', '2'  => '2|AOMORI', '15' => '15|NIGATA', '14' => '14|KANAGAWA', '28' => '28|HYÔGO|HYOGO', 
		'20' => '20|NAGANO', '38' => '38|EHIME', '22' => '22|SIZUOKA', '47' => '47|OKINAWA', '23' => '23|AITI', '7'  => '7|HUKUSIMA', '13' => '13|TÔKYÔ|TOKYO', '9'  => '9|TOTIGI', '44' => '44|ÕITA|OITA', '46' => '46|KAGOSIMA', 
		'10' => '10|GUNMA', '35' => '35|YAMAGUTI', '26' => '26|KYÔTO|KYOTO', '5'  => '5|AKITA', '21' => '21|GIHU', '36' => '36|TOKUSIMA', '29' => '29|NARA', '12' => '12|TIBA', '30' => '30|WAKAYAMA', '43' => '43|KUMAMOTO', 
		'11' => '11|SAITAMA', '3'  => '3|IWATE', '24' => '24|MIE', '33' => '33|OKAYAMA', '17' => '17|ISIKAWA','25' => '25|SIGA', '16' => '16|TOYAMA', '40' => '40|HUKUOKA', '27' => '27|ÕSAKA|OSAKA', '34' => '34|HIROSIMA' 
	);

	$stateCodeToState['JP'] = array(
		'8'  => 'ibaraki', '45' => 'miyazaki', '18' => 'hukui', '32' => 'simane', '31' => 'tottori', '41' => 'saga', '37' => 'kagawa', '19' => 'yamanasi', 
		'6'  => 'yamagata', '39' => 'kôti', '4'  => 'miyagi', '42' => 'nagasaki', '1'  => 'hokkaidô', '2'  => 'aomori', '15' => 'nigata', '14' => 'kanagawa', '28' => 'hyôgo', 
		'20' => 'nagano', '38' => 'ehime', '22' => 'sizuoka', '47' => 'okinawa', '23' => 'aiti', '7'  => 'hukusima', '13' => 'tôkyô', '9'  => 'totigi', '44' => 'õita', '46' => 'kagosima', 
		'10' => 'gunma', '35' => 'yamaguti', '26' => 'kyôto', '5'  => 'akita', '21' => 'gihu', '36' => 'tokusima', '29' => 'nara', '12' => 'tiba', '30' => 'wakayama', '43' => 'kumamoto', 
		'11' => 'saitama', '3'  => 'iwate', '24' => 'mie', '33' => 'okayama', '17' => 'isikawa','25' => 'siga', '16' => 'toyama', '40' => 'hukuoka', '27' => 'õsaka', '34' => 'hirosima' 
	);
}
