<?php
$lang['help_function_page_selector'] = '<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>name</th>
		<td>string</td>
		<td>Der Name des Eingabefelds.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>value</th>
		<td>int</td>
		<td>Die ID der aktuell ausgewählten Seite.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>allowcurrent</th>
		<td>bool</td>
		<td>Ob das aktuell ausgewählte Element erneut ausgewählt werden darf oder nicht. Der Standardwert ist false.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>allow_all</th>
		<td>bool</td>
		<td>Ob inaktive Inhaltsobjekte oder Inhaltsobjekte, die keine verwendbaren Links haben, ausgewählt werden dürfen oder nicht. Der Standardwert ist false.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>for_child</th>
		<td>bool</td>
		<td>Gibt an, dass wir eine übergeordnete Seite für ein neues Inhaltsobjekt auswählen. Der Standardwert ist false.</td>
	</tr>
</table>';
$lang['help_function_cms_html_options'] = '<h3>Was macht dieses Plugin?</h3>
<p>Dies ist ein leistungsstarkes Plugin, um Optionen für Auswahlelemente in HTML <option>- und <optgroup>-Tags zu rendern. Jede Option kann Unterelemente, einen eigenen Titel-Tag und ein eigenes Klassenattribut haben.</p>
<h3>Verwendung:</h3>
<pre><code>{cms_html_options options=$options [selected=value]}</code></pre>
<h3>Welche Parameter werden akzeptiert?</h3>
<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>options</th>
		<td>array</td>
		<td>Ein Array von Optionsdefinitionen.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>selected</th>
		<td>string</td>
		<td>Der Wert, der automatisch in der Dropdown-Liste ausgewählt werden soll. Muss dem Wert einer der Optionen entsprechen.</td>
	</tr>
</table>
<h4>Optionen</h4>
<p>Jede Option ist ein assoziatives Array mit zwei oder mehr der folgenden Elemente:</p>
<table>
	<tr>
		<th scope=\\\'col\\\'>Element</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>label</th>
		<td>string (erforderlich)</td>
		<td>Ein Label für die Option (das dem Benutzer präsentiert wird).</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>value</th>
		<td>mixed (erforderlich)</td>
		<td>Entweder ein Zeichenfolgenwert für die Option oder ein Array von Optionsdefinitionen.
			<p>Wenn der Wert einer Optionsdefinition selbst ein Array von Optionen ist, wird das Label als optgroup mit Unterelementen gerendert.</p>
		</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>title</th>
		<td>string</td>
		<td>Ein Titelattribut für die Option.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>class</th>
		<td>string</td>
		<td>Ein Klassenname für die Option.</td>
	</tr>
</table>

<h3>Beispiel:</h3>
<pre><code>
{$opts[]=[\'label\'=>\'Vogel\',\'value\'=>\'b\',\'title\'=>\'Ich habe einen Haustiervogel\']}
{$opts[]=[\'label\'=>\'Fisch\',\'value\'=>\'f\']}
{$sub[]=[\'label\'=>\'Kleiner Hund\',\'value\'=>\'sd\']}
{$sub[]=[\'label\'=>\'Mittlerer Hund\',\'value\'=>\'md\']}
{$sub[]=[\'label\'=>\'Großer Hund\',\'value\'=>\'ld\']}
{$opts[]=[\'label\'=>\'Hund\',\'value\'=>$sub]}
{$opts[]=[\'label\'=>\'Katze\',\'value\'=>\'c\',\'class\'=>\'katze\']}
<select name=\\\'haustier\\\'>
	{cms_html_options options=$opts selected=\'md\'}
</select></code></pre>';
$lang['help_modifier_cms_date_format'] = '<h3>Beschreibung</h3>
<p>Dieser Modifikator formatiert Datumsangaben in ein geeignetes Format. Es nutzt die regulären „strftime“-Parameter. Wenn keine Format-Zeichenfolge angegeben ist, verwendet das System die Benutzereinstellungen des Datumsformats (für angemeldete Benutzer) oder das Standard-Datumsformat des Systems.</p>
<p>Dieser Modifikator ist in der Lage, Daten in vielen Formaten zu verstehen, z. B. Datumsausgaben aus der Datenbank oder Integer-Zeitstempel, die von der Funktion time() erzeugt werden.</p>
<h3>Verwendung</h3>
<pre><code>{$some_date_var|cms_date_format[:<format string>]}</code></pre>
<h3>Beispiel</ h3>
<pre><code>{\'2012-03-24 22:44:22 \'|cms_date_format}</code></pre>';
$lang['help_modifier_cms_escape'] = '<h3>Was macht das?</h3>
<p>Dieser Modifikator wird verwendet, um den String auf verschiedene Arten zu escapen. Dies kann verwendet werden, um den String in mehrere verschiedene Anzeigeformate zu konvertieren oder um Benutzereingaben mit Sonderzeichen auf einer Standard-Webseite darstellbar zu machen.</p>
<h3>Verwendung:</h3>
<pre><code>{$some_var_with_text|cms_escape[:<escape type>|[<character set>]]}</code></pre>
<h4>Gültige Escape-Typen:</h4>
<table>
	<tr>
		<th scope=\\\'col\\\'>Escape-Typ</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>html (Standard)</th>
		<td>Verwendet htmlspecialchars.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>htmlall</th>
		<td>Verwendet htmlentities.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>url</th>
		<td>Kodiert alle Entitäten als Roh-URL.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>urlpathinfo</th>
		<td>Ähnlich wie der URL-Escape-Typ, kodiert aber auch /.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>quotes</th>
		<td>Escapen von unmaskierten einfachen Anführungszeichen.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>hex</th>
		<td>Escapen jedes Zeichens in Hexadezimal.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>hexentity</th>
		<td>Hexadezimale Kodierung jedes Zeichens.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>decentity</th>
		<td>Dezimale Kodierung jedes Zeichens.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>javascript</th>
		<td>Escapen von Anführungszeichen, Backslashes, Zeilenumbrüchen usw.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>mail</th>
		<td>Kodiert eine E-Mail-Adresse in etwas, das sicher angezeigt werden kann.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>nonstd</th>
		<td>Escapen von nicht standardmäßigen Zeichen, wie Dokumentanführungszeichen.</td>
	</tr>
</table>
<h4>Zeichensatz:</h4>
<p>Wenn der Zeichensatz nicht angegeben ist, wird utf-8 angenommen. Der Zeichensatz ist nur für die Escape-Typen „html“ und „htmlall“ anwendbar.</p>';
$lang['help_modifier_relative_time'] = '<h3>Was macht das?</h3>
<p>Dieser Modifikator wandelt einen ganzzahligen Zeitstempel oder eine Zeit-/Datumszeichenfolge in eine menschenlesbare Zeitspanne von oder bis jetzt um, z. B.: „vor 3 Stunden“</p>
<h3>Welche Parameter akzeptiert er?</h3>
<p>Dieser Modifikator akzeptiert keine optionalen Parameter.</p>
<h3>Beispiel:</h3>
<pre><code>{$some_timestamp|relative_time}</code></pre>';
$lang['help_modifier_summarize'] = '<h3>Was macht das?</h3>
<p>Dieser Modifikator wird verwendet, um eine lange Textsequenz auf eine begrenzte Anzahl von Wörtern zu kürzen.</p>
<h3>Verwendung:</h3>
<pre><code>{$some_var_with_long_text|summarize:<Anzahl>}</code></pre>
<h3>Beispiel:</h3>
<p>Im folgenden Beispiel würden alle HTML-Tags aus dem Inhalt entfernt und der Text nach 50 Wörtern gekürzt.</p>
<pre><code>{content|strip_tags|summarize:50}</code></pre>';
$lang['help_function_admin_icon'] = '<h3>Was macht das?</h3>
	<p>Dies ist ein Plugin nur für den Administrationsbereich, das Modulen ermöglicht, Piktogramme aus dem aktuellen Admin-Theme einfach anzuzeigen. Diese Piktogramme sind nützlich beim Erstellen von Links oder beim Anzeigen von Statusinformationen.</p>
	<h3>Welche Parameter akzeptiert es?</h3>
	<table>
		<tr>
			<th scope=\\\'col\\\'>Parameter</th>
			<th scope=\\\'col\\\'>Typ</th>
			<th scope=\\\'col\\\'>Beschreibung</th>
		</tr>
		<tr>
			<th scope=\\\'row\\\'>icon</th>
			<td>erforderlich</td>
			<td>Der Dateiname des Bilds, z. B.: run.gif</td>
		</tr>
		<tr>
			<th scope=\\\'row\\\'>height</th>
			<td>optional</td>
			<td>Die Höhe des Bilds in Pixeln.</td>
		</tr>
		<tr>
			<th scope=\\\'row\\\'>width</th>
			<td>optional</td>
			<td>Die Breite des Bilds in Pixeln.</td>
		</tr>
		<tr>
			<th scope=\\\'row\\\'>alt</th>
			<td>optional</td>
			<td>Alternativtext für das img-Tag, falls der angegebene Dateiname nicht verfügbar ist.</td>
		</tr>
		<tr>
			<th scope=\\\'row\\\'>rel</th>
			<td>optional</td>
			<td>Ein rel-Attribut für das img-Tag.</td>
		</tr>
		<tr>
			<th scope=\\\'row\\\'>class</th>
			<td>optional</td>
			<td>Ein class-Attribut für das img-Tag.</td>
		</tr>
		<tr>
			<th scope=\\\'row\\\'>id</th>
			<td>optional</td>
			<td>Ein id-Attribut für das img-Tag.</td>
		</tr>
		<tr>
			<th scope=\\\'row\\\'>title</th>
			<td>optional</td>
			<td>Ein title-Attribut für das img-Tag.</td>
		</tr>
		<tr>
			<th scope=\\\'row\\\'>accesskey</th>
			<td>optional</td>
			<td>Ein Zugriffstasten-Zeichen für das img-Tag.</td>
		</tr>
		<tr>
			<th scope=\\\'row\\\'>assign</th>
			<td>optional</td>
			<td>Weist die Ausgabe der benannten Smarty-Variable zu.</td>
		</tr>
	</table>
	<h3>Beispiel:</h3>
	<pre><code>{admin_icon icon=\'edit.gif\' class=\'editicon\'}</code></pre>';
$lang['help_function_cms_action_url'] = '<h3>Was macht das?</h3>
<p>Dies ist ein intelligentes Plugin, das nützlich ist, um eine URL zu einer Modulaktion zu generieren. Dieses Plugin ist nützlich für Modulentwickler, die Links generieren (entweder für Ajax oder im Administrationsbereich), um verschiedene Funktionen auszuführen oder verschiedene Daten anzuzeigen.</p>
<h3>Welche Parameter nimmt es?</h3>
<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>module</th>
		<td>optional</td>
		<td>Der Modulname, für den eine URL generiert werden soll. Dieser Parameter ist nicht erforderlich, wenn eine URL von innerhalb einer Modulaktion zu einer Aktion innerhalb desselben Moduls generiert wird.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>action</th>
		<td>erforderlich</td>
		<td>Der Aktionsname, für den eine URL generiert werden soll.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>returnid</th>
		<td>optional</td>
		<td>Die Ganzzahl-Seiten-ID, um die Ergebnisse der Aktion anzuzeigen. Dieser Parameter ist nicht erforderlich, wenn die Aktion auf der aktuellen Seite angezeigt werden soll oder wenn die URL zu einer Administrationsaktion von innerhalb einer Administrationsaktion ist.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>mid</th>
		<td>optional</td>
		<td>Die Modulaktions-ID. Dies wird standardmäßig auf „m1_“ für Administrationsaktionen und „cntnt01“ für Frontendaktionen festgelegt.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>forjs</th>
		<td>optional</td>
		<td>Eine optionale Ganzzahl, die angibt, dass die generierte URL für die Verwendung in JavaScript geeignet sein sollte.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>assign</th>
		<td>optional</td>
		<td>Weist die Ausgabe-URL der benannten Smarty-Variablen zu.</td>
	</tr>
</table>
<p><strong>Hinweis:</strong> Alle anderen Parameter, die von diesem Plugin nicht akzeptiert werden, werden automatisch an die aufgerufene Modulaktion in der generierten URL übergeben.</p>
<h3>Beispiel:</h3>
<pre><code>{cms_action_url module=News action=defaultadmin}</code></pre>';
$lang['help_function_cms_admin_user'] = '<h3>Was macht das?</h3>
<p>Dieses Admin-Plugin gibt Informationen über die angegebene Admin-Benutzer-ID aus.</p>

<h3>Welche Parameter akzeptiert es?</h3>
<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>uid</th>
		<td>erforderlich</td>
		<td>Eine Ganzzahl-Benutzer-ID, die ein gültiges Admin-Konto darstellt.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>mode</th>
		<td>optional</td>
		<td>Der Betriebsmodus. Mögliche Werte sind:
			<table>
				<tr>
					<th scope=\\\'col\\\'>Wert</th>
					<th scope=\\\'col\\\'>Beschreibung</th>
				</tr>
				<tr>
					<th scope=\\\'row\\\'>username</th>
					<td>(Standard) - gibt den Benutzernamen für die angegebene uid aus.</td>
				</tr>
				<tr>
					<th scope=\\\'row\\\'>email</th>
					<td>gibt die E-Mail-Adresse für die angegebene uid aus.</td>
				</tr>
				<tr>
					<th scope=\\\'row\\\'>firstname</th>
					<td>gibt den Vornamen für die angegebene uid aus.</td>
				</tr>
				<tr>
					<th scope=\\\'row\\\'>lastname</th>
					<td>gibt den Nachnamen für die angegebene uid aus.</td>
				</tr>
				<tr>
					<th scope=\\\'row\\\'>fullname</th>
					<td>gibt den vollständigen Namen für die angegebene uid aus.</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>assign</th>
		<td>optional</td>
		<td>Weist die Ausgabe der benannten Smarty-Variablen zu.</td>
	</tr>
</table>

<h3>Beispiel:</h3>
<pre><code>{cms_admin_user uid=1 mode=email}</code></pre>';
$lang['help_function_cms_get_language'] = '<h3>Was macht das?</h3>
<p>Dieses Plugin gibt den aktuellen CMSMS-Sprachnamen zurück. Die Sprache wird für Übersetzungszeichenfolgen und Datumsformatierung verwendet.</p>

<h3>Welche Parameter akzeptiert es?</h3>
<table>
  <tr>
    <th scope=\\\'row\\\'>assign</th>
    <td>(optional) – weist die Ausgabe des Plugins der benannten Smarty-Variablen zu.</td>
  </tr>
</table>';
$lang['help_function_cms_help'] = '<h3>Was macht das?</h3>
<p>Dies ist ein Admin-Plugin, das verwendet wird, um einen Link zu generieren, der beim Klicken Popup-Hilfe für ein bestimmtes Element generiert.</p>
<p>Dieses Plugin wird in der Regel aus Modul-Admin-Vorlagen verwendet, um Endbenutzerhilfe in einem Popup-Fenster für ein Eingabefeld, eine Spalte oder andere wichtige Informationen anzuzeigen.</p>

<h3>Welche Parameter akzeptiert es?</h3>
<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>key</th>
		<td>erforderlich</td>
		<td>Der zweite Teil in einem eindeutigen Schlüssel zur Identifizierung der anzuzeigenden Hilfesequenz. Dies ist normalerweise der Schlüssel aus der entsprechenden Sprachdatei des Bereichs.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>realm</th>
		<td>optional</td>
		<td>Der erste Teil in einem eindeutigen Schlüssel zur Identifizierung der Hilfesequenz. Wenn dieser Parameter nicht angegeben wird und dieses Plugin aus einer Modulaktion aufgerufen wird, wird normalerweise der aktuelle Modulname verwendet. Wenn kein Modulname gefunden werden kann, wird \\\'help\\\' als Sprachbereich verwendet.</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>title</th>
		<td>optional</td>
		<td>Titel des Hilfefensters</td>
	</tr>
	<tr>
		<th scope=\\\'row\\\'>assign</th>
		<td>optional</td>
		<td>Weist die Ausgabe der benannten Smarty-Variablen zu.</td>
	</tr>
</table>

<h3>Beispiel:</h3>
<pre><code>{cms_help key2=\'help_field_username\' title=$foo}</code></pre>';
$lang['help_function_cms_init_editor'] = '<h3>Was macht das?</h3>
<p>Dieses Plugin wird verwendet, um den ausgewählten visuellen Editor zu initialisieren, damit die WYSIWYG-Funktionalitäten für die Übermittlung von Frontend-Daten erforderlich sind. Dieses Modul wird den ausgewählten visuellen Editor für die öffentliche Website finden <em>(siehe globale Einstellungen)</em>, feststellen, ob er angefordert wurde, und falls ja, den entsprechenden HTML-Code generieren <em>(normalerweise JavaScript-Links)</em>, damit der Editor ordnungsgemäß initialisiert wird, wenn die Seite geladen wird. Wenn keine visuellen Editoren für die Frontend-Anforderung angefordert wurden, wird dieses Plugin keine Ausgabe erzeugen.</p>

<h3>Wie wird es verwendet?</h3>
<p>Zuerst müssen Sie den visuellen Editor in den globalen Einstellungen im Administrationsbereich auswählen. Wenn Sie visuelle Editoren auf zahlreichen Seiten verwenden, ist es möglicherweise am besten, das Plugin <code>{cms_init_editor}</code> direkt in Ihre Seitenvorlage einzubinden. Wenn Sie den visuellen Editor nur auf einer begrenzten Anzahl von Seiten aktivieren müssen, können Sie ihn einfach in das Feld „Seitenspezifische Metadaten“ auf jeder Seite platzieren.</p>

<h3>Welche Parameter werden akzeptiert?</h3>
<table>
	<tr>
		<th scope=\\\'col\\\'>Parameter</th>
		<th scope=\\\'col\\\'>Typ</th>
		<th scope=\\\'col\\\'>Beschreibung</th>
	</tr>
	<tr>
		<td>assign</td>
		<td>optional</td>
		<td>Weist die Ausgabe des Plugins der benannten Smarty-Variablen zu.</td>
	</tr>
</table>';
$lang['function'] = 'Funktionen können eine Aufgabe ausführen oder die Datenbank abfragen und normalerweise eine Ausgabe anzeigen. Sie können wie folgt aufgerufen werden: <code>{tagname [attribute=value…]}</code>';
$lang['modifier'] = 'Modifikatoren nehmen die Ausgabe einer Smarty-Variable und modifizieren sie. Sie werden folgendermaßen aufgerufen: <code>{$variable|modifier[:arg:...]}</code>';
$lang['postfilter'] = 'Postfilter werden von Smarty automatisch nach der Kompilierung jeder Vorlage aufgerufen. Ein manueller Aufruf ist nicht möglich.';
$lang['prefilter'] = 'Vorfilter werden von Smarty automatisch vor der Kompilierung jeder Vorlage aufgerufen. Ein manueller Aufruf ist nicht möglich.';
$lang['tag_about'] = 'Zeigt den Entwicklungsverlauf und die Autoreninformationen für dieses Plugin an, sofern verfügbar';
$lang['tag_adminplugin'] = 'Gibt an, dass das Tag nur im Administrationsbereich verfügbar ist und normalerweise in Modulvorlagen verwendet wird.';
$lang['tag_cachable'] = 'Zeigt an, ob die Ausgabe des Plugins zwischengespeichert werden kann (wenn Smarty-Caching aktiviert ist). Admin-Plugins und Modifikatoren können nicht zwischengespeichert werden.';
$lang['tag_help'] = 'Hilfe für dieses Tag anzeigen (sofern verfügbar)';
$lang['tag_name'] = 'Dies ist der Name für das Tag';
$lang['tag_type'] = 'Tag-Typ (Funktion, Modifikator bzw. Pre- oder Post-Filter';
$lang['title_admin'] = 'Diese Erweiterung ist nur im CMSMS-Administrationsbereich verfügbar.';
$lang['title_notadmin'] = 'Diese Erweiterung ist im Administrationsbereich und auf der öffentlichen Website verwendbar.';
$lang['title_cachable'] = 'Diese Erweiterung kann zwischengespeichert werden';
$lang['title_notcachable'] = 'Diese Erweiterung kann nicht zwischengespeichert werden';
$lang['viewabout'] = 'Vorgeschichte und Autoreninformation für dieses Modul anzeigen';
$lang['viewhelp'] = 'Modulhilfe anzeigen';
?>