<?php
$lang['help_function_page_selector'] = '<h3>Hva gjør denne?</h3>
<p>Denne admin-pluginen gir en kontroll for å tillate valg av innholdsside eller annet element. Dette er egnet for å la en administrator være i stand til å velge en side som vil bli lagret.</p>
<h3>Bruk:</h3>
<pre><code>{page_selector name=dfltpage value=$currentpage}</code></pre>
<h3>Hvilke parametere tar det?</h3>
<ul>
  <li>name - <em>(string)</em> - Navnet på inntastingsfeltet.</p>
  <li>value - <em>(int)</em> - IDen til den valgte siden.</p>
  <li>allowcurrent - <em>(bool)</em> - Hvorvidt det valgte elementet skal velges på nytt eller ikke. Standardverdien er falsk.</li>
  <li>allow_all - <em>(bool)</em> - Hvorvidt tillatelse av inaktive innholdselementer, eller innholdselementer som ikke har brukbare lenker, skal velges. Standardverdien er falsk</li>
  <li>for_child - <em>(bool)</em> - Viser at vi velger en forelder side for et nytt innholdselement. Standardverdien er falsk.</p>
  </li>
</ul>';
$lang['help_function_cms_html_options'] = '<h3>Hva gjør dette?</h3>
<p>Dette er en kraftig plugin for å gjengi alternativer for utvalgte elementer til html <option> og <optgroup> tagger. Hvert alternativ kan ha underordnede elementer, sin egen tittelkode og sin egen klasseattributt.</p>
<h3>Bruk:</h3>
<pre><code>{cms_html_options options=$options [selected=value]}</code></pre>
<h3>Hvilke parametere krever det?</h3>
<ul>
   <li>alternativer - <em>(matrise)</em> - En rekke alternativdefinisjoner.</li>
   <li>valgt - <em>(streng)</em> - Verdien som skal velges automatisk i rullegardinmenyen. må tilsvare verdien av ett av alternativene.</li>
</ul>
<h4>Alternativer</h4>
<p>Hvert alternativ er en assosiativ matrise med to eller flere av følgende medlemmer:</p>
<ul>
   <li>etikett - <em>(<strong>obligatorisk</strong> streng)</em> En etikett for alternativet (dette er det som presenteres for brukeren)</li>
   <li>verdi - <em>(<strong>obligatorisk</strong> blandet)</em> Enten en strengverdi for alternativet, eller en rekke alternativdefinisjoner.
     <p>Hvis verdien av en alternativdefinisjon i seg selv er en rekke alternativer, vil etiketten bli gjengitt som en optgruppe med barn.</p>
   </li>
   <li>tittel - <em>(streng)</em> Et tittelattributt for alternativet.</li>
   <li>klasse - <em>(streng)</em> Et klassenavn for alternativet.</li>
</ul>

<h3>Eksempel:</h3>
<pre><code>
{$opts[]=[\'label\'=>\'Fugl\',\'value\'=>\'b\',\'title\'=>\'Jeg har en kjæledyrfugl\']}
{$opts[]=[\'label\'=>\'Fisk\',\'value\'=>\'f\']}
{$sub[]=[\'label\'=>\'Small Dog\',\'value\'=>\'sd\']}
{$sub[]=[\'label\'=>\'Medium Dog\',\'value\'=>\'md\']}
{$sub[]=[\'label\'=>\'Stor hund\',\'value\'=>\'ld\']}
{$opts[]=[\'label\'=>\'Hund\',\'value\'=>$sub]}
{$opts[]=[\'label\'=>\'Katt\',\'value\'=>\'c\',\'class\'=>\'katt\']}
<select name="pet">
   {cms_html_options options=$opts selected=\'md\'}
</select></code></pre>';
$lang['help_modifier_cms_date_format'] = '<h3>Hva gjør dette?</h3>
<p>Denne modifikatoren brukes til å formatere datoer i et passende format. Den bruker standard strftime parametere. Hvis ingen formatstreng er spesifisert, vil systemet bruke datoformatstrengen brukerpreferanse (for påloggede brukere) eller systemets datoformatpreferanse.</p>
<p>Denne modifikatoren er i stand til å forstå datoer i mange formater. dvs.: dato- og klokkeslettstrenger som sendes ut fra databasen eller heltalls tidsstempler generert av time()-funksjonen.</p>
<h3>Bruk:</h3>
<pre><code>{$some_date_var|cms_date_format[:<format string>]}</code></pre>
<h3>Eksempel:</h3>
<pre><code>{\'2012-03-24 22:44:22\'|cms_date_format}</code></pre>';
$lang['help_modifier_cms_escape'] = '<h3>Hva gjør dette?</h3>
<p>Denne modifikatoren brukes til å unnslippe strengen på en av mange måter. Dette kan brukes til å konvertere strengen til flere forskjellige visningsformater, eller for å gjøre brukerangitte data med spesialtegn som kan vises på en standard nettside.</p>
<h3>Bruk:</h3>
<pre><code>{$some_var_with_text|cms_escape[:<escape type>|[<character set>]]}</code></pre>
<h4>Gyldige escape-typer:</h4>
<ul>
<li>html <em>(standard)</em> - bruk htmlspesielle tegn.</li>
<li>htmlalle – bruk htmlentities.</li>
<li>url – rå url koder for alle enheter.</li>
<li>urlpathinfo – Ligner på url-escape-typen, men koder også /.</li>
<li>sitater – unnslipp uunngåede enkeltsitater.</li>
<li>hex – Escape hvert tegn til heks.</li>
<li>heksentitet - Hex-kode hvert tegn.</li>
<li>anstendighet – Desimalkode hvert tegn.</li>
<li>javascript - Escape-sitater, omvendte skråstreker, nye linjer osv.</li>
<li>e-post – Kod inn en e-postadresse til noe som er trygt å vise.</li>
<li>nonstd – Escape ikke-standardtegn, for eksempel dokumentanførselstegn.</li>
</ul>
<h4>Tegnsett::</h4>
<p>Hvis tegnsettet ikke er spesifisert, antas utf-8. Tegnsettet gjelder kun for "html" og "htmlalle" rømningstyper.</p>';
$lang['help_modifier_relative_time'] = '<h3>Hva gjør dette?</h3>
   <p>Denne modifikatoren konverterer et heltalls tidsstempel eller klokkeslett/dato-streng til en menneskelig lesbar tidsperiode fra eller til nå. dvs.: "for tre timer siden."</p>
<h3>Hvilke parametere krever det?</h3>
  <p>Denne modifikatoren godtar ingen valgfrie parametere.</p>
<h3>Eksempel:</h3>
   <code><pre>{$some_timestamp|relative_time}</code></pre>';
$lang['help_modifier_summarize'] = '<h3>Hva gjør dette?</h3>
<p>Denne modifikatoren brukes til å avkorte en lang tekstsekvens til et begrenset antall "ord".</p>
<h3>Bruk:</h3>
<pre><code>{$some_var_with_long_text|summarize:<number>}</code></pre>
<h3>Eksempel:</h3>
<p>Følgende eksempel vil fjerne alle html-tagger fra innholdet og avkorte det etter 50 ord.</p>
<pre><code>{content|strip_tags|summarize:50}</code></pre>';
$lang['help_function_admin_icon'] = '<h3>Hva gjør dette?</h3>
<p>Dette er en plugin kun på adminsiden for å tillate moduler å enkelt vise ikoner fra gjeldende admin-tema. Disse ikonene er nyttige i koblingsbygging eller for å vise statusinformasjon.</p>
<h3>Hvilke parametere krever det?</h3>
<ul>
   <li>ikon - <strong>(obligatorisk)</strong> - Filnavnet til ikonet. dvs. run.gif</li>
   <li>høyde - <em>(valgfritt)</em> - Høyden (i piksler) på ikonet.</li>
   <li>bredde - <em>(valgfritt)</em> - Bredden (i piksler) på ikonet.</li>
   <li>alt - <em>(valgfritt)</em> - Valgfri tekst for img-taggen hvis det angitte filnavnet ikke er tilgjengelig.</li>
   <li>rel - <em>(valgfritt)</em> - Et valgfritt rel-attributt for img-taggen.</li>
   <li>klasse – <em>(valgfritt)</em> – Et valgfritt klasseattributt for img-taggen.</li>
   <li>id - <em>(valgfritt)</em> - Et valgfritt id-attributt for img-taggen.</li>
   <li>tittel - <em>(valgfritt)</em> - Et valgfritt tittelattributt for img-taggen.</li>
   <li>tilgangsnøkkel - <em>(valgfritt)</em> - Et valgfritt tilgangsnøkkeltegn for img-taggen.</li>
   <li>tilordne - <em>(valgfritt)</em> - Tilordne tag-utdata til den navngitte smarty-variabelen.</li>
</ul>
<h3>Eksempel:</h3>
<pre><code>{admin_icon icon=\'edit.gif\' class=\'editicon\'}</code></pre>';
$lang['help_function_cms_action_url'] = '<h3>Hva gjør dette?</h3>
<p>Dette er en smart plugin som er nyttig for å generere en URL til en modulhandling. Denne plugin-en er nyttig for modulutviklere som genererer lenker (enten for Ajax eller eller i admin-grensesnittet) for å utføre annen funksjonalitet eller vise forskjellige data.</p>
<h3>Hvilke parametere krever det?</h3>
<ul>
   <li>modul - <em>(valgfritt)</em> - Modulnavnet det skal genereres en URL for. Denne parameteren er ikke nødvendig hvis du genererer en URL fra en modulhandling til en handling innenfor samme modul.</li>
   <li>handling – <strong>(obligatorisk)</strong> – Handlingsnavnet det skal genereres en nettadresse til.</li>
   <li>returnid - <em>(valgfritt)</em> - Heltallsside-ID for å vise resultatene av handlingen i. Denne parameteren er ikke nødvendig hvis handlingen skal vises på gjeldende side, eller hvis URL-en er til en administratorhandling fra en administratorhandling.</li>
   <li>midt - <em>(valgfritt)</em> - Modulens handlings-ID. Dette er standard til "m1_" for administratorhandlinger, og "cntnt01" for frontend-handlinger.</li>
   <li>forjs - <em>(valgfritt)</em> - Et valgfritt heltall som indikerer at den genererte nettadressen skal være egnet for bruk i JavaScript.</li>
   <li>tilordne - <em>(valgfritt)</em> - Tilordne utdata-URLen til den navngitte smarty-variabelen.</li>
</ul>
<p><strong>Merk:</strong> Eventuelle andre parametere som ikke aksepteres av denne plugin-modulen, sendes automatisk til den kalte modulhandlingen på den genererte nettadressen.</p>
<h3>Eksempel:</h3>';
$lang['help_function_cms_admin_user'] = '<h3>Hva gjør dette?</h3>
<p>Dette admin-pluginet gir ut informasjon om den angitte admin-bruker-IDen.</p>
<h3>Hvilke parametere krever det?</h3>
<ul>
   <li>uid - <strong>obligatorisk</strong> - En heltalls bruker-ID som representerer en gyldig adminkonto.</li>
   <li>modus - <em>(valgfritt)</em> - Driftsmodusen. Mulige verdier er:
     <ul>
       <li>brukernavn <strong>standard</strong> – skriv ut brukernavnet for den angitte uid-en.</li>
       <li>e-post - skriv ut e-postadressen for den angitte uid.</li>
       <li>fornavn – skriv ut fornavnet for den angitte uid.</li>
       <li>etternavn - skriv ut etternavnet for den angitte uid.</li>
       <li>fullt navn – skriv ut det fulle navnet for den angitte uid.</li>
     </ul>
   </li>
   <li>tilordne - <em>(valgfritt)</em> - Tilordne utdata til den navngitte smarty-variabelen.</li>
</ul>
<h3>Eksempel:</h3>
<pre><code>{cms_admin_user uid=1 mode=email}</code></pre>';
$lang['help_function_cms_get_language'] = '<h3>Hva gjør dette?</h3>
<p>Denne plugin-modulen returnerer gjeldende CMSMS-språknavn. Språket brukes til oversettelsesstrenger og datoformatering.</p>
<h3>Hvilke parametere krever det?</h3>
<ul>
<li><em>(valgfritt)tilordne</em> – Tilordne utdataene fra plugin-en til den navngitte smarty-variabelen.</li>
</ul>';
$lang['help_function_cms_help'] = '<h3>Hva gjør dette?</h3>
<p>Dette er kun en admin-plugin som skal brukes til å generere en lenke som når den klikkes vil generere popup-hjelp for et bestemt element.</p>
<p>Dette pluginet brukes vanligvis fra moduladministratormaler for å vise sluttbrukerhjelp i et popup-vindu for et inndatafelt, kolonne eller annen viktig informasjon.</p>
<h3>Hvilke parametere krever det?</h3>
<ul>
<li>nøkkel - <strong>(påkrevd streng)</strong> - Den andre delen i en unik nøkkel for å identifisere hjelpestrengen som skal vises. Dette er vanligvis nøkkelen fra den riktige realms lang-filen.</li>
<li>realm - <em>(valgfri streng)</em> - Den første delen i en unik nøkkel for å identifisere hjelpestrengen. Hvis denne parameteren ikke er spesifisert, og denne plugin kalles fra en modulhandling, brukes det gjeldende modulnavnet. Hvis du ikke finner noe modulnavn, kan "hjelp" brukes som lang-riket.</li>
<li>tittel - <em>(valgfri streng)</em> - Hjelpebokstittel</li>
<li>tilordne - <em>(valgfri streng)</em> - Tilordne utdata til den navngitte smarty-variabelen.</li>
</ul>
<h3>Eksempel:</h3>
<pre><code>{cms_help key2=\'help_field_username\' title=$foo}</code></pre>';
$lang['help_function_cms_init_editor'] = '<h3>Hva gjør dette?</h3>
   <p>Denne plugin-modulen brukes til å initialisere den valgte WYSIWYG-editoren for visning når WYSIWYG-funksjonalitet er nødvendig for innsending av frontend-data. Denne modulen vil finne den valgte grensesnittet WYSIWYG <em>(se globale innstillinger).</em>, avgjør om det har blitt forespurt, og generer i så fall riktig html-kode <em>(vanligvis JavaScript-lenker)</em> så at WYSIWYG vil initialiseres riktig når siden er lastet. Hvis ingen WYSIWYG-redigerere har blitt bedt om for frontend-forespørselen, vil denne plugin ikke produsere noe utdata.</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Det første du må gjøre er å velge frontend WYSIWYG-editoren som skal brukes på den globale innstillingssiden til administrasjonskonsollen. Neste Hvis du bruker frontend WYSIWYG-redigeringsprogrammer på flere sider, kan det være best å plassere {cms_init_editor}-pluginen direkte i sidemalen. Hvis du bare krever at WYSIWYG-editoren skal være aktivert på et begrenset antall sider, kan du bare plassere den i "Sidespesifikke metadata" felt på hver side.</p>
<h3>Hvilke parametere krever det?</h3>
<ul>
<li><em>(valgfritt)tilordne</em> – Tilordne utdataene fra plugin-en til den navngitte smarty-variabelen.</li>
</ul>';
$lang['help_function_cms_lang_info'] = '<h3>Hva gjør dette?</h3>
<p>Denne plugin-modulen returnerer et objekt som inneholder informasjonen som CMSMS har om det valgte språket. Dette kan inkludere lokale informasjon, kodinger, språkaliaser osv.</p>
<h3>Hvilke parametere krever det?</h3>
<ul>
<li><em>(valgfritt)lang</em> – Språket det skal returneres informasjon for. Hvis lang-parameteren ikke er spesifisert, brukes informasjonen for gjeldende CMSMS-språk.</li>
<li><em>(valgfritt)tilordne</em> – Tilordne utdataene fra plugin-en til den navngitte smarty-variabelen.</li>
</ul>
<h3>Eksempel:</h3>
<pre>{cms_lang_info assign=\'nls\'}{$nls->locale()}</pre>
<h3>Se også:</h3>
<p>CmsNls-klassedokumentasjonen.</p>';
$lang['help_function_cms_pageoptions'] = '<h3>Hva gjør dette?</h3>
  <p>Dette er en enkel plugin for å generere en sekvens med <option> koder for en rullegardinliste som representerer sidetall i en paginering.</p>
  <p>Gitt antall sider og gjeldende side vil denne plugin-en generere en liste over sidetall som tillater rask navigering til et undersett av sidene.</p>
<h3>Hvilke parametere krever det?</h3>
   <ul>
     <li>antallsider – <strong>nødvendig heltall</strong> – Totalt antall tilgjengelige sider som skal vises.</li>
     <li>curpage - <strong>påkrevd heltall</strong> - Det gjeldende sidetallet (må være større enn 0 og mindre enn eller lik "antall"</li>
     <li>surround - <em>(valgfritt heltall)</em> - Antall elementer som den gjeldende siden skal omgis av. Standardverdien for denne parameteren er 3.</li>
     <li>bare - <em>(valgfritt boolesk)</em> - Ikke skriv ut <option> tagger, gir i stedet bare en enkel matrise som er egnet for videre manipulering i smarty.</li>
   </ul>
<h3>Eksempel:</h3>
<pre><code><select name="{$actionid}pagenum">{cms_pageoptions numpages=50 curpage=14}</select></code></pre>';
$lang['help_function_share_data'] = '<h3>Hva gjør dette?</h3>
<p>Dette pluginet brukes til å kopiere én eller flere aktive smarty-variabler til det overordnede eller globale omfanget.</p>
<h3>Hvilke parametere krever det?</h3>
<ul>
<li>omfang – <strong>valgfri streng</strong> – Målomfanget som variabler skal kopieres til. Mulige verdier er "overordnet" <em>(standard)</em> eller "global" for å kopiere dataene til det globale smarty-objektet for senere bruk på hele siden.</li>
<li>vars - <strong>påkrevd blandet</strong> - enten en rekke strengvariabelnavn, eller en kommadelt liste over strengvariabelnavn.</li>
</ul>
<h3>Eksempel:</h3>
<pre><code>{share_data scope=global data=\'title,canonical\'}</code></pre>
<h3>Merk:</h3>
<p>Dette programtillegget godtar ikke array-aksessors eller objektmedlemmer som variabelnavn. dvs.: <code>]$foo[1]</code> eller <code>{$foo->bar}</code> vil ikke fungere.</p>';
$lang['help_function_cms_yesno'] = '<h3>Hva gjør dette?</h3>
<p>Dette er en enkel plugin som brukes i skjemagenerering for å lage et sett med alternativer for en <select> som representerer et ja/nei-valg.</p>
<p>Dette programtillegget vil generere oversatte ja/nei-alternativer, med riktig valgt verdi.</p>
<h3>Hvilke parametere krever det?</h3>
<ul>
   <li>valgt - <em>(valgfritt heltall)</em> - enten 0 <em>(nei)</em> eller 1 <em>(ja)</em></li>
   <li>tilordne - <em>(valgfri streng)</em> - Tilordne utdata til den navngitte smarty-variabelen.</li>
</ul>
<h3>Eksempel:</h3>
<pre><code><select name="{$actionid}opt">{cms_yesno selected=$opt}</select></code></pre>';
$lang['help_function_module_available'] = '<h3>Hva gjør dette?</h3>
<p>En plugin for å teste om en gitt modul (etter navn) er installert og tilgjengelig for bruk.</p>
<h3>Hvilke parametere krever det?</h3>
<ul>
<li><strong>(påkrevd)modul</strong> - (streng) Navnet på modulen.</li>
<li><em>(valgfritt)tilordne</em> – Tilordne utdataene fra plugin-en til den navngitte smarty-variabelen.</li>
</ul>
<h3>Eksempel:</h3>
{module_available module=\'News\' assign=\'havenews\'}{if $havenews}{cms_module module=News}{/if}
<h3>Merk:</h3>
<p>Du kan ikke bruke kortformen til modulkallet, dvs.: <em>{Nyheter}</em> i denne typen uttrykk.</p>';
$lang['help_function_cms_set_language'] = '<h3>Hva gjør dette?</h3>
<p>Denne plugin-en prøver å sette gjeldende språk for bruk av oversettelsesstrenger og datoformatering til ønsket språk. Språket som er spesifisert må være kjent for CMSMS (nls-filen må eksistere). Når denne funksjonen kalles, (og med mindre den er overstyrt i config.php) vil det bli gjort et forsøk på å sette lokaliteten til den lokale som er knyttet til språket. Språket må være installert på serveren.</p>
<h3>Hvilke parametere krever det?</h3>
<ul>
<li><strong>(påkrevd)lang</strong> – ønsket språk. Språket må være kjent for CMSMS-installasjonen (nls-filen må eksistere).</li>
</ul>';
$lang['help_function_browser_lang'] = '<h3>Hva gjør dette?</h3>
   <p>Dette pluginet oppdager og sender ut språket som brukerens nettleser godtar, og kryssreferanser det med en liste over tillatte språk for å bestemme en språkverdi for økten.</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Sett inn taggen tidlig i sidemalen din <em>(den kan gå over <head>-delen hvis du vil)</em> og oppgi navnet på standardspråket og de aksepterte språkene (bare to navn på tegnspråk godtas), og gjør deretter noe med resultatet. dvs.:</p>
<pre><code>{browser_lang accepted="de,fr,en,es" default=no assign=tmp}{session_put var=lang val=$tmp}</code></pre>
<p><em>({session_put} er en plugin levert av CGSimpleSmarty-modulen)</em></p>
<h3>Hvilke parametere krever det?</h3>
<ul>
<li><strong>godkjent <em>(obligatorisk)</em></strong><br/> – En kommadelt liste over to tegnspråknavn som godtas.</li>
<li>standard<br/>- <em>(valgfritt)</em> Et standardspråk som skal skrives ut hvis ikke noe akseptert språk ble støttet av nettleseren. no brukes hvis ingen annen verdi er spesifisert.</li>
<li>tilordne<br/>- <em>(valgfritt)</em> Navnet på smarty-variabelen som resultatene skal tilordnes. Hvis ikke spesifisert, returneres resultatene av denne funksjonen.</li>
</ul>';
$lang['help_function_content_module'] = '<h3>Hva gjør dette?</h3>
<p>Denne innholdsblokktypen tillater grensesnitt med forskjellige moduler for å lage forskjellige innholdsblokktyper.</p>
<p>Noen moduler kan definere innholdsblokktyper for bruk i modulmaler. dvs.: FrontEndUsers-modulen kan definere en gruppelisteinnholdsblokktype. Den vil deretter indikere hvordan du kan bruke content_module-taggen til å bruke den blokktypen i malene dine.</p>
<p><strong>Merk:</strong> Denne blokktypen må kun brukes med kompatible moduler. Du bør ikke bruke dette på noen måte bortsett fra som veiledet av tilleggsmoduler.</p>
<p>Denne taggen godtar noen få parametere, og sender alle andre parametere til modulen for behandling.</p>
<p>Parametere:
  <ul>
  <li><strong>(påkrevd)</strong>modul – Navnet på modulen som skal gi denne innholdsblokken. Denne modulen må være installert og tilgjengelig</li>
  <li><strong>(obligatorisk)</strong>blokk – navnet på innholdsblokken.</li>
  <li><em>(valgfritt)</em>etikett – En etikett for innholdsblokken for bruk ved redigering av siden.</li>
  <li><em>(valgfritt)</em> påkrevd – Gjør det mulig å spesifisere at innholdsblokken må inneholde noe tekst.</em></li>
  <li><em>(valgfritt)</em>-fanen – den ønskede fanen for å vise dette feltet i redigeringsskjemaet.</li>
  <li><em>(valgfritt)</em> prioritet (heltall) – Gjør det mulig å spesifisere en heltallsprioritet for blokken i fanen.</li>
  <li><em>(valgfritt)</em> tilordne (streng) – tilordne resultatene til en smarty-variabel med det navnet.</li>
  </ul>
</p>';
$lang['help_function_cms_stylesheet'] = '<h3>Hva gjør dette?</h3>
   <p>En erstatning for {stylesheet}-taggen, gir denne taggen bufring av css-filer ved å generere statiske filer i tmp/cache-katalogen, og smart behandling av de individuelle stilarkene.</p>
   <p>Dette programtillegget henter stilarkinformasjon fra systemet. Som standard henter den alle stilarkene som er knyttet til den gjeldende malen i den rekkefølgen som er spesifisert av designeren, og kombinerer dem til en enkelt stilarktag.</p>
   <p>Genererte stilark er unikt navngitt i henhold til siste endringsdato i databasen, og genereres bare hvis et stilark er endret.</p>
   <p>Denne taggen er erstatningen for {stylesheet}-taggen.</p>
   <h3>Hvordan bruker jeg det?</h3>
   <p>Bare sett inn taggen i malen/sidens hodeseksjon som: <code>{cms_stylesheet}</code></p>
   <h3>Hvilke parametere krever det?</h3>
   <ul>
   <li><em>(valgfritt)</em> navn – i stedet for å få alle stilark for den gitte siden, vil den bare få ett spesifikt navngitt, enten det er knyttet til gjeldende mal eller ikke.</li>
   <li><em>(valgfritt)</em> nocombine - (boolesk, standard false) Hvis aktivert, og det er flere stilark knyttet til malen, vil stilarkene bli sendt ut som separate tagger i stedet for kombinert til en enkelt kode. </li>
   <li><em>(valgfritt)</em> nolinks - (boolesk, standard false) Hvis aktivert, vil stilarkene sendes ut som en URL uten <link> tag.</li>
   <li><em>(valgfritt)</em> https - (boolsk, standard false) indikerer om ssl_url-konfigurasjonsoppføringen skal brukes til å prefikse stilarknettadresser. Hvis det ikke er spesifisert, vil systemet forsøke å finne riktig rot-url basert på det sikre flagget til siden som vises.</li>
   <li><em>(valgfritt)</em> designid - Hvis designid er definert, vil dette returnere stilark knyttet til det designet i stedet for det gjeldende.</li>
   <li><em>(valgfritt)</em> media - <strong>[avviklet]</strong> - Når den brukes sammen med navneparameteren vil denne parameteren tillate deg å overstyre medietypen for det stilarket. Når den brukes sammen med templateid-parameteren, vil medieparameteren bare skrive ut stilark-tagger for de stilarkene som er merket som kompatible med den angitte medietypen.</li>
   </ul>
   <h3>Smart behandling</h3>
   <p>Ved generering av css-filer sender dette systemet stilarkene hentet fra databasen gjennom smarty. Smarty-avgrensningene er endret fra CMSMS-standarden { og } til henholdsvis [[ og ]] for å lette overgangen i stilark. Dette gjør det mulig å lage smarte variabler, dvs.: [[assign var=\'red\' value=\'#900\']] øverst på stilarket, og deretter bruke disse variablene senere i stilarket, dvs.:</p>
<pre>
<kode>
h3 .error { farge: [[$rød]]; }<br/>
</code>
</pre>
<p>Fordi de bufrede filene genereres i tmp/cache-katalogen til CMSMS-installasjonen, er ikke den relative arbeidskatalogen for CSS roten til nettstedet. Derfor bør alle bilder eller andre tagger som krever en url bruke [[root_url]]-taggen for å tvinge den til å være en absolutt url. dvs.:</p>
<pre>
<kode>
h3 .error { background: url([[root_url]]/uploads/images/error_background.gif); }<br/>
</code>
</pre>
<p><strong>Merk:</strong> På grunn av bufringsnaturen til plugin-modulen, bør smarty-variabler plasseres øverst på HVERT stilark som er knyttet til en mal.</p>';
$lang['help_function_page_attr'] = '<h3>Hva gjør dette?</h3>
<p>Denne taggen kan brukes til å returnere verdien av attributtene til en bestemt side.</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Sett inn taggen i malen som: <code>{page_attr key="extra1"}</code>.</p>
<h3>Hvilke parametere krever det?</h3>
<ul>
   <li><em>(valgfritt)</em> side (int|streng) – En valgfri side-ID eller alias for å hente innholdet fra. Hvis det ikke er spesifisert, antas gjeldende side.</li>
   <li><strong>nøkkel [påkrevd]</strong> Nøkkelen som skal returneres attributtet til.
     <p>Nøkkelen kan enten være et blokknavn eller fra et sett med standardegenskaper knyttet til en innholdsside. Noen av de aksepterte standardegenskapene er:</p>
     <ul>
       <li>_dflt_ - (streng) Verdien for standardinnholdsblokken (et alias for content_en).</li>
       <li>tittel</li>
       <li>beskrivelse</li>
       <li>alias - (streng) Det unike sidealiaset.</li>
       <li>id - (int) Den unike side-ID.</li>
       <li>created_date - (strengdato) Dato for opprettelsen av innholdsobjektet.</li>
       <li>modifisert_dato - (strengdato) Dato for siste endring av innholdsobjektet.</li>
       <li>last_modified_by - (int) UID for brukeren som sist endret siden.</li>
       <li>eier - (int) UID for sideeieren.</li>
       <li>bilde - (streng) Banen til bildet knyttet til innholdssiden.</li>
       <li>miniatyrbilde - (streng) Banen til miniatyrbildet knyttet til innholdssiden.</li>
       <li>extra1 - (streng) Verdien av extra1-attributtet.</li>
       <li>extra2 - (streng) Verdien til extra2-attributtet.</li>
       <li>extra3 - (streng) Verdien til extra3-attributtet.</li>
       <li>pageattr - (streng) Verdien til det sidespesifikke smarty-dataattributtet./li>
     </ul>
     <p><strong>Merk:</strong> Listen ovenfor er ikke inkluderende. Du kan også hente det uparsede innholdet til ytterligere innholdsblokker eller egenskaper lagt til av tredjepartsmoduler. Utgangen er alltid en streng</p>
   </li>
   <li><em>(valgfritt)</em> inaktiv (boolsk) – tillater lesing av sideattributter fra inaktive sider.</li>
   <li><em>(valgfritt)</em> tilordne (streng) – tilordne resultatene til en smarty-variabel med det navnet.</li>
</ul>
<h3>Returnerer:</h3>
<p><strong>streng</strong> – Den faktiske verdien av innholdsblokken fra databasen for den angitte blokken og siden.</p>
<p><strong>Merk:</strong> – Utdataene fra denne plugin-en sendes ikke gjennom smarty eller renses for visning. Hvis du viser dataene, må du konvertere strengdata til enheter, og/eller sende dem gjennom smarty.</p>';
$lang['help_function_page_image'] = '<h3>Hva gjør dette?</h3>
<p>Denne taggen kan brukes til å returnere verdien til bildet eller miniatyrbildefeltene på en bestemt side.</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Sett inn taggen i malen som: <code>{page_image}</code>.</p>
<h3>Hvilke parametere krever det?</h3>
<ul>
   <li><em>(valgfritt)</em> thumbnail (bool) – Vis eventuelt verdien til thumbnail-egenskapen i stedet for image-egenskapen.</li>
   <li><em>(valgfritt)</em> full (bool) – Du kan eventuelt skrive ut hele nettadressen til bildet i forhold til banen for bildeopplasting.</li>
    <li><em>(valgfritt)</em>-tag (bool) – Skriv eventuelt ut en fullstendig bilde-tag, hvis egenskapsverdien ikke er tom. Hvis tag-argumentet er aktivert, er full underforstått.</li>
   <li><em>(valgfritt)</em> tilordne (streng) – tilordne resultatene til en smarty-variabel med det navnet.</li>
</ul>
<h3>Mer...</h3>
<p>Hvis tag-argumentet er aktivert, og egenskapsverdien ikke er tom, vil dette utløse en full HTML-img-tag. Eventuelle argumenter til plugin-en som ikke er oppført ovenfor, vil automatisk bli inkludert i den resulterende img-taggen. dvs.: <code>{page_image tag=true class="pageimage" id="someid" title="testing"}</code>.</p>
<p>Hvis programtillegget sender ut en full img-tag, og alt-argumentet ikke er oppgitt, vil verdien til egenskapen bli brukt for alt-attributtet til img-taggen.</p>';
$lang['help_function_dump'] = '<h3>Hva gjør dette?</h3>
   <p>Denne taggen kan brukes til å dumpe innholdet i enhver smarty-variabel i et mer lesbart format. Dette er nyttig for feilsøking og redigering av maler for å vite formatet og datatypene som er tilgjengelige.</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Sett inn taggen i malen som <code>{dump item=\'the_smarty_variable_to_dump\'}</code>.</p>
<h3>Hvilke parametere krever det?</h3>
<ul>
<li><strong>item (obligatorisk)</strong> – Smarty-variabelen å dumpe innholdet i.</li>
<li>maxlevel – Maksimalt antall nivåer som skal gjentas (gjelder bare hvis recurse også er oppgitt. Standardverdien for denne parameteren er 3</li>
<li>nomethods - Hopp over utdata fra metoder fra objekter.</li>
<li>novars – Hopp over utdata fra objektmedlemmer.</li>
<li>recurse - Gjenta et maksimalt antall nivåer gjennom objektene som gir detaljerte utdata for hvert element til maksimalt antall nivåer er nådd.</li>
<li><em>(valgfritt)</em> tilordne (streng) – tilordne resultatene til en smarty-variabel med det navnet.</li>
</ul>';
$lang['help_function_content_image'] = '<h3>Hva gjør dette?</h3>
<p>Denne plugin-modulen lar maldesignere be brukere om å velge en bildefil når de redigerer innholdet på en side. Den oppfører seg på samme måte som innholdsplugin, for ytterligere innholdsblokker.</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Bare sett inn taggen i sidemalen som: <code>{content_image block=\'image1\'}</code>.</p>
<h3>Hvilke parametere krever det?</h3>
<ul>
   <li><strong>(obligatorisk)</strong> blokk (streng) – Navnet på denne ekstra innholdsblokken.
     <p>Eksempel:</p>
     <pre>{content_image block=\'image1\'}</pre><br/>
   </li>
   <li><em>(valgfritt)</em> etikett (sring) – En etikett eller melding for denne innholdsblokken på siden for redigering av innhold. Hvis det ikke er spesifisert, vil blokknavnet bli brukt.</li>
   <li><em>(valgfritt)</em> dir (streng) – Navnet på en katalog (i forhold til opplastingskatalogen, som det skal velges bildefiler fra. Hvis ikke angitt, vil preferansen fra siden med globale innstillinger være brukt. Hvis denne preferansen er tom, vil opplastingskatalogen bli brukt.
   <p>Eksempel: bruk bilder fra katalogen for opplastinger/bilder.</p>
   <pre><code>{content_image block=\'image1\' dir=\'images\'}</code></pre><br/>
   </li>
   <li><em>(valgfritt)</em> standard (streng) – Brukes til å angi et standardbilde som brukes når ingen bilder er valgt.</li>
   <li><em>(valgfritt)</em> urlonly (bool) – skriv ut bare url til bildet, ignorer alle parametere som id, navn, bredde, høyde osv.</li>
   <li><em>(valgfritt)</em> fane (streng) Den ønskede fanen å vise dette feltet på i redigeringsskjemaet.</li>
   <li><em>(valgfritt)</em> ekskluder (streng) – Spesifiser et prefiks for filer som skal ekskluderes. dvs.: thumb_ </li>
   <li><em>(valgfritt)</em> sortering (bool) - sorter alternativene. Standard er å ikke sortere.</li>
   <li><em>(valgfritt)</em> prioritet (heltall) – Gjør det mulig å spesifisere en heltallsprioritet for blokken i fanen.</li>
   <li><em>(valgfritt)</em> tilordne (streng) – tilordne resultatene til en smarty-variabel med det navnet.</li>
</ul>
<h3>Mer...</h3>
<p><strong>Merk:</strong> Fra og med versjon 2.2, hvis denne innholdsblokken ikke inneholder noen verdi, genereres ingen utdata.</p>
                                                             <p>I tillegg til argumentene som er oppført ovenfor, vil denne plugin godta et hvilket som helst antall tilleggsargumenter og videresende dem direkte til den genererte img-taggen hvis noen. dvs.: <code>{content_image block=\'img1\' id="id_img1" class="page-image" title=\'an image block\' data-foo=bar}</code>';
$lang['help_function_process_pagedata'] = '<h3>Hva gjør dette?</h3>
<p>Dette programtillegget vil behandle dataene i "sidedataene" blokk med innholdssider gjennom smarty. Den lar deg spesifisere sidespesifikke data til smarty uten å endre malen for hver side.</p>
<h3>Hvordan bruker jeg det?</h3>
<ol>
   <li>Sett inn smarty assign-variabler og annen smarty-logikk i sidedatafeltet på noen av innholdssidene dine.</li>
   <li>Sett inn <code>{process_pagedata}</code>-taggen helt øverst på sidemalen.</li>
</ol>
<br/>
<h3>Hvilke parametere krever det?</h3>
<p><em>(valgfritt)</em> tilordne (streng) – tilordne resultatene til en smart variabel med det navnet.</p>';
$lang['help_function_current_date'] = '<h3 style="color: red;">Utviklet</h3>
<p>bruk <code>{$smarty.now|cms_date_format}</code></p>
<h3>Hva gjør dette?</h3>
<p>Skriver ut gjeldende dato og klokkeslett. Hvis det ikke er oppgitt noe format, vil det som standard ha et format som ligner på "01. januar 2004".</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Bare sett inn taggen i malen/siden din som: <code>{current_date format="%A %d-%b-%y %T %Z"}</code></p>
<h3>Hvilke parametere krever det?</h3>
<ul>
<li><em>(valgfritt)</em>format - Dato-/klokkeslettformat ved hjelp av parametere fra phps strftime-funksjon. Se <a href="http://php.net/strftime" target="_blank">her</a> for en parameterliste og informasjon.</li>
<li><em>(valgfritt)</em>ucword – Hvis sant returnerer det første tegnet i hvert ord med stor bokstav.</li>
<li><em>(valgfritt)</em> <tt>tilordne</tt> – Tilordne resultatene til den navngitte smarty-variabelen.</li>
</ul>';
$lang['help_function_tab_end'] = '<h3>Hva gjør dette?</h3>
   <p>Denne plugin-en sender ut HTML-koden for å angi slutten av et innholdsområde.</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Følgende kode oppretter et innholdsområde med faner med to faner.</p>
<pre><code>{tab_header name=\'tab1\' label=\'Tab One\'}
{tab_header name=\'tab2\' label=\'Tab to\'}
{tab_start name=\'tab1\'}
<p>Dette er fane One</p>
{tab_start name=\'tab2\'}
<p>Dette er fane to</p>
<span style="color: blue;">{tab_end}</span></code></pre>
<h3>Hvilke parametere krever det?</h3>
<ul>
    <li>tilordne - <em>(valgfritt)</em> - Tilordne utdata til den navngitte smarty-variabelen.</li>
</ul>
<h3>Se også:</h3>
   <ul>
     <li>{tab_header}</li>
     <li>{tab_start}</li>
   </ul>';
$lang['help_function_tab_header'] = '<h3>Hva gjør dette?</h3>
   <p>Denne taggen genererer HTML-koden for å avgrense overskriften for en enkelt fane i et innholdsområde med faner.</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Følgende kode oppretter et innholdsområde med faner med to faner.</p>
<pre><code><span style="color: blue;">{tab_header name=\'tab1\' label=\'Tab One\'}</span>
<span style="color: blue;">{tab_header name=\'tab2\' label=\'Tab Two\'}</span>
{tab_start name=\'tab1\'}
<p>Dette er fane One</p>
{tab_start name=\'tab2\'}
<p>Dette er fane to</p>
{tab_end}</code></pre>
<p><strong>Merk:</strong> <code>{tab_start}</code> må kalles med navnene i samme rekkefølge som de ble gitt til <code>{tab_header}</code></p >
<h3>Hvilke parametere krever det?</h3>
<ul>
    <li><strong>navn – obligatorisk streng</strong> – Navnet på fanen. Må samsvare med navnet på en fane som sendes til {tab_header}</li>
    <li>etikett - <em>valgfri streng</em> - Den lesbare etiketten for fanen. Hvis det ikke er spesifisert, vil fanenavnet bli brukt.</li>
    <li>aktiv - <em>valgfritt blandet./em> - Angir om dette er den aktive fanen eller ikke. Du kan sende inn navnet (strengen) til den aktive fanen i en sekvens av tabulatoroverskrifter, eller en boolsk verdi.</li>
    <li>tilordne - <em>(valgfritt)</em> - Tilordne utdata til den navngitte smarty-variabelen.</li>
</ul>
<h3>Se også:</h3>
   <ul>
     <li>{tab_start}</li>
     <li>{tab_end}</li>
   </ul>';
$lang['help_function_tab_start'] = '<h3>Hva gjør dette?</h3>
   <p>Dette programtillegget gir html-koden for å avgrense starten av innhold for en bestemt fane i et innholdsområde med faner.</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Følgende kode oppretter et innholdsområde med faner med to faner.</p>
<pre><code>{tab_header name=\'tab1\' label=\'Tab One\'}
{tab_header name=\'tab2\' label=\'Tab to\'}
<span style="color: blue;">{tab_start name=\'tab1\'}</span>
<p>Dette er fane One</p>
<span style="color: blue;">{tab_start name=\'tab2\'}</span>
<p>Dette er fane to</p>
{tab_end}</code></pre>
<p><strong>Merk:</strong> <code>{tab_start}</code> må kalles med navnene i samme rekkefølge som de ble gitt til <code>{tab_header}</code></p >
<h3>Hvilke parametere krever det?</h3>
<ul>
    <li><strong>navn – obligatorisk</strong> – navnet på fanen. Må samsvare med navnet på en fane som sendes til {tab_header}</li>
    <li>tilordne - <em>(valgfritt)</em> - Tilordne utdata til den navngitte smarty-variabelen.</li>
</ul>
<h3>Se også:</h3>
   <ul>
     <li>{tab_header}</li>
     <li>{tab_end}</li>
   </ul>';
$lang['help_function_title'] = '<h3>Hva gjør dette?</h3>
<p>Skriver ut tittelen på siden.</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Bare sett inn taggen i malen/siden din som: <code>{title}</code></p>
<h3>Hvilke parametere krever det?</h3>
<p><em>(valgfritt)</em> tilordne (streng) – tilordne resultatene til en smart variabel med det navnet.</p>';
$lang['help_function_stylesheet'] = '<h3>Hva gjør dette?</h3>
         <p><strong>Utdatert:</strong> Denne funksjonen er utdatert og vil bli fjernet i senere versjoner av CMSMS.</p>
<p>Henter stilarkinformasjon fra systemet. Som standard tar den tak i alle stilarkene som er knyttet til gjeldende mal.</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Bare sett inn taggen i malen/sidens hodeseksjon som: <code>{stylesheet}</code></p>
<h3>Hvilke parametere krever det?</h3>
<ul>
<li><em>(valgfritt)</em>navn – i stedet for å få alle stilark for den gitte siden, vil den bare få ett spesifikt navngitt, enten det er knyttet til gjeldende mal eller ikke.</li>
<li><em>(valgfritt)</em>media – Hvis navn er definert, lar dette deg angi en annen medietype for det stilarket.</li>
     <li><em>(valgfritt)</em>templateid – Hvis templateid er definert, vil dette returnere stilark knyttet til den malen i stedet for den gjeldende.</li>
<li><em>(valgfritt)</em> <tt>tilordne</tt> – Tilordne resultatene til den navngitte smarty-variabelen.</li>
</ul>';
$lang['help_function_sitename'] = '<h3>Hva gjør dette?</h3>
         <p>Viser navnet på nettstedet. Dette defineres under installasjonen og kan endres i Global Settings-delen av administrasjonspanelet.</p>
         <h3>Hvordan bruker jeg det?</h3>
         <p>Bare sett inn taggen i malen/siden din som: <code>{sitename}</code></p>
         <h3>Hvilke parametere krever det?</h3>
<p><em>(valgfritt)</em> tilordne (streng) – tilordne resultatene til en smart variabel med det navnet.</p>';
$lang['help_function_search'] = '<h3>Hva gjør dette?</h3>
<p>Dette er faktisk bare en innpakningskode for søkemodulen for å gjøre tagsyntaksen enklere.
I stedet for å måtte bruke <code>{cms_module module=\'Search\'}</code> kan du nå bare bruke <code>{search}</code> for å sette inn modulen i en mal.
</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Bare legg inn <code>{search}</code> i en mal der du vil at søkeinndataboksen skal vises. For hjelp om søkemodulen, se hjelpen til søkemodulen.</p>';
$lang['help_function_cms_textarea'] = '<h3>Hva gjør dette?</h3>
   <p>Denne smarte plugin-en brukes når du bygger administrasjonsskjemaer for å generere et tekstområdefelt. Den har forskjellige parametere som gjør det mulig å kontrollere om en WYSIWYG-plugin brukes <em>(hvis tilgjengelig)</em> eller en syntaksuthever, og for å påvirke oppførselen til disse modulene, og størrelsen og utseendet til tekstområdet.</p >
   <h3>Hvordan bruker jeg det?</h3>
     <p>Den enkleste måten å bruke denne plugin-en på er ved å spesifisere <code>{cms_textarea name="noe"}</code>. Dette vil lage et enkelt tekstområde uten WYSIWYG eller syntaksuthevingsmoduler aktivert, med det angitte navnet.</p>
     <p>Deretter kan du spesifisere standardverdien for tekstområdet ved å bruke "tekst" eller "verdi" parametere.</p>
   <h3>Hvilke parametere krever det?</h3>
   <ul>
     <li>navn - obligatorisk streng : navneattributt for tekstområdeelementet.</li>
     <li>prefiks - valgfri streng : valgfritt prefiks for navneattributtet.</li>
     <li>klasse - valgfri streng : klasseattributt for tekstområdeelementet. Ytterligere klasser kan legges til automatisk.</li>
     <li>klassenavn – alias for klasseparameteren.</li>
     <li>forcemodule - valgfri streng : brukes til å spesifisere WYSIWYG- eller syntaksuthevingsmodulen som skal aktiveres. Hvis det er spesifisert og tilgjengelig, vil modulnavnet bli lagt til i klasseattributtet.</li>
     <li>enablewysiwyg - valgfri boolesk : brukes til å spesifisere om et WYSIWYG-tekstområde er nødvendig. Setter språket til "html"</li>
     <li>wantedsyntax - valgfri streng som brukes til å spesifisere språket (html,css,php,smarty...) som skal brukes. Hvis ikke tom, indikerer det at en syntaksuthevingsmodul er forespurt.</li>
     <li>type - alias for parameteren wantedsyntax.</li>
     <li>cols - valgfritt heltall : kolonner i tekstområdet (admin-tema css eller syntaks/WYSIWYG-modulen kan overstyre dette).</li>
     <li>width - alias for cols-parameteren.</li>
     <li>rader - valgfritt heltall : rader i tekstområdet (admin-tema css eller syntaks/WYSIWYG-modulen kan overstyre dette).</li>
     <li>høyde – alias for radparameteren.</li>
     <li>maxlength - valgfritt heltall: maxlength-attributtet for tekstområdet (syntaks/WYSIWYG-modul kan ignorere dette).</li>
     <li>obligatorisk - valgfri boolesk : indikerer et obligatorisk felt.</li>
     <li>plassholder - valgfri streng : plassholderattributt for tekstområdet (syntaks/WYSIWYG-modul kan ignorere dette).</li>
     <li>verdi – valgfri streng : standardtekst for tekstområdet, vil gjennomgå enhetskonvertering.</li>
     <li>tekst – alias for verdiparameteren</li>
     <li>cssname - valgfri streng : send dette stilarknavnet til WYSIWYG-modulen hvis en WYSIWYG-modul er aktivert.</li>
     <li>legg til tekst – valgfri streng : tilleggstekst for å legge til tekstområde-taggen.</li>
     <li>tilordne - valgfri streng : tilordne utdata-html til den navngitte smarty-variabelen.</li>
   </ul>';
$lang['help_function_root_url'] = '<h3>Hva gjør dette?</h3>
<p>Skriver ut rot-url-plasseringen for nettstedet.</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Bare sett inn taggen i malen/siden din som: <code>{root_url}</code></p>
<h3>Hvilke parametere krever det?</h3>
         <p><em>(valgfritt)autossl=1</em> – Aktivert som standard, vil dette alternativet oppdage om forespørselen til serveren var over SSL, og om den returnerte den riktig konfigurerte SSL-url. For å deaktivere denne funksjonen, spesifiser autossl=0.</p>
<p><em>(valgfritt)</em> tilordne (streng) – tilordne resultatene til en smart variabel med det navnet.</p>';
$lang['help_function_repeat'] = '<h3>Hva gjør dette?</h3>
   <p>Gjentar en spesifisert sekvens av tegn, et spesifisert antall ganger</p>
   <h3>Hvordan bruker jeg det?</h3>
   <p>Sett inn en tag som ligner på følgende i malen/siden din, slik: <code>{repeat string=\'repeat this \' times=\'3\'}</code></p>
   <h3>Hvilke parametere krever det?</h3>
   <ul>
   <li>string=\'text\' - strengen som skal gjentas</li>
   <li>times=\'num\' – Antall ganger det skal gjentas.</li>
   <li><em>(valgfritt)</em> tilordne (streng) – tilordne resultatene til en smarty-variabel med det navnet.</li>
   </ul>';
$lang['help_function_recently_updated'] = '<h3>Hva gjør dette?</h3>
<p>Skriver ut en liste over nylig oppdaterte sider.</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Bare sett inn taggen i malen/siden din som: <code>{recently_updated}</code></p>
<h3>Hvilke parametere krever det?</h3>
<ul>
<li><p><em>(valgfritt)</em> number=\'10\' – Antall oppdaterte sider som skal vises.</p><p>Eksempel: {recently_updated number=\'15\'}</p> </li>
  <li><p><em>(valgfritt)</em> leadin=\'Sist endret\' - Tekst som vises til venstre for endringsdatoen.</p><p>Eksempel: {recently_updated leadin=\'Sist endret\'} </p></li>
  <li><p><em>(valgfritt)</em> showtitle=\'true\' – Viser tittelattributtet hvis det også finnes (true|false).</p><p>Eksempel: {recently_updated showtitle= \'true\'}</p></li>
<li><p><em>(valgfritt)</em> css_class=\'some_name\' – Fordrei en div-tag med denne klassen rundt listen.</p><p>Eksempel: {recently_updated css_class=\'some_name\'} </p></li>
<li><p><em>(valgfritt)</em> dateformat=\'d.m.y h:m\' - standard er d.m.y h:m , bruk formatet du ønsker (php -date- format)</p><p >Eksempel: {recently_updated dateformat=\'D M j G:i:s T Y\'}</p></li>
<li><em>(valgfritt)</em> <tt>tilordne</tt> – Tilordne resultatene til den navngitte smarty-variabelen.</li>
</ul>
<p>eller kombinert:</p>
<pre>{recently_updated number=\'15\' showtitle=\'false\' leadin=\'Siste endring: \' css_class=\'my_changes\' dateformat=\'D M j G:i:s T Y\'}</pre>';
$lang['help_function_print'] = '<h3>Hva gjør dette?</h3>
<p>Dette er faktisk bare en wrapper-tag for CMSPrinting-modulen for å gjøre tag-syntaksen enklere.
I stedet for å måtte bruke <code>{cms_module module=\'CMSPrinting\'}</code> kan du nå bare bruke <code>{print}</code> for å sette inn modulen på sider og maler.
</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Bare legg inn <code>{print}</code> på en side eller i en mal. For hjelp om CMSPrinting-modulen, hvilke parametere den krever osv., se hjelpen til CMSPrinting-modulen.</p>';
$lang['help_function_news'] = '<h3>Hva gjør dette?</h3>
<p>Dette er faktisk bare en innpakningskode for Nyhetsmodulen for å gjøre tagsyntaksen enklere.
I stedet for å måtte bruke <code>{cms_module module=\'News\'}</code> kan du nå bare bruke <code>{news}</code> for å sette inn modulen på sider og maler.
</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Bare legg inn <code>{news}</code> på en side eller i en mal. For hjelp om Nyhetsmodulen, hvilke parametere den krever osv., se hjelpen til Nyhetsmodulen.</p>';
$lang['help_function_modified_date'] = '<h3>Hva gjør dette?</h3>
         <p>Skriver ut datoen og klokkeslettet siden sist ble endret. Hvis det ikke er oppgitt noe format, vil det som standard ha et format som ligner på "01. januar 2004".</p>
         <h3>Hvordan bruker jeg det?</h3>
         <p>Bare sett inn taggen i malen/siden din som: <code>{modified_date format="%A %d-%b-%y %T %Z"}</code></p>
         <h3>Hvilke parametere krever det?</h3>
         <ul>
                 <li><em>(valgfritt)</em>format - Dato-/klokkeslettformat ved hjelp av parametere fra phps strftime-funksjon. Se <a href="http://php.net/strftime" target="_blank">her</a> for en parameterliste og informasjon.</li>
                 <li><em>(valgfritt)</em>tilordne – tilordne resultatene til den navngitte smarty-variabelen.</li>
         </ul>';
$lang['help_function_metadata'] = '<h3>Hva gjør dette?</h3>
<p>Viser metadataene for denne siden. Både globale metadata fra den globale innstillingssiden og metadata for hver side vises.</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Bare sett inn taggen i malen din som: <code>{metadata}</code></p>
<h3>Hvilke parametere krever det?</h3>
<ul>
<li><em>(valgfritt)</em>showbase (true/false) – Hvis satt til usant, vil ikke basiskoden bli sendt ut.</li>
<li><em>(valgfritt)</em> <tt>tilordne</tt> – Tilordne resultatene til den navngitte smarty-variabelen.</li>
</ul>';
$lang['help_function_menu_text'] = '<h3>Hva gjør dette?</h3>
<p>Skriver ut menyteksten på siden.</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Bare sett inn taggen i malen/siden din som: <code>{menu_text}</code></p>
<h3>Hvilke parametere krever det?</h3>
<p><em>(valgfritt)</em> tilordne (streng) – tilordne resultatene til en smart variabel med det navnet.</p>';
$lang['help_function_menu'] = '<h3>Hva gjør dette?</h3>
<p>Dette er faktisk bare en innpakningskode for Menybehandling-modulen for å gjøre tagsyntaksen enklere.
I stedet for å måtte bruke <code>{cms_module module=\'MenuManager\'}</code> kan du nå bare bruke <code>{menu}</code> for å sette inn modulen på sider og maler.
</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Bare legg inn <code>{menu}</code> på en side eller i en mal. For hjelp om Meny Manager-modulen, hvilke parametere den krever osv., se hjelpen til Meny Manager-modulen.</p>';
$lang['help_function_last_modified_by'] = '<h3>Hva gjør dette?</h3>
         <p>Skriver ut den siste personen som redigerte denne siden. Hvis det ikke er oppgitt noe format, vil det som standard være et ID-nummer for bruker .</p>
         <h3>Hvordan bruker jeg det?</h3>
         <p>Bare sett inn taggen i malen/siden din som: <code>{last_modified_by format="fullname"}</code></p>
         <h3>Hvilke parametere krever det?</h3>
         <ul>
                 <li><em>(valgfritt)</em>format – id, brukernavn, fullt navn</li>
<li><em>(valgfritt)</em> <tt>tilordne</tt> – Tilordne resultatene til den navngitte smarty-variabelen.</li>
         </ul>';
$lang['help_function_image'] = '<h3>Hva gjør dette?</h3>
   <p>Oppretter en bildekode til et bilde som er lagret i bildekatalogen din</p>
   <h3>Hvordan bruker jeg det?</h3>
   <p class="warning">Dette programtillegget er utdatert og vil bli fjernet fra kjernen på et senere tidspunkt.</p>
   <p>Bare sett inn taggen i malen/siden din som: <code>{image src="something.jpg"}</code></p>
   <h3>Hvilke parametere krever det?</h3>
   <ul>
      <li><em>(påkrevd)</em> <tt>src</tt> – Bildefilnavn i bildekatalogen.</li>
      <li><em>(valgfritt)</em> <tt>bredde</tt> – Bredden på bildet på siden. Standard til sann størrelse.</li>
      <li><em>(valgfritt)</em> <tt>høyde</tt> – Høyden på bildet på siden. Standard til sann størrelse.</li>
      <li><em>(valgfritt)</em> <tt>alt</tt> – Alt-tekst for bildet – nødvendig for xhtml-samsvar. Standard til filnavn.</li>
      <li><em>(valgfritt)</em> <tt>klasse</tt> – CSS-klasse for bildet.</li>
      <li><em>(valgfritt)</em> <tt>tittel</tt> – Hold musepekeren over teksten til bildet. Standard til Alt-tekst.</li>
      <li><em>(valgfritt)</em> <tt>legg til tekst</tt> – tilleggstekst som skal legges inn i taggen</li>
<li><em>(valgfritt)</em> <tt>tilordne</tt> – Tilordne resultatene til den navngitte smarty-variabelen.</li>
   </ul>';
$lang['help_function_html_blob'] = '<h3>Hva gjør denne?</h3>
	<p>Se hjelpen for global_content for en beskrivelse.</p>';
$lang['help_function_google_search'] = '<h3>Hva gjør dette?</h3>
<p>Søk er nettstedet ditt ved hjelp av Googles søkemotor.</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Bare sett inn taggen i malen/siden din som: <code>{google_search}</code><br />
<br />
Merk: Google må ha nettstedet ditt indeksert for at dette skal fungere. Du kan sende inn nettstedet ditt til Google <a href="http://www.google.com/addurl.html">her</a>.</p>
<h3>Hva om jeg vil endre utseendet på tekstboksen eller knappen?</h3>
<p>Utseendet til tekstboksen og knappen kan endres via css. Tekstboksen får en ID for textSearch og knappen får en ID for buttonSearch.</p>

<h3>Hvilke parametere krever det?</h3>
<ul>
<li><em>(valgfritt)</em> domene – Dette forteller google nettsteddomenet å søke. Dette skriptet prøver å fastslå dette automatisk.</li>
<li><em>(valgfritt)</em> knappTekst – Teksten du vil vise på søkeknappen. Standard er "Søk på nettsted".</li>
<li><em>(valgfritt)</em> <tt>tilordne</tt> – Tilordne resultatene til den navngitte smarty-variabelen.</li>
</ul>';
$lang['help_function_global_content'] = '<h3>Hva gjør dette?</h3>
<p>Setter inn en global innholdsblokk i malen eller siden din.</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Bare sett inn taggen i malen/siden din som: <code>{global_content name=\'myblock\'}</code>, der navn er navnet som ble gitt til blokken da den ble opprettet.</p>
<h3>Hvilke parametere krever det?</h3>
<ul>
   <li>navn – navnet på den globale innholdsblokken som skal vises.</li>
           <li><em>(valgfritt)</em> assign - Navnet på en smarty-variabel som den globale innholdsblokken skal tilordnes.</li>
</ul>';
$lang['help_function_get_template_vars'] = '<h3>Hva gjør dette?</h3>
<p>Dumper alle de kjente smarty-variablene inn på siden din</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Bare sett inn taggen i malen/siden din som: <code>{get_template_vars}</code></p>
<h3>Hvilke parametere krever det?</h3>
<p><em>(valgfritt)</em> tilordne (streng) – tilordne resultatene til en smart variabel med det navnet.</p>';
$lang['help_function_page_error'] = '<h3>Hva gjør dette?</h3>
<p>Dette er en admin-plugin som viser en feil på en CMSMS-administrasjonsside.</p>
<h3>Hvilke parametere krever det?</h3>
<ul>
   <li>melding - <strong>obligatorisk streng</strong> - Feilmeldingen som skal vises.</li>
   <li>tilordne - <em>(valgfritt)</em> - Tilordne utdata til den navngitte smarty-variabelen.</li>
</ul>
<h3>Eksempel:</h3>
<pre><code>{page_error msg=\'Error Encountered\'}</code></pre>';
$lang['help_function_page_warning'] = '<h3>Hva gjør denne?</h3>
<p>Dette er en admin plugin som viser en advarsel på en CMSMS admin side.</p>
<h3>Hvilke parametere tar det?</h3>
<ul>
  <li>melding - <strong>required string</strong> - Advarselsmeldingen som skal vises.</li>
  <li>tildel - <em>(valgfri)</em> - Tilordne output til den navngitte smarty-variabelen.</li>
</ul>
<h3>Eksempel:</h3>
<pre><code>{page_warning msg=\'Something smells fishy\'}</code></pre>';
$lang['help_function_uploads_url'] = '<h3>Hva gjør denne?</h3>
	<p>Skriver ut opplastinger url stedet for området.</p>
	<h3>Hvordan bruker jeg det?</h3>
	<p>Bare sett inn koden i malen/siden som: <code>{uploads_url}</code></p>
	<h3>Hvilke parametere tar det?</h3>
	<p><em>(optional)</em> assign (string) - Tilordne resultatene til en smarty-variabel med det navnet.</p>';
$lang['help_function_embed'] = '<h3>Hva gjør dette?</h3>
<p>Aktiver inkludering (innebygging) av enhver annen applikasjon i CMS. Den mest vanlige bruken kan være et forum.
Denne implementeringen bruker IFRAMES slik at eldre nettlesere kan ha problemer. Beklager, men dette er den eneste kjente måten
som fungerer uten å endre det innebygde programmet.</p>
<h3>Hvordan bruker jeg det?</h3>
         <ul>
         <li>a) Legg til <code>{embed header=true}</code> i head-delen av sidemalen din, eller i metadata-delen i alternativfanen på en innholdsside. Dette vil sikre at nødvendig JavaScript blir inkludert. Hvis du setter inn denne taggen i metadatadelen i alternativfanen på en innholdsside, må du sørge for at <code>{metadata}</code> er i sidemalen.</li>
         <li>b) Legg til <code>{embed url="http://www.google.com"}</code> i sideinnholdet eller i brødteksten i sidemalen.</li>
         </ul>
         <br/>
         <h4>Eksempel for å gjøre iframen større</h4>
<p>Legg til følgende i stilarket:</p>
         <pre>#myframe { height: 600px; }</pre>
         <br/>
         <h3>Hvilke parametere krever det?</h3>
         <ul>
             <li><em>(obligatorisk)</em>url – nettadressen som skal inkluderes</li>
             <li><em>(obligatorisk)</em>header=true – dette vil generere overskriftskoden for god endring av størrelsen på IFRAME.</li>
             <li>(valgfritt)navn – et valgfritt navn som skal brukes for iframe (i stedet for myframe).<p>Hvis dette alternativet brukes, må det brukes identisk i begge samtalene, dvs.: {embed header=true name=foo } og {embed name=foo url=http://www.google.com} anrop.</p></li>

         </ul>';
$lang['help_function_description'] = '<h3>Hva gjør dette?</h3>
<p>Skriver ut beskrivelsen (tittelattributtet) av siden.</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Bare sett inn taggen i malen/siden din som: <code>{description}</code></p>
<h3>Hvilke parametere krever det?</h3>
<p><em>(valgfritt)</em> tilordne (streng) – tilordne resultatene til en smart variabel med det navnet.</p>';
$lang['help_function_created_date'] = '<h3>Hva gjør dette?</h3>
         <p>Skriver ut datoen og klokkeslettet siden ble opprettet. Hvis det ikke er oppgitt noe format, vil det som standard ha et format som ligner på "01. januar 2004".</p>
         <h3>Hvordan bruker jeg det?</h3>
         <p>Bare sett inn taggen i malen/siden din som: <code>{created_date format="%A %d-%b-%y %T %Z"}</code></p>
         <h3>Hvilke parametere krever det?</h3>
         <ul>
                 <li><em>(valgfritt)</em>format - Dato-/klokkeslettformat ved hjelp av parametere fra phps strftime-funksjon. Se <a href="http://php.net/strftime" target="_blank">her</a> for en parameterliste og informasjon.</li>
                 <li><em>(valgfritt)</em>tilordne – tilordne resultatene til den navngitte smarty-variabelen.</li>
         </ul>';
$lang['help_function_content'] = '<h3>Hva gjør dette?</h3>
<p>Det er her innholdet for siden din vises. Den settes inn i malen og endres basert på gjeldende side som vises.</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Bare sett inn taggen i malen din som: <code>{content}</code>.</p>
<p><strong>Standardblokken <code>{content}</code> kreves for at den skal fungere ordentlig. (altså uten blokk-parameteren)</strong> For å gi blokken en spesifikk etikett, bruk label-parameteren. Ytterligere blokker kan legges til ved å bruke blokk-parameteren.</p>
<h3>Hvilke parametere krever det?</h3>
<ul>
<li><em>(valgfritt) </em>blokk – lar deg ha mer enn én innholdsblokk per side. Når flere innholdstagger settes på en mal, vil det antallet redigeringsbokser vises når siden redigeres.
<p>Eksempel:</p>
<pre>{content block="second_content_block" label="Andre innholdsblokk"}</pre>
<p>Når du redigerer en side vil det et tekstområde som heter "Andre innholdsblokk".</p></li>
<li><em>(valgfritt)</em> wysiwyg (true/false) - Hvis satt til usant, vil en WYSIWYG aldri bli brukt under redigering av denne blokken. Hvis det er sant, fungerer det som normalt. Fungerer bare når blokkparameter brukes.</li>
<li><em>(valgfritt)</em> oneline (true/false) - Hvis satt til true, vil bare én redigeringslinje vises mens du redigerer denne blokken. Hvis det er usant, fungerer det som normalt. Fungerer bare når blokkparameter brukes.</li>
         <li><em>(valgfritt)</em> størrelse (positivt heltall) – Gjelder kun når oneline-alternativet brukes. Denne valgfrie parameteren lar deg spesifisere størrelsen på redigeringsfeltet. Standardverdien er 50.</li>
<li><em>(valgfritt)</em> maxlength (positivt heltall) – Gjelder bare når oneline-alternativet brukes. Denne valgfrie parameteren lar deg spesifisere maksimal lengde på inndata for redigeringsfeltet. Standardverdien er 255.</li>
         <li><em>(valgfritt)</em> standard (streng) – Lar deg spesifisere standardinnhold for disse innholdsblokkene (bare ekstra innholdsblokker).</li>
<li><em>(valgfritt)</em> etikett (streng) – Gjør det mulig å spesifisere en etikett for visning på siden for redigering av innhold.</li>
         <li><em>(valgfritt)</em> kreves (true/false) – Gjør det mulig å spesifisere at innholdsblokken må inneholde noe tekst.</li>
         <li><em>(valgfritt)</em> plassholder (streng) – Gjør det mulig å spesifisere plassholdertekst.</li>
         <li><em>(valgfritt)</em> prioritet (heltall) – Gjør det mulig å spesifisere en heltallsprioritet for blokken i fanen.</li>
         <li><em>(valgfritt)</em>-fane (streng) – den ønskede fanen for å vise dette feltet i redigeringsskjemaet.</li>
         <li><em>(valgfritt)</em> cssname (streng) – Et hint til WYSIWYG-redigeringsmodulen for å bruke det angitte stilarknavnet for utvidede stiler.</li>
         <li><em>(valgfritt)</em> noedit (true/false) - Hvis satt til true, vil ikke innholdsblokken være tilgjengelig for redigering i innholdsredigeringsskjemaet. Dette er nyttig for å sende ut en innholdsblokk til sideinnhold som ble opprettet via en tredjepartsmodul.</li>
         <li><em>(valgfritt)</em> data-xxxx (streng) – Lar overføring av dataattributter til det genererte tekstområdet for bruk av syntaks hilighter og WYSIWYG-moduler.
             <p>dvs.: <code>{content data-foo="bar"}</code></p>
         </li>
         <li><em>(valgfritt)</em> Adminonly (true/false) - Hvis satt til true, er det kun medlemmer av den spesielle "Admin" gruppe (gid==1) vil kunne redigere denne innholdsblokken.</li>
<li><em>(valgfritt)</em> tilordne - Tildeler innholdet til en smarty-parameter, som du deretter kan bruke i andre områder av siden, eller bruke til å teste om innholdet finnes på den eller ikke.
<p>Eksempel på overføring av sideinnhold til en brukerdefinert tag som parameter:</p></li>
<pre>
          {content assign=pagecontent}
          {table_of_contents thepagecontent="$pagecontent"}
</pre>
</li>
</ul>';
$lang['help_function_contact_form'] = '<h2>MERK: Denne plugin er foreldet</h2>
  <h3>Dette programtillegget er fjernet fra og CMS Made Simple versjon 1.5</h3>
  <p>Du kan bruke modulen FormBuilder i stedet.</p>';
$lang['help_function_cms_versionname'] = '<h3>Hva gjør dette?</h3>
<p>Denne taggen brukes til å sette inn gjeldende versjonsnavn av CMS i malen eller siden din. Den viser ikke noe ekstra i tillegg til versjonsnavnet.</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Dette er bare en grunnleggende tag-plugin. Du vil sette den inn i malen eller siden din slik: <code>{cms_versionname}</code>
<h3>Hvilke parametere krever det?</h3>
<p><em>(valgfritt)</em> tilordne (streng) – tilordne resultatene til en smart variabel med det navnet.</p>';
$lang['help_function_cms_version'] = '<h3>Hva gjør dette?</h3>
<p>Denne taggen brukes til å sette inn gjeldende versjonsnummer av CMS i malen eller siden din. Den viser ikke noe ekstra i tillegg til versjonsnummeret.</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Dette er bare en grunnleggende tag-plugin. Du vil sette den inn i malen eller siden din slik: <code>{cms_version}</code></p>
<h3>Hvilke parametere krever det?</h3>
<p><em>(valgfritt)</em> tilordne (streng) – tilordne resultatene til en smart variabel med det navnet.</p>';
$lang['help_function_cms_selflink'] = '<h3>Hva gjør dette?</h3>
<p>Oppretter en kobling til en annen CMSMS-innholdsside i malen eller innholdet.</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Bare sett inn taggen i malen/siden din som: <code>{cms_selflink page="1"}</code> eller <code>{cms_selflink page="alias"}</code></p >
<h3>Hvilke parametere krever det?</h3>
<ul>
<li><em>(valgfritt)</em> <tt>side</tt> – Side-ID eller alias å koble til.</li>
<li><em>(valgfritt)</em> <tt>ankerkobling</tt> – Spesifiserer et anker som skal legges til i den genererte nettadressen.</li>
<li><em>(valgfritt)</em> <tt>urlparam</tt> – Spesifiser flere parametere til URL-en. <strong>Ikke bruk dette sammen med parameteren <em>anchorlink</em></strong></li>
<li><em>(valgfritt)</em> <tt>tabindex ="en verdi"</tt> - Angi en tabindex for lenken.</li> <!-- Russ - 22-06-2005 -->
<li><em>(valgfritt)</em> <tt>dir start/neste/prev/up (forrige)</tt> – Lenker til standard startside eller neste eller forrige side, eller overordnet side ( opp). Hvis dette brukes, skal <tt>side</tt> ikke settes.</li>
</ul>
<strong>Merk!</strong> Bare ett av de ovennevnte kan brukes i den samme cms_selflink-setningen!!
<ul>
<li><em>(valgfritt)</em> <tt>tekst</tt> – Tekst som skal vises for koblingen. Hvis det ikke er oppgitt, brukes sidenavnet i stedet.</li>
<li><em>(valgfritt)</em> <tt>meny 1/0</tt> - Hvis 1 brukes menyteksten for lenketeksten i stedet for sidenavnet</li>
<li><em>(valgfritt)</em> <tt>mål</tt> – Valgfritt mål for en lenke å peke til. Nyttig for ramme- og JavaScript-situasjoner.</li>
<li><em>(valgfritt)</em> <tt>klasse</tt> – Klasse for <a> link. Nyttig for å style lenken.</li>
<li><em>(valgfritt)</em> <tt>id</tt> – Valgfri css_id for <a> lenke.</li>
<li><em>(valgfritt)</em> <tt>mer</tt> - plasser flere alternativer i <a> lenke.</li>
<li><em>(valgfritt)</em> <tt>etikett</tt> – Etikett som skal brukes sammen med koblingen hvis aktuelt.</li>
<li><em>(valgfritt)</em> <tt>label_side left/right</tt> - Side av lenken for å plassere etiketten (standard til "venstre").</li>
<li><em>(valgfritt)</em> <tt>tittel</tt> – Tekst som skal brukes i tittelattributtet. Hvis ingen er oppgitt, vil tittelen på siden bli brukt for tittelen.</li>
<li><em>(valgfritt)</em> <tt>rellink 1/0</tt> – Lag en relasjonskobling for tilgjengelig navigering. Fungerer bare hvis dir-parameteren er satt og skal bare gå i hodedelen av en mal.</li>
<li><em>(valgfritt)</em> <tt>href</tt> – Spesifiserer at bare resultat-URLen til sidealiaset som er spesifisert vil bli returnert. Dette er i hovedsak lik {cms_selflink page="alias" urlonly=1}. <strong>Eksempel:</strong> <a href="{cms_selflink href="alias"}"><img src=""></a>.</li>
<li><em>(valgfritt)</em> <tt>urlonly</tt> – Spesifiserer at bare den resulterende url skal skrives ut. Alle parametere knyttet til generering av koblinger ignoreres.</li>
<li><em>(valgfritt)</em> <tt>bilde</tt> – En url til et bilde som skal brukes i lenken. <strong>Eksempel:</strong> {cms_selflink dir="neste" image="neste.png" text="Neste"}</li>
<li><em>(valgfritt)</em> <tt>alt</tt> - Alternativ tekst som skal brukes med bilde (alt="" vil bli brukt hvis ingen alt-parameter er oppgitt).</li>
<li><em>(valgfritt)</em> <tt>bredde</tt> – Bredde som skal brukes med bildet (ingen width-attributt vil bli brukt på utdata-img-taggen hvis den ikke er oppgitt).</li>
<li><em>(valgfritt)</em> <tt>høyde</tt> – Høyde som skal brukes med bildet (ingen høydeattributt vil bli brukt på utdata-img-taggen hvis den ikke er oppgitt).</li>
<li><em>(valgfritt)</em> <tt>kun bilde</tt> - Hvis du bruker et bilde, om du vil undertrykke visning av tekstlenker. Hvis du ikke vil ha tekst i lenken i det hele tatt, setter du også lang=0 for å undertrykke etiketten. <strong>Eksempel:</strong> {cms_selflink dir="neste" image="neste.png" text="Neste" imageonly=1}</li>
         <li><em>(valgfritt)</em> <tt>tilordne</tt> – Tilordne resultatene til den navngitte smarty-variabelen.</li>
</ul>';
$lang['help_function_cms_module'] = '<h3>Hva gjør denne?</h3>
	<p>Denne taggen brukes til å sette inn moduler i maler og sider. Hvis en modul er laget for å bli brukt som en tag plugin (sjekk den hjelp for detaljer), så du bør være i stand til å sette den inn med denne taggen.</p>
	<h3>Hvordan bruker jeg det?</h3>
	<p>Det er bare en grunnleggende tag plugin. Du vil sette den inn i malen eller siden din slik:<code>{cms_module module="somemodulename"}</code></p>
	<h3>Hvilke parametere tar den?</h3>
	<p>Det er bare en nødvendig parameter. Alle andre parametere overføres til modulen.</p>
	<ul>
		<li>modul - Navn på modulen som skal settes inn. Dette er ikke små og små bokstaver.</li>
	</ul>';
$lang['help_function_cms_module_hint'] = '<h3>Hva gjør dette?</h3>
<p>Denne funksjonsplugin-modulen kan brukes til å gi hint for modulens oppførsel hvis ulike parametere ikke kan spesifiseres på URL-en. Dvs.: I en situasjon når et nettsted er konfigurert til å bruke pene nettadresser for SEO-formål, er det ofte umulig å gi ytterligere modulparametere som en detaljmal eller sorteringsrekkefølge på en URL. Denne plugin-en kan brukes i sidemaler, GCB-er eller på en sidespesifikk måte for å gi hint om hvordan moduler bør oppføre seg.</p>
<p><strong>Merk:</strong> Eventuelle parametere som er spesifisert på nettadressen vil overstyre matchende modulhint. dvs.: Når du bruker Nyheter og en detaljmal-parameter er spesifisert på en nyhetsdetalj-url, vil eventuelle detaljmal-hint ikke ha noen effekt.</p>
<p><strong>Merk:</strong> For å sikre riktig oppførsel må modulhint opprettes før {content}-taggen kjøres i CMSMS-sidemalen. Derfor bør de (normalt) opprettes veldig tidlig i sidemalprosessen. En ideell plassering for sidespesifikke hint er i "Smarty data eller logikk som er spesifikk for denne siden:" tekstområde på innholdsredigeringsskjemaet.</p>
<h3>Parametere:</h3>
<ul>
   <li>modul - <strong>obligatorisk streng</strong> - modulnavnet du legger til et hint for.</i>
</ul>
<p>Eventuelle ytterligere parametere til denne taggen lagres som hint.</p>
<h3>Eksempel:</h3>
<p>Når du bruker nyhetsmodulen, konfigureres og pene nettadresser. Du ønsker å vise nyhetsartikler for en bestemt kategori på én side, og vil gjerne bruke en ikke-standard detaljmal for å vise de enkelte artiklene på en annen side. Dvs: kanskje på din "Sports" siden du ringer til Nyheter som: <code>{News category=sports detailpage=sports_detail}</code>. Ved å bruke pene nettadresser kan det imidlertid være umulig å spesifisere en detaljmal på lenkene som vil generere detaljvisningene. Løsningen er å bruke {cms_module_hint}-taggen på <u>sports_detail</u>-siden for å gi noen hint om hvordan News bør oppføre seg på den siden.</p>
<p>Når du redigerer <u>sportsdetalj</u>-siden på alternativfanen, i tekstområdet med tittelen "Smartdata eller logikk som er spesifikke for denne siden:" du kan skrive inn en kode som: <code>{cms_module_hint module=News detailtemplate=sports}</code>. Nå når en bruker klikker på en kobling fra nyhetssammendraget på din "sport" siden vil han bli dirigert til <u>sportsdetalj</u>-siden og detaljmalen for nyheter med tittelen "sport" vil bli brukt til å vise artikkelen.</p>
<h3>Bruk:</h3>
<p><code>{cms_module_hint module=ModuleName paramname=value ...}</code></p>
<p><strong>Merk:</strong> Det er mulig å spesifisere flere parameterhint til en enkelt modul i ett kall til denne plugin-modulen.</p>
<p><strong>Merk:</strong> Det er mulig å kalle denne modulen flere ganger for å gi hint til forskjellige moduler.</p>';
$lang['help_function_breadcrumbs'] = '<h3 style="font-weight:bold;color:#f00;">FJERNET - Bruk nå &#123nav_breadcrumbs&#125 or &#123Navigator action=\'breadcrumbs\'&#125</h3>';
$lang['help_function_anchor'] = '<h3>Hva gjør denne?</h3>
	<p>Gjør et skikkelig anker link.</p>
	<h3>Hvordan bruker jeg det?</h3>
	<p>Bare sett inn koden i malen/siden som: <code>{anchor anchor=\'here\' text=\'Scroll Down\'}</code></p>
	<h3>Hvilke parametere tar det?</h3>
	<ul>
	<li><tt>anchor</tt> - Hvor vi knytter til. Delen etter #.</li>
	<li><tt>text</tt> - Teksten som skal vises i lenken.</li>
	<li><tt>class</tt> - Klassen for lenken, hvis noen</li>
	<li><tt>title</tt> - Tittelen som skal vises for linken, hvis noen.</li>
	<li><tt>tabindex</tt> - Den numeriske tabindex for lenken, hvis noen.</li>
	<li><tt>accesskey</tt> - Accesskey for linken, hvis noen.</li>
	<li><em>(optional)</em> <tt>onlyhref</tt> - Vis bare href og ikke hele lenken. Ingen andre alternativer vil fungere</li>
	<li><em>(optional)</em> <tt>assign</tt> - Tilordne resultatene til den navngitte smarty-variabelen.</li>
	</ul>';
$lang['help_function_site_mapper'] = '<h3>Hva gjør denne?</h3>
  <p>Dette er egentlig bare en wrapper-tag for menyen Manager-modulen for å gjøre taggens syntaks enklere, og for å forenkle opprettelsen av et nettstedkart.</p>
<h3>Hvordan bruker jeg det?</h3>
  <p>Bare Putt <code>{site_mapper}</code> på en side eller i en mal. For hjelp om menymanagermodulen, hvilke parametere det krever etc., vennligst se menystyringsmodulhjelpen.</p>
  <p>Som standard, hvis ikke noe malalternativ er angitt, vil filen minimal_menu.tpl bli brukt.</p>
  <p>Eventuelle parametrene som brukes i kode er tilgjengelige i menumanager malen som <code>{$menuparams.paramname}</code></p>';
$lang['help_function_redirect_url'] = '<h3>Hva gjør denne?</h3>
  <p>Dette programtillegget kan du enkelt omdirigere til en spesifisert url. Det er praktisk innsiden av Smarty betinget logikk (for eksempel viderekoble til en splash-side hvis området ikke er lever ennå).</p>
<h3>vordan bruker jeg det?</h3>
<p>Bare å sette denne Tagen inn i siden eller malen: <code>{redirect_url to=\'http://www.cmsmadesimple.org\'}</code></p>';
$lang['help_function_redirect_page'] = '<h3>Hva gjør denne?</h3>
 <p>Dette programtillegget kan du enkelt omdirigere til en annen side. Det er praktisk innsiden av Smarty betinget logikk (for eksempel viderekoble til en innloggingsside hvis brukeren ikke er logget inn.)</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Bare å sette denne Tagen inn i siden eller malen:<code>{redirect_page page=\'some-page-alias\'}</code></p>';
$lang['help_function_cms_jquery'] = '<h3>Hva gjør denne?</h3>
 <p>Denne plugin gjør at du kan utføre JavaScript-bibliotekene og pluginene som brukes fra administrasjonen</p>
<h3>Hvordan bruker jeg det?</h3>
<p>Bare sett inn denne taggen på siden din eller din mal: <code>{cms_jquery}</code></p>

<h3>Eksempel</h3>
<pre><code>{cms_jquery cdn=\'true\' exclude=\'jquery-ui\' append=\'uploads/NCleanBlue/js/ie6fix.js\' include_css=0}</code></pre>
<h4><em>Utviser</em></h4>
<pre><code><script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.7.2/jquery.min.js"></script>
<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.21/jquery-ui.min.js"></script>
<script type="text/javascript" src="http://localhost/1.10.x/lib/jquery/js/jquery.json-2.3.js"></script>
<script type="text/javascript" src="uploads/NCleanBlue/js/ie6fix.js"></script>
</code></pre>

<h3>>Kjente skript:</h3>
<ul>
	<li><tt>jQuery</tt></li>
	<li><tt>jQuery-UI</tt></li>
	<li><tt>nestedSortable</tt></li>
	<li><tt>json</tt></li>
	<li><tt>migrere</tt></li>
</ul>

<h3>Hvilke parametere tar det?</h3>
<ul>
	<li><em>(optional) </em><tt>utelukk</tt> - bruk av kommaseparert verdi (CSV) liste over skript du vil utelukke. <code>\'jquery-ui,migrate\'</code></li>
	<li><em>(optional) </em><tt>føye</tt> - bruk av kommaseparert verdi (CSV) liste over skriptbaner du vil legge til. <code>\'/uploads/jquery.ui.nestedSortable.js,http://code.jquery.com/jquery-1.7.1.min.js\'</code></li>
	<li><em>(optional) </em><tt>cdn</tt> - cdn=\'true\' vil sette inn jQuery og jQueryUI-rammer ved hjelp av Googles Content Delivery Netwok. Standard er false.</li>
	<li><em>(optional) </em><tt>ssl</tt> - Bruk ssl_url som grunnvei.</li>
	<li><em>(optional) </em><tt>custom_root</tt> - bruk for å angi hvilken grunnvei som ønskes.<code>custom_root=\'https://test.domain.com/\'</code> <br/>MERK: overskriver ssl-alternativet og fungerer med cdn-alternativet</li>
	<li><em>(optional) </em><tt>include_css <em>(boolean)</em></tt> - bruk for å forhindre css fra å bli inkludert i utgangen. Standardverdien er sann.</li>
	<li><em>(optional)</em> <tt>assign</tt> - Tilordne resultatene til den navngitte smarty-variabelen.</li>
	</ul>';
$lang['help_function_cms_filepicker'] = '<h3>Hva gjør denne?</h3>
<p>Dette pluginet vil opprette et inndatafelt som styres av <em>(current)</em> filvelgermodul for å tillate valg av fil. Dette er et kun plugin-program som er nyttig for modulmaler og andre admin-skjemaer.</p>
<p>Dette pluginet skal brukes i en moduls administratormal, og utdata opprettet ved å velge en fil skal håndteres på vanlig måte i php-filen for modulhandlinger.</p>
<p>Merk: Dette pluginet vil oppdage (ved bruk av interne mekanismer) den for tiden foretrukne filepicker-modulen, som kan være forskjellig fra CMSMS-kjernefilvelgermodulen, og den filepicker-modulen kan ignorere noen av disse parametrene.</p>
<h3>Bruk:</h3>
<ul>
  <li>name - <strong>kreves</strong> streng - Navnet på inndatafeltet.</li>
  <li>prefix - <em>(valgfri)</em> string - Et prefiks for navnet på inndatafeltet.</li>
  <li>value - <em>(valgfri)</em> string - Gjeldende verdi for inndatafeltet..</li>
  <li>profile - <em>(valgfri)</em> streng - Navnet på profilen som skal brukes. Profilen må finnes i den valgte filvelgermodulen, ellers kan en standardprofil brukes.</li>
  <li>topp - <em>(valgfri)</em> streng - En toppkatalog i forhold til opplastningskatalogen. Dette bør overstyre enhver toppverdi som allerede er spesifisert i profilen.</li>
  <li>type - <em>(valgfri)</em> string - En indikasjon på filtypen som kan velges.
      <p>Mulige verdier er: bilde,lyd,video,media,xml,dokument,arkiv,hvilken som helst</p>
  </li>
  <li>kreves - <em>(valgfri)</em> boolean - Angir om inntastingsfeltet er obligatorisk eller ikke.</li>
</ul>
<h3>Eksempel:</h3>
<p>Opprett et filepicker-felt for å tillate valg av bilder i bilder / eplekatalogen.</p>
<pre><code>{cms_filepicker prefix=$actionid name=article_image top=\'images/apples\' type=\'image\'}</code></pre>';
$lang['help_function_thumbnail_url'] = '<h3>Hva gjør denne?</h3>
<p>Denne taggen genererer en URL til en fil i opplastingsbanen til CMSMS-installasjonen.</p>
<p>Denne taggen returnerer en tom streng hvis filen som er oppgitt, ikke eksisterer, eller det er tillatelse problemer.</p>
<h3>Bruk:</h3>
<ul>
  <li>file - <strong>nødvendig</strong> - Filnavnet og banen i forhold til opplastingsmappen.</li>
  <li>dir - <em>(valgfri)</em> - En valgfri katalog prefiks til foran til filnavnet.</li>
  <li>assign - <em>(valgfri)</em> - Tilordne eventuelt utgangen til den navngitte smarty-variabelen.</li>
</ul>
<h3>Eksempel:</h3>
<pre><code><a href="{file_url file=\'images/noen-ting.jpg\'}">view file</a></code></pre>
<h3>Tips:</h3>
<p>Det er en triviell prosess å lage en generisk mal eller smarty-funksjon som vil bruke <code>{file_url}</code> og <code>{thumbnail_url}</code> plugins for å generere et miniatyrbilde og lenke til et større bilde.</p>';
$lang['help_function_file_url'] = '<h3>Hva gjør denne?</h3>
<p>Denne taggen genererer en URL til en fil i opplastingsbanen til CMSMS-installasjonen.</p>
<p>Denne taggen returnerer en tom streng hvis filen som er oppgitt ikke eksisterer eller det er tillatelser propblems.</p>
<h3>Bruk:</h3>
<ul>
  <li>file - <strong>nødvendig</strong> - Filnavnet og banen i forhold til opplastingsmappen.</li>
  <li>dir - <em>(valgfri)</em> - Et valgfritt katalog prefiks for å prepend til filnavnet.</li>
  <li>assign - <em>(valgfri)</em> - Eventuelt tildele utgangen til den navngitte smarty variabel.</li>
</ul>
<h3>Eksempel:</h3>
<pre><code><a href="{file_url file=\'images/noe.jpg\'}">view file</a></code></pre>
<h3>Tip:</h3>
<p>Det er en triviell prosess å lage en generisk mal eller smarty-funksjon som vil bruke <code>{file_url}</code> og <code>{thumbnail_url}</code> plugins for å generere et miniatyrbilde og lenke til et større bilde.</p>';
$lang['help_function_form_end'] = '<h3>Hva gjør denne?</h3>
<p>Denne tagen skaper en slutt form tag.</p>
<h3>Hvilke parametere tar det?</p>
<ul>
  <li>tildel - <em>(optional)</em> - Tildel resultatene av denne koden til den navngitte smarty variabel.</li>
</ul>
<h3>Bruk:</h3>
<pre><code>{form_end}</code></pre>
<h3>Se Også:</h3>
<p>Se {form_start} tag som er supplement til denne koden.</p>';
$lang['help_function_form_start'] = '<h3>Hva gjør dette?</h3>
   <p>Thie-taggen oppretter et <skjema> tag for en modulhandling. Det er nyttig i modulmaler og er en del av separasjonen mellom design og logikk som er kjernen i CMSMS.</p>
   <p>Denne taggen godtar en rekke parametere som kan akseptere <skjemaet> merke, og påvirke stilen.</p>
<h3>Hvilke parametere krever det?</h3>
<ul>
   <li>modul - <em>(valgfri streng)</em>
     <p>Modulen som er destinasjonen for skjemadataene. Hvis denne parameteren ikke er spesifisert, blir det gjort et forsøk på å bestemme gjeldende modul.<p>
   </li>
   <li>handling - <em>(valgfri streng)</em>
     <p>Modulhandlingen som er målet for skjemadataene. Hvis det ikke er spesifisert, "standard" antas for en grensesnittforespørsel, og "defaultadmin" for en forespørsel fra administratorsiden.</p>
   </li>
   <li>midt = <em>(valgfri streng)</em>
     <p>Modulens handlings-ID som er destinasjonen for skjemadataene. Hvis det ikke er spesifisert, beregnes en verdi automatisk.</p>
   </li>
   <li>returnid = <em>(valgfritt heltall)</em>
     <p>Innholdsside-ID-en som skjemaet skal sendes til. Hvis det ikke er spesifisert, brukes gjeldende side-ID for frontend-forespørsler. For administratorforespørsler er ikke dette attributtet påkrevd.</p>
   </li>
   <li>inline = <em>(valgfritt heltall)</em>
     <p>En boolsk verdi som indikerer at skjemaet skal sendes inline (skjemabehandlingsutdata erstatter den opprinnelige taggen) eller ikke (skjemabehandlingsutdata erstatter {content}-taggen). Denne parameteren gjelder kun for frontend-forespørsler, og er som standard usann for frontend-forespørsler.</p>
   </li>
   <li>metode = <em>(valgfri streng)</em>
     <p>Mulige verdier for dette feltet er GET og POST. Standardverdien er POST.</p>
   </li>
   <li>url = <em>(valgfri streng)</em>
     <p>Gjør det mulig å spesifisere handlingsattributtet for form-taggen. Dette er nyttig for å bygge skjemaer som ikke er bestemt til en modulhandling. En fullstendig URL kreves.</p>
   </li>
   <li>enctype = <em>(valgfri streng)</em>
     <p>Gjør det mulig å spesifisere kodingstypen for skjemakoden. Standardverdien for dette feltet er multipart/form-data.</p>
   </li>
   <li>id = <em>(valgfri streng)</em>
     <p>Gjør det mulig å spesifisere id-attributtet for form-taggen.</p>
   </li>
   <li>klasse = <em>(valgfri streng)</em>
     <p>Gjør det mulig å spesifisere klasseattributtet for form-taggen.</p>
   </li>
   <li>extraparms = <em>(valgfri assosiativ array)</em>
     <p>Gjør det mulig å spesifisere en assosiativ (nøkkel/verdi)-matrise med ekstra parametere for form-taggen.
   </li>
   <li>tilordne = <em>(valgfri streng)</em>
     <p>Tildel utdataene fra taggen til den navngitte smarty-variabelen.</p>
   </li>
</ul>
<p>Du kan også oppgi ekstra attributter til <skjemaet> tag ved å sette prefikset "form-" foran attributtet. dvs.:</p>
<pre><code>{form_start form-data-foo="bar" form-novalidate=""}</code></pre>
<p><strong>Merk:</strong> Smarte stenografiattributter er ikke tillatt. Hvert oppgitt attributt må ha en verdi, selv om det er tomt.</p>
<h3>Bruk:</h3>
<p>I en modulmal vil følgende kode generere en skjemakode for gjeldende handling.</p>
<pre><code>{form_start}</code></pre>
<p>Denne koden i en modulmal vil generere en skjemakode til den navngitte handlingen.</p>
<pre><code>{form_start action=myaction}</code></pre>
<p>Denne koden vil generere en skjemakode til den navngitte handlingen i den navngitte modulen.</p>
<pre><code>{form_start module=Nyheter action=default}</code></pre>
<p>Denne koden vil generere en skjemakode for samme handling, men angi en id og klasse.</p>
<pre><code>{form_start id="myform" class="form-inline"}</code></pre>
<p>Denne koden vil generere en skjemakode til den navngitte nettadressen, og angi en id og klasse.</p>
<pre><code>{form_start url="/products" class="form-inline"}</code></pre>
<h3>Se også:</h3>
<p>Se {form_end}-taggen som utfyller denne taggen.</p>
<h3>Eksempel 1:</h3>
<p>Det følgende er et eksempelskjema for bruk i en modul. Dette hypotetiske skjemaet vil underkastes handlingen som genererte skjemaet, og lar brukeren spesifisere en heltallssidegrense.</p>
<pre><code>{form_start}
<select name="{$actionid}sidegrense">
<option value="10">10</option>
<option value="25">25</option>
<option value="50">50</option>
<velg>
<input type="submit" name="{$actionid}submit" value="Send inn"/>
{form_end}</code></pre>
<h3>Eksempel 2:</h3>
<p>Det følgende er et eksempelskjema for bruk i frontend av et nettsted. Når det legges inn i sideinnhold, vil dette hypotetiske skjemaet samle en sidegrense og sende den til Nyhetsmodulen.</p>
<pre><code>{form_start method="GET" class="form-inline"}
<velg name="pagelimit">
<option value="10">10</option>
<option value="25">25</option>
<option value="50">50</option>
<velg>
<input type="submit" name="submit" value="Send inn"/>
{form_end}
{$pagelimit=25}
{if isset($smarty.get.pagelimit)}{$pagelimit=$smarty.get.pagelimit}{/if}
{News pagelimit=$pagelimit}</code></pre>';
$lang['function'] = 'Funksjoner kan utføre en oppgave, eller søke i databasen, og vanligvis vise utdata. De kan bli kalt ut {tagname [attribute=value...]}';
$lang['modifier'] = 'Modifiers ta resultatet av en smarty variabel og endre den. De kalles ut: {$variable|modifier[:arg:...]}';
$lang['postfilter'] = 'Postfiltere kalles automatisk av Smarty etter utarbeidelsen av hver mal. De kan ikke kalles manuelt.';
$lang['prefilter'] = 'Pre-Filter kalles automatisk av Smarty før utarbeidelsen av hver mal. De kan ikke kalles manuelt.';
$lang['tag_about'] = 'Vis historie og forfatterinformasjon for denne plugin, er tilgjengelig';
$lang['tag_adminplugin'] = 'Indikerer at koden er tilgjengelig i admin-grensesnittet, og blir vanligvis brukt i modulmaler';
$lang['tag_cachable'] = 'Angir om produksjonen av plugin kan bli lagret (når Smarty mellomlagring er aktivert). Admin plugins, og modifikatorer kan ikke bli lagret.';
$lang['tag_help'] = 'Vise hjelp (hvis noen finnes) for denne koden';
$lang['tag_name'] = 'Dette er navnet på koden';
$lang['tag_type'] = 'Tagtypen (funksjon, modifiseringsmiddel, eller en pre eller post-filter)';
$lang['title_admin'] = 'Dette programtillegget er kun tilgjengelig fra CMSMS administrasjonskonsoll..';
$lang['title_notadmin'] = 'Dette programtillegget kan brukes i både administrasjonskonsollen og på nettsidens frontend.';
$lang['title_cachable'] = 'Denne programtillegget kan bufres';
$lang['title_notcachable'] = 'Dette programtillegget kan ikke bufres';
$lang['viewabout'] = 'Vis historie og forfatterinformasjon for denne modulen';
$lang['viewhelp'] = 'Vis hjelp for denne modulen';
?>