<?php
$lang['help_group_permissions'] = '<h4>Berechtigungsmodell für Administrationsbenutzer</h4>
<p>CMS Made Simple (CMSMS) verwendet ein System von namentlichen Berechtigungen. Diese Berechtigungen bestimmen die Fähigkeit eines Benutzers, verschiedene Funktionen im Administrationsbereich von CMSMS auszuführen. Die Grundversion von CMSMS erstellt mehrere Berechtigungen während der Installation – gelegentlich werden während einer Aktualisierung Berechtigungen hinzugefügt oder gelöscht. Module von Drittanbietern können zusätzliche Berechtigungen erstellen.</p>
<p>Berechtigungen werden Benutzergruppen zugeordnet. Ein autorisierter Benutzer kann die Berechtigungen, die bestimmten Mitgliedergruppen zugeordnet sind, anpassen. Die Benutzergruppe „Admin“ ist eine spezielle Gruppe; Mitglieder dieser Gruppe haben automatisch alle Berechtigungen. Admin-Benutzerkonten können Mitglieder von null oder mehr Gruppen sein.</p>
<p>Es kann für ein Benutzerkonto, das nicht ein Mitglied einer Gruppe ist, dennoch möglich sein, verschiedene Funktionen auszuführen; mehr Informationen über Eigentumsrechte und zusätzliche Redakteure gibt es in der Dokumentation von Inhaltsverwaltung und Designverwaltung. Das erste Benutzerkonto <em> (uid=1)</em>, welches in der Regel mit den Namen „Admin“ trägt, ist ein spezielles Benutzerkonto und hat alle Berechtigungen.</p>';
$lang['help_cmscontentmanager_help'] = '<h3>Einführung</h3>
<p>Dieses Dokument beschreibt das Modul „CMS Content Manager“. Es richtet sich in erster Linie an den Website-Designer oder -Entwickler und beschreibt in groben Zügen, wie Inhaltselemente in CMS Made Simple funktionieren.</p>
<p>Die Hauptschnittstelle des Inhaltsverwaltungsmoduls ist die Inhaltsliste. Sie zeigt Inhalte in tabellarischer Form an und bietet die Möglichkeit, mehrere Inhaltselemente schnell zu suchen, zu navigieren und zu verwalten. Dies ist eine dynamische Liste. Die Anzeige wird abhängig von der Webseitenkonfiguration, einigen globalen Einstellungen, Benutzerberechtigungen und den einzelnen Inhaltselementen angepasst. Der folgende Text beschreibt, was Inhaltselemente sind und wie sich die Inhaltsliste mit ihnen verhält.</p>
<h3>Inhaltshierarchie und -navigation</h3>
<p>CMS Made Simple erstellt Frontend-Navigationen dynamisch aus der Inhaltsliste, den einzelnen Arten von Inhaltselementen, dem Inhalt dieser Inhaltselemente und der Navigationsvorlage. Die Organisation der Navigation wird in erster Linie durch die Eltern-Kind- bzw. Hierarchiebeziehung Ihrer Inhaltselemente gesteuert. Beginnend von der obersten <em>(root)</em> Ebene, abwärts.</p>
<p>Das Hinzufügen eines neuen Elements zum Navigationsmenü ist so einfach wie das Erstellen eines neuen Inhaltselements, das Platzieren an der gewünschten Stelle in der Hierarchie und <em>– abhängig vom Typ des Inhaltselements – </em> das Festlegen unterschiedlicher Eigenschaften, die dieser Inhaltselementtyp bereitstellt.</p>
<h3>Arten von Inhaltselementen</h3>
<p>CMS Made Simple wird mit mehreren verschiedenen Arten von Inhaltselementen vertrieben <em>(und mehr sind über Zusatzmodule von Drittanbietern verfügbar)</em>. Diese Inhaltselementtypen dienen unterschiedlichen Zwecken, wenn eine Navigation generiert wird. Einige enthalten keinen Inhalt, sondern werden nur zum Verwalten von Navigationen verwendet. Beispielsweise hat der Inhaltselementtyp „Trennzeichen“ keinen eigenen Inhalt und dient lediglich dazu, Inhaltselemente zu organisieren und ein sichtbares Trennzeichen in der generierten Navigation bereitzustellen.</p>
  <p>Nachstehend finden Sie eine kurze Beschreibung jedes Inhaltselementtyps, der mit CMS Made Simple verteilt wird</p>
<dl>
	<dt>Inhaltsseite</dt>
	<dd
		<p>Dieser Inhaltselementtyp ist einer HTML-Seite am ähnlichsten und wird normalerweise für diesen Zweck verwendet. Wenn Redakteure Inhaltsseitenelemente erstellen, wählen sie ein Design und eine Vorlage aus, die das Erscheinungsbild der Seite steuern, legen einen Titel fest und geben den Inhalt für die Seite ein.</p>
		<p>Inhaltselemente können auch Formulare, Logik, dynamische Daten von Modulen oder benutzerdefinierte Tags (UDTs) enthalten. Diese Flexibilität ermöglicht die Erstellung spezialisierter Anwendungen oder extrem flexibler und dynamischer Websites.</p>
	</dd>
	<dt>Link</dt>
	<dd>
		<p>Dieser Inhaltselementtyp wird in Navigationen verwendet, um einen Link zu einer Seite auf einer externen Website zu generieren.</p>
	</dd>
	<dt>Seitenlink</dt>
	<dd>
	<p>Dieser Inhaltselementtyp wird auch in Navigationen verwendet. Er generiert einen sekundären Link zu einer bestehenden Inhaltsseite. Dieser Inhaltselementtyp kann verwendet werden, wenn auf ein Inhaltselement von mehreren Stellen in der Navigation aus zugegriffen werden kann.</p>
	</dd>
	<dt>Trennzeichen</dt>
	<dd>
	<p>Dieser Inhaltselementtyp wird auch in Navigationen verwendet. Er wird normalerweise verwendet, um eine visuelle Trennlinie zwischen Navigationselementen zu erstellen. Einige Arten von Navigationen <em>(bestimmt durch die Navigationsvorlage)</em> zeigen möglicherweise überhaupt keine Trennzeichen an.</p>
	</dd>
	<dt>Abschnittsüberschrift</dt>
	<dd>
		<p>Die Abschnittsüberschrift wird auch nur in Navigationen angezeigt. Sie wird verwendet, um Inhaltselemente zu organisieren und bietet eine Textüberschrift über oder zwischen anderen Inhaltselementen. Abschnittsüberschriften haben keine URLs und können normalerweise nicht angeklickt werden. Einige Navigationsvorlagen können Abschnittsüberschriften anders gestalten als andere Inhaltselemente.</p>
	</dd>
	<dt>Fehlerseite</dt>
	<dd>
		<p>Die Fehlerseite ist eine spezielle Art von Inhalt. Sie wird verwendet, wenn ein Benutzer versucht, zu einem Inhalt zu navigieren, der entweder nicht navigierbar ist oder nicht existiert.</p>
	</dd>
</dl>
<p>Viele Module von Drittanbietern bieten mehr Inhaltstypen für unterschiedliche Zwecke. Beispielsweise das Anzeigen von Produktkatalogen oder das Beschränken des Inhalts auf autorisierte Benutzer.</p>
<h3>Die Liste der Inhaltselemente</h3>
<p>Die Inhaltsliste ist die primäre Schnittstelle zum Modul. Dieses Formular stellt die Hauptverwaltungsoberfläche für Ihre Inhalte bereit. Von hier aus können Sie Ihre Inhaltselemente erstellen, bearbeiten, löschen, kopieren, deaktivieren und organisieren. Dieser Bildschirm ist stark für größere Websites optimiert und bietet Seiten- und Suchmechanismen, um jeweils nur eine kleine Anzahl von Inhalten anzuzeigen, aber schnell Elemente zu finden.</p>
<h4>Spalten</h4>
<p>Jedes Inhaltselement wird als Zeile in einer Tabelle angezeigt. Es gibt eine Reihe von Spalten, um schnell verschiedene Attribute jedes Inhaltselements anzuzeigen, sowie einige praktische Aktionssymbole. Abhängig von einer Reihe von Faktoren können einige Spalten vollständig oder nur für einige Zeilen ausgeblendet werden:</p>
<ul>
	<dt>Ihre Zugriffsberechtigungen und Ihr Seiteneigentum</dt>
	<dd>
		<p>Wenn Ihr Konto auf bestimmte Berechtigungen beschränkt ist, werden einige Spalten möglicherweise nicht angezeigt oder sind deaktiviert.</p>
	</dd>
	<dt>Systemeinstellungen und Webseitenkonfiguration</dt>
	<dd>
		<p>Einige Systemeinstellungen und Konfigurationsoptionen führen dazu, dass einige Spalten deaktiviert werden, z. B. die Spalte „URL“</p>
	</dd>
	<dt>Der Inhaltstyp</dt>
	<dd>
		<p>Je nach Art des Inhaltselements können bestimmte Spalten irrelevant werden. Beispielsweise ist es nicht möglich „Abschnittsüberschriften“ oder „Trennzeichen“ als Standardseite zu setzen; dementsprechend wird in der Spalte „Standard“ für diese Inhaltselemente nichts angezeigt.</p>
	</dd>
	<dt>Ob das Inhaltselement bearbeitet wird</dt>
	<dd>
		<p>Wenn andere Benutzer <em>(oder sogar Sie selbst) einen Inhalt bearbeiten, werden einige Spalten in der Zeile für jeden Inhaltstyp ausgeblendet, um zu verhindern, dass die Inhaltsseite geändert, gelöscht oder kopiert wird.</p>
	</dd>
</ul>
<h5>Spaltenliste</h5>
       <p>Das Inhaltsverwaltungsmodul bietet einen flexiblen Mechanismus zum Ausblenden und Anzeigen verschiedener Spalten in der Inhaltsliste. Darüber hinaus können einige Spalten basierend auf der Webseitenkonfiguration ausgeblendet sein. Beispielsweise wird die URL-Spalte ausgeblendet, wenn suchmaschinenfreundliche URLs nicht konfiguriert sind.</p>
       <p>Jede Spalte in der Inhaltsliste hat einen besonderen Zweck:</p>
<dl>
	<dt>Spalte erweitern/reduzieren</dt>
	<dd>
		<p>Wenn ein Inhaltselement untergeordnete Elemente hat, wird diese Spalte um ein Symbol ergänzt, das es ermöglicht, die Liste zu erweitern bzw. zu reduzieren, um die untergeordneten Elemente anzuzeigen bzw. auszublenden. Der Status, welche Elemente erweitert und welche reduziert sind, wird pro Benutzer gespeichert. Wenn Sie den Inhaltsmanager erneut aufrufen, bleibt der erweiterte/reduzierte Status Ihrer Seiten unverändert.</p>
	</dd>
	<dt>Hierarchiespalte</dt>
	<dd>
		<p>Die Hierarchiespalte zeigt die Position jedes Inhaltselements in der Hierarchie in numerischer Form an. Die Hierarchie der Seite auf der ersten Stammebene beginnt mit 1 und erhöht sich für jedes weitere Element auf der jeweiligen Ebene. Jedes untergeordnete Element beginnt mit der 1, und Elemente auf der gleichen ebene werden um eins erhöht. Daher hätte das zweite Enkelkind des dritten Kindes des ersten Elements in der Inhaltsliste eine Hierarchie von 1.3.2.</p>
		<p>Der Hierarchiemechanismus ist ein wichtiger Teil, der der Inhaltsverwaltung ermöglicht, Inhaltselemente zu organisieren und daraus dann Navigationen zu erstellen.</p>
	</dd>
	<dt>Seitentitel / Menütextspalte</dt>
	<dd>
		<p>Diese Spalte kann entweder den Seitentitel oder den Seitenmenütext anzeigen. Dies hängt von einer Einstellung unter „Webseiten-Administration » Einstellungen – Inhaltsverwaltung“ ab.</p>
		<p>Diese Spalte enthält einen Link zum Bearbeiten des Inhaltselements <em>(es sei denn, das Inhaltselement ist gesperrt)</em>. Wenn Sie den Mauszeiger über den Text in dieser Spalte bewegen, werden zusätzliche Informationen über das Inhaltselement angezeigt, z. B. die eindeutige numerische Inhalts-ID und ob die Seite zwischengespeichert werden kann oder nicht.</p>
		<p>Wenn das Inhaltselement gesperrt ist, werden durch Bewegen der Maus über den Text in der Spalte Informationen darüber angezeigt, wer das Element gesperrt hat und wann die Sperre abläuft.</p>
	</dd>
	<dt>URL-Spalte</dt>
	<dd>
		<p>Falls aktiviert, zeigt diese Spalte alternative URLs für dieses Inhaltselement an. <em>(Hinweis: Nur bestimmte Inhaltselementtypen unterstützen eine alternative URL).</em></p>
	</dd>
	<dt>Seiten-Alias-Spalte</dt>
	<dd>
		<p>Diese Spalte zeigt den eindeutigen Alias, der jeder Seite zugeordnet ist. Aliase sind Textzeichenfolgen, die das Inhaltselement eindeutig identifizieren. Sie verwenden den Alias ​​für Inhaltselemente (oder die numerische ID), wenn Sie auf eine Seite innerhalb des Systems verweisen müssen.<em>(Hinweis: Einige Inhaltstypen haben keine Aliase).</em></p>
	</dd>
	<dt>Vorlagenspalte</dt>
	<dd>
		<p>Diese Spalte zeigt das Design und die Layoutvorlage an, die verwendet werden, um den Inhalt für das Element anzuzeigen. Weitere Informationen finden Sie in der Hilfe zum Design-Manager-Modul für eine Erläuterung, wie CMSMS Designs verwaltet, einschließlich Stylesheets und Layoutvorlagen. <em>(Hinweis: Einige Inhaltselementtypen verwenden kein Design oder keine Vorlage.)</em></p>
	</dd>
	<dt>Spalte „Typ“</dt>
	<dd>
		<p>Diese Spalte gibt den Inhaltstyp an (z. B. Inhalt, Abschnittsüberschrift, Trennzeichen usw.).<p>
	</dd>
	<dt>Eigentümer-Spalte</dt>
	<dd>
		<p>Die Eigentümerspalte zeigt den Benutzernamen des Eigentümers des Inhaltselements an. Wenn Sie den Mauszeiger über den Text in dieser Spalte bewegen, werden Informationen darüber angezeigt, wann das Inhaltselement erstellt und zuletzt bearbeitet wurde.</p>
	</dd>
	<dt>Spalte „Aktiv“</dt>
	<dd>
		<p>In dieser Spalte werden Symbole angezeigt, die den aktuellen aktiven Status des Inhaltselements anzeigen. Zu aktiven Elementen kann navigiert werden und sie erscheinen in Navigationsmenüs im Frontend. Wenn Ihr Benutzerkonto über ausreichende Berechtigungen für das Inhaltselement verfügt, können Sie auf das Symbol klicken, um seinen aktiven Status umzuschalten.</p>
	</dd>
	<dt>Spalte „Standard“</dt>
	<dd>
		<p>Diese Spalte zeigt an, ob das Inhaltselement die Standardseite ist oder nicht. Das standardmäßige Inhaltselement ist die Startseite Ihrer Website. Nur einige Inhaltstypen lassen zu, dass der Inhaltstyp der Standardwert ist.</p>
		<p>Wenn Ihr Benutzerkonto über ausreichende Berechtigungen verfügt und der Inhaltstyp den Standardinhalt für die Website unterstützt, können Sie auf das Symbol klicken, um den Standard-Status auf eine andere Seite zu ändern.</p>
	</dd>
	<dt>Spalte „Verschieben“</dt>
	<dd>
		<p>Abhängig von Ihren Zugriffsrechten sehen Sie möglicherweise Symbole, mit denen Sie die Reihenfolge der Inhaltselemente in Bezug auf ihre unmittelbaren Nachbarn ändern können. Dies ist ein einfacher Mechanismus zum schnellen Neuordnen von Inhaltselementen unter ihren Nachbarn. Die Option „Seiten neu anordnen“ ermöglicht die massenhafte Neuorganisation von Seiten, und wenn Sie ein Inhaltselement bearbeiten, können Sie das Element schnell einem anderen übergeordneten Element zuweisen.</p>
	</dd>
	<dt>Aktionssymbole</dt>
	<dd>
		<p>Abhängig von Ihren Zugriffsrechten, dem Inhaltstyp und seinem aktuellen Sperrstatus sehen Sie möglicherweise unterschiedliche Symbole in jeder Inhaltszeile, die unterschiedliche Funktionen ermöglichen:</p>
		<dl>
			<dt>Anzeigen</dt>
			<dd>Öffnen Sie ein neues Browserfenster <em>(oder Tab)</em> und sehen Sie sich das Inhaltselement so an, wie es Ihre Besucher sehen werden.</dd>
			<dt>Kopieren</dt>
			<dd>Kopieren Sie das Inhaltselement in ein neues Inhaltselement. Ein neues Inhaltselement wird mit einem neuen Seitentitel und Alias ​​erstellt, und Sie erhalten die Möglichkeit, die neue Seite zu bearbeiten.</dd>
			<dt>Löschen</dt>
			<dd>Inhaltselement löschen.<br>Abhängig von Ihren Zugriffsrechten und davon, ob das Inhaltselement untergeordnete Elemente hat oder nicht, kann die Option zum Löschen des Inhaltselements ausgeblendet oder deaktiviert sein.</dd>
			<dt>Sperre aufheben</dt>
			<dd>
					<p>Für Inhaltselemente, die gerade bearbeitet werden, aber deren Sperre abgelaufen ist <em>(der Bearbeiter hat eine Weile keine Änderung am Formular vorgenommen)</em> können Sie mit dieser Option die Sperre aufheben.</p>
			</dd>
			<dt>Kontrollkästchen Massenvorgänge</dt>
			<dd>
				<p>Das Kontrollkästchen für Massenoperationen ermöglicht die Auswahl mehrerer Inhaltselemente, die massenhaft verarbeitet werden sollen.</p>
			</dd>
		</dl>
	</dd>
</dl>
<h4>„Bearbeiten“-Fähigkeit</h4>
<p>Die Möglichkeit, ein Inhaltselement zu bearbeiten, wird entweder durch die Berechtigung <em>(siehe die Berechtigungen „Alle Inhalte verwalten“ und „Beliebige Seiten ändern“ weiter unten)</em> oder dadurch bestimmt, dass Sie Eigentümer oder zusätzlicher Bearbeiter eines Inhaltselements sind.</p>
<h4>Eigentümer</h4>
<p>Standardmäßig ist der Eigentümer eines Inhaltselements der Benutzer, der es ursprünglich erstellt hat. Inhaber oder Nutzer mit Berechtigung „Alle Inhalte verwalten“ kann einem anderen Benutzer das Eigentum an einer Seite übertragen.</p>
<h4>Zusätzliche Bearbeiter</h4>
<p>Beim Bearbeiten eines Inhaltselements als Eigentümer oder als Benutzer mit Berechtigung „Alle Inhalte verwalten“ kann der Benutzer andere administrative Benutzer oder Admin-Gruppen auswählen, die ebenfalls berechtigt sind, dieses Inhaltselement zu bearbeiten.</p>

<h4>Relevante Berechtigungen</h4>
<p>Es gibt einige Berechtigungen, die beeinflussen, welche Spalten in der Inhaltsliste angezeigt werden, und die Fähigkeit, mit der Inhaltsliste zu interagieren:</p>
<dl>
	<dt>Seiten hinzufügen</dt>
	<dd>
		<p>Diese Berechtigung ermöglicht es Benutzern, neue Inhaltselemente zu erstellen. Darüber hinaus können Benutzer mit dieser Berechtigung Inhaltselemente kopieren, für die sie Bearbeitungsberechtigungen haben.</p>
	</dd>
	<dt>Beliebige Seite ändern</dt>
	<dd>
		<p>Benutzer mit dieser Berechtigung haben die Möglichkeit, jedes Inhaltselement zu bearbeiten. Es ist ähnlich wie ein „zusätzlicher Bearbeiter“ bei allen Inhaltselementen.</p>
	</dd>
	<dt>Seiten entfernen</dt>
	<dd>
		<p>Diese Berechtigung ermöglicht es Benutzern, Inhaltselemente zu entfernen, für die sie Bearbeitungsberechtigungen haben. Ohne diese Berechtigung wird das Löschsymbol in jeder Zeile mit Inhaltselementen in der Inhaltsliste ausgeblendet.</p>
	</dd>
	<dt>Seiten neu anordnen</dt>
	<dd>
		<p>Diese Berechtigung ermöglicht es Benutzern, die die Möglichkeit haben, alle gleichgeordneten Elemente eines Inhaltselements zu bearbeiten, um Inhaltselemente unter ihren Nachbarn neu anzuordnen.</p>
		<p>Beispiel: Ein Benutzer in einer Gruppe, der die Bearbeitungsberechtigung für das Inhaltselement mit der Hierarchie 1.3 hat, und alle Elemente auf der gleichen Ebene <em>(1.1, 1.2, 1.3, 1.4 usw.)</em>, können diese Elemente in der Navigation neu anordnen. Benutzer ohne diese Berechtigung sehen die Aufwärts-/Abwärtsbewegungssymbole im Listeninhalt nicht.</p>
	</dd>
	<dt>Alle Inhalte verwalten</dt>
	<dd>
		<p>Diese Berechtigung bietet Superuser-Fähigkeit für alle Inhaltselemente. Benutzer mit dieser Berechtigung können Inhaltselemente hinzufügen, bearbeiten, löschen und neu anordnen. Sie haben auch die Möglichkeit, das Standard-Inhaltselement festzulegen und Massenaktionen durchzuführen, wie z. B. den Besitz zu ändern, die Benutzern mit anderen Berechtigungen möglicherweise zur Verfügung stehen oder nicht.</p>
	</dd>
</dl>
<p>Es ist möglich, dass ein Admin-Benutzerkonto kein Mitglied irgendeiner Gruppe ist, und für dieses Admin-Benutzerkonto dennoch die Möglichkeit hat, <em>(als Eigentümer oder zusätzlicher Bearbeiter)</em> einige Inhaltselemente zu bearbeiten .</p>

<h4>Bearbeitungssperre</h4>
<p>Das Sperren von Inhalten ist ein Mechanismus, der verhindert, dass zwei Bearbeiter gleichzeitig dasselbe Element bearbeiten und somit die Arbeit des anderen zerstören. Admin-Benutzer erhalten exklusiven Zugriff auf ein Inhaltselement, bis sie die Änderungen speichern.</p>
<p>Wenn ein Inhaltselement gesperrt ist, können Sie es nicht bearbeiten, bis die Sperre abgelaufen ist. Informationen zum Ablauf der Sperre finden Sie weiter unten. Sobald eine Sperre abgelaufen ist, hat ein Benutzer die Möglichkeit, die Sperre des ursprünglichen Bearbeiters aufzuheben und eine neue Bearbeitungssitzung zu beginnen.</p>
<p>Ein spezielles Symbol wird in der Zeile des Inhaltselements angezeigt, um anzuzeigen, dass die Sperre aufgehoben werden kann.</p>

<h4>Konfiguration</h4>
<p>Einige Konfigurationselemente beeinflussen die Sichtbarkeit bestimmter Elemente in der Inhaltsliste:</p>

<h4>Weitere Funktionen</h4>
<dl>
	<dt>Seitennummerierung</dt>
	<dd>
		<p>Die Inhaltsliste kann auf mehrere Seiten aufgeteilt werden. Dies ist ein Leistungsmerkmal für große Websites mit vielen Inhaltselementen. Die Standardbegrenzung beträgt 500 Elemente; diese Begrenzung kann jedoch durch Anpassen des Werts im Optionsdialog gesenkt werden.</p>
	</dd>
	<dt>Alle erweitern/reduzieren</dt>
	<dd>
		<p>Diese Optionen ermöglichen das Erweitern oder Zusammenklappen aller Inhaltselemente mit untergeordneten Elementen, sodass die untergeordneten sichtbar bzw. nicht sichtbar sind. Es ist nützlich, um ein Inhaltselement einfach zu finden oder um sich einen Überblick über die Website-Struktur zu verschaffen. Jedes Inhaltselement mit untergeordneten Elementen kann weiterhin einzeln erweitert oder reduziert werden.</p>
	</dd>
	<dt>Suchen</dt>
	<dd>
		<p>Das „Suchen“-Feld in der oberen linken Ecke der Inhaltsliste ermöglicht es Benutzern, ein Inhaltselement schnell und einfach anhand seines Titels oder Menütexts zu finden. Dieses Formular verwendet AJAX und automatische Vervollständigung, um eine Auswahlliste aller Elemente anzuzeigen, die mit der eingegebenen Zeichenfolge übereinstimmen (mindestens drei Zeichen sind erforderlich).</p>
	</dd>
	<dt>Massenaktionen</dt>
	<dd>
		<p>Die Auswahl „Mit ausgewählten“ unten rechts in der Inhaltsliste ermöglicht es Benutzern mit entsprechendem Zugriff, Inhaltselemente en masse zu ändern oder mit ihnen zu interagieren. Es stehen zahlreiche Optionen zur Verfügung (abhängig sowohl von den ausgewählten Elementen als auch von der Zugriffsberechtigung des Benutzers):</p>
		<dl>
			<dt>Löschen</dt>
			<dd>
				<p>Diese Option ermöglicht das Löschen mehrerer Inhaltselemente (und ihrer untergeordneten Elemente) in wenigen Schritten. Alle ausgewählten Inhaltselemente und ihre Nachkommen werden auf ihre Berechtigung zum Löschen analysiert. Benutzer werden dann aufgefordert, eine Liste der Inhaltselemente anzuzeigen, die die Analyse bestanden haben <em>(falls vorhanden)</em> und die Aktion zu bestätigen.</p>
				<p>Nur Benutzer mit der Berechtigung zum Entfernen von Seiten und Ändern von Seiten oder zum Verwalten aller Inhalte können diese Option verwenden.</p>
				<p><strong>Hinweis:</strong> Wenn Sie viele Inhaltselemente oder Inhaltselemente mit vielen Nachkommen auswählen, kann dies ein sehr speicher-, datenbank- und zeitintensiver Vorgang sein.</p>
			</dd>
			<dt>Aktivieren</dt>
			<dd>
				<p>Diese Option stellt sicher, dass die ausgewählten Inhaltselemente als „aktiv“ markiert werden. Benutzer werden aufgefordert, den Vorgang zu bestätigen. Dieser Vorgang funktioniert nicht auf untergeordneten Seiten der ausgewählten Seiten.</p>
				<p>Nur Benutzer mit der Option „Alle Inhalte verwalten“ Berechtigung können diese Option verwenden.</p>
			</dd>
			<dt>Deaktivieren</dt>
			<dd>
				<p>Diese Option analysiert die ausgewählten Elemente auf Eignung und setzt alle zulässigen Inhaltselemente auf inaktiv. Inaktive Seiten können nicht aufgerufen werden und können eine funktionierende Website beeinträchtigen. Die Standardseite kann nicht auf inaktiv gesetzt werden.</p>
				<p>Nur Benutzer mit der Berechtigung „Alle Inhalte verwalten“ können diese Option verwenden.</p>
			</dd>
			<dt>Zwischenspeicherbar machen</dt>
			<dd>
				<p>Diese Option setzt die ausgewählten Inhaltselemente auf „zwischenspeicherbar“. Dies kann je nach Standortkonfiguration unterschiedliche Auswirkungen haben:<p>
				<p>Wenn es in „Webseiten-Administration » Globale Einstellungen“ aktiviert ist, dann können als „zwischenspeicherbar“ markierte Inhaltselemente vom Browser zwischengespeichert werden <em>(dies reduziert die Belastung Ihres Webservers für Benutzer, die häufig dieselbe Seite besuchen).</em>
				<p>Auch „Smarty-Caching“ unter „Webseiten-Administration » Globale Einstellungen“ bewirkt zwischenspeicherbare Seiten. Dies ist ein fortschrittliches Hilfsmittel, das den generierten HTML-Code zur wiederholten Verwendung zwischenspeichert und die Serverlast drastisch reduzieren und die Leistung verbessern kann. Dies ist jedoch ein fortgeschrittenes Thema und kann die dynamische Natur einiger Inhaltselemente negativ beeinflussen.</p>
				<p>Nur Benutzer mit der Berechtigung „Alle Inhalte verwalten“ können diese Option verwenden.</p>
			</dd>
			<dt>Als nicht zwischenspeicherbar festlegen</dt>
			<dd>
				<p>Diese Option stellt sicher, dass die ausgewählten Inhaltselemente nicht zwischengespeichert werden können.<p>
			</dd>
			<dt>Im Menü anzeigen</dt>
			<dd>
				<p>Diese Option stellt sicher, dass die ausgewählten Inhaltselemente in Frontend-Navigationsmenüs sichtbar sind.</p>
				<p>Nur Benutzer mit der Berechtigung „Alle Inhalte verwalten“ können diese Option verwenden.</p>
			</dd>
			<dt>Aus Menü ausblenden</dt>
			<dd>
				<p>Diese Option stellt sicher, dass die ausgewählten Inhaltselemente (standardmäßig) nicht in Frontend-Navigationsmenüs sichtbar sind. Verschiedene Navigationserzeugungsmodule können die Einstellung „Im Menü anzeigen“ übergehen.</p>
				<p>Nur Benutzer mit der Berechtigung „Alle Inhalte verwalten“ können diese Option verwenden.</p>
			</dd>
			<dt>Sichere Verbindung festlegen (HTTPS)</dt>
			<dd>
				<p>Diese Option stellt sicher, dass HTTPS verwendet wird, wenn die ausgewählten Inhaltselemente angezeigt werden.</p>
				<p><strong>Hinweis:</strong> Möglicherweise müssen Sie die sicheren URL-Einstellungen in der Datei config.php anpassen und sich bezüglich der richtigen SSL-Konfiguration an Ihren Host wenden.</p>
				<p>Nur Benutzer mit der Berechtigung „Alle Inhalte verwalten“ können diese Option verwenden.</p>
			</dd>
			<dt>Unsicher Verbindung festlegen (HTTP)</dt>
			<dd>
				<p>Diese Option entfernt das HTTPS-Flag von den ausgewählten Inhaltselementen.</p>
				<p><strong>Hinweis:</strong> Auf unsichere Inhalte <em>(HTTPS)</em> kann weiterhin über das HTTPS-Protokoll zugegriffen werden.</p>
				<p>Nur Benutzer mit der Berechtigung „Alle Inhalte verwalten“ können diese Option verwenden.</p>
			</dd>
			<dt>Design und Layoutvorlage festlegen</dt>
			<dd>
				<p>Diese Option zeigt ein Formular an, um das Design und die Layoutvorlage festzulegen, die den ausgewählten Inhaltselementen zugeordnet sind. Nur einige Inhaltselementtypen haben eine Design- und Vorlagenzuordnung. d.h.: der Typ „Inhalt“ und solche, die von anderen Modulen bereitgestellt werden, die ähnliche Funktionen bieten.</p>
				<p>Nur Benutzer mit der Berechtigung „Alle Inhalte verwalten“ können diese Option verwenden.</p>
			</dd>
			<dt>Besitzer festlegen</dt>
			<dd>
				<p>Diese Option zeigt ein Formular an, mit dem Sie den Besitz der ausgewählten Inhaltselemente ändern können.</p>
				<p>Nur Benutzer mit der Berechtigung „Alle Inhalte verwalten“ können diese Option verwenden.</p>
			</dd>
		</dl>
	</dd>
	<dt>Neu sortieren</dt>
	<dd>
		<p>Benutzer mit der Berechtigung „Alle Inhalte verwalten“ haben die Möglichkeit, Inhaltselemente massenhaft neu zu organisieren, indem Sie die Schaltfläche „Seiten neu anordnen“ auf der Seite der Inhaltsliste auswählen. Dies stellt ein Formular bereit, in dem Inhaltselemente mit einfachen Drag-and-Drop-Vorgängen neu geordnet werden können.</p>
		<p><strong>Hinweis:</strong> Dies kann ein sehr speicher- und datenbankintensiver Vorgang sein, und wir raten davon ab, diese Option auf Websites mit mehr als ein paar hundert Inhaltselementen zu verwenden.</p>
	</dd>
</dl>
<h3>Hinzufügen und Bearbeiten von Inhaltselementen</h3>
<p>Die Möglichkeit, Inhaltselemente hinzuzufügen, hängt davon ab, ob ein Benutzer die Berechtigung „Alle Inhalte verwalten“ oder „Seiten hinzufügen“ hat. Benutzer mit der Berechtigung „Alle Inhalte verwalten“ sind in der Lage, alle Aspekte des Inhaltselements zu verwalten. Benutzer ohne diese Berechtigung haben erheblich weniger Möglichkeiten.</p>
<p>Das Formular zum Hinzufügen oder Bearbeiten der Inhaltsseite ist in zahlreiche Registerkarten unterteilt; zahlreiche Eigenschaften des Inhaltselements werden auf verschiedenen Registerkarten angezeigt. Die Liste der sichtbaren Registerkarten und die „Eigenschaften“ auf diesen Registerkarten wird von zahlreichen Faktoren beeinflusst:</p>
<dl>
	<dt>Der Typ des Inhaltselements</dt>
	<dd>
		<p>Einige Arten von Inhaltselementen (z. B. Trennzeichen und Abschnittsüberschriften) erfordern nicht viele Informationen, daher werden nur sehr wenige Registerkarten und Eigenschaften angezeigt.</p>
	</dd>
	<dt>Ihre Berechtigungsstufe</dt>
	<dd>
		<p>Wenn Ihr Benutzerkonto nicht über die Berechtigung „Alle Inhalte verwalten“ verfügt, dann dürfen Sie normalerweise nur die grundlegenden Eigenschaften des Inhaltselements verwalten – genug, um Inhalte zu bearbeiten und eine Seite in der Navigation auszuwählen. Sie können auch Einschränkungen haben, wo neue Inhaltselemente in der Inhaltshierarchie platziert werden können.</p>
	</dd>
	<dt>Webseiteneinstellungen <em>(d. h. das Feld „Grundlegende Eigenschaften“ im Fenster „Globale Einstellungen“ und andere)</em>.</dt>
	<dd>
		<p>Einige Webseiteneinstellungen – und sogar Konfigurationseinstellungen – können beeinflussen, welche Eigenschaften auf welcher Registerkarte angezeigt werden. Die Einstellung „Basiseigenschaften“ in „Webseiten-Administration – Globale Einstellungen“ erweitert die Liste der Eigenschaften von Inhaltselementen, die Benutzer mit eingeschränkten Berechtigungen bearbeiten können.</p>
	</dd>
	<dt>Die ausgewählte Vorlage.</dt>
	<dd>
		<p>Tags in Vorlagen definieren zusätzliche Eigenschaften <em>(Inhaltsblöcke genannt)</em>, die autorisierte Benutzer bearbeiten können, wenn sie ein Inhaltselement bearbeiten, das diese Vorlage verwendet. Diese Inhaltsblöcke können reine Textbereiche, WYSIWYG-Testbereiche, Bildselektoren oder andere Elemente sein. Vorlagenentwickler können die Registerkarte angeben, auf der das Bearbeitungsfeld für jeden Inhaltsblock angezeigt wird.</p>
	</dd>
</dl>
<h4>Eigenschaften</h4>
<p>Hier beschreiben wir kurz die gemeinsamen Eigenschaften für den Inhaltselementtyp „Inhalt“. Einige Inhaltselementtypen verwenden deutlich weniger Eigenschaften, und einige Inhaltselementtypen, die von Modulen von Drittanbietern bereitgestellt werden, verhalten sich möglicherweise völlig anders.</p>
<dl>
	<dt>Titel</dt>
	<dd>
		<p>Dieses Feld beschreibt den Titel für das Inhaltselement (falls zutreffend). Der Titel wird normalerweise im <title>-Tag im Kopf der HTML-Seite und an prominenter Stelle im Inhalt der HTML-Seite angezeigt. Der Website-Entwickler hat die vollständige Kontrolle darüber, wie diese Daten verwendet oder angezeigt werden.</p>
	</dd>
	
	<dt>Alias</dt>
	<dd>
		<p>Der Seitenalias ist eine Zeichenfolge, die dieses Inhaltselement eindeutig identifiziert und normalerweise leichter zu merken ist als die numerische Seiten-ID. Der Alias ​​wird an zahlreichen Stellen beim Erstellen einer Website mit CMS Made Simple verwendet. Es kann verwendet werden, um Links zu Inhaltselementen oder spezialisierte Navigationen zu erstellen oder als Verhaltenshinweis für andere Module, die angeben, zu welchem ​​Inhaltselement sie Daten anzeigen sollen.</p>
		<p>Standardmäßig wird der Seitenalias aus dem Titel generiert, wenn ein neues Inhaltselement hinzugefügt wird. Bearbeiter können jedoch beim Hinzufügen oder Bearbeiten des Inhaltselements ihren eigenen Seitenalias angeben, solange er unter allen anderen Inhaltselementen eindeutig ist. Einige Inhaltselementtypen erfordern keinen Seitenalias.</p>
		<p>Benutzer mit eingeschränkten Berechtigungen haben unter Umständen nicht die Möglichkeit, den Alias ​​anzugeben, wenn sie ein Inhaltselement hinzufügen oder bearbeiten.</p>
	</dd>
	
	<dt>Übergeordnet</dt>
	<dd>
		<p>Die Eigenschaft „Übergeordnet“ gibt das Inhaltselement an, das das unmittelbar übergeordnete Element des Inhaltselements ist, das in der Inhaltshierarchie bearbeitet wird. Benutzer mit eingeschränkten Berechtigungen können diese Eigenschaft möglicherweise nicht bearbeiten oder haben möglicherweise eine eingeschränkte Liste von Optionen für diese Eigenschaft.</p>
	</dd>
	
	<dt>Inhalt</dt>
	<dd>
		<p>Jede Seitenvorlage muss mindestens die standardmäßige Inhaltseigenschaft <em>(auch bekannt als Block)</em> enthalten. Sie können jedoch viel mehr und verschiedene Arten von Inhaltsblöcken definieren. Der Standardblock erscheint normalerweise im Formular zum Bearbeiten von Inhalten als WYSIWYG-Textfeld, der es Redakteuren ermöglicht, einige Standardinhalte für die Seite anzugeben.</p>
		<p>Entwickler haben erhebliche Kontrolle über die Registerkarte, auf der dies angezeigt wird, die Bezeichnung, die maximale Länge, die erforderlichen und andere Attribute, um das Verhalten dieser Eigenschaft im Bearbeitungsformular, und wann sie angezeigt wird, zu steuern.</p>
		<p>Wenn der WYSIWYG-Editor für diesen Inhaltsblock und dieses Inhaltselement <em>(siehe unten)</em> aktiviert ist und ein oder mehrere WYSIWYG-Editor-Module aktiviert sind und der Benutzer dann einen WYSIWYG-Editor in seinen Einstellungen ausgewählt hat, wird er hier angezeigt. Verschiedene WYSIWYG-Editoren haben unterschiedliche Fähigkeiten, aber die meisten bieten die Möglichkeit, Text auf unterschiedliche Weise zu formatieren. Darüber hinaus erlauben die meisten WYSIWYG-Editoren das Einfügen von Bildern und das Erstellen von Links zu anderen Inhaltselementen auf Ihrer Website.</p>
	</dd>
	
	<dt>Menütext</dt>
	<dd>
		<p>Diese Eigenschaft wird beim Erstellen von Navigationen verwendet. Der Inhalt dieses Feldes wird als Text verwendet, der für dieses Inhaltselement in der Navigation angezeigt wird.</p>
	</dd>
	
	<dt>Im Menü anzeigen</dt>
	<dd>
		<p>Oft ist es nützlich, Inhaltselemente für spezielle Zwecke (z. B. zum Anzeigen von Sitemaps, Suchergebnissen, Anmeldeformularen usw.) zu haben, die nicht <em>(standardmäßig)</em> in Navigationsmenüs angezeigt werden. Mit dieser Eigenschaft kann jedes Inhaltselement vor Navigationselementen ausgeblendet werden, sofern es nicht an anderer Stelle überschrieben wird.</p>
	<p>Benutzer mit eingeschränkten Berechtigungen können diese Eigenschaft unter Umständen nicht anpassen oder festlegen.</p>
	</dd>
	
	<dt>Titel-Attribut</dt>
	<dd>
		<p>Diese Eigenschaft definiert einen optionalen Text, der verwendet werden kann, um zusätzliche Informationen für das Inhaltselement in der Navigation anzuzeigen. Es wird normalerweise im „title“-Attribut für den Link, der in Navigationsmenüs generiert wird, verwendet.</p>
		<p>Entwickler haben die Möglichkeit, diese Daten anders anzuzeigen oder vollständig zu ignorieren, indem sie die entsprechende Vorlage für das Navigationsmenü ändern. Zusätzlich können diese Daten im Seiteninhalt angezeigt werden, indem die entsprechende Seitenvorlage modifiziert wird. Diese Eigenschaft ist für Inhaltselemente auf Ihrer Website möglicherweise nicht wichtig.</p>
		<p>Benutzer mit eingeschränkten Berechtigungen können diese Eigenschaft u. U. nicht anpassen oder angeben.</p>
	</dd>
	
	<dt>Zugriffstaste</dt>
	<dd>
		<p>Diese Eigenschaft definiert eine optionale Zeichenkette  <em>(normalerweise nur ein oder zwei Zeichen)</em>, die in Navigationsmenüs verwendet werden kann, um schnell über die Tastatur auf dieses Inhaltselement in der Navigation zuzugreifen. Dies ist eine nützliche Funktion beim Erstellen barrierefreier Navigationen.</p>
		<p>Entwickler können die Verwendung dieser Eigenschaft in Ihren Navigationsvorlagen vollständig einschließen oder ausschließen und es ist möglicherweise nicht erforderlich für Ihre Website.</p>
		<p>Benutzer mit eingeschränkten Berechtigungen können diese Eigenschaft u. U. nicht anpassen oder angeben.</p>
	</dd>
	
	<dt>Tab-Index</dt>
	<dd>
		<p>Diese Eigenschaft wird verwendet, um einen ganzzahligen Index anzugeben, um die Navigation zu diesem Inhaltselement in Menüs zu unterstützen. Es ist nützlich, wenn barrierefreie Websites erstellt werden.</p>
		<p>Entwickler kann die Verwendung dieser Eigenschaft in den Navigationsvorlagen vollständig einschließen oder ausschließen und es ist möglicherweise nicht erforderlich für Ihre Website.</p>
		<p>Benutzer mit eingeschränkten Berechtigungen können diese Eigenschaft u. U. nicht anpassen oder angeben.</p>
	</dd>
	
	<dt>Ziel</dt>
	<dd>
		<p>Diese Eigenschaft wird verwendet, um das „target“-Attribut in Links zu Inhaltselementen anzugeben. Sie ermöglicht das Erstellen von Navigationen, die Inhaltsseiten in verschiedenen Browserfenstern oder Registerkarten öffnen können.</p>
		<p>Entwickler können die Verwendung dieser Eigenschaft in den Navigationsvorlagen vollständig einschließen oder ausschließen und es ist möglicherweise nicht erforderlich für Ihre Website.</p>
		<p>Benutzer mit eingeschränkten Berechtigungen können diese Eigenschaft u. U. nicht anpassen oder angeben.</p>
	</dd>
	
	<dt>URL</dt>
	<dd>
		<p>Diese Eigenschaft wird verwendet, um eine primäre URL zu diesem Inhaltselement anzugeben. Benutzer können einen vollständigen Pfad oder eine einfache flache Zeichenfolge angeben. <em>(z. B. „pfad/zu/meineseite“ oder „seiten-url-mit-schlüsselwörtern“)</em>. Diese Eigenschaft (falls angegeben) wird beim Erstellen von Navigationen und anderen Links zu diesem Inhaltselement verwendet, wenn „suchmaschinenfreindliche URLs“ in der config.php aktiviert sind. Wenn nicht angegeben, steuern der Seitenalias und andere Einstellungen die primäre Route zum Inhaltselement.</p>
		<p>Für SEO-Zwecke ist zu beachten, dass dies nur eine primäre URL <em>(Route)</em> zu den Inhaltselementen ist. Website-Besucher können weiterhin auf andere Weise zu diesem Inhaltselement navigieren, d. h.: example.com/index.php?page=alias oder example.com/beispiel/beispiel/alias oder example.com/alias. Websites, die sich mit Suchmaschinen-Rankings befassen, sollten sicherstellen, dass das Element <link rel="canonical"> in ihren Seitenvorlagen richtig konfiguriert ist.</p>
		<p>Benutzer mit eingeschränkten Berechtigungen können diese Eigenschaft u. U. nicht anpassen oder angeben.</p>
	</dd>
	
	<dt>Aktiv <em>(d. h. deaktiviert)</em></dt>
	<dd>
		<p>Diese Eigenschaft wird verwendet, um anzugeben, ob zu diesem Inhaltselement überhaupt navigiert werden kann.</p>
		<p>Benutzer mit eingeschränkten Berechtigungen können diese Eigenschaft  u. U. nicht anpassen oder angeben.</p>
	</dd>
	
	<dt>Sicher (HTTPS)</dt>
	<dd>
		<p>Diese Eigenschaft wird verwendet, um anzugeben, ob auf dieses Inhaltselement unter Verwendung des HTTPS-Protokolls zugegriffen werden soll. Wenn dieses Attribut auf einer ordnungsgemäß für HTTPS konfigurierten Website für ein Inhaltselement festgelegt ist und versucht wird, auf diese Seite über das unsichere HTTP-Protokoll zuzugreifen, wird der Benutzer mit dem sichereren HTTPS-Protokoll auf dieselbe Seite umgeleitet. Wenn diese Option gesetzt ist, wenden außerdem alle Links zu diesem Inhaltselement das HTTPS-Protokoll an.</p>
		<p>Es ist wichtig zu wissen, dass Inhaltselemente ohne gesetztes Sicherheitsflag weiterhin über das HTTPS-Protokoll navigiert werden können und keine Umleitung stattfindet. Daher sollte der kanonische Link für Suchmaschinen-Ranking-Zwecke in jeder Seitenvorlage richtig konfiguriert werden.</p>
	</dd>
	
	<dt>Zwischenspeicherbar</dt>
	<dd>
		<p>Diese Eigenschaft gibt an, ob die kompilierte Form dieses Inhaltselements auf dem Server zwischengespeichert werden kann, um die Serverlast zu reduzieren <em>(wenn intelligentes Caching in den globalen Einstellungen aktiviert ist)</em> UND ob der Browser diese Seite zwischenspeichern kann <em>(wenn Browser-Caching in den globalen Einstellungen aktiviert ist)</em>. Bei weitgehend statischen Websites kann die Aktivierung von intelligentem Caching und Browser-Caching die Serverlast erheblich reduzieren und die Gesamtleistung der Website verbessern.</p>
		<p>Benutzer mit eingeschränkten Berechtigungen können diese Eigenschaft u. U. nicht anpassen oder angeben.</p>
	</dd>
	
	<dt>Bild</dt>
	<dd>
		<p>Diese Eigenschaft ermöglicht die Verknüpfung eines zuvor hochgeladenen Bildes mit diesem Inhaltselement. Redakteure können eine Bilddatei aus dem Verzeichnis uploads/images auswählen. Dieses Bild kann auf der generierten HTML-Seite (falls zutreffend) angezeigt oder beim Erstellen der Navigation verwendet werden.</p>
		<p>Benutzer mit eingeschränkten Berechtigungen können diese Eigenschaft u. U. nicht anpassen oder angeben.</p>
	</dd>
	
	<dt>Miniaturansicht</dt>
	<dd>
		<p>Diese Eigenschaft ermöglicht es, diesem Inhaltselement ein zuvor erstelltes Miniaturbild zuzuordnen. Redakteure können eine Vorschaubilddatei aus dem Verzeichnis „uploads/images“ auswählen. Dieses Miniaturbild kann auf der generierten HTML-Seite angezeigt oder beim Erstellen der Navigation verwendet werden.</p>
		<p>Benutzer mit eingeschränkten Berechtigungen können diese Eigenschaft u. U. nicht anpassen oder angeben.</p>
	</dd>
	
	<dt>Eigentümer</dt>
	<dd>
		<p>Die Eigentümereigenschaft ist eine Auswahlliste, die angibt, welches Admin-Benutzerkonto die Hauptverantwortung für das Inhaltselement trägt. Standardmäßig ist der Eigentümer des Inhaltselements der Benutzer, der es zuerst erstellt hat. Nutzer mit umfassender Berechtigung können das Eigentum an einem Element einem anderen Nutzer zuweisen.</p>
	</dd>
	
	<dt>Zusätzliche Bearbeiter</dt>
	<dd>
		<p>Diese Eigenschaft gibt eine Liste anderer Admin-Benutzer oder Admin-Gruppen an, die berechtigt sind, dieses Inhaltselement zu bearbeiten. Es ist als Mehrfachauswahlfeld implementiert. Auch hier haben Benutzer mit eingeschränkten Berechtigungen möglicherweise nicht die Möglichkeit, diese Eigenschaft anzupassen.</p>
	</dd>
	
	<dt>Design</dt>
	<dd>
		<p>Die Eigenschaft ermöglicht die Verknüpfung eines Designs mit dem Inhaltselement. Ein Design wird verwendet, um die Stylesheets und andere Elemente zu bestimmen, die zum Erscheinungsbild von Inhaltselementen beitragen. Das Design ist verschiedenen Vorlagen zugeordnet. Das Ändern der Designeigenschaft kann dazu führen, dass sich die Vorlageneigenschaft automatisch ändert. Standardmäßig ist das „Standarddesign“ ausgewählt im Design Manager wird hier ausgewählt. Einige eingeschränkte Bearbeiter haben möglicherweise nicht die Möglichkeit, diese Eigenschaft anzupassen.</p>
	</dd>
	
	<dt>Vorlage</dt>
	<dd>
		<p>Die Seitenvorlageneigenschaft wird verwendet, um das Gesamtlayout des Inhaltselements zu bestimmen (für die Inhaltselemente, die HTML generieren). Es bestimmt auch die Verwendung von Meta-Tags und Inhaltsblöcken. Durch das Ändern dieser Vorlage wird die Seite aktualisiert und die entsprechenden Inhaltseigenschaften (Blöcke) angezeigt, die in der neu ausgewählten Vorlage angegeben sind.</p>
		<p>Benutzer mit eingeschränkten Berechtigungen können diese Eigenschaft u. U. nicht anpassen oder angeben.</p>
	</dd>
	
	<dt>Durchsuchbar</dt>
	<dd>
		<p>Diese Eigenschaft steuert, ob die Inhaltseigenschaften dieses Inhaltselements vom Suchmodul indiziert werden können.</p>
		<p>Benutzer mit eingeschränkten Berechtigungen können diese Eigenschaft u. U. nicht anpassen oder angeben.</p>
	</dd>
	
	<dt>WYSIWYG deaktivieren</dt>
	<dd>
		<p>Diese Eigenschaft deaktiviert den WYSIWYG-Editor für alle Inhaltsblöcke auf diesem Inhaltselement. Dies überschreibt alle Einstellungen in den Inhaltsblöcken und alle Benutzereinstellungen. Dies ist nützlich für Inhaltselemente, die reine Logik in den Inhaltsblöcken enthalten oder ausschließlich andere Module aufrufen. Dadurch wird verhindert, dass die Logik oder die Ausgabe der Module durch das durch WYSIWYG eingefügte Styling beeinflusst wird.</p>
		<p>Benutzer mit eingeschränkten Berechtigungen können diese Eigenschaft u. U. nicht anpassen oder angeben.</p>
	</dd>
	
	<dt>Seiten-Metadaten</dt>
	<dd>
		<p>Der Hauptzweck dieser Eigenschaft besteht darin, Metaeigenschaften in den <head>-Abschnitt der gerenderten HTML-Seite einzufügen. Normalerweise ist es nützlich, um ein Meta-Beschreibungs-Tag einzufügen.</p>
		<p>Benutzer mit eingeschränkten Berechtigungen können diese Eigenschaft u. U. nicht anpassen oder angeben.</p>
	</dd>
	
	<dt>Seitendaten</dt>
	<dd>
		<p>Diese Eigenschaft wird hauptsächlich zum Einfügen von Daten oder Logik in den Smarty-Prozess zur Verwendung durch die Seitenvorlage verwendet. Es ist ein erweitertes Feld zur Verwendung in flexiblen Layouts, die ihr Verhalten dynamisch ändern.</p>
		<p>Benutzer mit eingeschränkten Berechtigungen können diese Eigenschaft möglicherweise nicht anpassen oder angeben.</p>
	</dd>
	
	<dt>extra1, extra2 und extra3</dt>
	<dd>
		<p>Zusätzliche Eigenschaften zur Verwendung bei der Anzeige von Daten oder zur Beeinflussung des Verhaltens der Seitenvorlage.</p>
	</dd>
</dl>';
$lang['help_designmanager_help'] = '<h3>Was ist das?</h3>
<p>Die Designverwaltung ist ein Grundmodul (ein Modul, das als Teil von CMS Made Simple mitgeliefert wird), das die Funktionalität zur Verwaltung des Layouts von CMSMS-Webseiten vereint. Es bietet eine vollständige Lösung zum Verwalten und Bearbeiten beliebiger Smarty-Vorlagen und zum Organisieren dieser Vorlagen. Außerdem können Sie Stylesheets erstellen, bearbeiten, löschen und verwalten. Vorlagen und Stylesheets können dann in „Designs“ organisiert werden.</p>

<h3>Was ist ein „Design“?</h3>
<p>Ein Design ist eine Art Container. Es enthält eine lockere Verknüpfung von Stylesheets und Vorlagen. Es ermöglicht das Verwalten aller Stylesheets und Vorlagen, die zur Implementierung eines bestimmten Erscheinungsbilds erforderlich sind. Designs können in einer einzigen Datei exportiert und geteilt sowie aus einer einzelnen Datei importiert werden.</p>
<p>Jede Inhaltsseite, die HTML enthält, ist mit einem Design verbunden, um festzulegen, welche Stylesheets verwendet werden sollen und in welcher Reihenfolge dies geschehen soll. Darüber hinaus ist jede Inhaltsseite, die HTML enthält, mit einer Vorlage verbunden, wenngleich die Vorlage nicht unbedingt mit dem angegebenen Design verbunden sein muss.</p>
<p>Vorlagen und Stylesheets müssen nicht mit einem Design verbunden sein, jedoch werden nur die Vorlagen und Stylesheets, die mit einem Design verbunden sind, mit dem Design exportiert.</p>

<h3>Was sind Vorlagentypen?</h3>
<p>Vorlagentypen sind eine Möglichkeit, Vorlagen locker zu organisieren. Einige Funktionen können Listen von Vorlagen eines bestimmten Typs anzeigen, um die Auswahl zu erleichtern. Zum Beispiel zeigt die Bearbeiten-Inhaltsseite eine Liste von Vorlagen des Typs „Seite“ an.</p>
<p>CMS Made Simple erstellt einige Standard-Vorlagentypen bei der Installation. Drittanbieter-Module werden wahrscheinlich weitere erstellen. Vorlagentypdefinitionen haben normalerweise zwei Teile, den Urheber (das Modul oder die Funktionalität, die sie erstellt hat) und den Typnamen selbst. z.B.: „Core::Page“ gibt einen Seitenvorlagentypen an, der vom CMS erstellt wurde. News::Summary ist der Name des Vorlagentyps für Zusammenfassungsvorlagen des News-Moduls. Obwohl Websiteentwickler keine neuen Vorlagentypen erstellen können, können sie den Typ für eine Vorlage beim Hinzufügen oder Bearbeiten einer Vorlage angeben.</p>
<p>Die meisten Vorlagentypen haben eine „Prototypen-Vorlage“, die verwendet wird, um ein Grundlayout für die Erstellung einer neuen Vorlage dieses Typs bereitzustellen.</p>
<p>Einige Vorlagentypen (wie der Vorlagentyp „Core::Page“) unterstützen die Idee einer „Standardvorlage“. Die Standardvorlage eines Typs wird normalerweise von Modulen verwendet, damit eine Vorlage eines bestimmten Typs verwendet werden kann, falls keine bestimmte Vorlage benannt ist. Darüber hinaus wird die Standardvorlage des Typs „Core::Page“ als Standardvorlage verwendet, wenn ein neues Inhaltsobjekt des Typs „Inhalt“ erstellt wird.</p>
<p>Die Administrationsoberfläche der Designverwaltung ermöglicht das Filtern von Vorlagen nach Urheber oder Typ, um Vorlagen zum Bearbeiten oder Verwalten leicht zu finden.</p>
<h4>Generische Vorlagen <em>(ehemals Globale Inhaltsblöcke)</em></h4>
<p>Ein Standardvorlagentyp wird als „Core::generic“ bezeichnet. Dies ist eine generische Vorlage, die für alles verwendet werden kann. Sie ersetzt „Globale Inhaltsblöcke“ <em>(GCB)</em> aus früheren Versionen von CMSMS.</p>

<h3>Wofür sind „Kategorien“ da?</h3>
<p>Kategorien sind eine Methode, die von Website-Entwicklern verwendet werden kann, um Vorlagen weiter zu organisieren. Website-Entwickler können Kategorien erstellen, umbenennen und löschen und verschiedene Vorlagen damit verknüpfen. Beim Verwalten von Vorlagen können Entwickler Vorlagen nach ihrer Kategorie filtern.</p>

<h3>Die Hauptbenutzeroberfläche</h3>
<p>Die Designverwaltungsoberfläche befindet sich in der CMSMS-Admin-Navigation als „Designverwaltung“ unter dem Abschnitt „Layout“.</p>
<p>Die Designverwaltungsoberfläche verfügt über zahlreiche Registerkarten. Jede Registerkarte dient einem bestimmten Zweck und erfordert möglicherweise besondere Berechtigungen. Nur ein Benutzer mit einer der erforderlichen Berechtigungen <em>(oder Besitzer/zusätzlicher Editorstatus für eine oder mehrere Vorlagen)</em> wird in der Lage sein, die Designverwaltung in der CMSMS-Admin-Konsole zu sehen.</p>
<dl>
	<dt>Die Vorlagenregisterkarte</dt>
	<dd>
		<p>Die Vorlagenregisterkarte bietet alle Funktionen, um Vorlagen bequem und einfach zu erstellen und zu verwalten. Sie ist für Admin-Benutzer mit der Berechtigung „Vorlagen bearbeiten“ sichtbar oder für Besitzer oder zusätzliche Editoren einer oder mehrerer Vorlagen.</p>
		<p>Zu den Funktionen dieser Registerkarte gehören unter anderem:</p>
		<ul>
			<li>Ein tabellarisches Format, das Zusammenfassungsinformationen zu jeder Vorlage anzeigt und bequeme Aktionen für die Arbeit an Vorlagen einzeln oder im Paket bietet.</li>
			<li>Die Möglichkeit, eine gesperrte Vorlage zu übernehmen</li>
			<li>Erweiterte Filterung</li>
			<li>Paginierung</li>
		</ul>
	</dd>

	<dt>Die Kategorienregisterkarte</dt>
	<dd>
		<p>Die Kategorienregisterkarte ist für alle Admin-Benutzer mit der Berechtigung „Vorlagen bearbeiten“ sichtbar. Sie bietet die Möglichkeit, Kategorien hinzuzufügen, zu bearbeiten, zu löschen, umzubenennen und neu anzuordnen.</p>
		<p>Beim Hinzufügen oder Bearbeiten einer Kategorie ist es möglich, eine Beschreibung der Verwendung der Kategorie für Referenzzwecke anzugeben.</p>
	</dd>

	<dt>Die Vorlagentypenregisterkarte</dt>
	<dd>
		<p>Diese Registerkarte ist für alle Admin-Benutzer mit der Berechtigung „Vorlagen bearbeiten“ sichtbar. Sie bietet die Möglichkeit, Informationen über den Vorlagentyp einschließlich der Prototypvorlage zu bearbeiten. Und um eine neue Vorlage jedes Typs zu erstellen.</p>
	</dd>

	<dt>Die Stylesheets-Registerkarte</dt>
	<dd>
		<p>Diese Registerkarte ist für alle Admin-Benutzer mit der Berechtigung „Stylesheets verwalten“ sichtbar. Sie bietet die Möglichkeit, Stylesheets zu erstellen, zu löschen, zu bearbeiten und zu verwalten.</p>
	</dd>

	<dt>Die Designs-Registerkarte</dt>
	<dd>
		<p>Diese Admin-Panel-Registerkarte ist für alle Admin-Benutzer mit der Berechtigung „Designs verwalten“ sichtbar. <em>(Hinweis: Benutzer mit dieser Berechtigung und ohne andere haben möglicherweise keinen Zugriff auf die volle Funktionalität dieser Registerkarte)</em>.</p>
		<p>Diese Registerkarte bietet die Möglichkeit, Designs zu importieren, zu exportieren, zu erstellen, zu bearbeiten und zu löschen.</p>
	</dd>
</dl>
<h3>Verwaltung von Vorlagen</h3>
<p>Der Registerkarte „Vorlagen“ zeigt eine Liste von Vorlagen an, die dem aktuellen Filter entsprechen <em>(falls angewendet)</em>, in tabellarischer Form mit Seitenzahlen. Jede Zeile der Tabelle repräsentiert eine einzelne Vorlage. Die Spalten der Tabelle zeigt eine Zusammenfassung über die Vorlage an und bieten die Möglichkeit zur Interaktion damit.</p>
<p>Ein Auswahlmenü ermöglicht es, zwischen Seiten von Vorlagen zu wechseln, die dem aktuellen Filter entsprechen, falls mehr als eine Seite von Vorlagen dem aktuellen Filter entspricht.</p>
<p>Ein Optionsmenü bietet die Möglichkeit, den aktuellen Filter anzupassen oder eine neue Vorlage zu erstellen <em>(abhängig von den Berechtigungen)</em>. Der Filterdialog ermöglicht das Filtern der angezeigten Vorlagen nach verschiedenen Kriterien sowie das Ändern des Seitenumfangs und die Sortierung der angezeigten Vorlagen.</p>
<h4>Tabellenspalten:</h4>
<dl>
	<dt>Id:</dt>
	<dd>
		<p>Dies zeigt die eindeutige numerische ID für die Vorlage an. Durch Klicken auf den Link in dieser Spalte wird das Formular zur Bearbeitung der Vorlage geöffnet. Wenn Sie über den Link fahren, wird ein Tooltip mit weiteren Informationen zur Vorlage angezeigt.</p>
	</dd>
	<dt>Name:</dt>
	<dd>
		<p>Dies zeigt einen eindeutigen textuellen Namen für die Vorlage an. Durch Klicken auf den Link in dieser Spalte wird das Formular zur Bearbeitung der Vorlage geöffnet. Wenn Sie über den Link fahren, wird ein Tooltip mit weiteren Informationen zur Vorlage angezeigt.</p>
	</dd>
	<dt>Typ:</dt>
	<dd>
		<p>Dies zeigt den Vorlagentyp an. Wenn Sie den Mauszeiger über den Typnamen bewegen, wird ein Tooltip mit weiteren Informationen zum Vorlagentyp angezeigt.</p>
	</dd>
	<dt>Design:</dt>
	<dd>
		<p>Diese Spalte zeigt das Design bzw. die Designs an, mit denen diese Vorlage verknüpft ist (falls vorhanden). Wenn die Vorlage mit mehreren Designs verknüpft ist, wird ein Tooltip eine Liste der ersten Designs anzeigen, mit denen diese Vorlage verknüpft ist.</p>
	</dd>
	<dt>Standard:</dt>
	<dd>
		<p>Diese Spalte zeigt ein Symbol an, das anzeigt, ob die Vorlage die Standardvorlage für ihren Typ ist.</p>
	</dd>
	<dt>Aktionen:</dt>
	<dd>
		<p>Je nach Benutzerberechtigungen werden in dieser Spalte ein oder mehrere Symbole angezeigt, um verschiedene Aktionen auf oder mit der Vorlage durchzuführen:</p>
		<ul>
			<li>Bearbeiten - Zeigt ein Formular zur Bearbeitung des Inhalts und der Attribute der Vorlage an.</li>
			<li>Kopieren - Zeigt ein Formular an, um die ausgewählte Vorlage unter einem neuen Namen zu kopieren. Für Bequemlichkeit wird ein Standardneuer Name bereitgestellt.</li>
			<li>Löschen - Zeigt ein Formular an, um die ausgewählte Vorlage zu löschen. Für diese Aktion ist eine zusätzliche Bestätigung erforderlich, da keine Überprüfungen möglich sind, um festzustellen, ob die Vorlage von einer Seite verwendet wird oder rekursiv von einer anderen Vorlage.</li>
		</ul>
	</dd>
	<dt>Mehrfachauswahl:</dt>
	<dd>
		<p>Diese Spalte (abhängig von den Berechtigungen) zeigt ein Kontrollkästchen an, das die Auswahl mehrerer Vorlagen ermöglicht, um Aktionen auf allen gleichzeitig durchzuführen.</p>
	</dd>
</dl>
<h4>Massenaktionen:</h4>
<p>Dies ist ein Dropdown mit Optionen <em>(derzeit nur löschen)</em>, um mehrere Vorlagen gleichzeitig zu bearbeiten. Verwenden Sie äußerste Vorsicht bei der Durchführung von Massenaktionen, da dies eine funktionierende Website schwerwiegend beeinträchtigen könnte.</p>
<h4>Vorlagen bearbeiten</h4>
<p>Das Vorlagenbearbeitungsformular ist ein komplexes Formular, das die Verwaltung aller Attribute einer Vorlage ermöglicht. Aus Gründen der Benutzerfreundlichkeit ist das Formular in zahlreiche Registerkarten unterteilt.</p>
<p>Dieses Formular unterstützt die „dirtyform“-Funktionalität, um die Wahrscheinlichkeit zu verringern, dass Änderungen versehentlich verloren gehen. Benutzer werden benachrichtigt, wenn sie versuchen, diese Seite zu verlassen, ohne die Vorlage gespeichert zu haben.</p>
<p>Dieses Formular sperrt die ausgewählte Vorlage, sodass andere autorisierte Bearbeiter nicht gleichzeitig die Vorlage bearbeiten können. Dies verhindert, dass jemand versehentlich die Änderungen eines anderen Bearbeiters überschreibt.</p>
<dl>
	<dt>Name:</dt>
	<dd>
		<p>Diese Textzeichenfolge identifiziert die Vorlage eindeutig. Das System generiert einen Fehler beim Speichern der Vorlage, wenn der Name bereits für eine andere Vorlage verwendet wird.</p>
	</dd>
	<dt>Vorlageninhalt:</dt>
	<dd>
		<p>Dieses Textfeld zeigt die tatsächliche Smarty-Vorlage an. Wenn ein Syntaxhervorhebungsmodul installiert und aktiviert ist und der Benutzer es in seinen Einstellungen aktiviert hat, wird es in diesem Bereich aktiviert, um erweiterte Bearbeitungsmöglichkeiten zu bieten.</p>
	</dd>
	<dt>Beschreibung:</dt>
	<dd>
		<p>Dieses Textfeld bietet die Möglichkeit, den Zweck der Vorlage zu beschreiben und Notizen zu machen, die für zukünftige Bearbeiter nützlich sein können.</p>
	</dd>
	<dt>Designs:</dt>
	<dd>
		<p>Abhängig von den Berechtigungsstufen ermöglicht dieser Tab die Zuordnung der Vorlage zu null oder mehr Designs.</p>
	</dd>
	<dt>Erweitert:</dt>
	<dd>
		<p>Dieser Tab zeigt Felder an, die es ermöglichen, die Vorlagenkategorie, ihren Typ und ob sie die Standardvorlage für diesen Typ ist, anzugeben. Dieser Tab ist nur mit den entsprechenden Berechtigungen verfügbar.</p>
	</dd>
	<dt>Berechtigungen:</dt>
	<dd>
		<p>Wenn das Benutzerkonto der Eigentümer der Vorlage ist oder über die Berechtigung „Vorlagen bearbeiten“ verfügt, ermöglicht dieser Tab das Ändern der Eigentümerschaft der Vorlage und/oder das Festlegen zusätzlicher Bearbeiter.</p>
	</dd>
	<dt>Alle Seiten setzen:</dt>
	<dd>
		<p>Benutzer mit der Berechtigung „Vorlagen bearbeiten“ sehen eine Schaltfläche, mit der alle Inhaltsseiten so eingestellt werden können, dass sie diese Vorlage verwenden.</p>
	</dd>
</dl>
<h3>Kategorien verwalten</h3>
<p>Die Berechtigung „Vorlagen bearbeiten“ ist erforderlich, um diesen Tab und die zugehörigen Aktionen zu sehen.</p>
<p>Der Kategorien-Tab ist eine einfache Benutzeroberfläche, die das Erstellen, Bearbeiten, Entfernen und Neuordnen von Kategorien ermöglicht. Kategorien können durch Ziehen und Ablegen in die gewünschte Reihenfolge gebracht werden.</p>
<p>Das Bearbeiten einer Kategorie ermöglicht das Festlegen einer Beschreibung für die Kategorie. Die Beschreibung ist nützlich, um eine Notiz zum Zweck der Kategorie zu hinterlassen.</p>
<h3>Vorlagentypen verwalten</h3>
<p>Die Berechtigung „Vorlagen bearbeiten“ ist erforderlich, um diesen Tab und die zugehörigen Aktionen zu sehen.</p>
<p>Benutzer mit ausreichenden Rechten können die Prototypvorlage und die Beschreibung für jeden Vorlagentyp anpassen. Die Prototypvorlage wird als Standardinhalt für die Vorlage verwendet, wenn eine neue Vorlage dieses Typs erstellt wird.</p>
<h3>Stylesheets verwalten</h3>
<p>Der Stylesheets-Tab steht Benutzern mit der Berechtigung „Stylesheets verwalten“ zur Verfügung. Er zeigt eine paginierte Liste aller Stylesheets an, die dem aktuellen Filter <em>(falls angewendet)</em> entsprechen, in tabellarischer Form. Jede Zeile der Tabelle repräsentiert ein einzelnes Stylesheet. Die Spalten der Tabelle zeigen Zusammenfassungsinformationen über das Stylesheet an und bieten einige Interaktionsmöglichkeiten.</p>
<p>Ein Auswahlmenü, das die Möglichkeit bietet, zwischen Seiten von Stylesheets zu wechseln, die dem aktuellen Filter entsprechen, wird angezeigt, wenn mehr als eine Seite von Stylesheets dem aktuellen Filter entsprechen.</p>
<p>Es gibt ein Optionsmenü, das die Möglichkeit bietet, den aktuellen Filter anzupassen oder ein neues Stylesheet zu erstellen <em>(abhängig von den Berechtigungen).</em> Der Filterdialog ermöglicht das Filtern, Sortieren und Paginieren der angezeigten Stylesheets nach verschiedenen Kriterien.</p>
<h4>Tabellenspalten:</h4>
<dl>
	<dt>Id:</dt>
	<dd>
		<p>Dies zeigt einen Link an, der die eindeutige numerische ID für das Stylesheet enthält. Durch Klicken auf diesen Link wird das Formular zum Bearbeiten des Stylesheets angezeigt. Wenn Sie über den Link fahren, wird ein Tooltip mit weiteren Informationen zum Stylesheet angezeigt.</p>
	</dd>
	<dt>Name:</dt>
	<dd>
		<p>Dies zeigt den eindeutigen textuellen Namen des Stylesheets als Link an. Durch Klicken auf diesen Link wird das Formular zum Bearbeiten des Stylesheets angezeigt. Wenn Sie über den Link fahren, wird ein Tooltip mit weiteren Informationen zum Stylesheet angezeigt.</p>
	</dd>
	<dt>Design:</dt>
	<dd>
		<p>Diese Spalte zeigt die Designs an, mit denen dieses Stylesheet verknüpft ist (falls vorhanden). Wenn das Stylesheet mit mehreren Designs verknüpft ist, wird ein Tooltip eine Liste der ersten paar Designs anzeigen.</p>
	</dd>
	<dt>Änderungsdatum:</dt>
	<dd>
		<p>Diese Spalte zeigt das Datum an, an dem das Stylesheet zuletzt geändert wurde.</p>
	</dd>
	<dt>Aktionen:</dt>
	<dd>
		<ul>
			<li>Bearbeiten - Durch Klicken auf dieses Symbol wird das Formular zum Bearbeiten des Stylesheets angezeigt.</li>
			<li>Löschen - Durch Klicken auf dieses Symbol wird ein Formular angezeigt, um das Stylesheet zu löschen. Eine zusätzliche Bestätigung ist für diese Aktion erforderlich.</li>
		</ul>
	</dd>
	<dt>Mehrfachauswahl:</dt>
	<dd>
		<p>Diese Spalte zeigt ein Kontrollkästchen an, das die Auswahl mehrerer Stylesheets ermöglicht, um Massenaktionen auf alle gleichzeitig durchzuführen.</p>
	</dd>
</dl>
<h4>Massenaktionen:</h4>
<p>Dieses Mini-Formular enthält ein Dropdown mit Optionen <em>(derzeit nur löschen)</em>, die auf die ausgewählten Stylesheets angewendet werden können. Verwenden Sie äußerste Vorsicht bei der Durchführung von Massenaktionen, da dies eine funktionierende Website schwerwiegend beeinträchtigen könnte.</p>
<h4>Stylesheets bearbeiten</h4>
<p>Das Formular zum Bearbeiten von Stylesheets ist ein komplexes Formular, das die Verwaltung aller Attribute eines Stylesheets ermöglicht. Aus Gründen der Benutzerfreundlichkeit ist das Formular in zahlreiche Registerkarten unterteilt. Es unterstützt die „dirtyform“-Funktionalität, um die Wahrscheinlichkeit zu verringern, dass Änderungen versehentlich verloren gehen, und es unterstützt das Sperren, um zu verhindern, dass andere autorisierte Bearbeiter Änderungen versehentlich überschreiben.</p>
<p>Hier sind einige der Attribute eines Stylesheets, die bearbeitet werden können:</p>
<dl>
	<dt>Name:</dt>
	<dd>
		<p>Diese Textzeichenfolge identifiziert das Stylesheet eindeutig. Das System generiert einen Fehler beim Speichern des Stylesheets, wenn der Name bereits von einem anderen Stylesheet verwendet wird.</p>
	</dd>
	<dt>Stylesheet-Inhalt:</dt>
	<dd>
		<p>Dieses Textfeld zeigt den tatsächlichen CSS-Code an. Wenn ein Syntax-Highlighting-Modul installiert ist, das das Hervorheben von CSS-Code unterstützt, aktiviert und vom Benutzer in seinen Einstellungen aktiviert wurde, wird es in diesem Bereich aktiviert, um erweiterte Bearbeitungsmöglichkeiten zu bieten.</p>
	</dd>
	<dt>Medientypen <em style="color: red;">(veraltet)</em>:</dt>
	<dd>
		<p>Dieser Tab bietet zahlreiche Kontrollkästchen, mit denen Sie Medientypen auswählen können, die mit dem Stylesheet verknüpft werden sollen. Es wird empfohlen, stattdessen Media-Queries zu verwenden, und diese Funktionalität kann zu einem späteren Zeitpunkt entfernt werden.</p>
	</dd>
	<dt>Media Query:</dt>
	<dd>
		<p>Dieser Tab bietet ein Textfeld, in dem eine Media-Query mit dem Stylesheet verknüpft werden kann.</p>
	</dd>
	<dt>Beschreibung:</dt>
	<dd>
		<p>Das Textfeld in diesem Tab bietet die Möglichkeit, den Zweck der Stylesheets zu beschreiben und Notizen zu machen, die für zukünftige Bearbeiter nützlich sein können.</p>
	</dd>
	<dt>Designs:</dt>
	<dd>
		<p>Dieser Tab bietet die Möglichkeit, das Stylesheet mit einem oder mehreren Designs zu verknüpfen. Wenn neue Designverknüpfungen erkannt werden, wird dieses Stylesheet am Ende der Stylesheet-Liste für dieses Design platziert.</p>
	</dd>
</dl>
<h3>Designs verwalten</h3>
<p>Der Designs-Tab steht Benutzern mit der Berechtigung „Designs verwalten“ zur Verfügung. Er zeigt eine Liste aller bekannten Designs in tabellarischer Form an. Jede Zeile der Tabelle repräsentiert ein einzelnes Design. Die Spalten der Tabelle zeigen Zusammenfassungsinformationen über das Design an und bieten einige Interaktionsmöglichkeiten.</p>
<p>Dieser Tab bietet keine Filter-, Paginierungs- oder Massenaktionsfunktionen, da die Anzahl der mit einer Website verbundenen Designs normalerweise klein und überschaubar gehalten werden sollte.</p>
<p>Es gibt ein Optionsmenü, das die Möglichkeit bietet, ein neues Design zu erstellen oder ein Design aus dem XML-Format zu importieren.</p>
<h4>Tabellenspalten</h4>
<dl>
	<dt>Id:</dt>
	<dd>
		<p>Diese Spalte zeigt einen Link mit der eindeutigen numerischen ID des Designs an. Durch Klicken auf diesen Link wird das Formular zum Bearbeiten des Designs angezeigt.</p>
	</dd>
	<dt>Name:</dt>
	<dd>
		<p>Diese Spalte zeigt einen Link mit dem Namen des Designs an. Durch Klicken auf diesen Link wird das Formular zum Bearbeiten des Designs angezeigt.</p>
	</dd>
	<dt>Standard:</dt>
	<dd>
		<p>Diese Spalte zeigt ein Symbol an, das darstellt, ob dieses Design das „Standard“-Design ist. Das Standarddesign wird zuerst ausgewählt, wenn ein neuer Inhaltstyp „Inhaltsseite“ erstellt wird, und kann für andere Zwecke verwendet werden. Es kann nur ein Design das Standarddesign sein.</p>
	</dd>
	<dt>Aktionen:</dt>
	<dd>
		<p>Diese Spalte zeigt verschiedene Links und Symbole an, die Aktionen darstellen, die mit Designs durchgeführt werden können:</p>
		<ul>
			<li>Bearbeiten - Ein Formular zum Bearbeiten des Designs anzeigen.</li>
			<li>Exportieren - Das Design in eine XML-Datei exportieren, die in andere Websites importiert werden kann.</li>
			<li>Löschen - Ein Formular anzeigen, das eine Bestätigung zum Löschen des Designs erfragt.</li>
		</ul>
	</dd>
</dl>
<h4>Designs bearbeiten:</h4>
<p>Das Formular zum Bearbeiten von Designs ist ein komplexes Formular, das die Verwaltung aller Attribute eines Designs ermöglicht. Das Formular ist in zahlreiche Registerkarten unterteilt. Im Gegensatz zur Bearbeitung von Stylesheets und Vorlagen unterstützt dieses Formular keine „dirtyform“- oder Sperrfunktionalität.</p>
<p>Einige der Attribute eines Designs, die bearbeitet werden können, sind:</p>
<dl>
	<dt>Name:</dt>
	<dd></dd>
	<dt>Vorlagen:</dt>
	<dd>
		<p>Dieser Tab ermöglicht die Auswahl verschiedener Vorlagen, die dem Design zugeordnet werden sollen. Sie können Vorlagen zwischen der Liste „Verfügbare Vorlagen“ und der Liste „Zugeordnete Vorlagen“ per Drag & Drop verschieben und die Reihenfolge der Vorlagen in der zugeordneten Liste ändern. Zurzeit ist die Reihenfolge der Vorlagen in der zugeordneten Vorlagenliste nicht von Bedeutung.</p>
	</dd>
	<dt>Stylesheets:</dt>
	<dd>
		<p>Dieser Tab ermöglicht die Auswahl verschiedener Stylesheets, die dem Design zugeordnet werden sollen. Sie können Stylesheets zwischen der Liste „Verfügbare Stylesheets“ und der Liste „Zugeordnete Stylesheets“ per Drag & Drop verschieben und die Reihenfolge der Stylesheets in der zugeordneten Liste ändern. Die Reihenfolge der Stylesheets in der zugeordneten Liste bestimmt die Reihenfolge, in der sie in den gerenderten Seiteninhalt für Inhaltselemente des Typs „Inhaltsseite“ aufgenommen werden.</p>
	</dd>
	<dt>Beschreibung:</dt>
	<dd>
		<p>Dieser Tab bietet ein freies Textfeld, in dem eine Beschreibung des Designs und zusätzliche Notizen eingegeben werden können. Die Beschreibung ist auch für andere Benutzer nützlich, wenn sie sich entscheiden, ein Design zu teilen.</p>
	</dd>
</dl>
<h4>Designs importieren</h4>
<p>Das Designverwaltungsmodul kann XML-Themen importieren, die aus der CMSMS-Designverwaltung oder dem älteren CMSMS Theme Manager exportiert wurden. Es erweitert die hochgeladene XML-Datei und extrahiert Vorlagen, Stylesheets und andere nützliche Informationen aus der Datei. Es führt auch einige kleinere Transformationen an den extrahierten Daten durch, um beispielsweise überlappende Namen anzupassen.</p>
<p>Der Importprozess ist in einige Schritte unterteilt:</p>
<dl>
	<dt>Schritt 1: Datei hochladen:</dt>
	<dd>
		<p>Dieser Schritt verwaltet das Hochladen der vom Benutzer ausgewählten XML-Datei und die Validierung ihres Inhalts. Dieser Schritt ist anfällig für PHP-Grenzwerte für Dateigröße, Speicherkapazität und Zeitlimits für die Formularverarbeitung. Möglicherweise müssen Sie diese Grenzwerte auf stark eingeschränkten Websites erhöhen, wenn Sie größere Themendateien hochladen.</p>
		<p>Sobald die XML-Datei den Validierungsprozess bestanden hat, wird sie zur Verarbeitung in Schritt 2 an einen temporären Speicherort kopiert.</p>
	</dd>
	<dt>Schritt 2: Verifizierung:</dt>
	<dd>
		<p>Der zweite Schritt dient der Verifizierung und Vorschau des neuen Designs, das aus der XML-Datei erstellt wird. Von hier aus können Sie verschiedene Aspekte des Designs oder Themas anzeigen und bearbeiten.</p>
	</dd>
</dl>
<h4>Designs löschen</h4>
<h3>Vorlagen verwenden</h3>
<h3>Optionen und Einstellungen</h3>
<h3>Upgrade-Hinweise</h3>';
$lang['help_myaccount_admincallout'] = 'Wenn diese Option aktiviert ist, werden administrative Lesezeichen <em>(Schnellzugriffe)</em> aktiviert, sodass Sie eine Liste häufig verwendeter Aktionen im Administrationsbereich verwalten können.';
$lang['help_myaccount_admintheme'] = 'Design der Benutzeroberfläche des Administrationsbereichs auswählen. Verschiedene Designs können unterschiedliche Layouts, Menüstrukturen oder sonstige Funktionen vorweisen.';
$lang['help_myaccount_ce_navdisplay'] = 'Wählen Sie aus, welches Inhaltsfeld in Inhaltslisten angezeigt werden soll. Zu den Optionen gehören der Seitentitel oder der Menütext. Wenn „Keine“ ausgewählt ist, wird die globale Webseiteneinstellung verwendet';
$lang['help_myaccount_dateformat'] = 'Geben Sie eine Datumsformatzeichenfolge an, die bei der Anzeige von Daten verwendet werden soll. Diese Zeichenfolge verwendet das Format <a href=\\
\'http://php.net/manual/en/function.strftime.php\\\' class=\\\'external\\\' target=\\\'_blank\\\'>strftime</a>. <strong>Hinweis:</strong> Einige Erweiterungen von Drittanbietern befolgen diese Einstellung möglicherweise nicht.</strong>';
$lang['help_myaccount_dfltparent'] = 'Geben Sie die übergeordnete Standardseite zum Erstellen einer neuen Inhaltsseite an. Die Verwendung dieser Einstellung hängt auch von Ihren Berechtigungen zum Bearbeiten von Inhalten ab.<br/><br/>Gehen Sie zur ausgewählten übergeordneten Standardseite, indem Sie die oberste übergeordnete Seite und die darauffolgenden untergeordneten Seiten aus den bereitgestellten Aufklapplisten auswählen.<br/><br/>Das Textfeld auf der rechten Seite zeigt immer an, welche Seite aktuell ausgewählt ist.';
$lang['help_myaccount_email'] = 'Geben Sie hier eine E-Mail-Adresse an, die für vergessene Kennwörter und für Benachrichtigungen des Systems oder von sonstigen Modulen verwendet wird.';
$lang['help_myaccount_enablenotifications'] = 'Wenn diese Option aktiviert ist, zeigt das System verschiedene Benachrichtigungen über Dinge an, die bei der Navigation erledigt werden müssen.';
$lang['help_myaccount_firstname'] = 'Geben Sie hier optional ihren Vornamen an; dieser kann in der Administration verwendet werden, oder um E-Mails an Sie zu personalisieren.';
$lang['help_myaccount_hidehelp'] = 'Ist diese Option aktiviert, wird das System Verweise zur Modulhilfe im Administrationsbereich verstecken. In den meisten Fällen ist die Hilfe, die von Modulen bereitgestellt wird, für Entwickler von Webseiten vorgesehen und möglicherweise nicht wirklich nützlich für Bearbeiter von Inhalten.';
$lang['help_myaccount_homepage'] = 'Sie können eine Seite im Administrationsbereich auswählen, auf der Sie direkt landen, wenn Sie sich im hier anmelden. Dies kann nützlich sein, wenn sie hauptsächlich eine bestimmte Funktion auf einer bestimmten Seite nutzen.';
$lang['help_myaccount_ignoremodules'] = 'Wenn Administrationsbenachrichtigungen aktiviert sind, können Sie hier wählen, Benachrichtigungen von bestimmten Modulen zu ignorieren';
$lang['help_myaccount_indent'] = 'Diese Option gibt der Inhaltsauflistung Einrückungen, um über- und untergeordnete Seitenbeziehungen zu verdeutlichen.';
$lang['help_myaccount_language'] = 'Hier kann die Sprache ausgewählt werden, in der die Administrationsoberfläche angezeigt wird; die Liste der verfügbaren Sprachen kann in unterschiedlichen CMS-Installationen variieren, je nachdem welche Sprachpakete installiert sind.';
$lang['help_myaccount_lastname'] = 'Geben Sie hier optional ihren Nachnamen an; dieser kann in der Administration verwendet werden, oder um E-Mails an Sie zu personalisieren.';
$lang['help_myaccount_password'] = 'Bitte geben Sie ein einzigartiges und sicheres Kennwort für die Website an; das Kennwort sollte mehr als sechs Zeichen lang sein und eine Kombination aus Groß- und Kleinbuchstaben, Zahlen und Sonderzeichen sein. Wenn sie das Kennwort nicht ändern wollen, lassen sie das Feld einfach leer.';
$lang['help_myaccount_passwordagain'] = 'Um Fehler zu vermeiden, geben Sie das Kennwort bitte nochmal an; wenn sie das Kennwort nicht ändern wollen, lassen sie das Feld einfach leer.';
$lang['help_myaccount_syntax'] = 'Wählen Sie ein Modul aus, das Syntaxhervorhebung beim Bearbeiten von Code ermöglicht; die Liste der verfügbaren Module kann variieren und ist abhängig von der Konfiguration des Webseitenadministrators.';
$lang['help_myaccount_username'] = 'Ihr Benutzername ist Ihr einzigartiger Name für den Administrationsbereich; bitte nur alphanumerische Zeichen und ggfs. Unterstrich verwenden.';
$lang['help_myaccount_wysiwyg'] = 'Wählen sie aus, welchen <a href="https://de.wikipedia.org/wiki/WYSIWYG" rel="external"><abbr title="„What You See Is What You Get“">WYSIWYG</abbr></a>-Editor sie während der Inhaltsbearbeitung verwenden wollen. Sie können auch „Kein(e)/ohne Vorgabe“ auswählen, wenn sie mit dem Schreiben von HTML-Code vertraut sind; die Liste der verfügbaren Module kann variieren und ist abhängig von der Konfiguration des Webseitenadministrators.';
$lang['settings_adminlog_lifetime'] = 'Diese Einstellung gibt die maximale Zeitspanne an, für die Einträge im Administrationslogbuch behalten werden.';
$lang['settings_autoclearcache'] = 'Die Option ermöglicht die Angabe eines Maximalzeitraums (in Tagen), nach dem Dateien aus dem Zwischenspeicher gelöscht werden. Diese Angabe ist nützlich, um sicherzustellen, dass zwischengespeicherte Dateien regelmäßig neu generiert werden und dass das System nicht mit alten, unnötigen Dateien überladen wird. Empfohlen werden Werte zwischen 14 und 30 Tagen; der Zwischenspeicher wird aber höchtens ein Mal pro Tag geleert.';
$lang['settings_autocreate_flaturls'] = 'Wenn suchmaschinenfreundliche/lesbare URLs aktiviert sind und die Option zum automatischen Erstellen von URLs aktiviert ist, gibt diese Option an, dass diese automatisch erstellten URLs flach sein sollten <em>(d. h.: identisch mit dem Seitenalias)</em>. <strong>Hinweis:</strong> Die beiden Werte müssen nicht identisch bleiben, der URL-Wert kann bei nachfolgenden Seitenbearbeitungen so geändert werden, dass er sich vom Seitenalias unterscheidet.';
$lang['settings_autocreate_url'] = 'Sollen beim Bearbeiten von Inhaltsseiten automatisch suchmaschinenfreundliche/lesbare URLs erstellt werden? Das automatische Erstellen von URLs hat keine Wirkung, wenn lesbare URLs in der CMSMS-Datei config.php nicht aktiviert sind.';
$lang['settings_badtypes'] = 'Wählen Sie aus der Auswahlliste „Inhaltstyp“ aus, welche Inhaltstypen beim Bearbeiten oder Hinzufügen von Inhalten entfernt werden sollen. Diese Funktion ist nützlich, wenn Sie nicht möchten, dass Redakteure bestimmte Inhaltstypen erstellen können. Verwenden Sie <kbd>Strg</kbd>-Klick (Windows/Linux) oder <kbd>Befehl ⌘</kbd>-Klick (Mac), um Elemente auszuwählen bzw. die Auswahl aufzuheben. Wenn keine Elemente ausgewählt sind, bedeutet dies, dass alle Inhaltstypen zulässig sind. <em>(gilt für alle Benutzer)</em>';
$lang['settings_basicattribs2'] = 'In diesem Feld können Sie angeben, welche Inhaltseigenschaften von Benutzern ohne die Berechtigung „Alle Inhalte verwalten“ bearbeitet werden dürfen.<br />Diese Funktion ist nützlich, wenn Sie Inhaltseditoren mit eingeschränkten Berechtigungen haben und die Bearbeitung zusätzlicher Inhaltseigenschaften zulassen möchten.';
$lang['settings_browsercache'] = 'Diese Einstellung gilt nur für zwischenspeicherbare Seiten. Sie gibt an, dass Browser die Seiten für eine bestimmte Zeit zwischenspeichern dürfen. Wenn diese Option aktiviert ist, bemerken wiederkehrende Besucher Ihrer Website Änderungen am Seiteninhalt möglicherweise nicht sofort. Das Aktivieren dieser Option kann jedoch die Leistung Ihrer Website erheblich verbessern.';
$lang['settings_browsercache_expiry'] = 'Geben Sie die Zeitspanne (in Minuten) an, für die Browser Seiten zwischenspeichern sollen. Wenn Sie diesen Wert auf 0 setzen, wird die Funktion deaktiviert. In den meisten Fällen sollten Sie einen Wert größer als 30 angeben.';
$lang['settings_checkversion'] = 'Ist dies aktiviert, prüft das System täglich, ob eine neue Version von CMS Made Simple verfügbar ist.';
$lang['settings_contentimage_path'] = 'Diese Einstellung wird verwendet, wenn eine Seitenvorlage das Tag <code>{content_image}</code> enthält. Das hier angegebene Verzeichnis wird verwendet, um eine Auswahl von Bildern bereitzustellen, die dem Tag zugeordnet werden.<br /><br />Geben Sie relativ zum Upload-Pfad einen Verzeichnisnamen an, der die Pfade mit Dateien für das Tag <code>{content_image}</code> enthält. Dieser Wert wird als Standard für den Parameter „dir“ verwendet.';
$lang['settings_cssnameisblockname'] = 'Wenn aktiviert, wird der Inhaltsblockname <em>(id)</em> als Standardwert für den cssname-Parameter jedes Inhaltsblocks verwendet.<br/><br/>Dies ist für visuelle Editoren nützlich. Das Stylesheet (Blockname) kann vom visuellen Editor geladen werden und bietet ein Erscheinungsbild, das dem der Webseite näher kommt.<br/><br/><strong>Hinweis:</strong> visuelle Editoren lesen je nach ihren Einstellungen und Fähigkeiten möglicherweise keine Informationen aus den bereitgestellten Stylesheets (sofern vorhanden).';
$lang['settings_disablesafemodewarn'] = 'Diese Option deaktiviert eine Warnmeldung, wenn CMSMS feststellt, dass der <a href=\\\'http://php.net/manual/en/features.safe-mode.php\\\' class=\\\'external\\\' target=\\\'_blank\\\'>PHP-Abgesicherter Modus</a> erkannt wurde.<br /><br /><strong>Hinweis:</strong> Der Abgesicherte Modus ist seit PHP 5.3.0 veraltet und wurde für PHP 5.4.0 entfernt. CMSMS unterstützt den Betrieb im Abgesicherten Modus nicht und unser Supportteam leistet keine technische Unterstützung für Installationen, bei denen der Abgesicherte Modus aktiv ist.';
$lang['settings_enablenotifications'] = 'Mit dieser Option werden Benachrichtigungen in jeder Administratoranfrage oben auf der Seite angezeigt. Dies ist nützlich für wichtige Benachrichtigungen über das System, die möglicherweise eine Benutzeraktion erfordern. Jeder Administrator kann Benachrichtigungen in seinen Einstellungen deaktivieren.';
$lang['settings_enablesitedown'] = 'Mit dieser Option können Sie die Website für Besucher deaktivieren und ihnen eine Wartungsmitteilung anzeigen.';
$lang['settings_enablewysiwyg'] = 'Den visuellen Editor im Textbereich unten aktivieren';
$lang['settings_imagefield_path'] = 'Diese Einstellung wird beim Bearbeiten von Inhalten verwendet. Das hier angegebene Verzeichnis wird verwendet, um eine Liste von Bildern bereitzustellen, aus denen der Inhaltsseite ein Bild zugeordnet werden kann.<br/></br/>Geben Sie relativ zum Bild-Upload-Pfad einen Verzeichnisnamen an, der die Pfade mit den Dateien für das Bildfeld enthält.';
$lang['settings_lock_timeout'] = 'Geben Sie einen Standardwert (in Minuten) für die Dauer von Sperren ein. Dies wird verwendet, wenn eine Funktion keinen benutzerdefinierten Wert für die Dauer von Sperren bereitstellt.';
$lang['settings_mailprefs_from'] = 'Diese Option steuert die <em>Standardadresse<em>, die CMSMS zum Senden von E-Mail-Nachrichten verwendet. Dies kann nicht einfach irgendeine E-Mail-Adresse sein. Sie muss mit der von der Website bereitgestellten Domäne übereinstimmen. Die Angabe einer persönlichen E-Mail-Adresse aus einer anderen Domäne wird als "<a href=\\\'https://en.wikipedia.org/wiki/Open_mail_relay\\\' class=\\\'external\\\' target=\\\'_blank\\\'>Relaying</a>" bezeichnet und führt höchstwahrscheinlich dazu, dass E-Mails nicht gesendet oder vom E-Mail-Server des Empfängers nicht akzeptiert werden. Ein typisches gutes Beispiel für dieses Feld ist noreply@meinedomain.com';
$lang['settings_mailprefs_fromuser'] = 'Hier können Sie einen Namen angeben, der mit der oben angegebenen E-Mail-Adresse verknüpft werden soll. Dieser Name kann beliebig sein.';
$lang['settings_mailprefs_mailer'] = 'Diese Auswahl steuert, wie CMSMS E-Mails versendet. Mithilfe der mail-Funktion von PHP, sendmail, oder durch direkte Kommunikation mit einem SMTP-Server.<br/><br/>Die Option „mail“ sollte bei den meisten gemeinsam genutzten Hosts funktionieren, jedoch wird sie mit ziemlicher Sicherheit auf den meisten selbst gehosteten Windows-Installationen nicht funktionieren.<br/><br/>Die Option „sendmail“ sollte auf den meisten richtig konfigurierten selbst gehosteten Linux-Servern funktionieren. Allerdings wird sie möglicherweise bei gemeinsam genutzten Hosts nicht funktionieren.<br/><br/>Die SMTP-Option erfordert Konfigurationsinformationen von Ihrem Hostinganbieter.';
$lang['settings_mailprefs_sendmail'] = 'Wenn Sie die Mailer-Methode „sendmail“ verwenden, müssen Sie den vollständigen Pfad zum binären Sendmail-Programm angeben. Ein typischer Wert für dieses Feld ist „/usr/sbin/sendmail“. Diese Option wird bei Windows-Hosts normalerweise nicht verwendet.<br/><br/><strong>Hinweis:</strong> Wenn Sie diese Option verwenden, muss Ihr Hostinganbieter die PHP-Funktionen „popen“ und „pclose“ zulassen, die auf gemeinsam genutzten Hosts häufig deaktiviert sind.';
$lang['settings_mailprefs_smtpauth'] = 'Wenn Sie den SMTP-Mailer verwenden, gibt diese Option an, dass der SMTP-Server eine Authentifizierung zum Senden von E-Mails erfordert. Sie müssen dann <em>(mindestens)</em> einen Benutzernamen und ein Passwort angeben. Ihr Hostinganbieter sollte angeben, ob eine SMTP-Authentifizierung erforderlich ist, und Ihnen in diesem Fall einen Benutzernamen und ein Passwort sowie optional eine Verschlüsselungsmethode bereitstellen.<br/><br/><strong>Hinweis:</strong> SMTP-Authentifizierung ist erforderlich, wenn Ihre Domain Google-Apps für E-Mails verwendet.';
$lang['settings_mailprefs_smtp_smtpautotls'] = 'Bei Verwendung des SMTP-Mailers gibt diese Option an, ob die TLS-Verschlüsselung automatisch aktiviert werden soll, wenn ein Server sie unterstützt. Diese Einstellung ist auch gültig, wenn die <em>Verschlüsselungsmethode</em> nicht auf <em>TLS</em> eingestellt ist. Sie erfordert außerdem, dass die Zertifikate des Servers gültig sind.<br> Einige wenige Hostinganbieter legen sehr strenge (bis fast nutzlose) Beschränkungen für das Senden einer E-Mail fest. Sie blockieren ausgehendes SMTP an die Ports 25, 465 und 587 an alle Server außer ihrem eigenen. Wenn Sie feststellen, dass Ihr Skript auf Ihrem lokalen Computer funktioniert, aber nicht, wenn Sie es auf einen entfernten Server hochladen, kann dies der Grund sein. Die Lösung ist in den meisten Fällen schlecht dokumentiert: Senden über ihre Server, während alle Sicherheitsfunktionen wie Benutzername, Passwort und automatische TLS-Verschlüsselung deaktiviert werden, die standardmäßig <strong>aktiviert</strong> ist.';
$lang['settings_mailprefs_smtphost'] = 'Bei Verwendung des SMTP-Mailers gibt diese Option den Hostnamen <em>(oder die IP-Adresse)</em> des SMTP-Servers an, der beim Senden von E-Mails verwendet werden soll. Den richtigen Wert erfahren Sie möglicherweise von Ihrem Hostinganbieter.';
$lang['settings_mailprefs_smtppassword'] = 'Dies ist das Kennwort für die Verbindung mit dem SMTP-Server, wenn die SMTP-Authentifizierung aktiviert ist.';
$lang['settings_mailprefs_smtpport'] = 'Bei Verwendung des SMTP-Mailers gibt diese Option die Portnummer für den SMTP-Server an. In den meisten Fällen ist dieser Wert 25, Sie müssen sich jedoch möglicherweise an Ihren Hostinganbieter wenden, um den richtigen Wert zu erfahren.';
$lang['settings_mailprefs_smtpsecure'] = 'Diese Option gibt bei Verwendung der SMTP-Authentifizierung einen Verschlüsselungsmechanismus an, der bei der Kommunikation mit dem SMTP-Server verwendet werden soll. Ihr Hostinganbieter sollte diese Informationen bereitstellen, wenn eine SMTP-Authentifizierung erforderlich ist.';
$lang['settings_mailprefs_smtptimeout'] = 'Bei Verwendung des SMTP-Mailers gibt diese Option die Anzahl der Sekunden an, bevor ein Verbindungsversuch zum SMTP-Server fehlschlägt. Ein typischer Wert für diese Einstellung ist 60.<br/><br/><strong>Hinweis:</strong> Wenn Sie hier einen längeren Wert benötigen, deutet dies wahrscheinlich auf ein zugrunde liegendes DNS-, Routing- oder Firewall-Problem hin und Sie müssen möglicherweise Ihren Hostinganbieter kontaktieren.';
$lang['settings_mailprefs_smtpusername'] = 'Dies ist der Benutzername für die Verbindung mit dem SMTP-Server, wenn die SMTP-Authentifizierung aktiviert ist.';
$lang['settings_mailtest_testaddress'] = 'Geben Sie eine gültige E-Mail-Adresse an, an die die Test-E-Mail gesendet wird.';
$lang['settings_mandatory_urls'] = 'Wenn suchmaschinenfreundliche/lesbare URLs aktiviert sind, gibt diese Option an, ob Seiten-URLs ein Pflichtfeld im Inhaltseditor sind.';
$lang['settings_nosefurl'] = 'Um suchmaschinenfreundliche/lesbare URLs zu konfigurieren, müssen Sie einige Zeilen in Ihrer config.php-Datei bearbeiten und möglicherweise eine .htaccess-Datei oder die Konfiguration Ihres Webservers bearbeiten. Weitere Informationen zum Konfigurieren lesbarer URLs finden Sie in der <a href=\\\'https://docs.cmsmadesimple.org/configuration/pretty-url\\\' class=\\\'external\\\' target=\\\'blank\\\'>CMS-Dokumentation</a>.';
$lang['settings_pseudocron_granularity'] = 'Diese Einstellung gibt an, wie oft das System versucht, regelmäßig geplante Aufgaben auszuführen.';
$lang['settings_searchmodule'] = 'Wählen Sie das Modul aus, das zum Indizieren von Wörtern für die Suche verwendet werden soll und die Suchfunktionen der Website bereitstellt.';
$lang['settings_sitedownexcludeadmins'] = 'Die Website Administratoren anzeigen, die im CMSMS-Administrationsbereich angemeldet sind';
$lang['settings_sitedownexcludes'] = 'Die Website diesen IP-Adressen anzeigen';
$lang['settings_sitedownmessage'] = 'Die Nachricht, die Ihren Webseitenbesuchern angezeigt wird, wenn die Website wegen Wartungsarbeiten nicht verfügbar ist';
$lang['settings_smartycaching'] = 'Wenn aktiviert, wird die Ausgabe verschiedener Plugins zwischengespeichert, um die Leistung zu verbessern. Darüber hinaus werden die meisten Teile kompilierter Vorlagen zwischengespeichert. Dies gilt nur für die Ausgabe auf Inhaltsseiten, die als zwischenspeicherbar markiert sind, und nur für Benutzer ohne Administratorrechte. Beachten Sie, dass diese Funktion das Verhalten einiger Module oder Plugins oder Plugins, die nicht-Inline-Formulare verwenden, beeinträchtigen kann.<br/><br/><strong>Hinweis:</strong> Wenn Smarty-Caching aktiviert ist, werden „globale Inhaltsblöcke“ immer von Smarty zwischengespeichert und benutzerdefinierte Tags werden nie zwischengespeichert. Darüber hinaus werden Inhaltsblöcke nie zwischengespeichert.';
$lang['settings_smartycompilecheck'] = 'Wenn diese Option deaktiviert ist, überprüft Smarty nicht die Änderungszeiten von Vorlagen, um festzustellen, ob sie geändert wurden. Dies kann die Leistung erheblich verbessern. Allerdings kann das Durchführen einer Vorlagenänderung (oder sogar einiger Inhaltsänderungen) eine Leerung des Zwischenspeichers erfordern.';
$lang['settings_thumbfield_path'] = 'Diese Einstellung wird beim Bearbeiten von Inhalten verwendet. Das hier angegebene Verzeichnis wird verwendet, um eine Liste von Bildern bereitzustellen, aus denen der Inhaltsseite ein Vorschaubild zugeordnet werden kann.<br/><br/>Geben Sie relativ zum Bild-Upload-Pfad einen Verzeichnisnamen an, der die Pfade mit den Dateien für das Bildfeld enthält. Normalerweise ist dies derselbe Pfad wie oben.';
$lang['settings_umask'] = 'Die „umask“ ist ein Oktalwert, der verwendet wird, um die Standardberechtigung für neu erstellte Dateien anzugeben (dies wird für Dateien im Cache-Verzeichnis und hochgeladene Dateien verwendet). Weitere Informationen finden Sie im entsprechenden <a href=\\\'http://en.wikipedia.org/wiki/Umask\\\' class=\\\'external\\\' target=\\\'_blank\\\'>Wikipedia-Artikel.</a>';
$lang['siteprefs_lockrefresh'] = 'Dieses Feld gibt die Mindesthäufigkeit (in Minuten) an, mit der der Ajax-basierte Sperrmechanismus eine Sperre „berühren“ soll. Ein idealer Wert für dieses Feld ist 5.';
$lang['siteprefs_locktimeout'] = 'Dieses Feld gibt die Anzahl der Minuten der Inaktivität an, bevor eine Sperre abläuft. Nach Ablauf der Sperre können andere Benutzer die Sperre aufheben. Damit eine Sperre nicht abläuft, muss sie vor Ablauf der Sperre „berührt“ werden. Dadurch wird die Ablaufzeit der Sperre zurückgesetzt. In den meisten Fällen sollte eine Sperre von 60 Minuten ausreichend sein.';
$lang['siteprefs_sitename'] = 'Dies ist ein für Menschen lesbarer Name für Ihre Website, z. B. der Name Ihres Unternehmens, Vereins oder Ihrer Organisation.';
$lang['siteprefs_frontendlang'] = 'Die Standardsprache, die Ihre Website im öffentlichen Bereich anzeigt. Dies kann seitenweise mithilfe verschiedener Smarty-Tags geändert werden. z. B.: <code>{cms_set_language}</code>';
$lang['siteprefs_frontendwysiwyg'] = 'Welches WYSIWYG-Modul sollte verwendet werden, wenn visuelle Editoren für Frontend-Formulare bereitgestellt werden?';
$lang['siteprefs_nogcbwysiwyg'] = 'Diese Option deaktiviert den visuellen Editor für alle globalen Inhaltsblöcke unabhängig von den Benutzereinstellungen oder für die einzelnen globalen Inhaltsblöcke.';
$lang['siteprefs_globalmetadata'] = 'In diesem Textbereich können Sie Metainformationen eingeben, die für alle Inhaltsseiten relevant sind. Dies ist ein idealer Ort für Meta-Tags wie „charset“, „viewport“, „Generator“, „Autor“ usw.';
$lang['siteprefs_logintheme'] = 'Wählen Sie das Admin-Design (aus den installierten Admin-Designs) aus, das zum Generieren des Administrator-Anmeldeformulars und als Standard-Anmeldedesign für neue Admin-Benutzerkonten verwendet wird. Admin-Benutzer können ihr bevorzugtes Admin-Design im Bereich „Benutzereinstellungen“ auswählen.';
$lang['siteprefs_backendwysiwyg'] = 'Wählen Sie den visuellen Editor für neu erstellte Administratorbenutzerkonten. Administratorbenutzer können ihren bevorzugten visuellen Editor in den Benutzereinstellungen auswählen.';
$lang['siteprefs_dateformat'] = '<p>Geben Sie die Datumsformatzeichenfolge im Format <a href=\\\'https://www.php.net/manual/en/function.strftime.php\\\' class=\\\'external\\\' rel=\\\'noopener noreferrer\\\' target=\\\'_blank\\\'>PHP strftime</a>an, das <em>(standardmäßig)</em> zum Anzeigen von Datum und Uhrzeit auf Ihrer Website verwendet wird.</p><p>Administratoren können diese Einstellungen in den Benutzereinstellungen anpassen.</p><p><strong>Hinweis:</strong> Einige Module zeigen Uhrzeit und Datum möglicherweise anders an.</p>';
$lang['siteprefs_thumbwidth'] = 'Geben Sie eine Breite <em>(in Pixeln)</em> an, die standardmäßig beim Generieren von Vorschaubildern aus hochgeladenen Bilddateien verwendet werden soll. Vorschaubilder werden normalerweise im Administrationsbereich der Dateiverwaltung oder beim Auswählen eines Bilds zum Einfügen in den Seiteninhalt angezeigt. Einige Module verwenden Vorschaubilder jedoch möglicherweise in der öffentlichen Website.<br/><br/><strong>Hinweis:</strong> Einige Module verfügen möglicherweise über zusätzliche Einstellungen zum Generieren von Vorschaubildern und ignorieren diese Einstellung.';
$lang['siteprefs_thumbheight'] = 'Geben Sie eine Höhe <em>(in Pixeln)</em> an, die standardmäßig beim Generieren von Vorschaubildern aus hochgeladenen Bilddateien verwendet werden soll. Vorschaubilder werden normalerweise im Administrationsbereich der Dateiverwaltung oder beim Auswählen eines Bilds zum Einfügen in den Seiteninhalt angezeigt. Einige Module verwenden Vorschaubilder jedoch möglicherweise in der öffentlichen Website.<br/><br/><strong>Hinweis:</strong> Einige Module verfügen möglicherweise über zusätzliche Einstellungen zum Generieren von Vorschaubildern und ignorieren diese Einstellung.';
?>