<?php

#A
$lang['additional_editors'] = 'Additional Editors';
$lang['apply'] = 'Apply';
$lang['asc'] = 'Ascending';
$lang['any'] = 'Any';
$lang['attached_stylesheets'] = 'Attached Stylesheets';
$lang['attached_templates'] = 'Attached Templates';
$lang['available_stylesheets'] = 'Available Stylesheets';
$lang['available_templates'] = 'Available Templates';

#B
$lang['bulk_action_delete'] = 'Bulk deletion of templates';
$lang['bulk_action_delete_css'] = 'Bulk Deletion of stylesheets';
$lang['bulk_action_export_css'] = 'Export multiple stylesheets to Files';
$lang['bulk_action_import_css'] = 'Import multiple stylesheets from Files';
$lang['bulk_action_export'] = 'Export multiple templates to files';
$lang['bulk_action_import'] = 'Import multiple templates from files';

#C
$lang['cancel'] = 'Cancel';
$lang['category_saved'] = 'Category Saved';
$lang['confirm_bulk_css_1'] = 'Yes, I am sure I want to perform this operation on multiple stylesheets.';
$lang['confirm_bulk_css_2'] = 'Yes, I am <strong>really</strong> sure I want to act on multiple stylesheets.';
$lang['confirm_bulk_template_1'] = 'Yes, I am sure I want to perform this operation on multiple templates.';
$lang['confirm_bulk_template_2'] = 'Yes, I am <strong>really</strong> sure I want to act on multiple templates.';
$lang['confirm_bulk_tmplop'] = 'Are you sure you want to perform this action on multiple templates?';
$lang['confirm_clearlocks'] = 'Clearing locks could disrupt existing editing sessions.  Are you sure you want to continue?';
$lang['confirm_delete_1'] = 'Are you sure you want to delete this design?';
$lang['confirm_delete_2a'] = 'Yes, I am sure I want to delete this item';
$lang['confirm_delete_2b'] = 'Yes, I am <strong>really</strong> sure I want to delete this item';
$lang['confirm_delete_category'] = 'Are you sure you want to delete this category?';
$lang['confirm_delete_css_1'] = 'Yes, I am sure I want to delete this stylesheet';
$lang['confirm_delete_css_2'] = 'Yes, I am <strong>really</strong> sure I want to delete this stylesheet';
$lang['confirm_delete_template_1'] = 'Yes, I am sure I want to delete this template';
$lang['confirm_delete_template_2'] = 'Yes, I am <strong>really</strong> sure I want to delete this template';
$lang['confirm_import'] = 'Confirm Import Design';
$lang['confirm_import_1'] = 'Yes, I am sure I want to import this design';
$lang['confirm_reset_type'] = "Reset the default content of this type to the version distributed with the system (or module)?\n\nResetting this will only affect newly created templates of this type.  No existing templates will be adjusted.";
$lang['confirm_save_design'] = 'This design has been changed.  Continuing will save the design, and allow you to edit the item.\nDo you want to continue?';
$lang['confirm_setall_1'] = 'Please confirm that you wish to set all content pages to use this template';
$lang['confirm_setall_2'] = 'Yes, I am sure';
$lang['confirm_setall_3'] = 'Yes, I am <strong>really</strong> sure';
$lang['confirm_steal_lock'] = 'Are you sure you want to steal this lock?  This will destroy any of the other users unsaved work.';
$lang['confirm_template_setall'] = 'Setting all pages to use this template may cause problems with a working site.  Use extreme caution!';
$lang['copy_stylesheet'] = 'Copy Stylesheet';
$lang['copy_template'] = 'Copy Template';
//$lang['close'] = 'Close';
$lang['create'] = 'Create';
$lang['created'] = 'Created';
$lang['create_category'] = 'Create a new Category';
$lang['create_design'] = 'Create a new Design';
$lang['create_stylesheet'] = 'Create a new Stylesheet';
$lang['create_template'] = 'Create a new Template';
$lang['css_filter'] = 'Filter Stylesheets';
$lang['category_reordered'] = 'Category order changed';

#D
$lang['delete_attached_stylesheets'] = 'Delete attached and orphaned stylesheets';
$lang['delete_attached_templates'] = 'Delete attached and orphaned templates';
$lang['delete_design'] = 'Delete Design';
$lang['delete_stylesheet'] = 'Delete Stylesheet';
$lang['delete_template'] = 'Delete Template';
$lang['desc'] = 'Descending';
$lang['desc_designmanager_settings'] = 'Adjust settings related to managing designs (templates and stylesheets)';
$lang['drop_items'] = 'Drop selected items here';

#E
$lang['edit_category'] = 'Edit Category';
$lang['edit_design'] = 'Edit Design';
$lang['edit_stylesheet'] = 'Edit Stylesheet';
$lang['edit_template'] = 'Edit Template';
$lang['edit_type'] = 'Edit Template Type';
$lang['error_assets_writeperm'] = 'Sorry, the templates directory under your assets path or some of the files within it, either do not exist or are not writable.';
$lang['error_assets_readwriteperm'] = 'Sorry, the template file for import either does not exist, or has permissions problems.';
$lang['error_bulkexport_noneprocessed'] = 'Sorry, all of these templates were already exported.';
$lang['error_bulkimport_noneprocessed'] = 'Sorry, none of those templates had files to import.';
$lang['error_contentlocked'] = 'Sorry, This content is already locked by another user.  Please refresh the page.';
$lang['error_create_tempfile'] = 'Error creating temporary file';
$lang['error_direxists'] = 'Directory %s already exists';
$lang['error_fileopen'] = 'Could not open %s for reading.  Permissions problem?';
$lang['error_filenotfound'] = 'Could not find a file we were expecting: %s';
$lang['error_missingparam'] = 'A required parameter is missing or invalid';
$lang['error_nofileuploaded'] = 'No file was uploaded';
$lang['error_notconfirmed'] = 'The action was not confirmed';
$lang['error_notemplates'] = 'No Editable Templates Found';
$lang['error_nothingselected'] = 'Nothing selected';
$lang['error_notwritable'] = 'Directory %s is not writeable';
$lang['error_permission'] = 'Permission Denied';
$lang['error_permission_deletetemplate'] = 'You do not have permission to perform the bulk operation on one or more of the selected items';
$lang['error_readxml'] = 'A problem occurred reading the XML file (possible syntax error)';
$lang['error_uploading'] = 'Problem uploading file (perhaps it is too large)';
$lang['error_upload_filetype'] = 'The file uploaded is not of the proper type (%s)';
$lang['error_xmlstructure'] = 'Error in the structure of the XML File';
$lang['error_nophysicalfile'] = 'An error occurred parsing the stylesheets, and/or templates of the design.  The URL %s could not be located as a physical file.  This probably indicates that the template and/or stylesheets of this theme are using advanced logic that the design manager cannot process.';
$lang['export'] = 'Export';
$lang['export_design'] = 'Export Design to XML';

#F
$lang['filter'] = 'Filter';
$lang['filterapplied'] = 'Filter Applied';
$lang['friendlyname'] = 'Design Manager';

#G
$lang['go'] = 'Go';

#H
/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
$lang['help'] = <<<EOT
<h3>What does this do?</h3>
  <p>The &quot;DesignManager&quot; module is a mechanism to comprehensively manage the various templates, stylesheets, and &quot;designs&quot; used in your website.  It provides convenient sorting, filtering, and organization mechanisms for these various primary elements.</p>

<h3>What is a &quot;Design&quot; ?</h3>
  <p>A &quot;Design&quot; is an entity that manages in one logical unit the various templates and stylesheets that are required for a particular look and feel on a website.</p>
  <p>The design contains a list of stylesheets, and manages the order of those stylesheets.  It also contains a list of templates <em>(of various types)</em> that are associated.   Designs can be exported to XML for sharing, and can be imported from XML.</p>

<h3>Templates Explained:</h3>
<p>A template is a collection of HTML and/or smarty code.  Templates are usually re-used multiple times on a website, and can include or inherit from other templates.  CMSMS provides numerous templates for various purposes.  These purposes include defining the structure of a web page, a navigation menu, or displaying news article summaries or details.<p>
<p>Each template must have a name that must be unique across the entire installation.  Additionally, each template is capable of having a description that allows providing human readable information and notes about the characteristics of the template.  You can optionally assign each template to a category to aide in quickly finding the template when edits are required.</p>
<p>Templates can optionally be associated with one or more designs.  This helps when needing to quickly find a template to edit.  As well, when exporting a design all the templates that are associated with the design will be exported.</p>
<p>Depending upon the template type <em>(see below)</em> A template can be set as the &quot;default&quot; for that type.  This functionality allows a module to find a template to use of an appropriate type if no template name is specified in the module tag, or via any other means.  For example, in a default installation the &quot;News Summary Sample&quot; template is the default template for the News default <em>(summary)</em> action.  Therefore calling <em>{News}</em> without specifying a template will use this template.</p>
<p>Optionally, you can select one or more admin user accounts, or admin user groups that have the ability to edit the template.  This gives the ability for restricted users to have limited access to some templates.  This may be useful for editing seasonal messages, or for modifying API keys or RSS feed URLS.</p>
<p>When templates are edited the user(s) selected syntax highlighter module will be used, assuming that a syntax highlighter module has been installed, and that the user has selected one from within his user preferences.</p>
<p>To call a template you can either specify the template name in a module call or explicitly call/include the template from another one with the <code>{include file='cms_template:&lt;template_name&gt;'}</code> syntax.  See the smarty {include} tag.  Additionally, for backwards compatibility purposes the <code>{global_content name='&lt;template_name&gt;'}</code> syntax still works.</p>

<h4>Template Types Explained:</h4>
<p>A template type loosely indicates the general purpose for the template.  Template types indicate the module or code that uses them, and a subtype.  For example two common template types are Core::Page indicating a template used by the core CMSMS system to structure a web page, and News::Summary indicating a template that the News module can use to create a summary listing.</p>
<p>Modules may create new template types on installation, and delete template types when they uninstall.  Most modules will delete all templates that are associated with its types when the module is uninstalled.</p>
<p>Template types can optionally contain a &quot;Prototype Template&quot;.  The prototype is used when creating a new template of that type.  For example, if you create a new template of type &quot;News::Detail&quot; the template will initially be filled with the prototype data from that type.  You can then change the template to your liking.</p>

<h3>Categories Explained:</h3>
<p>Templates can be associated with a single category merely as a method of organizing templates.  The DesignManager interface allows filtering types by category so that you can more easily find a template to edit.</p>

<h3>Stylesheets Explained:</h3>
<p>Stylesheets are text data that are stored in the database, and allow you to enter CSS data that is associated with zero or more designs.   Each stylesheet must have a unique name, has an optional description, and an optional media query.</p>
<p>You can associate each stylesheet with one or more designs, and specify the order of the stylesheets within the design.  When a content page is rendered, all of the stylesheets associated with the design will be combined, and output to a file to allow cashing by the browser.</p>
<p>Stylesheets can include smarty tags to allow doing logic within the stylesheet, or creating variables for reuse.  However instead of the normal { and } delimiters for smarty, the [[  and ]] delimiters are used.  For example:</p>
<pre><code><span style="color: blue;">[[&#36;red='#f00']]</span>
div.error {
   color: <span style="color: blue;">[[&#36;red]]</span>;
}
</code></pre>
<p><strong>Note:</strong> Due to the fact that stylesheets can be associated with zero or more designs, and/or called individually, and that stylesheets are combined and cached for all visitors, on the browser you must use caution when including smarty in templates.  Here are a few notes:</p>
  <ul>
    <li>Never put server specific conditions, state conditions, time related, or page specific conditions into a stylesheet.</li>
    <li>You should assume that each stylesheet may be called individually, therefore smarty variable initialization should be placed in each stylesheet.</li>
  </ul>
<p><strong>Note:</strong> You can include other templates inside of stylesheets using the <code>[[include file='cms_template::&lt;template_name&gt;']]</code> syntax as mentioned above however you must be aware of the change in smarty delimiters when processing stylesheets.  For example:</p>

  <ul>
    <li>Stylesheet &quot;page&quot;<br/>
<pre><code><span style="color: blue;">[[include file='cms_template::my_colors']]</span>
body {
  background-color: <span style="color: blue;">[[&#36;my_background]]</span>;
  color: <span style="color: blue;">[[&#36;dflt_foreground]]</span>;
}
</code></pre>
    </li>
    <li>Template: &quot;my_colors&quot;<br/>
<pre><code style="color: blue;">[[&#36;my_background='#fff']]
[[&#36;dflt_foreground='#000']]
</code></pre>
    </li>
  </ul>

<h3>How do Content Pages Figure In?</h3>
<p>A template <em>(usually of type Core::Page)</em> is associated with each content page; this determines the content blocks and types of content blocks that are displayed in the editcontent page, and is used to determine how the content data is rendered as an HTML page. Additionally, a design is associated with each content page; this is used to determine the stylesheets that will be associated with the content page, and the order of those stylesheets.</p>
<p>It is not mandatory that the template associated with a content page be of type <em>Core::Page</em> as the template type is just used for organizational purposes.</p>

<h3>Importing and Exporting:</h3>
<p>DesignManager supports functionality to export a complete design (including templates, stylesheets, images, descriptions, and stylesheet order) to an XML format for use on another compatible CMS Made Simple website.  To export a design just click on the export icon on each design row on the Designs tab of the Design Manager admin panel.</p>
<p>The system will find all of the templates and stylesheets attached with a design, and for each template parse the template to find templates that are <strong>directly</strong> included via module calls or the include statement, and attach them.  It will also find links to local images, and include those files in the output xml file.  Similarly stylesheets are parsed for links to local images, and those images are included in the xml file.</p>

<h3>Template Locking:</h3>
<p>In order to prevent one designer or site developer from accidentally overwriting the work of another developer the DesignManager provides locking for templates.  When a site developer begins an edit session on a template the template is locked from edits from other developers.</p>
<p>Frequently, during the edit session the software pings the server to indicate that the developer is still working on the template.  If edit activity on the template ceases for a period of time, other developers can &quot;steal&quot; the lock.  Any unsaved changes by the first developer would be lost.</p>
<p><strong>Note:</strong> At this time there is no locking functionality for stylesheets.</p>

<h3>Permissions and Visibility</h3>
<p>Numerous permissions are used to control access to the DesignManager module and its visibility in the CMSMS Admin navigation:</p>
<ul>
  <li>Add Templates:
    <p>Logged in admin users with this permission have the ability to create new templates, but not to modify any existing templates <em>(that they do not otherwise have access to)</em></p>
  </li>
  <li>Modify Templates:
    <p>Logged in admin users with this permission have the ability to completely manage templates, including adding/editing/deleting.  They can also adjust the ownership, and additional editors of a template.</li>
  </li>
  <li>Manage Stylesheets:
    <p>Logged in admin users with this permission have the ability to completely manage stylesheets.  There is no functionality for ownership and additional editors of stylesheets.</p>
  </li>
  <li>Manage Designs:
    <p>Logged in admin users with this permission have the ability to manage designs, including importing and exporting designs.  When importing a design the currently logged in user is marked as the owner for all new templates and stylesheets.</p>
  </li>
  <li>Owner:
    <p>The owner of at least one template can view the module in the admin navigation, and edit or delete the templates he owns.  He can also grant additional editor rights to other users or admin groups.</p>
  </li>
  <li>Additional Editor:
    <p>An admin user who has been marked as an &quot;Additional Editor&quot; to one or more templates can view the module in the admin navigation, and edit the template including its description.  However he cannot change any associations of this template, delete the template or grant additional privileges to other users.</p>
  </li>
</ul>

<h3>History:</h3>
<p>Prior to the development of the DesignManager module in CMSMS 2.0 each separate section, and each module managed their own templates.  This meant that module management had different interfaces for each different type of template.  CMS Made Simple provided a table to store module templates, and various methods in the module API to allow interfacing with those templates.  However, each module was responsible for its own functionality for managing its templates.</p>

<h3>Compatibility:</h3>
<p>For compatibility purposes, the old method of managing module templates has been kept. <em>(This functionality is <strong>deprecated</strong> and may be removed at a future date.)</em>  Therefore until modules migrate their functionality to use the new APIs for managing template types, templates and stylesheets you may still have to visit numerous different admin pages and experience different interfaces to manage the templates of those modules.</p>
<br />
EOT;
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

$lang['help_bulk_templates'] = 'This option allows performing actions on many templates at one time.  Only the templates selected will be operated upon.';
$lang['help_category_desc'] = 'A description for a template category is optional, but may help when organizing templates';
$lang['help_category_name'] = 'A category name is required, and must be unique';
$lang['help_create'] = 'This option will allow you to create a new template of the selected type';
$lang['help_create_template'] = 'This function allows creating a new template of the selected template type.  The default contents from the template type will be used';
$lang['help_css_bulk'] = 'This option allows performing actions on multiple stylesheets at one time.';
$lang['help_css_description'] = 'You may (optionally) include a description for this stylesheet.  This may be useful to describe the items that are in the stylesheet and aide in organization';
$lang['help_css_designs'] = 'You may associate one or more designs with a stylesheet.  Stylesheets associated with a design are automatically output by the {cms_stylesheet} tag, and when exporting a design for sharing';
$lang['help_css_mediaquery'] = <<<EOT
<p>A media query consists of a media type and at least one expression that limits the style sheets' scope by using media features, such as width, height, and color. Added in CSS3, media queries let the presentation of content be tailored to a specific range of output devices without having to change the content itself. For a simple reference see this page on the <a href="https://developer.mozilla.org/en/docs/CSS/Media_queries">Mozilla developer network</a></p><br/>
<p>CMSMS Allows associating a media query with a stylesheet.  When <code>{cms_stylesheet}</code> renders its output the media query will be automatically placed in the stylesheet tag.</p>
EOT;
$lang['help_design_name'] = 'This field contains the unique, logician name for the collection of templates and stylesheets';
$lang['help_design_created'] = 'This is the date the design was originally created';
$lang['help_design_description'] = 'Specify a description for this design (text only).  This may be useful for your future reference, or when sharing this design with others';
$lang['help_design_modified'] = 'The date the design was last modified';
$lang['help_has_dflt'] = 'If &quot;Yes&quot;, this template type has some default content that is used as a sample when creating a new template of this type.  Of course you are able to change the contents of the template';
$lang['help_import_cmsversion'] = 'This design file was generated from an earlier version of CMSMS.  This may cause difficulties, please use caution!';
$lang['help_import_created'] = 'This is the date that the XML file was created.  For themes created from the older CMSMS Theme manager there is no embedded creation date so &quot;unknown&quot; will be displayed';
$lang['help_import_newname'] = 'If you already have a design with the name specified, the system will suggest a new design name.  You must ensure that the design name you create is unique';
$lang['help_import_xml_file'] = 'Select an XML File to import.  The XML file have been generated by the CMSMS Design Manager, or by the older CMSMS Theme Manager';
$lang['help_lockrefresh'] = 'Specify the maximum number of seconds before a lock should be refreshed.  Setting a value of 0 will disable refreshing of locks.  <strong>Note:</strong> Locks are not refreshed unless there are some changes in the form.  The minimum value for this field (other than 0) is 30.';
$lang['help_locktimeout'] = 'Specify the minimum number of minutes after which a non-refreshed lock will expire.  Specifying a value of 0 will disable locking all together.  Minimum is 5 and maximum is 480';
$lang['help_move_down'] = 'Move the selected item down';
$lang['help_move_left'] = 'Remove the selected item from the target list';
$lang['help_move_right'] = 'Move the selected item to the target list.  You may also be able to adjust the order of the item in the target list, with the up and down buttons';
$lang['help_move_up'] = 'Move the selected item up';
$lang['help_proto_template'] = 'The prototype template contains the contents that are used when you create a new template of this type.  It is not used during frontend processing';
$lang['help_rm_tpl'] = 'Enabling this option will delete all templates that are attached to this design, but not attached to another design.  Use extreme caution when enabling this option.';
$lang['help_rm_css'] = 'Enabling this option will delete all stylesheets that are attached to this design, but not attached to another design.  Use extreme caution when enabling this option.';
$lang['help_stylesheet_content'] = 'Enter the content for this stylesheet here.  It makes sense to use multiple stylesheets for a design, divided upon logical lines.  This allows stylesheets to be re-used amongst designs.  There is a 64k limit for each stylesheet';
$lang['help_stylesheet_created'] = 'This is the date and time when this stylesheet was originally created';
$lang['help_stylesheet_modified'] = 'This is the date and time when this stylesheet was last modified';
$lang['help_stylesheet_multiple_designs'] = 'This stylesheet is attached to multiple designs';
$lang['help_stylesheet_name'] = 'Specify a name for this stylesheet.  Only alphanumeric characters, and the underscore are permitted';
$lang['help_stylesheet_no_designs'] = 'This stylesheet is not attached to any designs';
$lang['help_template_addteditors'] = 'Here you can specify additional users that have permission to edit this template';
$lang['help_template_bulk'] = 'This option allows performing actions on multiple templates at once.  Use with caution';
$lang['help_template_category'] = 'The template category is used for organizing and filtering templates.  A template may only belong to one category.  Selecting a category is optional';
$lang['help_template_contents'] = 'Enter or edit the contents for the particular template.  This is a Smarty template.  The data available to the smarty template depends on where in the application this template is called.';
$lang['help_template_description'] = 'You may provide a text description for this template to help with searching, organization, and to describe any special features or notes that are specific to this template';
$lang['help_template_designlist'] = 'Specify the designs (zero or more) that this template is attached to.  Attaching a template to a design is used for quickly finding templates, and when exporting a design for sharing.  You can select or deselect multiple designs by holding the CTRL button down when clicking';
$lang['help_template_designs'] = 'A template can belong to zero or more designs.  If a template is attached to a design then that template can be chosen for a content page, or exported with the template to an XML file';
$lang['help_template_dflt'] = 'Some templates (depending on their type) can be the &quot;default&quot; template for that type.  The &quot;default&quot; template for a type is typically used when a request is made for a specific template type, but without specifying a template name.';
$lang['help_template_listable'] = 'Indicate whether this template should appear in public lists (specifically the content manager).  This is particularly used when a template should not be selectable by a content editor.';
$lang['help_template_multiple_designs'] = 'This template is attached to multiple designs';
$lang['help_template_name'] = 'Specify a name for this template.  The name must contain only alphanumeric characters, and must be unique to the system';
$lang['help_template_no_designs'] = 'This template is not attached to any designs';
$lang['help_template_owner'] = 'You may change the authorized &quot;owner&quot; of this template.  The owner of a template is allowed to edit the template at any time (even without specific template editing permissions, and can change the additional editors.';
$lang['help_template_type'] = 'The template type is used for organizational purposes, and for finding default contents when restoring the template to its default value (if any).  Templates belonging to a certain module type may be removed if the module is uninstalled.';
$lang['help_tpl_created'] = 'This is the date that this template was initially created';
$lang['help_tpl_modified'] = 'This is the date that this template was last modified';
$lang['help_tpl_usage'] = 'This string can be inserted into a Smarty template to use this template';
$lang['help_type_createdate'] = 'The date that this template type was created in the database';
$lang['help_type_descriptive_name'] = 'This is the name that will indicate this type in the template list, or in edit content';
$lang['help_type_description'] = 'Specify a description for this content type.  This is useful to provide hints as to how this type is used, or other internal data.';
$lang['help_type_modifieddate'] = 'The date that this template type was last modified';
$lang['help_type_name'] = 'The name of this template type';
$lang['help_type_originator'] = 'The originator <em>(usually the module name)</em> that created this template type';
$lang['help_type_reqcontentblocks'] = 'This field indicates whether templates of this content type are required to have content blocks within them.';

#I
$lang['import'] = 'Import';
$lang['import_design'] = 'Import Design';
$lang['import_design_step1'] = 'Import Design Step 1';
$lang['import_design_step2'] = 'Import Design Step 2';
$lang['info_about_categories'] = 'Categories provide an additional, useful method of sorting and organizing templates.  A template can belong to multiple categories and filtering on categories is permitted in the template list.  Examples of categories may include &quot;landing page templates&quot; or &quot;base templates&quot; when utilizing template inheritance.';
$lang['info_copy_css'] = '<strong>Note:</strong><br />Copying a stylesheet will copy the stylesheet contents, as well as the description, media query, and media types.  However, the new stylesheet will not be associated with any designs';
$lang['info_css_content_file'] = 'The contents of this stylesheet are stored in a file.  You can edit this item by editing <strong>%s</strong> with your favorite editor.';
$lang['info_editcss_mediatype_tab'] = '<strong>Warning:</strong> This functionality is deprecated and will be removed at a later date.  If both the media type and media query are specified, then the media query will take preference when rendering stylesheets';
$lang['info_editcss_mediaquery_tab'] = '<strong>Warning:</strong> If both the media type and media query are specified, then the media query will take preference when rendering stylesheets';
$lang['info_edittemplate_templates_tab'] = 'Here you can select the templates that should be attached to the design.<br />
Attaching a template to a design is only used for organizational and export purposes. Order is not important.<br />
<br />
<b>How to use:</b><br />
Select one or more templates, drag them from Available Templates and drop them in the Attached Templates box, then hit Apply or Submit.<br />
Delete an attached template by clicking the trash icon.';
$lang['info_edittemplate_stylesheets_tab'] = 'Here you can select the stylesheets that should be attached to the design.<br />
Stylesheets are used to control the appearance of the web pages, and for organizational and export purposes. The order is used for determining the order in which stylesheets are output for a page using this design.<br />
<br />
<b>How to use:</b><br />
Select one or more stylesheets, drag them from Available Stylesheets and drop them in the Attached Stylesheets box, then hit Apply or Submit.<br />
Delete an attached stylesheet by clicking the trash icon.';
$lang['info_import_xml_step1'] = 'Step 1: Choose a Design XML File to import';
$lang['info_import_xml_step2'] = 'Step 2: Read information about this design before importing it to your CMSMS installation.';
$lang['info_nodescription'] = 'There is no description entered for this item';
$lang['info_template_content_file'] = 'The contents of this template are stored in a file.  You can edit this template by editing <strong>%s</strong> with your favorite editor.';
$lang['info_template_delete'] = 'This template may be used by a working system.  Deleting it may break an otherwise working website.  Use caution!';

#J


#K


#L
$lang['lock_timeout'] = 'Lock Time out (minutes)';
$lang['lock_refresh'] = 'Lock Refresh Interval (seconds)';
$lang['lock_warning'] = 'Another user is editing this item. You will not be able to save any of your work until lock time out expires.';

#M
$lang['media_type_all'] = 'All';
$lang['media_type_aural'] = 'Aural';
$lang['media_type_speech'] = 'Speech';
$lang['media_type_braille'] = 'Braille';
$lang['media_type_embossed'] = 'Embossed';
$lang['media_type_handheld'] = 'Handheld';
$lang['media_type_print'] = 'Print';
$lang['media_type_projection'] = 'Projection';
$lang['media_type_screen'] = 'Screen';
$lang['media_type_tty'] = 'TTY';
$lang['media_type_tv'] = 'TV';
$lang['moddescription'] = 'A module for managing layout templates';
$lang['modified'] = 'Modified';
$lang['msg_allpagesupdated'] = 'All content pages were updated';
$lang['msg_bulkop_complete'] = 'Bulk operation completed';
$lang['msg_cancelled'] = 'Operation Canceled';
$lang['msg_category_deleted'] = 'Category Deleted';
$lang['msg_category_saved'] = 'Category Saved';
$lang['msg_design_imported']  = 'Design Imported';
$lang['msg_dflt_design_saved'] = 'Default design changed';
$lang['msg_lockscleared'] = 'Locks cleared';
$lang['msg_lostlock'] = 'Sorry, but you have lost the lock on this item, and somebody else has made edits to this item.  You can save your changes to a text file for future use, but you can no longer commit any changes';
$lang['msg_options_saved'] = 'Options Saved';
$lang['msg_steal_lock'] = 'You can steal this lock';
$lang['msg_stylesheet_copied'] = 'Stylesheet Copied';
$lang['msg_stylesheet_copied_edit'] = 'Stylesheet has been copied, you are now editing the new version';
$lang['msg_stylesheet_deleted'] = 'Stylesheet Deleted';
$lang['msg_template_copied_edit'] = 'Template has been copied, you are now editing the new version';
$lang['msg_template_copied'] = 'Template Copied';
$lang['msg_template_deleted'] = 'Template Deleted';
$lang['msg_template_saved'] = 'Template Saved';
$lang['msg_stylesheet_saved'] = 'Stylesheet Saved';
$lang['msg_design_deleted'] = 'Design Deleted';
$lang['msg_design_saved'] = 'Design Saved';
$lang['msg_type_saved'] = 'Template Type Saved';

#N
$lang['name'] = 'Name';
$lang['newname'] =  'New Name';
$lang['next'] = 'Next';
$lang['new_stylesheet'] = 'New Stylesheet';
$lang['new_template'] = 'New Template';
$lang['no'] = 'No';

#O


#P
$lang['postinstall'] = 'Design Manager Module Installed';
$lang['postuninstall'] = 'Design Manager Module Uninstalled';
$lang['prompt_add'] = 'Add';
$lang['prompt_advanced'] = 'Advanced';
$lang['prompt_any'] = 'Any';
$lang['prompt_attached_designs'] = 'This stylesheet is attached to these designs';
$lang['prompt_category'] = 'Category';
$lang['prompt_categories'] = 'Categories';
$lang['prompt_cmsversion'] = 'CMS Version';
$lang['prompt_clearlocks'] = 'Remove Locks';
$lang['prompt_copy'] = 'Copy';
$lang['prompt_copyrightlicense'] = 'Copyright and License';
$lang['prompt_copy_template'] = 'Copy this Template';
$lang['prompt_created'] = 'Create Date';
$lang['prompt_cssfile'] = 'CSS File';
$lang['prompt_default'] = 'Default';
$lang['prompt_delete'] = 'Delete';
$lang['prompt_description'] = 'Description';
$lang['prompt_descriptive_name'] = 'Descriptive Name';
$lang['prompt_dest_css'] = 'Destination Stylesheet';
$lang['prompt_dest_template'] = 'Destination Template';
$lang['prompt_dflt'] = 'Default';
$lang['prompt_dflt_tpl'] = 'This is the default template for its type';
$lang['prompt_edit'] = 'Edit';
$lang['prompt_editfilter'] = 'Edit Template Filter';
$lang['prompt_filename'] = 'Filename';
$lang['prompt_filetemplate'] = 'Template File';
$lang['prompt_filter'] = 'Filter';
$lang['prompt_firstpage'] = 'First page';
$lang['prompt_has_dflt'] = 'Has Default Template Contents';
$lang['prompt_help'] = 'Help';
$lang['prompt_group'] = 'Group';
$lang['prompt_id'] = 'Id';
$lang['prompt_import'] = 'Create a new template of this type';
$lang['prompt_import_xml_file'] = 'Upload a Design XML File';
$lang['prompt_lastpage'] = 'Last page';
$lang['prompt_limit'] = 'Limit';
$lang['prompt_listable'] = 'Listable';
$lang['prompt_lockedby'] = 'Locked By';
$lang['prompt_lockedsince'] = 'Since';
$lang['prompt_lockexpired'] = 'Expired';
$lang['prompt_lockexpires'] = 'Expires';
$lang['prompt_locksettings'] = 'Locking';
$lang['prompt_media_type'] = 'Media Type';
$lang['prompt_media_query'] = 'Media Query';
$lang['prompt_modified'] = 'Modified Date';
$lang['prompt_multiple'] = 'Multiple';
$lang['prompt_na'] = 'N/A';
$lang['prompt_name'] = 'Name';
$lang['prompt_nextpage'] = 'Next page';
$lang['prompt_none'] = 'None';
$lang['prompt_notdflt'] = 'This is not a default template';
$lang['prompt_notdflt_tpl'] = 'This is not a default template for this template type.';
$lang['prompt_of'] = 'Of';
$lang['prompt_options'] = 'Options';
$lang['prompt_orig_name'] = 'Original Name';
$lang['prompt_originator'] = 'Originator';
$lang['prompt_owner'] = 'Owner';
$lang['prompt_page'] = 'Page';
$lang['prompt_permissions'] = 'Permissions';
$lang['prompt_prevpage'] = 'Previous page';
$lang['prompt_proto_template'] = 'Prototype Template';
$lang['prompt_resource'] = 'Resource';
$lang['prompt_requires_content_blocks'] = 'This template type requires content blocks';
$lang['prompt_return'] = 'Return';
$lang['prompt_select'] = 'Select this item for performing bulk actions.';
$lang['prompt_select_all'] = 'Select all';
$lang['prompt_setdflt_design'] = 'Set as default design';
$lang['prompt_source_css'] = 'Source Stylesheet';
$lang['prompt_source_template'] = 'Source Template';
$lang['prompt_sortby'] = 'Sort By';
$lang['prompt_sortorder'] = 'Order';
$lang['prompt_steal_lock'] = 'Steal this lock';
$lang['prompt_stylesheet'] = 'Stylesheet';
$lang['prompt_stylesheets'] = 'Stylesheets';
$lang['prompt_template'] = 'Template';
$lang['prompt_template_content'] = 'Template Content';
$lang['prompt_template_help'] = 'Template Help';
$lang['prompt_templates'] = 'Templates';
$lang['prompt_template_setallpages'] = 'Set All Pages';
$lang['prompt_templatetype'] = 'Template Type';
$lang['prompt_templatetypes'] = 'Template Types / Prototypes';
$lang['prompt_title_na'] = 'This template type does not have a default';
$lang['prompt_design'] = 'Design';
$lang['prompt_designs'] = 'Designs';
$lang['prompt_type'] = 'Type';
$lang['prompt_unknown'] = 'Unknown';
$lang['prompt_usage'] = 'Usage';
$lang['prompt_user'] = 'User';
$lang['prompt_view'] = 'View';
$lang['prompt_with_selected'] = 'With Selected';

#Q


#R
$lang['reset'] = 'Reset';
$lang['reset_factory'] = 'Reset to Factory Defaults';
$lang['remove'] = 'Remove';

#S
$lang['set_all_pages'] = 'Set All Pages To This Template';
$lang['submit'] = 'Submit';
$lang['submitandedit'] = 'Submit And Edit';

#T
$lang['title_cat_id'] = 'This column displays the unique integer id for the category.';
$lang['title_cat_name'] = 'This column displays the unique name for the category.';
$lang['title_clearlocks'] = 'Clear any locked items (subject to permissions)';
$lang['title_css_designs'] = 'This column lists the design that a stylesheet is attached to. If any.';
$lang['title_css_id'] = 'This column displays the unique integer id for the stylesheet.';
$lang['title_css_filename'] = 'When stylesheets are stored in a file this column displays the filename within the assets/css directory';
$lang['title_css_modified'] = 'Displays the date the stylesheet was last modified.';
$lang['title_css_name'] = 'This column displays the unique name for the stylesheet.';
$lang['title_css_selectall'] = 'Select <em>(or deselect)</em> all visible stylesheets.';
$lang['title_delete'] = 'Delete the selected items';
$lang['title_designmanager_settings'] = 'Settings - Design Manager';
$lang['title_designs_default'] = 'The default design is automatically selected when creating new content pages.';
$lang['title_tpl_filename'] = 'When templates are stored in a file this column displays the filename within the assets/templates directory';
$lang['title_filter'] = 'Select an item in this list to reduce the number of visible templates';
$lang['title_filter_design'] = 'Optionally filter the displayed stylesheet by the associated design/theme';
$lang['title_filterapplied'] = 'A filter has been selected which limits the number of templates listed';
$lang['title_filterlimit'] = 'Select the number of items to view on each page';
$lang['title_import_design'] = 'Import a design from XML';
$lang['title_locked'] = 'This item is already being edited by another user (or maybe even by you)';
$lang['title_sortby'] = 'Select a way to sort the matching templates';
$lang['title_sortorder'] = 'Modify the way the matching templates are ordered';
$lang['title_template_setallpages'] = 'Set all pages to use this template';
$lang['title_tpl_bulk'] = 'Select this template for bulk actions';
$lang['title_tpl_bulkaction'] = 'Select the action to perform on the selected templates.';
$lang['title_tpl_design'] = 'This column displays the name of the design (if any) that a template is associated with.  A template can be associated with multiple designs';
$lang['title_tpl_dflt'] = 'This column displays whether the template is the default template for its type';
$lang['title_tpl_id'] = 'This column displays the unique numeric template ID';
$lang['title_tpl_import_type'] = 'For organizational purposes, and to provide some default content, select the type for the new template.';
$lang['title_tpl_modified'] = 'This column displays the name date the template was last modified';
$lang['title_tpl_name'] = 'This column displays the unique template name';
$lang['title_tpl_type'] = 'This column displays the type of each template';
$lang['tpl_filter'] = 'Filter Templates';
$lang['tpl_originators'] = 'Originators';
$lang['tpl_type'] = 'Template Type';
$lang['tpl_types'] = 'Template Types';
$lang['type'] = 'Type';

#U
$lang['unknown'] = 'Unknown';

#V

#W
$lang['warn_bulk_delete_templates'] = '<strong>Warning:</strong> Deleting multiple templates at once is usually a bad idea.  No checks are performed to see if these templates are actually used in the system.  This operation may break a working website!';
$lang['warn_setall_nocontentblocks'] = '<strong>Warning:</strong> No content blocks were detected in the destination template.  This will prevent editing content in all current content pages.';
$lang['warn_template_used'] = '<strong>Warning:</strong> This template is in use by one or more pages, and/or designs.  It may also be included by other templates.  Deleting this template may break a working website. <strong>Use Extreme Caution!</strong>';
$lang['warning_category_dragdrop'] = 'To change the display order of categories you can drag the rows into their correct order';
$lang['warning_deletetemplate_attachments'] = 'This design has templates attached to it.  These templates may be in use on some page or by a module. Deleting these templates, even if they are attached to no other design, may break an otherwise working site.   Please exercise extreme caution!';
$lang['warning_deletedesign'] = '<strong>Warning:  Use extreme caution.</strong>  Deleting a design may break a functioning website.';
$lang['warning_deletestylesheet_attachments'] = 'This design has stylesheets attached to it.  Some of the templates in use by the system but not necessarily attached to this design may rely on these stylesheets.  Deleting these stylesheets, even if they are attached to no other design may break an otherwise working site. Please exercise extreme caution!';
$lang['warning_editdesign_nostylesheets'] = 'There are no stylesheets available in the system.';
$lang['warning_edittemplate_nostylesheets'] = 'No stylesheets attached';
$lang['warning_edittemplate_notemplates'] = 'Sorry, we could not find any templates that you have permission to edit';
$lang['warning_no_templates_available'] = 'We could find no templates that match the selected criteria or that you have permission to edit';
$lang['warning_no_stylesheets'] = 'We could find no stylesheets that match the selected criteria or that you have permission to edit';
$lang['warning_set_all_pages'] = '<strong>Warning:</strong> This is a potentially destructive operation!  You are asking that all content pages be set use this template.  Please confirm this action.';
$lang['whats_this'] = 'What\'s this?';

#X


#Y
$lang['yes'] = 'Yes';

#Z

?>