
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `conc943`
--

-- --------------------------------------------------------

--
-- Table structure for table `Announcements`
--

CREATE TABLE `Announcements` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `handle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `dateCreated` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `Announcements`
--

INSERT INTO `Announcements` VALUES
(1, 'collect_site_information', [[timestamp]]),
(2, 'welcome', [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `AnnouncementUserViews`
--

CREATE TABLE `AnnouncementUserViews` (
  `announcement_id` int(10) unsigned NOT NULL,
  `dateViewed` int(11) DEFAULT NULL,
  `uID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`uID`,`announcement_id`),
  KEY `IDX_B721E7B9FD71026C` (`uID`),
  KEY `IDX_B721E7B9913AEA17` (`announcement_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `AreaLayoutColumns`
--

CREATE TABLE `AreaLayoutColumns` (
  `arLayoutColumnID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `arLayoutID` int(10) unsigned NOT NULL DEFAULT '0',
  `arLayoutColumnIndex` int(10) unsigned NOT NULL DEFAULT '0',
  `arID` int(10) unsigned NOT NULL DEFAULT '0',
  `arLayoutColumnDisplayID` int(11) DEFAULT '0',
  PRIMARY KEY (`arLayoutColumnID`),
  KEY `arLayoutID` (`arLayoutID`,`arLayoutColumnIndex`),
  KEY `arID` (`arID`),
  KEY `arLayoutColumnDisplayID` (`arLayoutColumnDisplayID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=13 ;

--
-- Dumping data for table `AreaLayoutColumns`
--

INSERT INTO `AreaLayoutColumns` VALUES
(1, 1, 0, 2, 1),
(2, 1, 1, 3, 2),
(3, 1, 2, 4, 3),
(4, 2, 0, 5, 4),
(5, 2, 1, 6, 5),
(6, 3, 0, 7, 6),
(7, 3, 1, 8, 7),
(8, 3, 2, 9, 8),
(9, 4, 0, 11, 9),
(10, 5, 0, 12, 10),
(11, 6, 0, 14, 11),
(12, 7, 0, 15, 12);

-- --------------------------------------------------------

--
-- Table structure for table `AreaLayoutCustomColumns`
--

CREATE TABLE `AreaLayoutCustomColumns` (
  `arLayoutColumnID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `arLayoutColumnWidth` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`arLayoutColumnID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `AreaLayoutPresets`
--

CREATE TABLE `AreaLayoutPresets` (
  `arLayoutPresetID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `arLayoutID` int(10) unsigned NOT NULL DEFAULT '0',
  `arLayoutPresetName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`arLayoutPresetID`),
  KEY `arLayoutID` (`arLayoutID`),
  KEY `arLayoutPresetName` (`arLayoutPresetName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `AreaLayouts`
--

CREATE TABLE `AreaLayouts` (
  `arLayoutID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `arLayoutSpacing` int(10) unsigned NOT NULL DEFAULT '0',
  `arLayoutIsCustom` tinyint(1) NOT NULL DEFAULT '0',
  `arLayoutIsPreset` tinyint(1) NOT NULL DEFAULT '0',
  `arLayoutMaxColumns` int(10) unsigned NOT NULL DEFAULT '0',
  `arLayoutUsesThemeGridFramework` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`arLayoutID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `AreaLayouts`
--

INSERT INTO `AreaLayouts` VALUES
(1, 0, 0, 0, 12, 1),
(2, 0, 0, 0, 12, 1),
(3, 0, 0, 0, 12, 1),
(4, 0, 0, 0, 12, 1),
(5, 0, 0, 0, 12, 1),
(6, 0, 0, 0, 12, 1),
(7, 0, 0, 0, 12, 1);

-- --------------------------------------------------------

--
-- Table structure for table `AreaLayoutsUsingPresets`
--

CREATE TABLE `AreaLayoutsUsingPresets` (
  `arLayoutID` int(10) unsigned NOT NULL,
  `preset` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`arLayoutID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `AreaLayoutThemeGridColumns`
--

CREATE TABLE `AreaLayoutThemeGridColumns` (
  `arLayoutColumnID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `arLayoutColumnSpan` int(10) unsigned DEFAULT '0',
  `arLayoutColumnOffset` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`arLayoutColumnID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=13 ;

--
-- Dumping data for table `AreaLayoutThemeGridColumns`
--

INSERT INTO `AreaLayoutThemeGridColumns` VALUES
(1, 4, 0),
(2, 4, 0),
(3, 4, 0),
(4, 4, 0),
(5, 8, 0),
(6, 4, 0),
(7, 4, 0),
(8, 4, 0),
(9, 12, 0),
(10, 12, 0),
(11, 12, 0),
(12, 12, 0);

-- --------------------------------------------------------

--
-- Table structure for table `AreaPermissionAssignments`
--

CREATE TABLE `AreaPermissionAssignments` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `arHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`arHandle`,`pkID`,`paID`),
  KEY `paID` (`paID`),
  KEY `pkID` (`pkID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `AreaPermissionBlockTypeAccessList`
--

CREATE TABLE `AreaPermissionBlockTypeAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`),
  KEY `peID` (`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `AreaPermissionBlockTypeAccessListCustom`
--

CREATE TABLE `AreaPermissionBlockTypeAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `btID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`btID`),
  KEY `peID` (`peID`),
  KEY `btID` (`btID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `Areas`
--

CREATE TABLE `Areas` (
  `arID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `arHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `arOverrideCollectionPermissions` tinyint(1) NOT NULL DEFAULT '0',
  `arInheritPermissionsFromAreaOnCID` int(10) unsigned NOT NULL DEFAULT '0',
  `arIsGlobal` tinyint(1) NOT NULL DEFAULT '0',
  `arParentID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`arID`),
  KEY `arIsGlobal` (`arIsGlobal`),
  KEY `cID` (`cID`),
  KEY `arHandle` (`arHandle`),
  KEY `arParentID` (`arParentID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=17 ;

--
-- Dumping data for table `Areas`
--

INSERT INTO `Areas` VALUES
(1, 214, 'Main', 0, 0, 0, 0),
(2, 214, 'Main : 1', 0, 0, 0, 1),
(3, 214, 'Main : 2', 0, 0, 0, 1),
(4, 214, 'Main : 3', 0, 0, 0, 1),
(5, 214, 'Main : 4', 0, 0, 0, 1),
(6, 214, 'Main : 5', 0, 0, 0, 1),
(7, 214, 'Main : 6', 0, 0, 0, 1),
(8, 214, 'Main : 7', 0, 0, 0, 1),
(9, 214, 'Main : 8', 0, 0, 0, 1),
(10, 216, 'Main', 0, 0, 0, 0),
(11, 216, 'Main : 9', 0, 0, 0, 10),
(12, 216, 'Main : 10', 0, 0, 0, 10),
(13, 230, 'Main', 0, 0, 0, 0),
(14, 230, 'Main : 11', 0, 0, 0, 13),
(15, 230, 'Main : 12', 0, 0, 0, 13),
(16, 231, 'Main', 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `atAddress`
--

CREATE TABLE `atAddress` (
  `address1` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address2` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address3` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_province` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postal_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`),
  KEY `postal_code` (`postal_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atAddressSettings`
--

CREATE TABLE `atAddressSettings` (
  `akDefaultCountry` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `akHasCustomCountries` tinyint(1) NOT NULL,
  `customCountries` json NOT NULL COMMENT '(DC2Type:json_array)',
  `akGeolocateCountry` tinyint(1) NOT NULL,
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atBoolean`
--

CREATE TABLE `atBoolean` (
  `value` tinyint(1) NOT NULL,
  `avID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `atBoolean`
--

INSERT INTO `atBoolean` VALUES
(1, 7),
(1, 10),
(1, 19),
(1, 21),
(1, 23),
(1, 24),
(1, 25),
(1, 26),
(1, 27),
(1, 28),
(1, 29),
(1, 30),
(1, 31),
(1, 32),
(1, 33),
(1, 34),
(1, 35),
(1, 36),
(1, 37),
(1, 38),
(1, 39),
(1, 40),
(1, 41),
(1, 42),
(1, 43),
(1, 44),
(1, 47),
(1, 48),
(1, 51),
(1, 57),
(1, 58),
(1, 59),
(1, 60),
(1, 61),
(1, 62),
(1, 63),
(1, 64),
(1, 65),
(1, 69),
(1, 70),
(1, 71),
(1, 72),
(1, 75),
(1, 76),
(1, 89),
(1, 94),
(1, 97),
(1, 98),
(1, 102),
(1, 103),
(1, 104),
(1, 105),
(1, 106),
(1, 107),
(1, 108),
(1, 109),
(1, 110),
(1, 111),
(1, 123),
(1, 143),
(1, 144),
(1, 171),
(1, 183),
(0, 184),
(1, 188),
(1, 192),
(1, 193);

-- --------------------------------------------------------

--
-- Table structure for table `atBooleanSettings`
--

CREATE TABLE `atBooleanSettings` (
  `akCheckedByDefault` tinyint(1) NOT NULL,
  `checkboxLabel` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `atBooleanSettings`
--

INSERT INTO `atBooleanSettings` VALUES
(0, NULL, 5),
(0, 'Exclude Page from Navigation', 7),
(0, 'Exclude Page from Page List Blocks', 8),
(0, 'Feature this Page', 11),
(0, NULL, 12),
(0, NULL, 13),
(0, NULL, 14),
(1, NULL, 15),
(1, NULL, 16);

-- --------------------------------------------------------

--
-- Table structure for table `atDateTime`
--

CREATE TABLE `atDateTime` (
  `value` datetime DEFAULT NULL,
  `avID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atDateTimeSettings`
--

CREATE TABLE `atDateTimeSettings` (
  `akUseNowIfEmpty` tinyint(1) NOT NULL DEFAULT '0',
  `akDateDisplayMode` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `akTextCustomFormat` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Custom format for text inputs',
  `akTimeResolution` int(10) unsigned NOT NULL DEFAULT '60' COMMENT 'Time resolution (in seconds)',
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atDefault`
--

CREATE TABLE `atDefault` (
  `value` longtext COLLATE utf8mb4_unicode_ci,
  `avID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `atDefault`
--

INSERT INTO `atDefault` VALUES
('fas fa-th-large', 1),
('pages, add page, delete page, copy, move, alias', 2),
('pages, add page, delete page, copy, move, alias', 3),
('pages, add page, delete page, copy, move, alias, bulk', 4),
('find page, search page, search, find, pages, sitemap', 5),
('add file, delete file, copy, move, alias, resize, crop, rename, images, title, attribute', 6),
('file, file attributes, title, attribute, description, rename', 8),
('files, category, categories', 9),
('new file set', 11),
('users, groups, people, find, delete user, remove user, change password, password', 12),
('find, search, people, delete user, remove user, change password, password', 13),
('user, group, people, permissions, expire', 14),
('group types, group type', 15),
('user, group, people, messages', 16),
('user attributes, user data, gather data, registration data', 17),
('new user, create', 18),
('new user group, new group, group, create', 20),
('group set', 22),
('forms, log, error, email, mysql, exception, survey', 45),
('forms, questions, response, data', 46),
('health, check, site check, optimization', 49),
('page types', 50),
('questions, quiz, response', 52),
('forms, log, error, email, mysql, exception, survey, history', 53),
('changes, csv, report', 54),
('new theme, theme, active theme, change theme, template, css', 55),
('page types', 56),
('page attributes, custom', 66),
('single, page, custom, application', 67),
('atom, rss, feed, syndication', 68),
('icon-bullhorn', 73),
('stacks, global areas, reusable content, scrapbook, copy, paste, paste block, copy block, site name, logo', 74),
('edit stacks, view stacks, all stacks', 77),
('block, refresh, custom', 78),
('add-on, addon, add on, package, app, ecommerce, discussions, forums, themes, templates, blocks', 79),
('add-on, addon, ecommerce, install, discussions, forums, themes, templates, blocks', 80),
('update, upgrade', 81),
('buy theme, new theme, marketplace, template', 82),
('buy addon, buy add on, buy add-on, purchase addon, purchase add on, purchase add-on, find addon, new addon, marketplace', 83),
('dashboard, configuration', 84),
('website name, title', 85),
('concretecms.com, my account, purchase, extensions, marketplace', 86),
('production, staging, site copy, development copy, local', 87),
('accessibility, appearance, dark mode, tooltips', 88),
('logo, favicon, iphone, icon, bookmark', 90),
('tinymce, content block, fonts, editor, content, overlay', 91),
('translate, translation, internationalization, multilingual', 92),
('languages, update, gettext, translation, translate', 93),
('timezone, profile, locale', 95),
('site attributes', 96),
('checkin, check-in, check, force', 99),
('sharing, facebook, twitter', 100),
('sharing, opengraph, schema', 101),
('multilingual, localization, internationalization, i18n', 112),
('vanity, pretty url, redirection, hostname, canonical, seo, pageview, view', 113),
('bulk, seo, change keywords, engine, optimization, search', 114),
('traffic, statistics, google analytics, quant, pageviews, hits', 115),
('pretty, slug', 116),
('configure search, site search, search option', 117),
('url, slug', 118),
('security, files, media, extension, manager, upload', 119),
('file, chooser', 120),
('file options, file manager, upload, modify', 121),
('images, picture, responsive, retina', 122),
('thumbnail, format, png, jpg, jpeg, quality, compression, gd, imagick, imagemagick, transparency', 124),
('uploading, upload, images, image, resizing, manager, exif, rotation, rotate, quality, compression, png, jpg, jpeg', 125),
('image, editor, active, default, edit, png, jpg, jpeg', 126),
('security, alternate storage, hide files', 127),
('external, file, providers', 128),
('files, export, csv, bom, encoding', 129),
('files, upload, parallel, upload_max_filesize, post_max_size, limit, resize, chunk', 130),
('automated jobs, commands, tasks, console, cli', 131),
('processes, queues, jobs, running', 132),
('failed messages, retry', 133),
('cron, scheduling, jobs', 134),
('websocket, socket, socket.io, push, push notifications, mercure', 135),
('waiting for me, inbox, notifications', 136),
('cache option, change cache, override, turn on cache, turn off cache, no cache, page cache, caching', 137),
('cache option, turn off cache, no cache, page cache, caching', 138),
('index search, reindex search, build sitemap, sitemap.xml, clear old versions, page versions, remove old', 139),
('editors, hide site, offline, private, public, access', 140),
('security, actions, administrator, admin, package, marketplace, search', 141),
('security, lock ip, lock out, block ip, address, restrict, access', 142),
('security, registration', 145),
('antispam, block spam, security', 146),
('lock site, under construction, hide, hidden', 147),
('trusted, proxy, proxies, ip, header, cloudflare', 148),
('signup, new user, community, public registration, public, registration', 149),
('profile, login, redirect, specific, dashboard, administrators', 150),
('member profile, member page, community, forums, social, avatar', 151),
('auth, authentication, types, oauth, facebook, login, registration', 152),
('global, password, reset, change password, force, sign out', 153),
('login, logout, user, agent, ip, change, security, session, invalidation, invalid', 154),
('password, requirements, code, key, login, registration, security, nist', 155),
('session, options', 156),
('smtp, mail settings', 157),
('email server, mail settings, mail configuration, external, internal', 158),
('test smtp, test mail', 159),
('email server, mail settings, mail configuration, private message, message system, import, email, message', 160),
('mail settings, mail configuration, email, sender', 161),
('email logging, mail logging, log mails, log emails', 162),
('conversations', 163),
('conversations', 164),
('conversations ratings, ratings, community, community points', 165),
('conversations bad words, banned words, banned, bad words, bad, words, list', 166),
('attribute configuration', 167),
('attributes, types', 168),
('attributes, sets', 169),
('topics, tags, taxonomy', 170),
('overrides, system info, debug, support, help', 172),
('error, exception, debug', 173),
('email, logging, logs, smtp, pop, errors, mysql, log', 174),
('network, proxy server', 175),
('database, entities, doctrine, orm', 176),
('database, character set, charset, collation, utf8', 177),
('geolocation, ip, address, country, nation, place, locate', 178),
('security, content security policy, csp, strict transport security, hsts, x-frame-options', 179),
('upgrade, new version, update', 180),
('API, programming, public, app', 181),
('fas fa-palette', 185),
('fas fa-th', 186),
('fas fa-trash', 187),
('fas fa-briefcase', 189),
('fas fa-edit', 190);

-- --------------------------------------------------------

--
-- Table structure for table `atDuration`
--

CREATE TABLE `atDuration` (
  `value` int(11) DEFAULT NULL,
  `avID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atDurationSettings`
--

CREATE TABLE `atDurationSettings` (
  `akUnitType` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atEmptySettings`
--

CREATE TABLE `atEmptySettings` (
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `atEmptySettings`
--

INSERT INTO `atEmptySettings` VALUES
(4),
(17),
(18),
(19),
(20);

-- --------------------------------------------------------

--
-- Table structure for table `atExpress`
--

CREATE TABLE `atExpress` (
  `avID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atExpressSelectedEntries`
--

CREATE TABLE `atExpressSelectedEntries` (
  `avID` int(10) unsigned NOT NULL,
  `exEntryID` int(11) NOT NULL,
  PRIMARY KEY (`avID`,`exEntryID`),
  KEY `IDX_C9D404BBA2A82A5D` (`avID`),
  KEY `IDX_C9D404BB6DCB6296` (`exEntryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atExpressSettings`
--

CREATE TABLE `atExpressSettings` (
  `exEntityID` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`),
  KEY `IDX_E8F67F0FCE2D7284` (`exEntityID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atFile`
--

CREATE TABLE `atFile` (
  `fID` int(10) unsigned DEFAULT NULL,
  `avID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`),
  KEY `IDX_73D17D61E3111F45` (`fID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atFileSettings`
--

CREATE TABLE `atFileSettings` (
  `akFileManagerMode` int(11) NOT NULL,
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `atFileSettings`
--

INSERT INTO `atFileSettings` VALUES
(0, 21);

-- --------------------------------------------------------

--
-- Table structure for table `atNumber`
--

CREATE TABLE `atNumber` (
  `value` decimal(14,4) DEFAULT NULL,
  `avID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `atNumber`
--

INSERT INTO `atNumber` VALUES
('2.0000', 182),
('1.0000', 191);

-- --------------------------------------------------------

--
-- Table structure for table `atSelect`
--

CREATE TABLE `atSelect` (
  `avID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atSelectedSocialLinks`
--

CREATE TABLE `atSelectedSocialLinks` (
  `avsID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `service` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `serviceInfo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`avsID`),
  KEY `IDX_10743709A2A82A5D` (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `atSelectedTopics`
--

CREATE TABLE `atSelectedTopics` (
  `avTreeTopicNodeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `treeNodeID` int(10) unsigned NOT NULL,
  `avID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`avTreeTopicNodeID`),
  KEY `IDX_E42A7D5BA2A82A5D` (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `atSelectOptionLists`
--

CREATE TABLE `atSelectOptionLists` (
  `avSelectOptionListID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`avSelectOptionListID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `atSelectOptionLists`
--

INSERT INTO `atSelectOptionLists` VALUES
(1);

-- --------------------------------------------------------

--
-- Table structure for table `atSelectOptions`
--

CREATE TABLE `atSelectOptions` (
  `avSelectOptionID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `isEndUserAdded` tinyint(1) NOT NULL,
  `isDeleted` tinyint(1) NOT NULL DEFAULT '0',
  `displayOrder` int(11) NOT NULL,
  `value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avSelectOptionListID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`avSelectOptionID`),
  KEY `IDX_797414B0CB59257C` (`avSelectOptionListID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `atSelectOptionsSelected`
--

CREATE TABLE `atSelectOptionsSelected` (
  `avID` int(10) unsigned NOT NULL,
  `avSelectOptionID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`,`avSelectOptionID`),
  KEY `IDX_40C97EC3A2A82A5D` (`avID`),
  KEY `IDX_40C97EC3E584C274` (`avSelectOptionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atSelectSettings`
--

CREATE TABLE `atSelectSettings` (
  `akSelectAllowMultipleValues` tinyint(1) NOT NULL,
  `akSelectAllowOtherValues` tinyint(1) NOT NULL,
  `akHideNoneOption` tinyint(1) NOT NULL,
  `akSelectOptionDisplayOrder` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `akDisplayMultipleValuesOnSelect` tinyint(1) NOT NULL,
  `avSelectOptionListID` int(10) unsigned DEFAULT NULL,
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`),
  UNIQUE KEY `UNIQ_5D514424CB59257C` (`avSelectOptionListID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `atSelectSettings`
--

INSERT INTO `atSelectSettings` VALUES
(1, 1, 0, 'display_asc', 0, 1, 10);

-- --------------------------------------------------------

--
-- Table structure for table `atSite`
--

CREATE TABLE `atSite` (
  `siteID` int(10) unsigned DEFAULT NULL,
  `avID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`),
  KEY `IDX_960D4295521D8435` (`siteID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atSocialLinks`
--

CREATE TABLE `atSocialLinks` (
  `avID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atTextareaSettings`
--

CREATE TABLE `atTextareaSettings` (
  `akTextareaDisplayMode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `atTextareaSettings`
--

INSERT INTO `atTextareaSettings` VALUES
('', 2),
('', 3),
('', 6),
('', 9);

-- --------------------------------------------------------

--
-- Table structure for table `atTextSettings`
--

CREATE TABLE `atTextSettings` (
  `akTextPlaceholder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `atTextSettings`
--

INSERT INTO `atTextSettings` VALUES
('', 1);

-- --------------------------------------------------------

--
-- Table structure for table `atTopic`
--

CREATE TABLE `atTopic` (
  `avID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atTopicSettings`
--

CREATE TABLE `atTopicSettings` (
  `akTopicParentNodeID` int(11) NOT NULL,
  `akTopicTreeID` int(11) NOT NULL,
  `akTopicAllowMultipleValues` tinyint(1) NOT NULL DEFAULT '1',
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `AttributeKeyCategories`
--

CREATE TABLE `AttributeKeyCategories` (
  `akCategoryID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `akCategoryHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `akCategoryAllowSets` int(11) NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`akCategoryID`),
  UNIQUE KEY `UNIQ_A2A0CC67FA0337B` (`akCategoryHandle`),
  KEY `IDX_A2A0CC67CE45CBB0` (`pkgID`),
  KEY `pkgID` (`pkgID`,`akCategoryID`),
  KEY `akCategoryHandle` (`akCategoryHandle`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `AttributeKeyCategories`
--

INSERT INTO `AttributeKeyCategories` VALUES
(1, 'collection', 1, NULL),
(2, 'user', 1, NULL),
(3, 'file', 1, NULL),
(4, 'site', 1, NULL),
(5, 'event', 1, NULL),
(6, 'site_type', 1, NULL),
(7, 'express', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `AttributeKeys`
--

CREATE TABLE `AttributeKeys` (
  `akID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `akHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `akName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `akIsSearchable` tinyint(1) NOT NULL,
  `akIsInternal` tinyint(1) NOT NULL,
  `akIsSearchableIndexed` tinyint(1) NOT NULL,
  `atID` int(10) unsigned DEFAULT NULL,
  `akCategoryID` int(10) unsigned DEFAULT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  `akCategory` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`akID`),
  KEY `IDX_DCA32C62A12CFE33` (`atID`),
  KEY `IDX_DCA32C62B059B76B` (`akCategoryID`),
  KEY `pkgID` (`pkgID`),
  KEY `akHandle` (`akHandle`),
  KEY `akIsSearchable` (`akIsSearchable`),
  KEY `akIsInternal` (`akIsInternal`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=22 ;

--
-- Dumping data for table `AttributeKeys`
--

INSERT INTO `AttributeKeys` VALUES
(1, 'meta_title', 'Meta Title', 1, 0, 0, 1, 1, NULL, 'pagekey'),
(2, 'meta_description', 'Meta Description', 1, 0, 0, 3, 1, NULL, 'pagekey'),
(3, 'meta_keywords', 'Meta Keywords', 1, 0, 0, 3, 1, NULL, 'pagekey'),
(4, 'desktop_priority', 'Desktop Priority', 1, 1, 0, 7, 1, NULL, 'pagekey'),
(5, 'is_desktop', 'Is Desktop', 1, 1, 0, 4, 1, NULL, 'pagekey'),
(6, 'icon_dashboard', 'Dashboard Icon', 1, 1, 0, 3, 1, NULL, 'pagekey'),
(7, 'exclude_nav', 'Exclude From Nav', 1, 0, 0, 4, 1, NULL, 'pagekey'),
(8, 'exclude_page_list', 'Exclude From Page List', 1, 0, 0, 4, 1, NULL, 'pagekey'),
(9, 'header_extra_content', 'Header Extra Content', 1, 0, 0, 3, 1, NULL, 'pagekey'),
(10, 'tags', 'Tags', 1, 0, 1, 8, 1, NULL, 'pagekey'),
(11, 'is_featured', 'Is Featured', 1, 0, 0, 4, 1, NULL, 'pagekey'),
(12, 'exclude_search_index', 'Exclude From Search Index', 1, 0, 0, 4, 1, NULL, 'pagekey'),
(13, 'exclude_sitemapxml', 'Exclude From sitemap.xml', 1, 0, 0, 4, 1, NULL, 'pagekey'),
(14, 'exclude_subpages_from_nav', 'Exclude Sub-Pages From Nav', 1, 0, 1, 4, 1, NULL, 'pagekey'),
(15, 'profile_private_messages_enabled', 'I would like to receive private messages.', 1, 0, 0, 4, 2, NULL, 'userkey'),
(16, 'profile_private_messages_notification_enabled', 'Send me email notifications when I receive a private message.', 1, 0, 0, 4, 2, NULL, 'userkey'),
(17, 'width', 'Width', 1, 0, 0, 7, 3, NULL, 'filekey'),
(18, 'height', 'Height', 1, 0, 0, 7, 3, NULL, 'filekey'),
(19, 'account_profile_links', 'Personal Links', 0, 0, 0, 15, 2, NULL, 'userkey'),
(20, 'duration', 'Duration', 1, 0, 0, 7, 3, NULL, 'filekey'),
(21, 'thumbnail', 'Thumbnail', 1, 0, 1, 6, 1, NULL, 'pagekey');

-- --------------------------------------------------------

--
-- Table structure for table `AttributeSetKeys`
--

CREATE TABLE `AttributeSetKeys` (
  `asDisplayOrder` int(10) unsigned NOT NULL,
  `akID` int(10) unsigned NOT NULL,
  `asID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`,`asID`),
  KEY `IDX_222F72D8B6561A7E` (`akID`),
  KEY `IDX_222F72D8A463E8B6` (`asID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `AttributeSetKeys`
--

INSERT INTO `AttributeSetKeys` VALUES
(0, 1, 1),
(1, 2, 1),
(1, 7, 2),
(2, 8, 2),
(2, 9, 1),
(4, 10, 2),
(0, 11, 2),
(3, 12, 2),
(3, 13, 1);

-- --------------------------------------------------------

--
-- Table structure for table `AttributeSets`
--

CREATE TABLE `AttributeSets` (
  `asID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `asName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `asDisplayOrder` int(10) unsigned NOT NULL,
  `asIsLocked` tinyint(1) NOT NULL,
  `akCategoryID` int(10) unsigned DEFAULT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`asID`),
  KEY `IDX_FCA02D5FB059B76B` (`akCategoryID`),
  KEY `asHandle` (`asHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `AttributeSets`
--

INSERT INTO `AttributeSets` VALUES
(1, 'seo', 'SEO', 0, 0, 1, NULL),
(2, 'navigation', 'Navigation and Indexing', 0, 0, 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `AttributeTypeCategories`
--

CREATE TABLE `AttributeTypeCategories` (
  `akCategoryID` int(10) unsigned NOT NULL,
  `atID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akCategoryID`,`atID`),
  KEY `IDX_49A9CABEB059B76B` (`akCategoryID`),
  KEY `IDX_49A9CABEA12CFE33` (`atID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `AttributeTypeCategories`
--

INSERT INTO `AttributeTypeCategories` VALUES
(1, 1),
(1, 2),
(1, 3),
(1, 4),
(1, 5),
(1, 6),
(1, 7),
(1, 8),
(1, 10),
(1, 11),
(1, 12),
(1, 13),
(1, 14),
(1, 16),
(1, 17),
(1, 18),
(1, 19),
(1, 20),
(1, 21),
(2, 1),
(2, 2),
(2, 3),
(2, 4),
(2, 5),
(2, 7),
(2, 8),
(2, 9),
(2, 10),
(2, 11),
(2, 12),
(2, 14),
(2, 15),
(2, 18),
(2, 20),
(2, 21),
(3, 1),
(3, 2),
(3, 3),
(3, 4),
(3, 5),
(3, 7),
(3, 8),
(3, 10),
(3, 11),
(3, 12),
(3, 13),
(3, 14),
(3, 18),
(3, 20),
(3, 21),
(4, 1),
(4, 2),
(4, 3),
(4, 4),
(4, 5),
(4, 6),
(4, 7),
(4, 8),
(4, 9),
(4, 10),
(4, 11),
(4, 12),
(4, 14),
(4, 16),
(4, 18),
(4, 19),
(4, 20),
(4, 22),
(5, 1),
(5, 2),
(5, 3),
(5, 4),
(5, 5),
(5, 6),
(5, 7),
(5, 8),
(5, 9),
(5, 10),
(5, 11),
(5, 12),
(5, 14),
(5, 20),
(6, 1),
(6, 2),
(6, 3),
(6, 4),
(6, 5),
(6, 6),
(6, 7),
(6, 8),
(6, 9),
(6, 10),
(6, 11),
(6, 12),
(6, 14),
(6, 16),
(6, 18),
(6, 19),
(6, 20),
(6, 22),
(7, 1),
(7, 2),
(7, 3),
(7, 4),
(7, 5),
(7, 6),
(7, 7),
(7, 8),
(7, 9),
(7, 10),
(7, 11),
(7, 12),
(7, 13),
(7, 14),
(7, 16),
(7, 17),
(7, 19),
(7, 20),
(7, 21),
(7, 22);

-- --------------------------------------------------------

--
-- Table structure for table `AttributeTypes`
--

CREATE TABLE `AttributeTypes` (
  `atID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `atHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `atName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`atID`),
  UNIQUE KEY `UNIQ_53580A7F46AA0F38` (`atHandle`),
  KEY `IDX_53580A7FCE45CBB0` (`pkgID`),
  KEY `pkgID` (`pkgID`,`atID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=23 ;

--
-- Dumping data for table `AttributeTypes`
--

INSERT INTO `AttributeTypes` VALUES
(1, 'text', 'Text', NULL),
(2, 'duration', 'Duration', NULL),
(3, 'textarea', 'Text Area', NULL),
(4, 'boolean', 'Checkbox', NULL),
(5, 'date_time', 'Date/Time', NULL),
(6, 'image_file', 'Image/File', NULL),
(7, 'number', 'Number', NULL),
(8, 'select', 'Option List', NULL),
(9, 'address', 'Address', NULL),
(10, 'telephone', 'Phone Number', NULL),
(11, 'url', 'URL', NULL),
(12, 'email', 'Email', NULL),
(13, 'rating', 'Rating', NULL),
(14, 'topics', 'Topics', NULL),
(15, 'social_links', 'Social Links', NULL),
(16, 'calendar', 'Calendar', NULL),
(17, 'calendar_event', 'Calendar Event', NULL),
(18, 'express', 'Express Entity', NULL),
(19, 'page_selector', 'Page Selector', NULL),
(20, 'user_selector', 'User Selector', NULL),
(21, 'site', 'Site', NULL),
(22, 'user_group', 'User Group', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `AttributeValues`
--

CREATE TABLE `AttributeValues` (
  `avID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `akID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`avID`),
  KEY `IDX_DCCE7864B6561A7E` (`akID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=194 ;

--
-- Dumping data for table `AttributeValues`
--

INSERT INTO `AttributeValues` VALUES
(2, 3),
(3, 3),
(4, 3),
(5, 3),
(6, 3),
(8, 3),
(9, 3),
(11, 3),
(12, 3),
(13, 3),
(14, 3),
(15, 3),
(16, 3),
(17, 3),
(18, 3),
(20, 3),
(22, 3),
(45, 3),
(46, 3),
(49, 3),
(50, 3),
(52, 3),
(53, 3),
(54, 3),
(55, 3),
(56, 3),
(66, 3),
(67, 3),
(68, 3),
(74, 3),
(77, 3),
(78, 3),
(79, 3),
(80, 3),
(81, 3),
(82, 3),
(83, 3),
(84, 3),
(85, 3),
(86, 3),
(87, 3),
(88, 3),
(90, 3),
(91, 3),
(92, 3),
(93, 3),
(95, 3),
(96, 3),
(99, 3),
(100, 3),
(101, 3),
(112, 3),
(113, 3),
(114, 3),
(115, 3),
(116, 3),
(117, 3),
(118, 3),
(119, 3),
(120, 3),
(121, 3),
(122, 3),
(124, 3),
(125, 3),
(126, 3),
(127, 3),
(128, 3),
(129, 3),
(130, 3),
(131, 3),
(132, 3),
(133, 3),
(134, 3),
(135, 3),
(136, 3),
(137, 3),
(138, 3),
(139, 3),
(140, 3),
(141, 3),
(142, 3),
(145, 3),
(146, 3),
(147, 3),
(148, 3),
(149, 3),
(150, 3),
(151, 3),
(152, 3),
(153, 3),
(154, 3),
(155, 3),
(156, 3),
(157, 3),
(158, 3),
(159, 3),
(160, 3),
(161, 3),
(162, 3),
(163, 3),
(164, 3),
(165, 3),
(166, 3),
(167, 3),
(168, 3),
(169, 3),
(170, 3),
(172, 3),
(173, 3),
(174, 3),
(175, 3),
(176, 3),
(177, 3),
(178, 3),
(179, 3),
(180, 3),
(181, 3),
(182, 4),
(191, 4),
(183, 5),
(192, 5),
(1, 6),
(73, 6),
(185, 6),
(186, 6),
(187, 6),
(189, 6),
(190, 6),
(7, 7),
(10, 7),
(19, 7),
(21, 7),
(23, 7),
(25, 7),
(27, 7),
(29, 7),
(31, 7),
(33, 7),
(35, 7),
(37, 7),
(39, 7),
(41, 7),
(43, 7),
(47, 7),
(51, 7),
(57, 7),
(58, 7),
(59, 7),
(60, 7),
(61, 7),
(62, 7),
(63, 7),
(64, 7),
(65, 7),
(69, 7),
(71, 7),
(75, 7),
(94, 7),
(97, 7),
(102, 7),
(104, 7),
(106, 7),
(108, 7),
(110, 7),
(123, 7),
(143, 7),
(144, 7),
(184, 7),
(193, 7),
(24, 12),
(26, 12),
(28, 12),
(30, 12),
(32, 12),
(34, 12),
(36, 12),
(38, 12),
(40, 12),
(42, 12),
(44, 12),
(48, 12),
(70, 12),
(72, 12),
(76, 12),
(89, 12),
(98, 12),
(103, 12),
(105, 12),
(107, 12),
(109, 12),
(111, 12),
(171, 12),
(188, 12);

-- --------------------------------------------------------

--
-- Table structure for table `atUserGroupSettings`
--

CREATE TABLE `atUserGroupSettings` (
  `akDisplayGroupsBeneathSpecificParent` tinyint(1) NOT NULL,
  `akDisplayGroupsBeneathParentID` int(11) NOT NULL,
  `akGroupSelectionMethod` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `AuthenticationTypes`
--

CREATE TABLE `AuthenticationTypes` (
  `authTypeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `authTypeHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `authTypeName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `authTypeIsEnabled` tinyint(1) NOT NULL,
  `authTypeDisplayOrder` int(10) unsigned DEFAULT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`authTypeID`),
  UNIQUE KEY `authTypeHandle` (`authTypeHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `AuthenticationTypes`
--

INSERT INTO `AuthenticationTypes` VALUES
(1, 'concrete', 'Standard', 1, 0, 0),
(2, 'community', 'community.concretecms.com', 0, 0, 0),
(3, 'facebook', 'Facebook', 0, 0, 0),
(4, 'google', 'Google', 0, 0, 0),
(5, 'external_concrete', 'External Concrete Site', 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `authTypeConcreteCookieMap`
--

CREATE TABLE `authTypeConcreteCookieMap` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uID` int(11) DEFAULT NULL,
  `validThrough` int(11) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `token` (`token`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `BannedWords`
--

CREATE TABLE `BannedWords` (
  `bwID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bannedWord` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`bwID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `BannedWords`
--

INSERT INTO `BannedWords` VALUES
(1, 'fuck'),
(2, 'shit'),
(3, 'bitch'),
(4, 'ass');

-- --------------------------------------------------------

--
-- Table structure for table `BasicWorkflowPermissionAssignments`
--

CREATE TABLE `BasicWorkflowPermissionAssignments` (
  `wfID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`wfID`,`pkID`,`paID`),
  KEY `pkID` (`pkID`),
  KEY `paID` (`paID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `BasicWorkflowProgressData`
--

CREATE TABLE `BasicWorkflowProgressData` (
  `wpID` int(10) unsigned NOT NULL DEFAULT '0',
  `uIDStarted` int(10) unsigned NOT NULL DEFAULT '0',
  `uIDCompleted` int(10) unsigned NOT NULL DEFAULT '0',
  `wpDateCompleted` datetime DEFAULT NULL,
  PRIMARY KEY (`wpID`),
  KEY `uIDStarted` (`uIDStarted`),
  KEY `uIDCompleted` (`uIDCompleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `BlockPermissionAssignments`
--

CREATE TABLE `BlockPermissionAssignments` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '0',
  `bID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`bID`,`pkID`,`paID`),
  KEY `bID` (`bID`),
  KEY `pkID` (`pkID`),
  KEY `paID` (`paID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `Blocks`
--

CREATE TABLE `Blocks` (
  `bID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bName` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bDateAdded` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `bDateModified` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `bFilename` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bIsActive` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `btID` int(10) unsigned NOT NULL DEFAULT '0',
  `uID` int(10) unsigned DEFAULT NULL,
  `btCachedBlockRecord` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`bID`),
  KEY `btID` (`btID`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=22 ;

--
-- Dumping data for table `Blocks`
--

INSERT INTO `Blocks` VALUES
(1, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 43, 1, NULL),
(2, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 52, 1, NULL),
(3, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 47, 1, NULL),
(4, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, NULL),
(5, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 51, 1, NULL),
(6, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 52, 1, NULL),
(7, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 19, 1, NULL),
(8, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 19, 1, NULL),
(9, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 52, 1, NULL),
(10, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 50, 1, NULL),
(11, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 50, 1, NULL),
(12, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 50, 1, NULL),
(13, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 52, 1, NULL),
(14, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 48, 1, NULL),
(15, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 52, 1, NULL),
(16, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 49, 1, NULL),
(17, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 52, 1, NULL),
(18, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 48, 1, NULL),
(19, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 52, 1, NULL),
(20, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 49, 1, NULL),
(21, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 55, 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `BlockTypePermissionBlockTypeAccessList`
--

CREATE TABLE `BlockTypePermissionBlockTypeAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`),
  KEY `peID` (`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `BlockTypePermissionBlockTypeAccessListCustom`
--

CREATE TABLE `BlockTypePermissionBlockTypeAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `btID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`btID`),
  KEY `peID` (`peID`),
  KEY `btID` (`btID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `BlockTypes`
--

CREATE TABLE `BlockTypes` (
  `btIgnorePageThemeGridFrameworkContainer` tinyint(1) NOT NULL,
  `btID` int(11) NOT NULL AUTO_INCREMENT,
  `btHandle` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `btName` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `btDescription` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `btCopyWhenPropagate` tinyint(1) NOT NULL,
  `btIncludeAll` tinyint(1) NOT NULL,
  `btIsInternal` tinyint(1) NOT NULL,
  `btSupportsInlineEdit` tinyint(1) NOT NULL,
  `btSupportsInlineAdd` tinyint(1) NOT NULL,
  `btDisplayOrder` int(11) NOT NULL,
  `btInterfaceHeight` int(11) NOT NULL,
  `btInterfaceWidth` int(11) NOT NULL,
  `pkgID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`btID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=61 ;

--
-- Dumping data for table `BlockTypes`
--

INSERT INTO `BlockTypes` VALUES
(0, 1, 'content', 'Content', 'HTML/WYSIWYG Editor Content.', 0, 0, 0, 1, 1, 0, 465, 600, 0),
(1, 2, 'html', 'HTML', 'For adding HTML by hand.', 0, 0, 0, 0, 0, 0, 500, 600, 0),
(1, 3, 'hero_image', 'Hero Image', 'Places a large image on top of a page, with an optional title, description and call to action button.', 0, 0, 0, 0, 0, 0, 500, 640, 0),
(0, 4, 'image', 'Image', 'Adds images and onstates from the library to pages.', 0, 0, 0, 0, 0, 0, 550, 400, 0),
(0, 5, 'file', 'File', 'Link to files stored in the asset library.', 0, 0, 0, 0, 0, 0, 320, 300, 0),
(1, 6, 'horizontal_rule', 'Horizontal Rule', 'Adds a thin hairline horizontal divider to the page.', 0, 0, 0, 0, 0, 0, 400, 400, 0),
(0, 7, 'feature', 'Feature', 'Displays an icon, a title, and a short paragraph description.', 0, 0, 0, 0, 0, 0, 520, 400, 0),
(0, 8, 'feature_link', 'Feature Link', 'Add a title, body and a button/link to a page. Useful for calling out important links.', 0, 0, 0, 0, 0, 0, 500, 640, 0),
(0, 9, 'autonav', 'Auto-Nav', 'Creates navigation trees and sitemaps.', 0, 0, 0, 0, 0, 0, 525, 700, 0),
(0, 10, 'page_title', 'Page Title', 'Displays a Page''s Title', 0, 0, 0, 0, 0, 0, 500, 470, 0),
(0, 11, 'top_navigation_bar', 'Top Navigation Bar', 'Adds a responsive navigation bar with a logo, menu and search.', 0, 0, 0, 0, 0, 0, 500, 640, 0),
(0, 12, 'faq', 'FAQ', 'Frequently Asked Questions Block', 0, 0, 0, 0, 0, 0, 465, 600, 0),
(0, 13, 'accordion', 'Accordion', 'Collapsible content block.', 0, 0, 0, 0, 0, 0, 580, 720, 0),
(0, 14, 'page_list', 'Page List', 'List pages based on type, area.', 0, 0, 0, 0, 0, 0, 525, 700, 0),
(0, 15, 'next_previous', 'Next & Previous Nav', 'Navigate through sibling pages.', 0, 0, 0, 0, 0, 0, 400, 430, 0),
(0, 16, 'date_navigation', 'Date Navigation', 'Displays a list of months to filter a page list by.', 0, 0, 0, 0, 0, 0, 450, 400, 0),
(0, 17, 'tags', 'Tags', 'List pages based on type, area.', 0, 0, 0, 0, 0, 0, 439, 450, 0),
(0, 18, 'topic_list', 'Topic List', 'Displays a list of your site''s topics, allowing you to click on them to filter a page list.', 0, 0, 0, 0, 0, 0, 400, 400, 0),
(0, 19, 'rss_displayer', 'RSS Displayer', 'Fetch, parse and display the contents of an RSS or Atom feed.', 0, 0, 0, 0, 0, 0, 550, 400, 0),
(0, 20, 'switch_language', 'Switch Language', 'Adds a front-end language switcher to your website.', 0, 0, 0, 0, 0, 0, 150, 500, 0),
(0, 21, 'breadcrumbs', 'Breadcrumbs', 'Add a breadcrumbs navigation.', 0, 0, 0, 0, 0, 0, 300, 500, 0),
(0, 22, 'express_form', 'Form', 'Build simple forms and surveys.', 1, 0, 0, 0, 0, 0, 700, 640, 0),
(0, 23, 'search', 'Search', 'Add a search box to your site.', 0, 0, 0, 0, 0, 0, 420, 400, 0),
(0, 24, 'external_form', 'External Form', 'Include external forms in the filesystem and place them on pages.', 0, 0, 0, 0, 0, 0, 175, 420, 0),
(0, 25, 'express_entry_list', 'Express Entry List', 'Add a searchable Express entry list to a page.', 0, 0, 0, 0, 0, 0, 400, 640, 0),
(0, 26, 'express_entry_detail', 'Express Entry Detail', 'Add an Express entry detail display to a page.', 0, 0, 0, 0, 0, 0, 400, 640, 0),
(0, 27, 'survey', 'Survey', 'Provide a simple survey, along with results in a pie chart format.', 0, 0, 0, 0, 0, 0, 500, 500, 0),
(0, 28, 'core_conversation', 'Conversation', 'Displays conversations on a page.', 1, 0, 0, 0, 0, 0, 400, 450, 0),
(0, 29, 'social_links', 'Social Links', 'Allows users to add social icons to their website', 0, 0, 0, 0, 0, 0, 400, 400, 0),
(0, 30, 'testimonial', 'Testimonial', 'Displays a quote or paragraph next to biographical information and a person''s picture.', 0, 0, 0, 0, 0, 0, 560, 450, 0),
(0, 31, 'share_this_page', 'Share This Page', 'Allows users to share this page with social networks.', 0, 0, 0, 0, 0, 0, 400, 400, 0),
(0, 32, 'calendar', 'Calendar', 'Displays a month view calendar on a page.', 0, 0, 0, 0, 0, 0, 475, 500, 0),
(0, 33, 'event_list', 'Event List', 'Displays a list of events from a calendar.', 0, 0, 0, 0, 0, 0, 340, 500, 0),
(0, 34, 'calendar_event', 'Calendar Event', 'Displays a calendar event on a page.', 0, 0, 0, 0, 0, 0, 400, 550, 0),
(0, 35, 'page_attribute_display', 'Page Attribute Display', 'Displays the value of a page attribute for the current page.', 0, 0, 0, 0, 0, 0, 365, 500, 0),
(1, 36, 'image_slider', 'Image Slider', 'Display your images and captions in an attractive slideshow format.', 0, 0, 0, 0, 0, 0, 550, 600, 0),
(0, 37, 'video', 'Video Player', 'Embeds uploaded video into a web page. Supports WebM, Ogg, and Quicktime/MPEG4 formats.', 0, 0, 0, 0, 0, 0, 440, 450, 0),
(0, 38, 'document_library', 'Document Library', 'Add a searchable document library to a page.', 0, 0, 0, 0, 0, 0, 400, 640, 0),
(0, 39, 'youtube', 'YouTube Video', 'Embeds a YouTube Video in your web page.', 0, 0, 0, 0, 0, 0, 490, 400, 0),
(0, 40, 'google_map', 'Google Map', 'Enter an address and a Google Map of that location will be placed in your page.', 0, 0, 0, 0, 0, 0, 550, 525, 0),
(1, 41, 'board', 'Board', 'Adds a Board to your website.', 0, 0, 0, 1, 0, 0, 500, 500, 0),
(0, 42, 'gallery', 'Gallery', 'Creates an Image Gallery in your web page.', 0, 0, 0, 0, 0, 0, 820, 750, 0),
(0, 43, 'desktop_app_status', 'Concrete Status Messages', 'Displays alerts about your Concrete site and package updates.', 0, 0, 0, 0, 0, 0, 400, 400, 0),
(0, 44, 'desktop_site_activity', 'Site Activity', 'Displays a graph of recent activity on your site.', 0, 0, 0, 0, 0, 0, 560, 450, 0),
(0, 45, 'desktop_featured_addon', 'Dashboard Featured Add-On', 'Features an add-on from marketplace.concretecms.com.', 0, 0, 0, 0, 0, 0, 100, 300, 0),
(0, 46, 'desktop_featured_theme', 'Dashboard Featured Theme', 'Features a theme from marketplace.concretecms.com.', 0, 0, 0, 0, 0, 0, 100, 300, 0),
(0, 47, 'desktop_latest_form', 'Latest Form', 'Shows the latest form submission.', 0, 0, 0, 0, 0, 0, 400, 400, 0),
(0, 48, 'desktop_waiting_for_me', 'Waiting for Me', 'Displays workflow actions waiting for you.', 0, 0, 0, 0, 0, 0, 560, 450, 0),
(0, 49, 'desktop_draft_list', 'Draft List', 'Displays a list of all drafts.', 0, 0, 0, 0, 0, 0, 400, 400, 0),
(0, 50, 'desktop_concrete_latest', 'Desktop Latest News', 'Grabs the latest information about Concrete from concretecms.com.', 0, 0, 0, 0, 0, 0, 400, 400, 0),
(0, 51, 'desktop_latest_health_result', 'Desktop Latest Health Result', 'Displays the latest Health Report result on your Dashboard desktop.', 0, 0, 0, 0, 0, 0, 400, 400, 0),
(0, 52, 'core_area_layout', 'Area Layout', 'Proxy block for area layouts.', 0, 0, 1, 1, 1, 0, 400, 400, 0),
(1, 53, 'core_board_slot', 'Board Slot', 'Proxy block for board slots.', 0, 0, 1, 0, 0, 0, 400, 400, 0),
(1, 54, 'core_container', 'Container', 'Proxy block for theme containers added through the UI.', 0, 0, 1, 0, 0, 0, 400, 400, 0),
(0, 55, 'core_page_type_composer_control_output', 'Composer Control', 'Proxy block for blocks that need to be output through composer.', 0, 0, 1, 0, 0, 0, 400, 400, 0),
(0, 56, 'core_scrapbook_display', 'Scrapbook Display', 'Proxy block for blocks pasted through the scrapbook.', 0, 0, 1, 0, 0, 0, 400, 400, 0),
(0, 57, 'core_stack_display', 'Stack Display', 'Proxy block for stacks added through the UI.', 0, 0, 1, 0, 0, 0, 400, 400, 0),
(0, 58, 'core_theme_documentation_breadcrumb', 'Theme Documentation Breadcrumb', 'Adds breadcrumb navigation for use with internal theme documentation.', 0, 0, 1, 0, 0, 0, 400, 400, 0),
(0, 59, 'core_theme_documentation_toc', 'Theme Documentation TOC', 'Displays a table of contents list for theme documentation.', 0, 0, 1, 0, 0, 0, 400, 400, 0),
(0, 60, 'form', 'Legacy Form', 'Build simple forms and surveys.', 1, 0, 0, 0, 0, 0, 550, 525, 0);

-- --------------------------------------------------------

--
-- Table structure for table `BlockTypeSetBlockTypes`
--

CREATE TABLE `BlockTypeSetBlockTypes` (
  `btID` int(10) unsigned NOT NULL DEFAULT '0',
  `btsID` int(10) unsigned NOT NULL DEFAULT '0',
  `displayOrder` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`btID`,`btsID`),
  KEY `btsID` (`btsID`,`displayOrder`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `BlockTypeSetBlockTypes`
--

INSERT INTO `BlockTypeSetBlockTypes` VALUES
(1, 1, 0),
(2, 1, 1),
(3, 1, 2),
(4, 1, 3),
(5, 1, 4),
(6, 1, 5),
(7, 1, 6),
(8, 1, 7),
(9, 2, 0),
(10, 2, 1),
(11, 2, 2),
(13, 2, 3),
(12, 2, 4),
(14, 2, 5),
(15, 2, 6),
(16, 2, 7),
(17, 2, 8),
(18, 2, 9),
(19, 2, 10),
(20, 2, 11),
(21, 2, 12),
(22, 3, 0),
(23, 3, 1),
(24, 3, 2),
(25, 4, 0),
(26, 4, 1),
(27, 5, 0),
(28, 5, 1),
(29, 5, 2),
(30, 5, 3),
(31, 5, 4),
(32, 6, 0),
(33, 6, 1),
(34, 6, 2),
(41, 7, 0),
(35, 7, 1),
(36, 7, 2),
(37, 7, 3),
(38, 7, 4),
(39, 7, 5),
(40, 7, 6),
(42, 7, 7),
(43, 8, 0),
(44, 8, 1),
(45, 8, 2),
(46, 8, 3),
(47, 8, 4),
(48, 8, 5),
(49, 8, 6),
(50, 8, 7),
(51, 8, 8);

-- --------------------------------------------------------

--
-- Table structure for table `BlockTypeSets`
--

CREATE TABLE `BlockTypeSets` (
  `btsID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `btsName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `btsHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  `btsDisplayOrder` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`btsID`),
  UNIQUE KEY `btsHandle` (`btsHandle`),
  KEY `btsDisplayOrder` (`btsDisplayOrder`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=9 ;

--
-- Dumping data for table `BlockTypeSets`
--

INSERT INTO `BlockTypeSets` VALUES
(1, 'Basic', 'basic', 0, 0),
(2, 'Navigation', 'navigation', 0, 0),
(3, 'Forms', 'form', 0, 0),
(4, 'Express', 'express', 0, 0),
(5, 'Social Networking', 'social', 0, 0),
(6, 'Calendar & Events', 'calendar', 0, 0),
(7, 'Multimedia', 'multimedia', 0, 0),
(8, 'Desktop', 'core_desktop', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `BoardConfiguredDataSourceConfiguration`
--

CREATE TABLE `BoardConfiguredDataSourceConfiguration` (
  `configurationID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `configuredDataSourceID` int(10) unsigned DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`configurationID`),
  UNIQUE KEY `UNIQ_80879512E2D47DD5` (`configuredDataSourceID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `BoardConfiguredDataSourceConfigurationCalendarEvent`
--

CREATE TABLE `BoardConfiguredDataSourceConfigurationCalendarEvent` (
  `maxOccurrencesOfSameEvent` int(10) unsigned NOT NULL,
  `query_fields` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_columns` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_itemsPerPage` smallint(6) NOT NULL,
  `caID` int(10) unsigned DEFAULT NULL,
  `configurationID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`configurationID`),
  KEY `IDX_DE5A529911C85723` (`caID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `BoardConfiguredDataSourceConfigurationPage`
--

CREATE TABLE `BoardConfiguredDataSourceConfigurationPage` (
  `query_fields` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_columns` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_itemsPerPage` smallint(6) NOT NULL,
  `configurationID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`configurationID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `BoardConfiguredDataSources`
--

CREATE TABLE `BoardConfiguredDataSources` (
  `configuredDataSourceID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `populationDayIntervalFuture` int(11) NOT NULL,
  `populationDayIntervalPast` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customWeight` int(11) NOT NULL,
  `boardID` int(10) unsigned DEFAULT NULL,
  `dataSourceID` int(11) DEFAULT NULL,
  PRIMARY KEY (`configuredDataSourceID`),
  KEY `IDX_481DA3EF2571BEE` (`boardID`),
  KEY `IDX_481DA3EF3C4EAFF2` (`dataSourceID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `BoardCustomSlotTemplates`
--

CREATE TABLE `BoardCustomSlotTemplates` (
  `boardID` int(10) unsigned NOT NULL,
  `slotTemplateID` int(11) NOT NULL,
  PRIMARY KEY (`boardID`,`slotTemplateID`),
  KEY `IDX_A972DD602571BEE` (`boardID`),
  KEY `IDX_A972DD60E7630775` (`slotTemplateID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `BoardDataSources`
--

CREATE TABLE `BoardDataSources` (
  `dataSourceID` int(11) NOT NULL AUTO_INCREMENT,
  `handle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`dataSourceID`),
  KEY `IDX_DACB5A9ACE45CBB0` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `BoardDataSources`
--

INSERT INTO `BoardDataSources` VALUES
(1, 'page', 'Page', NULL),
(2, 'calendar_event', 'Calendar Event', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `BoardDesignerCustomElementItems`
--

CREATE TABLE `BoardDesignerCustomElementItems` (
  `itemId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `boardItemID` int(10) unsigned DEFAULT NULL,
  `customElementID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`itemId`),
  KEY `IDX_C3E81E43A1BF9938` (`boardItemID`),
  KEY `IDX_C3E81E43DA67F394` (`customElementID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `BoardDesignerCustomElements`
--

CREATE TABLE `BoardDesignerCustomElements` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `elementName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dateCreated` int(10) unsigned NOT NULL,
  `batchIdentifier` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `status` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uID` int(10) unsigned DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contentObjectCollection` json DEFAULT NULL,
  `slotTemplate_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_D2D0FCBDFD71026C` (`uID`),
  KEY `IDX_D2D0FCBD80D42955` (`slotTemplate_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `BoardInstanceItemBatches`
--

CREATE TABLE `BoardInstanceItemBatches` (
  `boardInstanceItemBatchID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dateCreated` int(10) unsigned NOT NULL,
  `boardInstanceID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`boardInstanceItemBatchID`),
  KEY `IDX_968D5F552E21467` (`boardInstanceID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `BoardInstanceItems`
--

CREATE TABLE `BoardInstanceItems` (
  `boardInstanceItemID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dateAddedToBoard` int(10) unsigned NOT NULL,
  `boardItemID` int(10) unsigned DEFAULT NULL,
  `configuredDataSourceID` int(10) unsigned DEFAULT NULL,
  `boardInstanceID` int(10) unsigned DEFAULT NULL,
  `boardInstanceItemBatchID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`boardInstanceItemID`),
  KEY `IDX_285D2C82A1BF9938` (`boardItemID`),
  KEY `IDX_285D2C82E2D47DD5` (`configuredDataSourceID`),
  KEY `IDX_285D2C822E21467` (`boardInstanceID`),
  KEY `IDX_285D2C82E9D76F8E` (`boardInstanceItemBatchID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `BoardInstanceLogEntries`
--

CREATE TABLE `BoardInstanceLogEntries` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `log_id` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `timestamp` int(10) unsigned NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` json DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_4CBE00D8EA675D86` (`log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `BoardInstanceLogs`
--

CREATE TABLE `BoardInstanceLogs` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `dateCreated` int(10) unsigned NOT NULL,
  `boardInstanceID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_BF6A8F2F2E21467` (`boardInstanceID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `BoardInstances`
--

CREATE TABLE `BoardInstances` (
  `boardInstanceID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `boardInstanceName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dateCreated` int(10) unsigned NOT NULL,
  `isGenerating` tinyint(1) NOT NULL,
  `dateDataPoolLastUpdated` int(10) unsigned DEFAULT NULL,
  `dateLastGenerated` int(10) unsigned DEFAULT NULL,
  `boardID` int(10) unsigned DEFAULT NULL,
  `siteID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`boardInstanceID`),
  KEY `IDX_8B85BCCB2571BEE` (`boardID`),
  KEY `IDX_8B85BCCB521D8435` (`siteID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `BoardInstanceSlotRules`
--

CREATE TABLE `BoardInstanceSlotRules` (
  `boardInstanceSlotRuleID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `slot` int(10) unsigned NOT NULL,
  `batchIdentifier` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `bID` int(10) unsigned NOT NULL,
  `notes` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timezone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `isLocked` tinyint(1) NOT NULL,
  `dateCreated` int(10) unsigned NOT NULL,
  `startDate` int(10) unsigned NOT NULL,
  `endDate` int(10) unsigned NOT NULL,
  `ruleType` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `boardInstanceID` int(10) unsigned DEFAULT NULL,
  `uID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`boardInstanceSlotRuleID`),
  KEY `IDX_4BF1A09D2E21467` (`boardInstanceID`),
  KEY `IDX_4BF1A09DFD71026C` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `BoardInstanceSlots`
--

CREATE TABLE `BoardInstanceSlots` (
  `template_id` int(11) DEFAULT NULL,
  `boardInstanceSlotID` int(11) NOT NULL AUTO_INCREMENT,
  `slot` int(11) NOT NULL,
  `bID` int(11) NOT NULL,
  `boardInstanceID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`boardInstanceSlotID`),
  KEY `IDX_137F01F2E21467` (`boardInstanceID`),
  KEY `IDX_137F01F5DA0FB8` (`template_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `BoardItemCategories`
--

CREATE TABLE `BoardItemCategories` (
  `boardItemCategoryID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `treeNodeID` int(10) unsigned NOT NULL,
  `boardItemID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`boardItemCategoryID`),
  KEY `IDX_BEF09673A1BF9938` (`boardItemID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `BoardItems`
--

CREATE TABLE `BoardItems` (
  `boardItemID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dateCreated` int(10) unsigned NOT NULL,
  `relevantDate` int(10) unsigned NOT NULL,
  `uniqueItemId` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` json NOT NULL,
  `fID` int(10) unsigned DEFAULT NULL,
  `dataSourceID` int(11) DEFAULT NULL,
  PRIMARY KEY (`boardItemID`),
  KEY `IDX_E831ECA1E3111F45` (`fID`),
  KEY `IDX_E831ECA13C4EAFF2` (`dataSourceID`),
  KEY `uniqueItemId` (`uniqueItemId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `BoardItemTags`
--

CREATE TABLE `BoardItemTags` (
  `boardItemTagID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tag` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `boardItemID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`boardItemTagID`),
  KEY `IDX_13AEB901A1BF9938` (`boardItemID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `BoardPermissionAssignments`
--

CREATE TABLE `BoardPermissionAssignments` (
  `pkID` int(10) unsigned NOT NULL,
  `paID` int(10) unsigned NOT NULL,
  `boardID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`boardID`,`pkID`,`paID`),
  KEY `IDX_7C073ED92571BEE` (`boardID`),
  KEY `paID` (`paID`),
  KEY `pkID` (`pkID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `Boards`
--

CREATE TABLE `Boards` (
  `template_id` int(11) DEFAULT NULL,
  `boardID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `boardName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sortBy` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hasCustomSlotTemplates` tinyint(1) NOT NULL,
  `hasCustomWeightingRules` tinyint(1) NOT NULL,
  `overridePermissions` tinyint(1) NOT NULL DEFAULT '0',
  `siteID` int(10) unsigned DEFAULT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`boardID`),
  KEY `IDX_F4424825521D8435` (`siteID`),
  KEY `IDX_F44248255DA0FB8` (`template_id`),
  KEY `IDX_F4424825CE45CBB0` (`pkgID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `BoardSlotTemplates`
--

CREATE TABLE `BoardSlotTemplates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `icon` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_6FE111C5CE45CBB0` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `BoardSlotTemplates`
--

INSERT INTO `BoardSlotTemplates` VALUES
(1, 'blank.png', 'Blog Image Left', 'blog_image_left', NULL),
(2, 'blank.png', 'Blog Image Right', 'blog_image_right', NULL),
(3, 'blank.png', 'Blog Two Up', 'blog_two_up', NULL),
(4, 'blank.png', 'Blog Three Up', 'blog_three_up', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `BoardSlotTemplateTags`
--

CREATE TABLE `BoardSlotTemplateTags` (
  `slottemplate_id` int(11) NOT NULL,
  `designtag_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`slottemplate_id`,`designtag_id`),
  KEY `IDX_7BB1975E648A682` (`slottemplate_id`),
  KEY `IDX_7BB1975E960BFEAE` (`designtag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `BoardTemplates`
--

CREATE TABLE `BoardTemplates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `icon` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_9E8AC12CCE45CBB0` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `BoardTemplates`
--

INSERT INTO `BoardTemplates` VALUES
(1, 'blank.png', 'Blog', 'blog', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `btAccordion`
--

CREATE TABLE `btAccordion` (
  `bID` int(10) unsigned NOT NULL,
  `initialState` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'openfirst',
  `itemHeadingFormat` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'h2',
  `alwaysOpen` int(11) DEFAULT NULL,
  `flush` int(11) DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btAccordionEntries`
--

CREATE TABLE `btAccordionEntries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bID` int(10) unsigned DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sortOrder` int(11) DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `bID` (`bID`,`sortOrder`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `btBoard`
--

CREATE TABLE `btBoard` (
  `bID` int(10) unsigned NOT NULL,
  `boardInstanceID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btBreadcrumbs`
--

CREATE TABLE `btBreadcrumbs` (
  `bID` int(10) unsigned NOT NULL,
  `includeCurrent` int(10) unsigned NOT NULL DEFAULT '1',
  `ignoreExcludeNav` int(10) unsigned NOT NULL DEFAULT '1',
  `ignorePermission` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btCalendar`
--

CREATE TABLE `btCalendar` (
  `bID` int(10) unsigned NOT NULL,
  `caID` int(10) unsigned NOT NULL DEFAULT '0',
  `calendarAttributeKeyHandle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filterByTopicAttributeKeyID` int(10) unsigned NOT NULL DEFAULT '0',
  `filterByTopicID` int(10) unsigned NOT NULL DEFAULT '0',
  `viewTypes` longtext COLLATE utf8mb4_unicode_ci,
  `viewTypesOrder` longtext COLLATE utf8mb4_unicode_ci,
  `defaultView` longtext COLLATE utf8mb4_unicode_ci,
  `navLinks` int(11) DEFAULT NULL,
  `eventLimit` int(11) DEFAULT NULL,
  `lightboxProperties` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btCalendarEvent`
--

CREATE TABLE `btCalendarEvent` (
  `bID` int(10) unsigned NOT NULL,
  `mode` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'S' COMMENT 'S = Specify, P = Page, R = Request',
  `calendarEventAttributeKeyHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `calendarID` int(10) unsigned NOT NULL DEFAULT '0',
  `eventID` int(10) unsigned NOT NULL DEFAULT '0',
  `displayEventAttributes` longtext COLLATE utf8mb4_unicode_ci,
  `allowExport` tinyint(1) DEFAULT '0',
  `enableLinkToPage` tinyint(1) DEFAULT '0',
  `displayEventName` tinyint(1) DEFAULT '0',
  `displayEventDate` tinyint(1) DEFAULT '0',
  `displayEventDescription` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btContentFile`
--

CREATE TABLE `btContentFile` (
  `bID` int(10) unsigned NOT NULL,
  `fID` int(10) unsigned DEFAULT NULL,
  `fileLinkText` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filePassword` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `forceDownload` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`bID`),
  KEY `fID` (`fID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btContentImage`
--

CREATE TABLE `btContentImage` (
  `bID` int(10) unsigned NOT NULL,
  `fID` int(10) unsigned DEFAULT '0',
  `fOnstateID` int(10) unsigned DEFAULT '0',
  `cropImage` int(10) unsigned DEFAULT '0',
  `maxWidth` int(10) unsigned DEFAULT '0',
  `maxHeight` int(10) unsigned DEFAULT '0',
  `externalLink` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `internalLinkCID` int(10) unsigned DEFAULT '0',
  `fileLinkID` int(10) unsigned DEFAULT '0',
  `openLinkInNewWindow` tinyint(1) NOT NULL DEFAULT '0',
  `altText` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lazyLoad` int(10) unsigned DEFAULT '0',
  `sizingOption` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT 'thumbnails_default',
  PRIMARY KEY (`bID`),
  KEY `fID` (`fID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btContentImageBreakpoints`
--

CREATE TABLE `btContentImageBreakpoints` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bID` int(10) unsigned DEFAULT NULL,
  `breakpointHandle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ftTypeID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `btContentLocal`
--

CREATE TABLE `btContentLocal` (
  `bID` int(10) unsigned NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btCoreAreaLayout`
--

CREATE TABLE `btCoreAreaLayout` (
  `bID` int(10) unsigned NOT NULL DEFAULT '0',
  `arLayoutID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`bID`),
  KEY `arLayoutID` (`arLayoutID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `btCoreAreaLayout`
--

INSERT INTO `btCoreAreaLayout` VALUES
(2, 1),
(6, 2),
(9, 3),
(13, 4),
(15, 5),
(17, 6),
(19, 7);

-- --------------------------------------------------------

--
-- Table structure for table `btCoreBoardSlot`
--

CREATE TABLE `btCoreBoardSlot` (
  `bID` int(10) unsigned NOT NULL,
  `slotTemplateID` int(10) unsigned NOT NULL DEFAULT '0',
  `contentObjectCollection` json DEFAULT NULL COMMENT '(DC2Type:json_array)',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btCoreContainer`
--

CREATE TABLE `btCoreContainer` (
  `bID` int(10) unsigned NOT NULL,
  `containerInstanceID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`bID`),
  KEY `containerInstanceID` (`containerInstanceID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btCoreConversation`
--

CREATE TABLE `btCoreConversation` (
  `bID` int(10) unsigned NOT NULL,
  `cnvID` int(11) DEFAULT NULL,
  `enablePosting` int(11) DEFAULT '1',
  `paginate` tinyint(1) NOT NULL DEFAULT '1',
  `itemsPerPage` smallint(5) unsigned NOT NULL DEFAULT '50',
  `displayMode` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'threaded',
  `orderBy` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'date_desc',
  `enableOrdering` tinyint(1) NOT NULL DEFAULT '1',
  `enableCommentRating` tinyint(1) NOT NULL DEFAULT '1',
  `enableTopCommentReviews` tinyint(1) NOT NULL DEFAULT '0',
  `displaySocialLinks` tinyint(1) NOT NULL DEFAULT '1',
  `reviewAggregateAttributeKey` int(11) DEFAULT NULL,
  `displayPostingForm` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'top',
  `addMessageLabel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `dateFormat` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT 'default',
  `customDateFormat` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`bID`),
  KEY `cnvID` (`cnvID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btCorePageTypeComposerControlOutput`
--

CREATE TABLE `btCorePageTypeComposerControlOutput` (
  `bID` int(10) unsigned NOT NULL,
  `ptComposerOutputControlID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`bID`),
  KEY `ptComposerOutputControlID` (`ptComposerOutputControlID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `btCorePageTypeComposerControlOutput`
--

INSERT INTO `btCorePageTypeComposerControlOutput` VALUES
(21, 1);

-- --------------------------------------------------------

--
-- Table structure for table `btCoreScrapbookDisplay`
--

CREATE TABLE `btCoreScrapbookDisplay` (
  `bID` int(10) unsigned NOT NULL,
  `bOriginalID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`bID`),
  KEY `bOriginalID` (`bOriginalID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btCoreStackDisplay`
--

CREATE TABLE `btCoreStackDisplay` (
  `bID` int(10) unsigned NOT NULL,
  `stID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`bID`),
  KEY `stID` (`stID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btDateNavigation`
--

CREATE TABLE `btDateNavigation` (
  `bID` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `filterByParent` tinyint(1) DEFAULT '0',
  `redirectToResults` tinyint(1) DEFAULT '0',
  `cParentID` int(10) unsigned NOT NULL DEFAULT '0',
  `cTargetID` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'this field is where the links will direct you',
  `ptID` smallint(5) unsigned DEFAULT NULL,
  `titleFormat` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'h5',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btDesktopConcreteLatest`
--

CREATE TABLE `btDesktopConcreteLatest` (
  `bID` int(10) unsigned NOT NULL,
  `slot` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `btDesktopConcreteLatest`
--

INSERT INTO `btDesktopConcreteLatest` VALUES
(10, 'A'),
(11, 'B'),
(12, 'C');

-- --------------------------------------------------------

--
-- Table structure for table `btDesktopDraftList`
--

CREATE TABLE `btDesktopDraftList` (
  `bID` int(10) unsigned NOT NULL,
  `draftsPerPage` int(11) DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `btDesktopDraftList`
--

INSERT INTO `btDesktopDraftList` VALUES
(16, 10),
(20, 10);

-- --------------------------------------------------------

--
-- Table structure for table `btDesktopSiteActivity`
--

CREATE TABLE `btDesktopSiteActivity` (
  `bID` int(10) unsigned NOT NULL,
  `types` json DEFAULT NULL COMMENT '(DC2Type:json_array)',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `btDesktopSiteActivity`
--

INSERT INTO `btDesktopSiteActivity` VALUES
(4, '["form_submissions", "survey_results", "signups", "conversation_messages", "workflow"]');

-- --------------------------------------------------------

--
-- Table structure for table `btDocumentLibrary`
--

CREATE TABLE `btDocumentLibrary` (
  `bID` int(10) unsigned NOT NULL,
  `setIds` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `folderID` int(11) NOT NULL DEFAULT '0',
  `setMode` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `onlyCurrentUser` int(11) DEFAULT '0',
  `tags` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `viewProperties` longtext COLLATE utf8mb4_unicode_ci,
  `expandableProperties` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `searchProperties` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `orderBy` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT 'title',
  `displayLimit` int(11) DEFAULT '20',
  `displayOrderDesc` tinyint(1) NOT NULL DEFAULT '0',
  `addFilesToSetID` int(10) unsigned NOT NULL DEFAULT '0',
  `maxThumbWidth` int(11) DEFAULT '100',
  `maxThumbHeight` int(11) DEFAULT '150',
  `enableSearch` int(11) DEFAULT '0',
  `heightMode` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT 'auto',
  `downloadFileMethod` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT 'force',
  `fixedHeightSize` int(11) DEFAULT '0',
  `headerBackgroundColor` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `headerBackgroundColorActiveSort` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `headerTextColor` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `allowFileUploading` int(11) DEFAULT '0',
  `allowInPageFileManagement` int(11) DEFAULT '0',
  `tableName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `tableDescription` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `tableStriped` tinyint(1) DEFAULT '0',
  `rowBackgroundColorAlternate` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `hideFolders` int(11) DEFAULT '0',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btEventList`
--

CREATE TABLE `btEventList` (
  `bID` int(10) unsigned NOT NULL,
  `caID` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `calendarAttributeKeyHandle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `totalToRetrieve` smallint(5) unsigned NOT NULL DEFAULT '10',
  `totalPerPage` smallint(5) unsigned NOT NULL DEFAULT '10',
  `filterByTopicAttributeKeyID` int(10) unsigned NOT NULL DEFAULT '0',
  `filterByTopicID` int(10) unsigned NOT NULL DEFAULT '0',
  `filterByPageTopicAttributeKeyHandle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filterByFeatured` tinyint(1) NOT NULL DEFAULT '0',
  `eventListTitle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `linkToPage` int(10) unsigned NOT NULL DEFAULT '0',
  `titleFormat` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'h5',
  `eventPeriod` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'future_events',
  `eventOrder` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'most_recent_first',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btExpressEntryDetail`
--

CREATE TABLE `btExpressEntryDetail` (
  `bID` int(10) unsigned NOT NULL,
  `exEntityID` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `exSpecificEntryID` int(10) unsigned DEFAULT NULL,
  `exEntryAttributeKeyHandle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `exFormID` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `entryMode` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'S',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btExpressEntryList`
--

CREATE TABLE `btExpressEntryList` (
  `bID` int(10) unsigned NOT NULL,
  `exEntityID` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `detailPage` int(10) unsigned NOT NULL DEFAULT '0',
  `linkedProperties` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `searchProperties` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `searchAssociations` longtext COLLATE utf8mb4_unicode_ci,
  `columns` longtext COLLATE utf8mb4_unicode_ci,
  `filterFields` longtext COLLATE utf8mb4_unicode_ci,
  `displayLimit` int(11) DEFAULT '20',
  `enableItemsPerPageSelection` int(11) DEFAULT '0',
  `enablePagination` int(11) DEFAULT '0',
  `enableSearch` int(11) DEFAULT '0',
  `enableKeywordSearch` int(11) DEFAULT '0',
  `headerBackgroundColor` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `headerBackgroundColorActiveSort` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `headerTextColor` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `tableName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `tableDescription` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `tableStriped` tinyint(1) DEFAULT '0',
  `rowBackgroundColorAlternate` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `titleFormat` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'h2',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btExpressForm`
--

CREATE TABLE `btExpressForm` (
  `bID` int(10) unsigned NOT NULL,
  `exFormID` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `submitLabel` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT 'Submit',
  `thankyouMsg` text COLLATE utf8mb4_unicode_ci,
  `notifyMeOnSubmission` tinyint(1) NOT NULL DEFAULT '0',
  `recipientEmail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `displayCaptcha` int(11) DEFAULT '1',
  `storeFormSubmission` tinyint(1) DEFAULT '1',
  `redirectCID` int(11) DEFAULT '0',
  `replyToEmailControlID` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `addFilesToSet` int(11) DEFAULT '0',
  `addFilesToFolder` int(11) DEFAULT '0',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btExternalForm`
--

CREATE TABLE `btExternalForm` (
  `bID` int(10) unsigned NOT NULL,
  `filename` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btFaq`
--

CREATE TABLE `btFaq` (
  `bID` int(10) unsigned NOT NULL,
  `blockTitle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btFaqEntries`
--

CREATE TABLE `btFaqEntries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bID` int(10) unsigned DEFAULT NULL,
  `linkTitle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sortOrder` int(11) DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `bID` (`bID`,`sortOrder`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `btFeature`
--

CREATE TABLE `btFeature` (
  `bID` int(10) unsigned NOT NULL,
  `icon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paragraph` text COLLATE utf8mb4_unicode_ci,
  `externalLink` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `internalLinkCID` int(10) unsigned DEFAULT '0',
  `titleFormat` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'h4',
  `fID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btFeatureLink`
--

CREATE TABLE `btFeatureLink` (
  `bID` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `body` longtext COLLATE utf8mb4_unicode_ci,
  `buttonText` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `buttonExternalLink` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `buttonInternalLinkCID` int(10) unsigned DEFAULT '0',
  `buttonFileLinkID` int(10) unsigned DEFAULT '0',
  `buttonColor` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `buttonStyle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `buttonSize` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `titleFormat` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'h2',
  `icon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btForm`
--

CREATE TABLE `btForm` (
  `bID` int(10) unsigned NOT NULL,
  `questionSetId` int(10) unsigned DEFAULT '0',
  `surveyName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `submitText` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT 'Submit',
  `thankyouMsg` text COLLATE utf8mb4_unicode_ci,
  `notifyMeOnSubmission` tinyint(1) NOT NULL DEFAULT '0',
  `recipientEmail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `displayCaptcha` int(11) DEFAULT '1',
  `redirectCID` int(11) DEFAULT '0',
  `addFilesToSet` int(11) DEFAULT '0',
  PRIMARY KEY (`bID`),
  KEY `questionSetIdForeign` (`questionSetId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btFormAnswers`
--

CREATE TABLE `btFormAnswers` (
  `aID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asID` int(10) unsigned DEFAULT '0',
  `msqID` int(10) unsigned DEFAULT '0',
  `answer` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `answerLong` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`aID`),
  KEY `asID` (`asID`),
  KEY `msqID` (`msqID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `btFormAnswerSet`
--

CREATE TABLE `btFormAnswerSet` (
  `asID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `questionSetId` int(10) unsigned DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `uID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`asID`),
  KEY `questionSetId` (`questionSetId`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `btFormQuestions`
--

CREATE TABLE `btFormQuestions` (
  `qID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `msqID` int(10) unsigned DEFAULT '0',
  `bID` int(10) unsigned DEFAULT '0',
  `questionSetId` int(10) unsigned DEFAULT '0',
  `question` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `inputType` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `position` int(10) unsigned DEFAULT '1000',
  `width` int(10) unsigned DEFAULT '50',
  `height` int(10) unsigned DEFAULT '3',
  `defaultDate` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `required` int(11) DEFAULT '0',
  PRIMARY KEY (`qID`),
  KEY `questionSetId` (`questionSetId`),
  KEY `msqID` (`msqID`),
  KEY `bID` (`bID`,`questionSetId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `btGallery`
--

CREATE TABLE `btGallery` (
  `bID` int(10) unsigned NOT NULL,
  `includeDownloadLink` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btGalleryEntries`
--

CREATE TABLE `btGalleryEntries` (
  `eID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bID` int(10) unsigned DEFAULT NULL,
  `idx` int(10) unsigned DEFAULT NULL,
  `fID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`eID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `btGalleryEntryDisplayChoices`
--

CREATE TABLE `btGalleryEntryDisplayChoices` (
  `dcID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `entryID` int(10) unsigned DEFAULT NULL,
  `bID` int(10) unsigned DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci,
  `dcKey` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`dcID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `btGoogleMap`
--

CREATE TABLE `btGoogleMap` (
  `bID` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `latitude` double DEFAULT NULL,
  `longitude` double DEFAULT NULL,
  `zoom` smallint(6) DEFAULT NULL,
  `width` varchar(8) COLLATE utf8mb4_unicode_ci DEFAULT '100%',
  `height` varchar(8) COLLATE utf8mb4_unicode_ci DEFAULT '400px',
  `scrollwheel` tinyint(1) NOT NULL DEFAULT '1',
  `titleFormat` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'h3',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btHeroImage`
--

CREATE TABLE `btHeroImage` (
  `bID` int(10) unsigned NOT NULL,
  `image` int(11) DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `body` longtext COLLATE utf8mb4_unicode_ci,
  `buttonText` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `buttonExternalLink` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `buttonInternalLinkCID` int(10) unsigned DEFAULT '0',
  `buttonFileLinkID` int(10) unsigned DEFAULT '0',
  `height` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `buttonColor` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `buttonStyle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `buttonSize` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `titleFormat` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'h1',
  `icon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btImageSlider`
--

CREATE TABLE `btImageSlider` (
  `bID` int(10) unsigned NOT NULL,
  `navigationType` int(10) unsigned DEFAULT '0',
  `timeout` int(10) unsigned DEFAULT NULL,
  `speed` int(10) unsigned DEFAULT NULL,
  `noAnimate` int(10) unsigned DEFAULT NULL,
  `pause` int(10) unsigned DEFAULT NULL,
  `maxWidth` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btImageSliderEntries`
--

CREATE TABLE `btImageSliderEntries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bID` int(10) unsigned DEFAULT NULL,
  `cID` int(10) unsigned DEFAULT '0',
  `fID` int(10) unsigned DEFAULT '0',
  `linkURL` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `internalLinkCID` int(10) unsigned DEFAULT '0',
  `title` longtext COLLATE utf8mb4_unicode_ci,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `sortOrder` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `btNavigation`
--

CREATE TABLE `btNavigation` (
  `bID` int(10) unsigned NOT NULL,
  `orderBy` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT 'alpha_asc',
  `displayPages` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT 'top' COMMENT 'was enum(''top'',''current'',''above'',''below'',''custom'')',
  `displayPagesCID` int(10) unsigned NOT NULL DEFAULT '1',
  `displayPagesIncludeSelf` tinyint(1) NOT NULL DEFAULT '0',
  `displaySubPages` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT 'none' COMMENT 'was enum(''none'',''all'',''relevant'',''relevant_breadcrumb'')',
  `displaySubPageLevels` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT 'none' COMMENT 'was enum(''all'',''none'',''enough'',''enough_plus1'',''custom'')',
  `displaySubPageLevelsNum` smallint(5) unsigned NOT NULL DEFAULT '0',
  `displayUnavailablePages` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btNextPrevious`
--

CREATE TABLE `btNextPrevious` (
  `bID` int(10) unsigned NOT NULL,
  `nextLabel` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `previousLabel` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parentLabel` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `loopSequence` int(11) DEFAULT '1',
  `orderBy` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT 'display_asc',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btPageAttributeDisplay`
--

CREATE TABLE `btPageAttributeDisplay` (
  `bID` int(10) unsigned NOT NULL,
  `attributeHandle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attributeTitleText` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `displayTag` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dateFormat` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT 'div',
  `thumbnailHeight` int(10) unsigned DEFAULT NULL,
  `thumbnailWidth` int(10) unsigned DEFAULT NULL,
  `delimiter` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btPageList`
--

CREATE TABLE `btPageList` (
  `bID` int(10) unsigned NOT NULL,
  `num` smallint(5) unsigned NOT NULL,
  `orderBy` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Was enum, display_asc'',''display_desc'',''chrono_asc'',''chrono_desc'',''alpha_asc'',''alpha_desc'',''score_asc'',''score_desc''',
  `cParentID` int(10) unsigned NOT NULL DEFAULT '1',
  `cThis` tinyint(1) NOT NULL DEFAULT '0',
  `cThisParent` tinyint(1) NOT NULL DEFAULT '0',
  `useButtonForLink` tinyint(1) NOT NULL DEFAULT '0',
  `buttonLinkText` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pageListTitle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filterByRelated` tinyint(1) NOT NULL DEFAULT '0',
  `filterByCustomTopic` tinyint(1) NOT NULL DEFAULT '0',
  `filterDateOption` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT 'all' COMMENT '(''all'',''today'',''past'',''future'',''between'')',
  `filterDateDays` int(10) unsigned NOT NULL DEFAULT '0',
  `filterDateStart` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filterDateEnd` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `relatedTopicAttributeKeyHandle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customTopicAttributeKeyHandle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customTopicTreeNodeID` int(10) unsigned NOT NULL DEFAULT '0',
  `includeName` tinyint(1) NOT NULL DEFAULT '1',
  `includeDescription` tinyint(1) NOT NULL DEFAULT '1',
  `includeDate` tinyint(1) NOT NULL DEFAULT '0',
  `includeAllDescendents` tinyint(1) NOT NULL DEFAULT '0',
  `paginate` tinyint(1) NOT NULL DEFAULT '0',
  `displayAliases` tinyint(1) NOT NULL DEFAULT '1',
  `displaySystemPages` tinyint(1) NOT NULL DEFAULT '0',
  `ignorePermissions` tinyint(1) NOT NULL DEFAULT '0',
  `enableExternalFiltering` tinyint(1) NOT NULL DEFAULT '0',
  `excludeCurrentPage` tinyint(1) NOT NULL DEFAULT '0',
  `ptID` smallint(5) unsigned DEFAULT NULL,
  `pfID` int(11) DEFAULT '0',
  `truncateSummaries` int(11) DEFAULT '0',
  `displayFeaturedOnly` tinyint(1) DEFAULT '0',
  `noResultsMessage` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `displayThumbnail` tinyint(1) DEFAULT '0',
  `truncateChars` int(11) DEFAULT '128',
  `titleFormat` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'h5',
  PRIMARY KEY (`bID`),
  KEY `ptID` (`ptID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btPageTitle`
--

CREATE TABLE `btPageTitle` (
  `bID` int(10) unsigned NOT NULL,
  `useCustomTitle` int(10) unsigned DEFAULT '0',
  `useFilterTitle` int(10) unsigned DEFAULT '0',
  `useFilterTopic` int(10) unsigned DEFAULT '0',
  `useFilterTag` int(10) unsigned DEFAULT '0',
  `useFilterDate` int(10) unsigned DEFAULT '0',
  `topicTextFormat` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tagTextFormat` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dateTextFormat` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filterDateFormat` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `titleText` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `formatting` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btRssDisplay`
--

CREATE TABLE `btRssDisplay` (
  `bID` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dateFormat` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `itemsToDisplay` int(10) unsigned DEFAULT '5',
  `showSummary` tinyint(1) NOT NULL DEFAULT '1',
  `launchInNewWindow` tinyint(1) NOT NULL DEFAULT '1',
  `titleFormat` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'h5',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `btRssDisplay`
--

INSERT INTO `btRssDisplay` VALUES
(7, 'Tutorials', 'https://documentation.concretecms.org/rss/tutorials', ':longDate:', 1, 1, 1, ''),
(8, 'News from concretecms.com', 'https://www.concretecms.com/rss/blog', ':longDate:', 3, 1, 1, '');

-- --------------------------------------------------------

--
-- Table structure for table `btSearch`
--

CREATE TABLE `btSearch` (
  `bID` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `buttonText` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `baseSearchPath` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `search_all` tinyint(1) DEFAULT NULL,
  `allow_user_options` tinyint(1) DEFAULT NULL,
  `postTo_cID` int(10) unsigned DEFAULT NULL,
  `resultsURL` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btShareThisPage`
--

CREATE TABLE `btShareThisPage` (
  `btShareThisPageID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bID` int(10) unsigned DEFAULT '0',
  `service` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `displayOrder` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`btShareThisPageID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `btSocialLinks`
--

CREATE TABLE `btSocialLinks` (
  `btSocialLinkID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bID` int(10) unsigned DEFAULT '0',
  `slID` int(10) unsigned DEFAULT '0',
  `displayOrder` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`btSocialLinkID`),
  KEY `bID` (`bID`,`displayOrder`),
  KEY `slID` (`slID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `btSurvey`
--

CREATE TABLE `btSurvey` (
  `bID` int(10) unsigned NOT NULL,
  `question` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `requiresRegistration` int(11) DEFAULT '0',
  `showResults` int(11) DEFAULT '0',
  `customMessage` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btSurveyOptions`
--

CREATE TABLE `btSurveyOptions` (
  `optionID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bID` int(11) DEFAULT NULL,
  `optionName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `displayOrder` int(11) DEFAULT '0',
  PRIMARY KEY (`optionID`),
  KEY `bID` (`bID`,`displayOrder`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `btSurveyResults`
--

CREATE TABLE `btSurveyResults` (
  `resultID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `optionID` int(10) unsigned DEFAULT '0',
  `uID` int(10) unsigned DEFAULT '0',
  `bID` int(11) DEFAULT NULL,
  `cID` int(11) DEFAULT NULL,
  `ipAddress` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`resultID`),
  KEY `optionID` (`optionID`),
  KEY `cID` (`cID`,`optionID`,`bID`),
  KEY `bID` (`bID`,`cID`,`uID`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `btSwitchLanguage`
--

CREATE TABLE `btSwitchLanguage` (
  `bID` int(10) unsigned NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btTags`
--

CREATE TABLE `btTags` (
  `bID` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `targetCID` int(11) DEFAULT NULL,
  `displayMode` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT 'page',
  `cloudCount` int(11) DEFAULT '10',
  `titleFormat` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'h5',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btTestimonial`
--

CREATE TABLE `btTestimonial` (
  `bID` int(10) unsigned NOT NULL,
  `fID` int(10) unsigned DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `companyURL` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paragraph` text COLLATE utf8mb4_unicode_ci,
  `awardImageID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btTopicList`
--

CREATE TABLE `btTopicList` (
  `bID` int(10) unsigned NOT NULL,
  `mode` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'S' COMMENT 'S = Search, P = Page',
  `topicAttributeKeyHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `topicTreeID` int(10) unsigned NOT NULL DEFAULT '0',
  `cParentID` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `titleFormat` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'h5',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btTopNavigationBar`
--

CREATE TABLE `btTopNavigationBar` (
  `bID` int(10) unsigned NOT NULL,
  `brandingText` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `brandingLogo` int(11) DEFAULT NULL,
  `brandingTransparentLogo` int(11) DEFAULT NULL,
  `includeBrandText` tinyint(1) DEFAULT NULL,
  `includeBrandLogo` tinyint(1) DEFAULT NULL,
  `includeTransparency` tinyint(1) DEFAULT NULL,
  `includeStickyNav` tinyint(1) DEFAULT NULL,
  `includeNavigation` tinyint(1) DEFAULT NULL,
  `includeNavigationDropdowns` tinyint(1) DEFAULT NULL,
  `includeSearchInput` tinyint(1) DEFAULT NULL,
  `searchInputFormActionPageID` int(11) DEFAULT NULL,
  `includeSwitchLanguage` tinyint(1) DEFAULT NULL,
  `ignorePermissions` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btVideo`
--

CREATE TABLE `btVideo` (
  `bID` int(10) unsigned NOT NULL,
  `webmfID` int(10) unsigned DEFAULT '0',
  `oggfID` int(10) unsigned DEFAULT '0',
  `posterfID` int(10) unsigned DEFAULT '0',
  `mp4fID` int(10) unsigned DEFAULT '0',
  `videoSize` int(10) unsigned DEFAULT '0',
  `width` int(10) unsigned DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btYouTube`
--

CREATE TABLE `btYouTube` (
  `bID` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `videoURL` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vHeight` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vWidth` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sizing` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `startTimeEnabled` tinyint(1) DEFAULT NULL,
  `startTime` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `noCookie` tinyint(1) DEFAULT NULL,
  `autoplay` tinyint(1) NOT NULL DEFAULT '0',
  `color` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `controls` int(10) unsigned DEFAULT NULL,
  `iv_load_policy` int(10) unsigned DEFAULT NULL,
  `loopEnd` tinyint(1) NOT NULL DEFAULT '0',
  `modestbranding` tinyint(1) NOT NULL DEFAULT '0',
  `lazyLoad` tinyint(1) NOT NULL DEFAULT '0',
  `rel` tinyint(1) NOT NULL DEFAULT '0',
  `showCaptions` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarEventAttributeKeys`
--

CREATE TABLE `CalendarEventAttributeKeys` (
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarEventCustomSummaryTemplates`
--

CREATE TABLE `CalendarEventCustomSummaryTemplates` (
  `template_id` int(11) NOT NULL,
  `eventID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eventID`,`template_id`),
  KEY `IDX_7059BBEF10409BA4` (`eventID`),
  KEY `IDX_7059BBEF5DA0FB8` (`template_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarEventOccurrences`
--

CREATE TABLE `CalendarEventOccurrences` (
  `occurrenceID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `startTime` int(11) NOT NULL,
  `endTime` int(11) NOT NULL,
  `cancelled` tinyint(1) NOT NULL,
  `repetitionID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`occurrenceID`),
  KEY `IDX_7DD686EC31391E00` (`repetitionID`),
  KEY `eventdates` (`occurrenceID`,`startTime`,`endTime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarEventRepetitions`
--

CREATE TABLE `CalendarEventRepetitions` (
  `repetitionID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `repetitionObject` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  PRIMARY KEY (`repetitionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarEvents`
--

CREATE TABLE `CalendarEvents` (
  `hasCustomSummaryTemplates` tinyint(1) NOT NULL,
  `eventID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `caID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`eventID`),
  KEY `IDX_7F23C55611C85723` (`caID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarEventSearchIndexAttributes`
--

CREATE TABLE `CalendarEventSearchIndexAttributes` (
  `eventID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`eventID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarEventSummaryTemplates`
--

CREATE TABLE `CalendarEventSummaryTemplates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template_id` int(11) DEFAULT NULL,
  `data` json NOT NULL,
  `eventID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_219AA86B10409BA4` (`eventID`),
  KEY `IDX_219AA86B5DA0FB8` (`template_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarEventVersionAttributeValues`
--

CREATE TABLE `CalendarEventVersionAttributeValues` (
  `eventVersionID` int(10) unsigned NOT NULL,
  `akID` int(10) unsigned NOT NULL,
  `avID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`eventVersionID`,`akID`),
  KEY `IDX_8C835B05403F5D6` (`eventVersionID`),
  KEY `IDX_8C835B05B6561A7E` (`akID`),
  KEY `IDX_8C835B05A2A82A5D` (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarEventVersionOccurrences`
--

CREATE TABLE `CalendarEventVersionOccurrences` (
  `versionOccurrenceID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `eventVersionID` int(10) unsigned DEFAULT NULL,
  `occurrenceID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`versionOccurrenceID`),
  KEY `IDX_60310489403F5D6` (`eventVersionID`),
  KEY `IDX_60310489B4FDDC0F` (`occurrenceID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarEventVersionRepetitions`
--

CREATE TABLE `CalendarEventVersionRepetitions` (
  `versionRepetitionID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `eventVersionID` int(10) unsigned DEFAULT NULL,
  `repetitionID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`versionRepetitionID`),
  KEY `IDX_C1C3D3DB403F5D6` (`eventVersionID`),
  KEY `IDX_C1C3D3DB31391E00` (`repetitionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarEventVersions`
--

CREATE TABLE `CalendarEventVersions` (
  `eventVersionID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `evDateAdded` datetime NOT NULL,
  `evActivateDateTime` datetime DEFAULT NULL,
  `evIsApproved` tinyint(1) NOT NULL,
  `evDescription` longtext COLLATE utf8mb4_unicode_ci,
  `evName` longtext COLLATE utf8mb4_unicode_ci,
  `evRelatedPageRelationType` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `eventID` int(10) unsigned DEFAULT NULL,
  `uID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`eventVersionID`),
  KEY `IDX_8E26027410409BA4` (`eventID`),
  KEY `IDX_8E260274FD71026C` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarEventWorkflowProgress`
--

CREATE TABLE `CalendarEventWorkflowProgress` (
  `wpID` int(10) unsigned NOT NULL DEFAULT '0',
  `eventID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eventID`,`wpID`),
  KEY `IDX_C5EAACF910409BA4` (`eventID`),
  KEY `wpID` (`wpID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarPermissionAssignments`
--

CREATE TABLE `CalendarPermissionAssignments` (
  `pkID` int(10) unsigned NOT NULL,
  `paID` int(10) unsigned NOT NULL,
  `caID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`caID`,`pkID`,`paID`),
  KEY `IDX_5AD546AA11C85723` (`caID`),
  KEY `paID` (`paID`),
  KEY `pkID` (`pkID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarRelatedEvents`
--

CREATE TABLE `CalendarRelatedEvents` (
  `relatedEventID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `relationID` int(10) unsigned NOT NULL,
  `relationType` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `eventID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`relatedEventID`),
  KEY `IDX_310130E910409BA4` (`eventID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `Calendars`
--

CREATE TABLE `Calendars` (
  `caID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `caName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `caOverridePermissions` tinyint(1) NOT NULL DEFAULT '0',
  `eventPageAttributeKeyHandle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enableMoreDetails` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `eventPageParentID` int(10) unsigned DEFAULT '0',
  `eventPageTypeID` int(10) unsigned DEFAULT '0',
  `eventPageAssociatedID` int(10) unsigned DEFAULT '0',
  `siteID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`caID`),
  KEY `IDX_62E00AC521D8435` (`siteID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `CollectionAttributeKeys`
--

CREATE TABLE `CollectionAttributeKeys` (
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `CollectionAttributeKeys`
--

INSERT INTO `CollectionAttributeKeys` VALUES
(1),
(2),
(3),
(4),
(5),
(6),
(7),
(8),
(9),
(10),
(11),
(12),
(13),
(14),
(21);

-- --------------------------------------------------------

--
-- Table structure for table `CollectionAttributeValues`
--

CREATE TABLE `CollectionAttributeValues` (
  `cID` int(10) unsigned NOT NULL,
  `cvID` int(10) unsigned NOT NULL,
  `akID` int(10) unsigned NOT NULL,
  `avID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`cID`,`cvID`,`akID`),
  KEY `IDX_BB9995FCB6561A7E` (`akID`),
  KEY `IDX_BB9995FCA2A82A5D` (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `CollectionAttributeValues`
--

INSERT INTO `CollectionAttributeValues` VALUES
(2, 1, 6, 1),
(3, 1, 3, 2),
(4, 1, 3, 3),
(5, 1, 3, 4),
(6, 1, 3, 5),
(8, 1, 3, 6),
(9, 1, 7, 7),
(10, 1, 3, 8),
(11, 1, 3, 9),
(12, 1, 7, 10),
(12, 1, 3, 11),
(13, 1, 3, 12),
(14, 1, 3, 13),
(15, 1, 3, 14),
(16, 1, 3, 15),
(17, 1, 3, 16),
(18, 1, 3, 17),
(19, 1, 3, 18),
(19, 1, 7, 19),
(20, 1, 3, 20),
(20, 1, 7, 21),
(23, 1, 3, 22),
(29, 1, 7, 23),
(29, 1, 12, 24),
(30, 1, 7, 25),
(30, 1, 12, 26),
(31, 1, 7, 27),
(31, 1, 12, 28),
(32, 1, 7, 29),
(32, 1, 12, 30),
(33, 1, 7, 31),
(33, 1, 12, 32),
(34, 1, 7, 33),
(34, 1, 12, 34),
(35, 1, 7, 35),
(35, 1, 12, 36),
(36, 1, 7, 37),
(36, 1, 12, 38),
(37, 1, 7, 39),
(37, 1, 12, 40),
(39, 1, 7, 41),
(39, 1, 12, 42),
(40, 1, 7, 43),
(40, 1, 12, 44),
(42, 1, 3, 45),
(43, 1, 3, 46),
(44, 1, 7, 47),
(44, 1, 12, 48),
(45, 1, 3, 49),
(46, 1, 3, 50),
(46, 1, 7, 51),
(47, 1, 3, 52),
(48, 1, 3, 53),
(49, 1, 3, 54),
(51, 1, 3, 55),
(52, 1, 3, 56),
(52, 1, 7, 57),
(54, 1, 7, 58),
(55, 1, 7, 59),
(56, 1, 7, 60),
(57, 1, 7, 61),
(58, 1, 7, 62),
(59, 1, 7, 63),
(61, 1, 7, 64),
(63, 1, 7, 65),
(64, 1, 3, 66),
(65, 1, 3, 67),
(66, 1, 3, 68),
(69, 1, 7, 69),
(69, 1, 12, 70),
(71, 1, 7, 71),
(71, 1, 12, 72),
(74, 1, 6, 73),
(76, 1, 3, 74),
(78, 1, 7, 75),
(78, 1, 12, 76),
(78, 1, 3, 77),
(79, 1, 3, 78),
(80, 1, 3, 79),
(81, 1, 3, 80),
(82, 1, 3, 81),
(83, 1, 3, 82),
(84, 1, 3, 83),
(85, 1, 3, 84),
(87, 1, 3, 85),
(88, 1, 3, 86),
(89, 1, 3, 87),
(90, 1, 3, 88),
(91, 1, 12, 89),
(92, 1, 3, 90),
(93, 1, 3, 91),
(94, 1, 3, 92),
(95, 1, 3, 93),
(95, 1, 7, 94),
(96, 1, 3, 95),
(97, 1, 3, 96),
(97, 1, 7, 97),
(97, 1, 12, 98),
(98, 1, 3, 99),
(100, 1, 3, 100),
(101, 1, 3, 101),
(104, 1, 7, 102),
(104, 1, 12, 103),
(105, 1, 7, 104),
(105, 1, 12, 105),
(106, 1, 7, 106),
(106, 1, 12, 107),
(107, 1, 7, 108),
(107, 1, 12, 109),
(108, 1, 7, 110),
(108, 1, 12, 111),
(114, 1, 3, 112),
(120, 1, 3, 113),
(121, 1, 3, 114),
(122, 1, 3, 115),
(123, 1, 3, 116),
(124, 1, 3, 117),
(125, 1, 3, 118),
(127, 1, 3, 119),
(128, 1, 3, 120),
(129, 1, 3, 121),
(130, 1, 3, 122),
(131, 1, 7, 123),
(131, 1, 3, 124),
(132, 1, 3, 125),
(133, 1, 3, 126),
(134, 1, 3, 127),
(135, 1, 3, 128),
(136, 1, 3, 129),
(137, 1, 3, 130),
(139, 1, 3, 131),
(140, 1, 3, 132),
(141, 1, 3, 133),
(142, 1, 3, 134),
(145, 1, 3, 135),
(146, 1, 3, 136),
(148, 1, 3, 137),
(149, 1, 3, 138),
(150, 1, 3, 139),
(152, 1, 3, 140),
(153, 1, 3, 141),
(157, 1, 3, 142),
(158, 1, 7, 143),
(159, 1, 7, 144),
(160, 1, 3, 145),
(161, 1, 3, 146),
(162, 1, 3, 147),
(163, 1, 3, 148),
(165, 1, 3, 149),
(166, 1, 3, 150),
(167, 1, 3, 151),
(168, 1, 3, 152),
(169, 1, 3, 153),
(171, 1, 3, 154),
(172, 1, 3, 155),
(173, 1, 3, 156),
(174, 1, 3, 157),
(175, 1, 3, 158),
(176, 1, 3, 159),
(177, 1, 3, 160),
(178, 1, 3, 161),
(179, 1, 3, 162),
(189, 1, 3, 163),
(190, 1, 3, 164),
(191, 1, 3, 165),
(192, 1, 3, 166),
(194, 1, 3, 167),
(195, 1, 3, 168),
(196, 1, 3, 169),
(197, 1, 3, 170),
(199, 1, 12, 171),
(200, 1, 3, 172),
(201, 1, 3, 173),
(202, 1, 3, 174),
(203, 1, 3, 175),
(204, 1, 3, 176),
(205, 1, 3, 177),
(206, 1, 3, 178),
(207, 1, 3, 179),
(209, 1, 3, 180),
(213, 1, 3, 181),
(214, 1, 4, 182),
(214, 1, 5, 183),
(214, 1, 7, 184),
(217, 1, 6, 185),
(218, 1, 6, 186),
(220, 1, 6, 187),
(221, 1, 12, 188),
(223, 1, 6, 189),
(229, 1, 6, 190),
(230, 1, 4, 191),
(230, 1, 5, 192),
(230, 1, 7, 193);

-- --------------------------------------------------------

--
-- Table structure for table `Collections`
--

CREATE TABLE `Collections` (
  `cID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cDateAdded` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `cDateModified` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `cHandle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`cID`),
  KEY `cIDDateModified` (`cID`,`cDateModified`),
  KEY `cDateModified` (`cDateModified`),
  KEY `cDateAdded` (`cDateAdded`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=232 ;

--
-- Dumping data for table `Collections`
--

INSERT INTO `Collections` VALUES
(1, '[[date_gmt]]', '[[date_gmt]]', NULL),
(2, '[[date_gmt]]', '[[date_gmt]]', 'dashboard'),
(3, '[[date_gmt]]', '[[date_gmt]]', 'sitemap'),
(4, '[[date_gmt]]', '[[date_gmt]]', 'full'),
(5, '[[date_gmt]]', '[[date_gmt]]', 'explore'),
(6, '[[date_gmt]]', '[[date_gmt]]', 'search'),
(7, '[[date_gmt]]', '[[date_gmt]]', 'files'),
(8, '[[date_gmt]]', '[[date_gmt]]', 'search'),
(9, '[[date_gmt]]', '[[date_gmt]]', 'details'),
(10, '[[date_gmt]]', '[[date_gmt]]', 'attributes'),
(11, '[[date_gmt]]', '[[date_gmt]]', 'sets'),
(12, '[[date_gmt]]', '[[date_gmt]]', 'add_set'),
(13, '[[date_gmt]]', '[[date_gmt]]', 'users'),
(14, '[[date_gmt]]', '[[date_gmt]]', 'search'),
(15, '[[date_gmt]]', '[[date_gmt]]', 'groups'),
(16, '[[date_gmt]]', '[[date_gmt]]', 'group_types'),
(17, '[[date_gmt]]', '[[date_gmt]]', 'message'),
(18, '[[date_gmt]]', '[[date_gmt]]', 'attributes'),
(19, '[[date_gmt]]', '[[date_gmt]]', 'add'),
(20, '[[date_gmt]]', '[[date_gmt]]', 'add_group'),
(21, '[[date_gmt]]', '[[date_gmt]]', 'bulkupdate'),
(22, '[[date_gmt]]', '[[date_gmt]]', 'bulk_user_assignment'),
(23, '[[date_gmt]]', '[[date_gmt]]', 'group_sets'),
(24, '[[date_gmt]]', '[[date_gmt]]', 'express'),
(25, '[[date_gmt]]', '[[date_gmt]]', 'entries'),
(26, '[[date_gmt]]', '[[date_gmt]]', 'boards'),
(27, '[[date_gmt]]', '[[date_gmt]]', 'boards'),
(28, '[[date_gmt]]', '[[date_gmt]]', 'add'),
(29, '[[date_gmt]]', '[[date_gmt]]', 'details'),
(30, '[[date_gmt]]', '[[date_gmt]]', 'edit'),
(31, '[[date_gmt]]', '[[date_gmt]]', 'data_sources'),
(32, '[[date_gmt]]', '[[date_gmt]]', 'appearance'),
(33, '[[date_gmt]]', '[[date_gmt]]', 'weighting'),
(34, '[[date_gmt]]', '[[date_gmt]]', 'permissions'),
(35, '[[date_gmt]]', '[[date_gmt]]', 'instances'),
(36, '[[date_gmt]]', '[[date_gmt]]', 'details'),
(37, '[[date_gmt]]', '[[date_gmt]]', 'rules'),
(38, '[[date_gmt]]', '[[date_gmt]]', 'designer'),
(39, '[[date_gmt]]', '[[date_gmt]]', 'choose_items'),
(40, '[[date_gmt]]', '[[date_gmt]]', 'customize_slot'),
(41, '[[date_gmt]]', '[[date_gmt]]', 'scheduler'),
(42, '[[date_gmt]]', '[[date_gmt]]', 'reports'),
(43, '[[date_gmt]]', '[[date_gmt]]', 'forms'),
(44, '[[date_gmt]]', '[[date_gmt]]', 'legacy'),
(45, '[[date_gmt]]', '[[date_gmt]]', 'health'),
(46, '[[date_gmt]]', '[[date_gmt]]', 'details'),
(47, '[[date_gmt]]', '[[date_gmt]]', 'surveys'),
(48, '[[date_gmt]]', '[[date_gmt]]', 'logs'),
(49, '[[date_gmt]]', '[[date_gmt]]', 'page_changes'),
(50, '[[date_gmt]]', '[[date_gmt]]', 'pages'),
(51, '[[date_gmt]]', '[[date_gmt]]', 'themes'),
(52, '[[date_gmt]]', '[[date_gmt]]', 'inspect'),
(53, '[[date_gmt]]', '[[date_gmt]]', 'types'),
(54, '[[date_gmt]]', '[[date_gmt]]', 'organize'),
(55, '[[date_gmt]]', '[[date_gmt]]', 'add'),
(56, '[[date_gmt]]', '[[date_gmt]]', 'form'),
(57, '[[date_gmt]]', '[[date_gmt]]', 'output'),
(58, '[[date_gmt]]', '[[date_gmt]]', 'attributes'),
(59, '[[date_gmt]]', '[[date_gmt]]', 'permissions'),
(60, '[[date_gmt]]', '[[date_gmt]]', 'templates'),
(61, '[[date_gmt]]', '[[date_gmt]]', 'add'),
(62, '[[date_gmt]]', '[[date_gmt]]', 'containers'),
(63, '[[date_gmt]]', '[[date_gmt]]', 'add'),
(64, '[[date_gmt]]', '[[date_gmt]]', 'attributes'),
(65, '[[date_gmt]]', '[[date_gmt]]', 'single'),
(66, '[[date_gmt]]', '[[date_gmt]]', 'feeds'),
(67, '[[date_gmt]]', '[[date_gmt]]', 'calendar'),
(68, '[[date_gmt]]', '[[date_gmt]]', 'events'),
(69, '[[date_gmt]]', '[[date_gmt]]', 'event_list'),
(70, '[[date_gmt]]', '[[date_gmt]]', 'add'),
(71, '[[date_gmt]]', '[[date_gmt]]', 'permissions'),
(72, '[[date_gmt]]', '[[date_gmt]]', 'attributes'),
(73, '[[date_gmt]]', '[[date_gmt]]', 'conversations'),
(74, '[[date_gmt]]', '[[date_gmt]]', 'messages'),
(75, '[[date_gmt]]', '[[date_gmt]]', 'blocks'),
(76, '[[date_gmt]]', '[[date_gmt]]', 'stacks'),
(77, '[[date_gmt]]', '[[date_gmt]]', 'permissions'),
(78, '[[date_gmt]]', '[[date_gmt]]', 'list'),
(79, '[[date_gmt]]', '[[date_gmt]]', 'types'),
(80, '[[date_gmt]]', '[[date_gmt]]', 'extend'),
(81, '[[date_gmt]]', '[[date_gmt]]', 'install'),
(82, '[[date_gmt]]', '[[date_gmt]]', 'update'),
(83, '[[date_gmt]]', '[[date_gmt]]', 'themes'),
(84, '[[date_gmt]]', '[[date_gmt]]', 'addons'),
(85, '[[date_gmt]]', '[[date_gmt]]', 'system'),
(86, '[[date_gmt]]', '[[date_gmt]]', 'basics'),
(87, '[[date_gmt]]', '[[date_gmt]]', 'name'),
(88, '[[date_gmt]]', '[[date_gmt]]', 'marketplace'),
(89, '[[date_gmt]]', '[[date_gmt]]', 'production_mode'),
(90, '[[date_gmt]]', '[[date_gmt]]', 'appearance'),
(91, '[[date_gmt]]', '[[date_gmt]]', 'site_information'),
(92, '[[date_gmt]]', '[[date_gmt]]', 'icons'),
(93, '[[date_gmt]]', '[[date_gmt]]', 'editor'),
(94, '[[date_gmt]]', '[[date_gmt]]', 'multilingual'),
(95, '[[date_gmt]]', '[[date_gmt]]', 'update'),
(96, '[[date_gmt]]', '[[date_gmt]]', 'timezone'),
(97, '[[date_gmt]]', '[[date_gmt]]', 'attributes'),
(98, '[[date_gmt]]', '[[date_gmt]]', 'reset_edit_mode'),
(99, '[[date_gmt]]', '[[date_gmt]]', 'social'),
(100, '[[date_gmt]]', '[[date_gmt]]', 'social_links'),
(101, '[[date_gmt]]', '[[date_gmt]]', 'opengraph'),
(102, '[[date_gmt]]', '[[date_gmt]]', 'express'),
(103, '[[date_gmt]]', '[[date_gmt]]', 'entities'),
(104, '[[date_gmt]]', '[[date_gmt]]', 'attributes'),
(105, '[[date_gmt]]', '[[date_gmt]]', 'associations'),
(106, '[[date_gmt]]', '[[date_gmt]]', 'forms'),
(107, '[[date_gmt]]', '[[date_gmt]]', 'customize_search'),
(108, '[[date_gmt]]', '[[date_gmt]]', 'order_entries'),
(109, '[[date_gmt]]', '[[date_gmt]]', 'entries'),
(110, '[[date_gmt]]', '[[date_gmt]]', 'multisite'),
(111, '[[date_gmt]]', '[[date_gmt]]', 'sites'),
(112, '[[date_gmt]]', '[[date_gmt]]', 'types'),
(113, '[[date_gmt]]', '[[date_gmt]]', 'settings'),
(114, '[[date_gmt]]', '[[date_gmt]]', 'multilingual'),
(115, '[[date_gmt]]', '[[date_gmt]]', 'setup'),
(116, '[[date_gmt]]', '[[date_gmt]]', 'copy'),
(117, '[[date_gmt]]', '[[date_gmt]]', 'page_report'),
(118, '[[date_gmt]]', '[[date_gmt]]', 'translate_interface'),
(119, '[[date_gmt]]', '[[date_gmt]]', 'seo'),
(120, '[[date_gmt]]', '[[date_gmt]]', 'urls'),
(121, '[[date_gmt]]', '[[date_gmt]]', 'bulk'),
(122, '[[date_gmt]]', '[[date_gmt]]', 'codes'),
(123, '[[date_gmt]]', '[[date_gmt]]', 'excluded'),
(124, '[[date_gmt]]', '[[date_gmt]]', 'searchindex'),
(125, '[[date_gmt]]', '[[date_gmt]]', 'url_slug'),
(126, '[[date_gmt]]', '[[date_gmt]]', 'files'),
(127, '[[date_gmt]]', '[[date_gmt]]', 'filetypes'),
(128, '[[date_gmt]]', '[[date_gmt]]', 'file_chooser'),
(129, '[[date_gmt]]', '[[date_gmt]]', 'permissions'),
(130, '[[date_gmt]]', '[[date_gmt]]', 'thumbnails'),
(131, '[[date_gmt]]', '[[date_gmt]]', 'options'),
(132, '[[date_gmt]]', '[[date_gmt]]', 'image_uploading'),
(133, '[[date_gmt]]', '[[date_gmt]]', 'image_editor'),
(134, '[[date_gmt]]', '[[date_gmt]]', 'storage'),
(135, '[[date_gmt]]', '[[date_gmt]]', 'external_file_provider'),
(136, '[[date_gmt]]', '[[date_gmt]]', 'export_options'),
(137, '[[date_gmt]]', '[[date_gmt]]', 'uploads'),
(138, '[[date_gmt]]', '[[date_gmt]]', 'automation'),
(139, '[[date_gmt]]', '[[date_gmt]]', 'tasks'),
(140, '[[date_gmt]]', '[[date_gmt]]', 'activity'),
(141, '[[date_gmt]]', '[[date_gmt]]', 'failed'),
(142, '[[date_gmt]]', '[[date_gmt]]', 'schedule'),
(143, '[[date_gmt]]', '[[date_gmt]]', 'settings'),
(144, '[[date_gmt]]', '[[date_gmt]]', 'notification'),
(145, '[[date_gmt]]', '[[date_gmt]]', 'events'),
(146, '[[date_gmt]]', '[[date_gmt]]', 'alerts'),
(147, '[[date_gmt]]', '[[date_gmt]]', 'optimization'),
(148, '[[date_gmt]]', '[[date_gmt]]', 'cache'),
(149, '[[date_gmt]]', '[[date_gmt]]', 'clearcache'),
(150, '[[date_gmt]]', '[[date_gmt]]', 'jobs'),
(151, '[[date_gmt]]', '[[date_gmt]]', 'permissions'),
(152, '[[date_gmt]]', '[[date_gmt]]', 'site'),
(153, '[[date_gmt]]', '[[date_gmt]]', 'tasks'),
(154, '[[date_gmt]]', '[[date_gmt]]', 'users'),
(155, '[[date_gmt]]', '[[date_gmt]]', 'advanced'),
(156, '[[date_gmt]]', '[[date_gmt]]', 'workflows'),
(157, '[[date_gmt]]', '[[date_gmt]]', 'denylist'),
(158, '[[date_gmt]]', '[[date_gmt]]', 'configure'),
(159, '[[date_gmt]]', '[[date_gmt]]', 'range'),
(160, '[[date_gmt]]', '[[date_gmt]]', 'captcha'),
(161, '[[date_gmt]]', '[[date_gmt]]', 'antispam'),
(162, '[[date_gmt]]', '[[date_gmt]]', 'maintenance'),
(163, '[[date_gmt]]', '[[date_gmt]]', 'trusted_proxies'),
(164, '[[date_gmt]]', '[[date_gmt]]', 'registration'),
(165, '[[date_gmt]]', '[[date_gmt]]', 'open'),
(166, '[[date_gmt]]', '[[date_gmt]]', 'postlogin'),
(167, '[[date_gmt]]', '[[date_gmt]]', 'profiles'),
(168, '[[date_gmt]]', '[[date_gmt]]', 'authentication'),
(169, '[[date_gmt]]', '[[date_gmt]]', 'global_password_reset'),
(170, '[[date_gmt]]', '[[date_gmt]]', 'deactivation'),
(171, '[[date_gmt]]', '[[date_gmt]]', 'automated_logout'),
(172, '[[date_gmt]]', '[[date_gmt]]', 'password_requirements'),
(173, '[[date_gmt]]', '[[date_gmt]]', 'session_options'),
(174, '[[date_gmt]]', '[[date_gmt]]', 'mail'),
(175, '[[date_gmt]]', '[[date_gmt]]', 'method'),
(176, '[[date_gmt]]', '[[date_gmt]]', 'test'),
(177, '[[date_gmt]]', '[[date_gmt]]', 'importers'),
(178, '[[date_gmt]]', '[[date_gmt]]', 'addresses'),
(179, '[[date_gmt]]', '[[date_gmt]]', 'logging'),
(180, '[[date_gmt]]', '[[date_gmt]]', 'calendar'),
(181, '[[date_gmt]]', '[[date_gmt]]', 'settings'),
(182, '[[date_gmt]]', '[[date_gmt]]', 'colors'),
(183, '[[date_gmt]]', '[[date_gmt]]', 'permissions'),
(184, '[[date_gmt]]', '[[date_gmt]]', 'import'),
(185, '[[date_gmt]]', '[[date_gmt]]', 'boards'),
(186, '[[date_gmt]]', '[[date_gmt]]', 'settings'),
(187, '[[date_gmt]]', '[[date_gmt]]', 'permissions'),
(188, '[[date_gmt]]', '[[date_gmt]]', 'summary_templates'),
(189, '[[date_gmt]]', '[[date_gmt]]', 'conversations'),
(190, '[[date_gmt]]', '[[date_gmt]]', 'settings'),
(191, '[[date_gmt]]', '[[date_gmt]]', 'points'),
(192, '[[date_gmt]]', '[[date_gmt]]', 'bannedwords'),
(193, '[[date_gmt]]', '[[date_gmt]]', 'permissions'),
(194, '[[date_gmt]]', '[[date_gmt]]', 'attributes'),
(195, '[[date_gmt]]', '[[date_gmt]]', 'types'),
(196, '[[date_gmt]]', '[[date_gmt]]', 'sets'),
(197, '[[date_gmt]]', '[[date_gmt]]', 'topics'),
(198, '[[date_gmt]]', '[[date_gmt]]', 'add'),
(199, '[[date_gmt]]', '[[date_gmt]]', 'environment'),
(200, '[[date_gmt]]', '[[date_gmt]]', 'info'),
(201, '[[date_gmt]]', '[[date_gmt]]', 'errors'),
(202, '[[date_gmt]]', '[[date_gmt]]', 'logging'),
(203, '[[date_gmt]]', '[[date_gmt]]', 'proxy'),
(204, '[[date_gmt]]', '[[date_gmt]]', 'entities'),
(205, '[[date_gmt]]', '[[date_gmt]]', 'database_charset'),
(206, '[[date_gmt]]', '[[date_gmt]]', 'geolocation'),
(207, '[[date_gmt]]', '[[date_gmt]]', 'security'),
(208, '[[date_gmt]]', '[[date_gmt]]', 'update'),
(209, '[[date_gmt]]', '[[date_gmt]]', 'update'),
(210, '[[date_gmt]]', '[[date_gmt]]', 'api'),
(211, '[[date_gmt]]', '[[date_gmt]]', 'integrations'),
(212, '[[date_gmt]]', '[[date_gmt]]', 'scopes'),
(213, '[[date_gmt]]', '[[date_gmt]]', 'settings'),
(214, '[[date_gmt]]', '[[date_gmt]]', 'welcome'),
(215, '[[date_gmt]]', '[[date_gmt]]', 'health'),
(216, '[[date_gmt]]', '[[date_gmt]]', 'me'),
(217, '[[date_gmt]]', '[[date_gmt]]', '!themes'),
(218, '[[date_gmt]]', '[[date_gmt]]', '!stacks'),
(219, '[[date_gmt]]', '[[date_gmt]]', 'page_not_found'),
(220, '[[date_gmt]]', '[[date_gmt]]', '!trash'),
(221, '[[date_gmt]]', '[[date_gmt]]', 'login'),
(222, '[[date_gmt]]', '[[date_gmt]]', 'register'),
(223, '[[date_gmt]]', '[[date_gmt]]', 'account'),
(224, '[[date_gmt]]', '[[date_gmt]]', 'edit_profile'),
(225, '[[date_gmt]]', '[[date_gmt]]', 'avatar'),
(226, '[[date_gmt]]', '[[date_gmt]]', 'messages'),
(227, '[[date_gmt]]', '[[date_gmt]]', 'page_forbidden'),
(228, '[[date_gmt]]', '[[date_gmt]]', 'download_file'),
(229, '[[date_gmt]]', '[[date_gmt]]', '!drafts'),
(230, '[[date_gmt]]', '[[date_gmt]]', 'desktop'),
(231, '[[date_gmt]]', '[[date_gmt]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `CollectionSearchIndexAttributes`
--

CREATE TABLE `CollectionSearchIndexAttributes` (
  `cID` int(10) unsigned NOT NULL,
  `ak_meta_title` longtext COLLATE utf8mb4_unicode_ci,
  `ak_meta_description` longtext COLLATE utf8mb4_unicode_ci,
  `ak_meta_keywords` longtext COLLATE utf8mb4_unicode_ci,
  `ak_desktop_priority` decimal(14,4) DEFAULT '0.0000',
  `ak_is_desktop` tinyint(1) DEFAULT '0',
  `ak_icon_dashboard` longtext COLLATE utf8mb4_unicode_ci,
  `ak_exclude_nav` tinyint(1) DEFAULT '0',
  `ak_exclude_page_list` tinyint(1) DEFAULT '0',
  `ak_header_extra_content` longtext COLLATE utf8mb4_unicode_ci,
  `ak_tags` longtext COLLATE utf8mb4_unicode_ci,
  `ak_is_featured` tinyint(1) DEFAULT '0',
  `ak_exclude_search_index` tinyint(1) DEFAULT '0',
  `ak_exclude_sitemapxml` tinyint(1) DEFAULT '0',
  `ak_exclude_subpages_from_nav` tinyint(1) DEFAULT '0',
  `ak_thumbnail` int(11) DEFAULT '0',
  PRIMARY KEY (`cID`),
  KEY `ak_exclude_page_list` (`ak_exclude_page_list`,`cID`),
  KEY `ak_is_featured` (`ak_is_featured`,`cID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `CollectionSearchIndexAttributes`
--

INSERT INTO `CollectionSearchIndexAttributes` VALUES
(2, NULL, NULL, NULL, '0.0000', 0, 'fas fa-th-large', 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(3, NULL, NULL, 'pages, add page, delete page, copy, move, alias', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(4, NULL, NULL, 'pages, add page, delete page, copy, move, alias', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(5, NULL, NULL, 'pages, add page, delete page, copy, move, alias, bulk', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(6, NULL, NULL, 'find page, search page, search, find, pages, sitemap', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(8, NULL, NULL, 'add file, delete file, copy, move, alias, resize, crop, rename, images, title, attribute', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(9, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, 0, 0),
(10, NULL, NULL, 'file, file attributes, title, attribute, description, rename', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(11, NULL, NULL, 'files, category, categories', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(12, NULL, NULL, 'new file set', '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, 0, 0),
(13, NULL, NULL, 'users, groups, people, find, delete user, remove user, change password, password', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(14, NULL, NULL, 'find, search, people, delete user, remove user, change password, password', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(15, NULL, NULL, 'user, group, people, permissions, expire', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(16, NULL, NULL, 'group types, group type', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(17, NULL, NULL, 'user, group, people, messages', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(18, NULL, NULL, 'user attributes, user data, gather data, registration data', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(19, NULL, NULL, 'new user, create', '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, 0, 0),
(20, NULL, NULL, 'new user group, new group, group, create', '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, 0, 0),
(23, NULL, NULL, 'group set', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(29, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, 0, 0),
(30, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, 0, 0),
(31, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, 0, 0),
(32, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, 0, 0),
(33, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, 0, 0),
(34, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, 0, 0),
(35, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, 0, 0),
(36, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, 0, 0),
(37, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, 0, 0),
(39, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, 0, 0),
(40, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, 0, 0),
(42, NULL, NULL, 'forms, log, error, email, mysql, exception, survey', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(43, NULL, NULL, 'forms, questions, response, data', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(44, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, 0, 0),
(45, NULL, NULL, 'health, check, site check, optimization', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(46, NULL, NULL, 'page types', '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, 0, 0),
(47, NULL, NULL, 'questions, quiz, response', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(48, NULL, NULL, 'forms, log, error, email, mysql, exception, survey, history', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(49, NULL, NULL, 'changes, csv, report', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(51, NULL, NULL, 'new theme, theme, active theme, change theme, template, css', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(52, NULL, NULL, 'page types', '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, 0, 0),
(54, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, 0, 0),
(55, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, 0, 0),
(56, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, 0, 0),
(57, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, 0, 0),
(58, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, 0, 0),
(59, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, 0, 0),
(61, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, 0, 0),
(63, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, 0, 0),
(64, NULL, NULL, 'page attributes, custom', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(65, NULL, NULL, 'single, page, custom, application', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(66, NULL, NULL, 'atom, rss, feed, syndication', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(69, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, 0, 0),
(71, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, 0, 0),
(74, NULL, NULL, NULL, '0.0000', 0, 'icon-bullhorn', 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(76, NULL, NULL, 'stacks, global areas, reusable content, scrapbook, copy, paste, paste block, copy block, site name, logo', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(78, NULL, NULL, 'edit stacks, view stacks, all stacks', '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, 0, 0),
(79, NULL, NULL, 'block, refresh, custom', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(80, NULL, NULL, 'add-on, addon, add on, package, app, ecommerce, discussions, forums, themes, templates, blocks', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(81, NULL, NULL, 'add-on, addon, ecommerce, install, discussions, forums, themes, templates, blocks', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(82, NULL, NULL, 'update, upgrade', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(83, NULL, NULL, 'buy theme, new theme, marketplace, template', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(84, NULL, NULL, 'buy addon, buy add on, buy add-on, purchase addon, purchase add on, purchase add-on, find addon, new addon, marketplace', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(85, NULL, NULL, 'dashboard, configuration', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(87, NULL, NULL, 'website name, title', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(88, NULL, NULL, 'concretecms.com, my account, purchase, extensions, marketplace', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(89, NULL, NULL, 'production, staging, site copy, development copy, local', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(90, NULL, NULL, 'accessibility, appearance, dark mode, tooltips', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(91, NULL, NULL, NULL, '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 1, 0, 0, 0),
(92, NULL, NULL, 'logo, favicon, iphone, icon, bookmark', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(93, NULL, NULL, 'tinymce, content block, fonts, editor, content, overlay', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(94, NULL, NULL, 'translate, translation, internationalization, multilingual', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(95, NULL, NULL, 'languages, update, gettext, translation, translate', '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, 0, 0),
(96, NULL, NULL, 'timezone, profile, locale', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(97, NULL, NULL, 'site attributes', '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, 0, 0),
(98, NULL, NULL, 'checkin, check-in, check, force', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(100, NULL, NULL, 'sharing, facebook, twitter', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(101, NULL, NULL, 'sharing, opengraph, schema', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(104, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, 0, 0),
(105, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, 0, 0),
(106, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, 0, 0),
(107, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, 0, 0),
(108, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, 0, 0),
(114, NULL, NULL, 'multilingual, localization, internationalization, i18n', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(120, NULL, NULL, 'vanity, pretty url, redirection, hostname, canonical, seo, pageview, view', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(121, NULL, NULL, 'bulk, seo, change keywords, engine, optimization, search', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(122, NULL, NULL, 'traffic, statistics, google analytics, quant, pageviews, hits', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(123, NULL, NULL, 'pretty, slug', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(124, NULL, NULL, 'configure search, site search, search option', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(125, NULL, NULL, 'url, slug', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(127, NULL, NULL, 'security, files, media, extension, manager, upload', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(128, NULL, NULL, 'file, chooser', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(129, NULL, NULL, 'file options, file manager, upload, modify', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(130, NULL, NULL, 'images, picture, responsive, retina', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(131, NULL, NULL, 'thumbnail, format, png, jpg, jpeg, quality, compression, gd, imagick, imagemagick, transparency', '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, 0, 0),
(132, NULL, NULL, 'uploading, upload, images, image, resizing, manager, exif, rotation, rotate, quality, compression, png, jpg, jpeg', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(133, NULL, NULL, 'image, editor, active, default, edit, png, jpg, jpeg', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(134, NULL, NULL, 'security, alternate storage, hide files', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(135, NULL, NULL, 'external, file, providers', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(136, NULL, NULL, 'files, export, csv, bom, encoding', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(137, NULL, NULL, 'files, upload, parallel, upload_max_filesize, post_max_size, limit, resize, chunk', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(139, NULL, NULL, 'automated jobs, commands, tasks, console, cli', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(140, NULL, NULL, 'processes, queues, jobs, running', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(141, NULL, NULL, 'failed messages, retry', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(142, NULL, NULL, 'cron, scheduling, jobs', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(145, NULL, NULL, 'websocket, socket, socket.io, push, push notifications, mercure', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(146, NULL, NULL, 'waiting for me, inbox, notifications', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(148, NULL, NULL, 'cache option, change cache, override, turn on cache, turn off cache, no cache, page cache, caching', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(149, NULL, NULL, 'cache option, turn off cache, no cache, page cache, caching', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(150, NULL, NULL, 'index search, reindex search, build sitemap, sitemap.xml, clear old versions, page versions, remove old', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(152, NULL, NULL, 'editors, hide site, offline, private, public, access', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(153, NULL, NULL, 'security, actions, administrator, admin, package, marketplace, search', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(157, NULL, NULL, 'security, lock ip, lock out, block ip, address, restrict, access', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(158, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, 0, 0),
(159, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, 0, 0),
(160, NULL, NULL, 'security, registration', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(161, NULL, NULL, 'antispam, block spam, security', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(162, NULL, NULL, 'lock site, under construction, hide, hidden', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(163, NULL, NULL, 'trusted, proxy, proxies, ip, header, cloudflare', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(165, NULL, NULL, 'signup, new user, community, public registration, public, registration', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(166, NULL, NULL, 'profile, login, redirect, specific, dashboard, administrators', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(167, NULL, NULL, 'member profile, member page, community, forums, social, avatar', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(168, NULL, NULL, 'auth, authentication, types, oauth, facebook, login, registration', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(169, NULL, NULL, 'global, password, reset, change password, force, sign out', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(171, NULL, NULL, 'login, logout, user, agent, ip, change, security, session, invalidation, invalid', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(172, NULL, NULL, 'password, requirements, code, key, login, registration, security, nist', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(173, NULL, NULL, 'session, options', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(174, NULL, NULL, 'smtp, mail settings', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(175, NULL, NULL, 'email server, mail settings, mail configuration, external, internal', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(176, NULL, NULL, 'test smtp, test mail', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(177, NULL, NULL, 'email server, mail settings, mail configuration, private message, message system, import, email, message', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(178, NULL, NULL, 'mail settings, mail configuration, email, sender', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(179, NULL, NULL, 'email logging, mail logging, log mails, log emails', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(189, NULL, NULL, 'conversations', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(190, NULL, NULL, 'conversations', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(191, NULL, NULL, 'conversations ratings, ratings, community, community points', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(192, NULL, NULL, 'conversations bad words, banned words, banned, bad words, bad, words, list', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(194, NULL, NULL, 'attribute configuration', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(195, NULL, NULL, 'attributes, types', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(196, NULL, NULL, 'attributes, sets', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(197, NULL, NULL, 'topics, tags, taxonomy', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(199, NULL, NULL, NULL, '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 1, 0, 0, 0),
(200, NULL, NULL, 'overrides, system info, debug, support, help', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(201, NULL, NULL, 'error, exception, debug', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(202, NULL, NULL, 'email, logging, logs, smtp, pop, errors, mysql, log', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(203, NULL, NULL, 'network, proxy server', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(204, NULL, NULL, 'database, entities, doctrine, orm', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(205, NULL, NULL, 'database, character set, charset, collation, utf8', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(206, NULL, NULL, 'geolocation, ip, address, country, nation, place, locate', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(207, NULL, NULL, 'security, content security policy, csp, strict transport security, hsts, x-frame-options', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(209, NULL, NULL, 'upgrade, new version, update', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(213, NULL, NULL, 'API, programming, public, app', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(214, NULL, NULL, NULL, '2.0000', 1, NULL, 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(217, NULL, NULL, NULL, '0.0000', 0, 'fas fa-palette', 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(218, NULL, NULL, NULL, '0.0000', 0, 'fas fa-th', 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(220, NULL, NULL, NULL, '0.0000', 0, 'fas fa-trash', 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(221, NULL, NULL, NULL, '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 1, 0, 0, 0),
(223, NULL, NULL, NULL, '0.0000', 0, 'fas fa-briefcase', 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(229, NULL, NULL, NULL, '0.0000', 0, 'fas fa-edit', 0, 0, NULL, NULL, 0, 0, 0, 0, 0),
(230, NULL, NULL, NULL, '1.0000', 1, NULL, 1, 0, NULL, NULL, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `CollectionVersionAreaStyles`
--

CREATE TABLE `CollectionVersionAreaStyles` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '0',
  `arHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `issID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`arHandle`),
  KEY `issID` (`issID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `CollectionVersionBlocks`
--

CREATE TABLE `CollectionVersionBlocks` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '1',
  `bID` int(10) unsigned NOT NULL DEFAULT '0',
  `arHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cbRelationID` int(10) unsigned DEFAULT '0',
  `cbDisplayOrder` int(10) unsigned NOT NULL DEFAULT '0',
  `isOriginal` tinyint(1) NOT NULL DEFAULT '0',
  `cbOverrideAreaPermissions` tinyint(1) NOT NULL DEFAULT '0',
  `cbIncludeAll` tinyint(1) NOT NULL DEFAULT '0',
  `cbOverrideBlockTypeCacheSettings` tinyint(1) NOT NULL DEFAULT '0',
  `cbOverrideBlockTypeContainerSettings` tinyint(1) NOT NULL DEFAULT '0',
  `cbEnableBlockContainer` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`bID`,`arHandle`),
  KEY `bID` (`bID`,`cID`),
  KEY `cbRelationID` (`cbRelationID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `CollectionVersionBlocks`
--

INSERT INTO `CollectionVersionBlocks` VALUES
(214, 1, 1, 'Main', 1, 0, 1, 0, 0, 0, 0, 0),
(214, 1, 2, 'Main', 2, 1, 1, 0, 0, 0, 0, 0),
(214, 1, 3, 'Main : 1', 3, 0, 1, 0, 0, 0, 0, 0),
(214, 1, 4, 'Main : 2', 4, 0, 1, 0, 0, 0, 0, 0),
(214, 1, 5, 'Main : 3', 5, 0, 1, 0, 0, 0, 0, 0),
(214, 1, 6, 'Main', 6, 2, 1, 0, 0, 0, 0, 0),
(214, 1, 7, 'Main : 4', 7, 0, 1, 0, 0, 1, 0, 0),
(214, 1, 8, 'Main : 5', 8, 0, 1, 0, 0, 1, 0, 0),
(214, 1, 9, 'Main', 9, 3, 1, 0, 0, 0, 0, 0),
(214, 1, 10, 'Main : 6', 10, 0, 1, 0, 0, 1, 0, 0),
(214, 1, 11, 'Main : 7', 11, 0, 1, 0, 0, 1, 0, 0),
(214, 1, 12, 'Main : 8', 12, 0, 1, 0, 0, 1, 0, 0),
(216, 1, 13, 'Main', 13, 0, 1, 0, 0, 0, 0, 0),
(216, 1, 14, 'Main : 9', 14, 0, 1, 0, 0, 0, 0, 0),
(216, 1, 15, 'Main', 15, 1, 1, 0, 0, 0, 0, 0),
(216, 1, 16, 'Main : 10', 16, 0, 1, 0, 0, 0, 0, 0),
(230, 1, 17, 'Main', 17, 0, 1, 0, 0, 0, 0, 0),
(230, 1, 18, 'Main : 11', 18, 0, 1, 0, 0, 0, 0, 0),
(230, 1, 19, 'Main', 19, 1, 1, 0, 0, 0, 0, 0),
(230, 1, 20, 'Main : 12', 20, 0, 1, 0, 0, 0, 0, 0),
(231, 1, 21, 'Main', 21, 0, 1, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `CollectionVersionBlocksCacheSettings`
--

CREATE TABLE `CollectionVersionBlocksCacheSettings` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '1',
  `bID` int(10) unsigned NOT NULL DEFAULT '0',
  `arHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `btCacheBlockOutput` tinyint(1) NOT NULL DEFAULT '0',
  `btCacheBlockOutputOnPost` tinyint(1) NOT NULL DEFAULT '0',
  `btCacheBlockOutputForRegisteredUsers` tinyint(1) NOT NULL DEFAULT '0',
  `btCacheBlockOutputLifetime` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`bID`,`arHandle`),
  KEY `bID` (`bID`,`cID`,`cvID`,`arHandle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `CollectionVersionBlocksCacheSettings`
--

INSERT INTO `CollectionVersionBlocksCacheSettings` VALUES
(214, 1, 7, 'Main : 4', 1, 1, 1, 0),
(214, 1, 8, 'Main : 5', 1, 1, 1, 0),
(214, 1, 10, 'Main : 6', 1, 1, 1, 0),
(214, 1, 11, 'Main : 7', 1, 1, 1, 0),
(214, 1, 12, 'Main : 8', 1, 1, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `CollectionVersionBlocksOutputCache`
--

CREATE TABLE `CollectionVersionBlocksOutputCache` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '1',
  `bID` int(10) unsigned NOT NULL DEFAULT '0',
  `arHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `btCachedBlockOutput` longtext COLLATE utf8mb4_unicode_ci,
  `btCachedBlockOutputExpires` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`bID`,`arHandle`),
  KEY `bID` (`bID`,`cID`,`cvID`,`arHandle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `CollectionVersionBlockStyles`
--

CREATE TABLE `CollectionVersionBlockStyles` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '0',
  `bID` int(10) unsigned NOT NULL DEFAULT '0',
  `arHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `issID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`bID`,`arHandle`),
  KEY `bID` (`bID`,`issID`),
  KEY `issID` (`issID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `CollectionVersionBlockStyles`
--

INSERT INTO `CollectionVersionBlockStyles` VALUES
(214, 1, 8, 'Main : 5', 1);

-- --------------------------------------------------------

--
-- Table structure for table `CollectionVersionRelatedEdits`
--

CREATE TABLE `CollectionVersionRelatedEdits` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '0',
  `cRelationID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvRelationID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`cRelationID`,`cvRelationID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `CollectionVersions`
--

CREATE TABLE `CollectionVersions` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '1',
  `cvName` text COLLATE utf8mb4_unicode_ci,
  `cvHandle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cvDescription` text COLLATE utf8mb4_unicode_ci,
  `cvDatePublic` datetime DEFAULT NULL,
  `cvDateCreated` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `cvComments` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cvIsApproved` tinyint(1) NOT NULL DEFAULT '0',
  `cvIsNew` tinyint(1) NOT NULL DEFAULT '0',
  `cvAuthorUID` int(10) unsigned DEFAULT NULL,
  `cvApproverUID` int(10) unsigned DEFAULT NULL,
  `pThemeID` int(10) unsigned NOT NULL DEFAULT '0',
  `pTemplateID` int(10) unsigned NOT NULL DEFAULT '0',
  `pThemeSkinIdentifier` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cvActivateDatetime` datetime DEFAULT NULL,
  `cvPublishDate` datetime DEFAULT NULL,
  `cvPublishEndDate` datetime DEFAULT NULL,
  `cvDateApproved` datetime DEFAULT NULL,
  PRIMARY KEY (`cID`,`cvID`),
  KEY `cvIsApproved` (`cvIsApproved`),
  KEY `cvAuthorUID` (`cvAuthorUID`),
  KEY `cvApproverUID` (`cvApproverUID`),
  KEY `pThemeID` (`pThemeID`),
  KEY `pTemplateID` (`pTemplateID`),
  KEY `cvDatePublic` (`cvDatePublic`),
  KEY `idxPublishDate` (`cID`,`cvID`,`cvIsApproved`,`cvPublishDate`,`cvPublishEndDate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `CollectionVersions`
--

INSERT INTO `CollectionVersions` VALUES
(1, 1, 'Home', NULL, '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 4, NULL, NULL, NULL, NULL, NULL),
(2, 1, 'Dashboard', 'dashboard', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(3, 1, 'Sitemap', 'sitemap', 'Whole world at a glance.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(4, 1, 'Full Sitemap', 'full', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(5, 1, 'Flat View', 'explore', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(6, 1, 'Page Search', 'search', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(7, 1, 'Files', 'files', 'All documents and images.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(8, 1, 'File Manager', 'search', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(9, 1, 'File Details', 'details', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(10, 1, 'Attributes', 'attributes', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(11, 1, 'File Sets', 'sets', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(12, 1, 'Add File Set', 'add_set', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(13, 1, 'Members', 'users', 'Add and manage the user accounts and groups on your website.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(14, 1, 'Search Users', 'search', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(15, 1, 'User Groups', 'groups', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(16, 1, 'Group Types', 'group_types', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(17, 1, 'Send Message to Group', 'message', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(18, 1, 'Attributes', 'attributes', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(19, 1, 'Add User', 'add', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(20, 1, 'Add Group', 'add_group', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(21, 1, 'Move Multiple Groups', 'bulkupdate', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(22, 1, 'Bulk User Assignment', 'bulk_user_assignment', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(23, 1, 'Group Sets', 'group_sets', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(24, 1, 'Express', 'express', 'Express Data Objects', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(25, 1, 'View Entries', 'entries', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(26, 1, 'Boards', 'boards', 'Express Data Objects', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(27, 1, 'View Boards', 'boards', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(28, 1, 'Add Board', 'add', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(29, 1, 'Board Details', 'details', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(30, 1, 'Edit Board', 'edit', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(31, 1, 'Data Sources', 'data_sources', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(32, 1, 'Board Appearance', 'appearance', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(33, 1, 'Weighting', 'weighting', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(34, 1, 'Board Permissions', 'permissions', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(35, 1, 'Instances', 'instances', 'View instances of your board.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(36, 1, 'Instance Details', 'details', 'View details of your board instance.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(37, 1, 'Rules', 'rules', 'View override rules for your instance.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(38, 1, 'Designer', 'designer', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(39, 1, 'Choose Items', 'choose_items', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(40, 1, 'Customize Slot', 'customize_slot', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(41, 1, 'Scheduler', 'scheduler', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(42, 1, 'Reports', 'reports', 'Get data from forms and logs.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(43, 1, 'Form Results', 'forms', 'Get submission data.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(44, 1, 'Form Results', 'legacy', 'Get submission data.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(45, 1, 'Site Health', 'health', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(46, 1, 'Report Details', 'details', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(47, 1, 'Surveys', 'surveys', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(48, 1, 'Logs', 'logs', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(49, 1, 'Page Changes', 'page_changes', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(50, 1, 'Pages & Themes', 'pages', 'Reskin your site.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(51, 1, 'Themes', 'themes', 'Reskin your site.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(52, 1, 'Inspect', 'inspect', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(53, 1, 'Page Types', 'types', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(54, 1, 'Organize Page Type Order', 'organize', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(55, 1, 'Add Page Type', 'add', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(56, 1, 'Compose Form', 'form', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(57, 1, 'Defaults and Output', 'output', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(58, 1, 'Page Type Attributes', 'attributes', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(59, 1, 'Page Type Permissions', 'permissions', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(60, 1, 'Page Templates', 'templates', 'Form factors for pages in your site.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(61, 1, 'Add Page Template', 'add', 'Add page templates to your site.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(62, 1, 'Containers', 'containers', 'Container Templates for Areas.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(63, 1, 'Add Container', 'add', 'Add page containers.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(64, 1, 'Attributes', 'attributes', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(65, 1, 'Single Pages', 'single', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(66, 1, 'RSS Feeds', 'feeds', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(67, 1, 'Calendar & Events', 'calendar', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(68, 1, 'View Calendar', 'events', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(69, 1, 'Event List', 'event_list', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(70, 1, 'Add Calendar', 'add', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(71, 1, 'Calendar Permissions', 'permissions', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(72, 1, 'Attributes', 'attributes', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(73, 1, 'Conversations', 'conversations', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(74, 1, 'Messages', 'messages', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(75, 1, 'Stacks & Blocks', 'blocks', 'Manage sitewide content and administer block types.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(76, 1, 'Stacks & Global Areas', 'stacks', 'Share content across your site.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(77, 1, 'Block & Stack Permissions', 'permissions', 'Control who can add blocks and stacks on your site.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(78, 1, 'Stack List', 'list', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(79, 1, 'Block Types', 'types', 'Manage the installed block types in your site.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(80, 1, 'Extend Concrete', 'extend', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(81, 1, 'Add Functionality', 'install', 'Install add-ons & themes.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(82, 1, 'Update Add-Ons', 'update', 'Update your installed packages.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(83, 1, 'Get More Themes', 'themes', 'Download themes from the marketplace.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(84, 1, 'Get More Add-Ons', 'addons', 'Download add-ons from the marketplace.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(85, 1, 'System & Settings', 'system', 'Secure and setup your site.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(86, 1, 'Basics', 'basics', 'Basic information about your website.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(87, 1, 'Name & Attributes', 'name', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(88, 1, 'Marketplace', 'marketplace', 'Connect to the Concrete CMS marketplace.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(89, 1, 'Production Mode', 'production_mode', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(90, 1, 'Appearance', 'appearance', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(91, 1, 'Site Information', 'site_information', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(92, 1, 'Bookmark Icons', 'icons', 'Bookmark icon and mobile home screen icon setup.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(93, 1, 'Rich Text Editor', 'editor', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(94, 1, 'Languages', 'multilingual', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(95, 1, 'Update Languages', 'update', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(96, 1, 'Time Zone', 'timezone', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(97, 1, 'Custom Attributes', 'attributes', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(98, 1, 'Reset Clipboard and Edit Mode', 'reset_edit_mode', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(99, 1, 'Social & Sharing', 'social', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(100, 1, 'Social Links', 'social_links', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(101, 1, 'Open Graph', 'opengraph', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(102, 1, 'Express', 'express', 'Express', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(103, 1, 'Data Objects', 'entities', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(104, 1, 'Attributes', 'attributes', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(105, 1, 'Associations', 'associations', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(106, 1, 'Forms', 'forms', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(107, 1, 'Customize Search', 'customize_search', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(108, 1, 'Update Entry Display Order', 'order_entries', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(109, 1, 'Custom Entry Locations', 'entries', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(110, 1, 'Multiple Site Hosting', 'multisite', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(111, 1, 'Sites & Domains', 'sites', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(112, 1, 'Site Types', 'types', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(113, 1, 'Multisite Settings', 'settings', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(114, 1, 'Multilingual', 'multilingual', 'Run your site in multiple languages.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(115, 1, 'Multilingual Setup', 'setup', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(116, 1, 'Copy Languages', 'copy', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(117, 1, 'Page Report', 'page_report', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(118, 1, 'Translate Site Interface', 'translate_interface', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(119, 1, 'SEO & Statistics', 'seo', 'Enable pretty URLs and tracking codes.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(120, 1, 'URLs and Redirection', 'urls', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(121, 1, 'Bulk SEO Updater', 'bulk', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(122, 1, 'Tracking Codes', 'codes', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(123, 1, 'Excluded URL Word List', 'excluded', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(124, 1, 'Search Index', 'searchindex', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(125, 1, 'URL Slug', 'url_slug', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(126, 1, 'Files', 'files', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(127, 1, 'Allowed File Types', 'filetypes', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(128, 1, 'File Chooser Options', 'file_chooser', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(129, 1, 'File Manager Permissions', 'permissions', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(130, 1, 'Thumbnails', 'thumbnails', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(131, 1, 'Thumbnail Options', 'options', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(132, 1, 'Image Options', 'image_uploading', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(133, 1, 'Image Editor', 'image_editor', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(134, 1, 'File Storage Locations', 'storage', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(135, 1, 'External File Providers', 'external_file_provider', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(136, 1, 'Export Options', 'export_options', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(137, 1, 'Upload Settings', 'uploads', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(138, 1, 'Automation', 'automation', 'Run and automate commands.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(139, 1, 'Tasks', 'tasks', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(140, 1, 'Activity', 'activity', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(141, 1, 'Failed Messages', 'failed', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(142, 1, 'Schedule', 'schedule', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(143, 1, 'Automation Settings', 'settings', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(144, 1, 'Notification', 'notification', 'Notification settings.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(145, 1, 'Server-Sent Events', 'events', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(146, 1, 'Waiting for Me', 'alerts', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(147, 1, 'Optimization', 'optimization', 'Keep your site running well.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(148, 1, 'Cache & Speed Settings', 'cache', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(149, 1, 'Clear Cache', 'clearcache', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(150, 1, 'Automated Jobs', 'jobs', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(151, 1, 'Permissions & Access', 'permissions', 'Control who sees and edits your site.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(152, 1, 'Site Access', 'site', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(153, 1, 'Task Permissions', 'tasks', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(154, 1, 'User Permissions', 'users', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(155, 1, 'Advanced Permissions', 'advanced', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(156, 1, 'Workflows', 'workflows', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(157, 1, 'IP Deny List', 'denylist', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(158, 1, 'Configure IP Blocking', 'configure', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(159, 1, 'IP Range', 'range', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(160, 1, 'Captcha Setup', 'captcha', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(161, 1, 'Spam Control', 'antispam', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(162, 1, 'Maintenance Mode', 'maintenance', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(163, 1, 'Trusted Proxies', 'trusted_proxies', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(164, 1, 'Login & Registration', 'registration', 'Change login behaviors and setup public profiles.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(165, 1, 'Account Options', 'open', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(166, 1, 'Login Destination', 'postlogin', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(167, 1, 'Public Profiles', 'profiles', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(168, 1, 'Authentication Types', 'authentication', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(169, 1, 'Global Password Reset', 'global_password_reset', 'Signs out all users, resets all passwords and forces users to choose a new one', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(170, 1, 'User Deactivation Settings', 'deactivation', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(171, 1, 'Automated Logout', 'automated_logout', 'Automate when users are logged out, or do it manually', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(172, 1, 'Password Requirements', 'password_requirements', 'Set password rule and regulations.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(173, 1, 'Session Options', 'session_options', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(174, 1, 'Email', 'mail', 'Control how your site send and processes mail.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(175, 1, 'SMTP Method', 'method', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(176, 1, 'Test Mail Settings', 'test', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(177, 1, 'Email Importers', 'importers', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(178, 1, 'System Email Addresses', 'addresses', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(179, 1, 'Email Logging', 'logging', 'Control how emails get logged.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(180, 1, 'Calendar', 'calendar', 'Manage your calendar settings', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(181, 1, 'General Settings', 'settings', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(182, 1, 'Color Settings', 'colors', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(183, 1, 'Calendar Permissions', 'permissions', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(184, 1, 'Import Calendar Data', 'import', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(185, 1, 'Boards & Summary', 'boards', 'Manage global board settings', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(186, 1, 'Board Settings', 'settings', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(187, 1, 'Permissions', 'permissions', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(188, 1, 'Summary Templates', 'summary_templates', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(189, 1, 'Conversations', 'conversations', 'Manage your conversations settings', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(190, 1, 'Settings', 'settings', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(191, 1, 'Community Points', 'points', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(192, 1, 'Banned Words', 'bannedwords', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(193, 1, 'Conversation Permissions', 'permissions', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(194, 1, 'Attributes', 'attributes', 'Setup attributes for pages, users, files and more.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(195, 1, 'Types', 'types', 'Choose which attribute types are available for different items.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(196, 1, 'Sets', 'sets', 'Group attributes into sets for easier organization', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(197, 1, 'Topics', 'topics', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(198, 1, 'Add Topic Tree', 'add', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(199, 1, 'Environment', 'environment', 'Advanced settings for web developers.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(200, 1, 'Environment Information', 'info', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(201, 1, 'Error Handling', 'errors', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(202, 1, 'Logging Settings', 'logging', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(203, 1, 'Proxy Server', 'proxy', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(204, 1, 'Database Entities', 'entities', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(205, 1, 'Database Character Set', 'database_charset', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(206, 1, 'Geolocation', 'geolocation', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(207, 1, 'Security Policy', 'security', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(208, 1, 'Update Concrete', 'update', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(209, 1, 'Apply Update', 'update', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(210, 1, 'API', 'api', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(211, 1, 'API Integrations', 'integrations', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(212, 1, 'Scopes', 'scopes', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(213, 1, 'API Settings', 'settings', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(214, 1, 'Welcome', 'welcome', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(215, 1, 'Site Health', 'health', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(216, 1, 'Waiting for Me', 'me', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 3, NULL, NULL, NULL, NULL, NULL),
(217, 1, 'Theme Documentation', '!themes', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(218, 1, 'Stacks', '!stacks', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(219, 1, 'Page Not Found', 'page_not_found', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(220, 1, 'Trash', '!trash', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(221, 1, 'Login', 'login', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(222, 1, 'Register', 'register', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(223, 1, 'My Account', 'account', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(224, 1, 'Edit Profile', 'edit_profile', 'Edit your user profile and change password.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(225, 1, 'Profile Picture', 'avatar', 'Specify a new image attached to posts or edits.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(226, 1, 'Private Messages', 'messages', 'Inbox for site-specific messages.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(227, 1, 'Page Forbidden', 'page_forbidden', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(228, 1, 'Download File', 'download_file', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(229, 1, 'Drafts', '!drafts', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(230, 1, 'Welcome Back', 'desktop', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(231, 1, '', NULL, NULL, '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, NULL, NULL, 0, 4, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `CollectionVersionThemeCustomStyles`
--

CREATE TABLE `CollectionVersionThemeCustomStyles` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '1',
  `pThemeID` int(10) unsigned NOT NULL DEFAULT '0',
  `scvlID` int(10) unsigned DEFAULT '0',
  `preset` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sccRecordID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`pThemeID`),
  KEY `pThemeID` (`pThemeID`),
  KEY `scvlID` (`scvlID`),
  KEY `sccRecordID` (`sccRecordID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `Config`
--

CREATE TABLE `Config` (
  `configNamespace` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `configGroup` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `configItem` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `configValue` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`configNamespace`,`configGroup`,`configItem`),
  KEY `configGroup` (`configGroup`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `Config`
--

INSERT INTO `Config` VALUES
('', 'app', 'privacy_policy_accepted', '1'),
('', 'concrete', 'marketplace.key.private', ''),
('', 'concrete', 'marketplace.key.public', ''),
('', 'concrete', 'security.token.encryption', '[[SECURITY_TOKEN_ENCRYPTION]]'),
('', 'concrete', 'security.token.jobs', '[[SECURITY_TOKEN_JOBS]]'),
('', 'concrete', 'security.token.validation', '[[SECURITY_TOKEN_VALIDATION]]');

-- --------------------------------------------------------

--
-- Table structure for table `ConfigStore`
--

CREATE TABLE `ConfigStore` (
  `cfKey` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `cfValue` longtext COLLATE utf8mb4_unicode_ci,
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cfKey`,`uID`),
  KEY `uID` (`uID`,`cfKey`),
  KEY `pkgID` (`pkgID`,`cfKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ConversationEditors`
--

CREATE TABLE `ConversationEditors` (
  `cnvEditorID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cnvEditorHandle` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cnvEditorName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cnvEditorIsActive` tinyint(1) NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cnvEditorID`),
  KEY `pkgID` (`pkgID`,`cnvEditorHandle`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `ConversationEditors`
--

INSERT INTO `ConversationEditors` VALUES
(1, 'plain_text', 'Plain Text', 1, 0),
(2, 'markdown', 'Markdown', 0, 0),
(3, 'rich_text', 'Rich Text', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `ConversationFlaggedMessages`
--

CREATE TABLE `ConversationFlaggedMessages` (
  `cnvMessageID` int(10) unsigned NOT NULL,
  `cnvMessageFlagTypeID` int(11) DEFAULT NULL,
  PRIMARY KEY (`cnvMessageID`),
  KEY `cnvMessageFlagTypeID` (`cnvMessageFlagTypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ConversationFlaggedMessageTypes`
--

CREATE TABLE `ConversationFlaggedMessageTypes` (
  `cnvMessageFlagTypeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cnvMessageFlagTypeHandle` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`cnvMessageFlagTypeID`),
  UNIQUE KEY `cnvMessageFlagTypeHandle` (`cnvMessageFlagTypeHandle`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `ConversationFlaggedMessageTypes`
--

INSERT INTO `ConversationFlaggedMessageTypes` VALUES
(1, 'spam');

-- --------------------------------------------------------

--
-- Table structure for table `ConversationMessageAttachments`
--

CREATE TABLE `ConversationMessageAttachments` (
  `cnvMessageAttachmentID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cnvMessageID` int(11) DEFAULT NULL,
  `fID` int(11) DEFAULT NULL,
  PRIMARY KEY (`cnvMessageAttachmentID`),
  KEY `cnvMessageID` (`cnvMessageID`),
  KEY `fID` (`fID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ConversationMessageNotifications`
--

CREATE TABLE `ConversationMessageNotifications` (
  `cnvMessageID` int(10) unsigned NOT NULL,
  `nID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`nID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ConversationMessageRatings`
--

CREATE TABLE `ConversationMessageRatings` (
  `cnvMessageRatingID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cnvMessageID` int(10) unsigned DEFAULT NULL,
  `cnvRatingTypeID` int(10) unsigned NOT NULL DEFAULT '0',
  `cnvMessageRatingIP` tinyblob,
  `timestamp` datetime DEFAULT NULL,
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cnvMessageRatingID`),
  KEY `cnvMessageID` (`cnvMessageID`,`cnvRatingTypeID`),
  KEY `cnvRatingTypeID` (`cnvRatingTypeID`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ConversationMessages`
--

CREATE TABLE `ConversationMessages` (
  `cnvMessageID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cnvID` int(10) unsigned NOT NULL DEFAULT '0',
  `cnvMessageReview` int(10) unsigned NOT NULL DEFAULT '0',
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  `cnvEditorID` int(10) unsigned NOT NULL DEFAULT '0',
  `cnvMessageAuthorName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cnvMessageAuthorEmail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cnvMessageAuthorWebsite` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cnvMessageSubmitIP` tinyblob,
  `cnvMessageSubmitUserAgent` longtext COLLATE utf8mb4_unicode_ci,
  `cnvMessageLevel` int(10) unsigned NOT NULL DEFAULT '0',
  `cnvMessageParentID` int(10) unsigned NOT NULL DEFAULT '0',
  `cnvMessageDateCreated` datetime DEFAULT NULL,
  `cnvMessageSubject` text COLLATE utf8mb4_unicode_ci,
  `cnvMessageBody` text COLLATE utf8mb4_unicode_ci,
  `cnvIsMessageDeleted` tinyint(1) NOT NULL DEFAULT '0',
  `cnvIsMessageApproved` tinyint(1) NOT NULL DEFAULT '0',
  `cnvMessageTotalRatingScore` bigint(20) DEFAULT '0',
  PRIMARY KEY (`cnvMessageID`),
  KEY `cnvID` (`cnvID`),
  KEY `cnvMessageParentID` (`cnvMessageParentID`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ConversationPermissionAddMessageAccessList`
--

CREATE TABLE `ConversationPermissionAddMessageAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'A',
  PRIMARY KEY (`paID`,`peID`),
  KEY `peID` (`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ConversationPermissionAssignments`
--

CREATE TABLE `ConversationPermissionAssignments` (
  `cnvID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cnvID`,`pkID`,`paID`),
  KEY `paID` (`paID`),
  KEY `pkID` (`pkID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `ConversationPermissionAssignments`
--

INSERT INTO `ConversationPermissionAssignments` VALUES
(0, 67, 126),
(0, 68, 127),
(0, 71, 128),
(0, 70, 129),
(0, 72, 130),
(0, 69, 131),
(0, 73, 132),
(0, 74, 133);

-- --------------------------------------------------------

--
-- Table structure for table `ConversationRatingTypes`
--

CREATE TABLE `ConversationRatingTypes` (
  `cnvRatingTypeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cnvRatingTypeHandle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cnvRatingTypeName` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cnvRatingTypeCommunityPoints` int(11) DEFAULT NULL,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cnvRatingTypeID`),
  UNIQUE KEY `cnvRatingTypeHandle` (`cnvRatingTypeHandle`),
  KEY `pkgID` (`pkgID`,`cnvRatingTypeHandle`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `ConversationRatingTypes`
--

INSERT INTO `ConversationRatingTypes` VALUES
(1, 'up_vote', 'Up Vote', 1, 0),
(2, 'down_vote', 'Down Vote', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `Conversations`
--

CREATE TABLE `Conversations` (
  `cnvID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cID` int(10) unsigned DEFAULT '0',
  `cnvDateCreated` datetime NOT NULL,
  `cnvDateLastMessage` datetime DEFAULT NULL,
  `cnvParentMessageID` int(10) unsigned DEFAULT '0',
  `cnvAttachmentsEnabled` tinyint(1) NOT NULL DEFAULT '1',
  `cnvMessagesTotal` int(10) unsigned DEFAULT '0',
  `cnvOverrideGlobalPermissions` tinyint(1) DEFAULT '0',
  `cnvAttachmentOverridesEnabled` tinyint(1) NOT NULL DEFAULT '0',
  `cnvMaxFilesGuest` int(11) DEFAULT '0',
  `cnvMaxFilesRegistered` int(11) DEFAULT '0',
  `cnvMaxFileSizeGuest` int(11) DEFAULT '0',
  `cnvMaxFileSizeRegistered` int(11) DEFAULT '0',
  `cnvFileExtensions` text COLLATE utf8mb4_unicode_ci,
  `cnvNotificationOverridesEnabled` tinyint(1) NOT NULL DEFAULT '0',
  `cnvEnableSubscription` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`cnvID`),
  KEY `cID` (`cID`),
  KEY `cnvParentMessageID` (`cnvParentMessageID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ConversationSubscriptions`
--

CREATE TABLE `ConversationSubscriptions` (
  `cnvID` int(10) unsigned NOT NULL DEFAULT '0',
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  `type` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'S',
  PRIMARY KEY (`cnvID`,`uID`),
  KEY `cnvID` (`cnvID`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `ConversationSubscriptions`
--

INSERT INTO `ConversationSubscriptions` VALUES
(0, 1, 'S');

-- --------------------------------------------------------

--
-- Table structure for table `DesignTags`
--

CREATE TABLE `DesignTags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `DownloadStatistics`
--

CREATE TABLE `DownloadStatistics` (
  `dsID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'DownloadStatistics record ID',
  `fvID` int(11) NOT NULL COMMENT 'Version of the downloaded file',
  `uID` int(10) unsigned DEFAULT NULL COMMENT 'ID of the user that downloaded the file',
  `rcID` int(10) unsigned DEFAULT NULL COMMENT 'ID of the page where the download originated',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `fID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`dsID`),
  KEY `IDX_7CDE2E3CE3111F45` (`fID`),
  KEY `fID` (`fID`,`timestamp`),
  KEY `fvID` (`fID`,`fvID`),
  KEY `uID` (`uID`),
  KEY `rcID` (`rcID`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='List of downloaded files' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `Editor`
--

CREATE TABLE `Editor` (
  `handle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`handle`),
  KEY `IDX_CB5DF48CCE45CBB0` (`pkgID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressAttributeKeys`
--

CREATE TABLE `ExpressAttributeKeys` (
  `entity_id` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `eakUnique` tinyint(1) NOT NULL COMMENT 'Enables SKU-type attributes',
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`),
  KEY `IDX_8C881F181257D5D` (`entity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressEntities`
--

CREATE TABLE `ExpressEntities` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `default_view_form_id` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `default_edit_form_id` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `plural_handle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `label_mask` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `supports_custom_display_order` tinyint(1) NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `result_column_set` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:object)',
  `include_in_public_list` tinyint(1) NOT NULL,
  `is_published` tinyint(1) NOT NULL,
  `include_in_rest_api` tinyint(1) NOT NULL,
  `entity_results_node_id` int(11) NOT NULL,
  `use_separate_site_result_buckets` tinyint(1) NOT NULL,
  `items_per_page` int(11) NOT NULL,
  `created_date` datetime NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_BC772AA6918020D9` (`handle`),
  UNIQUE KEY `UNIQ_BC772AA6547D6B2D` (`default_view_form_id`),
  UNIQUE KEY `UNIQ_BC772AA6C7DEC56D` (`default_edit_form_id`),
  KEY `IDX_BC772AA6CE45CBB0` (`pkgID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressEntityAssociationEntries`
--

CREATE TABLE `ExpressEntityAssociationEntries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `association_id` int(11) DEFAULT NULL,
  `displayOrder` int(10) unsigned NOT NULL DEFAULT '0',
  `exEntryID` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_9C2BB76C6DCB6296` (`exEntryID`),
  KEY `IDX_9C2BB76CEFB9C8A5` (`association_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressEntityAssociations`
--

CREATE TABLE `ExpressEntityAssociations` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `source_entity_id` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `target_entity_id` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `is_owned_by_association` tinyint(1) NOT NULL,
  `is_owning_association` tinyint(1) NOT NULL,
  `target_property_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `inversed_by_property_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `association_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_98A0F796E9BBEE93` (`source_entity_id`),
  KEY `IDX_98A0F796B5910F71` (`target_entity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressEntityEntries`
--

CREATE TABLE `ExpressEntityEntries` (
  `exEntryID` int(11) NOT NULL AUTO_INCREMENT,
  `exEntryDisplayOrder` int(11) NOT NULL,
  `exEntryDateCreated` datetime NOT NULL,
  `exEntryDateModified` datetime DEFAULT NULL,
  `publicIdentifier` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `resultsNodeID` int(11) DEFAULT NULL,
  `uID` int(10) unsigned DEFAULT NULL,
  `exEntryEntityID` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`exEntryID`),
  KEY `IDX_B8AE3531FD71026C` (`uID`),
  KEY `IDX_B8AE3531AFC87D03` (`exEntryEntityID`),
  KEY `resultsNodeID` (`resultsNodeID`),
  KEY `createdSort` (`exEntryDateCreated`),
  KEY `modifiedSort` (`exEntryDateModified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressEntityEntryAssociations`
--

CREATE TABLE `ExpressEntityEntryAssociations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `association_id` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `exEntryID` int(11) DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_25B3A0826DCB6296` (`exEntryID`),
  KEY `IDX_25B3A082EFB9C8A5` (`association_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressEntityEntryAttributeValues`
--

CREATE TABLE `ExpressEntityEntryAttributeValues` (
  `exEntryID` int(11) NOT NULL,
  `akID` int(10) unsigned NOT NULL,
  `avID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`exEntryID`,`akID`),
  KEY `IDX_6DB641546DCB6296` (`exEntryID`),
  KEY `IDX_6DB64154B6561A7E` (`akID`),
  KEY `IDX_6DB64154A2A82A5D` (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressFormFieldSetAssociationControls`
--

CREATE TABLE `ExpressFormFieldSetAssociationControls` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `association_id` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `association_entity_label_mask` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entry_selector_mode` int(10) unsigned NOT NULL DEFAULT '0',
  `enable_entry_reordering` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_E6DF21BBEFB9C8A5` (`association_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressFormFieldSetAttributeKeyControls`
--

CREATE TABLE `ExpressFormFieldSetAttributeKeyControls` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `akID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_8481F9D1B6561A7E` (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressFormFieldSetAuthorControls`
--

CREATE TABLE `ExpressFormFieldSetAuthorControls` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressFormFieldSetControls`
--

CREATE TABLE `ExpressFormFieldSetControls` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `field_set_id` int(11) DEFAULT NULL,
  `is_required` tinyint(1) NOT NULL,
  `position` int(11) NOT NULL,
  `custom_label` longtext COLLATE utf8mb4_unicode_ci,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_E42868A43ABF811A` (`field_set_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressFormFieldSetPublicIdentifierControls`
--

CREATE TABLE `ExpressFormFieldSetPublicIdentifierControls` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressFormFieldSets`
--

CREATE TABLE `ExpressFormFieldSets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `position` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `IDX_A33BBBEC5FF69B7D` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressFormFieldSetTextControls`
--

CREATE TABLE `ExpressFormFieldSetTextControls` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `headline` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `body` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressForms`
--

CREATE TABLE `ExpressForms` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `entity_id` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_8D09031A81257D5D` (`entity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `FileAttributeKeys`
--

CREATE TABLE `FileAttributeKeys` (
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `FileAttributeKeys`
--

INSERT INTO `FileAttributeKeys` VALUES
(17),
(18),
(20);

-- --------------------------------------------------------

--
-- Table structure for table `FileAttributeValues`
--

CREATE TABLE `FileAttributeValues` (
  `fID` int(10) unsigned NOT NULL,
  `fvID` int(10) unsigned NOT NULL,
  `akID` int(10) unsigned NOT NULL,
  `avID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`fID`,`fvID`,`akID`),
  KEY `IDX_BBECEAA4B6561A7E` (`akID`),
  KEY `IDX_BBECEAA4A2A82A5D` (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `FileExternalFileProviders`
--

CREATE TABLE `FileExternalFileProviders` (
  `efpName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `efpConfiguration` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `efpID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`efpID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `FileExternalFileProviderTypes`
--

CREATE TABLE `FileExternalFileProviderTypes` (
  `efpTypeHandle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `efpTypeName` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `efpTypeID` int(11) NOT NULL AUTO_INCREMENT,
  `pkgID` int(11) NOT NULL,
  PRIMARY KEY (`efpTypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `FileImageThumbnailPaths`
--

CREATE TABLE `FileImageThumbnailPaths` (
  `fileID` int(10) unsigned NOT NULL,
  `fileVersionID` int(10) unsigned NOT NULL,
  `thumbnailTypeHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `storageLocationID` int(10) unsigned NOT NULL,
  `thumbnailFormat` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `isBuilt` tinyint(1) NOT NULL,
  `lockID` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lockExpires` datetime DEFAULT NULL,
  PRIMARY KEY (`fileID`,`fileVersionID`,`thumbnailTypeHandle`,`storageLocationID`,`thumbnailFormat`),
  KEY `thumbnailPathIsBuilt` (`isBuilt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `FileImageThumbnailTypeFileSets`
--

CREATE TABLE `FileImageThumbnailTypeFileSets` (
  `ftfsFileSetID` int(10) unsigned NOT NULL,
  `ftfsThumbnailType` int(11) NOT NULL,
  PRIMARY KEY (`ftfsThumbnailType`,`ftfsFileSetID`),
  KEY `IDX_BD75F88D480660E5` (`ftfsThumbnailType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `FileImageThumbnailTypes`
--

CREATE TABLE `FileImageThumbnailTypes` (
  `ftTypeID` int(11) NOT NULL AUTO_INCREMENT,
  `ftTypeHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ftTypeName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ftTypeWidth` int(11) DEFAULT NULL,
  `ftTypeHeight` int(11) DEFAULT NULL,
  `ftTypeIsRequired` tinyint(1) NOT NULL,
  `ftTypeSizingMode` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ftUpscalingEnabled` tinyint(1) NOT NULL,
  `ftLimitedToFileSets` tinyint(1) NOT NULL,
  `ftKeepAnimations` tinyint(1) NOT NULL,
  `ftSaveAreaBackgroundColor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`ftTypeID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `FileImageThumbnailTypes`
--

INSERT INTO `FileImageThumbnailTypes` VALUES
(1, 'file_manager_listing', 'File Manager Thumbnails', 120, 120, 1, 'exact', 1, 0, 0, ''),
(2, 'file_manager_detail', 'File Manager Detail Thumbnails', 500, 500, 1, 'exact', 0, 0, 0, ''),
(3, 'resource_list_entry', 'Resource List Entry', 510, 510, 0, 'proportional', 0, 0, 0, ''),
(4, 'testimonial_circle', 'Testimonial Circle', 180, 180, 0, 'exact', 0, 0, 0, ''),
(5, 'stripe_column', 'Stripe Column Image', 850, 650, 0, 'exact', 0, 0, 0, ''),
(6, 'atomik_gallery', 'Gallery', 860, 614, 0, 'exact', 0, 0, 0, ''),
(7, 'blog_entry_thumbnail', 'Blog Entry Thumbnail', 660, 428, 0, 'exact', 0, 0, 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `FilePermissionAssignments`
--

CREATE TABLE `FilePermissionAssignments` (
  `fID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`fID`,`pkID`,`paID`),
  KEY `pkID` (`pkID`),
  KEY `paID` (`paID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `FilePermissionFileTypeAccessList`
--

CREATE TABLE `FilePermissionFileTypeAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`),
  KEY `peID` (`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `FilePermissionFileTypeAccessListCustom`
--

CREATE TABLE `FilePermissionFileTypeAccessListCustom` (
  `extension` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`extension`),
  KEY `peID` (`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `FilePermissionFileTypes`
--

CREATE TABLE `FilePermissionFileTypes` (
  `extension` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fsID` int(10) unsigned NOT NULL DEFAULT '0',
  `gID` int(10) unsigned NOT NULL DEFAULT '0',
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`fsID`,`gID`,`uID`,`extension`),
  KEY `gID` (`gID`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `Files`
--

CREATE TABLE `Files` (
  `fID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fUUID` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fDateAdded` datetime NOT NULL,
  `fPassword` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fOverrideSetPermissions` tinyint(1) NOT NULL,
  `ocID` int(10) unsigned NOT NULL,
  `folderTreeNodeID` int(10) unsigned NOT NULL,
  `uID` int(10) unsigned DEFAULT NULL,
  `fslID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`fID`),
  UNIQUE KEY `UNIQ_C7F46F5D16FE17FE` (`fUUID`),
  KEY `uID` (`uID`),
  KEY `fslID` (`fslID`),
  KEY `ocID` (`ocID`),
  KEY `fOverrideSetPermissions` (`fOverrideSetPermissions`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `FileSearchIndexAttributes`
--

CREATE TABLE `FileSearchIndexAttributes` (
  `fID` int(10) unsigned NOT NULL,
  `ak_width` decimal(14,4) DEFAULT '0.0000',
  `ak_height` decimal(14,4) DEFAULT '0.0000',
  `ak_duration` decimal(14,4) DEFAULT '0.0000',
  PRIMARY KEY (`fID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `FileSetFiles`
--

CREATE TABLE `FileSetFiles` (
  `fsfID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fID` int(10) unsigned NOT NULL,
  `fsID` int(10) unsigned NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `fsDisplayOrder` int(10) unsigned NOT NULL,
  PRIMARY KEY (`fsfID`),
  KEY `fID` (`fID`),
  KEY `fsID` (`fsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `FileSets`
--

CREATE TABLE `FileSets` (
  `fsID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fsName` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  `fsType` smallint(6) NOT NULL,
  `fsOverrideGlobalPermissions` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`fsID`),
  KEY `uID` (`uID`,`fsType`,`fsName`),
  KEY `fsName` (`fsName`),
  KEY `fsType` (`fsType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `FileSetSavedSearches`
--

CREATE TABLE `FileSetSavedSearches` (
  `fsID` int(10) unsigned NOT NULL DEFAULT '0',
  `fsSearchRequest` text COLLATE utf8mb4_unicode_ci,
  `fsResultColumns` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`fsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `FileStorageLocations`
--

CREATE TABLE `FileStorageLocations` (
  `fslName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fslConfiguration` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `fslID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fslIsDefault` tinyint(1) NOT NULL,
  PRIMARY KEY (`fslID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `FileStorageLocations`
--

INSERT INTO `FileStorageLocations` VALUES
('Default', 'O:69:"Concrete\\Core\\File\\StorageLocation\\Configuration\\DefaultConfiguration":1:{s:10:"\0*\0default";b:1;}', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `FileStorageLocationTypes`
--

CREATE TABLE `FileStorageLocationTypes` (
  `fslTypeHandle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fslTypeName` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fslTypeID` int(11) NOT NULL AUTO_INCREMENT,
  `pkgID` int(11) NOT NULL,
  PRIMARY KEY (`fslTypeID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `FileStorageLocationTypes`
--

INSERT INTO `FileStorageLocationTypes` VALUES
('default', 'Default', 1, 0),
('local', 'Local', 2, 0);

-- --------------------------------------------------------

--
-- Table structure for table `FileUsageRecord`
--

CREATE TABLE `FileUsageRecord` (
  `file_id` int(11) NOT NULL,
  `block_id` int(11) NOT NULL,
  `collection_id` int(11) NOT NULL,
  `collection_version_id` int(11) NOT NULL,
  PRIMARY KEY (`file_id`,`block_id`,`collection_id`,`collection_version_id`),
  KEY `block` (`block_id`),
  KEY `collection_version` (`collection_id`,`collection_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `FileVersionLog`
--

CREATE TABLE `FileVersionLog` (
  `fvlID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fID` int(10) unsigned NOT NULL DEFAULT '0',
  `fvID` int(10) unsigned NOT NULL DEFAULT '0',
  `fvUpdateTypeID` smallint(5) unsigned NOT NULL DEFAULT '0',
  `fvUpdateTypeAttributeID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`fvlID`),
  KEY `fvID` (`fID`,`fvID`,`fvlID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `FileVersions`
--

CREATE TABLE `FileVersions` (
  `fvID` int(11) NOT NULL,
  `fvFilename` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fvPrefix` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fvDateAdded` datetime NOT NULL,
  `fvActivateDateTime` datetime NOT NULL,
  `fvIsApproved` tinyint(1) NOT NULL,
  `fvAuthorUID` int(11) NOT NULL,
  `fvApproverUID` int(11) NOT NULL,
  `fvSize` bigint(20) NOT NULL,
  `fvTitle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fvDescription` longtext COLLATE utf8mb4_unicode_ci,
  `fvExtension` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fvTags` longtext COLLATE utf8mb4_unicode_ci,
  `fvType` int(11) NOT NULL,
  `fvHasListingThumbnail` int(11) NOT NULL,
  `fvHasDetailThumbnail` int(11) NOT NULL,
  `fID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`fID`,`fvID`),
  KEY `IDX_D7B5A13AE3111F45` (`fID`),
  KEY `fvFilename` (`fvFilename`),
  KEY `fvExtension` (`fvExtension`),
  KEY `fvType` (`fvType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `FormSubmissionNotifications`
--

CREATE TABLE `FormSubmissionNotifications` (
  `exEntryID` int(11) DEFAULT NULL,
  `nID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`nID`),
  KEY `IDX_E7B6BE406DCB6296` (`exEntryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `Geolocators`
--

CREATE TABLE `Geolocators` (
  `glID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Geolocator ID',
  `glHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Geolocator handle',
  `glName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Geolocator name',
  `glDescription` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Geolocator description',
  `glConfiguration` json NOT NULL COMMENT 'Geolocator configuration options(DC2Type:json_array)',
  `glActive` tinyint(1) NOT NULL COMMENT 'Is this Geolocator the active one?',
  `glPackage` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`glID`),
  UNIQUE KEY `UNIQ_83BB1614D4F4D416` (`glHandle`),
  KEY `IDX_83BB1614D5F6CC40` (`glPackage`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='List of all the installed Geolocator services' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `Geolocators`
--

INSERT INTO `Geolocators` VALUES
(1, 'geoplugin', 'geoPlugin', '', '{"url": "http://www.geoplugin.net/json.gp?ip=[[IP]]"}', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `GroupCreateNotifications`
--

CREATE TABLE `GroupCreateNotifications` (
  `id` int(10) unsigned DEFAULT NULL,
  `nID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`nID`),
  KEY `IDX_C17D9982BF396750` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GroupCreates`
--

CREATE TABLE `GroupCreates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gID` int(10) unsigned NOT NULL,
  `requested` datetime NOT NULL,
  `uID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_CCD7EF48FD71026C` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GroupJoinRequests`
--

CREATE TABLE `GroupJoinRequests` (
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  `gID` int(10) unsigned NOT NULL DEFAULT '0',
  `gjrRequested` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY (`uID`,`gID`),
  KEY `uID` (`uID`),
  KEY `gID` (`gID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GroupRoleChangeNotifications`
--

CREATE TABLE `GroupRoleChangeNotifications` (
  `id` int(10) unsigned DEFAULT NULL,
  `nID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`nID`),
  KEY `IDX_C1402C44BF396750` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GroupRoleChanges`
--

CREATE TABLE `GroupRoleChanges` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gID` int(10) unsigned NOT NULL,
  `grID` int(10) unsigned NOT NULL,
  `requested` datetime NOT NULL,
  `uID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_98ADE2F3FD71026C` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GroupRoles`
--

CREATE TABLE `GroupRoles` (
  `grID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `grName` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `grIsManager` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`grID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `GroupRoles`
--

INSERT INTO `GroupRoles` VALUES
(1, 'Member', 0);

-- --------------------------------------------------------

--
-- Table structure for table `Groups`
--

CREATE TABLE `Groups` (
  `gID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gName` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gDescription` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gUserExpirationIsEnabled` tinyint(1) NOT NULL DEFAULT '0',
  `gUserExpirationMethod` varchar(12) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gUserExpirationSetDateTime` datetime DEFAULT NULL,
  `gUserExpirationInterval` int(10) unsigned NOT NULL DEFAULT '0',
  `gUserExpirationAction` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gThumbnailFID` int(10) unsigned NOT NULL DEFAULT '0',
  `gPetitionForPublicEntry` tinyint(1) NOT NULL DEFAULT '0',
  `gOverrideGroupTypeSettings` tinyint(1) NOT NULL DEFAULT '0',
  `gtID` int(10) unsigned NOT NULL DEFAULT '0',
  `gDefaultRoleID` int(10) unsigned NOT NULL DEFAULT '0',
  `gIsBadge` tinyint(1) NOT NULL DEFAULT '0',
  `gBadgeFID` int(10) unsigned NOT NULL DEFAULT '0',
  `gAuthorID` int(10) unsigned NOT NULL DEFAULT '0',
  `gBadgeDescription` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gBadgeCommunityPointValue` int(11) NOT NULL DEFAULT '0',
  `gIsAutomated` tinyint(1) NOT NULL DEFAULT '0',
  `gCheckAutomationOnRegister` tinyint(1) NOT NULL DEFAULT '0',
  `gCheckAutomationOnLogin` tinyint(1) NOT NULL DEFAULT '0',
  `gCheckAutomationOnJobRun` tinyint(1) NOT NULL DEFAULT '0',
  `gPath` text COLLATE utf8mb4_unicode_ci,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`gID`),
  KEY `gName` (`gName`),
  KEY `gBadgeFID` (`gBadgeFID`),
  KEY `pkgID` (`pkgID`),
  KEY `gPath` (`gPath`(255))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `Groups`
--

INSERT INTO `Groups` VALUES
(1, 'Guest', 'The guest group represents unregistered visitors to your site.', 0, NULL, NULL, 0, NULL, 0, 0, 0, 1, 1, 0, 0, 0, NULL, 0, 0, 0, 0, 0, '/Guest', 0),
(2, 'Registered Users', 'The registered users group represents all user accounts.', 0, NULL, NULL, 0, NULL, 0, 0, 0, 1, 1, 0, 0, 0, NULL, 0, 0, 0, 0, 0, '/Registered Users', 0),
(3, 'Administrators', '', 0, NULL, NULL, 0, NULL, 0, 0, 0, 1, 1, 0, 0, 0, NULL, 0, 0, 0, 0, 0, '/Administrators', 0);

-- --------------------------------------------------------

--
-- Table structure for table `GroupSelectedRoles`
--

CREATE TABLE `GroupSelectedRoles` (
  `gID` int(10) unsigned NOT NULL DEFAULT '0',
  `grID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`gID`,`grID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GroupSetGroups`
--

CREATE TABLE `GroupSetGroups` (
  `gID` int(10) unsigned NOT NULL DEFAULT '0',
  `gsID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`gID`,`gsID`),
  KEY `gsID` (`gsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GroupSets`
--

CREATE TABLE `GroupSets` (
  `gsID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gsName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`gsID`),
  KEY `gsName` (`gsName`),
  KEY `pkgID` (`pkgID`,`gsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GroupSignupNotifications`
--

CREATE TABLE `GroupSignupNotifications` (
  `id` int(10) unsigned DEFAULT NULL,
  `nID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`nID`),
  KEY `IDX_77F3EABF396750` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GroupSignupRequestAcceptNotifications`
--

CREATE TABLE `GroupSignupRequestAcceptNotifications` (
  `id` int(10) unsigned DEFAULT NULL,
  `nID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`nID`),
  KEY `IDX_72E6015ABF396750` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GroupSignupRequestAccepts`
--

CREATE TABLE `GroupSignupRequestAccepts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gID` int(10) unsigned NOT NULL,
  `RequestAccepted` datetime NOT NULL,
  `uID` int(10) unsigned DEFAULT NULL,
  `managerUID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_18BBF9FCFD71026C` (`uID`),
  KEY `IDX_18BBF9FCDB43B5DF` (`managerUID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GroupSignupRequestDeclineNotifications`
--

CREATE TABLE `GroupSignupRequestDeclineNotifications` (
  `id` int(10) unsigned DEFAULT NULL,
  `nID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`nID`),
  KEY `IDX_930C0D02BF396750` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GroupSignupRequestDeclines`
--

CREATE TABLE `GroupSignupRequestDeclines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gID` int(10) unsigned NOT NULL,
  `RequestDeclineed` datetime NOT NULL,
  `uID` int(10) unsigned DEFAULT NULL,
  `managerUID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_A905188EFD71026C` (`uID`),
  KEY `IDX_A905188EDB43B5DF` (`managerUID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GroupSignupRequestNotifications`
--

CREATE TABLE `GroupSignupRequestNotifications` (
  `id` int(10) unsigned DEFAULT NULL,
  `nID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`nID`),
  KEY `IDX_56EC93C8BF396750` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GroupSignupRequests`
--

CREATE TABLE `GroupSignupRequests` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gID` int(10) unsigned NOT NULL,
  `requested` datetime NOT NULL,
  `uID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_8CF06191FD71026C` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GroupSignups`
--

CREATE TABLE `GroupSignups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gID` int(10) unsigned NOT NULL,
  `requested` datetime NOT NULL,
  `uID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_D6CC4ECBFD71026C` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GroupTypes`
--

CREATE TABLE `GroupTypes` (
  `gtID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gtName` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gtDefaultRoleID` int(10) unsigned NOT NULL DEFAULT '0',
  `gtPetitionForPublicEntry` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`gtID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `GroupTypes`
--

INSERT INTO `GroupTypes` VALUES
(1, 'Group', 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `GroupTypeSelectedRoles`
--

CREATE TABLE `GroupTypeSelectedRoles` (
  `gtID` int(10) unsigned NOT NULL DEFAULT '0',
  `grID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`gtID`,`grID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `GroupTypeSelectedRoles`
--

INSERT INTO `GroupTypeSelectedRoles` VALUES
(1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `HealthReportResultFindings`
--

CREATE TABLE `HealthReportResultFindings` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `result_id` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `message` json DEFAULT NULL,
  `handle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `control` json DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_14794DC7A7B643` (`result_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `HealthReportResults`
--

CREATE TABLE `HealthReportResults` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `dateStarted` int(10) unsigned NOT NULL,
  `dateCompleted` int(10) unsigned DEFAULT NULL,
  `score` int(10) unsigned DEFAULT NULL,
  `grade` json DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `taskID` int(10) unsigned DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_F8C09F44E821EAFF` (`taskID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `HealthReportSearchResults`
--

CREATE TABLE `HealthReportSearchResults` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `searchString` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `searchType` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `IpAccessControlCategories`
--

CREATE TABLE `IpAccessControlCategories` (
  `iaccID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The IP Access Control Category identifier',
  `iaccHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The IP Access Control handle',
  `iaccName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The IP Access Control name',
  `iaccEnabled` tinyint(1) NOT NULL COMMENT 'Is this IP Access Control enabled?',
  `iaccMaxEvents` int(10) unsigned NOT NULL COMMENT 'The maximum allowed events in the time window',
  `iaccTimeWindow` int(10) unsigned DEFAULT NULL COMMENT 'The time window (in seconds) where the events should be counted (NULL means no limits)',
  `iaccBanDuration` int(10) unsigned DEFAULT NULL COMMENT 'The duration (in seconds) of the ban when the maximum number of events occur in the time window (NULL means forever)',
  `iaccSiteSpecific` tinyint(1) NOT NULL COMMENT 'Is this IP Access Control Category site-specific?',
  `iaccLogChannel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The log channel handle',
  `iaccPackage` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`iaccID`),
  UNIQUE KEY `UNIQ_D4A1006246B4A747` (`iaccHandle`),
  KEY `IDX_D4A10062C908ED51` (`iaccPackage`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='List of IP Access Control Categories' AUTO_INCREMENT=3 ;

--
-- Dumping data for table `IpAccessControlCategories`
--

INSERT INTO `IpAccessControlCategories` VALUES
(1, 'failed_login', 'Failed Login Attempts', 1, 5, 300, 600, 0, 'security', NULL),
(2, 'forgot_password', 'Forgot Password Attempts', 1, 2, 30, 600, 0, 'security', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `IpAccessControlEvents`
--

CREATE TABLE `IpAccessControlEvents` (
  `iaceID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The IP Access Control Event identifier',
  `iaceIp` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The IP address associated to this event',
  `iaceDateTime` datetime NOT NULL COMMENT 'The date/time when this event occurred',
  `iaceCategory` int(10) unsigned NOT NULL COMMENT 'The IP Access Control Category identifier',
  `iaceSite` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`iaceID`),
  KEY `IDX_6C004072E9480668` (`iaceCategory`),
  KEY `IDX_6C004072B0C0DFA7` (`iaceSite`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='List of IP Access Control Events' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `IpAccessControlRanges`
--

CREATE TABLE `IpAccessControlRanges` (
  `iacrID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The IP Access Control Range identifier',
  `iacrIpFrom` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The initial IP address of the range',
  `iacrIpTo` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The final IP address of the range',
  `iacrType` int(10) unsigned NOT NULL COMMENT 'The type of this range',
  `iacrExpiration` datetime DEFAULT NULL COMMENT 'The date/time when this range expires (NULL means no expiration)',
  `iacrCategory` int(10) unsigned NOT NULL COMMENT 'The IP Access Control Category identifier',
  `iacrSite` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`iacrID`),
  KEY `IDX_2B1AA65D21E929D0` (`iacrCategory`),
  KEY `IDX_2B1AA65D62009435` (`iacrSite`),
  KEY `IPIntervalExpiration` (`iacrIpFrom`,`iacrIpTo`,`iacrExpiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='List of IP Access Control Ranges' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `Jobs`
--

CREATE TABLE `Jobs` (
  `jID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `jName` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `jDescription` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `jDateInstalled` datetime DEFAULT NULL,
  `jDateLastRun` datetime DEFAULT NULL,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  `jLastStatusText` longtext COLLATE utf8mb4_unicode_ci,
  `jLastStatusCode` smallint(6) NOT NULL DEFAULT '0',
  `jStatus` varchar(14) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'ENABLED',
  `jHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `jNotUninstallable` smallint(6) NOT NULL DEFAULT '0',
  `isScheduled` smallint(6) NOT NULL DEFAULT '0',
  `scheduledInterval` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'days',
  `scheduledValue` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`jID`),
  UNIQUE KEY `jHandle` (`jHandle`),
  KEY `pkgID` (`pkgID`),
  KEY `isScheduled` (`isScheduled`,`jDateLastRun`,`jID`),
  KEY `jDateLastRun` (`jDateLastRun`,`jID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `JobSetJobs`
--

CREATE TABLE `JobSetJobs` (
  `jsID` int(10) unsigned NOT NULL DEFAULT '0',
  `jID` int(10) unsigned NOT NULL DEFAULT '0',
  `jRunOrder` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`jsID`,`jID`),
  KEY `jID` (`jID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `JobSets`
--

CREATE TABLE `JobSets` (
  `jsID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `jsName` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  `jDateLastRun` datetime DEFAULT NULL,
  `isScheduled` smallint(6) NOT NULL DEFAULT '0',
  `scheduledInterval` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'days',
  `scheduledValue` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`jsID`),
  KEY `pkgID` (`pkgID`),
  KEY `jsName` (`jsName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `JobsLog`
--

CREATE TABLE `JobsLog` (
  `jlID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `jID` int(10) unsigned NOT NULL,
  `jlMessage` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `jlTimestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `jlError` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`jlID`),
  KEY `jID` (`jID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `LegacyAttributeKeys`
--

CREATE TABLE `LegacyAttributeKeys` (
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `Logs`
--

CREATE TABLE `Logs` (
  `logID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `channel` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `time` int(10) unsigned NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci,
  `cID` int(10) unsigned DEFAULT NULL,
  `uID` int(10) unsigned DEFAULT NULL,
  `level` int(11) NOT NULL,
  PRIMARY KEY (`logID`),
  KEY `channel` (`channel`),
  KEY `uID` (`uID`),
  KEY `cID` (`cID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `MailImporters`
--

CREATE TABLE `MailImporters` (
  `miID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `miHandle` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `miServer` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `miUsername` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `miPassword` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `miEncryption` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `miIsEnabled` tinyint(1) NOT NULL DEFAULT '0',
  `miEmail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `miPort` int(10) unsigned NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned DEFAULT NULL,
  `miConnectionMethod` varchar(8) COLLATE utf8mb4_unicode_ci DEFAULT 'POP',
  PRIMARY KEY (`miID`),
  UNIQUE KEY `miHandle` (`miHandle`),
  KEY `pkgID` (`pkgID`,`miID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `MailImporters`
--

INSERT INTO `MailImporters` VALUES
(1, 'private_message', '', NULL, NULL, NULL, 0, '', 0, 0, 'POP');

-- --------------------------------------------------------

--
-- Table structure for table `MailValidationHashes`
--

CREATE TABLE `MailValidationHashes` (
  `mvhID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `miID` int(10) unsigned NOT NULL DEFAULT '0',
  `email` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mHash` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mDateGenerated` int(10) unsigned NOT NULL DEFAULT '0',
  `mDateRedeemed` int(10) unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`mvhID`),
  UNIQUE KEY `mHash` (`mHash`),
  KEY `miID` (`miID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `MessengerBatches`
--

CREATE TABLE `MessengerBatches` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `totalJobs` int(11) NOT NULL,
  `pendingJobs` int(11) NOT NULL,
  `failedJobs` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `MessengerMessages`
--

CREATE TABLE `MessengerMessages` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `body` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `headers` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue_name` varchar(190) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL,
  `available_at` datetime NOT NULL,
  `delivered_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_41BD93AFFB7336F0` (`queue_name`),
  KEY `IDX_41BD93AFE3BD61CE` (`available_at`),
  KEY `IDX_41BD93AF16BA31DB` (`delivered_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `MessengerProcesses`
--

CREATE TABLE `MessengerProcesses` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `batch_id` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `dateStarted` int(10) unsigned NOT NULL,
  `dateCompleted` int(10) unsigned DEFAULT NULL,
  `exitCode` int(10) unsigned DEFAULT NULL,
  `exitMessage` longtext COLLATE utf8mb4_unicode_ci,
  `uID` int(10) unsigned DEFAULT NULL,
  `processType` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_FBB7A9C9F39EBE7A` (`batch_id`),
  KEY `IDX_FBB7A9C9FD71026C` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `MessengerScheduledTasks`
--

CREATE TABLE `MessengerScheduledTasks` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `task_id` int(10) unsigned DEFAULT NULL,
  `input` json DEFAULT NULL,
  `dateScheduled` int(10) unsigned DEFAULT NULL,
  `cronExpression` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `uID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_DCEB3C0D8DB60186` (`task_id`),
  KEY `IDX_DCEB3C0DFD71026C` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `MessengerTaskProcesses`
--

CREATE TABLE `MessengerTaskProcesses` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `task_id` int(10) unsigned DEFAULT NULL,
  `input` json DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_BE77DC6F8DB60186` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `MultilingualPageRelations`
--

CREATE TABLE `MultilingualPageRelations` (
  `mpLocale` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mpLanguage` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mpRelationID` int(10) unsigned NOT NULL,
  `cID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`mpRelationID`,`cID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `MultilingualTranslations`
--

CREATE TABLE `MultilingualTranslations` (
  `mtID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mtSectionID` int(10) unsigned NOT NULL DEFAULT '0',
  `msgid` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `msgidPlural` text COLLATE utf8mb4_unicode_ci,
  `msgstr` text COLLATE utf8mb4_unicode_ci,
  `msgstrPlurals` text COLLATE utf8mb4_unicode_ci,
  `context` text COLLATE utf8mb4_unicode_ci,
  `comments` text COLLATE utf8mb4_unicode_ci,
  `reference` text COLLATE utf8mb4_unicode_ci,
  `flags` text COLLATE utf8mb4_unicode_ci,
  `updated` datetime DEFAULT NULL,
  PRIMARY KEY (`mtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `NotificationAlerts`
--

CREATE TABLE `NotificationAlerts` (
  `naID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `naIsArchived` tinyint(1) NOT NULL,
  `uID` int(10) unsigned DEFAULT NULL,
  `nID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`naID`),
  KEY `IDX_E11C7408FD71026C` (`uID`),
  KEY `IDX_E11C7408ED024EFD` (`nID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `NotificationPermissionSubscriptionList`
--

CREATE TABLE `NotificationPermissionSubscriptionList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`),
  KEY `peID` (`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `NotificationPermissionSubscriptionListCustom`
--

CREATE TABLE `NotificationPermissionSubscriptionListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `nSubscriptionIdentifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`paID`,`peID`,`nSubscriptionIdentifier`),
  KEY `peID` (`peID`),
  KEY `nSubscriptionIdentifier` (`nSubscriptionIdentifier`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `Notifications`
--

CREATE TABLE `Notifications` (
  `nID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nDate` datetime NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`nID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `OAuth2AccessToken`
--

CREATE TABLE `OAuth2AccessToken` (
  `identifier` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `client` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `expiryDateTime` datetime NOT NULL,
  `userIdentifier` int(10) unsigned DEFAULT NULL,
  `scopes` json NOT NULL COMMENT '(DC2Type:json_array)',
  PRIMARY KEY (`identifier`),
  KEY `IDX_60D69F3FC7440455` (`client`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `OAuth2AuthCode`
--

CREATE TABLE `OAuth2AuthCode` (
  `identifier` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `client` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `scopes` json NOT NULL COMMENT '(DC2Type:json_array)',
  `expiryDateTime` datetime NOT NULL,
  `userIdentifier` int(10) unsigned NOT NULL,
  PRIMARY KEY (`identifier`),
  KEY `IDX_29D07B5C7440455` (`client`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `OAuth2Client`
--

CREATE TABLE `OAuth2Client` (
  `identifier` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `redirectUri` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `clientKey` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `clientSecret` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `documentationEnabled` tinyint(1) NOT NULL,
  `hasCustomScopes` tinyint(1) NOT NULL,
  `consentType` int(10) unsigned NOT NULL,
  PRIMARY KEY (`identifier`),
  UNIQUE KEY `client_idx` (`clientKey`,`clientSecret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `OAuth2ClientScopes`
--

CREATE TABLE `OAuth2ClientScopes` (
  `clientIdentifier` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `scopeIdentifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`clientIdentifier`,`scopeIdentifier`),
  KEY `IDX_497E26F39ECFF1A8` (`clientIdentifier`),
  KEY `IDX_497E26F3C7FD45E9` (`scopeIdentifier`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `OAuth2RefreshToken`
--

CREATE TABLE `OAuth2RefreshToken` (
  `identifier` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `expiryDateTime` datetime NOT NULL,
  `accessToken` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`identifier`),
  UNIQUE KEY `UNIQ_A205CB8350A9822` (`accessToken`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `OAuth2Scope`
--

CREATE TABLE `OAuth2Scope` (
  `identifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`identifier`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `OAuth2Scope`
--

INSERT INTO `OAuth2Scope` VALUES
('account:read', 'Read your user object'),
('blocks:delete', 'Delete blocks'),
('blocks:read', 'View site blocks'),
('blocks:update', 'Update blocks'),
('calendar_events:read', 'Read calendar events'),
('calendars:read', 'Read calendars'),
('files:add', 'Add files'),
('files:delete', 'Delete files'),
('files:read', 'Read files as your user'),
('files:update', 'Update files'),
('groups:add', 'Add groups'),
('groups:read', 'Views groups in the site'),
('openid', 'Remotely authenticate into Concrete'),
('pages:add', 'Add pages'),
('pages:areas:add_block', 'Add blocks to a page area'),
('pages:areas:delete_block', 'Delete blocks from a page area'),
('pages:areas:update_block', 'Updates a block in a page area'),
('pages:delete', 'Delete pages'),
('pages:read', 'View site pages'),
('pages:update', 'Update pages'),
('pages:versions:delete', 'Delete page versions'),
('pages:versions:read', 'View page versions'),
('pages:versions:update', 'Update page versions'),
('sites:read', 'Read sites'),
('system:info:read', 'Read system information'),
('users:add', 'Add users'),
('users:delete', 'Delete users'),
('users:read', 'Views users in the site'),
('users:update', 'Update users');

-- --------------------------------------------------------

--
-- Table structure for table `OAuthServerAccessTokens`
--

CREATE TABLE `OAuthServerAccessTokens` (
  `access_token` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expires` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `scope` varchar(4000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`access_token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `OAuthServerAuthorizationCodes`
--

CREATE TABLE `OAuthServerAuthorizationCodes` (
  `access_token` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `redirect_uri` varchar(2000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expires` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `scope` varchar(4000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `id_token` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`access_token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `OAuthServerClients`
--

CREATE TABLE `OAuthServerClients` (
  `client_id` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_secret` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `redirect_uri` varchar(2000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `grant_types` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `scope` varchar(4000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `OAuthServerJti`
--

CREATE TABLE `OAuthServerJti` (
  `issuer` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `audiance` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expires` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `jti` varchar(2000) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `OAuthServerJwt`
--

CREATE TABLE `OAuthServerJwt` (
  `client_id` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `public_key` varchar(2000) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `OAuthServerPublicKeys`
--

CREATE TABLE `OAuthServerPublicKeys` (
  `client_id` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `public_key` varchar(2000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `private_key` varchar(2000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `encryption_algorithm` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT 'RS256'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `OAuthServerRefreshTokens`
--

CREATE TABLE `OAuthServerRefreshTokens` (
  `refresh_token` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expires` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `scope` varchar(4000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`refresh_token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `OAuthServerScopes`
--

CREATE TABLE `OAuthServerScopes` (
  `scope` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_default` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`scope`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `OAuthServerUsers`
--

CREATE TABLE `OAuthServerUsers` (
  `username` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_verified` tinyint(1) DEFAULT NULL,
  `scope` varchar(4000) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `OauthUserMap`
--

CREATE TABLE `OauthUserMap` (
  `user_id` int(10) unsigned NOT NULL,
  `namespace` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `binding` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`user_id`,`namespace`),
  UNIQUE KEY `oauth_binding` (`binding`,`namespace`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `Packages`
--

CREATE TABLE `Packages` (
  `pkgID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pkgHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pkgVersion` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pkgIsInstalled` tinyint(1) NOT NULL,
  `pkgAvailableVersion` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pkgDescription` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `pkgDateInstalled` datetime NOT NULL,
  `pkgName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`pkgID`),
  UNIQUE KEY `UNIQ_62C3A2F1F2D49DB1` (`pkgHandle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `PageContainerInstanceAreas`
--

CREATE TABLE `PageContainerInstanceAreas` (
  `containerInstanceAreaID` int(11) NOT NULL AUTO_INCREMENT,
  `arID` int(11) NOT NULL,
  `containerAreaName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `containerInstanceID` int(11) DEFAULT NULL,
  PRIMARY KEY (`containerInstanceAreaID`),
  KEY `IDX_484B3E0A1FCD0045` (`containerInstanceID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `PageContainerInstances`
--

CREATE TABLE `PageContainerInstances` (
  `containerInstanceID` int(11) NOT NULL AUTO_INCREMENT,
  `containerID` int(11) DEFAULT NULL,
  PRIMARY KEY (`containerInstanceID`),
  KEY `IDX_489D87A71159C151` (`containerID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `PageContainers`
--

CREATE TABLE `PageContainers` (
  `containerID` int(11) NOT NULL AUTO_INCREMENT,
  `containerHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `containerIcon` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `containerName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`containerID`),
  KEY `IDX_65E7C1D1CE45CBB0` (`pkgID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `PageFeeds`
--

CREATE TABLE `PageFeeds` (
  `checkPagePermissions` tinyint(1) NOT NULL,
  `customTopicAttributeKeyHandle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customTopicTreeNodeID` int(10) unsigned NOT NULL,
  `iconFID` int(10) unsigned NOT NULL,
  `pfDescription` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pfHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pfTitle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pfID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cParentID` int(10) unsigned NOT NULL,
  `ptID` int(10) unsigned NOT NULL,
  `pfIncludeAllDescendents` tinyint(1) NOT NULL,
  `pfDisplayAliases` tinyint(1) NOT NULL,
  `pfDisplaySystemPages` tinyint(1) NOT NULL,
  `pfContentToDisplay` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pfAreaHandleToDisplay` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pfDisplayFeaturedOnly` tinyint(1) NOT NULL,
  PRIMARY KEY (`pfID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `PagePaths`
--

CREATE TABLE `PagePaths` (
  `cPath` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `ppID` int(11) NOT NULL AUTO_INCREMENT,
  `cID` int(10) unsigned NOT NULL,
  `ppIsCanonical` tinyint(1) NOT NULL,
  `ppGeneratedFromURLSlugs` tinyint(1) NOT NULL,
  PRIMARY KEY (`ppID`),
  KEY `ppIsCanonical` (`ppIsCanonical`),
  KEY `cID` (`cID`),
  KEY `cPath` (`cPath`(255))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=230 ;

--
-- Dumping data for table `PagePaths`
--

INSERT INTO `PagePaths` VALUES
('/dashboard', 1, 2, 1, 1),
('/dashboard/sitemap', 2, 3, 1, 1),
('/dashboard/sitemap/full', 3, 4, 1, 1),
('/dashboard/sitemap/explore', 4, 5, 1, 1),
('/dashboard/sitemap/search', 5, 6, 1, 1),
('/dashboard/files', 6, 7, 1, 1),
('/dashboard/files/search', 7, 8, 1, 1),
('/dashboard/files/details', 8, 9, 1, 1),
('/dashboard/files/attributes', 9, 10, 1, 1),
('/dashboard/files/sets', 10, 11, 1, 1),
('/dashboard/files/add_set', 11, 12, 1, 1),
('/dashboard/users', 12, 13, 1, 1),
('/dashboard/users/search', 13, 14, 1, 1),
('/dashboard/users/groups', 14, 15, 1, 1),
('/dashboard/users/group_types', 15, 16, 1, 1),
('/dashboard/users/groups/message', 16, 17, 1, 1),
('/dashboard/users/attributes', 17, 18, 1, 1),
('/dashboard/users/add', 18, 19, 1, 1),
('/dashboard/users/add_group', 19, 20, 1, 1),
('/dashboard/users/groups/bulkupdate', 20, 21, 1, 1),
('/dashboard/users/groups/bulk_user_assignment', 21, 22, 1, 1),
('/dashboard/users/group_sets', 22, 23, 1, 1),
('/dashboard/express', 23, 24, 1, 1),
('/dashboard/express/entries', 24, 25, 1, 1),
('/dashboard/boards', 25, 26, 1, 1),
('/dashboard/boards/boards', 26, 27, 1, 1),
('/dashboard/boards/add', 27, 28, 1, 1),
('/dashboard/boards/details', 28, 29, 1, 1),
('/dashboard/boards/edit', 29, 30, 1, 1),
('/dashboard/boards/data_sources', 30, 31, 1, 1),
('/dashboard/boards/appearance', 31, 32, 1, 1),
('/dashboard/boards/weighting', 32, 33, 1, 1),
('/dashboard/boards/permissions', 33, 34, 1, 1),
('/dashboard/boards/instances', 34, 35, 1, 1),
('/dashboard/boards/instances/details', 35, 36, 1, 1),
('/dashboard/boards/instances/rules', 36, 37, 1, 1),
('/dashboard/boards/designer', 37, 38, 1, 1),
('/dashboard/boards/designer/choose_items', 38, 39, 1, 1),
('/dashboard/boards/designer/customize_slot', 39, 40, 1, 1),
('/dashboard/boards/scheduler', 40, 41, 1, 1),
('/dashboard/reports', 41, 42, 1, 1),
('/dashboard/reports/forms', 42, 43, 1, 1),
('/dashboard/reports/forms/legacy', 43, 44, 1, 1),
('/dashboard/reports/health', 44, 45, 1, 1),
('/dashboard/reports/health/details', 45, 46, 1, 1),
('/dashboard/reports/surveys', 46, 47, 1, 1),
('/dashboard/reports/logs', 47, 48, 1, 1),
('/dashboard/reports/page_changes', 48, 49, 1, 1),
('/dashboard/pages', 49, 50, 1, 1),
('/dashboard/pages/themes', 50, 51, 1, 1),
('/dashboard/pages/themes/inspect', 51, 52, 1, 1),
('/dashboard/pages/types', 52, 53, 1, 1),
('/dashboard/pages/types/organize', 53, 54, 1, 1),
('/dashboard/pages/types/add', 54, 55, 1, 1),
('/dashboard/pages/types/form', 55, 56, 1, 1),
('/dashboard/pages/types/output', 56, 57, 1, 1),
('/dashboard/pages/types/attributes', 57, 58, 1, 1),
('/dashboard/pages/types/permissions', 58, 59, 1, 1),
('/dashboard/pages/templates', 59, 60, 1, 1),
('/dashboard/pages/templates/add', 60, 61, 1, 1),
('/dashboard/pages/containers', 61, 62, 1, 1),
('/dashboard/pages/containers/add', 62, 63, 1, 1),
('/dashboard/pages/attributes', 63, 64, 1, 1),
('/dashboard/pages/single', 64, 65, 1, 1),
('/dashboard/pages/feeds', 65, 66, 1, 1),
('/dashboard/calendar', 66, 67, 1, 1),
('/dashboard/calendar/events', 67, 68, 1, 1),
('/dashboard/calendar/event_list', 68, 69, 1, 1),
('/dashboard/calendar/add', 69, 70, 1, 1),
('/dashboard/calendar/permissions', 70, 71, 1, 1),
('/dashboard/calendar/attributes', 71, 72, 1, 1),
('/dashboard/conversations', 72, 73, 1, 1),
('/dashboard/conversations/messages', 73, 74, 1, 1),
('/dashboard/blocks', 74, 75, 1, 1),
('/dashboard/blocks/stacks', 75, 76, 1, 1),
('/dashboard/blocks/permissions', 76, 77, 1, 1),
('/dashboard/blocks/stacks/list', 77, 78, 1, 1),
('/dashboard/blocks/types', 78, 79, 1, 1),
('/dashboard/extend', 79, 80, 1, 1),
('/dashboard/extend/install', 80, 81, 1, 1),
('/dashboard/extend/update', 81, 82, 1, 1),
('/dashboard/extend/themes', 82, 83, 1, 1),
('/dashboard/extend/addons', 83, 84, 1, 1),
('/dashboard/system', 84, 85, 1, 1),
('/dashboard/system/basics', 85, 86, 1, 1),
('/dashboard/system/basics/name', 86, 87, 1, 1),
('/dashboard/system/basics/marketplace', 87, 88, 1, 1),
('/dashboard/system/basics/production_mode', 88, 89, 1, 1),
('/dashboard/system/basics/appearance', 89, 90, 1, 1),
('/dashboard/system/basics/site_information', 90, 91, 1, 1),
('/dashboard/system/basics/icons', 91, 92, 1, 1),
('/dashboard/system/basics/editor', 92, 93, 1, 1),
('/dashboard/system/basics/multilingual', 93, 94, 1, 1),
('/dashboard/system/basics/multilingual/update', 94, 95, 1, 1),
('/dashboard/system/basics/timezone', 95, 96, 1, 1),
('/dashboard/system/basics/attributes', 96, 97, 1, 1),
('/dashboard/system/basics/reset_edit_mode', 97, 98, 1, 1),
('/dashboard/system/social', 98, 99, 1, 1),
('/dashboard/system/social/social_links', 99, 100, 1, 1),
('/dashboard/system/social/opengraph', 100, 101, 1, 1),
('/dashboard/system/express', 101, 102, 1, 1),
('/dashboard/system/express/entities', 102, 103, 1, 1),
('/dashboard/system/express/entities/attributes', 103, 104, 1, 1),
('/dashboard/system/express/entities/associations', 104, 105, 1, 1),
('/dashboard/system/express/entities/forms', 105, 106, 1, 1),
('/dashboard/system/express/entities/customize_search', 106, 107, 1, 1),
('/dashboard/system/express/entities/order_entries', 107, 108, 1, 1),
('/dashboard/system/express/entries', 108, 109, 1, 1),
('/dashboard/system/multisite', 109, 110, 1, 1),
('/dashboard/system/multisite/sites', 110, 111, 1, 1),
('/dashboard/system/multisite/types', 111, 112, 1, 1),
('/dashboard/system/multisite/settings', 112, 113, 1, 1),
('/dashboard/system/multilingual', 113, 114, 1, 1),
('/dashboard/system/multilingual/setup', 114, 115, 1, 1),
('/dashboard/system/multilingual/copy', 115, 116, 1, 1),
('/dashboard/system/multilingual/page_report', 116, 117, 1, 1),
('/dashboard/system/multilingual/translate_interface', 117, 118, 1, 1),
('/dashboard/system/seo', 118, 119, 1, 1),
('/dashboard/system/seo/urls', 119, 120, 1, 1),
('/dashboard/system/seo/bulk', 120, 121, 1, 1),
('/dashboard/system/seo/codes', 121, 122, 1, 1),
('/dashboard/system/seo/excluded', 122, 123, 1, 1),
('/dashboard/system/seo/searchindex', 123, 124, 1, 1),
('/dashboard/system/seo/url_slug', 124, 125, 1, 1),
('/dashboard/system/files', 125, 126, 1, 1),
('/dashboard/system/files/filetypes', 126, 127, 1, 1),
('/dashboard/system/files/file_chooser', 127, 128, 1, 1),
('/dashboard/system/files/permissions', 128, 129, 1, 1),
('/dashboard/system/files/thumbnails', 129, 130, 1, 1),
('/dashboard/system/files/thumbnails/options', 130, 131, 1, 1),
('/dashboard/system/files/image_uploading', 131, 132, 1, 1),
('/dashboard/system/files/image_editor', 132, 133, 1, 1),
('/dashboard/system/files/storage', 133, 134, 1, 1),
('/dashboard/system/files/external_file_provider', 134, 135, 1, 1),
('/dashboard/system/files/export_options', 135, 136, 1, 1),
('/dashboard/system/files/uploads', 136, 137, 1, 1),
('/dashboard/system/automation', 137, 138, 1, 1),
('/dashboard/system/automation/tasks', 138, 139, 1, 1),
('/dashboard/system/automation/activity', 139, 140, 1, 1),
('/dashboard/system/automation/failed', 140, 141, 1, 1),
('/dashboard/system/automation/schedule', 141, 142, 1, 1),
('/dashboard/system/automation/settings', 142, 143, 1, 1),
('/dashboard/system/notification', 143, 144, 1, 1),
('/dashboard/system/notification/events', 144, 145, 1, 1),
('/dashboard/system/notification/alerts', 145, 146, 1, 1),
('/dashboard/system/optimization', 146, 147, 1, 1),
('/dashboard/system/optimization/cache', 147, 148, 1, 1),
('/dashboard/system/optimization/clearcache', 148, 149, 1, 1),
('/dashboard/system/optimization/jobs', 149, 150, 1, 1),
('/dashboard/system/permissions', 150, 151, 1, 1),
('/dashboard/system/permissions/site', 151, 152, 1, 1),
('/dashboard/system/permissions/tasks', 152, 153, 1, 1),
('/dashboard/system/permissions/users', 153, 154, 1, 1),
('/dashboard/system/permissions/advanced', 154, 155, 1, 1),
('/dashboard/system/permissions/workflows', 155, 156, 1, 1),
('/dashboard/system/permissions/denylist', 156, 157, 1, 1),
('/dashboard/system/permissions/denylist/configure', 157, 158, 1, 1),
('/dashboard/system/permissions/denylist/range', 158, 159, 1, 1),
('/dashboard/system/permissions/captcha', 159, 160, 1, 1),
('/dashboard/system/permissions/antispam', 160, 161, 1, 1),
('/dashboard/system/permissions/maintenance', 161, 162, 1, 1),
('/dashboard/system/permissions/trusted_proxies', 162, 163, 1, 1),
('/dashboard/system/registration', 163, 164, 1, 1),
('/dashboard/system/registration/open', 164, 165, 1, 1),
('/dashboard/system/registration/postlogin', 165, 166, 1, 1),
('/dashboard/system/registration/profiles', 166, 167, 1, 1),
('/dashboard/system/registration/authentication', 167, 168, 1, 1),
('/dashboard/system/registration/global_password_reset', 168, 169, 1, 1),
('/dashboard/system/registration/deactivation', 169, 170, 1, 1),
('/dashboard/system/registration/automated_logout', 170, 171, 1, 1),
('/dashboard/system/registration/password_requirements', 171, 172, 1, 1),
('/dashboard/system/registration/session_options', 172, 173, 1, 1),
('/dashboard/system/mail', 173, 174, 1, 1),
('/dashboard/system/mail/method', 174, 175, 1, 1),
('/dashboard/system/mail/method/test', 175, 176, 1, 1),
('/dashboard/system/mail/importers', 176, 177, 1, 1),
('/dashboard/system/mail/addresses', 177, 178, 1, 1),
('/dashboard/system/mail/logging', 178, 179, 1, 1),
('/dashboard/system/calendar', 179, 180, 1, 1),
('/dashboard/system/calendar/settings', 180, 181, 1, 1),
('/dashboard/system/calendar/colors', 181, 182, 1, 1),
('/dashboard/system/calendar/permissions', 182, 183, 1, 1),
('/dashboard/system/calendar/import', 183, 184, 1, 1),
('/dashboard/system/boards', 184, 185, 1, 1),
('/dashboard/system/boards/settings', 185, 186, 1, 1),
('/dashboard/system/boards/permissions', 186, 187, 1, 1),
('/dashboard/system/boards/summary_templates', 187, 188, 1, 1),
('/dashboard/system/conversations', 188, 189, 1, 1),
('/dashboard/system/conversations/settings', 189, 190, 1, 1),
('/dashboard/system/conversations/points', 190, 191, 1, 1),
('/dashboard/system/conversations/bannedwords', 191, 192, 1, 1),
('/dashboard/system/conversations/permissions', 192, 193, 1, 1),
('/dashboard/system/attributes', 193, 194, 1, 1),
('/dashboard/system/attributes/types', 194, 195, 1, 1),
('/dashboard/system/attributes/sets', 195, 196, 1, 1),
('/dashboard/system/attributes/topics', 196, 197, 1, 1),
('/dashboard/system/attributes/topics/add', 197, 198, 1, 1),
('/dashboard/system/environment', 198, 199, 1, 1),
('/dashboard/system/environment/info', 199, 200, 1, 1),
('/dashboard/system/environment/errors', 200, 201, 1, 1),
('/dashboard/system/environment/logging', 201, 202, 1, 1),
('/dashboard/system/environment/proxy', 202, 203, 1, 1),
('/dashboard/system/environment/entities', 203, 204, 1, 1),
('/dashboard/system/environment/database_charset', 204, 205, 1, 1),
('/dashboard/system/environment/geolocation', 205, 206, 1, 1),
('/dashboard/system/environment/security', 206, 207, 1, 1),
('/dashboard/system/update', 207, 208, 1, 1),
('/dashboard/system/update/update', 208, 209, 1, 1),
('/dashboard/system/api', 209, 210, 1, 1),
('/dashboard/system/api/integrations', 210, 211, 1, 1),
('/dashboard/system/api/scopes', 211, 212, 1, 1),
('/dashboard/system/api/settings', 212, 213, 1, 1),
('/dashboard/welcome', 213, 214, 1, 1),
('/dashboard/welcome/health', 214, 215, 1, 1),
('/dashboard/welcome/me', 215, 216, 1, 1),
('/!themes', 216, 217, 1, 1),
('/!stacks', 217, 218, 1, 1),
('/page_not_found', 218, 219, 1, 1),
('/!trash', 219, 220, 1, 1),
('/login', 220, 221, 1, 1),
('/register', 221, 222, 1, 1),
('/account', 222, 223, 1, 1),
('/account/edit_profile', 223, 224, 1, 1),
('/account/avatar', 224, 225, 1, 1),
('/account/messages', 225, 226, 1, 1),
('/page_forbidden', 226, 227, 1, 1),
('/download_file', 227, 228, 1, 1),
('/!drafts', 228, 229, 1, 1),
('/account/welcome', 229, 230, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `PagePermissionAssignments`
--

CREATE TABLE `PagePermissionAssignments` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`pkID`,`paID`),
  KEY `paID` (`paID`,`pkID`),
  KEY `pkID` (`pkID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `PagePermissionAssignments`
--

INSERT INTO `PagePermissionAssignments` VALUES
(1, 1, 101),
(2, 1, 82),
(219, 1, 81),
(221, 1, 78),
(222, 1, 79),
(227, 1, 80),
(229, 1, 83),
(1, 2, 102),
(229, 2, 84),
(1, 3, 103),
(229, 3, 85),
(1, 4, 104),
(229, 4, 86),
(1, 5, 105),
(229, 5, 87),
(1, 6, 106),
(229, 6, 88),
(1, 7, 107),
(229, 7, 89),
(1, 8, 109),
(229, 8, 91),
(1, 9, 110),
(229, 9, 92),
(1, 10, 111),
(229, 10, 93),
(1, 11, 112),
(229, 11, 94),
(1, 12, 113),
(229, 12, 95),
(1, 13, 114),
(229, 13, 96),
(1, 14, 115),
(229, 14, 97),
(1, 15, 116),
(229, 15, 98),
(1, 16, 117),
(229, 16, 99),
(1, 17, 118),
(229, 17, 100),
(1, 18, 108),
(229, 18, 90);

-- --------------------------------------------------------

--
-- Table structure for table `PagePermissionPageTypeAccessList`
--

CREATE TABLE `PagePermissionPageTypeAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `externalLink` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`),
  KEY `peID` (`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `PagePermissionPageTypeAccessListCustom`
--

CREATE TABLE `PagePermissionPageTypeAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `ptID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`ptID`),
  KEY `peID` (`peID`),
  KEY `ptID` (`ptID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `PagePermissionPropertyAccessList`
--

CREATE TABLE `PagePermissionPropertyAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `name` tinyint(1) DEFAULT '0',
  `publicDateTime` tinyint(1) DEFAULT '0',
  `uID` tinyint(1) DEFAULT '0',
  `description` tinyint(1) DEFAULT '0',
  `paths` tinyint(1) DEFAULT '0',
  `attributePermission` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`),
  KEY `peID` (`peID`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `PagePermissionPropertyAttributeAccessListCustom`
--

CREATE TABLE `PagePermissionPropertyAttributeAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `akID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`akID`),
  KEY `peID` (`peID`),
  KEY `akID` (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `PagePermissionThemeAccessList`
--

CREATE TABLE `PagePermissionThemeAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`),
  KEY `peID` (`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `PagePermissionThemeAccessListCustom`
--

CREATE TABLE `PagePermissionThemeAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `pThemeID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`pThemeID`),
  KEY `peID` (`peID`),
  KEY `pThemeID` (`pThemeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `Pages`
--

CREATE TABLE `Pages` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `siteTreeID` int(10) unsigned DEFAULT '0',
  `ptID` int(10) unsigned NOT NULL DEFAULT '0',
  `cIsTemplate` tinyint(1) NOT NULL DEFAULT '0',
  `uID` int(10) unsigned DEFAULT NULL,
  `cIsCheckedOut` tinyint(1) NOT NULL DEFAULT '0',
  `cCheckedOutUID` int(10) unsigned DEFAULT NULL,
  `cCheckedOutDatetime` datetime DEFAULT NULL,
  `cCheckedOutDatetimeLastEdit` datetime DEFAULT NULL,
  `cOverrideTemplatePermissions` tinyint(1) NOT NULL DEFAULT '1',
  `cInheritPermissionsFromCID` int(10) unsigned NOT NULL DEFAULT '0',
  `cInheritPermissionsFrom` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'PARENT',
  `cFilename` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cPointerID` int(10) unsigned NOT NULL DEFAULT '0',
  `cPointerExternalLink` longtext COLLATE utf8mb4_unicode_ci,
  `cPointerExternalLinkNewWindow` tinyint(1) NOT NULL DEFAULT '0',
  `cIsActive` tinyint(1) NOT NULL DEFAULT '1',
  `cChildren` int(10) unsigned NOT NULL DEFAULT '0',
  `cDisplayOrder` int(10) unsigned NOT NULL DEFAULT '0',
  `cParentID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  `cDraftTargetParentPageID` int(10) unsigned NOT NULL DEFAULT '0',
  `cIsDraft` tinyint(1) NOT NULL DEFAULT '0',
  `cCacheFullPageContent` smallint(6) NOT NULL DEFAULT '-1',
  `cCacheFullPageContentOverrideLifetime` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `cCacheFullPageContentLifetimeCustom` int(10) unsigned NOT NULL DEFAULT '0',
  `cIsSystemPage` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`ptID`),
  KEY `cParentID` (`cParentID`),
  KEY `siteTreeID` (`siteTreeID`),
  KEY `cIsActive` (`cID`,`cIsActive`),
  KEY `cCheckedOutUID` (`cCheckedOutUID`),
  KEY `uID` (`uID`,`cPointerID`),
  KEY `cPointerID` (`cPointerID`,`cDisplayOrder`),
  KEY `cIsTemplate` (`cID`,`cIsTemplate`),
  KEY `cIsSystemPage` (`cID`,`cIsSystemPage`),
  KEY `pkgID` (`pkgID`),
  KEY `cParentMaxDisplay` (`cParentID`,`cDisplayOrder`),
  KEY `idxPageList` (`cIsTemplate`,`cIsActive`,`siteTreeID`,`cIsSystemPage`,`cPointerID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `Pages`
--

INSERT INTO `Pages` VALUES
(1, 1, 6, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'OVERRIDE', NULL, 0, NULL, 0, 1, 12, 0, 0, 0, 0, 0, -1, '0', 0, 0),
(2, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'OVERRIDE', '/dashboard/view.php', 0, NULL, 0, 1, 13, 0, 0, 0, 0, 0, -1, '0', 0, 1),
(3, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/sitemap/view.php', 0, NULL, 0, 1, 3, 1, 2, 0, 0, 0, -1, '0', 0, 1),
(4, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/sitemap/full.php', 0, NULL, 0, 1, 0, 0, 3, 0, 0, 0, -1, '0', 0, 1),
(5, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/sitemap/explore.php', 0, NULL, 0, 1, 0, 1, 3, 0, 0, 0, -1, '0', 0, 1),
(6, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/sitemap/search.php', 0, NULL, 0, 1, 0, 2, 3, 0, 0, 0, -1, '0', 0, 1),
(7, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/files/view.php', 0, NULL, 0, 1, 5, 2, 2, 0, 0, 0, -1, '0', 0, 1),
(8, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/files/search.php', 0, NULL, 0, 1, 0, 0, 7, 0, 0, 0, -1, '0', 0, 1),
(9, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/files/details.php', 0, NULL, 0, 1, 0, 1, 7, 0, 0, 0, -1, '0', 0, 1),
(10, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/files/attributes.php', 0, NULL, 0, 1, 0, 2, 7, 0, 0, 0, -1, '0', 0, 1),
(11, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/files/sets.php', 0, NULL, 0, 1, 0, 3, 7, 0, 0, 0, -1, '0', 0, 1),
(12, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/files/add_set.php', 0, NULL, 0, 1, 0, 4, 7, 0, 0, 0, -1, '0', 0, 1),
(13, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/users/view.php', 0, NULL, 0, 1, 7, 3, 2, 0, 0, 0, -1, '0', 0, 1),
(14, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/users/search.php', 0, NULL, 0, 1, 0, 0, 13, 0, 0, 0, -1, '0', 0, 1),
(15, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/users/groups.php', 0, NULL, 0, 1, 3, 1, 13, 0, 0, 0, -1, '0', 0, 1),
(16, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/users/group_types.php', 0, NULL, 0, 1, 0, 2, 13, 0, 0, 0, -1, '0', 0, 1),
(17, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/users/groups/message.php', 0, NULL, 0, 1, 0, 0, 15, 0, 0, 0, -1, '0', 0, 1),
(18, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/users/attributes.php', 0, NULL, 0, 1, 0, 3, 13, 0, 0, 0, -1, '0', 0, 1),
(19, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/users/add.php', 0, NULL, 0, 1, 0, 4, 13, 0, 0, 0, -1, '0', 0, 1),
(20, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/users/add_group.php', 0, NULL, 0, 1, 0, 5, 13, 0, 0, 0, -1, '0', 0, 1),
(21, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/users/groups/bulkupdate.php', 0, NULL, 0, 1, 0, 1, 15, 0, 0, 0, -1, '0', 0, 1),
(22, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/users/groups/bulk_user_assignment.php', 0, NULL, 0, 1, 0, 2, 15, 0, 0, 0, -1, '0', 0, 1),
(23, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/users/group_sets.php', 0, NULL, 0, 1, 0, 6, 13, 0, 0, 0, -1, '0', 0, 1),
(24, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/express/view.php', 0, NULL, 0, 1, 1, 4, 2, 0, 0, 0, -1, '0', 0, 1),
(25, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/express/entries.php', 0, NULL, 0, 1, 0, 0, 24, 0, 0, 0, -1, '0', 0, 1),
(26, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/boards.php', 0, NULL, 0, 1, 11, 5, 2, 0, 0, 0, -1, '0', 0, 1),
(27, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/boards/boards.php', 0, NULL, 0, 1, 0, 0, 26, 0, 0, 0, -1, '0', 0, 1),
(28, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/boards/add.php', 0, NULL, 0, 1, 0, 1, 26, 0, 0, 0, -1, '0', 0, 1),
(29, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/boards/details.php', 0, NULL, 0, 1, 0, 2, 26, 0, 0, 0, -1, '0', 0, 1),
(30, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/boards/edit.php', 0, NULL, 0, 1, 0, 3, 26, 0, 0, 0, -1, '0', 0, 1),
(31, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/boards/data_sources.php', 0, NULL, 0, 1, 0, 4, 26, 0, 0, 0, -1, '0', 0, 1),
(32, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/boards/appearance.php', 0, NULL, 0, 1, 0, 5, 26, 0, 0, 0, -1, '0', 0, 1),
(33, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/boards/weighting.php', 0, NULL, 0, 1, 0, 6, 26, 0, 0, 0, -1, '0', 0, 1),
(34, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/boards/permissions.php', 0, NULL, 0, 1, 0, 7, 26, 0, 0, 0, -1, '0', 0, 1),
(35, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/boards/instances.php', 0, NULL, 0, 1, 2, 8, 26, 0, 0, 0, -1, '0', 0, 1),
(36, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/boards/instances/details.php', 0, NULL, 0, 1, 0, 0, 35, 0, 0, 0, -1, '0', 0, 1),
(37, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/boards/instances/rules.php', 0, NULL, 0, 1, 0, 1, 35, 0, 0, 0, -1, '0', 0, 1),
(38, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/boards/designer.php', 0, NULL, 0, 1, 2, 9, 26, 0, 0, 0, -1, '0', 0, 1),
(39, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/boards/designer/choose_items.php', 0, NULL, 0, 1, 0, 0, 38, 0, 0, 0, -1, '0', 0, 1),
(40, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/boards/designer/customize_slot.php', 0, NULL, 0, 1, 0, 1, 38, 0, 0, 0, -1, '0', 0, 1),
(41, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/boards/scheduler.php', 0, NULL, 0, 1, 0, 10, 26, 0, 0, 0, -1, '0', 0, 1),
(42, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/reports.php', 0, NULL, 0, 1, 5, 6, 2, 0, 0, 0, -1, '0', 0, 1),
(43, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/reports/forms.php', 0, NULL, 0, 1, 1, 0, 42, 0, 0, 0, -1, '0', 0, 1),
(44, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/reports/forms/legacy.php', 0, NULL, 0, 1, 0, 0, 43, 0, 0, 0, -1, '0', 0, 1),
(45, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/reports/health.php', 0, NULL, 0, 1, 1, 1, 42, 0, 0, 0, -1, '0', 0, 1),
(46, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/reports/health/details.php', 0, NULL, 0, 1, 0, 0, 45, 0, 0, 0, -1, '0', 0, 1),
(47, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/reports/surveys.php', 0, NULL, 0, 1, 0, 2, 42, 0, 0, 0, -1, '0', 0, 1),
(48, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/reports/logs.php', 0, NULL, 0, 1, 0, 3, 42, 0, 0, 0, -1, '0', 0, 1),
(49, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/reports/page_changes.php', 0, NULL, 0, 1, 0, 4, 42, 0, 0, 0, -1, '0', 0, 1),
(50, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/view.php', 0, NULL, 0, 1, 7, 7, 2, 0, 0, 0, -1, '0', 0, 1),
(51, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/themes/view.php', 0, NULL, 0, 1, 1, 0, 50, 0, 0, 0, -1, '0', 0, 1),
(52, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/themes/inspect.php', 0, NULL, 0, 1, 0, 0, 51, 0, 0, 0, -1, '0', 0, 1),
(53, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/types/view.php', 0, NULL, 0, 1, 6, 1, 50, 0, 0, 0, -1, '0', 0, 1),
(54, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/types/organize.php', 0, NULL, 0, 1, 0, 0, 53, 0, 0, 0, -1, '0', 0, 1),
(55, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/types/add.php', 0, NULL, 0, 1, 0, 1, 53, 0, 0, 0, -1, '0', 0, 1),
(56, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/types/form.php', 0, NULL, 0, 1, 0, 2, 53, 0, 0, 0, -1, '0', 0, 1),
(57, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/types/output.php', 0, NULL, 0, 1, 0, 3, 53, 0, 0, 0, -1, '0', 0, 1),
(58, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/types/attributes.php', 0, NULL, 0, 1, 0, 4, 53, 0, 0, 0, -1, '0', 0, 1),
(59, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/types/permissions.php', 0, NULL, 0, 1, 0, 5, 53, 0, 0, 0, -1, '0', 0, 1),
(60, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/templates/view.php', 0, NULL, 0, 1, 1, 2, 50, 0, 0, 0, -1, '0', 0, 1),
(61, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/templates/add.php', 0, NULL, 0, 1, 0, 0, 60, 0, 0, 0, -1, '0', 0, 1),
(62, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/containers/view.php', 0, NULL, 0, 1, 1, 3, 50, 0, 0, 0, -1, '0', 0, 1),
(63, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/containers/add.php', 0, NULL, 0, 1, 0, 0, 62, 0, 0, 0, -1, '0', 0, 1),
(64, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/attributes.php', 0, NULL, 0, 1, 0, 4, 50, 0, 0, 0, -1, '0', 0, 1),
(65, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/single.php', 0, NULL, 0, 1, 0, 5, 50, 0, 0, 0, -1, '0', 0, 1),
(66, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/feeds.php', 0, NULL, 0, 1, 0, 6, 50, 0, 0, 0, -1, '0', 0, 1),
(67, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/calendar/view.php', 0, NULL, 0, 1, 5, 8, 2, 0, 0, 0, -1, '0', 0, 1),
(68, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/calendar/events.php', 0, NULL, 0, 1, 0, 0, 67, 0, 0, 0, -1, '0', 0, 1),
(69, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/calendar/event_list.php', 0, NULL, 0, 1, 0, 1, 67, 0, 0, 0, -1, '0', 0, 1),
(70, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/calendar/add.php', 0, NULL, 0, 1, 0, 2, 67, 0, 0, 0, -1, '0', 0, 1),
(71, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/calendar/permissions.php', 0, NULL, 0, 1, 0, 3, 67, 0, 0, 0, -1, '0', 0, 1),
(72, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/calendar/attributes.php', 0, NULL, 0, 1, 0, 4, 67, 0, 0, 0, -1, '0', 0, 1),
(73, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/conversations/view.php', 0, NULL, 0, 1, 1, 9, 2, 0, 0, 0, -1, '0', 0, 1),
(74, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/conversations/messages.php', 0, NULL, 0, 1, 0, 0, 73, 0, 0, 0, -1, '0', 0, 1),
(75, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/blocks/view.php', 0, NULL, 0, 1, 3, 10, 2, 0, 0, 0, -1, '0', 0, 1),
(76, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/blocks/stacks/view.php', 0, NULL, 0, 1, 1, 0, 75, 0, 0, 0, -1, '0', 0, 1),
(77, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/blocks/permissions.php', 0, NULL, 0, 1, 0, 1, 75, 0, 0, 0, -1, '0', 0, 1),
(78, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/blocks/stacks/list/view.php', 0, NULL, 0, 1, 0, 0, 76, 0, 0, 0, -1, '0', 0, 1),
(79, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/blocks/types/view.php', 0, NULL, 0, 1, 0, 2, 75, 0, 0, 0, -1, '0', 0, 1),
(80, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/extend/view.php', 0, NULL, 0, 1, 4, 11, 2, 0, 0, 0, -1, '0', 0, 1),
(81, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/extend/install.php', 0, NULL, 0, 1, 0, 0, 80, 0, 0, 0, -1, '0', 0, 1),
(82, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/extend/update.php', 0, NULL, 0, 1, 0, 1, 80, 0, 0, 0, -1, '0', 0, 1),
(83, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/extend/themes.php', 0, NULL, 0, 1, 0, 2, 80, 0, 0, 0, -1, '0', 0, 1),
(84, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/extend/addons.php', 0, NULL, 0, 1, 0, 3, 80, 0, 0, 0, -1, '0', 0, 1),
(85, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/view.php', 0, NULL, 0, 1, 20, 12, 2, 0, 0, 0, -1, '0', 0, 1),
(86, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/view.php', 0, NULL, 0, 1, 11, 0, 85, 0, 0, 0, -1, '0', 0, 1),
(87, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/name.php', 0, NULL, 0, 1, 0, 0, 86, 0, 0, 0, -1, '0', 0, 1),
(88, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/marketplace.php', 0, NULL, 0, 1, 0, 1, 86, 0, 0, 0, -1, '0', 0, 1),
(89, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/production_mode.php', 0, NULL, 0, 1, 0, 2, 86, 0, 0, 0, -1, '0', 0, 1),
(90, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/appearance.php', 0, NULL, 0, 1, 0, 3, 86, 0, 0, 0, -1, '0', 0, 1),
(91, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/site_information.php', 0, NULL, 0, 1, 0, 4, 86, 0, 0, 0, -1, '0', 0, 1),
(92, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/icons.php', 0, NULL, 0, 1, 0, 5, 86, 0, 0, 0, -1, '0', 0, 1),
(93, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/editor.php', 0, NULL, 0, 1, 0, 6, 86, 0, 0, 0, -1, '0', 0, 1),
(94, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/multilingual/view.php', 0, NULL, 0, 1, 1, 7, 86, 0, 0, 0, -1, '0', 0, 1),
(95, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/multilingual/update.php', 0, NULL, 0, 1, 0, 0, 94, 0, 0, 0, -1, '0', 0, 1),
(96, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/timezone.php', 0, NULL, 0, 1, 0, 8, 86, 0, 0, 0, -1, '0', 0, 1),
(97, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/attributes.php', 0, NULL, 0, 1, 0, 9, 86, 0, 0, 0, -1, '0', 0, 1),
(98, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/reset_edit_mode.php', 0, NULL, 0, 1, 0, 10, 86, 0, 0, 0, -1, '0', 0, 1),
(99, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/social/view.php', 0, NULL, 0, 1, 2, 1, 85, 0, 0, 0, -1, '0', 0, 1),
(100, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/social/social_links.php', 0, NULL, 0, 1, 0, 0, 99, 0, 0, 0, -1, '0', 0, 1),
(101, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/social/opengraph.php', 0, NULL, 0, 1, 0, 1, 99, 0, 0, 0, -1, '0', 0, 1),
(102, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/express/view.php', 0, NULL, 0, 1, 2, 2, 85, 0, 0, 0, -1, '0', 0, 1),
(103, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/express/entities.php', 0, NULL, 0, 1, 5, 0, 102, 0, 0, 0, -1, '0', 0, 1),
(104, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/express/entities/attributes.php', 0, NULL, 0, 1, 0, 0, 103, 0, 0, 0, -1, '0', 0, 1),
(105, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/express/entities/associations.php', 0, NULL, 0, 1, 0, 1, 103, 0, 0, 0, -1, '0', 0, 1),
(106, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/express/entities/forms.php', 0, NULL, 0, 1, 0, 2, 103, 0, 0, 0, -1, '0', 0, 1),
(107, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/express/entities/customize_search.php', 0, NULL, 0, 1, 0, 3, 103, 0, 0, 0, -1, '0', 0, 1),
(108, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/express/entities/order_entries.php', 0, NULL, 0, 1, 0, 4, 103, 0, 0, 0, -1, '0', 0, 1),
(109, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/express/entries.php', 0, NULL, 0, 1, 0, 1, 102, 0, 0, 0, -1, '0', 0, 1),
(110, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/multisite/view.php', 0, NULL, 0, 1, 3, 3, 85, 0, 0, 0, -1, '0', 0, 1),
(111, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/multisite/sites/view.php', 0, NULL, 0, 1, 0, 0, 110, 0, 0, 0, -1, '0', 0, 1),
(112, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/multisite/types/view.php', 0, NULL, 0, 1, 0, 1, 110, 0, 0, 0, -1, '0', 0, 1),
(113, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/multisite/settings.php', 0, NULL, 0, 1, 0, 2, 110, 0, 0, 0, -1, '0', 0, 1),
(114, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/multilingual/view.php', 0, NULL, 0, 1, 4, 4, 85, 0, 0, 0, -1, '0', 0, 1),
(115, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/multilingual/setup.php', 0, NULL, 0, 1, 0, 0, 114, 0, 0, 0, -1, '0', 0, 1),
(116, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/multilingual/copy.php', 0, NULL, 0, 1, 0, 1, 114, 0, 0, 0, -1, '0', 0, 1),
(117, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/multilingual/page_report.php', 0, NULL, 0, 1, 0, 2, 114, 0, 0, 0, -1, '0', 0, 1),
(118, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/multilingual/translate_interface.php', 0, NULL, 0, 1, 0, 3, 114, 0, 0, 0, -1, '0', 0, 1),
(119, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/seo/view.php', 0, NULL, 0, 1, 6, 5, 85, 0, 0, 0, -1, '0', 0, 1),
(120, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/seo/urls.php', 0, NULL, 0, 1, 0, 0, 119, 0, 0, 0, -1, '0', 0, 1),
(121, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/seo/bulk.php', 0, NULL, 0, 1, 0, 1, 119, 0, 0, 0, -1, '0', 0, 1),
(122, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/seo/codes.php', 0, NULL, 0, 1, 0, 2, 119, 0, 0, 0, -1, '0', 0, 1),
(123, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/seo/excluded.php', 0, NULL, 0, 1, 0, 3, 119, 0, 0, 0, -1, '0', 0, 1),
(124, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/seo/searchindex.php', 0, NULL, 0, 1, 0, 4, 119, 0, 0, 0, -1, '0', 0, 1),
(125, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/seo/url_slug.php', 0, NULL, 0, 1, 0, 5, 119, 0, 0, 0, -1, '0', 0, 1),
(126, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/files/view.php', 0, NULL, 0, 1, 10, 6, 85, 0, 0, 0, -1, '0', 0, 1),
(127, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/files/filetypes.php', 0, NULL, 0, 1, 0, 0, 126, 0, 0, 0, -1, '0', 0, 1),
(128, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/files/file_chooser.php', 0, NULL, 0, 1, 0, 1, 126, 0, 0, 0, -1, '0', 0, 1),
(129, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/files/permissions.php', 0, NULL, 0, 1, 0, 2, 126, 0, 0, 0, -1, '0', 0, 1),
(130, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/files/thumbnails.php', 0, NULL, 0, 1, 1, 3, 126, 0, 0, 0, -1, '0', 0, 1),
(131, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/files/thumbnails/options.php', 0, NULL, 0, 1, 0, 0, 130, 0, 0, 0, -1, '0', 0, 1),
(132, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/files/image_uploading.php', 0, NULL, 0, 1, 0, 4, 126, 0, 0, 0, -1, '0', 0, 1),
(133, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/files/image_editor.php', 0, NULL, 0, 1, 0, 5, 126, 0, 0, 0, -1, '0', 0, 1),
(134, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/files/storage.php', 0, NULL, 0, 1, 0, 6, 126, 0, 0, 0, -1, '0', 0, 1),
(135, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/files/external_file_provider.php', 0, NULL, 0, 1, 0, 7, 126, 0, 0, 0, -1, '0', 0, 1),
(136, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/files/export_options.php', 0, NULL, 0, 1, 0, 8, 126, 0, 0, 0, -1, '0', 0, 1),
(137, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/files/uploads.php', 0, NULL, 0, 1, 0, 9, 126, 0, 0, 0, -1, '0', 0, 1),
(138, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/automation/view.php', 0, NULL, 0, 1, 5, 7, 85, 0, 0, 0, -1, '0', 0, 1),
(139, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/automation/tasks.php', 0, NULL, 0, 1, 0, 0, 138, 0, 0, 0, -1, '0', 0, 1),
(140, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/automation/activity.php', 0, NULL, 0, 1, 0, 1, 138, 0, 0, 0, -1, '0', 0, 1),
(141, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/automation/failed.php', 0, NULL, 0, 1, 0, 2, 138, 0, 0, 0, -1, '0', 0, 1),
(142, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/automation/schedule.php', 0, NULL, 0, 1, 0, 3, 138, 0, 0, 0, -1, '0', 0, 1),
(143, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/automation/settings.php', 0, NULL, 0, 1, 0, 4, 138, 0, 0, 0, -1, '0', 0, 1),
(144, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/notification/view.php', 0, NULL, 0, 1, 2, 8, 85, 0, 0, 0, -1, '0', 0, 1),
(145, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/notification/events.php', 0, NULL, 0, 1, 0, 0, 144, 0, 0, 0, -1, '0', 0, 1),
(146, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/notification/alerts.php', 0, NULL, 0, 1, 0, 1, 144, 0, 0, 0, -1, '0', 0, 1),
(147, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/optimization/view.php', 0, NULL, 0, 1, 3, 9, 85, 0, 0, 0, -1, '0', 0, 1),
(148, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/optimization/cache.php', 0, NULL, 0, 1, 0, 0, 147, 0, 0, 0, -1, '0', 0, 1),
(149, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/optimization/clearcache.php', 0, NULL, 0, 1, 0, 1, 147, 0, 0, 0, -1, '0', 0, 1),
(150, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/optimization/jobs.php', 0, NULL, 0, 1, 0, 2, 147, 0, 0, 0, -1, '0', 0, 1),
(151, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/view.php', 0, NULL, 0, 1, 10, 10, 85, 0, 0, 0, -1, '0', 0, 1),
(152, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/site.php', 0, NULL, 0, 1, 0, 0, 151, 0, 0, 0, -1, '0', 0, 1),
(153, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/tasks.php', 0, NULL, 0, 1, 0, 1, 151, 0, 0, 0, -1, '0', 0, 1),
(154, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/users.php', 0, NULL, 0, 1, 0, 2, 151, 0, 0, 0, -1, '0', 0, 1),
(155, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/advanced.php', 0, NULL, 0, 1, 0, 3, 151, 0, 0, 0, -1, '0', 0, 1),
(156, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/workflows.php', 0, NULL, 0, 1, 0, 4, 151, 0, 0, 0, -1, '0', 0, 1),
(157, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/denylist.php', 0, NULL, 0, 1, 2, 5, 151, 0, 0, 0, -1, '0', 0, 1),
(158, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/denylist/configure.php', 0, NULL, 0, 1, 0, 0, 157, 0, 0, 0, -1, '0', 0, 1),
(159, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/denylist/range.php', 0, NULL, 0, 1, 0, 1, 157, 0, 0, 0, -1, '0', 0, 1),
(160, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/captcha.php', 0, NULL, 0, 1, 0, 6, 151, 0, 0, 0, -1, '0', 0, 1),
(161, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/antispam.php', 0, NULL, 0, 1, 0, 7, 151, 0, 0, 0, -1, '0', 0, 1),
(162, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/maintenance.php', 0, NULL, 0, 1, 0, 8, 151, 0, 0, 0, -1, '0', 0, 1),
(163, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/trusted_proxies.php', 0, NULL, 0, 1, 0, 9, 151, 0, 0, 0, -1, '0', 0, 1),
(164, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/registration/view.php', 0, NULL, 0, 1, 9, 11, 85, 0, 0, 0, -1, '0', 0, 1),
(165, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/registration/open.php', 0, NULL, 0, 1, 0, 0, 164, 0, 0, 0, -1, '0', 0, 1),
(166, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/registration/postlogin.php', 0, NULL, 0, 1, 0, 1, 164, 0, 0, 0, -1, '0', 0, 1),
(167, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/registration/profiles.php', 0, NULL, 0, 1, 0, 2, 164, 0, 0, 0, -1, '0', 0, 1),
(168, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/registration/authentication.php', 0, NULL, 0, 1, 0, 3, 164, 0, 0, 0, -1, '0', 0, 1),
(169, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/registration/global_password_reset.php', 0, NULL, 0, 1, 0, 4, 164, 0, 0, 0, -1, '0', 0, 1),
(170, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/registration/deactivation.php', 0, NULL, 0, 1, 0, 5, 164, 0, 0, 0, -1, '0', 0, 1),
(171, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/registration/automated_logout.php', 0, NULL, 0, 1, 0, 6, 164, 0, 0, 0, -1, '0', 0, 1),
(172, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/registration/password_requirements.php', 0, NULL, 0, 1, 0, 7, 164, 0, 0, 0, -1, '0', 0, 1),
(173, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/registration/session_options.php', 0, NULL, 0, 1, 0, 8, 164, 0, 0, 0, -1, '0', 0, 1),
(174, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/mail/view.php', 0, NULL, 0, 1, 4, 12, 85, 0, 0, 0, -1, '0', 0, 1),
(175, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/mail/method.php', 0, NULL, 0, 1, 1, 0, 174, 0, 0, 0, -1, '0', 0, 1),
(176, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/mail/method/test.php', 0, NULL, 0, 1, 0, 0, 175, 0, 0, 0, -1, '0', 0, 1),
(177, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/mail/importers.php', 0, NULL, 0, 1, 0, 1, 174, 0, 0, 0, -1, '0', 0, 1),
(178, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/mail/addresses.php', 0, NULL, 0, 1, 0, 2, 174, 0, 0, 0, -1, '0', 0, 1),
(179, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/mail/logging.php', 0, NULL, 0, 1, 0, 3, 174, 0, 0, 0, -1, '0', 0, 1),
(180, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/calendar/view.php', 0, NULL, 0, 1, 4, 13, 85, 0, 0, 0, -1, '0', 0, 1),
(181, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/calendar/settings.php', 0, NULL, 0, 1, 0, 0, 180, 0, 0, 0, -1, '0', 0, 1),
(182, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/calendar/colors.php', 0, NULL, 0, 1, 0, 1, 180, 0, 0, 0, -1, '0', 0, 1),
(183, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/calendar/permissions.php', 0, NULL, 0, 1, 0, 2, 180, 0, 0, 0, -1, '0', 0, 1),
(184, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/calendar/import.php', 0, NULL, 0, 1, 0, 3, 180, 0, 0, 0, -1, '0', 0, 1),
(185, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/boards/view.php', 0, NULL, 0, 1, 3, 14, 85, 0, 0, 0, -1, '0', 0, 1),
(186, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/boards/settings.php', 0, NULL, 0, 1, 0, 0, 185, 0, 0, 0, -1, '0', 0, 1),
(187, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/boards/permissions.php', 0, NULL, 0, 1, 0, 1, 185, 0, 0, 0, -1, '0', 0, 1),
(188, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/boards/summary_templates.php', 0, NULL, 0, 1, 0, 2, 185, 0, 0, 0, -1, '0', 0, 1),
(189, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/conversations/view.php', 0, NULL, 0, 1, 4, 15, 85, 0, 0, 0, -1, '0', 0, 1),
(190, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/conversations/settings.php', 0, NULL, 0, 1, 0, 0, 189, 0, 0, 0, -1, '0', 0, 1),
(191, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/conversations/points.php', 0, NULL, 0, 1, 0, 1, 189, 0, 0, 0, -1, '0', 0, 1),
(192, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/conversations/bannedwords.php', 0, NULL, 0, 1, 0, 2, 189, 0, 0, 0, -1, '0', 0, 1),
(193, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/conversations/permissions.php', 0, NULL, 0, 1, 0, 3, 189, 0, 0, 0, -1, '0', 0, 1),
(194, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/attributes/view.php', 0, NULL, 0, 1, 3, 16, 85, 0, 0, 0, -1, '0', 0, 1),
(195, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/attributes/types.php', 0, NULL, 0, 1, 0, 0, 194, 0, 0, 0, -1, '0', 0, 1),
(196, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/attributes/sets.php', 0, NULL, 0, 1, 0, 1, 194, 0, 0, 0, -1, '0', 0, 1),
(197, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/attributes/topics/view.php', 0, NULL, 0, 1, 1, 2, 194, 0, 0, 0, -1, '0', 0, 1),
(198, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/attributes/topics/add.php', 0, NULL, 0, 1, 0, 0, 197, 0, 0, 0, -1, '0', 0, 1),
(199, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/environment/view.php', 0, NULL, 0, 1, 8, 17, 85, 0, 0, 0, -1, '0', 0, 1),
(200, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/environment/info.php', 0, NULL, 0, 1, 0, 0, 199, 0, 0, 0, -1, '0', 0, 1),
(201, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/environment/errors.php', 0, NULL, 0, 1, 0, 1, 199, 0, 0, 0, -1, '0', 0, 1),
(202, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/environment/logging.php', 0, NULL, 0, 1, 0, 2, 199, 0, 0, 0, -1, '0', 0, 1),
(203, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/environment/proxy.php', 0, NULL, 0, 1, 0, 3, 199, 0, 0, 0, -1, '0', 0, 1),
(204, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/environment/entities.php', 0, NULL, 0, 1, 0, 4, 199, 0, 0, 0, -1, '0', 0, 1),
(205, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/environment/database_charset.php', 0, NULL, 0, 1, 0, 5, 199, 0, 0, 0, -1, '0', 0, 1),
(206, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/environment/geolocation.php', 0, NULL, 0, 1, 0, 6, 199, 0, 0, 0, -1, '0', 0, 1),
(207, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/environment/security.php', 0, NULL, 0, 1, 0, 7, 199, 0, 0, 0, -1, '0', 0, 1),
(208, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/update/view.php', 0, NULL, 0, 1, 1, 18, 85, 0, 0, 0, -1, '0', 0, 1),
(209, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/update/update.php', 0, NULL, 0, 1, 0, 0, 208, 0, 0, 0, -1, '0', 0, 1),
(210, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/api/view.php', 0, NULL, 0, 1, 3, 19, 85, 0, 0, 0, -1, '0', 0, 1),
(211, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/api/integrations.php', 0, NULL, 0, 1, 0, 0, 210, 0, 0, 0, -1, '0', 0, 1),
(212, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/api/scopes.php', 0, NULL, 0, 1, 0, 1, 210, 0, 0, 0, -1, '0', 0, 1),
(213, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/api/settings.php', 0, NULL, 0, 1, 0, 2, 210, 0, 0, 0, -1, '0', 0, 1),
(214, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/welcome.php', 0, NULL, 0, 1, 2, 0, 2, 0, 0, 0, -1, '0', 0, 1),
(215, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/welcome/health.php', 0, NULL, 0, 1, 0, 0, 214, 0, 0, 0, -1, '0', 0, 1),
(216, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', NULL, 0, NULL, 0, 1, 0, 1, 214, 0, 0, 0, -1, '0', 0, 1),
(217, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', '/!themes/view.php', 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 1),
(218, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', '/!stacks/view.php', 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 1),
(219, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 219, 'OVERRIDE', '/page_not_found.php', 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 1),
(220, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', '/!trash/view.php', 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 1),
(221, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 221, 'OVERRIDE', '/login.php', 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 1),
(222, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 222, 'OVERRIDE', '/register.php', 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 1),
(223, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', '/account/view.php', 0, NULL, 0, 1, 3, 0, 0, 0, 0, 0, -1, '0', 0, 1),
(224, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', '/account/edit_profile.php', 0, NULL, 0, 1, 0, 0, 223, 0, 0, 0, -1, '0', 0, 1),
(225, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', '/account/avatar.php', 0, NULL, 0, 1, 0, 1, 223, 0, 0, 0, -1, '0', 0, 1),
(226, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', '/account/messages.php', 0, NULL, 0, 1, 0, 2, 223, 0, 0, 0, -1, '0', 0, 1),
(227, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 227, 'OVERRIDE', '/page_forbidden.php', 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 1),
(228, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', '/download_file.php', 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 1),
(229, 1, 0, 0, 1, 0, NULL, NULL, NULL, 1, 229, 'OVERRIDE', '/!drafts/view.php', 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 1),
(230, 1, 0, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', '/desktop.php', 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 1),
(231, 1, 6, 1, NULL, 0, NULL, NULL, NULL, 1, 231, 'OVERRIDE', NULL, 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `PageSearchIndex`
--

CREATE TABLE `PageSearchIndex` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `cName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cDescription` text COLLATE utf8mb4_unicode_ci,
  `cPath` text COLLATE utf8mb4_unicode_ci,
  `cDatePublic` datetime DEFAULT NULL,
  `cDateLastIndexed` datetime DEFAULT NULL,
  `cDateLastSitemapped` datetime DEFAULT NULL,
  `cRequiresReindex` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`cID`),
  KEY `cDateLastIndexed` (`cDateLastIndexed`),
  KEY `cDateLastSitemapped` (`cDateLastSitemapped`),
  KEY `cRequiresReindex` (`cRequiresReindex`),
  FULLTEXT KEY `cName` (`cName`),
  FULLTEXT KEY `cDescription` (`cDescription`),
  FULLTEXT KEY `content` (`content`),
  FULLTEXT KEY `content2` (`cName`,`cDescription`,`content`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `PageSearchIndex`
--

INSERT INTO `PageSearchIndex` VALUES
(1, '', 'Home', '', NULL, '[[date_gmt]]', '[[date_gmt]]', NULL, 0),
(216, '', 'Waiting for Me', '', '/dashboard/welcome/me', '[[date_gmt]]', '[[date_gmt]]', NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `PageSummaryTemplateCustomCollection`
--

CREATE TABLE `PageSummaryTemplateCustomCollection` (
  `cID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`cID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `PageSummaryTemplateCustomCollectionTemplates`
--

CREATE TABLE `PageSummaryTemplateCustomCollectionTemplates` (
  `template_id` int(11) NOT NULL,
  `cID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`cID`,`template_id`),
  KEY `IDX_23B91C0FE5DADDAE` (`cID`),
  KEY `IDX_23B91C0F5DA0FB8` (`template_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `PageSummaryTemplates`
--

CREATE TABLE `PageSummaryTemplates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template_id` int(11) DEFAULT NULL,
  `cID` int(10) unsigned NOT NULL,
  `data` json NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_55AC200B5DA0FB8` (`template_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `PageSummaryTemplates`
--

INSERT INTO `PageSummaryTemplates` VALUES
(1, 1, 1, '{"fields": {"date": {"class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\DatetimeDataFieldData", "timezone": "America/New_York", "timestamp": "[[timestamp]]"}, "link": {"class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\LazyPageLinkDataFieldData"}, "title": {"data": "Home", "class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\DataFieldData"}, "author": {"class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\AuthorDataFieldData", "author": {"id": 1, "name": "admin"}}}}'),
(2, 2, 1, '{"fields": {"date": {"class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\DatetimeDataFieldData", "timezone": "America/New_York", "timestamp": "[[timestamp]]"}, "link": {"class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\LazyPageLinkDataFieldData"}, "title": {"data": "Home", "class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\DataFieldData"}, "author": {"class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\AuthorDataFieldData", "author": {"id": 1, "name": "admin"}}}}'),
(3, 3, 1, '{"fields": {"date": {"class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\DatetimeDataFieldData", "timezone": "America/New_York", "timestamp": "[[timestamp]]"}, "link": {"class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\LazyPageLinkDataFieldData"}, "title": {"data": "Home", "class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\DataFieldData"}, "author": {"class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\AuthorDataFieldData", "author": {"id": 1, "name": "admin"}}}}'),
(4, 4, 1, '{"fields": {"date": {"class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\DatetimeDataFieldData", "timezone": "America/New_York", "timestamp": "[[timestamp]]"}, "link": {"class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\LazyPageLinkDataFieldData"}, "title": {"data": "Home", "class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\DataFieldData"}, "author": {"class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\AuthorDataFieldData", "author": {"id": 1, "name": "admin"}}}}'),
(5, 5, 1, '{"fields": {"date": {"class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\DatetimeDataFieldData", "timezone": "America/New_York", "timestamp": "[[timestamp]]"}, "link": {"class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\LazyPageLinkDataFieldData"}, "title": {"data": "Home", "class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\DataFieldData"}, "author": {"class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\AuthorDataFieldData", "author": {"id": 1, "name": "admin"}}}}'),
(6, 6, 1, '{"fields": {"date": {"class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\DatetimeDataFieldData", "timezone": "America/New_York", "timestamp": "[[timestamp]]"}, "link": {"class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\LazyPageLinkDataFieldData"}, "title": {"data": "Home", "class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\DataFieldData"}, "author": {"class": "Concrete\\\\Core\\\\Summary\\\\Data\\\\Field\\\\AuthorDataFieldData", "author": {"id": 1, "name": "admin"}}}}');

-- --------------------------------------------------------

--
-- Table structure for table `PageTemplates`
--

CREATE TABLE `PageTemplates` (
  `pTemplateID` int(11) NOT NULL AUTO_INCREMENT,
  `pTemplateHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pTemplateIcon` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pTemplateName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pTemplateIsInternal` tinyint(1) NOT NULL,
  `pkgID` int(11) NOT NULL,
  PRIMARY KEY (`pTemplateID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `PageTemplates`
--

INSERT INTO `PageTemplates` VALUES
(1, 'core_stack', '', 'Stack', 1, 0),
(2, 'core_theme_documentation', '', 'Theme Documentation', 1, 0),
(3, 'desktop', '', 'Desktop', 1, 0),
(4, 'full', 'full.png', 'Full', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `PageThemeCustomSkins`
--

CREATE TABLE `PageThemeCustomSkins` (
  `skinID` int(11) NOT NULL AUTO_INCREMENT,
  `skinIdentifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pThemeID` int(10) unsigned NOT NULL,
  `skinName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `presetStartingPoint` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `dateCreated` int(10) unsigned NOT NULL,
  `dateUpdated` int(10) unsigned NOT NULL,
  `variableCollection` json NOT NULL,
  `customCss` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `uID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`skinID`),
  KEY `IDX_162E9C4EFD71026C` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `PageThemeCustomStyles`
--

CREATE TABLE `PageThemeCustomStyles` (
  `pThemeID` int(10) unsigned NOT NULL DEFAULT '0',
  `scvlID` int(10) unsigned DEFAULT '0',
  `preset` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sccRecordID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`pThemeID`),
  KEY `scvlID` (`scvlID`),
  KEY `sccRecordID` (`sccRecordID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `PageThemes`
--

CREATE TABLE `PageThemes` (
  `pThemeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pThemeHandle` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pThemeName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pThemeDescription` text COLLATE utf8mb4_unicode_ci,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  `pThemeHasCustomClass` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pThemeID`),
  UNIQUE KEY `ptHandle` (`pThemeHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `PageThemes`
--

INSERT INTO `PageThemes` VALUES
(1, 'atomik', 'Atomik', 'A Concrete CMS theme built for version 9.', 0, 1),
(2, 'elemental', 'Elemental', 'Elegant, spacious theme with support for blogs, portfolios, layouts and more.', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `PageTypeComposerControlTypes`
--

CREATE TABLE `PageTypeComposerControlTypes` (
  `ptComposerControlTypeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ptComposerControlTypeHandle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ptComposerControlTypeName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ptComposerControlTypeID`),
  UNIQUE KEY `ptComposerControlTypeHandle` (`ptComposerControlTypeHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `PageTypeComposerControlTypes`
--

INSERT INTO `PageTypeComposerControlTypes` VALUES
(1, 'core_page_property', 'Built-In Property', 0),
(2, 'collection_attribute', 'Custom Attribute', 0),
(3, 'block', 'Block', 0);

-- --------------------------------------------------------

--
-- Table structure for table `PageTypeComposerFormLayoutSetControls`
--

CREATE TABLE `PageTypeComposerFormLayoutSetControls` (
  `ptComposerFormLayoutSetControlID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ptComposerFormLayoutSetID` int(10) unsigned DEFAULT '0',
  `ptComposerControlTypeID` int(10) unsigned DEFAULT '0',
  `ptComposerControlObject` longtext COLLATE utf8mb4_unicode_ci,
  `ptComposerFormLayoutSetControlDisplayOrder` int(10) unsigned DEFAULT '0',
  `ptComposerFormLayoutSetControlCustomLabel` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ptComposerFormLayoutSetControlCustomTemplate` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ptComposerFormLayoutSetControlDescription` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ptComposerFormLayoutSetControlRequired` int(11) DEFAULT '0',
  PRIMARY KEY (`ptComposerFormLayoutSetControlID`),
  KEY `ptComposerControlTypeID` (`ptComposerControlTypeID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `PageTypeComposerFormLayoutSetControls`
--

INSERT INTO `PageTypeComposerFormLayoutSetControls` VALUES
(1, 1, 1, 'O:78:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\NameCorePageProperty":13:{s:37:"\0*\0ptComposerControlRequiredByDefault";b:1;s:17:"\0*\0propertyHandle";s:4:"name";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:7:"\0*\0page";N;s:30:"\0*\0ptComposerControlIdentifier";s:4:"name";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:8:"file-alt";}s:20:"\0*\0ptComposerControl";N;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 0, 'Page Name', NULL, NULL, 1),
(2, 1, 1, 'O:85:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\DescriptionCorePageProperty":13:{s:17:"\0*\0propertyHandle";s:11:"description";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:7:"\0*\0page";N;s:30:"\0*\0ptComposerControlIdentifier";s:11:"description";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:4:"font";}s:20:"\0*\0ptComposerControl";N;s:37:"\0*\0ptComposerControlRequiredByDefault";b:0;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 1, NULL, NULL, NULL, 0),
(3, 1, 1, 'O:81:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\UrlSlugCorePageProperty":13:{s:17:"\0*\0propertyHandle";s:8:"url_slug";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:7:"\0*\0page";N;s:30:"\0*\0ptComposerControlIdentifier";s:8:"url_slug";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:8:"file-alt";}s:20:"\0*\0ptComposerControl";N;s:37:"\0*\0ptComposerControlRequiredByDefault";b:0;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 2, NULL, NULL, NULL, 0),
(4, 1, 1, 'O:86:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\PageTemplateCorePageProperty":13:{s:17:"\0*\0propertyHandle";s:13:"page_template";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:7:"\0*\0page";N;s:30:"\0*\0ptComposerControlIdentifier";s:13:"page_template";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:8:"list-alt";}s:20:"\0*\0ptComposerControl";N;s:37:"\0*\0ptComposerControlRequiredByDefault";b:0;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 3, NULL, NULL, NULL, 0),
(5, 1, 1, 'O:87:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\PublishTargetCorePageProperty":13:{s:17:"\0*\0propertyHandle";s:14:"publish_target";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:7:"\0*\0page";N;s:30:"\0*\0ptComposerControlIdentifier";s:14:"publish_target";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:8:"download";}s:20:"\0*\0ptComposerControl";N;s:37:"\0*\0ptComposerControlRequiredByDefault";b:0;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 4, NULL, NULL, NULL, 0),
(6, 2, 3, 'O:53:"Concrete\\Core\\Page\\Type\\Composer\\Control\\BlockControl":16:{s:7:"\0*\0btID";i:1;s:30:"\0*\0ptComposerControlTypeHandle";s:5:"block";s:5:"\0*\0bt";b:0;s:4:"\0*\0b";b:0;s:13:"\0*\0controller";N;s:7:"\0*\0page";N;s:30:"\0*\0ptComposerControlIdentifier";i:1;s:24:"\0*\0ptComposerControlName";s:7:"Content";s:27:"\0*\0ptComposerControlIconSRC";[[content_icon]]s:33:"\0*\0ptComposerControlIconFormatter";N;s:20:"\0*\0ptComposerControl";N;s:37:"\0*\0ptComposerControlRequiredByDefault";b:0;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 0, 'Body', NULL, NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `PageTypeComposerFormLayoutSets`
--

CREATE TABLE `PageTypeComposerFormLayoutSets` (
  `ptComposerFormLayoutSetID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ptID` int(10) unsigned DEFAULT '0',
  `ptComposerFormLayoutSetName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ptComposerFormLayoutSetDescription` text COLLATE utf8mb4_unicode_ci,
  `ptComposerFormLayoutSetCollapseType` varchar(12) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ptComposerFormLayoutSetDisplayOrder` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`ptComposerFormLayoutSetID`),
  KEY `ptID` (`ptID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `PageTypeComposerFormLayoutSets`
--

INSERT INTO `PageTypeComposerFormLayoutSets` VALUES
(1, 6, 'Basics', '', '', 0),
(2, 6, 'Content', '', '', 1);

-- --------------------------------------------------------

--
-- Table structure for table `PageTypeComposerOutputBlocks`
--

CREATE TABLE `PageTypeComposerOutputBlocks` (
  `ptComposerOutputBlockID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '0',
  `arHandle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cbDisplayOrder` int(10) unsigned DEFAULT '0',
  `ptComposerFormLayoutSetControlID` int(10) unsigned NOT NULL DEFAULT '0',
  `bID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`ptComposerOutputBlockID`),
  KEY `cID` (`cID`),
  KEY `bID` (`bID`,`cID`),
  KEY `ptComposerFormLayoutSetControlID` (`ptComposerFormLayoutSetControlID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `PageTypeComposerOutputControls`
--

CREATE TABLE `PageTypeComposerOutputControls` (
  `ptComposerOutputControlID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pTemplateID` int(10) unsigned DEFAULT '0',
  `ptID` int(10) unsigned DEFAULT '0',
  `ptComposerFormLayoutSetControlID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`ptComposerOutputControlID`),
  KEY `pTemplateID` (`pTemplateID`,`ptComposerFormLayoutSetControlID`),
  KEY `ptID` (`ptID`),
  KEY `ptComposerFormLayoutSetControlID` (`ptComposerFormLayoutSetControlID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `PageTypeComposerOutputControls`
--

INSERT INTO `PageTypeComposerOutputControls` VALUES
(1, 4, 6, 6);

-- --------------------------------------------------------

--
-- Table structure for table `PageTypePageTemplateDefaultPages`
--

CREATE TABLE `PageTypePageTemplateDefaultPages` (
  `pTemplateID` int(10) unsigned NOT NULL DEFAULT '0',
  `ptID` int(10) unsigned NOT NULL DEFAULT '0',
  `cID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`pTemplateID`,`ptID`),
  KEY `ptID` (`ptID`),
  KEY `cID` (`cID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `PageTypePageTemplateDefaultPages`
--

INSERT INTO `PageTypePageTemplateDefaultPages` VALUES
(4, 6, 231);

-- --------------------------------------------------------

--
-- Table structure for table `PageTypePageTemplates`
--

CREATE TABLE `PageTypePageTemplates` (
  `ptID` int(10) unsigned NOT NULL DEFAULT '0',
  `pTemplateID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ptID`,`pTemplateID`),
  KEY `pTemplateID` (`pTemplateID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `PageTypePermissionAssignments`
--

CREATE TABLE `PageTypePermissionAssignments` (
  `ptID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ptID`,`pkID`,`paID`),
  KEY `pkID` (`pkID`),
  KEY `ptID` (`ptID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `PageTypePermissionAssignments`
--

INSERT INTO `PageTypePermissionAssignments` VALUES
(1, 60, 37),
(2, 60, 37),
(3, 60, 37),
(4, 60, 37),
(5, 60, 37),
(6, 60, 37),
(1, 61, 37),
(2, 61, 37),
(3, 61, 37),
(4, 61, 37),
(5, 61, 37),
(6, 61, 37),
(1, 62, 37),
(2, 62, 37),
(3, 62, 37),
(4, 62, 37),
(5, 62, 37),
(6, 62, 37),
(1, 63, 37),
(2, 63, 37),
(3, 63, 37),
(4, 63, 37),
(5, 63, 37),
(6, 63, 37),
(1, 64, 60),
(2, 64, 61),
(3, 64, 62),
(4, 64, 63),
(5, 64, 64),
(6, 64, 66);

-- --------------------------------------------------------

--
-- Table structure for table `PageTypePublishTargetTypes`
--

CREATE TABLE `PageTypePublishTargetTypes` (
  `ptPublishTargetTypeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ptPublishTargetTypeHandle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ptPublishTargetTypeName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ptPublishTargetTypeID`),
  KEY `ptPublishTargetTypeHandle` (`ptPublishTargetTypeHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `PageTypePublishTargetTypes`
--

INSERT INTO `PageTypePublishTargetTypes` VALUES
(1, 'parent_page', 'Always publish below a certain page', 0),
(2, 'page_type', 'Choose from pages of a certain type', 0),
(3, 'all', 'Choose from all pages when publishing', 0);

-- --------------------------------------------------------

--
-- Table structure for table `PageTypes`
--

CREATE TABLE `PageTypes` (
  `ptID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ptName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ptHandle` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ptPublishTargetTypeID` int(10) unsigned DEFAULT NULL,
  `ptDefaultPageTemplateID` int(10) unsigned DEFAULT NULL,
  `ptDefaultThemeID` int(10) unsigned DEFAULT NULL,
  `ptAllowedPageTemplates` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'A',
  `ptIsInternal` tinyint(1) NOT NULL DEFAULT '0',
  `ptIsFrequentlyAdded` tinyint(1) NOT NULL DEFAULT '1',
  `ptDisplayOrder` int(10) unsigned DEFAULT NULL,
  `ptLaunchInComposer` tinyint(1) NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  `ptPublishTargetObject` longtext COLLATE utf8mb4_unicode_ci,
  `siteTypeID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`ptID`),
  UNIQUE KEY `ptHandle` (`ptHandle`),
  KEY `siteTypeID` (`siteTypeID`),
  KEY `pkgID` (`pkgID`,`ptID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `PageTypes`
--

INSERT INTO `PageTypes` VALUES
(1, 'Stack', 'core_stack', 3, 0, NULL, 'A', 1, 0, 0, 0, 0, 'O:68:"Concrete\\Core\\Page\\Type\\PublishTarget\\Configuration\\AllConfiguration":6:{s:21:"\0*\0selectorFormFactor";N;s:20:"\0*\0startingPointPage";N;s:5:"error";s:0:"";s:21:"ptPublishTargetTypeID";s:1:"3";s:25:"ptPublishTargetTypeHandle";s:3:"all";s:9:"pkgHandle";b:0;}', 1),
(2, 'Stack Category', 'core_stack_category', 3, 0, NULL, 'A', 1, 0, 1, 0, 0, 'O:68:"Concrete\\Core\\Page\\Type\\PublishTarget\\Configuration\\AllConfiguration":6:{s:21:"\0*\0selectorFormFactor";N;s:20:"\0*\0startingPointPage";N;s:5:"error";s:0:"";s:21:"ptPublishTargetTypeID";s:1:"3";s:25:"ptPublishTargetTypeHandle";s:3:"all";s:9:"pkgHandle";b:0;}', 1),
(3, 'Desktop', 'core_desktop', 3, 0, NULL, 'A', 1, 0, 2, 0, 0, 'O:68:"Concrete\\Core\\Page\\Type\\PublishTarget\\Configuration\\AllConfiguration":6:{s:21:"\0*\0selectorFormFactor";N;s:20:"\0*\0startingPointPage";N;s:5:"error";s:0:"";s:21:"ptPublishTargetTypeID";s:1:"3";s:25:"ptPublishTargetTypeHandle";s:3:"all";s:9:"pkgHandle";b:0;}', 1),
(4, 'Theme Documentation Category', 'core_theme_documentation_category', 3, 0, NULL, 'A', 1, 0, 3, 0, 0, 'O:68:"Concrete\\Core\\Page\\Type\\PublishTarget\\Configuration\\AllConfiguration":6:{s:21:"\0*\0selectorFormFactor";N;s:20:"\0*\0startingPointPage";N;s:5:"error";s:0:"";s:21:"ptPublishTargetTypeID";s:1:"3";s:25:"ptPublishTargetTypeHandle";s:3:"all";s:9:"pkgHandle";b:0;}', 1),
(5, 'Theme Documentation', 'core_theme_documentation', 3, 0, NULL, 'A', 1, 0, 4, 0, 0, 'O:68:"Concrete\\Core\\Page\\Type\\PublishTarget\\Configuration\\AllConfiguration":6:{s:21:"\0*\0selectorFormFactor";N;s:20:"\0*\0startingPointPage";N;s:5:"error";s:0:"";s:21:"ptPublishTargetTypeID";s:1:"3";s:25:"ptPublishTargetTypeHandle";s:3:"all";s:9:"pkgHandle";b:0;}', 1),
(6, 'Page', 'page', 3, 4, NULL, 'A', 0, 1, 0, 0, 0, 'O:68:"Concrete\\Core\\Page\\Type\\PublishTarget\\Configuration\\AllConfiguration":6:{s:21:"\0*\0selectorFormFactor";N;s:20:"\0*\0startingPointPage";N;s:5:"error";s:0:"";s:21:"ptPublishTargetTypeID";s:1:"3";s:25:"ptPublishTargetTypeHandle";s:3:"all";s:9:"pkgHandle";b:0;}', 1);

-- --------------------------------------------------------

--
-- Table structure for table `PageWorkflowProgress`
--

CREATE TABLE `PageWorkflowProgress` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `wpID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`wpID`),
  KEY `wpID` (`wpID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `PermissionAccess`
--

CREATE TABLE `PermissionAccess` (
  `paID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `paIsInUse` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=135 ;

--
-- Dumping data for table `PermissionAccess`
--

INSERT INTO `PermissionAccess` VALUES
(1, 1),
(2, 1),
(3, 1),
(4, 1),
(5, 1),
(6, 1),
(7, 1),
(8, 1),
(9, 1),
(10, 1),
(11, 1),
(12, 1),
(13, 1),
(14, 1),
(15, 1),
(16, 1),
(17, 1),
(18, 1),
(19, 1),
(20, 1),
(21, 1),
(22, 1),
(23, 1),
(24, 1),
(25, 1),
(26, 1),
(27, 1),
(28, 1),
(29, 1),
(30, 1),
(31, 1),
(32, 1),
(33, 1),
(34, 1),
(35, 1),
(36, 1),
(37, 1),
(38, 1),
(39, 1),
(40, 1),
(41, 1),
(42, 1),
(43, 1),
(44, 1),
(45, 1),
(46, 1),
(47, 1),
(48, 1),
(49, 1),
(50, 1),
(51, 1),
(52, 1),
(53, 1),
(54, 1),
(55, 1),
(56, 1),
(57, 1),
(58, 1),
(59, 1),
(60, 1),
(61, 1),
(62, 1),
(63, 1),
(64, 1),
(65, 1),
(66, 1),
(67, 1),
(68, 1),
(69, 1),
(70, 1),
(71, 1),
(72, 1),
(73, 1),
(74, 1),
(75, 1),
(76, 1),
(77, 1),
(78, 1),
(79, 1),
(80, 1),
(81, 1),
(82, 1),
(83, 1),
(84, 1),
(85, 1),
(86, 1),
(87, 1),
(88, 1),
(89, 1),
(90, 1),
(91, 1),
(92, 1),
(93, 1),
(94, 1),
(95, 1),
(96, 1),
(97, 1),
(98, 1),
(99, 1),
(100, 1),
(101, 1),
(102, 1),
(103, 1),
(104, 1),
(105, 1),
(106, 1),
(107, 1),
(108, 1),
(109, 1),
(110, 1),
(111, 1),
(112, 1),
(113, 1),
(114, 1),
(115, 1),
(116, 1),
(117, 1),
(118, 1),
(119, 1),
(120, 1),
(121, 1),
(122, 1),
(123, 1),
(124, 1),
(125, 1),
(126, 1),
(127, 1),
(128, 1),
(129, 1),
(130, 1),
(131, 1),
(132, 1),
(133, 1),
(134, 1);

-- --------------------------------------------------------

--
-- Table structure for table `PermissionAccessEntities`
--

CREATE TABLE `PermissionAccessEntities` (
  `peID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `petID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`peID`),
  KEY `petID` (`petID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `PermissionAccessEntities`
--

INSERT INTO `PermissionAccessEntities` VALUES
(1, 1),
(2, 1),
(6, 1),
(7, 2),
(3, 5),
(4, 6),
(5, 7);

-- --------------------------------------------------------

--
-- Table structure for table `PermissionAccessEntityGroups`
--

CREATE TABLE `PermissionAccessEntityGroups` (
  `pegID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `gID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`pegID`),
  KEY `peID` (`peID`),
  KEY `gID` (`gID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `PermissionAccessEntityGroups`
--

INSERT INTO `PermissionAccessEntityGroups` VALUES
(1, 1, 3),
(2, 2, 1),
(3, 6, 2);

-- --------------------------------------------------------

--
-- Table structure for table `PermissionAccessEntityGroupSets`
--

CREATE TABLE `PermissionAccessEntityGroupSets` (
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `gsID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`peID`,`gsID`),
  KEY `gsID` (`gsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `PermissionAccessEntitySiteGroups`
--

CREATE TABLE `PermissionAccessEntitySiteGroups` (
  `pegID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `peID` int(10) unsigned NOT NULL,
  `siteGID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`pegID`),
  KEY `peID` (`peID`),
  KEY `siteGID` (`siteGID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `PermissionAccessEntityTypeCategories`
--

CREATE TABLE `PermissionAccessEntityTypeCategories` (
  `petID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkCategoryID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`petID`,`pkCategoryID`),
  KEY `pkCategoryID` (`pkCategoryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `PermissionAccessEntityTypeCategories`
--

INSERT INTO `PermissionAccessEntityTypeCategories` VALUES
(1, 1),
(2, 1),
(3, 1),
(4, 1),
(5, 1),
(8, 1),
(1, 4),
(2, 4),
(3, 4),
(4, 4),
(1, 5),
(2, 5),
(3, 5),
(4, 5),
(6, 5),
(1, 6),
(2, 6),
(3, 6),
(4, 6),
(6, 6),
(1, 7),
(2, 7),
(3, 7),
(4, 7),
(1, 8),
(2, 8),
(3, 8),
(4, 8),
(1, 9),
(2, 9),
(3, 9),
(4, 9),
(1, 10),
(2, 10),
(3, 10),
(4, 10),
(1, 11),
(2, 11),
(3, 11),
(4, 11),
(1, 12),
(2, 12),
(3, 12),
(4, 12),
(1, 13),
(2, 13),
(3, 13),
(4, 13),
(1, 14),
(2, 14),
(3, 14),
(4, 14),
(8, 14),
(1, 15),
(2, 15),
(3, 15),
(4, 15),
(5, 15),
(8, 15),
(1, 16),
(2, 16),
(3, 16),
(4, 16),
(1, 17),
(2, 17),
(3, 17),
(4, 17),
(1, 18),
(2, 18),
(3, 18),
(4, 18),
(1, 19),
(2, 19),
(3, 19),
(4, 19),
(1, 20),
(2, 20),
(3, 20),
(4, 20),
(1, 21),
(2, 21),
(3, 21),
(4, 21),
(7, 21),
(1, 22),
(2, 22),
(3, 22),
(4, 22),
(7, 22),
(1, 23),
(2, 23),
(4, 23),
(1, 24),
(2, 24),
(3, 24),
(4, 24),
(1, 25),
(2, 25),
(3, 25),
(4, 25),
(1, 26),
(2, 26),
(3, 26),
(4, 26),
(1, 27),
(2, 27),
(3, 27),
(4, 27),
(1, 28),
(2, 28),
(3, 28),
(4, 28);

-- --------------------------------------------------------

--
-- Table structure for table `PermissionAccessEntityTypes`
--

CREATE TABLE `PermissionAccessEntityTypes` (
  `petID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `petHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `petName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`petID`),
  UNIQUE KEY `petHandle` (`petHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=9 ;

--
-- Dumping data for table `PermissionAccessEntityTypes`
--

INSERT INTO `PermissionAccessEntityTypes` VALUES
(1, 'group', 'Group', 0),
(2, 'user', 'User', 0),
(3, 'group_set', 'Group Set', 0),
(4, 'group_combination', 'Group Combination', 0),
(5, 'page_owner', 'Page Owner', 0),
(6, 'file_uploader', 'File Uploader', 0),
(7, 'conversation_message_author', 'Message Author', 0),
(8, 'site_group', 'Site Group', 0);

-- --------------------------------------------------------

--
-- Table structure for table `PermissionAccessEntityUsers`
--

CREATE TABLE `PermissionAccessEntityUsers` (
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`peID`,`uID`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `PermissionAccessEntityUsers`
--

INSERT INTO `PermissionAccessEntityUsers` VALUES
(7, 1);

-- --------------------------------------------------------

--
-- Table structure for table `PermissionAccessList`
--

CREATE TABLE `PermissionAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `pdID` int(10) unsigned NOT NULL DEFAULT '0',
  `accessType` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`),
  KEY `accessType` (`accessType`),
  KEY `peID` (`peID`),
  KEY `peID_accessType` (`peID`,`accessType`),
  KEY `pdID` (`pdID`),
  KEY `permissionAccessDuration` (`paID`,`pdID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `PermissionAccessList`
--

INSERT INTO `PermissionAccessList` VALUES
(1, 1, 0, 10),
(2, 1, 0, 10),
(3, 1, 0, 10),
(4, 1, 0, 10),
(5, 1, 0, 10),
(6, 1, 0, 10),
(7, 1, 0, 10),
(8, 1, 0, 10),
(9, 1, 0, 10),
(10, 1, 0, 10),
(11, 1, 0, 10),
(12, 1, 0, 10),
(13, 2, 0, 10),
(14, 1, 0, 10),
(15, 1, 0, 10),
(16, 1, 0, 10),
(17, 1, 0, 10),
(18, 1, 0, 10),
(19, 2, 0, 10),
(20, 1, 0, 10),
(21, 1, 0, 10),
(22, 1, 0, 10),
(23, 1, 0, 10),
(24, 1, 0, 10),
(25, 1, 0, 10),
(26, 1, 0, 10),
(27, 1, 0, 10),
(28, 1, 0, 10),
(29, 1, 0, 10),
(30, 1, 0, 10),
(31, 2, 0, 10),
(32, 1, 0, 10),
(33, 1, 0, 10),
(34, 1, 0, 10),
(35, 1, 0, 10),
(36, 1, 0, 10),
(37, 1, 0, 10),
(38, 1, 0, 10),
(39, 1, 0, 10),
(40, 1, 0, 10),
(41, 1, 0, 10),
(42, 1, 0, 10),
(43, 1, 0, 10),
(44, 1, 0, 10),
(45, 1, 0, 10),
(46, 1, 0, 10),
(47, 1, 0, 10),
(48, 1, 0, 10),
(49, 1, 0, 10),
(50, 1, 0, 10),
(51, 1, 0, 10),
(52, 1, 0, 10),
(53, 1, 0, 10),
(54, 1, 0, 10),
(55, 1, 0, 10),
(56, 1, 0, 10),
(57, 1, 0, 10),
(58, 1, 0, 10),
(58, 2, 0, 10),
(59, 1, 0, 10),
(59, 2, 0, 10),
(60, 3, 0, 10),
(61, 3, 0, 10),
(62, 3, 0, 10),
(63, 3, 0, 10),
(64, 3, 0, 10),
(65, 1, 0, 10),
(66, 3, 0, 10),
(67, 2, 0, 10),
(68, 1, 0, 10),
(68, 2, 0, 10),
(69, 1, 0, 10),
(70, 1, 0, 10),
(71, 1, 0, 10),
(72, 1, 0, 10),
(73, 1, 0, 10),
(74, 1, 0, 10),
(75, 1, 0, 10),
(76, 1, 0, 10),
(77, 1, 0, 10),
(78, 2, 0, 10),
(79, 2, 0, 10),
(80, 2, 0, 10),
(81, 2, 0, 10),
(82, 1, 0, 10),
(83, 1, 0, 10),
(84, 1, 0, 10),
(85, 1, 0, 10),
(86, 1, 0, 10),
(87, 1, 0, 10),
(88, 1, 0, 10),
(89, 1, 0, 10),
(90, 1, 0, 10),
(91, 1, 0, 10),
(92, 1, 0, 10),
(93, 1, 0, 10),
(94, 1, 0, 10),
(95, 1, 0, 10),
(96, 1, 0, 10),
(97, 1, 0, 10),
(98, 1, 0, 10),
(99, 1, 0, 10),
(100, 1, 0, 10),
(101, 2, 0, 10),
(102, 1, 0, 10),
(103, 1, 0, 10),
(104, 1, 0, 10),
(105, 1, 0, 10),
(106, 1, 0, 10),
(107, 1, 0, 10),
(108, 1, 0, 10),
(109, 1, 0, 10),
(110, 1, 0, 10),
(111, 1, 0, 10),
(112, 1, 0, 10),
(113, 1, 0, 10),
(114, 1, 0, 10),
(115, 1, 0, 10),
(116, 1, 0, 10),
(117, 1, 0, 10),
(118, 1, 0, 10),
(119, 1, 0, 10),
(120, 1, 0, 10),
(121, 1, 0, 10),
(122, 1, 0, 10),
(123, 1, 0, 10),
(124, 1, 0, 10),
(125, 1, 0, 10),
(126, 2, 0, 10),
(127, 2, 0, 10),
(128, 1, 0, 10),
(128, 5, 0, 10),
(129, 1, 0, 10),
(129, 5, 0, 10),
(130, 1, 0, 10),
(130, 6, 0, 10),
(131, 1, 0, 10),
(132, 1, 0, 10),
(133, 1, 0, 10),
(134, 1, 0, 10),
(134, 7, 0, 10);

-- --------------------------------------------------------

--
-- Table structure for table `PermissionAccessWorkflows`
--

CREATE TABLE `PermissionAccessWorkflows` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `wfID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`wfID`),
  KEY `wfID` (`wfID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `PermissionAssignments`
--

CREATE TABLE `PermissionAssignments` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`pkID`),
  KEY `pkID` (`pkID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `PermissionAssignments`
--

INSERT INTO `PermissionAssignments` VALUES
(1, 19),
(2, 20),
(3, 75),
(4, 76),
(5, 77),
(6, 78),
(7, 79),
(8, 80),
(9, 82),
(10, 83),
(11, 84),
(134, 85),
(12, 86),
(13, 87),
(14, 88),
(15, 89),
(16, 90),
(17, 91),
(18, 92),
(19, 93),
(20, 94),
(21, 95),
(22, 96),
(23, 97),
(24, 98),
(25, 99),
(26, 100),
(27, 101),
(28, 102),
(29, 103),
(30, 104),
(31, 105),
(32, 106),
(33, 107),
(34, 108),
(35, 109),
(36, 110),
(37, 136),
(38, 138),
(39, 139),
(40, 140),
(41, 141),
(42, 142),
(43, 143),
(44, 144),
(45, 145),
(46, 146),
(47, 147),
(48, 148),
(49, 149),
(50, 150),
(51, 151),
(52, 152),
(53, 153);

-- --------------------------------------------------------

--
-- Table structure for table `PermissionDurationObjects`
--

CREATE TABLE `PermissionDurationObjects` (
  `pdID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pdObject` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`pdID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `PermissionKeyCategories`
--

CREATE TABLE `PermissionKeyCategories` (
  `pkCategoryID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pkCategoryHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`pkCategoryID`),
  UNIQUE KEY `pkCategoryHandle` (`pkCategoryHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=30 ;

--
-- Dumping data for table `PermissionKeyCategories`
--

INSERT INTO `PermissionKeyCategories` VALUES
(1, 'page', NULL),
(2, 'single_page', NULL),
(3, 'stack', NULL),
(4, 'user', NULL),
(5, 'file_folder', NULL),
(6, 'file', NULL),
(7, 'area', NULL),
(8, 'block_type', NULL),
(9, 'block', NULL),
(10, 'admin', NULL),
(11, 'notification', NULL),
(12, 'sitemap', NULL),
(13, 'marketplace', NULL),
(14, 'basic_workflow', NULL),
(15, 'page_type', NULL),
(16, 'group_tree_node', NULL),
(17, 'group_folder', NULL),
(18, 'express_tree_node', NULL),
(19, 'category_tree_node', NULL),
(20, 'topic_tree_node', NULL),
(21, 'conversation', NULL),
(22, 'conversation_message', NULL),
(23, 'multilingual_section', NULL),
(24, 'calendar_admin', NULL),
(25, 'calendar', NULL),
(26, 'express_entry', NULL),
(27, 'board_admin', NULL),
(28, 'board', NULL),
(29, 'logs', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `PermissionKeys`
--

CREATE TABLE `PermissionKeys` (
  `pkID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pkHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pkName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pkCanTriggerWorkflow` tinyint(1) NOT NULL DEFAULT '0',
  `pkHasCustomClass` tinyint(1) NOT NULL DEFAULT '0',
  `pkDescription` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pkCategoryID` int(10) unsigned DEFAULT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`pkID`),
  UNIQUE KEY `akHandle` (`pkHandle`),
  KEY `pkCategoryID` (`pkCategoryID`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=154 ;

--
-- Dumping data for table `PermissionKeys`
--

INSERT INTO `PermissionKeys` VALUES
(1, 'view_page', 'View', 0, 0, 'Can see a page exists and read its content.', 1, 0),
(2, 'view_page_versions', 'View Versions', 0, 0, 'Can view the page versions dialog and read past versions of a page.', 1, 0),
(3, 'view_page_in_sitemap', 'View Page in Sitemap', 0, 0, 'Controls whether a user can see a page in the sitemap or intelligent search.', 1, 0),
(4, 'preview_page_as_user', 'Preview Page As User', 0, 0, 'Ability to see what this page will look like at a specific time in the future as a specific user.', 1, 0),
(5, 'edit_page_properties', 'Edit Properties', 0, 1, 'Ability to change anything in the Page Properties menu.', 1, 0),
(6, 'edit_page_contents', 'Edit Contents', 0, 0, 'Ability to make edits to at least some of the content in the page. You can lock down different block areas and specific blocks by clicking Permissions on them as well. ', 1, 0),
(7, 'edit_page_speed_settings', 'Edit Speed Settings', 0, 0, 'Ability to change caching settings.', 1, 0),
(8, 'edit_page_theme', 'Change Theme', 0, 1, 'Ability to change just the theme for this page.', 1, 0),
(9, 'edit_page_template', 'Change Page Template', 0, 0, 'Ability to change just the page template for this page.', 1, 0),
(10, 'edit_page_page_type', 'Edit Page Type', 0, 0, 'Change the type of an existing page.', 1, 0),
(11, 'edit_page_permissions', 'Edit Permissions', 1, 0, 'Ability to change permissions for this page. Warning: by granting this a user could give themselves more access.', 1, 0),
(12, 'delete_page', 'Delete', 1, 0, 'Ability to move this page to the site''s Trash.', 1, 0),
(13, 'delete_page_versions', 'Delete Versions', 1, 0, 'Ability to remove old versions of this page.', 1, 0),
(14, 'approve_page_versions', 'Approve Changes', 1, 0, 'Can publish an unapproved version of the page.', 1, 0),
(15, 'add_subpage', 'Add Sub-Page', 0, 1, 'Can add a page beneath the current page.', 1, 0),
(16, 'move_or_copy_page', 'Move or Copy Page', 1, 0, 'Can move or copy this page to another location.', 1, 0),
(17, 'schedule_page_contents_guest_access', 'Schedule Guest Access', 0, 0, 'Can control scheduled guest access to this page.', 1, 0),
(18, 'edit_page_multilingual_settings', 'Edit Multilingual Settings', 0, 0, 'Controls whether a user can see the multilingual settings menu, re-map a page or set a page as ignored in multilingual settings.', 1, 0),
(19, 'add_block', 'Add Block', 0, 1, 'Can add a block to any area on the site. If someone is added here they can add blocks to any area (unless that area has permissions that override these global permissions.)', 8, 0),
(20, 'add_stack', 'Add Stack', 0, 0, 'Can add a stack or block from a stack to any area on the site. If someone is added here they can add stacks to any area (unless that area has permissions that override these global permissions.)', 8, 0),
(21, 'view_area', 'View Area', 0, 0, 'Can view the area and its contents.', 7, 0),
(22, 'edit_area_contents', 'Edit Area Contents', 0, 0, 'Can edit blocks within this area.', 7, 0),
(23, 'add_block_to_area', 'Add Block to Area', 0, 1, 'Can add blocks to this area. This setting overrides the global Add Block permission for this area.', 7, 0),
(24, 'add_stack_to_area', 'Add Stack to Area', 0, 0, 'Can add stacks to this area. This setting overrides the global Add Stack permission for this area.', 7, 0),
(25, 'add_layout_to_area', 'Add Layouts to Area', 0, 0, 'Controls whether users get the ability to add layouts to a particular area.', 7, 0),
(26, 'edit_area_design', 'Edit Area Design', 0, 0, 'Controls whether users see design controls and can modify an area''s custom CSS.', 7, 0),
(27, 'edit_area_permissions', 'Edit Area Permissions', 0, 0, 'Controls whether users can access the permissions on an area. Custom area permissions could override those of the page.', 7, 0),
(28, 'delete_area_contents', 'Delete Area Contents', 0, 0, 'Controls whether users can delete blocks from this area.', 7, 0),
(29, 'schedule_area_contents_guest_access', 'Schedule Guest Access', 0, 0, 'Controls whether users can schedule guest access permissions on blocks in this area. Guest Access is a shortcut for granting permissions just to the Guest Group.', 7, 0),
(30, 'view_block', 'View Block', 0, 0, 'Controls whether users can view this block in the page.', 9, 0),
(31, 'edit_block', 'Edit Block', 0, 0, 'Controls whether users can edit this block. This overrides any area or page permissions.', 9, 0),
(32, 'edit_block_custom_template', 'Change Block Template', 0, 0, 'Controls whether users can change the block template on this block. This overrides any area or page permissions.', 9, 0),
(33, 'edit_block_cache_settings', 'Edit Cache Settings', 0, 0, 'Controls whether users can change the block cache settings for this block instance.', 9, 0),
(34, 'edit_block_name', 'Edit Name', 0, 0, 'Controls whether users can change the block''s name (rarely used.)', 9, 0),
(35, 'delete_block', 'Delete Block', 0, 0, 'Controls whether users can delete this block. This overrides any area or page permissions.', 9, 0),
(36, 'edit_block_design', 'Edit Design', 0, 0, 'Controls whether users can set custom design properties or CSS on this block.', 9, 0),
(37, 'edit_block_permissions', 'Edit Permissions', 0, 0, 'Controls whether users can change permissions on this block, potentially granting themselves or others greater access.', 9, 0),
(38, 'schedule_guest_access', 'Schedule Guest Access', 0, 0, 'Controls whether users can schedule guest access permissions on this block. Guest Access is a shortcut for granting permissions just to the Guest Group.', 9, 0),
(39, 'view_file_folder_file', 'View Files', 0, 0, 'View files within folder in the site.', 5, 0),
(40, 'search_file_folder', 'Search File Folder', 0, 0, 'See this file folder in the file manager', 5, 0),
(41, 'edit_file_folder', 'Edit File Folder', 0, 0, 'Edit a file folder.', 5, 0),
(42, 'edit_file_folder_file_properties', 'Edit File Properties', 0, 0, 'Can edit a file''s properties.', 5, 0),
(43, 'edit_file_folder_file_contents', 'Edit File Contents', 0, 0, 'Can edit or replace files in folder.', 5, 0),
(44, 'copy_file_folder_files', 'Copy File', 0, 0, 'Can copy files in file folder.', 5, 0),
(45, 'edit_file_folder_permissions', 'Edit File Access', 0, 0, 'Can edit access to file folder.', 5, 0),
(46, 'delete_file_folder', 'Delete File Folder', 0, 0, 'Can delete file folder.', 5, 0),
(47, 'delete_file_folder_files', 'Delete File', 0, 0, 'Can delete files in folder.', 5, 0),
(48, 'add_file', 'Add File', 0, 1, 'Can add files to folder.', 5, 0),
(49, 'view_file', 'View Files', 0, 0, 'Can view and download files.', 6, 0),
(50, 'view_file_in_file_manager', 'View File in File Manager', 0, 0, 'Can access the File Manager.', 6, 0),
(51, 'edit_file_properties', 'Edit File Properties', 0, 0, 'Can edit a file''s properties.', 6, 0),
(52, 'edit_file_contents', 'Edit File Contents', 0, 0, 'Can edit or replace files.', 6, 0),
(53, 'copy_file', 'Copy File', 0, 0, 'Can copy file.', 6, 0),
(54, 'edit_file_permissions', 'Edit File Access', 0, 0, 'Can edit access to file.', 6, 0),
(55, 'delete_file', 'Delete File', 0, 0, 'Can delete file.', 6, 0),
(56, 'approve_basic_workflow_action', 'Approve or Deny', 0, 0, 'Grant ability to approve workflow.', 14, 0),
(57, 'notify_on_basic_workflow_entry', 'Notify on Entry', 0, 0, 'Notify approvers that a change has entered the workflow.', 14, 0),
(58, 'notify_on_basic_workflow_approve', 'Notify on Approve', 0, 0, 'Notify approvers that a change has been approved.', 14, 0),
(59, 'notify_on_basic_workflow_deny', 'Notify on Deny', 0, 0, 'Notify approvers that a change has been denied.', 14, 0),
(60, 'add_page_type', 'Add Pages of This Type', 0, 0, '', 15, 0),
(61, 'edit_page_type', 'Edit Page Type', 0, 0, '', 15, 0),
(62, 'delete_page_type', 'Delete Page Type', 0, 0, '', 15, 0),
(63, 'edit_page_type_permissions', 'Edit Page Type Permissions', 0, 0, '', 15, 0),
(64, 'edit_page_type_drafts', 'Edit Page Type Drafts', 0, 0, '', 15, 0),
(65, 'view_topic_tree_node', 'View Topic Tree Node', 0, 0, '', 20, 0),
(66, 'view_category_tree_node', 'View Category Tree Node', 0, 0, '', 19, 0),
(67, 'add_conversation_message', 'Add Message to Conversation', 0, 1, '', 21, 0),
(68, 'add_conversation_message_attachments', 'Add Message Attachments', 0, 0, '', 21, 0),
(69, 'edit_conversation_permissions', 'Edit Conversation Permissions', 0, 0, '', 21, 0),
(70, 'delete_conversation_message', 'Delete Message', 0, 0, '', 21, 0),
(71, 'edit_conversation_message', 'Edit Message', 0, 0, '', 21, 0),
(72, 'rate_conversation_message', 'Rate Message', 0, 0, '', 21, 0),
(73, 'flag_conversation_message', 'Flag Message', 0, 0, '', 21, 0),
(74, 'approve_conversation_message', 'Approve Message', 0, 0, '', 21, 0),
(75, 'view_log_entries', 'View Log Entries', 0, 0, '', 29, 0),
(76, 'delete_log_entries', 'Delete Log Entries', 0, 0, '', 29, 0),
(77, 'export_log_entries', 'Export Log Entries', 0, 0, '', 29, 0),
(78, 'edit_user_properties', 'Edit User Details', 0, 1, NULL, 4, 0),
(79, 'view_user_attributes', 'View User Attributes', 0, 1, NULL, 4, 0),
(80, 'activate_user', 'Activate/Deactivate User', 1, 0, NULL, 4, 0),
(81, 'sudo', 'Sign in as User', 0, 0, NULL, 4, 0),
(82, 'upgrade', 'Upgrade Concrete', 0, 0, NULL, 10, 0),
(83, 'access_group_search', 'Access Group Search', 0, 0, NULL, 4, 0),
(84, 'delete_user', 'Delete User', 1, 0, NULL, 4, 0),
(85, 'notify_in_notification_center', 'Notify in Notification Center', 0, 1, 'Controls who receives updates in the notification center.', 11, 0),
(86, 'add_calendar', 'Add Calendar', 0, 0, '', 24, 0),
(87, 'view_calendars', 'View Calendars', 0, 0, '', 24, 0),
(88, 'edit_calendars', 'Edit Calendars', 0, 0, '', 24, 0),
(89, 'edit_calendars_permissions', 'Edit Permissions', 0, 0, '', 24, 0),
(90, 'add_calendar_events', 'Add Calendar Events', 0, 0, '', 24, 0),
(91, 'approve_calendar_events', 'Approve Calendar Events', 1, 0, '', 24, 0),
(92, 'delete_calendars', 'Delete Calendars', 0, 0, '', 24, 0),
(93, 'access_calendar_rss_feeds', 'Access RSS Feeds', 0, 0, '', 24, 0),
(94, 'view_calendar', 'View Calendar', 0, 0, '', 25, 0),
(95, 'view_calendar_in_edit_interface', 'View in Edit Interface', 0, 0, '', 25, 0),
(96, 'edit_calendar_permissions', 'Edit Permissions', 0, 0, '', 25, 0),
(97, 'edit_calendar', 'Edit Calendar', 0, 0, '', 25, 0),
(98, 'add_calendar_event', 'Add Calendar Event', 0, 0, '', 25, 0),
(99, 'approve_calendar_event', 'Approve Calendar Event', 1, 0, '', 25, 0),
(100, 'edit_calendar_event_more_details_location', 'Modify More Details Location', 0, 0, '', 25, 0),
(101, 'edit_calendar_events', 'Edit Calendar Events', 0, 0, '', 25, 0),
(102, 'access_calendar_rss_feed', 'Access RSS Feed', 0, 0, '', 25, 0),
(103, 'delete_calendar', 'Delete Calendar', 0, 0, '', 25, 0),
(104, 'add_board', 'Add Board', 0, 0, '', 27, 0),
(105, 'view_boards', 'View Boards', 0, 0, '', 27, 0),
(106, 'edit_boards_settings', 'Edit Board Settings', 0, 0, '', 27, 0),
(107, 'edit_boards_contents', 'Edit Board Content', 0, 0, '', 27, 0),
(108, 'edit_boards_permissions', 'Edit Permissions', 0, 0, '', 27, 0),
(109, 'edit_boards_locked_rules', 'Edit Locked Rules', 0, 0, '', 27, 0),
(110, 'delete_boards', 'Delete Boards', 0, 0, '', 27, 0),
(111, 'view_board', 'View Board', 0, 0, '', 28, 0),
(112, 'edit_board_settings', 'Edit Settings', 0, 0, '', 28, 0),
(113, 'edit_board_permissions', 'Edit Permissions', 0, 0, '', 28, 0),
(114, 'edit_board_contents', 'Edit Contents', 0, 0, '', 28, 0),
(115, 'edit_board_locked_rules', 'Edit Locked Rules', 0, 0, '', 28, 0),
(116, 'delete_board', 'Delete Board', 0, 0, '', 28, 0),
(117, 'view_express_entries', 'View Entries', 0, 0, NULL, 18, 0),
(118, 'add_express_entries', 'Add Entry', 0, 0, NULL, 18, 0),
(119, 'edit_express_entries', 'Edit Entry', 0, 0, NULL, 18, 0),
(120, 'delete_express_entries', 'Delete Entry', 0, 0, NULL, 18, 0),
(121, 'view_express_entry', 'View Entries', 0, 0, NULL, 26, 0),
(122, 'edit_express_entry', 'Edit Entry', 0, 0, NULL, 26, 0),
(123, 'delete_express_entry', 'Delete Entry', 0, 0, NULL, 26, 0),
(124, 'search_group_folder', 'Search Group Folder', 0, 0, 'See this group folder in the group search.', 17, 0),
(125, 'edit_group_folder', 'Edit Group Folder', 0, 0, 'Edit a group folder.', 17, 0),
(126, 'edit_group_folder_permissions', 'Edit Group Access', 0, 0, 'Can edit access to group folder.', 17, 0),
(127, 'delete_group_folder', 'Delete Group Folder', 0, 0, 'Can delete group folder.', 17, 0),
(128, 'add_group_folder', 'Add Group Folder', 0, 0, 'Can add folders.', 17, 0),
(129, 'add_group', 'Add Group', 0, 0, 'Can add groups to folder.', 17, 0),
(130, 'assign_groups', 'Assign Groups', 0, 0, 'Can assign the groups within this folder.', 17, 0),
(131, 'search_users_in_group', 'Search User Group', 0, 0, NULL, 16, 0),
(132, 'edit_group', 'Edit Group', 0, 0, NULL, 16, 0),
(133, 'assign_group', 'Assign Group', 0, 0, NULL, 16, 0),
(134, 'add_sub_group', 'Add Child Group', 0, 0, NULL, 16, 0),
(135, 'edit_group_permissions', 'Edit Group Permissions', 0, 0, NULL, 16, 0),
(136, 'access_page_type_permissions', 'Access Page Type Permissions', 0, 0, NULL, 10, 0),
(137, 'access_task_permissions', 'Access Task Permissions', 0, 0, NULL, 10, 0),
(138, 'access_sitemap', 'Access Sitemap', 0, 0, NULL, 12, 0),
(139, 'access_page_defaults', 'Access Page Type Defaults', 0, 0, NULL, 10, 0),
(140, 'customize_themes', 'Customize Themes', 0, 0, NULL, 10, 0),
(141, 'view_debug_error_information', 'View Debug Error Information', 0, 0, NULL, 10, 0),
(142, 'manage_layout_presets', 'Manage Layout Presets', 0, 0, NULL, 10, 0),
(143, 'empty_trash', 'Empty Trash', 0, 0, NULL, 10, 0),
(144, 'add_topic_tree', 'Add Topic Tree', 0, 0, NULL, 10, 0),
(145, 'remove_topic_tree', 'Remove Topic Tree', 0, 0, NULL, 10, 0),
(146, 'view_in_maintenance_mode', 'View Site in Maintenance Mode', 0, 0, 'Ability to see and use the website when Concrete is in maintenance mode.', 10, 0),
(147, 'uninstall_packages', 'Uninstall Packages', 0, 0, NULL, 13, 0),
(148, 'install_packages', 'Install Packages', 0, 0, NULL, 13, 0),
(149, 'access_user_search_export', 'Export Site Users', 0, 0, 'Controls whether a user can export site users or not', 4, 0),
(150, 'access_user_search', 'Access User Search', 0, 0, 'Controls whether a user can view the search user interface.', 4, 0),
(151, 'access_api', 'Access API', 0, 0, NULL, 10, 0),
(152, 'view_announcement_content', 'View Announcement Content', 0, 0, 'Controls whether a user sees the Announcement modal interstitial, including upgrades and help, upon login.', 10, 0),
(153, 'edit_topic_tree', 'Edit Topic Tree', 0, 0, NULL, 10, 0);

-- --------------------------------------------------------

--
-- Table structure for table `PileContents`
--

CREATE TABLE `PileContents` (
  `pcID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pID` int(10) unsigned NOT NULL DEFAULT '0',
  `itemID` int(10) unsigned NOT NULL DEFAULT '0',
  `itemType` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` int(10) unsigned NOT NULL DEFAULT '1',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `displayOrder` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`pcID`),
  KEY `pID` (`pID`,`displayOrder`),
  KEY `itemID` (`itemID`),
  KEY `itemType` (`itemType`,`itemID`,`pID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `Piles`
--

CREATE TABLE `Piles` (
  `pID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uID` int(10) unsigned DEFAULT NULL,
  `isDefault` tinyint(1) NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`pID`),
  KEY `uID` (`uID`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `PrivateMessageNotifications`
--

CREATE TABLE `PrivateMessageNotifications` (
  `msgID` int(10) unsigned NOT NULL,
  `nID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`nID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `QueuePageDuplicationRelations`
--

CREATE TABLE `QueuePageDuplicationRelations` (
  `queue_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `originalCID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`originalCID`),
  KEY `originalCID` (`originalCID`,`queue_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `SavedExpressSearchQueries`
--

CREATE TABLE `SavedExpressSearchQueries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `presetName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `query_fields` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_columns` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_itemsPerPage` smallint(6) NOT NULL,
  `exEntityID` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`),
  KEY `IDX_F87C25F2CE2D7284` (`exEntityID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `SavedFileSearchQueries`
--

CREATE TABLE `SavedFileSearchQueries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `presetName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `query_fields` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_columns` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_itemsPerPage` smallint(6) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `SavedGroupSearchQueries`
--

CREATE TABLE `SavedGroupSearchQueries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `presetName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `query_fields` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_columns` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_itemsPerPage` smallint(6) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `SavedLogSearchQueries`
--

CREATE TABLE `SavedLogSearchQueries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `presetName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `query_fields` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_columns` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_itemsPerPage` smallint(6) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `SavedPageSearchQueries`
--

CREATE TABLE `SavedPageSearchQueries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `presetName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `query_fields` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_columns` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_itemsPerPage` smallint(6) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `SavedUserSearchQueries`
--

CREATE TABLE `SavedUserSearchQueries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `presetName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `query_fields` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_columns` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_itemsPerPage` smallint(6) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `Sessions`
--

CREATE TABLE `Sessions` (
  `sessionID` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sessionValue` longtext COLLATE utf8mb4_unicode_ci,
  `sessionTime` int(10) unsigned NOT NULL,
  `sessionLifeTime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`sessionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `SiblingPageRelations`
--

CREATE TABLE `SiblingPageRelations` (
  `mpRelationID` int(10) unsigned NOT NULL,
  `cID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`mpRelationID`,`cID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `SiteAttributeKeys`
--

CREATE TABLE `SiteAttributeKeys` (
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `SiteAttributeValues`
--

CREATE TABLE `SiteAttributeValues` (
  `siteID` int(10) unsigned NOT NULL,
  `akID` int(10) unsigned NOT NULL,
  `avID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`siteID`,`akID`),
  KEY `IDX_67658AF7521D8435` (`siteID`),
  KEY `IDX_67658AF7B6561A7E` (`akID`),
  KEY `IDX_67658AF7A2A82A5D` (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `SiteDomains`
--

CREATE TABLE `SiteDomains` (
  `domainID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `domain` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `siteID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`domainID`),
  KEY `IDX_4CC7400A521D8435` (`siteID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `SiteGroupRelations`
--

CREATE TABLE `SiteGroupRelations` (
  `groupRelationID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gID` int(10) unsigned NOT NULL,
  `siteGID` int(10) unsigned DEFAULT NULL,
  `siteID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`groupRelationID`),
  KEY `IDX_DCBCDCA94A62E0E4` (`siteGID`),
  KEY `IDX_DCBCDCA9521D8435` (`siteID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `SiteGroups`
--

CREATE TABLE `SiteGroups` (
  `siteGID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `groupName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `siteTypeID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`siteGID`),
  KEY `IDX_F6FE030FE9548DF7` (`siteTypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `SiteLocales`
--

CREATE TABLE `SiteLocales` (
  `siteLocaleID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `msIsDefault` tinyint(1) NOT NULL,
  `msLanguage` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `msCountry` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `msNumPlurals` int(11) NOT NULL,
  `msPluralRule` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL,
  `msPluralCases` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL,
  `siteID` int(10) unsigned DEFAULT NULL,
  `siteTreeID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`siteLocaleID`),
  UNIQUE KEY `UNIQ_2527AB2CF9431B4B` (`siteTreeID`),
  KEY `IDX_2527AB2C521D8435` (`siteID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `SiteLocales`
--

INSERT INTO `SiteLocales` VALUES
(1, 1, 'en', 'US', 2, 'n != 1', 'one@1\nother@0, 2~16, 100, 1000, 10000, 100000, 1000000, …', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `Sites`
--

CREATE TABLE `Sites` (
  `siteID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pThemeID` int(10) unsigned NOT NULL,
  `pThemeSkinIdentifier` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pThemeSkinIdentifierDark` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `siteIsDefault` tinyint(1) NOT NULL,
  `siteHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `siteTypeID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`siteID`),
  UNIQUE KEY `UNIQ_7DC18567D84E1976` (`siteHandle`),
  KEY `IDX_7DC18567E9548DF7` (`siteTypeID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `Sites`
--

INSERT INTO `Sites` VALUES
(1, 1, NULL, NULL, 1, 'default', 1);

-- --------------------------------------------------------

--
-- Table structure for table `SiteSearchIndexAttributes`
--

CREATE TABLE `SiteSearchIndexAttributes` (
  `siteID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`siteID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `SiteSkeletonLocales`
--

CREATE TABLE `SiteSkeletonLocales` (
  `skeletonLocaleID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `msLanguage` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `msCountry` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `msNumPlurals` int(11) NOT NULL,
  `msPluralRule` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL,
  `msPluralCases` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL,
  `siteSkeletonID` int(10) unsigned DEFAULT NULL,
  `siteTreeID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`skeletonLocaleID`),
  UNIQUE KEY `UNIQ_212DD202F9431B4B` (`siteTreeID`),
  KEY `IDX_212DD202B579BD3E` (`siteSkeletonID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `SiteSkeletons`
--

CREATE TABLE `SiteSkeletons` (
  `siteSkeletonID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `siteTypeID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`siteSkeletonID`),
  UNIQUE KEY `UNIQ_D36AED98E9548DF7` (`siteTypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `SiteSkeletonTrees`
--

CREATE TABLE `SiteSkeletonTrees` (
  `skeletonLocaleID` int(10) unsigned DEFAULT NULL,
  `siteTypeID` int(10) unsigned DEFAULT NULL,
  `siteTreeID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`siteTreeID`),
  UNIQUE KEY `UNIQ_550F784B16B7EAF2` (`skeletonLocaleID`),
  UNIQUE KEY `UNIQ_550F784BE9548DF7` (`siteTypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `SiteTrees`
--

CREATE TABLE `SiteTrees` (
  `siteTreeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `siteHomePageID` int(10) unsigned NOT NULL,
  `treeType` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`siteTreeID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `SiteTrees`
--

INSERT INTO `SiteTrees` VALUES
(1, 1, 'sitetree');

-- --------------------------------------------------------

--
-- Table structure for table `SiteTreeTrees`
--

CREATE TABLE `SiteTreeTrees` (
  `siteLocaleID` int(10) unsigned DEFAULT NULL,
  `siteTreeID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`siteTreeID`),
  UNIQUE KEY `UNIQ_A4B9696EACD624CD` (`siteLocaleID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `SiteTreeTrees`
--

INSERT INTO `SiteTreeTrees` VALUES
(1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `SiteTypeAttributeKeys`
--

CREATE TABLE `SiteTypeAttributeKeys` (
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `SiteTypeAttributeValues`
--

CREATE TABLE `SiteTypeAttributeValues` (
  `siteSkeletonID` int(10) unsigned DEFAULT NULL,
  `akID` int(10) unsigned NOT NULL,
  `avID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`akID`),
  KEY `IDX_78059CB9B579BD3E` (`siteSkeletonID`),
  KEY `IDX_78059CB9A2A82A5D` (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `SiteTypes`
--

CREATE TABLE `SiteTypes` (
  `siteTypeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `siteTypeHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `siteTypeName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `siteTypeThemeID` int(11) NOT NULL,
  `siteTypeHomePageTemplateID` int(11) NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`siteTypeID`),
  UNIQUE KEY `UNIQ_7CBFE97576D39A3C` (`siteTypeHandle`),
  UNIQUE KEY `UNIQ_7CBFE975C7F74FC3` (`siteTypeName`),
  KEY `IDX_7CBFE975CE45CBB0` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `SiteTypes`
--

INSERT INTO `SiteTypes` VALUES
(1, 'default', 'Default Site Type', 0, 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `SocialLinks`
--

CREATE TABLE `SocialLinks` (
  `ssHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slID` int(11) NOT NULL AUTO_INCREMENT,
  `siteID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`slID`),
  KEY `IDX_84EBA2B4521D8435` (`siteID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `Stacks`
--

CREATE TABLE `Stacks` (
  `stID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `stName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `stType` int(10) unsigned NOT NULL DEFAULT '0',
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `stMultilingualSection` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`stID`),
  KEY `stType` (`stType`),
  KEY `stName` (`stName`),
  KEY `cID` (`cID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `StackUsageRecord`
--

CREATE TABLE `StackUsageRecord` (
  `stack_id` int(11) NOT NULL,
  `block_id` int(11) NOT NULL,
  `collection_id` int(11) NOT NULL,
  `collection_version_id` int(11) NOT NULL,
  PRIMARY KEY (`stack_id`,`block_id`,`collection_id`,`collection_version_id`),
  KEY `block` (`block_id`),
  KEY `collection_version` (`collection_id`,`collection_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `StyleCustomizerCustomCssRecords`
--

CREATE TABLE `StyleCustomizerCustomCssRecords` (
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sccRecordID` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sccRecordID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `StyleCustomizerInlineStylePresets`
--

CREATE TABLE `StyleCustomizerInlineStylePresets` (
  `pssPresetID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pssPresetName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `issID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`pssPresetID`),
  KEY `issID` (`issID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `StyleCustomizerInlineStyleSets`
--

CREATE TABLE `StyleCustomizerInlineStyleSets` (
  `issID` int(11) NOT NULL AUTO_INCREMENT,
  `customClass` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customID` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customElementAttribute` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `backgroundColor` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `backgroundImageFileID` int(11) NOT NULL,
  `backgroundRepeat` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `backgroundSize` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `backgroundPosition` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `borderColor` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `borderStyle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `borderWidth` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `borderRadius` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `baseFontSize` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alignment` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `textColor` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `linkColor` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `marginTop` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `marginBottom` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `marginLeft` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `marginRight` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paddingTop` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paddingBottom` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paddingLeft` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paddingRight` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rotate` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `boxShadowHorizontal` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `boxShadowVertical` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `boxShadowBlur` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `boxShadowSpread` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `boxShadowColor` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `boxShadowInset` tinyint(1) DEFAULT NULL,
  `hideOnExtraSmallDevice` tinyint(1) DEFAULT NULL,
  `hideOnSmallDevice` tinyint(1) DEFAULT NULL,
  `hideOnMediumDevice` tinyint(1) DEFAULT NULL,
  `hideOnLargeDevice` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`issID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `StyleCustomizerInlineStyleSets`
--

INSERT INTO `StyleCustomizerInlineStyleSets` VALUES
(1, 'concrete-blog-stories', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `StyleCustomizerValueLists`
--

CREATE TABLE `StyleCustomizerValueLists` (
  `scvlID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`scvlID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `StyleCustomizerValues`
--

CREATE TABLE `StyleCustomizerValues` (
  `scvID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scvlID` int(10) unsigned DEFAULT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`scvID`),
  KEY `scvlID` (`scvlID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `SummaryCategories`
--

CREATE TABLE `SummaryCategories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_F815AD2ACE45CBB0` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `SummaryCategories`
--

INSERT INTO `SummaryCategories` VALUES
(1, 'Page', 'page', NULL),
(2, 'Calendar Event', 'calendar_event', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `SummaryFields`
--

CREATE TABLE `SummaryFields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_AC926EC9CE45CBB0` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=10 ;

--
-- Dumping data for table `SummaryFields`
--

INSERT INTO `SummaryFields` VALUES
(1, 'Title', 'title', NULL),
(2, 'Date', 'date', NULL),
(3, 'Start Date', 'date_start', NULL),
(4, 'End Date', 'date_end', NULL),
(5, 'Link', 'link', NULL),
(6, 'Description', 'description', NULL),
(7, 'Thumbnail', 'thumbnail', NULL),
(8, 'Categories', 'categories', NULL),
(9, 'Author', 'author', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `SummaryTemplateCategories`
--

CREATE TABLE `SummaryTemplateCategories` (
  `template_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  PRIMARY KEY (`template_id`,`category_id`),
  KEY `IDX_C8B6E64A5DA0FB8` (`template_id`),
  KEY `IDX_C8B6E64A12469DE2` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `SummaryTemplateCategories`
--

INSERT INTO `SummaryTemplateCategories` VALUES
(1, 1),
(1, 2),
(2, 1),
(3, 1),
(4, 1),
(5, 1),
(6, 1);

-- --------------------------------------------------------

--
-- Table structure for table `SummaryTemplateFields`
--

CREATE TABLE `SummaryTemplateFields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template_id` int(11) DEFAULT NULL,
  `field_id` int(11) DEFAULT NULL,
  `is_required` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_294381EC5DA0FB8` (`template_id`),
  KEY `IDX_294381EC443707B0` (`field_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=29 ;

--
-- Dumping data for table `SummaryTemplateFields`
--

INSERT INTO `SummaryTemplateFields` VALUES
(1, 1, 1, 1),
(2, 1, 5, 1),
(3, 1, 6, 0),
(4, 1, 2, 0),
(5, 2, 1, 1),
(6, 2, 5, 1),
(7, 2, 7, 1),
(8, 2, 2, 1),
(9, 3, 1, 1),
(10, 3, 5, 1),
(11, 3, 7, 1),
(12, 3, 9, 1),
(13, 3, 2, 1),
(14, 4, 1, 1),
(15, 4, 5, 1),
(16, 4, 7, 1),
(17, 4, 9, 1),
(18, 4, 2, 1),
(19, 5, 1, 1),
(20, 5, 5, 1),
(21, 5, 7, 1),
(22, 5, 9, 1),
(23, 5, 2, 1),
(24, 6, 1, 1),
(25, 6, 5, 1),
(26, 6, 7, 1),
(27, 6, 9, 1),
(28, 6, 6, 0);

-- --------------------------------------------------------

--
-- Table structure for table `SummaryTemplates`
--

CREATE TABLE `SummaryTemplates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `icon` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_5E3C9832CE45CBB0` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `SummaryTemplates`
--

INSERT INTO `SummaryTemplates` VALUES
(1, 'blank.png', 'Default Summary Template', 'default', NULL),
(2, 'blank.png', 'Blog Image Left', 'blog_image_left', NULL),
(3, 'blank.png', 'Blog Image Right', 'blog_image_right', NULL),
(4, 'blank.png', 'Blog Image Top', 'blog_image_top', NULL),
(5, 'blank.png', 'Blog Entry Card', 'blog_entry_card', NULL),
(6, 'blank.png', 'Resource Page Entry', 'resource_page', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `SummaryTemplateTags`
--

CREATE TABLE `SummaryTemplateTags` (
  `template_id` int(11) NOT NULL,
  `designtag_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`template_id`,`designtag_id`),
  KEY `IDX_D9197F515DA0FB8` (`template_id`),
  KEY `IDX_D9197F51960BFEAE` (`designtag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `SystemAntispamLibraries`
--

CREATE TABLE `SystemAntispamLibraries` (
  `saslHandle` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `saslName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `saslIsActive` tinyint(1) NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`saslHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `SystemCaptchaLibraries`
--

CREATE TABLE `SystemCaptchaLibraries` (
  `sclHandle` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sclName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sclIsActive` tinyint(1) NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`sclHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `SystemCaptchaLibraries`
--

INSERT INTO `SystemCaptchaLibraries` VALUES
('recaptchaV3', 'reCAPTCHA v3', 0, 0),
('securimage', 'SecurImage (Default)', 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `SystemContentEditorSnippets`
--

CREATE TABLE `SystemContentEditorSnippets` (
  `scsHandle` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `scsName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `scsIsActive` tinyint(1) NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`scsHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `SystemContentEditorSnippets`
--

INSERT INTO `SystemContentEditorSnippets` VALUES
('page_name', 'Page Name', 1, 0),
('user_name', 'User Name', 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `SystemDatabaseMigrations`
--

CREATE TABLE `SystemDatabaseMigrations` (
  `version` varchar(14) COLLATE utf8mb4_unicode_ci NOT NULL,
  `executed_at` datetime NOT NULL COMMENT '(DC2Type:datetime_immutable)',
  PRIMARY KEY (`version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `SystemDatabaseMigrations`
--

INSERT INTO `SystemDatabaseMigrations` VALUES
('20140919000000', '[[date_gmt]]'),
('20140930000000', '[[date_gmt]]'),
('20141017000000', '[[date_gmt]]'),
('20141024000000', '[[date_gmt]]'),
('20141113000000', '[[date_gmt]]'),
('20141219000000', '[[date_gmt]]'),
('20150109000000', '[[date_gmt]]'),
('20150504000000', '[[date_gmt]]'),
('20150515000000', '[[date_gmt]]'),
('20150610000000', '[[date_gmt]]'),
('20150612000000', '[[date_gmt]]'),
('20150615000000', '[[date_gmt]]'),
('20150616000000', '[[date_gmt]]'),
('20150619000000', '[[date_gmt]]'),
('20150622000000', '[[date_gmt]]'),
('20150623000000', '[[date_gmt]]'),
('20150713000000', '[[date_gmt]]'),
('20150731000000', '[[date_gmt]]'),
('20151221000000', '[[date_gmt]]'),
('20160107000000', '[[date_gmt]]'),
('20160213000000', '[[date_gmt]]'),
('20160314000000', '[[date_gmt]]'),
('20160412000000', '[[date_gmt]]'),
('20160615000000', '[[date_gmt]]'),
('20160725000000', '[[date_gmt]]'),
('20161109000000', '[[date_gmt]]'),
('20161203000000', '[[date_gmt]]'),
('20161208000000', '[[date_gmt]]'),
('20161216000000', '[[date_gmt]]'),
('20161216100000', '[[date_gmt]]'),
('20170118000000', '[[date_gmt]]'),
('20170123000000', '[[date_gmt]]'),
('20170201000000', '[[date_gmt]]'),
('20170202000000', '[[date_gmt]]'),
('20170227063249', '[[date_gmt]]'),
('20170313000000', '[[date_gmt]]'),
('20170316000000', '[[date_gmt]]'),
('20170404000000', '[[date_gmt]]'),
('20170406000000', '[[date_gmt]]'),
('20170407000001', '[[date_gmt]]'),
('20170412000000', '[[date_gmt]]'),
('20170418000000', '[[date_gmt]]'),
('20170420000000', '[[date_gmt]]'),
('20170421000000', '[[date_gmt]]'),
('20170424000000', '[[date_gmt]]'),
('20170505000000', '[[date_gmt]]'),
('20170512000000', '[[date_gmt]]'),
('20170519000000', '[[date_gmt]]'),
('20170608000000', '[[date_gmt]]'),
('20170608100000', '[[date_gmt]]'),
('20170609000000', '[[date_gmt]]'),
('20170609100000', '[[date_gmt]]'),
('20170610000000', '[[date_gmt]]'),
('20170611000000', '[[date_gmt]]'),
('20170613000000', '[[date_gmt]]'),
('20170614000000', '[[date_gmt]]'),
('20170626000000', '[[date_gmt]]'),
('20170711151953', '[[date_gmt]]'),
('20170731021618', '[[date_gmt]]'),
('20170802000000', '[[date_gmt]]'),
('20170804000000', '[[date_gmt]]'),
('20170810000000', '[[date_gmt]]'),
('20170818000000', '[[date_gmt]]'),
('20170824000000', '[[date_gmt]]'),
('20170905000000', '[[date_gmt]]'),
('20170915000000', '[[date_gmt]]'),
('20170926000000', '[[date_gmt]]'),
('20171012000000', '[[date_gmt]]'),
('20171025000000', '[[date_gmt]]'),
('20171109000000', '[[date_gmt]]'),
('20171109065758', '[[date_gmt]]'),
('20171110032423', '[[date_gmt]]'),
('20171121000000', '[[date_gmt]]'),
('20171129190607', '[[date_gmt]]'),
('20171218000000', '[[date_gmt]]'),
('20171221194440', '[[date_gmt]]'),
('20180119000000', '[[date_gmt]]'),
('20180122213656', '[[date_gmt]]'),
('20180122220813', '[[date_gmt]]'),
('20180123000000', '[[date_gmt]]'),
('20180126000000', '[[date_gmt]]'),
('20180130000000', '[[date_gmt]]'),
('20180212000000', '[[date_gmt]]'),
('20180213000000', '[[date_gmt]]'),
('20180227035239', '[[date_gmt]]'),
('20180308043255', '[[date_gmt]]'),
('20180328215345', '[[date_gmt]]'),
('20180329183749', '[[date_gmt]]'),
('20180330080830', '[[date_gmt]]'),
('20180403143200', '[[date_gmt]]'),
('20180518153531', '[[date_gmt]]'),
('20180524000000', '[[date_gmt]]'),
('20180531000000', '[[date_gmt]]'),
('20180604000000', '[[date_gmt]]'),
('20180609000000', '[[date_gmt]]'),
('20180615000000', '[[date_gmt]]'),
('20180617000000', '[[date_gmt]]'),
('20180621222449', '[[date_gmt]]'),
('20180622192332', '[[date_gmt]]'),
('20180627000000', '[[date_gmt]]'),
('20180709175202', '[[date_gmt]]'),
('20180710203437', '[[date_gmt]]'),
('20180716000000', '[[date_gmt]]'),
('20180717000000', '[[date_gmt]]'),
('20180813220933', '[[date_gmt]]'),
('20180816210727', '[[date_gmt]]'),
('20180820205800', '[[date_gmt]]'),
('20180831213421', '[[date_gmt]]'),
('20180904165911', '[[date_gmt]]'),
('20180907091500', '[[date_gmt]]'),
('20180910000000', '[[date_gmt]]'),
('20180912113737', '[[date_gmt]]'),
('20180920000000', '[[date_gmt]]'),
('20180926000000', '[[date_gmt]]'),
('20180926070200', '[[date_gmt]]'),
('20180926070300', '[[date_gmt]]'),
('20181006212300', '[[date_gmt]]'),
('20181006212400', '[[date_gmt]]'),
('20181019010145', '[[date_gmt]]'),
('20181029223809', '[[date_gmt]]'),
('20181105102800', '[[date_gmt]]'),
('20181112211702', '[[date_gmt]]'),
('20181116072400', '[[date_gmt]]'),
('20181211000000', '[[date_gmt]]'),
('20181211100000', '[[date_gmt]]'),
('20181212000000', '[[date_gmt]]'),
('20181212221911', '[[date_gmt]]'),
('20181222183445', '[[date_gmt]]'),
('20190106000000', '[[date_gmt]]'),
('20190110194848', '[[date_gmt]]'),
('20190110231015', '[[date_gmt]]'),
('20190111181236', '[[date_gmt]]'),
('20190112000000', '[[date_gmt]]'),
('20190129000000', '[[date_gmt]]'),
('20190225000000', '[[date_gmt]]'),
('20190225184524', '[[date_gmt]]'),
('20190301133300', '[[date_gmt]]'),
('20190309000000', '[[date_gmt]]'),
('20190310000000', '[[date_gmt]]'),
('20190416224702', '[[date_gmt]]'),
('20190417180607', '[[date_gmt]]'),
('20190422235040', '[[date_gmt]]'),
('20190504005632', '[[date_gmt]]'),
('20190508232235', '[[date_gmt]]'),
('20190509000000', '[[date_gmt]]'),
('20190509205043', '[[date_gmt]]'),
('20190513164028', '[[date_gmt]]'),
('20190516204806', '[[date_gmt]]'),
('20190520171430', '[[date_gmt]]'),
('20190522202749', '[[date_gmt]]'),
('20190619141521', '[[date_gmt]]'),
('20190625177700', '[[date_gmt]]'),
('20190625177710', '[[date_gmt]]'),
('20190708000000', '[[date_gmt]]'),
('20190717090600', '[[date_gmt]]'),
('20190817000000', '[[date_gmt]]'),
('20190822160700', '[[date_gmt]]'),
('20190826000000', '[[date_gmt]]'),
('20190925072210', '[[date_gmt]]'),
('20191002000000', '[[date_gmt]]'),
('20191029175713', '[[date_gmt]]'),
('20200116115000', '[[date_gmt]]'),
('20200118043285', '[[date_gmt]]'),
('20200203000000', '[[date_gmt]]'),
('20200501000000', '[[date_gmt]]'),
('20200523051311', '[[date_gmt]]'),
('20200604000000', '[[date_gmt]]'),
('20200609145307', '[[date_gmt]]'),
('20200610162600', '[[date_gmt]]'),
('20200611161800', '[[date_gmt]]'),
('20200625191946', '[[date_gmt]]'),
('20200626142348', '[[date_gmt]]'),
('20200810000000', '[[date_gmt]]'),
('20200814143401', '[[date_gmt]]'),
('20200903201537', '[[date_gmt]]'),
('20200923143317', '[[date_gmt]]'),
('20200928000000', '[[date_gmt]]'),
('20200928000001', '[[date_gmt]]'),
('20200928000003', '[[date_gmt]]'),
('20201015174802', '[[date_gmt]]'),
('20201018000000', '[[date_gmt]]'),
('20201022000000', '[[date_gmt]]'),
('20201028143317', '[[date_gmt]]'),
('20201028201040', '[[date_gmt]]'),
('20201031143314', '[[date_gmt]]'),
('20201110150900', '[[date_gmt]]'),
('20201112172200', '[[date_gmt]]'),
('20201119123200', '[[date_gmt]]'),
('20201130130221', '[[date_gmt]]'),
('20201205023211', '[[date_gmt]]'),
('20201229143500', '[[date_gmt]]'),
('20201231153200', '[[date_gmt]]'),
('20210128224608', '[[date_gmt]]'),
('20210205193115', '[[date_gmt]]'),
('20210216184000', '[[date_gmt]]'),
('20210331213100', '[[date_gmt]]'),
('20210428212600', '[[date_gmt]]'),
('20210528170900', '[[date_gmt]]'),
('20210616131513', '[[date_gmt]]'),
('20210622145600', '[[date_gmt]]'),
('20210712110100', '[[date_gmt]]'),
('20210718190101', '[[date_gmt]]'),
('20210722225853', '[[date_gmt]]'),
('20210725000000', '[[date_gmt]]'),
('20210729191135', '[[date_gmt]]'),
('20210813173441', '[[date_gmt]]'),
('20210815000000', '[[date_gmt]]'),
('20210910234801', '[[date_gmt]]'),
('20210926145823', '[[date_gmt]]'),
('20211001145301', '[[date_gmt]]'),
('20211020151701', '[[date_gmt]]'),
('20211023155414', '[[date_gmt]]'),
('20211028000000', '[[date_gmt]]'),
('20211102171600', '[[date_gmt]]'),
('20211102171700', '[[date_gmt]]'),
('20211103142609', '[[date_gmt]]'),
('20211104161958', '[[date_gmt]]'),
('20211208145933', '[[date_gmt]]'),
('20220114215506', '[[date_gmt]]'),
('20220210120000', '[[date_gmt]]'),
('20220301185614', '[[date_gmt]]'),
('20220304163335', '[[date_gmt]]'),
('20220307105409', '[[date_gmt]]'),
('20220321122800', '[[date_gmt]]'),
('20220331222557', '[[date_gmt]]'),
('20220408000000', '[[date_gmt]]'),
('20220503000000', '[[date_gmt]]'),
('20220516191423', '[[date_gmt]]'),
('20220614180000', '[[date_gmt]]'),
('20220812035034', '[[date_gmt]]'),
('20220908074900', '[[date_gmt]]'),
('20220909000000', '[[date_gmt]]'),
('20220909100000', '[[date_gmt]]'),
('20220909200000', '[[date_gmt]]'),
('20220909300000', '[[date_gmt]]'),
('20220911000000', '[[date_gmt]]'),
('20220919000000', '[[date_gmt]]'),
('20221012183922', '[[date_gmt]]'),
('20221121152044', '[[date_gmt]]'),
('20221122000000', '[[date_gmt]]'),
('20221219220600', '[[date_gmt]]'),
('20230107185800', '[[date_gmt]]'),
('20230127095217', '[[date_gmt]]'),
('20230225150942', '[[date_gmt]]'),
('20230308163514', '[[date_gmt]]'),
('20230503095900', '[[date_gmt]]'),
('20230812015937', '[[date_gmt]]'),
('20230905000000', '[[date_gmt]]'),
('20230924000000', '[[date_gmt]]'),
('20231002142400', '[[date_gmt]]'),
('20231207100748', '[[date_gmt]]'),
('20240119210413', '[[date_gmt]]'),
('20240122172319', '[[date_gmt]]'),
('20240506191622', '[[date_gmt]]'),
('20240508000000', '[[date_gmt]]'),
('20240515173142', '[[date_gmt]]'),
('20240618202000', '[[date_gmt]]'),
('20240711000000', '[[date_gmt]]'),
('20240910000000', '[[date_gmt]]'),
('20241115093300', '[[date_gmt]]'),
('20241126174022', '[[date_gmt]]'),
('20241204161559', '[[date_gmt]]'),
('20241210181033', '[[date_gmt]]'),
('20241217194138', '[[date_gmt]]'),
('20250227155410', '[[date_gmt]]');

-- --------------------------------------------------------

--
-- Table structure for table `SystemDatabaseQueryLog`
--

CREATE TABLE `SystemDatabaseQueryLog` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `query` text COLLATE utf8mb4_unicode_ci,
  `params` text COLLATE utf8mb4_unicode_ci,
  `executionMS` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `Tasks`
--

CREATE TABLE `Tasks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `handle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `dateLastStarted` int(11) DEFAULT NULL,
  `dateLastCompleted` int(11) DEFAULT NULL,
  `uID` int(10) unsigned DEFAULT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_91994A93918020D9` (`handle`),
  KEY `IDX_91994A93FD71026C` (`uID`),
  KEY `IDX_91994A93CE45CBB0` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=16 ;

--
-- Dumping data for table `Tasks`
--

INSERT INTO `Tasks` VALUES
(1, 'clear_cache', NULL, NULL, NULL, NULL),
(2, 'generate_sitemap', NULL, NULL, NULL, NULL),
(3, 'rescan_files', NULL, NULL, NULL, NULL),
(4, 'check_automated_groups', NULL, NULL, NULL, NULL),
(5, 'deactivate_users', NULL, NULL, NULL, NULL),
(6, 'remove_old_page_versions', NULL, NULL, NULL, NULL),
(7, 'reindex_content', NULL, NULL, NULL, NULL),
(8, 'process_email', NULL, NULL, NULL, NULL),
(9, 'update_statistics', NULL, NULL, NULL, NULL),
(10, 'generate_thumbnails', NULL, NULL, NULL, NULL),
(11, 'remove_old_file_attachments', NULL, NULL, NULL, NULL),
(12, 'remove_unvalidated_users', NULL, NULL, NULL, NULL),
(13, 'production_status', NULL, NULL, NULL, NULL),
(14, 'page_cache_report', NULL, NULL, NULL, NULL),
(15, 'custom_javascript_report', NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `TaskSets`
--

CREATE TABLE `TaskSets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `handle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `displayOrder` int(10) unsigned NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `handle` (`handle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `TaskSets`
--

INSERT INTO `TaskSets` VALUES
(1, 'maintenance', 'Maintenance', 0, NULL),
(2, 'seo', 'SEO and Search', 1, NULL),
(3, 'user_groups', 'Users and Groups', 2, NULL),
(4, 'site_health', 'Site Health', 3, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `TaskSetTasks`
--

CREATE TABLE `TaskSetTasks` (
  `task_id` int(10) unsigned NOT NULL,
  `set_id` int(10) unsigned NOT NULL,
  `displayOrder` int(10) unsigned NOT NULL,
  PRIMARY KEY (`task_id`,`set_id`),
  KEY `IDX_D395AA388DB60186` (`task_id`),
  KEY `IDX_D395AA3810FB0D18` (`set_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `TaskSetTasks`
--

INSERT INTO `TaskSetTasks` VALUES
(1, 1, 0),
(2, 2, 0),
(3, 1, 1),
(4, 3, 0),
(5, 3, 1),
(6, 1, 2),
(7, 2, 1),
(8, 3, 2),
(9, 2, 2),
(10, 1, 4),
(11, 1, 3),
(12, 3, 3),
(13, 4, 0),
(14, 4, 1),
(15, 4, 2);

-- --------------------------------------------------------

--
-- Table structure for table `TopicTrees`
--

CREATE TABLE `TopicTrees` (
  `treeID` int(10) unsigned NOT NULL DEFAULT '0',
  `topicTreeName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`treeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `TreeExpressEntrySiteResultNodes`
--

CREATE TABLE `TreeExpressEntrySiteResultNodes` (
  `treeNodeID` int(10) unsigned NOT NULL,
  `siteID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`treeNodeID`),
  KEY `siteID` (`siteID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `TreeFileFolderNodes`
--

CREATE TABLE `TreeFileFolderNodes` (
  `treeNodeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fslID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`treeNodeID`),
  KEY `fslID` (`fslID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `TreeFileNodes`
--

CREATE TABLE `TreeFileNodes` (
  `treeNodeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`treeNodeID`),
  KEY `fID` (`fID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `TreeGroupFolderNodes`
--

CREATE TABLE `TreeGroupFolderNodes` (
  `treeNodeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contains` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`treeNodeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `TreeGroupFolderNodeSelectedGroupTypes`
--

CREATE TABLE `TreeGroupFolderNodeSelectedGroupTypes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `treeNodeID` int(10) unsigned DEFAULT '0',
  `gtID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `TreeGroupNodes`
--

CREATE TABLE `TreeGroupNodes` (
  `treeNodeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`treeNodeID`),
  KEY `gID` (`gID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `TreeGroupNodes`
--

INSERT INTO `TreeGroupNodes` VALUES
(2, 1),
(3, 2),
(4, 3);

-- --------------------------------------------------------

--
-- Table structure for table `TreeNodePermissionAssignments`
--

CREATE TABLE `TreeNodePermissionAssignments` (
  `treeNodeID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`treeNodeID`,`pkID`,`paID`),
  KEY `pkID` (`pkID`),
  KEY `paID` (`paID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `TreeNodePermissionAssignments`
--

INSERT INTO `TreeNodePermissionAssignments` VALUES
(7, 39, 68),
(7, 40, 69),
(7, 41, 70),
(7, 42, 71),
(7, 43, 72),
(7, 44, 73),
(7, 45, 74),
(7, 46, 76),
(7, 47, 75),
(7, 48, 77),
(7, 66, 65),
(5, 117, 59),
(6, 117, 54),
(5, 118, 55),
(6, 118, 58),
(5, 119, 56),
(6, 119, 56),
(5, 120, 57),
(6, 120, 57),
(1, 124, 119),
(1, 125, 120),
(1, 126, 121),
(1, 127, 122),
(1, 128, 125),
(1, 129, 123),
(1, 130, 124);

-- --------------------------------------------------------

--
-- Table structure for table `TreeNodes`
--

CREATE TABLE `TreeNodes` (
  `treeNodeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `treeNodeTypeID` int(10) unsigned DEFAULT '0',
  `treeID` int(10) unsigned DEFAULT '0',
  `treeNodeParentID` int(10) unsigned DEFAULT '0',
  `treeNodeDisplayOrder` int(10) unsigned DEFAULT '0',
  `treeNodeName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `dateModified` datetime DEFAULT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `treeNodeOverridePermissions` tinyint(1) DEFAULT '0',
  `inheritPermissionsFromTreeNodeID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`treeNodeID`),
  KEY `treeNodeParentID` (`treeNodeParentID`),
  KEY `treeNodeTypeID` (`treeNodeTypeID`),
  KEY `treeID` (`treeID`),
  KEY `inheritPermissionsFromTreeNodeID` (`inheritPermissionsFromTreeNodeID`,`treeNodeID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `TreeNodes`
--

INSERT INTO `TreeNodes` VALUES
(1, 2, 1, 0, 0, '', '[[date_gmt]]', '[[date_gmt]]', 1, 1),
(2, 1, 1, 1, 0, '', '[[date_gmt]]', '[[date_gmt]]', 0, 1),
(3, 1, 1, 1, 1, '', '[[date_gmt]]', '[[date_gmt]]', 0, 1),
(4, 1, 1, 1, 2, '', '[[date_gmt]]', '[[date_gmt]]', 0, 1),
(5, 4, 2, 0, 0, '', '[[date_gmt]]', '[[date_gmt]]', 1, 5),
(6, 4, 2, 5, 0, 'Forms', '[[date_gmt]]', '[[date_gmt]]', 1, 6),
(7, 9, 3, 0, 0, '', '[[date_gmt]]', '[[date_gmt]]', 1, 7);

-- --------------------------------------------------------

--
-- Table structure for table `TreeNodeTypes`
--

CREATE TABLE `TreeNodeTypes` (
  `treeNodeTypeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `treeNodeTypeHandle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `pkgID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`treeNodeTypeID`),
  UNIQUE KEY `treeNodeTypeHandle` (`treeNodeTypeHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=11 ;

--
-- Dumping data for table `TreeNodeTypes`
--

INSERT INTO `TreeNodeTypes` VALUES
(1, 'group', 0),
(2, 'group_folder', 0),
(3, 'category', 0),
(4, 'express_entry_category', 0),
(5, 'express_entry_results', 0),
(6, 'express_entry_site_results', 0),
(7, 'topic', 0),
(8, 'file', 0),
(9, 'file_folder', 0),
(10, 'search_preset', 0);

-- --------------------------------------------------------

--
-- Table structure for table `Trees`
--

CREATE TABLE `Trees` (
  `treeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `treeTypeID` int(10) unsigned DEFAULT '0',
  `treeDateAdded` datetime DEFAULT NULL,
  `rootTreeNodeID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`treeID`),
  KEY `treeTypeID` (`treeTypeID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `Trees`
--

INSERT INTO `Trees` VALUES
(1, 1, '[[date_gmt]]', 1),
(2, 2, '[[date_gmt]]', 5),
(3, 4, '[[date_gmt]]', 7);

-- --------------------------------------------------------

--
-- Table structure for table `TreeSearchQueryNodes`
--

CREATE TABLE `TreeSearchQueryNodes` (
  `treeNodeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `savedSearchID` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`treeNodeID`),
  KEY `savedSearchID` (`savedSearchID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `TreeTypes`
--

CREATE TABLE `TreeTypes` (
  `treeTypeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `treeTypeHandle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `pkgID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`treeTypeID`),
  UNIQUE KEY `treeTypeHandle` (`treeTypeHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `TreeTypes`
--

INSERT INTO `TreeTypes` VALUES
(1, 'group', 0),
(2, 'express_entry_results', 0),
(3, 'topic', 0),
(4, 'file_manager', 0);

-- --------------------------------------------------------

--
-- Table structure for table `UsedStringLog`
--

CREATE TABLE `UsedStringLog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `usedString` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_4E83837CF5E609AF` (`usedString`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `UserAttributeKeys`
--

CREATE TABLE `UserAttributeKeys` (
  `uakProfileDisplay` tinyint(1) NOT NULL,
  `uakProfileEdit` tinyint(1) NOT NULL,
  `uakProfileEditRequired` tinyint(1) NOT NULL,
  `uakRegisterEdit` tinyint(1) NOT NULL,
  `uakRegisterEditRequired` tinyint(1) NOT NULL,
  `uakMemberListDisplay` tinyint(1) NOT NULL,
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `UserAttributeKeys`
--

INSERT INTO `UserAttributeKeys` VALUES
(0, 1, 0, 1, 0, 0, 15),
(0, 1, 0, 1, 0, 0, 16),
(0, 0, 0, 0, 0, 0, 19);

-- --------------------------------------------------------

--
-- Table structure for table `UserAttributeValues`
--

CREATE TABLE `UserAttributeValues` (
  `uID` int(10) unsigned NOT NULL,
  `akID` int(10) unsigned NOT NULL,
  `avID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`uID`,`akID`),
  KEY `IDX_4DB68CA6FD71026C` (`uID`),
  KEY `IDX_4DB68CA6B6561A7E` (`akID`),
  KEY `IDX_4DB68CA6A2A82A5D` (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `UserDeactivatedNotifications`
--

CREATE TABLE `UserDeactivatedNotifications` (
  `userID` int(10) unsigned NOT NULL,
  `actorID` int(10) unsigned DEFAULT NULL,
  `nID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`nID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `UserFavoriteFolders`
--

CREATE TABLE `UserFavoriteFolders` (
  `treeNodeFolderId` int(10) unsigned NOT NULL,
  `uID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`uID`,`treeNodeFolderId`),
  KEY `IDX_EDB1ABB6FD71026C` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `UserGroups`
--

CREATE TABLE `UserGroups` (
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  `gID` int(10) unsigned NOT NULL DEFAULT '0',
  `grID` int(10) unsigned NOT NULL DEFAULT '0',
  `ugEntered` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY (`uID`,`gID`,`grID`),
  KEY `uID` (`uID`),
  KEY `gID` (`gID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `UserLoginAttempts`
--

CREATE TABLE `UserLoginAttempts` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `userId` int(10) unsigned NOT NULL,
  `utcDate` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `UserPermissionEditPropertyAccessList`
--

CREATE TABLE `UserPermissionEditPropertyAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `uName` tinyint(1) DEFAULT '0',
  `uEmail` tinyint(1) DEFAULT '0',
  `uPassword` tinyint(1) DEFAULT '0',
  `uAvatar` tinyint(1) DEFAULT '0',
  `uTimezone` tinyint(1) DEFAULT '0',
  `uDefaultLanguage` tinyint(1) DEFAULT '0',
  `uHomeFileManagerFolderID` tinyint(1) DEFAULT '0',
  `attributePermission` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `UserPermissionEditPropertyAttributeAccessListCustom`
--

CREATE TABLE `UserPermissionEditPropertyAttributeAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `akID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`akID`),
  KEY `peID` (`peID`),
  KEY `akID` (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `UserPermissionViewAttributeAccessList`
--

CREATE TABLE `UserPermissionViewAttributeAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`),
  KEY `peID` (`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `UserPermissionViewAttributeAccessListCustom`
--

CREATE TABLE `UserPermissionViewAttributeAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `akID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`akID`),
  KEY `peID` (`peID`),
  KEY `akID` (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `UserPrivateMessages`
--

CREATE TABLE `UserPrivateMessages` (
  `msgID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uAuthorID` int(10) unsigned NOT NULL DEFAULT '0',
  `msgDateCreated` datetime NOT NULL,
  `msgSubject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `msgBody` text COLLATE utf8mb4_unicode_ci,
  `uToID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`msgID`),
  KEY `uAuthorID` (`uAuthorID`,`msgDateCreated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `UserPrivateMessagesAttachments`
--

CREATE TABLE `UserPrivateMessagesAttachments` (
  `msgID` int(10) unsigned NOT NULL DEFAULT '0',
  `fID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`msgID`,`fID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `UserPrivateMessagesTo`
--

CREATE TABLE `UserPrivateMessagesTo` (
  `msgID` int(10) unsigned NOT NULL DEFAULT '0',
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  `uAuthorID` int(10) unsigned NOT NULL DEFAULT '0',
  `msgMailboxID` int(11) NOT NULL,
  `msgIsNew` tinyint(1) NOT NULL DEFAULT '0',
  `msgIsUnread` tinyint(1) NOT NULL DEFAULT '0',
  `msgIsReplied` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`msgID`,`uID`,`uAuthorID`,`msgMailboxID`),
  KEY `uID` (`uID`),
  KEY `uAuthorID` (`uAuthorID`),
  KEY `msgFolderID` (`msgMailboxID`),
  KEY `msgIsNew` (`msgIsNew`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `Users`
--

CREATE TABLE `Users` (
  `uID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uName` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uEmail` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uPassword` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uIsActive` tinyint(1) NOT NULL,
  `uIsFullRecord` tinyint(1) NOT NULL,
  `uIsValidated` tinyint(1) NOT NULL DEFAULT '-1',
  `uDateAdded` datetime NOT NULL,
  `uLastPasswordChange` datetime NOT NULL,
  `uDateLastUpdated` datetime DEFAULT NULL,
  `uHasAvatar` tinyint(1) NOT NULL,
  `uLastOnline` int(10) unsigned NOT NULL DEFAULT '0',
  `uLastLogin` int(10) unsigned NOT NULL DEFAULT '0',
  `uPreviousLogin` int(10) unsigned DEFAULT '0',
  `uNumLogins` int(10) unsigned NOT NULL DEFAULT '0',
  `uLastAuthTypeID` int(10) unsigned NOT NULL DEFAULT '0',
  `uLastIP` longtext COLLATE utf8mb4_unicode_ci,
  `uTimezone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uDefaultLanguage` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uIsPasswordReset` tinyint(1) NOT NULL,
  `uHomeFileManagerFolderID` int(10) unsigned DEFAULT NULL,
  `ignoredIPMismatches` longtext COLLATE utf8mb4_unicode_ci COMMENT '(DC2Type:simple_array)',
  PRIMARY KEY (`uID`),
  UNIQUE KEY `UNIQ_D5428AED28459686` (`uName`),
  KEY `uEmail` (`uEmail`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `Users`
--

INSERT INTO `Users` VALUES
(1, '[[admin_username]]', '[[admin_email]]', '[[admin_pass]]', 1, 1, 1, '[[date_gmt]]', '[[date_gmt]]', '[[date_gmt]]', 0, 0, [[timestamp]], 0, 1, 0, '[[longip]]', NULL, NULL, 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `UserSearchIndexAttributes`
--

CREATE TABLE `UserSearchIndexAttributes` (
  `uID` int(10) unsigned NOT NULL,
  `ak_profile_private_messages_enabled` tinyint(1) DEFAULT '0',
  `ak_profile_private_messages_notification_enabled` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `UserSignupNotifications`
--

CREATE TABLE `UserSignupNotifications` (
  `usID` int(10) unsigned DEFAULT NULL,
  `nID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`nID`),
  KEY `IDX_7FB1DF5B7B18287E` (`usID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `UserSignups`
--

CREATE TABLE `UserSignups` (
  `usID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uID` int(10) unsigned DEFAULT NULL,
  `createdBy` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`usID`),
  UNIQUE KEY `UNIQ_FEB5D909FD71026C` (`uID`),
  KEY `IDX_FEB5D909D3564642` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `UserValidationHashes`
--

CREATE TABLE `UserValidationHashes` (
  `uvhID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uID` int(10) unsigned DEFAULT NULL,
  `uHash` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` smallint(5) unsigned NOT NULL DEFAULT '0',
  `uDateGenerated` int(10) unsigned NOT NULL DEFAULT '0',
  `uDateRedeemed` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`uvhID`),
  KEY `uID` (`uID`,`type`),
  KEY `uHash` (`uHash`,`type`),
  KEY `uDateGenerated` (`uDateGenerated`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `UserWorkflowProgress`
--

CREATE TABLE `UserWorkflowProgress` (
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  `wpID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`uID`,`wpID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `WorkflowProgress`
--

CREATE TABLE `WorkflowProgress` (
  `wpID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wpCategoryID` int(10) unsigned DEFAULT NULL,
  `wfID` int(10) unsigned NOT NULL DEFAULT '0',
  `wpApproved` tinyint(1) NOT NULL DEFAULT '0',
  `wpDateAdded` datetime DEFAULT NULL,
  `wpDateLastAction` datetime DEFAULT NULL,
  `wpCurrentStatus` int(11) NOT NULL DEFAULT '0',
  `wrID` int(11) NOT NULL DEFAULT '0',
  `wpIsCompleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`wpID`),
  KEY `wpCategoryID` (`wpCategoryID`),
  KEY `wfID` (`wfID`),
  KEY `wrID` (`wrID`,`wpID`,`wpIsCompleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `WorkflowProgressCategories`
--

CREATE TABLE `WorkflowProgressCategories` (
  `wpCategoryID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wpCategoryHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`wpCategoryID`),
  UNIQUE KEY `wpCategoryHandle` (`wpCategoryHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `WorkflowProgressCategories`
--

INSERT INTO `WorkflowProgressCategories` VALUES
(1, 'page', NULL),
(2, 'file', NULL),
(3, 'user', NULL),
(4, 'calendar_event', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `WorkflowProgressHistory`
--

CREATE TABLE `WorkflowProgressHistory` (
  `wphID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wpID` int(10) unsigned NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `object` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`wphID`),
  KEY `wpID` (`wpID`,`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `WorkflowProgressNotifications`
--

CREATE TABLE `WorkflowProgressNotifications` (
  `wpID` int(10) unsigned NOT NULL,
  `nID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`nID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `WorkflowRequestObjects`
--

CREATE TABLE `WorkflowRequestObjects` (
  `wrID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wrObject` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`wrID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `Workflows`
--

CREATE TABLE `Workflows` (
  `wfID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wfName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `wftID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`wfID`),
  UNIQUE KEY `wfName` (`wfName`),
  KEY `wftID` (`wftID`,`wfID`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `WorkflowTypes`
--

CREATE TABLE `WorkflowTypes` (
  `wftID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wftHandle` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `wftName` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`wftID`),
  UNIQUE KEY `wftHandle` (`wftHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `WorkflowTypes`
--

INSERT INTO `WorkflowTypes` VALUES
(1, 'basic', 'Basic Workflow', 0);

--
-- Constraints for dumped tables
--

--
-- Constraints for table `AnnouncementUserViews`
--
ALTER TABLE `AnnouncementUserViews`
  ADD CONSTRAINT `FK_B721E7B9913AEA17` FOREIGN KEY (`announcement_id`) REFERENCES `Announcements` (`id`),
  ADD CONSTRAINT `FK_B721E7B9FD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`) ON DELETE CASCADE;

--
-- Constraints for table `AreaLayoutsUsingPresets`
--
ALTER TABLE `AreaLayoutsUsingPresets`
  ADD CONSTRAINT `FK_7A9049A1385521EA` FOREIGN KEY (`arLayoutID`) REFERENCES `AreaLayouts` (`arLayoutID`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `atAddress`
--
ALTER TABLE `atAddress`
  ADD CONSTRAINT `FK_DA949740A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`) ON DELETE CASCADE;

--
-- Constraints for table `atAddressSettings`
--
ALTER TABLE `atAddressSettings`
  ADD CONSTRAINT `FK_5A737B61B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `atBoolean`
--
ALTER TABLE `atBoolean`
  ADD CONSTRAINT `FK_5D5F70A9A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`) ON DELETE CASCADE;

--
-- Constraints for table `atBooleanSettings`
--
ALTER TABLE `atBooleanSettings`
  ADD CONSTRAINT `FK_78025F47B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `atDateTime`
--
ALTER TABLE `atDateTime`
  ADD CONSTRAINT `FK_DF75412AA2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`) ON DELETE CASCADE;

--
-- Constraints for table `atDateTimeSettings`
--
ALTER TABLE `atDateTimeSettings`
  ADD CONSTRAINT `FK_C6B3B63AB6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `atDefault`
--
ALTER TABLE `atDefault`
  ADD CONSTRAINT `FK_3484F81EA2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`) ON DELETE CASCADE;

--
-- Constraints for table `atDuration`
--
ALTER TABLE `atDuration`
  ADD CONSTRAINT `FK_6AEBA81EA2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`) ON DELETE CASCADE;

--
-- Constraints for table `atDurationSettings`
--
ALTER TABLE `atDurationSettings`
  ADD CONSTRAINT `FK_AE47F82EB6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `atEmptySettings`
--
ALTER TABLE `atEmptySettings`
  ADD CONSTRAINT `FK_ED1BF189B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `atExpress`
--
ALTER TABLE `atExpress`
  ADD CONSTRAINT `FK_CFAF40F1A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`) ON DELETE CASCADE;

--
-- Constraints for table `atExpressSelectedEntries`
--
ALTER TABLE `atExpressSelectedEntries`
  ADD CONSTRAINT `FK_C9D404BB6DCB6296` FOREIGN KEY (`exEntryID`) REFERENCES `ExpressEntityEntries` (`exEntryID`),
  ADD CONSTRAINT `FK_C9D404BBA2A82A5D` FOREIGN KEY (`avID`) REFERENCES `atExpress` (`avID`);

--
-- Constraints for table `atExpressSettings`
--
ALTER TABLE `atExpressSettings`
  ADD CONSTRAINT `FK_E8F67F0FB6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`),
  ADD CONSTRAINT `FK_E8F67F0FCE2D7284` FOREIGN KEY (`exEntityID`) REFERENCES `ExpressEntities` (`id`);

--
-- Constraints for table `atFile`
--
ALTER TABLE `atFile`
  ADD CONSTRAINT `FK_73D17D61A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_73D17D61E3111F45` FOREIGN KEY (`fID`) REFERENCES `Files` (`fID`) ON DELETE CASCADE;

--
-- Constraints for table `atFileSettings`
--
ALTER TABLE `atFileSettings`
  ADD CONSTRAINT `FK_EADD86C8B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `atNumber`
--
ALTER TABLE `atNumber`
  ADD CONSTRAINT `FK_41BA30B5A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`) ON DELETE CASCADE;

--
-- Constraints for table `atSelect`
--
ALTER TABLE `atSelect`
  ADD CONSTRAINT `FK_9CD8C521A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`) ON DELETE CASCADE;

--
-- Constraints for table `atSelectedSocialLinks`
--
ALTER TABLE `atSelectedSocialLinks`
  ADD CONSTRAINT `FK_10743709A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `atSocialLinks` (`avID`);

--
-- Constraints for table `atSelectedTopics`
--
ALTER TABLE `atSelectedTopics`
  ADD CONSTRAINT `FK_E42A7D5BA2A82A5D` FOREIGN KEY (`avID`) REFERENCES `atTopic` (`avID`);

--
-- Constraints for table `atSelectOptions`
--
ALTER TABLE `atSelectOptions`
  ADD CONSTRAINT `FK_797414B0CB59257C` FOREIGN KEY (`avSelectOptionListID`) REFERENCES `atSelectOptionLists` (`avSelectOptionListID`);

--
-- Constraints for table `atSelectOptionsSelected`
--
ALTER TABLE `atSelectOptionsSelected`
  ADD CONSTRAINT `FK_40C97EC3A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `atSelect` (`avID`),
  ADD CONSTRAINT `FK_40C97EC3E584C274` FOREIGN KEY (`avSelectOptionID`) REFERENCES `atSelectOptions` (`avSelectOptionID`);

--
-- Constraints for table `atSelectSettings`
--
ALTER TABLE `atSelectSettings`
  ADD CONSTRAINT `FK_5D514424B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`),
  ADD CONSTRAINT `FK_5D514424CB59257C` FOREIGN KEY (`avSelectOptionListID`) REFERENCES `atSelectOptionLists` (`avSelectOptionListID`);

--
-- Constraints for table `atSite`
--
ALTER TABLE `atSite`
  ADD CONSTRAINT `FK_960D4295521D8435` FOREIGN KEY (`siteID`) REFERENCES `Sites` (`siteID`),
  ADD CONSTRAINT `FK_960D4295A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`) ON DELETE CASCADE;

--
-- Constraints for table `atSocialLinks`
--
ALTER TABLE `atSocialLinks`
  ADD CONSTRAINT `FK_1431EC8AA2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`) ON DELETE CASCADE;

--
-- Constraints for table `atTextareaSettings`
--
ALTER TABLE `atTextareaSettings`
  ADD CONSTRAINT `FK_A6EA10D6B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `atTextSettings`
--
ALTER TABLE `atTextSettings`
  ADD CONSTRAINT `FK_951A10CCB6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `atTopic`
--
ALTER TABLE `atTopic`
  ADD CONSTRAINT `FK_BABDD1FAA2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`) ON DELETE CASCADE;

--
-- Constraints for table `atTopicSettings`
--
ALTER TABLE `atTopicSettings`
  ADD CONSTRAINT `FK_830FD2FEB6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `AttributeKeyCategories`
--
ALTER TABLE `AttributeKeyCategories`
  ADD CONSTRAINT `FK_A2A0CC67CE45CBB0` FOREIGN KEY (`pkgID`) REFERENCES `Packages` (`pkgID`);

--
-- Constraints for table `AttributeKeys`
--
ALTER TABLE `AttributeKeys`
  ADD CONSTRAINT `FK_DCA32C62A12CFE33` FOREIGN KEY (`atID`) REFERENCES `AttributeTypes` (`atID`),
  ADD CONSTRAINT `FK_DCA32C62B059B76B` FOREIGN KEY (`akCategoryID`) REFERENCES `AttributeKeyCategories` (`akCategoryID`),
  ADD CONSTRAINT `FK_DCA32C62CE45CBB0` FOREIGN KEY (`pkgID`) REFERENCES `Packages` (`pkgID`);

--
-- Constraints for table `AttributeSetKeys`
--
ALTER TABLE `AttributeSetKeys`
  ADD CONSTRAINT `FK_222F72D8A463E8B6` FOREIGN KEY (`asID`) REFERENCES `AttributeSets` (`asID`),
  ADD CONSTRAINT `FK_222F72D8B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `AttributeSets`
--
ALTER TABLE `AttributeSets`
  ADD CONSTRAINT `FK_FCA02D5FB059B76B` FOREIGN KEY (`akCategoryID`) REFERENCES `AttributeKeyCategories` (`akCategoryID`),
  ADD CONSTRAINT `FK_FCA02D5FCE45CBB0` FOREIGN KEY (`pkgID`) REFERENCES `Packages` (`pkgID`);

--
-- Constraints for table `AttributeTypeCategories`
--
ALTER TABLE `AttributeTypeCategories`
  ADD CONSTRAINT `FK_49A9CABEA12CFE33` FOREIGN KEY (`atID`) REFERENCES `AttributeTypes` (`atID`),
  ADD CONSTRAINT `FK_49A9CABEB059B76B` FOREIGN KEY (`akCategoryID`) REFERENCES `AttributeKeyCategories` (`akCategoryID`);

--
-- Constraints for table `AttributeTypes`
--
ALTER TABLE `AttributeTypes`
  ADD CONSTRAINT `FK_53580A7FCE45CBB0` FOREIGN KEY (`pkgID`) REFERENCES `Packages` (`pkgID`);

--
-- Constraints for table `AttributeValues`
--
ALTER TABLE `AttributeValues`
  ADD CONSTRAINT `FK_DCCE7864B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`) ON DELETE CASCADE;

--
-- Constraints for table `atUserGroupSettings`
--
ALTER TABLE `atUserGroupSettings`
  ADD CONSTRAINT `FK_C47871BEB6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `BoardConfiguredDataSourceConfiguration`
--
ALTER TABLE `BoardConfiguredDataSourceConfiguration`
  ADD CONSTRAINT `FK_80879512E2D47DD5` FOREIGN KEY (`configuredDataSourceID`) REFERENCES `BoardConfiguredDataSources` (`configuredDataSourceID`);

--
-- Constraints for table `BoardConfiguredDataSourceConfigurationCalendarEvent`
--
ALTER TABLE `BoardConfiguredDataSourceConfigurationCalendarEvent`
  ADD CONSTRAINT `FK_DE5A529911C85723` FOREIGN KEY (`caID`) REFERENCES `Calendars` (`caID`),
  ADD CONSTRAINT `FK_DE5A52997916C267` FOREIGN KEY (`configurationID`) REFERENCES `BoardConfiguredDataSourceConfiguration` (`configurationID`) ON DELETE CASCADE;

--
-- Constraints for table `BoardConfiguredDataSourceConfigurationPage`
--
ALTER TABLE `BoardConfiguredDataSourceConfigurationPage`
  ADD CONSTRAINT `FK_2C8A71BD7916C267` FOREIGN KEY (`configurationID`) REFERENCES `BoardConfiguredDataSourceConfiguration` (`configurationID`) ON DELETE CASCADE;

--
-- Constraints for table `BoardConfiguredDataSources`
--
ALTER TABLE `BoardConfiguredDataSources`
  ADD CONSTRAINT `FK_481DA3EF2571BEE` FOREIGN KEY (`boardID`) REFERENCES `Boards` (`boardID`),
  ADD CONSTRAINT `FK_481DA3EF3C4EAFF2` FOREIGN KEY (`dataSourceID`) REFERENCES `BoardDataSources` (`dataSourceID`);

--
-- Constraints for table `BoardCustomSlotTemplates`
--
ALTER TABLE `BoardCustomSlotTemplates`
  ADD CONSTRAINT `FK_A972DD602571BEE` FOREIGN KEY (`boardID`) REFERENCES `Boards` (`boardID`),
  ADD CONSTRAINT `FK_A972DD60E7630775` FOREIGN KEY (`slotTemplateID`) REFERENCES `BoardSlotTemplates` (`id`);

--
-- Constraints for table `BoardDataSources`
--
ALTER TABLE `BoardDataSources`
  ADD CONSTRAINT `FK_DACB5A9ACE45CBB0` FOREIGN KEY (`pkgID`) REFERENCES `Packages` (`pkgID`);

--
-- Constraints for table `BoardDesignerCustomElementItems`
--
ALTER TABLE `BoardDesignerCustomElementItems`
  ADD CONSTRAINT `FK_C3E81E43A1BF9938` FOREIGN KEY (`boardItemID`) REFERENCES `BoardItems` (`boardItemID`),
  ADD CONSTRAINT `FK_C3E81E43DA67F394` FOREIGN KEY (`customElementID`) REFERENCES `BoardDesignerCustomElements` (`id`);

--
-- Constraints for table `BoardDesignerCustomElements`
--
ALTER TABLE `BoardDesignerCustomElements`
  ADD CONSTRAINT `FK_D2D0FCBD80D42955` FOREIGN KEY (`slotTemplate_id`) REFERENCES `BoardSlotTemplates` (`id`),
  ADD CONSTRAINT `FK_D2D0FCBDFD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`) ON DELETE SET NULL;

--
-- Constraints for table `BoardInstanceItemBatches`
--
ALTER TABLE `BoardInstanceItemBatches`
  ADD CONSTRAINT `FK_968D5F552E21467` FOREIGN KEY (`boardInstanceID`) REFERENCES `BoardInstances` (`boardInstanceID`);

--
-- Constraints for table `BoardInstanceItems`
--
ALTER TABLE `BoardInstanceItems`
  ADD CONSTRAINT `FK_285D2C822E21467` FOREIGN KEY (`boardInstanceID`) REFERENCES `BoardInstances` (`boardInstanceID`),
  ADD CONSTRAINT `FK_285D2C82A1BF9938` FOREIGN KEY (`boardItemID`) REFERENCES `BoardItems` (`boardItemID`),
  ADD CONSTRAINT `FK_285D2C82E2D47DD5` FOREIGN KEY (`configuredDataSourceID`) REFERENCES `BoardConfiguredDataSources` (`configuredDataSourceID`),
  ADD CONSTRAINT `FK_285D2C82E9D76F8E` FOREIGN KEY (`boardInstanceItemBatchID`) REFERENCES `BoardInstanceItemBatches` (`boardInstanceItemBatchID`);

--
-- Constraints for table `BoardInstanceLogEntries`
--
ALTER TABLE `BoardInstanceLogEntries`
  ADD CONSTRAINT `FK_4CBE00D8EA675D86` FOREIGN KEY (`log_id`) REFERENCES `BoardInstanceLogs` (`id`);

--
-- Constraints for table `BoardInstanceLogs`
--
ALTER TABLE `BoardInstanceLogs`
  ADD CONSTRAINT `FK_BF6A8F2F2E21467` FOREIGN KEY (`boardInstanceID`) REFERENCES `BoardInstances` (`boardInstanceID`);

--
-- Constraints for table `BoardInstances`
--
ALTER TABLE `BoardInstances`
  ADD CONSTRAINT `FK_8B85BCCB2571BEE` FOREIGN KEY (`boardID`) REFERENCES `Boards` (`boardID`),
  ADD CONSTRAINT `FK_8B85BCCB521D8435` FOREIGN KEY (`siteID`) REFERENCES `Sites` (`siteID`);

--
-- Constraints for table `BoardInstanceSlotRules`
--
ALTER TABLE `BoardInstanceSlotRules`
  ADD CONSTRAINT `FK_4BF1A09D2E21467` FOREIGN KEY (`boardInstanceID`) REFERENCES `BoardInstances` (`boardInstanceID`),
  ADD CONSTRAINT `FK_4BF1A09DFD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`) ON DELETE SET NULL;

--
-- Constraints for table `BoardInstanceSlots`
--
ALTER TABLE `BoardInstanceSlots`
  ADD CONSTRAINT `FK_137F01F2E21467` FOREIGN KEY (`boardInstanceID`) REFERENCES `BoardInstances` (`boardInstanceID`),
  ADD CONSTRAINT `FK_137F01F5DA0FB8` FOREIGN KEY (`template_id`) REFERENCES `BoardSlotTemplates` (`id`);

--
-- Constraints for table `BoardItemCategories`
--
ALTER TABLE `BoardItemCategories`
  ADD CONSTRAINT `FK_BEF09673A1BF9938` FOREIGN KEY (`boardItemID`) REFERENCES `BoardItems` (`boardItemID`);

--
-- Constraints for table `BoardItems`
--
ALTER TABLE `BoardItems`
  ADD CONSTRAINT `FK_E831ECA13C4EAFF2` FOREIGN KEY (`dataSourceID`) REFERENCES `BoardDataSources` (`dataSourceID`),
  ADD CONSTRAINT `FK_E831ECA1E3111F45` FOREIGN KEY (`fID`) REFERENCES `Files` (`fID`);

--
-- Constraints for table `BoardItemTags`
--
ALTER TABLE `BoardItemTags`
  ADD CONSTRAINT `FK_13AEB901A1BF9938` FOREIGN KEY (`boardItemID`) REFERENCES `BoardItems` (`boardItemID`);

--
-- Constraints for table `BoardPermissionAssignments`
--
ALTER TABLE `BoardPermissionAssignments`
  ADD CONSTRAINT `FK_7C073ED92571BEE` FOREIGN KEY (`boardID`) REFERENCES `Boards` (`boardID`);

--
-- Constraints for table `Boards`
--
ALTER TABLE `Boards`
  ADD CONSTRAINT `FK_F4424825521D8435` FOREIGN KEY (`siteID`) REFERENCES `Sites` (`siteID`),
  ADD CONSTRAINT `FK_F44248255DA0FB8` FOREIGN KEY (`template_id`) REFERENCES `BoardTemplates` (`id`),
  ADD CONSTRAINT `FK_F4424825CE45CBB0` FOREIGN KEY (`pkgID`) REFERENCES `Packages` (`pkgID`);

--
-- Constraints for table `BoardSlotTemplates`
--
ALTER TABLE `BoardSlotTemplates`
  ADD CONSTRAINT `FK_6FE111C5CE45CBB0` FOREIGN KEY (`pkgID`) REFERENCES `Packages` (`pkgID`);

--
-- Constraints for table `BoardSlotTemplateTags`
--
ALTER TABLE `BoardSlotTemplateTags`
  ADD CONSTRAINT `FK_7BB1975E648A682` FOREIGN KEY (`slottemplate_id`) REFERENCES `BoardSlotTemplates` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_7BB1975E960BFEAE` FOREIGN KEY (`designtag_id`) REFERENCES `DesignTags` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `BoardTemplates`
--
ALTER TABLE `BoardTemplates`
  ADD CONSTRAINT `FK_9E8AC12CCE45CBB0` FOREIGN KEY (`pkgID`) REFERENCES `Packages` (`pkgID`);

--
-- Constraints for table `CalendarEventAttributeKeys`
--
ALTER TABLE `CalendarEventAttributeKeys`
  ADD CONSTRAINT `FK_27F477CCB6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`) ON DELETE CASCADE;

--
-- Constraints for table `CalendarEventCustomSummaryTemplates`
--
ALTER TABLE `CalendarEventCustomSummaryTemplates`
  ADD CONSTRAINT `FK_7059BBEF10409BA4` FOREIGN KEY (`eventID`) REFERENCES `CalendarEvents` (`eventID`),
  ADD CONSTRAINT `FK_7059BBEF5DA0FB8` FOREIGN KEY (`template_id`) REFERENCES `SummaryTemplates` (`id`);

--
-- Constraints for table `CalendarEventOccurrences`
--
ALTER TABLE `CalendarEventOccurrences`
  ADD CONSTRAINT `FK_7DD686EC31391E00` FOREIGN KEY (`repetitionID`) REFERENCES `CalendarEventRepetitions` (`repetitionID`);

--
-- Constraints for table `CalendarEvents`
--
ALTER TABLE `CalendarEvents`
  ADD CONSTRAINT `FK_7F23C55611C85723` FOREIGN KEY (`caID`) REFERENCES `Calendars` (`caID`);

--
-- Constraints for table `CalendarEventSummaryTemplates`
--
ALTER TABLE `CalendarEventSummaryTemplates`
  ADD CONSTRAINT `FK_219AA86B10409BA4` FOREIGN KEY (`eventID`) REFERENCES `CalendarEvents` (`eventID`),
  ADD CONSTRAINT `FK_219AA86B5DA0FB8` FOREIGN KEY (`template_id`) REFERENCES `SummaryTemplates` (`id`);

--
-- Constraints for table `CalendarEventVersionAttributeValues`
--
ALTER TABLE `CalendarEventVersionAttributeValues`
  ADD CONSTRAINT `FK_8C835B05403F5D6` FOREIGN KEY (`eventVersionID`) REFERENCES `CalendarEventVersions` (`eventVersionID`),
  ADD CONSTRAINT `FK_8C835B05A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`),
  ADD CONSTRAINT `FK_8C835B05B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `CalendarEventVersionOccurrences`
--
ALTER TABLE `CalendarEventVersionOccurrences`
  ADD CONSTRAINT `FK_60310489403F5D6` FOREIGN KEY (`eventVersionID`) REFERENCES `CalendarEventVersions` (`eventVersionID`),
  ADD CONSTRAINT `FK_60310489B4FDDC0F` FOREIGN KEY (`occurrenceID`) REFERENCES `CalendarEventOccurrences` (`occurrenceID`);

--
-- Constraints for table `CalendarEventVersionRepetitions`
--
ALTER TABLE `CalendarEventVersionRepetitions`
  ADD CONSTRAINT `FK_C1C3D3DB31391E00` FOREIGN KEY (`repetitionID`) REFERENCES `CalendarEventRepetitions` (`repetitionID`),
  ADD CONSTRAINT `FK_C1C3D3DB403F5D6` FOREIGN KEY (`eventVersionID`) REFERENCES `CalendarEventVersions` (`eventVersionID`);

--
-- Constraints for table `CalendarEventVersions`
--
ALTER TABLE `CalendarEventVersions`
  ADD CONSTRAINT `FK_8E26027410409BA4` FOREIGN KEY (`eventID`) REFERENCES `CalendarEvents` (`eventID`),
  ADD CONSTRAINT `FK_8E260274FD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`) ON DELETE SET NULL;

--
-- Constraints for table `CalendarEventWorkflowProgress`
--
ALTER TABLE `CalendarEventWorkflowProgress`
  ADD CONSTRAINT `FK_C5EAACF910409BA4` FOREIGN KEY (`eventID`) REFERENCES `CalendarEvents` (`eventID`);

--
-- Constraints for table `CalendarPermissionAssignments`
--
ALTER TABLE `CalendarPermissionAssignments`
  ADD CONSTRAINT `FK_5AD546AA11C85723` FOREIGN KEY (`caID`) REFERENCES `Calendars` (`caID`);

--
-- Constraints for table `CalendarRelatedEvents`
--
ALTER TABLE `CalendarRelatedEvents`
  ADD CONSTRAINT `FK_310130E910409BA4` FOREIGN KEY (`eventID`) REFERENCES `CalendarEvents` (`eventID`);

--
-- Constraints for table `Calendars`
--
ALTER TABLE `Calendars`
  ADD CONSTRAINT `FK_62E00AC521D8435` FOREIGN KEY (`siteID`) REFERENCES `Sites` (`siteID`);

--
-- Constraints for table `CollectionAttributeKeys`
--
ALTER TABLE `CollectionAttributeKeys`
  ADD CONSTRAINT `FK_1E3E5B79B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`) ON DELETE CASCADE;

--
-- Constraints for table `CollectionAttributeValues`
--
ALTER TABLE `CollectionAttributeValues`
  ADD CONSTRAINT `FK_BB9995FCA2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`),
  ADD CONSTRAINT `FK_BB9995FCB6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `CollectionSearchIndexAttributes`
--
ALTER TABLE `CollectionSearchIndexAttributes`
  ADD CONSTRAINT `FK_FD84E56FE5DADDAE` FOREIGN KEY (`cID`) REFERENCES `Collections` (`cID`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `ConversationMessageNotifications`
--
ALTER TABLE `ConversationMessageNotifications`
  ADD CONSTRAINT `FK_559DE1CBED024EFD` FOREIGN KEY (`nID`) REFERENCES `Notifications` (`nID`) ON DELETE CASCADE;

--
-- Constraints for table `DownloadStatistics`
--
ALTER TABLE `DownloadStatistics`
  ADD CONSTRAINT `FK_7CDE2E3CE3111F45` FOREIGN KEY (`fID`) REFERENCES `Files` (`fID`) ON DELETE CASCADE;

--
-- Constraints for table `Editor`
--
ALTER TABLE `Editor`
  ADD CONSTRAINT `FK_CB5DF48CCE45CBB0` FOREIGN KEY (`pkgID`) REFERENCES `Packages` (`pkgID`);

--
-- Constraints for table `ExpressAttributeKeys`
--
ALTER TABLE `ExpressAttributeKeys`
  ADD CONSTRAINT `FK_8C881F181257D5D` FOREIGN KEY (`entity_id`) REFERENCES `ExpressEntities` (`id`),
  ADD CONSTRAINT `FK_8C881F1B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`) ON DELETE CASCADE;

--
-- Constraints for table `ExpressEntities`
--
ALTER TABLE `ExpressEntities`
  ADD CONSTRAINT `FK_BC772AA6547D6B2D` FOREIGN KEY (`default_view_form_id`) REFERENCES `ExpressForms` (`id`),
  ADD CONSTRAINT `FK_BC772AA6C7DEC56D` FOREIGN KEY (`default_edit_form_id`) REFERENCES `ExpressForms` (`id`),
  ADD CONSTRAINT `FK_BC772AA6CE45CBB0` FOREIGN KEY (`pkgID`) REFERENCES `Packages` (`pkgID`);

--
-- Constraints for table `ExpressEntityAssociationEntries`
--
ALTER TABLE `ExpressEntityAssociationEntries`
  ADD CONSTRAINT `FK_9C2BB76C6DCB6296` FOREIGN KEY (`exEntryID`) REFERENCES `ExpressEntityEntries` (`exEntryID`),
  ADD CONSTRAINT `FK_9C2BB76CEFB9C8A5` FOREIGN KEY (`association_id`) REFERENCES `ExpressEntityEntryAssociations` (`id`);

--
-- Constraints for table `ExpressEntityAssociations`
--
ALTER TABLE `ExpressEntityAssociations`
  ADD CONSTRAINT `FK_98A0F796B5910F71` FOREIGN KEY (`target_entity_id`) REFERENCES `ExpressEntities` (`id`),
  ADD CONSTRAINT `FK_98A0F796E9BBEE93` FOREIGN KEY (`source_entity_id`) REFERENCES `ExpressEntities` (`id`);

--
-- Constraints for table `ExpressEntityEntries`
--
ALTER TABLE `ExpressEntityEntries`
  ADD CONSTRAINT `FK_B8AE3531AFC87D03` FOREIGN KEY (`exEntryEntityID`) REFERENCES `ExpressEntities` (`id`),
  ADD CONSTRAINT `FK_B8AE3531FD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`);

--
-- Constraints for table `ExpressEntityEntryAssociations`
--
ALTER TABLE `ExpressEntityEntryAssociations`
  ADD CONSTRAINT `FK_25B3A0826DCB6296` FOREIGN KEY (`exEntryID`) REFERENCES `ExpressEntityEntries` (`exEntryID`),
  ADD CONSTRAINT `FK_25B3A082EFB9C8A5` FOREIGN KEY (`association_id`) REFERENCES `ExpressEntityAssociations` (`id`);

--
-- Constraints for table `ExpressEntityEntryAttributeValues`
--
ALTER TABLE `ExpressEntityEntryAttributeValues`
  ADD CONSTRAINT `FK_6DB641546DCB6296` FOREIGN KEY (`exEntryID`) REFERENCES `ExpressEntityEntries` (`exEntryID`),
  ADD CONSTRAINT `FK_6DB64154A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`),
  ADD CONSTRAINT `FK_6DB64154B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `ExpressFormFieldSetAssociationControls`
--
ALTER TABLE `ExpressFormFieldSetAssociationControls`
  ADD CONSTRAINT `FK_E6DF21BBBF396750` FOREIGN KEY (`id`) REFERENCES `ExpressFormFieldSetControls` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_E6DF21BBEFB9C8A5` FOREIGN KEY (`association_id`) REFERENCES `ExpressEntityAssociations` (`id`);

--
-- Constraints for table `ExpressFormFieldSetAttributeKeyControls`
--
ALTER TABLE `ExpressFormFieldSetAttributeKeyControls`
  ADD CONSTRAINT `FK_8481F9D1B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`),
  ADD CONSTRAINT `FK_8481F9D1BF396750` FOREIGN KEY (`id`) REFERENCES `ExpressFormFieldSetControls` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ExpressFormFieldSetAuthorControls`
--
ALTER TABLE `ExpressFormFieldSetAuthorControls`
  ADD CONSTRAINT `FK_CF378786BF396750` FOREIGN KEY (`id`) REFERENCES `ExpressFormFieldSetControls` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ExpressFormFieldSetControls`
--
ALTER TABLE `ExpressFormFieldSetControls`
  ADD CONSTRAINT `FK_E42868A43ABF811A` FOREIGN KEY (`field_set_id`) REFERENCES `ExpressFormFieldSets` (`id`);

--
-- Constraints for table `ExpressFormFieldSetPublicIdentifierControls`
--
ALTER TABLE `ExpressFormFieldSetPublicIdentifierControls`
  ADD CONSTRAINT `FK_67180C04BF396750` FOREIGN KEY (`id`) REFERENCES `ExpressFormFieldSetControls` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ExpressFormFieldSets`
--
ALTER TABLE `ExpressFormFieldSets`
  ADD CONSTRAINT `FK_A33BBBEC5FF69B7D` FOREIGN KEY (`form_id`) REFERENCES `ExpressForms` (`id`);

--
-- Constraints for table `ExpressFormFieldSetTextControls`
--
ALTER TABLE `ExpressFormFieldSetTextControls`
  ADD CONSTRAINT `FK_DB5A209ABF396750` FOREIGN KEY (`id`) REFERENCES `ExpressFormFieldSetControls` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ExpressForms`
--
ALTER TABLE `ExpressForms`
  ADD CONSTRAINT `FK_8D09031A81257D5D` FOREIGN KEY (`entity_id`) REFERENCES `ExpressEntities` (`id`);

--
-- Constraints for table `FileAttributeKeys`
--
ALTER TABLE `FileAttributeKeys`
  ADD CONSTRAINT `FK_BC5C7BBB6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`) ON DELETE CASCADE;

--
-- Constraints for table `FileAttributeValues`
--
ALTER TABLE `FileAttributeValues`
  ADD CONSTRAINT `FK_BBECEAA4A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`),
  ADD CONSTRAINT `FK_BBECEAA4B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `FileImageThumbnailTypeFileSets`
--
ALTER TABLE `FileImageThumbnailTypeFileSets`
  ADD CONSTRAINT `FK_BD75F88D480660E5` FOREIGN KEY (`ftfsThumbnailType`) REFERENCES `FileImageThumbnailTypes` (`ftTypeID`) ON DELETE CASCADE;

--
-- Constraints for table `Files`
--
ALTER TABLE `Files`
  ADD CONSTRAINT `FK_C7F46F5DB81D3903` FOREIGN KEY (`fslID`) REFERENCES `FileStorageLocations` (`fslID`),
  ADD CONSTRAINT `FK_C7F46F5DFD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`) ON DELETE SET NULL;

--
-- Constraints for table `FileSearchIndexAttributes`
--
ALTER TABLE `FileSearchIndexAttributes`
  ADD CONSTRAINT `FK_3A3A4845E3111F45` FOREIGN KEY (`fID`) REFERENCES `Files` (`fID`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `FileVersions`
--
ALTER TABLE `FileVersions`
  ADD CONSTRAINT `FK_D7B5A13AE3111F45` FOREIGN KEY (`fID`) REFERENCES `Files` (`fID`);

--
-- Constraints for table `FormSubmissionNotifications`
--
ALTER TABLE `FormSubmissionNotifications`
  ADD CONSTRAINT `FK_E7B6BE406DCB6296` FOREIGN KEY (`exEntryID`) REFERENCES `ExpressEntityEntries` (`exEntryID`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_E7B6BE40ED024EFD` FOREIGN KEY (`nID`) REFERENCES `Notifications` (`nID`) ON DELETE CASCADE;

--
-- Constraints for table `Geolocators`
--
ALTER TABLE `Geolocators`
  ADD CONSTRAINT `FK_83BB1614D5F6CC40` FOREIGN KEY (`glPackage`) REFERENCES `Packages` (`pkgID`) ON DELETE CASCADE;

--
-- Constraints for table `GroupCreateNotifications`
--
ALTER TABLE `GroupCreateNotifications`
  ADD CONSTRAINT `FK_C17D9982BF396750` FOREIGN KEY (`id`) REFERENCES `GroupCreates` (`id`),
  ADD CONSTRAINT `FK_C17D9982ED024EFD` FOREIGN KEY (`nID`) REFERENCES `Notifications` (`nID`) ON DELETE CASCADE;

--
-- Constraints for table `GroupCreates`
--
ALTER TABLE `GroupCreates`
  ADD CONSTRAINT `FK_CCD7EF48FD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`) ON DELETE SET NULL;

--
-- Constraints for table `GroupRoleChangeNotifications`
--
ALTER TABLE `GroupRoleChangeNotifications`
  ADD CONSTRAINT `FK_C1402C44BF396750` FOREIGN KEY (`id`) REFERENCES `GroupRoleChanges` (`id`),
  ADD CONSTRAINT `FK_C1402C44ED024EFD` FOREIGN KEY (`nID`) REFERENCES `Notifications` (`nID`) ON DELETE CASCADE;

--
-- Constraints for table `GroupRoleChanges`
--
ALTER TABLE `GroupRoleChanges`
  ADD CONSTRAINT `FK_98ADE2F3FD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`) ON DELETE SET NULL;

--
-- Constraints for table `GroupSignupNotifications`
--
ALTER TABLE `GroupSignupNotifications`
  ADD CONSTRAINT `FK_77F3EABF396750` FOREIGN KEY (`id`) REFERENCES `GroupSignups` (`id`),
  ADD CONSTRAINT `FK_77F3EAED024EFD` FOREIGN KEY (`nID`) REFERENCES `Notifications` (`nID`) ON DELETE CASCADE;

--
-- Constraints for table `GroupSignupRequestAcceptNotifications`
--
ALTER TABLE `GroupSignupRequestAcceptNotifications`
  ADD CONSTRAINT `FK_72E6015ABF396750` FOREIGN KEY (`id`) REFERENCES `GroupSignupRequestAccepts` (`id`),
  ADD CONSTRAINT `FK_72E6015AED024EFD` FOREIGN KEY (`nID`) REFERENCES `Notifications` (`nID`) ON DELETE CASCADE;

--
-- Constraints for table `GroupSignupRequestAccepts`
--
ALTER TABLE `GroupSignupRequestAccepts`
  ADD CONSTRAINT `FK_18BBF9FCDB43B5DF` FOREIGN KEY (`managerUID`) REFERENCES `Users` (`uID`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_18BBF9FCFD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`) ON DELETE SET NULL;

--
-- Constraints for table `GroupSignupRequestDeclineNotifications`
--
ALTER TABLE `GroupSignupRequestDeclineNotifications`
  ADD CONSTRAINT `FK_930C0D02BF396750` FOREIGN KEY (`id`) REFERENCES `GroupSignupRequestDeclines` (`id`),
  ADD CONSTRAINT `FK_930C0D02ED024EFD` FOREIGN KEY (`nID`) REFERENCES `Notifications` (`nID`) ON DELETE CASCADE;

--
-- Constraints for table `GroupSignupRequestDeclines`
--
ALTER TABLE `GroupSignupRequestDeclines`
  ADD CONSTRAINT `FK_A905188EDB43B5DF` FOREIGN KEY (`managerUID`) REFERENCES `Users` (`uID`) ON DELETE SET NULL,
  ADD CONSTRAINT `FK_A905188EFD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`) ON DELETE SET NULL;

--
-- Constraints for table `GroupSignupRequestNotifications`
--
ALTER TABLE `GroupSignupRequestNotifications`
  ADD CONSTRAINT `FK_56EC93C8BF396750` FOREIGN KEY (`id`) REFERENCES `GroupSignupRequests` (`id`),
  ADD CONSTRAINT `FK_56EC93C8ED024EFD` FOREIGN KEY (`nID`) REFERENCES `Notifications` (`nID`) ON DELETE CASCADE;

--
-- Constraints for table `GroupSignupRequests`
--
ALTER TABLE `GroupSignupRequests`
  ADD CONSTRAINT `FK_8CF06191FD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`) ON DELETE SET NULL;

--
-- Constraints for table `GroupSignups`
--
ALTER TABLE `GroupSignups`
  ADD CONSTRAINT `FK_D6CC4ECBFD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`) ON DELETE SET NULL;

--
-- Constraints for table `HealthReportResultFindings`
--
ALTER TABLE `HealthReportResultFindings`
  ADD CONSTRAINT `FK_14794DC7A7B643` FOREIGN KEY (`result_id`) REFERENCES `HealthReportResults` (`id`);

--
-- Constraints for table `HealthReportResults`
--
ALTER TABLE `HealthReportResults`
  ADD CONSTRAINT `FK_F8C09F44E821EAFF` FOREIGN KEY (`taskID`) REFERENCES `Tasks` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `HealthReportSearchResults`
--
ALTER TABLE `HealthReportSearchResults`
  ADD CONSTRAINT `FK_96480975BF396750` FOREIGN KEY (`id`) REFERENCES `HealthReportResults` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `IpAccessControlCategories`
--
ALTER TABLE `IpAccessControlCategories`
  ADD CONSTRAINT `FK_D4A10062C908ED51` FOREIGN KEY (`iaccPackage`) REFERENCES `Packages` (`pkgID`) ON DELETE CASCADE;

--
-- Constraints for table `IpAccessControlEvents`
--
ALTER TABLE `IpAccessControlEvents`
  ADD CONSTRAINT `FK_6C004072B0C0DFA7` FOREIGN KEY (`iaceSite`) REFERENCES `Sites` (`siteID`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_6C004072E9480668` FOREIGN KEY (`iaceCategory`) REFERENCES `IpAccessControlCategories` (`iaccID`) ON DELETE CASCADE;

--
-- Constraints for table `IpAccessControlRanges`
--
ALTER TABLE `IpAccessControlRanges`
  ADD CONSTRAINT `FK_2B1AA65D21E929D0` FOREIGN KEY (`iacrCategory`) REFERENCES `IpAccessControlCategories` (`iaccID`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_2B1AA65D62009435` FOREIGN KEY (`iacrSite`) REFERENCES `Sites` (`siteID`) ON DELETE CASCADE;

--
-- Constraints for table `LegacyAttributeKeys`
--
ALTER TABLE `LegacyAttributeKeys`
  ADD CONSTRAINT `FK_740BA2BBB6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`) ON DELETE CASCADE;

--
-- Constraints for table `MessengerProcesses`
--
ALTER TABLE `MessengerProcesses`
  ADD CONSTRAINT `FK_FBB7A9C9F39EBE7A` FOREIGN KEY (`batch_id`) REFERENCES `MessengerBatches` (`id`),
  ADD CONSTRAINT `FK_FBB7A9C9FD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`) ON DELETE SET NULL;

--
-- Constraints for table `MessengerScheduledTasks`
--
ALTER TABLE `MessengerScheduledTasks`
  ADD CONSTRAINT `FK_DCEB3C0D8DB60186` FOREIGN KEY (`task_id`) REFERENCES `Tasks` (`id`),
  ADD CONSTRAINT `FK_DCEB3C0DFD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`) ON DELETE SET NULL;

--
-- Constraints for table `MessengerTaskProcesses`
--
ALTER TABLE `MessengerTaskProcesses`
  ADD CONSTRAINT `FK_BE77DC6F8DB60186` FOREIGN KEY (`task_id`) REFERENCES `Tasks` (`id`),
  ADD CONSTRAINT `FK_BE77DC6FBF396750` FOREIGN KEY (`id`) REFERENCES `MessengerProcesses` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `NotificationAlerts`
--
ALTER TABLE `NotificationAlerts`
  ADD CONSTRAINT `FK_E11C7408ED024EFD` FOREIGN KEY (`nID`) REFERENCES `Notifications` (`nID`),
  ADD CONSTRAINT `FK_E11C7408FD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`);

--
-- Constraints for table `OAuth2AccessToken`
--
ALTER TABLE `OAuth2AccessToken`
  ADD CONSTRAINT `FK_60D69F3FC7440455` FOREIGN KEY (`client`) REFERENCES `OAuth2Client` (`identifier`) ON DELETE CASCADE;

--
-- Constraints for table `OAuth2AuthCode`
--
ALTER TABLE `OAuth2AuthCode`
  ADD CONSTRAINT `FK_29D07B5C7440455` FOREIGN KEY (`client`) REFERENCES `OAuth2Client` (`identifier`);

--
-- Constraints for table `OAuth2ClientScopes`
--
ALTER TABLE `OAuth2ClientScopes`
  ADD CONSTRAINT `FK_497E26F39ECFF1A8` FOREIGN KEY (`clientIdentifier`) REFERENCES `OAuth2Client` (`identifier`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_497E26F3C7FD45E9` FOREIGN KEY (`scopeIdentifier`) REFERENCES `OAuth2Scope` (`identifier`);

--
-- Constraints for table `OAuth2RefreshToken`
--
ALTER TABLE `OAuth2RefreshToken`
  ADD CONSTRAINT `FK_A205CB8350A9822` FOREIGN KEY (`accessToken`) REFERENCES `OAuth2AccessToken` (`identifier`) ON DELETE SET NULL;

--
-- Constraints for table `PageContainerInstanceAreas`
--
ALTER TABLE `PageContainerInstanceAreas`
  ADD CONSTRAINT `FK_484B3E0A1FCD0045` FOREIGN KEY (`containerInstanceID`) REFERENCES `PageContainerInstances` (`containerInstanceID`) ON DELETE CASCADE;

--
-- Constraints for table `PageContainerInstances`
--
ALTER TABLE `PageContainerInstances`
  ADD CONSTRAINT `FK_489D87A71159C151` FOREIGN KEY (`containerID`) REFERENCES `PageContainers` (`containerID`) ON DELETE CASCADE;

--
-- Constraints for table `PageContainers`
--
ALTER TABLE `PageContainers`
  ADD CONSTRAINT `FK_65E7C1D1CE45CBB0` FOREIGN KEY (`pkgID`) REFERENCES `Packages` (`pkgID`);

--
-- Constraints for table `PageSummaryTemplateCustomCollectionTemplates`
--
ALTER TABLE `PageSummaryTemplateCustomCollectionTemplates`
  ADD CONSTRAINT `FK_23B91C0F5DA0FB8` FOREIGN KEY (`template_id`) REFERENCES `SummaryTemplates` (`id`),
  ADD CONSTRAINT `FK_23B91C0FE5DADDAE` FOREIGN KEY (`cID`) REFERENCES `PageSummaryTemplateCustomCollection` (`cID`);

--
-- Constraints for table `PageSummaryTemplates`
--
ALTER TABLE `PageSummaryTemplates`
  ADD CONSTRAINT `FK_55AC200B5DA0FB8` FOREIGN KEY (`template_id`) REFERENCES `SummaryTemplates` (`id`);

--
-- Constraints for table `PageThemeCustomSkins`
--
ALTER TABLE `PageThemeCustomSkins`
  ADD CONSTRAINT `FK_162E9C4EFD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`);

--
-- Constraints for table `PermissionAccessEntitySiteGroups`
--
ALTER TABLE `PermissionAccessEntitySiteGroups`
  ADD CONSTRAINT `FK_51122D554A62E0E4` FOREIGN KEY (`siteGID`) REFERENCES `SiteGroups` (`siteGID`);

--
-- Constraints for table `PrivateMessageNotifications`
--
ALTER TABLE `PrivateMessageNotifications`
  ADD CONSTRAINT `FK_1AB97592ED024EFD` FOREIGN KEY (`nID`) REFERENCES `Notifications` (`nID`) ON DELETE CASCADE;

--
-- Constraints for table `SavedExpressSearchQueries`
--
ALTER TABLE `SavedExpressSearchQueries`
  ADD CONSTRAINT `FK_F87C25F2CE2D7284` FOREIGN KEY (`exEntityID`) REFERENCES `ExpressEntities` (`id`);

--
-- Constraints for table `SiteAttributeKeys`
--
ALTER TABLE `SiteAttributeKeys`
  ADD CONSTRAINT `FK_63D1E182B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`) ON DELETE CASCADE;

--
-- Constraints for table `SiteAttributeValues`
--
ALTER TABLE `SiteAttributeValues`
  ADD CONSTRAINT `FK_67658AF7521D8435` FOREIGN KEY (`siteID`) REFERENCES `Sites` (`siteID`),
  ADD CONSTRAINT `FK_67658AF7A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`),
  ADD CONSTRAINT `FK_67658AF7B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `SiteDomains`
--
ALTER TABLE `SiteDomains`
  ADD CONSTRAINT `FK_4CC7400A521D8435` FOREIGN KEY (`siteID`) REFERENCES `Sites` (`siteID`);

--
-- Constraints for table `SiteGroupRelations`
--
ALTER TABLE `SiteGroupRelations`
  ADD CONSTRAINT `FK_DCBCDCA94A62E0E4` FOREIGN KEY (`siteGID`) REFERENCES `SiteGroups` (`siteGID`),
  ADD CONSTRAINT `FK_DCBCDCA9521D8435` FOREIGN KEY (`siteID`) REFERENCES `Sites` (`siteID`);

--
-- Constraints for table `SiteGroups`
--
ALTER TABLE `SiteGroups`
  ADD CONSTRAINT `FK_F6FE030FE9548DF7` FOREIGN KEY (`siteTypeID`) REFERENCES `SiteTypes` (`siteTypeID`);

--
-- Constraints for table `SiteLocales`
--
ALTER TABLE `SiteLocales`
  ADD CONSTRAINT `FK_2527AB2C521D8435` FOREIGN KEY (`siteID`) REFERENCES `Sites` (`siteID`),
  ADD CONSTRAINT `FK_2527AB2CF9431B4B` FOREIGN KEY (`siteTreeID`) REFERENCES `SiteTreeTrees` (`siteTreeID`);

--
-- Constraints for table `Sites`
--
ALTER TABLE `Sites`
  ADD CONSTRAINT `FK_7DC18567E9548DF7` FOREIGN KEY (`siteTypeID`) REFERENCES `SiteTypes` (`siteTypeID`);

--
-- Constraints for table `SiteSearchIndexAttributes`
--
ALTER TABLE `SiteSearchIndexAttributes`
  ADD CONSTRAINT `FK_3DD070B4521D8435` FOREIGN KEY (`siteID`) REFERENCES `Sites` (`siteID`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `SiteSkeletonLocales`
--
ALTER TABLE `SiteSkeletonLocales`
  ADD CONSTRAINT `FK_212DD202B579BD3E` FOREIGN KEY (`siteSkeletonID`) REFERENCES `SiteSkeletons` (`siteSkeletonID`),
  ADD CONSTRAINT `FK_212DD202F9431B4B` FOREIGN KEY (`siteTreeID`) REFERENCES `SiteSkeletonTrees` (`siteTreeID`);

--
-- Constraints for table `SiteSkeletons`
--
ALTER TABLE `SiteSkeletons`
  ADD CONSTRAINT `FK_D36AED98E9548DF7` FOREIGN KEY (`siteTypeID`) REFERENCES `SiteTypes` (`siteTypeID`);

--
-- Constraints for table `SiteSkeletonTrees`
--
ALTER TABLE `SiteSkeletonTrees`
  ADD CONSTRAINT `FK_550F784B16B7EAF2` FOREIGN KEY (`skeletonLocaleID`) REFERENCES `SiteSkeletonLocales` (`skeletonLocaleID`),
  ADD CONSTRAINT `FK_550F784BE9548DF7` FOREIGN KEY (`siteTypeID`) REFERENCES `SiteTypes` (`siteTypeID`),
  ADD CONSTRAINT `FK_550F784BF9431B4B` FOREIGN KEY (`siteTreeID`) REFERENCES `SiteTrees` (`siteTreeID`) ON DELETE CASCADE;

--
-- Constraints for table `SiteTreeTrees`
--
ALTER TABLE `SiteTreeTrees`
  ADD CONSTRAINT `FK_A4B9696EACD624CD` FOREIGN KEY (`siteLocaleID`) REFERENCES `SiteLocales` (`siteLocaleID`),
  ADD CONSTRAINT `FK_A4B9696EF9431B4B` FOREIGN KEY (`siteTreeID`) REFERENCES `SiteTrees` (`siteTreeID`) ON DELETE CASCADE;

--
-- Constraints for table `SiteTypeAttributeKeys`
--
ALTER TABLE `SiteTypeAttributeKeys`
  ADD CONSTRAINT `FK_26C73776B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`) ON DELETE CASCADE;

--
-- Constraints for table `SiteTypeAttributeValues`
--
ALTER TABLE `SiteTypeAttributeValues`
  ADD CONSTRAINT `FK_78059CB9A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`),
  ADD CONSTRAINT `FK_78059CB9B579BD3E` FOREIGN KEY (`siteSkeletonID`) REFERENCES `SiteSkeletons` (`siteSkeletonID`),
  ADD CONSTRAINT `FK_78059CB9B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `SiteTypes`
--
ALTER TABLE `SiteTypes`
  ADD CONSTRAINT `FK_7CBFE975CE45CBB0` FOREIGN KEY (`pkgID`) REFERENCES `Packages` (`pkgID`);

--
-- Constraints for table `SocialLinks`
--
ALTER TABLE `SocialLinks`
  ADD CONSTRAINT `FK_84EBA2B4521D8435` FOREIGN KEY (`siteID`) REFERENCES `Sites` (`siteID`);

--
-- Constraints for table `SummaryCategories`
--
ALTER TABLE `SummaryCategories`
  ADD CONSTRAINT `FK_F815AD2ACE45CBB0` FOREIGN KEY (`pkgID`) REFERENCES `Packages` (`pkgID`);

--
-- Constraints for table `SummaryFields`
--
ALTER TABLE `SummaryFields`
  ADD CONSTRAINT `FK_AC926EC9CE45CBB0` FOREIGN KEY (`pkgID`) REFERENCES `Packages` (`pkgID`);

--
-- Constraints for table `SummaryTemplateCategories`
--
ALTER TABLE `SummaryTemplateCategories`
  ADD CONSTRAINT `FK_C8B6E64A12469DE2` FOREIGN KEY (`category_id`) REFERENCES `SummaryCategories` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_C8B6E64A5DA0FB8` FOREIGN KEY (`template_id`) REFERENCES `SummaryTemplates` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `SummaryTemplateFields`
--
ALTER TABLE `SummaryTemplateFields`
  ADD CONSTRAINT `FK_294381EC443707B0` FOREIGN KEY (`field_id`) REFERENCES `SummaryFields` (`id`),
  ADD CONSTRAINT `FK_294381EC5DA0FB8` FOREIGN KEY (`template_id`) REFERENCES `SummaryTemplates` (`id`);

--
-- Constraints for table `SummaryTemplates`
--
ALTER TABLE `SummaryTemplates`
  ADD CONSTRAINT `FK_5E3C9832CE45CBB0` FOREIGN KEY (`pkgID`) REFERENCES `Packages` (`pkgID`);

--
-- Constraints for table `SummaryTemplateTags`
--
ALTER TABLE `SummaryTemplateTags`
  ADD CONSTRAINT `FK_D9197F515DA0FB8` FOREIGN KEY (`template_id`) REFERENCES `SummaryTemplates` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_D9197F51960BFEAE` FOREIGN KEY (`designtag_id`) REFERENCES `DesignTags` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `Tasks`
--
ALTER TABLE `Tasks`
  ADD CONSTRAINT `FK_91994A93CE45CBB0` FOREIGN KEY (`pkgID`) REFERENCES `Packages` (`pkgID`),
  ADD CONSTRAINT `FK_91994A93FD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`) ON DELETE SET NULL;

--
-- Constraints for table `TaskSets`
--
ALTER TABLE `TaskSets`
  ADD CONSTRAINT `FK_EF2069C4CE45CBB0` FOREIGN KEY (`pkgID`) REFERENCES `Packages` (`pkgID`);

--
-- Constraints for table `TaskSetTasks`
--
ALTER TABLE `TaskSetTasks`
  ADD CONSTRAINT `FK_D395AA3810FB0D18` FOREIGN KEY (`set_id`) REFERENCES `TaskSets` (`id`),
  ADD CONSTRAINT `FK_D395AA388DB60186` FOREIGN KEY (`task_id`) REFERENCES `Tasks` (`id`);

--
-- Constraints for table `UserAttributeKeys`
--
ALTER TABLE `UserAttributeKeys`
  ADD CONSTRAINT `FK_28970033B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`) ON DELETE CASCADE;

--
-- Constraints for table `UserAttributeValues`
--
ALTER TABLE `UserAttributeValues`
  ADD CONSTRAINT `FK_4DB68CA6A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`),
  ADD CONSTRAINT `FK_4DB68CA6B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`),
  ADD CONSTRAINT `FK_4DB68CA6FD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`);

--
-- Constraints for table `UserDeactivatedNotifications`
--
ALTER TABLE `UserDeactivatedNotifications`
  ADD CONSTRAINT `FK_ED5A1F9FED024EFD` FOREIGN KEY (`nID`) REFERENCES `Notifications` (`nID`) ON DELETE CASCADE;

--
-- Constraints for table `UserFavoriteFolders`
--
ALTER TABLE `UserFavoriteFolders`
  ADD CONSTRAINT `FK_EDB1ABB6FD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`) ON DELETE CASCADE;

--
-- Constraints for table `UserSearchIndexAttributes`
--
ALTER TABLE `UserSearchIndexAttributes`
  ADD CONSTRAINT `FK_74798B07FD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `UserSignupNotifications`
--
ALTER TABLE `UserSignupNotifications`
  ADD CONSTRAINT `FK_7FB1DF5B7B18287E` FOREIGN KEY (`usID`) REFERENCES `UserSignups` (`usID`),
  ADD CONSTRAINT `FK_7FB1DF5BED024EFD` FOREIGN KEY (`nID`) REFERENCES `Notifications` (`nID`) ON DELETE CASCADE;

--
-- Constraints for table `UserSignups`
--
ALTER TABLE `UserSignups`
  ADD CONSTRAINT `FK_FEB5D909D3564642` FOREIGN KEY (`createdBy`) REFERENCES `Users` (`uID`),
  ADD CONSTRAINT `FK_FEB5D909FD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`);

--
-- Constraints for table `WorkflowProgressNotifications`
--
ALTER TABLE `WorkflowProgressNotifications`
  ADD CONSTRAINT `FK_EC39CA81ED024EFD` FOREIGN KEY (`nID`) REFERENCES `Notifications` (`nID`) ON DELETE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
