SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `conc8520sd`
--

-- --------------------------------------------------------

--
-- Table structure for table `AreaLayoutColumns`
--

CREATE TABLE `AreaLayoutColumns` (
  `arLayoutColumnID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `arLayoutID` int(10) unsigned NOT NULL DEFAULT '0',
  `arLayoutColumnIndex` int(10) unsigned NOT NULL DEFAULT '0',
  `arID` int(10) unsigned NOT NULL DEFAULT '0',
  `arLayoutColumnDisplayID` int(11) DEFAULT '0',
  PRIMARY KEY (`arLayoutColumnID`),
  KEY `arLayoutID` (`arLayoutID`,`arLayoutColumnIndex`),
  KEY `arID` (`arID`),
  KEY `arLayoutColumnDisplayID` (`arLayoutColumnDisplayID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=54 ;

--
-- Dumping data for table `AreaLayoutColumns`
--

INSERT INTO `AreaLayoutColumns` VALUES
(1, 1, 0, 2, 1),
(2, 1, 1, 3, 2),
(3, 1, 2, 4, 3),
(4, 2, 0, 5, 4),
(5, 2, 1, 6, 5),
(6, 3, 0, 7, 6),
(7, 3, 1, 8, 7),
(8, 3, 2, 9, 8),
(9, 4, 0, 11, 9),
(10, 5, 0, 12, 10),
(11, 6, 0, 14, 11),
(12, 7, 0, 15, 12),
(13, 8, 0, 35, 13),
(14, 8, 1, 36, 14),
(15, 9, 0, 39, 15),
(16, 9, 1, 40, 16),
(17, 9, 2, 41, 17),
(18, 10, 0, 42, 18),
(19, 10, 1, 43, 19),
(20, 11, 0, 44, 20),
(21, 11, 1, 45, 21),
(22, 11, 2, 46, 22),
(23, 12, 0, 49, 23),
(24, 12, 1, 50, 24),
(25, 12, 2, 51, 25),
(26, 12, 3, 52, 26),
(27, 13, 0, 53, 27),
(28, 13, 1, 54, 28),
(29, 14, 0, 56, 29),
(30, 14, 1, 57, 30),
(31, 15, 0, 84, 31),
(32, 15, 1, 85, 32),
(33, 16, 0, 86, 33),
(34, 16, 1, 87, 34),
(35, 16, 2, 88, 35),
(36, 17, 0, 89, 36),
(37, 17, 1, 90, 37),
(38, 18, 0, 105, 38),
(39, 18, 1, 106, 39),
(40, 19, 0, 107, 40),
(41, 19, 1, 108, 41),
(42, 19, 2, 109, 42),
(43, 20, 0, 112, 43),
(44, 20, 1, 113, 44),
(45, 21, 0, 114, 45),
(46, 21, 1, 115, 46),
(47, 22, 0, 116, 47),
(48, 22, 1, 117, 48),
(49, 23, 0, 119, 49),
(50, 23, 1, 120, 50),
(51, 23, 2, 121, 51),
(52, 24, 0, 122, 52),
(53, 24, 1, 123, 53);

-- --------------------------------------------------------

--
-- Table structure for table `AreaLayoutCustomColumns`
--

CREATE TABLE `AreaLayoutCustomColumns` (
  `arLayoutColumnID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `arLayoutColumnWidth` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`arLayoutColumnID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `AreaLayoutPresets`
--

CREATE TABLE `AreaLayoutPresets` (
  `arLayoutPresetID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `arLayoutID` int(10) unsigned NOT NULL DEFAULT '0',
  `arLayoutPresetName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`arLayoutPresetID`),
  KEY `arLayoutID` (`arLayoutID`),
  KEY `arLayoutPresetName` (`arLayoutPresetName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `AreaLayouts`
--

CREATE TABLE `AreaLayouts` (
  `arLayoutID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `arLayoutSpacing` int(10) unsigned NOT NULL DEFAULT '0',
  `arLayoutIsCustom` tinyint(1) NOT NULL DEFAULT '0',
  `arLayoutIsPreset` tinyint(1) NOT NULL DEFAULT '0',
  `arLayoutMaxColumns` int(10) unsigned NOT NULL DEFAULT '0',
  `arLayoutUsesThemeGridFramework` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`arLayoutID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=25 ;

--
-- Dumping data for table `AreaLayouts`
--

INSERT INTO `AreaLayouts` VALUES
(1, 0, 0, 0, 12, 1),
(2, 0, 0, 0, 12, 1),
(3, 0, 0, 0, 12, 1),
(4, 0, 0, 0, 12, 1),
(5, 0, 0, 0, 12, 1),
(6, 0, 0, 0, 12, 1),
(7, 0, 0, 0, 12, 1),
(8, 0, 0, 0, 12, 1),
(9, 0, 0, 0, 12, 1),
(10, 0, 0, 0, 12, 1),
(11, 0, 0, 0, 12, 1),
(12, 0, 0, 0, 12, 1),
(13, 0, 0, 0, 12, 1),
(14, 0, 0, 0, 12, 1),
(15, 0, 0, 0, 12, 1),
(16, 0, 0, 0, 12, 1),
(17, 0, 0, 0, 12, 1),
(18, 0, 0, 0, 12, 1),
(19, 0, 0, 0, 12, 1),
(20, 0, 0, 0, 12, 1),
(21, 0, 0, 0, 12, 1),
(22, 0, 0, 0, 12, 1),
(23, 0, 0, 0, 12, 1),
(24, 0, 0, 0, 12, 1);

-- --------------------------------------------------------

--
-- Table structure for table `AreaLayoutsUsingPresets`
--

CREATE TABLE `AreaLayoutsUsingPresets` (
  `arLayoutID` int(10) unsigned NOT NULL,
  `preset` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`arLayoutID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `AreaLayoutThemeGridColumns`
--

CREATE TABLE `AreaLayoutThemeGridColumns` (
  `arLayoutColumnID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `arLayoutColumnSpan` int(10) unsigned DEFAULT '0',
  `arLayoutColumnOffset` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`arLayoutColumnID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=54 ;

--
-- Dumping data for table `AreaLayoutThemeGridColumns`
--

INSERT INTO `AreaLayoutThemeGridColumns` VALUES
(1, 4, 0),
(2, 4, 0),
(3, 4, 0),
(4, 4, 0),
(5, 8, 0),
(6, 4, 0),
(7, 4, 0),
(8, 4, 0),
(9, 12, 0),
(10, 12, 0),
(11, 12, 0),
(12, 12, 0),
(13, 8, 0),
(14, 3, 1),
(15, 4, 0),
(16, 4, 0),
(17, 4, 0),
(18, 6, 0),
(19, 6, 0),
(20, 2, 0),
(21, 3, 0),
(22, 6, 1),
(23, 3, 0),
(24, 3, 0),
(25, 3, 0),
(26, 3, 0),
(27, 6, 0),
(28, 6, 0),
(29, 5, 0),
(30, 5, 2),
(31, 6, 0),
(32, 6, 0),
(33, 4, 0),
(34, 4, 0),
(35, 4, 0),
(36, 4, 0),
(37, 7, 1),
(38, 7, 0),
(39, 4, 1),
(40, 2, 0),
(41, 4, 0),
(42, 6, 0),
(43, 7, 0),
(44, 5, 0),
(45, 4, 0),
(46, 7, 1),
(47, 4, 0),
(48, 7, 1),
(49, 4, 0),
(50, 4, 0),
(51, 4, 0),
(52, 4, 0),
(53, 8, 0);

-- --------------------------------------------------------

--
-- Table structure for table `AreaPermissionAssignments`
--

CREATE TABLE `AreaPermissionAssignments` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `arHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`arHandle`,`pkID`,`paID`),
  KEY `paID` (`paID`),
  KEY `pkID` (`pkID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `AreaPermissionBlockTypeAccessList`
--

CREATE TABLE `AreaPermissionBlockTypeAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`),
  KEY `peID` (`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `AreaPermissionBlockTypeAccessListCustom`
--

CREATE TABLE `AreaPermissionBlockTypeAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `btID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`btID`),
  KEY `peID` (`peID`),
  KEY `btID` (`btID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `Areas`
--

CREATE TABLE `Areas` (
  `arID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `arHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `arOverrideCollectionPermissions` tinyint(1) NOT NULL DEFAULT '0',
  `arInheritPermissionsFromAreaOnCID` int(10) unsigned NOT NULL DEFAULT '0',
  `arIsGlobal` tinyint(1) NOT NULL DEFAULT '0',
  `arParentID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`arID`),
  KEY `arIsGlobal` (`arIsGlobal`),
  KEY `cID` (`cID`),
  KEY `arHandle` (`arHandle`),
  KEY `arParentID` (`arParentID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=131 ;

--
-- Dumping data for table `Areas`
--

INSERT INTO `Areas` VALUES
(1, 170, 'Main', 0, 0, 0, 0),
(2, 170, 'Main : 1', 0, 0, 0, 1),
(3, 170, 'Main : 2', 0, 0, 0, 1),
(4, 170, 'Main : 3', 0, 0, 0, 1),
(5, 170, 'Main : 4', 0, 0, 0, 1),
(6, 170, 'Main : 5', 0, 0, 0, 1),
(7, 170, 'Main : 6', 0, 0, 0, 1),
(8, 170, 'Main : 7', 0, 0, 0, 1),
(9, 170, 'Main : 8', 0, 0, 0, 1),
(10, 171, 'Main', 0, 0, 0, 0),
(11, 171, 'Main : 9', 0, 0, 0, 10),
(12, 171, 'Main : 10', 0, 0, 0, 10),
(13, 184, 'Main', 0, 0, 0, 0),
(14, 184, 'Main : 11', 0, 0, 0, 13),
(15, 184, 'Main : 12', 0, 0, 0, 13),
(16, 185, 'Main', 0, 0, 0, 0),
(17, 186, 'Main', 0, 0, 0, 0),
(18, 187, 'Main', 0, 0, 0, 0),
(19, 188, 'Main', 0, 0, 0, 0),
(20, 189, 'Main', 0, 0, 0, 0),
(21, 190, 'Main', 0, 0, 0, 0),
(22, 191, 'Main', 0, 0, 0, 0),
(23, 192, 'Main', 0, 0, 0, 0),
(24, 211, 'Main', 0, 0, 0, 0),
(25, 211, 'Sidebar', 0, 0, 0, 0),
(26, 211, 'Page Footer', 0, 0, 0, 0),
(27, 218, 'Page Header', 0, 0, 0, 0),
(28, 218, 'Sidebar', 0, 0, 0, 0),
(29, 218, 'Main', 0, 0, 0, 0),
(30, 204, 'Page Header', 0, 0, 0, 0),
(31, 204, 'Sidebar', 0, 0, 0, 0),
(32, 204, 'Main', 0, 0, 0, 0),
(33, 204, 'Page Footer', 0, 0, 0, 0),
(34, 198, 'Main', 0, 0, 0, 0),
(35, 198, 'Main : 13', 0, 0, 0, 34),
(36, 198, 'Main : 14', 0, 0, 0, 34),
(37, 195, 'Main', 0, 0, 0, 0),
(38, 1, 'Main', 0, 0, 0, 0),
(39, 1, 'Main : 15', 0, 0, 0, 38),
(40, 1, 'Main : 16', 0, 0, 0, 38),
(41, 1, 'Main : 17', 0, 0, 0, 38),
(42, 1, 'Main : 18', 0, 0, 0, 38),
(43, 1, 'Main : 19', 0, 0, 0, 38),
(44, 1, 'Main : 20', 0, 0, 0, 38),
(45, 1, 'Main : 21', 0, 0, 0, 38),
(46, 1, 'Main : 22', 0, 0, 0, 38),
(47, 1, 'Page Footer', 0, 0, 0, 0),
(48, 194, 'Main', 0, 0, 0, 0),
(49, 194, 'Main : 23', 0, 0, 0, 48),
(50, 194, 'Main : 24', 0, 0, 0, 48),
(51, 194, 'Main : 25', 0, 0, 0, 48),
(52, 194, 'Main : 26', 0, 0, 0, 48),
(53, 194, 'Main : 27', 0, 0, 0, 48),
(54, 194, 'Main : 28', 0, 0, 0, 48),
(55, 194, 'Page Footer', 0, 0, 0, 0),
(56, 194, 'Page Footer : 29', 0, 0, 0, 55),
(57, 194, 'Page Footer : 30', 0, 0, 0, 55),
(58, 196, 'Main', 0, 0, 0, 0),
(59, 205, 'Page Header', 0, 0, 0, 0),
(60, 205, 'Main', 0, 0, 0, 0),
(61, 205, 'Sidebar', 0, 0, 0, 0),
(62, 205, 'Page Footer', 0, 0, 0, 0),
(63, 206, 'Page Header', 0, 0, 0, 0),
(64, 206, 'Main', 0, 0, 0, 0),
(65, 206, 'Sidebar', 0, 0, 0, 0),
(66, 206, 'Page Footer', 0, 0, 0, 0),
(67, 207, 'Page Header', 0, 0, 0, 0),
(68, 207, 'Main', 0, 0, 0, 0),
(69, 207, 'Sidebar', 0, 0, 0, 0),
(70, 207, 'Page Footer', 0, 0, 0, 0),
(71, 208, 'Page Header', 0, 0, 0, 0),
(72, 208, 'Main', 0, 0, 0, 0),
(73, 208, 'Sidebar', 0, 0, 0, 0),
(74, 208, 'Page Footer', 0, 0, 0, 0),
(75, 209, 'Page Header', 0, 0, 0, 0),
(76, 209, 'Main', 0, 0, 0, 0),
(77, 209, 'Sidebar', 0, 0, 0, 0),
(78, 209, 'Page Footer', 0, 0, 0, 0),
(79, 210, 'Page Header', 0, 0, 0, 0),
(80, 210, 'Main', 0, 0, 0, 0),
(81, 210, 'Sidebar', 0, 0, 0, 0),
(82, 210, 'Page Footer', 0, 0, 0, 0),
(83, 197, 'Main', 0, 0, 0, 0),
(84, 197, 'Main : 31', 0, 0, 0, 83),
(85, 197, 'Main : 32', 0, 0, 0, 83),
(86, 197, 'Main : 33', 0, 0, 0, 83),
(87, 197, 'Main : 34', 0, 0, 0, 83),
(88, 197, 'Main : 35', 0, 0, 0, 83),
(89, 197, 'Main : 36', 0, 0, 0, 83),
(90, 197, 'Main : 37', 0, 0, 0, 83),
(91, 199, 'Main', 0, 0, 0, 0),
(92, 199, 'Main : 13', 0, 0, 0, 0),
(93, 199, 'Main : 14', 0, 0, 0, 0),
(94, 212, 'Page Footer', 0, 0, 0, 0),
(95, 212, 'Main', 0, 0, 0, 0),
(96, 212, 'Sidebar', 0, 0, 0, 0),
(97, 213, 'Page Footer', 0, 0, 0, 0),
(98, 213, 'Main', 0, 0, 0, 0),
(99, 213, 'Sidebar', 0, 0, 0, 0),
(100, 214, 'Page Footer', 0, 0, 0, 0),
(101, 214, 'Main', 0, 0, 0, 0),
(102, 214, 'Sidebar', 0, 0, 0, 0),
(103, 200, 'Main', 0, 0, 0, 0),
(104, 201, 'Main', 0, 0, 0, 0),
(105, 201, 'Main : 38', 0, 0, 0, 104),
(106, 201, 'Main : 39', 0, 0, 0, 104),
(107, 201, 'Main : 40', 0, 0, 0, 104),
(108, 201, 'Main : 41', 0, 0, 0, 104),
(109, 201, 'Main : 42', 0, 0, 0, 104),
(110, 203, 'Main', 0, 0, 0, 0),
(111, 215, 'Main', 0, 0, 0, 0),
(112, 215, 'Main : 43', 0, 0, 0, 111),
(113, 215, 'Main : 44', 0, 0, 0, 111),
(114, 215, 'Main : 45', 0, 0, 0, 111),
(115, 215, 'Main : 46', 0, 0, 0, 111),
(116, 215, 'Main : 47', 0, 0, 0, 111),
(117, 215, 'Main : 48', 0, 0, 0, 111),
(118, 216, 'Main', 0, 0, 0, 0),
(119, 216, 'Main : 49', 0, 0, 0, 118),
(120, 216, 'Main : 50', 0, 0, 0, 118),
(121, 216, 'Main : 51', 0, 0, 0, 118),
(122, 216, 'Main : 52', 0, 0, 0, 118),
(123, 216, 'Main : 53', 0, 0, 0, 118),
(124, 219, 'Main', 0, 0, 0, 0),
(125, 219, 'Page Header', 0, 0, 0, 0),
(126, 219, 'Sidebar', 0, 0, 0, 0),
(127, 220, 'Main', 0, 0, 0, 0),
(128, 220, 'Page Header', 0, 0, 0, 0),
(129, 220, 'Sidebar', 0, 0, 0, 0),
(130, 217, 'Main', 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `atAddress`
--

CREATE TABLE `atAddress` (
  `address1` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address2` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address3` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state_province` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `postal_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `avID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atAddressSettings`
--

CREATE TABLE `atAddressSettings` (
  `akDefaultCountry` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `akHasCustomCountries` tinyint(1) NOT NULL,
  `customCountries` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:json_array)',
  `akGeolocateCountry` tinyint(1) NOT NULL,
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atBoolean`
--

CREATE TABLE `atBoolean` (
  `value` tinyint(1) NOT NULL,
  `avID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `atBoolean`
--

INSERT INTO `atBoolean` VALUES
(1, 9),
(1, 17),
(1, 19),
(1, 25),
(1, 26),
(1, 32),
(1, 33),
(1, 34),
(1, 35),
(1, 36),
(1, 37),
(1, 38),
(1, 39),
(1, 43),
(1, 44),
(1, 45),
(1, 46),
(1, 49),
(1, 50),
(1, 67),
(1, 70),
(1, 71),
(1, 73),
(1, 74),
(1, 75),
(1, 76),
(1, 77),
(1, 78),
(1, 79),
(1, 80),
(1, 81),
(1, 82),
(1, 92),
(1, 103),
(1, 104),
(1, 130),
(1, 140),
(1, 141),
(1, 143),
(0, 144),
(1, 147),
(1, 151),
(1, 152),
(1, 185),
(1, 186),
(1, 187),
(1, 198),
(1, 204),
(1, 220),
(0, 225),
(1, 235),
(0, 237),
(1, 238),
(0, 243),
(0, 250);

-- --------------------------------------------------------

--
-- Table structure for table `atBooleanSettings`
--

CREATE TABLE `atBooleanSettings` (
  `akCheckedByDefault` tinyint(1) NOT NULL,
  `checkboxLabel` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `atBooleanSettings`
--

INSERT INTO `atBooleanSettings` VALUES
(0, NULL, 5),
(0, 'Exclude Page from Navigation', 7),
(0, 'Exclude Page from Page List Blocks', 8),
(0, 'Feature this Page', 11),
(0, NULL, 12),
(0, NULL, 13),
(1, NULL, 14),
(1, NULL, 15),
(1, NULL, 22);

-- --------------------------------------------------------

--
-- Table structure for table `atDateTime`
--

CREATE TABLE `atDateTime` (
  `value` datetime DEFAULT NULL,
  `avID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atDateTimeSettings`
--

CREATE TABLE `atDateTimeSettings` (
  `akUseNowIfEmpty` tinyint(1) NOT NULL DEFAULT '0',
  `akDateDisplayMode` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `akTextCustomFormat` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT 'Custom format for text inputs',
  `akTimeResolution` int(10) unsigned NOT NULL DEFAULT '60' COMMENT 'Time resolution (in seconds)',
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atDefault`
--

CREATE TABLE `atDefault` (
  `value` longtext COLLATE utf8_unicode_ci,
  `avID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `atDefault`
--

INSERT INTO `atDefault` VALUES
('fa fa-th-large', 1),
('pages, add page, delete page, copy, move, alias', 2),
('pages, add page, delete page, copy, move, alias', 3),
('pages, add page, delete page, copy, move, alias, bulk', 4),
('find page, search page, search, find, pages, sitemap', 5),
('add file, delete file, copy, move, alias, resize, crop, rename, images, title, attribute', 6),
('file, file attributes, title, attribute, description, rename', 7),
('files, category, categories', 8),
('new file set', 10),
('users, groups, people, find, delete user, remove user, change password, password', 11),
('find, search, people, delete user, remove user, change password, password', 12),
('user, group, people, permissions, expire, badges', 13),
('user, group, people, messages', 14),
('user attributes, user data, gather data, registration data', 15),
('new user, create', 16),
('new user group, new group, group, create', 18),
('group set', 20),
('community, points, karma', 21),
('action, community actions', 22),
('forms, log, error, email, mysql, exception, survey', 23),
('forms, questions, response, data', 24),
('questions, quiz, response', 27),
('forms, log, error, email, mysql, exception, survey, history', 28),
('changes, csv, report', 29),
('new theme, theme, active theme, change theme, template, css', 30),
('page types', 31),
('page attributes, custom', 40),
('single, page, custom, application', 41),
('atom, rss, feed, syndication', 42),
('icon-bullhorn', 47),
('stacks, global areas, reusable content, scrapbook, copy, paste, paste block, copy block, site name, logo', 48),
('edit stacks, view stacks, all stacks', 51),
('block, refresh, custom', 52),
('add-on, addon, add on, package, app, ecommerce, discussions, forums, themes, templates, blocks', 53),
('add-on, addon, ecommerce, install, discussions, forums, themes, templates, blocks', 54),
('update, upgrade', 55),
('concretecms.org, my account, marketplace', 56),
('buy theme, new theme, marketplace, template', 57),
('buy addon, buy add on, buy add-on, purchase addon, purchase add on, purchase add-on, find addon, new addon, marketplace', 58),
('dashboard, configuration', 59),
('website name, title', 60),
('accessibility, easy mode', 61),
('sharing, facebook, twitter', 62),
('logo, favicon, iphone, icon, bookmark', 63),
('tinymce, content block, fonts, editor, content, overlay', 64),
('translate, translation, internationalization, multilingual', 65),
('languages, update, gettext, translation, translate', 66),
('timezone, profile, locale', 68),
('site attributes', 69),
('checkin, check-in, check, force', 72),
('multilingual, localization, internationalization, i18n', 83),
('vanity, pretty url, redirection, hostname, canonical, seo, pageview, view', 84),
('bulk, seo, change keywords, engine, optimization, search', 85),
('traffic, statistics, google analytics, quant, pageviews, hits', 86),
('pretty, slug', 87),
('configure search, site search, search option', 88),
('security, files, media, extension, manager, upload', 89),
('file options, file manager, upload, modify', 90),
('images, picture, responsive, retina', 91),
('thumbnail, format, png, jpg, jpeg, quality, compression, gd, imagick, imagemagick, transparency', 93),
('uploading, upload, images, image, resizing, manager, exif, rotation, rotate, quality, compression, png, jpg, jpeg', 94),
('security, alternate storage, hide files', 95),
('files, export, csv, bom, encoding', 96),
('cache option, change cache, override, turn on cache, turn off cache, no cache, page cache, caching', 97),
('cache option, turn off cache, no cache, page cache, caching', 98),
('index search, reindex search, build sitemap, sitemap.xml, clear old versions, page versions, remove old', 99),
('editors, hide site, offline, private, public, access', 100),
('security, actions, administrator, admin, package, marketplace, search', 101),
('security, lock ip, lock out, block ip, address, restrict, access', 102),
('security, registration', 105),
('antispam, block spam, security', 106),
('lock site, under construction, hide, hidden', 107),
('trusted, proxy, proxies, ip, header, cloudflare', 108),
('signup, new user, community, public registration, public, registration', 109),
('profile, login, redirect, specific, dashboard, administrators', 110),
('member profile, member page, community, forums, social, avatar', 111),
('auth, authentication, types, oauth, facebook, login, registration', 112),
('global, password, reset, change password, force, sign out', 113),
('login, logout, user, agent, ip, change, security, session, invalidation, invalid', 114),
('password, requirements, code, key, login, registration, security, nist', 115),
('session, options', 116),
('smtp, mail settings', 117),
('email server, mail settings, mail configuration, external, internal', 118),
('test smtp, test mail', 119),
('email server, mail settings, mail configuration, private message, message system, import, email, message', 120),
('mail settings, mail configuration, email, sender', 121),
('conversations', 122),
('conversations', 123),
('conversations ratings, ratings, community, community points', 124),
('conversations bad words, banned words, banned, bad words, bad, words, list', 125),
('attribute configuration', 126),
('attributes, types', 127),
('attributes, sets', 128),
('topics, tags, taxonomy', 129),
('overrides, system info, debug, support, help', 131),
('errors, exceptions, develop, support, help', 132),
('email, logging, logs, smtp, pop, errors, mysql, log', 133),
('network, proxy server', 134),
('database, entities, doctrine, orm', 135),
('database, character set, charset, collation, utf8', 136),
('geolocation, ip, address, country, nation, place, locate', 137),
('upgrade, new version, update', 138),
('API, programming, public, app', 139),
('fa fa-th', 145),
('fa fa-trash-o', 146),
('fa fa-briefcase', 148),
('fa fa-edit', 149),
('Test Client', 190),
('Test Client', 195),
('Test Client 2', 201),
('Test Client 2', 207),
('Test Client 2', 212),
('Test Client 2', 217),
('', 221),
('', 222),
('', 223),
('', 224),
('', 232),
('', 233),
('', 234),
('', 236),
('', 239),
('', 240),
('', 241),
('', 242),
('\n                        Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla massa lacus, vehicula eu interdum convallis, laoreet id lectus. Nunc turpis elit, aliquam sit amet aliquam tincidunt, dapibus vel tellus. ', 245),
('', 246),
('', 247),
('', 248),
('', 249),
('\n                        Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla massa lacus, vehicula eu interdum convallis, laoreet id lectus. Nunc turpis elit, aliquam sit amet aliquam tincidunt, dapibus vel tellus. ', 252);

-- --------------------------------------------------------

--
-- Table structure for table `atEmptySettings`
--

CREATE TABLE `atEmptySettings` (
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `atEmptySettings`
--

INSERT INTO `atEmptySettings` VALUES
(4),
(16),
(17),
(18),
(19);

-- --------------------------------------------------------

--
-- Table structure for table `atExpress`
--

CREATE TABLE `atExpress` (
  `avID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atExpressSelectedEntries`
--

CREATE TABLE `atExpressSelectedEntries` (
  `avID` int(10) unsigned NOT NULL,
  `exEntryID` int(11) NOT NULL,
  PRIMARY KEY (`avID`,`exEntryID`),
  KEY `IDX_C9D404BBA2A82A5D` (`avID`),
  KEY `IDX_C9D404BB6DCB6296` (`exEntryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atExpressSettings`
--

CREATE TABLE `atExpressSettings` (
  `exEntityID` char(36) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`),
  KEY `IDX_E8F67F0FCE2D7284` (`exEntityID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atFile`
--

CREATE TABLE `atFile` (
  `fID` int(10) unsigned DEFAULT NULL,
  `avID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`),
  KEY `IDX_73D17D61E3111F45` (`fID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `atFile`
--

INSERT INTO `atFile` VALUES
(1, 230),
(3, 226),
(7, 188),
(8, 228),
(9, 193),
(11, 215),
(12, 210),
(15, 205),
(16, 199);

-- --------------------------------------------------------

--
-- Table structure for table `atFileSettings`
--

CREATE TABLE `atFileSettings` (
  `akFileManagerMode` int(11) NOT NULL,
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `atFileSettings`
--

INSERT INTO `atFileSettings` VALUES
(0, 23);

-- --------------------------------------------------------

--
-- Table structure for table `atNumber`
--

CREATE TABLE `atNumber` (
  `value` decimal(14,4) DEFAULT NULL,
  `avID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `atNumber`
--

INSERT INTO `atNumber` VALUES
('2.0000', 142),
('1.0000', 150),
('1600.0000', 153),
('1066.0000', 154),
('200.0000', 155),
('200.0000', 156),
('500.0000', 157),
('500.0000', 158),
('460.0000', 159),
('460.0000', 160),
('592.0000', 161),
('397.0000', 162),
('250.0000', 163),
('252.0000', 164),
('1600.0000', 165),
('1067.0000', 166),
('200.0000', 167),
('200.0000', 168),
('1499.0000', 169),
('1067.0000', 170),
('1100.0000', 171),
('263.0000', 172),
('1600.0000', 173),
('1067.0000', 174),
('1600.0000', 175),
('1067.0000', 176),
('1100.0000', 177),
('368.0000', 178),
('1100.0000', 179),
('368.0000', 180),
('1600.0000', 181),
('1067.0000', 182),
('1600.0000', 183),
('953.0000', 184);

-- --------------------------------------------------------

--
-- Table structure for table `atSelect`
--

CREATE TABLE `atSelect` (
  `avID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `atSelect`
--

INSERT INTO `atSelect` VALUES
(191),
(192),
(196),
(197),
(202),
(203),
(208),
(209),
(213),
(214),
(218),
(219),
(244),
(251);

-- --------------------------------------------------------

--
-- Table structure for table `atSelectedSocialLinks`
--

CREATE TABLE `atSelectedSocialLinks` (
  `avsID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `service` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `serviceInfo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `avID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`avsID`),
  KEY `IDX_10743709A2A82A5D` (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `atSelectedTopics`
--

CREATE TABLE `atSelectedTopics` (
  `avTreeTopicNodeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `treeNodeID` int(10) unsigned NOT NULL,
  `avID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`avTreeTopicNodeID`),
  KEY `IDX_E42A7D5BA2A82A5D` (`avID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=10 ;

--
-- Dumping data for table `atSelectedTopics`
--

INSERT INTO `atSelectedTopics` VALUES
(1, 35, 189),
(2, 37, 194),
(3, 35, 200),
(4, 35, 206),
(5, 35, 211),
(6, 35, 216),
(7, 30, 227),
(8, 32, 229),
(9, 30, 231);

-- --------------------------------------------------------

--
-- Table structure for table `atSelectOptionLists`
--

CREATE TABLE `atSelectOptionLists` (
  `avSelectOptionListID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`avSelectOptionListID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `atSelectOptionLists`
--

INSERT INTO `atSelectOptionLists` VALUES
(1),
(2),
(3),
(4),
(5);

-- --------------------------------------------------------

--
-- Table structure for table `atSelectOptions`
--

CREATE TABLE `atSelectOptions` (
  `avSelectOptionID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `isEndUserAdded` tinyint(1) NOT NULL,
  `isDeleted` tinyint(1) NOT NULL DEFAULT '0',
  `displayOrder` int(11) NOT NULL,
  `value` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `avSelectOptionListID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`avSelectOptionID`),
  KEY `IDX_797414B0CB59257C` (`avSelectOptionListID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=27 ;

--
-- Dumping data for table `atSelectOptions`
--

INSERT INTO `atSelectOptions` VALUES
(1, 1, 0, 0, 'Finance', 2),
(2, 1, 0, 1, 'Marketing and Sales', 2),
(3, 1, 0, 2, 'Human Resources', 2),
(4, 1, 0, 3, 'Technical and Operations', 2),
(5, 1, 0, 4, 'Management', 2),
(6, 1, 0, 0, 'Architecture', 3),
(7, 1, 0, 1, 'Multimedia', 3),
(8, 1, 0, 2, 'Design', 3),
(9, 1, 0, 3, 'Production', 3),
(10, 1, 0, 4, 'Development', 3),
(11, 1, 0, 5, 'Quality Assurance', 3),
(12, 1, 0, 0, 'HTML', 4),
(13, 1, 0, 1, 'JavaScript', 4),
(14, 1, 0, 2, 'PHP', 4),
(15, 1, 0, 3, 'Database', 4),
(16, 1, 0, 4, 'CSS', 4),
(17, 1, 0, 5, 'Ruby', 4),
(18, 1, 0, 6, 'Java', 4),
(19, 1, 0, 7, 'iOS/Android/App Development', 4),
(20, 1, 0, 8, 'Photoshop', 4),
(21, 1, 0, 9, 'Python', 4),
(22, 1, 0, 10, 'Writing', 4),
(23, 1, 0, 0, 'I love your work', 5),
(24, 1, 0, 1, 'Great website', 5),
(25, 1, 0, 2, 'Check out this cool thing I found', 5),
(26, 1, 0, 3, 'Other', 5);

-- --------------------------------------------------------

--
-- Table structure for table `atSelectOptionsSelected`
--

CREATE TABLE `atSelectOptionsSelected` (
  `avID` int(10) unsigned NOT NULL,
  `avSelectOptionID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`,`avSelectOptionID`),
  KEY `IDX_40C97EC3A2A82A5D` (`avID`),
  KEY `IDX_40C97EC3E584C274` (`avSelectOptionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `atSelectOptionsSelected`
--

INSERT INTO `atSelectOptionsSelected` VALUES
(191, 6),
(191, 8),
(191, 9),
(192, 12),
(192, 13),
(192, 14),
(196, 6),
(197, 14),
(202, 7),
(202, 9),
(202, 10),
(203, 12),
(203, 13),
(203, 14),
(203, 16),
(208, 8),
(209, 20),
(213, 8),
(214, 20),
(218, 8),
(219, 20),
(244, 4),
(251, 2);

-- --------------------------------------------------------

--
-- Table structure for table `atSelectSettings`
--

CREATE TABLE `atSelectSettings` (
  `akSelectAllowMultipleValues` tinyint(1) NOT NULL,
  `akSelectAllowOtherValues` tinyint(1) NOT NULL,
  `akHideNoneOption` tinyint(1) NOT NULL,
  `akSelectOptionDisplayOrder` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `akDisplayMultipleValuesOnSelect` tinyint(1) NOT NULL,
  `avSelectOptionListID` int(10) unsigned DEFAULT NULL,
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`),
  UNIQUE KEY `UNIQ_5D514424CB59257C` (`avSelectOptionListID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `atSelectSettings`
--

INSERT INTO `atSelectSettings` VALUES
(1, 1, 0, 'display_asc', 0, 1, 10),
(0, 0, 0, 'display_asc', 0, 2, 20),
(1, 0, 0, 'display_asc', 0, 3, 28),
(1, 0, 0, 'display_asc', 0, 4, 29),
(0, 0, 0, 'display_asc', 1, 5, 33);

-- --------------------------------------------------------

--
-- Table structure for table `atSite`
--

CREATE TABLE `atSite` (
  `siteID` int(10) unsigned DEFAULT NULL,
  `avID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`),
  KEY `IDX_960D4295521D8435` (`siteID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atSocialLinks`
--

CREATE TABLE `atSocialLinks` (
  `avID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `atTextareaSettings`
--

CREATE TABLE `atTextareaSettings` (
  `akTextareaDisplayMode` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `atTextareaSettings`
--

INSERT INTO `atTextareaSettings` VALUES
('', 2),
('', 3),
('', 6),
('', 9),
('text', 21),
('text', 34);

-- --------------------------------------------------------

--
-- Table structure for table `atTextSettings`
--

CREATE TABLE `atTextSettings` (
  `akTextPlaceholder` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `atTextSettings`
--

INSERT INTO `atTextSettings` VALUES
('', 1),
('', 27),
('', 30),
('', 31),
('', 32);

-- --------------------------------------------------------

--
-- Table structure for table `atTopic`
--

CREATE TABLE `atTopic` (
  `avID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `atTopic`
--

INSERT INTO `atTopic` VALUES
(189),
(194),
(200),
(206),
(211),
(216),
(227),
(229),
(231);

-- --------------------------------------------------------

--
-- Table structure for table `atTopicSettings`
--

CREATE TABLE `atTopicSettings` (
  `akTopicParentNodeID` int(11) NOT NULL,
  `akTopicTreeID` int(11) NOT NULL,
  `akTopicAllowMultipleValues` tinyint(1) NOT NULL DEFAULT '1',
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `atTopicSettings`
--

INSERT INTO `atTopicSettings` VALUES
(24, 4, 0, 24),
(33, 5, 0, 25),
(38, 6, 0, 26);

-- --------------------------------------------------------

--
-- Table structure for table `AttributeKeyCategories`
--

CREATE TABLE `AttributeKeyCategories` (
  `akCategoryID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `akCategoryHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `akCategoryAllowSets` int(11) NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`akCategoryID`),
  UNIQUE KEY `UNIQ_A2A0CC67FA0337B` (`akCategoryHandle`),
  KEY `IDX_A2A0CC67CE45CBB0` (`pkgID`),
  KEY `pkgID` (`pkgID`,`akCategoryID`),
  KEY `akCategoryHandle` (`akCategoryHandle`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `AttributeKeyCategories`
--

INSERT INTO `AttributeKeyCategories` VALUES
(1, 'collection', 1, NULL),
(2, 'user', 1, NULL),
(3, 'file', 1, NULL),
(4, 'site', 1, NULL),
(5, 'event', 1, NULL),
(6, 'site_type', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `AttributeKeys`
--

CREATE TABLE `AttributeKeys` (
  `akID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `akHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `akName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `akIsSearchable` tinyint(1) NOT NULL,
  `akIsInternal` tinyint(1) NOT NULL,
  `akIsSearchableIndexed` tinyint(1) NOT NULL,
  `atID` int(10) unsigned DEFAULT NULL,
  `akCategoryID` int(10) unsigned DEFAULT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  `akCategory` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`akID`),
  KEY `IDX_DCA32C62A12CFE33` (`atID`),
  KEY `IDX_DCA32C62B059B76B` (`akCategoryID`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=35 ;

--
-- Dumping data for table `AttributeKeys`
--

INSERT INTO `AttributeKeys` VALUES
(1, 'meta_title', 'Meta Title', 1, 0, 0, 1, 1, NULL, 'pagekey'),
(2, 'meta_description', 'Meta Description', 1, 0, 0, 2, 1, NULL, 'pagekey'),
(3, 'meta_keywords', 'Meta Keywords', 1, 0, 0, 2, 1, NULL, 'pagekey'),
(4, 'desktop_priority', 'Desktop Priority', 1, 1, 0, 6, 1, NULL, 'pagekey'),
(5, 'is_desktop', 'Is Desktop', 1, 1, 0, 3, 1, NULL, 'pagekey'),
(6, 'icon_dashboard', 'Dashboard Icon', 1, 1, 0, 2, 1, NULL, 'pagekey'),
(7, 'exclude_nav', 'Exclude From Nav', 1, 0, 0, 3, 1, NULL, 'pagekey'),
(8, 'exclude_page_list', 'Exclude From Page List', 1, 0, 0, 3, 1, NULL, 'pagekey'),
(9, 'header_extra_content', 'Header Extra Content', 1, 0, 0, 2, 1, NULL, 'pagekey'),
(10, 'tags', 'Tags', 1, 0, 1, 7, 1, NULL, 'pagekey'),
(11, 'is_featured', 'Is Featured', 1, 0, 0, 3, 1, NULL, 'pagekey'),
(12, 'exclude_search_index', 'Exclude From Search Index', 1, 0, 0, 3, 1, NULL, 'pagekey'),
(13, 'exclude_sitemapxml', 'Exclude From sitemap.xml', 1, 0, 0, 3, 1, NULL, 'pagekey'),
(14, 'profile_private_messages_enabled', 'I would like to receive private messages.', 1, 0, 0, 3, 2, NULL, 'userkey'),
(15, 'profile_private_messages_notification_enabled', 'Send me email notifications when I receive a private message.', 1, 0, 0, 3, 2, NULL, 'userkey'),
(16, 'width', 'Width', 1, 0, 0, 6, 3, NULL, 'filekey'),
(17, 'height', 'Height', 1, 0, 0, 6, 3, NULL, 'filekey'),
(18, 'account_profile_links', 'Personal Links', 1, 0, 0, 14, 2, NULL, 'userkey'),
(19, 'duration', 'Duration', 1, 0, 0, 6, 3, NULL, 'filekey'),
(20, 'job_posting_department', 'Department', 1, 0, 1, 7, 1, NULL, 'pagekey'),
(21, 'job_location', 'Location', 1, 0, 1, 2, 1, NULL, 'pagekey'),
(22, 'exclude_subpages_from_nav', 'Exclude Sub-Pages From Nav', 1, 0, 1, 3, 1, NULL, 'pagekey'),
(23, 'thumbnail', 'Thumbnail', 1, 0, 1, 5, 1, NULL, 'pagekey'),
(24, 'blog_entry_topics', 'Blog Entry Topics', 1, 0, 1, 13, 1, NULL, 'pagekey'),
(25, 'project_topics', 'Project Topics', 1, 0, 1, 13, 1, NULL, 'pagekey'),
(26, 'event_categories', 'Event Categories', 1, 0, 1, 13, 5, NULL, 'eventkey'),
(27, 'project_client', 'Client', 1, 0, 1, 1, 1, NULL, 'pagekey'),
(28, 'project_tasks', 'Task', 1, 0, 1, 7, 1, NULL, 'pagekey'),
(29, 'project_skills', 'Skills', 1, 0, 1, 7, 1, NULL, 'pagekey'),
(30, 'contact_question_first_name', 'First Name', 1, 0, 1, 1, NULL, NULL, 'expresskey'),
(31, 'contact_question_last_name', 'Last Name', 1, 0, 1, 1, NULL, NULL, 'expresskey'),
(32, 'contact_question_email_address', 'Email Address', 1, 0, 1, 11, NULL, NULL, 'expresskey'),
(33, 'contact_question_subject', 'Subject', 1, 0, 1, 7, NULL, NULL, 'expresskey'),
(34, 'contact_question_message', 'Message', 1, 0, 1, 2, NULL, NULL, 'expresskey');

-- --------------------------------------------------------

--
-- Table structure for table `AttributeSetKeys`
--

CREATE TABLE `AttributeSetKeys` (
  `asDisplayOrder` int(10) unsigned NOT NULL,
  `akID` int(10) unsigned NOT NULL,
  `asID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`,`asID`),
  KEY `IDX_222F72D8B6561A7E` (`akID`),
  KEY `IDX_222F72D8A463E8B6` (`asID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `AttributeSetKeys`
--

INSERT INTO `AttributeSetKeys` VALUES
(0, 1, 1),
(1, 2, 1),
(1, 7, 2),
(2, 8, 2),
(2, 9, 1),
(4, 10, 2),
(0, 11, 2),
(3, 12, 2),
(3, 13, 1),
(0, 20, 3),
(1, 21, 3),
(6, 22, 2),
(5, 23, 2),
(0, 24, 4),
(0, 25, 5),
(0, 26, 6),
(1, 27, 5),
(2, 28, 5),
(3, 29, 5);

-- --------------------------------------------------------

--
-- Table structure for table `AttributeSets`
--

CREATE TABLE `AttributeSets` (
  `asID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `asName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `asDisplayOrder` int(10) unsigned NOT NULL,
  `asIsLocked` tinyint(1) NOT NULL,
  `akCategoryID` int(10) unsigned DEFAULT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`asID`),
  KEY `IDX_FCA02D5FB059B76B` (`akCategoryID`),
  KEY `asHandle` (`asHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `AttributeSets`
--

INSERT INTO `AttributeSets` VALUES
(1, 'seo', 'SEO', 0, 0, 1, NULL),
(2, 'navigation', 'Navigation and Indexing', 0, 0, 1, NULL),
(3, 'job_board', 'Jobs', 0, 0, 1, NULL),
(4, 'blog', 'Blog', 0, 0, 1, NULL),
(5, 'portfolio', 'Portfolio', 0, 0, 1, NULL),
(6, 'event_categories', 'Categories', 0, 0, 5, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `AttributeTypeCategories`
--

CREATE TABLE `AttributeTypeCategories` (
  `akCategoryID` int(10) unsigned NOT NULL,
  `atID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akCategoryID`,`atID`),
  KEY `IDX_49A9CABEB059B76B` (`akCategoryID`),
  KEY `IDX_49A9CABEA12CFE33` (`atID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `AttributeTypeCategories`
--

INSERT INTO `AttributeTypeCategories` VALUES
(1, 1),
(1, 2),
(1, 3),
(1, 4),
(1, 5),
(1, 6),
(1, 7),
(1, 9),
(1, 10),
(1, 11),
(1, 12),
(1, 13),
(1, 15),
(1, 16),
(1, 17),
(1, 18),
(1, 19),
(1, 20),
(2, 1),
(2, 2),
(2, 3),
(2, 4),
(2, 6),
(2, 7),
(2, 8),
(2, 9),
(2, 10),
(2, 11),
(2, 13),
(2, 14),
(2, 17),
(2, 19),
(2, 20),
(3, 1),
(3, 2),
(3, 3),
(3, 4),
(3, 6),
(3, 7),
(3, 9),
(3, 10),
(3, 11),
(3, 12),
(3, 13),
(3, 17),
(3, 19),
(3, 20),
(4, 1),
(4, 2),
(4, 3),
(4, 4),
(4, 5),
(4, 6),
(4, 7),
(4, 8),
(4, 9),
(4, 10),
(4, 11),
(4, 13),
(4, 15),
(4, 17),
(4, 18),
(4, 19),
(4, 21),
(5, 1),
(5, 2),
(5, 3),
(5, 4),
(5, 5),
(5, 6),
(5, 7),
(5, 8),
(5, 9),
(5, 10),
(5, 11),
(5, 13),
(5, 19),
(6, 1),
(6, 2),
(6, 3),
(6, 4),
(6, 5),
(6, 6),
(6, 7),
(6, 8),
(6, 9),
(6, 10),
(6, 11),
(6, 13),
(6, 15),
(6, 17),
(6, 18),
(6, 19),
(6, 21);

-- --------------------------------------------------------

--
-- Table structure for table `AttributeTypes`
--

CREATE TABLE `AttributeTypes` (
  `atID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `atHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `atName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`atID`),
  UNIQUE KEY `UNIQ_53580A7F46AA0F38` (`atHandle`),
  KEY `IDX_53580A7FCE45CBB0` (`pkgID`),
  KEY `pkgID` (`pkgID`,`atID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=22 ;

--
-- Dumping data for table `AttributeTypes`
--

INSERT INTO `AttributeTypes` VALUES
(1, 'text', 'Text', NULL),
(2, 'textarea', 'Text Area', NULL),
(3, 'boolean', 'Checkbox', NULL),
(4, 'date_time', 'Date/Time', NULL),
(5, 'image_file', 'Image/File', NULL),
(6, 'number', 'Number', NULL),
(7, 'select', 'Option List', NULL),
(8, 'address', 'Address', NULL),
(9, 'telephone', 'Phone Number', NULL),
(10, 'url', 'URL', NULL),
(11, 'email', 'Email', NULL),
(12, 'rating', 'Rating', NULL),
(13, 'topics', 'Topics', NULL),
(14, 'social_links', 'Social Links', NULL),
(15, 'calendar', 'Calendar', NULL),
(16, 'calendar_event', 'Calendar Event', NULL),
(17, 'express', 'Express Entity', NULL),
(18, 'page_selector', 'Page Selector', NULL),
(19, 'user_selector', 'User Selector', NULL),
(20, 'site', 'Site', NULL),
(21, 'user_group', 'User Group', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `AttributeValues`
--

CREATE TABLE `AttributeValues` (
  `avID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `akID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`avID`),
  KEY `IDX_DCCE7864B6561A7E` (`akID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=253 ;

--
-- Dumping data for table `AttributeValues`
--

INSERT INTO `AttributeValues` VALUES
(221, 1),
(232, 1),
(239, 1),
(246, 1),
(222, 2),
(233, 2),
(240, 2),
(247, 2),
(2, 3),
(3, 3),
(4, 3),
(5, 3),
(6, 3),
(7, 3),
(8, 3),
(10, 3),
(11, 3),
(12, 3),
(13, 3),
(14, 3),
(15, 3),
(16, 3),
(18, 3),
(20, 3),
(21, 3),
(22, 3),
(23, 3),
(24, 3),
(27, 3),
(28, 3),
(29, 3),
(30, 3),
(31, 3),
(40, 3),
(41, 3),
(42, 3),
(48, 3),
(51, 3),
(52, 3),
(53, 3),
(54, 3),
(55, 3),
(56, 3),
(57, 3),
(58, 3),
(59, 3),
(60, 3),
(61, 3),
(62, 3),
(63, 3),
(64, 3),
(65, 3),
(66, 3),
(68, 3),
(69, 3),
(72, 3),
(83, 3),
(84, 3),
(85, 3),
(86, 3),
(87, 3),
(88, 3),
(89, 3),
(90, 3),
(91, 3),
(93, 3),
(94, 3),
(95, 3),
(96, 3),
(97, 3),
(98, 3),
(99, 3),
(100, 3),
(101, 3),
(102, 3),
(105, 3),
(106, 3),
(107, 3),
(108, 3),
(109, 3),
(110, 3),
(111, 3),
(112, 3),
(113, 3),
(114, 3),
(115, 3),
(116, 3),
(117, 3),
(118, 3),
(119, 3),
(120, 3),
(121, 3),
(122, 3),
(123, 3),
(124, 3),
(125, 3),
(126, 3),
(127, 3),
(128, 3),
(129, 3),
(131, 3),
(132, 3),
(133, 3),
(134, 3),
(135, 3),
(136, 3),
(137, 3),
(138, 3),
(139, 3),
(223, 3),
(234, 3),
(241, 3),
(248, 3),
(142, 4),
(150, 4),
(143, 5),
(151, 5),
(1, 6),
(47, 6),
(145, 6),
(146, 6),
(148, 6),
(149, 6),
(9, 7),
(17, 7),
(19, 7),
(25, 7),
(32, 7),
(33, 7),
(34, 7),
(35, 7),
(36, 7),
(37, 7),
(38, 7),
(39, 7),
(43, 7),
(45, 7),
(49, 7),
(67, 7),
(70, 7),
(73, 7),
(75, 7),
(77, 7),
(79, 7),
(81, 7),
(92, 7),
(103, 7),
(104, 7),
(140, 7),
(144, 7),
(152, 7),
(185, 7),
(235, 7),
(238, 7),
(224, 9),
(236, 9),
(242, 9),
(249, 9),
(187, 11),
(198, 11),
(204, 11),
(26, 12),
(44, 12),
(46, 12),
(50, 12),
(71, 12),
(74, 12),
(76, 12),
(78, 12),
(80, 12),
(82, 12),
(130, 12),
(141, 12),
(147, 12),
(225, 13),
(237, 13),
(243, 13),
(250, 13),
(153, 16),
(155, 16),
(157, 16),
(159, 16),
(161, 16),
(163, 16),
(165, 16),
(167, 16),
(169, 16),
(171, 16),
(173, 16),
(175, 16),
(177, 16),
(179, 16),
(181, 16),
(183, 16),
(154, 17),
(156, 17),
(158, 17),
(160, 17),
(162, 17),
(164, 17),
(166, 17),
(168, 17),
(170, 17),
(172, 17),
(174, 17),
(176, 17),
(178, 17),
(180, 17),
(182, 17),
(184, 17),
(244, 20),
(251, 20),
(245, 21),
(252, 21),
(186, 22),
(220, 22),
(188, 23),
(193, 23),
(199, 23),
(205, 23),
(210, 23),
(215, 23),
(226, 23),
(228, 23),
(230, 23),
(227, 24),
(229, 24),
(231, 24),
(189, 25),
(194, 25),
(200, 25),
(206, 25),
(211, 25),
(216, 25),
(190, 27),
(195, 27),
(201, 27),
(207, 27),
(212, 27),
(217, 27),
(191, 28),
(196, 28),
(202, 28),
(208, 28),
(213, 28),
(218, 28),
(192, 29),
(197, 29),
(203, 29),
(209, 29),
(214, 29),
(219, 29);

-- --------------------------------------------------------

--
-- Table structure for table `atUserGroupSettings`
--

CREATE TABLE `atUserGroupSettings` (
  `akDisplayGroupsBeneathSpecificParent` tinyint(1) NOT NULL,
  `akDisplayGroupsBeneathParentID` int(11) NOT NULL,
  `akGroupSelectionMethod` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `AuthenticationTypes`
--

CREATE TABLE `AuthenticationTypes` (
  `authTypeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `authTypeHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `authTypeName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `authTypeIsEnabled` tinyint(1) NOT NULL,
  `authTypeDisplayOrder` int(10) unsigned DEFAULT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`authTypeID`),
  UNIQUE KEY `authTypeHandle` (`authTypeHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `AuthenticationTypes`
--

INSERT INTO `AuthenticationTypes` VALUES
(1, 'concrete', 'Standard', 1, 0, 0),
(2, 'community', 'concrete5.org', 0, 0, 0),
(3, 'facebook', 'Facebook', 0, 0, 0),
(4, 'twitter', 'Twitter', 0, 0, 0),
(5, 'google', 'Google', 0, 0, 0),
(6, 'external_concrete5', 'External concrete5', 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `authTypeConcreteCookieMap`
--

CREATE TABLE `authTypeConcreteCookieMap` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `token` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `uID` int(11) DEFAULT NULL,
  `validThrough` int(11) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `token` (`token`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `BannedWords`
--

CREATE TABLE `BannedWords` (
  `bwID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bannedWord` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`bwID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `BannedWords`
--

INSERT INTO `BannedWords` VALUES
(1, 'fuck'),
(2, 'shit'),
(3, 'bitch'),
(4, 'ass');

-- --------------------------------------------------------

--
-- Table structure for table `BasicWorkflowPermissionAssignments`
--

CREATE TABLE `BasicWorkflowPermissionAssignments` (
  `wfID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`wfID`,`pkID`,`paID`),
  KEY `pkID` (`pkID`),
  KEY `paID` (`paID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `BasicWorkflowProgressData`
--

CREATE TABLE `BasicWorkflowProgressData` (
  `wpID` int(10) unsigned NOT NULL DEFAULT '0',
  `uIDStarted` int(10) unsigned NOT NULL DEFAULT '0',
  `uIDCompleted` int(10) unsigned NOT NULL DEFAULT '0',
  `wpDateCompleted` datetime DEFAULT NULL,
  PRIMARY KEY (`wpID`),
  KEY `uIDStarted` (`uIDStarted`),
  KEY `uIDCompleted` (`uIDCompleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `BlockFeatureAssignments`
--

CREATE TABLE `BlockFeatureAssignments` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '0',
  `bID` int(10) unsigned NOT NULL DEFAULT '0',
  `faID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`bID`,`faID`),
  KEY `faID` (`faID`,`cID`,`cvID`),
  KEY `bID` (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `BlockFeatureAssignments`
--

INSERT INTO `BlockFeatureAssignments` VALUES
(211, 1, 29, 1),
(197, 1, 123, 2),
(212, 1, 125, 3),
(213, 1, 127, 4),
(214, 1, 129, 5),
(201, 1, 138, 6),
(215, 1, 145, 7),
(215, 1, 152, 8),
(215, 1, 156, 9),
(216, 1, 159, 10);

-- --------------------------------------------------------

--
-- Table structure for table `BlockPermissionAssignments`
--

CREATE TABLE `BlockPermissionAssignments` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '0',
  `bID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`bID`,`pkID`,`paID`),
  KEY `bID` (`bID`),
  KEY `pkID` (`pkID`),
  KEY `paID` (`paID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `Blocks`
--

CREATE TABLE `Blocks` (
  `bID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bName` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bDateAdded` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `bDateModified` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `bFilename` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bIsActive` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `btID` int(10) unsigned NOT NULL DEFAULT '0',
  `uID` int(10) unsigned DEFAULT NULL,
  `btCachedBlockRecord` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`bID`),
  KEY `btID` (`btID`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=176 ;

--
-- Dumping data for table `Blocks`
--

INSERT INTO `Blocks` VALUES
(1, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 36, 1, NULL),
(2, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjI7czo5OiIAKgBfdGFibGUiO3M6MTY6ImJ0Q29yZUFyZWFMYXlvdXQiO3M6MTA6ImFyTGF5b3V0SUQiO3M6MToiMSI7fQ=='),
(3, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 40, 1, NULL),
(4, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 38, 1, NULL),
(5, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 37, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjU7czo5OiIAKgBfdGFibGUiO3M6MjE6ImJ0RGVza3RvcFNpdGVBY3Rpdml0eSI7czo1OiJ0eXBlcyI7czo4MjoiWyJmb3JtX3N1Ym1pc3Npb25zIiwic3VydmV5X3Jlc3VsdHMiLCJzaWdudXBzIiwiY29udmVyc2F0aW9uX21lc3NhZ2VzIiwid29ya2Zsb3ciXSI7fQ=='),
(6, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjY7czo5OiIAKgBfdGFibGUiO3M6MTY6ImJ0Q29yZUFyZWFMYXlvdXQiO3M6MTA6ImFyTGF5b3V0SUQiO3M6MToiMiI7fQ=='),
(7, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 15, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjc7czo5OiIAKgBfdGFibGUiO3M6MTI6ImJ0UnNzRGlzcGxheSI7czo1OiJ0aXRsZSI7czo5OiJUdXRvcmlhbHMiO3M6MzoidXJsIjtzOjUxOiJodHRwczovL2RvY3VtZW50YXRpb24uY29uY3JldGVjbXMub3JnL3Jzcy90dXRvcmlhbHMiO3M6MTA6ImRhdGVGb3JtYXQiO3M6MDoiIjtzOjE0OiJpdGVtc1RvRGlzcGxheSI7aToxO3M6MTE6InNob3dTdW1tYXJ5IjtpOjE7czoxNzoibGF1bmNoSW5OZXdXaW5kb3ciO2k6MTt9'),
(8, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 39, 1, NULL),
(9, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjk7czo5OiIAKgBfdGFibGUiO3M6MTY6ImJ0Q29yZUFyZWFMYXlvdXQiO3M6MTA6ImFyTGF5b3V0SUQiO3M6MToiMyI7fQ=='),
(10, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 43, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjEwO3M6OToiACoAX3RhYmxlIjtzOjIzOiJidERlc2t0b3BOZXdzZmxvd0xhdGVzdCI7czo0OiJzbG90IjtzOjE6IkEiO30='),
(11, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 43, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjExO3M6OToiACoAX3RhYmxlIjtzOjIzOiJidERlc2t0b3BOZXdzZmxvd0xhdGVzdCI7czo0OiJzbG90IjtzOjE6IkIiO30='),
(12, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 43, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjEyO3M6OToiACoAX3RhYmxlIjtzOjIzOiJidERlc2t0b3BOZXdzZmxvd0xhdGVzdCI7czo0OiJzbG90IjtzOjE6IkMiO30='),
(13, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 15, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjEzO3M6OToiACoAX3RhYmxlIjtzOjEyOiJidFJzc0Rpc3BsYXkiO3M6NToidGl0bGUiO3M6MjU6Ik5ld3MgZnJvbSBjb25jcmV0ZWNtcy5jb20iO3M6MzoidXJsIjtzOjM2OiJodHRwczovL3d3dy5jb25jcmV0ZWNtcy5jb20vcnNzL2Jsb2ciO3M6MTA6ImRhdGVGb3JtYXQiO3M6MDoiIjtzOjE0OiJpdGVtc1RvRGlzcGxheSI7aTozO3M6MTE6InNob3dTdW1tYXJ5IjtpOjE7czoxNzoibGF1bmNoSW5OZXdXaW5kb3ciO2k6MTt9'),
(14, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjE0O3M6OToiACoAX3RhYmxlIjtzOjE2OiJidENvcmVBcmVhTGF5b3V0IjtzOjEwOiJhckxheW91dElEIjtzOjE6IjQiO30='),
(15, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 41, 1, NULL),
(16, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjE2O3M6OToiACoAX3RhYmxlIjtzOjE2OiJidENvcmVBcmVhTGF5b3V0IjtzOjEwOiJhckxheW91dElEIjtzOjE6IjUiO30='),
(17, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 42, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjE3O3M6OToiACoAX3RhYmxlIjtzOjE4OiJidERlc2t0b3BEcmFmdExpc3QiO3M6MTM6ImRyYWZ0c1BlclBhZ2UiO2k6MTA7fQ=='),
(18, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjE4O3M6OToiACoAX3RhYmxlIjtzOjE2OiJidENvcmVBcmVhTGF5b3V0IjtzOjEwOiJhckxheW91dElEIjtzOjE6IjYiO30='),
(19, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 41, 1, NULL),
(20, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjIwO3M6OToiACoAX3RhYmxlIjtzOjE2OiJidENvcmVBcmVhTGF5b3V0IjtzOjEwOiJhckxheW91dElEIjtzOjE6IjciO30='),
(21, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 42, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjIxO3M6OToiACoAX3RhYmxlIjtzOjE4OiJidERlc2t0b3BEcmFmdExpc3QiO3M6MTM6ImRyYWZ0c1BlclBhZ2UiO2k6MTA7fQ=='),
(22, '', '[[date_gmt]]', '[[date_gmt]]', 'byline.php', '0', 8, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjIyO3M6OToiACoAX3RhYmxlIjtzOjExOiJidFBhZ2VUaXRsZSI7czoxNDoidXNlQ3VzdG9tVGl0bGUiO2k6MDtzOjE0OiJ1c2VGaWx0ZXJUaXRsZSI7aTowO3M6MTQ6InVzZUZpbHRlclRvcGljIjtpOjA7czoxMjoidXNlRmlsdGVyVGFnIjtpOjA7czoxMzoidXNlRmlsdGVyRGF0ZSI7aTowO3M6OToidGl0bGVUZXh0IjtzOjEyOiJbUGFnZSBUaXRsZV0iO30='),
(23, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 45, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjIzO3M6OToiACoAX3RhYmxlIjtzOjM1OiJidENvcmVQYWdlVHlwZUNvbXBvc2VyQ29udHJvbE91dHB1dCI7czoyNToicHRDb21wb3Nlck91dHB1dENvbnRyb2xJRCI7czoxOiIxIjt9'),
(24, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 11, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjc6e3M6MzoiYklEIjtpOjI0O3M6OToiACoAX3RhYmxlIjtzOjE0OiJidE5leHRQcmV2aW91cyI7czo5OiJuZXh0TGFiZWwiO3M6OToiTmV4dCBQb3N0IjtzOjEzOiJwcmV2aW91c0xhYmVsIjtzOjk6Ikxhc3QgUG9zdCI7czoxMToicGFyZW50TGFiZWwiO3M6MDoiIjtzOjEyOiJsb29wU2VxdWVuY2UiO2k6MDtzOjc6Im9yZGVyQnkiO3M6MTE6ImNocm9ub19kZXNjIjt9'),
(25, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 26, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjI6e3M6MzoiYklEIjtpOjI1O3M6OToiACoAX3RhYmxlIjtzOjE1OiJidFNoYXJlVGhpc1BhZ2UiO30='),
(26, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 14, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjc6e3M6MzoiYklEIjtpOjI2O3M6OToiACoAX3RhYmxlIjtzOjExOiJidFRvcGljTGlzdCI7czo0OiJtb2RlIjtzOjE6IlAiO3M6MjM6InRvcGljQXR0cmlidXRlS2V5SGFuZGxlIjtzOjE3OiJibG9nX2VudHJ5X3RvcGljcyI7czoxMToidG9waWNUcmVlSUQiO3M6MToiNCI7czo5OiJjUGFyZW50SUQiO2k6MTk5O3M6NToidGl0bGUiO3M6NjoiVG9waWNzIjt9'),
(27, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 10, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjI3OntzOjM6ImJJRCI7aToyNztzOjk6IgAqAF90YWJsZSI7czoxMDoiYnRQYWdlTGlzdCI7czozOiJudW0iO3M6MToiMyI7czo3OiJvcmRlckJ5IjtzOjY6InJhbmRvbSI7czo5OiJjUGFyZW50SUQiO2k6MTk5O3M6NToiY1RoaXMiO3M6MToiMCI7czoxMToiY1RoaXNQYXJlbnQiO3M6MToiMCI7czoxMzoicGFnZUxpc3RUaXRsZSI7czoxMzoiUmVsYXRlZCBQb3N0cyI7czoxNToiZmlsdGVyQnlSZWxhdGVkIjtzOjE6IjAiO3M6MTk6ImZpbHRlckJ5Q3VzdG9tVG9waWMiO3M6MToiMCI7czoxNjoiZmlsdGVyRGF0ZU9wdGlvbiI7czowOiIiO3M6MzA6InJlbGF0ZWRUb3BpY0F0dHJpYnV0ZUtleUhhbmRsZSI7czowOiIiO3M6Mjk6ImN1c3RvbVRvcGljQXR0cmlidXRlS2V5SGFuZGxlIjtzOjA6IiI7czoyMToiY3VzdG9tVG9waWNUcmVlTm9kZUlEIjtpOjA7czoxMToiaW5jbHVkZU5hbWUiO3M6MToiMSI7czoxODoiaW5jbHVkZURlc2NyaXB0aW9uIjtzOjE6IjAiO3M6MTE6ImluY2x1ZGVEYXRlIjtzOjE6IjAiO3M6MjE6ImluY2x1ZGVBbGxEZXNjZW5kZW50cyI7czoxOiIwIjtzOjg6InBhZ2luYXRlIjtpOjA7czoxNDoiZGlzcGxheUFsaWFzZXMiO3M6MToiMCI7czoyMzoiZW5hYmxlRXh0ZXJuYWxGaWx0ZXJpbmciO3M6MToiMCI7czo0OiJwdElEIjtpOjY7czo0OiJwZklEIjtpOjA7czoxNzoidHJ1bmNhdGVTdW1tYXJpZXMiO3M6MToiMCI7czoxOToiZGlzcGxheUZlYXR1cmVkT25seSI7czoxOiIwIjtzOjE2OiJkaXNwbGF5VGh1bWJuYWlsIjtzOjE6IjAiO3M6MTM6InRydW5jYXRlQ2hhcnMiO2k6MDt9'),
(28, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 5, 1, NULL),
(29, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 23, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjE2OntzOjM6ImJJRCI7aToyOTtzOjk6IgAqAF90YWJsZSI7czoxODoiYnRDb3JlQ29udmVyc2F0aW9uIjtzOjU6ImNudklEIjtzOjE6IjEiO3M6MTM6ImVuYWJsZVBvc3RpbmciO3M6MToiMSI7czo4OiJwYWdpbmF0ZSI7czoxOiIxIjtzOjEyOiJpdGVtc1BlclBhZ2UiO3M6MjoiNTAiO3M6MTE6ImRpc3BsYXlNb2RlIjtzOjg6InRocmVhZGVkIjtzOjc6Im9yZGVyQnkiO3M6ODoiZGF0ZV9hc2MiO3M6MTQ6ImVuYWJsZU9yZGVyaW5nIjtpOjA7czoxOToiZW5hYmxlQ29tbWVudFJhdGluZyI7czoxOiIxIjtzOjIzOiJlbmFibGVUb3BDb21tZW50UmV2aWV3cyI7aTowO3M6MTg6ImRpc3BsYXlTb2NpYWxMaW5rcyI7aTowO3M6MTg6ImRpc3BsYXlQb3N0aW5nRm9ybSI7czozOiJ0b3AiO3M6MTU6ImFkZE1lc3NhZ2VMYWJlbCI7czoxMToiQWRkIE1lc3NhZ2UiO3M6MTA6ImRhdGVGb3JtYXQiO3M6NzoiZGVmYXVsdCI7czoxNjoiY3VzdG9tRGF0ZUZvcm1hdCI7czowOiIiO30='),
(30, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 8, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjMwO3M6OToiACoAX3RhYmxlIjtzOjExOiJidFBhZ2VUaXRsZSI7czoxNDoidXNlQ3VzdG9tVGl0bGUiO2k6MDtzOjE0OiJ1c2VGaWx0ZXJUaXRsZSI7aTowO3M6MTQ6InVzZUZpbHRlclRvcGljIjtpOjA7czoxMjoidXNlRmlsdGVyVGFnIjtpOjA7czoxMzoidXNlRmlsdGVyRGF0ZSI7aTowO3M6OToidGl0bGVUZXh0IjtzOjEyOiJbUGFnZSBUaXRsZV0iO30='),
(31, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 10, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjI2OntzOjM6ImJJRCI7aTozMTtzOjk6IgAqAF90YWJsZSI7czoxMDoiYnRQYWdlTGlzdCI7czozOiJudW0iO2k6MDtzOjc6Im9yZGVyQnkiO3M6MTE6ImNocm9ub19kZXNjIjtzOjk6ImNQYXJlbnRJRCI7aToyMTY7czo1OiJjVGhpcyI7czoxOiIwIjtzOjExOiJjVGhpc1BhcmVudCI7czoxOiIwIjtzOjEzOiJwYWdlTGlzdFRpdGxlIjtzOjE0OiJPcGVuIFBvc2l0aW9ucyI7czoxNToiZmlsdGVyQnlSZWxhdGVkIjtzOjE6IjAiO3M6MTk6ImZpbHRlckJ5Q3VzdG9tVG9waWMiO3M6MToiMCI7czoxNjoiZmlsdGVyRGF0ZU9wdGlvbiI7czowOiIiO3M6MzA6InJlbGF0ZWRUb3BpY0F0dHJpYnV0ZUtleUhhbmRsZSI7czowOiIiO3M6Mjk6ImN1c3RvbVRvcGljQXR0cmlidXRlS2V5SGFuZGxlIjtzOjA6IiI7czoyMToiY3VzdG9tVG9waWNUcmVlTm9kZUlEIjtpOjA7czoxODoiaW5jbHVkZURlc2NyaXB0aW9uIjtzOjE6IjAiO3M6MTE6ImluY2x1ZGVEYXRlIjtzOjE6IjAiO3M6MjE6ImluY2x1ZGVBbGxEZXNjZW5kZW50cyI7czoxOiIwIjtzOjg6InBhZ2luYXRlIjtpOjA7czoxNDoiZGlzcGxheUFsaWFzZXMiO3M6MToiMCI7czoyMzoiZW5hYmxlRXh0ZXJuYWxGaWx0ZXJpbmciO3M6MToiMCI7czo0OiJwdElEIjtpOjA7czo0OiJwZklEIjtpOjA7czoxNzoidHJ1bmNhdGVTdW1tYXJpZXMiO3M6MToiMCI7czoxOToiZGlzcGxheUZlYXR1cmVkT25seSI7czoxOiIwIjtzOjE2OiJkaXNwbGF5VGh1bWJuYWlsIjtzOjE6IjAiO3M6MTM6InRydW5jYXRlQ2hhcnMiO2k6MDt9'),
(32, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjMyO3M6OToiACoAX3RhYmxlIjtzOjE0OiJidENvbnRlbnRMb2NhbCI7czo3OiJjb250ZW50IjtzOjE4MjoiCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8cD48YSBocmVmPSJ7Q0NNOkNJRF8yMTZ9IiBzdHlsZT0iYmFja2dyb3VuZC1jb2xvcjogcmdiKDI1NSwgMjU1LCAyNTUpOyI+PGkgY2xhc3M9ImZhIGZhLWFycm93LWxlZnQiPjwvaT4gQmFjayB0byBDYXJlZXJzPC9hPjwvcD4iO30='),
(33, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjMzO3M6OToiACoAX3RhYmxlIjtzOjE0OiJidENvbnRlbnRMb2NhbCI7czo3OiJjb250ZW50IjtzOjE5OiI8aDM+RGVwYXJ0bWVudDwvaDM+Ijt9'),
(34, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 30, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjM0O3M6OToiACoAX3RhYmxlIjtzOjIyOiJidFBhZ2VBdHRyaWJ1dGVEaXNwbGF5IjtzOjE1OiJhdHRyaWJ1dGVIYW5kbGUiO3M6MjI6ImpvYl9wb3N0aW5nX2RlcGFydG1lbnQiO3M6MTg6ImF0dHJpYnV0ZVRpdGxlVGV4dCI7czowOiIiO3M6MTA6ImRpc3BsYXlUYWciO3M6MToicCI7czoxMDoiZGF0ZUZvcm1hdCI7czoxMToibS9kL3kgaDppOmEiO3M6MTU6InRodW1ibmFpbEhlaWdodCI7czozOiIyNTAiO3M6MTQ6InRodW1ibmFpbFdpZHRoIjtzOjM6IjI1MCI7fQ=='),
(35, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjM1O3M6OToiACoAX3RhYmxlIjtzOjE0OiJidENvbnRlbnRMb2NhbCI7czo3OiJjb250ZW50IjtzOjE3OiI8aDM+TG9jYXRpb248L2gzPiI7fQ=='),
(36, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 30, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjM2O3M6OToiACoAX3RhYmxlIjtzOjIyOiJidFBhZ2VBdHRyaWJ1dGVEaXNwbGF5IjtzOjE1OiJhdHRyaWJ1dGVIYW5kbGUiO3M6MTI6ImpvYl9sb2NhdGlvbiI7czoxODoiYXR0cmlidXRlVGl0bGVUZXh0IjtzOjA6IiI7czoxMDoiZGlzcGxheVRhZyI7czoxOiJwIjtzOjEwOiJkYXRlRm9ybWF0IjtzOjExOiJtL2QveSBoOmk6YSI7czoxNToidGh1bWJuYWlsSGVpZ2h0IjtzOjM6IjI1MCI7czoxNDoidGh1bWJuYWlsV2lkdGgiO3M6MzoiMjUwIjt9'),
(37, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjM3O3M6OToiACoAX3RhYmxlIjtzOjE0OiJidENvbnRlbnRMb2NhbCI7czo3OiJjb250ZW50IjtzOjI0OiI8aDM+Sm9iIEluZm9ybWF0aW9uPC9oMz4iO30='),
(38, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 45, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjM4O3M6OToiACoAX3RhYmxlIjtzOjM1OiJidENvcmVQYWdlVHlwZUNvbXBvc2VyQ29udHJvbE91dHB1dCI7czoyNToicHRDb21wb3Nlck91dHB1dENvbnRyb2xJRCI7czoxOiIyIjt9'),
(39, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjM5O3M6OToiACoAX3RhYmxlIjtzOjE0OiJidENvbnRlbnRMb2NhbCI7czo3OiJjb250ZW50IjtzOjYzOiIKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxici8+PGJyLz4iO30='),
(40, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 8, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjQwO3M6OToiACoAX3RhYmxlIjtzOjExOiJidFBhZ2VUaXRsZSI7czoxNDoidXNlQ3VzdG9tVGl0bGUiO2k6MDtzOjE0OiJ1c2VGaWx0ZXJUaXRsZSI7aTowO3M6MTQ6InVzZUZpbHRlclRvcGljIjtpOjA7czoxMjoidXNlRmlsdGVyVGFnIjtpOjA7czoxMzoidXNlRmlsdGVyRGF0ZSI7aTowO3M6OToidGl0bGVUZXh0IjtzOjEyOiJbUGFnZSBUaXRsZV0iO30='),
(41, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 45, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjQxO3M6OToiACoAX3RhYmxlIjtzOjM1OiJidENvcmVQYWdlVHlwZUNvbXBvc2VyQ29udHJvbE91dHB1dCI7czoyNToicHRDb21wb3Nlck91dHB1dENvbnRyb2xJRCI7czoxOiIzIjt9'),
(42, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 30, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjQyO3M6OToiACoAX3RhYmxlIjtzOjIyOiJidFBhZ2VBdHRyaWJ1dGVEaXNwbGF5IjtzOjE1OiJhdHRyaWJ1dGVIYW5kbGUiO3M6MTQ6InByb2plY3RfY2xpZW50IjtzOjE4OiJhdHRyaWJ1dGVUaXRsZVRleHQiO3M6NzoiQ2xpZW50OiI7czoxMDoiZGlzcGxheVRhZyI7czozOiJkaXYiO3M6MTA6ImRhdGVGb3JtYXQiO3M6MTE6Im0vZC95IGg6aTphIjtzOjE1OiJ0aHVtYm5haWxIZWlnaHQiO3M6MzoiMjUwIjtzOjE0OiJ0aHVtYm5haWxXaWR0aCI7czozOiIyNTAiO30='),
(43, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 30, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjQzO3M6OToiACoAX3RhYmxlIjtzOjIyOiJidFBhZ2VBdHRyaWJ1dGVEaXNwbGF5IjtzOjE1OiJhdHRyaWJ1dGVIYW5kbGUiO3M6MTM6InByb2plY3RfdGFza3MiO3M6MTg6ImF0dHJpYnV0ZVRpdGxlVGV4dCI7czo1OiJUYXNrOiI7czoxMDoiZGlzcGxheVRhZyI7czozOiJkaXYiO3M6MTA6ImRhdGVGb3JtYXQiO3M6MTE6Im0vZC95IGg6aTphIjtzOjE1OiJ0aHVtYm5haWxIZWlnaHQiO3M6MzoiMjUwIjtzOjE0OiJ0aHVtYm5haWxXaWR0aCI7czozOiIyNTAiO30='),
(44, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 30, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjQ0O3M6OToiACoAX3RhYmxlIjtzOjIyOiJidFBhZ2VBdHRyaWJ1dGVEaXNwbGF5IjtzOjE1OiJhdHRyaWJ1dGVIYW5kbGUiO3M6MTQ6InByb2plY3Rfc2tpbGxzIjtzOjE4OiJhdHRyaWJ1dGVUaXRsZVRleHQiO3M6NzoiU2tpbGxzOiI7czoxMDoiZGlzcGxheVRhZyI7czozOiJkaXYiO3M6MTA6ImRhdGVGb3JtYXQiO3M6MTE6Im0vZC95IGg6aTphIjtzOjE1OiJ0aHVtYm5haWxIZWlnaHQiO3M6MzoiMjUwIjtzOjE0OiJ0aHVtYm5haWxXaWR0aCI7czozOiIyNTAiO30='),
(45, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 45, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjQ1O3M6OToiACoAX3RhYmxlIjtzOjM1OiJidENvcmVQYWdlVHlwZUNvbXBvc2VyQ29udHJvbE91dHB1dCI7czoyNToicHRDb21wb3Nlck91dHB1dENvbnRyb2xJRCI7czoxOiI0Ijt9'),
(46, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 5, 1, NULL),
(47, '', '[[date_gmt]]', '[[date_gmt]]', 'thumbnail_grid', '0', 10, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjI4OntzOjM6ImJJRCI7aTo0NztzOjk6IgAqAF90YWJsZSI7czoxMDoiYnRQYWdlTGlzdCI7czozOiJudW0iO3M6MToiMyI7czo3OiJvcmRlckJ5IjtzOjY6InJhbmRvbSI7czo5OiJjUGFyZW50SUQiO2k6MDtzOjU6ImNUaGlzIjtzOjE6IjAiO3M6MTE6ImNUaGlzUGFyZW50IjtzOjE6IjAiO3M6MTM6InBhZ2VMaXN0VGl0bGUiO3M6MTY6IlJlbGF0ZWQgUHJvamVjdHMiO3M6MTU6ImZpbHRlckJ5UmVsYXRlZCI7czoxOiIwIjtzOjE5OiJmaWx0ZXJCeUN1c3RvbVRvcGljIjtzOjE6IjAiO3M6MTY6ImZpbHRlckRhdGVPcHRpb24iO3M6MDoiIjtzOjMwOiJyZWxhdGVkVG9waWNBdHRyaWJ1dGVLZXlIYW5kbGUiO3M6MDoiIjtzOjI5OiJjdXN0b21Ub3BpY0F0dHJpYnV0ZUtleUhhbmRsZSI7czowOiIiO3M6MjE6ImN1c3RvbVRvcGljVHJlZU5vZGVJRCI7aTowO3M6MTE6ImluY2x1ZGVOYW1lIjtzOjE6IjEiO3M6MTg6ImluY2x1ZGVEZXNjcmlwdGlvbiI7czoxOiIwIjtzOjExOiJpbmNsdWRlRGF0ZSI7czoxOiIwIjtzOjIxOiJpbmNsdWRlQWxsRGVzY2VuZGVudHMiO3M6MToiMCI7czo4OiJwYWdpbmF0ZSI7aTowO3M6MTQ6ImRpc3BsYXlBbGlhc2VzIjtzOjE6IjAiO3M6MjM6ImVuYWJsZUV4dGVybmFsRmlsdGVyaW5nIjtzOjE6IjAiO3M6NDoicHRJRCI7aTo4O3M6NDoicGZJRCI7aTowO3M6MTc6InRydW5jYXRlU3VtbWFyaWVzIjtzOjE6IjAiO3M6MTk6ImRpc3BsYXlGZWF0dXJlZE9ubHkiO3M6MToiMCI7czoxNjoibm9SZXN1bHRzTWVzc2FnZSI7czo3OToiCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBObyByZWxhdGVkIHByb2plY3RzIGZvdW5kLiI7czoxNjoiZGlzcGxheVRodW1ibmFpbCI7czoxOiIwIjtzOjEzOiJ0cnVuY2F0ZUNoYXJzIjtpOjA7fQ=='),
(48, '', '[[date_gmt]]', '[[date_gmt]]', 'archive.php', '0', 8, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjQ4O3M6OToiACoAX3RhYmxlIjtzOjExOiJidFBhZ2VUaXRsZSI7czoxNDoidXNlQ3VzdG9tVGl0bGUiO2k6MDtzOjE0OiJ1c2VGaWx0ZXJUaXRsZSI7aTowO3M6MTQ6InVzZUZpbHRlclRvcGljIjtpOjA7czoxMjoidXNlRmlsdGVyVGFnIjtpOjA7czoxMzoidXNlRmlsdGVyRGF0ZSI7aTowO3M6OToidGl0bGVUZXh0IjtzOjEyOiJbUGFnZSBUaXRsZV0iO30='),
(49, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjQ5O3M6OToiACoAX3RhYmxlIjtzOjE2OiJidENvcmVBcmVhTGF5b3V0IjtzOjEwOiJhckxheW91dElEIjtzOjE6IjgiO30='),
(50, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 10, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjI5OntzOjM6ImJJRCI7aTo1MDtzOjk6IgAqAF90YWJsZSI7czoxMDoiYnRQYWdlTGlzdCI7czozOiJudW0iO3M6MjoiMTAiO3M6Nzoib3JkZXJCeSI7czoxMToiY2hyb25vX2Rlc2MiO3M6OToiY1BhcmVudElEIjtpOjA7czo1OiJjVGhpcyI7czoxOiIwIjtzOjExOiJjVGhpc1BhcmVudCI7czoxOiIxIjtzOjE2OiJ1c2VCdXR0b25Gb3JMaW5rIjtzOjE6IjAiO3M6MTQ6ImJ1dHRvbkxpbmtUZXh0IjtzOjA6IiI7czoxNToiZmlsdGVyQnlSZWxhdGVkIjtzOjE6IjAiO3M6MTk6ImZpbHRlckJ5Q3VzdG9tVG9waWMiO3M6MToiMCI7czoxNjoiZmlsdGVyRGF0ZU9wdGlvbiI7czowOiIiO3M6MzA6InJlbGF0ZWRUb3BpY0F0dHJpYnV0ZUtleUhhbmRsZSI7czowOiIiO3M6Mjk6ImN1c3RvbVRvcGljQXR0cmlidXRlS2V5SGFuZGxlIjtzOjA6IiI7czoyMToiY3VzdG9tVG9waWNUcmVlTm9kZUlEIjtpOjA7czoxMToiaW5jbHVkZU5hbWUiO3M6MToiMSI7czoxODoiaW5jbHVkZURlc2NyaXB0aW9uIjtzOjE6IjEiO3M6MTE6ImluY2x1ZGVEYXRlIjtzOjE6IjEiO3M6MjE6ImluY2x1ZGVBbGxEZXNjZW5kZW50cyI7czoxOiIwIjtzOjg6InBhZ2luYXRlIjtpOjE7czoxNDoiZGlzcGxheUFsaWFzZXMiO3M6MToiMCI7czoyMzoiZW5hYmxlRXh0ZXJuYWxGaWx0ZXJpbmciO3M6MToiMSI7czo0OiJwdElEIjtpOjY7czo0OiJwZklEIjtpOjE7czoxNzoidHJ1bmNhdGVTdW1tYXJpZXMiO3M6MToiMCI7czoxOToiZGlzcGxheUZlYXR1cmVkT25seSI7czoxOiIwIjtzOjE2OiJub1Jlc3VsdHNNZXNzYWdlIjtzOjIyOiJObyBwb3N0cyB0byB0aGlzIGJsb2cuIjtzOjE2OiJkaXNwbGF5VGh1bWJuYWlsIjtzOjE6IjAiO3M6MTM6InRydW5jYXRlQ2hhcnMiO2k6MDt9'),
(51, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 14, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjc6e3M6MzoiYklEIjtpOjUxO3M6OToiACoAX3RhYmxlIjtzOjExOiJidFRvcGljTGlzdCI7czo0OiJtb2RlIjtzOjE6IlMiO3M6MjM6InRvcGljQXR0cmlidXRlS2V5SGFuZGxlIjtzOjA6IiI7czoxMToidG9waWNUcmVlSUQiO3M6MToiNCI7czo5OiJjUGFyZW50SUQiO2k6MDtzOjU6InRpdGxlIjtzOjY6IlRvcGljcyI7fQ=='),
(52, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 12, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjUyO3M6OToiACoAX3RhYmxlIjtzOjE2OiJidERhdGVOYXZpZ2F0aW9uIjtzOjU6InRpdGxlIjtzOjg6IkFyY2hpdmVzIjtzOjE0OiJmaWx0ZXJCeVBhcmVudCI7czoxOiIxIjtzOjE3OiJyZWRpcmVjdFRvUmVzdWx0cyI7czoxOiIwIjtzOjk6ImNQYXJlbnRJRCI7aToxOTk7czo5OiJjVGFyZ2V0SUQiO2k6MDtzOjQ6InB0SUQiO2k6Njt9'),
(53, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 8, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjUzO3M6OToiACoAX3RhYmxlIjtzOjExOiJidFBhZ2VUaXRsZSI7czoxNDoidXNlQ3VzdG9tVGl0bGUiO2k6MDtzOjE0OiJ1c2VGaWx0ZXJUaXRsZSI7aTowO3M6MTQ6InVzZUZpbHRlclRvcGljIjtpOjA7czoxMjoidXNlRmlsdGVyVGFnIjtpOjA7czoxMzoidXNlRmlsdGVyRGF0ZSI7aTowO3M6OToidGl0bGVUZXh0IjtzOjEyOiJbUGFnZSBUaXRsZV0iO30='),
(54, '', '[[date_gmt]]', '[[date_gmt]]', 'flat_filter.php', '0', 14, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjc6e3M6MzoiYklEIjtpOjU0O3M6OToiACoAX3RhYmxlIjtzOjExOiJidFRvcGljTGlzdCI7czo0OiJtb2RlIjtzOjE6IlMiO3M6MjM6InRvcGljQXR0cmlidXRlS2V5SGFuZGxlIjtzOjA6IiI7czoxMToidG9waWNUcmVlSUQiO3M6MToiNSI7czo5OiJjUGFyZW50SUQiO2k6MDtzOjU6InRpdGxlIjtzOjA6IiI7fQ=='),
(55, '', '[[date_gmt]]', '[[date_gmt]]', 'thumbnail_grid', '0', 10, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjI5OntzOjM6ImJJRCI7aTo1NTtzOjk6IgAqAF90YWJsZSI7czoxMDoiYnRQYWdlTGlzdCI7czozOiJudW0iO2k6MDtzOjc6Im9yZGVyQnkiO3M6MTE6ImNocm9ub19kZXNjIjtzOjk6ImNQYXJlbnRJRCI7aTowO3M6NToiY1RoaXMiO3M6MToiMCI7czoxMToiY1RoaXNQYXJlbnQiO3M6MToiMCI7czoxNjoidXNlQnV0dG9uRm9yTGluayI7czoxOiIwIjtzOjE0OiJidXR0b25MaW5rVGV4dCI7czowOiIiO3M6MTU6ImZpbHRlckJ5UmVsYXRlZCI7czoxOiIwIjtzOjE5OiJmaWx0ZXJCeUN1c3RvbVRvcGljIjtzOjE6IjAiO3M6MTY6ImZpbHRlckRhdGVPcHRpb24iO3M6MDoiIjtzOjMwOiJyZWxhdGVkVG9waWNBdHRyaWJ1dGVLZXlIYW5kbGUiO3M6MDoiIjtzOjI5OiJjdXN0b21Ub3BpY0F0dHJpYnV0ZUtleUhhbmRsZSI7czowOiIiO3M6MjE6ImN1c3RvbVRvcGljVHJlZU5vZGVJRCI7aTowO3M6MTE6ImluY2x1ZGVOYW1lIjtzOjE6IjEiO3M6MTg6ImluY2x1ZGVEZXNjcmlwdGlvbiI7czoxOiIwIjtzOjExOiJpbmNsdWRlRGF0ZSI7czoxOiIwIjtzOjIxOiJpbmNsdWRlQWxsRGVzY2VuZGVudHMiO3M6MToiMCI7czo4OiJwYWdpbmF0ZSI7aToxO3M6MTQ6ImRpc3BsYXlBbGlhc2VzIjtzOjE6IjAiO3M6MjM6ImVuYWJsZUV4dGVybmFsRmlsdGVyaW5nIjtzOjE6IjEiO3M6NDoicHRJRCI7aTo4O3M6NDoicGZJRCI7aTowO3M6MTc6InRydW5jYXRlU3VtbWFyaWVzIjtzOjE6IjAiO3M6MTk6ImRpc3BsYXlGZWF0dXJlZE9ubHkiO3M6MToiMCI7czoxNjoibm9SZXN1bHRzTWVzc2FnZSI7czoxODoiTm8gcHJvamVjdHMgZm91bmQuIjtzOjE2OiJkaXNwbGF5VGh1bWJuYWlsIjtzOjE6IjEiO3M6MTM6InRydW5jYXRlQ2hhcnMiO2k6MDt9'),
(56, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjU2O3M6OToiACoAX3RhYmxlIjtzOjE0OiJidENvbnRlbnRMb2NhbCI7czo3OiJjb250ZW50IjtzOjE1NzoiCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxwPjEyMzQgU0UgU3RyZWV0VmlldzwvcD48cD5TdWl0ZSAzMDE8L3A+PHA+UG9ydGxhbmQsIE9SIDk4MTAxPC9wPjxwPjxhIGhyZWY9IntDQ006Q0lEXzIwMX0iPlZpZXcgb24gR29vZ2xlIE1hcHM8L2E+PC9wPiI7fQ=='),
(57, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjU3O3M6OToiACoAX3RhYmxlIjtzOjE0OiJidENvbnRlbnRMb2NhbCI7czo3OiJjb250ZW50IjtzOjY4OiIKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHA+wqkgMjAxOMKgRWxlbWVudGFsIFRoZW1lPC9wPiI7fQ=='),
(58, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjU4O3M6OToiACoAX3RhYmxlIjtzOjE0OiJidENvbnRlbnRMb2NhbCI7czo3OiJjb250ZW50IjtzOjM5ODoiCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8cD48YSBocmVmPSJ7Q0NNOkNJRF8yMTd9Ij5GQVEgLyBIZWxwPC9hPjwvcD4KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHA+PGEgaHJlZj0ie0NDTTpDSURfMTk2fSI+Q2FzZSBTdHVkaWVzPC9hPjwvcD4KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHA+PGEgaHJlZj0ie0NDTTpDSURfMTk5fSI+QmxvZzwvYT48L3A+CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxwPjxhIGhyZWY9IntDQ006Q0lEXzF9Ij5Bbm90aGVyIExpbms8L2E+PC9wPgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAiO30='),
(59, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjU5O3M6OToiACoAX3RhYmxlIjtzOjE0OiJidENvbnRlbnRMb2NhbCI7czo3OiJjb250ZW50IjtzOjk1OiIKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPGEgaHJlZj0ie0NDTTpDSURfMX0iIGlkPSJmb290ZXItc2l0ZS10aXRsZSI+RWxlbWVudGFsPC9hPiI7fQ=='),
(60, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 24, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjI6e3M6MzoiYklEIjtpOjYwO3M6OToiACoAX3RhYmxlIjtzOjEzOiJidFNvY2lhbExpbmtzIjt9'),
(61, '', '[[date_gmt]]', '[[date_gmt]]', 'responsive_header_navigation', '0', 7, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjEwOntzOjM6ImJJRCI7aTo2MTtzOjk6IgAqAF90YWJsZSI7czoxMjoiYnROYXZpZ2F0aW9uIjtzOjc6Im9yZGVyQnkiO3M6MTE6ImRpc3BsYXlfYXNjIjtzOjEyOiJkaXNwbGF5UGFnZXMiO3M6MzoidG9wIjtzOjE1OiJkaXNwbGF5UGFnZXNDSUQiO2k6MDtzOjIzOiJkaXNwbGF5UGFnZXNJbmNsdWRlU2VsZiI7aTowO3M6MTU6ImRpc3BsYXlTdWJQYWdlcyI7czozOiJhbGwiO3M6MjA6ImRpc3BsYXlTdWJQYWdlTGV2ZWxzIjtzOjY6ImN1c3RvbSI7czoyMzoiZGlzcGxheVN1YlBhZ2VMZXZlbHNOdW0iO3M6MToiMSI7czoyMzoiZGlzcGxheVVuYXZhaWxhYmxlUGFnZXMiO2k6MDt9'),
(62, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 18, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjk6e3M6MzoiYklEIjtpOjYyO3M6OToiACoAX3RhYmxlIjtzOjg6ImJ0U2VhcmNoIjtzOjU6InRpdGxlIjtzOjA6IiI7czoxMDoiYnV0dG9uVGV4dCI7czowOiIiO3M6MTQ6ImJhc2VTZWFyY2hQYXRoIjtzOjA6IiI7czoxMDoic2VhcmNoX2FsbCI7aTowO3M6MTg6ImFsbG93X3VzZXJfb3B0aW9ucyI7aTowO3M6MTA6InBvc3RUb19jSUQiO2k6MjAwO3M6MTA6InJlc3VsdHNVUkwiO3M6MDoiIjt9'),
(63, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjYzO3M6OToiACoAX3RhYmxlIjtzOjE0OiJidENvbnRlbnRMb2NhbCI7czo3OiJjb250ZW50IjtzOjk1OiIKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPGEgaHJlZj0ie0NDTTpDSURfMX0iIGlkPSJoZWFkZXItc2l0ZS10aXRsZSI+RWxlbWVudGFsPC9hPiI7fQ=='),
(64, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 31, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjY0O3M6OToiACoAX3RhYmxlIjtzOjEzOiJidEltYWdlU2xpZGVyIjtzOjE0OiJuYXZpZ2F0aW9uVHlwZSI7czoxOiIxIjtzOjc6InRpbWVvdXQiO2k6NDAwMDtzOjU6InNwZWVkIjtpOjUwMDtzOjk6Im5vQW5pbWF0ZSI7aTowO3M6NToicGF1c2UiO2k6MDtzOjg6Im1heFdpZHRoIjtpOjA7fQ=='),
(65, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjY1O3M6OToiACoAX3RhYmxlIjtzOjE2OiJidENvcmVBcmVhTGF5b3V0IjtzOjEwOiJhckxheW91dElEIjtzOjE6IjkiO30='),
(66, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 6, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjc6e3M6MzoiYklEIjtpOjY2O3M6OToiACoAX3RhYmxlIjtzOjk6ImJ0RmVhdHVyZSI7czo0OiJpY29uIjtzOjY6InBlbmNpbCI7czo1OiJ0aXRsZSI7czoxMjoiRWFzeSB0byBFZGl0IjtzOjk6InBhcmFncmFwaCI7czoyMzQ6IgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgUGVsbGVudGVzcXVlIHVsdHJpY2llcyBsaWd1bGEgdmVsIG5lcXVlIGRpY3R1bSwgZXUgbW9sbGlzIHRvcnRvciBhZGlwaXNjaW5nLiBFdGlhbSBjb25ndWUsIGVzdCB2ZWwgdGluY2lkdW50IHZlc3RpYnVsdW0sIG51bmMgbnVuYyBwb3J0YSBudWxsYSwgYXQgYWRpcGlzY2luZyBuZXF1ZSB0ZWxsdXMgcXVpcyB1cm5hLiI7czoxMjoiZXh0ZXJuYWxMaW5rIjtzOjA6IiI7czoxNToiaW50ZXJuYWxMaW5rQ0lEIjtpOjA7fQ=='),
(67, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 6, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjc6e3M6MzoiYklEIjtpOjY3O3M6OToiACoAX3RhYmxlIjtzOjk6ImJ0RmVhdHVyZSI7czo0OiJpY29uIjtzOjM6ImV5ZSI7czo1OiJ0aXRsZSI7czoxMzoiUGl4ZWwgUGVyZmVjdCI7czo5OiJwYXJhZ3JhcGgiO3M6MjM0OiIKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFBlbGxlbnRlc3F1ZSB1bHRyaWNpZXMgbGlndWxhIHZlbCBuZXF1ZSBkaWN0dW0sIGV1IG1vbGxpcyB0b3J0b3IgYWRpcGlzY2luZy4gRXRpYW0gY29uZ3VlLCBlc3QgdmVsIHRpbmNpZHVudCB2ZXN0aWJ1bHVtLCBudW5jIG51bmMgcG9ydGEgbnVsbGEsIGF0IGFkaXBpc2NpbmcgbmVxdWUgdGVsbHVzIHF1aXMgdXJuYS4iO3M6MTI6ImV4dGVybmFsTGluayI7czowOiIiO3M6MTU6ImludGVybmFsTGlua0NJRCI7aTowO30='),
(68, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 6, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjc6e3M6MzoiYklEIjtpOjY4O3M6OToiACoAX3RhYmxlIjtzOjk6ImJ0RmVhdHVyZSI7czo0OiJpY29uIjtzOjEyOiJ5b3V0dWJlLXBsYXkiO3M6NToidGl0bGUiO3M6MTA6Ik1lZGlhIFJpY2giO3M6OToicGFyYWdyYXBoIjtzOjIzNDoiCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBQZWxsZW50ZXNxdWUgdWx0cmljaWVzIGxpZ3VsYSB2ZWwgbmVxdWUgZGljdHVtLCBldSBtb2xsaXMgdG9ydG9yIGFkaXBpc2NpbmcuIEV0aWFtIGNvbmd1ZSwgZXN0IHZlbCB0aW5jaWR1bnQgdmVzdGlidWx1bSwgbnVuYyBudW5jIHBvcnRhIG51bGxhLCBhdCBhZGlwaXNjaW5nIG5lcXVlIHRlbGx1cyBxdWlzIHVybmEuIjtzOjEyOiJleHRlcm5hbExpbmsiO3M6MDoiIjtzOjE1OiJpbnRlcm5hbExpbmtDSUQiO2k6MDt9'),
(69, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 5, 1, NULL),
(70, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjcwO3M6OToiACoAX3RhYmxlIjtzOjE0OiJidENvbnRlbnRMb2NhbCI7czo3OiJjb250ZW50IjtzOjQwNzoiCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxwIHN0eWxlPSJ0ZXh0LWFsaWduOiBjZW50ZXIiPjxzcGFuIGNsYXNzPSJ0aXRsZS1jYXBzLWJvbGQiPlByZXNlbnRpbmcgeW91ciBCdXNpbmVzcyBoYXMgbmV2ZXIgYmVlbiBzbyBlYXN5PC9zcGFuPjwvcD48cCBzdHlsZT0idGV4dC1hbGlnbjogY2VudGVyOyI+UGVsbGVudGVzcXVlIHVsdHJpY2llcyBsaWd1bGEgdmVsIG5lcXVlIGRpY3R1bSwgZXUgbW9sbGlzIHRvcnRvciBhZGlwaXNjaW5nLjwvcD48cCBzdHlsZT0idGV4dC1hbGlnbjogY2VudGVyOyI+RXRpYW0gY29uZ3VlLCBlc3QgdmVsIHRpbmNpZHVudCB2ZXN0aWJ1bHVtLCBudW5jIG51bmMgcG9ydGEgbnVsbGEsIGF0IGFkaXBpc2NpbmcgbmVxdWUgdGVsbHVzIHF1aXMgdXJuYS7CoDwvcD4iO30='),
(71, '', '[[date_gmt]]', '[[date_gmt]]', 'thumbnail_grid', '0', 10, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjI5OntzOjM6ImJJRCI7aTo3MTtzOjk6IgAqAF90YWJsZSI7czoxMDoiYnRQYWdlTGlzdCI7czozOiJudW0iO3M6MToiMyI7czo3OiJvcmRlckJ5IjtzOjExOiJjaHJvbm9fZGVzYyI7czo5OiJjUGFyZW50SUQiO2k6MDtzOjU6ImNUaGlzIjtzOjE6IjAiO3M6MTE6ImNUaGlzUGFyZW50IjtzOjE6IjAiO3M6MTY6InVzZUJ1dHRvbkZvckxpbmsiO3M6MToiMSI7czoxNDoiYnV0dG9uTGlua1RleHQiO3M6MTI6IlZpZXcgUHJvamVjdCI7czoxNToiZmlsdGVyQnlSZWxhdGVkIjtzOjE6IjAiO3M6MTk6ImZpbHRlckJ5Q3VzdG9tVG9waWMiO3M6MToiMCI7czoxNjoiZmlsdGVyRGF0ZU9wdGlvbiI7czowOiIiO3M6MzA6InJlbGF0ZWRUb3BpY0F0dHJpYnV0ZUtleUhhbmRsZSI7czowOiIiO3M6Mjk6ImN1c3RvbVRvcGljQXR0cmlidXRlS2V5SGFuZGxlIjtzOjA6IiI7czoyMToiY3VzdG9tVG9waWNUcmVlTm9kZUlEIjtpOjA7czoxMToiaW5jbHVkZU5hbWUiO3M6MToiMSI7czoxODoiaW5jbHVkZURlc2NyaXB0aW9uIjtzOjE6IjEiO3M6MTE6ImluY2x1ZGVEYXRlIjtzOjE6IjAiO3M6MjE6ImluY2x1ZGVBbGxEZXNjZW5kZW50cyI7czoxOiIwIjtzOjg6InBhZ2luYXRlIjtpOjA7czoxNDoiZGlzcGxheUFsaWFzZXMiO3M6MToiMCI7czoyMzoiZW5hYmxlRXh0ZXJuYWxGaWx0ZXJpbmciO3M6MToiMCI7czo0OiJwdElEIjtpOjg7czo0OiJwZklEIjtpOjA7czoxNzoidHJ1bmNhdGVTdW1tYXJpZXMiO3M6MToiMCI7czoxOToiZGlzcGxheUZlYXR1cmVkT25seSI7czoxOiIxIjtzOjE2OiJub1Jlc3VsdHNNZXNzYWdlIjtzOjA6IiI7czoxNjoiZGlzcGxheVRodW1ibmFpbCI7czoxOiIxIjtzOjEzOiJ0cnVuY2F0ZUNoYXJzIjtpOjA7fQ=='),
(72, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 5, 1, NULL),
(73, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjczO3M6OToiACoAX3RhYmxlIjtzOjE2OiJidENvcmVBcmVhTGF5b3V0IjtzOjEwOiJhckxheW91dElEIjtzOjI6IjEwIjt9'),
(74, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjc0O3M6OToiACoAX3RhYmxlIjtzOjE0OiJidENvbnRlbnRMb2NhbCI7czo3OiJjb250ZW50IjtzOjI1OiI8aDU+TGF0ZXN0IEJsb2cgUG9zdDwvaDU+Ijt9'),
(75, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjc1O3M6OToiACoAX3RhYmxlIjtzOjE0OiJidENvbnRlbnRMb2NhbCI7czo3OiJjb250ZW50IjtzOjMwOiI8aDU+Tm93IE9wZW4gRm9yIEJ1c2luZXNzPC9oNT4iO30='),
(76, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjc2O3M6OToiACoAX3RhYmxlIjtzOjE2OiJidENvcmVBcmVhTGF5b3V0IjtzOjEwOiJhckxheW91dElEIjtzOjI6IjExIjt9'),
(77, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 10, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjI5OntzOjM6ImJJRCI7aTo3NztzOjk6IgAqAF90YWJsZSI7czoxMDoiYnRQYWdlTGlzdCI7czozOiJudW0iO3M6MToiMSI7czo3OiJvcmRlckJ5IjtzOjExOiJjaHJvbm9fZGVzYyI7czo5OiJjUGFyZW50SUQiO2k6MDtzOjU6ImNUaGlzIjtzOjE6IjAiO3M6MTE6ImNUaGlzUGFyZW50IjtzOjE6IjAiO3M6MTY6InVzZUJ1dHRvbkZvckxpbmsiO3M6MToiMCI7czoxNDoiYnV0dG9uTGlua1RleHQiO3M6MDoiIjtzOjE1OiJmaWx0ZXJCeVJlbGF0ZWQiO3M6MToiMCI7czoxOToiZmlsdGVyQnlDdXN0b21Ub3BpYyI7czoxOiIwIjtzOjE2OiJmaWx0ZXJEYXRlT3B0aW9uIjtzOjA6IiI7czozMDoicmVsYXRlZFRvcGljQXR0cmlidXRlS2V5SGFuZGxlIjtzOjA6IiI7czoyOToiY3VzdG9tVG9waWNBdHRyaWJ1dGVLZXlIYW5kbGUiO3M6MDoiIjtzOjIxOiJjdXN0b21Ub3BpY1RyZWVOb2RlSUQiO2k6MDtzOjExOiJpbmNsdWRlTmFtZSI7czoxOiIwIjtzOjE4OiJpbmNsdWRlRGVzY3JpcHRpb24iO3M6MToiMCI7czoxMToiaW5jbHVkZURhdGUiO3M6MToiMCI7czoyMToiaW5jbHVkZUFsbERlc2NlbmRlbnRzIjtzOjE6IjAiO3M6ODoicGFnaW5hdGUiO2k6MDtzOjE0OiJkaXNwbGF5QWxpYXNlcyI7czoxOiIwIjtzOjIzOiJlbmFibGVFeHRlcm5hbEZpbHRlcmluZyI7czoxOiIwIjtzOjQ6InB0SUQiO2k6NjtzOjQ6InBmSUQiO2k6MDtzOjE3OiJ0cnVuY2F0ZVN1bW1hcmllcyI7czoxOiIwIjtzOjE5OiJkaXNwbGF5RmVhdHVyZWRPbmx5IjtzOjE6IjAiO3M6MTY6Im5vUmVzdWx0c01lc3NhZ2UiO3M6MDoiIjtzOjE2OiJkaXNwbGF5VGh1bWJuYWlsIjtzOjE6IjEiO3M6MTM6InRydW5jYXRlQ2hhcnMiO2k6MDt9'),
(78, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 10, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjI5OntzOjM6ImJJRCI7aTo3ODtzOjk6IgAqAF90YWJsZSI7czoxMDoiYnRQYWdlTGlzdCI7czozOiJudW0iO3M6MToiMSI7czo3OiJvcmRlckJ5IjtzOjExOiJjaHJvbm9fZGVzYyI7czo5OiJjUGFyZW50SUQiO2k6MDtzOjU6ImNUaGlzIjtzOjE6IjAiO3M6MTE6ImNUaGlzUGFyZW50IjtzOjE6IjAiO3M6MTY6InVzZUJ1dHRvbkZvckxpbmsiO3M6MToiMCI7czoxNDoiYnV0dG9uTGlua1RleHQiO3M6MDoiIjtzOjE1OiJmaWx0ZXJCeVJlbGF0ZWQiO3M6MToiMCI7czoxOToiZmlsdGVyQnlDdXN0b21Ub3BpYyI7czoxOiIwIjtzOjE2OiJmaWx0ZXJEYXRlT3B0aW9uIjtzOjA6IiI7czozMDoicmVsYXRlZFRvcGljQXR0cmlidXRlS2V5SGFuZGxlIjtzOjA6IiI7czoyOToiY3VzdG9tVG9waWNBdHRyaWJ1dGVLZXlIYW5kbGUiO3M6MDoiIjtzOjIxOiJjdXN0b21Ub3BpY1RyZWVOb2RlSUQiO2k6MDtzOjExOiJpbmNsdWRlTmFtZSI7czoxOiIxIjtzOjE4OiJpbmNsdWRlRGVzY3JpcHRpb24iO3M6MToiMSI7czoxMToiaW5jbHVkZURhdGUiO3M6MToiMCI7czoyMToiaW5jbHVkZUFsbERlc2NlbmRlbnRzIjtzOjE6IjAiO3M6ODoicGFnaW5hdGUiO2k6MDtzOjE0OiJkaXNwbGF5QWxpYXNlcyI7czoxOiIwIjtzOjIzOiJlbmFibGVFeHRlcm5hbEZpbHRlcmluZyI7czoxOiIwIjtzOjQ6InB0SUQiO2k6NjtzOjQ6InBmSUQiO2k6MDtzOjE3OiJ0cnVuY2F0ZVN1bW1hcmllcyI7czoxOiIwIjtzOjE5OiJkaXNwbGF5RmVhdHVyZWRPbmx5IjtzOjE6IjAiO3M6MTY6Im5vUmVzdWx0c01lc3NhZ2UiO3M6MDoiIjtzOjE2OiJkaXNwbGF5VGh1bWJuYWlsIjtzOjE6IjAiO3M6MTM6InRydW5jYXRlQ2hhcnMiO2k6MDt9'),
(79, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjc5O3M6OToiACoAX3RhYmxlIjtzOjE0OiJidENvbnRlbnRMb2NhbCI7czo3OiJjb250ZW50IjtzOjY2OToiCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8cD4gIDxzcGFuIGNsYXNzPSJ0aXRsZS10aGluIj5XZSBzcGVjaWFsaXplIGluIG1ha2luZyB5b3VyIGNvbmNlcHRzIGEgcmVhbGl0eS48L3NwYW4+ICA8L3A+ICA8cD4gICAgU2VkIGN1cnN1cyBmYWNpbGlzaXMgZGlnbmlzc2ltLiBBbGlxdWFtIHJob25jdXMgZW5pbSBldCBwZWxsZW50ZXNxdWUgdmFyaXVzLiBOdWxsYSBzb2RhbGVzIG5pYmggbG9yZW0sIHNpdCBhbWV0IGltcGVyZGlldCBhcmN1IGNvbW1vZG8gc2l0IGFtZXQuIE1hdXJpcyBzZWQgc2NlbGVyaXNxdWUgbmlzbC4gVXQgYXVjdG9yIGlwc3VtIHRlbGx1cywgdmVsIHZpdmVycmEgbWFzc2EgZWxlbWVudHVtIHNpdCBhbWV0LiAgPC9wPiAgPHA+ICAgIFNlZCBhZGlwaXNjaW5nIHRlbXB1cyBzZW0gZXUgbW9sZXN0aWUuIEFlbmVhbiBsYW9yZWV0IHByZXRpdW0gYW50ZSB2aXRhZSB1bHRyaWNlcy4gQWVuZWFuIGV1IGdyYXZpZGEgbWFnbmEsIHZlbCBhbGlxdWV0IG1hZ25hLiBJbiBhdWN0b3IgY29udmFsbGlzIGdyYXZpZGEuPGJyPiAgPC9wPiAgPGJyLz4gIDxwPiAgPGEgaHJlZj0ie0NDTTpDSURfMjAxfSI+PHNwYW4gY2xhc3M9ImJ0biBidG4tc3VjY2VzcyI+Q29udGFjdCBVcyBUb2RheTwvc3Bhbj48L2E+ICA8L3A+Ijt9'),
(80, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjgwO3M6OToiACoAX3RhYmxlIjtzOjE0OiJidENvbnRlbnRMb2NhbCI7czo3OiJjb250ZW50IjtzOjE0NjoiCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxwIHN0eWxlPSJ0ZXh0LWFsaWduOiBjZW50ZXIiPjxzcGFuIGNsYXNzPSJ0aXRsZS1jYXBzIj5DdXN0b21pemFibGUgZm9vdGVyIGFyZWEgd2l0aCBhY2NlbnQgY2xhc3MuPC9zcGFuPjwvcD4iO30='),
(81, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 8, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjgxO3M6OToiACoAX3RhYmxlIjtzOjExOiJidFBhZ2VUaXRsZSI7czoxNDoidXNlQ3VzdG9tVGl0bGUiO2k6MTtzOjE0OiJ1c2VGaWx0ZXJUaXRsZSI7aTowO3M6MTQ6InVzZUZpbHRlclRvcGljIjtpOjA7czoxMjoidXNlRmlsdGVyVGFnIjtpOjA7czoxMzoidXNlRmlsdGVyRGF0ZSI7aTowO3M6OToidGl0bGVUZXh0IjtzOjEzOiJPdXIgRXhwZXJ0aXNlIjt9'),
(82, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjgyO3M6OToiACoAX3RhYmxlIjtzOjE2OiJidENvcmVBcmVhTGF5b3V0IjtzOjEwOiJhckxheW91dElEIjtzOjI6IjEyIjt9'),
(83, '', '[[date_gmt]]', '[[date_gmt]]', 'hover_description', '0', 6, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjc6e3M6MzoiYklEIjtpOjgzO3M6OToiACoAX3RhYmxlIjtzOjk6ImJ0RmVhdHVyZSI7czo0OiJpY29uIjtzOjQ6InN0YXIiO3M6NToidGl0bGUiO3M6NzoiUXVhbGl0eSI7czo5OiJwYXJhZ3JhcGgiO3M6MTQzOiIKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIExvcmVtIGlwc3VtIGRvbG9yIHNpdCBhbWV0LCBjb25zZWN0ZXR1ciBhZGlwaXNjaW5nIGVsaXQuIE51bGxhIHNvZGFsZXMgbm9uIGxlbyBpZCBhbGlxdWV0LiI7czoxMjoiZXh0ZXJuYWxMaW5rIjtzOjA6IiI7czoxNToiaW50ZXJuYWxMaW5rQ0lEIjtpOjA7fQ=='),
(84, '', '[[date_gmt]]', '[[date_gmt]]', 'hover_description', '0', 6, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjc6e3M6MzoiYklEIjtpOjg0O3M6OToiACoAX3RhYmxlIjtzOjk6ImJ0RmVhdHVyZSI7czo0OiJpY29uIjtzOjQ6InRpbnQiO3M6NToidGl0bGUiO3M6NjoiRGVzaWduIjtzOjk6InBhcmFncmFwaCI7czoxNDM6IgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgTG9yZW0gaXBzdW0gZG9sb3Igc2l0IGFtZXQsIGNvbnNlY3RldHVyIGFkaXBpc2NpbmcgZWxpdC4gTnVsbGEgc29kYWxlcyBub24gbGVvIGlkIGFsaXF1ZXQuIjtzOjEyOiJleHRlcm5hbExpbmsiO3M6MDoiIjtzOjE1OiJpbnRlcm5hbExpbmtDSUQiO2k6MDt9'),
(85, '', '[[date_gmt]]', '[[date_gmt]]', 'hover_description', '0', 6, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjc6e3M6MzoiYklEIjtpOjg1O3M6OToiACoAX3RhYmxlIjtzOjk6ImJ0RmVhdHVyZSI7czo0OiJpY29uIjtzOjM6ImNvZyI7czo1OiJ0aXRsZSI7czoxMToiRGV2ZWxvcG1lbnQiO3M6OToicGFyYWdyYXBoIjtzOjE0MzoiCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBMb3JlbSBpcHN1bSBkb2xvciBzaXQgYW1ldCwgY29uc2VjdGV0dXIgYWRpcGlzY2luZyBlbGl0LiBOdWxsYSBzb2RhbGVzIG5vbiBsZW8gaWQgYWxpcXVldC4iO3M6MTI6ImV4dGVybmFsTGluayI7czowOiIiO3M6MTU6ImludGVybmFsTGlua0NJRCI7aTowO30='),
(86, '', '[[date_gmt]]', '[[date_gmt]]', 'hover_description', '0', 6, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjc6e3M6MzoiYklEIjtpOjg2O3M6OToiACoAX3RhYmxlIjtzOjk6ImJ0RmVhdHVyZSI7czo0OiJpY29uIjtzOjQ6ImxvY2siO3M6NToidGl0bGUiO3M6ODoiU2VjdXJpdHkiO3M6OToicGFyYWdyYXBoIjtzOjE0MzoiCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBMb3JlbSBpcHN1bSBkb2xvciBzaXQgYW1ldCwgY29uc2VjdGV0dXIgYWRpcGlzY2luZyBlbGl0LiBOdWxsYSBzb2RhbGVzIG5vbiBsZW8gaWQgYWxpcXVldC4iO3M6MTI6ImV4dGVybmFsTGluayI7czowOiIiO3M6MTU6ImludGVybmFsTGlua0NJRCI7aTowO30='),
(87, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 5, 1, NULL),
(88, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjg4O3M6OToiACoAX3RhYmxlIjtzOjE2OiJidENvcmVBcmVhTGF5b3V0IjtzOjEwOiJhckxheW91dElEIjtzOjI6IjEzIjt9'),
(89, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjg5O3M6OToiACoAX3RhYmxlIjtzOjE0OiJidENvbnRlbnRMb2NhbCI7czo3OiJjb250ZW50IjtzOjEwMzI6IgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPGgzPkF3ZXNvbWUgRmVhdHVyZXM8L2gzPjxwPkN1cmFiaXR1ciBzYWdpdHRpcyBlbGVtZW50dW0gZmVsaXMgYXQgc29kYWxlcy4gTnVsbGFtIGZlcm1lbnR1bSBhdCB1cm5hIHF1aXMgYWNjdW1zYW4uIE5hbSBiaWJlbmR1bSBsZW8gbmlzaSwgbGFjaW5pYSBtb2xlc3RpZSBhcmN1IGNvbnNlcXVhdCBxdWlzLiBNb3JiaSBhdCBzdXNjaXBpdCByaXN1cy4gU2VkIGNvbnNlcXVhdCBlbGVpZmVuZCBtZXR1cywgdml0YWUgbWFsZXN1YWRhIGVyb3MgZWxlbWVudHVtIHNlZC4gPC9wPjxoMz5HdWlkZSBCb29rczwvaDM+PHA+RnVzY2UgcmlzdXMgZmVsaXMsIHZpdmVycmEgZXQgZGlnbmlzc2ltIGF0LCBsb2JvcnRpcyBub24gZXN0LiBMb3JlbSBpcHN1bSBkb2xvciBzaXQgYW1ldCwgY29uc2VjdGV0dXIgYWRpcGlzY2luZyBlbGl0LiBOdWxsYW0gc2l0IGFtZXQgY29uc2VjdGV0dXIgbGFjdXMuIFZlc3RpYnVsdW0gbmVxdWUgbGVjdHVzLCBlZ2VzdGFzIG5vbiBjdXJzdXMgdml0YWUsIGFsaXF1YW0gYXQgbWFnbmEuIEV0aWFtIGFsaXF1YW0sIGp1c3RvIGV0IHZhcml1cyBlbGVpZmVuZCwgZHVpIGxlY3R1cyBlZ2VzdGFzIG51bmMsIHZlbCBtYWxlc3VhZGEgbmlzbCBwdXJ1cyBuZWMgbWV0dXMuIDwvcD48aDM+QWRtaW4gQWNjb3VudHM8L2gzPjxwPkZ1c2NlIHJpc3VzIGZlbGlzLCB2aXZlcnJhIGV0IGRpZ25pc3NpbSBhdCwgbG9ib3J0aXMgbm9uIGVzdC4gTG9yZW0gaXBzdW0gZG9sb3Igc2l0IGFtZXQsIGNvbnNlY3RldHVyIGFkaXBpc2NpbmcgZWxpdC4gTnVsbGFtIHNpdCBhbWV0IGNvbnNlY3RldHVyIGxhY3VzLiBWZXN0aWJ1bHVtIG5lcXVlIGxlY3R1cywgZWdlc3RhcyBub24gY3Vyc3VzIHZpdGFlLCBhbGlxdWFtIGF0IG1hZ25hLiBFdGlhbSBhbGlxdWFtLCBqdXN0byBldCB2YXJpdXMgZWxlaWZlbmQsIGR1aSBsZWN0dXMgZWdlc3RhcyBudW5jLCB2ZWwgbWFsZXN1YWRhIG5pc2wgcHVydXMgbmVjIG1ldHVzLsKgPC9wPiI7fQ=='),
(90, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjkwO3M6OToiACoAX3RhYmxlIjtzOjE0OiJidENvbnRlbnRMb2NhbCI7czo3OiJjb250ZW50IjtzOjg3MToiCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8aDM+U3VwcG9ydDwvaDM+PHA+Q3VyYWJpdHVyIHNhZ2l0dGlzIGVsZW1lbnR1bSBmZWxpcyBhdCBzb2RhbGVzLiBOdWxsYW0gZmVybWVudHVtIGF0IHVybmEgcXVpcyBhY2N1bXNhbi4gTmFtIGJpYmVuZHVtIGxlbyBuaXNpLCBsYWNpbmlhIG1vbGVzdGllIGFyY3UgY29uc2VxdWF0IHF1aXMuIE1vcmJpIGF0IHN1c2NpcGl0IHJpc3VzLiBTZWQgY29uc2VxdWF0IGVsZWlmZW5kIG1ldHVzLCB2aXRhZSBtYWxlc3VhZGEgZXJvcyBlbGVtZW50dW0gc2VkLiA8L3A+PGgzPkFkZGl0aW9uYWwgT3B0aW9uczwvaDM+PHA+RnVzY2UgcmlzdXMgZmVsaXMsIHZpdmVycmEgZXQgZGlnbmlzc2ltIGF0LCBsb2JvcnRpcyBub24gZXN0LiBMb3JlbSBpcHN1bSBkb2xvciBzaXQgYW1ldCwgY29uc2VjdGV0dXIgYWRpcGlzY2luZyBlbGl0LiBOdWxsYW0gc2l0IGFtZXQgY29uc2VjdGV0dXIgbGFjdXMuIFZlc3RpYnVsdW0gbmVxdWUgbGVjdHVzLCBlZ2VzdGFzIG5vbiBjdXJzdXMgdml0YWUsIGFsaXF1YW0gYXQgbWFnbmEuwqA8L3A+PHA+RXRpYW0gYWxpcXVhbSwganVzdG8gZXQgdmFyaXVzIGVsZWlmZW5kLCBkdWkgbGVjdHVzIGVnZXN0YXMgbnVuYywgdmVsIG1hbGVzdWFkYSBuaXNsIHB1cnVzIG5lYyBtZXR1cy4gSW4gZ3JhdmlkYSB0dXJwaXMgYSBwaGFyZXRyYSBjb21tb2RvLiBEb25lYyBub24gdHVycGlzIHZ1bHB1dGF0ZSwgZmF1Y2lidXMgbWV0dXMgYSwgY29uc2VjdGV0dXIgbnVuYy4gTW9yYmkgdG9ydG9yIG5pc2ksIGhlbmRyZXJpdCBzZWQgbGFvcmVldCBlZ2V0LCBmZXJtZW50dW0gZXQganVzdG8uIFN1c3BlbmRpc3NlIHBvdGVudGkuPC9wPiI7fQ=='),
(91, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjkxO3M6OToiACoAX3RhYmxlIjtzOjE0OiJidENvbnRlbnRMb2NhbCI7czo3OiJjb250ZW50IjtzOjEzNToiCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxwIHN0eWxlPSJ0ZXh0LWFsaWduOiBjZW50ZXIiPjxzcGFuIGNsYXNzPSJ0aXRsZS1jYXBzIj5XaGF0IENsaWVudHMgQXJlIFNheWluZyBBYm91dCBVczwvc3Bhbj48L3A+Ijt9'),
(92, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjkyO3M6OToiACoAX3RhYmxlIjtzOjE2OiJidENvcmVBcmVhTGF5b3V0IjtzOjEwOiJhckxheW91dElEIjtzOjI6IjE0Ijt9'),
(93, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 25, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjkzO3M6OToiACoAX3RhYmxlIjtzOjEzOiJidFRlc3RpbW9uaWFsIjtzOjM6ImZJRCI7aToyO3M6NDoibmFtZSI7czoxMjoiRnJhbnogTWFydW5hIjtzOjg6InBvc2l0aW9uIjtzOjEzOiJDRU8gJiBGb3VuZGVyIjtzOjc6ImNvbXBhbnkiO3M6OToiY29uY3JldGU1IjtzOjEwOiJjb21wYW55VVJMIjtzOjIwOiJodHRwOi8vY29uY3JldGU1Lm9yZyI7czo5OiJwYXJhZ3JhcGgiO3M6MjI1OiIKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIEN1cmFiaXR1ciBzYWdpdHRpcyBlbGVtZW50dW0gZmVsaXMgYXQgc29kYWxlcy4gTnVsbGFtIGZlcm1lbnR1bSBhdCB1cm5hIHF1aXMgYWNjdW1zYW4uIE5hbSBiaWJlbmR1bSBsZW8gbmlzaSwgbGFjaW5pYSBtb2xlc3RpZSBhcmN1IGNvbnNlcXVhdCBxdWlzLiBNb3JiaSBhdCBzdXNjaXBpdCByaXN1cy4iO30='),
(94, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 25, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjk0O3M6OToiACoAX3RhYmxlIjtzOjEzOiJidFRlc3RpbW9uaWFsIjtzOjM6ImZJRCI7aToyO3M6NDoibmFtZSI7czo4OiJKb2huIERvZSI7czo4OiJwb3NpdGlvbiI7czoxOToiTWFya2V0aW5nIERpcmVjdG9yeSI7czo3OiJjb21wYW55IjtzOjk6IkNvbXBhbnlDbyI7czoxMDoiY29tcGFueVVSTCI7czowOiIiO3M6OToicGFyYWdyYXBoIjtzOjIyNToiCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBDdXJhYml0dXIgc2FnaXR0aXMgZWxlbWVudHVtIGZlbGlzIGF0IHNvZGFsZXMuIE51bGxhbSBmZXJtZW50dW0gYXQgdXJuYSBxdWlzIGFjY3Vtc2FuLiBOYW0gYmliZW5kdW0gbGVvIG5pc2ksIGxhY2luaWEgbW9sZXN0aWUgYXJjdSBjb25zZXF1YXQgcXVpcy4gTW9yYmkgYXQgc3VzY2lwaXQgcmlzdXMuIjt9'),
(95, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 25, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjk1O3M6OToiACoAX3RhYmxlIjtzOjEzOiJidFRlc3RpbW9uaWFsIjtzOjM6ImZJRCI7aToyO3M6NDoibmFtZSI7czoxMzoiQW5kcmV3IEVtYmxlciI7czo4OiJwb3NpdGlvbiI7czoxMzoiQ1RPICYgRm91bmRlciI7czo3OiJjb21wYW55IjtzOjk6ImNvbmNyZXRlNSI7czoxMDoiY29tcGFueVVSTCI7czoyMDoiaHR0cDovL2NvbmNyZXRlNS5vcmciO3M6OToicGFyYWdyYXBoIjtzOjIyNToiCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBDdXJhYml0dXIgc2FnaXR0aXMgZWxlbWVudHVtIGZlbGlzIGF0IHNvZGFsZXMuIE51bGxhbSBmZXJtZW50dW0gYXQgdXJuYSBxdWlzIGFjY3Vtc2FuLiBOYW0gYmliZW5kdW0gbGVvIG5pc2ksIGxhY2luaWEgbW9sZXN0aWUgYXJjdSBjb25zZXF1YXQgcXVpcy4gTW9yYmkgYXQgc3VzY2lwaXQgcmlzdXMuIjt9'),
(96, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 25, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjk2O3M6OToiACoAX3RhYmxlIjtzOjEzOiJidFRlc3RpbW9uaWFsIjtzOjM6ImZJRCI7aToyO3M6NDoibmFtZSI7czo4OiJKYW5lIERvZSI7czo4OiJwb3NpdGlvbiI7czoxMDoiSVQgTWFuYWdlciI7czo3OiJjb21wYW55IjtzOjk6IkNvbXBhbnlDbyI7czoxMDoiY29tcGFueVVSTCI7czowOiIiO3M6OToicGFyYWdyYXBoIjtzOjIyNToiCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBDdXJhYml0dXIgc2FnaXR0aXMgZWxlbWVudHVtIGZlbGlzIGF0IHNvZGFsZXMuIE51bGxhbSBmZXJtZW50dW0gYXQgdXJuYSBxdWlzIGFjY3Vtc2FuLiBOYW0gYmliZW5kdW0gbGVvIG5pc2ksIGxhY2luaWEgbW9sZXN0aWUgYXJjdSBjb25zZXF1YXQgcXVpcy4gTW9yYmkgYXQgc3VzY2lwaXQgcmlzdXMuIjt9'),
(97, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 31, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjk3O3M6OToiACoAX3RhYmxlIjtzOjEzOiJidEltYWdlU2xpZGVyIjtzOjE0OiJuYXZpZ2F0aW9uVHlwZSI7czoxOiIwIjtzOjc6InRpbWVvdXQiO2k6NDAwMDtzOjU6InNwZWVkIjtpOjUwMDtzOjk6Im5vQW5pbWF0ZSI7aTowO3M6NToicGF1c2UiO2k6MDtzOjg6Im1heFdpZHRoIjtpOjA7fQ=='),
(98, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, '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');
INSERT INTO `Blocks` VALUES
(99, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 31, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjk5O3M6OToiACoAX3RhYmxlIjtzOjEzOiJidEltYWdlU2xpZGVyIjtzOjE0OiJuYXZpZ2F0aW9uVHlwZSI7czoxOiIwIjtzOjc6InRpbWVvdXQiO2k6NDAwMDtzOjU6InNwZWVkIjtpOjUwMDtzOjk6Im5vQW5pbWF0ZSI7aTowO3M6NToicGF1c2UiO2k6MDtzOjg6Im1heFdpZHRoIjtpOjA7fQ=='),
(100, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, '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'),
(101, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 31, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjEwMTtzOjk6IgAqAF90YWJsZSI7czoxMzoiYnRJbWFnZVNsaWRlciI7czoxNDoibmF2aWdhdGlvblR5cGUiO3M6MToiMCI7czo3OiJ0aW1lb3V0IjtpOjQwMDA7czo1OiJzcGVlZCI7aTo1MDA7czo5OiJub0FuaW1hdGUiO2k6MDtzOjU6InBhdXNlIjtpOjA7czo4OiJtYXhXaWR0aCI7aTowO30='),
(102, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, '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'),
(103, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 31, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjEwMztzOjk6IgAqAF90YWJsZSI7czoxMzoiYnRJbWFnZVNsaWRlciI7czoxNDoibmF2aWdhdGlvblR5cGUiO3M6MToiMCI7czo3OiJ0aW1lb3V0IjtpOjQwMDA7czo1OiJzcGVlZCI7aTo1MDA7czo5OiJub0FuaW1hdGUiO2k6MDtzOjU6InBhdXNlIjtpOjA7czo4OiJtYXhXaWR0aCI7aTowO30='),
(104, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, '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'),
(105, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 31, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjEwNTtzOjk6IgAqAF90YWJsZSI7czoxMzoiYnRJbWFnZVNsaWRlciI7czoxNDoibmF2aWdhdGlvblR5cGUiO3M6MToiMCI7czo3OiJ0aW1lb3V0IjtpOjQwMDA7czo1OiJzcGVlZCI7aTo1MDA7czo5OiJub0FuaW1hdGUiO2k6MDtzOjU6InBhdXNlIjtpOjA7czo4OiJtYXhXaWR0aCI7aTowO30='),
(106, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, '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'),
(107, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 31, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjEwNztzOjk6IgAqAF90YWJsZSI7czoxMzoiYnRJbWFnZVNsaWRlciI7czoxNDoibmF2aWdhdGlvblR5cGUiO3M6MToiMCI7czo3OiJ0aW1lb3V0IjtpOjQwMDA7czo1OiJzcGVlZCI7aTo1MDA7czo5OiJub0FuaW1hdGUiO2k6MDtzOjU6InBhdXNlIjtpOjA7czo4OiJtYXhXaWR0aCI7aTowO30='),
(108, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, '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'),
(109, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 8, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjEwOTtzOjk6IgAqAF90YWJsZSI7czoxMToiYnRQYWdlVGl0bGUiO3M6MTQ6InVzZUN1c3RvbVRpdGxlIjtpOjA7czoxNDoidXNlRmlsdGVyVGl0bGUiO2k6MDtzOjE0OiJ1c2VGaWx0ZXJUb3BpYyI7aTowO3M6MTI6InVzZUZpbHRlclRhZyI7aTowO3M6MTM6InVzZUZpbHRlckRhdGUiO2k6MDtzOjk6InRpdGxlVGV4dCI7czowOiIiO30='),
(110, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjExMDtzOjk6IgAqAF90YWJsZSI7czoxNjoiYnRDb3JlQXJlYUxheW91dCI7czoxMDoiYXJMYXlvdXRJRCI7czoyOiIxNSI7fQ=='),
(111, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 25, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjExMTtzOjk6IgAqAF90YWJsZSI7czoxMzoiYnRUZXN0aW1vbmlhbCI7czozOiJmSUQiO2k6NDtzOjQ6Im5hbWUiO3M6MTA6IkpvaG4gU21pdGgiO3M6ODoicG9zaXRpb24iO3M6MTY6IkNvLUZvdW5kZXIgLyBDRU8iO3M6NzoiY29tcGFueSI7czowOiIiO3M6MTA6ImNvbXBhbnlVUkwiO3M6MDoiIjtzOjk6InBhcmFncmFwaCI7czoyMDA6IgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgQ3VyYWJpdHVyIHNhZ2l0dGlzIGVsZW1lbnR1bSBmZWxpcyBhdCBzb2RhbGVzLiBOdWxsYW0gZmVybWVudHVtIGF0IHVybmEgcXVpcyBhY2N1bXNhbi4gTmFtIGJpYmVuZHVtIGxlbyBuaXNpLCBsYWNpbmlhIG1vbGVzdGllIGFyY3UgY29uc2VxdWF0IHF1aXMuIjt9'),
(112, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 25, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjExMjtzOjk6IgAqAF90YWJsZSI7czoxMzoiYnRUZXN0aW1vbmlhbCI7czozOiJmSUQiO2k6NDtzOjQ6Im5hbWUiO3M6OToiQm9iIFNtaXRoIjtzOjg6InBvc2l0aW9uIjtzOjE2OiJDby1Gb3VuZGVyIC8gQ1RPIjtzOjc6ImNvbXBhbnkiO3M6MDoiIjtzOjEwOiJjb21wYW55VVJMIjtzOjA6IiI7czo5OiJwYXJhZ3JhcGgiO3M6MjAwOiIKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIEN1cmFiaXR1ciBzYWdpdHRpcyBlbGVtZW50dW0gZmVsaXMgYXQgc29kYWxlcy4gTnVsbGFtIGZlcm1lbnR1bSBhdCB1cm5hIHF1aXMgYWNjdW1zYW4uIE5hbSBiaWJlbmR1bSBsZW8gbmlzaSwgbGFjaW5pYSBtb2xlc3RpZSBhcmN1IGNvbnNlcXVhdCBxdWlzLiI7fQ=='),
(113, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 5, 1, NULL),
(114, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjExNDtzOjk6IgAqAF90YWJsZSI7czoxNjoiYnRDb3JlQXJlYUxheW91dCI7czoxMDoiYXJMYXlvdXRJRCI7czoyOiIxNiI7fQ=='),
(115, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 25, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjExNTtzOjk6IgAqAF90YWJsZSI7czoxMzoiYnRUZXN0aW1vbmlhbCI7czozOiJmSUQiO2k6NDtzOjQ6Im5hbWUiO3M6MTA6IkpvaG4gU21pdGgiO3M6ODoicG9zaXRpb24iO3M6MTI6IkFydCBEaXJlY3RvciI7czo3OiJjb21wYW55IjtzOjA6IiI7czoxMDoiY29tcGFueVVSTCI7czowOiIiO3M6OToicGFyYWdyYXBoIjtzOjIwMDoiCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBDdXJhYml0dXIgc2FnaXR0aXMgZWxlbWVudHVtIGZlbGlzIGF0IHNvZGFsZXMuIE51bGxhbSBmZXJtZW50dW0gYXQgdXJuYSBxdWlzIGFjY3Vtc2FuLiBOYW0gYmliZW5kdW0gbGVvIG5pc2ksIGxhY2luaWEgbW9sZXN0aWUgYXJjdSBjb25zZXF1YXQgcXVpcy4iO30='),
(116, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 25, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjExNjtzOjk6IgAqAF90YWJsZSI7czoxMzoiYnRUZXN0aW1vbmlhbCI7czozOiJmSUQiO2k6NDtzOjQ6Im5hbWUiO3M6MTA6IkpvaG4gU21pdGgiO3M6ODoicG9zaXRpb24iO3M6MTI6IkFydCBEaXJlY3RvciI7czo3OiJjb21wYW55IjtzOjA6IiI7czoxMDoiY29tcGFueVVSTCI7czowOiIiO3M6OToicGFyYWdyYXBoIjtzOjIwMDoiCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBDdXJhYml0dXIgc2FnaXR0aXMgZWxlbWVudHVtIGZlbGlzIGF0IHNvZGFsZXMuIE51bGxhbSBmZXJtZW50dW0gYXQgdXJuYSBxdWlzIGFjY3Vtc2FuLiBOYW0gYmliZW5kdW0gbGVvIG5pc2ksIGxhY2luaWEgbW9sZXN0aWUgYXJjdSBjb25zZXF1YXQgcXVpcy4iO30='),
(117, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 25, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjExNztzOjk6IgAqAF90YWJsZSI7czoxMzoiYnRUZXN0aW1vbmlhbCI7czozOiJmSUQiO2k6NDtzOjQ6Im5hbWUiO3M6OToiQm9iIFNtaXRoIjtzOjg6InBvc2l0aW9uIjtzOjEyOiJBcnQgRGlyZWN0b3IiO3M6NzoiY29tcGFueSI7czowOiIiO3M6MTA6ImNvbXBhbnlVUkwiO3M6MDoiIjtzOjk6InBhcmFncmFwaCI7czoyMDA6IgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgQ3VyYWJpdHVyIHNhZ2l0dGlzIGVsZW1lbnR1bSBmZWxpcyBhdCBzb2RhbGVzLiBOdWxsYW0gZmVybWVudHVtIGF0IHVybmEgcXVpcyBhY2N1bXNhbi4gTmFtIGJpYmVuZHVtIGxlbyBuaXNpLCBsYWNpbmlhIG1vbGVzdGllIGFyY3UgY29uc2VxdWF0IHF1aXMuIjt9'),
(118, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 25, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjExODtzOjk6IgAqAF90YWJsZSI7czoxMzoiYnRUZXN0aW1vbmlhbCI7czozOiJmSUQiO2k6NDtzOjQ6Im5hbWUiO3M6OToiQm9iIFNtaXRoIjtzOjg6InBvc2l0aW9uIjtzOjEyOiJBcnQgRGlyZWN0b3IiO3M6NzoiY29tcGFueSI7czowOiIiO3M6MTA6ImNvbXBhbnlVUkwiO3M6MDoiIjtzOjk6InBhcmFncmFwaCI7czoyMDA6IgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgQ3VyYWJpdHVyIHNhZ2l0dGlzIGVsZW1lbnR1bSBmZWxpcyBhdCBzb2RhbGVzLiBOdWxsYW0gZmVybWVudHVtIGF0IHVybmEgcXVpcyBhY2N1bXNhbi4gTmFtIGJpYmVuZHVtIGxlbyBuaXNpLCBsYWNpbmlhIG1vbGVzdGllIGFyY3UgY29uc2VxdWF0IHF1aXMuIjt9'),
(119, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 25, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjExOTtzOjk6IgAqAF90YWJsZSI7czoxMzoiYnRUZXN0aW1vbmlhbCI7czozOiJmSUQiO2k6NDtzOjQ6Im5hbWUiO3M6OToiQm9iIFNtaXRoIjtzOjg6InBvc2l0aW9uIjtzOjEyOiJBcnQgRGlyZWN0b3IiO3M6NzoiY29tcGFueSI7czowOiIiO3M6MTA6ImNvbXBhbnlVUkwiO3M6MDoiIjtzOjk6InBhcmFncmFwaCI7czoyMDA6IgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgQ3VyYWJpdHVyIHNhZ2l0dGlzIGVsZW1lbnR1bSBmZWxpcyBhdCBzb2RhbGVzLiBOdWxsYW0gZmVybWVudHVtIGF0IHVybmEgcXVpcyBhY2N1bXNhbi4gTmFtIGJpYmVuZHVtIGxlbyBuaXNpLCBsYWNpbmlhIG1vbGVzdGllIGFyY3UgY29uc2VxdWF0IHF1aXMuIjt9'),
(120, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 25, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjEyMDtzOjk6IgAqAF90YWJsZSI7czoxMzoiYnRUZXN0aW1vbmlhbCI7czozOiJmSUQiO2k6NDtzOjQ6Im5hbWUiO3M6OToiQm9iIFNtaXRoIjtzOjg6InBvc2l0aW9uIjtzOjEyOiJBcnQgRGlyZWN0b3IiO3M6NzoiY29tcGFueSI7czowOiIiO3M6MTA6ImNvbXBhbnlVUkwiO3M6MDoiIjtzOjk6InBhcmFncmFwaCI7czoyMDA6IgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgQ3VyYWJpdHVyIHNhZ2l0dGlzIGVsZW1lbnR1bSBmZWxpcyBhdCBzb2RhbGVzLiBOdWxsYW0gZmVybWVudHVtIGF0IHVybmEgcXVpcyBhY2N1bXNhbi4gTmFtIGJpYmVuZHVtIGxlbyBuaXNpLCBsYWNpbmlhIG1vbGVzdGllIGFyY3UgY29uc2VxdWF0IHF1aXMuIjt9'),
(121, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 5, 1, NULL),
(122, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjEyMjtzOjk6IgAqAF90YWJsZSI7czoxNjoiYnRDb3JlQXJlYUxheW91dCI7czoxMDoiYXJMYXlvdXRJRCI7czoyOiIxNyI7fQ=='),
(123, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 3, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjEzOntzOjM6ImJJRCI7aToxMjM7czo5OiIAKgBfdGFibGUiO3M6MTQ6ImJ0Q29udGVudEltYWdlIjtzOjM6ImZJRCI7aTo2O3M6MTA6ImZPbnN0YXRlSUQiO2k6MDtzOjk6ImNyb3BJbWFnZSI7aTowO3M6ODoibWF4V2lkdGgiO2k6MDtzOjk6Im1heEhlaWdodCI7aTowO3M6MTI6ImV4dGVybmFsTGluayI7czowOiIiO3M6MTU6ImludGVybmFsTGlua0NJRCI7aTowO3M6MTA6ImZpbGVMaW5rSUQiO2k6MDtzOjE5OiJvcGVuTGlua0luTmV3V2luZG93IjtpOjA7czo3OiJhbHRUZXh0IjtzOjExOiJCbGFuayBJbWFnZSI7czo1OiJ0aXRsZSI7czoxMToiQmxhbmsgSW1hZ2UiO30='),
(124, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjEyNDtzOjk6IgAqAF90YWJsZSI7czoxNDoiYnRDb250ZW50TG9jYWwiO3M6NzoiY29udGVudCI7czozMTk6IgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHAgY2xhc3M9InRpdGxlLXRoaW4iPkdldCBpbiBUb3VjaDwvcD48cD5TZWQgY3Vyc3VzIGZhY2lsaXNpcyBkaWduaXNzaW0uIEFsaXF1YW0gcmhvbmN1cyBlbmltIGV0IHBlbGxlbnRlc3F1ZSB2YXJpdXMuIE51bGxhIHNvZGFsZXMgbmliaCBsb3JlbSwgc2l0IGFtZXQgaW1wZXJkaWV0IGFyY3UgY29tbW9kbyBzaXQgYW1ldC48YnI+PGJyPjwvcD48cD48YSBjbGFzcz0iYnRuIGJ0bi1zdWNjZXNzIiBocmVmPSJ7Q0NNOkNJRF8yMDF9Ij5Db250YWN0IFVzPC9hPjwvcD4iO30='),
(125, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 23, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjE2OntzOjM6ImJJRCI7aToxMjU7czo5OiIAKgBfdGFibGUiO3M6MTg6ImJ0Q29yZUNvbnZlcnNhdGlvbiI7czo1OiJjbnZJRCI7czoxOiIyIjtzOjEzOiJlbmFibGVQb3N0aW5nIjtzOjE6IjEiO3M6ODoicGFnaW5hdGUiO3M6MToiMSI7czoxMjoiaXRlbXNQZXJQYWdlIjtzOjI6IjUwIjtzOjExOiJkaXNwbGF5TW9kZSI7czo4OiJ0aHJlYWRlZCI7czo3OiJvcmRlckJ5IjtzOjg6ImRhdGVfYXNjIjtzOjE0OiJlbmFibGVPcmRlcmluZyI7aTowO3M6MTk6ImVuYWJsZUNvbW1lbnRSYXRpbmciO3M6MToiMSI7czoyMzoiZW5hYmxlVG9wQ29tbWVudFJldmlld3MiO2k6MDtzOjE4OiJkaXNwbGF5U29jaWFsTGlua3MiO2k6MDtzOjE4OiJkaXNwbGF5UG9zdGluZ0Zvcm0iO3M6MzoidG9wIjtzOjE1OiJhZGRNZXNzYWdlTGFiZWwiO3M6MTE6IkFkZCBNZXNzYWdlIjtzOjEwOiJkYXRlRm9ybWF0IjtzOjc6ImRlZmF1bHQiO3M6MTY6ImN1c3RvbURhdGVGb3JtYXQiO3M6MDoiIjt9'),
(126, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, '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'),
(127, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 23, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjE2OntzOjM6ImJJRCI7aToxMjc7czo5OiIAKgBfdGFibGUiO3M6MTg6ImJ0Q29yZUNvbnZlcnNhdGlvbiI7czo1OiJjbnZJRCI7czoxOiIzIjtzOjEzOiJlbmFibGVQb3N0aW5nIjtzOjE6IjEiO3M6ODoicGFnaW5hdGUiO3M6MToiMSI7czoxMjoiaXRlbXNQZXJQYWdlIjtzOjI6IjUwIjtzOjExOiJkaXNwbGF5TW9kZSI7czo4OiJ0aHJlYWRlZCI7czo3OiJvcmRlckJ5IjtzOjg6ImRhdGVfYXNjIjtzOjE0OiJlbmFibGVPcmRlcmluZyI7aTowO3M6MTk6ImVuYWJsZUNvbW1lbnRSYXRpbmciO3M6MToiMSI7czoyMzoiZW5hYmxlVG9wQ29tbWVudFJldmlld3MiO2k6MDtzOjE4OiJkaXNwbGF5U29jaWFsTGlua3MiO2k6MDtzOjE4OiJkaXNwbGF5UG9zdGluZ0Zvcm0iO3M6MzoidG9wIjtzOjE1OiJhZGRNZXNzYWdlTGFiZWwiO3M6MTE6IkFkZCBNZXNzYWdlIjtzOjEwOiJkYXRlRm9ybWF0IjtzOjc6ImRlZmF1bHQiO3M6MTY6ImN1c3RvbURhdGVGb3JtYXQiO3M6MDoiIjt9'),
(128, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjEyODtzOjk6IgAqAF90YWJsZSI7czoxNDoiYnRDb250ZW50TG9jYWwiO3M6NzoiY29udGVudCI7czo5NDE6IgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8cD5DdXJhYml0dXIgc2FnaXR0aXMgZWxlbWVudHVtIGZlbGlzIGF0IHNvZGFsZXMuIE51bGxhbSBmZXJtZW50dW0gYXQgdXJuYSBxdWlzIGFjY3Vtc2FuLiBOYW0gYmliZW5kdW0gbGVvIG5pc2ksIGxhY2luaWEgbW9sZXN0aWUgYXJjdSBjb25zZXF1YXQgcXVpcy4gTW9yYmkgYXQgc3VzY2lwaXQgcmlzdXMuIFNlZCBjb25zZXF1YXQgZWxlaWZlbmQgbWV0dXMsIHZpdGFlIG1hbGVzdWFkYSBlcm9zIGVsZW1lbnR1bSBzZWQuIEZ1c2NlIHJpc3VzIGZlbGlzLCB2aXZlcnJhIGV0IGRpZ25pc3NpbSBhdCwgbG9ib3J0aXMgbm9uIGVzdC4gTG9yZW0gaXBzdW0gZG9sb3Igc2l0IGFtZXQsIGNvbnNlY3RldHVyIGFkaXBpc2NpbmcgZWxpdC7CoDwvcD48cD48c3BhbiBjbGFzcz0idGl0bGUtdGhpbiI+Q01TIFRvIHRoZSBSZXNjdWUhPC9zcGFuPjwvcD48cD5OdWxsYW0gc2l0IGFtZXQgY29uc2VjdGV0dXIgbGFjdXMuIFZlc3RpYnVsdW0gbmVxdWUgbGVjdHVzLCBlZ2VzdGFzIG5vbiBjdXJzdXMgdml0YWUsIGFsaXF1YW0gYXQgbWFnbmEuIEV0aWFtIGFsaXF1YW0sIGp1c3RvIGV0IHZhcml1cyBlbGVpZmVuZCwgZHVpIGxlY3R1cyBlZ2VzdGFzIG51bmMsIHZlbCBtYWxlc3VhZGEgbmlzbCBwdXJ1cyBuZWMgbWV0dXMuIEluIGdyYXZpZGEgdHVycGlzIGEgcGhhcmV0cmEgY29tbW9kby4gRG9uZWMgbm9uIHR1cnBpcyB2dWxwdXRhdGUsIGZhdWNpYnVzIG1ldHVzIGEsIGNvbnNlY3RldHVyIG51bmMuIE1vcmJpIHRvcnRvciBuaXNpLCBoZW5kcmVyaXQgc2VkIGxhb3JlZXQgZWdldCwgZmVybWVudHVtIGV0IGp1c3RvLiBTdXNwZW5kaXNzZSBwb3RlbnRpLjwvcD48cD48YSBocmVmPSJodHRwOi8vd3d3LmNvbmNyZXRlNS5vcmciPkxlYXJuIG1vcmUgYXQgY29uY3JldGU1Lm9yZ8KgPC9hPjxicj48L3A+Ijt9'),
(129, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 23, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjE2OntzOjM6ImJJRCI7aToxMjk7czo5OiIAKgBfdGFibGUiO3M6MTg6ImJ0Q29yZUNvbnZlcnNhdGlvbiI7czo1OiJjbnZJRCI7czoxOiI0IjtzOjEzOiJlbmFibGVQb3N0aW5nIjtzOjE6IjEiO3M6ODoicGFnaW5hdGUiO3M6MToiMSI7czoxMjoiaXRlbXNQZXJQYWdlIjtzOjI6IjUwIjtzOjExOiJkaXNwbGF5TW9kZSI7czo4OiJ0aHJlYWRlZCI7czo3OiJvcmRlckJ5IjtzOjg6ImRhdGVfYXNjIjtzOjE0OiJlbmFibGVPcmRlcmluZyI7aTowO3M6MTk6ImVuYWJsZUNvbW1lbnRSYXRpbmciO3M6MToiMSI7czoyMzoiZW5hYmxlVG9wQ29tbWVudFJldmlld3MiO2k6MDtzOjE4OiJkaXNwbGF5U29jaWFsTGlua3MiO2k6MDtzOjE4OiJkaXNwbGF5UG9zdGluZ0Zvcm0iO3M6MzoidG9wIjtzOjE1OiJhZGRNZXNzYWdlTGFiZWwiO3M6MTE6IkFkZCBNZXNzYWdlIjtzOjEwOiJkYXRlRm9ybWF0IjtzOjc6ImRlZmF1bHQiO3M6MTY6ImN1c3RvbURhdGVGb3JtYXQiO3M6MDoiIjt9'),
(130, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, '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'),
(131, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 18, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjk6e3M6MzoiYklEIjtpOjEzMTtzOjk6IgAqAF90YWJsZSI7czo4OiJidFNlYXJjaCI7czo1OiJ0aXRsZSI7czo2OiJTZWFyY2giO3M6MTA6ImJ1dHRvblRleHQiO3M6NjoiU2VhcmNoIjtzOjE0OiJiYXNlU2VhcmNoUGF0aCI7czowOiIiO3M6MTA6InNlYXJjaF9hbGwiO2k6MDtzOjE4OiJhbGxvd191c2VyX29wdGlvbnMiO2k6MDtzOjEwOiJwb3N0VG9fY0lEIjtOO3M6MTA6InJlc3VsdHNVUkwiO3M6MDoiIjt9'),
(132, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 8, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjEzMjtzOjk6IgAqAF90YWJsZSI7czoxMToiYnRQYWdlVGl0bGUiO3M6MTQ6InVzZUN1c3RvbVRpdGxlIjtpOjA7czoxNDoidXNlRmlsdGVyVGl0bGUiO2k6MDtzOjE0OiJ1c2VGaWx0ZXJUb3BpYyI7aTowO3M6MTI6InVzZUZpbHRlclRhZyI7aTowO3M6MTM6InVzZUZpbHRlckRhdGUiO2k6MDtzOjk6InRpdGxlVGV4dCI7czowOiIiO30='),
(133, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjEzMztzOjk6IgAqAF90YWJsZSI7czoxNjoiYnRDb3JlQXJlYUxheW91dCI7czoxMDoiYXJMYXlvdXRJRCI7czoyOiIxOCI7fQ=='),
(134, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 35, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjEwOntzOjM6ImJJRCI7aToxMzQ7czo5OiIAKgBfdGFibGUiO3M6MTE6ImJ0R29vZ2xlTWFwIjtzOjU6InRpdGxlIjtzOjA6IiI7czo4OiJsb2NhdGlvbiI7czo0NzoiMTIwMCBOVyBOYWl0byBQa3d5LCBQb3J0bGFuZCwgT1IsIFVuaXRlZCBTdGF0ZXMiO3M6ODoibGF0aXR1ZGUiO3M6MTA6IjQ1LjUzMTMyNTQiO3M6OToibG9uZ2l0dWRlIjtzOjEyOiItMTIyLjY3NjM0OTMiO3M6NDoiem9vbSI7aToxNDtzOjU6IndpZHRoIjtzOjQ6IjEwMCUiO3M6NjoiaGVpZ2h0IjtzOjU6IjQwMHB4IjtzOjExOiJzY3JvbGx3aGVlbCI7aTowO30='),
(135, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjEzNTtzOjk6IgAqAF90YWJsZSI7czoxNDoiYnRDb250ZW50TG9jYWwiO3M6NzoiY29udGVudCI7czoyNjU6IgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPGg1PkhlYWRxdWFydGVyczwvaDU+PHA+MTIzNCBTRSBTdHJlZXQgVmlldzxicj5TdWl0ZSAzMDE8YnI+UG9ydGxhbmQsIE9SIDk4MTAxPC9wPjxoNT5IT1VSUzwvaDU+PHA+IDxzdHJvbmc+TS1GPC9zdHJvbmc+OiAgMTAgQU0gLSA3IFBNPGJyPjxzdHJvbmc+U2F0PC9zdHJvbmc+OiBOb29uIC0gTWlkbmlnaHQ8YnI+PHN0cm9uZz5TdW48L3N0cm9uZz46IENsb3NlZDwvcD4iO30='),
(136, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 5, 1, NULL),
(137, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjEzNztzOjk6IgAqAF90YWJsZSI7czoxNjoiYnRDb3JlQXJlYUxheW91dCI7czoxMDoiYXJMYXlvdXRJRCI7czoyOiIxOSI7fQ=='),
(138, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 3, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjEyOntzOjM6ImJJRCI7aToxMzg7czo5OiIAKgBfdGFibGUiO3M6MTQ6ImJ0Q29udGVudEltYWdlIjtzOjM6ImZJRCI7aTo4O3M6MTA6ImZPbnN0YXRlSUQiO2k6MDtzOjk6ImNyb3BJbWFnZSI7aTowO3M6ODoibWF4V2lkdGgiO2k6MDtzOjk6Im1heEhlaWdodCI7aTowO3M6MTI6ImV4dGVybmFsTGluayI7czowOiIiO3M6MTU6ImludGVybmFsTGlua0NJRCI7aTowO3M6MTA6ImZpbGVMaW5rSUQiO2k6MDtzOjE5OiJvcGVuTGlua0luTmV3V2luZG93IjtpOjA7czo3OiJhbHRUZXh0IjtzOjA6IiI7fQ=='),
(139, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjEzOTtzOjk6IgAqAF90YWJsZSI7czoxNDoiYnRDb250ZW50TG9jYWwiO3M6NzoiY29udGVudCI7czo1NzM6IgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPGgyPkNob29zaW5nIFVzPC9oMj48cD5QZWxsZW50ZXNxdWUgdWx0cmljaWVzIGxpZ3VsYSB2ZWwgbmVxdWUgZGljdHVtLCBldSBtb2xsaXMgdG9ydG9yIGFkaXBpc2NpbmcuIEV0aWFtIGNvbmd1ZSwgZXN0IHZlbCB0aW5jaWR1bnQgdmVzdGlidWx1bSwgbnVuYyBudW5jIHBvcnRhIG51bGxhLCBhdCBhZGlwaXNjaW5nIG5lcXVlIHRlbGx1cyBxdWlzIHVybmEuIFF1aXNxdWUgZGlnbmlzc2ltIG5lcXVlIGEgaXBzdW0gc29kYWxlcywgbWF0dGlzIGFsaXF1YW0gYW50ZSBkaWN0dW0uIFZlc3RpYnVsdW0gZWxlbWVudHVtIHBlbGxlbnRlc3F1ZSB0b3J0b3IgYWMgY29uZ3VlLiBNYXVyaXMgdmVsIG5pYmggaWQgbWV0dXMgdGluY2lkdW50IGVsZWlmZW5kLiBJbiBpbnRlcmR1bSBncmF2aWRhIGxpZ3VsYSwgYXQgdmVuZW5hdGlzIG9kaW8gZmVybWVudHVtIGF0LiBEb25lYyBkYXBpYnVzIGVuaW0gbGVjdHVzLCBxdWlzIHZlbmVuYXRpcyB0ZWxsdXMgdm9sdXRwYXQgaW4uIE51bGxhbSBpbiB2ZWxpdCB0b3J0b3IuPC9wPiI7fQ=='),
(140, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjE0MDtzOjk6IgAqAF90YWJsZSI7czoxNDoiYnRDb250ZW50TG9jYWwiO3M6NzoiY29udGVudCI7czo0MDoiPGg1PldlIHdvdWxkIGxvdmUgdG8gaGVhciBmcm9tIHlvdSE8L2g1PiI7fQ=='),
(141, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 17, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjEyOntzOjM6ImJJRCI7aToxNDE7czo5OiIAKgBfdGFibGUiO3M6MTM6ImJ0RXhwcmVzc0Zvcm0iO3M6ODoiZXhGb3JtSUQiO3M6MzY6Ijg4MWI2YmRlLTIyMGYtNDQ4Mi1iOGY5LWFjZTQwYjVkMTY5YiI7czoxMToic3VibWl0TGFiZWwiO3M6NjoiU3VibWl0IjtzOjExOiJ0aGFua3lvdU1zZyI7czo3OiJUaGFua3MhIjtzOjIwOiJub3RpZnlNZU9uU3VibWlzc2lvbiI7czoxOiIwIjtzOjE0OiJyZWNpcGllbnRFbWFpbCI7czowOiIiO3M6MTQ6ImRpc3BsYXlDYXB0Y2hhIjtzOjE6IjAiO3M6MTk6InN0b3JlRm9ybVN1Ym1pc3Npb24iO2I6MTtzOjExOiJyZWRpcmVjdENJRCI7czoxOiIwIjtzOjIxOiJyZXBseVRvRW1haWxDb250cm9sSUQiO3M6ODU6IjAyMTgxYWUyLTYzNGQtMTFlNi1hMjQ1LTYyZTY1YjE2NWQ4ZQogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAiO3M6MTM6ImFkZEZpbGVzVG9TZXQiO3M6MToiMCI7fQ=='),
(142, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjE0MjtzOjk6IgAqAF90YWJsZSI7czoxNDoiYnRDb250ZW50TG9jYWwiO3M6NzoiY29udGVudCI7czo1NToiPHA+VGhpcyBpcyBteSBlbXB0eSBjb250ZW50IGJsb2NrIG9uIG15IGJsYW5rIHBhZ2UuPC9wPiI7fQ=='),
(143, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 8, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjE0MztzOjk6IgAqAF90YWJsZSI7czoxMToiYnRQYWdlVGl0bGUiO3M6MTQ6InVzZUN1c3RvbVRpdGxlIjtpOjA7czoxNDoidXNlRmlsdGVyVGl0bGUiO2k6MDtzOjE0OiJ1c2VGaWx0ZXJUb3BpYyI7aTowO3M6MTI6InVzZUZpbHRlclRhZyI7aTowO3M6MTM6InVzZUZpbHRlckRhdGUiO2k6MDtzOjk6InRpdGxlVGV4dCI7czowOiIiO30='),
(144, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjE0NDtzOjk6IgAqAF90YWJsZSI7czoxNjoiYnRDb3JlQXJlYUxheW91dCI7czoxMDoiYXJMYXlvdXRJRCI7czoyOiIyMCI7fQ=='),
(145, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 3, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjEyOntzOjM6ImJJRCI7aToxNDU7czo5OiIAKgBfdGFibGUiO3M6MTQ6ImJ0Q29udGVudEltYWdlIjtzOjM6ImZJRCI7aTo1O3M6MTA6ImZPbnN0YXRlSUQiO2k6MDtzOjk6ImNyb3BJbWFnZSI7aTowO3M6ODoibWF4V2lkdGgiO2k6MDtzOjk6Im1heEhlaWdodCI7aTowO3M6MTI6ImV4dGVybmFsTGluayI7czowOiIiO3M6MTU6ImludGVybmFsTGlua0NJRCI7aTowO3M6MTA6ImZpbGVMaW5rSUQiO2k6MDtzOjE5OiJvcGVuTGlua0luTmV3V2luZG93IjtpOjA7czo3OiJhbHRUZXh0IjtzOjA6IiI7fQ=='),
(146, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjE0NjtzOjk6IgAqAF90YWJsZSI7czoxNDoiYnRDb250ZW50TG9jYWwiO3M6NzoiY29udGVudCI7czoxNzA6IgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPGJsb2NrcXVvdGU+RnVzY2Ugdm9sdXRwYXQgc29kYWxlcyBtYXVyaXMgcXVpcyBkYXBpYnVzLiBNYWVjZW5hcyBjb252YWxsaXMsIGxpYmVybyBldSB1bHRyaWNlcyBpbnRlcmR1bS48L2Jsb2NrcXVvdGU+Ijt9');
INSERT INTO `Blocks` VALUES
(147, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjE0NztzOjk6IgAqAF90YWJsZSI7czoxNDoiYnRDb250ZW50TG9jYWwiO3M6NzoiY29udGVudCI7czo0NDk6IgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHA+UGVsbGVudGVzcXVlIHVsdHJpY2llcyBsaWd1bGEgdmVsIG5lcXVlIGRpY3R1bSwgZXUgbW9sbGlzIHRvcnRvciBhZGlwaXNjaW5nLiBFdGlhbSBjb25ndWUsIGVzdCB2ZWwgdGluY2lkdW50IHZlc3RpYnVsdW0sIG51bmMgbnVuYyBwb3J0YSBudWxsYSwgYXQgYWRpcGlzY2luZyBuZXF1ZSB0ZWxsdXMgcXVpcyB1cm5hLiA8L3A+PHA+PGEgaHJlZj0iaHR0cDovL3d3dy55YWhvby5jb20iPlF1aXNxdWUgZGlnbmlzc2ltPC9hPiBuZXF1ZSBhIGlwc3VtIHNvZGFsZXMsIG1hdHRpcyBhbGlxdWFtIGFudGUgZGljdHVtLiBWZXN0aWJ1bHVtIGVsZW1lbnR1bSBwZWxsZW50ZXNxdWUgdG9ydG9yIGFjIGNvbmd1ZS4gTWF1cmlzIHZlbCBuaWJoIGlkIG1ldHVzIHRpbmNpZHVudCBlbGVpZmVuZC48L3A+Ijt9'),
(148, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 5, 1, NULL),
(149, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjE0OTtzOjk6IgAqAF90YWJsZSI7czoxNjoiYnRDb3JlQXJlYUxheW91dCI7czoxMDoiYXJMYXlvdXRJRCI7czoyOiIyMSI7fQ=='),
(150, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjE1MDtzOjk6IgAqAF90YWJsZSI7czoxNDoiYnRDb250ZW50TG9jYWwiO3M6NzoiY29udGVudCI7czoxNjE6IgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPGgxPkhlYWRpbmcgMTwvaDE+PGgyPkhlYWRpbmcgMjwvaDI+PGgzPkhlYWRpbmcgMzwvaDM+PGg0PkhlYWRpbmcgNDwvaDQ+PGg1PkhlYWRpbmcgNTwvaDU+PGg2PkhlYWRpbmcgNjwvaDY+Ijt9'),
(151, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjE1MTtzOjk6IgAqAF90YWJsZSI7czoxNDoiYnRDb250ZW50TG9jYWwiO3M6NzoiY29udGVudCI7czo4MjU6IgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHA+Q3VyYWJpdHVyIHNhZ2l0dGlzIGVsZW1lbnR1bSBmZWxpcyBhdCBzb2RhbGVzLiBOdWxsYW0gZmVybWVudHVtIGF0IHVybmEgcXVpcyBhY2N1bXNhbi4gTmFtIGJpYmVuZHVtIGxlbyBuaXNpLCBsYWNpbmlhIG1vbGVzdGllIGFyY3UgY29uc2VxdWF0IHF1aXMuIE1vcmJpIGF0IHN1c2NpcGl0IHJpc3VzLiBTZWQgY29uc2VxdWF0IGVsZWlmZW5kIG1ldHVzLCB2aXRhZSBtYWxlc3VhZGEgZXJvcyBlbGVtZW50dW0gc2VkLiBGdXNjZSByaXN1cyBmZWxpcywgdml2ZXJyYSBldCBkaWduaXNzaW0gYXQsIGxvYm9ydGlzIG5vbiBlc3QuIExvcmVtIGlwc3VtIGRvbG9yIHNpdCBhbWV0LCBjb25zZWN0ZXR1ciBhZGlwaXNjaW5nIGVsaXQuIE51bGxhbSBzaXQgYW1ldCBjb25zZWN0ZXR1ciBsYWN1cy4gVmVzdGlidWx1bSBuZXF1ZSBsZWN0dXMsIGVnZXN0YXMgbm9uIGN1cnN1cyB2aXRhZSwgYWxpcXVhbSBhdCBtYWduYS4gRXRpYW0gYWxpcXVhbSwganVzdG8gZXQgdmFyaXVzIGVsZWlmZW5kLCBkdWkgbGVjdHVzIGVnZXN0YXMgbnVuYywgdmVsIG1hbGVzdWFkYSBuaXNsIHB1cnVzIG5lYyBtZXR1cy4gSW4gZ3JhdmlkYSB0dXJwaXMgYSBwaGFyZXRyYSBjb21tb2RvLiBEb25lYyBub24gdHVycGlzIHZ1bHB1dGF0ZSwgZmF1Y2lidXMgbWV0dXMgYSwgY29uc2VjdGV0dXIgbnVuYy4gTW9yYmkgdG9ydG9yIG5pc2ksIGhlbmRyZXJpdCBzZWQgbGFvcmVldCBlZ2V0LCBmZXJtZW50dW0gZXQganVzdG8uIFN1c3BlbmRpc3NlIHBvdGVudGkuPGJyPjxicj48YnI+PC9wPiI7fQ=='),
(152, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 3, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjEyOntzOjM6ImJJRCI7aToxNTI7czo5OiIAKgBfdGFibGUiO3M6MTQ6ImJ0Q29udGVudEltYWdlIjtzOjM6ImZJRCI7aTo1O3M6MTA6ImZPbnN0YXRlSUQiO2k6MDtzOjk6ImNyb3BJbWFnZSI7aTowO3M6ODoibWF4V2lkdGgiO2k6MDtzOjk6Im1heEhlaWdodCI7aTowO3M6MTI6ImV4dGVybmFsTGluayI7czowOiIiO3M6MTU6ImludGVybmFsTGlua0NJRCI7aTowO3M6MTA6ImZpbGVMaW5rSUQiO2k6MDtzOjE5OiJvcGVuTGlua0luTmV3V2luZG93IjtpOjA7czo3OiJhbHRUZXh0IjtzOjA6IiI7fQ=='),
(153, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjE1MztzOjk6IgAqAF90YWJsZSI7czoxNDoiYnRDb250ZW50TG9jYWwiO3M6NzoiY29udGVudCI7czo4MjE6IgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHA+PGJyPjxicj5DdXJhYml0dXIgc2FnaXR0aXMgZWxlbWVudHVtIGZlbGlzIGF0IHNvZGFsZXMuIE51bGxhbSBmZXJtZW50dW0gYXQgdXJuYSBxdWlzIGFjY3Vtc2FuLiBOYW0gYmliZW5kdW0gbGVvIG5pc2ksIGxhY2luaWEgbW9sZXN0aWUgYXJjdSBjb25zZXF1YXQgcXVpcy4gTW9yYmkgYXQgc3VzY2lwaXQgcmlzdXMuIFNlZCBjb25zZXF1YXQgZWxlaWZlbmQgbWV0dXMsIHZpdGFlIG1hbGVzdWFkYSBlcm9zIGVsZW1lbnR1bSBzZWQuIEZ1c2NlIHJpc3VzIGZlbGlzLCB2aXZlcnJhIGV0IGRpZ25pc3NpbSBhdCwgbG9ib3J0aXMgbm9uIGVzdC4gTG9yZW0gaXBzdW0gZG9sb3Igc2l0IGFtZXQsIGNvbnNlY3RldHVyIGFkaXBpc2NpbmcgZWxpdC4gTnVsbGFtIHNpdCBhbWV0IGNvbnNlY3RldHVyIGxhY3VzLiBWZXN0aWJ1bHVtIG5lcXVlIGxlY3R1cywgZWdlc3RhcyBub24gY3Vyc3VzIHZpdGFlLCBhbGlxdWFtIGF0IG1hZ25hLiBFdGlhbSBhbGlxdWFtLCBqdXN0byBldCB2YXJpdXMgZWxlaWZlbmQsIGR1aSBsZWN0dXMgZWdlc3RhcyBudW5jLCB2ZWwgbWFsZXN1YWRhIG5pc2wgcHVydXMgbmVjIG1ldHVzLiBJbiBncmF2aWRhIHR1cnBpcyBhIHBoYXJldHJhIGNvbW1vZG8uIERvbmVjIG5vbiB0dXJwaXMgdnVscHV0YXRlLCBmYXVjaWJ1cyBtZXR1cyBhLCBjb25zZWN0ZXR1ciBudW5jLiBNb3JiaSB0b3J0b3IgbmlzaSwgaGVuZHJlcml0IHNlZCBsYW9yZWV0IGVnZXQsIGZlcm1lbnR1bSBldCBqdXN0by4gU3VzcGVuZGlzc2UgcG90ZW50aS48L3A+Ijt9'),
(154, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 5, 1, NULL),
(155, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjE1NTtzOjk6IgAqAF90YWJsZSI7czoxNjoiYnRDb3JlQXJlYUxheW91dCI7czoxMDoiYXJMYXlvdXRJRCI7czoyOiIyMiI7fQ=='),
(156, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 3, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjEyOntzOjM6ImJJRCI7aToxNTY7czo5OiIAKgBfdGFibGUiO3M6MTQ6ImJ0Q29udGVudEltYWdlIjtzOjM6ImZJRCI7aTo2O3M6MTA6ImZPbnN0YXRlSUQiO2k6MDtzOjk6ImNyb3BJbWFnZSI7aTowO3M6ODoibWF4V2lkdGgiO2k6MDtzOjk6Im1heEhlaWdodCI7aTowO3M6MTI6ImV4dGVybmFsTGluayI7czowOiIiO3M6MTU6ImludGVybmFsTGlua0NJRCI7aTowO3M6MTA6ImZpbGVMaW5rSUQiO2k6MDtzOjE5OiJvcGVuTGlua0luTmV3V2luZG93IjtpOjA7czo3OiJhbHRUZXh0IjtzOjA6IiI7fQ=='),
(157, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjE1NztzOjk6IgAqAF90YWJsZSI7czoxNDoiYnRDb250ZW50TG9jYWwiO3M6NzoiY29udGVudCI7czozMTk6IgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHAgY2xhc3M9InRpdGxlLXRoaW4iPkdldCBpbiBUb3VjaDwvcD48cD5TZWQgY3Vyc3VzIGZhY2lsaXNpcyBkaWduaXNzaW0uIEFsaXF1YW0gcmhvbmN1cyBlbmltIGV0IHBlbGxlbnRlc3F1ZSB2YXJpdXMuIE51bGxhIHNvZGFsZXMgbmliaCBsb3JlbSwgc2l0IGFtZXQgaW1wZXJkaWV0IGFyY3UgY29tbW9kbyBzaXQgYW1ldC48YnI+PGJyPjwvcD48cD48YSBjbGFzcz0iYnRuIGJ0bi1zdWNjZXNzIiBocmVmPSJ7Q0NNOkNJRF8yMDF9Ij5Db250YWN0IFVzPC9hPjwvcD4iO30='),
(158, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 8, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjE1ODtzOjk6IgAqAF90YWJsZSI7czoxMToiYnRQYWdlVGl0bGUiO3M6MTQ6InVzZUN1c3RvbVRpdGxlIjtpOjE7czoxNDoidXNlRmlsdGVyVGl0bGUiO2k6MDtzOjE0OiJ1c2VGaWx0ZXJUb3BpYyI7aTowO3M6MTI6InVzZUZpbHRlclRhZyI7aTowO3M6MTM6InVzZUZpbHRlckRhdGUiO2k6MDtzOjk6InRpdGxlVGV4dCI7czoxMjoiV29yayB3aXRoIFVzIjt9'),
(159, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 3, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjEyOntzOjM6ImJJRCI7aToxNTk7czo5OiIAKgBfdGFibGUiO3M6MTQ6ImJ0Q29udGVudEltYWdlIjtzOjM6ImZJRCI7aToxMDtzOjEwOiJmT25zdGF0ZUlEIjtpOjA7czo5OiJjcm9wSW1hZ2UiO2k6MDtzOjg6Im1heFdpZHRoIjtpOjA7czo5OiJtYXhIZWlnaHQiO2k6MDtzOjEyOiJleHRlcm5hbExpbmsiO3M6MDoiIjtzOjE1OiJpbnRlcm5hbExpbmtDSUQiO2k6MDtzOjEwOiJmaWxlTGlua0lEIjtpOjA7czoxOToib3BlbkxpbmtJbk5ld1dpbmRvdyI7aTowO3M6NzoiYWx0VGV4dCI7czowOiIiO30='),
(160, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 2, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjE2MDtzOjk6IgAqAF90YWJsZSI7czoxNDoiYnRDb250ZW50TG9jYWwiO3M6NzoiY29udGVudCI7czozMjoiPGRpdiBzdHlsZT0iaGVpZ2h0OiA1MHB4Ij48L2Rpdj4iO30='),
(161, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjE2MTtzOjk6IgAqAF90YWJsZSI7czoxNjoiYnRDb3JlQXJlYUxheW91dCI7czoxMDoiYXJMYXlvdXRJRCI7czoyOiIyMyI7fQ=='),
(162, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 6, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjc6e3M6MzoiYklEIjtpOjE2MjtzOjk6IgAqAF90YWJsZSI7czo5OiJidEZlYXR1cmUiO3M6NDoiaWNvbiI7czo0OiJob21lIjtzOjU6InRpdGxlIjtzOjEyOiJXZWxjb21lIEhvbWUiO3M6OToicGFyYWdyYXBoIjtzOjEzOToiCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBDdXJhYml0dXIgc2FnaXR0aXMgZWxlbWVudHVtIGZlbGlzIGF0IHNvZGFsZXMuIE51bGxhbSBmZXJtZW50dW0gYXQgdXJuYSBxdWlzIGFjY3Vtc2FuLiI7czoxMjoiZXh0ZXJuYWxMaW5rIjtzOjA6IiI7czoxNToiaW50ZXJuYWxMaW5rQ0lEIjtpOjA7fQ=='),
(163, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 6, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjc6e3M6MzoiYklEIjtpOjE2MztzOjk6IgAqAF90YWJsZSI7czo5OiJidEZlYXR1cmUiO3M6NDoiaWNvbiI7czo0OiJ1c2VyIjtzOjU6InRpdGxlIjtzOjEzOiJHcmVhdCBXb3JrZXJzIjtzOjk6InBhcmFncmFwaCI7czoxMzk6IgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgQ3VyYWJpdHVyIHNhZ2l0dGlzIGVsZW1lbnR1bSBmZWxpcyBhdCBzb2RhbGVzLiBOdWxsYW0gZmVybWVudHVtIGF0IHVybmEgcXVpcyBhY2N1bXNhbi4iO3M6MTI6ImV4dGVybmFsTGluayI7czowOiIiO3M6MTU6ImludGVybmFsTGlua0NJRCI7aTowO30='),
(164, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 6, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjc6e3M6MzoiYklEIjtpOjE2NDtzOjk6IgAqAF90YWJsZSI7czo5OiJidEZlYXR1cmUiO3M6NDoiaWNvbiI7czo0OiJmbGFnIjtzOjU6InRpdGxlIjtzOjE2OiJBbWF6aW5nIExvY2F0aW9uIjtzOjk6InBhcmFncmFwaCI7czoxMzk6IgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgQ3VyYWJpdHVyIHNhZ2l0dGlzIGVsZW1lbnR1bSBmZWxpcyBhdCBzb2RhbGVzLiBOdWxsYW0gZmVybWVudHVtIGF0IHVybmEgcXVpcyBhY2N1bXNhbi4iO3M6MTI6ImV4dGVybmFsTGluayI7czowOiIiO3M6MTU6ImludGVybmFsTGlua0NJRCI7aTowO30='),
(165, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 6, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjc6e3M6MzoiYklEIjtpOjE2NTtzOjk6IgAqAF90YWJsZSI7czo5OiJidEZlYXR1cmUiO3M6NDoiaWNvbiI7czo3OiJjbG9jay1vIjtzOjU6InRpdGxlIjtzOjEzOiJQYWlkIFRpbWUgT2ZmIjtzOjk6InBhcmFncmFwaCI7czoxMzk6IgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgQ3VyYWJpdHVyIHNhZ2l0dGlzIGVsZW1lbnR1bSBmZWxpcyBhdCBzb2RhbGVzLiBOdWxsYW0gZmVybWVudHVtIGF0IHVybmEgcXVpcyBhY2N1bXNhbi4iO3M6MTI6ImV4dGVybmFsTGluayI7czowOiIiO3M6MTU6ImludGVybmFsTGlua0NJRCI7aTowO30='),
(166, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 6, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjc6e3M6MzoiYklEIjtpOjE2NjtzOjk6IgAqAF90YWJsZSI7czo5OiJidEZlYXR1cmUiO3M6NDoiaWNvbiI7czo0OiJzdGFyIjtzOjU6InRpdGxlIjtzOjExOiJObyBNZWV0aW5ncyI7czo5OiJwYXJhZ3JhcGgiO3M6MTM5OiIKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIEN1cmFiaXR1ciBzYWdpdHRpcyBlbGVtZW50dW0gZmVsaXMgYXQgc29kYWxlcy4gTnVsbGFtIGZlcm1lbnR1bSBhdCB1cm5hIHF1aXMgYWNjdW1zYW4uIjtzOjEyOiJleHRlcm5hbExpbmsiO3M6MDoiIjtzOjE1OiJpbnRlcm5hbExpbmtDSUQiO2k6MDt9'),
(167, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 6, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjc6e3M6MzoiYklEIjtpOjE2NztzOjk6IgAqAF90YWJsZSI7czo5OiJidEZlYXR1cmUiO3M6NDoiaWNvbiI7czo0OiJiZWVyIjtzOjU6InRpdGxlIjtzOjExOiJGcmVlIERyaW5rcyI7czo5OiJwYXJhZ3JhcGgiO3M6MTM5OiIKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIEN1cmFiaXR1ciBzYWdpdHRpcyBlbGVtZW50dW0gZmVsaXMgYXQgc29kYWxlcy4gTnVsbGFtIGZlcm1lbnR1bSBhdCB1cm5hIHF1aXMgYWNjdW1zYW4uIjtzOjEyOiJleHRlcm5hbExpbmsiO3M6MDoiIjtzOjE1OiJpbnRlcm5hbExpbmtDSUQiO2k6MDt9'),
(168, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 5, 1, NULL),
(169, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 44, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjE2OTtzOjk6IgAqAF90YWJsZSI7czoxNjoiYnRDb3JlQXJlYUxheW91dCI7czoxMDoiYXJMYXlvdXRJRCI7czoyOiIyNCI7fQ=='),
(170, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjE3MDtzOjk6IgAqAF90YWJsZSI7czoxNDoiYnRDb250ZW50TG9jYWwiO3M6NzoiY29udGVudCI7czo5NzoiCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzPSJ0aXRsZS10aGluIj5PcGVuIFBvc2l0aW9uczwvZGl2PiI7fQ=='),
(171, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 10, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjI3OntzOjM6ImJJRCI7aToxNzE7czo5OiIAKgBfdGFibGUiO3M6MTA6ImJ0UGFnZUxpc3QiO3M6MzoibnVtIjtpOjA7czo3OiJvcmRlckJ5IjtzOjExOiJjaHJvbm9fZGVzYyI7czo5OiJjUGFyZW50SUQiO2k6MjE2O3M6NToiY1RoaXMiO3M6MToiMSI7czoxMToiY1RoaXNQYXJlbnQiO3M6MToiMCI7czoxNjoidXNlQnV0dG9uRm9yTGluayI7czoxOiIxIjtzOjE0OiJidXR0b25MaW5rVGV4dCI7czo5OiJBcHBseSBOb3ciO3M6MTU6ImZpbHRlckJ5UmVsYXRlZCI7czoxOiIwIjtzOjE5OiJmaWx0ZXJCeUN1c3RvbVRvcGljIjtzOjE6IjAiO3M6MTY6ImZpbHRlckRhdGVPcHRpb24iO3M6MDoiIjtzOjMwOiJyZWxhdGVkVG9waWNBdHRyaWJ1dGVLZXlIYW5kbGUiO3M6MDoiIjtzOjI5OiJjdXN0b21Ub3BpY0F0dHJpYnV0ZUtleUhhbmRsZSI7czowOiIiO3M6MjE6ImN1c3RvbVRvcGljVHJlZU5vZGVJRCI7aTowO3M6MTg6ImluY2x1ZGVEZXNjcmlwdGlvbiI7czoxOiIxIjtzOjExOiJpbmNsdWRlRGF0ZSI7czoxOiIwIjtzOjIxOiJpbmNsdWRlQWxsRGVzY2VuZGVudHMiO3M6MToiMCI7czo4OiJwYWdpbmF0ZSI7aTowO3M6MTQ6ImRpc3BsYXlBbGlhc2VzIjtzOjE6IjAiO3M6MjM6ImVuYWJsZUV4dGVybmFsRmlsdGVyaW5nIjtzOjE6IjAiO3M6NDoicHRJRCI7aTo3O3M6NDoicGZJRCI7aTowO3M6MTc6InRydW5jYXRlU3VtbWFyaWVzIjtzOjE6IjAiO3M6MTk6ImRpc3BsYXlGZWF0dXJlZE9ubHkiO3M6MToiMCI7czoxNjoiZGlzcGxheVRodW1ibmFpbCI7czoxOiIwIjtzOjEzOiJ0cnVuY2F0ZUNoYXJzIjtpOjA7fQ=='),
(172, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, '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'),
(173, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 1, 1, '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'),
(174, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 8, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjg6e3M6MzoiYklEIjtpOjE3NDtzOjk6IgAqAF90YWJsZSI7czoxMToiYnRQYWdlVGl0bGUiO3M6MTQ6InVzZUN1c3RvbVRpdGxlIjtpOjA7czoxNDoidXNlRmlsdGVyVGl0bGUiO2k6MDtzOjE0OiJ1c2VGaWx0ZXJUb3BpYyI7aTowO3M6MTI6InVzZUZpbHRlclRhZyI7aTowO3M6MTM6InVzZUZpbHRlckRhdGUiO2k6MDtzOjk6InRpdGxlVGV4dCI7czoyNjoiRnJlcXVlbnRseSBBc2tlZCBRdWVzdGlvbnMiO30='),
(175, '', '[[date_gmt]]', '[[date_gmt]]', NULL, '0', 9, 1, 'TzozMjoiQ29uY3JldGVcQ29yZVxMZWdhY3lcQmxvY2tSZWNvcmQiOjM6e3M6MzoiYklEIjtpOjE3NTtzOjk6IgAqAF90YWJsZSI7czo1OiJidEZhcSI7czoxMDoiYmxvY2tUaXRsZSI7czowOiIiO30=');

-- --------------------------------------------------------

--
-- Table structure for table `BlockTypePermissionBlockTypeAccessList`
--

CREATE TABLE `BlockTypePermissionBlockTypeAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`),
  KEY `peID` (`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `BlockTypePermissionBlockTypeAccessListCustom`
--

CREATE TABLE `BlockTypePermissionBlockTypeAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `btID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`btID`),
  KEY `peID` (`peID`),
  KEY `btID` (`btID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `BlockTypes`
--

CREATE TABLE `BlockTypes` (
  `btIgnorePageThemeGridFrameworkContainer` tinyint(1) NOT NULL,
  `btID` int(11) NOT NULL AUTO_INCREMENT,
  `btHandle` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `btName` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `btDescription` longtext COLLATE utf8_unicode_ci NOT NULL,
  `btCopyWhenPropagate` tinyint(1) NOT NULL,
  `btIncludeAll` tinyint(1) NOT NULL,
  `btIsInternal` tinyint(1) NOT NULL,
  `btSupportsInlineEdit` tinyint(1) NOT NULL,
  `btSupportsInlineAdd` tinyint(1) NOT NULL,
  `btDisplayOrder` int(11) NOT NULL,
  `btInterfaceHeight` int(11) NOT NULL,
  `btInterfaceWidth` int(11) NOT NULL,
  `pkgID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`btID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=49 ;

--
-- Dumping data for table `BlockTypes`
--

INSERT INTO `BlockTypes` VALUES
(0, 1, 'content', 'Content', 'HTML/WYSIWYG Editor Content.', 0, 0, 0, 1, 1, 0, 465, 600, 0),
(1, 2, 'html', 'HTML', 'For adding HTML by hand.', 0, 0, 0, 0, 0, 0, 500, 600, 0),
(0, 3, 'image', 'Image', 'Adds images and onstates from the library to pages.', 0, 0, 0, 0, 0, 0, 550, 400, 0),
(0, 4, 'file', 'File', 'Link to files stored in the asset library.', 0, 0, 0, 0, 0, 0, 320, 300, 0),
(1, 5, 'horizontal_rule', 'Horizontal Rule', 'Adds a thin hairline horizontal divider to the page.', 0, 0, 0, 0, 0, 0, 400, 400, 0),
(0, 6, 'feature', 'Feature', 'Displays an icon, a title, and a short paragraph description.', 0, 0, 0, 0, 0, 0, 520, 400, 0),
(0, 7, 'autonav', 'Auto-Nav', 'Creates navigation trees and sitemaps.', 0, 0, 0, 0, 0, 0, 525, 700, 0),
(0, 8, 'page_title', 'Page Title', 'Displays a Page''s Title', 0, 0, 0, 0, 0, 0, 500, 470, 0),
(0, 9, 'faq', 'FAQ', 'Frequently Asked Questions Block', 0, 0, 0, 0, 0, 0, 465, 600, 0),
(0, 10, 'page_list', 'Page List', 'List pages based on type, area.', 0, 0, 0, 0, 0, 0, 525, 700, 0),
(0, 11, 'next_previous', 'Next & Previous Nav', 'Navigate through sibling pages.', 0, 0, 0, 0, 0, 0, 400, 430, 0),
(0, 12, 'date_navigation', 'Date Navigation', 'Displays a list of months to filter a page list by.', 0, 0, 0, 0, 0, 0, 450, 400, 0),
(0, 13, 'tags', 'Tags', 'List pages based on type, area.', 0, 0, 0, 0, 0, 0, 439, 450, 0),
(0, 14, 'topic_list', 'Topic List', 'Displays a list of your site''s topics, allowing you to click on them to filter a page list.', 0, 0, 0, 0, 0, 0, 400, 400, 0),
(0, 15, 'rss_displayer', 'RSS Displayer', 'Fetch, parse and display the contents of an RSS or Atom feed.', 0, 0, 0, 0, 0, 0, 550, 400, 0),
(0, 16, 'switch_language', 'Switch Language', 'Adds a front-end language switcher to your website.', 0, 0, 0, 0, 0, 0, 150, 500, 0),
(0, 17, 'express_form', 'Form', 'Build simple forms and surveys.', 0, 0, 0, 0, 0, 0, 700, 640, 0),
(0, 18, 'search', 'Search', 'Add a search box to your site.', 0, 0, 0, 0, 0, 0, 420, 400, 0),
(0, 19, 'external_form', 'External Form', 'Include external forms in the filesystem and place them on pages.', 0, 0, 0, 0, 0, 0, 175, 420, 0),
(0, 20, 'express_entry_list', 'Express Entry List', 'Add a searchable Express entry list to a page.', 0, 0, 0, 0, 0, 0, 400, 640, 0),
(0, 21, 'express_entry_detail', 'Express Entry Detail', 'Add an Express entry detail display to a page.', 0, 0, 0, 0, 0, 0, 400, 640, 0),
(0, 22, 'survey', 'Survey', 'Provide a simple survey, along with results in a pie chart format.', 0, 0, 0, 0, 0, 0, 500, 500, 0),
(0, 23, 'core_conversation', 'Conversation', 'Displays conversations on a page.', 1, 0, 0, 0, 0, 0, 400, 450, 0),
(0, 24, 'social_links', 'Social Links', 'Allows users to add social icons to their website', 0, 0, 0, 0, 0, 0, 400, 400, 0),
(0, 25, 'testimonial', 'Testimonial', 'Displays a quote or paragraph next to biographical information and a person''s picture.', 0, 0, 0, 0, 0, 0, 560, 450, 0),
(0, 26, 'share_this_page', 'Share This Page', 'Allows users to share this page with social networks.', 0, 0, 0, 0, 0, 0, 400, 400, 0),
(0, 27, 'calendar', 'Calendar', 'Displays a month view calendar on a page.', 0, 0, 0, 0, 0, 0, 475, 500, 0),
(0, 28, 'event_list', 'Event List', 'Displays a list of events from a calendar.', 0, 0, 0, 0, 0, 0, 340, 500, 0),
(0, 29, 'calendar_event', 'Calendar Event', 'Displays a calendar event on a page.', 0, 0, 0, 0, 0, 0, 400, 550, 0),
(0, 30, 'page_attribute_display', 'Page Attribute Display', 'Displays the value of a page attribute for the current page.', 0, 0, 0, 0, 0, 0, 365, 500, 0),
(1, 31, 'image_slider', 'Image Slider', 'Display your images and captions in an attractive slideshow format.', 0, 0, 0, 0, 0, 0, 550, 600, 0),
(0, 32, 'video', 'Video Player', 'Embeds uploaded video into a web page. Supports WebM, Ogg, and Quicktime/MPEG4 formats.', 0, 0, 0, 0, 0, 0, 440, 450, 0),
(0, 33, 'document_library', 'Document Library', 'Add a searchable document library to a page.', 0, 0, 0, 0, 0, 0, 400, 640, 0),
(0, 34, 'youtube', 'YouTube Video', 'Embeds a YouTube Video in your web page.', 0, 0, 0, 0, 0, 0, 490, 400, 0),
(0, 35, 'google_map', 'Google Map', 'Enter an address and a Google Map of that location will be placed in your page.', 0, 0, 0, 0, 0, 0, 550, 525, 0),
(0, 36, 'desktop_app_status', 'concrete5 Status Messages', 'Displays alerts about your concrete5 site and package updates.', 0, 0, 0, 0, 0, 0, 400, 400, 0),
(0, 37, 'desktop_site_activity', 'Site Activity', 'Displays a graph of recent activity on your site.', 0, 0, 0, 0, 0, 0, 560, 450, 0),
(0, 38, 'desktop_featured_addon', 'Dashboard Featured Add-On', 'Features an add-on from concrete5.org.', 0, 0, 0, 0, 0, 0, 100, 300, 0),
(0, 39, 'desktop_featured_theme', 'Dashboard Featured Theme', 'Features a theme from concrete5.org.', 0, 0, 0, 0, 0, 0, 100, 300, 0),
(0, 40, 'desktop_latest_form', 'Latest Form', 'Shows the latest form submission.', 0, 0, 0, 0, 0, 0, 400, 400, 0),
(0, 41, 'desktop_waiting_for_me', 'Waiting for Me', 'Displays workflow actions waiting for you.', 0, 0, 0, 0, 0, 0, 560, 450, 0),
(0, 42, 'desktop_draft_list', 'Draft List', 'Displays a list of all drafts.', 0, 0, 0, 0, 0, 0, 400, 400, 0),
(0, 43, 'desktop_newsflow_latest', 'Dashboard Newsflow Latest', 'Grabs the latest newsflow data from concrete5.org.', 0, 0, 0, 0, 0, 0, 400, 400, 0),
(0, 44, 'core_area_layout', 'Area Layout', 'Proxy block for area layouts.', 0, 0, 1, 1, 1, 0, 400, 400, 0),
(0, 45, 'core_page_type_composer_control_output', 'Composer Control', 'Proxy block for blocks that need to be output through composer.', 0, 0, 1, 0, 0, 0, 400, 400, 0),
(0, 46, 'core_scrapbook_display', 'Scrapbook Display', 'Proxy block for blocks pasted through the scrapbook.', 0, 0, 1, 0, 0, 0, 400, 400, 0),
(0, 47, 'core_stack_display', 'Stack Display', 'Proxy block for stacks added through the UI.', 0, 0, 1, 0, 0, 0, 400, 400, 0),
(0, 48, 'form', 'Legacy Form', 'Build simple forms and surveys.', 1, 0, 0, 0, 0, 0, 430, 420, 0);

-- --------------------------------------------------------

--
-- Table structure for table `BlockTypeSetBlockTypes`
--

CREATE TABLE `BlockTypeSetBlockTypes` (
  `btID` int(10) unsigned NOT NULL DEFAULT '0',
  `btsID` int(10) unsigned NOT NULL DEFAULT '0',
  `displayOrder` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`btID`,`btsID`),
  KEY `btsID` (`btsID`,`displayOrder`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `BlockTypeSetBlockTypes`
--

INSERT INTO `BlockTypeSetBlockTypes` VALUES
(1, 1, 0),
(2, 1, 1),
(3, 1, 2),
(4, 1, 3),
(5, 1, 4),
(6, 1, 5),
(7, 2, 0),
(8, 2, 1),
(9, 2, 2),
(10, 2, 3),
(11, 2, 4),
(12, 2, 5),
(13, 2, 6),
(14, 2, 7),
(15, 2, 8),
(16, 2, 9),
(17, 3, 0),
(18, 3, 1),
(19, 3, 2),
(20, 4, 0),
(21, 4, 1),
(22, 5, 0),
(23, 5, 1),
(24, 5, 2),
(25, 5, 3),
(26, 5, 4),
(27, 6, 0),
(28, 6, 1),
(29, 6, 2),
(30, 7, 0),
(31, 7, 1),
(32, 7, 2),
(33, 7, 3),
(34, 7, 4),
(35, 7, 5),
(36, 8, 0),
(37, 8, 1),
(38, 8, 2),
(39, 8, 3),
(40, 8, 4),
(41, 8, 5),
(42, 8, 6),
(43, 8, 7);

-- --------------------------------------------------------

--
-- Table structure for table `BlockTypeSets`
--

CREATE TABLE `BlockTypeSets` (
  `btsID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `btsName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `btsHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  `btsDisplayOrder` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`btsID`),
  UNIQUE KEY `btsHandle` (`btsHandle`),
  KEY `btsDisplayOrder` (`btsDisplayOrder`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=9 ;

--
-- Dumping data for table `BlockTypeSets`
--

INSERT INTO `BlockTypeSets` VALUES
(1, 'Basic', 'basic', 0, 0),
(2, 'Navigation', 'navigation', 0, 0),
(3, 'Forms', 'form', 0, 0),
(4, 'Express', 'express', 0, 0),
(5, 'Social Networking', 'social', 0, 0),
(6, 'Calendar & Events', 'calendar', 0, 0),
(7, 'Multimedia', 'multimedia', 0, 0),
(8, 'Desktop', 'core_desktop', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `btCalendar`
--

CREATE TABLE `btCalendar` (
  `bID` int(10) unsigned NOT NULL,
  `caID` int(10) unsigned NOT NULL DEFAULT '0',
  `calendarAttributeKeyHandle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `filterByTopicAttributeKeyID` int(10) unsigned NOT NULL DEFAULT '0',
  `filterByTopicID` int(10) unsigned NOT NULL DEFAULT '0',
  `viewTypes` longtext COLLATE utf8_unicode_ci,
  `viewTypesOrder` longtext COLLATE utf8_unicode_ci,
  `defaultView` longtext COLLATE utf8_unicode_ci,
  `navLinks` int(11) DEFAULT NULL,
  `eventLimit` int(11) DEFAULT NULL,
  `lightboxProperties` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btCalendarEvent`
--

CREATE TABLE `btCalendarEvent` (
  `bID` int(10) unsigned NOT NULL,
  `mode` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'S' COMMENT 'S = Specify, P = Page, R = Request',
  `calendarEventAttributeKeyHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `calendarID` int(10) unsigned NOT NULL DEFAULT '0',
  `eventID` int(10) unsigned NOT NULL DEFAULT '0',
  `displayEventAttributes` longtext COLLATE utf8_unicode_ci,
  `enableLinkToPage` tinyint(1) DEFAULT '0',
  `displayEventName` tinyint(1) DEFAULT '0',
  `displayEventDate` tinyint(1) DEFAULT '0',
  `displayEventDescription` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btContentFile`
--

CREATE TABLE `btContentFile` (
  `bID` int(10) unsigned NOT NULL,
  `fID` int(10) unsigned DEFAULT NULL,
  `fileLinkText` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `filePassword` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `forceDownload` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`bID`),
  KEY `fID` (`fID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btContentImage`
--

CREATE TABLE `btContentImage` (
  `bID` int(10) unsigned NOT NULL,
  `fID` int(10) unsigned DEFAULT '0',
  `fOnstateID` int(10) unsigned DEFAULT '0',
  `cropImage` int(10) unsigned DEFAULT '0',
  `maxWidth` int(10) unsigned DEFAULT '0',
  `maxHeight` int(10) unsigned DEFAULT '0',
  `externalLink` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `internalLinkCID` int(10) unsigned DEFAULT '0',
  `fileLinkID` int(10) unsigned DEFAULT '0',
  `openLinkInNewWindow` tinyint(1) NOT NULL DEFAULT '0',
  `altText` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`bID`),
  KEY `fID` (`fID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `btContentImage`
--

INSERT INTO `btContentImage` VALUES
(123, 6, 0, 0, 0, 0, '', 0, 0, 0, 'Blank Image', 'Blank Image'),
(138, 8, 0, 0, 0, 0, '', 0, 0, 0, '', NULL),
(145, 5, 0, 0, 0, 0, '', 0, 0, 0, '', NULL),
(152, 5, 0, 0, 0, 0, '', 0, 0, 0, '', NULL),
(156, 6, 0, 0, 0, 0, '', 0, 0, 0, '', NULL),
(159, 10, 0, 0, 0, 0, '', 0, 0, 0, '', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `btContentLocal`
--

CREATE TABLE `btContentLocal` (
  `bID` int(10) unsigned NOT NULL,
  `content` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `btContentLocal`
--

INSERT INTO `btContentLocal` VALUES
(32, '\n                                                    <p><a href="{CCM:CID_216}" style="background-color: rgb(255, 255, 255);"><i class="fa fa-arrow-left"></i> Back to Careers</a></p>'),
(33, '<h3>Department</h3>'),
(35, '<h3>Location</h3>'),
(37, '<h3>Job Information</h3>'),
(39, '\n                                                    <br/><br/>'),
(56, '\n                                    <p>1234 SE StreetView</p><p>Suite 301</p><p>Portland, OR 98101</p><p><a href="{CCM:CID_201}">View on Google Maps</a></p>'),
(57, '\n                                    <p>© 2018 Elemental Theme</p>'),
(58, '\n                                    \n                                    <p><a href="{CCM:CID_217}">FAQ / Help</a></p>\n                                    <p><a href="{CCM:CID_196}">Case Studies</a></p>\n                                    <p><a href="{CCM:CID_199}">Blog</a></p>\n                                    <p><a href="{CCM:CID_1}">Another Link</a></p>\n                                    '),
(59, '\n                                    <a href="{CCM:CID_1}" id="footer-site-title">Elemental</a>'),
(63, '\n                                    <a href="{CCM:CID_1}" id="header-site-title">Elemental</a>'),
(70, '\n                                    <p style="text-align: center"><span class="title-caps-bold">Presenting your Business has never been so easy</span></p><p style="text-align: center;">Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing.</p><p style="text-align: center;">Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. </p>'),
(74, '<h5>Latest Blog Post</h5>'),
(75, '<h5>Now Open For Business</h5>'),
(79, '\n                                                    <p>  <span class="title-thin">We specialize in making your concepts a reality.</span>  </p>  <p>    Sed cursus facilisis dignissim. Aliquam rhoncus enim et pellentesque varius. Nulla sodales nibh lorem, sit amet imperdiet arcu commodo sit amet. Mauris sed scelerisque nisl. Ut auctor ipsum tellus, vel viverra massa elementum sit amet.  </p>  <p>    Sed adipiscing tempus sem eu molestie. Aenean laoreet pretium ante vitae ultrices. Aenean eu gravida magna, vel aliquet magna. In auctor convallis gravida.<br>  </p>  <br/>  <p>  <a href="{CCM:CID_201}"><span class="btn btn-success">Contact Us Today</span></a>  </p>'),
(80, '\n                                    <p style="text-align: center"><span class="title-caps">Customizable footer area with accent class.</span></p>'),
(89, '\n                                                    <h3>Awesome Features</h3><p>Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. Sed consequat eleifend metus, vitae malesuada eros elementum sed. </p><h3>Guide Books</h3><p>Fusce risus felis, viverra et dignissim at, lobortis non est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam sit amet consectetur lacus. Vestibulum neque lectus, egestas non cursus vitae, aliquam at magna. Etiam aliquam, justo et varius eleifend, dui lectus egestas nunc, vel malesuada nisl purus nec metus. </p><h3>Admin Accounts</h3><p>Fusce risus felis, viverra et dignissim at, lobortis non est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam sit amet consectetur lacus. Vestibulum neque lectus, egestas non cursus vitae, aliquam at magna. Etiam aliquam, justo et varius eleifend, dui lectus egestas nunc, vel malesuada nisl purus nec metus. </p>'),
(90, '\n                                                    <h3>Support</h3><p>Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. Sed consequat eleifend metus, vitae malesuada eros elementum sed. </p><h3>Additional Options</h3><p>Fusce risus felis, viverra et dignissim at, lobortis non est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam sit amet consectetur lacus. Vestibulum neque lectus, egestas non cursus vitae, aliquam at magna. </p><p>Etiam aliquam, justo et varius eleifend, dui lectus egestas nunc, vel malesuada nisl purus nec metus. In gravida turpis a pharetra commodo. Donec non turpis vulputate, faucibus metus a, consectetur nunc. Morbi tortor nisi, hendrerit sed laoreet eget, fermentum et justo. Suspendisse potenti.</p>'),
(91, '\n                                    <p style="text-align: center"><span class="title-caps">What Clients Are Saying About Us</span></p>'),
(98, '\n                                    <blockquote>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi tempus nibh a laoreet cursus. Phasellus malesuada vulputate bibendum. Ut vitae justo nisi. Sed consectetur vestibulum tortor, in bibendum diam lacinia vitae. Nullam volutpat risus quis orci consectetur adipiscing. In commodo vulputate arcu sit amet ornare. Vivamus ut iaculis velit.</blockquote><p>Pellentesque euismod lacus sed accumsan luctus. Suspendisse urna felis, lacinia vel tempor id, ultricies rutrum nisl. Nunc ultrices nulla et bibendum molestie. Phasellus porttitor sit amet libero vel fermentum. Sed sapien risus, eleifend vel hendrerit eu, porta vel tellus. Duis faucibus odio et magna varius, quis accumsan tellus vestibulum. Nam nunc nulla, convallis at elementum pharetra, adipiscing quis enim. Donec feugiat porttitor dolor, nec porttitor mi auctor eget. Fusce iaculis varius diam non dictum. Fusce elementum a nunc vel tincidunt. Morbi nec est elementum, vehicula odio nec, lobortis lacus. Nulla ultricies vitae nunc ut lacinia. Proin mattis felis sem, eu consectetur arcu varius et. Duis at lectus eu lorem elementum aliquet nec in elit. Vestibulum non metus ac risus adipiscing pellentesque sed sit amet lorem. Donec viverra, metus in varius pulvinar, augue nunc accumsan eros, a pulvinar est elit vitae nulla.</p><p>Duis non leo in enim laoreet pretium. Nullam vitae neque nec libero pharetra tempor at faucibus lectus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed imperdiet convallis arcu. Nam sollicitudin sollicitudin lacus non dictum. Aliquam erat volutpat. Nulla sapien quam, consequat non dui ut, eleifend sodales orci. Praesent quis lorem accumsan, volutpat lectus a, sollicitudin erat. Donec faucibus mi in sapien volutpat, ac auctor lorem mollis. Proin eget turpis non lacus bibendum porta non ac justo. Aliquam aliquam viverra lorem ac rutrum. In et sapien sit amet diam vestibulum cursus ut tristique tellus.</p><p>Ut in purus mi. Etiam ac aliquet ipsum. Pellentesque faucibus diam dui. Morbi a semper orci. Ut nec malesuada urna. Vestibulum aliquet ante ac lacus dictum, sit amet pulvinar leo laoreet. Maecenas ut est commodo, commodo quam nec, dignissim est. Quisque rutrum molestie nunc, sed mollis nulla volutpat et. Donec dignissim ornare augue eu aliquam. Aliquam in tincidunt velit. In at fermentum mauris, ut accumsan nisl. Interdum et malesuada fames ac ante ipsum primis in faucibus.</p><p>Integer ac nulla at nisi sodales ullamcorper id in justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Etiam pharetra elit odio, ac mattis turpis consequat ac. Pellentesque tincidunt sed enim nec auctor. Quisque varius, felis a hendrerit faucibus, nunc lorem varius nibh, vel dignissim velit dolor ut elit. Mauris ut vulputate neque. Donec at est vitae massa egestas fringilla. Praesent a tristique nibh. Nunc blandit dui risus, quis rhoncus nisi consectetur vel.</p>'),
(100, '\n                                    <blockquote>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi tempus nibh a laoreet cursus. Phasellus malesuada vulputate bibendum. Ut vitae justo nisi. Sed consectetur vestibulum tortor, in bibendum diam lacinia vitae. Nullam volutpat risus quis orci consectetur adipiscing. In commodo vulputate arcu sit amet ornare. Vivamus ut iaculis velit.</blockquote><p>Pellentesque euismod lacus sed accumsan luctus. Suspendisse urna felis, lacinia vel tempor id, ultricies rutrum nisl. Nunc ultrices nulla et bibendum molestie. Phasellus porttitor sit amet libero vel fermentum. Sed sapien risus, eleifend vel hendrerit eu, porta vel tellus. Duis faucibus odio et magna varius, quis accumsan tellus vestibulum. Nam nunc nulla, convallis at elementum pharetra, adipiscing quis enim. Donec feugiat porttitor dolor, nec porttitor mi auctor eget. Fusce iaculis varius diam non dictum. Fusce elementum a nunc vel tincidunt. Morbi nec est elementum, vehicula odio nec, lobortis lacus. Nulla ultricies vitae nunc ut lacinia. Proin mattis felis sem, eu consectetur arcu varius et. Duis at lectus eu lorem elementum aliquet nec in elit. Vestibulum non metus ac risus adipiscing pellentesque sed sit amet lorem. Donec viverra, metus in varius pulvinar, augue nunc accumsan eros, a pulvinar est elit vitae nulla.</p><p>Duis non leo in enim laoreet pretium. Nullam vitae neque nec libero pharetra tempor at faucibus lectus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed imperdiet convallis arcu. Nam sollicitudin sollicitudin lacus non dictum. Aliquam erat volutpat. Nulla sapien quam, consequat non dui ut, eleifend sodales orci. Praesent quis lorem accumsan, volutpat lectus a, sollicitudin erat. Donec faucibus mi in sapien volutpat, ac auctor lorem mollis. Proin eget turpis non lacus bibendum porta non ac justo. Aliquam aliquam viverra lorem ac rutrum. In et sapien sit amet diam vestibulum cursus ut tristique tellus.</p><p>Ut in purus mi. Etiam ac aliquet ipsum. Pellentesque faucibus diam dui. Morbi a semper orci. Ut nec malesuada urna. Vestibulum aliquet ante ac lacus dictum, sit amet pulvinar leo laoreet. Maecenas ut est commodo, commodo quam nec, dignissim est. Quisque rutrum molestie nunc, sed mollis nulla volutpat et. Donec dignissim ornare augue eu aliquam. Aliquam in tincidunt velit. In at fermentum mauris, ut accumsan nisl. Interdum et malesuada fames ac ante ipsum primis in faucibus.</p><p>Integer ac nulla at nisi sodales ullamcorper id in justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Etiam pharetra elit odio, ac mattis turpis consequat ac. Pellentesque tincidunt sed enim nec auctor. Quisque varius, felis a hendrerit faucibus, nunc lorem varius nibh, vel dignissim velit dolor ut elit. Mauris ut vulputate neque. Donec at est vitae massa egestas fringilla. Praesent a tristique nibh. Nunc blandit dui risus, quis rhoncus nisi consectetur vel.</p>'),
(102, '\n                                    <blockquote>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi tempus nibh a laoreet cursus. Phasellus malesuada vulputate bibendum. Ut vitae justo nisi. Sed consectetur vestibulum tortor, in bibendum diam lacinia vitae. Nullam volutpat risus quis orci consectetur adipiscing. In commodo vulputate arcu sit amet ornare. Vivamus ut iaculis velit.</blockquote><p>Pellentesque euismod lacus sed accumsan luctus. Suspendisse urna felis, lacinia vel tempor id, ultricies rutrum nisl. Nunc ultrices nulla et bibendum molestie. Phasellus porttitor sit amet libero vel fermentum. Sed sapien risus, eleifend vel hendrerit eu, porta vel tellus. Duis faucibus odio et magna varius, quis accumsan tellus vestibulum. Nam nunc nulla, convallis at elementum pharetra, adipiscing quis enim. Donec feugiat porttitor dolor, nec porttitor mi auctor eget. Fusce iaculis varius diam non dictum. Fusce elementum a nunc vel tincidunt. Morbi nec est elementum, vehicula odio nec, lobortis lacus. Nulla ultricies vitae nunc ut lacinia. Proin mattis felis sem, eu consectetur arcu varius et. Duis at lectus eu lorem elementum aliquet nec in elit. Vestibulum non metus ac risus adipiscing pellentesque sed sit amet lorem. Donec viverra, metus in varius pulvinar, augue nunc accumsan eros, a pulvinar est elit vitae nulla.</p><p>Duis non leo in enim laoreet pretium. Nullam vitae neque nec libero pharetra tempor at faucibus lectus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed imperdiet convallis arcu. Nam sollicitudin sollicitudin lacus non dictum. Aliquam erat volutpat. Nulla sapien quam, consequat non dui ut, eleifend sodales orci. Praesent quis lorem accumsan, volutpat lectus a, sollicitudin erat. Donec faucibus mi in sapien volutpat, ac auctor lorem mollis. Proin eget turpis non lacus bibendum porta non ac justo. Aliquam aliquam viverra lorem ac rutrum. In et sapien sit amet diam vestibulum cursus ut tristique tellus.</p><p>Ut in purus mi. Etiam ac aliquet ipsum. Pellentesque faucibus diam dui. Morbi a semper orci. Ut nec malesuada urna. Vestibulum aliquet ante ac lacus dictum, sit amet pulvinar leo laoreet. Maecenas ut est commodo, commodo quam nec, dignissim est. Quisque rutrum molestie nunc, sed mollis nulla volutpat et. Donec dignissim ornare augue eu aliquam. Aliquam in tincidunt velit. In at fermentum mauris, ut accumsan nisl. Interdum et malesuada fames ac ante ipsum primis in faucibus.</p><p>Integer ac nulla at nisi sodales ullamcorper id in justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Etiam pharetra elit odio, ac mattis turpis consequat ac. Pellentesque tincidunt sed enim nec auctor. Quisque varius, felis a hendrerit faucibus, nunc lorem varius nibh, vel dignissim velit dolor ut elit. Mauris ut vulputate neque. Donec at est vitae massa egestas fringilla. Praesent a tristique nibh. Nunc blandit dui risus, quis rhoncus nisi consectetur vel.</p>'),
(104, '\n                                    <blockquote>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi tempus nibh a laoreet cursus. Phasellus malesuada vulputate bibendum. Ut vitae justo nisi. Sed consectetur vestibulum tortor, in bibendum diam lacinia vitae. Nullam volutpat risus quis orci consectetur adipiscing. In commodo vulputate arcu sit amet ornare. Vivamus ut iaculis velit.</blockquote><p>Pellentesque euismod lacus sed accumsan luctus. Suspendisse urna felis, lacinia vel tempor id, ultricies rutrum nisl. Nunc ultrices nulla et bibendum molestie. Phasellus porttitor sit amet libero vel fermentum. Sed sapien risus, eleifend vel hendrerit eu, porta vel tellus. Duis faucibus odio et magna varius, quis accumsan tellus vestibulum. Nam nunc nulla, convallis at elementum pharetra, adipiscing quis enim. Donec feugiat porttitor dolor, nec porttitor mi auctor eget. Fusce iaculis varius diam non dictum. Fusce elementum a nunc vel tincidunt. Morbi nec est elementum, vehicula odio nec, lobortis lacus. Nulla ultricies vitae nunc ut lacinia. Proin mattis felis sem, eu consectetur arcu varius et. Duis at lectus eu lorem elementum aliquet nec in elit. Vestibulum non metus ac risus adipiscing pellentesque sed sit amet lorem. Donec viverra, metus in varius pulvinar, augue nunc accumsan eros, a pulvinar est elit vitae nulla.</p><p>Duis non leo in enim laoreet pretium. Nullam vitae neque nec libero pharetra tempor at faucibus lectus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed imperdiet convallis arcu. Nam sollicitudin sollicitudin lacus non dictum. Aliquam erat volutpat. Nulla sapien quam, consequat non dui ut, eleifend sodales orci. Praesent quis lorem accumsan, volutpat lectus a, sollicitudin erat. Donec faucibus mi in sapien volutpat, ac auctor lorem mollis. Proin eget turpis non lacus bibendum porta non ac justo. Aliquam aliquam viverra lorem ac rutrum. In et sapien sit amet diam vestibulum cursus ut tristique tellus.</p><p>Ut in purus mi. Etiam ac aliquet ipsum. Pellentesque faucibus diam dui. Morbi a semper orci. Ut nec malesuada urna. Vestibulum aliquet ante ac lacus dictum, sit amet pulvinar leo laoreet. Maecenas ut est commodo, commodo quam nec, dignissim est. Quisque rutrum molestie nunc, sed mollis nulla volutpat et. Donec dignissim ornare augue eu aliquam. Aliquam in tincidunt velit. In at fermentum mauris, ut accumsan nisl. Interdum et malesuada fames ac ante ipsum primis in faucibus.</p><p>Integer ac nulla at nisi sodales ullamcorper id in justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Etiam pharetra elit odio, ac mattis turpis consequat ac. Pellentesque tincidunt sed enim nec auctor. Quisque varius, felis a hendrerit faucibus, nunc lorem varius nibh, vel dignissim velit dolor ut elit. Mauris ut vulputate neque. Donec at est vitae massa egestas fringilla. Praesent a tristique nibh. Nunc blandit dui risus, quis rhoncus nisi consectetur vel.</p>'),
(106, '\n                                    <blockquote>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi tempus nibh a laoreet cursus. Phasellus malesuada vulputate bibendum. Ut vitae justo nisi. Sed consectetur vestibulum tortor, in bibendum diam lacinia vitae. Nullam volutpat risus quis orci consectetur adipiscing. In commodo vulputate arcu sit amet ornare. Vivamus ut iaculis velit.</blockquote><p>Pellentesque euismod lacus sed accumsan luctus. Suspendisse urna felis, lacinia vel tempor id, ultricies rutrum nisl. Nunc ultrices nulla et bibendum molestie. Phasellus porttitor sit amet libero vel fermentum. Sed sapien risus, eleifend vel hendrerit eu, porta vel tellus. Duis faucibus odio et magna varius, quis accumsan tellus vestibulum. Nam nunc nulla, convallis at elementum pharetra, adipiscing quis enim. Donec feugiat porttitor dolor, nec porttitor mi auctor eget. Fusce iaculis varius diam non dictum. Fusce elementum a nunc vel tincidunt. Morbi nec est elementum, vehicula odio nec, lobortis lacus. Nulla ultricies vitae nunc ut lacinia. Proin mattis felis sem, eu consectetur arcu varius et. Duis at lectus eu lorem elementum aliquet nec in elit. Vestibulum non metus ac risus adipiscing pellentesque sed sit amet lorem. Donec viverra, metus in varius pulvinar, augue nunc accumsan eros, a pulvinar est elit vitae nulla.</p><p>Duis non leo in enim laoreet pretium. Nullam vitae neque nec libero pharetra tempor at faucibus lectus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed imperdiet convallis arcu. Nam sollicitudin sollicitudin lacus non dictum. Aliquam erat volutpat. Nulla sapien quam, consequat non dui ut, eleifend sodales orci. Praesent quis lorem accumsan, volutpat lectus a, sollicitudin erat. Donec faucibus mi in sapien volutpat, ac auctor lorem mollis. Proin eget turpis non lacus bibendum porta non ac justo. Aliquam aliquam viverra lorem ac rutrum. In et sapien sit amet diam vestibulum cursus ut tristique tellus.</p><p>Ut in purus mi. Etiam ac aliquet ipsum. Pellentesque faucibus diam dui. Morbi a semper orci. Ut nec malesuada urna. Vestibulum aliquet ante ac lacus dictum, sit amet pulvinar leo laoreet. Maecenas ut est commodo, commodo quam nec, dignissim est. Quisque rutrum molestie nunc, sed mollis nulla volutpat et. Donec dignissim ornare augue eu aliquam. Aliquam in tincidunt velit. In at fermentum mauris, ut accumsan nisl. Interdum et malesuada fames ac ante ipsum primis in faucibus.</p><p>Integer ac nulla at nisi sodales ullamcorper id in justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Etiam pharetra elit odio, ac mattis turpis consequat ac. Pellentesque tincidunt sed enim nec auctor. Quisque varius, felis a hendrerit faucibus, nunc lorem varius nibh, vel dignissim velit dolor ut elit. Mauris ut vulputate neque. Donec at est vitae massa egestas fringilla. Praesent a tristique nibh. Nunc blandit dui risus, quis rhoncus nisi consectetur vel.</p>'),
(108, '\n                                    <blockquote>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi tempus nibh a laoreet cursus. Phasellus malesuada vulputate bibendum. Ut vitae justo nisi. Sed consectetur vestibulum tortor, in bibendum diam lacinia vitae. Nullam volutpat risus quis orci consectetur adipiscing. In commodo vulputate arcu sit amet ornare. Vivamus ut iaculis velit.</blockquote><p>Pellentesque euismod lacus sed accumsan luctus. Suspendisse urna felis, lacinia vel tempor id, ultricies rutrum nisl. Nunc ultrices nulla et bibendum molestie. Phasellus porttitor sit amet libero vel fermentum. Sed sapien risus, eleifend vel hendrerit eu, porta vel tellus. Duis faucibus odio et magna varius, quis accumsan tellus vestibulum. Nam nunc nulla, convallis at elementum pharetra, adipiscing quis enim. Donec feugiat porttitor dolor, nec porttitor mi auctor eget. Fusce iaculis varius diam non dictum. Fusce elementum a nunc vel tincidunt. Morbi nec est elementum, vehicula odio nec, lobortis lacus. Nulla ultricies vitae nunc ut lacinia. Proin mattis felis sem, eu consectetur arcu varius et. Duis at lectus eu lorem elementum aliquet nec in elit. Vestibulum non metus ac risus adipiscing pellentesque sed sit amet lorem. Donec viverra, metus in varius pulvinar, augue nunc accumsan eros, a pulvinar est elit vitae nulla.</p><p>Duis non leo in enim laoreet pretium. Nullam vitae neque nec libero pharetra tempor at faucibus lectus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed imperdiet convallis arcu. Nam sollicitudin sollicitudin lacus non dictum. Aliquam erat volutpat. Nulla sapien quam, consequat non dui ut, eleifend sodales orci. Praesent quis lorem accumsan, volutpat lectus a, sollicitudin erat. Donec faucibus mi in sapien volutpat, ac auctor lorem mollis. Proin eget turpis non lacus bibendum porta non ac justo. Aliquam aliquam viverra lorem ac rutrum. In et sapien sit amet diam vestibulum cursus ut tristique tellus.</p><p>Ut in purus mi. Etiam ac aliquet ipsum. Pellentesque faucibus diam dui. Morbi a semper orci. Ut nec malesuada urna. Vestibulum aliquet ante ac lacus dictum, sit amet pulvinar leo laoreet. Maecenas ut est commodo, commodo quam nec, dignissim est. Quisque rutrum molestie nunc, sed mollis nulla volutpat et. Donec dignissim ornare augue eu aliquam. Aliquam in tincidunt velit. In at fermentum mauris, ut accumsan nisl. Interdum et malesuada fames ac ante ipsum primis in faucibus.</p><p>Integer ac nulla at nisi sodales ullamcorper id in justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Etiam pharetra elit odio, ac mattis turpis consequat ac. Pellentesque tincidunt sed enim nec auctor. Quisque varius, felis a hendrerit faucibus, nunc lorem varius nibh, vel dignissim velit dolor ut elit. Mauris ut vulputate neque. Donec at est vitae massa egestas fringilla. Praesent a tristique nibh. Nunc blandit dui risus, quis rhoncus nisi consectetur vel.</p>'),
(124, '\n                                                    <p class="title-thin">Get in Touch</p><p>Sed cursus facilisis dignissim. Aliquam rhoncus enim et pellentesque varius. Nulla sodales nibh lorem, sit amet imperdiet arcu commodo sit amet.<br><br></p><p><a class="btn btn-success" href="{CCM:CID_201}">Contact Us</a></p>'),
(126, '\n                                    <blockquote>Fusce volutpat sodales mauris quis dapibus. Maecenas convallis, libero eu ultrices interdum, leo mauris commodo diam, sed cursus sapien ligula nec leo.</blockquote><p>Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. Sed consequat eleifend metus, vitae malesuada eros elementum sed. Fusce risus felis, viverra et dignissim at, lobortis non est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam sit amet consectetur lacus. Vestibulum neque lectus, egestas non cursus vitae, aliquam at magna. Etiam aliquam, justo et varius eleifend, dui lectus egestas nunc, vel malesuada nisl purus nec metus. In gravida turpis a pharetra commodo. Donec non turpis vulputate, faucibus metus a, consectetur nunc. Morbi tortor nisi, hendrerit sed laoreet eget, fermentum et justo. Suspendisse potenti.</p><p><a href="{CCM:FID_DL_3}" data-concrete5-link-lightbox="image"><concrete-picture fid="3" /></a></p><h2>Heading 2</h2><p>Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. Sed consequat eleifend metus, vitae malesuada eros elementum sed. Fusce risus felis, viverra et dignissim at, lobortis non est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam sit amet consectetur lacus. Vestibulum neque lectus, egestas non cursus vitae, aliquam at magna. Etiam aliquam, justo et varius eleifend, dui lectus egestas nunc, vel malesuada nisl purus nec metus. In gravida turpis a pharetra commodo. Donec non turpis vulputate, faucibus metus a, consectetur nunc. Morbi tortor nisi, hendrerit sed laoreet eget, fermentum et justo. Suspendisse potenti.</p><h3>Heading 3</h3><p>Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. Quisque dignissim neque a ipsum sodales, mattis aliquam ante dictum. Vestibulum elementum pellentesque tortor ac congue. Mauris vel nibh id metus tincidunt eleifend. In interdum gravida ligula, at venenatis odio fermentum at. Donec dapibus enim lectus, quis venenatis tellus volutpat in. Nullam in velit tortor.</p><h3>Heading 3</h3><p>Donec blandit lectus nec neque ullamcorper rhoncus. Sed adipiscing tempus sem eu molestie. Aenean laoreet pretium ante vitae ultrices. Aenean eu gravida magna, vel aliquet magna. In auctor convallis gravida. Phasellus est erat, adipiscing nec lobortis quis, eleifend at sem. Curabitur fringilla viverra dolor, in rutrum ipsum rutrum sit amet. Vestibulum feugiat porttitor ipsum vel condimentum. Suspendisse at tempus libero. Sed eu tempor enim. Etiam convallis eleifend rutrum. Donec porta diam quis tellus feugiat dignissim. Cras posuere, massa eget laoreet laoreet, urna libero lobortis dolor, sed consequat elit urna eget massa. Donec aliquet pellentesque consectetur.</p>'),
(128, '\n                                    <p>Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. Sed consequat eleifend metus, vitae malesuada eros elementum sed. Fusce risus felis, viverra et dignissim at, lobortis non est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. </p><p><span class="title-thin">CMS To the Rescue!</span></p><p>Nullam sit amet consectetur lacus. Vestibulum neque lectus, egestas non cursus vitae, aliquam at magna. Etiam aliquam, justo et varius eleifend, dui lectus egestas nunc, vel malesuada nisl purus nec metus. In gravida turpis a pharetra commodo. Donec non turpis vulputate, faucibus metus a, consectetur nunc. Morbi tortor nisi, hendrerit sed laoreet eget, fermentum et justo. Suspendisse potenti.</p><p><a href="http://www.concrete5.org">Learn more at concrete5.org </a><br></p>'),
(130, '\n                                    <p>Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. Sed consequat eleifend metus, vitae malesuada eros elementum sed. Fusce risus felis, viverra et dignissim at, lobortis non est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam sit amet consectetur lacus. Vestibulum neque lectus, egestas non cursus vitae, aliquam at magna. Etiam aliquam, justo et varius eleifend, dui lectus egestas nunc, vel malesuada nisl purus nec metus. In gravida turpis a pharetra commodo. Donec non turpis vulputate, faucibus metus a, consectetur nunc. Morbi tortor nisi, hendrerit sed laoreet eget, fermentum et justo. Suspendisse potenti.</p><p><span class="title-caps-bold">Heading 3</span></p><p>Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. Quisque dignissim neque a ipsum sodales, mattis aliquam ante dictum. Vestibulum elementum pellentesque tortor ac congue. Mauris vel nibh id metus tincidunt eleifend. In interdum gravida ligula, at venenatis odio fermentum at. Donec dapibus enim lectus, quis venenatis tellus volutpat in. Nullam in velit tortor.</p><p><a href="{CCM:FID_DL_1}" data-concrete5-link-lightbox="image"><concrete-picture fid="1" /></a></p><p><span class="image-caption">Look at my beautiful image. Don''t you to look more?</span></p><p>Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. Quisque dignissim neque a ipsum sodales, mattis aliquam ante dictum. Vestibulum elementum pellentesque tortor ac congue. Mauris vel nibh id metus tincidunt eleifend. In interdum gravida ligula, at venenatis odio fermentum at. Donec dapibus enim lectus, quis venenatis tellus volutpat in. Nullam in velit tortor.</p>'),
(135, '\n                                                    <h5>Headquarters</h5><p>1234 SE Street View<br>Suite 301<br>Portland, OR 98101</p><h5>HOURS</h5><p> <strong>M-F</strong>:  10 AM - 7 PM<br><strong>Sat</strong>: Noon - Midnight<br><strong>Sun</strong>: Closed</p>'),
(139, '\n                                                    <h2>Choosing Us</h2><p>Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. Quisque dignissim neque a ipsum sodales, mattis aliquam ante dictum. Vestibulum elementum pellentesque tortor ac congue. Mauris vel nibh id metus tincidunt eleifend. In interdum gravida ligula, at venenatis odio fermentum at. Donec dapibus enim lectus, quis venenatis tellus volutpat in. Nullam in velit tortor.</p>'),
(140, '<h5>We would love to hear from you!</h5>'),
(142, '<p>This is my empty content block on my blank page.</p>'),
(146, '\n                                                    <blockquote>Fusce volutpat sodales mauris quis dapibus. Maecenas convallis, libero eu ultrices interdum.</blockquote>'),
(147, '\n                                                    <p>Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. </p><p><a href="http://www.yahoo.com">Quisque dignissim</a> neque a ipsum sodales, mattis aliquam ante dictum. Vestibulum elementum pellentesque tortor ac congue. Mauris vel nibh id metus tincidunt eleifend.</p>'),
(150, '\n                                                    <h1>Heading 1</h1><h2>Heading 2</h2><h3>Heading 3</h3><h4>Heading 4</h4><h5>Heading 5</h5><h6>Heading 6</h6>'),
(151, '\n                                                    <p>Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. Sed consequat eleifend metus, vitae malesuada eros elementum sed. Fusce risus felis, viverra et dignissim at, lobortis non est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam sit amet consectetur lacus. Vestibulum neque lectus, egestas non cursus vitae, aliquam at magna. Etiam aliquam, justo et varius eleifend, dui lectus egestas nunc, vel malesuada nisl purus nec metus. In gravida turpis a pharetra commodo. Donec non turpis vulputate, faucibus metus a, consectetur nunc. Morbi tortor nisi, hendrerit sed laoreet eget, fermentum et justo. Suspendisse potenti.<br><br><br></p>'),
(153, '\n                                                    <p><br><br>Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. Sed consequat eleifend metus, vitae malesuada eros elementum sed. Fusce risus felis, viverra et dignissim at, lobortis non est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam sit amet consectetur lacus. Vestibulum neque lectus, egestas non cursus vitae, aliquam at magna. Etiam aliquam, justo et varius eleifend, dui lectus egestas nunc, vel malesuada nisl purus nec metus. In gravida turpis a pharetra commodo. Donec non turpis vulputate, faucibus metus a, consectetur nunc. Morbi tortor nisi, hendrerit sed laoreet eget, fermentum et justo. Suspendisse potenti.</p>'),
(157, '\n                                                    <p class="title-thin">Get in Touch</p><p>Sed cursus facilisis dignissim. Aliquam rhoncus enim et pellentesque varius. Nulla sodales nibh lorem, sit amet imperdiet arcu commodo sit amet.<br><br></p><p><a class="btn btn-success" href="{CCM:CID_201}">Contact Us</a></p>'),
(160, '<div style="height: 50px"></div>'),
(170, '\n                                                    <div class="title-thin">Open Positions</div>'),
(172, '\n                                    <p>Quisque accumsan leo sit amet neque pretium consectetur. Sed blandit nulla at justo volutpat rhoncus. Sed risus orci, luctus sit amet fringilla faucibus, congue nec dui. Phasellus mattis lobortis magna sed dapibus. Donec sagittis nunc sed accumsan eleifend. Ut porttitor sapien eu nisl volutpat, vitae interdum est mollis. Sed laoreet sit amet elit in eleifend. Sed a tincidunt velit, nec posuere urna. In eget metus non est varius viverra. Quisque accumsan odio sem, in consequat nunc lobortis ac.</p><p>Cras dignissim nulla ut euismod adipiscing. Mauris non eros sem. Cras at lacinia nulla. Maecenas nec magna arcu. Aenean iaculis, augue sed pretium semper, odio tellus volutpat risus, quis consectetur nibh mauris ut odio. Integer convallis, augue a accumsan condimentum, sem nisl congue lorem, consectetur lacinia neque tortor eu neque. Aenean convallis arcu vitae enim dignissim vestibulum. Phasellus tincidunt dolor id enim gravida ullamcorper. Nullam ut lorem auctor, congue quam non, auctor arcu. Morbi ac aliquam ipsum, at aliquet ligula.</p><p>Cras adipiscing tellus non nulla suscipit congue. Pellentesque id neque euismod, elementum augue vel, volutpat turpis. Pellentesque sit amet tortor non lorem hendrerit pellentesque ac in nisi. Sed aliquet tincidunt arcu, eu lacinia lorem fringilla id. Integer ut ornare orci. Donec scelerisque vulputate est a condimentum. Morbi tellus sapien, vehicula vel ipsum non, luctus ullamcorper mi. Phasellus felis tortor, egestas quis felis sit amet, malesuada auctor nibh. Sed mollis mi sit amet tristique scelerisque. Cras elementum mauris urna, ullamcorper consectetur orci vehicula ut.</p>'),
(173, '\n                                    <p>Quisque accumsan leo sit amet neque pretium consectetur. Sed blandit nulla at justo volutpat rhoncus. Sed risus orci, luctus sit amet fringilla faucibus, congue nec dui. Phasellus mattis lobortis magna sed dapibus. Donec sagittis nunc sed accumsan eleifend. Ut porttitor sapien eu nisl volutpat, vitae interdum est mollis. Sed laoreet sit amet elit in eleifend. Sed a tincidunt velit, nec posuere urna. In eget metus non est varius viverra. Quisque accumsan odio sem, in consequat nunc lobortis ac.</p><p>Cras dignissim nulla ut euismod adipiscing. Mauris non eros sem. Cras at lacinia nulla. Maecenas nec magna arcu. Aenean iaculis, augue sed pretium semper, odio tellus volutpat risus, quis consectetur nibh mauris ut odio. Integer convallis, augue a accumsan condimentum, sem nisl congue lorem, consectetur lacinia neque tortor eu neque. Aenean convallis arcu vitae enim dignissim vestibulum. Phasellus tincidunt dolor id enim gravida ullamcorper. Nullam ut lorem auctor, congue quam non, auctor arcu. Morbi ac aliquam ipsum, at aliquet ligula.</p><p>Cras adipiscing tellus non nulla suscipit congue. Pellentesque id neque euismod, elementum augue vel, volutpat turpis. Pellentesque sit amet tortor non lorem hendrerit pellentesque ac in nisi. Sed aliquet tincidunt arcu, eu lacinia lorem fringilla id. Integer ut ornare orci. Donec scelerisque vulputate est a condimentum. Morbi tellus sapien, vehicula vel ipsum non, luctus ullamcorper mi. Phasellus felis tortor, egestas quis felis sit amet, malesuada auctor nibh. Sed mollis mi sit amet tristique scelerisque. Cras elementum mauris urna, ullamcorper consectetur orci vehicula ut.</p>');

-- --------------------------------------------------------

--
-- Table structure for table `btCoreAreaLayout`
--

CREATE TABLE `btCoreAreaLayout` (
  `bID` int(10) unsigned NOT NULL DEFAULT '0',
  `arLayoutID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`bID`),
  KEY `arLayoutID` (`arLayoutID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `btCoreAreaLayout`
--

INSERT INTO `btCoreAreaLayout` VALUES
(2, 1),
(6, 2),
(9, 3),
(14, 4),
(16, 5),
(18, 6),
(20, 7),
(49, 8),
(65, 9),
(73, 10),
(76, 11),
(82, 12),
(88, 13),
(92, 14),
(110, 15),
(114, 16),
(122, 17),
(133, 18),
(137, 19),
(144, 20),
(149, 21),
(155, 22),
(161, 23),
(169, 24);

-- --------------------------------------------------------

--
-- Table structure for table `btCoreConversation`
--

CREATE TABLE `btCoreConversation` (
  `bID` int(10) unsigned NOT NULL,
  `cnvID` int(11) DEFAULT NULL,
  `enablePosting` int(11) DEFAULT '1',
  `paginate` tinyint(1) NOT NULL DEFAULT '1',
  `itemsPerPage` smallint(5) unsigned NOT NULL DEFAULT '50',
  `displayMode` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'threaded',
  `orderBy` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'date_desc',
  `enableOrdering` tinyint(1) NOT NULL DEFAULT '1',
  `enableCommentRating` tinyint(1) NOT NULL DEFAULT '1',
  `enableTopCommentReviews` tinyint(1) NOT NULL DEFAULT '0',
  `displaySocialLinks` tinyint(1) NOT NULL DEFAULT '1',
  `reviewAggregateAttributeKey` int(11) DEFAULT NULL,
  `displayPostingForm` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'top',
  `addMessageLabel` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dateFormat` varchar(255) COLLATE utf8_unicode_ci DEFAULT 'default',
  `customDateFormat` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`bID`),
  KEY `cnvID` (`cnvID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `btCoreConversation`
--

INSERT INTO `btCoreConversation` VALUES
(29, 1, 1, 1, 50, 'threaded', 'date_asc', 0, 1, 0, 0, NULL, 'top', 'Add Message', 'default', ''),
(125, 2, 1, 1, 50, 'threaded', 'date_asc', 0, 1, 0, 0, NULL, 'top', 'Add Message', 'default', ''),
(127, 3, 1, 1, 50, 'threaded', 'date_asc', 0, 1, 0, 0, NULL, 'top', 'Add Message', 'default', ''),
(129, 4, 1, 1, 50, 'threaded', 'date_asc', 0, 1, 0, 0, NULL, 'top', 'Add Message', 'default', '');

-- --------------------------------------------------------

--
-- Table structure for table `btCorePageTypeComposerControlOutput`
--

CREATE TABLE `btCorePageTypeComposerControlOutput` (
  `bID` int(10) unsigned NOT NULL,
  `ptComposerOutputControlID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`bID`),
  KEY `ptComposerOutputControlID` (`ptComposerOutputControlID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `btCorePageTypeComposerControlOutput`
--

INSERT INTO `btCorePageTypeComposerControlOutput` VALUES
(23, 1),
(38, 2),
(41, 3),
(45, 4);

-- --------------------------------------------------------

--
-- Table structure for table `btCoreScrapbookDisplay`
--

CREATE TABLE `btCoreScrapbookDisplay` (
  `bID` int(10) unsigned NOT NULL,
  `bOriginalID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`bID`),
  KEY `bOriginalID` (`bOriginalID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btCoreStackDisplay`
--

CREATE TABLE `btCoreStackDisplay` (
  `bID` int(10) unsigned NOT NULL,
  `stID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`bID`),
  KEY `stID` (`stID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btDateNavigation`
--

CREATE TABLE `btDateNavigation` (
  `bID` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `filterByParent` tinyint(1) DEFAULT '0',
  `redirectToResults` tinyint(1) DEFAULT '0',
  `cParentID` int(10) unsigned NOT NULL DEFAULT '0',
  `cTargetID` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'this field is where the links will direct you',
  `ptID` smallint(5) unsigned DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `btDateNavigation`
--

INSERT INTO `btDateNavigation` VALUES
(52, 'Archives', 1, 0, 199, 0, 6);

-- --------------------------------------------------------

--
-- Table structure for table `btDesktopDraftList`
--

CREATE TABLE `btDesktopDraftList` (
  `bID` int(10) unsigned NOT NULL,
  `draftsPerPage` int(11) DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `btDesktopDraftList`
--

INSERT INTO `btDesktopDraftList` VALUES
(17, 10),
(21, 10);

-- --------------------------------------------------------

--
-- Table structure for table `btDesktopNewsflowLatest`
--

CREATE TABLE `btDesktopNewsflowLatest` (
  `bID` int(10) unsigned NOT NULL,
  `slot` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `btDesktopNewsflowLatest`
--

INSERT INTO `btDesktopNewsflowLatest` VALUES
(10, 'A'),
(11, 'B'),
(12, 'C');

-- --------------------------------------------------------

--
-- Table structure for table `btDesktopSiteActivity`
--

CREATE TABLE `btDesktopSiteActivity` (
  `bID` int(10) unsigned NOT NULL,
  `types` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:json_array)',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `btDesktopSiteActivity`
--

INSERT INTO `btDesktopSiteActivity` VALUES
(5, '["form_submissions","survey_results","signups","conversation_messages","workflow"]');

-- --------------------------------------------------------

--
-- Table structure for table `btDocumentLibrary`
--

CREATE TABLE `btDocumentLibrary` (
  `bID` int(10) unsigned NOT NULL,
  `setIds` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `folderID` int(11) NOT NULL DEFAULT '0',
  `setMode` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `onlyCurrentUser` int(11) DEFAULT '0',
  `tags` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `viewProperties` longtext COLLATE utf8_unicode_ci,
  `expandableProperties` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `searchProperties` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `orderBy` varchar(64) COLLATE utf8_unicode_ci DEFAULT 'title',
  `displayLimit` int(11) DEFAULT '20',
  `displayOrderDesc` tinyint(1) NOT NULL DEFAULT '0',
  `addFilesToSetID` int(10) unsigned NOT NULL DEFAULT '0',
  `maxThumbWidth` int(11) DEFAULT '100',
  `maxThumbHeight` int(11) DEFAULT '150',
  `enableSearch` int(11) DEFAULT '0',
  `heightMode` varchar(32) COLLATE utf8_unicode_ci DEFAULT 'auto',
  `downloadFileMethod` varchar(32) COLLATE utf8_unicode_ci DEFAULT 'force',
  `fixedHeightSize` int(11) DEFAULT '0',
  `headerBackgroundColor` varchar(32) COLLATE utf8_unicode_ci DEFAULT '',
  `headerBackgroundColorActiveSort` varchar(32) COLLATE utf8_unicode_ci DEFAULT '',
  `headerTextColor` varchar(32) COLLATE utf8_unicode_ci DEFAULT '',
  `allowFileUploading` int(11) DEFAULT '0',
  `allowInPageFileManagement` int(11) DEFAULT '0',
  `tableName` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `tableDescription` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `tableStriped` tinyint(1) DEFAULT '0',
  `rowBackgroundColorAlternate` varchar(32) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btEventList`
--

CREATE TABLE `btEventList` (
  `bID` int(10) unsigned NOT NULL,
  `caID` text COLLATE utf8_unicode_ci NOT NULL,
  `calendarAttributeKeyHandle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `totalToRetrieve` smallint(5) unsigned NOT NULL DEFAULT '10',
  `totalPerPage` smallint(5) unsigned NOT NULL DEFAULT '10',
  `filterByTopicAttributeKeyID` int(10) unsigned NOT NULL DEFAULT '0',
  `filterByTopicID` int(10) unsigned NOT NULL DEFAULT '0',
  `filterByPageTopicAttributeKeyHandle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `filterByFeatured` tinyint(1) NOT NULL DEFAULT '0',
  `eventListTitle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `linkToPage` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btExpressEntryDetail`
--

CREATE TABLE `btExpressEntryDetail` (
  `bID` int(10) unsigned NOT NULL,
  `exEntityID` char(36) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `exSpecificEntryID` int(10) unsigned DEFAULT NULL,
  `exEntryAttributeKeyHandle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `exFormID` char(36) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `entryMode` varchar(1) COLLATE utf8_unicode_ci DEFAULT 'S',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btExpressEntryList`
--

CREATE TABLE `btExpressEntryList` (
  `bID` int(10) unsigned NOT NULL,
  `exEntityID` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `detailPage` int(10) unsigned NOT NULL DEFAULT '0',
  `linkedProperties` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `searchProperties` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `searchAssociations` longtext COLLATE utf8_unicode_ci,
  `columns` longtext COLLATE utf8_unicode_ci,
  `filterFields` longtext COLLATE utf8_unicode_ci,
  `displayLimit` int(11) DEFAULT '20',
  `enableSearch` int(11) DEFAULT '0',
  `enableKeywordSearch` int(11) DEFAULT '0',
  `headerBackgroundColor` varchar(32) COLLATE utf8_unicode_ci DEFAULT '',
  `headerBackgroundColorActiveSort` varchar(32) COLLATE utf8_unicode_ci DEFAULT '',
  `headerTextColor` varchar(32) COLLATE utf8_unicode_ci DEFAULT '',
  `tableName` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `tableDescription` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `tableStriped` tinyint(1) DEFAULT '0',
  `rowBackgroundColorAlternate` varchar(32) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btExpressForm`
--

CREATE TABLE `btExpressForm` (
  `bID` int(10) unsigned NOT NULL,
  `exFormID` char(36) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `submitLabel` varchar(255) COLLATE utf8_unicode_ci DEFAULT 'Submit',
  `thankyouMsg` text COLLATE utf8_unicode_ci,
  `notifyMeOnSubmission` tinyint(1) NOT NULL DEFAULT '0',
  `recipientEmail` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `displayCaptcha` int(11) DEFAULT '1',
  `storeFormSubmission` tinyint(1) DEFAULT '1',
  `redirectCID` int(11) DEFAULT '0',
  `replyToEmailControlID` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `addFilesToSet` int(11) DEFAULT '0',
  `addFilesToFolder` int(11) DEFAULT '0',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `btExpressForm`
--

INSERT INTO `btExpressForm` VALUES
(141, '881b6bde-220f-4482-b8f9-ace40b5d169b', 'Submit', 'Thanks!', 0, '', 0, 1, 0, '02181ae2-634d-11e6-a245-62e65b165d8e\n                                                ', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `btExternalForm`
--

CREATE TABLE `btExternalForm` (
  `bID` int(10) unsigned NOT NULL,
  `filename` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btFaq`
--

CREATE TABLE `btFaq` (
  `bID` int(10) unsigned NOT NULL,
  `blockTitle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `btFaq`
--

INSERT INTO `btFaq` VALUES
(175, '');

-- --------------------------------------------------------

--
-- Table structure for table `btFaqEntries`
--

CREATE TABLE `btFaqEntries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bID` int(10) unsigned DEFAULT NULL,
  `linkTitle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sortOrder` int(11) DEFAULT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `bID` (`bID`,`sortOrder`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `btFaqEntries`
--

INSERT INTO `btFaqEntries` VALUES
(4, 175, 'What are page versions?', 'What are page versions?', 0, '\n                                    Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. '),
(5, 175, 'How do I add more people as editors in my website?', 'How do I add more people as editors in my website?', 1, '\n                                    Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. ');

-- --------------------------------------------------------

--
-- Table structure for table `btFeature`
--

CREATE TABLE `btFeature` (
  `bID` int(10) unsigned NOT NULL,
  `icon` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `paragraph` text COLLATE utf8_unicode_ci,
  `externalLink` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `internalLinkCID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `btFeature`
--

INSERT INTO `btFeature` VALUES
(66, 'pencil', 'Easy to Edit', '\n                                                    Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna.', '', 0),
(67, 'eye', 'Pixel Perfect', '\n                                                    Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna.', '', 0),
(68, 'youtube-play', 'Media Rich', '\n                                                    Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna.', '', 0),
(83, 'star', 'Quality', '\n                                                    Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla sodales non leo id aliquet.', '', 0),
(84, 'tint', 'Design', '\n                                                    Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla sodales non leo id aliquet.', '', 0),
(85, 'cog', 'Development', '\n                                                    Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla sodales non leo id aliquet.', '', 0),
(86, 'lock', 'Security', '\n                                                    Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla sodales non leo id aliquet.', '', 0),
(162, 'home', 'Welcome Home', '\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan.', '', 0),
(163, 'user', 'Great Workers', '\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan.', '', 0),
(164, 'flag', 'Amazing Location', '\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan.', '', 0),
(165, 'clock-o', 'Paid Time Off', '\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan.', '', 0),
(166, 'star', 'No Meetings', '\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan.', '', 0),
(167, 'beer', 'Free Drinks', '\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan.', '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `btForm`
--

CREATE TABLE `btForm` (
  `bID` int(10) unsigned NOT NULL,
  `questionSetId` int(10) unsigned DEFAULT '0',
  `surveyName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `submitText` varchar(255) COLLATE utf8_unicode_ci DEFAULT 'Submit',
  `thankyouMsg` text COLLATE utf8_unicode_ci,
  `notifyMeOnSubmission` tinyint(1) NOT NULL DEFAULT '0',
  `recipientEmail` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `displayCaptcha` int(11) DEFAULT '1',
  `redirectCID` int(11) DEFAULT '0',
  `addFilesToSet` int(11) DEFAULT '0',
  PRIMARY KEY (`bID`),
  KEY `questionSetIdForeign` (`questionSetId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btFormAnswers`
--

CREATE TABLE `btFormAnswers` (
  `aID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asID` int(10) unsigned DEFAULT '0',
  `msqID` int(10) unsigned DEFAULT '0',
  `answer` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `answerLong` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`aID`),
  KEY `asID` (`asID`),
  KEY `msqID` (`msqID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `btFormAnswerSet`
--

CREATE TABLE `btFormAnswerSet` (
  `asID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `questionSetId` int(10) unsigned DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `uID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`asID`),
  KEY `questionSetId` (`questionSetId`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `btFormQuestions`
--

CREATE TABLE `btFormQuestions` (
  `qID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `msqID` int(10) unsigned DEFAULT '0',
  `bID` int(10) unsigned DEFAULT '0',
  `questionSetId` int(10) unsigned DEFAULT '0',
  `question` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inputType` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `options` text COLLATE utf8_unicode_ci,
  `position` int(10) unsigned DEFAULT '1000',
  `width` int(10) unsigned DEFAULT '50',
  `height` int(10) unsigned DEFAULT '3',
  `defaultDate` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `required` int(11) DEFAULT '0',
  PRIMARY KEY (`qID`),
  KEY `questionSetId` (`questionSetId`),
  KEY `msqID` (`msqID`),
  KEY `bID` (`bID`,`questionSetId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `btGoogleMap`
--

CREATE TABLE `btGoogleMap` (
  `bID` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `location` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `latitude` double DEFAULT NULL,
  `longitude` double DEFAULT NULL,
  `zoom` smallint(6) DEFAULT NULL,
  `width` varchar(8) COLLATE utf8_unicode_ci DEFAULT '100%',
  `height` varchar(8) COLLATE utf8_unicode_ci DEFAULT '400px',
  `scrollwheel` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `btGoogleMap`
--

INSERT INTO `btGoogleMap` VALUES
(134, '', '1200 NW Naito Pkwy, Portland, OR, United States', 45.5313254, -122.6763493, 14, '100%', '400px', 0);

-- --------------------------------------------------------

--
-- Table structure for table `btImageSlider`
--

CREATE TABLE `btImageSlider` (
  `bID` int(10) unsigned NOT NULL,
  `navigationType` int(10) unsigned DEFAULT '0',
  `timeout` int(10) unsigned DEFAULT NULL,
  `speed` int(10) unsigned DEFAULT NULL,
  `noAnimate` int(10) unsigned DEFAULT NULL,
  `pause` int(10) unsigned DEFAULT NULL,
  `maxWidth` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `btImageSlider`
--

INSERT INTO `btImageSlider` VALUES
(64, 1, 4000, 500, 0, 0, 0),
(97, 0, 4000, 500, 0, 0, 0),
(99, 0, 4000, 500, 0, 0, 0),
(101, 0, 4000, 500, 0, 0, 0),
(103, 0, 4000, 500, 0, 0, 0),
(105, 0, 4000, 500, 0, 0, 0),
(107, 0, 4000, 500, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `btImageSliderEntries`
--

CREATE TABLE `btImageSliderEntries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bID` int(10) unsigned DEFAULT NULL,
  `cID` int(10) unsigned DEFAULT '0',
  `fID` int(10) unsigned DEFAULT '0',
  `linkURL` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `internalLinkCID` int(10) unsigned DEFAULT '0',
  `title` longtext COLLATE utf8_unicode_ci,
  `description` longtext COLLATE utf8_unicode_ci,
  `sortOrder` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=21 ;

--
-- Dumping data for table `btImageSliderEntries`
--

INSERT INTO `btImageSliderEntries` VALUES
(1, 64, 0, 13, '', 0, 'Stand Out on the Web', '\n                                    <p>Share your business with an impressive, yet minimal presentation. Let your customers understand your web presence through elegance and clarity.</p>', 0),
(2, 64, 0, 14, '', 0, 'A Simple Image Slider', '\n                                    <p>This image slider can have any content that you want in it.</p>', 1),
(3, 97, 0, 16, '', 0, '', '', 0),
(4, 97, 0, 15, '', 0, '', '', 1),
(5, 97, 0, 12, '', 0, '', '', 2),
(6, 99, 0, 16, '', 0, '', '', 0),
(7, 99, 0, 15, '', 0, '', '', 1),
(8, 99, 0, 12, '', 0, '', '', 2),
(9, 101, 0, 16, '', 0, '', '', 0),
(10, 101, 0, 15, '', 0, '', '', 1),
(11, 101, 0, 12, '', 0, '', '', 2),
(12, 103, 0, 16, '', 0, '', '', 0),
(13, 103, 0, 15, '', 0, '', '', 1),
(14, 103, 0, 12, '', 0, '', '', 2),
(15, 105, 0, 16, '', 0, '', '', 0),
(16, 105, 0, 15, '', 0, '', '', 1),
(17, 105, 0, 12, '', 0, '', '', 2),
(18, 107, 0, 16, '', 0, '', '', 0),
(19, 107, 0, 15, '', 0, '', '', 1),
(20, 107, 0, 12, '', 0, '', '', 2);

-- --------------------------------------------------------

--
-- Table structure for table `btNavigation`
--

CREATE TABLE `btNavigation` (
  `bID` int(10) unsigned NOT NULL,
  `orderBy` varchar(255) COLLATE utf8_unicode_ci DEFAULT 'alpha_asc',
  `displayPages` varchar(255) COLLATE utf8_unicode_ci DEFAULT 'top' COMMENT 'was enum(''top'',''current'',''above'',''below'',''custom'')',
  `displayPagesCID` int(10) unsigned NOT NULL DEFAULT '1',
  `displayPagesIncludeSelf` tinyint(1) NOT NULL DEFAULT '0',
  `displaySubPages` varchar(255) COLLATE utf8_unicode_ci DEFAULT 'none' COMMENT 'was enum(''none'',''all'',''relevant'',''relevant_breadcrumb'')',
  `displaySubPageLevels` varchar(255) COLLATE utf8_unicode_ci DEFAULT 'none' COMMENT 'was enum(''all'',''none'',''enough'',''enough_plus1'',''custom'')',
  `displaySubPageLevelsNum` smallint(5) unsigned NOT NULL DEFAULT '0',
  `displayUnavailablePages` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `btNavigation`
--

INSERT INTO `btNavigation` VALUES
(61, 'display_asc', 'top', 0, 0, 'all', 'custom', 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `btNextPrevious`
--

CREATE TABLE `btNextPrevious` (
  `bID` int(10) unsigned NOT NULL,
  `nextLabel` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `previousLabel` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `parentLabel` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `loopSequence` int(11) DEFAULT '1',
  `orderBy` varchar(20) COLLATE utf8_unicode_ci DEFAULT 'display_asc',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `btNextPrevious`
--

INSERT INTO `btNextPrevious` VALUES
(24, 'Next Post', 'Last Post', '', 0, 'chrono_desc');

-- --------------------------------------------------------

--
-- Table structure for table `btPageAttributeDisplay`
--

CREATE TABLE `btPageAttributeDisplay` (
  `bID` int(10) unsigned NOT NULL,
  `attributeHandle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `attributeTitleText` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `displayTag` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dateFormat` varchar(100) COLLATE utf8_unicode_ci DEFAULT 'div',
  `thumbnailHeight` int(10) unsigned DEFAULT NULL,
  `thumbnailWidth` int(10) unsigned DEFAULT NULL,
  `delimiter` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `btPageAttributeDisplay`
--

INSERT INTO `btPageAttributeDisplay` VALUES
(34, 'job_posting_department', '', 'p', 'm/d/y h:i:a', 250, 250, NULL),
(36, 'job_location', '', 'p', 'm/d/y h:i:a', 250, 250, NULL),
(42, 'project_client', 'Client:', 'div', 'm/d/y h:i:a', 250, 250, NULL),
(43, 'project_tasks', 'Task:', 'div', 'm/d/y h:i:a', 250, 250, NULL),
(44, 'project_skills', 'Skills:', 'div', 'm/d/y h:i:a', 250, 250, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `btPageList`
--

CREATE TABLE `btPageList` (
  `bID` int(10) unsigned NOT NULL,
  `num` smallint(5) unsigned NOT NULL,
  `orderBy` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Was enum, display_asc'',''display_desc'',''chrono_asc'',''chrono_desc'',''alpha_asc'',''alpha_desc'',''score_asc'',''score_desc''',
  `cParentID` int(10) unsigned NOT NULL DEFAULT '1',
  `cThis` tinyint(1) NOT NULL DEFAULT '0',
  `cThisParent` tinyint(1) NOT NULL DEFAULT '0',
  `useButtonForLink` tinyint(1) NOT NULL DEFAULT '0',
  `buttonLinkText` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pageListTitle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `filterByRelated` tinyint(1) NOT NULL DEFAULT '0',
  `filterByCustomTopic` tinyint(1) NOT NULL DEFAULT '0',
  `filterDateOption` varchar(25) COLLATE utf8_unicode_ci DEFAULT 'all' COMMENT '(''all'',''today'',''past'',''future'',''between'')',
  `filterDateDays` int(10) unsigned NOT NULL DEFAULT '0',
  `filterDateStart` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `filterDateEnd` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `relatedTopicAttributeKeyHandle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customTopicAttributeKeyHandle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customTopicTreeNodeID` int(10) unsigned NOT NULL DEFAULT '0',
  `includeName` tinyint(1) NOT NULL DEFAULT '1',
  `includeDescription` tinyint(1) NOT NULL DEFAULT '1',
  `includeDate` tinyint(1) NOT NULL DEFAULT '0',
  `includeAllDescendents` tinyint(1) NOT NULL DEFAULT '0',
  `paginate` tinyint(1) NOT NULL DEFAULT '0',
  `displayAliases` tinyint(1) NOT NULL DEFAULT '1',
  `ignorePermissions` tinyint(1) NOT NULL DEFAULT '0',
  `enableExternalFiltering` tinyint(1) NOT NULL DEFAULT '0',
  `ptID` smallint(5) unsigned DEFAULT NULL,
  `pfID` int(11) DEFAULT '0',
  `truncateSummaries` int(11) DEFAULT '0',
  `displayFeaturedOnly` tinyint(1) DEFAULT '0',
  `noResultsMessage` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `displayThumbnail` tinyint(1) DEFAULT '0',
  `truncateChars` int(11) DEFAULT '128',
  PRIMARY KEY (`bID`),
  KEY `ptID` (`ptID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `btPageList`
--

INSERT INTO `btPageList` VALUES
(27, 3, 'random', 199, 0, 0, 0, NULL, 'Related Posts', 0, 0, '', 0, NULL, NULL, '', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, NULL, 0, 0),
(31, 0, 'chrono_desc', 216, 0, 0, 0, NULL, 'Open Positions', 0, 0, '', 0, NULL, NULL, '', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, 0, 0),
(47, 3, 'random', 0, 0, 0, 0, NULL, 'Related Projects', 0, 0, '', 0, NULL, NULL, '', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, '\n                                                    No related projects found.', 0, 0),
(50, 10, 'chrono_desc', 0, 0, 1, 0, '', NULL, 0, 0, '', 0, NULL, NULL, '', '', 0, 1, 1, 1, 0, 1, 0, 0, 1, 6, 1, 0, 0, 'No posts to this blog.', 0, 0),
(55, 0, 'chrono_desc', 0, 0, 0, 0, '', NULL, 0, 0, '', 0, NULL, NULL, '', '', 0, 1, 0, 0, 0, 1, 0, 0, 1, 8, 0, 0, 0, 'No projects found.', 1, 0),
(71, 3, 'chrono_desc', 0, 0, 0, 1, 'View Project', NULL, 0, 0, '', 0, NULL, NULL, '', '', 0, 1, 1, 0, 0, 0, 0, 0, 0, 8, 0, 0, 1, '', 1, 0),
(77, 1, 'chrono_desc', 0, 0, 0, 0, '', NULL, 0, 0, '', 0, NULL, NULL, '', '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, '', 1, 0),
(78, 1, 'chrono_desc', 0, 0, 0, 0, '', NULL, 0, 0, '', 0, NULL, NULL, '', '', 0, 1, 1, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, '', 0, 0),
(171, 0, 'chrono_desc', 216, 1, 0, 1, 'Apply Now', NULL, 0, 0, '', 0, NULL, NULL, '', '', 0, 1, 1, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, NULL, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `btPageTitle`
--

CREATE TABLE `btPageTitle` (
  `bID` int(10) unsigned NOT NULL,
  `useCustomTitle` int(10) unsigned DEFAULT '0',
  `useFilterTitle` int(10) unsigned DEFAULT '0',
  `useFilterTopic` int(10) unsigned DEFAULT '0',
  `useFilterTag` int(10) unsigned DEFAULT '0',
  `useFilterDate` int(10) unsigned DEFAULT '0',
  `topicTextFormat` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tagTextFormat` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dateTextFormat` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `filterDateFormat` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `titleText` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `formatting` varchar(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `btPageTitle`
--

INSERT INTO `btPageTitle` VALUES
(22, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, '[Page Title]', NULL),
(30, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, '[Page Title]', NULL),
(40, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, '[Page Title]', NULL),
(48, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, '[Page Title]', NULL),
(53, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, '[Page Title]', NULL),
(81, 1, 0, 0, 0, 0, NULL, NULL, NULL, NULL, 'Our Expertise', NULL),
(109, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, '', NULL),
(132, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, '', NULL),
(143, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, '', NULL),
(158, 1, 0, 0, 0, 0, NULL, NULL, NULL, NULL, 'Work with Us', NULL),
(174, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, 'Frequently Asked Questions', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `btRssDisplay`
--

CREATE TABLE `btRssDisplay` (
  `bID` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dateFormat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `itemsToDisplay` int(10) unsigned DEFAULT '5',
  `showSummary` tinyint(1) NOT NULL DEFAULT '1',
  `launchInNewWindow` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `btRssDisplay`
--

INSERT INTO `btRssDisplay` VALUES
(7, 'Tutorials', 'https://documentation.concretecms.org/rss/tutorials', '', 1, 1, 1),
(13, 'News from concretecms.com', 'https://www.concretecms.com/rss/blog', '', 3, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `btSearch`
--

CREATE TABLE `btSearch` (
  `bID` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `buttonText` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `baseSearchPath` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `search_all` tinyint(1) DEFAULT NULL,
  `allow_user_options` tinyint(1) DEFAULT NULL,
  `postTo_cID` int(10) unsigned DEFAULT NULL,
  `resultsURL` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `btSearch`
--

INSERT INTO `btSearch` VALUES
(62, '', '', '', 0, 0, 200, ''),
(131, 'Search', 'Search', '', 0, 0, NULL, '');

-- --------------------------------------------------------

--
-- Table structure for table `btShareThisPage`
--

CREATE TABLE `btShareThisPage` (
  `btShareThisPageID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bID` int(10) unsigned DEFAULT '0',
  `service` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `displayOrder` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`btShareThisPageID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `btShareThisPage`
--

INSERT INTO `btShareThisPage` VALUES
(1, 25, 'facebook', 0),
(2, 25, 'twitter', 1),
(3, 25, 'linkedin', 2),
(4, 25, 'email', 3);

-- --------------------------------------------------------

--
-- Table structure for table `btSocialLinks`
--

CREATE TABLE `btSocialLinks` (
  `btSocialLinkID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bID` int(10) unsigned DEFAULT '0',
  `slID` int(10) unsigned DEFAULT '0',
  `displayOrder` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`btSocialLinkID`),
  KEY `bID` (`bID`,`displayOrder`),
  KEY `slID` (`slID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `btSocialLinks`
--

INSERT INTO `btSocialLinks` VALUES
(1, 60, 3, 0),
(2, 60, 2, 1),
(3, 60, 1, 2);

-- --------------------------------------------------------

--
-- Table structure for table `btSurvey`
--

CREATE TABLE `btSurvey` (
  `bID` int(10) unsigned NOT NULL,
  `question` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `requiresRegistration` int(11) DEFAULT '0',
  `showResults` int(11) DEFAULT '0',
  `customMessage` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btSurveyOptions`
--

CREATE TABLE `btSurveyOptions` (
  `optionID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bID` int(11) DEFAULT NULL,
  `optionName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `displayOrder` int(11) DEFAULT '0',
  PRIMARY KEY (`optionID`),
  KEY `bID` (`bID`,`displayOrder`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `btSurveyResults`
--

CREATE TABLE `btSurveyResults` (
  `resultID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `optionID` int(10) unsigned DEFAULT '0',
  `uID` int(10) unsigned DEFAULT '0',
  `bID` int(11) DEFAULT NULL,
  `cID` int(11) DEFAULT NULL,
  `ipAddress` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`resultID`),
  KEY `optionID` (`optionID`),
  KEY `cID` (`cID`,`optionID`,`bID`),
  KEY `bID` (`bID`,`cID`,`uID`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `btSwitchLanguage`
--

CREATE TABLE `btSwitchLanguage` (
  `bID` int(10) unsigned NOT NULL,
  `label` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btTags`
--

CREATE TABLE `btTags` (
  `bID` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `targetCID` int(11) DEFAULT NULL,
  `displayMode` varchar(20) COLLATE utf8_unicode_ci DEFAULT 'page',
  `cloudCount` int(11) DEFAULT '10',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btTestimonial`
--

CREATE TABLE `btTestimonial` (
  `bID` int(10) unsigned NOT NULL,
  `fID` int(10) unsigned DEFAULT '0',
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `position` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `company` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `companyURL` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `paragraph` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `btTestimonial`
--

INSERT INTO `btTestimonial` VALUES
(93, 2, 'Franz Maruna', 'CEO & Founder', 'concrete5', 'http://concrete5.org', '\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus.'),
(94, 2, 'John Doe', 'Marketing Directory', 'CompanyCo', '', '\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus.'),
(95, 2, 'Andrew Embler', 'CTO & Founder', 'concrete5', 'http://concrete5.org', '\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus.'),
(96, 2, 'Jane Doe', 'IT Manager', 'CompanyCo', '', '\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus.'),
(111, 4, 'John Smith', 'Co-Founder / CEO', '', '', '\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis.'),
(112, 4, 'Bob Smith', 'Co-Founder / CTO', '', '', '\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis.'),
(115, 4, 'John Smith', 'Art Director', '', '', '\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis.'),
(116, 4, 'John Smith', 'Art Director', '', '', '\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis.'),
(117, 4, 'Bob Smith', 'Art Director', '', '', '\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis.'),
(118, 4, 'Bob Smith', 'Art Director', '', '', '\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis.'),
(119, 4, 'Bob Smith', 'Art Director', '', '', '\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis.'),
(120, 4, 'Bob Smith', 'Art Director', '', '', '\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis.');

-- --------------------------------------------------------

--
-- Table structure for table `btTopicList`
--

CREATE TABLE `btTopicList` (
  `bID` int(10) unsigned NOT NULL,
  `mode` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'S' COMMENT 'S = Search, P = Page',
  `topicAttributeKeyHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `topicTreeID` int(10) unsigned NOT NULL DEFAULT '0',
  `cParentID` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `btTopicList`
--

INSERT INTO `btTopicList` VALUES
(26, 'P', 'blog_entry_topics', 4, 199, 'Topics'),
(51, 'S', '', 4, 0, 'Topics'),
(54, 'S', '', 5, 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `btVideo`
--

CREATE TABLE `btVideo` (
  `bID` int(10) unsigned NOT NULL,
  `webmfID` int(10) unsigned DEFAULT '0',
  `oggfID` int(10) unsigned DEFAULT '0',
  `posterfID` int(10) unsigned DEFAULT '0',
  `mp4fID` int(10) unsigned DEFAULT '0',
  `videoSize` int(10) unsigned DEFAULT '0',
  `width` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `btYouTube`
--

CREATE TABLE `btYouTube` (
  `bID` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `videoURL` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vHeight` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vWidth` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sizing` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `startTimeEnabled` tinyint(1) DEFAULT NULL,
  `startTime` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `noCookie` tinyint(1) DEFAULT NULL,
  `autoplay` tinyint(1) NOT NULL DEFAULT '0',
  `color` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `controls` int(10) unsigned DEFAULT NULL,
  `iv_load_policy` int(10) unsigned DEFAULT NULL,
  `loopEnd` tinyint(1) NOT NULL DEFAULT '0',
  `modestbranding` tinyint(1) NOT NULL DEFAULT '0',
  `lazyLoad` tinyint(1) NOT NULL DEFAULT '0',
  `rel` tinyint(1) NOT NULL DEFAULT '0',
  `showCaptions` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`bID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarEventAttributeKeys`
--

CREATE TABLE `CalendarEventAttributeKeys` (
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `CalendarEventAttributeKeys`
--

INSERT INTO `CalendarEventAttributeKeys` VALUES
(26);

-- --------------------------------------------------------

--
-- Table structure for table `CalendarEventOccurrences`
--

CREATE TABLE `CalendarEventOccurrences` (
  `occurrenceID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `startTime` int(11) NOT NULL,
  `endTime` int(11) NOT NULL,
  `cancelled` tinyint(1) NOT NULL,
  `repetitionID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`occurrenceID`),
  KEY `IDX_7DD686EC31391E00` (`repetitionID`),
  KEY `eventdates` (`occurrenceID`,`startTime`,`endTime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarEventRepetitions`
--

CREATE TABLE `CalendarEventRepetitions` (
  `repetitionID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `repetitionObject` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  PRIMARY KEY (`repetitionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarEvents`
--

CREATE TABLE `CalendarEvents` (
  `eventID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `caID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`eventID`),
  KEY `IDX_7F23C55611C85723` (`caID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarEventSearchIndexAttributes`
--

CREATE TABLE `CalendarEventSearchIndexAttributes` (
  `eventID` int(10) unsigned NOT NULL DEFAULT '0',
  `ak_event_categories` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`eventID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarEventVersionAttributeValues`
--

CREATE TABLE `CalendarEventVersionAttributeValues` (
  `eventVersionID` int(10) unsigned NOT NULL,
  `akID` int(10) unsigned NOT NULL,
  `avID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`eventVersionID`,`akID`),
  KEY `IDX_8C835B05403F5D6` (`eventVersionID`),
  KEY `IDX_8C835B05B6561A7E` (`akID`),
  KEY `IDX_8C835B05A2A82A5D` (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarEventVersionOccurrences`
--

CREATE TABLE `CalendarEventVersionOccurrences` (
  `versionOccurrenceID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `eventVersionID` int(10) unsigned DEFAULT NULL,
  `occurrenceID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`versionOccurrenceID`),
  KEY `IDX_60310489403F5D6` (`eventVersionID`),
  KEY `IDX_60310489B4FDDC0F` (`occurrenceID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarEventVersionRepetitions`
--

CREATE TABLE `CalendarEventVersionRepetitions` (
  `versionRepetitionID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `eventVersionID` int(10) unsigned DEFAULT NULL,
  `repetitionID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`versionRepetitionID`),
  KEY `IDX_C1C3D3DB403F5D6` (`eventVersionID`),
  KEY `IDX_C1C3D3DB31391E00` (`repetitionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarEventVersions`
--

CREATE TABLE `CalendarEventVersions` (
  `eventVersionID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `evDateAdded` datetime NOT NULL,
  `evActivateDateTime` datetime DEFAULT NULL,
  `evIsApproved` tinyint(1) NOT NULL,
  `evDescription` longtext COLLATE utf8_unicode_ci,
  `evName` longtext COLLATE utf8_unicode_ci,
  `evRelatedPageRelationType` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `eventID` int(10) unsigned DEFAULT NULL,
  `uID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`eventVersionID`),
  KEY `IDX_8E26027410409BA4` (`eventID`),
  KEY `IDX_8E260274FD71026C` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarEventWorkflowProgress`
--

CREATE TABLE `CalendarEventWorkflowProgress` (
  `wpID` int(10) unsigned NOT NULL DEFAULT '0',
  `eventID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eventID`,`wpID`),
  KEY `IDX_C5EAACF910409BA4` (`eventID`),
  KEY `wpID` (`wpID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarPermissionAssignments`
--

CREATE TABLE `CalendarPermissionAssignments` (
  `pkID` int(10) unsigned NOT NULL,
  `paID` int(10) unsigned NOT NULL,
  `caID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`caID`,`pkID`,`paID`),
  KEY `IDX_5AD546AA11C85723` (`caID`),
  KEY `paID` (`paID`),
  KEY `pkID` (`pkID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `CalendarRelatedEvents`
--

CREATE TABLE `CalendarRelatedEvents` (
  `relatedEventID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `relationID` int(10) unsigned NOT NULL,
  `relationType` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `eventID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`relatedEventID`),
  KEY `IDX_310130E910409BA4` (`eventID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `Calendars`
--

CREATE TABLE `Calendars` (
  `caID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `caName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `caOverridePermissions` tinyint(1) NOT NULL DEFAULT '0',
  `eventPageAttributeKeyHandle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `enableMoreDetails` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `eventPageParentID` int(10) unsigned DEFAULT '0',
  `eventPageTypeID` int(10) unsigned DEFAULT '0',
  `eventPageAssociatedID` int(10) unsigned DEFAULT '0',
  `siteID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`caID`),
  KEY `IDX_62E00AC521D8435` (`siteID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `CollectionAttributeKeys`
--

CREATE TABLE `CollectionAttributeKeys` (
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `CollectionAttributeKeys`
--

INSERT INTO `CollectionAttributeKeys` VALUES
(1),
(2),
(3),
(4),
(5),
(6),
(7),
(8),
(9),
(10),
(11),
(12),
(13),
(20),
(21),
(22),
(23),
(24),
(25),
(27),
(28),
(29);

-- --------------------------------------------------------

--
-- Table structure for table `CollectionAttributeValues`
--

CREATE TABLE `CollectionAttributeValues` (
  `cID` int(10) unsigned NOT NULL,
  `cvID` int(10) unsigned NOT NULL,
  `akID` int(10) unsigned NOT NULL,
  `avID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`cID`,`cvID`,`akID`),
  KEY `IDX_BB9995FCB6561A7E` (`akID`),
  KEY `IDX_BB9995FCA2A82A5D` (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `CollectionAttributeValues`
--

INSERT INTO `CollectionAttributeValues` VALUES
(2, 1, 6, 1),
(3, 1, 3, 2),
(4, 1, 3, 3),
(5, 1, 3, 4),
(6, 1, 3, 5),
(8, 1, 3, 6),
(9, 1, 3, 7),
(10, 1, 3, 8),
(11, 1, 7, 9),
(11, 1, 3, 10),
(12, 1, 3, 11),
(13, 1, 3, 12),
(14, 1, 3, 13),
(15, 1, 3, 14),
(16, 1, 3, 15),
(17, 1, 3, 16),
(17, 1, 7, 17),
(18, 1, 3, 18),
(18, 1, 7, 19),
(20, 1, 3, 20),
(21, 1, 3, 21),
(23, 1, 3, 22),
(26, 1, 3, 23),
(27, 1, 3, 24),
(28, 1, 7, 25),
(28, 1, 12, 26),
(29, 1, 3, 27),
(30, 1, 3, 28),
(31, 1, 3, 29),
(33, 1, 3, 30),
(34, 1, 3, 31),
(34, 1, 7, 32),
(36, 1, 7, 33),
(37, 1, 7, 34),
(38, 1, 7, 35),
(39, 1, 7, 36),
(40, 1, 7, 37),
(41, 1, 7, 38),
(43, 1, 7, 39),
(44, 1, 3, 40),
(45, 1, 3, 41),
(46, 1, 3, 42),
(49, 1, 7, 43),
(49, 1, 12, 44),
(51, 1, 7, 45),
(51, 1, 12, 46),
(54, 1, 6, 47),
(56, 1, 3, 48),
(58, 1, 7, 49),
(58, 1, 12, 50),
(58, 1, 3, 51),
(59, 1, 3, 52),
(60, 1, 3, 53),
(61, 1, 3, 54),
(62, 1, 3, 55),
(63, 1, 3, 56),
(64, 1, 3, 57),
(65, 1, 3, 58),
(66, 1, 3, 59),
(68, 1, 3, 60),
(69, 1, 3, 61),
(70, 1, 3, 62),
(71, 1, 3, 63),
(72, 1, 3, 64),
(73, 1, 3, 65),
(74, 1, 3, 66),
(74, 1, 7, 67),
(75, 1, 3, 68),
(76, 1, 3, 69),
(76, 1, 7, 70),
(76, 1, 12, 71),
(77, 1, 3, 72),
(80, 1, 7, 73),
(80, 1, 12, 74),
(81, 1, 7, 75),
(81, 1, 12, 76),
(82, 1, 7, 77),
(82, 1, 12, 78),
(83, 1, 7, 79),
(83, 1, 12, 80),
(84, 1, 7, 81),
(84, 1, 12, 82),
(90, 1, 3, 83),
(96, 1, 3, 84),
(97, 1, 3, 85),
(98, 1, 3, 86),
(99, 1, 3, 87),
(100, 1, 3, 88),
(102, 1, 3, 89),
(103, 1, 3, 90),
(104, 1, 3, 91),
(105, 1, 7, 92),
(105, 1, 3, 93),
(106, 1, 3, 94),
(107, 1, 3, 95),
(108, 1, 3, 96),
(110, 1, 3, 97),
(111, 1, 3, 98),
(112, 1, 3, 99),
(114, 1, 3, 100),
(115, 1, 3, 101),
(119, 1, 3, 102),
(120, 1, 7, 103),
(121, 1, 7, 104),
(122, 1, 3, 105),
(123, 1, 3, 106),
(124, 1, 3, 107),
(125, 1, 3, 108),
(127, 1, 3, 109),
(128, 1, 3, 110),
(129, 1, 3, 111),
(130, 1, 3, 112),
(131, 1, 3, 113),
(134, 1, 3, 114),
(135, 1, 3, 115),
(136, 1, 3, 116),
(137, 1, 3, 117),
(138, 1, 3, 118),
(139, 1, 3, 119),
(140, 1, 3, 120),
(141, 1, 3, 121),
(147, 1, 3, 122),
(148, 1, 3, 123),
(149, 1, 3, 124),
(150, 1, 3, 125),
(152, 1, 3, 126),
(153, 1, 3, 127),
(154, 1, 3, 128),
(155, 1, 3, 129),
(157, 1, 12, 130),
(158, 1, 3, 131),
(159, 1, 3, 132),
(160, 1, 3, 133),
(161, 1, 3, 134),
(162, 1, 3, 135),
(163, 1, 3, 136),
(164, 1, 3, 137),
(166, 1, 3, 138),
(168, 1, 3, 139),
(169, 1, 7, 140),
(169, 1, 12, 141),
(170, 1, 4, 142),
(170, 1, 5, 143),
(170, 1, 7, 144),
(172, 1, 6, 145),
(174, 1, 6, 146),
(175, 1, 12, 147),
(177, 1, 6, 148),
(183, 1, 6, 149),
(184, 1, 4, 150),
(184, 1, 5, 151),
(184, 1, 7, 152),
(1, 1, 7, 185),
(196, 1, 22, 186),
(205, 1, 11, 187),
(205, 1, 23, 188),
(205, 1, 25, 189),
(205, 1, 27, 190),
(205, 1, 28, 191),
(205, 1, 29, 192),
(206, 1, 23, 193),
(206, 1, 25, 194),
(206, 1, 27, 195),
(206, 1, 28, 196),
(206, 1, 29, 197),
(207, 1, 11, 198),
(207, 1, 23, 199),
(207, 1, 25, 200),
(207, 1, 27, 201),
(207, 1, 28, 202),
(207, 1, 29, 203),
(208, 1, 11, 204),
(208, 1, 23, 205),
(208, 1, 25, 206),
(208, 1, 27, 207),
(208, 1, 28, 208),
(208, 1, 29, 209),
(209, 1, 23, 210),
(209, 1, 25, 211),
(209, 1, 27, 212),
(209, 1, 28, 213),
(209, 1, 29, 214),
(210, 1, 23, 215),
(210, 1, 25, 216),
(210, 1, 27, 217),
(210, 1, 28, 218),
(210, 1, 29, 219),
(199, 1, 22, 220),
(212, 1, 1, 221),
(212, 1, 2, 222),
(212, 1, 3, 223),
(212, 1, 9, 224),
(212, 1, 13, 225),
(212, 1, 23, 226),
(212, 1, 24, 227),
(213, 1, 23, 228),
(213, 1, 24, 229),
(214, 1, 23, 230),
(214, 1, 24, 231),
(200, 1, 1, 232),
(200, 1, 2, 233),
(200, 1, 3, 234),
(200, 1, 7, 235),
(200, 1, 9, 236),
(200, 1, 13, 237),
(203, 1, 7, 238),
(219, 1, 1, 239),
(219, 1, 2, 240),
(219, 1, 3, 241),
(219, 1, 9, 242),
(219, 1, 13, 243),
(219, 1, 20, 244),
(219, 1, 21, 245),
(220, 1, 1, 246),
(220, 1, 2, 247),
(220, 1, 3, 248),
(220, 1, 9, 249),
(220, 1, 13, 250),
(220, 1, 20, 251),
(220, 1, 21, 252);

-- --------------------------------------------------------

--
-- Table structure for table `Collections`
--

CREATE TABLE `Collections` (
  `cID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cDateAdded` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `cDateModified` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `cHandle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`cID`),
  KEY `cIDDateModified` (`cID`,`cDateModified`),
  KEY `cDateModified` (`cDateModified`),
  KEY `cDateAdded` (`cDateAdded`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=223 ;

--
-- Dumping data for table `Collections`
--

INSERT INTO `Collections` VALUES
(1, '[[date_gmt]]', '[[date_gmt]]', NULL),
(2, '[[date_gmt]]', '[[date_gmt]]', 'dashboard'),
(3, '[[date_gmt]]', '[[date_gmt]]', 'sitemap'),
(4, '[[date_gmt]]', '[[date_gmt]]', 'full'),
(5, '[[date_gmt]]', '[[date_gmt]]', 'explore'),
(6, '[[date_gmt]]', '[[date_gmt]]', 'search'),
(7, '[[date_gmt]]', '[[date_gmt]]', 'files'),
(8, '[[date_gmt]]', '[[date_gmt]]', 'search'),
(9, '[[date_gmt]]', '[[date_gmt]]', 'attributes'),
(10, '[[date_gmt]]', '[[date_gmt]]', 'sets'),
(11, '[[date_gmt]]', '[[date_gmt]]', 'add_set'),
(12, '[[date_gmt]]', '[[date_gmt]]', 'users'),
(13, '[[date_gmt]]', '[[date_gmt]]', 'search'),
(14, '[[date_gmt]]', '[[date_gmt]]', 'groups'),
(15, '[[date_gmt]]', '[[date_gmt]]', 'message'),
(16, '[[date_gmt]]', '[[date_gmt]]', 'attributes'),
(17, '[[date_gmt]]', '[[date_gmt]]', 'add'),
(18, '[[date_gmt]]', '[[date_gmt]]', 'add_group'),
(19, '[[date_gmt]]', '[[date_gmt]]', 'bulkupdate'),
(20, '[[date_gmt]]', '[[date_gmt]]', 'group_sets'),
(21, '[[date_gmt]]', '[[date_gmt]]', 'points'),
(22, '[[date_gmt]]', '[[date_gmt]]', 'assign'),
(23, '[[date_gmt]]', '[[date_gmt]]', 'actions'),
(24, '[[date_gmt]]', '[[date_gmt]]', 'express'),
(25, '[[date_gmt]]', '[[date_gmt]]', 'entries'),
(26, '[[date_gmt]]', '[[date_gmt]]', 'reports'),
(27, '[[date_gmt]]', '[[date_gmt]]', 'forms'),
(28, '[[date_gmt]]', '[[date_gmt]]', 'legacy'),
(29, '[[date_gmt]]', '[[date_gmt]]', 'surveys'),
(30, '[[date_gmt]]', '[[date_gmt]]', 'logs'),
(31, '[[date_gmt]]', '[[date_gmt]]', 'page_changes'),
(32, '[[date_gmt]]', '[[date_gmt]]', 'pages'),
(33, '[[date_gmt]]', '[[date_gmt]]', 'themes'),
(34, '[[date_gmt]]', '[[date_gmt]]', 'inspect'),
(35, '[[date_gmt]]', '[[date_gmt]]', 'types'),
(36, '[[date_gmt]]', '[[date_gmt]]', 'organize'),
(37, '[[date_gmt]]', '[[date_gmt]]', 'add'),
(38, '[[date_gmt]]', '[[date_gmt]]', 'form'),
(39, '[[date_gmt]]', '[[date_gmt]]', 'output'),
(40, '[[date_gmt]]', '[[date_gmt]]', 'attributes'),
(41, '[[date_gmt]]', '[[date_gmt]]', 'permissions'),
(42, '[[date_gmt]]', '[[date_gmt]]', 'templates'),
(43, '[[date_gmt]]', '[[date_gmt]]', 'add'),
(44, '[[date_gmt]]', '[[date_gmt]]', 'attributes'),
(45, '[[date_gmt]]', '[[date_gmt]]', 'single'),
(46, '[[date_gmt]]', '[[date_gmt]]', 'feeds'),
(47, '[[date_gmt]]', '[[date_gmt]]', 'calendar'),
(48, '[[date_gmt]]', '[[date_gmt]]', 'events'),
(49, '[[date_gmt]]', '[[date_gmt]]', 'event_list'),
(50, '[[date_gmt]]', '[[date_gmt]]', 'add'),
(51, '[[date_gmt]]', '[[date_gmt]]', 'permissions'),
(52, '[[date_gmt]]', '[[date_gmt]]', 'attributes'),
(53, '[[date_gmt]]', '[[date_gmt]]', 'conversations'),
(54, '[[date_gmt]]', '[[date_gmt]]', 'messages'),
(55, '[[date_gmt]]', '[[date_gmt]]', 'blocks'),
(56, '[[date_gmt]]', '[[date_gmt]]', 'stacks'),
(57, '[[date_gmt]]', '[[date_gmt]]', 'permissions'),
(58, '[[date_gmt]]', '[[date_gmt]]', 'list'),
(59, '[[date_gmt]]', '[[date_gmt]]', 'types'),
(60, '[[date_gmt]]', '[[date_gmt]]', 'extend'),
(61, '[[date_gmt]]', '[[date_gmt]]', 'install'),
(62, '[[date_gmt]]', '[[date_gmt]]', 'update'),
(63, '[[date_gmt]]', '[[date_gmt]]', 'connect'),
(64, '[[date_gmt]]', '[[date_gmt]]', 'themes'),
(65, '[[date_gmt]]', '[[date_gmt]]', 'addons'),
(66, '[[date_gmt]]', '[[date_gmt]]', 'system'),
(67, '[[date_gmt]]', '[[date_gmt]]', 'basics'),
(68, '[[date_gmt]]', '[[date_gmt]]', 'name'),
(69, '[[date_gmt]]', '[[date_gmt]]', 'accessibility'),
(70, '[[date_gmt]]', '[[date_gmt]]', 'social'),
(71, '[[date_gmt]]', '[[date_gmt]]', 'icons'),
(72, '[[date_gmt]]', '[[date_gmt]]', 'editor'),
(73, '[[date_gmt]]', '[[date_gmt]]', 'multilingual'),
(74, '[[date_gmt]]', '[[date_gmt]]', 'update'),
(75, '[[date_gmt]]', '[[date_gmt]]', 'timezone'),
(76, '[[date_gmt]]', '[[date_gmt]]', 'attributes'),
(77, '[[date_gmt]]', '[[date_gmt]]', 'reset_edit_mode'),
(78, '[[date_gmt]]', '[[date_gmt]]', 'express'),
(79, '[[date_gmt]]', '[[date_gmt]]', 'entities'),
(80, '[[date_gmt]]', '[[date_gmt]]', 'attributes'),
(81, '[[date_gmt]]', '[[date_gmt]]', 'associations'),
(82, '[[date_gmt]]', '[[date_gmt]]', 'forms'),
(83, '[[date_gmt]]', '[[date_gmt]]', 'customize_search'),
(84, '[[date_gmt]]', '[[date_gmt]]', 'order_entries'),
(85, '[[date_gmt]]', '[[date_gmt]]', 'entries'),
(86, '[[date_gmt]]', '[[date_gmt]]', 'multisite'),
(87, '[[date_gmt]]', '[[date_gmt]]', 'sites'),
(88, '[[date_gmt]]', '[[date_gmt]]', 'types'),
(89, '[[date_gmt]]', '[[date_gmt]]', 'settings'),
(90, '[[date_gmt]]', '[[date_gmt]]', 'multilingual'),
(91, '[[date_gmt]]', '[[date_gmt]]', 'setup'),
(92, '[[date_gmt]]', '[[date_gmt]]', 'copy'),
(93, '[[date_gmt]]', '[[date_gmt]]', 'page_report'),
(94, '[[date_gmt]]', '[[date_gmt]]', 'translate_interface'),
(95, '[[date_gmt]]', '[[date_gmt]]', 'seo'),
(96, '[[date_gmt]]', '[[date_gmt]]', 'urls'),
(97, '[[date_gmt]]', '[[date_gmt]]', 'bulk'),
(98, '[[date_gmt]]', '[[date_gmt]]', 'codes'),
(99, '[[date_gmt]]', '[[date_gmt]]', 'excluded'),
(100, '[[date_gmt]]', '[[date_gmt]]', 'searchindex'),
(101, '[[date_gmt]]', '[[date_gmt]]', 'files'),
(102, '[[date_gmt]]', '[[date_gmt]]', 'filetypes'),
(103, '[[date_gmt]]', '[[date_gmt]]', 'permissions'),
(104, '[[date_gmt]]', '[[date_gmt]]', 'thumbnails'),
(105, '[[date_gmt]]', '[[date_gmt]]', 'options'),
(106, '[[date_gmt]]', '[[date_gmt]]', 'image_uploading'),
(107, '[[date_gmt]]', '[[date_gmt]]', 'storage'),
(108, '[[date_gmt]]', '[[date_gmt]]', 'export_options'),
(109, '[[date_gmt]]', '[[date_gmt]]', 'optimization'),
(110, '[[date_gmt]]', '[[date_gmt]]', 'cache'),
(111, '[[date_gmt]]', '[[date_gmt]]', 'clearcache'),
(112, '[[date_gmt]]', '[[date_gmt]]', 'jobs'),
(113, '[[date_gmt]]', '[[date_gmt]]', 'permissions'),
(114, '[[date_gmt]]', '[[date_gmt]]', 'site'),
(115, '[[date_gmt]]', '[[date_gmt]]', 'tasks'),
(116, '[[date_gmt]]', '[[date_gmt]]', 'users'),
(117, '[[date_gmt]]', '[[date_gmt]]', 'advanced'),
(118, '[[date_gmt]]', '[[date_gmt]]', 'workflows'),
(119, '[[date_gmt]]', '[[date_gmt]]', 'blacklist'),
(120, '[[date_gmt]]', '[[date_gmt]]', 'configure'),
(121, '[[date_gmt]]', '[[date_gmt]]', 'range'),
(122, '[[date_gmt]]', '[[date_gmt]]', 'captcha'),
(123, '[[date_gmt]]', '[[date_gmt]]', 'antispam'),
(124, '[[date_gmt]]', '[[date_gmt]]', 'maintenance'),
(125, '[[date_gmt]]', '[[date_gmt]]', 'trusted_proxies'),
(126, '[[date_gmt]]', '[[date_gmt]]', 'registration'),
(127, '[[date_gmt]]', '[[date_gmt]]', 'open'),
(128, '[[date_gmt]]', '[[date_gmt]]', 'postlogin'),
(129, '[[date_gmt]]', '[[date_gmt]]', 'profiles'),
(130, '[[date_gmt]]', '[[date_gmt]]', 'authentication'),
(131, '[[date_gmt]]', '[[date_gmt]]', 'global_password_reset'),
(132, '[[date_gmt]]', '[[date_gmt]]', 'notification'),
(133, '[[date_gmt]]', '[[date_gmt]]', 'deactivation'),
(134, '[[date_gmt]]', '[[date_gmt]]', 'automated_logout'),
(135, '[[date_gmt]]', '[[date_gmt]]', 'password_requirements'),
(136, '[[date_gmt]]', '[[date_gmt]]', 'session_options'),
(137, '[[date_gmt]]', '[[date_gmt]]', 'mail'),
(138, '[[date_gmt]]', '[[date_gmt]]', 'method'),
(139, '[[date_gmt]]', '[[date_gmt]]', 'test'),
(140, '[[date_gmt]]', '[[date_gmt]]', 'importers'),
(141, '[[date_gmt]]', '[[date_gmt]]', 'addresses'),
(142, '[[date_gmt]]', '[[date_gmt]]', 'calendar'),
(143, '[[date_gmt]]', '[[date_gmt]]', 'settings'),
(144, '[[date_gmt]]', '[[date_gmt]]', 'colors'),
(145, '[[date_gmt]]', '[[date_gmt]]', 'permissions'),
(146, '[[date_gmt]]', '[[date_gmt]]', 'import'),
(147, '[[date_gmt]]', '[[date_gmt]]', 'conversations'),
(148, '[[date_gmt]]', '[[date_gmt]]', 'settings'),
(149, '[[date_gmt]]', '[[date_gmt]]', 'points'),
(150, '[[date_gmt]]', '[[date_gmt]]', 'bannedwords'),
(151, '[[date_gmt]]', '[[date_gmt]]', 'permissions'),
(152, '[[date_gmt]]', '[[date_gmt]]', 'attributes'),
(153, '[[date_gmt]]', '[[date_gmt]]', 'types'),
(154, '[[date_gmt]]', '[[date_gmt]]', 'sets'),
(155, '[[date_gmt]]', '[[date_gmt]]', 'topics'),
(156, '[[date_gmt]]', '[[date_gmt]]', 'add'),
(157, '[[date_gmt]]', '[[date_gmt]]', 'environment'),
(158, '[[date_gmt]]', '[[date_gmt]]', 'info'),
(159, '[[date_gmt]]', '[[date_gmt]]', 'debug'),
(160, '[[date_gmt]]', '[[date_gmt]]', 'logging'),
(161, '[[date_gmt]]', '[[date_gmt]]', 'proxy'),
(162, '[[date_gmt]]', '[[date_gmt]]', 'entities'),
(163, '[[date_gmt]]', '[[date_gmt]]', 'database_charset'),
(164, '[[date_gmt]]', '[[date_gmt]]', 'geolocation'),
(165, '[[date_gmt]]', '[[date_gmt]]', 'update'),
(166, '[[date_gmt]]', '[[date_gmt]]', 'update'),
(167, '[[date_gmt]]', '[[date_gmt]]', 'api'),
(168, '[[date_gmt]]', '[[date_gmt]]', 'settings'),
(169, '[[date_gmt]]', '[[date_gmt]]', 'integrations'),
(170, '[[date_gmt]]', '[[date_gmt]]', 'welcome'),
(171, '[[date_gmt]]', '[[date_gmt]]', 'me'),
(172, '[[date_gmt]]', '[[date_gmt]]', '!stacks'),
(173, '[[date_gmt]]', '[[date_gmt]]', 'page_not_found'),
(174, '[[date_gmt]]', '[[date_gmt]]', '!trash'),
(175, '[[date_gmt]]', '[[date_gmt]]', 'login'),
(176, '[[date_gmt]]', '[[date_gmt]]', 'register'),
(177, '[[date_gmt]]', '[[date_gmt]]', 'account'),
(178, '[[date_gmt]]', '[[date_gmt]]', 'edit_profile'),
(179, '[[date_gmt]]', '[[date_gmt]]', 'avatar'),
(180, '[[date_gmt]]', '[[date_gmt]]', 'messages'),
(181, '[[date_gmt]]', '[[date_gmt]]', 'page_forbidden'),
(182, '[[date_gmt]]', '[[date_gmt]]', 'download_file'),
(183, '[[date_gmt]]', '[[date_gmt]]', '!drafts'),
(184, '[[date_gmt]]', '[[date_gmt]]', 'desktop'),
(185, '[[date_gmt]]', '[[date_gmt]]', 'footer-contact'),
(186, '[[date_gmt]]', '[[date_gmt]]', 'footer-legal'),
(187, '[[date_gmt]]', '[[date_gmt]]', 'footer-navigation'),
(188, '[[date_gmt]]', '[[date_gmt]]', 'footer-site-title'),
(189, '[[date_gmt]]', '[[date_gmt]]', 'footer-social'),
(190, '[[date_gmt]]', '[[date_gmt]]', 'header-navigation'),
(191, '[[date_gmt]]', '[[date_gmt]]', 'header-search'),
(192, '[[date_gmt]]', '[[date_gmt]]', 'header-site-title'),
(193, '[[date_gmt]]', '[[date_gmt]]', NULL),
(194, '[[date_gmt]]', '[[date_gmt]]', 'services'),
(195, '[[date_gmt]]', '[[date_gmt]]', NULL),
(196, '[[date_gmt]]', '[[date_gmt]]', 'portfolio'),
(197, '[[date_gmt]]', '[[date_gmt]]', 'team'),
(198, '[[date_gmt]]', '[[date_gmt]]', NULL),
(199, '[[date_gmt]]', '[[date_gmt]]', 'blog'),
(200, '[[date_gmt]]', '[[date_gmt]]', 'search'),
(201, '[[date_gmt]]', '[[date_gmt]]', 'contact'),
(202, '[[date_gmt]]', '[[date_gmt]]', NULL),
(203, '[[date_gmt]]', '[[date_gmt]]', 'blank-page'),
(204, '[[date_gmt]]', '[[date_gmt]]', NULL),
(205, '[[date_gmt]]', '[[date_gmt]]', 'project-title'),
(206, '[[date_gmt]]', '[[date_gmt]]', 'project-title-2'),
(207, '[[date_gmt]]', '[[date_gmt]]', 'project-title-3'),
(208, '[[date_gmt]]', '[[date_gmt]]', 'project-title-4'),
(209, '[[date_gmt]]', '[[date_gmt]]', 'project-title-5'),
(210, '[[date_gmt]]', '[[date_gmt]]', 'project-title-6'),
(211, '[[date_gmt]]', '[[date_gmt]]', NULL),
(212, '[[date_gmt]]', '[[date_gmt]]', 'hello-world'),
(213, '[[date_gmt]]', '[[date_gmt]]', 'another-blog-post'),
(214, '[[date_gmt]]', '[[date_gmt]]', 'a-beautiful-blog'),
(215, '[[date_gmt]]', '[[date_gmt]]', 'about'),
(216, '[[date_gmt]]', '[[date_gmt]]', 'careers'),
(217, '[[date_gmt]]', '[[date_gmt]]', 'faq'),
(218, '[[date_gmt]]', '[[date_gmt]]', NULL),
(219, '[[date_gmt]]', '[[date_gmt]]', 'web-developer'),
(220, '[[date_gmt]]', '[[date_gmt]]', 'sales-associate'),
(221, '[[date_gmt]]', '[[date_gmt]]', NULL),
(222, '[[date_gmt]]', '[[date_gmt]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `CollectionSearchIndexAttributes`
--

CREATE TABLE `CollectionSearchIndexAttributes` (
  `cID` int(10) unsigned NOT NULL,
  `ak_meta_title` longtext COLLATE utf8_unicode_ci,
  `ak_meta_description` longtext COLLATE utf8_unicode_ci,
  `ak_meta_keywords` longtext COLLATE utf8_unicode_ci,
  `ak_desktop_priority` decimal(14,4) DEFAULT '0.0000',
  `ak_is_desktop` tinyint(1) DEFAULT '0',
  `ak_icon_dashboard` longtext COLLATE utf8_unicode_ci,
  `ak_exclude_nav` tinyint(1) DEFAULT '0',
  `ak_exclude_page_list` tinyint(1) DEFAULT '0',
  `ak_header_extra_content` longtext COLLATE utf8_unicode_ci,
  `ak_tags` longtext COLLATE utf8_unicode_ci,
  `ak_is_featured` tinyint(1) DEFAULT '0',
  `ak_exclude_search_index` tinyint(1) DEFAULT '0',
  `ak_exclude_sitemapxml` tinyint(1) DEFAULT '0',
  `ak_job_posting_department` longtext COLLATE utf8_unicode_ci,
  `ak_job_location` longtext COLLATE utf8_unicode_ci,
  `ak_exclude_subpages_from_nav` tinyint(1) DEFAULT '0',
  `ak_thumbnail` int(11) DEFAULT '0',
  `ak_blog_entry_topics` longtext COLLATE utf8_unicode_ci,
  `ak_project_topics` longtext COLLATE utf8_unicode_ci,
  `ak_project_client` longtext COLLATE utf8_unicode_ci,
  `ak_project_tasks` longtext COLLATE utf8_unicode_ci,
  `ak_project_skills` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`cID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `CollectionSearchIndexAttributes`
--

INSERT INTO `CollectionSearchIndexAttributes` VALUES
(1, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(2, NULL, NULL, NULL, '0.0000', 0, 'fa fa-th-large', 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(3, NULL, NULL, 'pages, add page, delete page, copy, move, alias', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(4, NULL, NULL, 'pages, add page, delete page, copy, move, alias', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(5, NULL, NULL, 'pages, add page, delete page, copy, move, alias, bulk', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(6, NULL, NULL, 'find page, search page, search, find, pages, sitemap', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(8, NULL, NULL, 'add file, delete file, copy, move, alias, resize, crop, rename, images, title, attribute', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(9, NULL, NULL, 'file, file attributes, title, attribute, description, rename', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(10, NULL, NULL, 'files, category, categories', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(11, NULL, NULL, 'new file set', '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(12, NULL, NULL, 'users, groups, people, find, delete user, remove user, change password, password', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(13, NULL, NULL, 'find, search, people, delete user, remove user, change password, password', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(14, NULL, NULL, 'user, group, people, permissions, expire, badges', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(15, NULL, NULL, 'user, group, people, messages', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(16, NULL, NULL, 'user attributes, user data, gather data, registration data', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(17, NULL, NULL, 'new user, create', '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(18, NULL, NULL, 'new user group, new group, group, create', '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(20, NULL, NULL, 'group set', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(21, NULL, NULL, 'community, points, karma', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(23, NULL, NULL, 'action, community actions', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(26, NULL, NULL, 'forms, log, error, email, mysql, exception, survey', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(27, NULL, NULL, 'forms, questions, response, data', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(28, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(29, NULL, NULL, 'questions, quiz, response', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(30, NULL, NULL, 'forms, log, error, email, mysql, exception, survey, history', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(31, NULL, NULL, 'changes, csv, report', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(33, NULL, NULL, 'new theme, theme, active theme, change theme, template, css', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(34, NULL, NULL, 'page types', '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(36, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(37, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(38, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(39, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(40, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(41, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(43, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(44, NULL, NULL, 'page attributes, custom', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(45, NULL, NULL, 'single, page, custom, application', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(46, NULL, NULL, 'atom, rss, feed, syndication', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(49, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(51, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(54, NULL, NULL, NULL, '0.0000', 0, 'icon-bullhorn', 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(56, NULL, NULL, 'stacks, global areas, reusable content, scrapbook, copy, paste, paste block, copy block, site name, logo', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(58, NULL, NULL, 'edit stacks, view stacks, all stacks', '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(59, NULL, NULL, 'block, refresh, custom', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(60, NULL, NULL, 'add-on, addon, add on, package, app, ecommerce, discussions, forums, themes, templates, blocks', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(61, NULL, NULL, 'add-on, addon, ecommerce, install, discussions, forums, themes, templates, blocks', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(62, NULL, NULL, 'update, upgrade', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(63, NULL, NULL, 'concretecms.org, my account, marketplace', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(64, NULL, NULL, 'buy theme, new theme, marketplace, template', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(65, NULL, NULL, 'buy addon, buy add on, buy add-on, purchase addon, purchase add on, purchase add-on, find addon, new addon, marketplace', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(66, NULL, NULL, 'dashboard, configuration', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(68, NULL, NULL, 'website name, title', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(69, NULL, NULL, 'accessibility, easy mode', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(70, NULL, NULL, 'sharing, facebook, twitter', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(71, NULL, NULL, 'logo, favicon, iphone, icon, bookmark', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(72, NULL, NULL, 'tinymce, content block, fonts, editor, content, overlay', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(73, NULL, NULL, 'translate, translation, internationalization, multilingual', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(74, NULL, NULL, 'languages, update, gettext, translation, translate', '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(75, NULL, NULL, 'timezone, profile, locale', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(76, NULL, NULL, 'site attributes', '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(77, NULL, NULL, 'checkin, check-in, check, force', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(80, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(81, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(82, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(83, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(84, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(90, NULL, NULL, 'multilingual, localization, internationalization, i18n', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(96, NULL, NULL, 'vanity, pretty url, redirection, hostname, canonical, seo, pageview, view', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(97, NULL, NULL, 'bulk, seo, change keywords, engine, optimization, search', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(98, NULL, NULL, 'traffic, statistics, google analytics, quant, pageviews, hits', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(99, NULL, NULL, 'pretty, slug', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(100, NULL, NULL, 'configure search, site search, search option', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(102, NULL, NULL, 'security, files, media, extension, manager, upload', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(103, NULL, NULL, 'file options, file manager, upload, modify', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(104, NULL, NULL, 'images, picture, responsive, retina', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(105, NULL, NULL, 'thumbnail, format, png, jpg, jpeg, quality, compression, gd, imagick, imagemagick, transparency', '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(106, NULL, NULL, 'uploading, upload, images, image, resizing, manager, exif, rotation, rotate, quality, compression, png, jpg, jpeg', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(107, NULL, NULL, 'security, alternate storage, hide files', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(108, NULL, NULL, 'files, export, csv, bom, encoding', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(110, NULL, NULL, 'cache option, change cache, override, turn on cache, turn off cache, no cache, page cache, caching', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(111, NULL, NULL, 'cache option, turn off cache, no cache, page cache, caching', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(112, NULL, NULL, 'index search, reindex search, build sitemap, sitemap.xml, clear old versions, page versions, remove old', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(114, NULL, NULL, 'editors, hide site, offline, private, public, access', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(115, NULL, NULL, 'security, actions, administrator, admin, package, marketplace, search', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(119, NULL, NULL, 'security, lock ip, lock out, block ip, address, restrict, access', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(120, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(121, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(122, NULL, NULL, 'security, registration', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(123, NULL, NULL, 'antispam, block spam, security', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(124, NULL, NULL, 'lock site, under construction, hide, hidden', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(125, NULL, NULL, 'trusted, proxy, proxies, ip, header, cloudflare', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(127, NULL, NULL, 'signup, new user, community, public registration, public, registration', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(128, NULL, NULL, 'profile, login, redirect, specific, dashboard, administrators', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(129, NULL, NULL, 'member profile, member page, community, forums, social, avatar', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(130, NULL, NULL, 'auth, authentication, types, oauth, facebook, login, registration', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(131, NULL, NULL, 'global, password, reset, change password, force, sign out', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(134, NULL, NULL, 'login, logout, user, agent, ip, change, security, session, invalidation, invalid', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(135, NULL, NULL, 'password, requirements, code, key, login, registration, security, nist', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(136, NULL, NULL, 'session, options', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(137, NULL, NULL, 'smtp, mail settings', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(138, NULL, NULL, 'email server, mail settings, mail configuration, external, internal', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(139, NULL, NULL, 'test smtp, test mail', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(140, NULL, NULL, 'email server, mail settings, mail configuration, private message, message system, import, email, message', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(141, NULL, NULL, 'mail settings, mail configuration, email, sender', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(147, NULL, NULL, 'conversations', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(148, NULL, NULL, 'conversations', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(149, NULL, NULL, 'conversations ratings, ratings, community, community points', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(150, NULL, NULL, 'conversations bad words, banned words, banned, bad words, bad, words, list', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(152, NULL, NULL, 'attribute configuration', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(153, NULL, NULL, 'attributes, types', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(154, NULL, NULL, 'attributes, sets', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(155, NULL, NULL, 'topics, tags, taxonomy', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(157, NULL, NULL, NULL, '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 1, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(158, NULL, NULL, 'overrides, system info, debug, support, help', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(159, NULL, NULL, 'errors, exceptions, develop, support, help', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(160, NULL, NULL, 'email, logging, logs, smtp, pop, errors, mysql, log', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(161, NULL, NULL, 'network, proxy server', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(162, NULL, NULL, 'database, entities, doctrine, orm', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(163, NULL, NULL, 'database, character set, charset, collation, utf8', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(164, NULL, NULL, 'geolocation, ip, address, country, nation, place, locate', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(166, NULL, NULL, 'upgrade, new version, update', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(168, NULL, NULL, 'API, programming, public, app', '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(169, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 1, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(170, NULL, NULL, NULL, '2.0000', 1, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(172, NULL, NULL, NULL, '0.0000', 0, 'fa fa-th', 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(174, NULL, NULL, NULL, '0.0000', 0, 'fa fa-trash-o', 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(175, NULL, NULL, NULL, '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 1, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(177, NULL, NULL, NULL, '0.0000', 0, 'fa fa-briefcase', 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(183, NULL, NULL, NULL, '0.0000', 0, 'fa fa-edit', 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(184, NULL, NULL, NULL, '1.0000', 1, NULL, 1, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(196, NULL, NULL, NULL, '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 1, 0, NULL, NULL, NULL, NULL, NULL),
(199, NULL, NULL, NULL, '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 1, 0, NULL, NULL, NULL, NULL, NULL),
(200, '', '', '', '0.0000', 0, NULL, 1, 0, '', NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(203, NULL, NULL, NULL, '0.0000', 0, NULL, 1, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 0, NULL, NULL, NULL, NULL, NULL),
(205, NULL, NULL, NULL, '0.0000', 0, NULL, 0, 0, NULL, NULL, 1, 0, 0, NULL, NULL, 0, 7, NULL, '||/Homework||', 'Test Client', '\nArchitecture\nDesign\nProduction\n', '\nHTML\nJavaScript\nPHP\n'),
(206, NULL, NULL, NULL, '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 9, NULL, '||/Activities||', 'Test Client', '\nArchitecture\n', '\nPHP\n'),
(207, NULL, NULL, NULL, '0.0000', 0, NULL, 0, 0, NULL, NULL, 1, 0, 0, NULL, NULL, 0, 16, NULL, '||/Homework||', 'Test Client 2', '\nMultimedia\nProduction\nDevelopment\n', '\nPHP\nHTML\nCSS\nJavaScript\n'),
(208, NULL, NULL, NULL, '0.0000', 0, NULL, 0, 0, NULL, NULL, 1, 0, 0, NULL, NULL, 0, 15, NULL, '||/Homework||', 'Test Client 2', '\nDesign\n', '\nPhotoshop\n'),
(209, NULL, NULL, NULL, '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 12, NULL, '||/Homework||', 'Test Client 2', '\nDesign\n', '\nPhotoshop\n'),
(210, NULL, NULL, NULL, '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 11, NULL, '||/Homework||', 'Test Client 2', '\nDesign\n', '\nPhotoshop\n'),
(212, '', '', '', '0.0000', 0, NULL, 0, 0, '', NULL, 0, 0, 0, NULL, NULL, 0, 3, '||/Projects||', NULL, NULL, NULL, NULL),
(213, NULL, NULL, NULL, '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 8, '||/Humor||', NULL, NULL, NULL, NULL),
(214, NULL, NULL, NULL, '0.0000', 0, NULL, 0, 0, NULL, NULL, 0, 0, 0, NULL, NULL, 0, 1, '||/Projects||', NULL, NULL, NULL, NULL),
(219, '', '', '', '0.0000', 0, NULL, 0, 0, '', NULL, 0, 0, 0, '\nTechnical and Operations\n', '\n                        Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla massa lacus, vehicula eu interdum convallis, laoreet id lectus. Nunc turpis elit, aliquam sit amet aliquam tincidunt, dapibus vel tellus. ', 0, 0, NULL, NULL, NULL, NULL, NULL),
(220, '', '', '', '0.0000', 0, NULL, 0, 0, '', NULL, 0, 0, 0, '\nMarketing and Sales\n', '\n                        Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla massa lacus, vehicula eu interdum convallis, laoreet id lectus. Nunc turpis elit, aliquam sit amet aliquam tincidunt, dapibus vel tellus. ', 0, 0, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `CollectionVersionAreaStyles`
--

CREATE TABLE `CollectionVersionAreaStyles` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '0',
  `arHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `issID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`arHandle`),
  KEY `issID` (`issID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `CollectionVersionAreaStyles`
--

INSERT INTO `CollectionVersionAreaStyles` VALUES
(1, 1, 'Page Footer', 15),
(194, 1, 'Page Footer', 16);

-- --------------------------------------------------------

--
-- Table structure for table `CollectionVersionBlocks`
--

CREATE TABLE `CollectionVersionBlocks` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '1',
  `bID` int(10) unsigned NOT NULL DEFAULT '0',
  `arHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `cbRelationID` int(10) unsigned DEFAULT '0',
  `cbDisplayOrder` int(10) unsigned NOT NULL DEFAULT '0',
  `isOriginal` tinyint(1) NOT NULL DEFAULT '0',
  `cbOverrideAreaPermissions` tinyint(1) NOT NULL DEFAULT '0',
  `cbIncludeAll` tinyint(1) NOT NULL DEFAULT '0',
  `cbOverrideBlockTypeCacheSettings` tinyint(1) NOT NULL DEFAULT '0',
  `cbOverrideBlockTypeContainerSettings` tinyint(1) NOT NULL DEFAULT '0',
  `cbEnableBlockContainer` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`bID`,`arHandle`),
  KEY `bID` (`bID`,`cID`),
  KEY `cbRelationID` (`cbRelationID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `CollectionVersionBlocks`
--

INSERT INTO `CollectionVersionBlocks` VALUES
(1, 1, 64, 'Main', 64, 0, 1, 0, 0, 0, 0, 0),
(1, 1, 65, 'Main', 65, 1, 1, 0, 0, 0, 0, 0),
(1, 1, 66, 'Main : 15', 66, 0, 1, 0, 0, 0, 0, 0),
(1, 1, 67, 'Main : 16', 67, 0, 1, 0, 0, 0, 0, 0),
(1, 1, 68, 'Main : 17', 68, 0, 1, 0, 0, 0, 0, 0),
(1, 1, 69, 'Main', 69, 2, 1, 0, 0, 0, 0, 0),
(1, 1, 70, 'Main', 70, 3, 1, 0, 0, 0, 0, 0),
(1, 1, 71, 'Main', 71, 4, 1, 0, 0, 0, 0, 0),
(1, 1, 72, 'Main', 72, 5, 1, 0, 0, 0, 0, 0),
(1, 1, 73, 'Main', 73, 6, 1, 0, 0, 0, 0, 0),
(1, 1, 74, 'Main : 18', 74, 0, 1, 0, 0, 0, 0, 0),
(1, 1, 75, 'Main : 19', 75, 0, 1, 0, 0, 0, 0, 0),
(1, 1, 76, 'Main', 76, 7, 1, 0, 0, 0, 0, 0),
(1, 1, 77, 'Main : 20', 77, 0, 1, 0, 0, 0, 0, 0),
(1, 1, 78, 'Main : 21', 78, 0, 1, 0, 0, 0, 0, 0),
(1, 1, 79, 'Main : 22', 79, 0, 1, 0, 0, 0, 0, 0),
(1, 1, 80, 'Page Footer', 80, 0, 1, 0, 0, 0, 0, 0),
(170, 1, 1, 'Main', 1, 0, 1, 0, 0, 0, 0, 0),
(170, 1, 2, 'Main', 2, 1, 1, 0, 0, 0, 0, 0),
(170, 1, 3, 'Main : 1', 3, 0, 1, 0, 0, 0, 0, 0),
(170, 1, 4, 'Main : 2', 4, 0, 1, 0, 0, 0, 0, 0),
(170, 1, 5, 'Main : 3', 5, 0, 1, 0, 0, 0, 0, 0),
(170, 1, 6, 'Main', 6, 2, 1, 0, 0, 0, 0, 0),
(170, 1, 7, 'Main : 4', 7, 0, 1, 0, 0, 0, 0, 0),
(170, 1, 8, 'Main : 5', 8, 0, 1, 0, 0, 0, 0, 0),
(170, 1, 9, 'Main', 9, 3, 1, 0, 0, 0, 0, 0),
(170, 1, 10, 'Main : 6', 10, 0, 1, 0, 0, 0, 0, 0),
(170, 1, 11, 'Main : 7', 11, 0, 1, 0, 0, 0, 0, 0),
(170, 1, 12, 'Main : 8', 12, 0, 1, 0, 0, 0, 0, 0),
(170, 1, 13, 'Main', 13, 4, 1, 0, 0, 0, 0, 0),
(171, 1, 14, 'Main', 14, 0, 1, 0, 0, 0, 0, 0),
(171, 1, 15, 'Main : 9', 15, 0, 1, 0, 0, 0, 0, 0),
(171, 1, 16, 'Main', 16, 1, 1, 0, 0, 0, 0, 0),
(171, 1, 17, 'Main : 10', 17, 0, 1, 0, 0, 0, 0, 0),
(184, 1, 18, 'Main', 18, 0, 1, 0, 0, 0, 0, 0),
(184, 1, 19, 'Main : 11', 19, 0, 1, 0, 0, 0, 0, 0),
(184, 1, 20, 'Main', 20, 1, 1, 0, 0, 0, 0, 0),
(184, 1, 21, 'Main : 12', 21, 0, 1, 0, 0, 0, 0, 0),
(185, 1, 56, 'Main', 56, 0, 1, 0, 0, 0, 0, 0),
(186, 1, 57, 'Main', 57, 0, 1, 0, 0, 0, 0, 0),
(187, 1, 58, 'Main', 58, 0, 1, 0, 0, 0, 0, 0),
(188, 1, 59, 'Main', 59, 0, 1, 0, 0, 0, 0, 0),
(189, 1, 60, 'Main', 60, 0, 1, 0, 0, 0, 0, 0),
(190, 1, 61, 'Main', 61, 0, 1, 0, 0, 1, 0, 0),
(191, 1, 62, 'Main', 62, 0, 1, 0, 0, 0, 0, 0),
(192, 1, 63, 'Main', 63, 0, 1, 0, 0, 0, 0, 0),
(194, 1, 81, 'Main', 81, 0, 1, 0, 0, 0, 0, 0),
(194, 1, 82, 'Main', 82, 1, 1, 0, 0, 0, 0, 0),
(194, 1, 83, 'Main : 23', 83, 0, 1, 0, 0, 0, 0, 0),
(194, 1, 84, 'Main : 24', 84, 0, 1, 0, 0, 0, 0, 0),
(194, 1, 85, 'Main : 25', 85, 0, 1, 0, 0, 0, 0, 0),
(194, 1, 86, 'Main : 26', 86, 0, 1, 0, 0, 0, 0, 0),
(194, 1, 87, 'Main', 87, 2, 1, 0, 0, 0, 0, 0),
(194, 1, 88, 'Main', 88, 3, 1, 0, 0, 0, 0, 0),
(194, 1, 89, 'Main : 27', 89, 0, 1, 0, 0, 0, 0, 0),
(194, 1, 90, 'Main : 28', 90, 0, 1, 0, 0, 0, 0, 0),
(194, 1, 91, 'Page Footer', 91, 0, 1, 0, 0, 0, 0, 0),
(194, 1, 92, 'Page Footer', 92, 1, 1, 0, 0, 0, 0, 0),
(194, 1, 93, 'Page Footer : 29', 93, 0, 1, 0, 0, 0, 0, 0),
(194, 1, 94, 'Page Footer : 29', 94, 1, 1, 0, 0, 0, 0, 0),
(194, 1, 95, 'Page Footer : 30', 95, 0, 1, 0, 0, 0, 0, 0),
(194, 1, 96, 'Page Footer : 30', 96, 1, 1, 0, 0, 0, 0, 0),
(195, 1, 53, 'Main', 53, 0, 1, 0, 0, 0, 0, 0),
(195, 1, 54, 'Main', 54, 1, 1, 0, 0, 0, 0, 0),
(195, 1, 55, 'Main', 55, 2, 1, 0, 0, 0, 0, 0),
(196, 1, 53, 'Main', 53, 0, 0, 0, 0, 0, 0, 0),
(196, 1, 54, 'Main', 54, 1, 0, 0, 0, 0, 0, 0),
(196, 1, 55, 'Main', 55, 2, 0, 0, 0, 0, 0, 0),
(197, 1, 109, 'Main', 109, 0, 1, 0, 0, 0, 0, 0),
(197, 1, 110, 'Main', 110, 1, 1, 0, 0, 0, 0, 0),
(197, 1, 111, 'Main : 31', 111, 0, 1, 0, 0, 0, 0, 0),
(197, 1, 112, 'Main : 32', 112, 0, 1, 0, 0, 0, 0, 0),
(197, 1, 113, 'Main', 113, 2, 1, 0, 0, 0, 0, 0),
(197, 1, 114, 'Main', 114, 3, 1, 0, 0, 0, 0, 0),
(197, 1, 115, 'Main : 33', 115, 0, 1, 0, 0, 0, 0, 0),
(197, 1, 116, 'Main : 33', 116, 1, 1, 0, 0, 0, 0, 0),
(197, 1, 117, 'Main : 34', 117, 0, 1, 0, 0, 0, 0, 0),
(197, 1, 118, 'Main : 34', 118, 1, 1, 0, 0, 0, 0, 0),
(197, 1, 119, 'Main : 35', 119, 0, 1, 0, 0, 0, 0, 0),
(197, 1, 120, 'Main : 35', 120, 1, 1, 0, 0, 0, 0, 0),
(197, 1, 121, 'Main', 121, 4, 1, 0, 0, 0, 0, 0),
(197, 1, 122, 'Main', 122, 5, 1, 0, 0, 0, 0, 0),
(197, 1, 123, 'Main : 36', 123, 0, 1, 0, 0, 0, 0, 0),
(197, 1, 124, 'Main : 37', 124, 0, 1, 0, 0, 0, 0, 0),
(198, 1, 48, 'Main', 48, 0, 1, 0, 0, 0, 0, 0),
(198, 1, 49, 'Main', 49, 1, 1, 0, 0, 0, 0, 0),
(198, 1, 50, 'Main : 13', 50, 0, 1, 0, 0, 0, 0, 0),
(198, 1, 51, 'Main : 14', 51, 0, 1, 0, 0, 0, 0, 0),
(198, 1, 52, 'Main : 14', 52, 1, 1, 0, 0, 0, 0, 0),
(199, 1, 48, 'Main', 48, 0, 0, 0, 0, 0, 0, 0),
(199, 1, 49, 'Main', 49, 1, 0, 0, 0, 0, 0, 0),
(199, 1, 50, 'Main : 13', 50, 0, 0, 0, 0, 0, 0, 0),
(199, 1, 51, 'Main : 14', 51, 0, 0, 0, 0, 0, 0, 0),
(199, 1, 52, 'Main : 14', 52, 1, 0, 0, 0, 0, 0, 0),
(200, 1, 131, 'Main', 131, 0, 1, 0, 0, 0, 0, 0),
(201, 1, 132, 'Main', 132, 0, 1, 0, 0, 0, 0, 0),
(201, 1, 133, 'Main', 133, 1, 1, 0, 0, 0, 0, 0),
(201, 1, 134, 'Main : 38', 134, 0, 1, 0, 0, 0, 0, 0),
(201, 1, 135, 'Main : 39', 135, 0, 1, 0, 0, 0, 0, 0),
(201, 1, 136, 'Main', 136, 2, 1, 0, 0, 0, 0, 0),
(201, 1, 137, 'Main', 137, 3, 1, 0, 0, 0, 0, 0),
(201, 1, 138, 'Main : 40', 138, 0, 1, 0, 0, 0, 0, 0),
(201, 1, 139, 'Main : 41', 139, 0, 1, 0, 0, 0, 0, 0),
(201, 1, 140, 'Main : 42', 140, 0, 1, 0, 0, 0, 0, 0),
(201, 1, 141, 'Main : 42', 141, 1, 1, 0, 0, 0, 0, 0),
(203, 1, 142, 'Main', 142, 0, 1, 0, 0, 0, 0, 0),
(204, 1, 40, 'Page Header', 40, 0, 1, 0, 0, 0, 0, 0),
(204, 1, 41, 'Page Header', 41, 1, 1, 0, 0, 0, 0, 0),
(204, 1, 42, 'Sidebar', 42, 0, 1, 0, 0, 0, 0, 0),
(204, 1, 43, 'Sidebar', 43, 1, 1, 0, 0, 0, 0, 0),
(204, 1, 44, 'Sidebar', 44, 2, 1, 0, 0, 0, 0, 0),
(204, 1, 45, 'Main', 45, 0, 1, 0, 0, 0, 0, 0),
(204, 1, 46, 'Page Footer', 46, 0, 1, 0, 0, 0, 0, 0),
(204, 1, 47, 'Page Footer', 47, 1, 1, 0, 0, 0, 0, 0),
(205, 1, 40, 'Page Header', 40, 0, 0, 0, 0, 0, 0, 0),
(205, 1, 42, 'Sidebar', 42, 0, 0, 0, 0, 0, 0, 0),
(205, 1, 43, 'Sidebar', 43, 1, 0, 0, 0, 0, 0, 0),
(205, 1, 44, 'Sidebar', 44, 2, 0, 0, 0, 0, 0, 0),
(205, 1, 46, 'Page Footer', 46, 0, 0, 0, 0, 0, 0, 0),
(205, 1, 47, 'Page Footer', 47, 1, 0, 0, 0, 0, 0, 0),
(205, 1, 97, 'Page Header', 97, 1, 1, 0, 0, 0, 0, 0),
(205, 1, 98, 'Main', 98, 0, 1, 0, 0, 0, 0, 0),
(206, 1, 40, 'Page Header', 40, 0, 0, 0, 0, 0, 0, 0),
(206, 1, 42, 'Sidebar', 42, 0, 0, 0, 0, 0, 0, 0),
(206, 1, 43, 'Sidebar', 43, 1, 0, 0, 0, 0, 0, 0),
(206, 1, 44, 'Sidebar', 44, 2, 0, 0, 0, 0, 0, 0),
(206, 1, 46, 'Page Footer', 46, 0, 0, 0, 0, 0, 0, 0),
(206, 1, 47, 'Page Footer', 47, 1, 0, 0, 0, 0, 0, 0),
(206, 1, 99, 'Page Header', 99, 1, 1, 0, 0, 0, 0, 0),
(206, 1, 100, 'Main', 100, 0, 1, 0, 0, 0, 0, 0),
(207, 1, 40, 'Page Header', 40, 0, 0, 0, 0, 0, 0, 0),
(207, 1, 42, 'Sidebar', 42, 0, 0, 0, 0, 0, 0, 0),
(207, 1, 43, 'Sidebar', 43, 1, 0, 0, 0, 0, 0, 0),
(207, 1, 44, 'Sidebar', 44, 2, 0, 0, 0, 0, 0, 0),
(207, 1, 46, 'Page Footer', 46, 0, 0, 0, 0, 0, 0, 0),
(207, 1, 47, 'Page Footer', 47, 1, 0, 0, 0, 0, 0, 0),
(207, 1, 101, 'Page Header', 101, 1, 1, 0, 0, 0, 0, 0),
(207, 1, 102, 'Main', 102, 0, 1, 0, 0, 0, 0, 0),
(208, 1, 40, 'Page Header', 40, 0, 0, 0, 0, 0, 0, 0),
(208, 1, 42, 'Sidebar', 42, 0, 0, 0, 0, 0, 0, 0),
(208, 1, 43, 'Sidebar', 43, 1, 0, 0, 0, 0, 0, 0),
(208, 1, 44, 'Sidebar', 44, 2, 0, 0, 0, 0, 0, 0),
(208, 1, 46, 'Page Footer', 46, 0, 0, 0, 0, 0, 0, 0),
(208, 1, 47, 'Page Footer', 47, 1, 0, 0, 0, 0, 0, 0),
(208, 1, 103, 'Page Header', 103, 1, 1, 0, 0, 0, 0, 0),
(208, 1, 104, 'Main', 104, 0, 1, 0, 0, 0, 0, 0),
(209, 1, 40, 'Page Header', 40, 0, 0, 0, 0, 0, 0, 0),
(209, 1, 42, 'Sidebar', 42, 0, 0, 0, 0, 0, 0, 0),
(209, 1, 43, 'Sidebar', 43, 1, 0, 0, 0, 0, 0, 0),
(209, 1, 44, 'Sidebar', 44, 2, 0, 0, 0, 0, 0, 0),
(209, 1, 46, 'Page Footer', 46, 0, 0, 0, 0, 0, 0, 0),
(209, 1, 47, 'Page Footer', 47, 1, 0, 0, 0, 0, 0, 0),
(209, 1, 105, 'Page Header', 105, 1, 1, 0, 0, 0, 0, 0),
(209, 1, 106, 'Main', 106, 0, 1, 0, 0, 0, 0, 0),
(210, 1, 40, 'Page Header', 40, 0, 0, 0, 0, 0, 0, 0),
(210, 1, 42, 'Sidebar', 42, 0, 0, 0, 0, 0, 0, 0),
(210, 1, 43, 'Sidebar', 43, 1, 0, 0, 0, 0, 0, 0),
(210, 1, 44, 'Sidebar', 44, 2, 0, 0, 0, 0, 0, 0),
(210, 1, 46, 'Page Footer', 46, 0, 0, 0, 0, 0, 0, 0),
(210, 1, 47, 'Page Footer', 47, 1, 0, 0, 0, 0, 0, 0),
(210, 1, 107, 'Page Header', 107, 1, 1, 0, 0, 0, 0, 0),
(210, 1, 108, 'Main', 108, 0, 1, 0, 0, 0, 0, 0),
(211, 1, 22, 'Main', 22, 0, 1, 0, 0, 0, 0, 0),
(211, 1, 23, 'Main', 23, 1, 1, 0, 0, 0, 0, 0),
(211, 1, 24, 'Sidebar', 24, 0, 1, 0, 0, 0, 0, 0),
(211, 1, 25, 'Sidebar', 25, 1, 1, 0, 0, 0, 0, 0),
(211, 1, 26, 'Sidebar', 26, 2, 1, 0, 0, 0, 0, 0),
(211, 1, 27, 'Sidebar', 27, 3, 1, 0, 0, 0, 0, 0),
(211, 1, 28, 'Page Footer', 28, 0, 1, 0, 0, 0, 0, 0),
(211, 1, 29, 'Page Footer', 29, 1, 1, 0, 0, 0, 0, 0),
(212, 1, 22, 'Main', 22, 0, 0, 0, 0, 0, 0, 0),
(212, 1, 24, 'Sidebar', 24, 0, 0, 0, 0, 0, 0, 0),
(212, 1, 25, 'Sidebar', 25, 1, 0, 0, 0, 0, 0, 0),
(212, 1, 26, 'Sidebar', 26, 2, 0, 0, 0, 0, 0, 0),
(212, 1, 27, 'Sidebar', 27, 3, 0, 0, 0, 0, 0, 0),
(212, 1, 28, 'Page Footer', 28, 0, 0, 0, 0, 0, 0, 0),
(212, 1, 125, 'Page Footer', 125, 1, 1, 0, 0, 0, 0, 0),
(212, 1, 126, 'Main', 126, 1, 1, 0, 0, 0, 0, 0),
(213, 1, 22, 'Main', 22, 0, 0, 0, 0, 0, 0, 0),
(213, 1, 24, 'Sidebar', 24, 0, 0, 0, 0, 0, 0, 0),
(213, 1, 25, 'Sidebar', 25, 1, 0, 0, 0, 0, 0, 0),
(213, 1, 26, 'Sidebar', 26, 2, 0, 0, 0, 0, 0, 0),
(213, 1, 27, 'Sidebar', 27, 3, 0, 0, 0, 0, 0, 0),
(213, 1, 28, 'Page Footer', 28, 0, 0, 0, 0, 0, 0, 0),
(213, 1, 127, 'Page Footer', 127, 1, 1, 0, 0, 0, 0, 0),
(213, 1, 128, 'Main', 128, 1, 1, 0, 0, 0, 0, 0),
(214, 1, 22, 'Main', 22, 0, 0, 0, 0, 0, 0, 0),
(214, 1, 24, 'Sidebar', 24, 0, 0, 0, 0, 0, 0, 0),
(214, 1, 25, 'Sidebar', 25, 1, 0, 0, 0, 0, 0, 0),
(214, 1, 26, 'Sidebar', 26, 2, 0, 0, 0, 0, 0, 0),
(214, 1, 27, 'Sidebar', 27, 3, 0, 0, 0, 0, 0, 0),
(214, 1, 28, 'Page Footer', 28, 0, 0, 0, 0, 0, 0, 0),
(214, 1, 129, 'Page Footer', 129, 1, 1, 0, 0, 0, 0, 0),
(214, 1, 130, 'Main', 130, 1, 1, 0, 0, 0, 0, 0),
(215, 1, 143, 'Main', 143, 0, 1, 0, 0, 0, 0, 0),
(215, 1, 144, 'Main', 144, 1, 1, 0, 0, 0, 0, 0),
(215, 1, 145, 'Main : 43', 145, 0, 1, 0, 0, 0, 0, 0),
(215, 1, 146, 'Main : 44', 146, 0, 1, 0, 0, 0, 0, 0),
(215, 1, 147, 'Main : 44', 147, 1, 1, 0, 0, 0, 0, 0),
(215, 1, 148, 'Main', 148, 2, 1, 0, 0, 0, 0, 0),
(215, 1, 149, 'Main', 149, 3, 1, 0, 0, 0, 0, 0),
(215, 1, 150, 'Main : 45', 150, 0, 1, 0, 0, 0, 0, 0),
(215, 1, 151, 'Main : 46', 151, 0, 1, 0, 0, 0, 0, 0),
(215, 1, 152, 'Main : 46', 152, 1, 1, 0, 0, 0, 0, 0),
(215, 1, 153, 'Main : 46', 153, 2, 1, 0, 0, 0, 0, 0),
(215, 1, 154, 'Main', 154, 4, 1, 0, 0, 0, 0, 0),
(215, 1, 155, 'Main', 155, 5, 1, 0, 0, 0, 0, 0),
(215, 1, 156, 'Main : 47', 156, 0, 1, 0, 0, 0, 0, 0),
(215, 1, 157, 'Main : 48', 157, 0, 1, 0, 0, 0, 0, 0),
(216, 1, 158, 'Main', 158, 0, 1, 0, 0, 0, 0, 0),
(216, 1, 159, 'Main', 159, 1, 1, 0, 0, 0, 0, 0),
(216, 1, 160, 'Main', 160, 2, 1, 0, 0, 0, 0, 0),
(216, 1, 161, 'Main', 161, 3, 1, 0, 0, 0, 0, 0),
(216, 1, 162, 'Main : 49', 162, 0, 1, 0, 0, 0, 0, 0),
(216, 1, 163, 'Main : 49', 163, 1, 1, 0, 0, 0, 0, 0),
(216, 1, 164, 'Main : 50', 164, 0, 1, 0, 0, 0, 0, 0),
(216, 1, 165, 'Main : 50', 165, 1, 1, 0, 0, 0, 0, 0),
(216, 1, 166, 'Main : 51', 166, 0, 1, 0, 0, 0, 0, 0),
(216, 1, 167, 'Main : 51', 167, 1, 1, 0, 0, 0, 0, 0),
(216, 1, 168, 'Main', 168, 4, 1, 0, 0, 0, 0, 0),
(216, 1, 169, 'Main', 169, 5, 1, 0, 0, 0, 0, 0),
(216, 1, 170, 'Main : 52', 170, 0, 1, 0, 0, 0, 0, 0),
(216, 1, 171, 'Main : 53', 171, 0, 1, 0, 0, 0, 0, 0),
(217, 1, 174, 'Main', 174, 0, 1, 0, 0, 0, 0, 0),
(217, 1, 175, 'Main', 175, 1, 1, 0, 0, 0, 0, 0),
(218, 1, 30, 'Page Header', 30, 0, 1, 0, 0, 0, 0, 0),
(218, 1, 31, 'Sidebar', 31, 0, 1, 0, 0, 0, 0, 0),
(218, 1, 32, 'Main', 32, 0, 1, 0, 0, 0, 0, 0),
(218, 1, 33, 'Main', 33, 1, 1, 0, 0, 0, 0, 0),
(218, 1, 34, 'Main', 34, 2, 1, 0, 0, 0, 0, 0),
(218, 1, 35, 'Main', 35, 3, 1, 0, 0, 0, 0, 0),
(218, 1, 36, 'Main', 36, 4, 1, 0, 0, 0, 0, 0),
(218, 1, 37, 'Main', 37, 5, 1, 0, 0, 0, 0, 0),
(218, 1, 38, 'Main', 38, 6, 1, 0, 0, 0, 0, 0),
(218, 1, 39, 'Main', 39, 7, 1, 0, 0, 0, 0, 0),
(219, 1, 30, 'Page Header', 30, 0, 0, 0, 0, 0, 0, 0),
(219, 1, 31, 'Sidebar', 31, 0, 0, 0, 0, 0, 0, 0),
(219, 1, 32, 'Main', 32, 0, 0, 0, 0, 0, 0, 0),
(219, 1, 33, 'Main', 33, 1, 0, 0, 0, 0, 0, 0),
(219, 1, 34, 'Main', 34, 2, 0, 0, 0, 0, 0, 0),
(219, 1, 35, 'Main', 35, 3, 0, 0, 0, 0, 0, 0),
(219, 1, 36, 'Main', 36, 4, 0, 0, 0, 0, 0, 0),
(219, 1, 37, 'Main', 37, 5, 0, 0, 0, 0, 0, 0),
(219, 1, 39, 'Main', 39, 7, 0, 0, 0, 0, 0, 0),
(219, 1, 172, 'Main', 172, 6, 1, 0, 0, 0, 0, 0),
(220, 1, 30, 'Page Header', 30, 0, 0, 0, 0, 0, 0, 0),
(220, 1, 31, 'Sidebar', 31, 0, 0, 0, 0, 0, 0, 0),
(220, 1, 32, 'Main', 32, 0, 0, 0, 0, 0, 0, 0),
(220, 1, 33, 'Main', 33, 1, 0, 0, 0, 0, 0, 0),
(220, 1, 34, 'Main', 34, 2, 0, 0, 0, 0, 0, 0),
(220, 1, 35, 'Main', 35, 3, 0, 0, 0, 0, 0, 0),
(220, 1, 36, 'Main', 36, 4, 0, 0, 0, 0, 0, 0),
(220, 1, 37, 'Main', 37, 5, 0, 0, 0, 0, 0, 0),
(220, 1, 39, 'Main', 39, 7, 0, 0, 0, 0, 0, 0),
(220, 1, 173, 'Main', 173, 6, 1, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `CollectionVersionBlocksCacheSettings`
--

CREATE TABLE `CollectionVersionBlocksCacheSettings` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '1',
  `bID` int(10) unsigned NOT NULL DEFAULT '0',
  `arHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `btCacheBlockOutput` tinyint(1) NOT NULL DEFAULT '0',
  `btCacheBlockOutputOnPost` tinyint(1) NOT NULL DEFAULT '0',
  `btCacheBlockOutputForRegisteredUsers` tinyint(1) NOT NULL DEFAULT '0',
  `btCacheBlockOutputLifetime` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`bID`,`arHandle`),
  KEY `bID` (`bID`,`cID`,`cvID`,`arHandle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `CollectionVersionBlocksCacheSettings`
--

INSERT INTO `CollectionVersionBlocksCacheSettings` VALUES
(190, 1, 61, 'Main', 1, 1, 1, 3600);

-- --------------------------------------------------------

--
-- Table structure for table `CollectionVersionBlocksOutputCache`
--

CREATE TABLE `CollectionVersionBlocksOutputCache` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '1',
  `bID` int(10) unsigned NOT NULL DEFAULT '0',
  `arHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `btCachedBlockOutput` longtext COLLATE utf8_unicode_ci,
  `btCachedBlockOutputExpires` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`bID`,`arHandle`),
  KEY `bID` (`bID`,`cID`,`cvID`,`arHandle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `CollectionVersionBlockStyles`
--

CREATE TABLE `CollectionVersionBlockStyles` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '0',
  `bID` int(10) unsigned NOT NULL DEFAULT '0',
  `arHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `issID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`bID`,`arHandle`),
  KEY `bID` (`bID`,`issID`),
  KEY `issID` (`issID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `CollectionVersionBlockStyles`
--

INSERT INTO `CollectionVersionBlockStyles` VALUES
(170, 1, 13, 'Main', 1),
(211, 1, 24, 'Sidebar', 2),
(212, 1, 24, 'Sidebar', 2),
(213, 1, 24, 'Sidebar', 2),
(214, 1, 24, 'Sidebar', 2),
(211, 1, 25, 'Sidebar', 3),
(212, 1, 25, 'Sidebar', 3),
(213, 1, 25, 'Sidebar', 3),
(214, 1, 25, 'Sidebar', 3),
(218, 1, 31, 'Sidebar', 4),
(219, 1, 31, 'Sidebar', 4),
(220, 1, 31, 'Sidebar', 4),
(198, 1, 50, 'Main : 13', 5),
(199, 1, 50, 'Main : 13', 5),
(198, 1, 51, 'Main : 14', 6),
(199, 1, 51, 'Main : 14', 6),
(198, 1, 52, 'Main : 14', 7),
(199, 1, 52, 'Main : 14', 7),
(195, 1, 54, 'Main', 8),
(196, 1, 54, 'Main', 8),
(1, 1, 66, 'Main : 15', 9),
(1, 1, 67, 'Main : 16', 10),
(1, 1, 68, 'Main : 17', 11),
(1, 1, 70, 'Main', 12),
(1, 1, 77, 'Main : 20', 13),
(1, 1, 78, 'Main : 21', 14),
(197, 1, 111, 'Main : 31', 17),
(197, 1, 112, 'Main : 32', 18),
(197, 1, 115, 'Main : 33', 19),
(197, 1, 116, 'Main : 33', 20),
(197, 1, 117, 'Main : 34', 21),
(197, 1, 118, 'Main : 34', 22),
(197, 1, 119, 'Main : 35', 23),
(197, 1, 120, 'Main : 35', 24),
(197, 1, 123, 'Main : 36', 25),
(201, 1, 138, 'Main : 40', 26),
(215, 1, 156, 'Main : 47', 27),
(216, 1, 171, 'Main : 53', 28);

-- --------------------------------------------------------

--
-- Table structure for table `CollectionVersionFeatureAssignments`
--

CREATE TABLE `CollectionVersionFeatureAssignments` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '1',
  `faID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`faID`),
  KEY `faID` (`faID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `CollectionVersionFeatureAssignments`
--

INSERT INTO `CollectionVersionFeatureAssignments` VALUES
(211, 1, 1),
(197, 1, 2),
(212, 1, 3),
(213, 1, 4),
(214, 1, 5),
(201, 1, 6),
(215, 1, 7),
(215, 1, 8),
(215, 1, 9),
(216, 1, 10);

-- --------------------------------------------------------

--
-- Table structure for table `CollectionVersionRelatedEdits`
--

CREATE TABLE `CollectionVersionRelatedEdits` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '0',
  `cRelationID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvRelationID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`cRelationID`,`cvRelationID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `CollectionVersions`
--

CREATE TABLE `CollectionVersions` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '1',
  `cvName` text COLLATE utf8_unicode_ci,
  `cvHandle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cvDescription` text COLLATE utf8_unicode_ci,
  `cvDatePublic` datetime DEFAULT NULL,
  `cvDateCreated` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `cvComments` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cvIsApproved` tinyint(1) NOT NULL DEFAULT '0',
  `cvIsNew` tinyint(1) NOT NULL DEFAULT '0',
  `cvAuthorUID` int(10) unsigned DEFAULT NULL,
  `cvApproverUID` int(10) unsigned DEFAULT NULL,
  `pThemeID` int(10) unsigned NOT NULL DEFAULT '0',
  `pTemplateID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvActivateDatetime` datetime DEFAULT NULL,
  `cvPublishDate` datetime DEFAULT NULL,
  `cvPublishEndDate` datetime DEFAULT NULL,
  `cvDateApproved` datetime DEFAULT NULL,
  PRIMARY KEY (`cID`,`cvID`),
  KEY `cvIsApproved` (`cvIsApproved`),
  KEY `cvAuthorUID` (`cvAuthorUID`),
  KEY `cvApproverUID` (`cvApproverUID`),
  KEY `pThemeID` (`pThemeID`),
  KEY `pTemplateID` (`pTemplateID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `CollectionVersions`
--

INSERT INTO `CollectionVersions` VALUES
(1, 1, 'Home', '', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 5, NULL, NULL, NULL, NULL),
(2, 1, 'Dashboard', 'dashboard', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(3, 1, 'Sitemap', 'sitemap', 'Whole world at a glance.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(4, 1, 'Full Sitemap', 'full', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(5, 1, 'Flat View', 'explore', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(6, 1, 'Page Search', 'search', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(7, 1, 'Files', 'files', 'All documents and images.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(8, 1, 'File Manager', 'search', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(9, 1, 'Attributes', 'attributes', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(10, 1, 'File Sets', 'sets', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(11, 1, 'Add File Set', 'add_set', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(12, 1, 'Members', 'users', 'Add and manage the user accounts and groups on your website.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(13, 1, 'Search Users', 'search', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(14, 1, 'User Groups', 'groups', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(15, 1, 'Send Message to Group', 'message', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(16, 1, 'Attributes', 'attributes', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(17, 1, 'Add User', 'add', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(18, 1, 'Add Group', 'add_group', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(19, 1, 'Move Multiple Groups', 'bulkupdate', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(20, 1, 'Group Sets', 'group_sets', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(21, 1, 'Community Points', 'points', NULL, '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(22, 1, 'Assign Points', 'assign', NULL, '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(23, 1, 'Actions', 'actions', NULL, '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(24, 1, 'Express', 'express', 'Express Data Objects', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(25, 1, 'View Entries', 'entries', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(26, 1, 'Reports', 'reports', 'Get data from forms and logs.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(27, 1, 'Form Results', 'forms', 'Get submission data.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(28, 1, 'Form Results', 'legacy', 'Get submission data.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(29, 1, 'Surveys', 'surveys', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(30, 1, 'Logs', 'logs', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(31, 1, 'Page Changes', 'page_changes', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(32, 1, 'Pages & Themes', 'pages', 'Reskin your site.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(33, 1, 'Themes', 'themes', 'Reskin your site.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(34, 1, 'Inspect', 'inspect', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(35, 1, 'Page Types', 'types', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(36, 1, 'Organize Page Type Order', 'organize', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(37, 1, 'Add Page Type', 'add', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(38, 1, 'Compose Form', 'form', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(39, 1, 'Defaults and Output', 'output', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(40, 1, 'Page Type Attributes', 'attributes', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(41, 1, 'Page Type Permissions', 'permissions', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(42, 1, 'Page Templates', 'templates', 'Form factors for pages in your site.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(43, 1, 'Add Page Template', 'add', 'Add page templates to your site.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(44, 1, 'Attributes', 'attributes', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(45, 1, 'Single Pages', 'single', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(46, 1, 'RSS Feeds', 'feeds', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(47, 1, 'Calendar & Events', 'calendar', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(48, 1, 'View Calendar', 'events', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(49, 1, 'Event List', 'event_list', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(50, 1, 'Add Calendar', 'add', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(51, 1, 'Permissions', 'permissions', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(52, 1, 'Attributes', 'attributes', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(53, 1, 'Conversations', 'conversations', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(54, 1, 'Messages', 'messages', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(55, 1, 'Stacks & Blocks', 'blocks', 'Manage sitewide content and administer block types.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(56, 1, 'Stacks & Global Areas', 'stacks', 'Share content across your site.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(57, 1, 'Block & Stack Permissions', 'permissions', 'Control who can add blocks and stacks on your site.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(58, 1, 'Stack List', 'list', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(59, 1, 'Block Types', 'types', 'Manage the installed block types in your site.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(60, 1, 'Extend Concrete', 'extend', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(61, 1, 'Add Functionality', 'install', 'Install add-ons & themes.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(62, 1, 'Update Add-Ons', 'update', 'Update your installed packages.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(63, 1, 'Connect to the Community', 'connect', 'Connect to the Concrete community.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(64, 1, 'Get More Themes', 'themes', 'Download themes from the marketplace.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(65, 1, 'Get More Add-Ons', 'addons', 'Download add-ons from the marketplace.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(66, 1, 'System & Settings', 'system', 'Secure and setup your site.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(67, 1, 'Basics', 'basics', 'Basic information about your website.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(68, 1, 'Name & Attributes', 'name', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(69, 1, 'Accessibility', 'accessibility', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(70, 1, 'Social Links', 'social', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(71, 1, 'Bookmark Icons', 'icons', 'Bookmark icon and mobile home screen icon setup.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(72, 1, 'Rich Text Editor', 'editor', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(73, 1, 'Languages', 'multilingual', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(74, 1, 'Update Languages', 'update', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(75, 1, 'Time Zone', 'timezone', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(76, 1, 'Custom Attributes', 'attributes', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(77, 1, 'Reset Edit Mode', 'reset_edit_mode', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(78, 1, 'Express', 'express', 'Express', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(79, 1, 'Data Objects', 'entities', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(80, 1, 'Attributes', 'attributes', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(81, 1, 'Associations', 'associations', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(82, 1, 'Forms', 'forms', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(83, 1, 'Customize Search', 'customize_search', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(84, 1, 'Update Entry Display Order', 'order_entries', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(85, 1, 'Custom Entry Locations', 'entries', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(86, 1, 'Multiple Site Hosting', 'multisite', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(87, 1, 'Sites & Domains', 'sites', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(88, 1, 'Site Types', 'types', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(89, 1, 'Multisite Settings', 'settings', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(90, 1, 'Multilingual', 'multilingual', 'Run your site in multiple languages.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(91, 1, 'Multilingual Setup', 'setup', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(92, 1, 'Copy Languages', 'copy', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(93, 1, 'Page Report', 'page_report', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(94, 1, 'Translate Site Interface', 'translate_interface', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(95, 1, 'SEO & Statistics', 'seo', 'Enable pretty URLs and tracking codes.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(96, 1, 'URLs and Redirection', 'urls', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(97, 1, 'Bulk SEO Updater', 'bulk', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(98, 1, 'Tracking Codes', 'codes', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(99, 1, 'Excluded URL Word List', 'excluded', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(100, 1, 'Search Index', 'searchindex', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(101, 1, 'Files', 'files', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(102, 1, 'Allowed File Types', 'filetypes', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(103, 1, 'File Manager Permissions', 'permissions', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(104, 1, 'Thumbnails', 'thumbnails', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(105, 1, 'Thumbnail Options', 'options', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(106, 1, 'Image Options', 'image_uploading', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(107, 1, 'File Storage Locations', 'storage', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(108, 1, 'Export Options', 'export_options', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(109, 1, 'Optimization', 'optimization', 'Keep your site running well.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(110, 1, 'Cache & Speed Settings', 'cache', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(111, 1, 'Clear Cache', 'clearcache', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(112, 1, 'Automated Jobs', 'jobs', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(113, 1, 'Permissions & Access', 'permissions', 'Control who sees and edits your site.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(114, 1, 'Site Access', 'site', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(115, 1, 'Task Permissions', 'tasks', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(116, 1, 'User Permissions', 'users', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(117, 1, 'Advanced Permissions', 'advanced', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(118, 1, 'Workflows', 'workflows', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(119, 1, 'IP Blacklist', 'blacklist', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(120, 1, 'Configure IP Blocking', 'configure', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(121, 1, 'IP Range', 'range', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(122, 1, 'Captcha Setup', 'captcha', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(123, 1, 'Spam Control', 'antispam', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(124, 1, 'Maintenance Mode', 'maintenance', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(125, 1, 'Trusted Proxies', 'trusted_proxies', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(126, 1, 'Login & Registration', 'registration', 'Change login behaviors and setup public profiles.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(127, 1, 'Account Options', 'open', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(128, 1, 'Login Destination', 'postlogin', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(129, 1, 'Public Profiles', 'profiles', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(130, 1, 'Authentication Types', 'authentication', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(131, 1, 'Global Password Reset', 'global_password_reset', 'Signs out all users, resets all passwords and forces users to choose a new one', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(132, 1, 'Notification Settings', 'notification', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(133, 1, 'User Deactivation Settings', 'deactivation', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(134, 1, 'Automated Logout', 'automated_logout', 'Automate when users are logged out, or do it manually', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(135, 1, 'Password Requirements', 'password_requirements', 'Set password rule and regulations.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(136, 1, 'Session Options', 'session_options', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(137, 1, 'Email', 'mail', 'Control how your site send and processes mail.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(138, 1, 'SMTP Method', 'method', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(139, 1, 'Test Mail Settings', 'test', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(140, 1, 'Email Importers', 'importers', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(141, 1, 'System Email Addresses', 'addresses', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(142, 1, 'Calendar', 'calendar', 'Manage your calendar settings', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(143, 1, 'General Settings', 'settings', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(144, 1, 'Color Settings', 'colors', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(145, 1, 'Permissions', 'permissions', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(146, 1, 'Import Calendar Data', 'import', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(147, 1, 'Conversations', 'conversations', 'Manage your conversations settings', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(148, 1, 'Settings', 'settings', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(149, 1, 'Community Points', 'points', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(150, 1, 'Banned Words', 'bannedwords', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(151, 1, 'Conversation Permissions', 'permissions', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(152, 1, 'Attributes', 'attributes', 'Setup attributes for pages, users, files and more.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(153, 1, 'Types', 'types', 'Choose which attribute types are available for different items.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(154, 1, 'Sets', 'sets', 'Group attributes into sets for easier organization', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(155, 1, 'Topics', 'topics', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(156, 1, 'Add Topic Tree', 'add', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(157, 1, 'Environment', 'environment', 'Advanced settings for web developers.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(158, 1, 'Environment Information', 'info', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(159, 1, 'Debug Settings', 'debug', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(160, 1, 'Logging Settings', 'logging', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(161, 1, 'Proxy Server', 'proxy', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(162, 1, 'Database Entities', 'entities', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(163, 1, 'Database Character Set', 'database_charset', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(164, 1, 'Geolocation', 'geolocation', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(165, 1, 'Update Concrete', 'update', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(166, 1, 'Apply Update', 'update', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(167, 1, 'API', 'api', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(168, 1, 'API Settings', 'settings', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(169, 1, 'API Integrations', 'integrations', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(170, 1, 'Welcome', 'welcome', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(171, 1, 'Waiting for Me', 'me', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 2, NULL, NULL, NULL, NULL),
(172, 1, 'Stacks', '!stacks', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(173, 1, 'Page Not Found', 'page_not_found', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(174, 1, 'Trash', '!trash', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(175, 1, 'Login', 'login', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(176, 1, 'Register', 'register', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(177, 1, 'My Account', 'account', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(178, 1, 'Edit Profile', 'edit_profile', 'Edit your user profile and change password.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(179, 1, 'Profile Picture', 'avatar', 'Specify a new image attached to posts or edits.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(180, 1, 'Private Messages', 'messages', 'Inbox for site-specific messages.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(181, 1, 'Page Forbidden', 'page_forbidden', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(182, 1, 'Download File', 'download_file', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(183, 1, 'Drafts', '!drafts', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(184, 1, 'Welcome Back', 'desktop', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 0, 0, NULL, NULL, NULL, NULL),
(185, 1, 'Footer Contact', 'footer-contact', NULL, '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 0, NULL, NULL, NULL, NULL),
(186, 1, 'Footer Legal', 'footer-legal', NULL, '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 0, NULL, NULL, NULL, NULL),
(187, 1, 'Footer Navigation', 'footer-navigation', NULL, '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 0, NULL, NULL, NULL, NULL),
(188, 1, 'Footer Site Title', 'footer-site-title', NULL, '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 0, NULL, NULL, NULL, NULL),
(189, 1, 'Footer Social', 'footer-social', NULL, '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 0, NULL, NULL, NULL, NULL),
(190, 1, 'Header Navigation', 'header-navigation', NULL, '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 0, NULL, NULL, NULL, NULL),
(191, 1, 'Header Search', 'header-search', NULL, '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 0, NULL, NULL, NULL, NULL),
(192, 1, 'Header Site Title', 'header-site-title', NULL, '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 0, NULL, NULL, NULL, NULL),
(193, 1, '', NULL, NULL, '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, NULL, NULL, 0, 5, NULL, NULL, NULL, NULL),
(194, 1, 'Services', 'services', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 5, NULL, NULL, NULL, NULL),
(195, 1, '', NULL, NULL, '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, NULL, NULL, 0, 5, NULL, NULL, NULL, NULL),
(196, 1, 'Portfolio', 'portfolio', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 5, NULL, NULL, NULL, NULL),
(197, 1, 'Team', 'team', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 5, NULL, NULL, NULL, NULL),
(198, 1, '', NULL, NULL, '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, NULL, NULL, 0, 5, NULL, NULL, NULL, NULL),
(199, 1, 'Blog', 'blog', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 5, NULL, NULL, NULL, NULL),
(200, 1, 'Search', 'search', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 5, NULL, NULL, NULL, NULL),
(201, 1, 'Contact', 'contact', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 5, NULL, NULL, NULL, NULL),
(202, 1, '', NULL, NULL, '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, NULL, NULL, 0, 4, NULL, NULL, NULL, NULL),
(203, 1, 'Blank Page', 'blank-page', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 4, NULL, NULL, NULL, NULL),
(204, 1, '', NULL, NULL, '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, NULL, NULL, 0, 6, NULL, NULL, NULL, NULL),
(205, 1, 'Project Title', 'project-title', 'Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing.', '2014-08-06 15:30:00', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 6, NULL, NULL, NULL, NULL),
(206, 1, 'Project Title 2', 'project-title-2', 'Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing.', '2014-08-06 15:20:00', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 6, NULL, NULL, NULL, NULL),
(207, 1, 'Project Title 3', 'project-title-3', 'Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing.', '2014-08-06 15:10:00', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 6, NULL, NULL, NULL, NULL),
(208, 1, 'Project Title 4', 'project-title-4', 'Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing.', '2014-08-06 15:00:00', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 6, NULL, NULL, NULL, NULL),
(209, 1, 'Project Title 5', 'project-title-5', 'Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing.', '2014-08-06 14:30:00', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 6, NULL, NULL, NULL, NULL),
(210, 1, 'Project Title 6', 'project-title-6', 'Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing.', '2014-08-06 14:20:00', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 6, NULL, NULL, NULL, NULL),
(211, 1, '', NULL, NULL, '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, NULL, NULL, 0, 7, NULL, NULL, NULL, NULL),
(212, 1, 'Hello World!', 'hello-world', 'Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. Quisque dignissim neque a ipsum sodales, mattis aliquam ante dictum.', '2014-07-01 12:00:00', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 7, NULL, NULL, NULL, NULL),
(213, 1, 'Another Blog Post', 'another-blog-post', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam sit amet consectetur lacus. Vestibulum neque lectus, egestas non cursus vitae, aliquam at magna.', '2014-07-04 15:00:00', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 7, NULL, NULL, NULL, NULL),
(214, 1, 'A Beautiful Site Deserves a Beautiful Blog', 'a-beautiful-blog', 'Donec blandit lectus nec neque ullamcorper rhoncus. Sed adipiscing tempus sem eu molestie. Aenean laoreet pretium ante vitae ultrices. Aenean eu gravida magna, vel aliquet magna. In auctor convallis gravida. Phasellus est erat.', '2014-08-01 16:30:00', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 7, NULL, NULL, NULL, NULL),
(215, 1, 'About', 'about', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 5, NULL, NULL, NULL, NULL),
(216, 1, 'Careers', 'careers', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 5, NULL, NULL, NULL, NULL),
(217, 1, 'Frequently Asked Questions', 'faq', '', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 5, NULL, NULL, NULL, NULL),
(218, 1, '', NULL, NULL, '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, NULL, NULL, 0, 6, NULL, NULL, NULL, NULL),
(219, 1, 'Web Developer', 'web-developer', 'Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. Sed consequat eleifend metus, vitae malesuada eros elementum sed. Fusce risus felis, viverra et dignissim at, lobortis non est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam sit amet consectetur lacus.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 6, NULL, NULL, NULL, NULL),
(220, 1, 'Sales Associate', 'sales-associate', 'Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. Sed consequat eleifend metus, vitae malesuada eros elementum sed. Fusce risus felis, viverra et dignissim at, lobortis non est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam sit amet consectetur lacus.', '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, 1, NULL, 1, 6, NULL, NULL, NULL, NULL),
(221, 1, '', NULL, NULL, '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, NULL, NULL, 0, 6, NULL, NULL, NULL, NULL),
(222, 1, '', NULL, NULL, '[[date_gmt]]', '[[date_gmt]]', 'Initial Version', 1, 0, NULL, NULL, 0, 7, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `CollectionVersionThemeCustomStyles`
--

CREATE TABLE `CollectionVersionThemeCustomStyles` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '1',
  `pThemeID` int(10) unsigned NOT NULL DEFAULT '0',
  `scvlID` int(10) unsigned DEFAULT '0',
  `preset` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sccRecordID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`cID`,`cvID`,`pThemeID`),
  KEY `pThemeID` (`pThemeID`),
  KEY `scvlID` (`scvlID`),
  KEY `sccRecordID` (`sccRecordID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `Config`
--

CREATE TABLE `Config` (
  `configNamespace` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `configGroup` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `configItem` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `configValue` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`configNamespace`,`configGroup`,`configItem`),
  KEY `configGroup` (`configGroup`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `Config`
--

INSERT INTO `Config` VALUES
('', 'app', 'privacy_policy_accepted', '1'),
('', 'concrete', 'security.token.encryption', '[[SECURITY_TOKEN_ENCRYPTION]]'),
('', 'concrete', 'security.token.jobs', '[[SECURITY_TOKEN_JOBS]]'),
('', 'concrete', 'security.token.validation', '[[SECURITY_TOKEN_VALIDATION]]');

-- --------------------------------------------------------

--
-- Table structure for table `ConfigStore`
--

CREATE TABLE `ConfigStore` (
  `cfKey` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `cfValue` longtext COLLATE utf8_unicode_ci,
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cfKey`,`uID`),
  KEY `uID` (`uID`,`cfKey`),
  KEY `pkgID` (`pkgID`,`cfKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ConversationDiscussions`
--

CREATE TABLE `ConversationDiscussions` (
  `cnvDiscussionID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cnvDiscussionDateCreated` datetime NOT NULL,
  `cID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`cnvDiscussionID`),
  KEY `cID` (`cID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ConversationEditors`
--

CREATE TABLE `ConversationEditors` (
  `cnvEditorID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cnvEditorHandle` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cnvEditorName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cnvEditorIsActive` tinyint(1) NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cnvEditorID`),
  KEY `pkgID` (`pkgID`,`cnvEditorHandle`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `ConversationEditors`
--

INSERT INTO `ConversationEditors` VALUES
(1, 'plain_text', 'Plain Text', 1, 0),
(2, 'markdown', 'Markdown', 0, 0),
(3, 'rich_text', 'Rich Text', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `ConversationFeatureDetailAssignments`
--

CREATE TABLE `ConversationFeatureDetailAssignments` (
  `faID` int(10) unsigned NOT NULL DEFAULT '0',
  `cnvID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`faID`),
  KEY `cnvID` (`cnvID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `ConversationFeatureDetailAssignments`
--

INSERT INTO `ConversationFeatureDetailAssignments` VALUES
(1, 1),
(3, 2),
(4, 3),
(5, 4);

-- --------------------------------------------------------

--
-- Table structure for table `ConversationFlaggedMessages`
--

CREATE TABLE `ConversationFlaggedMessages` (
  `cnvMessageID` int(10) unsigned NOT NULL,
  `cnvMessageFlagTypeID` int(11) DEFAULT NULL,
  PRIMARY KEY (`cnvMessageID`),
  KEY `cnvMessageFlagTypeID` (`cnvMessageFlagTypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ConversationFlaggedMessageTypes`
--

CREATE TABLE `ConversationFlaggedMessageTypes` (
  `cnvMessageFlagTypeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cnvMessageFlagTypeHandle` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`cnvMessageFlagTypeID`),
  UNIQUE KEY `cnvMessageFlagTypeHandle` (`cnvMessageFlagTypeHandle`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `ConversationFlaggedMessageTypes`
--

INSERT INTO `ConversationFlaggedMessageTypes` VALUES
(1, 'spam');

-- --------------------------------------------------------

--
-- Table structure for table `ConversationMessageAttachments`
--

CREATE TABLE `ConversationMessageAttachments` (
  `cnvMessageAttachmentID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cnvMessageID` int(11) DEFAULT NULL,
  `fID` int(11) DEFAULT NULL,
  PRIMARY KEY (`cnvMessageAttachmentID`),
  KEY `cnvMessageID` (`cnvMessageID`),
  KEY `fID` (`fID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ConversationMessageNotifications`
--

CREATE TABLE `ConversationMessageNotifications` (
  `cnvMessageID` int(10) unsigned NOT NULL,
  `nID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`nID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ConversationMessageRatings`
--

CREATE TABLE `ConversationMessageRatings` (
  `cnvMessageRatingID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cnvMessageID` int(10) unsigned DEFAULT NULL,
  `cnvRatingTypeID` int(10) unsigned NOT NULL DEFAULT '0',
  `cnvMessageRatingIP` tinyblob,
  `timestamp` datetime DEFAULT NULL,
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cnvMessageRatingID`),
  KEY `cnvMessageID` (`cnvMessageID`,`cnvRatingTypeID`),
  KEY `cnvRatingTypeID` (`cnvRatingTypeID`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ConversationMessages`
--

CREATE TABLE `ConversationMessages` (
  `cnvMessageID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cnvID` int(10) unsigned NOT NULL DEFAULT '0',
  `cnvMessageReview` int(10) unsigned NOT NULL DEFAULT '0',
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  `cnvEditorID` int(10) unsigned NOT NULL DEFAULT '0',
  `cnvMessageAuthorName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cnvMessageAuthorEmail` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cnvMessageAuthorWebsite` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cnvMessageSubmitIP` tinyblob,
  `cnvMessageSubmitUserAgent` longtext COLLATE utf8_unicode_ci,
  `cnvMessageLevel` int(10) unsigned NOT NULL DEFAULT '0',
  `cnvMessageParentID` int(10) unsigned NOT NULL DEFAULT '0',
  `cnvMessageDateCreated` datetime DEFAULT NULL,
  `cnvMessageSubject` text COLLATE utf8_unicode_ci,
  `cnvMessageBody` text COLLATE utf8_unicode_ci,
  `cnvIsMessageDeleted` tinyint(1) NOT NULL DEFAULT '0',
  `cnvIsMessageApproved` tinyint(1) NOT NULL DEFAULT '0',
  `cnvMessageTotalRatingScore` bigint(20) DEFAULT '0',
  PRIMARY KEY (`cnvMessageID`),
  KEY `cnvID` (`cnvID`),
  KEY `cnvMessageParentID` (`cnvMessageParentID`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ConversationPermissionAddMessageAccessList`
--

CREATE TABLE `ConversationPermissionAddMessageAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'A',
  PRIMARY KEY (`paID`,`peID`),
  KEY `peID` (`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ConversationPermissionAssignments`
--

CREATE TABLE `ConversationPermissionAssignments` (
  `cnvID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cnvID`,`pkID`,`paID`),
  KEY `paID` (`paID`),
  KEY `pkID` (`pkID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `ConversationPermissionAssignments`
--

INSERT INTO `ConversationPermissionAssignments` VALUES
(0, 67, 111),
(0, 68, 112),
(0, 71, 113),
(0, 70, 114),
(0, 72, 115),
(0, 69, 116),
(0, 73, 117),
(0, 74, 118);

-- --------------------------------------------------------

--
-- Table structure for table `ConversationRatingTypes`
--

CREATE TABLE `ConversationRatingTypes` (
  `cnvRatingTypeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cnvRatingTypeHandle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cnvRatingTypeName` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cnvRatingTypeCommunityPoints` int(11) DEFAULT NULL,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cnvRatingTypeID`),
  UNIQUE KEY `cnvRatingTypeHandle` (`cnvRatingTypeHandle`),
  KEY `pkgID` (`pkgID`,`cnvRatingTypeHandle`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `ConversationRatingTypes`
--

INSERT INTO `ConversationRatingTypes` VALUES
(1, 'up_vote', 'Up Vote', 1, 0),
(2, 'down_vote', 'Down Vote', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `Conversations`
--

CREATE TABLE `Conversations` (
  `cnvID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cID` int(10) unsigned DEFAULT '0',
  `cnvDateCreated` datetime NOT NULL,
  `cnvDateLastMessage` datetime DEFAULT NULL,
  `cnvParentMessageID` int(10) unsigned DEFAULT '0',
  `cnvAttachmentsEnabled` tinyint(1) NOT NULL DEFAULT '1',
  `cnvMessagesTotal` int(10) unsigned DEFAULT '0',
  `cnvOverrideGlobalPermissions` tinyint(1) DEFAULT '0',
  `cnvAttachmentOverridesEnabled` tinyint(1) NOT NULL DEFAULT '0',
  `cnvMaxFilesGuest` int(11) DEFAULT '0',
  `cnvMaxFilesRegistered` int(11) DEFAULT '0',
  `cnvMaxFileSizeGuest` int(11) DEFAULT '0',
  `cnvMaxFileSizeRegistered` int(11) DEFAULT '0',
  `cnvFileExtensions` text COLLATE utf8_unicode_ci,
  `cnvNotificationOverridesEnabled` tinyint(1) NOT NULL DEFAULT '0',
  `cnvEnableSubscription` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`cnvID`),
  KEY `cID` (`cID`),
  KEY `cnvParentMessageID` (`cnvParentMessageID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `Conversations`
--

INSERT INTO `Conversations` VALUES
(1, 211, '[[date_gmt]]', '[[date_gmt]]', 0, 1, 0, 0, 0, 0, 0, 0, 0, NULL, 0, 0),
(2, 212, '[[date_gmt]]', '[[date_gmt]]', 0, 1, 0, 0, 0, 0, 0, 0, 0, NULL, 0, 0),
(3, 213, '[[date_gmt]]', '[[date_gmt]]', 0, 1, 0, 0, 0, 0, 0, 0, 0, NULL, 0, 0),
(4, 214, '[[date_gmt]]', '[[date_gmt]]', 0, 1, 0, 0, 0, 0, 0, 0, 0, NULL, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `ConversationSubscriptions`
--

CREATE TABLE `ConversationSubscriptions` (
  `cnvID` int(10) unsigned NOT NULL DEFAULT '0',
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  `type` varchar(1) COLLATE utf8_unicode_ci DEFAULT 'S',
  PRIMARY KEY (`cnvID`,`uID`),
  KEY `cnvID` (`cnvID`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `ConversationSubscriptions`
--

INSERT INTO `ConversationSubscriptions` VALUES
(0, 1, 'S');

-- --------------------------------------------------------

--
-- Table structure for table `DownloadStatistics`
--

CREATE TABLE `DownloadStatistics` (
  `dsID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fID` int(10) unsigned NOT NULL,
  `fvID` int(10) unsigned NOT NULL,
  `uID` int(10) unsigned NOT NULL,
  `rcID` int(10) unsigned NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`dsID`),
  KEY `fID` (`fID`,`timestamp`),
  KEY `fvID` (`fID`,`fvID`),
  KEY `uID` (`uID`),
  KEY `rcID` (`rcID`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressAttributeKeys`
--

CREATE TABLE `ExpressAttributeKeys` (
  `entity_id` char(36) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`),
  KEY `IDX_8C881F181257D5D` (`entity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `ExpressAttributeKeys`
--

INSERT INTO `ExpressAttributeKeys` VALUES
('83ae65b1-79e8-4ded-bbca-e419bfd19bb6', 30),
('83ae65b1-79e8-4ded-bbca-e419bfd19bb6', 31),
('83ae65b1-79e8-4ded-bbca-e419bfd19bb6', 32),
('83ae65b1-79e8-4ded-bbca-e419bfd19bb6', 33),
('83ae65b1-79e8-4ded-bbca-e419bfd19bb6', 34);

-- --------------------------------------------------------

--
-- Table structure for table `ExpressEntities`
--

CREATE TABLE `ExpressEntities` (
  `id` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `default_view_form_id` char(36) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `default_edit_form_id` char(36) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `handle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `plural_handle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `label_mask` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `supports_custom_display_order` tinyint(1) NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  `result_column_set` longtext COLLATE utf8_unicode_ci COMMENT '(DC2Type:object)',
  `include_in_public_list` tinyint(1) NOT NULL,
  `entity_results_node_id` int(11) NOT NULL,
  `items_per_page` int(11) NOT NULL,
  `created_date` datetime NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_BC772AA6918020D9` (`handle`),
  UNIQUE KEY `UNIQ_BC772AA6547D6B2D` (`default_view_form_id`),
  UNIQUE KEY `UNIQ_BC772AA6C7DEC56D` (`default_edit_form_id`),
  KEY `IDX_BC772AA6CE45CBB0` (`pkgID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `ExpressEntities`
--

INSERT INTO `ExpressEntities` VALUES
('83ae65b1-79e8-4ded-bbca-e419bfd19bb6', '881b6bde-220f-4482-b8f9-ace40b5d169b', '881b6bde-220f-4482-b8f9-ace40b5d169b', 'Contact', 'express_form_170', '', NULL, 0, '', 'N;', 0, 43, 10, '[[date_gmt]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ExpressEntityAssociationEntries`
--

CREATE TABLE `ExpressEntityAssociationEntries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `association_id` int(11) DEFAULT NULL,
  `displayOrder` int(10) unsigned NOT NULL DEFAULT '0',
  `exEntryID` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_9C2BB76C6DCB6296` (`exEntryID`),
  KEY `IDX_9C2BB76CEFB9C8A5` (`association_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressEntityAssociations`
--

CREATE TABLE `ExpressEntityAssociations` (
  `id` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `source_entity_id` char(36) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `target_entity_id` char(36) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `is_owned_by_association` tinyint(1) NOT NULL,
  `is_owning_association` tinyint(1) NOT NULL,
  `target_property_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inversed_by_property_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `association_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_98A0F796E9BBEE93` (`source_entity_id`),
  KEY `IDX_98A0F796B5910F71` (`target_entity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressEntityEntries`
--

CREATE TABLE `ExpressEntityEntries` (
  `exEntryID` int(11) NOT NULL AUTO_INCREMENT,
  `exEntryDisplayOrder` int(11) NOT NULL,
  `exEntryDateCreated` datetime NOT NULL,
  `exEntryDateModified` datetime DEFAULT NULL,
  `publicIdentifier` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `uID` int(10) unsigned DEFAULT NULL,
  `exEntryEntityID` char(36) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`exEntryID`),
  KEY `IDX_B8AE3531FD71026C` (`uID`),
  KEY `IDX_B8AE3531AFC87D03` (`exEntryEntityID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressEntityEntryAssociations`
--

CREATE TABLE `ExpressEntityEntryAssociations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `association_id` char(36) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `exEntryID` int(11) DEFAULT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_25B3A0826DCB6296` (`exEntryID`),
  KEY `IDX_25B3A082EFB9C8A5` (`association_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressEntityEntryAttributeValues`
--

CREATE TABLE `ExpressEntityEntryAttributeValues` (
  `exEntryID` int(11) NOT NULL,
  `akID` int(10) unsigned NOT NULL,
  `avID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`exEntryID`,`akID`),
  KEY `IDX_6DB641546DCB6296` (`exEntryID`),
  KEY `IDX_6DB64154B6561A7E` (`akID`),
  KEY `IDX_6DB64154A2A82A5D` (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressForm170ExpressSearchIndexAttributes`
--

CREATE TABLE `ExpressForm170ExpressSearchIndexAttributes` (
  `exEntryID` int(11) NOT NULL,
  `ak_contact_question_first_name` longtext COLLATE utf8_unicode_ci,
  `ak_contact_question_last_name` longtext COLLATE utf8_unicode_ci,
  `ak_contact_question_email_address` longtext COLLATE utf8_unicode_ci,
  `ak_contact_question_subject` longtext COLLATE utf8_unicode_ci,
  `ak_contact_question_message` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`exEntryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressFormFieldSetAssociationControls`
--

CREATE TABLE `ExpressFormFieldSetAssociationControls` (
  `id` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `association_id` char(36) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `association_entity_label_mask` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `entry_selector_mode` int(10) unsigned NOT NULL DEFAULT '0',
  `enable_entry_reordering` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_E6DF21BBEFB9C8A5` (`association_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressFormFieldSetAttributeKeyControls`
--

CREATE TABLE `ExpressFormFieldSetAttributeKeyControls` (
  `id` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `akID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_8481F9D1B6561A7E` (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `ExpressFormFieldSetAttributeKeyControls`
--

INSERT INTO `ExpressFormFieldSetAttributeKeyControls` VALUES
('f68175ca-634c-11e6-a245-62e65b165d8e', 30),
('fbc62d32-634c-11e6-a245-62e65b165d8e', 31),
('02181ae2-634d-11e6-a245-62e65b165d8e', 32),
('b3c4ee52-6350-11e6-a245-62e65b165d8e', 33),
('bf4cdc08-6350-11e6-a245-62e65b165d8e', 34);

-- --------------------------------------------------------

--
-- Table structure for table `ExpressFormFieldSetAuthorControls`
--

CREATE TABLE `ExpressFormFieldSetAuthorControls` (
  `id` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressFormFieldSetControls`
--

CREATE TABLE `ExpressFormFieldSetControls` (
  `id` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `field_set_id` int(11) DEFAULT NULL,
  `is_required` tinyint(1) NOT NULL,
  `position` int(11) NOT NULL,
  `custom_label` longtext COLLATE utf8_unicode_ci,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_E42868A43ABF811A` (`field_set_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `ExpressFormFieldSetControls`
--

INSERT INTO `ExpressFormFieldSetControls` VALUES
('02181ae2-634d-11e6-a245-62e65b165d8e', 1, 1, 2, '', 'attributekeycontrol'),
('32a6369e-65a0-11e6-9add-e0995e0a1653', 1, 0, 3, '', 'textcontrol'),
('b3c4ee52-6350-11e6-a245-62e65b165d8e', 1, 0, 4, '', 'attributekeycontrol'),
('bf4cdc08-6350-11e6-a245-62e65b165d8e', 1, 1, 5, '', 'attributekeycontrol'),
('f68175ca-634c-11e6-a245-62e65b165d8e', 1, 1, 0, '', 'attributekeycontrol'),
('fbc62d32-634c-11e6-a245-62e65b165d8e', 1, 1, 1, '', 'attributekeycontrol');

-- --------------------------------------------------------

--
-- Table structure for table `ExpressFormFieldSetPublicIdentifierControls`
--

CREATE TABLE `ExpressFormFieldSetPublicIdentifierControls` (
  `id` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ExpressFormFieldSets`
--

CREATE TABLE `ExpressFormFieldSets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` char(36) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `position` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `IDX_A33BBBEC5FF69B7D` (`form_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `ExpressFormFieldSets`
--

INSERT INTO `ExpressFormFieldSets` VALUES
(1, '881b6bde-220f-4482-b8f9-ace40b5d169b', 0, '', '');

-- --------------------------------------------------------

--
-- Table structure for table `ExpressFormFieldSetTextControls`
--

CREATE TABLE `ExpressFormFieldSetTextControls` (
  `id` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `headline` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `body` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `ExpressFormFieldSetTextControls`
--

INSERT INTO `ExpressFormFieldSetTextControls` VALUES
('32a6369e-65a0-11e6-9add-e0995e0a1653', '', '<div class="alert alert-info">Don&#39;t worry &ndash;&nbsp;we won&#39;t add you to any email list. This is just so we can contact you in case you have questions.</div>\n');

-- --------------------------------------------------------

--
-- Table structure for table `ExpressForms`
--

CREATE TABLE `ExpressForms` (
  `id` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `entity_id` char(36) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_8D09031A81257D5D` (`entity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `ExpressForms`
--

INSERT INTO `ExpressForms` VALUES
('881b6bde-220f-4482-b8f9-ace40b5d169b', '83ae65b1-79e8-4ded-bbca-e419bfd19bb6', 'Form');

-- --------------------------------------------------------

--
-- Table structure for table `FeatureAssignments`
--

CREATE TABLE `FeatureAssignments` (
  `faID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `feID` int(10) unsigned DEFAULT NULL,
  `fcID` int(10) unsigned DEFAULT NULL,
  `fdObject` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`faID`),
  KEY `feID` (`feID`),
  KEY `fcID` (`fcID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=11 ;

--
-- Dumping data for table `FeatureAssignments`
--

INSERT INTO `FeatureAssignments` VALUES
(1, 6, 1, 'O:47:"Concrete\\Core\\Feature\\Detail\\ConversationDetail":3:{s:8:"\0*\0cnvID";s:1:"1";s:7:"\0*\0item";N;s:5:"error";s:0:"";}'),
(2, 5, 1, 'O:40:"Concrete\\Core\\Feature\\Detail\\ImageDetail":5:{s:6:"\0*\0src";s:[[blank2_png_strlen]]:"[[relativeurl]]/application/files/1417/4357/4323/blank2.png";s:8:"\0*\0width";s:3:"250";s:9:"\0*\0height";s:3:"252";s:7:"\0*\0item";N;s:5:"error";s:0:"";}'),
(3, 6, 1, 'O:47:"Concrete\\Core\\Feature\\Detail\\ConversationDetail":3:{s:8:"\0*\0cnvID";s:1:"2";s:7:"\0*\0item";N;s:5:"error";s:0:"";}'),
(4, 6, 1, 'O:47:"Concrete\\Core\\Feature\\Detail\\ConversationDetail":3:{s:8:"\0*\0cnvID";s:1:"3";s:7:"\0*\0item";N;s:5:"error";s:0:"";}'),
(5, 6, 1, 'O:47:"Concrete\\Core\\Feature\\Detail\\ConversationDetail":3:{s:8:"\0*\0cnvID";s:1:"4";s:7:"\0*\0item";N;s:5:"error";s:0:"";}'),
(6, 5, 1, 'O:40:"Concrete\\Core\\Feature\\Detail\\ImageDetail":5:{s:6:"\0*\0src";s:[[chinese_house2]]:"[[relativeurl]]/application/files/1017/4357/4323/chinese_house2.jpg";s:8:"\0*\0width";s:3:"200";s:9:"\0*\0height";s:3:"200";s:7:"\0*\0item";N;s:5:"error";s:0:"";}'),
(7, 5, 1, 'O:40:"Concrete\\Core\\Feature\\Detail\\ImageDetail":5:{s:6:"\0*\0src";s:[[blank_png_strlen]]:"[[relativeurl]]/application/files/8017/4357/4322/blank.png";s:8:"\0*\0width";s:3:"592";s:9:"\0*\0height";s:3:"397";s:7:"\0*\0item";N;s:5:"error";s:0:"";}'),
(8, 5, 1, 'O:40:"Concrete\\Core\\Feature\\Detail\\ImageDetail":5:{s:6:"\0*\0src";s:[[blank_png_strlen]]:"[[relativeurl]]/application/files/8017/4357/4322/blank.png";s:8:"\0*\0width";s:3:"592";s:9:"\0*\0height";s:3:"397";s:7:"\0*\0item";N;s:5:"error";s:0:"";}'),
(9, 5, 1, 'O:40:"Concrete\\Core\\Feature\\Detail\\ImageDetail":5:{s:6:"\0*\0src";s:[[blank2_png_strlen]]:"[[relativeurl]]/application/files/1417/4357/4323/blank2.png";s:8:"\0*\0width";s:3:"250";s:9:"\0*\0height";s:3:"252";s:7:"\0*\0item";N;s:5:"error";s:0:"";}'),
(10, 5, 1, 'O:40:"Concrete\\Core\\Feature\\Detail\\ImageDetail":5:{s:6:"\0*\0src";s:[[masthead_strlen]]:"[[relativeurl]]/application/files/1517/4357/4324/masthead.png";s:8:"\0*\0width";s:4:"1100";s:9:"\0*\0height";s:3:"263";s:7:"\0*\0item";N;s:5:"error";s:0:"";}');

-- --------------------------------------------------------

--
-- Table structure for table `FeatureCategories`
--

CREATE TABLE `FeatureCategories` (
  `fcID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fcHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`fcID`),
  UNIQUE KEY `fcHandle` (`fcHandle`),
  KEY `pkgID` (`pkgID`,`fcID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `FeatureCategories`
--

INSERT INTO `FeatureCategories` VALUES
(1, 'collection_version', 0),
(2, 'gathering_item', 0);

-- --------------------------------------------------------

--
-- Table structure for table `Features`
--

CREATE TABLE `Features` (
  `feID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `feHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `feScore` int(11) NOT NULL DEFAULT '1',
  `feHasCustomClass` tinyint(1) NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`feID`),
  UNIQUE KEY `feHandle` (`feHandle`),
  KEY `pkgID` (`pkgID`,`feID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=9 ;

--
-- Dumping data for table `Features`
--

INSERT INTO `Features` VALUES
(1, 'title', 1, 0, 0),
(2, 'link', 1, 0, 0),
(3, 'author', 1, 0, 0),
(4, 'date_time', 1, 0, 0),
(5, 'image', 500, 1, 0),
(6, 'conversation', 10, 1, 0),
(7, 'description', 1, 0, 0),
(8, 'featured', 1000, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `FileAttributeKeys`
--

CREATE TABLE `FileAttributeKeys` (
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `FileAttributeKeys`
--

INSERT INTO `FileAttributeKeys` VALUES
(16),
(17),
(19);

-- --------------------------------------------------------

--
-- Table structure for table `FileAttributeValues`
--

CREATE TABLE `FileAttributeValues` (
  `fID` int(10) unsigned NOT NULL,
  `fvID` int(10) unsigned NOT NULL,
  `akID` int(10) unsigned NOT NULL,
  `avID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`fID`,`fvID`,`akID`),
  KEY `IDX_BBECEAA4B6561A7E` (`akID`),
  KEY `IDX_BBECEAA4A2A82A5D` (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `FileAttributeValues`
--

INSERT INTO `FileAttributeValues` VALUES
(1, 1, 16, 153),
(1, 1, 17, 154),
(2, 1, 16, 155),
(2, 1, 17, 156),
(3, 1, 16, 157),
(3, 1, 17, 158),
(4, 1, 16, 159),
(4, 1, 17, 160),
(5, 1, 16, 161),
(5, 1, 17, 162),
(6, 1, 16, 163),
(6, 1, 17, 164),
(7, 1, 16, 165),
(7, 1, 17, 166),
(8, 1, 16, 167),
(8, 1, 17, 168),
(9, 1, 16, 169),
(9, 1, 17, 170),
(10, 1, 16, 171),
(10, 1, 17, 172),
(11, 1, 16, 173),
(11, 1, 17, 174),
(12, 1, 16, 175),
(12, 1, 17, 176),
(13, 1, 16, 177),
(13, 1, 17, 178),
(14, 1, 16, 179),
(14, 1, 17, 180),
(15, 1, 16, 181),
(15, 1, 17, 182),
(16, 1, 16, 183),
(16, 1, 17, 184);

-- --------------------------------------------------------

--
-- Table structure for table `FileImageThumbnailPaths`
--

CREATE TABLE `FileImageThumbnailPaths` (
  `fileID` int(10) unsigned NOT NULL,
  `fileVersionID` int(10) unsigned NOT NULL,
  `thumbnailTypeHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `storageLocationID` int(10) unsigned NOT NULL,
  `thumbnailFormat` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `path` longtext COLLATE utf8_unicode_ci NOT NULL,
  `isBuilt` tinyint(1) NOT NULL,
  `lockID` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lockExpires` datetime DEFAULT NULL,
  PRIMARY KEY (`fileID`,`fileVersionID`,`thumbnailTypeHandle`,`storageLocationID`,`thumbnailFormat`),
  KEY `thumbnailPathIsBuilt` (`isBuilt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `FileImageThumbnailTypeFileSets`
--

CREATE TABLE `FileImageThumbnailTypeFileSets` (
  `ftfsFileSetID` int(10) unsigned NOT NULL,
  `ftfsThumbnailType` int(11) NOT NULL,
  PRIMARY KEY (`ftfsThumbnailType`,`ftfsFileSetID`),
  KEY `IDX_BD75F88D480660E5` (`ftfsThumbnailType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `FileImageThumbnailTypes`
--

CREATE TABLE `FileImageThumbnailTypes` (
  `ftTypeID` int(11) NOT NULL AUTO_INCREMENT,
  `ftTypeHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ftTypeName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ftTypeWidth` int(11) DEFAULT NULL,
  `ftTypeHeight` int(11) DEFAULT NULL,
  `ftTypeIsRequired` tinyint(1) NOT NULL,
  `ftTypeSizingMode` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ftUpscalingEnabled` tinyint(1) NOT NULL,
  `ftLimitedToFileSets` tinyint(1) NOT NULL,
  `ftKeepAnimations` tinyint(1) NOT NULL,
  `ftSaveAreaBackgroundColor` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`ftTypeID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `FileImageThumbnailTypes`
--

INSERT INTO `FileImageThumbnailTypes` VALUES
(1, 'small', 'Small Image', 740, NULL, 0, 'proportional', 0, 0, 0, ''),
(2, 'medium', 'Medium Image', 940, NULL, 0, 'proportional', 0, 0, 0, ''),
(3, 'large', 'Large Image', 1140, NULL, 0, 'proportional', 0, 0, 0, ''),
(4, 'file_manager_listing', 'File Manager Thumbnails', 60, 60, 1, 'exact', 1, 0, 0, ''),
(5, 'file_manager_detail', 'File Manager Detail Thumbnails', 400, 400, 1, 'exact', 0, 0, 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `FilePermissionAssignments`
--

CREATE TABLE `FilePermissionAssignments` (
  `fID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`fID`,`pkID`,`paID`),
  KEY `pkID` (`pkID`),
  KEY `paID` (`paID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `FilePermissionFileTypeAccessList`
--

CREATE TABLE `FilePermissionFileTypeAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`),
  KEY `peID` (`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `FilePermissionFileTypeAccessListCustom`
--

CREATE TABLE `FilePermissionFileTypeAccessListCustom` (
  `extension` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`extension`),
  KEY `peID` (`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `FilePermissionFileTypes`
--

CREATE TABLE `FilePermissionFileTypes` (
  `extension` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `fsID` int(10) unsigned NOT NULL DEFAULT '0',
  `gID` int(10) unsigned NOT NULL DEFAULT '0',
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`fsID`,`gID`,`uID`,`extension`),
  KEY `gID` (`gID`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `Files`
--

CREATE TABLE `Files` (
  `fID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fDateAdded` datetime NOT NULL,
  `fPassword` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fOverrideSetPermissions` tinyint(1) NOT NULL,
  `ocID` int(10) unsigned NOT NULL,
  `folderTreeNodeID` int(10) unsigned NOT NULL,
  `uID` int(10) unsigned DEFAULT NULL,
  `fslID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`fID`),
  KEY `uID` (`uID`),
  KEY `fslID` (`fslID`),
  KEY `ocID` (`ocID`),
  KEY `fOverrideSetPermissions` (`fOverrideSetPermissions`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=17 ;

--
-- Dumping data for table `Files`
--

INSERT INTO `Files` VALUES
(1, '[[date_gmt]]', NULL, 0, 0, 7, 1, 1),
(2, '[[date_gmt]]', NULL, 0, 0, 7, 1, 1),
(3, '[[date_gmt]]', NULL, 0, 0, 7, 1, 1),
(4, '[[date_gmt]]', NULL, 0, 0, 7, 1, 1),
(5, '[[date_gmt]]', NULL, 0, 0, 7, 1, 1),
(6, '[[date_gmt]]', NULL, 0, 0, 7, 1, 1),
(7, '[[date_gmt]]', NULL, 0, 0, 7, 1, 1),
(8, '[[date_gmt]]', NULL, 0, 0, 7, 1, 1),
(9, '[[date_gmt]]', NULL, 0, 0, 7, 1, 1),
(10, '[[date_gmt]]', NULL, 0, 0, 7, 1, 1),
(11, '[[date_gmt]]', NULL, 0, 0, 7, 1, 1),
(12, '[[date_gmt]]', NULL, 0, 0, 7, 1, 1),
(13, '[[date_gmt]]', NULL, 0, 0, 7, 1, 1),
(14, '[[date_gmt]]', NULL, 0, 0, 7, 1, 1),
(15, '[[date_gmt]]', NULL, 0, 0, 7, 1, 1),
(16, '[[date_gmt]]', NULL, 0, 0, 7, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `FileSearchIndexAttributes`
--

CREATE TABLE `FileSearchIndexAttributes` (
  `fID` int(10) unsigned NOT NULL,
  `ak_width` decimal(14,4) DEFAULT '0.0000',
  `ak_height` decimal(14,4) DEFAULT '0.0000',
  `ak_duration` decimal(14,4) DEFAULT '0.0000',
  PRIMARY KEY (`fID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `FileSearchIndexAttributes`
--

INSERT INTO `FileSearchIndexAttributes` VALUES
(1, '1600.0000', '1066.0000', '0.0000'),
(2, '200.0000', '200.0000', '0.0000'),
(3, '500.0000', '500.0000', '0.0000'),
(4, '460.0000', '460.0000', '0.0000'),
(5, '592.0000', '397.0000', '0.0000'),
(6, '250.0000', '252.0000', '0.0000'),
(7, '1600.0000', '1067.0000', '0.0000'),
(8, '200.0000', '200.0000', '0.0000'),
(9, '1499.0000', '1067.0000', '0.0000'),
(10, '1100.0000', '263.0000', '0.0000'),
(11, '1600.0000', '1067.0000', '0.0000'),
(12, '1600.0000', '1067.0000', '0.0000'),
(13, '1100.0000', '368.0000', '0.0000'),
(14, '1100.0000', '368.0000', '0.0000'),
(15, '1600.0000', '1067.0000', '0.0000'),
(16, '1600.0000', '953.0000', '0.0000');

-- --------------------------------------------------------

--
-- Table structure for table `FileSetFiles`
--

CREATE TABLE `FileSetFiles` (
  `fsfID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fID` int(10) unsigned NOT NULL,
  `fsID` int(10) unsigned NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `fsDisplayOrder` int(10) unsigned NOT NULL,
  PRIMARY KEY (`fsfID`),
  KEY `fID` (`fID`),
  KEY `fsID` (`fsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `FileSets`
--

CREATE TABLE `FileSets` (
  `fsID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fsName` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  `fsType` smallint(6) NOT NULL,
  `fsOverrideGlobalPermissions` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`fsID`),
  KEY `uID` (`uID`,`fsType`,`fsName`),
  KEY `fsName` (`fsName`),
  KEY `fsType` (`fsType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `FileSetSavedSearches`
--

CREATE TABLE `FileSetSavedSearches` (
  `fsID` int(10) unsigned NOT NULL DEFAULT '0',
  `fsSearchRequest` text COLLATE utf8_unicode_ci,
  `fsResultColumns` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`fsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `FileStorageLocations`
--

CREATE TABLE `FileStorageLocations` (
  `fslName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `fslConfiguration` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `fslID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fslIsDefault` tinyint(1) NOT NULL,
  PRIMARY KEY (`fslID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `FileStorageLocations`
--

INSERT INTO `FileStorageLocations` VALUES
('Default', 'O:69:"Concrete\\Core\\File\\StorageLocation\\Configuration\\DefaultConfiguration":1:{s:10:"\0*\0default";b:1;}', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `FileStorageLocationTypes`
--

CREATE TABLE `FileStorageLocationTypes` (
  `fslTypeHandle` longtext COLLATE utf8_unicode_ci NOT NULL,
  `fslTypeName` longtext COLLATE utf8_unicode_ci NOT NULL,
  `fslTypeID` int(11) NOT NULL AUTO_INCREMENT,
  `pkgID` int(11) NOT NULL,
  PRIMARY KEY (`fslTypeID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `FileStorageLocationTypes`
--

INSERT INTO `FileStorageLocationTypes` VALUES
('default', 'Default', 1, 0),
('local', 'Local', 2, 0);

-- --------------------------------------------------------

--
-- Table structure for table `FileUsageRecord`
--

CREATE TABLE `FileUsageRecord` (
  `file_id` int(11) NOT NULL,
  `block_id` int(11) NOT NULL,
  `collection_id` int(11) NOT NULL,
  `collection_version_id` int(11) NOT NULL,
  PRIMARY KEY (`file_id`,`block_id`,`collection_id`,`collection_version_id`),
  KEY `block` (`block_id`),
  KEY `collection_version` (`collection_id`,`collection_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `FileUsageRecord`
--

INSERT INTO `FileUsageRecord` VALUES
(6, 123, 197, 1),
(8, 138, 201, 1),
(5, 145, 215, 1),
(5, 152, 215, 1),
(6, 156, 215, 1),
(10, 159, 216, 1);

-- --------------------------------------------------------

--
-- Table structure for table `FileVersionLog`
--

CREATE TABLE `FileVersionLog` (
  `fvlID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fID` int(10) unsigned NOT NULL DEFAULT '0',
  `fvID` int(10) unsigned NOT NULL DEFAULT '0',
  `fvUpdateTypeID` smallint(5) unsigned NOT NULL DEFAULT '0',
  `fvUpdateTypeAttributeID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`fvlID`),
  KEY `fvID` (`fID`,`fvID`,`fvlID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `FileVersions`
--

CREATE TABLE `FileVersions` (
  `fvID` int(11) NOT NULL,
  `fvFilename` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `fvPrefix` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fvDateAdded` datetime NOT NULL,
  `fvActivateDateTime` datetime NOT NULL,
  `fvIsApproved` tinyint(1) NOT NULL,
  `fvAuthorUID` int(11) NOT NULL,
  `fvApproverUID` int(11) NOT NULL,
  `fvSize` bigint(20) NOT NULL,
  `fvTitle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fvDescription` longtext COLLATE utf8_unicode_ci,
  `fvExtension` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fvTags` longtext COLLATE utf8_unicode_ci,
  `fvType` int(11) NOT NULL,
  `fvHasListingThumbnail` tinyint(1) NOT NULL,
  `fvHasDetailThumbnail` tinyint(1) NOT NULL,
  `fID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`fID`,`fvID`),
  KEY `IDX_D7B5A13AE3111F45` (`fID`),
  KEY `fvFilename` (`fvFilename`),
  KEY `fvExtension` (`fvExtension`),
  KEY `fvType` (`fvType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `FileVersions`
--

INSERT INTO `FileVersions` VALUES
(1, 'plants.jpg', '123412345678', '[[date_gmt]]', '[[date_gmt]]', 1, 1, 1, 373839, 'plants.jpg', '', 'jpg', '', 1, 1, 1, 1),
(1, 'avatar_none.png', '921743574322', '[[date_gmt]]', '[[date_gmt]]', 1, 1, 1, 12769, 'avatar_none.png', '', 'png', '', 1, 1, 0, 2),
(1, 'balloon.jpg', '371743574322', '[[date_gmt]]', '[[date_gmt]]', 1, 1, 1, 49708, 'balloon.jpg', '', 'jpg', '', 1, 1, 1, 3),
(1, 'bio.png', '191743574322', '[[date_gmt]]', '[[date_gmt]]', 1, 1, 1, 1353, 'bio.png', '', 'png', '', 1, 1, 1, 4),
(1, 'blank.png', '801743574322', '[[date_gmt]]', '[[date_gmt]]', 1, 1, 1, 1837, 'blank.png', '', 'png', '', 1, 1, 1, 5),
(1, 'blank2.png', '141743574323', '[[date_gmt]]', '[[date_gmt]]', 1, 1, 1, 1210, 'blank2.png', '', 'png', '', 1, 1, 0, 6),
(1, 'bridge.jpg', '591743574323', '[[date_gmt]]', '[[date_gmt]]', 1, 1, 1, 211901, 'bridge.jpg', '', 'jpg', '', 1, 1, 1, 7),
(1, 'chinese_house2.jpg', '101743574323', '[[date_gmt]]', '[[date_gmt]]', 1, 1, 1, 84383, 'chinese_house2.jpg', '', 'jpg', '', 1, 1, 0, 8),
(1, 'houses.jpg', '871743574323', '[[date_gmt]]', '[[date_gmt]]', 1, 1, 1, 293154, 'houses.jpg', '', 'jpg', '', 1, 1, 1, 9),
(1, 'masthead.png', '151743574324', '[[date_gmt]]', '[[date_gmt]]', 1, 1, 1, 1429, 'masthead.png', '', 'png', '', 1, 1, 1, 10),
(1, 'mountains.jpg', '181743574324', '[[date_gmt]]', '[[date_gmt]]', 1, 1, 1, 330436, 'mountains.jpg', '', 'jpg', '', 1, 1, 1, 11),
(1, 'shoes.jpg', '681743574325', '[[date_gmt]]', '[[date_gmt]]', 1, 1, 1, 170179, 'shoes.jpg', '', 'jpg', '', 1, 1, 1, 12),
(1, 'slider1.png', '211743574325', '[[date_gmt]]', '[[date_gmt]]', 1, 1, 1, 78494, 'slider1.png', '', 'png', '', 1, 1, 1, 13),
(1, 'slider2.png', '721743574325', '[[date_gmt]]', '[[date_gmt]]', 1, 1, 1, 111308, 'slider2.png', '', 'png', '', 1, 1, 1, 14),
(1, 'subway.jpg', '361743574325', '[[date_gmt]]', '[[date_gmt]]', 1, 1, 1, 305595, 'subway.jpg', '', 'jpg', '', 1, 1, 1, 15),
(1, 'sunset.jpg', '441743574326', '[[date_gmt]]', '[[date_gmt]]', 1, 1, 1, 458047, 'sunset.jpg', '', 'jpg', '', 1, 1, 1, 16);

-- --------------------------------------------------------

--
-- Table structure for table `FormSubmissionNotifications`
--

CREATE TABLE `FormSubmissionNotifications` (
  `exEntryID` int(11) DEFAULT NULL,
  `nID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`nID`),
  KEY `IDX_E7B6BE406DCB6296` (`exEntryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `gaPage`
--

CREATE TABLE `gaPage` (
  `gaiID` int(10) unsigned NOT NULL,
  `cID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`gaiID`),
  KEY `cID` (`cID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GatheringConfiguredDataSources`
--

CREATE TABLE `GatheringConfiguredDataSources` (
  `gcsID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gaID` int(10) unsigned DEFAULT NULL,
  `gasID` int(10) unsigned DEFAULT NULL,
  `gcdObject` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`gcsID`),
  KEY `gaID` (`gaID`),
  KEY `gasID` (`gasID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GatheringDataSources`
--

CREATE TABLE `GatheringDataSources` (
  `gasID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gasName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `gasHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  `gasDisplayOrder` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`gasID`),
  UNIQUE KEY `gasHandle` (`gasHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `GatheringDataSources`
--

INSERT INTO `GatheringDataSources` VALUES
(1, 'Site Page', 'page', 0, 0),
(2, 'RSS Feed', 'rss_feed', 0, 1),
(3, 'Flickr Feed', 'flickr_feed', 0, 2),
(4, 'Twitter', 'twitter', 0, 3);

-- --------------------------------------------------------

--
-- Table structure for table `GatheringItemFeatureAssignments`
--

CREATE TABLE `GatheringItemFeatureAssignments` (
  `gafaID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gaiID` int(10) unsigned DEFAULT NULL,
  `faID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`gafaID`),
  KEY `gaiID` (`gaiID`,`faID`),
  KEY `faID` (`faID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GatheringItems`
--

CREATE TABLE `GatheringItems` (
  `gaiID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gaID` int(10) unsigned DEFAULT NULL,
  `gasID` int(10) unsigned DEFAULT NULL,
  `gaiDateTimeCreated` datetime NOT NULL,
  `gaiPublicDateTime` datetime NOT NULL,
  `gaiTitle` text COLLATE utf8_unicode_ci,
  `gaiSlotWidth` int(10) unsigned DEFAULT '1',
  `gaiSlotHeight` int(10) unsigned DEFAULT '1',
  `gaiKey` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `gaiBatchDisplayOrder` int(10) unsigned NOT NULL DEFAULT '0',
  `gaiBatchTimestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `gaiIsDeleted` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`gaiID`),
  UNIQUE KEY `gaiUniqueKey` (`gaiKey`,`gasID`,`gaID`),
  KEY `gaID` (`gaID`,`gaiBatchTimestamp`),
  KEY `gasID` (`gasID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `GatheringItemSelectedTemplates`
--

CREATE TABLE `GatheringItemSelectedTemplates` (
  `gaiID` int(10) unsigned NOT NULL DEFAULT '0',
  `gatID` int(10) unsigned NOT NULL DEFAULT '0',
  `gatTypeID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`gaiID`,`gatID`),
  UNIQUE KEY `gatUniqueKey` (`gaiID`,`gatTypeID`),
  KEY `gatTypeID` (`gatTypeID`),
  KEY `gatID` (`gatID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GatheringItemTemplateFeatures`
--

CREATE TABLE `GatheringItemTemplateFeatures` (
  `gfeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gatID` int(10) unsigned DEFAULT NULL,
  `feID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`gfeID`),
  KEY `gatID` (`gatID`),
  KEY `feID` (`feID`,`gatID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=67 ;

--
-- Dumping data for table `GatheringItemTemplateFeatures`
--

INSERT INTO `GatheringItemTemplateFeatures` VALUES
(4, 1, 1),
(10, 2, 1),
(13, 3, 1),
(16, 4, 1),
(19, 5, 1),
(23, 7, 1),
(29, 11, 1),
(33, 12, 1),
(37, 13, 1),
(42, 14, 1),
(47, 15, 1),
(53, 17, 1),
(56, 18, 1),
(63, 21, 1),
(64, 22, 1),
(3, 1, 2),
(9, 2, 2),
(12, 3, 2),
(15, 4, 2),
(18, 5, 2),
(21, 6, 2),
(25, 8, 2),
(27, 9, 2),
(41, 13, 3),
(46, 14, 3),
(51, 16, 3),
(55, 17, 3),
(62, 20, 3),
(66, 22, 3),
(2, 1, 4),
(8, 2, 4),
(14, 4, 4),
(17, 5, 4),
(31, 11, 4),
(35, 12, 4),
(39, 13, 4),
(44, 14, 4),
(61, 20, 4),
(5, 1, 5),
(22, 6, 5),
(24, 8, 5),
(26, 9, 5),
(28, 10, 5),
(32, 11, 5),
(36, 12, 5),
(40, 13, 5),
(45, 14, 5),
(49, 15, 5),
(50, 16, 5),
(59, 19, 5),
(65, 22, 5),
(20, 5, 6),
(1, 1, 7),
(7, 2, 7),
(11, 3, 7),
(30, 11, 7),
(34, 12, 7),
(38, 13, 7),
(43, 14, 7),
(48, 15, 7),
(52, 16, 7),
(54, 17, 7),
(57, 18, 7),
(58, 19, 7),
(60, 20, 7),
(6, 1, 8);

-- --------------------------------------------------------

--
-- Table structure for table `GatheringItemTemplates`
--

CREATE TABLE `GatheringItemTemplates` (
  `gatID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gatHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `gatName` text COLLATE utf8_unicode_ci,
  `gatHasCustomClass` tinyint(1) NOT NULL DEFAULT '0',
  `gatFixedSlotWidth` int(10) unsigned DEFAULT '0',
  `gatFixedSlotHeight` int(10) unsigned DEFAULT '0',
  `gatForceDefault` int(10) unsigned DEFAULT '0',
  `pkgID` int(10) unsigned DEFAULT NULL,
  `gatTypeID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`gatID`),
  UNIQUE KEY `gatHandle` (`gatHandle`,`gatTypeID`),
  KEY `gatTypeID` (`gatTypeID`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=23 ;

--
-- Dumping data for table `GatheringItemTemplates`
--

INSERT INTO `GatheringItemTemplates` VALUES
(1, 'featured', 'Featured Item', 0, 6, 2, 1, 0, 1),
(2, 'title_date_description', 'Title Date & Description', 0, 0, 0, 0, 0, 1),
(3, 'title_description', 'Title & Description', 0, 0, 0, 0, 0, 1),
(4, 'title_date', 'Title & Date', 0, 0, 0, 0, 0, 1),
(5, 'title_date_comments', 'Title, Date & Comments', 1, 0, 0, 0, 0, 1),
(6, 'thumbnail', 'Thumbnail', 0, 0, 0, 0, 0, 1),
(7, 'basic', 'Basic', 0, 0, 0, 0, 0, 2),
(8, 'image_sharing_link', 'Image Sharing Link', 0, 0, 0, 0, 0, 2),
(9, 'image_conversation', 'Image Conversation', 0, 0, 0, 0, 0, 2),
(10, 'image', 'Large Image', 0, 0, 0, 0, 0, 2),
(11, 'masthead_image_left', 'Masthead Image Left', 0, 0, 0, 0, 0, 1),
(12, 'masthead_image_right', 'Masthead Image Right', 0, 0, 0, 0, 0, 1),
(13, 'masthead_image_byline_right', 'Masthead Image Byline Right', 0, 0, 0, 0, 0, 1),
(14, 'masthead_image_byline_left', 'Masthead Image Byline Left', 0, 0, 0, 0, 0, 1),
(15, 'image_masthead_description_center', 'Image Masthead Description Center', 0, 0, 0, 0, 0, 1),
(16, 'image_byline_description_center', 'Image Byline Description Center', 0, 0, 0, 0, 0, 1),
(17, 'masthead_byline_description', 'Masthead Byline Description', 0, 0, 0, 0, 0, 1),
(18, 'masthead_description', 'Masthead Description', 0, 0, 0, 0, 0, 1),
(19, 'thumbnail_description_center', 'Thumbnail & Description Center', 0, 0, 0, 0, 0, 1),
(20, 'tweet', 'Tweet', 0, 0, 0, 0, 0, 1),
(21, 'vimeo', 'Vimeo', 0, 0, 0, 0, 0, 1),
(22, 'image_overlay_headline', 'Image Overlay Headline', 0, 0, 0, 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `GatheringItemTemplateTypes`
--

CREATE TABLE `GatheringItemTemplateTypes` (
  `gatTypeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gatTypeHandle` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`gatTypeID`),
  UNIQUE KEY `gatTypeHandle` (`gatTypeHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `GatheringItemTemplateTypes`
--

INSERT INTO `GatheringItemTemplateTypes` VALUES
(1, 'tile', 0),
(2, 'detail', 0);

-- --------------------------------------------------------

--
-- Table structure for table `GatheringPermissionAssignments`
--

CREATE TABLE `GatheringPermissionAssignments` (
  `gaID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`gaID`,`pkID`,`paID`),
  KEY `pkID` (`pkID`),
  KEY `paID` (`paID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `Gatherings`
--

CREATE TABLE `Gatherings` (
  `gaID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gaDateCreated` datetime NOT NULL,
  `gaDateLastUpdated` datetime NOT NULL,
  PRIMARY KEY (`gaID`),
  KEY `gaDateLastUpdated` (`gaDateLastUpdated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `Geolocators`
--

CREATE TABLE `Geolocators` (
  `glID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Geolocator ID',
  `glHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Geolocator handle',
  `glName` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'Geolocator name',
  `glDescription` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT 'Geolocator description',
  `glConfiguration` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT 'Geolocator configuration options(DC2Type:json_array)',
  `glActive` tinyint(1) NOT NULL COMMENT 'Is this Geolocator the active one?',
  `glPackage` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`glID`),
  UNIQUE KEY `UNIQ_83BB1614D4F4D416` (`glHandle`),
  KEY `IDX_83BB1614D5F6CC40` (`glPackage`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='List of all the installed Geolocator services' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `Geolocators`
--

INSERT INTO `Geolocators` VALUES
(1, 'geoplugin', 'geoPlugin', '', '{"url":"http:\\/\\/www.geoplugin.net\\/json.gp?ip=[[IP]]"}', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `Groups`
--

CREATE TABLE `Groups` (
  `gID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gName` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `gDescription` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `gUserExpirationIsEnabled` tinyint(1) NOT NULL DEFAULT '0',
  `gUserExpirationMethod` varchar(12) COLLATE utf8_unicode_ci DEFAULT NULL,
  `gUserExpirationSetDateTime` datetime DEFAULT NULL,
  `gUserExpirationInterval` int(10) unsigned NOT NULL DEFAULT '0',
  `gUserExpirationAction` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `gIsBadge` tinyint(1) NOT NULL DEFAULT '0',
  `gBadgeFID` int(10) unsigned NOT NULL DEFAULT '0',
  `gBadgeDescription` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `gBadgeCommunityPointValue` int(11) NOT NULL DEFAULT '0',
  `gIsAutomated` tinyint(1) NOT NULL DEFAULT '0',
  `gCheckAutomationOnRegister` tinyint(1) NOT NULL DEFAULT '0',
  `gCheckAutomationOnLogin` tinyint(1) NOT NULL DEFAULT '0',
  `gCheckAutomationOnJobRun` tinyint(1) NOT NULL DEFAULT '0',
  `gPath` text COLLATE utf8_unicode_ci,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`gID`),
  KEY `gName` (`gName`),
  KEY `gBadgeFID` (`gBadgeFID`),
  KEY `pkgID` (`pkgID`),
  KEY `gPath` (`gPath`(255))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `Groups`
--

INSERT INTO `Groups` VALUES
(1, 'Guest', 'The guest group represents unregistered visitors to your site.', 0, NULL, NULL, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, '/Guest', 0),
(2, 'Registered Users', 'The registered users group represents all user accounts.', 0, NULL, NULL, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, '/Registered Users', 0),
(3, 'Administrators', '', 0, NULL, NULL, 0, NULL, 0, 0, NULL, 0, 0, 0, 0, 0, '/Administrators', 0);

-- --------------------------------------------------------

--
-- Table structure for table `GroupSetGroups`
--

CREATE TABLE `GroupSetGroups` (
  `gID` int(10) unsigned NOT NULL DEFAULT '0',
  `gsID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`gID`,`gsID`),
  KEY `gsID` (`gsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `GroupSets`
--

CREATE TABLE `GroupSets` (
  `gsID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gsName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`gsID`),
  KEY `gsName` (`gsName`),
  KEY `pkgID` (`pkgID`,`gsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `IpAccessControlCategories`
--

CREATE TABLE `IpAccessControlCategories` (
  `iaccID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The IP Access Control Category identifier',
  `iaccHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'The IP Access Control handle',
  `iaccName` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'The IP Access Control name',
  `iaccEnabled` tinyint(1) NOT NULL COMMENT 'Is this IP Access Control enabled?',
  `iaccMaxEvents` int(10) unsigned NOT NULL COMMENT 'The maximum allowed events in the time window',
  `iaccTimeWindow` int(10) unsigned DEFAULT NULL COMMENT 'The time window (in seconds) where the events should be counted (NULL means no limits)',
  `iaccBanDuration` int(10) unsigned DEFAULT NULL COMMENT 'The duration (in seconds) of the ban when the maximum number of events occur in the time window (NULL means forever)',
  `iaccSiteSpecific` tinyint(1) NOT NULL COMMENT 'Is this IP Access Control Category site-specific?',
  `iaccLogChannel` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'The log channel handle',
  `iaccPackage` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`iaccID`),
  UNIQUE KEY `UNIQ_D4A1006246B4A747` (`iaccHandle`),
  KEY `IDX_D4A10062C908ED51` (`iaccPackage`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='List of IP Access Control Categories' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `IpAccessControlCategories`
--

INSERT INTO `IpAccessControlCategories` VALUES
(1, 'failed_login', 'Failed Login Attempts', 1, 5, 300, 600, 1, 'security', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `IpAccessControlEvents`
--

CREATE TABLE `IpAccessControlEvents` (
  `iaceID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The IP Access Control Event identifier',
  `iaceIp` varchar(40) COLLATE utf8_unicode_ci NOT NULL COMMENT 'The IP address associated to this event',
  `iaceDateTime` datetime NOT NULL COMMENT 'The date/time when this event occurred',
  `iaceCategory` int(10) unsigned NOT NULL COMMENT 'The IP Access Control Category identifier',
  `iaceSite` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`iaceID`),
  KEY `IDX_6C004072E9480668` (`iaceCategory`),
  KEY `IDX_6C004072B0C0DFA7` (`iaceSite`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='List of IP Access Control Events' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `IpAccessControlRanges`
--

CREATE TABLE `IpAccessControlRanges` (
  `iacrID` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The IP Access Control Range identifier',
  `iacrIpFrom` varchar(40) COLLATE utf8_unicode_ci NOT NULL COMMENT 'The initial IP address of the range',
  `iacrIpTo` varchar(40) COLLATE utf8_unicode_ci NOT NULL COMMENT 'The final IP address of the range',
  `iacrType` int(10) unsigned NOT NULL COMMENT 'The type of this range',
  `iacrExpiration` datetime DEFAULT NULL COMMENT 'The date/time when this range expires (NULL means no expiration)',
  `iacrCategory` int(10) unsigned NOT NULL COMMENT 'The IP Access Control Category identifier',
  `iacrSite` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`iacrID`),
  KEY `IDX_2B1AA65D21E929D0` (`iacrCategory`),
  KEY `IDX_2B1AA65D62009435` (`iacrSite`),
  KEY `IPIntervalExpiration` (`iacrIpFrom`,`iacrIpTo`,`iacrExpiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='List of IP Access Control Ranges' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `Jobs`
--

CREATE TABLE `Jobs` (
  `jID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `jName` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `jDescription` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `jDateInstalled` datetime DEFAULT NULL,
  `jDateLastRun` datetime DEFAULT NULL,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  `jLastStatusText` longtext COLLATE utf8_unicode_ci,
  `jLastStatusCode` smallint(6) NOT NULL DEFAULT '0',
  `jStatus` varchar(14) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'ENABLED',
  `jHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `jNotUninstallable` smallint(6) NOT NULL DEFAULT '0',
  `isScheduled` smallint(6) NOT NULL DEFAULT '0',
  `scheduledInterval` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'days',
  `scheduledValue` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`jID`),
  UNIQUE KEY `jHandle` (`jHandle`),
  KEY `pkgID` (`pkgID`),
  KEY `isScheduled` (`isScheduled`,`jDateLastRun`,`jID`),
  KEY `jDateLastRun` (`jDateLastRun`,`jID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=11 ;

--
-- Dumping data for table `Jobs`
--

INSERT INTO `Jobs` VALUES
(1, 'Index Search Engine - Updates', 'Index the site to allow searching to work quickly and accurately', '[[date_gmt]]', NULL, 0, NULL, 0, 'ENABLED', 'index_search', 1, 0, 'days', 0),
(2, 'Index Search Engine - All', 'Empties the page search index and reindexes all pages.', '[[date_gmt]]', NULL, 0, NULL, 0, 'ENABLED', 'index_search_all', 1, 0, 'days', 0),
(3, 'Check Automated Groups', 'Automatically add users to groups and assign badges.', '[[date_gmt]]', NULL, 0, NULL, 0, 'ENABLED', 'check_automated_groups', 0, 0, 'days', 0),
(4, 'Generate the sitemap.xml file', 'Generate the sitemap.xml file that search engines use to crawl your site.', '[[date_gmt]]', NULL, 0, NULL, 0, 'ENABLED', 'generate_sitemap', 0, 0, 'days', 0),
(5, 'Process Email Posts', 'Polls an email account and grabs private messages/postings that are sent there..', '[[date_gmt]]', NULL, 0, NULL, 0, 'ENABLED', 'process_email', 0, 0, 'days', 0),
(6, 'Remove Old Page Versions', 'Removes all except the 10 most recent page versions for each page.', '[[date_gmt]]', NULL, 0, NULL, 0, 'ENABLED', 'remove_old_page_versions', 0, 0, 'days', 0),
(7, 'Update Gatherings', 'Loads new items into gatherings.', '[[date_gmt]]', NULL, 0, NULL, 0, 'ENABLED', 'update_gatherings', 0, 0, 'days', 0),
(8, 'Update Statistics Trackers', 'Scan the sitemap for file usage and stack usage to update statistics trackers', '[[date_gmt]]', NULL, 0, NULL, 0, 'ENABLED', 'update_statistics', 0, 0, 'days', 0),
(9, 'Fill thumbnail database table', 'Re-populate the thumbnail path database table.', '[[date_gmt]]', NULL, 0, NULL, 0, 'ENABLED', 'fill_thumbnails_table', 0, 0, 'days', 0),
(10, 'Deactivate Users', 'Deactivates users who haven''t logged in recently, if automatic user deactivation is active.', '[[date_gmt]]', NULL, 0, NULL, 0, 'ENABLED', 'deactivate_users', 0, 0, 'days', 0);

-- --------------------------------------------------------

--
-- Table structure for table `JobSetJobs`
--

CREATE TABLE `JobSetJobs` (
  `jsID` int(10) unsigned NOT NULL DEFAULT '0',
  `jID` int(10) unsigned NOT NULL DEFAULT '0',
  `jRunOrder` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`jsID`,`jID`),
  KEY `jID` (`jID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `JobSetJobs`
--

INSERT INTO `JobSetJobs` VALUES
(1, 1, 0),
(1, 4, 0),
(1, 5, 0),
(1, 6, 0),
(1, 7, 0),
(1, 9, 0),
(1, 10, 0);

-- --------------------------------------------------------

--
-- Table structure for table `JobSets`
--

CREATE TABLE `JobSets` (
  `jsID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `jsName` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  `jDateLastRun` datetime DEFAULT NULL,
  `isScheduled` smallint(6) NOT NULL DEFAULT '0',
  `scheduledInterval` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'days',
  `scheduledValue` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`jsID`),
  KEY `pkgID` (`pkgID`),
  KEY `jsName` (`jsName`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `JobSets`
--

INSERT INTO `JobSets` VALUES
(1, 'Default', 0, NULL, 0, 'days', 0);

-- --------------------------------------------------------

--
-- Table structure for table `JobsLog`
--

CREATE TABLE `JobsLog` (
  `jlID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `jID` int(10) unsigned NOT NULL,
  `jlMessage` longtext COLLATE utf8_unicode_ci NOT NULL,
  `jlTimestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `jlError` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`jlID`),
  KEY `jID` (`jID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `LegacyAttributeKeys`
--

CREATE TABLE `LegacyAttributeKeys` (
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `Logs`
--

CREATE TABLE `Logs` (
  `logID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `channel` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `time` int(10) unsigned NOT NULL,
  `message` longtext COLLATE utf8_unicode_ci,
  `uID` int(10) unsigned DEFAULT NULL,
  `level` int(11) NOT NULL,
  PRIMARY KEY (`logID`),
  KEY `channel` (`channel`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `MailImporters`
--

CREATE TABLE `MailImporters` (
  `miID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `miHandle` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `miServer` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `miUsername` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `miPassword` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `miEncryption` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `miIsEnabled` tinyint(1) NOT NULL DEFAULT '0',
  `miEmail` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `miPort` int(10) unsigned NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned DEFAULT NULL,
  `miConnectionMethod` varchar(8) COLLATE utf8_unicode_ci DEFAULT 'POP',
  PRIMARY KEY (`miID`),
  UNIQUE KEY `miHandle` (`miHandle`),
  KEY `pkgID` (`pkgID`,`miID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `MailImporters`
--

INSERT INTO `MailImporters` VALUES
(1, 'private_message', '', NULL, NULL, NULL, 0, '', 0, 0, 'POP');

-- --------------------------------------------------------

--
-- Table structure for table `MailValidationHashes`
--

CREATE TABLE `MailValidationHashes` (
  `mvhID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `miID` int(10) unsigned NOT NULL DEFAULT '0',
  `email` varchar(254) COLLATE utf8_unicode_ci NOT NULL,
  `mHash` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `mDateGenerated` int(10) unsigned NOT NULL DEFAULT '0',
  `mDateRedeemed` int(10) unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`mvhID`),
  UNIQUE KEY `mHash` (`mHash`),
  KEY `miID` (`miID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `MultilingualPageRelations`
--

CREATE TABLE `MultilingualPageRelations` (
  `mpLocale` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `mpLanguage` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mpRelationID` int(10) unsigned NOT NULL,
  `cID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`mpRelationID`,`cID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `MultilingualTranslations`
--

CREATE TABLE `MultilingualTranslations` (
  `mtID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mtSectionID` int(10) unsigned NOT NULL DEFAULT '0',
  `msgid` text COLLATE utf8_unicode_ci NOT NULL,
  `msgidPlural` text COLLATE utf8_unicode_ci,
  `msgstr` text COLLATE utf8_unicode_ci,
  `msgstrPlurals` text COLLATE utf8_unicode_ci,
  `context` text COLLATE utf8_unicode_ci,
  `comments` text COLLATE utf8_unicode_ci,
  `reference` text COLLATE utf8_unicode_ci,
  `flags` text COLLATE utf8_unicode_ci,
  `updated` datetime DEFAULT NULL,
  PRIMARY KEY (`mtID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `NotificationAlerts`
--

CREATE TABLE `NotificationAlerts` (
  `naID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `naIsArchived` tinyint(1) NOT NULL,
  `uID` int(10) unsigned DEFAULT NULL,
  `nID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`naID`),
  KEY `IDX_E11C7408FD71026C` (`uID`),
  KEY `IDX_E11C7408ED024EFD` (`nID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `NotificationPermissionSubscriptionList`
--

CREATE TABLE `NotificationPermissionSubscriptionList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`),
  KEY `peID` (`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `NotificationPermissionSubscriptionListCustom`
--

CREATE TABLE `NotificationPermissionSubscriptionListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `nSubscriptionIdentifier` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`paID`,`peID`,`nSubscriptionIdentifier`),
  KEY `peID` (`peID`),
  KEY `nSubscriptionIdentifier` (`nSubscriptionIdentifier`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `Notifications`
--

CREATE TABLE `Notifications` (
  `nID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nDate` datetime NOT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`nID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `OAuth2AccessToken`
--

CREATE TABLE `OAuth2AccessToken` (
  `identifier` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `client` char(36) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `expiryDateTime` datetime NOT NULL,
  `userIdentifier` int(10) unsigned DEFAULT NULL,
  `scopes` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:json_array)',
  PRIMARY KEY (`identifier`),
  KEY `IDX_60D69F3FC7440455` (`client`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `OAuth2AuthCode`
--

CREATE TABLE `OAuth2AuthCode` (
  `identifier` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `client` char(36) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  `scopes` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:json_array)',
  `expiryDateTime` datetime NOT NULL,
  `userIdentifier` int(10) unsigned NOT NULL,
  PRIMARY KEY (`identifier`),
  KEY `IDX_29D07B5C7440455` (`client`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `OAuth2Client`
--

CREATE TABLE `OAuth2Client` (
  `identifier` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `redirectUri` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `clientKey` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `clientSecret` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `consentType` int(10) unsigned NOT NULL,
  PRIMARY KEY (`identifier`),
  UNIQUE KEY `client_idx` (`clientKey`,`clientSecret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `OAuth2RefreshToken`
--

CREATE TABLE `OAuth2RefreshToken` (
  `identifier` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `expiryDateTime` datetime NOT NULL,
  `accessToken` char(36) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '(DC2Type:guid)',
  PRIMARY KEY (`identifier`),
  UNIQUE KEY `UNIQ_A205CB8350A9822` (`accessToken`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `OAuth2Scope`
--

CREATE TABLE `OAuth2Scope` (
  `identifier` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`identifier`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `OAuth2Scope`
--

INSERT INTO `OAuth2Scope` VALUES
('account:read', 'Read information about the remotely authenticated user.'),
('files:read', 'Read detailed information about uploaded files.'),
('openid', 'Remotely authenticate into concrete5.'),
('site:trees:read', 'Read information about system site trees.'),
('system:info:read', 'Read detailed information about the system.');

-- --------------------------------------------------------

--
-- Table structure for table `OauthUserMap`
--

CREATE TABLE `OauthUserMap` (
  `user_id` int(10) unsigned NOT NULL,
  `namespace` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `binding` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`user_id`,`namespace`),
  UNIQUE KEY `oauth_binding` (`binding`,`namespace`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `Packages`
--

CREATE TABLE `Packages` (
  `pkgID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pkgHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `pkgVersion` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `pkgIsInstalled` tinyint(1) NOT NULL,
  `pkgAvailableVersion` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pkgDescription` longtext COLLATE utf8_unicode_ci NOT NULL,
  `pkgDateInstalled` datetime NOT NULL,
  `pkgName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`pkgID`),
  UNIQUE KEY `UNIQ_62C3A2F1F2D49DB1` (`pkgHandle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `PageFeeds`
--

CREATE TABLE `PageFeeds` (
  `checkPagePermissions` tinyint(1) NOT NULL,
  `customTopicAttributeKeyHandle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customTopicTreeNodeID` int(10) unsigned NOT NULL,
  `iconFID` int(10) unsigned NOT NULL,
  `pfDescription` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `pfHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `pfTitle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `pfID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cParentID` int(10) unsigned NOT NULL,
  `ptID` int(10) unsigned NOT NULL,
  `pfIncludeAllDescendents` tinyint(1) NOT NULL,
  `pfDisplayAliases` tinyint(1) NOT NULL,
  `pfContentToDisplay` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `pfAreaHandleToDisplay` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pfDisplayFeaturedOnly` tinyint(1) NOT NULL,
  PRIMARY KEY (`pfID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `PageFeeds`
--

INSERT INTO `PageFeeds` VALUES
(1, NULL, 0, 0, 'concrete5 Blog', 'blog', 'Blog', 1, 199, 6, 0, 0, 'S', NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `PagePaths`
--

CREATE TABLE `PagePaths` (
  `cPath` longtext COLLATE utf8_unicode_ci NOT NULL,
  `ppID` int(11) NOT NULL AUTO_INCREMENT,
  `cID` int(10) unsigned NOT NULL,
  `ppIsCanonical` tinyint(1) NOT NULL,
  `ppGeneratedFromURLSlugs` tinyint(1) NOT NULL,
  PRIMARY KEY (`ppID`),
  KEY `ppIsCanonical` (`ppIsCanonical`),
  KEY `cID` (`cID`),
  KEY `cPath` (`cPath`(255))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=213 ;

--
-- Dumping data for table `PagePaths`
--

INSERT INTO `PagePaths` VALUES
('/dashboard', 1, 2, 1, 1),
('/dashboard/sitemap', 2, 3, 1, 1),
('/dashboard/sitemap/full', 3, 4, 1, 1),
('/dashboard/sitemap/explore', 4, 5, 1, 1),
('/dashboard/sitemap/search', 5, 6, 1, 1),
('/dashboard/files', 6, 7, 1, 1),
('/dashboard/files/search', 7, 8, 1, 1),
('/dashboard/files/attributes', 8, 9, 1, 1),
('/dashboard/files/sets', 9, 10, 1, 1),
('/dashboard/files/add_set', 10, 11, 1, 1),
('/dashboard/users', 11, 12, 1, 1),
('/dashboard/users/search', 12, 13, 1, 1),
('/dashboard/users/groups', 13, 14, 1, 1),
('/dashboard/users/groups/message', 14, 15, 1, 1),
('/dashboard/users/attributes', 15, 16, 1, 1),
('/dashboard/users/add', 16, 17, 1, 1),
('/dashboard/users/add_group', 17, 18, 1, 1),
('/dashboard/users/groups/bulkupdate', 18, 19, 1, 1),
('/dashboard/users/group_sets', 19, 20, 1, 1),
('/dashboard/users/points', 20, 21, 1, 1),
('/dashboard/users/points/assign', 21, 22, 1, 1),
('/dashboard/users/points/actions', 22, 23, 1, 1),
('/dashboard/express', 23, 24, 1, 1),
('/dashboard/express/entries', 24, 25, 1, 1),
('/dashboard/reports', 25, 26, 1, 1),
('/dashboard/reports/forms', 26, 27, 1, 1),
('/dashboard/reports/forms/legacy', 27, 28, 1, 1),
('/dashboard/reports/surveys', 28, 29, 1, 1),
('/dashboard/reports/logs', 29, 30, 1, 1),
('/dashboard/reports/page_changes', 30, 31, 1, 1),
('/dashboard/pages', 31, 32, 1, 1),
('/dashboard/pages/themes', 32, 33, 1, 1),
('/dashboard/pages/themes/inspect', 33, 34, 1, 1),
('/dashboard/pages/types', 34, 35, 1, 1),
('/dashboard/pages/types/organize', 35, 36, 1, 1),
('/dashboard/pages/types/add', 36, 37, 1, 1),
('/dashboard/pages/types/form', 37, 38, 1, 1),
('/dashboard/pages/types/output', 38, 39, 1, 1),
('/dashboard/pages/types/attributes', 39, 40, 1, 1),
('/dashboard/pages/types/permissions', 40, 41, 1, 1),
('/dashboard/pages/templates', 41, 42, 1, 1),
('/dashboard/pages/templates/add', 42, 43, 1, 1),
('/dashboard/pages/attributes', 43, 44, 1, 1),
('/dashboard/pages/single', 44, 45, 1, 1),
('/dashboard/pages/feeds', 45, 46, 1, 1),
('/dashboard/calendar', 46, 47, 1, 1),
('/dashboard/calendar/events', 47, 48, 1, 1),
('/dashboard/calendar/event_list', 48, 49, 1, 1),
('/dashboard/calendar/add', 49, 50, 1, 1),
('/dashboard/calendar/permissions', 50, 51, 1, 1),
('/dashboard/calendar/attributes', 51, 52, 1, 1),
('/dashboard/conversations', 52, 53, 1, 1),
('/dashboard/conversations/messages', 53, 54, 1, 1),
('/dashboard/blocks', 54, 55, 1, 1),
('/dashboard/blocks/stacks', 55, 56, 1, 1),
('/dashboard/blocks/permissions', 56, 57, 1, 1),
('/dashboard/blocks/stacks/list', 57, 58, 1, 1),
('/dashboard/blocks/types', 58, 59, 1, 1),
('/dashboard/extend', 59, 60, 1, 1),
('/dashboard/extend/install', 60, 61, 1, 1),
('/dashboard/extend/update', 61, 62, 1, 1),
('/dashboard/extend/connect', 62, 63, 1, 1),
('/dashboard/extend/themes', 63, 64, 1, 1),
('/dashboard/extend/addons', 64, 65, 1, 1),
('/dashboard/system', 65, 66, 1, 1),
('/dashboard/system/basics', 66, 67, 1, 1),
('/dashboard/system/basics/name', 67, 68, 1, 1),
('/dashboard/system/basics/accessibility', 68, 69, 1, 1),
('/dashboard/system/basics/social', 69, 70, 1, 1),
('/dashboard/system/basics/icons', 70, 71, 1, 1),
('/dashboard/system/basics/editor', 71, 72, 1, 1),
('/dashboard/system/basics/multilingual', 72, 73, 1, 1),
('/dashboard/system/basics/multilingual/update', 73, 74, 1, 1),
('/dashboard/system/basics/timezone', 74, 75, 1, 1),
('/dashboard/system/basics/attributes', 75, 76, 1, 1),
('/dashboard/system/basics/reset_edit_mode', 76, 77, 1, 1),
('/dashboard/system/express', 77, 78, 1, 1),
('/dashboard/system/express/entities', 78, 79, 1, 1),
('/dashboard/system/express/entities/attributes', 79, 80, 1, 1),
('/dashboard/system/express/entities/associations', 80, 81, 1, 1),
('/dashboard/system/express/entities/forms', 81, 82, 1, 1),
('/dashboard/system/express/entities/customize_search', 82, 83, 1, 1),
('/dashboard/system/express/entities/order_entries', 83, 84, 1, 1),
('/dashboard/system/express/entries', 84, 85, 1, 1),
('/dashboard/system/multisite', 85, 86, 1, 1),
('/dashboard/system/multisite/sites', 86, 87, 1, 1),
('/dashboard/system/multisite/types', 87, 88, 1, 1),
('/dashboard/system/multisite/settings', 88, 89, 1, 1),
('/dashboard/system/multilingual', 89, 90, 1, 1),
('/dashboard/system/multilingual/setup', 90, 91, 1, 1),
('/dashboard/system/multilingual/copy', 91, 92, 1, 1),
('/dashboard/system/multilingual/page_report', 92, 93, 1, 1),
('/dashboard/system/multilingual/translate_interface', 93, 94, 1, 1),
('/dashboard/system/seo', 94, 95, 1, 1),
('/dashboard/system/seo/urls', 95, 96, 1, 1),
('/dashboard/system/seo/bulk', 96, 97, 1, 1),
('/dashboard/system/seo/codes', 97, 98, 1, 1),
('/dashboard/system/seo/excluded', 98, 99, 1, 1),
('/dashboard/system/seo/searchindex', 99, 100, 1, 1),
('/dashboard/system/files', 100, 101, 1, 1),
('/dashboard/system/files/filetypes', 101, 102, 1, 1),
('/dashboard/system/files/permissions', 102, 103, 1, 1),
('/dashboard/system/files/thumbnails', 103, 104, 1, 1),
('/dashboard/system/files/thumbnails/options', 104, 105, 1, 1),
('/dashboard/system/files/image_uploading', 105, 106, 1, 1),
('/dashboard/system/files/storage', 106, 107, 1, 1),
('/dashboard/system/files/export_options', 107, 108, 1, 1),
('/dashboard/system/optimization', 108, 109, 1, 1),
('/dashboard/system/optimization/cache', 109, 110, 1, 1),
('/dashboard/system/optimization/clearcache', 110, 111, 1, 1),
('/dashboard/system/optimization/jobs', 111, 112, 1, 1),
('/dashboard/system/permissions', 112, 113, 1, 1),
('/dashboard/system/permissions/site', 113, 114, 1, 1),
('/dashboard/system/permissions/tasks', 114, 115, 1, 1),
('/dashboard/system/permissions/users', 115, 116, 1, 1),
('/dashboard/system/permissions/advanced', 116, 117, 1, 1),
('/dashboard/system/permissions/workflows', 117, 118, 1, 1),
('/dashboard/system/permissions/blacklist', 118, 119, 1, 1),
('/dashboard/system/permissions/blacklist/configure', 119, 120, 1, 1),
('/dashboard/system/permissions/blacklist/range', 120, 121, 1, 1),
('/dashboard/system/permissions/captcha', 121, 122, 1, 1),
('/dashboard/system/permissions/antispam', 122, 123, 1, 1),
('/dashboard/system/permissions/maintenance', 123, 124, 1, 1),
('/dashboard/system/permissions/trusted_proxies', 124, 125, 1, 1),
('/dashboard/system/registration', 125, 126, 1, 1),
('/dashboard/system/registration/open', 126, 127, 1, 1),
('/dashboard/system/registration/postlogin', 127, 128, 1, 1),
('/dashboard/system/registration/profiles', 128, 129, 1, 1),
('/dashboard/system/registration/authentication', 129, 130, 1, 1),
('/dashboard/system/registration/global_password_reset', 130, 131, 1, 1),
('/dashboard/system/registration/notification', 131, 132, 1, 1),
('/dashboard/system/registration/deactivation', 132, 133, 1, 1),
('/dashboard/system/registration/automated_logout', 133, 134, 1, 1),
('/dashboard/system/registration/password_requirements', 134, 135, 1, 1),
('/dashboard/system/registration/session_options', 135, 136, 1, 1),
('/dashboard/system/mail', 136, 137, 1, 1),
('/dashboard/system/mail/method', 137, 138, 1, 1),
('/dashboard/system/mail/method/test', 138, 139, 1, 1),
('/dashboard/system/mail/importers', 139, 140, 1, 1),
('/dashboard/system/mail/addresses', 140, 141, 1, 1),
('/dashboard/system/calendar', 141, 142, 1, 1),
('/dashboard/system/calendar/settings', 142, 143, 1, 1),
('/dashboard/system/calendar/colors', 143, 144, 1, 1),
('/dashboard/system/calendar/permissions', 144, 145, 1, 1),
('/dashboard/system/calendar/import', 145, 146, 1, 1),
('/dashboard/system/conversations', 146, 147, 1, 1),
('/dashboard/system/conversations/settings', 147, 148, 1, 1),
('/dashboard/system/conversations/points', 148, 149, 1, 1),
('/dashboard/system/conversations/bannedwords', 149, 150, 1, 1),
('/dashboard/system/conversations/permissions', 150, 151, 1, 1),
('/dashboard/system/attributes', 151, 152, 1, 1),
('/dashboard/system/attributes/types', 152, 153, 1, 1),
('/dashboard/system/attributes/sets', 153, 154, 1, 1),
('/dashboard/system/attributes/topics', 154, 155, 1, 1),
('/dashboard/system/attributes/topics/add', 155, 156, 1, 1),
('/dashboard/system/environment', 156, 157, 1, 1),
('/dashboard/system/environment/info', 157, 158, 1, 1),
('/dashboard/system/environment/debug', 158, 159, 1, 1),
('/dashboard/system/environment/logging', 159, 160, 1, 1),
('/dashboard/system/environment/proxy', 160, 161, 1, 1),
('/dashboard/system/environment/entities', 161, 162, 1, 1),
('/dashboard/system/environment/database_charset', 162, 163, 1, 1),
('/dashboard/system/environment/geolocation', 163, 164, 1, 1),
('/dashboard/system/update', 164, 165, 1, 1),
('/dashboard/system/update/update', 165, 166, 1, 1),
('/dashboard/system/api', 166, 167, 1, 1),
('/dashboard/system/api/settings', 167, 168, 1, 1),
('/dashboard/system/api/integrations', 168, 169, 1, 1),
('/dashboard/welcome', 169, 170, 1, 1),
('/dashboard/welcome/me', 170, 171, 1, 1),
('/!stacks', 171, 172, 1, 1),
('/page_not_found', 172, 173, 1, 1),
('/!trash', 173, 174, 1, 1),
('/login', 174, 175, 1, 1),
('/register', 175, 176, 1, 1),
('/account', 176, 177, 1, 1),
('/account/edit_profile', 177, 178, 1, 1),
('/account/avatar', 178, 179, 1, 1),
('/account/messages', 179, 180, 1, 1),
('/page_forbidden', 180, 181, 1, 1),
('/download_file', 181, 182, 1, 1),
('/!drafts', 182, 183, 1, 1),
('/account/welcome', 183, 184, 1, 0),
('/!stacks/footer-contact', 184, 185, 1, 1),
('/!stacks/footer-legal', 185, 186, 1, 1),
('/!stacks/footer-navigation', 186, 187, 1, 1),
('/!stacks/footer-site-title', 187, 188, 1, 1),
('/!stacks/footer-social', 188, 189, 1, 1),
('/!stacks/header-navigation', 189, 190, 1, 1),
('/!stacks/header-search', 190, 191, 1, 1),
('/!stacks/header-site-title', 191, 192, 1, 1),
('/services', 192, 194, 1, 1),
('/portfolio', 193, 196, 1, 1),
('/team', 194, 197, 1, 1),
('/blog', 195, 199, 1, 1),
('/search', 196, 200, 1, 1),
('/contact', 197, 201, 1, 1),
('/blank-page', 198, 203, 1, 1),
('/portfolio/project-title', 199, 205, 1, 1),
('/portfolio/project-title-2', 200, 206, 1, 1),
('/portfolio/project-title-3', 201, 207, 1, 1),
('/portfolio/project-title-4', 202, 208, 1, 1),
('/portfolio/project-title-5', 203, 209, 1, 1),
('/portfolio/project-title-6', 204, 210, 1, 1),
('/blog/hello-world', 205, 212, 1, 1),
('/blog/another-blog-post', 206, 213, 1, 1),
('/blog/a-beautiful-blog', 207, 214, 1, 1),
('/team/about', 208, 215, 1, 1),
('/team/careers', 209, 216, 1, 1),
('/team/faq', 210, 217, 1, 1),
('/team/careers/web-developer', 211, 219, 1, 1),
('/team/careers/sales-associate', 212, 220, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `PagePermissionAssignments`
--

CREATE TABLE `PagePermissionAssignments` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`pkID`,`paID`),
  KEY `paID` (`paID`,`pkID`),
  KEY `pkID` (`pkID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `PagePermissionAssignments`
--

INSERT INTO `PagePermissionAssignments` VALUES
(1, 1, 88),
(2, 1, 69),
(173, 1, 68),
(175, 1, 65),
(176, 1, 66),
(181, 1, 67),
(183, 1, 70),
(1, 2, 89),
(183, 2, 71),
(1, 3, 90),
(183, 3, 72),
(1, 4, 91),
(183, 4, 73),
(1, 5, 92),
(183, 5, 74),
(1, 6, 93),
(183, 6, 75),
(1, 7, 94),
(183, 7, 76),
(1, 8, 96),
(183, 8, 78),
(1, 9, 97),
(183, 9, 79),
(1, 10, 98),
(183, 10, 80),
(1, 11, 99),
(183, 11, 81),
(1, 12, 100),
(183, 12, 82),
(1, 13, 101),
(183, 13, 83),
(1, 14, 102),
(183, 14, 84),
(1, 15, 103),
(183, 15, 85),
(1, 16, 104),
(183, 16, 86),
(1, 17, 105),
(183, 17, 87),
(1, 18, 95),
(183, 18, 77);

-- --------------------------------------------------------

--
-- Table structure for table `PagePermissionPageTypeAccessList`
--

CREATE TABLE `PagePermissionPageTypeAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `externalLink` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`),
  KEY `peID` (`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `PagePermissionPageTypeAccessListCustom`
--

CREATE TABLE `PagePermissionPageTypeAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `ptID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`ptID`),
  KEY `peID` (`peID`),
  KEY `ptID` (`ptID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `PagePermissionPropertyAccessList`
--

CREATE TABLE `PagePermissionPropertyAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `name` tinyint(1) DEFAULT '0',
  `publicDateTime` tinyint(1) DEFAULT '0',
  `uID` tinyint(1) DEFAULT '0',
  `description` tinyint(1) DEFAULT '0',
  `paths` tinyint(1) DEFAULT '0',
  `attributePermission` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`),
  KEY `peID` (`peID`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `PagePermissionPropertyAttributeAccessListCustom`
--

CREATE TABLE `PagePermissionPropertyAttributeAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `akID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`akID`),
  KEY `peID` (`peID`),
  KEY `akID` (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `PagePermissionThemeAccessList`
--

CREATE TABLE `PagePermissionThemeAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`),
  KEY `peID` (`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `PagePermissionThemeAccessListCustom`
--

CREATE TABLE `PagePermissionThemeAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `pThemeID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`pThemeID`),
  KEY `peID` (`peID`),
  KEY `pThemeID` (`pThemeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `Pages`
--

CREATE TABLE `Pages` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `siteTreeID` int(10) unsigned DEFAULT '0',
  `ptID` int(10) unsigned NOT NULL DEFAULT '0',
  `cIsTemplate` tinyint(1) NOT NULL DEFAULT '0',
  `uID` int(10) unsigned DEFAULT NULL,
  `cIsCheckedOut` tinyint(1) NOT NULL DEFAULT '0',
  `cCheckedOutUID` int(10) unsigned DEFAULT NULL,
  `cCheckedOutDatetime` datetime DEFAULT NULL,
  `cCheckedOutDatetimeLastEdit` datetime DEFAULT NULL,
  `cOverrideTemplatePermissions` tinyint(1) NOT NULL DEFAULT '1',
  `cInheritPermissionsFromCID` int(10) unsigned NOT NULL DEFAULT '0',
  `cInheritPermissionsFrom` varchar(8) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'PARENT',
  `cFilename` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cPointerID` int(10) unsigned NOT NULL DEFAULT '0',
  `cPointerExternalLink` longtext COLLATE utf8_unicode_ci,
  `cPointerExternalLinkNewWindow` tinyint(1) NOT NULL DEFAULT '0',
  `cIsActive` tinyint(1) NOT NULL DEFAULT '1',
  `cChildren` int(10) unsigned NOT NULL DEFAULT '0',
  `cDisplayOrder` int(10) unsigned NOT NULL DEFAULT '0',
  `cParentID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  `cDraftTargetParentPageID` int(10) unsigned NOT NULL DEFAULT '0',
  `cIsDraft` tinyint(1) NOT NULL DEFAULT '0',
  `cCacheFullPageContent` smallint(6) NOT NULL DEFAULT '-1',
  `cCacheFullPageContentOverrideLifetime` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `cCacheFullPageContentLifetimeCustom` int(10) unsigned NOT NULL DEFAULT '0',
  `cIsSystemPage` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`ptID`),
  KEY `cParentID` (`cParentID`),
  KEY `siteTreeID` (`siteTreeID`),
  KEY `cIsActive` (`cID`,`cIsActive`),
  KEY `cCheckedOutUID` (`cCheckedOutUID`),
  KEY `uID` (`uID`,`cPointerID`),
  KEY `cPointerID` (`cPointerID`,`cDisplayOrder`),
  KEY `cIsTemplate` (`cID`,`cIsTemplate`),
  KEY `cIsSystemPage` (`cID`,`cIsSystemPage`),
  KEY `pkgID` (`pkgID`),
  KEY `cParentMaxDisplay` (`cParentID`,`cDisplayOrder`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `Pages`
--

INSERT INTO `Pages` VALUES
(1, 1, 0, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'OVERRIDE', NULL, 0, NULL, 0, 1, 18, 0, 0, 0, 0, 0, -1, '0', 0, 0),
(2, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'OVERRIDE', '/dashboard/view.php', 0, NULL, 0, 1, 12, 0, 0, 0, 0, 0, -1, '0', 0, 1),
(3, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/sitemap/view.php', 0, NULL, 0, 1, 3, 1, 2, 0, 0, 0, -1, '0', 0, 1),
(4, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/sitemap/full.php', 0, NULL, 0, 1, 0, 0, 3, 0, 0, 0, -1, '0', 0, 1),
(5, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/sitemap/explore.php', 0, NULL, 0, 1, 0, 1, 3, 0, 0, 0, -1, '0', 0, 1),
(6, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/sitemap/search.php', 0, NULL, 0, 1, 0, 2, 3, 0, 0, 0, -1, '0', 0, 1),
(7, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/files/view.php', 0, NULL, 0, 1, 4, 2, 2, 0, 0, 0, -1, '0', 0, 1),
(8, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/files/search.php', 0, NULL, 0, 1, 0, 0, 7, 0, 0, 0, -1, '0', 0, 1),
(9, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/files/attributes.php', 0, NULL, 0, 1, 0, 1, 7, 0, 0, 0, -1, '0', 0, 1),
(10, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/files/sets.php', 0, NULL, 0, 1, 0, 2, 7, 0, 0, 0, -1, '0', 0, 1),
(11, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/files/add_set.php', 0, NULL, 0, 1, 0, 3, 7, 0, 0, 0, -1, '0', 0, 1),
(12, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/users/view.php', 0, NULL, 0, 1, 7, 3, 2, 0, 0, 0, -1, '0', 0, 1),
(13, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/users/search.php', 0, NULL, 0, 1, 0, 0, 12, 0, 0, 0, -1, '0', 0, 1),
(14, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/users/groups.php', 0, NULL, 0, 1, 2, 1, 12, 0, 0, 0, -1, '0', 0, 1),
(15, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/users/groups/message.php', 0, NULL, 0, 1, 0, 0, 14, 0, 0, 0, -1, '0', 0, 1),
(16, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/users/attributes.php', 0, NULL, 0, 1, 0, 2, 12, 0, 0, 0, -1, '0', 0, 1),
(17, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/users/add.php', 0, NULL, 0, 1, 0, 3, 12, 0, 0, 0, -1, '0', 0, 1),
(18, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/users/add_group.php', 0, NULL, 0, 1, 0, 4, 12, 0, 0, 0, -1, '0', 0, 1),
(19, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/users/groups/bulkupdate.php', 0, NULL, 0, 1, 0, 1, 14, 0, 0, 0, -1, '0', 0, 1),
(20, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/users/group_sets.php', 0, NULL, 0, 1, 0, 5, 12, 0, 0, 0, -1, '0', 0, 1),
(21, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/users/points/view.php', 0, NULL, 0, 1, 2, 6, 12, 0, 0, 0, -1, '0', 0, 1),
(22, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/users/points/assign.php', 0, NULL, 0, 1, 0, 0, 21, 0, 0, 0, -1, '0', 0, 1),
(23, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/users/points/actions.php', 0, NULL, 0, 1, 0, 1, 21, 0, 0, 0, -1, '0', 0, 1),
(24, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/express/view.php', 0, NULL, 0, 1, 1, 4, 2, 0, 0, 0, -1, '0', 0, 1),
(25, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/express/entries.php', 0, NULL, 0, 1, 0, 0, 24, 0, 0, 0, -1, '0', 0, 1),
(26, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/reports.php', 0, NULL, 0, 1, 4, 5, 2, 0, 0, 0, -1, '0', 0, 1),
(27, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/reports/forms.php', 0, NULL, 0, 1, 1, 0, 26, 0, 0, 0, -1, '0', 0, 1),
(28, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/reports/forms/legacy.php', 0, NULL, 0, 1, 0, 0, 27, 0, 0, 0, -1, '0', 0, 1),
(29, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/reports/surveys.php', 0, NULL, 0, 1, 0, 1, 26, 0, 0, 0, -1, '0', 0, 1),
(30, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/reports/logs.php', 0, NULL, 0, 1, 0, 2, 26, 0, 0, 0, -1, '0', 0, 1),
(31, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/reports/page_changes.php', 0, NULL, 0, 1, 0, 3, 26, 0, 0, 0, -1, '0', 0, 1),
(32, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/view.php', 0, NULL, 0, 1, 6, 6, 2, 0, 0, 0, -1, '0', 0, 1),
(33, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/themes/view.php', 0, NULL, 0, 1, 1, 0, 32, 0, 0, 0, -1, '0', 0, 1),
(34, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/themes/inspect.php', 0, NULL, 0, 1, 0, 0, 33, 0, 0, 0, -1, '0', 0, 1),
(35, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/types/view.php', 0, NULL, 0, 1, 6, 1, 32, 0, 0, 0, -1, '0', 0, 1),
(36, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/types/organize.php', 0, NULL, 0, 1, 0, 0, 35, 0, 0, 0, -1, '0', 0, 1),
(37, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/types/add.php', 0, NULL, 0, 1, 0, 1, 35, 0, 0, 0, -1, '0', 0, 1),
(38, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/types/form.php', 0, NULL, 0, 1, 0, 2, 35, 0, 0, 0, -1, '0', 0, 1),
(39, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/types/output.php', 0, NULL, 0, 1, 0, 3, 35, 0, 0, 0, -1, '0', 0, 1),
(40, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/types/attributes.php', 0, NULL, 0, 1, 0, 4, 35, 0, 0, 0, -1, '0', 0, 1),
(41, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/types/permissions.php', 0, NULL, 0, 1, 0, 5, 35, 0, 0, 0, -1, '0', 0, 1),
(42, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/templates/view.php', 0, NULL, 0, 1, 1, 2, 32, 0, 0, 0, -1, '0', 0, 1),
(43, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/templates/add.php', 0, NULL, 0, 1, 0, 0, 42, 0, 0, 0, -1, '0', 0, 1),
(44, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/attributes.php', 0, NULL, 0, 1, 0, 3, 32, 0, 0, 0, -1, '0', 0, 1),
(45, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/single.php', 0, NULL, 0, 1, 0, 4, 32, 0, 0, 0, -1, '0', 0, 1),
(46, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/pages/feeds.php', 0, NULL, 0, 1, 0, 5, 32, 0, 0, 0, -1, '0', 0, 1),
(47, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/calendar/view.php', 0, NULL, 0, 1, 5, 7, 2, 0, 0, 0, -1, '0', 0, 1),
(48, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/calendar/events.php', 0, NULL, 0, 1, 0, 0, 47, 0, 0, 0, -1, '0', 0, 1),
(49, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/calendar/event_list.php', 0, NULL, 0, 1, 0, 1, 47, 0, 0, 0, -1, '0', 0, 1),
(50, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/calendar/add.php', 0, NULL, 0, 1, 0, 2, 47, 0, 0, 0, -1, '0', 0, 1),
(51, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/calendar/permissions.php', 0, NULL, 0, 1, 0, 3, 47, 0, 0, 0, -1, '0', 0, 1),
(52, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/calendar/attributes.php', 0, NULL, 0, 1, 0, 4, 47, 0, 0, 0, -1, '0', 0, 1),
(53, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/conversations/view.php', 0, NULL, 0, 1, 1, 8, 2, 0, 0, 0, -1, '0', 0, 1),
(54, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/conversations/messages.php', 0, NULL, 0, 1, 0, 0, 53, 0, 0, 0, -1, '0', 0, 1),
(55, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/blocks/view.php', 0, NULL, 0, 1, 3, 9, 2, 0, 0, 0, -1, '0', 0, 1),
(56, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/blocks/stacks/view.php', 0, NULL, 0, 1, 1, 0, 55, 0, 0, 0, -1, '0', 0, 1),
(57, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/blocks/permissions.php', 0, NULL, 0, 1, 0, 1, 55, 0, 0, 0, -1, '0', 0, 1),
(58, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/blocks/stacks/list/view.php', 0, NULL, 0, 1, 0, 0, 56, 0, 0, 0, -1, '0', 0, 1),
(59, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/blocks/types/view.php', 0, NULL, 0, 1, 0, 2, 55, 0, 0, 0, -1, '0', 0, 1),
(60, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/extend/view.php', 0, NULL, 0, 1, 5, 10, 2, 0, 0, 0, -1, '0', 0, 1),
(61, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/extend/install.php', 0, NULL, 0, 1, 0, 0, 60, 0, 0, 0, -1, '0', 0, 1),
(62, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/extend/update.php', 0, NULL, 0, 1, 0, 1, 60, 0, 0, 0, -1, '0', 0, 1),
(63, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/extend/connect.php', 0, NULL, 0, 1, 0, 2, 60, 0, 0, 0, -1, '0', 0, 1),
(64, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/extend/themes.php', 0, NULL, 0, 1, 0, 3, 60, 0, 0, 0, -1, '0', 0, 1),
(65, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/extend/addons.php', 0, NULL, 0, 1, 0, 4, 60, 0, 0, 0, -1, '0', 0, 1),
(66, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/view.php', 0, NULL, 0, 1, 16, 11, 2, 0, 0, 0, -1, '0', 0, 1),
(67, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/view.php', 0, NULL, 0, 1, 9, 0, 66, 0, 0, 0, -1, '0', 0, 1),
(68, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/name.php', 0, NULL, 0, 1, 0, 0, 67, 0, 0, 0, -1, '0', 0, 1),
(69, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/accessibility.php', 0, NULL, 0, 1, 0, 1, 67, 0, 0, 0, -1, '0', 0, 1),
(70, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/social.php', 0, NULL, 0, 1, 0, 2, 67, 0, 0, 0, -1, '0', 0, 1),
(71, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/icons.php', 0, NULL, 0, 1, 0, 3, 67, 0, 0, 0, -1, '0', 0, 1),
(72, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/editor.php', 0, NULL, 0, 1, 0, 4, 67, 0, 0, 0, -1, '0', 0, 1),
(73, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/multilingual/view.php', 0, NULL, 0, 1, 1, 5, 67, 0, 0, 0, -1, '0', 0, 1),
(74, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/multilingual/update.php', 0, NULL, 0, 1, 0, 0, 73, 0, 0, 0, -1, '0', 0, 1),
(75, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/timezone.php', 0, NULL, 0, 1, 0, 6, 67, 0, 0, 0, -1, '0', 0, 1),
(76, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/attributes.php', 0, NULL, 0, 1, 0, 7, 67, 0, 0, 0, -1, '0', 0, 1),
(77, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/basics/reset_edit_mode.php', 0, NULL, 0, 1, 0, 8, 67, 0, 0, 0, -1, '0', 0, 1),
(78, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/express/view.php', 0, NULL, 0, 1, 2, 1, 66, 0, 0, 0, -1, '0', 0, 1),
(79, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/express/entities.php', 0, NULL, 0, 1, 5, 0, 78, 0, 0, 0, -1, '0', 0, 1),
(80, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/express/entities/attributes.php', 0, NULL, 0, 1, 0, 0, 79, 0, 0, 0, -1, '0', 0, 1),
(81, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/express/entities/associations.php', 0, NULL, 0, 1, 0, 1, 79, 0, 0, 0, -1, '0', 0, 1),
(82, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/express/entities/forms.php', 0, NULL, 0, 1, 0, 2, 79, 0, 0, 0, -1, '0', 0, 1),
(83, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/express/entities/customize_search.php', 0, NULL, 0, 1, 0, 3, 79, 0, 0, 0, -1, '0', 0, 1),
(84, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/express/entities/order_entries.php', 0, NULL, 0, 1, 0, 4, 79, 0, 0, 0, -1, '0', 0, 1),
(85, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/express/entries.php', 0, NULL, 0, 1, 0, 1, 78, 0, 0, 0, -1, '0', 0, 1),
(86, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/multisite/view.php', 0, NULL, 0, 1, 3, 2, 66, 0, 0, 0, -1, '0', 0, 1),
(87, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/multisite/sites/view.php', 0, NULL, 0, 1, 0, 0, 86, 0, 0, 0, -1, '0', 0, 1),
(88, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/multisite/types/view.php', 0, NULL, 0, 1, 0, 1, 86, 0, 0, 0, -1, '0', 0, 1),
(89, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/multisite/settings.php', 0, NULL, 0, 1, 0, 2, 86, 0, 0, 0, -1, '0', 0, 1),
(90, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/multilingual/view.php', 0, NULL, 0, 1, 4, 3, 66, 0, 0, 0, -1, '0', 0, 1),
(91, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/multilingual/setup.php', 0, NULL, 0, 1, 0, 0, 90, 0, 0, 0, -1, '0', 0, 1),
(92, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/multilingual/copy.php', 0, NULL, 0, 1, 0, 1, 90, 0, 0, 0, -1, '0', 0, 1),
(93, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/multilingual/page_report.php', 0, NULL, 0, 1, 0, 2, 90, 0, 0, 0, -1, '0', 0, 1),
(94, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/multilingual/translate_interface.php', 0, NULL, 0, 1, 0, 3, 90, 0, 0, 0, -1, '0', 0, 1),
(95, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/seo/view.php', 0, NULL, 0, 1, 5, 4, 66, 0, 0, 0, -1, '0', 0, 1),
(96, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/seo/urls.php', 0, NULL, 0, 1, 0, 0, 95, 0, 0, 0, -1, '0', 0, 1),
(97, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/seo/bulk.php', 0, NULL, 0, 1, 0, 1, 95, 0, 0, 0, -1, '0', 0, 1),
(98, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/seo/codes.php', 0, NULL, 0, 1, 0, 2, 95, 0, 0, 0, -1, '0', 0, 1),
(99, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/seo/excluded.php', 0, NULL, 0, 1, 0, 3, 95, 0, 0, 0, -1, '0', 0, 1),
(100, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/seo/searchindex.php', 0, NULL, 0, 1, 0, 4, 95, 0, 0, 0, -1, '0', 0, 1),
(101, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/files/view.php', 0, NULL, 0, 1, 6, 5, 66, 0, 0, 0, -1, '0', 0, 1),
(102, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/files/filetypes.php', 0, NULL, 0, 1, 0, 0, 101, 0, 0, 0, -1, '0', 0, 1),
(103, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/files/permissions.php', 0, NULL, 0, 1, 0, 1, 101, 0, 0, 0, -1, '0', 0, 1),
(104, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/files/thumbnails.php', 0, NULL, 0, 1, 1, 2, 101, 0, 0, 0, -1, '0', 0, 1),
(105, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/files/thumbnails/options.php', 0, NULL, 0, 1, 0, 0, 104, 0, 0, 0, -1, '0', 0, 1),
(106, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/files/image_uploading.php', 0, NULL, 0, 1, 0, 3, 101, 0, 0, 0, -1, '0', 0, 1),
(107, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/files/storage.php', 0, NULL, 0, 1, 0, 4, 101, 0, 0, 0, -1, '0', 0, 1),
(108, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/files/export_options.php', 0, NULL, 0, 1, 0, 5, 101, 0, 0, 0, -1, '0', 0, 1),
(109, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/optimization/view.php', 0, NULL, 0, 1, 3, 6, 66, 0, 0, 0, -1, '0', 0, 1),
(110, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/optimization/cache.php', 0, NULL, 0, 1, 0, 0, 109, 0, 0, 0, -1, '0', 0, 1),
(111, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/optimization/clearcache.php', 0, NULL, 0, 1, 0, 1, 109, 0, 0, 0, -1, '0', 0, 1),
(112, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/optimization/jobs.php', 0, NULL, 0, 1, 0, 2, 109, 0, 0, 0, -1, '0', 0, 1),
(113, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/view.php', 0, NULL, 0, 1, 10, 7, 66, 0, 0, 0, -1, '0', 0, 1),
(114, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/site.php', 0, NULL, 0, 1, 0, 0, 113, 0, 0, 0, -1, '0', 0, 1),
(115, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/tasks.php', 0, NULL, 0, 1, 0, 1, 113, 0, 0, 0, -1, '0', 0, 1),
(116, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/users.php', 0, NULL, 0, 1, 0, 2, 113, 0, 0, 0, -1, '0', 0, 1),
(117, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/advanced.php', 0, NULL, 0, 1, 0, 3, 113, 0, 0, 0, -1, '0', 0, 1),
(118, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/workflows.php', 0, NULL, 0, 1, 0, 4, 113, 0, 0, 0, -1, '0', 0, 1),
(119, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/blacklist.php', 0, NULL, 0, 1, 2, 5, 113, 0, 0, 0, -1, '0', 0, 1),
(120, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/blacklist/configure.php', 0, NULL, 0, 1, 0, 0, 119, 0, 0, 0, -1, '0', 0, 1),
(121, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/blacklist/range.php', 0, NULL, 0, 1, 0, 1, 119, 0, 0, 0, -1, '0', 0, 1),
(122, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/captcha.php', 0, NULL, 0, 1, 0, 6, 113, 0, 0, 0, -1, '0', 0, 1),
(123, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/antispam.php', 0, NULL, 0, 1, 0, 7, 113, 0, 0, 0, -1, '0', 0, 1),
(124, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/maintenance.php', 0, NULL, 0, 1, 0, 8, 113, 0, 0, 0, -1, '0', 0, 1),
(125, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/permissions/trusted_proxies.php', 0, NULL, 0, 1, 0, 9, 113, 0, 0, 0, -1, '0', 0, 1),
(126, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/registration/view.php', 0, NULL, 0, 1, 10, 8, 66, 0, 0, 0, -1, '0', 0, 1),
(127, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/registration/open.php', 0, NULL, 0, 1, 0, 0, 126, 0, 0, 0, -1, '0', 0, 1),
(128, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/registration/postlogin.php', 0, NULL, 0, 1, 0, 1, 126, 0, 0, 0, -1, '0', 0, 1),
(129, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/registration/profiles.php', 0, NULL, 0, 1, 0, 2, 126, 0, 0, 0, -1, '0', 0, 1),
(130, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/registration/authentication.php', 0, NULL, 0, 1, 0, 3, 126, 0, 0, 0, -1, '0', 0, 1),
(131, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/registration/global_password_reset.php', 0, NULL, 0, 1, 0, 4, 126, 0, 0, 0, -1, '0', 0, 1),
(132, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/registration/notification.php', 0, NULL, 0, 1, 0, 5, 126, 0, 0, 0, -1, '0', 0, 1),
(133, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/registration/deactivation.php', 0, NULL, 0, 1, 0, 6, 126, 0, 0, 0, -1, '0', 0, 1),
(134, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/registration/automated_logout.php', 0, NULL, 0, 1, 0, 7, 126, 0, 0, 0, -1, '0', 0, 1),
(135, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/registration/password_requirements.php', 0, NULL, 0, 1, 0, 8, 126, 0, 0, 0, -1, '0', 0, 1),
(136, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/registration/session_options.php', 0, NULL, 0, 1, 0, 9, 126, 0, 0, 0, -1, '0', 0, 1),
(137, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/mail/view.php', 0, NULL, 0, 1, 3, 9, 66, 0, 0, 0, -1, '0', 0, 1),
(138, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/mail/method.php', 0, NULL, 0, 1, 1, 0, 137, 0, 0, 0, -1, '0', 0, 1),
(139, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/mail/method/test.php', 0, NULL, 0, 1, 0, 0, 138, 0, 0, 0, -1, '0', 0, 1),
(140, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/mail/importers.php', 0, NULL, 0, 1, 0, 1, 137, 0, 0, 0, -1, '0', 0, 1),
(141, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/mail/addresses.php', 0, NULL, 0, 1, 0, 2, 137, 0, 0, 0, -1, '0', 0, 1),
(142, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/calendar/view.php', 0, NULL, 0, 1, 4, 10, 66, 0, 0, 0, -1, '0', 0, 1),
(143, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/calendar/settings.php', 0, NULL, 0, 1, 0, 0, 142, 0, 0, 0, -1, '0', 0, 1),
(144, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/calendar/colors.php', 0, NULL, 0, 1, 0, 1, 142, 0, 0, 0, -1, '0', 0, 1),
(145, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/calendar/permissions.php', 0, NULL, 0, 1, 0, 2, 142, 0, 0, 0, -1, '0', 0, 1),
(146, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/calendar/import.php', 0, NULL, 0, 1, 0, 3, 142, 0, 0, 0, -1, '0', 0, 1),
(147, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/conversations/view.php', 0, NULL, 0, 1, 4, 11, 66, 0, 0, 0, -1, '0', 0, 1),
(148, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/conversations/settings.php', 0, NULL, 0, 1, 0, 0, 147, 0, 0, 0, -1, '0', 0, 1),
(149, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/conversations/points.php', 0, NULL, 0, 1, 0, 1, 147, 0, 0, 0, -1, '0', 0, 1),
(150, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/conversations/bannedwords.php', 0, NULL, 0, 1, 0, 2, 147, 0, 0, 0, -1, '0', 0, 1),
(151, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/conversations/permissions.php', 0, NULL, 0, 1, 0, 3, 147, 0, 0, 0, -1, '0', 0, 1),
(152, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/attributes/view.php', 0, NULL, 0, 1, 3, 12, 66, 0, 0, 0, -1, '0', 0, 1),
(153, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/attributes/types.php', 0, NULL, 0, 1, 0, 0, 152, 0, 0, 0, -1, '0', 0, 1),
(154, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/attributes/sets.php', 0, NULL, 0, 1, 0, 1, 152, 0, 0, 0, -1, '0', 0, 1),
(155, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/attributes/topics/view.php', 0, NULL, 0, 1, 1, 2, 152, 0, 0, 0, -1, '0', 0, 1),
(156, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/attributes/topics/add.php', 0, NULL, 0, 1, 0, 0, 155, 0, 0, 0, -1, '0', 0, 1),
(157, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/environment/view.php', 0, NULL, 0, 1, 7, 13, 66, 0, 0, 0, -1, '0', 0, 1),
(158, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/environment/info.php', 0, NULL, 0, 1, 0, 0, 157, 0, 0, 0, -1, '0', 0, 1),
(159, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/environment/debug.php', 0, NULL, 0, 1, 0, 1, 157, 0, 0, 0, -1, '0', 0, 1),
(160, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/environment/logging.php', 0, NULL, 0, 1, 0, 2, 157, 0, 0, 0, -1, '0', 0, 1),
(161, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/environment/proxy.php', 0, NULL, 0, 1, 0, 3, 157, 0, 0, 0, -1, '0', 0, 1),
(162, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/environment/entities.php', 0, NULL, 0, 1, 0, 4, 157, 0, 0, 0, -1, '0', 0, 1),
(163, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/environment/database_charset.php', 0, NULL, 0, 1, 0, 5, 157, 0, 0, 0, -1, '0', 0, 1),
(164, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/environment/geolocation.php', 0, NULL, 0, 1, 0, 6, 157, 0, 0, 0, -1, '0', 0, 1),
(165, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/update/view.php', 0, NULL, 0, 1, 1, 14, 66, 0, 0, 0, -1, '0', 0, 1),
(166, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/update/update.php', 0, NULL, 0, 1, 0, 0, 165, 0, 0, 0, -1, '0', 0, 1),
(167, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/api/view.php', 0, NULL, 0, 1, 2, 15, 66, 0, 0, 0, -1, '0', 0, 1),
(168, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/api/settings.php', 0, NULL, 0, 1, 0, 0, 167, 0, 0, 0, -1, '0', 0, 1),
(169, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/system/api/integrations.php', 0, NULL, 0, 1, 0, 1, 167, 0, 0, 0, -1, '0', 0, 1),
(170, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', '/dashboard/welcome.php', 0, NULL, 0, 1, 1, 0, 2, 0, 0, 0, -1, '0', 0, 1),
(171, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 2, 'PARENT', NULL, 0, NULL, 0, 1, 0, 0, 170, 0, 0, 0, -1, '0', 0, 1),
(172, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', '/!stacks/view.php', 0, NULL, 0, 1, 8, 0, 0, 0, 0, 0, -1, '0', 0, 1),
(173, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 173, 'OVERRIDE', '/page_not_found.php', 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 1),
(174, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', '/!trash/view.php', 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 1),
(175, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 175, 'OVERRIDE', '/login.php', 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 1),
(176, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 176, 'OVERRIDE', '/register.php', 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 1),
(177, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', '/account/view.php', 0, NULL, 0, 1, 3, 0, 0, 0, 0, 0, -1, '0', 0, 1),
(178, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', '/account/edit_profile.php', 0, NULL, 0, 1, 0, 0, 177, 0, 0, 0, -1, '0', 0, 1),
(179, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', '/account/avatar.php', 0, NULL, 0, 1, 0, 1, 177, 0, 0, 0, -1, '0', 0, 1),
(180, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', '/account/messages.php', 0, NULL, 0, 1, 0, 2, 177, 0, 0, 0, -1, '0', 0, 1),
(181, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 181, 'OVERRIDE', '/page_forbidden.php', 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 1),
(182, 0, 0, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', '/download_file.php', 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 1),
(183, 1, 0, 0, 1, 0, NULL, NULL, NULL, 1, 183, 'OVERRIDE', '/!drafts/view.php', 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 1),
(184, 1, 0, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', '/desktop.php', 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 1),
(185, 0, 1, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 0, 172, 0, 0, 0, -1, '0', 0, 1),
(186, 0, 1, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 1, 172, 0, 0, 0, -1, '0', 0, 1),
(187, 0, 1, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 2, 172, 0, 0, 0, -1, '0', 0, 1),
(188, 0, 1, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 3, 172, 0, 0, 0, -1, '0', 0, 1),
(189, 0, 1, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 4, 172, 0, 0, 0, -1, '0', 0, 1),
(190, 0, 1, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 5, 172, 0, 0, 0, -1, '0', 0, 1),
(191, 0, 1, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 6, 172, 0, 0, 0, -1, '0', 0, 1),
(192, 0, 1, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 7, 172, 0, 0, 0, -1, '0', 0, 1),
(193, 1, 5, 1, NULL, 0, NULL, NULL, NULL, 1, 193, 'OVERRIDE', NULL, 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 0),
(194, 1, 5, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 0, 1, 0, 0, 0, -1, '0', 0, 0),
(195, 1, 10, 1, NULL, 0, NULL, NULL, NULL, 1, 195, 'OVERRIDE', NULL, 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 0),
(196, 1, 10, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 6, 1, 1, 0, 0, 0, -1, '0', 0, 0),
(197, 1, 5, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 3, 2, 1, 0, 0, 0, -1, '0', 0, 0),
(198, 1, 9, 1, NULL, 0, NULL, NULL, NULL, 1, 198, 'OVERRIDE', NULL, 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 0),
(199, 1, 9, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 3, 3, 1, 0, 0, 0, -1, '0', 0, 0),
(200, 1, 5, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 4, 1, 0, 0, 0, -1, '0', 0, 0),
(201, 1, 5, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 5, 1, 0, 0, 0, -1, '0', 0, 0),
(202, 1, 5, 1, NULL, 0, NULL, NULL, NULL, 1, 202, 'OVERRIDE', NULL, 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 0),
(203, 1, 5, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 6, 1, 0, 0, 0, -1, '0', 0, 0),
(204, 1, 8, 1, NULL, 0, NULL, NULL, NULL, 1, 204, 'OVERRIDE', NULL, 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 0),
(205, 1, 8, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 0, 196, 0, 0, 0, -1, '0', 0, 0),
(206, 1, 8, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 1, 196, 0, 0, 0, -1, '0', 0, 0),
(207, 1, 8, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 2, 196, 0, 0, 0, -1, '0', 0, 0),
(208, 1, 8, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 3, 196, 0, 0, 0, -1, '0', 0, 0),
(209, 1, 8, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 4, 196, 0, 0, 0, -1, '0', 0, 0),
(210, 1, 8, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 5, 196, 0, 0, 0, -1, '0', 0, 0),
(211, 1, 6, 1, NULL, 0, NULL, NULL, NULL, 1, 211, 'OVERRIDE', NULL, 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 0),
(212, 1, 6, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 0, 199, 0, 0, 0, -1, '0', 0, 0),
(213, 1, 6, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 1, 199, 0, 0, 0, -1, '0', 0, 0),
(214, 1, 6, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 2, 199, 0, 0, 0, -1, '0', 0, 0),
(215, 1, 5, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 0, 197, 0, 0, 0, -1, '0', 0, 0),
(216, 1, 5, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 2, 1, 197, 0, 0, 0, -1, '0', 0, 0),
(217, 1, 5, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 2, 197, 0, 0, 0, -1, '0', 0, 0),
(218, 1, 7, 1, NULL, 0, NULL, NULL, NULL, 1, 218, 'OVERRIDE', NULL, 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 0),
(219, 1, 7, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 0, 216, 0, 0, 0, -1, '0', 0, 0),
(220, 1, 7, 0, 1, 0, NULL, NULL, NULL, 1, 1, 'PARENT', NULL, 0, NULL, 0, 1, 0, 1, 216, 0, 0, 0, -1, '0', 0, 0),
(221, 1, 5, 1, NULL, 0, NULL, NULL, NULL, 1, 221, 'OVERRIDE', NULL, 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 0),
(222, 1, 5, 1, NULL, 0, NULL, NULL, NULL, 1, 222, 'OVERRIDE', NULL, 0, NULL, 0, 1, 0, 0, 0, 0, 0, 0, -1, '0', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `PageSearchIndex`
--

CREATE TABLE `PageSearchIndex` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `content` longtext COLLATE utf8_unicode_ci,
  `cName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cDescription` text COLLATE utf8_unicode_ci,
  `cPath` text COLLATE utf8_unicode_ci,
  `cDatePublic` datetime DEFAULT NULL,
  `cDateLastIndexed` datetime DEFAULT NULL,
  `cDateLastSitemapped` datetime DEFAULT NULL,
  `cRequiresReindex` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`cID`),
  KEY `cDateLastIndexed` (`cDateLastIndexed`),
  KEY `cDateLastSitemapped` (`cDateLastSitemapped`),
  KEY `cRequiresReindex` (`cRequiresReindex`),
  FULLTEXT KEY `cName` (`cName`),
  FULLTEXT KEY `cDescription` (`cDescription`),
  FULLTEXT KEY `content` (`content`),
  FULLTEXT KEY `content2` (`cName`,`cDescription`,`content`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `PageSearchIndex`
--

INSERT INTO `PageSearchIndex` VALUES
(171, '', 'Waiting for Me', '', '/dashboard/welcome/me', '[[date_gmt]]', '[[date_gmt]]', NULL, 0),
(1, 'Stand Out on the Web \n                                     Share your business with an impressive, yet minimal presentation. Let your customers understand your web presence through elegance and clarity.  A Simple Image Slider \n                                     This image slider can have any content that you want in it.   Easy to Edit \n                                                    Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. Pixel Perfect \n                                                    Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. Media Rich \n                                                    Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. \n                                    Presenting your Business has never been so easy Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna.   Latest Blog Post Now Open For Business \n                                                       We specialize in making your concepts a reality.          Sed cursus facilisis dignissim. Aliquam rhoncus enim et pellentesque varius. Nulla sodales nibh lorem, sit amet imperdiet arcu commodo sit amet. Mauris sed scelerisque nisl. Ut auctor ipsum tellus, vel viverra massa elementum sit amet.          Sed adipiscing tempus sem eu molestie. Aenean laoreet pretium ante vitae ultrices. Aenean eu gravida magna, vel aliquet magna. In auctor convallis gravida.            Contact Us Today    \n                                    Customizable footer area with accent class.  ', 'Home', '', NULL, '[[date_gmt]]', '[[date_gmt]]', NULL, 0),
(194, 'Our Expertise Quality \n                                                    Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla sodales non leo id aliquet. Design \n                                                    Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla sodales non leo id aliquet. Development \n                                                    Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla sodales non leo id aliquet. Security \n                                                    Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla sodales non leo id aliquet. \n                                                    Awesome Features Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. Sed consequat eleifend metus, vitae malesuada eros elementum sed.  Guide Books Fusce risus felis, viverra et dignissim at, lobortis non est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam sit amet consectetur lacus. Vestibulum neque lectus, egestas non cursus vitae, aliquam at magna. Etiam aliquam, justo et varius eleifend, dui lectus egestas nunc, vel malesuada nisl purus nec metus.  Admin Accounts Fusce risus felis, viverra et dignissim at, lobortis non est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam sit amet consectetur lacus. Vestibulum neque lectus, egestas non cursus vitae, aliquam at magna. Etiam aliquam, justo et varius eleifend, dui lectus egestas nunc, vel malesuada nisl purus nec metus.   \n                                                    Support Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. Sed consequat eleifend metus, vitae malesuada eros elementum sed.  Additional Options Fusce risus felis, viverra et dignissim at, lobortis non est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam sit amet consectetur lacus. Vestibulum neque lectus, egestas non cursus vitae, aliquam at magna.   Etiam aliquam, justo et varius eleifend, dui lectus egestas nunc, vel malesuada nisl purus nec metus. In gravida turpis a pharetra commodo. Donec non turpis vulputate, faucibus metus a, consectetur nunc. Morbi tortor nisi, hendrerit sed laoreet eget, fermentum et justo. Suspendisse potenti.  \n                                    What Clients Are Saying About Us  Franz Maruna\nCEO & Founder\nconcrete5\n\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. John Doe\nMarketing Directory\nCompanyCo\n\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. Andrew Embler\nCTO & Founder\nconcrete5\n\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. Jane Doe\nIT Manager\nCompanyCo\n\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. ', 'Services', '', '/services', '[[date_gmt]]', '[[date_gmt]]', NULL, 0),
(196, '', 'Portfolio', '', '/portfolio', '[[date_gmt]]', '[[date_gmt]]', NULL, 0),
(205, '\n                                    Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi tempus nibh a laoreet cursus. Phasellus malesuada vulputate bibendum. Ut vitae justo nisi. Sed consectetur vestibulum tortor, in bibendum diam lacinia vitae. Nullam volutpat risus quis orci consectetur adipiscing. In commodo vulputate arcu sit amet ornare. Vivamus ut iaculis velit. Pellentesque euismod lacus sed accumsan luctus. Suspendisse urna felis, lacinia vel tempor id, ultricies rutrum nisl. Nunc ultrices nulla et bibendum molestie. Phasellus porttitor sit amet libero vel fermentum. Sed sapien risus, eleifend vel hendrerit eu, porta vel tellus. Duis faucibus odio et magna varius, quis accumsan tellus vestibulum. Nam nunc nulla, convallis at elementum pharetra, adipiscing quis enim. Donec feugiat porttitor dolor, nec porttitor mi auctor eget. Fusce iaculis varius diam non dictum. Fusce elementum a nunc vel tincidunt. Morbi nec est elementum, vehicula odio nec, lobortis lacus. Nulla ultricies vitae nunc ut lacinia. Proin mattis felis sem, eu consectetur arcu varius et. Duis at lectus eu lorem elementum aliquet nec in elit. Vestibulum non metus ac risus adipiscing pellentesque sed sit amet lorem. Donec viverra, metus in varius pulvinar, augue nunc accumsan eros, a pulvinar est elit vitae nulla.  Duis non leo in enim laoreet pretium. Nullam vitae neque nec libero pharetra tempor at faucibus lectus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed imperdiet convallis arcu. Nam sollicitudin sollicitudin lacus non dictum. Aliquam erat volutpat. Nulla sapien quam, consequat non dui ut, eleifend sodales orci. Praesent quis lorem accumsan, volutpat lectus a, sollicitudin erat. Donec faucibus mi in sapien volutpat, ac auctor lorem mollis. Proin eget turpis non lacus bibendum porta non ac justo. Aliquam aliquam viverra lorem ac rutrum. In et sapien sit amet diam vestibulum cursus ut tristique tellus.  Ut in purus mi. Etiam ac aliquet ipsum. Pellentesque faucibus diam dui. Morbi a semper orci. Ut nec malesuada urna. Vestibulum aliquet ante ac lacus dictum, sit amet pulvinar leo laoreet. Maecenas ut est commodo, commodo quam nec, dignissim est. Quisque rutrum molestie nunc, sed mollis nulla volutpat et. Donec dignissim ornare augue eu aliquam. Aliquam in tincidunt velit. In at fermentum mauris, ut accumsan nisl. Interdum et malesuada fames ac ante ipsum primis in faucibus.  Integer ac nulla at nisi sodales ullamcorper id in justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Etiam pharetra elit odio, ac mattis turpis consequat ac. Pellentesque tincidunt sed enim nec auctor. Quisque varius, felis a hendrerit faucibus, nunc lorem varius nibh, vel dignissim velit dolor ut elit. Mauris ut vulputate neque. Donec at est vitae massa egestas fringilla. Praesent a tristique nibh. Nunc blandit dui risus, quis rhoncus nisi consectetur vel.  ', 'Project Title', 'Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing.', '/portfolio/project-title', '2014-08-06 15:30:00', '[[date_gmt]]', NULL, 0),
(206, '\n                                    Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi tempus nibh a laoreet cursus. Phasellus malesuada vulputate bibendum. Ut vitae justo nisi. Sed consectetur vestibulum tortor, in bibendum diam lacinia vitae. Nullam volutpat risus quis orci consectetur adipiscing. In commodo vulputate arcu sit amet ornare. Vivamus ut iaculis velit. Pellentesque euismod lacus sed accumsan luctus. Suspendisse urna felis, lacinia vel tempor id, ultricies rutrum nisl. Nunc ultrices nulla et bibendum molestie. Phasellus porttitor sit amet libero vel fermentum. Sed sapien risus, eleifend vel hendrerit eu, porta vel tellus. Duis faucibus odio et magna varius, quis accumsan tellus vestibulum. Nam nunc nulla, convallis at elementum pharetra, adipiscing quis enim. Donec feugiat porttitor dolor, nec porttitor mi auctor eget. Fusce iaculis varius diam non dictum. Fusce elementum a nunc vel tincidunt. Morbi nec est elementum, vehicula odio nec, lobortis lacus. Nulla ultricies vitae nunc ut lacinia. Proin mattis felis sem, eu consectetur arcu varius et. Duis at lectus eu lorem elementum aliquet nec in elit. Vestibulum non metus ac risus adipiscing pellentesque sed sit amet lorem. Donec viverra, metus in varius pulvinar, augue nunc accumsan eros, a pulvinar est elit vitae nulla.  Duis non leo in enim laoreet pretium. Nullam vitae neque nec libero pharetra tempor at faucibus lectus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed imperdiet convallis arcu. Nam sollicitudin sollicitudin lacus non dictum. Aliquam erat volutpat. Nulla sapien quam, consequat non dui ut, eleifend sodales orci. Praesent quis lorem accumsan, volutpat lectus a, sollicitudin erat. Donec faucibus mi in sapien volutpat, ac auctor lorem mollis. Proin eget turpis non lacus bibendum porta non ac justo. Aliquam aliquam viverra lorem ac rutrum. In et sapien sit amet diam vestibulum cursus ut tristique tellus.  Ut in purus mi. Etiam ac aliquet ipsum. Pellentesque faucibus diam dui. Morbi a semper orci. Ut nec malesuada urna. Vestibulum aliquet ante ac lacus dictum, sit amet pulvinar leo laoreet. Maecenas ut est commodo, commodo quam nec, dignissim est. Quisque rutrum molestie nunc, sed mollis nulla volutpat et. Donec dignissim ornare augue eu aliquam. Aliquam in tincidunt velit. In at fermentum mauris, ut accumsan nisl. Interdum et malesuada fames ac ante ipsum primis in faucibus.  Integer ac nulla at nisi sodales ullamcorper id in justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Etiam pharetra elit odio, ac mattis turpis consequat ac. Pellentesque tincidunt sed enim nec auctor. Quisque varius, felis a hendrerit faucibus, nunc lorem varius nibh, vel dignissim velit dolor ut elit. Mauris ut vulputate neque. Donec at est vitae massa egestas fringilla. Praesent a tristique nibh. Nunc blandit dui risus, quis rhoncus nisi consectetur vel.  ', 'Project Title 2', 'Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing.', '/portfolio/project-title-2', '2014-08-06 15:20:00', '[[date_gmt]]', NULL, 0),
(207, '\n                                    Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi tempus nibh a laoreet cursus. Phasellus malesuada vulputate bibendum. Ut vitae justo nisi. Sed consectetur vestibulum tortor, in bibendum diam lacinia vitae. Nullam volutpat risus quis orci consectetur adipiscing. In commodo vulputate arcu sit amet ornare. Vivamus ut iaculis velit. Pellentesque euismod lacus sed accumsan luctus. Suspendisse urna felis, lacinia vel tempor id, ultricies rutrum nisl. Nunc ultrices nulla et bibendum molestie. Phasellus porttitor sit amet libero vel fermentum. Sed sapien risus, eleifend vel hendrerit eu, porta vel tellus. Duis faucibus odio et magna varius, quis accumsan tellus vestibulum. Nam nunc nulla, convallis at elementum pharetra, adipiscing quis enim. Donec feugiat porttitor dolor, nec porttitor mi auctor eget. Fusce iaculis varius diam non dictum. Fusce elementum a nunc vel tincidunt. Morbi nec est elementum, vehicula odio nec, lobortis lacus. Nulla ultricies vitae nunc ut lacinia. Proin mattis felis sem, eu consectetur arcu varius et. Duis at lectus eu lorem elementum aliquet nec in elit. Vestibulum non metus ac risus adipiscing pellentesque sed sit amet lorem. Donec viverra, metus in varius pulvinar, augue nunc accumsan eros, a pulvinar est elit vitae nulla.  Duis non leo in enim laoreet pretium. Nullam vitae neque nec libero pharetra tempor at faucibus lectus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed imperdiet convallis arcu. Nam sollicitudin sollicitudin lacus non dictum. Aliquam erat volutpat. Nulla sapien quam, consequat non dui ut, eleifend sodales orci. Praesent quis lorem accumsan, volutpat lectus a, sollicitudin erat. Donec faucibus mi in sapien volutpat, ac auctor lorem mollis. Proin eget turpis non lacus bibendum porta non ac justo. Aliquam aliquam viverra lorem ac rutrum. In et sapien sit amet diam vestibulum cursus ut tristique tellus.  Ut in purus mi. Etiam ac aliquet ipsum. Pellentesque faucibus diam dui. Morbi a semper orci. Ut nec malesuada urna. Vestibulum aliquet ante ac lacus dictum, sit amet pulvinar leo laoreet. Maecenas ut est commodo, commodo quam nec, dignissim est. Quisque rutrum molestie nunc, sed mollis nulla volutpat et. Donec dignissim ornare augue eu aliquam. Aliquam in tincidunt velit. In at fermentum mauris, ut accumsan nisl. Interdum et malesuada fames ac ante ipsum primis in faucibus.  Integer ac nulla at nisi sodales ullamcorper id in justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Etiam pharetra elit odio, ac mattis turpis consequat ac. Pellentesque tincidunt sed enim nec auctor. Quisque varius, felis a hendrerit faucibus, nunc lorem varius nibh, vel dignissim velit dolor ut elit. Mauris ut vulputate neque. Donec at est vitae massa egestas fringilla. Praesent a tristique nibh. Nunc blandit dui risus, quis rhoncus nisi consectetur vel.  ', 'Project Title 3', 'Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing.', '/portfolio/project-title-3', '2014-08-06 15:10:00', '[[date_gmt]]', NULL, 0),
(208, '\n                                    Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi tempus nibh a laoreet cursus. Phasellus malesuada vulputate bibendum. Ut vitae justo nisi. Sed consectetur vestibulum tortor, in bibendum diam lacinia vitae. Nullam volutpat risus quis orci consectetur adipiscing. In commodo vulputate arcu sit amet ornare. Vivamus ut iaculis velit. Pellentesque euismod lacus sed accumsan luctus. Suspendisse urna felis, lacinia vel tempor id, ultricies rutrum nisl. Nunc ultrices nulla et bibendum molestie. Phasellus porttitor sit amet libero vel fermentum. Sed sapien risus, eleifend vel hendrerit eu, porta vel tellus. Duis faucibus odio et magna varius, quis accumsan tellus vestibulum. Nam nunc nulla, convallis at elementum pharetra, adipiscing quis enim. Donec feugiat porttitor dolor, nec porttitor mi auctor eget. Fusce iaculis varius diam non dictum. Fusce elementum a nunc vel tincidunt. Morbi nec est elementum, vehicula odio nec, lobortis lacus. Nulla ultricies vitae nunc ut lacinia. Proin mattis felis sem, eu consectetur arcu varius et. Duis at lectus eu lorem elementum aliquet nec in elit. Vestibulum non metus ac risus adipiscing pellentesque sed sit amet lorem. Donec viverra, metus in varius pulvinar, augue nunc accumsan eros, a pulvinar est elit vitae nulla.  Duis non leo in enim laoreet pretium. Nullam vitae neque nec libero pharetra tempor at faucibus lectus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed imperdiet convallis arcu. Nam sollicitudin sollicitudin lacus non dictum. Aliquam erat volutpat. Nulla sapien quam, consequat non dui ut, eleifend sodales orci. Praesent quis lorem accumsan, volutpat lectus a, sollicitudin erat. Donec faucibus mi in sapien volutpat, ac auctor lorem mollis. Proin eget turpis non lacus bibendum porta non ac justo. Aliquam aliquam viverra lorem ac rutrum. In et sapien sit amet diam vestibulum cursus ut tristique tellus.  Ut in purus mi. Etiam ac aliquet ipsum. Pellentesque faucibus diam dui. Morbi a semper orci. Ut nec malesuada urna. Vestibulum aliquet ante ac lacus dictum, sit amet pulvinar leo laoreet. Maecenas ut est commodo, commodo quam nec, dignissim est. Quisque rutrum molestie nunc, sed mollis nulla volutpat et. Donec dignissim ornare augue eu aliquam. Aliquam in tincidunt velit. In at fermentum mauris, ut accumsan nisl. Interdum et malesuada fames ac ante ipsum primis in faucibus.  Integer ac nulla at nisi sodales ullamcorper id in justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Etiam pharetra elit odio, ac mattis turpis consequat ac. Pellentesque tincidunt sed enim nec auctor. Quisque varius, felis a hendrerit faucibus, nunc lorem varius nibh, vel dignissim velit dolor ut elit. Mauris ut vulputate neque. Donec at est vitae massa egestas fringilla. Praesent a tristique nibh. Nunc blandit dui risus, quis rhoncus nisi consectetur vel.  ', 'Project Title 4', 'Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing.', '/portfolio/project-title-4', '2014-08-06 15:00:00', '[[date_gmt]]', NULL, 0),
(209, '\n                                    Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi tempus nibh a laoreet cursus. Phasellus malesuada vulputate bibendum. Ut vitae justo nisi. Sed consectetur vestibulum tortor, in bibendum diam lacinia vitae. Nullam volutpat risus quis orci consectetur adipiscing. In commodo vulputate arcu sit amet ornare. Vivamus ut iaculis velit. Pellentesque euismod lacus sed accumsan luctus. Suspendisse urna felis, lacinia vel tempor id, ultricies rutrum nisl. Nunc ultrices nulla et bibendum molestie. Phasellus porttitor sit amet libero vel fermentum. Sed sapien risus, eleifend vel hendrerit eu, porta vel tellus. Duis faucibus odio et magna varius, quis accumsan tellus vestibulum. Nam nunc nulla, convallis at elementum pharetra, adipiscing quis enim. Donec feugiat porttitor dolor, nec porttitor mi auctor eget. Fusce iaculis varius diam non dictum. Fusce elementum a nunc vel tincidunt. Morbi nec est elementum, vehicula odio nec, lobortis lacus. Nulla ultricies vitae nunc ut lacinia. Proin mattis felis sem, eu consectetur arcu varius et. Duis at lectus eu lorem elementum aliquet nec in elit. Vestibulum non metus ac risus adipiscing pellentesque sed sit amet lorem. Donec viverra, metus in varius pulvinar, augue nunc accumsan eros, a pulvinar est elit vitae nulla.  Duis non leo in enim laoreet pretium. Nullam vitae neque nec libero pharetra tempor at faucibus lectus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed imperdiet convallis arcu. Nam sollicitudin sollicitudin lacus non dictum. Aliquam erat volutpat. Nulla sapien quam, consequat non dui ut, eleifend sodales orci. Praesent quis lorem accumsan, volutpat lectus a, sollicitudin erat. Donec faucibus mi in sapien volutpat, ac auctor lorem mollis. Proin eget turpis non lacus bibendum porta non ac justo. Aliquam aliquam viverra lorem ac rutrum. In et sapien sit amet diam vestibulum cursus ut tristique tellus.  Ut in purus mi. Etiam ac aliquet ipsum. Pellentesque faucibus diam dui. Morbi a semper orci. Ut nec malesuada urna. Vestibulum aliquet ante ac lacus dictum, sit amet pulvinar leo laoreet. Maecenas ut est commodo, commodo quam nec, dignissim est. Quisque rutrum molestie nunc, sed mollis nulla volutpat et. Donec dignissim ornare augue eu aliquam. Aliquam in tincidunt velit. In at fermentum mauris, ut accumsan nisl. Interdum et malesuada fames ac ante ipsum primis in faucibus.  Integer ac nulla at nisi sodales ullamcorper id in justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Etiam pharetra elit odio, ac mattis turpis consequat ac. Pellentesque tincidunt sed enim nec auctor. Quisque varius, felis a hendrerit faucibus, nunc lorem varius nibh, vel dignissim velit dolor ut elit. Mauris ut vulputate neque. Donec at est vitae massa egestas fringilla. Praesent a tristique nibh. Nunc blandit dui risus, quis rhoncus nisi consectetur vel.  ', 'Project Title 5', 'Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing.', '/portfolio/project-title-5', '2014-08-06 14:30:00', '[[date_gmt]]', NULL, 0),
(210, '\n                                    Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi tempus nibh a laoreet cursus. Phasellus malesuada vulputate bibendum. Ut vitae justo nisi. Sed consectetur vestibulum tortor, in bibendum diam lacinia vitae. Nullam volutpat risus quis orci consectetur adipiscing. In commodo vulputate arcu sit amet ornare. Vivamus ut iaculis velit. Pellentesque euismod lacus sed accumsan luctus. Suspendisse urna felis, lacinia vel tempor id, ultricies rutrum nisl. Nunc ultrices nulla et bibendum molestie. Phasellus porttitor sit amet libero vel fermentum. Sed sapien risus, eleifend vel hendrerit eu, porta vel tellus. Duis faucibus odio et magna varius, quis accumsan tellus vestibulum. Nam nunc nulla, convallis at elementum pharetra, adipiscing quis enim. Donec feugiat porttitor dolor, nec porttitor mi auctor eget. Fusce iaculis varius diam non dictum. Fusce elementum a nunc vel tincidunt. Morbi nec est elementum, vehicula odio nec, lobortis lacus. Nulla ultricies vitae nunc ut lacinia. Proin mattis felis sem, eu consectetur arcu varius et. Duis at lectus eu lorem elementum aliquet nec in elit. Vestibulum non metus ac risus adipiscing pellentesque sed sit amet lorem. Donec viverra, metus in varius pulvinar, augue nunc accumsan eros, a pulvinar est elit vitae nulla.  Duis non leo in enim laoreet pretium. Nullam vitae neque nec libero pharetra tempor at faucibus lectus. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed imperdiet convallis arcu. Nam sollicitudin sollicitudin lacus non dictum. Aliquam erat volutpat. Nulla sapien quam, consequat non dui ut, eleifend sodales orci. Praesent quis lorem accumsan, volutpat lectus a, sollicitudin erat. Donec faucibus mi in sapien volutpat, ac auctor lorem mollis. Proin eget turpis non lacus bibendum porta non ac justo. Aliquam aliquam viverra lorem ac rutrum. In et sapien sit amet diam vestibulum cursus ut tristique tellus.  Ut in purus mi. Etiam ac aliquet ipsum. Pellentesque faucibus diam dui. Morbi a semper orci. Ut nec malesuada urna. Vestibulum aliquet ante ac lacus dictum, sit amet pulvinar leo laoreet. Maecenas ut est commodo, commodo quam nec, dignissim est. Quisque rutrum molestie nunc, sed mollis nulla volutpat et. Donec dignissim ornare augue eu aliquam. Aliquam in tincidunt velit. In at fermentum mauris, ut accumsan nisl. Interdum et malesuada fames ac ante ipsum primis in faucibus.  Integer ac nulla at nisi sodales ullamcorper id in justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Etiam pharetra elit odio, ac mattis turpis consequat ac. Pellentesque tincidunt sed enim nec auctor. Quisque varius, felis a hendrerit faucibus, nunc lorem varius nibh, vel dignissim velit dolor ut elit. Mauris ut vulputate neque. Donec at est vitae massa egestas fringilla. Praesent a tristique nibh. Nunc blandit dui risus, quis rhoncus nisi consectetur vel.  ', 'Project Title 6', 'Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing.', '/portfolio/project-title-6', '2014-08-06 14:20:00', '[[date_gmt]]', NULL, 0),
(197, 'John Smith\nCo-Founder / CEO\n\n\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Bob Smith\nCo-Founder / CTO\n\n\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. John Smith\nArt Director\n\n\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. John Smith\nArt Director\n\n\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Bob Smith\nArt Director\n\n\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Bob Smith\nArt Director\n\n\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Bob Smith\nArt Director\n\n\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Bob Smith\nArt Director\n\n\n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. \n                                                    Get in Touch  Sed cursus facilisis dignissim. Aliquam rhoncus enim et pellentesque varius. Nulla sodales nibh lorem, sit amet imperdiet arcu commodo sit amet.    Contact Us  ', 'Team', '', '/team', '[[date_gmt]]', '[[date_gmt]]', NULL, 0),
(199, '', 'Blog', '', '/blog', '[[date_gmt]]', '[[date_gmt]]', NULL, 0),
(212, '\n                                    Fusce volutpat sodales mauris quis dapibus. Maecenas convallis, libero eu ultrices interdum, leo mauris commodo diam, sed cursus sapien ligula nec leo. Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. Sed consequat eleifend metus, vitae malesuada eros elementum sed. Fusce risus felis, viverra et dignissim at, lobortis non est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam sit amet consectetur lacus. Vestibulum neque lectus, egestas non cursus vitae, aliquam at magna. Etiam aliquam, justo et varius eleifend, dui lectus egestas nunc, vel malesuada nisl purus nec metus. In gravida turpis a pharetra commodo. Donec non turpis vulputate, faucibus metus a, consectetur nunc. Morbi tortor nisi, hendrerit sed laoreet eget, fermentum et justo. Suspendisse potenti.   Heading 2 Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. Sed consequat eleifend metus, vitae malesuada eros elementum sed. Fusce risus felis, viverra et dignissim at, lobortis non est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam sit amet consectetur lacus. Vestibulum neque lectus, egestas non cursus vitae, aliquam at magna. Etiam aliquam, justo et varius eleifend, dui lectus egestas nunc, vel malesuada nisl purus nec metus. In gravida turpis a pharetra commodo. Donec non turpis vulputate, faucibus metus a, consectetur nunc. Morbi tortor nisi, hendrerit sed laoreet eget, fermentum et justo. Suspendisse potenti. Heading 3 Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. Quisque dignissim neque a ipsum sodales, mattis aliquam ante dictum. Vestibulum elementum pellentesque tortor ac congue. Mauris vel nibh id metus tincidunt eleifend. In interdum gravida ligula, at venenatis odio fermentum at. Donec dapibus enim lectus, quis venenatis tellus volutpat in. Nullam in velit tortor. Heading 3 Donec blandit lectus nec neque ullamcorper rhoncus. Sed adipiscing tempus sem eu molestie. Aenean laoreet pretium ante vitae ultrices. Aenean eu gravida magna, vel aliquet magna. In auctor convallis gravida. Phasellus est erat, adipiscing nec lobortis quis, eleifend at sem. Curabitur fringilla viverra dolor, in rutrum ipsum rutrum sit amet. Vestibulum feugiat porttitor ipsum vel condimentum. Suspendisse at tempus libero. Sed eu tempor enim. Etiam convallis eleifend rutrum. Donec porta diam quis tellus feugiat dignissim. Cras posuere, massa eget laoreet laoreet, urna libero lobortis dolor, sed consequat elit urna eget massa. Donec aliquet pellentesque consectetur.  ', 'Hello World!', 'Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. Quisque dignissim neque a ipsum sodales, mattis aliquam ante dictum.', '/blog/hello-world', '2014-07-01 12:00:00', '[[date_gmt]]', NULL, 0),
(213, '\n                                     Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. Sed consequat eleifend metus, vitae malesuada eros elementum sed. Fusce risus felis, viverra et dignissim at, lobortis non est. Lorem ipsum dolor sit amet, consectetur adipiscing elit.   CMS To the Rescue!  Nullam sit amet consectetur lacus. Vestibulum neque lectus, egestas non cursus vitae, aliquam at magna. Etiam aliquam, justo et varius eleifend, dui lectus egestas nunc, vel malesuada nisl purus nec metus. In gravida turpis a pharetra commodo. Donec non turpis vulputate, faucibus metus a, consectetur nunc. Morbi tortor nisi, hendrerit sed laoreet eget, fermentum et justo. Suspendisse potenti.  Learn more at concrete5.org    ', 'Another Blog Post', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam sit amet consectetur lacus. Vestibulum neque lectus, egestas non cursus vitae, aliquam at magna.', '/blog/another-blog-post', '2014-07-04 15:00:00', '[[date_gmt]]', NULL, 0),
(214, '\n                                     Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. Sed consequat eleifend metus, vitae malesuada eros elementum sed. Fusce risus felis, viverra et dignissim at, lobortis non est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam sit amet consectetur lacus. Vestibulum neque lectus, egestas non cursus vitae, aliquam at magna. Etiam aliquam, justo et varius eleifend, dui lectus egestas nunc, vel malesuada nisl purus nec metus. In gravida turpis a pharetra commodo. Donec non turpis vulputate, faucibus metus a, consectetur nunc. Morbi tortor nisi, hendrerit sed laoreet eget, fermentum et justo. Suspendisse potenti.  Heading 3  Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. Quisque dignissim neque a ipsum sodales, mattis aliquam ante dictum. Vestibulum elementum pellentesque tortor ac congue. Mauris vel nibh id metus tincidunt eleifend. In interdum gravida ligula, at venenatis odio fermentum at. Donec dapibus enim lectus, quis venenatis tellus volutpat in. Nullam in velit tortor.    Look at my beautiful image. Don''t you to look more?  Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. Quisque dignissim neque a ipsum sodales, mattis aliquam ante dictum. Vestibulum elementum pellentesque tortor ac congue. Mauris vel nibh id metus tincidunt eleifend. In interdum gravida ligula, at venenatis odio fermentum at. Donec dapibus enim lectus, quis venenatis tellus volutpat in. Nullam in velit tortor.  ', 'A Beautiful Site Deserves a Beautiful Blog', 'Donec blandit lectus nec neque ullamcorper rhoncus. Sed adipiscing tempus sem eu molestie. Aenean laoreet pretium ante vitae ultrices. Aenean eu gravida magna, vel aliquet magna. In auctor convallis gravida. Phasellus est erat.', '/blog/a-beautiful-blog', '2014-08-01 16:30:00', '[[date_gmt]]', NULL, 0),
(200, '', 'Search', '', '/search', '[[date_gmt]]', '[[date_gmt]]', NULL, 0),
(201, '\n                                                    Headquarters 1234 SE Street View Suite 301 Portland, OR 98101 HOURS  M-F:  10 AM - 7 PM Sat: Noon - Midnight Sun: Closed  \n                                                    Choosing Us Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. Quisque dignissim neque a ipsum sodales, mattis aliquam ante dictum. Vestibulum elementum pellentesque tortor ac congue. Mauris vel nibh id metus tincidunt eleifend. In interdum gravida ligula, at venenatis odio fermentum at. Donec dapibus enim lectus, quis venenatis tellus volutpat in. Nullam in velit tortor.  We would love to hear from you! ', 'Contact', '', '/contact', '[[date_gmt]]', '[[date_gmt]]', NULL, 0),
(203, ' This is my empty content block on my blank page.  ', 'Blank Page', '', '/blank-page', '[[date_gmt]]', '[[date_gmt]]', NULL, 0),
(215, '\n                                                    Fusce volutpat sodales mauris quis dapibus. Maecenas convallis, libero eu ultrices interdum. \n                                                     Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna.   Quisque dignissim neque a ipsum sodales, mattis aliquam ante dictum. Vestibulum elementum pellentesque tortor ac congue. Mauris vel nibh id metus tincidunt eleifend.  \n                                                    Heading 1Heading 2Heading 3Heading 4Heading 5Heading 6 \n                                                     Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. Sed consequat eleifend metus, vitae malesuada eros elementum sed. Fusce risus felis, viverra et dignissim at, lobortis non est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam sit amet consectetur lacus. Vestibulum neque lectus, egestas non cursus vitae, aliquam at magna. Etiam aliquam, justo et varius eleifend, dui lectus egestas nunc, vel malesuada nisl purus nec metus. In gravida turpis a pharetra commodo. Donec non turpis vulputate, faucibus metus a, consectetur nunc. Morbi tortor nisi, hendrerit sed laoreet eget, fermentum et justo. Suspendisse potenti.     \n                                                       Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. Sed consequat eleifend metus, vitae malesuada eros elementum sed. Fusce risus felis, viverra et dignissim at, lobortis non est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam sit amet consectetur lacus. Vestibulum neque lectus, egestas non cursus vitae, aliquam at magna. Etiam aliquam, justo et varius eleifend, dui lectus egestas nunc, vel malesuada nisl purus nec metus. In gravida turpis a pharetra commodo. Donec non turpis vulputate, faucibus metus a, consectetur nunc. Morbi tortor nisi, hendrerit sed laoreet eget, fermentum et justo. Suspendisse potenti.  \n                                                    Get in Touch  Sed cursus facilisis dignissim. Aliquam rhoncus enim et pellentesque varius. Nulla sodales nibh lorem, sit amet imperdiet arcu commodo sit amet.    Contact Us  ', 'About', '', '/team/about', '[[date_gmt]]', '[[date_gmt]]', NULL, 0),
(216, 'Work with Us   Welcome Home \n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Great Workers \n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Amazing Location \n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Paid Time Off \n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. No Meetings \n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Free Drinks \n                                                    Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. \n                                                    Open Positions  ', 'Careers', '', '/team/careers', '[[date_gmt]]', '[[date_gmt]]', NULL, 0),
(219, '\n                                                      Back to Careers  Department Location Job Information \n                                                       \n                                     Quisque accumsan leo sit amet neque pretium consectetur. Sed blandit nulla at justo volutpat rhoncus. Sed risus orci, luctus sit amet fringilla faucibus, congue nec dui. Phasellus mattis lobortis magna sed dapibus. Donec sagittis nunc sed accumsan eleifend. Ut porttitor sapien eu nisl volutpat, vitae interdum est mollis. Sed laoreet sit amet elit in eleifend. Sed a tincidunt velit, nec posuere urna. In eget metus non est varius viverra. Quisque accumsan odio sem, in consequat nunc lobortis ac.  Cras dignissim nulla ut euismod adipiscing. Mauris non eros sem. Cras at lacinia nulla. Maecenas nec magna arcu. Aenean iaculis, augue sed pretium semper, odio tellus volutpat risus, quis consectetur nibh mauris ut odio. Integer convallis, augue a accumsan condimentum, sem nisl congue lorem, consectetur lacinia neque tortor eu neque. Aenean convallis arcu vitae enim dignissim vestibulum. Phasellus tincidunt dolor id enim gravida ullamcorper. Nullam ut lorem auctor, congue quam non, auctor arcu. Morbi ac aliquam ipsum, at aliquet ligula.  Cras adipiscing tellus non nulla suscipit congue. Pellentesque id neque euismod, elementum augue vel, volutpat turpis. Pellentesque sit amet tortor non lorem hendrerit pellentesque ac in nisi. Sed aliquet tincidunt arcu, eu lacinia lorem fringilla id. Integer ut ornare orci. Donec scelerisque vulputate est a condimentum. Morbi tellus sapien, vehicula vel ipsum non, luctus ullamcorper mi. Phasellus felis tortor, egestas quis felis sit amet, malesuada auctor nibh. Sed mollis mi sit amet tristique scelerisque. Cras elementum mauris urna, ullamcorper consectetur orci vehicula ut.  ', 'Web Developer', 'Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. Sed consequat eleifend metus, vitae malesuada eros elementum sed. Fusce risus felis, viverra et dignissim at, lobortis non est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam sit amet consectetur lacus.', '/team/careers/web-developer', '[[date_gmt]]', '[[date_gmt]]', NULL, 0),
(220, '\n                                                      Back to Careers  Department Location Job Information \n                                                       \n                                     Quisque accumsan leo sit amet neque pretium consectetur. Sed blandit nulla at justo volutpat rhoncus. Sed risus orci, luctus sit amet fringilla faucibus, congue nec dui. Phasellus mattis lobortis magna sed dapibus. Donec sagittis nunc sed accumsan eleifend. Ut porttitor sapien eu nisl volutpat, vitae interdum est mollis. Sed laoreet sit amet elit in eleifend. Sed a tincidunt velit, nec posuere urna. In eget metus non est varius viverra. Quisque accumsan odio sem, in consequat nunc lobortis ac.  Cras dignissim nulla ut euismod adipiscing. Mauris non eros sem. Cras at lacinia nulla. Maecenas nec magna arcu. Aenean iaculis, augue sed pretium semper, odio tellus volutpat risus, quis consectetur nibh mauris ut odio. Integer convallis, augue a accumsan condimentum, sem nisl congue lorem, consectetur lacinia neque tortor eu neque. Aenean convallis arcu vitae enim dignissim vestibulum. Phasellus tincidunt dolor id enim gravida ullamcorper. Nullam ut lorem auctor, congue quam non, auctor arcu. Morbi ac aliquam ipsum, at aliquet ligula.  Cras adipiscing tellus non nulla suscipit congue. Pellentesque id neque euismod, elementum augue vel, volutpat turpis. Pellentesque sit amet tortor non lorem hendrerit pellentesque ac in nisi. Sed aliquet tincidunt arcu, eu lacinia lorem fringilla id. Integer ut ornare orci. Donec scelerisque vulputate est a condimentum. Morbi tellus sapien, vehicula vel ipsum non, luctus ullamcorper mi. Phasellus felis tortor, egestas quis felis sit amet, malesuada auctor nibh. Sed mollis mi sit amet tristique scelerisque. Cras elementum mauris urna, ullamcorper consectetur orci vehicula ut.  ', 'Sales Associate', 'Curabitur sagittis elementum felis at sodales. Nullam fermentum at urna quis accumsan. Nam bibendum leo nisi, lacinia molestie arcu consequat quis. Morbi at suscipit risus. Sed consequat eleifend metus, vitae malesuada eros elementum sed. Fusce risus felis, viverra et dignissim at, lobortis non est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam sit amet consectetur lacus.', '/team/careers/sales-associate', '[[date_gmt]]', '[[date_gmt]]', NULL, 0),
(217, 'What are page versions? What are page versions? \n                                    Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. How do I add more people as editors in my website? How do I add more people as editors in my website? \n                                    Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna. Pellentesque ultricies ligula vel neque dictum, eu mollis tortor adipiscing. Etiam congue, est vel tincidunt vestibulum, nunc nunc porta nulla, at adipiscing neque tellus quis urna.  ', 'Frequently Asked Questions', '', '/team/faq', '[[date_gmt]]', '[[date_gmt]]', NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `PageTemplates`
--

CREATE TABLE `PageTemplates` (
  `pTemplateID` int(11) NOT NULL AUTO_INCREMENT,
  `pTemplateHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `pTemplateIcon` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `pTemplateName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `pTemplateIsInternal` tinyint(1) NOT NULL,
  `pkgID` int(11) NOT NULL,
  PRIMARY KEY (`pTemplateID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `PageTemplates`
--

INSERT INTO `PageTemplates` VALUES
(1, 'core_stack', '', 'Stack', 1, 0),
(2, 'desktop', '', 'Desktop', 1, 0),
(3, 'dashboard_full', '', 'Dashboard Full', 1, 0),
(4, 'blank', 'blank.png', 'Blank', 0, 0),
(5, 'full', 'full.png', 'Full', 0, 0),
(6, 'left_sidebar', 'left_sidebar.png', 'Left Sidebar', 0, 0),
(7, 'right_sidebar', 'right_sidebar.png', 'Right Sidebar', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `PageThemeCustomStyles`
--

CREATE TABLE `PageThemeCustomStyles` (
  `pThemeID` int(10) unsigned NOT NULL DEFAULT '0',
  `scvlID` int(10) unsigned DEFAULT '0',
  `preset` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sccRecordID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`pThemeID`),
  KEY `scvlID` (`scvlID`),
  KEY `sccRecordID` (`sccRecordID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `PageThemes`
--

CREATE TABLE `PageThemes` (
  `pThemeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pThemeHandle` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `pThemeName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pThemeDescription` text COLLATE utf8_unicode_ci,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  `pThemeHasCustomClass` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pThemeID`),
  UNIQUE KEY `ptHandle` (`pThemeHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `PageThemes`
--

INSERT INTO `PageThemes` VALUES
(1, 'elemental', 'Elemental', 'Elegant, spacious theme with support for blogs, portfolios, layouts and more.', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `PageTypeComposerControlTypes`
--

CREATE TABLE `PageTypeComposerControlTypes` (
  `ptComposerControlTypeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ptComposerControlTypeHandle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ptComposerControlTypeName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ptComposerControlTypeID`),
  UNIQUE KEY `ptComposerControlTypeHandle` (`ptComposerControlTypeHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `PageTypeComposerControlTypes`
--

INSERT INTO `PageTypeComposerControlTypes` VALUES
(1, 'core_page_property', 'Built-In Property', 0),
(2, 'collection_attribute', 'Custom Attribute', 0),
(3, 'block', 'Block', 0);

-- --------------------------------------------------------

--
-- Table structure for table `PageTypeComposerFormLayoutSetControls`
--

CREATE TABLE `PageTypeComposerFormLayoutSetControls` (
  `ptComposerFormLayoutSetControlID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ptComposerFormLayoutSetID` int(10) unsigned DEFAULT '0',
  `ptComposerControlTypeID` int(10) unsigned DEFAULT '0',
  `ptComposerControlObject` longtext COLLATE utf8_unicode_ci,
  `ptComposerFormLayoutSetControlDisplayOrder` int(10) unsigned DEFAULT '0',
  `ptComposerFormLayoutSetControlCustomLabel` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ptComposerFormLayoutSetControlCustomTemplate` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ptComposerFormLayoutSetControlDescription` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ptComposerFormLayoutSetControlRequired` int(11) DEFAULT '0',
  PRIMARY KEY (`ptComposerFormLayoutSetControlID`),
  KEY `ptComposerControlTypeID` (`ptComposerControlTypeID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=34 ;

--
-- Dumping data for table `PageTypeComposerFormLayoutSetControls`
--

INSERT INTO `PageTypeComposerFormLayoutSetControls` VALUES
(1, 1, 1, 'O:78:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\NameCorePageProperty":12:{s:37:"\0*\0ptComposerControlRequiredByDefault";b:1;s:17:"\0*\0propertyHandle";s:4:"name";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:30:"\0*\0ptComposerControlIdentifier";s:4:"name";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:9:"file-text";}s:20:"\0*\0ptComposerControl";N;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 0, 'Page Name', NULL, NULL, 1),
(2, 1, 1, 'O:85:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\DescriptionCorePageProperty":12:{s:17:"\0*\0propertyHandle";s:11:"description";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:30:"\0*\0ptComposerControlIdentifier";s:11:"description";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:4:"font";}s:20:"\0*\0ptComposerControl";N;s:37:"\0*\0ptComposerControlRequiredByDefault";b:0;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 1, NULL, NULL, NULL, 0),
(3, 1, 1, 'O:81:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\UrlSlugCorePageProperty":12:{s:17:"\0*\0propertyHandle";s:8:"url_slug";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:30:"\0*\0ptComposerControlIdentifier";s:8:"url_slug";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:9:"file-text";}s:20:"\0*\0ptComposerControl";N;s:37:"\0*\0ptComposerControlRequiredByDefault";b:0;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 2, NULL, NULL, NULL, 0),
(4, 1, 1, 'O:86:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\PageTemplateCorePageProperty":12:{s:17:"\0*\0propertyHandle";s:13:"page_template";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:30:"\0*\0ptComposerControlIdentifier";s:13:"page_template";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:8:"list-alt";}s:20:"\0*\0ptComposerControl";N;s:37:"\0*\0ptComposerControlRequiredByDefault";b:0;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 3, NULL, NULL, NULL, 0),
(5, 1, 1, 'O:87:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\PublishTargetCorePageProperty":12:{s:17:"\0*\0propertyHandle";s:14:"publish_target";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:30:"\0*\0ptComposerControlIdentifier";s:14:"publish_target";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:8:"download";}s:20:"\0*\0ptComposerControl";N;s:37:"\0*\0ptComposerControlRequiredByDefault";b:0;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 4, NULL, NULL, NULL, 0),
(6, 2, 1, 'O:78:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\NameCorePageProperty":12:{s:37:"\0*\0ptComposerControlRequiredByDefault";b:1;s:17:"\0*\0propertyHandle";s:4:"name";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:30:"\0*\0ptComposerControlIdentifier";s:4:"name";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:9:"file-text";}s:20:"\0*\0ptComposerControl";N;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 0, 'Entry Name', NULL, NULL, 0),
(7, 2, 1, 'O:81:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\UrlSlugCorePageProperty":12:{s:17:"\0*\0propertyHandle";s:8:"url_slug";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:30:"\0*\0ptComposerControlIdentifier";s:8:"url_slug";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:9:"file-text";}s:20:"\0*\0ptComposerControl";N;s:37:"\0*\0ptComposerControlRequiredByDefault";b:0;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 1, NULL, NULL, NULL, 0),
(8, 2, 1, 'O:85:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\DescriptionCorePageProperty":12:{s:17:"\0*\0propertyHandle";s:11:"description";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:30:"\0*\0ptComposerControlIdentifier";s:11:"description";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:4:"font";}s:20:"\0*\0ptComposerControl";N;s:37:"\0*\0ptComposerControlRequiredByDefault";b:0;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 2, 'Short Description', NULL, NULL, 0),
(9, 2, 1, 'O:87:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\PublishTargetCorePageProperty":12:{s:17:"\0*\0propertyHandle";s:14:"publish_target";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:30:"\0*\0ptComposerControlIdentifier";s:14:"publish_target";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:8:"download";}s:20:"\0*\0ptComposerControl";N;s:37:"\0*\0ptComposerControlRequiredByDefault";b:0;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 3, NULL, NULL, NULL, 0),
(10, 2, 2, 'O:67:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CollectionAttributeControl":1:{s:7:"\0*\0akID";i:24;}', 4, 'Topics', NULL, NULL, 0),
(11, 3, 2, 'O:67:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CollectionAttributeControl":1:{s:7:"\0*\0akID";i:23;}', 0, NULL, NULL, NULL, 0),
(12, 3, 3, 'O:53:"Concrete\\Core\\Page\\Type\\Composer\\Control\\BlockControl":15:{s:7:"\0*\0btID";i:1;s:30:"\0*\0ptComposerControlTypeHandle";s:5:"block";s:5:"\0*\0bt";b:0;s:4:"\0*\0b";b:0;s:13:"\0*\0controller";N;s:30:"\0*\0ptComposerControlIdentifier";i:1;s:24:"\0*\0ptComposerControlName";s:7:"Content";s:27:"\0*\0ptComposerControlIconSRC";[[content_icon]]s:33:"\0*\0ptComposerControlIconFormatter";N;s:20:"\0*\0ptComposerControl";N;s:37:"\0*\0ptComposerControlRequiredByDefault";b:0;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 1, NULL, NULL, NULL, 0),
(13, 4, 1, 'O:78:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\NameCorePageProperty":12:{s:37:"\0*\0ptComposerControlRequiredByDefault";b:1;s:17:"\0*\0propertyHandle";s:4:"name";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:30:"\0*\0ptComposerControlIdentifier";s:4:"name";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:9:"file-text";}s:20:"\0*\0ptComposerControl";N;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 0, 'Job Name', NULL, NULL, 1),
(14, 4, 1, 'O:82:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\DateTimeCorePageProperty":12:{s:17:"\0*\0propertyHandle";s:9:"date_time";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:30:"\0*\0ptComposerControlIdentifier";s:9:"date_time";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:8:"calendar";}s:20:"\0*\0ptComposerControl";N;s:37:"\0*\0ptComposerControlRequiredByDefault";b:0;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 1, 'Posting Date', NULL, NULL, 0),
(15, 5, 2, 'O:67:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CollectionAttributeControl":1:{s:7:"\0*\0akID";i:21;}', 0, NULL, NULL, NULL, 0),
(16, 5, 2, 'O:67:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CollectionAttributeControl":1:{s:7:"\0*\0akID";i:20;}', 1, NULL, NULL, NULL, 0),
(17, 5, 1, 'O:85:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\DescriptionCorePageProperty":12:{s:17:"\0*\0propertyHandle";s:11:"description";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:30:"\0*\0ptComposerControlIdentifier";s:11:"description";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:4:"font";}s:20:"\0*\0ptComposerControl";N;s:37:"\0*\0ptComposerControlRequiredByDefault";b:0;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 2, 'Brief Description', NULL, NULL, 0),
(18, 5, 3, 'O:53:"Concrete\\Core\\Page\\Type\\Composer\\Control\\BlockControl":15:{s:7:"\0*\0btID";i:1;s:30:"\0*\0ptComposerControlTypeHandle";s:5:"block";s:5:"\0*\0bt";b:0;s:4:"\0*\0b";b:0;s:13:"\0*\0controller";N;s:30:"\0*\0ptComposerControlIdentifier";i:1;s:24:"\0*\0ptComposerControlName";s:7:"Content";s:27:"\0*\0ptComposerControlIconSRC";[[content_icon]]s:33:"\0*\0ptComposerControlIconFormatter";N;s:20:"\0*\0ptComposerControl";N;s:37:"\0*\0ptComposerControlRequiredByDefault";b:0;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 3, 'Job Details', NULL, NULL, 0),
(19, 6, 1, 'O:78:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\NameCorePageProperty":12:{s:37:"\0*\0ptComposerControlRequiredByDefault";b:1;s:17:"\0*\0propertyHandle";s:4:"name";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:30:"\0*\0ptComposerControlIdentifier";s:4:"name";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:9:"file-text";}s:20:"\0*\0ptComposerControl";N;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 0, NULL, NULL, 'Give your portfolio project a name.', 0),
(20, 6, 1, 'O:81:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\UrlSlugCorePageProperty":12:{s:17:"\0*\0propertyHandle";s:8:"url_slug";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:30:"\0*\0ptComposerControlIdentifier";s:8:"url_slug";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:9:"file-text";}s:20:"\0*\0ptComposerControl";N;s:37:"\0*\0ptComposerControlRequiredByDefault";b:0;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 1, NULL, NULL, NULL, 0),
(21, 6, 1, 'O:87:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\PublishTargetCorePageProperty":12:{s:17:"\0*\0propertyHandle";s:14:"publish_target";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:30:"\0*\0ptComposerControlIdentifier";s:14:"publish_target";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:8:"download";}s:20:"\0*\0ptComposerControl";N;s:37:"\0*\0ptComposerControlRequiredByDefault";b:0;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 2, NULL, NULL, NULL, 0),
(22, 7, 2, 'O:67:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CollectionAttributeControl":1:{s:7:"\0*\0akID";i:25;}', 0, NULL, NULL, NULL, 0),
(23, 7, 1, 'O:82:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\DateTimeCorePageProperty":12:{s:17:"\0*\0propertyHandle";s:9:"date_time";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:30:"\0*\0ptComposerControlIdentifier";s:9:"date_time";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:8:"calendar";}s:20:"\0*\0ptComposerControl";N;s:37:"\0*\0ptComposerControlRequiredByDefault";b:0;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 1, 'Date Completed', NULL, NULL, 0),
(24, 7, 2, 'O:67:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CollectionAttributeControl":1:{s:7:"\0*\0akID";i:27;}', 2, NULL, NULL, NULL, 0),
(25, 7, 2, 'O:67:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CollectionAttributeControl":1:{s:7:"\0*\0akID";i:28;}', 3, NULL, NULL, NULL, 0),
(26, 7, 2, 'O:67:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CollectionAttributeControl":1:{s:7:"\0*\0akID";i:29;}', 4, NULL, NULL, NULL, 0),
(27, 7, 2, 'O:67:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CollectionAttributeControl":1:{s:7:"\0*\0akID";i:23;}', 5, NULL, NULL, NULL, 0),
(28, 8, 3, 'O:53:"Concrete\\Core\\Page\\Type\\Composer\\Control\\BlockControl":15:{s:7:"\0*\0btID";i:31;s:30:"\0*\0ptComposerControlTypeHandle";s:5:"block";s:5:"\0*\0bt";b:0;s:4:"\0*\0b";b:0;s:13:"\0*\0controller";N;s:30:"\0*\0ptComposerControlIdentifier";i:31;s:24:"\0*\0ptComposerControlName";s:12:"Image Slider";s:27:"\0*\0ptComposerControlIconSRC";[[image_slider_icon]]s:33:"\0*\0ptComposerControlIconFormatter";N;s:20:"\0*\0ptComposerControl";N;s:37:"\0*\0ptComposerControlRequiredByDefault";b:0;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 0, NULL, NULL, NULL, 0),
(29, 9, 3, 'O:53:"Concrete\\Core\\Page\\Type\\Composer\\Control\\BlockControl":15:{s:7:"\0*\0btID";i:1;s:30:"\0*\0ptComposerControlTypeHandle";s:5:"block";s:5:"\0*\0bt";b:0;s:4:"\0*\0b";b:0;s:13:"\0*\0controller";N;s:30:"\0*\0ptComposerControlIdentifier";i:1;s:24:"\0*\0ptComposerControlName";s:7:"Content";s:27:"\0*\0ptComposerControlIconSRC";[[content_icon]]s:33:"\0*\0ptComposerControlIconFormatter";N;s:20:"\0*\0ptComposerControl";N;s:37:"\0*\0ptComposerControlRequiredByDefault";b:0;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 0, NULL, NULL, NULL, 0),
(30, 10, 1, 'O:78:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\NameCorePageProperty":12:{s:37:"\0*\0ptComposerControlRequiredByDefault";b:1;s:17:"\0*\0propertyHandle";s:4:"name";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:30:"\0*\0ptComposerControlIdentifier";s:4:"name";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:9:"file-text";}s:20:"\0*\0ptComposerControl";N;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 0, NULL, NULL, NULL, 0),
(31, 10, 1, 'O:87:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\PublishTargetCorePageProperty":12:{s:17:"\0*\0propertyHandle";s:14:"publish_target";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:30:"\0*\0ptComposerControlIdentifier";s:14:"publish_target";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:8:"download";}s:20:"\0*\0ptComposerControl";N;s:37:"\0*\0ptComposerControlRequiredByDefault";b:0;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 1, NULL, NULL, NULL, 0),
(32, 11, 1, 'O:78:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\NameCorePageProperty":12:{s:37:"\0*\0ptComposerControlRequiredByDefault";b:1;s:17:"\0*\0propertyHandle";s:4:"name";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:30:"\0*\0ptComposerControlIdentifier";s:4:"name";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:9:"file-text";}s:20:"\0*\0ptComposerControl";N;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 0, 'Name', NULL, NULL, 0),
(33, 11, 1, 'O:87:"Concrete\\Core\\Page\\Type\\Composer\\Control\\CorePageProperty\\PublishTargetCorePageProperty":12:{s:17:"\0*\0propertyHandle";s:14:"publish_target";s:30:"\0*\0ptComposerControlTypeHandle";s:18:"core_page_property";s:30:"\0*\0ptComposerControlIdentifier";s:14:"publish_target";s:24:"\0*\0ptComposerControlName";N;s:27:"\0*\0ptComposerControlIconSRC";N;s:33:"\0*\0ptComposerControlIconFormatter";O:48:"Concrete\\Core\\Attribute\\FontAwesomeIconFormatter":1:{s:7:"\0*\0icon";s:8:"download";}s:20:"\0*\0ptComposerControl";N;s:37:"\0*\0ptComposerControlRequiredByDefault";b:0;s:41:"\0*\0ptComposerControlRequiredOnThisRequest";b:0;s:31:"\0*\0ptComposerControlCustomLabel";N;s:31:"\0*\0ptComposerControlDescription";N;s:5:"error";s:0:"";}', 1, NULL, NULL, NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `PageTypeComposerFormLayoutSets`
--

CREATE TABLE `PageTypeComposerFormLayoutSets` (
  `ptComposerFormLayoutSetID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ptID` int(10) unsigned DEFAULT '0',
  `ptComposerFormLayoutSetName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ptComposerFormLayoutSetDescription` text COLLATE utf8_unicode_ci,
  `ptComposerFormLayoutSetDisplayOrder` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`ptComposerFormLayoutSetID`),
  KEY `ptID` (`ptID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=12 ;

--
-- Dumping data for table `PageTypeComposerFormLayoutSets`
--

INSERT INTO `PageTypeComposerFormLayoutSets` VALUES
(1, 5, 'Basics', '', 0),
(2, 6, 'Post Details', '', 0),
(3, 6, 'Content', '', 1),
(4, 7, 'Basics', '', 0),
(5, 7, 'About This Job', '', 1),
(6, 8, 'Page', '', 0),
(7, 8, 'Project Data', '', 1),
(8, 8, 'Image Slider', '', 2),
(9, 8, 'Body', '', 3),
(10, 9, 'Details', '', 0),
(11, 10, '', '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `PageTypeComposerOutputBlocks`
--

CREATE TABLE `PageTypeComposerOutputBlocks` (
  `ptComposerOutputBlockID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `cvID` int(10) unsigned NOT NULL DEFAULT '0',
  `arHandle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cbDisplayOrder` int(10) unsigned DEFAULT '0',
  `ptComposerFormLayoutSetControlID` int(10) unsigned NOT NULL DEFAULT '0',
  `bID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`ptComposerOutputBlockID`),
  KEY `cID` (`cID`),
  KEY `bID` (`bID`,`cID`),
  KEY `ptComposerFormLayoutSetControlID` (`ptComposerFormLayoutSetControlID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `PageTypeComposerOutputControls`
--

CREATE TABLE `PageTypeComposerOutputControls` (
  `ptComposerOutputControlID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pTemplateID` int(10) unsigned DEFAULT '0',
  `ptID` int(10) unsigned DEFAULT '0',
  `ptComposerFormLayoutSetControlID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`ptComposerOutputControlID`),
  KEY `pTemplateID` (`pTemplateID`,`ptComposerFormLayoutSetControlID`),
  KEY `ptID` (`ptID`),
  KEY `ptComposerFormLayoutSetControlID` (`ptComposerFormLayoutSetControlID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `PageTypeComposerOutputControls`
--

INSERT INTO `PageTypeComposerOutputControls` VALUES
(1, 7, 6, 12),
(2, 6, 7, 18),
(3, 6, 8, 28),
(4, 6, 8, 29);

-- --------------------------------------------------------

--
-- Table structure for table `PageTypePageTemplateDefaultPages`
--

CREATE TABLE `PageTypePageTemplateDefaultPages` (
  `pTemplateID` int(10) unsigned NOT NULL DEFAULT '0',
  `ptID` int(10) unsigned NOT NULL DEFAULT '0',
  `cID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`pTemplateID`,`ptID`),
  KEY `ptID` (`ptID`),
  KEY `cID` (`cID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `PageTypePageTemplateDefaultPages`
--

INSERT INTO `PageTypePageTemplateDefaultPages` VALUES
(5, 5, 193),
(5, 10, 195),
(5, 9, 198),
(4, 5, 202),
(6, 8, 204),
(7, 6, 211),
(6, 7, 218),
(6, 5, 221),
(7, 5, 222);

-- --------------------------------------------------------

--
-- Table structure for table `PageTypePageTemplates`
--

CREATE TABLE `PageTypePageTemplates` (
  `ptID` int(10) unsigned NOT NULL DEFAULT '0',
  `pTemplateID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ptID`,`pTemplateID`),
  KEY `pTemplateID` (`pTemplateID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `PageTypePageTemplates`
--

INSERT INTO `PageTypePageTemplates` VALUES
(9, 5),
(10, 5),
(7, 6),
(8, 6),
(6, 7);

-- --------------------------------------------------------

--
-- Table structure for table `PageTypePermissionAssignments`
--

CREATE TABLE `PageTypePermissionAssignments` (
  `ptID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ptID`,`pkID`,`paID`),
  KEY `pkID` (`pkID`),
  KEY `ptID` (`ptID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `PageTypePermissionAssignments`
--

INSERT INTO `PageTypePermissionAssignments` VALUES
(1, 60, 17),
(2, 60, 17),
(3, 60, 17),
(4, 60, 17),
(5, 60, 17),
(6, 60, 17),
(7, 60, 17),
(8, 60, 17),
(9, 60, 17),
(10, 60, 17),
(1, 61, 17),
(2, 61, 17),
(3, 61, 17),
(4, 61, 17),
(5, 61, 17),
(6, 61, 17),
(7, 61, 17),
(8, 61, 17),
(9, 61, 17),
(10, 61, 17),
(1, 62, 17),
(2, 62, 17),
(3, 62, 17),
(4, 62, 17),
(5, 62, 17),
(6, 62, 17),
(7, 62, 17),
(8, 62, 17),
(9, 62, 17),
(10, 62, 17),
(1, 63, 17),
(2, 63, 17),
(3, 63, 17),
(4, 63, 17),
(5, 63, 17),
(6, 63, 17),
(7, 63, 17),
(8, 63, 17),
(9, 63, 17),
(10, 63, 17),
(1, 64, 40),
(2, 64, 41),
(3, 64, 42),
(4, 64, 43),
(5, 64, 48),
(6, 64, 49),
(7, 64, 50),
(8, 64, 51),
(9, 64, 52),
(10, 64, 53);

-- --------------------------------------------------------

--
-- Table structure for table `PageTypePublishTargetTypes`
--

CREATE TABLE `PageTypePublishTargetTypes` (
  `ptPublishTargetTypeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ptPublishTargetTypeHandle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ptPublishTargetTypeName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ptPublishTargetTypeID`),
  KEY `ptPublishTargetTypeHandle` (`ptPublishTargetTypeHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `PageTypePublishTargetTypes`
--

INSERT INTO `PageTypePublishTargetTypes` VALUES
(1, 'parent_page', 'Always publish below a certain page', 0),
(2, 'page_type', 'Choose from pages of a certain type', 0),
(3, 'all', 'Choose from all pages when publishing', 0);

-- --------------------------------------------------------

--
-- Table structure for table `PageTypes`
--

CREATE TABLE `PageTypes` (
  `ptID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ptName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ptHandle` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `ptPublishTargetTypeID` int(10) unsigned DEFAULT NULL,
  `ptDefaultPageTemplateID` int(10) unsigned DEFAULT NULL,
  `ptAllowedPageTemplates` varchar(1) COLLATE utf8_unicode_ci DEFAULT 'A',
  `ptIsInternal` tinyint(1) NOT NULL DEFAULT '0',
  `ptIsFrequentlyAdded` tinyint(1) NOT NULL DEFAULT '1',
  `ptDisplayOrder` int(10) unsigned DEFAULT NULL,
  `ptLaunchInComposer` tinyint(1) NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  `ptPublishTargetObject` longtext COLLATE utf8_unicode_ci,
  `siteTypeID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`ptID`),
  UNIQUE KEY `ptHandle` (`ptHandle`),
  KEY `siteTypeID` (`siteTypeID`),
  KEY `pkgID` (`pkgID`,`ptID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=11 ;

--
-- Dumping data for table `PageTypes`
--

INSERT INTO `PageTypes` VALUES
(1, 'Stack', 'core_stack', 3, 0, 'A', 1, 0, 0, 0, 0, 'O:68:"Concrete\\Core\\Page\\Type\\PublishTarget\\Configuration\\AllConfiguration":7:{s:21:"\0*\0selectorFormFactor";N;s:22:"\0*\0startingPointPageID";N;s:5:"error";s:0:"";s:21:"ptPublishTargetTypeID";s:1:"3";s:25:"ptPublishTargetTypeHandle";s:3:"all";s:9:"pkgHandle";b:0;s:17:"startingPointPage";N;}', 1),
(2, 'Stack Category', 'core_stack_category', 3, 0, 'A', 1, 0, 1, 0, 0, 'O:68:"Concrete\\Core\\Page\\Type\\PublishTarget\\Configuration\\AllConfiguration":7:{s:21:"\0*\0selectorFormFactor";N;s:22:"\0*\0startingPointPageID";N;s:5:"error";s:0:"";s:21:"ptPublishTargetTypeID";s:1:"3";s:25:"ptPublishTargetTypeHandle";s:3:"all";s:9:"pkgHandle";b:0;s:17:"startingPointPage";N;}', 1),
(3, 'Desktop', 'core_desktop', 3, 0, 'A', 1, 0, 2, 0, 0, 'O:68:"Concrete\\Core\\Page\\Type\\PublishTarget\\Configuration\\AllConfiguration":7:{s:21:"\0*\0selectorFormFactor";N;s:22:"\0*\0startingPointPageID";N;s:5:"error";s:0:"";s:21:"ptPublishTargetTypeID";s:1:"3";s:25:"ptPublishTargetTypeHandle";s:3:"all";s:9:"pkgHandle";b:0;s:17:"startingPointPage";N;}', 1),
(4, 'Dashboard Full', 'dashboard_full', 3, 0, 'A', 1, 0, 3, 0, 0, 'O:68:"Concrete\\Core\\Page\\Type\\PublishTarget\\Configuration\\AllConfiguration":7:{s:21:"\0*\0selectorFormFactor";N;s:22:"\0*\0startingPointPageID";N;s:5:"error";s:0:"";s:21:"ptPublishTargetTypeID";s:1:"3";s:25:"ptPublishTargetTypeHandle";s:3:"all";s:9:"pkgHandle";b:0;s:17:"startingPointPage";N;}', 1),
(5, 'Empty Page', 'page', 3, 5, 'A', 0, 1, 0, 0, 0, 'O:68:"Concrete\\Core\\Page\\Type\\PublishTarget\\Configuration\\AllConfiguration":6:{s:21:"\0*\0selectorFormFactor";N;s:22:"\0*\0startingPointPageID";N;s:5:"error";s:0:"";s:21:"ptPublishTargetTypeID";s:1:"3";s:25:"ptPublishTargetTypeHandle";s:3:"all";s:9:"pkgHandle";b:0;}', 1),
(6, 'Blog Entry', 'blog_entry', 2, 7, 'C', 0, 1, 1, 1, 0, 'O:73:"Concrete\\Core\\Page\\Type\\PublishTarget\\Configuration\\PageTypeConfiguration":7:{s:7:"\0*\0ptID";s:1:"9";s:21:"\0*\0selectorFormFactor";N;s:20:"\0*\0startingPointPage";N;s:5:"error";s:0:"";s:21:"ptPublishTargetTypeID";s:1:"2";s:25:"ptPublishTargetTypeHandle";s:9:"page_type";s:9:"pkgHandle";b:0;}', 1),
(7, 'Job Posting', 'job_posting', 1, 6, 'C', 0, 1, 2, 1, 0, 'O:75:"Concrete\\Core\\Page\\Type\\PublishTarget\\Configuration\\ParentPageConfiguration":5:{s:12:"\0*\0cParentID";i:216;s:5:"error";s:0:"";s:21:"ptPublishTargetTypeID";s:1:"1";s:25:"ptPublishTargetTypeHandle";s:11:"parent_page";s:9:"pkgHandle";b:0;}', 1),
(8, 'Portfolio Project', 'portfolio_project', 2, 6, 'C', 0, 1, 3, 1, 0, 'O:73:"Concrete\\Core\\Page\\Type\\PublishTarget\\Configuration\\PageTypeConfiguration":7:{s:7:"\0*\0ptID";s:2:"10";s:21:"\0*\0selectorFormFactor";N;s:20:"\0*\0startingPointPage";N;s:5:"error";s:0:"";s:21:"ptPublishTargetTypeID";s:1:"2";s:25:"ptPublishTargetTypeHandle";s:9:"page_type";s:9:"pkgHandle";b:0;}', 1),
(9, 'Blog', 'blog', 3, 5, 'C', 0, 0, 4, 1, 0, 'O:68:"Concrete\\Core\\Page\\Type\\PublishTarget\\Configuration\\AllConfiguration":6:{s:21:"\0*\0selectorFormFactor";N;s:22:"\0*\0startingPointPageID";N;s:5:"error";s:0:"";s:21:"ptPublishTargetTypeID";s:1:"3";s:25:"ptPublishTargetTypeHandle";s:3:"all";s:9:"pkgHandle";b:0;}', 1),
(10, 'Portfolio', 'portfolio', 3, 5, 'C', 0, 0, 5, 1, 0, 'O:68:"Concrete\\Core\\Page\\Type\\PublishTarget\\Configuration\\AllConfiguration":6:{s:21:"\0*\0selectorFormFactor";N;s:22:"\0*\0startingPointPageID";N;s:5:"error";s:0:"";s:21:"ptPublishTargetTypeID";s:1:"3";s:25:"ptPublishTargetTypeHandle";s:3:"all";s:9:"pkgHandle";b:0;}', 1);

-- --------------------------------------------------------

--
-- Table structure for table `PageWorkflowProgress`
--

CREATE TABLE `PageWorkflowProgress` (
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `wpID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`wpID`),
  KEY `wpID` (`wpID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `PermissionAccess`
--

CREATE TABLE `PermissionAccess` (
  `paID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `paIsInUse` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=120 ;

--
-- Dumping data for table `PermissionAccess`
--

INSERT INTO `PermissionAccess` VALUES
(1, 1),
(2, 1),
(3, 1),
(4, 1),
(5, 1),
(6, 1),
(7, 1),
(8, 1),
(9, 1),
(10, 1),
(11, 1),
(12, 1),
(13, 1),
(14, 1),
(15, 1),
(16, 1),
(17, 1),
(18, 1),
(19, 1),
(20, 1),
(21, 1),
(22, 1),
(23, 1),
(24, 1),
(25, 1),
(26, 1),
(27, 1),
(28, 1),
(29, 1),
(30, 1),
(31, 1),
(32, 1),
(33, 1),
(34, 1),
(35, 1),
(36, 1),
(37, 1),
(38, 1),
(39, 1),
(40, 1),
(41, 1),
(42, 1),
(43, 1),
(44, 1),
(45, 1),
(46, 1),
(47, 1),
(48, 1),
(49, 1),
(50, 1),
(51, 1),
(52, 1),
(53, 1),
(54, 1),
(55, 1),
(56, 1),
(57, 1),
(58, 1),
(59, 1),
(60, 1),
(61, 1),
(62, 1),
(63, 1),
(64, 1),
(65, 1),
(66, 1),
(67, 1),
(68, 1),
(69, 1),
(70, 1),
(71, 1),
(72, 1),
(73, 1),
(74, 1),
(75, 1),
(76, 1),
(77, 1),
(78, 1),
(79, 1),
(80, 1),
(81, 1),
(82, 1),
(83, 1),
(84, 1),
(85, 1),
(86, 1),
(87, 1),
(88, 1),
(89, 1),
(90, 1),
(91, 1),
(92, 1),
(93, 1),
(94, 1),
(95, 1),
(96, 1),
(97, 1),
(98, 1),
(99, 1),
(100, 1),
(101, 1),
(102, 1),
(103, 1),
(104, 1),
(105, 1),
(106, 1),
(107, 1),
(108, 1),
(109, 1),
(110, 1),
(111, 1),
(112, 1),
(113, 1),
(114, 1),
(115, 1),
(116, 1),
(117, 1),
(118, 1),
(119, 1);

-- --------------------------------------------------------

--
-- Table structure for table `PermissionAccessEntities`
--

CREATE TABLE `PermissionAccessEntities` (
  `peID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `petID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`peID`),
  KEY `petID` (`petID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `PermissionAccessEntities`
--

INSERT INTO `PermissionAccessEntities` VALUES
(1, 1),
(2, 1),
(6, 1),
(7, 2),
(3, 5),
(4, 6),
(5, 7);

-- --------------------------------------------------------

--
-- Table structure for table `PermissionAccessEntityGroups`
--

CREATE TABLE `PermissionAccessEntityGroups` (
  `pegID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `gID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`pegID`),
  KEY `peID` (`peID`),
  KEY `gID` (`gID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `PermissionAccessEntityGroups`
--

INSERT INTO `PermissionAccessEntityGroups` VALUES
(1, 1, 3),
(2, 2, 1),
(3, 6, 2);

-- --------------------------------------------------------

--
-- Table structure for table `PermissionAccessEntityGroupSets`
--

CREATE TABLE `PermissionAccessEntityGroupSets` (
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `gsID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`peID`,`gsID`),
  KEY `gsID` (`gsID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `PermissionAccessEntitySiteGroups`
--

CREATE TABLE `PermissionAccessEntitySiteGroups` (
  `pegID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `peID` int(10) unsigned NOT NULL,
  `siteGID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`pegID`),
  KEY `peID` (`peID`),
  KEY `siteGID` (`siteGID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `PermissionAccessEntityTypeCategories`
--

CREATE TABLE `PermissionAccessEntityTypeCategories` (
  `petID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkCategoryID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`petID`,`pkCategoryID`),
  KEY `pkCategoryID` (`pkCategoryID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `PermissionAccessEntityTypeCategories`
--

INSERT INTO `PermissionAccessEntityTypeCategories` VALUES
(1, 1),
(2, 1),
(3, 1),
(4, 1),
(5, 1),
(8, 1),
(1, 4),
(2, 4),
(3, 4),
(4, 4),
(1, 5),
(2, 5),
(3, 5),
(4, 5),
(6, 5),
(1, 6),
(2, 6),
(3, 6),
(4, 6),
(6, 6),
(1, 7),
(2, 7),
(3, 7),
(4, 7),
(1, 8),
(2, 8),
(3, 8),
(4, 8),
(1, 9),
(2, 9),
(3, 9),
(4, 9),
(1, 10),
(2, 10),
(3, 10),
(4, 10),
(1, 11),
(2, 11),
(3, 11),
(4, 11),
(1, 12),
(2, 12),
(3, 12),
(4, 12),
(1, 13),
(2, 13),
(3, 13),
(4, 13),
(1, 14),
(2, 14),
(3, 14),
(4, 14),
(8, 14),
(1, 15),
(2, 15),
(3, 15),
(4, 15),
(5, 15),
(8, 15),
(1, 16),
(2, 16),
(3, 16),
(4, 16),
(1, 17),
(2, 17),
(3, 17),
(4, 17),
(1, 18),
(2, 18),
(3, 18),
(4, 18),
(1, 19),
(2, 19),
(3, 19),
(4, 19),
(1, 20),
(2, 20),
(3, 20),
(4, 20),
(1, 21),
(2, 21),
(3, 21),
(4, 21),
(7, 21),
(1, 22),
(2, 22),
(3, 22),
(4, 22),
(7, 22),
(1, 23),
(2, 23),
(4, 23),
(1, 24),
(2, 24),
(3, 24),
(4, 24),
(1, 25),
(2, 25),
(3, 25),
(4, 25),
(1, 26),
(2, 26),
(3, 26),
(4, 26);

-- --------------------------------------------------------

--
-- Table structure for table `PermissionAccessEntityTypes`
--

CREATE TABLE `PermissionAccessEntityTypes` (
  `petID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `petHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `petName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`petID`),
  UNIQUE KEY `petHandle` (`petHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=9 ;

--
-- Dumping data for table `PermissionAccessEntityTypes`
--

INSERT INTO `PermissionAccessEntityTypes` VALUES
(1, 'group', 'Group', 0),
(2, 'user', 'User', 0),
(3, 'group_set', 'Group Set', 0),
(4, 'group_combination', 'Group Combination', 0),
(5, 'page_owner', 'Page Owner', 0),
(6, 'file_uploader', 'File Uploader', 0),
(7, 'conversation_message_author', 'Message Author', 0),
(8, 'site_group', 'Site Group', 0);

-- --------------------------------------------------------

--
-- Table structure for table `PermissionAccessEntityUsers`
--

CREATE TABLE `PermissionAccessEntityUsers` (
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`peID`,`uID`),
  KEY `uID` (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `PermissionAccessEntityUsers`
--

INSERT INTO `PermissionAccessEntityUsers` VALUES
(7, 1);

-- --------------------------------------------------------

--
-- Table structure for table `PermissionAccessList`
--

CREATE TABLE `PermissionAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `pdID` int(10) unsigned NOT NULL DEFAULT '0',
  `accessType` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`),
  KEY `accessType` (`accessType`),
  KEY `peID` (`peID`),
  KEY `peID_accessType` (`peID`,`accessType`),
  KEY `pdID` (`pdID`),
  KEY `permissionAccessDuration` (`paID`,`pdID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `PermissionAccessList`
--

INSERT INTO `PermissionAccessList` VALUES
(1, 1, 0, 10),
(2, 1, 0, 10),
(3, 1, 0, 10),
(4, 1, 0, 10),
(5, 1, 0, 10),
(6, 1, 0, 10),
(7, 1, 0, 10),
(8, 1, 0, 10),
(9, 1, 0, 10),
(10, 2, 0, 10),
(11, 1, 0, 10),
(12, 1, 0, 10),
(13, 1, 0, 10),
(14, 1, 0, 10),
(15, 1, 0, 10),
(16, 2, 0, 10),
(17, 1, 0, 10),
(18, 1, 0, 10),
(19, 1, 0, 10),
(20, 1, 0, 10),
(21, 1, 0, 10),
(22, 1, 0, 10),
(23, 1, 0, 10),
(24, 1, 0, 10),
(25, 1, 0, 10),
(26, 1, 0, 10),
(27, 1, 0, 10),
(28, 1, 0, 10),
(29, 1, 0, 10),
(30, 1, 0, 10),
(31, 1, 0, 10),
(32, 1, 0, 10),
(33, 1, 0, 10),
(34, 1, 0, 10),
(35, 1, 0, 10),
(36, 1, 0, 10),
(36, 2, 0, 10),
(37, 1, 0, 10),
(37, 2, 0, 10),
(38, 1, 0, 10),
(39, 1, 0, 10),
(40, 3, 0, 10),
(41, 3, 0, 10),
(42, 3, 0, 10),
(43, 3, 0, 10),
(44, 1, 0, 10),
(45, 2, 0, 10),
(46, 2, 0, 10),
(47, 2, 0, 10),
(48, 3, 0, 10),
(49, 3, 0, 10),
(50, 3, 0, 10),
(51, 3, 0, 10),
(52, 3, 0, 10),
(53, 3, 0, 10),
(54, 2, 0, 10),
(55, 1, 0, 10),
(55, 2, 0, 10),
(56, 1, 0, 10),
(57, 1, 0, 10),
(58, 1, 0, 10),
(59, 1, 0, 10),
(60, 1, 0, 10),
(61, 1, 0, 10),
(62, 1, 0, 10),
(63, 1, 0, 10),
(64, 1, 0, 10),
(65, 2, 0, 10),
(66, 2, 0, 10),
(67, 2, 0, 10),
(68, 2, 0, 10),
(69, 1, 0, 10),
(70, 1, 0, 10),
(71, 1, 0, 10),
(72, 1, 0, 10),
(73, 1, 0, 10),
(74, 1, 0, 10),
(75, 1, 0, 10),
(76, 1, 0, 10),
(77, 1, 0, 10),
(78, 1, 0, 10),
(79, 1, 0, 10),
(80, 1, 0, 10),
(81, 1, 0, 10),
(82, 1, 0, 10),
(83, 1, 0, 10),
(84, 1, 0, 10),
(85, 1, 0, 10),
(86, 1, 0, 10),
(87, 1, 0, 10),
(88, 2, 0, 10),
(89, 1, 0, 10),
(90, 1, 0, 10),
(91, 1, 0, 10),
(92, 1, 0, 10),
(93, 1, 0, 10),
(94, 1, 0, 10),
(95, 1, 0, 10),
(96, 1, 0, 10),
(97, 1, 0, 10),
(98, 1, 0, 10),
(99, 1, 0, 10),
(100, 1, 0, 10),
(101, 1, 0, 10),
(102, 1, 0, 10),
(103, 1, 0, 10),
(104, 1, 0, 10),
(105, 1, 0, 10),
(106, 1, 0, 10),
(107, 1, 0, 10),
(108, 1, 0, 10),
(109, 1, 0, 10),
(110, 1, 0, 10),
(111, 2, 0, 10),
(112, 2, 0, 10),
(113, 1, 0, 10),
(113, 5, 0, 10),
(114, 1, 0, 10),
(114, 5, 0, 10),
(115, 1, 0, 10),
(115, 6, 0, 10),
(116, 1, 0, 10),
(117, 1, 0, 10),
(118, 1, 0, 10),
(119, 1, 0, 10),
(119, 7, 0, 10);

-- --------------------------------------------------------

--
-- Table structure for table `PermissionAccessWorkflows`
--

CREATE TABLE `PermissionAccessWorkflows` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `wfID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`wfID`),
  KEY `wfID` (`wfID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `PermissionAssignments`
--

CREATE TABLE `PermissionAssignments` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`pkID`),
  KEY `pkID` (`pkID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `PermissionAssignments`
--

INSERT INTO `PermissionAssignments` VALUES
(1, 19),
(2, 20),
(3, 75),
(4, 76),
(5, 77),
(6, 79),
(7, 80),
(8, 81),
(119, 82),
(9, 83),
(10, 84),
(11, 85),
(12, 86),
(13, 87),
(14, 88),
(15, 89),
(16, 90),
(17, 113),
(18, 115),
(19, 116),
(20, 117),
(21, 118),
(22, 119),
(23, 120),
(24, 121),
(25, 122),
(26, 123),
(27, 124),
(28, 125),
(29, 126),
(30, 127),
(31, 128),
(38, 129),
(39, 130);

-- --------------------------------------------------------

--
-- Table structure for table `PermissionDurationObjects`
--

CREATE TABLE `PermissionDurationObjects` (
  `pdID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pdObject` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`pdID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `PermissionKeyCategories`
--

CREATE TABLE `PermissionKeyCategories` (
  `pkCategoryID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pkCategoryHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`pkCategoryID`),
  UNIQUE KEY `pkCategoryHandle` (`pkCategoryHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=27 ;

--
-- Dumping data for table `PermissionKeyCategories`
--

INSERT INTO `PermissionKeyCategories` VALUES
(1, 'page', NULL),
(2, 'single_page', NULL),
(3, 'stack', NULL),
(4, 'user', NULL),
(5, 'file_folder', NULL),
(6, 'file', NULL),
(7, 'area', NULL),
(8, 'block_type', NULL),
(9, 'block', NULL),
(10, 'admin', NULL),
(11, 'notification', NULL),
(12, 'sitemap', NULL),
(13, 'marketplace_newsflow', NULL),
(14, 'basic_workflow', NULL),
(15, 'page_type', NULL),
(16, 'gathering', NULL),
(17, 'group_tree_node', NULL),
(18, 'express_tree_node', NULL),
(19, 'category_tree_node', NULL),
(20, 'topic_tree_node', NULL),
(21, 'conversation', NULL),
(22, 'conversation_message', NULL),
(23, 'multilingual_section', NULL),
(24, 'calendar_admin', NULL),
(25, 'calendar', NULL),
(26, 'express_entry', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `PermissionKeys`
--

CREATE TABLE `PermissionKeys` (
  `pkID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pkHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `pkName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `pkCanTriggerWorkflow` tinyint(1) NOT NULL DEFAULT '0',
  `pkHasCustomClass` tinyint(1) NOT NULL DEFAULT '0',
  `pkDescription` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pkCategoryID` int(10) unsigned DEFAULT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`pkID`),
  UNIQUE KEY `akHandle` (`pkHandle`),
  KEY `pkCategoryID` (`pkCategoryID`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=131 ;

--
-- Dumping data for table `PermissionKeys`
--

INSERT INTO `PermissionKeys` VALUES
(1, 'view_page', 'View', 0, 0, 'Can see a page exists and read its content.', 1, 0),
(2, 'view_page_versions', 'View Versions', 0, 0, 'Can view the page versions dialog and read past versions of a page.', 1, 0),
(3, 'view_page_in_sitemap', 'View Page in Sitemap', 0, 0, 'Controls whether a user can see a page in the sitemap or intelligent search.', 1, 0),
(4, 'preview_page_as_user', 'Preview Page As User', 0, 0, 'Ability to see what this page will look like at a specific time in the future as a specific user.', 1, 0),
(5, 'edit_page_properties', 'Edit Properties', 0, 1, 'Ability to change anything in the Page Properties menu.', 1, 0),
(6, 'edit_page_contents', 'Edit Contents', 0, 0, 'Ability to make edits to at least some of the content in the page. You can lock down different block areas and specific blocks by clicking Permissions on them as well. ', 1, 0),
(7, 'edit_page_speed_settings', 'Edit Speed Settings', 0, 0, 'Ability to change caching settings.', 1, 0),
(8, 'edit_page_theme', 'Change Theme', 0, 1, 'Ability to change just the theme for this page.', 1, 0),
(9, 'edit_page_template', 'Change Page Template', 0, 0, 'Ability to change just the page template for this page.', 1, 0),
(10, 'edit_page_page_type', 'Edit Page Type', 0, 0, 'Change the type of an existing page.', 1, 0),
(11, 'edit_page_permissions', 'Edit Permissions', 1, 0, 'Ability to change permissions for this page. Warning: by granting this a user could give themselves more access.', 1, 0),
(12, 'delete_page', 'Delete', 1, 0, 'Ability to move this page to the site''s Trash.', 1, 0),
(13, 'delete_page_versions', 'Delete Versions', 1, 0, 'Ability to remove old versions of this page.', 1, 0),
(14, 'approve_page_versions', 'Approve Changes', 1, 0, 'Can publish an unapproved version of the page.', 1, 0),
(15, 'add_subpage', 'Add Sub-Page', 0, 1, 'Can add a page beneath the current page.', 1, 0),
(16, 'move_or_copy_page', 'Move or Copy Page', 1, 0, 'Can move or copy this page to another location.', 1, 0),
(17, 'schedule_page_contents_guest_access', 'Schedule Guest Access', 0, 0, 'Can control scheduled guest access to this page.', 1, 0),
(18, 'edit_page_multilingual_settings', 'Edit Multilingual Settings', 0, 0, 'Controls whether a user can see the multilingual settings menu, re-map a page or set a page as ignored in multilingual settings.', 1, 0),
(19, 'add_block', 'Add Block', 0, 1, 'Can add a block to any area on the site. If someone is added here they can add blocks to any area (unless that area has permissions that override these global permissions.)', 8, 0),
(20, 'add_stack', 'Add Stack', 0, 0, 'Can add a stack or block from a stack to any area on the site. If someone is added here they can add stacks to any area (unless that area has permissions that override these global permissions.)', 8, 0),
(21, 'view_area', 'View Area', 0, 0, 'Can view the area and its contents.', 7, 0),
(22, 'edit_area_contents', 'Edit Area Contents', 0, 0, 'Can edit blocks within this area.', 7, 0),
(23, 'add_block_to_area', 'Add Block to Area', 0, 1, 'Can add blocks to this area. This setting overrides the global Add Block permission for this area.', 7, 0),
(24, 'add_stack_to_area', 'Add Stack to Area', 0, 0, 'Can add stacks to this area. This setting overrides the global Add Stack permission for this area.', 7, 0),
(25, 'add_layout_to_area', 'Add Layouts to Area', 0, 0, 'Controls whether users get the ability to add layouts to a particular area.', 7, 0),
(26, 'edit_area_design', 'Edit Area Design', 0, 0, 'Controls whether users see design controls and can modify an area''s custom CSS.', 7, 0),
(27, 'edit_area_permissions', 'Edit Area Permissions', 0, 0, 'Controls whether users can access the permissions on an area. Custom area permissions could override those of the page.', 7, 0),
(28, 'delete_area_contents', 'Delete Area Contents', 0, 0, 'Controls whether users can delete blocks from this area.', 7, 0),
(29, 'schedule_area_contents_guest_access', 'Schedule Guest Access', 0, 0, 'Controls whether users can schedule guest access permissions on blocks in this area. Guest Access is a shortcut for granting permissions just to the Guest Group.', 7, 0),
(30, 'view_block', 'View Block', 0, 0, 'Controls whether users can view this block in the page.', 9, 0),
(31, 'edit_block', 'Edit Block', 0, 0, 'Controls whether users can edit this block. This overrides any area or page permissions.', 9, 0),
(32, 'edit_block_custom_template', 'Change Block Template', 0, 0, 'Controls whether users can change the block template on this block. This overrides any area or page permissions.', 9, 0),
(33, 'edit_block_cache_settings', 'Edit Cache Settings', 0, 0, 'Controls whether users can change the block cache settings for this block instance.', 9, 0),
(34, 'edit_block_name', 'Edit Name', 0, 0, 'Controls whether users can change the block''s name (rarely used.)', 9, 0),
(35, 'delete_block', 'Delete Block', 0, 0, 'Controls whether users can delete this block. This overrides any area or page permissions.', 9, 0),
(36, 'edit_block_design', 'Edit Design', 0, 0, 'Controls whether users can set custom design properties or CSS on this block.', 9, 0),
(37, 'edit_block_permissions', 'Edit Permissions', 0, 0, 'Controls whether users can change permissions on this block, potentially granting themselves or others greater access.', 9, 0),
(38, 'schedule_guest_access', 'Schedule Guest Access', 0, 0, 'Controls whether users can schedule guest access permissions on this block. Guest Access is a shortcut for granting permissions just to the Guest Group.', 9, 0),
(39, 'view_file_folder_file', 'View Files', 0, 0, 'View files within folder in the site.', 5, 0),
(40, 'search_file_folder', 'Search File Folder', 0, 0, 'See this file folder in the file manager', 5, 0),
(41, 'edit_file_folder', 'Edit File Folder', 0, 0, 'Edit a file folder.', 5, 0),
(42, 'edit_file_folder_file_properties', 'Edit File Properties', 0, 0, 'Can edit a file''s properties.', 5, 0),
(43, 'edit_file_folder_file_contents', 'Edit File Contents', 0, 0, 'Can edit or replace files in folder.', 5, 0),
(44, 'copy_file_folder_files', 'Copy File', 0, 0, 'Can copy files in file folder.', 5, 0),
(45, 'edit_file_folder_permissions', 'Edit File Access', 0, 0, 'Can edit access to file folder.', 5, 0),
(46, 'delete_file_folder', 'Delete File Set', 0, 0, 'Can delete file folder.', 5, 0),
(47, 'delete_file_folder_files', 'Delete File', 0, 0, 'Can delete files in folder.', 5, 0),
(48, 'add_file', 'Add File', 0, 1, 'Can add files to folder.', 5, 0),
(49, 'view_file', 'View Files', 0, 0, 'Can view and download files.', 6, 0),
(50, 'view_file_in_file_manager', 'View File in File Manager', 0, 0, 'Can access the File Manager.', 6, 0),
(51, 'edit_file_properties', 'Edit File Properties', 0, 0, 'Can edit a file''s properties.', 6, 0),
(52, 'edit_file_contents', 'Edit File Contents', 0, 0, 'Can edit or replace files.', 6, 0),
(53, 'copy_file', 'Copy File', 0, 0, 'Can copy file.', 6, 0),
(54, 'edit_file_permissions', 'Edit File Access', 0, 0, 'Can edit access to file.', 6, 0),
(55, 'delete_file', 'Delete File', 0, 0, 'Can delete file.', 6, 0),
(56, 'approve_basic_workflow_action', 'Approve or Deny', 0, 0, 'Grant ability to approve workflow.', 14, 0),
(57, 'notify_on_basic_workflow_entry', 'Notify on Entry', 0, 0, 'Notify approvers that a change has entered the workflow.', 14, 0),
(58, 'notify_on_basic_workflow_approve', 'Notify on Approve', 0, 0, 'Notify approvers that a change has been approved.', 14, 0),
(59, 'notify_on_basic_workflow_deny', 'Notify on Deny', 0, 0, 'Notify approvers that a change has been denied.', 14, 0),
(60, 'add_page_type', 'Add Pages of This Type', 0, 0, '', 15, 0),
(61, 'edit_page_type', 'Edit Page Type', 0, 0, '', 15, 0),
(62, 'delete_page_type', 'Delete Page Type', 0, 0, '', 15, 0),
(63, 'edit_page_type_permissions', 'Edit Page Type Permissions', 0, 0, '', 15, 0),
(64, 'edit_page_type_drafts', 'Edit Page Type Drafts', 0, 0, '', 15, 0),
(65, 'view_topic_tree_node', 'View Topic Tree Node', 0, 0, '', 20, 0),
(66, 'view_category_tree_node', 'View Category Tree Node', 0, 0, '', 19, 0),
(67, 'add_conversation_message', 'Add Message to Conversation', 0, 1, '', 21, 0),
(68, 'add_conversation_message_attachments', 'Add Message Attachments', 0, 0, '', 21, 0),
(69, 'edit_conversation_permissions', 'Edit Conversation Permissions', 0, 0, '', 21, 0),
(70, 'delete_conversation_message', 'Delete Message', 0, 0, '', 21, 0),
(71, 'edit_conversation_message', 'Edit Message', 0, 0, '', 21, 0),
(72, 'rate_conversation_message', 'Rate Message', 0, 0, '', 21, 0),
(73, 'flag_conversation_message', 'Flag Message', 0, 0, '', 21, 0),
(74, 'approve_conversation_message', 'Approve Message', 0, 0, '', 21, 0),
(75, 'edit_user_properties', 'Edit User Details', 0, 1, NULL, 4, 0),
(76, 'view_user_attributes', 'View User Attributes', 0, 1, NULL, 4, 0),
(77, 'activate_user', 'Activate/Deactivate User', 1, 0, NULL, 4, 0),
(78, 'sudo', 'Sign in as User', 0, 0, NULL, 4, 0),
(79, 'upgrade', 'Upgrade concrete5', 0, 0, NULL, 10, 0),
(80, 'access_group_search', 'Access Group Search', 0, 0, NULL, 4, 0),
(81, 'delete_user', 'Delete User', 1, 0, NULL, 4, 0),
(82, 'notify_in_notification_center', 'Notify in Notification Center', 0, 1, 'Controls who receives updates in the notification center.', 11, 0),
(83, 'add_calendar', 'Add Calendar', 0, 0, '', 24, 0),
(84, 'view_calendars', 'View Calendars', 0, 0, '', 24, 0),
(85, 'edit_calendars', 'Edit Calendars', 0, 0, '', 24, 0),
(86, 'edit_calendars_permissions', 'Edit Permissions', 0, 0, '', 24, 0),
(87, 'add_calendar_events', 'Add Calendar Events', 0, 0, '', 24, 0),
(88, 'approve_calendar_events', 'Approve Calendar Events', 1, 0, '', 24, 0),
(89, 'delete_calendars', 'Delete Calendars', 0, 0, '', 24, 0),
(90, 'access_calendar_rss_feeds', 'Access RSS Feeds', 0, 0, '', 24, 0),
(91, 'view_calendar', 'View Calendar', 0, 0, '', 25, 0),
(92, 'view_calendar_in_edit_interface', 'View in Edit Interface', 0, 0, '', 25, 0),
(93, 'edit_calendar_permissions', 'Edit Permissions', 0, 0, '', 25, 0),
(94, 'edit_calendar', 'Edit Calendar', 0, 0, '', 25, 0),
(95, 'add_calendar_event', 'Add Calendar Event', 0, 0, '', 25, 0),
(96, 'approve_calendar_event', 'Approve Calendar Event', 1, 0, '', 25, 0),
(97, 'edit_calendar_event_more_details_location', 'Modify More Details Location', 0, 0, '', 25, 0),
(98, 'edit_calendar_events', 'Edit Calendar Events', 0, 0, '', 25, 0),
(99, 'access_calendar_rss_feed', 'Access RSS Feed', 0, 0, '', 25, 0),
(100, 'delete_calendar', 'Delete Calendar', 0, 0, '', 25, 0),
(101, 'view_express_entries', 'View Entries', 0, 0, NULL, 18, 0),
(102, 'add_express_entries', 'Add Entry', 0, 0, NULL, 18, 0),
(103, 'edit_express_entries', 'Edit Entry', 0, 0, NULL, 18, 0),
(104, 'delete_express_entries', 'Delete Entry', 0, 0, NULL, 18, 0),
(105, 'view_express_entry', 'View Entries', 0, 0, NULL, 26, 0),
(106, 'edit_express_entry', 'Edit Entry', 0, 0, NULL, 26, 0),
(107, 'delete_express_entry', 'Delete Entry', 0, 0, NULL, 26, 0),
(108, 'search_users_in_group', 'Search User Group', 0, 0, NULL, 17, 0),
(109, 'edit_group', 'Edit Group', 0, 0, NULL, 17, 0),
(110, 'assign_group', 'Assign Group', 0, 0, NULL, 17, 0),
(111, 'add_sub_group', 'Add Child Group', 0, 0, NULL, 17, 0),
(112, 'edit_group_permissions', 'Edit Group Permissions', 0, 0, NULL, 17, 0),
(113, 'access_page_type_permissions', 'Access Page Type Permissions', 0, 0, NULL, 10, 0),
(114, 'access_task_permissions', 'Access Task Permissions', 0, 0, NULL, 10, 0),
(115, 'access_sitemap', 'Access Sitemap', 0, 0, NULL, 12, 0),
(116, 'access_page_defaults', 'Access Page Type Defaults', 0, 0, NULL, 10, 0),
(117, 'customize_themes', 'Customize Themes', 0, 0, NULL, 10, 0),
(118, 'manage_layout_presets', 'Manage Layout Presets', 0, 0, NULL, 10, 0),
(119, 'empty_trash', 'Empty Trash', 0, 0, NULL, 10, 0),
(120, 'add_topic_tree', 'Add Topic Tree', 0, 0, NULL, 10, 0),
(121, 'remove_topic_tree', 'Remove Topic Tree', 0, 0, NULL, 10, 0),
(122, 'view_in_maintenance_mode', 'View Site in Maintenance Mode', 0, 0, 'Ability to see and use the website when concrete5 is in maintenance mode.', 10, 0),
(123, 'uninstall_packages', 'Uninstall Packages', 0, 0, NULL, 13, 0),
(124, 'install_packages', 'Install Packages', 0, 0, NULL, 13, 0),
(125, 'view_newsflow', 'View Newsflow', 0, 0, NULL, 13, 0),
(126, 'access_user_search_export', 'Export Site Users', 0, 0, 'Controls whether a user can export site users or not', 4, 0),
(127, 'access_user_search', 'Access User Search', 0, 0, 'Controls whether a user can view the search user interface.', 4, 0),
(128, 'edit_topic_tree', 'Edit Topic Tree', 0, 0, NULL, 10, 0),
(129, 'edit_gatherings', 'Edit Gatherings', 0, 0, 'Can edit the footprint and items in all gatherings.', 10, 0),
(130, 'edit_gathering_items', 'Edit Gathering Items', 0, 0, '', 16, 0);

-- --------------------------------------------------------

--
-- Table structure for table `PileContents`
--

CREATE TABLE `PileContents` (
  `pcID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pID` int(10) unsigned NOT NULL DEFAULT '0',
  `itemID` int(10) unsigned NOT NULL DEFAULT '0',
  `itemType` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `quantity` int(10) unsigned NOT NULL DEFAULT '1',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `displayOrder` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`pcID`),
  KEY `pID` (`pID`,`displayOrder`),
  KEY `itemID` (`itemID`),
  KEY `itemType` (`itemType`,`itemID`,`pID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `Piles`
--

CREATE TABLE `Piles` (
  `pID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uID` int(10) unsigned DEFAULT NULL,
  `isDefault` tinyint(1) NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`pID`),
  KEY `uID` (`uID`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `PrivateMessageNotifications`
--

CREATE TABLE `PrivateMessageNotifications` (
  `msgID` int(10) unsigned NOT NULL,
  `nID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`nID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `QueueMessages`
--

CREATE TABLE `QueueMessages` (
  `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `queue_id` int(10) unsigned NOT NULL,
  `handle` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `body` longtext COLLATE utf8_unicode_ci NOT NULL,
  `md5` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `timeout` decimal(14,0) DEFAULT NULL,
  `created` int(10) unsigned NOT NULL,
  PRIMARY KEY (`message_id`),
  UNIQUE KEY `message_handle` (`handle`),
  KEY `message_queueid` (`queue_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `QueuePageDuplicationRelations`
--

CREATE TABLE `QueuePageDuplicationRelations` (
  `queue_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `originalCID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cID`,`originalCID`),
  KEY `originalCID` (`originalCID`,`queue_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `Queues`
--

CREATE TABLE `Queues` (
  `queue_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `queue_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `timeout` int(10) unsigned NOT NULL DEFAULT '30',
  PRIMARY KEY (`queue_id`),
  KEY `queue_name` (`queue_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `SavedExpressSearchQueries`
--

CREATE TABLE `SavedExpressSearchQueries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `presetName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `query_fields` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_columns` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_itemsPerPage` smallint(6) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `SavedFileSearchQueries`
--

CREATE TABLE `SavedFileSearchQueries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `presetName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `query_fields` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_columns` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_itemsPerPage` smallint(6) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `SavedPageSearchQueries`
--

CREATE TABLE `SavedPageSearchQueries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `presetName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `query_fields` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_columns` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_itemsPerPage` smallint(6) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `SavedUserSearchQueries`
--

CREATE TABLE `SavedUserSearchQueries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `presetName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `query_fields` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_columns` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:object)',
  `query_itemsPerPage` smallint(6) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `Sessions`
--

CREATE TABLE `Sessions` (
  `sessionID` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `sessionValue` longtext COLLATE utf8_unicode_ci,
  `sessionTime` int(10) unsigned NOT NULL,
  `sessionLifeTime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`sessionID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `SiblingPageRelations`
--

CREATE TABLE `SiblingPageRelations` (
  `mpRelationID` int(10) unsigned NOT NULL,
  `cID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`mpRelationID`,`cID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `SiteAttributeKeys`
--

CREATE TABLE `SiteAttributeKeys` (
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `SiteAttributeValues`
--

CREATE TABLE `SiteAttributeValues` (
  `siteID` int(10) unsigned NOT NULL,
  `akID` int(10) unsigned NOT NULL,
  `avID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`siteID`,`akID`),
  KEY `IDX_67658AF7521D8435` (`siteID`),
  KEY `IDX_67658AF7B6561A7E` (`akID`),
  KEY `IDX_67658AF7A2A82A5D` (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `SiteDomains`
--

CREATE TABLE `SiteDomains` (
  `domainID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `domain` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `siteID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`domainID`),
  KEY `IDX_4CC7400A521D8435` (`siteID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `SiteGroupRelations`
--

CREATE TABLE `SiteGroupRelations` (
  `groupRelationID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gID` int(10) unsigned NOT NULL,
  `siteGID` int(10) unsigned DEFAULT NULL,
  `siteID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`groupRelationID`),
  KEY `IDX_DCBCDCA94A62E0E4` (`siteGID`),
  KEY `IDX_DCBCDCA9521D8435` (`siteID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `SiteGroups`
--

CREATE TABLE `SiteGroups` (
  `siteGID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `groupName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `siteTypeID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`siteGID`),
  KEY `IDX_F6FE030FE9548DF7` (`siteTypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `SiteLocales`
--

CREATE TABLE `SiteLocales` (
  `siteLocaleID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `msIsDefault` tinyint(1) NOT NULL,
  `msLanguage` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `msCountry` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `msNumPlurals` int(11) NOT NULL,
  `msPluralRule` varchar(400) COLLATE utf8_unicode_ci NOT NULL,
  `msPluralCases` varchar(1000) COLLATE utf8_unicode_ci NOT NULL,
  `siteID` int(10) unsigned DEFAULT NULL,
  `siteTreeID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`siteLocaleID`),
  UNIQUE KEY `UNIQ_2527AB2CF9431B4B` (`siteTreeID`),
  KEY `IDX_2527AB2C521D8435` (`siteID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `SiteLocales`
--

INSERT INTO `SiteLocales` VALUES
(1, 1, 'en', 'US', 2, 'n != 1', 'one@1\nother@0, 2~16, 100, 1000, 10000, 100000, 1000000, …', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `Sites`
--

CREATE TABLE `Sites` (
  `siteID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pThemeID` int(10) unsigned NOT NULL,
  `siteIsDefault` tinyint(1) NOT NULL,
  `siteHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `siteTypeID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`siteID`),
  UNIQUE KEY `UNIQ_7DC18567D84E1976` (`siteHandle`),
  KEY `IDX_7DC18567E9548DF7` (`siteTypeID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `Sites`
--

INSERT INTO `Sites` VALUES
(1, 1, 1, 'default', 1);

-- --------------------------------------------------------

--
-- Table structure for table `SiteSearchIndexAttributes`
--

CREATE TABLE `SiteSearchIndexAttributes` (
  `siteID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`siteID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `SiteSkeletonLocales`
--

CREATE TABLE `SiteSkeletonLocales` (
  `skeletonLocaleID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `msLanguage` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `msCountry` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `msNumPlurals` int(11) NOT NULL,
  `msPluralRule` varchar(400) COLLATE utf8_unicode_ci NOT NULL,
  `msPluralCases` varchar(1000) COLLATE utf8_unicode_ci NOT NULL,
  `siteSkeletonID` int(10) unsigned DEFAULT NULL,
  `siteTreeID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`skeletonLocaleID`),
  UNIQUE KEY `UNIQ_212DD202F9431B4B` (`siteTreeID`),
  KEY `IDX_212DD202B579BD3E` (`siteSkeletonID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `SiteSkeletons`
--

CREATE TABLE `SiteSkeletons` (
  `siteSkeletonID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `siteTypeID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`siteSkeletonID`),
  UNIQUE KEY `UNIQ_D36AED98E9548DF7` (`siteTypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `SiteSkeletonTrees`
--

CREATE TABLE `SiteSkeletonTrees` (
  `skeletonLocaleID` int(10) unsigned DEFAULT NULL,
  `siteTypeID` int(10) unsigned DEFAULT NULL,
  `siteTreeID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`siteTreeID`),
  UNIQUE KEY `UNIQ_550F784B16B7EAF2` (`skeletonLocaleID`),
  UNIQUE KEY `UNIQ_550F784BE9548DF7` (`siteTypeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `SiteTrees`
--

CREATE TABLE `SiteTrees` (
  `siteTreeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `siteHomePageID` int(10) unsigned NOT NULL,
  `treeType` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`siteTreeID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `SiteTrees`
--

INSERT INTO `SiteTrees` VALUES
(1, 1, 'sitetree');

-- --------------------------------------------------------

--
-- Table structure for table `SiteTreeTrees`
--

CREATE TABLE `SiteTreeTrees` (
  `siteLocaleID` int(10) unsigned DEFAULT NULL,
  `siteTreeID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`siteTreeID`),
  UNIQUE KEY `UNIQ_A4B9696EACD624CD` (`siteLocaleID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `SiteTreeTrees`
--

INSERT INTO `SiteTreeTrees` VALUES
(1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `SiteTypeAttributeKeys`
--

CREATE TABLE `SiteTypeAttributeKeys` (
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `SiteTypeAttributeValues`
--

CREATE TABLE `SiteTypeAttributeValues` (
  `siteSkeletonID` int(10) unsigned DEFAULT NULL,
  `akID` int(10) unsigned NOT NULL,
  `avID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`akID`),
  KEY `IDX_78059CB9B579BD3E` (`siteSkeletonID`),
  KEY `IDX_78059CB9A2A82A5D` (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `SiteTypes`
--

CREATE TABLE `SiteTypes` (
  `siteTypeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `siteTypeHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `siteTypeName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `siteTypeThemeID` int(11) NOT NULL,
  `siteTypeHomePageTemplateID` int(11) NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`siteTypeID`),
  UNIQUE KEY `UNIQ_7CBFE97576D39A3C` (`siteTypeHandle`),
  UNIQUE KEY `UNIQ_7CBFE975C7F74FC3` (`siteTypeName`),
  KEY `IDX_7CBFE975CE45CBB0` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `SiteTypes`
--

INSERT INTO `SiteTypes` VALUES
(1, 'default', 'Default Site Type', 0, 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `SocialLinks`
--

CREATE TABLE `SocialLinks` (
  `ssHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `url` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `slID` int(11) NOT NULL AUTO_INCREMENT,
  `siteID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`slID`),
  KEY `IDX_84EBA2B4521D8435` (`siteID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `SocialLinks`
--

INSERT INTO `SocialLinks` VALUES
('facebook', 'http://facebook.com/concrete5', 1, 1),
('github', 'http://github.com/concrete5', 2, 1),
('twitter', 'http://twitter.com/concrete5', 3, 1);

-- --------------------------------------------------------

--
-- Table structure for table `Stacks`
--

CREATE TABLE `Stacks` (
  `stID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `stName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `stType` int(10) unsigned NOT NULL DEFAULT '0',
  `cID` int(10) unsigned NOT NULL DEFAULT '0',
  `stMultilingualSection` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`stID`),
  KEY `stType` (`stType`),
  KEY `stName` (`stName`),
  KEY `cID` (`cID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=9 ;

--
-- Dumping data for table `Stacks`
--

INSERT INTO `Stacks` VALUES
(1, 'Footer Contact', 20, 185, 0),
(2, 'Footer Legal', 20, 186, 0),
(3, 'Footer Navigation', 20, 187, 0),
(4, 'Footer Site Title', 20, 188, 0),
(5, 'Footer Social', 20, 189, 0),
(6, 'Header Navigation', 20, 190, 0),
(7, 'Header Search', 20, 191, 0),
(8, 'Header Site Title', 20, 192, 0);

-- --------------------------------------------------------

--
-- Table structure for table `StackUsageRecord`
--

CREATE TABLE `StackUsageRecord` (
  `stack_id` int(11) NOT NULL,
  `block_id` int(11) NOT NULL,
  `collection_id` int(11) NOT NULL,
  `collection_version_id` int(11) NOT NULL,
  PRIMARY KEY (`stack_id`,`block_id`,`collection_id`,`collection_version_id`),
  KEY `block` (`block_id`),
  KEY `collection_version` (`collection_id`,`collection_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `StyleCustomizerCustomCssRecords`
--

CREATE TABLE `StyleCustomizerCustomCssRecords` (
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  `sccRecordID` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sccRecordID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `StyleCustomizerInlineStylePresets`
--

CREATE TABLE `StyleCustomizerInlineStylePresets` (
  `pssPresetID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pssPresetName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `issID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`pssPresetID`),
  KEY `issID` (`issID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `StyleCustomizerInlineStyleSets`
--

CREATE TABLE `StyleCustomizerInlineStyleSets` (
  `issID` int(11) NOT NULL AUTO_INCREMENT,
  `customClass` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customID` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customElementAttribute` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `backgroundColor` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `backgroundImageFileID` int(11) NOT NULL,
  `backgroundRepeat` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `backgroundSize` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `backgroundPosition` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `borderColor` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `borderStyle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `borderWidth` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `borderRadius` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `baseFontSize` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `alignment` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `textColor` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `linkColor` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `marginTop` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `marginBottom` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `marginLeft` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `marginRight` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `paddingTop` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `paddingBottom` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `paddingLeft` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `paddingRight` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rotate` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `boxShadowHorizontal` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `boxShadowVertical` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `boxShadowBlur` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `boxShadowSpread` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `boxShadowColor` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hideOnExtraSmallDevice` tinyint(1) DEFAULT NULL,
  `hideOnSmallDevice` tinyint(1) DEFAULT NULL,
  `hideOnMediumDevice` tinyint(1) DEFAULT NULL,
  `hideOnLargeDevice` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`issID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=29 ;

--
-- Dumping data for table `StyleCustomizerInlineStyleSets`
--

INSERT INTO `StyleCustomizerInlineStyleSets` VALUES
(1, 'concrete5-org-stories', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(2, 'block-sidebar-wrapped', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(3, 'block-sidebar-wrapped', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(4, 'block-sidebar-wrapped', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(5, 'blog-entry-list', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(6, 'block-sidebar-wrapped', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(7, 'block-sidebar-padded', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(8, '', '', '', '', 0, 'no-repeat', '', '', '', 'none', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(9, 'feature-home-page', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(10, 'feature-home-page', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(11, 'feature-home-page', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(12, '', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '80px', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(13, 'recent-blog-entry', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(14, 'recent-blog-entry', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(15, 'area-content-accent', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(16, 'area-content-accent', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(17, 'testimonial-bio', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(18, 'testimonial-bio', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(19, 'testimonial-bio', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(20, 'testimonial-bio', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(21, 'testimonial-bio', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(22, 'testimonial-bio', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(23, 'testimonial-bio', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(24, 'testimonial-bio', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(25, 'image-right-tilt', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(26, 'image-circle', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(27, 'image-right-tilt', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0),
(28, 'page-list-with-buttons', '', '', '', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `StyleCustomizerValueLists`
--

CREATE TABLE `StyleCustomizerValueLists` (
  `scvlID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`scvlID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `StyleCustomizerValues`
--

CREATE TABLE `StyleCustomizerValues` (
  `scvID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `scvlID` int(10) unsigned DEFAULT NULL,
  `value` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`scvID`),
  KEY `scvlID` (`scvlID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `SystemAntispamLibraries`
--

CREATE TABLE `SystemAntispamLibraries` (
  `saslHandle` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `saslName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `saslIsActive` tinyint(1) NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`saslHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `SystemCaptchaLibraries`
--

CREATE TABLE `SystemCaptchaLibraries` (
  `sclHandle` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `sclName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sclIsActive` tinyint(1) NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`sclHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `SystemCaptchaLibraries`
--

INSERT INTO `SystemCaptchaLibraries` VALUES
('recaptchaV3', 'reCAPTCHA v3', 0, 0),
('securimage', 'SecurImage (Default)', 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `SystemContentEditorSnippets`
--

CREATE TABLE `SystemContentEditorSnippets` (
  `scsHandle` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `scsName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `scsIsActive` tinyint(1) NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`scsHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `SystemContentEditorSnippets`
--

INSERT INTO `SystemContentEditorSnippets` VALUES
('page_name', 'Page Name', 1, 0),
('user_name', 'User Name', 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `SystemDatabaseMigrations`
--

CREATE TABLE `SystemDatabaseMigrations` (
  `version` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `SystemDatabaseMigrations`
--

INSERT INTO `SystemDatabaseMigrations` VALUES
('20140919000000'),
('20140930000000'),
('20141017000000'),
('20141024000000'),
('20141113000000'),
('20141219000000'),
('20150109000000'),
('20150504000000'),
('20150515000000'),
('20150610000000'),
('20150612000000'),
('20150615000000'),
('20150616000000'),
('20150619000000'),
('20150622000000'),
('20150623000000'),
('20150713000000'),
('20150731000000'),
('20151221000000'),
('20160107000000'),
('20160213000000'),
('20160314000000'),
('20160412000000'),
('20160615000000'),
('20160725000000'),
('20161109000000'),
('20161203000000'),
('20161208000000'),
('20161216000000'),
('20161216100000'),
('20170118000000'),
('20170123000000'),
('20170201000000'),
('20170202000000'),
('20170227063249'),
('20170313000000'),
('20170316000000'),
('20170404000000'),
('20170406000000'),
('20170407000001'),
('20170412000000'),
('20170418000000'),
('20170420000000'),
('20170421000000'),
('20170424000000'),
('20170505000000'),
('20170512000000'),
('20170519000000'),
('20170608000000'),
('20170608100000'),
('20170609000000'),
('20170609100000'),
('20170610000000'),
('20170611000000'),
('20170613000000'),
('20170614000000'),
('20170626000000'),
('20170711151953'),
('20170731021618'),
('20170802000000'),
('20170804000000'),
('20170810000000'),
('20170818000000'),
('20170824000000'),
('20170905000000'),
('20170915000000'),
('20170926000000'),
('20171012000000'),
('20171025000000'),
('20171109000000'),
('20171109065758'),
('20171110032423'),
('20171121000000'),
('20171129190607'),
('20171218000000'),
('20171221194440'),
('20180119000000'),
('20180122213656'),
('20180122220813'),
('20180123000000'),
('20180126000000'),
('20180130000000'),
('20180212000000'),
('20180213000000'),
('20180227035239'),
('20180308043255'),
('20180328215345'),
('20180329183749'),
('20180330080830'),
('20180403143200'),
('20180518153531'),
('20180524000000'),
('20180531000000'),
('20180604000000'),
('20180609000000'),
('20180615000000'),
('20180617000000'),
('20180621222449'),
('20180622192332'),
('20180627000000'),
('20180709175202'),
('20180710203437'),
('20180716000000'),
('20180717000000'),
('20180813220933'),
('20180816210727'),
('20180820205800'),
('20180831213421'),
('20180904165911'),
('20180907091500'),
('20180910000000'),
('20180912113737'),
('20180920000000'),
('20180926000000'),
('20180926070200'),
('20180926070300'),
('20181006212300'),
('20181006212400'),
('20181019010145'),
('20181029223809'),
('20181105102800'),
('20181112211702'),
('20181116072400'),
('20181211000000'),
('20181211100000'),
('20181212000000'),
('20181212221911'),
('20181222183445'),
('20190106000000'),
('20190110194848'),
('20190110231015'),
('20190111181236'),
('20190112000000'),
('20190129000000'),
('20190225000000'),
('20190225184524'),
('20190301133300'),
('20190309000000'),
('20190310000000'),
('20190416224702'),
('20190417180607'),
('20190422235040'),
('20190504005632'),
('20190508232235'),
('20190509000000'),
('20190509205043'),
('20190513164028'),
('20190516204806'),
('20190520171430'),
('20190522202749'),
('20190619141521'),
('20190625177700'),
('20190625177710'),
('20190708000000'),
('20190717090600'),
('20190817000000'),
('20190822160700'),
('20190826000000'),
('20190925072210'),
('20191002000000'),
('20200118043285'),
('20200203000000'),
('20200501000000'),
('20200609145307'),
('20201116182100'),
('20210622145600'),
('20210623000000'),
('20220319043123'),
('20240809105200');

-- --------------------------------------------------------

--
-- Table structure for table `SystemDatabaseQueryLog`
--

CREATE TABLE `SystemDatabaseQueryLog` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `query` text COLLATE utf8_unicode_ci,
  `params` text COLLATE utf8_unicode_ci,
  `executionMS` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `TopicTrees`
--

CREATE TABLE `TopicTrees` (
  `treeID` int(10) unsigned NOT NULL DEFAULT '0',
  `topicTreeName` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`treeID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `TopicTrees`
--

INSERT INTO `TopicTrees` VALUES
(4, 'Blog Entries'),
(5, 'Projects'),
(6, 'Event Categories');

-- --------------------------------------------------------

--
-- Table structure for table `TreeFileFolderNodes`
--

CREATE TABLE `TreeFileFolderNodes` (
  `treeNodeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fslID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`treeNodeID`),
  KEY `fslID` (`fslID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `TreeFileNodes`
--

CREATE TABLE `TreeFileNodes` (
  `treeNodeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`treeNodeID`),
  KEY `fID` (`fID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=24 ;

--
-- Dumping data for table `TreeFileNodes`
--

INSERT INTO `TreeFileNodes` VALUES
(8, 1),
(9, 2),
(10, 3),
(11, 4),
(12, 5),
(13, 6),
(14, 7),
(15, 8),
(16, 9),
(17, 10),
(18, 11),
(19, 12),
(20, 13),
(21, 14),
(22, 15),
(23, 16);

-- --------------------------------------------------------

--
-- Table structure for table `TreeGroupNodes`
--

CREATE TABLE `TreeGroupNodes` (
  `treeNodeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`treeNodeID`),
  KEY `gID` (`gID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `TreeGroupNodes`
--

INSERT INTO `TreeGroupNodes` VALUES
(2, 1),
(3, 2),
(4, 3);

-- --------------------------------------------------------

--
-- Table structure for table `TreeNodePermissionAssignments`
--

CREATE TABLE `TreeNodePermissionAssignments` (
  `treeNodeID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkID` int(10) unsigned NOT NULL DEFAULT '0',
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`treeNodeID`,`pkID`,`paID`),
  KEY `pkID` (`pkID`),
  KEY `paID` (`paID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `TreeNodePermissionAssignments`
--

INSERT INTO `TreeNodePermissionAssignments` VALUES
(7, 39, 55),
(7, 40, 56),
(7, 41, 57),
(7, 42, 58),
(7, 43, 59),
(7, 44, 60),
(7, 45, 61),
(7, 46, 63),
(7, 47, 62),
(7, 48, 64),
(7, 66, 44),
(24, 66, 45),
(33, 66, 46),
(38, 66, 47),
(5, 101, 37),
(6, 101, 32),
(5, 102, 33),
(6, 102, 36),
(5, 103, 34),
(6, 103, 34),
(5, 104, 35),
(6, 104, 35),
(1, 108, 106),
(1, 109, 107),
(1, 110, 108),
(1, 111, 109),
(1, 112, 110);

-- --------------------------------------------------------

--
-- Table structure for table `TreeNodes`
--

CREATE TABLE `TreeNodes` (
  `treeNodeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `treeNodeTypeID` int(10) unsigned DEFAULT '0',
  `treeID` int(10) unsigned DEFAULT '0',
  `treeNodeParentID` int(10) unsigned DEFAULT '0',
  `treeNodeDisplayOrder` int(10) unsigned DEFAULT '0',
  `treeNodeName` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `dateModified` datetime DEFAULT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `treeNodeOverridePermissions` tinyint(1) DEFAULT '0',
  `inheritPermissionsFromTreeNodeID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`treeNodeID`),
  KEY `treeNodeParentID` (`treeNodeParentID`),
  KEY `treeNodeTypeID` (`treeNodeTypeID`),
  KEY `treeID` (`treeID`),
  KEY `inheritPermissionsFromTreeNodeID` (`inheritPermissionsFromTreeNodeID`,`treeNodeID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=44 ;

--
-- Dumping data for table `TreeNodes`
--

INSERT INTO `TreeNodes` VALUES
(1, 1, 1, 0, 0, '', '[[date_gmt]]', '[[date_gmt]]', 1, 1),
(2, 1, 1, 1, 0, '', '[[date_gmt]]', '[[date_gmt]]', 0, 1),
(3, 1, 1, 1, 1, '', '[[date_gmt]]', '[[date_gmt]]', 0, 1),
(4, 1, 1, 1, 2, '', '[[date_gmt]]', '[[date_gmt]]', 0, 1),
(5, 3, 2, 0, 0, '', '[[date_gmt]]', '[[date_gmt]]', 1, 5),
(6, 3, 2, 5, 0, 'Forms', '[[date_gmt]]', '[[date_gmt]]', 1, 6),
(7, 7, 3, 0, 0, '', '[[date_gmt]]', '[[date_gmt]]', 1, 7),
(8, 6, 3, 7, 0, '', '[[date_gmt]]', '[[date_gmt]]', 0, 7),
(9, 6, 3, 7, 1, '', '[[date_gmt]]', '[[date_gmt]]', 0, 7),
(10, 6, 3, 7, 2, '', '[[date_gmt]]', '[[date_gmt]]', 0, 7),
(11, 6, 3, 7, 3, '', '[[date_gmt]]', '[[date_gmt]]', 0, 7),
(12, 6, 3, 7, 4, '', '[[date_gmt]]', '[[date_gmt]]', 0, 7),
(13, 6, 3, 7, 5, '', '[[date_gmt]]', '[[date_gmt]]', 0, 7),
(14, 6, 3, 7, 6, '', '[[date_gmt]]', '[[date_gmt]]', 0, 7),
(15, 6, 3, 7, 7, '', '[[date_gmt]]', '[[date_gmt]]', 0, 7),
(16, 6, 3, 7, 8, '', '[[date_gmt]]', '[[date_gmt]]', 0, 7),
(17, 6, 3, 7, 9, '', '[[date_gmt]]', '[[date_gmt]]', 0, 7),
(18, 6, 3, 7, 10, '', '[[date_gmt]]', '[[date_gmt]]', 0, 7),
(19, 6, 3, 7, 11, '', '[[date_gmt]]', '[[date_gmt]]', 0, 7),
(20, 6, 3, 7, 12, '', '[[date_gmt]]', '[[date_gmt]]', 0, 7),
(21, 6, 3, 7, 13, '', '[[date_gmt]]', '[[date_gmt]]', 0, 7),
(22, 6, 3, 7, 14, '', '[[date_gmt]]', '[[date_gmt]]', 0, 7),
(23, 6, 3, 7, 15, '', '[[date_gmt]]', '[[date_gmt]]', 0, 7),
(24, 2, 4, 0, 0, '', '[[date_gmt]]', '[[date_gmt]]', 1, 24),
(25, 2, 4, 24, 0, 'Reviews', '[[date_gmt]]', '[[date_gmt]]', 0, 24),
(26, 5, 4, 25, 0, 'Gadgets', '[[date_gmt]]', '[[date_gmt]]', 0, 24),
(27, 5, 4, 25, 1, 'Movies', '[[date_gmt]]', '[[date_gmt]]', 0, 24),
(28, 5, 4, 25, 2, 'Books', '[[date_gmt]]', '[[date_gmt]]', 0, 24),
(29, 5, 4, 25, 3, 'Music', '[[date_gmt]]', '[[date_gmt]]', 0, 24),
(30, 5, 4, 24, 1, 'Projects', '[[date_gmt]]', '[[date_gmt]]', 0, 24),
(31, 5, 4, 24, 2, 'Sports', '[[date_gmt]]', '[[date_gmt]]', 0, 24),
(32, 5, 4, 24, 3, 'Humor', '[[date_gmt]]', '[[date_gmt]]', 0, 24),
(33, 2, 5, 0, 0, '', '[[date_gmt]]', '[[date_gmt]]', 1, 33),
(34, 5, 5, 33, 0, 'Crafts', '[[date_gmt]]', '[[date_gmt]]', 0, 33),
(35, 5, 5, 33, 1, 'Homework', '[[date_gmt]]', '[[date_gmt]]', 0, 33),
(36, 5, 5, 33, 2, 'Supplies', '[[date_gmt]]', '[[date_gmt]]', 0, 33),
(37, 5, 5, 33, 3, 'Activities', '[[date_gmt]]', '[[date_gmt]]', 0, 33),
(38, 2, 6, 0, 0, '', '[[date_gmt]]', '[[date_gmt]]', 1, 38),
(39, 5, 6, 38, 0, 'Meetings', '[[date_gmt]]', '[[date_gmt]]', 0, 38),
(40, 5, 6, 38, 1, 'Activities', '[[date_gmt]]', '[[date_gmt]]', 0, 38),
(41, 5, 6, 38, 2, 'Sports', '[[date_gmt]]', '[[date_gmt]]', 0, 38),
(42, 5, 6, 38, 3, 'Holidays', '[[date_gmt]]', '[[date_gmt]]', 0, 38),
(43, 4, 2, 6, 0, 'Contact', '[[date_gmt]]', '[[date_gmt]]', 0, 6);

-- --------------------------------------------------------

--
-- Table structure for table `TreeNodeTypes`
--

CREATE TABLE `TreeNodeTypes` (
  `treeNodeTypeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `treeNodeTypeHandle` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `pkgID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`treeNodeTypeID`),
  UNIQUE KEY `treeNodeTypeHandle` (`treeNodeTypeHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=9 ;

--
-- Dumping data for table `TreeNodeTypes`
--

INSERT INTO `TreeNodeTypes` VALUES
(1, 'group', 0),
(2, 'category', 0),
(3, 'express_entry_category', 0),
(4, 'express_entry_results', 0),
(5, 'topic', 0),
(6, 'file', 0),
(7, 'file_folder', 0),
(8, 'search_preset', 0);

-- --------------------------------------------------------

--
-- Table structure for table `Trees`
--

CREATE TABLE `Trees` (
  `treeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `treeTypeID` int(10) unsigned DEFAULT '0',
  `treeDateAdded` datetime DEFAULT NULL,
  `rootTreeNodeID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`treeID`),
  KEY `treeTypeID` (`treeTypeID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `Trees`
--

INSERT INTO `Trees` VALUES
(1, 1, '[[date_gmt]]', 1),
(2, 2, '[[date_gmt]]', 5),
(3, 4, '[[date_gmt]]', 7),
(4, 3, '[[date_gmt]]', 24),
(5, 3, '[[date_gmt]]', 33),
(6, 3, '[[date_gmt]]', 38);

-- --------------------------------------------------------

--
-- Table structure for table `TreeSearchQueryNodes`
--

CREATE TABLE `TreeSearchQueryNodes` (
  `treeNodeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `savedSearchID` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`treeNodeID`),
  KEY `savedSearchID` (`savedSearchID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `TreeTypes`
--

CREATE TABLE `TreeTypes` (
  `treeTypeID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `treeTypeHandle` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `pkgID` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`treeTypeID`),
  UNIQUE KEY `treeTypeHandle` (`treeTypeHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `TreeTypes`
--

INSERT INTO `TreeTypes` VALUES
(1, 'group', 0),
(2, 'express_entry_results', 0),
(3, 'topic', 0),
(4, 'file_manager', 0);

-- --------------------------------------------------------

--
-- Table structure for table `UsedStringLog`
--

CREATE TABLE `UsedStringLog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `usedString` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `subject` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_4E83837CF5E609AF` (`usedString`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `UserAttributeKeys`
--

CREATE TABLE `UserAttributeKeys` (
  `uakProfileDisplay` tinyint(1) NOT NULL,
  `uakProfileEdit` tinyint(1) NOT NULL,
  `uakProfileEditRequired` tinyint(1) NOT NULL,
  `uakRegisterEdit` tinyint(1) NOT NULL,
  `uakRegisterEditRequired` tinyint(1) NOT NULL,
  `uakMemberListDisplay` tinyint(1) NOT NULL,
  `akID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `UserAttributeKeys`
--

INSERT INTO `UserAttributeKeys` VALUES
(0, 1, 0, 1, 0, 0, 14),
(0, 1, 0, 1, 0, 0, 15),
(0, 0, 0, 0, 0, 0, 18);

-- --------------------------------------------------------

--
-- Table structure for table `UserAttributeValues`
--

CREATE TABLE `UserAttributeValues` (
  `uID` int(10) unsigned NOT NULL,
  `akID` int(10) unsigned NOT NULL,
  `avID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`uID`,`akID`),
  KEY `IDX_4DB68CA6FD71026C` (`uID`),
  KEY `IDX_4DB68CA6B6561A7E` (`akID`),
  KEY `IDX_4DB68CA6A2A82A5D` (`avID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `UserDeactivatedNotifications`
--

CREATE TABLE `UserDeactivatedNotifications` (
  `userID` int(10) unsigned NOT NULL,
  `actorID` int(10) unsigned DEFAULT NULL,
  `nID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`nID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `UserGroups`
--

CREATE TABLE `UserGroups` (
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  `gID` int(10) unsigned NOT NULL DEFAULT '0',
  `ugEntered` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY (`uID`,`gID`),
  KEY `uID` (`uID`),
  KEY `gID` (`gID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `UserLoginAttempts`
--

CREATE TABLE `UserLoginAttempts` (
  `id` char(36) COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:guid)',
  `userId` int(10) unsigned NOT NULL,
  `utcDate` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `UserPermissionEditPropertyAccessList`
--

CREATE TABLE `UserPermissionEditPropertyAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `uName` tinyint(1) DEFAULT '0',
  `uEmail` tinyint(1) DEFAULT '0',
  `uPassword` tinyint(1) DEFAULT '0',
  `uAvatar` tinyint(1) DEFAULT '0',
  `uTimezone` tinyint(1) DEFAULT '0',
  `uDefaultLanguage` tinyint(1) DEFAULT '0',
  `attributePermission` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `UserPermissionEditPropertyAttributeAccessListCustom`
--

CREATE TABLE `UserPermissionEditPropertyAttributeAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `akID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`akID`),
  KEY `peID` (`peID`),
  KEY `akID` (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `UserPermissionViewAttributeAccessList`
--

CREATE TABLE `UserPermissionViewAttributeAccessList` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `permission` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`paID`,`peID`),
  KEY `peID` (`peID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `UserPermissionViewAttributeAccessListCustom`
--

CREATE TABLE `UserPermissionViewAttributeAccessListCustom` (
  `paID` int(10) unsigned NOT NULL DEFAULT '0',
  `peID` int(10) unsigned NOT NULL DEFAULT '0',
  `akID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`paID`,`peID`,`akID`),
  KEY `peID` (`peID`),
  KEY `akID` (`akID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `UserPointActions`
--

CREATE TABLE `UserPointActions` (
  `upaID` int(11) NOT NULL AUTO_INCREMENT,
  `upaHandle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `upaName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `upaDefaultPoints` int(11) NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  `upaHasCustomClass` tinyint(1) NOT NULL DEFAULT '0',
  `upaIsActive` tinyint(1) NOT NULL DEFAULT '1',
  `gBadgeID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`upaID`),
  UNIQUE KEY `upaHandle` (`upaHandle`),
  KEY `pkgID` (`pkgID`),
  KEY `gBBadgeID` (`gBadgeID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `UserPointActions`
--

INSERT INTO `UserPointActions` VALUES
(1, 'won_badge', 'Won a Badge', 5, 0, 1, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `UserPointHistory`
--

CREATE TABLE `UserPointHistory` (
  `upID` int(11) NOT NULL AUTO_INCREMENT,
  `upuID` int(11) NOT NULL DEFAULT '0',
  `upaID` int(11) DEFAULT '0',
  `upPoints` int(11) DEFAULT '0',
  `object` longtext COLLATE utf8_unicode_ci,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`upID`),
  KEY `upuID` (`upuID`),
  KEY `upaID` (`upaID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `UserPrivateMessages`
--

CREATE TABLE `UserPrivateMessages` (
  `msgID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uAuthorID` int(10) unsigned NOT NULL DEFAULT '0',
  `msgDateCreated` datetime NOT NULL,
  `msgSubject` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `msgBody` text COLLATE utf8_unicode_ci,
  `uToID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`msgID`),
  KEY `uAuthorID` (`uAuthorID`,`msgDateCreated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `UserPrivateMessagesTo`
--

CREATE TABLE `UserPrivateMessagesTo` (
  `msgID` int(10) unsigned NOT NULL DEFAULT '0',
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  `uAuthorID` int(10) unsigned NOT NULL DEFAULT '0',
  `msgMailboxID` int(11) NOT NULL,
  `msgIsNew` tinyint(1) NOT NULL DEFAULT '0',
  `msgIsUnread` tinyint(1) NOT NULL DEFAULT '0',
  `msgIsReplied` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`msgID`,`uID`,`uAuthorID`,`msgMailboxID`),
  KEY `uID` (`uID`),
  KEY `uAuthorID` (`uAuthorID`),
  KEY `msgFolderID` (`msgMailboxID`),
  KEY `msgIsNew` (`msgIsNew`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `Users`
--

CREATE TABLE `Users` (
  `uID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uName` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `uEmail` varchar(254) COLLATE utf8_unicode_ci NOT NULL,
  `uPassword` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `uIsActive` tinyint(1) NOT NULL,
  `uIsFullRecord` tinyint(1) NOT NULL,
  `uIsValidated` tinyint(1) NOT NULL DEFAULT '-1',
  `uDateAdded` datetime NOT NULL,
  `uLastPasswordChange` datetime NOT NULL,
  `uHasAvatar` tinyint(1) NOT NULL,
  `uLastOnline` int(10) unsigned NOT NULL DEFAULT '0',
  `uLastLogin` int(10) unsigned NOT NULL DEFAULT '0',
  `uPreviousLogin` int(10) unsigned DEFAULT '0',
  `uNumLogins` int(10) unsigned NOT NULL DEFAULT '0',
  `uLastAuthTypeID` int(10) unsigned NOT NULL DEFAULT '0',
  `uLastIP` longtext COLLATE utf8_unicode_ci,
  `uTimezone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `uDefaultLanguage` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `uIsPasswordReset` tinyint(1) NOT NULL,
  PRIMARY KEY (`uID`),
  UNIQUE KEY `UNIQ_D5428AED28459686` (`uName`),
  KEY `uEmail` (`uEmail`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `Users`
--

INSERT INTO `Users` VALUES
(1, '[[admin_username]]', '[[admin_email]]', '[[admin_pass]]', 1, 1, 1, '[[date_gmt]]', '[[date_gmt]]', 0, 0, [[timestamp]], 0, 1, 0, '[[longip]]', NULL, NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `UserSearchIndexAttributes`
--

CREATE TABLE `UserSearchIndexAttributes` (
  `uID` int(10) unsigned NOT NULL,
  `ak_profile_private_messages_enabled` tinyint(1) DEFAULT '0',
  `ak_profile_private_messages_notification_enabled` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`uID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `UserSignupNotifications`
--

CREATE TABLE `UserSignupNotifications` (
  `usID` int(10) unsigned DEFAULT NULL,
  `nID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`nID`),
  KEY `IDX_7FB1DF5B7B18287E` (`usID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `UserSignups`
--

CREATE TABLE `UserSignups` (
  `usID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uID` int(10) unsigned DEFAULT NULL,
  `createdBy` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`usID`),
  UNIQUE KEY `UNIQ_FEB5D909FD71026C` (`uID`),
  KEY `IDX_FEB5D909D3564642` (`createdBy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `UserValidationHashes`
--

CREATE TABLE `UserValidationHashes` (
  `uvhID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uID` int(10) unsigned DEFAULT NULL,
  `uHash` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `type` smallint(5) unsigned NOT NULL DEFAULT '0',
  `uDateGenerated` int(10) unsigned NOT NULL DEFAULT '0',
  `uDateRedeemed` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`uvhID`),
  KEY `uID` (`uID`,`type`),
  KEY `uHash` (`uHash`,`type`),
  KEY `uDateGenerated` (`uDateGenerated`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `UserWorkflowProgress`
--

CREATE TABLE `UserWorkflowProgress` (
  `uID` int(10) unsigned NOT NULL DEFAULT '0',
  `wpID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`uID`,`wpID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `WorkflowProgress`
--

CREATE TABLE `WorkflowProgress` (
  `wpID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wpCategoryID` int(10) unsigned DEFAULT NULL,
  `wfID` int(10) unsigned NOT NULL DEFAULT '0',
  `wpApproved` tinyint(1) NOT NULL DEFAULT '0',
  `wpDateAdded` datetime DEFAULT NULL,
  `wpDateLastAction` datetime DEFAULT NULL,
  `wpCurrentStatus` int(11) NOT NULL DEFAULT '0',
  `wrID` int(11) NOT NULL DEFAULT '0',
  `wpIsCompleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`wpID`),
  KEY `wpCategoryID` (`wpCategoryID`),
  KEY `wfID` (`wfID`),
  KEY `wrID` (`wrID`,`wpID`,`wpIsCompleted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `WorkflowProgressCategories`
--

CREATE TABLE `WorkflowProgressCategories` (
  `wpCategoryID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wpCategoryHandle` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`wpCategoryID`),
  UNIQUE KEY `wpCategoryHandle` (`wpCategoryHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `WorkflowProgressCategories`
--

INSERT INTO `WorkflowProgressCategories` VALUES
(1, 'page', NULL),
(2, 'file', NULL),
(3, 'user', NULL),
(4, 'calendar_event', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `WorkflowProgressHistory`
--

CREATE TABLE `WorkflowProgressHistory` (
  `wphID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wpID` int(10) unsigned NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `object` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`wphID`),
  KEY `wpID` (`wpID`,`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `WorkflowProgressNotifications`
--

CREATE TABLE `WorkflowProgressNotifications` (
  `wpID` int(10) unsigned NOT NULL,
  `nID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`nID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `WorkflowRequestObjects`
--

CREATE TABLE `WorkflowRequestObjects` (
  `wrID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wrObject` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`wrID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `Workflows`
--

CREATE TABLE `Workflows` (
  `wfID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wfName` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `wftID` int(10) unsigned NOT NULL DEFAULT '0',
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`wfID`),
  UNIQUE KEY `wfName` (`wfName`),
  KEY `wftID` (`wftID`,`wfID`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `WorkflowTypes`
--

CREATE TABLE `WorkflowTypes` (
  `wftID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wftHandle` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `wftName` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `pkgID` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`wftID`),
  UNIQUE KEY `wftHandle` (`wftHandle`),
  KEY `pkgID` (`pkgID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `WorkflowTypes`
--

INSERT INTO `WorkflowTypes` VALUES
(1, 'basic', 'Basic Workflow', 0);

--
-- Constraints for dumped tables
--

--
-- Constraints for table `AreaLayoutsUsingPresets`
--
ALTER TABLE `AreaLayoutsUsingPresets`
  ADD CONSTRAINT `FK_7A9049A1385521EA` FOREIGN KEY (`arLayoutID`) REFERENCES `AreaLayouts` (`arLayoutID`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `atAddress`
--
ALTER TABLE `atAddress`
  ADD CONSTRAINT `FK_DA949740A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`) ON DELETE CASCADE;

--
-- Constraints for table `atAddressSettings`
--
ALTER TABLE `atAddressSettings`
  ADD CONSTRAINT `FK_5A737B61B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `atBoolean`
--
ALTER TABLE `atBoolean`
  ADD CONSTRAINT `FK_5D5F70A9A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`) ON DELETE CASCADE;

--
-- Constraints for table `atBooleanSettings`
--
ALTER TABLE `atBooleanSettings`
  ADD CONSTRAINT `FK_78025F47B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `atDateTime`
--
ALTER TABLE `atDateTime`
  ADD CONSTRAINT `FK_DF75412AA2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`) ON DELETE CASCADE;

--
-- Constraints for table `atDateTimeSettings`
--
ALTER TABLE `atDateTimeSettings`
  ADD CONSTRAINT `FK_C6B3B63AB6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `atDefault`
--
ALTER TABLE `atDefault`
  ADD CONSTRAINT `FK_3484F81EA2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`) ON DELETE CASCADE;

--
-- Constraints for table `atEmptySettings`
--
ALTER TABLE `atEmptySettings`
  ADD CONSTRAINT `FK_ED1BF189B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `atExpress`
--
ALTER TABLE `atExpress`
  ADD CONSTRAINT `FK_CFAF40F1A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`) ON DELETE CASCADE;

--
-- Constraints for table `atExpressSelectedEntries`
--
ALTER TABLE `atExpressSelectedEntries`
  ADD CONSTRAINT `FK_C9D404BB6DCB6296` FOREIGN KEY (`exEntryID`) REFERENCES `ExpressEntityEntries` (`exEntryID`),
  ADD CONSTRAINT `FK_C9D404BBA2A82A5D` FOREIGN KEY (`avID`) REFERENCES `atExpress` (`avID`);

--
-- Constraints for table `atExpressSettings`
--
ALTER TABLE `atExpressSettings`
  ADD CONSTRAINT `FK_E8F67F0FB6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`),
  ADD CONSTRAINT `FK_E8F67F0FCE2D7284` FOREIGN KEY (`exEntityID`) REFERENCES `ExpressEntities` (`id`);

--
-- Constraints for table `atFile`
--
ALTER TABLE `atFile`
  ADD CONSTRAINT `FK_73D17D61A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_73D17D61E3111F45` FOREIGN KEY (`fID`) REFERENCES `Files` (`fID`) ON DELETE CASCADE;

--
-- Constraints for table `atFileSettings`
--
ALTER TABLE `atFileSettings`
  ADD CONSTRAINT `FK_EADD86C8B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `atNumber`
--
ALTER TABLE `atNumber`
  ADD CONSTRAINT `FK_41BA30B5A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`) ON DELETE CASCADE;

--
-- Constraints for table `atSelect`
--
ALTER TABLE `atSelect`
  ADD CONSTRAINT `FK_9CD8C521A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`) ON DELETE CASCADE;

--
-- Constraints for table `atSelectedSocialLinks`
--
ALTER TABLE `atSelectedSocialLinks`
  ADD CONSTRAINT `FK_10743709A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `atSocialLinks` (`avID`);

--
-- Constraints for table `atSelectedTopics`
--
ALTER TABLE `atSelectedTopics`
  ADD CONSTRAINT `FK_E42A7D5BA2A82A5D` FOREIGN KEY (`avID`) REFERENCES `atTopic` (`avID`);

--
-- Constraints for table `atSelectOptions`
--
ALTER TABLE `atSelectOptions`
  ADD CONSTRAINT `FK_797414B0CB59257C` FOREIGN KEY (`avSelectOptionListID`) REFERENCES `atSelectOptionLists` (`avSelectOptionListID`);

--
-- Constraints for table `atSelectOptionsSelected`
--
ALTER TABLE `atSelectOptionsSelected`
  ADD CONSTRAINT `FK_40C97EC3E584C274` FOREIGN KEY (`avSelectOptionID`) REFERENCES `atSelectOptions` (`avSelectOptionID`),
  ADD CONSTRAINT `FK_40C97EC3A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `atSelect` (`avID`);

--
-- Constraints for table `atSelectSettings`
--
ALTER TABLE `atSelectSettings`
  ADD CONSTRAINT `FK_5D514424B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`),
  ADD CONSTRAINT `FK_5D514424CB59257C` FOREIGN KEY (`avSelectOptionListID`) REFERENCES `atSelectOptionLists` (`avSelectOptionListID`);

--
-- Constraints for table `atSite`
--
ALTER TABLE `atSite`
  ADD CONSTRAINT `FK_960D4295A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_960D4295521D8435` FOREIGN KEY (`siteID`) REFERENCES `Sites` (`siteID`);

--
-- Constraints for table `atSocialLinks`
--
ALTER TABLE `atSocialLinks`
  ADD CONSTRAINT `FK_1431EC8AA2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`) ON DELETE CASCADE;

--
-- Constraints for table `atTextareaSettings`
--
ALTER TABLE `atTextareaSettings`
  ADD CONSTRAINT `FK_A6EA10D6B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `atTextSettings`
--
ALTER TABLE `atTextSettings`
  ADD CONSTRAINT `FK_951A10CCB6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `atTopic`
--
ALTER TABLE `atTopic`
  ADD CONSTRAINT `FK_BABDD1FAA2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`) ON DELETE CASCADE;

--
-- Constraints for table `atTopicSettings`
--
ALTER TABLE `atTopicSettings`
  ADD CONSTRAINT `FK_830FD2FEB6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `AttributeKeyCategories`
--
ALTER TABLE `AttributeKeyCategories`
  ADD CONSTRAINT `FK_A2A0CC67CE45CBB0` FOREIGN KEY (`pkgID`) REFERENCES `Packages` (`pkgID`);

--
-- Constraints for table `AttributeKeys`
--
ALTER TABLE `AttributeKeys`
  ADD CONSTRAINT `FK_DCA32C62CE45CBB0` FOREIGN KEY (`pkgID`) REFERENCES `Packages` (`pkgID`),
  ADD CONSTRAINT `FK_DCA32C62A12CFE33` FOREIGN KEY (`atID`) REFERENCES `AttributeTypes` (`atID`),
  ADD CONSTRAINT `FK_DCA32C62B059B76B` FOREIGN KEY (`akCategoryID`) REFERENCES `AttributeKeyCategories` (`akCategoryID`);

--
-- Constraints for table `AttributeSetKeys`
--
ALTER TABLE `AttributeSetKeys`
  ADD CONSTRAINT `FK_222F72D8A463E8B6` FOREIGN KEY (`asID`) REFERENCES `AttributeSets` (`asID`),
  ADD CONSTRAINT `FK_222F72D8B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `AttributeSets`
--
ALTER TABLE `AttributeSets`
  ADD CONSTRAINT `FK_FCA02D5FCE45CBB0` FOREIGN KEY (`pkgID`) REFERENCES `Packages` (`pkgID`),
  ADD CONSTRAINT `FK_FCA02D5FB059B76B` FOREIGN KEY (`akCategoryID`) REFERENCES `AttributeKeyCategories` (`akCategoryID`);

--
-- Constraints for table `AttributeTypeCategories`
--
ALTER TABLE `AttributeTypeCategories`
  ADD CONSTRAINT `FK_49A9CABEA12CFE33` FOREIGN KEY (`atID`) REFERENCES `AttributeTypes` (`atID`),
  ADD CONSTRAINT `FK_49A9CABEB059B76B` FOREIGN KEY (`akCategoryID`) REFERENCES `AttributeKeyCategories` (`akCategoryID`);

--
-- Constraints for table `AttributeTypes`
--
ALTER TABLE `AttributeTypes`
  ADD CONSTRAINT `FK_53580A7FCE45CBB0` FOREIGN KEY (`pkgID`) REFERENCES `Packages` (`pkgID`);

--
-- Constraints for table `AttributeValues`
--
ALTER TABLE `AttributeValues`
  ADD CONSTRAINT `FK_DCCE7864B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`) ON DELETE CASCADE;

--
-- Constraints for table `atUserGroupSettings`
--
ALTER TABLE `atUserGroupSettings`
  ADD CONSTRAINT `FK_C47871BEB6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `CalendarEventAttributeKeys`
--
ALTER TABLE `CalendarEventAttributeKeys`
  ADD CONSTRAINT `FK_27F477CCB6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`) ON DELETE CASCADE;

--
-- Constraints for table `CalendarEventOccurrences`
--
ALTER TABLE `CalendarEventOccurrences`
  ADD CONSTRAINT `FK_7DD686EC31391E00` FOREIGN KEY (`repetitionID`) REFERENCES `CalendarEventRepetitions` (`repetitionID`);

--
-- Constraints for table `CalendarEvents`
--
ALTER TABLE `CalendarEvents`
  ADD CONSTRAINT `FK_7F23C55611C85723` FOREIGN KEY (`caID`) REFERENCES `Calendars` (`caID`);

--
-- Constraints for table `CalendarEventVersionAttributeValues`
--
ALTER TABLE `CalendarEventVersionAttributeValues`
  ADD CONSTRAINT `FK_8C835B05A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`),
  ADD CONSTRAINT `FK_8C835B05403F5D6` FOREIGN KEY (`eventVersionID`) REFERENCES `CalendarEventVersions` (`eventVersionID`),
  ADD CONSTRAINT `FK_8C835B05B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `CalendarEventVersionOccurrences`
--
ALTER TABLE `CalendarEventVersionOccurrences`
  ADD CONSTRAINT `FK_60310489B4FDDC0F` FOREIGN KEY (`occurrenceID`) REFERENCES `CalendarEventOccurrences` (`occurrenceID`),
  ADD CONSTRAINT `FK_60310489403F5D6` FOREIGN KEY (`eventVersionID`) REFERENCES `CalendarEventVersions` (`eventVersionID`);

--
-- Constraints for table `CalendarEventVersionRepetitions`
--
ALTER TABLE `CalendarEventVersionRepetitions`
  ADD CONSTRAINT `FK_C1C3D3DB31391E00` FOREIGN KEY (`repetitionID`) REFERENCES `CalendarEventRepetitions` (`repetitionID`),
  ADD CONSTRAINT `FK_C1C3D3DB403F5D6` FOREIGN KEY (`eventVersionID`) REFERENCES `CalendarEventVersions` (`eventVersionID`);

--
-- Constraints for table `CalendarEventVersions`
--
ALTER TABLE `CalendarEventVersions`
  ADD CONSTRAINT `FK_8E260274FD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`),
  ADD CONSTRAINT `FK_8E26027410409BA4` FOREIGN KEY (`eventID`) REFERENCES `CalendarEvents` (`eventID`);

--
-- Constraints for table `CalendarEventWorkflowProgress`
--
ALTER TABLE `CalendarEventWorkflowProgress`
  ADD CONSTRAINT `FK_C5EAACF910409BA4` FOREIGN KEY (`eventID`) REFERENCES `CalendarEvents` (`eventID`);

--
-- Constraints for table `CalendarPermissionAssignments`
--
ALTER TABLE `CalendarPermissionAssignments`
  ADD CONSTRAINT `FK_5AD546AA11C85723` FOREIGN KEY (`caID`) REFERENCES `Calendars` (`caID`);

--
-- Constraints for table `CalendarRelatedEvents`
--
ALTER TABLE `CalendarRelatedEvents`
  ADD CONSTRAINT `FK_310130E910409BA4` FOREIGN KEY (`eventID`) REFERENCES `CalendarEvents` (`eventID`);

--
-- Constraints for table `Calendars`
--
ALTER TABLE `Calendars`
  ADD CONSTRAINT `FK_62E00AC521D8435` FOREIGN KEY (`siteID`) REFERENCES `Sites` (`siteID`);

--
-- Constraints for table `CollectionAttributeKeys`
--
ALTER TABLE `CollectionAttributeKeys`
  ADD CONSTRAINT `FK_1E3E5B79B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`) ON DELETE CASCADE;

--
-- Constraints for table `CollectionAttributeValues`
--
ALTER TABLE `CollectionAttributeValues`
  ADD CONSTRAINT `FK_BB9995FCA2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`),
  ADD CONSTRAINT `FK_BB9995FCB6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `CollectionSearchIndexAttributes`
--
ALTER TABLE `CollectionSearchIndexAttributes`
  ADD CONSTRAINT `FK_FD84E56FE5DADDAE` FOREIGN KEY (`cID`) REFERENCES `Collections` (`cID`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `ConversationMessageNotifications`
--
ALTER TABLE `ConversationMessageNotifications`
  ADD CONSTRAINT `FK_559DE1CBED024EFD` FOREIGN KEY (`nID`) REFERENCES `Notifications` (`nID`) ON DELETE CASCADE;

--
-- Constraints for table `ExpressAttributeKeys`
--
ALTER TABLE `ExpressAttributeKeys`
  ADD CONSTRAINT `FK_8C881F1B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_8C881F181257D5D` FOREIGN KEY (`entity_id`) REFERENCES `ExpressEntities` (`id`);

--
-- Constraints for table `ExpressEntities`
--
ALTER TABLE `ExpressEntities`
  ADD CONSTRAINT `FK_BC772AA6CE45CBB0` FOREIGN KEY (`pkgID`) REFERENCES `Packages` (`pkgID`),
  ADD CONSTRAINT `FK_BC772AA6547D6B2D` FOREIGN KEY (`default_view_form_id`) REFERENCES `ExpressForms` (`id`),
  ADD CONSTRAINT `FK_BC772AA6C7DEC56D` FOREIGN KEY (`default_edit_form_id`) REFERENCES `ExpressForms` (`id`);

--
-- Constraints for table `ExpressEntityAssociationEntries`
--
ALTER TABLE `ExpressEntityAssociationEntries`
  ADD CONSTRAINT `FK_9C2BB76CEFB9C8A5` FOREIGN KEY (`association_id`) REFERENCES `ExpressEntityEntryAssociations` (`id`),
  ADD CONSTRAINT `FK_9C2BB76C6DCB6296` FOREIGN KEY (`exEntryID`) REFERENCES `ExpressEntityEntries` (`exEntryID`);

--
-- Constraints for table `ExpressEntityAssociations`
--
ALTER TABLE `ExpressEntityAssociations`
  ADD CONSTRAINT `FK_98A0F796B5910F71` FOREIGN KEY (`target_entity_id`) REFERENCES `ExpressEntities` (`id`),
  ADD CONSTRAINT `FK_98A0F796E9BBEE93` FOREIGN KEY (`source_entity_id`) REFERENCES `ExpressEntities` (`id`);

--
-- Constraints for table `ExpressEntityEntries`
--
ALTER TABLE `ExpressEntityEntries`
  ADD CONSTRAINT `FK_B8AE3531AFC87D03` FOREIGN KEY (`exEntryEntityID`) REFERENCES `ExpressEntities` (`id`),
  ADD CONSTRAINT `FK_B8AE3531FD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`);

--
-- Constraints for table `ExpressEntityEntryAssociations`
--
ALTER TABLE `ExpressEntityEntryAssociations`
  ADD CONSTRAINT `FK_25B3A082EFB9C8A5` FOREIGN KEY (`association_id`) REFERENCES `ExpressEntityAssociations` (`id`),
  ADD CONSTRAINT `FK_25B3A0826DCB6296` FOREIGN KEY (`exEntryID`) REFERENCES `ExpressEntityEntries` (`exEntryID`);

--
-- Constraints for table `ExpressEntityEntryAttributeValues`
--
ALTER TABLE `ExpressEntityEntryAttributeValues`
  ADD CONSTRAINT `FK_6DB64154A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`),
  ADD CONSTRAINT `FK_6DB641546DCB6296` FOREIGN KEY (`exEntryID`) REFERENCES `ExpressEntityEntries` (`exEntryID`),
  ADD CONSTRAINT `FK_6DB64154B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `ExpressForm170ExpressSearchIndexAttributes`
--
ALTER TABLE `ExpressForm170ExpressSearchIndexAttributes`
  ADD CONSTRAINT `FK_722F0F0E6DCB6296` FOREIGN KEY (`exEntryID`) REFERENCES `ExpressEntityEntries` (`exEntryID`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `ExpressFormFieldSetAssociationControls`
--
ALTER TABLE `ExpressFormFieldSetAssociationControls`
  ADD CONSTRAINT `FK_E6DF21BBBF396750` FOREIGN KEY (`id`) REFERENCES `ExpressFormFieldSetControls` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_E6DF21BBEFB9C8A5` FOREIGN KEY (`association_id`) REFERENCES `ExpressEntityAssociations` (`id`);

--
-- Constraints for table `ExpressFormFieldSetAttributeKeyControls`
--
ALTER TABLE `ExpressFormFieldSetAttributeKeyControls`
  ADD CONSTRAINT `FK_8481F9D1BF396750` FOREIGN KEY (`id`) REFERENCES `ExpressFormFieldSetControls` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_8481F9D1B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `ExpressFormFieldSetAuthorControls`
--
ALTER TABLE `ExpressFormFieldSetAuthorControls`
  ADD CONSTRAINT `FK_CF378786BF396750` FOREIGN KEY (`id`) REFERENCES `ExpressFormFieldSetControls` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ExpressFormFieldSetControls`
--
ALTER TABLE `ExpressFormFieldSetControls`
  ADD CONSTRAINT `FK_E42868A43ABF811A` FOREIGN KEY (`field_set_id`) REFERENCES `ExpressFormFieldSets` (`id`);

--
-- Constraints for table `ExpressFormFieldSetPublicIdentifierControls`
--
ALTER TABLE `ExpressFormFieldSetPublicIdentifierControls`
  ADD CONSTRAINT `FK_67180C04BF396750` FOREIGN KEY (`id`) REFERENCES `ExpressFormFieldSetControls` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ExpressFormFieldSets`
--
ALTER TABLE `ExpressFormFieldSets`
  ADD CONSTRAINT `FK_A33BBBEC5FF69B7D` FOREIGN KEY (`form_id`) REFERENCES `ExpressForms` (`id`);

--
-- Constraints for table `ExpressFormFieldSetTextControls`
--
ALTER TABLE `ExpressFormFieldSetTextControls`
  ADD CONSTRAINT `FK_DB5A209ABF396750` FOREIGN KEY (`id`) REFERENCES `ExpressFormFieldSetControls` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ExpressForms`
--
ALTER TABLE `ExpressForms`
  ADD CONSTRAINT `FK_8D09031A81257D5D` FOREIGN KEY (`entity_id`) REFERENCES `ExpressEntities` (`id`);

--
-- Constraints for table `FileAttributeKeys`
--
ALTER TABLE `FileAttributeKeys`
  ADD CONSTRAINT `FK_BC5C7BBB6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`) ON DELETE CASCADE;

--
-- Constraints for table `FileAttributeValues`
--
ALTER TABLE `FileAttributeValues`
  ADD CONSTRAINT `FK_BBECEAA4A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`),
  ADD CONSTRAINT `FK_BBECEAA4B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `FileImageThumbnailTypeFileSets`
--
ALTER TABLE `FileImageThumbnailTypeFileSets`
  ADD CONSTRAINT `FK_BD75F88D480660E5` FOREIGN KEY (`ftfsThumbnailType`) REFERENCES `FileImageThumbnailTypes` (`ftTypeID`) ON DELETE CASCADE;

--
-- Constraints for table `Files`
--
ALTER TABLE `Files`
  ADD CONSTRAINT `FK_C7F46F5DB81D3903` FOREIGN KEY (`fslID`) REFERENCES `FileStorageLocations` (`fslID`),
  ADD CONSTRAINT `FK_C7F46F5DFD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`) ON DELETE SET NULL;

--
-- Constraints for table `FileSearchIndexAttributes`
--
ALTER TABLE `FileSearchIndexAttributes`
  ADD CONSTRAINT `FK_3A3A4845E3111F45` FOREIGN KEY (`fID`) REFERENCES `Files` (`fID`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `FileVersions`
--
ALTER TABLE `FileVersions`
  ADD CONSTRAINT `FK_D7B5A13AE3111F45` FOREIGN KEY (`fID`) REFERENCES `Files` (`fID`);

--
-- Constraints for table `FormSubmissionNotifications`
--
ALTER TABLE `FormSubmissionNotifications`
  ADD CONSTRAINT `FK_E7B6BE40ED024EFD` FOREIGN KEY (`nID`) REFERENCES `Notifications` (`nID`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_E7B6BE406DCB6296` FOREIGN KEY (`exEntryID`) REFERENCES `ExpressEntityEntries` (`exEntryID`) ON DELETE CASCADE;

--
-- Constraints for table `Geolocators`
--
ALTER TABLE `Geolocators`
  ADD CONSTRAINT `FK_83BB1614D5F6CC40` FOREIGN KEY (`glPackage`) REFERENCES `Packages` (`pkgID`) ON DELETE CASCADE;

--
-- Constraints for table `IpAccessControlCategories`
--
ALTER TABLE `IpAccessControlCategories`
  ADD CONSTRAINT `FK_D4A10062C908ED51` FOREIGN KEY (`iaccPackage`) REFERENCES `Packages` (`pkgID`) ON DELETE CASCADE;

--
-- Constraints for table `IpAccessControlEvents`
--
ALTER TABLE `IpAccessControlEvents`
  ADD CONSTRAINT `FK_6C004072B0C0DFA7` FOREIGN KEY (`iaceSite`) REFERENCES `Sites` (`siteID`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_6C004072E9480668` FOREIGN KEY (`iaceCategory`) REFERENCES `IpAccessControlCategories` (`iaccID`) ON DELETE CASCADE;

--
-- Constraints for table `IpAccessControlRanges`
--
ALTER TABLE `IpAccessControlRanges`
  ADD CONSTRAINT `FK_2B1AA65D62009435` FOREIGN KEY (`iacrSite`) REFERENCES `Sites` (`siteID`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_2B1AA65D21E929D0` FOREIGN KEY (`iacrCategory`) REFERENCES `IpAccessControlCategories` (`iaccID`) ON DELETE CASCADE;

--
-- Constraints for table `LegacyAttributeKeys`
--
ALTER TABLE `LegacyAttributeKeys`
  ADD CONSTRAINT `FK_740BA2BBB6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`) ON DELETE CASCADE;

--
-- Constraints for table `NotificationAlerts`
--
ALTER TABLE `NotificationAlerts`
  ADD CONSTRAINT `FK_E11C7408ED024EFD` FOREIGN KEY (`nID`) REFERENCES `Notifications` (`nID`),
  ADD CONSTRAINT `FK_E11C7408FD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`);

--
-- Constraints for table `OAuth2AccessToken`
--
ALTER TABLE `OAuth2AccessToken`
  ADD CONSTRAINT `FK_60D69F3FC7440455` FOREIGN KEY (`client`) REFERENCES `OAuth2Client` (`identifier`);

--
-- Constraints for table `OAuth2AuthCode`
--
ALTER TABLE `OAuth2AuthCode`
  ADD CONSTRAINT `FK_29D07B5C7440455` FOREIGN KEY (`client`) REFERENCES `OAuth2Client` (`identifier`);

--
-- Constraints for table `OAuth2RefreshToken`
--
ALTER TABLE `OAuth2RefreshToken`
  ADD CONSTRAINT `FK_A205CB8350A9822` FOREIGN KEY (`accessToken`) REFERENCES `OAuth2AccessToken` (`identifier`) ON DELETE SET NULL;

--
-- Constraints for table `PermissionAccessEntitySiteGroups`
--
ALTER TABLE `PermissionAccessEntitySiteGroups`
  ADD CONSTRAINT `FK_51122D554A62E0E4` FOREIGN KEY (`siteGID`) REFERENCES `SiteGroups` (`siteGID`);

--
-- Constraints for table `PrivateMessageNotifications`
--
ALTER TABLE `PrivateMessageNotifications`
  ADD CONSTRAINT `FK_1AB97592ED024EFD` FOREIGN KEY (`nID`) REFERENCES `Notifications` (`nID`) ON DELETE CASCADE;

--
-- Constraints for table `QueueMessages`
--
ALTER TABLE `QueueMessages`
  ADD CONSTRAINT `FK_7C04D76477B5BAE` FOREIGN KEY (`queue_id`) REFERENCES `Queues` (`queue_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `SiteAttributeKeys`
--
ALTER TABLE `SiteAttributeKeys`
  ADD CONSTRAINT `FK_63D1E182B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`) ON DELETE CASCADE;

--
-- Constraints for table `SiteAttributeValues`
--
ALTER TABLE `SiteAttributeValues`
  ADD CONSTRAINT `FK_67658AF7A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`),
  ADD CONSTRAINT `FK_67658AF7521D8435` FOREIGN KEY (`siteID`) REFERENCES `Sites` (`siteID`),
  ADD CONSTRAINT `FK_67658AF7B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `SiteDomains`
--
ALTER TABLE `SiteDomains`
  ADD CONSTRAINT `FK_4CC7400A521D8435` FOREIGN KEY (`siteID`) REFERENCES `Sites` (`siteID`);

--
-- Constraints for table `SiteGroupRelations`
--
ALTER TABLE `SiteGroupRelations`
  ADD CONSTRAINT `FK_DCBCDCA9521D8435` FOREIGN KEY (`siteID`) REFERENCES `Sites` (`siteID`),
  ADD CONSTRAINT `FK_DCBCDCA94A62E0E4` FOREIGN KEY (`siteGID`) REFERENCES `SiteGroups` (`siteGID`);

--
-- Constraints for table `SiteGroups`
--
ALTER TABLE `SiteGroups`
  ADD CONSTRAINT `FK_F6FE030FE9548DF7` FOREIGN KEY (`siteTypeID`) REFERENCES `SiteTypes` (`siteTypeID`);

--
-- Constraints for table `SiteLocales`
--
ALTER TABLE `SiteLocales`
  ADD CONSTRAINT `FK_2527AB2CF9431B4B` FOREIGN KEY (`siteTreeID`) REFERENCES `SiteTreeTrees` (`siteTreeID`),
  ADD CONSTRAINT `FK_2527AB2C521D8435` FOREIGN KEY (`siteID`) REFERENCES `Sites` (`siteID`);

--
-- Constraints for table `Sites`
--
ALTER TABLE `Sites`
  ADD CONSTRAINT `FK_7DC18567E9548DF7` FOREIGN KEY (`siteTypeID`) REFERENCES `SiteTypes` (`siteTypeID`);

--
-- Constraints for table `SiteSearchIndexAttributes`
--
ALTER TABLE `SiteSearchIndexAttributes`
  ADD CONSTRAINT `FK_3DD070B4521D8435` FOREIGN KEY (`siteID`) REFERENCES `Sites` (`siteID`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `SiteSkeletonLocales`
--
ALTER TABLE `SiteSkeletonLocales`
  ADD CONSTRAINT `FK_212DD202F9431B4B` FOREIGN KEY (`siteTreeID`) REFERENCES `SiteSkeletonTrees` (`siteTreeID`),
  ADD CONSTRAINT `FK_212DD202B579BD3E` FOREIGN KEY (`siteSkeletonID`) REFERENCES `SiteSkeletons` (`siteSkeletonID`);

--
-- Constraints for table `SiteSkeletons`
--
ALTER TABLE `SiteSkeletons`
  ADD CONSTRAINT `FK_D36AED98E9548DF7` FOREIGN KEY (`siteTypeID`) REFERENCES `SiteTypes` (`siteTypeID`);

--
-- Constraints for table `SiteSkeletonTrees`
--
ALTER TABLE `SiteSkeletonTrees`
  ADD CONSTRAINT `FK_550F784BF9431B4B` FOREIGN KEY (`siteTreeID`) REFERENCES `SiteTrees` (`siteTreeID`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_550F784B16B7EAF2` FOREIGN KEY (`skeletonLocaleID`) REFERENCES `SiteSkeletonLocales` (`skeletonLocaleID`),
  ADD CONSTRAINT `FK_550F784BE9548DF7` FOREIGN KEY (`siteTypeID`) REFERENCES `SiteTypes` (`siteTypeID`);

--
-- Constraints for table `SiteTreeTrees`
--
ALTER TABLE `SiteTreeTrees`
  ADD CONSTRAINT `FK_A4B9696EF9431B4B` FOREIGN KEY (`siteTreeID`) REFERENCES `SiteTrees` (`siteTreeID`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_A4B9696EACD624CD` FOREIGN KEY (`siteLocaleID`) REFERENCES `SiteLocales` (`siteLocaleID`);

--
-- Constraints for table `SiteTypeAttributeKeys`
--
ALTER TABLE `SiteTypeAttributeKeys`
  ADD CONSTRAINT `FK_26C73776B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`) ON DELETE CASCADE;

--
-- Constraints for table `SiteTypeAttributeValues`
--
ALTER TABLE `SiteTypeAttributeValues`
  ADD CONSTRAINT `FK_78059CB9A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`),
  ADD CONSTRAINT `FK_78059CB9B579BD3E` FOREIGN KEY (`siteSkeletonID`) REFERENCES `SiteSkeletons` (`siteSkeletonID`),
  ADD CONSTRAINT `FK_78059CB9B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`);

--
-- Constraints for table `SiteTypes`
--
ALTER TABLE `SiteTypes`
  ADD CONSTRAINT `FK_7CBFE975CE45CBB0` FOREIGN KEY (`pkgID`) REFERENCES `Packages` (`pkgID`);

--
-- Constraints for table `SocialLinks`
--
ALTER TABLE `SocialLinks`
  ADD CONSTRAINT `FK_84EBA2B4521D8435` FOREIGN KEY (`siteID`) REFERENCES `Sites` (`siteID`);

--
-- Constraints for table `UserAttributeKeys`
--
ALTER TABLE `UserAttributeKeys`
  ADD CONSTRAINT `FK_28970033B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`) ON DELETE CASCADE;

--
-- Constraints for table `UserAttributeValues`
--
ALTER TABLE `UserAttributeValues`
  ADD CONSTRAINT `FK_4DB68CA6A2A82A5D` FOREIGN KEY (`avID`) REFERENCES `AttributeValues` (`avID`),
  ADD CONSTRAINT `FK_4DB68CA6B6561A7E` FOREIGN KEY (`akID`) REFERENCES `AttributeKeys` (`akID`),
  ADD CONSTRAINT `FK_4DB68CA6FD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`);

--
-- Constraints for table `UserDeactivatedNotifications`
--
ALTER TABLE `UserDeactivatedNotifications`
  ADD CONSTRAINT `FK_ED5A1F9FED024EFD` FOREIGN KEY (`nID`) REFERENCES `Notifications` (`nID`) ON DELETE CASCADE;

--
-- Constraints for table `UserSearchIndexAttributes`
--
ALTER TABLE `UserSearchIndexAttributes`
  ADD CONSTRAINT `FK_74798B07FD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `UserSignupNotifications`
--
ALTER TABLE `UserSignupNotifications`
  ADD CONSTRAINT `FK_7FB1DF5BED024EFD` FOREIGN KEY (`nID`) REFERENCES `Notifications` (`nID`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_7FB1DF5B7B18287E` FOREIGN KEY (`usID`) REFERENCES `UserSignups` (`usID`);

--
-- Constraints for table `UserSignups`
--
ALTER TABLE `UserSignups`
  ADD CONSTRAINT `FK_FEB5D909D3564642` FOREIGN KEY (`createdBy`) REFERENCES `Users` (`uID`),
  ADD CONSTRAINT `FK_FEB5D909FD71026C` FOREIGN KEY (`uID`) REFERENCES `Users` (`uID`);

--
-- Constraints for table `WorkflowProgressNotifications`
--
ALTER TABLE `WorkflowProgressNotifications`
  ADD CONSTRAINT `FK_EC39CA81ED024EFD` FOREIGN KEY (`nID`) REFERENCES `Notifications` (`nID`) ON DELETE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
