
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `contao561`
--

-- --------------------------------------------------------

--
-- Table structure for table `altcha_challenges`
--

CREATE TABLE `altcha_challenges` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `challenge` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `expires` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `challenge` (`challenge`),
  KEY `expires` (`expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `rememberme_token`
--

CREATE TABLE `rememberme_token` (
  `series` varchar(88) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(88) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastUsed` datetime NOT NULL,
  `class` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `username` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`series`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_article`
--

CREATE TABLE `tl_article` (
  `showTeaser` tinyint(1) NOT NULL DEFAULT '0',
  `protected` tinyint(1) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pid` int unsigned NOT NULL DEFAULT '0',
  `sorting` int unsigned NOT NULL DEFAULT '0',
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `author` int unsigned NOT NULL DEFAULT '0',
  `inColumn` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'main',
  `teaserCssID` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `teaser` text COLLATE utf8mb4_unicode_ci,
  `printable` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `customTpl` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `groups` blob,
  `cssID` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `start` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `stop` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `tstamp` (`tstamp`),
  KEY `alias` (`alias`),
  KEY `pid_published_incolumn_start_stop` (`pid`,`published`,`inColumn`,`start`,`stop`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_calendar`
--

CREATE TABLE `tl_calendar` (
  `protected` tinyint(1) NOT NULL DEFAULT '0',
  `allowComments` tinyint(1) NOT NULL DEFAULT '0',
  `moderate` tinyint(1) NOT NULL DEFAULT '0',
  `bbcode` tinyint(1) NOT NULL DEFAULT '0',
  `requireLogin` tinyint(1) NOT NULL DEFAULT '0',
  `disableCaptcha` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `jumpTo` int unsigned NOT NULL DEFAULT '0',
  `groups` blob,
  `notify` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'notify_admin',
  `sortOrder` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'ascending',
  `perPage` smallint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `tstamp` (`tstamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_calendar_events`
--

CREATE TABLE `tl_calendar_events` (
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `addTime` tinyint(1) NOT NULL DEFAULT '0',
  `addImage` tinyint(1) NOT NULL DEFAULT '0',
  `overwriteMeta` tinyint(1) NOT NULL DEFAULT '0',
  `fullsize` tinyint(1) NOT NULL DEFAULT '0',
  `recurring` tinyint(1) NOT NULL DEFAULT '0',
  `addEnclosure` tinyint(1) NOT NULL DEFAULT '0',
  `target` tinyint(1) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `noComments` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pid` int unsigned NOT NULL DEFAULT '0',
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `author` int unsigned NOT NULL DEFAULT '0',
  `startTime` bigint DEFAULT NULL,
  `endTime` bigint DEFAULT NULL,
  `startDate` bigint DEFAULT NULL,
  `endDate` bigint DEFAULT NULL,
  `pageTitle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `robots` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci,
  `canonicalLink` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `location` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `teaser` text COLLATE utf8mb4_unicode_ci,
  `singleSRC` binary(16) DEFAULT NULL,
  `alt` text COLLATE utf8mb4_unicode_ci,
  `imageTitle` text COLLATE utf8mb4_unicode_ci,
  `size` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `imageUrl` text COLLATE utf8mb4_unicode_ci,
  `caption` text COLLATE utf8mb4_unicode_ci,
  `floating` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'above',
  `repeatEach` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `repeatEnd` int unsigned NOT NULL DEFAULT '0',
  `recurrences` smallint unsigned NOT NULL DEFAULT '0',
  `enclosure` blob,
  `source` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `linkText` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `jumpTo` int unsigned NOT NULL DEFAULT '0',
  `articleId` int unsigned NOT NULL DEFAULT '0',
  `url` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cssClass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `searchIndexer` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `start` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `stop` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `tstamp` (`tstamp`),
  KEY `alias` (`alias`),
  KEY `pid_published_featured_start_stop` (`pid`,`published`,`featured`,`start`,`stop`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_calendar_feed`
--

CREATE TABLE `tl_calendar_feed` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `language` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `calendars` blob,
  `format` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'rss',
  `source` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'source_teaser',
  `maxItems` smallint unsigned NOT NULL DEFAULT '25',
  `feedBase` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci,
  `imgSize` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `tstamp` (`tstamp`),
  KEY `alias` (`alias`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tl_comments`
--

CREATE TABLE `tl_comments` (
  `addReply` tinyint(1) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `notified` tinyint(1) NOT NULL DEFAULT '0',
  `notifiedReply` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `source` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `parent` int unsigned NOT NULL DEFAULT '0',
  `date` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `website` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `member` int unsigned NOT NULL DEFAULT '0',
  `comment` text COLLATE utf8mb4_unicode_ci,
  `author` int unsigned NOT NULL DEFAULT '0',
  `reply` text COLLATE utf8mb4_unicode_ci,
  `ip` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `published` (`published`),
  KEY `source_parent_published` (`source`,`parent`,`published`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_comments_notify`
--

CREATE TABLE `tl_comments_notify` (
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `source` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `parent` int unsigned NOT NULL DEFAULT '0',
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `url` varchar(2048) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `addedOn` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tokenRemove` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `tstamp` (`tstamp`),
  KEY `source_parent_active_email` (`source`,`parent`,`active`,`email`),
  KEY `tokenremove` (`tokenRemove`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_content`
--

CREATE TABLE `tl_content` (
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(64) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT 'text',
  `addImage` tinyint(1) NOT NULL DEFAULT '0',
  `showPreview` tinyint(1) NOT NULL DEFAULT '0',
  `inline` tinyint(1) NOT NULL DEFAULT '0',
  `overwriteMeta` tinyint(1) NOT NULL DEFAULT '0',
  `fullsize` tinyint(1) NOT NULL DEFAULT '0',
  `thead` tinyint(1) NOT NULL DEFAULT '0',
  `tfoot` tinyint(1) NOT NULL DEFAULT '0',
  `tleft` tinyint(1) NOT NULL DEFAULT '0',
  `sortable` tinyint(1) NOT NULL DEFAULT '0',
  `closeSections` tinyint(1) NOT NULL DEFAULT '0',
  `target` tinyint(1) NOT NULL DEFAULT '0',
  `overwriteLink` tinyint(1) NOT NULL DEFAULT '0',
  `useImage` tinyint(1) NOT NULL DEFAULT '0',
  `useHomeDir` tinyint(1) NOT NULL DEFAULT '0',
  `metaIgnore` tinyint(1) NOT NULL DEFAULT '0',
  `splashImage` tinyint(1) NOT NULL DEFAULT '0',
  `sliderContinuous` tinyint(1) NOT NULL DEFAULT '0',
  `protected` tinyint(1) NOT NULL DEFAULT '0',
  `jumpTo` int unsigned NOT NULL DEFAULT '0',
  `redirectBack` tinyint(1) NOT NULL DEFAULT '0',
  `autologin` tinyint(1) NOT NULL DEFAULT '0',
  `pwResetPage` int unsigned NOT NULL DEFAULT '0',
  `invisible` tinyint(1) NOT NULL DEFAULT '0',
  `com_moderate` tinyint(1) NOT NULL DEFAULT '0',
  `com_bbcode` tinyint(1) NOT NULL DEFAULT '0',
  `com_disableCaptcha` tinyint(1) NOT NULL DEFAULT '0',
  `com_requireLogin` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pid` int unsigned NOT NULL DEFAULT '0',
  `ptable` varchar(64) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT 'tl_article',
  `sorting` int unsigned NOT NULL DEFAULT '0',
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `headline` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'a:2:{s:5:"value";s:0:"";s:4:"unit";s:2:"h2";}',
  `sectionHeadline` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'a:2:{s:5:"value";s:0:"";s:4:"unit";s:2:"h2";}',
  `text` mediumtext COLLATE utf8mb4_unicode_ci,
  `singleSRC` binary(16) DEFAULT NULL,
  `alt` text COLLATE utf8mb4_unicode_ci,
  `imageTitle` text COLLATE utf8mb4_unicode_ci,
  `size` varchar(128) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `imageUrl` text COLLATE utf8mb4_unicode_ci,
  `caption` text COLLATE utf8mb4_unicode_ci,
  `floating` varchar(32) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT 'above',
  `html` mediumtext COLLATE utf8mb4_unicode_ci,
  `unfilteredHtml` mediumtext COLLATE utf8mb4_unicode_ci,
  `listtype` varchar(32) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `listitems` blob,
  `tableitems` mediumblob,
  `summary` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortIndex` smallint unsigned NOT NULL DEFAULT '0',
  `sortOrder` varchar(32) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT 'ascending',
  `mooHeadline` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `mooStyle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `mooClasses` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `highlight` varchar(32) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `markdownSource` varchar(12) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT 'sourceText',
  `code` text COLLATE utf8mb4_unicode_ci,
  `url` text COLLATE utf8mb4_unicode_ci,
  `titleText` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `linkTitle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `embed` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rel` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `multiSRC` blob,
  `perRow` smallint unsigned NOT NULL DEFAULT '4',
  `perPage` smallint unsigned NOT NULL DEFAULT '0',
  `numberOfItems` smallint unsigned NOT NULL DEFAULT '0',
  `sortBy` varchar(32) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `galleryTpl` varchar(64) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `customTpl` varchar(64) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `playerSRC` blob,
  `youtube` varchar(16) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `vimeo` varchar(64) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `posterSRC` binary(16) DEFAULT NULL,
  `playerSize` varchar(64) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `playerOptions` text COLLATE utf8mb4_unicode_ci,
  `playerStart` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `playerStop` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `playerTitle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `playerCaption` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `playerAspect` varchar(8) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `textTrackSRC` blob,
  `playerPreload` varchar(8) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `playerColor` varchar(6) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `youtubeOptions` text COLLATE utf8mb4_unicode_ci,
  `vimeoOptions` text COLLATE utf8mb4_unicode_ci,
  `sliderDelay` int unsigned NOT NULL DEFAULT '0',
  `sliderSpeed` int unsigned NOT NULL DEFAULT '300',
  `sliderStartSlide` smallint unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `cteAlias` int unsigned NOT NULL DEFAULT '0',
  `articleAlias` int unsigned NOT NULL DEFAULT '0',
  `article` int unsigned NOT NULL DEFAULT '0',
  `form` int unsigned NOT NULL DEFAULT '0',
  `module` int unsigned NOT NULL DEFAULT '0',
  `groups` blob,
  `cssID` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `start` varchar(10) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `stop` varchar(10) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `com_order` varchar(16) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT 'ascending',
  `com_perPage` smallint unsigned NOT NULL DEFAULT '0',
  `com_template` varchar(64) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `tstamp` (`tstamp`),
  KEY `ptable_pid_invisible_start_stop` (`ptable`,`pid`,`invisible`,`start`,`stop`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tl_crawl_queue`
--

CREATE TABLE `tl_crawl_queue` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `job_id` char(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uri` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `uri_hash` char(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `found_on` longtext COLLATE utf8mb4_unicode_ci,
  `level` smallint NOT NULL,
  `processed` tinyint(1) NOT NULL,
  `tags` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `job_id` (`job_id`),
  KEY `uri_hash` (`uri_hash`),
  KEY `processed` (`processed`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_cron_job`
--

CREATE TABLE `tl_cron_job` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastRun` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_faq`
--

CREATE TABLE `tl_faq` (
  `addImage` tinyint(1) NOT NULL DEFAULT '0',
  `overwriteMeta` tinyint(1) NOT NULL DEFAULT '0',
  `fullsize` tinyint(1) NOT NULL DEFAULT '0',
  `addEnclosure` tinyint(1) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `noComments` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pid` int unsigned NOT NULL DEFAULT '0',
  `sorting` int unsigned NOT NULL DEFAULT '0',
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `question` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `author` int unsigned NOT NULL DEFAULT '0',
  `answer` text COLLATE utf8mb4_unicode_ci,
  `pageTitle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `robots` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci,
  `singleSRC` binary(16) DEFAULT NULL,
  `alt` text COLLATE utf8mb4_unicode_ci,
  `imageTitle` text COLLATE utf8mb4_unicode_ci,
  `size` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `imageUrl` text COLLATE utf8mb4_unicode_ci,
  `caption` text COLLATE utf8mb4_unicode_ci,
  `floating` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'above',
  `enclosure` blob,
  `searchIndexer` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `pid_published` (`pid`,`published`),
  KEY `tstamp` (`tstamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_faq_category`
--

CREATE TABLE `tl_faq_category` (
  `allowComments` tinyint(1) NOT NULL DEFAULT '0',
  `moderate` tinyint(1) NOT NULL DEFAULT '0',
  `bbcode` tinyint(1) NOT NULL DEFAULT '0',
  `requireLogin` tinyint(1) NOT NULL DEFAULT '0',
  `disableCaptcha` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `headline` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `jumpTo` int unsigned NOT NULL DEFAULT '0',
  `notify` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'notify_admin',
  `sortOrder` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'ascending',
  `perPage` smallint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `tstamp` (`tstamp`),
  KEY `jumpto` (`jumpTo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_favorites`
--

CREATE TABLE `tl_favorites` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pid` int unsigned NOT NULL DEFAULT '0',
  `sorting` int unsigned NOT NULL DEFAULT '0',
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `user` int unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `url` varchar(1022) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `tstamp` (`tstamp`),
  KEY `pid_user` (`pid`,`user`),
  KEY `url` (`url`(768))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_files`
--

CREATE TABLE `tl_files` (
  `found` tinyint(1) NOT NULL DEFAULT '1',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pid` binary(16) DEFAULT NULL,
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `uuid` binary(16) DEFAULT NULL,
  `type` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(1022) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `extension` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lastModified` int unsigned DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `importantPartX` double unsigned NOT NULL DEFAULT '0',
  `importantPartY` double unsigned NOT NULL DEFAULT '0',
  `importantPartWidth` double unsigned NOT NULL DEFAULT '0',
  `importantPartHeight` double unsigned NOT NULL DEFAULT '0',
  `textTrackLanguage` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `textTrackType` varchar(12) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta` blob,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `pid` (`pid`),
  KEY `tstamp` (`tstamp`),
  KEY `path` (`path`(768)),
  KEY `extension` (`extension`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tl_form`
--

CREATE TABLE `tl_form` (
  `sendViaEmail` tinyint(1) NOT NULL DEFAULT '0',
  `skipEmpty` tinyint(1) NOT NULL DEFAULT '0',
  `storeValues` tinyint(1) NOT NULL DEFAULT '0',
  `novalidate` tinyint(1) NOT NULL DEFAULT '0',
  `ajax` tinyint(1) NOT NULL DEFAULT '0',
  `allowTags` tinyint(1) NOT NULL DEFAULT '0',
  `storeSession` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `jumpTo` int unsigned NOT NULL DEFAULT '0',
  `confirmation` text COLLATE utf8mb4_unicode_ci,
  `mailerTransport` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `recipient` varchar(1022) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `format` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'raw',
  `targetTable` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `customTpl` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `method` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'POST',
  `attributes` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `formID` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `tstamp` (`tstamp`),
  KEY `alias` (`alias`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_form_field`
--

CREATE TABLE `tl_form_field` (
  `type` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `mandatory` tinyint(1) NOT NULL DEFAULT '0',
  `multiple` tinyint(1) NOT NULL DEFAULT '0',
  `storeFile` tinyint(1) NOT NULL DEFAULT '0',
  `useHomeDir` tinyint(1) NOT NULL DEFAULT '0',
  `doNotOverwrite` tinyint(1) NOT NULL DEFAULT '0',
  `imageSubmit` tinyint(1) NOT NULL DEFAULT '0',
  `altchaHideLogo` tinyint(1) NOT NULL DEFAULT '0',
  `altchaHideFooter` tinyint(1) NOT NULL DEFAULT '0',
  `invisible` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pid` int unsigned NOT NULL DEFAULT '0',
  `sorting` int unsigned NOT NULL DEFAULT '0',
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `text` text COLLATE utf8mb4_unicode_ci,
  `html` text COLLATE utf8mb4_unicode_ci,
  `options` blob,
  `rgxp` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `placeholder` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `help` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `customRgxp` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `errorMsg` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `minlength` int unsigned NOT NULL DEFAULT '0',
  `maxlength` int unsigned NOT NULL DEFAULT '0',
  `maxImageWidth` int unsigned NOT NULL DEFAULT '0',
  `maxImageHeight` int unsigned NOT NULL DEFAULT '0',
  `minval` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `maxval` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `step` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `size` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'a:2:{i:0;i:4;i:1;i:40;}',
  `mSize` smallint unsigned NOT NULL DEFAULT '0',
  `extensions` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'jpg,jpeg,gif,png,pdf,doc,docx,xls,xlsx,ppt,pptx',
  `uploadFolder` binary(16) DEFAULT NULL,
  `class` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `accesskey` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `fSize` smallint unsigned NOT NULL DEFAULT '0',
  `customTpl` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slabel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `singleSRC` binary(16) DEFAULT NULL,
  `altchaAuto` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `autocomplete` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `pid_invisible` (`pid`,`invisible`),
  KEY `tstamp` (`tstamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_image_size`
--

CREATE TABLE `tl_image_size` (
  `skipIfDimensionsMatch` tinyint(1) NOT NULL DEFAULT '0',
  `lazyLoading` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pid` int unsigned NOT NULL DEFAULT '0',
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `name` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imageQuality` int DEFAULT NULL,
  `cssClass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `densities` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sizes` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `width` int DEFAULT NULL,
  `height` int DEFAULT NULL,
  `resizeMode` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `zoom` int DEFAULT NULL,
  `formats` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `preserveMetadata` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `preserveMetadataFields` blob,
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `tstamp` (`tstamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_image_size_item`
--

CREATE TABLE `tl_image_size_item` (
  `invisible` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pid` int unsigned NOT NULL DEFAULT '0',
  `sorting` int unsigned NOT NULL DEFAULT '0',
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `media` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `densities` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sizes` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `width` int DEFAULT NULL,
  `height` int DEFAULT NULL,
  `resizeMode` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `zoom` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `tstamp` (`tstamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_job`
--

CREATE TABLE `tl_job` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `pid` int unsigned NOT NULL DEFAULT '0',
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` int unsigned NOT NULL DEFAULT '0',
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `public` tinyint(1) NOT NULL DEFAULT '0',
  `jobData` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `uuid` (`uuid`),
  KEY `pid` (`pid`),
  KEY `tstamp` (`tstamp`),
  KEY `type` (`type`),
  KEY `owner` (`owner`),
  KEY `status` (`status`),
  KEY `public` (`public`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_layout`
--

CREATE TABLE `tl_layout` (
  `type` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `combineScripts` tinyint(1) NOT NULL DEFAULT '1',
  `minifyMarkup` tinyint(1) NOT NULL DEFAULT '1',
  `addJQuery` tinyint(1) NOT NULL DEFAULT '0',
  `addMooTools` tinyint(1) NOT NULL DEFAULT '0',
  `static` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pid` int unsigned NOT NULL DEFAULT '0',
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rows` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '2rwh',
  `headerHeight` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `footerHeight` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cols` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '2cll',
  `widthLeft` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `widthRight` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sections` blob,
  `framework` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'a:2:{i:0;s:10:"layout.css";i:1;s:14:"responsive.css";}',
  `external` blob,
  `modules` blob,
  `template` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lightboxSize` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `defaultImageDensities` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `viewport` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'width=device-width,initial-scale=1.0,shrink-to-fit=no',
  `titleTag` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cssClass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `onload` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `head` text COLLATE utf8mb4_unicode_ci,
  `jquery` text COLLATE utf8mb4_unicode_ci,
  `mootools` text COLLATE utf8mb4_unicode_ci,
  `analytics` text COLLATE utf8mb4_unicode_ci,
  `externalJs` blob,
  `scripts` text COLLATE utf8mb4_unicode_ci,
  `script` text COLLATE utf8mb4_unicode_ci,
  `width` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `align` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'center',
  `newsfeeds` blob,
  `calendarfeeds` blob,
  PRIMARY KEY (`id`),
  KEY `tstamp` (`tstamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_log`
--

CREATE TABLE `tl_log` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `source` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `action` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `text` text COLLATE utf8mb4_unicode_ci,
  `func` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `browser` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `uri` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `page` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `tstamp` (`tstamp`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_member`
--

CREATE TABLE `tl_member` (
  `login` tinyint(1) NOT NULL DEFAULT '0',
  `assignDir` tinyint(1) NOT NULL DEFAULT '0',
  `disable` tinyint(1) NOT NULL DEFAULT '0',
  `useTwoFactor` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `firstname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lastname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `dateOfBirth` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `gender` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `company` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `street` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `postal` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `city` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `country` varchar(6) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `phone` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `mobile` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `fax` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `website` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `groups` blob,
  `username` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `homeDir` binary(16) DEFAULT NULL,
  `start` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `stop` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `dateAdded` int unsigned NOT NULL DEFAULT '0',
  `lastLogin` int unsigned NOT NULL DEFAULT '0',
  `currentLogin` int unsigned NOT NULL DEFAULT '0',
  `session` blob,
  `secret` binary(128) DEFAULT NULL,
  `backupCodes` text COLLATE utf8mb4_unicode_ci,
  `trustedTokenVersion` int unsigned NOT NULL DEFAULT '0',
  `newsletter` blob,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  KEY `tstamp` (`tstamp`),
  KEY `email` (`email`),
  KEY `login_disable_start_stop` (`login`,`disable`,`start`,`stop`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tl_member_group`
--

CREATE TABLE `tl_member_group` (
  `redirect` tinyint(1) NOT NULL DEFAULT '0',
  `disable` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `jumpTo` int unsigned NOT NULL DEFAULT '0',
  `start` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `stop` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `tstamp` (`tstamp`),
  KEY `disable_start_stop` (`disable`,`start`,`stop`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_message_queue`
--

CREATE TABLE `tl_message_queue` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `body` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `headers` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue_name` varchar(190) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL,
  `available_at` datetime NOT NULL,
  `delivered_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_1E97E1ADFB7336F0` (`queue_name`),
  KEY `IDX_1E97E1ADE3BD61CE` (`available_at`),
  KEY `IDX_1E97E1AD16BA31DB` (`delivered_at`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_module`
--

CREATE TABLE `tl_module` (
  `hardLimit` tinyint(1) NOT NULL DEFAULT '0',
  `showProtected` tinyint(1) NOT NULL DEFAULT '0',
  `defineRoot` tinyint(1) NOT NULL DEFAULT '0',
  `showHidden` tinyint(1) NOT NULL DEFAULT '0',
  `autologin` tinyint(1) NOT NULL DEFAULT '0',
  `redirectBack` tinyint(1) NOT NULL DEFAULT '0',
  `reqFullAuth` tinyint(1) NOT NULL DEFAULT '0',
  `fuzzy` tinyint(1) NOT NULL DEFAULT '0',
  `loadFirst` tinyint(1) NOT NULL DEFAULT '0',
  `useCaption` tinyint(1) NOT NULL DEFAULT '0',
  `fullsize` tinyint(1) NOT NULL DEFAULT '0',
  `disableCaptcha` tinyint(1) NOT NULL DEFAULT '0',
  `reg_allowLogin` tinyint(1) NOT NULL DEFAULT '0',
  `reg_skipName` tinyint(1) NOT NULL DEFAULT '0',
  `reg_deleteDir` tinyint(1) NOT NULL DEFAULT '0',
  `reg_assignDir` tinyint(1) NOT NULL DEFAULT '0',
  `reg_activate` tinyint(1) NOT NULL DEFAULT '0',
  `protected` tinyint(1) NOT NULL DEFAULT '0',
  `news_showQuantity` tinyint(1) NOT NULL DEFAULT '0',
  `news_keepCanonical` tinyint(1) NOT NULL DEFAULT '0',
  `cal_noSpan` tinyint(1) NOT NULL DEFAULT '0',
  `cal_hideRunning` tinyint(1) NOT NULL DEFAULT '0',
  `cal_ignoreDynamic` tinyint(1) NOT NULL DEFAULT '0',
  `cal_showQuantity` tinyint(1) NOT NULL DEFAULT '0',
  `cal_keepCanonical` tinyint(1) NOT NULL DEFAULT '0',
  `nl_hideChannels` tinyint(1) NOT NULL DEFAULT '0',
  `com_moderate` tinyint(1) NOT NULL DEFAULT '0',
  `com_bbcode` tinyint(1) NOT NULL DEFAULT '0',
  `com_requireLogin` tinyint(1) NOT NULL DEFAULT '0',
  `com_disableCaptcha` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pid` int unsigned NOT NULL DEFAULT '0',
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `headline` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'a:2:{s:5:"value";s:0:"";s:4:"unit";s:2:"h2";}',
  `type` varchar(64) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT 'navigation',
  `ariaLabel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `levelOffset` smallint unsigned NOT NULL DEFAULT '0',
  `showLevel` smallint unsigned NOT NULL DEFAULT '0',
  `rootPage` int unsigned NOT NULL DEFAULT '0',
  `navigationTpl` varchar(64) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `customTpl` varchar(64) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `pages` blob,
  `customLabel` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `jumpTo` int unsigned NOT NULL DEFAULT '0',
  `overviewPage` int unsigned NOT NULL DEFAULT '0',
  `pwResetPage` int unsigned NOT NULL DEFAULT '0',
  `editable` blob,
  `memberTpl` varchar(64) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `form` int unsigned NOT NULL DEFAULT '0',
  `queryType` varchar(8) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT 'and',
  `contextLength` varchar(64) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `minKeywordLength` smallint unsigned NOT NULL DEFAULT '4',
  `perPage` smallint unsigned NOT NULL DEFAULT '0',
  `searchType` varchar(16) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT 'simple',
  `searchTpl` varchar(64) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `inColumn` varchar(32) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT 'main',
  `skipFirst` smallint unsigned NOT NULL DEFAULT '0',
  `singleSRC` binary(16) DEFAULT NULL,
  `imgSize` varchar(128) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `multiSRC` blob,
  `html` text COLLATE utf8mb4_unicode_ci,
  `unfilteredHtml` mediumtext COLLATE utf8mb4_unicode_ci,
  `rss_cache` int unsigned NOT NULL DEFAULT '3600',
  `rss_feed` text COLLATE utf8mb4_unicode_ci,
  `rss_template` varchar(64) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `numberOfItems` smallint unsigned NOT NULL DEFAULT '3',
  `reg_groups` blob,
  `reg_close` varchar(32) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `reg_homeDir` binary(16) DEFAULT NULL,
  `reg_jumpTo` int unsigned NOT NULL DEFAULT '0',
  `reg_text` text COLLATE utf8mb4_unicode_ci,
  `reg_password` text COLLATE utf8mb4_unicode_ci,
  `data` text COLLATE utf8mb4_unicode_ci,
  `groups` blob,
  `cssID` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rootPageDependentModules` blob,
  `faq_categories` blob,
  `faq_readerModule` int unsigned NOT NULL DEFAULT '0',
  `news_archives` blob,
  `news_featured` varchar(16) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT 'all_items',
  `news_jumpToCurrent` varchar(16) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `news_readerModule` int unsigned NOT NULL DEFAULT '0',
  `news_template` varchar(64) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `news_format` varchar(32) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT 'news_month',
  `news_startDay` smallint unsigned NOT NULL DEFAULT '0',
  `news_order` varchar(32) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT 'order_date_desc',
  `list_table` varchar(64) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `list_fields` tinytext COLLATE utf8mb4_unicode_ci,
  `list_where` tinytext COLLATE utf8mb4_unicode_ci,
  `list_search` tinytext COLLATE utf8mb4_unicode_ci,
  `list_sort` tinytext COLLATE utf8mb4_unicode_ci,
  `list_info` tinytext COLLATE utf8mb4_unicode_ci,
  `list_info_where` tinytext COLLATE utf8mb4_unicode_ci,
  `list_layout` varchar(64) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `list_info_layout` varchar(64) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `cal_calendar` blob,
  `cal_startDay` smallint unsigned NOT NULL DEFAULT '1',
  `cal_format` varchar(32) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT 'cal_month',
  `cal_order` varchar(16) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT 'ascending',
  `cal_readerModule` int unsigned NOT NULL DEFAULT '0',
  `cal_limit` smallint unsigned NOT NULL DEFAULT '0',
  `cal_template` varchar(64) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `cal_ctemplate` varchar(64) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `cal_featured` varchar(16) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT 'all_items',
  `newsletters` blob,
  `nl_channels` blob,
  `nl_text` text COLLATE utf8mb4_unicode_ci,
  `nl_subscribe` text COLLATE utf8mb4_unicode_ci,
  `nl_unsubscribe` text COLLATE utf8mb4_unicode_ci,
  `nl_template` varchar(64) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `com_order` varchar(16) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT 'ascending',
  `com_template` varchar(64) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `tstamp` (`tstamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_news`
--

CREATE TABLE `tl_news` (
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `addImage` tinyint(1) NOT NULL DEFAULT '0',
  `overwriteMeta` tinyint(1) NOT NULL DEFAULT '0',
  `fullsize` tinyint(1) NOT NULL DEFAULT '0',
  `addEnclosure` tinyint(1) NOT NULL DEFAULT '0',
  `target` tinyint(1) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `noComments` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pid` int unsigned NOT NULL DEFAULT '0',
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `headline` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `author` int unsigned NOT NULL DEFAULT '0',
  `date` int unsigned NOT NULL DEFAULT '0',
  `time` int NOT NULL DEFAULT '0',
  `pageTitle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `robots` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci,
  `canonicalLink` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `subheadline` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `teaser` text COLLATE utf8mb4_unicode_ci,
  `singleSRC` binary(16) DEFAULT NULL,
  `alt` text COLLATE utf8mb4_unicode_ci,
  `imageTitle` text COLLATE utf8mb4_unicode_ci,
  `size` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `imageUrl` text COLLATE utf8mb4_unicode_ci,
  `caption` text COLLATE utf8mb4_unicode_ci,
  `floating` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'above',
  `enclosure` blob,
  `source` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `linkText` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `jumpTo` int unsigned NOT NULL DEFAULT '0',
  `articleId` int unsigned NOT NULL DEFAULT '0',
  `url` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cssClass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `searchIndexer` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `start` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `stop` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `tstamp` (`tstamp`),
  KEY `alias` (`alias`),
  KEY `pid_published_featured_start_stop` (`pid`,`published`,`featured`,`start`,`stop`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_newsletter`
--

CREATE TABLE `tl_newsletter` (
  `addFile` tinyint(1) NOT NULL DEFAULT '0',
  `sendText` tinyint(1) NOT NULL DEFAULT '0',
  `externalImages` tinyint(1) NOT NULL DEFAULT '0',
  `sent` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pid` int unsigned NOT NULL DEFAULT '0',
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `preheader` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` mediumtext COLLATE utf8mb4_unicode_ci,
  `text` mediumtext COLLATE utf8mb4_unicode_ci,
  `files` blob,
  `template` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `mailerTransport` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sender` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `senderName` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `date` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `tstamp` (`tstamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_newsletter_channel`
--

CREATE TABLE `tl_newsletter_channel` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `jumpTo` int unsigned NOT NULL DEFAULT '0',
  `template` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `mailerTransport` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sender` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `senderName` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `tstamp` (`tstamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_newsletter_deny_list`
--

CREATE TABLE `tl_newsletter_deny_list` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pid` int unsigned NOT NULL DEFAULT '0',
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pid_hash` (`pid`,`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_newsletter_recipients`
--

CREATE TABLE `tl_newsletter_recipients` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pid` int unsigned NOT NULL DEFAULT '0',
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `addedOn` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `pid_email` (`pid`,`email`),
  KEY `tstamp` (`tstamp`),
  KEY `email` (`email`),
  KEY `active` (`active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_news_archive`
--

CREATE TABLE `tl_news_archive` (
  `protected` tinyint(1) NOT NULL DEFAULT '0',
  `allowComments` tinyint(1) NOT NULL DEFAULT '0',
  `moderate` tinyint(1) NOT NULL DEFAULT '0',
  `bbcode` tinyint(1) NOT NULL DEFAULT '0',
  `requireLogin` tinyint(1) NOT NULL DEFAULT '0',
  `disableCaptcha` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `jumpTo` int unsigned NOT NULL DEFAULT '0',
  `groups` blob,
  `notify` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'notify_admin',
  `sortOrder` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'ascending',
  `perPage` smallint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `tstamp` (`tstamp`),
  KEY `jumpto` (`jumpTo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_opt_in`
--

CREATE TABLE `tl_opt_in` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `token` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `createdOn` int unsigned NOT NULL DEFAULT '0',
  `confirmedOn` int unsigned NOT NULL DEFAULT '0',
  `removeOn` int unsigned NOT NULL DEFAULT '0',
  `invalidatedThrough` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `emailSubject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `emailText` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `token` (`token`),
  KEY `tstamp` (`tstamp`),
  KEY `removeon` (`removeOn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_opt_in_related`
--

CREATE TABLE `tl_opt_in_related` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pid` int unsigned NOT NULL DEFAULT '0',
  `relTable` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `relId` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `reltable_relid` (`relTable`,`relId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_page`
--

CREATE TABLE `tl_page` (
  `requireItem` tinyint(1) NOT NULL DEFAULT '0',
  `alwaysForward` tinyint(1) NOT NULL DEFAULT '0',
  `redirectBack` tinyint(1) NOT NULL DEFAULT '0',
  `target` tinyint(1) NOT NULL DEFAULT '0',
  `fallback` tinyint(1) NOT NULL DEFAULT '0',
  `disableLanguageRedirect` tinyint(1) NOT NULL DEFAULT '0',
  `maintenanceMode` tinyint(1) NOT NULL DEFAULT '0',
  `enableCanonical` tinyint(1) NOT NULL DEFAULT '0',
  `useFolderUrl` tinyint(1) NOT NULL DEFAULT '0',
  `useSSL` tinyint(1) NOT NULL DEFAULT '1',
  `autoforward` tinyint(1) NOT NULL DEFAULT '0',
  `protected` tinyint(1) NOT NULL DEFAULT '0',
  `includeLayout` tinyint(1) NOT NULL DEFAULT '0',
  `includeCache` tinyint(1) NOT NULL DEFAULT '0',
  `alwaysLoadFromCache` tinyint(1) NOT NULL DEFAULT '0',
  `includeChmod` tinyint(1) NOT NULL DEFAULT '0',
  `hide` tinyint(1) NOT NULL DEFAULT '0',
  `guests` tinyint(1) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `enforceTwoFactor` tinyint(1) NOT NULL DEFAULT '0',
  `enableCsp` tinyint(1) NOT NULL DEFAULT '0',
  `csp` longtext COLLATE utf8mb4_unicode_ci,
  `cspReportOnly` tinyint(1) NOT NULL DEFAULT '0',
  `cspReportLog` tinyint(1) NOT NULL DEFAULT '0',
  `feedSource` varchar(32) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT 'source_teaser',
  `feedFeatured` varchar(16) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT 'all_items',
  `eventCalendars` blob,
  `feedRecurrenceLimit` smallint unsigned NOT NULL DEFAULT '25',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pid` int unsigned NOT NULL DEFAULT '0',
  `sorting` int unsigned NOT NULL DEFAULT '0',
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'regular',
  `alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `routePriority` int NOT NULL DEFAULT '0',
  `pageTitle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `robots` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci,
  `redirect` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'permanent',
  `jumpTo` int unsigned NOT NULL DEFAULT '0',
  `url` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `dns` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `staticFiles` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `staticPlugins` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `favicon` binary(16) DEFAULT NULL,
  `robotsTxt` text COLLATE utf8mb4_unicode_ci,
  `mailerTransport` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `canonicalLink` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `canonicalKeepParams` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `adminEmail` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `dateFormat` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timeFormat` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `datimFormat` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `validAliasCharacters` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `urlPrefix` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `urlSuffix` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `groups` blob,
  `layout` int unsigned NOT NULL DEFAULT '0',
  `subpageLayout` int unsigned NOT NULL DEFAULT '0',
  `cache` int unsigned NOT NULL DEFAULT '0',
  `clientCache` int unsigned NOT NULL DEFAULT '0',
  `cuser` int unsigned NOT NULL DEFAULT '0',
  `cgroup` int unsigned NOT NULL DEFAULT '0',
  `chmod` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cssClass` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sitemap` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `searchIndexer` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `accesskey` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `start` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `stop` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `twoFactorJumpTo` int unsigned NOT NULL DEFAULT '0',
  `feedFormat` varchar(32) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT 'rss',
  `maxFeedItems` smallint unsigned NOT NULL DEFAULT '25',
  `feedDescription` text COLLATE utf8mb4_unicode_ci,
  `imgSize` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `newsArchives` blob,
  PRIMARY KEY (`id`),
  KEY `tstamp` (`tstamp`),
  KEY `alias` (`alias`),
  KEY `type_dns_fallback_published_start_stop` (`type`,`dns`,`fallback`,`published`,`start`,`stop`),
  KEY `pid_published_type_start_stop` (`pid`,`published`,`type`,`start`,`stop`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_preview_link`
--

CREATE TABLE `tl_preview_link` (
  `showUnpublished` tinyint(1) NOT NULL DEFAULT '0',
  `restrictToUrl` tinyint(1) NOT NULL DEFAULT '1',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `url` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `createdAt` int unsigned NOT NULL DEFAULT '0',
  `expiresAt` int unsigned NOT NULL DEFAULT '0',
  `createdBy` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `tstamp` (`tstamp`),
  KEY `id_published_expiresat` (`id`,`published`,`expiresAt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_search`
--

CREATE TABLE `tl_search` (
  `protected` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pid` int unsigned NOT NULL DEFAULT '0',
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `title` text COLLATE utf8mb4_unicode_ci,
  `url` varchar(2048) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '',
  `text` mediumtext COLLATE utf8mb4_unicode_ci,
  `filesize` double NOT NULL DEFAULT '0',
  `checksum` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `groups` blob,
  `language` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `vectorLength` double NOT NULL DEFAULT '0',
  `meta` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `url` (`url`),
  UNIQUE KEY `pid_checksum` (`pid`,`checksum`),
  KEY `tstamp` (`tstamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_search_index`
--

CREATE TABLE `tl_search_index` (
  `pid` int unsigned NOT NULL,
  `termId` int unsigned NOT NULL,
  `relevance` smallint unsigned NOT NULL,
  PRIMARY KEY (`termId`,`pid`),
  KEY `pid` (`pid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_search_term`
--

CREATE TABLE `tl_search_term` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `term` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `documentFrequency` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `term` (`term`),
  KEY `documentfrequency` (`documentFrequency`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_theme`
--

CREATE TABLE `tl_theme` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `author` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `folders` blob,
  `screenshot` binary(16) DEFAULT NULL,
  `templates` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `tstamp` (`tstamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_trusted_device`
--

CREATE TABLE `tl_trusted_device` (
  `id` int NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `userClass` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `userId` int DEFAULT NULL,
  `user_agent` longtext COLLATE utf8mb4_unicode_ci,
  `ua_family` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `os_family` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `device_family` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_undo`
--

CREATE TABLE `tl_undo` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pid` int unsigned NOT NULL DEFAULT '0',
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `fromTable` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `query` text COLLATE utf8mb4_unicode_ci,
  `affectedRows` smallint unsigned NOT NULL DEFAULT '0',
  `data` mediumblob,
  `preview` mediumblob,
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `tstamp` (`tstamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_user`
--

CREATE TABLE `tl_user` (
  `showHelp` tinyint(1) NOT NULL DEFAULT '1',
  `thumbnails` tinyint(1) NOT NULL DEFAULT '1',
  `useRTE` tinyint(1) NOT NULL DEFAULT '1',
  `useCE` tinyint(1) NOT NULL DEFAULT '1',
  `doNotCollapse` tinyint(1) NOT NULL DEFAULT '0',
  `doNotHideMessages` tinyint(1) NOT NULL DEFAULT '0',
  `pwChange` tinyint(1) NOT NULL DEFAULT '0',
  `admin` tinyint(1) NOT NULL DEFAULT '0',
  `disable` tinyint(1) NOT NULL DEFAULT '0',
  `session` mediumblob,
  `useTwoFactor` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `username` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `backendTheme` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `uploader` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `groups` blob,
  `inherit` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'group',
  `modules` blob,
  `themes` blob,
  `elements` blob,
  `fields` blob,
  `frontendModules` blob,
  `pagemounts` blob,
  `alpty` blob,
  `filemounts` blob,
  `fop` blob,
  `imageSizes` blob,
  `forms` blob,
  `formp` blob,
  `amg` blob,
  `start` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `stop` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `dateAdded` int unsigned NOT NULL DEFAULT '0',
  `secret` binary(128) DEFAULT NULL,
  `lastLogin` int unsigned NOT NULL DEFAULT '0',
  `currentLogin` int unsigned NOT NULL DEFAULT '0',
  `backupCodes` text COLLATE utf8mb4_unicode_ci,
  `trustedTokenVersion` int unsigned NOT NULL DEFAULT '0',
  `faqs` blob,
  `faqp` blob,
  `news` blob,
  `newp` blob,
  `calendars` blob,
  `calendarp` blob,
  `calendarfeeds` blob,
  `calendarfeedp` blob,
  `newsletters` blob,
  `newsletterp` blob,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  KEY `tstamp` (`tstamp`),
  KEY `email` (`email`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `tl_user`
--

INSERT INTO `tl_user` VALUES
(1, 1, 1, 1, 0, 0, 0, 1, 0, NULL, 0, 1, [[timestamp]], '[[admin_username]]', '[[real_name]]', '[[admin_email]]', 'en', 'flexible', '', '[[admin_pass]]', NULL, 'group', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '', [[timestamp]], NULL, 0, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tl_user_group`
--

CREATE TABLE `tl_user_group` (
  `disable` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modules` blob,
  `themes` blob,
  `elements` blob,
  `fields` blob,
  `frontendModules` blob,
  `pagemounts` blob,
  `alpty` blob,
  `filemounts` blob,
  `fop` blob,
  `imageSizes` blob,
  `forms` blob,
  `formp` blob,
  `amg` blob,
  `alexf` blob,
  `start` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `stop` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `faqs` blob,
  `faqp` blob,
  `news` blob,
  `newp` blob,
  `calendars` blob,
  `calendarp` blob,
  `calendarfeeds` blob,
  `calendarfeedp` blob,
  `newsletters` blob,
  `newsletterp` blob,
  PRIMARY KEY (`id`),
  KEY `tstamp` (`tstamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `tl_version`
--

CREATE TABLE `tl_version` (
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pid` int unsigned NOT NULL DEFAULT '0',
  `tstamp` int unsigned NOT NULL DEFAULT '0',
  `version` smallint unsigned NOT NULL DEFAULT '1',
  `fromTable` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `userid` int unsigned NOT NULL DEFAULT '0',
  `username` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `editUrl` text COLLATE utf8mb4_unicode_ci,
  `data` mediumblob,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pid_fromtable_version` (`pid`,`fromTable`,`version`),
  KEY `tstamp` (`tstamp`),
  KEY `userid` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

-- --------------------------------------------------------

--
-- Table structure for table `webauthn_credentials`
--

CREATE TABLE `webauthn_credentials` (
  `publicKeyCredentialId` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transports` json NOT NULL,
  `attestationType` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trustPath` json NOT NULL,
  `aaguid` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `credentialPublicKey` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `userHandle` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `counter` int NOT NULL,
  `otherUI` json DEFAULT NULL,
  `backupEligible` tinyint(1) DEFAULT NULL,
  `backupStatus` tinyint(1) DEFAULT NULL,
  `uvInitialized` tinyint(1) DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `createdAt` datetime NOT NULL,
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
