<?php

error_reporting(-1);

if (function_exists('ini_set')) {
    @ini_set('display_errors', 1);
    @ini_set('display_startup_errors', 1);
    @ini_set('opcache.enable_cli', '0');

    if (isset($_GET['opcache_reset']) && $_GET['opcache_reset'] === md5(Phar::running(false))) {
        $GLOBALS['opcacheEnabled'] = @ini_get('opcache.enable');
    } else {
        $GLOBALS['opcacheEnabled'] = @ini_set('opcache.enable', '0');
    }
}

if (PHP_VERSION_ID < 50509) {
    die('You are using PHP '.PHP_VERSION." but you need least PHP 5.5.9 to run the Contao Manager.\n");
}

if (!extension_loaded('Phar')) {
    echo 'PHP\'s phar extension is missing. Contao Manager requires it to run. Enable the extension or recompile php without --disable-phar then try again.' . PHP_EOL;
    exit(1);
}

if (('cli' === PHP_SAPI || !isset($_SERVER['REQUEST_URI'])) && isset($_SERVER['argv'][1]) && 'test' === $_SERVER['argv'][1]) {
    die(json_encode(['version' => PHP_VERSION, 'version_id' => PHP_VERSION_ID, 'sapi' => PHP_SAPI]));
}

if (PHP_VERSION_ID < 80100) {
    Phar::mapPhar('contao-manager.phar');
    @include 'phar://contao-manager.phar/downgrade.php';
    die('<script>setTimeout(function() { window.location.reload(true) }, 1000)</script>');
}

if (function_exists('date_default_timezone_set') && function_exists('date_default_timezone_get')) {
    date_default_timezone_set(@date_default_timezone_get());
}

if ('cli' === PHP_SAPI || !isset($_SERVER['REQUEST_URI'])) {
    Phar::mapPhar('contao-manager.phar');
    require 'phar://contao-manager.phar/api/console';
} else {
    function rewrites()
    {
        // The function argument is unreliable across servers, Nginx for example is always empty
        list(,$url) = explode(basename(__FILE__), $_SERVER['REQUEST_URI'], 2);

        if (strpos($url, '..')) {
            return false;
        }

        if ('' === $url) {
            header('Location: /'.basename(__FILE__).'/');
            exit;
        }

        if (0 === strpos($url, '/api/')) {
            return '/dist/api.php'.$url;
        }

        if (!empty($url) && is_file('phar://'.__FILE__.'/dist'.$url)) {
            return '/dist'.$url;
        }

        return '/dist/index.html';
    }

    Phar::webPhar(
        null,
        'index.html',
        null,
        array(
            'log' => 'text/plain',
            'txt' => 'text/plain',
            'php' => Phar::PHP, // parse as PHP
            'css' => 'text/css',
            'gif' => 'image/gif',
            'html' => 'text/html',
            'ico' => 'image/x-ico',
            'jpg' => 'image/jpeg',
            'jpeg' => 'image/jpeg',
            'js' => 'application/x-javascript',
            'png' => 'image/png',
            'svg' => 'image/svg+xml',
            'json' => 'application/json'
        ),
        'rewrites'
    );
}

__HALT_COMPILER(); ?>
*                  .box/bin/check-requirements.php  տh  ^ʨ         .box/.requirements.phpY  տhY  BN﫤         .box/vendor/autoload.php   տh   s      ,   .box/vendor/composer/autoload_namespaces.php   տh   t!פ         .box/vendor/composer/LICENSE.  տh.         $   .box/vendor/composer/ClassLoader.php>  տh>  5Ky      &   .box/vendor/composer/autoload_psr4.php6  տh6   0Ӥ      *   .box/vendor/composer/autoload_classmap.php,
  տh,
  ӽǤ      (   .box/vendor/composer/autoload_static.phpK  տhK  ?      &   .box/vendor/composer/autoload_real.php   տh   yi\      .   .box/vendor/composer/semver/src/Comparator.phpu  տhu  	74      *   .box/vendor/composer/semver/src/Semver.php  տh  ׯ      1   .box/vendor/composer/semver/src/VersionParser.php9  տh9  Wz      B   .box/vendor/composer/semver/src/Constraint/ConstraintInterface.php  տh  wQ      >   .box/vendor/composer/semver/src/Constraint/MultiConstraint.php~  տh~  5[e      9   .box/vendor/composer/semver/src/Constraint/Constraint.php'&  տh'&  `         .box/src/Terminal.php
  տh
  %V         .box/src/IO.php   տh   [l%      !   .box/src/IsExtensionFulfilled.phpv  տhv  '0Ҥ         .box/src/Checker.php  տh  )W>      "   .box/src/IsPhpVersionFulfilled.php  տh  !83      "   .box/src/RequirementCollection.php  տh  Wb?         .box/src/Printer.php  տh  )8AV         .box/src/IsFulfilled.phpv   տhv   %*H         .box/src/Requirement.phpm  տhm  B         LICENSE  տh  p         dist/index.htmlH'  տhH'  t         dist/api.php--  տh  L|R         dist/css/367.25211792.cssl  տhl  A         dist/css/522.44f2aba0.cssO  տhO  o         dist/css/909.2589534e.css  տh           dist/css/317.eb3ccfd5.cssi?  տhi?  Wq         dist/css/335.e18cb2b2.css  տh  26&         dist/css/826.11002f25.css  տh  +         dist/css/380.93b3a21a.css0  տh0  	G         dist/css/904.3a60e65a.css  տh  i_Ӥ      #   dist/css/chunk-vendors.4e650cae.csss  տhs   -         dist/css/app.67f6747d.css  տh           dist/js/557.b97cda2f.js&  տh&  Ru/         dist/js/748.9a6e9b04.js/  տh/  @n4         dist/js/716.4e1e095d.js  տh  1         dist/js/194.08ec4754.js  տh  Τ         dist/js/317.fe6520b8.js  տh           dist/js/958.d76e2c65.jsS  տhS  CIsƤ         dist/js/120.a3871654.js  տh  v"         dist/js/28.f5c58fb6.jsw  տhw  Ig0         dist/js/523.a0c7916c.js  տh           dist/js/826.16ae7dac.js,  տh,  V[         dist/js/542.bf1113e7.jsN
  տhN
  EJˤ         dist/js/581.3865f2ba.js  տh  6         dist/js/551.b0e7412c.js  տh   g         dist/js/554.db2fd3db.jsB  տhB           dist/js/367.88e13716.js_
  տh_
  {         dist/js/140.22123c23.js=  տh=  3N         dist/js/638.e19fa914.jsJ  տhJ  Q7         dist/js/643.4050c25c.js  տh  UV|r         dist/js/706.c7bc29f3.jsܮ  տhܮ  `         dist/js/909.5cdd6208.js  տh  ﭤ         dist/js/335.01fdb510.jso
  տho
  Lޤ      !   dist/js/chunk-vendors.50ce20a0.jsS տhS          dist/js/180.197182e8.js&  տh&           dist/js/769.e5135861.js  տh  ^         dist/js/518.ffd48e14.js  տh  ?MD         dist/js/60.933bb34f.jsI"  տhI"  H[         dist/js/52.e0999c29.js  տh  |         dist/js/477.5a960d78.js  տh  ̤         dist/js/953.a276ff36.js  տh  IP         dist/js/721.94b06fd9.js1  տh1  ڬ
j         dist/js/851.498c84d6.jsq  տhq  X         dist/js/874.6efa795b.jsc  տhc  j5ͤ         dist/js/522.126103db.js
O  տh
O  i         dist/js/164.242532b7.jst  տht  c         dist/js/560.c80117fd.js  տh  Qv         dist/js/app.e04c574b.js տh Pe         dist/js/710.8322ed38.js| տh| 02         dist/js/139.a4efb68d.jsU  տhU  x0L6         dist/js/474.94df83ad.jsM  տhM           dist/js/486.1ff4679a.jsq  տhq  b
         dist/js/715.502ef477.js  տh  ꅤ         dist/js/540.68fcceec.js  տh  a         dist/js/219.bcc06aee.js  տh  q伤         dist/js/44.6b4b9d5f.jsx  տhx  $
oM         dist/js/553.9b87f585.jsP  տhP  M^         dist/js/669.20e6dd0f.js  տh           dist/js/904.b3a8fffa.js6  տh6  U         dist/js/606.03ea9631.jsҥ  տhҥ        !   dist/img/button-show.2336e1d9.svgS  տhS  U         dist/img/warning.9a7cd776.svg   տh   fh         dist/img/logo.d9707286.svg  տh  ;w          dist/img/button-add.759df12e.svg   տh   O
         dist/img/favers.056e2836.svgH  տhH  y,ͤ      #   dist/img/server-config.1a2d0888.svgg  տhg  RN      %   dist/img/button-database.5282fc7e.svg   տh   P      "   dist/img/symfony-logo.5c162c73.svg
  տh
  Os@      !   dist/img/button-link.dd42e161.svg   տh   ֖>      (   dist/img/button-maintenance.93830369.svgE  տhE  O      $   dist/img/create-project.b22522ee.svg   տh   ʅ      )   dist/img/button-incompatible.3eb2b686.svg  տh  /$      #   dist/img/document-root.0e6dd2e4.svg   տh   D      '   dist/img/search-by-algolia.72f0ac9a.svg  տh           dist/img/boot.92149bf5.svg   տh   So      #   dist/img/button-search.44ce1d4b.svgL  տhL  w         dist/img/oauth.1243e742.svg.  տh.  @
         dist/img/private.a1c65662.svg  տh  _50w      %   dist/img/button-download.e1ba6f25.svg1  տh1  O#         dist/img/person.00d78897.svg   տh   w*      )   dist/img/widget-checkbox--on.8b830157.svg   տh   #;      !   dist/img/button-lock.98988f08.svgc  տhc  5=6z      "   dist/img/button-check.7a3b5ada.svg   տh   ]R         dist/img/user.129e863d.svg   տh   cǤ         dist/img/offline.0c23d1ce.svg  տh  У-      $   dist/img/button-passkey.3806f98a.svg=  տh=  }      (   dist/img/symfony-logo--dark.ea265042.svg  տh  溤      #   dist/img/private--dark.41b90022.svg  տh  b      &   dist/img/button-cloud-off.dd8ba18e.svg  տh  ܡ<      "   dist/img/button-power.298a8072.svg6  տh6  Kb      %   dist/img/downloads--dark.034bf7a3.svg-  տh-  	Ǥ      "   dist/img/button-trash.855f57fa.svgt  տht  2}          dist/img/link-blank.eb57b3fa.svg   տh   f^      &   dist/img/button-clipboard.9ef63d39.svgJ  տhJ  v,N      '   dist/img/widget-radio--off.4e93f443.svg  տh           dist/img/task.e9e5333f.svg{  տh{  Jl      #   dist/img/button-update.ad79c617.svg\  տh\  Į         dist/img/hint.ba2ac97e.svg!  տh!        !   dist/img/button-hide.d23f6533.svg  տh  m3(         dist/img/database.7f0a8c49.svg  տh  <	         dist/img/updated.3b47bebb.svgH  տhH  ʦ      $   dist/img/language--dark.a24e849e.svgx  տhx  G7?      !   dist/img/button-save.3b5224de.svg  տh           dist/img/lock.3c42a55f.svgf  տhf  gG      $   dist/img/button-details.8ce780e9.svg  տh  `         dist/img/downloads.c1db2a9e.svg0  տh0  ¤      "   dist/img/color_scheme.d527d153.svg   տh   t         dist/img/recovery.70ee118a.svg   տh   OTM`      #   dist/img/button-upload.ca8e9cfc.svg3  տh3  0U      !   dist/img/button-edit.40a4be06.svg  տh  !.      &   dist/img/link-blank--dark.07eeaee6.svg   տh   B|         dist/img/funding.cf78a0a0.svgJ  տhJ  `1_      #   dist/img/button-unlock.51b76e07.svgi  տhi  
         dist/img/php-logo.7376e212.svg	  տh	  k9q      #   dist/img/updated--dark.c21fdd5b.svgE  տhE  Ey      "   dist/img/button-cloud.bc42f267.svg  տh  I[      "   dist/img/favers--dark.4765f7d4.svgE  տhE        !   dist/img/button-more.e3eb2622.svg  տh  v         dist/img/language.582b2920.svg{  տh{  tW      &   dist/img/widget-radio--on.181461b6.svg:  տh:  j
M      $   dist/img/button-console.05dcdfc4.svg   տh   >y      (   dist/img/color_scheme--dark.ef0f0aed.svg:  տh:  <      !   dist/img/button-gear.a2dc1f09.svg  տh  0         dist/img/sad.c7de6e95.svg5  տh5  h          dist/img/button-run.b6310c5a.svg  տh           dist/img/close.8b27dbcb.svg   տh   e      "   dist/img/link-funding.b25cd92d.svg  տh  PԤ      *   dist/img/widget-checkbox--off.73856538.svg   տh   ~      (   dist/icons/task-active/favicon-16x16.png3  տh3  K       "   dist/icons/task-active/favicon.ico:  տh:  8      (   dist/icons/task-active/favicon-32x32.pngF  տhF  )fx      '   dist/icons/task-error/favicon-16x16.png;  տh;        !   dist/icons/task-error/favicon.ico:  տh:  u      '   dist/icons/task-error/favicon-32x32.pngB  տhB        )   dist/icons/task-success/favicon-16x16.pngU  տhU  {ؤ      #   dist/icons/task-success/favicon.ico:  տh:  TIm      )   dist/icons/task-success/favicon-32x32.pngq  տhq  ?.         dist/api.php  տh  C¾         dist/assets/favicon-16x16.png  տh           dist/assets/mstile-310x310.png%  տh%  xH      &   dist/assets/android-chrome-384x384.png%  տh%  1|&      3   dist/assets/apple-touch-startup-image-1125x2436.png  տh  5      2   dist/assets/apple-touch-startup-image-1792x828.png  տh  8Q      2   dist/assets/apple-touch-startup-image-1334x750.png}y  տh}y  Դ         dist/assets/mstile-144x144.png  տh        3   dist/assets/apple-touch-startup-image-1290x2796.pngu  տhu  ^v         dist/assets/favicon.ico  տh  }*~      (   dist/assets/apple-touch-icon-120x120.png
  տh
        3   dist/assets/apple-touch-startup-image-2732x2048.png տh .uE      &   dist/assets/android-chrome-192x192.png3  տh3  '\          dist/assets/apple-touch-icon.png  տh  :5      3   dist/assets/apple-touch-startup-image-1242x2688.png&  տh&  :Pg      &   dist/assets/android-chrome-256x256.pngh  տhh  j't      3   dist/assets/apple-touch-startup-image-2436x1125.png  տh  5x         dist/assets/mstile-70x70.png  տh  eݺ=      2   dist/assets/apple-touch-startup-image-640x1136.pngP  տhP  n      3   dist/assets/apple-touch-startup-image-1170x2532.png@  տh@  ˨      *   dist/assets/apple-touch-icon-1024x1024.pngr|  տhr|  T      (   dist/assets/apple-touch-icon-152x152.png  տh  o      3   dist/assets/apple-touch-startup-image-1620x2160.pngb  տhb  RE      3   dist/assets/apple-touch-startup-image-1668x2388.png  տh  I      2   dist/assets/apple-touch-startup-image-828x1792.pngv  տhv  >H      3   dist/assets/apple-touch-startup-image-2048x1536.pngn տhn xEy      (   dist/assets/apple-touch-icon-180x180.png  տh  :5      (   dist/assets/yandex-browser-manifest.json   տh   p#Ȥ      3   dist/assets/apple-touch-startup-image-1640x2160.pngv  տhv  <o      3   dist/assets/apple-touch-startup-image-2224x1668.png+ տh+       3   dist/assets/apple-touch-startup-image-1179x2556.pngZ  տhZ           dist/assets/favicon-48x48.png  տh  .i         dist/assets/mstile-310x150.png  տh  ƒܤ      3   dist/assets/apple-touch-startup-image-1242x2208.pngٸ  տhٸ  &Nf      (   dist/assets/apple-touch-icon-114x114.pngR	  տhR	  M      &   dist/assets/apple-touch-icon-76x76.png)  տh)  b      &   dist/assets/android-chrome-512x512.pngL6  տhL6  x9      3   dist/assets/apple-touch-startup-image-2556x1179.png  տh  jW      2   dist/assets/apple-touch-startup-image-1136x640.pngd  տhd  %¤      3   dist/assets/apple-touch-startup-image-2532x1170.png  տh  Ҫ      3   dist/assets/apple-touch-startup-image-2208x1242.png  տh  PQ      3   dist/assets/apple-touch-startup-image-1488x2266.pngb  տhb  Wzۤ      &   dist/assets/apple-touch-icon-57x57.png  տh  1@      2   dist/assets/apple-touch-startup-image-750x1334.pnga  տha  ΃      3   dist/assets/apple-touch-startup-image-2266x1488.pngP տhP aФ      ,   dist/assets/apple-touch-icon-precomposed.png  տh  :5      3   dist/assets/apple-touch-startup-image-2160x1620.png" տh" A'      3   dist/assets/apple-touch-startup-image-1284x2778.pngh  տhh  eX:      3   dist/assets/apple-touch-startup-image-1668x2224.pngl  տhl  N      3   dist/assets/apple-touch-startup-image-2688x1242.png  տh  v      &   dist/assets/apple-touch-icon-72x72.png  տh  ^F W      3   dist/assets/apple-touch-startup-image-2778x1284.png  տh   Z      3   dist/assets/apple-touch-startup-image-1536x2048.pngW  տhW  q)ݤ      3   dist/assets/apple-touch-startup-image-2388x1668.png1 տh1 [3j         dist/assets/mstile-150x150.png  տh  	          dist/assets/manifest.webmanifest  տh  `l      3   dist/assets/apple-touch-startup-image-2796x1290.png  տh  3ق      $   dist/assets/android-chrome-36x36.png+  տh+        $   dist/assets/android-chrome-96x96.png  տh  l@w      (   dist/assets/apple-touch-icon-167x167.png
  տh
  dP      $   dist/assets/android-chrome-72x72.png  տh  hQ\      &   dist/assets/apple-touch-icon-60x60.png  տh        3   dist/assets/apple-touch-startup-image-2160x1640.pngV& տhV& 7E      3   dist/assets/apple-touch-startup-image-2048x2732.pngDE տhDE bpF      (   dist/assets/apple-touch-icon-144x144.png	  տh	  Np      $   dist/assets/yandex-browser-50x50.pngX  տhX  X         dist/assets/browserconfig.xmlr  տhr  v,      $   dist/assets/android-chrome-48x48.png  տh  .i         dist/assets/favicon-32x32.png  տh  ɹ      &   dist/assets/android-chrome-144x144.png  տh        %   api/HttpKernel/ApiProblemResponse.php	  տh	        
   api/console--A  տhA  C~Ƥ         api/Config/UploadsConfig.php9  տh9  Bɤ         api/Config/UserConfig.php%  տh%  bf         api/Config/ManagerConfig.php9  տh9  v         api/Config/AbstractConfig.phpk  տhk  L@         api/Config/ComposerConfig.php  տh  5[
         api/Config/PartialConfig.php  տh  +tŅ         api/Config/AuthConfig.php  տh  $Ĥ      *   api/Security/PasswordlessAuthenticator.php
  տh
  E&      &   api/Security/WebauthnAuthenticator.phpr)  տhr)  If      #   api/Security/TokenAuthenticator.php  տh  <U7      ,   api/Security/AuthenticationTrustResolver.php  տh  XG         api/Security/UserProvider.php  տh  &N}         api/Security/User.php/
  տh/
  [      !   api/Security/JwtAuthenticator.php	  տh	  %Ȥ      -   api/Security/AbstractBrowserAuthenticator.php  տh  ,         api/Security/TotpBadge.php;  տh;  lz      #   api/Security/LoginAuthenticator.php  տh  b         api/Security/JwtManager.php  տh        .   api/TaskOperation/Composer/RemoveOperation.php  տh  -8      2   api/TaskOperation/Composer/ClearCacheOperation.php  տh  [Ǥ      4   api/TaskOperation/Composer/DumpAutoloadOperation.php  տh        /   api/TaskOperation/Composer/InstallOperation.php  տh  Y      .   api/TaskOperation/Composer/UpdateOperation.php  տh        /   api/TaskOperation/Composer/RequireOperation.phpJ  տhJ        5   api/TaskOperation/Composer/CreateProjectOperation.php  տh  2F=      -   api/TaskOperation/Composer/CloudOperation.phpC9  տhC9  ]$      8   api/TaskOperation/Filesystem/InstallUploadsOperation.php  տh  *դ      9   api/TaskOperation/Filesystem/RemoveArtifactsOperation.php  տh  dm-      6   api/TaskOperation/Filesystem/RemoveVendorOperation.php  տh  Nx      7   api/TaskOperation/Filesystem/RemoveUploadsOperation.php  տh        5   api/TaskOperation/Filesystem/RemoveCacheOperation.php  տh  (٤      1   api/TaskOperation/Manager/SelfUpdateOperation.php  տh  3:      -   api/TaskOperation/AbstractInlineOperation.php
  տh
  \.      1   api/TaskOperation/SponsoredOperationInterface.php"  տh"  :      #   api/TaskOperation/ConsoleOutput.php?  տh?  Tv      .   api/TaskOperation/AbstractProcessOperation.phpK
  տhK
  KG      5   api/TaskOperation/Contao/MaintenanceModeOperation.phps  տhs  m6ͤ      2   api/TaskOperation/Contao/BackupCreateOperation.php<  տh<  w      1   api/TaskOperation/Contao/CacheWarmupOperation.phpX  տhX  hzۤ      2   api/TaskOperation/Contao/CreateContaoOperation.php  տh  g%+      3   api/TaskOperation/Contao/BackupRestoreOperation.php{  տh{  n<!      0   api/TaskOperation/Contao/CacheClearOperation.phpo  տho  n      ,   api/TaskOperation/TaskOperationInterface.php  տh  6         api/Composer/CloudResolver.phpM  տhM  ~2         api/Composer/CloudChanges.phpe  տhe  #l֤         api/Composer/CloudJob.php	  տh	  yP         api/Composer/CloudException.php  տh  ߬         api/Composer/Environment.php.  տh.        2   api/Resources/cache/url_generating_routes.php.meta!  տh!  Γ2      @   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.php  տh  1G      %   api/Resources/cache/serialization.phpx   տhx   [J      E   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.php.lock    տh              E   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.php.meta9y տh9y ?fޤ      T   api/Resources/cache/ContainerEdRFl8V/getSecurity_Firewall_Map_Context_ApiService.php\
  տh\
  0`      W   api/Resources/cache/ContainerEdRFl8V/getContainer_GetRoutingConditionServiceService.php  տh  
P9      F   api/Resources/cache/ContainerEdRFl8V/getComposerController2Service.php  տh  pFe      N   api/Resources/cache/ContainerEdRFl8V/getSecurity_UserCheckerLocatorService.php  տh  `5	      N   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_SecretsListService.php  տh  Q      P   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_SecretsRemoveService.php  տh  W      C   api/Resources/cache/ContainerEdRFl8V/getGraphicsLibCheckService.php  տh  ]PŤ      C   api/Resources/cache/ContainerEdRFl8V/getPhpCliControllerService.php  տh  !ܤ      Y   api/Resources/cache/ContainerEdRFl8V/getSecurity_Authenticator_ManagersLocatorService.php  տh  W@      D   api/Resources/cache/ContainerEdRFl8V/getTaskDeleteCommandService.php  տh  m      `   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_SecretsEncryptFromLocal_LazyService.php~  տh~  >      G   api/Resources/cache/ContainerEdRFl8V/getConstraintControllerService.php  տh        V   api/Resources/cache/ContainerEdRFl8V/getArgumentResolver_BackedEnumResolverService.php  տh        4   api/Resources/cache/ContainerEdRFl8V/removed-ids.phpI  տhI  D      G   api/Resources/cache/ContainerEdRFl8V/getProcessRunnerCommandService.php/  տh/  fˤ      C   api/Resources/cache/ContainerEdRFl8V/getJwtAuthenticatorService.php  տh  [B      C   api/Resources/cache/ContainerEdRFl8V/getContaoControllerService.php?  տh?  	N7      E   api/Resources/cache/ContainerEdRFl8V/getSecurity_AccessMapService.php*  տh*  _      H   api/Resources/cache/ContainerEdRFl8V/getIntegrityCheckFactoryService.php?  տh?  <^      Q   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_ContainerDebugService.php)  տh)        W   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_ContainerDebug_LazyService.php(  տh(  
      H   api/Resources/cache/ContainerEdRFl8V/getWebauthnAuthenticatorService.php	  տh	  lk{ݤ      F   api/Resources/cache/ContainerEdRFl8V/getJwtCookieControllerService.php:  տh:  }Τ      E   api/Resources/cache/ContainerEdRFl8V/getRouter_CacheWarmerService.phpu  տhu  <.      D   api/Resources/cache/ContainerEdRFl8V/getBackupRestoreTaskService.phpL  տhL  w{      H   api/Resources/cache/ContainerEdRFl8V/getConsole_CommandLoaderService.phpN'  տhN'  ľ
      <   api/Resources/cache/ContainerEdRFl8V/getCache_AppService.phpb  տhb  A      M   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_SecretsSetService.php  տh  Ent      T   api/Resources/cache/ContainerEdRFl8V/getSecurity_Command_UserPasswordHashService.php  տh        H   api/Resources/cache/ContainerEdRFl8V/getConsoleProcessFactoryService.phpd  տhd  
:Z      \   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_ConfigDumpReference_LazyService.php^  տh^  >&6      C   api/Resources/cache/ContainerEdRFl8V/getCache_AppClearerService.php  տh  H
v      A   api/Resources/cache/ContainerEdRFl8V/getUserControllerService.php  տh        N   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_RouterDebugService.php  տh  ǆ:u      Q   api/Resources/cache/ContainerEdRFl8V/Contao_ManagerApi_ApiKernelProdContainer.phpa  տha  (&ݤ      W   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_CachePoolPrune_LazyService.php  տh  +[      D   api/Resources/cache/ContainerEdRFl8V/getTaskUpdateCommandService.php  տh  hD3}      A   api/Resources/cache/ContainerEdRFl8V/getTaskControllerService.php  տh  )X      L   api/Resources/cache/ContainerEdRFl8V/getMaintenanceModeControllerService.php  տh  s      A   api/Resources/cache/ContainerEdRFl8V/getFileControllerService.php/  տh/  (Τ      J   api/Resources/cache/ContainerEdRFl8V/get_ServiceLocator_Y_Xs7MwService.phpT  տhT  Qn.      A   api/Resources/cache/ContainerEdRFl8V/getRouting_LoaderService.phpN
  տhN
  Iˤ      >   api/Resources/cache/ContainerEdRFl8V/getEnvironmentService.php  տh  j      T   api/Resources/cache/ContainerEdRFl8V/getSecurity_Listener_UserChecker_ApiService.php  տh  X3S      C   api/Resources/cache/ContainerEdRFl8V/getServicesResetterService.php~  տh~  Z      e   api/Resources/cache/ContainerEdRFl8V/getCache_SecurityIsGrantedAttributeExpressionLanguageService.php  տh  ̨7!      D   api/Resources/cache/ContainerEdRFl8V/getOpcacheControllerService.php  տh  Ĥ      P   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_AssetsInstallService.php  տh  
<C      Q   api/Resources/cache/ContainerEdRFl8V/getSerializer_Mapping_CacheWarmerService.php  տh        E   api/Resources/cache/ContainerEdRFl8V/getLoginAuthenticatorService.php  տh  	>Ѥ      O   api/Resources/cache/ContainerEdRFl8V/getSecurity_EventDispatcher_ApiService.php&  տh&  bE+}      ?   api/Resources/cache/ContainerEdRFl8V/getCache_SystemService.php  տh  e\      A   api/Resources/cache/ContainerEdRFl8V/getMonolog_LoggerService.php  տh  ud      X   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_CachePoolDelete_LazyService.php+  տh+  4      J   api/Resources/cache/ContainerEdRFl8V/getMonolog_Logger_SecurityService.php  տh  ;Ѕ      @   api/Resources/cache/ContainerEdRFl8V/getUpdateCommandService.php  տh  AO      Q   api/Resources/cache/ContainerEdRFl8V/getDebug_ErrorHandlerConfiguratorService.php\  տh\        I   api/Resources/cache/ContainerEdRFl8V/getTaskDeleteCommand_LazyService.php  տh  },      U   api/Resources/cache/ContainerEdRFl8V/getSecurity_Access_AuthenticatedVoterService.phpJ  տhJ  nU      ?   api/Resources/cache/ContainerEdRFl8V/getProcessCheckService.php
  տh
  Q7֤      D   api/Resources/cache/ContainerEdRFl8V/getSessionControllerService.php  տh  a3      V   api/Resources/cache/ContainerEdRFl8V/getSecurity_Listener_PasswordMigratingService.php$  տh$  d ?      A   api/Resources/cache/ContainerEdRFl8V/getSelfUpdateTaskService.php*  տh*  5      X   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_SerializerDebug_LazyService.php  տh  3      F   api/Resources/cache/ContainerEdRFl8V/getCache_GlobalClearerService.phpn  տhn  [HW      >   api/Resources/cache/ContainerEdRFl8V/getTaskManagerService.php  տh  O      H   api/Resources/cache/ContainerEdRFl8V/getConsole_ErrorListenerService.php  տh  |      K   api/Resources/cache/ContainerEdRFl8V/getUploadPackagesControllerService.php  տh  5
      <   api/Resources/cache/ContainerEdRFl8V/getContaoApiService.php^  տh^  	
      C   api/Resources/cache/ContainerEdRFl8V/getMemoryLimitCheckService.php  տh  H      W   api/Resources/cache/ContainerEdRFl8V/get_Security_Command_DebugFirewall_LazyService.php+  տh+  
+K      B   api/Resources/cache/ContainerEdRFl8V/getSysTempDirCheckService.php  տh  -פ      V   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_SecretsRemove_LazyService.php  տh  |+      _   api/Resources/cache/ContainerEdRFl8V/getArgumentResolver_QueryParameterValueResolverService.php  տh  .Ѥ      I   api/Resources/cache/ContainerEdRFl8V/getTaskUpdateCommand_LazyService.php  տh        C   api/Resources/cache/ContainerEdRFl8V/getConfigControllerService.php  տh  x      =   api/Resources/cache/ContainerEdRFl8V/getSelfUpdateService.php  տh  !>G      C   api/Resources/cache/ContainerEdRFl8V/getTaskAbortCommandService.php  տh  Z      @   api/Resources/cache/ContainerEdRFl8V/getCloudResolverService.php  տh  ^.)      ^   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_SecretsDecryptToLocal_LazyService.php|  տh|  ۤ      F   api/Resources/cache/ContainerEdRFl8V/getAccessKeyControllerService.php:  տh:  磾       S   api/Resources/cache/ContainerEdRFl8V/getPropertyInfo_SerializerExtractorService.php$  տh$  [      ?   api/Resources/cache/ContainerEdRFl8V/getUserProviderService.php  տh  -7<      C   api/Resources/cache/ContainerEdRFl8V/getPhpWebControllerService.phpJ  տhJ  Lҟ      D   api/Resources/cache/ContainerEdRFl8V/getAboutCommand_LazyService.php  տh         P   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_ContainerLintService.php<  տh<  .      N   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_About_LazyService.php  տh  Aw      T   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_RouterMatch_LazyService.php  տh        =   api/Resources/cache/ContainerEdRFl8V/getTranslatorService.php  տh  9      G   api/Resources/cache/ContainerEdRFl8V/getSelfUpdateControllerService.php  տh  nb      K   api/Resources/cache/ContainerEdRFl8V/getSecurity_ChannelListenerService.php  տh  K3      L   api/Resources/cache/ContainerEdRFl8V/getArgumentResolver_VariadicService.php  տh  ^1      D   api/Resources/cache/ContainerEdRFl8V/getManagerControllerService.php7  տh7  gҤ      C   api/Resources/cache/ContainerEdRFl8V/getBackupControllerService.php  տh  W      B   api/Resources/cache/ContainerEdRFl8V/getSecurity_HelperService.php;  տh;  $      Q   api/Resources/cache/ContainerEdRFl8V/getSecurity_Listener_UserProviderService.php  տh  統      Q   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_YamlLint_LazyService.php  տh  _&      @   api/Resources/cache/ContainerEdRFl8V/getSecrets_VaultService.phpE  տhE  2
      V   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_ConfigDumpReferenceService.phpN  տhN  d:      N   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_CacheWarmupService.phpS  տhS  wd      U   api/Resources/cache/ContainerEdRFl8V/getSecurity_Access_RoleHierarchyVoterService.php*  տh*  ,      T   api/Resources/cache/ContainerEdRFl8V/getArgumentResolver_RequestAttributeService.php  տh  Vo      C   api/Resources/cache/ContainerEdRFl8V/getBackupCreateTaskService.phpG  տhG  Q-      L   api/Resources/cache/ContainerEdRFl8V/getProcessRunnerCommand_LazyService.php  տh  >      R   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_CachePoolDeleteService.phpt  տht  J;T      B   api/Resources/cache/ContainerEdRFl8V/getCloudControllerService.php	  տh	  e      <   api/Resources/cache/ContainerEdRFl8V/getSetupTaskService.phpX  տhX  H      S   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_SecretsSet_LazyService.php  տh  V      E   api/Resources/cache/ContainerEdRFl8V/getTemplateControllerService.php  տh  :d|      Z   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_CachePoolInvalidateTagsService.php  տh  c̤      ]   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_EventDispatcherDebug_LazyService.phpg  տhg  lT      V   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_CachePoolList_LazyService.php  տh  54      W   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_EventDispatcherDebugService.php  տh         K   api/Resources/cache/ContainerEdRFl8V/getArgumentResolver_ServiceService.php  տh  տ      `   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_CachePoolInvalidateTags_LazyService.php  տh  ULͤ      T   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_CacheWarmup_LazyService.php  տh  2      F   api/Resources/cache/ContainerEdRFl8V/getCache_SystemClearerService.php  տh  rn      J   api/Resources/cache/ContainerEdRFl8V/get_ServiceLocator_BvkMlPlService.phpP  տhP  .K      G   api/Resources/cache/ContainerEdRFl8V/getMonolog_Logger_TasksService.php  տh  n      F   api/Resources/cache/ContainerEdRFl8V/getAdminUserControllerService.phpB  տhB  A      H   api/Resources/cache/ContainerEdRFl8V/getIntegrityCheckCommandService.php  տh  ͤ      V   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_AssetsInstall_LazyService.php)  տh)  O      [   api/Resources/cache/ContainerEdRFl8V/getSecurity_Firewall_EventDispatcherLocatorService.php  տh  }E      R   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_SerializerDebugService.php  տh  ޕa      E   api/Resources/cache/ContainerEdRFl8V/getPhpExtensionsCheckService.php(  տh(  NCΤ      K   api/Resources/cache/ContainerEdRFl8V/getArgumentResolver_DefaultService.php  տh  o̤      A   api/Resources/cache/ContainerEdRFl8V/getAuthControllerService.php  տh  '      L   api/Resources/cache/ContainerEdRFl8V/getArgumentResolver_DatetimeService.php  տh  T      G   api/Resources/cache/ContainerEdRFl8V/getArgumentResolver_UidService.php  տh  &5      L   api/Resources/cache/ContainerEdRFl8V/getInstallToolLockControllerService.php  տh  ¤      E   api/Resources/cache/ContainerEdRFl8V/getUpdateCommand_LazyService.php  տh  gi      E   api/Resources/cache/ContainerEdRFl8V/getComposerControllerService.php>  տh>  5"[      K   api/Resources/cache/ContainerEdRFl8V/getArgumentResolver_SessionService.php  տh  GF      >   api/Resources/cache/ContainerEdRFl8V/getCacheWarmerService.php  տh  ֤      E   api/Resources/cache/ContainerEdRFl8V/getRedirectControllerService.php  տh  Z37{      @   api/Resources/cache/ContainerEdRFl8V/getUploadsConfigService.php  տh        N   api/Resources/cache/ContainerEdRFl8V/getDatabaseMigrationControllerService.php=  տh=  8      K   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_YamlLintService.php	  տh	  ʧ      G   api/Resources/cache/ContainerEdRFl8V/getConfigBuilder_WarmerService.php  տh  !      L   api/Resources/cache/ContainerEdRFl8V/getPasswordlessAuthenticatorService.php  տh  >      A   api/Resources/cache/ContainerEdRFl8V/getClearCacheTaskService.phpE  տhE  (      H   api/Resources/cache/ContainerEdRFl8V/getRootPackageControllerService.phpQ  տhQ  ¤      E   api/Resources/cache/ContainerEdRFl8V/getCache_App_TaggableService.php  տh  m?`      @   api/Resources/cache/ContainerEdRFl8V/getContaoConsoleService.php  տh  >      @   api/Resources/cache/ContainerEdRFl8V/getManagerConfigService.php  տh        M   api/Resources/cache/ContainerEdRFl8V/getSecurity_UserValueResolverService.php  տh  A2      X   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_DebugAutowiring_LazyService.php8  տh8  ¾      Q   api/Resources/cache/ContainerEdRFl8V/getSecurity_Command_DebugFirewallService.php  տh  C&      b   api/Resources/cache/ContainerEdRFl8V/getSecurity_Listener_CheckAuthenticatorCredentialsService.phpH  տhH  89      W   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_CachePoolClear_LazyService.php  տh  M>      M   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_CacheClearService.php  տh  1      D   api/Resources/cache/ContainerEdRFl8V/getPhpinfoControllerService.php  տh  S      P   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_CachePoolListService.php  տh  g@      U   api/Resources/cache/ContainerEdRFl8V/getSecurity_Authenticator_Manager_ApiService.php  տh  ",/      E   api/Resources/cache/ContainerEdRFl8V/getAllowUrlFopenCheckService.php(  տh(  i      C   api/Resources/cache/ContainerEdRFl8V/getRebuildCacheTaskService.phpp  տhp  J      V   api/Resources/cache/ContainerEdRFl8V/getSecurity_Firewall_Authenticator_ApiService.php  տh  d      [   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_SecretsGenerateKey_LazyService.phpE  տhE  N(      T   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_RouterDebug_LazyService.php  տh  :9      Q   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_CachePoolClearService.php_  տh_  NӤ      @   api/Resources/cache/ContainerEdRFl8V/getLogControllerService.php*  տh*  <X      L   api/Resources/cache/ContainerEdRFl8V/getContainer_EnvVarProcessorService.php,  տh,  ;G      U   api/Resources/cache/ContainerEdRFl8V/getSecurity_Listener_Api_UserProviderService.php!  տh!  e      >   api/Resources/cache/ContainerEdRFl8V/getInstallTaskService.php#  տh#  )V      T   api/Resources/cache/ContainerEdRFl8V/getContainer_EnvVarProcessorsLocatorService.php
  տh
  «      D   api/Resources/cache/ContainerEdRFl8V/getExceptionListenerService.php  տh        ?   api/Resources/cache/ContainerEdRFl8V/getSymlinkCheckService.php  տh  
,D      :   api/Resources/cache/ContainerEdRFl8V/getRequestService.php  տh  8G      ?   api/Resources/cache/ContainerEdRFl8V/getSessionCheckService.php
  տh
  r%      L   api/Resources/cache/ContainerEdRFl8V/getMissingPackagesControllerService.phpe  տhe  g      U   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_SecretsGenerateKeyService.php8  տh8  L/      =   api/Resources/cache/ContainerEdRFl8V/getUpdateTaskService.php  տh  21      T   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_SecretsList_LazyService.php  տh        A   api/Resources/cache/ContainerEdRFl8V/getComposerConfigService.php   տh   `      Z   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_SecretsEncryptFromLocalService.php`  տh`  `=      J   api/Resources/cache/ContainerEdRFl8V/getSecurity_AccessListenerService.php  տh   Yf      Q   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_CachePoolPruneService.php  տh  -      Z   api/Resources/cache/ContainerEdRFl8V/get_Security_Command_UserPasswordHash_LazyService.php6  տh6  "m$~      N   api/Resources/cache/ContainerEdRFl8V/getSecurity_RouteLoader_LogoutService.php  տh  li`      T   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_ConfigDebug_LazyService.php  տh  5s      e   api/Resources/cache/ContainerEdRFl8V/getContaoManager_Security_AuthenticationTrustResolverService.php  տh  rgf      E   api/Resources/cache/ContainerEdRFl8V/getDatabaseControllerService.php  տh  yt      X   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_SecretsDecryptToLocalService.phpd  տhd  Ɛ      J   api/Resources/cache/ContainerEdRFl8V/getLocalPackagesControllerService.php[  տh[  1Τ      ?   api/Resources/cache/ContainerEdRFl8V/getAboutCommandService.php  տh  0H      H   api/Resources/cache/ContainerEdRFl8V/getTaskAbortCommand_LazyService.php  տh  |yG      V   api/Resources/cache/ContainerEdRFl8V/getSecurity_SecurityTokenValueResolverService.php@  տh@  ]"J      E   api/Resources/cache/ContainerEdRFl8V/getTokenAuthenticatorService.php  տh  4%      R   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_DebugAutowiringService.php  տh  Ym|      =   api/Resources/cache/ContainerEdRFl8V/getServerInfoService.php  տh  C      N   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_RouterMatchService.php  տh  {X      M   api/Resources/cache/ContainerEdRFl8V/getIntegrityCheckCommand_LazyService.php  տh  =      J   api/Resources/cache/ContainerEdRFl8V/get_ServiceLocator_AH5O6SdService.phph  տhh  Bk      B   api/Resources/cache/ContainerEdRFl8V/getErrorControllerService.php  տh  1:      J   api/Resources/cache/ContainerEdRFl8V/get_ServiceLocator_EZsc_DOService.phpb  տhb  I4      S   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_CacheClear_LazyService.php  տh  	      K   api/Resources/cache/ContainerEdRFl8V/getArgumentResolver_RequestService.php  տh  NF      P   api/Resources/cache/ContainerEdRFl8V/RequestPayloadValueResolverGhost8d82153.phpX  տhX  
8      H   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_AboutService.php  տh  kO3      C   api/Resources/cache/ContainerEdRFl8V/getDumpAutoloadTaskService.phpO  տhO  n:      V   api/Resources/cache/ContainerEdRFl8V/get_Console_Command_ContainerLint_LazyService.php8  տh8  5f      N   api/Resources/cache/ContainerEdRFl8V/getConsole_Command_ConfigDebugService.php  տh  D;      -   api/Resources/cache/url_generating_routes.phpv  տhv  w      +   api/Resources/cache/url_matching_routes.php5  տh5  v݈      0   api/Resources/cache/url_matching_routes.php.meta!  տh!  Γ2      H   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.preload.php6v  տh6v  Q$      @   api/Resources/cache/Symfony/Config/Framework/HttpCacheConfig.php#  տh#  
1      F   api/Resources/cache/Symfony/Config/Framework/Webhook/RoutingConfig.phpv  տhv  j3      <   api/Resources/cache/Symfony/Config/Framework/CacheConfig.php$  տh$  Ah;      @   api/Resources/cache/Symfony/Config/Framework/FragmentsConfig.php
  տh
  	[b      J   api/Resources/cache/Symfony/Config/Framework/Form/CsrfProtectionConfig.php  տh  7eG      P   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptionsConfig.phpE  տhE  X      i   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig/RetryFailed/HttpCodeConfig.php  տh        d   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig/PeerFingerprintConfig.php
  տh
  E      `   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig/RetryFailedConfig.phpr  տhr         N   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig.php=S  տh=S  >)
      e   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptions/RetryFailed/HttpCodeConfig.php  տh  ,@Ϥ      `   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptions/PeerFingerprintConfig.php	  տh	   !j      \   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptions/RetryFailedConfig.php^  տh^  C"      I   api/Resources/cache/Symfony/Config/Framework/Serializer/MappingConfig.phpF  տhF  $v      A   api/Resources/cache/Symfony/Config/Framework/ValidationConfig.php&  տh&  j      B   api/Resources/cache/Symfony/Config/Framework/RateLimiterConfig.php	  տh	        U   api/Resources/cache/Symfony/Config/Framework/RateLimiter/LimiterConfig/RateConfig.phpm  տhm  $S      J   api/Resources/cache/Symfony/Config/Framework/RateLimiter/LimiterConfig.php  տh  9§      A   api/Resources/cache/Symfony/Config/Framework/Cache/PoolConfig.php  տh  -.-      A   api/Resources/cache/Symfony/Config/Framework/SerializerConfig.php  տh  `o      E   api/Resources/cache/Symfony/Config/Framework/CsrfProtectionConfig.php7  տh7  g	      =   api/Resources/cache/Symfony/Config/Framework/AssetsConfig.php+  տh+  (      N   api/Resources/cache/Symfony/Config/Framework/Notifier/AdminRecipientConfig.phpZ  տhZ  ¾      @   api/Resources/cache/Symfony/Config/Framework/MessengerConfig.php^(  տh^(  2!ä      >   api/Resources/cache/Symfony/Config/Framework/WebhookConfig.php  տh  &J      =   api/Resources/cache/Symfony/Config/Framework/RouterConfig.php  տh  Ǚw      A   api/Resources/cache/Symfony/Config/Framework/TranslatorConfig.phpy   տhy         @   api/Resources/cache/Symfony/Config/Framework/WorkflowsConfig.php  տh  :i      J   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig.php)  տh)  N      [   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/AuditTrailConfig.phpN  տhN  VN      ]   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/MarkingStoreConfig.php	  տh	  h4      [   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/TransitionConfig.php]  տh]  Eg :      V   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/PlaceConfig.php  տh  i:      :   api/Resources/cache/Symfony/Config/Framework/EsiConfig.php-  տh-  5      >   api/Resources/cache/Symfony/Config/Framework/WebLinkConfig.php1  տh1        F   api/Resources/cache/Symfony/Config/Framework/Mailer/EnvelopeConfig.php  տh  R      D   api/Resources/cache/Symfony/Config/Framework/Mailer/HeaderConfig.php,  տh,  lu      :   api/Resources/cache/Symfony/Config/Framework/SsiConfig.php-  տh-  (      T   api/Resources/cache/Symfony/Config/Framework/Translator/PseudoLocalizationConfig.php  տh  |Њ      J   api/Resources/cache/Symfony/Config/Framework/Translator/ProviderConfig.php
  տh
  ܤ      ?   api/Resources/cache/Symfony/Config/Framework/ProfilerConfig.php  տh  pé      @   api/Resources/cache/Symfony/Config/Framework/SemaphoreConfig.php  տh  R8      >   api/Resources/cache/Symfony/Config/Framework/SecretsConfig.php  տh  |1      E   api/Resources/cache/Symfony/Config/Framework/PropertyAccessConfig.php  տh  S(      J   api/Resources/cache/Symfony/Config/Framework/Messenger/TransportConfig.php  տh  W      ]   api/Resources/cache/Symfony/Config/Framework/Messenger/Serializer/SymfonySerializerConfig.php  տh  +]      K   api/Resources/cache/Symfony/Config/Framework/Messenger/SerializerConfig.php  տh  Ot      ^   api/Resources/cache/Symfony/Config/Framework/Messenger/TransportConfig/RetryStrategyConfig.php?  տh?  [T      H   api/Resources/cache/Symfony/Config/Framework/Messenger/RoutingConfig.php]  տh]  zT      U   api/Resources/cache/Symfony/Config/Framework/Messenger/BusConfig/MiddlewareConfig.php  տh  i      \   api/Resources/cache/Symfony/Config/Framework/Messenger/BusConfig/DefaultMiddlewareConfig.php
  տh
  Ԥ      D   api/Resources/cache/Symfony/Config/Framework/Messenger/BusConfig.php  տh        C   api/Resources/cache/Symfony/Config/Framework/PropertyInfoConfig.php5  տh5        =   api/Resources/cache/Symfony/Config/Framework/MailerConfig.php;  տh;        :   api/Resources/cache/Symfony/Config/Framework/UidConfig.php  տh  ե      B   api/Resources/cache/Symfony/Config/Framework/RemoteeventConfig.php5  տh5  `      B   api/Resources/cache/Symfony/Config/Framework/AssetMapperConfig.phpY(  տhY(  Pm      D   api/Resources/cache/Symfony/Config/Framework/HtmlSanitizerConfig.php*
  տh*
  
?      @   api/Resources/cache/Symfony/Config/Framework/ExceptionConfig.phpO  տhO        >   api/Resources/cache/Symfony/Config/Framework/SessionConfig.php`2  տh`2        N   api/Resources/cache/Symfony/Config/Framework/HtmlSanitizer/SanitizerConfig.php9  տh9  ,      A   api/Resources/cache/Symfony/Config/Framework/HttpClientConfig.phpv  տhv  1      @   api/Resources/cache/Symfony/Config/Framework/PhpErrorsConfig.php  տh  .m      ?   api/Resources/cache/Symfony/Config/Framework/NotifierConfig.phpS  տhS  6S2      >   api/Resources/cache/Symfony/Config/Framework/RequestConfig.phpg  տhg  Ϊ      B   api/Resources/cache/Symfony/Config/Framework/AnnotationsConfig.php  տh  c:Ĥ      E   api/Resources/cache/Symfony/Config/Framework/Assets/PackageConfig.php!  տh!  `      X   api/Resources/cache/Symfony/Config/Framework/Validation/NotCompromisedPasswordConfig.php9  տh9  r9`      I   api/Resources/cache/Symfony/Config/Framework/Validation/MappingConfig.phpF  տhF  Һ      M   api/Resources/cache/Symfony/Config/Framework/Validation/AutoMappingConfig.phpn  տhn  }      ;   api/Resources/cache/Symfony/Config/Framework/LockConfig.php  տh  $      @   api/Resources/cache/Symfony/Config/Framework/SchedulerConfig.php3  տh3        ;   api/Resources/cache/Symfony/Config/Framework/FormConfig.php
  տh
  ܥ;      P   api/Resources/cache/Symfony/Config/Security/ProviderConfig/Memory/UserConfig.php  տh  K      I   api/Resources/cache/Symfony/Config/Security/ProviderConfig/LdapConfig.php  տh  OK      K   api/Resources/cache/Symfony/Config/Security/ProviderConfig/MemoryConfig.phpO  տhO  >]      J   api/Resources/cache/Symfony/Config/Security/ProviderConfig/ChainConfig.php  տh  y4      D   api/Resources/cache/Symfony/Config/Security/PasswordHasherConfig.php  տh  j{쾤      >   api/Resources/cache/Symfony/Config/Security/ProviderConfig.php  տh  73      >   api/Resources/cache/Symfony/Config/Security/FirewallConfig.php/n  տh/n  %k      P   api/Resources/cache/Symfony/Config/Security/FirewallConfig/AccessTokenConfig.php  տh  dä      O   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RememberMeConfig.php1  տh1  P'      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/FormLoginConfig.phpA  տhA  ǌ       R   api/Resources/cache/Symfony/Config/Security/FirewallConfig/JsonLoginLdapConfig.php,*  տh,*  Ex      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/HttpBasicConfig.php  տh  j      ]   api/Resources/cache/Symfony/Config/Security/FirewallConfig/AccessToken/TokenHandlerConfig.php  տh  
Ƕ      j   api/Resources/cache/Symfony/Config/Security/FirewallConfig/AccessToken/TokenHandler/OidcUserInfoConfig.php
  տh
  
      b   api/Resources/cache/Symfony/Config/Security/FirewallConfig/AccessToken/TokenHandler/OidcConfig.php  տh  .}e      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/JsonLoginConfig.php  տh  \      X   api/Resources/cache/Symfony/Config/Security/FirewallConfig/Logout/DeleteCookieConfig.php  տh  8x      O   api/Resources/cache/Symfony/Config/Security/FirewallConfig/SwitchUserConfig.php  տh  j a      T   api/Resources/cache/Symfony/Config/Security/FirewallConfig/LoginThrottlingConfig.php
  տh
  >      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/LoginLinkConfig.php3  տh3  ~1      f   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RememberMe/TokenProvider/DoctrineConfig.php  տh  =      ]   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RememberMe/TokenProviderConfig.php[  տh[  6O      R   api/Resources/cache/Symfony/Config/Security/FirewallConfig/FormLoginLdapConfig.phpNN  տhNN  jN      R   api/Resources/cache/Symfony/Config/Security/FirewallConfig/HttpBasicLdapConfig.php  տh  B      I   api/Resources/cache/Symfony/Config/Security/FirewallConfig/X509Config.php  տh  I      O   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RemoteUserConfig.php  տh  U8      K   api/Resources/cache/Symfony/Config/Security/FirewallConfig/LogoutConfig.php   տh   E㲤      K   api/Resources/cache/Symfony/Config/Security/AccessDecisionManagerConfig.php  տh  O^      C   api/Resources/cache/Symfony/Config/Security/AccessControlConfig.php  տh  XAL      5   api/Resources/cache/Symfony/Config/SecurityConfig.php1  տh1  ?      4   api/Resources/cache/Symfony/Config/MonologConfig.php  տh  j%      <   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig.php>) տh>) 	      V   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ProcessPsr3MessagesConfig.php
  տh
  U      L   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/PublisherConfig.php"  տh"  -      H   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/RedisConfig.php  տh  ע      P   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ElasticsearchConfig.php  տh  !a      Q   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/EmailPrototypeConfig.phpZ  տhZ  q:_      H   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/MongoConfig.php  տh  =o      R   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/VerbosityLevelsConfig.php  տh  =1ޤ      I   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/PredisConfig.php:  տh:  f ɤ      S   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ExcludedHttpCodeConfig.php~  տh~  4:T      K   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ChannelsConfig.php  տh  у      6   api/Resources/cache/Symfony/Config/FrameworkConfig.php տh ?>      #   api/Resources/cache/annotations.map  տh  r'      "   api/Resources/config/services.yaml  տh  Q]      $   api/Resources/config/config_dev.yaml  տh        %   api/Resources/config/config_prod.yaml   տh   H          api/Resources/config/config.yaml*  տh*  "H         api/Resources/i18n/cs.yml  տh  f         api/Resources/i18n/br.yml  տh           api/Resources/i18n/es.ymlP  տhP  eͺ         api/Resources/i18n/pt.yml  տh  hǤ         api/Resources/i18n/de.yml  տh  V=         api/Resources/i18n/it.yml  տh  `         api/Resources/i18n/pl.yml3  տh3  fi         api/Resources/i18n/fa.yml;	  տh;	  1,         api/Resources/i18n/sv.yml6  տh6  kM4Ť         api/Resources/i18n/en.ymlm  տhm  hDh>         api/Resources/i18n/ja.yml  տh  8E~         api/Resources/i18n/ru.yml  տh  2          api/Resources/i18n/sr.yml  տh  jU         api/Resources/i18n/fr.yml7  տh7  	         api/Resources/i18n/lv.yml  տh           api/Resources/i18n/tr.yml  տh  ݇         api/Resources/i18n/nl.yml  տh  դ         api/Resources/i18n/zh.yml
  տh
  ^a         api/ApiApplication.php  տh  -r      #   api/Tests/Composer/CloudJobTest.php  տh  !L      '   api/Tests/Controller/LogPatternTest.php0  տh0  Ly      !   api/Controller/FileController.php  տh        !   api/Controller/UserController.phpoB  տhoB  !          api/Controller/LogController.php  տh  '%      (   api/Controller/Config/AuthController.phpg  տhg  rI6      2   api/Controller/Config/AbstractConfigController.php  տh  <V      ,   api/Controller/Config/ComposerController.php  տh  gƤ      +   api/Controller/Config/ManagerController.php  տh  ݤ      !   api/Controller/TaskController.phpy  տhy  fId      *   api/Controller/Server/PhpWebController.phpD  տhD  1eŤ      *   api/Controller/Server/ContaoController.php"  տh"  ͚v      ,   api/Controller/Server/DatabaseController.php2
  տh2
  W?      -   api/Controller/Server/AdminUserController.php
  տh
  DV      +   api/Controller/Server/PhpinfoController.phpr  տhr  %E      +   api/Controller/Server/OpcacheController.php  տh  "      *   api/Controller/Server/ConfigController.php  տh  $      ,   api/Controller/Server/ComposerController.php?  տh?  j$Np      *   api/Controller/Server/PhpCliController.php  տh  K|Q      .   api/Controller/Server/SelfUpdateController.php  տh  $w      $   api/Controller/SessionController.phps  տhs  YK~      5   api/Controller/Packages/MissingPackagesController.php
  տh
  2c      4   api/Controller/Packages/UploadPackagesController.php'  տh'  O      1   api/Controller/Packages/RootPackageController.php'  տh'  &H)      +   api/Controller/Packages/CloudController.php  տh  a      3   api/Controller/Packages/LocalPackagesController.phpN  տhN        '   api/Controller/ConstraintController.phpY  տhY  kۤ      3   api/Controller/Contao/InstallToolLockController.php3  տh3  AÖ      5   api/Controller/Contao/DatabaseMigrationController.php%  տh%  Zb      -   api/Controller/Contao/AccessKeyController.php0  տh0  I>      *   api/Controller/Contao/BackupController.php,  տh,  >]6      3   api/Controller/Contao/MaintenanceModeController.php  տh  $iW      -   api/Controller/Contao/JwtCookieController.php  տh  bˤ         api/ApiKernel.php>&  տh>&  8          api/System/ServerInfo.phpq  տhq  ƾq         api/System/Request.php[  տh[  y9[<         api/System/SelfUpdate.phpD  տhD  qׂ         api/Task/TaskStatus.php=  տh=  %s      &   api/Task/Composer/DumpAutoloadTask.php  տh  Wj      $   api/Task/Composer/ClearCacheTask.php  տh        #   api/Task/Manager/SelfUpdateTask.php  տh  @?&         api/Task/AbstractTask.php  տh  ߪO         api/Task/Packages/SetupTask.php
  տh
  f          api/Task/Packages/UpdateTask.phpF+  տhF+  .      !   api/Task/Packages/InstallTask.php-  տh-  }~BC      *   api/Task/Packages/AbstractPackagesTask.php
  տh
  #c      $   api/Task/Contao/BackupCreateTask.php  տh  E      %   api/Task/Contao/BackupRestoreTask.php  տh  UF      $   api/Task/Contao/RebuildCacheTask.php  տh  lK         api/Task/TaskManager.phpC  տhC  W         api/Task/TaskInterface.php  տh  r         api/Task/TaskConfig.php	  տh	  /ʤ      %   api/Command/IntegrityCheckCommand.php	  տh	           api/Command/UpdateCommand.php  տh  %          api/Command/TaskAbortCommand.phpJ  տhJ  {P峤      !   api/Command/TaskUpdateCommand.phpz  տhz  k      $   api/Command/ProcessRunnerCommand.phpy  տhy  `݃y         api/Command/AboutCommand.php  տh  pSe      !   api/Command/TaskDeleteCommand.phpa  տha  
W         api/I18n/Translator.php
  տh
  q
      %   api/Exception/ApiProblemException.php5  տh5  W{       (   api/Exception/ProcessOutputException.php  տh  o      &   api/Exception/InvalidTotpException.php  տh  ʤ      &   api/Exception/InvalidJsonException.php
  տh
  8Y      "   api/Exception/RequestException.php  տh  Ű      )   api/IntegrityCheck/AllowUrlFopenCheck.php%  տh%  z2Ť      '   api/IntegrityCheck/GraphicsLibCheck.php  տh  kp¤         api/IntegrityCheck/ZipCheck.php  տh  k"      &   api/IntegrityCheck/SysTempDirCheck.php  տh  Ƥ      .   api/IntegrityCheck/IntegrityCheckInterface.php~  տh~        #   api/IntegrityCheck/ProcessCheck.php  տh  \.sg      #   api/IntegrityCheck/SymlinkCheck.php  տh  ;W      #   api/IntegrityCheck/SessionCheck.php  տh  ˭K      '   api/IntegrityCheck/MemoryLimitCheck.phpK  տhK  ^      )   api/IntegrityCheck/PhpExtensionsCheck.php  տh  	:      -   api/IntegrityCheck/AbstractIntegrityCheck.php  տh        ,   api/IntegrityCheck/IntegrityCheckFactory.php  տh  R,         api/Process/ContaoApi.phpF  տhF  B      !   api/Process/ProcessController.php  տh  ٧e      %   api/Process/Forker/AbstractForker.php
  տh
  ȮH      &   api/Process/Forker/ForkerInterface.phpn  տhn  |5oq      #   api/Process/Forker/DisownForker.php  տh  w4h      "   api/Process/Forker/NohupForker.php  տh  ZA      )   api/Process/Forker/WindowsStartForker.php  տh  a\"      #   api/Process/Forker/InlineForker.php  տh  Ѷ#         api/Process/Utf8Process.php  տh  x         api/Process/ProcessRunner.php  տh  |E         api/Process/AbstractProcess.php  տh  6?=         api/Process/ContaoConsole.php   տh   v)1      #   api/Process/PhpExecutableFinder.php  տh  r      %   api/Process/ConsoleProcessFactory.php  տh  k         api/console8  տh8  i.      $   api/EventListener/LocaleListener.php.  տh.        '   api/EventListener/ExceptionListener.php~
  տh~
  
      &   api/EventListener/SecurityListener.php  տh  O      '   api/EventListener/CheckTotpListener.php  տh  5%T      )   api/EventListener/JsonRequestListener.phpM  տhM  ä      
   downgrade.php0  տh0  8-ˤ      $   vendor/seld/phar-utils/composer.lock/  տh/  cւ(         vendor/seld/phar-utils/LICENSE"  տh"  ?e          vendor/seld/phar-utils/README.mde  տhe  :N      $   vendor/seld/phar-utils/composer.json;  տh;  =      %   vendor/seld/phar-utils/src/Linter.php
  տh
  #:	      )   vendor/seld/phar-utils/src/Timestamps.phpk  տhk  F         vendor/seld/jsonlint/LICENSE"  տh"  asy      !   vendor/seld/jsonlint/bin/jsonlint  տh   
      !   vendor/seld/jsonlint/CHANGELOG.md	  տh	  ݣʤ         vendor/seld/jsonlint/README.md
  տh
  f      "   vendor/seld/jsonlint/composer.jsonU  տhU  TR      @   vendor/seld/jsonlint/src/Seld/JsonLint/DuplicateKeyException.php  տh  ArQ      ;   vendor/seld/jsonlint/src/Seld/JsonLint/ParsingException.php  տh  m2;      0   vendor/seld/jsonlint/src/Seld/JsonLint/Lexer.php"  տh"  ;      4   vendor/seld/jsonlint/src/Seld/JsonLint/Undefined.php*  տh*        5   vendor/seld/jsonlint/src/Seld/JsonLint/JsonParser.php,_  տh,_  v      "   vendor/seld/signal-handler/LICENSE"  տh"  ?e      (   vendor/seld/signal-handler/composer.json  տh  c      0   vendor/seld/signal-handler/src/SignalHandler.phpO  տhO  ,C         vendor/autoload.php  տh  hU%u      $   vendor/phpstan/phpdoc-parser/LICENSEQ  տhQ  w      &   vendor/phpstan/phpdoc-parser/README.md  տh  eC      )   vendor/phpstan/phpdoc-parser/UPGRADING.md#  տh#  &~g      *   vendor/phpstan/phpdoc-parser/composer.json  տh  R	      0   vendor/phpstan/phpdoc-parser/src/Lexer/Lexer.php  տh  &eo      5   vendor/phpstan/phpdoc-parser/src/Printer/DiffElem.php  տh  
      3   vendor/phpstan/phpdoc-parser/src/Printer/Differ.phpj  տhj  yT      4   vendor/phpstan/phpdoc-parser/src/Printer/Printer.php7  տh7  x)      ;   vendor/phpstan/phpdoc-parser/src/Parser/ParserException.php	  տh	  2Ф      8   vendor/phpstan/phpdoc-parser/src/Parser/PhpDocParser.php  տh  ^      ;   vendor/phpstan/phpdoc-parser/src/Parser/ConstExprParser.php!  տh!  HH      ;   vendor/phpstan/phpdoc-parser/src/Parser/StringUnescaper.php\
  տh\
  k'#      6   vendor/phpstan/phpdoc-parser/src/Parser/TypeParser.php_  տh_  YeG      9   vendor/phpstan/phpdoc-parser/src/Parser/TokenIterator.php8)  տh8)  \j      1   vendor/phpstan/phpdoc-parser/src/ParserConfig.php`  տh`  Kä      V   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PureUnlessCallableIsImpureTagValueNode.php  տh  ;      A   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/MixinTagValueNode.php  տh  0      D   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/TemplateTagValueNode.php  տh        B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/AssertTagValueNode.php:  տh:  
f      B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ThrowsTagValueNode.php  տh  }      U   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamLaterInvokedCallableTagValueNode.php  տh  OS^      B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocTagValueNode.php   տh   ck      J   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/AssertTagPropertyValueNode.php  տh  -      M   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/RequireImplementsTagValueNode.php  տh  Z3      B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/SealedTagValueNode.php  տh  C      F   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ImplementsTagValueNode.php  տh  ^Ĥ      >   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocTextNode.php  տh  h%      :   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocNode.php*  տh*  M0      L   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamClosureThisTagValueNode.php-  տh-  =H      C   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/GenericTagValueNode.php  տh  ~T      E   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/TypeAliasTagValueNode.phpc  տhc        B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ReturnTagValueNode.php  տh  ^T      @   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/UsesTagValueNode.php  տh  Z!K      K   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/MethodTagValueParameterNode.php4  տh4  ܤ      I   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineArgument.php  տh  =      K   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineAnnotation.php  տh  ;k      M   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineTagValueNode.php  տh  j$Ѥ      J   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineArrayItem.php  տh  K      F   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineArray.php  տh  (Ҥ      C   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/InvalidTagValueNode.php  տh  ^ߤ      ?   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/VarTagValueNode.phpL  տhL  KHx      =   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocTagNode.php  տh  ɿ      D   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamOutTagValueNode.php%  տh%        I   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/TypelessParamTagValueNode.php  տh  m#w      H   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/AssertTagMethodValueNode.php  տh  {֤      K   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/TypeAliasImportTagValueNode.php  տh  jW      D   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PropertyTagValueNode.php   տh   7b!      [   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamImmediatelyInvokedCallableTagValueNode.php  տh  'D      ?   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocChildNode.php   տh   )5Q      C   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ExtendsTagValueNode.php  տh  ݤ      A   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamTagValueNode.phpU  տhU  ~,      B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/MethodTagValueNode.php  տh  7Ǥ      C   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/SelfOutTagValueNode.php  տh  L~      F   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/DeprecatedTagValueNode.php  տh  K]C      J   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/RequireExtendsTagValueNode.php  տh  >      A   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstFetchNode.php  տh  "iT      E   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprArrayNode.phpF  տhF  Y7      @   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprNode.php   տh         F   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprStringNode.php  տh  &m      D   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprTrueNode.php5  տh5  #6      G   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprIntegerNode.php  տh  80      E   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprFalseNode.php7  տh7  c󷯤      I   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprArrayItemNode.php  տh  ۋ      D   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprNullNode.php5  տh5  "      N   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/DoctrineConstExprStringNode.phpt  տht  <      E   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprFloatNode.php  տh  Gʤ      4   vendor/phpstan/phpdoc-parser/src/Ast/NodeVisitor.php
  տh
  һc      C   vendor/phpstan/phpdoc-parser/src/Ast/NodeVisitor/CloningVisitor.php  տh        2   vendor/phpstan/phpdoc-parser/src/Ast/Attribute.phpp  տhp  B      -   vendor/phpstan/phpdoc-parser/src/Ast/Node.php  տh  I       ;   vendor/phpstan/phpdoc-parser/src/Ast/Type/UnionTypeNode.php  տh  '¤      B   vendor/phpstan/phpdoc-parser/src/Ast/Type/IntersectionTypeNode.php
  տh
  m      @   vendor/phpstan/phpdoc-parser/src/Ast/Type/IdentifierTypeNode.php  տh  z21      @   vendor/phpstan/phpdoc-parser/src/Ast/Type/ArrayShapeItemNode.php  տh  o=      ;   vendor/phpstan/phpdoc-parser/src/Ast/Type/ConstTypeNode.php  տh  V0	      G   vendor/phpstan/phpdoc-parser/src/Ast/Type/CallableTypeParameterNode.php  տh        >   vendor/phpstan/phpdoc-parser/src/Ast/Type/CallableTypeNode.phpz  տhz  z"      6   vendor/phpstan/phpdoc-parser/src/Ast/Type/TypeNode.php   տh   9      A   vendor/phpstan/phpdoc-parser/src/Ast/Type/ObjectShapeItemNode.php  տh  [Z      :   vendor/phpstan/phpdoc-parser/src/Ast/Type/ThisTypeNode.php'  տh'  |      =   vendor/phpstan/phpdoc-parser/src/Ast/Type/ObjectShapeNode.phpR  տhR  7Nf      =   vendor/phpstan/phpdoc-parser/src/Ast/Type/InvalidTypeNode.phpg  տhg  L      B   vendor/phpstan/phpdoc-parser/src/Ast/Type/OffsetAccessTypeNode.php  տh  4      A   vendor/phpstan/phpdoc-parser/src/Ast/Type/ConditionalTypeNode.php  տh  Rפ      H   vendor/phpstan/phpdoc-parser/src/Ast/Type/ArrayShapeUnsealedTypeNode.php  տh  t       M   vendor/phpstan/phpdoc-parser/src/Ast/Type/ConditionalTypeForParameterNode.php  տh  +$      >   vendor/phpstan/phpdoc-parser/src/Ast/Type/NullableTypeNode.php  տh  qo      <   vendor/phpstan/phpdoc-parser/src/Ast/Type/ArrayShapeNode.php  տh  \鿤      =   vendor/phpstan/phpdoc-parser/src/Ast/Type/GenericTypeNode.php.  տh.  3      ;   vendor/phpstan/phpdoc-parser/src/Ast/Type/ArrayTypeNode.phpi  տhi  <p      <   vendor/phpstan/phpdoc-parser/src/Ast/AbstractNodeVisitor.php  տh  }$      0   vendor/phpstan/phpdoc-parser/src/Ast/Comment.php  տh  c軤      7   vendor/phpstan/phpdoc-parser/src/Ast/NodeAttributes.php+  տh+        6   vendor/phpstan/phpdoc-parser/src/Ast/NodeTraverser.php*  տh*           vendor/lcobucci/clock/LICENSE.  տh.  >z      #   vendor/lcobucci/clock/renovate.json   տh   ]G(      #   vendor/lcobucci/clock/composer.json,  տh,  ;      #   vendor/lcobucci/clock/src/Clock.php   տh   *	      )   vendor/lcobucci/clock/src/FrozenClock.php*  տh*  8o      )   vendor/lcobucci/clock/src/SystemClock.php  տh            vendor/bin/yaml-lint
  տh
  8<h      "   vendor/bin/patch-type-declarations`
  տh`
  +դ         vendor/bin/validate-json0
  տh0
  ̤         vendor/bin/composer	
  տh	
  k?ۤ         vendor/bin/var-dump-server?
  տh?
  &j         vendor/bin/jsonlint  տh  X      $   vendor/web-auth/webauthn-lib/LICENSE1  տh1  2      *   vendor/web-auth/webauthn-lib/composer.json	  տh	  =K      <   vendor/web-auth/webauthn-lib/src/FakeCredentialGenerator.php1  տh1  cF,Ȥ      1   vendor/web-auth/webauthn-lib/src/StringStream.php'  տh'  K1ۤ      @   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckAlgorithm.php$  տh$  $      D   vendor/web-auth/webauthn-lib/src/CeremonyStep/TopOriginValidator.php   տh   Q      A   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckUserHandle.php  տh         P   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckHasAttestedCredentialData.phpC  տhC  $Q      E   vendor/web-auth/webauthn-lib/src/CeremonyStep/CeremonyStepManager.php  տh  \TP      G   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckUserVerification.php3  տh3  PX,      L   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckAllowedCredentialList.php  տh        C   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckCredentialId.php  տh  \	      W   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckAttestationFormatIsKnownAndValid.phpH  տhH  $@s      @   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckSignature.php  տh  !Ǥ      H   vendor/web-auth/webauthn-lib/src/CeremonyStep/HostTopOriginValidator.php
  տh
  #o      K   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckRelyingPartyIdIdHash.php
  տh
  Oû      N   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckBackupBitsAreConsistent.php  տh  a      E   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckUserWasPresent.php  տh  w      N   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckClientDataCollectorType.php  տh  =&      @   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckChallenge.php  տh  g      >   vendor/web-auth/webauthn-lib/src/CeremonyStep/CeremonyStep.php  տh  ujv      >   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckCounter.php  տh  ʤ      @   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckTopOrigin.php  տh  "      =   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckOrigin.php  տh  Ť      A   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckExtensions.phpt  տht  =      H   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckMetadataStatement.php	   տh	   `      L   vendor/web-auth/webauthn-lib/src/CeremonyStep/CeremonyStepManagerFactory.php  տh  ^fr      B   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialUserEntity.php  տh  yP      7   vendor/web-auth/webauthn-lib/src/CertificateToolbox.php  տh  µ      V   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtensions.php  տh  ;k      [   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/ExtensionOutputCheckerHandler.php}  տh}  %}h      b   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtensionsClientInputs.php  տh  `i      R   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/ExtensionOutputError.php  տh  H'      U   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtension.php  տh  R      T   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/ExtensionOutputChecker.php   տh   DA      c   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtensionsClientOutputs.php  տh  
QT      i   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtensionsClientOutputsLoader.php  տh  D+      e   vendor/web-auth/webauthn-lib/src/AttestationStatement/AndroidSafetyNetAttestationStatementSupport.php66  տh66  v      \   vendor/web-auth/webauthn-lib/src/AttestationStatement/FidoU2FAttestationStatementSupport.phpZ  տhZ  T      Z   vendor/web-auth/webauthn-lib/src/AttestationStatement/AppleAttestationStatementSupport.phpR  տhR  9      Y   vendor/web-auth/webauthn-lib/src/AttestationStatement/NoneAttestationStatementSupport.phpz  տhz  |       U   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationStatementSupport.php  տh  0Hä      Q   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationObjectLoader.php  տh  a      [   vendor/web-auth/webauthn-lib/src/AttestationStatement/PackedAttestationStatementSupport.php+  տh+  ɯ      K   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationObject.php  տh  _f      _   vendor/web-auth/webauthn-lib/src/AttestationStatement/AndroidKeyAttestationStatementSupport.phpM"  տhM"  O~O      \   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationStatementSupportManager.php  տh  o      X   vendor/web-auth/webauthn-lib/src/AttestationStatement/TPMAttestationStatementSupport.php=  տh=  $3Y      N   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationStatement.php  տh  *      >   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialLoader.php  տh  x&      B   vendor/web-auth/webauthn-lib/src/SimpleFakeCredentialGenerator.php  տh  Aݤ      >   vendor/web-auth/webauthn-lib/src/TokenBinding/TokenBinding.php  տh  jhդ      H   vendor/web-auth/webauthn-lib/src/TokenBinding/SecTokenBindingHandler.php  տh        K   vendor/web-auth/webauthn-lib/src/TokenBinding/IgnoreTokenBindingHandler.php  տh  ɗCڤ      Q   vendor/web-auth/webauthn-lib/src/TokenBinding/TokenBindingNotSupportedHandler.php  տh  W      E   vendor/web-auth/webauthn-lib/src/TokenBinding/TokenBindingHandler.phph  տhh        <   vendor/web-auth/webauthn-lib/src/Util/CoseSignatureFixer.php`  տh`  _nW      0   vendor/web-auth/webauthn-lib/src/Util/Base64.phps  տhs  ݤ      ;   vendor/web-auth/webauthn-lib/src/AttestedCredentialData.php
  տh
  sr      /   vendor/web-auth/webauthn-lib/src/Credential.php  տh  h      N   vendor/web-auth/webauthn-lib/src/AuthenticatorAttestationResponseValidator.phpd2  տhd2  s      B   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialParameters.php	  տh	  #8r      B   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialDescriptor.php 
  տh 
  9\o      @   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialRpEntity.phpX  տhX  {B      E   vendor/web-auth/webauthn-lib/src/AuthenticatorAttestationResponse.php  տh  J      ?   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialOptions.php  տh  ^9      6   vendor/web-auth/webauthn-lib/src/AuthenticatorData.phpo
  տho
  Wo      L   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialDescriptorCollection.php  տh  
?Ҥ      :   vendor/web-auth/webauthn-lib/src/AuthenticatorResponse.php  տh  J      L   vendor/web-auth/webauthn-lib/src/AuthenticatorAssertionResponseValidator.php0  տh0  Dߤ      C   vendor/web-auth/webauthn-lib/src/AuthenticatorAssertionResponse.php=  տh=  Ȫ       W   vendor/web-auth/webauthn-lib/src/CertificateChainChecker/PhpCertificateChainChecker.php  տh  {Ϥ      T   vendor/web-auth/webauthn-lib/src/CertificateChainChecker/CertificateChainChecker.php  տh  2Ƥ      F   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialRequestOptions.php.  տh.  Dg      <   vendor/web-auth/webauthn-lib/src/AuthenticatorDataLoader.php  տh  Lڤ      H   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialSourceRepository.php   տh   z      >   vendor/web-auth/webauthn-lib/src/TrustPath/TrustPathLoader.php  տh  @b      B   vendor/web-auth/webauthn-lib/src/TrustPath/EcdaaKeyIdTrustPath.php  տh  ,q      8   vendor/web-auth/webauthn-lib/src/TrustPath/TrustPath.php  տh  "ߣ      =   vendor/web-auth/webauthn-lib/src/TrustPath/EmptyTrustPath.php  տh  b_      C   vendor/web-auth/webauthn-lib/src/TrustPath/CertificateTrustPath.php  տh  A#      >   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialEntity.php  տh         L   vendor/web-auth/webauthn-lib/src/ClientDataCollector/ClientDataCollector.phpA  տhA  У      S   vendor/web-auth/webauthn-lib/src/ClientDataCollector/ClientDataCollectorManager.php  տh  [6      X   vendor/web-auth/webauthn-lib/src/ClientDataCollector/WebauthnAuthenticationCollector.php  տh  =m      D   vendor/web-auth/webauthn-lib/src/Counter/ThrowExceptionIfInvalid.phpw  տhw  <Sڤ      ;   vendor/web-auth/webauthn-lib/src/Counter/CounterChecker.php  տh        V   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticationExtensionsDenormalizer.php	  տh	  Jo0Ӥ      R   vendor/web-auth/webauthn-lib/src/Denormalizer/AttestationStatementDenormalizer.php  տh        S   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticationExtensionNormalizer.php  տh  9A      G   vendor/web-auth/webauthn-lib/src/Denormalizer/TrustPathDenormalizer.php  տh        Q   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialDenormalizer.php  տh  ژؤ      K   vendor/web-auth/webauthn-lib/src/Denormalizer/WebauthnSerializerFactory.phpF
  տhF
  y      Q   vendor/web-auth/webauthn-lib/src/Denormalizer/CollectedClientDataDenormalizer.php  տh  ߺ䥤      [   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialParametersDenormalizer.php  տh  1      ^   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticatorAttestationResponseDenormalizer.php:  տh:  .֤      R   vendor/web-auth/webauthn-lib/src/Denormalizer/AttestedCredentialDataNormalizer.phpj  տhj  !wJ      Y   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialDescriptorNormalizer.phpy  տhy  薆      O   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticatorDataDenormalizer.php  տh  IV      O   vendor/web-auth/webauthn-lib/src/Denormalizer/AttestationObjectDenormalizer.php|  տh|  =G      W   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialSourceDenormalizer.php  տh  h2eԤ      [   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialUserEntityDenormalizer.php  տh  Wݤ      Q   vendor/web-auth/webauthn-lib/src/Denormalizer/ExtensionDescriptorDenormalizer.php(  տh(  PwФ      _   vendor/web-auth/webauthn-lib/src/Denormalizer/VerificationMethodANDCombinationsDenormalizer.php  տh  Eڵ      \   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticatorAssertionResponseDenormalizer.php  տh  s2P      S   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticatorResponseDenormalizer.php  տh  Wi      X   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialOptionsDenormalizer.php  տh  w~      8   vendor/web-auth/webauthn-lib/src/PublicKeyCredential.php  տh        D   vendor/web-auth/webauthn-lib/src/MetadataService/Psr18HttpClient.phpf  տhf  	\      K   vendor/web-auth/webauthn-lib/src/MetadataService/StatusReportRepository.php3  տh3  |`4&      _   vendor/web-auth/webauthn-lib/src/MetadataService/CertificateChain/CertificateChainValidator.phpT  տhT  Ѓv      X   vendor/web-auth/webauthn-lib/src/MetadataService/CertificateChain/CertificateToolbox.php  տh  W֮y      b   vendor/web-auth/webauthn-lib/src/MetadataService/CertificateChain/PhpCertificateChainValidator.php'  տh'  K%C      ?   vendor/web-auth/webauthn-lib/src/MetadataService/CanLogData.php   տh   .j       P   vendor/web-auth/webauthn-lib/src/MetadataService/MetadataStatementRepository.php  տh  8T      R   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/ExtensionDescriptor.php  տh  I      U   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/CodeAccuracyDescriptor.php	  տh	  P2      X   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/PatternAccuracyDescriptor.php	  տh	  7\      P   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/MetadataStatement.phpQ  տhQ  02      S   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/AuthenticatorGetInfo.php  տh  ;T      `   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/VerificationMethodANDCombinations.php  տh  J      T   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/BiometricStatusReport.php  տh  t%{      R   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/AuthenticatorStatus.php  տh  IJ>      Q   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/AbstractDescriptor.phpC  տhC  e0@      O   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/EcdaaTrustAnchor.php0
  տh0
  Ҩ      K   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/StatusReport.php7  տh7  P	      [   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/VerificationMethodDescriptor.php!  տh!   +9      V   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/AlternativeDescriptions.php+  տh+  c      Z   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/BiometricAccuracyDescriptor.php	  տh	  nX}}      F   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/Version.phpV	  տhV	        N   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/RgbPaletteEntry.php\	  տh\	  Pnu      M   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/RogueListEntry.php  տh  x"#      b   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/DisplayPNGCharacteristicsDescriptor.php  տh  ꠼      @   vendor/web-auth/webauthn-lib/src/MetadataService/ValueFilter.phpo  տho  jPOϤ      a   vendor/web-auth/webauthn-lib/src/MetadataService/Denormalizer/ExtensionDescriptorDenormalizer.php  տh  Ћz      d   vendor/web-auth/webauthn-lib/src/MetadataService/Denormalizer/MetadataStatementSerializerFactory.php  տh  yx      a   vendor/web-auth/webauthn-lib/src/MetadataService/Service/FidoAllianceCompliantMetadataService.php'  տh'  +X5դ      P   vendor/web-auth/webauthn-lib/src/MetadataService/Service/JsonMetadataService.php	  տh	  K      R   vendor/web-auth/webauthn-lib/src/MetadataService/Service/StringMetadataService.php  տh  :)Ĥ      U   vendor/web-auth/webauthn-lib/src/MetadataService/Service/MetadataBLOBPayloadEntry.php  տh  7      [   vendor/web-auth/webauthn-lib/src/MetadataService/Service/DistantResourceMetadataService.php  տh  fB      P   vendor/web-auth/webauthn-lib/src/MetadataService/Service/MetadataBLOBPayload.php  տh  4n      L   vendor/web-auth/webauthn-lib/src/MetadataService/Service/MetadataService.php  տh        Y   vendor/web-auth/webauthn-lib/src/MetadataService/Service/LocalResourceMetadataService.php

  տh

  i      T   vendor/web-auth/webauthn-lib/src/MetadataService/Service/ChainedMetadataServices.php  տh        Z   vendor/web-auth/webauthn-lib/src/MetadataService/Service/FolderResourceMetadataService.php
  տh
  -NZ      T   vendor/web-auth/webauthn-lib/src/MetadataService/Service/InMemoryMetadataService.phpA  տhA  T      Z   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/InvalidCertificateException.php  տh  z]      W   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/MetadataServiceException.php  տh  Y1ص      Z   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/ExpiredCertificateException.php  տh  g/      S   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/CertificateException.phpq  տhq  h      `   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/MissingMetadataStatementException.php  տh  m %      Z   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/RevokedCertificateException.php  տh  /      `   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/MetadataStatementLoadingException.php  տh  /V      Y   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/MetadataStatementException.php  տh  c       X   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/CertificateChainException.php  տh  ]ཤ      a   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/CertificateRevocationListException.php  տh  [      L   vendor/web-auth/webauthn-lib/src/MetadataService/Event/CanDispatchEvents.phpU  տhU  x      H   vendor/web-auth/webauthn-lib/src/MetadataService/Event/WebauthnEvent.phpA  տhA  o      [   vendor/web-auth/webauthn-lib/src/MetadataService/Event/BeforeCertificateChainValidation.php  տh  <s
      [   vendor/web-auth/webauthn-lib/src/MetadataService/Event/CertificateChainValidationFailed.php  տh  @2      ^   vendor/web-auth/webauthn-lib/src/MetadataService/Event/CertificateChainValidationSucceeded.php  տh  
$      Q   vendor/web-auth/webauthn-lib/src/MetadataService/Event/MetadataStatementFound.phpp  տhp  3	      N   vendor/web-auth/webauthn-lib/src/MetadataService/Event/NullEventDispatcher.phpa  տha  D
      C   vendor/web-auth/webauthn-lib/src/AuthenticatorSelectionCriteria.phpH   տhH   EѤ      X   vendor/web-auth/webauthn-lib/src/Exception/AttestationStatementVerificationException.phpn  տhn  66      J   vendor/web-auth/webauthn-lib/src/Exception/InvalidCertificateException.php  տh  ,s      S   vendor/web-auth/webauthn-lib/src/Exception/InvalidAttestationStatementException.php  տh        G   vendor/web-auth/webauthn-lib/src/Exception/MetadataServiceException.php1  տh1  \	      O   vendor/web-auth/webauthn-lib/src/Exception/AuthenticationExtensionException.php:  տh:  CVs      @   vendor/web-auth/webauthn-lib/src/Exception/WebauthnException.php*  տh*  m2      H   vendor/web-auth/webauthn-lib/src/Exception/InvalidTrustPathException.php3  տh3  ".      Y   vendor/web-auth/webauthn-lib/src/Exception/AuthenticatorResponseVerificationException.php>  տh>  
      J   vendor/web-auth/webauthn-lib/src/Exception/ExpiredCertificateException.php  տh  p      J   vendor/web-auth/webauthn-lib/src/Exception/UnsupportedFeatureException.php5  տh5  G      C   vendor/web-auth/webauthn-lib/src/Exception/CertificateException.phpO  տhO  Zl      P   vendor/web-auth/webauthn-lib/src/Exception/MissingMetadataStatementException.php;  տh;  )<Ԥ      J   vendor/web-auth/webauthn-lib/src/Exception/RevokedCertificateException.php   տh   cO      L   vendor/web-auth/webauthn-lib/src/Exception/AttestationStatementException.php   տh   n      P   vendor/web-auth/webauthn-lib/src/Exception/MetadataStatementLoadingException.phpz  տhz  $BC      ?   vendor/web-auth/webauthn-lib/src/Exception/CounterException.phpL  տhL        I   vendor/web-auth/webauthn-lib/src/Exception/MetadataStatementException.php   տh   ng      H   vendor/web-auth/webauthn-lib/src/Exception/CertificateChainException.php  տh  [4ۤ      S   vendor/web-auth/webauthn-lib/src/Exception/AttestationStatementLoadingException.php  տh        C   vendor/web-auth/webauthn-lib/src/Exception/InvalidDataException.php  տh  ޘ+      Q   vendor/web-auth/webauthn-lib/src/Exception/CertificateRevocationListException.php  տh  q9      I   vendor/web-auth/webauthn-lib/src/Exception/InvalidUserHandleException.phpe  տhe  |      1   vendor/web-auth/webauthn-lib/src/U2FPublicKey.php  տh  T      <   vendor/web-auth/webauthn-lib/src/Event/CanDispatchEvents.php  տh  ':      c   vendor/web-auth/webauthn-lib/src/Event/AuthenticatorAttestationResponseValidationSucceededEvent.php7  տh7  \Z      8   vendor/web-auth/webauthn-lib/src/Event/WebauthnEvent.phpg   տhg   >G      B   vendor/web-auth/webauthn-lib/src/Event/AttestationObjectLoaded.php  տh  ob      a   vendor/web-auth/webauthn-lib/src/Event/AuthenticatorAssertionResponseValidationSucceededEvent.php  տh         ^   vendor/web-auth/webauthn-lib/src/Event/AuthenticatorAssertionResponseValidationFailedEvent.php  տh  o~֤      K   vendor/web-auth/webauthn-lib/src/Event/BeforeCertificateChainValidation.phpX  տhX  /      K   vendor/web-auth/webauthn-lib/src/Event/CertificateChainValidationFailed.phpX  տhX  p      N   vendor/web-auth/webauthn-lib/src/Event/CertificateChainValidationSucceeded.php[  տh[  (ɤ      A   vendor/web-auth/webauthn-lib/src/Event/MetadataStatementFound.php  տh  
      >   vendor/web-auth/webauthn-lib/src/Event/NullEventDispatcher.php8  տh8  }o      `   vendor/web-auth/webauthn-lib/src/Event/AuthenticatorAttestationResponseValidationFailedEvent.php  տh  <?      E   vendor/web-auth/webauthn-lib/src/Event/AttestationStatementLoaded.php  տh  |7      >   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialSource.php"  տh"  Ik      G   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialCreationOptions.phpo)  տho)  í      8   vendor/web-auth/webauthn-lib/src/CollectedClientData.phpr  տhr  +Ĥ          vendor/web-auth/cose-lib/LICENSE,  տh,  C      "   vendor/web-auth/cose-lib/README.md  տh  Ŭ      &   vendor/web-auth/cose-lib/composer.json  տh  uN      $   vendor/web-auth/cose-lib/SECURITY.md  տh  Y{      %   vendor/web-auth/cose-lib/src/Hash.php  տh  8pȤ      (   vendor/web-auth/cose-lib/src/Key/Key.php*	  տh*	  4      +   vendor/web-auth/cose-lib/src/Key/RsaKey.php
  տh
  ZΤ      1   vendor/web-auth/cose-lib/src/Key/SymmetricKey.php  տh  f      +   vendor/web-auth/cose-lib/src/Key/Ec2Key.php'  տh'  n      +   vendor/web-auth/cose-lib/src/Key/OkpKey.php
  տh
  ?      9   vendor/web-auth/cose-lib/src/Algorithm/ManagerFactory.php  տh  7]4      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ES256.php  տh  U0      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ECDSA.php  տh  Af      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ES384.php  տh  "8      F   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ECSignature.php  տh  3y      A   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ES256K.php  տh  8      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ES512.php  տh  ˤ      <   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RS1.php  տh  ]2      <   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RSA.php  տh  #2      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RS384.php  տh  
f¤      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/PS256.php  տh  掤      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/PS384.php  տh  {      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RS256.php  տh        >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RS512.php  տh  *(z      ?   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/PSSRSA.php\  տh\  i"      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/PS512.php  տh  kJ      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/EdDSA/Ed512.php  տh  ƩK      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/EdDSA/EdDSA.php  տh         @   vendor/web-auth/cose-lib/src/Algorithm/Signature/EdDSA/Ed256.php  տh  Xy      B   vendor/web-auth/cose-lib/src/Algorithm/Signature/EdDSA/Ed25519.php@  տh@  	      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/Signature.phpV  տhV  ;      4   vendor/web-auth/cose-lib/src/Algorithm/Algorithm.php   տh   =
h      4   vendor/web-auth/cose-lib/src/Algorithm/Mac/HS512.php  տh  4X e      3   vendor/web-auth/cose-lib/src/Algorithm/Mac/Hmac.php  տh  Jd      2   vendor/web-auth/cose-lib/src/Algorithm/Mac/Mac.phpJ  տhJ  l'      4   vendor/web-auth/cose-lib/src/Algorithm/Mac/HS384.php  տh  5YF      ?   vendor/web-auth/cose-lib/src/Algorithm/Mac/HS256Truncated64.php  տh  y      4   vendor/web-auth/cose-lib/src/Algorithm/Mac/HS256.php  տh        2   vendor/web-auth/cose-lib/src/Algorithm/Manager.php  տh  ,      +   vendor/web-auth/cose-lib/src/BigInteger.php  տh  Yy      +   vendor/web-auth/cose-lib/src/Algorithms.phpX  տhX  S@      '   vendor/composer/autoload_namespaces.php   տh   /t      &   vendor/composer/xdebug-handler/LICENSE)  տh)  #;^      +   vendor/composer/xdebug-handler/CHANGELOG.md  տh  !YsK      (   vendor/composer/xdebug-handler/README.md4  տh4  S%      ,   vendor/composer/xdebug-handler/composer.jsony  տhy  -      0   vendor/composer/xdebug-handler/src/PhpConfig.php  տh  ]      -   vendor/composer/xdebug-handler/src/Status.phpz  տhz  "      4   vendor/composer/xdebug-handler/src/XdebugHandler.phpKV  տhKV  Eb      .   vendor/composer/xdebug-handler/src/Process.phpH  տhH  G      +   vendor/composer/class-map-generator/LICENSE  տh  DӤ      -   vendor/composer/class-map-generator/README.mdN  տhN  K(      1   vendor/composer/class-map-generator/composer.json  տh  |(~      =   vendor/composer/class-map-generator/src/ClassMapGenerator.phpk6  տhk6  2Bgn      :   vendor/composer/class-map-generator/src/PhpFileCleaner.php?  տh?  s      4   vendor/composer/class-map-generator/src/FileList.phpc  տhc  r5      9   vendor/composer/class-map-generator/src/PhpFileParser.php  տh  Ӡ      4   vendor/composer/class-map-generator/src/ClassMap.php  տh           vendor/composer/LICENSE.  տh.            vendor/composer/ClassLoader.php?  տh?  2@u      +   vendor/composer/composer/phpstan/rules.neon  տh  ~d      1   vendor/composer/composer/res/composer-schema.json  տh  -Zy       6   vendor/composer/composer/res/composer-lock-schema.json
  տh
  rf      <   vendor/composer/composer/res/composer-repository-schema.json   տh   븂      &   vendor/composer/composer/composer.lockK տhK R          vendor/composer/composer/LICENSE,  տh,  Vg      %   vendor/composer/composer/bin/composer  տh  -0~      $   vendor/composer/composer/bin/compile  տh  \0      &   vendor/composer/composer/composer.json  տh  Sv'      S   vendor/composer/composer/src/Composer/PHPStan/RuleReasonDataReturnTypeExtension.php
  տh
  
      K   vendor/composer/composer/src/Composer/PHPStan/ConfigReturnTypeExtension.phpL"  տhL"  W      1   vendor/composer/composer/src/Composer/Factory.php  տh  z0      H   vendor/composer/composer/src/Composer/Repository/RepositoryInterface.php  տh  й      R   vendor/composer/composer/src/Composer/Repository/InstalledFilesystemRepository.php  տh  J=      F   vendor/composer/composer/src/Composer/Repository/PackageRepository.phpl  տhl  +Z%      H   vendor/composer/composer/src/Composer/Repository/LockArrayRepository.php  տh  Ȥ      G   vendor/composer/composer/src/Composer/Repository/PlatformRepository.php  տh  ,+      F   vendor/composer/composer/src/Composer/Repository/RepositoryFactory.php$   տh$   8l      Q   vendor/composer/composer/src/Composer/Repository/InstalledRepositoryInterface.php  տh  +      P   vendor/composer/composer/src/Composer/Repository/WritableRepositoryInterface.php@  տh@  ek      D   vendor/composer/composer/src/Composer/Repository/RepositoryUtils.php
  տh
        P   vendor/composer/composer/src/Composer/Repository/RepositorySecurityException.php  տh  l	Ф      H   vendor/composer/composer/src/Composer/Repository/CompositeRepository.php  տh  $	)      D   vendor/composer/composer/src/Composer/Repository/ArrayRepository.phpw(  տhw(  x)      L   vendor/composer/composer/src/Composer/Repository/WritableArrayRepository.php	  տh	  X      B   vendor/composer/composer/src/Composer/Repository/VcsRepository.phpR  տhR  Bq      G   vendor/composer/composer/src/Composer/Repository/ComposerRepository.php1 տh1 h)      C   vendor/composer/composer/src/Composer/Repository/PearRepository.php`  տh`        B   vendor/composer/composer/src/Composer/Repository/RepositorySet.phpA  տhA  _O      G   vendor/composer/composer/src/Composer/Repository/ArtifactRepository.php  տh  e      J   vendor/composer/composer/src/Composer/Repository/RootPackageRepository.php:  տh:  V>      F   vendor/composer/composer/src/Composer/Repository/RepositoryManager.php  տh  nH      E   vendor/composer/composer/src/Composer/Repository/Vcs/GitHubDriver.phpZ  տhZ  U s      B   vendor/composer/composer/src/Composer/Repository/Vcs/VcsDriver.php  տh  rO      B   vendor/composer/composer/src/Composer/Repository/Vcs/SvnDriver.php3  տh3  ʍE      A   vendor/composer/composer/src/Composer/Repository/Vcs/HgDriver.php6  տh6         G   vendor/composer/composer/src/Composer/Repository/Vcs/PerforceDriver.php  տh  %6ɤ      K   vendor/composer/composer/src/Composer/Repository/Vcs/GitBitbucketDriver.php8  տh8  Mn      B   vendor/composer/composer/src/Composer/Repository/Vcs/GitDriver.php!  տh!  Zf      E   vendor/composer/composer/src/Composer/Repository/Vcs/GitLabDriver.php4R  տh4R  \6L      K   vendor/composer/composer/src/Composer/Repository/Vcs/VcsDriverInterface.php
  տh
  O
4ۤ      E   vendor/composer/composer/src/Composer/Repository/Vcs/FossilDriver.php\  տh\  b:      C   vendor/composer/composer/src/Composer/Repository/PathRepository.phpK"  տhK"  -Ƥ      J   vendor/composer/composer/src/Composer/Repository/VersionCacheInterface.phpd  տhd  ~      K   vendor/composer/composer/src/Composer/Repository/CanonicalPackagesTrait.php  տh  =      E   vendor/composer/composer/src/Composer/Repository/FilterRepository.php  տh  X      H   vendor/composer/composer/src/Composer/Repository/InstalledRepository.phpI3  տhI3  ̤      N   vendor/composer/composer/src/Composer/Repository/AdvisoryProviderInterface.php  տh  XD@      I   vendor/composer/composer/src/Composer/Repository/FilesystemRepository.php??  տh??  W      M   vendor/composer/composer/src/Composer/Repository/InstalledArrayRepository.php  տh  f~      T   vendor/composer/composer/src/Composer/Repository/ConfigurableRepositoryInterface.php  տh  F*'      O   vendor/composer/composer/src/Composer/Repository/InvalidRepositoryException.php  տh  f=      <   vendor/composer/composer/src/Composer/Util/PackageSorter.phpN  տhN  8
      >   vendor/composer/composer/src/Composer/Util/ConfigValidator.php[$  տh[$   zf      2   vendor/composer/composer/src/Composer/Util/Git.phpqi  տhqi        2   vendor/composer/composer/src/Composer/Util/Svn.php&  տh&  sH      =   vendor/composer/composer/src/Composer/Util/NoProxyPattern.php)  տh)  x      =   vendor/composer/composer/src/Composer/Util/ComposerMirror.phpW	  տhW	  ~w      :   vendor/composer/composer/src/Composer/Util/PackageInfo.phpA  տhA  #R      9   vendor/composer/composer/src/Composer/Util/AuthHelper.php8  տh8        2   vendor/composer/composer/src/Composer/Util/Zip.phpR
  տhR
  Aä      7   vendor/composer/composer/src/Composer/Util/Silencer.php/  տh/  <      9   vendor/composer/composer/src/Composer/Util/Filesystem.phpd{  տhd{  d}`      2   vendor/composer/composer/src/Composer/Util/Tar.php  տh  
Ǥ      5   vendor/composer/composer/src/Composer/Util/GitHub.php!  տh!  j\	v      5   vendor/composer/composer/src/Composer/Util/GitLab.php/  տh/  |!      8   vendor/composer/composer/src/Composer/Util/Bitbucket.php9&  տh9&  	ǽ      =   vendor/composer/composer/src/Composer/Util/HttpDownloader.php)H  տh)H  s%G      8   vendor/composer/composer/src/Composer/Util/IniHelper.phpm  տhm  7r      7   vendor/composer/composer/src/Composer/Util/Platform.php*  տh*  hP      C   vendor/composer/composer/src/Composer/Util/StreamContextFactory.php"  տh"  ?x      8   vendor/composer/composer/src/Composer/Util/TlsHelper.php  տh  5FϤ      2   vendor/composer/composer/src/Composer/Util/Url.php  տh  ʉ٤      7   vendor/composer/composer/src/Composer/Util/Perforce.php2L  տh2L  
Ǥ      @   vendor/composer/composer/src/Composer/Util/Http/ProxyManager.php  տh  ewY      <   vendor/composer/composer/src/Composer/Util/Http/Response.phpa  տha  ^      @   vendor/composer/composer/src/Composer/Util/Http/RequestProxy.php  տh  Mg      B   vendor/composer/composer/src/Composer/Util/Http/CurlDownloader.phpy  տhy  'B      @   vendor/composer/composer/src/Composer/Util/Http/CurlResponse.php  տh  1'ɤ      =   vendor/composer/composer/src/Composer/Util/Http/ProxyItem.php  տh  =eY      ?   vendor/composer/composer/src/Composer/Util/MetadataMinifier.php  տh  #`      >   vendor/composer/composer/src/Composer/Util/ProcessExecutor.phpE  տhE  5U      1   vendor/composer/composer/src/Composer/Util/Hg.php  տh  Q5      ?   vendor/composer/composer/src/Composer/Util/RemoteFilesystem.php?l  տh?l  q'      ;   vendor/composer/composer/src/Composer/Util/ErrorHandler.php,
  տh,
  JC      9   vendor/composer/composer/src/Composer/Util/SyncHelper.php
  տh
  ެpQ      3   vendor/composer/composer/src/Composer/Util/Loop.php2  տh2        A   vendor/composer/composer/src/Composer/Config/JsonConfigSource.phpv)  տhv)        F   vendor/composer/composer/src/Composer/Config/ConfigSourceInterface.phpf  տhf  (פ      =   vendor/composer/composer/src/Composer/SelfUpdate/Versions.php  տh  .]!      9   vendor/composer/composer/src/Composer/SelfUpdate/Keys.php  տh  -*      /   vendor/composer/composer/src/Composer/Cache.php+  տh+  @U      ?   vendor/composer/composer/src/Composer/EventDispatcher/Event.php  տh  ~ k      R   vendor/composer/composer/src/Composer/EventDispatcher/ScriptExecutionException.php  տh  ;;      I   vendor/composer/composer/src/Composer/EventDispatcher/EventDispatcher.php4  տh4  Dפ      R   vendor/composer/composer/src/Composer/EventDispatcher/EventSubscriberInterface.phpu  տhu  h_}      9   vendor/composer/composer/src/Composer/PartialComposer.php'
  տh'
  c      :   vendor/composer/composer/src/Composer/Platform/Runtime.php
	  տh
	  :K(      ?   vendor/composer/composer/src/Composer/Platform/HhvmDetector.php  տh  H껥      :   vendor/composer/composer/src/Composer/Platform/Version.php
  տh
  \      5   vendor/composer/composer/src/Composer/IO/BufferIO.php  տh  '˄      6   vendor/composer/composer/src/Composer/IO/ConsoleIO.phpK)  տhK)  51      3   vendor/composer/composer/src/Composer/IO/BaseIO.phpX#  տhX#        3   vendor/composer/composer/src/Composer/IO/NullIO.php	  տh	  {      8   vendor/composer/composer/src/Composer/IO/IOInterface.phpZ   տhZ   
      =   vendor/composer/composer/src/Composer/Plugin/PluginEvents.phpe  տhe  1+ˤ      C   vendor/composer/composer/src/Composer/Plugin/PreCommandRunEvent.php2  տh2  :q@      K   vendor/composer/composer/src/Composer/Plugin/Capability/CommandProvider.php  տh  d,      F   vendor/composer/composer/src/Composer/Plugin/Capability/Capability.php  տh  Lk      G   vendor/composer/composer/src/Composer/Plugin/PluginBlockedException.php  տh  Nu      =   vendor/composer/composer/src/Composer/Plugin/CommandEvent.phpy  տhy  /      @   vendor/composer/composer/src/Composer/Plugin/PluginInterface.php?  տh?  #?"      >   vendor/composer/composer/src/Composer/Plugin/PluginManager.phpP  տhP  .r      E   vendor/composer/composer/src/Composer/Plugin/PreFileDownloadEvent.php9  տh9        F   vendor/composer/composer/src/Composer/Plugin/PostFileDownloadEvent.php
  տh
        8   vendor/composer/composer/src/Composer/Plugin/Capable.php  տh  u      C   vendor/composer/composer/src/Composer/Plugin/PrePoolCreateEvent.php  տh  H      B   vendor/composer/composer/src/Composer/Downloader/RarDownloader.php	  տh	  "Ĥ      R   vendor/composer/composer/src/Composer/Downloader/VcsCapableDownloaderInterface.phpC  տhC  H      B   vendor/composer/composer/src/Composer/Downloader/VcsDownloader.php4  տh4  \4=      H   vendor/composer/composer/src/Composer/Downloader/FilesystemException.php  տh  J      D   vendor/composer/composer/src/Composer/Downloader/DownloadManager.phpR<  տhR<  H      B   vendor/composer/composer/src/Composer/Downloader/TarDownloader.php  տh  K7J      E   vendor/composer/composer/src/Composer/Downloader/FossilDownloader.php  տh  WΤ      Q   vendor/composer/composer/src/Composer/Downloader/MaxFileSizeExceededException.php  տh  `ܤ      H   vendor/composer/composer/src/Composer/Downloader/DownloaderInterface.php  տh  x      A   vendor/composer/composer/src/Composer/Downloader/XzDownloader.phpQ  տhQ  aYŤ      A   vendor/composer/composer/src/Composer/Downloader/HgDownloader.php  տh  p      B   vendor/composer/composer/src/Composer/Downloader/SvnDownloader.php"  տh"  rv      C   vendor/composer/composer/src/Composer/Downloader/FileDownloader.phpCS  տhCS  R      J   vendor/composer/composer/src/Composer/Downloader/ChangeReportInterface.php'  տh'  }s$      G   vendor/composer/composer/src/Composer/Downloader/TransportException.php  տh  ʤ      F   vendor/composer/composer/src/Composer/Downloader/ArchiveDownloader.php!  տh!  {Z      L   vendor/composer/composer/src/Composer/Downloader/DvcsDownloaderInterface.php6  տh6  1N}      C   vendor/composer/composer/src/Composer/Downloader/PharDownloader.php  տh  /&֤      C   vendor/composer/composer/src/Composer/Downloader/PathDownloader.php6  տh6  ,_      G   vendor/composer/composer/src/Composer/Downloader/PerforceDownloader.php
  տh
  R.      B   vendor/composer/composer/src/Composer/Downloader/GitDownloader.phpa  տha  5Ȥ      B   vendor/composer/composer/src/Composer/Downloader/ZipDownloader.phpL9  տhL9  0      C   vendor/composer/composer/src/Composer/Downloader/GzipDownloader.php  տh  S      0   vendor/composer/composer/src/Composer/Config.phpCa  տhCa  ~s      6   vendor/composer/composer/src/Composer/Script/Event.php  տh  D]      =   vendor/composer/composer/src/Composer/Script/ScriptEvents.php  տh  KGꮤ      M   vendor/composer/composer/src/Composer/Question/StrictConfirmationQuestion.php  տh  `a      2   vendor/composer/composer/src/Composer/Composer.php  տh  o]Ƥ      F   vendor/composer/composer/src/Composer/Json/JsonValidationException.phpl  տhl  exˤ      <   vendor/composer/composer/src/Composer/Json/JsonFormatter.phpe  տhe        7   vendor/composer/composer/src/Composer/Json/JsonFile.php3  տh3  N      >   vendor/composer/composer/src/Composer/Json/JsonManipulator.php8S  տh8S  WT      ;   vendor/composer/composer/src/Composer/InstalledVersions.phpIB  տhIB   "      W   vendor/composer/composer/src/Composer/DependencyResolver/Operation/InstallOperation.phpz  տhz  =~i      b   vendor/composer/composer/src/Composer/DependencyResolver/Operation/MarkAliasInstalledOperation.phpx  տhx  nҤ      Y   vendor/composer/composer/src/Composer/DependencyResolver/Operation/OperationInterface.php  տh  }|(̤      V   vendor/composer/composer/src/Composer/DependencyResolver/Operation/UpdateOperation.phpw  տhw  c;      V   vendor/composer/composer/src/Composer/DependencyResolver/Operation/SolverOperation.php  տh  Iw      Y   vendor/composer/composer/src/Composer/DependencyResolver/Operation/UninstallOperation.phpb  տhb  &Yl      d   vendor/composer/composer/src/Composer/DependencyResolver/Operation/MarkAliasUninstalledOperation.php~  տh~        H   vendor/composer/composer/src/Composer/DependencyResolver/Transaction.php8  տh8  |Ԥ      L   vendor/composer/composer/src/Composer/DependencyResolver/PolicyInterface.php  տh         Q   vendor/composer/composer/src/Composer/DependencyResolver/LocalRepoTransaction.php(  տh(  tʺ      K   vendor/composer/composer/src/Composer/DependencyResolver/RuleWatchGraph.phpA  տhA  >      H   vendor/composer/composer/src/Composer/DependencyResolver/GenericRule.php  տh  >>MV      L   vendor/composer/composer/src/Composer/DependencyResolver/LockTransaction.php  տh  h      C   vendor/composer/composer/src/Composer/DependencyResolver/Solver.phph  տhh  s      A   vendor/composer/composer/src/Composer/DependencyResolver/Rule.phpN  տhN  d ۤ      J   vendor/composer/composer/src/Composer/DependencyResolver/Rule2Literals.php
  տh
  dײ      T   vendor/composer/composer/src/Composer/DependencyResolver/SolverProblemsException.php  տh  18M      O   vendor/composer/composer/src/Composer/DependencyResolver/SolverBugException.php  տh  /d      J   vendor/composer/composer/src/Composer/DependencyResolver/DefaultPolicy.php(  տh(  
8      J   vendor/composer/composer/src/Composer/DependencyResolver/RuleWatchNode.php  տh  '      D   vendor/composer/composer/src/Composer/DependencyResolver/RuleSet.phpX  տhX  q      A   vendor/composer/composer/src/Composer/DependencyResolver/Pool.php   տh   ?6lJ      N   vendor/composer/composer/src/Composer/DependencyResolver/MultiConflictRule.phpq  տhq  S8e      D   vendor/composer/composer/src/Composer/DependencyResolver/Request.php!  տh!  1      J   vendor/composer/composer/src/Composer/DependencyResolver/PoolOptimizer.phpM  տhM  	zA      M   vendor/composer/composer/src/Composer/DependencyResolver/RuleSetGenerator.php6  տh6  w      F   vendor/composer/composer/src/Composer/DependencyResolver/Decisions.php  տh  Q      H   vendor/composer/composer/src/Composer/DependencyResolver/PoolBuilder.php  տh  	dA"      D   vendor/composer/composer/src/Composer/DependencyResolver/Problem.php-  տh-  3C      L   vendor/composer/composer/src/Composer/DependencyResolver/RuleSetIterator.phpC
  տhC
  r      K   vendor/composer/composer/src/Composer/DependencyResolver/RuleWatchChain.php  տh  ]      D   vendor/composer/composer/src/Composer/Autoload/AutoloadGenerator.phpM  տhM  pN      >   vendor/composer/composer/src/Composer/Autoload/ClassLoader.phpg>  տhg>  v      D   vendor/composer/composer/src/Composer/Autoload/ClassMapGenerator.php  տh  I%c       A   vendor/composer/composer/src/Composer/Command/SuggestsCommand.php;  տh;  :&|      ?   vendor/composer/composer/src/Composer/Command/SearchCommand.php  տh  k^      =   vendor/composer/composer/src/Composer/Command/BumpCommand.php&  տh&  r      @   vendor/composer/composer/src/Composer/Command/ArchiveCommand.php*!  տh*!  sM      >   vendor/composer/composer/src/Composer/Command/AuditCommand.php3  տh3  jl      A   vendor/composer/composer/src/Composer/Command/ValidateCommand.phpm$  տhm$  撌r      =   vendor/composer/composer/src/Composer/Command/FundCommand.php  տh  {      G   vendor/composer/composer/src/Composer/Command/PackageDiscoveryTrait.phpO  տhO  G:      D   vendor/composer/composer/src/Composer/Command/ScriptAliasCommand.php
  տh
  \       F   vendor/composer/composer/src/Composer/Command/CreateProjectCommand.php^  տh^  4Ѥ      =   vendor/composer/composer/src/Composer/Command/BaseCommand.phpB  տhB  ?a      A   vendor/composer/composer/src/Composer/Command/OutdatedCommand.phpB  տhB  G      E   vendor/composer/composer/src/Composer/Command/DumpAutoloadCommand.php  տh        =   vendor/composer/composer/src/Composer/Command/HomeCommand.phpC  տhC  rj      B   vendor/composer/composer/src/Composer/Command/ReinstallCommand.php#  տh#  "       ?   vendor/composer/composer/src/Composer/Command/RemoveCommand.php;  տh;        =   vendor/composer/composer/src/Composer/Command/ShowCommand.php% տh% 	EO      @   vendor/composer/composer/src/Composer/Command/InstallCommand.php  տh  
q      =   vendor/composer/composer/src/Composer/Command/InitCommand.php([  տh([  (!#ͤ      B   vendor/composer/composer/src/Composer/Command/RunScriptCommand.php  տh  rm      ?   vendor/composer/composer/src/Composer/Command/ConfigCommand.phpȜ  տhȜ  J瑤      A   vendor/composer/composer/src/Composer/Command/LicensesCommand.php  տh  8$䂤      ?   vendor/composer/composer/src/Composer/Command/UpdateCommand.phpeN  տheN  J(      ?   vendor/composer/composer/src/Composer/Command/StatusCommand.php{   տh{   C      G   vendor/composer/composer/src/Composer/Command/BaseDependencyCommand.php3  տh3        @   vendor/composer/composer/src/Composer/Command/DependsCommand.php  տh  vN      B   vendor/composer/composer/src/Composer/Command/ProhibitsCommand.php  տh   &      J   vendor/composer/composer/src/Composer/Command/CheckPlatformReqsCommand.php  տh  Yj      C   vendor/composer/composer/src/Composer/Command/SelfUpdateCommand.phpi  տhi        @   vendor/composer/composer/src/Composer/Command/RequireCommand.phps  տhs  ^;      A   vendor/composer/composer/src/Composer/Command/CompletionTrait.php#  տh#  "i      C   vendor/composer/composer/src/Composer/Command/ClearCacheCommand.phpX
  տhX
  (      A   vendor/composer/composer/src/Composer/Command/DiagnoseCommand.phpF  տhF  Þ      ?   vendor/composer/composer/src/Composer/Command/GlobalCommand.php  տh  ~i      >   vendor/composer/composer/src/Composer/Command/AboutCommand.php  տh  
      =   vendor/composer/composer/src/Composer/Command/ExecCommand.php>  տh>  Ƙi      3   vendor/composer/composer/src/Composer/Installer.php  տh  MI      m   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/PlatformRequirementFilterInterface.php  տh         m   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/IgnoreAllPlatformRequirementFilter.php  տh  u      n   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/IgnoreListPlatformRequirementFilter.php  տh  f      q   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/IgnoreNothingPlatformRequirementFilter.php  տh  u      k   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/PlatformRequirementFilterFactory.php  տh  $¤      A   vendor/composer/composer/src/Composer/Installer/PackageEvents.php"  տh"  ]m      C   vendor/composer/composer/src/Composer/Installer/BinaryInstaller.php8  տh8  b>      C   vendor/composer/composer/src/Composer/Installer/PluginInstaller.phpw  տhw  0\      K   vendor/composer/composer/src/Composer/Installer/BinaryPresenceInterface.php  տh  <P      C   vendor/composer/composer/src/Composer/Installer/InstallerEvents.php  տh  "e      @   vendor/composer/composer/src/Composer/Installer/PackageEvent.php  տh  T      B   vendor/composer/composer/src/Composer/Installer/InstallerEvent.php  տh  r>      D   vendor/composer/composer/src/Composer/Installer/LibraryInstaller.php&,  տh&,        F   vendor/composer/composer/src/Composer/Installer/InstallerInterface.php1  տh1  K;      H   vendor/composer/composer/src/Composer/Installer/MetapackageInstaller.php  տh  ն٤      D   vendor/composer/composer/src/Composer/Installer/ProjectInstaller.php
  տh
        M   vendor/composer/composer/src/Composer/Installer/SuggestedPackagesReporter.php  տh  vӤ      G   vendor/composer/composer/src/Composer/Installer/InstallationManager.php`  տh`  @!      A   vendor/composer/composer/src/Composer/Installer/NoopInstaller.phpY  տhY  ^.      C   vendor/composer/composer/src/Composer/Advisory/SecurityAdvisory.php  տh  ݭ      J   vendor/composer/composer/src/Composer/Advisory/PartialSecurityAdvisory.php  տh  u      :   vendor/composer/composer/src/Composer/Advisory/Auditor.php=  տh=  ̶Ҥ      J   vendor/composer/composer/src/Composer/Advisory/IgnoredSecurityAdvisory.phpk  տhk  K`      R   vendor/composer/composer/src/Composer/Exception/IrrecoverableDownloadException.php  տh        B   vendor/composer/composer/src/Composer/Exception/NoSslException.php  տh  ;P      2   vendor/composer/composer/src/Composer/Compiler.php-  տh-  zq      9   vendor/composer/composer/src/Composer/Package/Package.phpD  տhD  i?f      6   vendor/composer/composer/src/Composer/Package/Link.php
  տh
  +H      J   vendor/composer/composer/src/Composer/Package/CompletePackageInterface.php  տh  }{+      I   vendor/composer/composer/src/Composer/Package/Archiver/ArchiveManager.php$  տh$        P   vendor/composer/composer/src/Composer/Package/Archiver/ArchivableFilesFinder.phpq  տhq  ߶q      G   vendor/composer/composer/src/Composer/Package/Archiver/PharArchiver.php  տh  ǁM      L   vendor/composer/composer/src/Composer/Package/Archiver/BaseExcludeFilter.php  տh  @ݤ      P   vendor/composer/composer/src/Composer/Package/Archiver/ArchivableFilesFilter.php  տh  ߵ      K   vendor/composer/composer/src/Composer/Package/Archiver/GitExcludeFilter.php  տh  ^      P   vendor/composer/composer/src/Composer/Package/Archiver/ComposerExcludeFilter.php  տh  ޣ      L   vendor/composer/composer/src/Composer/Package/Archiver/ArchiverInterface.php  տh  ;w      F   vendor/composer/composer/src/Composer/Package/Archiver/ZipArchiver.php  տh  L      F   vendor/composer/composer/src/Composer/Package/CompleteAliasPackage.php  տh  lN(      >   vendor/composer/composer/src/Composer/Package/AliasPackage.phpe'  տhe'  Ҥ      8   vendor/composer/composer/src/Composer/Package/Locker.php/X  տh/X        B   vendor/composer/composer/src/Composer/Package/PackageInterface.php00  տh00  "'      G   vendor/composer/composer/src/Composer/Package/Version/VersionBumper.phpS  տhS  p      I   vendor/composer/composer/src/Composer/Package/Version/StabilityFilter.php  տh  5      H   vendor/composer/composer/src/Composer/Package/Version/VersionGuesser.phpWH  տhWH  kS      I   vendor/composer/composer/src/Composer/Package/Version/VersionSelector.php0  տh0  
      G   vendor/composer/composer/src/Composer/Package/Version/VersionParser.php  տh  
?      N   vendor/composer/composer/src/Composer/Package/Loader/ValidatingArrayLoader.phpu  տhu  _U      P   vendor/composer/composer/src/Composer/Package/Loader/InvalidPackageException.phpo  տho  ,Ҥ      D   vendor/composer/composer/src/Composer/Package/Loader/ArrayLoader.phpF  տhF  W
      H   vendor/composer/composer/src/Composer/Package/Loader/LoaderInterface.phpj  տhj  7      J   vendor/composer/composer/src/Composer/Package/Loader/RootPackageLoader.phpO.  տhO.  pk      C   vendor/composer/composer/src/Composer/Package/Loader/JsonLoader.phpc  տhc  ܝ@      =   vendor/composer/composer/src/Composer/Package/BasePackage.php  տh  $8      C   vendor/composer/composer/src/Composer/Package/Comparer/Comparer.php  տh  fɋ      B   vendor/composer/composer/src/Composer/Package/RootAliasPackage.php  տh  r      A   vendor/composer/composer/src/Composer/Package/CompletePackage.php@  տh@  ew      F   vendor/composer/composer/src/Composer/Package/RootPackageInterface.php  տh  S      =   vendor/composer/composer/src/Composer/Package/RootPackage.phpZ  տhZ  k      D   vendor/composer/composer/src/Composer/Package/Dumper/ArrayDumper.php  տh  )=      =   vendor/composer/composer/src/Composer/Console/Application.php$  տh$  d      C   vendor/composer/composer/src/Composer/Console/GithubActionError.phpl  տhl  g`+      E   vendor/composer/composer/src/Composer/Console/Input/InputArgument.php
  տh
  &o      C   vendor/composer/composer/src/Composer/Console/Input/InputOption.php  տh  (C      E   vendor/composer/composer/src/Composer/Console/HtmlOutputFormatter.php1  տh1  g?Ѥ      *   vendor/composer/composer/src/bootstrap.php7  տh7  t      (   vendor/composer/ca-bundle/res/cacert.pemf տhf 7n      !   vendor/composer/ca-bundle/LICENSE  տh  *!^`      #   vendor/composer/ca-bundle/README.md1  տh1  >VuĤ      '   vendor/composer/ca-bundle/composer.json5  տh5  y:      *   vendor/composer/ca-bundle/src/CaBundle.phpE+  տhE+  &V      !   vendor/composer/autoload_psr4.php  տh        %   vendor/composer/autoload_classmap.php տh ̢      "   vendor/composer/platform_check.php  տh        #   vendor/composer/autoload_static.phpH տhH -;      !   vendor/composer/autoload_real.php  տh  Ӥ         vendor/composer/semver/LICENSE  տh  Bh      #   vendor/composer/semver/CHANGELOG.mdi'  տhi'  [L          vendor/composer/semver/README.mdH
  տhH
   }Τ      $   vendor/composer/semver/composer.json  տh  z)      /   vendor/composer/semver/src/CompilingMatcher.php
  տh
  F      '   vendor/composer/semver/src/Interval.phpu  տhu         )   vendor/composer/semver/src/Comparator.php<
  տh<
  <L      (   vendor/composer/semver/src/Intervals.phpLP  տhLP  K.      %   vendor/composer/semver/src/Semver.phpr
  տhr
  Τ      ,   vendor/composer/semver/src/VersionParser.phpSU  տhSU  <J?F      =   vendor/composer/semver/src/Constraint/ConstraintInterface.php  տh  겤      9   vendor/composer/semver/src/Constraint/MultiConstraint.php#  տh#  o      4   vendor/composer/semver/src/Constraint/Constraint.php2  տh2  *      <   vendor/composer/semver/src/Constraint/MatchAllConstraint.php,  տh,  [j<      =   vendor/composer/semver/src/Constraint/MatchNoneConstraint.php(  տh(  h      /   vendor/composer/semver/src/Constraint/Bound.php
  տh
        "   vendor/composer/autoload_files.phpD  տhD  VV2      %   vendor/composer/InstalledVersions.phpC  տhC  Ȱ         vendor/composer/installed.phpGa  տhGa  D֫         vendor/composer/pcre/LICENSE  տh  hg^         vendor/composer/pcre/README.md!  տh!  B      #   vendor/composer/pcre/extension.neon  տh  &&1      "   vendor/composer/pcre/composer.json  տh  r7      E   vendor/composer/pcre/src/PHPStan/PregMatchTypeSpecifyingExtension.php  տh  UJl      L   vendor/composer/pcre/src/PHPStan/PregReplaceCallbackClosureTypeExtension.php`
  տh`
  |~      G   vendor/composer/pcre/src/PHPStan/PregMatchParameterOutTypeExtension.php  տh        <   vendor/composer/pcre/src/PHPStan/InvalidRegexPatternRule.phpV  տhV   r      3   vendor/composer/pcre/src/PHPStan/PregMatchFlags.php		  տh		  wD3B      ?   vendor/composer/pcre/src/PHPStan/UnsafeStrictGroupsCallRule.php
  տh
  tCs      (   vendor/composer/pcre/src/MatchResult.php  տh  ڇҤ      "   vendor/composer/pcre/src/Regex.php  տh  ɤ      6   vendor/composer/pcre/src/MatchAllWithOffsetsResult.php  տh        3   vendor/composer/pcre/src/MatchWithOffsetsResult.php  տh  o      7   vendor/composer/pcre/src/MatchAllStrictGroupsResult.phpw  տhw  Q      9   vendor/composer/pcre/src/UnexpectedNullMatchException.php"  տh"  _      4   vendor/composer/pcre/src/MatchStrictGroupsResult.php  տh        +   vendor/composer/pcre/src/MatchAllResult.php  տh  	Z      *   vendor/composer/pcre/src/ReplaceResult.php  տh  /      !   vendor/composer/pcre/src/Preg.phpE  տhE  ]G      *   vendor/composer/pcre/src/PcreException.phpw  տhw  'v      )   vendor/composer/metadata-minifier/LICENSE  տh  hg^      +   vendor/composer/metadata-minifier/README.mdL  տhL  Mv<      3   vendor/composer/metadata-minifier/phpstan.neon.distB   տhB   #f      /   vendor/composer/metadata-minifier/composer.json  տh  D0פ      :   vendor/composer/metadata-minifier/src/MetadataMinifier.php
  տh
         6   vendor/composer/spdx-licenses/res/spdx-exceptions.json  տh  L(      4   vendor/composer/spdx-licenses/res/spdx-licenses.json! տh!       %   vendor/composer/spdx-licenses/LICENSE  տh  Bh      '   vendor/composer/spdx-licenses/README.md<  տh<  se      +   vendor/composer/spdx-licenses/composer.json  տh  Ť      2   vendor/composer/spdx-licenses/src/SpdxLicenses.php%  տh%  ]H
      .   vendor/phpdocumentor/reflection-common/LICENSE9  տh9  *2Ȑ      0   vendor/phpdocumentor/reflection-common/README.mdO  տhO  
һ      4   vendor/phpdocumentor/reflection-common/composer.json  տh  k6      6   vendor/phpdocumentor/reflection-common/src/Element.php  տh  7      =   vendor/phpdocumentor/reflection-common/src/ProjectFactory.phpf  տhf        3   vendor/phpdocumentor/reflection-common/src/File.php  տh  s      6   vendor/phpdocumentor/reflection-common/src/Project.php  տh  c=      4   vendor/phpdocumentor/reflection-common/src/Fqsen.php  տh  p      7   vendor/phpdocumentor/reflection-common/src/Location.php  տh  ;      *   vendor/phpdocumentor/type-resolver/LICENSE8  տh8  ʤ      2   vendor/phpdocumentor/type-resolver/phpdoc.dist.xml  տh  DA낤      ,   vendor/phpdocumentor/type-resolver/README.md#  տh#  ܵ\      0   vendor/phpdocumentor/type-resolver/composer.json  տh  \[      7   vendor/phpdocumentor/type-resolver/src/TypeResolver.phpc]  տhc]  v      ;   vendor/phpdocumentor/type-resolver/src/Types/Expression.phpF  տhF  PM      8   vendor/phpdocumentor/type-resolver/src/Types/Boolean.php|  տh|  M65      8   vendor/phpdocumentor/type-resolver/src/Types/Integer.phpx  տhx  jJ&      6   vendor/phpdocumentor/type-resolver/src/Types/Self_.php  տh  SY      6   vendor/phpdocumentor/type-resolver/src/Types/Void_.php  տh  Dk'٤      6   vendor/phpdocumentor/type-resolver/src/Types/Null_.php  տh  G      :   vendor/phpdocumentor/type-resolver/src/Types/Resource_.php  տh  JϤ      7   vendor/phpdocumentor/type-resolver/src/Types/Float_.phpu  տhu  Hդ      8   vendor/phpdocumentor/type-resolver/src/Types/Object_.php  տh  "]!      8   vendor/phpdocumentor/type-resolver/src/Types/String_.php  տh  V̤      9   vendor/phpdocumentor/type-resolver/src/Types/Nullable.php`  տh`  uy      :   vendor/phpdocumentor/type-resolver/src/Types/Callable_.php  տh  l      @   vendor/phpdocumentor/type-resolver/src/Types/InterfaceString.php  տh  >^      :   vendor/phpdocumentor/type-resolver/src/Types/Iterable_.phpF  տhF   'y      B   vendor/phpdocumentor/type-resolver/src/Types/CallableParameter.php  տh  /      9   vendor/phpdocumentor/type-resolver/src/Types/ArrayKey.php  տh  ?n)      7   vendor/phpdocumentor/type-resolver/src/Types/Never_.php  տh  	'      8   vendor/phpdocumentor/type-resolver/src/Types/Static_.php  տh  {6@      <   vendor/phpdocumentor/type-resolver/src/Types/ClassString.php_  տh_  g      8   vendor/phpdocumentor/type-resolver/src/Types/Parent_.php  տh  ip      7   vendor/phpdocumentor/type-resolver/src/Types/Scalar.php  տh  ؤ      8   vendor/phpdocumentor/type-resolver/src/Types/Context.php  տh  fYK      =   vendor/phpdocumentor/type-resolver/src/Types/AbstractList.php  տh  &      ;   vendor/phpdocumentor/type-resolver/src/Types/Collection.php  տh  䅝      =   vendor/phpdocumentor/type-resolver/src/Types/Intersection.php$  տh$        ?   vendor/phpdocumentor/type-resolver/src/Types/ContextFactory.php7  տh7  v#      ?   vendor/phpdocumentor/type-resolver/src/Types/AggregatedType.php
  տh
  C`      9   vendor/phpdocumentor/type-resolver/src/Types/Compound.php  տh        5   vendor/phpdocumentor/type-resolver/src/Types/This.phpg  տhg  ~+6      7   vendor/phpdocumentor/type-resolver/src/Types/Array_.php  տh   NK      7   vendor/phpdocumentor/type-resolver/src/Types/Mixed_.php  տh        /   vendor/phpdocumentor/type-resolver/src/Type.php  տh  q4      8   vendor/phpdocumentor/type-resolver/src/FqsenResolver.php	  տh	  ͢      B   vendor/phpdocumentor/type-resolver/src/PseudoTypes/StringValue.php  տh  FI      <   vendor/phpdocumentor/type-resolver/src/PseudoTypes/List_.php  տh  O      E   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NonEmptyString.php}  տh}   i      @   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ShapeItem.php+  տh+  NG      C   vendor/phpdocumentor/type-resolver/src/PseudoTypes/IntegerRange.phpA  տhA  ֭Z$      E   vendor/phpdocumentor/type-resolver/src/PseudoTypes/CallableString.php|  տh|        D   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ListShapeItem.php   տh   곤      ?   vendor/phpdocumentor/type-resolver/src/PseudoTypes/Numeric_.php(  տh(  ^6      =   vendor/phpdocumentor/type-resolver/src/PseudoTypes/False_.php  տh  /      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ObjectShapeItem.php   տh   IC3      B   vendor/phpdocumentor/type-resolver/src/PseudoTypes/TraitString.phpv  տhv  {      A   vendor/phpdocumentor/type-resolver/src/PseudoTypes/FloatValue.php  տh  4AY      D   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NumericString.phpz  տhz  *      H   vendor/phpdocumentor/type-resolver/src/PseudoTypes/HtmlEscapedString.php  տh  y"Ѥ      C   vendor/phpdocumentor/type-resolver/src/PseudoTypes/IntegerValue.php  տh  R4      D   vendor/phpdocumentor/type-resolver/src/PseudoTypes/LiteralString.phpz  տhz        C   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NonEmptyList.php  տh  I      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ConstExpression.php  տh  oe4      A   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ArrayShape.php  տh  frd      N   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NonEmptyLowercaseString.php  տh        D   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NonEmptyArray.php  տh  ,      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/LowercaseString.php~  տh~  kc      <   vendor/phpdocumentor/type-resolver/src/PseudoTypes/True_.php  տh  W      @   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ListShape.php3  տh3  p      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NegativeInteger.phpw  տhw  p      E   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ArrayShapeItem.phpe  տhe  7      B   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ObjectShape.phpM  տhM  *9      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/PositiveInteger.phpw  տhw  .      5   vendor/phpdocumentor/type-resolver/src/PseudoType.php|  տh|  }      0   vendor/phpdocumentor/reflection-docblock/LICENSE8  տh8  ʤ      2   vendor/phpdocumentor/reflection-docblock/README.md  տh  }      6   vendor/phpdocumentor/reflection-docblock/composer.json  տh        @   vendor/phpdocumentor/reflection-docblock/src/DocBlockFactory.php0  տh0  O?&      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Serializer.phpH  տhH  gդ      G   vendor/phpdocumentor/reflection-docblock/src/DocBlock/ExampleFinder.phpI  տhI  	T      =   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tag.php  տh  ῤ      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/TagFactory.php
  տh
  ROJ      L   vendor/phpdocumentor/reflection-docblock/src/DocBlock/DescriptionFactory.php<  տh<  FJ      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Since.php
  տh
  ,      L   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/PropertyWrite.php  տh  ֻ      N   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/MethodParameter.php  տh  K銤      C   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Link.php  տh  j
      I   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/InvalidTag.phpx  տhx  Vj      F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/BaseTag.php  տh  y{      C   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Var_.php  տh  x֤      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Param.php9  տh9  ֩      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Mixin.php  տh        P   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/TemplateCovariant.php  տh  ͤ      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Method.php'  տh'  ʤ      H   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Formatter.php,  տh,  <c      C   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Uses.phpV
  տhV
  .Ѥ      F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Return_.php  տh  }þ      ]   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Formatter/PassthroughFormatter.php  տh  ZL      W   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Formatter/AlignFormatter.php  տh  e&A      Q   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/TemplateImplements.php  տh  r      K   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/PropertyRead.php  տh  )r      G   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Property.php  տh  q}      F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Version.php
  տh
  .2      B   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/See.php5  տh5  
      G   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Extends_.php,  տh,  gE      F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Generic.php	  տh	        J   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/TagWithType.php	  տh	  _UG      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Source.php  տh  cM      G   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Template.phpM	  տhM	        J   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Implements_.php5  տh5  q      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Author.php	  տh	  8"      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Throws.php  տh        X   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/ImplementsFactory.php  տh  5      N   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/Factory.phpJ  տhJ  \Τ      Z   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/PropertyReadFactory.php*  տh*  )܈      U   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/ExtendsFactory.php  տh  if      S   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/StaticMethod.php%  տh%  cTg      ]   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/AbstractPHPStanFactory.php  տh  )9      [   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/PropertyWriteFactory.php.  տh.  k      Q   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/VarFactory.php  տh  $      T   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/MethodFactory.phpC
  տhC
  [<      V   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/TemplateFactory.phpJ  տhJ  !rs      `   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/TemplateImplementsFactory.php  տh  {׮      S   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/ParamFactory.php  տh  j      ]   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/MethodParameterFactory.phpN	  տhN	  ^E      U   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/PHPStanFactory.php  տh  gɉ      ]   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/TemplateExtendsFactory.php  տh  %?      V   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/PropertyFactory.php  տh  dB      T   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/ReturnFactory.php  տh  z      R   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Reference/Reference.php  տh  g      L   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Reference/Url.php  տh  ޛ      N   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Reference/Fqsen.php*  տh*        N   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/TemplateExtends.php  տh        F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Example.php  տh  c      I   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Deprecated.php  տh  v      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Covers.php
  տh
  
C      L   vendor/phpdocumentor/reflection-docblock/src/DocBlock/StandardTagFactory.php4  տh4  ~      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Description.php<  տh<  TT|      6   vendor/phpdocumentor/reflection-docblock/src/Utils.php	  տh	  Ԥ      I   vendor/phpdocumentor/reflection-docblock/src/DocBlockFactoryInterface.php  տh  δ      9   vendor/phpdocumentor/reflection-docblock/src/DocBlock.php  տh  Zr      H   vendor/phpdocumentor/reflection-docblock/src/Exception/PcreException.php  տh  ~	g      1   vendor/paragonie/constant_time_encoding/README.md~
  տh~
  uLR      3   vendor/paragonie/constant_time_encoding/LICENSE.txte	  տhe	  |[      5   vendor/paragonie/constant_time_encoding/composer.json  տh  `Zo>      =   vendor/paragonie/constant_time_encoding/src/Base64UrlSafe.phpm  տhm  W}¤      9   vendor/paragonie/constant_time_encoding/src/Base32Hex.php9
  տh9
  fm      >   vendor/paragonie/constant_time_encoding/src/Base64DotSlash.php  տh  %o      8   vendor/paragonie/constant_time_encoding/src/Encoding.php,  տh,  R2~      @   vendor/paragonie/constant_time_encoding/src/EncoderInterface.php  տh  s:      6   vendor/paragonie/constant_time_encoding/src/Base32.php<  տh<  $HC      3   vendor/paragonie/constant_time_encoding/src/Hex.php  տh  bFǤ      E   vendor/paragonie/constant_time_encoding/src/Base64DotSlashOrdered.php
  տh
  ?Na      6   vendor/paragonie/constant_time_encoding/src/Binary.php
  տh
  ތ      7   vendor/paragonie/constant_time_encoding/src/RFC4648.php  տh        6   vendor/paragonie/constant_time_encoding/src/Base64.phpc$  տhc$  K      #   vendor/spomky-labs/cbor-php/LICENSE,  տh,  C      %   vendor/spomky-labs/cbor-php/README.md[+  տh[+        )   vendor/spomky-labs/cbor-php/composer.json[  տh[  n*      '   vendor/spomky-labs/cbor-php/SECURITY.md  տh  Ǥ      0   vendor/spomky-labs/cbor-php/src/StringStream.phpy  տhy  .      :   vendor/spomky-labs/cbor-php/src/OtherObject/TrueObject.php  տh  b1F      ;   vendor/spomky-labs/cbor-php/src/OtherObject/BreakObject.phpX  տhX  &c      D   vendor/spomky-labs/cbor-php/src/OtherObject/OtherObjectInterface.phpt  տht  аȤ      J   vendor/spomky-labs/cbor-php/src/OtherObject/SinglePrecisionFloatObject.phpQ  տhQ  t      =   vendor/spomky-labs/cbor-php/src/OtherObject/GenericObject.php  տh  ku5      ;   vendor/spomky-labs/cbor-php/src/OtherObject/FalseObject.php  տh  =
      ?   vendor/spomky-labs/cbor-php/src/OtherObject/UndefinedObject.phpd  տhd  IM(      J   vendor/spomky-labs/cbor-php/src/OtherObject/DoublePrecisionFloatObject.php  տh  ]      K   vendor/spomky-labs/cbor-php/src/OtherObject/OtherObjectManagerInterface.php   տh   I      H   vendor/spomky-labs/cbor-php/src/OtherObject/HalfPrecisionFloatObject.phpq  տhq  WF       <   vendor/spomky-labs/cbor-php/src/OtherObject/SimpleObject.php	  տh	  :j      :   vendor/spomky-labs/cbor-php/src/OtherObject/NullObject.php  տh  .      B   vendor/spomky-labs/cbor-php/src/OtherObject/OtherObjectManager.php~  տh~  =*F      4   vendor/spomky-labs/cbor-php/src/DecoderInterface.php   տh   \f      4   vendor/spomky-labs/cbor-php/src/ByteStringObject.php  տh  Bl      D   vendor/spomky-labs/cbor-php/src/IndefiniteLengthTextStringObject.php*  տh*  `갤      '   vendor/spomky-labs/cbor-php/src/Tag.phpc  տhc  }      +   vendor/spomky-labs/cbor-php/src/Decoder.php#  տh#  Yu      9   vendor/spomky-labs/cbor-php/src/UnsignedIntegerObject.php  տh  򽩜      6   vendor/spomky-labs/cbor-php/src/AbstractCBORObject.phpY  տhY  @z>      0   vendor/spomky-labs/cbor-php/src/Normalizable.php   տh   xӤ      4   vendor/spomky-labs/cbor-php/src/LengthCalculator.php|  տh|  N`      /   vendor/spomky-labs/cbor-php/src/OtherObject.php  տh  ?73      *   vendor/spomky-labs/cbor-php/src/Stream.php   տh   $c      4   vendor/spomky-labs/cbor-php/src/TextStringObject.php  տh  1aM      D   vendor/spomky-labs/cbor-php/src/IndefiniteLengthByteStringObject.php3  տh3  Q      >   vendor/spomky-labs/cbor-php/src/IndefiniteLengthListObject.php  տh  cR¤      =   vendor/spomky-labs/cbor-php/src/IndefiniteLengthMapObject.php  տh  y8      +   vendor/spomky-labs/cbor-php/src/MapItem.php  տh         )   vendor/spomky-labs/cbor-php/src/Utils.phpv  տhv  p#      .   vendor/spomky-labs/cbor-php/src/ListObject.php  տh  0S      -   vendor/spomky-labs/cbor-php/src/MapObject.phpg  տhg  /k      .   vendor/spomky-labs/cbor-php/src/CBORObject.php~  տh~  4      .   vendor/spomky-labs/cbor-php/src/Tag/UriTag.php  տh  )      <   vendor/spomky-labs/cbor-php/src/Tag/Base64UrlEncodingTag.php  տh  ܤ      =   vendor/spomky-labs/cbor-php/src/Tag/NegativeBigIntegerTag.php_  տh_  [ؠd      :   vendor/spomky-labs/cbor-php/src/Tag/DecimalFractionTag.php
  տh
        ;   vendor/spomky-labs/cbor-php/src/Tag/TagManagerInterface.php  տh  cG      4   vendor/spomky-labs/cbor-php/src/Tag/TagInterface.phph  տhh        4   vendor/spomky-labs/cbor-php/src/Tag/Base64UrlTag.php  տh  }       3   vendor/spomky-labs/cbor-php/src/Tag/BigFloatTag.php
  տh
  M@Ǥ      /   vendor/spomky-labs/cbor-php/src/Tag/CBORTag.php}  տh}  %Ƥ      /   vendor/spomky-labs/cbor-php/src/Tag/MimeTag.php  տh  <,      3   vendor/spomky-labs/cbor-php/src/Tag/DatetimeTag.php  տh  bʤ      7   vendor/spomky-labs/cbor-php/src/Tag/CBOREncodingTag.php  տh   lM      1   vendor/spomky-labs/cbor-php/src/Tag/Base64Tag.php  տh  |㨤      9   vendor/spomky-labs/cbor-php/src/Tag/Base16EncodingTag.php  տh  M9      =   vendor/spomky-labs/cbor-php/src/Tag/UnsignedBigIntegerTag.php  տh  |}      2   vendor/spomky-labs/cbor-php/src/Tag/TagManager.phpE  տhE  a      4   vendor/spomky-labs/cbor-php/src/Tag/TimestampTag.php  տh  qJ      2   vendor/spomky-labs/cbor-php/src/Tag/GenericTag.php  տh  22      9   vendor/spomky-labs/cbor-php/src/Tag/Base64EncodingTag.php  տh   k      9   vendor/spomky-labs/cbor-php/src/NegativeIntegerObject.php  տh  bx7      (   vendor/spomky-labs/pki-framework/LICENSES  տhS  t      *   vendor/spomky-labs/pki-framework/README.md  տh  7/V      .   vendor/spomky-labs/pki-framework/composer.json
  տh
  ;      ,   vendor/spomky-labs/pki-framework/SECURITY.mdI  տhI  ,)      5   vendor/spomky-labs/pki-framework/src/ASN1/Element.php<  տh<  9t      9   vendor/spomky-labs/pki-framework/src/ASN1/Util/BigInt.php  տh  `}      8   vendor/spomky-labs/pki-framework/src/ASN1/Util/Flags.php  տh  
      B   vendor/spomky-labs/pki-framework/src/ASN1/Component/Identifier.php  տh  J=      >   vendor/spomky-labs/pki-framework/src/ASN1/Component/Length.php  տh  ri
      @   vendor/spomky-labs/pki-framework/src/ASN1/Type/PrimitiveType.php,  տh,  SZe2      =   vendor/spomky-labs/pki-framework/src/ASN1/Type/BaseString.php  տh  M"~      F   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/BMPString.php_  տh_  .      D   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Boolean.php9  տh9  p@      D   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Integer.phpa  տha  @n      H   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/RelativeOID.php  տh  lb      J   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/VisibleString.php  տh  wn      C   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Number.php  տh  zڡ      G   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/UTF8String.php  տh  b      F   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/BitString.php  տh  +      F   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/IA5String.php  տh  c&k      L   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/UniversalString.php  տh  l0ޤ      J   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/GraphicString.php  տh  W      M   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/ObjectDescriptor.php  տh  Y1      A   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Real.phpQ  տhQ  ~^      L   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/PrintableString.php  տh  iTȘ      @   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/EOC.php  տh  !¤      E   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/NullType.php  տh  o      M   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/ObjectIdentifier.php  տh  z&      G   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Enumerated.php:  տh:  N      J   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/NumericString.php  տh  y{      H   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/OctetString.php2  տh2  y      L   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/GeneralizedTime.php7  տh7  l
      D   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/UTCTime.php:	  տh:	  3W-N      K   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/VideotexString.php  տh  =đ      L   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/CharacterString.php>  տh>         F   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/T61String.php  տh  _      J   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/GeneralString.php  տh  wӺ      ;   vendor/spomky-labs/pki-framework/src/ASN1/Type/TimeType.php;  տh;  -R
      I   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ImplicitTagging.php  տh  Wq      M   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ContextSpecificType.php   տh   X      N   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ExplicitlyTaggedType.php&  տh&        E   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/PrivateType.php   տh   4eY      I   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ApplicationType.php   տh   CF      N   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ImplicitlyTaggedType.php@  տh@        G   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/DERTaggedType.php  տh  }LV      H   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/TaggedTypeWrap.php'  տh'  :      I   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ExplicitTagging.php  տh  \      G   vendor/spomky-labs/pki-framework/src/ASN1/Type/Constructed/Sequence.php[  տh[  x       B   vendor/spomky-labs/pki-framework/src/ASN1/Type/Constructed/Set.php$  տh$  ~      P   vendor/spomky-labs/pki-framework/src/ASN1/Type/Constructed/ConstructedString.php  տh  2L:      B   vendor/spomky-labs/pki-framework/src/ASN1/Type/PrimitiveString.php  տh  @$      <   vendor/spomky-labs/pki-framework/src/ASN1/Type/Structure.phpM  տhM  f<      ;   vendor/spomky-labs/pki-framework/src/ASN1/Type/BaseTime.php  տh  CLb      B   vendor/spomky-labs/pki-framework/src/ASN1/Type/UnspecifiedType.php/?  տh/?  ?qФ      =   vendor/spomky-labs/pki-framework/src/ASN1/Type/TaggedType.php	  տh	  m      =   vendor/spomky-labs/pki-framework/src/ASN1/Type/StringType.php  տh  &      A   vendor/spomky-labs/pki-framework/src/ASN1/Type/UniversalClass.php  տh  o      5   vendor/spomky-labs/pki-framework/src/ASN1/DERData.php  տh  ($Ĥ      A   vendor/spomky-labs/pki-framework/src/ASN1/Feature/ElementBase.php  տh  }<t      @   vendor/spomky-labs/pki-framework/src/ASN1/Feature/Stringable.phps  տhs  FM      ?   vendor/spomky-labs/pki-framework/src/ASN1/Feature/Encodable.php   տh   ܴ;      G   vendor/spomky-labs/pki-framework/src/ASN1/Exception/DecodeException.php   տh   }Ӥ      ;   vendor/spomky-labs/pki-framework/src/CryptoEncoding/PEM.php  տh  |f"ˤ      A   vendor/spomky-labs/pki-framework/src/CryptoEncoding/PEMBundle.php  տh  La      J   vendor/spomky-labs/pki-framework/src/CryptoBridge/Crypto/OpenSSLCrypto.php  տh        <   vendor/spomky-labs/pki-framework/src/CryptoBridge/Crypto.php  տh  @      >   vendor/spomky-labs/pki-framework/src/X509/Certificate/Time.php3  տh3  Ħ      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CRLDistributionPointsExtension.php
  տh
  X      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/SubjectDirectoryAttributesExtension.php&  տh&  K+Y      n   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AccessDescription/SubjectAccessDescription.phpw  տhw  e\      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AccessDescription/AccessDescription.php  տh        p   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AccessDescription/AuthorityAccessDescription.phpJ  տhJ  (~s      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/NoRevocationAvailableExtension.php  տh        ^   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/PolicyConstraintsExtension.php  տh  v!      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AuthorityInformationAccessExtension.php
  տh
        e   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/SubjectInformationAccessExtension.php'
  տh'
   .î      ^   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/TargetInformationExtension.phpN
  տhN
  tc(      U   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/KeyUsageExtension.php  տh  W).      U   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Target/TargetName.php  տh  HA      R   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Target/Targets.php
  տh
  `%      Q   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Target/Target.phps  տhs  G]b      V   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Target/TargetGroup.php  տh  1*      `   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/PolicyMappings/PolicyMapping.phph  տhh  Ť      \   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/NameConstraintsExtension.phpp  տhp  i      X   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/FreshestCRLExtension.phpU  տhU  E      T   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/UnknownExtension.php  տh  m      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/IssuerAlternativeNameExtension.php  տh  7@A^      `   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePoliciesExtension.phpx
  տhx
        ]   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/InhibitAnyPolicyExtension.phpf  տhf  UP      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/RelativeName.phpe  տhe  iwX      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/DistributionPoint.php  տh  pӿ      ^   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/FullName.php  տh  4      a   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/ReasonFlags.php  տh  dŤ      k   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/DistributionPointName.php  տh  TQ      c   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/NameConstraints/GeneralSubtrees.php  տh  hL\      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/NameConstraints/GeneralSubtree.php
  տh
  Du      ]   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/ExtendedKeyUsageExtension.php  տh  WL      W   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AAControlsExtension.php  տh  er      e   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/NoticeReference.phpa  տha  
      i   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/PolicyQualifierInfo.php  տh  Dr      i   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/UserNoticeQualifier.php	  տh	  4s      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/PolicyInformation.phpt  տht  ҫ       a   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/DisplayText.php6  տh6  Ť      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/CPSQualifier.phpK  տhK  $vu      [   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/PolicyMappingsExtension.php  տh  p'i      M   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Extension.php'  տh'  b      c   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AuthorityKeyIdentifierExtension.php  տh  pT      c   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/SubjectAlternativeNameExtension.php  տh  6+      ]   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/BasicConstraintsExtension.php	  տh	  ?z      a   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/SubjectKeyIdentifierExtension.php  տh  )VS      E   vendor/spomky-labs/pki-framework/src/X509/Certificate/Certificate.php  տh  7;      J   vendor/spomky-labs/pki-framework/src/X509/Certificate/UniqueIdentifier.php  տh  q      J   vendor/spomky-labs/pki-framework/src/X509/Certificate/CertificateChain.php  տh  N8      B   vendor/spomky-labs/pki-framework/src/X509/Certificate/Validity.phpx  տhx  $Ҥ      K   vendor/spomky-labs/pki-framework/src/X509/Certificate/CertificateBundle.phpC  տhC        H   vendor/spomky-labs/pki-framework/src/X509/Certificate/TBSCertificate.php8  տh8  b^      D   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extensions.php$  տh$  [      F   vendor/spomky-labs/pki-framework/src/X509/GeneralName/RegisteredID.php  տh  Z3      G   vendor/spomky-labs/pki-framework/src/X509/GeneralName/DirectoryName.php]  տh]  ^      F   vendor/spomky-labs/pki-framework/src/X509/GeneralName/EDIPartyName.php  տh  Noߤ      C   vendor/spomky-labs/pki-framework/src/X509/GeneralName/OtherName.php  տh  V$d      C   vendor/spomky-labs/pki-framework/src/X509/GeneralName/IPAddress.php  տh  ?U      E   vendor/spomky-labs/pki-framework/src/X509/GeneralName/X400Address.php  տh  T      E   vendor/spomky-labs/pki-framework/src/X509/GeneralName/IPv4Address.php!  տh!  #      F   vendor/spomky-labs/pki-framework/src/X509/GeneralName/GeneralNames.php  տh  \֤      S   vendor/spomky-labs/pki-framework/src/X509/GeneralName/UniformResourceIdentifier.php  տh  e      D   vendor/spomky-labs/pki-framework/src/X509/GeneralName/RFC822Name.php  տh  Mpn      E   vendor/spomky-labs/pki-framework/src/X509/GeneralName/GeneralName.phpD
  տhD
        E   vendor/spomky-labs/pki-framework/src/X509/GeneralName/IPv6Address.php  տh   Ip      A   vendor/spomky-labs/pki-framework/src/X509/GeneralName/DNSName.php(  տh(  Yj      D   vendor/spomky-labs/pki-framework/src/X509/Feature/DateTimeHelper.php  տh  $u      c   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathValidation/PathValidationConfig.php  տh  U\      c   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathValidation/PathValidationResult.php\  տh\  c[      ]   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathValidation/ValidatorState.php)  տh)  0p      \   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathValidation/PathValidator.phpB  տhB  ~i      e   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathBuilding/CertificationPathBuilder.php  տh  h      _   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/Exception/PathBuildingException.php  տh  v      a   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/Exception/PathValidationException.phpC  տhC  Wb'      Q   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/Policy/PolicyNode.phpT  տhT  Rn      Q   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/Policy/PolicyTree.php+5  տh+5  1ؤ      Q   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/CertificationPath.php  տh  s      O   vendor/spomky-labs/pki-framework/src/X509/Exception/X509ValidationException.php   տh   ?$      i   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/AccessIdentityAttributeValue.php5  տh5  3c      Z   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/IetfAttrValue.php  տh  f#       Y   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/SvceAuthInfo.php	  տh	  Gh      m   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/AuthenticationInfoAttributeValue.phpN  տhN  ˯Ť      k   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/ChargingIdentityAttributeValue.php  տh  d      `   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/GroupAttributeValue.php  տh  vR      [   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/IetfAttrSyntax.php  տh        _   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/RoleAttributeValue.php  տh  q1      M   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attributes.php   տh   pr      O   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/IssuerSerial.php  տh  hU      I   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Holder.php  տh  pS      I   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/V2Form.php  տh  ~      [   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/AttributeCertificateInfo.phpK&  տhK&  lz      S   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/ObjectDigestInfo.php	  տh	  >      P   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/AttCertIssuer.phpB  տhB  y0      W   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/AttributeCertificate.php  տh        X   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/AttCertValidityPeriod.php$  տh$  t      Y   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Validation/ACValidator.php  տh        m   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Validation/Exception/ACValidationException.php
  տh
  K      `   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Validation/ACValidationConfig.php  տh  6      W   vendor/spomky-labs/pki-framework/src/X509/CertificationRequest/CertificationRequest.php  տh  `      b   vendor/spomky-labs/pki-framework/src/X509/CertificationRequest/Attribute/ExtensionRequestValue.phpD  տhD  
      M   vendor/spomky-labs/pki-framework/src/X509/CertificationRequest/Attributes.php  տh        [   vendor/spomky-labs/pki-framework/src/X509/CertificationRequest/CertificationRequestInfo.php  տh  X      6   vendor/spomky-labs/pki-framework/src/X501/ASN1/RDN.php  տh  u晤      @   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeType.php@  տh@  7P      R   vendor/spomky-labs/pki-framework/src/X501/ASN1/Collection/SequenceOfAttributes.php  տh  xDc      M   vendor/spomky-labs/pki-framework/src/X501/ASN1/Collection/SetOfAttributes.php2  տh2  %      Q   vendor/spomky-labs/pki-framework/src/X501/ASN1/Collection/AttributeCollection.php"  տh"  ,L      <   vendor/spomky-labs/pki-framework/src/X501/ASN1/Attribute.php#  տh#  9      S   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/LocalityNameValue.php  տh  `      P   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/GivenNameValue.php  տh  g      W   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/OrganizationNameValue.php  տh  09      L   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/TitleValue.php  տh  f2      S   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/SerialNumberValue.php  տh  G      P   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/AttributeValue.php  տh  Sg&      R   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/DescriptionValue.php  տh  GϤ      R   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/CountryNameValue.php  տh  k      Q   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/CommonNameValue.php  տh  40L      N   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/SurnameValue.php  տh  l      P   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/PseudonymValue.php  տh        Z   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/StateOrProvinceNameValue.php  տh  ˤ      ^   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/Feature/PrintableStringValue.php  տh  Rp      Y   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/Feature/DirectoryString.php  տh  W      W   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/UnknownAttributeValue.php<	  տh<	  %U      ]   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/OrganizationalUnitNameValue.php  տh  6ۺ      K   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/NameValue.php  տh        H   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeTypeAndValue.phpe  տhe  z\      7   vendor/spomky-labs/pki-framework/src/X501/ASN1/Name.phpP  տhP  :      9   vendor/spomky-labs/pki-framework/src/X501/DN/DNParser.phpd(  տhd(        G   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/MatchingRule.phpP  տhP  ~j2      J   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/CaseIgnoreMatch.php  տh   Eʤ      I   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/CaseExactMatch.php  տh  }      Q   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/StringPrepMatchingRule.php{  տh{  峿      F   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/BinaryMatch.php  տh  	r      @   vendor/spomky-labs/pki-framework/src/X501/StringPrep/MapStep.phpn  տhn  T      F   vendor/spomky-labs/pki-framework/src/X501/StringPrep/NormalizeStep.php
  տh
  q      D   vendor/spomky-labs/pki-framework/src/X501/StringPrep/PrepareStep.php  տh  o*      F   vendor/spomky-labs/pki-framework/src/X501/StringPrep/TranscodeStep.phpA	  տhA	  B      F   vendor/spomky-labs/pki-framework/src/X501/StringPrep/CheckBidiStep.php  տh  tId      G   vendor/spomky-labs/pki-framework/src/X501/StringPrep/StringPreparer.php  տh  o<I      E   vendor/spomky-labs/pki-framework/src/X501/StringPrep/ProhibitStep.php  տh        [   vendor/spomky-labs/pki-framework/src/X501/StringPrep/InsignificantNonSubstringSpaceStep.php!  տh!  Q6|      O   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/Ed25519Signature.php  տh        M   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/Ed448Signature.php  տh  Pb      O   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/GenericSignature.phpB  տhB   ~      J   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/ECSignature.php  տh        K   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/RSASignature.phpY  տhY  ފ-      H   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/Signature.php  տh  U(      P   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/OneAsymmetricKey.php)  տh)  NM@      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/Attribute/OneAsymmetricKeyAttributes.php  տh  H      P   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RSA/RSAPublicKey.php
  տh
  3:      Q   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RSA/RSAPrivateKey.phpO  տhO  U      W   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RSA/RSASSAPSSPrivateKey.phpj  տhj  f*      N   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/EC/ECPublicKey.phpm  տhm  Ҥ      O   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/EC/ECPrivateKey.php*  տh*  QOM2      O   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/EC/ECConversion.php  տh  Ғ      I   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/PublicKey.php3  տh3  Zh      N   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/PrivateKeyInfo.php  տh  Ln+      Y   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/RFC8410PrivateKey.phpj
  տhj
  "      X   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/RFC8410PublicKey.php  տh  ;.      ^   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve448/X448PublicKey.php  տh  O      _   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve448/Ed448PublicKey.php  տh  +/      _   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve448/X448PrivateKey.php  տh  Q      `   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve448/Ed448PrivateKey.php  տh  	      b   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/X25519PublicKey.php  տh  .)      f   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/Curve25519PublicKey.php  տh  4I      c   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/X25519PrivateKey.php  տh  vV      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/Curve25519PrivateKey.php3  տh3  D3      c   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/Ed25519PublicKey.php  տh  ʙ      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/Ed25519PrivateKey.php  տh  .:      M   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/PublicKeyInfo.php  տh  3D      J   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/PrivateKey.php0  տh0  Ix      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/SpecificAlgorithmIdentifier.phpW  տhW  y      \   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/AlgorithmIdentifier.phpp  տhp  %H      }   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA384WithRSAEncryptionAlgorithmIdentifier.php  տh  O+      z   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/MD2WithRSAEncryptionAlgorithmIdentifier.php  տh  Qߕޤ      u   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA256AlgorithmIdentifier.php  տh  -      u   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA224AlgorithmIdentifier.php  տh  
      z   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/MD5WithRSAEncryptionAlgorithmIdentifier.php  տh  +      y   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/RFC3279RSASignatureAlgorithmIdentifier.php  տh  )af      z   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/MD4WithRSAEncryptionAlgorithmIdentifier.php  տh  wl      y   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/RFC4055RSASignatureAlgorithmIdentifier.phpl  տhl  _esԤ      u   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA512AlgorithmIdentifier.php  տh  6f{      r   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/RSASignatureAlgorithmIdentifier.php  տh  |Ǥ      }   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA256WithRSAEncryptionAlgorithmIdentifier.php  տh  `%      s   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA1AlgorithmIdentifier.php  տh  bd      u   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA384AlgorithmIdentifier.php  տh  ,P      q   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECSignatureAlgorithmIdentifier.php  տh  _<      }   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA512WithRSAEncryptionAlgorithmIdentifier.php  տh        {   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA1WithRSAEncryptionAlgorithmIdentifier.php  տh  1      }   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA224WithRSAEncryptionAlgorithmIdentifier.php  տh  &n      o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA224AlgorithmIdentifier.php  տh  Ф      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA224AlgorithmIdentifier.php  տh  1]̤      o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA256AlgorithmIdentifier.php  տh  L      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA256AlgorithmIdentifier.php  տh  F      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/RFC4231HMACAlgorithmIdentifier.phps  տhs  TE      o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA512AlgorithmIdentifier.php  տh  N      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA512AlgorithmIdentifier.php  տh  Iˤ      m   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA1AlgorithmIdentifier.php  տh  l	d      e   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA2AlgorithmIdentifier.php  տh  	      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/MD5AlgorithmIdentifier.php  տh  :      e   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA1AlgorithmIdentifier.phpy  տhy        o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA384AlgorithmIdentifier.php  տh  /4      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA384AlgorithmIdentifier.php  տh  MaA4      i   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/RC2CBCAlgorithmIdentifier.php  տh        m   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/DESEDE3CBCAlgorithmIdentifier.phpg  տhg  p      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/AES192CBCAlgorithmIdentifier.php  տh        i   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/AESCBCAlgorithmIdentifier.php  տh  qz      i   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/CipherAlgorithmIdentifier.php8  տh8   "¤      i   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/DESCBCAlgorithmIdentifier.php  տh  HY      n   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/BlockCipherAlgorithmIdentifier.phpd  տhd  ~      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/AES128CBCAlgorithmIdentifier.php|  տh|  Wϸ      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/AES256CBCAlgorithmIdentifier.php  տh  |Ĥ      r   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/ECPublicKeyAlgorithmIdentifier.php/  տh/  D      m   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/X25519AlgorithmIdentifier.php+  տh+  0Ŕ      k   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/X448AlgorithmIdentifier.php#  տh#  oœ#      p   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/RFC8410EdAlgorithmIdentifier.php  տh   ߎ      t   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/RSAEncryptionAlgorithmIdentifier.php  տh  seR      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/Ed448AlgorithmIdentifier.php  տh  ְ      o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/RFC8410XAlgorithmIdentifier.php  տh  L~.      z   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/RSAPSSSSAEncryptionAlgorithmIdentifier.php  տh  Z      n   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/Ed25519AlgorithmIdentifier.php  տh         c   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/AlgorithmIdentifierFactory.php$  տh$  #ꨤ      m   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/SignatureAlgorithmIdentifier.php  տh  3!      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/PRFAlgorithmIdentifier.php   տh   !$      t   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/AsymmetricCryptoAlgorithmIdentifier.php
  տh
  C      h   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/HashAlgorithmIdentifier.php   տh   &-      n   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/EncryptionAlgorithmIdentifier.php   տh   bO      h   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/AlgorithmIdentifierType.phpy  տhy  l̤      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/AlgorithmIdentifierProvider.php  տh  k\d      c   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/GenericAlgorithmIdentifier.php  տh  CI	          vendor/spomky-labs/otphp/LICENSE@  տh@  xi      "   vendor/spomky-labs/otphp/README.md%  տh%  z@      &   vendor/spomky-labs/otphp/composer.json  տh  ;       $   vendor/spomky-labs/otphp/SECURITY.md  տh  ?	m      %   vendor/spomky-labs/otphp/src/TOTP.php  տh  >s?      (   vendor/spomky-labs/otphp/src/Factory.php+  տh+  0$      -   vendor/spomky-labs/otphp/src/OTPInterface.php
  տh
  zr      .   vendor/spomky-labs/otphp/src/TOTPInterface.php  տh  *      $   vendor/spomky-labs/otphp/src/OTP.php  տh  B      %   vendor/spomky-labs/otphp/src/HOTP.php=
  տh=
  hct      .   vendor/spomky-labs/otphp/src/HOTPInterface.php=  տh=  ߤ      1   vendor/spomky-labs/otphp/src/FactoryInterface.phpr  տhr  ¤      /   vendor/spomky-labs/otphp/src/ParameterTrait.php  տh  da&      $   vendor/spomky-labs/otphp/src/Url.php#
  տh#
  >쐡      .   vendor/spomky-labs/otphp/src/InternalClock.php5  տh5  GƤ      $   vendor/doctrine/deprecations/LICENSE)  տh)  "0      &   vendor/doctrine/deprecations/README.md
  տh
  {      *   vendor/doctrine/deprecations/composer.json
  տh
        ?   vendor/doctrine/deprecations/src/PHPUnit/VerifyDeprecations.php  տh  jϤ      0   vendor/doctrine/deprecations/src/Deprecation.php$  տh$  )         vendor/firebase/php-jwt/LICENSE  տh  #      $   vendor/firebase/php-jwt/CHANGELOG.md(  տh(  D      !   vendor/firebase/php-jwt/README.md4  տh4  !Uk      %   vendor/firebase/php-jwt/composer.json  տh  ܤ      9   vendor/firebase/php-jwt/src/SignatureInvalidException.phpu   տhu   Ͻ      4   vendor/firebase/php-jwt/src/BeforeValidException.phpt  տht  u0      ,   vendor/firebase/php-jwt/src/CachedKeySet.php  տh   ؤ      #   vendor/firebase/php-jwt/src/Key.php  տh  lx+      #   vendor/firebase/php-jwt/src/JWK.phpA,  տhA,        @   vendor/firebase/php-jwt/src/JWTExceptionWithPayloadInterface.php  տh  ky      0   vendor/firebase/php-jwt/src/ExpiredException.phpp  տhp  7      #   vendor/firebase/php-jwt/src/JWT.php\  տh\  2ב         vendor/brick/math/LICENSEA  տhA  ݸL         vendor/brick/math/CHANGELOG.md`O  տh`O        $   vendor/brick/math/psalm-baseline.xml	  տh	           vendor/brick/math/composer.jsonR  տhR  IG      &   vendor/brick/math/src/RoundingMode.php
  տh
        ;   vendor/brick/math/src/Internal/Calculator/GmpCalculator.php'
  տh'
  ;0      >   vendor/brick/math/src/Internal/Calculator/BcMathCalculator.php  տh  ,1      >   vendor/brick/math/src/Internal/Calculator/NativeCalculator.php7  տh7  #.      -   vendor/brick/math/src/Internal/Calculator.phpI  տhI  }      $   vendor/brick/math/src/BigInteger.php  տh  oa      #   vendor/brick/math/src/BigNumber.php>  տh>  Eä      $   vendor/brick/math/src/BigDecimal.phpW  տhW  87      1   vendor/brick/math/src/Exception/MathException.php   տh   }&      9   vendor/brick/math/src/Exception/NumberFormatException.php  տh  ojQ      ;   vendor/brick/math/src/Exception/NegativeNumberException.php  տh  +;      ;   vendor/brick/math/src/Exception/DivisionByZeroException.php  տh  Ɓj      <   vendor/brick/math/src/Exception/IntegerOverflowException.php,  տh,  1C>*      >   vendor/brick/math/src/Exception/RoundingNecessaryException.php  տh  A      %   vendor/brick/math/src/BigRational.php.  տh.  2h      (   vendor/justinrainbow/json-schema/LICENSE   տh         2   vendor/justinrainbow/json-schema/bin/validate-json  տh        F   vendor/justinrainbow/json-schema/dist/schema/json-schema-draft-03.json  տh  -aߤ      F   vendor/justinrainbow/json-schema/dist/schema/json-schema-draft-04.json  տh  Nߤ      *   vendor/justinrainbow/json-schema/README.mdz  տhz  ˱      .   vendor/justinrainbow/json-schema/composer.json  տh  7      ;   vendor/justinrainbow/json-schema/src/JsonSchema/Rfc3339.php  տh  ̤      =   vendor/justinrainbow/json-schema/src/JsonSchema/Validator.php
  տh
         I   vendor/justinrainbow/json-schema/src/JsonSchema/UriRetrieverInterface.php  տh  hJ      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/ObjectConstraint.php{  տh{  =6      G   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/Factory.php  տh  ߤ      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/NumberConstraint.php
  տh
  Uj      N   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeConstraint.php  տh  MY      N   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/BaseConstraint.php   տh   ֤      N   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/EnumConstraint.php  տh  l$М      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/StringConstraint.php  տh  ^      S   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/ConstraintInterface.php3  տh3  9¤      T   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/CollectionConstraint.php  տh  5q      J   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/Constraint.php  տh  d5      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/FormatConstraint.php.#  տh.#  '      \   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeCheck/TypeCheckInterface.php  տh  y      Y   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeCheck/StrictTypeCheck.php:  տh:  *9      X   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeCheck/LooseTypeCheck.php  տh  r(      S   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/UndefinedConstraint.php<  տh<  U>      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/SchemaConstraint.php!  տh!        F   vendor/justinrainbow/json-schema/src/JsonSchema/Entity/JsonPointer.php4
  տh4
        H   vendor/justinrainbow/json-schema/src/JsonSchema/UriResolverInterface.php   տh   "      K   vendor/justinrainbow/json-schema/src/JsonSchema/Iterator/ObjectIterator.php
  տh
  hl      A   vendor/justinrainbow/json-schema/src/JsonSchema/SchemaStorage.php  տh  Nq      X   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/UriRetrieverInterface.php  տh  -,      T   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/AbstractRetriever.php  տh  _Ǥ      G   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/Curl.php  տh  x(      R   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/FileGetContents.php^
  տh^
        R   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/PredefinedArray.php
  տh
  /8      D   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/UriRetriever.php$  տh$  Aq      C   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/UriResolver.php  տh  _9<      W   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/ResourceNotFoundException.phpb  տhb  `      P   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/ExceptionInterface.phpX   տhX   [      N   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/RuntimeException.phpo  տho  Cr      W   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidSourceUriException.phpj  տhj  *5      V   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidArgumentException.php  տh  N      ^   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/UnresolvableJsonPointerException.php  տh  ZHe      Q   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/ValidationException.php'  տh'  Aj      T   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidConfigException.php_  տh_  P      S   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/JsonDecodingException.php  տh  nW      T   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidSchemaException.php\  տh\  @S6      R   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/UriResolverException.phpX  տhX  Ӕ      ]   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidSchemaMediaTypeException.phpe  տhe  U3$      J   vendor/justinrainbow/json-schema/src/JsonSchema/SchemaStorageInterface.php.  տh.  VԠg      1   vendor/crell/api-problem/docker/php/81/Dockerfile   տh   D1      1   vendor/crell/api-problem/docker/php/81/xdebug.inil   տhl   b0      >   vendor/crell/api-problem/docker/php/conf.d/error_reporting.ini   տh   lc¤      !   vendor/crell/api-problem/Makefile]  տh]  Zib      *   vendor/crell/api-problem/phpstan.neon.dist0   տh0   b      +   vendor/crell/api-problem/docker-compose.ymlb  տhb  Ruv      &   vendor/crell/api-problem/composer.json  տh  VN+      $   vendor/crell/api-problem/SECURITY.mdw	  տhw	  _yU      %   vendor/crell/api-problem/default-.env  տh  ]h	Q      4   vendor/crell/api-problem/src/JsonEncodeException.php   տh   ewF      .   vendor/crell/api-problem/src/HttpConverter.php6
  տh6
  1B      3   vendor/crell/api-problem/src/JsonParseException.phpH  տhH  %P(      .   vendor/crell/api-problem/src/JsonException.php  տh  5-      +   vendor/crell/api-problem/src/ApiProblem.phpdH  տhdH  'M         vendor/psr/cache/CHANGELOG.md  տh  -	G         vendor/psr/cache/README.md"  տh"  (AcӤ         vendor/psr/cache/LICENSE.txt8  տh8  Df         vendor/psr/cache/composer.json4  տh4  C      /   vendor/psr/cache/src/CacheItemPoolInterface.php  տh  Y      +   vendor/psr/cache/src/CacheItemInterface.php&  տh&  =b      1   vendor/psr/cache/src/InvalidArgumentException.php:  տh:  MY      '   vendor/psr/cache/src/CacheException.php   տh   BJ      #   vendor/psr/event-dispatcher/LICENSE(  տh(  }]      %   vendor/psr/event-dispatcher/README.mdE  տhE  S      )   vendor/psr/event-dispatcher/composer.jsonb  տhb  q      =   vendor/psr/event-dispatcher/src/ListenerProviderInterface.php  տh  bh      <   vendor/psr/event-dispatcher/src/EventDispatcherInterface.php  տh        ;   vendor/psr/event-dispatcher/src/StoppableEventInterface.php!  տh!  T>q         vendor/psr/http-message/LICENSE=  տh=        $   vendor/psr/http-message/CHANGELOG.md3  տh3  :\Y      !   vendor/psr/http-message/README.md  տh        %   vendor/psr/http-message/composer.json  տh  7      6   vendor/psr/http-message/src/ServerRequestInterface.phpH(  տhH(  #      ,   vendor/psr/http-message/src/UriInterface.php/2  տh/2  קY      /   vendor/psr/http-message/src/StreamInterface.php  տh        5   vendor/psr/http-message/src/UploadedFileInterface.php  տh  	      0   vendor/psr/http-message/src/RequestInterface.phpG  տhG  ir      1   vendor/psr/http-message/src/ResponseInterface.phpZ
  տhZ
  aG      0   vendor/psr/http-message/src/MessageInterface.php  տh  |C         vendor/psr/container/LICENSEy  տhy  Op         vendor/psr/container/README.mdB  տhB  g?      "   vendor/psr/container/composer.json  տh  nY      7   vendor/psr/container/src/NotFoundExceptionInterface.php   տh   B@      /   vendor/psr/container/src/ContainerInterface.php%  տh%  )      8   vendor/psr/container/src/ContainerExceptionInterface.php   տh              vendor/psr/http-client/LICENSE=  տh=  S      #   vendor/psr/http-client/CHANGELOG.md  տh  z򪌤          vendor/psr/http-client/README.md%  տh%  F      $   vendor/psr/http-client/composer.json  տh  bϤ      8   vendor/psr/http-client/src/NetworkExceptionInterface.php  տh  6SB      8   vendor/psr/http-client/src/RequestExceptionInterface.phph  տhh  *c=      .   vendor/psr/http-client/src/ClientInterface.php!  տh!  {0      7   vendor/psr/http-client/src/ClientExceptionInterface.php   տh   xz         vendor/psr/log/LICENSE=  տh=  pO         vendor/psr/log/README.mdB  տhB  '         vendor/psr/log/composer.json`  տh`  ],      +   vendor/psr/log/src/LoggerAwareInterface.php   տh   ow         vendor/psr/log/src/LogLevel.phpH  տhH  u      '   vendor/psr/log/src/LoggerAwareTrait.phpj  տhj  dz      /   vendor/psr/log/src/InvalidArgumentException.phpo   տho   MWd      !   vendor/psr/log/src/NullLogger.php  տh   <      &   vendor/psr/log/src/LoggerInterface.php
  տh
  c=      "   vendor/psr/log/src/LoggerTrait.php
  տh
  
      %   vendor/psr/log/src/AbstractLogger.php  տh  q         vendor/psr/clock/LICENSE8  տh8  l         vendor/psr/clock/CHANGELOG.md   տh   <         vendor/psr/clock/README.md  տh  GL[         vendor/psr/clock/composer.json2  տh2  $DCM      '   vendor/psr/clock/src/ClockInterface.php   տh   H%         vendor/psr/http-factory/LICENSE(  տh(  }]      !   vendor/psr/http-factory/README.md,  տh,  zwf      %   vendor/psr/http-factory/composer.json8  տh8        8   vendor/psr/http-factory/src/ResponseFactoryInterface.php2  տh2  ձ}      6   vendor/psr/http-factory/src/StreamFactoryInterface.php  տh  e      <   vendor/psr/http-factory/src/UploadedFileFactoryInterface.phpJ  տhJ  nʉ      3   vendor/psr/http-factory/src/UriFactoryInterface.phpU  տhU        =   vendor/psr/http-factory/src/ServerRequestFactoryInterface.php  տh  w9      7   vendor/psr/http-factory/src/RequestFactoryInterface.php  տh  4(         vendor/monolog/monolog/LICENSE'  տh'        #   vendor/monolog/monolog/CHANGELOG.md  տh  nr          vendor/monolog/monolog/README.mdA  տhA  o      $   vendor/monolog/monolog/composer.json3
  տh3
        >   vendor/monolog/monolog/src/Monolog/Handler/SendGridHandler.php  տh  
FϤ      @   vendor/monolog/monolog/src/Monolog/Handler/InsightOpsHandler.php  տh  &      :   vendor/monolog/monolog/src/Monolog/Handler/TestHandler.php  տh  )Bs      ;   vendor/monolog/monolog/src/Monolog/Handler/IFTTTHandler.php  տh  ps      H   vendor/monolog/monolog/src/Monolog/Handler/WebRequestRecognizerTrait.php  տh  cJ      <   vendor/monolog/monolog/src/Monolog/Handler/SocketHandler.phpY/  տhY/  q]      C   vendor/monolog/monolog/src/Monolog/Handler/SymfonyMailerHandler.phpJ  տhJ  H      :   vendor/monolog/monolog/src/Monolog/Handler/NoopHandler.php  տh  :      <   vendor/monolog/monolog/src/Monolog/Handler/BufferHandler.phpy  տhy  ,Z̤      <   vendor/monolog/monolog/src/Monolog/Handler/SyslogHandler.php  տh  ~      =   vendor/monolog/monolog/src/Monolog/Handler/RollbarHandler.php
  տh
  kVʤ      D   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossedHandler.phpz   տhz   U6X      >   vendor/monolog/monolog/src/Monolog/Handler/OverflowHandler.php  տh  8      =   vendor/monolog/monolog/src/Monolog/Handler/HandlerWrapper.phpO
  տhO
        Y   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ActivationStrategyInterface.php  տh  z.      Z   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ErrorLevelActivationStrategy.php  տh         \   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ChannelLevelActivationStrategy.php	  տh	  ;Ӥ      ;   vendor/monolog/monolog/src/Monolog/Handler/GroupHandler.php  տh  Y      C   vendor/monolog/monolog/src/Monolog/Handler/ElasticsearchHandler.php  տh         >   vendor/monolog/monolog/src/Monolog/Handler/SamplingHandler.phpz  տhz  E^      6   vendor/monolog/monolog/src/Monolog/Handler/Handler.php  տh  |      >   vendor/monolog/monolog/src/Monolog/Handler/AbstractHandler.php
  տh
  7m      >   vendor/monolog/monolog/src/Monolog/Handler/FlowdockHandler.phpG
  տhG
  
B      >   vendor/monolog/monolog/src/Monolog/Handler/PushoverHandler.phpJ  տhJ  1      J   vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerInterface.php  տh  'W      H   vendor/monolog/monolog/src/Monolog/Handler/MissingExtensionException.php  տh   
l      D   vendor/monolog/monolog/src/Monolog/Handler/AbstractSyslogHandler.php  տh  
$      ?   vendor/monolog/monolog/src/Monolog/Handler/SyslogUdpHandler.php4  տh4        D   vendor/monolog/monolog/src/Monolog/Handler/BrowserConsoleHandler.php$  տh$   Aߤ      <   vendor/monolog/monolog/src/Monolog/Handler/FilterHandler.php  տh        9   vendor/monolog/monolog/src/Monolog/Handler/SqsHandler.php  տh  -
M      B   vendor/monolog/monolog/src/Monolog/Handler/RotatingFileHandler.php>  տh>  ^n      C   vendor/monolog/monolog/src/Monolog/Handler/FallbackGroupHandler.php  տh  <      B   vendor/monolog/monolog/src/Monolog/Handler/NativeMailerHandler.php  տh  .t      =   vendor/monolog/monolog/src/Monolog/Handler/MongoDBHandler.php	  տh	  nD      =   vendor/monolog/monolog/src/Monolog/Handler/ProcessHandler.phpU  տhU  ٤      F   vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerTrait.php  տh  N'x~      :   vendor/monolog/monolog/src/Monolog/Handler/GelfHandler.php  տh  ca      A   vendor/monolog/monolog/src/Monolog/Handler/ZendMonitorHandler.php  տh        @   vendor/monolog/monolog/src/Monolog/Handler/PHPConsoleHandler.phpQ0  տhQ0  v֤      >   vendor/monolog/monolog/src/Monolog/Handler/ErrorLogHandler.php
  տh
  *rʤ      @   vendor/monolog/monolog/src/Monolog/Handler/LogEntriesHandler.php  տh  D      >   vendor/monolog/monolog/src/Monolog/Handler/LogmaticHandler.php	  տh	  go      C   vendor/monolog/monolog/src/Monolog/Handler/DeduplicationHandler.phpY  տhY  h      =   vendor/monolog/monolog/src/Monolog/Handler/FirePHPHandler.php  տh        8   vendor/monolog/monolog/src/Monolog/Handler/Curl/Util.php  տh  A      E   vendor/monolog/monolog/src/Monolog/Handler/DoctrineCouchDBHandler.php  տh  O!֤      >   vendor/monolog/monolog/src/Monolog/Handler/DynamoDbHandler.php  տh  %Tg      J   vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerInterface.php  տh        A   vendor/monolog/monolog/src/Monolog/Handler/RedisPubSubHandler.php  տh  ޤ      :   vendor/monolog/monolog/src/Monolog/Handler/MailHandler.php  տh  Nv      <   vendor/monolog/monolog/src/Monolog/Handler/StreamHandler.php5   տh5   EW      <   vendor/monolog/monolog/src/Monolog/Handler/LogglyHandler.phpa  տha  Ӥ      B   vendor/monolog/monolog/src/Monolog/Handler/SlackWebhookHandler.php  տh  Kdﮤ      >   vendor/monolog/monolog/src/Monolog/Handler/ElasticaHandler.php  տh        F   vendor/monolog/monolog/src/Monolog/Handler/WhatFailureGroupHandler.php  տh  f      ?   vendor/monolog/monolog/src/Monolog/Handler/ChromePHPHandler.php/  տh/  m      @   vendor/monolog/monolog/src/Monolog/Handler/Slack/SlackRecord.php'  տh'        9   vendor/monolog/monolog/src/Monolog/Handler/PsrHandler.php	  տh	  |cU      >   vendor/monolog/monolog/src/Monolog/Handler/NewRelicHandler.php)  տh)  ̤      F   vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerTrait.php  տh  PK      ?   vendor/monolog/monolog/src/Monolog/Handler/HandlerInterface.php
  տh
  2      ;   vendor/monolog/monolog/src/Monolog/Handler/SlackHandler.php  տh  '      ?   vendor/monolog/monolog/src/Monolog/Handler/FleepHookHandler.phpI
  տhI
   T      :   vendor/monolog/monolog/src/Monolog/Handler/NullHandler.php|  տh|  Wb      :   vendor/monolog/monolog/src/Monolog/Handler/AmqpHandler.php%  տh%  paĤ      A   vendor/monolog/monolog/src/Monolog/Handler/TelegramBotHandler.php$  տh$  39      >   vendor/monolog/monolog/src/Monolog/Handler/MandrillHandler.php
  տh
  \+w      H   vendor/monolog/monolog/src/Monolog/Handler/AbstractProcessingHandler.php  տh  cl      =   vendor/monolog/monolog/src/Monolog/Handler/CouchDBHandler.php	  տh	  (ٌ      ;   vendor/monolog/monolog/src/Monolog/Handler/RedisHandler.php
  տh
        :   vendor/monolog/monolog/src/Monolog/Handler/CubeHandler.phpF  տhF  !fB      B   vendor/monolog/monolog/src/Monolog/Handler/SyslogUdp/UdpSocket.php  տh  bH      H   vendor/monolog/monolog/src/Monolog/JsonSerializableDateTimeImmutable.php  տh  kܤ      -   vendor/monolog/monolog/src/Monolog/Logger.php;Y  տh;Y  {      C   vendor/monolog/monolog/src/Monolog/Attribute/AsMonologProcessor.php  տh  b      C   vendor/monolog/monolog/src/Monolog/Attribute/WithMonologChannel.php  տh  GL      8   vendor/monolog/monolog/src/Monolog/DateTimeImmutable.phph  տhh  x\G      ;   vendor/monolog/monolog/src/Monolog/Test/MonologTestCase.php@  տh@  (-      4   vendor/monolog/monolog/src/Monolog/Test/TestCase.php  տh  >7)      /   vendor/monolog/monolog/src/Monolog/Registry.php  տh  =      B   vendor/monolog/monolog/src/Monolog/Processor/HostnameProcessor.php  տh  	'1      G   vendor/monolog/monolog/src/Monolog/Processor/PsrLogMessageProcessor.phpI  տhI        =   vendor/monolog/monolog/src/Monolog/Processor/WebProcessor.phpU
  տhU
  8      I   vendor/monolog/monolog/src/Monolog/Processor/MemoryPeakUsageProcessor.php|  տh|  _`x      C   vendor/monolog/monolog/src/Monolog/Processor/ProcessIdProcessor.php  տh  +@      E   vendor/monolog/monolog/src/Monolog/Processor/LoadAverageProcessor.php\  տh\  s      H   vendor/monolog/monolog/src/Monolog/Processor/ClosureContextProcessor.php  տh  :Eg      C   vendor/monolog/monolog/src/Monolog/Processor/MercurialProcessor.php  տh  O      =   vendor/monolog/monolog/src/Monolog/Processor/TagProcessor.php  տh  G?o      =   vendor/monolog/monolog/src/Monolog/Processor/GitProcessor.php  տh  \@      @   vendor/monolog/monolog/src/Monolog/Processor/MemoryProcessor.php  տh  )      G   vendor/monolog/monolog/src/Monolog/Processor/IntrospectionProcessor.php\  տh\  h      =   vendor/monolog/monolog/src/Monolog/Processor/UidProcessor.php  տh  Hz      C   vendor/monolog/monolog/src/Monolog/Processor/ProcessorInterface.php]  տh]  l(      E   vendor/monolog/monolog/src/Monolog/Processor/MemoryUsageProcessor.phpi  տhi  3;w      :   vendor/monolog/monolog/src/Monolog/ResettableInterface.php  տh  Z̤      4   vendor/monolog/monolog/src/Monolog/SignalHandler.phpZ  տhZ  N      ,   vendor/monolog/monolog/src/Monolog/Level.php\  տh\  $رn      B   vendor/monolog/monolog/src/Monolog/Formatter/LogmaticFormatter.php;  տh;  
ؤ      B   vendor/monolog/monolog/src/Monolog/Formatter/ElasticaFormatter.php  տh  q*      >   vendor/monolog/monolog/src/Monolog/Formatter/LineFormatter.phph&  տhh&  ؃      >   vendor/monolog/monolog/src/Monolog/Formatter/JsonFormatter.phpm  տhm  l S      B   vendor/monolog/monolog/src/Monolog/Formatter/FlowdockFormatter.phpC	  տhC	  mӼ      C   vendor/monolog/monolog/src/Monolog/Formatter/FormatterInterface.php  տh  ̍Q      B   vendor/monolog/monolog/src/Monolog/Formatter/LogstashFormatter.phpQ
  տhQ
  n@      @   vendor/monolog/monolog/src/Monolog/Formatter/LogglyFormatter.php  տh  א      G   vendor/monolog/monolog/src/Monolog/Formatter/ElasticsearchFormatter.phpF  տhF  pz      @   vendor/monolog/monolog/src/Monolog/Formatter/ScalarFormatter.php  տh  Pa      A   vendor/monolog/monolog/src/Monolog/Formatter/MongoDBFormatter.php  տh  դ      C   vendor/monolog/monolog/src/Monolog/Formatter/ChromePHPFormatter.php  տh        A   vendor/monolog/monolog/src/Monolog/Formatter/FluentdFormatter.php  տh  (QG      E   vendor/monolog/monolog/src/Monolog/Formatter/GelfMessageFormatter.phpY  տhY  9Pi      B   vendor/monolog/monolog/src/Monolog/Formatter/WildfireFormatter.php  տh  :      L   vendor/monolog/monolog/src/Monolog/Formatter/GoogleCloudLoggingFormatter.php  տh        @   vendor/monolog/monolog/src/Monolog/Formatter/SyslogFormatter.php  տh  氂      D   vendor/monolog/monolog/src/Monolog/Formatter/NormalizerFormatter.php'  տh'  6xq      >   vendor/monolog/monolog/src/Monolog/Formatter/HtmlFormatter.php  տh  x       0   vendor/monolog/monolog/src/Monolog/LogRecord.php
  տh
  
      3   vendor/monolog/monolog/src/Monolog/ErrorHandler.php'  տh'  4_      ,   vendor/monolog/monolog/src/Monolog/Utils.phpr"  տhr"  c      !   vendor/studio24/rotate/LICENSE.md>  տh>  3ä      "   vendor/studio24/rotate/phpunit.xml   տh   gE          vendor/studio24/rotate/README.md  տh  ?/      $   vendor/studio24/rotate/composer.json  տh  WѤ      .   vendor/studio24/rotate/src/RotateException.php_   տh_    ;      %   vendor/studio24/rotate/src/Rotate.php#  տh#  j      -   vendor/studio24/rotate/src/FilenameFormat.php  տh  =D      -   vendor/studio24/rotate/src/RotateAbstract.php  տh  D      6   vendor/studio24/rotate/src/FilenameFormatException.phpg   տhg   ܙ      %   vendor/studio24/rotate/src/Delete.php|#  տh|#  ؤ      0   vendor/studio24/rotate/src/DirectoryIterator.phpk  տhk  mA      G   vendor/symfony/framework-bundle/DataCollector/AbstractDataCollector.php  տh  xϤ      E   vendor/symfony/framework-bundle/DataCollector/RouterDataCollector.phpD  տhD  }      U   vendor/symfony/framework-bundle/DataCollector/TemplateAwareDataCollectorInterface.phpU  տhU  ~suܤ      '   vendor/symfony/framework-bundle/LICENSE,  տh,  U      7   vendor/symfony/framework-bundle/Test/KernelTestCase.php
  տh
  C>      B   vendor/symfony/framework-bundle/Test/DomCrawlerAssertionsTrait.php  տh  eNʤ      >   vendor/symfony/framework-bundle/Test/MailerAssertionsTrait.phpe  տhe  }w      D   vendor/symfony/framework-bundle/Test/NotificationAssertionsTrait.php%  տh%  *      B   vendor/symfony/framework-bundle/Test/HttpClientAssertionsTrait.php  տh  ~s      B   vendor/symfony/framework-bundle/Test/BrowserKitAssertionsTrait.php!  տh!  탤      9   vendor/symfony/framework-bundle/Test/TestBrowserToken.php  տh  ¾      4   vendor/symfony/framework-bundle/Test/WebTestCase.php  տh  5      ?   vendor/symfony/framework-bundle/Test/WebTestAssertionsTrait.php  տh  *      6   vendor/symfony/framework-bundle/Test/TestContainer.phpP  տhP  Ԕq      ,   vendor/symfony/framework-bundle/CHANGELOG.md  տh  ķ      :   vendor/symfony/framework-bundle/Translation/Translator.phpR  տhR  
H      7   vendor/symfony/framework-bundle/Secrets/SodiumVault.phpK#  տhK#  ?/      7   vendor/symfony/framework-bundle/Secrets/DotenvVault.php8  տh8  U:      9   vendor/symfony/framework-bundle/Secrets/AbstractVault.php  տh  ~p      I   vendor/symfony/framework-bundle/Resources/bin/check-unused-known-tags.php  տh  1      A   vendor/symfony/framework-bundle/Resources/config/asset_mapper.php$  տh$  O)      8   vendor/symfony/framework-bundle/Resources/config/esi.php  տh        @   vendor/symfony/framework-bundle/Resources/config/translation.phpM   տhM   Tפ      ?   vendor/symfony/framework-bundle/Resources/config/serializer.phpy'  տhy'  PF      ?   vendor/symfony/framework-bundle/Resources/config/form_debug.php  տh  "      >   vendor/symfony/framework-bundle/Resources/config/validator.php  տh  iL6Ǥ      >   vendor/symfony/framework-bundle/Resources/config/semaphore.php  տh  4.      @   vendor/symfony/framework-bundle/Resources/config/annotations.php
  տh
  ݋\      >   vendor/symfony/framework-bundle/Resources/config/profiling.php=  տh=  +      ;   vendor/symfony/framework-bundle/Resources/config/mailer.php
  տh
  븤      F   vendor/symfony/framework-bundle/Resources/config/fragment_listener.phpw  տhw  Vg      F   vendor/symfony/framework-bundle/Resources/config/translation_debug.php  տh  $      C   vendor/symfony/framework-bundle/Resources/config/notifier_debug.php  տh  w0      A   vendor/symfony/framework-bundle/Resources/config/rate_limiter.php  տh  |s      9   vendor/symfony/framework-bundle/Resources/config/lock.php  տh  z      H   vendor/symfony/framework-bundle/Resources/config/identity_translator.php  տh  W      @   vendor/symfony/framework-bundle/Resources/config/http_client.phpx
  տhx
  ^?Ϥ      A   vendor/symfony/framework-bundle/Resources/config/mailer_debug.php  տh  `܄       =   vendor/symfony/framework-bundle/Resources/config/services.php]#  տh]#  k      :   vendor/symfony/framework-bundle/Resources/config/cache.php"  տh"  -l7      <   vendor/symfony/framework-bundle/Resources/config/session.php  տh  wr      F   vendor/symfony/framework-bundle/Resources/config/mailer_transports.php  տh  i?
      J   vendor/symfony/framework-bundle/Resources/config/translation_providers.php	  տh	  ?H      :   vendor/symfony/framework-bundle/Resources/config/debug.php  տh  L_      E   vendor/symfony/framework-bundle/Resources/config/notifier_webhook.php  տh  ,      F   vendor/symfony/framework-bundle/Resources/config/fragment_renderer.php	  տh	         =   vendor/symfony/framework-bundle/Resources/config/web_link.phpZ  տhZ  Oj      <   vendor/symfony/framework-bundle/Resources/config/routing.php  տh  A      G   vendor/symfony/framework-bundle/Resources/config/schema/symfony-1.0.xsd  տh  gD1      =   vendor/symfony/framework-bundle/Resources/config/notifier.php  տh  Ec      F   vendor/symfony/framework-bundle/Resources/config/http_client_debug.php  տh  "5$      <   vendor/symfony/framework-bundle/Resources/config/request.php  տh  kP?      9   vendor/symfony/framework-bundle/Resources/config/test.php  տh        <   vendor/symfony/framework-bundle/Resources/config/webhook.php  տh  P쌤      D   vendor/symfony/framework-bundle/Resources/config/validator_debug.php  տh  GU      C   vendor/symfony/framework-bundle/Resources/config/error_renderer.php/  տh/        >   vendor/symfony/framework-bundle/Resources/config/mime_type.php  տh  H̤      >   vendor/symfony/framework-bundle/Resources/config/messenger.php?#  տh?#  Y      <   vendor/symfony/framework-bundle/Resources/config/console.php3  տh3  uҤ      8   vendor/symfony/framework-bundle/Resources/config/uid.php=  տh=  S      B   vendor/symfony/framework-bundle/Resources/config/property_info.php	  տh	  j      >   vendor/symfony/framework-bundle/Resources/config/scheduler.php  տh  1@w      8   vendor/symfony/framework-bundle/Resources/config/ssi.php  տh  5{      8   vendor/symfony/framework-bundle/Resources/config/web.php  տh  k?֓      D   vendor/symfony/framework-bundle/Resources/config/messenger_debug.php  տh  o灤      ?   vendor/symfony/framework-bundle/Resources/config/collectors.phpq  տhq  %(      C   vendor/symfony/framework-bundle/Resources/config/routing/errors.xml  տh  >      D   vendor/symfony/framework-bundle/Resources/config/routing/webhook.xml  տh  Vc      C   vendor/symfony/framework-bundle/Resources/config/html_sanitizer.php  տh  Pդ      <   vendor/symfony/framework-bundle/Resources/config/secrets.php  տh  *n      9   vendor/symfony/framework-bundle/Resources/config/form.php  տh  m17      E   vendor/symfony/framework-bundle/Resources/config/serializer_debug.php  տh        C   vendor/symfony/framework-bundle/Resources/config/workflow_debug.php  տh  RRT      C   vendor/symfony/framework-bundle/Resources/config/mailer_webhook.php
  տh
  dea      >   vendor/symfony/framework-bundle/Resources/config/form_csrf.phpD  տhD  A3U      =   vendor/symfony/framework-bundle/Resources/config/workflow.php  տh  #m7Y      B   vendor/symfony/framework-bundle/Resources/config/security_csrf.php  տh  ~ܤ      H   vendor/symfony/framework-bundle/Resources/config/notifier_transports.php^3  տh^3  |      ?   vendor/symfony/framework-bundle/Resources/config/debug_prod.php  տh  _Q      D   vendor/symfony/framework-bundle/Resources/config/property_access.php  տh  Bʤ      ;   vendor/symfony/framework-bundle/Resources/config/assets.php  տh  v'      @   vendor/symfony/framework-bundle/Resources/config/cache_debug.php  տh  %]      A   vendor/symfony/framework-bundle/Resources/config/remote_event.php  տh  
ä      <   vendor/symfony/framework-bundle/Resources/config/process.phpc  տhc        1   vendor/symfony/framework-bundle/KernelBrowser.php  տh        D   vendor/symfony/framework-bundle/CacheWarmer/ValidatorCacheWarmer.php^
  տh^
  hr      H   vendor/symfony/framework-bundle/CacheWarmer/ConfigBuilderCacheWarmer.phpc  տhc  gp      J   vendor/symfony/framework-bundle/CacheWarmer/AbstractPhpFileCacheWarmer.php
  տh
  $bΤ      A   vendor/symfony/framework-bundle/CacheWarmer/RouterCacheWarmer.php  տh  )      G   vendor/symfony/framework-bundle/CacheWarmer/TranslationsCacheWarmer.php  տh  2e      E   vendor/symfony/framework-bundle/CacheWarmer/SerializerCacheWarmer.php  տh  ^M      K   vendor/symfony/framework-bundle/CacheWarmer/CachePoolClearerCacheWarmer.php  տh  ҧ      F   vendor/symfony/framework-bundle/CacheWarmer/AnnotationsCacheWarmer.php  տh  l      A   vendor/symfony/framework-bundle/Controller/AbstractController.phpH  տhH        A   vendor/symfony/framework-bundle/Controller/TemplateController.php	  տh	  k      A   vendor/symfony/framework-bundle/Controller/ControllerResolver.php3  տh3  0      A   vendor/symfony/framework-bundle/Controller/RedirectController.php  տh  HǤ      )   vendor/symfony/framework-bundle/README.md!  տh!  q      7   vendor/symfony/framework-bundle/HttpCache/HttpCache.php
  տh
  R      3   vendor/symfony/framework-bundle/FrameworkBundle.php3  տh3  ب       >   vendor/symfony/framework-bundle/Command/SecretsListCommand.php
  տh
  cc4      J   vendor/symfony/framework-bundle/Command/CachePoolInvalidateTagsCommand.phpK  տhK  ,ؤ      @   vendor/symfony/framework-bundle/Command/SecretsRemoveCommand.phpw
  տhw
  A      =   vendor/symfony/framework-bundle/Command/CacheClearCommand.php(  տh(  ~      <   vendor/symfony/framework-bundle/Command/XliffLintCommand.php  տh  vtc      H   vendor/symfony/framework-bundle/Command/SecretsDecryptToLocalCommand.php
  տh
        A   vendor/symfony/framework-bundle/Command/AbstractConfigCommand.phpi  տhi  VP      >   vendor/symfony/framework-bundle/Command/RouterDebugCommand.php  տh  s`i      D   vendor/symfony/framework-bundle/Command/TranslationUpdateCommand.php/D  տh/D  F%      F   vendor/symfony/framework-bundle/Command/ConfigDumpReferenceCommand.php8  տh8  !      @   vendor/symfony/framework-bundle/Command/AssetsInstallCommand.php'  տh'  ]3%      A   vendor/symfony/framework-bundle/Command/CachePoolPruneCommand.php  տh  ~T}      A   vendor/symfony/framework-bundle/Command/CachePoolClearCommand.php  տh  ZQ~      @   vendor/symfony/framework-bundle/Command/ContainerLintCommand.php\  տh\  ]6      J   vendor/symfony/framework-bundle/Command/SecretsEncryptFromLocalCommand.php1	  տh1	  dƃ|      B   vendor/symfony/framework-bundle/Command/DebugAutowiringCommand.php  տh  \      >   vendor/symfony/framework-bundle/Command/CacheWarmupCommand.php  տh  :5Τ      ?   vendor/symfony/framework-bundle/Command/WorkflowDumpCommand.phpD  տhD  &      G   vendor/symfony/framework-bundle/Command/EventDispatcherDebugCommand.php  տh   ّY      A   vendor/symfony/framework-bundle/Command/ContainerDebugCommand.phps<  տhs<  _ q      C   vendor/symfony/framework-bundle/Command/TranslationDebugCommand.phpa<  տha<  $      ;   vendor/symfony/framework-bundle/Command/YamlLintCommand.phpA  տhA  Fs      @   vendor/symfony/framework-bundle/Command/CachePoolListCommand.php  տh  ;q      F   vendor/symfony/framework-bundle/Command/SecretsGenerateKeysCommand.php  տh  ֤      B   vendor/symfony/framework-bundle/Command/CachePoolDeleteCommand.php  տh  yUɤ      D   vendor/symfony/framework-bundle/Command/BuildDebugContainerTrait.php
  տh
  ҥ      8   vendor/symfony/framework-bundle/Command/AboutCommand.php  տh  n٤      >   vendor/symfony/framework-bundle/Command/RouterMatchCommand.php7  տh7  }S      =   vendor/symfony/framework-bundle/Command/SecretsSetCommand.php:  տh:        >   vendor/symfony/framework-bundle/Command/ConfigDebugCommand.php4)  տh4)  E^%      J   vendor/symfony/framework-bundle/Routing/RedirectableCompiledUrlMatcher.php!  տh!  )\      J   vendor/symfony/framework-bundle/Routing/AttributeRouteControllerLoader.php  տh  v1)      O   vendor/symfony/framework-bundle/Routing/Attribute/AsRoutingConditionService.php  տh  ny      @   vendor/symfony/framework-bundle/Routing/RouteLoaderInterface.php  տh  b       2   vendor/symfony/framework-bundle/Routing/Router.php  տh  ~Un      <   vendor/symfony/framework-bundle/Routing/DelegatingLoader.php
  տh
  դ      J   vendor/symfony/framework-bundle/Routing/AnnotatedRouteControllerLoader.php
  տh
  y,      E   vendor/symfony/framework-bundle/DependencyInjection/Configuration.php7A տh7A R      J   vendor/symfony/framework-bundle/DependencyInjection/FrameworkExtension.php) տh) $      O   vendor/symfony/framework-bundle/DependencyInjection/VirtualRequestStackPass.php  տh  
w      ^   vendor/symfony/framework-bundle/DependencyInjection/Compiler/ContainerBuilderDebugDumpPass.phpS  տhS  n>.      `   vendor/symfony/framework-bundle/DependencyInjection/Compiler/TestServiceContainerRealRefPass.php	  տh	  j(v      c   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AddExpressionLanguageProvidersPass.phpW  տhW  W*ͤ      O   vendor/symfony/framework-bundle/DependencyInjection/Compiler/UnusedTagsPass.phpt  տht  b"      R   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AssetsContextPass.php  տh  o      X   vendor/symfony/framework-bundle/DependencyInjection/Compiler/ErrorLoggerCompilerPass.php  տh  9/      ]   vendor/symfony/framework-bundle/DependencyInjection/Compiler/TranslationUpdateCommandPass.php  տh        Z   vendor/symfony/framework-bundle/DependencyInjection/Compiler/WorkflowGuardListenerPass.php#  տh#  ,      Z   vendor/symfony/framework-bundle/DependencyInjection/Compiler/EnableLoggerDebugModePass.php  տh  }V      `   vendor/symfony/framework-bundle/DependencyInjection/Compiler/TestServiceContainerWeakRefPass.php@	  տh@	  y`1      V   vendor/symfony/framework-bundle/DependencyInjection/Compiler/LoggingTranslatorPass.phpY  տhY  Nx      \   vendor/symfony/framework-bundle/DependencyInjection/Compiler/DataCollectorTranslatorPass.phpV  տhV  0#      _   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AddAnnotationsCachedReaderPass.php  տh  ~Y      M   vendor/symfony/framework-bundle/DependencyInjection/Compiler/ProfilerPass.php	  տh	  &1      j   vendor/symfony/framework-bundle/DependencyInjection/Compiler/RemoveUnusedSessionMarshallingHandlerPass.php   տh   k)̤      Y   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AddDebugLogProcessorPass.php  տh  `:W      -   vendor/symfony/framework-bundle/composer.json  տh  cFD
      ;   vendor/symfony/framework-bundle/Kernel/MicroKernelTrait.phpf   տhf   ૦      7   vendor/symfony/framework-bundle/Console/Application.phpE   տhE   '23      E   vendor/symfony/framework-bundle/Console/Descriptor/TextDescriptor.phpm  տhm  JL      D   vendor/symfony/framework-bundle/Console/Descriptor/XmlDescriptor.phpj  տhj  ksnU      A   vendor/symfony/framework-bundle/Console/Descriptor/Descriptor.php6  տh6        E   vendor/symfony/framework-bundle/Console/Descriptor/JsonDescriptor.phpD  տhD  vF      I   vendor/symfony/framework-bundle/Console/Descriptor/MarkdownDescriptor.php8I  տh8I  h      C   vendor/symfony/framework-bundle/Console/Helper/DescriptorHelper.php  տh  *      I   vendor/symfony/framework-bundle/EventListener/ConsoleProfilerListener.php  տh  c      Q   vendor/symfony/framework-bundle/EventListener/SuggestMissingPackageSubscriber.php	  տh	  Su      %   vendor/symfony/monolog-bundle/LICENSE)  տh)  Ǥ      *   vendor/symfony/monolog-bundle/CHANGELOG.md  տh  :L      :   vendor/symfony/monolog-bundle/Resources/config/monolog.xml.  տh.   0yK      E   vendor/symfony/monolog-bundle/Resources/config/schema/monolog-1.0.xsd'  տh'  )X      <   vendor/symfony/monolog-bundle/SwiftMailer/MessageFactory.php  տh        '   vendor/symfony/monolog-bundle/README.mdY  տhY        /   vendor/symfony/monolog-bundle/MonologBundle.php  տh  @g      F   vendor/symfony/monolog-bundle/DependencyInjection/MonologExtension.phpi  տhi  ve      C   vendor/symfony/monolog-bundle/DependencyInjection/Configuration.php  տh  vr      P   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/AddProcessorsPass.php  տh  R      P   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/LoggerChannelPass.php  տh        O   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/DebugHandlerPass.php
  տh
  HS      Q   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/FixEmptyLoggerPass.php  տh  DN      Z   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/AddSwiftMailerTransportPass.php  տh   *Q      +   vendor/symfony/monolog-bundle/composer.json  տh  Ǉ      %   vendor/symfony/polyfill-php73/LICENSE,  տh,        '   vendor/symfony/polyfill-php73/Php73.phps  տhs  D\      ?   vendor/symfony/polyfill-php73/Resources/stubs/JsonException.phpE  տhE  8S      +   vendor/symfony/polyfill-php73/bootstrap.php  տh  |      '   vendor/symfony/polyfill-php73/README.md/  տh/  m      +   vendor/symfony/polyfill-php73/composer.json  տh  t      C   vendor/symfony/serializer/DataCollector/SerializerDataCollector.php?  տh?  8      (   vendor/symfony/serializer/Serializer.phpH  տhH  |      I   vendor/symfony/serializer/Mapping/ClassDiscriminatorFromClassMetadata.phpu
  տhu
  5      <   vendor/symfony/serializer/Mapping/ClassMetadataInterface.php3  տh3  闙      3   vendor/symfony/serializer/Mapping/ClassMetadata.phpV
  տhV
  ŏ=      <   vendor/symfony/serializer/Mapping/Loader/AttributeLoader.php+5  տh+5  y      7   vendor/symfony/serializer/Mapping/Loader/FileLoader.phpF  տhF  hդ      <   vendor/symfony/serializer/Mapping/Loader/LoaderInterface.phpY  տhY  
lޤ      ;   vendor/symfony/serializer/Mapping/Loader/YamlFileLoader.php  տh  rF      a   vendor/symfony/serializer/Mapping/Loader/schema/dic/serializer-mapping/serializer-mapping-1.0.xsd  տh  7      :   vendor/symfony/serializer/Mapping/Loader/XmlFileLoader.php  տh  W      8   vendor/symfony/serializer/Mapping/Loader/LoaderChain.php  տh  S*      =   vendor/symfony/serializer/Mapping/Loader/AnnotationLoader.php  տh  a      I   vendor/symfony/serializer/Mapping/ClassDiscriminatorResolverInterface.php  տh  2      @   vendor/symfony/serializer/Mapping/AttributeMetadataInterface.php  տh  v5      ?   vendor/symfony/serializer/Mapping/ClassDiscriminatorMapping.php  տh  2q      J   vendor/symfony/serializer/Mapping/Factory/ClassMetadataFactoryCompiler.phpp  տhp  A
      @   vendor/symfony/serializer/Mapping/Factory/ClassResolverTrait.php+  տh+  u鏤      B   vendor/symfony/serializer/Mapping/Factory/ClassMetadataFactory.php  տh  5      G   vendor/symfony/serializer/Mapping/Factory/CacheClassMetadataFactory.php  տh        J   vendor/symfony/serializer/Mapping/Factory/CompiledClassMetadataFactory.php7  տh7  @IP      K   vendor/symfony/serializer/Mapping/Factory/ClassMetadataFactoryInterface.php  տh  /      7   vendor/symfony/serializer/Mapping/AttributeMetadata.php  տh  j\      1   vendor/symfony/serializer/SerializerInterface.php}  տh}  WY      F   vendor/symfony/serializer/Context/Encoder/CsvEncoderContextBuilder.php  տh  H      F   vendor/symfony/serializer/Context/Encoder/XmlEncoderContextBuilder.php  տh  |̤      G   vendor/symfony/serializer/Context/Encoder/YamlEncoderContextBuilder.php  տh  \      G   vendor/symfony/serializer/Context/Encoder/JsonEncoderContextBuilder.php  տh  ;b      9   vendor/symfony/serializer/Context/ContextBuilderTrait.php  տh  W6      >   vendor/symfony/serializer/Context/SerializerContextBuilder.php  տh  ޵R      =   vendor/symfony/serializer/Context/ContextBuilderInterface.php  տh  n
      O   vendor/symfony/serializer/Context/Normalizer/ObjectNormalizerContextBuilder.php#  տh#  D      Q   vendor/symfony/serializer/Context/Normalizer/DateTimeNormalizerContextBuilder.php  տh  ,P      R   vendor/symfony/serializer/Context/Normalizer/FormErrorNormalizerContextBuilder.php  տh  sڤ      U   vendor/symfony/serializer/Context/Normalizer/GetSetMethodNormalizerContextBuilder.php/  տh/  gB      Y   vendor/symfony/serializer/Context/Normalizer/JsonSerializableNormalizerContextBuilder.php1  տh1  z      P   vendor/symfony/serializer/Context/Normalizer/ProblemNormalizerContextBuilder.php  տh  \oq      W   vendor/symfony/serializer/Context/Normalizer/AbstractObjectNormalizerContextBuilder.phpQ  տhQ  2      S   vendor/symfony/serializer/Context/Normalizer/BackedEnumNormalizerContextBuilder.phpg  տhg  S      `   vendor/symfony/serializer/Context/Normalizer/ConstraintViolationListNormalizerContextBuilder.php7  տh7  gO      U   vendor/symfony/serializer/Context/Normalizer/UnwrappingDenormalizerContextBuilder.php!  տh!  t;9      Q   vendor/symfony/serializer/Context/Normalizer/AbstractNormalizerContextBuilder.php  տh  r㽤      L   vendor/symfony/serializer/Context/Normalizer/UidNormalizerContextBuilder.php  տh  B4      Q   vendor/symfony/serializer/Context/Normalizer/PropertyNormalizerContextBuilder.php  տh  8      U   vendor/symfony/serializer/Context/Normalizer/DateIntervalNormalizerContextBuilder.phpB  տhB  Ѥ      6   vendor/symfony/serializer/Attribute/SerializedName.php  տh  pl      .   vendor/symfony/serializer/Attribute/Ignore.php  տh        /   vendor/symfony/serializer/Attribute/Context.php	  տh	  Oq'      8   vendor/symfony/serializer/Attribute/DiscriminatorMap.php  տh  Ӥ      6   vendor/symfony/serializer/Attribute/SerializedPath.php  տh  <      0   vendor/symfony/serializer/Attribute/MaxDepth.php  տh  [v      .   vendor/symfony/serializer/Attribute/Groups.php  տh  !x
      !   vendor/symfony/serializer/LICENSE,  տh,  U      &   vendor/symfony/serializer/CHANGELOG.md6<  տh6<  qSx      0   vendor/symfony/serializer/Encoder/CsvEncoder.php'  տh'  8zڤ      B   vendor/symfony/serializer/Encoder/ContextAwareDecoderInterface.php  տh  o׍      2   vendor/symfony/serializer/Encoder/ChainEncoder.phpg  տhg  A0      6   vendor/symfony/serializer/Encoder/DecoderInterface.php/  տh/  
      B   vendor/symfony/serializer/Encoder/ContextAwareEncoderInterface.php  տh  Q{N      A   vendor/symfony/serializer/Encoder/NormalizationAwareInterface.phpv  տhv  
/g      6   vendor/symfony/serializer/Encoder/EncoderInterface.php  տh  _J      2   vendor/symfony/serializer/Encoder/ChainDecoder.php  տh  }[      0   vendor/symfony/serializer/Encoder/JsonEncode.php  տh  ۤ      1   vendor/symfony/serializer/Encoder/JsonEncoder.php  տh  w      0   vendor/symfony/serializer/Encoder/JsonDecode.php<  տh<  Dh$      1   vendor/symfony/serializer/Encoder/YamlEncoder.phpq
  տhq
  !y]      0   vendor/symfony/serializer/Encoder/XmlEncoder.phpH  տhH  pbR      J   vendor/symfony/serializer/CacheWarmer/CompiledClassMetadataCacheWarmer.php7  տh7  Ƭc      7   vendor/symfony/serializer/Annotation/SerializedName.php[  տh[  PR      /   vendor/symfony/serializer/Annotation/Ignore.phpC  տhC  𽩤      0   vendor/symfony/serializer/Annotation/Context.php  տh  ;i*      9   vendor/symfony/serializer/Annotation/DiscriminatorMap.phpB  տhB  R?      7   vendor/symfony/serializer/Annotation/SerializedPath.php[  տh[  ޢ6X      1   vendor/symfony/serializer/Annotation/MaxDepth.phpI  տhI  BY      /   vendor/symfony/serializer/Annotation/Groups.php^  տh^  wLN      L   vendor/symfony/serializer/Extractor/ObjectPropertyListExtractorInterface.php^  տh^  $7      C   vendor/symfony/serializer/Extractor/ObjectPropertyListExtractor.php{  տh{  E      6   vendor/symfony/serializer/SerializerAwareInterface.php  տh  M      #   vendor/symfony/serializer/README.mdJ  տhJ  Mc%      B   vendor/symfony/serializer/NameConverter/NameConverterInterface.php  տh  pvEq      J   vendor/symfony/serializer/NameConverter/AdvancedNameConverterInterface.php  տh  6      F   vendor/symfony/serializer/NameConverter/MetadataAwareNameConverter.php  տh  .]      M   vendor/symfony/serializer/NameConverter/CamelCaseToSnakeCaseNameConverter.php8  տh8  \Ѥ      2   vendor/symfony/serializer/Command/DebugCommand.phpy  տhy  2 3      ;   vendor/symfony/serializer/Normalizer/DateTimeNormalizer.php  տh  aZ      >   vendor/symfony/serializer/Normalizer/MimeMessageNormalizer.phpD  տhD  Br͌      @   vendor/symfony/serializer/Normalizer/DenormalizableInterface.phpv  տhv        :   vendor/symfony/serializer/Normalizer/ProblemNormalizer.php  տh  K      I   vendor/symfony/serializer/Normalizer/CacheableSupportsMethodInterface.php"  տh"  Jgɤ      >   vendor/symfony/serializer/Normalizer/ObjectToPopulateTrait.php-  տh-  Ґ~}      <   vendor/symfony/serializer/Normalizer/FormErrorNormalizer.php	  տh	  cI      J   vendor/symfony/serializer/Normalizer/ContextAwareDenormalizerInterface.php7  տh7  #      :   vendor/symfony/serializer/Normalizer/ArrayDenormalizer.php  տh        A   vendor/symfony/serializer/Normalizer/AbstractObjectNormalizer.php  տh  .      ?   vendor/symfony/serializer/Normalizer/DateTimeZoneNormalizer.php  տh  6Ǥ      ?   vendor/symfony/serializer/Normalizer/UnwrappingDenormalizer.php}
  տh}
  /)      =   vendor/symfony/serializer/Normalizer/NormalizerAwareTrait.phpk  տhk  #      A   vendor/symfony/serializer/Normalizer/NormalizerAwareInterface.php%  տh%  :]R      C   vendor/symfony/serializer/Normalizer/JsonSerializableNormalizer.php1
  տh1
  PC      :   vendor/symfony/serializer/Normalizer/DataUriNormalizer.php  տh  %      H   vendor/symfony/serializer/Normalizer/ContextAwareNormalizerInterface.php  տh  +      9   vendor/symfony/serializer/Normalizer/CustomNormalizer.phpB  տhB  O(      C   vendor/symfony/serializer/Normalizer/DenormalizerAwareInterface.php/  տh/  <ǖ      ?   vendor/symfony/serializer/Normalizer/DateIntervalNormalizer.php  տh  zԋ      ;   vendor/symfony/serializer/Normalizer/PropertyNormalizer.php#  տh#        9   vendor/symfony/serializer/Normalizer/ObjectNormalizer.php!  տh!  cRb      ;   vendor/symfony/serializer/Normalizer/AbstractNormalizer.phpa  տha  Pt      ?   vendor/symfony/serializer/Normalizer/TranslatableNormalizer.php  տh  Z7(G      6   vendor/symfony/serializer/Normalizer/UidNormalizer.php  տh   ru      >   vendor/symfony/serializer/Normalizer/DenormalizerInterface.php
  տh
  Vi3      >   vendor/symfony/serializer/Normalizer/NormalizableInterface.php  տh        ?   vendor/symfony/serializer/Normalizer/GetSetMethodNormalizer.php  տh  ṗ      =   vendor/symfony/serializer/Normalizer/BackedEnumNormalizer.php,  տh,  g      J   vendor/symfony/serializer/Normalizer/ConstraintViolationListNormalizer.php  տh  o      <   vendor/symfony/serializer/Normalizer/NormalizerInterface.php  տh  e      ?   vendor/symfony/serializer/Normalizer/DenormalizerAwareTrait.php{  տh{  o      2   vendor/symfony/serializer/SerializerAwareTrait.php`  տh`  ĝ|      @   vendor/symfony/serializer/DependencyInjection/SerializerPass.php
  տh
        6   vendor/symfony/serializer/Exception/LogicException.php  տh  A      :   vendor/symfony/serializer/Exception/ExceptionInterface.php  տh  Za      L   vendor/symfony/serializer/Exception/MissingConstructorArgumentsException.php  տh  a      @   vendor/symfony/serializer/Exception/UnexpectedValueException.php  տh  rǤ      8   vendor/symfony/serializer/Exception/RuntimeException.php  տh  VX      E   vendor/symfony/serializer/Exception/NotNormalizableValueException.phpc  տhc  N͜      @   vendor/symfony/serializer/Exception/InvalidArgumentException.php  տh  n      B   vendor/symfony/serializer/Exception/CircularReferenceException.php  տh  s5      >   vendor/symfony/serializer/Exception/BadMethodCallException.php  տh  }
      8   vendor/symfony/serializer/Exception/MappingException.php  տh  Ǡۤ      <   vendor/symfony/serializer/Exception/UnsupportedException.php  տh         B   vendor/symfony/serializer/Exception/NotEncodableValueException.php  տh  \53      G   vendor/symfony/serializer/Exception/PartialDenormalizationException.phpM  տhM  D      B   vendor/symfony/serializer/Exception/UnsupportedFormatException.php  տh  G`k      @   vendor/symfony/serializer/Exception/ExtraAttributesException.php  տh  3ٌ      '   vendor/symfony/serializer/composer.json	  տh	  ɮ      4   vendor/symfony/serializer/Debug/TraceableEncoder.php'  տh'  hͤ      7   vendor/symfony/serializer/Debug/TraceableSerializer.php  տh  ɸ      7   vendor/symfony/serializer/Debug/TraceableNormalizer.phpa  տha  ;ݤ      *   vendor/symfony/polyfill-php80/PhpToken.php  տh  dF      %   vendor/symfony/polyfill-php80/LICENSE,  տh,  K      :   vendor/symfony/polyfill-php80/Resources/stubs/PhpToken.phpw  տhw  =7T8      <   vendor/symfony/polyfill-php80/Resources/stubs/ValueError.php>  տh>  g      ;   vendor/symfony/polyfill-php80/Resources/stubs/Attribute.php  տh  MK<      E   vendor/symfony/polyfill-php80/Resources/stubs/UnhandledMatchError.phpG  տhG  ֈ+      <   vendor/symfony/polyfill-php80/Resources/stubs/Stringable.php  տh  t]\ڤ      +   vendor/symfony/polyfill-php80/bootstrap.php  տh  .Ĥ      '   vendor/symfony/polyfill-php80/README.md  տh  "tF      '   vendor/symfony/polyfill-php80/Php80.php  տh  H      +   vendor/symfony/polyfill-php80/composer.jsonb  տhb  F      7   vendor/symfony/monolog-bridge/Handler/MailerHandler.php  տh  1d      H   vendor/symfony/monolog-bridge/Handler/CompatibilityProcessingHandler.php  տh        8   vendor/symfony/monolog-bridge/Handler/ConsoleHandler.php  տh  Ѻ	      S   vendor/symfony/monolog-bridge/Handler/FingersCrossed/HttpCodeActivationStrategy.php  տh  c      S   vendor/symfony/monolog-bridge/Handler/FingersCrossed/NotFoundActivationStrategy.phpT  տhT  s      :   vendor/symfony/monolog-bridge/Handler/ServerLogHandler.php  տh  \~      >   vendor/symfony/monolog-bridge/Handler/CompatibilityHandler.php  տh  !E      9   vendor/symfony/monolog-bridge/Handler/NotifierHandler.php	  տh	  %ˤ      8   vendor/symfony/monolog-bridge/Handler/FirePHPHandler.php  տh  J      :   vendor/symfony/monolog-bridge/Handler/ChromePhpHandler.php0  տh0  ݤ      F   vendor/symfony/monolog-bridge/Handler/ElasticsearchLogstashHandler.php  տh  I6      (   vendor/symfony/monolog-bridge/Logger.php-
  տh-
  y      %   vendor/symfony/monolog-bridge/LICENSE,  տh,  U      *   vendor/symfony/monolog-bridge/CHANGELOG.md
  տh
  `s      :   vendor/symfony/monolog-bridge/Processor/TokenProcessor.php<  տh<  ]      D   vendor/symfony/monolog-bridge/Processor/SwitchUserTokenProcessor.php  տh  A܊      8   vendor/symfony/monolog-bridge/Processor/WebProcessor.php  տh        B   vendor/symfony/monolog-bridge/Processor/CompatibilityProcessor.php!  տh!  6$      :   vendor/symfony/monolog-bridge/Processor/RouteProcessor.php	  տh	  <      C   vendor/symfony/monolog-bridge/Processor/ConsoleCommandProcessor.phpJ  տhJ  ZU      B   vendor/symfony/monolog-bridge/Processor/AbstractTokenProcessor.php  տh  dC      :   vendor/symfony/monolog-bridge/Processor/DebugProcessor.php  տh  c4      '   vendor/symfony/monolog-bridge/README.md  տh  =~      <   vendor/symfony/monolog-bridge/Formatter/ConsoleFormatter.php  տh  Pp      >   vendor/symfony/monolog-bridge/Formatter/VarDumperFormatter.php0  տh0  r~ݤ      B   vendor/symfony/monolog-bridge/Formatter/CompatibilityFormatter.php  տh  ˦k      :   vendor/symfony/monolog-bridge/Command/ServerLogCommand.php  տh        +   vendor/symfony/monolog-bridge/composer.json  տh  -}b      9   vendor/symfony/cache/DataCollector/CacheDataCollector.php  տh        "   vendor/symfony/cache/CacheItem.php  տh  =g      #   vendor/symfony/cache/Psr16Cache.php=  տh=  8`c         vendor/symfony/cache/LICENSE,  տh,  X      +   vendor/symfony/cache/PruneableInterface.php  տh  a]      !   vendor/symfony/cache/CHANGELOG.mdo  տho  ʗXJ      5   vendor/symfony/cache/Traits/RedisClusterNodeProxy.php  տh  &yF      /   vendor/symfony/cache/Traits/RelayProxyTrait.php  տh  R      *   vendor/symfony/cache/Traits/RedisTrait.phpju  տhju  ?Τ      +   vendor/symfony/cache/Traits/Redis5Proxy.php׷  տh׷  \٤      2   vendor/symfony/cache/Traits/RedisCluster6Proxy.phps  տhs  Q      *   vendor/symfony/cache/Traits/ProxyTrait.php%  տh%  P      5   vendor/symfony/cache/Traits/FilesystemCommonTrait.php9  տh9        1   vendor/symfony/cache/Traits/RedisClusterProxy.php  տh  `"      *   vendor/symfony/cache/Traits/RedisProxy.php  տh  G.r      .   vendor/symfony/cache/Traits/ContractsTrait.php&  տh&  .M=      *   vendor/symfony/cache/Traits/RelayProxy.php^  տh^        0   vendor/symfony/cache/Traits/Redis6ProxyTrait.php  տh  P      ,   vendor/symfony/cache/Traits/ValueWrapper.phpE  տhE  i7      2   vendor/symfony/cache/Traits/RedisCluster5Proxy.php\  տh\  UҤ      /   vendor/symfony/cache/Traits/FilesystemTrait.php  տh  7      +   vendor/symfony/cache/Traits/Redis6Proxy.php  տh  X      4   vendor/symfony/cache/Traits/Relay/GeosearchTrait.php'  տh'  7      /   vendor/symfony/cache/Traits/Relay/MoveTrait.php  տh  [r      2   vendor/symfony/cache/Traits/Relay/PfcountTrait.php  տh  D      /   vendor/symfony/cache/Traits/Relay/CopyTrait.php  տh  ѽ      9   vendor/symfony/cache/Traits/Relay/NullableReturnTrait.phpZ  տhZ  *zʤ      2   vendor/symfony/cache/Traits/Relay/Relay11Trait.phpv  տhv  n      /   vendor/symfony/cache/Traits/Relay/HsetTrait.php  տh  E      1   vendor/symfony/cache/Traits/Relay/SwapdbTrait.php  տh  b      3   vendor/symfony/cache/Traits/Relay/GetrangeTrait.php  տh  XԖ      4   vendor/symfony/cache/Traits/Relay/IsTrackedTrait.php  տh  5      -   vendor/symfony/cache/Traits/Relay/FtTrait.php  տh  0C      6   vendor/symfony/cache/Traits/Relay/GetWithMetaTrait.php  տh  ^D      1   vendor/symfony/cache/Traits/Relay/BgsaveTrait.php  տh  )¤      4   vendor/symfony/cache/Traits/AbstractAdapterTrait.php\0  տh\0  1Ť      7   vendor/symfony/cache/Traits/RedisCluster6ProxyTrait.php  տh  Xm      -   vendor/symfony/cache/Adapter/ProxyAdapter.php_  տh_  <      ,   vendor/symfony/cache/Adapter/ApcuAdapter.php?
  տh?
  [/      ;   vendor/symfony/cache/Adapter/CouchbaseCollectionAdapter.php  տh  ƫ}      1   vendor/symfony/cache/Adapter/TraceableAdapter.php  տh  
bJ6      +   vendor/symfony/cache/Adapter/PdoAdapter.phpA  տhA        -   vendor/symfony/cache/Adapter/ArrayAdapter.php,  տh,  ߍ       5   vendor/symfony/cache/Adapter/RedisTagAwareAdapter.php0  տh0  1      7   vendor/symfony/cache/Adapter/CouchbaseBucketAdapter.php  տh  <^      ,   vendor/symfony/cache/Adapter/NullAdapter.php  տh  :@      4   vendor/symfony/cache/Adapter/ParameterNormalizer.php  տh  +      0   vendor/symfony/cache/Adapter/TagAwareAdapter.php,  տh,  mX      0   vendor/symfony/cache/Adapter/PhpFilesAdapter.php(  տh(   &      4   vendor/symfony/cache/Adapter/DoctrineDbalAdapter.phpA  տhA  nƬq      9   vendor/symfony/cache/Adapter/TagAwareAdapterInterface.php	  տh	  ?      1   vendor/symfony/cache/Adapter/MemcachedAdapter.php4  տh4  N9T      -   vendor/symfony/cache/Adapter/RedisAdapter.php/  տh/  -U=$      1   vendor/symfony/cache/Adapter/AdapterInterface.php  տh  $B      :   vendor/symfony/cache/Adapter/FilesystemTagAwareAdapter.php#  տh#  ˤ      9   vendor/symfony/cache/Adapter/TraceableTagAwareAdapter.php  տh  6s:      -   vendor/symfony/cache/Adapter/Psr16Adapter.php*  տh*  $\      -   vendor/symfony/cache/Adapter/ChainAdapter.php]"  տh]"  x      2   vendor/symfony/cache/Adapter/FilesystemAdapter.php  տh  (Acb      0   vendor/symfony/cache/Adapter/AbstractAdapter.php2  տh2  @2      8   vendor/symfony/cache/Adapter/AbstractTagAwareAdapter.php1  տh1  ;,      0   vendor/symfony/cache/Adapter/PhpArrayAdapter.php/  տh/   Ť      %   vendor/symfony/cache/LockRegistry.php  տh  )?Ӥ      ,   vendor/symfony/cache/ResettableInterface.php  տh  NR         vendor/symfony/cache/README.md  տh  `t:      9   vendor/symfony/cache/Messenger/EarlyExpirationHandler.php7
  տh7
  r      9   vendor/symfony/cache/Messenger/EarlyExpirationMessage.php
  տh
  %      <   vendor/symfony/cache/Messenger/EarlyExpirationDispatcher.php	  տh	  q      5   vendor/symfony/cache/Marshaller/DefaultMarshaller.phpK  տhK  h&      5   vendor/symfony/cache/Marshaller/DeflateMarshaller.php  տh  C      7   vendor/symfony/cache/Marshaller/MarshallerInterface.php3  տh3  Ǚ      6   vendor/symfony/cache/Marshaller/TagAwareMarshaller.php  տh  t      4   vendor/symfony/cache/Marshaller/SodiumMarshaller.php`	  տh`	  F      :   vendor/symfony/cache/DependencyInjection/CachePoolPass.php'  տh'  1i      @   vendor/symfony/cache/DependencyInjection/CachePoolPrunerPass.php  տh  m}      ?   vendor/symfony/cache/DependencyInjection/CacheCollectorPass.php  տh  t      A   vendor/symfony/cache/DependencyInjection/CachePoolClearerPass.php  տh  Ł:      1   vendor/symfony/cache/Exception/LogicException.php  տh  9d      ;   vendor/symfony/cache/Exception/InvalidArgumentException.php  տh  j      1   vendor/symfony/cache/Exception/CacheException.php  տh  Q4      "   vendor/symfony/cache/composer.json  տh  Fw      -   vendor/symfony/polyfill-ctype/bootstrap80.phpr  տhr  F)      %   vendor/symfony/polyfill-ctype/LICENSE,  տh,        +   vendor/symfony/polyfill-ctype/bootstrap.php@  տh@  jQ9      '   vendor/symfony/polyfill-ctype/README.md^  տh^  lHk      '   vendor/symfony/polyfill-ctype/Ctype.php  տh   /      +   vendor/symfony/polyfill-ctype/composer.json  տh  9      %   vendor/symfony/polyfill-php81/LICENSE,  տh,  0      F   vendor/symfony/polyfill-php81/Resources/stubs/ReturnTypeWillChange.php  տh  5+      @   vendor/symfony/polyfill-php81/Resources/stubs/CURLStringFile.php  տh  JT      +   vendor/symfony/polyfill-php81/bootstrap.php  տh  <P      '   vendor/symfony/polyfill-php81/README.md  տh        '   vendor/symfony/polyfill-php81/Php81.php  տh  3E      +   vendor/symfony/polyfill-php81/composer.json  տh  #@      F   vendor/symfony/security-bundle/DataCollector/SecurityDataCollector.php>.  տh>.  n      &   vendor/symfony/security-bundle/LICENSE,  տh,  U      +   vendor/symfony/security-bundle/CHANGELOG.mdCD  տhCD  ;      ?   vendor/symfony/security-bundle/Security/LazyFirewallContext.php	  տh	  Ӈ      =   vendor/symfony/security-bundle/Security/UserAuthenticator.php>  տh>  @      ;   vendor/symfony/security-bundle/Security/FirewallContext.php  տh  	͢      7   vendor/symfony/security-bundle/Security/FirewallMap.php;	  տh;	  5r\      :   vendor/symfony/security-bundle/Security/FirewallConfig.php	  տh	  `9p      >   vendor/symfony/security-bundle/Security/FirewallAwareTrait.php  տh  s      W   vendor/symfony/security-bundle/Resources/config/security_authenticator_access_token.php  տh  43MU      C   vendor/symfony/security-bundle/Resources/config/templating_twig.php  տh  @']      F   vendor/symfony/security-bundle/Resources/config/security_listeners.php  տh  Ne      U   vendor/symfony/security-bundle/Resources/config/security_authenticator_login_link.php	  տh	  +      B   vendor/symfony/security-bundle/Resources/config/security_debug.php3  տh3  6!H!      A   vendor/symfony/security-bundle/Resources/config/debug_console.php   տh         G   vendor/symfony/security-bundle/Resources/config/schema/security-1.0.xsdX  տhX  f#      ;   vendor/symfony/security-bundle/Resources/config/console.php  տh  ,      C   vendor/symfony/security-bundle/Resources/config/password_hasher.php  տh  J      >   vendor/symfony/security-bundle/Resources/config/collectors.php  տh  u|      J   vendor/symfony/security-bundle/Resources/config/security_authenticator.php  տh  VQ      <   vendor/symfony/security-bundle/Resources/config/security.php	.  տh	.  អ      V   vendor/symfony/security-bundle/Resources/config/security_authenticator_remember_me.php  տh  K      A   vendor/symfony/security-bundle/Resources/views/Collector/icon.svg  տh  0צ      K   vendor/symfony/security-bundle/Resources/views/Collector/security.html.twige  տhe  Y      D   vendor/symfony/security-bundle/CacheWarmer/ExpressionCacheWarmer.phpq  տhq  50      1   vendor/symfony/security-bundle/SecurityBundle.php  տh  7-X      (   vendor/symfony/security-bundle/README.md  տh  [A      H   vendor/symfony/security-bundle/RememberMe/DecoratedRememberMeHandler.php^  տh^  H:y      L   vendor/symfony/security-bundle/RememberMe/FirewallAwareRememberMeHandler.php@  տh@  G٤      ?   vendor/symfony/security-bundle/Command/DebugFirewallCommand.php"  տh"  ž&x      <   vendor/symfony/security-bundle/Routing/LogoutRouteLoader.php=  տh=  פ      +   vendor/symfony/security-bundle/Security.php1&  տh1&  ~,      J   vendor/symfony/security-bundle/LoginLink/FirewallAwareLoginLinkHandler.php	  տh	  ߡ      H   vendor/symfony/security-bundle/DependencyInjection/MainConfiguration.phpS9  տhS9  |      c   vendor/symfony/security-bundle/DependencyInjection/Security/AccessToken/OidcTokenHandlerFactory.php3  տh3  V      k   vendor/symfony/security-bundle/DependencyInjection/Security/AccessToken/OidcUserInfoTokenHandlerFactory.php
  տh
  ~G      f   vendor/symfony/security-bundle/DependencyInjection/Security/AccessToken/ServiceTokenHandlerFactory.php  տh  CWߤ      h   vendor/symfony/security-bundle/DependencyInjection/Security/AccessToken/TokenHandlerFactoryInterface.php  տh  w(      X   vendor/symfony/security-bundle/DependencyInjection/Security/UserProvider/LdapFactory.php	  տh	  HX      \   vendor/symfony/security-bundle/DependencyInjection/Security/UserProvider/InMemoryFactory.php  տh  bHq      i   vendor/symfony/security-bundle/DependencyInjection/Security/UserProvider/UserProviderFactoryInterface.php  տh  vi      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/LoginLinkFactory.phpm  տhm  pSʤ      \   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/HttpBasicLdapFactory.php  տh  (腊      \   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/JsonLoginLdapFactory.php  տh  Rz      Z   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/AccessTokenFactory.php  տh  AY      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/FormLoginFactory.phpv  տhv  zä      \   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/FormLoginLdapFactory.phpK  տhK  pR      b   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/CustomAuthenticatorFactory.php  տh  Xi      Y   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/RemoteUserFactory.php  տh  :Pդ      e   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/AuthenticatorFactoryInterface.phpG  տhG  3S      Y   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/RememberMeFactory.php*  տh*  隤      W   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/AbstractFactory.php  տh  p      S   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/X509Factory.php  տh  Vr@      a   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/SignatureAlgorithmFactory.phpf  տhf  P      h   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/FirewallListenerFactoryInterface.php  տh  }/      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/JsonLoginFactory.php  տh  
      n   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/StatelessAuthenticatorFactoryInterface.php	  տh	  9̤      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/HttpBasicFactory.php  տh  soF      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/LdapFactoryTrait.phpm	  տhm	  盤      ^   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/LoginThrottlingFactory.php  տh  .b      H   vendor/symfony/security-bundle/DependencyInjection/SecurityExtension.php  տh  A      b   vendor/symfony/security-bundle/DependencyInjection/Compiler/AddExpressionLanguageProvidersPass.php  տh  ߐ*7      ^   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterTokenUsageTrackingPass.php	  տh	  І;      W   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterLdapLocatorPass.phpW  տhW  9k      h   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterGlobalSecurityEventListenersPass.php 
  տh 
  Ǔ      Y   vendor/symfony/security-bundle/DependencyInjection/Compiler/SortFirewallListenersPass.phpO  տhO  դ      e   vendor/symfony/security-bundle/DependencyInjection/Compiler/ReplaceDecoratedRememberMeHandlerPass.php	  տh	  >y      ^   vendor/symfony/security-bundle/DependencyInjection/Compiler/AddSessionDomainConstraintPass.php  տh  x      U   vendor/symfony/security-bundle/DependencyInjection/Compiler/AddSecurityVotersPass.php
  տh
  rҤ      V   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterEntryPointPass.php  տh  d%      i   vendor/symfony/security-bundle/DependencyInjection/Compiler/MakeFirewallsEventDispatcherTraceablePass.php`
  տh`
  U
p3      [   vendor/symfony/security-bundle/DependencyInjection/Compiler/CleanRememberMeVerifierPass.php  տh  "*A      X   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterCsrfFeaturesPass.php	  տh	  8I      ,   vendor/symfony/security-bundle/composer.json  տh  ֛      B   vendor/symfony/security-bundle/Debug/TraceableFirewallListener.phpN  տhN  Z.      8   vendor/symfony/security-bundle/Debug/WrappedListener.php  տh  D      ?   vendor/symfony/security-bundle/Debug/TraceableListenerTrait.phpj  տhj  qU      <   vendor/symfony/security-bundle/Debug/WrappedLazyListener.php  տh  
9      A   vendor/symfony/security-bundle/EventListener/FirewallListener.php  տh  +C      =   vendor/symfony/security-bundle/EventListener/VoteListener.phpB  տhB  <ˊϤ      4   vendor/symfony/config/ResourceCheckerConfigCache.php~  տh~  p         vendor/symfony/config/LICENSE,  տh,  U      '   vendor/symfony/config/Util/XmlUtils.php$  տh$  U6      <   vendor/symfony/config/Util/Exception/XmlParsingException.php  տh  䢗      <   vendor/symfony/config/Util/Exception/InvalidXmlException.php4  տh4        "   vendor/symfony/config/CHANGELOG.mde  տhe  (,      .   vendor/symfony/config/ConfigCacheInterface.php  տh  	1      .   vendor/symfony/config/FileLocatorInterface.php  տh        %   vendor/symfony/config/ConfigCache.php  տh  S      5   vendor/symfony/config/ConfigCacheFactoryInterface.php  տh  ^&      %   vendor/symfony/config/FileLocator.php4
  տh4
  =      2   vendor/symfony/config/ResourceCheckerInterface.php  տh  åؤ         vendor/symfony/config/README.mdT  տhT        '   vendor/symfony/config/Loader/Loader.php  տh  IѤ      >   vendor/symfony/config/Loader/DirectoryAwareLoaderInterface.php  տh  j=      +   vendor/symfony/config/Loader/FileLoader.php  տh  bUL      2   vendor/symfony/config/Loader/ParamConfigurator.phpq  տhq  n݁      0   vendor/symfony/config/Loader/LoaderInterface.phpy  տhy  ঽ      8   vendor/symfony/config/Loader/LoaderResolverInterface.php  տh  G/3      /   vendor/symfony/config/Loader/LoaderResolver.phpF  տhF  )%%      1   vendor/symfony/config/Loader/DelegatingLoader.php  տh  Κ%      /   vendor/symfony/config/Loader/GlobFileLoader.php  տh  [      .   vendor/symfony/config/Definition/FloatNode.php  տh  Ť      -   vendor/symfony/config/Definition/BaseNode.php:  տh:  qY6      0   vendor/symfony/config/Definition/NumericNode.php)  տh)  	ä      :   vendor/symfony/config/Definition/ConfigurableInterface.phpo  տho  jש,      0   vendor/symfony/config/Definition/IntegerNode.phpV  տhV  (      ;   vendor/symfony/config/Definition/PrototypeNodeInterface.phpp  տhp  <5@      2   vendor/symfony/config/Definition/Configuration.php  տh  j      8   vendor/symfony/config/Definition/PrototypedArrayNode.php,  տh,  d#      .   vendor/symfony/config/Definition/Processor.php	  տh	   \      @   vendor/symfony/config/Definition/Loader/DefinitionFileLoader.php  տh   "      2   vendor/symfony/config/Definition/NodeInterface.phpL  տhL  Q      -   vendor/symfony/config/Definition/EnumNode.php
  տh
  |      0   vendor/symfony/config/Definition/BooleanNode.php  տh  
B      H   vendor/symfony/config/Definition/Configurator/DefinitionConfigurator.phpy  տhy  =      .   vendor/symfony/config/Definition/ArrayNode.php.  տh.  ͤ      /   vendor/symfony/config/Definition/ScalarNode.php}  տh}  GrI      ;   vendor/symfony/config/Definition/ConfigurationInterface.php  տh  _+      8   vendor/symfony/config/Definition/Builder/ExprBuilder.phpL  տhL  :^      ?   vendor/symfony/config/Definition/Builder/EnumNodeDefinition.php  տh  <      9   vendor/symfony/config/Definition/Builder/MergeBuilder.php  տh  |      B   vendor/symfony/config/Definition/Builder/NumericNodeDefinition.phpm  տhm  Mg      8   vendor/symfony/config/Definition/Builder/NodeBuilder.php  տh  |פ      C   vendor/symfony/config/Definition/Builder/VariableNodeDefinition.phpg  տhg  ?      @   vendor/symfony/config/Definition/Builder/ArrayNodeDefinition.php=  տh=  M}      B   vendor/symfony/config/Definition/Builder/BuilderAwareInterface.phpl  տhl  %      >   vendor/symfony/config/Definition/Builder/ValidationBuilder.php  տh  ]
      8   vendor/symfony/config/Definition/Builder/TreeBuilder.phpE  տhE  O      B   vendor/symfony/config/Definition/Builder/IntegerNodeDefinition.php  տh  \+F}      @   vendor/symfony/config/Definition/Builder/NodeParentInterface.php  տh  ʤ      A   vendor/symfony/config/Definition/Builder/NormalizationBuilder.php  տh  Xä      B   vendor/symfony/config/Definition/Builder/BooleanNodeDefinition.php  տh  YDq      J   vendor/symfony/config/Definition/Builder/ParentNodeDefinitionInterface.php  տh  Σ      A   vendor/symfony/config/Definition/Builder/ScalarNodeDefinition.php  տh  *@      @   vendor/symfony/config/Definition/Builder/FloatNodeDefinition.php  տh  ю      ;   vendor/symfony/config/Definition/Builder/NodeDefinition.phpf  տhf  3Ԥ      D   vendor/symfony/config/Definition/Exception/DuplicateKeyException.phpS  տhS  g      I   vendor/symfony/config/Definition/Exception/InvalidDefinitionException.php  տh  re      C   vendor/symfony/config/Definition/Exception/InvalidTypeException.php  տh  2      @   vendor/symfony/config/Definition/Exception/UnsetKeyException.php*  տh*  %2d      L   vendor/symfony/config/Definition/Exception/InvalidConfigurationException.php  տh  i      J   vendor/symfony/config/Definition/Exception/ForbiddenOverwriteException.php_  տh_  :      8   vendor/symfony/config/Definition/Exception/Exception.php  տh  RrO      1   vendor/symfony/config/Definition/VariableNode.php
  տh
  o      ?   vendor/symfony/config/Definition/Dumper/YamlReferenceDumper.php   տh   0      >   vendor/symfony/config/Definition/Dumper/XmlReferenceDumper.php'  տh'        @   vendor/symfony/config/Resource/SelfCheckingResourceInterface.php  տh  2Ф      /   vendor/symfony/config/Resource/FileResource.php  տh  a      :   vendor/symfony/config/Resource/ReflectionClassResource.php7  տh7        >   vendor/symfony/config/Resource/SelfCheckingResourceChecker.php}  տh}  r      3   vendor/symfony/config/Resource/ComposerResource.php2  տh2  3Pu      8   vendor/symfony/config/Resource/FileExistenceResource.php  տh  w}      4   vendor/symfony/config/Resource/ResourceInterface.php  տh  8I      9   vendor/symfony/config/Resource/ClassExistenceResource.php   տh   T$      4   vendor/symfony/config/Resource/DirectoryResource.php
  տh
  C      /   vendor/symfony/config/Resource/GlobResource.phpW!  տhW!  ׏3      8   vendor/symfony/config/Builder/ConfigBuilderInterface.php  տh  {O      (   vendor/symfony/config/Builder/Method.php  տh  @֤      .   vendor/symfony/config/Builder/ClassBuilder.php  տh        *   vendor/symfony/config/Builder/Property.php,  տh,  _      A   vendor/symfony/config/Builder/ConfigBuilderGeneratorInterface.php  տh        8   vendor/symfony/config/Builder/ConfigBuilderGenerator.phpvS  տhvS  U(      7   vendor/symfony/config/Exception/LoaderLoadException.php  տh  /z      N   vendor/symfony/config/Exception/FileLoaderImportCircularReferenceException.php[  տh[  `ܤ      D   vendor/symfony/config/Exception/FileLocatorFileNotFoundException.phpK  տhK  f      #   vendor/symfony/config/composer.json   տh   M      ,   vendor/symfony/config/ConfigCacheFactory.phpS  տhS  cġ      ;   vendor/symfony/config/ResourceCheckerConfigCacheFactory.php5  տh5  Yb      D   vendor/symfony/security-http/RateLimiter/DefaultLoginRateLimiter.php  տh  b      4   vendor/symfony/security-http/Attribute/IsGranted.php  տh  `A      6   vendor/symfony/security-http/Attribute/CurrentUser.php!  տh!  C      $   vendor/symfony/security-http/LICENSE,  տh,  U      5   vendor/symfony/security-http/Util/TargetPathTrait.phpb  տhb  6=Y      )   vendor/symfony/security-http/CHANGELOG.md  տh  k      ,   vendor/symfony/security-http/FirewallMap.php  տh  A
C      )   vendor/symfony/security-http/Firewall.php1  տh1  o:      J   vendor/symfony/security-http/AccessToken/AccessTokenExtractorInterface.phpf  տhf  }P      H   vendor/symfony/security-http/AccessToken/AccessTokenHandlerInterface.php  տh  msl      G   vendor/symfony/security-http/AccessToken/HeaderAccessTokenExtractor.php8  տh8  h      F   vendor/symfony/security-http/AccessToken/ChainAccessTokenExtractor.php'  տh'  g
      J   vendor/symfony/security-http/AccessToken/Oidc/OidcUserInfoTokenHandler.phpc	  տhc	        ;   vendor/symfony/security-http/AccessToken/Oidc/OidcTrait.php  տh  ̤      B   vendor/symfony/security-http/AccessToken/Oidc/OidcTokenHandler.php  տh        U   vendor/symfony/security-http/AccessToken/Oidc/Exception/InvalidSignatureException.php  տh  +FL      Q   vendor/symfony/security-http/AccessToken/Oidc/Exception/MissingClaimException.php  տh  	      E   vendor/symfony/security-http/AccessToken/FormEncodedBodyExtractor.phpm  տhm  }      F   vendor/symfony/security-http/AccessToken/QueryAccessTokenExtractor.php  տh  w      :   vendor/symfony/security-http/Logout/LogoutUrlGenerator.phpv  տhv  +      /   vendor/symfony/security-http/SecurityEvents.php  տh  7      8   vendor/symfony/security-http/Firewall/AccessListener.php
  տh
  8ä      9   vendor/symfony/security-http/Firewall/ContextListener.php5  տh5  d`ۤ      :   vendor/symfony/security-http/Firewall/AbstractListener.phpq  տhq        F   vendor/symfony/security-http/Firewall/AuthenticatorManagerListener.phpj  տhj  ʯ      ;   vendor/symfony/security-http/Firewall/ExceptionListener.phpf(  տhf(  ti      C   vendor/symfony/security-http/Firewall/FirewallListenerInterface.php=  տh=  9      9   vendor/symfony/security-http/Firewall/ChannelListener.php  տh  2      <   vendor/symfony/security-http/Firewall/SwitchUserListener.phpE$  տhE$  hް      8   vendor/symfony/security-http/Firewall/LogoutListener.php  տh  (3\      F   vendor/symfony/security-http/Controller/SecurityTokenValueResolver.php  տh  J;Y      =   vendor/symfony/security-http/Controller/UserValueResolver.php  տh  ؉M      &   vendor/symfony/security-http/README.md  տh  k      <   vendor/symfony/security-http/RememberMe/ResponseListener.php  տh         G   vendor/symfony/security-http/RememberMe/PersistentRememberMeHandler.php   տh   V      F   vendor/symfony/security-http/RememberMe/RememberMeHandlerInterface.php
  տh
  	~¤      =   vendor/symfony/security-http/RememberMe/RememberMeDetails.phpQ  տhQ  Gk<[      E   vendor/symfony/security-http/RememberMe/AbstractRememberMeHandler.phpX  տhX  a*      F   vendor/symfony/security-http/RememberMe/SignatureRememberMeHandler.php
  տh
  xo$f      M   vendor/symfony/security-http/EntryPoint/AuthenticationEntryPointInterface.php  տh  3i      N   vendor/symfony/security-http/EntryPoint/Exception/NotAnEntryPointException.php  տh  (6      *   vendor/symfony/security-http/HttpUtils.php  տh  e      5   vendor/symfony/security-http/FirewallMapInterface.phpP  տhP  !      L   vendor/symfony/security-http/Authenticator/Token/PostAuthenticationToken.phpT  տhT  H      P   vendor/symfony/security-http/Authenticator/InteractiveAuthenticatorInterface.phpj  տhj  9      M   vendor/symfony/security-http/Authenticator/AbstractLoginFormAuthenticator.php	  տh	  e      E   vendor/symfony/security-http/Authenticator/AuthenticatorInterface.phpS
  տhS
  v
      A   vendor/symfony/security-http/Authenticator/FallbackUserLoader.php  տh  ٤      D   vendor/symfony/security-http/Authenticator/AbstractAuthenticator.php  տh   R      E   vendor/symfony/security-http/Authenticator/HttpBasicAuthenticator.phpe  տhe  Z      E   vendor/symfony/security-http/Authenticator/LoginLinkAuthenticator.php?  տh?  !6      E   vendor/symfony/security-http/Authenticator/JsonLoginAuthenticator.php  տh  7$;      N   vendor/symfony/security-http/Authenticator/Passport/SelfValidatingPassport.php  տh  YWW      @   vendor/symfony/security-http/Authenticator/Passport/Passport.php$  տh$   ;!2      X   vendor/symfony/security-http/Authenticator/Passport/Credentials/CredentialsInterface.php  տh  P      U   vendor/symfony/security-http/Authenticator/Passport/Credentials/CustomCredentials.php  տh  @1      W   vendor/symfony/security-http/Authenticator/Passport/Credentials/PasswordCredentials.phpV  տhV  R      W   vendor/symfony/security-http/Authenticator/Passport/Badge/PreAuthenticatedUserBadge.php  տh  yΤ      L   vendor/symfony/security-http/Authenticator/Passport/Badge/CsrfTokenBadge.phpi  տhi  $      R   vendor/symfony/security-http/Authenticator/Passport/Badge/PasswordUpgradeBadge.phpV  տhV  Ĥ      G   vendor/symfony/security-http/Authenticator/Passport/Badge/UserBadge.php  տh  V5פ      M   vendor/symfony/security-http/Authenticator/Passport/Badge/RememberMeBadge.phpK  տhK  p"      L   vendor/symfony/security-http/Authenticator/Passport/Badge/BadgeInterface.php  տh  ˙Au      @   vendor/symfony/security-http/Authenticator/X509Authenticator.php	  տh	  }      G   vendor/symfony/security-http/Authenticator/AccessTokenAuthenticator.php  տh  YTS      F   vendor/symfony/security-http/Authenticator/RemoteUserAuthenticator.php  տh  _]z      E   vendor/symfony/security-http/Authenticator/FormLoginAuthenticator.phpS  տhS  eQ8      T   vendor/symfony/security-http/Authenticator/AbstractPreAuthenticatedAuthenticator.php  տh  hʆ`      K   vendor/symfony/security-http/Authenticator/Debug/TraceableAuthenticator.phpO  տhO  ӊ2      Z   vendor/symfony/security-http/Authenticator/Debug/TraceableAuthenticatorManagerListener.phpg  տhg        F   vendor/symfony/security-http/Authenticator/RememberMeAuthenticator.php  տh  Au      K   vendor/symfony/security-http/Authorization/AccessDeniedHandlerInterface.phpz  տhz  (      3   vendor/symfony/security-http/AccessMapInterface.phpi  տhi  HY%      ;   vendor/symfony/security-http/LoginLink/LoginLinkDetails.phpe  տhe  Z/      ;   vendor/symfony/security-http/LoginLink/LoginLinkHandler.php  տh  ąy      @   vendor/symfony/security-http/LoginLink/LoginLinkNotification.php
  տh
  ֽ      D   vendor/symfony/security-http/LoginLink/LoginLinkHandlerInterface.php  տh  \S      W   vendor/symfony/security-http/LoginLink/Exception/InvalidLoginLinkExceptionInterface.php  տh  HF      N   vendor/symfony/security-http/LoginLink/Exception/InvalidLoginLinkException.php  տh        \   vendor/symfony/security-http/LoginLink/Exception/InvalidLoginLinkAuthenticationException.php  տh  <Yķ      N   vendor/symfony/security-http/LoginLink/Exception/ExpiredLoginLinkException.phpI  տhI  Z      S   vendor/symfony/security-http/Authentication/DefaultAuthenticationFailureHandler.phph  տhh  [)-G      M   vendor/symfony/security-http/Authentication/AuthenticatorManagerInterface.php  տh  1      R   vendor/symfony/security-http/Authentication/CustomAuthenticationSuccessHandler.php  տh  W"¤      U   vendor/symfony/security-http/Authentication/AuthenticationFailureHandlerInterface.php>  տh>        C   vendor/symfony/security-http/Authentication/AuthenticationUtils.php	  տh	  ج      R   vendor/symfony/security-http/Authentication/CustomAuthenticationFailureHandler.php  տh  c      U   vendor/symfony/security-http/Authentication/AuthenticationSuccessHandlerInterface.phpI  տhI  &4Q      J   vendor/symfony/security-http/Authentication/UserAuthenticatorInterface.php  տh  
>      D   vendor/symfony/security-http/Authentication/AuthenticatorManager.php6  տh6  c
9      S   vendor/symfony/security-http/Authentication/DefaultAuthenticationSuccessHandler.php  տh  N"      *   vendor/symfony/security-http/AccessMap.php~  տh~  t<y      8   vendor/symfony/security-http/Event/LoginFailureEvent.php;
  տh;
  (Ϥ      8   vendor/symfony/security-http/Event/LoginSuccessEvent.php<  տh<  .      8   vendor/symfony/security-http/Event/LazyResponseEvent.php  տh  /H
      6   vendor/symfony/security-http/Event/SwitchUserEvent.php  տh  U      F   vendor/symfony/security-http/Event/AuthenticationTokenCreatedEvent.phpW  տhW  c|      9   vendor/symfony/security-http/Event/CheckPassportEvent.php  տh  g      <   vendor/symfony/security-http/Event/InteractiveLoginEvent.phpG  տhG  <KB      2   vendor/symfony/security-http/Event/LogoutEvent.php  տh        @   vendor/symfony/security-http/Event/TokenDeauthenticatedEvent.php  տh  X2      D   vendor/symfony/security-http/Impersonate/ImpersonateUrlGenerator.php%  տh%  ./ U      2   vendor/symfony/security-http/ParameterBagUtils.php  տh  [7b      *   vendor/symfony/security-http/composer.json\  տh\  7      :   vendor/symfony/security-http/SecurityRequestAttributes.php  տh  J      J   vendor/symfony/security-http/EventListener/ClearSiteDataLogoutListener.php  տh  jͤ      D   vendor/symfony/security-http/EventListener/SessionLogoutListener.php  տh  t      D   vendor/symfony/security-http/EventListener/DefaultLogoutListener.phpm  տhm        H   vendor/symfony/security-http/EventListener/PasswordMigratingListener.php  տh  £פ      A   vendor/symfony/security-http/EventListener/RememberMeListener.php  տh  vx.ʤ      F   vendor/symfony/security-http/EventListener/LoginThrottlingListener.php
  տh
  L      C   vendor/symfony/security-http/EventListener/UserProviderListener.phpf  տhf  6i      K   vendor/symfony/security-http/EventListener/CookieClearingLogoutListener.php  տh  o[      G   vendor/symfony/security-http/EventListener/CheckCredentialsListener.php  տh  );L      F   vendor/symfony/security-http/EventListener/SessionStrategyListener.php  տh  .      N   vendor/symfony/security-http/EventListener/CsrfTokenClearingLogoutListener.phpp  տhp  u      B   vendor/symfony/security-http/EventListener/UserCheckerListener.phpi  տhi  g%      I   vendor/symfony/security-http/EventListener/IsGrantedAttributeListener.php  տh  5D      E   vendor/symfony/security-http/EventListener/CsrfProtectionListener.php  տh        P   vendor/symfony/security-http/EventListener/CheckRememberMeConditionsListener.php
  տh
  wj      O   vendor/symfony/security-http/Session/SessionAuthenticationStrategyInterface.phpC  տhC  'ʤ      F   vendor/symfony/security-http/Session/SessionAuthenticationStrategy.php]  տh]  Q         vendor/symfony/uid/UuidV8.phpK  տhK  {dL      !   vendor/symfony/uid/BinaryUtil.php-  տh-   Ҥ         vendor/symfony/uid/NilUuid.php  տh  MzĤ         vendor/symfony/uid/LICENSE,  տh,  K         vendor/symfony/uid/NilUlid.php  տh  [         vendor/symfony/uid/CHANGELOG.md  տh        "   vendor/symfony/uid/AbstractUid.php[  տh[  boO         vendor/symfony/uid/Ulid.phpP  տhP  ݤ         vendor/symfony/uid/Uuid.php  տh  t0[O         vendor/symfony/uid/MaxUlid.php  տh  >Z         vendor/symfony/uid/MaxUuid.php  տh  Sw4         vendor/symfony/uid/README.md\  տh\        2   vendor/symfony/uid/Command/GenerateUuidCommand.php(  տh(  vF@      2   vendor/symfony/uid/Command/GenerateUlidCommand.php  տh  ->      1   vendor/symfony/uid/Command/InspectUuidCommand.php
  տh
  +}      1   vendor/symfony/uid/Command/InspectUlidCommand.php  տh  0>Ȉ         vendor/symfony/uid/UuidV1.phpV  տhV  ʤ         vendor/symfony/uid/UuidV3.php^  տh^  (L         vendor/symfony/uid/UuidV6.phpN  տhN  ͤ         vendor/symfony/uid/UuidV7.php  տh  C/      3   vendor/symfony/uid/Factory/TimeBasedUuidFactory.php-  տh-  i`mU      *   vendor/symfony/uid/Factory/UuidFactory.php>
  տh>
   Xw      5   vendor/symfony/uid/Factory/RandomBasedUuidFactory.php[  տh[  \(R      *   vendor/symfony/uid/Factory/UlidFactory.php  տh  )ݿ      3   vendor/symfony/uid/Factory/NameBasedUuidFactory.php  տh  0 A          vendor/symfony/uid/composer.json  տh  s	ۤ      ,   vendor/symfony/uid/TimeBasedUidInterface.php  տh  Q         vendor/symfony/uid/UuidV5.php^  տh^  A         vendor/symfony/uid/UuidV4.php  տh  <      <   vendor/symfony/event-dispatcher/EventDispatcherInterface.php  տh  a      =   vendor/symfony/event-dispatcher/Attribute/AsEventListener.php  տh  $      '   vendor/symfony/event-dispatcher/LICENSE,  տh,  U      ,   vendor/symfony/event-dispatcher/CHANGELOG.md]  տh]  uE~      3   vendor/symfony/event-dispatcher/EventDispatcher.php9#  տh9#  ή&      )   vendor/symfony/event-dispatcher/README.mdW  տhW  ,fB      <   vendor/symfony/event-dispatcher/EventSubscriberInterface.php  տh  A{)      <   vendor/symfony/event-dispatcher/ImmutableEventDispatcher.php  տh  w      0   vendor/symfony/event-dispatcher/GenericEvent.php
  տh
  d      M   vendor/symfony/event-dispatcher/DependencyInjection/RegisterListenersPass.php   տh   i٤      K   vendor/symfony/event-dispatcher/DependencyInjection/AddEventAliasesPass.php  տh  &{      -   vendor/symfony/event-dispatcher/composer.json  տh  R      B   vendor/symfony/event-dispatcher/Debug/TraceableEventDispatcher.php0  տh0  U*u      9   vendor/symfony/event-dispatcher/Debug/WrappedListener.php  տh  okŤ      +   vendor/symfony/var-dumper/Cloner/Cursor.phpH  տhH  cq      .   vendor/symfony/var-dumper/Cloner/VarCloner.php)  տh)  
      4   vendor/symfony/var-dumper/Cloner/ClonerInterface.php  տh  ze      7   vendor/symfony/var-dumper/Cloner/Internal/NoDefault.php4  տh4  ߞ      4   vendor/symfony/var-dumper/Cloner/DumperInterface.phpo  տho  k      3   vendor/symfony/var-dumper/Cloner/AbstractCloner.php]  տh]  $^      )   vendor/symfony/var-dumper/Cloner/Data.php5  տh5  G      )   vendor/symfony/var-dumper/Cloner/Stub.phpk  տhk  Xܤ      !   vendor/symfony/var-dumper/LICENSE,  տh,  .z      5   vendor/symfony/var-dumper/Test/VarDumperTestTrait.phpV
  տhV
  F      &   vendor/symfony/var-dumper/CHANGELOG.md	  տh	  "D      .   vendor/symfony/var-dumper/Caster/GmpCaster.php
  տh
  "       5   vendor/symfony/var-dumper/Caster/ReflectionCaster.php;  տh;  -,      /   vendor/symfony/var-dumper/Caster/StubCaster.php	  տh	  @v      2   vendor/symfony/var-dumper/Caster/SymfonyCaster.php|  տh|  c      .   vendor/symfony/var-dumper/Caster/FrameStub.php  տh  aa      7   vendor/symfony/var-dumper/Caster/ProxyManagerCaster.php#  տh#  DJ      .   vendor/symfony/var-dumper/Caster/FFICaster.php  տh  ь      /   vendor/symfony/var-dumper/Caster/DateCaster.php;  տh;  C7>      .   vendor/symfony/var-dumper/Caster/PdoCaster.php  տh  ɤ      6   vendor/symfony/var-dumper/Caster/XmlResourceCaster.php|	  տh|	        3   vendor/symfony/var-dumper/Caster/ResourceCaster.php  տh  ~      4   vendor/symfony/var-dumper/Caster/ExceptionCaster.phpmA  տhmA  SL      6   vendor/symfony/var-dumper/Caster/UninitializedStub.phpy  տhy  0:      -   vendor/symfony/var-dumper/Caster/DsCaster.phpS  տhS  c      -   vendor/symfony/var-dumper/Caster/LinkStub.phpH
  տhH
  ϼ      4   vendor/symfony/var-dumper/Caster/MemcachedCaster.php  տh  Y#g	      3   vendor/symfony/var-dumper/Caster/DoctrineCaster.phpG  տhG  55      2   vendor/symfony/var-dumper/Caster/RdKafkaCaster.php  տh  9#      1   vendor/symfony/var-dumper/Caster/MysqliCaster.php  տh        ,   vendor/symfony/var-dumper/Caster/ImgStub.php  տh  ͤ      .   vendor/symfony/var-dumper/Caster/ClassStub.php?  տh?  7V      .   vendor/symfony/var-dumper/Caster/TraceStub.php  տh  _      1   vendor/symfony/var-dumper/Caster/CutArrayStub.php  տh  QG      0   vendor/symfony/var-dumper/Caster/PgSqlCaster.php  տh  pv      +   vendor/symfony/var-dumper/Caster/Caster.php*  տh*  n      .   vendor/symfony/var-dumper/Caster/SplCaster.php]  տh]  4Dӻ      .   vendor/symfony/var-dumper/Caster/ConstStub.php   տh   3Ôk      /   vendor/symfony/var-dumper/Caster/ScalarStub.phpF  տhF  fA      /   vendor/symfony/var-dumper/Caster/DsPairStub.phpn  տhn  0
      /   vendor/symfony/var-dumper/Caster/IntlCaster.php  տh        0   vendor/symfony/var-dumper/Caster/RedisCaster.php  տh  $OP      0   vendor/symfony/var-dumper/Caster/FiberCaster.phpf  տhf  K      2   vendor/symfony/var-dumper/Caster/ImagineCaster.php  տh  |gdߤ      /   vendor/symfony/var-dumper/Caster/AmqpCaster.phpH  տhH        .   vendor/symfony/var-dumper/Caster/DOMCaster.phpN  տhN  t      /   vendor/symfony/var-dumper/Caster/UuidCaster.php  տh  E7      4   vendor/symfony/var-dumper/Caster/XmlReaderCaster.php  տh  5      -   vendor/symfony/var-dumper/Caster/ArgsStub.php	  տh	  O      -   vendor/symfony/var-dumper/Caster/EnumStub.php  տh  `"      ,   vendor/symfony/var-dumper/Caster/CutStub.php  տh        7   vendor/symfony/var-dumper/Resources/bin/var-dump-server  տh  '      :   vendor/symfony/var-dumper/Resources/css/htmlDescriptor.css  տh  Dva      8   vendor/symfony/var-dumper/Resources/js/htmlDescriptor.jsb  տhb  h|      6   vendor/symfony/var-dumper/Resources/functions/dump.php5  տh5  j1      /   vendor/symfony/var-dumper/Server/Connection.php
  տh
  xΤ      /   vendor/symfony/var-dumper/Server/DumpServer.php  տh  U駤      #   vendor/symfony/var-dumper/README.md_  տh_  Fq      7   vendor/symfony/var-dumper/Command/ServerDumpCommand.php  տh  S+      H   vendor/symfony/var-dumper/Command/Descriptor/DumpDescriptorInterface.php  տh  a*      >   vendor/symfony/var-dumper/Command/Descriptor/CliDescriptor.php
  տh
  d      ?   vendor/symfony/var-dumper/Command/Descriptor/HtmlDescriptor.php  տh  	      ?   vendor/symfony/var-dumper/Exception/ThrowingCasterException.php  տh  ä      1   vendor/symfony/var-dumper/Dumper/ServerDumper.php  տh  DZ      8   vendor/symfony/var-dumper/Dumper/DataDumperInterface.php@  տh@  o/      M   vendor/symfony/var-dumper/Dumper/ContextProvider/ContextProviderInterface.php(  տh(  EFf      K   vendor/symfony/var-dumper/Dumper/ContextProvider/RequestContextProvider.php
  տh
  뉤      G   vendor/symfony/var-dumper/Dumper/ContextProvider/CliContextProvider.php  տh  B߫u      J   vendor/symfony/var-dumper/Dumper/ContextProvider/SourceContextProvider.php  տh  u      3   vendor/symfony/var-dumper/Dumper/AbstractDumper.phpq  տhq  	      .   vendor/symfony/var-dumper/Dumper/CliDumper.phpZ  տhZ  '      9   vendor/symfony/var-dumper/Dumper/ContextualizedDumper.php  տh  U      /   vendor/symfony/var-dumper/Dumper/HtmlDumper.php<  տh<   F      '   vendor/symfony/var-dumper/composer.json]  տh]        '   vendor/symfony/var-dumper/VarDumper.php  տh  Ϥ      !   vendor/symfony/filesystem/LICENSE,  տh,  U      &   vendor/symfony/filesystem/CHANGELOG.md  տh  I      (   vendor/symfony/filesystem/Filesystem.phpt  տht  @WI      "   vendor/symfony/filesystem/Path.php
f  տh
f  ׀s      #   vendor/symfony/filesystem/README.md  տh        <   vendor/symfony/filesystem/Exception/IOExceptionInterface.php  տh        :   vendor/symfony/filesystem/Exception/ExceptionInterface.php  տh  (l`Ф      8   vendor/symfony/filesystem/Exception/RuntimeException.php  տh  A      3   vendor/symfony/filesystem/Exception/IOException.php  տh  0      @   vendor/symfony/filesystem/Exception/InvalidArgumentException.php  տh  $
      =   vendor/symfony/filesystem/Exception/FileNotFoundException.php  տh   [:      '   vendor/symfony/filesystem/composer.json{  տh{  zq      G   vendor/symfony/security-csrf/TokenStorage/NativeSessionTokenStorage.php
  տh
  .פ      A   vendor/symfony/security-csrf/TokenStorage/SessionTokenStorage.phpK  տhK  <_      L   vendor/symfony/security-csrf/TokenStorage/ClearableTokenStorageInterface.php3  տh3        C   vendor/symfony/security-csrf/TokenStorage/TokenStorageInterface.php  տh  7䭤      $   vendor/symfony/security-csrf/LICENSE,  տh,  U      )   vendor/symfony/security-csrf/CHANGELOG.md  տh  >*      *   vendor/symfony/security-csrf/CsrfToken.php  տh  3      &   vendor/symfony/security-csrf/README.md  տh        :   vendor/symfony/security-csrf/CsrfTokenManagerInterface.php  տh  yɤ      E   vendor/symfony/security-csrf/TokenGenerator/UriSafeTokenGenerator.php  տh  1      G   vendor/symfony/security-csrf/TokenGenerator/TokenGeneratorInterface.php  տh  <xx      1   vendor/symfony/security-csrf/CsrfTokenManager.php  տh  Zؤ      A   vendor/symfony/security-csrf/Exception/TokenNotFoundException.php  տh   U      *   vendor/symfony/security-csrf/composer.json  տh  -      ,   vendor/symfony/polyfill-uuid/bootstrap80.php  տh  jx      $   vendor/symfony/polyfill-uuid/LICENSE,  տh,        %   vendor/symfony/polyfill-uuid/Uuid.phpqB  տhqB  E      *   vendor/symfony/polyfill-uuid/bootstrap.php#  տh#  )      &   vendor/symfony/polyfill-uuid/README.md[  տh[  Ƥ      *   vendor/symfony/polyfill-uuid/composer.json  տh  {Ĥ      7   vendor/symfony/polyfill-intl-normalizer/bootstrap80.php  տh  ,      /   vendor/symfony/polyfill-intl-normalizer/LICENSE,  տh,  H      6   vendor/symfony/polyfill-intl-normalizer/Normalizer.php8$  տh8$  &(C      F   vendor/symfony/polyfill-intl-normalizer/Resources/stubs/Normalizer.php  տh  %      L   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/combiningClass.php.  տh.  Cb      T   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/canonicalDecomposition.phpx  տhx        R   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/canonicalComposition.php=  տh=  V{      X   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/compatibilityDecomposition.php  տh  [
+      5   vendor/symfony/polyfill-intl-normalizer/bootstrap.php  տh  #p      1   vendor/symfony/polyfill-intl-normalizer/README.md  տh  +tK      5   vendor/symfony/polyfill-intl-normalizer/composer.jsonx  տhx        F   vendor/symfony/event-dispatcher-contracts/EventDispatcherInterface.php,  տh,  ۃf      3   vendor/symfony/event-dispatcher-contracts/Event.php  տh  +Vg      1   vendor/symfony/event-dispatcher-contracts/LICENSE,  տh,        6   vendor/symfony/event-dispatcher-contracts/CHANGELOG.md   տh   h{#      3   vendor/symfony/event-dispatcher-contracts/README.mdZ  տhZ  9{Am      7   vendor/symfony/event-dispatcher-contracts/composer.json?  տh?  ׿s      8   vendor/symfony/property-access/PropertyPathInterface.php  տh  z      7   vendor/symfony/property-access/PropertyPathIterator.php  տh  ax      &   vendor/symfony/property-access/LICENSE,  տh,  U      @   vendor/symfony/property-access/PropertyPathIteratorInterface.php  տh  
M      +   vendor/symfony/property-access/CHANGELOG.md
  տh
  <4      <   vendor/symfony/property-access/PropertyAccessorInterface.php  տh  {Q      /   vendor/symfony/property-access/PropertyPath.php  տh  ^      :   vendor/symfony/property-access/PropertyAccessorBuilder.php  տh  zH;       (   vendor/symfony/property-access/README.md1  տh1  !Q      3   vendor/symfony/property-access/PropertyAccessor.phpq{  տhq{  Egݤ      1   vendor/symfony/property-access/PropertyAccess.php  տh        6   vendor/symfony/property-access/PropertyPathBuilder.php!  տh!  2{      <   vendor/symfony/property-access/Exception/AccessException.php  տh  KW      K   vendor/symfony/property-access/Exception/UninitializedPropertyException.php  տh  ,      ?   vendor/symfony/property-access/Exception/ExceptionInterface.php  տh  l      A   vendor/symfony/property-access/Exception/OutOfBoundsException.php  տh  ؤ      =   vendor/symfony/property-access/Exception/RuntimeException.php  տh  Cn      E   vendor/symfony/property-access/Exception/InvalidArgumentException.php  տh  IF[3      I   vendor/symfony/property-access/Exception/InvalidPropertyPathException.php  տh  zޤ      D   vendor/symfony/property-access/Exception/UnexpectedTypeException.phpy  տhy  bR      A   vendor/symfony/property-access/Exception/NoSuchIndexException.php  տh  NQp      D   vendor/symfony/property-access/Exception/NoSuchPropertyException.php  տh  ?      ,   vendor/symfony/property-access/composer.json~  տh~        %   vendor/symfony/finder/SplFileInfo.php  տh  9$̤      5   vendor/symfony/finder/Comparator/NumberComparator.php
  տh
        /   vendor/symfony/finder/Comparator/Comparator.php  տh  @x      3   vendor/symfony/finder/Comparator/DateComparator.php  տh  ~Q          vendor/symfony/finder/Finder.phpPb  տhPb  F̲         vendor/symfony/finder/LICENSE,  տh,  U      "   vendor/symfony/finder/CHANGELOG.md
  տh
  3g         vendor/symfony/finder/Glob.php2  տh2  A         vendor/symfony/finder/README.md  տh  C      /   vendor/symfony/finder/Iterator/LazyIterator.php  տh  Wđ      ;   vendor/symfony/finder/Iterator/VcsIgnoredFilterIterator.php'  տh'  n!      <   vendor/symfony/finder/Iterator/FilecontentFilterIterator.php  տh  \v:c      =   vendor/symfony/finder/Iterator/MultiplePcreFilterIterator.php  տh  N      :   vendor/symfony/finder/Iterator/SizeRangeFilterIterator.phpk  տhk  4-      9   vendor/symfony/finder/Iterator/FilenameFilterIterator.phpn  տhn  MNQ      :   vendor/symfony/finder/Iterator/DateRangeFilterIterator.php  տh  9z֤      7   vendor/symfony/finder/Iterator/CustomFilterIterator.php  տh  	ʤ      =   vendor/symfony/finder/Iterator/RecursiveDirectoryIterator.phpO  տhO        A   vendor/symfony/finder/Iterator/ExcludeDirectoryFilterIterator.php5
  տh5
  `      3   vendor/symfony/finder/Iterator/SortableIterator.php3  տh3  뛽       ;   vendor/symfony/finder/Iterator/DepthRangeFilterIterator.phpn  տhn  O      9   vendor/symfony/finder/Iterator/FileTypeFilterIterator.php|  տh|  Aj      5   vendor/symfony/finder/Iterator/PathFilterIterator.php  տh  (      #   vendor/symfony/finder/Gitignore.php  տh  Q)      9   vendor/symfony/finder/Exception/AccessDeniedException.php  տh        >   vendor/symfony/finder/Exception/DirectoryNotFoundException.php  տh  )      #   vendor/symfony/finder/composer.json*  տh*  _      -   vendor/symfony/polyfill-php83/bootstrap81.php  տh  p$      %   vendor/symfony/polyfill-php83/LICENSE,  տh,  t=      B   vendor/symfony/polyfill-php83/Resources/stubs/SQLite3Exception.phpH  տhH  <ܐ      ;   vendor/symfony/polyfill-php83/Resources/stubs/DateError.php=  տh=  ˤ      :   vendor/symfony/polyfill-php83/Resources/stubs/Override.php  տh  NsE      ?   vendor/symfony/polyfill-php83/Resources/stubs/DateException.phpE  տhE        O   vendor/symfony/polyfill-php83/Resources/stubs/DateInvalidOperationException.phpY  տhY  Mߤ      A   vendor/symfony/polyfill-php83/Resources/stubs/DateObjectError.phpG  տhG  
.I      T   vendor/symfony/polyfill-php83/Resources/stubs/DateMalformedPeriodStringException.php^  տh^  K      N   vendor/symfony/polyfill-php83/Resources/stubs/DateMalformedStringException.phpX  տhX  Wߤ      @   vendor/symfony/polyfill-php83/Resources/stubs/DateRangeError.phpF  տhF  L;      N   vendor/symfony/polyfill-php83/Resources/stubs/DateInvalidTimeZoneException.phpX  տhX  g      V   vendor/symfony/polyfill-php83/Resources/stubs/DateMalformedIntervalStringException.php`  տh`  6      +   vendor/symfony/polyfill-php83/bootstrap.php  տh  {Jc      '   vendor/symfony/polyfill-php83/README.md  տh  }      '   vendor/symfony/polyfill-php83/Php83.php  տh        +   vendor/symfony/polyfill-php83/composer.json  տh  {V      >   vendor/symfony/http-kernel/DataCollector/DumpDataCollector.php%+  տh%+  p	q      @   vendor/symfony/http-kernel/DataCollector/MemoryDataCollector.php  տh  ]%      G   vendor/symfony/http-kernel/DataCollector/LateDataCollectorInterface.php/  տh/  D
      @   vendor/symfony/http-kernel/DataCollector/RouterDataCollector.php	  տh	  W}}      >   vendor/symfony/http-kernel/DataCollector/TimeDataCollector.php
  տh
  R       C   vendor/symfony/http-kernel/DataCollector/DataCollectorInterface.php  տh        A   vendor/symfony/http-kernel/DataCollector/RequestDataCollector.phpo>  տho>  se      >   vendor/symfony/http-kernel/DataCollector/AjaxDataCollector.phpl  տhl  kD      :   vendor/symfony/http-kernel/DataCollector/DataCollector.phpB  տhB  r      @   vendor/symfony/http-kernel/DataCollector/LoggerDataCollector.phpV)  տhV)  >W      @   vendor/symfony/http-kernel/DataCollector/ConfigDataCollector.php<  տh<        ?   vendor/symfony/http-kernel/DataCollector/EventDataCollector.phpG  տhG  Jݤ      C   vendor/symfony/http-kernel/DataCollector/ExceptionDataCollector.phpU  տhU  	      5   vendor/symfony/http-kernel/Attribute/AsController.php  տh  UT      @   vendor/symfony/http-kernel/Attribute/AsTargetedValueResolver.php
  տh
  w      .   vendor/symfony/http-kernel/Attribute/Cache.phpX
  տhX
  LҌ      7   vendor/symfony/http-kernel/Attribute/MapQueryString.php  տh  u~      7   vendor/symfony/http-kernel/Attribute/WithHttpStatus.php^  տh^  
      4   vendor/symfony/http-kernel/Attribute/MapDateTime.php   տh   j      :   vendor/symfony/http-kernel/Attribute/MapRequestPayload.php)  տh)  -"y      5   vendor/symfony/http-kernel/Attribute/WithLogLevel.php  տh  FH      6   vendor/symfony/http-kernel/Attribute/ValueResolver.php  տh  \      :   vendor/symfony/http-kernel/Attribute/MapQueryParameter.php\  տh\  %      "   vendor/symfony/http-kernel/LICENSE,  տh,  U      R   vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactoryInterface.php  տh  ͞1      B   vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadata.php  տh  S      I   vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactory.php  տh  D{\Ǥ      '   vendor/symfony/http-kernel/CHANGELOG.mdQ  տhQ        1   vendor/symfony/http-kernel/Config/FileLocator.phpw  տhw        /   vendor/symfony/http-kernel/HttpClientKernel.php  տh  u*D      2   vendor/symfony/http-kernel/TerminableInterface.php  տh        A   vendor/symfony/http-kernel/CacheClearer/CacheClearerInterface.php*  տh*  雗      =   vendor/symfony/http-kernel/CacheClearer/ChainCacheClearer.phpJ  տhJ  7      <   vendor/symfony/http-kernel/CacheClearer/Psr6CacheClearer.php  տh  r2      5   vendor/symfony/http-kernel/Resources/welcome.html.php  տh  i      )   vendor/symfony/http-kernel/HttpKernel.php-  տh-  ¤      ?   vendor/symfony/http-kernel/CacheWarmer/CacheWarmerAggregate.php  տh  Q      6   vendor/symfony/http-kernel/CacheWarmer/CacheWarmer.php  տh  QĤ      <   vendor/symfony/http-kernel/CacheWarmer/WarmableInterface.php3  տh3  P@ˤ      ?   vendor/symfony/http-kernel/CacheWarmer/CacheWarmerInterface.php  տh  {w]b      ,   vendor/symfony/http-kernel/Bundle/Bundle.php  տh  ~o      5   vendor/symfony/http-kernel/Bundle/BundleInterface.php  տh  "z      4   vendor/symfony/http-kernel/Bundle/AbstractBundle.php  տh  |`      5   vendor/symfony/http-kernel/Bundle/BundleExtension.php	  տh	  Y]=      .   vendor/symfony/http-kernel/KernelInterface.php  տh  J:      :   vendor/symfony/http-kernel/Controller/ArgumentResolver.php  տh  <n      =   vendor/symfony/http-kernel/Controller/ControllerReference.php5  տh5  Ul      9   vendor/symfony/http-kernel/Controller/ErrorController.php>  տh>  B      E   vendor/symfony/http-kernel/Controller/ContainerControllerResolver.php  տh  f      P   vendor/symfony/http-kernel/Controller/ArgumentResolver/VariadicValueResolver.php@  տh@  S      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/ServiceValueResolver.php|  տh|  wS      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/DefaultValueResolver.php  տh  ^(2      V   vendor/symfony/http-kernel/Controller/ArgumentResolver/QueryParameterValueResolver.php  տh  g,      K   vendor/symfony/http-kernel/Controller/ArgumentResolver/UidValueResolver.php  տh  ybޤ      R   vendor/symfony/http-kernel/Controller/ArgumentResolver/BackedEnumValueResolver.php0  տh0  Ns      V   vendor/symfony/http-kernel/Controller/ArgumentResolver/RequestPayloadValueResolver.phpD"  տhD"  rn      P   vendor/symfony/http-kernel/Controller/ArgumentResolver/DateTimeValueResolver.php
  տh
  7      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/RequestValueResolver.php  տh  05      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/SessionValueResolver.php  տh  o      X   vendor/symfony/http-kernel/Controller/ArgumentResolver/RequestAttributeValueResolver.php  տh  q?柤      [   vendor/symfony/http-kernel/Controller/ArgumentResolver/NotTaggedControllerValueResolver.php:
  տh:
  <      Q   vendor/symfony/http-kernel/Controller/ArgumentResolver/TraceableValueResolver.php3  տh3  8?      C   vendor/symfony/http-kernel/Controller/ArgumentResolverInterface.phpt  տht  q/m      E   vendor/symfony/http-kernel/Controller/ControllerResolverInterface.phpy  տhy  5ݰʤ      C   vendor/symfony/http-kernel/Controller/TraceableArgumentResolver.php  տh  D      @   vendor/symfony/http-kernel/Controller/ValueResolverInterface.php  տh  @9      <   vendor/symfony/http-kernel/Controller/ControllerResolver.php0(  տh0(  7nl      E   vendor/symfony/http-kernel/Controller/TraceableControllerResolver.phpJ  տhJ  #@      H   vendor/symfony/http-kernel/Controller/ArgumentValueResolverInterface.php  տh  %      $   vendor/symfony/http-kernel/README.md  տh  7      E   vendor/symfony/http-kernel/Fragment/FragmentUriGeneratorInterface.php:  տh:  Ze      >   vendor/symfony/http-kernel/Fragment/InlineFragmentRenderer.php  տh  b^b      ;   vendor/symfony/http-kernel/Fragment/SsiFragmentRenderer.php%  տh%  	      I   vendor/symfony/http-kernel/Fragment/AbstractSurrogateFragmentRenderer.php  տh  ,J      A   vendor/symfony/http-kernel/Fragment/FragmentRendererInterface.php  տh  Ǜ<      <   vendor/symfony/http-kernel/Fragment/FragmentUriGenerator.php$  տh$        ;   vendor/symfony/http-kernel/Fragment/EsiFragmentRenderer.php%  տh%  p      @   vendor/symfony/http-kernel/Fragment/HIncludeFragmentRenderer.php/
  տh/
  r0      7   vendor/symfony/http-kernel/Fragment/FragmentHandler.php  տh  <̤      @   vendor/symfony/http-kernel/Fragment/RoutableFragmentRenderer.php+  տh+  rT      +   vendor/symfony/http-kernel/KernelEvents.phpd  տhd  Z$      ,   vendor/symfony/http-kernel/HttpCache/Esi.php
  տh
  
K\      2   vendor/symfony/http-kernel/HttpCache/HttpCache.phpRk  տhRk  $ˏ      .   vendor/symfony/http-kernel/HttpCache/Store.php9  տh9  j=      ;   vendor/symfony/http-kernel/HttpCache/SurrogateInterface.php  տh  r      G   vendor/symfony/http-kernel/HttpCache/ResponseCacheStrategyInterface.php:  տh:  )Ou      >   vendor/symfony/http-kernel/HttpCache/ResponseCacheStrategy.php!  տh!  Xפ      7   vendor/symfony/http-kernel/HttpCache/StoreInterface.php  տh  +      ,   vendor/symfony/http-kernel/HttpCache/Ssi.phpR
  տhR
  Y      @   vendor/symfony/http-kernel/HttpCache/CacheWasLockedException.phpy  տhy  Lv      :   vendor/symfony/http-kernel/HttpCache/AbstractSurrogate.php  տh  ڄ      :   vendor/symfony/http-kernel/HttpCache/SubRequestHandler.php1  տh1  イ      2   vendor/symfony/http-kernel/HttpKernelInterface.php  տh   Z      )   vendor/symfony/http-kernel/Log/Logger.php2  տh2  Y8X      7   vendor/symfony/http-kernel/Log/DebugLoggerInterface.phpD  տhD  'V      :   vendor/symfony/http-kernel/Log/DebugLoggerConfigurator.phpH  տhH  ,      ;   vendor/symfony/http-kernel/Profiler/FileProfilerStorage.php(  տh(  |r      /   vendor/symfony/http-kernel/Profiler/Profile.phpo  տho   #      0   vendor/symfony/http-kernel/Profiler/Profiler.php  տh  27ya      @   vendor/symfony/http-kernel/Profiler/ProfilerStorageInterface.php  տh  0Ĥ      G   vendor/symfony/http-kernel/DependencyInjection/FragmentRendererPass.php  տh  P      C   vendor/symfony/http-kernel/DependencyInjection/ServicesResetter.php  տh  /v      R   vendor/symfony/http-kernel/DependencyInjection/RegisterLocaleAwareServicesPass.php  տh  2@      H   vendor/symfony/http-kernel/DependencyInjection/ResettableServicePass.php  տh  &ˏ      R   vendor/symfony/http-kernel/DependencyInjection/MergeExtensionConfigurationPass.php  տh  T
      Q   vendor/symfony/http-kernel/DependencyInjection/AddAnnotatedClassesToCachePass.php  տh  :      H   vendor/symfony/http-kernel/DependencyInjection/ConfigurableExtension.php  տh  6v      =   vendor/symfony/http-kernel/DependencyInjection/LoggerPass.php)  տh)  Q*      <   vendor/symfony/http-kernel/DependencyInjection/Extension.php_  տh_  ʍ/      V   vendor/symfony/http-kernel/DependencyInjection/ControllerArgumentValueResolverPass.phpY  տhY  FT      Y   vendor/symfony/http-kernel/DependencyInjection/RegisterControllerArgumentLocatorsPass.php.  տh.  8      \   vendor/symfony/http-kernel/DependencyInjection/RemoveEmptyControllerArgumentLocatorsPass.php
  տh
  5
դ      M   vendor/symfony/http-kernel/DependencyInjection/LazyLoadingFragmentHandler.php  տh        E   vendor/symfony/http-kernel/Exception/TooManyRequestsHttpException.php  տh  <      >   vendor/symfony/http-kernel/Exception/ConflictHttpException.phpc  տhc        6   vendor/symfony/http-kernel/Exception/HttpException.phpN  տhN  դ      B   vendor/symfony/http-kernel/Exception/UnauthorizedHttpException.php  տh  8      A   vendor/symfony/http-kernel/Exception/InvalidMetadataException.phpj  տhj  ;녤      D   vendor/symfony/http-kernel/Exception/LengthRequiredHttpException.phpi  տhi  
l      I   vendor/symfony/http-kernel/Exception/UnprocessableEntityHttpException.phpw  տhw  3      H   vendor/symfony/http-kernel/Exception/PreconditionFailedHttpException.phpm  տhm  m%      :   vendor/symfony/http-kernel/Exception/GoneHttpException.php_  տh_  ey      J   vendor/symfony/http-kernel/Exception/UnsupportedMediaTypeHttpException.phpo  տho  aM}      H   vendor/symfony/http-kernel/Exception/UnexpectedSessionUsageException.php  տh  Zis      <   vendor/symfony/http-kernel/Exception/LockedHttpException.phpe  տhe  peh      H   vendor/symfony/http-kernel/Exception/ServiceUnavailableHttpException.phpm  տhm  =      ?   vendor/symfony/http-kernel/Exception/HttpExceptionInterface.php}  տh}  ֚5      B   vendor/symfony/http-kernel/Exception/AccessDeniedHttpException.php  տh  6HHg      @   vendor/symfony/http-kernel/Exception/BadRequestHttpException.phpe  տhe  Ց      Q   vendor/symfony/http-kernel/Exception/ControllerDoesNotReturnResponseException.php  տh  t<
e      C   vendor/symfony/http-kernel/Exception/NotAcceptableHttpException.phph  տhh  (ޤ      J   vendor/symfony/http-kernel/Exception/PreconditionRequiredHttpException.php  տh  cԤ      >   vendor/symfony/http-kernel/Exception/NotFoundHttpException.phpj  տhj  Vz      F   vendor/symfony/http-kernel/Exception/MethodNotAllowedHttpException.php  տh  iנ      B   vendor/symfony/http-kernel/Exception/ResolverNotFoundException.php  տh  y	+      4   vendor/symfony/http-kernel/Event/ControllerEvent.phpj  տhj  w.Ƥ      3   vendor/symfony/http-kernel/Event/ExceptionEvent.php  տh  p-      7   vendor/symfony/http-kernel/Event/FinishRequestEvent.php  տh  TY      2   vendor/symfony/http-kernel/Event/ResponseEvent.php  տh  ,7      3   vendor/symfony/http-kernel/Event/TerminateEvent.php  տh  VC      =   vendor/symfony/http-kernel/Event/ControllerArgumentsEvent.php  տh  nT      0   vendor/symfony/http-kernel/Event/KernelEvent.php  տh  DBc      1   vendor/symfony/http-kernel/Event/RequestEvent.php  տh  ׁ      .   vendor/symfony/http-kernel/Event/ViewEvent.php  տh        (   vendor/symfony/http-kernel/composer.jsonm  տhm  -m      2   vendor/symfony/http-kernel/RebootableInterface.php<  տh<  pLX1      %   vendor/symfony/http-kernel/Kernel.phpw  տhw  Pn      (   vendor/symfony/http-kernel/UriSigner.php  տh  2[{      8   vendor/symfony/http-kernel/Debug/VirtualRequestStack.phpI  տhI  U&      =   vendor/symfony/http-kernel/Debug/ErrorHandlerConfigurator.php  տh  P      =   vendor/symfony/http-kernel/Debug/TraceableEventDispatcher.php  տh  ]`>      6   vendor/symfony/http-kernel/Debug/FileLinkFormatter.php  տh        0   vendor/symfony/http-kernel/HttpKernelBrowser.php  տh  i\      E   vendor/symfony/http-kernel/EventListener/StreamedResponseListener.php  տh  }>Ť      =   vendor/symfony/http-kernel/EventListener/ResponseListener.php  տh  PUȤ      ;   vendor/symfony/http-kernel/EventListener/LocaleListener.php  տh  7)<      =   vendor/symfony/http-kernel/EventListener/FragmentListener.php8  տh8  v      C   vendor/symfony/http-kernel/EventListener/CacheAttributeListener.php1  տh1  ۤ      D   vendor/symfony/http-kernel/EventListener/AbstractSessionListener.phpd0  տhd0  o!      D   vendor/symfony/http-kernel/EventListener/ValidateRequestListener.php  տh  x      K   vendor/symfony/http-kernel/EventListener/DisallowRobotsIndexingListener.phpo  տho  >JȤ      F   vendor/symfony/http-kernel/EventListener/AddRequestFormatsListener.php  տh  q       =   vendor/symfony/http-kernel/EventListener/ProfilerListener.php<  տh<  <3W      >   vendor/symfony/http-kernel/EventListener/SurrogateListener.phpU  տhU  M      B   vendor/symfony/http-kernel/EventListener/DebugHandlersListener.php  տh  n      @   vendor/symfony/http-kernel/EventListener/LocaleAwareListener.php	  տh	        9   vendor/symfony/http-kernel/EventListener/DumpListener.php%  տh%  ۤ      :   vendor/symfony/http-kernel/EventListener/ErrorListener.php!  տh!  	O      <   vendor/symfony/http-kernel/EventListener/SessionListener.php  տh        ;   vendor/symfony/http-kernel/EventListener/RouterListener.php  տh  G]9         vendor/symfony/yaml/LICENSE,  տh,  U         vendor/symfony/yaml/Parser.php  տh  i          vendor/symfony/yaml/CHANGELOG.md  տh  Ĥ         vendor/symfony/yaml/Escaper.php  տh  
      +   vendor/symfony/yaml/Resources/bin/yaml-lint  տh  3VԈ         vendor/symfony/yaml/README.md  տh  ـT      !   vendor/symfony/yaml/Unescaper.phpK  տhK   脱         vendor/symfony/yaml/Dumper.php  տh  h         vendor/symfony/yaml/Inline.php  տh  ɋؤ         vendor/symfony/yaml/Yaml.php  տh  LϽ      +   vendor/symfony/yaml/Command/LintCommand.php'  տh'  te      /   vendor/symfony/yaml/Exception/DumpException.php  տh  ?<̤      4   vendor/symfony/yaml/Exception/ExceptionInterface.php  տh  ,P      2   vendor/symfony/yaml/Exception/RuntimeException.php  տh  #OU      0   vendor/symfony/yaml/Exception/ParseException.php  տh  mFB      '   vendor/symfony/yaml/Tag/TaggedValue.php  տh  s$      !   vendor/symfony/yaml/composer.json  տh   Zܦ      )   vendor/symfony/string/CodePointString.phpN  տhN  J         vendor/symfony/string/LICENSE,  տh,  զ_Ϥ      "   vendor/symfony/string/CHANGELOG.mdz  տhz  ub      (   vendor/symfony/string/AbstractString.phpI  տhI  k      -   vendor/symfony/string/Resources/functions.phpc  տhc  Ȥ      <   vendor/symfony/string/Resources/data/wcswidth_table_zero.phpF  տhF  MI      <   vendor/symfony/string/Resources/data/wcswidth_table_wide.phpk  տhk  /      3   vendor/symfony/string/Inflector/FrenchInflector.php  տh  Q      6   vendor/symfony/string/Inflector/InflectorInterface.phpR  տhR  _      4   vendor/symfony/string/Inflector/EnglishInflector.phpC  տhC  'X<         vendor/symfony/string/README.md+  տh+  L      /   vendor/symfony/string/AbstractUnicodeString.phpxc  տhxc  7q      $   vendor/symfony/string/LazyString.php  տh        $   vendor/symfony/string/ByteString.phpv9  տhv9  }      '   vendor/symfony/string/UnicodeString.php1  տh1        6   vendor/symfony/string/Exception/ExceptionInterface.php_  տh_  :      4   vendor/symfony/string/Exception/RuntimeException.php~  տh~  )Ʉ      <   vendor/symfony/string/Exception/InvalidArgumentException.php  տh  B;8      #   vendor/symfony/string/composer.json  տh  #      2   vendor/symfony/string/Slugger/SluggerInterface.php  տh        .   vendor/symfony/string/Slugger/AsciiSlugger.php  տh  [=M      4   vendor/symfony/security-core/Role/SwitchUserRole.php  տh  'v      <   vendor/symfony/security-core/Role/RoleHierarchyInterface.php]  տh]  Բ'      *   vendor/symfony/security-core/Role/Role.php  տh  i֜      3   vendor/symfony/security-core/Role/RoleHierarchy.php  տh  UՈ      C   vendor/symfony/security-core/Validator/Constraints/UserPassword.php"  տh"  <0      L   vendor/symfony/security-core/Validator/Constraints/UserPasswordValidator.php~
  տh~
  ^      $   vendor/symfony/security-core/LICENSE,  տh,  U      D   vendor/symfony/security-core/Test/AccessDecisionStrategyTestCase.php	  տh	  A      B   vendor/symfony/security-core/Signature/ExpiredSignatureStorage.php  տh  `5      N   vendor/symfony/security-core/Signature/Exception/InvalidSignatureException.php  տh  [.ܤ      N   vendor/symfony/security-core/Signature/Exception/ExpiredSignatureException.php  տh  (:      :   vendor/symfony/security-core/Signature/SignatureHasher.php  տh  d5A      )   vendor/symfony/security-core/CHANGELOG.md  տh  &      C   vendor/symfony/security-core/Resources/translations/security.sq.xlfS  տhS  B&^      C   vendor/symfony/security-core/Resources/translations/security.ru.xlf  տh  m      C   vendor/symfony/security-core/Resources/translations/security.hy.xlf  տh  B      C   vendor/symfony/security-core/Resources/translations/security.fr.xlfU  տhU  $      C   vendor/symfony/security-core/Resources/translations/security.fa.xlf  տh  IѤ      C   vendor/symfony/security-core/Resources/translations/security.pl.xlf  տh  u      C   vendor/symfony/security-core/Resources/translations/security.sv.xlf  տh  cn      C   vendor/symfony/security-core/Resources/translations/security.el.xlf8  տh8  yva      H   vendor/symfony/security-core/Resources/translations/security.sr_Cyrl.xlf  տh        C   vendor/symfony/security-core/Resources/translations/security.en.xlfl  տhl  gBZ      C   vendor/symfony/security-core/Resources/translations/security.ja.xlf  տh  H      F   vendor/symfony/security-core/Resources/translations/security.pt_BR.xlf  տh  iH!      C   vendor/symfony/security-core/Resources/translations/security.no.xlf  տh  ~RҤ      C   vendor/symfony/security-core/Resources/translations/security.vi.xlf,  տh,  a      C   vendor/symfony/security-core/Resources/translations/security.ur.xlf  տh  g      C   vendor/symfony/security-core/Resources/translations/security.nn.xlf  տh  l      C   vendor/symfony/security-core/Resources/translations/security.nl.xlf  տh  "֤      C   vendor/symfony/security-core/Resources/translations/security.cy.xlfv  տhv  FŤ      C   vendor/symfony/security-core/Resources/translations/security.af.xlf  տh  ojo      C   vendor/symfony/security-core/Resources/translations/security.lv.xlfc  տhc  @ۤ      C   vendor/symfony/security-core/Resources/translations/security.ar.xlf  տh  OD      C   vendor/symfony/security-core/Resources/translations/security.lb.xlf)  տh)  z7      C   vendor/symfony/security-core/Resources/translations/security.tr.xlf  տh  0˵      C   vendor/symfony/security-core/Resources/translations/security.lt.xlfv  տhv  @Ȥ      F   vendor/symfony/security-core/Resources/translations/security.zh_CN.xlf  տh  D      C   vendor/symfony/security-core/Resources/translations/security.ca.xlf  տh  
      C   vendor/symfony/security-core/Resources/translations/security.be.xlfX  տhX  \ä      C   vendor/symfony/security-core/Resources/translations/security.th.xlf  տh  x=ݤ      C   vendor/symfony/security-core/Resources/translations/security.uz.xlfl  տhl  M      C   vendor/symfony/security-core/Resources/translations/security.mk.xlf  տh  ڞ      C   vendor/symfony/security-core/Resources/translations/security.bs.xlf  տh  %}o      C   vendor/symfony/security-core/Resources/translations/security.bg.xlf  տh  d캤      H   vendor/symfony/security-core/Resources/translations/security.sr_Latn.xlf6  տh6  dξ      C   vendor/symfony/security-core/Resources/translations/security.uk.xlf  տh  6V      F   vendor/symfony/security-core/Resources/translations/security.zh_TW.xlf  տh  Ȉf      C   vendor/symfony/security-core/Resources/translations/security.cs.xlf  տh  S0k3      C   vendor/symfony/security-core/Resources/translations/security.tl.xlfW  տhW        C   vendor/symfony/security-core/Resources/translations/security.my.xlf  տh  [v      C   vendor/symfony/security-core/Resources/translations/security.nb.xlf  տh  ~RҤ      C   vendor/symfony/security-core/Resources/translations/security.mn.xlf  տh  އ      C   vendor/symfony/security-core/Resources/translations/security.az.xlf^  տh^  9      C   vendor/symfony/security-core/Resources/translations/security.eu.xlf  տh  bs`      C   vendor/symfony/security-core/Resources/translations/security.he.xlfh  տhh  u      C   vendor/symfony/security-core/Resources/translations/security.hr.xlf[  տh[        C   vendor/symfony/security-core/Resources/translations/security.pt.xlf  տh  5>      C   vendor/symfony/security-core/Resources/translations/security.et.xlf  տh  s      C   vendor/symfony/security-core/Resources/translations/security.de.xlfV  տhV  :      C   vendor/symfony/security-core/Resources/translations/security.sl.xlf  տh  A      C   vendor/symfony/security-core/Resources/translations/security.it.xlf  տh  a      C   vendor/symfony/security-core/Resources/translations/security.gl.xlf8  տh8  Ϗ      C   vendor/symfony/security-core/Resources/translations/security.es.xlfQ  տhQ  cP)      C   vendor/symfony/security-core/Resources/translations/security.hu.xlf:  տh:  KY      C   vendor/symfony/security-core/Resources/translations/security.da.xlf  տh  mm      C   vendor/symfony/security-core/Resources/translations/security.fi.xlf  տh   T      C   vendor/symfony/security-core/Resources/translations/security.id.xlf  տh  x"      C   vendor/symfony/security-core/Resources/translations/security.sk.xlf  տh  ^P      C   vendor/symfony/security-core/Resources/translations/security.ro.xlfy  տhy  Aze      J   vendor/symfony/security-core/User/AttributesBasedUserProviderInterface.phpN  տhN  u      .   vendor/symfony/security-core/User/OidcUser.php  տh        9   vendor/symfony/security-core/User/InMemoryUserChecker.php  տh  l      3   vendor/symfony/security-core/User/UserInterface.php  տh  K-      ;   vendor/symfony/security-core/User/UserProviderInterface.phpI	  տhI	  ̤      9   vendor/symfony/security-core/User/MissingUserProvider.php  տh  E      6   vendor/symfony/security-core/User/ChainUserChecker.phpd  տhd  OϤ      N   vendor/symfony/security-core/User/LegacyPasswordAuthenticatedUserInterface.php1  տh1  ,      ?   vendor/symfony/security-core/User/PasswordUpgraderInterface.php  տh  }m      2   vendor/symfony/security-core/User/InMemoryUser.phpX  տhX  H      :   vendor/symfony/security-core/User/InMemoryUserProvider.php  տh  ,aR      8   vendor/symfony/security-core/User/EquatableInterface.phpm  տhm  C      H   vendor/symfony/security-core/User/PasswordAuthenticatedUserInterface.php  տh  hΤ      :   vendor/symfony/security-core/User/UserCheckerInterface.phpb  տhb  P      7   vendor/symfony/security-core/User/ChainUserProvider.php	  տh	         &   vendor/symfony/security-core/README.md  տh  {u!      L   vendor/symfony/security-core/Authorization/AuthorizationCheckerInterface.php2  տh2  O      I   vendor/symfony/security-core/Authorization/ExpressionLanguageProvider.phpV  տhV  @)5      M   vendor/symfony/security-core/Authorization/TraceableAccessDecisionManager.php
  տh
  T(      D   vendor/symfony/security-core/Authorization/AccessDecisionManager.phpl  տhl  0ո      M   vendor/symfony/security-core/Authorization/AccessDecisionManagerInterface.php}  տh}  ,t      C   vendor/symfony/security-core/Authorization/Voter/VoterInterface.php  տh  ])      L   vendor/symfony/security-core/Authorization/Voter/CacheableVoterInterface.php~  տh~  9      D   vendor/symfony/security-core/Authorization/Voter/ExpressionVoter.php3
  տh3
        G   vendor/symfony/security-core/Authorization/Voter/RoleHierarchyVoter.phpl  տhl  H??      C   vendor/symfony/security-core/Authorization/Voter/TraceableVoter.php)  տh)  'J      :   vendor/symfony/security-core/Authorization/Voter/Voter.phpf  տhf  5~      >   vendor/symfony/security-core/Authorization/Voter/RoleVoter.php  տh  Pj^      G   vendor/symfony/security-core/Authorization/Voter/AuthenticatedVoter.phpC  տhC  A      A   vendor/symfony/security-core/Authorization/ExpressionLanguage.php  տh  8Cy      C   vendor/symfony/security-core/Authorization/AuthorizationChecker.php  տh  w      H   vendor/symfony/security-core/Authorization/Strategy/PriorityStrategy.php  տh   7^      I   vendor/symfony/security-core/Authorization/Strategy/UnanimousStrategy.php/  տh/        K   vendor/symfony/security-core/Authorization/Strategy/AffirmativeStrategy.php  տh  
م      I   vendor/symfony/security-core/Authorization/Strategy/ConsensusStrategy.php  տh  դ      W   vendor/symfony/security-core/Authorization/Strategy/AccessDecisionStrategyInterface.php]  տh]  pf      )   vendor/symfony/security-core/Security.php
	  տh
	        @   vendor/symfony/security-core/Exception/AccessDeniedException.phpZ  տhZ  pth      D   vendor/symfony/security-core/Exception/InvalidCsrfTokenException.php}  տh}  O      :   vendor/symfony/security-core/Exception/LogoutException.php  տh  y'פ      9   vendor/symfony/security-core/Exception/LogicException.php  տh  $2      @   vendor/symfony/security-core/Exception/LazyResponseException.php  տh  .'      S   vendor/symfony/security-core/Exception/CustomUserMessageAuthenticationException.php	  տh	  qHV      =   vendor/symfony/security-core/Exception/ExceptionInterface.php  տh  ^      B   vendor/symfony/security-core/Exception/BadCredentialsException.php  տh  h	      ;   vendor/symfony/security-core/Exception/RuntimeException.php  տh  >
      <   vendor/symfony/security-core/Exception/DisabledException.phpv  տhv  Ϥֽ      A   vendor/symfony/security-core/Exception/TokenNotFoundException.php  տh  (      D   vendor/symfony/security-core/Exception/ProviderNotFoundException.php  տh  R      F   vendor/symfony/security-core/Exception/SessionUnavailableException.phpz  տhz  {Y      C   vendor/symfony/security-core/Exception/InvalidArgumentException.php  տh  W.      B   vendor/symfony/security-core/Exception/AccountExpiredException.php  տh  O
      I   vendor/symfony/security-core/Exception/AuthenticationExpiredException.phpG  տhG  %.D      V   vendor/symfony/security-core/Exception/TooManyLoginAttemptsAuthenticationException.php}  տh}  j      ?   vendor/symfony/security-core/Exception/CookieTheftException.php  տh  m	      I   vendor/symfony/security-core/Exception/AuthenticationServiceException.php  տh  t%      C   vendor/symfony/security-core/Exception/UnsupportedUserException.phpJ  տhJ  jۤ      A   vendor/symfony/security-core/Exception/AccountStatusException.php  տh  c%      R   vendor/symfony/security-core/Exception/CustomUserMessageAccountStatusException.php  տh  *
      N   vendor/symfony/security-core/Exception/InsufficientAuthenticationException.php&  տh&  [d      :   vendor/symfony/security-core/Exception/LockedException.phpl  տhl  0믤      B   vendor/symfony/security-core/Exception/AuthenticationException.php+  տh+  l      @   vendor/symfony/security-core/Exception/UserNotFoundException.php@  տh@  򼓤      U   vendor/symfony/security-core/Exception/AuthenticationCredentialsNotFoundException.php  տh  bb      F   vendor/symfony/security-core/Exception/CredentialsExpiredException.php  տh  8h      C   vendor/symfony/security-core/Authentication/Token/AbstractToken.phpb  տhb  ߤ7	      ?   vendor/symfony/security-core/Authentication/Token/NullToken.php   տh   iƤ      W   vendor/symfony/security-core/Authentication/Token/Storage/UsageTrackingTokenStorage.php	  տh	  l	      J   vendor/symfony/security-core/Authentication/Token/Storage/TokenStorage.php4  տh4  g      S   vendor/symfony/security-core/Authentication/Token/Storage/TokenStorageInterface.php  տh  %N      E   vendor/symfony/security-core/Authentication/Token/RememberMeToken.php  տh  
5Lq      E   vendor/symfony/security-core/Authentication/Token/SwitchUserToken.phpm  տhm  8      K   vendor/symfony/security-core/Authentication/Token/PreAuthenticatedToken.php  տh  .      D   vendor/symfony/security-core/Authentication/Token/TokenInterface.php1	  տh1	  =N*ݤ      K   vendor/symfony/security-core/Authentication/Token/UsernamePasswordToken.php  տh  z      T   vendor/symfony/security-core/Authentication/AuthenticationTrustResolverInterface.php`  տh`  J      K   vendor/symfony/security-core/Authentication/AuthenticationTrustResolver.phpw  տhw  4
      S   vendor/symfony/security-core/Authentication/RememberMe/PersistentTokenInterface.php  տh        P   vendor/symfony/security-core/Authentication/RememberMe/InMemoryTokenProvider.php'  տh'  =      M   vendor/symfony/security-core/Authentication/RememberMe/CacheTokenVerifier.php	  տh	  -Lu      J   vendor/symfony/security-core/Authentication/RememberMe/PersistentToken.php  տh  Ij       Q   vendor/symfony/security-core/Authentication/RememberMe/TokenVerifierInterface.php  տh  Ҥ      Q   vendor/symfony/security-core/Authentication/RememberMe/TokenProviderInterface.php  տh  ܪ      A   vendor/symfony/security-core/Event/AuthenticationSuccessEvent.phpu  տhu        :   vendor/symfony/security-core/Event/AuthenticationEvent.php  տh  :7x      0   vendor/symfony/security-core/Event/VoteEvent.php-  տh-        *   vendor/symfony/security-core/composer.json  տh  x4      5   vendor/symfony/security-core/AuthenticationEvents.php  տh  "a䚤      ,   vendor/symfony/deprecation-contracts/LICENSE,  տh,  K      1   vendor/symfony/deprecation-contracts/CHANGELOG.md   տh   h{#      1   vendor/symfony/deprecation-contracts/function.php  տh  Oݤ      .   vendor/symfony/deprecation-contracts/README.md  տh  X      2   vendor/symfony/deprecation-contracts/composer.jsonS  տhS  No      (   vendor/symfony/routing/CompiledRoute.php6  տh6  k栤      *   vendor/symfony/routing/Attribute/Route.php  տh  MT|         vendor/symfony/routing/LICENSE,  տh,  U      (   vendor/symfony/routing/RouteCompiler.php8  տh8  u      #   vendor/symfony/routing/CHANGELOG.md6  տh6  V^      )   vendor/symfony/routing/RequestContext.php`  տh`  )-ͤ      +   vendor/symfony/routing/Annotation/Route.php  տh  m\      :   vendor/symfony/routing/Matcher/RequestMatcherInterface.php+  տh+  <      =   vendor/symfony/routing/Matcher/ExpressionLanguageProvider.php  տh  ~      -   vendor/symfony/routing/Matcher/UrlMatcher.php'  տh'  #Ф      B   vendor/symfony/routing/Matcher/RedirectableUrlMatcherInterface.phpo  տho  0
H      6   vendor/symfony/routing/Matcher/UrlMatcherInterface.php  տh  P-2Ȥ      5   vendor/symfony/routing/Matcher/CompiledUrlMatcher.php  տh  *g      6   vendor/symfony/routing/Matcher/TraceableUrlMatcher.phpJ  տhJ  @      B   vendor/symfony/routing/Matcher/Dumper/CompiledUrlMatcherDumper.phpJ  տhJ   3I      7   vendor/symfony/routing/Matcher/Dumper/MatcherDumper.php  տh  \Pܤ      @   vendor/symfony/routing/Matcher/Dumper/MatcherDumperInterface.phpg  տhg  xI{$      A   vendor/symfony/routing/Matcher/Dumper/CompiledUrlMatcherTrait.php  տh  kR      @   vendor/symfony/routing/Matcher/Dumper/StaticPrefixCollection.php  տh  ˥      9   vendor/symfony/routing/Matcher/RedirectableUrlMatcher.php<  տh<  ðKʤ          vendor/symfony/routing/README.md  տh  rɤ      9   vendor/symfony/routing/Generator/CompiledUrlGenerator.php
  տh
  XA~      1   vendor/symfony/routing/Generator/UrlGenerator.php;  տh;  Yn'      F   vendor/symfony/routing/Generator/ConfigurableRequirementsInterface.php  տh  dfФ      :   vendor/symfony/routing/Generator/UrlGeneratorInterface.php
  տh
  Y3
8      D   vendor/symfony/routing/Generator/Dumper/GeneratorDumperInterface.phpi  տhi  fE      F   vendor/symfony/routing/Generator/Dumper/CompiledUrlGeneratorDumper.php  տh        ;   vendor/symfony/routing/Generator/Dumper/GeneratorDumper.php$  տh$  αh      *   vendor/symfony/routing/RouteCollection.phpO+  տhO+  u      6   vendor/symfony/routing/Requirement/EnumRequirement.php  տh        2   vendor/symfony/routing/Requirement/Requirement.phpR  տhR  1$      7   vendor/symfony/routing/RequestContextAwareInterface.php6  տh6  t      7   vendor/symfony/routing/Loader/AnnotationClassLoader.php  տh  tD0      :   vendor/symfony/routing/Loader/AttributeDirectoryLoader.php  տh  Tst      5   vendor/symfony/routing/Loader/AttributeFileLoader.php  տh  MKI      0   vendor/symfony/routing/Loader/YamlFileLoader.php/  տh/  14%      6   vendor/symfony/routing/Loader/AnnotationFileLoader.php  տh        <   vendor/symfony/routing/Loader/schema/routing/routing-1.0.xsd9  տh9  *#      /   vendor/symfony/routing/Loader/PhpFileLoader.php  տh  @      5   vendor/symfony/routing/Loader/Psr4DirectoryLoader.php  տh  *>      /   vendor/symfony/routing/Loader/XmlFileLoader.phpF  տhF  =k      .   vendor/symfony/routing/Loader/ObjectLoader.phpq  տhq  !v|      ?   vendor/symfony/routing/Loader/Configurator/Traits/HostTrait.php!  տh!        A   vendor/symfony/routing/Loader/Configurator/Traits/PrefixTrait.php
  տh
  (      I   vendor/symfony/routing/Loader/Configurator/Traits/LocalizedRouteTrait.php3
  տh3
  }2       @   vendor/symfony/routing/Loader/Configurator/Traits/RouteTrait.php9  տh9  ,s      >   vendor/symfony/routing/Loader/Configurator/Traits/AddTrait.phpS  տhS  Ӥ      @   vendor/symfony/routing/Loader/Configurator/RouteConfigurator.php  տh  {      E   vendor/symfony/routing/Loader/Configurator/CollectionConfigurator.php  տh  ֠P      @   vendor/symfony/routing/Loader/Configurator/AliasConfigurator.php  տh        B   vendor/symfony/routing/Loader/Configurator/RoutingConfigurator.php  տh  a      A   vendor/symfony/routing/Loader/Configurator/ImportConfigurator.php  տh  O      6   vendor/symfony/routing/Loader/AttributeClassLoader.php>  տh>  K      1   vendor/symfony/routing/Loader/ContainerLoader.php  տh  :      1   vendor/symfony/routing/Loader/DirectoryLoader.php  տh  ]/      0   vendor/symfony/routing/Loader/GlobFileLoader.php  տh  .]      /   vendor/symfony/routing/Loader/ClosureLoader.php  տh  
       ;   vendor/symfony/routing/Loader/AnnotationDirectoryLoader.php  տh  7
h          vendor/symfony/routing/Route.php/  տh/  _      *   vendor/symfony/routing/RouterInterface.php"  տh"  WF      !   vendor/symfony/routing/Router.phpt/  տht/  -X      1   vendor/symfony/routing/RouteCompilerInterface.php  տh  T          vendor/symfony/routing/Alias.php	  տh	  ä      Q   vendor/symfony/routing/DependencyInjection/AddExpressionLanguageProvidersPass.php  տh  Tw      B   vendor/symfony/routing/DependencyInjection/RoutingResolverPass.php"  տh"  K˶      >   vendor/symfony/routing/Exception/ResourceNotFoundException.php2  տh2  FL"1      7   vendor/symfony/routing/Exception/ExceptionInterface.php  տh  &      ;   vendor/symfony/routing/Exception/RouteNotFoundException.php  տh  	C      5   vendor/symfony/routing/Exception/RuntimeException.php  տh  $>G      H   vendor/symfony/routing/Exception/MissingMandatoryParametersException.phpC  տhC  jYKФ      =   vendor/symfony/routing/Exception/InvalidArgumentException.php  տh  ֤      >   vendor/symfony/routing/Exception/MethodNotAllowedException.phpp  տhp  .ִ      =   vendor/symfony/routing/Exception/NoConfigurationException.php  տh  r      D   vendor/symfony/routing/Exception/RouteCircularReferenceException.php>  տh>  \T      >   vendor/symfony/routing/Exception/InvalidParameterException.php  տh  !N      $   vendor/symfony/routing/composer.jsony  տhy  P      ?   vendor/symfony/service-contracts/ServiceSubscriberInterface.php
  տh
  }uP      ?   vendor/symfony/service-contracts/ServiceCollectionInterface.php  տh  }V      @   vendor/symfony/service-contracts/Attribute/SubscribedService.php  տh  i      7   vendor/symfony/service-contracts/Attribute/Required.php  տh  `e      (   vendor/symfony/service-contracts/LICENSE,  տh,        @   vendor/symfony/service-contracts/Test/ServiceLocatorTestCase.phpI  տhI  RisY      <   vendor/symfony/service-contracts/Test/ServiceLocatorTest.php  տh  ]1C      -   vendor/symfony/service-contracts/CHANGELOG.md   տh   h{#      *   vendor/symfony/service-contracts/README.mdJ  տhJ  Г      3   vendor/symfony/service-contracts/ResetInterface.php  տh  B4      =   vendor/symfony/service-contracts/ServiceProviderInterface.php  տh  B쯇      ;   vendor/symfony/service-contracts/ServiceSubscriberTrait.php(
  տh(
        B   vendor/symfony/service-contracts/ServiceMethodsSubscriberTrait.php>  տh>  ۳N      8   vendor/symfony/service-contracts/ServiceLocatorTrait.phpG  տhG  m:      .   vendor/symfony/service-contracts/composer.json  տh  0_      9   vendor/symfony/property-info/PhpStan/NameScopeFactory.php  տh  r      2   vendor/symfony/property-info/PhpStan/NameScope.php  տh  d)ݤ      ?   vendor/symfony/property-info/PropertyInfoExtractorInterface.php  տh  U-R      %   vendor/symfony/property-info/Type.php  տh  1ɤ      $   vendor/symfony/property-info/LICENSE,  տh,  H      6   vendor/symfony/property-info/Util/PhpDocTypeHelper.php  տh  0Ƥ      7   vendor/symfony/property-info/Util/PhpStanTypeHelper.php#  տh#  >       )   vendor/symfony/property-info/CHANGELOG.md  տh  .      ;   vendor/symfony/property-info/PropertyInfoCacheExtractor.phpE  տhE  ؍      D   vendor/symfony/property-info/PropertyWriteInfoExtractorInterface.php  տh  xBy\      A   vendor/symfony/property-info/PropertyAccessExtractorInterface.php  տh  2$C      ?   vendor/symfony/property-info/PropertyTypeExtractorInterface.phpQ  տhQ        1   vendor/symfony/property-info/PropertyReadInfo.php  տh  
      ;   vendor/symfony/property-info/Extractor/PhpStanExtractor.php.  տh.  G      >   vendor/symfony/property-info/Extractor/SerializerExtractor.php  տh        ?   vendor/symfony/property-info/Extractor/ConstructorExtractor.php  տh  -U      T   vendor/symfony/property-info/Extractor/ConstructorArgumentTypeExtractorInterface.php  տh  jv\      >   vendor/symfony/property-info/Extractor/ReflectionExtractor.php  տh        :   vendor/symfony/property-info/Extractor/PhpDocExtractor.php&0  տh&0  VŤ      F   vendor/symfony/property-info/PropertyDescriptionExtractorInterface.php   տh   
8      2   vendor/symfony/property-info/PropertyWriteInfo.php  տh  C      &   vendor/symfony/property-info/README.md  տh  '7      C   vendor/symfony/property-info/PropertyReadInfoExtractorInterface.php  տh  :|`դ      H   vendor/symfony/property-info/PropertyInitializableExtractorInterface.php  տh  OW      6   vendor/symfony/property-info/PropertyInfoExtractor.php  տh  yh      ?   vendor/symfony/property-info/PropertyListExtractorInterface.php  տh  J$      P   vendor/symfony/property-info/DependencyInjection/PropertyInfoConstructorPass.phpY  տhY  [c      E   vendor/symfony/property-info/DependencyInjection/PropertyInfoPass.php)  տh)         *   vendor/symfony/property-info/composer.json  տh  j      3   vendor/symfony/http-foundation/StreamedResponse.php  տh  <      :   vendor/symfony/http-foundation/RequestMatcherInterface.php|  տh|  3Q      5   vendor/symfony/http-foundation/BinaryFileResponse.php2  տh2  y      +   vendor/symfony/http-foundation/InputBag.php7  տh7  sĤ      I   vendor/symfony/http-foundation/RateLimiter/AbstractRequestRateLimiter.php	  տh	  -3      J   vendor/symfony/http-foundation/RateLimiter/RequestRateLimiterInterface.php
  տh
  ¤      R   vendor/symfony/http-foundation/RateLimiter/PeekableRequestRateLimiterInterface.php  տh  U      &   vendor/symfony/http-foundation/LICENSE,  տh,  U      J   vendor/symfony/http-foundation/Test/Constraint/ResponseCookieValueSame.phpL  տhL  f_      D   vendor/symfony/http-foundation/Test/Constraint/ResponseHasCookie.phpJ  տhJ  Z^      M   vendor/symfony/http-foundation/Test/Constraint/ResponseHeaderLocationSame.php  տh  U      I   vendor/symfony/http-foundation/Test/Constraint/ResponseStatusCodeSame.php  տh  I[x`      G   vendor/symfony/http-foundation/Test/Constraint/ResponseIsSuccessful.php.  տh.  P      J   vendor/symfony/http-foundation/Test/Constraint/ResponseIsUnprocessable.phpE  տhE  K¤      G   vendor/symfony/http-foundation/Test/Constraint/ResponseIsRedirected.php,  տh,        D   vendor/symfony/http-foundation/Test/Constraint/ResponseHasHeader.php<  տh<  &      L   vendor/symfony/http-foundation/Test/Constraint/RequestAttributeValueSame.php  տh  '`7      E   vendor/symfony/http-foundation/Test/Constraint/ResponseFormatSame.php  տh  ^)      E   vendor/symfony/http-foundation/Test/Constraint/ResponseHeaderSame.php  տh  <پJ      ,   vendor/symfony/http-foundation/ServerBag.php  տh        +   vendor/symfony/http-foundation/CHANGELOG.mduL  տhuL  M      ,   vendor/symfony/http-foundation/File/File.php  տh  ޯԤ      .   vendor/symfony/http-foundation/File/Stream.php  տh  x      4   vendor/symfony/http-foundation/File/UploadedFile.php^'  տh^'  b[      G   vendor/symfony/http-foundation/File/Exception/AccessDeniedException.phpi  տhi  Y      A   vendor/symfony/http-foundation/File/Exception/NoFileException.php  տh  -A      F   vendor/symfony/http-foundation/File/Exception/IniSizeFileException.php  տh  I      J   vendor/symfony/http-foundation/File/Exception/CannotWriteFileException.php  տh  :ݤ      H   vendor/symfony/http-foundation/File/Exception/ExtensionFileException.php  տh  )      ?   vendor/symfony/http-foundation/File/Exception/FileException.php  տh  j2      A   vendor/symfony/http-foundation/File/Exception/UploadException.php  տh  S      I   vendor/symfony/http-foundation/File/Exception/UnexpectedTypeException.php9  տh9  d-      G   vendor/symfony/http-foundation/File/Exception/FormSizeFileException.php  տh  m;      G   vendor/symfony/http-foundation/File/Exception/FileNotFoundException.phpY  տhY  {WɈ      F   vendor/symfony/http-foundation/File/Exception/PartialFileException.php  տh  *      G   vendor/symfony/http-foundation/File/Exception/NoTmpDirFileException.php  տh  n      +   vendor/symfony/http-foundation/Response.php  տh  u      )   vendor/symfony/http-foundation/Cookie.phpJ/  տhJ/  "f      /   vendor/symfony/http-foundation/AcceptHeader.php{
  տh{
  G      1   vendor/symfony/http-foundation/RequestMatcher.php  տh  յnҤ      4   vendor/symfony/http-foundation/ResponseHeaderBag.php  տh  4֭      .   vendor/symfony/http-foundation/HeaderUtils.php$  տh$  4      F   vendor/symfony/http-foundation/RequestMatcher/MethodRequestMatcher.php>  տh>        D   vendor/symfony/http-foundation/RequestMatcher/PathRequestMatcher.phpd  տhd  w|      F   vendor/symfony/http-foundation/RequestMatcher/IsJsonRequestMatcher.php  տh  TK      D   vendor/symfony/http-foundation/RequestMatcher/PortRequestMatcher.php  տh  2      D   vendor/symfony/http-foundation/RequestMatcher/HostRequestMatcher.phpR  տhR  s      J   vendor/symfony/http-foundation/RequestMatcher/AttributesRequestMatcher.php  տh  d      J   vendor/symfony/http-foundation/RequestMatcher/ExpressionRequestMatcher.php  տh  Q̤      F   vendor/symfony/http-foundation/RequestMatcher/SchemeRequestMatcher.php,  տh,  s>M      C   vendor/symfony/http-foundation/RequestMatcher/IpsRequestMatcher.php2  տh2  ti      /   vendor/symfony/http-foundation/RequestStack.php  տh   J      3   vendor/symfony/http-foundation/RedirectResponse.php9
  տh9
  V      /   vendor/symfony/http-foundation/JsonResponse.phpj  տhj  OP/      (   vendor/symfony/http-foundation/README.md  տh  &      *   vendor/symfony/http-foundation/Request.php տh kaФ      ;   vendor/symfony/http-foundation/ExpressionRequestMatcher.php  տh  |*      /   vendor/symfony/http-foundation/ParameterBag.php  տh  6      *   vendor/symfony/http-foundation/IpUtils.php   տh   6      3   vendor/symfony/http-foundation/AcceptHeaderItem.php  տh  :6      7   vendor/symfony/http-foundation/StreamedJsonResponse.php  տh  ؕSҤ      ,   vendor/symfony/http-foundation/UrlHelper.phpq  տhq  `Kl      6   vendor/symfony/http-foundation/ChainRequestMatcher.phpx  տhx  X!      ,   vendor/symfony/http-foundation/HeaderBag.php  տh  ZdL      *   vendor/symfony/http-foundation/FileBag.php  տh  "4Ϥ      H   vendor/symfony/http-foundation/Exception/ConflictingHeadersException.php  տh  ,Ň      E   vendor/symfony/http-foundation/Exception/UnexpectedValueException.phpx  տhx   ȕ      F   vendor/symfony/http-foundation/Exception/RequestExceptionInterface.php  տh  R      @   vendor/symfony/http-foundation/Exception/BadRequestException.php  տh  Uڤ      I   vendor/symfony/http-foundation/Exception/SuspiciousOperationException.php  տh  '      :   vendor/symfony/http-foundation/Exception/JsonException.php  տh        E   vendor/symfony/http-foundation/Exception/SessionNotFoundException.phpY  տhY  1      ,   vendor/symfony/http-foundation/composer.jsonv  տhv  ^D      ,   vendor/symfony/http-foundation/UriSigner.php!
  տh!
         J   vendor/symfony/http-foundation/Session/Attribute/AttributeBagInterface.php  տh  Gf=      A   vendor/symfony/http-foundation/Session/Attribute/AttributeBag.php
  տh
        H   vendor/symfony/http-foundation/Session/FlashBagAwareSessionInterface.php4  տh4        B   vendor/symfony/http-foundation/Session/SessionFactoryInterface.php  տh  f*      2   vendor/symfony/http-foundation/Session/Session.php  տh  <)      7   vendor/symfony/http-foundation/Session/SessionUtils.php  տh  '      M   vendor/symfony/http-foundation/Session/Storage/Handler/NullSessionHandler.php  տh  r@      Q   vendor/symfony/http-foundation/Session/Storage/Handler/AbstractSessionHandler.php  տh  դ      P   vendor/symfony/http-foundation/Session/Storage/Handler/SessionHandlerFactory.php)  տh)  o      L   vendor/symfony/http-foundation/Session/Storage/Handler/PdoSessionHandler.php  տh  AS      T   vendor/symfony/http-foundation/Session/Storage/Handler/MarshallingSessionHandler.php~  տh~  |%      S   vendor/symfony/http-foundation/Session/Storage/Handler/NativeFileSessionHandler.php  տh  wb      R   vendor/symfony/http-foundation/Session/Storage/Handler/MigratingSessionHandler.php  տh  Dt|      M   vendor/symfony/http-foundation/Session/Storage/Handler/IdentityMarshaller.php  տh  Gҭq      P   vendor/symfony/http-foundation/Session/Storage/Handler/MongoDbSessionHandler.phpG  տhG  $      N   vendor/symfony/http-foundation/Session/Storage/Handler/RedisSessionHandler.php  տh  G      O   vendor/symfony/http-foundation/Session/Storage/Handler/StrictSessionHandler.php	  տh	  mI      R   vendor/symfony/http-foundation/Session/Storage/Handler/MemcachedSessionHandler.php  տh  oڤ      G   vendor/symfony/http-foundation/Session/Storage/NativeSessionStorage.php7  տh7  tJ      J   vendor/symfony/http-foundation/Session/Storage/SessionStorageInterface.php/  տh/  {      P   vendor/symfony/http-foundation/Session/Storage/MockFileSessionStorageFactory.php  տh  YPZ      L   vendor/symfony/http-foundation/Session/Storage/Proxy/SessionHandlerProxy.phpB	  տhB	        F   vendor/symfony/http-foundation/Session/Storage/Proxy/AbstractProxy.php  տh  <      N   vendor/symfony/http-foundation/Session/Storage/NativeSessionStorageFactory.php!  տh!  	      J   vendor/symfony/http-foundation/Session/Storage/PhpBridgeSessionStorage.php  տh  f      Q   vendor/symfony/http-foundation/Session/Storage/SessionStorageFactoryInterface.phpw  տhw  ]n      I   vendor/symfony/http-foundation/Session/Storage/MockFileSessionStorage.php  տh  *8      Q   vendor/symfony/http-foundation/Session/Storage/PhpBridgeSessionStorageFactory.php  տh  ɤ      >   vendor/symfony/http-foundation/Session/Storage/MetadataBag.php
  տh
        J   vendor/symfony/http-foundation/Session/Storage/MockArraySessionStorage.php	  տh	  Q3U      ;   vendor/symfony/http-foundation/Session/SessionInterface.php  տh  OY>      C   vendor/symfony/http-foundation/Session/Flash/AutoExpireFlashBag.php  տh  Ԗޤ      B   vendor/symfony/http-foundation/Session/Flash/FlashBagInterface.php  տh  u1Ф      9   vendor/symfony/http-foundation/Session/Flash/FlashBag.php	  տh	  vɅ      9   vendor/symfony/http-foundation/Session/SessionFactory.phpG  տhG  
      :   vendor/symfony/http-foundation/Session/SessionBagProxy.php  տh  
      >   vendor/symfony/http-foundation/Session/SessionBagInterface.phpW  տhW  #9      ,   vendor/symfony/var-exporter/Instantiator.php	  տh	  
      +   vendor/symfony/var-exporter/ProxyHelper.php_  տh_  )      #   vendor/symfony/var-exporter/LICENSE,  տh,        (   vendor/symfony/var-exporter/CHANGELOG.md  տh  t?      (   vendor/symfony/var-exporter/Hydrator.php  տh  Lф      8   vendor/symfony/var-exporter/Internal/LazyObjectState.php(  տh(  P      ;   vendor/symfony/var-exporter/Internal/LazyObjectRegistry.phpT  տhT  x      /   vendor/symfony/var-exporter/Internal/Values.php  տh  `ǿ      8   vendor/symfony/var-exporter/Internal/LazyObjectTrait.php)  տh)  ;ޣ      1   vendor/symfony/var-exporter/Internal/Hydrator.php(.  տh(.  L\-      1   vendor/symfony/var-exporter/Internal/Registry.php@  տh@  #      2   vendor/symfony/var-exporter/Internal/Reference.php
  տh
  #Jn      1   vendor/symfony/var-exporter/Internal/Exporter.phpUB  տhUB  EG      .   vendor/symfony/var-exporter/LazyGhostTrait.php;  տh;  Y      %   vendor/symfony/var-exporter/README.md-  տh-  "      .   vendor/symfony/var-exporter/LazyProxyTrait.php2  տh2  jˤ      +   vendor/symfony/var-exporter/VarExporter.phpR  տhR  eH      3   vendor/symfony/var-exporter/LazyObjectInterface.phpa  տha  @#      8   vendor/symfony/var-exporter/Exception/LogicException.php  տh  -ʤ      <   vendor/symfony/var-exporter/Exception/ExceptionInterface.phpd  տhd        @   vendor/symfony/var-exporter/Exception/ClassNotFoundException.php1  տh1  w w      F   vendor/symfony/var-exporter/Exception/NotInstantiableTypeException.php>  տh>  }      )   vendor/symfony/var-exporter/composer.jsonr  տhr  ~j      E   vendor/symfony/error-handler/ErrorEnhancer/ErrorEnhancerInterface.php	  տh	  ޺      I   vendor/symfony/error-handler/ErrorEnhancer/ClassNotFoundErrorEnhancer.phpR  տhR        M   vendor/symfony/error-handler/ErrorEnhancer/UndefinedFunctionErrorEnhancer.php*  տh*  ^z      K   vendor/symfony/error-handler/ErrorEnhancer/UndefinedMethodErrorEnhancer.php  տh  1'      $   vendor/symfony/error-handler/LICENSE,  տh,  զ_Ϥ      )   vendor/symfony/error-handler/CHANGELOG.md  տh  D9      B   vendor/symfony/error-handler/Resources/bin/patch-type-declarations
  տh
  d"m      M   vendor/symfony/error-handler/Resources/bin/extract-tentative-return-types.php   տh   mE      ?   vendor/symfony/error-handler/Resources/views/exception.html.php/  տh/        <   vendor/symfony/error-handler/Resources/views/traces.html.php
  տh
  n       A   vendor/symfony/error-handler/Resources/views/traces_text.html.php  տh  j+2      :   vendor/symfony/error-handler/Resources/views/logs.html.php)	  տh)	  _&      ;   vendor/symfony/error-handler/Resources/views/trace.html.php`  տh`  39      ;   vendor/symfony/error-handler/Resources/views/error.html.phpd  տhd  x      D   vendor/symfony/error-handler/Resources/views/exception_full.html.php  տh  Eޤ      ?   vendor/symfony/error-handler/Resources/assets/css/exception.css	B  տh	B  R      D   vendor/symfony/error-handler/Resources/assets/css/exception_full.css
  տh
  *bc      ;   vendor/symfony/error-handler/Resources/assets/css/error.css  տh  %7      J   vendor/symfony/error-handler/Resources/assets/images/icon-minus-square.svgQ  տhQ  p      B   vendor/symfony/error-handler/Resources/assets/images/icon-book.svg  տh        E   vendor/symfony/error-handler/Resources/assets/images/icon-support.svgz  տhz  S̤      F   vendor/symfony/error-handler/Resources/assets/images/chevron-right.svg  տh        J   vendor/symfony/error-handler/Resources/assets/images/symfony-ghost.svg.php   տh   9꒤      I   vendor/symfony/error-handler/Resources/assets/images/icon-plus-square.svg  տh  U      E   vendor/symfony/error-handler/Resources/assets/images/symfony-logo.svg  տh  %0ɤ      B   vendor/symfony/error-handler/Resources/assets/images/icon-copy.svg	  տh	  "Ȗ      G   vendor/symfony/error-handler/Resources/assets/images/favicon.png.base64  տh  "i^      K   vendor/symfony/error-handler/Resources/assets/images/icon-plus-square-o.svg  տh  -      L   vendor/symfony/error-handler/Resources/assets/images/icon-minus-square-o.svg  տh  s0      =   vendor/symfony/error-handler/Resources/assets/js/exception.js4  տh4  C#      8   vendor/symfony/error-handler/Internal/TentativeTypes.php  տh        &   vendor/symfony/error-handler/Debug.phps  տhs  4\H      F   vendor/symfony/error-handler/ErrorRenderer/SerializerErrorRenderer.php
  տh
  <      ?   vendor/symfony/error-handler/ErrorRenderer/CliErrorRenderer.php  տh  
+2      E   vendor/symfony/error-handler/ErrorRenderer/ErrorRendererInterface.php  տh  sۤ      @   vendor/symfony/error-handler/ErrorRenderer/HtmlErrorRenderer.php'^  տh'^  ZO      @   vendor/symfony/error-handler/ErrorRenderer/FileLinkFormatter.phpP  տhP  Y      &   vendor/symfony/error-handler/README.md=  տh=  \      1   vendor/symfony/error-handler/DebugClassLoader.phpT  տhT  *W>      0   vendor/symfony/error-handler/BufferingLogger.phpA  տhA  Z      -   vendor/symfony/error-handler/ErrorHandler.phppk  տhpk  l_      /   vendor/symfony/error-handler/ThrowableUtils.php{  տh{  -F      7   vendor/symfony/error-handler/Error/OutOfMemoryError.php[  տh[  N      ;   vendor/symfony/error-handler/Error/UndefinedMethodError.php  տh  V[      1   vendor/symfony/error-handler/Error/FatalError.php
  տh
  Ff      =   vendor/symfony/error-handler/Error/UndefinedFunctionError.php  տh  lnB      9   vendor/symfony/error-handler/Error/ClassNotFoundError.php  տh  Ep      ;   vendor/symfony/error-handler/Exception/FlattenException.phpI.  տhI.  ޱњ      ?   vendor/symfony/error-handler/Exception/SilencedErrorContext.phpr  տhr  +      *   vendor/symfony/error-handler/composer.json  տh  ny&      4   vendor/symfony/cache-contracts/CallbackInterface.php]  տh]  oW$      0   vendor/symfony/cache-contracts/ItemInterface.php6  տh6  #
      &   vendor/symfony/cache-contracts/LICENSE,  տh,        +   vendor/symfony/cache-contracts/CHANGELOG.md   տh   h{#      1   vendor/symfony/cache-contracts/CacheInterface.php2	  տh2	  5      :   vendor/symfony/cache-contracts/NamespacedPoolInterface.php  տh  N      (   vendor/symfony/cache-contracts/README.mdF  տhF  _      -   vendor/symfony/cache-contracts/CacheTrait.php	  տh	  iW      9   vendor/symfony/cache-contracts/TagAwareCacheInterface.php  տh  1swc      ,   vendor/symfony/cache-contracts/composer.json  տh  /      7   vendor/symfony/dependency-injection/EnvVarProcessor.php2  տh2  sF      ;   vendor/symfony/dependency-injection/ContainerAwareTrait.phpO  տhO  4rS      B   vendor/symfony/dependency-injection/ExpressionLanguageProvider.php\  տh\  lD      1   vendor/symfony/dependency-injection/Container.php6  տh6  S      8   vendor/symfony/dependency-injection/ReverseContainer.php	  տh	  4)Ȥ      0   vendor/symfony/dependency-injection/Variable.php  տh  hp      P   vendor/symfony/dependency-injection/Extension/ConfigurableExtensionInterface.php#  տh#  ᅋ~      D   vendor/symfony/dependency-injection/Extension/ExtensionInterface.php`  տh`  ^
N      C   vendor/symfony/dependency-injection/Extension/AbstractExtension.php  տh  W$      @   vendor/symfony/dependency-injection/Extension/ExtensionTrait.php  տh  V      ;   vendor/symfony/dependency-injection/Extension/Extension.php  տh  0B      K   vendor/symfony/dependency-injection/Extension/PrependExtensionInterface.phpS  տhS  NC6      Q   vendor/symfony/dependency-injection/Extension/ConfigurationExtensionInterface.phpS  տhS  )      ?   vendor/symfony/dependency-injection/Attribute/Autoconfigure.php  տh  ZӤ      B   vendor/symfony/dependency-injection/Attribute/AutowireIterator.php  տh  o      =   vendor/symfony/dependency-injection/Attribute/AsDecorator.phpo  տho  Y|      H   vendor/symfony/dependency-injection/Attribute/AutowireServiceClosure.php  տh  ^#5      >   vendor/symfony/dependency-injection/Attribute/AsTaggedItem.php  տh  k      8   vendor/symfony/dependency-injection/Attribute/Target.php  տh  A      6   vendor/symfony/dependency-injection/Attribute/When.php  տh  Xˤ      C   vendor/symfony/dependency-injection/Attribute/AutowireDecorated.php  տh  +h      @   vendor/symfony/dependency-injection/Attribute/TaggedIterator.php  տh  u      A   vendor/symfony/dependency-injection/Attribute/AutowireLocator.phpe
  տhe
        B   vendor/symfony/dependency-injection/Attribute/AutowireCallable.phpT  տhT  鼎`      :   vendor/symfony/dependency-injection/Attribute/Autowire.php]
  տh]
  sO      B   vendor/symfony/dependency-injection/Attribute/AutoconfigureTag.php  տh  	       ?   vendor/symfony/dependency-injection/Attribute/TaggedLocator.php  տh  鱞      >   vendor/symfony/dependency-injection/Attribute/MapDecorated.phpb  տhb  \      9   vendor/symfony/dependency-injection/Attribute/Exclude.php  տh  a)      9   vendor/symfony/dependency-injection/Attribute/AsAlias.php  տh        +   vendor/symfony/dependency-injection/LICENSE,  տh,  U      0   vendor/symfony/dependency-injection/CHANGELOG.mdhI  տhhI  Z[      Q   vendor/symfony/dependency-injection/Config/ContainerParametersResourceChecker.php)  տh)  }~      J   vendor/symfony/dependency-injection/Config/ContainerParametersResource.php  տh  5      J   vendor/symfony/dependency-injection/Argument/ReferenceSetArgumentTrait.php	  տh	  /      A   vendor/symfony/dependency-injection/Argument/AbstractArgument.php  տh  1i      D   vendor/symfony/dependency-injection/Argument/RewindableGenerator.php  տh  s      G   vendor/symfony/dependency-injection/Argument/ServiceLocatorArgument.php  տh  /c=      >   vendor/symfony/dependency-injection/Argument/BoundArgument.php  տh  >))      A   vendor/symfony/dependency-injection/Argument/IteratorArgument.php6  տh6  2Ҥ      <   vendor/symfony/dependency-injection/Argument/LazyClosure.php=
  տh=
  EK      G   vendor/symfony/dependency-injection/Argument/TaggedIteratorArgument.phpu
  տhu
        B   vendor/symfony/dependency-injection/Argument/ArgumentInterface.phpN  տhN        ?   vendor/symfony/dependency-injection/Argument/ServiceLocator.php#  տh#  ěs@      G   vendor/symfony/dependency-injection/Argument/ServiceClosureArgument.php*  տh*  k      8   vendor/symfony/dependency-injection/ContainerBuilder.php  տh  ܉      7   vendor/symfony/dependency-injection/ChildDefinition.phpp
  տhp
  /o      1   vendor/symfony/dependency-injection/Reference.php  տh  ͯ      J   vendor/symfony/dependency-injection/ParameterBag/ParameterBagInterface.php	  տh	  U]      O   vendor/symfony/dependency-injection/ParameterBag/EnvPlaceholderParameterBag.php  տh  !      A   vendor/symfony/dependency-injection/ParameterBag/ParameterBag.php$  տh$  AҤ      J   vendor/symfony/dependency-injection/ParameterBag/ContainerBagInterface.php  տh        A   vendor/symfony/dependency-injection/ParameterBag/ContainerBag.php  տh  #O      G   vendor/symfony/dependency-injection/ParameterBag/FrozenParameterBag.php  տh  0P      2   vendor/symfony/dependency-injection/Definition.phpP  տhP  D      @   vendor/symfony/dependency-injection/EnvVarProcessorInterface.php  տh  90      -   vendor/symfony/dependency-injection/README.mdC  տhC  <      :   vendor/symfony/dependency-injection/ContainerInterface.phpd	  տhd	  ʤ      9   vendor/symfony/dependency-injection/Loader/FileLoader.php<  տh<  (٤      =   vendor/symfony/dependency-injection/Loader/YamlFileLoader.php  տh  ȶ_      O   vendor/symfony/dependency-injection/Loader/schema/dic/services/services-1.0.xsdB  տhB  o      <   vendor/symfony/dependency-injection/Loader/PhpFileLoader.php!  տh!  g      <   vendor/symfony/dependency-injection/Loader/XmlFileLoader.php  տh  Thm      <   vendor/symfony/dependency-injection/Loader/IniFileLoader.php  տh  j}      P   vendor/symfony/dependency-injection/Loader/Configurator/ServicesConfigurator.php4  տh4  g      P   vendor/symfony/dependency-injection/Loader/Configurator/DefaultsConfigurator.php9	  տh9	  Ca      Q   vendor/symfony/dependency-injection/Loader/Configurator/ReferenceConfigurator.php  տh  w      T   vendor/symfony/dependency-injection/Loader/Configurator/FromCallableConfigurator.php  տh  6n      M   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ClassTrait.php1  տh1  D      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/CallTrait.phpN  տhN  X_^      Q   vendor/symfony/dependency-injection/Loader/Configurator/Traits/SyntheticTrait.php  տh  .      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/PropertyTrait.phpl  տhl  
s_      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ArgumentTrait.php  տh  
      T   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ConfiguratorTrait.php  տh  M      N   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ParentTrait.php  տh  (      O   vendor/symfony/dependency-injection/Loader/Configurator/Traits/FactoryTrait.phpd  տhd  'D      K   vendor/symfony/dependency-injection/Loader/Configurator/Traits/TagTrait.php  տh  p       N   vendor/symfony/dependency-injection/Loader/Configurator/Traits/PublicTrait.php  տh        P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/DecorateTrait.php{  տh{  2Ѥ      U   vendor/symfony/dependency-injection/Loader/Configurator/Traits/AutoconfigureTrait.phpE  տhE  ^7      T   vendor/symfony/dependency-injection/Loader/Configurator/Traits/FromCallableTrait.php	  տh	  \      Q   vendor/symfony/dependency-injection/Loader/Configurator/Traits/DeprecateTrait.phpb  տhb  *'Ѥ      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/BindTrait.php[  տh[  Bf      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/LazyTrait.phpD  տhD  5R      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/FileTrait.phpG  տhG  F8      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/AbstractTrait.php  տh  ge      M   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ShareTrait.phpL  տhL  b      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/AutowireTrait.phpM  տhM  P      S   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ConstructorTrait.phpU  տhU  86$      P   vendor/symfony/dependency-injection/Loader/Configurator/AbstractConfigurator.php  տh  ԏ)      X   vendor/symfony/dependency-injection/Loader/Configurator/ClosureReferenceConfigurator.php  տh  #y      K   vendor/symfony/dependency-injection/Loader/Configurator/EnvConfigurator.phpj  տhj        W   vendor/symfony/dependency-injection/Loader/Configurator/AbstractServiceConfigurator.php  տh  fۤ      R   vendor/symfony/dependency-injection/Loader/Configurator/InstanceofConfigurator.php  տh  !R      Q   vendor/symfony/dependency-injection/Loader/Configurator/ContainerConfigurator.php  տh  4      M   vendor/symfony/dependency-injection/Loader/Configurator/AliasConfigurator.php  տh  RF,b      U   vendor/symfony/dependency-injection/Loader/Configurator/InlineServiceConfigurator.phpR  տhR  <      Q   vendor/symfony/dependency-injection/Loader/Configurator/PrototypeConfigurator.php
  տh
  o      R   vendor/symfony/dependency-injection/Loader/Configurator/ParametersConfigurator.php  տh  "      O   vendor/symfony/dependency-injection/Loader/Configurator/ServiceConfigurator.php  տh  A[_v      >   vendor/symfony/dependency-injection/Loader/DirectoryLoader.php2  տh2  	      =   vendor/symfony/dependency-injection/Loader/GlobFileLoader.php`  տh`        <   vendor/symfony/dependency-injection/Loader/ClosureLoader.php  տh  5      =   vendor/symfony/dependency-injection/LazyProxy/ProxyHelper.php  տh  Ğ}      K   vendor/symfony/dependency-injection/LazyProxy/PhpDumper/DumperInterface.php  տh  5=      M   vendor/symfony/dependency-injection/LazyProxy/PhpDumper/LazyServiceDumper.php  տh  p<      F   vendor/symfony/dependency-injection/LazyProxy/PhpDumper/NullDumper.php  տh  vOΤ      V   vendor/symfony/dependency-injection/LazyProxy/Instantiator/LazyServiceInstantiator.php  տh  (d      V   vendor/symfony/dependency-injection/LazyProxy/Instantiator/RealServiceInstantiator.phpd  տhd  翓      T   vendor/symfony/dependency-injection/LazyProxy/Instantiator/InstantiatorInterface.php~  տh~  0ND      :   vendor/symfony/dependency-injection/ExpressionLanguage.phpb  տhb  !UO      6   vendor/symfony/dependency-injection/ServiceLocator.php  տh  9x"D      6   vendor/symfony/dependency-injection/TypedReference.php3  տh3  adt      -   vendor/symfony/dependency-injection/Alias.php  տh  nZԤ      U   vendor/symfony/dependency-injection/Exception/ParameterCircularReferenceException.php  տh  t9      @   vendor/symfony/dependency-injection/Exception/LogicException.php  տh  }|Ȥ      F   vendor/symfony/dependency-injection/Exception/EnvNotFoundException.php  տh  &      L   vendor/symfony/dependency-injection/Exception/ParameterNotFoundException.php"  տh"  
      D   vendor/symfony/dependency-injection/Exception/ExceptionInterface.php~  տh~        F   vendor/symfony/dependency-injection/Exception/OutOfBoundsException.php  տh  On      S   vendor/symfony/dependency-injection/Exception/ServiceCircularReferenceException.php_  տh_  Ke&      J   vendor/symfony/dependency-injection/Exception/ServiceNotFoundException.php  տh  Ф      B   vendor/symfony/dependency-injection/Exception/RuntimeException.php	  տh	  
      J   vendor/symfony/dependency-injection/Exception/InvalidArgumentException.php'  տh'        H   vendor/symfony/dependency-injection/Exception/BadMethodCallException.php  տh  ,w      K   vendor/symfony/dependency-injection/Exception/AutowiringFailedException.php  տh  M      O   vendor/symfony/dependency-injection/Exception/InvalidParameterTypeException.php0  տh0  I      G   vendor/symfony/dependency-injection/Exception/EnvParameterException.php  տh  =&)      @   vendor/symfony/dependency-injection/TaggedContainerInterface.php  տh  J.      1   vendor/symfony/dependency-injection/Parameter.phpf  տhf  sD      E   vendor/symfony/dependency-injection/Compiler/DecoratorServicePass.php  տh  'f      M   vendor/symfony/dependency-injection/Compiler/ResolveInvalidReferencesPass.php  տh  ]      L   vendor/symfony/dependency-injection/Compiler/ValidateEnvPlaceholdersPass.php  տh        M   vendor/symfony/dependency-injection/Compiler/RegisterEnvVarProcessorsPass.php@  տh@  p脤      T   vendor/symfony/dependency-injection/Compiler/RegisterAutoconfigureAttributesPass.php  տh        L   vendor/symfony/dependency-injection/Compiler/CheckDefinitionValidityPass.php!  տh!  gPK      ;   vendor/symfony/dependency-injection/Compiler/PassConfig.phpm  տhm  1&      F   vendor/symfony/dependency-injection/Compiler/ServiceReferenceGraph.php
  տh
  j      E   vendor/symfony/dependency-injection/Compiler/ResolveNoPreloadPass.phpK  տhK  7ɤ      J   vendor/symfony/dependency-injection/Compiler/ServiceReferenceGraphNode.php  տh        J   vendor/symfony/dependency-injection/Compiler/CheckTypeDeclarationsPass.php1  տh1  W       M   vendor/symfony/dependency-injection/Compiler/InlineServiceDefinitionsPass.php  տh  m      H   vendor/symfony/dependency-injection/Compiler/ResolveFactoryClassPass.php   տh   %d      D   vendor/symfony/dependency-injection/Compiler/ResolveBindingsPass.php$*  տh$*  
B      H   vendor/symfony/dependency-injection/Compiler/AutowireAsDecoratorPass.php  տh  3      K   vendor/symfony/dependency-injection/Compiler/PriorityTaggedServiceTrait.php  տh  v3      M   vendor/symfony/dependency-injection/Compiler/RegisterReverseContainerPass.php  տh  QY      F   vendor/symfony/dependency-injection/Compiler/AbstractRecursivePass.php8*  տh8*  c3      R   vendor/symfony/dependency-injection/Compiler/AliasDeprecatedPublicServicesPass.php  տh  Hl      R   vendor/symfony/dependency-injection/Compiler/ResolveInstanceofConditionalsPass.php8  տh8  y      O   vendor/symfony/dependency-injection/Compiler/ResolveReferencesToAliasesPass.php  տh  cW      K   vendor/symfony/dependency-injection/Compiler/CheckArgumentsValidityPass.php3  տh3  췤      O   vendor/symfony/dependency-injection/Compiler/AttributeAutoconfigurationPass.php  տh  1x      O   vendor/symfony/dependency-injection/Compiler/AutowireRequiredPropertiesPass.php-
  տh-
  zh      J   vendor/symfony/dependency-injection/Compiler/ResolveNamedArgumentsPass.php'  տh'  $      I   vendor/symfony/dependency-injection/Compiler/RemovePrivateAliasesPass.php  տh  XB      P   vendor/symfony/dependency-injection/Compiler/MergeExtensionConfigurationPass.php!  տh!  ?      J   vendor/symfony/dependency-injection/Compiler/ServiceReferenceGraphEdge.phpi  տhi  ^n      M   vendor/symfony/dependency-injection/Compiler/DefinitionErrorExceptionPass.php
  տh
  B      L   vendor/symfony/dependency-injection/Compiler/RemoveUnusedDefinitionsPass.php  տh  xp      =   vendor/symfony/dependency-injection/Compiler/AutowirePass.php8{  տh8{  an+      F   vendor/symfony/dependency-injection/Compiler/ServiceLocatorTagPass.php  տh  J      R   vendor/symfony/dependency-injection/Compiler/ResolveTaggedIteratorArgumentPass.phpq  տhq  ?      K   vendor/symfony/dependency-injection/Compiler/ResolveEnvPlaceholdersPass.php  տh  ]      L   vendor/symfony/dependency-injection/Compiler/CheckCircularReferencesPass.php  տh  uV      ]   vendor/symfony/dependency-injection/Compiler/CheckExceptionOnInvalidReferenceBehaviorPass.php  տh  Lפ      J   vendor/symfony/dependency-injection/Compiler/RemoveBuildParametersPass.php  տh  vg      E   vendor/symfony/dependency-injection/Compiler/AutoAliasServicePass.php  տh  zp
      Q   vendor/symfony/dependency-injection/Compiler/ResolveParameterPlaceHoldersPass.php  տh  F0      A   vendor/symfony/dependency-injection/Compiler/ResolveClassPass.php]  տh]  v`      N   vendor/symfony/dependency-injection/Compiler/RemoveAbstractDefinitionsPass.php  տh  Q      K   vendor/symfony/dependency-injection/Compiler/CheckReferenceValidityPass.php6  տh6  YB      O   vendor/symfony/dependency-injection/Compiler/RegisterServiceSubscribersPass.php  տh  a%      C   vendor/symfony/dependency-injection/Compiler/ResolveHotPathPass.php<	  տh<	  sY[      J   vendor/symfony/dependency-injection/Compiler/ResolveDecoratorStackPass.php  տh  lD      N   vendor/symfony/dependency-injection/Compiler/ResolveServiceSubscribersPass.php  տh  ٭v      F   vendor/symfony/dependency-injection/Compiler/CompilerPassInterface.php  տh  &      S   vendor/symfony/dependency-injection/Compiler/ReplaceAliasByActualDefinitionPass.phpa  տha  p6      L   vendor/symfony/dependency-injection/Compiler/ResolveChildDefinitionsPass.php&  տh&  W      9   vendor/symfony/dependency-injection/Compiler/Compiler.php
  տh
  ˤ      F   vendor/symfony/dependency-injection/Compiler/ExtensionCompilerPass.php  տh        M   vendor/symfony/dependency-injection/Compiler/AnalyzeServiceReferencesPass.php  տh  ^0      L   vendor/symfony/dependency-injection/Compiler/AutowireRequiredMethodsPass.php  տh  `#{      =   vendor/symfony/dependency-injection/Dumper/GraphvizDumper.php#  տh#  sO      9   vendor/symfony/dependency-injection/Dumper/YamlDumper.php	9  տh	9  I)%      8   vendor/symfony/dependency-injection/Dumper/Preloader.php  տh  v{      8   vendor/symfony/dependency-injection/Dumper/XmlDumper.phpH  տhH  ]߸      >   vendor/symfony/dependency-injection/Dumper/DumperInterface.phpV  տhV  s#      5   vendor/symfony/dependency-injection/Dumper/Dumper.php  տh  U;a      8   vendor/symfony/dependency-injection/Dumper/PhpDumper.phpP տhP /ܤ      1   vendor/symfony/dependency-injection/composer.json  տh  X~      =   vendor/symfony/dependency-injection/EnvVarLoaderInterface.php  տh  bkr      ?   vendor/symfony/dependency-injection/ContainerAwareInterface.php  տh  =>         vendor/symfony/clock/LICENSE,  տh,  t=      1   vendor/symfony/clock/Test/ClockSensitiveTrait.php  տh  I      !   vendor/symfony/clock/CHANGELOG.md  տh  CJ      &   vendor/symfony/clock/Resources/now.php  տh  5䏤      (   vendor/symfony/clock/ClockAwareTrait.php  տh  3         vendor/symfony/clock/README.md  տh  I      "   vendor/symfony/clock/MockClock.php  տh  $i         vendor/symfony/clock/Clock.phpS	  տhS	  *R'      '   vendor/symfony/clock/MonotonicClock.php
  տh
  }Z      '   vendor/symfony/clock/ClockInterface.phpL  տhL  z֚&      "   vendor/symfony/clock/DatePoint.php  տh  Ф      "   vendor/symfony/clock/composer.json  տh  GPҤ      $   vendor/symfony/clock/NativeClock.php/  տh/  ur+      :   vendor/symfony/password-hasher/PasswordHasherInterface.php  տh  -<      >   vendor/symfony/password-hasher/Hasher/SodiumPasswordHasher.php  տh  ^~      B   vendor/symfony/password-hasher/Hasher/CheckPasswordLengthTrait.php  տh  B+.      <   vendor/symfony/password-hasher/Hasher/UserPasswordHasher.phpK  տhK  r,Ф      >   vendor/symfony/password-hasher/Hasher/Pbkdf2PasswordHasher.php  տh  S8      F   vendor/symfony/password-hasher/Hasher/PasswordHasherAwareInterface.php  տh  ϡ*      >   vendor/symfony/password-hasher/Hasher/NativePasswordHasher.php  տh  Q      E   vendor/symfony/password-hasher/Hasher/MessageDigestPasswordHasher.php 
  տh 
  r6k      E   vendor/symfony/password-hasher/Hasher/UserPasswordHasherInterface.phpr  տhr  4Τ      A   vendor/symfony/password-hasher/Hasher/PlaintextPasswordHasher.php[	  տh[	        H   vendor/symfony/password-hasher/Hasher/PasswordHasherFactoryInterface.php  տh  @      A   vendor/symfony/password-hasher/Hasher/MigratingPasswordHasher.php  տh  rG      ?   vendor/symfony/password-hasher/Hasher/PasswordHasherFactory.php&!  տh&!  FA      &   vendor/symfony/password-hasher/LICENSE,  տh,  U      +   vendor/symfony/password-hasher/CHANGELOG.md   տh   ڰ      @   vendor/symfony/password-hasher/LegacyPasswordHasherInterface.php  տh  t      (   vendor/symfony/password-hasher/README.md  տh  !      B   vendor/symfony/password-hasher/Command/UserPasswordHashCommand.php'  տh'  8      ;   vendor/symfony/password-hasher/Exception/LogicException.php  տh  A      ?   vendor/symfony/password-hasher/Exception/ExceptionInterface.php  տh  EWL      E   vendor/symfony/password-hasher/Exception/InvalidPasswordException.php  տh  L      ,   vendor/symfony/password-hasher/composer.json  տh           vendor/symfony/process/LICENSE,  տh,  U      +   vendor/symfony/process/ExecutableFinder.php
  տh
  wt      #   vendor/symfony/process/CHANGELOG.md  տh   %8          vendor/symfony/process/README.md  տh  \3$Ϥ      *   vendor/symfony/process/Pipes/UnixPipes.php  տh  6      -   vendor/symfony/process/Pipes/WindowsPipes.php  տh  Q      .   vendor/symfony/process/Pipes/AbstractPipes.php  տh  e      /   vendor/symfony/process/Pipes/PipesInterface.php  տh        &   vendor/symfony/process/InputStream.php	  տh	  6ee      6   vendor/symfony/process/Messenger/RunProcessContext.php|  տh|  ɔ      6   vendor/symfony/process/Messenger/RunProcessMessage.php  տh  2$      =   vendor/symfony/process/Messenger/RunProcessMessageHandler.php%  տh%  0      %   vendor/symfony/process/PhpProcess.php	  տh	  3x      (   vendor/symfony/process/PhpSubprocess.php  տh  :1      .   vendor/symfony/process/PhpExecutableFinder.php%	  տh%	  ޏx      =   vendor/symfony/process/Exception/ProcessSignaledException.php  տh  -n_      3   vendor/symfony/process/Exception/LogicException.php  տh  iUQ      7   vendor/symfony/process/Exception/ExceptionInterface.php  տh  
j%W      ;   vendor/symfony/process/Exception/ProcessFailedException.phpp  տhp   ۋ      5   vendor/symfony/process/Exception/RuntimeException.php  տh  P      =   vendor/symfony/process/Exception/ProcessTimedOutException.php  տh  8^Q      =   vendor/symfony/process/Exception/InvalidArgumentException.php  տh  ڴ      >   vendor/symfony/process/Exception/RunProcessFailedException.php  տh  ؤ      $   vendor/symfony/process/composer.json  տh  S.t      '   vendor/symfony/process/ProcessUtils.php  տh  a鍤      "   vendor/symfony/process/Process.php  տh  8      =   vendor/symfony/console/DataCollector/CommandDataCollector.php  տh  &      (   vendor/symfony/console/ConsoleEvents.php  տh  .
      !   vendor/symfony/console/Cursor.php  տh  \Fä      &   vendor/symfony/console/Application.php  տh  U"      /   vendor/symfony/console/Logger/ConsoleLogger.phpY  տhY  Ġ      .   vendor/symfony/console/Attribute/AsCommand.phpJ  տhJ  c         vendor/symfony/console/LICENSE,  տh,  U      #   vendor/symfony/console/CHANGELOG.md)  տh)   b_e      9   vendor/symfony/console/Input/StreamableInputInterface.php  տh  3y-      +   vendor/symfony/console/Input/ArrayInput.phpH  տhH  ůx      *   vendor/symfony/console/Input/ArgvInput.php0  տh0  #      .   vendor/symfony/console/Input/InputArgument.php:  տh:  bŮ      4   vendor/symfony/console/Input/InputAwareInterface.phpc  տhc  Q      ,   vendor/symfony/console/Input/InputOption.php!  տh!  <      0   vendor/symfony/console/Input/InputDefinition.phpU.  տhU.  )ͤ      ,   vendor/symfony/console/Input/StringInput.php
  տh
  G      &   vendor/symfony/console/Input/Input.phpl  տhl  ;      /   vendor/symfony/console/Input/InputInterface.php|  տh|  kx'      #   vendor/symfony/console/Terminal.php  տh  `HN      2   vendor/symfony/console/CI/GithubActionReporter.php+  տh+  @      0   vendor/symfony/console/Resources/completion.bash  տh  %}      4   vendor/symfony/console/Resources/bin/hiddeninput.exe $  տh $  v      /   vendor/symfony/console/Resources/completion.zsh  տh  ʤ      0   vendor/symfony/console/Resources/completion.fish  տh  Keդ      5   vendor/symfony/console/Output/TrimmedBufferOutput.phpY  տhY  G>d      8   vendor/symfony/console/Output/ConsoleOutputInterface.php=  տh=  B:      0   vendor/symfony/console/Output/BufferedOutput.phpQ  տhQ  *AS      1   vendor/symfony/console/Output/OutputInterface.php6  տh6  j8q      /   vendor/symfony/console/Output/AnsiColorMode.php
  տh
  oi+      (   vendor/symfony/console/Output/Output.php  տh  \Τ      6   vendor/symfony/console/Output/ConsoleSectionOutput.php9!  տh9!         /   vendor/symfony/console/Output/ConsoleOutput.php  տh  :*      ,   vendor/symfony/console/Output/NullOutput.phpO  տhO  p       .   vendor/symfony/console/Output/StreamOutput.php  տh  +%ؤ      A   vendor/symfony/console/Completion/Output/FishCompletionOutput.php  տh  `      A   vendor/symfony/console/Completion/Output/BashCompletionOutput.php	  տh	  Q2      F   vendor/symfony/console/Completion/Output/CompletionOutputInterface.php  տh  :]      @   vendor/symfony/console/Completion/Output/ZshCompletionOutput.php1  տh1        0   vendor/symfony/console/Completion/Suggestion.php7  տh7  /)	Ϥ      ;   vendor/symfony/console/Completion/CompletionSuggestions.php^  տh^  lx      5   vendor/symfony/console/Completion/CompletionInput.php   տh   jfO      ,   vendor/symfony/console/Style/OutputStyle.php  տh  Vy      -   vendor/symfony/console/Style/SymfonyStyle.php;  տh;  
&ˤ      /   vendor/symfony/console/Style/StyleInterface.php
  տh
  .      2   vendor/symfony/console/Question/ChoiceQuestion.php1  տh1  JY      ,   vendor/symfony/console/Question/Question.php>  տh>  upq      8   vendor/symfony/console/Question/ConfirmationQuestion.php,  տh,  %          vendor/symfony/console/README.md  տh  Æf      9   vendor/symfony/console/Formatter/OutputFormatterStyle.php  տh  yM      B   vendor/symfony/console/Formatter/OutputFormatterStyleInterface.php  տh  ǡ      =   vendor/symfony/console/Formatter/NullOutputFormatterStyle.phpl  տhl        =   vendor/symfony/console/Formatter/OutputFormatterInterface.php"  տh"  7V6_      4   vendor/symfony/console/Formatter/OutputFormatter.php"  տh"  -"Ụ      8   vendor/symfony/console/Formatter/NullOutputFormatter.php  տh  B[      F   vendor/symfony/console/Formatter/WrappableOutputFormatterInterface.php  տh  *
      >   vendor/symfony/console/Formatter/OutputFormatterStyleStack.php?
  տh?
  :;      6   vendor/symfony/console/Messenger/RunCommandMessage.php  տh  
M      6   vendor/symfony/console/Messenger/RunCommandContext.php  տh  !B      =   vendor/symfony/console/Messenger/RunCommandMessageHandler.php  տh  F          vendor/symfony/console/Color.php(  տh(  -      8   vendor/symfony/console/SignalRegistry/SignalRegistry.php  տh  G,eͤ      3   vendor/symfony/console/SignalRegistry/SignalMap.php  տh  N+QѤ      3   vendor/symfony/console/SingleCommandApplication.php>  տh>  OA      ?   vendor/symfony/console/CommandLoader/CommandLoaderInterface.phpV  տhV  X2      ?   vendor/symfony/console/CommandLoader/ContainerCommandLoader.php  տh  ƒ      =   vendor/symfony/console/CommandLoader/FactoryCommandLoader.phpK  տhK  <      4   vendor/symfony/console/Descriptor/TextDescriptor.php0  տh0  f      <   vendor/symfony/console/Descriptor/ApplicationDescription.php(  տh(  #1      3   vendor/symfony/console/Descriptor/XmlDescriptor.php&  տh&  ,Eb      9   vendor/symfony/console/Descriptor/DescriptorInterface.phpm  տhm  B      0   vendor/symfony/console/Descriptor/Descriptor.php
  տh
  j      @   vendor/symfony/console/Descriptor/ReStructuredTextDescriptor.php')  տh')  Ǿ4      4   vendor/symfony/console/Descriptor/JsonDescriptor.php]  տh]  r"z      8   vendor/symfony/console/Descriptor/MarkdownDescriptor.php  տh  4Qj      /   vendor/symfony/console/Tester/CommandTester.phpL	  տhL	  5Ykؤ      -   vendor/symfony/console/Tester/TesterTrait.phpr  տhr  Ƥ      3   vendor/symfony/console/Tester/ApplicationTester.php
  տh
  Z3      9   vendor/symfony/console/Tester/CommandCompletionTester.phpD  տhD  T      @   vendor/symfony/console/Tester/Constraint/CommandIsSuccessful.php+  տh+  1      3   vendor/symfony/console/Command/TraceableCommand.phpe(  տhe(  -2`      .   vendor/symfony/console/Command/LazyCommand.php  տh  oͤ      0   vendor/symfony/console/Command/LockableTrait.php3  տh3        .   vendor/symfony/console/Command/HelpCommand.php	  տh	  6_3      2   vendor/symfony/console/Command/CompleteCommand.php#  տh#  sJ!      .   vendor/symfony/console/Command/ListCommand.php	  տh	  e\{      8   vendor/symfony/console/Command/DumpCompletionCommand.php  տh  +CQ      =   vendor/symfony/console/Command/SignalableCommandInterface.phpE  տhE  bO      *   vendor/symfony/console/Command/Command.php!Z  տh!Z  a 啤      ,   vendor/symfony/console/Helper/TableStyle.php!1  տh!1  'p,      +   vendor/symfony/console/Helper/TableRows.php[  տh[  {m֤      7   vendor/symfony/console/Helper/SymfonyQuestionHelper.php)
  տh)
  7N      1   vendor/symfony/console/Helper/HelperInterface.phpV  տhV  ̊      +   vendor/symfony/console/Helper/TableCell.php  տh  e9S      /   vendor/symfony/console/Helper/ProcessHelper.php  տh  e      0   vendor/symfony/console/Helper/TableSeparator.php!  տh!  n2      /   vendor/symfony/console/Helper/OutputWrapper.php  տh  lؤ      1   vendor/symfony/console/Helper/FormatterHelper.php  տh  0ɤ      0   vendor/symfony/console/Helper/TableCellStyle.php)  տh)  KӘ      -   vendor/symfony/console/Helper/ProgressBar.phpKN  տhKN  F@{      6   vendor/symfony/console/Helper/DebugFormatterHelper.php

  տh

  &      +   vendor/symfony/console/Helper/HelperSet.phpc  տhc  V.      (   vendor/symfony/console/Helper/Dumper.phpz  տhz  `      2   vendor/symfony/console/Helper/InputAwareHelper.php  տh  pc      0   vendor/symfony/console/Helper/QuestionHelper.phpXL  տhXL  ʱbܤ      (   vendor/symfony/console/Helper/Helper.phpl  տhl  5      '   vendor/symfony/console/Helper/Table.php  տh  C2Ӷ      3   vendor/symfony/console/Helper/ProgressIndicator.php  տh  bN&      2   vendor/symfony/console/Helper/DescriptorHelper.phpd
  տhd
        D   vendor/symfony/console/DependencyInjection/AddConsoleCommandPass.php  տh  4      3   vendor/symfony/console/Exception/LogicException.php  տh  5      ;   vendor/symfony/console/Exception/InvalidOptionException.php  տh  %:      >   vendor/symfony/console/Exception/RunCommandFailedException.php>  տh>  ~      7   vendor/symfony/console/Exception/ExceptionInterface.php  տh  oOȤ      5   vendor/symfony/console/Exception/RuntimeException.php  տh        ?   vendor/symfony/console/Exception/NamespaceNotFoundException.php  տh  xD      =   vendor/symfony/console/Exception/InvalidArgumentException.php  տh  x
Τ      :   vendor/symfony/console/Exception/MissingInputException.php  տh  L      =   vendor/symfony/console/Exception/CommandNotFoundException.php  տh  ͆Ť      6   vendor/symfony/console/Event/ConsoleTerminateEvent.php  տh  [5Ť      2   vendor/symfony/console/Event/ConsoleErrorEvent.php  տh  z      4   vendor/symfony/console/Event/ConsoleCommandEvent.php>  տh>  y      -   vendor/symfony/console/Event/ConsoleEvent.php  տh  8(M      3   vendor/symfony/console/Event/ConsoleSignalEvent.php  տh  =|Ѯ      $   vendor/symfony/console/composer.jsonH  տhH  +      +   vendor/symfony/console/Debug/CliRequest.phpq  տhq  ekX      6   vendor/symfony/console/EventListener/ErrorListener.php  տh  h
      0   vendor/symfony/polyfill-mbstring/bootstrap80.php'  տh'  	~
      (   vendor/symfony/polyfill-mbstring/LICENSE,  տh,  H      B   vendor/symfony/polyfill-mbstring/Resources/unidata/caseFolding.php  տh  ]SC      @   vendor/symfony/polyfill-mbstring/Resources/unidata/lowerCase.phpU  տhU  D׎      F   vendor/symfony/polyfill-mbstring/Resources/unidata/titleCaseRegexp.php  տh  oቤ      @   vendor/symfony/polyfill-mbstring/Resources/unidata/upperCase.phpO[  տhO[  (      -   vendor/symfony/polyfill-mbstring/Mbstring.php  տh        .   vendor/symfony/polyfill-mbstring/bootstrap.php!  տh!  d      *   vendor/symfony/polyfill-mbstring/README.mdr  տhr  A`      .   vendor/symfony/polyfill-mbstring/composer.jsonR  տhR  `P
      5   vendor/symfony/polyfill-intl-grapheme/bootstrap80.phpR  տhR  i`      -   vendor/symfony/polyfill-intl-grapheme/LICENSE,  տh,  H      2   vendor/symfony/polyfill-intl-grapheme/Grapheme.phpt)  տht)  Qm      3   vendor/symfony/polyfill-intl-grapheme/bootstrap.phpY	  տhY	  IH1      /   vendor/symfony/polyfill-intl-grapheme/README.md  տh  6      3   vendor/symfony/polyfill-intl-grapheme/composer.json   տh   +          vendor/ramsey/collection/LICENSE7  տh7  ŸԤ      "   vendor/ramsey/collection/README.md  տh  3 Ӥ      &   vendor/ramsey/collection/composer.json|  տh|   v֤      $   vendor/ramsey/collection/SECURITY.md  տh        1   vendor/ramsey/collection/src/DoubleEndedQueue.php  տh  e      ,   vendor/ramsey/collection/src/AbstractSet.php  տh  <!      /   vendor/ramsey/collection/src/QueueInterface.php  տh  *      3   vendor/ramsey/collection/src/AbstractCollection.phpa+  տha+  d?      .   vendor/ramsey/collection/src/AbstractArray.php  տh  z P      &   vendor/ramsey/collection/src/Queue.php3  տh3  D      $   vendor/ramsey/collection/src/Set.php0  տh0  H      :   vendor/ramsey/collection/src/DoubleEndedQueueInterface.php(  տh(  6'&      6   vendor/ramsey/collection/src/Map/TypedMapInterface.php2  տh2  z      5   vendor/ramsey/collection/src/Map/AbstractTypedMap.phpc  տhc  cͤ      1   vendor/ramsey/collection/src/Map/MapInterface.php  տh  OA      -   vendor/ramsey/collection/src/Map/TypedMap.php
  տh
  >)      8   vendor/ramsey/collection/src/Map/AssociativeArrayMap.php0  տh0  PǤ      6   vendor/ramsey/collection/src/Map/NamedParameterMap.php   տh   `@Q      0   vendor/ramsey/collection/src/Map/AbstractMap.php  տh  I?      -   vendor/ramsey/collection/src/GenericArray.php  տh        /   vendor/ramsey/collection/src/ArrayInterface.php'  տh'  5a      %   vendor/ramsey/collection/src/Sort.php{  տh{  Ȥ      +   vendor/ramsey/collection/src/Collection.php	  տh	  0       4   vendor/ramsey/collection/src/CollectionInterface.php$  տh$  űʤ      H   vendor/ramsey/collection/src/Exception/UnsupportedOperationException.phpL  տhL  ff      ?   vendor/ramsey/collection/src/Exception/OutOfBoundsException.phpw  տhw        >   vendor/ramsey/collection/src/Exception/CollectionException.php  տh  Ĵ@      C   vendor/ramsey/collection/src/Exception/InvalidArgumentException.phps  տhs  ڤ      A   vendor/ramsey/collection/src/Exception/NoSuchElementException.phpD  տhD  	Ln      B   vendor/ramsey/collection/src/Exception/InvalidPropertyOrMethod.php  տh        F   vendor/ramsey/collection/src/Exception/CollectionMismatchException.phpM  տhM  \ć      8   vendor/ramsey/collection/src/Tool/ValueToStringTrait.php	  տh	  ;5      /   vendor/ramsey/collection/src/Tool/TypeTrait.phpD  տhD  e      9   vendor/ramsey/collection/src/Tool/ValueExtractorTrait.php  տh  q          vendor/ramsey/uuid/LICENSE7  տh7  <[         vendor/ramsey/uuid/README.md.  տh.            vendor/ramsey/uuid/composer.json  տh        $   vendor/ramsey/uuid/src/functions.php  տh  /      5   vendor/ramsey/uuid/src/Validator/GenericValidator.php)  տh)  ر      7   vendor/ramsey/uuid/src/Validator/ValidatorInterface.php  տh  L      >   vendor/ramsey/uuid/src/Converter/Time/GenericTimeConverter.php  տh  }      ;   vendor/ramsey/uuid/src/Converter/Time/UnixTimeConverter.php!
  տh!
  u:      :   vendor/ramsey/uuid/src/Converter/Time/PhpTimeConverter.phpN  տhN        ?   vendor/ramsey/uuid/src/Converter/Time/DegradedTimeConverter.phpv  տhv  
פ      @   vendor/ramsey/uuid/src/Converter/Time/BigNumberTimeConverter.phpu  տhu  Ϫ24      C   vendor/ramsey/uuid/src/Converter/Number/DegradedNumberConverter.php}  տh}  Y{      >   vendor/ramsey/uuid/src/Converter/Number/BigNumberConverter.php  տh  @      B   vendor/ramsey/uuid/src/Converter/Number/GenericNumberConverter.php  տh  6Q      ;   vendor/ramsey/uuid/src/Converter/TimeConverterInterface.php  տh  )      =   vendor/ramsey/uuid/src/Converter/NumberConverterInterface.php  տh  uVt       5   vendor/ramsey/uuid/src/DeprecatedUuidMethodsTrait.php3  տh3  h      8   vendor/ramsey/uuid/src/Codec/TimestampFirstCombCodec.php  տh  s3٩      1   vendor/ramsey/uuid/src/Codec/OrderedTimeCodec.php
  տh
  
M      /   vendor/ramsey/uuid/src/Codec/CodecInterface.php  տh  D8ڤ      0   vendor/ramsey/uuid/src/Codec/GuidStringCodec.php  տh  ܤ      ,   vendor/ramsey/uuid/src/Codec/StringCodec.php5  տh5        7   vendor/ramsey/uuid/src/Codec/TimestampLastCombCodec.php  տh  e8         vendor/ramsey/uuid/src/Uuid.php^  տh^  n$Ϥ      @   vendor/ramsey/uuid/src/Provider/DceSecurityProviderInterface.php  տh  jf      A   vendor/ramsey/uuid/src/Provider/Dce/SystemDceSecurityProvider.php0  տh0  M_=      9   vendor/ramsey/uuid/src/Provider/NodeProviderInterface.php  տh  	"      ;   vendor/ramsey/uuid/src/Provider/Time/SystemTimeProvider.php   տh   a      :   vendor/ramsey/uuid/src/Provider/Time/FixedTimeProvider.php  տh  eˤ      9   vendor/ramsey/uuid/src/Provider/TimeProviderInterface.phpS  տhS  m+      ;   vendor/ramsey/uuid/src/Provider/Node/RandomNodeProvider.phpo  տho  L_      =   vendor/ramsey/uuid/src/Provider/Node/FallbackNodeProvider.phpw  տhw        ;   vendor/ramsey/uuid/src/Provider/Node/SystemNodeProvider.php  տh  r犤      ?   vendor/ramsey/uuid/src/Provider/Node/NodeProviderCollection.phpE  տhE  7      ;   vendor/ramsey/uuid/src/Provider/Node/StaticNodeProvider.php4  տh4  ]q      %   vendor/ramsey/uuid/src/FeatureSet.php2  տh2  rI|Ф      2   vendor/ramsey/uuid/src/Rfc4122/FieldsInterface.php   տh   w      )   vendor/ramsey/uuid/src/Rfc4122/UuidV8.php	  տh	  RE      ,   vendor/ramsey/uuid/src/Rfc4122/Validator.php[  տh[  -=      +   vendor/ramsey/uuid/src/Rfc4122/MaxTrait.phpW  տhW  r`      /   vendor/ramsey/uuid/src/Rfc4122/VersionTrait.php  տh  O;      +   vendor/ramsey/uuid/src/Rfc4122/NilTrait.phpC  տhC  `ܤ      )   vendor/ramsey/uuid/src/Rfc4122/Fields.php  տh  ;      *   vendor/ramsey/uuid/src/Rfc4122/NilUuid.php  տh        *   vendor/ramsey/uuid/src/Rfc4122/MaxUuid.php  տh  oޤ      0   vendor/ramsey/uuid/src/Rfc4122/UuidInterface.php  տh  :J}      ,   vendor/ramsey/uuid/src/Rfc4122/TimeTrait.phpA  տhA  P*      /   vendor/ramsey/uuid/src/Rfc4122/VariantTrait.php!  տh!        .   vendor/ramsey/uuid/src/Rfc4122/UuidBuilder.phpy  տhy  MSZ      )   vendor/ramsey/uuid/src/Rfc4122/UuidV1.php  տh  )]ߤ      )   vendor/ramsey/uuid/src/Rfc4122/UuidV3.php>  տh>  H<      )   vendor/ramsey/uuid/src/Rfc4122/UuidV2.php  տh  O      )   vendor/ramsey/uuid/src/Rfc4122/UuidV6.php  տh  e`      )   vendor/ramsey/uuid/src/Rfc4122/UuidV7.php  տh  gE      )   vendor/ramsey/uuid/src/Rfc4122/UuidV5.phpC  տhC  X      )   vendor/ramsey/uuid/src/Rfc4122/UuidV4.php  տh        (   vendor/ramsey/uuid/src/UuidInterface.php  տh  s      ,   vendor/ramsey/uuid/src/Math/RoundingMode.php1  տh1  {k3      3   vendor/ramsey/uuid/src/Math/CalculatorInterface.php"  տh"  "      3   vendor/ramsey/uuid/src/Math/BrickMathCalculator.php?  տh?  Cm)      /   vendor/ramsey/uuid/src/UuidFactoryInterface.php  տh  {      9   vendor/ramsey/uuid/src/Generator/RandomBytesGenerator.phpU  տhU  7      9   vendor/ramsey/uuid/src/Generator/NameGeneratorFactory.php  տh  zݤ      6   vendor/ramsey/uuid/src/Generator/UnixTimeGenerator.php  տh  D      ;   vendor/ramsey/uuid/src/Generator/NameGeneratorInterface.php:  տh:  Hf      ;   vendor/ramsey/uuid/src/Generator/RandomGeneratorFactory.php  տh  ,q      9   vendor/ramsey/uuid/src/Generator/DceSecurityGenerator.php  տh  P~f      B   vendor/ramsey/uuid/src/Generator/DceSecurityGeneratorInterface.php  տh  8      9   vendor/ramsey/uuid/src/Generator/TimeGeneratorFactory.phpx  տhx  76i      9   vendor/ramsey/uuid/src/Generator/DefaultNameGenerator.phpU  տhU  x-      9   vendor/ramsey/uuid/src/Generator/DefaultTimeGenerator.php  տh  YO      5   vendor/ramsey/uuid/src/Generator/RandomLibAdapter.php7  տh7  ю      ;   vendor/ramsey/uuid/src/Generator/TimeGeneratorInterface.php  տh  CkO      2   vendor/ramsey/uuid/src/Generator/CombGenerator.phpZ
  տhZ
        =   vendor/ramsey/uuid/src/Generator/RandomGeneratorInterface.php  տh  Il      <   vendor/ramsey/uuid/src/Generator/PeclUuidRandomGenerator.php<  տh<  18      :   vendor/ramsey/uuid/src/Generator/PeclUuidNameGenerator.php  տh  f      :   vendor/ramsey/uuid/src/Generator/PeclUuidTimeGenerator.php{  տh{  Ҥ      &   vendor/ramsey/uuid/src/BinaryUtils.php%  տh%  rT      &   vendor/ramsey/uuid/src/UuidFactory.phpl<  տhl<        '   vendor/ramsey/uuid/src/Type/Integer.php7  տh7  RM      $   vendor/ramsey/uuid/src/Type/Time.php&
  տh&
        +   vendor/ramsey/uuid/src/Type/Hexadecimal.php  տh  _}^      /   vendor/ramsey/uuid/src/Type/NumberInterface.php  տh  B1      -   vendor/ramsey/uuid/src/Type/TypeInterface.php  տh  |3:A      '   vendor/ramsey/uuid/src/Type/Decimal.php  տh        $   vendor/ramsey/uuid/src/Guid/Guid.php		  տh		  M      &   vendor/ramsey/uuid/src/Guid/Fields.php   տh   8mF      +   vendor/ramsey/uuid/src/Guid/GuidBuilder.phpM	  տhM	  awߤ      2   vendor/ramsey/uuid/src/Lazy/LazyUuidFromString.php5  տh5  ȚS      '   vendor/ramsey/uuid/src/DegradedUuid.php[  տh[  ?^      1   vendor/ramsey/uuid/src/Fields/FieldsInterface.php  տh  5l      9   vendor/ramsey/uuid/src/Fields/SerializableFieldsTrait.phpz  տhz  P	      2   vendor/ramsey/uuid/src/DeprecatedUuidInterface.php  տh  >      6   vendor/ramsey/uuid/src/Builder/DegradedUuidBuilder.phph  տhh  :2ͤ      7   vendor/ramsey/uuid/src/Builder/UuidBuilderInterface.php$  տh$  !      4   vendor/ramsey/uuid/src/Builder/BuilderCollection.php	  տh	  =      2   vendor/ramsey/uuid/src/Builder/FallbackBuilder.phpo  տho  D+.      5   vendor/ramsey/uuid/src/Builder/DefaultUuidBuilder.phpU  տhU  "      :   vendor/ramsey/uuid/src/Exception/RandomSourceException.php  տh        2   vendor/ramsey/uuid/src/Exception/NodeException.php`  տh`  ]      6   vendor/ramsey/uuid/src/Exception/DateTimeException.phpa  տha  \      8   vendor/ramsey/uuid/src/Exception/TimeSourceException.phpQ  տhQ        B   vendor/ramsey/uuid/src/Exception/UnsupportedOperationException.phpV  տhV  JN      :   vendor/ramsey/uuid/src/Exception/InvalidBytesException.php_  տh_  /٤      9   vendor/ramsey/uuid/src/Exception/DceSecurityException.phpm  տhm  IC      2   vendor/ramsey/uuid/src/Exception/NameException.phpc  տhc  sOS      =   vendor/ramsey/uuid/src/Exception/InvalidArgumentException.phpi  տhi  v'ä      =   vendor/ramsey/uuid/src/Exception/BuilderNotFoundException.phpQ  տhQ  @c      ?   vendor/ramsey/uuid/src/Exception/UnableToBuildUuidException.phpO  տhO  Ro      ;   vendor/ramsey/uuid/src/Exception/UuidExceptionInterface.php  տh  K;Ҥ      ?   vendor/ramsey/uuid/src/Exception/InvalidUuidStringException.php  տh  <1i      -   vendor/ramsey/uuid/src/Nonstandard/Fields.php2
  տh2
        +   vendor/ramsey/uuid/src/Nonstandard/Uuid.php  տh        2   vendor/ramsey/uuid/src/Nonstandard/UuidBuilder.phpv	  տhv	         -   vendor/ramsey/uuid/src/Nonstandard/UuidV6.php
  տh
  !b         vendor/webmozart/assert/LICENSE<  տh<  t}      $   vendor/webmozart/assert/CHANGELOG.md  տh        !   vendor/webmozart/assert/README.md>  տh>  |Ϥ      %   vendor/webmozart/assert/composer.json  տh  3p      %   vendor/webmozart/assert/src/Mixin.php5 տh5 9(      8   vendor/webmozart/assert/src/InvalidArgumentException.phpi  տhi  {Lä      &   vendor/webmozart/assert/src/Assert.php  տh  =         vendor/react/promise/LICENSEg  տhg  F      !   vendor/react/promise/CHANGELOG.md9  տh9  OT:         vendor/react/promise/README.mdQY  տhQY  1      "   vendor/react/promise/composer.json  տh  T?      -   vendor/react/promise/src/PromiseInterface.php  տh  MFx8      &   vendor/react/promise/src/functions.php1-  տh1-  t      .   vendor/react/promise/src/functions_include.php   տh   dx\      $   vendor/react/promise/src/Promise.php(  տh(  XF<      %   vendor/react/promise/src/Deferred.php0  տh0        5   vendor/react/promise/src/Internal/RejectedPromise.php
  տh
  |      6   vendor/react/promise/src/Internal/FulfilledPromise.phpT	  տhT	  ϊK      7   vendor/react/promise/src/Internal/CancellationQueue.php  տh  r2      6   vendor/react/promise/src/Exception/LengthException.php^   տh^   ?q      9   vendor/react/promise/src/Exception/CompositeException.phpa  տha  '         vendor/sebastian/diff/LICENSE  տh  ܡ7      "   vendor/sebastian/diff/ChangeLog.md  տh  A         vendor/sebastian/diff/README.mdx   տhx   Z      #   vendor/sebastian/diff/composer.json  տh  H      !   vendor/sebastian/diff/SECURITY.mdu  տhu  KJ      "   vendor/sebastian/diff/src/Diff.php^  տh^  D1Ѥ      $   vendor/sebastian/diff/src/Parser.php  տh  թ      M   vendor/sebastian/diff/src/TimeEfficientLongestCommonSubsequenceCalculator.php5	  տh5	  0OԤ      :   vendor/sebastian/diff/src/Output/DiffOnlyOutputBuilder.php  տh        ?   vendor/sebastian/diff/src/Output/DiffOutputBuilderInterface.php  տh        =   vendor/sebastian/diff/src/Output/UnifiedDiffOutputBuilder.php  տh        C   vendor/sebastian/diff/src/Output/StrictUnifiedDiffOutputBuilder.phpm(  տhm(  ˌ      ?   vendor/sebastian/diff/src/Output/AbstractChunkOutputBuilder.php  տh  J5|      @   vendor/sebastian/diff/src/LongestCommonSubsequenceCalculator.php  տh  !J9      #   vendor/sebastian/diff/src/Chunk.php	  տh	  8      $   vendor/sebastian/diff/src/Differ.php  տh  ԕL      "   vendor/sebastian/diff/src/Line.php  տh  >      >   vendor/sebastian/diff/src/Exception/ConfigurationException.php)  տh)  2ܤ      @   vendor/sebastian/diff/src/Exception/InvalidArgumentException.php  տh  +U/ܤ      1   vendor/sebastian/diff/src/Exception/Exception.phpq  տhq  Z      O   vendor/sebastian/diff/src/MemoryEfficientLongestCommonSubsequenceCalculator.php+
  տh+
  ٤      3   vendor/terminal42/composer-lock-validator/README.md#
  տh#
  QG      7   vendor/terminal42/composer-lock-validator/composer.json#  տh#  B      ;   vendor/terminal42/composer-lock-validator/src/Validator.php$  տh$  sҤ      E   vendor/terminal42/composer-lock-validator/src/ValidationException.php1  տh1  V      <?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

require __DIR__ . '/../vendor/autoload.php';
if (\false === \in_array(\PHP_SAPI, array('cli', 'phpdbg', 'embed'), \true)) {
    echo \PHP_EOL . 'The application may only be invoked from a command line, got "' . \PHP_SAPI . '"' . \PHP_EOL;
    exit(1);
}
if ((\false === isset($_SERVER['BOX_REQUIREMENT_CHECKER']) || \true === (bool) $_SERVER['BOX_REQUIREMENT_CHECKER']) && \false === Checker::checkRequirements()) {
    exit(1);
}
<?php

return array (
  0 => 
  array (
    'type' => 'php',
    'condition' => '^8.1',
    'message' => 'The application requires the version "^8.1" or greater.',
    'helpMessage' => 'The application requires the version "^8.1" or greater.',
  ),
  1 => 
  array (
    'type' => 'extension',
    'condition' => 'json',
    'message' => 'The application requires the extension "json". Enable it or install a polyfill.',
    'helpMessage' => 'The application requires the extension "json".',
  ),
  2 => 
  array (
    'type' => 'extension',
    'condition' => 'json',
    'message' => 'The package "web-auth/cose-lib" requires the extension "json". Enable it or install a polyfill.',
    'helpMessage' => 'The package "web-auth/cose-lib" requires the extension "json".',
  ),
  3 => 
  array (
    'type' => 'extension',
    'condition' => 'json',
    'message' => 'The package "web-auth/webauthn-lib" requires the extension "json". Enable it or install a polyfill.',
    'helpMessage' => 'The package "web-auth/webauthn-lib" requires the extension "json".',
  ),
  4 => 
  array (
    'type' => 'extension',
    'condition' => 'session',
    'message' => 'The application requires the extension "session". Enable it or install a polyfill.',
    'helpMessage' => 'The application requires the extension "session".',
  ),
  5 => 
  array (
    'type' => 'extension',
    'condition' => 'zip',
    'message' => 'The application requires the extension "zip". Enable it or install a polyfill.',
    'helpMessage' => 'The application requires the extension "zip".',
  ),
  6 => 
  array (
    'type' => 'extension',
    'condition' => 'openssl',
    'message' => 'The package "composer/ca-bundle" requires the extension "openssl". Enable it or install a polyfill.',
    'helpMessage' => 'The package "composer/ca-bundle" requires the extension "openssl".',
  ),
  7 => 
  array (
    'type' => 'extension',
    'condition' => 'openssl',
    'message' => 'The package "web-auth/cose-lib" requires the extension "openssl". Enable it or install a polyfill.',
    'helpMessage' => 'The package "web-auth/cose-lib" requires the extension "openssl".',
  ),
  8 => 
  array (
    'type' => 'extension',
    'condition' => 'openssl',
    'message' => 'The package "web-auth/webauthn-lib" requires the extension "openssl". Enable it or install a polyfill.',
    'helpMessage' => 'The package "web-auth/webauthn-lib" requires the extension "openssl".',
  ),
  9 => 
  array (
    'type' => 'extension',
    'condition' => 'pcre',
    'message' => 'The package "composer/ca-bundle" requires the extension "pcre". Enable it or install a polyfill.',
    'helpMessage' => 'The package "composer/ca-bundle" requires the extension "pcre".',
  ),
  10 => 
  array (
    'type' => 'extension',
    'condition' => 'filter',
    'message' => 'The package "phpdocumentor/reflection-docblock" requires the extension "filter". Enable it or install a polyfill.',
    'helpMessage' => 'The package "phpdocumentor/reflection-docblock" requires the extension "filter".',
  ),
  11 => 
  array (
    'type' => 'extension',
    'condition' => 'xml',
    'message' => 'The package "symfony/framework-bundle" requires the extension "xml". Enable it or install a polyfill.',
    'helpMessage' => 'The package "symfony/framework-bundle" requires the extension "xml".',
  ),
  12 => 
  array (
    'type' => 'extension',
    'condition' => 'xml',
    'message' => 'The package "symfony/security-bundle" requires the extension "xml". Enable it or install a polyfill.',
    'helpMessage' => 'The package "symfony/security-bundle" requires the extension "xml".',
  ),
  13 => 
  array (
    'type' => 'extension',
    'condition' => 'iconv',
    'message' => 'The package "symfony/polyfill-mbstring" requires the extension "iconv". Enable it or install a polyfill.',
    'helpMessage' => 'The package "symfony/polyfill-mbstring" requires the extension "iconv".',
  ),
);<?php

// autoload.php @generated by Composer

require_once __DIR__ . '/composer/autoload_real.php';

return ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893::getLoader();
<?php

// autoload_namespaces.php @generated by Composer

$vendorDir = dirname(dirname(__FILE__));
$baseDir = dirname($vendorDir);

return array(
);

Copyright (c) Nils Adermann, Jordi Boggiano

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is furnished
to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

<?php

/*
 * This file is part of Composer.
 *
 * (c) Nils Adermann <naderman@naderman.de>
 *     Jordi Boggiano <j.boggiano@seld.be>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Composer\Autoload;

/**
 * ClassLoader implements a PSR-0, PSR-4 and classmap class loader.
 *
 *     $loader = new \Composer\Autoload\ClassLoader();
 *
 *     // register classes with namespaces
 *     $loader->add('Symfony\Component', __DIR__.'/component');
 *     $loader->add('Symfony',           __DIR__.'/framework');
 *
 *     // activate the autoloader
 *     $loader->register();
 *
 *     // to enable searching the include path (eg. for PEAR packages)
 *     $loader->setUseIncludePath(true);
 *
 * In this example, if you try to use a class in the Symfony\Component
 * namespace or one of its children (Symfony\Component\Console for instance),
 * the autoloader will first look for the class under the component/
 * directory, and it will then fallback to the framework/ directory if not
 * found before giving up.
 *
 * This class is loosely based on the Symfony UniversalClassLoader.
 *
 * @author Fabien Potencier <fabien@symfony.com>
 * @author Jordi Boggiano <j.boggiano@seld.be>
 * @see    https://www.php-fig.org/psr/psr-0/
 * @see    https://www.php-fig.org/psr/psr-4/
 */
class ClassLoader
{
    /** @var ?string */
    private $vendorDir;

    // PSR-4
    /**
     * @var array[]
     * @psalm-var array<string, array<string, int>>
     */
    private $prefixLengthsPsr4 = array();
    /**
     * @var array[]
     * @psalm-var array<string, array<int, string>>
     */
    private $prefixDirsPsr4 = array();
    /**
     * @var array[]
     * @psalm-var array<string, string>
     */
    private $fallbackDirsPsr4 = array();

    // PSR-0
    /**
     * @var array[]
     * @psalm-var array<string, array<string, string[]>>
     */
    private $prefixesPsr0 = array();
    /**
     * @var array[]
     * @psalm-var array<string, string>
     */
    private $fallbackDirsPsr0 = array();

    /** @var bool */
    private $useIncludePath = false;

    /**
     * @var string[]
     * @psalm-var array<string, string>
     */
    private $classMap = array();

    /** @var bool */
    private $classMapAuthoritative = false;

    /**
     * @var bool[]
     * @psalm-var array<string, bool>
     */
    private $missingClasses = array();

    /** @var ?string */
    private $apcuPrefix;

    /**
     * @var self[]
     */
    private static $registeredLoaders = array();

    /**
     * @param ?string $vendorDir
     */
    public function __construct($vendorDir = null)
    {
        $this->vendorDir = $vendorDir;
    }

    /**
     * @return string[]
     */
    public function getPrefixes()
    {
        if (!empty($this->prefixesPsr0)) {
            return call_user_func_array('array_merge', array_values($this->prefixesPsr0));
        }

        return array();
    }

    /**
     * @return array[]
     * @psalm-return array<string, array<int, string>>
     */
    public function getPrefixesPsr4()
    {
        return $this->prefixDirsPsr4;
    }

    /**
     * @return array[]
     * @psalm-return array<string, string>
     */
    public function getFallbackDirs()
    {
        return $this->fallbackDirsPsr0;
    }

    /**
     * @return array[]
     * @psalm-return array<string, string>
     */
    public function getFallbackDirsPsr4()
    {
        return $this->fallbackDirsPsr4;
    }

    /**
     * @return string[] Array of classname => path
     * @psalm-return array<string, string>
     */
    public function getClassMap()
    {
        return $this->classMap;
    }

    /**
     * @param string[] $classMap Class to filename map
     * @psalm-param array<string, string> $classMap
     *
     * @return void
     */
    public function addClassMap(array $classMap)
    {
        if ($this->classMap) {
            $this->classMap = array_merge($this->classMap, $classMap);
        } else {
            $this->classMap = $classMap;
        }
    }

    /**
     * Registers a set of PSR-0 directories for a given prefix, either
     * appending or prepending to the ones previously set for this prefix.
     *
     * @param string          $prefix  The prefix
     * @param string[]|string $paths   The PSR-0 root directories
     * @param bool            $prepend Whether to prepend the directories
     *
     * @return void
     */
    public function add($prefix, $paths, $prepend = false)
    {
        if (!$prefix) {
            if ($prepend) {
                $this->fallbackDirsPsr0 = array_merge(
                    (array) $paths,
                    $this->fallbackDirsPsr0
                );
            } else {
                $this->fallbackDirsPsr0 = array_merge(
                    $this->fallbackDirsPsr0,
                    (array) $paths
                );
            }

            return;
        }

        $first = $prefix[0];
        if (!isset($this->prefixesPsr0[$first][$prefix])) {
            $this->prefixesPsr0[$first][$prefix] = (array) $paths;

            return;
        }
        if ($prepend) {
            $this->prefixesPsr0[$first][$prefix] = array_merge(
                (array) $paths,
                $this->prefixesPsr0[$first][$prefix]
            );
        } else {
            $this->prefixesPsr0[$first][$prefix] = array_merge(
                $this->prefixesPsr0[$first][$prefix],
                (array) $paths
            );
        }
    }

    /**
     * Registers a set of PSR-4 directories for a given namespace, either
     * appending or prepending to the ones previously set for this namespace.
     *
     * @param string          $prefix  The prefix/namespace, with trailing '\\'
     * @param string[]|string $paths   The PSR-4 base directories
     * @param bool            $prepend Whether to prepend the directories
     *
     * @throws \InvalidArgumentException
     *
     * @return void
     */
    public function addPsr4($prefix, $paths, $prepend = false)
    {
        if (!$prefix) {
            // Register directories for the root namespace.
            if ($prepend) {
                $this->fallbackDirsPsr4 = array_merge(
                    (array) $paths,
                    $this->fallbackDirsPsr4
                );
            } else {
                $this->fallbackDirsPsr4 = array_merge(
                    $this->fallbackDirsPsr4,
                    (array) $paths
                );
            }
        } elseif (!isset($this->prefixDirsPsr4[$prefix])) {
            // Register directories for a new namespace.
            $length = strlen($prefix);
            if ('\\' !== $prefix[$length - 1]) {
                throw new \InvalidArgumentException("A non-empty PSR-4 prefix must end with a namespace separator.");
            }
            $this->prefixLengthsPsr4[$prefix[0]][$prefix] = $length;
            $this->prefixDirsPsr4[$prefix] = (array) $paths;
        } elseif ($prepend) {
            // Prepend directories for an already registered namespace.
            $this->prefixDirsPsr4[$prefix] = array_merge(
                (array) $paths,
                $this->prefixDirsPsr4[$prefix]
            );
        } else {
            // Append directories for an already registered namespace.
            $this->prefixDirsPsr4[$prefix] = array_merge(
                $this->prefixDirsPsr4[$prefix],
                (array) $paths
            );
        }
    }

    /**
     * Registers a set of PSR-0 directories for a given prefix,
     * replacing any others previously set for this prefix.
     *
     * @param string          $prefix The prefix
     * @param string[]|string $paths  The PSR-0 base directories
     *
     * @return void
     */
    public function set($prefix, $paths)
    {
        if (!$prefix) {
            $this->fallbackDirsPsr0 = (array) $paths;
        } else {
            $this->prefixesPsr0[$prefix[0]][$prefix] = (array) $paths;
        }
    }

    /**
     * Registers a set of PSR-4 directories for a given namespace,
     * replacing any others previously set for this namespace.
     *
     * @param string          $prefix The prefix/namespace, with trailing '\\'
     * @param string[]|string $paths  The PSR-4 base directories
     *
     * @throws \InvalidArgumentException
     *
     * @return void
     */
    public function setPsr4($prefix, $paths)
    {
        if (!$prefix) {
            $this->fallbackDirsPsr4 = (array) $paths;
        } else {
            $length = strlen($prefix);
            if ('\\' !== $prefix[$length - 1]) {
                throw new \InvalidArgumentException("A non-empty PSR-4 prefix must end with a namespace separator.");
            }
            $this->prefixLengthsPsr4[$prefix[0]][$prefix] = $length;
            $this->prefixDirsPsr4[$prefix] = (array) $paths;
        }
    }

    /**
     * Turns on searching the include path for class files.
     *
     * @param bool $useIncludePath
     *
     * @return void
     */
    public function setUseIncludePath($useIncludePath)
    {
        $this->useIncludePath = $useIncludePath;
    }

    /**
     * Can be used to check if the autoloader uses the include path to check
     * for classes.
     *
     * @return bool
     */
    public function getUseIncludePath()
    {
        return $this->useIncludePath;
    }

    /**
     * Turns off searching the prefix and fallback directories for classes
     * that have not been registered with the class map.
     *
     * @param bool $classMapAuthoritative
     *
     * @return void
     */
    public function setClassMapAuthoritative($classMapAuthoritative)
    {
        $this->classMapAuthoritative = $classMapAuthoritative;
    }

    /**
     * Should class lookup fail if not found in the current class map?
     *
     * @return bool
     */
    public function isClassMapAuthoritative()
    {
        return $this->classMapAuthoritative;
    }

    /**
     * APCu prefix to use to cache found/not-found classes, if the extension is enabled.
     *
     * @param string|null $apcuPrefix
     *
     * @return void
     */
    public function setApcuPrefix($apcuPrefix)
    {
        $this->apcuPrefix = function_exists('apcu_fetch') && filter_var(ini_get('apc.enabled'), FILTER_VALIDATE_BOOLEAN) ? $apcuPrefix : null;
    }

    /**
     * The APCu prefix in use, or null if APCu caching is not enabled.
     *
     * @return string|null
     */
    public function getApcuPrefix()
    {
        return $this->apcuPrefix;
    }

    /**
     * Registers this instance as an autoloader.
     *
     * @param bool $prepend Whether to prepend the autoloader or not
     *
     * @return void
     */
    public function register($prepend = false)
    {
        spl_autoload_register(array($this, 'loadClass'), true, $prepend);

        if (null === $this->vendorDir) {
            return;
        }

        if ($prepend) {
            self::$registeredLoaders = array($this->vendorDir => $this) + self::$registeredLoaders;
        } else {
            unset(self::$registeredLoaders[$this->vendorDir]);
            self::$registeredLoaders[$this->vendorDir] = $this;
        }
    }

    /**
     * Unregisters this instance as an autoloader.
     *
     * @return void
     */
    public function unregister()
    {
        spl_autoload_unregister(array($this, 'loadClass'));

        if (null !== $this->vendorDir) {
            unset(self::$registeredLoaders[$this->vendorDir]);
        }
    }

    /**
     * Loads the given class or interface.
     *
     * @param  string    $class The name of the class
     * @return true|null True if loaded, null otherwise
     */
    public function loadClass($class)
    {
        if ($file = $this->findFile($class)) {
            includeFile($file);

            return true;
        }

        return null;
    }

    /**
     * Finds the path to the file where the class is defined.
     *
     * @param string $class The name of the class
     *
     * @return string|false The path if found, false otherwise
     */
    public function findFile($class)
    {
        // class map lookup
        if (isset($this->classMap[$class])) {
            return $this->classMap[$class];
        }
        if ($this->classMapAuthoritative || isset($this->missingClasses[$class])) {
            return false;
        }
        if (null !== $this->apcuPrefix) {
            $file = apcu_fetch($this->apcuPrefix.$class, $hit);
            if ($hit) {
                return $file;
            }
        }

        $file = $this->findFileWithExtension($class, '.php');

        // Search for Hack files if we are running on HHVM
        if (false === $file && defined('HHVM_VERSION')) {
            $file = $this->findFileWithExtension($class, '.hh');
        }

        if (null !== $this->apcuPrefix) {
            apcu_add($this->apcuPrefix.$class, $file);
        }

        if (false === $file) {
            // Remember that this class does not exist.
            $this->missingClasses[$class] = true;
        }

        return $file;
    }

    /**
     * Returns the currently registered loaders indexed by their corresponding vendor directories.
     *
     * @return self[]
     */
    public static function getRegisteredLoaders()
    {
        return self::$registeredLoaders;
    }

    /**
     * @param  string       $class
     * @param  string       $ext
     * @return string|false
     */
    private function findFileWithExtension($class, $ext)
    {
        // PSR-4 lookup
        $logicalPathPsr4 = strtr($class, '\\', DIRECTORY_SEPARATOR) . $ext;

        $first = $class[0];
        if (isset($this->prefixLengthsPsr4[$first])) {
            $subPath = $class;
            while (false !== $lastPos = strrpos($subPath, '\\')) {
                $subPath = substr($subPath, 0, $lastPos);
                $search = $subPath . '\\';
                if (isset($this->prefixDirsPsr4[$search])) {
                    $pathEnd = DIRECTORY_SEPARATOR . substr($logicalPathPsr4, $lastPos + 1);
                    foreach ($this->prefixDirsPsr4[$search] as $dir) {
                        if (file_exists($file = $dir . $pathEnd)) {
                            return $file;
                        }
                    }
                }
            }
        }

        // PSR-4 fallback dirs
        foreach ($this->fallbackDirsPsr4 as $dir) {
            if (file_exists($file = $dir . DIRECTORY_SEPARATOR . $logicalPathPsr4)) {
                return $file;
            }
        }

        // PSR-0 lookup
        if (false !== $pos = strrpos($class, '\\')) {
            // namespaced class name
            $logicalPathPsr0 = substr($logicalPathPsr4, 0, $pos + 1)
                . strtr(substr($logicalPathPsr4, $pos + 1), '_', DIRECTORY_SEPARATOR);
        } else {
            // PEAR-like class name
            $logicalPathPsr0 = strtr($class, '_', DIRECTORY_SEPARATOR) . $ext;
        }

        if (isset($this->prefixesPsr0[$first])) {
            foreach ($this->prefixesPsr0[$first] as $prefix => $dirs) {
                if (0 === strpos($class, $prefix)) {
                    foreach ($dirs as $dir) {
                        if (file_exists($file = $dir . DIRECTORY_SEPARATOR . $logicalPathPsr0)) {
                            return $file;
                        }
                    }
                }
            }
        }

        // PSR-0 fallback dirs
        foreach ($this->fallbackDirsPsr0 as $dir) {
            if (file_exists($file = $dir . DIRECTORY_SEPARATOR . $logicalPathPsr0)) {
                return $file;
            }
        }

        // PSR-0 include paths.
        if ($this->useIncludePath && $file = stream_resolve_include_path($logicalPathPsr0)) {
            return $file;
        }

        return false;
    }
}

/**
 * Scope isolated include.
 *
 * Prevents access to $this/self from included files.
 *
 * @param  string $file
 * @return void
 * @private
 */
function includeFile($file)
{
    include $file;
}
<?php

// autoload_psr4.php @generated by Composer

$vendorDir = dirname(dirname(__FILE__));
$baseDir = dirname($vendorDir);

return array(
    'HumbugBox3150\\KevinGH\\RequirementChecker\\' => array($baseDir . '/src'),
    'HumbugBox3150\\Composer\\Semver\\' => array($vendorDir . '/composer/semver/src'),
);
<?php

// autoload_classmap.php @generated by Composer

$vendorDir = dirname(dirname(__FILE__));
$baseDir = dirname($vendorDir);

return array(
    'Composer\\InstalledVersions' => $vendorDir . '/composer/InstalledVersions.php',
    'HumbugBox3150\\Composer\\Semver\\Comparator' => $vendorDir . '/composer/semver/src/Comparator.php',
    'HumbugBox3150\\Composer\\Semver\\CompilingMatcher' => $vendorDir . '/composer/semver/src/CompilingMatcher.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\Bound' => $vendorDir . '/composer/semver/src/Constraint/Bound.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\Constraint' => $vendorDir . '/composer/semver/src/Constraint/Constraint.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\ConstraintInterface' => $vendorDir . '/composer/semver/src/Constraint/ConstraintInterface.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchAllConstraint' => $vendorDir . '/composer/semver/src/Constraint/MatchAllConstraint.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchNoneConstraint' => $vendorDir . '/composer/semver/src/Constraint/MatchNoneConstraint.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\MultiConstraint' => $vendorDir . '/composer/semver/src/Constraint/MultiConstraint.php',
    'HumbugBox3150\\Composer\\Semver\\Interval' => $vendorDir . '/composer/semver/src/Interval.php',
    'HumbugBox3150\\Composer\\Semver\\Intervals' => $vendorDir . '/composer/semver/src/Intervals.php',
    'HumbugBox3150\\Composer\\Semver\\Semver' => $vendorDir . '/composer/semver/src/Semver.php',
    'HumbugBox3150\\Composer\\Semver\\VersionParser' => $vendorDir . '/composer/semver/src/VersionParser.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Checker' => $baseDir . '/src/Checker.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IO' => $baseDir . '/src/IO.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IsExtensionFulfilled' => $baseDir . '/src/IsExtensionFulfilled.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IsFulfilled' => $baseDir . '/src/IsFulfilled.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IsPhpVersionFulfilled' => $baseDir . '/src/IsPhpVersionFulfilled.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Printer' => $baseDir . '/src/Printer.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Requirement' => $baseDir . '/src/Requirement.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\RequirementCollection' => $baseDir . '/src/RequirementCollection.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Terminal' => $baseDir . '/src/Terminal.php',
);
<?php

// autoload_static.php @generated by Composer

namespace Composer\Autoload;

class ComposerStaticInit7b1918d23e69dc64db20ca1f98396893
{
    public static $prefixLengthsPsr4 = array (
        'H' => 
        array (
            'HumbugBox3150\\KevinGH\\RequirementChecker\\' => 41,
            'HumbugBox3150\\Composer\\Semver\\' => 30,
        ),
    );

    public static $prefixDirsPsr4 = array (
        'HumbugBox3150\\KevinGH\\RequirementChecker\\' => 
        array (
            0 => __DIR__ . '/../..' . '/src',
        ),
        'HumbugBox3150\\Composer\\Semver\\' => 
        array (
            0 => __DIR__ . '/..' . '/composer/semver/src',
        ),
    );

    public static $classMap = array (
        'Composer\\InstalledVersions' => __DIR__ . '/..' . '/composer/InstalledVersions.php',
        'HumbugBox3150\\Composer\\Semver\\Comparator' => __DIR__ . '/..' . '/composer/semver/src/Comparator.php',
        'HumbugBox3150\\Composer\\Semver\\CompilingMatcher' => __DIR__ . '/..' . '/composer/semver/src/CompilingMatcher.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\Bound' => __DIR__ . '/..' . '/composer/semver/src/Constraint/Bound.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\Constraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/Constraint.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\ConstraintInterface' => __DIR__ . '/..' . '/composer/semver/src/Constraint/ConstraintInterface.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchAllConstraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/MatchAllConstraint.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchNoneConstraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/MatchNoneConstraint.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\MultiConstraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/MultiConstraint.php',
        'HumbugBox3150\\Composer\\Semver\\Interval' => __DIR__ . '/..' . '/composer/semver/src/Interval.php',
        'HumbugBox3150\\Composer\\Semver\\Intervals' => __DIR__ . '/..' . '/composer/semver/src/Intervals.php',
        'HumbugBox3150\\Composer\\Semver\\Semver' => __DIR__ . '/..' . '/composer/semver/src/Semver.php',
        'HumbugBox3150\\Composer\\Semver\\VersionParser' => __DIR__ . '/..' . '/composer/semver/src/VersionParser.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Checker' => __DIR__ . '/../..' . '/src/Checker.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IO' => __DIR__ . '/../..' . '/src/IO.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IsExtensionFulfilled' => __DIR__ . '/../..' . '/src/IsExtensionFulfilled.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IsFulfilled' => __DIR__ . '/../..' . '/src/IsFulfilled.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IsPhpVersionFulfilled' => __DIR__ . '/../..' . '/src/IsPhpVersionFulfilled.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Printer' => __DIR__ . '/../..' . '/src/Printer.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Requirement' => __DIR__ . '/../..' . '/src/Requirement.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\RequirementCollection' => __DIR__ . '/../..' . '/src/RequirementCollection.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Terminal' => __DIR__ . '/../..' . '/src/Terminal.php',
    );

    public static function getInitializer(ClassLoader $loader)
    {
        return \Closure::bind(function () use ($loader) {
            $loader->prefixLengthsPsr4 = ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::$prefixLengthsPsr4;
            $loader->prefixDirsPsr4 = ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::$prefixDirsPsr4;
            $loader->classMap = ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::$classMap;

        }, null, ClassLoader::class);
    }
}
<?php

// autoload_real.php @generated by Composer

class ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893
{
    private static $loader;

    public static function loadClassLoader($class)
    {
        if ('Composer\Autoload\ClassLoader' === $class) {
            require __DIR__ . '/ClassLoader.php';
        }
    }

    /**
     * @return \Composer\Autoload\ClassLoader
     */
    public static function getLoader()
    {
        if (null !== self::$loader) {
            return self::$loader;
        }

        spl_autoload_register(array('ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893', 'loadClassLoader'), true, true);
        self::$loader = $loader = new \Composer\Autoload\ClassLoader(\dirname(\dirname(__FILE__)));
        spl_autoload_unregister(array('ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893', 'loadClassLoader'));

        $useStaticLoader = PHP_VERSION_ID >= 50600 && !defined('HHVM_VERSION') && (!function_exists('zend_loader_file_encoded') || !zend_loader_file_encoded());
        if ($useStaticLoader) {
            require __DIR__ . '/autoload_static.php';

            call_user_func(\Composer\Autoload\ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::getInitializer($loader));
        } else {
            $classMap = require __DIR__ . '/autoload_classmap.php';
            if ($classMap) {
                $loader->addClassMap($classMap);
            }
        }

        $loader->setClassMapAuthoritative(true);
        $loader->register(true);

        return $loader;
    }
}
<?php

namespace HumbugBox3150\Composer\Semver;

use HumbugBox3150\Composer\Semver\Constraint\Constraint;
class Comparator
{
    public static function greaterThan($version1, $version2)
    {
        return self::compare($version1, '>', $version2);
    }
    public static function greaterThanOrEqualTo($version1, $version2)
    {
        return self::compare($version1, '>=', $version2);
    }
    public static function lessThan($version1, $version2)
    {
        return self::compare($version1, '<', $version2);
    }
    public static function lessThanOrEqualTo($version1, $version2)
    {
        return self::compare($version1, '<=', $version2);
    }
    public static function equalTo($version1, $version2)
    {
        return self::compare($version1, '==', $version2);
    }
    public static function notEqualTo($version1, $version2)
    {
        return self::compare($version1, '!=', $version2);
    }
    public static function compare($version1, $operator, $version2)
    {
        $constraint = new Constraint($operator, $version2);
        return $constraint->matchSpecific(new Constraint('==', $version1), \true);
    }
}
<?php

namespace HumbugBox3150\Composer\Semver;

use HumbugBox3150\Composer\Semver\Constraint\Constraint;
class Semver
{
    const SORT_ASC = 1;
    const SORT_DESC = -1;
    private static $versionParser;
    public static function satisfies($version, $constraints)
    {
        if (null === self::$versionParser) {
            self::$versionParser = new VersionParser();
        }
        $versionParser = self::$versionParser;
        $provider = new Constraint('==', $versionParser->normalize($version));
        $parsedConstraints = $versionParser->parseConstraints($constraints);
        return $parsedConstraints->matches($provider);
    }
    public static function satisfiedBy(array $versions, $constraints)
    {
        $versions = \array_filter($versions, function ($version) use($constraints) {
            return Semver::satisfies($version, $constraints);
        });
        return \array_values($versions);
    }
    public static function sort(array $versions)
    {
        return self::usort($versions, self::SORT_ASC);
    }
    public static function rsort(array $versions)
    {
        return self::usort($versions, self::SORT_DESC);
    }
    private static function usort(array $versions, $direction)
    {
        if (null === self::$versionParser) {
            self::$versionParser = new VersionParser();
        }
        $versionParser = self::$versionParser;
        $normalized = array();
        foreach ($versions as $key => $version) {
            $normalizedVersion = $versionParser->normalize($version);
            $normalizedVersion = $versionParser->normalizeDefaultBranch($normalizedVersion);
            $normalized[] = array($normalizedVersion, $key);
        }
        \usort($normalized, function (array $left, array $right) use($direction) {
            if ($left[0] === $right[0]) {
                return 0;
            }
            if (Comparator::lessThan($left[0], $right[0])) {
                return -$direction;
            }
            return $direction;
        });
        $sorted = array();
        foreach ($normalized as $item) {
            $sorted[] = $versions[$item[1]];
        }
        return $sorted;
    }
}
<?php

namespace HumbugBox3150\Composer\Semver;

use HumbugBox3150\Composer\Semver\Constraint\ConstraintInterface;
use HumbugBox3150\Composer\Semver\Constraint\MatchAllConstraint;
use HumbugBox3150\Composer\Semver\Constraint\MultiConstraint;
use HumbugBox3150\Composer\Semver\Constraint\Constraint;
class VersionParser
{
    private static $modifierRegex = '[._-]?(?:(stable|beta|b|RC|alpha|a|patch|pl|p)((?:[.-]?\\d+)*+)?)?([.-]?dev)?';
    private static $stabilitiesRegex = 'stable|RC|beta|alpha|dev';
    public static function parseStability($version)
    {
        $version = \preg_replace('{#.+$}i', '', $version);
        if (\strpos($version, 'dev-') === 0 || '-dev' === \substr($version, -4)) {
            return 'dev';
        }
        \preg_match('{' . self::$modifierRegex . '(?:\\+.*)?$}i', \strtolower($version), $match);
        if (!empty($match[3])) {
            return 'dev';
        }
        if (!empty($match[1])) {
            if ('beta' === $match[1] || 'b' === $match[1]) {
                return 'beta';
            }
            if ('alpha' === $match[1] || 'a' === $match[1]) {
                return 'alpha';
            }
            if ('rc' === $match[1]) {
                return 'RC';
            }
        }
        return 'stable';
    }
    public static function normalizeStability($stability)
    {
        $stability = \strtolower($stability);
        return $stability === 'rc' ? 'RC' : $stability;
    }
    public function normalize($version, $fullVersion = null)
    {
        $version = \trim($version);
        $origVersion = $version;
        if (null === $fullVersion) {
            $fullVersion = $version;
        }
        if (\preg_match('{^([^,\\s]++) ++as ++([^,\\s]++)$}', $version, $match)) {
            $version = $match[1];
        }
        if (\preg_match('{@(?:' . self::$stabilitiesRegex . ')$}i', $version, $match)) {
            $version = \substr($version, 0, \strlen($version) - \strlen($match[0]));
        }
        if (\in_array($version, array('master', 'trunk', 'default'), \true)) {
            $version = 'dev-' . $version;
        }
        if (\stripos($version, 'dev-') === 0) {
            return 'dev-' . \substr($version, 4);
        }
        if (\preg_match('{^([^,\\s+]++)\\+[^\\s]++$}', $version, $match)) {
            $version = $match[1];
        }
        if (\preg_match('{^v?(\\d{1,5})(\\.\\d++)?(\\.\\d++)?(\\.\\d++)?' . self::$modifierRegex . '$}i', $version, $matches)) {
            $version = $matches[1] . (!empty($matches[2]) ? $matches[2] : '.0') . (!empty($matches[3]) ? $matches[3] : '.0') . (!empty($matches[4]) ? $matches[4] : '.0');
            $index = 5;
        } elseif (\preg_match('{^v?(\\d{4}(?:[.:-]?\\d{2}){1,6}(?:[.:-]?\\d{1,3})?)' . self::$modifierRegex . '$}i', $version, $matches)) {
            $version = \preg_replace('{\\D}', '.', $matches[1]);
            $index = 2;
        }
        if (isset($index)) {
            if (!empty($matches[$index])) {
                if ('stable' === $matches[$index]) {
                    return $version;
                }
                $version .= '-' . $this->expandStability($matches[$index]) . (!empty($matches[$index + 1]) ? \ltrim($matches[$index + 1], '.-') : '');
            }
            if (!empty($matches[$index + 2])) {
                $version .= '-dev';
            }
            return $version;
        }
        if (\preg_match('{(.*?)[.-]?dev$}i', $version, $match)) {
            try {
                $normalized = $this->normalizeBranch($match[1]);
                if (\strpos($normalized, 'dev-') === \false) {
                    return $normalized;
                }
            } catch (\Exception $e) {
            }
        }
        $extraMessage = '';
        if (\preg_match('{ +as +' . \preg_quote($version) . '(?:@(?:' . self::$stabilitiesRegex . '))?$}', $fullVersion)) {
            $extraMessage = ' in "' . $fullVersion . '", the alias must be an exact version';
        } elseif (\preg_match('{^' . \preg_quote($version) . '(?:@(?:' . self::$stabilitiesRegex . '))? +as +}', $fullVersion)) {
            $extraMessage = ' in "' . $fullVersion . '", the alias source must be an exact version, if it is a branch name you should prefix it with dev-';
        }
        throw new \UnexpectedValueException('Invalid version string "' . $origVersion . '"' . $extraMessage);
    }
    public function parseNumericAliasPrefix($branch)
    {
        if (\preg_match('{^(?P<version>(\\d++\\.)*\\d++)(?:\\.x)?-dev$}i', $branch, $matches)) {
            return $matches['version'] . '.';
        }
        return \false;
    }
    public function normalizeBranch($name)
    {
        $name = \trim($name);
        if (\preg_match('{^v?(\\d++)(\\.(?:\\d++|[xX*]))?(\\.(?:\\d++|[xX*]))?(\\.(?:\\d++|[xX*]))?$}i', $name, $matches)) {
            $version = '';
            for ($i = 1; $i < 5; ++$i) {
                $version .= isset($matches[$i]) ? \str_replace(array('*', 'X'), 'x', $matches[$i]) : '.x';
            }
            return \str_replace('x', '9999999', $version) . '-dev';
        }
        return 'dev-' . $name;
    }
    public function normalizeDefaultBranch($name)
    {
        if ($name === 'dev-master' || $name === 'dev-default' || $name === 'dev-trunk') {
            return '9999999-dev';
        }
        return $name;
    }
    public function parseConstraints($constraints)
    {
        $prettyConstraint = $constraints;
        $orConstraints = \preg_split('{\\s*\\|\\|?\\s*}', \trim($constraints));
        $orGroups = array();
        foreach ($orConstraints as $constraints) {
            $andConstraints = \preg_split('{(?<!^|as|[=>< ,]) *(?<!-)[, ](?!-) *(?!,|as|$)}', $constraints);
            if (\count($andConstraints) > 1) {
                $constraintObjects = array();
                foreach ($andConstraints as $constraint) {
                    foreach ($this->parseConstraint($constraint) as $parsedConstraint) {
                        $constraintObjects[] = $parsedConstraint;
                    }
                }
            } else {
                $constraintObjects = $this->parseConstraint($andConstraints[0]);
            }
            if (1 === \count($constraintObjects)) {
                $constraint = $constraintObjects[0];
            } else {
                $constraint = new MultiConstraint($constraintObjects);
            }
            $orGroups[] = $constraint;
        }
        $constraint = MultiConstraint::create($orGroups, \false);
        $constraint->setPrettyString($prettyConstraint);
        return $constraint;
    }
    private function parseConstraint($constraint)
    {
        if (\preg_match('{^([^,\\s]++) ++as ++([^,\\s]++)$}', $constraint, $match)) {
            $constraint = $match[1];
        }
        if (\preg_match('{^([^,\\s]*?)@(' . self::$stabilitiesRegex . ')$}i', $constraint, $match)) {
            $constraint = '' !== $match[1] ? $match[1] : '*';
            if ($match[2] !== 'stable') {
                $stabilityModifier = $match[2];
            }
        }
        if (\preg_match('{^(dev-[^,\\s@]+?|[^,\\s@]+?\\.x-dev)#.+$}i', $constraint, $match)) {
            $constraint = $match[1];
        }
        if (\preg_match('{^(v)?[xX*](\\.[xX*])*$}i', $constraint, $match)) {
            if (!empty($match[1]) || !empty($match[2])) {
                return array(new Constraint('>=', '0.0.0.0-dev'));
            }
            return array(new MatchAllConstraint());
        }
        $versionRegex = 'v?(\\d++)(?:\\.(\\d++|[xX*]))?(?:\\.(\\d++|[xX*]))?(?:\\.(\\d++|[xX*]))?' . self::$modifierRegex . '(?:\\+[^\\s]+)?';
        if (\preg_match('{^~>?' . $versionRegex . '$}i', $constraint, $matches)) {
            if (\strpos($constraint, '~>') === 0) {
                throw new \UnexpectedValueException('Could not parse version constraint ' . $constraint . ': ' . 'Invalid operator "~>", you probably meant to use the "~" operator');
            }
            if (isset($matches[4]) && '' !== $matches[4] && null !== $matches[4]) {
                $position = 4;
            } elseif (isset($matches[3]) && '' !== $matches[3] && null !== $matches[3]) {
                $position = 3;
            } elseif (isset($matches[2]) && '' !== $matches[2] && null !== $matches[2]) {
                $position = 2;
            } else {
                $position = 1;
            }
            for ($i = $position; $i >= 0; $i--) {
                if ($matches[$i] === 'x' || $matches[$i] === 'X' || $matches[$i] === '*') {
                    $matches[$i] = '9999999';
                }
            }
            $stabilitySuffix = '';
            if (empty($matches[5]) && empty($matches[7])) {
                $stabilitySuffix .= '-dev';
            }
            $lowVersion = $this->normalize(\substr($constraint . $stabilitySuffix, 1));
            $lowerBound = new Constraint('>=', $lowVersion);
            $highPosition = \max(1, $position - 1);
            $highVersion = $this->manipulateVersionString($matches, $highPosition, 1) . '-dev';
            $upperBound = new Constraint('<', $highVersion);
            return array($lowerBound, $upperBound);
        }
        if (\preg_match('{^\\^' . $versionRegex . '($)}i', $constraint, $matches)) {
            if ('0' !== $matches[1] || '' === $matches[2] || null === $matches[2]) {
                $position = 1;
            } elseif ('0' !== $matches[2] || '' === $matches[3] || null === $matches[3]) {
                $position = 2;
            } else {
                $position = 3;
            }
            if ($position === 2 && ($matches[2] === 'x' || $matches[2] === 'X' || $matches[2] === '*')) {
                $position = 1;
            }
            $stabilitySuffix = '';
            if (empty($matches[5]) && empty($matches[7])) {
                $stabilitySuffix .= '-dev';
            }
            $lowVersion = $this->normalize(\substr($constraint . $stabilitySuffix, 1));
            $lowerBound = new Constraint('>=', $lowVersion);
            $highVersion = $this->manipulateVersionString($matches, $position, 1) . '-dev';
            $upperBound = new Constraint('<', $highVersion);
            return array($lowerBound, $upperBound);
        }
        if (\preg_match('{^v?(\\d++)(?:\\.(\\d++))?(?:\\.(\\d++))?(?:\\.[xX*])++$}', $constraint, $matches)) {
            if (isset($matches[3]) && '' !== $matches[3] && null !== $matches[3]) {
                $position = 3;
            } elseif (isset($matches[2]) && '' !== $matches[2] && null !== $matches[2]) {
                $position = 2;
            } else {
                $position = 1;
            }
            $lowVersion = $this->manipulateVersionString($matches, $position) . '-dev';
            $highVersion = $this->manipulateVersionString($matches, $position, 1) . '-dev';
            if ($lowVersion === '0.0.0.0-dev') {
                return array(new Constraint('<', $highVersion));
            }
            return array(new Constraint('>=', $lowVersion), new Constraint('<', $highVersion));
        }
        if (\preg_match('{^(?P<from>' . $versionRegex . ') +- +(?P<to>' . $versionRegex . ')($)}i', $constraint, $matches)) {
            $lowStabilitySuffix = '';
            if (empty($matches[6]) && empty($matches[8])) {
                $lowStabilitySuffix = '-dev';
            }
            $lowVersion = $this->normalize($matches['from']);
            $lowerBound = new Constraint('>=', $lowVersion . $lowStabilitySuffix);
            $empty = function ($x) {
                return $x === 0 || $x === '0' ? \false : empty($x);
            };
            if (!$empty($matches[11]) && !$empty($matches[12]) || !empty($matches[14]) || !empty($matches[16])) {
                $highVersion = $this->normalize($matches['to']);
                $upperBound = new Constraint('<=', $highVersion);
            } else {
                $highMatch = array('', $matches[10], $matches[11], $matches[12], $matches[13]);
                $this->normalize($matches['to']);
                $highVersion = $this->manipulateVersionString($highMatch, $empty($matches[11]) ? 1 : 2, 1) . '-dev';
                $upperBound = new Constraint('<', $highVersion);
            }
            return array($lowerBound, $upperBound);
        }
        if (\preg_match('{^(<>|!=|>=?|<=?|==?)?\\s*(.*)}', $constraint, $matches)) {
            try {
                try {
                    $version = $this->normalize($matches[2]);
                } catch (\UnexpectedValueException $e) {
                    if (\substr($matches[2], -4) === '-dev') {
                        $version = $this->normalize('dev-' . \substr($matches[2], 0, -4));
                    } else {
                        throw $e;
                    }
                }
                $op = $matches[1] ?: '=';
                if ($op !== '==' && $op !== '=' && !empty($stabilityModifier) && self::parseStability($version) === 'stable') {
                    $version .= '-' . $stabilityModifier;
                } elseif ('<' === $op || '>=' === $op) {
                    if (!\preg_match('/-' . self::$modifierRegex . '$/', \strtolower($matches[2]))) {
                        if (\strpos($matches[2], 'dev-') !== 0) {
                            $version .= '-dev';
                        }
                    }
                }
                return array(new Constraint($matches[1] ?: '=', $version));
            } catch (\Exception $e) {
            }
        }
        $message = 'Could not parse version constraint ' . $constraint;
        if (isset($e)) {
            $message .= ': ' . $e->getMessage();
        }
        throw new \UnexpectedValueException($message);
    }
    private function manipulateVersionString($matches, $position, $increment = 0, $pad = '0')
    {
        for ($i = 4; $i > 0; --$i) {
            if ($i > $position) {
                $matches[$i] = $pad;
            } elseif ($i === $position && $increment) {
                $matches[$i] += $increment;
                if ($matches[$i] < 0) {
                    $matches[$i] = $pad;
                    --$position;
                    if ($i === 1) {
                        return null;
                    }
                }
            }
        }
        return $matches[1] . '.' . $matches[2] . '.' . $matches[3] . '.' . $matches[4];
    }
    private function expandStability($stability)
    {
        $stability = \strtolower($stability);
        switch ($stability) {
            case 'a':
                return 'alpha';
            case 'b':
                return 'beta';
            case 'p':
            case 'pl':
                return 'patch';
            case 'rc':
                return 'RC';
            default:
                return $stability;
        }
    }
}
<?php

namespace HumbugBox3150\Composer\Semver\Constraint;

interface ConstraintInterface
{
    public function matches(ConstraintInterface $provider);
    public function compile($operator);
    public function getUpperBound();
    public function getLowerBound();
    public function getPrettyString();
    public function setPrettyString($prettyString);
    public function __toString();
}
<?php

namespace HumbugBox3150\Composer\Semver\Constraint;

class MultiConstraint implements ConstraintInterface
{
    protected $constraints;
    protected $prettyString;
    protected $string;
    protected $conjunctive;
    protected $lowerBound;
    protected $upperBound;
    public function __construct(array $constraints, $conjunctive = \true)
    {
        if (\count($constraints) < 2) {
            throw new \InvalidArgumentException('Must provide at least two constraints for a MultiConstraint. Use ' . 'the regular Constraint class for one constraint only or MatchAllConstraint for none. You may use ' . 'MultiConstraint::create() which optimizes and handles those cases automatically.');
        }
        $this->constraints = $constraints;
        $this->conjunctive = $conjunctive;
    }
    public function getConstraints()
    {
        return $this->constraints;
    }
    public function isConjunctive()
    {
        return $this->conjunctive;
    }
    public function isDisjunctive()
    {
        return !$this->conjunctive;
    }
    public function compile($otherOperator)
    {
        $parts = array();
        foreach ($this->constraints as $constraint) {
            $code = $constraint->compile($otherOperator);
            if ($code === 'true') {
                if (!$this->conjunctive) {
                    return 'true';
                }
            } elseif ($code === 'false') {
                if ($this->conjunctive) {
                    return 'false';
                }
            } else {
                $parts[] = '(' . $code . ')';
            }
        }
        if (!$parts) {
            return $this->conjunctive ? 'true' : 'false';
        }
        return $this->conjunctive ? \implode('&&', $parts) : \implode('||', $parts);
    }
    public function matches(ConstraintInterface $provider)
    {
        if (\false === $this->conjunctive) {
            foreach ($this->constraints as $constraint) {
                if ($provider->matches($constraint)) {
                    return \true;
                }
            }
            return \false;
        }
        foreach ($this->constraints as $constraint) {
            if (!$provider->matches($constraint)) {
                return \false;
            }
        }
        return \true;
    }
    public function setPrettyString($prettyString)
    {
        $this->prettyString = $prettyString;
    }
    public function getPrettyString()
    {
        if ($this->prettyString) {
            return $this->prettyString;
        }
        return (string) $this;
    }
    public function __toString()
    {
        if ($this->string !== null) {
            return $this->string;
        }
        $constraints = array();
        foreach ($this->constraints as $constraint) {
            $constraints[] = (string) $constraint;
        }
        return $this->string = '[' . \implode($this->conjunctive ? ' ' : ' || ', $constraints) . ']';
    }
    public function getLowerBound()
    {
        $this->extractBounds();
        return $this->lowerBound;
    }
    public function getUpperBound()
    {
        $this->extractBounds();
        return $this->upperBound;
    }
    public static function create(array $constraints, $conjunctive = \true)
    {
        if (0 === \count($constraints)) {
            return new MatchAllConstraint();
        }
        if (1 === \count($constraints)) {
            return $constraints[0];
        }
        $optimized = self::optimizeConstraints($constraints, $conjunctive);
        if ($optimized !== null) {
            list($constraints, $conjunctive) = $optimized;
            if (\count($constraints) === 1) {
                return $constraints[0];
            }
        }
        return new self($constraints, $conjunctive);
    }
    private static function optimizeConstraints(array $constraints, $conjunctive)
    {
        if (!$conjunctive) {
            $left = $constraints[0];
            $mergedConstraints = array();
            $optimized = \false;
            for ($i = 1, $l = \count($constraints); $i < $l; $i++) {
                $right = $constraints[$i];
                if ($left instanceof MultiConstraint && $left->conjunctive && $right instanceof MultiConstraint && $right->conjunctive && ($left0 = (string) $left->constraints[0]) && $left0[0] === '>' && $left0[1] === '=' && ($left1 = (string) $left->constraints[1]) && $left1[0] === '<' && ($right0 = (string) $right->constraints[0]) && $right0[0] === '>' && $right0[1] === '=' && ($right1 = (string) $right->constraints[1]) && $right1[0] === '<' && \substr($left1, 2) === \substr($right0, 3)) {
                    $optimized = \true;
                    $left = new MultiConstraint(\array_merge(array($left->constraints[0], $right->constraints[1]), \array_slice($left->constraints, 2), \array_slice($right->constraints, 2)), \true);
                } else {
                    $mergedConstraints[] = $left;
                    $left = $right;
                }
            }
            if ($optimized) {
                $mergedConstraints[] = $left;
                return array($mergedConstraints, \false);
            }
        }
        return null;
    }
    private function extractBounds()
    {
        if (null !== $this->lowerBound) {
            return;
        }
        foreach ($this->constraints as $constraint) {
            if (null === $this->lowerBound && null === $this->upperBound) {
                $this->lowerBound = $constraint->getLowerBound();
                $this->upperBound = $constraint->getUpperBound();
                continue;
            }
            if ($constraint->getLowerBound()->compareTo($this->lowerBound, $this->isConjunctive() ? '>' : '<')) {
                $this->lowerBound = $constraint->getLowerBound();
            }
            if ($constraint->getUpperBound()->compareTo($this->upperBound, $this->isConjunctive() ? '<' : '>')) {
                $this->upperBound = $constraint->getUpperBound();
            }
        }
    }
}
<?php

namespace HumbugBox3150\Composer\Semver\Constraint;

class Constraint implements ConstraintInterface
{
    const OP_EQ = 0;
    const OP_LT = 1;
    const OP_LE = 2;
    const OP_GT = 3;
    const OP_GE = 4;
    const OP_NE = 5;
    /**
    @phpstan-var
    */
    private static $transOpStr = array('=' => self::OP_EQ, '==' => self::OP_EQ, '<' => self::OP_LT, '<=' => self::OP_LE, '>' => self::OP_GT, '>=' => self::OP_GE, '<>' => self::OP_NE, '!=' => self::OP_NE);
    /**
    @phpstan-var
    */
    private static $transOpInt = array(self::OP_EQ => '==', self::OP_LT => '<', self::OP_LE => '<=', self::OP_GT => '>', self::OP_GE => '>=', self::OP_NE => '!=');
    /**
    @phpstan-var
    */
    protected $operator;
    protected $version;
    protected $prettyString;
    protected $lowerBound;
    protected $upperBound;
    public function __construct($operator, $version)
    {
        if (!isset(self::$transOpStr[$operator])) {
            throw new \InvalidArgumentException(\sprintf('Invalid operator "%s" given, expected one of: %s', $operator, \implode(', ', self::getSupportedOperators())));
        }
        $this->operator = self::$transOpStr[$operator];
        $this->version = $version;
    }
    public function getVersion()
    {
        return $this->version;
    }
    public function getOperator()
    {
        return self::$transOpInt[$this->operator];
    }
    public function matches(ConstraintInterface $provider)
    {
        if ($provider instanceof self) {
            return $this->matchSpecific($provider);
        }
        return $provider->matches($this);
    }
    public function setPrettyString($prettyString)
    {
        $this->prettyString = $prettyString;
    }
    public function getPrettyString()
    {
        if ($this->prettyString) {
            return $this->prettyString;
        }
        return $this->__toString();
    }
    public static function getSupportedOperators()
    {
        return \array_keys(self::$transOpStr);
    }
    /**
    @phpstan-return
    */
    public static function getOperatorConstant($operator)
    {
        return self::$transOpStr[$operator];
    }
    public function versionCompare($a, $b, $operator, $compareBranches = \false)
    {
        if (!isset(self::$transOpStr[$operator])) {
            throw new \InvalidArgumentException(\sprintf('Invalid operator "%s" given, expected one of: %s', $operator, \implode(', ', self::getSupportedOperators())));
        }
        $aIsBranch = 'dev-' === \substr($a, 0, 4);
        $bIsBranch = 'dev-' === \substr($b, 0, 4);
        if ($operator === '!=' && ($aIsBranch || $bIsBranch)) {
            return $a !== $b;
        }
        if ($aIsBranch && $bIsBranch) {
            return $operator === '==' && $a === $b;
        }
        if (!$compareBranches && ($aIsBranch || $bIsBranch)) {
            return \false;
        }
        return \version_compare($a, $b, $operator);
    }
    public function compile($otherOperator)
    {
        if ($this->version[0] === 'd' && 'dev-' === \substr($this->version, 0, 4)) {
            if (self::OP_EQ === $this->operator) {
                if (self::OP_EQ === $otherOperator) {
                    return \sprintf('$b && $v === %s', \var_export($this->version, \true));
                }
                if (self::OP_NE === $otherOperator) {
                    return \sprintf('!$b || $v !== %s', \var_export($this->version, \true));
                }
                return 'false';
            }
            if (self::OP_NE === $this->operator) {
                if (self::OP_EQ === $otherOperator) {
                    return \sprintf('!$b || $v !== %s', \var_export($this->version, \true));
                }
                if (self::OP_NE === $otherOperator) {
                    return 'true';
                }
                return '!$b';
            }
            return 'false';
        }
        if (self::OP_EQ === $this->operator) {
            if (self::OP_EQ === $otherOperator) {
                return \sprintf('\\version_compare($v, %s, \'==\')', \var_export($this->version, \true));
            }
            if (self::OP_NE === $otherOperator) {
                return \sprintf('$b || \\version_compare($v, %s, \'!=\')', \var_export($this->version, \true));
            }
            return \sprintf('!$b && \\version_compare(%s, $v, \'%s\')', \var_export($this->version, \true), self::$transOpInt[$otherOperator]);
        }
        if (self::OP_NE === $this->operator) {
            if (self::OP_EQ === $otherOperator) {
                return \sprintf('$b || (!$b && \\version_compare($v, %s, \'!=\'))', \var_export($this->version, \true));
            }
            if (self::OP_NE === $otherOperator) {
                return 'true';
            }
            return '!$b';
        }
        if (self::OP_LT === $this->operator || self::OP_LE === $this->operator) {
            if (self::OP_LT === $otherOperator || self::OP_LE === $otherOperator) {
                return '!$b';
            }
        } elseif (self::OP_GT === $this->operator || self::OP_GE === $this->operator) {
            if (self::OP_GT === $otherOperator || self::OP_GE === $otherOperator) {
                return '!$b';
            }
        }
        if (self::OP_NE === $otherOperator) {
            return 'true';
        }
        $codeComparison = \sprintf('\\version_compare($v, %s, \'%s\')', \var_export($this->version, \true), self::$transOpInt[$this->operator]);
        if ($this->operator === self::OP_LE) {
            if ($otherOperator === self::OP_GT) {
                return \sprintf('!$b && \\version_compare($v, %s, \'!=\') && ', \var_export($this->version, \true)) . $codeComparison;
            }
        } elseif ($this->operator === self::OP_GE) {
            if ($otherOperator === self::OP_LT) {
                return \sprintf('!$b && \\version_compare($v, %s, \'!=\') && ', \var_export($this->version, \true)) . $codeComparison;
            }
        }
        return \sprintf('!$b && %s', $codeComparison);
    }
    public function matchSpecific(Constraint $provider, $compareBranches = \false)
    {
        $noEqualOp = \str_replace('=', '', self::$transOpInt[$this->operator]);
        $providerNoEqualOp = \str_replace('=', '', self::$transOpInt[$provider->operator]);
        $isEqualOp = self::OP_EQ === $this->operator;
        $isNonEqualOp = self::OP_NE === $this->operator;
        $isProviderEqualOp = self::OP_EQ === $provider->operator;
        $isProviderNonEqualOp = self::OP_NE === $provider->operator;
        if ($isNonEqualOp || $isProviderNonEqualOp) {
            if ($isNonEqualOp && !$isProviderNonEqualOp && !$isProviderEqualOp && 'dev-' === \substr($provider->version, 0, 4)) {
                return \false;
            }
            if ($isProviderNonEqualOp && !$isNonEqualOp && !$isEqualOp && 'dev-' === \substr($this->version, 0, 4)) {
                return \false;
            }
            if (!$isEqualOp && !$isProviderEqualOp) {
                return \true;
            }
            return $this->versionCompare($provider->version, $this->version, '!=', $compareBranches);
        }
        if ($this->operator !== self::OP_EQ && $noEqualOp === $providerNoEqualOp) {
            if ('dev-' === \substr($this->version, 0, 4) || 'dev-' === \substr($provider->version, 0, 4)) {
                return \false;
            }
            return \true;
        }
        $version1 = $isEqualOp ? $this->version : $provider->version;
        $version2 = $isEqualOp ? $provider->version : $this->version;
        $operator = $isEqualOp ? $provider->operator : $this->operator;
        if ($this->versionCompare($version1, $version2, self::$transOpInt[$operator], $compareBranches)) {
            return !(self::$transOpInt[$provider->operator] === $providerNoEqualOp && self::$transOpInt[$this->operator] !== $noEqualOp && \version_compare($provider->version, $this->version, '=='));
        }
        return \false;
    }
    public function __toString()
    {
        return self::$transOpInt[$this->operator] . ' ' . $this->version;
    }
    public function getLowerBound()
    {
        $this->extractBounds();
        return $this->lowerBound;
    }
    public function getUpperBound()
    {
        $this->extractBounds();
        return $this->upperBound;
    }
    private function extractBounds()
    {
        if (null !== $this->lowerBound) {
            return;
        }
        if (\strpos($this->version, 'dev-') === 0) {
            $this->lowerBound = Bound::zero();
            $this->upperBound = Bound::positiveInfinity();
            return;
        }
        switch ($this->operator) {
            case self::OP_EQ:
                $this->lowerBound = new Bound($this->version, \true);
                $this->upperBound = new Bound($this->version, \true);
                break;
            case self::OP_LT:
                $this->lowerBound = Bound::zero();
                $this->upperBound = new Bound($this->version, \false);
                break;
            case self::OP_LE:
                $this->lowerBound = Bound::zero();
                $this->upperBound = new Bound($this->version, \true);
                break;
            case self::OP_GT:
                $this->lowerBound = new Bound($this->version, \false);
                $this->upperBound = Bound::positiveInfinity();
                break;
            case self::OP_GE:
                $this->lowerBound = new Bound($this->version, \true);
                $this->upperBound = Bound::positiveInfinity();
                break;
            case self::OP_NE:
                $this->lowerBound = Bound::zero();
                $this->upperBound = Bound::positiveInfinity();
                break;
        }
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

class Terminal
{
    private static $width;
    private static $height;
    private static $stty;
    public function getWidth()
    {
        $width = \getenv('COLUMNS');
        if (\false !== $width) {
            return (int) \trim($width);
        }
        if (null === self::$width) {
            self::initDimensions();
        }
        return self::$width ?: 80;
    }
    public function getHeight()
    {
        $height = \getenv('LINES');
        if (\false !== $height) {
            return (int) \trim($height);
        }
        if (null === self::$height) {
            self::initDimensions();
        }
        return self::$height ?: 50;
    }
    public static function hasSttyAvailable()
    {
        if (null !== self::$stty) {
            return self::$stty;
        }
        if (!\function_exists('exec')) {
            return \false;
        }
        \exec('stty 2>&1', $output, $exitcode);
        return self::$stty = 0 === $exitcode;
    }
    private static function initDimensions()
    {
        if ('\\' === \DIRECTORY_SEPARATOR) {
            if (\preg_match('/^(\\d+)x(\\d+)(?: \\((\\d+)x(\\d+)\\))?$/', \trim(\getenv('ANSICON')), $matches)) {
                self::$width = (int) $matches[1];
                self::$height = isset($matches[4]) ? (int) $matches[4] : (int) $matches[2];
            } elseif (!self::hasVt100Support() && self::hasSttyAvailable()) {
                self::initDimensionsUsingStty();
            } elseif (null !== ($dimensions = self::getConsoleMode())) {
                self::$width = (int) $dimensions[0];
                self::$height = (int) $dimensions[1];
            }
        } else {
            self::initDimensionsUsingStty();
        }
    }
    private static function hasVt100Support()
    {
        return \function_exists('sapi_windows_vt100_support') && \sapi_windows_vt100_support(\fopen('php://stdout', 'wb'));
    }
    private static function initDimensionsUsingStty()
    {
        if ($sttyString = self::getSttyColumns()) {
            if (\preg_match('/rows.(\\d+);.columns.(\\d+);/i', $sttyString, $matches)) {
                self::$width = (int) $matches[2];
                self::$height = (int) $matches[1];
            } elseif (\preg_match('/;.(\\d+).rows;.(\\d+).columns/i', $sttyString, $matches)) {
                self::$width = (int) $matches[2];
                self::$height = (int) $matches[1];
            }
        }
    }
    private static function getConsoleMode()
    {
        $info = self::readFromProcess('mode CON');
        if (null === $info || !\preg_match('/--------+\\r?\\n.+?(\\d+)\\r?\\n.+?(\\d+)\\r?\\n/', $info, $matches)) {
            return null;
        }
        return array((int) $matches[2], (int) $matches[1]);
    }
    private static function getSttyColumns()
    {
        return self::readFromProcess('stty -a | grep columns');
    }
    private static function readFromProcess($command)
    {
        if (!\function_exists('proc_open')) {
            return null;
        }
        $descriptorspec = array(1 => array('pipe', 'w'), 2 => array('pipe', 'w'));
        $process = \proc_open($command, $descriptorspec, $pipes, null, null, array('suppress_errors' => \true));
        if (!\is_resource($process)) {
            return null;
        }
        $info = \stream_get_contents($pipes[1]);
        \fclose($pipes[1]);
        \fclose($pipes[2]);
        \proc_close($process);
        return $info;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class IO
{
    const VERBOSITY_QUIET = 16;
    const VERBOSITY_NORMAL = 32;
    const VERBOSITY_VERBOSE = 64;
    const VERBOSITY_VERY_VERBOSE = 128;
    const VERBOSITY_DEBUG = 256;
    private $interactive;
    private $verbosity = self::VERBOSITY_NORMAL;
    private $colorSupport;
    private $options;
    public function __construct()
    {
        $this->options = \implode(' ', $_SERVER['argv']);
        $shellVerbosity = $this->configureVerbosity();
        $this->interactive = $this->checkInteractivity($shellVerbosity);
        $this->colorSupport = $this->checkColorSupport();
    }
    public function isInteractive()
    {
        return $this->interactive;
    }
    public function getVerbosity()
    {
        return $this->verbosity;
    }
    public function hasColorSupport()
    {
        return $this->colorSupport;
    }
    public function hasParameter($values)
    {
        $values = (array) $values;
        foreach ($values as $value) {
            $regexp = \sprintf('/\\s%s\\b/', \str_replace(' ', '\\s+', \preg_quote($value, '/')));
            if (1 === \preg_match($regexp, $this->options)) {
                return \true;
            }
        }
        return \false;
    }
    private function checkInteractivity($shellVerbosity)
    {
        if (-1 === $shellVerbosity) {
            return \false;
        }
        if (\true === $this->hasParameter(array('--no-interaction', '-n'))) {
            return \false;
        }
        if (\function_exists('posix_isatty') && !@\posix_isatty(\STDOUT) && \false === \getenv('SHELL_INTERACTIVE')) {
            return \false;
        }
        return \true;
    }
    private function configureVerbosity()
    {
        switch ($shellVerbosity = (int) \getenv('SHELL_VERBOSITY')) {
            case -1:
                $this->verbosity = self::VERBOSITY_QUIET;
                break;
            case 1:
                $this->verbosity = self::VERBOSITY_VERBOSE;
                break;
            case 2:
                $this->verbosity = self::VERBOSITY_VERY_VERBOSE;
                break;
            case 3:
                $this->verbosity = self::VERBOSITY_DEBUG;
                break;
            default:
                $shellVerbosity = 0;
                break;
        }
        if ($this->hasParameter(array('--quiet', '-q'))) {
            $this->verbosity = self::VERBOSITY_QUIET;
            $shellVerbosity = -1;
        } elseif ($this->hasParameter(array('-vvv', '--verbose=3', '--verbose 3'))) {
            $this->verbosity = self::VERBOSITY_DEBUG;
            $shellVerbosity = 3;
        } elseif ($this->hasParameter(array('-vv', '--verbose=2', '--verbose 2'))) {
            $this->verbosity = self::VERBOSITY_VERY_VERBOSE;
            $shellVerbosity = 2;
        } elseif ($this->hasParameter(array('-v', '--verbose=1', '--verbose 1', '--verbose'))) {
            $this->verbosity = self::VERBOSITY_VERBOSE;
            $shellVerbosity = 1;
        }
        return $shellVerbosity;
    }
    private function checkColorSupport()
    {
        if ($this->hasParameter(array('--ansi'))) {
            return \true;
        }
        if ($this->hasParameter(array('--no-ansi'))) {
            return \false;
        }
        if (\DIRECTORY_SEPARATOR === '\\') {
            return \function_exists('sapi_windows_vt100_support') && \sapi_windows_vt100_support(\STDOUT) || \false !== \getenv('ANSICON') || 'ON' === \getenv('ConEmuANSI') || 'xterm' === \getenv('TERM');
        }
        if (\function_exists('stream_isatty')) {
            return \stream_isatty(\STDOUT);
        }
        if (\function_exists('posix_isatty')) {
            return \posix_isatty(\STDOUT);
        }
        $stat = \fstat(\STDOUT);
        return $stat ? 020000 === ($stat['mode'] & 0170000) : \false;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class IsExtensionFulfilled implements IsFulfilled
{
    private $requiredExtension;
    public function __construct($requiredExtension)
    {
        $this->requiredExtension = $requiredExtension;
    }
    public function __invoke()
    {
        return \extension_loaded($this->requiredExtension);
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class Checker
{
    private static $requirementsConfig;
    public static function checkRequirements()
    {
        $requirements = self::retrieveRequirements();
        $checkPassed = $requirements->evaluateRequirements();
        $io = new IO();
        self::printCheck($checkPassed, new Printer($io->getVerbosity(), $io->hasColorSupport()), $requirements);
        return $checkPassed;
    }
    public static function printCheck($checkPassed, Printer $printer, RequirementCollection $requirements)
    {
        if (\false === $checkPassed && IO::VERBOSITY_VERY_VERBOSE > $printer->getVerbosity()) {
            $printer->setVerbosity(IO::VERBOSITY_VERY_VERBOSE);
        }
        $verbosity = IO::VERBOSITY_VERY_VERBOSE;
        $iniPath = $requirements->getPhpIniPath();
        $printer->title('Box Requirements Checker', $verbosity);
        $printer->printv('> Using PHP ', $verbosity);
        $printer->printvln(\PHP_VERSION, $verbosity, 'green');
        $printer->printvln('> PHP is using the following php.ini file:', $verbosity);
        if ($iniPath) {
            $printer->printvln('  ' . $iniPath, $verbosity, 'green');
        } else {
            $printer->printvln('  WARNING: No configuration file (php.ini) used by PHP!', $verbosity, 'yellow');
        }
        $printer->printvln('', $verbosity);
        if (\count($requirements) > 0) {
            $printer->printvln('> Checking Box requirements:', $verbosity);
            $printer->printv('  ', $verbosity);
        } else {
            $printer->printvln('> No requirements found.', $verbosity);
        }
        $errorMessages = array();
        foreach ($requirements->getRequirements() as $requirement) {
            if ($errorMessage = $printer->getRequirementErrorMessage($requirement)) {
                if (IO::VERBOSITY_DEBUG === $printer->getVerbosity()) {
                    $printer->printvln('✘ ' . $requirement->getTestMessage(), IO::VERBOSITY_DEBUG, 'red');
                    $printer->printv('  ', IO::VERBOSITY_DEBUG);
                    $errorMessages[] = $errorMessage;
                } else {
                    $printer->printv('E', $verbosity, 'red');
                    $errorMessages[] = $errorMessage;
                }
                continue;
            }
            if (IO::VERBOSITY_DEBUG === $printer->getVerbosity()) {
                $printer->printvln('✔ ' . $requirement->getHelpText(), IO::VERBOSITY_DEBUG, 'green');
                $printer->printv('  ', IO::VERBOSITY_DEBUG);
            } else {
                $printer->printv('.', $verbosity, 'green');
            }
        }
        if (IO::VERBOSITY_DEBUG !== $printer->getVerbosity() && \count($requirements) > 0) {
            $printer->printvln('', $verbosity);
        }
        if ($requirements->evaluateRequirements()) {
            $printer->block('OK', 'Your system is ready to run the application.', $verbosity, 'success');
        } else {
            $printer->block('ERROR', 'Your system is not ready to run the application.', $verbosity, 'error');
            $printer->title('Fix the following mandatory requirements:', $verbosity, 'red');
            foreach ($errorMessages as $errorMessage) {
                $printer->printv(' * ' . $errorMessage, $verbosity);
            }
        }
        $printer->printvln('', $verbosity);
    }
    private static function retrieveRequirements()
    {
        if (null === self::$requirementsConfig) {
            self::$requirementsConfig = __DIR__ . '/../.requirements.php';
        }
        $config = (require self::$requirementsConfig);
        $requirements = new RequirementCollection();
        foreach ($config as $constraint) {
            $requirements->addRequirement('php' === $constraint['type'] ? new IsPhpVersionFulfilled($constraint['condition']) : new IsExtensionFulfilled($constraint['condition']), $constraint['message'], $constraint['helpMessage']);
        }
        return $requirements;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

use HumbugBox3150\Composer\Semver\Semver;
final class IsPhpVersionFulfilled implements IsFulfilled
{
    private $requiredPhpVersion;
    public function __construct($requiredPhpVersion)
    {
        $this->requiredPhpVersion = $requiredPhpVersion;
    }
    public function __invoke()
    {
        return Semver::satisfies(\sprintf('%d.%d.%d', \PHP_MAJOR_VERSION, \PHP_MINOR_VERSION, \PHP_RELEASE_VERSION), $this->requiredPhpVersion);
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

use ArrayIterator;
use Countable;
use IteratorAggregate;
use ReturnTypeWillChange;
use Traversable;
final class RequirementCollection implements IteratorAggregate, Countable
{
    private $requirements = array();
    #[\ReturnTypeWillChange]
    public function getIterator()
    {
        return new ArrayIterator($this->requirements);
    }
    #[\ReturnTypeWillChange]
    public function count()
    {
        return \count($this->requirements);
    }
    public function add(Requirement $requirement)
    {
        $this->requirements[] = $requirement;
    }
    public function addRequirement($checkIsFulfilled, $testMessage, $helpText)
    {
        $this->add(new Requirement($checkIsFulfilled, $testMessage, $helpText));
    }
    public function getRequirements()
    {
        return $this->requirements;
    }
    public function getPhpIniPath()
    {
        return \get_cfg_var('cfg_file_path');
    }
    public function evaluateRequirements()
    {
        return \array_reduce($this->requirements, function ($checkPassed, Requirement $requirement) {
            return $checkPassed && $requirement->isFulfilled();
        }, \true);
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class Printer
{
    private $styles = array('reset' => "\x1b[0m", 'red' => "\x1b[31m", 'green' => "\x1b[32m", 'yellow' => "\x1b[33m", 'title' => "\x1b[33m", 'error' => "\x1b[37;41m", 'success' => "\x1b[30;42m");
    private $verbosity;
    private $supportColors;
    private $width;
    public function __construct($verbosity, $supportColors, $width = null)
    {
        if (null === $width) {
            $terminal = new Terminal();
            $width = $terminal->getWidth();
        }
        $this->verbosity = $verbosity;
        $this->supportColors = $supportColors;
        $this->width = $width ?: 80;
    }
    public function getVerbosity()
    {
        return $this->verbosity;
    }
    public function setVerbosity($verbosity)
    {
        $this->verbosity = $verbosity;
    }
    public function title($title, $verbosity, $style = null)
    {
        if (null === $style) {
            $style = 'title';
        }
        $this->printvln('', $verbosity, $style);
        $this->printvln($title, $verbosity, $style);
        $this->printvln(\str_repeat('=', \min(\strlen($title), $this->width)), $verbosity, $style);
        $this->printvln('', $verbosity, $style);
    }
    public function getRequirementErrorMessage(Requirement $requirement)
    {
        if ($requirement->isFulfilled()) {
            return null;
        }
        $errorMessage = \wordwrap($requirement->getTestMessage(), $this->width - 3, \PHP_EOL . '   ') . \PHP_EOL;
        return $errorMessage;
    }
    public function block($title, $message, $verbosity, $style = null)
    {
        $prefix = ' [' . $title . '] ';
        $lineLength = $this->width - \strlen($prefix) - 1;
        if ($lineLength < 0) {
            $lineLength = 0;
        }
        $message = $prefix . \trim($message);
        $lines = array();
        $remainingMessage = $message;
        $wrapped = \wordwrap($remainingMessage, $lineLength, '¬');
        $wrapped = \explode('¬', $wrapped);
        do {
            $line = \array_shift($wrapped);
            if ($lines && $lineLength > 0) {
                $line = \str_repeat(' ', \strlen($prefix)) . \ltrim($line);
            }
            $lines[] = \str_pad($line, $this->width, ' ', \STR_PAD_RIGHT);
        } while (\count($wrapped));
        $this->printvln('', $verbosity);
        $this->printvln(\str_repeat(' ', $this->width), $verbosity, $style);
        foreach ($lines as $line) {
            $this->printvln($line, $verbosity, $style);
        }
        $this->printv(\str_repeat(' ', $this->width), $verbosity, $style);
        $this->printvln('', $verbosity);
    }
    public function printvln($message, $verbosity, $style = null)
    {
        $this->printv($message, $verbosity, $style);
        $this->printv(\PHP_EOL, $verbosity, null);
    }
    public function printv($message, $verbosity, $style = null)
    {
        if ($verbosity > $this->verbosity) {
            return;
        }
        $message = \wordwrap($message, $this->width);
        $message = \sprintf('%s%s%s', $this->supportColors && isset($this->styles[$style]) ? $this->styles[$style] : '', $message, $this->supportColors ? $this->styles['reset'] : '');
        echo $message;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

interface IsFulfilled
{
    public function __invoke();
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class Requirement
{
    private $checkIsFulfilled;
    private $fulfilled;
    private $testMessage;
    private $helpText;
    public function __construct($checkIsFulfilled, $testMessage, $helpText)
    {
        $this->checkIsFulfilled = $checkIsFulfilled;
        $this->testMessage = $testMessage;
        $this->helpText = $helpText;
    }
    public function isFulfilled()
    {
        if (null === $this->fulfilled) {
            $this->fulfilled = $this->checkIsFulfilled->__invoke();
        }
        return (bool) $this->fulfilled;
    }
    public function getIsFullfilledChecker()
    {
        return $this->checkIsFulfilled;
    }
    public function getTestMessage()
    {
        return $this->testMessage;
    }
    public function getHelpText()
    {
        return $this->helpText;
    }
}
                   GNU LESSER GENERAL PUBLIC LICENSE
                       Version 3, 29 June 2007

 Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.


  This version of the GNU Lesser General Public License incorporates
the terms and conditions of version 3 of the GNU General Public
License, supplemented by the additional permissions listed below.

  0. Additional Definitions.

  As used herein, "this License" refers to version 3 of the GNU Lesser
General Public License, and the "GNU GPL" refers to version 3 of the GNU
General Public License.

  "The Library" refers to a covered work governed by this License,
other than an Application or a Combined Work as defined below.

  An "Application" is any work that makes use of an interface provided
by the Library, but which is not otherwise based on the Library.
Defining a subclass of a class defined by the Library is deemed a mode
of using an interface provided by the Library.

  A "Combined Work" is a work produced by combining or linking an
Application with the Library.  The particular version of the Library
with which the Combined Work was made is also called the "Linked
Version".

  The "Minimal Corresponding Source" for a Combined Work means the
Corresponding Source for the Combined Work, excluding any source code
for portions of the Combined Work that, considered in isolation, are
based on the Application, and not on the Linked Version.

  The "Corresponding Application Code" for a Combined Work means the
object code and/or source code for the Application, including any data
and utility programs needed for reproducing the Combined Work from the
Application, but excluding the System Libraries of the Combined Work.

  1. Exception to Section 3 of the GNU GPL.

  You may convey a covered work under sections 3 and 4 of this License
without being bound by section 3 of the GNU GPL.

  2. Conveying Modified Versions.

  If you modify a copy of the Library, and, in your modifications, a
facility refers to a function or data to be supplied by an Application
that uses the facility (other than as an argument passed when the
facility is invoked), then you may convey a copy of the modified
version:

   a) under this License, provided that you make a good faith effort to
   ensure that, in the event an Application does not supply the
   function or data, the facility still operates, and performs
   whatever part of its purpose remains meaningful, or

   b) under the GNU GPL, with none of the additional permissions of
   this License applicable to that copy.

  3. Object Code Incorporating Material from Library Header Files.

  The object code form of an Application may incorporate material from
a header file that is part of the Library.  You may convey such object
code under terms of your choice, provided that, if the incorporated
material is not limited to numerical parameters, data structure
layouts and accessors, or small macros, inline functions and templates
(ten or fewer lines in length), you do both of the following:

   a) Give prominent notice with each copy of the object code that the
   Library is used in it and that the Library and its use are
   covered by this License.

   b) Accompany the object code with a copy of the GNU GPL and this license
   document.

  4. Combined Works.

  You may convey a Combined Work under terms of your choice that,
taken together, effectively do not restrict modification of the
portions of the Library contained in the Combined Work and reverse
engineering for debugging such modifications, if you also do each of
the following:

   a) Give prominent notice with each copy of the Combined Work that
   the Library is used in it and that the Library and its use are
   covered by this License.

   b) Accompany the Combined Work with a copy of the GNU GPL and this license
   document.

   c) For a Combined Work that displays copyright notices during
   execution, include the copyright notice for the Library among
   these notices, as well as a reference directing the user to the
   copies of the GNU GPL and this license document.

   d) Do one of the following:

       0) Convey the Minimal Corresponding Source under the terms of this
       License, and the Corresponding Application Code in a form
       suitable for, and under terms that permit, the user to
       recombine or relink the Application with a modified version of
       the Linked Version to produce a modified Combined Work, in the
       manner specified by section 6 of the GNU GPL for conveying
       Corresponding Source.

       1) Use a suitable shared library mechanism for linking with the
       Library.  A suitable mechanism is one that (a) uses at run time
       a copy of the Library already present on the user's computer
       system, and (b) will operate properly with a modified version
       of the Library that is interface-compatible with the Linked
       Version.

   e) Provide Installation Information, but only if you would otherwise
   be required to provide such information under section 6 of the
   GNU GPL, and only to the extent that such information is
   necessary to install and execute a modified version of the
   Combined Work produced by recombining or relinking the
   Application with a modified version of the Linked Version. (If
   you use option 4d0, the Installation Information must accompany
   the Minimal Corresponding Source and Corresponding Application
   Code. If you use option 4d1, you must provide the Installation
   Information in the manner specified by section 6 of the GNU GPL
   for conveying Corresponding Source.)

  5. Combined Libraries.

  You may place library facilities that are a work based on the
Library side by side in a single library together with other library
facilities that are not Applications and are not covered by this
License, and convey such a combined library under terms of your
choice, if you do both of the following:

   a) Accompany the combined library with a copy of the same work based
   on the Library, uncombined with any other library facilities,
   conveyed under the terms of this License.

   b) Give prominent notice with the combined library that part of it
   is a work based on the Library, and explaining where to find the
   accompanying uncombined form of the same work.

  6. Revised Versions of the GNU Lesser General Public License.

  The Free Software Foundation may publish revised and/or new versions
of the GNU Lesser General Public License from time to time. Such new
versions will be similar in spirit to the present version, but may
differ in detail to address new problems or concerns.

  Each version is given a distinguishing version number. If the
Library as you received it specifies that a certain numbered version
of the GNU Lesser General Public License "or any later version"
applies to it, you have the option of following the terms and
conditions either of that published version or of any later version
published by the Free Software Foundation. If the Library as you
received it does not specify a version number of the GNU Lesser
General Public License, you may choose any version of the GNU Lesser
General Public License ever published by the Free Software Foundation.

  If the Library as you received it specifies that a proxy can decide
whether future versions of the GNU Lesser General Public License shall
apply, that proxy's public statement of acceptance of any version is
permanent authorization for you to choose that version for the
Library.
<!doctype html><html lang="en"><head><meta charset="utf-8"><title>Contao Manager</title><meta http-equiv="X-UA-Compatible" content="IE=edge"><meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1"/><meta name="description" content=""><meta name="robots" content="noindex,follow"><meta http-equiv="Content-Security-Policy" content="img-src 'self' data: blob: contao.github.io extensions.contao.org; object-src 'none'"/><link rel="icon" type="image/x-icon" href="assets/favicon.ico"><link rel="icon" type="image/png" sizes="16x16" href="assets/favicon-16x16.png"><link rel="icon" type="image/png" sizes="32x32" href="assets/favicon-32x32.png"><link rel="icon" type="image/png" sizes="48x48" href="assets/favicon-48x48.png"><link rel="manifest" href="assets/manifest.webmanifest"><meta name="mobile-web-app-capable" content="yes"><meta name="theme-color" content="#ffffff"><meta name="application-name" content="Contao Manager"><link rel="apple-touch-icon" sizes="57x57" href="assets/apple-touch-icon-57x57.png"><link rel="apple-touch-icon" sizes="60x60" href="assets/apple-touch-icon-60x60.png"><link rel="apple-touch-icon" sizes="72x72" href="assets/apple-touch-icon-72x72.png"><link rel="apple-touch-icon" sizes="76x76" href="assets/apple-touch-icon-76x76.png"><link rel="apple-touch-icon" sizes="114x114" href="assets/apple-touch-icon-114x114.png"><link rel="apple-touch-icon" sizes="120x120" href="assets/apple-touch-icon-120x120.png"><link rel="apple-touch-icon" sizes="144x144" href="assets/apple-touch-icon-144x144.png"><link rel="apple-touch-icon" sizes="152x152" href="assets/apple-touch-icon-152x152.png"><link rel="apple-touch-icon" sizes="167x167" href="assets/apple-touch-icon-167x167.png"><link rel="apple-touch-icon" sizes="180x180" href="assets/apple-touch-icon-180x180.png"><link rel="apple-touch-icon" sizes="1024x1024" href="assets/apple-touch-icon-1024x1024.png"><meta name="apple-mobile-web-app-capable" content="yes"><meta name="apple-mobile-web-app-status-bar-style" content="black-translucent"><meta name="apple-mobile-web-app-title" content="Contao Manager"><link rel="apple-touch-startup-image" media="(device-width: 320px) and (device-height: 568px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-640x1136.png"><link rel="apple-touch-startup-image" media="(device-width: 320px) and (device-height: 568px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-1136x640.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 667px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-750x1334.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 667px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-1334x750.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 812px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1125x2436.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 812px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2436x1125.png"><link rel="apple-touch-startup-image" media="(device-width: 390px) and (device-height: 844px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1170x2532.png"><link rel="apple-touch-startup-image" media="(device-width: 390px) and (device-height: 844px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2532x1170.png"><link rel="apple-touch-startup-image" media="(device-width: 393px) and (device-height: 852px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1179x2556.png"><link rel="apple-touch-startup-image" media="(device-width: 393px) and (device-height: 852px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2556x1179.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-828x1792.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-1792x828.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1242x2688.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2688x1242.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 736px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1242x2208.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 736px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2208x1242.png"><link rel="apple-touch-startup-image" media="(device-width: 428px) and (device-height: 926px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1284x2778.png"><link rel="apple-touch-startup-image" media="(device-width: 428px) and (device-height: 926px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2778x1284.png"><link rel="apple-touch-startup-image" media="(device-width: 430px) and (device-height: 932px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1290x2796.png"><link rel="apple-touch-startup-image" media="(device-width: 430px) and (device-height: 932px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2796x1290.png"><link rel="apple-touch-startup-image" media="(device-width: 744px) and (device-height: 1133px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1488x2266.png"><link rel="apple-touch-startup-image" media="(device-width: 744px) and (device-height: 1133px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2266x1488.png"><link rel="apple-touch-startup-image" media="(device-width: 768px) and (device-height: 1024px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1536x2048.png"><link rel="apple-touch-startup-image" media="(device-width: 768px) and (device-height: 1024px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2048x1536.png"><link rel="apple-touch-startup-image" media="(device-width: 810px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1620x2160.png"><link rel="apple-touch-startup-image" media="(device-width: 810px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2160x1620.png"><link rel="apple-touch-startup-image" media="(device-width: 820px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1640x2160.png"><link rel="apple-touch-startup-image" media="(device-width: 820px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2160x1640.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1194px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1668x2388.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1194px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2388x1668.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1112px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1668x2224.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1112px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2224x1668.png"><link rel="apple-touch-startup-image" media="(device-width: 1024px) and (device-height: 1366px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-2048x2732.png"><link rel="apple-touch-startup-image" media="(device-width: 1024px) and (device-height: 1366px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2732x2048.png"><meta name="msapplication-TileColor" content="#ffffff"><meta name="msapplication-TileImage" content="assets/mstile-144x144.png"><meta name="msapplication-config" content="assets/browserconfig.xml"><link rel="yandex-tableau-widget" href="assets/yandex-browser-manifest.json"><script defer="defer" src="js/chunk-vendors.50ce20a0.js"></script><script defer="defer" src="js/app.e04c574b.js"></script><link href="css/chunk-vendors.4e650cae.css" rel="stylesheet"><link href="css/app.67f6747d.css" rel="stylesheet"></head><body><noscript><strong>We're sorry but the Contao Manager does not work without JavaScript enabled. Please enable it to continue.</strong></noscript></body></html><?php

declare(strict_types=1);

/*
 * This file is part of Contao Manager.
 *
 * (c) Contao Association
 *
 * @license LGPL-3.0-or-later
 */

use Contao\ManagerApi\ApiKernel;
use Contao\ManagerApi\HttpKernel\ApiProblemResponse;
use Symfony\Component\HttpFoundation\Request;

require __DIR__.'/../vendor/autoload.php';

try {
    // @phpstan-ignore identical.alwaysFalse
    $kernel = new ApiKernel('@symfony_env@' === 'prod' ? 'prod' : 'dev');

    $request = Request::createFromGlobals();
    $response = $kernel->handle($request);
    $response->send();
    $kernel->terminate($request, $response);
} catch (Throwable $throwable) {
    ApiProblemResponse::createFromException($throwable, '@symfony_env@' !== 'prod')->send();
}
.view-recovery__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0 10px;text-align:center}.view-recovery__icon{background:var(--contao);border-radius:10px;padding:10px}.view-recovery__headline{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-recovery__content{margin:0 30px 50px}@media(min-width:960px){.view-recovery__content{margin-left:50px;margin-right:50px}}.view-recovery__description{font-weight:600;max-width:600px;margin:0 auto;text-align:center}.view-recovery__console{margin:30px 0 60px}.view-recovery__option{margin:50px 0 0;padding:20px 20px 30px;background:var(--table-odd-bg);text-align:center}.view-recovery__option h3{position:relative;top:-40px;margin-bottom:-25px;font-size:2em;font-weight:300}.view-recovery__option button{margin-top:1.5em}.view-recovery__failed{margin:10px 0;color:var(--btn-alert);font-weight:600}.boot-check{padding:10px}.boot-check:after{display:table;clear:both;content:""}.boot-check__icon{float:left}.boot-check__icon .sk-circle{width:34px;height:34px;margin:3px}.boot-check__icon svg{display:block;width:40px;height:40px}.boot-check__icon--success svg{fill:var(--btn-primary)}.boot-check__icon--info svg,.boot-check__icon--warning svg{fill:var(--btn-warning)}.boot-check__icon--error svg{fill:var(--btn-alert)}.boot-check__label{margin-left:50px}.boot-check__description,.boot-check__detail,.boot-check__title{margin:0;line-height:inherit;overflow:hidden;text-overflow:ellipsis}.boot-check__detail{margin-top:5px;font-size:12px}.boot-check__action{margin-left:50px}.boot-check__action button{margin:15px 0 10px;height:33px;line-height:33px}@media(min-width:960px){.boot-check__label{float:left;width:540px;margin-left:10px}.boot-check__action{float:right;margin:0 0 0 10px;width:140px;text-align:center}.boot-check__action button{margin:3px 0}.boot-check__action a[target=_blank]{display:inline-block;margin:10px 0;padding-left:20px;background:var(--svg--link-blank) left center no-repeat;background-size:16px 16px}}.view-boot__header{margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.view-boot__icon{background:var(--contao);border-radius:10px;padding:10px}.view-boot__headline{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-boot__description{margin:0;font-weight:600}.view-boot__loading{width:30px;margin:0 auto 40px}.view-boot__loading .sk-circle{width:30px;height:30px}.view-boot__checks{margin:0 16px 50px}.view-boot__checks .boot-check:nth-child(odd){border-radius:var(--border-radius);background:var(--table-odd-bg)}.view-boot__summary{margin:50px 0 0}.view-boot__summary--error svg{width:100%;height:40px;fill:var(--btn-alert)}.view-boot__issue{max-width:60%;margin:10px auto;text-align:center;color:var(--btn-alert);line-height:1.2em}.view-boot__safeMode{margin:2em auto 0}.view-boot__continue,.view-boot__safeMode{clear:both;display:block!important;width:220px!important}.view-boot__continue{margin:0 auto}@media(min-width:960px){.view-boot__checks{margin:0 80px 50px}}.view-login__header{max-width:280px;margin:0 auto 60px;padding-top:40px;text-align:center}.view-login__product{margin-top:15px;font-size:38px;font-weight:100;line-height:1}.view-login__form{position:relative;max-width:280px;margin:0 auto 60px}.view-login__form input{padding-right:30px;margin:5px 0 10px}.view-login__locked{max-width:290px;margin:-20px auto 60px;padding:20px;background:var(--btn-alert);color:#fff;text-align:center}.view-login__locked strong{white-space:pre}.view-login__headline{margin-bottom:0}.view-login__description{margin-top:.5em;margin-bottom:20px}.view-login label{position:absolute;text-indent:-999em;pointer-events:none}.view-login label[for=ctrl_username]{top:0;bottom:0;margin:auto;right:13px;width:16px;height:16px;background:url(../img/person.00d78897.svg) 0 0 no-repeat;background-size:16px 16px;z-index:10}.view-login label[for=ctrl_password]{top:0;bottom:0;margin:auto;right:12px;width:16px;height:16px;background:url(../img/lock.3c42a55f.svg) 0 0 no-repeat;background-size:14px 14px;z-index:10}.view-login__password input,.view-login__user input{margin:0}.view-login__user input{border-radius:var(--border-radius) var(--border-radius) 0 0!important}.view-login__password{margin-top:-1px;margin-bottom:10px}.view-login__password input{border-radius:0 0 var(--border-radius) var(--border-radius)!important}.view-login .widget-text--password button{opacity:0}.view-login__link{display:block;margin-top:2em;font-size:12px;text-align:center}.view-login__button{margin:3px 0}.view-login__button .sk-circle{color:#fff;text-align:center}.view-login__or{display:grid;gap:15px;grid-template-columns:1fr auto 1fr;padding:12px}.view-login__or:after,.view-login__or:before{align-self:center;border-top:1px solid var(--border);content:""}.view-login .fragment-footer{display:block}.widget-radio-button legend{margin-bottom:2px}.widget-radio-button>div{position:relative;margin:.25em 0}.widget-radio-button input{border:0;clip:rect(0 0 0 0);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;width:1px}.widget-radio-button label{display:block;padding-left:25px;background:url(../img/widget-radio--off.4e93f443.svg) 0 -1px no-repeat;background-size:20px 20px}.widget-radio-button input:checked+label{background-image:url(../img/widget-radio--on.181461b6.svg)}.widget-radio-button input:focus-visible+label{outline:5px auto Highlight;outline:5px auto -webkit-focus-ring-color}.widget-radio-button input:disabled+label{opacity:.5}.setup__directories{margin-top:2em}.setup__directories>dt{margin-top:1em;font-weight:600}.setup__directories>dd{margin:0;word-break:break-all}.setup__directories>dd span{background-color:var(--highlight-bg);color:var(--highlight-color);font-weight:400}.link-more{position:relative;display:inline-block}p:empty+.link-more{margin-left:0}.link-more button{width:auto;height:auto;padding:0 0 5px;background:transparent;color:var(--link);font-size:13px;font-weight:300;line-height:inherit;border:none;cursor:pointer}.link-more button:hover{text-decoration:underline}.link-more__menu{outline:none}.link-more ul{transform:translateX(-50%)}.package-link{display:flex;column-gap:8px;justify-content:space-between;width:100%;padding-bottom:4px;margin-bottom:4px;border-bottom:1px solid var(--border--light)}.package-link:last-child{padding-bottom:0;margin-bottom:0;border-bottom:none}.package-link__details{padding:5px 0;line-height:18px}.package-link__name{display:inline;font-weight:600}.package-link__name:after{content:": "}.package-link__text{display:inline}.package-link__actions{display:flex;margin-left:20px;margin:0 -4px}.package-link__actions>*{margin:0 4px}.package-link--limit .package-link__details{display:flex}.package-link--limit .package-link__name{white-space:nowrap}.package-link--limit .package-link__text{display:-webkit-box;overflow:hidden;line-clamp:1;-webkit-line-clamp:1;-webkit-box-orient:vertical;padding:0 10px 0 5px}.package-funding[data-v-5a8fd14b]{padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:rgba(var(--funding-rgb),.025) url(../img/funding.cf78a0a0.svg) 15px 50% no-repeat;background-size:23px 23px;border:1px solid rgba(var(--funding-rgb),.5);border-radius:6px}.package-funding>div[data-v-5a8fd14b]{overflow:hidden}.package-funding span[data-v-5a8fd14b]{margin-right:15px}.package-funding a[data-v-5a8fd14b]{position:relative;display:inline-block;margin:0 20px 0 0;padding-left:16px;color:var(--funding);background:url(../img/link-funding.b25cd92d.svg) 0 50% no-repeat;background-size:13px 13px}.package-funding a[data-v-5a8fd14b]:before{content:"|";position:absolute;left:-12px}.package-funding a[data-v-5a8fd14b]:nth-child(2):before{content:none}.package-popup{position:fixed;display:flex;flex-direction:column;justify-content:flex-start;width:100%;max-width:none;height:100%;background:var(--popup-bg);z-index:10;opacity:1}.package-popup>*{flex-basis:auto;flex-grow:1}.package-popup__loader{display:flex;flex-direction:column;align-items:center;justify-content:center;padding:50px 0}.package-popup__loader p{margin:1em}.package-popup__headline{position:relative;flex-grow:0;flex-shrink:1;padding:7px 30px 6px;background:var(--popup-hl-bg);color:#fff;font-size:18px;font-weight:300;line-height:1.5;text-align:center}.package-popup__button{display:block;float:right;position:absolute;top:0;margin:4px 0;padding:4px;background:none;border:1px solid transparent;border-radius:5px;cursor:pointer}.package-popup__button--previous{left:4px}.package-popup__button--close{right:4px}.package-popup__button svg{display:block;width:22px;height:22px}.package-popup__button:hover{background-color:#db6f00}.package-popup__summary{flex-grow:0;padding:25px 35px}@media(min-width:600px){.package-popup__summary{display:flex}}.package-popup__logo{border-radius:6px;float:right;height:60px;width:60px;margin-left:1em;background:#f7f7f7}@media(min-width:600px){.package-popup__logo{display:block;float:left;width:110px;height:110px;margin:-10px 16px 0 -10px}}.package-popup__icon{display:flex;align-items:center;justify-content:center;height:100%}.package-popup__icon--fallback{display:none}.package-popup__icon img{width:50px;height:50px;max-height:100%;object-fit:contain}@media(min-width:600px){.package-popup__icon img{width:90px;height:90px}}.package-popup__text{display:flex;flex-direction:column;flex-grow:1}@media(min-width:600px){.package-popup__text{width:200px}}.package-popup__title{margin:0;line-height:1.4;overflow-wrap:break-word}.package-popup__authors{flex-grow:1;font-size:13px;margin-bottom:.5em}.package-popup__author{display:inline-block;margin-right:2px}.package-popup__author:after{color:var(--text);content:", "}.package-popup__author:last-child:after{content:none}.package-popup__stats{display:inline-block;margin-right:15px;margin-top:.5em;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.package-popup__stats--private{padding-left:20px;background-image:var(--svg--private);background-size:15px 15px}.package-popup__stats--updated{background-image:var(--svg--updated)}.package-popup__stats--downloads{background-image:var(--svg--downloads)}.package-popup__stats--favers{background-image:var(--svg--favers)}.package-popup__actions{display:flex;flex-direction:column;gap:10px;margin-top:1em}@media(min-width:600px){.package-popup__actions{justify-content:space-between;margin:0 0 0 25px;width:200px}}.package-popup__installed{margin-top:1em}.package-popup__abandoned{margin:0 0 20px;padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:rgba(var(--hint-rgb),.3) url(../img/hint.ba2ac97e.svg) 15px 50% no-repeat;background-size:23px 23px;border:1px solid var(--hint-link);border-radius:6px}.package-popup__funding{margin:0 0 20px}.package-popup__tabs{position:relative;flex-grow:revert}.package-popup__tabs:after,.package-popup__tabs:before{content:"";display:block;position:absolute;top:0;bottom:1px;width:7px;background:linear-gradient(-90deg,transparent 0,var(--popup-bg) 50%);z-index:1;pointer-events:none}.package-popup__tabs:after{background:linear-gradient(90deg,transparent 0,var(--popup-bg) 50%);right:0}.package-popup__tabs-list{flex-shrink:0;flex-grow:0;display:flex;column-gap:4px;height:40px;min-width:100%;overflow-x:auto;scrollbar-width:none;overflow-y:hidden;margin:0;padding:0 7px;list-style-type:none}.package-popup__tabs-list:after{content:"";position:absolute;inset:auto 0 0;height:1px;background:var(--border--light);z-index:-1}.package-popup__tab{position:relative;top:1px;flex-grow:1;padding:0;height:39px;line-height:39px;text-align:center;border:1px solid var(--border--light);border-top-left-radius:6px;border-top-right-radius:6px}.package-popup__tab--active{background:var(--tab-content);border-bottom:1px solid var(--tab-content)}.package-popup__tab button{display:flex;justify-content:center;align-items:center;width:100%;height:100%;margin:0;padding:0 10px;border:none;background:transparent;cursor:pointer}.package-popup__tab button:disabled{color:var(--border)!important;cursor:not-allowed}.package-popup__pill{position:relative;top:-2px;display:inline-block;margin-left:5px;padding:2px 5px;font-size:10px;font-weight:400;background:var(--border--light);border-radius:40%}.package-popup__pill--highlight{color:var(--clr-btn);background:var(--btn-primary)}.package-popup__tabcontent{position:relative;padding:25px 35px;overflow-y:auto;background:var(--tab-content);outline:0}@media(min-width:960px)and (min-height:700px){.package-popup__tabcontent{height:450px}}.package-popup__description{margin:1em 0;white-space:pre-wrap}@media(min-width:960px){.package-popup{position:relative;display:block;top:0;left:50%;width:750px;margin-left:-375px;height:auto;border-radius:8px;transform:none}.package-popup__headline{border-radius:8px 8px 0 0}.package-popup__tabcontent{border-radius:0 0 8px 8px}}@media(min-width:960px)and (min-height:700px){.package-popup{position:absolute;top:50%;transform:translateY(-50%)}}.package-popup__installed strong{margin-right:5px}@media(min-width:600px){.package-popup__installed{display:flex;flex-direction:column;justify-content:flex-end;text-align:center}.package-popup__installed strong{display:block;margin:0}}.package-popup__update{background:var(--btn-primary) url(../img/button-update.ad79c617.svg) 15px 50% no-repeat;background-size:23px 23px}.package-popup__incompatible,.package-popup__update{margin:0 0 20px;padding:10px 20px 10px 50px;color:var(--clr-btn);border-radius:var(--border-radius)}.package-popup__incompatible{background:var(--contao) url(../img/button-incompatible.3eb2b686.svg) 15px 50% no-repeat;background-size:23px 23px}.package-popup__funding+.package-popup__update{margin-top:-10px}.theme-details__constraint{flex-grow:1}.file-tree{margin:0;padding:0;list-style:none}.file-tree__folder{position:relative;padding-left:20px}.file-tree__folder:before{content:"";position:absolute;left:10px;top:6px;width:0;height:0;border-top:5px solid transparent;border-bottom:5px solid transparent;border-left:5px solid var(--text);transition:transform .1s ease-in-out}.file-tree__folder--open:before{transform:rotate(90deg)}.file-tree__file{padding-left:20px}.file-tree button{background:none;border:none;font-weight:400;cursor:pointer}.setup__versions{margin:0;padding:0 0 0 15px}.setup__version{margin:.5em 0;text-align:left}.setup__version--warning{color:var(--btn-alert)}.setup__releaseplan{margin-top:1.5em}.setup__fielddesc--version{margin-bottom:-1em!important}.setup__core-features{margin:5px 0 0 5px;font-size:12px}.setup__theme-image{max-width:100%;height:auto;border:1px solid var(--border)}.setup__theme p{margin:1em 0}.setup__themes{padding:0 14px}.setup__themes-results{display:grid;gap:14px}@media(min-width:1024px){.setup__themes-results{grid-template-columns:repeat(2,1fr)}.setup__themes-results-item{flex-basis:calc(50% - 16px);margin-left:8px;margin-right:8px}}.setup__themes-item{border:1px solid var(--tiles-bdr)}.setup__themes-more{margin-top:20px;text-align:center}.setup__theme-search{margin:20px 0 0;text-align:center}.setup__theme-search--empty{padding-top:60px;background:url(../img/sad.c7de6e95.svg) top no-repeat;background-size:50px 50px}.setup__theme-search--offline{padding-top:60px;background:url(../img/offline.0c23d1ce.svg) top no-repeat;background-size:50px 50px}.setup__theme-search--loader .sk-circle{width:50px;height:50px;margin:0 auto 20px}.setup__theme-search button{margin-top:2em}.setup__fielddesc--warning{padding:10px 10px 10px 40px;background:var(--hint-bg) url(../img/hint.ba2ac97e.svg) 10px 10px no-repeat}.setup__tabs{margin:1em 0}.setup__tab-controls{display:flex}.setup__tab-control{flex-grow:1;padding:4px 10px;border:none;border-top:1px solid var(--border);border-left:1px solid var(--border);background:none;cursor:pointer}.setup__tab-control:last-child{border-right:1px solid var(--border)}.setup__tab-control--active{border-color:var(--btn);background:var(--btn);color:#fff}.setup__tab{border:1px solid var(--border)}.setup__tab--files{white-space:pre;overflow:scroll;height:200px}.setup__requires{width:100%;border-collapse:collapse}.setup__requires td,.setup__requires th{margin:0;padding:3px 10px;text-align:start;vertical-align:top}.setup__requires th{background:var(--btn);color:#fff}.setup__requires td{border-bottom:1px solid var(--border)}.setup__requires tr:last-child td{border-bottom:none}.setup__requires tr:nth-child(odd) td{background:var(--table-odd-bg)}.setup__theme-upload{padding:0 50px;text-align:center}@media(min-width:960px){.setup__theme-upload{padding:0 150px}}.setup__or{position:relative;overflow:hidden;margin:1em 0;text-align:center}.setup__or:before{content:"";position:absolute;top:.8em;left:0;right:0;display:block;height:1px;background:var(--border);z-index:1}.setup__or span{position:relative;padding:0 10px;background:var(--popup-bg);z-index:2}.view-setup{padding-top:40px}.view-setup footer{margin-top:40px}.view-setup__steps{padding:0 0 50px 0}.view-setup__steps ul{display:flex;margin:0;padding:0;list-style-type:none}.view-setup__steps li{display:flex;justify-content:center;align-items:center;flex-grow:1;position:relative;height:6px;margin:0;padding:0}.view-setup__steps li:before{content:"";position:absolute;left:-50%;right:50%;background:var(--border);height:5px}.view-setup__steps li:after{content:"";position:absolute;top:-18px;left:50%;margin-left:-21px;width:42px;height:42px;color:#fff;text-indent:0;text-align:center;line-height:35px;background:var(--border);border-radius:50%;z-index:1}.view-setup__steps li:first-child:before{content:none}.view-setup__steps li.active:after,.view-setup__steps li.active:before{background:var(--contao)}.view-setup__steps button{display:flex;justify-content:center;align-items:center;background:transparent;border:none;z-index:10;cursor:pointer}.view-setup__steps button:disabled{cursor:default}.view-setup__steps svg{fill:#fff}.view-setup__main{text-align:center}.view-setup__party{font-size:64px}.view-setup__headline{margin:10px 0 20px;padding:15px 0;font-size:42px;font-weight:100}.view-setup__description{max-width:500px;margin:1em 25px}.view-setup__start.widget-button{height:50px;margin:30px 10px 0;padding:0 50px;font-size:1.2em;line-height:50px}.view-setup__continue.widget-button{width:80%!important;margin:10px 0 0}.view-setup__funding{width:80%;margin:50px auto 0;padding:20px 25px;border:2px solid var(--funding);border-radius:var(--border-radius);background:rgba(var(--funding-rgb),.025);font-weight:400}.view-setup__funding figure{margin-bottom:1em}.view-setup__funding p{margin:0 0 .5em 0}.view-setup__funding-link{margin:1em 0 0}@media(min-width:960px){.view-setup{padding-top:80px}.view-setup footer{margin-top:80px}.view-setup__steps{padding-bottom:80px}.view-setup__headline{margin:20px 0 40px;font-size:64px}.view-setup__continue.widget-button{width:auto!important;margin:25px 10px 0;padding:0 20px}.view-setup__description{max-width:550px;margin:1em auto;font-size:1.2em}.view-setup__funding{display:flex;margin:60px auto -20px;text-align:left}.view-setup__funding figure{margin-right:25px}}.setup__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.setup__header .widget-button{margin-top:1em}.setup__icon{background:var(--contao);border-radius:10px;padding:10px}.setup__headline{margin-top:20px;margin-bottom:25px;font-size:36px;font-weight:100;line-height:1}.setup__description,.setup__warning{margin:1em 0;text-align:justify}.setup__warning{color:var(--btn-alert);font-weight:600}.setup__form{position:relative;max-width:280px;margin:0 auto 50px;opacity:1}.setup__form svg.setup__check{display:block;width:80px;height:80px;margin:0 auto 2em;fill:var(--btn-primary)}.setup__form .widget-select,.setup__form .widget-text{margin-top:10px}.setup__form .widget-select label,.setup__form .widget-text label{display:block;margin-bottom:5px;font-weight:400}.setup__form .widget-checkbox{margin-top:20px;font-weight:400}.setup__form .widget-radio-button{margin-top:20px}.setup__fields{margin-bottom:2em}.setup__fields--center{text-align:center}.setup__fields .button-group .widget-button{margin-bottom:1px}.setup__fieldtitle{margin-bottom:.5em;font-size:18px;font-weight:600;line-height:30px}.setup__fielddesc{margin-bottom:1em;text-align:left}.setup__fielddesc code{word-break:break-word}.setup__actions{display:flex;flex-wrap:wrap;gap:10px}.setup__actions--center{justify-content:center}.setup__actions .button-group,.setup__actions .widget-button{flex-grow:1}.setup__actions .button-group--inline,.setup__actions .widget-button--inline{flex-grow:0}@media(min-width:960px){.setup{padding-top:100px}.setup__header{float:left;width:470px;max-width:none;padding:0 60px 50px}.setup__form{float:left;width:370px;max-width:none;margin:0 50px 50px}.setup__form .widget-select label,.setup__form .widget-text label{display:block;float:left;width:120px;padding-top:10px;font-weight:400}.setup__form .widget-select input,.setup__form .widget-select select,.setup__form .widget-text input,.setup__form .widget-text select{width:250px!important}}.config-check__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.config-check__icon{background:var(--contao);border-radius:10px;padding:10px}.config-check__headline{margin-top:20px;margin-bottom:25px;font-size:36px;font-weight:100;line-height:1}.config-check__description{text-align:justify}.config-check__form{position:relative;max-width:280px;margin:0 auto 50px}.config-check__form .widget-select,.config-check__form .widget-text{margin-top:20px}.config-check__form .widget-select label,.config-check__form .widget-text label{display:block;margin-bottom:5px;font-weight:400}.config-check__fields{margin-bottom:2em}.config-check__fieldtitle{margin-bottom:.5em;font-size:18px;font-weight:600;line-height:30px}.config-check__fielddesc{margin-bottom:1em}.config-check__issues{margin-bottom:1em;color:var(--btn-alert)}.config-check__issues p{font-weight:600}.config-check__issues ul{margin:0;padding:0}.config-check__issues li{margin:.5em 0 0 25px;padding:0}.config-check .widget-button{margin-bottom:.5em}@media(min-width:960px){.config-check{padding-top:100px}.config-check__header{float:left;width:470px;max-width:none;padding:0 60px 100px}.config-check__form{float:left;width:370px;max-width:none;margin:20px 50px 0;padding-bottom:100px}.config-check__form .widget-select label,.config-check__form .widget-text label{display:block;float:left;width:120px;padding-top:10px;font-weight:400}}.database-migration__header{margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.database-migration__icon{background:var(--contao);border-radius:10px;padding:10px}.database-migration__headline{margin-top:.5em;margin-bottom:.5em;font-size:36px;font-weight:100;line-height:1}.database-migration__description{margin:0 50px;font-weight:600}.database-migration__actions{display:flex;flex-direction:column;justify-content:center;align-items:center;margin-top:2em;padding:0 50px}@media(min-width:960px){.database-migration__actions{flex-direction:row}}.database-migration .widget-button{width:280px;height:35px;margin:5px;padding:0 30px;line-height:35px}@media(min-width:960px){.database-migration .widget-button{width:auto}}.database-migration__main{margin:0 50px 50px;background:#24292e}.database-migration__loading{width:30px;margin:40px auto}.database-migration__loading .sk-circle{width:30px;height:30px}.link-more{position:relative;display:inline-block}p:empty+.link-more{margin-left:0}.link-more button{width:auto;height:auto;padding:0 0 5px;background:transparent;color:var(--link);font-size:13px;font-weight:300;line-height:inherit;border:none;cursor:pointer}.link-more button:hover{text-decoration:underline}.link-more__menu{outline:none}.link-more ul{transform:translateX(-50%)}.package-link{display:flex;column-gap:8px;justify-content:space-between;width:100%;padding-bottom:4px;margin-bottom:4px;border-bottom:1px solid var(--border--light)}.package-link:last-child{padding-bottom:0;margin-bottom:0;border-bottom:none}.package-link__details{padding:5px 0;line-height:18px}.package-link__name{display:inline;font-weight:600}.package-link__name:after{content:": "}.package-link__text{display:inline}.package-link__actions{display:flex;margin-left:20px;margin:0 -4px}.package-link__actions>*{margin:0 4px}.package-link--limit .package-link__details{display:flex}.package-link--limit .package-link__name{white-space:nowrap}.package-link--limit .package-link__text{display:-webkit-box;overflow:hidden;line-clamp:1;-webkit-line-clamp:1;-webkit-box-orient:vertical;padding:0 10px 0 5px}.package-funding[data-v-5a8fd14b]{padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:rgba(var(--funding-rgb),.025) url(../img/funding.cf78a0a0.svg) 15px 50% no-repeat;background-size:23px 23px;border:1px solid rgba(var(--funding-rgb),.5);border-radius:6px}.package-funding>div[data-v-5a8fd14b]{overflow:hidden}.package-funding span[data-v-5a8fd14b]{margin-right:15px}.package-funding a[data-v-5a8fd14b]{position:relative;display:inline-block;margin:0 20px 0 0;padding-left:16px;color:var(--funding);background:url(../img/link-funding.b25cd92d.svg) 0 50% no-repeat;background-size:13px 13px}.package-funding a[data-v-5a8fd14b]:before{content:"|";position:absolute;left:-12px}.package-funding a[data-v-5a8fd14b]:nth-child(2):before{content:none}.package-popup{position:fixed;display:flex;flex-direction:column;justify-content:flex-start;width:100%;max-width:none;height:100%;background:var(--popup-bg);z-index:10;opacity:1}.package-popup>*{flex-basis:auto;flex-grow:1}.package-popup__loader{display:flex;flex-direction:column;align-items:center;justify-content:center;padding:50px 0}.package-popup__loader p{margin:1em}.package-popup__headline{position:relative;flex-grow:0;flex-shrink:1;padding:7px 30px 6px;background:var(--popup-hl-bg);color:#fff;font-size:18px;font-weight:300;line-height:1.5;text-align:center}.package-popup__button{display:block;float:right;position:absolute;top:0;margin:4px 0;padding:4px;background:none;border:1px solid transparent;border-radius:5px;cursor:pointer}.package-popup__button--previous{left:4px}.package-popup__button--close{right:4px}.package-popup__button svg{display:block;width:22px;height:22px}.package-popup__button:hover{background-color:#db6f00}.package-popup__summary{flex-grow:0;padding:25px 35px}@media(min-width:600px){.package-popup__summary{display:flex}}.package-popup__logo{border-radius:6px;float:right;height:60px;width:60px;margin-left:1em;background:#f7f7f7}@media(min-width:600px){.package-popup__logo{display:block;float:left;width:110px;height:110px;margin:-10px 16px 0 -10px}}.package-popup__icon{display:flex;align-items:center;justify-content:center;height:100%}.package-popup__icon--fallback{display:none}.package-popup__icon img{width:50px;height:50px;max-height:100%;object-fit:contain}@media(min-width:600px){.package-popup__icon img{width:90px;height:90px}}.package-popup__text{display:flex;flex-direction:column;flex-grow:1}@media(min-width:600px){.package-popup__text{width:200px}}.package-popup__title{margin:0;line-height:1.4;overflow-wrap:break-word}.package-popup__authors{flex-grow:1;font-size:13px;margin-bottom:.5em}.package-popup__author{display:inline-block;margin-right:2px}.package-popup__author:after{color:var(--text);content:", "}.package-popup__author:last-child:after{content:none}.package-popup__stats{display:inline-block;margin-right:15px;margin-top:.5em;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.package-popup__stats--private{padding-left:20px;background-image:var(--svg--private);background-size:15px 15px}.package-popup__stats--updated{background-image:var(--svg--updated)}.package-popup__stats--downloads{background-image:var(--svg--downloads)}.package-popup__stats--favers{background-image:var(--svg--favers)}.package-popup__actions{display:flex;flex-direction:column;gap:10px;margin-top:1em}@media(min-width:600px){.package-popup__actions{justify-content:space-between;margin:0 0 0 25px;width:200px}}.package-popup__installed{margin-top:1em}.package-popup__abandoned{margin:0 0 20px;padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:rgba(var(--hint-rgb),.3) url(../img/hint.ba2ac97e.svg) 15px 50% no-repeat;background-size:23px 23px;border:1px solid var(--hint-link);border-radius:6px}.package-popup__funding{margin:0 0 20px}.package-popup__tabs{position:relative;flex-grow:revert}.package-popup__tabs:after,.package-popup__tabs:before{content:"";display:block;position:absolute;top:0;bottom:1px;width:7px;background:linear-gradient(-90deg,transparent 0,var(--popup-bg) 50%);z-index:1;pointer-events:none}.package-popup__tabs:after{background:linear-gradient(90deg,transparent 0,var(--popup-bg) 50%);right:0}.package-popup__tabs-list{flex-shrink:0;flex-grow:0;display:flex;column-gap:4px;height:40px;min-width:100%;overflow-x:auto;scrollbar-width:none;overflow-y:hidden;margin:0;padding:0 7px;list-style-type:none}.package-popup__tabs-list:after{content:"";position:absolute;inset:auto 0 0;height:1px;background:var(--border--light);z-index:-1}.package-popup__tab{position:relative;top:1px;flex-grow:1;padding:0;height:39px;line-height:39px;text-align:center;border:1px solid var(--border--light);border-top-left-radius:6px;border-top-right-radius:6px}.package-popup__tab--active{background:var(--tab-content);border-bottom:1px solid var(--tab-content)}.package-popup__tab button{display:flex;justify-content:center;align-items:center;width:100%;height:100%;margin:0;padding:0 10px;border:none;background:transparent;cursor:pointer}.package-popup__tab button:disabled{color:var(--border)!important;cursor:not-allowed}.package-popup__pill{position:relative;top:-2px;display:inline-block;margin-left:5px;padding:2px 5px;font-size:10px;font-weight:400;background:var(--border--light);border-radius:40%}.package-popup__pill--highlight{color:var(--clr-btn);background:var(--btn-primary)}.package-popup__tabcontent{position:relative;padding:25px 35px;overflow-y:auto;background:var(--tab-content);outline:0}@media(min-width:960px)and (min-height:700px){.package-popup__tabcontent{height:450px}}.package-popup__description{margin:1em 0;white-space:pre-wrap}@media(min-width:960px){.package-popup{position:relative;display:block;top:0;left:50%;width:750px;margin-left:-375px;height:auto;border-radius:8px;transform:none}.package-popup__headline{border-radius:8px 8px 0 0}.package-popup__tabcontent{border-radius:0 0 8px 8px}}@media(min-width:960px)and (min-height:700px){.package-popup{position:absolute;top:50%;transform:translateY(-50%)}}.package-popup__installed strong{margin-right:5px}@media(min-width:600px){.package-popup__installed{display:flex;flex-direction:column;justify-content:flex-end;text-align:center}.package-popup__installed strong{display:block;margin:0}}.package-popup__update{background:var(--btn-primary) url(../img/button-update.ad79c617.svg) 15px 50% no-repeat;background-size:23px 23px}.package-popup__incompatible,.package-popup__update{margin:0 0 20px;padding:10px 20px 10px 50px;color:var(--clr-btn);border-radius:var(--border-radius)}.package-popup__incompatible{background:var(--contao) url(../img/button-incompatible.3eb2b686.svg) 15px 50% no-repeat;background-size:23px 23px}.package-popup__funding+.package-popup__update{margin-top:-10px}.view-account__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.view-account__product{margin-top:15px;margin-bottom:40px;font-weight:600}.view-account__product strong{display:block;margin-bottom:10px;font-size:54px;font-weight:100;line-height:1}.view-account__headline{margin-bottom:.5em;font-size:18px;font-weight:600;line-height:30px}.view-account__description{margin-bottom:1em;text-align:justify}.view-account__form,.view-account__totp{position:relative;max-width:280px;margin:0 auto}.view-account__form .widget-button,.view-account__totp .widget-button{margin-top:1.5em}.view-account__form .widget-text{margin-top:10px}.view-account__form .widget-text label{display:block;padding-bottom:5px}.view-account__contribute{max-width:280px;margin:60px auto 0;font-size:12px;text-align:center}.view-account__contribute br{display:none}@media(min-width:960px){.view-account{display:flex;flex-flow:row wrap;align-items:center;padding-top:50px}.view-account__form,.view-account__header,.view-account__totp{padding:50px;width:50%;max-width:none}.view-account__form .widget-text label{float:left;width:120px;padding-top:10px;font-weight:400}.view-account__form input[type=password],.view-account__form input[type=text],.view-account__form select{width:250px!important}.view-account__form .button-group,.view-account__form .widget-button--anchor{width:250px;margin-left:120px}.view-account__contribute{max-width:840px}.view-account__contribute br{display:block}}.popup-overlay{position:fixed;inset:0;z-index:1000;background:var(--popup-overlay-bg)}@media(min-width:960px){.popup-overlay{padding:20px 0;overflow-y:auto}}.popup-overlay__popup{position:fixed;display:block;top:50%;left:50%;width:500px;max-width:90%;background:var(--popup-bg);z-index:10;opacity:1;transform:translate(-50%,-50%);border-radius:var(--border-radius);overflow:hidden}.popup-overlay__headline{position:relative;margin-bottom:0;padding:7px 30px 6px;background:var(--popup-hl-bg);font-size:18px;color:#fff;font-weight:300;line-height:1.5em;text-align:center}.popup-overlay__headline--primary{background-color:var(--btn-primary)}.popup-overlay__headline--alert{background-color:var(--btn-alert)}.popup-overlay__content{padding:2em 20px}.popup-overlay__actions{display:flex;justify-content:center;gap:10px;flex-wrap:wrap;padding:0 20px 2em}.popup-overlay__actions .widget-button{width:auto;height:35px;padding:0 30px;line-height:35px}@media(min-width:550px){.popup-overlay__actions,.popup-overlay__content{padding-left:40px;padding-right:40px}}.loader__item{float:left;width:16px;height:16px;margin-right:1px;background-color:var(--contao);animation:loading 1.4s ease-in-out infinite both}.loader__item--20{animation-delay:-.64s}.loader__item--40{animation-delay:-.48s}.loader__item--60{animation-delay:-.32s}.loader__item--80{animation-delay:-.16s}@keyframes loading{0%,90%,to{opacity:0}20%{opacity:1}}.loader__text{float:left;width:40px}.sk-circle{width:25px;height:25px;position:relative}.sk-circle .sk-child{width:100%;height:100%;position:absolute;left:0;top:0}.sk-circle .sk-child:before{content:"";display:block;margin:0 auto;width:15%;height:15%;background-color:var(--text);border-radius:100%;animation:sk-circleBounceDelay 1.2s ease-in-out infinite both}.sk-circle .sk-circle2{transform:rotate(30deg)}.sk-circle .sk-circle3{transform:rotate(60deg)}.sk-circle .sk-circle4{transform:rotate(90deg)}.sk-circle .sk-circle5{transform:rotate(120deg)}.sk-circle .sk-circle6{transform:rotate(150deg)}.sk-circle .sk-circle7{transform:rotate(180deg)}.sk-circle .sk-circle8{transform:rotate(210deg)}.sk-circle .sk-circle9{transform:rotate(240deg)}.sk-circle .sk-circle10{transform:rotate(270deg)}.sk-circle .sk-circle11{transform:rotate(300deg)}.sk-circle .sk-circle12{transform:rotate(330deg)}.sk-circle .sk-circle2:before{animation-delay:-1.1s}.sk-circle .sk-circle3:before{animation-delay:-1s}.sk-circle .sk-circle4:before{animation-delay:-.9s}.sk-circle .sk-circle5:before{animation-delay:-.8s}.sk-circle .sk-circle6:before{animation-delay:-.7s}.sk-circle .sk-circle7:before{animation-delay:-.6s}.sk-circle .sk-circle8:before{animation-delay:-.5s}.sk-circle .sk-circle9:before{animation-delay:-.4s}.sk-circle .sk-circle10:before{animation-delay:-.3s}.sk-circle .sk-circle11:before{animation-delay:-.2s}.sk-circle .sk-circle12:before{animation-delay:-.1s}@keyframes sk-circleBounceDelay{0%,80%,to{transform:scale(0)}40%{transform:scale(1)}}.widget-button .loader{width:25px;margin:0 auto}.widget-button .sk-circle .sk-child:before{background-color:#fff}.loading-button{position:relative}.loading-button>.loader{position:absolute;left:calc(50% - 12.5px);top:calc(50% - 12.5px)}.loading-button>.loading{visibility:hidden}.link-menu{position:absolute;display:grid;grid-template:1fr/1fr;left:50%;gap:2px;margin:0;padding:2px;text-align:center;list-style-type:none;white-space:nowrap;background:var(--form-bg);border-top:3px solid var(--text);border-radius:5px;z-index:100;box-shadow:0 0 1px var(--shadow);outline:none}.link-menu:before{position:absolute;left:50%;top:-7px;width:0;height:0;margin-left:-4px;border-style:solid;border-width:0 3.5px 4px 3.5px;border-color:transparent transparent var(--text) transparent;content:""}.link-menu--align-left{left:0;right:auto}.link-menu--align-left:before{left:17px;right:auto}.link-menu--align-right{left:auto;right:0}.link-menu--align-right:before{left:auto;right:17px}.link-menu--valign-top{bottom:0;border-top:none;border-bottom:3px solid var(--text);box-shadow:0 0 2px var(--shadow)}.link-menu--valign-top:before{top:auto;bottom:-7px;border-width:4px 3.5px 0 3.5px;border-color:var(--text) transparent transparent transparent}.link-menu--contao{border-color:var(--contao)}.link-menu--contao:before{border-bottom-color:var(--contao)}.link-menu--contao.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--contao)}.link-menu--primary{border-color:var(--btn-primary)}.link-menu--primary:before{border-bottom-color:var(--btn-primary)}.link-menu--primary.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--btn-primary)}.link-menu--warning{border-color:var(--btn-warning)}.link-menu--warning:before{border-bottom-color:var(--btn-warning)}.link-menu--warning.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--btn-warning)}.link-menu--alert{border-color:var(--btn-alert)}.link-menu--alert:before{border-bottom-color:var(--btn-alert)}.link-menu--alert.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--btn-alert)}.link-menu__item{margin:0;padding:0;display:block}.link-menu__action{display:block;width:100%;border-radius:5px;padding:8px 16px;color:var(--text);font-size:inherit;text-align:center;background:none;border:none;cursor:pointer}.link-menu__action:hover{color:var(--text);background:var(--focus);text-decoration:none}.link-menu__action--active{font-weight:600;background:var(--focus)}.footer-languages{position:relative;display:inline-block}.footer-languages__toggle{width:auto;height:auto;padding:0 0 0 25px;background:transparent;color:var(--text);font-size:12px;font-weight:300;line-height:20px;background:var(--svg--language) left center no-repeat;background-size:20px 20px;border:none;cursor:pointer}.footer-languages__toggle:hover{color:var(--black)}.footer-languages__menu{display:grid;grid-template:auto/1fr 1fr;bottom:25px;white-space:nowrap;transform:translateX(-50%)}.footer-languages__menu button{margin:0;padding:6px;text-align:left;font-size:inherit}.theme-switch{position:relative;display:inline-block}.theme-switch button{width:auto;height:auto;padding:0 0 0 24px;background:transparent;color:var(--text);font-size:12px;font-weight:300;line-height:20px;background:var(--svg--color-scheme) left center no-repeat;background-size:20px 20px;border:none;cursor:pointer}.theme-switch button:hover{color:var(--black)}.package-logo--fallback[data-v-9c1c5f6c]{display:flex;justify-content:center;align-items:center}svg[data-v-9c1c5f6c]{width:80px;height:80px;fill:#ccc}.discover-package{display:flex;flex-direction:column;position:relative;overflow:hidden;background:var(--tiles-bg);border:1px solid var(--tiles-bdr);border-radius:14px}.discover-package.is--hint{border-color:var(--border--light)}.discover-package.is--hint .discover-package__inside>*{opacity:.65}.discover-package__hint{position:relative;background:var(--border--light);padding:8px 16px;font-weight:400;font-size:12px;line-height:1.2;z-index:1}.discover-package__hint p a{display:inline-block;padding-right:10px}.discover-package__hint p a:first-child{margin-left:10px}.discover-package__hint p a:not(:first-child):before{padding-right:10px;content:"|"}.discover-package__inside{flex-grow:1;padding:16px}.discover-package__abandoned{display:inline-block;margin-bottom:1em;padding:2px 5px;color:#fff;font-size:12px;font-weight:600;background:var(--btn-alert);cursor:help;z-index:10}@media(min-width:600px){.discover-package__abandoned{position:absolute;top:20px;left:-25px;padding:2px 30px;border-top:1px solid var(--btn-alert-active);transform:rotate(-45deg)}}.discover-package__icon{border-radius:6px;height:60px;width:60px;background:#f7f7f7;margin:0 auto 10px;position:absolute;right:16px}.discover-package__icon>figure{display:flex;align-items:center;justify-content:center;height:100%;max-height:140px}.discover-package__icon img,.discover-package__icon svg{border-radius:4px;width:50px;height:50px;max-height:100%;object-fit:contain}.discover-package__details{display:flex;flex-direction:column;justify-content:space-between;min-height:96px}.discover-package__headline{margin-bottom:.2em;line-height:1;overflow-wrap:break-word;margin-right:70px}.discover-package__headline em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.discover-package__versions{display:flex;flex-wrap:wrap;gap:5px;list-style:none;margin:5px 0;padding:0}.discover-package__version{display:inline-flex;justify-content:center;padding:3px 5px;border-radius:4px;line-height:1;min-width:40px;font-size:13px;color:#fff;background:var(--badge-bg);pointer-events:none}.discover-package__description{display:-webkit-box;overflow:hidden;-webkit-line-clamp:2;-webkit-box-orient:vertical;margin-bottom:1em;margin-right:70px}.discover-package__description em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.discover-package__more{display:flex;flex-flow:row wrap;align-items:flex-end;flex-grow:1;gap:4px;line-height:28px}.discover-package__counts{flex-grow:1;justify-content:flex-start}.discover-package__count{display:inline-block;margin-right:15px;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.discover-package__count--private{background-image:var(--svg--private)}.discover-package__count--updated{background-image:var(--svg--updated)}.discover-package__count--downloads{background-image:var(--svg--downloads)}.discover-package__count--favers{background-image:var(--svg--favers)}.discover-package__actions{flex-grow:1;display:flex;justify-content:flex-end;gap:8px}@media(max-width:599.98px){.discover-package__headline-container{display:flex;flex-direction:column-reverse}}@media(min-width:600px){.discover-package__inside{text-align:initial;display:flex;padding:0}.discover-package__icon{width:130px;height:100%;min-height:130px;margin:0;border-radius:0;position:revert;right:revert}.discover-package__icon img{width:100px;height:100px}.discover-package__icon svg{width:90px;height:90px}.discover-package__details{padding:16px;height:100%;min-height:90px;max-width:calc(100% - 130px);flex:1}.discover-package__versions{float:right;margin:-3px 0 0 16px}.discover-package__description,.discover-package__headline{margin-right:0}.discover-package__more{flex-direction:row}.discover-package__actions{justify-content:end}}.vueperslide{white-space:normal;background-size:cover;flex-shrink:0;display:block;width:100%;position:relative}.vueperslide--clone-1{position:absolute;top:0;bottom:0;right:100%}.vueperslides--rtl .vueperslide--clone-1{right:auto;left:100%}.vueperslide[href]{-webkit-user-drag:none}.vueperslide__image{background-size:cover}.vueperslide__image,.vueperslide__loader{position:absolute;top:0;left:0;right:0;bottom:0}.vueperslide__loader{display:flex;flex-direction:column;align-items:center;justify-content:center}.vueperslide__content-wrapper:not(.vueperslide__content-wrapper--outside-top):not(.vueperslide__content-wrapper--outside-bottom){height:100%;margin:auto}.vueperslides--fade .vueperslide{position:absolute;top:0;left:0;right:0;bottom:0;opacity:0;transition:opacity ease-in-out;transition-duration:inherit}.vueperslides--fade .vueperslide--active,.vueperslides--fade .vueperslide--visible{z-index:1;opacity:1}.vueperslides--slide-image-inside .vueperslide{overflow:hidden}.vueperslides--3d .vueperslide{position:absolute;z-index:-1;height:100%}.vueperslides--3d .vueperslide--active,.vueperslides--3d .vueperslide--next-slide,.vueperslides--3d .vueperslide--previous-slide{z-index:0}.vueperslides--3d .vueperslide--active{z-index:1}.vueperslides--3d .vueperslide[face=front]{transform:rotateY(90deg) translate(-50%) rotateY(-90deg)}.vueperslides--3d .vueperslide[face=right]{transform:rotateY(90deg) translate(50%);transform-origin:100% 0}.vueperslides--3d .vueperslide[face=back]{transform:rotateY(270deg) translate(-50%) rotateY(-90deg)}.vueperslides--3d .vueperslide[face=left]{transform:rotateY(270deg) translate(-50%);transform-origin:0 0}.vueperslides:not(.no-shadow):not(.vueperslides--3d) .vueperslides__parallax-wrapper:after,.vueperslides:not(.no-shadow):not(.vueperslides--3d) .vueperslides__parallax-wrapper:before{content:"";position:absolute;bottom:100%;left:-1em;right:-1em;height:2em;box-shadow:0 0 20px #00000040;z-index:2}.vueperslides:not(.no-shadow):not(.vueperslides--3d) .vueperslides__parallax-wrapper:after{top:100%;bottom:auto}.vueperslides__arrows{color:#fff}.vueperslides__arrows--outside{color:currentColor}.vueperslides__arrow{top:50%;background-color:transparent;border:none;opacity:.7}.vueperslides--rtl .vueperslides__arrow--next,.vueperslides__arrow--prev{right:auto;left:.5em}.vueperslides--rtl .vueperslides__arrow--prev,.vueperslides__arrow--next{left:auto;right:.5em}.vueperslides__arrow:hover{opacity:1}.vueperslides--rtl .vueperslides__arrows--outside .vueperslides__arrow--next,.vueperslides__arrows--outside .vueperslides__arrow--prev{right:auto;left:-3.5em}.vueperslides--rtl .vueperslides__arrows--outside .vueperslides__arrow--prev,.vueperslides__arrows--outside .vueperslides__arrow--next{left:auto;right:-3.5em}.vueperslides__paused{top:.7em;right:.7em;opacity:0;text-shadow:0 0 3px rgba(0,0,0,.4);z-index:1}.vueperslides:hover .vueperslides__paused{opacity:1}.vueperslides__bullets:not(.vueperslides__bullets--outside){color:#fff}.vueperslides__bullet{margin:1.5em .6em;padding:0;border:none;background:none}.vueperslides__bullet .default{width:12px;height:12px;border-radius:12px;border:1px solid currentColor;background-color:transparent;box-shadow:0 0 1px #00000080,0 0 3px #0000004d;transition:.4s ease-in-out;box-sizing:border-box}.vueperslides__bullet .default span{display:none}.vueperslides__bullet--active .default{border-width:6px}.vueperslide,.vueperslide__image{background-position:50%}.vueperslide__video{outline:none}.vueperslide--no-pointer-events:before{content:"";position:absolute;top:0;bottom:0;left:0;right:0}.vueperslide__content-wrapper:not(.vueperslide__content-wrapper--outside-top):not(.vueperslide__content-wrapper--outside-bottom){display:flex;flex:1 1 auto;flex-direction:column;align-items:center;justify-content:center;text-align:center}.vueperslide--has-image-inside .vueperslide__content-wrapper,.vueperslide--has-video .vueperslide__content-wrapper,.vueperslide__content-wrapper.parallax-fixed-content{position:absolute;z-index:2;top:0;bottom:0;left:0;right:0;display:flex;flex-direction:column;justify-content:center;align-items:center;pointer-events:none}.vueperslides{position:relative}.vueperslides--fixed-height .vueperslide,.vueperslides--fixed-height .vueperslides__inner,.vueperslides--fixed-height .vueperslides__parallax-wrapper{height:inherit}.vueperslides--fixed-height .vueperslides__parallax-wrapper{padding-bottom:0!important}.vueperslides--fixed-height.vueperslides--bullets-outside{margin-bottom:4em}.vueperslides__inner{position:relative;-webkit-user-select:none;-moz-user-select:none;user-select:none}.vueperslides__parallax-wrapper{position:relative;overflow:hidden}.vueperslides--3d .vueperslides__parallax-wrapper{overflow:visible}.vueperslides__track{position:absolute;top:0;height:100%;left:0;right:0;overflow:hidden;z-index:1}.vueperslides--parallax .vueperslides__track{height:200%;transform:translateY(0)}.vueperslides--touchable .vueperslides__track{cursor:ew-resize;cursor:grab}.vueperslides--touchable .vueperslides__track--dragging,.vueperslides--touchable .vueperslides__track--mousedown{cursor:grabbing}.vueperslides--3d .vueperslides__track{overflow:visible;perspective:100em}.vueperslides__track-inner{white-space:nowrap;transition:transform .5s ease-in-out;height:100%;display:flex}.vueperslides--no-animation .vueperslides__track-inner{transition-duration:0s!important}.vueperslides--fade .vueperslides__track-inner{white-space:normal;transition:none}.vueperslides--3d .vueperslides__track-inner{transform-style:preserve-3d}.vueperslides__track--mousedown .vueperslides__track-inner{transition:transform .25s ease-in-out!important}.vueperslides__track--dragging .vueperslides__track-inner{transition:none}.vueperslides__arrow{position:absolute;font-size:inherit;color:inherit;text-align:center;transform:translateY(-50%);transition:.3s ease-in-out;cursor:pointer;-webkit-user-select:none;-moz-user-select:none;user-select:none;outline:none;z-index:2;line-height:1}.vueperslides__arrow svg{vertical-align:middle;stroke:currentColor;fill:none;width:3.5em;padding:1em;stroke-width:1;transition:.3s ease-in-out;box-sizing:border-box}.vueperslides__arrow svg:hover{stroke-width:1.3}.vueperslides__paused{position:absolute;transition:.3s ease-in-out}.vueperslides__bullets{display:flex;justify-content:center;position:absolute;bottom:0;left:0;right:0}.vueperslides__bullets--outside{position:relative}.vueperslides__bullet,.vueperslides__bullets button{cursor:pointer;-webkit-user-select:none;-moz-user-select:none;user-select:none;outline:none;z-index:2;display:flex;justify-content:center;align-items:center;color:inherit}.vueperslides__bullet::-moz-focus-inner,.vueperslides__bullets button::-moz-focus-inner{border:0}.vueperslides__fractions{position:absolute;top:.8em;left:.5em;z-index:2;padding:.2em 1em;border:1px solid hsla(0,0%,100%,.5);border-radius:2em;background:#fff3;color:#fff}.vueperslides__progress{position:absolute;top:0;left:0;right:0;z-index:2;height:6px;color:#000000b3}.vueperslides__progress>*{position:absolute;top:0;bottom:0;left:0;background:currentColor;transition:.3s ease-in-out}@media(min-width:1200px){.ads{margin:59px 0 69px}}.ads .link{padding-top:5px;text-align:right}.ads .link a{padding-left:16px;font-size:.8em;color:inherit;background:var(--svg--link-blank) left center no-repeat;background-size:13px 13px}.ads .container{position:relative;background:var(--popup-bg);box-shadow:var(--ad-shadow);border-radius:14px;overflow:hidden}.ads .container a,.ads .container img{display:block}.ads .container img{width:100%;aspect-ratio:2}.vueperslides__arrow:focus-visible{outline:5px auto Highlight!important;outline:5px auto -webkit-focus-ring-color!important}.package-sorting{margin:20px 0 15px;text-align:right}.package-sorting__label{display:inline-block;text-transform:uppercase}.package-sorting__label:after{content:":"}.package-sorting__group{position:relative;display:inline-flex;flex-direction:column;margin:0;padding:0 15px 0 0;list-style-type:none;text-align:left}.package-sorting__group:after{content:"";position:absolute;top:.8em;right:0;width:0;height:0;border-left:5px solid transparent;border-right:5px solid transparent;border-top:5px solid #777}.package-sorting__item{display:none;margin:0 0 0 10px;padding:3px 0;border-bottom:2px solid transparent}.package-sorting__item:hover{color:var(--link)}.package-sorting__item--open{display:inline}.package-sorting__item--active{display:inline;color:var(--link);border-bottom:2px solid var(--link)}.package-sorting__item button{margin:0;padding:0;background:none;border:none;text-transform:uppercase;cursor:pointer}@media(min-width:600px){.package-sorting__group{flex-direction:row;justify-content:flex-end;padding:0}.package-sorting__group:after{content:none}.package-sorting__item{display:inline}}.search-bar{position:relative}.search-bar__input{height:50px!important;padding-right:45px!important;border-radius:50px!important}.search-bar__button{position:absolute;top:5px;right:5px;display:flex;align-items:center;width:38px;height:40px;margin:0;padding:7px;line-height:36px;border:none;border-radius:0 50px 50px 0;background:none}.package-search{position:relative}.package-search__input{max-width:400px;margin:0 20px}@media(min-width:1024px){.package-search__input{margin-right:0}}.package-search__headline{font-size:18px;font-weight:300;margin:30px 0 10px}.package-search__results{display:grid;gap:20px;margin-bottom:20px}@media(min-width:1024px){.package-search__results{grid-template-columns:repeat(2,1fr)}}.package-search__status{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.package-search__status--empty{padding-top:140px;background:url(../img/sad.c7de6e95.svg) top no-repeat;background-size:100px 100px}.package-search__status--offline{padding-top:140px;background:url(../img/offline.0c23d1ce.svg) top no-repeat;background-size:100px 100px}.package-search__status--loader .sk-circle{width:100px;height:100px;margin:0 auto 40px}.package-search__status button{margin-top:2em}.package-search__explain{font-size:16px}.package-search__more{margin:10px 0 30px;text-align:center}.package-search__more-button{display:inline-block;margin:0 auto;padding:0;text-transform:uppercase;background:none;border:none;cursor:pointer}.package-search__more-button:hover{text-decoration:underline}.package-search__algolia{display:block;width:200px;margin:50px auto 0}.vjs-tree-brackets{cursor:pointer}.vjs-tree-brackets:hover{color:#1890ff}.vjs-check-controller{position:absolute;left:0}.vjs-check-controller.is-checked .vjs-check-controller-inner{background-color:#1890ff;border-color:#0076e4}.vjs-check-controller.is-checked .vjs-check-controller-inner.is-checkbox:after{-webkit-transform:rotate(45deg) scaleY(1);transform:rotate(45deg) scaleY(1)}.vjs-check-controller.is-checked .vjs-check-controller-inner.is-radio:after{-webkit-transform:translate(-50%,-50%) scale(1);transform:translate(-50%,-50%) scale(1)}.vjs-check-controller .vjs-check-controller-inner{display:inline-block;position:relative;border:1px solid #bfcbd9;border-radius:2px;vertical-align:middle;-webkit-box-sizing:border-box;box-sizing:border-box;width:16px;height:16px;background-color:#fff;z-index:1;cursor:pointer;-webkit-transition:border-color .25s cubic-bezier(.71,-.46,.29,1.46),background-color .25s cubic-bezier(.71,-.46,.29,1.46);transition:border-color .25s cubic-bezier(.71,-.46,.29,1.46),background-color .25s cubic-bezier(.71,-.46,.29,1.46)}.vjs-check-controller .vjs-check-controller-inner:after{-webkit-box-sizing:content-box;box-sizing:content-box;content:"";border:2px solid #fff;border-left:0;border-top:0;height:8px;left:4px;position:absolute;top:1px;-webkit-transform:rotate(45deg) scaleY(0);transform:rotate(45deg) scaleY(0);width:4px;-webkit-transition:-webkit-transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;transition:-webkit-transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;transition:transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;transition:transform .15s cubic-bezier(.71,-.46,.88,.6) .05s,-webkit-transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;-webkit-transform-origin:center;transform-origin:center}.vjs-check-controller .vjs-check-controller-inner.is-radio{border-radius:100%}.vjs-check-controller .vjs-check-controller-inner.is-radio:after{border-radius:100%;height:4px;background-color:#fff;left:50%;top:50%}.vjs-check-controller .vjs-check-controller-original{opacity:0;outline:none;position:absolute;z-index:-1;top:0;left:0;right:0;bottom:0;margin:0}.vjs-carets{position:absolute;right:0;cursor:pointer}.vjs-carets svg{-webkit-transition:-webkit-transform .3s;transition:-webkit-transform .3s;transition:transform .3s;transition:transform .3s,-webkit-transform .3s}.vjs-carets:hover{color:#1890ff}.vjs-carets-close{-webkit-transform:rotate(-90deg);transform:rotate(-90deg)}.vjs-tree-node{display:-webkit-box;display:-ms-flexbox;display:flex;position:relative;line-height:20px}.vjs-tree-node.has-carets{padding-left:15px}.vjs-tree-node.has-carets.has-selector,.vjs-tree-node.has-selector{padding-left:30px}.vjs-tree-node.is-highlight,.vjs-tree-node:hover{background-color:#e6f7ff}.vjs-tree-node .vjs-indent{display:-webkit-box;display:-ms-flexbox;display:flex;position:relative}.vjs-tree-node .vjs-indent-unit{width:1em}.vjs-tree-node .vjs-indent-unit.has-line{border-left:1px dashed #bfcbd9}.vjs-tree-node.dark.is-highlight,.vjs-tree-node.dark:hover{background-color:#2e4558}.vjs-node-index{position:absolute;right:100%;margin-right:4px;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.vjs-colon{white-space:pre}.vjs-comment{color:#bfcbd9}.vjs-value{word-break:break-word}.vjs-value-null,.vjs-value-undefined{color:#d55fde}.vjs-value-boolean,.vjs-value-number{color:#1d8ce0}.vjs-value-string{color:#13ce66}.vjs-tree{font-family:Monaco,Menlo,Consolas,Bitstream Vera Sans Mono,monospace;font-size:14px;text-align:left}.vjs-tree.is-virtual{overflow:auto}.vjs-tree.is-virtual .vjs-tree-node{white-space:nowrap}[data-notivue=promise-resolve],[data-notivue=success]{--nv-bg:var(--nv-success-bg);--nv-fg:var(--nv-success-fg);--nv-accent:var(--nv-success-accent,var(--nv-global-accent));--nv-border:var(--nv-success-border)}[data-notivue=error],[data-notivue=promise-reject]{--nv-bg:var(--nv-error-bg);--nv-fg:var(--nv-error-fg);--nv-accent:var(--nv-error-accent,var(--nv-global-accent));--nv-border:var(--nv-error-border)}[data-notivue=warning]{--nv-bg:var(--nv-warning-bg);--nv-fg:var(--nv-warning-fg);--nv-accent:var(--nv-warning-accent,var(--nv-global-accent));--nv-border:var(--nv-warning-border)}[data-notivue=info]{--nv-bg:var(--nv-info-bg);--nv-fg:var(--nv-info-fg);--nv-accent:var(--nv-info-accent,var(--nv-global-accent));--nv-border:var(--nv-info-border)}[data-notivue=promise]{--nv-bg:var(--nv-promise-bg);--nv-fg:var(--nv-promise-fg);--nv-accent:var(--nv-promise-accent,var(--nv-global-accent));--nv-border:var(--nv-promise-border)}.Notivue__notification{--tip-width:calc(var(--tip-width-fx, 1)*var(--nv-tip-width, 0px));box-sizing:border-box;position:relative;width:var(--nv-min-width,auto);max-width:var(--nv-width,100%);background-color:var(--nv-bg,var(--nv-global-bg));display:flex;align-items:var(--nv-y-align);border-radius:var(--nv-radius,0);border:var(--nv-border-width,0) solid var(--nv-border,var(--nv-global-border));box-shadow:var(--nv-shadow,0 0 transparent),inset var(--tip-width) 0 0 var(--nv-accent)}.Notivue__notification *{box-sizing:border-box;touch-action:manipulation}.Notivue__notification[data-notivue-has-title=true]{align-items:var(--nv-y-align-has-title,var(--nv-y-align))}.Notivue__icon{display:flex;justify-content:center;align-items:center;overflow:visible;min-width:var(--nv-icon-size);width:var(--nv-icon-size);height:var(--nv-icon-size);margin:var(--nv-spacing) 0 var(--nv-spacing) var(--nv-spacing);color:var(--nv-accent)}.Notivue__content{--nv-content-space:calc(var(--nv-spacing) + var(--nv-spacing)*0.15);display:flex;flex-direction:column;flex-grow:1;text-align:inherit;padding:var(--nv-content-space)}.Notivue__content-title{line-height:1.15;font-weight:700;color:var(--nv-fg,var(--nv-global-fg));font-size:var(--nv-title-size);margin:0 0 .33em;padding:0}.Notivue__transition-enter-active{--dur-easing:.5s cubic-bezier(.16,1,.3,1);transition:opacity var(--dur-easing),transform var(--dur-easing)}@media (prefers-reduced-motion:reduce){.Notivue__transition-enter-active{transition:none}}.Notivue__transition-enter-from{opacity:0;transform:scale(.8)}.Notivue__transition-enter-to{opacity:1;transform:scale(1)}.Notivue__transition-leave-active{transition:opacity 0ms ease}.Notivue__transition-leave-from,.Notivue__transition-leave-to{opacity:0}.Notivue__content-message{max-height:250px;overflow:auto;line-height:1.375;margin:0;padding:0;white-space:pre-line}.Notivue__close,.Notivue__content-message{color:var(--nv-fg,var(--nv-global-fg));font-size:var(--nv-message-size)}.Notivue__close{position:relative;cursor:pointer;padding:calc(var(--nv-spacing)/2);margin:var(--nv-spacing) var(--nv-spacing) var(--nv-spacing) 0;font-weight:700;border:none;background:none;line-height:1;-webkit-tap-highlight-color:rgba(0,0,0,0)}.Notivue__close:after{content:"";position:absolute;top:0;right:0;bottom:0;left:0;width:100%;height:100%;background-color:var(--nv-fg,var(--nv-global-fg));opacity:0;border-radius:calc(var(--nv-radius)/2);transition:opacity .1s ease-out}@media (hover:hover){.Notivue__close:hover{opacity:1}.Notivue__close:hover:after{opacity:.1}.Notivue__close:hover .Notivue__close-icon{opacity:1}}.Notivue__close-icon{width:var(--nv-icon-size);height:var(--nv-icon-size);display:flex;color:var(--nv-fg,var(--nv-global-fg));pointer-events:none;opacity:.65}.Notivue__spinner{transform-origin:center;animation:Notivue__spinner-kf .75s linear infinite}@keyframes Notivue__spinner-kf{to{transform:rotate(1turn)}}@media (prefers-reduced-motion:reduce){.Notivue__duplicate,.Notivue__spinner{animation:none}}[dir=rtl] .Notivue__notification{--tip-width-fx:-1}[dir=rtl] .Notivue__icon{margin:var(--nv-spacing) var(--nv-spacing) var(--nv-spacing) 0}[dir=rtl] .Notivue__content-message{font-size:calc(var(--nv-message-size) + .1em)}[dir=rtl] .Notivue__content-title{font-size:calc(var(--nv-title-size) + .1em)}[dir=rtl] .Notivue__close{margin:var(--nv-spacing) 0 var(--nv-spacing) var(--nv-spacing)}.Notivue__duplicate{animation:Notivue__duplicate-kf .3s cubic-bezier(.16,1,.3,1) forwards}@keyframes Notivue__duplicate-kf{0%{transform:scale(1);opacity:1}50%{transform:scale(1.035);opacity:.8}to{transform:scale(1);opacity:1}}[data-notivue-align=top] .Notivue__enter,[data-notivue-align=top] .Notivue__leave{--notivue-ty:-200%}[data-notivue-align=bottom] .Notivue__enter,[data-notivue-align=bottom] .Notivue__leave{--notivue-ty:200%}.Notivue__enter{animation:Notivue__enter-kf .35s cubic-bezier(.5,1,.25,1)}.Notivue__leave{animation:Notivue__leave-kf .35s ease}.Notivue__clearAll{animation:Notivue__clearAll-kf .5s cubic-bezier(.22,1,.36,1)}@keyframes Notivue__enter-kf{0%{transform:translate3d(0,var(--notivue-ty),0) scale(.25);opacity:0}to{transform:translateZ(0) scale(1);opacity:1}}@keyframes Notivue__leave-kf{0%{transform:translateZ(0) scale(1);opacity:.7}to{transform:translate3d(0,var(--notivue-ty),0) scale(0);opacity:0}}@keyframes Notivue__clearAll-kf{0%{opacity:1}to{opacity:0}}body.nav-active{overflow:hidden!important}#app{transition:transform .4s cubic-bezier(.55,0,.1,1)}.nav-active #app{overflow-y:visible;transform:translateX(-280px)}.nav-active #app .navigation__group--main{visibility:visible}@media(min-width:1024px){.nav-active #app{transform:none}}.navigation__toggle{display:block;float:right;position:relative;margin:5px 15px;padding:0;width:30px;height:30px;background:none;border:none;cursor:pointer;z-index:20}.navigation__toggle span,.navigation__toggle span:after,.navigation__toggle span:before{content:"";display:block;width:100%;height:4px;background:var(--text);border-radius:4px;position:absolute}.navigation__toggle span{transition-duration:75ms;transition-timing-function:cubic-bezier(.215,.61,.355,1);top:50%;margin-top:-2px}.navigation__toggle span:before{top:-10px;transition:top 75ms ease .12s,opacity 75ms ease}.navigation__toggle span:after{bottom:-10px;transition:bottom 75ms ease .12s,transform 75ms cubic-bezier(.55,.055,.675,.19)}.nav-active .navigation__toggle span{transform:rotate(45deg);transition-delay:.12s;transition-timing-function:cubic-bezier(.215,.61,.355,1)}.nav-active .navigation__toggle span:before{top:0;opacity:0;transition:top 75ms ease,opacity 75ms ease .12s}.nav-active .navigation__toggle span:after{transition:bottom 75ms ease,transform 75ms cubic-bezier(.215,.61,.355,1) .12s;bottom:0;transform:rotate(-90deg)}.navigation__group,.navigation__item{list-style-type:none;margin:0;padding:0}.navigation__group--main{position:fixed;top:0;bottom:0;right:-280px;width:280px;visibility:hidden;padding:20px;overflow-y:auto;overflow-scrolling:touch;background:var(--header-main-bg);border-left:1px solid var(--header-bdr);z-index:10}.navigation__item a,.navigation__item button{display:block;margin:0;padding:12px 10px;font-size:16px;color:var(--text);white-space:pre;background:none;border:none}.navigation__item a:hover,.navigation__item button:hover{text-decoration:none}.navigation__item a[href]:hover,.navigation__item button[href]:hover{color:var(--link)}.navigation__item--main>a,.navigation__item--main>button{text-transform:uppercase}.navigation__item--sub>a{margin-left:15px}.navigation__item--icon svg{display:none}.navigation__item-badge{position:relative;top:-2px;margin-left:8px;padding:2px 5px;font-size:10px;color:var(--clr-btn);font-weight:600;background:var(--contao);border-radius:40%}@media(min-width:1024px){.navigation__toggle{display:none}.navigation__group--main{display:flex;visibility:visible;position:inherit;inset:auto;width:auto;padding:0;overflow:visible;background:none;border:none;box-shadow:none;transform:none;transition:none}.navigation__group--sub{position:absolute;left:50%;min-width:180px;margin-top:-3px;text-align:center;background:var(--form-bg);border-top:3px solid var(--link);border-radius:5px;transform:translateX(-50%);z-index:100;box-shadow:0 0 2px var(--shadow);transition:opacity var(--am-close-transition-duration) ease}.navigation__group--sub:before{position:absolute;left:50%;top:-7px;width:0;height:0;margin-left:-4px;border-style:solid;border-width:0 3.5px 4px 3.5px;border-color:transparent transparent var(--link) transparent;content:""}.navigation__group--sub.hide{display:none!important}.navigation__group--sub.transitioning{display:block!important;opacity:0}.navigation__group--sub.show{display:block!important;opacity:1;transition:opacity var(--am-open-transition-duration) ease}.navigation__group--right{left:auto;right:7px;transform:translateX(0)}.navigation__group--right:before{left:auto;right:18px}.navigation__item{position:relative;padding:0 8px}.navigation__item.router-link-active>a,.navigation__item:hover>a{color:var(--link)!important;border-bottom:3px solid var(--link)}.navigation__item:hover>.navigation__group--sub{display:block}.navigation__item--sub{display:block;margin:calc(var(--border-radius)/2) 0;padding:0 2px;border-radius:var(--border-radius)}.navigation__item--sub a{margin:0;border:none!important}.navigation__item--sub.router-link-active,.navigation__item--sub:hover{background:var(--focus)}.navigation__item--sub.router-link-active a,.navigation__item--sub:hover a{color:var(--text)!important}.navigation__item--icon>button{padding-top:7px}.navigation__item--icon>button svg{display:inline;position:relative;top:4px;width:22px;height:22px;fill:var(--text)}.navigation__item--icon>button:hover svg{fill:var(--link)}.navigation__item--icon>button span{display:none}.navigation:hover li>a{border:none}.navigation:hover li:hover>a{border-bottom:3px solid var(--link)}.navigation:hover li:hover>a svg{fill:var(--link)}}.logout-warning{text-align:center}.logout-warning__countdown{margin:20px 0;font:600 4em/1.6 SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;color:var(--btn-warning)}.fragment-footer{width:280px;margin:10px auto 0;padding:15px 0 25px;font-size:12px;text-align:center;border-top:1px solid var(--footer-bdr)}.fragment-footer--main{width:auto;margin-top:52px!important;padding:20px 0}.fragment-footer--boxed{border-color:var(--footer-fragment-bdr)}.fragment-footer__product{font-weight:300}.fragment-footer__links{margin:5px 0 0;padding:0;list-style-type:none}.fragment-footer__links li{display:inline-block}.fragment-footer__links li:not(:first-child):before{content:"|";padding:0 10px 0 8px}.fragment-footer__links a{display:inline!important;color:var(--link-footer)}.fragment-footer__settings{margin-top:10px;display:flex;flex-flow:column;justify-content:center;gap:10px}@media(min-width:960px){.fragment-footer{display:grid;grid-auto-flow:column;grid-auto-columns:minmax(0,1fr);gap:16px;align-content:center}.fragment-footer--boxed .fragment-footer__product,.fragment-footer--main .fragment-footer__product{margin-right:auto}.fragment-footer--boxed .fragment-footer__links,.fragment-footer--main .fragment-footer__links{order:15;margin:0 0 0 auto}.fragment-footer--boxed .fragment-footer__settings,.fragment-footer--main .fragment-footer__settings{flex-flow:row;margin-top:0}.fragment-footer--boxed{width:840px}}.layout-main{overflow:hidden;min-height:100vh}.layout-main__header{display:flex;justify-content:space-between;height:56px;padding:8px;background:var(--header-main-bg)}.layout-main__header--margin{margin-bottom:30px}.layout-main__badge-title{background:var(--border);color:var(--text);padding:2px 5px;position:relative;top:-5px;border-radius:8px;font-size:.75rem;font-weight:600;line-height:1;display:-webkit-box;-webkit-line-clamp:1;line-clamp:1;-webkit-box-orient:vertical;word-break:break-word;overflow:hidden;text-overflow:ellipsis}.layout-main__subheader{margin:0 0 45px;padding:20px 0;background:var(--header-bg);border-bottom:1px solid var(--header-bdr)}.layout-main__subheader-inside{display:flex;justify-content:center;align-items:center;flex-direction:column}.layout-main__news{width:320px;height:50px;margin-bottom:20px}.layout-main__news a,.layout-main__news img{display:block}.layout-main .search-bar{width:100%;margin:0}.layout-main__logo{display:inline;color:var(--text);text-decoration:none;font-weight:100;font-size:27px;line-height:40px}.layout-main__logo img{float:left;margin:0 10px 0 12px}@media(min-width:1024px){.layout-main__logo img{margin-left:0}}.layout-main footer,.layout-main__content,.layout-main__subheader-inside{position:relative;margin:0 20px}.layout-main__has-badge-title{display:flex;justify-content:space-between}.layout-main__has-badge-title .layout-main__logo{display:flex}.layout-main__has-badge-title .layout-main__title{display:flex;flex-wrap:wrap;align-items:center;line-height:1;column-gap:10px;row-gap:5px}@media(max-width:600px){.layout-main__badge-title{max-width:220px}}@media(min-width:700px){.layout-main__subheader-inside{flex-direction:row}.layout-main__news{margin:0 20px 0 0}}@media(min-width:1024px){.layout-main__has-badge-title .navigation__group--main{display:flex}.layout-main footer,.layout-main__content,.layout-main__subheader-inside{max-width:960px;margin:0 auto}}@media(min-width:1200px){.layout-main footer,.layout-main__content,.layout-main__subheader-inside{max-width:1180px}}.confirm-button{position:relative}.confirm-button__icon{display:none;position:absolute;opacity:0;z-index:100}.confirm-button__icon--confirm{display:block;animation:confirm_button .5s ease-out 0s}.confirm-button__icon svg{fill:var(--btn-primary);width:100%;height:100%}@keyframes confirm_button{0%{opacity:1;height:10px;width:10px;left:calc(50% - 5px);top:calc(50% - 5px)}to{opacity:0;height:150px;width:150px;left:calc(50% - 75px);top:calc(50% - 75px)}}.package-tools{position:relative;clear:both;text-align:center}@media(min-width:800px){.package-tools{margin-bottom:40px}}.package-tools__button.widget-button{margin-bottom:10px}@media(min-width:800px){.package-tools{display:flex;justify-content:center;align-items:center}.package-tools__button.widget-button{width:auto;margin:0 15px;padding:0 15px}}.package-actions{position:fixed;left:0;right:0;bottom:0;max-height:0;background:#000;background:rgba(0,0,0,.8);color:#fff;transition:max-height .4s ease;z-index:100}.package-actions--active{max-height:200px}.package-actions__inner{display:flex;flex-wrap:wrap;justify-content:flex-end;align-items:center;margin:0;padding:12px;text-align:right}@media(min-width:1024px){.package-actions__inner{max-width:976px;margin:0 auto;padding-left:0;padding-right:0}}@media(min-width:1200px){.package-actions__inner{max-width:1196px}}.package-actions__text{flex-grow:1;display:initial;margin:0 8px;font-weight:600}.package-actions__button{display:block;padding:0 15px!important;margin:8px}.package-actions__button--dryRun{width:auto!important;flex-grow:1}@media(min-width:600px){.package-actions__button{width:auto!important}.package-actions__button--dryRun{flex-grow:0}}.package-actions__button-group{display:block;width:100%;margin:8px}.package-actions__button-group>.button-group__primary{padding:0 15px!important}@media(min-width:600px){.package-actions__button-group{width:auto!important}}.package{position:relative;margin-bottom:20px;background:var(--tiles-bg);border:1px solid var(--tiles-bdr);border-radius:14px}.package.is--hint{border-color:var(--btn-alert)}.package--contao:not(:last-child){margin-bottom:5em}.package__hint{position:relative;background:var(--hint-bg);padding:8px 16px;font-weight:400;font-size:12px;line-height:1.8;border-radius:14px 14px 0 0;z-index:1}.package__hint p a{display:inline-block;padding-right:10px}.package__hint p a:first-child{margin-left:10px}.package__hint p a:not(:first-child):before{padding-right:10px;content:"|"}.package__hint-close{float:right;padding-left:18px;color:var(--hint-link);background:url(../img/close.8b27dbcb.svg) 0 no-repeat;background-size:14px 14px}.package__inside{position:relative;padding:16px}.package__inside:after{display:table;clear:both;content:""}.package__badge{display:inline-block;margin-bottom:.5em;padding:2px 5px;color:#fff;font-size:12px;font-weight:600;background:var(--btn-alert);border-radius:var(--border-radius);cursor:help}.package__icon{border-radius:6px;height:60px;width:60px;background:#f7f7f7;margin:0 auto 10px;position:absolute;right:16px}.package__icon>figure{display:flex;align-items:center;justify-content:center;height:100%}.package__icon img,.package__icon svg{border-radius:4px;width:50px;height:50px;max-height:100%;object-fit:contain}.package__details{min-height:96px}.package__about{margin-bottom:20px}.package__headline{position:relative;margin-bottom:.2em;line-height:1;overflow-wrap:break-word;margin-right:70px}.package__headline em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.package__title{display:block;margin-right:10px}.package__description{display:-webkit-box;overflow:hidden;-webkit-line-clamp:2;-webkit-box-orient:vertical;margin-bottom:1em;margin-right:70px}.package__description em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.package__additional{margin-top:-5px}.package .package__release{text-align:right;margin-bottom:5px}.package__version--additional{margin-bottom:5px}.package__version--additional strong{margin-right:10px}.package__version--release{display:none}.package__version--release time{display:block}.package__version--missing{padding:4px 8px;background:var(--btn-alert);border-radius:var(--border-radius);color:#fff;font-weight:700}.package__version-update{display:inline-block;margin:0 0 2px;padding:1px 8px;color:#fff;border-radius:var(--border-radius)}.package__version-update--available{background:var(--btn-primary)}.package__version-update--error{background:var(--btn-alert)}.package__version-update--none{background:var(--border)}.package__version-latest{float:right;position:relative;right:-7px;width:24px;height:20px;background:var(--btn-primary) url(../img/button-update.ad79c617.svg) center center/20px 20px no-repeat}.package__actions{display:flex;flex-flow:column;gap:5px}.package__actions .button-group button{margin-bottom:0!important}@media(min-width:600px){.package__description,.package__title{margin-right:0}.package__hint{padding-left:52px;background:rgba(var(--hint-rgb),.9) url(../img/hint.ba2ac97e.svg) 12px 5px no-repeat;background-size:28px 28px}.package__inside{display:flex;align-items:stretch;padding:0}.package__headline--badge{display:flex;gap:6px;align-items:flex-start}.package__headline{margin:0 0 8px}.package__badge{order:1;margin:0 0 0 2px}.package__icon{width:130px;height:auto;min-height:130px;margin:0;border-radius:12px 0 0 12px;position:revert;right:revert}.package__icon img,.package__icon svg{width:110px;height:110px}.is--hint .package__icon{border-top-left-radius:0}.package--contao{overflow:hidden}.package--contao .package__icon{border-radius:0}.package__details{padding:16px;height:100%;min-height:90px;max-width:calc(100% - 130px);flex:1}.package.is--hint .package__icon{border-top-left-radius:0}}@media(min-width:680px){.package .package__release{display:block;float:left;width:33%}.package__actions{float:right;width:64%;flex-flow:row;gap:4%;text-align:right}.package__actions>*{flex:1}}@media(min-width:1024px){.package__version--additional{display:none}.package__version--release{display:block;margin-top:15px;text-align:center}.package__version-update{display:block;margin:2px 0 0}.package__about{float:left;width:396px;margin-bottom:0}.package .package__release{width:180px;margin-left:20px;margin-bottom:0}.package__actions{flex-flow:column;gap:10px;width:180px;margin-left:20px}.package__details{display:flex;align-self:center;align-items:flex-start}}@media(min-width:1200px){.package__about{width:616px}}.progress-bar{--progress-color:var(--btn-warning);position:relative;width:100%;height:30px;background:var(--clr-btn);border:2px solid var(--progress-color);color:#000;font-weight:600;text-align:center;line-height:26px}.progress-bar__bar{position:absolute;overflow:hidden;left:0;right:0;top:0;bottom:0;background:var(--progress-color)}.progress-bar__bar span{display:block;color:var(--clr-btn);text-align:center}.progress-bar--primary{--progress-color:var(--btn-primary)}.progress-bar--alert{--progress-color:var(--btn-alert)}.feature-package{display:flex;flex-wrap:wrap;padding:6px 16px;border-top:1px solid var(--border--light)}.feature-package__name{font-weight:600;white-space:nowrap}.feature-package__name:after{content:": "}.feature-package__text{flex-grow:1;display:-webkit-box;overflow:hidden;-webkit-line-clamp:1;line-clamp:1;-webkit-box-orient:vertical;margin-right:.5em;padding:4px 0;line-height:20px}.feature-package__text--hint{display:inline;-webkit-line-clamp:none;line-clamp:none}.feature-package__badge{margin-left:5px;padding:2px 8px;background:var(--btn-alert);border-radius:var(--border-radius);font-size:12px;font-weight:600;line-height:19px;color:#fff;cursor:help}.feature-package__hint{line-height:1.2;padding:2px 5px;background:var(--hint-bg);font-size:12px}.feature-package__actions{flex-grow:1;display:flex;justify-content:flex-end;margin:0 -4px 0 0}.feature-package__actions>*{margin:0 4px}.feature-package__restore{padding-left:18px;font-size:12px;color:var(--hint-link);background:url(../img/close.8b27dbcb.svg) 0 no-repeat;background-size:14px 14px;border:none;cursor:pointer}.feature-package__restore:hover{text-decoration:underline}@media(min-width:800px){.feature-package{flex-wrap:nowrap}}@media(min-width:1024px){.feature-package__hint{padding:8px 10px 8px 36px;background:var(--hint-bg) url(../img/hint.ba2ac97e.svg) 10px 5px no-repeat;background-size:20px 20px}.feature-package__actions{margin:0 -4px 0 0}}.package-constraint input[type=text][data-v-45700166]{margin-right:2px;background:#fff;border:2px solid var(--btn-warning);color:var(--black);font-weight:600;text-align:center;border-top-right-radius:0;border-bottom-right-radius:0}.package-constraint input[type=text][data-v-45700166]::placeholder{color:#fff;-webkit-text-fill-color:#fff;opacity:1}.package-constraint input[type=text][data-v-45700166]:disabled{color:var(--clr-btn);opacity:1;background:var(--btn-warning);-webkit-text-fill-color:var(--clr-btn)}.package-constraint input[type=text].disabled[data-v-45700166]{background:var(--border);border-color:var(--border)}.package-constraint input[type=text].error[data-v-45700166]{animation:input-error .15s linear 3}.package-constraint>input[type=text][data-v-45700166],.package-constraint>input[type=text][data-v-45700166]:disabled{float:left;width:calc(100% - 32px)}.package-constraint button[data-v-45700166]{position:relative;width:30px;background:var(--btn-warning);line-height:20px;text-indent:-999em;border-top-left-radius:0;border-bottom-left-radius:0}.package-constraint button[data-v-45700166]:hover{background:var(--btn-warning-active);border-color:var(--btn-warning-active)}.package-constraint button[data-v-45700166]:before{position:absolute;left:50%;top:50%;margin:-10px 0 0 -10px}.package-constraint button.rotate[data-v-45700166]:before{animation:release-validating-45700166 2s linear infinite}@keyframes release-validating-45700166{to{transform:rotate(1turn)}}@media(min-width:1024px){.package-constraint button[data-v-45700166],.package-constraint input[type=text][data-v-45700166]{height:30px}}.button-group{display:flex;gap:1px;position:relative}.button-group__primary.widget-button{flex-grow:1;border-top-right-radius:0;border-bottom-right-radius:0}.button-group__more.widget-button{flex-shrink:0;width:38px;padding:7px;border-top-left-radius:0;border-bottom-left-radius:0}.button-group__more.widget-button svg{width:24px;height:24px}.button-group__group{position:absolute;top:39px;width:100%;padding-top:3px;z-index:100}.button-group__group:focus{outline:none}.button-group__group .widget-button{margin-top:1px}.button-group__group .link-menu{margin-top:3px}.button-group__group--top{top:auto;bottom:39px}.button-group__group--top .link-menu{margin-top:0;margin-bottom:3px}.composer-package__stats{display:inline-block;margin-right:15px;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.composer-package__stats--license{padding-left:0}.composer-package__stats--versions{display:inline-flex;flex-wrap:wrap;gap:5px;list-style:none;margin:0 15px 0 0;padding:0}.composer-package__stats--version{padding:3px 5px;line-height:1;border:1px solid var(--border);border-radius:4px}.composer-package__stats--funding{width:16px;background-image:url(../img/funding.cf78a0a0.svg);background-size:16px 16px;background-repeat:no-repeat;text-decoration:none!important}.package-uploads__overlay{top:0;bottom:0;right:0;left:0;position:fixed;z-index:9999;opacity:.6;text-align:center;background:#000}.package-uploads__overlay div{margin:-.5em 0 0;position:absolute;top:50%;left:0;right:0;transform:translateY(-50%);font-size:40px;color:#fff;padding:0}.cloud-status{margin-left:8px;position:relative}.cloud-status__button{margin-left:0;margin-right:0;padding-left:8px;cursor:help!important}.cloud-status__popup{position:absolute;text-align:center;left:0;bottom:54px;margin:0;padding:0 0 15px;outline:none;background:var(--form-bg);color:var(--text);border-bottom:3px solid var(--contao);border-radius:5px;box-shadow:0 0 2px var(--shadow);z-index:100}.cloud-status__popup:after{position:absolute;left:38px;bottom:-6px;width:0;height:0;margin-left:-4px;border-style:solid;border-width:4px 3.5px 0 3.5px;border-color:var(--contao) transparent transparent transparent;content:""}.cloud-status__popup--error{color:var(--clr-btn);background-color:var(--btn-alert);border-color:var(--btn-alert)}.cloud-status__popup--error:after{left:27px;border-color:var(--btn-alert) transparent transparent transparent}.cloud-status__headline{padding:15px 20px 0;font-size:16px;white-space:pre}.cloud-status__version{margin:0 0 8px;font-size:12px}.cloud-status__link{display:inline-block;margin:15px 10px 0}.cloud-status__error{padding:8px 20px 8px;hyphens:auto}.cloud-status table{width:100%;margin-top:12px;text-align:left;border-spacing:0;border-collapse:collapse}.cloud-status th{padding:3px 5px 3px 20px}.cloud-status td{padding:3px 20px 3px 0}.cloud-status tr:nth-child(odd){background:var(--table-odd-bg)}.package-list{position:relative}.package-list__status{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.package-list__status .sk-circle{width:100px;height:100px;margin:0 auto 40px}.package-list__headline{font-size:18px;font-weight:300;margin:30px 0 10px}.animate-blur-in,.animate-blur-out,.layout-boxed{display:table;width:100%;height:100%}.layout-boxed__cell{display:table-cell;overflow:hidden;vertical-align:middle;padding:10px}.layout-boxed__container{position:relative;max-width:380px;margin:0 auto;background:var(--popup-bg);border-radius:8px}@media(min-width:960px){.layout-boxed__container{margin-top:20px;margin-bottom:20px}.layout-boxed__container--wide{max-width:940px}}.widget-checkbox input{border:0;clip:rect(0 0 0 0);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;width:1px}.widget-checkbox label{position:relative;display:block;padding-left:25px;text-align:left}.widget-checkbox label:before{content:"";position:absolute;left:0;width:20px;height:20px;background:url(../img/widget-checkbox--off.73856538.svg) 0 0 no-repeat;background-size:20px 20px}.widget-checkbox input:checked+label:before{background-image:url(../img/widget-checkbox--on.8b830157.svg)}.widget-checkbox input:focus-visible+label{outline:5px auto Highlight;outline:5px auto -webkit-focus-ring-color}.widget-checkbox input:disabled+label{opacity:.5}.widget-checkbox .widget__description{padding-left:25px}.widget-checkbox .widget__description--disabled{opacity:.5}.user-scope__label{margin:0;padding:0}.user-scope__item{padding:5px 0 0}.user-scope__item--required label{opacity:1!important}.user-scope__item--required label:before{opacity:.5}.view-oauth__header{max-width:280px;margin:0 auto 40px;padding-top:40px;text-align:center}.view-oauth__icon{background:var(--contao);border-radius:10px;padding:10px}.view-oauth__product{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-oauth__form{position:relative;max-width:280px;margin:0 auto 60px;text-align:center}.view-oauth__form input,.view-oauth__form select{margin:5px 0 10px}.view-oauth__description{margin-top:.5em;margin-bottom:.5em}.view-oauth__client{margin:1em 0;font-size:32px}.view-oauth__scopes{text-align:left}.view-oauth__warning{color:var(--btn-alert);margin-top:2em;margin-bottom:2em}.view-oauth__button{margin-top:1em}.view-oauth__button .sk-circle{color:#fff;text-align:center}.message-overlay{position:relative}.message-overlay__blur{opacity:.75;filter:blur(2px);transition:opacity .5s,filter .5s}.message-overlay__overlay{position:absolute;display:flex;justify-content:center;align-items:center;left:0;right:0;top:0;bottom:0}.message-overlay__message{padding:10px;font-size:2em;font-weight:400;text-align:center}.maintenance{margin-bottom:14px;background:var(--tiles-bg);border-radius:var(--border-radius)}.maintenance__inside{padding:10px 20px 20px}@media(min-width:1024px){.maintenance__inside{display:grid;grid-template:auto/90px auto 300px;column-gap:20px;padding:25px 20px}}.maintenance__image{display:none}.maintenance__image img{width:100%;border-radius:var(--border-radius);overflow:hidden;aspect-ratio:1;object-fit:contain}@media(min-width:1024px){.maintenance__image{display:flex;align-items:center}}.maintenance__about{margin-bottom:20px}@media(min-width:1024px){.maintenance__about{margin-bottom:0}}.maintenance__about h1{position:relative;margin-bottom:5px;display:flex;flex-wrap:wrap;column-gap:.5em;align-items:baseline}.maintenance__about p{margin:0 0 1em;display:inline}.maintenance__error,.maintenance__warning{position:relative;top:-2px;padding:4px 8px;font-size:14px;line-height:1em;font-weight:300;background:var(--btn-warning);color:var(--clr-btn);border-radius:var(--border-radius)}.maintenance__error{background:var(--btn-alert)}.maintenance__actions{display:flex;flex-direction:column;row-gap:10px;column-gap:20px}@media(min-width:600px){.maintenance__actions{flex-direction:row-reverse}}@media(min-width:1024px){.maintenance__actions{flex-direction:column;margin-left:20px}}.maintenance__actions>.button-group,.maintenance__actions>button{width:100%}@media(min-width:600px){.maintenance__actions>.button-group,.maintenance__actions>button{width:calc(50% - 10px)}}@media(min-width:1024px){.maintenance__actions>.button-group,.maintenance__actions>button{width:100%}}.maintenance__loader{width:50px;margin:0 auto}.maintenance__loader .sk-circle{width:50px;height:50px}.log-viewer__status{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.log-viewer__status--empty{padding-top:140px;background:url(../img/warning.9a7cd776.svg) top no-repeat;background-size:100px 100px}.log-viewer__status--loader .sk-circle{width:100px;height:100px;margin:0 auto 40px}.log-viewer__status button{margin-top:2em}.log-viewer__loading{width:30px;margin:40px auto}.log-viewer__loading .sk-circle{width:30px;height:30px}.log-viewer__filters{display:flex;justify-content:space-between;flex-wrap:wrap;gap:20px}.log-viewer__filters>div{display:flex;align-items:flex-end;gap:20px}.log-viewer__filters a{flex-shrink:0}.log-viewer__file{flex-shrink:1;display:flex;align-items:flex-end}.log-viewer__file select{border-right:none;border-top-right-radius:0;border-bottom-right-radius:0}.log-viewer__file button{border-top-left-radius:0;border-bottom-left-radius:0}.log-viewer__list{margin-top:2em;padding-bottom:1px;background:var(--form-bg);border-radius:var(--border-radius)}@media(min-width:600px){.log-viewer__list{overflow-y:scroll;max-height:calc(100vh - 300px)}}.log-viewer__line{position:relative;padding:10px 0;border-bottom:1px solid var(--border--light)}@media(min-width:600px){.log-viewer__line{display:flex}}.log-viewer__line:hover{background:var(--focus)}.log-viewer__line:last-child{border-bottom:none}.log-viewer__line--header{display:none}@media(min-width:600px){.log-viewer__line--header{display:flex;position:sticky;top:0;z-index:1;font-weight:600;background:var(--log-header-bg)!important;color:#fff;border-top-left-radius:2px;border-top-right-radius:2px;border-bottom-color:var(--border)}}.log-viewer__line--alert:before,.log-viewer__line--critical:before,.log-viewer__line--emergency:before,.log-viewer__line--error:before,.log-viewer__line--warning:before{content:"";position:absolute;left:0;top:-1px;bottom:-1px;width:4px;background:var(--btn-alert)}.log-viewer__line--warning:before{background:var(--btn-warning)}.log-viewer__line--raw{padding:5px 10px;background:#24292e;border-bottom:none;font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;color:#f6f8fa;font-size:.8em;line-height:1.5;white-space:pre-wrap}.log-viewer__line--raw:hover{background:#2f363d}.log-viewer__more{display:flex;justify-content:center;padding:20px}.log-viewer__content,.log-viewer__meta{padding:10px 20px}.log-viewer__content--header,.log-viewer__meta--header{padding:0 20px!important}.log-viewer__meta{padding-bottom:0;flex-shrink:0;font-style:italic}.log-viewer__meta--header{font-style:normal}@media(min-width:600px){.log-viewer__meta{width:220px;padding-bottom:10px}}.log-viewer__content{flex-grow:1}.log-viewer__datetime{display:block}@media(min-width:600px){.log-viewer__datetime{margin-bottom:1em}}.log-viewer__badge{display:inline-block;margin-right:10px;padding:1px 4px;background:var(--border);border-radius:var(--border-radius);font-size:.9em;font-weight:400;text-transform:lowercase}.log-viewer__badge--desktop{display:none}@media(min-width:600px){.log-viewer__badge--desktop{display:inline-block}.log-viewer__badge--mobile{display:none}}.log-viewer__badge--channel{padding-top:0;padding-bottom:0;border:1px solid var(--border);background:var(--white)}.log-viewer__badge--level-warning{background:var(--btn-warning);color:#fff}.log-viewer__badge--level-alert,.log-viewer__badge--level-critical,.log-viewer__badge--level-emergency,.log-viewer__badge--level-error{background:var(--btn-alert);color:#fff}.log-viewer__message span:nth-child(2n){font-weight:600;color:var(--black)}.log-viewer__details{display:flex;align-items:center;margin-top:1em}.log-viewer__toggle{margin-right:10px;padding:0;border:none;background:none;color:var(--link);text-decoration:none;cursor:pointer}.log-viewer__toggle:hover{text-decoration:underline}.log-viewer__json{margin:10px 0 0}.invite-user__check{text-align:center}.invite-user__check svg{width:60px;height:60px;fill:var(--btn-primary)}.invite-user__check,.invite-user__text{margin-bottom:1em}.invite-user__url{display:block;margin-top:2em}.invite-user__help{display:block;margin-top:1em;font-size:12px}.invite-user__clipboard{margin:1em 0}.widget-text input::-webkit-inner-spin-button,.widget-text input::-webkit-outer-spin-button{display:none}.widget-text input[type=number]{appearance:textfield!important}.widget-text--password input{padding-right:40px!important}.widget__password-toggle{position:absolute;right:8px;bottom:2px;padding:0;margin:0;background:none;border:none;cursor:pointer}.widget__password-toggle--hidden svg{fill:var(--btn-primary)}.widget__password-toggle--visible svg{fill:var(--btn)}.setup-totp__qr{margin:2em;text-align:center}.setup-totp__qr svg{width:200px;height:200px}.setup-totp__uri{display:block;margin:1em 0;word-break:break-all}.setup-totp .sk-circle{margin:20px auto}.disable-totp__text{margin-bottom:1em}.change-password .widget{margin:1em 0 0}.user-manager__loading{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.user-manager__loading .sk-circle{width:100px;height:100px;margin:0 auto 40px}.user-manager__list{display:grid;grid-template:1fr/1fr;gap:20px}@media(min-width:600px){.user-manager__list{grid-template:1fr/repeat(2,1fr)}}@media(min-width:800px){.user-manager__list{grid-template:1fr/repeat(3,1fr)}}@media(min-width:1200px){.user-manager__list{grid-template:1fr/repeat(4,1fr)}}.user-manager__item{position:relative;overflow:hidden;display:flex;flex-direction:column;padding:16px;background:var(--tiles-bg);border:1px solid 1px solid var(--tiles-bdr);border-radius:14px}.user-manager__ribbon{position:absolute;top:18px;right:-22px;width:100px;font-size:12px;color:#fff;font-weight:600;line-height:1.5;text-align:center;background:var(--btn-info);transform-origin:center center;transform:rotate(45deg)}.user-manager__ribbon--hint{cursor:help}.user-manager__ribbon--primary{background:var(--btn-primary)}.user-manager__ribbon--warning{background:var(--btn-warning)}.user-manager__ribbon--alert{background:var(--btn-alert)}.user-manager__new{margin-top:60px;text-align:center}.user-manager__spacer{flex-grow:1;min-height:1em}.user-manager__username{font-size:18px;font-weight:600}.user-manager__scope{margin-top:1em}.user-manager .widget-button{margin-top:5px}.view-error{position:fixed;left:0;right:0;top:0;bottom:0;padding:10px;color:#e8e8e8;font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;font-size:13px;line-height:1.2;background-color:rgba(0,0,0,.851);background-position:0 0;background-repeat:repeat;z-index:9998}.view-error,.view-error__close{display:flex;justify-content:center;align-items:center}.view-error__close{position:absolute;top:15px;right:10px;width:35px;height:35px;background:none;border:none;cursor:pointer;z-index:10}.view-error__close:hover{border:1px solid #fff}.view-error__content{display:flex;flex-direction:column;align-items:center;max-width:800px;max-height:100vh;line-height:1.5;text-align:center}.view-error__content--dump{text-align:left!important;overflow:auto!important;max-width:none!important;width:100vw!important;height:calc(100vh - 40px)!important;display:block!important;z-index:-1}.view-error__content--dump .sf-dump{background:none!important}.view-error__icon{display:block;height:100px;margin:2em 0;fill:#fff}.view-error__status{margin-bottom:1em;padding:2px 4px;background-color:#e36049;border-radius:var(--border-radius)}.view-error__headline{margin:0;font-size:1em;line-height:1.5}.view-error__status a{color:#e8e8e8;text-decoration:underline}.view-error__details{display:block;margin-top:2em;white-space:pre-line}.view-error__debug{align-self:flex-start;width:100%;max-height:60vh;overflow-y:auto;margin-top:2em;text-align:left;white-space:pre-line}.view-error__actions{margin:4em 0;text-align:center}.view-error__link{margin:10px;padding:10px 20px;border:1px solid #fff;border-radius:4px;color:#fff}.button-menu{position:relative}.button-menu__primary.widget-button{float:left;width:calc(100% - 39px);border-top-right-radius:0;border-bottom-right-radius:0}.button-menu__more.widget-button{float:right;width:38px;padding:7px;border-top-left-radius:0;border-bottom-left-radius:0}.button-menu__more.widget-button svg{width:24px;height:24px}.button-menu__menu{display:flex;flex-direction:column;position:absolute;top:38px;right:0;width:auto;z-index:100;background:var(--form-bg);border-radius:var(--border-radius)}.button-menu__menu:before{content:"";position:absolute;top:-5px;right:15px;width:0;height:0;border-right:none;border-bottom:none;border-left:5px solid transparent;border-right:5px solid transparent;border-bottom:5px solid var(--form-bg)}.button-menu__menu:focus{outline:none}.button-menu__menu button{padding:8px 16px;background:none;border:none;text-align:left;white-space:nowrap;border-bottom:1px solid var(--border);cursor:pointer}.button-menu__menu button:hover{color:var(--text);background:var(--focus)}.button-menu__menu button:first-child{border-top-left-radius:2px;border-top-right-radius:2px}.button-menu__menu button:last-child{border-bottom:none;border-bottom-left-radius:2px;border-bottom-right-radius:2px}.button-menu__menu .link-menu{margin-top:3px}.console-operation{position:relative;padding:0 16px;text-align:left;font-size:12px;color:#959da5}.console-operation__summary{margin-left:13px;padding:8px;box-sizing:border-box}.console-operation__summary--console{margin-left:0}.console-operation summary{cursor:pointer}.console-operation__status{display:inline-block;position:relative;box-sizing:border-box;padding-right:8px;width:24px;height:18px;text-align:center;vertical-align:middle}.console-operation__icon{position:absolute;left:0;top:0}.console-operation__icon--skipped{fill:#666b71}.console-operation__icon--pending{fill:#dbab0a}.console-operation__icon--active{fill:#dbab0a;animation:console-active 1s linear infinite}@keyframes console-active{0%{transform:rotate(0deg)}50%{transform:rotate(180deg)}to{transform:rotate(359deg)}}.console-operation__icon--success{fill:var(--btn-primary)}.console-operation__icon--error{fill:var(--btn-alert)}.console-operation__label{display:inline-block;overflow:hidden;max-width:750px;vertical-align:top}.console-operation__title{display:inline;margin:0;color:#fff}.console-operation__title--disabled{text-decoration:line-through}.console-operation__description{display:inline;margin:0 0 0 10px}.console-operation__console{position:relative;overflow-y:auto;max-height:280px}.console-operation__lines{padding:8px 0 16px;font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;color:#f6f8fa;line-height:1.5;white-space:pre-wrap;word-break:break-word;overflow-wrap:break-word}.console-operation__line{display:flex}.console-operation__line:hover{background-color:#2f363d}.console-operation__line-number{display:inline-block;overflow:hidden;width:48px;min-width:48px;color:#959da5;text-align:right;text-overflow:ellipsis;white-space:nowrap;vertical-align:middle;user-select:none}.console-operation__line-content{display:inline-block;margin-left:16px;vertical-align:middle}.console-operation__scroll{position:sticky;left:0;right:0;display:flex;justify-content:center;align-items:flex-end;width:100%;height:30px;padding:0;border:none;cursor:pointer}.console-operation__scroll svg{fill:#fff;width:16px;height:16px}.console-operation__scroll--top{top:0;background:linear-gradient(#24292e,rgba(36,41,46,.502) 50%)}.console-operation__scroll--top svg{transform:rotate(180deg)}.console-operation__scroll--bottom{bottom:0;background:linear-gradient(rgba(36,41,46,.502),#24292e 50%)}.console-operation__scroll--bottom svg{transform:rotate(0deg)}.console{background:#24292e;border-radius:8px}.console__header{display:flex;flex-wrap:nowrap;justify-content:space-between;align-items:center;padding:12px 12px 12px 24px;border-bottom:1px solid #444d56}.console__headline{margin:0;font-size:inherit;line-height:1.5;color:#fff}.console__description{color:#959da5;font-size:12px}.console__actions{display:flex;flex-wrap:nowrap;align-items:center}.console__action,.console__action>button{height:30px!important;line-height:30px!important;width:auto!important;min-width:0;margin:0 2px;padding:0 5px!important;border:none!important}.console__action:hover,.console__action>button:hover{background-color:#2f363d!important}.console__action--active,.console__action>button--active{background-color:#586069!important}.console__operations{padding:20px 0}.view-task__header{margin-left:auto;margin-right:auto;padding:40px 20px;text-align:center}.view-task__icon{background:var(--contao);border-radius:10px;padding:10px}.view-task__headline{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-task__description{margin:0;font-weight:600}.view-task__actions{display:flex;flex-direction:column;justify-content:center;align-items:center;margin-top:2em}@media(min-width:960px){.view-task__actions{flex-direction:row}}.view-task .widget-button{width:280px;height:35px;margin:5px;padding:0 30px;line-height:35px}@media(min-width:960px){.view-task .widget-button{width:auto}}.view-task__main{margin:0 50px 50px}.view-task__loading{width:30px;margin:40px auto}.view-task__loading .sk-circle{width:30px;height:30px}.view-task__sponsor{margin:-30px 50px 50px;text-align:center}@media(min-width:960px){.view-task__sponsor br{display:none}}.view-task__donate{position:relative;top:5px;margin-left:.5em;line-height:0}:root{--text:#535353;--link:#f47c00;--placeholder:#a9a9a9;--body-bg:#ebe6db;--link-footer:#2a7887;--tiles-bg:#fff;--tiles-bdr:#ddd3bc;--popup-hl-bg:#f47c00;--popup-bg:#fff;--popup-header:#fff;--popup-overlay-bg:hsla(41,29%,89%,.35);--tab-content:#f8f9fb;--highlight-bg:#ff0;--highlight-color:#535353;--shadow:#ccbfa2;--contao:#f47c00;--badge-bg:var(--contao);--ad-shadow:0 1px 5px 1px rgba(0,0,0,.2);--black:#000;--funding:#ea4aaa;--funding-rgb:234,74,170;--form-bg:#fff;--border:#ccc;--border--light:#e9eef1;--focus:#f9f9f9;--clr-btn:#fff;--btn:#737373;--btn-active:#666;--btn-primary:#31a64b;--btn-primary-active:#2b9242;--btn-warning:#db8c41;--btn-warning-active:#d77f2c;--btn-alert:#db5041;--btn-alert-active:#d73c2c;--btn-info:#6a8ca6;--btn-info-active:#5c7f9a;--btn-funding:#ea4aaa;--btn-funding-active:#e7339f;--btn-disabled:#ccc;--hint-bg:#e8c8bc;--hint-rgb:232,200,188;--hint-link:#bd2e20;--header-bg:#e5dfcf;--header-bdr:#dcd8cc;--footer-bdr:#bbb;--svg--link-blank:url(../img/link-blank.eb57b3fa.svg);--svg--private:url(../img/private.a1c65662.svg);--svg--updated:url(../img/updated.3b47bebb.svg);--svg--downloads:url(../img/downloads.c1db2a9e.svg);--svg--favers:url(../img/favers.056e2836.svg);--svg--language:url(../img/language.582b2920.svg);--svg--color-scheme:url(../img/color_scheme.d527d153.svg)}html[data-color-scheme=dark]{color-scheme:dark;--text:#ddd;--link:#f47c00;--body-bg:#0f0f11;--tiles-bg:#212227;--tiles-bdr:#303236;--popup-hl-bg:#292c32;--popup-bg:#1b1d21;--popup-overlay-bg:rgba(0,0,0,.35);--tab-content:#212227;--highlight-bg:#f47c00;--highlight-color:#fff;--shadow:transparent;--badge-bg:var(--border--light);--ad-shadow:none;--btn:#3c3f4c;--btn-active:#25272f;--black:#fff;--form-bg:#151619;--border:#44464b;--border--light:#2e2e34;--focus:#1e2024;--btn-info:#25455f;--btn-info-active:#253846;--btn-disabled:#151517;--opacity-disabled:0.5;--hint-rgb:57,9,20;--header-bg:#1b1d21;--header-bdr:#1b1d21;--footer-bdr:#414448;--svg--link-blank:url(../img/link-blank--dark.07eeaee6.svg);--svg--private:url(../img/private--dark.41b90022.svg);--svg--updated:url(../img/updated--dark.c21fdd5b.svg);--svg--downloads:url(../img/downloads--dark.034bf7a3.svg);--svg--favers:url(../img/favers--dark.4765f7d4.svg);--svg--language:url(../img/language--dark.a24e849e.svg);--svg--color-scheme:url(../img/color_scheme--dark.ef0f0aed.svg)}html[data-color-scheme=dark] #contao-network{background:#292c32!important;color:#ddd!important}html{box-sizing:border-box}*,:after,:before{box-sizing:inherit}#app,body,html{height:100%}blockquote,body,figure,form,p{margin:0;padding:0}article,aside,figcaption,figure,footer,header,main,nav,section{display:block}body,div,fieldset,form,h1,h2,h3,h4,h5,h6,html,p{text-size-adjust:none}body{background:var(--body-bg);overflow-y:hidden}#app{overflow-y:scroll}fieldset{border:none;margin:0;padding:0}legend{-webkit-padding-start:0;-webkit-padding-end:0}figure{line-height:0}body,button,input,textarea{font:300 14px/1.4 -apple-system,system-ui,Segoe UI,Roboto,Oxygen-Sans,Ubuntu,Cantarell,Helvetica Neue,sans-serif;color:var(--text)}strong{font-weight:600}code{font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace}input,select,textarea{font-size:99%}input:disabled,select:disabled,textarea:disabled{color:var(--text);-webkit-text-fill-color:var(--text);cursor:text}input::-ms-clear,input::-ms-reveal,select::-ms-clear,select::-ms-reveal,textarea::-ms-clear,textarea::-ms-reveal{display:none}input::placeholder,select::placeholder,textarea::placeholder{color:var(--placeholder);-webkit-text-fill-color:var(--placeholder)}.invisible{border:0;clip:rect(0 0 0 0);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;width:1px}.clearfix{*zoom:1}.clearfix:after,.clearfix:before{display:table;content:"";line-height:0}.clearfix:after{clear:both}h1,h2,h3,h4,h5,h6{font-size:inherit;line-height:inherit;font-weight:600;margin:0}a{color:var(--link);text-decoration:none}a:hover{text-decoration:underline}h1{font-size:18px;line-height:30px;margin-bottom:10px}@keyframes input-error{0%{left:0}25%{left:-5px}75%{left:5px}to{left:0}}.widget{position:relative}.widget__error{display:none;position:absolute;left:0;right:0;margin:0;padding:4px 10px;color:var(--clr-btn);background:var(--btn-alert);border-radius:2px;transform:translateY(6px);z-index:10;white-space:pre-line}.widget__error:after,.widget__error:before{bottom:100%;left:30px;border:solid transparent;content:" ";height:0;width:0;position:absolute;pointer-events:none}.widget__error:after{border-bottom-color:var(--btn-alert);border-width:3px;margin-left:-3px}.widget__error:before{border-bottom-color:var(--btn-alert);border-width:5px;margin-left:-5px}input:focus+*+.widget__error,input:focus+.widget__error,input:hover+*+.widget__error,input:hover+.widget__error,select:hover+.widget__error{display:block}.widget__description{margin-top:2px;font-size:12px}input:not([type=checkbox]):not([type=radio]),select{position:relative;width:100%;height:38px;padding:0 20px;background:var(--form-bg);border:1px solid var(--border);border-radius:6px;color:var(--text);appearance:none}input:not([type=checkbox]):not([type=radio]):focus,select:focus{outline:none;background-color:var(--focus)}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:placeholder-shown):valid,.widget--validate select:not(:placeholder-shown):valid{border-color:var(--btn-primary)}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:placeholder-shown):invalid,.widget--validate select:not(:placeholder-shown):invalid{border-color:var(--btn-alert)}.widget--error input:not([type=checkbox]):not([type=radio]),.widget--error select{border-color:var(--btn-alert);animation:input-error .15s linear 3}select{padding-right:30px}.widget-select:after{position:absolute;right:12px;bottom:16px;width:0;height:0;border-left:6px solid transparent;border-right:6px solid transparent;border-top:6px solid var(--border);content:"";pointer-events:none}.widget-button{display:inline-block;width:100%;height:38px;padding:0;border:none;background-color:var(--btn);color:var(--clr-btn);font-weight:600;line-height:38px;text-decoration:none;text-align:center;white-space:nowrap;cursor:pointer;border-radius:5px}.widget-button:active,.widget-button:hover{background-color:var(--btn-active)}.widget-button--inline{width:auto!important;min-width:100px;padding:0 20px}.widget-button--transparent{background:transparent}.widget-button--small{height:28px;width:auto!important;min-width:0;padding:0 15px;font-size:13px;line-height:28px;font-weight:300}.widget-button--small:before,.widget-button--small>:before{top:3px!important;width:15px!important;height:15px!important;margin-right:6px!important;background-size:15px 15px!important}.widget-button--primary{--btn:var(--btn-primary);--btn-active:var(--btn-primary-active)}.widget-button--warning{--btn:var(--btn-warning);--btn-active:var(--btn-warning-active)}.widget-button--alert{--btn:var(--btn-alert);--btn-active:var(--btn-alert-active)}.widget-button--info{--btn:var(--btn-info);--btn-active:var(--btn-info-active)}.widget-button--funding{--btn:var(--btn-funding);--btn-active:var(--btn-funding-active)}.widget-button:empty{min-width:auto;padding:0 10px}.widget-button:empty:before{margin-right:0!important}.widget-button:hover{text-decoration:none}.widget-button.disabled,.widget-button:disabled{background-color:var(--btn-disabled)!important;border-color:var(--btn-disabled)!important;cursor:not-allowed;opacity:var(--opacity-disabled,1)}.widget-button.disabled{pointer-events:none}.widget-button--anchor{height:auto;background:none!important;line-height:inherit;font-weight:inherit;color:var(--link);text-decoration:none;cursor:pointer}.widget-button--anchor:hover{text-decoration:underline!important}.widget-button--anchor.disabled,.widget-button--anchor:disabled{background:none!important}label{padding:0}.widget--required label:after{margin-left:2px;content:"*";color:var(--btn-alert)}input:-webkit-autofill,select:-webkit-autofill{-webkit-text-fill-color:var(--text);-webkit-box-shadow:inset 0 0 0 1000px hsla(0,0%,100%,0);transition:background-color 5000s ease-in-out 0s}.widget-button--details:before{background-image:url(../img/button-details.8ce780e9.svg)}.widget-button--link:before{background-image:url(../img/button-link.dd42e161.svg)}.widget-button--search:before{background-image:url(../img/button-search.44ce1d4b.svg)}.widget-button--add:before,.widget-button--check:before,.widget-button--clipboard:before,.widget-button--cloud-off:before,.widget-button--cloud:before,.widget-button--console:before,.widget-button--database:before,.widget-button--details:before,.widget-button--download:before,.widget-button--edit:before,.widget-button--gear:before,.widget-button--hide:before,.widget-button--link:before,.widget-button--lock:before,.widget-button--maintenance:before,.widget-button--more:before,.widget-button--passkey:before,.widget-button--power:before,.widget-button--run:before,.widget-button--save:before,.widget-button--search:before,.widget-button--show:before,.widget-button--trash:before,.widget-button--unlock:before,.widget-button--update:before,.widget-button--upload:before{position:relative;display:inline-block;top:5px;width:20px;height:20px;margin-right:8px;background-position:50%;background-repeat:no-repeat;background-size:18px 18px;content:""}.widget-button--add:empty:before,.widget-button--check:empty:before,.widget-button--clipboard:empty:before,.widget-button--cloud-off:empty:before,.widget-button--cloud:empty:before,.widget-button--console:empty:before,.widget-button--database:empty:before,.widget-button--details:empty:before,.widget-button--download:empty:before,.widget-button--edit:empty:before,.widget-button--gear:empty:before,.widget-button--hide:empty:before,.widget-button--link:empty:before,.widget-button--lock:empty:before,.widget-button--maintenance:empty:before,.widget-button--more:empty:before,.widget-button--passkey:empty:before,.widget-button--power:empty:before,.widget-button--run:empty:before,.widget-button--save:empty:before,.widget-button--search:empty:before,.widget-button--show:empty:before,.widget-button--trash:empty:before,.widget-button--unlock:empty:before,.widget-button--update:empty:before,.widget-button--upload:empty:before{margin-right:0!important}.animate-initializing{animation:initializing 1s linear infinite}@keyframes initializing{0%{opacity:.5}50%{opacity:1}to{opacity:.5}}.animate-blur-in{z-index:-1;opacity:.5;filter:blur(4px);transition:opacity .35s,filter .5s}.animate-blur-out{opacity:1;transition:opacity .35s}.animate-fade-enter-active,.animate-fade-leave-active{transition-duration:.2s;transition-property:opacity;transition-timing-function:ease}.animate-fade-enter,.animate-fade-leave-active{opacity:0}.animate-flip-enter-active,.animate-flip-leave-active{transform-style:preserve-3d;backface-visibility:hidden;transition-duration:.5s;transition-property:transform,opacity}.animate-flip-leave-active{transform:perspective(600px) rotateY(0deg);opacity:1}.animate-flip-leave-to{transform:perspective(600px) rotateY(90deg);transition-timing-function:ease-in;opacity:0}.animate-flip-enter-active{transform:perspective(400px) rotateY(270deg);opacity:0}.animate-flip-enter-to{transform:perspective(400px) rotateY(1turn);transition-timing-function:ease-out;opacity:1}:root{--header-main-bg:#fff;--footer-fragment-bdr:#eee;--table-odd-bg:#f5f9fa;--border-radius:6px;--log-header-bg:var(--shadow)}html[data-color-scheme=dark]{--header-main-bg:#292c32;--footer-fragment-bdr:var(--footer-bdr);--table-odd-bg:var(--tiles-bg);--link-footer:#fff;--hint-bg:#151619;--hint-rgb:21,22,25;--log-header-bg:var(--btn)}html[data-color-scheme=dark] .vjs-tree-node:hover{background-color:#2b3439}.color-scheme--light,html[data-color-scheme=dark] .color-scheme--dark{display:initial}.color-scheme--dark,html[data-color-scheme=dark] .color-scheme--light{display:none}.app-hint{position:absolute;top:0;left:0;right:0;height:27px;padding:4px 8px;background:var(--btn-info);color:#fff;text-align:center;z-index:100}.app-hint--warning{background:var(--btn-warning)}.app-hint--alert{background:var(--btn-alert)}.app-hint__description{display:none}@media(min-width:600px){.app-hint__description{display:inline}}.app-hint__link{margin:0;padding:0;background:none;border:none;color:#fff;text-decoration:underline;cursor:pointer}.app-hint+div{padding-top:25px}.view-init{display:table;width:100%;height:100%}.view-init__cell{display:table-cell;font-size:1.5em;text-align:center;vertical-align:middle}.widget-button--add:before{background-image:url(../img/button-add.759df12e.svg)}.widget-button--check:before{background-image:url(../img/button-check.7a3b5ada.svg)}.widget-button--clipboard:before{background-image:url(../img/button-clipboard.9ef63d39.svg)}.widget-button--cloud:before{background-image:url(../img/button-cloud.bc42f267.svg)}.widget-button--cloud-off:before{background-image:url(../img/button-cloud-off.dd8ba18e.svg)}.widget-button--console:before{background-image:url(../img/button-console.05dcdfc4.svg)}.widget-button--database:before{background-image:url(../img/button-database.5282fc7e.svg)}.widget-button--download:before{background-image:url(../img/button-download.e1ba6f25.svg)}.widget-button--edit:before{background-image:url(../img/button-edit.40a4be06.svg)}.widget-button--gear:before{background-image:url(../img/button-gear.a2dc1f09.svg)}.widget-button--hide:before{background-image:url(../img/button-hide.d23f6533.svg)}.widget-button--lock:before{background-image:url(../img/button-lock.98988f08.svg)}.widget-button--maintenance:before{background-image:url(../img/button-maintenance.93830369.svg)}.widget-button--more:before{background-image:url(../img/button-more.e3eb2622.svg)}.widget-button--passkey:before{background-image:url(../img/button-passkey.3806f98a.svg)}.widget-button--power:before{background-image:url(../img/button-power.298a8072.svg)}.widget-button--run:before{background-image:url(../img/button-run.b6310c5a.svg)}.widget-button--save:before{background-image:url(../img/button-save.3b5224de.svg)}.widget-button--show:before{background-image:url(../img/button-show.2336e1d9.svg)}.widget-button--trash:before{background-image:url(../img/button-trash.855f57fa.svg)}.widget-button--unlock:before{background-image:url(../img/button-unlock.51b76e07.svg)}.widget-button--update:before{background-image:url(../img/button-update.ad79c617.svg)}.widget-button--upload:before{background-image:url(../img/button-upload.ca8e9cfc.svg)}"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[557],{1557:function(a){a.exports=JSON.parse('{"ui.app.title":"Расширения Contao","ui.app.loading":"Загрузка списка расширений...","ui.app.language":"Переключить язык Contao Manager","ui.app.colorDark":"Темный режим","ui.app.colorDarkTitle":"Переключить цветовую схему на темную","ui.app.colorLight":"Светлый режим","ui.app.colorLightTitle":"Переключить цветовую схему на светлую","ui.discover.advertisement":"Реклама в списке расширений","ui.discover.loading":"Загрузка...","ui.discover.offline":"Не удалось получить результаты.","ui.discover.offlineExplain":"Проверьте подключение к сети Интернет и отключите блокировку JavaScript в своем браузере.","ui.discover.offlineButton":"Попробовать еще раз","ui.discover.searchPlaceholder":"Поиск в {count} расширениях...","ui.discover.empty":"Нет результатов для {query}","ui.discover.more":"Другие результаты","ui.discover.sortBy":"Сортировать по","ui.discover.sortReleased":"Выпуск","ui.discover.sortReleasedTitle":"Сортировать результаты по дате выпуска","ui.discover.sortLatest":"Обновлено","ui.discover.sortLatestTitle":"Сортировать результаты по последнему обновлению","ui.discover.sortDownloads":"Загрузки","ui.discover.sortDownloadsTitle":"Сортировать результаты по количеству загрузок","ui.discover.sortFavers":"Рейтинг","ui.discover.sortFaversTitle":"Сортировать результаты по рейтингу","ui.discover.detailsButton":"Сведения","ui.discover.latestPackages":"Последние и обновленные расширения","ui.discover.faversPackages":"Расширения с высоким рейтингом","ui.discover.downloadsPackages":"Самые загружаемые расширения","ui.discover.exactHit":"Точное соответствие запросу","ui.discover.results":"Больше результатов поиска","ui.package.homepage":"Веб-сайт проекта","ui.package.private":"Частный пакет","ui.package.privateTitle":"Частные пакеты доступны только у поставщика (наприм., в виде загрузки ZIP-файла). Посетите веб-сайт для получения дополнительной информации.","ui.package.abandoned":"Заброшенный","ui.package.abandonedText":"Этот пакет отмечен как заброшенный и больше не поддерживается.","ui.package.abandonedReplace":"Этот пакет имеет статус заброшенного и больше не поддерживается. Автор предлагает вместо него использовать пакет {replacement}.","ui.package.contaoVersion":"Доступно для Contao","ui.package-details.previous":"Детали предыдущего расширения","ui.package-details.close":"Закрыть детали расширения","ui.package-details.loading":"Загрузка...","ui.package-details.tabDescription":"Описание","ui.package-details.tabRequire":"Требования","ui.package-details.tabFeatures":"Особенности","ui.package-details.tabSuggest":"Предложения","ui.package-details.tabConflict":"Конфликты","ui.package-details.tabDependents":"Зависимые","ui.package-details.linkRequires":"требует","ui.package-details.linkReplaces":"заменяет","ui.package-details.linkProvides":"обеспечивает","ui.package-details.linkConflicts":"конфликты","ui.package-details.funding":"Финансировать дальнейшее развитие!","ui.package-details.contaoVersions":"Поддерживаемые версии Contao","ui.package-details.latest":"Последняя версия","ui.package-details.released":"выпуск от","ui.package-details.license":"Лицензия(и)","ui.package-details.authors":"из","ui.package-details.more":"Еще","ui.package-details.packagist":"Сведения о пакете","ui.package-details.metadata":"Редактировать метаданные","ui.package-details.support_docs":"Документация","ui.package-details.support_wiki":"Вики","ui.package-details.support_forum":"Форум поддержки","ui.package-details.support_issues":"Проблемы / Отчет об ошибках","ui.package-details.support_source":"Исходный код","ui.package-details.support_irc":"IRC / Чат","ui.package-details.support_email":"E-Mail поддержки","ui.package-details.support_rss":"RSS-канал"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[748],{8367:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Веза није безбедна !!","ui.app.httpsDescription":"Ако не користите HTTPS ваши поверљиви подаци ће се преносити без енкрипције.","ui.app.httpsLink":"Детаљније","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Сигурни мод је омогућен !!","ui.app.safeModeDescription":"Неке функционалности Contao Manager-a нису доступне.","ui.app.safeModeExit":"Изађи из Сигурног мода","ui.app.limitedHeadline":"Даљинска аутентификација","ui.app.limitedDescription":"You have limited permissions due to passwordless login.","ui.app.limitedLogout":"Re-authenticate","ui.app.totpHeadline":"Security Notice","ui.app.totpDescription":"Configure two-factor authentication now to secure your account.","ui.app.totpSetup":"Покретање инсталације","ui.app.loading":"Contao Manager се учитава...","ui.app.apiError":"Неочекиван статус API","ui.app.configSecurity1":"УПОЗОРЕЊЕ !!! Пронађен је незаштићен config фолдер","ui.app.configSecurity2":"Contao Manager је открио да су конфигурациони фајлови јавно доступни. Све операције су обустављене док се config фолдер не заштити. У супротном би потенцијални нападач могао да приступи осетљивим подацима о Вашој инсталацији.\\n\\nДа поправите ово, осигурајте да приступ фолдеру \\"contao-manager\\" на Вашем серверу буде спречен. Ако је потребно да прво научите како то да урадите, прочитајте упутство за ваш сервер или контактирајте корисничку подршку Вашег хостинг провајдера.","ui.account.welcome":"Добро дошли","ui.account.intro1":"Добродошли у Contao Manager, универзални алат за инсталацију и управљање са Вашом инсталацијом Contao Open Source CMS. Ако се први пут срећете са њим, погледајте {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} да почнете","ui.account.introManual":"прочитајте приручник","ui.account.intro2":"Ако наиђете на неки проблем, проверите {ourGithubIssues}  и слободно креирајте нову тему за било шта што до сада није пријављено.","ui.account.introIssues":"наши GitHub проблеми","ui.account.headline":"Кориснички налог","ui.account.description":"Да управљате Вашом инсталацијом, потребно је да креирате налог за Contao Manager. Имајте на уму да овај налог није исто што и налог за Contao Фронт- и БекЕнд.","ui.account.username":"Корисничко име","ui.account.password":"Лозинка","ui.account.passwordPlaceholder":"мин. 8 знакова","ui.account.passwordLength":"Унесите барем 8 знакова.","ui.account.loginInvalid":"There was an error when creating the account. Please try a different username.","ui.account.submit":"Креирај налог","ui.account.usePassword":"Use password for login","ui.account.usePasskey":"Use Passkey for login","ui.account.totpHeadline":"Two-factor authentication","ui.account.totpDescription":"Please enable two-factor authentication, which adds an extra layer of security to your account. In addition to your username and password, you will need to enter a verification code generated by a two-factor app such as 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator or any other TOTP app.","ui.account.totpSetup":"Configure now","ui.account.totpSkip":"Configure later","ui.account.login":"Decline Invitation","ui.account.contribute1":"Contao и Contao Manager су под покровитељством непрофитне организације Contao Association.","ui.account.contribute2":"Молимо Вас да размислите о томе да помогнете отвореном пројекту својом {donate}.","ui.account.contributeDonate":"донирање","ui.login.headline":"Пријава","ui.login.description":"Пријави се ради управљања инсталацијом.","ui.login.username":"Корисничко име","ui.login.password":"Лозинка","ui.login.totpHeadline":"Two-factor authentication","ui.login.totpDescription":"Please enter your verification code to complete the login process.","ui.login.totp":"Verification code","ui.login.forgotPassword":"Заборавили сте лозинку?","ui.login.button":"Пријава","ui.login.passkey":"Sign In with Passkey","ui.login.cancel":"Откажи","ui.login.or":"или","ui.login.locked":"Приступ је одбијен јер је Contao Manager закључан. Да бисте га откључали, обришите {lockFile} у почетном директоријуму ваше Contao инсталације.","ui.logout.headline":"Сесија је истекла","ui.logout.warning":"Нисте били активни дуже од 25 минута. Из безбедносних разлога ваша сесија ће бити ускоро прекинута.","ui.logout.expired":"Ваша сесија је аутоматски прекинута јер сте били неактивни дуже од 30 минута.","ui.logout.renew":"Остани пријављен","ui.logout.logout":"Одјава","ui.logout.login":"Назад на пријаву","ui.oauth.error":"Неисправан OAuth покушај. Проверите параметре.","ui.oauth.https":"URI за редирекцију МОРА да користи сигурни протокол (https:) чиме се спречава да се аутентификациони токен преноси као обични текст.","ui.oauth.headline":"Даљинска аутентификација","ui.oauth.description":"Следеће апликације или сервиси захтевају удаљени приступ Вашој инстанци Contao Manager-а.","ui.oauth.domain":"Пре него што дозволите приступ, будите сигурни да познајете овај URL и имате поверење у власника!","ui.oauth.outOfScope":"Unfortunately, you do not have the necessary permissions to grant this access.","ui.oauth.allow":"Дозволи приступ","ui.oauth.deny":"Одбиј приступ","ui.oauth.switchUser":"Switch User","ui.scope.admin":"Admin access including user management","ui.scope.install":"Install new packages and change Contao configuration","ui.scope.update":"Update packages and execute maintenance tasks","ui.scope.read":"Read packages and configuration","ui.boot.headline":"Провера система","ui.boot.description":"Молимо сачекајте, анализирам ваш сервер ...","ui.boot.issue1":"Пронађен је проблем приликом инсталације","ui.boot.issue2":"Ваша инсталација има проблеме који морају бити решени како бисте могли да користите Contao Manager.","ui.boot.run":"Покрени Contao Manager","ui.boot.safeMode":"Покрени у Safe Mode","ui.recovery.headline":"Опоравак система","ui.recovery.description":"Contao Manager је открио фајлове који наликују на Contaо, али интерфејс командне линије - Command Line Interface - не ради како би требао.","ui.recovery.console":"Испис конзоле","ui.recovery.repairOptions":"Одаберите опцију за опоравак инсталације.","ui.recovery.repairHeadline":"Аутоматска поправка","ui.recovery.repairDescription":"Аутоматска поправка инсталације поновним креирањем апликативног cache-а и реинсталацијом пакета Композера.","ui.recovery.repairWarning":"Било која модификација vendor фајлова можда ће бити обрисана приликом процедуре!","ui.recovery.repairFailed":"Аутоматска поправка није успела. Пробајте ручно да поправите инсталацију у Safe Mode-у.","ui.recovery.repairButton":"Покрени системску поправку","ui.recovery.safeModeHeadline":"Safe Mode","ui.recovery.safeModeDescription":"Покретањем Contao Manager-а у Safe Mode-у омогућиће управљање пакетима и одређеним задацима одржавања, али могућности које се ослањају на постојећу инсталацију Contao неће бити доступне.","ui.recovery.safeModeButton":"Покрени у Safe Mode","ui.server.pending":"Причекајте...","ui.server.running":"Анализа је у току...","ui.server.error":"Провера није успела због неочекиваног одговора са сервера.","ui.server.details":"Детаљи","ui.server.prerequisite":"Провера је заустављена због тога што потребни предуслови нису задовољени.","ui.server.selfUpdate.title":"Ажурирања Contao Manager-а","ui.server.selfUpdate.update":"Нова верзија Contao Manager {latest} је доступна.","ui.server.selfUpdate.manualUpdate":"Нова верзија Contao Manager {latest} је доступна. Ваш сервер не подржава аутоматско ажурирање, панову верзију преузмите са {download}.","ui.server.selfUpdate.latest":"Користите последњу верзију {current}.","ui.server.selfUpdate.dev":"Развојне верзије не подржавају аутоматско ажурирање.","ui.server.selfUpdate.unsupported":"Нова верзија је доступна али не подржава вашу верзију PHP-а.","ui.server.selfUpdate.button":"Покрени Само-ажурирање","ui.server.selfUpdate.continue":"Настави","ui.server.config.title":"Конфигурација сервера","ui.server.config.setup":"Конфигуриши","ui.server.config.change":"Промени","ui.server.config.save":"Сачувај","ui.server.config.cancel":"Откажи","ui.server.config.customOption":"Остало...","ui.server.config.description":"Да би исправно извршавао позадинске задатке, Contao Manager треба да зна где се налази PHP command line binary и како да извршава команде одвојено од мрежних процеса.","ui.server.config.formTitle":"Конфигурација сервера","ui.server.config.formText":"Унесите путању до вашег PHP binary. Проверите да ли је binary у истој верзији PHP као ваш веб процес.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud омогућава инсталацију Composer зависности и у случају када ваш локални сервер не поседује довољно радне меморије. Имајте на уму да ће информације о вашим пакетима бити пренете на сервер којим управља Contao Association.","ui.server.config.cloud":"Користи Composer Resolver Cloud","ui.server.config.cli":"PHP binary","ui.server.config.stateErrorCli":"На серверу није пронађен валидан PHP binary.","ui.server.config.stateErrorCloud":"Употреба Composer Resolver Cloud није подржана.","ui.server.config.stateSuccess":"PHP binary на {php_cli}.","ui.server.php_web.title":"PHP Web Process","ui.server.php_web.below7":"Пронађена је верзија PHP {version}. Молимо Вас да што пре пређете на PHP 7!","ui.server.php_web.success":"Пронађена верзија PHP {version}, нема познатих проблема.","ui.server.php_cli.title":"PHP Command Line Interface","ui.server.php_cli.success":"Пронађена верзија PHP {version}, нема познатих проблема.","ui.server.composer.title":"Composer Environment","ui.server.composer.success":"Нема познатих проблема.","ui.server.composer.install":"Зависности Композера нису инсталиране.","ui.server.composer.button":"Инсталирај","ui.server.contao.title":"Инсталација Contao","ui.server.contao.setup":"Покретање инсталације","ui.server.contao.check":"Провери базу података","ui.server.contao.empty":"Није пронађена инсталација Contao.","ui.server.contao.old":"Верзија Contao {version} није усклађена са Contao Менаџером, па ћете морати ручно да ажурирате вашу инсталацију.","ui.server.contao.found":"Пронађен Contao {version} (API version {api}).","ui.server.contao.connectionError":"Неуспешно повезивање са сервером базе података.","ui.server.contao.connectionProblem":"Пронађен је проблем у бази података.","ui.server.contao.missingUser":"Није пронађен администраторски налог.","ui.setup.continue":"Настави","ui.setup.manager":"Покрени Contao Manager","ui.setup.cancel":"Откажи","ui.setup.welcome":"Добро дошли","ui.setup.welcome1":"Овај чаробњак ће вас водити кроз неопходне кораке за инсталацију  Contao Open Source CMS.","ui.setup.welcome2":"У случају да имате било каква питања, претражите документацију, форуме, канал на Slack-у и остале ресурсе на страници {support}.","ui.setup.support":"подршка из заједнице","ui.setup.start":"Почни","ui.setup.complete":"Честитамо!","ui.setup.complete1":"Contao {version} је успешно инсталиран.","ui.setup.complete2":"За завршетак процеса инсталације, отворите алат за инсталацију да бисте пдесили параметре конекције са базом података и креирали корисника за Бек Енд.","ui.setup.complete3":"Сада можете почети да развијате свој сајт у Бек Енду. Ако су вам потребне додатне екстензије, наставите у Contao Manager.","ui.setup.installTool":"Отвори Инсталациони алат","ui.setup.login":"Пријави се у Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". Пројекат Отвореног кода попут Contao захтева новац који не може да обезбеди само један појединац или комапнија.\\nАко имате сајт или продајете сајтове засноване на Contao, волели бисмо да добијемо вашу подршку у виду донације те да на тај начин подржите пројекат од кога зависи и ваш пословни резултат.","ui.setup.fundingLink":"Више информација","ui.setup.document-root.headline":"Подешавања мрежног сервера","ui.setup.document-root.warning":"Да бисте инсталирали Contao уз помоћ Contao Manager-а, морате да исправно подесите локацију  root-а на Вашем мрежном серверу.","ui.setup.document-root.description1":"Contao користи посебан фолдер за јавно доступне фајлове, а апликативни фајлови су инсталирани у надређеном фолдеру. Contao сада није могуће инсталирати јер структура фолдера није тачна или фолдери нису празни.","ui.setup.document-root.description2":"Ако нисте сигурни како да подесите root, прочитајте документацију или контактирајте администратора Вашег хостинг провајдера.","ui.setup.document-root.documentation":"Прочитајте документацију","ui.setup.document-root.conflictsTitle":"Инсталациони фолдер није празан","ui.setup.document-root.conflictsDirectory":"Основни директоријум ваше будуће инсталације Contao није празан. Пронашли смо {count} фајла(ова) који ће можда бити обрисани приликом инсталације. Препоручујемо да направите празну структуру директоријума, али можете и да преместите следеће фајлове и проверите поново ако нисте сигурни да ли су у употреби.","ui.setup.document-root.ignoreConflicts":"Желим да инсталирам Contao у директоријум који није празан. Разумем да ће ово можда обрисати постојеће фајлове.","ui.setup.document-root.check":"Провери поново","ui.setup.document-root.create":"Направи директоријуме","ui.setup.document-root.change":"Промени директоријуме","ui.setup.document-root.formTitle":"Подешавање директоријума","ui.setup.document-root.formText1":"Contao Manager може аутоматски да креира нову структуру директоријума на серверу.","ui.setup.document-root.formText2":"Мораћете рућно да подесите нови root за документе (нпр. преко администраторског контрол панела на хостингу).","ui.setup.document-root.autoconfig":"Разумем да морам да променим моју конфигурацију сервера. Ако то не урадим, конфигурациони фајлови ће бити изложени (укључујући детаље налога и лозинке)!","ui.setup.document-root.directory":"Нови директоријум","ui.setup.document-root.currentRoot":"Тренутни Document Root","ui.setup.document-root.newRoot":"Нови Document Root","ui.setup.document-root.finish":"Постављање директоријума","ui.setup.document-root.publicDir":"Користи {dir} за јавне фајлове (за Contao {version})","ui.setup.document-root.directoryInvalid":"Унесите исправан назив за директоријум.","ui.setup.document-root.directoryExists":"Одредишни директоријум већ постоји. Унесите други назив.","ui.setup.document-root.confirmation":"Contao Manager је успешно завршио креирање потребног директоријума за Вашу Contao инсталацију. Сада треба да подесите document root на Вашем мрежном серверу. Немојте да поново учитавате ову страницу пре тога.","ui.setup.document-root.reload":"Поново учитај страницу","ui.setup.document-root.success":"Структура директоријума на вашем серверу је исправно постављена.","ui.setup.document-root.installingProjectDir":"Апликативни фајлови ће бити инсталирани у {dir}.","ui.setup.document-root.installingPublicDir":"Јавни фајлови ће бити инсталирани у {dir}.","ui.setup.document-root.installedProjectDir":"Апликативни фајлови су инсталирани у {dir}.","ui.setup.document-root.installedPublicDir":"Јавни фајлови су инсталирани у {dir}.","ui.setup.create-project.headline":"Инсталација Contao","ui.setup.create-project.description":"Развој Contao следи принципе {semver}, што значи да се нова мања верзија објављује сваких шест месеци. Тренутно подржана издања су:","ui.setup.create-project.semver":"Семантичко верзионисање","ui.setup.create-project.latestTitle":"Последња верзија","ui.setup.create-project.ltsTitle":"Long Term Support","ui.setup.create-project.latestQ1":"Наша последња верзија нуди највише функционалности са подршком до фебруара {year}.","ui.setup.create-project.latestQ3":"Напа последња верзија нуди највише функционалности са подршком до августа {year}.","ui.setup.create-project.ltsText":"Наша тренутна LTS верзија, ако сте фокусирани на стабилност. Нуди дугорочну подршку до фебруара {year}.","ui.setup.create-project.pltsText":"Претходна LTS верзија, још увек нуди дугорочну подршку до фебруара {year}.","ui.setup.create-project.requiresPHP":"Захтева минималну верзију PHP {version}, а ви имате PHP {current}.","ui.setup.create-project.releaseplan":"За више информација, проверите {contaoReleasePlan}.","ui.setup.create-project.releaseplanLink":"План издања за Contao","ui.setup.create-project.installed":"Contao {version} је успешно инсталиран на сервер. Наставите са постављањем ваше базе података или покрените Contao Manager да инсталирате другу верзију.","ui.setup.create-project.formTitle":"Изабери дистрибуцију","ui.setup.create-project.formText":"Изаберите верзију која треба да се инсталира.","ui.setup.create-project.version":"Верзија","ui.setup.create-project.demo":"Инсталирај Contao демо сајт.","ui.setup.create-project.demoDescription":"Демо сајт помаже да се упознате са Contao и са основним функционалностима. Више тема можете пронаћи у {store}.","ui.setup.create-project.coreOnly":"Минимална инсталација (само основни модули)","ui.setup.create-project.noUpdate":"Прескочи инсталацију (само за експерте!)","ui.setup.create-project.theme":"Теме за Contao","ui.setup.create-project.themeInstall":"Да инсталирате тему за Contao, користите претрагу или учитајте фајл теме (.cto/.zip) који подржава инсталацију помоћу Contao Manager.","ui.setup.create-project.themeBuy":"Не заборавите да посетите званични {store}.","ui.setup.create-project.themeStore":"Продавница тема за Contao ","ui.setup.create-project.themeUpload":"Учитај фајл теме (.cto/.zip)","ui.setup.create-project.themeInvalid":"Учитани фајл није тема за Contao или не подржава Contao Manager.","ui.setup.create-project.themeWarning":"Contao Manager не може да процени да ли је ова тема компатибилна са вашим сервером. Проверите то са испоручиоцем од кога сте набавили тему ако имате било каква питања.","ui.setup.create-project.themeTitle":"Прегледај детаље теме","ui.setup.create-project.themeDetails":"Следеће зависности и фајлови ће бити инсталирани са овом темом.","ui.setup.create-project.themeRequire":"{count} Зависности | {count} Зависности","ui.setup.create-project.themeFiles":"{count} Фајл | {count} Фајлови","ui.setup.create-project.theme.or":"или претраже јавне теме","ui.setup.create-project.theme.search":"Претражи теме","ui.setup.create-project.theme.more":"Више тема","ui.setup.create-project.theme.empty":"Нема тема које се поклапају са {query}","ui.setup.create-project.theme.uploaded":"Фајл теме је успешно учитан.","ui.setup.create-project.theme.packageName":"Име пакета","ui.setup.create-project.theme.version":"Верзија","ui.setup.create-project.theme.authors":"Аутор(и)","ui.setup.create-project.theme.upload":"Uploading {name} ({size})","ui.setup.create-project.install":"Инсталирај","ui.setup.create-project.cancel":"Откажи","ui.setup.create-project.fileError":"Could not find composer.json in {file}.","ui.setup.create-project.jsonError":"composer.json contains invalid JSON.","ui.setup.create-project.schemaError":"composer.json schema validation failed.","ui.setup.database-connection.headline":"Конекција са базом података","ui.setup.database-connection.description":"Да би могао да чува странице, садржај, кориснике и остале релационе податке, Contao захтева MySQL базу података (или компатибилну варијанту као што је MariaDB). Параметри за повезивање су сачувани у фајлу {env} који се чува у основном фолдеру ваше Contao инсталације.","ui.setup.database-connection.formTitle":"Параметри за повезивање","ui.setup.database-connection.formText":"Унесите URL базе података или испуните корисничко име, лозинку, сервер и име базе података.","ui.setup.database-connection.url":"URL базе података","ui.setup.database-connection.validUrl":"URL базе података није исправан или повезивање са сервером није успело.","ui.setup.database-connection.or":"или","ui.setup.database-connection.user":"Корисничко име","ui.setup.database-connection.password":"Лозинка","ui.setup.database-connection.server":"Сервер (:Порт)","ui.setup.database-connection.database":"Назив базе података","ui.setup.database-connection.connected":"Повезивање са базом података {database} на серверу {server} је успело.","ui.setup.database-connection.error":"Грешка приликом повезивања са базом података.","ui.setup.database-connection.problem":"Contao је поронашао проблем са вашим сервером базе података.","ui.setup.database-connection.schemaTitle":"Шема базе података","ui.setup.database-connection.migration":"На чекању је једна миграција. | На чекању је {count} миграција.","ui.setup.database-connection.schema":"Једно ажурирање шеме је на чекању. | На чекању је {count} ажурирања шеме.","ui.setup.database-connection.noChanges":"Ваша шема у оквиру базе података је ажурна.","ui.setup.database-connection.check":"Провери базу података","ui.setup.database-connection.skip":"ПрескочиПрескочи","ui.setup.database-connection.save":"Сачувај","ui.setup.database-connection.change":"Промени креденцијале","ui.setup.database-connection.restoreTitle":"Увоз базе података","ui.setup.database-connection.restoreText":"Тема коју сте управо инсталирали садржи копију базе података. Увезите базу података да бисте увезли податке теме или прескочите овај корак да почнете са празном инсталацијом Contao. | Тема коју сте управо инсталирали садржи неколико копија базе података. Изаберите копију да увезете податке теме или прескочите овај корак да почнете са празном инсталацијом Contao.","ui.setup.database-connection.backup":"Спреми копију тренутне базе података прије увоза","ui.setup.database-connection.backupWarning":"Сви подаци у бази података ће бити обрисани и уместо њих ће се уписати нови подаци! Ако база није празна, прво направите резервну копију. ","ui.setup.database-connection.restore":"Увоз базе података","ui.setup.database-connection.restoreOption":"Резервна копија од {date} ({size})","ui.setup.database-connection.restored":"Ваша база података која припада теми је успешно увезена. Наставите према валидацији шеме базе података.","ui.setup.backend-user.success":"У бази је пронађен администраторски налог за Contao Бек Енд. Употребите Contao Бек Енд да додате нове кориснике.","ui.setup.backend-user.error":"Повлачење листе корисника није успело. Проверите испис конзоле за више детаља.","ui.setup.backend-user.headline":"Налог за Бек Енд","ui.setup.backend-user.description":"Да бисте управљали својим сајтом, морате да имате барем један администраторски налог за Contao Бек Енд. Имајте на уму да овај налог није повезан са Contao Manager.","ui.setup.backend-user.formTitle":"Креирај налог","ui.setup.backend-user.formText":"Унесите податке за нови налог Бек Енда.","ui.setup.backend-user.username":"Корисничко име","ui.setup.backend-user.name":"Име","ui.setup.backend-user.email":"E-mail адреса","ui.setup.backend-user.emailInvalid":"Унесите исправну адресу e-mailа.","ui.setup.backend-user.password":"Лозинка","ui.setup.backend-user.passwordPlaceholder":"мин. 8 знакова","ui.setup.backend-user.passwordLength":"Унесите барем 8 знакова.","ui.setup.backend-user.create":"Додај налог","ui.task.headline":"Позадински задаци","ui.task.loading":"Учитавам детаље...","ui.task.created":"Учитавам детаље...","ui.task.active":"Сачекајте док Contao Manager заврши са позадинским задацима и операцијама.","ui.task.complete":"Сви задаци су успешно завршени. За више детаља, проверите излаз конзоле.","ui.task.paused":"Позадински задатак је неочекивано заустављен. Проверите излаз конзоле.","ui.task.aborting":"Сачекајте док се позадински задаци не откажу.","ui.task.stopped":"Неки позадински задаци су отказани. Проверите излаз конзоле.","ui.task.error":"Позадински задатак је неочекивано заустављен. Проверите излаз конзоле.","ui.task.failed":"Contao Manager није успео да покрене позадински задатак!","ui.task.failedDescription1":"Нешто је кренуло погрешно приликом извршавања операција у позадини.","ui.task.failedDescription2":"Ако се ово деси поново, Ваш сервер можда не подржава инсталацију.","ui.task.reportProblem":"Пријави проблем","ui.task.pausedDescription":"Click \\"Continue\\" if you want to ignore the error and execute the remaining operations.","ui.task.sponsor":"Composer Cloud је подржан од {sponsor}","ui.task.buttonAudit":"Ажурирај базу података","ui.task.buttonClose":"Затвори","ui.task.buttonConfirm":"Потврди и затвори","ui.task.buttonContinue":"Настави","ui.task.buttonCancel":"Откажи","ui.task.confirmCancel":"Да ли сте сигурни да желите да откажете задатак? Ово ће можда довести до тога да Contao инсталација не буде комплетна.","ui.task.autoclose":"Затвори детаље задатка након успешног завршетка.","ui.console.toggle":"Прикажи/Сакриј конзолу","ui.console.showLog":"Прикажи сав лог конзоле","ui.console.copyLog":"Копирај лог у привремену меморију.","ui.migrate.headline":"Ажурирања базе података","ui.migrate.migrationsOnly":"(само миграције)","ui.migrate.schemaOnly":"(само шема)","ui.migrate.loading":"Молимо да сачекате док проверимо вашу базу података ...","ui.migrate.empty":"Нису пронађене миграције или ажурирања шеме базе података на чекању. Ваша база података је ажурна.","ui.migrate.emptyMigrations":"Нису пронађене миграције на чекању. Не заборавите да проверите и ажурирања шеме.","ui.migrate.emptySchema":"Нису пронађена ажурирања шеме на чекању. Не заборавите да проверите и миграције.","ui.migrate.pending":"Ваша база података није ажурна. Проучите испис конзоле и извршите захтеване промене.","ui.migrate.previousChanges":"Миграција претходне базе података није потврђена..\\nПроверите испис конзоле испод, а онда наставите са променама.","ui.migrate.previousComplete":"Претходна миграција базе података није потврђена, проверите испис конзоле испод.\\nНема других промена на чекању.","ui.migrate.appliedChanges":"Извршена су ажурирања базе података.\\nПроверите испис конзоле испод, а онда наставите са променама.","ui.migrate.appliedComplete":"Извршена су ажуриања базе података.\\nСада је ваша база ажурна. Нема других миграција и ажурирања шеме на чекању.","ui.migrate.problem":"Contao је пронашао проблем са вашим сервером базе података.\\nПроверите испис конзоле како бисте сазнали шта треба да се поправи. | Contao је пронашао проблем са вашим сервером базе података. \\nПроверите испис конзоле како бисте сазнали шта треба да се поправи.","ui.migrate.warning":"Contao је пронашао грешку у подешавању сервера базе података.\\nУпозорења за сада можете да занемарите, али би било добро да их поправите како бисте добили оптималне перформансе и интегритет података.","ui.migrate.error":"Промене не могу да се сачувају. Изгледа да је дошло до промена у вашој бази података, освежите податке и покушајте поново.","ui.migrate.execute":"Изврши","ui.migrate.close":"Затвори","ui.migrate.confirm":"Потврди и затвори","ui.migrate.cancel":"Откажи","ui.migrate.continue":"Настави","ui.migrate.setup":"Покретање инсталације","ui.migrate.skip":"ПрескочиПрескочи","ui.migrate.retry":"Провери поново","ui.migrate.retryAll":"Провери све","ui.migrate.withDeletes":"Изврши све промене у бази података, укључујучи DROP упите.","ui.migrate.migrationTitle":"Миграције базе података","ui.migrate.schemaTitle":"Ажурирања шема","ui.migrate.problemTitle":"Проблеми базе података","ui.migrate.warningTitle":"Упозорења базе података","ui.migrate.addTable":"Додај табелу {table}","ui.migrate.dropTable":"Обриши табелу {table}","ui.migrate.addField":"Додај колону {table}.{field}","ui.migrate.changeField":"Промени колону {table}.{field}","ui.migrate.dropField":"Обриши колону {table}.{field}","ui.migrate.createIndex":"Креирај индекс \\"{name}\\" над табелом {table}","ui.migrate.dropIndex":"Обриши индекс \\"{name}\\" над табелом {table}","ui.widget.mandatory":"Ово поље не сме бити празно.","ui.widget.blankOption":"Одаберите...","ui.widget.showPassword":"Прикажи лозинку","ui.widget.hidePassword":"Сакриј лозинку","ui.error.title":"HTTP захтев за \\"{method} {url}\\" није успео.","ui.error.server500":" Изгледа да се десила нека неочекивана грешка на серверу. Проверите логове на Вашем серверу  (Apache/Nginx) и логове Contao Manager на локацији \\"contao-manager/logs\\".","ui.error.response":"Сервер је договорио са кодом  {status}.","ui.error.moreLink":"Више информација","ui.error.support":"Подршка за  Contao","ui.error.permission":"You do not have permission to use this feature.","ui.footer.help":"Помоћ","ui.footer.reportProblem":"Пријави проблем","ui.navigation.discover":"Истражи","ui.navigation.packages":"Пакети","ui.navigation.tools":"Алати","ui.navigation.installTool":"Алат за инсталацију","ui.navigation.backend":"Contao БекЕнд","ui.navigation.debug":"Contao мод за дебаговање","ui.navigation.logViewer":"Преглед логова","ui.navigation.phpinfo":"Информације о PHP","ui.navigation.phpinfoLoading":"Учитавање информација о PHP...","ui.navigation.maintenance":"Одржавање","ui.navigation.rebuildCache":"Поновно креирај кеш","ui.navigation.users":"Accounts","ui.navigation.systemCheck":"Провера система","ui.navigation.advanced":"Напредно","ui.navigation.logout":"Одјава","ui.maintenance.database.title":"Миграције и резервне копије базе података","ui.maintenance.database.description":"Миграције базе података осигуравају конзистентност података и табела у оквиру шема.","ui.maintenance.database.migrations":"Једна миграција базе података на чекању | {count} миграција базе података на чекању","ui.maintenance.database.schemaUpdates":"Једно ажурирање шеме на чекању | {count} ажурирања шеме на чекању","ui.maintenance.database.error":"Пронађен је проблем у бази података.","ui.maintenance.database.warning":"Пронађена су упозорења за базу података.","ui.maintenance.database.button":"Провери базу података","ui.maintenance.database.migrationOnly":"Провери само миграције","ui.maintenance.database.schemaOnly":"Провери само шеме","ui.maintenance.database.installTool":"Отвори Инсталациони алат","ui.maintenance.database.createBackup":"Креирај резервну копију","ui.maintenance.database.backupUnsupported":"Резервне копије базе података нису подржане у оквиру ваше верзије Contao.","ui.maintenance.database.backupList":"Имате једну резервну копију базе података, креирану {date}. | Имате {count} резервних копија базе података, а последња је креирана {date}.","ui.maintenance.database.backupEmpty":"Тренутно немате резервне копије базе података.","ui.maintenance.rebuildCache.title":"Апликативни cache","ui.maintenance.rebuildCache.description":"Поновно креирање апликативног cache-a је потребно сваки пут када мењате било који конфигурациони фајл.","ui.maintenance.rebuildCache.rebuildProd":"Обнови продукциони Cache","ui.maintenance.rebuildCache.rebuildDev":"Обнови развојни Cache","ui.maintenance.rebuildCache.clearProd":"Обриши продукциони Cache","ui.maintenance.rebuildCache.clearDev":"Обриши развојни Cache","ui.maintenance.installTool.title":"Инсталациони алат за Contao","ui.maintenance.installTool.description":"Инсталациони алат за Contao је аутоматски закључан ако три пута заредом погрешите лозинку.","ui.maintenance.installTool.unlock":"Откључај Инсталациони алат","ui.maintenance.installTool.lock":"Закључај Инсталациони алат","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"The Composer autoloader је одговоран за учитавање PHP класа.  Аutoloader мора бити испражњен након додавања властитих namespaces у root composer.json.","ui.maintenance.dumpAutoload.button":"Испразни Autoloader","ui.maintenance.composerInstall.title":"Композер зависности - dependencies","ui.maintenance.composerInstall.description":"Композер зависности су смештене у фолдер {vendor} у root фолдеру ваше апликације. Реинсталирање зависности ће можда бити неопходно након измене или ручног копирања на сервер фајла {composerLock}.","ui.maintenance.composerInstall.button":"Покрени Инсталер","ui.maintenance.composerInstall.update":"Покрени ажурирање Композера","ui.maintenance.composerCache.title":"Композер Cache","ui.maintenance.composerCache.description":"Композер кешира преузете пакете како би побољшао перформансе. Ако имате проблеме са непотпуним фајловима, покушајте да обришете cache Композера како бисте га присилили на поновно преузимање читавог пакета.","ui.maintenance.composerCache.button":"Обриши Cache","ui.maintenance.maintenanceMode.title":"Мод одржавања","ui.maintenance.maintenanceMode.description":"Када Contao пребаците у Мод одржавања, сајт ће да приказује шаблон за \\"503 Service Unavailable\\".","ui.maintenance.maintenanceMode.enable":"Омогући","ui.maintenance.maintenanceMode.disable":"Онемогући","ui.maintenance.debugMode.title":"Мод за дебаговање","ui.maintenance.debugMode.description":"Активирајте мод за дебаговање тако што ћете поставити корисничко име и лозинку за улазну тачку {appDevPhp}.","ui.maintenance.debugMode.descriptionJwt":"Активирајте debug мод тако што ћете поставити debug колачић за тренутни домен.","ui.maintenance.debugMode.activate":"Активирај","ui.maintenance.debugMode.deactivate":"Деактивирај","ui.maintenance.debugMode.credentials":"Креденцијали","ui.maintenance.debugMode.user":"Унесите корисничко име за Мод за дебаговање.","ui.maintenance.debugMode.password":"Унесите лозинку за Мод за дебаговање.","ui.maintenance.opcodeCache.title":"Opcode Cache","ui.maintenance.opcodeCache.description":"Opcode кешира PHP фајлове ради бржег извршавања. У неким околностима мора бити обрисан ако фајлови нису препознати након измене.","ui.maintenance.opcodeCache.button":"Испразни Cache","ui.maintenance.safeMode":"Није доступно у Safe Mode","ui.maintenance.unsupported":"Није подржан у вашој верзији Contao","ui.packages.updateButton":"Ажурирај Пакете","ui.packages.searchButton":"Претрага пакета","ui.packages.searchPlaceholder":"Претрага Пакета...","ui.packages.uploadOverlay":"Превуците & пустите фајлове да бисте их пренели на сервер","ui.packages.uploadButton":"Постави пакете","ui.packages.uploadMessage":"Имате непотврђено пребацивање на сервер. | Имате {count} непотврђених пребацивања на сервер.","ui.packages.uploadApply":"Потврди преносе","ui.packages.uploadReset":"Обриши преносе","ui.packages.uploadIncomplete":"Фајл није пренесен у потпуности. Уклоните га и пробајте поново.","ui.packages.uploadDuplicate":"Изгледа да је овај фајл пренесен неколико пута. Уклоните дупликате.","ui.packages.uploadInstalled":"Овај фајл је већ инсталиран. Уклоните дупликате.","ui.packages.uploadUnsupported":"Учитавања нису подржана у вашој инсталацији. Проверите да је инсталирана екстензија PHP ZIP и ажурирајте зависности.","ui.packages.changesMessage":"Имате једну непотврђену промену. | Имате {count} непотврђених промена.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"Примени промене","ui.packages.changesApplyAll":"Ажурирај све пакете","ui.packages.changesDryrunAll":"Обави \\"dry-run\\" симулацију свих пакета.","ui.packages.changesReset":"Врати на почетно стање","ui.packages.changesReview":"Прегледај промене","ui.packagelist.loading":"Учитавам ...","ui.packagelist.uploads":"Преноси","ui.packagelist.added":"Нови пакети","ui.packagelist.installed":"Инсталирани пакети","ui.package.hintRevert":"Опозови измене","ui.package.hintNoupdate":"Не ажурирај","ui.package.hintConstraint":"Када сачувате измене, овај пакет ће бити инсталиран са ограничењима {constraint}.","ui.package.hintConstraintBest":"Када сачувате измене, овај пакет ће бити инсталиран са најбољом доступном верзијом.","ui.package.hintConstraintChange":"Када сачувате измене, ограничење овог пакета биће промењено из \\"{from}\\" у \\"{to}\\" .","ui.package.hintConstraintUpdate":"Ови пакети ће бити ажурирани када потврдите измене.","ui.package.hintAdded":"Ови пакети ће бити инсталирани када потврдите измене.","ui.package.hintRemoved":"Када сачувате измене, овај пакет ће бити уклоњен.","ui.package.requiredTitle":"ручно додати","ui.package.requiredText":"Овај пакет је захтеван у Вашем composer.json али није инсталиран.","ui.package.removedTitle":"ручно уклоњено","ui.package.removedText":"Овај пакет је уклоњен из вашег composer.json.","ui.package.installed":"Тренутно инсталирано:","ui.package.version":"Верзија {version}","ui.package.additionalDownloads":"{count} Преузимање | {count} Преузимања","ui.package.additionalStars":"{count} Звезда | {count} Звезде","ui.package.editConstraint":"Уреди","ui.package.uploadConstraint":"Ова зависности је дефинисана од пренесеног пакета.","ui.package.updateButton":"Ажурирај","ui.package.removeButton":"Уклони","ui.package.installButton":"Додај пакет","ui.package.installButtonShort":"Додавање","ui.package.detailsButton":"Детаљи","ui.package.latestConstraint":"последња верзија","ui.package.update":"Доступно је ажурирање","ui.package.updateLatest":"последња верзија","ui.package.updateAvailable":"{version} доступна","ui.package.updateUnknown":"непозната верзија","ui.package.updateConstraint":"Новија верзија изван вашег опсега верзија је доступна.","ui.package.incompatible":"{package} does not work with Contao {constraint}.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Верзија {version}","ui.cloudStatus.waitingTime":"Време чекања","ui.cloudStatus.jobs":"Тренутни задаци","ui.cloudStatus.workers":"Радници","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"нема","ui.cloudStatus.short":"ca. {minutes} min","ui.cloudStatus.long":"ca. {minutes} min {seconds} sec","ui.cloudStatus.error":"Није могуће проверити стање сервиса Composer Resolver Cloud. Можда је у току одржавање или постоје проблеми.","ui.cloudStatus.button":"Статус Cloud-а","ui.cloudStatus.refresh":"Освежи статус Cloud-а","ui.log-viewer.loading":"Учитавам ...","ui.log-viewer.empty":"Нема лог фајлова на вашем серверу. ","ui.log-viewer.reload":"Поново учитај","ui.log-viewer.file":"Лог фајл","ui.log-viewer.channel":"Канал","ui.log-viewer.channelTitle":"Канал у ком је ова порука забиљежена.","ui.log-viewer.level":"Ниво","ui.log-viewer.levelTitle":"Озбиљност лог поруке.","ui.log-viewer.timeHeader":"Време","ui.log-viewer.messageHeader":"Порука","ui.log-viewer.showContext":"Прикажи контекст","ui.log-viewer.hideContext":"Сакриј контектст","ui.log-viewer.showExtra":"Прикажи додатне информације","ui.log-viewer.hideExtra":"Сакриј додатне информације","ui.log-viewer.more":"Учитај више ...","ui.log-viewer.download":"Преузми локално","ui.log-viewer.downloadTitle":"Преузми фајл \\"{file}\\"","ui.log-viewer.prodEnvironment":"Продукционо окружење","ui.log-viewer.devEnvironment":"Развојно окружење (Debug Mode)","ui.user-manager.loading":"Loading users …","ui.user-manager.changePassword":"Change Password","ui.user-manager.setupTotp":"Setup Two-Factor Authentication","ui.user-manager.disableTotp":"Disable Two-Factor Authentication","ui.user-manager.invite":"Invite User","ui.user-manager.delete":"Delete","ui.user-manager.deleteConfirm":"Do you really want to delete user \\"{username}\\"?","ui.user-manager.deleted":"User {username} deleted successfully","ui.user-manager.passwordHeadline":"Change Password","ui.user-manager.passwordText":"To change your password, please enter the current and a new password in the respective fields.","ui.user-manager.currentPassword":"Current password","ui.user-manager.newPassword":"New password","ui.user-manager.passwordPlaceholder":"мин. 8 знакова","ui.user-manager.submitPassword":"Submit","ui.user-manager.passwordChanged":"Your password has been changed successfully.","ui.user-manager.passwordError":"This password is incorrect.","ui.user-manager.inviteHeadline":"Invite User","ui.user-manager.inviteText":"If you need multiple logins for the Contao Manager, you can create an invitation link here. Share this link with someone or use it on another device to create a new account with the given permissions.","ui.user-manager.inviteSuccess1":"A new invitation link was created. The URL below can be used to create a new user account for this Contao Manager. The invitation expires on {expires} (one week from now).","ui.user-manager.inviteSuccess2":"Please copy the link to your clipboard. It will only work once and you will not be able to see it again after closing this dialog.","ui.user-manager.createInvitation":"Create Invitation Link","ui.user-manager.clipboard":"Copy to clipboard","ui.user-manager.permissions":"Learn about permissions","ui.user-manager.cancel":"Откажи","ui.user-manager.close":"Затвори","ui.user-manager.you":"You","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"Two-Factor Authentication","ui.totp.setupQr":"Please scan the QR code with your 2FA/TOTP app.","ui.totp.setupCode":"If you cannot scan the QR code, enter this key instead:","ui.totp.codeLabel":"Verification code","ui.totp.codeDescription":"Please enter the verification code generated by your 2FA/TOTP app.","ui.totp.disableText":"Please enter the verification code to disable two-factor authentication.","ui.totp.invalid":"The verification code is invalid.","ui.totp.enable":"Омогући","ui.totp.disable":"Онемогући","ui.totp.cancel":"Откажи","ui.totp.enabled":"Two-factor authentication was enabled successfully.","ui.totp.disabled":"Two-factor authentication was disabled successfully.","ui.totp.setup":"Setup Two-Factor Authentication","ui.totp.skip":"Skip Two-Factor Authentication"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[716],{3716:function(e){e.exports=JSON.parse('{"ui.app.title":"Rozszerzenia Contao","ui.app.loading":"Ładowanie listy rozszerzeń …","ui.app.language":"Switch language for the Contao Manager","ui.app.colorDark":"Dark Mode","ui.app.colorDarkTitle":"Switch color scheme to dark","ui.app.colorLight":"Light Mode","ui.app.colorLightTitle":"Switch color scheme to light","ui.discover.advertisement":"Reklama w liście rozszerzeń","ui.discover.loading":"Ładowanie …","ui.discover.offline":"Nie znaleziono żadnych wyników.","ui.discover.offlineExplain":"Sprawdź swoje połączenie internetowe i wyłącz narzędzia blokujące JavaScript w przeglądarce.","ui.discover.offlineButton":"Spróbuj ponownie","ui.discover.searchPlaceholder":"Szukaj w {count} rozszerzeniach ...","ui.discover.empty":"Brak wyników dla {query}","ui.discover.more":"Więcej Wyników","ui.discover.sortBy":"Sortuj według","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"Data aktualizacji","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"Pobrania","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"Ocena","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"Szczegóły","ui.discover.latestPackages":"Najnowsze i zaktualizowane rozszerzenia","ui.discover.faversPackages":"Najwyżej oceniane rozszerzenia","ui.discover.downloadsPackages":"Najczęściej pobierane rozszerzenia","ui.discover.exactHit":"Exact query match","ui.discover.results":"More search results","ui.package.homepage":"Strona Projektu","ui.package.private":"Prywatny Pakiet","ui.package.privateTitle":"Prywatne pakiety są dostępne tylko bezpośrednio od dostawcy (np. jako plik ZIP). Odwiedź stronę po więcej informacji.","ui.package.abandoned":"porzucony","ui.package.abandonedText":"Ten pakiet jest porzucony i nie jest już wspierany.","ui.package.abandonedReplace":"Ten pakiet jest porzucony i nie jest już wspierany. Autor sugeruje użycie pakietu {replacement} zamiast niego.","ui.package.contaoVersion":"Available for Contao","ui.package-details.previous":"Szczegóły poprzedniego rozszerzenia","ui.package-details.close":"Zamknij szczegóły rozszerzenia","ui.package-details.loading":"Ładowanie …","ui.package-details.tabDescription":"Opis","ui.package-details.tabRequire":"Wymagania","ui.package-details.tabFeatures":"Funkcjonalności","ui.package-details.tabSuggest":"Sugestie","ui.package-details.tabConflict":"Konflikty","ui.package-details.tabDependents":"Zależności","ui.package-details.linkRequires":"wymaga","ui.package-details.linkReplaces":"zastępuje","ui.package-details.linkProvides":"dostarcza","ui.package-details.linkConflicts":"koliduje","ui.package-details.funding":"Finansuj rozwój pakietu!","ui.package-details.contaoVersions":"Supported Contao version(s)","ui.package-details.latest":"Ostatnia wersja","ui.package-details.released":"data wydania","ui.package-details.license":"Licencje","ui.package-details.authors":"od","ui.package-details.more":"Więcej","ui.package-details.packagist":"Szczegóły Pakietu","ui.package-details.metadata":"Edytuj metadane","ui.package-details.support_docs":"Dokumentacja","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Forum","ui.package-details.support_issues":"Issues / Bug Report","ui.package-details.support_source":"Kod źródłowy","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Wsparcie E-mail","ui.package-details.support_rss":"Kanał RSS"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[194],{194:function(a){a.exports=JSON.parse('{"ui.app.title":"Contao paplašinājumi","ui.app.loading":"Ielādē paplašinājumu sarakstu ...","ui.app.language":"Switch language for the Contao Manager","ui.app.colorDark":"Dark Mode","ui.app.colorDarkTitle":"Switch color scheme to dark","ui.app.colorLight":"Light Mode","ui.app.colorLightTitle":"Switch color scheme to light","ui.discover.advertisement":"Reklāma paplašinājumu sarakstā","ui.discover.loading":"Ielādē ...","ui.discover.offline":"Nevarēja iegūt nekādus rezultātus.","ui.discover.offlineExplain":"Pārbaudiet savu interneta savienojumu un atspējojiet JavaScript bloķētājus savā pārlūkprogrammā.","ui.discover.offlineButton":"Mēģini vēlreiz","ui.discover.searchPlaceholder":"Meklēt {count} paplašinājumos ...","ui.discover.empty":"Nav rezultātu {query}","ui.discover.more":"Vairāk rezultātu","ui.discover.sortBy":"Kārtot pēc","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"Atjaunināts","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"Lejupielādes","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"Vērtējums","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"Sīkāka informācija","ui.discover.latestPackages":"Jaunākie un atjauninātie paplašinājumi","ui.discover.faversPackages":"Visaugstāk novērtētie paplašinājumi","ui.discover.downloadsPackages":"Visvairāk lejupielādētie paplašinājumi","ui.discover.exactHit":"Exact query match","ui.discover.results":"More search results","ui.package.homepage":"Projekta mājaslapa","ui.package.private":"Privāta pakotne","ui.package.privateTitle":"Privātās pakotnes ir pieejamas tikai pie pārdevēja (piem., kā ZIP lejupielādes). Lūdzu, apmeklējiet vietni, lai iegūtu papildinformāciju.","ui.package.abandoned":"pamests","ui.package.abandonedText":"Šī pakotne ir pamesta un vairs netiek uzturēta.","ui.package.abandonedReplace":"Šī pakotne ir pamesta un vairs netiek uzturēta. Autors iesaka tās vietā izmantot pakotni {replacement}.","ui.package.contaoVersion":"Available for Contao","ui.package-details.previous":"Iepriekšējā paplašinājuma informācija","ui.package-details.close":"Aizvērt paplašinājuma informāciju","ui.package-details.loading":"Ielādē ...","ui.package-details.tabDescription":"Apraksts","ui.package-details.tabRequire":"Prasības","ui.package-details.tabFeatures":"Iespējas","ui.package-details.tabSuggest":"Ieteikumi","ui.package-details.tabConflict":"Konflikti","ui.package-details.tabDependents":"Atkarīgie","ui.package-details.linkRequires":"nepieciešams","ui.package-details.linkReplaces":"aizstāj","ui.package-details.linkProvides":"nodrošina","ui.package-details.linkConflicts":"konflikti","ui.package-details.funding":"Finansējiet paketes uzturēšanu!","ui.package-details.contaoVersions":"Supported Contao version(s)","ui.package-details.latest":"Jaunākā versija","ui.package-details.released":"izlaists","ui.package-details.license":"Licence(s)","ui.package-details.authors":"no","ui.package-details.more":"Vairāk","ui.package-details.packagist":"Pakotnes informācija","ui.package-details.metadata":"Rediģēt metadatus","ui.package-details.support_docs":"Dokumentācija","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Atbalsta forums","ui.package-details.support_issues":"Problēmas / Kļūdu ziņojums","ui.package-details.support_source":"Avota kods","ui.package-details.support_irc":"IRC / Tērzēšana","ui.package-details.support_email":"Atbalsta e-pasts","ui.package-details.support_rss":"RSS barotne"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[317,380],{4686:function(e,t){var s=this&&this.__extends||function(){var e=function(t,s){return e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var s in t)Object.prototype.hasOwnProperty.call(t,s)&&(e[s]=t[s])},e(t,s)};return function(t,s){if("function"!==typeof s&&null!==s)throw new TypeError("Class extends value "+String(s)+" is not a constructor or null");function i(){this.constructor=t}e(t,s),t.prototype=null===s?Object.create(s):(i.prototype=s.prototype,new i)}}();Object.defineProperty(t,"__esModule",{value:!0}),t.treeifyPaths=t.Node=t.PathTree=void 0;var i=function(){function e(e){void 0===e&&(e=""),this.path=e,this.name="",this.children=[]}return e}();t.PathTree=i;var a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s(t,e),t}(i);function o(e,t,s){void 0===s&&(s={});var a={};t.forEach((function(t){var s=t[0],o=t[1],n=r(s).split("/"),l=n[0];if(!a[l]){var u="".concat(e.path,"/").concat(n[0]);a[l]={paths:[],obj:new i(r(u))}}if(1==n.length)a[l].obj.name=l,a[l].obj.ctx=o;else{n.shift();var c=n.join("/");a[l].paths.push([c,o]),a[l].obj.ctx=o}}));var n=Object.keys(a);return s.caseInsensitive?n.sort((function(e,t){return e.toLocaleLowerCase().localeCompare(t.toLocaleLowerCase())})):n.sort(),n.forEach((function(t){var i=a[t].obj;o(i,a[t].paths,s),(i.name||i.path||i.children.length)&&e.children.push(i)})),s.directoriesFirst?e.children.sort((function(e,t){return e.children.length&&!t.children.length?-1:t.children.length&&!e.children.length?1:0})):s.directoriesLast&&e.children.sort((function(e,t){return e.children.length&&!t.children.length?1:t.children.length&&!e.children.length?-1:0})),e}function n(e,t){void 0===e&&(e=[]),void 0===t&&(t={});var s=l(e)?e.map((function(e){return[e,void 0]})):e;return o(new i,s,t)}t.Node=a,t.treeifyPaths=n,t["default"]=n;var r=function(e){return e.replace(/^\/*/,"").replace(/\/*$/,"")},l=function(e){return"string"===typeof e[0]}},5679:function(e,t,s){s.r(t),s.d(t,{default:function(){return yi}});var i=s(641),a=s(33),o=s(3382),n=s(6894);const r={key:0,class:"view-setup__steps"},l=["onClick","disabled"],u=["src"],c={key:1,class:"view-setup__main"},d={class:"view-setup__headline"},p={class:"view-setup__description"},h={class:"view-setup__description"},m={href:"/contao/install",class:"widget-button widget-button--primary view-setup__continue"},_={class:"view-setup__description"},v={href:"/contao",class:"widget-button widget-button--primary view-setup__continue"},k={class:"view-setup__funding"},b={class:"view-setup__funding-link widget-button widget-button--small widget-button--funding widget-button--link",href:"https://to.contao.org/donate",target:"_blank"},g={key:3,class:"view-setup__main"},f={class:"view-setup__headline"},y={class:"view-setup__description"},w={href:"https://to.contao.org/support",target:"_blank"};function L(e,t,s,L,$,C){const E=(0,i.g2)("i18n-t"),X=(0,i.g2)("boxed-layout");return(0,i.uX)(),(0,i.Wv)(X,{wide:!0,slotClass:"view-setup"},{default:(0,i.k6)((()=>[C.currentStep>0?((0,i.uX)(),(0,i.CE)("section",r,[(0,i.Lk)("ul",null,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(C.steps,((e,t)=>((0,i.uX)(),(0,i.CE)("li",{class:(0,a.C4)({active:C.currentStep>t}),key:e.name},[(0,i.Lk)("button",{onClick:e=>C.currentStep=t+1,disabled:C.currentStep<=t+1},[(0,i.Lk)("img",{src:e.icon,width:"24",height:"24",alt:""},null,8,u)],8,l)],2)))),128)),(0,i.Lk)("li",{class:(0,a.C4)({active:C.currentStep>C.steps.length})},t[4]||(t[4]=[(0,i.Lk)("button",{disabled:""},[(0,i.Lk)("svg",{xmlns:"http://www.w3.org/2000/svg",height:"24px",viewBox:"0 0 24 24",width:"24px"},[(0,i.Lk)("path",{d:"M0 0h24v24H0z",fill:"none"}),(0,i.Lk)("path",{d:"M9 16.2L4.8 12l-1.4 1.4L9 19 21 7l-1.4-1.4L9 16.2z"})])],-1)]),2)])])):(0,i.Q3)("",!0),C.currentStep>C.steps.length?((0,i.uX)(),(0,i.CE)("main",c,[t[6]||(t[6]=(0,i.Lk)("span",{class:"view-setup__party"},"🎉",-1)),(0,i.Lk)("h1",d,(0,a.v_)(e.$t("ui.setup.complete")),1),(0,i.Lk)("p",p,(0,a.v_)(e.$t("ui.setup.complete1",{version:e.contaoVersion})),1),e.showInstallTool?((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[(0,i.Lk)("p",h,(0,a.v_)(e.$t("ui.setup.complete2")),1),(0,i.Lk)("button",{class:"widget-button widget-button--inline",onClick:t[0]||(t[0]=(...e)=>C.launch&&C.launch(...e))},(0,a.v_)(e.$t("ui.setup.manager")),1),(0,i.Lk)("a",m,(0,a.v_)(e.$t("ui.setup.installTool")),1)],64)):((0,i.uX)(),(0,i.CE)(i.FK,{key:1},[(0,i.Lk)("p",_,(0,a.v_)(e.$t("ui.setup.complete3")),1),(0,i.Lk)("button",{class:"widget-button view-setup__continue",onClick:t[1]||(t[1]=(...e)=>C.launch&&C.launch(...e))},(0,a.v_)(e.$t("ui.setup.manager")),1),(0,i.Lk)("a",v,(0,a.v_)(e.$t("ui.setup.login")),1)],64)),(0,i.Lk)("div",k,[t[5]||(t[5]=(0,i.Lk)("figure",null,[(0,i.Lk)("img",{src:o,width:"80",height:"80",alt:""})],-1)),(0,i.Lk)("div",null,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(e.$t("ui.setup.funding").split("\n"),((e,t)=>((0,i.uX)(),(0,i.CE)("p",{key:t},(0,a.v_)(e),1)))),128)),(0,i.Lk)("p",null,[(0,i.Lk)("a",b,(0,a.v_)(e.$t("ui.setup.fundingLink")),1)])])])])):C.currentStep>0?((0,i.uX)(),(0,i.Wv)((0,i.$y)(C.steps[C.currentStep-1].component),{key:2,onContinue:t[2]||(t[2]=e=>C.currentStep+=1)},null,32)):((0,i.uX)(),(0,i.CE)("main",g,[t[7]||(t[7]=(0,i.Lk)("img",{src:n,width:"100",height:"100",alt:"Contao Logo",class:"view-setup__icon"},null,-1)),(0,i.Lk)("h1",f,(0,a.v_)(e.$t("ui.setup.welcome")),1),(0,i.Lk)("p",y,(0,a.v_)(e.$t("ui.setup.welcome1")),1),(0,i.bF)(E,{tag:"p",class:"view-setup__description",keypath:"ui.setup.welcome2"},{support:(0,i.k6)((()=>[(0,i.Lk)("a",w,(0,a.v_)(e.$t("ui.setup.support")),1)])),_:1}),(0,i.Lk)("button",{class:"widget-button widget-button--inline widget-button--primary view-setup__start",onClick:t[3]||(t[3]=e=>C.currentStep=1)},(0,a.v_)(e.$t("ui.setup.start")),1)]))])),_:1})}s(4114);var $=s(707),C=s(6278),E=s(728),X=s(3751),j=s.p+"img/document-root.0e6dd2e4.svg",F=s.p+"img/button-update.ad79c617.svg";const A={class:"setup__header"},V={class:"setup__headline"},U={key:0,class:"setup__warning"},x={class:"setup__description"},D={class:"setup__description"},S=["href"],P={class:"setup__form setup__form--center",key:"updated"},T={class:"setup__fields"},W={class:"setup__fielddesc"},I={class:"setup__directories"},q={key:0},R={key:1},B={key:2},M={key:3},O={key:4},Q={key:5},H={key:6},K={class:"setup__actions setup__actions--center"},J={class:"setup__form",key:"conflicts"},N={class:"setup__fields"},z={class:"setup__fieldtitle"},Z={class:"setup__fielddesc"},Y={key:0},G={class:"setup__actions setup__actions--center"},ee=["disabled"],te={class:"setup__form",key:"setup"},se={class:"setup__fields"},ie={class:"setup__fieldtitle"},ae={class:"setup__fielddesc"},oe={class:"setup__directories"},ne={key:0},re={key:1},le={key:2},ue={key:3},ce={key:4},de={key:5},pe={key:6},he={class:"setup__actions setup__actions--center"},me=["disabled"],_e={class:"setup__form",key:"confirmation"},ve={class:"setup__fields setup__fields--center"},ke={class:"setup__fielddesc"},be={class:"setup__actions setup__actions--center"};function ge(e,t,s,o,n,r){const l=(0,i.g2)("loading-button"),u=(0,i.g2)("check-box"),c=(0,i.g2)("text-field"),d=(0,i.g2)("radio-button"),p=(0,i.g2)("i18n-t");return(0,i.uX)(),(0,i.CE)("section",null,[(0,i.Lk)("header",A,[t[10]||(t[10]=(0,i.Lk)("img",{src:j,width:"80",height:"80",alt:"",class:"setup__icon"},null,-1)),(0,i.Lk)("h1",V,(0,a.v_)(e.$t("ui.setup.document-root.headline")),1),r.needsFix?((0,i.uX)(),(0,i.CE)("p",U,(0,a.v_)(e.$t("ui.setup.document-root.warning")),1)):(0,i.Q3)("",!0),(0,i.Lk)("p",x,(0,a.v_)(e.$t("ui.setup.document-root.description1")),1),(0,i.Lk)("p",D,(0,a.v_)(e.$t("ui.setup.document-root.description2")),1),(0,i.Lk)("a",{class:"widget-button widget-button--inline widget-button--info widget-button--link",href:`https://to.contao.org/docs/webroot?lang=${e.$i18n.locale}`,target:"_blank"},(0,a.v_)(e.$t("ui.setup.document-root.documentation")),9,S)]),null!==e.projectDir?((0,i.uX)(),(0,i.Wv)(X.eB,{key:0,name:e.forceInstall?"none":"animate-flip",type:"transition",mode:"out-in"},{default:(0,i.k6)((()=>[r.needsFix||e.wantsFix?((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[e.directoryUpdated?((0,i.uX)(),(0,i.CE)("main",P,[(0,i.Lk)("div",T,[t[13]||(t[13]=(0,i.Lk)("svg",{class:"setup__check",xmlns:"http://www.w3.org/2000/svg",width:"24",height:"24",viewBox:"0 0 24 24"},[(0,i.Lk)("path",{d:"M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2M12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4M11,16.5L6.5,12L7.91,10.59L11,13.67L16.59,8.09L18,9.5L11,16.5Z"})],-1)),(0,i.Lk)("p",W,(0,a.v_)(e.$t("ui.setup.document-root.confirmation")),1),(0,i.Lk)("dl",I,[(0,i.Lk)("dt",null,(0,a.v_)(e.$t("ui.setup.document-root.currentRoot")),1),e.isWeb?((0,i.uX)(),(0,i.CE)("dd",q,(0,a.v_)(e.projectDir)+"/web",1)):e.isPublic?((0,i.uX)(),(0,i.CE)("dd",R,(0,a.v_)(e.projectDir)+"/public",1)):((0,i.uX)(),(0,i.CE)("dd",B,(0,a.v_)(e.projectDir),1)),(0,i.Lk)("dt",null,(0,a.v_)(e.$t("ui.setup.document-root.newRoot")),1),!e.isEmpty||e.wantsFix&&e.directory||!r.canUsePublicDir||!e.usePublicDir?!e.isEmpty||e.wantsFix&&e.directory?r.canUsePublicDir&&e.usePublicDir?((0,i.uX)(),(0,i.CE)("dd",Q,[(0,i.eW)((0,a.v_)(e.projectDir),1),(0,i.Lk)("span",null,"/"+(0,a.v_)(e.directory)+"/public",1)])):((0,i.uX)(),(0,i.CE)("dd",H,[(0,i.eW)((0,a.v_)(e.projectDir),1),(0,i.Lk)("span",null,"/"+(0,a.v_)(e.directory)+"/web",1)])):((0,i.uX)(),(0,i.CE)("dd",O,[(0,i.eW)((0,a.v_)(e.projectDir),1),t[12]||(t[12]=(0,i.Lk)("span",null,"/web",-1))])):((0,i.uX)(),(0,i.CE)("dd",M,[(0,i.eW)((0,a.v_)(e.projectDir),1),t[11]||(t[11]=(0,i.Lk)("span",null,"/public",-1))]))])]),(0,i.Lk)("div",K,[(0,i.bF)(l,{inline:"",loading:e.processing,color:"primary",icon:"update",onClick:r.reload},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.document-root.reload")),1)])),_:1},8,["loading","onClick"])])])):e.conflicts.length?((0,i.uX)(),(0,i.CE)("main",J,[(0,i.Lk)("div",N,[(0,i.Lk)("h2",z,(0,a.v_)(e.$t("ui.setup.document-root.conflictsTitle")),1),(0,i.Lk)("p",Z,(0,a.v_)(e.$t("ui.setup.document-root.conflictsDirectory",{count:e.conflicts.length})),1),(0,i.Lk)("ul",null,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(e.conflicts.slice(0,5),(e=>((0,i.uX)(),(0,i.CE)("li",{key:e},(0,a.v_)(e),1)))),128)),e.conflicts.length>5?((0,i.uX)(),(0,i.CE)("li",Y,"...")):(0,i.Q3)("",!0)]),e.isPublic||e.isWeb?((0,i.uX)(),(0,i.Wv)(u,{key:0,name:"ignoreConflicts",label:e.$t("ui.setup.document-root.ignoreConflicts"),disabled:e.processing,modelValue:e.forceInstall,"onUpdate:modelValue":t[0]||(t[0]=t=>e.forceInstall=t)},null,8,["label","disabled","modelValue"])):(0,i.Q3)("",!0)]),(0,i.Lk)("div",G,[e.forceInstall?((0,i.uX)(),(0,i.CE)("button",{key:0,class:"widget-button widget-button--alert widget-button--run",onClick:t[1]||(t[1]=t=>e.$emit("continue"))},(0,a.v_)(e.$t("ui.server.contao.setup")),1)):((0,i.uX)(),(0,i.CE)(i.FK,{key:1},[(0,i.bF)(l,{inline:"",icon:"update",loading:e.processing,onClick:t[2]||(t[2]=e=>r.init(!1))},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.document-root.check")),1)])),_:1},8,["loading"]),(0,i.Lk)("button",{class:"widget-button widget-button--inline widget-button--primary widget-button--gear",disabled:e.processing,onClick:t[3]||(t[3]=t=>e.conflicts=[])},(0,a.v_)(e.$t("ui.setup.document-root.create")),9,ee)],64))])])):((0,i.uX)(),(0,i.CE)("main",te,[t[14]||(t[14]=(0,i.Lk)("img",{src:F,class:"invisible",alt:""},null,-1)),(0,i.Lk)("div",se,[(0,i.Lk)("h2",ie,(0,a.v_)(e.$t("ui.setup.document-root.formTitle")),1),(0,i.Lk)("p",ae,[(0,i.eW)((0,a.v_)(e.$t("ui.setup.document-root.formText1"))+" ",1),(0,i.Lk)("u",null,(0,a.v_)(e.$t("ui.setup.document-root.formText2")),1)]),!e.isEmpty||e.wantsFix?((0,i.uX)(),(0,i.Wv)(c,{key:0,ref:"directory",name:"directory",label:e.$t("ui.setup.document-root.directory"),error:r.directoryError,required:!e.isEmpty,pattern:"^[^/]+$",validate:"",modelValue:e.directory,"onUpdate:modelValue":t[4]||(t[4]=t=>e.directory=t)},null,8,["label","error","required","modelValue"])):(0,i.Q3)("",!0),r.canUsePublicDir?((0,i.uX)(),(0,i.Wv)(d,{key:1,name:"usePublicDir",options:r.publicDirOptions,"allow-html":"",modelValue:e.usePublicDir,"onUpdate:modelValue":t[5]||(t[5]=t=>e.usePublicDir=t)},null,8,["options","modelValue"])):(0,i.Q3)("",!0),(0,i.Lk)("dl",oe,[(0,i.Lk)("dt",null,(0,a.v_)(e.$t("ui.setup.document-root.currentRoot")),1),e.isWeb?((0,i.uX)(),(0,i.CE)("dd",ne,(0,a.v_)(e.projectDir)+(0,a.v_)(e.directorySeparator)+"web",1)):e.isPublic?((0,i.uX)(),(0,i.CE)("dd",re,(0,a.v_)(e.projectDir)+(0,a.v_)(e.directorySeparator)+"public",1)):((0,i.uX)(),(0,i.CE)("dd",le,(0,a.v_)(e.projectDir),1)),(0,i.Lk)("dt",null,(0,a.v_)(e.$t("ui.setup.document-root.newRoot")),1),!e.isEmpty||e.wantsFix&&e.directory||!r.canUsePublicDir||!e.usePublicDir?!e.isEmpty||e.wantsFix&&e.directory?r.canUsePublicDir&&e.usePublicDir?((0,i.uX)(),(0,i.CE)("dd",de,[(0,i.eW)((0,a.v_)(e.projectDir),1),(0,i.Lk)("span",null,(0,a.v_)(e.directorySeparator)+(0,a.v_)(e.directory)+(0,a.v_)(e.directorySeparator)+"public",1)])):((0,i.uX)(),(0,i.CE)("dd",pe,[(0,i.eW)((0,a.v_)(e.projectDir),1),(0,i.Lk)("span",null,(0,a.v_)(e.directorySeparator)+(0,a.v_)(e.directory)+(0,a.v_)(e.directorySeparator)+"web",1)])):((0,i.uX)(),(0,i.CE)("dd",ce,[(0,i.eW)((0,a.v_)(e.projectDir),1),(0,i.Lk)("span",null,(0,a.v_)(e.directorySeparator)+"web",1)])):((0,i.uX)(),(0,i.CE)("dd",ue,[(0,i.eW)((0,a.v_)(e.projectDir),1),(0,i.Lk)("span",null,(0,a.v_)(e.directorySeparator)+"public",1)]))]),(0,i.bF)(u,{name:"autoconfig",label:e.$t("ui.setup.document-root.autoconfig"),disabled:e.processing,modelValue:e.autoconfig,"onUpdate:modelValue":t[6]||(t[6]=t=>e.autoconfig=t)},null,8,["label","disabled","modelValue"])]),(0,i.Lk)("div",he,[(0,i.bF)(l,{color:"primary",icon:"run",loading:e.processing,disabled:!e.autoconfig||!!r.directoryError||e.wantsFix&&!e.directory&&(e.isPublic&&e.usePublicDir||e.isWeb&&!e.usePublicDir),onClick:r.setupDocroot},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.document-root.finish")),1)])),_:1},8,["loading","disabled","onClick"]),e.wantsFix?((0,i.uX)(),(0,i.CE)("button",{key:0,type:"button",class:"widget-button",disabled:e.processing,onClick:t[7]||(t[7]=(...e)=>r.init&&r.init(...e))},(0,a.v_)(e.$t("ui.setup.cancel")),9,me)):(0,i.Q3)("",!0)])]))],64)):((0,i.uX)(),(0,i.CE)("main",_e,[(0,i.Lk)("div",ve,[t[15]||(t[15]=(0,i.Lk)("svg",{class:"setup__check",xmlns:"http://www.w3.org/2000/svg",width:"24",height:"24",viewBox:"0 0 24 24"},[(0,i.Lk)("path",{d:"M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2M12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4M11,16.5L6.5,12L7.91,10.59L11,13.67L16.59,8.09L18,9.5L11,16.5Z"})],-1)),(0,i.Lk)("p",ke,(0,a.v_)(e.$t("ui.setup.document-root.success")),1),(0,i.bF)(p,{tag:"p",class:"setup__fielddesc",keypath:`ui.setup.document-root.${e.contaoVersion?"installed":"installing"}ProjectDir`},{dir:(0,i.k6)((()=>[(0,i.Lk)("code",null,(0,a.v_)(e.projectDir),1)])),_:1},8,["keypath"]),(0,i.bF)(p,{tag:"p",class:"setup__fielddesc",keypath:`ui.setup.document-root.${e.contaoVersion?"installed":"installing"}PublicDir`},{dir:(0,i.k6)((()=>[(0,i.Lk)("code",null,(0,a.v_)(r.publicDir),1)])),_:1},8,["keypath"])]),(0,i.Lk)("div",be,[e.contaoVersion?(0,i.Q3)("",!0):((0,i.uX)(),(0,i.CE)("button",{key:0,class:"widget-button widget-button--inline widget-button--gear",onClick:t[8]||(t[8]=t=>e.wantsFix=!0)},(0,a.v_)(e.$t("ui.setup.document-root.change")),1)),(0,i.Lk)("button",{class:"widget-button widget-button--inline widget-button--primary",onClick:t[9]||(t[9]=t=>e.$emit("continue"))},(0,a.v_)(e.$t("ui.setup.continue")),1)])]))])),_:1},8,["name"])):(0,i.Q3)("",!0)])}var fe=s(9757);const ye={key:0},we=["id","name","disabled","required","checked","onClick"],Le=["for","innerHTML"],$e=["for"];function Ce(e,t,s,o,n,r){return(0,i.uX)(),(0,i.CE)("fieldset",{class:(0,a.C4)(["widget widget-radio-button",{"widget--required":s.required}])},[s.label||e.$slots.label?((0,i.uX)(),(0,i.CE)("legend",ye,[(0,i.RG)(e.$slots,"label",{},(()=>[(0,i.eW)((0,a.v_)(s.label),1)]))])):(0,i.Q3)("",!0),((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(s.options,((e,t)=>((0,i.uX)(),(0,i.CE)("div",{key:t},[(0,i.Lk)("input",{ref_for:!0,ref:"input",type:"radio",id:`ctrl_${s.name}_${e.value}`,name:s.name,disabled:e.disabled,required:s.required,checked:s.modelValue===e.value,onClick:t=>r.input(e.value)},null,8,we),s.allowHtml?((0,i.uX)(),(0,i.CE)("label",{key:0,for:`ctrl_${s.name}_${e.value}`,innerHTML:e.label},null,8,Le)):((0,i.uX)(),(0,i.CE)("label",{key:1,for:`ctrl_${s.name}_${e.value}`},(0,a.v_)(e.label),9,$e))])))),128))],2)}var Ee={emits:["input","update:modelValue"],props:{name:{type:String,required:!0},options:{type:Array,required:!0},label:String,modelValue:{required:!0},disabled:Boolean,required:Boolean,allowHtml:{type:Boolean,default:!1}},methods:{input(e){this.$emit("input"),this.$emit("update:modelValue",e)}}},Xe=s(6262);const je=(0,Xe.A)(Ee,[["render",Ce]]);var Fe=je,Ae=s(3480),Ve=s(85),Ue={components:{TextField:fe.A,RadioButton:Fe,CheckBox:Ae.A,LoadingButton:Ve.A},data:()=>({processing:!1,usePublicDir:!1,wantsFix:!1,conflicts:[],isEmpty:!0,isWeb:!0,isPublic:!1,projectDir:null,autoconfig:!1,forceInstall:!1,directory:"",directoryExists:!1,directoryUpdated:!1,directorySeparator:"/"}),computed:{...(0,C.aH)("server/php-web",["phpVersionId"]),...(0,C.aH)("server/contao",["contaoVersion"]),needsFix:e=>!e.isEmpty||!e.isWeb&&(!e.isPublic||!e.canUsePublicDir),publicDirOptions:e=>[{label:e.$t("ui.setup.document-root.publicDir",{dir:"<code>web</code>",version:"4.9+"}),value:!1},{label:e.$t("ui.setup.document-root.publicDir",{dir:"<code>public</code>",version:"4.13+"}),value:!0}],canUsePublicDir:e=>e.phpVersionId>=70400,publicDir:e=>e.isWeb?`${e.projectDir}${e.directorySeparator}web`:`${e.projectDir}${e.directorySeparator}public`,directoryError(){return this.directoryExists?this.$t("ui.setup.document-root.directoryExists"):this.directory&&!this.directory.match(/^[^/]+$/)?this.$t("ui.setup.document-root.directoryInvalid"):this.wantsFix||this.isEmpty||this.directory?"":this.$t("ui.setup.document-root.directoryInvalid")}},methods:{reload(){this.processing=!0,window.location.reload()},async setupDocroot(){this.processing=!0;const e=await this.$store.dispatch("server/contao/documentRoot",{directory:!this.isEmpty||this.wantsFix?this.directory:null,usePublicDir:this.canUsePublicDir&&this.usePublicDir});if(403===e.status)return this.directoryExists=!0,this.processing=!1,void this.$refs.directory.focus();this.processing=!1,this.directoryUpdated=!0,this.$store.commit("auth/resetCountdown")},async init(e=!0){this.processing=!0;const t=await this.$store.dispatch("server/contao/get",e);this.projectDir=t.data.project_dir,this.conflicts=t.data.conflicts,this.isEmpty=0===t.data.conflicts.length,this.isWeb="web"===t.data.public_dir,this.isPublic="public"===t.data.public_dir,this.usePublicDir="public"===t.data.public_dir,this.wantsFix=!1,this.directory=this.isEmpty?"":location.hostname,this.directorySeparator=t.data.directory_separator,this.processing=!1}},watch:{directory(){this.directoryExists=!1}},async mounted(){this.init()}};const xe=(0,Xe.A)(Ue,[["render",ge]]);var De=xe,Se=(s(8111),s(1701),s.p+"img/create-project.b22522ee.svg"),Pe=s(7591);const Te={key:0,class:"setup__theme-upload"},We={key:1},Ie=["disabled"],qe={class:"setup__header"},Re=["src","alt"],Be={key:1,src:Se,width:"80",height:"80",alt:"",class:"setup__icon"},Me={class:"setup__headline"},Oe={class:"setup__description"},Qe={class:"setup__version"},He={class:"setup__version"},Ke={key:2,class:"setup__version"},Je={key:3,class:"setup__version"},Ne={key:4,class:"setup__version"},ze=["href"],Ze={class:"setup__form"},Ye={key:0,class:"setup__fields"},Ge={class:"setup__fieldtitle"},et={class:"setup__fielddesc"},tt={class:"setup__tabs"},st={class:"setup__tab-controls"},it={key:0,class:"setup__tab"},at={class:"setup__requires"},ot={key:1,class:"setup__tab setup__tab--files"},nt={class:"setup__fielddesc setup__fielddesc--warning"},rt={class:"setup__actions"},lt=["disabled"],ut={class:"setup__header"},ct={class:"setup__headline"},dt={href:"https://semver.org",target:"_blank",rel:"noreferrer noopener"},pt={class:"setup__versions"},ht={class:"setup__version--warning"},mt=["href"],_t={key:0,class:"setup__form"},vt={class:"setup__fields setup__fields--center"},kt={class:"setup__fielddesc"},bt={class:"setup__actions setup__actions--center"},gt={key:1,class:"setup__form"},ft={class:"setup__fields"},yt={class:"setup__fieldtitle"},wt={class:"setup__fielddesc setup__fielddesc--version"},Lt={key:0,class:"setup__theme"},$t={href:"https://themes.contao.org",target:"_blank"},Ct={class:"package-uploads__overlay"},Et={href:"https://themes.contao.org",target:"_blank"},Xt={class:"setup__fields"},jt={class:"setup__or"},Ft=["disabled"],At=["disabled"],Vt={key:2,class:"setup__themes"},Ut={key:1,class:"setup__theme-search setup__theme-search--offline"},xt={key:2,class:"setup__theme-search setup__theme-search--empty"},Dt={class:"setup__themes-results"},St={class:"setup__themes-more"};function Pt(e,t,s,o,n,r){const l=(0,i.g2)("file-upload"),u=(0,i.g2)("progress-bar"),c=(0,i.g2)("console-output"),d=(0,i.g2)("file-tree"),p=(0,i.g2)("loading-button"),h=(0,i.g2)("i18n-t"),m=(0,i.g2)("radio-button"),_=(0,i.g2)("check-box"),v=(0,i.g2)("search-input"),k=(0,i.g2)("button-group"),b=(0,i.g2)("loading-spinner"),g=(0,i.g2)("discover-package");return(0,i.uX)(),(0,i.CE)("div",null,[(0,i.bF)(l,{name:"package",ref:"uploader","post-action":"api/packages/uploads",multiple:!0,drop:!0,"drop-directory":!1,"chunk-enabled":!0,chunk:{action:"api/packages/uploads"},onInputFile:r.uploadTheme,onInputFilter:r.filterTheme},null,8,["onInputFile","onInputFilter"]),e.upload?((0,i.uX)(),(0,i.CE)("main",Te,[(0,i.Lk)("h1",null,(0,a.v_)(e.$t("ui.setup.create-project.theme.upload",{name:e.upload.name,size:r.uploadSize})),1),(0,i.bF)(u,{amount:e.upload.progress,color:e.upload.active||e.upload.success?"":"alert"},null,8,["amount","color"]),e.upload.active||e.upload.success?(0,i.Q3)("",!0):((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[t[13]||(t[13]=(0,i.Lk)("br",null,null,-1)),e.upload.response.exception?((0,i.uX)(),(0,i.Wv)(c,{key:0,title:e.$t(`ui.setup.create-project.${e.upload.response.error}Error`,{file:e.upload.name}),operations:[{status:"error",summary:`composer validate ${e.upload.name}#composer.json`,console:e.upload.response.exception}],"console-output":e.upload.response.exception,"force-console":!0},null,8,["title","operations","console-output"])):((0,i.uX)(),(0,i.CE)("p",We,(0,a.v_)(e.$t(`ui.setup.create-project.${e.upload.response.error}Error`,{file:e.upload.name})),1)),t[14]||(t[14]=(0,i.Lk)("br",null,null,-1)),(0,i.Lk)("button",{class:"widget-button widget-button--inline",onClick:t[0]||(t[0]=(...e)=>r.cancelTheme&&r.cancelTheme(...e)),disabled:e.processing},(0,a.v_)(e.$t("ui.setup.create-project.cancel")),9,Ie)],64))])):e.theme?((0,i.uX)(),(0,i.CE)(i.FK,{key:1},[(0,i.Lk)("header",qe,[e.themeImage?((0,i.uX)(),(0,i.CE)("img",{key:0,class:"setup__theme-image",src:e.themeImage,alt:e.theme.composerJson.name},null,8,Re)):((0,i.uX)(),(0,i.CE)("img",Be)),(0,i.Lk)("h1",Me,(0,a.v_)(e.$t("ui.setup.create-project.headline")),1),(0,i.Lk)("p",Oe,(0,a.v_)(e.$t("ui.setup.create-project.theme.uploaded")),1),(0,i.Lk)("div",Qe,[(0,i.Lk)("strong",null,(0,a.v_)(e.$t("ui.setup.create-project.theme.packageName"))+":",1),(0,i.eW)(" "+(0,a.v_)(e.theme.composerJson.name),1)]),(0,i.Lk)("div",He,[(0,i.Lk)("strong",null,(0,a.v_)(e.$t("ui.setup.create-project.theme.version"))+":",1),(0,i.eW)(" "+(0,a.v_)(e.theme.composerJson.version),1)]),e.theme.composerJson.authors||e.theme.authors?((0,i.uX)(),(0,i.CE)("div",Ke,[(0,i.Lk)("strong",null,(0,a.v_)(e.$t("ui.setup.create-project.theme.authors"))+": ",1),e.theme.composerJson.authors?((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[(0,i.eW)((0,a.v_)(e.theme.composerJson.authors.map((e=>e.name)).join(", ")),1)],64)):((0,i.uX)(),(0,i.CE)(i.FK,{key:1},[(0,i.eW)((0,a.v_)(e.theme.authors),1)],64))])):(0,i.Q3)("",!0),e.theme.composerJson.license?((0,i.uX)(),(0,i.CE)("div",Je,[(0,i.Lk)("strong",null,(0,a.v_)(e.$t("ui.package-details.license"))+":",1),(0,i.eW)(" "+(0,a.v_)(Array.isArray(e.theme.composerJson.license)?e.theme.composerJson.license.join(", "):e.theme.composerJson.license),1)])):(0,i.Q3)("",!0),e.theme.composerJson.homepage?((0,i.uX)(),(0,i.CE)("div",Ne,[(0,i.Lk)("strong",null,(0,a.v_)(e.$t("ui.package.homepage"))+": ",1),(0,i.Lk)("a",{href:e.theme.composerJson.homepage,target:"_blank"},(0,a.v_)(e.theme.composerJson.homepage),9,ze)])):(0,i.Q3)("",!0),(0,i.Lk)("button",{class:"widget-button widget-button--info widget-button--details",onClick:t[1]||(t[1]=(...e)=>r.themeDetails&&r.themeDetails(...e))},(0,a.v_)(e.$t("ui.package.detailsButton")),1)]),(0,i.Lk)("main",Ze,[e.theme.files?((0,i.uX)(),(0,i.CE)("div",Ye,[(0,i.Lk)("h2",Ge,(0,a.v_)(e.$t("ui.setup.create-project.themeTitle")),1),(0,i.Lk)("p",et,(0,a.v_)(e.$t("ui.setup.create-project.themeDetails")),1),(0,i.Lk)("div",tt,[(0,i.Lk)("div",st,[(0,i.Lk)("button",{class:(0,a.C4)(["setup__tab-control",{"setup__tab-control--active":"require"===e.view}]),onClick:t[2]||(t[2]=t=>e.view="require")},(0,a.v_)(e.$tc("ui.setup.create-project.themeRequire",Object.keys(e.theme.composerJson.require).length)),3),(0,i.Lk)("button",{class:(0,a.C4)(["setup__tab-control",{"setup__tab-control--active":"files"===e.view}]),onClick:t[3]||(t[3]=t=>e.view="files")},(0,a.v_)(e.$tc("ui.setup.create-project.themeFiles",e.theme.files.length)),3)]),"require"===e.view?((0,i.uX)(),(0,i.CE)("div",it,[(0,i.Lk)("table",at,[(0,i.Lk)("tbody",null,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(e.theme.composerJson.require,((e,t)=>((0,i.uX)(),(0,i.CE)("tr",{key:t},[(0,i.Lk)("td",null,(0,a.v_)(t)+":",1),(0,i.Lk)("td",null,(0,a.v_)(e),1)])))),128))])])])):(0,i.Q3)("",!0),"files"===e.view?((0,i.uX)(),(0,i.CE)("div",ot,[(0,i.bF)(d,{files:r.themeFiles},null,8,["files"])])):(0,i.Q3)("",!0)]),(0,i.Lk)("p",nt,(0,a.v_)(e.$t("ui.setup.create-project.themeWarning")),1)])):(0,i.Q3)("",!0),(0,i.Lk)("div",rt,[(0,i.bF)(p,{color:"primary",icon:"run",loading:e.processing,onClick:r.installTheme},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.create-project.install")),1)])),_:1},8,["loading","onClick"]),(0,i.Lk)("button",{class:"widget-button",onClick:t[4]||(t[4]=(...e)=>r.cancelTheme&&r.cancelTheme(...e)),disabled:e.processing},(0,a.v_)(e.$t("ui.setup.create-project.cancel")),9,lt)])])],64)):((0,i.uX)(),(0,i.CE)(i.FK,{key:2},[(0,i.Lk)("header",ut,[t[17]||(t[17]=(0,i.Lk)("img",{src:Se,width:"80",height:"80",alt:"",class:"setup__icon"},null,-1)),(0,i.Lk)("h1",ct,(0,a.v_)(e.$t("ui.setup.create-project.headline")),1),(0,i.bF)(h,{tag:"p",keypath:"ui.setup.create-project.description",class:"setup__description"},{semver:(0,i.k6)((()=>[(0,i.Lk)("a",dt,(0,a.v_)(e.$t("ui.setup.create-project.semver")),1)])),_:1}),(0,i.Lk)("ul",pt,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(r.versions,(e=>((0,i.uX)(),(0,i.CE)(i.FK,null,[e.description?((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[e.disabled?((0,i.uX)(),(0,i.CE)("li",{class:"setup__version",key:e.value},[(0,i.Lk)("strong",null,(0,a.v_)(e.label),1),t[16]||(t[16]=(0,i.Lk)("br",null,null,-1)),(0,i.Lk)("span",ht,(0,a.v_)(e.problem),1)])):((0,i.uX)(),(0,i.CE)("li",{class:"setup__version",key:e.value},[(0,i.Lk)("strong",null,(0,a.v_)(e.label),1),t[15]||(t[15]=(0,i.Lk)("br",null,null,-1)),(0,i.eW)(" "+(0,a.v_)(e.description),1)]))],64)):(0,i.Q3)("",!0)],64)))),256))]),(0,i.bF)(h,{tag:"p",keypath:"ui.setup.create-project.releaseplan",class:"setup__releaseplan"},{contaoReleasePlan:(0,i.k6)((()=>[(0,i.Lk)("a",{href:`https://to.contao.org/release-plan?lang=${e.$i18n.locale}`,target:"_blank",rel:"noreferrer noopener"},(0,a.v_)(e.$t("ui.setup.create-project.releaseplanLink")),9,mt)])),_:1})]),e.contaoVersion?((0,i.uX)(),(0,i.CE)("main",_t,[(0,i.Lk)("div",vt,[t[18]||(t[18]=(0,i.Lk)("svg",{class:"setup__check",xmlns:"http://www.w3.org/2000/svg",width:"24",height:"24",viewBox:"0 0 24 24"},[(0,i.Lk)("path",{d:"M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2M12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4M11,16.5L6.5,12L7.91,10.59L11,13.67L16.59,8.09L18,9.5L11,16.5Z"})],-1)),(0,i.Lk)("p",kt,(0,a.v_)(e.$t("ui.setup.create-project.installed",{version:e.contaoVersion})),1)]),(0,i.Lk)("div",bt,[(0,i.Lk)("button",{class:"widget-button widget-button--inline",onClick:t[5]||(t[5]=(...e)=>r.launch&&r.launch(...e))},(0,a.v_)(e.$t("ui.setup.manager")),1),(0,i.Lk)("button",{class:"widget-button widget-button--inline widget-button--primary",onClick:t[6]||(t[6]=t=>e.$emit("continue"))},(0,a.v_)(e.$t("ui.setup.continue")),1)])])):((0,i.uX)(),(0,i.CE)("main",gt,[(0,i.Lk)("div",ft,[(0,i.Lk)("h2",yt,(0,a.v_)(e.$t("ui.setup.create-project.formTitle")),1),(0,i.Lk)("p",wt,(0,a.v_)(e.$t("ui.setup.create-project.formText")),1),(0,i.bF)(m,{name:"version",options:r.versions,disabled:e.processing,modelValue:e.version,"onUpdate:modelValue":t[7]||(t[7]=t=>e.version=t)},null,8,["options","disabled","modelValue"]),"theme"===e.version?((0,i.uX)(),(0,i.CE)("div",Lt,[(0,i.Lk)("p",null,(0,a.v_)(e.$t("ui.setup.create-project.themeInstall")),1),(0,i.bF)(h,{keypath:"ui.setup.create-project.themeBuy",tag:"p"},{store:(0,i.k6)((()=>[(0,i.Lk)("a",$t,(0,a.v_)(e.$t("ui.setup.create-project.themeStore")),1)])),_:1}),(0,i.bo)((0,i.Lk)("div",Ct,[(0,i.Lk)("div",null,[t[19]||(t[19]=(0,i.Lk)("img",{src:Pe,alt:"",width:"128",height:"128"},null,-1)),(0,i.Lk)("p",null,(0,a.v_)(e.$t("ui.packages.uploadOverlay")),1)])],512),[[X.aG,e.$refs.uploader&&e.$refs.uploader.dropActive]])])):((0,i.uX)(),(0,i.Wv)(_,{key:1,name:"demo",label:e.$t("ui.setup.create-project.demo"),disabled:e.processing,modelValue:e.demo,"onUpdate:modelValue":t[8]||(t[8]=t=>e.demo=t)},{description:(0,i.k6)((()=>[(0,i.bF)(h,{tag:"p",keypath:"ui.setup.create-project.demoDescription"},{store:(0,i.k6)((()=>[(0,i.Lk)("a",Et,(0,a.v_)(e.$t("ui.setup.create-project.themeStore")),1)])),_:1})])),_:1},8,["label","disabled","modelValue"]))]),(0,i.Lk)("div",Xt,["theme"===e.version?((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[(0,i.bF)(p,{color:"primary",icon:"upload",loading:e.processing,onClick:r.openFileSelector},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.create-project.themeUpload")),1)])),_:1},8,["loading","onClick"]),(0,i.Lk)("div",jt,[(0,i.Lk)("span",null,(0,a.v_)(e.$t("ui.setup.create-project.theme.or")),1)]),(0,i.bF)(v,{placeholder:e.$t("ui.setup.create-project.theme.search"),disabled:e.processing},null,8,["placeholder","disabled"])],64)):((0,i.uX)(),(0,i.Wv)(k,{key:1,color:"primary",icon:"run",disabled:!e.version,loading:e.processing,onClick:t[11]||(t[11]=()=>r.install()),label:e.$t("ui.setup.create-project.install")},{default:(0,i.k6)((()=>[e.demo?(0,i.Q3)("",!0):((0,i.uX)(),(0,i.CE)("button",{key:0,class:"widget-button",disabled:!e.version||e.processing,onClick:t[9]||(t[9]=(...e)=>r.installCoreOnly&&r.installCoreOnly(...e))},(0,a.v_)(e.$t("ui.setup.create-project.coreOnly")),9,Ft)),(0,i.Lk)("button",{class:"widget-button",disabled:!e.version||e.processing,onClick:t[10]||(t[10]=(...e)=>r.installNoUpdate&&r.installNoUpdate(...e))},(0,a.v_)(e.$t("ui.setup.create-project.noUpdate")),9,At)])),_:1},8,["disabled","loading","label"]))])])),t[20]||(t[20]=(0,i.Lk)("div",{class:"clearfix"},null,-1)),e.searching||e.results||e.offline?((0,i.uX)(),(0,i.CE)("div",Vt,[e.searching&&!e.results?((0,i.uX)(),(0,i.Wv)(b,{key:0,class:"setup__theme-search setup__theme-search--loader"},{default:(0,i.k6)((()=>[(0,i.Lk)("p",null,(0,a.v_)(e.$t("ui.discover.loading")),1)])),_:1})):e.offline?((0,i.uX)(),(0,i.CE)("div",Ut,[(0,i.Lk)("p",null,(0,a.v_)(e.$t("ui.discover.offline")),1),(0,i.Lk)("p",null,(0,a.v_)(e.$t("ui.discover.offlineExplain")),1),(0,i.Lk)("button",{class:"widget-button widget-button--inline widget-button--update",onClick:t[12]||(t[12]=(...e)=>r.searchThemes&&r.searchThemes(...e))},(0,a.v_)(e.$t("ui.discover.offlineButton")),1)])):e.isSearching&&e.results&&!Object.keys(e.results).length?((0,i.uX)(),(0,i.CE)("div",xt,[(0,i.bF)(h,{tag:"p",keypath:"ui.setup.create-project.theme.empty"},{query:(0,i.k6)((()=>[(0,i.Lk)("i",null,(0,a.v_)(e.query),1)])),_:1})])):e.isSearching&&e.results?((0,i.uX)(),(0,i.CE)(i.FK,{key:3},[(0,i.Lk)("div",Dt,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(e.results,(e=>((0,i.uX)(),(0,i.Wv)(g,{class:"setup__themes-item",data:e,key:e.name},null,8,["data"])))),128))]),(0,i.Lk)("div",St,[e.hasMore?((0,i.uX)(),(0,i.Wv)(p,{key:0,inline:"",icon:"search",loading:e.searching,onClick:e.loadMore},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.create-project.theme.more")),1)])),_:1},8,["loading","onClick"])):(0,i.Q3)("",!0)])],64)):(0,i.Q3)("",!0)])):(0,i.Q3)("",!0)],64))])}s(2489),s(116),s(7588),s(4603),s(7566),s(8721);var Tt=s(4686),Wt=s.n(Tt),It=s(1881),qt=s(8568),Rt=s.n(qt);const Bt=["href"],Mt=["href"],Ot={key:3};function Qt(e,t,s,o,n,r){const l=(0,i.g2)("package-constraint"),u=(0,i.g2)("package-details");return(0,i.uX)(),(0,i.Wv)(u,null,{"package-actions":(0,i.k6)((()=>[!e.isTheme||r.data.uploaded||r.isPrivate?r.data.homepage||e.metadata.homepage?((0,i.uX)(),(0,i.CE)("a",{key:1,class:"widget-button widget-button--primary widget-button--link",target:"_blank",href:r.data.homepage||e.metadata.homepage},(0,a.v_)(e.$t("ui.package.homepage")),9,Bt)):r.isPrivate?((0,i.uX)(),(0,i.CE)("div",Ot)):((0,i.uX)(),(0,i.CE)("a",{key:2,class:"widget-button widget-button--primary widget-button--link",target:"_blank",href:`https://packagist.org/packages/${r.data.name}`},(0,a.v_)(e.$t("ui.package-details.packagist")),9,Mt)):((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[(0,i.Lk)("button",{class:"widget-button widget-button--primary widget-button--run",onClick:t[0]||(t[0]=(...e)=>r.install&&r.install(...e))},(0,a.v_)(e.$t("ui.setup.create-project.install")),1),(0,i.bF)(l,{class:"theme-details__constraint",emit:!0,data:r.data,modelValue:e.version,"onUpdate:modelValue":t[1]||(t[1]=t=>e.version=t)},null,8,["data","modelValue"])],64))])),_:1})}var Ht=s(1474),Kt=s(5062),Jt=s(416),Nt=s(8200),zt={mixins:[Jt.A,Nt.A],components:{PackageConstraint:Kt.A,PackageDetails:Ht["default"]},data:()=>({version:""}),computed:{...(0,C.aH)("packages",{allInstalled:"installed"}),current:e=>e.$route.query.p,data:e=>e.allInstalled&&e.allInstalled[e.current]||{name:e.current},isPrivate:e=>e.metadata&&!!e.metadata.private},methods:{install(){this.$store.commit("contao/installTheme",{package:this.data.name,version:this.version})}}};const Zt=(0,Xe.A)(zt,[["render",Qt]]);var Yt=Zt,Gt=s(791),es=s(9045),ts=s(6435);const ss={class:"file-tree"},is=["onClick"],as={key:1,class:"file-tree__file"};function os(e,t,s,o,n,r){const l=(0,i.g2)("file-tree",!0);return(0,i.uX)(),(0,i.CE)("ul",ss,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(s.files,((e,t)=>((0,i.uX)(),(0,i.CE)(i.FK,{key:t},[e.children.length?((0,i.uX)(),(0,i.CE)("li",{key:0,class:(0,a.C4)("file-tree__folder"+(r.isOpen(e)?" file-tree__folder--open":""))},[(0,i.Lk)("button",{onClick:t=>r.toggle(e)},(0,a.v_)(r.name(e)),9,is),r.isOpen(e)?((0,i.uX)(),(0,i.Wv)(l,{key:0,files:e.children},null,8,["files"])):(0,i.Q3)("",!0)],2)):((0,i.uX)(),(0,i.CE)("li",as,[(0,i.Lk)("span",null,(0,a.v_)(r.name(e)),1)]))],64)))),128))])}var ns={name:"FileTree",props:{files:{type:Array,required:!0}},data:()=>({open:[]}),computed:{name:()=>e=>e.name?e.name:e.path.substring(e.path.lastIndexOf("/")+1),isOpen:e=>t=>e.open.includes(t)},methods:{toggle(e){this.open.includes(e)?this.open=this.open.filter((t=>t!==e)):this.open.push(e)}}};const rs=(0,Xe.A)(ns,[["render",os]]);var ls=rs,us=s(4676),cs=s(1298),ds=s(2864),ps=s(4960),hs={mixins:[It.A],components:{ButtonGroup:us.A,FileTree:ls,DiscoverPackage:ts.A,LoadingSpinner:es.A,SearchInput:Gt.A,FileUpload:Rt(),RadioButton:Fe,CheckBox:Ae.A,LoadingButton:Ve.A,ProgressBar:cs.A,ConsoleOutput:ds.A},data:()=>({processing:!1,isWeb:!0,version:"5.6",demo:!1,view:"require",theme:null,themeImage:null,upload:null,searching:!1,results:null,hasMore:!1,offline:!1}),computed:{...(0,C.aH)("tasks",{taskStatus:"status"}),...(0,C.aH)("server/php-web",["phpVersionId","phpVersion"]),...(0,C.aH)("server/contao",["contaoVersion"]),...(0,C.aH)("contao",{themeName:"package",themeVersion:"version"}),themeFiles:e=>Wt()(e.theme.files,{directoriesFirst:!0}).children,uploadSize:e=>e.upload&&(0,ps.A)(e.upload.size)||"",versions(){const e=[];return e.push({value:"5.6",label:`Contao 5.6 (${this.$t("ui.setup.create-project.latestTitle")})`,disabled:this.phpVersionId<80200,description:this.$t("ui.setup.create-project.latestQ1",{year:"2026"}),problem:this.$t("ui.setup.create-project.requiresPHP",{version:"8.2.0",current:this.phpVersion})}),e.push({value:"5.3",label:`Contao 5.3 (${this.$t("ui.setup.create-project.ltsTitle")})`,disabled:this.phpVersionId<80100,description:this.$t("ui.setup.create-project.ltsText",{year:"2027"}),problem:this.$t("ui.setup.create-project.requiresPHP",{version:"8.1.0",current:this.phpVersion})}),e.push({value:"4.13",label:`Contao 4.13 (${this.$t("ui.setup.create-project.ltsTitle")})`,disabled:this.phpVersionId<70400,description:this.$t("ui.setup.create-project.pltsText",{year:"2025"}),problem:this.$t("ui.setup.create-project.requiresPHP",{version:"7.4.0",current:this.phpVersion})}),e.push({value:"theme",label:this.$t("ui.setup.create-project.theme")}),e}},watch:{version(){this.stopSearch(),this.searching=!1,this.results=null,this.hasMore=!1},sorting(){this.searchThemes()},query(){this.results=null,this.query?this.searchThemes():(this.searching=!1,this.hasMore=!1)},pages(){this.searchThemes()},themeName(){this.themeName&&(this.closePopup(),this.install({package:this.themeName,version:this.themeVersion}))}},methods:{...(0,C.PY)("packages/details",{closePopup:"clearCurrent"}),async searchThemes(){this.searching=!0,this.offline=!1;try{const e={facetFilters:["type:contao-theme"],hitsPerPage:10*this.pages};this.query?e.query=this.query:this.sorting&&(e.sorting=this.sorting);const t=await this.$store.dispatch("algolia/findPackages",e);if(this.hasMore=t.nbPages>1,0===t.nbHits)return void(this.results={});const s={};t.hits.forEach((e=>{s[e.name]=e})),this.results=s}catch(e){this.offline=!0}this.searching=!1},async install(e,t=null){let s;this.processing=!0,s=e||(this.theme?{upload:this.theme.upload.id}:this.demo?{package:"contao/contao-demo",version:this.version,"no-update":"no-update"===t?"1":"0"}:{version:this.version,"core-only":"core-only"===t?"1":"0","no-update":"no-update"===t?"1":"0"});try{await this.$store.dispatch("contao/install",s)}catch(i){}this.processing=!1,"complete"===this.taskStatus&&(this.$store.commit("tasks/setDeleting",!0),await this.$store.dispatch("server/composer/get",!1),"no-update"===t?(this.$store.commit("setSafeMode",!0),this.$store.commit("setView",$.A.READY)):(this.isWeb="web"===(await this.$store.dispatch("server/contao/get",!1)).data.public_dir,await Promise.all([this.$store.dispatch("contao/install-tool/fetch",!1),this.$store.dispatch("server/database/get",!1),this.$store.dispatch("contao/backup/fetch",!1)]),this.$store.commit("contao/backup/setRestore",!0),this.$store.commit("setup",3)),await this.$store.dispatch("tasks/deleteCurrent"))},installNoUpdate(){this.install(null,"no-update")},installCoreOnly(){this.install(null,"core-only")},launch(){this.$store.commit("setView",$.A.READY)},openFileSelector(){this.$refs.uploader&&this.$refs.uploader.$el.querySelector("input").click()},async filterTheme(e,t,s){if(e&&!t&&!/(\.cto|\.zip)$/i.test(e.name))return console&&console.debug(`${e.name} is not a .zip or .cto`),alert(this.$t("ui.setup.create-project.themeInvalid")),s()},async uploadTheme(e,t){if(e)if(this.processing=!0,this.$refs.uploader.uploaded&&e&&t&&!e.active&&t.active)if(this.theme.upload=e.response.data,e.success)try{await this.install()}catch(i){this.upload=null,this.processing=!1}else this.upload=e,this.processing=!1;else if(!e.active||t.active){e.url=URL.createObjectURL(e.file);try{const t=new File([e.file],e.name,{type:e.type}),a=(await s.e(710).then(s.t.bind(s,1710,23))).default,o=await a.loadAsync(t),n=o.filter((e=>!["composer.json","theme.xml"].includes(e)&&!e.startsWith("__MACOSX/")&&!e.includes(".DS_Store")&&!e.endsWith("/"))).map((e=>e.name));let r=n[0].substring(0,n[0].indexOf("/")+1);n.find((e=>e.substr(0,r.length)!==r))&&(r="");const l=JSON.parse(await o.file(`${r}composer.json`).async("string")),u=await o.file(`${r}theme.xml`).async("string"),c=new DOMParser,d=c.parseFromString(u,"application/xml");if(this.theme={tstamp:d.querySelector('table[name="tl_theme"] field[name="tstamp"]')?.innerHTML,name:d.querySelector('table[name="tl_theme"] field[name="name"]')?.innerHTML,author:d.querySelector('table[name="tl_theme"] field[name="author"]')?.innerHTML,screenshot:d.querySelector('table[name="tl_theme"] field[name="screenshot"]')?.innerHTML,composerJson:l,files:n},this.theme.screenshot&&"NULL"!==this.theme.screenshot)try{const e=await o.file(`${r}${this.theme.screenshot}`);this.themeImage=e?URL.createObjectURL(await e.async("blob")):null}catch(i){}}catch(i){console&&console.debug(i),alert(this.$t("ui.setup.create-project.themeInvalid")),this.cancelTheme()}this.processing=!1}else this.upload=e},cancelTheme(){this.theme=null,this.upload=null,this.$refs.uploader.clear()},themeDetails(){this.$store.commit("packages/setInstalled",{local:{[this.theme.composerJson.name]:Object.assign({},this.theme.composerJson,{uploaded:!0})}}),this.$store.commit("packages/details/setCurrent",this.theme.composerJson.name)},installTheme(){this.$refs.uploader.active||(this.processing=!0,this.$refs.uploader.active=!0)}},async mounted(){await this.$router.isReady(),Object.keys(this.$route.query).length&&this.$router.replace({query:null}),await this.$store.dispatch("packages/details/init",{vue:this,component:Yt}),this.$store.commit("packages/setInstalled",{}),this.isWeb="web"===(await this.$store.dispatch("server/contao/get")).data.public_dir,this.version=this.versions.find((e=>!e.disabled)).value}};const ms=(0,Xe.A)(hs,[["render",Pt]]);var _s=ms,vs=s(9472);const ks={class:"setup__header"},bs={class:"setup__headline"},gs={class:"setup__form",key:"setup"},fs={class:"setup__fields"},ys={class:"setup__fieldtitle"},ws={class:"setup__fielddesc"},Ls={key:0,class:"setup__warning"},$s={class:"setup__or"},Cs={class:"setup__actions"},Es=["disabled"],Xs={class:"setup__form",key:"confirmation"},js={class:"setup__fields"},Fs={class:"setup__fieldtitle"},As={key:"migrate"},Vs={class:"setup__fields"},Us={class:"setup__fieldtitle"},xs={key:0,class:"setup__fielddesc setup__warning"},Ds={key:1,class:"setup__fielddesc"},Ss={class:"setup__actions setup__actions--center"},Ps={key:"restored"},Ts={class:"setup__fields"},Ws={class:"setup__fieldtitle"},Is={class:"setup__fielddesc"},qs={class:"setup__actions setup__actions--center"},Rs={key:"backup"},Bs={class:"setup__fields"},Ms={class:"setup__fieldtitle"},Os={class:"setup__fielddesc"},Qs={class:"setup__fielddesc setup__warning"},Hs={class:"setup__actions"},Ks=["disabled"];function Js(e,t,s,o,n,r){const l=(0,i.g2)("i18n-t"),u=(0,i.g2)("text-field"),c=(0,i.g2)("loading-button"),d=(0,i.g2)("radio-button");return(0,i.uX)(),(0,i.CE)("section",null,[(0,i.Lk)("header",ks,[t[17]||(t[17]=(0,i.Lk)("img",{src:vs,width:"80",height:"80",class:"setup__icon",alt:""},null,-1)),(0,i.Lk)("h1",bs,(0,a.v_)(e.$t("ui.setup.database-connection.headline")),1),(0,i.bF)(l,{tag:"p",keypath:"ui.setup.database-connection.description",class:"setup__description"},{env:(0,i.k6)((()=>t[16]||(t[16]=[(0,i.Lk)("code",null,".env.local",-1)]))),_:1})]),e.currentState?((0,i.uX)(),(0,i.Wv)(X.eB,{key:0,name:"animate-flip",type:"transition",mode:"out-in"},{default:(0,i.k6)((()=>["error"===e.currentState||"edit"===e.currentState?((0,i.uX)(),(0,i.CE)("main",gs,[(0,i.Lk)("form",{onSubmit:t[7]||(t[7]=(0,X.D$)(((...e)=>r.save&&r.save(...e)),["prevent"]))},[(0,i.Lk)("div",fs,[(0,i.Lk)("h2",ys,(0,a.v_)(e.$t("ui.setup.database-connection.formTitle")),1),(0,i.Lk)("p",ws,(0,a.v_)(e.$t("ui.setup.database-connection.formText")),1),"edit"!==e.currentState&&""!==e.currentUrl?((0,i.uX)(),(0,i.CE)("p",Ls,(0,a.v_)(e.$t("ui.setup.database-connection.error")),1)):(0,i.Q3)("",!0),(0,i.bF)(u,{ref:"url",name:"url",type:"url",label:e.$t("ui.setup.database-connection.url"),placeholder:"mysql://user:password@server:port/database",required:"",pattern:e.urlPattern,validate:"",disabled:e.processing,modelValue:e.url,"onUpdate:modelValue":t[0]||(t[0]=t=>e.url=t),onKeyup:t[1]||(t[1]=t=>e.validUrl=!0),onBlur:r.parseUrl,error:e.validUrl?void 0:e.$t("ui.setup.database-connection.validUrl")},null,8,["label","pattern","disabled","modelValue","onBlur","error"]),(0,i.Lk)("div",$s,[(0,i.Lk)("span",null,(0,a.v_)(e.$t("ui.setup.database-connection.or")),1)]),(0,i.bF)(u,{name:"user",label:e.$t("ui.setup.database-connection.user"),disabled:e.processing,modelValue:e.user,"onUpdate:modelValue":t[2]||(t[2]=t=>e.user=t)},null,8,["label","disabled","modelValue"]),(0,i.bF)(u,{name:"password",type:"password",label:e.$t("ui.setup.database-connection.password"),disabled:e.processing,modelValue:e.password,"onUpdate:modelValue":t[3]||(t[3]=t=>e.password=t)},null,8,["label","disabled","modelValue"]),(0,i.bF)(u,{name:"server",label:e.$t("ui.setup.database-connection.server"),disabled:e.processing,required:"",modelValue:e.server,"onUpdate:modelValue":t[4]||(t[4]=t=>e.server=t)},null,8,["label","disabled","modelValue"]),(0,i.bF)(u,{name:"database",label:e.$t("ui.setup.database-connection.database"),disabled:e.processing,required:"",modelValue:e.database,"onUpdate:modelValue":t[5]||(t[5]=t=>e.database=t)},null,8,["label","disabled","modelValue"])]),(0,i.Lk)("div",Cs,[(0,i.bF)(c,{submit:"",color:"primary",icon:"save",loading:e.processing,disabled:!e.valid},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.database-connection.save")),1)])),_:1},8,["loading","disabled"]),"edit"===e.currentState?((0,i.uX)(),(0,i.CE)("button",{key:0,type:"button",class:"widget-button",disabled:e.processing,onClick:t[6]||(t[6]=(...e)=>r.load&&r.load(...e))},(0,a.v_)(e.$t("ui.setup.cancel")),9,Es)):(0,i.Q3)("",!0)])],32)])):((0,i.uX)(),(0,i.CE)("main",Xs,[(0,i.Lk)("div",js,[(0,i.Lk)("h2",Fs,(0,a.v_)(e.$t("ui.setup.database-connection.formTitle")),1),e.url?((0,i.uX)(),(0,i.Wv)(l,{key:0,tag:"p",keypath:"ui.setup.database-connection.connected",class:"setup__fielddesc"},{database:(0,i.k6)((()=>[(0,i.Lk)("i",null,(0,a.v_)(e.database),1)])),server:(0,i.k6)((()=>[(0,i.Lk)("i",null,(0,a.v_)(e.server),1)])),_:1})):(0,i.Q3)("",!0),(0,i.Lk)("button",{type:"button",class:"widget-button widget-button--edit widget-button--small",onClick:t[8]||(t[8]=t=>e.currentState="edit")},(0,a.v_)(e.$t("ui.setup.database-connection.change")),1)]),(0,i.bF)(X.eB,{name:"animate-flip",type:"transition",mode:"out-in"},{default:(0,i.k6)((()=>[!e.hasDatabaseError&&e.backupRestore&&e.hasBackups?e.backupRestored?((0,i.uX)(),(0,i.CE)("div",Ps,[(0,i.Lk)("div",Ts,[(0,i.Lk)("h2",Ws,(0,a.v_)(e.$t("ui.setup.database-connection.restoreTitle")),1),t[18]||(t[18]=(0,i.Lk)("svg",{class:"setup__check",xmlns:"http://www.w3.org/2000/svg",width:"24",height:"24",viewBox:"0 0 24 24"},[(0,i.Lk)("path",{d:"M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2M12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4M11,16.5L6.5,12L7.91,10.59L11,13.67L16.59,8.09L18,9.5L11,16.5Z"})],-1)),(0,i.Lk)("p",Is,(0,a.v_)(e.$t("ui.setup.database-connection.restored")),1)]),(0,i.Lk)("div",qs,[(0,i.Lk)("button",{type:"button",class:"widget-button widget-button--primary",onClick:t[12]||(t[12]=t=>e.$store.commit("contao/backup/setRestore",!1))},(0,a.v_)(e.$t("ui.setup.continue")),1)])])):((0,i.uX)(),(0,i.CE)("div",Rs,[(0,i.Lk)("div",Bs,[(0,i.Lk)("h2",Ms,(0,a.v_)(e.$t("ui.setup.database-connection.restoreTitle")),1),(0,i.Lk)("p",Os,(0,a.v_)(e.$tc("ui.setup.database-connection.restoreText",e.files.length)),1),e.files.length>1?((0,i.uX)(),(0,i.Wv)(d,{key:0,required:"","allow-html":"",options:r.fileOptions,name:"selection",modelValue:e.selection,"onUpdate:modelValue":t[13]||(t[13]=t=>e.selection=t)},null,8,["options","modelValue"])):(0,i.Q3)("",!0),(0,i.Lk)("p",Qs,(0,a.v_)(e.$t("ui.setup.database-connection.backupWarning")),1)]),(0,i.Lk)("div",Hs,[(0,i.Lk)("button",{type:"button",class:"widget-button widget-button--inline",onClick:t[14]||(t[14]=t=>e.$store.commit("contao/backup/setRestore",!1))},(0,a.v_)(e.$t("ui.setup.database-connection.skip")),1),(0,i.Lk)("button",{type:"button",class:"widget-button widget-button--inline widget-button--primary",disabled:e.files.length>1&&!e.selection,onClick:t[15]||(t[15]=(...e)=>r.restore&&r.restore(...e))},(0,a.v_)(e.$t("ui.setup.database-connection.restore")),9,Ks)])])):((0,i.uX)(),(0,i.CE)("div",As,[(0,i.Lk)("div",Vs,[(0,i.Lk)("h2",Us,(0,a.v_)(e.$t("ui.setup.database-connection.schemaTitle")),1),e.status&&e.status.total>0?((0,i.uX)(),(0,i.CE)("p",xs,(0,a.v_)(e.$tc(`ui.setup.database-connection.${e.currentState}`,e.status.total)),1)):((0,i.uX)(),(0,i.CE)("p",Ds,(0,a.v_)(e.$t("ui.setup.database-connection.noChanges")),1))]),(0,i.Lk)("div",Ss,[e.status&&e.status.total>0?((0,i.uX)(),(0,i.CE)(i.FK,{key:0},[e.hasDatabaseError?(0,i.Q3)("",!0):((0,i.uX)(),(0,i.CE)("button",{key:0,type:"button",class:"widget-button widget-button--inline",onClick:t[9]||(t[9]=t=>e.$emit("continue"))},(0,a.v_)(e.$t("ui.setup.database-connection.skip")),1)),(0,i.Lk)("button",{type:"button",class:"widget-button widget-button--inline widget-button--primary",onClick:t[10]||(t[10]=(...e)=>r.checkMigrations&&r.checkMigrations(...e))},(0,a.v_)(e.$t("ui.setup.database-connection.check")),1)],64)):((0,i.uX)(),(0,i.CE)("button",{key:1,type:"button",class:"widget-button widget-button--primary",onClick:t[11]||(t[11]=t=>e.$emit("continue"))},(0,a.v_)(e.$t("ui.setup.continue")),1))])]))])),_:1})]))])),_:1})):(0,i.Q3)("",!0)])}var Ns=s(4210),zs={components:{RadioButton:Fe,TextField:fe.A,LoadingButton:Ve.A},data:()=>({processing:!1,validUrl:!0,valid:!1,validating:!1,currentState:null,url:"",user:"",password:"",server:"localhost",database:"",backup:!0,selection:null}),computed:{...(0,C.aH)("tasks",{taskStatus:"status"}),...(0,C.aH)("contao/backup",{backupRestored:"restored",backupRestore:"restore"}),...(0,C.aH)("server/database",{currentUrl:"url",urlPattern:"pattern",status:"status"}),...(0,C.aH)("contao/backup",["files"]),...(0,C.L8)("server/database",{hasDatabaseError:"hasError"}),...(0,C.L8)("contao/backup",["hasBackups"]),fileOptions(){return this.files.map((e=>({value:e.name,label:this.$t("ui.setup.database-connection.restoreOption",{date:(0,Ns.A)(e.createdAt),size:(0,ps.A)(e.size)})})))}},methods:{datimFormat(e){return(0,Ns.A)(e,"short","long")},checkMigrations(){this.$store.commit("checkMigrations")},parseUrl(){if(!this.validateUrl())return;this.validating=!0;const e=new RegExp(this.urlPattern,"i").exec(this.url);this.user=e[3]?decodeURIComponent(e[3]):"",this.password=e[5]?decodeURIComponent(e[5]):"",this.server=decodeURIComponent(e[6]),this.database=decodeURIComponent(e[8]),":3306"===this.server.substring(this.server.length-5)?this.server=this.server.substring(0,this.server.length-5):this.server.includes(":")||(this.server=`${this.server}:3306`),this.valid=this.validateUrl(),this.validating=!1},updateUrl(){if(this.validating)return;if(this.valid=!1,!this.server)return;const e=this.server.split(":",2),t=`${encodeURIComponent(e[0])}:${e[1]||"3306"}`;let s="mysql://";this.user&&(s+=encodeURIComponent(this.user),this.password&&(s+=":"+encodeURIComponent(this.password)),s+="@"),s+=t,this.database&&(s+="/"+encodeURIComponent(this.database)),this.url=s,this.valid=this.validateUrl()},validateUrl(){return this.validUrl=!0,this.valid=!1,""!==this.url&&(this.validUrl=new RegExp(this.urlPattern,"i").test(this.url),this.validUrl)},async load(){this.url=(await this.$store.dispatch("server/database/get")).data.url,this.currentState=this.status?.type,this.parseUrl(),"error"===this.currentState&&(this.validUrl=!1,this.valid=!1)},async save(){this.processing=!0;const e=await this.$store.dispatch("server/database/set",this.url);if("error"===e.data.status.type)return this.processing=!1,this.validUrl=!1,void(this.valid=!1);await this.$store.dispatch("server/adminUser/get",!1),this.processing=!1},async restore(){await this.$store.dispatch("tasks/execute",{name:"contao/backup-restore",config:{file:this.files.length>1?this.selection:this.files[0].name,backup:!1}}),"complete"===this.taskStatus&&(this.$store.commit("contao/backup/setRestored"),await this.$store.dispatch("tasks/deleteCurrent"))}},watch:{user(){this.updateUrl()},password(){this.updateUrl()},server(){this.updateUrl()},database(){this.updateUrl()},status(){this.currentState=this.status?.type}},mounted(){this.load(),this.selection=null,this.backup=!0}};const Zs=(0,Xe.A)(zs,[["render",Js]]);var Ys=Zs,Gs=s.p+"img/user.129e863d.svg";const ei={class:"setup__header"},ti={class:"setup__headline"},si={class:"setup__description"},ii={key:0,class:"setup__form"},ai={class:"setup__fields"},oi={class:"setup__warning"},ni={class:"setup__form setup__form--center",key:"confirmation"},ri={class:"setup__fields"},li={class:"setup__fielddesc"},ui={class:"setup__actions setup__actions--center"},ci={class:"setup__form",key:"setup"},di={class:"setup__fields"},pi={class:"setup__fieldtitle"},hi={class:"setup__fielddesc"},mi={class:"setup__actions setup__actions--center"};function _i(e,t,s,o,n,r){const l=(0,i.g2)("console-output"),u=(0,i.g2)("text-field"),c=(0,i.g2)("loading-button");return(0,i.uX)(),(0,i.CE)("section",null,[(0,i.Lk)("header",ei,[t[8]||(t[8]=(0,i.Lk)("img",{src:Gs,width:"80",height:"80",class:"setup__icon",alt:""},null,-1)),(0,i.Lk)("h1",ti,(0,a.v_)(e.$t("ui.setup.backend-user.headline")),1),(0,i.Lk)("p",si,(0,a.v_)(e.$t("ui.setup.backend-user.description")),1)]),null===e.hasUser?((0,i.uX)(),(0,i.CE)("main",ii,[(0,i.Lk)("div",ai,[(0,i.Lk)("p",oi,(0,a.v_)(e.$t("ui.setup.backend-user.error")),1),502===e.response.status?((0,i.uX)(),(0,i.Wv)(l,{key:0,class:"view-recovery__console",title:e.$t("ui.recovery.console"),operations:[{status:"error",summary:"vendor/bin/contao-console contao:user:list",console:e.response.data.detail}],"console-output":e.response.data.detail,"show-console":"","force-console":""},null,8,["title","operations","console-output"])):(0,i.Q3)("",!0)])])):((0,i.uX)(),(0,i.Wv)(X.eB,{key:1,name:"animate-flip",type:"transition",mode:"out-in"},{default:(0,i.k6)((()=>[e.hasUser?((0,i.uX)(),(0,i.CE)("main",ni,[(0,i.Lk)("div",ri,[t[9]||(t[9]=(0,i.Lk)("svg",{class:"setup__check",xmlns:"http://www.w3.org/2000/svg",width:"24",height:"24",viewBox:"0 0 24 24"},[(0,i.Lk)("path",{d:"M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2M12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4M11,16.5L6.5,12L7.91,10.59L11,13.67L16.59,8.09L18,9.5L11,16.5Z"})],-1)),(0,i.Lk)("p",li,(0,a.v_)(e.$t("ui.setup.backend-user.success")),1)]),(0,i.Lk)("div",ui,[(0,i.Lk)("button",{type:"button",class:"widget-button widget-button--inline widget-button--primary",onClick:t[0]||(t[0]=t=>e.$emit("continue"))},(0,a.v_)(e.$t("ui.setup.continue")),1)])])):((0,i.uX)(),(0,i.CE)("main",ci,[(0,i.Lk)("form",{onSubmit:t[7]||(t[7]=(0,X.D$)(((...e)=>r.save&&r.save(...e)),["prevent"]))},[(0,i.Lk)("div",di,[(0,i.Lk)("h2",pi,(0,a.v_)(e.$t("ui.setup.backend-user.formTitle")),1),(0,i.Lk)("p",hi,(0,a.v_)(e.$t("ui.setup.backend-user.formText")),1),(0,i.bF)(u,{ref:"username",name:"username",label:e.$t("ui.setup.backend-user.username"),disabled:e.processing,required:"",validate:"",modelValue:e.username,"onUpdate:modelValue":t[1]||(t[1]=t=>e.username=t)},null,8,["label","disabled","modelValue"]),(0,i.bF)(u,{ref:"name",name:"name",label:e.$t("ui.setup.backend-user.name"),disabled:e.processing,required:"",validate:"",modelValue:e.name,"onUpdate:modelValue":t[2]||(t[2]=t=>e.name=t)},null,8,["label","disabled","modelValue"]),(0,i.bF)(u,{ref:"email",name:"email",type:"email",label:e.$t("ui.setup.backend-user.email"),disabled:e.processing,required:"",validate:"",error:e.errors.email,onFocus:t[3]||(t[3]=t=>e.errors.email=""),onBlur:r.validateEmail,modelValue:e.email,"onUpdate:modelValue":t[4]||(t[4]=t=>e.email=t)},null,8,["label","disabled","error","onBlur","modelValue"]),(0,i.bF)(u,{ref:"password",name:"password",type:"password",label:e.$t("ui.setup.backend-user.password"),placeholder:e.$t("ui.setup.backend-user.passwordPlaceholder"),disabled:e.processing,required:"",minlength:"8",validate:"",error:e.errors.password,onFocus:t[5]||(t[5]=t=>e.errors.password=""),onBlur:r.validatePassword,modelValue:e.password,"onUpdate:modelValue":t[6]||(t[6]=t=>e.password=t)},null,8,["label","placeholder","disabled","error","onBlur","modelValue"])]),(0,i.Lk)("div",mi,[(0,i.bF)(c,{submit:"",color:"primary",loading:e.processing,disabled:!e.valid},{default:(0,i.k6)((()=>[(0,i.eW)((0,a.v_)(e.$t("ui.setup.backend-user.create")),1)])),_:1},8,["loading","disabled"])])],32)]))])),_:1}))])}var vi={components:{TextField:fe.A,LoadingButton:Ve.A,ConsoleOutput:ds.A},data:()=>({processing:!1,valid:!1,username:"",name:"",email:"",password:"",errors:{email:"",password:""}}),computed:{...(0,C.aH)("server/adminUser",{hasUser:"hasUser",response:"cache"})},methods:{validate(){this.valid=this.$refs.username.checkValidity()&&this.$refs.name.checkValidity()&&this.$refs.email.checkValidity()&&this.$refs.password.checkValidity()},validateEmail(){this.errors.email=null,""!==this.email&&(this.$refs.email.checkValidity()||(this.errors.email=this.$t("ui.setup.backend-user.emailInvalid")))},validatePassword(){this.errors.password=null,""!==this.password&&this.password.length<8&&(this.errors.password=this.$t("ui.setup.backend-user.passwordLength"))},async save(){this.processing=!0,await this.$store.dispatch("server/adminUser/set",{username:this.username,name:this.name,email:this.email,password:this.password}),this.processing=!1,this.$store.commit("setup",5)}},watch:{username(){this.validate()},name(){this.validate()},email(){this.validate()},password(){this.validate()}}};const ki=(0,Xe.A)(vi,[["render",_i]]);var bi=ki,gi={components:{BoxedLayout:E.A,DocumentRoot:De,CreateProject:_s,DatabaseConnection:Ys,BackendUser:bi},computed:{...(0,C.aH)(["setupStep"]),...(0,C.aH)("server/contao",["contaoVersion"]),...(0,C.aH)("server/database",{databaseSupported:"supported"}),...(0,C.aH)("server/adminUser",{userSupported:"supported"}),...(0,C.aH)("contao/install-tool",{showInstallTool:"isSupported"}),currentStep:{get(){return this.setupStep},set(e){this.$store.commit("setup",e)}},steps(){const e=[];return e.push({name:"document-root",icon:j,component:De}),e.push({name:"create-project",icon:Se,component:_s}),this.databaseSupported&&e.push({name:"database-connection",icon:vs,component:Ys}),this.userSupported&&e.push({name:"backend-user",icon:Gs,component:bi}),e}},methods:{launch(){this.$store.commit("setView",$.A.READY)}},mounted(){this.$store.dispatch("server/adminUser/get"),this.$store.dispatch("contao/backup/fetch")}};const fi=(0,Xe.A)(gi,[["render",L]]);var yi=fi},9472:function(e,t,s){e.exports=s.p+"img/database.7f0a8c49.svg"}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[958],{2958:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Kevreadur diasur !!","ui.app.httpsDescription":"Hep HTTPS ho roadennoù kuzhut a vo treuzkaset dirinegañ.","ui.app.httpsLink":"Muioc\'h a ditouroù","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.loading":"O kargañ Contao Manager ...","ui.app.apiError":"Statud API dic\'hortoz","ui.app.configSecurity1":"SECURITY ALERT !!! Unprotected config directory detected","ui.app.configSecurity2":"The Contao Manager has detected that its config files are publicly accessible. All operations are disabled until the directory is secured, otherwise an attacker could access sensitive data of your installation.\\n\\nTo fix this issue, make sure to prevent access to the \\"contao-manager\\" directory on your server. To learn how to do this, please refer to the manual of your webserver or contact your hosting provider.","ui.account.welcome":"Degemer mat","ui.account.intro1":"Welcome to the Contao Manager, a universal tool to install and manage Contao Open Source CMS. If you are new to it, please {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} to get started","ui.account.introManual":"read the manual","ui.account.intro2":"If you encounter any problems, check {ourGithubIssues} and feel free to create new one for anything that has not been reported yet.","ui.account.introIssues":"our GitHub issues","ui.account.headline":"Kont implijer","ui.account.description":"Da verañ ho staliadur, krouit ur gont mar plij evit Contao Manager. Deoc\'h da c\'houzout n\'eo ket liammet d\'ar c\'hontoù Contao back end pe front end.","ui.account.username":"Anv-implijer","ui.account.password":"Ger-tremen","ui.account.passwordConfirm":"Adskrivit ar ger-tremen","ui.account.passwordPlaceholder":"min. 8 arouezenn","ui.account.passwortLength":"Ebarzhit da vihanañ 8 arouezenn.","ui.account.passwortDifferent":"Ar ger-tremen na glot ket gant ar c\'hadarnadur.","ui.account.submit":"Krouiñ ur gont","ui.account.contribute1":"Contao and the Contao Manager are sponsored by the non-profit Contao Association.","ui.account.contribute2":"Please consider contributing to open source by {donate}.","ui.account.contributeDonate":"making a donation","ui.login.headline":"Kevreañ","ui.login.description":"Kevreit evit merañ ho staliadur.","ui.login.username":"Anv-implijer","ui.login.password":"Ger-tremen","ui.login.forgotPassword":"Ankouaet ho ker-tremen?","ui.login.button":"Kevreañ","ui.login.locked":"Access has been denied because the Contao Manager is locked. To unlock, delete the {lockFile} file in your Contao root directory.","ui.logout.headline":"Session Timeout","ui.logout.warning":"Your have been inactive for more than 25 minutes. For security reasons your session will be terminated shortly.","ui.logout.expired":"Your session was automatically terminated because you have been inactive for more than 30 minutes.","ui.logout.renew":"Keep Logged In","ui.logout.logout":"Digevreañ","ui.logout.login":"Back To Login","ui.oauth.error":"Invalid OAuth attempt. Check the request parameters.","ui.oauth.https":"The redirect URI MUST use a secure protocol (https:) to prevent the authentication token from being transmitted in clear-text.","ui.oauth.headline":"Remote Authentication","ui.oauth.description":"The following application or service is requesting remote access to your Contao Manager instance.","ui.oauth.domain":"Before allowing access, make sure you know this URL and trust its owner!","ui.oauth.allow":"Allow Access","ui.oauth.deny":"Deny Access","ui.boot.headline":"Gwiriadur ar reizhad","ui.boot.description":"Please wait, we are analyzing your server …","ui.boot.issue1":"Kudennoù diguzhet en ur staliañ","ui.boot.issue2":"Your installation has issues that have to be fixed before the Contao Manager can be used.","ui.boot.run":"Loc\'hañ Contao Manager","ui.recovery.headline":"System Recovery","ui.recovery.description":"The Contao Manager detected files that look like Contao, but the Command Line Interface does not work as expected.","ui.recovery.console":"Console Output","ui.recovery.repairOptions":"Please choose an option to repair your installation.","ui.recovery.repairHeadline":"Automatic Repair","ui.recovery.repairDescription":"Attempts to automatically repair the installation by rebuilding the application cache and re-installing the Composer packages.","ui.recovery.repairWarning":"Any modifications to the vendor files might be deleted in the process!","ui.recovery.repairFailed":"Automatic repair was not successful. Try the Safe Mode to manually repair the installation.","ui.recovery.repairButton":"Run System Repair","ui.recovery.safeModeHeadline":"Safe Mode","ui.recovery.safeModeDescription":"Launching the Contao Manager in Safe Mode allows to manage packages and run certain maintenance tasks, but features that rely on a working Contao installation will not be available.","ui.recovery.safeModeButton":"Launch in Safe Mode","ui.server.pending":"Waiting …","ui.server.running":"Oc\'h analizañ ...","ui.server.error":"Check failed due to an unexpected response from the server.","ui.server.details":"Munudoù","ui.server.prerequisite":"Check cancelled due to a missing prerequisite.","ui.server.selfUpdate.title":"Hizivadurioù Contao Manager","ui.server.selfUpdate.update":"Ur stumm nevez eus Contao Managaer a zo hegerz: {latest}.","ui.server.selfUpdate.manualUpdate":"A new Contao Manager version {latest} is available. Your server does not support automatic updates, please download the new version from {download}.","ui.server.selfUpdate.latest":"You are using the latest version {current}.","ui.server.selfUpdate.dev":"Development builds do not support automatic updates.","ui.server.selfUpdate.unsupported":"A new version is available but it does not support your PHP version.","ui.server.selfUpdate.button":"Seveniñ an em-hizivaat","ui.server.selfUpdate.continue":"Continue","ui.server.config.title":"Kefluniadur ar servijer","ui.server.config.setup":"Kefluniañ","ui.server.config.change":"Cheñch","ui.server.config.save":"Enrollañ","ui.server.config.blankOption":"Diuzit mar plij ...","ui.server.config.customOption":"Traoù all ...","ui.server.config.description":"To correctly run background tasks, the Contao Manager needs to know where to find the PHP command line binary and how to run commands separated from the web process.","ui.server.config.formTitle":"Kefluniadur ar servijer","ui.server.config.formText":"Please enter the path to your PHP binary. Make sure the binary is the same PHP version as your web process.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"The Composer Resolver Cloud allows to install Composer dependencies even if your server does not provide enough local memory. Please be aware that your package information will be transmitted to a cloud server operated by the Contao Association.","ui.server.config.cloud":"Use the Composer Resolver Cloud","ui.server.config.cli":"PHP daouel","ui.server.config.stateErrorCli":"No valid PHP binary was found on the server.","ui.server.config.stateErrorCloud":"The Composer Resolver Cloud is not supported.","ui.server.config.stateSuccess":"PHP binary at {php_cli}.","ui.server.php_web.title":"PHP Web Process","ui.server.php_web.below7":"Found PHP version {version}. Please switch to PHP 7 as soon as possible!","ui.server.php_web.success":"Found PHP version {version}, no known issues found.","ui.server.php_cli.title":"PHP Command Line Interface","ui.server.php_cli.success":"Found PHP version {version}, no known issues found.","ui.server.composer.title":"Endro kompozer","ui.server.composer.success":"N\'eus bet kavet kudenn ebet.","ui.server.composer.install":"Composer dependencies are not installed.","ui.server.composer.button":"Run Composer","ui.server.composer.safeMode":"Run Safe Mode","ui.server.contao.title":"Staliadur Contao","ui.server.contao.setup":"Setup","ui.server.contao.empty":"Staliadur Contao ebet bet kavet","ui.server.contao.old":"Contao version {version} is not compatible with the Contao Manager, please update your installation manually.","ui.server.contao.found":"Kavet Contao {version} (API stumm {api}).","ui.server.contao.headline":"Kefluniadur Contao","ui.server.contao.description":"Welcome to the setup process of your Contao Open Source CMS. You can choose between two versions to install.","ui.server.contao.publicDir":"Use {dir} for public files (for Contao {version})","ui.server.contao.ltsTitle":"Skor war hir amzer","ui.server.contao.ltsText":"The LTS version has an extended support period of up to four years.","ui.server.contao.latestTitle":"Diwezhatañ","ui.server.contao.latestText":"A new latest version is released every six months in February and August.","ui.server.contao.noLatest":"Requires at least PHP {version}.","ui.server.contao.releaseplan":"See the {contaoReleasePlan} for detailed information.","ui.server.contao.releaseplanLink":"Contao Release Plan","ui.server.contao.formTitle":"Staliadur Contao","ui.server.contao.formText":"Select the Contao version to install.","ui.server.contao.version":"Stumm","ui.server.contao.coreOnly":"Initial Setup","ui.server.contao.coreOnlyNo":"Full Installation (News, Calendar, etc.)","ui.server.contao.coreOnlyYes":"Minimal Installation (Core only)","ui.server.contao.coreOnlyFeatures":"What\'s the difference?","ui.server.contao.noUpdate":"Skip Installation (Expert Only!)","ui.server.contao.install":"Finish","ui.server.docroot.headline":"Webserver Setup","ui.server.docroot.warning":"To install Contao through the Contao Manager, you have to fix the document root on the web server.","ui.server.docroot.description1":"Contao uses a separate folder for public files, application files are installed in its parent folder. Contao cannot be installed right now, because your folder structure is not correct or the folders are not empty.","ui.server.docroot.description2":"If you don\'t know how to configure your document root, please read the Contao documentation or contact your hosting provider.","ui.server.docroot.documentation":"Read the Documentation","ui.server.docroot.conflictsTitle":"Installation directory not empty","ui.server.docroot.conflictsDirectory":"The root directory of your future Contao installation is not empty, we have found {count} file(s) that might be overwritten by the installation process. It is recommended to create an empty directory structure for Contao, but you can also remove the following files and reload the page if you are sure they are unused.","ui.server.docroot.ignoreConflicts":"I want to install Contao into the non-empty directory. I understand that this might overwrite any existing files on my webspace.","ui.server.docroot.create":"Create directories","ui.server.docroot.formTitle":"Directory Setup","ui.server.docroot.formText1":"The Contao Manager can automatically create a new directory structure on the server.","ui.server.docroot.formText2":"You will need to manually configure the new document root (e.g. through a hosting admin panel).","ui.server.docroot.autoconfig":"I understand that I have to change my server configuration. Not configuring the document root will break the Contao Manager and expose configuration files (including account details and passwords)!","ui.server.docroot.directory":"New Directory","ui.server.docroot.currentRoot":"Current Document Root","ui.server.docroot.newRoot":"New Document Root","ui.server.docroot.finish":"Setup Directories","ui.server.docroot.directoryInvalid":"Please enter a valid directory name.","ui.server.docroot.directoryExists":"The target directory already exists. Please enter a different name.","ui.server.docroot.confirmation":"The Contao Manager has successfully created the necessary directory for your Contao installation. You now have to configure the document root on your web server. Do not reload this page until then.","ui.server.docroot.reload":"Reload Page","ui.task.headline":"Background Task","ui.task.loading":"Loading details …","ui.task.created":"Loading details …","ui.task.active":"Please wait while the Contao Manager is running task operations in the background.","ui.task.complete":"All operations are completed successfully. Check the console output for details.","ui.task.aborting":"Please wait while the background operations are being cancelled.","ui.task.stopped":"Some background operations were cancelled. Please check the console output.","ui.task.error":"A background operation stopped unexpectedly. Please check the console output.","ui.task.failed":"The Contao Manager failed to start a background task!","ui.task.failedDescription1":"Something went wrong while trying to execute operations in the background.","ui.task.failedDescription2":"If this happens again, your server might not be supported.","ui.task.reportProblem":"Danevelliñ ur gudenn","ui.task.buttonAudit":"Update Database","ui.task.buttonClose":"Serriñ","ui.task.buttonConfirm":"Kadarnaat & ha serriñ","ui.task.buttonCancel":"Nullañ","ui.task.confirmCancel":"Are you sure to cancel this task? This might leave your Contao installation in a broken state!","ui.task.autoclose":"Close task details on success","ui.console.toggle":"Show/Hide Console Output","ui.console.showLog":"Show full console log","ui.console.copyLog":"Copy log to clipboard","ui.widget.mandatory":"Ar vaezienn-mañ n\'hall ket bezañ goullo.","ui.error.title":"HTTP request for \\"{method} {url}\\" failed.","ui.error.server500":"Looks like an unexpected error happened on your server. Please check the log files of your web server (Apache/Nginx) and the Contao Manager logs at \\"contao-manager/logs\\".","ui.error.response":"The server returned a response with status code {status}.","ui.error.moreLink":"Muioc\'h a ditouroù","ui.error.support":"Contao Support","ui.footer.help":"Skoazell","ui.footer.reportProblem":"Danevelliñ ur gudenn","ui.navigation.discover":"Discover","ui.navigation.packages":"Pakadoù","ui.navigation.tools":"Ostilhoù","ui.navigation.installTool":"Staliañ an ostilh","ui.navigation.backend":"Contao Backend","ui.navigation.debug":"Contao Debug Mode","ui.navigation.phpinfo":"PHP Information","ui.navigation.maintenance":"Trezalc\'h","ui.navigation.rebuildCache":"Adsevel ar c\'hrubuilh","ui.navigation.systemCheck":"Gwiriadur ar reizhad","ui.navigation.advanced":"Araokaet","ui.navigation.logout":"Digevreañ","ui.maintenance.rebuildCache.title":"Application Cache","ui.maintenance.rebuildCache.description":"Rebuilding the application cache is required after modifying any of the configuration files.","ui.maintenance.rebuildCache.rebuildProd":"Rebuild Production Cache","ui.maintenance.rebuildCache.rebuildDev":"Rebuild Development Cache","ui.maintenance.rebuildCache.clearProd":"Clear Production Cache","ui.maintenance.rebuildCache.clearDev":"Clear Development Cache","ui.maintenance.installTool.title":"Contao Install Tool","ui.maintenance.installTool.description":"The Contao Install Tool is automatically locked if you enter a wrong password three times in a row.","ui.maintenance.installTool.unlock":"Unlock Install Tool","ui.maintenance.installTool.lock":"Lock Install Tool","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"The Composer autoloader is responsible for PHP class loading. The autoloader must be dumped after adding custom namespaces to the root composer.json.","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Composer Dependencies","ui.maintenance.composerInstall.description":"Composer dependencies are located in the {vendor} folder in your application root. Reinstalling the dependencies can be necessary after manipulation or manually uploading the {composerLock} file.","ui.maintenance.composerInstall.button":"Run Installer","ui.maintenance.composerInstall.update":"Run Composer Update","ui.maintenance.composerCache.title":"Composer Cache","ui.maintenance.composerCache.description":"Composer caches downloaded packages for improved performance. If you have issues like broken files, try to delete the Composer cache to force a new download.","ui.maintenance.composerCache.button":"Clear Cache","ui.maintenance.maintenanceMode.title":"Maintenance Mode","ui.maintenance.maintenanceMode.description":"Putting Contao in maintenance mode will display a \\"503 Service Unavailable\\" template for the website.","ui.maintenance.maintenanceMode.enable":"Enable","ui.maintenance.maintenanceMode.disable":"Disable","ui.maintenance.debugMode.title":"Debug Mode","ui.maintenance.debugMode.description":"Activate the debug mode by setting a user and password for the {appDevPhp} entry point.","ui.maintenance.debugMode.descriptionJwt":"Activate the debug mode by setting the debug cookie for the current domain.","ui.maintenance.debugMode.activate":"Activate","ui.maintenance.debugMode.deactivate":"Deactivate","ui.maintenance.debugMode.credentials":"Credentials","ui.maintenance.debugMode.user":"Please enter a username for the debug mode.","ui.maintenance.debugMode.password":"Please enter a password for the debug mode.","ui.maintenance.opcodeCache.title":"Opcode Cache","ui.maintenance.opcodeCache.description":"Opcode caches PHP files on the web process for faster execution. It must be deleted under certain circumstances if files are not recognized after changing.","ui.maintenance.opcodeCache.button":"Truncate Cache","ui.maintenance.safeMode":"Not available in Safe Mode","ui.maintenance.unsupported":"Not supported by your Contao version","ui.packages.updateButton":"Hizivaat ar pakadoù","ui.packages.searchButton":"Search Packages","ui.packages.searchPlaceholder":"Klask war-lerc\'h pakadoù ...","ui.packages.uploadOverlay":"Drag & drop files to upload","ui.packages.uploadButton":"Upload Packages","ui.packages.uploadMessage":"You have one unconfirmed upload. | You have {count} unconfirmed uploads.","ui.packages.uploadApply":"Confirm Uploads","ui.packages.uploadReset":"Delete Uploads","ui.packages.uploadIncomplete":"This file was not uploaded completely. Please remove it and try again.","ui.packages.uploadDuplicate":"This file seems to be uploaded multiple times. Please remove the duplicates.","ui.packages.uploadInstalled":"This file is already installed. Please remove the duplicates.","ui.packages.uploadUnsupported":"Uploads are not supported in your installation. Please make sure to update your dependencies.","ui.packages.changesMessage":"You have one unconfirmed change. | You have {count} unconfirmed changes.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"Arloañ ar c\'hemmoù","ui.packages.changesApplyAll":"Update all packages","ui.packages.changesDryrunAll":"Dry run all packages","ui.packages.changesReset":"Adderaouekaat ar cheñchamantoù","ui.packages.changesReview":"Review Changes","ui.packagelist.loading":"O kargañ ...","ui.packagelist.uploads":"Uploads","ui.packagelist.added":"New packages","ui.packagelist.installed":"Installed packages","ui.package.hintRevert":"Adlakaat ar cheñchamantoù","ui.package.hintNoupdate":"Do not update","ui.package.hintConstraint":"This package will be installed with constraint {constraint} when you apply the changes.","ui.package.hintConstraintBest":"This package will be installed in the best available version when you apply the changes.","ui.package.hintConstraintChange":"The constraint for this package will be changed from \\"{from}\\" to \\"{to}\\" when you apply the changes.","ui.package.hintConstraintUpdate":"This package will be updated when you apply the changes.","ui.package.hintAdded":"This package will be installed when you apply the changes.","ui.package.hintRemoved":"This package will be removed when you apply the changes.","ui.package.requiredTitle":"manually added","ui.package.requiredText":"This package is required in your composer.json but not installed.","ui.package.removedTitle":"manually removed","ui.package.removedText":"This package was removed from your composer.json.","ui.package.installed":"Currently installed:","ui.package.version":"Stumm {version}","ui.package.additionalDownloads":"{count} Download | {count} Downloads","ui.package.additionalStars":"{count} Star | {count} Stars","ui.package.editConstraint":"Kemm","ui.package.uploadConstraint":"This constraint is defined by the uploaded package.","ui.package.updateButton":"Update","ui.package.removeButton":"Dilemel","ui.package.installButton":"Add Package","ui.package.installButtonShort":"Add","ui.package.detailsButton":"Munudoù","ui.package.latestConstraint":"stumm diwezhañ","ui.package.update":"Update available","ui.package.updateLatest":"stumm diwezhañ","ui.package.updateAvailable":"{version} available","ui.package.updateUnknown":"unknown version","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Stumm {version}","ui.cloudStatus.waitingTime":"Waiting Time","ui.cloudStatus.jobs":"Current Jobs","ui.cloudStatus.workers":"Workers","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"none","ui.cloudStatus.short":"ca. {minutes} min","ui.cloudStatus.long":"ca. {minutes} min {seconds} sec","ui.cloudStatus.error":"Unable to fetch the status of the Composer Resolver Cloud. It might be down for maintenance or experience issues.","ui.cloudStatus.button":"Cloud Status","ui.cloudStatus.refresh":"Refresh Cloud Status"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[120],{8120:function(e){e.exports=JSON.parse('{"ui.app.title":"Extensions Contao","ui.app.loading":"Chargement de la liste des extensions…","ui.app.language":"Switch language for the Contao Manager","ui.app.colorDark":"Dark Mode","ui.app.colorDarkTitle":"Switch color scheme to dark","ui.app.colorLight":"Light Mode","ui.app.colorLightTitle":"Switch color scheme to light","ui.discover.advertisement":"Publicité dans la liste des extensions","ui.discover.loading":"Chargement…","ui.discover.offline":"Impossible de récupérer des résultats.","ui.discover.offlineExplain":"Vérifiez votre connexion Internet et désactivez les bloqueurs JavaScript dans votre navigateur.","ui.discover.offlineButton":"Réessayer","ui.discover.searchPlaceholder":"Search in {count} extensions …","ui.discover.empty":"Pas de résultats pour {query}","ui.discover.more":"Plus de résulats","ui.discover.sortBy":"Trier par","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"Mis à jour","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"Téléchargements","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"Note","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"Détails","ui.discover.latestPackages":"Extensions les plus récentes et mises à jour","ui.discover.faversPackages":"Extensions les mieux notées","ui.discover.downloadsPackages":"Extensions les plus téléchargées","ui.discover.exactHit":"Exact query match","ui.discover.results":"More search results","ui.package.homepage":"Site web du projet","ui.package.private":"Package privé","ui.package.privateTitle":"Les packages privés ne sont disponibles que chez le fournisseur (par exemple sous forme de téléchargement ZIP). Veuillez visiter le site Web pour plus d\'informations","ui.package.abandoned":"abandonné","ui.package.abandonedText":"Ce package est abandonné et n\'est plus maintenu.","ui.package.abandonedReplace":"Ce package est abandonné et n\'est plus maintenu. L\'auteur suggère d\'utiliser le package {replacement} à la place.","ui.package.contaoVersion":"Available for Contao","ui.package-details.previous":"Extension précédente","ui.package-details.close":"Fermer les détails","ui.package-details.loading":"Chargement…","ui.package-details.tabDescription":"Description","ui.package-details.tabRequire":"Prérequis","ui.package-details.tabFeatures":"Fonctionnalités","ui.package-details.tabSuggest":"Suggestions","ui.package-details.tabConflict":"Conflits","ui.package-details.tabDependents":"Dépendants","ui.package-details.linkRequires":"nécessite","ui.package-details.linkReplaces":"remplaces","ui.package-details.linkProvides":"fournis","ui.package-details.linkConflicts":"conflits","ui.package-details.funding":"Fund package maintenance!","ui.package-details.contaoVersions":"Supported Contao version(s)","ui.package-details.latest":"Dernière version","ui.package-details.released":"Publié le","ui.package-details.license":"License(s)","ui.package-details.authors":"de","ui.package-details.more":"Plus","ui.package-details.packagist":"Détails du Package","ui.package-details.metadata":"Editer les Metadata","ui.package-details.support_docs":"Documentation","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Support","ui.package-details.support_issues":"Issues / Bug Report","ui.package-details.support_source":"Code source","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Support E-Mail","ui.package-details.support_rss":"RSS Feed"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[28],{4028:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! 不安全连接 !!","ui.app.httpsDescription":"没有HTTPS情况下，机密数据将会未加密传输。","ui.app.httpsLink":"更多信息","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Safe Mode enabled !!","ui.app.safeModeDescription":"Some features of the Contao Manager are not available.","ui.app.safeModeExit":"Exit Safe Mode","ui.app.loading":"加载 Contao 管理器 …","ui.app.apiError":"意外的API状态","ui.app.configSecurity1":"安全警报 !!! 检测到未受保护的配置目录","ui.app.configSecurity2":"Contao管理器检测到其配置文件可以公开访问。目录受到保护之前会禁止所有操作，否则攻击者可以访问安装的敏感数据。\\n\\n为了修复这个问题，请确保阻止访问服务器上的\\"contao-manager\\"目录。要了解如何执行此操作，请参阅您的网络服务器手册或联系您的托管服务提供商。","ui.account.welcome":"欢迎","ui.account.intro1":"Welcome to the Contao Manager, a universal tool to install and manage Contao Open Source CMS. If you are new to it, please {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} to get started","ui.account.introManual":"read the manual","ui.account.intro2":"If you encounter any problems, check {ourGithubIssues} and feel free to create new one for anything that has not been reported yet.","ui.account.introIssues":"our GitHub issues","ui.account.headline":"用户账户","ui.account.description":"为了管理安装，请为Contao管理器创建一个账号。请注意该账号和Contao后台和前端没有关联。","ui.account.username":"用户名","ui.account.password":"密码","ui.account.passwordPlaceholder":"最少8个字符","ui.account.passwordLength":"请输入最少8个字符","ui.account.submit":"创建账号","ui.account.contribute1":"Contao and the Contao Manager are sponsored by the non-profit Contao Association.","ui.account.contribute2":"Please consider contributing to open source by {donate}.","ui.account.contributeDonate":"making a donation","ui.login.headline":"登录","ui.login.description":"登录来管理安装。","ui.login.username":"用户名","ui.login.password":"密码","ui.login.forgotPassword":"忘记密码","ui.login.button":"登录","ui.login.locked":"Access has been denied because the Contao Manager is locked. To unlock, delete the {lockFile} file in your Contao root directory.","ui.logout.headline":"会话超时","ui.logout.warning":"超过25分钟没有活动。安全原因您的会话将很快被终止。","ui.logout.expired":"由于超过30分钟没有活动，您的会话已自动终止。","ui.logout.renew":"保持登入","ui.logout.logout":"注销","ui.logout.login":"返回登录","ui.oauth.error":"无效的OAuth尝试。检查请求参数。","ui.oauth.https":"The redirect URI MUST use a secure protocol (https:) to prevent the authentication token from being transmitted in clear-text.","ui.oauth.headline":"Remote Authentication","ui.oauth.description":"以下应用程序或者服务正在请求对您的Contao Manager实例远程访问。","ui.oauth.domain":"Before allowing access, make sure you know this URL and trust its owner!","ui.oauth.allow":"允许访问","ui.oauth.deny":"拒绝访问","ui.boot.headline":"系统检查","ui.boot.description":"请稍等，正在分析您的服务器 …","ui.boot.issue1":"监测到安装问题","ui.boot.issue2":"Your installation has issues that have to be fixed before the Contao Manager can be used.","ui.boot.run":"运行Contao管理器","ui.boot.safeMode":"安全模式下运行","ui.recovery.headline":"系统恢复","ui.recovery.description":"The Contao Manager detected files that look like Contao, but the Command Line Interface does not work as expected.","ui.recovery.console":"Console Output","ui.recovery.repairOptions":"Please choose an option to repair your installation.","ui.recovery.repairHeadline":"自动修复","ui.recovery.repairDescription":"尝试通过重建应用缓存并重新安装Composer包来自动修复安装。","ui.recovery.repairWarning":"此过程可能会删除vendor中文件的任何修改!","ui.recovery.repairFailed":"自动修复没有成功。请尝试安全模式手动修复安装。","ui.recovery.repairButton":"运行系统修复","ui.recovery.safeModeHeadline":"安全模式","ui.recovery.safeModeDescription":"安全模式下运行Contao管理器允许管理包并运行某些维护任务，但依赖于正在运行的Contao安装的功能将不可用。","ui.recovery.safeModeButton":"安全模式下运行","ui.server.pending":"等待 …","ui.server.running":"分析中 …","ui.server.error":"由于服务器的意外响应，检查失败。","ui.server.details":"详情","ui.server.prerequisite":"由于缺少必要的条件，检查已取消。","ui.server.selfUpdate.title":"Contao管理器更新","ui.server.selfUpdate.update":"新的Contao管理器版本 {latest} .","ui.server.selfUpdate.manualUpdate":"新版本的Contao管理器 {latest} 可用。服务器不支持自动更新，请从{download}下载新版本。","ui.server.selfUpdate.latest":"正在使用最新版本 {current}。","ui.server.selfUpdate.dev":"开发版不支持自动更新。","ui.server.selfUpdate.unsupported":"有新版本，但您的PHP版本不支持。","ui.server.selfUpdate.button":"运行自更新","ui.server.selfUpdate.continue":"继续","ui.server.config.title":"服务器配置","ui.server.config.setup":"配置","ui.server.config.change":"更改","ui.server.config.save":"保存","ui.server.config.cancel":"取消","ui.server.config.customOption":"其他 …","ui.server.config.description":"To correctly run background tasks, the Contao Manager needs to know where to find the PHP command line binary and how to run commands separated from the web process.","ui.server.config.formTitle":"服务器配置","ui.server.config.formText":"请输入PHP二进制文件位置。确认二进制文件和服务器web进程是相同的PHP版本。","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud 允许安装Composer依赖即使服务器无法提供足够的内存。您的包信息将被传输到由Contao Association运营的云服务器。","ui.server.config.cloud":"使用Composer Resolver Cloud","ui.server.config.cli":"PHP二进制","ui.server.config.stateErrorCli":"服务器中没有发现有效的PHP二进制文件。","ui.server.config.stateErrorCloud":"不支持Composer Resolver Cloud。","ui.server.config.stateSuccess":"PHP 二进制文件在 {php_cli}.","ui.server.php_web.title":"PHP Web 进程","ui.server.php_web.below7":"发现 PHP 版本 {version}。请尽快切换到PHP 7!","ui.server.php_web.success":"发现PHP版本 {version}, 没有发现已知问题。","ui.server.php_cli.title":"PHP命令行接口","ui.server.php_cli.success":"发现PHP版本 {version}, 没有发现已知问题。","ui.server.composer.title":"Composer环境","ui.server.composer.success":"没有发现已知问题","ui.server.composer.install":"没有安装Composer依赖。","ui.server.composer.button":"Install","ui.server.contao.title":"Contao 安装","ui.server.contao.setup":"安装","ui.server.contao.check":"Check database","ui.server.contao.empty":"没有发现安装Contao。","ui.server.contao.old":"Contao版本 {version}不兼容Contao Manager，请手动更新当前安装的系统。","ui.server.contao.found":"发现Contao {version} (API 版本 {api}).","ui.server.contao.connectionError":"Unable to connect to the database server.","ui.server.contao.connectionProblem":"Database problem found.","ui.server.contao.missingUser":"Admin account not found.","ui.setup.continue":"继续","ui.setup.manager":"运行Contao管理器","ui.setup.cancel":"取消","ui.setup.welcome":"欢迎","ui.setup.welcome1":"This wizard will take you through the necessary steps to set up your Contao Open Source CMS installation.","ui.setup.welcome2":"If you have any questions, please find documentation, forums, a Slack channel and more on the {support} page.","ui.setup.support":"community support","ui.setup.start":"Get started","ui.setup.complete":"Congratulations!","ui.setup.complete1":"Contao {version} has been installed successfully.","ui.setup.complete2":"To finish the setup process, please open the install tool to configure the database connection and create a back end user.","ui.setup.complete3":"You can now start to create your website in the Contao back end. If you need additional extensions, continue to the Contao Manager.","ui.setup.installTool":"Open the Install Tool","ui.setup.login":"Login to Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Learn more","ui.setup.document-root.headline":"Webserver Setup","ui.setup.document-root.warning":"To install Contao through the Contao Manager, you have to fix the document root on the web server.","ui.setup.document-root.description1":"Contao uses a separate folder for public files, application files are installed in its parent folder. Contao cannot be installed if the folder structure is not correct or the folders are not empty.","ui.setup.document-root.description2":"If you don\'t know how to configure your document root, please read the Contao documentation or contact your hosting provider.","ui.setup.document-root.documentation":"Read the Documentation","ui.setup.document-root.conflictsTitle":"Installation directory not empty","ui.setup.document-root.conflictsDirectory":"The root directory of your future Contao installation is not empty, we have found {count} file(s) that might be overwritten by the installation process. It is recommended to create an empty directory structure for Contao, but you can also remove the following files and check again if you are sure they are unused.","ui.setup.document-root.ignoreConflicts":"I want to install Contao into the non-empty directory. I understand that this might overwrite any existing files on my webspace.","ui.setup.document-root.check":"Check again","ui.setup.document-root.create":"Create directories","ui.setup.document-root.change":"Change directories","ui.setup.document-root.formTitle":"Directory Setup","ui.setup.document-root.formText1":"The Contao Manager can automatically create a new directory structure on the server.","ui.setup.document-root.formText2":"You will need to manually configure the new document root (e.g. through a hosting admin panel).","ui.setup.document-root.autoconfig":"I understand that I have to change my server configuration. Not configuring the document root will break the Contao Manager and expose configuration files (including account details and passwords)!","ui.setup.document-root.directory":"New Directory","ui.setup.document-root.currentRoot":"Current Document Root","ui.setup.document-root.newRoot":"New Document Root","ui.setup.document-root.finish":"Setup Directories","ui.setup.document-root.publicDir":"Use {dir} for public files (for Contao {version})","ui.setup.document-root.directoryInvalid":"Please enter a valid directory name.","ui.setup.document-root.directoryExists":"The target directory already exists. Please enter a different name.","ui.setup.document-root.confirmation":"The Contao Manager has successfully created the necessary directory for your Contao installation. You now have to configure the document root on your web server. Do not reload this page until then.","ui.setup.document-root.reload":"Reload Page","ui.setup.document-root.success":"The directory structure on your web server is set up correctly!","ui.setup.document-root.installingProjectDir":"Application files will be installed to {dir}.","ui.setup.document-root.installingPublicDir":"Public files will be installed to {dir}.","ui.setup.document-root.installedProjectDir":"Application files are installed in {dir}.","ui.setup.document-root.installedPublicDir":"Public files are installed in {dir}.","ui.setup.create-project.headline":"Contao 安装","ui.setup.create-project.description":"Contao development follows the principle of {semver}, a new minor version is released every six months. The currently supported releases are:","ui.setup.create-project.semver":"Semantic Versioning","ui.setup.create-project.latestTitle":"最新","ui.setup.create-project.ltsTitle":"长期支持","ui.setup.create-project.latestQ1":"Our latest version, offers the most features with support until February {year}.","ui.setup.create-project.latestQ3":"Our latest version, offers the most features with support until August {year}.","ui.setup.create-project.ltsText":"Our current LTS version, if you focus on stability. Offers long term support until February {year}.","ui.setup.create-project.pltsText":"The previous LTS version, still has long term support until February {year}.","ui.setup.create-project.requiresPHP":"Requires at least PHP {version}, you have PHP {current}.","ui.setup.create-project.requiresDocroot":"The document root must be \\"{folder}\\".","ui.setup.create-project.releaseplan":"See the {contaoReleasePlan} for detailed information.","ui.setup.create-project.releaseplanLink":"Contao Release Plan","ui.setup.create-project.formTitle":"Select a distribution","ui.setup.create-project.formText":"Please choose which version should be installed.","ui.setup.create-project.version":"版本","ui.setup.create-project.coreOnly":"初始化安装","ui.setup.create-project.coreOnlyNo":"全部安装 (新闻, 日历, 等.)","ui.setup.create-project.coreOnlyYes":"最小化安装 (仅核心)","ui.setup.create-project.coreOnlyFeatures":"What\'s the difference?","ui.setup.create-project.noUpdate":"跳过安装 (仅限专家!)","ui.setup.create-project.install":"Install","ui.setup.database-connection.headline":"Database Connection","ui.setup.database-connection.description":"Contao requires a MySQL database (or a compatible fork like MariaDB) to store pages, content, users and other relational data. Connection parameters are stored in the {env} file in the project root of your Contao installation.","ui.setup.database-connection.formTitle":"Connection Parameters","ui.setup.database-connection.formText":"Enter a database URL or fill in the username, password, server and database fields separately.","ui.setup.database-connection.url":"Database URL","ui.setup.database-connection.validUrl":"Database URL is invalid or connection to server failed.","ui.setup.database-connection.or":"or","ui.setup.database-connection.user":"用户名","ui.setup.database-connection.password":"密码","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Database Name","ui.setup.database-connection.serverVersion":"Server Version","ui.setup.database-connection.oldVersion":"Older MySQL or MariaDB","ui.setup.database-connection.connected":"Successfully connected to database {database} on {server} {version}.","ui.setup.database-connection.error":"Error connecting to the database.","ui.setup.database-connection.problem":"Contao has detected a problem with your database server.","ui.setup.database-connection.migration":"There is one pending migration. | There are {count} pending migrations.","ui.setup.database-connection.schema":"There is one pending schema update. | There are {count} pending schema updates.","ui.setup.database-connection.noChanges":"Your database schema is up to date.","ui.setup.database-connection.check":"Check database","ui.setup.database-connection.save":"保存","ui.setup.database-connection.change":"Change credentials","ui.setup.backend-user.success":"An admin account for the Contao back end was found in your database. Use the Contao back end to add more users.","ui.setup.backend-user.error":"Unable to retrieve user list. Check the console output for details.","ui.setup.backend-user.headline":"Backend Account","ui.setup.backend-user.description":"To manage your website, you need to have at least one admin account for the Contao back end. Be aware that this account is not related to the Contao Manager.","ui.setup.backend-user.formTitle":"创建账号","ui.setup.backend-user.formText":"Please enter the details for the new back end account.","ui.setup.backend-user.username":"用户名","ui.setup.backend-user.name":"Name","ui.setup.backend-user.email":"E-mail address","ui.setup.backend-user.emailInvalid":"Please enter a valid e-mail address","ui.setup.backend-user.password":"密码","ui.setup.backend-user.passwordPlaceholder":"最少8个字符","ui.setup.backend-user.passwordLength":"请输入最少8个字符","ui.setup.backend-user.create":"Add account","ui.task.headline":"Background Task","ui.task.loading":"Loading details …","ui.task.created":"Loading details …","ui.task.active":"Please wait while the Contao Manager is running task operations in the background.","ui.task.complete":"All operations are completed successfully. Check the console output for details.","ui.task.aborting":"Please wait while the background operations are being cancelled.","ui.task.stopped":"Some background operations were cancelled. Please check the console output.","ui.task.error":"A background operation stopped unexpectedly. Please check the console output.","ui.task.failed":"The Contao Manager failed to start a background task!","ui.task.failedDescription1":"Something went wrong while trying to execute operations in the background.","ui.task.failedDescription2":"If this happens again, your server might not be supported.","ui.task.reportProblem":"报告问题","ui.task.sponsor":"Composer Cloud sponsored by {sponsor}","ui.task.buttonAudit":"更新数据库","ui.task.buttonClose":"关闭","ui.task.buttonConfirm":"确认 & 关闭","ui.task.buttonCancel":"取消","ui.task.confirmCancel":"确认取消此任务? 将会使Contao安装处于损坏状态!","ui.task.autoclose":"Close task details on success","ui.console.toggle":"显示/隐藏命令行输出","ui.console.showLog":"Show full console log","ui.console.copyLog":"Copy log to clipboard","ui.migrate.headline":"Database Updates","ui.migrate.migrationsOnly":"(migrations only)","ui.migrate.schemaOnly":"(schema only)","ui.migrate.loading":"Please wait, we are checking your database …","ui.migrate.empty":"No pending migrations or schema updates found. Your database is up to date.","ui.migrate.emptyMigrations":"No pending migrations found. Make sure to also check for schema updates.","ui.migrate.emptySchema":"No pending schema updates found. Make sure to also check for migrations.","ui.migrate.pending":"Your database is not up to date. Please review the console output below and execute the changes.","ui.migrate.previousChanges":"A previous database migration was not confirmed.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.previousComplete":"A previous database migration was not confirmed, please review the console output below.\\nThere are no more pending changes.","ui.migrate.appliedChanges":"Database updates have been applied.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.appliedComplete":"Database updates have been applied.\\nThere are no more pending migrations or schema updates. Your database is up to date.","ui.migrate.problem":"Contao has detected a problem with your database server.\\nPlease review the console output below to find out what needs to be fixed. | Contao has detected problems with your database server.\\nPlease review the console output below to find out what needs to be fixed.","ui.migrate.warning":"Contao has detected a misconfiguration of your database server.\\nWarnings can be skipped temporarily, but should be fixed for optimal performance and data integrity.","ui.migrate.error":"The changes could not be applied. Your database might have been changed, please check again to retry.","ui.migrate.execute":"Execute","ui.migrate.close":"关闭","ui.migrate.confirm":"确认 & 关闭","ui.migrate.cancel":"取消","ui.migrate.continue":"继续","ui.migrate.setup":"安装","ui.migrate.skip":"Skip","ui.migrate.retry":"Check again","ui.migrate.retryAll":"Check all","ui.migrate.withDeletes":"Execute all database changes including DROP queries.","ui.migrate.migrationTitle":"Database Migrations","ui.migrate.schemaTitle":"Schema Updates","ui.migrate.problemTitle":"Database Problems","ui.migrate.warningTitle":"Database Warnings","ui.migrate.addTable":"Add table {table}","ui.migrate.dropTable":"Drop table {table}","ui.migrate.addField":"Add field {table}.{field}","ui.migrate.changeField":"Change field {table}.{field}","ui.migrate.dropField":"Drop field {table}.{field}","ui.migrate.createIndex":"Create index \\"{name}\\" on {table}","ui.migrate.dropIndex":"Drop index \\"{name}\\" on {table}","ui.widget.mandatory":"该字段不能为空。","ui.widget.blankOption":"请选择 …","ui.widget.showPassword":"Show password","ui.widget.hidePassword":"Hide password","ui.error.title":"HTTP request for \\"{method} {url}\\" failed.","ui.error.server500":"Looks like an unexpected error happened on your server. Please check the log files of your web server (Apache/Nginx) and the Contao Manager logs at \\"contao-manager/logs\\".","ui.error.response":"The server returned a response with status code {status}.","ui.error.moreLink":"更多信息","ui.error.support":"Contao Support","ui.footer.help":"帮助","ui.footer.reportProblem":"报告问题","ui.navigation.discover":"发现","ui.navigation.packages":"包","ui.navigation.tools":"工具","ui.navigation.installTool":"安装工具","ui.navigation.backend":"Contao 后台","ui.navigation.debug":"Contao调试模式","ui.navigation.logViewer":"Log Viewer","ui.navigation.phpinfo":"PHP信息","ui.navigation.phpinfoLoading":"Loading PHP Information…","ui.navigation.maintenance":"维护","ui.navigation.rebuildCache":"重建缓存","ui.navigation.systemCheck":"系统检查","ui.navigation.advanced":"高级","ui.navigation.logout":"注销","ui.maintenance.databaseMigration.title":"Database Migrations","ui.maintenance.databaseMigration.description":"Database migrations ensure consistent data and table schemas.","ui.maintenance.databaseMigration.migrations":"One pending database migration | {count} pending database migrations","ui.maintenance.databaseMigration.schemaUpdates":"One pending schema update | {count} pending schema updates","ui.maintenance.databaseMigration.error":"Database problem found.","ui.maintenance.databaseMigration.warning":"Database warnings found.","ui.maintenance.databaseMigration.button":"Check database","ui.maintenance.databaseMigration.migrationOnly":"Check migrations only","ui.maintenance.databaseMigration.schemaOnly":"Check schema only","ui.maintenance.databaseMigration.installTool":"Open Install Tool","ui.maintenance.rebuildCache.title":"应用缓存","ui.maintenance.rebuildCache.description":"修改任何配置文件后，必须重建应用程序缓存。","ui.maintenance.rebuildCache.rebuildProd":"重建生产环境缓存","ui.maintenance.rebuildCache.rebuildDev":"重建开发环境缓存","ui.maintenance.rebuildCache.clearProd":"清除生产环境缓存","ui.maintenance.rebuildCache.clearDev":"清除开发环境缓存","ui.maintenance.installTool.title":"Contao安装工具","ui.maintenance.installTool.description":"连续输入3次错误密码会自动锁定Contao安装工具。","ui.maintenance.installTool.unlock":"解锁安装工具","ui.maintenance.installTool.lock":"锁定安装工具","ui.maintenance.dumpAutoload.title":"Composer类加载器","ui.maintenance.dumpAutoload.description":"Composer的自动加载器负责PHP类加载。添加自定义命名空间到根下的composer.json后必须转储自动加载器。","ui.maintenance.dumpAutoload.button":"打印Autoloader","ui.maintenance.composerInstall.title":"Composer依赖","ui.maintenance.composerInstall.description":"Composer dependencies are located in the {vendor} folder in your application root. Reinstalling the dependencies can be necessary after manipulation or manually uploading the {composerLock} file.","ui.maintenance.composerInstall.button":"运行安装器","ui.maintenance.composerInstall.update":"运行Composer更新","ui.maintenance.composerCache.title":"Composer缓存","ui.maintenance.composerCache.description":"Composer缓存下载的软件包以提高性能。 如果您遇到文件损坏等问题，请尝试删除Composer缓存以强制进行新的下载。","ui.maintenance.composerCache.button":"清楚缓存","ui.maintenance.maintenanceMode.title":"Maintenance Mode","ui.maintenance.maintenanceMode.description":"Putting Contao in maintenance mode will display a \\"503 Service Unavailable\\" template for the website.","ui.maintenance.maintenanceMode.enable":"Enable","ui.maintenance.maintenanceMode.disable":"Disable","ui.maintenance.debugMode.title":"调试模式","ui.maintenance.debugMode.description":"Activate the debug mode by setting a user and password for the {appDevPhp} entry point.","ui.maintenance.debugMode.descriptionJwt":"通过对于当前域名设置调试cookie来激活调试模式。","ui.maintenance.debugMode.activate":"激活","ui.maintenance.debugMode.deactivate":"未激活","ui.maintenance.debugMode.credentials":"证书","ui.maintenance.debugMode.user":"请输入用于调试模式的用户名。","ui.maintenance.debugMode.password":"请输入用于调试模式的密码。","ui.maintenance.opcodeCache.title":"Opcode缓存","ui.maintenance.opcodeCache.description":"Opcode在Web进程上缓存PHP文件以加快执行速度。 如果文件在更改后无法识别，则在某些情况下必须将其删除。","ui.maintenance.opcodeCache.button":"清除缓存","ui.maintenance.safeMode":"安装模式下无效","ui.maintenance.unsupported":"您的Contao版本不支持","ui.packages.updateButton":"更新包","ui.packages.searchButton":"搜索包","ui.packages.searchPlaceholder":"搜索包","ui.packages.uploadOverlay":"拖拽文件上传","ui.packages.uploadButton":"上传包","ui.packages.uploadMessage":"You have one unconfirmed upload. | You have {count} unconfirmed uploads.","ui.packages.uploadApply":"确认上传","ui.packages.uploadReset":"删除上传","ui.packages.uploadIncomplete":"此文件未完全上传。 请将其删除，然后重试。","ui.packages.uploadDuplicate":"此文件似乎多次上传。 请删除重复项。","ui.packages.uploadInstalled":"此文件已安装。请移除重复项。","ui.packages.uploadUnsupported":"Uploads are not supported in your installation. Please make sure that the PHP ZIP extension is installed and update your dependencies.","ui.packages.changesMessage":"You have one unconfirmed change. | You have {count} unconfirmed changes.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"应用更改","ui.packages.changesApplyAll":"Update all packages","ui.packages.changesDryrunAll":"Dry run all packages","ui.packages.changesReset":"重置更改","ui.packages.changesReview":"预览更改","ui.packagelist.loading":"加载 …","ui.packagelist.uploads":"上传","ui.packagelist.added":"新包","ui.packagelist.installed":"已安装的包","ui.package.hintRevert":"恢复更改","ui.package.hintNoupdate":"不要更新","ui.package.hintConstraint":"应用更改时，此包将会带约束 {constraint} 安装。","ui.package.hintConstraintBest":"应用更改时，此包将会安装最佳版本。","ui.package.hintConstraintChange":"应用更改时，此包的约束将从\\"{from}\\"更改为\\"{to}\\"。","ui.package.hintConstraintUpdate":"应用更改后此包会被更新","ui.package.hintAdded":"应用更改后此包会被安装","ui.package.hintRemoved":"应用更改时，该程序包将被移除。","ui.package.requiredTitle":"手动添加","ui.package.requiredText":"composer.json中需要此包，但是没有安装","ui.package.removedTitle":"手动移除","ui.package.removedText":"此包已从composer.json移除。","ui.package.installed":"当前已安装:","ui.package.version":"版本 {version}","ui.package.additionalDownloads":"{count} Download | {count} Downloads","ui.package.additionalStars":"{count} Star | {count} Stars","ui.package.editConstraint":"编辑","ui.package.uploadConstraint":"此约束由上传的包定义。","ui.package.updateButton":"更新","ui.package.removeButton":"移除","ui.package.installButton":"添加包","ui.package.installButtonShort":"添加","ui.package.detailsButton":"详情","ui.package.latestConstraint":"最新版","ui.package.update":"Update available","ui.package.updateLatest":"最新版","ui.package.updateAvailable":"{version} available","ui.package.updateUnknown":"unknown version","ui.package.updateConstraint":"A newer version outside your version constraint is available.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"版本 {version}","ui.cloudStatus.waitingTime":"等待时间","ui.cloudStatus.jobs":"当前工作","ui.cloudStatus.workers":"工作者","ui.cloudStatus.approx":"{minutes} 分钟","ui.cloudStatus.none":"无","ui.cloudStatus.short":"ca. {minutes} 分钟","ui.cloudStatus.long":"ca. {minutes} 分钟 {seconds} 秒","ui.cloudStatus.error":"Unable to fetch the status of the Composer Resolver Cloud. It might be down for maintenance or experience issues.","ui.cloudStatus.button":"Cloud Status","ui.cloudStatus.refresh":"Refresh Cloud Status","ui.log-viewer.loading":"加载 …","ui.log-viewer.empty":"There are no log files on your server.","ui.log-viewer.reload":"Reload","ui.log-viewer.file":"Log file","ui.log-viewer.channel":"Channel","ui.log-viewer.channelTitle":"The channel this message was logged to.","ui.log-viewer.level":"Level","ui.log-viewer.levelTitle":"Severity of the log message.","ui.log-viewer.timeHeader":"Time","ui.log-viewer.messageHeader":"Message","ui.log-viewer.showContext":"Show Context","ui.log-viewer.hideContext":"Hide Context","ui.log-viewer.showExtra":"Show Extra","ui.log-viewer.hideExtra":"Hide Extra","ui.log-viewer.more":"Load more …","ui.log-viewer.download":"Download","ui.log-viewer.downloadTitle":"Download file \\"{file}\\"","ui.log-viewer.prodEnvironment":"Production Environment","ui.log-viewer.devEnvironment":"Development Environment (Debug Mode)"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[523],{523:function(e){e.exports=JSON.parse('{"ui.app.title":"Contao Erweiterungen","ui.app.loading":"Lade Erweiterungsliste …","ui.app.language":"Sprache für den Contao Manager wechseln","ui.app.colorDark":"Dunkles Design","ui.app.colorDarkTitle":"Farbschema auf dunkel umstellen","ui.app.colorLight":"Helles Design","ui.app.colorLightTitle":"Farbschema auf hell umstellen","ui.discover.advertisement":"Anzeigen in der Erweiterungsliste","ui.discover.loading":"Laden …","ui.discover.offline":"Konnte keine Ergebnisse laden.","ui.discover.offlineExplain":"Prüfe deine Internet-Verbindung und deaktiviere alle JavaScript-Blocker.","ui.discover.offlineButton":"Erneut versuchen","ui.discover.searchPlaceholder":"{count} Erweiterungen durchsuchen …","ui.discover.empty":"Keine Ergebnisse für {query}","ui.discover.more":"Mehr Resultate","ui.discover.sortBy":"Sortieren nach","ui.discover.sortReleased":"Veröffentlicht","ui.discover.sortReleasedTitle":"Ergebnisse nach der Veröffentlichung sortieren","ui.discover.sortLatest":"Aktualisiert","ui.discover.sortLatestTitle":"Ergebnisse nach der letzten Aktualisierung sortieren","ui.discover.sortDownloads":"Downloads","ui.discover.sortDownloadsTitle":"Ergebnisse nach Anzahl Downloads sortieren","ui.discover.sortFavers":"Bewertung","ui.discover.sortFaversTitle":"Ergebnisse nach Bewertung sortieren","ui.discover.detailsButton":"Details","ui.discover.latestPackages":"Neuste und aktualisierte Erweiterungen","ui.discover.faversPackages":"Bestbewertete Erweiterungen","ui.discover.downloadsPackages":"Meistgeladene Erweiterungen","ui.discover.exactHit":"Exakte Übereinstimmung der Suchanfrage","ui.discover.results":"Weitere Suchergebnisse","ui.package.homepage":"Projektwebseite","ui.package.private":"Privates Paket","ui.package.privateTitle":"Private Pakete sind nur vom jeweiligen Hersteller verfügbar (z.B. als ZIP-Download). Besuche die Webseite für weitere Informationen.","ui.package.abandoned":"verwaist","ui.package.abandonedText":"Diese Erweiterung ist verwaist und wird nicht mehr gepflegt.","ui.package.abandonedReplace":"Diese Erweiterung ist verwaist und wird nicht mehr gepflegt. Der Autor empfiehlt stattdessen das Paket {replacement} zu verwenden.","ui.package.contaoVersion":"Verfügbar für Contao","ui.package-details.previous":"Details der vorherigen Erweiterung","ui.package-details.close":"Details der Erweiterung schließen","ui.package-details.loading":"Laden …","ui.package-details.tabDescription":"Beschreibung","ui.package-details.tabRequire":"Abhängigkeiten","ui.package-details.tabFeatures":"Funktionen","ui.package-details.tabSuggest":"Empfehlungen","ui.package-details.tabConflict":"Konflikte","ui.package-details.tabDependents":"Abhängige","ui.package-details.linkRequires":"benötigt","ui.package-details.linkReplaces":"ersetzt","ui.package-details.linkProvides":"liefert","ui.package-details.linkConflicts":"inkompatibel mit","ui.package-details.funding":"Weiterentwicklung finanzieren!","ui.package-details.contaoVersions":"Unterstützte Contao-Version(en)","ui.package-details.latest":"Neuste Version","ui.package-details.released":"veröffentlicht am","ui.package-details.license":"Lizenz(en)","ui.package-details.authors":"von","ui.package-details.more":"Mehr","ui.package-details.packagist":"Paketdetails","ui.package-details.metadata":"Metadaten bearbeiten","ui.package-details.support_docs":"Dokumentation","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Support-Forum","ui.package-details.support_issues":"Fehler melden","ui.package-details.support_source":"Quellcode","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Support E-Mail","ui.package-details.support_rss":"RSS-Feed"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[826],{9472:function(t,e,s){t.exports=s.p+"img/database.7f0a8c49.svg"},9826:function(t,e,s){s.r(e),s.d(e,{default:function(){return K}});var a=s(641),i=s(33),n=s(9472);const o={class:"database-migration__header"},l={class:"database-migration__headline"},r={key:0,class:"database-migration__text"},c={key:1,class:"database-migration__text"},u={class:"database-migration__description"},h={class:"database-migration__loading"},g={key:0,class:"database-migration__description"},m={key:1,class:"database-migration__description"},d={key:2,class:"database-migration__description"},p={class:"database-migration__actions"},b=["disabled"],y={class:"database-migration__actions"},k=["disabled"],_=["disabled"],w=["disabled"],$=["disabled"],v=["disabled"],C={class:"database-migration__description"},E={class:"database-migration__actions"},f={key:0,class:"database-migration__actions"};function x(t,e,s,x,A,D){const L=(0,a.g2)("loading-spinner"),T=(0,a.g2)("loading-button"),X=(0,a.g2)("check-box"),R=(0,a.g2)("console-output"),F=(0,a.g2)("boxed-layout");return(0,a.uX)(),(0,a.Wv)(F,{wide:!0,slotClass:"database-migration"},{default:(0,a.k6)((()=>[(0,a.Lk)("header",o,[e[7]||(e[7]=(0,a.Lk)("img",{src:n,width:"80",height:"80",alt:"",class:"database-migration__icon"},null,-1)),(0,a.Lk)("h1",l,(0,i.v_)(t.$t("ui.migrate.headline")),1),"migrations-only"===t.type?((0,a.uX)(),(0,a.CE)("p",r,(0,i.v_)(t.$t("ui.migrate.migrationsOnly")),1)):(0,a.Q3)("",!0),"schema-only"===t.type?((0,a.uX)(),(0,a.CE)("p",c,(0,i.v_)(t.$t("ui.migrate.schemaOnly")),1)):(0,a.Q3)("",!0),t.checking?((0,a.uX)(),(0,a.CE)(a.FK,{key:2},[(0,a.Lk)("p",u,(0,i.v_)(t.$t("ui.migrate.loading")),1),(0,a.Lk)("div",h,[(0,a.bF)(L)])],64)):D.isEmpty?((0,a.uX)(),(0,a.CE)(a.FK,{key:3},["migrations-only"===t.type?((0,a.uX)(),(0,a.CE)("p",g,(0,i.v_)(t.$t("ui.migrate.emptyMigrations")),1)):"schema-only"===t.type?((0,a.uX)(),(0,a.CE)("p",m,(0,i.v_)(t.$t("ui.migrate.emptySchema")),1)):((0,a.uX)(),(0,a.CE)("p",d,(0,i.v_)(t.$t("ui.migrate.empty")),1)),(0,a.Lk)("div",p,["migrations-only"===t.type||"schema-only"===t.type?((0,a.uX)(),(0,a.CE)("button",{key:0,class:"widget-button widget-button--primary",disabled:t.closing,onClick:e[0]||(e[0]=t=>D.checkAll())},(0,i.v_)(t.$t("ui.migrate.retryAll")),9,b)):(0,a.Q3)("",!0),(0,a.bF)(T,{loading:t.closing,onClick:D.close},{default:(0,a.k6)((()=>[(0,a.eW)((0,i.v_)(t.$t("ui.migrate.close")),1)])),_:1},8,["loading","onClick"])])],64)):!t.executing&&(D.isComplete||D.hasError||D.hasProblem)?((0,a.uX)(),(0,a.CE)(a.FK,{key:4},[((0,a.uX)(!0),(0,a.CE)(a.FK,null,(0,a.pI)(D.description.split("\n"),((t,e)=>((0,a.uX)(),(0,a.CE)("p",{class:"database-migration__description",key:e},(0,i.v_)(t),1)))),128)),(0,a.Lk)("div",y,["problem"===t.type?((0,a.uX)(),(0,a.CE)(a.FK,{key:0},[(0,a.bF)(T,{loading:t.closing,onClick:D.close},{default:(0,a.k6)((()=>[(0,a.eW)((0,i.v_)(t.$t("ui.migrate.cancel")),1)])),_:1},8,["loading","onClick"]),(0,a.Lk)("button",{class:"widget-button",disabled:t.closing,onClick:e[1]||(e[1]=(...t)=>D.setup&&D.setup(...t))},(0,i.v_)(t.$t("ui.migrate.setup")),9,k),(0,a.Lk)("button",{class:"widget-button widget-button--primary",disabled:t.closing,onClick:e[2]||(e[2]=t=>D.checkAll())},(0,i.v_)(t.$t("ui.migrate.retry")),9,_)],64)):"warning"===t.type?((0,a.uX)(),(0,a.CE)(a.FK,{key:1},[(0,a.bF)(T,{loading:t.closing,onClick:D.close},{default:(0,a.k6)((()=>[(0,a.eW)((0,i.v_)(t.$t("ui.migrate.cancel")),1)])),_:1},8,["loading","onClick"]),(0,a.Lk)("button",{class:"widget-button widget-button",disabled:t.closing,onClick:e[3]||(e[3]=t=>D.checkAll())},(0,i.v_)(t.$t("ui.migrate.retry")),9,w),(0,a.Lk)("button",{class:"widget-button widget-button--primary",disabled:t.closing,onClick:e[4]||(e[4]=t=>D.checkAll(!0))},(0,i.v_)(t.$t("ui.migrate.skip")),9,$)],64)):t.hasChanges?((0,a.uX)(),(0,a.CE)(a.FK,{key:2},[(0,a.bF)(T,{loading:t.closing,onClick:D.close},{default:(0,a.k6)((()=>[(0,a.eW)((0,i.v_)(t.$t("ui.migrate.cancel")),1)])),_:1},8,["loading","onClick"]),(0,a.Lk)("button",{class:"widget-button widget-button--primary",disabled:t.closing,onClick:e[5]||(e[5]=t=>D.check())},(0,i.v_)(t.$t("ui.migrate.continue")),9,v)],64)):((0,a.uX)(),(0,a.Wv)(T,{key:3,loading:t.closing,onClick:D.close},{default:(0,a.k6)((()=>[(0,a.eW)((0,i.v_)(t.$t("ui.migrate.confirm")),1)])),_:1},8,["loading","onClick"]))])],64)):((0,a.uX)(),(0,a.CE)(a.FK,{key:5},[(0,a.Lk)("p",C,(0,i.v_)(t.$t("ui.migrate.pending")),1),(0,a.Lk)("div",E,[(0,a.bF)(T,{class:"database-migration__action",loading:t.closing,disabled:t.executing,onClick:D.close},{default:(0,a.k6)((()=>[(0,a.eW)((0,i.v_)(t.$t("ui.migrate.cancel")),1)])),_:1},8,["loading","disabled","onClick"]),(0,a.bF)(T,{class:"database-migration__action",color:"primary",loading:t.executing,disabled:t.closing,onClick:D.execute},{default:(0,a.k6)((()=>[(0,a.eW)((0,i.v_)(t.$t("ui.migrate.execute")),1)])),_:1},8,["loading","disabled","onClick"])]),t.hasDeletes?((0,a.uX)(),(0,a.CE)("div",f,[(0,a.bF)(X,{name:"withDeletes",label:t.$t("ui.migrate.withDeletes"),disabled:t.executing,modelValue:t.withDeletes,"onUpdate:modelValue":e[6]||(e[6]=e=>t.withDeletes=e)},null,8,["label","disabled","modelValue"])])):(0,a.Q3)("",!0)],64))]),!t.checking&&t.operations&&t.operations.length?((0,a.uX)(),(0,a.Wv)(R,{key:0,class:"database-migration__main",title:D.consoleTitle,operations:t.operations,"console-output":D.console,"force-console":D.hasProblem},null,8,["title","operations","console-output","force-console"])):(0,a.Q3)("",!0)])),_:1})}s(4114),s(8111),s(7588),s(1701);var A=s(6278),D=s(4335),L=s(707),T=s(728),X=s(9045),R=s(85),F=s(2864),O=s(3480),W={components:{BoxedLayout:T.A,LoadingSpinner:X.A,LoadingButton:R.A,ConsoleOutput:F.A,CheckBox:O.A},data:()=>({type:null,status:"",changes:null,hasDeletes:!1,operations:null,hash:null,withDeletes:!1,previousResult:!0,checking:!0,executing:!1,closing:!1}),computed:{...(0,A.aH)("server/database",["supported"]),...(0,A.aH)(["setupStep"]),...(0,A.L8)("server/database",["hasChanges"]),isEmpty:t=>"active"!==t.status&&t.operations&&!t.operations.length,isComplete:t=>"complete"===t.status,hasError:t=>"error"===t.status,hasProblem:t=>"problem"===t.type||"warning"===t.type,description(){return"problem"===this.type?this.$tc("ui.migrate.problem",this.operations?.length||0):"warning"===this.type?this.$t("ui.migrate.warning"):this.previousResult&&this.hasChanges?this.$t("ui.migrate.previousChanges"):this.previousResult?this.$t("ui.migrate.previousComplete"):this.isComplete&&this.hasChanges?this.$t("ui.migrate.appliedChanges"):this.isComplete?this.$t("ui.migrate.appliedComplete"):this.$t("ui.migrate.error")},consoleTitle(){switch(this.type){case"migrations":case"migrations-only":return this.$t("ui.migrate.migrationTitle");case"schema":case"schema-only":return this.$t("ui.migrate.schemaTitle");case"problem":return this.$t("ui.migrate.problemTitle");case"warning":return this.$t("ui.migrate.warningTitle")}return""},console(){if(!this.changes||!this.changes.length)return"";let t="";return this.changes.forEach((e=>{t+=`${e.name}\n`})),t}},methods:{async poll(t){if(201===t.status)return new Promise((t=>{setTimeout((async()=>{await this.poll(await D.A.get("api/contao/database-migration")),t()}),1e3)}));const e=t.data;return this.changes&&!e.status||(this.type=e.type,this.status=e.status,this.hash=e.hash,this.changes=e.operations),e.status&&"active"!==e.status?void 0:new Promise((t=>{setTimeout((async()=>{await this.poll(await D.A.get("api/contao/database-migration")),t()}),1e3)}))},async execute(){this.executing=!0,await D.A.put("api/contao/database-migration",{type:this.type,hash:this.hash,withDeletes:this.withDeletes&&this.hasDeletes}),setTimeout((async()=>{await this.poll(await D.A.get("api/contao/database-migration")),await this.$store.dispatch("server/database/get",!1),this.executing=!1}),1e3)},async check(t=!1){this.checking=!0;const e=this.type||this.$store.state.migrationsType;this.status&&(this.type=null,this.status="",this.changes=null,this.hash=null,await D.A.delete("api/contao/database-migration"));let s=await D.A.get("api/contao/database-migration");204===s.status&&(this.previousResult=!1,s=await D.A.put("api/contao/database-migration",{type:e,skipWarnings:t})),await this.poll(s),await D.A.delete("api/contao/database-migration"),this.checking=!1},checkAll(t=!1){this.type=null,this.check(t)},generateStatus(t,e){return e?`~${t}~`:t},async close(){this.closing=!0,await D.A.delete("api/contao/database-migration"),await this.$store.dispatch("server/database/get",!1),this.setupStep>0?(await this.$store.dispatch("server/adminUser/get",!1),this.$store.commit("setView",L.A.SETUP)):this.$store.commit("setView",L.A.READY),this.closing=!1},async setup(){this.$store.commit("setup",3)},updateOperations(){if(this.hasDeletes=!1,this.operations=null,!this.changes)return;if(this.hasProblem)return void(this.operations=this.changes.map((t=>({status:t.status,summary:t.name,details:t.message,console:t.trace}))));if("migrations"===this.type||"migrations-only"===this.type)return void(this.operations=this.changes.map((t=>({status:t.status,summary:t.name,details:t.message}))));const t=[];this.changes.forEach((e=>{let s;if(s=new RegExp("^CREATE TABLE ([^ ]+) .+$").exec(e.name),s)t.push({status:e.status,summary:this.$t("ui.migrate.addTable",{table:s[1]}),details:e.message,console:e.name});else{if(s=new RegExp("^DROP TABLE (.+)$").exec(e.name),s)return t.push({status:this.withDeletes?e.status:"skipped",summary:this.generateStatus(this.$t("ui.migrate.dropTable",{table:s[1]}),!this.withDeletes),details:e.message,console:e.name}),void(this.hasDeletes=!0);if(s=new RegExp("^CREATE INDEX ([^ ]+) ON ([^ ]+) \\(([^)]+)\\)$").exec(e.name),s)t.push({status:e.status,summary:this.$t("ui.migrate.createIndex",{name:s[1],table:s[2]}),details:e.message||s[3],console:e.name});else{if(s=new RegExp("^DROP INDEX ([^ ]+) ON ([^ ]+)$").exec(e.name),s)return t.push({status:this.withDeletes?e.status:"skipped",summary:this.generateStatus(this.$t("ui.migrate.dropIndex",{name:s[1],table:s[2]}),!this.withDeletes),details:e.message,console:e.name}),void(this.hasDeletes=!0);if(s=new RegExp("^ALTER TABLE ([^ ]+) (.+)$").exec(e.name),s){const a=s[1],i={status:e.status,summary:[],details:[],console:e.name};e.message&&i.details.push(e.message);let n="";s[2].split("'").forEach(((t,e)=>{n=e%2?`${n}'${t.replace(",","%comma%")}'`:`${n}${t}`}));const o=n.split(",").map((t=>t.trim().replace("%comma%",",")));let l=0;return o.forEach((t=>{let s;return s=new RegExp("^ADD ([^ ]+) (.+)$").exec(t),s?(i.summary.push(this.$t("ui.migrate.addField",{table:a,field:s[1]})),void(e.message||i.details.push(s[2]))):(s=new RegExp("^CHANGE ([^ ]+) ([^ ]+) (.+)$").exec(t),s?(i.summary.push(this.$t("ui.migrate.changeField",{table:a,field:s[1]})),void(e.message||i.details.push(s[3]))):(s=new RegExp("^DROP (.+)$").exec(t),s?(i.summary.push(this.generateStatus(this.$t("ui.migrate.dropField",{table:a,field:s[1]}),!this.withDeletes)),i.details.push(""),this.hasDeletes=!0,void l++):(i.summary.push(`ALTER TABLE ${a} ${t}`),void i.details.push(""))))})),l===o.length&&(i.status=this.withDeletes?e.status:"skipped"),void t.push(i)}t.push({status:e.status,summary:e.name,details:e.message,console:e.name}),this.hasDeletes=!0}}})),this.operations=t}},watch:{changes(){this.updateOperations()},withDeletes(){this.updateOperations()}},mounted(){this.check()}},P=s(6262);const S=(0,P.A)(W,[["render",x]]);var K=S}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[542],{7542:function(e){e.exports=JSON.parse('{"ui.app.title":"Contao 扩展","ui.app.loading":"扩展列表加载中 …","ui.app.language":"Switch language for the Contao Manager","ui.app.colorDark":"Dark Mode","ui.app.colorDarkTitle":"Switch color scheme to dark","ui.app.colorLight":"Light Mode","ui.app.colorLightTitle":"Switch color scheme to light","ui.discover.advertisement":"Advertisement in the extension list","ui.discover.loading":"加载 …","ui.discover.offline":"无法获取任何结果","ui.discover.offlineExplain":"检查网络连接并在浏览器中禁用JavaScript拦截器。","ui.discover.offlineButton":"重试","ui.discover.searchPlaceholder":"Search in {count} extensions …","ui.discover.empty":"No results for {query}","ui.discover.more":"更多","ui.discover.sortBy":"排序","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"已更新","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"下载","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"评级","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"详情","ui.discover.latestPackages":"最新和已更新扩展","ui.discover.faversPackages":"最高评级扩展","ui.discover.downloadsPackages":"下载最多扩展","ui.discover.exactHit":"Exact query match","ui.discover.results":"More search results","ui.package.homepage":"项目网站","ui.package.private":"私有包","ui.package.privateTitle":"私有包仅可从提供商获取 (e.g. ZIP 下载)。请访问网站获取更多信息。","ui.package.abandoned":"放弃","ui.package.abandonedText":"该程序包已放弃不再维护。","ui.package.abandonedReplace":"该程序包已放弃不再维护。作者建议使用 {replacement} 包替代.","ui.package.contaoVersion":"Available for Contao","ui.package-details.previous":"以前的扩展详细信息","ui.package-details.close":"关闭扩展详情","ui.package-details.loading":"加载 …","ui.package-details.tabDescription":"描述","ui.package-details.tabRequire":"需求","ui.package-details.tabFeatures":"特征","ui.package-details.tabSuggest":"建议","ui.package-details.tabConflict":"冲突","ui.package-details.tabDependents":"依赖","ui.package-details.linkRequires":"需要","ui.package-details.linkReplaces":"替换","ui.package-details.linkProvides":"提供","ui.package-details.linkConflicts":"冲突","ui.package-details.funding":"Fund package maintenance!","ui.package-details.contaoVersions":"Supported Contao version(s)","ui.package-details.latest":"最新版","ui.package-details.released":"发布于","ui.package-details.license":"许可(s)","ui.package-details.authors":"from","ui.package-details.more":"更多","ui.package-details.packagist":"包详情","ui.package-details.metadata":"编辑元数据","ui.package-details.support_docs":"文档","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"支持论坛","ui.package-details.support_issues":"问题 / 错误 报告","ui.package-details.support_source":"源代码","ui.package-details.support_irc":"IRC / 聊天","ui.package-details.support_email":"支持 E-Mail","ui.package-details.support_rss":"RSS"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[581],{4581:function(a){a.exports=JSON.parse('{"ui.app.title":"Contao проширења","ui.app.loading":"Учитавам листу проширења...","ui.app.language":"Switch language for the Contao Manager","ui.app.colorDark":"Dark Mode","ui.app.colorDarkTitle":"Switch color scheme to dark","ui.app.colorLight":"Light Mode","ui.app.colorLightTitle":"Switch color scheme to light","ui.discover.advertisement":"Оглашавање у листи екстензија","ui.discover.loading":"Учитавам ...","ui.discover.offline":"Нема пронађених резултата.","ui.discover.offlineExplain":"Проверите вашу интернет конекцију и искључите блокаду JavaScript-а у вашем прегледачу.","ui.discover.offlineButton":"Покушајте поново","ui.discover.searchPlaceholder":"Претражи у {count} екстензија ...","ui.discover.empty":"Нема резултата за {query}","ui.discover.more":"Више резултата","ui.discover.sortBy":"Сортирај по","ui.discover.sortReleased":"Објављено","ui.discover.sortReleasedTitle":"Поредај резултате по датуму објаве","ui.discover.sortLatest":"Ажурирано","ui.discover.sortLatestTitle":"Поредај резултате по датуму ажурирања","ui.discover.sortDownloads":"Преузимања","ui.discover.sortDownloadsTitle":"Поредај резултате по броју преузимања","ui.discover.sortFavers":"Оцене","ui.discover.sortFaversTitle":"Поредај резултате по оцени","ui.discover.detailsButton":"Детаљи","ui.discover.latestPackages":"Последње и ажуриране екстензије","ui.discover.faversPackages":"Најбоље оцењене екстензије","ui.discover.downloadsPackages":"Екстензије са највише преузимања","ui.discover.exactHit":"Exact query match","ui.discover.results":"More search results","ui.package.homepage":"Вебсајт пројекта","ui.package.private":"Приватни пакети","ui.package.privateTitle":"Приватни пакети су доступни само од вендора (нпр. као ZIP преузимање). Посетите сајт ради више информација.","ui.package.abandoned":"напуштено","ui.package.abandonedText":"Овај пакет је напуштен и више се не одржава.","ui.package.abandonedReplace":"Овај пакет је напуштен и више се не одржава. Аутор предлаже да користите {replacement} као замену.","ui.package.contaoVersion":"Available for Contao","ui.package-details.previous":"Детаљи претходне екстензије","ui.package-details.close":"Затвори детаље екстензије","ui.package-details.loading":"Учитавам ...","ui.package-details.tabDescription":"Опис","ui.package-details.tabRequire":"Захтеви","ui.package-details.tabFeatures":"Могућности","ui.package-details.tabSuggest":"Предлози","ui.package-details.tabConflict":"Конфликти","ui.package-details.tabDependents":"Зависности","ui.package-details.linkRequires":"захтева","ui.package-details.linkReplaces":"мења","ui.package-details.linkProvides":"пружа","ui.package-details.linkConflicts":"сукобљава се са","ui.package-details.funding":"Спонзорирајте одржавање пакета!","ui.package-details.contaoVersions":"Supported Contao version(s)","ui.package-details.latest":"Последња верзија","ui.package-details.released":"објављено","ui.package-details.license":"Лиценца(е)","ui.package-details.authors":"од","ui.package-details.more":"Детаљније","ui.package-details.packagist":"Детаљи пакета","ui.package-details.metadata":"Уреди мета податке","ui.package-details.support_docs":"Документација","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Форум за подршку","ui.package-details.support_issues":"Пријава проблема/Баг","ui.package-details.support_source":"Изворни код","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Имејл подршке","ui.package-details.support_rss":"RSS сажетак"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[551],{2551:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! この接続は安全ではありません !!","ui.app.httpsDescription":"HTTPSでないと秘密のデータも暗号化しないで送信してしまいます。","ui.app.httpsLink":"詳細な情報","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! セーフモードが有効です !!","ui.app.safeModeDescription":"Contao Managerの一部の機能は利用できません。","ui.app.safeModeExit":"セーフモードを終了","ui.app.limitedHeadline":"リモート認証","ui.app.limitedDescription":"パスワードなしのログインのため限れた権限になっています。","ui.app.limitedLogout":"再認証","ui.app.totpHeadline":"セキュリティの注意","ui.app.totpDescription":"すぐに2ファクタ認証を構成してアカウントを安全にします。","ui.app.totpSetup":"セットアップ","ui.app.loading":"Contao Managerを読み込み中…","ui.app.apiError":"予期しないAPIの状態","ui.app.configSecurity1":"セキュリティ警告!!!  保護していない設定ディレクトリを検出","ui.app.configSecurity2":"Contao Managerは設定ファイルが公開してアクセスできる状態を検出しました。ディレクトリを安全な状態にするまで、すべての操作は動作しません、そうしないとインストールに含まれている極秘データを攻撃者がアクセスできる可能性があるためです。\\n\\nこれを修正するには\\"contao-manager\\"のディレクトリへのアクセスを禁止してください。この方法を学ぶには、ウェブサーバーのマニュアルを参照するかホスティング提供者に連絡してください。","ui.account.welcome":"ようこそ","ui.account.intro1":"Contao Managerにようこそ。Contao ManagerはContaoオープンソースCMSのインストールと管理を行う多才なツールです。Contao Managerを初めて利用する場合は{readTheManualToGetStarted}","ui.account.introGetStarted":"最初に{readTheManual} ","ui.account.introManual":"マニュアルを読んでください","ui.account.intro2":"何か問題があった場合は、{ourGithubIssues} を確認して、まだ報告されていない新しいどの様な問題は自由に新しいIssueを作成してください。","ui.account.introIssues":"GitHubのIssue","ui.account.headline":"ユーザーアカウント","ui.account.description":"インストールしたContaoを管理するには新しいアカウントを作成してください。このアカウントはContaoのバックエンドやフロントエンドとはまったく関係ないことに注意してください。","ui.account.username":"ユーザー名","ui.account.password":"パスワード","ui.account.passwordPlaceholder":"最小で8文字","ui.account.passwordLength":"少なくとも8文字を入力してください。","ui.account.loginInvalid":"アカウントの作成でエラーとなりました。異なるユーザー名で試してください。","ui.account.submit":"アカウントを作成","ui.account.usePassword":"ログインにパスワードを使用","ui.account.usePasskey":"パスキーをログインに使用","ui.account.totpHeadline":"2ファクター認証","ui.account.totpDescription":"2ファクター認証を有効にしてセキュリティレベルを高めてください。ユーザー名とパスワードに加えて、1Password、Authy、Google Authenticator、LastPass Authenticatorや他のTOTP(Time-based One-Time Password)アプリの確認コードの入力が必要となります。","ui.account.totpSetup":"すぐに設定","ui.account.totpSkip":"後で設定","ui.account.login":"申し出を拒否","ui.account.contribute1":"ContaoとContao Managerは非営利のContao Associationが支援しています。","ui.account.contribute2":"{donate}でオープンソースに貢献することをご検討ください。","ui.account.contributeDonate":"寄付をする","ui.login.headline":"サインイン","ui.login.description":"インストールを管理するにはログインします。","ui.login.username":"ユーザー名","ui.login.password":"パスワード","ui.login.totpHeadline":"2ファクター認証","ui.login.totpDescription":"確認コードを入力してログイン処理を完了してください。","ui.login.totp":"確認コード","ui.login.forgotPassword":"パスワードを忘れましたか?","ui.login.button":"サインイン","ui.login.passkey":"パスキーでサインイン","ui.login.cancel":"取り止め","ui.login.or":"または","ui.login.locked":"Contao Managerはロック状態のためアクセスを拒否しました。ロックを解除するには、Contaoのルートディレクトリにあるファイル: {lockFile}を削除してください。","ui.logout.headline":"セッションタイムアウト","ui.logout.warning":"25分以上アクセスがありません。セキュリティ上の理由から、セッションを間もなく終了します。","ui.logout.expired":"30分以上アクセスがなかったため自動的にセッションを終了しました。","ui.logout.renew":"ログインを維持","ui.logout.logout":"ログアウト","ui.logout.login":"ログイン画面に戻る","ui.oauth.error":"不正なOAuthの試みです。リクエストのパラメーターを確認してください。","ui.oauth.https":"平文で認証トークンが転送されることを防ぐため、リダイレクトのURIは安全なプロトコル(https:)を*使用*しなければなりません。","ui.oauth.headline":"リモート認証","ui.oauth.description":"以下のアプリケーションやサービスが、このContao Managerへのリモートアクセスを要求しています。","ui.oauth.domain":"アクセスを許可する前に、このURLのことを知っていて所有者を信頼できることを確認してください!","ui.oauth.outOfScope":"残念ですが、このアクセスを許可するのに十分な権限がありません。","ui.oauth.allow":"アクセスを許可","ui.oauth.deny":"アクセスを拒否","ui.oauth.switchUser":"ユーザーを切り替え","ui.scope.admin":"ユーザー管理を含んだ管理者アクセス","ui.scope.install":"新しいパッケージのインストールとContaoの構成の変更","ui.scope.update":"パッケージの更新と保守の作業の実行","ui.scope.read":"パッケージと構成の読み取り","ui.boot.headline":"システム検査","ui.boot.description":"しばらくお待ちください、サーバーを解析中です...","ui.boot.issue1":"インストール上の問題を検出","ui.boot.issue2":"Contao Managerを使用できるようにする前に修正しなければならない問題があります。","ui.boot.run":"Contao Managerを開始","ui.boot.safeMode":"セーフモードで開始","ui.recovery.headline":"システム回復","ui.recovery.description":"Contao ManagerはContaoと思われるファイルを検出しましたが、コマンド行のインターフェイスは期待した様に動作しませんでした。","ui.recovery.console":"コンソール出力","ui.recovery.repairOptions":"インストールしたContaoを修正する方法を選択してください。","ui.recovery.repairHeadline":"自動修復","ui.recovery.repairDescription":"アプリケーションキャッシュの再構築とComposerパッケージを再インストールすることで、自動的にインストールの修復を試みます。","ui.recovery.repairWarning":"この処理でベンダーのファイルに行った変更は取り消されるかもしれません!","ui.recovery.repairFailed":"自動修復できませんでした。セーフモードで手作業でインストールを修復してみてください。","ui.recovery.repairButton":"システム修復を実行","ui.recovery.safeModeHeadline":"セーフモード","ui.recovery.safeModeDescription":"Contao Managerをセーフモードで開始するとパッケージの管理と特定の保守のタスクを実行できます。しかし、インストールしたContaoの動作に依存した機能は利用できません。","ui.recovery.safeModeButton":"セーフモードで開始","ui.server.pending":"待機中...","ui.server.running":"解析中…","ui.server.error":"サーバーからの予期しない応答のため検査に失敗しました。","ui.server.details":"詳細","ui.server.prerequisite":"前提条件を満たせていないため検査を取り止めました。","ui.server.selfUpdate.title":"Contao Managerを更新","ui.server.selfUpdate.update":"新しいContao Managerのバージョン {latest} を利用できます。","ui.server.selfUpdate.manualUpdate":"新しいContao Managerバージョン{latest}を利用できます。使用しているサーバーは自動的な更新をサポートしていません、新しいバージョンを {download} からダウンロードしてください。","ui.server.selfUpdate.latest":"最新のバージョン: {current}を使用しています。","ui.server.selfUpdate.dev":"開発版は自動的な更新をサポートしていません。","ui.server.selfUpdate.unsupported":"新しいバージョンを利用できますが、使用しているPHPのバージョンをサポートしていません。","ui.server.selfUpdate.button":"自己更新を実行","ui.server.selfUpdate.continue":"続ける","ui.server.config.title":"サーバーの構成","ui.server.config.setup":"構成","ui.server.config.change":"変更","ui.server.config.save":"保存","ui.server.config.cancel":"取り止め","ui.server.config.customOption":"その他…","ui.server.config.description":"バックグラウンドのタスクを正しく実行するため、Contao ManagerはPHPのコマンド行の実行ファイルがある場所と、ウェブのプロセスから切り離してコマンドを実行する方法を知る必要があります。","ui.server.config.formTitle":"サーバーの構成","ui.server.config.formText":"PHPの実行ファイルのパスを入力してください。Webのプロセスと同じバージョンのPHPであることを忘れずに確認してください。","ui.server.config.cloudTitle":"Composerリゾルバークラウド","ui.server.config.cloudText":"Composerリゾルバークラウドによって、サーバーが十分なローカルのメモリを提供しない場合でもComposerの依存関係のインストールが可能になります。パッケージの情報がContao Associationが運用するクラウドに送信されることに注意してください。","ui.server.config.cloud":"Composerリゾルバークラウドを使用","ui.server.config.cli":"PHPの実行ファイル","ui.server.config.stateErrorCli":"有効なPHPの実行ファイルをサーバー上に見つけられませんでした。","ui.server.config.stateErrorCloud":"Composerリゾルバークラウドをサポートしていません。","ui.server.config.stateSuccess":"PHPの実行ファイルは{php_cli}です。","ui.server.php_web.title":"PHPのWebプロセス","ui.server.php_web.below7":"PHPのバージョン {version} を検出しました。可能な限りPHP 7に切り替えてください!","ui.server.php_web.success":"PHPのバージョン {version} を検出しました、既知の問題はありませんでした。","ui.server.php_cli.title":"PHPコマンド行インターフェイス","ui.server.php_cli.success":"PHPのバージョン {version} を検出しました、既知の問題はありませんでした。","ui.server.composer.title":"Composer環境","ui.server.composer.success":"既知の問題はありませんでした。","ui.server.composer.install":"Composerの依存関係はインストールしていません。","ui.server.composer.button":"インストール","ui.server.contao.title":"Contaoのインストール","ui.server.contao.setup":"セットアップ","ui.server.contao.check":"データベースを検査","ui.server.contao.empty":"インストールしているContaoは見つかりませんでした。","ui.server.contao.old":"Contaoのバージョン{version}はContao Managerと互換性がありません。インストールしているContaoを手作業で更新してください。","ui.server.contao.found":"Contao {version} (APIバージョン {api})を検出しました。","ui.server.contao.connectionError":"データベースサーバーに接続できません。","ui.server.contao.connectionProblem":"データベースの問題が見つかりました。","ui.server.contao.missingUser":"管理者のアカウントがありません。","ui.setup.continue":"続ける","ui.setup.manager":"Contao Managerを開始","ui.setup.cancel":"取り止め","ui.setup.welcome":"ようこそ","ui.setup.welcome1":"このウィザードはContaoオープンソースCMSを設定するのに必要な段階を案内します。","ui.setup.welcome2":"もし質問がありましたらドキュメント、フォーラム、Slackのチャンネル、さらに多くの情報を{support}のページから探してください。","ui.setup.support":"コミュニティサポート","ui.setup.start":"始める","ui.setup.complete":"おめでとうございます!","ui.setup.complete1":"Contao {version}をうまくインストールしました。","ui.setup.complete2":"設定の処理を終えるには、インストールツールを開いて、データベース接続を構成し、バックエンドのユーザーを作成してください。","ui.setup.complete3":"Contaoのバックエンドでウェブサイトを作成できるようになりました。追加の機能拡張が必要な場合は、Contao Managerを続けてください。","ui.setup.installTool":"インストールツールを開く","ui.setup.login":"Contaoにログイン","ui.setup.funding":"フリーソフトウェアの「フリー」は「言論の自由」の自由であって、「無料のビール」の「無料」ではありません。Contaoのようなオープンソースのプロジェクトは一人の個人や1つの会社では集められない資金を必要とします。\\nContaoでウェブサイトを構築したり、構築したウェブサイトを販売される場合は、ビジネスが依存する製品に金銭的に貢献されることを期待しています。","ui.setup.fundingLink":"さらに学ぶ","ui.setup.document-root.headline":"Webサーバーの設定","ui.setup.document-root.warning":"Contao ManagerからContaoをインストールするには、Webサーバーのドキュメントルートを修正しなければなりません。","ui.setup.document-root.description1":"Contaoは公開するファイルに別のフォルダーを使用し、その親のフォルダーにアプリケーションのファイルをインストールします。フォルダーの構造が正しくないか、またはフォルダーが空でない場合はContaoをインストールできません。","ui.setup.document-root.description2":"ドキュメントルートを構成する方法を知らない場合は、Contaoのドキュメントを読むかホスティングサービスの提供者に連絡してください。","ui.setup.document-root.documentation":"ドキュメントを読む","ui.setup.document-root.conflictsTitle":"インストール先のディレクトリが空ではありません","ui.setup.document-root.conflictsDirectory":"Contaoをインストールしようとしているルートのディレクトリが空ではありません、インストールの処理で{count}個のファイルを上書きするかもしれません。Contaoのために空のディレクトリ構造の作成を推奨しますが、以下のファイルを使用していないことが確かな場合は、これらを削除して再検査することもできます。","ui.setup.document-root.ignoreConflicts":"空でないディレクトリにContaoをインストールしようとしています。Web領域の既存のファイルを上書きする可能性を理解しています。","ui.setup.document-root.check":"再検査","ui.setup.document-root.create":"ディレクトリを作成","ui.setup.document-root.change":"ディレクトリを変更","ui.setup.document-root.formTitle":"ディレクトリ設定","ui.setup.document-root.formText1":"Contao Managerはサーバー上に新しいディレクトリ構成を自動的に作成できます。","ui.setup.document-root.formText2":"手作業で(例えば、ホスティングの管理パネルから)新しいドキュメントルートを構成する必要があります。","ui.setup.document-root.autoconfig":"サーバーの構成を変更しなければならないことを理解しました。ドキュメントルートを構成しないとContao Managerは壊れ、(アカウントの詳細とパスワードを含んだ)構成ファイルを剥き出しの状態にしてしまいます。","ui.setup.document-root.directory":"新しいディレクトリ","ui.setup.document-root.currentRoot":"現在のドキュメントルート","ui.setup.document-root.newRoot":"新しいドキュメントルート","ui.setup.document-root.finish":"ディレクトリの設定","ui.setup.document-root.publicDir":"{dir}を(Contao {version}の)公開ファイルの場所として使用","ui.setup.document-root.directoryInvalid":"有効なディレクトリの名前を入力してください。","ui.setup.document-root.directoryExists":"目的のディレクトリは既に存在します。異なる名前を入力してください。","ui.setup.document-root.confirmation":"Contao ManagerはContaoのインストールに必要なディレクトリを作成しました。次にウェブサーバーのドキュメントルートを構成しなければなりません。このページをそれまで再読み込みしないでください。","ui.setup.document-root.reload":"ページを再読み込み","ui.setup.document-root.success":"ウェブサーバーにディレクトリ構造を正しく設定できました!","ui.setup.document-root.installingProjectDir":"{dir}にアプリケーションのファイルをインストールします。","ui.setup.document-root.installingPublicDir":"{dir}に公開するファイルをインストールします。","ui.setup.document-root.installedProjectDir":"{dir}にアプリケーションのファイルをインストールしました。","ui.setup.document-root.installedPublicDir":"{dir}に公開するファイルをインストールしました。","ui.setup.create-project.headline":"Contaoのインストール","ui.setup.create-project.description":"Contaoの開発は{semver}の概念にしたがっていて、新しいマイナーバージョンを6か月毎にリリースします。現在サポートしているリリース:","ui.setup.create-project.semver":"セマンティックバージョニング","ui.setup.create-project.latestTitle":"最新","ui.setup.create-project.ltsTitle":"長期サポート版","ui.setup.create-project.latestQ1":"最新のバージョン、もっとも多くの機能を提供して{year}年2月までサポートします。","ui.setup.create-project.latestQ3":"最新のバージョン、もっとも多くの昨日を提供して{year}年8月までサポートします。","ui.setup.create-project.ltsText":"現在のLTSバージョン、安定性を重視する場合に選んでください。さらに{year}年2月までの長期サポートを提供します。","ui.setup.create-project.pltsText":"以前のLTSバージョン、さらに{year}年2月までの長期サポートを提供します。","ui.setup.create-project.requiresPHP":"少なくともPHP {version}が必要です、現在はPHP {current}です。","ui.setup.create-project.releaseplan":"詳細な情報は{contaoReleasePlan}を参照してください。","ui.setup.create-project.releaseplanLink":"Contaoのリリース計画","ui.setup.create-project.installed":"サーバーにContao {version}のインストールに成功しました。データベースの設定を続けるか、異なるバージョンをインストールするにはContao Managerを起動してください。","ui.setup.create-project.formTitle":"配布の選択","ui.setup.create-project.formText":"インストールするバージョンを選択してください。","ui.setup.create-project.version":"バージョン","ui.setup.create-project.demo":"Contaoのデモ版のWebサイトをインストール","ui.setup.create-project.demoDescription":"デモ版のWebサイトはContaoと、その基本的な特徴を知る助けとなります。テーマはさらに{store}で入手できます。","ui.setup.create-project.coreOnly":"最小のインストール(コアだけ)","ui.setup.create-project.noUpdate":"インストールを省く(専門家だけ!)","ui.setup.create-project.theme":"Contaoのテーマ","ui.setup.create-project.themeInstall":"Contaoのテーマをインストールするには、検索入力を使用するか、Contao Managerからのインストールをサポートしたテーマのファイル(.ctoまたは.zip)をアップロードしてください。","ui.setup.create-project.themeBuy":"必ず公式の{store}にアクセスしてください。","ui.setup.create-project.themeStore":"Contaoのテーマのストア","ui.setup.create-project.themeUpload":"テーマのファイル(.cto/.zip)をアップロード","ui.setup.create-project.themeInvalid":"アップロードしたファイルはContaoのテーマではないか、Contao Managerをサポートしていません。","ui.setup.create-project.themeWarning":"このテーマがサーバーと互換性があるかどうか、COntao Managerは判断できません。何か疑問がある場合はテーマのベンダーに相談してください。","ui.setup.create-project.themeTitle":"テーマの詳細を調査","ui.setup.create-project.themeDetails":"このテーマは以下の依存関係とファイルもインストールします。","ui.setup.create-project.themeRequire":"{count} 依存関係 | {count} 依存関係","ui.setup.create-project.themeFiles":"{count} ファイル | {count} ファイル","ui.setup.create-project.theme.or":"または公開テーマを検索","ui.setup.create-project.theme.search":"テーマを検索","ui.setup.create-project.theme.more":"さらにテーマ","ui.setup.create-project.theme.empty":"{query}に一致するテーマがありません。","ui.setup.create-project.theme.uploaded":"テーマのファイルのアップロードに成功しました。","ui.setup.create-project.theme.packageName":"パッケージ名","ui.setup.create-project.theme.version":"バージョン","ui.setup.create-project.theme.authors":"作成者","ui.setup.create-project.theme.upload":"{name} ({size})をアップロード中","ui.setup.create-project.install":"インストール","ui.setup.create-project.cancel":"取り止め","ui.setup.create-project.fileError":"{file}にcomposer.jsonがありません。","ui.setup.create-project.jsonError":"composer.jsonが不正なJSONを含んでいます。","ui.setup.create-project.schemaError":"composer.jsonのスキーマの検証に失敗しました。","ui.setup.database-connection.headline":"データベース接続","ui.setup.database-connection.description":"Contaoはページ、コンテント、ユーザー、他の関係のあるデータを保管するためにMySQLデータベース(またはMariaDBの様な互換性のある分岐)を必要とします。接続のパラメーターは、Contaoをインストールしたプロジェクトのルートにある{env}ファイルに保存します。","ui.setup.database-connection.formTitle":"接続パラメーター","ui.setup.database-connection.formText":"データベースのURLを入力するか、ユーザー名、パスワード、サーバー、データベースの欄を別々に入力してください。","ui.setup.database-connection.url":"データベースのURL","ui.setup.database-connection.validUrl":"データベースのURLが正しくないか、サーバーへの接続に失敗しました。","ui.setup.database-connection.or":"または","ui.setup.database-connection.user":"ユーザー名","ui.setup.database-connection.password":"パスワード","ui.setup.database-connection.server":"サーバー(:ポート)","ui.setup.database-connection.database":"データベース名","ui.setup.database-connection.connected":"{server}のデータベース{database}に接続しました。","ui.setup.database-connection.error":"データベースの接続のエラーです。","ui.setup.database-connection.problem":"Contaoはデータベースサーバーの問題を検出しました。","ui.setup.database-connection.schemaTitle":"データベーススキーマ","ui.setup.database-connection.migration":"未解決の移行が1件あります。 | 未解決の移行が{count}件あります。","ui.setup.database-connection.schema":"未解決のスキーマの更新が1件あります。 | 未解決のスキーマの更新が{count}件あります。","ui.setup.database-connection.noChanges":"データベースのスキーマは最新です。","ui.setup.database-connection.check":"データベースを検査","ui.setup.database-connection.skip":"飛ばす","ui.setup.database-connection.save":"保存","ui.setup.database-connection.change":"認証情報を変更","ui.setup.database-connection.restoreTitle":"データベースをインポート","ui.setup.database-connection.restoreText":"先ほどインストールしたテーマはデータベースのバックアップを含んでいます。データベースを復元してテーマのデータを取り込むか、空のContaoのインストールから始める場合はこの段階を飛ばしてください。 | 先ほどインストールしたテーマは複数のデータベースのバックアップを含んでいます。バックアップのファイルを選択してテーマのデータをインポートするか、空のContaoのインストールから始める場合はこの段階を飛ばしてください。","ui.setup.database-connection.backup":"インポート前に現在のデータベースをバックアップ","ui.setup.database-connection.backupWarning":"データベースのすべてのデータを上書きします。データベースが空でない場合は最初にバックアップを作成してください。","ui.setup.database-connection.restore":"テーマのデータベースをインポート","ui.setup.database-connection.restoreOption":"{date} ({size})からバックアップ","ui.setup.database-connection.restored":"テーマのデータベースのインポートに成功しました。データベースのスキーマの検証に進んでください。","ui.setup.backend-user.success":"データベースにContaoのバックエンドの管理者のアカウントがあります。さらにユーザーを追加するにはContaoのバックエンドを使用してください。","ui.setup.backend-user.error":"ユーザーのリストを取り出せません。詳細はコンソールの出力を確認してください。","ui.setup.backend-user.headline":"バックエンドのアカウント","ui.setup.backend-user.description":"ウェブサイトを管理するには、少なくともContaoのバックエンドの管理者のアカウントが1つ必要です。このアカウントはContao Managerと無関係なことに注意してください。","ui.setup.backend-user.formTitle":"アカウントを作成","ui.setup.backend-user.formText":"新しいバックエンドのアカウントの詳細を入力してください。","ui.setup.backend-user.username":"ユーザー名","ui.setup.backend-user.name":"名前","ui.setup.backend-user.email":"電子メールアドレス","ui.setup.backend-user.emailInvalid":"有効な電子メールアドレスを入力してください。","ui.setup.backend-user.password":"パスワード","ui.setup.backend-user.passwordPlaceholder":"最小で8文字","ui.setup.backend-user.passwordLength":"少なくとも8文字を入力してください。","ui.setup.backend-user.create":"アカウントを追加","ui.task.headline":"バックグランドのタスク","ui.task.loading":"詳細を読み込み中...","ui.task.created":"詳細を読み込み中...","ui.task.active":"Contao Managerがバックグラウンドでタスクの処理を実行を開始するまで、しばらくお待ちください。","ui.task.complete":"すべての処理を正常に完了しました。詳細はコンソールの出力を確認してください。","ui.task.paused":"バックグラウンドの処理が予期せず停止しました。コンソールの出力を確認してください。","ui.task.aborting":"バックグラウンドの処理を取り消すまで、しばらくお待ちください。","ui.task.stopped":"バックグラウンドの処理の一部を取り消しました。コンソールの出力を確認してください。","ui.task.error":"バックグラウンドの処理が予期せず停止しました。コンソールの出力を確認してください。","ui.task.failed":"Contao Managerはバックグラウンドのタスクを開始できませんでした!","ui.task.failedDescription1":"バックグラウンドで処理を実行しようとするときに何か問題がありました。","ui.task.failedDescription2":"これが再度起きる場合は、サーバーはサポートされていないかもしれません。","ui.task.reportProblem":"問題を報告","ui.task.pausedDescription":"エラーを無視して残る作業を実行したい場合は「続ける」をクリックしてください。","ui.task.sponsor":"{sponsor}が後援のComposer Cloud","ui.task.buttonAudit":"データベースを更新","ui.task.buttonClose":"閉じる","ui.task.buttonConfirm":"確認して閉じる","ui.task.buttonContinue":"続ける","ui.task.buttonCancel":"取り止め","ui.task.confirmCancel":"このタスクを本当に取り止めて良いですか?  取り止めるとContaoのインストールを壊れた状態のままにするかもしれません。","ui.task.autoclose":"正常に終了したときにタスクの詳細を閉じる","ui.console.toggle":"コンソールの出力を表示・非表示","ui.console.showLog":"完全なコンソールのログを表示","ui.console.copyLog":"ログをクリップボードにコピー","ui.migrate.headline":"データベースの更新","ui.migrate.migrationsOnly":"(移行だけ)","ui.migrate.schemaOnly":"(スキーマだけ)","ui.migrate.loading":"しばらくお待ちください、データベースを検査中です...","ui.migrate.empty":"未解決な移行やスキーマの更新はありません。データベースは最新です。","ui.migrate.emptyMigrations":"未解決な移行はありません。スキーマの更新も忘れずにしてください。","ui.migrate.emptySchema":"未解決なスキーマの更新はありません。移行の確認も忘れずにしてください。","ui.migrate.pending":"データベースが最新ではありません。以下のコンソール出力を再確認して変更を実行してください。","ui.migrate.previousChanges":"以前のデータベース移行を確認できませんでした。\\n以下のコンソール出力を再確認して、次の変更の確認に進んでください。","ui.migrate.previousComplete":"以前のデータベース移行を確認できませんでしたので、以下のコンソール出力を再確認してください。\\nこれ以上の未解決な変更はありません。","ui.migrate.appliedChanges":"データベースの更新を適用しました。\\n以下のコンソール出力を再確認して、次の変更の確認に進んでください。","ui.migrate.appliedComplete":"データベースの更新を適用しました。\\n未確認の移行やスキーマの更新はありません。データベースは最新の状態です。","ui.migrate.problem":"Contaoはデータベースサーバーの問題を検出しました。\\n下のコンソール出力を再確認して修正しなければならない事項を調査してください!","ui.migrate.warning":"Contaoはデータベースサーバーの誤った設定を検出しました。\\n一時的に警告は無視できますが、最適な性能とデータの一貫性のためには修正しなければなりません。","ui.migrate.error":"変更を適用できませんでした。データベースは変更されているかもしれません、再確認して再実行してください。","ui.migrate.execute":"実行","ui.migrate.close":"閉じる","ui.migrate.confirm":"確認して閉じる","ui.migrate.cancel":"取り止め","ui.migrate.continue":"続ける","ui.migrate.setup":"セットアップ","ui.migrate.skip":"飛ばす","ui.migrate.retry":"再検査","ui.migrate.retryAll":"すべて検査","ui.migrate.withDeletes":"DROPの処理を含む、すべてのデータベースの変更を実行します。","ui.migrate.migrationTitle":"データベースの移行","ui.migrate.schemaTitle":"スキーマの更新","ui.migrate.problemTitle":"データベースの問題","ui.migrate.warningTitle":"データベースの警告","ui.migrate.addTable":"テーブルを追加","ui.migrate.dropTable":"テーブルを削除","ui.migrate.addField":"項目{table}.{field}を追加","ui.migrate.changeField":"項目{table}.{field}を変更","ui.migrate.dropField":"項目{table}.{field}を削除","ui.migrate.createIndex":"{table}にインデックス\\"{name}\\"を作成","ui.migrate.dropIndex":"{table}のインデックス\\"{name}\\"を削除","ui.widget.mandatory":"この欄の入力は必須です。","ui.widget.blankOption":"選択してください…","ui.widget.showPassword":"パスワードを表示","ui.widget.hidePassword":"パスワードを非表示","ui.error.title":"\\"{method} {url}\\"というHTTPの要求に失敗しました。","ui.error.server500":"予期しないエラーがサーバーで発生したようです。Webサーバー(Apache/Nginx)のログファイルと、Contao Managerの\\"contao-manager/logs\\"へのログを確認してください。","ui.error.response":"サーバーは{status}という応答コードを返しました。","ui.error.moreLink":"詳細な情報","ui.error.support":"Contaoサポート","ui.error.permission":"この機能を使用する権限がありません。","ui.footer.help":"ヘルプ","ui.footer.reportProblem":"問題を報告","ui.navigation.discover":"発見","ui.navigation.packages":"パッケージ","ui.navigation.tools":"ツール","ui.navigation.installTool":"インストールツール","ui.navigation.backend":"Contaoのバックエンド","ui.navigation.debug":"Contaoのデバッグモード","ui.navigation.logViewer":"ログ表示","ui.navigation.phpinfo":"PHPの情報","ui.navigation.phpinfoLoading":"PHPの情報を読み込み中...","ui.navigation.maintenance":"保守","ui.navigation.rebuildCache":"キャッシュを再作成","ui.navigation.users":"アカウント","ui.navigation.systemCheck":"システム検査","ui.navigation.advanced":"詳細","ui.navigation.logout":"ログアウト","ui.maintenance.database.title":"データベースの移行とバックアップ","ui.maintenance.database.description":"データベースの移行はデータとテーブルのスキーマの一貫性を確保します。","ui.maintenance.database.migrations":"未解決のデータベース移行が1件 | 未解決のデータベース移行が{count}件","ui.maintenance.database.schemaUpdates":"未解決のスキーマの更新が1件 | 未解決のスキーマの更新が{count}件","ui.maintenance.database.error":"データベースの問題が見つかりました。","ui.maintenance.database.warning":"データベースの警告が見つかりました。","ui.maintenance.database.button":"データベースを検査","ui.maintenance.database.migrationOnly":"移行だけを検査","ui.maintenance.database.schemaOnly":"スキーマだけを検査","ui.maintenance.database.installTool":"インストールツールを開く","ui.maintenance.database.createBackup":"バックアップを作成","ui.maintenance.database.backupUnsupported":"このContaoのバージョンではデータベースのバックアップをサポートしていません。","ui.maintenance.database.backupList":"データベースのバックアップが1個あって、{date}に作成されています。 | データベースのバックアップが{count}個あって、最新のものは{date}に作成されています。","ui.maintenance.database.backupEmpty":"現在データベースのバックアップはありません。","ui.maintenance.rebuildCache.title":"アプリケーションキャッシュ","ui.maintenance.rebuildCache.description":"構成ファイルのいずれかを修正した後はアプリケーションキャッシュの再構築が必要です。","ui.maintenance.rebuildCache.rebuildProd":"実稼働用のキャッシュを再構築","ui.maintenance.rebuildCache.rebuildDev":"開発用のキャッシュを再構築","ui.maintenance.rebuildCache.clearProd":"実稼働用のキャッシュを消去","ui.maintenance.rebuildCache.clearDev":"開発用のキャッシュを消去","ui.maintenance.installTool.title":"Contaoインストールツール","ui.maintenance.installTool.description":"連続して3回誤ったパスワードを入力すると、Contaoのインストールツールは自動的にロック状態となります。","ui.maintenance.installTool.unlock":"インストールツールのロックを解除","ui.maintenance.installTool.lock":"インストールツールをロック","ui.maintenance.dumpAutoload.title":"Composerクラスローダー","ui.maintenance.dumpAutoload.description":"ComposerのオートローダーがPHPのクラスの読み込み担当します。rootのcomposer.jsonに独自のネームスペースを追加した後は、オートローダーを書き出さなければなりません。","ui.maintenance.dumpAutoload.button":"オートローダーを書き出し","ui.maintenance.composerInstall.title":"Composerの依存関係","ui.maintenance.composerInstall.description":"Composerの依存関係はアプリケーションのルートの{vendor}フォルダーに配置されています。{composerLock}ファイルを操作や手動でアップロードした後は依存関係の再インストールが必要な場合があります。","ui.maintenance.composerInstall.button":"インストーラーを実行","ui.maintenance.composerInstall.update":"Composerで更新を実行","ui.maintenance.composerCache.title":"Composerキャッシュ","ui.maintenance.composerCache.description":"Composerは性能向上のためにダウンロードしたパッケージをキャッシュします。壊れたファイルのような問題がある場合は、Composerキャッシュを削除して強制的に新しいダウンロードを行ってみてください。","ui.maintenance.composerCache.button":"キャッシュを消去","ui.maintenance.maintenanceMode.title":"保守モード","ui.maintenance.maintenanceMode.description":"Contaoを保守モードにするとウェブサイトでは\\"503 Service Unavailable\\"のテンプレートを表示します。","ui.maintenance.maintenanceMode.enable":"有効","ui.maintenance.maintenanceMode.disable":"無効","ui.maintenance.debugMode.title":"デバッグモード","ui.maintenance.debugMode.description":"{appDevPhp}のエントリーポイントにユーザーとパスワードを設定してデバッグモードを有効にします。","ui.maintenance.debugMode.descriptionJwt":"現在のドメインにデバッグ用のクッキーを設定してデバッグモードを有効にします。","ui.maintenance.debugMode.activate":"有効化","ui.maintenance.debugMode.deactivate":"無効化","ui.maintenance.debugMode.credentials":"認証情報","ui.maintenance.debugMode.user":"デバッグモードのユーザー名を入力してください。","ui.maintenance.debugMode.password":"デバッグモードのパスワードを入力してください。","ui.maintenance.opcodeCache.title":"Opcodeキャッシュ","ui.maintenance.opcodeCache.description":"Opcodeは高速な実行のためにPHPのファイルをウェブプロセス常にキャッシュします。変更後にファイルの変化を認識していないといった、特定の状況では削除しなければなりません。","ui.maintenance.opcodeCache.button":"キャッシュを切り詰め","ui.maintenance.safeMode":"セーフモードでは利用不可","ui.maintenance.unsupported":"このContaoのバージョンでは非サポート","ui.packages.updateButton":"パッケージを更新","ui.packages.searchButton":"パッケージを検索","ui.packages.searchPlaceholder":"パッケージを検索中…","ui.packages.uploadOverlay":"アップロードするファイルをドラッグアンドドロップ","ui.packages.uploadButton":"パッケージをアップロード","ui.packages.uploadMessage":"未確認の1個のアップロードがあります。 | 未確認の{count}個のアップロードがあります。","ui.packages.uploadApply":"アップロードを実行","ui.packages.uploadReset":"アップロードを削除","ui.packages.uploadIncomplete":"このファイルは完全にアップロードできていません。一旦削除削除してもう一度アップロードしてください。","ui.packages.uploadDuplicate":"このファイルを複数回アップロードした様です。重複しているファイルを削除してください。","ui.packages.uploadInstalled":"このファイルを既にインストールしています。重複しているファイルを削除してください。","ui.packages.uploadUnsupported":"インストールしたContaoはアップロードをサポートしていません。PHPのzip拡張のインストールと依存関係の更新を確認してください。","ui.packages.changesMessage":"未確認の1個の変更があります。 | 未確認の{count}個の変更があります。","ui.packages.changesDryrun":"変更を試行","ui.packages.changesApply":"変更を適用","ui.packages.changesApplyAll":"すべてのパッケージを更新","ui.packages.changesDryrunAll":"すべてのパッケージの変更を試行","ui.packages.changesReset":"変更をリセット","ui.packages.changesReview":"変更を見直し","ui.packagelist.loading":"読み込み中...","ui.packagelist.uploads":"アップロード","ui.packagelist.added":"新しいパッケージ","ui.packagelist.installed":"インストール済みのパッケージ","ui.package.hintRevert":"変更を取り消す","ui.package.hintNoupdate":"更新しない","ui.package.hintConstraint":"この変更を適用すると、このパッケージを{constraint}の制約によりインストールします。","ui.package.hintConstraintBest":"変更を適用すると、このパッケージの利用できる一番良いバージョンをインストールします。","ui.package.hintConstraintChange":"変更を適用すると、このパッケージへの制約は\\"{from}\\"から\\"{to}\\"に変更します。","ui.package.hintConstraintUpdate":"変更を適用すると、このパッケージを更新します。","ui.package.hintAdded":"変更を適用すると、このパッケージをインストールします。","ui.package.hintRemoved":"変更を適用すると、このパッケージを削除します。","ui.package.requiredTitle":"手作業で追加済み","ui.package.requiredText":"このパッケージはcomposer.jsonで必要としていますが、インストールされていません。","ui.package.removedTitle":"手作業で削除済み","ui.package.removedText":"このパッケージはcomposer.jsonから削除されています。","ui.package.installed":"インストール済み:","ui.package.version":"バージョン{version}","ui.package.additionalDownloads":"{count}個のダウンロード | {count}個のダウンロード","ui.package.additionalStars":"{count}のスター | {count}のスター","ui.package.editConstraint":"編集","ui.package.uploadConstraint":"この定数はアップロードしたパッケージで定義されています。","ui.package.updateButton":"更新","ui.package.removeButton":"削除","ui.package.installButton":"パッケージを追加","ui.package.installButtonShort":"追加","ui.package.detailsButton":"詳細","ui.package.latestConstraint":"最新のバージョン","ui.package.update":"更新を利用可能","ui.package.updateLatest":"最新のバージョン","ui.package.updateAvailable":"バージョン{version}を利用可能","ui.package.updateUnknown":"不明なバージョン","ui.package.updateConstraint":"バージョンの制約外に利用できる新しいバージョンがあります。","ui.package.incompatible":"{package}はContao {constraint}では動作しません。","ui.cloudStatus.headline":"Composerリゾルバークラウド","ui.cloudStatus.version":"バージョン{version}","ui.cloudStatus.waitingTime":"待ち時間","ui.cloudStatus.jobs":"現在のジョブ","ui.cloudStatus.workers":"ワーカー","ui.cloudStatus.approx":"{minutes}分","ui.cloudStatus.none":"なし","ui.cloudStatus.short":"ca. {minutes}分","ui.cloudStatus.long":"ca. {minutes}分{seconds}秒","ui.cloudStatus.error":"Composerリゾルバークラウドの状態を取得できません。保守または技術的な問題のため停止しているかもしれません。","ui.cloudStatus.button":"クラウドの状態","ui.cloudStatus.refresh":"クラウドの状態を更新","ui.log-viewer.loading":"読み込み中...","ui.log-viewer.empty":"サーバーにログファイルはありません。","ui.log-viewer.reload":"際読み込み","ui.log-viewer.file":"ログファイル","ui.log-viewer.channel":"チャネル","ui.log-viewer.channelTitle":"このメッセージを記録する先のチャネルです。","ui.log-viewer.level":"レベル","ui.log-viewer.levelTitle":"ログメッセージの深刻さです。","ui.log-viewer.timeHeader":"時刻","ui.log-viewer.messageHeader":"メッセージ","ui.log-viewer.showContext":"コンテキストを表示","ui.log-viewer.hideContext":"コンテキストを非表示","ui.log-viewer.showExtra":"追加を表示","ui.log-viewer.hideExtra":"追加を非表示","ui.log-viewer.more":" さらに読み込む...","ui.log-viewer.download":"ダウンロード","ui.log-viewer.downloadTitle":"\\"{file}\\"をダウンロード","ui.log-viewer.prodEnvironment":"実運用環境","ui.log-viewer.devEnvironment":"開発環境(デバッグモード)","ui.user-manager.loading":"ユーザーを読み込み中...","ui.user-manager.changePassword":"パスワードを変更","ui.user-manager.setupTotp":"2ファクター認証を設定","ui.user-manager.disableTotp":"2ファクター認証を無効","ui.user-manager.invite":"ユーザーを招待","ui.user-manager.delete":"削除","ui.user-manager.deleteConfirm":"ほんとうにユーザー: \\"{username}\\"を削除しますか?","ui.user-manager.deleted":"ユーザー: {username}を削除しました。","ui.user-manager.passwordHeadline":"パスワードを変更","ui.user-manager.passwordText":"パスワードを変更するには、現在のパスワードと新しいパスワードをそれぞれの欄に入力してください。","ui.user-manager.currentPassword":"現在のパスワード","ui.user-manager.newPassword":"新しいパスワード","ui.user-manager.passwordPlaceholder":"最小で8文字","ui.user-manager.submitPassword":"送信","ui.user-manager.passwordChanged":"パスワードを変更しました。","ui.user-manager.passwordError":"このパスワードは間違っています。","ui.user-manager.inviteHeadline":"ユーザーを招待","ui.user-manager.inviteText":"Contao Managerに複数のログイン情報が必要な場合、ここで招待のリンクを作成できます。このリンクを誰か、または他の機器で使用して、指定した権限の新しいアカウントを作成してください。","ui.user-manager.inviteSuccess1":"新しい招待のリンクを作成しました。以下のURLを使用して、このContao Managerの新しいユーザーを作成できます。この招待は(今から1週間後の){expires}に期限が切れます。","ui.user-manager.inviteSuccess2":"リンクをクリップボードにコピーしてください。一度だけ動作し、このダイアログを閉じた後に再び見ることはできません。","ui.user-manager.createInvitation":"招待のリンクを作成","ui.user-manager.clipboard":"クリップボードにコピー","ui.user-manager.permissions":"権限について学ぶ","ui.user-manager.cancel":"取り止め","ui.user-manager.close":"閉じる","ui.user-manager.you":"あなた","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"このアカウントは2ファクター認証により安全です。","ui.user-manager.2faDisabled":"このアカウントはに2ファクター認証が設定されていないため安全ではありません。","ui.user-manager.passkey":"パスキー","ui.user-manager.passkeyTitle":"このアカウントはパスキーにより安全です。","ui.totp.headline":"2ファクター認証","ui.totp.setupQr":"2FA/TOTPアプリでQRコードを読み取ってください。","ui.totp.setupCode":"QRコードを読み取れない場合は、このキーを代わりに入力してください: ","ui.totp.codeLabel":"確認コード","ui.totp.codeDescription":"2FA/TOTPアプリが生成した確認コードを入力してください。","ui.totp.disableText":"2ファクター認証を無効にするには確認コードを入力してください。","ui.totp.invalid":"確認コードが無効です。","ui.totp.enable":"有効","ui.totp.disable":"無効","ui.totp.cancel":"取り止め","ui.totp.enabled":"2ファクター認証を有効にしました。","ui.totp.disabled":"2ファクター認証を無効にしました。","ui.totp.setup":"2ファクター認証を設定","ui.totp.skip":"2ファクター認証を飛ばす"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[554],{4554:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Connexion non sécurisée !!","ui.app.httpsDescription":"Sans HTTPS, vos données confidentielles seront transférées non chiffrées.","ui.app.httpsLink":"Plus d\'information","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Safe Mode enabled !!","ui.app.safeModeDescription":"Some features of the Contao Manager are not available.","ui.app.safeModeExit":"Exit Safe Mode","ui.app.limitedHeadline":"Remote Authentication","ui.app.limitedDescription":"You have limited permissions due to passwordless login.","ui.app.limitedLogout":"Re-authenticate","ui.app.totpHeadline":"Security Notice","ui.app.totpDescription":"Configure two-factor authentication now to secure your account.","ui.app.totpSetup":"Configuration","ui.app.loading":"Chargement de Contao Manager …","ui.app.apiError":"Statut de l\'API inattendu","ui.app.configSecurity1":"ALERTE DE SÉCURITÉ !!! Répertoire de configuration non protégé détecté","ui.app.configSecurity2":"Contao Manager a détecté que ses fichiers de configuration sont accessibles au public. Toutes les opérations sont désactivées jusqu\'à ce que le répertoire soit sécurisé, sinon une personne malintentionnée pourrait accéder aux données sensibles de votre installation.\\n\\nPour résoudre ce problème, assurez-vous d\'empêcher l\'accès au répertoire \\"contao-manager\\" sur votre serveur. Pour savoir comment faire cela, référez-vous au manuel de votre serveur Web ou contactez votre fournisseur d\'hébergement.","ui.account.welcome":"Bienvenue","ui.account.intro1":"Bienvenue dans Contao Manager, un outil universel pour installer et gérer Contao Open Source CMS. Si vous êtes nouveau dans ce domaine, veuillez {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} pour commencer","ui.account.introManual":"lire le manuel","ui.account.intro2":"Si vous rencontrez des problèmes, vérifiez {ourGithubIssues} et n\'hésitez pas à créer un nouveau rapport de bug pour tout ce qui n\'a pas encore été signalé.","ui.account.introIssues":"nos problèmes GitHub","ui.account.headline":"Compte d\'utilisateur","ui.account.description":"Pour gérer votre installation, veuillez créer un compte Contao Manager. Sachez que ce compte n\'est pas lié au back office ou front office de Contao.","ui.account.username":"Nom d\'utilisateur","ui.account.password":"Mot de passe","ui.account.passwordPlaceholder":"Min. 8 caractères","ui.account.passwordLength":"Veuillez insérer au moins 8 caractères.","ui.account.loginInvalid":"There was an error when creating the account. Please try a different username.","ui.account.submit":"Créer un compte","ui.account.usePassword":"Use password for login","ui.account.usePasskey":"Use Passkey for login","ui.account.totpHeadline":"Two-factor authentication","ui.account.totpDescription":"Please enable two-factor authentication, which adds an extra layer of security to your account. In addition to your username and password, you will need to enter a verification code generated by a two-factor app such as 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator or any other TOTP app.","ui.account.totpSetup":"Configure now","ui.account.totpSkip":"Configure later","ui.account.login":"Decline Invitation","ui.account.contribute1":"Contao et le Contao Manager sont parrainés par l\'association à but non lucratif Contao.","ui.account.contribute2":"Please consider contributing to open source by {donate}.","ui.account.contributeDonate":"making a donation","ui.login.headline":"Se connecter","ui.login.description":"Connectez-vous afin de gérer votre installation.","ui.login.username":"Nom d\'utilisateur","ui.login.password":"Mot de passe","ui.login.totpHeadline":"Two-factor authentication","ui.login.totpDescription":"Please enter your verification code to complete the login process.","ui.login.totp":"Verification code","ui.login.forgotPassword":"Mot de passe oublié ?","ui.login.button":"Se connecter","ui.login.passkey":"Sign In with Passkey","ui.login.cancel":"Annuler","ui.login.or":"or","ui.login.locked":"Access has been denied because the Contao Manager is locked. To unlock, delete the {lockFile} file in your Contao root directory.","ui.logout.headline":"Timeout session","ui.logout.warning":"Vous êtes inactif depuis plus de 25 minutes. Pour des raisons de sécurité, votre session va se terminera sous peu.","ui.logout.expired":"votre session a été automatiquement interrompue car vous êtes resté inactif pendant plus de 30 minutes.","ui.logout.renew":"Restez connecté","ui.logout.logout":"Se déconnecter","ui.logout.login":"Retour à la page de connexion","ui.oauth.error":"Tentative de connexion OAuth invalide. Contrôlez le paramètre de la requête.","ui.oauth.https":"The redirect URI MUST use a secure protocol (https:) to prevent the authentication token from being transmitted in clear-text.","ui.oauth.headline":"Remote Authentication","ui.oauth.description":"L\'application ou le service suivant demande un accès à distance de votre instance Contao Manager.","ui.oauth.domain":"Before allowing access, make sure you know this URL and trust its owner!","ui.oauth.outOfScope":"Unfortunately, you do not have the necessary permissions to grant this access.","ui.oauth.allow":"Permettre l\'accès","ui.oauth.deny":"Refuser l\'accès","ui.oauth.switchUser":"Switch User","ui.scope.admin":"Admin access including user management","ui.scope.install":"Install new packages and change Contao configuration","ui.scope.update":"Update packages and execute maintenance tasks","ui.scope.read":"Read packages and configuration","ui.boot.headline":"Vérification du système","ui.boot.description":"Veuillez patienter, nous analysons votre serveur…","ui.boot.issue1":"Problèmes d\'installation détectés","ui.boot.issue2":"Votre installation présente des problèmes qui doivent être résolus avant que Contao Manager puisse être utilisé.","ui.boot.run":"Lancez Contao Manager","ui.boot.safeMode":"Lancer en mode sans échec","ui.recovery.headline":"Récupération du système","ui.recovery.description":"Le Contao Manager a détecté des fichiers qui ressemblent à Contao, mais l\'interface de ligne de commande ne fonctionne pas comme prévu.","ui.recovery.console":"Console Output","ui.recovery.repairOptions":"Veuillez choisir une option pour réparer votre installation.","ui.recovery.repairHeadline":"Réparation automatique","ui.recovery.repairDescription":"Essaye de réparer automatiquement l\'installation en reconstruisant le cache de l\'application et en réinstallant les packages Composer.","ui.recovery.repairWarning":"Toutes les modifications apportées aux fichiers présents dans le dossier Vendor peuvent être supprimées au cours du processus!","ui.recovery.repairFailed":"La réparation automatique a échoué. Essayez le mode sans échec pour réparer manuellement l\'installation.","ui.recovery.repairButton":"Lancer la réparation","ui.recovery.safeModeHeadline":"Mode sans échec","ui.recovery.safeModeDescription":"Lancer le Contao Manager en mode sans échec permet de gérer les packages et d\'exécuter certaines tâches de maintenance, mais les fonctionnalités qui reposent sur une installation fonctionnelle de Contao ne seront pas disponibles.","ui.recovery.safeModeButton":"Lancer en mode sans échec","ui.server.pending":"En attente…","ui.server.running":"En cours d\'analyse…","ui.server.error":"La vérification a échoué en raison d\'une réponse inattendue du serveur.","ui.server.details":"Détails","ui.server.prerequisite":"Vérification annulée en raison d\'un prérequis manquant","ui.server.selfUpdate.title":"Mises à jour de Contao Manager","ui.server.selfUpdate.update":"Une nouvelle version de Contao Manager ({latest}) est disponible.","ui.server.selfUpdate.manualUpdate":"Une nouvelle version {latest} de Contao Manager est disponible. Votre serveur ne prend pas en charge les mises à jour automatiques, veuillez télécharger la nouvelle version à partir de {download}.","ui.server.selfUpdate.latest":"Vous utilisez la dernière version {current}.","ui.server.selfUpdate.dev":"Les versions de développement ne supportent pas les mises à jour automatiques.","ui.server.selfUpdate.unsupported":"Une nouvelle version est disponible mais elle ne supporte pas votre version de PHP.","ui.server.selfUpdate.button":"Lancer la mise à jour","ui.server.selfUpdate.continue":"Continuer","ui.server.config.title":"Configuration du serveur","ui.server.config.setup":"Configurer","ui.server.config.change":"Modifier","ui.server.config.save":"Sauvegarder","ui.server.config.cancel":"Annuler","ui.server.config.customOption":"Autre… ","ui.server.config.description":"Pour exécuter correctement les opérations en tâche de fond, Contao Manager doit savoir où trouver le binaire de PHP en ligne de commande (CLI) et comment exécuter des commandes séparées du processus Web.","ui.server.config.formTitle":"Configuration du serveur","ui.server.config.formText":"Merci de saisir le chemin vers le binaire PHP. La version du binaire PHP doit être la même que pour le processus web.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud permet d\'installer des dépendances Composer même si votre serveur ne fournit pas suffisamment de mémoire. Veuillez noter que les informations relatives à votre package seront transmises à un serveur cloud géré par l\'Association Contao.","ui.server.config.cloud":"Utilisé le Composer Resolver Cloud","ui.server.config.cli":"Binaire PHP","ui.server.config.stateErrorCli":"Aucun binaire PHP valide n\'a été trouvé sur le serveur.","ui.server.config.stateErrorCloud":"Le Composer Resolver Cloud n\'est pas pris en charge.","ui.server.config.stateSuccess":"Binaire PHP à {php_cli}.","ui.server.php_web.title":"Processus web de PHP","ui.server.php_web.below7":"La version {version} de PHP a été trouvée. Passez s\'il vous plaît à PHP 7 dès que possible.","ui.server.php_web.success":"Version PHP {version} trouvée, aucun problème connu trouvé.","ui.server.php_cli.title":"PHP en ligne de commande (CLI)","ui.server.php_cli.success":"Version PHP {version} trouvée, aucun problème connu trouvé.","ui.server.composer.title":"Environnement Composer","ui.server.composer.success":"Aucun problème connu trouvé.","ui.server.composer.install":"Les dépendances de Composer ne sont pas installées.","ui.server.composer.button":"Install","ui.server.contao.title":"Installation de Contao","ui.server.contao.setup":"Configuration","ui.server.contao.check":"Vérifier la base de données.","ui.server.contao.empty":"Aucune installation de Contao n\'a été trouvée.","ui.server.contao.old":"La version {version} de Contao n\'est pas compatible avec Contao Manager, veuillez mettre à jour manuellement votre installation.","ui.server.contao.found":"Contao {version} a été détecté (version API {api}).","ui.server.contao.connectionError":"Impossible de se connecter au serveur de base de données","ui.server.contao.connectionProblem":"La base de données a un problème.","ui.server.contao.missingUser":"Admin account not found.","ui.setup.continue":"Continuer","ui.setup.manager":"Lancez Contao Manager","ui.setup.cancel":"Annuler","ui.setup.welcome":"Bienvenue","ui.setup.welcome1":"This wizard will take you through the necessary steps to set up your Contao Open Source CMS installation.","ui.setup.welcome2":"If you have any questions, please find documentation, forums, a Slack channel and more on the {support} page.","ui.setup.support":"community support","ui.setup.start":"Get started","ui.setup.complete":"Congratulations!","ui.setup.complete1":"Contao {version} has been installed successfully.","ui.setup.complete2":"Pour terminer l\'installation, vous devez ouvrir  l\'Outil d\'installation pour configurer la connexion à la base de données et créer un utilisateur back end.","ui.setup.complete3":"You can now start to create your website in the Contao back end. If you need additional extensions, continue to the Contao Manager.","ui.setup.installTool":"Open the Install Tool","ui.setup.login":"Login to Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Learn more","ui.setup.document-root.headline":"Configuration du serveur web","ui.setup.document-root.warning":"Pour installer Contao via Contao Manager, vous devez définir la racine du site sur le serveur web.","ui.setup.document-root.description1":"Contao uses a separate folder for public files, application files are installed in its parent folder. Contao cannot be installed if the folder structure is not correct or the folders are not empty.","ui.setup.document-root.description2":"Si vous ne savez pas comment configurer la racine de votre site, veuillez lire la documentation Contao ou contacter votre hébergeur.","ui.setup.document-root.documentation":"Lire la Documentation","ui.setup.document-root.conflictsTitle":"Installation directory not empty","ui.setup.document-root.conflictsDirectory":"The root directory of your future Contao installation is not empty, we have found {count} file(s) that might be overwritten by the installation process. It is recommended to create an empty directory structure for Contao, but you can also remove the following files and check again if you are sure they are unused.","ui.setup.document-root.ignoreConflicts":"I want to install Contao into the non-empty directory. I understand that this might overwrite any existing files on my webspace.","ui.setup.document-root.check":"Check again","ui.setup.document-root.create":"Create directories","ui.setup.document-root.change":"Change directories","ui.setup.document-root.formTitle":"Configuration des répertoires","ui.setup.document-root.formText1":"Le Contao-manager peut créer automatiquement une nouvelle structure de répertoires sur le serveur.","ui.setup.document-root.formText2":"Vous devrez configurer manuellement la nouvelle racine du site (par exemple via un panneau d\'administration d\'hébergement).","ui.setup.document-root.autoconfig":"Je comprends que je dois modifier la configuration de mon serveur. Ne pas configurer la racine du site bloquera le Contao Manager et exposera les fichiers de configuration (y compris les détails du compte et les mots de passe)!","ui.setup.document-root.directory":"Nouveau répertoire","ui.setup.document-root.currentRoot":"Racine du site actuel","ui.setup.document-root.newRoot":"Nouvelle racine du site","ui.setup.document-root.finish":"Répertoires créés","ui.setup.document-root.publicDir":"Use {dir} for public files (for Contao {version})","ui.setup.document-root.directoryInvalid":"Veuillez saisir un nom de répertoire valide.","ui.setup.document-root.directoryExists":"Le répertoire cible existe déjà. Veuillez saisir un autre nom.","ui.setup.document-root.confirmation":"Le Contao Manager a créé avec succès les répertoires nécessaires pour votre installation Contao. Vous devez maintenant configurer la racine du site sur votre serveur web. Ne rechargez pas cette page jusque-là.","ui.setup.document-root.reload":"Recharger la page","ui.setup.document-root.success":"The directory structure on your web server is set up correctly!","ui.setup.document-root.installingProjectDir":"Application files will be installed to {dir}.","ui.setup.document-root.installingPublicDir":"Public files will be installed to {dir}.","ui.setup.document-root.installedProjectDir":"Application files are installed in {dir}.","ui.setup.document-root.installedPublicDir":"Public files are installed in {dir}.","ui.setup.create-project.headline":"Installation de Contao","ui.setup.create-project.description":"Contao development follows the principle of {semver}, a new minor version is released every six months. The currently supported releases are:","ui.setup.create-project.semver":"Semantic Versioning","ui.setup.create-project.latestTitle":"Dernière version","ui.setup.create-project.ltsTitle":"Long Term Support (LTS)","ui.setup.create-project.latestQ1":"Our latest version, offers the most features with support until February {year}.","ui.setup.create-project.latestQ3":"Our latest version, offers the most features with support until August {year}.","ui.setup.create-project.ltsText":"Our current LTS version, if you focus on stability. Offers long term support until February {year}.","ui.setup.create-project.pltsText":"The previous LTS version, still has long term support until February {year}.","ui.setup.create-project.requiresPHP":"Requires at least PHP {version}, you have PHP {current}.","ui.setup.create-project.releaseplan":"Consultez le {contaoReleasePlan} pour obtenir des informations détaillées","ui.setup.create-project.releaseplanLink":"Plan de publication","ui.setup.create-project.installed":"Contao {version} is successfully installed on the server. Continue to set up your database or launch the Contao Manager to install a different version.","ui.setup.create-project.formTitle":"Select a distribution","ui.setup.create-project.formText":"Please choose which version should be installed.","ui.setup.create-project.version":"Version","ui.setup.create-project.demo":"Install the Contao demo website","ui.setup.create-project.demoDescription":"The demo website helps you to get familiar with Contao and all of its core features. More themes can be found in the {store}.","ui.setup.create-project.coreOnly":"Installation de base (Core seulement)","ui.setup.create-project.noUpdate":"Ignorer l\'installation (réservé aux experts !)","ui.setup.create-project.theme":"Contao Theme","ui.setup.create-project.themeInstall":"To install a Contao theme, use the search input or upload a theme file (.cto/.zip) that supports installation through the Contao Manager.","ui.setup.create-project.themeBuy":"Make sure to visit the official {store}.","ui.setup.create-project.themeStore":"Contao Themes Store","ui.setup.create-project.themeUpload":"Upload theme file (.cto/.zip)","ui.setup.create-project.themeInvalid":"The uploaded file is not a Contao theme or does not support the Contao Manager.","ui.setup.create-project.themeWarning":"The Contao Manager cannot tell whether this theme is compatible with your server. Please check with the theme vendor if you have any questions.","ui.setup.create-project.themeTitle":"Review theme details","ui.setup.create-project.themeDetails":"The following dependencies and files will be installed with this theme.","ui.setup.create-project.themeRequire":"{count} Dependencies | {count} Dependencies","ui.setup.create-project.themeFiles":"{count} File | {count} Files","ui.setup.create-project.theme.or":"or search public themes","ui.setup.create-project.theme.search":"Search themes","ui.setup.create-project.theme.more":"More themes","ui.setup.create-project.theme.empty":"No themes matching {query}","ui.setup.create-project.theme.uploaded":"The theme file was uploaded successfully.","ui.setup.create-project.theme.packageName":"Package name","ui.setup.create-project.theme.version":"Version","ui.setup.create-project.theme.authors":"Author(s)","ui.setup.create-project.theme.upload":"Uploading {name} ({size})","ui.setup.create-project.install":"Install","ui.setup.create-project.cancel":"Annuler","ui.setup.create-project.fileError":"Could not find composer.json in {file}.","ui.setup.create-project.jsonError":"composer.json contains invalid JSON.","ui.setup.create-project.schemaError":"composer.json schema validation failed.","ui.setup.database-connection.headline":"Connexion à la base de données;","ui.setup.database-connection.description":"Contao nécessite une base de données MySQL (ou un équivalent comme MariaDB) pour stocker les pages, les contenus, les utilisateurs et les données relationnelles. Les paramètres de connexion sont stockés le fichier (env) à la racine de votre installation Contao. ","ui.setup.database-connection.formTitle":"Connection Parameters","ui.setup.database-connection.formText":"Entrez l\'URL d\'une base de données ou saisissez séparément utilisateur, mot de passe, serveur et autres champs de base de donnée.","ui.setup.database-connection.url":"URL de la base de données","ui.setup.database-connection.validUrl":"L\'URL de la base de données est invalide ou la connexion au serveur a échoué.","ui.setup.database-connection.or":"or","ui.setup.database-connection.user":"Nom d\'utilisateur","ui.setup.database-connection.password":"Mot de passe","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Nom de la base de données","ui.setup.database-connection.connected":"Successfully connected to database {database} on {server}.","ui.setup.database-connection.error":"Erreur de connexion à la base de données","ui.setup.database-connection.problem":"Contao a détecté un problème avec votre serveur de bases de données.\\n","ui.setup.database-connection.schemaTitle":"Database Schema","ui.setup.database-connection.migration":"There is one pending migration. | There are {count} pending migrations.","ui.setup.database-connection.schema":"There is one pending schema update. | There are {count} pending schema updates.","ui.setup.database-connection.noChanges":"Le schéma de votre base de données est à jour.","ui.setup.database-connection.check":"Vérifier la base de données.","ui.setup.database-connection.skip":"Skip","ui.setup.database-connection.save":"Sauvegarder","ui.setup.database-connection.change":"Change credentials","ui.setup.database-connection.restoreTitle":"Database Import","ui.setup.database-connection.restoreText":"The theme you just installed contains a database backup. Restore the database to import theme data or skip this step to start with a blank Contao installation. | The theme you just installed contains multiple database backups. Select a backup file to import theme data or skip this step to start with a blank Contao installation.","ui.setup.database-connection.backup":"Backup current database before import","ui.setup.database-connection.backupWarning":"All data in database will be overwritten on import! Create a backup first if the database is not empty.","ui.setup.database-connection.restore":"Import theme database","ui.setup.database-connection.restoreOption":"Backup from {date} ({size})","ui.setup.database-connection.restored":"Your theme database was successfully imported. Continue to validate your database schema.","ui.setup.backend-user.success":"Un compte administrateur pour le back end de Contao a été trouvé dans votre base de données. veuillez utiliser le back end pour ajouter d\'autres utilisateurs.","ui.setup.backend-user.error":"Unable to retrieve user list. Check the console output for details.","ui.setup.backend-user.headline":"Backend Account","ui.setup.backend-user.description":"To manage your website, you need to have at least one admin account for the Contao back end. Be aware that this account is not related to the Contao Manager.","ui.setup.backend-user.formTitle":"Créer un compte","ui.setup.backend-user.formText":"Please enter the details for the new back end account.","ui.setup.backend-user.username":"Nom d\'utilisateur","ui.setup.backend-user.name":"Name","ui.setup.backend-user.email":"E-mail address","ui.setup.backend-user.emailInvalid":"Please enter a valid e-mail address","ui.setup.backend-user.password":"Mot de passe","ui.setup.backend-user.passwordPlaceholder":"Min. 8 caractères","ui.setup.backend-user.passwordLength":"Veuillez insérer au moins 8 caractères.","ui.setup.backend-user.create":"Add account","ui.task.headline":"Tâche de fond","ui.task.loading":"Chargement des détails…","ui.task.created":"Chargement des détails…","ui.task.active":"Veuillez patienter pendant que Contao Manager exécute des opérations en tâche de fond.","ui.task.complete":"Toutes les opérations sont terminées avec succès. Vérifiez les détails dans la console.","ui.task.paused":"Une opération en tâche de fond s\'est arrêtée de manière inattendue. Veuillez vérifier les détails dans la console.","ui.task.aborting":"Veuillez patienter le temps que les opérations en tâche de fond se terminent.","ui.task.stopped":"Certaines opérations en tâche de fond ont été annulées. Veuillez vérifier les détails dans la console","ui.task.error":"Une opération en tâche de fond s\'est arrêtée de manière inattendue. Veuillez vérifier les détails dans la console.","ui.task.failed":"Le Contao Manager n\'a pas pu démarrer!","ui.task.failedDescription1":"Une erreur s\'est produite lors de la tentative d\'exécution des opérations en arrière plan","ui.task.failedDescription2":"Si cela se reproduit, votre serveur peut ne pas être pris en charge","ui.task.reportProblem":"Signaler un problème","ui.task.pausedDescription":"Click \\"Continue\\" if you want to ignore the error and execute the remaining operations.","ui.task.sponsor":"Composer Cloud sponsored by {sponsor}","ui.task.buttonAudit":"Mettre à jour la base de données","ui.task.buttonClose":"Fermer","ui.task.buttonConfirm":"Confirmer & fermer","ui.task.buttonContinue":"Continuer","ui.task.buttonCancel":"Annuler","ui.task.confirmCancel":"Êtes-vous sûr de vouloir annuler cette tâche? Cela pourrait laisser votre installation Contao inutilisable!","ui.task.autoclose":"Fermer les détails de la tâche en cas de succès","ui.console.toggle":"Afficher / masquer la console","ui.console.showLog":"Show full console log","ui.console.copyLog":"Copier le journal dans le presse-papiers","ui.migrate.headline":"Database Updates","ui.migrate.migrationsOnly":"(migrations only)","ui.migrate.schemaOnly":"(schema only)","ui.migrate.loading":"Please wait, we are checking your database …","ui.migrate.empty":"No pending migrations or schema updates found. Your database is up to date.","ui.migrate.emptyMigrations":"No pending migrations found. Make sure to also check for schema updates.","ui.migrate.emptySchema":"No pending schema updates found. Make sure to also check for migrations.","ui.migrate.pending":"Your database is not up to date. Please review the console output below and execute the changes.","ui.migrate.previousChanges":"A previous database migration was not confirmed.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.previousComplete":"A previous database migration was not confirmed, please review the console output below.\\nThere are no more pending changes.","ui.migrate.appliedChanges":"Database updates have been applied.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.appliedComplete":"Database updates have been applied.\\nThere are no more pending migrations or schema updates. Your database is up to date.","ui.migrate.problem":"Contao has detected a problem with your database server.\\nPlease review the console output below to find out what needs to be fixed. | Contao has detected problems with your database server.\\nPlease review the console output below to find out what needs to be fixed.","ui.migrate.warning":"Contao has detected a misconfiguration of your database server.\\nWarnings can be skipped temporarily, but should be fixed for optimal performance and data integrity.","ui.migrate.error":"The changes could not be applied. Your database might have been changed, please check again to retry.","ui.migrate.execute":"Execute","ui.migrate.close":"Fermer","ui.migrate.confirm":"Confirmer & fermer","ui.migrate.cancel":"Annuler","ui.migrate.continue":"Continuer","ui.migrate.setup":"Configuration","ui.migrate.skip":"Skip","ui.migrate.retry":"Check again","ui.migrate.retryAll":"Check all","ui.migrate.withDeletes":"Execute all database changes including DROP queries.","ui.migrate.migrationTitle":"Database Migrations","ui.migrate.schemaTitle":"Schema Updates","ui.migrate.problemTitle":"Database Problems","ui.migrate.warningTitle":"Database Warnings","ui.migrate.addTable":"Add table {table}","ui.migrate.dropTable":"Drop table {table}","ui.migrate.addField":"Add field {table}.{field}","ui.migrate.changeField":"Change field {table}.{field}","ui.migrate.dropField":"Drop field {table}.{field}","ui.migrate.createIndex":"Create index \\"{name}\\" on {table}","ui.migrate.dropIndex":"Drop index \\"{name}\\" on {table}","ui.widget.mandatory":"Ce champ ne doit pas être vide.","ui.widget.blankOption":"Veuillez sélectionner","ui.widget.showPassword":"Show password","ui.widget.hidePassword":"Hide password","ui.error.title":"La requête HTTP pour \\"{method} {url}\\" a échoué.","ui.error.server500":"Il semble qu\'une erreur inattendue s\'est produite sur votre serveur. Veuillez vérifier les fichiers journaux de votre serveur Web (Apache / Nginx) et les journaux de Contao Manager à \\"contao-manager/logs\\".","ui.error.response":"Le serveur a renvoyé une réponse avec le status {status}.","ui.error.moreLink":"Plus d\'informations","ui.error.support":"Contao Support","ui.error.permission":"You do not have permission to use this feature.","ui.footer.help":"Aide","ui.footer.reportProblem":"Signaler un problème","ui.navigation.discover":"Découvrir","ui.navigation.packages":"Packages","ui.navigation.tools":"Outils","ui.navigation.installTool":"Outil d\'installation","ui.navigation.backend":"Back office de Contao","ui.navigation.debug":"Mode de débogage","ui.navigation.logViewer":"Log Viewer","ui.navigation.phpinfo":"Informations PHP","ui.navigation.phpinfoLoading":"Loading PHP Information…","ui.navigation.maintenance":"Maintenance","ui.navigation.rebuildCache":"Reconstruire le cache","ui.navigation.users":"Accounts","ui.navigation.systemCheck":"Vérification du système","ui.navigation.advanced":"Avancé","ui.navigation.logout":"Se déconnecter","ui.maintenance.database.title":"Database Migrations and Backups","ui.maintenance.database.description":"Database migrations ensure consistent data and table schemas.","ui.maintenance.database.migrations":"One pending database migration | {count} pending database migrations","ui.maintenance.database.schemaUpdates":"One pending schema update | {count} pending schema updates","ui.maintenance.database.error":"La base de données a un problème.","ui.maintenance.database.warning":"Database warnings found.","ui.maintenance.database.button":"Vérifier la base de données.","ui.maintenance.database.migrationOnly":"Check migrations only","ui.maintenance.database.schemaOnly":"Check schema only","ui.maintenance.database.installTool":"Open Install Tool","ui.maintenance.database.createBackup":"Create Backup","ui.maintenance.database.backupUnsupported":"Database backups are not supported by your Contao version.","ui.maintenance.database.backupList":"You have one database backup, created on {date}. | You have {count} database backups, the latest one was created on {date}.","ui.maintenance.database.backupEmpty":"You currently have no database backups.","ui.maintenance.rebuildCache.title":"Cache de l\'application","ui.maintenance.rebuildCache.description":"La reconstruction du cache de l\'application est requise après toute modification des fichiers de configuration.","ui.maintenance.rebuildCache.rebuildProd":"Reconstruire le cache de production","ui.maintenance.rebuildCache.rebuildDev":"Reconstruire le cache de développement","ui.maintenance.rebuildCache.clearProd":"Vider le cache de production","ui.maintenance.rebuildCache.clearDev":"Vider le cache de développement","ui.maintenance.installTool.title":"Outil d\'installation Contao","ui.maintenance.installTool.description":"L\'outil d\'installation Contao est automatiquement verrouillé si vous entrez un mauvais mot de passe trois fois de suite.","ui.maintenance.installTool.unlock":"Dévérouillage de l\'outil d\'installation Contao","ui.maintenance.installTool.lock":"Vérouillage de l\'outil d\'installation Contao","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"L\'autoloader de Composer est responsable du chargement des classes PHP. L\'autoloader doit être vidé après l\'ajout de namespaces à la racine composer.json.","ui.maintenance.dumpAutoload.button":"Purger l\'Autoloader","ui.maintenance.composerInstall.title":"Composer Dependencies","ui.maintenance.composerInstall.description":"Les dépendances de Composer se trouvent dans le dossier {vendor} à la racine de votre application. La réinstallation des dépendances peut être nécessaire après manipulation ou téléchargement manuel du fichier {composerLock}","ui.maintenance.composerInstall.button":"Lancer Composer Install","ui.maintenance.composerInstall.update":"Lancer Composer Update","ui.maintenance.composerCache.title":"Composer Cache","ui.maintenance.composerCache.description":"Pour améliorer ses performences, Composer met en cache les packages téléchargés. Si vous rencontrez des problèmes comme par exemple des fichiers corrompdus, vous pouvez essayer de d\'effacer le cache de Composer pour forcer un nouveau téléchargement des packages.","ui.maintenance.composerCache.button":"Vider le cache","ui.maintenance.maintenanceMode.title":"Maintenance Mode","ui.maintenance.maintenanceMode.description":"Putting Contao in maintenance mode will display a \\"503 Service Unavailable\\" template for the website.","ui.maintenance.maintenanceMode.enable":"Enable","ui.maintenance.maintenanceMode.disable":"Disable","ui.maintenance.debugMode.title":"Mode de débogage","ui.maintenance.debugMode.description":"Activez le mode débogage en définissant un utilisateur et un mot de passe pour le point d\'entrée {appDevPhp}","ui.maintenance.debugMode.descriptionJwt":"Activez le mode débogage en définissant le cookie de débogage pour le domaine actuel.","ui.maintenance.debugMode.activate":"Activer","ui.maintenance.debugMode.deactivate":"Désactiver","ui.maintenance.debugMode.credentials":"Données de connexion","ui.maintenance.debugMode.user":"Veuillez saisir un nom d\'utilisateur pour le mode de débogage.","ui.maintenance.debugMode.password":"Veuillez saisir un mot de passe pour le mode de débogage.","ui.maintenance.opcodeCache.title":"Opcode Cache","ui.maintenance.opcodeCache.description":"Opcode met en cache les fichiers PHP pour améliorer la vitesse d\'exécution du processus web. Cette fonctionnalité doit être supprimée dans certaines circontances et notammment si certanis fichiers ne sont pas reconnus après des modifications.","ui.maintenance.opcodeCache.button":"Vider le cache","ui.maintenance.safeMode":"Non disponible en mode sans échec","ui.maintenance.unsupported":"Non pris en charge par votre version Contao","ui.packages.updateButton":"Mise à jour des packages","ui.packages.searchButton":"Rechercher des packages","ui.packages.searchPlaceholder":"Rechercher des packages…","ui.packages.uploadOverlay":"Glisser-déposez les fichiers à uploader","ui.packages.uploadButton":"Uploader des packages","ui.packages.uploadMessage":"Vous avez un upload non confirmé. | Vous avez {count} uploads non confirmés.","ui.packages.uploadApply":"Confirmer les uploads","ui.packages.uploadReset":"Supprimer les uploads","ui.packages.uploadIncomplete":"Ce fichier n\'a pas été entièrement uploadé. Veuillez le supprimer et réessayer.","ui.packages.uploadDuplicate":"Ce fichier semble avoir été uploadé plusieurs fois. Veuillez supprimer les doublons.","ui.packages.uploadInstalled":"Ce fichier est déjà installé. Veuillez supprimer les doublons.","ui.packages.uploadUnsupported":"Uploads are not supported in your installation. Please make sure that the PHP ZIP extension is installed and update your dependencies.","ui.packages.changesMessage":"Vous avez un changement non confirmé. | Vous avez {count} changements non confirmés.","ui.packages.changesDryrun":"Tester (Dry run)","ui.packages.changesApply":"Appliquer les changements","ui.packages.changesApplyAll":"Update all packages","ui.packages.changesDryrunAll":"Dry run all packages","ui.packages.changesReset":"Annuler les changements","ui.packages.changesReview":"Revoir les changements","ui.packagelist.loading":"Chargement…","ui.packagelist.uploads":"Uploads","ui.packagelist.added":"Nouveaux packages","ui.packagelist.installed":"Packages installés","ui.package.hintRevert":"Rétablir les modifications","ui.package.hintNoupdate":"Ne pas mettre à jour","ui.package.hintConstraint":"Ce package va être installé avec la contrainte {constraint} quand vous appliquerez les modifications.","ui.package.hintConstraintBest":"Ce package sera installé avec la meilleure version disponible lorsque vous appliquerez les modifications.","ui.package.hintConstraintChange":"La contrainte pour ce package sera changée de \\"{from}\\" à \\"{to}\\" lorsque vous appliquerez les modifications.","ui.package.hintConstraintUpdate":"Ce package sera mis à jour lorsque vous appliquez les modifications.","ui.package.hintAdded":"Ce package sera installé lorsque vous appliquerez les modifications.","ui.package.hintRemoved":"Ce package sera supprimé lorsque vous appliquerez les modifications.","ui.package.requiredTitle":"ajouté manuellement","ui.package.requiredText":"Ce package est requis dans votre composer.json mais n\'est pas installé.","ui.package.removedTitle":"supprimé manuellement","ui.package.removedText":"Ce package a été supprimé de votre composer.json.","ui.package.installed":"Actuellement installé:","ui.package.version":"Version {version}","ui.package.additionalDownloads":"{count} Téléchargement | {count} Téléchargements","ui.package.additionalStars":"{count} Star | {count} Stars","ui.package.editConstraint":"Éditer","ui.package.uploadConstraint":"Cette contrainte est définie par le package téléchargé.","ui.package.updateButton":"Mettre à jour","ui.package.removeButton":"Supprimer","ui.package.installButton":"Ajouter un package","ui.package.installButtonShort":"Ajouter","ui.package.detailsButton":"Détails","ui.package.latestConstraint":"dernière version","ui.package.update":"Update available","ui.package.updateLatest":"dernière version","ui.package.updateAvailable":"{version} available","ui.package.updateUnknown":"unknown version","ui.package.updateConstraint":"A newer version outside your version constraint is available.","ui.package.incompatible":"{package} does not work with Contao {constraint}.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Version {version}","ui.cloudStatus.waitingTime":"Temps d\'attente","ui.cloudStatus.jobs":"Jobs en cours","ui.cloudStatus.workers":"Workers","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"sans","ui.cloudStatus.short":"ca. {minutes} min","ui.cloudStatus.long":"ca. {minutes} min {seconds} sec","ui.cloudStatus.error":"Unable to fetch the status of the Composer Resolver Cloud. It might be down for maintenance or experience issues.","ui.cloudStatus.button":"Cloud Status","ui.cloudStatus.refresh":"Refresh Cloud Status","ui.log-viewer.loading":"Chargement…","ui.log-viewer.empty":"There are no log files on your server.","ui.log-viewer.reload":"Reload","ui.log-viewer.file":"Log file","ui.log-viewer.channel":"Channel","ui.log-viewer.channelTitle":"The channel this message was logged to.","ui.log-viewer.level":"Level","ui.log-viewer.levelTitle":"Severity of the log message.","ui.log-viewer.timeHeader":"Time","ui.log-viewer.messageHeader":"Message","ui.log-viewer.showContext":"Show Context","ui.log-viewer.hideContext":"Hide Context","ui.log-viewer.showExtra":"Show Extra","ui.log-viewer.hideExtra":"Hide Extra","ui.log-viewer.more":"Load more …","ui.log-viewer.download":"Download","ui.log-viewer.downloadTitle":"Download file \\"{file}\\"","ui.log-viewer.prodEnvironment":"Production Environment","ui.log-viewer.devEnvironment":"Development Environment (Debug Mode)","ui.user-manager.loading":"Loading users …","ui.user-manager.changePassword":"Change Password","ui.user-manager.setupTotp":"Setup Two-Factor Authentication","ui.user-manager.disableTotp":"Disable Two-Factor Authentication","ui.user-manager.invite":"Invite User","ui.user-manager.delete":"Delete","ui.user-manager.deleteConfirm":"Do you really want to delete user \\"{username}\\"?","ui.user-manager.deleted":"User {username} deleted successfully","ui.user-manager.passwordHeadline":"Change Password","ui.user-manager.passwordText":"To change your password, please enter the current and a new password in the respective fields.","ui.user-manager.currentPassword":"Current password","ui.user-manager.newPassword":"New password","ui.user-manager.passwordPlaceholder":"Min. 8 caractères","ui.user-manager.submitPassword":"Submit","ui.user-manager.passwordChanged":"Your password has been changed successfully.","ui.user-manager.passwordError":"This password is incorrect.","ui.user-manager.inviteHeadline":"Invite User","ui.user-manager.inviteText":"If you need multiple logins for the Contao Manager, you can create an invitation link here. Share this link with someone or use it on another device to create a new account with the given permissions.","ui.user-manager.inviteSuccess1":"A new invitation link was created. The URL below can be used to create a new user account for this Contao Manager. The invitation expires on {expires} (one week from now).","ui.user-manager.inviteSuccess2":"Please copy the link to your clipboard. It will only work once and you will not be able to see it again after closing this dialog.","ui.user-manager.createInvitation":"Create Invitation Link","ui.user-manager.clipboard":"Copy to clipboard","ui.user-manager.permissions":"Learn about permissions","ui.user-manager.cancel":"Annuler","ui.user-manager.close":"Fermer","ui.user-manager.you":"You","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"Two-Factor Authentication","ui.totp.setupQr":"Please scan the QR code with your 2FA/TOTP app.","ui.totp.setupCode":"If you cannot scan the QR code, enter this key instead:","ui.totp.codeLabel":"Verification code","ui.totp.codeDescription":"Please enter the verification code generated by your 2FA/TOTP app.","ui.totp.disableText":"Please enter the verification code to disable two-factor authentication.","ui.totp.invalid":"The verification code is invalid.","ui.totp.enable":"Enable","ui.totp.disable":"Disable","ui.totp.cancel":"Annuler","ui.totp.enabled":"Two-factor authentication was enabled successfully.","ui.totp.disabled":"Two-factor authentication was disabled successfully.","ui.totp.setup":"Setup Two-Factor Authentication","ui.totp.skip":"Skip Two-Factor Authentication"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[367],{7390:function(e,r,t){t.r(r),t.d(r,{default:function(){return b}});var o=t(641),i=t(33),a=t.p+"img/recovery.70ee118a.svg";const s={class:"view-recovery__header"},n={class:"view-recovery__headline"},c={class:"view-recovery__content"},l={class:"view-recovery__description"},d={class:"view-recovery__description"},u={class:"view-recovery__option"},v={key:0,class:"view-recovery__failed"},p={class:"view-recovery__option"},h=["disabled"];function _(e,r,t,_,k,y){const w=(0,o.g2)("console-output"),m=(0,o.g2)("loading-button"),f=(0,o.g2)("boxed-layout");return(0,o.uX)(),(0,o.Wv)(f,{wide:!0,slotClass:"view-recovery"},{default:(0,o.k6)((()=>[(0,o.Lk)("header",s,[r[1]||(r[1]=(0,o.Lk)("img",{src:a,width:"80",height:"80",alt:"",class:"view-recovery__icon"},null,-1)),(0,o.Lk)("h1",n,(0,i.v_)(e.$t("ui.recovery.headline")),1)]),(0,o.Lk)("main",c,[(0,o.Lk)("p",l,(0,i.v_)(e.$t("ui.recovery.description")),1),console?((0,o.uX)(),(0,o.Wv)(w,{key:0,class:"view-recovery__console",title:e.$t("ui.recovery.console"),operations:[{status:"error",summary:"vendor/bin/contao-console list",console:this.error}],"console-output":e.error,"show-console":"","force-console":""},null,8,["title","operations","console-output"])):(0,o.Q3)("",!0),(0,o.Lk)("p",d,(0,i.v_)(e.$t("ui.recovery.repairOptions")),1),(0,o.Lk)("div",u,[(0,o.Lk)("h3",null,(0,i.v_)(e.$t("ui.recovery.repairHeadline")),1),(0,o.Lk)("p",null,(0,i.v_)(e.$t("ui.recovery.repairDescription")),1),(0,o.Lk)("p",null,[(0,o.Lk)("strong",null,(0,i.v_)(e.$t("ui.recovery.repairWarning")),1)]),e.repairFailed?((0,o.uX)(),(0,o.CE)("p",v,(0,i.v_)(e.$t("ui.recovery.repairFailed")),1)):(0,o.Q3)("",!0),(0,o.bF)(m,{inline:"",color:"alert",icon:"run",disabled:e.repairFailed,loading:e.repairStarted&&!e.repairFailed,onClick:y.runRepair},{default:(0,o.k6)((()=>[(0,o.eW)((0,i.v_)(e.$t("ui.recovery.repairButton")),1)])),_:1},8,["disabled","loading","onClick"])]),(0,o.Lk)("div",p,[(0,o.Lk)("h3",null,(0,i.v_)(e.$t("ui.recovery.safeModeHeadline")),1),(0,o.Lk)("p",null,(0,i.v_)(e.$t("ui.recovery.safeModeDescription")),1),(0,o.Lk)("button",{class:"widget-button widget-button--inline widget-button--primary",disabled:e.repairStarted&&!e.repairFailed,onClick:r[0]||(r[0]=(...e)=>y.runSafeMode&&y.runSafeMode(...e))},(0,i.v_)(e.$t("ui.recovery.safeModeButton")),9,h)])])])),_:1})}var k=t(6278),y=t(707),w=t(728),m=t(85),f=t(2864),g={components:{BoxedLayout:w.A,LoadingButton:m.A,ConsoleOutput:f.A},data:()=>({repairStarted:!1,repairFailed:!1,error:""}),computed:{...(0,k.aH)("tasks",{taskStatus:"status"})},methods:{async runRepair(){let e;this.repairStarted=!0;const r=[{name:"contao/rebuild-cache"},{name:"composer/install"},{name:"composer/install",config:{"remove-vendor":!0}}];while(void 0!==(e=r.shift()))try{return await this.$store.dispatch("tasks/execute",e),await this.$store.dispatch("tasks/deleteCurrent"),void window.location.reload(!0)}catch(t){if("failed"===this.taskStatus){await this.$store.dispatch("tasks/deleteCurrent");break}await this.$store.dispatch("tasks/deleteCurrent")}this.repairFailed=!0},runSafeMode(){this.$store.commit("setSafeMode",!0),this.$store.commit("setView",y.A.READY)}},async mounted(){const e=await this.$store.dispatch("server/contao/get");502===e.status&&e.data.error&&(this.error=e.data.error)}},$=t(6262);const L=(0,$.A)(g,[["render",_]]);var b=L}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[140],{1140:function(e){e.exports=JSON.parse('{"ui.app.title":"Contao Extensions","ui.app.loading":"Loading Extension List …","ui.discover.advertisement":"Advertisement in the extension list","ui.discover.loading":"O kargañ ...","ui.discover.offline":"N\'eo ket gouest da adtapout disoc\'hoù.","ui.discover.offlineExplain":"Check your internet connection and disable JavaScript blockers in your browser.","ui.discover.offlineButton":"Try again","ui.discover.searchPlaceholder":"Search in {count} extensions …","ui.discover.empty":"No results for {query}","ui.discover.more":"More Results","ui.discover.sortBy":"Sort by","ui.discover.sortLatest":"Updated","ui.discover.sortLatestTitle":"Sort search results by last updated","ui.discover.sortDownloads":"Downloads","ui.discover.sortDownloadsTitle":"Sort search results by number of downloads","ui.discover.sortFavers":"Rating","ui.discover.sortFaversTitle":"Sort search results by rating","ui.discover.detailsButton":"Munudoù","ui.discover.latestPackages":"Latest and updated extensions","ui.discover.faversPackages":"Top rated extensions","ui.discover.downloadsPackages":"Most downloaded extensions","ui.package.homepage":"Lec\'hienn ar raktres","ui.package.private":"Private Package","ui.package.privateTitle":"Private packages are only available from the vendor (e.g. as a ZIP download). Please visit the website for more information.","ui.package.abandoned":"dilezet","ui.package.abandonedText":"This package is abandoned and no longer maintained.","ui.package.abandonedReplace":"This package is abandoned and no longer maintained. The author suggests using the {replacement} package instead.","ui.package-details.previous":"Previous Extension Details","ui.package-details.close":"Close Extension Details","ui.package-details.loading":"O kargañ ...","ui.package-details.tabDescription":"Description","ui.package-details.tabRequire":"Requirements","ui.package-details.tabFeatures":"Features","ui.package-details.tabSuggest":"Suggestions","ui.package-details.tabConflict":"Conflicts","ui.package-details.tabDependents":"Dependents","ui.package-details.linkRequires":"requires","ui.package-details.linkReplaces":"replaces","ui.package-details.linkProvides":"provides","ui.package-details.linkConflicts":"conflicts","ui.package-details.funding":"Fund package maintenance!","ui.package-details.latest":"Latest version","ui.package-details.released":"released on","ui.package-details.license":"License(s)","ui.package-details.authors":"from","ui.package-details.more":"Muioc\'h","ui.package-details.packagist":"Munudoù ar pakaj","ui.package-details.metadata":"Edit Metadata","ui.package-details.support_docs":"Titouroù","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Forom skoazell","ui.package-details.support_issues":"Kudennoù/Danevell beugoù","ui.package-details.support_source":"Kod mamenn","ui.package-details.support_irc":"IRC/Flapva","ui.package-details.support_email":"Skoazell dre Bostel","ui.package-details.support_rss":"Froud RSS"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[638],{3638:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Niebezpieczne połączenie !!","ui.app.httpsDescription":"Bez HTTPS twoje poufne dane będą wysyłane bez szyfrowania.","ui.app.httpsLink":"Więcej informacji","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Bezpieczny Tryb włączony !!","ui.app.safeModeDescription":"Niektóre funkcje Contao Manager nie są dostępne.","ui.app.safeModeExit":"Wyłącz Bezpieczny Tryb","ui.app.limitedHeadline":"Zdalne Poświadczenie","ui.app.limitedDescription":"You have limited permissions due to passwordless login.","ui.app.limitedLogout":"Re-authenticate","ui.app.totpHeadline":"Security Notice","ui.app.totpDescription":"Configure two-factor authentication now to secure your account.","ui.app.totpSetup":"Instalacja","ui.app.loading":"Ładowanie Contao Manager …","ui.app.apiError":"Nieoczekiwany status API","ui.app.configSecurity1":"ALERT BEZPIECZEŃSTWA !!! Wykryto niezabezpieczony folder konfiguracji","ui.app.configSecurity2":"Contao Manager wykrył, że pliki konfiguracji są dostępne publicznie. Wszystkie operacje zostały zablokowane do czasu, aż folder zostanie zabezpieczony. W przeciwnym wypadku atakujący mógłby uzyskać dostęp do wrażliwych danych twojej instalacji.\\n\\nAby naprawić ten problem, zabezpiecz dostęp do katalogu \\"contao-manager\\" na serwerze. Jeśli nie wiesz jak to zrobić, odwołaj się dokumentacji twojego serwera lub skontaktuj z dostawcą usług.","ui.account.welcome":"Witaj","ui.account.intro1":"Witaj w Contao Manager, uniwersalnym narzędziu do instalacji i zarządzania Contao Open Source CMS. Jeśli jesteś tu nowy, proszę {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual}, żeby zacząć","ui.account.introManual":"przeczytaj instrukcję","ui.account.intro2":"Jeśli masz jakiekolwiek problemy, sprawdź {ourGithubIssues} i utwórz nowe zgłoszenie na dowolny temat, który nie był jeszcze raportowany.","ui.account.introIssues":"naszą listę problemów na GitHub","ui.account.headline":"Konto użytkownika","ui.account.description":"Aby zarządzać twoją instalacją, utwórz konto w Contao Manager. Uwaga – to konto nie jest powiązane z kontem w backendzie ani frontendzie Contao!","ui.account.username":"Nazwa użytkownika","ui.account.password":"Hasło","ui.account.passwordPlaceholder":"min 8 znaków","ui.account.passwordLength":"Wprowadź przynajmniej 8 znaków.","ui.account.loginInvalid":"There was an error when creating the account. Please try a different username.","ui.account.submit":"Utwórz konto","ui.account.usePassword":"Use password for login","ui.account.usePasskey":"Use Passkey for login","ui.account.totpHeadline":"Two-factor authentication","ui.account.totpDescription":"Please enable two-factor authentication, which adds an extra layer of security to your account. In addition to your username and password, you will need to enter a verification code generated by a two-factor app such as 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator or any other TOTP app.","ui.account.totpSetup":"Configure now","ui.account.totpSkip":"Configure later","ui.account.login":"Decline Invitation","ui.account.contribute1":"Contao i Contao Manager są sponsorowane przez charytatywną organizację Contao Association.","ui.account.contribute2":"Rozważ uczestnictwo w projektach open source poprzez {donate}.","ui.account.contributeDonate":"przekazanie darowizny","ui.login.headline":"Zaloguj się","ui.login.description":"Zaloguj się, aby zarządzać instalacją.","ui.login.username":"Nazwa użytkownika","ui.login.password":"Hasło","ui.login.totpHeadline":"Two-factor authentication","ui.login.totpDescription":"Please enter your verification code to complete the login process.","ui.login.totp":"Verification code","ui.login.forgotPassword":"Zapomniałeś hasła?","ui.login.button":"Zaloguj się","ui.login.passkey":"Sign In with Passkey","ui.login.cancel":"Anuluj","ui.login.or":"lub","ui.login.locked":"Odmówiono dostępu, ponieważ Contao Manager jest zablokowany. Aby odblokować, usuń plik {lockFile} w folderze głównym instalacji Contao.","ui.logout.headline":"Limit czasu sesji","ui.logout.warning":"Byłeś nieaktywny przez więcej niż 25 minut. Z powodu bezpieczeństwa twoja sesja zostanie wkrótce zakończona.","ui.logout.expired":"Twoja sesja została zakończona, ponieważ byłeś nieaktywny przez więcej niż 30 minut.","ui.logout.renew":"Nie wylogowuj się","ui.logout.logout":"Wyloguj","ui.logout.login":"Powrót do logowania","ui.oauth.error":"Nieudana próba OAuth. Sprawdź parametry żądania.","ui.oauth.https":"URI przekierowania MUSI używać bezpiecznego protokołu (https:), aby nie przesyłać tokena poświadczenia otwartym tekstem.","ui.oauth.headline":"Zdalne Poświadczenie","ui.oauth.description":"Następująca aplikacja lub usługa żąda zdalnego dostępu do twojej instancji Contao Manager.","ui.oauth.domain":"Zanim zezwolisz na dostęp, upewnij się, że znasz ten adres URL i ufasz jego właścicielowi!","ui.oauth.outOfScope":"Unfortunately, you do not have the necessary permissions to grant this access.","ui.oauth.allow":"Zezwól na dostęp","ui.oauth.deny":"Odmów dostępu","ui.oauth.switchUser":"Switch User","ui.scope.admin":"Admin access including user management","ui.scope.install":"Install new packages and change Contao configuration","ui.scope.update":"Update packages and execute maintenance tasks","ui.scope.read":"Read packages and configuration","ui.boot.headline":"Sprawdzenie Systemu","ui.boot.description":"Proszę czekać, analizujemy twój serwer …","ui.boot.issue1":"Wykryto nieprawidłowości instalacji","ui.boot.issue2":"Twoja instalacja zawiera błędy, które muszą być rozwiązane, zanim zaczniesz używać Contao Manager.","ui.boot.run":"Otwórz Contao Manager","ui.boot.safeMode":"Uruchom w Bezpiecznym Trybie","ui.recovery.headline":"Odzyskiwanie Systemu","ui.recovery.description":"Contao Manager wykrył pliki, które wyglądają jak z Contao, ale interfejs linii komend (CLI) nie działa tak jak powinien.","ui.recovery.console":"Wyjście Konsolie","ui.recovery.repairOptions":"Wybierz opcję naprawy twojej instalacji.","ui.recovery.repairHeadline":"Automatyczna Naprawa","ui.recovery.repairDescription":"Próba automatycznego naprawienia instalacji poprzez przebudowanie pamięci cache aplikacji i ponownej instalacji pakietów Composera.","ui.recovery.repairWarning":"Jakakolwiek modyfikacja plików vendor może zostać skasowana podczas tego procesu!","ui.recovery.repairFailed":"Automatyczna naprawa nie zakończyła się sukcesem. Spróbuj Bezpiecznego Trybu w celu naprawy instalacji.","ui.recovery.repairButton":"Uruchom naprawę systemu","ui.recovery.safeModeHeadline":"Bezpieczny Tryb","ui.recovery.safeModeDescription":"Uruchamianie Contao Managera w Bezpiecznym Trybie pozwala na zarządzanie pakietami i wykonywanie określonych czynności konserwacyjnych, ale funkcje, które wymagają działającego Contao będą niedostępne.","ui.recovery.safeModeButton":"Uruchom w Bezpiecznym Trybie","ui.server.pending":"Czekam …","ui.server.running":"Analizuję …","ui.server.error":"Sprawdzenie nie powiodło się z powodu niespodziewanej odpowiedzi serwera.","ui.server.details":"Szczegóły","ui.server.prerequisite":"Sprawdzenie anulowane z powodu brakującego warunku wstępnego.","ui.server.selfUpdate.title":"Aktualizacje Contao Managera","ui.server.selfUpdate.update":"Nowa wersja Contao Managera {latest} jest dostępna.","ui.server.selfUpdate.manualUpdate":"Nowa wersja Contao Managera {latest} jest dostępna. Twój serwer nie wspiera automatycznych aktualizacji, nową wersję możesz pobrać z {download}.","ui.server.selfUpdate.latest":"Używasz najnowszej wersji {current}.","ui.server.selfUpdate.dev":"Buildy deweloperskie nie wspierają automatycznych aktualizacji.","ui.server.selfUpdate.unsupported":"Nowa wersja jest dostępna, ale nie wspiera ona twojej wersji PHP.","ui.server.selfUpdate.button":"Uruchom Aktualizację","ui.server.selfUpdate.continue":"Kontynuuj","ui.server.config.title":"Konfiguracja Serwera","ui.server.config.setup":"Konfiguruj","ui.server.config.change":"Zmień","ui.server.config.save":"Zapisz","ui.server.config.cancel":"Anuluj","ui.server.config.customOption":"Inne …","ui.server.config.description":"Aby zadania w tle poprawnie działały, Contao Manager musi wiedzieć, gdzie znaleźć wykonywalny plik PHP linii komend i jak uruchamiać działania niezależnie od procesów serwera www.","ui.server.config.formTitle":"Konfiguracja Serwera","ui.server.config.formText":"Wprowadź ścieżkę do PHP binary. Upewnij się, że wersja PHP binary jest taka sama jak w procesie web.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud pozwala na instalowanie pakietów Composera nawet jeśli twój serwer nie posiada wystarczającej ilości pamięci. Informacja o twoich pakietach będzie przesłana na serwer operowany przez Contao Association.","ui.server.config.cloud":"Użyj Composer Resolver Cloud","ui.server.config.cli":"Plik binarny PHP","ui.server.config.stateErrorCli":"Nie znaleziono poprawnego pliku binarnego PHP na serwerze.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud jest niewspierany.","ui.server.config.stateSuccess":"Plik binarny PHP pod {php_cli}.","ui.server.php_web.title":"PHP Web Process","ui.server.php_web.below7":"Znaleziono wersję PHP {version}. Zaktualizuj ją do PHP 7 tak szybko, jak to możliwe!","ui.server.php_web.success":"Znaleziono wersję PHP {version}, brak nieprawidłowości.","ui.server.php_cli.title":"PHP Command Line Interface","ui.server.php_cli.success":"Znaleziono wersję PHP {version}, brak nieprawidłowości.","ui.server.composer.title":"Środowisko Composera","ui.server.composer.success":"Brak nieprawidłowości.","ui.server.composer.install":"Pakiety Composera nie są zainstalowane.","ui.server.composer.button":"Instalacja","ui.server.contao.title":"Instalacja Contao","ui.server.contao.setup":"Instalacja","ui.server.contao.check":"Sprawdź bazę danych","ui.server.contao.empty":"Nie znaleziono instalacji Contao.","ui.server.contao.old":"Wersja Contao {version} jest niekompatybilna z Contao Manager, aktualizuj swoją instalację ręcznie.","ui.server.contao.found":"Znaleziono Contao {version} (wersja API {api}).","ui.server.contao.connectionError":"Brak połączenia z serwerem bazy danych.","ui.server.contao.connectionProblem":"Problem z bazą danych został znaleziony.","ui.server.contao.missingUser":"Nie znaleziono konta administratora.","ui.setup.continue":"Kontynuuj","ui.setup.manager":"Otwórz Contao Manager","ui.setup.cancel":"Anuluj","ui.setup.welcome":"Witaj","ui.setup.welcome1":"Ten kreator przeprowadzi Cię przez niezbędne kroki, aby skonfigurować instalację Contao Open Source CMS.","ui.setup.welcome2":"Jeśli masz jakieś pytania, odwiedź dokumentację, fora, kanał Slack i więcej na stronie {support}.","ui.setup.support":"wsparcie społeczności","ui.setup.start":"Rozpocznij","ui.setup.complete":"Gratulacje!","ui.setup.complete1":"Contao {version} zostało zainstalowane pomyślnie.","ui.setup.complete2":"Aby zakończyć proces konfiguracji, otwórz narzędzie instalacyjne, aby skonfigurować połączenie z bazą danych i utworzyć użytkownika.","ui.setup.complete3":"Możesz teraz rozpocząć tworzenie swojej strony internetowej w Contao. Jeśli potrzebujesz dodatkowych rozszerzeń, przejdź dalej do Contao Manager.","ui.setup.installTool":"Otwórz instalator","ui.setup.login":"Zaloguj się do Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Dowiedz się więcej","ui.setup.document-root.headline":"Konfiguracja serwera www","ui.setup.document-root.warning":"Aby zainstalować Contao przez Contao Manager, musisz poprawić ustawienie katalogu głównego - document root - w konfiguracji serwera www.","ui.setup.document-root.description1":"Contao używa osobnego folderu dla plików publicznych, a pliki aplikacji są instalowane w folderze nadrzędnym. Contao nie może być zainstalowany, jeśli struktura folderów nie jest poprawna lub foldery nie są puste.","ui.setup.document-root.description2":"Jeśli wiesz, jak skonfigurować katalog główny - document root, zapoznaj się z dokumentacją Contao lub skontaktuj się z administratorem serwera.","ui.setup.document-root.documentation":"Przeczytaj Dokumentację","ui.setup.document-root.conflictsTitle":"Katalog instalacyjny nie jest pusty","ui.setup.document-root.conflictsDirectory":"Katalog główny Twojej przyszłej instalacji Contao nie jest pusty, znaleźliśmy {count} plik(i), które mogą zostać nadpisane przez proces instalacji. Zaleca się utworzenie pustej struktury katalogów dla Contao, ale możesz również usunąć następujące pliki i sprawdzić ponownie, jeśli jesteś pewien, że są one nieużywane.","ui.setup.document-root.ignoreConflicts":"Chcę zainstalować Contao w katalogu, który nie jest pusty. Rozumiem, że może to spowodować nadpisanie wszelkich istniejących plików na mojej przestrzeni dyskowej.","ui.setup.document-root.check":"Sprawdź ponownie","ui.setup.document-root.create":"Utwórz katalogi","ui.setup.document-root.change":"Zmień katalogi","ui.setup.document-root.formTitle":"Konfiguracja Katalogu","ui.setup.document-root.formText1":"Contao Manager może automatycznie utworzyć nową strukturę katalogów na serwerze.","ui.setup.document-root.formText2":"Będziesz musiał ręcznie skonfigurować nowy katalog główny - document root (np. przez panel administracyjny serwera).","ui.setup.document-root.autoconfig":"Rozumiem, że muszę zmienić konfigurację mojego serwera. Niepoprawne ustawienie katalogu głównego może uniemożliwić działanie Contao Manager i uwidocznić publicznie pliki konfiguracyjne (włącznie ze szczegółami konta i hasłami)!","ui.setup.document-root.directory":"Nowy Katalog","ui.setup.document-root.currentRoot":"Aktualny Katalog Główny","ui.setup.document-root.newRoot":"Nowy Katalog Główny","ui.setup.document-root.finish":"Ustawienia Katalogów","ui.setup.document-root.publicDir":"Użyj {dir} dla plików publicznych (dla Contao {version})","ui.setup.document-root.directoryInvalid":"Wprowadź prawidłową nazwę katalogu.","ui.setup.document-root.directoryExists":"Docelowy katalog już istnieje. Podaj inną nazwę.","ui.setup.document-root.confirmation":"Contao Manager utworzył potrzebne katalogi dla twojej instalacji Contao. Teraz powinieneś skonfigurować główny katalog serwera www - document root. Nie przeładowuj wcześniej tej strony.","ui.setup.document-root.reload":"Przeładuj Stronę","ui.setup.document-root.success":"Struktura katalogów na Twoim serwerze jest ustawiona prawidłowo!","ui.setup.document-root.installingProjectDir":"Pliki aplikacji zostaną zainstalowane w {dir}.","ui.setup.document-root.installingPublicDir":"Pliki publiczne zostaną zainstalowane do {dir}.","ui.setup.document-root.installedProjectDir":"Pliki aplikacji są zainstalowane w {dir}.","ui.setup.document-root.installedPublicDir":"Pliki publiczne są instalowane w {dir}.","ui.setup.create-project.headline":"Instalacja Contao","ui.setup.create-project.description":"Rozwój Contao odbywa się zgodnie z zasadą {semver}, co pół roku wydawana jest nowa wersja minor. Obecnie wspierane wydania to:","ui.setup.create-project.semver":"Wersjonowanie semantyczne","ui.setup.create-project.latestTitle":"Najnowsza","ui.setup.create-project.ltsTitle":"Long Term Support","ui.setup.create-project.latestQ1":"Nasza najnowsza wersja, oferuje najwięcej funkcji ze wsparciem do lutego {year}.","ui.setup.create-project.latestQ3":"Nasza najnowsza wersja oferuje najwięcej funkcji z wsparciem do sierpnia {year}.","ui.setup.create-project.ltsText":"Nasza aktualna wersja LTS, jeśli stawiasz na stabilność. Oferuje długoterminowe wsparcie do lutego {year}.","ui.setup.create-project.pltsText":"Poprzednia wersja LTS, nadal posiada długoterminowe wsparcie do lutego {year}.","ui.setup.create-project.requiresPHP":"Wymaga co najmniej PHP {version}, ty masz PHP {current}.","ui.setup.create-project.releaseplan":"Zobacz {contaoReleasePlan}, aby uzyskać szczegółowe informacje.","ui.setup.create-project.releaseplanLink":"Plan Rozwoju Contao","ui.setup.create-project.installed":"Contao {version} zostało pomyślnie zainstalowane na serwerze. Kontynuuj konfigurację bazy danych lub uruchom Contao Manager, aby zainstalować inną wersję.","ui.setup.create-project.formTitle":"Wybierz dystrybucję","ui.setup.create-project.formText":"Wybierz, która wersja ma być zainstalowana.","ui.setup.create-project.version":"Wersja","ui.setup.create-project.demo":"Zainstaluj witrynę demonstracyjną Contao","ui.setup.create-project.demoDescription":"Strona demonstracyjna pomaga Ci zapoznać się z Contao i wszystkimi jego podstawowymi funkcjami. Więcej motywów można znaleźć w {store}.","ui.setup.create-project.coreOnly":"Minimalna Instalacja (tylko Core)","ui.setup.create-project.noUpdate":"Pomiń Instalację (tylko dla ekspertów!)","ui.setup.create-project.theme":"Motyw Contao","ui.setup.create-project.themeInstall":"Aby zainstalować motyw Contao, użyj pola wyszukiwania lub załaduj plik motywu (.cto/.zip), który obsługuje instalację za pośrednictwem menedżera Contao.","ui.setup.create-project.themeBuy":"Upewnij się, że odwiedzisz oficjalny {sklep}.","ui.setup.create-project.themeStore":"Sklep z motywami Contao","ui.setup.create-project.themeUpload":"Prześlij plik motywu (.cto/.zip)","ui.setup.create-project.themeInvalid":"Przesłany plik nie jest motywem Contao lub nie obsługuje Contao Managera.","ui.setup.create-project.themeWarning":"Contao Manager nie może stwierdzić, czy ten motyw jest kompatybilny z Twoim serwerem. Prosimy skontaktować się z dostawcą motywu, jeśli masz jakiekolwiek pytania.","ui.setup.create-project.themeTitle":"Przejrzyj szczegóły motywu","ui.setup.create-project.themeDetails":"Następujące zależności i pliki zostaną zainstalowane wraz z tym motywem.","ui.setup.create-project.themeRequire":"{count} Zależności | {count} Zależności","ui.setup.create-project.themeFiles":"{count} Plik | {count} Pliki","ui.setup.create-project.theme.or":"lub wyszukaj publiczne motywy","ui.setup.create-project.theme.search":"Wyszukiwanie motywów","ui.setup.create-project.theme.more":"Więcej motywów","ui.setup.create-project.theme.empty":"Brak motywów pasujących do {query}","ui.setup.create-project.theme.uploaded":"Plik motywu został pomyślnie przesłany.","ui.setup.create-project.theme.packageName":"Nazwa pakietu","ui.setup.create-project.theme.version":"Wersja","ui.setup.create-project.theme.authors":"Autor(zy)","ui.setup.create-project.theme.upload":"Uploading {name} ({size})","ui.setup.create-project.install":"Instalacja","ui.setup.create-project.cancel":"Anuluj","ui.setup.create-project.fileError":"Could not find composer.json in {file}.","ui.setup.create-project.jsonError":"composer.json contains invalid JSON.","ui.setup.create-project.schemaError":"composer.json schema validation failed.","ui.setup.database-connection.headline":"Połączenie z bazą danych","ui.setup.database-connection.description":"Contao wymaga bazy danych MySQL (lub kompatybilnego forka jak MariaDB) do przechowywania stron, treści, użytkowników i innych danych relacyjnych. Parametry połączenia są przechowywane w pliku {env} w katalogu głównym twojej instalacji Contao.","ui.setup.database-connection.formTitle":"Parametry połączenia","ui.setup.database-connection.formText":"Podaj adres URL bazy danych lub wypełnij osobno pola nazwa użytkownika, hasło, serwer i baza danych.","ui.setup.database-connection.url":"URL bazy danych","ui.setup.database-connection.validUrl":"URL bazy danych jest nieprawidłowy lub połączenie z serwerem nie powiodło się.","ui.setup.database-connection.or":"lub","ui.setup.database-connection.user":"Nazwa użytkownika","ui.setup.database-connection.password":"Hasło","ui.setup.database-connection.server":"Serwer (:Port)","ui.setup.database-connection.database":"Nazwa bazy danych","ui.setup.database-connection.connected":"Pomyślnie połączono z bazą danych {database} na {server}.","ui.setup.database-connection.error":"Błąd połączenia z bazą danych.","ui.setup.database-connection.problem":"Contao wykrył problem z serwerem bazy danych.","ui.setup.database-connection.schemaTitle":"Schemat bazy danych","ui.setup.database-connection.migration":"Jest jedna oczekująca migracja. | Jest {count} oczekujących migracji.","ui.setup.database-connection.schema":"Istnieje jedna oczekująca aktualizacja schematu. | Istnieje {count} oczekujących aktualizacji schematu.","ui.setup.database-connection.noChanges":"Schemat Twojej bazy danych jest aktualny.","ui.setup.database-connection.check":"Sprawdź bazę danych","ui.setup.database-connection.skip":"Pomiń","ui.setup.database-connection.save":"Zapisz","ui.setup.database-connection.change":"Zmień dane dostępowe","ui.setup.database-connection.restoreTitle":"Import bazy danych","ui.setup.database-connection.restoreText":"Temat, który właśnie zainstalowałeś, zawiera kopię zapasową bazy danych. Przywróć bazę danych, aby zaimportować dane motywu, lub pomini ten krok, aby rozpocząć instalację Contao od nowa. | Temat, który właśnie zainstalowałeś, zawiera wiele kopii zapasowych bazy danych. Wybierz plik kopii zapasowej do zaimportowania danych motywu lub pomiń ten krok, aby rozpocząć instalację Contao od nowa.","ui.setup.database-connection.backup":"Zrób kopię zapasową bieżącej bazy danych przed importem","ui.setup.database-connection.backupWarning":"Wszystkie dane w bazie danych zostaną nadpisane podczas importu! Jeśli baza danych nie jest pusta, utwórz najpierw kopię zapasową.","ui.setup.database-connection.restore":"Importuj bazę danych motywu","ui.setup.database-connection.restoreOption":"Kopia zapasowa z {date} ({size})","ui.setup.database-connection.restored":"Twoja baza danych motywu została pomyślnie zaimportowana. Kontynuuj walidację schematu bazy danych.","ui.setup.backend-user.success":"W Twojej bazie danych znaleziono konto administratora Contao. Użyj Contao, aby dodać więcej użytkowników.","ui.setup.backend-user.error":"Nie można pobrać listy użytkowników. Sprawdź wynik konsoli w celu uzyskania szczegółów.","ui.setup.backend-user.headline":"Konto użytkownika","ui.setup.backend-user.description":"Aby zarządzać swoją stroną internetową, musisz mieć co najmniej jedno konto administratora w Contao. Należy pamiętać, że to konto nie jest powiązane z Contao Manager.","ui.setup.backend-user.formTitle":"Utwórz konto","ui.setup.backend-user.formText":"Proszę wprowadzić dane dla nowego konta backend.","ui.setup.backend-user.username":"Nazwa użytkownika","ui.setup.backend-user.name":"Nazwa","ui.setup.backend-user.email":"Adres e-mail","ui.setup.backend-user.emailInvalid":"Wprowadź prawidłowy adres e-mail","ui.setup.backend-user.password":"Hasło","ui.setup.backend-user.passwordPlaceholder":"min 8 znaków","ui.setup.backend-user.passwordLength":"Wprowadź przynajmniej 8 znaków.","ui.setup.backend-user.create":"Dodaj konto","ui.task.headline":"Zadanie w Tle","ui.task.loading":"Ładowanie szczegółów ...","ui.task.created":"Ładowanie szczegółów ...","ui.task.active":"Czekaj, dopóki trwa wykonywanie zadań w tle przez Contao Manager.","ui.task.complete":"Wszystkie operacje wykonane poprawnie. Sprawdź szczegóły w treści konsoli.","ui.task.paused":"Operacja w tle niespodziewanie przestała pracować. Sprawdź szczegóły w konsoli.","ui.task.aborting":"Czekaj, dopóki trwa anulowanie operacji w tle.","ui.task.stopped":"Niektóre operacje w tle zostały anulowane. Zobacz szczegóły w konsoli.","ui.task.error":"Operacja w tle niespodziewanie przestała pracować. Sprawdź szczegóły w konsoli.","ui.task.failed":"Contao Manager nie mógł uruchomić zadania w tle!","ui.task.failedDescription1":"Coś poszło źle podczas próby wykonania operacji w tle.","ui.task.failedDescription2":"Jeśli sytuacja się powtórzy, być może twój serwer nie ma wsparcia.","ui.task.reportProblem":"Zgłoś problem","ui.task.pausedDescription":"Click \\"Continue\\" if you want to ignore the error and execute the remaining operations.","ui.task.sponsor":"Composer Cloud sponsorowane przez {sponsor}","ui.task.buttonAudit":"Aktualizacja Bazy Danych","ui.task.buttonClose":"Zamknij","ui.task.buttonConfirm":"Potwierdź i zamknij","ui.task.buttonContinue":"Kontynuuj","ui.task.buttonCancel":"Anuluj","ui.task.confirmCancel":"Czy na pewno chcesz anulować to zadanie? To może pozostawić twoją instalację w nieznanym stanie.","ui.task.autoclose":"Zamknij szczegóły zadania, gdy udane","ui.console.toggle":"Pokaż/Ukryj Konsolę","ui.console.showLog":"Pokaż pełny dziennik konsoli","ui.console.copyLog":"Skopiuj dziennik do schowka","ui.migrate.headline":"Aktualizacje bazy danych","ui.migrate.migrationsOnly":"(tylko migracje)","ui.migrate.schemaOnly":"(tylko struktura)","ui.migrate.loading":"Proszę czekać, sprawdzamy twoją bazę danych …","ui.migrate.empty":"Nie znaleziono żadnych oczekujących migracji ani aktualizacji schematów. Twoja baza danych jest aktualna.","ui.migrate.emptyMigrations":"Nie znaleziono żadnych oczekujących migracji. Upewnij się, że sprawdziłeś również aktualizacje schematu.","ui.migrate.emptySchema":"Nie znaleziono oczekujących aktualizacji schematu. Upewnij się, że sprawdzisz również migracje.","ui.migrate.pending":"Twoja baza danych nie jest aktualna. Proszę przejrzyj poniższe wyjście konsoli i wykonaj zmiany.","ui.migrate.previousChanges":"Poprzednia migracja bazy danych nie została potwierdzona.\\nProszę przejrzeć poniższe wyniki konsoli, a następnie kontynuować, aby zobaczyć kolejne zmiany.","ui.migrate.previousComplete":"Poprzednia migracja bazy danych nie została potwierdzona, proszę sprawdzić poniższe wyniki konsoli.\\nNie ma więcej oczekujących zmian.","ui.migrate.appliedChanges":"Aktualizacje bazy danych zostały zastosowane.\\nProszę przejrzeć poniższe wyjście konsoli, a następnie kontynuować, aby zobaczyć kolejne zmiany.","ui.migrate.appliedComplete":"Baza danych została zaktualizowana.\\nNie ma więcej oczekujących migracji ani aktualizacji schematu. Twoja baza danych jest aktualna.","ui.migrate.problem":"Contao wykrył problem z serwerem bazy danych.\\nProszę przejrzyj poniżej wynik konsoli, aby dowiedzieć się, co należy naprawić. | Contao wykrył problemy z serwerem bazy danych.\\nProszę przejrzyj poniżej wynik konsoli, aby dowiedzieć się, co należy naprawić.","ui.migrate.warning":"Contao wykrył błędną konfigurację serwera bazy danych.\\nOstrzeżenia można tymczasowo pominąć, ale należy je naprawić dla optymalnej wydajności i integralności danych.","ui.migrate.error":"Zmiany nie mogły zostać zastosowane. Twoja baza danych mogła zostać zmieniona, sprawdź ponownie, aby ponowić próbę.","ui.migrate.execute":"Wykonaj","ui.migrate.close":"Zamknij","ui.migrate.confirm":"Potwierdź i zamknij","ui.migrate.cancel":"Anuluj","ui.migrate.continue":"Kontynuuj","ui.migrate.setup":"Instalacja","ui.migrate.skip":"Pomiń","ui.migrate.retry":"Sprawdź ponownie","ui.migrate.retryAll":"Sprawdź wszystkie","ui.migrate.withDeletes":"Wykonaj wszystkie zmiany w bazie danych, włączając zapytania DROP.","ui.migrate.migrationTitle":"Migracje baz danych","ui.migrate.schemaTitle":"Aktualizacje schematu","ui.migrate.problemTitle":"Problemy z bazą danych","ui.migrate.warningTitle":"Ostrzeżenia bazy danych","ui.migrate.addTable":"Dodaj tabelę {table}","ui.migrate.dropTable":"Usuń tabelę {table}","ui.migrate.addField":"Dodaj pole {table}.{field}","ui.migrate.changeField":"Zmień pole {table}.{field}","ui.migrate.dropField":"Usuń pole {table}.{field}","ui.migrate.createIndex":"Utwórz indeks \\"{name}\\" w {table}","ui.migrate.dropIndex":"Usuń indeks \\"{name}\\" w {table}","ui.widget.mandatory":"To pole nie może być puste.","ui.widget.blankOption":"Proszę wybrać …","ui.widget.showPassword":"Pokaż hasło","ui.widget.hidePassword":"Ukryj hasło","ui.error.title":"Żądanie HTTP dla \\"{method}{url}\\" nie powiodło się.","ui.error.server500":"Wygląda na to, że wystąpił nieoczekiwany błąd na twoim serwerze. Sprawdź dziennik zdarzeń serwera www (Apache/Nginx) oraz dziennik Contao Manager w \\"contao-manager/logs\\".","ui.error.response":"Serwer zwrócił odpowiedź z kodem {status}.","ui.error.moreLink":"Więcej informacji","ui.error.support":"Wsparcie Contao","ui.error.permission":"You do not have permission to use this feature.","ui.footer.help":"Pomoc","ui.footer.reportProblem":"Zgłoś problem","ui.navigation.discover":"Odkrywaj","ui.navigation.packages":"Pakiety","ui.navigation.tools":"Narzędzia","ui.navigation.installTool":"Instalator","ui.navigation.backend":"Contao Backend","ui.navigation.debug":"Contao Tryb Debug","ui.navigation.logViewer":"Czytnik logów","ui.navigation.phpinfo":"Informacja PHP","ui.navigation.phpinfoLoading":"Ładowanie informacji PHP…","ui.navigation.maintenance":"Konserwacja","ui.navigation.rebuildCache":"Przebuduj cache","ui.navigation.users":"Accounts","ui.navigation.systemCheck":"Sprawdzenie Systemu","ui.navigation.advanced":"Zaawansowane","ui.navigation.logout":"Wyloguj","ui.maintenance.database.title":"Bazy danych Migracje i Kopie Zapasowe","ui.maintenance.database.description":"Migracje baz danych zapewniają spójność danych i schematów tabel.","ui.maintenance.database.migrations":"Jedna oczekująca migracja bazy danych | {count} oczekujących migracji bazy danych","ui.maintenance.database.schemaUpdates":"Jedna oczekująca aktualizacja schematu | {count} oczekujące aktualizacje schematu","ui.maintenance.database.error":"Problem z bazą danych został znaleziony.","ui.maintenance.database.warning":"Wykryto ostrzeżenia w bazie danych.","ui.maintenance.database.button":"Sprawdź bazę danych","ui.maintenance.database.migrationOnly":"Sprawdź tylko migracje","ui.maintenance.database.schemaOnly":"Sprawdź tylko strukturę","ui.maintenance.database.installTool":"Otwórz instalator","ui.maintenance.database.createBackup":"Utwórz kopię zapasową","ui.maintenance.database.backupUnsupported":"Kopie zapasowe bazy danych nie są obsługiwane przez Twoją wersję Contao.","ui.maintenance.database.backupList":"Masz jedno kopię zapasową bazy danych, utworzoną {date}. | Masz {count} kopii zapasowych bazy danych, najnowsza została utworzona {date}.","ui.maintenance.database.backupEmpty":"Nie masz obecnie żadnych kopii zapasowych bazy danych.","ui.maintenance.rebuildCache.title":"Cache Aplikacji","ui.maintenance.rebuildCache.description":"Przebudowanie cache\'u aplikacji jest wymagane po jakichkolwiek modyfikacjach plików konfiguracyjnych.","ui.maintenance.rebuildCache.rebuildProd":"Przebuduj Cache Production","ui.maintenance.rebuildCache.rebuildDev":"Przebuduj Cache Development","ui.maintenance.rebuildCache.clearProd":"Wyczyść Cache Production","ui.maintenance.rebuildCache.clearDev":"Wyczyść Cache Development","ui.maintenance.installTool.title":"Instalator Contao","ui.maintenance.installTool.description":"Instalator Contao jest automatycznie blokowany jeśli wprowadzisz błędne hasło trzy razy z rzędu.","ui.maintenance.installTool.unlock":"Odblokuj instalator","ui.maintenance.installTool.lock":"Zablokuj instalator","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"Autoloader Composera jest odpowiedzialny za ładowanie klas PHP. Autoloader musi być odświeżony po dodaniu własnych namespace\'ów do pliku composer.json.","ui.maintenance.dumpAutoload.button":"Odśwież Autoloader","ui.maintenance.composerInstall.title":"Pakiety Composera","ui.maintenance.composerInstall.description":"Zależności Composer\'a są umieszczone w folderze {vendor} w głównym katalogu aplikacji. Przeinstalowanie zależności może być konieczne po zmianach lub ręcznym wgraniu pliku {composerLock}.","ui.maintenance.composerInstall.button":"Uruchom Instalator","ui.maintenance.composerInstall.update":"Uruchom Composer Update","ui.maintenance.composerCache.title":"Cache Composera","ui.maintenance.composerCache.description":"Composer cache\'uje pobrane pakiety w celu lepszej wydajności. Jeśli masz problemy z zepsutymi plikami, spróbuj usunąć cache Composera, aby wymusić nowe pobranie plików.","ui.maintenance.composerCache.button":"Wyczyść Cache","ui.maintenance.maintenanceMode.title":"Tryb konserwacji","ui.maintenance.maintenanceMode.description":"Przełączenie Contao w tryb konserwacji spowoduje wyświetlenie szablonu \\"503 Service Unavailable\\" dla strony internetowej.","ui.maintenance.maintenanceMode.enable":"Włącz","ui.maintenance.maintenanceMode.disable":"Wyłącz","ui.maintenance.debugMode.title":"Tryb Debug","ui.maintenance.debugMode.description":"Aktywuj tryb diagnostyczny podając nazwę użytkownika i hasło do {appDevPhp} punktu dostępowego.","ui.maintenance.debugMode.descriptionJwt":"Aktywuj tryb debug poprzez ustawienie ciasteczka debug dla obecnej domeny.","ui.maintenance.debugMode.activate":"Aktywuj","ui.maintenance.debugMode.deactivate":"Deaktywuj","ui.maintenance.debugMode.credentials":"Uwierzytelnianie","ui.maintenance.debugMode.user":"Proszę wprowadzić nazwę użytkownika dla trybu debug.","ui.maintenance.debugMode.password":"Proszę wprowadzić hasło dla trybu debug.","ui.maintenance.opcodeCache.title":"Cache Opcode","ui.maintenance.opcodeCache.description":"Opcode cache\'uje pliki PHP procesu web w celu szybszego ich wykonywania. Cache musi zostać usunięty w pewnych okolicznościach, jeśli pliki nie są rozpoznawane po ich zmianie.","ui.maintenance.opcodeCache.button":"Wyczyść Cache","ui.maintenance.safeMode":"Niedostępne w Bezpiecznym Trybie","ui.maintenance.unsupported":"Niewspierane przez twoją wersję Contao","ui.packages.updateButton":"Zaktualizuj pakiety","ui.packages.searchButton":"Szukaj Pakietów","ui.packages.searchPlaceholder":"Szukaj pakietów …","ui.packages.uploadOverlay":"Przeciągnij i upuść pliki","ui.packages.uploadButton":"Wgraj pakiety","ui.packages.uploadMessage":"Masz jedną niepotwierdzoną wysyłkę. | Masz {count} niepotwierdzonych wysyłek.","ui.packages.uploadApply":"Potwierdź pliki","ui.packages.uploadReset":"Usuń pliki","ui.packages.uploadIncomplete":"Ten plik nie został wgrany całkowicie. Usuń go i spróbuj ponownie.","ui.packages.uploadDuplicate":"Ten plik wygląda na wgrany kilka razy. Usuń duplikaty.","ui.packages.uploadInstalled":"Ten plik jest już zainstalowany. Usuń duplikaty.","ui.packages.uploadUnsupported":"Przesyłki nie są obsługiwane w Twojej instalacji. Upewnij się, że rozszerzenie PHP ZIP jest zainstalowane i zaktualizuj swoje zależności.","ui.packages.changesMessage":"Masz jedną niepotwierdzoną zmianę. | Masz {count} niepotwierdzonych zmian.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"Zapisz zmiany","ui.packages.changesApplyAll":"Zaktualizuj wszystkie pakiety","ui.packages.changesDryrunAll":"Próbnie zaktualizuj wszystkie pakiety","ui.packages.changesReset":"Zresetuj zmiany","ui.packages.changesReview":"Zapisz Zmiany","ui.packagelist.loading":"Ładowanie …","ui.packagelist.uploads":"Wgrane pliki","ui.packagelist.added":"Nowe pakiety","ui.packagelist.installed":"Zainstalowane pakiety","ui.package.hintRevert":"Cofnij zmiany","ui.package.hintNoupdate":"Nie aktualizuj","ui.package.hintConstraint":"Ten pakiet zostanie zainstalowany z wymogiem {constraint} kiedy zapiszesz zmiany.","ui.package.hintConstraintBest":"Ten pakiet zostanie zainstalowany w najlepszej możliwej wersji kiedy zapiszesz zmiany.","ui.package.hintConstraintChange":"Wymóg dla tego pakietu zostanie zmieniony z \\"{from}\\" do \\"{to}\\" kiedy zapiszesz zmiany.","ui.package.hintConstraintUpdate":"Ten pakiet zostanie zaktualizowany, kiedy zapiszesz zmiany.","ui.package.hintAdded":"Ten pakiet zostanie zainstalowana, kiedy zapiszesz zmiany.","ui.package.hintRemoved":"Ten pakiet zostanie usunięty kiedy zapiszesz zmiany.","ui.package.requiredTitle":"dodane ręcznie","ui.package.requiredText":"Ten pakiet jest jako wymagany w pliku composer.json, ale nie jest zainstalowany.","ui.package.removedTitle":"usunięte ręcznie","ui.package.removedText":"Ten pakiet został usunięty z twojego composer.json.","ui.package.installed":"Obecnie zainstalowane:","ui.package.version":"Wersja {version}","ui.package.additionalDownloads":"{count} Pobranie | {count} Pobrania","ui.package.additionalStars":"{count} Gwiazdka | {count} Gwiazdki","ui.package.editConstraint":"Edytuj","ui.package.uploadConstraint":"To ograniczenie zdefiniowane jest przez przesłany pakiet.","ui.package.updateButton":"Aktualizuj","ui.package.removeButton":"Usuń","ui.package.installButton":"Dodaj Pakiet","ui.package.installButtonShort":"Dodaj","ui.package.detailsButton":"Szczegóły","ui.package.latestConstraint":"ostatnia wersja","ui.package.update":"Dostępna aktualizacja","ui.package.updateLatest":"ostatnia wersja","ui.package.updateAvailable":"{version} dostępna","ui.package.updateUnknown":"nieznana wersja","ui.package.updateConstraint":"Dostępna jest nowsza wersja spoza ograniczenia wersji Twojego oprogramowania.","ui.package.incompatible":"{package} does not work with Contao {constraint}.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Wersja {version}","ui.cloudStatus.waitingTime":"Czas Oczekiwania","ui.cloudStatus.jobs":"Aktualne Zadania","ui.cloudStatus.workers":"Workers","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"żaden","ui.cloudStatus.short":"ok. {minutes} min","ui.cloudStatus.long":"ok. {minutes} min {seconds} sek","ui.cloudStatus.error":"Nie udało się uzyskać stanu Composer Resolver Cloud. Może być w trakcie serwisowania lub ma awarię.","ui.cloudStatus.button":"Status Chmury","ui.cloudStatus.refresh":"Odśwież Status Chmury","ui.log-viewer.loading":"Ładowanie …","ui.log-viewer.empty":"Nie ma plików dziennika na Twoim serwerze.","ui.log-viewer.reload":"Odśwież","ui.log-viewer.file":"Plik logów","ui.log-viewer.channel":"Kanał","ui.log-viewer.channelTitle":"Kanał, do którego została zapisana ta wiadomość.","ui.log-viewer.level":"Poziom","ui.log-viewer.levelTitle":"Ważność wiadomości log.","ui.log-viewer.timeHeader":"Czas","ui.log-viewer.messageHeader":"Wiadomość","ui.log-viewer.showContext":"Pokaż kontekst","ui.log-viewer.hideContext":"Ukryj kontekst","ui.log-viewer.showExtra":"Pokaż Dodatkowe","ui.log-viewer.hideExtra":"Ukryj Dodatkowe","ui.log-viewer.more":"Wczytaj więcej ...","ui.log-viewer.download":"Pobierz","ui.log-viewer.downloadTitle":"Pobierz plik \\"{file}\\"","ui.log-viewer.prodEnvironment":"Środowisko produkcyjne","ui.log-viewer.devEnvironment":"Środowisko deweloperskie (tryb debugowania)","ui.user-manager.loading":"Loading users …","ui.user-manager.changePassword":"Change Password","ui.user-manager.setupTotp":"Setup Two-Factor Authentication","ui.user-manager.disableTotp":"Disable Two-Factor Authentication","ui.user-manager.invite":"Invite User","ui.user-manager.delete":"Delete","ui.user-manager.deleteConfirm":"Do you really want to delete user \\"{username}\\"?","ui.user-manager.deleted":"User {username} deleted successfully","ui.user-manager.passwordHeadline":"Change Password","ui.user-manager.passwordText":"To change your password, please enter the current and a new password in the respective fields.","ui.user-manager.currentPassword":"Current password","ui.user-manager.newPassword":"New password","ui.user-manager.passwordPlaceholder":"min 8 znaków","ui.user-manager.submitPassword":"Submit","ui.user-manager.passwordChanged":"Your password has been changed successfully.","ui.user-manager.passwordError":"This password is incorrect.","ui.user-manager.inviteHeadline":"Invite User","ui.user-manager.inviteText":"If you need multiple logins for the Contao Manager, you can create an invitation link here. Share this link with someone or use it on another device to create a new account with the given permissions.","ui.user-manager.inviteSuccess1":"A new invitation link was created. The URL below can be used to create a new user account for this Contao Manager. The invitation expires on {expires} (one week from now).","ui.user-manager.inviteSuccess2":"Please copy the link to your clipboard. It will only work once and you will not be able to see it again after closing this dialog.","ui.user-manager.createInvitation":"Create Invitation Link","ui.user-manager.clipboard":"Copy to clipboard","ui.user-manager.permissions":"Learn about permissions","ui.user-manager.cancel":"Anuluj","ui.user-manager.close":"Zamknij","ui.user-manager.you":"You","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"Two-Factor Authentication","ui.totp.setupQr":"Please scan the QR code with your 2FA/TOTP app.","ui.totp.setupCode":"If you cannot scan the QR code, enter this key instead:","ui.totp.codeLabel":"Verification code","ui.totp.codeDescription":"Please enter the verification code generated by your 2FA/TOTP app.","ui.totp.disableText":"Please enter the verification code to disable two-factor authentication.","ui.totp.invalid":"The verification code is invalid.","ui.totp.enable":"Włącz","ui.totp.disable":"Wyłącz","ui.totp.cancel":"Anuluj","ui.totp.enabled":"Two-factor authentication was enabled successfully.","ui.totp.disabled":"Two-factor authentication was disabled successfully.","ui.totp.setup":"Setup Two-Factor Authentication","ui.totp.skip":"Skip Two-Factor Authentication"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[643],{6643:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Osäker anslutning !!","ui.app.httpsDescription":"Utan HTTPS kommer din konfidentiella data att överföras okrypterad.","ui.app.httpsLink":"Mer information","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Säkert läge aktiverat !!","ui.app.safeModeDescription":"Vissa funktioner i Contao Manager är inte tillgängliga.","ui.app.safeModeExit":"Avsluta felsäkert läge","ui.app.limitedHeadline":"Fjärrautentisering","ui.app.limitedDescription":"Du har begränsade behörigheter på grund av lösenordslös inloggning.","ui.app.limitedLogout":"Autentisera på nytt","ui.app.totpHeadline":"Säkerhetsmeddelande","ui.app.totpDescription":"Konfigurera tvåfaktorsautentisering nu för att säkra ditt konto.","ui.app.totpSetup":"Setup","ui.app.loading":"Laddar Contao Manager …","ui.app.apiError":"Oväntad API-status","ui.app.configSecurity1":"SÄKERHETSVARNING !!! Oskyddad konfigurationskatalog upptäcktes","ui.app.configSecurity2":"Contao Manager har upptäckt att dess konfigurationsfiler är offentligt tillgängliga. Alla operationer är inaktiverade tills katalogen är säker, annars kan en angripare komma åt känsliga data från din installation.\\n\\nFör att åtgärda det här problemet, se till att förhindra åtkomst till \\"contao-manager\\"-katalogen på din server. För att lära dig hur du gör detta, se manualen för din webbserver eller kontakta din värdleverantör.","ui.account.welcome":"Välkommen","ui.account.intro1":"Välkommen till Contao Manager, ett universellt verktyg för att installera och hantera Contao Open Source CMS. Om du är ny på det, vänligen {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} för att komma igång","ui.account.introManual":"läs manualen","ui.account.intro2":"Om du stöter på några problem, kolla {ourGithubIssues} och skapa gärna ett nytt för allt som inte har rapporterats ännu.","ui.account.introIssues":"våra GitHub-problem","ui.account.headline":"Användarkonto","ui.account.description":"För att hantera din installation, skapa ett konto för Contao Manager. Var medveten om att det här kontot inte är relaterat till Contao backend eller frontend.","ui.account.username":"Användarnamn","ui.account.password":"Lösenord","ui.account.passwordPlaceholder":"min. 8 tecken","ui.account.passwordLength":"Ange minst 8 tecken.","ui.account.loginInvalid":"Det uppstod ett fel när du skapade kontot. Vänligen försök med ett annat användarnamn.","ui.account.submit":"Skapa konto","ui.account.usePassword":"Använd lösenord för inloggning","ui.account.usePasskey":"Använd Passkey för inloggning","ui.account.totpHeadline":"Tvåfaktorsautentisering","ui.account.totpDescription":"Vänligen aktivera tvåfaktorsautentisering, vilket ger ditt konto ett extra säkerhetslager. Förutom ditt användarnamn och lösenord måste du ange en verifieringskod som genereras av en tvåfaktorsapp som 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator eller någon annan TOTP-app.","ui.account.totpSetup":"Konfigurera nu","ui.account.totpSkip":"Konfigureras senare","ui.account.login":"Avvisa inbjudan","ui.account.contribute1":"Contao och Contao Manager är sponsrade av den ideella Contao Association.","ui.account.contribute2":"Vänligen överväg att bidra till öppen källkod genom att {donate}.","ui.account.contributeDonate":"göra en donation","ui.login.headline":"Logga in","ui.login.description":"Logga in för att hantera din installation.","ui.login.username":"Användarnamn","ui.login.password":"Lösenord","ui.login.totpHeadline":"Tvåfaktorsautentisering","ui.login.totpDescription":"Ange din verifieringskod för att slutföra inloggningsprocessen.","ui.login.totp":"Verifieringskod","ui.login.forgotPassword":"Glömt ditt lösenord?","ui.login.button":"Logga in","ui.login.passkey":"Logga in med Passkey","ui.login.cancel":"Avbryt","ui.login.or":"eller","ui.login.locked":"Åtkomst har nekats eftersom Contao Manager är låst. För att låsa upp, radera {lockFile}-filen i din Contao-rotkatalog.","ui.logout.headline":"Sessionen har gått ut","ui.logout.warning":"Du har varit inaktiv i mer än 25 minuter. Av säkerhetsskäl kommer din session att avslutas inom kort.","ui.logout.expired":"Din session avslutades automatiskt eftersom du har varit inaktiv i mer än 30 minuter.","ui.logout.renew":"Håll inloggad","ui.logout.logout":"Logga ut","ui.logout.login":"Tillbaka till login","ui.oauth.error":"Ogiltigt OAuth-försök. Kontrollera request-parametrarna.","ui.oauth.https":"Omdirigerings-URI:n MÅSTE använda ett säkert protokoll (https:) för att förhindra att autentiseringstoken sänds i klartext.","ui.oauth.headline":"Fjärrautentisering","ui.oauth.description":"Följande applikation eller tjänst begär fjärråtkomst till din Contao Manager-instans.","ui.oauth.domain":"Innan du tillåter åtkomst, se till att du känner till den här webbadressen och litar på dess ägare!","ui.oauth.outOfScope":"Tyvärr har du inte de nödvändiga behörigheterna för att bevilja denna åtkomst.","ui.oauth.allow":"Tillåta åtkomst","ui.oauth.deny":"Neka åtkomst","ui.oauth.switchUser":"Växla användare","ui.scope.admin":"Admin-åtkomst inklusive användarhantering","ui.scope.install":"Installera nya paket och ändra Contao-konfigurationen","ui.scope.update":"Uppdatera paket och utföra underhållsåtgärder","ui.scope.read":"Läs paket och konfiguration","ui.boot.headline":"Systemkontroll","ui.boot.description":"Vänta, vi analyserar din server...","ui.boot.issue1":"Installationsproblem upptäcktes","ui.boot.issue2":"Din installation har problem som måste åtgärdas innan Contao Manager kan användas.","ui.boot.run":"Starta Contao Manager","ui.boot.safeMode":"Starta i felsäkert läge Safe Mode","ui.recovery.headline":"Systemåterställning","ui.recovery.description":"Contao Manager upptäckte filer som ser ut som Contao, men kommandoradsgränssnittet fungerar inte som förväntat.","ui.recovery.console":"Konsolutgång","ui.recovery.repairOptions":"Välj ett alternativ för att reparera din installation.","ui.recovery.repairHeadline":"Automatisk reparation","ui.recovery.repairDescription":"Försöker att automatiskt reparera installationen genom att bygga om programcachen och installera om Composer-paketen.","ui.recovery.repairWarning":"Eventuella ändringar av vendor-filerna kan raderas under processen!","ui.recovery.repairFailed":"Den automatiska reparationen lyckades inte. Prova felsäkert läge Safe Mode för att manuellt reparera installationen.","ui.recovery.repairButton":"Kör systemreparation","ui.recovery.safeModeHeadline":"Säkert läge Safe Mode","ui.recovery.safeModeDescription":"Att starta Contao Manager i felsäkert läge gör det möjligt att hantera paket och köra vissa underhållsuppgifter, men funktioner som förlitar sig på en fungerande Contao-installation kommer inte att vara tillgängliga.","ui.recovery.safeModeButton":"Starta i felsäkert läge Safe Mode","ui.server.pending":"Väntar …","ui.server.running":"Analyserar …","ui.server.error":"Kontrollen misslyckades på grund av ett oväntat svar från servern.","ui.server.details":"Detaljer","ui.server.prerequisite":"Checken annullerad på grund av att förutsättning saknas.","ui.server.selfUpdate.title":"Uppdateringar av Contao Manager","ui.server.selfUpdate.update":"En ny version av Contao Manager {latest} är tillgänglig.","ui.server.selfUpdate.manualUpdate":"En ny version av Contao Manager {latest} är tillgänglig. Din server stöder inte automatiska uppdateringar, ladda ner den nya versionen från {download}.","ui.server.selfUpdate.latest":"Du använder den senaste versionen {current}.","ui.server.selfUpdate.dev":"Utvecklingsbyggen stöder inte automatiska uppdateringar.","ui.server.selfUpdate.unsupported":"En ny version är tillgänglig men den stöder inte din PHP-version.","ui.server.selfUpdate.button":"Kör självuppdatering","ui.server.selfUpdate.continue":"Fortsätta","ui.server.config.title":"Serverkonfiguration","ui.server.config.setup":"Konfigurera","ui.server.config.change":"Förändra","ui.server.config.save":"Spara","ui.server.config.cancel":"Avbryt","ui.server.config.customOption":"Övrig …","ui.server.config.description":"För att köra bakgrundsuppgifter korrekt måste Contao Manager veta var man hittar PHP-kommandoradens binära filer och hur man kör kommandon separerade från webbprocessen.","ui.server.config.formTitle":"Serverkonfiguration","ui.server.config.formText":"Ange sökvägen till din PHP-binär. Se till att binären är samma PHP-version som din webbprocess.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud gör det möjligt att installera Composer-beroenden även om din server inte tillhandahåller tillräckligt med lokalt minne. Var medveten om att din paketinformation kommer att överföras till en molnserver som drivs av Contao Association.","ui.server.config.cloud":"Använd Composer Resolver Cloud","ui.server.config.cli":"PHP binär","ui.server.config.stateErrorCli":"Ingen giltig PHP-binär hittades på servern.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud stöds inte.","ui.server.config.stateSuccess":"PHP binär på {php_cli}.","ui.server.php_web.title":"PHP webbprocess","ui.server.php_web.below7":"Hittade PHP-versionen {version}. Byt till PHP 7 så snart som möjligt!","ui.server.php_web.success":"Hittade PHP-versionen {version}, inga kända problem hittades.","ui.server.php_cli.title":"PHP kommandoradsgränssnitt","ui.server.php_cli.success":"Hittade PHP-versionen {version}, inga kända problem hittades.","ui.server.composer.title":"Composer-Miljö","ui.server.composer.success":"Inga kända problem hittades.","ui.server.composer.install":"Composer-beroenden är inte installerade.","ui.server.composer.button":"Installera","ui.server.contao.title":"Contao installation","ui.server.contao.setup":"Setup","ui.server.contao.check":"Kontrollera databasen","ui.server.contao.empty":"Ingen Contao-installation har hittats.","ui.server.contao.old":"Contao version {version} är inte kompatibel med Contao Manager, uppdatera din installation manuellt.","ui.server.contao.found":"Hittade Contao {version} (API-version {api}).","ui.server.contao.connectionError":"Det går inte att ansluta till databasservern.","ui.server.contao.connectionProblem":"Databasproblem hittades.","ui.server.contao.missingUser":"Administratörskonto hittades inte.","ui.setup.continue":"Fortsätta","ui.setup.manager":"Starta Contao Manager","ui.setup.cancel":"Avbryt","ui.setup.welcome":"Välkommen","ui.setup.welcome1":"Den här guiden tar dig igenom de nödvändiga stegen för att konfigurera din Contao Open Source CMS-installation.","ui.setup.welcome2":"Om du har några frågor kan du hitta dokumentation, forum, en Slack-kanal och mer på sidan {support}.","ui.setup.support":"community support","ui.setup.start":"Komma igång","ui.setup.complete":"Grattis!","ui.setup.complete1":"Contao {version} har installerats.","ui.setup.complete2":"För att avsluta installationsprocessen, öppna installationsverktyget för att konfigurera databasanslutningen och skapa en backend-användare.","ui.setup.complete3":"Du kan nu börja skapa din webbplats i Contaos back end. Om du behöver ytterligare tillägg, fortsätt till Contao Manager.","ui.setup.installTool":"Öppna installationsverktyget","ui.setup.login":"Logga in på Contao","ui.setup.funding":"Fri programvara är \\"fri\\" som i \\"yttrandefritt\\", inte som i \\"gratis öl\\". Ett Open Source-projekt som Contao kräver summor pengar som inte kan samlas in av en enda person eller företag.\\nOm du har en webbplats eller säljer webbplatser byggda med Contao, skulle vi gärna se att du bidrar ekonomiskt till den produkt som ditt företag är beroende av.","ui.setup.fundingLink":"Läs mer","ui.setup.document-root.headline":"Webserverinstallation","ui.setup.document-root.warning":"För att installera Contao via Contao Manager måste du fixa dokumentroten på webbservern.","ui.setup.document-root.description1":"Contao använder en separat mapp för offentliga filer, programfiler installeras i dess överordnade mapp. Contao kan inte installeras om mappstrukturen inte är korrekt eller om mapparna inte är tomma.","ui.setup.document-root.description2":"Om du inte vet hur du konfigurerar din dokumentrot, läs Contao-dokumentationen eller kontakta din värdleverantör.","ui.setup.document-root.documentation":"Läs dokumentationen","ui.setup.document-root.conflictsTitle":"Installationskatalogen är inte tom","ui.setup.document-root.conflictsDirectory":"Rotkatalogen för din framtida Contao-installation är inte tom, vi har hittat {count} fil(er) som kan skrivas över av installationsprocessen. Det rekommenderas att skapa en tom katalogstruktur för Contao, men du kan också ta bort följande filer och kontrollera igen om du är säker på att de är oanvända.","ui.setup.document-root.ignoreConflicts":"Jag vill installera Contao i den icke-tomma katalogen. Jag förstår att detta kan skriva över alla befintliga filer på mitt webbutrymme.","ui.setup.document-root.check":"Kolla igen","ui.setup.document-root.create":"Skapa kataloger","ui.setup.document-root.change":"Byt kataloger","ui.setup.document-root.formTitle":"Kataloginställningar","ui.setup.document-root.formText1":"Contao Manager kan automatiskt skapa en ny katalogstruktur på servern.","ui.setup.document-root.formText2":"Du måste konfigurera den nya dokumentroten manuellt (t.ex. via en värdadministratörspanel).","ui.setup.document-root.autoconfig":"Jag förstår att jag måste ändra min serverkonfiguration. Att inte konfigurera dokumentroten kommer att bryta Contao Manager och exponera konfigurationsfiler (inklusive kontodetaljer och lösenord)!","ui.setup.document-root.directory":"Ny katalog","ui.setup.document-root.currentRoot":"Aktuell dokumentrot","ui.setup.document-root.newRoot":"Ny dokumentrot","ui.setup.document-root.finish":"Installera kataloger","ui.setup.document-root.publicDir":"Använd {dir} för offentliga filer (för Contao {version})","ui.setup.document-root.directoryInvalid":"Vänligen ange ett giltigt katalognamn.","ui.setup.document-root.directoryExists":"Vänligen ange ett giltigt katalognamn.","ui.setup.document-root.confirmation":"Contao Manager har skapat den nödvändiga katalogen för din Contao-installation. Du måste nu konfigurera dokumentroten på din webbserver. Ladda inte om den här sidan förrän då.","ui.setup.document-root.reload":"Ladda om sidan","ui.setup.document-root.success":"Katalogstrukturen på din webbserver är korrekt inställd!","ui.setup.document-root.installingProjectDir":"Programfiler kommer att installeras i {dir}.","ui.setup.document-root.installingPublicDir":"Offentliga filer kommer att installeras i {dir}.","ui.setup.document-root.installedProjectDir":"Programfiler installeras i {dir}.","ui.setup.document-root.installedPublicDir":"Offentliga filer installeras i {dir}.","ui.setup.create-project.headline":"Contao installation","ui.setup.create-project.description":"Contao-utvecklingen följer principen för {semver}, en ny minor version släpps var sjätte månad. De utgåvor som för närvarande stöds är:","ui.setup.create-project.semver":"Semantisk versionering","ui.setup.create-project.latestTitle":"Senast","ui.setup.create-project.ltsTitle":"Långtidssupport","ui.setup.create-project.latestQ1":"Vår senaste version erbjuder de flesta funktionerna med support fram till februari {year}.","ui.setup.create-project.latestQ3":"Vår senaste version erbjuder de flesta funktionerna med support fram till augusti {year}.","ui.setup.create-project.ltsText":"Vår nuvarande LTS-version, om du fokuserar på stabilitet. Erbjuder långsiktig support till februari {year}.","ui.setup.create-project.pltsText":"Den tidigare LTS-versionen har fortfarande långtidssupport fram till februari {year}.","ui.setup.create-project.requiresPHP":"Kräver minst PHP {version}, du har PHP {current}.","ui.setup.create-project.releaseplan":"Se {contaoReleasePlan} för detaljerad information.","ui.setup.create-project.releaseplanLink":"Contao Release Plan","ui.setup.create-project.installed":"Contao {version} har installerats på servern. Fortsätt att ställa in din databas eller starta Contao Manager för att installera en annan version.","ui.setup.create-project.formTitle":"Välj en distribution","ui.setup.create-project.formText":"Välj vilken version som ska installeras.","ui.setup.create-project.version":"Version","ui.setup.create-project.demo":"Installera Contaos demowebbplats","ui.setup.create-project.demoDescription":"Demowebbplatsen hjälper dig att bli bekant med Contao och alla dess kärnfunktioner. Fler teman finns i {butiken}.","ui.setup.create-project.coreOnly":"Minimal installation (endast kärna core)","ui.setup.create-project.noUpdate":"Hoppa över installationen (endast experter!)","ui.setup.create-project.theme":"Contao Theme","ui.setup.create-project.themeInstall":"För att installera ett Contao-tema, använd sökingången eller ladda upp en temafil (.cto/.zip) som stöder installation via Contao Manager.","ui.setup.create-project.themeBuy":"Se till att besöka den officiella {butiken}.","ui.setup.create-project.themeStore":"Contao Themes Store","ui.setup.create-project.themeUpload":"Ladda upp temafil (.cto/.zip)","ui.setup.create-project.themeInvalid":"Den uppladdade filen är inte ett Contao-tema eller stöder inte Contao Manager.","ui.setup.create-project.themeWarning":"Contao Manager kan inte avgöra om detta tema är kompatibelt med din server. Kontrollera med temaleverantören om du har några frågor.","ui.setup.create-project.themeTitle":"Granska temadetaljer","ui.setup.create-project.themeDetails":"Följande beroenden och filer kommer att installeras med detta tema.","ui.setup.create-project.themeRequire":"{count} beroenden | {count} beroenden","ui.setup.create-project.themeFiles":"{count} Fil | {count} filer","ui.setup.create-project.theme.or":"eller sök efter offentliga teman","ui.setup.create-project.theme.search":"Sök teman","ui.setup.create-project.theme.more":"Fler teman","ui.setup.create-project.theme.empty":"Inga teman matchar {query}","ui.setup.create-project.theme.uploaded":"Temafilen laddades upp.","ui.setup.create-project.theme.packageName":"Paketnamn","ui.setup.create-project.theme.version":"Version","ui.setup.create-project.theme.authors":"Författare","ui.setup.create-project.theme.upload":"Uploading {name} ({size})","ui.setup.create-project.install":"Installera","ui.setup.create-project.cancel":"Avbryt","ui.setup.create-project.fileError":"Could not find composer.json in {file}.","ui.setup.create-project.jsonError":"composer.json contains invalid JSON.","ui.setup.create-project.schemaError":"composer.json schema validation failed.","ui.setup.database-connection.headline":"Databasanslutning","ui.setup.database-connection.description":"Contao kräver en MySQL-databas (eller en kompatibel databas som MariaDB) för att lagra sidor, innehåll, användare och annan relationsdata. Anslutningsparametrar lagras i filen {env} i projektroten för din Contao-installation.","ui.setup.database-connection.formTitle":"Anslutningsparametrar","ui.setup.database-connection.formText":"Ange en databas-URL eller fyll i användarnamn, lösenord, server och databasfält separat.","ui.setup.database-connection.url":"Databas URL","ui.setup.database-connection.validUrl":"Databas-URL är ogiltig eller anslutningen till servern misslyckades.","ui.setup.database-connection.or":"eller","ui.setup.database-connection.user":"Användarnamn","ui.setup.database-connection.password":"Lösenord","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Databas namn","ui.setup.database-connection.connected":"Ansluten till databasen {database} på {server}.","ui.setup.database-connection.error":"Fel vid anslutning till databasen.","ui.setup.database-connection.problem":"Contao har upptäckt ett problem med din databasserver.","ui.setup.database-connection.schemaTitle":"Databasschema","ui.setup.database-connection.migration":"Det finns en väntande migrering. | Det finns {count} väntande migreringar.","ui.setup.database-connection.schema":"Det finns en väntande schemauppdatering. | Det finns {count} väntande schemauppdateringar.","ui.setup.database-connection.noChanges":"Ditt databasschema är uppdaterat.","ui.setup.database-connection.check":"Kontrollera databasen","ui.setup.database-connection.skip":"Hoppa över","ui.setup.database-connection.save":"Spara","ui.setup.database-connection.change":"Ändra autentiseringsuppgifter","ui.setup.database-connection.restoreTitle":"Databasimport","ui.setup.database-connection.restoreText":"Temat du just installerade innehåller en databassäkerhetskopiering. Återställ databasen för att importera temadata eller hoppa över detta steg för att börja med en tom Contao-installation. | Temat du just installerade innehåller flera säkerhetskopior av databaser. Välj en säkerhetskopia för att importera temadata eller hoppa över det här steget för att börja med en tom Contao-installation.","ui.setup.database-connection.backup":"Säkerhetskopiera aktuell databas före import","ui.setup.database-connection.backupWarning":"All data i databasen kommer att skrivas över vid import! Skapa en säkerhetskopia först om databasen inte är tom.","ui.setup.database-connection.restore":"Importera temadatabas","ui.setup.database-connection.restoreOption":"Säkerhetskopiering från {date} ({size})","ui.setup.database-connection.restored":"Din temadatabas har importerats. Fortsätt att validera ditt databasschema.","ui.setup.backend-user.success":"Ett administratörskonto för Contao backend hittades i din databas. Använd Contaos backend för att lägga till fler användare.","ui.setup.backend-user.error":"Det gick inte att hämta användarlistan. Kontrollera konsolutgången för detaljer.","ui.setup.backend-user.headline":"Backend-konto","ui.setup.backend-user.description":"För att hantera din webbplats måste du ha minst ett administratörskonto för Contaos backend. Var medveten om att detta konto inte är relaterat till Contao Manager.","ui.setup.backend-user.formTitle":"Skapa konto","ui.setup.backend-user.formText":"Vänligen ange detaljerna för det nya backend-kontot.","ui.setup.backend-user.username":"Användarnamn","ui.setup.backend-user.name":"namn","ui.setup.backend-user.email":"E-postadress","ui.setup.backend-user.emailInvalid":"Vänligen ange en giltig e-postadress","ui.setup.backend-user.password":"Lösenord","ui.setup.backend-user.passwordPlaceholder":"min. 8 tecken","ui.setup.backend-user.passwordLength":"Ange minst 8 tecken.","ui.setup.backend-user.create":"Lägg till konto","ui.task.headline":"Bakgrundsuppgift","ui.task.loading":"Läser in detaljer...","ui.task.created":"Läser in detaljer...","ui.task.active":"Vänta medan Contao Manager kör uppgiftsoperationer i bakgrunden.","ui.task.complete":"Alla operationer har slutförts framgångsrikt. Kontrollera konsolutgången för detaljer.","ui.task.paused":"En bakgrundsåtgärd avbröts oväntat. Kontrollera konsolutgången.","ui.task.aborting":"Vänta medan bakgrundsåtgärderna avbryts.","ui.task.stopped":"Vissa bakgrundsoperationer avbröts. Kontrollera konsolutgången.","ui.task.error":"En bakgrundsåtgärd avbröts oväntat. Kontrollera konsolutgången.","ui.task.failed":"Contao Manager kunde inte starta en bakgrundsuppgift!","ui.task.failedDescription1":"Något gick fel när man försökte utföra åtgärder i bakgrunden.","ui.task.failedDescription2":"Om detta händer igen kanske din server inte stöds.","ui.task.reportProblem":"Rapportera ett problem","ui.task.pausedDescription":"Click \\"Continue\\" if you want to ignore the error and execute the remaining operations.","ui.task.sponsor":"Composer Cloud sponsras av {sponsor}","ui.task.buttonAudit":"Uppdatera databas","ui.task.buttonClose":"Stänga","ui.task.buttonConfirm":"Bekräfta och stäng","ui.task.buttonContinue":"Fortsätta","ui.task.buttonCancel":"Avbryt","ui.task.confirmCancel":"Är du säker på att du avbryter den här uppgiften? Detta kan lämna din Contao-installation i ett trasigt tillstånd!","ui.task.autoclose":"Stäng uppgiftsinformation om framgång","ui.console.toggle":"Visa/dölj konsol-output","ui.console.showLog":"Visa hela konsolloggen","ui.console.copyLog":"Kopiera loggen till urklipp","ui.migrate.headline":"Databasuppdateringar","ui.migrate.migrationsOnly":"(endast migrering)","ui.migrate.schemaOnly":"(endast schema)","ui.migrate.loading":"Vänta, vi kontrollerar din databas...","ui.migrate.empty":"Inga pågående migreringar eller schemauppdateringar hittades. Din databas är uppdaterad.","ui.migrate.emptyMigrations":"Inga väntande migrering hittades. Se till att även leta efter schemauppdateringar.","ui.migrate.emptySchema":"Inga väntande schemauppdateringar hittades. Se till att även kontrollera migrering.","ui.migrate.pending":"Din databas är inte uppdaterad. Granska konsolutgången nedan och verkställ ändringarna.","ui.migrate.previousChanges":"En tidigare databasmigrering har inte bekräftats.\\nGranska konsolutgången nedan och fortsätt sedan för att se nästa ändringar.","ui.migrate.previousComplete":"En tidigare databasmigrering har inte bekräftats, vänligen granska konsolutdata nedan.\\nDet finns inga fler väntande ändringar.","ui.migrate.appliedChanges":"Databasuppdateringar har tillämpats.\\nGranska konsolutgången nedan och fortsätt sedan för att se nästa ändringar.","ui.migrate.appliedComplete":"Databasuppdateringar har tillämpats.\\nDet finns inga fler väntande migreringar eller schemauppdateringar. Din databas är uppdaterad.","ui.migrate.problem":"Contao har upptäckt ett problem med din databasserver.\\nGranska konsolutgången nedan för att ta reda på vad som behöver åtgärdas. | Contao har upptäckt problem med din databasserver.\\nGranska konsolutgången nedan för att ta reda på vad som behöver åtgärdas.","ui.migrate.warning":"Contao har upptäckt en felaktig konfiguration av din databasserver.\\nVarningar kan hoppas över tillfälligt, men bör åtgärdas för optimal prestanda och dataintegritet.","ui.migrate.error":"Ändringarna kunde inte tillämpas. Din databas kan ha ändrats, kontrollera igen för att försöka igen.","ui.migrate.execute":"Kör","ui.migrate.close":"Stänga","ui.migrate.confirm":"Bekräfta och stäng","ui.migrate.cancel":"Avbryt","ui.migrate.continue":"Fortsätta","ui.migrate.setup":"Setup","ui.migrate.skip":"Hoppa över","ui.migrate.retry":"Kolla igen","ui.migrate.retryAll":"Kontrollera alla","ui.migrate.withDeletes":"Utför alla databasändringar inklusive DROP-queries.","ui.migrate.migrationTitle":"Databasmigreringar","ui.migrate.schemaTitle":"Schemauppdateringar","ui.migrate.problemTitle":"Databasproblem","ui.migrate.warningTitle":"Databasvarningar","ui.migrate.addTable":"Lägg till tabell {table}","ui.migrate.dropTable":"Släpp tabell {table}","ui.migrate.addField":"Lägg till fält {table}.{field}","ui.migrate.changeField":"Ändra fält {table}.{field}","ui.migrate.dropField":"Släpp fältet {table}.{field}","ui.migrate.createIndex":"Skapa index \\"{name}\\" på {table}","ui.migrate.dropIndex":"Släpp index \\"{name}\\" på {table}","ui.widget.mandatory":"Detta fält får inte vara tomt.","ui.widget.blankOption":"Vänligen välj …","ui.widget.showPassword":"Visa lösenord","ui.widget.hidePassword":"Dölj lösenord","ui.error.title":"HTTP-begäran för \\"{method} {url}\\" misslyckades.","ui.error.server500":"Det verkar som att ett oväntat fel inträffade på din server. Kontrollera loggfilerna för din webbserver (Apache/Nginx) och Contao Manager-loggarna på \\"contao-manager/logs\\".","ui.error.response":"Servern returnerade ett svar med statuskoden {status}.","ui.error.moreLink":"Mer information","ui.error.support":"Contao Support","ui.error.permission":"Du har inte tillstånd att använda den här funktionen.","ui.footer.help":"Hjälp","ui.footer.reportProblem":"Rapportera ett problem","ui.navigation.discover":"Upptäck","ui.navigation.packages":"Paket","ui.navigation.tools":"Verktyg","ui.navigation.installTool":"Installera verktyg","ui.navigation.backend":"Contao Backend","ui.navigation.debug":"Contao Debug Mode Felsökningsläge","ui.navigation.logViewer":"Logg visare","ui.navigation.phpinfo":"PHP-information","ui.navigation.phpinfoLoading":"Laddar PHP-information...","ui.navigation.maintenance":"Underhåll","ui.navigation.rebuildCache":"Bygg om cachen","ui.navigation.users":"Konton","ui.navigation.systemCheck":"Systemkontroll","ui.navigation.advanced":"Avancerad","ui.navigation.logout":"Logga ut","ui.maintenance.database.title":"Databasmigreringar och säkerhetskopieringar","ui.maintenance.database.description":"Databasmigreringar säkerställer konsekventa data och tabellscheman.","ui.maintenance.database.migrations":"En väntande databasmigrering | {count} väntande databasmigreringar","ui.maintenance.database.schemaUpdates":"En väntande schemauppdatering | {count} väntande schemauppdateringar","ui.maintenance.database.error":"Databasproblem hittades.","ui.maintenance.database.warning":"Databasvarningar hittades.","ui.maintenance.database.button":"Kontrollera databasen","ui.maintenance.database.migrationOnly":"Kontrollera endast migrering","ui.maintenance.database.schemaOnly":"Kontrollera endast schemat","ui.maintenance.database.installTool":"Öppna installationsverktyget","ui.maintenance.database.createBackup":"Skapa backup","ui.maintenance.database.backupUnsupported":"Databassäkerhetskopior stöds inte av din Contao-version.","ui.maintenance.database.backupList":"Du har en databassäkerhetskopia, skapad den {date}. | Du har {count} databassäkerhetskopior, den senaste skapades den {date}.","ui.maintenance.database.backupEmpty":"Du har för närvarande inga säkerhetskopior av databasen.","ui.maintenance.rebuildCache.title":"Applikationscache","ui.maintenance.rebuildCache.description":"Att bygga om applikationscachen krävs efter att ha ändrat någon av konfigurationsfilerna.","ui.maintenance.rebuildCache.rebuildProd":"Bygg om produktionscachen","ui.maintenance.rebuildCache.rebuildDev":"Bygg om utvecklingscachen","ui.maintenance.rebuildCache.clearProd":"Rensa produktionscache","ui.maintenance.rebuildCache.clearDev":"Rensa utvecklingscache","ui.maintenance.installTool.title":"Contao installationsverktyg","ui.maintenance.installTool.description":"Contao Install Tool låses automatiskt om du anger fel lösenord tre gånger i rad.","ui.maintenance.installTool.unlock":"Lås upp installationsverktyget","ui.maintenance.installTool.lock":"Lås installationsverktyg","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"Composer autoloader ansvarar för PHP-klassladdning. Autoloadern måste dumpas efter att anpassade namnområden har lagts till i roten composer.json.","ui.maintenance.dumpAutoload.button":"Dumpa Autoloader","ui.maintenance.composerInstall.title":"Composer beroenden","ui.maintenance.composerInstall.description":"Composer-beroenden finns i mappen {vendor} i din programrot. Att installera om beroenden kan vara nödvändigt efter manipulering eller manuell uppladdning av {composerLock}-filen.","ui.maintenance.composerInstall.button":"Kör installationsprogrammet","ui.maintenance.composerInstall.update":"Kör Composer Update","ui.maintenance.composerCache.title":"Composer Cache","ui.maintenance.composerCache.description":"Composer cachar nedladdade paket för förbättrad prestanda. Om du har problem som trasiga filer, försök att ta bort Composer-cachen för att tvinga fram en ny nedladdning.","ui.maintenance.composerCache.button":"Rensa cache","ui.maintenance.maintenanceMode.title":"Underhållsläge","ui.maintenance.maintenanceMode.description":"Om du sätter Contao i underhållsläge visas en \\"503 Service Unavailable\\"-mall för webbplatsen.","ui.maintenance.maintenanceMode.enable":"Aktivera","ui.maintenance.maintenanceMode.disable":"Inaktivera","ui.maintenance.debugMode.title":"Felsökningsläge Debug Mode","ui.maintenance.debugMode.description":"Aktivera felsökningsläget genom att ställa in en användare och lösenord för ingångspunkten för {appDevPhp}.","ui.maintenance.debugMode.descriptionJwt":"Aktivera felsökningsläget genom att ställa in felsökningscookien för den aktuella domänen.","ui.maintenance.debugMode.activate":"Aktivera","ui.maintenance.debugMode.deactivate":"Avaktivera","ui.maintenance.debugMode.credentials":"Referenser","ui.maintenance.debugMode.user":"Ange ett användarnamn för felsökningsläget.","ui.maintenance.debugMode.password":"Ange ett lösenord för felsökningsläget.","ui.maintenance.opcodeCache.title":"Opcode Cache","ui.maintenance.opcodeCache.description":"Opcode cachar PHP-filer på webbprocessen för snabbare exekvering. Det måste tas bort under vissa omständigheter om filer inte känns igen efter ändring.","ui.maintenance.opcodeCache.button":"Stympa Cache","ui.maintenance.safeMode":"Ej tillgängligt i felsäkert läge Safe Mode","ui.maintenance.unsupported":"Stöds inte av din Contao-version","ui.packages.updateButton":"Uppdatera paket","ui.packages.searchButton":"Sök paket","ui.packages.searchPlaceholder":"Sök paket …","ui.packages.uploadOverlay":"Dra och släpp filer för att ladda upp","ui.packages.uploadButton":"Ladda upp paket","ui.packages.uploadMessage":"Du har en obekräftad uppladdning. | Du har {count} obekräftade uppladdningar.","ui.packages.uploadApply":"Bekräfta uppladdningar","ui.packages.uploadReset":"Ta bort uppladdningar","ui.packages.uploadIncomplete":"Den här filen laddades inte upp helt. Ta bort den och försök igen.","ui.packages.uploadDuplicate":"Den här filen verkar ha laddats upp flera gånger. Ta bort dubbletterna.","ui.packages.uploadInstalled":"Den här filen är redan installerad. Ta bort dubbletterna.","ui.packages.uploadUnsupported":"Uppladdningar stöds inte i din installation. Se till att PHP ZIP-tillägget är installerat och uppdatera dina beroenden.","ui.packages.changesMessage":"Du har en obekräftad förändring. | Du har {count} obekräftade ändringar.","ui.packages.changesDryrun":"Testkörning","ui.packages.changesApply":"Applicera förändringar","ui.packages.changesApplyAll":"Uppdatera alla paket","ui.packages.changesDryrunAll":"Testkör alla paket","ui.packages.changesReset":"Återställ ändringar","ui.packages.changesReview":"Granska ändringar","ui.packagelist.loading":"Laddning ...","ui.packagelist.uploads":"Uppladdningar","ui.packagelist.added":"Nya paket","ui.packagelist.installed":"Installerade paket","ui.package.hintRevert":"Återställ ändringar","ui.package.hintNoupdate":"Uppdatera inte","ui.package.hintConstraint":"Det här paketet kommer att installeras med begränsningen {constraint} när du tillämpar ändringarna.","ui.package.hintConstraintBest":"Det här paketet kommer att installeras i den bästa tillgängliga versionen när du tillämpar ändringarna.","ui.package.hintConstraintChange":"Begränsningen för detta paket kommer att ändras från \\"{from}\\" till \\"{to}\\" när du tillämpar ändringarna.","ui.package.hintConstraintUpdate":"Detta paket kommer att uppdateras när du tillämpar ändringarna.","ui.package.hintAdded":"Det här paketet kommer att installeras när du tillämpar ändringarna.","ui.package.hintRemoved":"Detta paket kommer att tas bort när du tillämpar ändringarna.","ui.package.requiredTitle":"manuellt lagt till","ui.package.requiredText":"Det här paketet krävs i din composer.json men är inte installerat.","ui.package.removedTitle":"tas bort manuellt","ui.package.removedText":"Det här paketet togs bort från din composer.json.","ui.package.installed":"För närvarande installerad:","ui.package.version":"Version {version}","ui.package.additionalDownloads":"{count} Nedladdning | {count} nedladdningar","ui.package.additionalStars":"{count} stjärna | {count} stjärnor","ui.package.editConstraint":"Redigera","ui.package.uploadConstraint":"Denna begränsning definieras av det uppladdade paketet.","ui.package.updateButton":"Uppdatering","ui.package.removeButton":"Ta bort","ui.package.installButton":"Lägg till paket","ui.package.installButtonShort":"Lägg till","ui.package.detailsButton":"Detaljer","ui.package.latestConstraint":"senaste versionen","ui.package.update":"Uppdatering tillgänglig","ui.package.updateLatest":"senaste versionen","ui.package.updateAvailable":"{version} tillgänglig","ui.package.updateUnknown":"okänd version","ui.package.updateConstraint":"En nyare version utanför din versionsbegränsning är tillgänglig.","ui.package.incompatible":"{package} fungerar inte med Contao {constraint}.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Version {version}","ui.cloudStatus.waitingTime":"Väntetid","ui.cloudStatus.jobs":"Aktuella jobb","ui.cloudStatus.workers":"Arbetare","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"ingen","ui.cloudStatus.short":"ca. {minutes} min","ui.cloudStatus.long":"ca. {minutes} min {seconds} sek","ui.cloudStatus.error":"Det går inte att hämta status för Composer Resolver Cloud. Det kan vara nere på grund av underhåll eller upplevelseproblem.","ui.cloudStatus.button":"Molnstatus","ui.cloudStatus.refresh":"Uppdatera molnstatus","ui.log-viewer.loading":"Laddning ...","ui.log-viewer.empty":"Det finns inga loggfiler på din server.","ui.log-viewer.reload":"Ladda om","ui.log-viewer.file":"Loggfil","ui.log-viewer.channel":"Kanal","ui.log-viewer.channelTitle":"Kanalen som detta meddelande loggades på.","ui.log-viewer.level":"Nivå","ui.log-viewer.levelTitle":"Allvaret i loggmeddelandet.","ui.log-viewer.timeHeader":"Tid","ui.log-viewer.messageHeader":"Meddelande","ui.log-viewer.showContext":"Visa sammanhang","ui.log-viewer.hideContext":"Dölj sammanhang","ui.log-viewer.showExtra":"Visa extra","ui.log-viewer.hideExtra":"Dölj extra","ui.log-viewer.more":"Ladda mer …","ui.log-viewer.download":"Ladda ner","ui.log-viewer.downloadTitle":"Nedladdning fil \\"{file}\\"","ui.log-viewer.prodEnvironment":"Produktionsmiljö","ui.log-viewer.devEnvironment":"Utvecklingsmiljö (felsökningsläge)","ui.user-manager.loading":"Laddar användare ...","ui.user-manager.changePassword":"Ändra lösenord","ui.user-manager.setupTotp":"Konfigurera tvåfaktorsautentisering","ui.user-manager.disableTotp":"Inaktivera tvåfaktorsautentisering","ui.user-manager.invite":"Bjud in användare","ui.user-manager.delete":"Radera","ui.user-manager.deleteConfirm":"Vill du verkligen ta bort användaren ”{användarnamn}”?","ui.user-manager.deleted":"Användaren {användarnamn} raderades framgångsrikt","ui.user-manager.passwordHeadline":"Ändra lösenord","ui.user-manager.passwordText":"Om du vill ändra ditt lösenord anger du det nuvarande och ett nytt lösenord i respektive fält.","ui.user-manager.currentPassword":"Aktuellt lösenord","ui.user-manager.newPassword":"Nytt lösenord","ui.user-manager.passwordPlaceholder":"min. 8 tecken","ui.user-manager.submitPassword":"Skicka","ui.user-manager.passwordChanged":"Ditt lösenord har ändrats framgångsrikt.","ui.user-manager.passwordError":"Det här lösenordet är felaktigt.","ui.user-manager.inviteHeadline":"Bjud in användare","ui.user-manager.inviteText":"Om du behöver flera inloggningar för Contao Manager kan du skapa en inbjudningslänk här. Dela den här länken med någon eller använd den på en annan enhet för att skapa ett nytt konto med de angivna behörigheterna.","ui.user-manager.inviteSuccess1":"En ny inbjudningslänk har skapats. URL:en nedan kan användas för att skapa ett nytt användarkonto för denna Contao Manager. Inbjudan löper ut den {expires} (one week from now).","ui.user-manager.inviteSuccess2":"Kopiera länken till ditt urklipp. Den fungerar bara en gång och du kommer inte att kunna se den igen efter att du har stängt den här dialogen.","ui.user-manager.createInvitation":"Skapa länk till inbjudan","ui.user-manager.clipboard":"Kopiera till urklipp","ui.user-manager.permissions":"Läs mer om behörigheter","ui.user-manager.cancel":"Avbryt","ui.user-manager.close":"Stänga","ui.user-manager.you":"Du","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"Tvåfaktorsautentisering","ui.totp.setupQr":"Vänligen skanna QR-koden med din 2FA/TOTP-app.","ui.totp.setupCode":"Om du inte kan skanna QR-koden, ange den här nyckeln istället:","ui.totp.codeLabel":"Verifieringskod","ui.totp.codeDescription":"Ange verifieringskoden som genereras av din 2FA/TOTP-app.","ui.totp.disableText":"Ange verifieringskoden för att inaktivera tvåfaktorsautentisering.","ui.totp.invalid":"Verifieringskoden är ogiltig.","ui.totp.enable":"Aktivera","ui.totp.disable":"Inaktivera","ui.totp.cancel":"Avbryt","ui.totp.enabled":"Tvåfaktorsautentisering aktiverades framgångsrikt.","ui.totp.disabled":"Tvåfaktorsautentisering avaktiverades framgångsrikt.","ui.totp.setup":"Konfigurera tvåfaktorsautentisering","ui.totp.skip":"Skip Two-Factor Authentication"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[706],{2706:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Conexión insegura !!","ui.app.httpsDescription":"Sin HTTPS, sus datos confidenciales se transferirán sin cifrar.","ui.app.httpsLink":"Mas información","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"¡Modo seguro habilitado!","ui.app.safeModeDescription":"Algunas funciones de Contao Manager no están disponibles.","ui.app.safeModeExit":"Salida del modo seguro","ui.app.limitedHeadline":"Autenticación remota ","ui.app.limitedDescription":"Tiene permisos limitados debido al inicio de sesión sin contraseña.","ui.app.limitedLogout":"Volver a autenticar","ui.app.totpHeadline":"Aviso de seguridad","ui.app.totpDescription":"Configure la autenticación de dos factores ahora para proteger su cuenta.","ui.app.totpSetup":"Configuración","ui.app.loading":"Cargando Contao Manager ...","ui.app.apiError":"Estado inesperado de la API","ui.app.configSecurity1":"ALERTA DE SEGURIDAD !!! Detectado directorio de configuración desprotegido","ui.app.configSecurity2":"Contao Manager ha detectado que sus archivos de configuración son de acceso público. Todas las operaciones están deshabilitadas hasta que el directorio esté seguro; de lo contrario, un atacante podría acceder a datos confidenciales de su instalación.\\n\\nPara solucionar este problema, asegúrese de evitar el acceso al directorio \\"contao-manager\\" en su servidor. Para saber cómo hacer esto, consulte el manual de su servidor web o póngase en contacto con su proveedor de alojamiento.","ui.account.welcome":"Bienvenido","ui.account.intro1":"Bienvenido a Contao Manager, una herramienta universal para instalar y administrar Contao Open Source CMS. Si es nuevo en esto, {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} para comenzar","ui.account.introManual":"lea el manual","ui.account.intro2":"Si encuentra algún problema, consulte {ourGithubIssues} y siéntase libre de crear uno nuevo para cualquier cosa que aún no se haya informado.","ui.account.introIssues":"nuestros problemas de GitHub","ui.account.headline":"Cuenta de usuario","ui.account.description":"Para administrar su instalación, cree una cuenta para Contao Manager. Tenga en cuenta que esta cuenta no está relacionada con el back end o front end de Contao.","ui.account.username":"Nombre de usuario","ui.account.password":"Contraseña","ui.account.passwordPlaceholder":"min. 8 caracteres","ui.account.passwordLength":"Por favor introduzca al menos 8 caracteres.","ui.account.loginInvalid":"Se produjo un error al crear la cuenta. Intente con otro nombre de usuario.","ui.account.submit":"Crear una cuenta","ui.account.usePassword":"Utilice contraseña para iniciar sesión","ui.account.usePasskey":"Utilice la clave de acceso (Passkey) para iniciar sesión","ui.account.totpHeadline":"Autenticación de dos factores","ui.account.totpDescription":"Habilite la autenticación de dos factores, que agrega una capa adicional de seguridad a su cuenta. Además de su nombre de usuario y contraseña, deberá ingresar un código de verificación generado por una aplicación de dos factores como 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator o cualquier otra aplicación TOTP.","ui.account.totpSetup":"Configurar ahora","ui.account.totpSkip":"Configurar más tarde","ui.account.login":"Rechazar invitación","ui.account.contribute1":"Contao y Contao Manager están patrocinados por la Asociación Contao sin fines de lucro.","ui.account.contribute2":"Considere contribuir al código abierto con {donate}.","ui.account.contributeDonate":"hacer una donación","ui.login.headline":"Registrarse","ui.login.description":"Inicie sesión para administrar su instalación.","ui.login.username":"Nombre de usuario","ui.login.password":"Contraseña","ui.login.totpHeadline":"Autenticación de dos factores","ui.login.totpDescription":"Ingrese su código de verificación para completar el proceso de inicio de sesión.","ui.login.totp":"Código de verificación","ui.login.forgotPassword":"¿Ha olvidado su contraseña?","ui.login.button":"Registrarse","ui.login.passkey":"Iniciar sesión con clave de acceso (Passkey)","ui.login.cancel":"Cancelar","ui.login.or":"o","ui.login.locked":"Se ha denegado el acceso porque Contao Manager está bloqueado. Para desbloquear, elimine el archivo {lockFile} en su directorio raíz de Contao.","ui.logout.headline":"Timeout de la sesión","ui.logout.warning":"Ha estado inactivo por más de 25 minutos. Por razones de seguridad, su sesión finalizará en breve.","ui.logout.expired":"Su sesión finalizó automáticamente porque ha estado inactivo durante más de 30 minutos.","ui.logout.renew":"Mantener conectado","ui.logout.logout":"Cerrar sesión","ui.logout.login":"Volver para iniciar sesión","ui.oauth.error":"Intento de OAuth no válido Verifique los parámetros de solicitud.","ui.oauth.https":"El URI de redireccionamiento DEBE usar un protocolo seguro (https :) para evitar que el token de autenticación se transmita en texto sin cifrar. ","ui.oauth.headline":"Autenticación remota ","ui.oauth.description":"La siguiente aplicación o servicio está solicitando acceso remoto a su instancia del Contao Manager.","ui.oauth.domain":"Antes de permitir el acceso, asegúrese de conocer esta URL y confíe en su propietario.","ui.oauth.outOfScope":"Lamentablemente, no tienes los permisos necesarios para otorgar este acceso.","ui.oauth.allow":"Permitir el acceso","ui.oauth.deny":"Acceso denegado","ui.oauth.switchUser":"Cambiar de usuario","ui.scope.admin":"Acceso de administrador, incluida la gestión de usuarios","ui.scope.install":"Instalar nuevos paquetes y cambiar la configuración de Contao","ui.scope.update":"Actualizar paquetes y ejecutar tareas de mantenimiento","ui.scope.read":"Leer paquetes y configuración","ui.boot.headline":"Comprobar sistema","ui.boot.description":"Por favor espere, estamos analizando su servidor ...","ui.boot.issue1":"Se han detectado problemas de instalación","ui.boot.issue2":"Su instalación tiene problemas que deben solucionarse antes de que se pueda utilizar Contao Manager.","ui.boot.run":"Lanzamiento de Contao Manager","ui.boot.safeMode":"Lanzamiento en modo seguro","ui.recovery.headline":"Recuperación del sistema","ui.recovery.description":"El Contao Manager detectó archivos que se parecen a Contao, pero la Interfaz de línea de comandos no funciona como se esperaba.","ui.recovery.console":"Salida de consola","ui.recovery.repairOptions":"Por favor, elija una opción para reparar su instalación.","ui.recovery.repairHeadline":"Reparación automática","ui.recovery.repairDescription":"Intenta reparar automáticamente la instalación reconstruyendo el caché de la aplicación y reinstalando los paquetes de Composer.","ui.recovery.repairWarning":"¡Cualquier modificación de los archivos del proveedor podría ser eliminada en el proceso!","ui.recovery.repairFailed":"La reparación automática no tuvo éxito. Pruebe el Modo seguro para reparar manualmente la instalación.","ui.recovery.repairButton":"Ejecutar la reparación del sistema","ui.recovery.safeModeHeadline":"Modo seguro","ui.recovery.safeModeDescription":"Iniciar el Contao Manager en Modo seguro permite administrar paquetes y ejecutar ciertas tareas de mantenimiento, pero las funciones que dependen de una instalación de Contao que funcione no estarán disponibles.","ui.recovery.safeModeButton":"Lanzamiento en modo seguro","ui.server.pending":"Esperando …","ui.server.running":"Analizando ...","ui.server.error":"La comprobación falló debido a una respuesta inesperada del servidor.","ui.server.details":"Detalles","ui.server.prerequisite":"Verificación cancelada debido a un prerrequisito faltante.","ui.server.selfUpdate.title":"Actualizaciones del Contao Manager","ui.server.selfUpdate.update":"Una nueva versión {latest} de Contao Manager está disponible.","ui.server.selfUpdate.manualUpdate":"Hay disponible una nueva versión {latest} de Contao Manager. Su servidor no admite actualizaciones automáticas, descargue la nueva versión de {download}.","ui.server.selfUpdate.latest":"Estás utilizando la última versión {current}.","ui.server.selfUpdate.dev":"Las compilaciones de desarrollo no admiten actualizaciones automáticas.","ui.server.selfUpdate.unsupported":"Hay una nueva versión disponible pero no es compatible con su versión de PHP.","ui.server.selfUpdate.button":"Ejecutar autoactualización","ui.server.selfUpdate.continue":"Continuar","ui.server.config.title":"Configuración del servidor","ui.server.config.setup":"Configurar","ui.server.config.change":"Cambiar","ui.server.config.save":"Guardar","ui.server.config.cancel":"Cancelar","ui.server.config.customOption":"Otros ...","ui.server.config.description":"Para ejecutar correctamente las tareas en segundo plano, Contao Manager necesita saber dónde encontrar el binario de la línea de comandos PHP y cómo ejecutar comandos separados del proceso web.","ui.server.config.formTitle":"Configuración del servidor","ui.server.config.formText":"Por favor ingrese la ruta a su binario de PHP. Asegúrese de que el binario sea la misma versión PHP que su proceso web.","ui.server.config.cloudTitle":"Compositor Resolver Cloud","ui.server.config.cloudText":"El Composer Resolver Cloud permite instalar dependencias de Composer incluso si su servidor no proporciona suficiente memoria local. Tenga en cuenta que la información de su paquete se transmitirá a un servidor en la nube operado por la Asociación Contao.","ui.server.config.cloud":"Utilice la nube Composer Resolver Cloud","ui.server.config.cli":"PHP binario","ui.server.config.stateErrorCli":"No se encontró ningún binario PHP válido en el servidor.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud no es compatible.","ui.server.config.stateSuccess":"PHP binario en {php_cli}.","ui.server.php_web.title":"Proceso web de PHP","ui.server.php_web.below7":"Versión PHP encontrada {versión}. ¡Cambie a PHP 7 lo antes posible!","ui.server.php_web.success":"Se encontró la versión PHP {versión}, no se encontraron problemas conocidos.","ui.server.php_cli.title":"Interfaz de línea de comandos de PHP","ui.server.php_cli.success":"Se encontró la versión PHP {versión}, no se encontraron problemas conocidos.","ui.server.composer.title":"Entorno Composer","ui.server.composer.success":"No se encontraron problemas conocidos.","ui.server.composer.install":"Las dependencias del Composer no están instaladas.","ui.server.composer.button":"Instalar","ui.server.contao.title":"Instalación de Contao","ui.server.contao.setup":"Configuración","ui.server.contao.check":"Consultar base de datos","ui.server.contao.empty":"No se ha encontrado una instalación de Contao.","ui.server.contao.old":"La versión de Contao {versión} no es compatible con Contao Manager, actualice su instalación manualmente.","ui.server.contao.found":"Se ha encontrado Contao {version} (API version {api}).","ui.server.contao.connectionError":"No se puede conectar con el servidor de la base de datos.","ui.server.contao.connectionProblem":"Problema de base de datos encontrado.","ui.server.contao.missingUser":"Cuenta de administrador no encontrada.","ui.setup.continue":"Continuar","ui.setup.manager":"Lanzamiento de Contao Manager","ui.setup.cancel":"Cancelar","ui.setup.welcome":"Bienvenido","ui.setup.welcome1":"Este asistente le guiará a través de los pasos necesarios para configurar su instalación de CMS de código abierto de Contao.","ui.setup.welcome2":"Si tiene alguna pregunta, busque documentación, foros, un canal de Slack y más en la página de {support}.","ui.setup.support":"soporte comunitario","ui.setup.start":"Empezar","ui.setup.complete":"¡Enhorabuena!","ui.setup.complete1":"Contao {versión} se ha instalado correctamente.","ui.setup.complete2":"Para finalizar el proceso de configuración, abra la herramienta de instalación para configurar la conexión de la base de datos y crear un usuario final.","ui.setup.complete3":"Ahora puede comenzar a crear su sitio web en el back-end de Contao. Si necesita extensiones adicionales, continúe con Contao Manager.","ui.setup.installTool":"Abra la herramienta de instalación","ui.setup.login":"Iniciar sesión en Contao","ui.setup.funding":"El software libre es \\"libre\\" como en \\"libertad de expresión\\", no como en \\"cerveza gratis\\". Un proyecto de código abierto como Contao requiere cantidades de dinero que no pueden ser recaudadas por una sola persona o empresa.\\nSi tiene un sitio web o vende sitios web creados con Contao, nos encantaría ver que contribuye financieramente al producto del que depende su negocio.","ui.setup.fundingLink":"Aprende más","ui.setup.document-root.headline":"Configuración del servidor web","ui.setup.document-root.warning":"Para instalar Contao a través de Contao Manager, debe arreglar la raíz del documento en el servidor web.","ui.setup.document-root.description1":"Contao usa una carpeta separada para los archivos públicos, los archivos de la aplicación se instalan en su carpeta principal. Contao no se puede instalar si la estructura de carpetas no es correcta o las carpetas no están vacías.","ui.setup.document-root.description2":"Si no sabe cómo configurar la raíz de su documento, lea la documentación de Contao o comuníquese con su proveedor de alojamiento.","ui.setup.document-root.documentation":"Lea la documentación","ui.setup.document-root.conflictsTitle":"El directorio de instalación no está vacío","ui.setup.document-root.conflictsDirectory":"El directorio raíz de su futura instalación de Contao no está vacío, hemos encontrado (un) archivo(s) {count} que podrían sobrescribirse durante el proceso de instalación. Se recomienda crear una estructura de directorios vacía para Contao, pero también puede eliminar los siguientes archivos y verificar nuevamente si está seguro de que no se utilizan.","ui.setup.document-root.ignoreConflicts":"Quiero instalar Contao en el directorio no vacío. Entiendo que esto podría sobrescribir cualquier archivo existente en mi espacio web.","ui.setup.document-root.check":"Revisar otra vez","ui.setup.document-root.create":"Crear directorios","ui.setup.document-root.change":"Cambiar directorios","ui.setup.document-root.formTitle":"Configuración de directorio","ui.setup.document-root.formText1":"Contao Manager puede crear automáticamente una nueva estructura de directorio en el servidor.","ui.setup.document-root.formText2":"Deberá configurar manualmente la nueva raíz del documento (por ejemplo, a través de un panel de administración de alojamiento).","ui.setup.document-root.autoconfig":"Entiendo que tengo que cambiar la configuración de mi servidor. ¡No configurar la raíz del documento romperá el Contao Manager y expondrá los archivos de configuración (incluidos los detalles de la cuenta y las contraseñas)!","ui.setup.document-root.directory":"Nuevo directorio","ui.setup.document-root.currentRoot":"Raíz del documento actual","ui.setup.document-root.newRoot":"Nueva raíz del documento","ui.setup.document-root.finish":"Configurar directorios","ui.setup.document-root.publicDir":"Use {dir} para archivos públicos (para Contao {version})","ui.setup.document-root.directoryInvalid":"Introduzca un nombre de directorio válido.","ui.setup.document-root.directoryExists":"El directorio de destino ya existe. Ingrese un nombre diferente.","ui.setup.document-root.confirmation":"Contao Manager ha creado con éxito el directorio necesario para su instalación de Contao. Ahora debe configurar la raíz del documento en su servidor web. No recargues esta página hasta entonces.","ui.setup.document-root.reload":"Recargar página","ui.setup.document-root.success":"¡La estructura de directorios en su servidor web está configurada correctamente!","ui.setup.document-root.installingProjectDir":"Los archivos de la aplicación se instalarán en {dir}.","ui.setup.document-root.installingPublicDir":"Los archivos públicos se instalarán en {dir}.","ui.setup.document-root.installedProjectDir":"Los archivos de la aplicación se instalan en {dir}.","ui.setup.document-root.installedPublicDir":"Los archivos públicos se instalan en {dir}.","ui.setup.create-project.headline":"Instalación de Contao","ui.setup.create-project.description":"El desarrollo de Contao sigue el principio de {semver}, se lanza una nueva versión secundaria cada seis meses. Las versiones admitidas actualmente son:","ui.setup.create-project.semver":"Versionado semántico","ui.setup.create-project.latestTitle":"Última","ui.setup.create-project.ltsTitle":"Soporte a largo plazo","ui.setup.create-project.latestQ1":"Nuestra última versión ofrece la mayoría de las funciones con soporte hasta febrero de {year}.","ui.setup.create-project.latestQ3":"Nuestra última versión ofrece la mayor cantidad de funciones con soporte hasta agosto del {year}.","ui.setup.create-project.ltsText":"Nuestra versión LTS actual, si te enfocas en la estabilidad. Ofrece soporte a largo plazo hasta febrero {year}.","ui.setup.create-project.pltsText":"La versión anterior de LTS todavía tiene soporte a largo plazo hasta febrero de {year}.","ui.setup.create-project.requiresPHP":"Requiere al menos PHP {version}, tiene PHP {current}.","ui.setup.create-project.releaseplan":"Consulte el {contaoReleasePlan} para obtener información detallada.","ui.setup.create-project.releaseplanLink":"Plan de lanzamiento de Contao","ui.setup.create-project.installed":"Contao {version} se instaló correctamente en el servidor. Continúe configurando su base de datos o inicie Contao Manager para instalar una versión diferente.","ui.setup.create-project.formTitle":"Seleccione una distribución","ui.setup.create-project.formText":"Elija qué versión debe instalarse.","ui.setup.create-project.version":"Versión","ui.setup.create-project.demo":"Instale el sitio web de demostración de Contao","ui.setup.create-project.demoDescription":"The demo website helps you to get familiar with Contao and all of its core features. More themes can be found in the {store}.Instale el sitio web de demostración de Contao","ui.setup.create-project.coreOnly":"Instalación mínima (solo el núcleo)","ui.setup.create-project.noUpdate":"Omitir instalación (¡Solo experto!)","ui.setup.create-project.theme":"Tema Contao","ui.setup.create-project.themeInstall":"Para instalar un tema de Contao, utilice la entrada de búsqueda o cargue un archivo de tema (.cto/.zip) que admita la instalación a través de Contao Manager.","ui.setup.create-project.themeBuy":"Asegúrate de visitar la {store} oficial.","ui.setup.create-project.themeStore":"Tienda de temas Contao","ui.setup.create-project.themeUpload":"Cargar archivo de tema (.cto/.zip)","ui.setup.create-project.themeInvalid":"El archivo cargado no es un tema de Contao o no es compatible con Contao Manager.","ui.setup.create-project.themeWarning":"El Contao Manager no puede saber si este tema es compatible con su servidor. Consulte con el proveedor del tema si tiene alguna pregunta.","ui.setup.create-project.themeTitle":"Revisar los detalles del tema","ui.setup.create-project.themeDetails":"Las siguientes dependencias y archivos se instalarán con este tema.","ui.setup.create-project.themeRequire":"{count} Dependencias | {count} Dependencias","ui.setup.create-project.themeFiles":"{count} Archivo | {count} Archivos","ui.setup.create-project.theme.or":"o buscar temas públicos","ui.setup.create-project.theme.search":"Buscar temas","ui.setup.create-project.theme.more":"Más temas","ui.setup.create-project.theme.empty":"No hay temas que coincidan con {query}","ui.setup.create-project.theme.uploaded":"El archivo del tema se cargó correctamente.","ui.setup.create-project.theme.packageName":"Nombre del paquete","ui.setup.create-project.theme.version":"Versión","ui.setup.create-project.theme.authors":"Autor(es)","ui.setup.create-project.theme.upload":"Uploading {name} ({size})","ui.setup.create-project.install":"Instalar","ui.setup.create-project.cancel":"Cancelar","ui.setup.create-project.fileError":"Could not find composer.json in {file}.","ui.setup.create-project.jsonError":"composer.json contains invalid JSON.","ui.setup.create-project.schemaError":"composer.json schema validation failed.","ui.setup.database-connection.headline":"Conexión de base de datos","ui.setup.database-connection.description":"Contao requiere una base de datos MySQL (o una bifurcación compatible como MariaDB) para almacenar páginas, contenido, usuarios y otros datos relacionales. Los parámetros de conexión se almacenan en el archivo {env} en la raíz del proyecto de su instalación de Contao.","ui.setup.database-connection.formTitle":"Parámetros de conexión","ui.setup.database-connection.formText":"Ingrese una URL de base de datos o complete los campos de nombre de usuario, contraseña, servidor y base de datos por separado.","ui.setup.database-connection.url":"URL de la base de datos","ui.setup.database-connection.validUrl":"La URL de la base de datos no es válida o la conexión con el servidor falló.","ui.setup.database-connection.or":"o","ui.setup.database-connection.user":"Nombre de usuario","ui.setup.database-connection.password":"Contraseña","ui.setup.database-connection.server":"Servidor (:Port)","ui.setup.database-connection.database":"Nombre de la base de datos","ui.setup.database-connection.connected":"Conexión exitosa a la base de datos {database} en {server}.","ui.setup.database-connection.error":"Error al conectarse a la base de datos.","ui.setup.database-connection.problem":"Contao ha detectado un problema con su servidor de base de datos.","ui.setup.database-connection.schemaTitle":"Esquema de base de datos","ui.setup.database-connection.migration":"Hay una migración pendiente. | Hay {count} migraciones pendientes.","ui.setup.database-connection.schema":"Hay una actualización de esquema pendiente. | Hay {count} actualizaciones de esquema pendientes.","ui.setup.database-connection.noChanges":"El esquema de su base de datos está actualizado.","ui.setup.database-connection.check":"Consultar base de datos","ui.setup.database-connection.skip":"Saltar","ui.setup.database-connection.save":"Guardar","ui.setup.database-connection.change":"Cambiar credenciales","ui.setup.database-connection.restoreTitle":"Importar base de datos","ui.setup.database-connection.restoreText":"El tema que acaba de instalar contiene una copia de seguridad de la base de datos. Restaure la base de datos para importar datos del tema u omita este paso para comenzar con una instalación de Contao en blanco. | El tema que acaba de instalar contiene múltiples copias de seguridad de bases de datos. Seleccione un archivo de respaldo para importar datos del tema u omita este paso para comenzar con una instalación de Contao en blanco.","ui.setup.database-connection.backup":"Copia de seguridad de la base de datos actual antes de importar","ui.setup.database-connection.backupWarning":"¡Todos los datos de la base de datos se sobrescribirán al importar! Primero cree una copia de seguridad si la base de datos no está vacía.","ui.setup.database-connection.restore":"Importar base de datos de temas","ui.setup.database-connection.restoreOption":"Copia de seguridad de {date} ({size})","ui.setup.database-connection.restored":"Su base de datos de temas se importó correctamente. Continúe validando el esquema de su base de datos.","ui.setup.backend-user.success":"Se encontró una cuenta de administrador para el back-end de Contao en su base de datos. Use el back-end de Contao para agregar más usuarios.","ui.setup.backend-user.error":"No se puede recuperar la lista de usuarios. Consulte la salida de la consola para obtener más detalles.","ui.setup.backend-user.headline":"Cuenta back-end","ui.setup.backend-user.description":"Para administrar su sitio web, debe tener al menos una cuenta de administrador para el back-end de Contao. Tenga en cuenta que esta cuenta no está relacionada con Contao Manager.","ui.setup.backend-user.formTitle":"Crear una cuenta","ui.setup.backend-user.formText":"Introduzca los detalles de la nueva cuenta back-end.","ui.setup.backend-user.username":"Nombre de usuario","ui.setup.backend-user.name":"Nombre","ui.setup.backend-user.email":"Dirección de correo electrónico","ui.setup.backend-user.emailInvalid":"Por favor, introduzca una dirección de correo electrónico válida","ui.setup.backend-user.password":"Contraseña","ui.setup.backend-user.passwordPlaceholder":"min. 8 caracteres","ui.setup.backend-user.passwordLength":"Por favor introduzca al menos 8 caracteres.","ui.setup.backend-user.create":"Añadir cuenta","ui.task.headline":"Tarea de fondo","ui.task.loading":"Cargando detalles…","ui.task.created":"Cargando detalles…","ui.task.active":"Espere mientras Contao Manager ejecuta las operaciones de tareas en segundo plano.","ui.task.complete":"Todas las operaciones se completan con éxito. Consulte la salida de la consola para obtener más detalles.","ui.task.paused":"Una operación en segundo plano se detuvo inesperadamente. Compruebe la salida de la consola.","ui.task.aborting":"Espere mientras se cancelan las operaciones en segundo plano.","ui.task.stopped":"Se cancelaron algunas operaciones en segundo plano. Compruebe la salida de la consola.","ui.task.error":"Una operación en segundo plano se detuvo inesperadamente. Compruebe la salida de la consola.","ui.task.failed":"¡El Contao Manager no pudo iniciar una tarea en segundo plano!","ui.task.failedDescription1":"Algo salió mal al intentar ejecutar operaciones en segundo plano.","ui.task.failedDescription2":"Si esto vuelve a suceder, es posible que su servidor no sea compatible.","ui.task.reportProblem":"Informar de un problema","ui.task.pausedDescription":"Click \\"Continue\\" if you want to ignore the error and execute the remaining operations.","ui.task.sponsor":"Composer Cloud patrocinado por {sponsor}","ui.task.buttonAudit":"Actualizar base de datos","ui.task.buttonClose":"Cerrar","ui.task.buttonConfirm":"Confirmar y cerrar","ui.task.buttonContinue":"Continuar","ui.task.buttonCancel":"Cancelar","ui.task.confirmCancel":"¿Está seguro de cancelar esta tarea? ¡Esto podría dejar su instalación de Contao en un estado roto!","ui.task.autoclose":"Cerrar los detalles de la tarea en caso de éxito","ui.console.toggle":"Mostrar / Ocultar salida de consola","ui.console.showLog":"Mostrar registro completo de la consola","ui.console.copyLog":"Copiar registro al portapapeles","ui.migrate.headline":"Actualizaciones de la base de datos","ui.migrate.migrationsOnly":"(solo migraciones)","ui.migrate.schemaOnly":"(solo esquema)","ui.migrate.loading":"Por favor espere, estamos revisando su base de datos...","ui.migrate.empty":"No se encontraron migraciones pendientes ni actualizaciones de esquema. Su base de datos está actualizada.","ui.migrate.emptyMigrations":"No se encontraron migraciones pendientes. Asegúrese de verificar también las actualizaciones del esquema.","ui.migrate.emptySchema":"No se encontraron actualizaciones de esquema pendientes. Asegúrese de verificar también las migraciones.","ui.migrate.pending":"Su base de datos no está actualizada. Revise la salida de la consola a continuación y ejecute los cambios.","ui.migrate.previousChanges":"No se confirmó una migración de base de datos anterior.\\nRevise el resultado de la consola a continuación, luego continúe para ver los próximos cambios.","ui.migrate.previousComplete":"No se confirmó una migración de base de datos anterior, revise el resultado de la consola a continuación.\\nNo hay más cambios pendientes.","ui.migrate.appliedChanges":"Se han aplicado actualizaciones de la base de datos.\\nRevise el resultado de la consola a continuación, luego continúe para ver los próximos cambios.","ui.migrate.appliedComplete":"Se han aplicado actualizaciones de la base de datos.\\nNo hay más migraciones pendientes ni actualizaciones de esquemas. Su base de datos está actualizada.","ui.migrate.problem":"Contao ha detectado un problema con su servidor de base de datos.\\nRevise la salida de la consola a continuación para averiguar qué debe corregirse. | Contao ha detectado problemas con su servidor de base de datos.\\nRevise la salida de la consola a continuación para averiguar qué debe corregirse.","ui.migrate.warning":"Contao ha detectado una configuración incorrecta de su servidor de base de datos.\\nLas advertencias se pueden omitir temporalmente, pero se deben corregir para lograr un rendimiento y una integridad de los datos óptimos.","ui.migrate.error":"No se pudieron aplicar los cambios. Es posible que su base de datos haya cambiado, verifique nuevamente para volver a intentarlo.","ui.migrate.execute":"Ejecutar","ui.migrate.close":"Cerrar","ui.migrate.confirm":"Confirmar y cerrar","ui.migrate.cancel":"Cancelar","ui.migrate.continue":"Continuar","ui.migrate.setup":"Configuración","ui.migrate.skip":"Saltar","ui.migrate.retry":"Revisar otra vez","ui.migrate.retryAll":"Comprobar todo","ui.migrate.withDeletes":"Ejecute todos los cambios de la base de datos, incluidas las consultas DROP.","ui.migrate.migrationTitle":"Migraciones de bases de datos","ui.migrate.schemaTitle":"Actualizaciones de esquema","ui.migrate.problemTitle":"Problemas de base de datos","ui.migrate.warningTitle":"Advertencias de la base de datos","ui.migrate.addTable":"Añadir tabla {table}","ui.migrate.dropTable":"Soltar tabla {table}","ui.migrate.addField":"Añadir campo {table}.{field}","ui.migrate.changeField":"Cambiar campo {table}.{field}","ui.migrate.dropField":"Soltar campo {table}.{field}","ui.migrate.createIndex":"Crear índice \\"{name}\\" en {table}","ui.migrate.dropIndex":"Coloque el índice \\"{name}\\" en {table}","ui.widget.mandatory":"Este campo no debe estar vacío.","ui.widget.blankOption":"Por favor seleccione","ui.widget.showPassword":"Mostrar contraseña","ui.widget.hidePassword":"Ocultar contraseña","ui.error.title":"Error en la solicitud HTTP para \\"{method} {url}\\".","ui.error.server500":"Parece que ocurrió un error inesperado en su servidor. Consulte los archivos de registro de su servidor web (Apache/Nginx) y los registros de Contao Manager en \\"contao-manager/logs\\".","ui.error.response":"El servidor devolvió una respuesta con el código de estado {status}.","ui.error.moreLink":"Más información","ui.error.support":"Soporte Contao","ui.error.permission":"No tiene permiso para utilizar esta función.","ui.footer.help":"Ayuda","ui.footer.reportProblem":"Informar de un problema","ui.navigation.discover":"Descubrir","ui.navigation.packages":"Paquetes","ui.navigation.tools":"Herramientas","ui.navigation.installTool":"Herramienta de instalación","ui.navigation.backend":"Backend de Contao","ui.navigation.debug":"Modo Contao Debug","ui.navigation.logViewer":"Visor de registros","ui.navigation.phpinfo":"Información PHP","ui.navigation.phpinfoLoading":"Cargando información de PHP…","ui.navigation.maintenance":"Mantenimiento","ui.navigation.rebuildCache":"Reconstruir caché","ui.navigation.users":"Cuentas","ui.navigation.systemCheck":"Comprobar sistema","ui.navigation.advanced":"Avanzado","ui.navigation.logout":"Cerrar sesión","ui.maintenance.database.title":"Migraciones y copias de seguridad de bases de datos","ui.maintenance.database.description":"Las migraciones de bases de datos garantizan esquemas de tablas y datos coherentes.","ui.maintenance.database.migrations":"Una migración de base de datos pendiente | {count} migraciones de bases de datos pendientes","ui.maintenance.database.schemaUpdates":"Una actualización de esquema pendiente | {count} actualizaciones de esquema pendientes","ui.maintenance.database.error":"Problema de base de datos encontrado.","ui.maintenance.database.warning":"Se encontraron advertencias de la base de datos.","ui.maintenance.database.button":"Consultar base de datos","ui.maintenance.database.migrationOnly":"Comprobar solo migraciones","ui.maintenance.database.schemaOnly":"Comprobar solamente esquema ","ui.maintenance.database.installTool":"Abrir herramienta de instalación","ui.maintenance.database.createBackup":"Crear copia de seguridad","ui.maintenance.database.backupUnsupported":"Las copias de seguridad de bases de datos no son compatibles con su versión de Contao.","ui.maintenance.database.backupList":"Tiene una copia de seguridad de la base de datos, creada el {fecha}. | Tiene {count} copias de seguridad de la base de datos; la última se creó el {fecha}.","ui.maintenance.database.backupEmpty":"Actualmente no tiene copias de seguridad de la base de datos.","ui.maintenance.rebuildCache.title":"Caché de la aplicación","ui.maintenance.rebuildCache.description":"Es necesario volver a generar la caché de la aplicación después de modificar cualquiera de los archivos de configuración.","ui.maintenance.rebuildCache.rebuildProd":"Reconstruir caché de producción","ui.maintenance.rebuildCache.rebuildDev":"Reconstruir caché de desarrollo","ui.maintenance.rebuildCache.clearProd":"Borrar caché de producción","ui.maintenance.rebuildCache.clearDev":"Borrar caché de desarrollo","ui.maintenance.installTool.title":"Herramienta de Instalación Contao","ui.maintenance.installTool.description":"La herramienta de instalación de Contao se bloquea automáticamente si introduce una contraseña incorrecta tres veces seguidas.","ui.maintenance.installTool.unlock":"Desbloquear herramienta de instalación","ui.maintenance.installTool.lock":"Bloquear herramienta de instalación","ui.maintenance.dumpAutoload.title":"Cargador Composer Class","ui.maintenance.dumpAutoload.description":"El autocargador Composer es responsable de la carga de la clase PHP. El autocargador debe volcarse después de agregar espacios de nombres personalizados a la raíz composer.json.","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Dependencias Composer","ui.maintenance.composerInstall.description":"Las dependencias de Composer se encuentran en la carpeta {vendor} en la raíz de su aplicación. Puede ser necesario reinstalar las dependencias después de la manipulación o de cargar manualmente el archivo {composerLock}.","ui.maintenance.composerInstall.button":"Ejecutar instalador","ui.maintenance.composerInstall.update":"Ejecutar actualización de Composer","ui.maintenance.composerCache.title":"Caché del Composer","ui.maintenance.composerCache.description":"El Composer almacena en el caché los paquetes descargados para un mejor rendimiento. Si tiene problemas como archivos rotos, intente eliminar el caché de Composer para forzar una nueva descarga.","ui.maintenance.composerCache.button":"Limpiar cache","ui.maintenance.maintenanceMode.title":"Modo de mantenimiento","ui.maintenance.maintenanceMode.description":"Poner a Contao en modo de mantenimiento mostrará una plantilla \\"503 Servicio no disponible\\" para el sitio web.","ui.maintenance.maintenanceMode.enable":"Habilitar","ui.maintenance.maintenanceMode.disable":"Deshabilitar","ui.maintenance.debugMode.title":"Modo Debug","ui.maintenance.debugMode.description":"Active el modo de depuración configurando un usuario y una contraseña para el punto de entrada {appDevPhp}.","ui.maintenance.debugMode.descriptionJwt":"Active el modo de depuración configurando la cookie de depuración para el dominio actual.","ui.maintenance.debugMode.activate":"Activar","ui.maintenance.debugMode.deactivate":"Desactivar","ui.maintenance.debugMode.credentials":"Credenciales","ui.maintenance.debugMode.user":"Introduzca un nombre de usuario para el modo Debug.","ui.maintenance.debugMode.password":"Introduzca una contraseña de usuario para el modo Debug.","ui.maintenance.opcodeCache.title":"Caché Opcode","ui.maintenance.opcodeCache.description":"Opcode guarda en caché los archivos PHP en el proceso web para una ejecución más rápida. Debe borrarse bajo ciertas circunstancias si los archivos no son reconocidos después de cambiarlos.","ui.maintenance.opcodeCache.button":"Truncar caché","ui.maintenance.safeMode":"No disponible en modo seguro","ui.maintenance.unsupported":"No es compatible con su versión de Contao","ui.packages.updateButton":"Paquetes de actualización","ui.packages.searchButton":"Buscar paquetes","ui.packages.searchPlaceholder":"Buscando paquetes ...","ui.packages.uploadOverlay":"Arrastra y suelta archivos para subir","ui.packages.uploadButton":"Subir paquetes","ui.packages.uploadMessage":"Tiene una carga sin confirmar. | Tienes {count} cargas sin confirmar.","ui.packages.uploadApply":"Confirmar subidas","ui.packages.uploadReset":"Eliminar subidas","ui.packages.uploadIncomplete":"Este archivo no se cargó por completo. Elimínelo e intente nuevamente.","ui.packages.uploadDuplicate":"Este archivo parece haberse cargado varias veces. Por favor, elimine los duplicados.","ui.packages.uploadInstalled":"Este archivo ya está instalado. Por favor, elimine los duplicados.","ui.packages.uploadUnsupported":"Las cargas no son compatibles con su instalación. Asegúrese de que la extensión PHP ZIP esté instalada y actualice sus dependencias.","ui.packages.changesMessage":"Tiene un cambio sin confirmar. | Tiene {count} cambios sin confirmar.","ui.packages.changesDryrun":"Funcionamiento en seco","ui.packages.changesApply":"Aplicar cambios","ui.packages.changesApplyAll":"Actualizar todos los paquetes ","ui.packages.changesDryrunAll":"Ejecutar en seco todos los paquetes","ui.packages.changesReset":"Restablecer cambios","ui.packages.changesReview":"Revisar cambios","ui.packagelist.loading":"Cargando ...","ui.packagelist.uploads":"Subidas","ui.packagelist.added":"Neuvos paquetes","ui.packagelist.installed":"paquetes instalados","ui.package.hintRevert":"Revertir cambios","ui.package.hintNoupdate":"No actualice","ui.package.hintConstraint":"Este paquete se instalará con restricción {constraint} al aplicar los cambios.","ui.package.hintConstraintBest":"Este paquete se instalará en la mejor versión disponible cuando aplique los cambios.","ui.package.hintConstraintChange":"La restricción para este paquete cambiará de \\"{from}\\" a \\"{to}\\" cuando aplique los cambios.","ui.package.hintConstraintUpdate":"Este paquete se actualizará cuando aplique los cambios.","ui.package.hintAdded":"Este paquete se instalará cuando aplique los cambios.","ui.package.hintRemoved":"Este paquete se eliminará cuando aplique los cambios.","ui.package.requiredTitle":"agregado manualmente","ui.package.requiredText":"Este paquete es obligatorio en su composer.json pero no está instalado.","ui.package.removedTitle":"Eliminado manualmente","ui.package.removedText":"Este paquete se eliminó de su composer.json.","ui.package.installed":"Actualmente instalado:","ui.package.version":"Versión {version}","ui.package.additionalDownloads":"{count} Descargar | {count} Descargas","ui.package.additionalStars":"{count} estrella | {count} estrellas","ui.package.editConstraint":"Editar","ui.package.uploadConstraint":"Esta restricción está definida por el paquete cargado.","ui.package.updateButton":"Actualizar","ui.package.removeButton":"Eliminar","ui.package.installButton":"Agregar paquete","ui.package.installButtonShort":"Añadir","ui.package.detailsButton":"Detalles","ui.package.latestConstraint":"Última versión","ui.package.update":"Actualización disponible ","ui.package.updateLatest":"Última versión","ui.package.updateAvailable":"{version} disponible","ui.package.updateUnknown":"versión desconocida ","ui.package.updateConstraint":"Hay disponible una versión más nueva fuera de su restricción de versión.","ui.package.incompatible":"{package} no funciona con Contao {constraint}.","ui.cloudStatus.headline":"Compositor Resolver Cloud","ui.cloudStatus.version":"Versión {version}","ui.cloudStatus.waitingTime":"Tiempo de espera","ui.cloudStatus.jobs":"Trabajos actuales","ui.cloudStatus.workers":"Trabajadores","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"ninguno","ui.cloudStatus.short":"aprox. {minutes} min","ui.cloudStatus.long":"aprox. {minutes} min {seconds} seg","ui.cloudStatus.error":"No se puede obtener el estado del Composer Resolver Cloud. Puede haber una ventana de mantenimiento o problemas del sistema.","ui.cloudStatus.button":"Cloud-Status ","ui.cloudStatus.refresh":"Actualizar el Cloud-Status","ui.log-viewer.loading":"Cargando ...","ui.log-viewer.empty":"No hay archivos de registro en su servidor.","ui.log-viewer.reload":"Recargar","ui.log-viewer.file":"Archivo de registro","ui.log-viewer.channel":"Canal","ui.log-viewer.channelTitle":"El canal en el que se registró este mensaje.","ui.log-viewer.level":"Nivel","ui.log-viewer.levelTitle":"Gravedad del mensaje de registro.","ui.log-viewer.timeHeader":"Tiempo","ui.log-viewer.messageHeader":"Mensaje","ui.log-viewer.showContext":"Mostrar contenido","ui.log-viewer.hideContext":"Ocultar contenido","ui.log-viewer.showExtra":"Mostrar Extra","ui.log-viewer.hideExtra":"Ocultar Extra","ui.log-viewer.more":"Cargar más ...","ui.log-viewer.download":"Descargar","ui.log-viewer.downloadTitle":"Descargar archivo \\"{file}\\"","ui.log-viewer.prodEnvironment":"Entorno de producción","ui.log-viewer.devEnvironment":"Entorno de desarrollo (Debug Mode)","ui.user-manager.loading":"Cargando usuarios…","ui.user-manager.changePassword":"Cambiar contraseña","ui.user-manager.setupTotp":"Configurar la autenticación de dos factores","ui.user-manager.disableTotp":"Deshabilitar la autenticación de dos factores","ui.user-manager.invite":"Invitar usuario","ui.user-manager.delete":"Borrar","ui.user-manager.deleteConfirm":"¿Está seguro de que desea eliminar el usuario \\"{username}\\"?","ui.user-manager.deleted":"El usuario {username} fue eliminado exitosamente","ui.user-manager.passwordHeadline":"Cambiar contraseña","ui.user-manager.passwordText":"Para cambiar su contraseña, ingrese la contraseña actual y la nueva en los campos respectivos.","ui.user-manager.currentPassword":"Contraseña actual","ui.user-manager.newPassword":"Nueva contraseña","ui.user-manager.passwordPlaceholder":"min. 8 caracteres","ui.user-manager.submitPassword":"Enviar","ui.user-manager.passwordChanged":"Su contraseña ha sido cambiada exitosamente","ui.user-manager.passwordError":"Esta contraseña es incorrecta.","ui.user-manager.inviteHeadline":"Invitar usuario","ui.user-manager.inviteText":"Si necesita varios inicios de sesión para Contao Manager, puede crear un enlace de invitación aquí. Comparta este enlace con alguien o úselo en otro dispositivo para crear una nueva cuenta con los permisos otorgados.","ui.user-manager.inviteSuccess1":"Se ha creado un nuevo enlace de invitación. La URL que aparece a continuación se puede utilizar para crear una nueva cuenta de usuario para este administrador de cuentas. La invitación vence el {expires} (dentro de una semana).","ui.user-manager.inviteSuccess2":"Copie el enlace en su portapapeles. Solo funcionará una vez y no podra verlo nuevamente luego de cerrar este cuadro de diálogo.","ui.user-manager.createInvitation":"Crear enlace de invitación","ui.user-manager.clipboard":"Copiar al portapapeles","ui.user-manager.permissions":"Obtenga más información sobre los permisos","ui.user-manager.cancel":"Cancelar","ui.user-manager.close":"Cerrar","ui.user-manager.you":"Usted","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"Autenticación de dos factores","ui.totp.setupQr":"Escanee el código QR con su aplicación 2FA/TOTP.","ui.totp.setupCode":"Si no puede escanear el código QR, ingrese esta clave en su lugar:","ui.totp.codeLabel":"Código de verificación","ui.totp.codeDescription":"Ingrese el código de verificación generado por su aplicación 2FA/TOTP.","ui.totp.disableText":"Ingrese el código de verificación para desactivar la autenticación de dos factores.","ui.totp.invalid":"El código de verificación no es válido.","ui.totp.enable":"Habilitar","ui.totp.disable":"Deshabilitar","ui.totp.cancel":"Cancelar","ui.totp.enabled":"La autenticación de dos factores se habilitó correctamente.","ui.totp.disabled":"La autenticación de dos factores se deshabilitó correctamente.","ui.totp.setup":"Configurar la autenticación de dos factores","ui.totp.skip":"Skip Two-Factor Authentication"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[909],{3909:function(e,i,o){o.r(i),o.d(i,{default:function(){return C}});var t=o(641),s=o(3751),l=o(33),n=o(6894);const a={key:0,class:"view-login__locked"},r={key:0,class:"view-login__form"},g={class:"view-login__headline"},d={class:"view-login__description"},u={class:"view-login__or"},p=["href"],c={key:1,class:"view-login__form"},_={class:"view-login__headline"},h={class:"view-login__description"};function m(e,i,o,m,k,w){const b=(0,t.g2)("i18n-t"),f=(0,t.g2)("text-field"),v=(0,t.g2)("loading-button"),y=(0,t.g2)("boxed-layout");return(0,t.uX)(),(0,t.Wv)(y,{slotClass:"view-login"},{default:(0,t.k6)((()=>[i[7]||(i[7]=(0,t.Lk)("header",{class:"view-login__header"},[(0,t.Lk)("img",{src:n,width:"80",height:"80",alt:"Contao Logo"}),(0,t.Lk)("p",{class:"view-login__product"},"Contao Manager")],-1)),e.locked?((0,t.uX)(),(0,t.CE)("main",a,[(0,t.bF)(b,{tag:"p",keypath:"ui.login.locked"},{lockFile:(0,t.k6)((()=>i[6]||(i[6]=[(0,t.Lk)("strong",null,"contao-manager/login.lock",-1),(0,t.Lk)("br",null,null,-1)]))),_:1})])):((0,t.uX)(),(0,t.Wv)(s.eB,{key:1,name:"animate-flip",type:"transition",mode:"out-in"},{default:(0,t.k6)((()=>[e.requires_totp?((0,t.uX)(),(0,t.CE)("main",c,[(0,t.Lk)("form",{onSubmit:i[5]||(i[5]=(0,s.D$)(((...e)=>w.login&&w.login(...e)),["prevent"]))},[(0,t.Lk)("h1",_,(0,l.v_)(e.$t("ui.login.totpHeadline")),1),(0,t.Lk)("p",h,(0,l.v_)(e.$t("ui.login.totpDescription")),1),(0,t.bF)(f,{name:"totp",required:"",minlength:"6",maxlength:"6",autocomplete:"one-time-code",label:e.$t("ui.login.totp"),placeholder:e.$t("ui.login.totp"),class:(0,l.C4)(["view-login__totp",e.login_failed?"widget--error":""]),disabled:e.logging_in,modelValue:e.totp,"onUpdate:modelValue":i[3]||(i[3]=i=>e.totp=i),onInput:w.reset},null,8,["label","placeholder","class","disabled","modelValue","onInput"]),(0,t.bF)(v,{submit:"",class:"view-login__button",color:"primary",disabled:!w.totpValid||e.login_failed,loading:e.logging_in},{default:(0,t.k6)((()=>[(0,t.eW)((0,l.v_)(e.$t("ui.login.button")),1)])),_:1},8,["disabled","loading"]),(0,t.Lk)("button",{class:"widget-button view-login__button",onClick:i[4]||(i[4]=(...e)=>w.cancelTotp&&w.cancelTotp(...e))},(0,l.v_)(e.$t("ui.login.cancel")),1)],32)])):((0,t.uX)(),(0,t.CE)("main",r,[(0,t.Lk)("form",{onSubmit:i[2]||(i[2]=(0,s.D$)(((...e)=>w.login&&w.login(...e)),["prevent"]))},[(0,t.Lk)("h1",g,(0,l.v_)(e.$t("ui.login.headline")),1),(0,t.Lk)("p",d,(0,l.v_)(e.$t("ui.login.description")),1),(0,t.bF)(f,{ref:"username",name:"username",autocomplete:"username webauthn",label:e.$t("ui.login.username"),placeholder:e.$t("ui.login.username"),class:(0,l.C4)(["view-login__user",e.login_failed?"widget--error":""]),disabled:e.logging_in||e.passkey_login,modelValue:e.username,"onUpdate:modelValue":i[0]||(i[0]=i=>e.username=i),onInput:w.reset},null,8,["label","placeholder","class","disabled","modelValue","onInput"]),(0,t.bF)(f,{type:"password",name:"password",autocomplete:"current-password",label:e.$t("ui.login.password"),placeholder:e.$t("ui.login.password"),minlength:"8",class:(0,l.C4)(["view-login__password",e.login_failed?"widget--error":""]),disabled:e.logging_in||e.passkey_login,modelValue:e.password,"onUpdate:modelValue":i[1]||(i[1]=i=>e.password=i),onInput:w.reset},null,8,["label","placeholder","class","disabled","modelValue","onInput"]),(0,t.bF)(v,{submit:"",class:"view-login__button",color:"primary",disabled:!w.inputValid||e.login_failed||e.passkey_login,loading:e.logging_in&&!e.passkey_login},{default:(0,t.k6)((()=>[(0,t.eW)((0,l.v_)(e.$t("ui.login.button")),1)])),_:1},8,["disabled","loading"]),(0,t.Lk)("p",u,(0,l.v_)(e.$t("ui.login.or")),1),e.showPasskey?((0,t.uX)(),(0,t.Wv)(v,{key:0,class:"view-login__button",icon:"passkey",color:"primary",loading:e.passkey_login,disabled:e.logging_in,onClick:(0,s.D$)(w.passkeyLogin,["prevent"])},{default:(0,t.k6)((()=>[(0,t.eW)((0,l.v_)(e.$t("ui.login.passkey")),1)])),_:1},8,["loading","disabled","onClick"])):(0,t.Q3)("",!0),(0,t.Lk)("a",{href:`https://to.contao.org/docs/manager-password?lang=${e.$i18n.locale}`,target:"_blank",class:"view-login__link"},(0,l.v_)(e.$t("ui.login.forgotPassword")),9,p)],32)]))])),_:1}))])),_:1,__:[7]})}var k=o(6278),w=o(60),b=o(707),f=o(728),v=o(9757),y=o(85),$={components:{BoxedLayout:f.A,TextField:v.A,LoadingButton:y.A},data:()=>({username:"",password:"",totp:"",logging_in:!1,passkey_login:!1,requires_totp:!1,login_failed:!1,showPasskey:!1}),computed:{...(0,k.aH)(["locked"]),inputValid(){return""!==this.username&&""!==this.password&&this.password.length>=8},totpValid(){return""!==this.totp&&/^\d{6}$/.test(this.totp)}},methods:{async login(){this.inputValid&&this.doLogin({username:this.username,password:this.password,totp:this.totp})},async passkeyLogin({useBrowserAutofill:e}){this.passkey_login=!e;const i=(await this.$request.get("api/session/options")).data;try{const o=await(0,w.HS)({optionsJSON:i,useBrowserAutofill:!!e});await this.doLogin({passkey:JSON.stringify(o)})}catch(o){}this.passkey_login=!1},async doLogin(e){this.logging_in=!0;const i=await this.$store.dispatch("auth/login",e);201===i.status?this.$store.commit("setView",b.A.BOOT):401===i.status&&i.data.totp_enabled?(this.logging_in=!1,this.requires_totp=!0,this.login_failed=!!this.totp):(this.logging_in=!1,this.login_failed=!0)},reset(){this.login_failed=!1},cancelTotp(){this.username="",this.password="",this.totp="",this.logging_in=!1,this.requires_totp=!1,this.login_failed=!1}},async mounted(){if(this.$store.commit("setError",null),this.locked)return;if(this.$refs.username&&this.$refs.username.focus(),"https:"!==location.protocol)return void(this.showPasskey=!1);const e=(0,w.zZ)(),i=await(0,w.ZF)();this.showPasskey=e,e&&i&&this.passkeyLogin({useBrowserAutofill:!0})}},L=o(6262);const V=(0,L.A)($,[["render",m]]);var C=V}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[335],{1035:function(e,s,c){c.r(s),c.d(s,{default:function(){return V}});var i=c(641),l=c(33),o=c(3751),t=c.p+"img/server-config.1a2d0888.svg";const n={class:"config-check__header"},r={class:"config-check__headline"},a={class:"config-check__description"},d={class:"config-check__form"},u={class:"config-check__fields"},g={class:"config-check__fieldtitle"},h={class:"config-check__fielddesc"},f={class:"config-check__fields"},_={class:"config-check__fieldtitle"},p={class:"config-check__fielddesc"},k={key:0,class:"config-check__issues"},v=["disabled"];function b(e,s,c,b,m,L){const $=(0,i.g2)("text-field"),w=(0,i.g2)("check-box"),C=(0,i.g2)("loading-button"),x=(0,i.g2)("boxed-layout");return(0,i.uX)(),(0,i.Wv)(x,{wide:!0,slotClass:"config-check"},{default:(0,i.k6)((()=>[(0,i.Lk)("header",n,[s[4]||(s[4]=(0,i.Lk)("img",{src:t,width:"80",height:"80",class:"config-check__icon",alt:""},null,-1)),(0,i.Lk)("h1",r,(0,l.v_)(e.$t("ui.server.config.title")),1),(0,i.Lk)("p",a,(0,l.v_)(e.$t("ui.server.config.description")),1)]),(0,i.Lk)("main",d,[(0,i.Lk)("form",{onSubmit:s[3]||(s[3]=(0,o.D$)(((...e)=>L.save&&L.save(...e)),["prevent"]))},[(0,i.Lk)("fieldset",u,[(0,i.Lk)("legend",g,(0,l.v_)(e.$t("ui.server.config.formTitle")),1),(0,i.Lk)("p",h,(0,l.v_)(e.$t("ui.server.config.formText")),1),(0,i.bF)($,{ref:"cli",name:"php_cli",label:e.$t("ui.server.config.cli"),required:"",disabled:e.processing,error:e.error,modelValue:e.php_cli,"onUpdate:modelValue":s[0]||(s[0]=s=>e.php_cli=s)},null,8,["label","disabled","error","modelValue"])]),(0,i.Lk)("fieldset",f,[(0,i.Lk)("legend",_,(0,l.v_)(e.$t("ui.server.config.cloudTitle")),1),(0,i.Lk)("p",p,(0,l.v_)(e.$t("ui.server.config.cloudText")),1),e.cloudIssues&&e.cloudIssues.length?((0,i.uX)(),(0,i.CE)("div",k,[(0,i.Lk)("p",null,(0,l.v_)(e.$t("ui.server.config.stateErrorCloud")),1),(0,i.Lk)("ul",null,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(e.cloudIssues,((e,s)=>((0,i.uX)(),(0,i.CE)("li",{key:s},(0,l.v_)(e),1)))),128))])])):(0,i.Q3)("",!0),(0,i.bF)(w,{name:"cloud",label:e.$t("ui.server.config.cloud"),disabled:e.processing,modelValue:e.cloud,"onUpdate:modelValue":s[1]||(s[1]=s=>e.cloud=s)},null,8,["label","disabled","modelValue"])]),(0,i.bF)(C,{submit:"",color:"primary",disabled:!e.php_cli,loading:e.processing},{default:(0,i.k6)((()=>[(0,i.eW)((0,l.v_)(e.$t("ui.server.config.save")),1)])),_:1},8,["disabled","loading"]),(0,i.Lk)("button",{type:"button",class:"widget-button",disabled:e.processing,onClick:s[2]||(s[2]=(...e)=>L.cancel&&L.cancel(...e))},(0,l.v_)(e.$t("ui.server.config.cancel")),9,v)],32)])])),_:1})}var m=c(728),L=c(9757),$=c(3480),w=c(85),C=c(707),x={components:{BoxedLayout:m.A,TextField:L.A,CheckBox:$.A,LoadingButton:w.A},data:()=>({processing:!0,error:"",php_cli:"",cloud:!0,cloudIssues:[]}),methods:{async save(){this.processing=!0,this.error="";const e={php_cli:this.php_cli,cloud:this.cloud},s=await this.$store.dispatch("server/config/set",e);400===s.status&&s.detail?(this.error=s.detail,this.processing=!1,setTimeout((()=>{this.$refs.cli.focus()}),0)):window.location.reload(!0)},cancel(){this.$store.commit("setView",C.A.BOOT)}},async mounted(){const e=await this.$store.dispatch("server/config/get");this.php_cli=e.php_cli,this.cloud=e.cloud.enabled,this.cloudIssues=e.cloud.issues,this.processing=!1}},y=c(6262);const T=(0,y.A)(x,[["render",b]]);var V=T}}]);(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[504],{33:function(e,t,n){"use strict";
/**
* @vue/shared v3.5.16
* (c) 2018-present Yuxi (Evan) You and Vue contributors
* @license MIT
**/
/*! #__NO_SIDE_EFFECTS__ */
function r(e){const t=Object.create(null);for(const n of e.split(","))t[n]=1;return e=>e in t}n.d(t,{$3:function(){return h},$H:function(){return F},BH:function(){return G},BX:function(){return re},Bm:function(){return E},C4:function(){return Q},CE:function(){return m},CP:function(){return u},DY:function(){return $},Gv:function(){return w},J$:function(){return ee},Kg:function(){return _},MZ:function(){return o},Mp:function(){return l},NO:function(){return a},Oj:function(){return i},PT:function(){return L},Qd:function(){return O},Ro:function(){return B},SU:function(){return R},TF:function(){return d},Tg:function(){return P},Tn:function(){return b},Tr:function(){return X},We:function(){return H},X$:function(){return c},Y2:function(){return te},ZH:function(){return M},Zf:function(){return k},_B:function(){return J},bB:function(){return U},cy:function(){return p},gd:function(){return y},p