<?php

declare(strict_types=1);

/*
 * This file is part of Contao.
 *
 * (c) Leo Feyer
 *
 * @license LGPL-3.0-or-later
 */

namespace Contao\CoreBundle\Job;

use Contao\CoreBundle\Translation\TranslatableLabelInterface;
use Symfony\Component\Translation\TranslatableMessage;

enum Status: string implements TranslatableLabelInterface
{
    case new = 'new';
    case pending = 'pending';
    case completed = 'completed';

    public function label(): TranslatableMessage
    {
        return new TranslatableMessage('jobs.statusLabel.'.$this->getTranslationKey(), [], 'contao_jobs');
    }

    private function getTranslationKey(): string
    {
        return match ($this) {
            self::new => 'new',
            self::pending => 'pending',
            self::completed => 'completed',
        };
    }
}
