<?php

/*
 * This file is part of the FOSHttpCacheBundle package.
 *
 * (c) FriendsOfSymfony <http://friendsofsymfony.github.com/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FOS\HttpCacheBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Announce the log listener to the symfony event system.
 */
final class LoggerPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        if (!$container->has('logger') || !$container->has('fos_http_cache.event_listener.log')) {
            return;
        }

        $container->getDefinition('fos_http_cache.event_listener.log')
            ->setAbstract(false)
            ->addTag('kernel.event_subscriber')
        ;
    }
}
