
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `cscart4182`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]access_restriction`
--

CREATE TABLE `[[dbprefix]]access_restriction` (
  `item_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `value` varchar(66) NOT NULL DEFAULT '',
  `ip_from` varbinary(40) NOT NULL DEFAULT '',
  `ip_to` varbinary(40) NOT NULL DEFAULT '',
  `type` char(3) NOT NULL DEFAULT '',
  `status` char(1) NOT NULL DEFAULT 'A',
  `timestamp` int(11) unsigned NOT NULL DEFAULT '0',
  `expires` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_id`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]access_restriction_block`
--

CREATE TABLE `[[dbprefix]]access_restriction_block` (
  `id_block` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ip` varbinary(40) NOT NULL DEFAULT '',
  `tries` smallint(5) unsigned NOT NULL DEFAULT '0',
  `timestamp` int(11) unsigned NOT NULL DEFAULT '0',
  `expires` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_block`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]access_restriction_reason_descriptions`
--

CREATE TABLE `[[dbprefix]]access_restriction_reason_descriptions` (
  `item_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` char(3) NOT NULL DEFAULT '',
  `reason` mediumtext,
  `lang_code` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`item_id`,`type`,`lang_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]addons`
--

CREATE TABLE `[[dbprefix]]addons` (
  `addon` varchar(32) NOT NULL DEFAULT '',
  `status` char(1) NOT NULL DEFAULT 'A',
  `version` varchar(16) NOT NULL DEFAULT '',
  `priority` int(11) unsigned NOT NULL DEFAULT '0',
  `dependencies` varchar(255) NOT NULL DEFAULT '',
  `conflicts` varchar(255) NOT NULL DEFAULT '',
  `separate` tinyint(1) NOT NULL,
  `unmanaged` tinyint(1) NOT NULL,
  `has_icon` tinyint(1) NOT NULL,
  `install_datetime` int(11) NOT NULL DEFAULT '0',
  `marketplace_id` int(11) unsigned DEFAULT NULL,
  `marketplace_license_key` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`addon`),
  KEY `priority` (`priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]addons`
--

INSERT INTO `[[dbprefix]]addons` VALUES
('hidpi', 'A', '1.0', 1, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('social_buttons', 'A', '1.0', 100, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('paypal_checkout', 'A', '1.0', 100, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('onboarding_guide', 'A', '1.0', 100, '', '', 0, 1, 0, [[timestamp]], NULL, NULL),
('help_center', 'A', '1.0', 100, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('tags', 'A', '1.0', 200, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('rss_feed', 'A', '1.0', 490, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('newsletters', 'A', '1.0', 500, '', 'email_marketing', 0, 0, 0, [[timestamp]], NULL, NULL),
('email_marketing', 'D', '1.0', 500, '', 'newsletters', 1, 0, 0, [[timestamp]], NULL, NULL),
('attachments', 'A', '1.0', 600, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('customers_also_bought', 'A', '1.0', 900, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('vendor_communication', 'A', '1.0', 1000, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('advanced_import', 'A', '1.0.0', 1000, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('geo_maps', 'A', '1.0', 1000, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('gift_certificates', 'A', '1.0', 1100, '', 'catalog_mode', 0, 0, 0, [[timestamp]], NULL, NULL),
('store_locator', 'A', '1.0', 1200, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('product_variations', 'A', '1.0', 1500, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('recaptcha', 'A', '1.0', 1500, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('product_bundles', 'A', '1.0', 1520, '', 'buy_together', 0, 0, 0, [[timestamp]], NULL, NULL),
('rma', 'D', '1.0', 1600, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('blog', 'A', '1.0', 1700, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('bestsellers', 'A', '1.0', 1700, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('seo', 'A', '1.0', 1800, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('reward_points', 'A', '1.0', 1900, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('google_analytics', 'D', '1.0', 2000, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('facebook_pixel', 'D', '1.0', 2000, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('call_requests', 'A', '1.0', 2300, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('form_builder', 'A', '1.0', 2400, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('barcode', 'A', '1.0', 2500, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('polls', 'D', '1.0', 2600, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('access_restrictions', 'D', '1.0', 2700, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('banners', 'A', '1.0', 2800, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('discussion', 'A', '1.0', 3000, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('watermarks', 'D', '1.0', 3000, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('product_reviews', 'A', '1.0', 3001, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('wishlist', 'A', '1.0', 3100, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('image_zoom', 'A', '1.0', 3500, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('google_sitemap', 'A', '1.0', 3500, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('required_products', 'A', '1.0', 3900, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('data_feeds', 'A', '1.0', 4000, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('price_list', 'A', '1.0', 4100, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('janrain', 'D', '1.0', 4200, '', 'loginza,hybrid_auth', 0, 0, 0, [[timestamp]], NULL, NULL),
('catalog_mode', 'D', '1.0', 4200, '', 'buy_together,gift_certificates,product_configurator', 0, 0, 0, [[timestamp]], NULL, NULL),
('hybrid_auth', 'A', '1.0', 4200, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('zapier', 'A', '1.0', 4320, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('price_per_unit', 'A', '1.0', 4330, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('gdpr', 'A', '1.0', 9999, '', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('shopify_import', 'A', '1.0', 4328362, 'product_variations', '', 0, 0, 0, [[timestamp]], NULL, NULL),
('tech_support_chat', 'A', '1.0', 4294967294, '', '', 0, 1, 0, [[timestamp]], NULL, NULL),
('my_changes', 'D', '1.0', 4294967294, '', '', 0, 0, 0, [[timestamp]], NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]addon_data`
--

CREATE TABLE `[[dbprefix]]addon_data` (
  `addon` varchar(32) NOT NULL DEFAULT '',
  `is_favorite` char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`addon`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]addon_descriptions`
--

CREATE TABLE `[[dbprefix]]addon_descriptions` (
  `addon` varchar(32) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT '',
  `lang_code` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`addon`,`lang_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]addon_descriptions`
--

INSERT INTO `[[dbprefix]]addon_descriptions` VALUES
('hidpi', 'HiDPI displays support', 'Support for Retina displays', 'en'),
('social_buttons', 'Social buttons', 'Adds the buttons for sharing products and pages in social media (Twitter, Facebook, etc.). Helps social networks and messengers to display better previews for the links to your site', 'en'),
('paypal_checkout', 'PayPal Complete Payments', 'A PayPal solution for online stores. Lets you accept payments through PayPal and other means.', 'en'),
('onboarding_guide', 'Onboarding guide', 'Introduces the marketplace to administrators and allows quickly set up basic functionality.', 'en'),
('help_center', 'Help center', 'Adds a help button with links to relevant documentation and/or videos to various pages in the admin panel.', 'en'),
('tags', 'Tags', 'Enables product tags', 'en'),
('rss_feed', 'RSS feed', 'Generates RSS feeds for products and blog posts', 'en'),
('newsletters', 'Newsletters', 'Lets you configure newsletter sending', 'en'),
('email_marketing', 'E-mail marketing', 'Synchronizes your newsletter subscriber lists with MailChimp and Mad Mimi', 'en'),
('attachments', 'Attachments', 'Makes it possible to attach files to products', 'en'),
('customers_also_bought', 'Customers also bought', 'Makes it possible to create a special block for the products often purchased along with the current one', 'en'),
('vendor_communication', 'Message center', 'Allows customers, vendors, and administrators to contact each other via the built-in chat.', 'en'),
('advanced_import', 'Advanced products import', 'Allows you to match the fields in the imported file with the product properties. These matchings and other import settings can also be saved as presets for later use.', 'en'),
('geo_maps', 'Maps and geolocation', 'Enables Google or Yandex maps and geolocation functionality in your store.', 'en'),
('gift_certificates', 'Gift certificates', 'Adds a built-in gift certificate system', 'en'),
('store_locator', 'Stores and pickup points', 'Allows you to mark your physical stores on the map and offer your customers to collect orders from there, if a corresponding shipping method is configured.', 'en'),
('product_variations', 'Product Variations', 'Create products with different feature variants (for example, a different color or size), and let customers select the desired variant.', 'en'),
('recaptcha', 'Google reCAPTCHA', 'Adds the support of Google reCAPTCHA to protect your store against bots', 'en'),
('product_bundles', 'Product bundles', 'Allows you to create product bundles and set up discounts for them.', 'en'),
('rma', 'RMA', 'Adds a return management system', 'en'),
('blog', 'Blog', 'Lets you start your blog easily', 'en'),
('bestsellers', 'Bestsellers & On-Sale Products', 'Collects best selling & on sale product data and adds block fillings to show such products', 'en'),
('seo', 'SEO', 'Adds Search engine-friendly URLs support', 'en'),
('reward_points', 'Reward points', 'Lets customers earn and spend points for purchases', 'en'),
('google_analytics', 'Google Analytics', 'Integrates a Google Analytics service with the store', 'en'),
('facebook_pixel', 'Facebook Pixel', 'Integrates a Facebook Pixel with the store', 'en'),
('call_requests', 'Call requests', 'Adds the "Buy now with one click" and "Request call" buttons', 'en'),
('form_builder', 'Form builder', 'Lets you create custom forms (e.g. Contact us)', 'en'),
('barcode', 'Order barcode', 'Makes it possible to configure and attach barcodes to orders', 'en'),
('polls', 'Polls', 'Adds a possibility to add customized polls to the site', 'en'),
('access_restrictions', 'Access restrictions', 'Lets you limit storefront and administrator area access to certain IP-addresses with different options', 'en'),
('banners', 'Banners management', 'Allows you to create text and visual banners', 'en'),
('discussion', 'Comments and reviews', 'Lets customers leave comments to categories, pages, etc., review vendors and write testimonials', 'en'),
('watermarks', 'Watermarks', 'Allows you to add watermarks to product and category images', 'en'),
('product_reviews', 'Product reviews', 'Allows your customers to leave reviews for products. That can build up trust, provide social proof, and add user-generated content to your site.', 'en'),
('wishlist', 'Wish List', 'Lets customers store items in personal wish lists', 'en'),
('image_zoom', 'Image zoom', 'Shows zoomed image on product image hover', 'en'),
('google_sitemap', 'Google sitemap', 'Creates a sitemap.xml for Google', 'en'),
('required_products', 'Required products', 'Makes it possible to specify products required for purchase', 'en'),
('data_feeds', 'Data feeds', 'Makes it possible to create product data feeds in CSV', 'en'),
('price_list', 'Price list', 'Generates configurable price list in PDF or XLS', 'en'),
('janrain', 'Janrain', 'Adds the Social Login feature; allows customers use Facebook, Twitter, etc. to log in on the store', 'en'),
('catalog_mode', 'Catalog mode', 'Allows you to use the store as a product catalog', 'en'),
('hybrid_auth', 'Social login', 'Adds the Social Login feature; allows customers use Facebook, Twitter, etc. to log in on the store', 'en'),
('zapier', 'Integration with Zapier', 'Allows you to integrate CS-Cart with over 4 000 other apps through Zapier.', 'en'),
('price_per_unit', 'Price per unit', 'Allows you to display price per unit on catalog and product pages.', 'en'),
('gdpr', 'GDPR Compliance (EU)', 'Helps you to comply with GDPR (a European Union regulation on personal data) by showing customers info about their personal data, asking their consent for its processing, and by offering ways to delete or export personal data.', 'en'),
('shopify_import', 'Import from Shopify', 'Allows you to import products from Shopify.', 'en'),
('tech_support_chat', 'Techical support chat', 'Adds live chat with the technical support team int the Administration panel', 'en'),
('my_changes', 'My Changes (example add-on)', 'A dummy add-on to let devs see how add-ons work. You can also use it to introduce small changes not worthy of a separate add-on', 'en');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]also_bought_products`
--

CREATE TABLE `[[dbprefix]]also_bought_products` (
  `product_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `related_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `amount` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`,`related_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]also_bought_products`
--

INSERT INTO `[[dbprefix]]also_bought_products` VALUES
(12, 11, 1),
(12, 7, 1),
(12, 79, 1),
(11, 12, 1),
(7, 12, 1),
(79, 12, 1),
(114, 199, 1),
(199, 114, 1),
(21, 112, 1),
(21, 110, 1),
(110, 21, 1),
(112, 21, 1),
(18, 108, 1),
(18, 103, 1),
(108, 18, 1),
(103, 18, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]attachments`
--

CREATE TABLE `[[dbprefix]]attachments` (
  `attachment_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `object_type` varchar(30) NOT NULL DEFAULT '',
  `object_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `type` char(1) NOT NULL DEFAULT '',
  `position` int(11) NOT NULL DEFAULT '0',
  `filename` varchar(100) NOT NULL DEFAULT '',
  `filesize` int(11) unsigned NOT NULL DEFAULT '0',
  `usergroup_ids` varchar(255) NOT NULL DEFAULT '0',
  `status` char(1) NOT NULL DEFAULT 'A',
  `on_server` char(1) NOT NULL DEFAULT 'Y',
  `url` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`attachment_id`),
  KEY `object_type` (`object_type`,`object_id`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]attachment_descriptions`
--

CREATE TABLE `[[dbprefix]]attachment_descriptions` (
  `attachment_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `lang_code` char(2) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`attachment_id`,`lang_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]banners`
--

CREATE TABLE `[[dbprefix]]banners` (
  `banner_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `status` char(1) NOT NULL DEFAULT 'A',
  `type` char(1) NOT NULL DEFAULT 'G',
  `target` char(1) NOT NULL DEFAULT 'B',
  `localization` varchar(255) NOT NULL DEFAULT '',
  `timestamp` int(11) unsigned NOT NULL DEFAULT '0',
  `company_id` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`banner_id`),
  KEY `localization` (`localization`),
  KEY `status` (`status`),
  KEY `company_id` (`company_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=23 ;

--
-- Dumping data for table `[[dbprefix]]banners`
--

INSERT INTO `[[dbprefix]]banners` VALUES
(7, 'A', 'G', 'T', '', [[timestamp]], 1),
(8, 'A', 'G', 'T', '', [[timestamp]], 1),
(16, 'A', 'G', 'T', '', [[timestamp]], 1),
(17, 'A', 'G', 'T', '', [[timestamp]], 1),
(18, 'A', 'G', 'T', '', [[timestamp]], 1),
(19, 'A', 'G', 'T', '', [[timestamp]], 1),
(6, 'A', 'G', 'T', '', [[timestamp]], 1),
(9, 'A', 'G', 'T', '', [[timestamp]], 1),
(20, 'A', 'G', 'T', '', [[timestamp]], 1),
(21, 'A', 'G', 'T', '', [[timestamp]], 1),
(22, 'A', 'G', 'T', '', [[timestamp]], 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]banner_descriptions`
--

CREATE TABLE `[[dbprefix]]banner_descriptions` (
  `banner_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `banner` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext,
  `lang_code` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`banner_id`,`lang_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]banner_descriptions`
--

INSERT INTO `[[dbprefix]]banner_descriptions` VALUES
(6, 'Free shipping', 'index.php?dispatch=pages.view&page_id=22', '', 'en'),
(7, 'Gift certificate', 'gift_certificates.add', '', 'en'),
(8, 'Holiday gift guide', 'gift_certificates.add', '', 'en'),
(9, 'Discount if select pickup', 'index.php?dispatch=pages.view&page_id=20', '', 'en'),
(16, 'Final sale', 'index.php?dispatch=products.final_sale', '', 'en'),
(17, 'X-Box', 'index.php?dispatch=products.view&product_id=248', '', 'en'),
(18, 'Bonus points', 'index.php?dispatch=pages.view&page_id=23', '', 'en'),
(19, 'Gift certificates', 'index.php?dispatch=pages.view&page_id=19', '', 'en'),
(20, 'X-Box Mobile', 'index.php?dispatch=products.view&product_id=5764', '', 'en'),
(21, 'Acme Mobile', 'index.php?dispatch=pages.view&page_id=25', '', 'en'),
(22, 'Multivendor demo mobile', 'index.php?dispatch=pages.view&page_id=24', '', 'en');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]banner_images`
--

CREATE TABLE `[[dbprefix]]banner_images` (
  `banner_image_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `banner_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `lang_code` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`banner_image_id`),
  UNIQUE KEY `banner` (`banner_id`,`lang_code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=48 ;

--
-- Dumping data for table `[[dbprefix]]banner_images`
--

INSERT INTO `[[dbprefix]]banner_images` VALUES
(16, 7, 'en'),
(39, 6, 'en'),
(40, 9, 'en'),
(18, 8, 'en'),
(35, 16, 'en'),
(36, 17, 'en'),
(37, 18, 'en'),
(38, 19, 'en'),
(41, 20, 'en'),
(42, 21, 'en'),
(47, 22, 'en');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blog_authors`
--

CREATE TABLE `[[dbprefix]]blog_authors` (
  `page_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`page_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]blog_authors`
--

INSERT INTO `[[dbprefix]]blog_authors` VALUES
(7, 1),
(8, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bm_blocks`
--

CREATE TABLE `[[dbprefix]]bm_blocks` (
  `block_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(64) NOT NULL DEFAULT '',
  `properties` text,
  `company_id` int(11) unsigned NOT NULL DEFAULT '0',
  `storefront_id` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`block_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=54 ;

--
-- Dumping data for table `[[dbprefix]]bm_blocks`
--

INSERT INTO `[[dbprefix]]bm_blocks` VALUES
(1, 'languages', 'a:3:{s:8:"template";s:20:"blocks/languages.tpl";s:6:"format";s:4:"icon";s:14:"dropdown_limit";s:1:"0";}', 1, 1),
(2, 'currencies', 'a:3:{s:8:"template";s:21:"blocks/currencies.tpl";s:6:"format";s:6:"symbol";s:14:"dropdown_limit";s:1:"3";}', 1, 1),
(3, 'menu', 'a:2:{s:8:"template";s:26:"blocks/menu/text_links.tpl";s:18:"show_items_in_line";s:1:"Y";}', 1, 1),
(4, 'my_account', 'a:1:{s:8:"template";s:21:"blocks/my_account.tpl";}', 1, 1),
(5, 'template', 'a:2:{s:8:"template";s:32:"blocks/static_templates/logo.tpl";s:11:"enable_link";s:1:"Y";}', 1, 1),
(6, 'call_request', 'a:1:{s:8:"template";s:44:"addons/call_requests/blocks/call_request.tpl";}', 1, 1),
(7, 'template', 'a:1:{s:8:"template";s:34:"blocks/static_templates/search.tpl";}', 1, 1),
(8, 'cart_content', 'a:5:{s:8:"template";s:23:"blocks/cart_content.tpl";s:22:"display_bottom_buttons";s:1:"Y";s:20:"display_delete_icons";s:1:"Y";s:19:"products_links_type";s:5:"thumb";s:20:"generate_block_title";s:1:"Y";}', 1, 1),
(9, 'menu', 'a:3:{s:8:"template";s:35:"blocks/menu/dropdown_horizontal.tpl";s:30:"dropdown_second_level_elements";s:2:"12";s:29:"dropdown_third_level_elements";s:1:"6";}', 1, 1),
(10, 'breadcrumbs', 'a:1:{s:8:"template";s:22:"common/breadcrumbs.tpl";}', 1, 1),
(11, 'main', '', 1, 1),
(12, 'template', 'a:1:{s:8:"template";s:65:"addons/newsletters/blocks/static_templates/subscribe_advanced.tpl";}', 1, 1),
(13, 'safe_smarty_block', 'a:1:{s:8:"template";s:28:"blocks/safe_smarty_block.tpl";}', 1, 1),
(14, 'template', 'a:1:{s:8:"template";s:53:"blocks/static_templates/my_account_links_advanced.tpl";}', 1, 1),
(15, 'menu', 'a:2:{s:8:"template";s:26:"blocks/menu/text_links.tpl";s:18:"show_items_in_line";s:1:"N";}', 1, 1),
(16, 'menu', 'a:2:{s:8:"template";s:26:"blocks/menu/text_links.tpl";s:18:"show_items_in_line";s:1:"N";}', 1, 1),
(17, 'safe_smarty_block', 'a:1:{s:8:"template";s:28:"blocks/safe_smarty_block.tpl";}', 1, 1),
(18, 'template', 'a:1:{s:8:"template";s:37:"blocks/static_templates/copyright.tpl";}', 1, 1),
(19, 'template', 'a:1:{s:8:"template";s:41:"blocks/static_templates/payment_icons.tpl";}', 1, 1),
(20, 'banners', 'a:3:{s:8:"template";s:34:"addons/banners/blocks/carousel.tpl";s:10:"navigation";s:1:"P";s:5:"delay";s:3:"333";}', 1, 1),
(21, 'banners', 'a:1:{s:8:"template";s:34:"addons/banners/blocks/original.tpl";}', 1, 1),
(22, 'banners', 'a:1:{s:8:"template";s:34:"addons/banners/blocks/original.tpl";}', 1, 1),
(23, 'products', 'a:11:{s:8:"template";s:37:"blocks/products/products_scroller.tpl";s:10:"show_price";s:1:"Y";s:17:"enable_quick_view";s:1:"N";s:24:"not_scroll_automatically";s:1:"Y";s:5:"speed";s:3:"400";s:15:"scroll_per_page";s:1:"Y";s:11:"pause_delay";s:1:"3";s:13:"item_quantity";s:1:"4";s:15:"thumbnail_width";s:3:"160";s:23:"hide_add_to_cart_button";s:1:"Y";s:18:"outside_navigation";s:1:"Y";}', 1, 1),
(24, 'products', 'a:4:{s:8:"template";s:41:"blocks/products/products_multicolumns.tpl";s:11:"item_number";s:1:"N";s:17:"number_of_columns";s:1:"4";s:23:"hide_add_to_cart_button";s:1:"Y";}', 1, 1),
(25, 'blog', 'a:1:{s:8:"template";s:33:"addons/blog/blocks/text_links.tpl";}', 1, 1),
(26, 'testimonials', 'a:8:{s:8:"template";s:41:"addons/discussion/blocks/testimonials.tpl";s:5:"limit";s:2:"10";s:6:"random";s:1:"N";s:24:"not_scroll_automatically";s:1:"Y";s:5:"speed";s:3:"400";s:11:"pause_delay";s:1:"3";s:13:"item_quantity";s:1:"1";s:18:"outside_navigation";s:1:"N";}', 1, 1),
(27, 'our_brands', 'a:9:{s:8:"template";s:21:"blocks/our_brands.tpl";s:24:"not_scroll_automatically";s:1:"Y";s:5:"speed";s:3:"400";s:15:"scroll_per_page";s:1:"Y";s:11:"pause_delay";s:1:"3";s:13:"item_quantity";s:1:"7";s:11:"total_items";s:2:"14";s:15:"thumbnail_width";s:2:"75";s:18:"outside_navigation";s:1:"N";}', 1, 1),
(28, 'safe_smarty_block', 'a:1:{s:8:"template";s:28:"blocks/safe_smarty_block.tpl";}', 1, 1),
(29, 'products', 'a:4:{s:8:"template";s:41:"blocks/products/products_multicolumns.tpl";s:11:"item_number";s:1:"N";s:17:"number_of_columns";s:1:"2";s:23:"hide_add_to_cart_button";s:1:"Y";}', 1, 1),
(30, 'products', 'a:2:{s:8:"template";s:30:"blocks/products/short_list.tpl";s:23:"hide_add_to_cart_button";s:1:"Y";}', 1, 1),
(31, 'product_filters', 'a:1:{s:8:"template";s:48:"blocks/product_filters/for_category/original.tpl";}', 1, 1),
(32, 'products', 'a:3:{s:8:"template";s:40:"blocks/products/products_small_items.tpl";s:11:"item_number";s:1:"N";s:23:"hide_add_to_cart_button";s:1:"Y";}', 1, 1),
(33, 'template', 'a:2:{s:8:"template";s:32:"blocks/static_templates/logo.tpl";s:11:"enable_link";s:1:"N";}', 1, 1),
(34, 'lite_checkout_location', 'a:1:{s:8:"template";s:33:"blocks/lite_checkout/location.tpl";}', 1, 1),
(35, 'lite_checkout_shipping_methods', 'a:1:{s:8:"template";s:41:"blocks/lite_checkout/shipping_methods.tpl";}', 1, 1),
(36, 'lite_checkout_customer_sign_in', 'a:1:{s:8:"template";s:41:"blocks/lite_checkout/customer_sign_in.tpl";}', 1, 1),
(37, 'lite_checkout_customer_address', 'a:1:{s:8:"template";s:41:"blocks/lite_checkout/customer_address.tpl";}', 1, 1),
(38, 'lite_checkout_customer_information', 'a:1:{s:8:"template";s:45:"blocks/lite_checkout/customer_information.tpl";}', 1, 1),
(39, 'lite_checkout_customer_notes', 'a:1:{s:8:"template";s:39:"blocks/lite_checkout/customer_notes.tpl";}', 1, 1),
(40, 'lite_checkout_payment_methods', 'a:1:{s:8:"template";s:40:"blocks/lite_checkout/payment_methods.tpl";}', 1, 1),
(41, 'lite_checkout_customer_billing', 'a:1:{s:8:"template";s:41:"blocks/lite_checkout/customer_billing.tpl";}', 1, 1),
(42, 'lite_checkout_terms_and_conditions', 'a:1:{s:8:"template";s:45:"blocks/lite_checkout/terms_and_conditions.tpl";}', 1, 1),
(43, 'lite_checkout_newsletters', 'a:1:{s:8:"template";s:55:"addons/newsletters/blocks/lite_checkout/newsletters.tpl";}', 1, 1),
(44, 'checkout', 'a:1:{s:8:"template";s:36:"blocks/checkout/products_in_cart.tpl";}', 1, 1),
(45, 'checkout', 'a:1:{s:8:"template";s:27:"blocks/checkout/summary.tpl";}', 1, 1),
(46, 'template', 'a:1:{s:8:"template";s:37:"blocks/static_templates/auth_info.tpl";}', 1, 1),
(47, 'template', 'a:1:{s:8:"template";s:40:"blocks/static_templates/profile_info.tpl";}', 1, 1),
(48, 'template', 'a:1:{s:8:"template";s:31:"blocks/static_templates/404.tpl";}', 1, 1),
(49, 'product_filters', 'a:1:{s:8:"template";s:58:"blocks/product_filters/for_category/horizontal_filters.tpl";}', 1, 1),
(50, 'blog', 'a:1:{s:8:"template";s:35:"addons/blog/blocks/recent_posts.tpl";}', 1, 1),
(51, 'gift_certificates_verify', 'a:1:{s:8:"template";s:60:"addons/gift_certificates/blocks/gift_certificates_verify.tpl";}', 1, 1),
(52, 'products', 'a:5:{s:8:"template";s:61:"addons/product_variations/blocks/products/variations_list.tpl";s:46:"product_variations.hide_add_to_wishlist_button";s:1:"N";s:23:"hide_add_to_cart_button";s:1:"N";s:36:"product_variations.show_product_code";s:1:"Y";s:44:"product_variations.show_variation_thumbnails";s:1:"Y";}', 1, 1),
(53, 'product_bundles', 'a:1:{s:8:"template";s:49:"addons/product_bundles/blocks/product_bundles.tpl";}', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bm_blocks_content`
--

CREATE TABLE `[[dbprefix]]bm_blocks_content` (
  `snapping_id` int(11) unsigned NOT NULL,
  `object_id` int(11) unsigned NOT NULL DEFAULT '0',
  `object_type` varchar(64) NOT NULL DEFAULT '',
  `block_id` int(11) unsigned NOT NULL,
  `lang_code` char(2) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  PRIMARY KEY (`block_id`,`snapping_id`,`lang_code`,`object_id`,`object_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]bm_blocks_content`
--

INSERT INTO `[[dbprefix]]bm_blocks_content` VALUES
(0, 0, '', 1, 'en', 'a:1:{s:4:"text";s:0:"";}'),
(0, 0, '', 2, 'en', 'a:1:{s:4:"text";s:0:"";}'),
(0, 0, '', 3, 'en', 'a:1:{s:4:"menu";s:1:"1";}'),
(0, 0, '', 3, 'ru', 'a:1:{s:4:"menu";s:1:"1";}'),
(0, 0, '', 4, 'en', ''),
(0, 0, '', 5, 'en', ''),
(0, 0, '', 6, 'en', ''),
(0, 0, '', 7, 'en', ''),
(0, 0, '', 8, 'en', ''),
(0, 0, '', 9, 'en', 'a:1:{s:4:"menu";s:1:"2";}'),
(0, 0, '', 9, 'ru', 'a:1:{s:4:"menu";s:1:"2";}'),
(0, 0, '', 10, 'en', ''),
(0, 0, '', 11, 'en', ''),
(0, 0, '', 12, 'en', ''),
(0, 0, '', 13, 'en', 'a:1:{s:7:"content";s:773:"<div class="ty-social-link-block"><h3 class="ty-social-link__title">{__("get_social")}</h3>\n\n<div class="ty-social-link facebook">\n    <a href="http://www.facebook.com/pages/CS-Cart/156687676230"><span class="ty-icon ty-icon-facebook ty-icon-moon-facebook"></span></a>\n</div>\n\n<div class="ty-social-link instagram">\n    <a href="https://www.instagram.com"><span class="ty-icon ty-icon-instagram ty-icon-moon-instagram"></span></a>\n</div>\n\n<div class="ty-social-link twitter">\n    <a href="https://twitter.com/cscart"><span class="ty-icon ty-icon-twitter ty-icon-moon-twitter"></span></a>\n</div>\n\n<div class="ty-social-link youtube">\n    <a href="https://www.youtube.com/user/cscartvideos"><span class="ty-icon ty-icon-youtube ty-icon-moon-youtube"></span></a>\n</div></div>\n";}'),
(0, 0, '', 13, 'ru', 'a:1:{s:7:"content";s:772:"<div class="ty-social-link-block"><h3 class="ty-social-link__title">{__("get_social")}</h3>\n\n<div class="ty-social-link facebook">\n    <a href="http://www.facebook.com/pages/CS-Cart/156687676230"><span class="ty-icon ty-icon-facebook ty-icon-moon-facebook"></span></a>\n</div>\n\n<div class="ty-social-link instagram">\n    <a href="https://www.instagram.com"><span class="ty-icon ty-icon-instagram ty-icon-moon-instagram"></span></a>\n</div>\n\n<div class="ty-social-link twitter">\n    <a href="https://twitter.com/cscart"><span class="ty-icon ty-icon-twitter ty-icon-moon-twitter"></span></a>\n</div>\n\n<div class="ty-social-link youtube">\n    <a href="https://www.youtube.com/user/cscartvideos"><span class="ty-icon ty-icon-youtube ty-icon-moon-youtube"></span></a>\n</div></div>";}'),
(0, 0, '', 14, 'en', ''),
(0, 0, '', 15, 'en', 'a:1:{s:4:"menu";s:1:"3";}'),
(0, 0, '', 15, 'ru', 'a:1:{s:4:"menu";s:1:"3";}'),
(0, 0, '', 16, 'en', 'a:1:{s:4:"menu";s:1:"4";}'),
(0, 0, '', 16, 'ru', 'a:1:{s:4:"menu";s:1:"4";}'),
(0, 0, '', 17, 'en', 'a:1:{s:7:"content";s:394:"<ul>\n    <li>3993 Hanover Street<br/>New York, NY 10016\n</li>\n    <li><bdi>+19177227425</bdi> (call is free)</li>\n    <li><bdi>10 am — 6 pm</bdi><br/>\nMonday - Friday</li>\n    <li><a class="ty-exception__links-a greeny" href="mailto:sales@example.com">sales@example.com</a></li>\n\n    <li><a href="{"pages.view?page_id=20"|fn_url}" class="ty-exception__links-a">About company</a></li>\n\n</ul>\n\n";}'),
(0, 0, '', 17, 'ru', 'a:1:{s:7:"content";s:411:"<ul>\n    <li>3993 Hanover Street<br/>New York, NY 10016\n</li>\n    <li><bdi>+19177227425 (звонок бесплатный)</bdi></li>\n    <li><bdi>Пн-Пт 10.00 - 18.00</bdi></li>\n    <li><a class="ty-exception__links-a greeny" href="mailto:sales@example.com">sales@example.com</a></li>\n\n    <li><a href="{"pages.view?page_id=20"|fn_url}" class="ty-exception__links-a">О компании</a></li>\n\n</ul>\n\n\n\n";}'),
(0, 0, '', 18, 'en', ''),
(0, 0, '', 19, 'en', ''),
(0, 0, '', 20, 'en', 'a:1:{s:5:"items";a:4:{s:7:"filling";s:6:"newest";s:6:"period";s:1:"A";s:9:"last_days";s:1:"1";s:5:"limit";s:1:"4";}}'),
(0, 0, '', 20, 'ru', 'a:1:{s:5:"items";a:4:{s:7:"filling";s:6:"newest";s:6:"period";s:1:"A";s:9:"last_days";s:1:"1";s:5:"limit";s:1:"4";}}'),
(0, 0, '', 21, 'en', 'a:1:{s:5:"items";a:2:{s:7:"filling";s:8:"manually";s:8:"item_ids";s:1:"6";}}'),
(0, 0, '', 21, 'ru', 'a:1:{s:5:"items";a:2:{s:7:"filling";s:8:"manually";s:8:"item_ids";s:1:"6";}}'),
(0, 0, '', 22, 'en', 'a:1:{s:5:"items";a:2:{s:7:"filling";s:8:"manually";s:8:"item_ids";s:1:"9";}}'),
(0, 0, '', 22, 'ru', 'a:1:{s:5:"items";a:2:{s:7:"filling";s:8:"manually";s:8:"item_ids";s:1:"9";}}'),
(0, 0, '', 23, 'en', 'a:1:{s:5:"items";a:4:{s:7:"filling";s:6:"newest";s:6:"period";s:1:"A";s:9:"last_days";s:1:"1";s:5:"limit";s:1:"6";}}'),
(0, 0, '', 23, 'ru', 'a:1:{s:5:"items";a:4:{s:7:"filling";s:6:"newest";s:6:"period";s:1:"A";s:9:"last_days";s:1:"1";s:5:"limit";s:1:"6";}}'),
(0, 0, '', 24, 'en', 'a:1:{s:5:"items";a:3:{s:7:"filling";s:7:"on_sale";s:5:"limit";s:1:"8";s:3:"cid";s:0:"";}}'),
(0, 0, '', 24, 'ru', 'a:1:{s:5:"items";a:3:{s:7:"filling";s:7:"on_sale";s:5:"limit";s:1:"8";s:3:"cid";s:0:"";}}'),
(0, 0, '', 25, 'en', 'a:1:{s:5:"items";a:3:{s:7:"filling";s:15:"blog.text_links";s:14:"parent_page_id";s:1:"7";s:5:"limit";s:1:"5";}}'),
(0, 0, '', 25, 'ru', 'a:1:{s:5:"items";a:3:{s:7:"filling";s:15:"blog.text_links";s:14:"parent_page_id";s:1:"7";s:5:"limit";s:1:"5";}}'),
(0, 0, '', 26, 'en', ''),
(0, 0, '', 27, 'en', ''),
(0, 0, '', 28, 'en', 'a:1:{s:7:"content";s:1170:"<div class="ty-benefits-guarantees clearfix">\n<ul class="ty-benefits-guarantees__list">\n    <li class="ty-benefits-guarantees__item">\n        <a class="ty-benefits-guarantees__a" href="{"pages.view?page_id=6"|fn_url}">\n        <span class="ty-icon ty-benefits-guarantees__icon ty-benefits-low-price"></span>\n        <h4 class="ty-benefits-guarantees__title"><strong>Low price</strong> Guarantee</h4>\n        </a>\n    </li>\n    <li class="ty-benefits-guarantees__item">\n        <a class="ty-benefits-guarantees__a" href="{"pages.view?page_id=5"|fn_url}">\n        <span class="ty-icon ty-benefits-guarantees__icon ty-benefits-free-shipping"></span>\n        <h4 class="ty-benefits-guarantees__title"><strong>Free</strong> shipping</h4>\n        <p class="ty-benefits-guarantees__txt">Orders $19 and up.</p>\n        </a>\n    </li>\n    <li class="ty-benefits-guarantees__item">\n        <a class="ty-benefits-guarantees__a" href="{"pages.view?page_id=4"|fn_url}">\n        <span class="ty-icon ty-benefits-guarantees__icon ty-benefits-free-returns"></span>\n        <h4 class="ty-benefits-guarantees__title"><strong>Free</strong> returns</h4>\n        </a>\n    </li>\n</ul>\n\n</div>";}'),
(0, 0, '', 28, 'ru', 'a:1:{s:7:"content";s:1170:"<div class="ty-benefits-guarantees clearfix">\n<ul class="ty-benefits-guarantees__list">\n    <li class="ty-benefits-guarantees__item">\n        <a class="ty-benefits-guarantees__a" href="{"pages.view?page_id=6"|fn_url}">\n        <span class="ty-icon ty-benefits-guarantees__icon ty-benefits-low-price"></span>\n        <h4 class="ty-benefits-guarantees__title"><strong>Low price</strong> Guarantee</h4>\n        </a>\n    </li>\n    <li class="ty-benefits-guarantees__item">\n        <a class="ty-benefits-guarantees__a" href="{"pages.view?page_id=5"|fn_url}">\n        <span class="ty-icon ty-benefits-guarantees__icon ty-benefits-free-shipping"></span>\n        <h4 class="ty-benefits-guarantees__title"><strong>Free</strong> shipping</h4>\n        <p class="ty-benefits-guarantees__txt">Orders $19 and up.</p>\n        </a>\n    </li>\n    <li class="ty-benefits-guarantees__item">\n        <a class="ty-benefits-guarantees__a" href="{"pages.view?page_id=4"|fn_url}">\n        <span class="ty-icon ty-benefits-guarantees__icon ty-benefits-free-returns"></span>\n        <h4 class="ty-benefits-guarantees__title"><strong>Free</strong> returns</h4>\n        </a>\n    </li>\n</ul>\n\n</div>";}'),
(0, 0, '', 29, 'en', 'a:1:{s:5:"items";a:6:{s:7:"filling";s:7:"similar";s:5:"limit";s:1:"4";s:13:"percent_range";s:0:"";s:16:"similar_category";s:1:"Y";s:15:"similar_subcats";s:1:"Y";s:16:"similar_in_stock";s:1:"Y";}}'),
(0, 0, '', 29, 'ru', 'a:1:{s:5:"items";a:6:{s:7:"filling";s:7:"similar";s:5:"limit";s:1:"4";s:13:"percent_range";s:0:"";s:16:"similar_category";s:1:"Y";s:15:"similar_subcats";s:1:"Y";s:16:"similar_in_stock";s:1:"Y";}}'),
(0, 0, '', 30, 'en', 'a:1:{s:5:"items";a:6:{s:7:"filling";s:7:"similar";s:5:"limit";s:1:"3";s:13:"percent_range";s:1:"5";s:16:"similar_category";s:1:"N";s:15:"similar_subcats";s:1:"N";s:16:"similar_in_stock";s:1:"N";}}'),
(0, 0, '', 30, 'ru', 'a:1:{s:5:"items";a:6:{s:7:"filling";s:7:"similar";s:5:"limit";s:1:"3";s:13:"percent_range";s:1:"5";s:16:"similar_category";s:1:"N";s:15:"similar_subcats";s:1:"N";s:16:"similar_in_stock";s:1:"N";}}'),
(0, 0, '', 31, 'en', 'a:1:{s:5:"items";a:1:{s:7:"filling";s:8:"manually";}}'),
(0, 0, '', 31, 'ru', 'a:1:{s:5:"items";a:1:{s:7:"filling";s:8:"manually";}}'),
(0, 0, '', 32, 'en', 'a:1:{s:5:"items";a:2:{s:7:"filling";s:15:"recent_products";s:5:"limit";s:1:"3";}}'),
(0, 0, '', 32, 'ru', 'a:1:{s:5:"items";a:2:{s:7:"filling";s:15:"recent_products";s:5:"limit";s:1:"3";}}'),
(0, 0, '', 33, 'en', ''),
(0, 0, '', 34, 'en', 'a:1:{s:5:"items";a:3:{s:7:"filling";s:8:"manually";s:8:"item_ids";s:8:"23,25,27";s:8:"required";a:3:{s:11:"field_id_23";s:1:"N";s:11:"field_id_25";s:1:"N";s:11:"field_id_27";s:1:"N";}}}'),
(0, 0, '', 34, 'ru', 'a:1:{s:5:"items";a:3:{s:7:"filling";s:8:"manually";s:8:"item_ids";s:8:"23,25,27";s:8:"required";a:3:{s:11:"field_id_23";s:1:"N";s:11:"field_id_25";s:1:"N";s:11:"field_id_27";s:1:"N";}}}'),
(0, 0, '', 35, 'en', ''),
(0, 0, '', 36, 'en', ''),
(0, 0, '', 37, 'en', 'a:1:{s:5:"items";a:3:{s:7:"filling";s:8:"manually";s:8:"item_ids";s:5:"19,29";s:8:"required";a:2:{s:11:"field_id_19";s:1:"Y";s:11:"field_id_29";s:1:"Y";}}}'),
(0, 0, '', 37, 'ru', 'a:1:{s:5:"items";a:3:{s:7:"filling";s:8:"manually";s:8:"item_ids";s:5:"19,29";s:8:"required";a:2:{s:11:"field_id_19";s:1:"Y";s:11:"field_id_29";s:1:"Y";}}}'),
(0, 0, '', 38, 'en', 'a:1:{s:5:"items";a:3:{s:7:"filling";s:8:"manually";s:8:"item_ids";s:8:"6,7,9,32";s:8:"required";a:4:{s:10:"field_id_6";s:1:"N";s:10:"field_id_7";s:1:"N";s:10:"field_id_9";s:1:"N";s:11:"field_id_32";s:1:"Y";}}}'),
(0, 0, '', 38, 'ru', 'a:1:{s:5:"items";a:3:{s:7:"filling";s:8:"manually";s:8:"item_ids";s:8:"6,7,9,32";s:8:"required";a:4:{s:10:"field_id_6";s:1:"N";s:10:"field_id_7";s:1:"N";s:10:"field_id_9";s:1:"N";s:11:"field_id_32";s:1:"N";}}}'),
(0, 0, '', 39, 'en', ''),
(0, 0, '', 40, 'en', ''),
(0, 0, '', 41, 'en', 'a:1:{s:5:"items";a:3:{s:7:"filling";s:8:"manually";s:8:"item_ids";s:23:"14,16,30,18,28,22,24,26";s:8:"required";a:8:{s:11:"field_id_14";s:1:"N";s:11:"field_id_16";s:1:"N";s:11:"field_id_30";s:1:"N";s:11:"field_id_18";s:1:"N";s:11:"field_id_28";s:1:"N";s:11:"field_id_22";s:1:"N";s:11:"field_id_24";s:1:"N";s:11:"field_id_26";s:1:"N";}}}'),
(0, 0, '', 42, 'en', ''),
(0, 0, '', 43, 'en', ''),
(0, 0, '', 44, 'en', ''),
(0, 0, '', 45, 'en', ''),
(0, 0, '', 46, 'en', ''),
(0, 0, '', 47, 'en', ''),
(0, 0, '', 48, 'en', ''),
(0, 0, '', 49, 'en', 'a:1:{s:5:"items";a:2:{s:7:"filling";s:8:"manually";s:8:"item_ids";s:0:"";}}'),
(0, 0, '', 49, 'ru', 'a:1:{s:5:"items";a:1:{s:7:"filling";s:8:"manually";}}'),
(0, 0, '', 50, 'en', 'a:1:{s:5:"items";a:4:{s:7:"filling";s:17:"blog.recent_posts";s:6:"period";s:1:"A";s:9:"last_days";s:1:"1";s:5:"limit";s:1:"3";}}'),
(0, 0, '', 50, 'ru', 'a:1:{s:5:"items";a:4:{s:7:"filling";s:17:"blog.recent_posts";s:6:"period";s:1:"A";s:9:"last_days";s:1:"1";s:5:"limit";s:1:"3";}}'),
(0, 0, '', 51, 'en', ''),
(0, 0, '', 52, 'en', 'a:1:{s:5:"items";a:3:{s:7:"filling";s:37:"product_variations.variations_filling";s:5:"limit";s:3:"100";s:19:"variations_in_stock";s:1:"N";}}'),
(0, 0, '', 53, 'en', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bm_blocks_descriptions`
--

CREATE TABLE `[[dbprefix]]bm_blocks_descriptions` (
  `block_id` int(11) unsigned NOT NULL,
  `lang_code` char(2) NOT NULL DEFAULT '',
  `name` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`block_id`,`lang_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]bm_blocks_descriptions`
--

INSERT INTO `[[dbprefix]]bm_blocks_descriptions` VALUES
(1, 'en', 'Languages'),
(2, 'en', 'Currencies'),
(3, 'en', 'Quick links'),
(4, 'en', 'My Account'),
(5, 'en', 'Logo'),
(6, 'en', 'Call Request'),
(7, 'en', 'Search'),
(8, 'en', 'Cart content'),
(9, 'en', 'Main menu'),
(10, 'en', 'Breadcrumbs'),
(11, 'en', 'Main Content'),
(12, 'en', 'Subscribe'),
(13, 'en', 'Social links'),
(14, 'en', 'My account'),
(15, 'en', 'Shop'),
(16, 'en', 'Create order'),
(17, 'en', 'About us'),
(18, 'en', 'Copyright'),
(19, 'en', 'Payment icons'),
(20, 'en', 'Main banners'),
(21, 'en', 'Free shipping'),
(22, 'en', 'Discount for pickup'),
(23, 'en', 'Hot deals'),
(24, 'en', 'Sale'),
(25, 'en', 'Blog'),
(26, 'en', 'Reviews'),
(27, 'en', 'Brands'),
(28, 'en', 'Guarantees and benefits'),
(29, 'en', 'Similar products'),
(30, 'en', 'At the same price!'),
(31, 'en', 'Product filters'),
(32, 'en', 'Recently Viewed'),
(33, 'en', 'Logo without link'),
(34, 'en', 'Deliver to'),
(35, 'en', 'Shipping methods'),
(36, 'en', 'Customer'),
(37, 'en', 'Address'),
(38, 'en', 'Customer information'),
(39, 'en', 'Customer''s notes'),
(40, 'en', 'Payment methods'),
(41, 'en', 'Billing address'),
(42, 'en', 'Terms and conditions'),
(43, 'en', 'Sign up for our newsletters!'),
(44, 'en', 'Products in your order'),
(45, 'en', 'Order summary'),
(46, 'en', 'Auth information'),
(47, 'en', 'Profile information'),
(48, 'en', '404'),
(49, 'en', 'Product filters'),
(50, 'en', 'Recent posts'),
(51, 'en', 'Gift certificate verification'),
(52, 'en', 'Variations list'),
(53, 'en', 'Bundles with this product');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bm_block_statuses`
--

CREATE TABLE `[[dbprefix]]bm_block_statuses` (
  `snapping_id` int(11) NOT NULL,
  `object_ids` text,
  `object_type` varchar(32) NOT NULL,
  UNIQUE KEY `snapping_id` (`snapping_id`,`object_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bm_containers`
--

CREATE TABLE `[[dbprefix]]bm_containers` (
  `container_id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `location_id` mediumint(9) unsigned NOT NULL,
  `position` enum('TOP_PANEL','HEADER','CONTENT','FOOTER') NOT NULL,
  `width` tinyint(4) NOT NULL,
  `user_class` varchar(128) NOT NULL DEFAULT '',
  `linked_to_default` varchar(1) NOT NULL DEFAULT 'Y',
  `status` varchar(1) NOT NULL DEFAULT 'A',
  `company_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT 'If a vendor uses custom block configuration for a container, his/her vendor ID is stored here',
  PRIMARY KEY (`container_id`),
  KEY `location_id` (`location_id`),
  KEY `location_id_company_id` (`location_id`,`company_id`),
  KEY `location_id_position_company_id` (`location_id`,`position`,`company_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=65 ;

--
-- Dumping data for table `[[dbprefix]]bm_containers`
--

INSERT INTO `[[dbprefix]]bm_containers` VALUES
(1, 1, 'TOP_PANEL', 16, 'top-grid', 'Y', 'A', 0),
(2, 1, 'HEADER', 16, 'header-grid', 'Y', 'A', 0),
(3, 1, 'CONTENT', 16, 'content-grid', 'Y', 'A', 0),
(4, 1, 'FOOTER', 16, 'ty-footer-grid', 'Y', 'A', 0),
(5, 2, 'TOP_PANEL', 16, '', 'Y', 'A', 0),
(6, 2, 'HEADER', 16, '', 'Y', 'A', 0),
(7, 2, 'CONTENT', 16, 'content-grid', 'Y', 'A', 0),
(8, 2, 'FOOTER', 16, '', 'Y', 'A', 0),
(9, 3, 'TOP_PANEL', 16, '', 'Y', 'A', 0),
(10, 3, 'HEADER', 16, '', 'Y', 'A', 0),
(11, 3, 'CONTENT', 16, 'content-grid', 'Y', 'A', 0),
(12, 3, 'FOOTER', 16, '', 'Y', 'A', 0),
(13, 4, 'TOP_PANEL', 16, '', 'Y', 'A', 0),
(14, 4, 'HEADER', 16, '', 'Y', 'A', 0),
(15, 4, 'CONTENT', 16, 'content-grid', 'Y', 'A', 0),
(16, 4, 'FOOTER', 16, '', 'Y', 'A', 0),
(17, 5, 'TOP_PANEL', 16, '', 'Y', 'A', 0),
(18, 5, 'HEADER', 16, '', 'Y', 'A', 0),
(19, 5, 'CONTENT', 16, 'content-grid', 'Y', 'A', 0),
(20, 5, 'FOOTER', 16, '', 'Y', 'A', 0),
(21, 6, 'TOP_PANEL', 16, '', 'N', 'D', 0),
(22, 6, 'HEADER', 16, 'litecheckout__header', 'N', 'A', 0),
(23, 6, 'CONTENT', 16, 'content-grid', 'Y', 'A', 0),
(24, 6, 'FOOTER', 16, 'litecheckout__footer', 'N', 'A', 0),
(25, 7, 'TOP_PANEL', 16, '', 'Y', 'A', 0),
(26, 7, 'HEADER', 16, '', 'Y', 'A', 0),
(27, 7, 'CONTENT', 16, 'content-grid', 'Y', 'A', 0),
(28, 7, 'FOOTER', 16, '', 'Y', 'A', 0),
(29, 8, 'TOP_PANEL', 16, '', 'Y', 'A', 0),
(30, 8, 'HEADER', 16, '', 'Y', 'A', 0),
(31, 8, 'CONTENT', 16, 'content-grid', 'Y', 'A', 0),
(32, 8, 'FOOTER', 16, '', 'Y', 'A', 0),
(33, 9, 'TOP_PANEL', 16, '', 'Y', 'A', 0),
(34, 9, 'HEADER', 16, '', 'Y', 'A', 0),
(35, 9, 'CONTENT', 16, 'content-grid', 'Y', 'A', 0),
(36, 9, 'FOOTER', 16, '', 'Y', 'A', 0),
(37, 10, 'TOP_PANEL', 16, '', 'Y', 'A', 0),
(38, 10, 'HEADER', 16, '', 'Y', 'A', 0),
(39, 10, 'CONTENT', 16, 'content-grid', 'Y', 'A', 0),
(40, 10, 'FOOTER', 16, '', 'Y', 'A', 0),
(41, 11, 'TOP_PANEL', 16, '', 'Y', 'A', 0),
(42, 11, 'HEADER', 16, '', 'Y', 'A', 0),
(43, 11, 'CONTENT', 16, 'content-grid', 'Y', 'A', 0),
(44, 11, 'FOOTER', 16, '', 'Y', 'A', 0),
(45, 12, 'TOP_PANEL', 16, '', 'Y', 'A', 0),
(46, 12, 'HEADER', 16, '', 'Y', 'A', 0),
(47, 12, 'CONTENT', 16, 'content-grid', 'Y', 'A', 0),
(48, 12, 'FOOTER', 16, '', 'Y', 'A', 0),
(49, 13, 'TOP_PANEL', 16, '', 'Y', 'A', 0),
(50, 13, 'HEADER', 16, '', 'Y', 'A', 0),
(51, 13, 'CONTENT', 16, '', 'Y', 'A', 0),
(52, 13, 'FOOTER', 16, '', 'Y', 'A', 0),
(57, 15, 'TOP_PANEL', 16, '', 'Y', 'A', 0),
(58, 15, 'HEADER', 16, '', 'Y', 'A', 0),
(59, 15, 'CONTENT', 16, 'content-grid', 'Y', 'A', 0),
(60, 15, 'FOOTER', 16, '', 'Y', 'A', 0),
(61, 16, 'TOP_PANEL', 16, '', 'Y', 'A', 0),
(62, 16, 'HEADER', 16, '', 'Y', 'A', 0),
(63, 16, 'CONTENT', 16, '', 'Y', 'A', 0),
(64, 16, 'FOOTER', 16, '', 'Y', 'A', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bm_grids`
--

CREATE TABLE `[[dbprefix]]bm_grids` (
  `grid_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `container_id` mediumint(9) unsigned NOT NULL,
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0',
  `order` mediumint(9) unsigned NOT NULL DEFAULT '0',
  `width` tinyint(4) unsigned NOT NULL DEFAULT '1',
  `offset` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `user_class` varchar(128) NOT NULL DEFAULT '',
  `omega` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `alpha` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `wrapper` varchar(128) NOT NULL DEFAULT '',
  `content_align` enum('LEFT','RIGHT','FULL_WIDTH') NOT NULL DEFAULT 'FULL_WIDTH',
  `html_element` varchar(8) NOT NULL DEFAULT 'div',
  `clear` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `status` varchar(1) NOT NULL DEFAULT 'A',
  PRIMARY KEY (`grid_id`),
  KEY `container_id` (`container_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=79 ;

--
-- Dumping data for table `[[dbprefix]]bm_grids`
--

INSERT INTO `[[dbprefix]]bm_grids` VALUES
(1, 1, 0, 0, 3, 0, 'top-links-grid ty-top-grid_float', 0, 1, '', 'LEFT', 'div', 0, 'A'),
(2, 1, 0, 0, 11, 0, 'top-links-grid', 0, 0, '', 'LEFT', 'div', 0, 'A'),
(3, 1, 0, 0, 2, 0, 'top-links-grid', 1, 0, '', 'RIGHT', 'div', 1, 'A'),
(4, 2, 0, 0, 3, 0, 'top-logo-grid', 0, 1, '', 'FULL_WIDTH', 'div', 0, 'A'),
(5, 2, 0, 0, 5, 0, 'ty-cr-content-grid', 0, 0, '', 'FULL_WIDTH', 'div', 0, 'A'),
(6, 2, 0, 0, 8, 0, '', 1, 0, '', 'FULL_WIDTH', 'div', 1, 'A'),
(7, 2, 6, 0, 4, 0, 'search-block-grid', 0, 1, '', 'FULL_WIDTH', 'div', 0, 'A'),
(8, 2, 6, 0, 4, 0, 'cart-content-grid', 1, 0, '', 'FULL_WIDTH', 'div', 1, 'A'),
(9, 2, 0, 0, 16, 0, 'top-menu-grid', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(10, 3, 0, 0, 16, 0, 'breadcrumbs-grid', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(11, 3, 0, 0, 16, 0, 'main-content-grid', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(12, 4, 0, 0, 16, 0, 'ty-footer-grid__full-width footer-stay-connected', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(13, 4, 12, 0, 10, 0, 'ty-grid', 0, 1, '', 'FULL_WIDTH', 'div', 0, 'A'),
(14, 4, 12, 0, 6, 0, 'ty-grid', 1, 0, '', 'FULL_WIDTH', 'div', 1, 'A'),
(15, 4, 0, 0, 16, 0, 'ty-footer-grid__full-width ty-footer-menu', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(16, 4, 15, 0, 4, 0, 'my-account-grid', 0, 1, '', 'LEFT', 'div', 0, 'A'),
(17, 4, 15, 0, 4, 0, 'footer-store-grid', 0, 0, '', 'LEFT', 'div', 0, 'A'),
(18, 4, 15, 0, 4, 0, 'customer-service-grid', 0, 0, '', 'LEFT', 'div', 0, 'A'),
(19, 4, 15, 0, 4, 0, 'about-grid', 1, 0, '', 'LEFT', 'div', 1, 'A'),
(20, 4, 0, 0, 16, 0, 'ty-footer-grid__full-width footer-copyright', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(21, 4, 20, 0, 8, 0, '', 0, 1, '', 'LEFT', 'div', 0, 'A'),
(22, 4, 20, 0, 8, 0, '', 1, 0, '', 'RIGHT', 'div', 1, 'A'),
(23, 7, 0, 0, 16, 0, '', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(24, 7, 23, 0, 10, 0, '', 0, 1, '', 'FULL_WIDTH', 'div', 0, 'A'),
(25, 7, 23, 0, 6, 0, '', 1, 0, '', 'FULL_WIDTH', 'div', 1, 'A'),
(26, 7, 0, 0, 16, 0, '', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(27, 7, 0, 0, 8, 0, '', 0, 1, '', 'FULL_WIDTH', 'div', 0, 'A'),
(28, 7, 0, 0, 8, 0, '', 1, 0, '', 'FULL_WIDTH', 'div', 1, 'A'),
(29, 7, 0, 0, 16, 0, '', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(30, 9, 0, 0, 16, 0, '', 0, 0, '', 'FULL_WIDTH', 'div', 0, 'A'),
(31, 11, 0, 0, 16, 0, 'breadcrumbs-grid', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(32, 11, 0, 0, 16, 0, 'main-content-grid', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(33, 11, 0, 0, 9, 0, '', 0, 1, '', 'FULL_WIDTH', 'div', 0, 'A'),
(34, 11, 0, 0, 7, 0, '', 1, 0, '', 'FULL_WIDTH', 'div', 1, 'A'),
(35, 12, 0, 0, 16, 0, '', 0, 0, '', 'FULL_WIDTH', 'div', 0, 'A'),
(36, 13, 0, 0, 16, 0, '', 0, 0, '', 'FULL_WIDTH', 'div', 0, 'A'),
(37, 15, 0, 0, 16, 0, 'breadcrumbs-grid', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(38, 15, 0, 0, 4, 0, 'side-grid', 0, 1, '', 'FULL_WIDTH', 'div', 0, 'A'),
(39, 15, 0, 0, 12, 0, 'main-content-grid', 1, 0, '', 'FULL_WIDTH', 'div', 1, 'A'),
(40, 16, 0, 0, 16, 0, '', 0, 0, '', 'FULL_WIDTH', 'div', 0, 'A'),
(41, 17, 0, 0, 16, 0, '', 1, 1, '', 'FULL_WIDTH', 'div', 0, 'A'),
(42, 19, 0, 0, 16, 0, 'breadcrumbs-grid', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(43, 19, 0, 0, 16, 0, 'main-content-grid', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(44, 20, 0, 0, 16, 0, '', 0, 0, '', 'FULL_WIDTH', 'div', 0, 'A'),
(45, 21, 0, 0, 16, 0, '', 0, 0, '', 'FULL_WIDTH', 'div', 0, 'A'),
(46, 22, 0, 0, 3, 0, 'top-logo-grid', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(47, 23, 0, 0, 12, 0, 'main-content-grid', 0, 1, 'blocks/grid_wrappers/lite_checkout.tpl', 'FULL_WIDTH', 'div', 0, 'A'),
(48, 23, 0, 0, 4, 0, 'side-grid litecheckout__cart', 1, 0, '', 'FULL_WIDTH', 'div', 1, 'A'),
(49, 24, 0, 0, 16, 0, 'ty-footer-grid__full-width footer-copyright', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(50, 24, 49, 0, 2, 0, '', 0, 1, '', 'LEFT', 'div', 0, 'A'),
(51, 24, 49, 0, 14, 0, '', 1, 0, '', 'FULL_WIDTH', 'div', 1, 'A'),
(52, 27, 0, 0, 16, 0, 'breadcrumbs-grid', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(53, 27, 0, 0, 8, 0, 'main-content-grid', 0, 1, '', 'FULL_WIDTH', 'div', 0, 'A'),
(54, 27, 0, 0, 8, 0, 'auth-information-grid', 1, 0, '', 'FULL_WIDTH', 'div', 1, 'A'),
(55, 31, 0, 0, 16, 0, 'breadcrumbs-grid', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(56, 31, 0, 0, 8, 0, 'main-content-grid', 0, 1, '', 'FULL_WIDTH', 'div', 0, 'A'),
(57, 31, 0, 0, 8, 0, 'profile-information-grid', 1, 0, '', 'FULL_WIDTH', 'div', 1, 'A'),
(58, 35, 0, 0, 16, 0, 'main-content-grid', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(59, 37, 0, 0, 16, 0, '', 0, 0, '', 'FULL_WIDTH', 'div', 0, 'A'),
(60, 39, 0, 0, 16, 0, 'main-content-grid', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(61, 40, 0, 0, 16, 0, '', 0, 0, '', 'FULL_WIDTH', 'div', 0, 'A'),
(62, 41, 0, 0, 16, 0, '', 0, 0, '', 'FULL_WIDTH', 'div', 0, 'A'),
(63, 43, 0, 0, 16, 0, 'breadcrumbs-grid', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(64, 43, 0, 0, 4, 0, 'side-grid', 0, 1, '', 'FULL_WIDTH', 'div', 0, 'D'),
(65, 43, 0, 0, 12, 0, 'main-content-grid', 1, 0, '', 'FULL_WIDTH', 'div', 1, 'A'),
(66, 44, 0, 0, 16, 0, '', 0, 0, '', 'FULL_WIDTH', 'div', 0, 'A'),
(67, 47, 0, 0, 16, 0, 'main-content-grid', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(68, 51, 0, 0, 16, 0, 'breadcrumbs-grid', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(69, 51, 0, 0, 16, 0, 'main-content-grid', 1, 1, '', 'FULL_WIDTH', 'div', 0, 'A'),
(78, 63, 0, 0, 3, 0, '', 1, 0, '', 'FULL_WIDTH', 'div', 0, 'A'),
(77, 63, 0, 0, 13, 0, 'ty-blog-grid', 0, 1, '', 'FULL_WIDTH', 'div', 0, 'A'),
(76, 63, 0, 0, 16, 0, '', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(73, 59, 0, 0, 16, 0, 'breadcrumbs-grid', 1, 1, '', 'FULL_WIDTH', 'div', 1, 'A'),
(74, 59, 0, 0, 8, 0, 'main-content-grid', 0, 1, '', 'FULL_WIDTH', 'div', 0, 'A'),
(75, 59, 0, 0, 8, 0, 'certificates-verify-grid', 1, 0, '', 'RIGHT', 'div', 0, 'A');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bm_layouts`
--

CREATE TABLE `[[dbprefix]]bm_layouts` (
  `layout_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL DEFAULT '',
  `is_default` tinyint(4) NOT NULL DEFAULT '0',
  `width` tinyint(4) NOT NULL DEFAULT '16',
  `layout_width` enum('fixed','fluid','full_width') NOT NULL DEFAULT 'fixed',
  `min_width` int(11) unsigned NOT NULL DEFAULT '760',
  `max_width` int(11) unsigned NOT NULL DEFAULT '960',
  `theme_name` varchar(64) NOT NULL DEFAULT '',
  `style_id` varchar(64) NOT NULL DEFAULT '',
  `storefront_id` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`layout_id`),
  KEY `is_default` (`is_default`,`storefront_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]bm_layouts`
--

INSERT INTO `[[dbprefix]]bm_layouts` VALUES
(1, 'Main', 1, 16, 'fluid', 280, 1200, 'bright_theme', 'Bright_theme', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bm_locations`
--

CREATE TABLE `[[dbprefix]]bm_locations` (
  `location_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `dispatch` varchar(64) NOT NULL,
  `is_default` tinyint(1) NOT NULL,
  `layout_id` int(11) unsigned NOT NULL DEFAULT '0',
  `object_ids` text,
  `custom_html` text,
  `position` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`location_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

--
-- Dumping data for table `[[dbprefix]]bm_locations`
--

INSERT INTO `[[dbprefix]]bm_locations` VALUES
(1, 'default', 1, 1, '', '', 10),
(2, 'index.index', 0, 1, '', '', 20),
(3, 'products.view', 0, 1, '', '', 30),
(4, 'categories.view', 0, 1, '', '', 40),
(5, 'checkout.cart', 0, 1, '', '', 50),
(6, 'checkout', 0, 1, '', '', 60),
(7, 'auth', 0, 1, '', '', 70),
(8, 'profiles', 0, 1, '', '', 80),
(9, 'profiles.success_add', 0, 1, '', '', 90),
(10, 'checkout.complete', 0, 1, '', '', 100),
(11, 'pages.view', 0, 1, '', '', 110),
(12, 'no_page', 0, 1, '', '', 160),
(13, 'products.search', 0, 1, '', '', 170),
(15, 'gift_certificates', 0, 1, '', NULL, 130),
(16, 'pages.view?page_type=B', 0, 1, '', '', 170);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bm_locations_descriptions`
--

CREATE TABLE `[[dbprefix]]bm_locations_descriptions` (
  `location_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lang_code` char(2) NOT NULL DEFAULT '',
  `name` varchar(64) NOT NULL,
  `title` text NOT NULL,
  `meta_description` text NOT NULL,
  `meta_keywords` text NOT NULL,
  PRIMARY KEY (`location_id`,`lang_code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

--
-- Dumping data for table `[[dbprefix]]bm_locations_descriptions`
--

INSERT INTO `[[dbprefix]]bm_locations_descriptions` VALUES
(1, 'en', 'Default', '', '', ''),
(2, 'en', 'Homepage', 'Shopping Cart Software & Ecommerce Software Solutions by CS-Cart', 'Secure and full-featured Online Shopping Cart Software with the complete set of powerful ecommerce options to create your own online store with minimum efforts involved.', 'shopping cart, software, ecommerce software, online store'),
(3, 'en', 'Products', '', '', ''),
(4, 'en', 'Categories', '', '', ''),
(5, 'en', 'Cart', '', '', ''),
(6, 'en', 'Checkout', '', '', ''),
(7, 'en', 'Auth', '', '', ''),
(8, 'en', 'Profiles', '', '', ''),
(9, 'en', 'Successful registration', '', '', ''),
(10, 'en', 'Order landing page', '', '', ''),
(11, 'en', 'Pages', '', '', ''),
(12, 'en', '404', 'Page not found', '', ''),
(13, 'en', 'Search results', '', '', ''),
(15, 'en', 'Gift certificates', '', '', ''),
(16, 'en', 'Blog', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bm_snapping`
--

CREATE TABLE `[[dbprefix]]bm_snapping` (
  `snapping_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `block_id` int(11) unsigned NOT NULL,
  `grid_id` int(11) unsigned NOT NULL,
  `wrapper` varchar(128) NOT NULL DEFAULT '',
  `user_class` varchar(128) NOT NULL DEFAULT '',
  `order` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `status` varchar(1) NOT NULL DEFAULT 'A',
  PRIMARY KEY (`snapping_id`),
  KEY `grid_id` (`grid_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=83 ;

--
-- Dumping data for table `[[dbprefix]]bm_snapping`
--

INSERT INTO `[[dbprefix]]bm_snapping` VALUES
(1, 1, 1, '', 'top-languages', 2, 'A'),
(2, 2, 1, '', 'top-currencies', 3, 'A'),
(3, 3, 2, '', 'top-quick-links', 3, 'A'),
(4, 4, 3, 'blocks/wrappers/onclick_dropdown.tpl', 'top-my-account', 2, 'A'),
(5, 5, 4, '', 'top-logo', 0, 'A'),
(6, 6, 5, '', '', 0, 'A'),
(7, 7, 7, '', 'top-search', 0, 'A'),
(8, 8, 8, '', 'top-cart-content', 2, 'A'),
(9, 9, 9, '', 'top-menu', 2, 'A'),
(10, 10, 10, '', '', 0, 'A'),
(11, 11, 11, 'blocks/wrappers/mainbox_general.tpl', '', 0, 'A'),
(12, 12, 13, '', '', 2, 'A'),
(13, 13, 14, '', '', 2, 'A'),
(14, 14, 16, 'blocks/wrappers/footer_general.tpl', '', 0, 'A'),
(15, 15, 17, 'blocks/wrappers/footer_general.tpl', 'footer-menu-shop', 0, 'A'),
(16, 16, 18, 'blocks/wrappers/footer_general.tpl', 'footer-menu-create-orders', 0, 'A'),
(17, 17, 19, 'blocks/wrappers/footer_general.tpl', 'footer-no-wysiwyg footer-contacts', 0, 'A'),
(18, 18, 21, '', '', 2, 'A'),
(19, 19, 22, '', '', 2, 'A'),
(20, 20, 24, '', 'homepage-banners', 0, 'A'),
(21, 21, 25, '', 'ty-banners-free-ship', 3, 'A'),
(22, 22, 25, '', 'ty-banners-pickup', 4, 'A'),
(23, 23, 26, 'blocks/wrappers/mainbox_simple.tpl', 'homepage-hotdeals', 2, 'A'),
(24, 24, 26, 'blocks/wrappers/mainbox_simple.tpl', 'homepage-on-sale', 5, 'A'),
(25, 25, 27, 'blocks/wrappers/mainbox_simple.tpl', '', 0, 'A'),
(26, 26, 28, 'blocks/wrappers/mainbox_simple.tpl', 'homepage-reviews', 0, 'A'),
(27, 11, 29, '', '', 1, 'A'),
(28, 27, 29, 'blocks/wrappers/mainbox_simple.tpl', 'homepage-our-brands', 2, 'A'),
(29, 28, 29, '', 'homepage-benefits-guarantees', 3, 'D'),
(30, 10, 31, '', '', 0, 'A'),
(31, 11, 32, '', '', 0, 'A'),
(32, 29, 33, 'blocks/wrappers/mainbox_simple.tpl', '', 2, 'A'),
(33, 30, 34, 'blocks/wrappers/mainbox_simple.tpl', '', 2, 'A'),
(34, 10, 37, '', '', 0, 'A'),
(35, 31, 38, 'blocks/wrappers/sidebox_important.tpl', '', 0, 'A'),
(36, 32, 38, 'blocks/wrappers/sidebox_important.tpl', '', 0, 'A'),
(37, 11, 39, 'blocks/wrappers/mainbox_general.tpl', '', 0, 'A'),
(38, 10, 42, '', '', 0, 'A'),
(39, 11, 43, 'blocks/wrappers/mainbox_general.tpl', '', 0, 'A'),
(40, 33, 46, '', '', 0, 'A'),
(41, 34, 47, '', '', 0, 'A'),
(42, 35, 47, '', '', 1, 'A'),
(43, 36, 47, '', '', 2, 'A'),
(44, 37, 47, '', '', 3, 'A'),
(45, 38, 47, '', '', 4, 'A'),
(46, 39, 47, '', '', 5, 'A'),
(47, 40, 47, 'blocks/lite_checkout/wrappers/checkout_block_with_heading.tpl', '', 6, 'A'),
(48, 41, 47, '', '', 7, 'A'),
(49, 42, 47, '', '', 8, 'A'),
(50, 43, 47, '', '', 9, 'A'),
(51, 11, 47, 'blocks/wrappers/mainbox_general.tpl', '', 10, 'D'),
(52, 44, 48, '', 'order-products', 0, 'A'),
(53, 45, 48, '', '', 1, 'A'),
(54, 5, 50, '', 'top-logo', 0, 'A'),
(55, 18, 51, '', '', 2, 'A'),
(56, 10, 52, '', '', 0, 'A'),
(57, 11, 53, 'blocks/wrappers/mainbox_general.tpl', '', 0, 'A'),
(58, 46, 54, '', '', 0, 'A'),
(59, 10, 55, '', '', 0, 'A'),
(60, 11, 56, 'blocks/wrappers/mainbox_general.tpl', '', 2, 'A'),
(61, 47, 57, '', '', 0, 'A'),
(62, 10, 58, '', '', 0, 'A'),
(63, 11, 58, 'blocks/wrappers/mainbox_general.tpl', '', 1, 'A'),
(64, 10, 60, '', '', 0, 'A'),
(65, 11, 60, 'blocks/wrappers/mainbox_general.tpl', '', 1, 'A'),
(66, 10, 63, '', '', 0, 'A'),
(67, 4, 64, 'blocks/wrappers/sidebox_important.tpl', '', 1, 'A'),
(68, 32, 64, 'blocks/wrappers/sidebox_important.tpl', '', 2, 'A'),
(69, 11, 65, '', '', 0, 'A'),
(70, 48, 67, '', '', 0, 'A'),
(71, 10, 68, '', '', 0, 'A'),
(72, 49, 68, 'blocks/wrappers/sidebox_important.tpl', '', 0, 'A'),
(73, 11, 69, 'blocks/wrappers/mainbox_general.tpl', '', 0, 'A'),
(82, 50, 78, 'blocks/wrappers/sidebox_important.tpl', '', 0, 'A'),
(81, 11, 77, 'blocks/wrappers/mainbox_general.tpl', '', 0, 'A'),
(80, 10, 76, '', '', 0, 'A'),
(77, 10, 73, '', '', 0, 'A'),
(78, 11, 74, 'blocks/wrappers/mainbox_general.tpl', '', 0, 'A'),
(79, 51, 75, '', '', 0, 'A');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_handlers`
--

CREATE TABLE `[[dbprefix]]cache_handlers` (
  `table_name` varchar(128) NOT NULL COMMENT 'Table name the cache record depends on',
  `cache_key` varchar(128) NOT NULL COMMENT 'Cache key or prefix used to register cache record',
  UNIQUE KEY `table_name_cache_key` (`table_name`,`cache_key`),
  KEY `table_name` (`table_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Stores relations between cache records registered with TyghRegistry::registerCache() and tables they depend on';

--
-- Dumping data for table `[[dbprefix]]cache_handlers`
--

INSERT INTO `[[dbprefix]]cache_handlers` VALUES
('addons', 'addons'),
('addons', 'schemas'),
('addons', 'template_overrides'),
('addons', 'thooks_A'),
('addons', 'unmanaged_addons'),
('addons', 'upgrade_packages'),
('companies', 'all_available_company_ids'),
('countries', 'available_countries_hash'),
('currencies', 'init_currency'),
('currency_descriptions', 'init_currency'),
('images', 'template_logos'),
('images_links', 'template_logos'),
('languages', 'init_language'),
('language_values', 'lang_cache'),
('logos', 'template_logos'),
('settings_descriptions', 'addons'),
('settings_descriptions', 'settings'),
('settings_objects', 'addons'),
('settings_objects', 'init_cdn_settings'),
('settings_objects', 'init_storage_settings'),
('settings_objects', 'schemas'),
('settings_objects', 'seo_settings'),
('settings_objects', 'settings'),
('settings_objects', 'storefront_protocol'),
('settings_sections', 'addons'),
('settings_sections', 'settings'),
('settings_variants', 'addons'),
('settings_variants', 'settings'),
('settings_vendor_values', 'addons'),
('settings_vendor_values', 'seo_settings'),
('settings_vendor_values', 'settings'),
('storefronts', 'seo_settings'),
('storefronts_currencies', 'init_currency'),
('storefronts_languages', 'init_language'),
('storefronts_languages', 'seo_settings'),
('ult_language_values', 'lang_cache');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]call_requests`
--

CREATE TABLE `[[dbprefix]]call_requests` (
  `request_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `order_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `product_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `timestamp` int(11) unsigned NOT NULL DEFAULT '0',
  `status` enum('new','in_progress','completed','no_answer') NOT NULL DEFAULT 'new',
  `name` varchar(250) NOT NULL DEFAULT '',
  `phone` varchar(128) NOT NULL DEFAULT '',
  `time_from` varchar(32) NOT NULL DEFAULT '',
  `time_to` varchar(32) NOT NULL DEFAULT '',
  `notes` text,
  `cart_products` text NOT NULL COMMENT 'Serialized data',
  PRIMARY KEY (`request_id`),
  KEY `user_id` (`company_id`,`user_id`),
  KEY `timestamp` (`timestamp`),
  KEY `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `category_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `id_path` varchar(255) NOT NULL DEFAULT '',
  `level` int(11) unsigned NOT NULL DEFAULT '1',
  `company_id` int(11) unsigned NOT NULL DEFAULT '0',
  `storefront_id` int(11) unsigned NOT NULL DEFAULT '0',
  `usergroup_ids` varchar(255) NOT NULL DEFAULT '0',
  `status` char(1) NOT NULL DEFAULT 'A',
  `product_count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `position` smallint(5) unsigned NOT NULL DEFAULT '0',
  `timestamp` int(11) unsigned NOT NULL DEFAULT '0',
  `is_op` char(1) NOT NULL DEFAULT 'N',
  `localization` varchar(255) NOT NULL DEFAULT '',
  `age_verification` char(1) NOT NULL DEFAULT 'N',
  `age_limit` tinyint(4) NOT NULL DEFAULT '0',
  `parent_age_verification` char(1) NOT NULL DEFAULT 'N',
  `parent_age_limit` tinyint(4) NOT NULL DEFAULT '0',
  `selected_views` text,
  `default_view` varchar(50) NOT NULL DEFAULT '',
  `product_details_view` varchar(50) NOT NULL DEFAULT '',
  `product_columns` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `is_trash` char(1) NOT NULL DEFAULT 'N',
  `is_default` char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`category_id`),
  KEY `c_status` (`usergroup_ids`,`status`,`parent_id`),
  KEY `position` (`position`),
  KEY `parent` (`parent_id`),
  KEY `id_path` (`id_path`),
  KEY `localization` (`localization`),
  KEY `age_verification` (`age_verification`,`age_limit`),
  KEY `parent_age_verification` (`parent_age_verification`,`parent_age_limit`),
  KEY `p_category_id` (`category_id`,`usergroup_ids`,`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=264 ;

--
-- Dumping data for table `[[dbprefix]]categories`
--

INSERT INTO `[[dbprefix]]categories` VALUES
(165, 167, '166/167/165', 3, 1, 1, '0', 'A', 6, 100, 1310932800, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(166, 0, '166', 1, 1, 1, '0', 'A', 0, 10, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(167, 166, '166/167', 2, 1, 1, '0', 'A', 0, 10, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(168, 167, '166/167/168', 3, 1, 1, '0', 'A', 4, 10, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(169, 167, '166/167/169', 3, 1, 1, '0', 'A', 4, 20, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(170, 167, '166/167/170', 3, 1, 1, '0', 'A', 3, 110, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(171, 167, '166/167/171', 3, 1, 1, '0', 'A', 4, 120, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(172, 167, '166/167/172', 3, 1, 1, '0', 'A', 4, 130, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(174, 166, '166/174', 2, 1, 1, '0', 'A', 0, 30, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(175, 166, '166/175', 2, 1, 1, '0', 'A', 0, 20, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(176, 175, '166/175/176', 3, 1, 1, '0', 'A', 5, 10, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(177, 166, '166/177', 2, 1, 1, '0', 'A', 0, 50, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(178, 177, '166/177/178', 3, 1, 1, '0', 'A', 2, 10, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(179, 177, '166/177/179', 3, 1, 1, '0', 'A', 9, 30, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(180, 177, '166/177/180', 3, 1, 1, '0', 'A', 5, 40, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(181, 177, '166/177/181', 3, 1, 1, '0', 'A', 5, 50, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(182, 177, '166/177/182', 3, 1, 1, '0', 'A', 4, 20, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(199, 196, '166/196/199', 3, 1, 1, '0', 'A', 12, 30, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(185, 175, '166/175/185', 3, 1, 1, '0', 'A', 5, 20, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(186, 175, '166/175/186', 3, 1, 1, '0', 'A', 4, 30, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(187, 175, '166/175/187', 3, 1, 1, '0', 'A', 3, 50, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(188, 175, '166/175/188', 3, 1, 1, '0', 'A', 2, 60, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(189, 175, '166/175/189', 3, 1, 1, '0', 'A', 5, 70, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(190, 174, '166/174/190', 3, 1, 1, '0', 'A', 5, 10, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(191, 174, '166/174/191', 3, 1, 1, '0', 'A', 3, 20, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(194, 174, '166/174/194', 3, 1, 1, '0', 'A', 4, 40, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(193, 174, '166/174/193', 3, 1, 1, '0', 'A', 3, 30, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(195, 174, '166/174/195', 3, 1, 1, '0', 'A', 4, 50, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(196, 166, '166/196', 2, 1, 1, '0', 'A', 0, 60, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(197, 196, '166/196/197', 3, 1, 1, '0', 'A', 3, 20, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(198, 196, '166/196/198', 3, 1, 1, '0', 'A', 8, 10, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(200, 196, '166/196/200', 3, 1, 1, '0', 'A', 5, 40, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(201, 167, '166/167/201', 3, 1, 1, '0', 'A', 3, 140, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(202, 175, '166/175/202', 3, 1, 1, '0', 'A', 3, 40, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(203, 0, '203', 1, 1, 1, '0', 'A', 0, 20, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(204, 203, '203/204', 2, 1, 1, '0', 'A', 0, 10, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(211, 203, '203/211', 2, 1, 1, '0', 'A', 0, 20, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(212, 211, '203/211/212', 3, 1, 1, '0', 'A', 4, 10, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(208, 204, '203/204/208', 3, 1, 1, '0', 'A', 3, 30, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(209, 204, '203/204/209', 3, 1, 1, '0', 'A', 3, 20, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(210, 204, '203/204/210', 3, 1, 1, '0', 'A', 4, 10, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(213, 211, '203/211/213', 3, 1, 1, '0', 'A', 1, 20, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(214, 211, '203/211/214', 3, 1, 1, '0', 'A', 3, 30, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(215, 203, '203/215', 2, 1, 1, '0', 'A', 0, 30, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(216, 215, '203/215/216', 3, 1, 1, '0', 'A', 3, 10, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(217, 215, '203/215/217', 3, 1, 1, '0', 'A', 3, 20, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(218, 215, '203/215/218', 3, 1, 1, '0', 'A', 2, 30, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(219, 0, '219', 1, 1, 1, '0', 'D', 0, 40, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(220, 219, '219/220', 2, 1, 1, '0', 'A', 3, 20, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(221, 219, '219/221', 2, 1, 1, '0', 'A', 3, 30, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(222, 219, '219/222', 2, 1, 1, '0', 'A', 3, 10, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(223, 0, '223', 1, 1, 1, '0', 'A', 0, 30, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(224, 223, '223/224', 2, 1, 1, '0', 'A', 4, 10, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(225, 223, '223/225', 2, 1, 1, '0', 'A', 6, 20, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(226, 223, '223/226', 2, 1, 1, '0', 'A', 4, 30, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'bigpicture_template', 0, 'N', 'N'),
(227, 223, '223/227', 2, 1, 1, '0', 'A', 5, 40, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(228, 0, '228', 1, 1, 1, '0', 'A', 0, 50, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(229, 228, '228/229', 2, 1, 1, '0', 'A', 3, 10, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(230, 228, '228/230', 2, 1, 1, '0', 'A', 4, 20, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(231, 228, '228/231', 2, 1, 1, '0', 'A', 2, 30, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(232, 228, '228/232', 2, 1, 1, '0', 'A', 5, 40, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(234, 166, '166/234', 2, 1, 1, '0', 'A', 0, 40, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(235, 234, '166/234/235', 3, 1, 1, '0', 'A', 3, 10, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(236, 234, '166/234/236', 3, 1, 1, '0', 'A', 5, 20, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(237, 234, '166/234/237', 3, 1, 1, '0', 'A', 4, 50, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(238, 234, '166/234/238', 3, 1, 1, '0', 'A', 4, 40, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(240, 234, '166/234/240', 3, 1, 1, '0', 'A', 5, 30, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(241, 0, '241', 1, 1, 1, '0', 'A', 0, 60, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(242, 241, '241/242', 2, 1, 1, '0', 'A', 5, 10, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(243, 241, '241/243', 2, 1, 1, '0', 'A', 5, 20, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(244, 241, '241/244', 2, 1, 1, '0', 'A', 4, 30, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(245, 0, '245', 1, 1, 1, '0', 'A', 0, 70, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(246, 245, '245/246', 2, 1, 1, '0', 'A', 5, 10, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(247, 245, '245/247', 2, 1, 1, '0', 'A', 4, 20, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(248, 245, '245/248', 2, 1, 1, '0', 'A', 5, 40, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(249, 245, '245/249', 2, 1, 1, '0', 'A', 4, 30, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(250, 0, '250', 1, 1, 1, '0', 'A', 0, 80, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(251, 250, '250/251', 2, 1, 1, '0', 'A', 3, 10, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(252, 250, '250/252', 2, 1, 1, '0', 'A', 5, 20, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(253, 250, '250/253', 2, 1, 1, '0', 'A', 3, 30, 1328475600, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(254, 166, '166/254', 2, 1, 1, '0', 'A', 0, 70, 1412280000, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(255, 263, '166/254/263/255', 4, 1, 1, '0', 'A', 1, 10, 1412601391, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N'),
(263, 254, '166/254/263', 3, 1, 1, '0', 'A', 0, 160, 1412539200, 'N', '', 'N', 0, 'N', 0, '', '', 'default', 0, 'N', 'N');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]category_descriptions`
--

CREATE TABLE `[[dbprefix]]category_descriptions` (
  `category_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `lang_code` char(2) NOT NULL DEFAULT '',
  `category` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext,
  `meta_keywords` varchar(255) NOT NULL DEFAULT '',
  `meta_description` varchar(255) NOT NULL DEFAULT '',
  `page_title` varchar(255) NOT NULL DEFAULT '',
  `age_warning_message` text,
  PRIMARY KEY (`category_id`,`lang_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]category_descriptions`
--

INSERT INTO `[[dbprefix]]category_descriptions` VALUES
(165, 'en', 'Tablets', '', '', '', '', ''),
(166, 'en', 'Electronics', '', '', '', '', ''),
(167, 'en', 'Computers', '', '', '', '', ''),
(168, 'en', 'Desktops', '', '', '', '', ''),
(169, 'en', 'Laptops', '', '', '', '', ''),
(170, 'en', 'Monitors', '', '', '', '', ''),
(171, 'en', 'Networking', '', '', '', '', ''),
(172, 'en', 'Printers & Scanners', '', '', '', '', ''),
(174, 'en', 'TV & Video', '', '', '', '', ''),
(177, 'en', 'MP3 Players', '', '', '', '', ''),
(175, 'en', 'Car Electronics', '', '', '', '', ''),
(176, 'en', 'GPS & Navigation', '', '', '', '', ''),
(178, 'en', 'iPods', '', '', '', '', ''),
(179, 'en', 'MP3 Players', '', '', '', '', ''),
(180, 'en', 'MP3 Speaker Systems', '', '', '', '', ''),
(181, 'en', 'Headphones', '', '', '', '', ''),
(182, 'en', 'Android', '', '', '', '', ''),
(199, 'en', 'Camcorders', '', '', '', '', ''),
(185, 'en', 'In-Dash Stereos', '', '', '', '', ''),
(186, 'en', 'Speakers', '', '', '', '', ''),
(187, 'en', 'Amplifiers', '', '', '', '', ''),
(188, 'en', 'Car DVD & Video', '', '', '', '', ''),
(189, 'en', 'Radar Detectors', '', '', '', '', ''),
(190, 'en', 'LED TVs', '', '', '', '', ''),
(191, 'en', 'Plasma TVs', '', '', '', '', ''),
(194, 'en', 'DVD & Blu-ray Players', '', '', '', '', ''),
(193, 'en', '3D TVs', '', '', '', '', ''),
(195, 'en', 'Home Theater Systems', '', '', '', '', ''),
(196, 'en', 'Cameras & Photo', '', '', '', '', ''),
(197, 'en', 'DSLR Cameras', '', '', '', '', ''),
(198, 'en', 'Digital Cameras', '', '', '', '', ''),
(200, 'en', 'Lenses', '', '', '', '', ''),
(201, 'en', 'Processors', '', '', '', '', ''),
(202, 'en', 'Subwoofers', '', '', '', '', ''),
(203, 'en', 'Sports & Outdoors', '', '', '', '', ''),
(204, 'en', 'Bikes', '', '', '', '', ''),
(211, 'en', 'Golf', '', '', '', '', ''),
(208, 'en', 'Mountain Bikes', '', '', '', '', ''),
(209, 'en', 'Road Bikes', '', '', '', '', ''),
(210, 'en', 'Comfort & Cruisers', '', '', '', '', ''),
(212, 'en', 'Golf Clubs', '', '', '', '', ''),
(213, 'en', 'Golf Balls', '', '', '', '', ''),
(214, 'en', 'Golf Bags & Carts', '', '', '', '', ''),
(215, 'en', 'Camping', '', '', '', '', ''),
(216, 'en', 'Backpacks', '', '', '', '', ''),
(217, 'en', 'Sleeping Bags', '', '', '', '', ''),
(218, 'en', 'Tents', '', '', '', '', ''),
(219, 'en', 'Books', '', '', '', '', ''),
(220, 'en', 'Computing & Internet', '', '', '', '', ''),
(221, 'en', 'Education', '', '', '', '', ''),
(222, 'en', 'Business & Investing', '', '', '', '', ''),
(223, 'en', 'Apparel', '', '', '', '', ''),
(224, 'en', 'Men''s Clothing', '', '', '', '', ''),
(225, 'en', 'Women''s Clothing', '', '', '', '', ''),
(226, 'en', 'Shoes', '', '', '', '', ''),
(227, 'en', 'Watches & Jewelry', '', '', '', '', ''),
(228, 'en', 'Music', '', '', '', '', ''),
(229, 'en', 'Blues', '', '', '', '', ''),
(230, 'en', 'Classical', '', '', '', '', ''),
(231, 'en', 'Jazz', '', '', '', '', ''),
(232, 'en', 'Rock', '', '', '', '', ''),
(234, 'en', 'Cell Phones', '', '', '', '', ''),
(235, 'en', 'Apple iPhone', '', '', '', '', ''),
(236, 'en', 'HTC', '', '', '', '', ''),
(237, 'en', 'Samsung', '', '', '', '', ''),
(238, 'en', 'Nokia', '', '', '', '', ''),
(240, 'en', 'Motorola', '', '', '', '', ''),
(241, 'en', 'Movies & TV', '', '', '', '', ''),
(242, 'en', 'Blu-ray Discs', '', '', '', '', ''),
(243, 'en', 'Movies (DVD)', '', '', '', '', ''),
(244, 'en', 'TV Shows (DVD)', '', '', '', '', ''),
(245, 'en', 'Video Games', '', '', '', '', ''),
(246, 'en', 'Nintendo Wii', '', '', '', '', ''),
(247, 'en', 'PlayStation 3', '', '', '', '', ''),
(248, 'en', 'X-Box One', '', '', '', '', ''),
(249, 'en', 'PlayStation Vita', '', '', '', '', ''),
(250, 'en', 'Office Supplies', '', '', '', '', ''),
(251, 'en', 'Calculators', '', '', '', '', ''),
(252, 'en', 'Desk Accessories', '', '', '', '', ''),
(253, 'en', 'Safes', '', '', '', '', ''),
(254, 'en', 'Game consoles', '', '', '', '', ''),
(255, 'en', 'Microsoft', '', '', '', '', ''),
(263, 'en', 'Consoles', '', '', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]common_descriptions`
--

CREATE TABLE `[[dbprefix]]common_descriptions` (
  `object_id` int(11) unsigned NOT NULL DEFAULT '0',
  `object_type` varchar(32) NOT NULL DEFAULT '',
  `description` mediumtext,
  `lang_code` char(2) NOT NULL DEFAULT '',
  `object` varchar(128) NOT NULL DEFAULT '',
  `object_holder` varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`object_id`,`lang_code`,`object_holder`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]common_descriptions`
--

INSERT INTO `[[dbprefix]]common_descriptions` VALUES
(2, '', '', 'en', 'My account', 'sitemap_sections'),
(1, '', 'View cart', 'en', 'View cart', 'sitemap_links'),
(2, '', 'Wish List', 'en', 'Wish List', 'sitemap_links'),
(3, '', 'Checkout', 'en', 'Checkout', 'sitemap_links'),
(4, '', 'Edit profile', 'en', 'Edit profile', 'sitemap_links'),
(11, '', 'Fourth affiliate plan description.', 'en', 'Test plan', 'affiliate_plans'),
(1, '', 'Branding', 'en', '', 'quick_menu'),
(2, '', 'Legal documents', 'en', '', 'quick_menu'),
(4, '', 'Checkout', 'en', '', 'quick_menu'),
(5, '', 'Logo', 'en', '', 'quick_menu'),
(6, '', 'Company & contacts', 'en', '', 'quick_menu'),
(7, '', 'Theme colors & fonts', 'en', '', 'quick_menu'),
(8, '', 'Terms for customers', 'en', '', 'quick_menu'),
(9, '', 'Privacy policy', 'en', '', 'quick_menu'),
(10, '', 'GDPR', 'en', '', 'quick_menu'),
(11, '', 'Returns and exchanges', 'en', '', 'quick_menu'),
(19, '', 'Structure and fields', 'en', '', 'quick_menu'),
(20, '', 'Extra fields', 'en', '', 'quick_menu'),
(21, '', 'Payment methods', 'en', '', 'quick_menu'),
(22, '', 'Shipping methods', 'en', '', 'quick_menu'),
(23, '', 'Taxes', 'en', '', 'quick_menu'),
(180, '', 'men_clothes.jpg', 'en', '', 'images'),
(181, '', 'w-phones_cat.gif', 'en', '', 'images'),
(182, '', '100009923665.gif', 'en', '', 'images'),
(183, '', 'audio_video.gif', 'en', '', 'images'),
(184, '', 'computes.gif', 'en', '', 'images'),
(185, '', 'pc-desktops-sony_cat.jpg', 'en', '', 'images'),
(186, '', 'dvds.gif', 'en', '', 'images'),
(187, '', 'books.jpg', 'en', '', 'images'),
(188, '', 'music.gif', 'en', '', 'images'),
(189, '', 'build_your_pc.jpg', 'en', '', 'images'),
(190, '', 'special_offer_ads.gif', 'en', '', 'images'),
(191, '', 'thumbnail_B000068IG9.01._SCMZZZZZZZ_.jpg', 'en', '', 'images'),
(192, '', 'modems.jpg', 'en', '', 'images'),
(193, '', 'tjpg', 'en', '', 'images'),
(194, '', 'ujpg', 'en', '', 'images'),
(195, '', 'group_ddr_memory.jpg', 'en', '', 'images'),
(196, '', 'group_laser_printers.jpg', 'en', '', 'images'),
(197, '', 'tjpg', 'en', '', 'images'),
(198, '', 'ujpg', 'en', '', 'images'),
(199, '', 'tjpg', 'en', '', 'images'),
(200, '', 'ujpg', 'en', '', 'images'),
(237, '', '', 'en', '', 'images'),
(238, '', '', 'en', '', 'images'),
(239, '', '', 'en', '', 'images'),
(240, '', '', 'en', '', 'images'),
(243, '', '', 'en', '', 'images'),
(244, '', '', 'en', '', 'images'),
(245, '', '', 'en', '', 'images'),
(246, '', '', 'en', '', 'images'),
(247, '', '', 'en', '', 'images'),
(248, '', '', 'en', '', 'images'),
(249, '', '', 'en', '', 'images'),
(250, '', '', 'en', '', 'images'),
(251, '', '', 'en', '', 'images'),
(252, '', '', 'en', '', 'images'),
(254, '', '', 'en', '', 'images'),
(255, '', '', 'en', '', 'images'),
(256, '', '', 'en', '', 'images'),
(257, '', '', 'en', '', 'images'),
(258, '', '', 'en', '', 'images'),
(259, '', '', 'en', '', 'images'),
(260, '', '', 'en', '', 'images'),
(261, '', '', 'en', '', 'images'),
(262, '', '', 'en', '', 'images'),
(263, '', '', 'en', '', 'images'),
(264, '', '', 'en', '', 'images'),
(265, '', '', 'en', '', 'images'),
(266, '', '', 'en', '', 'images'),
(267, '', '', 'en', '', 'images'),
(268, '', '', 'en', '', 'images'),
(269, '', '', 'en', '', 'images'),
(270, '', '', 'en', '', 'images'),
(271, '', '', 'en', '', 'images'),
(274, '', '', 'en', '', 'images'),
(275, '', '', 'en', '', 'images'),
(276, '', '', 'en', '', 'images'),
(277, '', '', 'en', '', 'images'),
(278, '', '', 'en', '', 'images'),
(279, '', '', 'en', '', 'images'),
(280, '', '', 'en', '', 'images'),
(281, '', '', 'en', '', 'images'),
(282, '', '', 'en', '', 'images'),
(283, '', '', 'en', '', 'images'),
(284, '', '', 'en', '', 'images'),
(285, '', '', 'en', '', 'images'),
(286, '', '', 'en', '', 'images'),
(287, '', '', 'en', '', 'images'),
(288, '', '', 'en', '', 'images'),
(289, '', '', 'en', '', 'images'),
(290, '', '', 'en', '', 'images'),
(291, '', '', 'en', '', 'images'),
(292, '', '', 'en', '', 'images'),
(293, '', '', 'en', '', 'images'),
(294, '', '', 'en', '', 'images'),
(295, '', '', 'en', '', 'images'),
(296, '', '', 'en', '', 'images'),
(297, '', '', 'en', '', 'images'),
(298, '', '', 'en', '', 'images'),
(299, '', '', 'en', '', 'images'),
(300, '', '', 'en', '', 'images'),
(301, '', '', 'en', '', 'images'),
(302, '', '', 'en', '', 'images'),
(303, '', '', 'en', '', 'images'),
(304, '', '', 'en', '', 'images'),
(305, '', '', 'en', '', 'images'),
(306, '', '', 'en', '', 'images'),
(307, '', '', 'en', '', 'images'),
(308, '', '', 'en', '', 'images'),
(309, '', '', 'en', '', 'images'),
(310, '', '', 'en', '', 'images'),
(311, '', '', 'en', '', 'images'),
(312, '', '', 'en', '', 'images'),
(313, '', '', 'en', '', 'images'),
(314, '', '', 'en', '', 'images'),
(315, '', '', 'en', '', 'images'),
(316, '', '', 'en', '', 'images'),
(317, '', '', 'en', '', 'images'),
(318, '', '', 'en', '', 'images'),
(319, '', '', 'en', '', 'images'),
(320, '', '', 'en', '', 'images'),
(321, '', '', 'en', '', 'images'),
(322, '', '', 'en', '', 'images'),
(323, '', '', 'en', '', 'images'),
(324, '', '', 'en', '', 'images'),
(325, '', '', 'en', '', 'images'),
(327, '', '', 'en', '', 'images'),
(328, '', '', 'en', '', 'images'),
(329, '', '', 'en', '', 'images'),
(330, '', '', 'en', '', 'images'),
(331, '', '', 'en', '', 'images'),
(332, '', '', 'en', '', 'images'),
(333, '', '', 'en', '', 'images'),
(334, '', '', 'en', '', 'images'),
(335, '', '', 'en', '', 'images'),
(336, '', '', 'en', '', 'images'),
(337, '', '', 'en', '', 'images'),
(338, '', '', 'en', '', 'images'),
(339, '', '', 'en', '', 'images'),
(340, '', '', 'en', '', 'images'),
(341, '', '', 'en', '', 'images'),
(342, '', '', 'en', '', 'images'),
(343, '', '', 'en', '', 'images'),
(344, '', '', 'en', '', 'images'),
(345, '', '', 'en', '', 'images'),
(346, '', '', 'en', '', 'images'),
(347, '', '', 'en', '', 'images'),
(348, '', '', 'en', '', 'images'),
(349, '', '', 'en', '', 'images'),
(350, '', '', 'en', '', 'images'),
(351, '', '', 'en', '', 'images'),
(352, '', '', 'en', '', 'images'),
(353, '', '', 'en', '', 'images'),
(354, '', '', 'en', '', 'images'),
(355, '', '', 'en', '', 'images'),
(356, '', '', 'en', '', 'images'),
(357, '', '', 'en', '', 'images'),
(358, '', '', 'en', '', 'images'),
(359, '', '', 'en', '', 'images'),
(360, '', '', 'en', '', 'images'),
(361, '', '', 'en', '', 'images'),
(362, '', '', 'en', '', 'images'),
(363, '', '', 'en', '', 'images'),
(364, '', '', 'en', '', 'images'),
(365, '', '', 'en', '', 'images'),
(366, '', '', 'en', '', 'images'),
(367, '', '', 'en', '', 'images'),
(368, '', '', 'en', '', 'images'),
(369, '', '', 'en', '', 'images'),
(370, '', '', 'en', '', 'images'),
(371, '', '', 'en', '', 'images'),
(372, '', '', 'en', '', 'images'),
(373, '', '', 'en', '', 'images'),
(374, '', '', 'en', '', 'images'),
(375, '', '', 'en', '', 'images'),
(376, '', '', 'en', '', 'images'),
(377, '', '', 'en', '', 'images'),
(378, '', '', 'en', '', 'images'),
(379, '', '', 'en', '', 'images'),
(380, '', '', 'en', '', 'images'),
(381, '', '', 'en', '', 'images'),
(382, '', '', 'en', '', 'images'),
(383, '', '', 'en', '', 'images'),
(384, '', '', 'en', '', 'images'),
(385, '', '', 'en', '', 'images'),
(386, '', '', 'en', '', 'images'),
(390, '', '', 'en', '', 'images'),
(391, '', '', 'en', '', 'images'),
(392, '', '', 'en', '', 'images'),
(393, '', '', 'en', '', 'images'),
(394, '', '', 'en', '', 'images'),
(395, '', '', 'en', '', 'images'),
(396, '', '', 'en', '', 'images'),
(397, '', '', 'en', '', 'images'),
(398, '', '', 'en', '', 'images'),
(399, '', '', 'en', '', 'images'),
(400, '', '', 'en', '', 'images'),
(401, '', '', 'en', '', 'images'),
(402, '', '', 'en', '', 'images'),
(403, '', '', 'en', '', 'images'),
(404, '', '', 'en', '', 'images'),
(405, '', '', 'en', '', 'images'),
(406, '', '', 'en', '', 'images'),
(407, '', '', 'en', '', 'images'),
(408, '', '', 'en', '', 'images'),
(409, '', '', 'en', '', 'images'),
(410, '', '', 'en', '', 'images'),
(411, '', '', 'en', '', 'images'),
(412, '', '', 'en', '', 'images'),
(413, '', '', 'en', '', 'images'),
(414, '', '', 'en', '', 'images'),
(415, '', '', 'en', '', 'images'),
(416, '', '', 'en', '', 'images'),
(417, '', '', 'en', '', 'images'),
(418, '', '', 'en', '', 'images'),
(419, '', '', 'en', '', 'images'),
(420, '', '', 'en', '', 'images'),
(421, '', '', 'en', '', 'images'),
(422, '', '', 'en', '', 'images'),
(423, '', '', 'en', '', 'images'),
(424, '', '', 'en', '', 'images'),
(425, '', '', 'en', '', 'images'),
(426, '', '', 'en', '', 'images'),
(427, '', '', 'en', '', 'images'),
(428, '', '', 'en', '', 'images'),
(429, '', '', 'en', '', 'images'),
(430, '', '', 'en', '', 'images'),
(431, '', '', 'en', '', 'images'),
(432, '', '', 'en', '', 'images'),
(433, '', '', 'en', '', 'images'),
(434, '', '', 'en', '', 'images'),
(435, '', '', 'en', '', 'images'),
(436, '', '', 'en', '', 'images'),
(437, '', '', 'en', '', 'images'),
(438, '', '', 'en', '', 'images'),
(439, '', '', 'en', '', 'images'),
(440, '', '', 'en', '', 'images'),
(441, '', '', 'en', '', 'images'),
(442, '', '', 'en', '', 'images'),
(443, '', '', 'en', '', 'images'),
(444, '', '', 'en', '', 'images'),
(445, '', '', 'en', '', 'images'),
(446, '', '', 'en', '', 'images'),
(447, '', '', 'en', '', 'images'),
(522, '', '', 'en', '', 'images'),
(525, '', '', 'en', '', 'images'),
(524, '', '', 'en', '', 'images'),
(523, '', '', 'en', '', 'images'),
(453, '', '', 'en', '', 'images'),
(454, '', '', 'en', '', 'images'),
(455, '', '', 'en', '', 'images'),
(456, '', '', 'en', '', 'images'),
(457, '', '', 'en', '', 'images'),
(458, '', '', 'en', '', 'images'),
(459, '', '', 'en', '', 'images'),
(460, '', '', 'en', '', 'images'),
(461, '', '', 'en', '', 'images'),
(462, '', '', 'en', '', 'images'),
(463, '', '', 'en', '', 'images'),
(464, '', '', 'en', '', 'images'),
(465, '', '', 'en', '', 'images'),
(466, '', '', 'en', '', 'images'),
(467, '', '', 'en', '', 'images'),
(468, '', '', 'en', '', 'images'),
(469, '', '', 'en', '', 'images'),
(470, '', '', 'en', '', 'images'),
(471, '', '', 'en', '', 'images'),
(510, '', '', 'en', '', 'images'),
(473, '', '', 'en', '', 'images'),
(474, '', '', 'en', '', 'images'),
(475, '', '', 'en', '', 'images'),
(476, '', '', 'en', '', 'images'),
(477, '', '', 'en', '', 'images'),
(478, '', '', 'en', '', 'images'),
(479, '', '', 'en', '', 'images'),
(480, '', '', 'en', '', 'images'),
(481, '', '', 'en', '', 'images'),
(482, '', '', 'en', '', 'images'),
(483, '', '', 'en', '', 'images'),
(484, '', '', 'en', '', 'images'),
(485, '', '', 'en', '', 'images'),
(486, '', '', 'en', '', 'images'),
(487, '', '', 'en', '', 'images'),
(488, '', '', 'en', '', 'images'),
(489, '', '', 'en', '', 'images'),
(511, '', '', 'en', '', 'images'),
(491, '', '', 'en', '', 'images'),
(514, '', '', 'en', '', 'images'),
(495, '', '', 'en', '', 'images'),
(516, '', '', 'en', '', 'images'),
(515, '', '', 'en', '', 'images'),
(498, '', '', 'en', '', 'images'),
(513, '', '', 'en', '', 'images'),
(500, '', '', 'en', '', 'images'),
(501, '', '', 'en', '', 'images'),
(502, '', '', 'en', '', 'images'),
(503, '', '', 'en', '', 'images'),
(504, '', '', 'en', '', 'images'),
(518, '', '', 'en', '', 'images'),
(517, '', '', 'en', '', 'images'),
(507, '', '', 'en', '', 'images'),
(508, '', '', 'en', '', 'images'),
(509, '', '', 'en', '', 'images'),
(512, '', '', 'en', '', 'images'),
(519, '', '', 'en', '', 'images'),
(520, '', '', 'en', '', 'images'),
(521, '', '', 'en', '', 'images'),
(526, '', '', 'en', '', 'images'),
(527, '', '', 'en', '', 'images'),
(528, '', '', 'en', '', 'images'),
(529, '', '', 'en', '', 'images'),
(530, '', '', 'en', '', 'images'),
(531, '', '', 'en', '', 'images'),
(532, '', '', 'en', '', 'images'),
(533, '', '', 'en', '', 'images'),
(534, '', '', 'en', '', 'images'),
(535, '', '', 'en', '', 'images'),
(536, '', '', 'en', '', 'images'),
(537, '', '', 'en', '', 'images'),
(538, '', '', 'en', '', 'images'),
(539, '', '', 'en', '', 'images'),
(540, '', '', 'en', '', 'images'),
(541, '', '', 'en', '', 'images'),
(542, '', '', 'en', '', 'images'),
(543, '', '', 'en', '', 'images'),
(544, '', '', 'en', '', 'images'),
(545, '', '', 'en', '', 'images'),
(546, '', '', 'en', '', 'images'),
(547, '', '', 'en', '', 'images'),
(548, '', '', 'en', '', 'images'),
(549, '', '', 'en', '', 'images'),
(550, '', '', 'en', '', 'images'),
(551, '', '', 'en', '', 'images'),
(552, '', '', 'en', '', 'images'),
(553, '', '', 'en', '', 'images'),
(554, '', '', 'en', '', 'images'),
(555, '', '', 'en', '', 'images'),
(556, '', '', 'en', '', 'images'),
(557, '', '', 'en', '', 'images'),
(558, '', '', 'en', '', 'images'),
(559, '', '', 'en', '', 'images'),
(560, '', '', 'en', '', 'images'),
(561, '', '', 'en', '', 'images'),
(562, '', '', 'en', '', 'images'),
(563, '', '', 'en', '', 'images'),
(572, '', '', 'en', '', 'images'),
(565, '', '', 'en', '', 'images'),
(566, '', '', 'en', '', 'images'),
(567, '', '', 'en', '', 'images'),
(568, '', '', 'en', '', 'images'),
(569, '', '', 'en', '', 'images'),
(570, '', '', 'en', '', 'images'),
(571, '', '', 'en', '', 'images'),
(573, '', '', 'en', '', 'images'),
(574, '', '', 'en', '', 'images'),
(575, '', '', 'en', '', 'images'),
(576, '', '', 'en', '', 'images'),
(577, '', '', 'en', '', 'images'),
(578, '', '', 'en', '', 'images'),
(579, '', '', 'en', '', 'images'),
(580, '', '', 'en', '', 'images'),
(581, '', '', 'en', '', 'images'),
(582, '', '', 'en', '', 'images'),
(583, '', '', 'en', '', 'images'),
(584, '', '', 'en', '', 'images'),
(585, '', '', 'en', '', 'images'),
(586, '', '', 'en', '', 'images'),
(587, '', '', 'en', '', 'images'),
(588, '', '', 'en', '', 'images'),
(589, '', '', 'en', '', 'images'),
(590, '', '', 'en', '', 'images'),
(591, '', '', 'en', '', 'images'),
(592, '', '', 'en', '', 'images'),
(593, '', '', 'en', '', 'images'),
(594, '', '', 'en', '', 'images'),
(595, '', '', 'en', '', 'images'),
(596, '', '', 'en', '', 'images'),
(597, '', '', 'en', '', 'images'),
(598, '', '', 'en', '', 'images'),
(599, '', '', 'en', '', 'images'),
(600, '', '', 'en', '', 'images'),
(601, '', '', 'en', '', 'images'),
(602, '', '', 'en', '', 'images'),
(603, '', '', 'en', '', 'images'),
(604, '', '', 'en', '', 'images'),
(605, '', '', 'en', '', 'images'),
(606, '', '', 'en', '', 'images'),
(607, '', '', 'en', '', 'images'),
(608, '', '', 'en', '', 'images'),
(609, '', '', 'en', '', 'images'),
(610, '', '', 'en', '', 'images'),
(611, '', '', 'en', '', 'images'),
(612, '', '', 'en', '', 'images'),
(613, '', '', 'en', '', 'images'),
(614, '', '', 'en', '', 'images'),
(615, '', '', 'en', '', 'images'),
(616, '', '', 'en', '', 'images'),
(617, '', '', 'en', '', 'images'),
(618, '', '', 'en', '', 'images'),
(619, '', '', 'en', '', 'images'),
(620, '', '', 'en', '', 'images'),
(621, '', '', 'en', '', 'images'),
(622, '', '', 'en', '', 'images'),
(623, '', '', 'en', '', 'images'),
(624, '', '', 'en', '', 'images'),
(625, '', '', 'en', '', 'images'),
(626, '', '', 'en', '', 'images'),
(627, '', '', 'en', '', 'images'),
(628, '', '', 'en', '', 'images'),
(629, '', '', 'en', '', 'images'),
(630, '', '', 'en', '', 'images'),
(631, '', '', 'en', '', 'images'),
(632, '', '', 'en', '', 'images'),
(633, '', '', 'en', '', 'images'),
(634, '', '', 'en', '', 'images'),
(635, '', '', 'en', '', 'images'),
(636, '', '', 'en', '', 'images'),
(637, '', '', 'en', '', 'images'),
(638, '', '', 'en', '', 'images'),
(639, '', '', 'en', '', 'images'),
(640, '', '', 'en', '', 'images'),
(641, '', '', 'en', '', 'images'),
(642, '', '', 'en', '', 'images'),
(643, '', '', 'en', '', 'images'),
(644, '', '', 'en', '', 'images'),
(645, '', '', 'en', '', 'images'),
(646, '', '', 'en', '', 'images'),
(647, '', '', 'en', '', 'images'),
(648, '', '', 'en', '', 'images'),
(649, '', '', 'en', '', 'images'),
(650, '', '', 'en', '', 'images'),
(651, '', '', 'en', '', 'images'),
(652, '', '', 'en', '', 'images'),
(653, '', '', 'en', '', 'images'),
(654, '', '', 'en', '', 'images'),
(655, '', '', 'en', '', 'images'),
(656, '', '', 'en', '', 'images'),
(657, '', '', 'en', '', 'images'),
(658, '', '', 'en', '', 'images'),
(659, '', '', 'en', '', 'images'),
(660, '', '', 'en', '', 'images'),
(661, '', '', 'en', '', 'images'),
(662, '', '', 'en', '', 'images'),
(663, '', '', 'en', '', 'images'),
(664, '', '', 'en', '', 'images'),
(665, '', '', 'en', '', 'images'),
(666, '', '', 'en', '', 'images'),
(667, '', '', 'en', '', 'images'),
(668, '', '', 'en', '', 'images'),
(669, '', '', 'en', '', 'images'),
(670, '', '', 'en', '', 'images'),
(671, '', '', 'en', '', 'images'),
(672, '', '', 'en', '', 'images'),
(673, '', '', 'en', '', 'images'),
(674, '', '', 'en', '', 'images'),
(675, '', '', 'en', '', 'images'),
(676, '', '', 'en', '', 'images'),
(677, '', '', 'en', '', 'images'),
(678, '', '', 'en', '', 'images'),
(679, '', '', 'en', '', 'images'),
(680, '', '', 'en', '', 'images'),
(681, '', '', 'en', '', 'images'),
(682, '', '', 'en', '', 'images'),
(683, '', '', 'en', '', 'images'),
(684, '', '', 'en', '', 'images'),
(685, '', '', 'en', '', 'images'),
(686, '', '', 'en', '', 'images'),
(687, '', '', 'en', '', 'images'),
(688, '', '', 'en', '', 'images'),
(689, '', '', 'en', '', 'images'),
(690, '', '', 'en', '', 'images'),
(691, '', '', 'en', '', 'images'),
(692, '', '', 'en', '', 'images'),
(693, '', '', 'en', '', 'images'),
(694, '', '', 'en', '', 'images'),
(695, '', '', 'en', '', 'images'),
(696, '', '', 'en', '', 'images'),
(697, '', '', 'en', '', 'images'),
(698, '', '', 'en', '', 'images'),
(699, '', '', 'en', '', 'images'),
(700, '', '', 'en', '', 'images'),
(701, '', '', 'en', '', 'images'),
(702, '', '', 'en', '', 'images'),
(703, '', '', 'en', '', 'images'),
(704, '', '', 'en', '', 'images'),
(705, '', '', 'en', '', 'images'),
(706, '', '', 'en', '', 'images'),
(707, '', '', 'en', '', 'images'),
(708, '', '', 'en', '', 'images'),
(709, '', '', 'en', '', 'images'),
(710, '', '', 'en', '', 'images'),
(711, '', '', 'en', '', 'images'),
(712, '', '', 'en', '', 'images'),
(713, '', '', 'en', '', 'images'),
(714, '', '', 'en', '', 'images'),
(715, '', '', 'en', '', 'images'),
(716, '', '', 'en', '', 'images'),
(717, '', '', 'en', '', 'images'),
(718, '', '', 'en', '', 'images'),
(719, '', '', 'en', '', 'images'),
(720, '', '', 'en', '', 'images'),
(721, '', '', 'en', '', 'images'),
(722, '', '', 'en', '', 'images'),
(723, '', '', 'en', '', 'images'),
(724, '', '', 'en', '', 'images'),
(725, '', '', 'en', '', 'images'),
(739, '', '', 'en', '', 'images'),
(727, '', '', 'en', '', 'images'),
(728, '', '', 'en', '', 'images'),
(729, '', '', 'en', '', 'images'),
(730, '', '', 'en', '', 'images'),
(731, '', '', 'en', '', 'images'),
(732, '', '', 'en', '', 'images'),
(733, '', '', 'en', '', 'images'),
(734, '', '', 'en', '', 'images'),
(735, '', '', 'en', '', 'images'),
(736, '', '', 'en', '', 'images'),
(737, '', '', 'en', '', 'images'),
(738, '', '', 'en', '', 'images'),
(740, '', '', 'en', '', 'images'),
(741, '', '', 'en', '', 'images'),
(742, '', '', 'en', '', 'images'),
(743, '', '', 'en', '', 'images'),
(744, '', '', 'en', '', 'images'),
(745, '', '', 'en', '', 'images'),
(746, '', '', 'en', '', 'images'),
(747, '', '', 'en', '', 'images'),
(748, '', '', 'en', '', 'images'),
(749, '', '', 'en', '', 'images'),
(750, '', '', 'en', '', 'images'),
(751, '', '', 'en', '', 'images'),
(752, '', '', 'en', '', 'images'),
(753, '', '', 'en', '', 'images'),
(754, '', '', 'en', '', 'images'),
(755, '', '', 'en', '', 'images'),
(756, '', '', 'en', '', 'images'),
(757, '', '', 'en', '', 'images'),
(758, '', '', 'en', '', 'images'),
(759, '', '', 'en', '', 'images'),
(760, '', '', 'en', '', 'images'),
(761, '', '', 'en', '', 'images'),
(762, '', '', 'en', '', 'images'),
(763, '', '', 'en', '', 'images'),
(764, '', '', 'en', '', 'images'),
(765, '', '', 'en', '', 'images'),
(766, '', '', 'en', '', 'images'),
(767, '', '', 'en', '', 'images'),
(768, '', '', 'en', '', 'images'),
(769, '', '', 'en', '', 'images'),
(833, '', '', 'en', '', 'images'),
(771, '', '', 'en', '', 'images'),
(772, '', '', 'en', '', 'images'),
(773, '', '', 'en', '', 'images'),
(774, '', '', 'en', '', 'images'),
(775, '', '', 'en', '', 'images'),
(776, '', '', 'en', '', 'images'),
(777, '', '', 'en', '', 'images'),
(778, '', '', 'en', '', 'images'),
(779, '', '', 'en', '', 'images'),
(780, '', '', 'en', '', 'images'),
(781, '', '', 'en', '', 'images'),
(782, '', '', 'en', '', 'images'),
(783, '', '', 'en', '', 'images'),
(784, '', '', 'en', '', 'images'),
(785, '', '', 'en', '', 'images'),
(786, '', '', 'en', '', 'images'),
(787, '', '', 'en', '', 'images'),
(788, '', '', 'en', '', 'images'),
(789, '', '', 'en', '', 'images'),
(790, '', '', 'en', '', 'images'),
(791, '', '', 'en', '', 'images'),
(792, '', '', 'en', '', 'images'),
(793, '', '', 'en', '', 'images'),
(794, '', '', 'en', '', 'images'),
(795, '', '', 'en', '', 'images'),
(796, '', '', 'en', '', 'images'),
(797, '', '', 'en', '', 'images'),
(798, '', '', 'en', '', 'images'),
(799, '', '', 'en', '', 'images'),
(800, '', '', 'en', '', 'images'),
(801, '', '', 'en', '', 'images'),
(802, '', '', 'en', '', 'images'),
(803, '', '', 'en', '', 'images'),
(804, '', '', 'en', '', 'images'),
(805, '', '', 'en', '', 'images'),
(806, '', '', 'en', '', 'images'),
(807, '', '', 'en', '', 'images'),
(808, '', '', 'en', '', 'images'),
(809, '', '', 'en', '', 'images'),
(810, '', '', 'en', '', 'images'),
(811, '', '', 'en', '', 'images'),
(812, '', '', 'en', '', 'images'),
(813, '', '', 'en', '', 'images'),
(814, '', '', 'en', '', 'images'),
(815, '', '', 'en', '', 'images'),
(816, '', '', 'en', '', 'images'),
(817, '', '', 'en', '', 'images'),
(818, '', '', 'en', '', 'images'),
(819, '', '', 'en', '', 'images'),
(820, '', '', 'en', '', 'images'),
(821, '', '', 'en', '', 'images'),
(822, '', '', 'en', '', 'images'),
(823, '', '', 'en', '', 'images'),
(824, '', '', 'en', '', 'images'),
(825, '', '', 'en', '', 'images'),
(826, '', '', 'en', '', 'images'),
(827, '', '', 'en', '', 'images'),
(828, '', '', 'en', '', 'images'),
(829, '', '', 'en', '', 'images'),
(830, '', '', 'en', '', 'images'),
(831, '', '', 'en', '', 'images'),
(832, '', '', 'en', '', 'images'),
(834, '', '', 'en', '', 'images'),
(835, '', '', 'en', '', 'images'),
(836, '', '', 'en', '', 'images'),
(837, '', '', 'en', '', 'images'),
(838, '', '', 'en', '', 'images'),
(839, '', '', 'en', '', 'images'),
(840, '', '', 'en', '', 'images'),
(841, '', '', 'en', '', 'images'),
(842, '', '', 'en', '', 'images'),
(843, '', '', 'en', '', 'images'),
(844, '', '', 'en', '', 'images'),
(845, '', '', 'en', '', 'images'),
(846, '', '', 'en', '', 'images'),
(847, '', '', 'en', '', 'images'),
(848, '', '', 'en', '', 'images'),
(849, '', '', 'en', '', 'images'),
(850, '', '', 'en', '', 'images'),
(851, '', '', 'en', '', 'images'),
(852, '', '', 'en', '', 'images'),
(853, '', '', 'en', '', 'images'),
(854, '', '', 'en', '', 'images'),
(855, '', '', 'en', '', 'images'),
(856, '', '', 'en', '', 'images'),
(857, '', '', 'en', '', 'images'),
(858, '', '', 'en', '', 'images'),
(862, '', '', 'en', '', 'images'),
(861, '', '', 'en', '', 'images'),
(863, '', '', 'en', '', 'images'),
(879, '', '', 'en', '', 'images'),
(898, '', '', 'en', '', 'images'),
(881, '', '', 'en', '', 'images'),
(882, '', '', 'en', '', 'images'),
(905, '', '', 'en', '', 'images'),
(906, '', '', 'en', '', 'images'),
(908, '', '', 'en', '', 'images'),
(909, '', '', 'en', '', 'images'),
(904, '', '', 'en', '', 'images'),
(907, '', '', 'en', '', 'images'),
(926, '', '', 'en', '', 'images'),
(1006, '', '', 'en', '', 'images'),
(1007, '', '', 'en', '', 'images'),
(1008, '', '', 'en', '', 'images'),
(1009, '', '', 'en', '', 'images'),
(1010, '', '', 'en', '', 'images'),
(1011, '', '', 'en', '', 'images'),
(1012, '', '', 'en', '', 'images'),
(1013, '', '', 'en', '', 'images'),
(1014, '', '', 'en', '', 'images'),
(1015, '', '', 'en', '', 'images'),
(1016, '', '', 'en', '', 'images'),
(1017, '', '', 'en', '', 'images'),
(1018, '', '', 'en', '', 'images'),
(1019, '', '', 'en', '', 'images'),
(1020, '', '', 'en', '', 'images'),
(1021, '', '', 'en', '', 'images'),
(1022, '', '', 'en', '', 'images'),
(1023, '', '', 'en', '', 'images'),
(1024, '', '', 'en', '', 'images'),
(1025, '', '', 'en', '', 'images'),
(1026, '', '', 'en', '', 'images'),
(1027, '', '', 'en', '', 'images'),
(1028, '', '', 'en', '', 'images'),
(1029, '', '', 'en', '', 'images'),
(1030, '', '', 'en', '', 'images'),
(1031, '', '', 'en', '', 'images'),
(1032, '', '', 'en', '', 'images'),
(1033, '', '', 'en', '', 'images'),
(1034, '', '', 'en', '', 'images'),
(1035, '', '', 'en', '', 'images'),
(1036, '', '', 'en', '', 'images'),
(1037, '', '', 'en', '', 'images'),
(1038, '', '', 'en', '', 'images'),
(1039, '', '', 'en', '', 'images'),
(1040, '', '', 'en', '', 'images'),
(1041, '', '', 'en', '', 'images'),
(1042, '', '', 'en', '', 'images'),
(1043, '', '', 'en', '', 'images'),
(1044, '', '', 'en', '', 'images'),
(1045, '', '', 'en', '', 'images'),
(1046, '', '', 'en', '', 'images'),
(1047, '', '', 'en', '', 'images'),
(1048, '', '', 'en', '', 'images'),
(1051, '', '', 'en', '', 'images'),
(1052, '', '', 'en', '', 'images'),
(1053, '', '', 'en', '', 'images'),
(1054, '', '', 'en', '', 'images'),
(1055, '', '', 'en', '', 'images'),
(1, '', '', 'en', 'Company news and unique discounts for subscribers', 'mailing_lists'),
(8649, '', '', 'en', '', 'images'),
(8650, '', '', 'en', '', 'images'),
(8651, '', '', 'en', '', 'images');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]companies`
--

CREATE TABLE `[[dbprefix]]companies` (
  `company_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `status` char(1) NOT NULL DEFAULT 'A',
  `company` varchar(255) NOT NULL,
  `lang_code` char(2) NOT NULL DEFAULT '',
  `address` varchar(255) NOT NULL,
  `city` varchar(64) NOT NULL,
  `state` varchar(32) NOT NULL,
  `country` char(2) NOT NULL,
  `zipcode` varchar(16) NOT NULL,
  `email` varchar(128) NOT NULL,
  `phone` varchar(128) NOT NULL,
  `url` varchar(128) NOT NULL,
  `storefront` varchar(255) NOT NULL DEFAULT '',
  `secure_storefront` varchar(255) NOT NULL DEFAULT '',
  `entry_page` varchar(50) NOT NULL DEFAULT 'none',
  `redirect_customer` char(1) NOT NULL DEFAULT 'Y',
  `countries_list` text,
  `timestamp` int(11) NOT NULL,
  `shippings` text,
  `logos` text,
  `request_user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `request_account_name` varchar(255) NOT NULL DEFAULT '',
  `request_account_data` blob,
  PRIMARY KEY (`company_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]companies`
--

INSERT INTO `[[dbprefix]]companies` VALUES
(1, 'A', 'CS-Cart', 'en', 'Boston street', 'Boston', 'MA', 'US', '02125', 'cs-cart@example.com', '+16175556985', 'http://example.com', '[[domhost]][[relativeurl]]', '[[domhost]][[relativeurl]]', 'none', 'Y', NULL, 1269610461, '1', '', 0, '', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]company_descriptions`
--

CREATE TABLE `[[dbprefix]]company_descriptions` (
  `company_id` int(11) unsigned NOT NULL,
  `lang_code` char(2) NOT NULL,
  `company_description` text,
  PRIMARY KEY (`company_id`,`lang_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]countries`
--

CREATE TABLE `[[dbprefix]]countries` (
  `code` char(2) NOT NULL DEFAULT '',
  `code_A3` char(3) NOT NULL DEFAULT '',
  `code_N3` char(3) NOT NULL DEFAULT '',
  `region` char(2) NOT NULL DEFAULT '',
  `lat` float NOT NULL DEFAULT '0',
  `lon` float NOT NULL DEFAULT '0',
  `status` char(1) NOT NULL DEFAULT 'A',
  PRIMARY KEY (`code`),
  KEY `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]countries`
--

INSERT INTO `[[dbprefix]]countries` VALUES
('AF', 'AFG', '004', 'AS', 33, 65, 'A'),
('AL', 'ALB', '008', 'EU', 41, 20, 'A'),
('DZ', 'DZA', '012', 'AF', 28, 3, 'A'),
('AS', 'ASM', '016', 'AU', -14.2, -170, 'A'),
('AD', 'AND', '020', 'EU', 42.3, 1.3, 'A'),
('AO', 'AGO', '024', 'AF', -12.3, 18.3, 'A'),
('AI', 'AIA', '660', 'LA', 18.15, -63.1, 'A'),
('AQ', 'ATA', '010', 'AN', -90, 0, 'A'),
('AG', 'ATG', '028', 'LA', 17.03, -61.48, 'A'),
('AR', 'ARG', '032', 'LA', -34, -64, 'A'),
('AM', 'ARM', '051', 'AS', 40, 45, 'A'),
('AW', 'ABW', '533', 'LA', 12.3, -69.58, 'A'),
('AU', 'AUS', '036', 'AU', -27, 133, 'A'),
('AT', 'AUT', '040', 'EU', 47.2, 13.2, 'A'),
('AZ', 'AZE', '031', 'AS', 40.3, 47.3, 'A'),
('BS', 'BHS', '044', 'LA', 24.15, -76, 'A'),
('BH', 'BHR', '048', 'AS', 26, 50.33, 'A'),
('BD', 'BGD', '050', 'AS', 24, 90, 'A'),
('BB', 'BRB', '052', 'LA', 13.1, -59.32, 'A'),
('BY', 'BLR', '112', 'EU', 53, 28, 'A'),
('BE', 'BEL', '056', 'EU', 50.5, 4, 'A'),
('BZ', 'BLZ', '084', 'LA', 17.15, -88.45, 'A'),
('BJ', 'BEN', '204', 'AF', 9.3, 2.15, 'A'),
('BM', 'BMU', '060', 'LA', 32.2, -64.45, 'A'),
('BT', 'BTN', '064', 'AS', 27.3, 90.3, 'A'),
('BO', 'BOL', '068', 'LA', -17, -65, 'A'),
('BA', 'BIH', '070', 'EU', 44, 18, 'A'),
('BW', 'BWA', '072', 'AF', -22, 24, 'A'),
('BV', 'BVT', '074', 'AN', -54.26, 3.24, 'A'),
('BR', 'BRA', '076', 'LA', -10, -55, 'A'),
('IO', 'IOT', '086', 'AS', -6, 71.3, 'A'),
('VG', 'VGB', '092', 'LA', 18.2, -64.5, 'A'),
('BN', 'BRN', '096', 'AS', 4.3, 114.4, 'A'),
('BG', 'BGR', '100', 'EU', 43, 25, 'A'),
('BF', 'BFA', '854', 'AF', 13, -2, 'A'),
('BI', 'BDI', '108', 'AF', -3.3, 30, 'A'),
('KH', 'KHM', '116', 'AS', 13, 105, 'A'),
('CM', 'CMR', '120', 'AF', 6, 12, 'A'),
('CA', 'CAN', '124', 'NA', 60, -95, 'A'),
('CV', 'CPV', '132', 'AF', 16, -24, 'A'),
('KY', 'CYM', '136', 'LA', 19.3, -80.3, 'A'),
('CF', 'CAF', '140', 'AF', 7, 21, 'A'),
('TD', 'TCD', '148', 'AF', 15, 19, 'A'),
('CL', 'CHL', '152', 'LA', -30, -71, 'A'),
('CN', 'CHN', '156', 'AS', 35, 105, 'A'),
('CX', 'CXR', '162', 'AU', -10.3, 105.4, 'A'),
('CC', 'CCK', '166', 'AU', -12.3, 96.5, 'A'),
('CO', 'COL', '170', 'LA', 4, -72, 'A'),
('KM', 'COM', '174', 'AF', -12.1, 44.15, 'A'),
('CG', 'COG', '178', 'AF', 0, 25, 'A'),
('CK', 'COK', '184', 'AU', -21.14, -159.46, 'A'),
('CR', 'CRI', '188', 'LA', 10, -84, 'A'),
('CI', 'CIV', '384', 'AF', 7.64, -4.93, 'A'),
('HR', 'HRV', '191', 'EU', 45.1, 15.3, 'A'),
('CU', 'CUB', '192', 'LA', 21.3, -80, 'A'),
('CY', 'CYP', '196', 'EU', 35, 33, 'A'),
('CZ', 'CZE', '203', 'EU', 49.45, 15.3, 'A'),
('DK', 'DNK', '208', 'EU', 56, 10, 'A'),
('DJ', 'DJI', '262', 'AF', 11.3, 43, 'A'),
('DM', 'DMA', '212', 'LA', 15.25, -61.2, 'A'),
('DO', 'DOM', '214', 'LA', 19, -70.4, 'A'),
('TL', 'TLS', '626', 'AS', -8.5, 125.55, 'A'),
('EC', 'ECU', '218', 'LA', -2, -77.3, 'A'),
('EG', 'EGY', '818', 'AF', 27, 30, 'A'),
('SV', 'SLV', '222', 'LA', 13.5, -88.55, 'A'),
('GQ', 'GNQ', '226', 'AF', 2, 10, 'A'),
('ER', 'ERI', '232', 'AF', 15, 39, 'A'),
('EE', 'EST', '233', 'EU', 59, 26, 'A'),
('ET', 'ETH', '210', 'AF', 8, 38, 'A'),
('FK', 'FLK', '238', 'LA', -51.45, -59, 'A'),
('FO', 'FRO', '234', 'EU', 62, -7, 'A'),
('FJ', 'FJI', '242', 'AU', -18, 175, 'A'),
('FI', 'FIN', '246', 'EU', 64, 26, 'A'),
('FR', 'FRA', '250', 'EU', 46, 2, 'A'),
('FX', 'FXX', '249', 'EU', 0, 0, 'A'),
('GF', 'GUF', '254', 'LA', 4, -53, 'A'),
('PF', 'PYF', '258', 'AU', -15, -140, 'A'),
('TF', 'ATF', '260', 'AN', -43, 67, 'A'),
('GA', 'GAB', '266', 'AF', -1, 11.45, 'A'),
('GE', 'GEO', '268', 'AS', 42, 43.3, 'A'),
('GM', 'GMB', '270', 'AF', 13.28, -16.34, 'A'),
('PS', 'PSE', '275', 'AS', 31.89, 34.9, 'A'),
('DE', 'DEU', '276', 'EU', 51, 9, 'A'),
('GH', 'GHA', '288', 'AF', 8, -2, 'A'),
('GI', 'GIB', '292', 'EU', 36.8, -5.21, 'A'),
('GR', 'GRC', '300', 'EU', 39, 22, 'A'),
('GL', 'GRL', '304', 'NA', 72, -40, 'A'),
('GD', 'GRD', '308', 'LA', 12.07, -61.4, 'A'),
('GP', 'GLP', '312', 'LA', 16.15, -61.35, 'A'),
('GU', 'GUM', '316', 'AU', 13.28, 144.47, 'A'),
('GT', 'GTM', '320', 'LA', 15.3, -90.15, 'A'),
('GN', 'GIN', '324', 'AF', 11, -10, 'A'),
('GW', 'GNB', '624', 'AF', 12, -15, 'A'),
('GY', 'GUY', '328', 'LA', 5, -59, 'A'),
('HT', 'HTI', '332', 'LA', 19, -72.25, 'A'),
('HM', 'HMD', '334', 'AU', -53.06, 72.31, 'A'),
('HN', 'HND', '340', 'LA', 15, -86.3, 'A'),
('HK', 'HKG', '344', 'AS', 22.15, 114.1, 'A'),
('HU', 'HUN', '348', 'EU', 47, 20, 'A'),
('IS', 'ISL', '352', 'EU', 65, -18, 'A'),
('IN', 'IND', '356', 'AS', 20, 77, 'A'),
('ID', 'IDN', '360', 'AS', -5, 120, 'A'),
('IQ', 'IRQ', '368', 'AS', 33, 44, 'A'),
('IE', 'IRL', '372', 'EU', 53, -8, 'A'),
('IR', 'IRN', '364', 'AS', 32, 53, 'A'),
('IL', 'ISR', '376', 'AS', 31.3, 34.45, 'A'),
('IT', 'ITA', '380', 'EU', 42.5, 12.5, 'A'),
('JM', 'JAM', '388', 'LA', 18.15, -77.3, 'A'),
('JP', 'JPN', '392', 'AS', 36, 138, 'A'),
('JO', 'JOR', '400', 'AS', 31, 36, 'A'),
('KZ', 'KAZ', '398', 'AS', 48, 68, 'A'),
('KE', 'KEN', '404', 'AF', 1, 38, 'A'),
('KI', 'KIR', '296', 'AU', 1.25, 173, 'A'),
('KP', 'PRK', '408', 'AS', 40, 127, 'A'),
('KR', 'KOR', '410', 'AS', 37, 127.3, 'A'),
('KW', 'KWT', '414', 'AS', 29.3, 45.45, 'A'),
('KG', 'KGZ', '417', 'AS', 41, 75, 'A'),
('LA', 'LAO', '418', 'AS', 18, 105, 'A'),
('LV', 'LVA', '428', 'EU', 57, 25, 'A'),
('LB', 'LBN', '422', 'AS', 33.5, 35.5, 'A'),
('LS', 'LSO', '426', 'AF', -29.3, 28.3, 'A'),
('LR', 'LBR', '430', 'AF', 6.3, -9.3, 'A'),
('LY', 'LBY', '434', 'AF', 25, 17, 'A'),
('LI', 'LIE', '438', 'EU', 47.16, 9.32, 'A'),
('LT', 'LTU', '440', 'EU', 56, 24, 'A'),
('LU', 'LUX', '442', 'EU', 49.45, 6.1, 'A'),
('MO', 'MAC', '446', 'AS', 22.1, 113.33, 'A'),
('MK', 'MKD', '807', 'EU', 41.5, 22, 'A'),
('MG', 'MDG', '450', 'AF', -20, 47, 'A'),
('MW', 'MWI', '454', 'AF', -13.3, 34, 'A'),
('MY', 'MYS', '458', 'AS', 2.3, 112.3, 'A'),
('MV', 'MDV', '462', 'AS', 3.15, 73, 'A'),
('ML', 'MLI', '466', 'AF', 17, -4, 'A'),
('MT', 'MLT', '470', 'EU', 35.5, 14.35, 'A'),
('MH', 'MHL', '584', 'AU', 9, 168, 'A'),
('MQ', 'MTQ', '474', 'LA', 14.4, -61, 'A'),
('MR', 'MRT', '478', 'AF', 20, -12, 'A'),
('MU', 'MUS', '480', 'AF', -20.17, 57.33, 'A'),
('YT', 'MYT', '175', 'AF', -12.5, 45.1, 'A'),
('MX', 'MEX', '484', 'LA', 23, -102, 'A'),
('FM', 'FSM', '583', 'AU', 6.55, 158.15, 'A'),
('MD', 'MDA', '498', 'EU', 47, 29, 'A'),
('MC', 'MCO', '492', 'EU', 43.44, 7.24, 'A'),
('MN', 'MNG', '496', 'AS', 46, 105, 'A'),
('MS', 'MSR', '500', 'LA', 16.45, -62.12, 'A'),
('MA', 'MAR', '504', 'AF', 32, -5, 'A'),
('MZ', 'MOZ', '508', 'AF', -18.15, 35, 'A'),
('MM', 'MMR', '104', 'AS', 22, 98, 'A'),
('NA', 'NAM', '516', 'AF', -22, 17, 'A'),
('NR', 'NRU', '520', 'AU', -0.32, 166.55, 'A'),
('NP', 'NPL', '524', 'AS', 28, 84, 'A'),
('NL', 'NLD', '528', 'EU', 52.3, 5.45, 'A'),
('NC', 'NCL', '540', 'AU', -21.3, 165.3, 'A'),
('NZ', 'NZL', '554', 'AU', -41, 174, 'A'),
('NI', 'NIC', '558', 'LA', 13, -85, 'A'),
('NE', 'NER', '562', 'AF', 16, 8, 'A'),
('NG', 'NGA', '566', 'AF', 10, 8, 'A'),
('NU', 'NIU', '570', 'AU', -19.02, -169.52, 'A'),
('NF', 'NFK', '574', 'AU', -29.02, 167.57, 'A'),
('MP', 'MNP', '580', 'AU', 15.12, 145.45, 'A'),
('NO', 'NOR', '578', 'EU', 62, 10, 'A'),
('OM', 'OMN', '512', 'AS', 21, 57, 'A'),
('PK', 'PAK', '586', 'AS', 30, 70, 'A'),
('PW', 'PLW', '585', 'AU', 7.3, 134.3, 'A'),
('PA', 'PAN', '591', 'LA', 9, -80, 'A'),
('PG', 'PNG', '598', 'AS', -6, 147, 'A'),
('PY', 'PRY', '600', 'LA', -23, -58, 'A'),
('PE', 'PER', '604', 'LA', -10, -76, 'A'),
('PH', 'PHL', '608', 'AS', 13, 122, 'A'),
('PN', 'PCN', '612', 'AU', -25.04, -130.06, 'A'),
('PL', 'POL', '616', 'EU', 52, 20, 'A'),
('PT', 'PRT', '620', 'EU', 39.3, -8, 'A'),
('PR', 'PRI', '630', 'LA', 18.15, -66.3, 'A'),
('QA', 'QAT', '634', 'AS', 25.3, 51.15, 'A'),
('RE', 'REU', '638', 'AF', -21.06, 55.36, 'A'),
('RO', 'ROU', '642', 'EU', 46, 25, 'A'),
('RU', 'RUS', '643', 'EU', 60, 100, 'A'),
('RW', 'RWA', '646', 'AF', -2, 30, 'A'),
('LC', 'LCA', '662', 'LA', 13.53, -60.68, 'A'),
('WS', 'WSM', '685', 'AU', -13.35, -172.2, 'A'),
('SM', 'SMR', '674', 'EU', 43.46, 12.25, 'A'),
('ST', 'STP', '678', 'AF', 1, 7, 'A'),
('SA', 'SAU', '682', 'AS', 25, 45, 'A'),
('SN', 'SEN', '686', 'AF', 14, -14, 'A'),
('SC', 'SYC', '690', 'AF', -4.35, 55.4, 'A'),
('SL', 'SLE', '694', 'AF', 8.3, -11.3, 'A'),
('SG', 'SGP', '702', 'AS', 1.22, 103.48, 'A'),
('SK', 'SVK', '703', 'EU', 48.4, 19.3, 'A'),
('SI', 'SVN', '705', 'EU', 46.07, 14.49, 'A'),
('SB', 'SLB', '090', 'AU', -8, 159, 'A'),
('SO', 'SOM', '706', 'AF', 10, 49, 'A'),
('ZA', 'ZAF', '710', 'AF', -29, 24, 'A'),
('ES', 'ESP', '724', 'EU', 40, -4, 'A'),
('LK', 'LKA', '144', 'AS', 7, 81, 'A'),
('SH', 'SHN', '654', 'AF', -15.56, -5.42, 'A'),
('KN', 'KNA', '659', 'LA', 17.2, -62.45, 'A'),
('PM', 'SPM', '666', 'NA', 46.5, -56.2, 'A'),
('VC', 'VCT', '670', 'LA', 13.15, -61.12, 'A'),
('SD', 'SDN', '736', 'AF', 15, 30, 'A'),
('SR', 'SUR', '740', 'LA', 4, -56, 'A'),
('SJ', 'SJM', '744', 'EU', 78, 20, 'A'),
('SZ', 'SWZ', '748', 'AF', -26.3, 31.3, 'A'),
('SE', 'SWE', '752', 'EU', 62, 15, 'A'),
('CH', 'CHE', '756', 'EU', 47, 8, 'A'),
('SY', 'SYR', '760', 'AS', 35, 38, 'A'),
('TW', 'TWN', '158', 'AS', 23.3, 121, 'A'),
('TJ', 'TJK', '762', 'AS', 39, 71, 'A'),
('TZ', 'TZA', '834', 'AF', -6, 35, 'A'),
('TH', 'THA', '764', 'AS', 15, 100, 'A'),
('TG', 'TGO', '768', 'AF', 8, 1.1, 'A'),
('TK', 'TKL', '772', 'AU', -9, -172, 'A'),
('TO', 'TON', '776', 'AU', -20, -175, 'A'),
('TT', 'TTO', '780', 'LA', 11, -61, 'A'),
('TN', 'TUN', '788', 'AF', 34, 9, 'A'),
('TR', 'TUR', '792', 'EU', 39, 35, 'A'),
('TM', 'TKM', '795', 'AS', 40, 60, 'A'),
('TC', 'TCA', '796', 'LA', 21.45, -71.35, 'A'),
('TV', 'TUV', '798', 'AU', -8, 178, 'A'),
('UG', 'UGA', '800', 'AF', 1, 32, 'A'),
('UA', 'UKR', '804', 'EU', 49, 32, 'A'),
('AE', 'ARE', '784', 'AS', 24, 54, 'A'),
('GB', 'GBR', '826', 'EU', 54, -2, 'A'),
('US', 'USA', '840', 'NA', 38, -97, 'A'),
('VI', 'VIR', '850', 'LA', 18.2, -64.5, 'A'),
('UY', 'URY', '858', 'LA', -33, -56, 'A'),
('UZ', 'UZB', '860', 'AS', 41, 64, 'A'),
('VU', 'VUT', '548', 'AU', -16, 167, 'A'),
('VA', 'VAT', '336', 'EU', 41.54, 12.27, 'A'),
('VE', 'VEN', '862', 'LA', 8, -66, 'A'),
('VN', 'VNM', '704', 'AS', 16, 106, 'A'),
('WF', 'WLF', '876', 'AU', -13.18, -176.12, 'A'),
('EH', 'ESH', '732', 'AF', 24.3, -13, 'A'),
('YE', 'YEM', '887', 'AS', 15, 48, 'A'),
('CS', 'SCG', '891', 'EU', 43.57, 21.41, 'A'),
('ZR', 'ZAR', '180', 'AF', 0, 0, 'A'),
('ZM', 'ZMB', '894', 'AF', -15, 30, 'A'),
('ZW', 'ZWE', '716', 'AF', -20, 30, 'A'),
('AP', '', '', '', -2.81, 128.5, 'A'),
('RS', 'SRB', '688', 'EU', 44.02, 21.01, 'A'),
('AX', 'ALA', '248', 'EU', 60.21, 20.16, 'A'),
('EU', '', '', '', 0, 0, 'A'),
('ME', 'MNE', '499', 'EU', 42.47, 19.28, 'A'),
('GG', 'GGY', '831', 'EU', 49.27, 2.33, 'A'),
('JE', 'JEY', '832', 'EU', 49.11, 2.06, 'A'),
('IM', 'IMN', '833', 'EU', 54.09, 4.29, 'A'),
('CW', 'CUW', '531', 'LA', 12.18, -69, 'A'),
('SX', 'SXM', '534', 'LA', 18.07, -63.05, 'A');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]country_descriptions`
--

CREATE TABLE `[[dbprefix]]country_descriptions` (
  `code` char(2) NOT NULL DEFAULT '',
  `lang_code` char(2) NOT NULL DEFAULT '',
  `country` varchar(128) NOT NULL DEFAULT '',
  PRIMARY KEY (`code`,`lang_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]country_descriptions`
--

INSERT INTO `[[dbprefix]]country_descriptions` VALUES
('AD', 'en', 'Andorra'),
('AE', 'en', 'United Arab Emirates'),
('AF', 'en', 'Afghanistan'),
('AG', 'en', 'Antigua and Barbuda'),
('AI', 'en', 'Anguilla'),
('AL', 'en', 'Albania'),
('AM', 'en', 'Armenia'),
('AO', 'en', 'Angola'),
('AQ', 'en', 'Antarctica'),
('AR', 'en', 'Argentina'),
('AS', 'en', 'American Samoa'),
('AT', 'en', 'Austria'),
('AU', 'en', 'Australia'),
('AW', 'en', 'Aruba'),
('AZ', 'en', 'Azerbaijan'),
('BA', 'en', 'Bosnia and Herzegovina'),
('BB', 'en', 'Barbados'),
('BD', 'en', 'Bangladesh'),
('BE', 'en', 'Belgium'),
('BF', 'en', 'Burkina Faso'),
('BG', 'en', 'Bulgaria'),
('BH', 'en', 'Bahrain'),
('BI', 'en', 'Burundi'),
('BJ', 'en', 'Benin'),
('BM', 'en', 'Bermuda'),
('BN', 'en', 'Brunei Darussalam'),
('BO', 'en', 'Bolivia'),
('BR', 'en', 'Brazil'),
('BS', 'en', 'Bahamas'),
('BT', 'en', 'Bhutan'),
('BV', 'en', 'Bouvet Island'),
('BW', 'en', 'Botswana'),
('BY', 'en', 'Belarus'),
('BZ', 'en', 'Belize'),
('CA', 'en', 'Canada'),
('CC', 'en', 'Cocos (Keeling) Islands'),
('CF', 'en', 'Central African Republic'),
('CG', 'en', 'Congo'),
('CH', 'en', 'Switzerland'),
('CI', 'en', 'Cote D''ivoire'),
('CK', 'en', 'Cook Islands'),
('CL', 'en', 'Chile'),
('CM', 'en', 'Cameroon'),
('CN', 'en', 'China'),
('CO', 'en', 'Colombia'),
('CR', 'en', 'Costa Rica'),
('CU', 'en', 'Cuba'),
('CV', 'en', 'Cape Verde'),
('CX', 'en', 'Christmas Island'),
('CY', 'en', 'Cyprus'),
('CZ', 'en', 'Czech Republic'),
('DE', 'en', 'Germany'),
('DJ', 'en', 'Djibouti'),
('DK', 'en', 'Denmark'),
('DM', 'en', 'Dominica'),
('DO', 'en', 'Dominican Republic'),
('DZ', 'en', 'Algeria'),
('EC', 'en', 'Ecuador'),
('EE', 'en', 'Estonia'),
('EG', 'en', 'Egypt'),
('EH', 'en', 'Western Sahara'),
('ER', 'en', 'Eritrea'),
('ES', 'en', 'Spain'),
('ET', 'en', 'Ethiopia'),
('FI', 'en', 'Finland'),
('FJ', 'en', 'Fiji'),
('FK', 'en', 'Falkland Islands (Malvinas)'),
('FM', 'en', 'Micronesia'),
('FO', 'en', 'Faroe Islands'),
('FR', 'en', 'France'),
('FX', 'en', 'France, Metropolitan'),
('GA', 'en', 'Gabon'),
('GB', 'en', 'United Kingdom (Great Britain)'),
('GD', 'en', 'Grenada'),
('GE', 'en', 'Georgia'),
('GF', 'en', 'French Guiana'),
('GH', 'en', 'Ghana'),
('GI', 'en', 'Gibraltar'),
('GL', 'en', 'Greenland'),
('GM', 'en', 'Gambia'),
('GN', 'en', 'Guinea'),
('GP', 'en', 'Guadeloupe'),
('GQ', 'en', 'Equatorial Guinea'),
('GR', 'en', 'Greece'),
('GT', 'en', 'Guatemala'),
('GU', 'en', 'Guam'),
('GW', 'en', 'Guinea-Bissau'),
('GY', 'en', 'Guyana'),
('HK', 'en', 'Hong Kong'),
('HM', 'en', 'Heard and McDonald Islands'),
('HN', 'en', 'Honduras'),
('HR', 'en', 'Croatia'),
('HT', 'en', 'Haiti'),
('HU', 'en', 'Hungary'),
('ID', 'en', 'Indonesia'),
('IE', 'en', 'Ireland'),
('IL', 'en', 'Israel'),
('IN', 'en', 'India'),
('IO', 'en', 'British Indian Ocean Territory'),
('IQ', 'en', 'Iraq'),
('IR', 'en', 'Islamic Republic of Iran'),
('IS', 'en', 'Iceland'),
('IT', 'en', 'Italy'),
('IM', 'en', 'Isle of Man'),
('JM', 'en', 'Jamaica'),
('JO', 'en', 'Jordan'),
('JP', 'en', 'Japan'),
('KE', 'en', 'Kenya'),
('KG', 'en', 'Kyrgyzstan'),
('KH', 'en', 'Cambodia'),
('KI', 'en', 'Kiribati'),
('KM', 'en', 'Comoros'),
('KN', 'en', 'St. Kitts and Nevis'),
('KP', 'en', 'Korea'),
('KR', 'en', 'Korea, Republic of'),
('KW', 'en', 'Kuwait'),
('KY', 'en', 'Cayman Islands'),
('KZ', 'en', 'Kazakhstan'),
('LA', 'en', 'Laos'),
('LB', 'en', 'Lebanon'),
('LC', 'en', 'Saint Lucia'),
('LI', 'en', 'Liechtenstein'),
('LK', 'en', 'Sri Lanka'),
('LR', 'en', 'Liberia'),
('LS', 'en', 'Lesotho'),
('LT', 'en', 'Lithuania'),
('LU', 'en', 'Luxembourg'),
('LV', 'en', 'Latvia'),
('LY', 'en', 'Libyan Arab Jamahiriya'),
('MA', 'en', 'Morocco'),
('MC', 'en', 'Monaco'),
('MD', 'en', 'Moldova, Republic of'),
('MG', 'en', 'Madagascar'),
('MH', 'en', 'Marshall Islands'),
('MK', 'en', 'Macedonia'),
('ML', 'en', 'Mali'),
('MM', 'en', 'Myanmar'),
('MN', 'en', 'Mongolia'),
('ME', 'en', 'Montenegro'),
('MO', 'en', 'Macau'),
('MP', 'en', 'Northern Mariana Islands'),
('MQ', 'en', 'Martinique'),
('MR', 'en', 'Mauritania'),
('MS', 'en', 'Montserrat'),
('MT', 'en', 'Malta'),
('MU', 'en', 'Mauritius'),
('MV', 'en', 'Maldives'),
('MW', 'en', 'Malawi'),
('MX', 'en', 'Mexico'),
('MY', 'en', 'Malaysia'),
('MZ', 'en', 'Mozambique'),
('NA', 'en', 'Namibia'),
('NC', 'en', 'New Caledonia'),
('NE', 'en', 'Niger'),
('NF', 'en', 'Norfolk Island'),
('NG', 'en', 'Nigeria'),
('NI', 'en', 'Nicaragua'),
('NL', 'en', 'Netherlands'),
('NO', 'en', 'Norway'),
('NP', 'en', 'Nepal'),
('NR', 'en', 'Nauru'),
('NU', 'en', 'Niue'),
('NZ', 'en', 'New Zealand'),
('OM', 'en', 'Oman'),
('PA', 'en', 'Panama'),
('PE', 'en', 'Peru'),
('PF', 'en', 'French Polynesia'),
('PG', 'en', 'Papua New Guinea'),
('PH', 'en', 'Philippines'),
('PK', 'en', 'Pakistan'),
('PL', 'en', 'Poland'),
('PM', 'en', 'St. Pierre and Miquelon'),
('PN', 'en', 'Pitcairn'),
('PR', 'en', 'Puerto Rico'),
('PS', 'en', 'Palestine Authority'),
('PT', 'en', 'Portugal'),
('PW', 'en', 'Palau'),
('PY', 'en', 'Paraguay'),
('QA', 'en', 'Qatar'),
('RE', 'en', 'Reunion'),
('RO', 'en', 'Romania'),
('RU', 'en', 'Russian Federation'),
('RW', 'en', 'Rwanda'),
('SA', 'en', 'Saudi Arabia'),
('CS', 'en', 'Serbia'),
('SB', 'en', 'Solomon Islands'),
('SC', 'en', 'Seychelles'),
('SD', 'en', 'Sudan'),
('SE', 'en', 'Sweden'),
('SG', 'en', 'Singapore'),
('SH', 'en', 'St. Helena'),
('SI', 'en', 'Slovenia'),
('SJ', 'en', 'Svalbard and Jan Mayen Islands'),
('SK', 'en', 'Slovakia'),
('SL', 'en', 'Sierra Leone'),
('SM', 'en', 'San Marino'),
('SN', 'en', 'Senegal'),
('SO', 'en', 'Somalia'),
('SR', 'en', 'Suriname'),
('ST', 'en', 'Sao Tome and Principe'),
('SV', 'en', 'El Salvador'),
('SY', 'en', 'Syrian Arab Republic'),
('SZ', 'en', 'Swaziland'),
('TC', 'en', 'Turks and Caicos Islands'),
('TD', 'en', 'Chad'),
('TF', 'en', 'French Southern Territories'),
('TG', 'en', 'Togo'),
('TH', 'en', 'Thailand'),
('TJ', 'en', 'Tajikistan'),
('TK', 'en', 'Tokelau'),
('TM', 'en', 'Turkmenistan'),
('TN', 'en', 'Tunisia'),
('TO', 'en', 'Tonga'),
('TL', 'en', 'East Timor'),
('TR', 'en', 'Turkey'),
('TT', 'en', 'Trinidad and Tobago'),
('TV', 'en', 'Tuvalu'),
('TW', 'en', 'Taiwan'),
('TZ', 'en', 'Tanzania, United Republic of'),
('UA', 'en', 'Ukraine'),
('UG', 'en', 'Uganda'),
('US', 'en', 'United States'),
('UY', 'en', 'Uruguay'),
('UZ', 'en', 'Uzbekistan'),
('VA', 'en', 'Vatican City State'),
('VC', 'en', 'St. Vincent and the Grenadines'),
('VE', 'en', 'Venezuela'),
('VG', 'en', 'British Virgin Islands'),
('VI', 'en', 'United States Virgin Islands'),
('VN', 'en', 'Viet Nam'),
('VU', 'en', 'Vanuatu'),
('WF', 'en', 'Wallis And Futuna Islands'),
('WS', 'en', 'Samoa'),
('YE', 'en', 'Yemen'),
('YT', 'en', 'Mayotte'),
('ZA', 'en', 'South Africa'),
('ZM', 'en', 'Zambia'),
('ZR', 'en', 'Zaire'),
('ZW', 'en', 'Zimbabwe'),
('CD', 'en', 'Democratic Republic of Congo'),
('AP', 'en', 'Asia-Pacific'),
('RS', 'en', 'Republic of Serbia'),
('AX', 'en', 'Aland Islands'),
('EU', 'en', 'Europe'),
('GG', 'en', 'Guernsey'),
('JE', 'en', 'Jersey'),
('CW', 'en', 'Curaçao'),
('SX', 'en', 'Sint Maarten');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]currencies`
--

CREATE TABLE `[[dbprefix]]currencies` (
  `currency_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `currency_code` varchar(10) NOT NULL DEFAULT '',
  `after` char(1) NOT NULL DEFAULT 'N',
  `symbol` tinytext,
  `coefficient` double(12,5) NOT NULL DEFAULT '1.00000',
  `is_primary` char(1) NOT NULL DEFAULT 'N',
  `position` smallint(5) NOT NULL,
  `decimals_separator` varchar(6) NOT NULL DEFAULT '.',
  `thousands_separator` varchar(6) NOT NULL DEFAULT ',',
  `decimals` smallint(5) NOT NULL DEFAULT '2',
  `status` char(1) NOT NULL DEFAULT 'A',
  PRIMARY KEY (`currency_id`),
  UNIQUE KEY `currency_code` (`currency_code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]currencies`
--

INSERT INTO `[[dbprefix]]currencies` VALUES
(1, 'USD', 'N', '$', 1.00000, 'Y', 10, '.', ',', 2, 'A'),
(2, 'EUR', 'N', '€', 1.28000, 'N', 20, '.', ',', 2, 'A'),
(3, 'GBP', 'N', '£', 1.88000, 'N', 30, '.', ',', 2, 'A');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]currency_descriptions`
--

CREATE TABLE `[[dbprefix]]currency_descriptions` (
  `currency_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `description` varchar(255) NOT NULL DEFAULT '',
  `lang_code` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`currency_id`,`lang_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]currency_descriptions`
--

INSERT INTO `[[dbprefix]]currency_descriptions` VALUES
(1, 'US Dollars', 'en'),
(2, 'Euro', 'en'),
(3, 'GB Pound', 'en');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]custom_blocks`
--

CREATE TABLE `[[dbprefix]]custom_blocks` (
  `block_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `status` char(1) NOT NULL DEFAULT 'A',
  `section` char(1) DEFAULT NULL,
  `type` char(1) NOT NULL DEFAULT 'B',
  `area` char(1) NOT NULL DEFAULT 'V',
  `position` smallint(5) unsigned NOT NULL DEFAULT '0',
  `storefront_id` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`block_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]custom_blocks_content`
--

CREATE TABLE `[[dbprefix]]custom_blocks_content` (
  `block_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `lang_code` char(2) NOT NULL DEFAULT '',
  `content` text,
  PRIMARY KEY (`block_id`,`lang_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]custom_menu`
--

CREATE TABLE `[[dbprefix]]custom_menu` (
  `item_id` varchar(64) NOT NULL DEFAULT '',
  `href` varchar(255) NOT NULL DEFAULT '',
  `alt` varchar(255) NOT NULL DEFAULT '',
  `new_window` char(1) NOT NULL DEFAULT 'N',
  `status` char(1) NOT NULL DEFAULT 'A',
  `location` varchar(255) NOT NULL DEFAULT 'central',
  `area` char(1) NOT NULL DEFAULT 'V',
  `position` smallint(5) NOT NULL DEFAULT '0',
  `parent_id` varchar(64) NOT NULL DEFAULT '0',
  `id_path` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`item_id`,`id_path`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]custom_menu_descriptions`
--

CREATE TABLE `[[dbprefix]]custom_menu_descriptions` (
  `item_id` varchar(64) NOT NULL DEFAULT '',
  `id_path` varchar(255) NOT NULL DEFAULT '',
  `lang_code` char(2) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`item_id`,`id_path`,`lang_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]data_feeds`
--

CREATE TABLE `[[dbprefix]]data_feeds` (
  `datafeed_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(11) unsigned NOT NULL DEFAULT '0',
  `categories` text,
  `products` text,
  `fields` text,
  `export_location` char(1) NOT NULL DEFAULT 'L',
  `export_by_cron` char(1) NOT NULL DEFAULT 'N',
  `ftp_url` varchar(255) NOT NULL DEFAULT '',
  `ftp_user` varchar(50) NOT NULL DEFAULT '',
  `ftp_pass` varchar(50) NOT NULL DEFAULT '',
  `file_name` varchar(50) NOT NULL DEFAULT '',
  `enclosure` char(1) NOT NULL DEFAULT '',
  `csv_delimiter` char(1) NOT NULL DEFAULT '',
  `exclude_disabled_products` char(1) NOT NULL DEFAULT 'N',
  `exclude_shared_products` char(1) NOT NULL DEFAULT 'N',
  `export_options` text,
  `save_dir` varchar(255) NOT NULL DEFAULT '',
  `status` char(1) NOT NULL DEFAULT '',
  `layout_id` int(11) unsigned NOT NULL DEFAULT '0',
  `params` text,
  PRIMARY KEY (`datafeed_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]data_feed_descriptions`
--

CREATE TABLE `[[dbprefix]]data_feed_descriptions` (
  `datafeed_id` int(11) unsigned NOT NULL DEFAULT '0',
  `datafeed_name` varchar(255) NOT NULL DEFAULT '',
  `lang_code` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`datafeed_id`,`lang_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]destinations`
--

CREATE TABLE `[[dbprefix]]destinations` (
  `destination_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `localization` varchar(255) NOT NULL DEFAULT '',
  `status` char(1) NOT NULL DEFAULT 'A',
  PRIMARY KEY (`destination_id`),
  KEY `localization` (`localization`),
  KEY `c_status` (`destination_id`,`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]destinations`
--

INSERT INTO `[[dbprefix]]destinations` VALUES
(1, '', 'A'),
(7, '', 'A'),
(8, '', 'A');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]destination_descriptions`
--

CREATE TABLE `[[dbprefix]]destination_descriptions` (
  `destination_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `lang_code` char(2) NOT NULL DEFAULT '',
  `destination` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`destination_id`,`lang_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]destination_descriptions`
--

INSERT INTO `[[dbprefix]]destination_descriptions` VALUES
(7, 'en', 'USA'),
(8, 'en', 'Canada'),
(1, 'en', 'Default rate area (all countries)');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]destination_elements`
--

CREATE TABLE `[[dbprefix]]destination_elements` (
  `element_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `destination_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `element` varchar(255) NOT NULL DEFAULT '',
  `element_type` char(1) NOT NULL DEFAULT 'S',
  PRIMARY KEY (`element_id`),
  KEY `c_status` (`destination_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=355 ;

--
-- Dumping data for table `[[dbprefix]]destination_elements`
--

INSERT INTO `[[dbprefix]]destination_elements` VALUES
(59, 7, '13', 'S'),
(60, 7, '12', 'S'),
(61, 7, '11', 'S'),
(62, 7, '10', 'S'),
(63, 7, '15', 'S'),
(64, 7, '16', 'S'),
(65, 7, '17', 'S'),
(66, 7, '18', 'S'),
(67, 7, '19', 'S'),
(68, 7, '20', 'S'),
(69, 7, '21', 'S'),
(70, 7, '22', 'S'),
(71, 7, '23', 'S'),
(72, 7, '24', 'S'),
(73, 7, '25', 'S'),
(74, 7, '26', 'S'),
(75, 7, '27', 'S'),
(76, 7, '28', 'S'),
(77, 7, '29', 'S'),
(78, 7, '30', 'S'),
(79, 7, '31', 'S'),
(80, 7, '32', 'S'),
(81, 7, '33', 'S'),
(82, 7, '34', 'S'),
(83, 7, '35', 'S'),
(84, 7, '36', 'S'),
(85, 7, '37', 'S'),
(86, 7, '38', 'S'),
(87, 7, '39', 'S'),
(88, 7, '40', 'S'),
(89, 7, '41', 'S'),
(90, 7, '42', 'S'),
(91, 7, '43', 'S'),
(92, 7, '44', 'S'),
(93, 7, '45', 'S'),
(94, 7, '46', 'S'),
(95, 7, '47', 'S'),
(96, 7, '48', 'S'),
(97, 7, '49', 'S'),
(98, 7, '50', 'S'),
(99, 7, '51', 'S'),
(100, 7, '52', 'S'),
(101, 7, '53', 'S'),
(102, 7, '54', 'S'),
(103, 7, '55', 'S'),
(104, 7, '56', 'S'),
(105, 7, '57', 'S'),
(106, 7, '58', 'S'),
(107, 7, '59', 'S'),
(108, 7, '60', 'S'),
(109, 7, '61', 'S'),
(110, 7, '62', 'S'),
(111, 7, '63', 'S'),
(112, 7, '64', 'S'),
(113, 7, 'US', 'C'),
(114, 1, 'AF', 'C'),
(115, 1, 'AL', 'C'),
(116, 1, 'DZ', 'C'),
(117, 1, 'AS', 'C'),
(118, 1, 'AD', 'C'),
(119, 1, 'AO', 'C'),
(120, 1, 'AI', 'C'),
(121, 1, 'AQ', 'C'),
(122, 1, 'AG', 'C'),
(123, 1, 'AR', 'C'),
(124, 1, 'AM', 'C'),
(125, 1, 'AW', 'C'),
(126, 1, 'AU', 'C'),
(127, 1, 'AT', 'C'),
(128, 1, 'AZ', 'C'),
(129, 1, 'BS', 'C'),
(130, 1, 'BH', 'C'),
(131, 1, 'BD', 'C'),
(132, 1, 'BB', 'C'),
(133, 1, 'BY', 'C'),
(134, 1, 'BE', 'C'),
(135, 1, 'BZ', 'C'),
(136, 1, 'BJ', 'C'),
(137, 1, 'BM', 'C'),
(138, 1, 'BT', 'C'),
(139, 1, 'BO', 'C'),
(140, 1, 'BA', 'C'),
(141, 1, 'BW', 'C'),
(142, 1, 'BV', 'C'),
(143, 1, 'BR', 'C'),
(144, 1, 'IO', 'C'),
(145, 1, 'VG', 'C'),
(146, 1, 'BN', 'C'),
(147, 1, 'BG', 'C'),
(148, 1, 'BF', 'C'),
(149, 1, 'BI', 'C'),
(150, 1, 'KH', 'C'),
(151, 1, 'CM', 'C'),
(152, 1, 'CA', 'C'),
(153, 1, 'CV', 'C'),
(154, 1, 'KY', 'C'),
(155, 1, 'CF', 'C'),
(156, 1, 'TD', 'C'),
(157, 1, 'CL', 'C'),
(158, 1, 'CN', 'C'),
(159, 1, 'CX', 'C'),
(160, 1, 'CC', 'C'),
(161, 1, 'CO', 'C'),
(162, 1, 'KM', 'C'),
(163, 1, 'CG', 'C'),
(164, 1, 'CK', 'C'),
(165, 1, 'CR', 'C'),
(166, 1, 'CI', 'C'),
(167, 1, 'HR', 'C'),
(168, 1, 'CU', 'C'),
(169, 1, 'CY', 'C'),
(170, 1, 'CZ', 'C'),
(171, 1, 'DK', 'C'),
(172, 1, 'DJ', 'C'),
(173, 1, 'DM', 'C'),
(174, 1, 'DO', 'C'),
(175, 1, 'TP', 'C'),
(176, 1, 'EC', 'C'),
(177, 1, 'EG', 'C'),
(178, 1, 'SV', 'C'),
(179, 1, 'GQ', 'C'),
(180, 1, 'ER', 'C'),
(181, 1, 'EE', 'C'),
(182, 1, 'ET', 'C'),
(183, 1, 'FK', 'C'),
(184, 1, 'FO', 'C'),
(185, 1, 'FJ', 'C'),
(186, 1, 'FI', 'C'),
(187, 1, 'FR', 'C'),
(188, 1, 'FX', 'C'),
(189, 1, 'GF', 'C'),
(190, 1, 'PF', 'C'),
(191, 1, 'TF', 'C'),
(192, 1, 'GA', 'C'),
(193, 1, 'GM', 'C'),
(194, 1, 'GE', 'C'),
(195, 1, 'DE', 'C'),
(196, 1, 'GH', 'C'),
(197, 1, 'GI', 'C'),
(198, 1, 'GR', 'C'),
(199, 1, 'GL', 'C'),
(200, 1, 'GD', 'C'),
(201, 1, 'GP', 'C'),
(202, 1, 'GU', 'C'),
(203, 1, 'GT', 'C'),
(204, 1, 'GN', 'C'),
(205, 1, 'GW', 'C'),
(206, 1, 'GY', 'C'),
(207, 1, 'HT', 'C'),
(208, 1, 'HM', 'C'),
(209, 1, 'HN', 'C'),
(210, 1, 'HK', 'C'),
(211, 1, 'HU', 'C'),
(212, 1, 'IS', 'C'),
(213, 1, 'IN', 'C'),
(214, 1, 'ID', 'C'),
(215, 1, 'IQ', 'C'),
(216, 1, 'IE', 'C'),
(217, 1, 'IR', 'C'),
(218, 1, 'IL', 'C'),
(219, 1, 'IT', 'C'),
(220, 1, 'JM', 'C'),
(221, 1, 'JP', 'C'),
(222, 1, 'JO', 'C'),
(223, 1, 'KZ', 'C'),
(224, 1, 'KE', 'C'),
(225, 1, 'KI', 'C'),
(226, 1, 'KP', 'C'),
(227, 1, 'KR', 'C'),
(228, 1, 'KW', 'C'),
(229, 1, 'KG', 'C'),
(230, 1, 'LA', 'C'),
(231, 1, 'LV', 'C'),
(232, 1, 'LB', 'C'),
(233, 1, 'LS', 'C'),
(234, 1, 'LR', 'C'),
(235, 1, 'LY', 'C'),
(236, 1, 'LI', 'C'),
(237, 1, 'LT', 'C'),
(238, 1, 'LU', 'C'),
(239, 1, 'MO', 'C'),
(240, 1, 'MK', 'C'),
(241, 1, 'MG', 'C'),
(242, 1, 'MW', 'C'),
(243, 1, 'MY', 'C'),
(244, 1, 'MV', 'C'),
(245, 1, 'ML', 'C'),
(246, 1, 'MT', 'C'),
(247, 1, 'MH', 'C'),
(248, 1, 'MQ', 'C'),
(249, 1, 'MR', 'C'),
(250, 1, 'MU', 'C'),
(251, 1, 'YT', 'C'),
(252, 1, 'MX', 'C'),
(253, 1, 'FM', 'C'),
(254, 1, 'MD', 'C'),
(255, 1, 'MC', 'C'),
(256, 1, 'MN', 'C'),
(257, 1, 'MS', 'C'),
(258, 1, 'MA', 'C'),
(259, 1, 'MZ', 'C'),
(260, 1, 'MM', 'C'),
(261, 1, 'NA', 'C'),
(262, 1, 'NR', 'C'),
(263, 1, 'NP', 'C'),
(264, 1, 'NL', 'C'),
(266, 1, 'NC', 'C'),
(267, 1, 'NZ', 'C'),
(268, 1, 'NI', 'C'),
(269, 1, 'NE', 'C'),
(270, 1, 'NG', 'C'),
(271, 1, 'NU', 'C'),
(272, 1, 'NF', 'C'),
(273, 1, 'MP', 'C'),
(274, 1, 'NO', 'C'),
(275, 1, 'OM', 'C'),
(276, 1, 'PK', 'C'),
(277, 1, 'PW', 'C'),
(278, 1, 'PA', 'C'),
(279, 1, 'PG', 'C'),
(280, 1, 'PY', 'C'),
(281, 1, 'PE', 'C'),
(282, 1, 'PH', 'C'),
(283, 1, 'PN', 'C'),
(284, 1, 'PL', 'C'),
(285, 1, 'PT', 'C'),
(286, 1, 'PR', 'C'),
(287, 1, 'QA', 'C'),
(288, 1, 'RE', 'C'),
(289, 1, 'RO', 'C'),
(290, 1, 'RU', 'C'),
(291, 1, 'RW', 'C'),
(292, 1, 'LC', 'C'),
(293, 1, 'WS', 'C'),
(294, 1, 'SM', 'C'),
(295, 1, 'ST', 'C'),
(296, 1, 'SA', 'C'),
(297, 1, 'SN', 'C'),
(298, 1, 'SC', 'C'),
(299, 1, 'SL', 'C'),
(300, 1, 'SG', 'C'),
(301, 1, 'SK', 'C'),
(302, 1, 'SI', 'C'),
(303, 1, 'SB', 'C'),
(304, 1, 'SO', 'C'),
(305, 1, 'ZA', 'C'),
(306, 1, 'ES', 'C'),
(307, 1, 'LK', 'C'),
(308, 1, 'SH', 'C'),
(309, 1, 'KN', 'C'),
(310, 1, 'PM', 'C'),
(311, 1, 'VC', 'C'),
(312, 1, 'SD', 'C'),
(313, 1, 'SR', 'C'),
(314, 1, 'SJ', 'C'),
(315, 1, 'SZ', 'C'),
(316, 1, 'SE', 'C'),
(317, 1, 'CH', 'C'),
(318, 1, 'SY', 'C'),
(319, 1, 'TW', 'C'),
(320, 1, 'TJ', 'C'),
(321, 1, 'TZ', 'C'),
(322, 1, 'TH', 'C'),
(323, 1, 'TG', 'C'),
(324, 1, 'TK', 'C'),
(325, 1, 'TO', 'C'),
(326, 1, 'TT', 'C'),
(327, 1, 'TN', 'C'),
(328, 1, 'TR', 'C'),
(329, 1, 'TM', 'C'),
(330, 1, 'TC', 'C'),
(331, 1, 'TV', 'C'),
(332, 1, 'UG', 'C'),
(333, 1, 'UA', 'C'),
(334, 1, 'AE', 'C'),
(335, 1, 'GB', 'C'),
(336, 1, 'US', 'C'),
(337, 1, 'VI', 'C'),
(338, 1, 'UY', 'C'),
(339, 1, 'UZ', 'C'),
(340, 1, 'VU', 'C'),
(341, 1, 'VA', 'C'),
(342, 1, 'VE', 'C'),
(343, 1, 'VN', 'C'),
(344, 1, 'WF', 'C'),
(345, 1, 'EH', 'C'),
(346, 1, 'YE', 'C'),
(347, 1, 'YU', 'C'),
(348, 1, 'ZR', 'C'),
(349, 1, 'ZM', 'C'),
(350, 1, 'ZW', 'C'),
(351, 8, 'CA', 'C'),
(352, 1, 'IM', 'C'),
(353, 1, 'CW', 'C'),
(354, 1, 'SX', 'C');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]discussion`
--

CREATE TABLE `[[dbprefix]]discussion` (
  `thread_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `object_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `object_type` char(1) NOT NULL DEFAULT '',
  `type` char(1) NOT NULL DEFAULT 'D',
  `company_id` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`thread_id`),
  UNIQUE KEY `object_id` (`object_id`,`object_type`,`company_id`),
  KEY `idx_company_id` (`company_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=27 ;

--
-- Dumping data for table `[[dbprefix]]discussion`
--

INSERT INTO `[[dbprefix]]discussion` VALUES
(1, 228, 'P', 'B', 1),
(2, 242, 'P', 'B', 1),
(3, 78, 'P', 'B', 1),
(4, 16, 'P', 'B', 1),
(5, 170, 'P', 'B', 1),
(7, 1, 'A', 'D', 1),
(8, 2, 'A', 'D', 1),
(9, 3, 'A', 'D', 1),
(11, 167, 'C', 'D', 1),
(16, 243, 'P', 'D', 1),
(17, 224, 'P', 'B', 1),
(18, 5, 'P', 'B', 1),
(19, 1, 'P', 'B', 1),
(20, 23, 'P', 'B', 1),
(21, 8, 'P', 'B', 1),
(22, 172, 'P', 'B', 1),
(23, 238, 'P', 'B', 1),
(24, 167, 'P', 'B', 1),
(25, 239, 'P', 'B', 1),
(26, 0, 'E', 'B', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]discussion_messages`
--

CREATE TABLE `[[dbprefix]]discussion_messages` (
  `message` mediumtext,
  `post_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `thread_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`post_id`),
  KEY `thread_id` (`thread_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]discussion_messages`
--

INSERT INTO `[[dbprefix]]discussion_messages` VALUES
('I first noticed this monitor at one of those computer stores where they place all the monitors on the same shelf. This one really stood out for color and very sharp focus. I watch movies and play some games and I haven''t noticed any ghosting. The only thing that I wish I could do is rotate the screen for word processing (kind of a minor complaint). Otherwise this is a very good monitor and the price is good for a 3D LCD. ', 1, 1),
('This monitor is way too light (everything appears faded out), and adjusting the contrast and brightness controls don''t help. No matter what brightness contrast setting is used, everything is either way too dim & gray or way too light. The monitor''s brightness & contrast controls seem to have the exact same function - contrast setting appears to actually be adjusting the brightness and nothing seems to be actually changing the contrast. This will probably be returned soon, unless someone can tell me how to get the correct brightness/contrast setting. ', 2, 1),
('Just a perfect product!', 3, 2),
('I do not like. \n\nAt all.', 4, 2),
('Beautiful boots.\n\nMy opinion is they are just best.', 5, 3),
('I got the Galaxy Tab over on Friday from a local BestBuy apparent they are not suppose to sell it until Monday. The screen has very wide viewing angle, I looked at the Ipad2 before I looked at the Galaxy Tab, and I couldn''t tell the difference based on memory, but I''m sure Galaxy Tab is better. Though the screen is better than the Xoom which I also own.', 8, 17),
('We don''t get much of a choice here in Russia, really only the Iconia, Xoom & the Samsung Galaxy, so far this Iconia is my favourite.', 9, 17),
('I am extremely satisfied with this LCD TV. I have searched for and read all I could about the flat screen TVS. I am so impressed with the picture and sound quality, even though some of the reviews I read did not give this model the best reviews on sound quality and volume. All in all, the benefits for me are: Built-in speakers, Bright display, Durable, Realistic color, Lightweight, can be carried by one person. Would definitely recommend this to my friends. ', 10, 18),
('Absolutely enjoy this TV. The colors are amazing: the depth, the balance and everything else is just top notch! I can plug in my hard drive and watch videos instantly! I am still amazed at the clarity from all the angles. Just getting into Blue-ray capabilities now. Although the price is relatively high, I can truly say that it''s a stunning piece of technological craftsmanship. ', 11, 19),
(' Purchased this for my home theater. I am a bit wary when it comes to 5.1 Channel systems, but decided to give it a try. The sound is nice, although the mid-range could have been a bit clearer. The system definitely lacks the low frequencies, so I am currently in search for a good sub-woofer. The high frequencies are crystal clear, though, and the surround sound simply blows you away. I wouldn''t recommend this to everyone, but it definitely is quite a good product in its segment, although not perfect. ', 12, 20),
('Good picture quality for a LED-based LCD, with relatively deep levels in dark scenes, as well as good white balance in the bright ones. It includes built-in Wi-Fi, 3D with a pair of glasses, and many other cool features.  Overall it''s quite good, although the picture sometimes loses fidelity from off-angle in dark scenes. ', 13, 21),
('I was looking for a handy and easy-to-use camcorder when I came across this little bird, and I have to say — it really does everything perfectly! Whether you just want to catch some memory in a form of a video, or plan to do a full video project — this camcorder will become your best friend! All the necessary features are present and easily adjustable. I didn''t come across any problem using this amazing piece of technology. Definitely worth its money! ', 14, 22),
('A good and reliable phone is a necessity for a person like me, that''s why I decided to choose iPhone. Apple is a remarkable company, and it is always at pace with time, forward-thinking and innovative. The iPhone is clear-cut, easy-to-use and definitely the most stylish phone on the market now. I enjoy it, although I sometimes experience troubles with software & maintenance, and there phone is literally crammed with a lot of features I never use. I would recommend this mostly to younger generation, whereas people of my age might find it a bit bewildering at first. ', 15, 23),
('I was hesitant to choose between Nikon and Canon at first, but when I had a chance to compare the 2 similar models of the 2 competing giants, I chose Nikon. It just feels right, you know. The colors, the matrix, the interface — everything about this product is just beyond expectations! I''ve already made a portfolio with the help of it. Simply perfect! ', 16, 24),
('I’ve been using an iPhone 5 daily for the past year, and the iPhone 5s seems to feel exactly the same: the same curved edges, same dimensions, same everything. It''s only an updated Home button and the new camera flash which make you realize that this is not an iPhone 5.  Many people think that releasing the same design twice is bad, and there are others who realize that sometimes there''s no need for change. Apple might want to understand that the competition is strong, and it needs to stay relevant. ', 17, 25),
('You guys have the BEST customer service known to man!!! I have always been impressed with how fast you help us out!', 18, 26),
('You''re the best! Thank you most graciously and appreciatively!', 19, 26);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]discussion_posts`
--

CREATE TABLE `[[dbprefix]]discussion_posts` (
  `post_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `thread_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(128) NOT NULL DEFAULT '',
  `timestamp` int(11) unsigned NOT NULL DEFAULT '0',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `ip_address` varbinary(40) NOT NULL DEFAULT '',
  `status` char(1) NOT NULL DEFAULT 'D',
  PRIMARY KEY (`post_id`),
  KEY `thread_id` (`thread_id`,`ip_address`),
  KEY `thread_id_2` (`thread_id`,`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=20 ;

--
-- Dumping data for table `[[dbprefix]]discussion_posts`
--

INSERT INTO `[[dbprefix]]discussion_posts` VALUES
(1, 1, 'Customer Customer', 1129547428, 3, '192.168.0.2', 'A'),
(2, 1, 'A PC Hardware Fan', 1129559367, 0, '192.168.0.2', 'A'),
(3, 2, 'Admin Admin', 1129558427, 1, '192.168.0.2', 'A'),
(4, 2, 'Guest', 1129558457, 0, '192.168.0.2', 'A'),
(5, 3, 'Customer Customer', 1129559626, 3, '192.168.0.2', 'A'),
(8, 17, 'John', 1311063983, 0, '127.0.0.1', 'A'),
(9, 17, 'Michael', 1311079049, 0, '127.0.0.1', 'A'),
(10, 18, 'David', 1383914308, 0, '10.7.7.93', 'A'),
(11, 19, 'Brian', 1383914367, 0, '10.7.7.93', 'A'),
(12, 20, 'Sophie', 1383914425, 0, '10.7.7.93', 'A'),
(13, 21, 'Jeniffer', 1383914502, 0, '10.7.7.93', 'A'),
(14, 22, 'Alex', 1383914559, 0, '10.7.7.93', 'A'),
(15, 23, 'George', 1383914632, 0, '10.7.7.93', 'A'),
(16, 24, 'Melissa', 1383914678, 0, '10.7.7.93', 'A'),
(17, 25, 'John', 1383914729, 0, '10.7.7.93', 'A'),
(18, 26, 'Alex', 1383914729, 0, '10.7.7.93', 'A'),
(19, 26, 'Michael', 1383914678, 0, '10.7.7.93', 'A');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]discussion_rating`
--

CREATE TABLE `[[dbprefix]]discussion_rating` (
  `rating_value` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `post_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `thread_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`post_id`),
  KEY `thread_id` (`thread_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]discussion_rating`
--

INSERT INTO `[[dbprefix]]discussion_rating` VALUES
(4, 1, 1),
(2, 2, 1),
(5, 3, 2),
(2, 4, 2),
(4, 5, 3),
(4, 8, 17),
(5, 9, 17),
(4, 10, 18),
(4, 11, 19),
(3, 12, 20),
(4, 13, 21),
(4, 14, 22),
(4, 15, 23),
(5, 16, 24),
(3, 17, 25),
(4, 18, 26),
(5, 19, 26);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ekeys`
--

CREATE TABLE `[[dbprefix]]ekeys` (
  `object_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `object_string` varchar(128) NOT NULL DEFAULT '',
  `object_type` char(1) NOT NULL DEFAULT 'R',
  `ekey` varchar(255) NOT NULL DEFAULT '',
  `ttl` int(11) unsigned NOT NULL DEFAULT '0',
  `data` text,
  PRIMARY KEY (`object_id`,`object_type`,`ekey`(64)),
  UNIQUE KEY `object_string` (`object_string`,`object_type`,`ekey`(64)),
  KEY `c_status` (`ekey`(64),`object_type`,`ttl`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]em_mailchimp_webhooks`
--

CREATE TABLE `[[dbprefix]]em_mailchimp_webhooks` (
  `webhook_id` varchar(128) NOT NULL DEFAULT '',
  `list_id` varchar(128) NOT NULL DEFAULT '',
  PRIMARY KEY (`webhook_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]em_subscribers`
--

CREATE TABLE `[[dbprefix]]em_subscribers` (
  `subscriber_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(128) NOT NULL DEFAULT '',
  `name` varchar(128) NOT NULL DEFAULT '',
  `timestamp` int(11) unsigned NOT NULL DEFAULT '0',
  `ip_address` varbinary(40) NOT NULL DEFAULT '',
  `lang_code` char(2) NOT NULL DEFAULT '',
  `status` char(1) NOT NULL DEFAULT 'A',
  `unsubscribe_key` varchar(32) NOT NULL DEFAULT '',
  `company_id` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`subscriber_id`),
  UNIQUE KEY `email` (`email`,`company_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]exim_layouts`
--

CREATE TABLE `[[dbprefix]]exim_layouts` (
  `layout_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL DEFAULT '',
  `cols` text,
  `options` text,
  `pattern_id` varchar(128) NOT NULL DEFAULT '',
  `active` char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`layout_id`),
  KEY `pattern_id` (`pattern_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=30 ;

--
-- Dumping data for table `[[dbprefix]]exim_layouts`
--

INSERT INTO `[[dbprefix]]exim_layouts` VALUES
(18, 'general', 'Product code,Language,Product id,Category,List price,Price,Weight,Available,Quantity,Min quantity,Shipping freight,Date added,Downloadable,Files,Ship downloadable,Inventory tracking,Free shipping,Feature comparison,Zero price action,Thumbnail,Detailed image,Product name,Description,Meta keywords,Meta description,Search words,Page title,Taxes,Features,Options,Secondary categories,Pay by points,Override points,Override exchange rate,Supplier,SEO name,Short description,Localizations,Status,Popularity', NULL, 'products', 'Y'),
(17, 'general', 'Product code,Pair type,Thumbnail,Detailed image', NULL, 'product_images', 'Y'),
(7, 'general', 'Product code,Language,Price,Lower limit,User group,Percentage discount', NULL, 'qty_discounts', 'Y'),
(15, 'general', 'id,product_type,quantity,price,upc,title,description,link,image_link,brand,condition,weight', NULL, 'google', 'Y'),
(19, 'general', 'E-mail,User type,Active,User group ID,Password,Salt,Title,First name,Last name,Company,Fax,Phone,Web site,Tax exempt,Language,Billing: title,Billing: first name,Billing: last name,Billing: address,Billing: address (line 2),Billing: city,Billing: state,Billing: country,Billing: zipcode,Shipping: title,Shipping: first name,Shipping: last name,Shipping: address,Shipping: address (line 2),Shipping: city,Shipping: state,Shipping: country,Shipping: zipcode,Extra fields', NULL, 'users', 'Y'),
(22, 'general', 'Order ID,E-mail,Store,User ID,Total,Subtotal,Discount,Subtotal discount,Payment surcharge,Shipping cost,Date,Status,Notes,Payment ID,IP address,Details,Payment information,Taxes,Coupons,Shipping,First name,Last name,Company,Fax,Phone,Web site,Tax exempt,Language,Billing: first name,Billing: last name,Billing: address,Billing: address (line 2),Billing: city,Billing: state,Billing: country,Billing: zipcode,Shipping: first name,Shipping: last name,Shipping: address,Shipping: address (line 2),Shipping: city,Shipping: state,Shipping: country,Shipping: zipcode', NULL, 'orders', 'Y'),
(20, 'general', 'Order ID,Item ID,Product ID,Product code,Price,Quantity,Supplier,Extra', NULL, 'order_items', 'Y'),
(21, 'general', 'Name,Value,Language', NULL, 'language_variables', 'Y'),
(23, 'general', 'State,Code,Country code', NULL, 'states', 'Y'),
(25, 'general', 'Feature name,Feature ID,Language,Type,Purpose,Feature style,Filter style,Group,Description,Categories,Show on the features tab,Show in product list,Show in product header,Position,Status,Store,Storefront name', NULL, 'features', 'Y'),
(26, 'general', 'Variant,Variant ID,Language,Feature name,Feature group,Position', NULL, 'feature_variants', 'Y'),
(27, 'general', 'Product ID,Language,Combination', NULL, 'option_exceptions', 'Y'),
(28, 'general', 'Pickup ID,Language,Latitude,Longitude,Country,Name,City', NULL, 'pickup', 'Y'),
(29, 'general_data_feeds', 'Product code,Language,Product id,Category,List price,Price,Weight,Available,Quantity,Min quantity,Shipping freight,Date added,Downloadable,Files,Ship downloadable,Inventory tracking,Free shipping,Feature comparison,Zero price action,Thumbnail,Detailed image,Product name,Description,Meta keywords,Meta description,Search words,Page title,Taxes,Features,Options,Secondary categories,Pay by points,Override points,Override exchange rate,Supplier,SEO name,Short description,Localizations,Status,Popularity', NULL, 'data_feeds', 'Y');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]form_descriptions`
--

CREATE TABLE `[[dbprefix]]form_descriptions` (
  `object_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `description` text,
  `lang_code` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`object_id`,`lang_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]form_descriptions`
--

INSERT INTO `[[dbprefix]]form_descriptions` VALUES
(1, 'Full name', 'en'),
(2, 'Email', 'en'),
(3, 'Body', 'en'),
(4, 'Thank you for contacting us. We''ll answer you at first opportunity.', 'en'),
(7, 'Subject', 'en'),
(9, '', 'en');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]form_options`
--

CREATE TABLE `[[dbprefix]]form_options` (
  `element_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `page_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `element_type` char(1) NOT NULL DEFAULT 'I',
  `value` varchar(255) NOT NULL DEFAULT '',
  `position` smallint(5) unsigned NOT NULL DEFAULT '0',
  `required` char(1) NOT NULL DEFAULT 'N',
  `status` char(1) NOT NULL DEFAULT 'A',
  PRIMARY KEY (`element_id`),
  KEY `page_id` (`page_id`,`status`),
  KEY `position` (`position`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]form_options`
--

INSERT INTO `[[dbprefix]]form_options` VALUES
(1, 30, 0, 'I', '', 3, 'Y', 'A'),
(2, 30, 0, 'Y', '', 1, 'Y', 'A'),
(3, 30, 0, 'T', '', 20, 'Y', 'A'),
(4, 30, 0, 'L', '', 0, 'N', 'A'),
(5, 30, 0, 'J', '[[admin_email]]', 0, 'N', 'A'),
(6, 30, 0, 'U', 'N', 0, 'N', 'A'),
(7, 30, 0, 'I', 'N', 4, 'Y', 'A'),
(8, 30, 0, 'E', '7', 0, 'N', 'A'),
(9, 30, 0, 'K', '', 0, 'N', 'A');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gdpr_user_agreements`
--

CREATE TABLE `[[dbprefix]]gdpr_user_agreements` (
  `agreement_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` mediumint(8) unsigned DEFAULT '0',
  `email` varchar(128) DEFAULT '',
  `type` varchar(128) DEFAULT '',
  `timestamp` int(11) unsigned DEFAULT '0',
  `agreement` text,
  PRIMARY KEY (`agreement_id`),
  KEY `idx_user_id_email` (`user_id`,`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gdpr_user_data`
--

CREATE TABLE `[[dbprefix]]gdpr_user_data` (
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `anonymized` char(1) DEFAULT 'N',
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gift_certificates`
--

CREATE TABLE `[[dbprefix]]gift_certificates` (
  `gift_cert_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(11) unsigned NOT NULL DEFAULT '0',
  `gift_cert_code` varchar(255) NOT NULL DEFAULT '',
  `sender` varchar(64) NOT NULL DEFAULT '',
  `recipient` varchar(64) NOT NULL DEFAULT '',
  `send_via` char(1) NOT NULL DEFAULT 'E',
  `amount` decimal(12,2) NOT NULL DEFAULT '0.00',
  `email` varchar(64) NOT NULL DEFAULT '',
  `address` varchar(255) NOT NULL DEFAULT '',
  `address_2` varchar(255) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `state` varchar(32) NOT NULL DEFAULT '',
  `country` char(2) NOT NULL DEFAULT '',
  `zipcode` varchar(10) NOT NULL DEFAULT '',
  `status` char(1) NOT NULL DEFAULT 'P',
  `timestamp` int(11) unsigned NOT NULL DEFAULT '0',
  `phone` varchar(32) NOT NULL DEFAULT '',
  `order_ids` varchar(255) NOT NULL DEFAULT '',
  `template` varchar(128) NOT NULL DEFAULT '',
  `message` mediumtext,
  `products` text,
  PRIMARY KEY (`gift_cert_id`),
  KEY `status` (`status`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]gift_certificates_log`
--

CREATE TABLE `[[dbprefix]]gift_certificates_log` (
  `log_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `gift_cert_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `area` char(1) NOT NULL DEFAULT 'C',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `order_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `timestamp` int(11) unsigned NOT NULL DEFAULT '0',
  `amount` decimal(12,2) NOT NULL DEFAULT '0.00',
  `debit` decimal(12,2) NOT NULL DEFAULT '0.00',
  `products` text,
  `debit_products` text,
  PRIMARY KEY (`log_id`),
  KEY `area` (`area`),
  KEY `user_id` (`user_id`),
  KEY `order_id` (`order_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]hybrid_auth_providers`
--

CREATE TABLE `[[dbprefix]]hybrid_auth_providers` (
  `provider_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `company_id` int(11) unsigned NOT NULL DEFAULT '0',
  `provider` varchar(32) NOT NULL,
  `position` smallint(6) NOT NULL DEFAULT '0',
  `app_id` varchar(255) NOT NULL DEFAULT '',
  `app_secret_key` varchar(255) DEFAULT '',
  `app_public_key` varchar(255) DEFAULT '',
  `app_params` text,
  `status` char(1) DEFAULT 'D',
  PRIMARY KEY (`provider_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]hybrid_auth_storefronts_providers`
--

CREATE TABLE `[[dbprefix]]hybrid_auth_storefronts_providers` (
  `storefront_id` int(11) unsigned NOT NULL DEFAULT '0',
  `provider_id` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`storefront_id`,`provider_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]hybrid_auth_users`
--

CREATE TABLE `[[dbprefix]]hybrid_auth_users` (
  `user_id` mediumint(8) unsigned NOT NULL,
  `provider_id` mediumint(8) unsigned NOT NULL,
  `identifier` varchar(128) NOT NULL DEFAULT '',
  `timestamp` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`provider_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]images`
--

CREATE TABLE `[[dbprefix]]images` (
  `image_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `image_path` varchar(255) NOT NULL DEFAULT '',
  `image_x` int(5) NOT NULL DEFAULT '0',
  `image_y` int(5) NOT NULL DEFAULT '0',
  `is_high_res` char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`image_id`),
  KEY `image_path` (`image_path`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8652 ;

--
-- Dumping data for table `[[dbprefix]]images`
--

INSERT INTO `[[dbprefix]]images` VALUES
(237, 'd85_smartTV.jpg', 400, 400, 'N'),
(238, 'LED800065NAL30_1.jpg', 500, 500, 'N'),
(239, 'LED800065NAfront_2.jpg', 500, 500, 'N'),
(240, 'LED800065NAR30_2.jpg', 500, 500, 'N'),
(243, 'UN40D5003BFXZA.jpg', 800, 800, 'N'),
(244, 'LED4003400532NAL30_1.jpg', 500, 500, 'N'),
(245, 'LED4003400532NAR30_1.jpg', 500, 500, 'N'),
(246, 'LCD_610_Sailing_Frt_3.jpg', 600, 600, 'N'),
(247, 'LCD610_R70_1.jpg', 600, 600, 'N'),
(248, 'LCD610_R45.jpg', 1000, 1000, 'N'),
(249, 'LCD610_R90_1.jpg', 600, 600, 'N'),
(250, 'LCD610_Back_1.jpg', 600, 600, 'N'),
(251, 'lcd-tv-32C120-01.jpg', 600, 600, 'N'),
(252, 'X41185_01.jpg', 500, 500, 'N'),
(254, 'lcd-tv-32C120-02.jpg', 600, 600, 'N'),
(255, 'lcd-tv-32C120-04.jpg', 600, 600, 'N'),
(256, 'lcd-tv-32C120-03.jpg', 600, 600, 'N'),
(257, 'led-tv-32TL515-01.jpg', 715, 496, 'N'),
(258, 'led-tv-32TL515-02.jpg', 1280, 764, 'N'),
(259, 'led-tv-TL515-04.jpg', 1280, 764, 'N'),
(260, 'led-tv-32TL515-03.jpg', 600, 600, 'N'),
(261, 'led-tv-42TL515-01.jpg', 715, 496, 'N'),
(262, 'led-tv-42TL515-02.jpg', 1280, 764, 'N'),
(263, 'led-tv-42TL515-03.jpg', 600, 600, 'N'),
(264, 'led-tv-TL515-0413286204504f3123a20c4ea.jpg', 1280, 764, 'N'),
(265, '47tl515.jpg', 300, 300, 'N'),
(266, 'X32444_01.jpg', 2000, 2000, 'N'),
(267, 'X32444_02.jpg', 1806, 2586, 'N'),
(268, 'led-tv-47TL515-01.jpg', 715, 496, 'N'),
(269, 'led-tv-47TL515-02.jpg', 1280, 764, 'N'),
(270, 'led-tv-47TL515-03.jpg', 600, 600, 'N'),
(271, 'led-tv-TL515-0413286206244f312450e72f4.jpg', 1280, 764, 'N'),
(274, 'Z2580.jpg', 500, 766, 'N'),
(275, '40e220u.jpg', 500, 500, 'N'),
(276, 'lcd-tv-40E220-01.jpg', 600, 600, 'N'),
(277, 'lcd-tv-40E220-02.jpg', 600, 600, 'N'),
(278, 'lcd-tv-40E220-03.jpg', 600, 600, 'N'),
(279, 'lcd-tv-40E220-04.jpg', 600, 600, 'N'),
(280, '452499_010_A.jpg', 900, 600, 'N'),
(281, '452499_010_B.jpg', 900, 600, 'N'),
(282, 'BD-D7500_01-copy_5.jpg', 600, 600, 'N'),
(283, 'BD_D7500_FrtAngle_2.jpg', 600, 600, 'N'),
(284, 'BD-D7500_04-copy_3.jpg', 600, 600, 'N'),
(285, 'Z6595.jpg', 510, 680, 'N'),
(286, 'BD-D7000_F_5.jpg', 600, 600, 'N'),
(287, 'BD-D7000_R45_2.jpg', 600, 600, 'N'),
(288, 'bluray-bdx2150-600-01.jpg', 600, 600, 'N'),
(289, 'bluray-bdx2150-600-02.jpg', 600, 600, 'N'),
(290, 'bluray-bdx2150-600-03.jpg', 600, 600, 'N'),
(291, 'bluray-bdx2150-600-04.jpg', 600, 600, 'N'),
(292, '1886039720.jpg', 500, 500, 'N'),
(293, 'dvd-player-sd3300-600-01.jpg', 600, 600, 'N'),
(294, 'dvd-player-sd3300-600-02.jpg', 600, 600, 'N'),
(295, 'HT_D6730W_5.jpg', 1086, 768, 'N'),
(296, 'HTD6500WF1_5.jpg', 1500, 1500, 'N'),
(297, 'HT-D5500_FRONT-copy_5.jpg', 1500, 1500, 'N'),
(298, 'HT_D5500_2.jpg', 800, 800, 'N'),
(299, 'HWD7000Fopen_6.jpg', 600, 600, 'N'),
(300, 'cat.gif', 500, 500, 'N'),
(301, 'V31582_01.jpg', 800, 800, 'N'),
(302, 'V31582_02.jpg', 800, 800, 'N'),
(303, 'X35533_01.jpg', 500, 500, 'N'),
(304, 'X35533_02.jpg', 500, 500, 'N'),
(305, 'TT_VIALIVE135_FRONT-GENERIC_image_tcm137-14537.jpg', 850, 593, 'N'),
(306, 'Top-Gear-Image-1_tcm137-20857.jpg', 1585, 1664, 'N'),
(307, 'TT_VIALIVE135_LOGO_L-GENERIC_image_tcm137-14539.jpg', 1280, 1250, 'N'),
(308, 'TT_VIALIVE135_DOCK-R_tcm137-14608.jpg', 500, 500, 'N'),
(309, 'TT_VIALIVE135_DOCK2-L_s_tcm137-14610.jpg', 1857, 2064, 'N'),
(310, 'mount_angle_500_tcm137-7794.jpg', 500, 500, 'N'),
(311, '450676_063_A.jpg', 900, 600, 'N'),
(312, '450676_063_B.jpg', 900, 600, 'N'),
(313, 'front_500_tcm137-7792.jpg', 500, 330, 'N'),
(314, 'Siena-0001_Image_tcm137-6416.jpg', 750, 493, 'N'),
(315, 'Siena-0018_Image_tcm137-6423.jpg', 800, 800, 'N'),
(316, 'cf-lg.jpg', 500, 500, 'N'),
(317, 'pd-01-lg.jpg', 500, 500, 'N'),
(318, 'pd-03-lg.jpg', 500, 500, 'N'),
(319, 'rf-lg.jpg', 500, 500, 'N'),
(320, '451160_063_A.jpg', 900, 600, 'N'),
(321, '451160_063_B.jpg', 900, 600, 'N'),
(322, 'pd-01-lg13286231214f312e1193b91.jpg', 500, 500, 'N'),
(323, 'pd-03-lg13286231214f312e11985e8.jpg', 900, 900, 'N'),
(324, 'url_uploaded_file_13286231494f312e2e48377.jpg', 504, 648, 'N'),
(325, 'url_uploaded_file_13286235024f312f8f85905.jpg', 500, 614, 'N'),
(327, '1951_800_550.jpg', 1000, 1000, 'N'),
(328, '437394_010_A.jpg', 900, 600, 'N'),
(329, '437394_010_B.jpg', 900, 600, 'N'),
(330, 'DEH-80PRS_large.jpg', 800, 800, 'N'),
(331, 'DEH-Card-Remote-BT-2012_large.jpg', 500, 500, 'N'),
(332, 'DEH-80PRS_rear.jpg', 800, 800, 'N'),
(333, 'DEH-80PRS_angle.jpg', 800, 800, 'N'),
(334, 'DEH-P8400BH_large.jpg', 1600, 591, 'N'),
(335, 'DEH-P8400BH_rear.jpg', 1000, 1000, 'N'),
(336, 'DEH-Card-Remote-BT-2012_large13286238444f3130e4e4dcf.jpg', 500, 500, 'N'),
(337, 'DEH-P8400BH_angle1.jpg', 1000, 519, 'N'),
(338, 'DEH-P8400BH_angle2.jpg', 1200, 1200, 'N'),
(339, 'X32679_01.jpg', 500, 500, 'N'),
(340, 'X32679_02.jpg', 500, 500, 'N'),
(341, 'DEH-1300MP_large.jpg', 800, 800, 'N'),
(342, 'DEH-1300MP_angle.jpg', 800, 800, 'N'),
(343, 'DEH-Card-Remote-2011_large.jpg', 500, 500, 'N'),
(344, 'FH-P8000BT_main_Lrg.jpg', 800, 800, 'N'),
(345, 'Bluetooth_Remote.jpg', 500, 500, 'N'),
(346, 'FH-P8000BT_Right_Lrg.jpg', 800, 800, 'N'),
(347, 'FH-P8000BT_Back_lrg.jpg', 800, 800, 'N'),
(348, 'FH-P8000BT_Left_Lrg.jpg', 800, 800, 'N'),
(349, 'Main_116.jpg', 500, 500, 'N'),
(350, '29336_McBride_The_Process_of_Research_in_Psychology_72ppiRGB_150pixW.jpg', 500, 500, 'N'),
(351, '008525B.jpg', 1240, 1633, 'N'),
(352, 'MvC3_PS3CE_moreboxshot.jpg', 500, 500, 'N'),
(353, 'MvC3_PS3CE_productimage.jpg', 500, 500, 'N'),
(354, '95531493TS-MR2040_Front_med.jpg', 500, 500, 'N'),
(355, '66349997TS-MR1640_front_med.jpg', 654, 654, 'N'),
(356, 'TS-D1720C_large.jpg', 833, 625, 'N'),
(357, 'TS-D1720C_tweeters.jpg', 800, 400, 'N'),
(358, 'TS-D1720C_crossovers.jpg', 800, 800, 'N'),
(359, 'TS-D1720C_woofers.jpg', 800, 800, 'N'),
(360, 'TS-D6902R_large.jpg', 700, 700, 'N'),
(361, '1967_675_600.jpg', 1200, 900, 'N'),
(362, '1150_570_600.jpg', 900, 900, 'N'),
(363, 'TS-W3002D2D4_large.jpg', 1024, 1024, 'N'),
(364, 'PRS-D800_large.jpg', 1000, 1000, 'N'),
(365, 'PRS-D800_side1.jpg', 1000, 1000, 'N'),
(366, 'PRS-D800_side2.jpg', 1000, 1000, 'N'),
(367, 'PRS-D800_top.jpg', 1000, 1000, 'N'),
(368, 'GM-6500F_large.jpg', 800, 800, 'N'),
(369, 'GM-6500F_left.jpg', 800, 800, 'N'),
(370, 'GM-D8500M_angle_large.jpg', 800, 450, 'N'),
(371, 'GM-D8500F_Remote_large.jpg', 500, 500, 'N'),
(372, 'AVH-P8400BH_large.jpg', 800, 600, 'N'),
(373, 'AVH-P8400BH_angle1.jpg', 800, 600, 'N'),
(374, 'AVH-P8400BH_angle2.jpg', 800, 600, 'N'),
(375, 'AVH-P8400BH_in-dash.jpg', 800, 600, 'N'),
(376, 'AVH-P8400BH_DFS.jpg', 800, 600, 'N'),
(377, 'AVH-P8400BH_rear.jpg', 800, 600, 'N'),
(378, 'AVH-Remote-2012_CXE5116_large.jpg', 600, 600, 'N'),
(379, 'AVH-P4400BH_large.jpg', 800, 600, 'N'),
(380, 'AVH-P4400BH_angle1.jpg', 800, 600, 'N'),
(381, 'AVH-P4400BH_angle2.jpg', 800, 600, 'N'),
(382, 'AVH-P4400BH_rear.jpg', 800, 600, 'N'),
(383, 'AVH-Remote-2012_CXE5116_large13286304494f314ab18b007.jpg', 600, 600, 'N'),
(384, 'AVIC-Z130BT_reg.jpg', 500, 500, 'N'),
(385, 'AVIC-Z130BT.jpg', 400, 400, 'N'),
(386, 'AVIC-Z130BT_UC_in-dash.jpg', 800, 800, 'N'),
(390, 'XRS9945_LRG.jpg', 500, 500, 'N'),
(391, 'XRS9770_MD.jpg', 809, 500, 'N'),
(392, 'XRS9745_LRG.jpg', 1000, 1000, 'N'),
(393, 'XRS9370_MD.jpg', 650, 403, 'N'),
(394, 'XRS9970G_R-med.jpg', 805, 805, 'N'),
(395, 'wildfires-metropcs-MoreViews-2985.jpg', 500, 500, 'N'),
(396, 'wildfires-metropcs-MoreViews-2986.jpg', 500, 500, 'N'),
(397, 'wildfires-metropcs-MoreViews-2987.jpg', 500, 500, 'N'),
(398, 'wildfires-metropcs-MoreViews-2988.jpg', 500, 500, 'N'),
(399, 'titan-att-MoreViews-3012.jpg', 500, 608, 'N'),
(400, 'titan-att-MoreViews-3013.jpg', 500, 608, 'N'),
(401, 'titan-att-MoreViews-3014.jpg', 500, 608, 'N'),
(402, 'titan-att-MoreViews-3015.jpg', 500, 608, 'N'),
(403, 'titan-att-MoreViews-3016.jpg', 500, 608, 'N'),
(404, 'titan-att-MoreViews-3017.jpg', 500, 608, 'N'),
(405, 'titan-att-MoreViews-3018.jpg', 500, 608, 'N'),
(406, 'titan-att-MoreViews-3019.jpg', 500, 608, 'N'),
(407, 'titan-att-MoreViews-3021.jpg', 500, 608, 'N'),
(408, 'rhyme-verizon-MoreViews-2645.jpg', 500, 500, 'N'),
(409, 'rhyme-verizon-MoreViews-2646.jpg', 500, 500, 'N'),
(410, 'rhyme-verizon-MoreViews-2647.jpg', 600, 600, 'N'),
(411, 'rhyme-verizon-MoreViews-2648.jpg', 644, 644, 'N'),
(412, 'rhyme-verizon-MoreViews-2649.jpg', 500, 500, 'N'),
(413, 'evodesign4g-sprint-MoreViews-2839.jpg', 800, 948, 'N'),
(414, 'evodesign4g-sprint-MoreViews-2840.jpg', 800, 800, 'N'),
(415, 'evodesign4g-sprint-MoreViews-2841.jpg', 500, 500, 'N'),
(416, 'evodesign4g-sprint-MoreViews-2842.jpg', 818, 1210, 'N'),
(417, 'evodesign4g-sprint-MoreViews-2843.jpg', 606, 404, 'N'),
(418, 'incredible2-verizon-MoreViews-1922.jpg', 1100, 1026, 'N'),
(419, 'incredible2-verizon-MoreViews-1918.jpg', 1500, 1360, 'N'),
(420, 'incredible2-verizon-MoreViews-1919.jpg', 600, 600, 'N'),
(421, 'incredible2-verizon-MoreViews-1920.jpg', 500, 500, 'N'),
(422, 'incredible2-verizon-MoreViews-1921.jpg', 900, 900, 'N'),
(423, '31igDkhoUNL._SX220_.jpg', 500, 500, 'N'),
(424, '21SXU3Z1iGL._SX220_.jpg', 500, 500, 'N'),
(425, '31FZtzlRY+L._SX220_.jpg', 500, 500, 'N'),
(426, '318v60DwLzL._SX220_.jpg', 500, 500, 'N'),
(427, '11UG7jOeaaL._SX220_.jpg', 500, 500, 'N'),
(428, '21HZgrCmlnL._SX220_.jpg', 500, 500, 'N'),
(429, '21LllLxrG7L._SX220_.jpg', 500, 500, 'N'),
(430, '21m6Oh-3V7L._SX220_.jpg', 500, 500, 'N'),
(431, '21NE2eQ9cGL._SX220_.jpg', 500, 500, 'N'),
(432, '21nGYVjaXcL._SX220_.jpg', 500, 500, 'N'),
(433, '21Y7tnPMVHL._SX220_.jpg', 500, 500, 'N'),
(434, '21J1GvD2+OL._SX220_.jpg', 500, 500, 'N'),
(435, '219VLxUNBVL._SX220_.jpg', 500, 500, 'N'),
(436, '21YX09ju46L._SX220_.jpg', 500, 500, 'N'),
(437, '31XNsUOJQ2L._SX220_.jpg', 500, 500, 'N'),
(438, '21ey9KYVJBL._SX220_.jpg', 500, 500, 'N'),
(439, '217t6mWmKtL._SX220_.jpg', 500, 500, 'N'),
(440, '21o5d8HaEPL._SX220_.jpg', 500, 500, 'N'),
(441, '31OMU8eIbpL._SX220_.jpg', 500, 500, 'N'),
(442, '21NteLdVarL._SX220_.jpg', 500, 500, 'N'),
(443, '217Lf0Ah3rL._SX220_.jpg', 500, 500, 'N'),
(444, '31jwZ9SwA8L._SX220_.jpg', 500, 500, 'N'),
(445, '31fu60vb60L._SX220_.jpg', 500, 500, 'N'),
(446, '31OZNMeCWBL._SX220_.jpg', 500, 500, 'N'),
(447, '21hNMRIx66L._SX220_.jpg', 500, 500, 'N'),
(522, 'i515_400x400_large1_cf_1.jpg', 1000, 1000, 'N'),
(523, '1000173538_f.jpg', 500, 500, 'N'),
(524, 'i515_400x400_large1_cl.jpg', 800, 800, 'N'),
(525, 'i515_400x400_large1_cr.jpg', 619, 600, 'N'),
(526, 'i515_400x400_large1_cr13286900474f32337fcaa2a.jpg', 619, 600, 'N'),
(453, 'G48874_01.jpg', 500, 500, 'N'),
(454, 'G48874_02.jpg', 500, 500, 'N'),
(455, 'G48874_03.jpg', 500, 500, 'N'),
(456, 'G48874_04.jpg', 500, 500, 'N'),
(457, 'G48874_05.jpg', 500, 500, 'N'),
(458, 'U42918_01.jpg', 500, 500, 'N'),
(459, 'U42918_02.jpg', 500, 500, 'N'),
(460, 'U42918_03.jpg', 500, 500, 'N'),
(461, 'U42918_04.jpg', 500, 500, 'N'),
(462, 'U42918_05.jpg', 500, 500, 'N'),
(463, '476750_003_A.jpg', 900, 600, 'N'),
(464, '476750_003_B.jpg', 900, 600, 'N'),
(465, '7210_4815_200_f.jpg', 1119, 1253, 'N'),
(466, '7210_4815_200_d2.jpg', 1119, 1253, 'N'),
(467, '7210_4815_200_d1.jpg', 1119, 1253, 'N'),
(468, '2817406.jpg', 878, 1200, 'N'),
(469, '1907188.jpg', 500, 512, 'N'),
(470, '2083726.jpg', 640, 906, 'N'),
(471, '1000009496_f.jpg', 500, 500, 'N'),
(510, '700-red-front-png13286885734f322dbde9ae7.jpg', 500, 500, 'N'),
(473, '2817655.jpg', 1000, 1000, 'N'),
(474, '3086390.jpg', 1040, 1040, 'N'),
(475, '2954384.jpg', 1200, 1200, 'N'),
(476, '1000202232_f.jpg', 1200, 1200, 'N'),
(477, '102337_l.ashx.jpg', 500, 500, 'N'),
(478, '102337_890x364_01.ashx.jpg', 890, 890, 'N'),
(479, '102337_890x364_02.ashx.jpg', 890, 890, 'N'),
(480, '102337_890x364_03.ashx.jpg', 411, 411, 'N'),
(481, '102337_890x364_04.ashx.jpg', 890, 890, 'N'),
(482, '101551_l.ashx.jpg', 500, 500, 'N'),
(483, '101551_890x364_01.ashx.jpg', 890, 890, 'N'),
(484, '101551_890x364_02.ashx.jpg', 890, 890, 'N'),
(485, '101551_890x364_03.ashx.jpg', 408, 408, 'N'),
(486, '2423577.jpg', 1000, 1000, 'N'),
(487, '1000176186_f.jpg', 625, 849, 'N'),
(488, '2832686.jpg', 500, 512, 'N'),
(489, '1000235553_f.jpg', 1200, 1200, 'N'),
(511, '1565865.jpg', 500, 512, 'N'),
(491, '1000156676_f.jpg', 500, 500, 'N'),
(514, 'i677_600x600_xlarge_cf.jpg', 600, 600, 'N'),
(515, 'i677_600x600_xlarge_bk.jpg', 600, 600, 'N'),
(516, 'i677_600x600_xlarge_cl.jpg', 600, 600, 'N'),
(495, '1000156675_f.jpg', 500, 500, 'N'),
(521, '1837696.jpg', 500, 512, 'N'),
(517, 'i677_600x600_xlarge_cr.jpg', 600, 600, 'N'),
(498, 'X3-02-white-front-png.jpg', 500, 500, 'N'),
(513, '2419089.jpg', 500, 512, 'N'),
(500, 't049_210_11_017_00.jpg', 500, 500, 'N'),
(501, '2980245.jpg', 600, 881, 'N'),
(502, '3083326.jpg', 700, 959, 'N'),
(503, 'Searay-white-Front-png.jpg', 1000, 1000, 'N'),
(504, 'E5-black-front-black-png13286888164f322eb054f4c.jpg', 1000, 1000, 'N'),
(520, 'CB-evolve.jpg', 936, 612, 'N'),
(518, 'i677_600x600_xlarge_s1.jpg', 600, 600, 'N'),
(507, '03804_l.ashx.jpg', 500, 500, 'N'),
(508, '2891878.jpg', 500, 636, 'N'),
(509, '101796_l.ashx.jpg', 500, 500, 'N'),
(512, '2411125.jpg', 500, 512, 'N'),
(519, '1917865.jpg', 1071, 1185, 'N'),
(527, 'i515_400x400_large1_s1.jpg', 500, 500, 'N'),
(528, 'i515_400x400_large1_s2.jpg', 500, 500, 'N'),
(529, 'i515_400x400_large1_bk_2.jpg', 650, 650, 'N'),
(530, '2957882.jpg', 1445, 1600, 'N'),
(531, 'd710_600x600_xlarge_cf.jpg', 600, 600, 'N'),
(532, '2980261.jpg', 500, 512, 'N'),
(533, 'CB-evolution.jpg', 936, 612, 'N'),
(534, '1000172227_f.jpg', 500, 500, 'N'),
(535, 'CB-truth.jpg', 936, 612, 'N'),
(536, 'd710_400x400_large1_bk.jpg', 400, 400, 'N'),
(537, 'd710_400x400_large1_cl.jpg', 400, 400, 'N'),
(538, 'd710_400x400_large1_cr.jpg', 400, 400, 'N'),
(539, 'd710_400x400_large1_s1.jpg', 500, 500, 'N'),
(540, 'd710_400x400_large1_s2.jpg', 600, 600, 'N'),
(541, 'i777_400x400_large1_cf_1.jpg', 700, 700, 'N'),
(542, 'fx-cg10_xlarge.jpg', 500, 529, 'N'),
(543, 'i777_400x400_large1_bk.jpg', 400, 400, 'N'),
(544, 'i777_400x400_large1_cl.jpg', 600, 600, 'N'),
(545, 'i777_400x400_large1_cr.jpg', 650, 650, 'N'),
(546, 'i777_400x400_large1_s1.jpg', 500, 500, 'N'),
(547, 'i777_400x400_large1_s2.jpg', 500, 500, 'N'),
(548, '1312496083_CR5-2011-315-sram.jpg', 618, 500, 'N'),
(549, '1312496057_CR5-2011-225-sram.jpg', 618, 500, 'N'),
(550, '1312496025_CR5-2011-180-sram.jpg', 618, 500, 'N'),
(551, '1312496004_CR5-2011-135-sram.jpg', 618, 500, 'N'),
(552, '1312495974_CR5-2011-45-sram.jpg', 618, 500, 'N'),
(553, '1312495960_CR5-2011-0-sram.jpg', 618, 500, 'N'),
(554, 'fx-115es_xlarge.jpg', 500, 529, 'N'),
(555, '1316633534_CR1-2012-315.jpg', 618, 500, 'N'),
(556, '1316633442_CR1-2012-0.jpg', 618, 500, 'N'),
(557, '1316633497_CR1-2012-180.jpg', 618, 500, 'N'),
(558, '1316633471_CR1-2012-90.jpg', 618, 500, 'N'),
(559, 'dr-210tmbk_xlarge.jpg', 1175, 1166, 'N'),
(560, '1316556371_CA-2012-45.jpg', 618, 500, 'N'),
(561, '1316556344_CA-2012-0.jpg', 618, 500, 'N'),
(562, '1316556781_CA-2012-315.jpg', 618, 500, 'N'),
(563, 'WiFi_Galaxy5_front3_4.jpg', 800, 800, 'N'),
(572, 'Wifi_Galaxy_Player_4_front2_14.jpg', 800, 800, 'N'),
(565, 'GalaxyPlayer5_18_213286919574f323af5ddfc8.jpg', 600, 600, 'N'),
(566, 'GalaxyPlayer5_26.jpg', 600, 600, 'N'),
(567, 'GalaxyPlayer5_28_2.jpg', 600, 600, 'N'),
(568, 'GalaxyPlayer5_07.jpg', 600, 600, 'N'),
(569, 'GalaxyPlayer5_05_2.jpg', 600, 600, 'N'),
(570, 'GalaxyPlayer5_04.jpg', 600, 600, 'N'),
(571, 'GalaxyPlayer5_03_5.jpg', 600, 600, 'N'),
(573, 'rearr1_2.jpg', 600, 600, 'N'),
(574, 'rear2.jpg', 600, 600, 'N'),
(575, 'side1_5.jpg', 600, 600, 'N'),
(576, 'Untitled-1.jpg', 600, 600, 'N'),
(577, 'Wifi_Galaxy_Player_4_extleft2_2.jpg', 800, 800, 'N'),
(578, 'Wifi_Galaxy_Player_4_extright2.jpg', 800, 800, 'N'),
(579, 'Wifi_Galaxy_Player_4_left2_2.jpg', 800, 800, 'N'),
(580, '41rz1TVrQdL.jpg', 500, 500, 'N'),
(581, '51g+lhvGGQL.jpg', 500, 500, 'N'),
(582, 'bbex_boxart_psvita.jpg', 500, 637, 'N'),
(583, 'url_uploaded_file_13286945074f3244ec33aed.jpg', 1200, 1200, 'N'),
(584, '1328221407-ridgeracer-gameart_landing.jpg', 500, 500, 'N'),
(585, '1328221297-documentvi-gameart_landing.jpg', 500, 500, 'N'),
(586, 'p149239z.jpg', 450, 450, 'N'),
(587, 'p149240z.jpg', 450, 450, 'N'),
(588, 'p95910z.jpg', 500, 500, 'N'),
(589, 'p98947z.jpg', 500, 500, 'N'),
(590, 'p98945z.jpg', 500, 500, 'N'),
(591, 'Fuzeplusred_210.jpg', 600, 600, 'N'),
(592, 'clip_plus_red.jpg', 500, 500, 'N'),
(593, 'NWZA865BLK.jpg', 1000, 1000, 'N'),
(594, 'NWZA865BLK_1.jpg', 800, 600, 'N'),
(595, 'NWZE464RED.jpg', 1000, 1000, 'N'),
(596, 'DB_2011_WILDWOOD-CITI_Blue_LG.jpg', 800, 523, 'N'),
(597, 'DB_2011_WILDWOOD-CITI_Black_LG.jpg', 800, 530, 'N'),
(598, 'DB_2011_DRIFTER-2_Grey_LG.jpg', 800, 513, 'N'),
(599, 'url_uploaded_file_13286977924f3251c3f2695.jpg', 1000, 1000, 'N'),
(600, 'url_uploaded_file_13286978134f3251d8b881b.jpg', 1000, 1000, 'N'),
(601, 'NWZE464RED_1.jpg', 1000, 1000, 'N'),
(602, 'url_uploaded_file_13286980754f3252e10c119.jpg', 1000, 1000, 'N'),
(603, 'url_uploaded_file_13286980934f3252f0a7257.jpg', 1000, 1000, 'N'),
(604, 'url_uploaded_file_13286981734f3253431b01f.jpg', 1000, 1000, 'N'),
(605, 'url_uploaded_file_13286983184f3253d32faa0.jpg', 1000, 1000, 'N'),
(606, 'url_uploaded_file_13286983184f3253d55fbaf.jpg', 1000, 1000, 'N'),
(607, 'url_uploaded_file_13286983184f3253da9b588.jpg', 1000, 1000, 'N'),
(608, 'url_uploaded_file_13286983184f3253dece8d3.jpg', 1000, 1000, 'N'),
(609, 'MDRXB1000.jpg', 800, 800, 'N'),
(610, 'MDRXB1000_1.jpg', 500, 500, 'N'),
(611, 'MDRZ1000.jpg', 500, 500, 'N'),
(612, 'MDRZ1000_1.jpg', 500, 500, 'N'),
(613, 'icon-01.jpg', 500, 500, 'N'),
(614, 'cs-53.jpg', 500, 500, 'N'),
(615, 'DB2010Drifter3SatinRed_Profile_LRG.jpg', 800, 800, 'N'),
(616, 'MV800_NEW_KV_6.jpg', 600, 600, 'N'),
(617, 'cs-180.jpg', 500, 511, 'N'),
(618, 'MV800_02_MB_1024x768.jpg', 600, 600, 'N'),
(619, 'MV800_03_MB_1024x768_2.jpg', 600, 600, 'N'),
(620, 'MV800_04_MB_1024x768.jpg', 600, 600, 'N'),
(621, 'MV800_37_MB_1024x768_2.jpg', 600, 600, 'N'),
(622, 'MV800_38_MB_1024x768_3.jpg', 600, 600, 'N'),
(623, 'MV800_45_MB_1024x768.jpg', 600, 600, 'N'),
(624, 'MV800_46_MB_1024x768_2.jpg', 600, 600, 'N'),
(625, 'MV800_F2_MB_1024x768.jpg', 600, 600, 'N'),
(626, 'MV800_FS1_MB_1024x768_2.jpg', 600, 600, 'N'),
(627, 'NX200_F4_B_1024x768_6.jpg', 1000, 819, 'N'),
(628, 'main_2.jpg', 800, 600, 'N'),
(629, 'NX200_B_B.jpg', 1024, 768, 'N'),
(630, 'NX200_BS1_B_2.jpg', 1280, 1280, 'N'),
(631, 'NX200_BS2_B.jpg', 897, 448, 'N'),
(632, 'NX200_FS1_B_2.jpg', 600, 600, 'N'),
(633, 'NX200_FS2_B.jpg', 1200, 1200, 'N'),
(634, 'NX200_FT1_B_2.jpg', 1024, 768, 'N'),
(635, 'NX200_S2_B.jpg', 1000, 1000, 'N'),
(636, 'NX200_T2_B_4.jpg', 1000, 1000, 'N'),
(637, 'NX200_WS1_B_1.jpg', 891, 797, 'N'),
(638, 'NX200_WS2_B_2.jpg', 600, 600, 'N'),
(639, 'NX200_F5_B_1024x768_2.jpg', 1024, 768, 'N'),
(640, 'NX-system_2_1024x768.jpg', 600, 600, 'N'),
(641, 'WB210_F_R_Global_4.jpg', 1024, 768, 'N'),
(642, 'WB210_FS_R_Global_2.jpg', 1000, 1000, 'N'),
(643, 'WB210_T_R_Global_2.jpg', 1024, 768, 'N'),
(644, 'WB210_B_R_Global_2.jpg', 800, 800, 'N'),
(645, '27528_1.jpg', 1024, 698, 'N'),
(646, '27528_2.jpg', 1024, 768, 'N'),
(647, '27528_3.jpg', 1135, 900, 'N'),
(648, '27528_4.jpg', 700, 700, 'N'),
(649, '27534_1.jpg', 700, 595, 'N'),
(650, '27534_2.jpg', 1200, 900, 'N'),
(651, '27534_4.jpg', 500, 500, 'N'),
(652, '27534_3.jpg', 500, 500, 'N'),
(653, '25472_1.jpg', 1000, 1000, 'N'),
(654, '25472_2.jpg', 1280, 1280, 'N'),
(655, '25472_4.jpg', 1200, 1200, 'N'),
(656, '25472_3.jpg', 1024, 783, 'N'),
(657, '25464_1.jpg', 900, 900, 'N'),
(658, '25464_2.jpg', 1024, 854, 'N'),
(659, '25464_4.jpg', 700, 700, 'N'),
(660, '25464_3.jpg', 1600, 1200, 'N'),
(661, '25478_1.jpg', 1200, 1200, 'N'),
(662, '25478_2.jpg', 1000, 1000, 'N'),
(663, '25478_4.jpg', 500, 500, 'N'),
(664, '25478_3.jpg', 500, 500, 'N'),
(665, '25478_5.jpg', 1000, 1000, 'N'),
(666, '588crm_hero.jpg', 800, 800, 'N'),
(667, '588crm_address.jpg', 800, 800, 'N'),
(668, '588crm_face.jpg', 800, 800, 'N'),
(669, '588crm_money.jpg', 800, 800, 'N'),
(670, 'url_uploaded_file_13287005214f325c6eac3d5.jpg', 632, 632, 'N'),
(671, 'T10_use_5.jpg', 750, 474, 'N'),
(672, 'T10_F2_O_1024x768.jpg', 600, 600, 'N'),
(673, 'T10_S1_O_1024x768.jpg', 600, 600, 'N'),
(674, 'T10_F2_O_1024x768_dimg_2.jpg', 600, 600, 'N'),
(675, 'T10_FS3_O_1024x768.jpg', 600, 600, 'N'),
(676, 'T10_T_O_1024x768_2.jpg', 600, 600, 'N'),
(677, 'T10_FS5_O_1024x768_2.jpg', 800, 544, 'N'),
(678, 'h300_main_5.jpg', 600, 600, 'N'),
(679, 'url_uploaded_file_13287007294f325d3b12476.jpg', 1375, 1093, 'N'),
(680, 'H300_FT_B_2.jpg', 800, 600, 'N'),
(681, 'H300_FS3_B_2.jpg', 1000, 1000, 'N'),
(682, 'H300_FS2_B_2.jpg', 1000, 1000, 'N'),
(683, 'H300_F2_B_2.jpg', 3000, 2000, 'N'),
(684, 'H300_F1_B_2.jpg', 600, 600, 'N'),
(685, 'H300_BS_B_2.jpg', 600, 600, 'N'),
(686, 'H300_B_B_2.jpg', 600, 600, 'N'),
(687, 'F50_front_5.jpg', 600, 600, 'N'),
(688, 'url_uploaded_file_13287009294f325e041c8e1.jpg', 550, 550, 'N'),
(689, 'F50_B_S_1024x768_2.jpg', 1024, 794, 'N'),
(690, 'F50_FS5_S_1024x768_2.jpg', 600, 600, 'N'),
(691, 'F50_BS_S_1024x768.jpg', 600, 600, 'N'),
(692, 'F50_F1_S_1024x768_2.jpg', 600, 600, 'N'),
(693, 'F50_S1_S_1024x768.jpg', 600, 600, 'N'),
(694, 'F50_FS2_S_1024x768_1.jpg', 600, 600, 'N'),
(695, 'F50_T1_S_1024x768_2.jpg', 600, 600, 'N'),
(696, 'F50_T2_S_1024x768.jpg', 600, 600, 'N'),
(697, 'blkdrv_hero.jpg', 800, 800, 'N'),
(698, 'blkdrv_face.jpg', 800, 800, 'N'),
(699, 'blkdrv_super.jpg', 800, 800, 'N'),
(700, 'blkdrv_toe.jpg', 800, 800, 'N'),
(701, 'mbank30208_w550_h550.jpg', 550, 550, 'N'),
(702, '16_bp_1.jpg', 800, 800, 'N'),
(703, '16_bp_2.jpg', 800, 800, 'N'),
(704, '16_bp_3.jpg', 800, 800, 'N'),
(705, '16_bp_4.jpg', 800, 800, 'N'),
(706, 'EX-S1855SB_600.jpg', 600, 600, 'N'),
(707, 'bloom_berry_set1.jpg', 800, 800, 'N'),
(708, 'bloom_berry_set2.jpg', 800, 800, 'N'),
(709, 'bloom_berry_driver_hero.jpg', 800, 800, 'N'),
(710, 'bloom_berry_8iron_hero.jpg', 800, 800, 'N'),
(711, 'bloom_berry_niblick_hero.jpg', 800, 800, 'N'),
(712, 'mbank15770_w550_h550.jpg', 550, 550, 'N'),
(713, 'NX_50-200_Lens_600.jpg', 600, 600, 'N'),
(714, 'ED-30NB_pancake2_600_1.jpg', 700, 700, 'N'),
(715, 'cameraLens_4.jpg', 600, 600, 'N'),
(716, '5e1cdabf5a35c38ba2b747c9adfddb7f.jpg', 800, 800, 'N'),
(717, '8ad650de56e5e2272b240d3a6c171545.jpg', 800, 800, 'N'),
(718, '167734bda696f56942c278bee07e7236.jpg', 800, 800, 'N'),
(719, '50Elite_Yellow_12ball_Render.jpg', 500, 500, 'N'),
(720, '50Elite_Yellow_3ball_Sleeve_Render.jpg', 500, 500, 'N'),
(721, '50Eilte_Yellow_Ball_Front_render.jpg', 500, 500, 'N'),
(722, '2163_1.jpg', 850, 850, 'N'),
(723, '2181_1.jpg', 1000, 816, 'N'),
(724, '02xrms-cd.jpg', 300, 300, 'N'),
(725, 'lenny_cover.jpg', 1000, 1000, 'N'),
(739, 'DIR-657_front.jpg', 1224, 1224, 'N'),
(727, 'U2TCD020.jpg', 1500, 1500, 'N'),
(728, '603497948727.sml_0.jpg', 500, 500, 'N'),
(729, 'feedingthemonkies_frntLRG.jpg', 600, 600, 'N'),
(730, 'url_uploaded_file_13287662164f335d096a3ce.jpg', 650, 650, 'N'),
(731, 'feedingthemonkies_bckLRG.jpg', 600, 600, 'N'),
(732, 'bbk_onekindfavorcdcover_sm.jpg', 500, 500, 'N'),
(733, 'bbk_originalhitscd.jpg', 500, 500, 'N'),
(734, 'url_uploaded_file_13287719184f33734f6b3e9.jpg', 1426, 1413, 'N'),
(735, 'url_uploaded_file_13287720374f3373c6eef1f.jpg', 600, 600, 'N'),
(736, 'cover1.jpg', 500, 500, 'N'),
(737, 'cover113287723384f3374f2d5491.jpg', 500, 500, 'N'),
(738, '5OCD09.jpg', 600, 600, 'N'),
(740, 'DIR-657_back.jpg', 800, 746, 'N'),
(741, 'DIR-657_package.jpg', 800, 600, 'N'),
(742, 'DIR-657_side.jpg', 1040, 922, 'N'),
(743, 'hyyfnOGfxDQXnGM0_500.jpg', 1680, 1187, 'N'),
(744, '6f2jZfBiIngiA5w9_500.jpg', 1574, 1134, 'N'),
(745, 'lLazPZxUGkwbxiMD_500.jpg', 1500, 1500, 'N'),
(746, '8nGC9Ie9LzTeYwhG_500.jpg', 800, 800, 'N'),
(747, 'Wfx1S8niGkMLf4J6_500.jpg', 800, 880, 'N'),
(748, 'KAFs4kAWJIJzo9Wn_500.jpg', 1024, 1238, 'N'),
(749, 'oddRDU1adeGw7hzT_500.jpg', 1514, 1833, 'N'),
(750, 'P_500.jpg', 500, 500, 'N'),
(751, 'QsZIfPvMYSFALNDL_500.jpg', 1280, 1280, 'N'),
(752, 'r8eFbY8vK54nOPhI_500.jpg', 800, 800, 'N'),
(753, '0um2OBCCu8446Wls_500.jpg', 500, 500, 'N'),
(754, 'TL-SC3430-01.jpg', 800, 800, 'N'),
(755, 'TL-SC3430-02.jpg', 1000, 1000, 'N'),
(756, 'TL-SC3430-03.jpg', 800, 600, 'N'),
(757, 'TL-SC3430-04.jpg', 500, 500, 'N'),
(758, 'l2698a_300.jpg', 500, 500, 'N'),
(759, 'cn216a_main.jpg', 500, 500, 'N'),
(760, 'cn577a_main.jpg', 500, 500, 'N'),
(761, '0120b3d3-82ef-4d27-8d43-9d75b4db19a1.jpg', 700, 525, 'N'),
(762, '4a3aa57f-6894-47b9-86d5-5ba73e9fd732.jpg', 700, 525, 'N'),
(763, 'adc9c3b2-94d7-4e17-a1d6-f2c29448bc4e.jpg', 700, 525, 'N'),
(764, 'imageservice.jpg', 1732, 2182, 'N'),
(765, 'P_50013287768924f3386bc5fe80.jpg', 500, 500, 'N'),
(766, 'nDMJWQLHhMN4fi8b_500.jpg', 500, 500, 'N'),
(767, 'b3k0951cYIyn1LDE_500.jpg', 500, 500, 'N'),
(768, 'vx8EzIhsyOV81i8h_500.jpg', 735, 750, 'N'),
(769, 'uMhBLQB2lSbT9kBm_500.jpg', 1000, 1000, 'N'),
(833, 'HN274H_350x250.jpg', 500, 500, 'N'),
(771, 'imageservice13287772554f338827bf601.jpg', 1000, 1000, 'N'),
(772, 'P_50013287772614f33882d85395.jpg', 500, 500, 'N'),
(773, 'YG1btKkZMPz16ZnZ_500.jpg', 1300, 1300, 'N'),
(774, 'xMTkMl6sfppE75Wt_500.jpg', 1300, 1300, 'N'),
(775, 'XDhwZOlu58p5FmeS_500.jpg', 500, 500, 'N'),
(776, 'P_50013287774434f3388e3b9edd.jpg', 500, 500, 'N'),
(777, 'w91u59ZCZzPzZ8RO_500.jpg', 500, 500, 'N'),
(778, 'OTPci8iqEoHfq8rX_500.jpg', 500, 500, 'N'),
(779, 'nO6yAKoQVtSOrbZv_500.jpg', 500, 500, 'N'),
(780, '300V5A_Raspberry-Pink_04_6.jpg', 600, 600, 'N'),
(781, '300V5A_Raspberry-Pink_02_2.jpg', 600, 600, 'N'),
(782, '300V5A_Raspberry-Pink_05.jpg', 600, 600, 'N'),
(783, '700Z-side_back_open-01.jpg', 900, 600, 'N'),
(784, '700Z3A_01_2.jpg', 600, 600, 'N'),
(785, '700Z3A_06.jpg', 600, 600, 'N'),
(786, '700Z3A_02.jpg', 600, 600, 'N'),
(787, '700Z3A_03_2.jpg', 600, 600, 'N'),
(788, '700Z3A_09_2.jpg', 600, 600, 'N'),
(789, '700Z3A_05.jpg', 600, 600, 'N'),
(790, '700Z3A_08.jpg', 600, 600, 'N'),
(791, '700Z3A_07_2.jpg', 600, 600, 'N'),
(792, '700Z-side_back_open-03.jpg', 1000, 749, 'N'),
(793, '700Z-side_front_open-01_2.jpg', 980, 735, 'N'),
(794, '700Z-side-01_2.jpg', 600, 600, 'N'),
(795, '9-Series-Laptop_04_4.jpg', 1024, 768, 'N'),
(796, '9-Series-Laptop_11_2.jpg', 850, 850, 'N'),
(797, '9-Series-Laptop_07_2.jpg', 600, 600, 'N'),
(798, '9-Series-Laptop_12_2.jpg', 1200, 1200, 'N'),
(799, '9-Series-Laptop_05_2.jpg', 1024, 1024, 'N'),
(800, '9-Series-Laptop_09_2.jpg', 600, 600, 'N'),
(801, '9-Series-Laptop_02_2.jpg', 1024, 1024, 'N'),
(802, '9-Series-Laptop_08_2.jpg', 600, 600, 'N'),
(803, '9-Series-Laptop_10_2.jpg', 600, 600, 'N'),
(804, '9-Series-Laptop_13_2.jpg', 600, 600, 'N'),
(805, '9-Series-Laptop_14_2.jpg', 1200, 843, 'N'),
(806, '600x600_NP300E5A-A01_main.jpg', 600, 600, 'N'),
(807, '600x600_front.jpg', 600, 600, 'N'),
(808, '600x600_angle.jpg', 600, 600, 'N'),
(809, 'p7310_400x400_large1_cf_1.jpg', 728, 546, 'N'),
(810, 'p7310_600x600_xlarge_vf.jpg', 600, 600, 'N'),
(811, 'p7310_600x600_xlarge_bk.jpg', 1200, 1200, 'N'),
(812, 'p7310_600x600_xlarge_s2.jpg', 600, 600, 'N'),
(813, 'p7310_600x600_xlarge_vf_1.jpg', 600, 600, 'N'),
(814, 'p7310_600x600_xlarge_vl.jpg', 640, 480, 'N'),
(815, 'p7310_600x600_xlarge_hl.jpg', 850, 700, 'N'),
(816, 'i957_600x600_xlarge_hf.jpg', 600, 600, 'N'),
(817, 'i957_600x600_xlarge_hl.jpg', 600, 600, 'N'),
(818, 'i957_600x600_xlarge_s2.jpg', 600, 600, 'N'),
(819, 'i957_600x600_xlarge_vb.jpg', 600, 600, 'N'),
(820, 'i957_600x600_xlarge_vf.jpg', 600, 600, 'N'),
(821, 'i957_600x600_xlarge_vl.jpg', 600, 600, 'N'),
(822, 'Ver_Galaxy_Tab_front2_5.jpg', 1000, 1000, 'N'),
(823, 'Ver_Galaxy_Tab_extbackleft_8.jpg', 600, 600, 'N'),
(824, 'Ver_Galaxy_Tab_horizback_10.jpg', 600, 600, 'N'),
(825, 'Ver_Galaxy_Tab_extbackright_6.jpg', 600, 600, 'N'),
(826, 'Ver_Galaxy_Tab_extleft2_2.jpg', 600, 600, 'N'),
(827, 'Ver_Galaxy_Tab_right2_2.jpg', 637, 606, 'N'),
(828, 'Ver_Galaxy_Tab_extright2.jpg', 600, 600, 'N'),
(829, 'Ver_Galaxy_Tab_left2_1.jpg', 600, 600, 'N'),
(830, 'Ver_Galaxy_Tab_horizfront2.jpg', 680, 680, 'N'),
(831, 'Ver_Galaxy_Tab_side1_6.jpg', 600, 600, 'N'),
(832, 'imageservice_(1).jpg', 1500, 1924, 'N'),
(834, 'large01.jpg', 1400, 1400, 'N'),
(835, 'large02.jpg', 1024, 576, 'N'),
(836, 'large03.jpg', 750, 750, 'N'),
(837, 'large04.jpg', 1772, 1158, 'N'),
(838, 'xp600aa_300.jpg', 1000, 1000, 'N'),
(839, 'url_uploaded_file_13287871234f33aeb3d0793.jpg', 1000, 1000, 'N'),
(840, 'url_uploaded_file_13287871534f33aed1a26d2.jpg', 850, 518, 'N'),
(841, 'url_uploaded_file_13287871534f33aed237cf7.jpg', 850, 518, 'N'),
(842, 'url_uploaded_file_13287872334f33af2276de4.jpg', 1095, 1095, 'N'),
(843, 'url_uploaded_file_13287872754f33af4c7159c.jpg', 1095, 1095, 'N'),
(844, 'url_uploaded_file_13287872754f33af4d0657a.jpg', 850, 518, 'N'),
(845, 'url_uploaded_file_13287873494f33af96095d8.jpg', 1000, 1000, 'N'),
(846, 'url_uploaded_file_13287873674f33afa7f19d6.jpg', 850, 518, 'N'),
(847, '2000004455_500.jpg', 500, 500, 'N'),
(848, '2000004453_500.jpg', 500, 500, 'N'),
(849, '2000004467_500.jpg', 500, 500, 'N'),
(850, '2000001597_500.jpg', 500, 500, 'N'),
(851, '2000004674_500.jpg', 500, 500, 'N'),
(852, '2000004674_500a.jpg', 500, 500, 'N'),
(853, '2000004674_500b.jpg', 500, 500, 'N'),
(854, 'white-iphone-hi.jpg', 1000, 1000, 'N'),
(855, 'iphone-smartphone-hi.jpg', 500, 596, 'N'),
(856, 'white-iphone-hi.jpg', 1000, 1000, 'N'),
(857, 'apple-ipod-hi.jpg', 700, 700, 'N'),
(858, 'ipod-shuffle-hi.jpg', 600, 521, 'N'),
(862, '242265_01.jpg', 500, 500, 'N'),
(861, '173283_01.jpg', 500, 500, 'N'),
(863, 'X29580_01.jpg', 500, 500, 'N'),
(879, '173283_0113298267324f438bac97eaf.jpg', 500, 500, 'N'),
(898, 'X41181_01.jpg', 2400, 2400, 'N'),
(881, 'X41182_01.jpg', 500, 500, 'N'),
(882, 'X41187_01.jpg', 500, 500, 'N'),
(904, 'ipad-black-1.jpg', 536, 742, 'N'),
(907, 'ipad-white-1.jpg', 536, 742, 'N'),
(905, 'ipad-black-2.jpg', 536, 742, 'N'),
(906, 'ipad-black-3.jpg', 536, 742, 'N'),
(908, 'ipad-white-2.jpg', 536, 742, 'N'),
(909, 'ipad-white-3.jpg', 536, 742, 'N'),
(926, 'clip_plus_black.jpg', 500, 500, 'N'),
(1006, 'Adidas_Logo.svg.png', 200, 133, 'N'),
(1007, '200px-Logo_NIKE.svg.png', 200, 72, 'N'),
(1008, '200px-ASUS_Logo.svg.png', 200, 35, 'N'),
(1009, 'Samsung_Logo.svg.png', 200, 68, 'N'),
(1010, 'Universal_Music_Group.svg.png', 225, 85, 'N'),
(1011, 'Apple_logo_black.svg.png', 150, 180, 'N'),
(1012, '250px-Acer_2011.svg.png', 250, 60, 'N'),
(1013, '150px-HP_logo_2012.svg.png', 150, 150, 'N'),
(1014, 'LG_Logo.svg.png', 200, 95, 'N'),
(1015, '250px-D-Link.svg.png', 250, 75, 'N'),
(1016, 'Concordjazzlogo.png', 68, 67, 'N'),
(1017, 'TP-Link_logo.jpg', 220, 61, 'N'),
(1018, 'Panasonic_logo_(Blue).svg.png', 220, 52, 'N'),
(1019, '230px-Pioneer_logo.svg.png', 230, 34, 'N'),
(1020, '190px-TomTom.svg.png', 190, 41, 'N'),
(1021, '225px-Garmin_logo.svg.png', 225, 61, 'N'),
(1022, '175px-Company-Logo-of-Kenwood001.png', 175, 34, 'N'),
(1023, 'cobra-logo.jpg', 152, 48, 'N'),
(1024, '225px-Roadrunner_Records_Logo.svg.png', 225, 68, 'N'),
(1025, '200px-Toshiba_logo.svg.png', 200, 31, 'N'),
(1026, 'Rhinologo_whiteonwhite.png', 150, 79, 'N'),
(1027, '200px-Htc_new_logo.svg.png', 200, 111, 'N'),
(1028, '250px-Motorola.svg.png', 250, 47, 'N'),
(1029, 'Nokia_wordmark.svg.png', 200, 34, 'N'),
(1030, 'Creative_Technology_logo.svg.png', 200, 45, 'N'),
(1031, '200px-YamahaCorp.svg.png', 200, 45, 'N'),
(1032, 'Entertainment_One_logo.svg.png', 150, 172, 'N'),
(1033, 'Sony_logo.svg.png', 220, 37, 'N'),
(1034, 'koss_logo.jpg', 300, 88, 'N'),
(1035, 'Nikon_logo.svg.png', 150, 150, 'N'),
(1036, '79085903.jpg', 150, 48, 'N'),
(1037, '200px-Warner_Bros.svg.png', 200, 209, 'N'),
(1038, '200px-Warner_Bros.svg.png', 200, 209, 'N'),
(1039, 'Arc_system_works.jpg', 64, 65, 'N'),
(1040, 'SanDisk_Logo_2007.svg.png', 200, 40, 'N'),
(1041, '230px-Namco_logo.svg.png', 230, 32, 'N'),
(1042, 'Namco_Bandai_Games_Logo.png', 243, 222, 'N'),
(1043, '220px-Capcom_logo.svg.png', 220, 40, 'N'),
(1044, 'Casio_logo.svg.png', 250, 50, 'N'),
(1045, 'Quartet_Logo_jpg.jpg', 250, 92, 'N'),
(1046, 'Swingline_Logo.jpg', 200, 53, 'N'),
(1047, 'logo_wilsonjones.gif', 204, 112, 'N'),
(1048, 'aiko_safe_t.gif', 80, 50, 'N'),
(1051, 'Clevelandgolf_logo.png', 320, 128, 'N'),
(1052, 'CamelBak_Logo.jpg', 150, 48, 'N'),
(1053, 'Wilson_Staff_Logo.jpg', 274, 292, 'N'),
(1054, 'Montblanc_logo.png', 85, 46, 'N'),
(1055, 'Tissot_Logo.svg.png', 85, 31, 'N'),
(1057, 'Intel-logo.jpg', 323, 300, 'N'),
(1058, 'pocket_bell.jpg', 700, 700, 'N'),
(1062, 'iphone_green.png', 600, 600, 'N'),
(1061, 'pocket_bell2.jpg', 700, 700, 'N'),
(1063, 'iphone_5c2.png', 600, 600, 'N'),
(1064, 'iphones_5c.png', 600, 600, 'N'),
(1065, 'go_pro.png', 600, 600, 'N'),
(1066, 'go_pro_2.png', 600, 600, 'N'),
(1067, 'go_pro_3.png', 600, 600, 'N'),
(1068, 'go_pro_4.png', 600, 600, 'N'),
(1069, 'gopro-logo-whitebgd.jpg', 288, 90, 'N'),
(1074, '1.png', 894, 305, 'N'),
(1073, '2_en_1.png', 894, 305, 'N'),
(1072, '3_en_1.png', 894, 305, 'N'),
(1279, 'comp.png', 60, 48, 'N'),
(1280, 'cars.png', 60, 48, 'N'),
(1281, 'mp3.png', 60, 48, 'N'),
(1282, 'cell.png', 60, 48, 'N'),
(1283, 'tv.png', 60, 48, 'N'),
(1284, 'camera.png', 60, 48, 'N'),
(1285, 'nokia_n1_perspectives_-_app.jpg', 5000, 3096, 'N'),
(1286, 'nokia-n1-tablet-thin.jpg', 780, 112, 'N'),
(1287, 'nokia-n1.jpg', 1702, 1100, 'N'),
(1288, 'a05b922ffd50ee0d1818527e9d4a.jpg', 900, 548, 'N'),
(1187, 'i.jpg', 478, 616, 'N'),
(1188, 'i_(1).jpg', 280, 160, 'N'),
(1189, 'i_(2).jpg', 280, 85, 'N'),
(1190, 'i_(3).jpg', 701, 245, 'N'),
(1191, 'i_(4).jpg', 701, 615, 'N'),
(1386, '664187.jpg', 295, 249, 'N'),
(1270, 'ea.png', 152, 151, 'N'),
(1220, '1.png', 256, 144, 'N'),
(1226, '1.jpg', 120, 120, 'N'),
(1223, 'nintendo.jpg', 156, 117, 'N'),
(8644, 'promotion_coupon.jpg', 770, 471, 'N'),
(8643, 'promotion_pickup.jpg', 770, 471, 'N'),
(8642, 'promotion_xbox_one.jpg', 770, 471, 'N'),
(8640, 'promotion_10_for_demo.jpg', 770, 471, 'N'),
(8639, 'promotion_free_shipping.jpg', 770, 471, 'N'),
(8645, 'cart.png', 300, 49, 'N'),
(8646, 'favicon.ico', 48, 48, 'N'),
(8647, 'invoice_logo.png', 300, 49, 'N'),
(8648, 'gift_cert_logo.png', 176, 42, 'N'),
(1396, 't-13.jpg', 2400, 2838, 'N'),
(1397, 't-6.jpg', 400, 543, 'N'),
(1398, 't-3.jpg', 400, 543, 'N'),
(1399, 't-10.jpg', 1000, 1182, 'N'),
(1400, 't-11.jpg', 700, 700, 'N'),
(1401, 't-4.jpg', 2300, 2415, 'N'),
(1402, 't-12.jpg', 1500, 1500, 'N'),
(1403, 't-8.jpg', 1500, 1500, 'N'),
(1404, 't-2.jpg', 2300, 2415, 'N'),
(1405, 't-7.jpg', 1500, 1500, 'N'),
(1406, 't-5.jpg', 1500, 1500, 'N'),
(1407, 't-9.jpg', 700, 700, 'N'),
(8649, '3.jpg', 500, 500, 'N'),
(8650, '1.jpg', 800, 800, 'N'),
(8651, '2.jpg', 500, 500, 'N'),
(1076, 'gift_certificate.png', 1200, 136, 'N'),
(1077, 'holiday_gift.png', 900, 175, 'N'),
(1300, 'banner-en-sale-40-80.png', 740, 395, 'N'),
(1301, 'banner-en-xbox360.png', 740, 395, 'N'),
(1302, 'banner-en-point.png', 740, 395, 'N'),
(1303, 'banner-en-girl.png', 740, 395, 'N'),
(1304, 'banner_en_free_ship_lies-pz.png', 434, 185, 'N'),
(1305, 'banner_en_pickup_ok56-7h.png', 434, 185, 'N'),
(8633, 'banner_acme_mobile.jpg', 770, 471, 'N'),
(8634, 'banner_multivendor_mobile.jpg', 770, 471, 'N'),
(8632, 'banner_x-box_mobile.jpg', 770, 471, 'N');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]images_links`
--

CREATE TABLE `[[dbprefix]]images_links` (
  `pair_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `object_id` int(11) unsigned NOT NULL DEFAULT '0',
  `object_type` varchar(24) NOT NULL DEFAULT '',
  `image_id` int(11) unsigned NOT NULL DEFAULT '0',
  `detailed_id` int(11) unsigned NOT NULL DEFAULT '0',
  `type` char(1) NOT NULL DEFAULT 'M',
  `position` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pair_id`),
  KEY `object_id` (`object_id`,`object_type`,`type`),
  KEY `detailed_id` (`detailed_id`),
  KEY `image_id` (`image_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3262 ;

--
-- Dumping data for table `[[dbprefix]]images_links`
--

INSERT INTO `[[dbprefix]]images_links` VALUES
(181, 1, 'product', 0, 237, 'M', 0),
(182, 1, 'product', 0, 238, 'A', 0),
(183, 1, 'product', 0, 239, 'A', 0),
(184, 1, 'product', 0, 240, 'A', 0),
(187, 4, 'product', 0, 243, 'M', 0),
(188, 4, 'product', 0, 244, 'A', 0),
(189, 4, 'product', 0, 245, 'A', 0),
(190, 5, 'product', 0, 246, 'M', 0),
(191, 5, 'product', 0, 247, 'A', 0),
(192, 5, 'product', 0, 248, 'A', 0),
(193, 5, 'product', 0, 249, 'A', 0),
(194, 5, 'product', 0, 250, 'A', 0),
(195, 6, 'product', 0, 251, 'M', 0),
(196, 7, 'product', 0, 252, 'M', 0),
(198, 6, 'product', 0, 254, 'A', 0),
(199, 6, 'product', 0, 255, 'A', 0),
(200, 6, 'product', 0, 256, 'A', 0),
(201, 8, 'product', 0, 257, 'M', 0),
(202, 8, 'product', 0, 258, 'A', 0),
(203, 8, 'product', 0, 259, 'A', 0),
(204, 8, 'product', 0, 260, 'A', 0),
(205, 9, 'product', 0, 261, 'M', 0),
(206, 9, 'product', 0, 262, 'A', 0),
(207, 9, 'product', 0, 263, 'A', 0),
(208, 9, 'product', 0, 264, 'A', 0),
(209, 10, 'product', 0, 265, 'M', 0),
(210, 11, 'product', 0, 266, 'M', 0),
(211, 11, 'product', 0, 267, 'A', 0),
(212, 10, 'product', 0, 268, 'A', 0),
(213, 10, 'product', 0, 269, 'A', 0),
(214, 10, 'product', 0, 270, 'A', 0),
(215, 10, 'product', 0, 271, 'A', 0),
(218, 13, 'product', 0, 274, 'M', 0),
(219, 14, 'product', 0, 275, 'M', 0),
(220, 14, 'product', 0, 276, 'A', 0),
(221, 14, 'product', 0, 277, 'A', 0),
(222, 14, 'product', 0, 278, 'A', 0),
(223, 14, 'product', 0, 279, 'A', 0),
(224, 15, 'product', 0, 280, 'M', 0),
(225, 15, 'product', 0, 281, 'A', 0),
(226, 16, 'product', 0, 282, 'M', 0),
(227, 16, 'product', 0, 283, 'A', 0),
(228, 16, 'product', 0, 284, 'A', 0),
(229, 17, 'product', 0, 285, 'M', 0),
(230, 18, 'product', 0, 286, 'M', 0),
(231, 18, 'product', 0, 287, 'A', 0),
(232, 19, 'product', 0, 288, 'M', 0),
(233, 19, 'product', 0, 289, 'A', 0),
(234, 19, 'product', 0, 290, 'A', 0),
(235, 19, 'product', 0, 291, 'A', 0),
(236, 20, 'product', 0, 292, 'M', 0),
(237, 21, 'product', 0, 293, 'M', 0),
(238, 21, 'product', 0, 294, 'A', 0),
(239, 22, 'product', 0, 295, 'M', 0),
(240, 23, 'product', 0, 296, 'M', 0),
(241, 24, 'product', 0, 297, 'M', 0),
(242, 24, 'product', 0, 298, 'A', 0),
(243, 25, 'product', 0, 299, 'M', 0),
(244, 26, 'product', 0, 300, 'M', 0),
(245, 27, 'product', 0, 301, 'M', 0),
(246, 27, 'product', 0, 302, 'A', 0),
(247, 28, 'product', 0, 303, 'M', 0),
(248, 28, 'product', 0, 304, 'A', 0),
(249, 29, 'product', 0, 305, 'M', 0),
(250, 29, 'product', 0, 306, 'A', 0),
(251, 29, 'product', 0, 307, 'A', 0),
(252, 29, 'product', 0, 308, 'A', 0),
(253, 29, 'product', 0, 309, 'A', 0),
(254, 30, 'product', 0, 310, 'M', 0),
(255, 31, 'product', 0, 311, 'M', 0),
(256, 31, 'product', 0, 312, 'A', 0),
(257, 30, 'product', 0, 313, 'A', 0),
(258, 30, 'product', 0, 314, 'A', 0),
(259, 30, 'product', 0, 315, 'A', 0),
(260, 32, 'product', 0, 316, 'M', 0),
(261, 32, 'product', 0, 317, 'A', 0),
(262, 32, 'product', 0, 318, 'A', 0),
(263, 33, 'product', 0, 319, 'M', 0),
(264, 34, 'product', 0, 320, 'M', 0),
(265, 34, 'product', 0, 321, 'A', 0),
(266, 33, 'product', 0, 322, 'A', 0),
(267, 33, 'product', 0, 323, 'A', 0),
(268, 35, 'product', 0, 324, 'M', 0),
(269, 36, 'product', 0, 325, 'M', 0),
(271, 37, 'product', 0, 327, 'M', 0),
(272, 38, 'product', 0, 328, 'M', 0),
(273, 38, 'product', 0, 329, 'A', 0),
(274, 39, 'product', 0, 330, 'M', 0),
(275, 39, 'product', 0, 331, 'A', 0),
(276, 39, 'product', 0, 332, 'A', 0),
(277, 39, 'product', 0, 333, 'A', 0),
(278, 40, 'product', 0, 334, 'M', 0),
(279, 40, 'product', 0, 335, 'A', 0),
(280, 40, 'product', 0, 336, 'A', 0),
(281, 40, 'product', 0, 337, 'A', 0),
(282, 40, 'product', 0, 338, 'A', 0),
(283, 41, 'product', 0, 339, 'M', 0),
(284, 41, 'product', 0, 340, 'A', 0),
(285, 42, 'product', 0, 341, 'M', 0),
(286, 42, 'product', 0, 342, 'A', 0),
(287, 42, 'product', 0, 343, 'A', 0),
(288, 43, 'product', 0, 344, 'M', 0),
(289, 43, 'product', 0, 345, 'A', 0),
(290, 43, 'product', 0, 346, 'A', 0),
(291, 43, 'product', 0, 347, 'A', 0),
(292, 43, 'product', 0, 348, 'A', 0),
(293, 44, 'product', 0, 349, 'M', 0),
(294, 45, 'product', 0, 350, 'M', 0),
(295, 46, 'product', 0, 351, 'M', 0),
(296, 47, 'product', 0, 352, 'M', 0),
(297, 47, 'product', 0, 353, 'A', 0),
(298, 48, 'product', 0, 354, 'M', 0),
(299, 49, 'product', 0, 355, 'M', 0),
(300, 50, 'product', 0, 356, 'M', 0),
(301, 50, 'product', 0, 357, 'A', 0),
(302, 50, 'product', 0, 358, 'A', 0),
(303, 50, 'product', 0, 359, 'A', 0),
(304, 51, 'product', 0, 360, 'M', 0),
(305, 52, 'product', 0, 361, 'M', 0),
(306, 53, 'product', 0, 362, 'M', 0),
(307, 54, 'product', 0, 363, 'M', 0),
(308, 55, 'product', 0, 364, 'M', 0),
(309, 55, 'product', 0, 365, 'A', 0),
(310, 55, 'product', 0, 366, 'A', 0),
(311, 55, 'product', 0, 367, 'A', 0),
(312, 56, 'product', 0, 368, 'M', 0),
(313, 56, 'product', 0, 369, 'A', 0),
(314, 57, 'product', 0, 370, 'M', 0),
(315, 57, 'product', 0, 371, 'A', 0),
(316, 58, 'product', 0, 372, 'M', 0),
(317, 58, 'product', 0, 373, 'A', 0),
(318, 58, 'product', 0, 374, 'A', 0),
(319, 58, 'product', 0, 375, 'A', 0),
(320, 58, 'product', 0, 376, 'A', 0),
(321, 58, 'product', 0, 377, 'A', 0),
(322, 58, 'product', 0, 378, 'A', 0),
(323, 59, 'product', 0, 379, 'M', 0),
(324, 59, 'product', 0, 380, 'A', 0),
(325, 59, 'product', 0, 381, 'A', 0),
(326, 59, 'product', 0, 382, 'A', 0),
(327, 59, 'product', 0, 383, 'A', 0),
(328, 60, 'product', 0, 384, 'M', 0),
(329, 60, 'product', 0, 385, 'A', 0),
(330, 60, 'product', 0, 386, 'A', 0),
(334, 62, 'product', 0, 390, 'M', 0),
(335, 63, 'product', 0, 391, 'M', 0),
(336, 64, 'product', 0, 392, 'M', 0),
(337, 65, 'product', 0, 393, 'M', 0),
(338, 66, 'product', 0, 394, 'M', 0),
(339, 67, 'product', 0, 395, 'M', 0),
(340, 67, 'product', 0, 396, 'A', 0),
(341, 67, 'product', 0, 397, 'A', 0),
(342, 67, 'product', 0, 398, 'A', 0),
(343, 68, 'product', 0, 399, 'M', 0),
(344, 68, 'product', 0, 400, 'A', 0),
(345, 68, 'product', 0, 401, 'A', 0),
(346, 68, 'product', 0, 402, 'A', 0),
(347, 68, 'product', 0, 403, 'A', 0),
(348, 68, 'product', 0, 404, 'A', 0),
(349, 68, 'product', 0, 405, 'A', 0),
(350, 68, 'product', 0, 406, 'A', 0),
(351, 68, 'product', 0, 407, 'A', 0),
(352, 69, 'product', 0, 408, 'M', 0),
(353, 69, 'product', 0, 409, 'A', 0),
(354, 69, 'product', 0, 410, 'A', 0),
(355, 69, 'product', 0, 411, 'A', 0),
(356, 69, 'product', 0, 412, 'A', 0),
(357, 70, 'product', 0, 413, 'M', 0),
(358, 70, 'product', 0, 414, 'A', 0),
(359, 70, 'product', 0, 415, 'A', 0),
(360, 70, 'product', 0, 416, 'A', 0),
(361, 70, 'product', 0, 417, 'A', 0),
(362, 71, 'product', 0, 418, 'M', 0),
(363, 71, 'product', 0, 419, 'A', 0),
(364, 71, 'product', 0, 420, 'A', 0),
(365, 71, 'product', 0, 421, 'A', 0),
(366, 71, 'product', 0, 422, 'A', 0),
(367, 72, 'product', 0, 423, 'M', 0),
(368, 72, 'product', 0, 424, 'A', 0),
(369, 72, 'product', 0, 425, 'A', 0),
(370, 72, 'product', 0, 426, 'A', 0),
(371, 72, 'product', 0, 427, 'A', 0),
(372, 73, 'product', 0, 428, 'M', 0),
(373, 73, 'product', 0, 429, 'A', 0),
(374, 73, 'product', 0, 430, 'A', 0),
(375, 73, 'product', 0, 431, 'A', 0),
(376, 73, 'product', 0, 432, 'A', 0),
(377, 74, 'product', 0, 433, 'M', 0),
(378, 74, 'product', 0, 434, 'A', 0),
(379, 74, 'product', 0, 435, 'A', 0),
(380, 74, 'product', 0, 436, 'A', 0),
(381, 74, 'product', 0, 437, 'A', 0),
(382, 75, 'product', 0, 438, 'M', 0),
(383, 75, 'product', 0, 439, 'A', 0),
(384, 75, 'product', 0, 440, 'A', 0),
(385, 75, 'product', 0, 441, 'A', 0),
(386, 75, 'product', 0, 442, 'A', 0),
(387, 76, 'product', 0, 443, 'M', 0),
(388, 76, 'product', 0, 444, 'A', 0),
(389, 76, 'product', 0, 445, 'A', 0),
(390, 76, 'product', 0, 446, 'A', 0),
(391, 76, 'product', 0, 447, 'A', 0),
(466, 117, 'product', 0, 522, 'M', 0),
(469, 117, 'product', 0, 525, 'A', 0),
(468, 117, 'product', 0, 524, 'A', 0),
(467, 118, 'product', 0, 523, 'M', 0),
(397, 78, 'product', 0, 453, 'M', 0),
(398, 78, 'product', 0, 454, 'A', 0),
(399, 78, 'product', 0, 455, 'A', 0),
(400, 78, 'product', 0, 456, 'A', 0),
(401, 78, 'product', 0, 457, 'A', 0),
(402, 79, 'product', 0, 458, 'M', 0),
(403, 79, 'product', 0, 459, 'A', 0),
(404, 79, 'product', 0, 460, 'A', 0),
(405, 79, 'product', 0, 461, 'A', 0),
(406, 79, 'product', 0, 462, 'A', 0),
(407, 80, 'product', 0, 463, 'M', 0),
(408, 80, 'product', 0, 464, 'A', 0),
(409, 81, 'product', 0, 465, 'M', 0),
(410, 81, 'product', 0, 466, 'A', 0),
(411, 81, 'product', 0, 467, 'A', 0),
(412, 82, 'product', 0, 468, 'M', 0),
(413, 83, 'product', 0, 469, 'M', 0),
(414, 84, 'product', 0, 470, 'M', 0),
(415, 85, 'product', 0, 471, 'M', 0),
(454, 86, 'product', 0, 510, 'M', 0),
(417, 87, 'product', 0, 473, 'M', 0),
(418, 88, 'product', 0, 474, 'M', 0),
(419, 89, 'product', 0, 475, 'M', 0),
(420, 90, 'product', 0, 476, 'M', 0),
(421, 91, 'product', 0, 477, 'M', 0),
(422, 91, 'product', 0, 478, 'A', 0),
(423, 91, 'product', 0, 479, 'A', 0),
(424, 91, 'product', 0, 480, 'A', 0),
(425, 91, 'product', 0, 481, 'A', 0),
(426, 92, 'product', 0, 482, 'M', 0),
(427, 92, 'product', 0, 483, 'A', 0),
(428, 92, 'product', 0, 484, 'A', 0),
(429, 92, 'product', 0, 485, 'A', 0),
(430, 93, 'product', 0, 486, 'M', 0),
(431, 94, 'product', 0, 487, 'M', 0),
(432, 95, 'product', 0, 488, 'M', 0),
(433, 96, 'product', 0, 489, 'M', 0),
(455, 110, 'product', 0, 511, 'M', 0),
(435, 97, 'product', 0, 491, 'M', 0),
(458, 113, 'product', 0, 514, 'M', 0),
(459, 113, 'product', 0, 515, 'A', 0),
(439, 100, 'product', 0, 495, 'M', 0),
(461, 113, 'product', 0, 517, 'A', 0),
(460, 113, 'product', 0, 516, 'A', 0),
(442, 101, 'product', 0, 498, 'M', 0),
(457, 112, 'product', 0, 513, 'M', 0),
(444, 102, 'product', 0, 500, 'M', 0),
(445, 103, 'product', 0, 501, 'M', 0),
(446, 104, 'product', 0, 502, 'M', 0),
(447, 105, 'product', 0, 503, 'M', 0),
(448, 106, 'product', 0, 504, 'M', 0),
(463, 114, 'product', 0, 519, 'M', 0),
(462, 113, 'product', 0, 518, 'A', 0),
(451, 107, 'product', 0, 507, 'M', 0),
(452, 108, 'product', 0, 508, 'M', 0),
(453, 109, 'product', 0, 509, 'M', 0),
(456, 111, 'product', 0, 512, 'M', 0),
(464, 115, 'product', 0, 520, 'M', 0),
(465, 116, 'product', 0, 521, 'M', 0),
(470, 117, 'product', 0, 526, 'A', 0),
(471, 117, 'product', 0, 527, 'A', 0),
(472, 117, 'product', 0, 528, 'A', 0),
(473, 117, 'product', 0, 529, 'A', 0),
(474, 119, 'product', 0, 530, 'M', 0),
(475, 120, 'product', 0, 531, 'M', 0),
(476, 121, 'product', 0, 532, 'M', 0),
(477, 122, 'product', 0, 533, 'M', 0),
(478, 123, 'product', 0, 534, 'M', 0),
(479, 124, 'product', 0, 535, 'M', 0),
(480, 120, 'product', 0, 536, 'A', 0),
(481, 120, 'product', 0, 537, 'A', 0),
(482, 120, 'product', 0, 538, 'A', 0),
(483, 120, 'product', 0, 539, 'A', 0),
(484, 120, 'product', 0, 540, 'A', 0),
(485, 125, 'product', 0, 541, 'M', 0),
(486, 126, 'product', 0, 542, 'M', 0),
(487, 125, 'product', 0, 543, 'A', 0),
(488, 125, 'product', 0, 544, 'A', 0),
(489, 125, 'product', 0, 545, 'A', 0),
(490, 125, 'product', 0, 546, 'A', 0),
(491, 125, 'product', 0, 547, 'A', 0),
(492, 127, 'product', 0, 548, 'M', 0),
(493, 127, 'product', 0, 549, 'A', 0),
(494, 127, 'product', 0, 550, 'A', 0),
(495, 127, 'product', 0, 551, 'A', 0),
(496, 127, 'product', 0, 552, 'A', 0),
(497, 127, 'product', 0, 553, 'A', 0),
(498, 128, 'product', 0, 554, 'M', 0),
(499, 129, 'product', 0, 555, 'M', 0),
(500, 129, 'product', 0, 556, 'A', 0),
(501, 129, 'product', 0, 557, 'A', 0),
(502, 129, 'product', 0, 558, 'A', 0),
(503, 130, 'product', 0, 559, 'M', 0),
(504, 131, 'product', 0, 560, 'M', 0),
(505, 131, 'product', 0, 561, 'A', 0),
(506, 131, 'product', 0, 562, 'A', 0),
(507, 132, 'product', 0, 563, 'M', 0),
(516, 133, 'product', 0, 572, 'M', 0),
(509, 132, 'product', 0, 565, 'A', 0),
(510, 132, 'product', 0, 566, 'A', 0),
(511, 132, 'product', 0, 567, 'A', 0),
(512, 132, 'product', 0, 568, 'A', 0),
(513, 132, 'product', 0, 569, 'A', 0),
(514, 132, 'product', 0, 570, 'A', 0),
(515, 132, 'product', 0, 571, 'A', 0),
(517, 133, 'product', 0, 573, 'A', 0),
(518, 133, 'product', 0, 574, 'A', 0),
(519, 133, 'product', 0, 575, 'A', 0),
(520, 133, 'product', 0, 576, 'A', 0),
(521, 133, 'product', 0, 577, 'A', 0),
(522, 133, 'product', 0, 578, 'A', 0),
(523, 133, 'product', 0, 579, 'A', 0),
(524, 134, 'product', 0, 580, 'M', 0),
(525, 135, 'product', 0, 581, 'M', 0),
(526, 136, 'product', 0, 582, 'M', 0),
(527, 137, 'product', 0, 583, 'M', 0),
(528, 138, 'product', 0, 584, 'M', 0),
(529, 139, 'product', 0, 585, 'M', 0),
(530, 140, 'product', 0, 586, 'M', 0),
(531, 141, 'product', 0, 587, 'M', 0),
(532, 142, 'product', 0, 588, 'M', 0),
(533, 143, 'product', 0, 589, 'M', 0),
(534, 144, 'product', 0, 590, 'M', 0),
(535, 145, 'product', 0, 591, 'M', 0),
(536, 147, 'product', 0, 592, 'M', 0),
(537, 148, 'product', 0, 593, 'M', 0),
(538, 148, 'product', 0, 594, 'A', 0),
(539, 149, 'product', 0, 595, 'M', 0),
(540, 150, 'product', 0, 596, 'M', 0),
(541, 151, 'product', 0, 597, 'M', 0),
(542, 152, 'product', 0, 598, 'M', 0),
(543, 153, 'product', 0, 599, 'M', 0),
(544, 153, 'product', 0, 600, 'A', 0),
(545, 149, 'product', 0, 601, 'A', 0),
(546, 154, 'product', 0, 602, 'M', 0),
(547, 154, 'product', 0, 603, 'A', 0),
(548, 155, 'product', 0, 604, 'M', 0),
(549, 155, 'product', 0, 605, 'A', 0),
(550, 155, 'product', 0, 606, 'A', 0),
(551, 155, 'product', 0, 607, 'A', 0),
(552, 155, 'product', 0, 608, 'A', 0),
(553, 156, 'product', 0, 609, 'M', 0),
(554, 156, 'product', 0, 610, 'A', 0),
(555, 157, 'product', 0, 611, 'M', 0),
(556, 157, 'product', 0, 612, 'A', 0),
(557, 158, 'product', 0, 613, 'M', 0),
(558, 159, 'product', 0, 614, 'M', 0),
(559, 160, 'product', 0, 615, 'M', 0),
(560, 161, 'product', 0, 616, 'M', 0),
(561, 162, 'product', 0, 617, 'M', 0),
(562, 161, 'product', 0, 618, 'A', 0),
(563, 161, 'product', 0, 619, 'A', 0),
(564, 161, 'product', 0, 620, 'A', 0),
(565, 161, 'product', 0, 621, 'A', 0),
(566, 161, 'product', 0, 622, 'A', 0),
(567, 161, 'product', 0, 623, 'A', 0),
(568, 161, 'product', 0, 624, 'A', 0),
(569, 161, 'product', 0, 625, 'A', 0),
(570, 161, 'product', 0, 626, 'A', 0),
(571, 163, 'product', 0, 627, 'M', 0),
(572, 163, 'product', 0, 628, 'A', 0),
(573, 163, 'product', 0, 629, 'A', 0),
(574, 163, 'product', 0, 630, 'A', 0),
(575, 163, 'product', 0, 631, 'A', 0),
(576, 163, 'product', 0, 632, 'A', 0),
(577, 163, 'product', 0, 633, 'A', 0),
(578, 163, 'product', 0, 634, 'A', 0),
(579, 163, 'product', 0, 635, 'A', 0),
(580, 163, 'product', 0, 636, 'A', 0),
(581, 163, 'product', 0, 637, 'A', 0),
(582, 163, 'product', 0, 638, 'A', 0),
(583, 163, 'product', 0, 639, 'A', 0),
(584, 163, 'product', 0, 640, 'A', 0),
(585, 164, 'product', 0, 641, 'M', 0),
(586, 164, 'product', 0, 642, 'A', 0),
(587, 164, 'product', 0, 643, 'A', 0),
(588, 164, 'product', 0, 644, 'A', 0),
(589, 165, 'product', 0, 645, 'M', 0),
(590, 165, 'product', 0, 646, 'A', 0),
(591, 165, 'product', 0, 647, 'A', 0),
(592, 165, 'product', 0, 648, 'A', 0),
(593, 166, 'product', 0, 649, 'M', 0),
(594, 166, 'product', 0, 650, 'A', 0),
(595, 166, 'product', 0, 651, 'A', 0),
(596, 166, 'product', 0, 652, 'A', 0),
(597, 167, 'product', 0, 653, 'M', 0),
(598, 167, 'product', 0, 654, 'A', 0),
(599, 167, 'product', 0, 655, 'A', 0),
(600, 167, 'product', 0, 656, 'A', 0),
(601, 168, 'product', 0, 657, 'M', 0),
(602, 168, 'product', 0, 658, 'A', 0),
(603, 168, 'product', 0, 659, 'A', 0),
(604, 168, 'product', 0, 660, 'A', 0),
(605, 169, 'product', 0, 661, 'M', 0),
(606, 169, 'product', 0, 662, 'A', 0),
(607, 169, 'product', 0, 663, 'A', 0),
(608, 169, 'product', 0, 664, 'A', 0),
(609, 169, 'product', 0, 665, 'A', 0),
(610, 170, 'product', 0, 666, 'M', 0),
(611, 170, 'product', 0, 667, 'A', 0),
(612, 170, 'product', 0, 668, 'A', 0),
(613, 170, 'product', 0, 669, 'A', 0),
(614, 171, 'product', 0, 670, 'M', 0),
(615, 172, 'product', 0, 671, 'M', 0),
(616, 172, 'product', 0, 672, 'A', 0),
(617, 172, 'product', 0, 673, 'A', 0),
(618, 172, 'product', 0, 674, 'A', 0),
(619, 172, 'product', 0, 675, 'A', 0),
(620, 172, 'product', 0, 676, 'A', 0),
(621, 172, 'product', 0, 677, 'A', 0),
(622, 173, 'product', 0, 678, 'M', 0),
(623, 174, 'product', 0, 679, 'M', 0),
(624, 173, 'product', 0, 680, 'A', 0),
(625, 173, 'product', 0, 681, 'A', 0),
(626, 173, 'product', 0, 682, 'A', 0),
(627, 173, 'product', 0, 683, 'A', 0),
(628, 173, 'product', 0, 684, 'A', 0),
(629, 173, 'product', 0, 685, 'A', 0),
(630, 173, 'product', 0, 686, 'A', 0),
(631, 175, 'product', 0, 687, 'M', 0),
(632, 176, 'product', 0, 688, 'M', 0),
(633, 175, 'product', 0, 689, 'A', 0),
(634, 175, 'product', 0, 690, 'A', 0),
(635, 175, 'product', 0, 691, 'A', 0),
(636, 175, 'product', 0, 692, 'A', 0),
(637, 175, 'product', 0, 693, 'A', 0),
(638, 175, 'product', 0, 694, 'A', 0),
(639, 175, 'product', 0, 695, 'A', 0),
(640, 175, 'product', 0, 696, 'A', 0),
(641, 177, 'product', 0, 697, 'M', 0),
(642, 177, 'product', 0, 698, 'A', 0),
(643, 177, 'product', 0, 699, 'A', 0),
(644, 177, 'product', 0, 700, 'A', 0),
(645, 178, 'product', 0, 701, 'M', 0),
(646, 179, 'product', 0, 702, 'M', 0),
(647, 179, 'product', 0, 703, 'A', 0),
(648, 179, 'product', 0, 704, 'A', 0),
(649, 179, 'product', 0, 705, 'A', 0),
(650, 180, 'product', 0, 706, 'M', 0),
(651, 181, 'product', 0, 707, 'M', 0),
(652, 181, 'product', 0, 708, 'A', 0),
(653, 181, 'product', 0, 709, 'A', 0),
(654, 181, 'product', 0, 710, 'A', 0),
(655, 181, 'product', 0, 711, 'A', 0),
(656, 182, 'product', 0, 712, 'M', 0),
(657, 183, 'product', 0, 713, 'M', 0),
(658, 184, 'product', 0, 714, 'M', 0),
(659, 184, 'product', 0, 715, 'A', 0),
(660, 185, 'product', 0, 716, 'M', 0),
(661, 186, 'product', 0, 717, 'M', 0),
(662, 187, 'product', 0, 718, 'M', 0),
(663, 188, 'product', 0, 719, 'M', 0),
(664, 188, 'product', 0, 720, 'A', 0),
(665, 188, 'product', 0, 721, 'A', 0),
(666, 189, 'product', 0, 722, 'M', 0),
(667, 190, 'product', 0, 723, 'M', 0),
(668, 191, 'product', 0, 724, 'M', 0),
(669, 192, 'product', 0, 725, 'M', 0),
(683, 205, 'product', 0, 739, 'M', 0),
(671, 194, 'product', 0, 727, 'M', 0),
(672, 195, 'product', 0, 728, 'M', 0),
(673, 196, 'product', 0, 729, 'M', 0),
(674, 197, 'product', 0, 730, 'M', 0),
(675, 196, 'product', 0, 731, 'A', 0),
(676, 198, 'product', 0, 732, 'M', 0),
(677, 199, 'product', 0, 733, 'M', 0),
(678, 200, 'product', 0, 734, 'M', 0),
(679, 201, 'product', 0, 735, 'M', 0),
(680, 202, 'product', 0, 736, 'M', 0),
(681, 203, 'product', 0, 737, 'M', 0),
(682, 204, 'product', 0, 738, 'M', 0),
(684, 205, 'product', 0, 740, 'A', 0),
(685, 205, 'product', 0, 741, 'A', 0),
(686, 205, 'product', 0, 742, 'A', 0),
(687, 206, 'product', 0, 743, 'M', 0),
(688, 206, 'product', 0, 744, 'A', 0),
(689, 206, 'product', 0, 745, 'A', 0),
(690, 206, 'product', 0, 746, 'A', 0),
(691, 206, 'product', 0, 747, 'A', 0),
(692, 206, 'product', 0, 748, 'A', 0),
(693, 206, 'product', 0, 749, 'A', 0),
(694, 207, 'product', 0, 750, 'M', 0),
(695, 207, 'product', 0, 751, 'A', 0),
(696, 207, 'product', 0, 752, 'A', 0),
(697, 207, 'product', 0, 753, 'A', 0),
(698, 208, 'product', 0, 754, 'M', 0),
(699, 208, 'product', 0, 755, 'A', 0),
(700, 208, 'product', 0, 756, 'A', 0),
(701, 208, 'product', 0, 757, 'A', 0),
(702, 209, 'product', 0, 758, 'M', 0),
(703, 210, 'product', 0, 759, 'M', 0),
(704, 211, 'product', 0, 760, 'M', 0),
(705, 212, 'product', 0, 761, 'M', 0),
(706, 212, 'product', 0, 762, 'A', 0),
(707, 212, 'product', 0, 763, 'A', 0),
(708, 213, 'product', 0, 764, 'M', 0),
(709, 214, 'product', 0, 765, 'M', 0),
(710, 214, 'product', 0, 766, 'A', 0),
(711, 214, 'product', 0, 767, 'A', 0),
(712, 214, 'product', 0, 768, 'A', 0),
(713, 214, 'product', 0, 769, 'A', 0),
(777, 227, 'product', 0, 833, 'M', 0),
(715, 215, 'product', 0, 771, 'M', 0),
(716, 217, 'product', 0, 772, 'M', 0),
(717, 217, 'product', 0, 773, 'A', 0),
(718, 217, 'product', 0, 774, 'A', 0),
(719, 217, 'product', 0, 775, 'A', 0),
(720, 218, 'product', 0, 776, 'M', 0),
(721, 218, 'product', 0, 777, 'A', 0),
(722, 218, 'product', 0, 778, 'A', 0),
(723, 218, 'product', 0, 779, 'A', 0),
(724, 219, 'product', 0, 780, 'M', 0),
(725, 219, 'product', 0, 781, 'A', 0),
(726, 219, 'product', 0, 782, 'A', 0),
(727, 220, 'product', 0, 783, 'M', 0),
(728, 220, 'product', 0, 784, 'A', 0),
(729, 220, 'product', 0, 785, 'A', 0),
(730, 220, 'product', 0, 786, 'A', 0),
(731, 220, 'product', 0, 787, 'A', 0),
(732, 220, 'product', 0, 788, 'A', 0),
(733, 220, 'product', 0, 789, 'A', 0),
(734, 220, 'product', 0, 790, 'A', 0),
(735, 220, 'product', 0, 791, 'A', 0),
(736, 220, 'product', 0, 792, 'A', 0),
(737, 220, 'product', 0, 793, 'A', 0),
(738, 220, 'product', 0, 794, 'A', 0),
(739, 221, 'product', 0, 795, 'M', 0),
(740, 221, 'product', 0, 796, 'A', 0),
(741, 221, 'product', 0, 797, 'A', 0),
(742, 221, 'product', 0, 798, 'A', 0),
(743, 221, 'product', 0, 799, 'A', 0),
(744, 221, 'product', 0, 800, 'A', 0),
(745, 221, 'product', 0, 801, 'A', 0),
(746, 221, 'product', 0, 802, 'A', 0),
(747, 221, 'product', 0, 803, 'A', 0),
(748, 221, 'product', 0, 804, 'A', 0),
(749, 221, 'product', 0, 805, 'A', 0),
(750, 222, 'product', 0, 806, 'M', 0),
(751, 222, 'product', 0, 807, 'A', 0),
(752, 222, 'product', 0, 808, 'A', 0),
(753, 223, 'product', 0, 809, 'M', 0),
(754, 223, 'product', 0, 810, 'A', 0),
(755, 223, 'product', 0, 811, 'A', 0),
(756, 223, 'product', 0, 812, 'A', 0),
(757, 223, 'product', 0, 813, 'A', 0),
(758, 223, 'product', 0, 814, 'A', 0),
(759, 223, 'product', 0, 815, 'A', 0),
(760, 224, 'product', 0, 816, 'M', 0),
(761, 224, 'product', 0, 817, 'A', 0),
(762, 224, 'product', 0, 818, 'A', 0),
(763, 224, 'product', 0, 819, 'A', 0),
(764, 224, 'product', 0, 820, 'A', 0),
(765, 224, 'product', 0, 821, 'A', 0),
(766, 225, 'product', 0, 822, 'M', 0),
(767, 225, 'product', 0, 823, 'A', 0),
(768, 225, 'product', 0, 824, 'A', 0),
(769, 225, 'product', 0, 825, 'A', 0),
(770, 225, 'product', 0, 826, 'A', 0),
(771, 225, 'product', 0, 827, 'A', 0),
(772, 225, 'product', 0, 828, 'A', 0),
(773, 225, 'product', 0, 829, 'A', 0),
(774, 225, 'product', 0, 830, 'A', 0),
(775, 225, 'product', 0, 831, 'A', 0),
(776, 226, 'product', 0, 832, 'M', 0),
(778, 228, 'product', 0, 834, 'M', 0),
(779, 228, 'product', 0, 835, 'A', 0),
(780, 228, 'product', 0, 836, 'A', 0),
(781, 228, 'product', 0, 837, 'A', 0),
(782, 229, 'product', 0, 838, 'M', 0),
(783, 230, 'product', 0, 839, 'M', 0),
(784, 230, 'product', 0, 840, 'A', 0),
(785, 230, 'product', 0, 841, 'A', 0),
(786, 231, 'product', 0, 842, 'M', 0),
(787, 231, 'product', 0, 843, 'A', 0),
(788, 231, 'product', 0, 844, 'A', 0),
(789, 232, 'product', 0, 845, 'M', 0),
(790, 232, 'product', 0, 846, 'A', 0),
(791, 233, 'product', 0, 847, 'M', 0),
(792, 234, 'product', 0, 848, 'M', 0),
(793, 235, 'product', 0, 849, 'M', 0),
(794, 236, 'product', 0, 850, 'M', 0),
(795, 237, 'product', 0, 851, 'M', 0),
(796, 237, 'product', 0, 852, 'A', 0),
(797, 237, 'product', 0, 853, 'A', 0),
(799, 238, 'product', 0, 855, 'M', 0),
(800, 239, 'product', 0, 856, 'M', 0),
(801, 242, 'product', 0, 857, 'M', 0),
(802, 243, 'product', 0, 858, 'M', 0),
(805, 17, 'variant_image', 861, 0, 'V', 0),
(806, 18, 'variant_image', 862, 0, 'V', 0),
(807, 19, 'variant_image', 863, 0, 'V', 0),
(823, 12, 'product', 0, 879, 'M', 0),
(842, 36, 'variant_image', 898, 0, 'V', 0),
(825, 37, 'variant_image', 881, 0, 'V', 0),
(826, 38, 'variant_image', 882, 0, 'V', 0),
(848, 240, 'product', 0, 904, 'M', 0),
(851, 241, 'product', 0, 907, 'M', 0),
(849, 240, 'product', 0, 905, 'A', 0),
(850, 240, 'product', 0, 906, 'A', 0),
(852, 241, 'product', 0, 908, 'A', 0),
(853, 241, 'product', 0, 909, 'A', 0),
(870, 146, 'product', 0, 926, 'M', 0),
(875, 86, 'feature_variant', 1006, 0, 'V', 0),
(876, 87, 'feature_variant', 1007, 0, 'V', 0),
(877, 88, 'feature_variant', 1008, 0, 'V', 0),
(878, 89, 'feature_variant', 1009, 0, 'V', 0),
(879, 90, 'feature_variant', 1010, 0, 'V', 0),
(880, 91, 'feature_variant', 1011, 0, 'V', 0),
(881, 92, 'feature_variant', 1012, 0, 'V', 0),
(882, 93, 'feature_variant', 1013, 0, 'V', 0),
(883, 94, 'feature_variant', 1014, 0, 'V', 0),
(884, 95, 'feature_variant', 1015, 0, 'V', 0),
(885, 96, 'feature_variant', 1016, 0, 'V', 0),
(886, 97, 'feature_variant', 1017, 0, 'V', 0),
(887, 98, 'feature_variant', 1018, 0, 'V', 0),
(888, 100, 'feature_variant', 1019, 0, 'V', 0),
(889, 101, 'feature_variant', 1020, 0, 'V', 0),
(890, 102, 'feature_variant', 1021, 0, 'V', 0),
(891, 103, 'feature_variant', 1022, 0, 'V', 0),
(892, 104, 'feature_variant', 1023, 0, 'V', 0),
(893, 105, 'feature_variant', 1024, 0, 'V', 0),
(894, 106, 'feature_variant', 1025, 0, 'V', 0),
(895, 107, 'feature_variant', 1026, 0, 'V', 0),
(896, 108, 'feature_variant', 1027, 0, 'V', 0),
(897, 109, 'feature_variant', 1028, 0, 'V', 0),
(898, 110, 'feature_variant', 1029, 0, 'V', 0),
(899, 111, 'feature_variant', 1030, 0, 'V', 0),
(900, 112, 'feature_variant', 1031, 0, 'V', 0),
(901, 113, 'feature_variant', 1032, 0, 'V', 0),
(902, 114, 'feature_variant', 1033, 0, 'V', 0),
(903, 115, 'feature_variant', 1034, 0, 'V', 0),
(904, 117, 'feature_variant', 1035, 0, 'V', 0),
(905, 116, 'feature_variant', 1036, 0, 'V', 0),
(906, 118, 'feature_variant', 1037, 0, 'V', 0),
(907, 119, 'feature_variant', 1038, 0, 'V', 0),
(908, 120, 'feature_variant', 1039, 0, 'V', 0),
(909, 121, 'feature_variant', 1040, 0, 'V', 0),
(910, 122, 'feature_variant', 1041, 0, 'V', 0),
(911, 123, 'feature_variant', 1042, 0, 'V', 0),
(912, 124, 'feature_variant', 1043, 0, 'V', 0),
(913, 125, 'feature_variant', 1044, 0, 'V', 0),
(914, 126, 'feature_variant', 1045, 0, 'V', 0),
(915, 127, 'feature_variant', 1046, 0, 'V', 0),
(916, 128, 'feature_variant', 1047, 0, 'V', 0),
(917, 129, 'feature_variant', 1048, 0, 'V', 0),
(918, 130, 'feature_variant', 1051, 0, 'V', 0),
(919, 131, 'feature_variant', 1052, 0, 'V', 0),
(920, 132, 'feature_variant', 1053, 0, 'V', 0),
(921, 133, 'feature_variant', 1054, 0, 'V', 0),
(922, 134, 'feature_variant', 1055, 0, 'V', 0),
(936, 99, 'feature_variant', 1057, 0, 'V', 0),
(937, 244, 'product', 0, 1058, 'M', 0),
(941, 245, 'product', 0, 1062, 'M', 0),
(940, 244, 'product', 0, 1061, 'A', 0),
(942, 245, 'product', 0, 1063, 'A', 0),
(943, 245, 'product', 0, 1064, 'A', 0),
(944, 246, 'product', 0, 1065, 'M', 0),
(945, 246, 'product', 0, 1066, 'A', 0),
(946, 246, 'product', 0, 1067, 'A', 0),
(947, 246, 'product', 0, 1068, 'A', 0),
(948, 135, 'feature_variant', 1069, 0, 'V', 0),
(1051, 10, 'blog', 1072, 0, 'M', 0),
(1052, 9, 'blog', 1073, 0, 'M', 0),
(1053, 8, 'blog', 1074, 0, 'M', 0),
(1066, 167, 'category', 0, 1279, 'M', 0),
(1067, 175, 'category', 0, 1280, 'M', 0),
(1068, 177, 'category', 0, 1281, 'M', 0),
(1069, 234, 'category', 0, 1282, 'M', 0),
(1070, 174, 'category', 0, 1283, 'M', 0),
(1071, 196, 'category', 0, 1284, 'M', 0),
(1072, 247, 'product', 0, 1285, 'M', 0),
(1073, 247, 'product', 0, 1286, 'A', 0),
(1074, 247, 'product', 0, 1287, 'A', 0),
(1075, 247, 'product', 0, 1288, 'A', 0),
(994, 248, 'product', 0, 1187, 'M', 0),
(995, 248, 'product', 0, 1188, 'A', 0),
(996, 248, 'product', 0, 1189, 'A', 0),
(997, 248, 'product', 0, 1190, 'A', 0),
(998, 248, 'product', 0, 1191, 'A', 0),
(993, 136, 'feature_variant', 1386, 0, 'V', 0),
(1113, 177, 'feature_variant', 1223, 0, 'V', 0),
(1126, 190, 'feature_variant', 1270, 0, 'V', 0),
(1127, 191, 'feature_variant', 1220, 0, 'V', 0),
(1133, 192, 'feature_variant', 1226, 0, 'V', 0),
(3227, 6, 'promotion', 8644, 0, 'M', 0),
(3217, 9, 'promotion', 8642, 0, 'M', 0),
(3216, 8, 'promotion', 8643, 0, 'M', 0),
(3215, 7, 'promotion', 8640, 0, 'M', 0),
(3218, 10, 'promotion', 8639, 0, 'M', 0),
(3228, 1, 'logos', 8645, 0, 'M', 0),
(3229, 2, 'logos', 8646, 0, 'M', 0),
(3230, 3, 'logos', 8647, 0, 'M', 0),
(3231, 4, 'logos', 8648, 0, 'M', 0),
(1159, 278, 'product', 0, 1396, 'A', 0),
(1160, 278, 'product', 0, 1397, 'M', 0),
(1161, 279, 'product', 0, 1398, 'M', 0),
(1162, 279, 'product', 0, 1399, 'A', 0),
(1163, 279, 'product', 0, 1400, 'A', 0),
(1164, 280, 'product', 0, 1401, 'M', 0),
(1165, 280, 'product', 0, 1402, 'A', 0),
(1166, 281, 'product', 0, 1403, 'A', 0),
(1167, 281, 'product', 0, 1404, 'M', 0),
(1168, 282, 'product', 0, 1405, 'M', 0),
(1169, 283, 'product', 0, 1406, 'M', 0),
(1170, 283, 'product', 0, 1407, 'A', 0),
(1171, 284, 'product', 0, 1406, 'M', 0),
(1172, 284, 'product', 0, 1407, 'A', 0),
(3232, 1, 'product_bundle', 8649, 0, 'M', 0),
(3233, 2, 'product_bundle', 8650, 0, 'M', 0),
(3234, 3, 'product_bundle', 8651, 0, 'M', 0),
(953, 8, 'blog', 1074, 0, 'M', 0),
(3235, 16, 'promo', 1076, 0, 'M', 0),
(3236, 18, 'promo', 1077, 0, 'M', 0),
(3237, 35, 'promo', 1300, 0, 'M', 0),
(3238, 36, 'promo', 1301, 0, 'M', 0),
(3239, 37, 'promo', 1302, 0, 'M', 0),
(3240, 38, 'promo', 1303, 0, 'M', 0),
(3241, 39, 'promo', 1304, 0, 'M', 0),
(3242, 40, 'promo', 1305, 0, 'M', 0),
(3243, 42, 'promo', 8633, 0, 'M', 0),
(3244, 47, 'promo', 8634, 0, 'M', 0),
(3245, 41, 'promo', 8632, 0, 'M', 0),
(3246, 45, 'product_reviews', 0, 908, 'A', 0),
(3247, 46, 'product_reviews', 0, 909, 'A', 0),
(3248, 23, 'product_reviews', 0, 1061, 'A', 0),
(3249, 26, 'product_reviews', 0, 1063, 'A', 0),
(3250, 27, 'product_reviews', 0, 1064, 'A', 0),
(3251, 35, 'product_reviews', 0, 1066, 'A', 0),
(3252, 36, 'product_reviews', 0, 1068, 'A', 0),
(3253, 38, 'product_reviews', 0, 1286, 'A', 0),
(3254, 39, 'product_reviews', 0, 1287, 'A', 0),
(3255, 41, 'product_reviews', 0, 1188, 'A', 0),
(3256, 42, 'product_reviews', 0, 1189, 'A', 0),
(3257, 31, 'product_reviews', 0, 594, 'A', 0),
(3258, 8, 'product_reviews', 0, 248, 'A', 0),
(3259, 11, 'product_reviews', 0, 238, 'A', 0),
(3260, 15, 'product_reviews', 0, 260, 'A', 0),
(3261, 16, 'product_reviews', 0, 675, 'A', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]import_presets`
--

CREATE TABLE `[[dbprefix]]import_presets` (
  `preset_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(11) unsigned NOT NULL DEFAULT '0',
  `object_type` varchar(32) NOT NULL DEFAULT 'products',
  `file_extension` varchar(6) NOT NULL DEFAULT '',
  `options` text,
  PRIMARY KEY (`preset_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]import_preset_descriptions`
--

CREATE TABLE `[[dbprefix]]import_preset_descriptions` (
  `preset_id` int(11) unsigned NOT NULL DEFAULT '0',
  `lang_code` char(2) NOT NULL DEFAULT '',
  `preset` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`preset_id`,`lang_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]import_preset_fields`
--

CREATE TABLE `[[dbprefix]]import_preset_fields` (
  `field_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `preset_id` int(11) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `related_object_type` varchar(32) NOT NULL DEFAULT 'product_field',
  `related_object` varchar(255) NOT NULL DEFAULT '',
  `modifier` text,
  PRIMARY KEY (`field_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]import_preset_states`
--

CREATE TABLE `[[dbprefix]]import_preset_states` (
  `preset_id` int(11) unsigned NOT NULL DEFAULT '0',
  `company_id` int(11) unsigned NOT NULL DEFAULT '0',
  `last_launch` int(11) unsigned NOT NULL DEFAULT '0',
  `last_status` char(1) NOT NULL DEFAULT 'X',
  `last_result` text,
  `file` varchar(255) NOT NULL DEFAULT '',
  `file_type` varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`preset_id`,`company_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]installed_upgrades`
--

CREATE TABLE `[[dbprefix]]installed_upgrades` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `timestamp` int(11) NOT NULL DEFAULT '0',
  `description` text,
  `conflicts` longtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]languages`
--

CREATE TABLE `[[dbprefix]]languages` (
  `lang_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `lang_code` char(2) NOT NULL DEFAULT '',
  `name` varchar(64) NOT NULL DEFAULT '',
  `status` char(1) NOT NULL DEFAULT 'A',
  `country_code` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`lang_id`),
  UNIQUE KEY `lang_code` (`lang_code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]languages`
--

INSERT INTO `[[dbprefix]]languages` VALUES
(1, 'en', 'English', 'A', 'US');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]language_values`
--

CREATE TABLE `[[dbprefix]]language_values` (
  `lang_code` char(2) NOT NULL DEFAULT '',
  `name` varchar(128) NOT NULL DEFAULT '',
  `value` text NOT NULL,
  PRIMARY KEY (`lang_code`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]language_values`
--

INSERT INTO `[[dbprefix]]language_values` VALUES
('en', '2co_enable_fraud_verification', 'Enable support of fraud notification'),
('en', '2co_fraud_fail', 'Status for orders with failed fraud review'),
('en', '2co_fraud_wait', 'Status for orders waiting for fraud review'),
('en', '3d_secure', '3-D Secure'),
('en', '404', 'The 404 Not Found error message'),
('en', 'absolute', 'Absolute'),
('en', 'installed_addons', 'Installed add-ons'),
('en', 'browse_all_available_addons', 'Browse all available add-ons'),
('en', 'accept', 'Accept'),
('en', 'access_denied', 'Access denied'),
('en', 'event.order.status_changed.name', 'Order status changed to [status]'),
('en', 'access_denied_text', 'You don''t have permission to access the page.'),
('en', 'account', 'Account'),
('en', 'account_name', 'Account name'),
('en', 'account_number', 'Account number'),
('en', 'account_type', 'Account type'),
('en', 'acquirerid', 'Acquirer ID'),
('en', 'action', 'Action'),
('en', 'actions', 'Actions'),
('en', 'activate_menu_tab_for', 'Activate menu item for dispatch'),
('en', 'activate_selected', 'Activate selected'),
('en', 'activate_skrill_merchant_tools', 'Activate Skrill Merchant Tools'),
('en', 'activation_link', 'Activation link'),
('en', 'activation_mode', 'Activation mode'),
('en', 'active', 'Active'),
('en', 'active_categories', 'Active categories'),
('en', 'active_style', 'Active style'),
('en', 'active_products', 'Active products'),
('en', 'active_promotions', 'Active promotions'),
('en', 'act_on_behalf', 'Act on behalf of'),
('en', 'log_in_as_user', 'Log in as user'),
('en', 'add', 'Add'),
('en', 'added', 'added'),
('en', 'adding_block_to_grid', 'Adding block to grid'),
('en', 'adding_grid', 'Adding grid'),
('en', 'additional_data', 'Additional data'),
('en', 'additional_images', 'Additional images'),
('en', 'additional_options', 'Additional options'),
('en', 'additional_parameter_not_correct', 'Additional parameter is incorrect'),
('en', 'additional_popup_larger_image', 'Popup larger images of additional thumbnails'),
('en', 'additional_thumbnail', 'Additional thumbnails'),
('en', 'additional__option_thumbnail', 'Additional option thumbnail'),
('en', 'addon', 'Add-on'),
('en', 'addons', 'Add-ons'),
('en', 'addon_sql_error', 'An error in an SQL query occurred during the add-on installation. The add-on will not be installed.'),
('en', 'address', 'Address'),
('en', 'addresses', 'Addresses'),
('en', 'address_2', 'Address (line 2)'),
('en', 'address_commercial', 'Commercial'),
('en', 'address_residential', 'Residential'),
('en', 'address_type', 'Address type'),
('en', 'add_administrator', 'Add administrator'),
('en', 'add_block', 'Add block'),
('en', 'add_image_from_server', 'Add image from server'),
('en', 'add_image_from_url', 'Add image from URL'),
('en', 'add_bonus', 'Add bonus'),
('en', 'add_cart_promotion', 'Add cart promotion'),
('en', 'add_catalog_promotion', 'Add catalog promotion'),
('en', 'add_categories', 'Add categories'),
('en', 'select_categories', 'Select categories'),
('en', 'add_categories_and_close', 'Add categories and close'),
('en', 'add_category', 'Add category'),
('en', 'add_chart', 'Add chart'),
('en', 'add_combination', 'Add combination'),
('en', 'add_companies', 'Add stores'),
('en', 'add_companies_and_close', 'Add stores and close'),
('en', 'add_condition', 'Add condition'),
('en', 'add_currency', 'Add currency'),
('en', 'add_customer', 'Add customer'),
('en', 'add_elements', 'Add elements'),
('en', 'add_empty_item', 'Add empty item'),
('en', 'add_feature', 'Add feature'),
('en', 'advanced_feature_creation', 'Advanced feature creation'),
('en', 'add_field', 'Add field'),
('en', 'add_file', 'Add file'),
('en', 'add_filter', 'Add filter'),
('en', 'add_filters', 'Add filters'),
('en', 'add_filters_and_close', 'Add filters and close'),
('en', 'add_folder', 'Add folder'),
('en', 'add_global_option', 'Add global option'),
('en', 'add_grid_block', 'Add grid or block'),
('en', 'add_group', 'Add group'),
('en', 'add_item', 'Add item'),
('en', 'add_items', 'Add [items]'),
('en', 'add_language', 'Add language'),
('en', 'add_language_variable', 'Add language variable'),
('en', 'add_layout', 'Add layout'),
('en', 'add_link', 'Add link'),
('en', 'add_localization', 'Add localization'),
('en', 'add_location', 'Add location'),
('en', 'add_rate_area', 'Add rate area'),
('en', 'add_menu', 'Add menu'),
('en', 'add_new', 'Add new'),
('en', 'add_new_field', 'Add new field'),
('en', 'add_new_order', 'Adding new order'),
('en', 'add_new_variant', 'Add new variant'),
('en', 'add_variant', 'Add variant'),
('en', 'add_option', 'Add option'),
('en', 'advanced_option_creation', 'Advanced option creation'),
('en', 'add_order', 'Add order'),
('en', 'add_orders', 'Add orders'),
('en', 'add_orders_and_close', 'Add orders and close'),
('en', 'add_page', 'Add page'),
('en', 'add_pages', 'Add pages'),
('en', 'add_pages_and_close', 'Add pages and close'),
('en', 'add_payment', 'Add payment method'),
('en', 'add_payout', 'Add payout'),
('en', 'add_product', 'Add product'),
('en', 'add_products', 'Add products'),
('en', 'add_products_and_close', 'Add products and close'),
('en', 'add_products_to_section', 'Add product(s) to this section'),
('en', 'add_product_filter', 'Add product filter'),
('en', 'add_promotions', 'Add promotions'),
('en', 'add_promotion', 'Add promotion'),
('en', 'add_report', 'Add report'),
('en', 'add_section', 'Add section'),
('en', 'add_selected_to_cart', 'Add selected to cart'),
('en', 'add_shipping_method', 'Add shipping method'),
('en', 'add_site_map_section', 'Add sitemap section'),
('en', 'add_state', 'Add state'),
('en', 'add_status', 'Add status'),
('en', 'add_subcategory', 'Add subcategory'),
('en', 'new_subscribers', 'New subscribers'),
('en', 'add_subscriber', 'Add subscriber'),
('en', 'add_subscribers_from_users', 'Add subscribers from the list of users'),
('en', 'add_tab', 'Add tab'),
('en', 'add_tax', 'Add tax'),
('en', 'add_to_cart', 'Add to cart'),
('en', 'add_to_comparison_list', 'Add to comparison list'),
('en', 'add_user', 'Add user'),
('en', 'add_users', 'Add users'),
('en', 'add_users_and_close', 'Add users and close'),
('en', 'add_vendor', 'Add store'),
('en', 'admin2', 'You can not perform an import to this store because you are using an expired trial version'),
('en', 'administration', 'Administration'),
('en', 'administration_panel', 'Administration panel'),
('en', 'administrator', 'Administrator'),
('en', 'administrators', 'Administrators'),
('en', 'main_administrator', 'Main administrator'),
('en', 'storefront_admin', 'Main admin for [storefront]'),
('en', 'administrators_notified', '[count] administrators notified.'),
('en', 'admin_panel', 'Administration panel'),
('en', 'admin_text_letter_footer', 'E-shop of [company_name].'),
('en', 'administration_view', 'Settings'),
('en', 'advanced', 'Advanced'),
('en', 'advanced_search', 'Advanced search'),
('en', 'advanced_search_options', 'Advanced search options'),
('en', 'search_add_filter', 'Add filter'),
('en', 'search_range_from', 'From'),
('en', 'search_range_to', 'To'),
('en', 'dynamic_navigation_more', 'More'),
('en', 'after_full_payment', 'After full payment'),
('en', 'after_sum', 'After sum'),
('en', 'agent_id', 'Agent ID'),
('en', 'agreement_required', 'Agreement required'),
('en', 'all', 'All'),
('en', 'allowed', 'Allowed'),
('en', 'allowed_combinations', 'Allowed combinations'),
('en', 'allowed_extensions', 'Allowed extensions'),
('en', 'allowed_extensions_hint', 'Leave this field empty to allow uploading of all file types, or input allowed extensions separated by comma (e.g. jpg,bmp,gif,pdf)'),
('en', 'allow_api_access', 'Yes, allow this user to use the API'),
('en', 'api_access_for_user', 'API access for this user'),
('en', 'generate_new_api_key', 'Generate new API key'),
('en', 'please_copy_api_key', 'Please copy the API key now and keep it somewhere. Once you save the changes, this key won''t appear here again. If the key is lost, the only way to regain API access will be to generate a new key on this page.'),
('en', 'allow_return_registration', 'Allow return registration'),
('en', 'all_categories', 'All categories'),
('en', 'all_downloads', 'All downloads'),
('en', 'all_features', 'All features'),
('en', 'all_filters', 'All product filters'),
('en', 'all_pages', 'All pages'),
('en', 'all_products_have_been_updated', 'All products have been updated successfully.'),
('en', 'all_vendors', 'All stores'),
('en', 'all_storefronts_short', 'All'),
('en', 'show_all_storefronts', 'Show all storefronts'),
('en', 'show_all_storefronts_with_count', 'Show all [count] storefronts'),
('en', 'all_words', 'All of these words'),
('en', 'also_bought', 'Also bought'),
('en', 'alt_text', 'Alternative text/title'),
('en', 'alternative_text', 'Alt text'),
('en', 'american_express', 'American Express'),
('en', 'american_express_info', 'CVV is on the front of the card above the credit card number (either on the right or on the left side of the credit card).'),
('en', 'amount', 'Amount'),
('en', 'amount_decreased', 'Quantity has been decreased by'),
('en', 'amount_increased', 'Quantity has been increased by'),
('en', 'anonymous', 'Anonymous'),
('en', 'answer', 'Answer'),
('en', 'any', 'Any'),
('en', 'any_date', 'Any date'),
('en', 'any_option_combinations', 'Any option combinations'),
('en', 'any_status', 'Any status'),
('en', 'any_words', 'Any of these words'),
('en', 'any_category', 'Any category'),
('en', 'any_product', 'Any product'),
('en', 'api', 'API'),
('en', 'api_access', 'API access'),
('en', 'api_key', 'API key'),
('en', 'need_company_id', 'Company ID is required (the company_id param)'),
('en', 'api_need_correct_company_id', 'Company by passed ID not found'),
('en', 'api_need_id', 'Object ID undefined'),
('en', 'api_need_params', 'Missing parameters'),
('en', 'api_need_store', 'Store is required (the company_id param or entity stores)'),
('en', 'api_not_need_id', 'ID must not be defined'),
('en', 'api_partner', 'API partner'),
('en', 'api_password', 'API password'),
('en', 'api_shipments_not_allow_update', 'Only the tracking_number and carrier params can be updated with the setting ''Allow multiple shipments for a single order'' set'),
('en', 'api_user', 'API user'),
('en', 'api_order_couldnt_be_created', 'Order couldn''t be created'),
('en', 'api_no_shipping_methods_available', 'No shipping methods are available'),
('en', 'appearance', 'Appearance'),
('en', 'appearance_settings', 'Appearance settings'),
('en', 'appearance_type', 'Appearance type'),
('en', 'application_id', 'Application ID'),
('en', 'application_login', 'Application login'),
('en', 'apply', 'Apply'),
('en', 'apply_as_link', 'Apply as link'),
('en', 'apply_tax_to_products', 'Apply selected taxes to all products'),
('en', 'apply_to_all_languages', 'Apply to all languages'),
('en', 'apply_to_products', 'Apply to products'),
('en', 'approve', 'Approve'),
('en', 'approved', 'Approved'),
('en', 'approve_selected', 'Approve selected'),
('en', 'enter_disapproval_reason', 'Enter the reason for disapproval'),
('en', 'arabic', 'Arabic'),
('en', 'arrows', 'Arrows'),
('en', 'asc', 'asc.'),
('en', 'attention', 'Attention!'),
('en', 'audience', 'Audience'),
('en', 'authentication_failed', 'Authentication failed'),
('en', 'authentication_key', 'Authentication key'),
('en', 'authentication_password', 'Authentication password'),
('en', 'author', 'Author'),
('en', 'authorization', 'Authorization'),
('en', 'authorize_capture', 'Authorize and capture'),
('en', 'authorize_only', 'Authorize only'),
('en', 'auth_code', 'Auth code'),
('en', 'auth_info', 'Authentication information'),
('en', 'auto', 'Auto'),
('en', 'auto_set_permissions_via_ftp', 'Auto-set permissions via FTP'),
('en', 'avail', 'Available'),
('en', 'availability', 'Availability'),
('en', 'available', 'Available'),
('en', 'available_fields', 'Available fields'),
('en', 'available_for_vendor', 'Available for store'),
('en', 'available_items', 'Available items'),
('en', 'available_languages', 'Available'),
('en', 'available_views', 'Available views'),
('en', 'available_since', 'Avail since'),
('en', 'installed_themes', 'Installed theme'),
('en', 'browse_all_available_themes', 'Browse all available themes'),
('en', 'currently_in_use', 'Currently in use'),
('en', 'avail_from', 'Available from'),
('en', 'avail_till', 'Available till'),
('en', 'average', 'Average'),
('en', 'avs', 'AVS'),
('en', 'awaiting', 'Awaiting'),
('en', 'awaiting_approval', 'Awaiting approval'),
('en', 'backtrace', 'Backtrace'),
('en', 'backup', 'Backup'),
('en', 'backupping_data', 'Backing up data for'),
('en', 'backupping_schema', 'Backing up schema for'),
('en', 'backup_data', 'Backup database data'),
('en', 'backup_filename', 'Backup file name'),
('en', 'backup_files', 'Backup files'),
('en', 'backup_options', 'Backup options'),
('en', 'backup_schema', 'Backup database schema'),
('en', 'back_in_stock_notification_footer', 'Welcome to purchase!'),
('en', 'back_in_stock_notification_header', 'We are writing to inform you that the following product is back in stock in our store:'),
('en', 'balance', 'Balance'),
('en', 'balance_account', 'Account balance'),
('en', 'bank', 'Bank'),
('en', 'ground_only', 'Ground only'),
('en', 'bank_cic', 'Groupe CIC'),
('en', 'bank_cm', 'Credit Mutuel'),
('en', 'bank_obc', 'OBC'),
('en', 'bank_routing_number', 'Bank routing number'),
('en', 'bar', 'Bar'),
('en', 'base_currency', 'Base'),
('en', 'base_currency_not_deleted', 'The currency has not been deleted because it is the base currency of the store.'),
('en', 'base_price', 'Base price'),
('en', 'bestsellers', 'Bestsellers'),
('en', 'biller_code', 'Biller code'),
('en', 'billing_address', 'Billing address'),
('en', 'billing_options', 'Billing Options'),
('en', 'billing_shipping_address', 'Billing and Shipping Address'),
('en', 'bill_to', 'Bill to'),
('en', 'block', 'Block'),
('en', 'blocks', 'Blocks'),
('en', 'block_already_exists_in_grid', 'This block already exists in this grid'),
('en', 'invalid_value_for_grid_with_content', 'This value can not be set, because the content does not fit into the grid width. Edit the grid content and try again.'),
('en', 'block_breadcrumbs', 'Breadcrumbs'),
('en', 'block_breadcrumbs_description', 'Navigation breadcrumbs'),
('en', 'block_categories_description', 'Category trees'),
('en', 'block_products_description', 'Product showcase'),
('en', 'block_cart_content', 'Cart content'),
('en', 'block_cart_content_description', 'Current cart content'),
('en', 'block_categories', 'Categories'),
('en', 'block_checkout', 'Checkout'),
('en', 'block_checkout_description', 'Current order information'),
('en', 'block_content', 'Block content'),
('en', 'block_currencies', 'Currencies'),
('en', 'block_currencies_description', 'Currency selector'),
('en', 'block_disabled', 'Block was disabled for this location'),
('en', 'block_enabled', 'Block was enabled for this location'),
('en', 'block_html_block', 'HTML block'),
('en', 'block_html_block_description', 'Any HTML content'),
('en', 'block_ip_after', 'Block IP after a number of unsuccessful attempts'),
('en', 'block_languages', 'Languages'),
('en', 'block_languages_description', 'Language selector'),
('en', 'block_localizations', 'Localizations'),
('en', 'block_localizations_description', 'Localization selector'),
('en', 'block_main', 'Main'),
('en', 'block_main_description', 'Main content (loaded by controller)'),
('en', 'block_manager', 'Block manager'),
('en', 'block_manager.fixed_layout', 'Fixed width'),
('en', 'block_manager.fluid_layout', 'Fluid'),
('en', 'block_manager.full_width_layout', 'Full width'),
('en', 'block_manager.grid_columns', 'Grid columns'),
('en', 'block_manager.layout_width', 'Layout width'),
('en', 'block_manager.max_width', 'Maximal width'),
('en', 'block_manager.min_width', 'Minimal width'),
('en', 'block_manager.forbid_changing_layout_in_css_mode', 'Changing layout when the theme is converted to CSS is not permitted. Please enable LESS mode in the <a target="_blank" class="cm-post" href="[url]">Theme editor</a>.'),
('en', 'block_manager.can_not_add_product', 'Sorry, we couldn''t take you to the checkout page. It requires at least one product in cart, and we couldn''t add any. Please create a product and make it available on the storefront first.'),
('en', 'block_manager.add_layout_page', 'Add layout page'),
('en', 'block_manager.editing_layout_page', 'Editing layout page'),
('en', 'block_manager.new_layout_page', 'New layout page'),
('en', 'block_manager.layout_pages', 'Layout pages'),
('en', 'block_manager.wrappers.lite_checkout', 'Lite checkout'),
('en', 'block_manager.description_available_values_for_grid_select', 'The available values depend on the size and offset of parent and nested elements.'),
('en', 'block_lite_checkout_location', 'Checkout: Location'),
('en', 'block_lite_checkout_location_description', 'Customer''s city, state, and country'),
('en', 'block_lite_checkout_customer_sign_in', 'Checkout: Sign-In'),
('en', 'block_lite_checkout_customer_sign_in_description', 'Sign-in button'),
('en', 'customer_sign_in', 'Customer Sign-In'),
('en', 'block_lite_checkout_customer_information', 'Checkout: Customer Information'),
('en', 'block_lite_checkout_customer_information_description', 'Profile fields for customer information'),
('en', 'block_lite_checkout_customer_address', 'Checkout: Address'),
('en', 'block_lite_checkout_customer_address_description', 'Profile fields for customer address'),
('en', 'customer_address', 'Customer address'),
('en', 'block_lite_checkout_shipping_methods', 'Checkout: Shipping methods'),
('en', 'block_lite_checkout_shipping_methods_description', 'Shipping method selection'),
('en', 'block_lite_checkout_payment_methods', 'Checkout: Payment methods'),
('en', 'block_lite_checkout_payment_methods_description', 'Payment method selection'),
('en', 'block_lite_checkout_customer_billing', 'Checkout: Billing address'),
('en', 'block_lite_checkout_customer_billing_description', 'Profile fields for billing address'),
('en', 'block_lite_checkout_customer_notes', 'Checkout: Notes'),
('en', 'block_lite_checkout_customer_notes_description', 'Customer''s notes about the order'),
('en', 'block_lite_checkout_terms_and_conditions', 'Checkout: Terms and conditions'),
('en', 'block_lite_checkout_terms_and_conditions_description', 'Checkbox for accepting terms and conditions'),
('en', 'terms_and_conditions', 'Terms and conditions'),
('en', 'block_menu', 'Menu'),
('en', 'block_my_account', 'My account'),
('en', 'block_my_account_description', 'Customer profile access'),
('en', 'block_name', 'Block name'),
('en', 'block_options', 'Block options'),
('en', 'block_order', 'Block order'),
('en', 'block_our_brands', 'Brands'),
('en', 'block_our_brands_description', 'Product brands presented in the store'),
('en', 'block_pages', 'Pages'),
('en', 'block_pages_description', 'Store pages'),
('en', 'block_payment_methods', 'Payment methods'),
('en', 'block_payment_methods_description', 'Available payment methods'),
('en', 'block_products', 'Products'),
('en', 'block_product_filters', 'Product filters'),
('en', 'block_product_filters_description', 'Product filtering options'),
('en', 'block_product_filters_home', 'Product filters for home page'),
('en', 'block_product_filters_home_description', 'Product filtering options, displayed on home page'),
('en', 'block_settings', 'Block settings'),
('en', 'block_shipping_methods', 'Shipping methods'),
('en', 'block_shipping_methods_description', 'Available shipping methods'),
('en', 'block_smarty_block', 'HTML block with Smarty support'),
('en', 'block_smarty_block_description', 'Any HTML/Smarty content'),
('en', 'block_template', 'Template'),
('en', 'block_template_description', 'Block with a particular template'),
('en', 'block_text', 'Block text'),
('en', 'block_time', 'Time for which IP should be blocked'),
('en', 'block_width', 'Block width'),
('en', 'block_wrapper_updated', 'Block wrapper was updated'),
('en', 'bm_confirm', 'Performing this action will [action] this block on all the [location_name] pages. Do you want to continue?'),
('en', 'body', 'Body'),
('en', 'bonus', 'Bonus'),
('en', 'bonuses', 'Bonuses'),
('en', 'both', 'Both'),
('en', 'bought', 'Already bought'),
('en', 'bought_amount', 'Bought quantity'),
('en', 'box_height', 'Box height'),
('en', 'box_length', 'Box length'),
('en', 'box_width', 'Box width'),
('en', 'brand', 'Brand'),
('en', 'brand_type', 'Brand/Manufacturer'),
('en', 'breadcrumbs', 'Breadcrumbs'),
('en', 'broken_addon_pack', 'Incorrect add-on structure. The uploaded pack cannot be installed.'),
('en', 'broken_po_pack', 'Incorrect PO-pack structure. The uploaded pack cannot be installed.'),
('en', 'incorrect_po_pack_structure_file_not_exist', 'The structure of package that contains ".po" translation files located at <b>"[pack_path]"</b> is incorrect. The file <b>"[po_file]"</b> does not exist.'),
('en', 'browse', 'Browse...'),
('en', 'browser_upgrade_notice', '<p>We have detected that the browser you are using is not fully supported by our Admin Panel. You can view this site using your current browser but it may not display properly, and you may not be able to fully use all features.</p><br><p>Admin Panel is best viewed using the following browsers:</p><br><ul><li>&ndash; <a href="http://windows.microsoft.com/en-US/internet-explorer/products/ie/home" target="_blank">Internet Explorer 9 and above</a></li><li>&ndash; <a href="http://www.mozilla.org/en-US/" target="_blank">Mozilla Firefox (latest version)</a></li><li>&ndash; <a href="https://www.google.com/intl/en/chrome/browser/" target="_blank">Google Chrome (latest version)</a></li></ul><br><p>Click on one of the links to download the browser of your choice. Once the download has completed, install the browser by running the setup program.</p><br><p>If you cannot upgrade your browser now, you can still access Admin Panel, but you may not be able to fully use all features.<br><br><a href="[url]">Continue</a></p>'),
('en', 'browser_upgrade_notice_title', 'Browser Upgrade Notice'),
('en', 'bucket', 'Bucket'),
('en', 'bulk_category_addition', 'Bulk category addition'),
('en', 'bulk_print_invoice', 'Invoice bulk print'),
('en', 'bulk_product_addition', 'Bulk product addition'),
('en', 'button_bgcolor', 'Button background color'),
('en', 'button_text_color', 'Button text color'),
('en', 'but_change', 'Change'),
('en', 'buyer_name', 'Buyer''s name'),
('en', 'buy_in_advance', 'Buy in advance'),
('en', 'buy_now', 'Buy now'),
('en', 'by', 'by'),
('en', 'bytes', 'bytes'),
('en', 'by_fixed', 'by fixed amount'),
('en', 'by_percentage', 'by percentage of the original price'),
('en', 'C128A', 'Code 128 is a high-density barcode symbology.<br/>Used extensively worldwide.<br/>Code 128 is designed to encode 128 full ASCII characters.<br/>Code 128-A - 0-9, A-Z, ASCII control codes, special characters.<br/>Code 128-B - 0-9, A-Z, a-z, special characters.<br/>Code 128-C - 00-99 (double density encoding of numeric only data).<br/>'),
('en', 'C128B', 'Code 128 is a high-density barcode symbology.<br/>Used extensively worldwide.<br/>Code 128 is designed to encode 128 full ASCII characters.<br/>Code 128-A - 0-9, A-Z, ASCII control codes, special characters.<br/>Code 128-B - 0-9, A-Z, a-z, special characters.<br/>Code 128-C - 00-99 (double density encoding of numeric only data).<br/>'),
('en', 'C128C', 'Code 128 is a high-density barcode symbology.<br/>Used extensively worldwide.<br/>Code 128 is designed to encode 128 full ASCII characters.<br/>Code 128-A - 0-9, A-Z, ASCII control codes, special characters.<br/>Code 128-B - 0-9, A-Z, a-z, special characters.<br/>Code 128-C - 00-99 (double density encoding of numeric only data).<br/>'),
('en', 'C39', 'Known also as USS Code 39, 3 of 9.<br/>Code 39 can encode alphanumeric characters.<br/>The symbology is used in non-retail environment.<br/>Code 39 is designed to encode 26 upper case letters, 10 digits and 7 special characters.'),
('en', 'cache_cleared', 'Cache has been cleared'),
('en', 'calculate', 'Calculate'),
('en', 'calculate_shipping_cost', 'Calculate shipping cost'),
('en', 'calendar', 'Calendar'),
('en', 'canada_post_activation_error', 'To activate the Canada post shipping processor, you must have the Canadian Dollar currency enabled.'),
('en', 'cancel', 'Cancel'),
('en', 'canceled_reversal', 'Canceled reversal'),
('en', 'cancelled', 'Canceled'),
('en', 'cancel_url_target', 'Cancel URL target'),
('en', 'cannot_buy', 'You cannot buy the product with these option variants'),
('en', 'cannot_proccess_checkout', 'Your cart is empty, so you cannot proceed to checkout.'),
('en', 'cannot_proccess_checkout_without_payment_methods', 'There are no payment methods available, so you cannot proceed to checkout.'),
('en', 'cannot_remove_active_theme', 'Cannot remove the active theme'),
('en', 'cannot_write_file', 'Cannot write to the file <b>[file]</b>. Please check the file and directory permissions.'),
('en', 'cant_save_percentage_price', 'You can not use percentage value for base price.'),
('en', 'cant_upload_file', 'Couldn''t upload the file. The problem isn''t necessarily on the [product] end. If it occurs regularly, please contact your server administrator or our technical support.'),
('en', 'capture', 'Capture'),
('en', 'card', 'Card'),
('en', 'cardholder_name', 'Cardholder''s name'),
('en', 'card_number', 'Card number'),
('en', 'carousel', 'Carousel'),
('en', 'carrier', 'Carrier'),
('en', 'carrier_aup', 'Australia Post'),
('en', 'carrier_can', 'Canada Post'),
('en', 'carrier_dhl', 'DHL'),
('en', 'carrier_fedex', 'FedEx'),
('en', 'carrier_swisspost', 'SwissPost'),
('en', 'carrier_ups', 'UPS'),
('en', 'tools_carrier_ups_msg', 'To get Client ID and Client Secret, <a target="_blank" href="[url]">register an app in your UPS account</a>.'),
('en', 'carrier_upsdeprecated', 'UPS [Deprecated]'),
('en', 'tools_carrier_upsdeprecated_msg', 'This shipping method will stop working in June 2024. To keep using UPS, please set up a shipping method that uses "UPS" rather than "UPS [Deprecated]" for rate calculation.'),
('en', 'carrier_usps', 'USPS'),
('en', 'cart', 'Cart'),
('en', 'cart_content', 'Cart content'),
('en', 'cart_contents', 'Cart contents'),
('en', 'cart_info', 'Site info'),
('en', 'cart_is_empty', 'Cart is empty'),
('en', 'cart_items', 'Cart items'),
('en', 'cart_subtotal', 'Cart subtotal'),
('en', 'cash_on_delivery', 'Cash on delivery'),
('en', 'catalog', 'Catalog'),
('en', 'catalog_pages', 'Catalog pages'),
('en', 'categories', 'Categories'),
('en', 'categories_have_been_added', 'Categories have been added'),
('en', 'category', 'Category'),
('en', 'category_delimiter', 'Category delimiter'),
('en', 'category_description', 'Category description'),
('en', 'category_location', 'Category location'),
('en', 'category_name', 'Category name'),
('en', 'cdn_settings', 'CDN settings'),
('en', 'central', 'Central'),
('en', 'central_content', 'Central content'),
('en', 'certificate', 'Certificate'),
('en', 'certificate_filename', 'Certificate filename'),
('en', 'change', 'Change'),
('en', 'changed', 'Changed'),
('en', 'changes', 'Changes'),
('en', 'change_access_permission_to_config', 'Also it is recommended to change the access permissions for the config.local.php file. It should have 644 (read/write for the owner and read for others) permissions.'),
('en', 'change_addons_initialization', 'Change add-ons initialization'),
('en', 'change_language', 'Change language'),
('en', 'change_password_notification', 'Please change your password'),
('en', 'change_password_notification_body', 'Your password to access the admin panel of the [store] store was last changed [days] days ago. For security reasons, please change your password. In order to do this, please follow the link:'),
('en', 'change_permissions', 'Change permissions'),
('en', 'check_permissions', 'Check permissions'),
('en', 'change_range', 'Change range'),
('en', 'charged_amount', 'Charged amount'),
('en', 'charset', 'Character set'),
('en', 'chart', 'Chart'),
('en', 'charts', 'Charts'),
('en', 'chart_type', 'Chart type'),
('en', 'check', 'Check'),
('en', 'checkbox', 'Check box'),
('en', 'checking_account_number', 'Checking account number'),
('en', 'checkout', 'Checkout'),
('en', 'checkout_as_guest', 'Checkout as guest'),
('en', 'checkout_edp_terms_n_conditions', 'I accept the terms in the'),
('en', 'checkout_terms_n_conditions', 'Select this check box to accept the [terms_href]'),
('en', 'checkout_terms_n_conditions_name', 'Terms and Conditions'),
('en', 'checkout_terms_n_conditions_alert', 'In order to proceed, you need to accept our Terms and Conditions.'),
('en', 'terms_and_conditions_content', '<p>Please read these Terms and Conditions ("Terms", "Terms and Conditions") carefully before using the <a href="http://www.mywebsite.com">http://www.mywebsite.com</a> website and the My Mobile App mobile application (the "Service") operated by My Company ("us", "we", or "our").</p><p><strong>By accessing or using the Service you agree to be bound by these Terms. If you disagree with any part of the Terms then you may not access the Service.</strong></p><p><strong>Purchases</strong></p><p>If you wish to purchase any product or service made available through the Service ("Purchase"), you may be asked to supply certain information relevant to your Purchase including, without limitation, your ...</p><p><strong>Content</strong></p><p>Our Service allows you to post, link, store, share and otherwise make available certain information, text, graphics, videos, or other material ("Content"). You are responsible for the ...</p><p><strong>Changes</strong></p><p>We reserve the right, at our sole discretion, to modify or replace these Terms at any time. If a revision is material we will try to provide at least 30 days'' notice prior to any new terms taking effect. What constitutes a material change will be determined at our sole discretion.</p><p><strong>Contact Us</strong></p><p>If you have any questions about these Terms, please contact us.</p>'),
('en', 'check_again', 'Recheck and correct'),
('en', 'check_all', 'All'),
('en', 'check_disabled', 'Disabled'),
('en', 'check_items_text', 'To include Order statuses, Payment methods and Locations in the conditions list, check the necessary item and click on the "Save" button.'),
('en', 'sales_reports_side_bar_notes', 'To include Order statuses, Payment methods and Rate areas in the conditions list, check the necessary item and click on the "Save" button.'),
('en', 'check_none', 'None'),
('en', 'check_active', 'Active'),
('en', 'check_hidden', 'Hidden'),
('en', 'check_pending', 'Pending'),
('en', 'check_number', 'Check Number'),
('en', 'check_ssl', 'Check SSL'),
('en', 'check_uncheck_all', 'Check / uncheck all'),
('en', 'chinese', 'Chinese'),
('en', 'choose', 'Choose'),
('en', 'choose_action', 'Choose action'),
('en', 'actions.more', 'More'),
('en', 'actions.bulk_product_addition', 'Add several products'),
('en', 'actions.cdn_settings', 'CDN settings'),
('en', 'actions.cities', 'Cities'),
('en', 'actions.clear_cache', 'Clear cache'),
('en', 'actions.clear_thumbnails', 'Clear thumbnails'),
('en', 'actions.countries', 'Countries'),
('en', 'actions.datakeeper_optimize', 'Optimize database'),
('en', 'actions.destinations', 'Rate areas'),
('en', 'actions.export_found', 'Export found'),
('en', 'actions.export', 'Export'),
('en', 'actions.feature_groups', 'Feature groups'),
('en', 'actions.file_changes_detector', 'Changed core files'),
('en', 'actions.files', 'File manager'),
('en', 'actions.global_update', 'Global update'),
('en', 'actions.import', 'Import'),
('en', 'actions.languages', 'Languages'),
('en', 'actions.layouts', 'Layouts'),
('en', 'actions.live_editor', 'Edit on site'),
('en', 'actions.logs', 'Logs'),
('en', 'actions.localizations', 'Localizations'),
('en', 'actions.preview', 'Preview'),
('en', 'actions.product_subscriptions', 'Expected products'),
('en', 'actions.product_tabs', 'Product tabs'),
('en', 'actions.seo_robots', 'Robots.txt'),
('en', 'actions.shipment_statuses', 'Shipment statuses'),
('en', 'actions.states', 'States'),
('en', 'actions.templates', 'Templates'),
('en', 'actions.upload_backup', 'Upload file'),
('en', 'actions.user_group_requests', 'User group requests'),
('en', 'choose_category', 'Choose category'),
('en', 'choose_user', 'Choose user'),
('en', 'choose_your_country', 'Choose your country'),
('en', 'choose_your_store_mode', 'Please choose your licensing mode'),
('en', 'cities', 'Cities'),
('en', 'city', 'City'),
('en', 'classes', 'classes'),
('en', 'clean', 'clean'),
('en', 'cleanup_history', 'Clean up history'),
('en', 'clean_logs', 'Clear logs'),
('en', 'clean_old_logs', 'Clear logs older than [n] day|Clear logs older than [n] days'),
('en', 'clean_up_all_locations_on_import', 'Clean up locations before import'),
('en', 'clear', 'Clear'),
('en', 'clear_cache', 'Clear cache'),
('en', 'generate_cache', 'Generate cache'),
('en', 'clear_cart', 'Clear cart'),
('en', 'clear_conditions', 'Clear conditions'),
('en', 'clear_fields', 'Clear fields'),
('en', 'clear_list', 'Clear list'),
('en', 'clear_thumbnails', 'Clean up generated thumbnails'),
('en', 'clicks', 'Clicks'),
('en', 'client_id', 'Client ID'),
('en', 'clone', 'Clone'),
('en', 'clone_from', 'Clone from'),
('en', 'clone_selected', 'Clone selected'),
('en', 'clone_table', 'Clone table'),
('en', 'clone_theme', 'Clone theme'),
('en', 'clone_this_item', 'Clone this item'),
('en', 'clone_this_page', 'Clone this page'),
('en', 'close', 'Close'),
('en', 'cmcic_societe', 'Societe'),
('en', 'cname', 'CNAME'),
('en', 'code', 'Code'),
('en', 'coefficient', 'Coefficient'),
('en', 'collapse_bg_color', 'Collapse background color'),
('en', 'collapse_sublist_of_items', 'Collapse the sublist of items'),
('en', 'collapse_text_color', 'Collapse text color'),
('en', 'color', 'Color'),
('en', 'combination', 'Combination'),
('en', 'comma', 'Comma'),
('en', 'comment', 'Comment'),
('en', 'comments', 'Comments'),
('en', 'comment_hint', 'Enter your comment to appear below the option'),
('en', 'commission', 'Commission'),
('en', 'commissions', 'Commissions'),
('en', 'commissions_of_last_periods', 'Commissions of latest periods'),
('en', 'commission_rates', 'Commission rates'),
('en', 'compact_list', 'Compact list'),
('en', 'company', 'Company'),
('en', 'company_address', 'Company address'),
('en', 'company_name', 'Company name'),
('en', 'company_not_found', 'Selected company not found.'),
('en', 'company_phone', 'Company phone'),
('en', 'company_settings', 'Company settings'),
('en', 'compare', 'Compare'),
('en', 'product_comparison_list', 'Comparison list'),
('en', 'comparison_list_note', 'Go to the products comparison list'),
('en', 'compare_product_features', 'Compare product features'),
('en', 'comparison_list', 'Comparison list'),
('en', 'compatible_class', 'Compatible class'),
('en', 'completed', 'Completed'),
('en', 'compressing_backup', 'Compressing backup file'),
('en', 'compress_dump', 'Compress backup file'),
('en', 'condition', 'Condition'),
('en', 'conditions', 'Conditions'),
('en', 'configure', 'Configure'),
('en', 'confirm', 'Confirm'),
('en', 'confirmation_dialog', 'Confirmation dialog'),
('en', 'confirm_password', 'Confirm password'),
('en', 'conflicts', 'Conflicts'),
('en', 'congratulations', 'Congratulations!'),
('en', 'connection_ticket', 'Connection ticket'),
('en', 'contact_information', 'Contact information'),
('en', 'contact_us_for_price', 'Contact us for a price'),
('en', 'container_options', 'Container options'),
('en', 'content', 'Content'),
('en', 'content_alignment', 'Content alignment'),
('en', 'content_changed_for', 'This block instances have different content for'),
('en', 'continue', 'Continue'),
('en', 'continue_shopping', 'Continue shopping'),
('en', 'controller', 'Replace with'),
('en', 'converting_data_in_table', 'Converting data in table [table]'),
('en', 'copyright_shopping_cart', '[product] - Shopping Cart Software'),
('en', 'core', 'Core'),
('en', 'cost', 'Cost'),
('en', 'cost_dependences', 'Cost dependencies'),
('en', 'could_not_open_file', 'File preview is not available'),
('en', 'countries', 'Countries'),
('en', 'country', 'Country'),
('en', 'coupon', 'Coupon'),
('en', 'coupons', 'Coupons'),
('en', 'coupon_already_used', 'This coupon is already in use'),
('en', 'coupon_code', 'Coupon code'),
('en', 'cpi_hash_key', 'CPI Hash Key'),
('en', 'create', 'Create'),
('en', 'created', 'Created'),
('en', 'create_account', 'Create account'),
('en', 'create_administrator_account', 'Create administrator account'),
('en', 'create_and_close', 'Create and close'),
('en', 'create_file', 'Create file'),
('en', 'create_folder', 'Create folder'),
('en', 'create_guest_account', 'Quick checkout with no account creating required'),
('en', 'create_new_account', 'Create a permanent account and use it for checkout'),
('en', 'create_new_block', 'Create New Block'),
('en', 'create_new_order', 'Create a new order'),
('en', 'create_process_payment', 'Create and process payment'),
('en', 'create_profile', 'Create a new profile'),
('en', 'create_profile_notification_header', 'Thank you for becoming a registered user at our store. Below you will find your account information.'),
('en', 'create_table', 'Create New Table'),
('en', 'creating', 'Creating'),
('en', 'creating_table', 'Creating table'),
('en', 'creation_date', 'Creation date'),
('en', 'credit_card', 'Credit card'),
('en', 'credit_card_info', 'This number is printed in the signature area on the back of the card. It is the 3 digits AFTER the credit card number.'),
('en', 'credit_memo', 'Credit memo'),
('en', 'credit_memo_id', 'Credit memo ID'),
('en', 'cresecureapitoken', 'CRE SecureAPIToken'),
('en', 'cresecureid', 'CRE SecureID'),
('en', 'cresecure_allowed_types', 'Allowed card types'),
('en', 'csv_delimiter', 'CSV delimiter'),
('en', 'csv_file', 'CSV file'),
('en', 'currencies', 'Currencies'),
('en', 'edit_currencies', 'Edit currencies'),
('en', 'currency', 'Currency'),
('en', 'currencycode', 'Currency code'),
('en', 'currency_code_aed', 'United Arab Emirates Dirham'),
('en', 'currency_code_ang', 'ANG'),
('en', 'currency_code_ars', 'ARS'),
('en', 'currency_code_aud', 'Australian Dollar'),
('en', 'currency_code_awg', 'AWG'),
('en', 'currency_code_bgn', 'BGN'),
('en', 'currency_code_brl', 'Brazilian Real'),
('en', 'currency_code_byr', 'BYN'),
('en', 'currency_code_cad', 'Canadian Dollar'),
('en', 'currency_code_chf', 'Swiss Franc'),
('en', 'currency_code_cny', 'CNY'),
('en', 'currency_code_cyr', 'Cyprus Pound'),
('en', 'currency_code_czk', 'Czech Koruna'),
('en', 'currency_code_dkk', 'Danish Kroner'),
('en', 'currency_code_eek', 'Estonian Kroon'),
('en', 'currency_code_egp', 'EGP'),
('en', 'currency_code_eur', 'Euro'),
('en', 'currency_code_fjd', 'Fiji Dollar'),
('en', 'currency_code_frf', 'French Franc'),
('en', 'currency_code_gbp', 'UK Pound'),
('en', 'currency_code_gel', 'GEL'),
('en', 'currency_code_hkd', 'Hong Kong Dollar'),
('en', 'currency_code_hrk', 'HRK'),
('en', 'currency_code_huf', 'Hungarian Forint'),
('en', 'currency_code_ils', 'Israel New Shequel'),
('en', 'currency_code_inr', 'Indian Rupee'),
('en', 'currency_code_isk', 'Iceland Krona'),
('en', 'currency_code_jpy', 'Japanese Yen'),
('en', 'currency_code_kpw', 'North Korean Won'),
('en', 'currency_code_krw', 'South Korean Won'),
('en', 'currency_code_kwd', 'Kuwaiti Dinar'),
('en', 'currency_code_kzt', 'Kazakhstani tenge'),
('en', 'currency_code_ltl', 'Lithuanian Litas'),
('en', 'currency_code_lvl', 'Latvian Lat'),
('en', 'currency_code_mad', 'MAD'),
('en', 'currency_code_mxn', 'Mexican Peso'),
('en', 'currency_code_myr', 'Malaysian Ringgit'),
('en', 'currency_code_nok', 'Norwegian Kroner'),
('en', 'currency_code_nzd', 'New Zealand Dollar'),
('en', 'currency_code_php', 'Philippine Peso'),
('en', 'currency_code_pln', 'Polish Zlotych'),
('en', 'currency_code_png', 'Papua New Guinea Kina'),
('en', 'currency_code_ron', 'RON'),
('en', 'currency_code_rub', 'RUB'),
('en', 'currency_code_rur', 'Russian Ruble'),
('en', 'currency_code_sar', 'Saudi Riyal'),
('en', 'currency_code_sbd', 'Solomon Islands Dollar'),
('en', 'currency_code_sek', 'Sweden Kroner'),
('en', 'currency_code_sgd', 'Singapore Dollar'),
('en', 'currency_code_sit', 'Slovenian Tolar'),
('en', 'currency_code_skk', 'Slovak Koruna'),
('en', 'currency_code_thb', 'Thai Baht'),
('en', 'currency_code_top', 'Tongan Pa''anga'),
('en', 'currency_code_try', 'Turkish Lira'),
('en', 'currency_code_twd', 'New Taiwan dollar'),
('en', 'currency_code_uah', 'UAH'),
('en', 'currency_code_usd', 'US Dollar'),
('en', 'currency_code_vuv', 'Vanuatu Vatu'),
('en', 'currency_code_wst', 'Samoan Tala'),
('en', 'currency_code_xaf', 'XAF'),
('en', 'currency_code_xof', 'XOF'),
('en', 'currency_code_xpf', 'XPF'),
('en', 'currency_code_zar', 'Rand'),
('en', 'currency_deleted', 'The currency has been deleted successfully.'),
('en', 'currency_rate', 'Rate'),
('en', 'currency_rate_greater_than_null', 'Currency exchange rate should be higher than 0.'),
('en', 'currency_sign', 'Sign'),
('en', 'current_database_size', 'Current database size'),
('en', 'current_path', 'Current path'),
('en', 'text_file_editor_notice', 'You can upload and download files via <a href="[href]">File Editor</a>'),
('en', 'text_file_editor_notice_with_image_size_info', 'You can upload and download files via <a href="[href]">File Editor</a>. The maximum size of image files is [file_size] MB.'),
('en', 'text_file_editor_notice_full_link', 'You can upload and download files via [link]'),
('en', 'current_previous_period', '''Current (''[date]'') and previous period'''),
('en', 'current_period', 'Current Period'),
('en', 'current_theme', 'Current theme'),
('en', 'custom', 'Custom'),
('en', 'customer', 'Customer'),
('en', 'customers', 'Customers'),
('en', 'customers_menu_title', 'Users'),
('en', 'my_customers', 'My customers'),
('en', 'my_administrators', 'My administrators'),
('en', 'customer_details', 'Customer details'),
('en', 'customer_email', 'Customer email'),
('en', 'customer_id', 'Customer ID'),
('en', 'customer_info', 'Customer information'),
('en', 'customer_information', 'Customer information'),
('en', 'customer_notes', 'Customer notes'),
('en', 'customer_signature', 'Customer''s signature'),
('en', 'customer_text_letter_footer', 'Thank you for using our shopping cart.'),
('en', 'customize', 'Customize'),
('en', 'theme_no_styles_text', 'This theme doesn''t have styles.'),
('en', 'custom_range', 'Custom Range'),
('en', 'cutted_product_codes', 'The following product codes are too long and were cut to 32 figures:'),
('en', 'cvv2', 'CVV/CVC'),
('en', 'czech', 'Czech'),
('en', 'danish', 'Danish'),
('en', 'dashboard', 'Dashboard'),
('en', 'database', 'Database'),
('en', 'database_data_changes', 'Database data changes'),
('en', 'backup_restore', 'Backup/Restore'),
('en', 'database_structure_changes', 'Database structure changes'),
('en', 'datatrans_caa', 'Authorization with immediate settlement'),
('en', 'datatrans_noa', 'Authorization only'),
('en', 'datatrans_sign', 'Digital signature'),
('en', 'date', 'Date'),
('en', 'date_added', 'Date added'),
('en', 'date_of_birth', 'Date of birth'),
('en', 'day', 'day'),
('en', 'days', 'days'),
('en', 'db_backup_restore', 'DB Backup/Restore'),
('en', 'create_backup', 'Create backup'),
('en', 'db_name', 'Database name'),
('en', 'dear', 'Dear'),
('en', 'debit', 'Debit'),
('en', 'decimals', 'Decimals'),
('en', 'decline', 'Decline'),
('en', 'default_decline_inventory_info', 'To avoid the situation when two customers buy the same product, this status always decreases inventory.'),
('en', 'declined', 'Declined'),
('en', 'decline_selected', 'Decline selected'),
('en', 'decorator', 'Decorator'),
('en', 'decrease', 'Decrease'),
('en', 'dec_sign', 'Dec sign'),
('en', 'select_selectbox_option', 'Select option'),
('en', 'default', 'Default'),
('en', 'select_default', 'Select default'),
('en', 'default_category_view', 'Default category view'),
('en', 'default_language', 'Default language'),
('en', 'default_layout', 'Default layout'),
('en', 'default_long_options_template', 'Default template (long product option names)'),
('en', 'default_product_details_view', 'Parent ([default])'),
('en', 'default_template', 'Default template'),
('en', 'bigpicture_template', 'The big picture'),
('en', 'default_value', 'Default value'),
('en', 'default_custom.disabled', 'Disabled'),
('en', 'default_custom.custom', 'Custom...'),
('en', 'default_custom.custom_value', 'Custom ([value])'),
('en', 'default_custom.parent', 'Parent ([name])'),
('en', 'default_custom.global', 'Global ([name])'),
('en', 'default_custom.edit_parent', 'Edit parent ([name])...'),
('en', 'default_custom.edit_global', 'Edit global ([name])...'),
('en', 'global_individual.global', 'Global'),
('en', 'global_individual.individual', 'Individual'),
('en', 'global_individual.global_value_all_items', 'Global value for all items'),
('en', 'global_individual.individual_values_each_item', 'Individual values for each item'),
('en', 'global_individual.individual_tooltip', 'This setting is currently global. Click here to allow changing its value for individual items.'),
('en', 'global_individual.global_tooltip', 'The value of this setting can be changed for individual items. Click here to make this setting global.'),
('en', 'global_individual.additional_settings', 'You can hide or show some extra product settings here. A hidden setting will be global and affect all products. Look out for icon [icon] <a href="[settings_url]">in the "Settings" menu</a>.'),
('en', 'deferred', 'Deferred'),
('en', 'defined', 'Defined'),
('en', 'defined_desired_products', 'List of desired products'),
('en', 'defined_items', 'defined items'),
('en', 'delay', 'Delay (in seconds)'),
('en', 'delete', 'Delete'),
('en', 'dismiss', 'Dismiss'),
('en', 'deleted', 'Deleted'),
('en', 'deleted_product', 'DELETED PRODUCT'),
('en', 'delete_block', 'Delete block'),
('en', 'delete_confirmation', 'Are you sure you want to delete the selected items?'),
('en', 'delete_grid', 'Delete grid'),
('en', 'delete_image', 'Delete image'),
('en', 'delete_image_pair', 'Delete image pair'),
('en', 'delete_install_folder', 'Please remove the install directory.<br /><br />Keeping the install directory on the server is insecure.'),
('en', 'delete_range', 'Delete range'),
('en', 'delete_selected', 'Delete selected'),
('en', 'delete_this_category', 'Delete this category'),
('en', 'delete_this_page', 'Delete this page'),
('en', 'delivery_time', 'Delivery time'),
('en', 'demo', 'Demo'),
('en', 'demo_mode', 'Demo mode is enabled'),
('en', 'demo_mode_content_text', '<p>The cart is working in the <b>DEMO</b> mode and this functionality is disabled.</p>'),
('en', 'demo_panel.demo_store_panel', 'Demo store panel'),
('en', 'demo_panel.go_admin_panel', 'Go to Administration panel'),
('en', 'demo_panel.go_storefront', 'Go to Storefront'),
('en', 'demo_panel.demo_will_be_reset_in', 'Demo will be reset in:'),
('en', 'denied', 'Denied'),
('en', 'dependence', 'Sort by'),
('en', 'deposit_amount', 'Deposit amount'),
('en', 'desc', 'desc.'),
('en', 'description', 'Description'),
('en', 'descr_avs', 'AVS verification response'),
('en', 'descr_cvv', 'CVV2 verification response'),
('en', 'design', 'Design'),
('en', 'design_mode', 'Design mode'),
('en', 'desired_amount', 'Desired quantity'),
('en', 'destination', 'Destination'),
('en', 'detailed_description', 'Detailed description'),
('en', 'detailed_images', 'Detailed images'),
('en', 'details', 'details'),
('en', 'diff', 'File changes'),
('en', 'different_only', 'Different only'),
('en', 'directory', 'Directory'),
('en', 'direct_download', 'Direct download'),
('en', 'disable', 'Disable'),
('en', 'disabled', 'Disabled'),
('en', 'disabled_categories', 'Disabled categories'),
('en', 'disable_for', 'Disable for'),
('en', 'disable_selected', 'Disable selected'),
('en', 'disapprove', 'Disapprove'),
('en', 'disapproved', 'Disapproved'),
('en', 'disapprove_selected', 'Disapprove selected'),
('en', 'discount', 'Discount'),
('en', 'discounted_price', 'Discounted price'),
('en', 'discounts', 'Discounts'),
('en', 'discount_coupon', 'Discount coupon'),
('en', 'discount_coupon_code', 'Discount coupon code'),
('en', 'dispatch', 'Dispatch'),
('en', 'displayed_vendors', 'Displayed stores'),
('en', 'display_bottom_buttons', 'Display bottom buttons'),
('en', 'display_delete_icons', 'Display delete icons'),
('en', 'display_message', 'Display message'),
('en', 'display_on', 'Display on'),
('en', 'display_type', 'Display type'),
('en', 'display_variants_count', 'Number of displayed filter variants before scroll'),
('en', 'domains', 'Domains'),
('en', 'domestic_usps', 'Domestic U.S.P.S.'),
('en', 'done', 'Done'),
('en', 'dont_track', 'Do not track'),
('en', 'dont_use_cardinal', 'Don''t use Cardinal Centinel&reg; for 3-D Secure Payer Authentication'),
('en', 'dots', 'Dots'),
('en', 'down', 'Down'),
('en', 'download', 'Download'),
('en', 'downloadable', 'Downloadable'),
('en', 'downloadable_shipping', 'Enable shipping if downloadable'),
('en', 'downloads', 'Downloads'),
('en', 'downloads_max_left', 'Downloads (max./left)'),
('en', 'download_key_expiry', 'Download key expiry'),
('en', 'download_link_expired', 'The download link is expired or is not ready.'),
('en', 'do_not_change', 'Do not change'),
('en', 'do_not_pass_logo', 'Do not pass the shopping cart logo to the merchant'),
('en', 'do_not_use', 'Do not use'),
('en', 'drlicense_number', 'Driving License Number'),
('en', 'dropdown_horizontal', 'Dropdown horizontal'),
('en', 'dropdown_limit', 'Minimal number of items to be placed in a dropdown list.'),
('en', 'dropdown_second_level_elements', 'Second level elements'),
('en', 'dropdown_third_level_elements', 'Third level elements'),
('en', 'dropdown_vertical', 'Dropdown vertical'),
('en', 'drop_existing_data', 'Delete all existing product files before import'),
('en', 'delete_downloadable_product_files', 'Delete existing files of downloadable products'),
('en', 'delete_downloadable_product_files_tooltip', 'If you enable this setting, then importing downloadable products will delete their existing files. If the setting is disabled, the new files of downloadable products will simply be added to existing files.'),
('en', 'cant_create_backup_file', 'Cannot upload backup file. Please check permissions for the "var/backups" directory of your installation.'),
('en', 'dump_file_not_writable', 'Please set write permissions on the database backup file.'),
('en', 'duplicate', 'Duplicate transactions'),
('en', 'dutch', 'Dutch'),
('en', 'dynamic', 'Dynamic'),
('en', 'dynamic_content', 'This block content will be shown on <a href="[url]">this page</a> only.'),
('en', 'dynamic_tree_cat', 'Dynamic tree'),
('en', 'dynamic_tree_pages', 'Dynamic tree'),
('en', 'easing', 'Easing'),
('en', 'edit', 'Edit'),
('en', 'editing', 'Editing'),
('en', 'editing_block', 'Editing block'),
('en', 'editing_category', 'Editing category'),
('en', 'editing_chart', 'Editing chart'),
('en', 'editing_container', 'Editing container'),
('en', 'editing_currency', 'Editing currency'),
('en', 'editing_defined_products', 'Editing defined products'),
('en', 'editing_file', 'Editing file'),
('en', 'editing_filter', 'Editing filter'),
('en', 'editing_folder', 'Editing folder'),
('en', 'editing_grid', 'Editing grid'),
('en', 'editing_group', 'Editing group'),
('en', 'editing_item', 'Editing item'),
('en', 'editing_language', 'Editing language'),
('en', 'editing_layout', 'Editing layout'),
('en', 'editing_link', 'Editing link'),
('en', 'editing_localization', 'Editing localization'),
('en', 'editing_location', 'Editing location'),
('en', 'editing_rate_area', 'Editing rate area'),
('en', 'editing_menu', 'Editing menus'),
('en', 'editing_option', 'Editing option'),
('en', 'editing_order', 'Editing order'),
('en', 'editing_page', 'Editing page'),
('en', 'editing_payment', 'Editing payment');
INSERT INTO `[[dbprefix]]language_values` VALUES
('en', 'editing_product', 'Editing product'),
('en', 'editing_product_feature', 'Editing product feature'),
('en', 'editing_profile', 'Editing profile'),
('en', 'editing_profile_field', 'Editing profile field'),
('en', 'editing_promotion', 'Editing promotion'),
('en', 'editing_quick_menu_link', 'Editing quick menu link'),
('en', 'editing_quick_menu_section', 'Editing quick menu section'),
('en', 'editing_report', 'Editing report'),
('en', 'editing_shipping_method', 'Editing shipping method'),
('en', 'editing_sitemap_section', 'Editing sitemap section'),
('en', 'editing_status', 'Editing status'),
('en', 'editing_tab', 'Editing tab'),
('en', 'editing_tax', 'Editing tax'),
('en', 'editing_vendor', 'Editing store'),
('en', 'edition_type', 'Edition type'),
('en', 'edit_content_on_site', 'Edit content on-site'),
('en', 'edit_files', 'Can edit'),
('en', 'edit_layout', 'Edit layout'),
('en', 'edit_order', 'Edit order'),
('en', 'edit_products', 'Edit products'),
('en', 'edit_profile', 'Edit profile'),
('en', 'edit_profile_note', 'Change email, password, shipping/billing info, and other profile settings'),
('en', 'edit_report', 'Edit report'),
('en', 'edit_selected', 'Edit selected'),
('en', 'edp_access_granted', 'Now you can download the purchased products.'),
('en', 'edp_access_subj', 'Access to electronically distributed products is granted'),
('en', 'edp_enable_shipping', 'Enable shipping for downloadable products'),
('en', 'email', 'E-mail'),
('en', 'emails', 'Emails'),
('en', 'email_address', 'E-mail address'),
('en', 'email_header', 'E-mail header'),
('en', 'email_subject', 'E-mail subject'),
('en', 'empty', 'Empty'),
('en', 'empty_key_value', 'Empty table key value'),
('en', 'enable', 'Enable'),
('en', 'enabled', 'Enabled'),
('en', 'enable_cdn', 'Enable CDN'),
('en', 'enable_for', 'Enable for'),
('en', 'enable_or_disable_block', 'Activate/Deactivate Block'),
('en', 'enable_or_disable_container', 'Activate/Deactivate Container'),
('en', 'enable_or_disable_grid', 'Activate/Deactivate Grid'),
('en', 'enable_quick_view', 'Enable quick view'),
('en', 'encryption', 'Encryption'),
('en', 'encryption_key', 'Encryption Key'),
('en', 'end_date', 'End date'),
('en', 'english', 'English'),
('en', 'enter_code', 'Enter code'),
('en', 'enter_data', 'Enter data'),
('en', 'enter_email', 'Enter e-mail address'),
('en', 'enter_new_lang_code', 'Enter a new language code'),
('en', 'enter_other', 'Enter other'),
('en', 'enter_your_price', 'Enter your price'),
('en', 'entity', 'Entity'),
('en', 'entry_page', 'Global entry page'),
('en', 'entry_point', 'Entry point'),
('en', 'envelope', 'Envelope'),
('en', 'epdq_3ds_main', 'Main window'),
('en', 'epdq_3ds_popup', 'Popup'),
('en', 'error', 'Error'),
('en', 'errorCode', 'Error Code'),
('en', 'errorName', 'Error Name'),
('en', 'error_account_disabled', 'Your account is disabled. Please contact the store administration.'),
('en', 'error_count_recover_password_ekeys', 'You''ve already requested password reset. If you haven''t received an email, please try again in a few minutes.'),
('en', 'error_admin_not_created_email_already_used', 'Administrator account was not created. The email address belongs to another user. You can add the administrator for this company manually.'),
('en', 'error_ajax', 'Oops, something went wrong ([error]). Please try again.'),
('en', 'error_area_access_denied', 'You are not allowed to login to this area.'),
('en', 'error_confirmation_code_invalid', 'Sorry, the anti-bot validation has failed. Please try again.'),
('en', 'error_curl_not_exists', '<b>Warning!</b><br />Your server <b>does not</b> support the PHP cURL extension. <b>[method]</b> will not be operational. Please contact your hosting provider.'),
('en', 'error_curl_ssl_not_exists', '<b>Warning!</b><br />The PHP cURL extension is compiled <b>without</b> SSL support on your server. <b>[method]</b> will not be operational. Please contact your hosting provider.'),
('en', 'error_currency_exists', 'Currency with code <b>[code]</b> already exists'),
('en', 'error_delete_theme_company', 'One of your storefronts uses this theme. Please set another theme before deleting it.'),
('en', 'error_delete_theme_layout', 'Layout that uses this theme is set as 	default. Please set another layout as default.'),
('en', 'error_demo_mode', 'The cart is working in the <b>DEMO</b> mode and this functionality is disabled.'),
('en', 'error_empty_company_name', 'Company name cannot be empty'),
('en', 'error_exim_get_images_for_products', 'Could not import images for some of the products. Either those images don''t exist (or can''t be accessed), or the paths to those images in the imported file are incorrect.'),
('en', 'error_exim_cant_open_file', 'Cannot open uploaded file'),
('en', 'error_exim_cant_read_file', 'Cannot read uploaded file'),
('en', 'error_exim_fields_not_selected', 'No fields selected for export'),
('en', 'error_exim_file_doesnt_exist', 'File doesn''t exist'),
('en', 'error_exim_incorrect_lines', 'Your CSV file has incorrect data formatting (incorrect delimiter, missed/missing fields, etc.) in the following lines: <b>[lines]</b>'),
('en', 'error_exim_incorrent_delimiter', 'The delimiter in CSV file differs from the one selected by you'),
('en', 'error_exim_invalid_count_langs', 'Multi-language line count mismatch: different number of lines for different languages provided.'),
('en', 'error_exim_layout_required_fields', 'The following fields are mandatory and cannot be removed from the layout:'),
('en', 'error_exim_no_data_exported_new', 'No data exported. The wrong export range is probably causing this issue. <a class="cm-post" href="[url]">Clear the export range</a>, then try again'),
('en', 'error_exim_no_file_uploaded', 'No file uploaded'),
('en', 'error_exim_pattern_definition_alt_keys', 'Invalid pattern definition: alternative key is missing'),
('en', 'error_exim_pattern_definition_references', 'Invalid pattern definition: missing table references'),
('en', 'error_exim_pattern_dont_match', 'Your import file does not match the selected pattern'),
('en', 'error_exim_pattern_not_found', 'Pattern not found'),
('en', 'error_exim_pattern_required_fields', 'Your import file MUST have the following fields: <b>[fields]</b>'),
('en', 'error_hash_generation', 'Error in hash generation. Please choose another payment method.'),
('en', 'error_images_need_located_root_dir', 'Please specify the images directory within the store root directory. Put the images to import in this directory.'),
('en', 'error_image_format_not_supported', 'The image format <b>[format]</b> is not supported by GD library installed on your server. The thumbnail was not created.'),
('en', 'error_incorrect_login', 'The username or password you have entered is invalid. Please try again.'),
('en', 'error_invalid_emails', 'The following email addresses are invalid: <b>[emails]</b>'),
('en', 'error_lang_code_exists', 'The provided language ([code]) code already exists'),
('en', 'error_login_not_exists', 'The username you have entered does not match any account in our store. Please make sure you have entered the correct username and try again.'),
('en', 'error_message_not_sent', 'Message could not be sent.<br />Mailer Error:'),
('en', 'error_not_logged', 'You must log in before you can access this resource!'),
('en', 'error_no_items_selected', 'No items selected! At least one check box must be selected to perform this action.'),
('en', 'error_occured', 'Error occurred.'),
('en', 'error_occurred', 'Error occurred'),
('en', 'error_passwords_dont_match', 'The passwords do not match.'),
('en', 'error_password_content', 'The password must contain both letters and numbers.'),
('en', 'error_password_expired', 'Your password has expired. You must change your password now.'),
('en', 'error_password_expired_change', 'Your password has expired. <p><a href="[link]" class="underlined"><b>Change password &#155;&#155;</b></a></p>'),
('en', 'error_password_min_symbols', 'The password must contain at least <b>[number]</b> characters.'),
('en', 'error_password_was_used', 'Your new password must not coincide with any of those four passwords used before. Please use another password.'),
('en', 'error_permissions_not_changed', 'Cannot change permissions'),
('en', 'error_status_not_changed', 'Error while updating the status. Status was not changed.'),
('en', 'error_theme_manifest_missed', 'Theme description file ("manifest") was not found. Installation canceled.'),
('en', 'error_user_exists', 'The username or email you have chosen already exists. Please try another one.'),
('en', 'error_validator_color', 'The color code in the <b>[field]</b> field is invalid.'),
('en', 'error_validator_email', 'The email address in the <b>[field]</b> field is invalid.'),
('en', 'error_validator_integer', 'The value of the <b>[field]</b> field is invalid. It should be integer.'),
('en', 'error_validator_message', 'The value of the <b>[field]</b> field is invalid.'),
('en', 'error_validator_multiple', 'The <b>[field]</b> field does not contain the selected options.'),
('en', 'error_validator_password', 'The passwords in the <b>[field2]</b> and <b>[field]</b> fields do not match.'),
('en', 'error_validator_phone', 'The phone number in the <b>[field]</b> field is invalid. The correct format is +16175555555.'),
('en', 'error_validator_phone_mask', 'The phone number in the <b>[field]</b> field is invalid.'),
('en', 'error_validator_phone_mask_with_phone', 'The phone number <b>[phone]</b> is invalid.'),
('en', 'error_validator_phone_phone_number_with_country_selection', 'The phone number is invalid'),
('en', 'error_validator_phone_number', 'It is required to use the following format for this payment method: +16175555555.'),
('en', 'error_validator_required', 'The <b>[field]</b> field is mandatory.'),
('en', 'error_validator_zipcode', 'The ZIP / Postal code in the <b>[field]</b> field is incorrect. The correct format is [extra].'),
('en', 'error_vendor_exists', 'The company with e-mail you have chosen already exists, please try another.'),
('en', 'error_validator_ccv', 'CVV/CVC is too short.'),
('en', 'error_validator_ccv_long', 'CVV/CVC is too long.'),
('en', 'error_change_admin_data_in_frontend', 'It''s forbidden to change the admin email or password in the customer area. Please sign in using a customer account.'),
('en', 'error_exchange_rate', 'Unable to get exchange rates. Please try reloading this page in a minute.'),
('en', 'exact_phrase', 'The exact phrase'),
('en', 'excellent', 'Excellent!'),
('en', 'exception', 'Exception'),
('en', 'exceptions', 'Exceptions'),
('en', 'exceptions_type', 'Exceptions type'),
('en', 'exception_disabled', 'No variant can be selected'),
('en', 'exception_disregard', 'Any variant'),
('en', 'exception_error', 'ERROR'),
('en', 'exception_error_code', 'Error code:'),
('en', 'exception_exist', 'This exception combination already exists'),
('en', 'exception_title', 'Oops!<br />We were unable to find what you were looking for.'),
('en', 'exchange_rate', 'Live exchange rates'),
('en', 'exec', 'Execute'),
('en', 'exim_remove_additional_images', 'Clean up'),
('en', 'exit_point', 'Exit point'),
('en', 'exp', 'Exp'),
('en', 'expanded', 'Expanded'),
('en', 'expand_collapse_list', 'Expand / collapse the list of items'),
('en', 'expand_sublist_of_items', 'Expand the sublist of items'),
('en', 'expired', 'Expired'),
('en', 'expirepreauth', 'Preauthorization'),
('en', 'expirepreauth_description', 'Preauthorization hold limit in days. The maximum value is 30 days. With the "Sale" request type, leave this field empty.'),
('en', 'expiry_date', 'Expiration date'),
('en', 'export', 'Export'),
('en', 'exported_fields', 'Exported fields'),
('en', 'exported_files', 'Exported files'),
('en', 'exporting_data', 'Exporting data'),
('en', 'export_data', 'Export data'),
('en', 'export_locations', 'Export locations'),
('en', 'export_options', 'Export options'),
('en', 'export_selected', 'Export selected'),
('en', 'export_products', 'Export products'),
('en', 'extended', 'Extended'),
('en', 'extra', 'Extra'),
('en', 'extra_services', 'Extra services'),
('en', 'extra_folders', 'Extra folders'),
('en', 'fail', 'Fail'),
('en', 'failed', 'Failed'),
('en', 'fair', 'Fair'),
('en', 'false', 'False'),
('en', 'faroese', 'Faroese'),
('en', 'fast', 'Fast'),
('en', 'fax', 'Fax'),
('en', 'feature', 'Feature'),
('en', 'features', 'Features'),
('en', 'features_delimiter', 'Feature variants delimiter'),
('en', 'feature_code', 'Feature code'),
('en', 'feature_comparison', 'Feature comparison'),
('en', 'feature_category', 'Feature category'),
('en', 'feature_display_on_catalog', 'Show in product list'),
('en', 'feature_display_on_header', 'Show in header on the product details page'),
('en', 'feature_display_on_product', 'Show on the Features tab'),
('en', 'feature_hide_on_catalog', 'Hide in product list'),
('en', 'feature_hide_on_header', 'Hide in header on the product details page'),
('en', 'feature_hide_on_product', 'Hide on the Features tab'),
('en', 'feedback_is_sent_successfully', 'The feedback has been sent successfully.'),
('en', 'feedback_values', 'Feedback values'),
('en', 'field', 'Field'),
('en', 'field_editor', 'Field Editor'),
('en', 'file', 'File'),
('en', 'filename', 'File name'),
('en', 'files', 'Files'),
('en', 'sell_files', 'Files to sell'),
('en', 'filesize', 'File size'),
('en', 'files_changes', 'File changes'),
('en', 'files_directory', 'Files directory'),
('en', 'downloadable_product_files_directory', 'Directory for the files of downloadable products'),
('en', 'file_avail_after_payment', 'This file will be available after the order is paid in full.'),
('en', 'file_browser', 'File browser'),
('en', 'file_doesnt_have_key', 'This file doesn''t have a download key.'),
('en', 'file_download_limit_exceeded', 'The file cannot be downloaded because the download limit equal to [limit] is exceeded.'),
('en', 'file_is_too_large', 'File is too large. Max uploading size is [size].'),
('en', 'files_are_too_large', 'Total size of the uploaded files exceeds the maximum limit of [size].'),
('en', 'file_tree', 'File tree'),
('en', 'filling', 'Filling'),
('en', 'filter', 'Filter'),
('en', 'filters', 'Filters'),
('en', 'filter_by', 'Filter by'),
('en', 'filter_description', 'Filter description'),
('en', 'filter_name', 'Filter name'),
('en', 'filters_in_use', 'All features are already in use'),
('en', 'finance_product_code', 'Finance product code'),
('en', 'financial_state', 'Financial state'),
('en', 'find_results_with', 'Find results with'),
('en', 'finish', 'Finish'),
('en', 'finished', 'Finished'),
('en', 'finnish', 'Finnish'),
('en', 'first_name', 'First name'),
('en', 'flemish', 'Flemish'),
('en', 'folder', 'Folder'),
('en', 'folder_is_empty', 'Folder is empty'),
('en', 'footer', 'Footer'),
('en', 'for', 'for'),
('en', 'forbidden', 'Forbidden'),
('en', 'forbidden_combinations', 'Forbidden combinations'),
('en', 'forgot_password_question', 'Forgot your password?'),
('en', 'form', 'Form'),
('en', 'format', 'Format'),
('en', 'forms', 'Forms'),
('en', 'form_id', 'Form ID'),
('en', 'for_all_found_orders', 'For orders on ALL pages'),
('en', 'for_this_page_orders', 'For orders on THIS page'),
('en', 'fragile', 'Fragile'),
('en', 'free', 'Free'),
('en', 'free_products', 'Free products'),
('en', 'free_shipping', 'Free shipping'),
('en', 'french', 'French'),
('en', 'from', 'from'),
('en', 'from_date', 'Date from'),
('en', 'fulfillment_state', 'Fulfillment state'),
('en', 'full', 'Full'),
('en', 'fullauth', 'Fullauth'),
('en', 'full_description', 'Full description'),
('en', 'full_list', 'Full list'),
('en', 'full_tree_cat', 'Full tree'),
('en', 'full_tree_pages', 'Full tree'),
('en', 'full_width', 'Full width'),
('en', 'function', 'Core'),
('en', 'function_deprecated', 'Function [old_function] is deprecated and will be removed in next version. Please use [new_function] instead of it.'),
('en', 'gateway', 'Gateway'),
('en', 'gateways', 'Gateways'),
('en', 'general', 'General'),
('en', 'general_info', 'General information'),
('en', 'general_statistics', 'General statistics'),
('en', 'generate', 'Generate'),
('en', 'generate_submenu', 'Generate submenu'),
('en', 'geography', 'Geography'),
('en', 'german', 'German'),
('en', 'get_rates', 'Get rates'),
('en', 'give_coupon_subj', 'you have new promotion'),
('en', 'global', 'Global'),
('en', 'global_options', 'Global options'),
('en', 'global_status', 'Global status'),
('en', 'global_update', 'Global update'),
('en', 'global_update_description', 'Positive or negative values can be entered in the fields below (e.g. -5).'),
('en', 'go', 'Go'),
('en', 'google', 'Google'),
('en', 'google_base', 'Google Base'),
('en', 'google_base_export_notice', '<b>Note:</b> You can setup Tax and Shipping rates on the <a href="http://www.google.com/merchants/taxshippingsettings">Tax and shipping summary</a> page in your Google merchant center.'),
('en', 'goto_theme_configuration', 'Browse themes'),
('en', 'remove_theme', 'Remove theme'),
('en', 'go_back', 'Go back'),
('en', 'go_to_the_admin_homepage', 'Go to the admin homepage'),
('en', 'admin.go_to_the_homepage', 'Go to the homepage'),
('en', 'go_to_the_homepage', 'Go to the homepage'),
('en', 'grams_in_the_unit_of_weight', 'Grams in the unit of weight defined by the weight symbol'),
('en', 'graphic', 'Graphic'),
('en', 'greek', 'Greek'),
('en', 'grid', 'Grid'),
('en', 'tmpl_grid', 'Grid'),
('en', 'tmpl_grid2', 'Grid2'),
('en', 'grid_options', 'Grid options'),
('en', 'gross_total', 'Gross total'),
('en', 'group', 'Group'),
('en', 'groups', 'Groups'),
('en', 'guest', 'Guest'),
('en', 'has_credit_memo', 'Has credit memo'),
('en', 'has_invoice', 'Has invoice'),
('en', 'header', 'Header'),
('en', 'sidebar', 'Sidebar'),
('en', 'header_image', 'Header image'),
('en', 'hebrew', 'Hebrew'),
('en', 'height', 'Height'),
('en', 'hello', 'Hello'),
('en', 'help', 'Help'),
('en', 'hidden', 'Hidden'),
('en', 'hide', 'Hide'),
('en', 'hide_add_to_cart_button', 'Hide add to cart button'),
('en', 'hide_options', 'Hide options'),
('en', 'show_options', 'Show options'),
('en', 'hide_option_completely', 'Hide option completely'),
('en', 'home', 'Home'),
('en', 'home_page', 'Home page'),
('en', 'horizontal', 'Horizontal'),
('en', 'host', 'Host name'),
('en', 'host_code', 'Host code'),
('en', 'hour', 'Hour'),
('en', 'how_to_send', 'How to send?'),
('en', 'html_block', 'HTML block'),
('en', 'hungarian', 'Hungarian'),
('en', 'I25', 'Interleaved 2 of 5 is based on Standard 2 of 5 symbology.<br/>Interleaved 2 of 5 is designed to encode only 10 digits.'),
('en', 'icon', 'Icon'),
('en', 'id', 'ID'),
('en', 'identifier', 'PayBox identifier'),
('en', 'iframe_mode', 'iFrame mode'),
('en', 'illegal_item_weight', 'Illegal item weight'),
('en', 'image', 'Image'),
('en', 'images', 'Images'),
('en', 'images_directory', 'Images directory'),
('en', 'image_pair', 'Image pair'),
('en', 'image_verification', 'Image verification'),
('en', 'image_verification_body', 'Type the characters you see in the picture above.'),
('en', 'image_verification_label', 'Anti-bot validation'),
('en', 'immediately', 'Immediately'),
('en', 'import', 'Import'),
('en', 'important', 'Important'),
('en', 'importing_data', 'Importing data'),
('en', 'import_data', 'Import data'),
('en', 'import_locations', 'Import locations'),
('en', 'import_options', 'Import options'),
('en', 'in', 'In'),
('en', 'included', 'included'),
('en', 'include_cvn', 'Include CVN'),
('en', 'including_discount', 'Including discount'),
('en', 'including_tax', 'Including tax'),
('en', 'incompleted', 'Incomplete'),
('en', 'incompleted_orders', 'Incomplete orders'),
('en', 'incorrect_filling_message', 'Incorrect filling message'),
('en', 'incorrect_price_warning', 'Product has not been added to the cart. Please enter the correct price.'),
('en', 'increase', 'Increase'),
('en', 'inc_tax', 'inc tax'),
('en', 'index', 'Home page'),
('en', 'information', 'Information'),
('en', 'tip', 'Tip'),
('en', 'inner_hint', 'Inner hint'),
('en', 'input_field', 'Input field'),
('en', 'insert_block', 'Add block'),
('en', 'insert_grid', 'Add grid'),
('en', 'install', 'Install'),
('en', 'installation_id', 'Installation ID'),
('en', 'installed', 'Installed'),
('en', 'installed_languages', 'Installed'),
('en', 'installed_upgrades', 'Installed upgrades'),
('en', 'welcome_screen.administrator_info', 'To access the administrator area, use the e-mail (<b>[email]</b>) and the password you have entered earlier.'),
('en', 'welcome_screen.go_admin_panel', 'Go to the administration panel'),
('en', 'welcome_screen.go_storefront', 'Go to the storefront'),
('en', 'welcome_screen.go_settings_wizard', 'Go to the Settings wizard for basic store setup'),
('en', 'welcome_screen.knowledge_base', 'Documentation'),
('en', 'welcome_screen.run_settings_wizard', 'Run Settings wizard'),
('en', 'welcome_screen.learn_more_configuration', 'Learn more about storefront configuration in our'),
('en', 'welcome_screen.thanks', 'Thank you for choosing [product]. Happy selling!'),
('en', 'installer_complete_title', 'Installation successfully finished'),
('en', 'international_settings', 'International settings'),
('en', 'international_usps', 'International U.S.P.S.'),
('en', 'inventory', 'Inventory'),
('en', 'track_inventory', 'Track inventory'),
('en', 'track_inventory_tooltip', 'When inventory is tracked, the number of products in stock will decrease after each purchase.'),
('en', 'invitees', 'Invitees'),
('en', 'invoice', 'Invoice'),
('en', 'invoices', 'Invoices'),
('en', 'invoice_credit_memo', 'Invoice/Credit memo'),
('en', 'invoice_id', 'Invoice ID'),
('en', 'invoice_title', 'INVOICE'),
('en', 'in_progress', 'In progress'),
('en', 'in_stock', 'In stock'),
('en', 'n_in_stock_products_short', '[quantity] in stock'),
('en', 'ip', 'IP'),
('en', 'ip_address', 'IP address'),
('en', 'manager', 'Manager'),
('en', 'is_back_in_stock', 'is back in stock!'),
('en', 'is_pbp', 'Allow payment by points'),
('en', 'italian', 'Italian'),
('en', 'items', 'item(s)'),
('en', 'items_dependences', 'Items dependencies'),
('en', 'items_in_box', 'Items in a box'),
('en', 'items_in_cart', 'You have [n] item in your cart|You have [n] items in your cart'),
('en', 'n_products', '[n] product|[n] products'),
('en', 'items_per_page', 'Items per page'),
('en', 'objects_per_page', '[n] per page'),
('en', 'items_title', 'Items'),
('en', 'item_number', 'Show item number'),
('en', 'item_quantity', 'Item quantity'),
('en', 'japanese', 'Japanese'),
('en', 'join', 'Join'),
('en', 'json_error_ctrl_char', 'Control character error, possibly incorrectly encoded'),
('en', 'json_error_depth', 'The maximum stack depth has been exceeded'),
('en', 'json_error_state_mismatch', 'Invalid or malformed JSON'),
('en', 'json_error_syntax', 'Syntax error, malformed JSON'),
('en', 'json_error_unknown', 'Unknown JSON error'),
('en', 'json_error_utf8', 'Malformed UTF-8 characters, possibly incorrectly encoded'),
('en', 'key', 'Key'),
('en', 'key1_for_md5', 'Auth key 1 for md5'),
('en', 'key2_for_md5', 'Auth key 2 for md5'),
('en', 'keywords', 'Keywords'),
('en', 'korean', 'Korean'),
('en', 'label_text_color', 'Label text color'),
('en', 'landing_header', 'Your order has been received'),
('en', 'language', 'Language'),
('en', 'language_content', 'The language of content'),
('en', 'languagecode', 'Language code'),
('en', 'languages', 'Languages'),
('en', 'texts_languages', 'Texts & languages'),
('en', 'language_code', 'Language code'),
('en', 'language_variable', 'Language variable'),
('en', 'language_variables', 'Language variables'),
('en', 'last4ssn', 'Last 4 digits of Social Security Number'),
('en', 'last_24hours', 'Last 24 hours'),
('en', 'last_days', 'Last days'),
('en', 'last_month', 'Last month'),
('en', 'last_name', 'Last name'),
('en', 'last_n_days', 'Last [N] days'),
('en', 'last_order', 'Last order'),
('en', 'first_order', 'First order'),
('en', 'registration_date', 'Registration date'),
('en', 'latitude', 'Latitude'),
('en', 'layout', 'Layout'),
('en', 'layouts', 'Layouts'),
('en', 'lbl_amazon_aws_access_public_key', 'AWS access public key'),
('en', 'lbl_amazon_aws_access_secret_key', 'AWS access secret key'),
('en', 'lbl_amazon_background_color', 'Background color'),
('en', 'lbl_amazon_button_color', 'Button color'),
('en', 'lbl_amazon_button_size', 'Button size'),
('en', 'lbl_amazon_button_style', 'Amazon button style'),
('en', 'lbl_amazon_color_dark', 'Dark'),
('en', 'lbl_amazon_color_light', 'Light'),
('en', 'lbl_amazon_color_orange', 'Orange'),
('en', 'lbl_amazon_color_tan', 'Tan'),
('en', 'lbl_amazon_color_white', 'White'),
('en', 'lbl_amazon_process_order_on_failure', 'Process order on callback failure'),
('en', 'lbl_amazon_size_large', 'Large'),
('en', 'lbl_amazon_size_medium', 'Medium'),
('en', 'lbl_amazon_size_xlarge', 'X-Large'),
('en', 'left', 'Left'),
('en', 'length', 'Length'),
('en', 'less', 'less'),
('en', 'letter', 'Letter'),
('en', 'level', 'Level'),
('en', 'licence_agreement', 'License Agreement'),
('en', 'license_agreement', 'License agreement'),
('en', 'license_number', 'License number'),
('en', 'license_number_cannot_be_empty', 'License number cannot be empty'),
('en', 'limit', 'Limit'),
('en', 'line', 'Line'),
('en', 'linear', 'Linear'),
('en', 'link', 'Link'),
('en', 'linked_categories', 'Linked categories'),
('en', 'linked_products', 'Linked products'),
('en', 'links', 'Links'),
('en', 'links_thumb', 'Links thumb'),
('en', 'link_text', 'Link text'),
('en', 'link_to', 'Link to'),
('en', 'list', 'List'),
('en', 'list_objects', 'List objects'),
('en', 'list_price', 'List price'),
('en', 'list_price_decreased', 'List price has been decreased by'),
('en', 'list_price_increased', 'List price has been increased by'),
('en', 'list_price_short', 'List price'),
('en', 'list_price_short_2', 'List price'),
('en', 'list_quantity_count', 'Number of available quantities'),
('en', 'tmpl_list_without_options', 'List without options'),
('en', 'live', 'Live'),
('en', 'live_preview', 'Live preview'),
('en', 'loading', 'Loading...'),
('en', 'local', 'Local'),
('en', 'localization', 'Localization'),
('en', 'localizations', 'Localizations'),
('en', 'location', 'Location'),
('en', 'rate_area', 'Rate area'),
('en', 'locations', 'Locations'),
('en', 'rate_areas', 'Rate areas'),
('en', 'statuses_management', 'Statuses'),
('en', 'loggedin_time', 'Logged in time'),
('en', 'logging', 'Logging'),
('en', 'login', 'Login'),
('en', 'login_url', 'Login URL'),
('en', 'logos', 'Logos'),
('en', 'logo_link', 'Location (URL) of logo'),
('en', 'logs', 'Logs'),
('en', 'log_action_backup', 'backup'),
('en', 'log_action_create', 'create'),
('en', 'log_action_delete', 'delete'),
('en', 'log_action_deprecated', 'deprecated'),
('en', 'log_action_error', 'error'),
('en', 'log_action_failed_login', 'failed login'),
('en', 'log_action_http', 'http/https request'),
('en', 'log_action_login', 'sign in'),
('en', 'log_action_low_stock', 'low stock'),
('en', 'log_action_optimize', 'optimize'),
('en', 'log_action_restore', 'restore'),
('en', 'log_action_runtime', 'runtime'),
('en', 'log_action_session', 'session'),
('en', 'log_action_status', 'status change'),
('en', 'log_action_update', 'update'),
('en', 'log_type_categories', 'Categories'),
('en', 'log_type_database', 'Database'),
('en', 'log_type_general', 'general'),
('en', 'log_type_orders', 'Orders'),
('en', 'log_type_products', 'Products'),
('en', 'log_type_requests', 'Requests'),
('en', 'log_type_users', 'Users'),
('en', 'longitude', 'Longitude'),
('en', 'low_stock_subj', 'Low inventory of "[product]"'),
('en', 'mac_key', 'Mac key'),
('en', 'mailing_lists', 'Mailing lists'),
('en', 'mail_message', 'Mail message'),
('en', 'mail_subject', 'Mail subject'),
('en', 'main', 'Main'),
('en', 'mainbox_general', 'Main block (H1 heading)'),
('en', 'mainbox_simple', 'Important block (H2 heading)'),
('en', 'footer_general', 'Footer general'),
('en', 'maintenance', 'Maintenance'),
('en', 'main_category', 'Main category'),
('en', 'make_default', 'Make default'),
('en', 'manage', 'Manage'),
('en', 'manage_addons', 'Manage add-ons'),
('en', 'manage_blocks', 'Manage blocks'),
('en', 'manage_categories', 'Manage categories'),
('en', 'manage_existing_block', 'Edit Existing Blocks'),
('en', 'manage_items', 'Manage items'),
('en', 'manage_languages', 'Manage languages'),
('en', 'manage_menus', 'Manage menus'),
('en', 'manage_pages', 'Can edit'),
('en', 'manage_products', 'Manage products'),
('en', 'manage_reports', 'Manage reports'),
('en', 'manage_shippings', 'Shipping methods'),
('en', 'manage_sitemap', 'Manage sitemap'),
('en', 'manage_stores', 'Manage stores'),
('en', 'mandatory', 'Required'),
('en', 'manually', 'Manually'),
('en', 'manually_set_tax_rates', 'Manually set tax rates'),
('en', 'mark', 'Mark as resolved'),
('en', 'marketing', 'Marketing'),
('en', 'maximum_items_in_box', 'Maximum items in box'),
('en', 'max_amount', 'Total cost'),
('en', 'max_box_weight', 'Max box weight'),
('en', 'max_downloads', 'Max downloads'),
('en', 'max_item', 'Number of items'),
('en', 'max_order_qty', 'Maximum quantity to buy per product'),
('en', 'max_uploading_file_size', 'Max uploading file size'),
('en', 'max_uploading_file_size_hint', 'Leave this field empty to allow uploading of files of any size, or limit the file size ("100" is equal to 100 Kb)'),
('en', 'mb_amounts_not_match', 'The amount value received in status request differs from the original order total'),
('en', 'mb_currencies_not_match', 'The currency value received in status request differs from the store currency'),
('en', 'mb_md5_hashes_not_match', 'The md5 hash value received in status request differs from the calculated one'),
('en', 'mb_transaction_id', 'MB Transaction ID'),
('en', 'md5_checksum_failed', 'MD5 checksum failed'),
('en', 'md5_hash_value', 'MD5 hash value'),
('en', 'menu', 'Menu'),
('en', 'menus', 'Menus'),
('en', 'menu_items', 'Items for menu'),
('en', 'merchantid', 'Merchant ID'),
('en', 'merchant_email', 'Merchant Notification Email'),
('en', 'merchant_firstname', 'Merchant first name'),
('en', 'merchant_id', 'Merchant ID'),
('en', 'merchant_key', 'Merchant key'),
('en', 'merchant_lastname', 'Merchant last name'),
('en', 'merchant_login', 'Merchant login'),
('en', 'merchant_name', 'Merchant name'),
('en', 'merchant_pin', 'Merchant PIN'),
('en', 'merchant_response_was_not_received', 'No response from the merchant received. Please check this transaction manually.'),
('en', 'merchant_site_id', 'Merchant site ID'),
('en', 'merchant_warrior_api_key', 'API Key.'),
('en', 'merchant_warrior_api_passphrase', 'API Passphrase.'),
('en', 'merge', 'Merge'),
('en', 'message', 'Message'),
('en', 'messages', 'Messages'),
('en', 'meta_description', 'Meta description'),
('en', 'meta_keywords', 'Meta keywords'),
('en', 'method', 'Method'),
('en', 'minimized', 'Minimized'),
('en', 'minimum_commission_payment', 'Minimum commission payment'),
('en', 'minimum_items_in_box', 'Minimum items in box'),
('en', 'minutes', 'minute(s)'),
('en', 'min_order_qty', 'Minimum quantity to buy per product'),
('en', 'missing_variants_handling', 'Missing variants handling'),
('en', 'modifier', 'Modifier'),
('en', 'modifiers', 'Modifiers'),
('en', 'modify_profile', 'Modify Profile'),
('en', 'modify_selected', 'Modify selected'),
('en', 'month', 'Month'),
('en', 'months', 'month(s)'),
('en', 'month_name_1', 'January'),
('en', 'month_name_10', 'October'),
('en', 'month_name_11', 'November'),
('en', 'month_name_12', 'December'),
('en', 'month_name_2', 'February'),
('en', 'month_name_3', 'March'),
('en', 'month_name_4', 'April'),
('en', 'month_name_5', 'May'),
('en', 'month_name_6', 'June'),
('en', 'month_name_7', 'July'),
('en', 'month_name_8', 'August'),
('en', 'month_name_9', 'September'),
('en', 'month_name_abr_1', 'Jan'),
('en', 'month_name_abr_10', 'Oct'),
('en', 'month_name_abr_11', 'Nov'),
('en', 'month_name_abr_12', 'Dec'),
('en', 'month_name_abr_2', 'Feb'),
('en', 'month_name_abr_3', 'Mar'),
('en', 'month_name_abr_4', 'Apr'),
('en', 'month_name_abr_5', 'May'),
('en', 'month_name_abr_6', 'Jun'),
('en', 'month_name_abr_7', 'Jul'),
('en', 'month_name_abr_8', 'Aug'),
('en', 'month_name_abr_9', 'Sep'),
('en', 'more', 'More'),
('en', 'content_more', 'more'),
('en', 'more_info', 'More info'),
('en', 'more_link', '[more]'),
('en', 'more_sign_in_options', 'Back to more sign in options'),
('en', 'more_than', 'More than'),
('en', 'more_w_ellipsis', 'More...'),
('en', 'most_popular', 'Most popular'),
('en', 'most_popular_addons', 'Most popular add-ons'),
('en', 'mr', 'Mr.'),
('en', 'ms', 'Ms.'),
('en', 'tmpl_multicolumns_small', 'Multicolumns small'),
('en', 'tmpl_multicolumn_list', 'Multi-column list'),
('en', 'multiple', 'Multiple'),
('en', 'multiple_selectbox_notice', '<p>To select several items, press and hold the CTRL key and click on the required items.</p>'),
('en', 'multiupload', 'Multiupload'),
('en', 'my_account', 'My account'),
('en', 'my_account_links', 'My account links'),
('en', 'my_points', 'My points'),
('en', 'na', 'N/A'),
('en', 'name', 'Name'),
('en', 'name_short', 'Name'),
('en', 'navigation', 'Navigation'),
('en', 'navi_pages', 'Pages'),
('en', 'neighbours', 'Neighbours'),
('en', 'new', 'New'),
('en', 'newest', 'Newest'),
('en', 'new_administrator_password', 'New administrator password'),
('en', 'new_category', 'New category'),
('en', 'new_chart', 'New chart'),
('en', 'new_combination', 'New combination'),
('en', 'new_currency', 'New currency'),
('en', 'new_customer', 'New customer'),
('en', 'new_feature', 'New feature'),
('en', 'new_file', 'New file'),
('en', 'new_filter', 'New filter'),
('en', 'new_folder', 'New folder'),
('en', 'new_group', 'New group'),
('en', 'new_items', 'New item'),
('en', 'new_language', 'New language'),
('en', 'new_language_variable', 'New language variable'),
('en', 'important_language_text', 'When you hide, disable, or delete a default language of one of the storefronts, make sure to update the value of the <b>Frontend default language</b> setting in <a href="[link]">Settings → Appearance</a>.'),
('en', 'important_currency_text', 'When you hide, disable, or delete a default currency of one of the storefronts, make sure to update the value of the <b>Frontend default currency</b> setting in <a href="[link]">Settings → Appearance</a>.'),
('en', 'new_layout', 'New layout'),
('en', 'new_link', 'New link'),
('en', 'new_localization', 'New localization'),
('en', 'new_location', 'New location'),
('en', 'new_rate_area', 'New rate area'),
('en', 'new_menu', 'New menu'),
('en', 'new_option', 'New option'),
('en', 'new_page', 'New page'),
('en', 'new_payments', 'New payment method'),
('en', 'new_payout', 'New payout'),
('en', 'new_post', 'New post'),
('en', 'new_product', 'New product'),
('en', 'new_profile', 'New profile'),
('en', 'new_profile_field', 'New profile field'),
('en', 'new_profile_notification', 'New profile notification'),
('en', 'new_promotion', 'New promotion'),
('en', 'new_report', 'New report'),
('en', 'new_saved_search', 'New saved search'),
('en', 'new_section', 'New section'),
('en', 'new_shipment', 'New shipment'),
('en', 'detailed_shipment', 'Detailed shipment'),
('en', 'create_detailed_shipment', 'Create detailed shipment'),
('en', 'new_shipment_was_created', 'New shipment was created'),
('en', 'new_shipping_method', 'New shipping method'),
('en', 'new_site_map_section', 'New sitemap section'),
('en', 'new_states', 'New state(s) for the selected country'),
('en', 'new_status', 'New status'),
('en', 'new_tab', 'New tab'),
('en', 'new_tax', 'New tax'),
('en', 'new_usergroups', 'New user group(s)'),
('en', 'new_user_profile', 'New user profile'),
('en', 'new_vendor', 'New store'),
('en', 'new_zealand', 'New Zealand'),
('en', 'next', 'Next'),
('en', 'next_step', 'Next step'),
('en', 'no', 'No'),
('en', 'nocombination', 'Unfortunately this combination is not accessible'),
('en', 'none', 'None'),
('en', 'normal', 'Normal'),
('en', 'norway', 'Norway'),
('en', 'norwegian', 'Norwegian'),
('en', 'note', 'Note'),
('en', 'notes', 'Notes'),
('en', 'notice', 'Notice'),
('en', 'notice_too_many_decimals', 'You have specified [DECIMALS] decimal places for [CURRENCY]. The maximum number of supported decimal places is 2. Further values will be displayed as zeros.'),
('en', 'notice_undeliverable_products_removed', 'Undeliverable products have been removed from your cart. You may proceed with the purchase.'),
('en', 'notice_update_customer_details', 'The customer updated the email address in the profile. Select the check box to update the order details:'),
('en', 'notify_customer', 'Notify customer'),
('en', 'notify_orders_department', 'Notify orders department'),
('en', 'notify_user', 'Notify user'),
('en', 'notify_vendor', 'Notify store owner'),
('en', 'notify_when_back_in_stock', 'Notify me when this product is back in stock'),
('en', 'not_active', 'Not active'),
('en', 'not_active_file_notice', 'This file will be available for downloading only after the administrator approves them'),
('en', 'not_a_member', 'Not a member'),
('en', 'not_installed', 'Not installed'),
('en', 'not_scroll_automatically', 'Do not scroll automatically'),
('en', 'enable_link', 'Enable link'),
('en', 'no_categories_available', 'No categories available'),
('en', 'no_data', 'No data found'),
('en', 'no_data_found', 'No data found that satisfies this chart conditions'),
('en', 'no_files', 'No files'),
('en', 'no_image', 'No image'),
('en', 'no_items', 'No items defined'),
('en', 'no_items_found', 'No items found matching the search criteria'),
('en', 'no_menus', 'No menus'),
('en', 'no_products_for_shipment', 'There are no products for shipment'),
('en', 'no_products_selected', 'No products selected'),
('en', 'no_rates_for_empty_cart', '<p class="error-text" align="center">Your cart is empty and the shipping cost cannot be estimated</p>'),
('en', 'no_rates_for_empty_cart_warning', 'Your cart is empty and the shipping cost cannot be estimated'),
('en', 'no_shipping_required', 'No shipping required'),
('en', 'no_such_coupon', 'The entered code cannot be applied, because it does not meet the requirements.'),
('en', 'no_themes_available', 'No themes available'),
('en', 'no_users_found', 'No users found'),
('en', 'number', 'Number'),
('en', 'number_of_columns', 'Number of columns in the objects list'),
('en', 'object', 'Object'),
('en', 'object_does_not_exist', 'The object doesn''t exist'),
('en', 'object_exists', 'Object of the same name already exists. Do you want to overwrite it?'),
('en', 'object_not_found', 'The [object] not found'),
('en', 'of', 'of'),
('en', 'off', 'Off'),
('en', 'offline', 'Offline'),
('en', 'offset', 'Offset'),
('en', 'ok', 'OK'),
('en', 'old_price', 'Old price'),
('en', 'on', 'on'),
('en', 'once_per_customer', 'Once per customer'),
('en', 'onclick_dropdown', 'Onclick-dropdown'),
('en', 'online_only', 'Online only'),
('en', 'on_off', 'On/Off'),
('en', 'on_site_template_editing', 'On-site template editing'),
('en', 'on_site_live_editing', 'On-site live editing'),
('en', 'open', 'Open'),
('en', 'open_action', 'Open'),
('en', 'open_file_or_create_new', 'Open a file or create a new one to get started.'),
('en', 'open_in_new_window', 'Open in new window'),
('en', 'open_store', 'Open storefront'),
('en', 'optimize_database', 'Optimize database'),
('en', 'optimizing_table', 'Optimizing table'),
('en', 'options', 'Options'),
('en', 'options_for', 'Options for'),
('en', 'options_have_been_applied_to_products', 'Options have been successfully applied to the selected products'),
('en', 'options_settings', 'Options settings'),
('en', 'options_type', 'Options type'),
('en', 'option_combinations', 'Option combinations'),
('en', 'option_name', 'Option name'),
('en', 'option_unlinked', 'Global option "[option_name]" has been deactivated for the product'),
('en', 'option_variants', 'Option variants'),
('en', 'opt_currency_name', 'Show currency titles'),
('en', 'opt_currency_symbol', 'Use currency symbols instead of titles'),
('en', 'opt_language_icon', 'Flags only'),
('en', 'opt_language_name', 'Flags and language names'),
('en', 'or', 'or'),
('en', 'order', 'Order'),
('en', 'ordered_products', 'Ordered products'),
('en', 'orders', 'Orders'),
('en', 'orders_not_allow_to_change_company', 'Company has not been changed. It is not allowed to change the company when editing an order.'),
('en', 'orders_no_items', 'Use the "Add products" button above to add products to order.'),
('en', 'order_by_status', 'Order by status'),
('en', 'order_date', 'Order date'),
('en', 'order_details', 'Order details'),
('en', 'order_discount', 'Order discount'),
('en', 'order_id', 'Order ID'),
('en', 'order_info', 'Order information'),
('en', 'order_items', 'Order items'),
('en', 'order_landing_page', 'Order landing page'),
('en', 'order_management', 'Order management'),
('en', 'order_placed', 'Order placed'),
('en', 'order_prefix', 'Order prefix'),
('en', 'order_search', 'Search order'),
('en', 'order_status', 'Order status'),
('en', 'order_statuses', 'Order statuses'),
('en', 'order_total', 'Order Total'),
('en', 'order_total_not_correct', 'The paid total amount does not match the order total'),
('en', 'order_was_not_placed', 'Order was not placed'),
('en', 'only_one_order_can_be_edited_at_a_time', 'Couldn''t save changes to the order. Only one order can be edited per browser at a time. Please close any other browser tabs where you''re editing orders, and reload the tab with the order that you want to edit.'),
('en', 'original', 'Original'),
('en', 'origination', 'Origination'),
('en', 'or_saved_search', 'or any item from the saved search'),
('en', 'or_use', 'Or use'),
('en', 'others', 'Others'),
('en', 'other_addons', 'Other add-ons'),
('en', 'output', 'Output'),
('en', 'out_of_stock_actions', 'Out of stock actions'),
('en', 'out_of_stock_products', 'Out of stock'),
('en', 'override_by_dispatch', 'Override locations by dispatch'),
('en', 'override_by_this', 'Use this content for all the block instances'),
('en', 'override_product_data', 'Apply values to all the selected products'),
('en', 'owner', 'Owner'),
('en', 'p21agree', 'Please type "AGREE" or "DISAGREE" in the box provided'),
('en', 'p21agree_tooltip', 'By typing AGREE in the below box I am providing my signature as authorization to Payment21&reg; to electronically debit my account for the amount I have entered. I also understand and expressly authorize the merchant, if my eCheck payment is dishonored or returned for any reason, to electronically debit my account for the amount of the eCheck payment plus an NSF fee not to exceed the state maximum legal limit. I will print or save this page for my records. I can call +18887700850 for 24/7 support with any questions regarding this payment transaction.'),
('en', 'package', 'Package'),
('en', 'packages', 'Packages'),
('en', 'show_package_contents', 'View upgrade contents'),
('en', 'package_type', 'Package type'),
('en', 'packing_slip', 'Packing slip'),
('en', 'packing_slip_for_order', 'Packing slip for order'),
('en', 'page', 'Page'),
('en', 'pages', 'Pages'),
('en', 'page_cloned', 'The page <b>[page]</b> has been cloned successfully. Now you can edit the new page'),
('en', 'page_id', 'Page ID'),
('en', 'page_link', 'Page URL'),
('en', 'page_name', 'Page name'),
('en', 'page_not_found', 'Page Not Found'),
('en', 'page_not_found_text', 'The page you have requested cannot be found.'),
('en', 'page_title', 'Page title'),
('en', 'paid_amount', 'Paid amount'),
('en', 'param', 'Parameter'),
('en', 'parameter', 'Object to analyze'),
('en', 'parameter_name', 'Parameter name'),
('en', 'parent_category', 'Parent category'),
('en', 'parent_category_id', 'Parent category'),
('en', 'parent_item', 'Parent item'),
('en', 'parent_page', 'Parent page'),
('en', 'parent_page_id', 'Parent page'),
('en', 'partner', 'Partner'),
('en', 'passphrase', 'Pass-phrase'),
('en', 'passport_number', 'Passport number'),
('en', 'password', 'Password'),
('en', 'path_to_files', 'Full path to the "atos" files'),
('en', 'pause_delay', 'Pause delay (in seconds)'),
('en', 'payflowcolor', 'Payflow color'),
('en', 'payment', 'Payment'),
('en', 'payments', 'Payments'),
('en', 'payments.cresecure.location_notice', '<b>Please note:</b><br>1. This payment requires the https checkout option to be enabled!<br>2. By default, the Checkout location is shown to a user on payment placing. In order to show a different location, create a new location with the dispatch ''checkout.cresecure_template'' in the <a href="[url]" target="_blank">Layout manager</a>.'),
('en', 'payments.epdq.bgcolor', 'Background color'),
('en', 'payments.epdq.btn_bgcolor', 'Button background color'),
('en', 'payments.epdq.btn_textcolor', 'Button text color'),
('en', 'payments.epdq.font_type', 'Font type'),
('en', 'payments.epdq.hash_error', 'Sorry, the hash string does not match'),
('en', 'payments.epdq.instructions', '<ol><li><p>Enter the following URL in the "Technical information"→"Transaction feedback" section in the Barclaycard ePDQ admin area:</p><p>for the "accepted" and "cancelled" payments: [url]</p></li><li>Make sure that the "Timing of the request" is set to "Always online", and "Request method" is set to "POST"</li><li>Define the "SHA-OUT pass phrase" value in the ePDQ admin area as you like, then duplicate it in the "SHA-IN pass phrase" field in the "Data and origin verification" section, and also in the "Pass-phrase" field below</li><li>Make sure that the "Default operation code" option in the ePDQ admin area has the same value as the "Transaction type" option value below</li><li>Set the "Hash algorithm" parameter to "SHA-1" in the "Global security parameters" section in the Barclaycard ePDQ admin area</li></ol>'),
('en', 'payments.epdq.pspid', 'EPDQ pspid'),
('en', 'payments.epdq.tbl_bgcolor', 'Table background color'),
('en', 'payments.epdq.tbl_textcolor', 'Table text color'),
('en', 'payments.epdq.textcolor', 'Text color'),
('en', 'payments.epdq.title', 'Title'),
('en', 'payments.signin_to_checkout', '<a href=[url]>Sign in</a> to check out'),
('en', 'payments_tab1', 'Credit card'),
('en', 'payments_tab2', 'Internet Payments'),
('en', 'payments_tab3', 'Other Payment Options'),
('en', 'payment_amount', 'Payment amount'),
('en', 'payment_category', 'Payment category'),
('en', 'payment_category_note', 'Payment categories tabs will NOT be displayed if all the active payments belong to the same category'),
('en', 'payment_details', 'Payment details'),
('en', 'payment_form_url', 'Payment Form URL'),
('en', 'payment_info', 'Payment type'),
('en', 'payment_information', 'Payment information'),
('en', 'payment_instructions', 'Payment instructions'),
('en', 'payment_method', 'Payment method'),
('en', 'payment_methods', 'Payment methods'),
('en', 'payment_response_password', 'Payment Response password'),
('en', 'payment_surcharge', 'Payment surcharge'),
('en', 'payment_type', 'Payment type'),
('en', 'paypal_authentication_method', 'PayPal authentication method'),
('en', 'paypal_item_name', 'Name of the item (or a name for the Shopping Cart)'),
('en', 'paypal_security_error', 'Your order was not placed: the recipient PayPal account is wrong.'),
('en', 'pay_from_email', 'Customer email'),
('en', 'pay_order_again', 'Pay order again'),
('en', 'pay_to_email', 'Email address of the Merchant'),
('en', 'pending', 'Pending'),
('en', 'suspended', 'Suspended'),
('en', 'per', 'Per [object]'),
('en', 'percent', 'Percent'),
('en', 'period', 'Period'),
('en', 'per_item', 'Per Item'),
('en', 'per_page', 'Per Page'),
('en', 'pagination_range', '<span>[pagination.range_from]</span>–<span>[pagination.range_to]</span>&nbsp;of&nbsp;[pagination.total_items]'),
('en', 'phone', 'Phone'),
('en', 'phone1_label', 'Phone'),
('en', 'phone2_label', 'International'),
('en', 'phone2', 'International'),
('en', 'phone_mask_label', 'Phone'),
('en', 'phpinfo', 'PHP information'),
('en', 'pick_store', 'Pick a store'),
('en', 'pie', 'Pie'),
('en', 'pie_3d', 'Pie 3D'),
('en', 'pixels', 'pixels'),
('en', 'place_order', 'Place order'),
('en', 'placing_order', 'Placing the order'),
('en', 'plain', 'Plain'),
('en', 'platform', 'Platform'),
('en', 'please_be_patient', 'Please be patient'),
('en', 'please_enter_license_here', 'Enter your license number here'),
('en', 'please_select_one', 'Please, select one'),
('en', 'please_sign_in', 'Please sign in'),
('en', 'polish', 'Polish'),
('en', 'poor', 'Poor'),
('en', 'popularity', 'Popularity'),
('en', 'popup', 'Popup'),
('en', 'popup_larger_image', 'Popup larger image'),
('en', 'portugese', 'Portuguese'),
('en', 'posid', 'Pos ID'),
('en', 'position', 'Position'),
('en', 'positions_updated', 'Positions of items were updated'),
('en', 'position_short', 'Pos.'),
('en', 'postal_mail', 'Postal mail'),
('en', 'postauth', 'Postauth'),
('en', 'post_url', 'Post URL'),
('en', 'powered_by', 'Powered by'),
('en', 'po_number', 'PO number'),
('en', 'preauth', 'Preauth'),
('en', 'preauthorization', 'Preauthorization'),
('en', 'prefix', 'Prefix'),
('en', 'preshared_key', 'PreShared Key'),
('en', 'prev', 'Prev.'),
('en', 'preview', 'Preview'),
('en', 'preview_file', 'Preview file'),
('en', 'previous', 'Previous'),
('en', 'previous_month', 'Previous month'),
('en', 'previous_period', 'Previous period'),
('en', 'previous_week', 'Previous week'),
('en', 'previous_year', 'Previous year'),
('en', 'prev_page', 'Prev'),
('en', 'price', 'Price'),
('en', 'price_decreased', 'Price has been decreased by'),
('en', 'price_dec_sign_delimiter', 'Price decimal separator'),
('en', 'price_includes_tax', 'Price includes tax'),
('en', 'price_increased', 'Price has been increased by'),
('en', 'price_in_points', 'Price in points'),
('en', 'price_summary', 'Price summary'),
('en', 'pricing_inventory', 'Pricing / inventory'),
('en', 'primary', 'Primary'),
('en', 'primary_currency', 'Primary currency'),
('en', 'print_card', 'Print card'),
('en', 'print_credit_memo', 'Print credit memo'),
('en', 'print_invoice', 'Print invoice'),
('en', 'edit_invoice', 'Edit invoice'),
('en', 'remove_invoice', 'Remove invoice'),
('en', 'print_order_details', 'Print order details'),
('en', 'print_packing_slip', 'Print packing slip'),
('en', 'print_pdf_packing_slip', 'Print packing slip (pdf)'),
('en', 'print_pdf_credit_memo', 'Print credit memo (pdf)'),
('en', 'print_pdf_invoice', 'Print invoice (pdf)'),
('en', 'print_pdf_order_details', 'Print order details (pdf)'),
('en', 'print_slip', 'Print slip'),
('en', 'priority', 'Priority'),
('en', 'private', 'Private'),
('en', 'private_customer_settings', 'Private customer settings'),
('en', 'privilege', 'Privilege'),
('en', 'privileges', 'Privileges'),
('en', 'privileges.change_order_status', 'Can change statuses'),
('en', 'privileges.create_order', 'Can create orders (only if editing entire orders is allowed)'),
('en', 'privileges.backup_restore', 'Can manage'),
('en', 'privileges.delete_logs', 'Can delete'),
('en', 'privileges.delete_orders', 'Can delete'),
('en', 'privileges.edit_blocks', 'Can edit'),
('en', 'privileges.edit_order', 'Can edit entire order (select other products, payment and shipping methods, customers)'),
('en', 'privileges.edit_files', 'Edit files'),
('en', 'privileges.exim_access', 'Can manage'),
('en', 'privileges.manage_catalog', 'Can edit'),
('en', 'privileges.manage_currencies', 'Can edit'),
('en', 'privileges.manage_design', 'Can edit'),
('en', 'privileges.manage_languages', 'Can edit'),
('en', 'privileges.manage_locations', 'Can edit'),
('en', 'privileges.manage_order_statuses', 'Can edit'),
('en', 'privileges.manage_pages', 'Manage pages'),
('en', 'privileges.manage_payments', 'Can edit'),
('en', 'privileges.manage_promotions', 'Can edit'),
('en', 'privileges.manage_reports', 'Can edit'),
('en', 'privileges.manage_shipping', 'Can edit'),
('en', 'privileges.manage_sitemap', 'Can edit'),
('en', 'privileges.manage_static_data', 'Can edit'),
('en', 'privileges.manage_storage', 'Can manage'),
('en', 'privileges.manage_stores', 'Manage stores');
INSERT INTO `[[dbprefix]]language_values` VALUES
('en', 'privileges.manage_taxes', 'Can edit'),
('en', 'privileges.manage_themes', 'Can edit'),
('en', 'privileges.manage_translation', 'Can edit'),
('en', 'privileges.manage_usergroups', 'Can manage customer user groups'),
('en', 'privileges.manage_users', 'Can edit'),
('en', 'privileges.manage_email_templates', 'Can edit'),
('en', 'privileges.manage_document_templates', 'Can edit'),
('en', 'privileges.update_settings', 'Can edit'),
('en', 'privileges.update_order_details', 'Can edit minor details (select manager; edit shipments, notes, and tracking number)'),
('en', 'privileges.upgrade_store', 'Can upgrade'),
('en', 'privileges.view_catalog', 'Can view'),
('en', 'privileges.view_currencies', 'Can view'),
('en', 'privileges.view_languages', 'Can view'),
('en', 'privileges.view_locations', 'Can view'),
('en', 'privileges.view_logs', 'Can view'),
('en', 'privileges.view_orders', 'Can view'),
('en', 'privileges.view_pages', 'Can view'),
('en', 'privileges.view_payments', 'Can view'),
('en', 'privileges.view_reports', 'Can view'),
('en', 'privileges.view_settings', 'Can view'),
('en', 'privileges.view_shipping', 'Can view'),
('en', 'privileges.view_static_data', 'Can view'),
('en', 'privileges.view_stores', 'View stores'),
('en', 'privileges.view_taxes', 'Can view'),
('en', 'privileges.view_usergroups', 'Can view'),
('en', 'privileges.view_users', 'Can view'),
('en', 'privilege_sections.addons', 'Add-on privileges'),
('en', 'privilege_sections.administration', 'Administration privileges'),
('en', 'privilege_sections.cart', 'Cart'),
('en', 'privilege_sections.products', 'Product privileges'),
('en', 'privilege_sections.settings', 'Settings privileges'),
('en', 'privilege_sections.catalog', 'Catalog'),
('en', 'privilege_sections.cms', 'CMS'),
('en', 'privilege_sections.design', 'Design privileges'),
('en', 'privilege_sections.orders', 'Order privileges'),
('en', 'privilege_sections.marketing', 'Marketing privileges'),
('en', 'privilege_sections.website', 'Website privileges'),
('en', 'privilege_sections.users', 'Customer privileges'),
('en', 'privilege_sections.vendors', 'Store privileges'),
('en', 'proceed', 'Proceed'),
('en', 'proceed_to_checkout', 'Proceed to checkout'),
('en', 'proceed_to_the_next_step', 'Proceed to the next step'),
('en', 'processed', 'Processed'),
('en', 'processing', 'Processing'),
('en', 'processing_order', 'Processing order'),
('en', 'processor', 'Processor'),
('en', 'processor_description_cardsave', 'Merchant Accounts provided by Worldpay Cardsave, <a href="http://www.cardsave.net">www.cardsave.net</a><br/><br/>Email: <a href=''mailto:ecomm@cardsave.net''>ecomm@cardsave.net</a>'),
('en', 'processor_description_p21', '<b>P21 Simple API</b> enables you to accept check payments. It offers the industry''s most comprehensive suite of check image creation and clearing solutions. With Check 21, you will receive your funds within the same day by check or direct deposit.<br/><br/>To activate the Check 21 option, please contact us via email at: <a href="mailto:support@payment21.com">support@payment21.com</a> or by phone at: +18887700850 (US Toll Free) or +41717401629 (International).<br/><br/><a href="http://www.payment21.com" target="_blank">www.payment21.com</a>'),
('en', 'processor_id', 'Processor ID'),
('en', 'process_selected', 'Process selected'),
('en', 'product', 'Product'),
('en', 'products', 'Products'),
('en', 'products_menu_title', 'Products'),
('en', 'products_deprecated', 'Products (Deprecated)'),
('en', 'products2', 'Products2'),
('en', 'products_added_to_cart', 'The products were added to your cart'),
('en', 'products_number_added_to_cart', '<b>[number]</b> products were added to your cart'),
('en', 'products_amount', 'Product quantity'),
('en', 'products_bar', 'Products bar'),
('en', 'products_cost', 'Products cost'),
('en', 'products_for_shipment_not_selected', 'Products for shipment were not selected'),
('en', 'products_found', 'Products found'),
('en', 'n_products_found', '[n] product found|[n] products found'),
('en', 'products_grid', 'Products grid'),
('en', 'products_information', 'Products information'),
('en', 'products_in_cart', 'Products in cart'),
('en', 'products_links_type', 'Products links type'),
('en', 'products_required', 'Please add product(s)'),
('en', 'products_stat', 'Product statistics'),
('en', 'products_weight', 'Products weight'),
('en', 'products_were_sent', 'The products have been sent out to you. The order information is given below'),
('en', 'product_added_to_cart', 'The product was added to your cart'),
('en', 'product_name_added_to_cart', '<b>[product]</b> was added to your cart'),
('en', 'product_added_to_cl', 'The product was added to your Comparison list'),
('en', 'product_cannot_be_added', 'The product cannot be added to cart. Check if all the uploading files meet the necessary conditions'),
('en', 'product_code', 'Product code'),
('en', 'product_columns', 'Product columns'),
('en', 'product_combinations', 'Product combinations'),
('en', 'product_coming_soon', 'This product can''t be added to cart now. It will be available on [avail_date]'),
('en', 'product_coming_soon_add', 'This product will be shipped on [avail_date]'),
('en', 'product_details', 'Product details page'),
('en', 'product_details_view', 'Product details view'),
('en', 'product_details_sidebar', 'Product details'),
('en', 'customer_info_sidebar', 'Customer info'),
('en', 'product_feature_cannot_assigned', 'The feature "[feature_name]" cannot be assigned to the product "[product_name]"'),
('en', 'product_fields', 'Product fields'),
('en', 'product_groups', 'Product groups'),
('en', 'product_id', 'Product ID'),
('en', 'product_images', 'Product images'),
('en', 'product_inventory', 'Product inventory'),
('en', 'product_in_cart', 'This product is already in the cart'),
('en', 'product_in_comparison_list', 'This product is already in the comparison list'),
('en', 'product_name', 'Product name'),
('en', 'product_notification_subscribed', 'You have been subscribed to the product in stock notifications'),
('en', 'product_notification_unsubscribed', 'You have been unsubscribed from the product in stock notifications'),
('en', 'product_notification_subscription_error', 'Cannot subscribe for the product in stock notification'),
('en', 'product_options', 'Product options'),
('en', 'product_options_forbidden_combination', 'The <strong>[product]</strong> product has options that are included in the forbidden combination. The product was deleted from the cart'),
('en', 'zero_price_product_was_deleted', 'The <strong>[product]</strong> product has zero price. The product was deleted from the cart'),
('en', 'product_disabled_options', 'The product <strong>[product]</strong> has options or option variants that are not available anymore, so it was removed from cart'),
('en', 'product_s', 'Product(s)'),
('en', 'product_subscriptions', 'Product subscriptions'),
('en', 'product_summary', 'Product summary'),
('en', 'product_tabs', 'Product tabs'),
('en', 'product_type', 'Product type'),
('en', 'profile', 'Profile'),
('en', 'profiles', 'Profiles'),
('en', 'profile_activated', 'Account activated'),
('en', 'profile_details', 'Profile details'),
('en', 'profile_fields', 'Profile fields'),
('en', 'profile_info', 'Profile information'),
('en', 'profile_name', 'Profile name'),
('en', 'project_id', 'Project ID'),
('en', 'project_password', 'Project password'),
('en', 'prolongate_download_key', 'Prolong download key to'),
('en', 'promotion', 'Promotion'),
('en', 'promotions', 'Promotions'),
('en', 'promotion_bonus_discount_on_categories', 'Discount on all products in categories'),
('en', 'promotion_bonus_discount_on_products', 'Discount on products'),
('en', 'promotion_bonus_free_products', 'Free products'),
('en', 'promotion_bonus_free_shipping', 'Free shipping'),
('en', 'promotion_bonus_give_coupon', 'Give coupon'),
('en', 'promotion_bonus_give_points', 'Give points'),
('en', 'promotion_bonus_give_usergroup', 'Give user group'),
('en', 'promotion_bonus_order_discount', 'Order discount'),
('en', 'promotion_bonus_product_discount', 'Product discount'),
('en', 'promotion_cond_auto_coupons', 'Automatically generated coupon codes'),
('en', 'promotion_cond_categories', 'Categories'),
('en', 'promotion_cond_country', 'Customer country (shipping)'),
('en', 'promotion_cond_coupon_code', 'Coupon code'),
('en', 'promotion_cond_feature', 'Product feature'),
('en', 'promotion_cond_number_of_usages', 'Number of usages'),
('en', 'promotion_cond_once_per_customer', 'Once per customer'),
('en', 'promotion_cond_payment', 'Payment method'),
('en', 'promotion_cond_price', 'Product price'),
('en', 'promotion_cond_products', 'Products'),
('en', 'promotion_cond_products_number', 'Total products in the cart'),
('en', 'promotion_cond_purchased_products', 'Purchased products'),
('en', 'promotion_cond_state', 'Customer state (shipping)'),
('en', 'promotion_cond_subtotal', 'Order subtotal'),
('en', 'promotion_cond_total', 'Order total'),
('en', 'promotion_cond_total_weight', 'Total products weight in the cart'),
('en', 'promotion_cond_usergroup', 'User group'),
('en', 'promotion_cond_users', 'Users'),
('en', 'promotion_cond_zip_postal_code', 'Customer zip/postal code (shipping)'),
('en', 'promotion_cond_shipping', 'Shipping methods'),
('en', 'promotion_op_amount', 'amount'),
('en', 'promotion_op_cont', 'contains'),
('en', 'promotion_op_eq', 'equal'),
('en', 'promotion_op_gt', 'greater'),
('en', 'promotion_op_gte', 'equal or greater'),
('en', 'promotion_op_in', 'in'),
('en', 'promotion_op_lt', 'less'),
('en', 'promotion_op_lte', 'equal or less'),
('en', 'promotion_op_ncont', 'doesn''t contain'),
('en', 'promotion_op_neq', 'not equal'),
('en', 'promotion_op_nin', 'not in'),
('en', 'promo_code', 'Promo code'),
('en', 'promo_text', 'Promo text'),
('en', 'properties', 'Properties'),
('en', 'provider', 'Provider'),
('en', 'pspid', 'PSPID'),
('en', 'public', 'Public'),
('en', 'purchased_in_orders', 'Purchased in orders'),
('en', 'purchased_qty', 'Purchased qty'),
('en', 'purchasers_name', 'From'),
('en', 'qty', 'Qty'),
('en', 'qty_discounts', 'Quantity discounts'),
('en', 'qty_discount_type_tooltip', 'Fixed amount/Percentage to be taken off the price'),
('en', 'quantity', 'Quantity'),
('en', 'quantity_long', 'Quantity'),
('en', 'quantity_step', 'Quantity step'),
('en', 'query', 'Query'),
('en', 'quick_checkout', 'Quick checkout'),
('en', 'quick_links', 'Quick links'),
('en', 'quick_menu', 'Quick start menu'),
('en', 'admin_menu.add_item', 'Add item'),
('en', 'admin_menu.add_item_for_menu_title', 'Add item for menu'),
('en', 'admin_menu.add_item_title', 'Add item'),
('en', 'admin_menu.edit_item_title', 'Edit item'),
('en', 'quick_product_viewer', 'Quick product viewer'),
('en', 'quick_view', 'Quick view'),
('en', 'radiogroup', 'Radio group'),
('en', 'random', 'Random'),
('en', 'rank_number', 'Rank (''machine'') number'),
('en', 'rates_depend_on', 'Rates depend on'),
('en', 'rate_calculation', 'Rate calculation'),
('en', 'rate_calculation_manual', 'Manual (by defined location)'),
('en', 'rate_calculation_manual_by_rate_area', 'Manual (by rate areas)'),
('en', 'rate_calculation_by_customer_address', 'By customer''s address'),
('en', 'rate_calculation_realtime', 'Realtime'),
('en', 'rate_calculation_realtime_automatic', 'Real-time (automatic)'),
('en', 'rate_value', 'Rate value'),
('en', 'read', 'Read'),
('en', 'readme', 'Readme'),
('en', 'read_more_3d_secure', 'Read more about 3-D Secure'),
('en', 'reason', 'Reason'),
('en', 'reasons', 'reasons'),
('en', 'reason_text', 'Payment processor response'),
('en', 'rebuild_cache_automatically', 'Rebuild cache automatically'),
('en', 'rebuild_cache_automatically_tooltip', 'Modified files are tracked in real time (including the files modified directly on server) and re-cached. Block cache will be disabled. Store performance may be slightly affected. Recommended to disable on production.'),
('en', 'rebuild_combinations', 'Rebuild combinations'),
('en', 'recalculate', 'Recalculate'),
('en', 'recalculate_rates', 'Recalculate rates'),
('en', 'recalculate_totals', 'Recalculate totals'),
('en', 'recent_activity', 'Recent activity'),
('en', 'recent_orders', 'Recent orders'),
('en', 'recent_products', 'Recently viewed'),
('en', 'recipient', 'Recipient'),
('en', 'recipients_name', 'To'),
('en', 'recipient_description', 'Description of the Merchant'),
('en', 'recommended', 'Recommended'),
('en', 'recover_password', 'Reset password'),
('en', 'recover_password_subj', 'Password recovery'),
('en', 'recursively', 'Recursively'),
('en', 'redirect_customer_from_storefront', 'Redirect visitors of this storefront to the one that has countries to which the visitors'' IP addresses belong defined'),
('en', 'referrers', 'Referrers'),
('en', 'referrer_domain', 'Referrer domain'),
('en', 'refresh', 'Refresh'),
('en', 'refresh_packages_list', 'Refresh available upgrades'),
('en', 'refund', 'Refund'),
('en', 'refunded', 'Refunded'),
('en', 'refunded_amount', 'Refunded amount'),
('en', 'regexp', 'RegExp'),
('en', 'regexp_hint', 'If you are using the regexp checking, it is necessary to set a prompting message informing of the incorrect filling of the field, otherwise, the checking will not be performed'),
('en', 'region', 'Region'),
('en', 'regions', 'Regions'),
('en', 'register', 'Register'),
('en', 'registered', 'Registered'),
('en', 'registered_customers', 'Registered customers'),
('en', 'register_new_account', 'Register for a new account'),
('en', 'register_profile', 'Register profile'),
('en', 'registration', 'Registration'),
('en', 'regnumber', 'Registration number'),
('en', 'related_order', 'Related order'),
('en', 'release_date', 'Release date'),
('en', 'remember_me', 'Remember me'),
('en', 'remove', 'Remove'),
('en', 'remove_backup_files', 'Remove backup files'),
('en', 'remove_cc_info', 'Remove CC info'),
('en', 'remove_this_item', 'Remove this item'),
('en', 'rename', 'Rename'),
('en', 'repay_order', 'Pay order'),
('en', 'report', 'Report'),
('en', 'reports', 'Reports'),
('en', 'reports_interval_1', 'Total'),
('en', 'reports_interval_3', 'Day'),
('en', 'reports_interval_5', 'Week'),
('en', 'reports_interval_7', 'Month'),
('en', 'reports_interval_9', 'Year'),
('en', 'reports_list', 'Reports list'),
('en', 'reports_parameter_1', 'Order totals'),
('en', 'reports_parameter_10', 'Shipping costs'),
('en', 'reports_parameter_11', 'Categories'),
('en', 'reports_parameter_12', 'Products'),
('en', 'reports_parameter_13', 'Product costs'),
('en', 'reports_parameter_14', 'The number of products'),
('en', 'reports_parameter_15', 'Managers'),
('en', 'reports_parameter_2', 'The number of orders'),
('en', 'reports_parameter_3', 'Orders'),
('en', 'reports_parameter_4', 'Statuses of orders'),
('en', 'reports_parameter_5', 'Payment methods'),
('en', 'reports_parameter_6', 'Rate areas'),
('en', 'reports_parameter_7', 'Users'),
('en', 'reports_parameter_8', 'Discounts and coupons'),
('en', 'reports_parameter_9', 'Taxes'),
('en', 'request', 'Request'),
('en', 'requests_count', 'Requests count'),
('en', 'requesttype', 'Request type'),
('en', 'request_account_name', 'Requested account name'),
('en', 'required', 'Required'),
('en', 'reset', 'Reset'),
('en', 'reset_filter', 'Reset filter'),
('en', 'reset_inventory', 'Reset inventory'),
('en', 'reset_quantity_to_zero', 'Set quantity of all products to zero'),
('en', 'reset_quantity_to_zero_tooltip', 'If you enable this setting, all the products in your store will have their quantity set to 0, except for the products that have the quantity specified in the imported file.'),
('en', 'reset_password', 'Reset password'),
('en', 'resolved', 'Resolved'),
('en', 'response', 'Response'),
('en', 'restore', 'Restore'),
('en', 'restore_default', 'Use default value'),
('en', 'restore_from_repository', 'Restore from the repository'),
('en', 'ResultCode', 'ResultCode'),
('en', 'ResultDescription', 'ResultDescription'),
('en', 'return', 'Return to normal view'),
('en', 'returning_customer', 'Returning customer'),
('en', 'return_url_target', 'Return URL target'),
('en', 'reuse', 'Reuse'),
('en', 'reversed', 'Reversed'),
('en', 'revert', 'Revert'),
('en', 're_order', 'Reorder this order'),
('en', 'right', 'Right'),
('en', 'right_to_left_orientation', 'Right to left orientation'),
('en', 'risk_checking', 'Risk checking is in process. Please try reloading this page in a minute.'),
('en', 'risk_information', 'Risk information'),
('en', 'romanian', 'Romanian'),
('en', 'root_category', 'Root category'),
('en', 'root_level', 'Root level'),
('en', 'root_page', 'Root level page'),
('en', 'round_to', 'Round to'),
('en', 'routing_code', 'Routing Number'),
('en', 'runtime', 'Runtime'),
('en', 'russian', 'Russian'),
('en', 'sale', 'Sale'),
('en', 'sales', 'Sales'),
('en', 'sales_commission', 'Sales commission'),
('en', 'sales_reports', 'Sales reports'),
('en', 'same_as_source', 'same as source'),
('en', 'save', 'Save'),
('en', 'saved_search', 'Saved searches'),
('en', 'save_and_close', 'Save and close'),
('en', 'save_as', 'Save As...'),
('en', 'save_changes', 'Save changes'),
('en', 'save_discount', 'Save'),
('en', 'save_layout', 'Save layout'),
('en', 'save_layout_as', 'Save layout as'),
('en', 'save_process_payment', 'Save and process payment'),
('en', 'save_this_search_as', 'Save this search as'),
('en', 'scb_text_notice', 'Please send the following URL to the SCB support to be set as PostbackURL: <br /><b>[return_url]</b>'),
('en', 'screen', 'Screen'),
('en', 'screen_resolution', 'Screen resolution'),
('en', 'script', 'Script'),
('en', 'tmpl_scroller', 'Scroller'),
('en', 'scroller_direction', 'Auto-scroll direction'),
('en', 'search', 'Search'),
('en', 'admin_search_title', 'Search'),
('en', 'admin_search_button', 'Search'),
('en', 'admin_search_field', 'Search'),
('en', 'admin_search_general', 'Search'),
('en', 'storefront_search_button', 'Search'),
('en', 'storefront_search_field', 'Search'),
('en', 'storefront_search_label', 'Search'),
('en', 'storefront_search_general', 'Search'),
('en', 'search_again', 'Search again'),
('en', 'search_by_order', 'Search by order'),
('en', 'search_by_customer', 'Search by customer'),
('en', 'search_by_owner', 'Search by owner'),
('en', 'search_by_price', 'Search by price'),
('en', 'search_by_product_features', 'Search by product features'),
('en', 'search_by_product_filters', 'Search by product filters'),
('en', 'search_by_sku', 'Search by product code'),
('en', 'search_by_vendor', 'Search by store'),
('en', 'search_by_weight', 'Search by weight'),
('en', 'search_engine', 'Search engine'),
('en', 'search_for_pattern', 'Search for pattern'),
('en', 'search_in', 'Search in'),
('en', 'search_in_category', 'Search in category'),
('en', 'search_in_subcategories', 'Search in subcategories'),
('en', 'search_options', 'Search options'),
('en', 'search_product', 'Search product'),
('en', 'search_products', 'Search products'),
('en', 'searching_all_products', 'Searching all products'),
('en', 'search_results', 'Search results'),
('en', 'search_results_for', 'Search results for [search]'),
('en', 'search_string', 'Search string'),
('en', 'search_words', 'Search words'),
('en', 'secret_key', 'Secret key'),
('en', 'secret_string', 'Secret string'),
('en', 'secret_word', 'Secret word'),
('en', 'section', 'Section'),
('en', 'section_is_not_completed', 'Section is not completed.'),
('en', 'section_links', 'Section links'),
('en', 'section_name', 'Section name'),
('en', 'secure', 'Secure'),
('en', 'security', 'Security'),
('en', 'secure_checkout', 'Secure checkout'),
('en', 'secure_storefront_url', 'Secure storefront URL'),
('en', 'store_access_key', 'Access key to temporarily closed store'),
('en', 'secure_storefront_url_already_exists', 'The value of the <strong>Secure storefront URL</strong> parameter mentioned by you already belongs to another company.'),
('en', 'url_access_storefront', 'Use the following URL to access the storefront:<br><a href="[url]" target="_blank">[url]</a>'),
('en', 'security_settings', 'Security settings'),
('en', 'see_demo', 'See demo'),
('en', 'select', 'Select'),
('en', 'selectbox', 'Select box'),
('en', 'selected', 'Selected'),
('en', 'selected_fields', 'Selected fields'),
('en', 'selected_items', 'Selected items'),
('en', 'select_all', 'Select all'),
('en', 'select_all_product_options', 'You should select all product options'),
('en', 'select_block', 'Select block'),
('en', 'select_country', 'Select country'),
('en', 'select_customer', 'Select customer'),
('en', 'select_dates', 'Select dates'),
('en', 'period_selector_from', 'From'),
('en', 'period_selector_to', 'To'),
('en', 'select_descr_lang', 'Select the description language'),
('en', 'select_fields_to_edit', 'Select fields to edit'),
('en', 'select_file', 'Select file'),
('en', 'select_image', 'Select image'),
('en', 'select_options', 'Select options'),
('en', 'select_option_above', 'Select the previous option first'),
('en', 'select_product', 'Select product'),
('en', 'select_products', 'Select products'),
('en', 'select_profile', 'Select profile'),
('en', 'select_shipping_method', 'Select shipping method'),
('en', 'select_state', 'Select state'),
('en', 'select_tables', 'Select tables'),
('en', 'select_storefront', 'Select [store] storefront'),
('en', 'semicolon', 'Semicolon'),
('en', 'send', 'Send'),
('en', 'sender', 'Sender'),
('en', 'send_feedback', 'Help us improve [product]'),
('en', 'send_notification', 'Send notification to selected'),
('en', 'send_shipment_notification_to_customer', 'Send shipment notification to customer'),
('en', 'send_shipping_address', 'Send customer shipping address'),
('en', 'send_via', 'Send via'),
('en', 'send_via_email', 'Send via email'),
('en', 'send_via_postal_mail', 'Send via postal mail'),
('en', 'seo_meta_data', 'Meta data'),
('en', 'sequential', 'Sequential'),
('en', 'server', 'Server'),
('en', 'service_not_available', 'This service is not available.'),
('en', 'settings', 'Settings'),
('en', 'settings_wizard', 'Settings wizard'),
('en', 'settings_wizard_close_tooltip', 'Wizard will be possible to re-open in the menu ''Settings -> Settings wizard''.'),
('en', 'settings_wizard_title', 'Settings wizard: Step [current_step] of [total_steps]'),
('en', 'store_mode_menu_description', 'View and manage your licensing details.'),
('en', 'upgrade_center_menu_description', 'Get the latest versions of CS-Cart and its add-ons.'),
('en', 'import_data_menu_description', 'Import products, orders, users and more.'),
('en', 'export_data_menu_description', 'Export products, orders, users and more.'),
('en', 'languages_menu_description', 'Configure the available languages and edit any texts on your site.'),
('en', 'storage_menu_description', 'Back up your site data or restore a previous copy, manage files and CDN.'),
('en', 'settings_general', 'General'),
('en', 'settings_general_menu_description', 'Configure your company info and basic principles of how your site works.'),
('en', 'payment_methods_menu_description', 'Set up the payment options available to your customers.'),
('en', 'shipping_methods_menu_description', 'Set up shipping options, their rates and availability by location.'),
('en', 'taxes_menu_description', 'Configure what taxes you show, how you do it, and tax rates by location.'),
('en', 'storefronts_menu_description', 'Create regional or thematic branches, manage common storefront details.'),
('en', 'stores_menu_description', 'Create regional or thematic branches, manage common storefront details.'),
('en', 'profile_fields_menu_description', 'Manage information collected from customers and sellers.'),
('en', 'notifications_menu_description', 'Manage the notifications sent to customers, administrators and sellers.'),
('en', 'logs_menu_description', 'Store activity log.'),
('en', 'sync_data_manage', 'Sync data'),
('en', 'sync_data_manage_menu_description', 'Connect your store with external systems.'),
('en', 'currencies_menu_description', 'Set up the currencies in which you show the prices to customers.'),
('en', 'statuses_management_menu_description', 'Edit the possible statuses for orders, shipments, etc.'),
('en', 'share', 'Share'),
('en', 'share.congratulations_first_order', 'Congratulations on your first complete order.'),
('en', 'share.first_order_tweet', 'Wow! The first complete order in my [product]-powered store'),
('en', 'share.installation_tweet', 'I have just created an online store with [product_name]'),
('en', 'sharedsec', 'SharedSec'),
('en', 'shared_secret', 'Shared Secret'),
('en', 'sha_sign', 'SHA-1 Signature'),
('en', 'shipment', 'Shipment'),
('en', 'shipments', 'Shipments'),
('en', 'shipment_date', 'Shipment date'),
('en', 'shipment_details', 'Shipment details'),
('en', 'shipment_has_been_created', 'Shipment has been created'),
('en', 'shipment_id', 'Shipment ID'),
('en', 'shipment_info', 'Shipment information'),
('en', 'shipped', 'Shipped'),
('en', 'shipped_products', 'Shipped products'),
('en', 'shipper_number', 'Shipper number'),
('en', 'shipping', 'Shipping'),
('en', 'shippings', 'Shippings'),
('en', 'shippings.service_not_configured', 'Service is not configured'),
('en', 'shippings.service_not_found', 'Service was not found'),
('en', 'shippings.currency_not_found', 'Currency [currency] was not found'),
('en', 'shippings_taxes', 'Shipping & taxes'),
('en', 'shipping_address', 'Shipping address'),
('en', 'shipping_charges', 'Shipping charges'),
('en', 'shipping_time_and_charges', 'Shipping time and rates'),
('en', 'shipping_cost', 'Shipping cost'),
('en', 'shipping.pricing', 'Pricing'),
('en', 'shipping_estimation', 'Shipping estimation'),
('en', 'shipping_freight', 'Shipping freight'),
('en', 'shipping_information', 'Shipping information'),
('en', 'shipping_method', 'Shipping method'),
('en', 'shipping_methods', 'Shipping methods'),
('en', 'shipping_name', 'Shipping name'),
('en', 'shipping_options', 'Shipping Options'),
('en', 'shipping_properties', 'Shipping properties'),
('en', 'shipping_rates', 'Shipping rates'),
('en', 'shipping_same_as_billing', 'Are shipping and billing addresses the same?'),
('en', 'shipping_service', 'Shipping service'),
('en', 'shipping_time', 'Shipping time'),
('en', 'shipping_rate', 'Rate'),
('en', 'shipping_condition', 'Condition'),
('en', 'shipping_price_condition', 'Price condition'),
('en', 'shipping_weight_condition', 'Weight condition'),
('en', 'shipping_items_condition', 'Items condition'),
('en', 'shipping_surcharge_discount', 'Surcharge / Discount'),
('en', 'shipping_per', 'per'),
('en', 'shipping_from_value', 'From'),
('en', 'shipping_to_value', 'To'),
('en', 'shipping_and_up', 'and up'),
('en', 'shipping_item', 'item'),
('en', 'shipping_add_conditions', 'Add conditions'),
('en', 'shipping_hide_conditions', 'Hide conditions'),
('en', 'shipping_add_price_condition', 'Add price conditions'),
('en', 'shipping_add_weight_condition', 'Add weight conditions'),
('en', 'shipping_add_items_condition', 'Add items conditions'),
('en', 'shipping_remove_price_condition', 'Remove price conditions'),
('en', 'shipping_remove_weight_condition', 'Remove weight conditions'),
('en', 'shipping_remove_items_condition', 'Remove items conditions'),
('en', 'shipping_edit_rate_area', 'Edit rate area'),
('en', 'shipping_remove_rate_area', 'Remove rate area from shipping'),
('en', 'shipping_rate_range_overlap_error_message', 'Condition must not fall within existing range.'),
('en', 'shipping_rate_range_limit_error_message', 'The beginning of the range can''t be higher than the end.'),
('en', 'shipping_rate_absolute', 'Absolute ([currency])'),
('en', 'shipping_rate_percent', 'Cart percent (%)'),
('en', 'ship_dhl_height', 'Package height'),
('en', 'ship_dhl_length', 'Package length'),
('en', 'ship_dhl_site_id', 'Site ID'),
('en', 'ship_dhl_width', 'Package width'),
('en', 'ship_fedex_ancillary_endorsement', 'Ancillary Endorsements'),
('en', 'ship_fedex_ancillary_endorsement_address_correction', 'Address Service Requested'),
('en', 'ship_fedex_ancillary_endorsement_carrier_leave_if_no_response', 'Carrier Leave If No Response'),
('en', 'ship_fedex_ancillary_endorsement_change_service', 'Change Service Requested'),
('en', 'ship_fedex_ancillary_endorsement_forwarding_service', 'Forwarding Service Requested'),
('en', 'ship_fedex_ancillary_endorsement_return_delivery', 'Return Service Requested'),
('en', 'ship_fedex_customer_manifest_id', 'Customer manifest ID'),
('en', 'ship_fedex_drop_off_type', 'Drop Off Type'),
('en', 'ship_fedex_drop_off_type_regular_pickup', 'Regular pickup'),
('en', 'ship_fedex_drop_off_type_request_courier', 'Request courier'),
('en', 'ship_fedex_drop_off_type_station', 'Drop at station'),
('en', 'ship_fedex_height', 'Height (inches)'),
('en', 'ship_fedex_hub_id', 'Hub ID'),
('en', 'ship_fedex_indicia', 'Indicia'),
('en', 'ship_fedex_indicia_media_mail', 'Media Mail (Packages from 1 to 70 lbs Books, DVDs, CDs, videotapes)'),
('en', 'ship_fedex_indicia_parcel_select', 'Parcel Select (Packages from 1 to 70 lbs)'),
('en', 'ship_fedex_indicia_presorted_bound_printed_matter', 'Bound Printed Matter packages (Packages from 1 to 15 lbs Catalogs, phone books or anything permanently bound)'),
('en', 'ship_fedex_indicia_presorted_standard', 'Standard Mail packages (Packages less than 1 lb)'),
('en', 'ship_fedex_length', 'Length (inches)'),
('en', 'ship_fedex_meter_number', 'Meter number'),
('en', 'ship_fedex_package_type_fedex_10kg_box', 'FedEx 10kg Box'),
('en', 'ship_fedex_package_type_fedex_25kg_box', 'FedEx 25kg Box'),
('en', 'ship_fedex_package_type_fedex_box', 'FedEx Box'),
('en', 'ship_fedex_package_type_fedex_envelope', 'FedEx Envelope'),
('en', 'ship_fedex_package_type_fedex_pak', 'FedEx Pak'),
('en', 'ship_fedex_package_type_fedex_tube', 'FedEx Tube'),
('en', 'ship_fedex_package_type_your_packaging', 'Your packaging'),
('en', 'ship_fedex_smart_post', 'Smart Post'),
('en', 'ship_fedex_special_services', 'Special service (delivery confirmation)'),
('en', 'ship_fedex_width', 'Width (inches)'),
('en', 'ship_height', 'Package height (cm)'),
('en', 'ship_length', 'Package length (cm)'),
('en', 'ship_sp_l_acknowledgement_of_delivery', 'Acknowledgement of delivery (for registered mail only)'),
('en', 'ship_sp_l_cash_on_delivery', 'Cash on delivery (for registered mail only)'),
('en', 'ship_sp_l_personal_delivery', 'Personal delivery (for registered mail only)'),
('en', 'ship_sp_l_registered_mail', 'Registered mail'),
('en', 'ship_sp_pc_assurance', 'Assurance'),
('en', 'ship_sp_pc_cash_on_delivery', 'Cash on delivery (COD)'),
('en', 'ship_sp_pc_fragile', 'Fragile'),
('en', 'ship_sp_pc_manual_handling', 'Manual handling'),
('en', 'ship_sp_pc_personal', 'Personal'),
('en', 'ship_sp_pc_signature', 'Signature'),
('en', 'ship_sp_pp_additional_insurance', 'Additional insurance (up to CHF 3000.-)'),
('en', 'ship_sp_pp_bulky_goods', 'Bulky goods'),
('en', 'ship_sp_pp_cash_on_delivery', 'Cash on delivery (ECONOMY only)'),
('en', 'ship_sp_pp_manual_processing', 'Manual processing'),
('en', 'ship_sp_ur_additional_insurance', 'Additional insurance for URGENT goods  (up to CHF 3000.-)'),
('en', 'ship_swisspost_error_intl_delivery', 'Cannot use this shipping method for the international delivery'),
('en', 'ship_swisspost_error_private_delivery', 'Cannot use this shipping method for the private delivery'),
('en', 'ship_swisspost_heavy_package', 'The package is too heavy'),
('en', 'ship_swisspost_unable_to_open_additional_services', 'Cannot open the additional_services.csv file'),
('en', 'ship_swisspost_unable_to_open_service', 'Cannot open the [code] file'),
('en', 'ship_to', 'Ship to'),
('en', 'ship_to_another', 'Ship to a different address'),
('en', 'ship_ups_access_key', 'UPS Rates Access Key'),
('en', 'ship_ups_package_type_01', 'UPS letter/ UPS Express Envelope'),
('en', 'ship_ups_package_type_03', 'UPS Tube'),
('en', 'ship_ups_package_type_04', 'UPS Pack'),
('en', 'ship_ups_package_type_21', 'UPS Express Box'),
('en', 'ship_ups_package_type_24', 'UPS 25Kg Box'),
('en', 'ship_ups_package_type_25', 'UPS 10Kg Box'),
('en', 'ship_ups_pickup_type', 'Pickup type'),
('en', 'ship_ups_pickup_type_01', 'Daily Pickup'),
('en', 'ship_ups_pickup_type_03', 'Customer Counter'),
('en', 'ship_ups_pickup_type_06', 'One Time Pickup'),
('en', 'ship_ups_pickup_type_07', 'On Call Air'),
('en', 'ship_ups_pickup_type_11', 'Suggested Retail Rates'),
('en', 'ship_ups_pickup_type_19', 'Letter Center'),
('en', 'ship_ups_pickup_type_20', 'Air Service Center'),
('en', 'ship_ups_delivery_confirmation', 'No Signature'),
('en', 'ship_ups_delivery_confirmation_signature', 'Signature Required'),
('en', 'ship_ups_delivery_confirmation_adult_signature', 'Adult Signature Required'),
('en', 'ship_ups_use_delivery_confirmation', 'Use Delivery confirmation'),
('en', 'ship_ups_dcist_type', 'Confirmation type'),
('en', 'ship_usps_container', 'Container'),
('en', 'ship_usps_container_express', 'Container (Express)'),
('en', 'ship_usps_container_express_flat_rate_envelope', 'Flat Rate Envelope'),
('en', 'ship_usps_container_priority', 'Container (Priority Mail)'),
('en', 'ship_usps_container_priority_flat_rate_box', 'Flat Rate Box'),
('en', 'ship_usps_container_priority_flat_rate_envelope', 'Flat Rate Letter'),
('en', 'ship_usps_container_priority_lg_flat_rate_box', 'Large Flat Rate Box'),
('en', 'ship_usps_container_priority_md_flat_rate_box', 'Medium Flat Rate Box'),
('en', 'ship_usps_container_priority_nonrectangular', 'NonRectangular'),
('en', 'ship_usps_container_priority_rectangular', 'Rectangular'),
('en', 'ship_usps_container_priority_regional_a_rate_box', 'Regional Rate Box A'),
('en', 'ship_usps_container_priority_regional_b_rate_box', 'Regional Rate Box B'),
('en', 'ship_usps_container_priority_regional_c_rate_box', 'Regional Rate Box C'),
('en', 'ship_usps_container_priority_sm_flat_rate_box', 'Small Flat Rate Box'),
('en', 'ship_usps_container_priority_padded_flat_rate_envelope', 'Padded Flat Rate Envelope'),
('en', 'ship_usps_container_priority_legal_flat_rate_envelope', 'Legal Flat Rate Envelope'),
('en', 'ship_usps_container_priority_sm_flat_rate_envelope', 'Sm Flat Rate Envelope'),
('en', 'ship_usps_container_priority_window_flat_rate_envelope', 'Window Flat Rate Envelope'),
('en', 'ship_usps_container_priority_gift_card_flat_rate_envelope', 'Gift Card Flat Rate Envelope'),
('en', 'ship_usps_first_class_mail_type', 'First Class Mail Type'),
('en', 'ship_usps_first_class_mail_type_flat', 'Flat'),
('en', 'ship_usps_first_class_mail_type_parcel', 'Parcel'),
('en', 'ship_usps_intl_package_girth', 'Package girth'),
('en', 'ship_usps_intl_package_height', 'Package height'),
('en', 'ship_usps_intl_package_length', 'Package length'),
('en', 'ship_usps_intl_package_size', 'Package size'),
('en', 'ship_usps_intl_package_width', 'Package width'),
('en', 'ship_usps_machinable', 'Machinable (First-Class Mail or Standard Post)'),
('en', 'ship_usps_machinable_false', 'False'),
('en', 'ship_usps_machinable_true', 'True'),
('en', 'ship_usps_mailtype', 'Type of Mail'),
('en', 'ship_usps_mailtype_matter_for_the_blind', 'Matter for the Blind'),
('en', 'ship_usps_mailtype_postcards_or_aerogrammes', 'Postcards or Aerogrammes'),
('en', 'ship_usps_package_size', 'Package Size (length + girth, inches)'),
('en', 'ship_usps_package_size_large', 'Large (84..108)'),
('en', 'ship_usps_package_size_oversize', 'Oversize (108..130)'),
('en', 'ship_usps_package_size_regular', 'Regular (0..84)'),
('en', 'ship_usps_priority_girth', 'Priority Mail (Size:Large, Container:NonRectangular) Girth (inches)'),
('en', 'ship_usps_priority_height', 'Priority Mail (Size:Large) Height (inches)'),
('en', 'ship_usps_priority_length', 'Priority Mail (Size:Large) Length (inches)'),
('en', 'ship_usps_priority_width', 'Priority Mail (Size:Large) Width (inches)'),
('en', 'ship_usps_username', 'User ID'),
('en', 'ship_width', 'Package width (cm)'),
('en', 'short_description', 'Short description'),
('en', 'short_hour', 'h.'),
('en', 'short_list', 'Short list'),
('en', 'show', 'Show'),
('en', 'show_all', 'Show all'),
('en', 'show_items_in_line', 'Show items inline'),
('en', 'show_orders', 'Show orders'),
('en', 'show_price', 'Show price'),
('en', 'show_rate_for_destination', 'Show rates for location'),
('en', 'show_rate_for_rate_area', 'Show rates for rate area'),
('en', 'show_tab_in_popup', 'Show this tab in a popup window'),
('en', 'tmpl_sidebox_1_item', 'Side box first item'),
('en', 'sidebox_general', 'Ordinary block (H3 heading) [deprecated]'),
('en', 'sidebox_important', 'Ordinary block (H3 heading)'),
('en', 'signature', 'Signature'),
('en', 'signed_in_as', 'Signed in as'),
('en', 'sign_in', 'Sign in'),
('en', 'sign_in_as_different', 'Sign in as a different user'),
('en', 'sign_in_to_buy', 'Please sign in to buy'),
('en', 'sign_in_to_view_price', '[Sign in to view price]'),
('en', 'sign_out', 'Sign out'),
('en', 'sign_up_for_notification', 'Sign up for notification'),
('en', 'similar_only', 'Similar only'),
('en', 'simple_ultimate_companies_selector', 'Please contact the technical support'),
('en', 'simultaneous', 'Simultaneous'),
('en', 'single', 'Single'),
('en', 'single_coupon_is_allowed', 'Single discount coupon is allowed only'),
('en', 'sitemap', 'Sitemap'),
('en', 'sitemap_settings', 'Sitemap settings'),
('en', 'site_number', 'Site number (EPT)'),
('en', 'size', 'Size'),
('en', 'skiplastpage', 'Skip the last page'),
('en', 'skip_payment', 'Skip payment'),
('en', 'skrill_customer_id', 'Skrill Customer ID'),
('en', 'sku', 'CODE'),
('en', 'slovak', 'Slovak'),
('en', 'slow', 'Slow'),
('en', 'small_items', 'Small items'),
('en', 'smarty_block', 'HTML block with Smarty support'),
('en', 'sms_customer_registered', 'Customer [name] has been registered.'),
('en', 'sms_for_the_sum', 'to the amount of'),
('en', 'sms_order_placed', 'has been placed'),
('en', 'snapshot_date', 'Snapshot date'),
('en', 'sort_by', 'Sort by'),
('en', 'sort_by_null_asc', 'No sorting'),
('en', 'sort_by_popularity_asc', 'Sort by Popularity: Low to High'),
('en', 'sort_by_popularity_desc', 'Sort by Popularity'),
('en', 'sort_by_position_asc', 'Sort by Position: Low to High'),
('en', 'sort_by_position_desc', 'Sort by Position: High to Low'),
('en', 'sort_by_price_asc', 'Sort by Price: Low to High'),
('en', 'sort_by_price_desc', 'Sort by Price: High to Low'),
('en', 'sort_by_product_asc', 'Sort Alphabetically: A to Z'),
('en', 'sort_by_product_desc', 'Sort Alphabetically: Z to A'),
('en', 'sort_by_timestamp_asc', 'Oldest Items First'),
('en', 'sort_by_timestamp_desc', 'Newest Items First'),
('en', 'sort_images', 'Sort images'),
('en', 'spanish', 'Spanish'),
('en', 'specific_settings', 'Specific settings'),
('en', 'specify_url', 'Specify URL'),
('en', 'speed', 'Speed'),
('en', 'tooltip_carousel_speed', 'The time of the animation in milliseconds. The shorter the time, the faster the animation.'),
('en', 'type_to_search', 'Type to search...'),
('en', 'type_to_create', 'Type to create...'),
('en', 'type_to_search_or_click_button', 'Type to search, or click the button on the right for advanced search'),
('en', 'use_comma_enter_to_separate_variants', 'Use a comma or Enter to separate variants.'),
('en', 'enter_color_name_and_code', 'Enter color name and code. Example, "Red #ff0000"'),
('en', 'enter_category_name_and_path', 'Enter path and category name. Example, "Electronics/Computers/Laptops"'),
('en', 'object_picker.remove_all_items', 'Remove all items'),
('en', 'ssl_certificate', 'SSL certificate'),
('en', 'staff_only_notes', 'Staff only notes'),
('en', 'stage', 'Stage'),
('en', 'standard_sidebox', 'Standard side box'),
('en', 'start', 'Start'),
('en', 'start_communication', 'Start communication'),
('en', 'start_date', 'Start date'),
('en', 'start_price', 'Start price'),
('en', 'state', 'State/Province'),
('en', 'states', 'States'),
('en', 'static_block', 'Static block'),
('en', 'static_data', 'Static data'),
('en', 'static_data_use_item', 'Use the "Link text" and "URL" values from this item in the storefront'),
('en', 'statistics', 'Statistics'),
('en', 'status', 'Status'),
('en', 'status_changed', 'Status has been changed'),
('en', 'no_active_storefronts', 'No active storefronts'),
('en', 'status_changed_after_process_payment', 'Order status was set according to the payment processing result'),
('en', 'stay_connected', 'Stay Connected'),
('en', 'stay_connected_notice', 'Enter your email address to receive special offers and promotions.'),
('en', 'step_four', 'Step 4'),
('en', 'step_one', 'Step 1'),
('en', 'step_three', 'Step 3'),
('en', 'step_two', 'Step 2'),
('en', 'stop_other_rules', 'Stop other rules'),
('en', 'storage', 'Storage'),
('en', 'store', 'Store'),
('en', 'storefront', 'Storefront'),
('en', 'storefront_url', 'Storefront URL'),
('en', 'storefront_url_already_exists', 'The value of the <strong>Storefront URL</strong> parameter mentioned by you already belongs to another company.'),
('en', 'storefront_url_not_defined', 'Storefront URL not defined'),
('en', 'stores_status', 'Status'),
('en', 'storefront_status_access_key_hint', 'Even if the storefront is closed (the status set to OFF), you''ll be able to view it if you have an access key. Go to <a target="blank" href="[url]">Settings → General</a> and specify the <i>Access key to temporarily closed store</i> setting. Please note that a different key can be specified for each storefront, so make sure to select the correct storefront first. Use the key as described in the tooltip of that setting.'),
('en', 'stores', 'Stores'),
('en', 'store_mode', 'Licensing mode'),
('en', 'store_mode_changed', 'Licensing mode has been changed'),
('en', 'store_number', 'Store number'),
('en', 'store_object_denied', 'The [object_type] [object_name] is unavailable for this store.'),
('en', 'store_theme', 'Storefront theme'),
('en', 'subcategories', 'Subcategories'),
('en', 'submit', 'Submit'),
('en', 'submit_my_order', 'Submit my order'),
('en', 'subpages', 'Subpages'),
('en', 'subscribe', 'Subscribe'),
('en', 'subscriber', 'Subscriber'),
('en', 'subscribers', 'Subscribers'),
('en', 'subscriber_email', 'Subscriber email'),
('en', 'subscriptions', 'Subscriptions'),
('en', 'subtotal', 'Subtotal'),
('en', 'subtotal_sum', 'Subtotal sum'),
('en', 'suburb', 'Suburb'),
('en', 'successful', 'Successful'),
('en', 'successfully_registered', 'Successfully registered'),
('en', 'successful_login', 'You have been successfully logged in.'),
('en', 'success_registration_text', 'Congratulations! The registration was successful!<br/>Now, you have full access to all the store features. Click on "My account" to see them.'),
('en', 'suffix', 'Suffix'),
('en', 'summary', 'Summary'),
('en', 'supplier', 'Supplier'),
('en', 'suppliers', 'Suppliers'),
('en', 'supplier_id', 'Supplier'),
('en', 'surcharge', 'Surcharge'),
('en', 'surcharge_title', 'Surcharge title'),
('en', 'sweden', 'Sweden'),
('en', 'swedish', 'Swedish'),
('en', 'swing', 'Swing'),
('en', 'switch_layout', 'Switch layout'),
('en', 'layout_page', 'Layout Page'),
('en', 'layout_meta_data', 'Meta data & more'),
('en', 'symbol', 'Symbol'),
('en', 'system', 'System'),
('en', 'tab', 'Tab'),
('en', 'table', 'Table'),
('en', 'tables', 'Tables'),
('en', 'table_conditions', 'Table Conditions'),
('en', 'tabs', 'Tabs'),
('en', 'tax', 'Tax'),
('en', 'taxes', 'Taxes'),
('en', 'tax_exempt', 'Tax exempt'),
('en', 'tax_rates', 'Tax rates'),
('en', 'template', 'Template'),
('en', 'templates_tree', 'Templates tree'),
('en', 'file_editor', 'File editor'),
('en', 'file_editor_archive_contains_incorrect_paths', 'Archive contains files with incorrect paths.'),
('en', 'terminal', 'Terminal'),
('en', 'terminal_id', 'Terminal ID'),
('en', 'test', 'Test'),
('en', 'test_live_mode', 'Test/Live mode'),
('en', 'test_mode', 'Test mode'),
('en', 'text', 'Text'),
('en', 'textarea', 'Text area'),
('en', 'text_2checkout_notice', '<b>Note</b>: In order to track your 2Checkout orders with the shopping cart software you have to take these steps:<br /><br />-&nbsp;Log in to your 2Checkout account<br />-&nbsp;Click on <u>''Site management''</u> in the <u>''Account''</u> section.<br />-&nbsp;Select <b>''Given links back to my website''</b> option in the <u>''Direct Return''</u> subsection <br />-&nbsp;Set <u>''Approved URL''</u> and <u>''Pending URL''</u> to:<br /><b>[return_url]</b><br />-&nbsp;Set <u>''Secret Word''</u>. The Secret Word is known only to the seller and 2CheckOut.<br />'),
('en', 'text_2co_ins', 'Instant Notification Service (INS)'),
('en', 'text_additional_detailed_image', '(displayed in popup window)'),
('en', 'text_additional_thumbnail', '(displayed on product details page in "Additional images")'),
('en', 'addon_files_was_copied', 'The <b>"[addon]"</b> add-on files has been copied successfully'),
('en', 'text_addon_cannot_enable', 'Add-on "[addon_name]" is incompatible with the following add-ons: [addons]. It cannot be enabled'),
('en', 'text_addon_confclicts', 'Add-on "[addon_name]" is incompatible with the following add-ons: [addons]. These add-ons will be automatically disabled.'),
('en', 'text_addon_confclicts_on_install', 'Add-on "[addon_name]" is incompatible with the following add-ons: [addons]. It has not been be enabled. Enable it manually and all the incompatible add-ons will be disabled automatically.'),
('en', 'text_addon_installed', 'The <b>"[addon]"</b> add-on has been installed successfully'),
('en', 'text_addon_install_dependencies', 'The add-on cannot be installed because a dependence on the [addon] add-on is set for it. Please install the [addon] add-on first.'),
('en', 'text_addon_refreshed', 'The settings and language variables of the <b>"[addon]"</b> add-on have been updated successfully'),
('en', 'text_addon_uninstalled', 'The <b>"[addon]"</b> add-on has been uninstalled.'),
('en', 'text_addon_uninstall_dependencies', 'The add-on cannot be uninstalled because the following add-ons depend on it: [addons]'),
('en', 'text_addresses_wildcards', 'You are able to use wildcards in this field:<br /><b>''?''</b> - any single character;<b>''*''</b> - any number of characters.<br /><br /><u>Example:</u><br /><b>* street</b> &nbsp;&nbsp;(corresponds to 1st Street, 102nd Street, etc)'),
('en', 'text_admin_new_orders', 'This section shows the orders you have never viewed.'),
('en', 'text_allowed_to_upload_file_extension', 'The following file extensions are supported: <b>[ext]</b>.'),
('en', 'text_amazon_callback_url', 'Important! You must specify your store''s URL <b>[callback_url]</b> as the Merchant URL on the Amazon''s Seller Central Website (Settings > Checkout Pipeline Settings). Otherwise, you won''t be able to accept payments through Amazon Checkout in your store'),
('en', 'text_amazon_failed_order', 'No response from Amazon Checkout has been received yet, please hold on. Although the order might not be created in the store as long last, it is highly probable that it has been successfully created and processed by Amazon Checkout. Please contact the store staff and tell them the order ID as provided by Amazon'),
('en', 'text_amazon_incorrect_products_count', 'Number of products in your cart differs from the number of products in the Amazon request.'),
('en', 'text_amazon_link_message', 'For testing purposes, the Merchant URL may be the HTTP link to your store, but the live mode requires secure connection and you must use the HTTPS link. Also, remember to enable the production mode on Amazon''s Seller Central website when you are ready to go live.'),
('en', 'text_amazon_surcharge', '<b>Note:</b> According to the Amazon <a href=''https://payments.amazon.com/sdui/sdui/about?nodeId=6019'' target=''_blank''>policy</a> (B4.2), surcharges are not supported. Any surcharges you may have set will be ignored when Amazon Checkout is used.'),
('en', 'text_anonymous_checkout', 'You must be a registered user to proceed to checkout'),
('en', 'recalculate_shipping_cost', 'Recalculate shipping cost'),
('en', 'text_applied_promotions', 'Applied promotions'),
('en', 'text_are_you_sure_to_delete_file', 'Are you sure you want to delete the item?'),
('en', 'text_are_you_sure_to_proceed', 'Are you sure you want to proceed?'),
('en', 'text_atos_notice', '<b>Note:</b><br />1. Copy your certificate that you received on the disk to the [home_path] directory. Rename the certificate to certif.fr.[my_merchant_id], where [my_merchant_id] is your web site number.<br /> 2. Rename the store parameters file (parmcom.014213245611111 file) to parmcom.[my_merchant_id].<br />3. Edit the <b>pathfile</b> file in the  <b>[home_path]</b> directory<br />- Replace string ''<u>D_LOGO![some_dir]!</u>'' with ''<u>D_LOGO![http_path]/logo/!</u>''<br />- Replace string ''<u>F_DEFAULT![/some_dirs/parmcom.sogenactif]!</u>'' with ''<u>F_DEFAULT![home_path]/parmcom.sogenactif!</u>''<br />- Replace string ''<u>F_PARAM![/some_dirs/parmcom]!</u>'' with ''<u>F_PARAM![home_path]/parmcom!</u>''<br />- Replace string ''<u>F_CERTIFICATE![/some_dirs/certif]!</u>'' with ''<u>F_CERTIFICATE![home_path]/certif!</u>''<br />4. Edit the <b>parmcom.[some_number]</b> file in the <b>[home_path]</b> directory<br />- Replace string ''<u>AUTO_RESPONSE_URL![some_url]!</u>'' with ''<u>AUTO_RESPONSE_URL![auto_url]!</u>''<br />- Replace string ''<u>CANCEL_URL![some_url]!</u>'' with ''<u>CANCEL_URL![ok_url]!</u>''<br />- Replace string ''<u>RETURN_URL![some_url]!</u>'' with ''<u>RETURN_URL![ok_url]!</u>''<br />'),
('en', 'text_atos_warning', '<span style="color:#FF2222">Warning!!!</span> The path to atos files should consist of not more than 60 symbols, otherwise please copy the atos_files folder to some parent directory, e.g. to the cart core directory. Also please make sure the atos files directory has full permissions.'),
('en', 'text_authentication_failed_message', 'Your financial institution has indicated that it could not successfully authenticate this transaction. To protect against unauthorized use, this card cannot be used to complete your purchase. You may complete the purchase by selecting another form of payment.'),
('en', 'text_backup_filename_hint', 'To download this backup, click the gear icon and select Download'),
('en', 'text_backup_management_notice', 'This section allows you to manage your backup files.<br />- To restore the database, select the check box near the appropriate file name and click on Restore.<br />- To delete files, select the check boxes near the files that need to be deleted and click on Delete.<br />- To download a file to your local computer, click on the file name.'),
('en', 'text_billing_same_with_shipping', 'Billing and shipping addresses are the same'),
('en', 'text_billing_address_is_different_from_shipping', 'My billing address is different from shipping address'),
('en', 'text_block_trial_notice', 'Your 30-day evaluation period has expired. Please, buy a license ([href]) or remove the software from your server.'),
('en', 'text_cannot_create_directory', 'Cannot create the directory <b>[directory]</b>. Please check the permissions.'),
('en', 'text_cannot_create_file', 'Cannot create the file <b>[file]</b>. Please check the directory permissions.'),
('en', 'text_cannot_delete_directory', 'Cannot delete the directory <b>[directory]</b>. Please check the permissions.'),
('en', 'text_cannot_delete_file', 'Cannot delete the file <b>[file]</b>. Please check the permissions.'),
('en', 'text_cannot_rename_directory', 'Cannot rename the directory <b>[directory]</b>. Please check the permissions.'),
('en', 'text_cannot_rename_file', 'Cannot rename the file <b>[file]</b>. Please check the permissions.');
INSERT INTO `[[dbprefix]]language_values` VALUES
('en', 'text_cannot_restore_directory', 'Cannot restore the directory <b>[directory]</b> from the repository. Please check if the repository exists.'),
('en', 'text_cannot_restore_file', 'Cannot restore file <b>[file]</b> from the repository. Please check if the repository exists.'),
('en', 'text_can_be_used_once', 'This coupon can be used only once. You have already applied it.'),
('en', 'text_cart_amount_changed', 'The quantity of the product <b>[product]</b> in your cart  has been changed to allowable.'),
('en', 'text_cart_amount_corrected', 'The number of products in the inventory is not enough for your order. The quantity of the product <b>[product]</b> in your cart has been reduced to <b>[count]</b>.'),
('en', 'text_cart_empty', 'Your cart is empty'),
('en', 'text_cart_max_qty', 'Maximum quantity for "[product]" is <b>[quantity]</b>'),
('en', 'text_cart_min_qty', 'Minimum quantity for "[product]" is <b>[quantity]</b>'),
('en', 'text_cart_not_enough_inventory', 'The number of products in the inventory is not enough for your order'),
('en', 'text_cart_zero_inventory', '<b>[product]</b> has zero inventory and cannot be added to the cart'),
('en', 'text_cart_zero_inventory_and_removed', '<b>[product]</b> has zero inventory and is removed from the cart'),
('en', 'text_categories_have_been_deleted', 'Categories have been deleted successfully.'),
('en', 'text_category_delimiter', 'Category path delimiter for product main category (e.g. "Computers///Desktops")'),
('en', 'text_category_detailed_image', '(optional displayed on category details page only)'),
('en', 'text_category_has_been_deleted', 'Category, subcategories and their products have been deleted successfully.'),
('en', 'text_category_icon', '(displayed on category list and details pages)'),
('en', 'text_cc_processor_connection', 'Connecting to <b>[processor]</b>...'),
('en', 'text_cdn_check', '<strong>Attention!</strong> Please test some static URL, e.g. <a href="[url]">[url]</a>, to ensure it''s working before enabling CDN (you can enable it after storage became active). It usually takes 10-15 minutes to activate storage (the "Status" field should display "Active", refresh page for updates).'),
('en', 'text_cdn_setup', 'CDN was set up successfully.'),
('en', 'text_changes_not_saved', 'Your changes have not been saved.'),
('en', 'text_changes_saved', 'Your changes have been saved.'),
('en', 'text_change_password', 'You are now logged in to your account. Please change the password and click the "Save" button.'),
('en', 'text_checkout_new_profile_notice', 'If you are a new customer, we need to know your personal details.'),
('en', 'text_cities_wildcards', 'You are able to use wildcards in this field:<br /><b>''?''</b> - any single character;<b>''*''</b> - any number of characters.<br /><br /><u>Example:</u><br /><b>New Y*</b> &nbsp;&nbsp;(corresponds to New York, New Yark, etc)<br /><b>L?s*</b>&nbsp;&nbsp; (corresponds to Las Vegas, Los Angeles, etc..)'),
('en', 'tmpl_text_ckeditor', 'CKEditor'),
('en', 'text_click_here', 'Click here for more details'),
('en', 'text_cmcic_notice', 'Please set the following URL as the <b>CGI2</b>: <b>[postback_url]</b>'),
('en', 'text_cmpi_frame_message', 'For your security, please fill out the form below to complete your order. Do not click the Refresh or Back button, or this transaction may be interrupted or canceled.'),
('en', 'text_cmpi_go_back', 'Go back'),
('en', 'text_combination_out_of_stock', 'No products with the selected options in stock'),
('en', 'text_companies_activated', 'Selected companies have been activated'),
('en', 'text_companies_disabled', 'Selected companies have been disabled'),
('en', 'text_company_status_active_subj', 'Your company was activated.'),
('en', 'text_company_status_changed', 'Status of your company [company] was changed to [status].'),
('en', 'text_company_status_disabled_subj', 'Your company was disabled.'),
('en', 'text_conditions_cleared', 'Table conditions were cleared'),
('en', 'text_confirm_passwd_recovery', 'Please follow this link to confirm your password recovery procedure'),
('en', 'password_recovery.text_confirm', 'Somebody — hopefully you — has asked us to reset the password for your account at [site]. If it weren''t you, then feel free to ignore this message.'),
('en', 'password_recovery.link_expire', 'But if you''d like to reset the password, follow the link below. It will expire in 15 minutes'),
('en', 'text_csrf_attack', 'Access denied: Possible CSRF attack'),
('en', 'text_customer_area_logo', 'Logo for the <b>customer</b> area'),
('en', 'text_datatrans_notice', '<b>Note</b>: In order to track your Datatrans orders with the shopping cart software you have to take the following steps:<br /> <br /> -&nbsp;Log in to your Datatrans account<br /> -&nbsp;Click on the <u>''Upp Data''</u> link in the <u>''Upp Administration''</u> section.<br /> -&nbsp;Set <u>''URL Post data format''</u> to <b>''Data in HTML FORM''</b>.<br /> -&nbsp;Set <u>''URL Post''</u> to:<br /> <b>[post_url]</b><br /> -&nbsp;Click on the <u>''Security''</u> link in the <u>''Upp Administration''</u> section.<br /> -&nbsp;Select the <b>''An additional merchant identification will be send with payment messages''</b> option.<br /> -&nbsp;Generate new digital signature using the <u>''Generate new sign''</u> button.<br /> -&nbsp;Set generated value to the <u>''Digital signature''</u> field on the Datatrans payment configuration page in your store<br />'),
('en', 'text_data_changed', 'Your changes have not been saved.Press OK to continue, or Cancel to stay on the current page.'),
('en', 'text_tab_changed', 'Your changes on the current tab have not been saved. Click "OK" to continue or "Cancel" to stay on the current tab.'),
('en', 'text_decrease_points_in_use', 'The points used in the order were subtracted from user account.'),
('en', 'text_deltapay_notice', '<b>Note:</b> Please send the following information to the DeltaPay support:<br />Payment page: ''<u>[payment_url]</u>''<br />Success page: ''<u>[result_url]</u>''<br />Failure page: ''<u>[result_url]</u>''<br />Cancel page: ''<u>[result_url]</u>''<br />'),
('en', 'text_directebanking_notice', 'Set ''Success link'' to: <b>[success_url]</b><br /> Set ''Abort link'' to: <b>[abort_url]</b><br /> Add new HTTP notifications and set ''Notification URL'' to: <b>[notification_url]</b><br /> Activate input check and set ''Hash Algoritm'' to the ''SHA1''<br />'),
('en', 'text_directory_created', 'The directory <b>[directory]</b> has been successfully created.'),
('en', 'text_directory_deleted', 'The directory <b>[directory]</b> has been successfully deleted'),
('en', 'text_directory_renamed', 'The directory <b>[directory]</b> has been successfully renamed to <b>[to_directory]</b>'),
('en', 'text_directory_restored', 'The directory <b>[directory]</b> has been restored from the repository'),
('en', 'text_downloads_empty', 'Your downloads list is empty'),
('en', 'text_editing', 'Text editing'),
('en', 'text_edp_product', 'This product is electronically distributed'),
('en', 'text_ekey_not_valid', 'The confirmation link is invalid or has expired.'),
('en', 'text_email_sent', 'E-mail has been sent successfully.'),
('en', 'text_emerchantpay_notice', 'Please add these URL fields in your eMerchantPay eCommerce Payment Form configuration:<br/><br/><b>BackReturn URL:</b><br/>[backreturn_url]<br/><br/><b>Custom Approval URL:</b><br/>[notify_url]<br/><br/><b>Custom Decline URL:</b><br/>[decline_url]<br/><br/><b>Activate Notification URL:</b><br/>[process_url]'),
('en', 'text_enets_notice', 'Please send the following URL to the eNPS manager as a response URL for all the three cases (success, failure, cancel): [r_url]'),
('en', 'text_enter_filename', 'Please enter a new file name'),
('en', 'text_exim_data_exported', 'Data is exported successfully'),
('en', 'text_exim_data_imported', 'Data is imported successfully.<br />New objects - <b>[new]</b>;<br />Updated objects - <b>[exist]</b>;<br />Skipped objects - <b>[skipped]</b>;<br />Total - <b>[total]</b>.'),
('en', 'text_exim_data_imported_clear', 'Data is imported successfully.'),
('en', 'text_exim_export_notice', 'Below is a list of the fields that can be exported. The <b>highlighted</b> fields are mandatory.'),
('en', 'text_exim_import_features_note', '<h4>Product features import format</h4><code>(%Group name%) %Feature name%: %Feature type%[%Feature value%]</code>where,<dl class="dl-horizontal"><dt>%Group name%</dt><dd>the name of feature group</dd><dt>%Feature name%</dt><dd>the name of feature</dd><dt>%Feature type%</dt><dd>the feature type (C - checkbox, M - multiple checkboxes, S - text select box, N - number select box, E - extended selectbox, T - simple text, O - number, D - date)</dd><dt>%Feature value%</dt><dd>the feature value (several values can be delimited by comma)</dd></dl><p>Several features must be delimited by semicolon.</p><h5>Example:</h5><code>ISBN: T[1233423423]; Release date: D[05/05/07]; Color: S[Red]</code>'),
('en', 'text_exim_import_files_note', '<h4>File import format</h4><code>%File location%</code> where, <dl class="dl-horizontal"> <dt>%File location%</dt> <dd>can be an absolute or relative path in a server file system or a URL</dd> </dl> <p>Several files must be delimited by comma.</p> <h5>Example 1:</h5><code>file1.jpg</code><h5>Example 2:</h5><code>backup/file1.zip, images/file2.jpg</code>'),
('en', 'text_exim_import_images_note', '<h4>Image import format</h4><code>%Image location%#%Alternative text%</code> where,<br><dl class="dl-horizontal"><dt>%Image location%</dt><dd>can be an absolute or relative path in a server file system or a URL,</dd><dt>%Alternative text%<dt><dd>image alternative text</dd></dl><h5>Example 1:</h5><code>images/product_images/apples.jpg#Apples</code><h5>Example 2:</h5><code>http://www.site.com/apples.jpg#Apples</code>'),
('en', 'text_exim_import_notice', 'Below is a list of the fields that your data file can contain. The fields highlighted in bold are mandatory. If you are importing data with special symbols (commas, semicolons, etc.), please make sure you have these fields quoted.'),
('en', 'text_exim_import_options_note', '<h4>Product options import format</h4><code>%Option name%: %Option type%[{$ldelim}%Variant 1 ID%{$rdelim}%Variant 1%,{$ldelim}%Variant 2 ID%{$rdelim}%Variant 2%,{$ldelim}%Variant N ID%{$rdelim}%Variant N%]</code> where,<dl class="dl-horizontal"><dt>%Option name%</dt><dd>the name of the option,</dd><dt>%Variant N ID%</dt><dd>the id of the variant,</dd><dt>%Variant N%</dt><dd>the name of the variant. Variants must be specified if the option type is a selectbox or radiogroup only.</dd><dt>%Option type%</dt><dd>the option type, can be the following:<br><ul><li><b>S</b> - selectbox,</li><li><b>R</b> - radiogroup,</li><li><b>C</b> - checkbox,</li><li><b>I</b> - simple input,</li><li><b>T</b> - textarea.</li></ul></dd></dl><p>Several options must be delimited by semicolon.</p><h5>Examples:</h5>Simple text options:<code>Your age: I; Date of birth: I; Notes: T</code><br>Options with variants:<code>Color: S[Red, Green, Blue]; Size: R[X, XL, XXL]</code>'),
('en', 'text_exim_utf8_file_format', 'Please make sure that the file you are importing has UTF-8 charset for correct import'),
('en', 'text_expired_license', 'Unfortunately, your subscription for [product] software is over. Please renew it as soon as possible to avoid the program suspending.'),
('en', 'text_features_delimiter', 'Delimiter between variant values of a product feature.'),
('en', 'text_feedback_notice', 'The parameters that will be sent to our server to analyze the functionality and the current configuration are listed below.<br />Please note that no personal or financial information will be sent. After you get acquainted with the list of the parameters, click on "Send".<br />'),
('en', 'text_files_directory', 'Directory where product files are located. This will be used if the "File" field is specified without a path.'),
('en', 'text_file_created', 'The file <b>[file]</b> has been successfully created'),
('en', 'text_file_deleted', 'The file <b>[file]</b> has been successfully deleted'),
('en', 'text_file_renamed', 'The file <b>[file]</b> has been successfully renamed to <b>[to_file]</b>'),
('en', 'text_file_restored', 'The file <b>[file]</b> has been restored from the repository'),
('en', 'text_file_saved', 'The file <b>[file]</b> is successfully saved'),
('en', 'text_fill_the_mandatory_fields', 'You need to complete all the mandatory fields'),
('en', 'text_forbidden_file_extension', 'It is not allowed to create/upload/rename files with the <b>.[ext]</b> extension.'),
('en', 'text_forbidden_file_mime', 'It is not allowed to create/upload/rename files of the <b>[mime]</b> MIME type.'),
('en', 'text_forbidden_functionality', '<p>To use this feature, you need a [product] license.</p>'),
('en', 'upgrade_license', 'Upgrade my license'),
('en', 'need_upgrade', 'Need upgrade'),
('en', 'text_forbidden_uploaded_file_extension', 'It is not allowed to upload files with the <b>.[ext]</b> extension. Allowed extensions are: <b>[exts]</b>'),
('en', 'text_forbidden_uploaded_file_size', 'It is not allowed to upload files with size more than <b>[size]</b>'),
('en', 'text_license_required_full', 'Your current CS-Cart edition is Professional. We also offer another one, a more advanced edition—<b>Ultimate</b>. With CS-Cart Ultimate, you''ll be able to use unlimited number of storefronts and the mobile commerce app as well as the eBay Synchronization add-on and the Facebook app without additional fees. To unlock unlimited storefronts and mobile commerce, get the Ultimate license.'),
('en', 'text_license_required_storefronts', 'Add as many storefronts as you want and manage them via a single admin panel.'),
('en', 'text_license_required_facebook', 'Build your store into your Facebook page to get closer to your audience and draw more new customers.'),
('en', 'text_license_required_ebay', 'Boost your sales by selling products presented in your CS-Cart store on the world''s biggest marketplace—eBay.'),
('en', 'text_form_cresecure_notice', 'Please complete your payment below.<br />This is a secure payment page, served from a secure location.'),
('en', 'text_license_required_storefronts-title', 'Unlimited Storefronts'),
('en', 'text_license_required_facebook-title', 'Facebook App'),
('en', 'text_license_required_ebay-title', 'eBay Synchronization'),
('en', 'text_full_mode_required', '<strong>Full mode</strong> required.'),
('en', 'license_required', '[product] license required'),
('en', 'text_gate2shop_notice', '<p>Please set the following values in the Gate2Shop merchant settings:</p><p>Success, failed and canceled URL: <b>[result_url]</b></p><p>Back URL: <b>[back_url]</b></p>'),
('en', 'text_gd_not_avail', 'GD library is <b>not</b> installed on your server. Please contact your hosting provider. <br />Charts can be represented only as tables (chart type "Table").'),
('en', 'text_hsbc_notice', '<b>Client ID  -</b> Your Client ID - a decimal value between 0 and 999999999, or a valid Client alias of the form UK12345678CUR. <br /> Note, the alias is case sensitive. <br /> <b>Important note for UNIX users:</b><br /> Please make sure you have appropriate permissions for the following directory: [cart_dir] (shell command "chmod -R 755").'),
('en', 'text_ideal_basic_notice', '-&nbsp;Log in to your iDEAL account<br />-&nbsp;Click on <u>''Security''</u> in the <u>''Profile''</u> section.<br />-&nbsp;Set the option <u>''Notification''</u> to <b>''XML''</b><br />-&nbsp;Set <u>''Notification URL''</u> to:<br /><b>[return_url]</b><br />-&nbsp;Set <u>''Secret key''</u>. The Secret key is known only to the seller and iDEAL.'),
('en', 'text_images_directory', 'Directory where images are located. This will be used if an image file is specified without a path.'),
('en', 'text_invalid_url', 'You have entered an invalid URL'),
('en', 'text_items_added', 'The items were added successfully'),
('en', 'text_items_updated', 'The items were updated successfully'),
('en', 'text_payment_first_data_notice', 'Please log in to FirstData Connect 2.0 Admin, open the "Administration" tab, click on the "Connect 2.0 Setup" link.<br /> Set the following URL in the "Order Submission Form", "Confirmation Page", "Failure Page" sections: [return_url]<br />'),
('en', 'text_links', 'Text links'),
('en', 'text_login_form', '<h4>Not a registered member?</h4><p>Creating a new account is easy and takes less than a minute.</p>'),
('en', 'text_login_to_add_to_cart', 'This product cannot be added to the<br>cart because you are not logged in.'),
('en', 'text_mail_area_logo', 'Logo for <b>invoices</b>'),
('en', 'text_mandatory_fields', '<p class="mandatory-fields">The fields marked with <span class="required">*</span> are mandatory</p>'),
('en', 'text_max_limit_of_parameters', 'Maximum value of the "limit" field cannot exceed 25 unless the chart type is "Table". Limit of this chart has been corrected.'),
('en', 'text_mb_failed_order', 'No response from Skrill has been received yet, please hold on. Although the order might not be created in the store as long last, it is highly probable that it has been successfully created and processed by Skrill. Please contact the store staff and tell them the order ID as provided by Skrill'),
('en', 'text_min_order_amount_required', 'To continue checkout process your order total must exceed'),
('en', 'text_min_products_amount_required', 'To continue checkout process your order subtotal must exceed'),
('en', 'text_multiprofile_notice', 'One user can have multiple profiles. For example, one for personal orders and another for office needs.'),
('en', 'text_new_user_activation', 'The profile owned by "[user_login]" has been newly created, you should check the details of this user (if required) and activate it by using the following link:<br /><a href="[url]">[url_text]</a>'),
('en', 'text_nothing_found', 'Nothing found'),
('en', 'text_not_allowed_to_upload_file_extension', 'It is not allowed to upload files with the <b>.[ext]</b> extension here.'),
('en', 'text_not_allowed_to_upload_file_size', 'It is not allowed to upload files that exceed the maximum allowed size of [file_size] MB.'),
('en', 'text_not_valid_email', '<b>[email]</b> is not a valid e-mail address.'),
('en', 'text_no_active_promotions', 'No promotions available.'),
('en', 'text_no_conflicts', 'No conflicts found'),
('en', 'text_no_items_defined', 'No [items] defined'),
('en', 'text_no_matching_products_found', 'No products found matching the search criteria'),
('en', 'text_no_matching_results_found', 'No results match the search query'),
('en', 'text_no_orders', 'No orders found'),
('en', 'text_no_payments_needed', 'No payment information required'),
('en', 'text_no_payments_required', 'No payment required'),
('en', 'text_no_products', 'There are no products in this section'),
('en', 'text_no_products_defined', 'No products defined'),
('en', 'text_no_products_found', 'No products found'),
('en', 'selected_filters', 'Selected filters'),
('en', 'text_no_shipments_found', 'No shipments found'),
('en', 'text_no_shipping_methods', 'Sorry, it seems that we have no shipping options available for your location.<br/>Please check your shipping address and contact us if everything is okay. We''ll see what we can do about it.'),
('en', 'text_no_upgrades_available', 'No upgrades currently available'),
('en', 'text_objects_for_export', '<b>[total]</b> [name] will be exported.'),
('en', 'text_ogonedirect_notice', 'Enter SHA-1 Signature both: here and on the Ogone Configuration.<br /><br />For new Ogone accounts created since May 11th, 2010, the new SHA policy is automatically active. <br/>Please do not forget to select the "Use new SHA signature policy" checkbox.'),
('en', 'text_ogoneweb_notice', 'Please set the following URL in the Technical Information section on the Ogone Configuration as a <b>Response Url</b> for all cases ("accepted", "on hold", "uncertain", "canceled by the client", "too many rejections by the acquirer"): <b>[r_url]</b><br /> Also enter SHA-1 Signature both: here and on the Ogone Configuration. Then select Request Type: "Make this request in background and deferred".'),
('en', 'text_options_no_inventory', 'In order to create option combinations, you must have the "Inventory" check box selected for at least one product option.'),
('en', 'text_order_backordered', 'Your order has been backordered. We will contact you at the first opportunity.'),
('en', 'text_order_placed_error', 'Your order has been declined by the payment processor. Please review your information and contact store administration.'),
('en', 'text_order_placed_successfully', 'Congratulations! Your order has been successfully placed.'),
('en', 'text_order_repayed_successfully', 'Order has been repaid successfully.'),
('en', 'text_order_saved_successfully', 'Order has been saved successfully.'),
('en', 'text_order_status_notification', 'Please note that the notification of changing the status  will be sent depending on the settings of this status'),
('en', 'text_out_of_stock', 'Out of stock'),
('en', 'text_pages_cloned', 'The pages have been cloned successfully. Below the list of new pages.'),
('en', 'text_pages_have_been_deleted', 'Pages have been deleted successfully.'),
('en', 'text_page_changed', 'Are you sure you want to leave this page? Your changes have not been saved. Click on OK to continue, or on Cancel to stay on the current page.'),
('en', 'text_page_has_been_deleted', 'Page has been deleted successfully.'),
('en', 'text_page_loading', 'Loading... Your request is being processed, please wait.'),
('en', 'text_password_recovery_instructions_sent', 'Password recovery instructions have been sent to [email] address.'),
('en', 'text_pay4later_notice', '<b>Note</b>: In order to track your Deko orders with the shopping cart software, you have to take these steps:<br /><br />-&nbsp;Log in to Deko BackOffice<br />-&nbsp;Click on the <u>''Settings/Installations''</u> link in the <u>''Quick Links''</u> section.<br />-&nbsp;Set <u>''Return URL (Verified)''</u> setting to:<br /><b>[verified_url]</b><br />-&nbsp;Set <u>''Return URL (Decline)''</u> setting to:<br /><b>[decline_url]</b><br />-&nbsp;Set <u>''Return URL (Refer)''</u> setting to:<br /><b>[refer_url]</b><br />-&nbsp;Set <u>''Return URL (Cancel)''</u> setting to:<br /><b>[cancel_url]</b><br />-&nbsp;Set <u>''CSN URL''</u> setting to:<br /><b>[process_url]</b><br />-&nbsp;Click on the <u>''Save Changes''</u> button<br />'),
('en', 'text_paybox_notice', '<b>Note:</b> Please download the file modulev2.cgi from the PayBox server, copy it to the <b>[paybox_dir]</b> directory <u>in binary mode</u> and make it executable. <br />Run the following command:<br /><b><i>chmod 755 modulev2.cgi</b></i><br /><br />Also ask &#8220;Paybox&#8221; service to add the following URL to the database as &#8220;Callback URL&#8221;:<br /><b>[callback_url]</b>'),
('en', 'text_payment_have_been_deleted', 'Payment have been deleted successfully.'),
('en', 'text_payment_have_not_been_deleted', 'Payment cannot be deleted.'),
('en', 'text_paypal_processing_payment', 'Please wait while processing the payment details...'),
('en', 'text_paysitecash_debug', 'Debug Information'),
('en', 'text_paysitecash_mode', 'Mode'),
('en', 'text_paysitecash_mode_debug_off', 'OFF'),
('en', 'text_paysitecash_mode_debug_on', 'ON'),
('en', 'text_paysitecash_mode_live', 'Live'),
('en', 'text_paysitecash_mode_test', 'Test'),
('en', 'text_paysitecash_nocurrencies', 'Currency mode'),
('en', 'text_paysitecash_nocurrencies_no', 'Allow customer select any of supported currency'),
('en', 'text_paysitecash_nocurrencies_yes', 'Do not show currency selection at all'),
('en', 'text_paysitecash_notice', 'Please add these URL fields in your Paysite-cash configuration:<br/><br/><b>URL:</b><br/>[url]<br/><br/><b>Referer url:</b><br/>[ref_url]<br/><br/><b>after payment return url:</b><br/>[sucess_url]<br/><br/><b>canceled payment url:</b><br/>[cancel_url]<br/><br/><b>Backoffice confirmation url:</b><br/>[confirm_url]'),
('en', 'text_paysitecash_processor', 'Processor'),
('en', 'text_paysitecash_site_id', 'Site ID'),
('en', 'text_payway_notice', 'Please set up the following parameters in PayWay back end: <p> Browser Return URL Pre Payment: <b>[prepayment]</b><br /> Browser Return URL: <b>[return]</b><br /> Notification URL: <b>[notify]</b><br /> Notification Post Type: leave empty </p>'),
('en', 'text_permissions_changed', 'Permissions changed'),
('en', 'text_piraeus_notice', '<b>Note:</b> Please send the following information to the payment support:<br /> Website URL: ''<u>[website_url]</u>''<br /> Referrer URL: ''<u>[referrer_url]</u>''<br /> Success URL: ''<u>[success_url]</u>''<br /> Failure URL: ''<u>[failure_url]</u>''<br /> Backlink URL: ''<u>[backlink_url]</u>''<br /> IP Address: ''<u>[ip_address]</u>''<br /><br /> Response Method: ''<u>[response_method]</u>''<br /><br />'),
('en', 'text_position_updating', 'Loading... Positions are being updated, please wait.'),
('en', 'text_price_dec_sign_delimiter', 'Decimal separator for product prices.'),
('en', 'text_products_added', 'The products have been added successfully. See the list of the new products below.'),
('en', 'text_products_cloned', 'The products have been cloned successfully. Below the list of new products'),
('en', 'text_products_have_been_deleted', 'Products have been deleted successfully.'),
('en', 'text_products_updated', 'The following products have been updated:'),
('en', 'text_products_updated_successfully', 'The product(s) have been updated successfully'),
('en', 'text_product_cloned', 'The product has been cloned'),
('en', 'text_product_detailed_image', '(optional displayed in popup window)'),
('en', 'text_product_file_has_been_deleted', 'Product file has been deleted'),
('en', 'text_product_filters_were_disabled', 'The following <a href="[url]" target="_blank">product filters</a> were disabled: [filters_list].'),
('en', 'text_product_has_been_deleted', 'Product has been deleted successfully.'),
('en', 'text_product_thumbnail', '(displayed on products list and product details pages)'),
('en', 'text_profile_activated', 'Your account is now active. You may log in to your account using your credentials.'),
('en', 'text_profile_benefits', '<h4>Benefits of becoming a registered member</h4><ul><li>Log in at any time to check order statuses</li><li>Personalize your shopping</li><li>Speed up future purchases</li></ul>'),
('en', 'text_profile_details', '<h4>Profile details</h4><p>On this page you can modify your login credentials and personal data to be used during future purchases.</p><p>To keep your account secure we recommend to avoid creating passwords that use:</p><ul><li>Dictionary words in any language.</li><li>Words spelled backwards, common misspellings, and abbreviations.</li><li>Sequences or repeated characters. Examples: 12345678, 222222, abcdefg, or adjacent letters on your keyboard (qwerty).</li><li>Personal information. Your name, birthday, driver''s license, passport number, or similar information.</li></ul>'),
('en', 'text_profile_is_created', 'The account has been created successfully.'),
('en', 'text_profile_is_updated', 'The profile data has been updated successfully.'),
('en', 'text_profile_should_be_approved', 'Your account has been created successfully, but it must be activated by the store administrator before you are able to sign in.'),
('en', 'text_promotions_group_condition', 'If [set] of these conditions are [set_value]'),
('en', 'our_brands', 'Our Brands'),
('en', 'text_qty_discounts', 'Our quantity discounts'),
('en', 'text_recover_password', '<p>If you have forgotten your password, enter your email address in the field and click <i>Reset password</i>.</p><p>You will receive a new password and a link to sign in. You will be able to change the password later.</p>'),
('en', 'text_recover_password_notice', 'Enter your email address to receive a new login key and a link to sign in and change your password.'),
('en', 'text_recover_password_title', 'Reset password'),
('en', 'text_remove_additional_images', 'When importing additional images of an updated product, existing images of this product will be deleted before import'),
('en', 'text_remove_backup_files', 'Warning! If you remove the backup files, you will not be able to restore your previous installation. Ensure that the new version is working properly, and the backup database files are in a safe place.'),
('en', 'text_required_group_product', 'Please select a product for the required group [group_name]'),
('en', 'text_reset_inventory_description', 'Quantity of all products in the store will be reset.'),
('en', 'text_restore_question', 'Are you sure that you want to restore the template?'),
('en', 'text_sagepay_dir_notice', '<b>Note:</b> In order to track your Opayo orders by the shopping cart software, please enable the 3D Secure Fraud Checking Option for your Opayo VSP Direct account.'),
('en', 'text_sagepay_notice', 'Use <b>testvendor</b> as <b>Vendor Name</b> for the testing purposes<br /><p><b>PAYMENT</b> - transaction type is used to gain an authorisation from the bank, then settle that transaction early the following morning, committing the funds to be taken from your customer''s card.<br /></p><p><b>DEFERRED</b> - transactions are NOT sent to the bank for completion until you RELEASE them by logging into the Opayo VSP Admin interface, finding the transaction and clicking the Release button.</p>'),
('en', 'text_secret_key_notice', 'Please complete this field with any non-empty value. It will increase the security of transactions.'),
('en', 'text_select_fields2edit_note', 'You are able to modify several items at once. Select the check boxes corresponding to the fields you wish to edit, and click on Modify Selected.'),
('en', 'text_select_file', 'Select a file or enter a URL'),
('en', 'text_select_range', 'You can select a range to export (otherwise all [name] will be exported)'),
('en', 'text_share_product_features_tooltip', 'Attention! Some data will not be copied during this operation: the categories set in filters will be lost even if you copy all categories. Please, fix categories manually.'),
('en', 'text_share_product_filters_tooltip', 'Attention! Some data will not be copied during this operation: the categories set in features will be lost even if you copy all categories. Please, fix categories manually.'),
('en', 'text_share_promotions_tooltip', 'In order to share promotions make sure the respective products are also shared (check Share products below)'),
('en', 'text_shipping_packages_info', 'To ensure a more precise shipping rate estimation, the products have been separated into packages as defined by the product settings and the shipping method configuration. The following info is for referential use only'),
('en', 'text_shipping_rates_changed', 'Shipping rates were changed'),
('en', 'text_ship_to_billing', 'Order will be delivered to the billing address'),
('en', 'text_skrill_activate_quick_checkout_short_explanation', 'Skrill Merchant Tools enables you to take payments from credit cards, debit cards and over 60 other local payment options in over 200 countries. The highly competitive rates for this service are published on the Skrill website at www.skrill.com.'),
('en', 'text_skrill_activate_quick_checkout_short_explanation_1', 'You have sent a request for activation on the [date]. Please be aware that the verification process to use Skrill Merchant Tools could take up to 72 hours. You will be contacted by Skrill when the verification process has been completed.'),
('en', 'text_skrill_activate_quick_checkout_short_explanation_2', 'After activation Skrill will grant you access to a new section in your Skrill Account called Merchant Tools. There please choose a secret word (NOT the same as your password) and enter it in the section below to connect to Skrill. The secret word is the last step of your activation process and encrypts your payments securely. After successful submission you will be ready to use all the direct payment options of Skrill.'),
('en', 'text_skrill_currs_notice', 'If you selected a currency that is not the base one in your store, please make sure that it has the correct <a href="http://en.wikipedia.org/wiki/ISO_4217">ISO 4217 code</a> on the <a href="[link]">currencies</a> page.'),
('en', 'text_skrill_email_is_not_registered', 'Specified email address is not registered in Skrill.'),
('en', 'text_skrill_email_is_registered', 'Specified email address is registered in Skrill.'),
('en', 'text_skrill_empty_input_data', 'Some of the fields required for Quick Checkout activation are missing. Please check.'),
('en', 'text_skrill_logo_notice', 'If your HTTPS server is not set up, the logo will be passed by the HTTP protocol and users will see the "Connection Partially Encrypted" warning on the Skrill page.'),
('en', 'text_skrill_notice', 'To gain access to the international payment network of Skrill, please register <a href="[register_url]" target="_blank">here</a> for a free account if you do not have one yet.<p><strong>Attention</strong>: please save settings before validating email, secret word or activating merchant tools.</p>'),
('en', 'text_skrill_notice_register', 'To gain access to the international payment network of Skrill, please register <a href="[register_url]" target="_blank">here</a> for a free account if you do not have one yet.<p><strong>Attention</strong>: please save settings before activating merchant tools.</p>'),
('en', 'text_skrill_payment_is_not_saved', 'In order to use this feature, please save the payment method first.'),
('en', 'text_skrill_secred_word_notice', 'The secret word must be in lower case without special characters and at least 10 digits long.'),
('en', 'text_skrill_secret_word_is_correct', 'Specified secret word is correct.'),
('en', 'text_skrill_secret_word_is_incorrect', 'Your secret word is incorrect. Please choose your secret word in the Merchant Tools section of your Skrill Account and then enter it here.'),
('en', 'text_skrill_support', '<b>Support:</b> <br /><br /> Do you have questions?<br /> Contact Skrill on <a href="mailto:">ecommerce@skrill.com</a> or by phone +4408703830762.<br />'),
('en', 'text_status_is_float', 'You cannot use time interval for the "Status" parameter because this parameter is time dependent.'),
('en', 'text_storage_changed', 'Storage changed successfully'),
('en', 'text_store_mode_changed_to_full', '<strong>Full mode</strong> has been activated. In this mode, all the advanced eCommerce features are available.'),
('en', 'text_store_mode_closed', 'The store was <b>closed</b>'),
('en', 'text_store_mode_full', '<p>Full unrestricted access to all features. Enter a valid license number to activate.</p><p>This mode can be activated at any time.</p><br />'),
('en', 'text_store_mode_opened', 'The store was <b>opened</b>'),
('en', 'text_store_mode_open', 'The store was <b>opened</b>'),
('en', 'text_store_mode_trial', '<p>Full access to all features during the 30-day trial period, starting from the time of activation.</p><p>Once the 30-day trial period expires, you''ll have to <a href="[product_buy_url]" target="_blank">purchase a license</a> or enter a valid license number to be able to manage your store.</p>'),
('en', 'text_store_mode_trial_rb', 'All features are available during 30 days after download of the installation package. You don''t need to enter the license key.<br /><br />After the 30-day trial period is over, you need to buy the license or enter the license key if you already have one.<br /><br />'),
('en', 'text_tax_applied', 'The tax <b>[tax]</b> has been applied to all products'),
('en', 'text_tax_unset', 'The tax <b>[tax]</b> has been removed from all products'),
('en', 'text_template_changed', 'Your changes have not been saved.Press OK to save changes or Cancel to discard them.'),
('en', 'text_thaiepay_notice', '<p>Please set the following values in the ThaiePay merchant settings:</p><p>Return Url: <b>[return_url]</b></p><p>Status: <b>Yes (it is important!)</b></p><p>Post Back Url: <b>[postback_url]</b></p><p>Main Parameter: <b>"total" must be checked</b> - it will increase the security of transactions</p><p>Additional Parameter: it is obligatory for successful processing of transactions. For example, you can set <b>name=completed</b> and <b>value=some_secret_word</b>. Copy these values to these form fields: "Additional parameter Name" and "Additional parameter Value".</p>'),
('en', 'text_thumbnail_manual_loading', 'Thumbnails will be generated from detailed images automatically, but you can also <a id="[id]" class="[class]">upload them manually.</a>'),
('en', 'text_tinymce', 'TinyMCE'),
('en', 'text_topmenu_more', 'More [item] <i class="text-arrow">&rarr;</i>'),
('en', 'text_topmenu_view_more', 'View more <i class="text-arrow">&rarr;</i>'),
('en', 'text_track_instructions_sent', 'Access instructions were sent to your e-mail address.'),
('en', 'text_track_request', 'You requested information on the orders you placed in our store.'),
('en', 'text_track_view_all_orders', 'To view all your orders, please follow this link:'),
('en', 'text_track_view_order', 'To view order #[order] please open this link:'),
('en', 'text_transaction_cancelled', 'Transaction was canceled by the customer'),
('en', 'text_transaction_declined', 'Transaction was declined by the payment processor or was canceled by the customer'),
('en', 'text_uc_another_update_process_running', 'Possibly another upgrade process is running.<br />Please wait until it is finished.<br />If the process has finished with an error, you can remove the file [filename] and try to restart the upgrade.<br /><a href="[url]">Remove the lock file and restart the upgrade</a>'),
('en', 'text_uc_backup_database', 'The following database tables have been backed up'),
('en', 'text_uc_backup_files', 'The following files have been backed up'),
('en', 'text_uc_broken_package', 'The upgrade package seems to be broken. Please refresh packages list and try to download it again'),
('en', 'text_uc_cannot_lock_upgrade_process', 'Failed to disable upgrade process launching'),
('en', 'text_uc_cant_download_package', 'Cannot download the upgrade package'),
('en', 'text_uc_changed_files_message', 'These files have local modifications and will be backed up. Once the upgrade is complete, compare the backup files with the new files and reapply the modifications to the new files, if necessary.'),
('en', 'text_uc_check_ok', 'Your [product] version has been checked successfully. It is ready for upgrade.'),
('en', 'text_uc_conflicts', 'The following files had local modifications'),
('en', 'text_uc_db_right_needed', 'Not enough permissions to update database. Please assign the following privileges to your database user [db_user]: [priviliges].'),
('en', 'text_uc_emergency_restore', 'Attention! Please copy and save the URL below - you can use it to restore your store if upgrade fails.<br /><b>[href]</b>'),
('en', 'text_uc_failed_to_backup_tables', 'The database tables have not been backed up'),
('en', 'text_uc_failed_to_create_directory', 'Failed to create a new directory'),
('en', 'text_uc_failed_to_ftp_copy', 'FTP transfer failed'),
('en', 'text_uc_ftp_cart_directory_not_found', 'We were unable to find CS-Cart installation in the specified directory. Please make sure that you have entered the correct FTP directory.'),
('en', 'text_uc_ftp_connection_failed', 'FTP connection failed'),
('en', 'text_uc_ftp_connect_failed', 'Cannot connect to FTP server. Please check if the host name is correct'),
('en', 'text_uc_ftp_login_failed', 'Cannot log in to FTP server. Please check if username and password are correct'),
('en', 'text_uc_ftp_needed', 'FTP credentials to access the files and set proper permissions automatically'),
('en', 'text_uc_has_conflicts', 'Some of your files had local modifications. You can check them by clicking the following link'),
('en', 'text_uc_incorrect_upgrade_path', 'Wrong path to upgrade files'),
('en', 'text_uc_license_number_required', 'Please enter your [product] license number'),
('en', 'text_uc_list_of_updates_missing', 'List of upgrades is missing'),
('en', 'text_uc_non_writable_files', 'These files require write permissions set (manually or automatically via FTP)'),
('en', 'text_uc_no_enough_space_to_backup_database', 'Insufficient disk space to back up the database'),
('en', 'text_uc_no_ftp_module', 'It seems that no FTP module is installed on your server. You cannot use FTP until this module is installed'),
('en', 'text_uc_unable_to_create_upgrade_folder', 'Failed to create an upgrade folder'),
('en', 'text_uc_unable_to_parse_uc_xml', 'Failed to parse the upgrade process descriptor uc.xml'),
('en', 'text_uc_unable_to_remove_file', 'Failed to remove the file'),
('en', 'text_uc_unable_to_remove_packages_xml', 'Failed to remove the upgrade descriptor packages.xml'),
('en', 'text_uc_unable_to_remove_upgrade_lock', 'Failed to remove the upgrade lock file. Please remove the [file] file.'),
('en', 'text_uc_unable_to_update_list_of_installed_upgrades', 'Failed to update the list of installed upgrades'),
('en', 'text_uc_upgrade_completed', 'Your store has been upgraded successfully'),
('en', 'text_uc_upgrade_completed_check_and_open', '<p>Your store was closed during the upgrading procedure. We recommend you to check the work of the store after the upgrade and only then open it.</p><p>You can open the store by unchecking the Close storefront setting under Settings → General.</p>'),
('en', 'text_uc_upgrade_log_file_not_writable', 'Upgrade log file is not writable'),
('en', 'text_uc_upgrade_needed', 'You need to upgrade to version <b>[to_version]</b> before applying this upgrade package (your version is <b>[your_version]</b>).'),
('en', 'text_uc_upgrade_not_selected', 'No upgrade package is selected'),
('en', 'text_uc_upgrade_reverted', 'The upgrade has been reverted successfully'),
('en', 'text_ult_product_store_field_tooltip', 'Product owner. Only product owner can edit all fields in shared products.'),
('en', 'text_unable_to_parse_xml', 'Failed to parse XML structure'),
('en', 'text_unsupported_currency', 'The currency which is not supported by the payment system is used on the website. Please contact the store administrator regarding this issue.'),
('en', 'text_upgrade_available', 'A new version of [product] is available. If you want to upgrade to the latest version now, click <a href="[link]">here</a>.'),
('en', 'text_usergroup_activated', 'The following user groups have been activated for your account: [usergroups].'),
('en', 'text_usergroup_disactivated', 'The following user groups have been removed from your account: [usergroups].'),
('en', 'text_usergroup_request', 'Customer requested user group.'),
('en', 'text_usergroup_requested_by', 'The <b>[usergroup]</b> group was requested by [name] ([email]).'),
('en', 'text_worldpay_notice', 'Configure your Worldpay account before using the payment.<br /><br />Go to the Worldpay administration page and switch to the Installation section.<br /><br />Fill the fields as follows:<br /><br />Payment Response URL: <b>[return_url]</b><br />Payment Response Password: <b>Make up a secret word.</b> The same word must be entered in the respective field below<br />MD5 secret for transactions: <b>Make up a secret word.</b> The same word must be entered in the respective field below<br />SignatureFields: <b>instId:amount:currency:cartId</b>'),
('en', 'text_zipcodes_wildcards', 'You are able to use wildcards in this field:<br /><b>''?''</b> - any single character;<b>''*''</b> - any number of characters.<br /><br /><u>Example:</u><br /><b>98?78</b> &nbsp;&nbsp;(corresponds to 98878, 98378, 98978, etc)<br /><b>12*</b>&nbsp;&nbsp; (corresponds to 12345, 12876, 12098, etc..)'),
('en', 'theme', 'Theme'),
('en', 'themes', 'Themes'),
('en', 'theme_directory', 'Theme directory'),
('en', 'theme_editor', 'Theme editor'),
('en', 'theme_editor.background', 'Background'),
('en', 'theme_editor.backgrounds', 'Backgrounds'),
('en', 'theme_editor.background_color', 'Background color'),
('en', 'theme_editor.base_color', 'Base'),
('en', 'theme_editor.body_font', 'Body'),
('en', 'theme_editor.browse', 'Browse'),
('en', 'theme_editor.buttons_font', 'Buttons'),
('en', 'theme_editor.close', 'Close theme editor'),
('en', 'theme_editor.color', 'Color'),
('en', 'theme_editor.colors', 'Colors'),
('en', 'theme_editor.background_image', 'Background image'),
('en', 'theme_editor.color_gen_algorithm', 'Colors combination'),
('en', 'theme_editor.color_gen_analogic', 'Analogic'),
('en', 'theme_editor.color_gen_base_color', 'Base color'),
('en', 'theme_editor.color_gen_contrast', 'Contrast'),
('en', 'theme_editor.color_gen_dark_pastel', 'Dark pastel'),
('en', 'theme_editor.color_gen_default', 'Default'),
('en', 'theme_editor.color_gen_light_pastel', 'Light pastel'),
('en', 'theme_editor.color_gen_monochromatic', 'Monochromatic'),
('en', 'theme_editor.color_gen_pale', 'Pale'),
('en', 'theme_editor.color_gen_pastel', 'Pastel'),
('en', 'theme_editor.color_gen_title', 'Generate colors'),
('en', 'theme_editor.color_gen_triad', 'Triad'),
('en', 'theme_editor.color_gen_variant', 'Variation'),
('en', 'theme_editor.color_gen_vcontrast', 'Contrast'),
('en', 'theme_editor.content_bg', 'Content'),
('en', 'theme_editor.css', 'Custom CSS'),
('en', 'theme_editor.customize', 'Customize'),
('en', 'theme_editor.decorative_color', 'Decorative'),
('en', 'theme_editor.discount_label', 'Discount label'),
('en', 'theme_editor.error_style_exists', 'The style with this name is already exist. Please choose another one.'),
('en', 'theme_editor.favicon', 'Favicon'),
('en', 'theme_editor.favicon_size', 'Favicon size must be 16x16 px'),
('en', 'theme_editor.fixed', 'Fixed'),
('en', 'theme_editor.font', 'Font'),
('en', 'theme_editor.fonts', 'Fonts'),
('en', 'theme_editor.font_color', 'Font'),
('en', 'theme_editor.footer', 'Footer'),
('en', 'theme_editor.footer_text', 'Footer text'),
('en', 'theme_editor.full_width', 'Full width'),
('en', 'theme_editor.general', 'General'),
('en', 'theme_editor.general_bg', 'General'),
('en', 'theme_editor.gradient', 'Gradient'),
('en', 'theme_editor.header', 'Header'),
('en', 'theme_editor.headings_font', 'Headings'),
('en', 'theme_editor.hide_show', 'Hide/show theme editor panel'),
('en', 'theme_editor.incorrect_style_name', 'Style name can not contain the following characters: "/ # % ? * : ; { } \\ + "'),
('en', 'theme_editor.in_stock', 'In stock'),
('en', 'theme_editor.links_font', 'Links'),
('en', 'theme_editor.link_color', 'Links'),
('en', 'theme_editor.logos', 'Logos'),
('en', 'theme_editor.mail', 'Mail'),
('en', 'theme_editor_logo.mail', 'E-mails'),
('en', 'theme_editor.main', 'Main content'),
('en', 'theme_editor.max_image_size', 'The image must not be bigger than 200 kB.'),
('en', 'theme_editor.menu_color', 'Menu'),
('en', 'theme_editor.menu_links_color', 'Menu links'),
('en', 'theme_editor.middle_bg', 'Middle'),
('en', 'theme_editor.no_repeat', 'No repeat'),
('en', 'theme_editor.off', 'Off'),
('en', 'theme_editor.on', 'On'),
('en', 'theme_editor.out_of_stock', 'Out of stock'),
('en', 'theme_editor.pattern', 'Pattern'),
('en', 'theme_editor.position', 'Position'),
('en', 'theme_editor.styles', 'Styles'),
('en', 'theme_editor.style', 'Style'),
('en', 'theme_editor.color_scheme', 'Color scheme'),
('en', 'theme_editor.style_data_cannot_be_saved', 'Style data cannot be saved. You should set write permissions for <b>[theme_dir]</b> directory to fix this issue.'),
('en', 'theme_editor.style_name', 'Style name'),
('en', 'theme_editor.price', 'Price'),
('en', 'theme_editor.price_font', 'Price tag'),
('en', 'theme_editor.primary_button', 'Primary button'),
('en', 'theme_editor.tertiary_button', 'Tertiary button'),
('en', 'theme_editor.repeat', 'Repeat'),
('en', 'theme_editor.repeat_x', 'Repeat x'),
('en', 'theme_editor.repeat_y', 'Repeat y'),
('en', 'theme_editor.reset_backgrounds', 'Reset backgrounds'),
('en', 'theme_editor.reset_colors', 'Reset colors'),
('en', 'theme_editor.reset_css', 'Reset CSS'),
('en', 'theme_editor.reset_fonts', 'Reset fonts'),
('en', 'theme_editor.reset_general', 'Reset general'),
('en', 'theme_editor.reset_logos', 'Reset logos'),
('en', 'theme_editor.rounded_corners', 'Rounded corners'),
('en', 'theme_editor.scroll', 'Scroll'),
('en', 'theme_editor.secondary_button', 'Secondary button'),
('en', 'theme_editor.sidebar', 'Sidebar'),
('en', 'theme_editor.text_align', 'Text alignment'),
('en', 'theme_editor.text_close_editor', 'Are you sure to exit the theme editor?'),
('en', 'theme_editor.text_close_editor_unsaved', 'You have unsaved changes. Are you sure to exit from theme editor?'),
('en', 'theme_editor.text_reset_changes', 'All changes after last save will be reset'),
('en', 'theme_editor.theme', 'Theme'),
('en', 'theme_editor_logo.theme', 'Theme'),
('en', 'theme_editor.top_panel', 'Top panel'),
('en', 'theme_editor.top_panel_links', 'Top panel links'),
('en', 'theme_editor.top_panel_text', 'Top panel text'),
('en', 'theme_editor.transparent', 'Transparent'),
('en', 'theme_editor.upload_image', 'Upload image'),
('en', 'theme_editor.enable', 'Enable Theme editor'),
('en', 'theme_editor.system_fonts', 'System fonts'),
('en', 'theme_editor.popular_fonts', 'Popular fonts'),
('en', 'theme_editor.other_fonts', 'Other fonts'),
('en', 'theme_editor_mode', 'Theme editor mode'),
('en', 'theme_editor.checkout_selected_control_border', 'Checkout: Selected payment / shipping method border'),
('en', 'theme_editor.checkout_active_selector_border', 'Checkout: Active selector border'),
('en', 'theme_editor.checkout_control_border', 'Checkout: Payment / shipping method border'),
('en', 'theme_editor.checkout_selector_border', 'Checkout: Selector border'),
('en', 'theme_editor.checkout_input_border', 'Checkout: Field border'),
('en', 'theme_editor.checkout_selected_input_border', 'Checkout: Selected field border'),
('en', 'theme_editor.checkout_step_title', 'Checkout: Step title'),
('en', 'theme_editor.checkout_input_text', 'Checkout: Text in fields'),
('en', 'theme_editor.checkout_input_label', 'Checkout: Field label'),
('en', 'theme_editor.checkout_control_background', 'Checkout: Payment / shipping method background'),
('en', 'theme_editor.checkout_selector_background', 'Checkout: Selector background'),
('en', 'theme_editor.checkout_selected_control_background', 'Checkout: Selected payment / shipping method background'),
('en', 'theme_editor.checkout_active_selector_background', 'Checkout: Active selector background'),
('en', 'theme_editor.checkout_control_title', 'Checkout: Payment / shipping method title'),
('en', 'theme_editor.checkout_selector_title', 'Checkout: Selector title');
INSERT INTO `[[dbprefix]]language_values` VALUES
('en', 'theme_editor.checkout_control_description', 'Checkout: Payment / shipping method description'),
('en', 'theme_editor.checkout_selector_tooltip', 'Checkout: Selector tooltip'),
('en', 'theme_editor.checkout_control_label', 'Checkout: Credit card field names'),
('en', 'theme_editor.checkout_terms_background', 'Checkout: "Terms and conditions" section background'),
('en', 'theme_editor.checkout_link', 'Checkout: Link'),
('en', 'admin_panel.block_manager', 'Editing layout'),
('en', 'theme_editor.create_style_first', 'You cannot modify this parameter for default styles. Create a new one first'),
('en', 'backoffice_color_scheme.dark_mode', 'Dark theme'),
('en', 'backoffice_color_scheme.light_mode', 'Light theme'),
('en', 'backoffice_color_scheme.system_mode', 'System theme'),
('en', 'the_test_transaction', 'This is a TEST transaction'),
('en', 'this_day', 'This day'),
('en', 'this_month', 'This month'),
('en', 'this_week', 'This week'),
('en', 'this_year', 'This year'),
('en', 'ths_sign', 'Ths sign'),
('en', 'thumb', 'Thumbnail'),
('en', 'thumbnail', 'Thumbnail'),
('en', 'thumbnails', 'Thumbnails'),
('en', 'thumbnails_removed', 'Thumbnails have been removed'),
('en', 'thumbnail_width', 'Thumbnail width in scroller'),
('en', 'image_file_size_set_to_server_setting', 'Image file size set to [file_size] MB. This is the largest file size allowed by the server settings.'),
('en', 'tier_account', 'tier account'),
('en', 'time', 'Time'),
('en', 'timeout', 'Timeout'),
('en', 'Timestamp', 'Timestamp'),
('en', 'time_interval', 'Time interval'),
('en', 'time_unlimited_download', 'Time-unlimited download'),
('en', 'title', 'Title'),
('en', 'tmpl_copyright', 'Copyright information'),
('en', 'tmpl_logo', 'Store logo'),
('en', 'tmpl_payment_icons', 'Payment systems icons'),
('en', 'tmpl_quick_links', 'Quick links'),
('en', 'tmpl_search', 'Search field'),
('en', 'to', 'TO'),
('en', 'today', 'Today'),
('en', 'tools', 'Tools'),
('en', 'tools_addons_current_state', 'Current state'),
('en', 'tools_addons_no_addons', 'No add-ons'),
('en', 'tools_addons_no_third_party_addons', 'No third party add-ons'),
('en', 'tooltip', 'Tooltip'),
('en', 'container_not_used', 'This container is NOT used. "[container]" container from the default location will be used instead. Set this location as default to use this container as "[container]" for all locations.'),
('en', 'top_panel', 'Top panel'),
('en', 'total', 'Total'),
('en', 'totally_paid', 'Total paid'),
('en', 'totals', 'Totals'),
('en', 'total_amount', 'Total amount'),
('en', 'total_cost', 'Total cost'),
('en', 'total_items', 'Total items'),
('en', 'total_price', 'Total price'),
('en', 'total_product_cost', 'Total product cost'),
('en', 'total_results', 'Total results'),
('en', 'to_all_subcats', 'Apply to all subcategories'),
('en', 'to_date', 'Date through'),
('en', 'to_fixed', 'to fixed amount'),
('en', 'to_percentage', 'to percentage of the original price'),
('en', 'tpe', 'TPE'),
('en', 'track', 'Track'),
('en', 'tracking_num', 'Tracking number'),
('en', 'tracking_number', 'Tracking number'),
('en', 'tracks', 'Identifier'),
('en', 'track_my_order', 'Track my order(s)'),
('en', 'track_orders', 'Track orders'),
('en', 'track_request_subj', 'Order tracking'),
('en', 'track_without_options', 'Track without options'),
('en', 'track_with_options', 'Track with options'),
('en', 'TransactionDateTime', 'TransactionDateTime'),
('en', 'transaction_approved', 'Transaction approved'),
('en', 'transaction_cancelled', 'Transaction was canceled'),
('en', 'transaction_declined', 'Transaction declined'),
('en', 'transaction_id', 'Transaction ID'),
('en', 'transaction_datetime', 'Transaction date'),
('en', 'transaction_key', 'Transaction key'),
('en', 'transaction_password', 'Transaction password'),
('en', 'transaction_type', 'Transaction type'),
('en', 'transaction_url', 'Transaction URL'),
('en', 'translate', 'Translate'),
('en', 'translations', 'Translations'),
('en', 'edit_texts', 'Edit texts'),
('en', 'tree', 'Tree'),
('en', 'trial', 'Trial'),
('en', 'trial_mode_mve_disabled', 'Trial mode is not available anymore since you have a valid license activated for this installation'),
('en', 'trial_mode_ult_disabled', 'Trial mode cannot be activated'),
('en', 'trial_notice', 'Your store is in the Trial mode.<br /><br />When the 30-day trial period expires, you''ll have to enter a valid license number to be able to manage your store.<br /><br />To dismiss this message permanently, and to access to the Administration panel after the trial period is over, purchase a license and <a class="cm-dialog-opener cm-dialog-auto-size" data-ca-target-id="store_mode_dialog">activate the Full mode</a>.'),
('en', 'trial_expired', 'Your [product] trial period has expired'),
('en', 'text_input_license_code', 'Please enter your license number to be able to manage your store:'),
('en', 'text_buy_new_license', 'If you don''t have a license number yet, you can purchase it at our official website.'),
('en', 'buy_license', 'Purchase a license'),
('en', 'true', 'True'),
('en', 'tt_views_shippings_update_delivery_time', 'The delivery time appears next to the name of the shipping method. If you use realtime shipping rate calculation, your shipping service may provide its own delivery time. The time provided by the shipping service will be displayed instead of the time you specify here.'),
('en', 'ttc_page_title', 'Page title displayed on a browser panel.'),
('en', 'ttc_popularity', 'Product popularity rating based on how many times the storefront has been viewed, number of additions to cart and number of purchases.'),
('en', 'ttc_search_words', 'Enter a few words here, and the product will appear in the results of the built-in search for those words, even if the product name or description doesn''t have them. Separate different search words by commas.'),
('en', 'ttc_storefront_url', 'All the storefronts domain names must be associated with the same IP-address. Note: Switch to "All stores" to edit'),
('en', 'ttc_stores_status', 'ON—the storefront is open; everyone will see it. OFF—the storefront is closed; only those who have the access key will be able to see it.'),
('en', 'access_for_authorized_customers_only', 'Access for authorized customers only'),
('en', 'tts_activate_menu_tab_for', 'The menu item will be shown activated for the specified dispatch.'),
('en', 'tts_generate_submenu', 'The submenu will include child elements of the selected object.'),
('en', 'tts_link_text', 'Target URL. May be an external URL, an inner store URL or a dispatch.'),
('en', 'tts_menu_user_class', 'User-defined CSS class will be added to the menu item, so this will allow to define the menu item with its own CSS style.'),
('en', 'tt_views_block_manager_update_block_override_by_this', 'If you save the block with this option checked, the current block content value will override the content of this block everywhere it is used in the cart'),
('en', 'tt_views_block_manager_update_block_width', 'Block width works for blocks located in the group having horizontal direction, for other cases this parameter does not work.'),
('en', 'tt_views_block_manager_update_location_default', 'One location must be picked as default. Its Top and Bottom containers will be used in all locations.'),
('en', 'tt_views_cart_components_carts_search_form_online_only', 'If enabled, search results include only users who are online at the moment.'),
('en', 'tt_views_currencies_update_after_sum', 'If enabled, the symbol of the currency is shown after the sum.'),
('en', 'tt_views_currencies_update_decimals', 'Number of digits after the decimal sign.'),
('en', 'tt_views_currencies_update_dec_sign', 'Decimal separator.'),
('en', 'tt_views_currencies_update_ths_sign', 'Thousand separator.'),
('en', 'tt_views_database_manage_backup_data', 'If enabled, the database backup file includes the actual table data.'),
('en', 'tt_views_database_manage_backup_schema', 'If enabled, the database backup file keeps the table structure.'),
('en', 'tt_views_exim_export_output', 'Choose an action on the file: "Direct download" - to save the file on the local computer, "Screen" - to display the file''s contents, "Server" - to save the file on the server file system.'),
('en', 'tt_views_languages_manage_language_code', 'Two-letter code of the language.'),
('en', 'tt_views_languages_update_country', 'The flag of this country will be used as language icon.'),
('en', 'tt_views_orders_components_orders_search_form_customer_files', 'If enabled, the search results will contain the orders for which customers loaded their own files.'),
('en', 'tt_views_payments_update_surcharge_title', 'Leave empty to use the ''Payment surcharge'' as a title'),
('en', 'tt_views_payments_update_template', 'Template responsible for displaying supplementary fields for the payment method.'),
('en', 'tt_views_products_components_products_shipping_settings_items_in_box', 'Use this field to define the minimum and maximum number of product items to be shipped in a separate box. Enter a non-zero value and specify the box dimensions below.'),
('en', 'tt_views_products_components_products_shipping_settings_weight', 'Non-downloadable products with zero weight are handled as having minimal possible non-zero weight'),
('en', 'tt_views_products_update_categories', 'Categories to be displayed in the navigation breadcrumbs.'),
('en', 'tt_views_products_update_images', 'The maximum size of image files is [file_size] MB.'),
('en', 'tt_views_products_update_inventory', 'Track in stock product quantity. Enable the "Enable inventory tracking" option (Settings -> General) to modify.'),
('en', 'tt_views_products_update_list_price', 'Manufacturer suggested retail price.'),
('en', 'tt_views_products_update_out_of_stock_actions', '''Buy in advance'' lets customers buy out-of-stock products and products that will be available since a specific date. ''Sign up for notification'' works only when the product has zero or negative quantity.'),
('en', 'tt_views_product_features_update_feature_display_on_catalog', 'Show this feature on product list pages along with product description.'),
('en', 'tt_views_product_features_update_feature_display_on_product', 'If enabled, the product feature is displayed on the product details page in the storefront'),
('en', 'tt_views_product_features_update_prefix', 'An affix that precedes the product feature.'),
('en', 'tt_views_product_features_update_suffix', 'An affix that follows the product feature.'),
('en', 'tt_views_product_options_update_incorrect_filling_message', 'Message that is displayed if the entered data is incorrect.'),
('en', 'tt_views_product_options_update_inner_hint', 'A note that indicates the value to be entered.'),
('en', 'tt_views_product_options_update_inventory', 'If enabled, the option is taken into account when forming the product inventory.'),
('en', 'tt_views_product_options_update_regexp', 'Regular expression specifying a pattern to match.'),
('en', 'tt_views_promotions_update_stop_other_rules', 'If enabled, the other promotions are not applied.'),
('en', 'tt_views_sales_reports_table_time_interval', 'Periods to analyze (day, week, month, year).'),
('en', 'tt_views_sales_reports_update_table_dependence', 'Parameter to sort values by. It should relate to the Value to display param (e.g. Product costs—Total cost or Number of products—Number of items).'),
('en', 'tt_views_sales_reports_update_table_limit', 'Max number of chart components.'),
('en', 'tt_views_site_layout_logos_alt_text', 'Leave empty to use company name as alternative text.'),
('en', 'tt_views_storage_cdn_cname', 'Domain name that you want to use instead of the CloudFront domain name for the URLs for your files. You also need to create a CNAME record with your DNS service to route queries to CloudFront host (it will be displayed on this page after you enter account information).'),
('en', 'tt_views_storage_cdn_key', 'AWS Access Key ID. See <a href="https://docs.aws.amazon.com/powershell/latest/userguide/pstools-appendix-sign-up.html" target="_blank">https://docs.aws.amazon.com</a> to learn how to get key and secret key.'),
('en', 'tt_views_taxes_update_regnumber', 'Registration number of this tax in the store.'),
('en', 'turkish', 'Turkish'),
('en', 'type', 'Type'),
('en', 'type_comments_here', 'You can leave us a comment here'),
('en', 'uc_ok', 'OK'),
('en', 'uk_cookies_law', 'Cookies are used on this site to provide the best user experience. If you continue, we assume that you agree to receive cookies from this site. <span class="button button-wrap-left"><span class="button button-wrap-right"><a rel="nofollow" href="[url]">OK</a></span></span>'),
('en', 'ult_share_users_setting_disabled', 'The setting value can not be changed as identical email addresses are registered in your store.'),
('en', 'unable_delete_vendor_orders_exists', 'Unable to delete this store because there are orders containing the products of this company in the store database. To delete the account, please delete all such orders first.'),
('en', 'unable_to_assign_usergroup', 'Unable to assign the usergroup. Please contact the shop administrator.'),
('en', 'unable_to_check_license', 'Unable to check your license number'),
('en', 'unable_to_delete_setting_description', 'Unable to delete setting description: [reason]'),
('en', 'unable_to_delete_setting_variant', 'Unable to delete setting_variant: [reason]'),
('en', 'unable_to_read_resource', 'Unable to read resource: [file]'),
('en', 'unable_to_update_setting_description', 'Unable to set description: [reason]'),
('en', 'unable_to_update_setting_value', 'Unable to set value: [reason]'),
('en', 'unable_to_unpack_file', 'Unable to decompress file'),
('en', 'ungroupped_features', 'Ungrouped features'),
('en', 'uninstall', 'Uninstall'),
('en', 'unique_html_block', 'Unique HTML block'),
('en', 'unit', 'Unit'),
('en', 'united_kingdom', 'United Kingdom'),
('en', 'unit_price', 'Unit price'),
('en', 'unknown', 'Unknown'),
('en', 'unknown_server_response', 'Unknown server response'),
('en', 'unmark', 'Unmark'),
('en', 'unregistered_customer', 'Unregistered customer'),
('en', 'unregistered_customer_short', 'Unregistered'),
('en', 'unselect_all', 'Unselect all'),
('en', 'unset_tax_to_products', 'Remove selected taxes from all products'),
('en', 'unsubscribe', 'Unsubscribe'),
('en', 'up', 'Up'),
('en', 'update', 'Update'),
('en', 'update_categories', 'Update categories'),
('en', 'update_customer_info', 'Update customer information'),
('en', 'update_for_all_act', 'New value will be saved for ALL stores which share this item. Click to save it only for the owner-store.'),
('en', 'update_for_all_dis', 'New value will be saved ONLY for the owner-store. Click to save it for all stores which share this item.'),
('en', 'update_for_all_hid_act', 'Click to cancel field update.'),
('en', 'update_for_all_hid_dis', 'Click to enter a new field value to update in all stores when saving item.'),
('en', 'update_group', 'Update group'),
('en', 'update_period_expired', '<p class="text-error">Your upgrade subscription has expired, so this software upgrade cannot be installed. You can prolongate your subscription in the <a href="[url]">Customer Help Desk</a>.</p><p>Please note that it is not mandatory: you can continue using this software with no limitation even without an upgrade subscription.</p>'),
('en', 'update_products', 'Update products'),
('en', 'update_profile', 'Update profile'),
('en', 'update_profile_notification', 'Your profile has been updated.'),
('en', 'update_profile_notification_header', 'Your profile has been updated'),
('en', 'update_status', 'Update status'),
('en', 'update_text', 'Update text'),
('en', 'updating', 'Updating'),
('en', 'updating_links', 'Updating links'),
('en', 'upgrade', 'Upgrade'),
('en', 'upgrade_center', 'Upgrade center'),
('en', 'upgrade_center_permission_adjusted_properly', 'All file and folder permissions have been adjusted properly.'),
('en', 'upgrade_center.validation_issue', 'Validation issue'),
('en', 'upgrade_center.validator_fail_result', 'Validator "[validator_name]" returned fail status'),
('en', 'upgrade_center.filehash_check_failed', 'Upgrade is impossible due to file integrity check error. Please contact the technical support team.'),
('en', 'upgrade_center.upgrades_are_not_available_in_trial', 'Upgrades are available only in <strong>Full</strong> and <strong>Free</strong> licensing modes.<br /><br />The licensing mode can be changed under Settings → <a class="cm-dialog-opener cm-dialog-auto-size" data-ca-target-id="store_mode_dialog">Licensing mode</a>.'),
('en', 'upgrade_center.incompatible_third_party_addons', 'Some of your add-ons weren''t tested with this version yet. Before the upgrade, ask the developers of these add-ons if they''ll work.'),
('en', 'upgrade_center.check_addons', 'See add-ons that weren''t tested →'),
('en', 'upgrade_flash_player', 'You need to upgrade your Flash Player'),
('en', 'upgrade_is_not_avail', '<p class="text-error">This upgrade is not available for your [product] license. Please contact our <a href="[href]">support team</a> to update your license status.</p>'),
('en', 'upgrade_center.warning_msg_upgrade_is_complicated', 'The upgrade is a complicated process. It can be failed due to reasons that are beyond our control.<br> To make the upgrade of your store safer, we have prepared tips for you:'),
('en', 'upgrade_center.warning_msg_specialists', 'If you are not familiar with technical aspects of CS-Cart and the upgrade process, we strongly recommend that you <a href="[upgrade_center_specialist]" target="_blank">hire a specialist</a> or <a href="[upgrade_center_team]" target="_blank">ask our support team</a> to upgrade your store for you.'),
('en', 'upgrade_center.warning_msg_third_party_add_ons', 'The upgrade doesn''t update third-party add-ons. That''s why we recommend that you disable all the third-party add-ons before the upgrade.'),
('en', 'upgrade_center.warning_msg_test_local', 'Upgrade the test copy of your store first to make sure that the upgrade will go smoothly.'),
('en', 'upgrade_center.warning_msg_after_upgrade', 'After the upgrade, check the basic functionality of your store.'),
('en', 'upgrade_center.warning_msg_generally', 'Generally, the upgrade fails because the PHP script execution is terminated due to your server configuration. It''s essential to check the PHP script timeout settings on your server'),
('en', 'upgrade_center.warning_msg_timeout_fail', 'We DO NOT recommend to start the upgrade on your server.'),
('en', 'upgrade_center.warning_msg_timeout_check_failed', 'Your server has wrong PHP script timeout settings. This could be due to restrictions on the PHP <a href="http://php.net/manual/en/function.set-time-limit.php" target="_blank">set_time_limit</a> function or FastCGI "Timeout" options. We recommend you to contact your hosting provider in order to resolve this issue or contact our tech support team to perform the upgrade for you.'),
('en', 'upgrade_center.warning_msg_executed_php', '<p class="text-error">We have started a dummy PHP script. It will be working during 6 minutes. When the check is finished, we''ll tell you if the PHP script''s timeouts can be set correctly. If yes, then you are good to go with the upgrade. Please wait until the check is finished to be sure that your server has correct PHP timeout configuration.</p>'),
('en', 'upload', 'Upload'),
('en', 'upload_install', 'Upload & install'),
('en', 'upload_another_file', 'Upload another file'),
('en', 'upload_file', 'Upload file'),
('en', 'ups', 'United Parcel Service'),
('en', 'url', 'URL'),
('en', 'user', 'User'),
('en', 'usergroup', 'User group'),
('en', 'usergroups', 'User groups'),
('en', 'usergroup_activated', 'User group has been activated'),
('en', 'usergroup_disactivated', 'User group has been deactivated'),
('en', 'usergroup_privileges', 'User group privileges'),
('en', 'usergroup_request_by_customer', 'User group request by customer'),
('en', 'username', 'Username'),
('en', 'users', 'Users'),
('en', 'users_carts', 'Abandoned / Live carts'),
('en', 'users_carts_menu', 'Live carts'),
('en', 'user_type', 'User type'),
('en', 'user_account_info', 'User account information'),
('en', 'user_account_information', 'User account information'),
('en', 'user_cannot_be_deleted', 'Sorry, user with id [user_id] can not be deleted.'),
('en', 'user_class', 'User-defined CSS class'),
('en', 'wrapper_class', 'User-defined wrapper CSS class'),
('en', 'user_data_required', 'Please select a customer or enter data'),
('en', 'user_details_page', 'User details page'),
('en', 'user_group_requests', 'User group requests'),
('en', 'user_id', 'User ID'),
('en', 'user_info', 'User information'),
('en', 'user_pin', 'User PIN'),
('en', 'user_profile_info', 'User profile information'),
('en', 'user_settings', 'User settings'),
('en', 'use_avail_period', 'Use available period'),
('en', 'use_cardinal', 'Use Cardinal Centinel&reg; for 3-D Secure Payer Authentication'),
('en', 'use_coupons_commission', 'Coupon commission'),
('en', 'use_current_link', 'Use the current page link'),
('en', 'use_custom_view', 'Use custom view'),
('en', 'use_custom_weight_settings', 'Use custom weight settings'),
('en', 'use_existing_block', 'Use Existing Block'),
('en', 'use_existing_store', 'Copy existing storefront configuration'),
('en', 'use_negotiated_rates', 'Use negotiated rates'),
('en', 'use_new_sha_method', 'Use new SHA signature policy'),
('en', 'usps', 'U.S Postal Service'),
('en', 'usps_package_size_large', 'Large'),
('en', 'usps_package_size_regular', 'Regular'),
('en', 'usps_service_certificate_of_mailing', 'Certificate of mailing'),
('en', 'usps_service_certificate_of_mailing_for_firm_mailing_books', 'Certificate of mailing for firm mailing books'),
('en', 'usps_service_certificate_of_mailing_per_individual_article', 'Certificate of mailing per individual article'),
('en', 'usps_service_certified', 'Certified'),
('en', 'usps_service_collect_on_delivery', 'Collect on delivery'),
('en', 'usps_service_delivery_confirmation', 'USPS Tracking/Delivery confirmation'),
('en', 'usps_service_edelivery_confirmation', 'e-Delivery Confirmation'),
('en', 'usps_service_express_mail_insurance', 'Express mail insurance'),
('en', 'usps_service_insurance', 'Insurance'),
('en', 'usps_service_pick_up_on_demand', 'Pick up on demand'),
('en', 'usps_service_registered_mail', 'Registered mail'),
('en', 'usps_service_registered_without_insurance', 'Registered without insurance'),
('en', 'usps_service_registered_with_insurance', 'Registered with insurance'),
('en', 'usps_service_return_receipt', 'Return receipt'),
('en', 'usps_service_return_receipt_electronic', 'Return receipt electronic'),
('en', 'usps_service_return_receipt_for_merchandise', 'Return receipt for merchandise'),
('en', 'usps_service_signature_confirmation', 'Signature confirmation'),
('en', 'usps_size', 'Please specify the package width, height and length for Priority mail, if Package Size is Large only.'),
('en', 'valid', 'Period of validity'),
('en', 'validate_email', 'Validate E-mail'),
('en', 'validate_secret_word', 'Validate secret word'),
('en', 'valid_thru', 'Valid thru (mm/yy)'),
('en', 'value', 'Value'),
('en', 'value_to_display', 'Value to display'),
('en', 'variant', 'Variant'),
('en', 'variants', 'Variants'),
('en', 'variant_name', 'Variant name'),
('en', 'vendor', 'Store'),
('en', 'vendors', 'Stores'),
('en', 'vendor_id', 'Store ID'),
('en', 'vendor_name_field', 'Vendor name'),
('en', 'vendor_name', 'Store name'),
('en', 'vendor_pages', 'Store pages'),
('en', 'version', 'Version'),
('en', 'vertical', 'Vertical'),
('en', 'very_good', 'Very Good'),
('en', 'view', 'View'),
('en', 'viewing_feature', 'Viewing feature'),
('en', 'viewing_filter', 'Viewing filter'),
('en', 'view_all', 'view all'),
('en', 'view_all_orders', 'View all orders'),
('en', 'view_all_product_features', 'View all product features'),
('en', 'view_cart', 'View cart'),
('en', 'view_categories', 'View categories'),
('en', 'view_comparison_list', 'Comparison list'),
('en', 'view_details', 'View details'),
('en', 'view_orders', 'View orders'),
('en', 'view_page', 'View page'),
('en', 'view_product', 'View product'),
('en', 'view_products', 'View products'),
('en', 'view_product_features', 'View product features'),
('en', 'view_purchased_products', 'View purchased products'),
('en', 'view_report', 'View report'),
('en', 'view_results', 'View results'),
('en', 'view_storefront', 'View storefront'),
('en', 'view_vendor_categories', 'View store categories'),
('en', 'view_vendor_orders', 'View store orders'),
('en', 'view_vendor_products', 'View store products'),
('en', 'view_vendor_users', 'View store users'),
('en', 'visa_card_discover', 'Visa, MasterCard, Discover'),
('en', 'visited_page', 'Visited page'),
('en', 'voided', 'Voided'),
('en', 'warning', 'Warning'),
('en', 'warning_default_language_disabled', 'The default language defined in your settings has been disabled or deleted. Please update the Frontend default language value on the following page: <a href="[link]">Settings :: Appearance</a>'),
('en', 'default_language_status', 'Status of the Default language cannot be changed'),
('en', 'warning_cannot_disable_all_currencies', 'All currencies cannot be hidden or disabled. Primary currency activated.'),
('en', 'warning_default_currency_disabled', 'The default currency of one of the storefronts defined in your settings has been disabled or deleted, or its code has been changed. Please update the Frontend default currency value on the following page: <a href="[link]">Settings :: Appearance</a>'),
('en', 'default_currency_status', 'Status of the Primary currency cannot be changed'),
('en', 'warning_https_is_disabled', 'The secure connection check has failed. Please ensure that SSL certificate is installed on your server. Check out the <a href="[href]" target="_blank">Documentation article</a> for more details.'),
('en', 'warning_insecure_admin_script', 'It is strongly recommended that you rename the default <b>admin.php</b> script (check the <a href="[href]" target="_blank">Documentation</a>) for security reasons.'),
('en', 'warning_insecure_password_email', 'The password must be different from the E-mail! <p><a href="[link]" class="underlined"><b>Change password &#155;&#155;</b></a></p>'),
('en', 'warning_lanvar_incorrect_name', 'Language variable name contains unsupported characters!'),
('en', 'warning_not_deleted_default_language', 'The [lang_name] language cannot be deleted because it is the default store language'),
('en', 'warning_promotions_incorrect_condition', 'The "[condition]" condition can be used in groups with "[set_value]" conditions only.'),
('en', 'warning_store_optimization_dev', 'Auto cache update enabled.<br /><br />Modified files are tracked in real time (including the files modified directly on server) and re-cached.<br /><br />Store performance may be slightly affected. Recommended to disable on production in the <a href="[link]">Themes</a>.'),
('en', 'warning_store_optimization_dev_disabled', 'Auto cache update disabled.<br /><br />Clear compiled templates manually after modifying the theme files by following <a href="[link]">this link</a> to apply the changes.'),
('en', 'warning_subscr_email_exists', '<b>[email]</b> is already in the subscribers list'),
('en', 'warning_theme_clone_dir_exists', 'Can not clone theme, because directory you entered is already exist. Please enter another one.'),
('en', 'warning_track_orders_not_allowed', 'You are not allowed to view the details of this order.'),
('en', 'warning_track_orders_not_found', 'The E-mail/Order ID you entered doesn''t exist'),
('en', 'warning_variants_removal', 'Clicking on Save will remove product feature values.'),
('en', 'website', 'Website'),
('en', 'web_pages', 'Web pages'),
('en', 'web_site', 'Website'),
('en', 'week', 'Week'),
('en', 'weekday_0', 'Sunday'),
('en', 'weekday_1', 'Monday'),
('en', 'weekday_2', 'Tuesday'),
('en', 'weekday_3', 'Wednesday'),
('en', 'weekday_4', 'Thursday'),
('en', 'weekday_5', 'Friday'),
('en', 'weekday_6', 'Saturday'),
('en', 'weekday_abr_0', 'Sun'),
('en', 'weekday_abr_1', 'Mon'),
('en', 'weekday_abr_2', 'Tue'),
('en', 'weekday_abr_3', 'Wed'),
('en', 'weekday_abr_4', 'Thu'),
('en', 'weekday_abr_5', 'Fri'),
('en', 'weekday_abr_6', 'Sat'),
('en', 'weeks', 'week(s)'),
('en', 'weight', 'Weight'),
('en', 'weight_dependences', 'Weight dependencies'),
('en', 'weight_limit', 'Weight limit'),
('en', 'weight_modifier', 'Weight modifier'),
('en', 'weight_symbol', 'Weight symbol'),
('en', 'well_done', 'Well done!'),
('en', 'what_is_cvv2', 'What is CVV/CVC'),
('en', 'widget_code', 'Widget code'),
('en', 'widget_what_is_it', '<a href="[href]" target="_blank">What is it?</a>'),
('en', 'width', 'Width'),
('en', 'without_image', 'Without image'),
('en', 'with_contact_information', 'With contact information only'),
('en', 'world', 'World'),
('en', 'worldnettps_hash_error', 'An error occurred. Error details: Request and Response hash do not match.'),
('en', 'worldpay_secret', 'MD5 secret for transactions'),
('en', 'wrapper', 'Wrapper'),
('en', 'write', 'Write'),
('en', 'year', 'Year'),
('en', 'yes', 'Yes'),
('en', 'yesterday', 'Yesterday'),
('en', 'your_message', 'Your message'),
('en', 'your_name', 'Your name'),
('en', 'your_range', 'Your range'),
('en', 'you_have_no_permissions', 'You have no permissions'),
('en', 'you_save', 'You save'),
('en', 'zero_price_action', 'Zero price action'),
('en', 'zipcodes', 'Zip/Postal codes'),
('en', 'zip_postal_code', 'Zip/postal code'),
('en', 'zone', 'Zone'),
('en', 'zpa_ask_price', 'Ask customer to enter the price'),
('en', 'zpa_permit', 'Allow customers to add the product to cart'),
('en', 'zpa_refuse', 'Do not allow customers to add the product to cart'),
('en', 'po_file', 'Choose a file in the PO or ZIP format'),
('en', 'hidden_categories', 'Hidden categories'),
('en', 'clone_categories', 'Copy categories'),
('en', 'clone_layouts', 'Copy layouts'),
('en', 'clone_pages', 'Share pages'),
('en', 'clone_payments', 'Share payment methods'),
('en', 'clone_products', 'Share products'),
('en', 'clone_product_features', 'Share product features'),
('en', 'clone_product_filters', 'Share product filters'),
('en', 'clone_profile_fields', 'Share profile fields'),
('en', 'clone_promotions', 'Share promotions'),
('en', 'clone_settings', 'Copy settings'),
('en', 'clone_shippings', 'Share shipping methods'),
('en', 'clone_sitemap', 'Copy sitemap'),
('en', 'clone_static_data_clone', 'Copy menus'),
('en', 'text_uc_failed_to_decompress_files', 'Failed to extract files from the archive'),
('en', 'development', 'Development'),
('en', 'po_file_is_incorrect', 'PO-file <b>"[file]"</b> contains syntax errors or incorrect structure.'),
('en', 'product_option_delimiter', 'Option delimiter'),
('en', 'text_product_option_delimiter', 'Delimiter for product options within an option combination (e.g. "Color: Red, Size: Small")'),
('en', 'upload_addon', 'Upload & install add-on'),
('en', 'upload_theme', 'Upload theme'),
('en', 'install_theme_text', 'Uploading and installing a new theme is a great way to personalize your storefront. You can upload a theme by picking a [exts] format archive and clicking <strong>Upload</strong>.'),
('en', 'install_upgrade_package_text', 'You can upload an upgrade package manually from the local machine, your server, or from a remote location. Specify the location of a [exts] format archive and click <strong>Upload</strong>.'),
('en', 'non_writable_directories', 'The following directories do not have writable permissions'),
('en', 'text_set_write_permissions_for_dirs', 'You can set the write permissions for the Web server to the directories listed above or provide an FTP-access with the write permissions to these directories.'),
('en', 'ftp_server_options', 'FTP server options'),
('en', 'ftp_directory', 'FTP directory'),
('en', 'recheck', 'Re-check'),
('en', 'use_this_style', 'Use this style'),
('en', 'upload_via_ftp', 'Upload via FTP'),
('en', 'invalid_ftp_access', 'Invalid FTP access'),
('en', 'install_addon_text', 'Add-ons extend the functionality of your store. <br /> You can install an add-on by picking a [exts] format archive and clicking Upload & install.'),
('en', 'xml_error', 'XML parse error'),
('en', 'column', 'Column'),
('en', 'checking_core_version_is_not_suitable', 'Version of your cart ([version]) is not supported. Minimal: [min]. Maximal: [max].'),
('en', 'checking_core_edition_is_not_suitable', 'Edition of your cart ([current_edition]) is not supported. Required: [required_edition].'),
('en', 'checking_php_version_is_not_suitable', 'PHP version ([version]) is not supported. Minimal: [min]. Maximal: [max].'),
('en', 'checking_extension_should_be_installed', 'The [extension] extension should be installed on your server for correct add-on operation.'),
('en', 'checking_extension_should_be_removed', 'The [extension] extension should be removed from your server for correct add-on operation.'),
('en', 'checking_extension_version_is_not_suitable', 'The [extension] version ([version]) is not supported by the add-on. Minimal: [min]. Maximal: [max].'),
('en', 'scroll_per_page', 'Scroll per page'),
('en', 'payments.paypal_adv_layout', 'Layout'),
('en', 'payments.layout_a', 'Layout A'),
('en', 'payments.layout_b', 'Layout B'),
('en', 'payments.layout_c', 'Layout C'),
('en', 'payments.eway_rapidapi_rsp.header_text', 'Header text'),
('en', 'filter_by_categories', 'Filter by categories'),
('en', 'default_filter_by_location', 'No filter specified. Filter by location set as default.'),
('en', 'theme_information', 'Theme information'),
('en', 'developer', 'Developer'),
('en', 'theme_styles_and_layouts', 'Theme styles and layouts'),
('en', 'activate', 'Activate'),
('en', 'export_layout', 'Export layout'),
('en', 'import_layout', 'Import layout'),
('en', 'create_new_layout', 'Create new layout'),
('en', 'update_current_layout', 'Update current layout'),
('en', 'get_social', 'Get social'),
('en', 'uc_searchanise_disabled', 'The Searchanise add-on was automatically disabled during upgrade to avoid false search results. Activate it at any time on the <a href="[url]">Add-ons</a> page.'),
('en', 'text_store_closed', 'Sorry, the store is temporarily closed for maintenance.'),
('en', 'theme_editor.presets', 'Presets'),
('en', 'theme_editor.preset_data_cannot_be_saved', 'Preset data cannot be saved. You should set write permissions for <b>[theme_dir]</b> directory to fix this issue.'),
('en', 'theme_editor.preset_name', 'Preset name'),
('en', 'active_preset', 'Active preset'),
('en', 'theme_editor.error_preset_exists', 'The preset with this name is already exist. Please choose another one.'),
('en', 'theme_editor.incorrect_preset_name', 'Preset name can not contain the following characters: "/ # % ? * : ; { } \\ "'),
('en', 'theme_editor.convert_to_css', 'Convert to CSS'),
('en', 'theme_editor.text_convert_to_css', '<p>Generate CSS files from LESS (for manual editing).</p><p>IMPORTANT: You won''t be able to use the Theme editor to customize the storefront!</p><p><i>The original LESS files will be backed up and you will be able to restore them later</i></p>'),
('en', 'theme_editor.enable_less', 'Enable LESS'),
('en', 'theme_editor.warning_css_changes_will_be_reverted', '<p>You should switch back to LESS to be able to use the Theme editor, because it deals with LESS files instead of plain CSS.</p><p><strong>Important:</strong> All CSS files will be overwritten during the restore! Custom CSS modifications will be saved in the backup directory.</p>'),
('en', 'theme_editor.confirm_enable_less', 'Your CSS modifications will be backed up and overwritten. Are you sure to continue with the LESS restore?'),
('en', 'theme_editor.error_theme_converted_to_css', 'Compiled CSS files do not support styling. Restore LESS in the <a target="_blank" href="[url]">Theme editor</a> to be able to change styles.'),
('en', 'need_product_name', 'You have to specify product name'),
('en', 'api_required_field', 'The [field] field is required'),
('en', 'update_translation', 'Update translations'),
('en', 'po_meta_error_validating_lang_code', 'Language code in the PO file does not match that of the updated language'),
('en', 'error_class_phar_data_not_found', 'The PharData class not found. Read more: <a href="https://php.net/manual/en/class.phardata.php">https://php.net/manual/en/class.phardata.php</a>'),
('en', 'error_class_zip_archive_not_found', 'The ZipArchive class not found. Read more: <a href="https://php.net/manual/en/class.ziparchive.php">https://php.net/manual/en/class.ziparchive.php</a>'),
('en', 'error_zip_php_extension_not_installed', '"Zip" PHP extension is not installed. Please install the "Zip" PHP extension to create and extract ZIP-archives.'),
('en', 'make_archive', 'Make archive'),
('en', 'marketplace', 'Marketplace'),
('en', 'cscart_marketplace', 'CS-Cart Marketplace'),
('en', 'marketplace_find_more', 'Find more add-ons and themes in <a href="[href]" target="_blank">Marketplace</a>'),
('en', 'cscart_marketplace.search', 'Search'),
('en', 'cscart_marketplace.search_description', 'Search the Add-on Market for your business needs'),
('en', 'cscart_marketplace.buy', 'Buy'),
('en', 'cscart_marketplace.price', 'Price'),
('en', 'cscart_marketplace.list_price', 'List price'),
('en', 'cscart_marketplace.price_free', 'Free'),
('en', 'more_languages', 'More languages'),
('en', 'languages_find_more', 'If you haven''t found the language you need, check out <a href="[href]" target="_blank">our site with free language packs</a>.'),
('en', 'extract_archive', 'Extract archive'),
('en', 'seo', 'SEO'),
('en', 'text_owl', 'OwlCarousel'),
('en', 'carousel_swiper', 'Swiper'),
('en', 'bulk_print_packing_slip', 'Packing slip bulk print'),
('en', 'bulk_print_pdf', 'Invoice bulk print (PDF)'),
('en', 'text_all_categories_included', 'All categories included'),
('en', 'text_all_products_included', 'All products included'),
('en', 'usergroup_registered', 'Registered user'),
('en', 'person_name', 'Name'),
('en', 'promotions.cond_any', 'any'),
('en', 'promotions.cond_all', 'all'),
('en', 'promotions.cond_true', 'true'),
('en', 'promotions.cond_false', 'false'),
('en', 'text_select_vendor', 'Please select a store first'),
('en', 'views', 'Views'),
('en', 'first_name_and_last_name', 'First name and last name'),
('en', 's_first_name_and_last_name', 'First name and last name (for shipping)'),
('en', 'b_first_name_and_last_name', 'First name and last name (for billing)'),
('en', 'last_name_and_first_name', 'Last name and first name'),
('en', 's_last_name_and_first_name', 'Last name and first name (for shipping)'),
('en', 'b_last_name_and_first_name', 'Last name and first name (for billing)'),
('en', 'fullname', 'Full name'),
('en', 's_fullname', 'Full name (for shipping)'),
('en', 'b_fullname', 'Full name (for billing)'),
('en', 'vendor_terms', 'Vendor terms and conditions'),
('en', 'vendor_terms_field_alert', 'Vendor terms and conditions alert'),
('en', 'vendor_terms_field_terms_text', 'Vendor terms and conditions text'),
('en', 'product_must_have_owner_category', 'Product must belong to some category created by the owner company.'),
('en', 'last_year', 'Last year'),
('en', 'store_closed', 'Store closed'),
('en', 'store_closed_banner', 'Store<br/>closed'),
('en', 'copy_to_other_locations', 'Copy to other locations'),
('en', 'head_custom_html', 'Custom HTML code'),
('en', 'tt_views_block_manager_update_location_head_custom_html', 'This code will be put between the &lt;head&gt;&lt;/head&gt; tags. Use it to specify meta tags or to reference external scripts or styles.'),
('en', 'category_deletion_side_effects', 'This will delete all selected category''s products, as well as its subcategories and their products.'),
('en', 'bulk_category_deletion_side_effects', 'This will delete all selected categories'' products, as well as their subcategories and their products.'),
('en', 'restore_original', 'Restore original'),
('en', 'set_custom_configuration', 'Set custom configuration'),
('en', 'use_default_block_configuration', 'Use default block configuration'),
('en', 'private_files', 'Private files'),
('en', 'public_files', 'Public files'),
('en', 'templates', 'Templates'),
('en', 'payments.realex.referring_url', 'Please supply this URL to your Realex Payments account manager'),
('en', 'payments.globalpayments.referring_url', 'Please supply this URL to your Global Payments account manager'),
('en', 'payments.realex.referring_ip', 'Please supply the IP address of your server to your Realex Payments account manager'),
('en', 'payments.globalpayments.referring_ip', 'Please supply the IP address of your server to your Global Payments account manager'),
('en', 'payments.realex.settlement', 'Settlement'),
('en', 'payments.realex.delayed_settlement', 'Delayed settlement'),
('en', 'payments.realex.auto_settled', 'Auto-settled'),
('en', 'payments.realex.text_status_map', 'Realex to CS-Cart order status conversion map'),
('en', 'payments.globalpayments.text_status_map', 'Global Payments to [product] order status conversion map'),
('en', 'payments.realex.subaccount', 'Subaccount'),
('en', 'payments.realex.liability_shift', 'Liability Shift'),
('en', 'payments.realex.liability_shift_required', 'Liability Shift required'),
('en', 'payments.realex.3d_secure_message', '3-D Secure message'),
('en', 'payments.realex.connector_error', 'Your Realex account has been suspended. Contact Realex support for further information.'),
('en', 'payments.globalpayments.connector_error', 'Your Global Payments account has been suspended. Contact Global Payments support for further information.'),
('en', 'payments.realex.incorrect_request', 'Incorrect XML message formation or content'),
('en', 'payments.realex.realex_error', 'Error with Realex systems'),
('en', 'payments.globalpayments.globalpayments_error', 'Error with Global Payments systems'),
('en', 'payments.realex.bank_error', 'Error with bank systems'),
('en', 'payments.realex.card_lost_or_stolen', 'Card reported lost or stolen'),
('en', 'payments.realex.refferal', 'Referral by bank'),
('en', 'payments.realex.avs_postcode', 'AVS Postcode'),
('en', 'payments.realex.avs_address', 'AVS Address'),
('en', 'payments.realex.tss_result', 'TSS'),
('en', 'payments.realex.eci', 'ECI'),
('en', 'payments.realex.cavv', 'CAVV'),
('en', 'payments.realex.xid', 'XID'),
('en', 'payments.realex.result_message', 'Result message'),
('en', 'payments.realex.result_code', 'Result code'),
('en', 'payments.realex.transaction_pasref', 'Transaction PASREF'),
('en', 'payments.realex.transaction_order_id', 'Transaction Order ID'),
('en', 'payments.realex.avs.matched', 'Matched'),
('en', 'payments.realex.avs.not_matched', 'Not matched'),
('en', 'payments.realex.avs.problem_with_check', 'Problem with check'),
('en', 'payments.realex.avs.unable_to_check', 'Unable to check'),
('en', 'payments.realex.avs.partial_match', 'Partial match'),
('en', 'payments.realex.wrong_card_type', 'This payment is unavailable for this type of credit cards.'),
('en', 'payments.realex.incorrect_valid_trhu', 'Incorrect values of ''Valid thru'' fields.'),
('en', 'use_for_login', 'Login form'),
('en', 'use_for_recover', 'Recover password form'),
('en', 'use_for_register', 'Create and edit profile form'),
('en', 'use_for_checkout', 'Checkout (user information) form'),
('en', 'use_for_track_orders', 'Track my order form'),
('en', 'use_for_track_product_in_stock', 'In-stock notification subscription form'),
('en', 'seo_robots', 'robots.txt'),
('en', 'robots_title', 'Editing: robots.txt'),
('en', 'edit_robots', 'Edit robots.txt'),
('en', 'restore_robots', 'Restore the default robots.txt'),
('en', 'option_exceptions', 'Option exceptions'),
('en', 'horizontal_filters', 'Horizontal filters'),
('en', 'vendor_filters_description', ''),
('en', 'uc_broken_upgrade_connector', 'Upgrade connector [connector_id] returned incorrect data'),
('en', 'uc_downloaded_and_ready', 'Upgrade package has been downloaded and ready to install'),
('en', 'uc_connector_not_found', 'Upgrade connector not found'),
('en', 'uc_unable_to_read_schema', 'Unable to read package schema (schema.json)'),
('en', 'uc_package_schema_not_found', 'Package content schema not found'),
('en', 'uc_package_schema_is_not_json', 'Package schema is not a valid JSON'),
('en', 'uc_addon_package_forbidden_path', 'Forbidden: Add-on tries to upgrade core files ([path])'),
('en', 'uc_addon_package_migrations_forbidden', 'Package contains migrations that were not described in schema or schema has links to missing migration files'),
('en', 'uc_addon_package_languages_forbidden', 'Package contains languages that were not described in schema or schema has links to missing languages files'),
('en', 'uc_addon_package_files_do_not_match_schema', 'Package contains files that were not described in schema or schema has links to missing files'),
('en', 'uc_addon_package_pre_post_scripts_mismatch', 'Package contains pre/post scripts that were not described in schema or schema has links to missing files'),
('en', 'new_version', 'New version'),
('en', 'migrations', 'Migrations'),
('en', 'permissions_issue', 'Permissions issue'),
('en', 'text_uc_local_modification', 'Local modifications'),
('en', 'text_uc_agreed_collisions', 'I understand that my local modifications will be permanently lost during the upgrade'),
('en', 'text_uc_will_be_changed', 'Will be changed'),
('en', 'text_uc_will_be_deleted', 'Will be deleted'),
('en', 'uc_title_validators', 'Upgrade package validators'),
('en', 'uc_execute_validator', 'Execute "[validator]" validator'),
('en', 'uc_copy_files', 'Copy files'),
('en', 'uc_run_migrations', 'Run migrations'),
('en', 'uc_install_languages', 'Install languages'),
('en', 'uc_upgrade_progress', 'Upgrade progress'),
('en', 'upload_upgrade_package', 'Upload upgrade package'),
('en', 'upload_upgrade_text', 'Uploading upgrade package allows you to apply HotFixes or Add-on upgrades. You can upload an upgrade pack by picking a tgz,gz,zip format archive and clicking Upload.'),
('en', 'outside_navigation', 'Outside navigation'),
('en', 'exim_error_incorrect_feature_type', 'Incorrect feature type. Some product features were not updated.'),
('en', 'exim_error_empty_feature_name', 'Feature name is missing. Some product features were not updated.'),
('en', 'unable_to_delete_last_storefront', 'At least one storefront must remain'),
('en', 'datakeeper.run_backup_via_cron_message', 'You can run the backup automatically at certain time intervals. To do it, add the following command to <a href="https://en.wikipedia.org/wiki/Cron" target="_blank">Cron</a>:'),
('en', 'datakeeper.error_unsupported_file_type', 'File cannot be restored. Only .sql, .zip and .tgz files are allowed.'),
('en', 'datakeeper.file_cannot_be_overrided', 'Cannot write to the file <b>[file]</b>. Set the writable permissions manually or check the FTP access to your server in the <a href="[url]">"Upgrade center"</a> section'),
('en', 'uc_restore_email_body', '<p>Your store''s database and files has been backed up before the upgrade. The backup archive includes the whole database and all files except for images. The backup archive has been stored on your server: [backup_file].</p><p>Before the upgrade, your store was closed. Check if it''s running fine after the upgrade and <a href="[settings_section]">open it</a>.</p><p>If something goes wrong during the upgrade, go to your admin panel, <strong>Administration → Backup/Restore</strong>, to restore the backup.</p><p>If you can''t access your admin panel, use the following link to restore the last backup. <b>Important:</b> following this link will immediately launch the restore process. Use it only if you can''t access your admin panel! Restore the last backup:</p>'),
('en', 'uc_backup_info_subj', 'Upgrade Center: Store has been backed up and closed.'),
('en', 'uc_info_subj', 'Upgrade Center: Store has been closed.'),
('en', 'error_features_too_many_variants', 'Search by features is not available due to the excessive number of variants.'),
('en', 'upgraded_on', 'Upgraded on'),
('en', 'error_unable_to_create_thumbnail', 'Unable to create thumbnail for file "[file]": [error]'),
('en', 'cookie_is_disabled', 'For a complete shopping experience, please <a href="https://www.wikihow.com/Enable-Cookies-in-Your-Internet-Web-Browser" target="_blank">set your browser to accept cookies</a>'),
('en', 'uc_restore_email_subject', 'Upgrade center: Store has been backed up and closed.'),
('en', 'warning_zero_price_restricted_product', 'Product <b>"[product]"</b> has not been added to the cart, because it doesn''t have a price.'),
('en', 'exim_vendor_cant_create_feature', 'Vendors cannot create product features and their variants. Some product features cannot be modified.'),
('en', 'uc_migration_failed', 'An error has occured during upgrading database structure (applying migration [migration]).'),
('en', 'text_entered_html_was_sanitized', 'Some <strong>HTML tags</strong> that you have used <strong>were cut off</strong> because of the restrictions on inserting HTML tags such as &lt;object&gt;, &lt;iframe&gt;, &lt;embed&gt; and JavaScript code. That''s why the content that you''ve inserted via these tags will not be displayed.'),
('en', 'text_uc_package_installed_with_errors', 'Errors occurred during the upgrade process. Please contact technical support to investigate the problem.'),
('en', 'error_unable_to_create_backups', 'Unable to create backups.'),
('en', 'seconds_left', '[n] second left|[n] seconds left'),
('en', 'text_uc_timeout_check_success', 'Looks like your server allows to change the "max_execution_time" option from the script. You are good to go with the upgrade process.'),
('en', 'check_php_timeout', 'Check PHP script timeout'),
('en', 'i_agree_continue', 'I agree and continue'),
('en', 'upgrade_center.error_unable_to_prepare_restore', 'Unable to prepare restore script.'),
('en', 'text_cc_javascript_disabled', 'Note! Your browser has the <b>JavaScript</b> disabled. To pay for your order click'),
('en', 'cc_button_submit', 'Proceed to checkout'),
('en', 'payments.rocketgate.avs_mode', 'AVS Mode'),
('en', 'payments.rocketgate.scrub_mode', 'SCRUB Mode'),
('en', 'payments.rocketgate.ignore', 'Ignore'),
('en', 'use_for_free_shipping', 'Use for free shipping'),
('en', 'tt_views_products_components_products_shipping_settings_free_shipping', 'Products with the Free shipping option enabled will be excluded from shipping calculation if shipping method has the Use for free shipping option enabled'),
('en', 'tt_views_shippings_update_use_for_free_shipping', 'Exclude products with the enabled Free shipping option from the shipping price calculation'),
('en', 'tt_views_shippings_update_is_address_required', 'If address isn''t required, CS-Cart will treat this shipping method as "Pick-up".'),
('en', 'trash_category', 'Trash category'),
('en', 'trash_category_description', 'When a product is deleted from the last category in the store, it will be moved to this category.'),
('en', 'products_without_category', 'Products without category');
INSERT INTO `[[dbprefix]]language_values` VALUES
('en', 'products_without_category_description', 'When a product is created without a category during import, it will be placed into this category.'),
('en', 'products_without_category_notification_text', 'Some of your products currently don''t have a category. It may be harder for customers to find those products.<br /> <a href="[url]" target="_blank">Please check these products and assign them a category.</a>'),
('en', 'deleting_required_category_notification_text', 'Category "[category]" is required and can''t be deleted.'),
('en', 'upgrade_notification_title', 'Upgrade changes in [product] [version]'),
('en', 'eway_configuration_note', '<a href=''https://go.eway.io/s/article/How-do-I-setup-my-Live-eWAY-API-Key-and-Password'' target=''_blank''>How do I set up my Live eWAY API Key and Password?</a>'),
('en', 'eway_failed_to_pay', 'Failed to pay for the order. Please contact the store administration about this payment method.'),
('en', 'show_more', 'Show more'),
('en', 'show_less', 'Show less'),
('en', 'products_moved_to_trash', '[count] products were moved to <a href=''[url]'' target=''_blank''>Trash category</a>'),
('en', 'products_adopted', '[n] product had a new main category assigned to it.|[n] products had a new main category assigned to them.'),
('en', 'text_uc_addon_upgrade_completed', 'Add-on "[name]" has been upgraded successfully'),
('en', 'change_addons_initialization_description', 'To determine if a certain problem is caused by an add-on, you can disable third-party add-ons or all add-ons. Re-enable them later with one click.'),
('en', 'tools_addons_disable_all', 'Disable all add-ons'),
('en', 'tools_addons_disable_third_party', 'Disable Third-party add-ons'),
('en', 'tools_re_enable_add_ons', 'Re-enable add-ons'),
('en', 'tools_addons_installed_count', 'Installed add-ons:'),
('en', 'tools_addons_activated_count', 'Active add-ons:'),
('en', 'tools_addons_core_addons_count', 'Built-in add-ons:'),
('en', 'tools_addons_other_addons_count', 'Third-party add-ons:'),
('en', 'tools_addons_disabled_msg', 'An administrator disabled all add-ons or third-party add-ons.<br> Press the Re-enable add-ons button to initialize the add-ons that were previously active.'),
('en', 'tools_addons_additional_shipping_methods_msg', 'There may be more ways to calculate shipping rates. They''ll show up if you activate the corresponding <a href="[url]">shipping add-ons</a>.'),
('en', 'tools_addons_additional_payment_methods', 'There may be more payment processors. They''ll show up if you activate the corresponding <a href="[url]">payment add-ons</a>.'),
('en', 'tools_addons_additional_themes', 'There may be more themes. They''ll show up if you activate the corresponding <a href="[url]">theme add-ons</a>.'),
('en', 'addons_source', 'Source'),
('en', 'addon_built_in', 'Built-in'),
('en', 'addon_third_party', 'Third-party'),
('en', 'requires_upgrade', 'Requires [product] upgrade'),
('en', 'new_add_on_is_not_compatible_with_your_product', 'The new add-on is not compatible with your current version of [product]. To upgrade the add-on to the latest version, please upgrade [product] to version [version].'),
('en', 'upgrade_and_update_addon', 'Upgrade [product] and upgrade the add-on'),
('en', 'addons.upgrade_to_version', 'Upgrade to [version]'),
('en', 'addons.search_description', 'Search by add-on name, description, developer, and add-on ID.'),
('en', 'addons.show_review', 'Show review'),
('en', 'addons.show_all_reviews', 'Show all reviews'),
('en', 'addons.hide_all_reviews', 'Hide all reviews'),
('en', 'addons.show_n_reviews', 'Show [n] review|Show [n] reviews'),
('en', 'addons.n_reviews', 'review|reviews'),
('en', 'addons.out_of_five', 'out of 5'),
('en', 'addons.tap_star_to_rate_on_marketplace', 'Tap a star to rate it on the CS-Cart Marketplace.'),
('en', 'addons.write_review', 'Write a review'),
('en', 'addons.no_reviews', 'No reviews'),
('en', 'addons.stars', 'stars'),
('en', 'addons.and_half_stars', 'and a half stars'),
('en', 'n_stars', '[n] star|[n] stars'),
('en', 'addons.message', 'Message'),
('en', 'addons.name', 'Add-on name'),
('en', 'addons.support', 'Support'),
('en', 'addons.website', 'Website'),
('en', 'addons.documentation', 'Documentation'),
('en', 'addons.forum', 'Forum'),
('en', 'addons.forum_en', 'Forum (EN)'),
('en', 'addons.forum_ru', 'Forum (RU)'),
('en', 'addons.get_support', 'Get support'),
('en', 'addons.no_changelog', 'No changelog'),
('en', 'addons.no_information', 'No information'),
('en', 'subcategories_tree_cat', 'Subcategories tree'),
('en', 'settings_overwrite_title', 'The theme overwrites store settings'),
('en', 'settings_overwrite_text', '<b>[theme_name]</b> will set following settings on activation'),
('en', 'overwrite', 'Overwrite'),
('en', 'upgrade_center.skip_backup', 'Skip files and database backup'),
('en', 'uc_open_store_email_body', '<p>Before the upgrade, your store was closed. Check if it''s running fine after the upgrade and <a href="[settings_section]">open it</a>.</p>'),
('en', 'upgrade_notification_message', '<p class=''upgrade-center_notice-msg''>Copy of this message was sent to administrator''s email.</p><hr>'),
('en', 'http_transport_error_prefix_curl', 'Curl Error'),
('en', 'http_transport_error_prefix_socket', 'Socket Error'),
('en', 'curl_error_code_reference_link', 'To learn what caused the Curl error, look for your error number in <a target="_blank" href="[href]">this article</a>.'),
('en', 'n_days', '[n] day|[n] days'),
('en', 'track_on_carrier_site', 'Track on website'),
('en', 'unable_to_create_status', 'Couldn''t create a new status'),
('en', 'maximum_number_of_statuses_reached', 'You have reached the maximum number of statuses'),
('en', 'curl_error_description_curle_ssl_invalidcertstatus', 'Status returned failure when asked with CURLOPT_SSL_VERIFYSTATUS.'),
('en', 'error_unknown_archive_format', 'Unknown archive format: [ext]'),
('en', 'error_file_not_found', 'File "[file]" not found.'),
('en', 'error_file_already_exists', 'File "[file]" already exists.'),
('en', 'local_modifications', 'Local modifications'),
('en', 'local_modifications_message', 'These files had local modifications. During the upgrade a backup archive was created in the <strong>[dir]</strong> directory. You may want to check these files in the archive and reapply the modifications to your store.'),
('en', 'not_checked', 'Not checked'),
('en', 'checked', 'Checked'),
('en', 'error_filter_by_feature_exists', 'Filter by feature "[name]" already exists.'),
('en', 'error_filter_by_product_field_exists', 'Filter by product field "[name]" already exists.'),
('en', 'shipping_address_changed', 'Shipping address has been changed'),
('en', 'theme_editor_not_supported', 'This theme doesn''t support theme editor'),
('en', 'shipment_statuses', 'Shipment statuses'),
('en', 'email_templates', 'Email templates'),
('en', 'editing_email_template', 'Editing email template'),
('en', 'customer_notifications', 'Customer notifications'),
('en', 'admin_notifications', 'Administrator notifications'),
('en', 'subject', 'Subject'),
('en', 'variables', 'Variables'),
('en', 'snippets', 'Snippets'),
('en', 'code_snippets', 'Code snippets'),
('en', 'editing_email_snippet', 'Editing snippet'),
('en', 'editing_snippet', 'Editing snippet'),
('en', 'snippet_exists', 'The snippet with the chosen code already exists, please try another.'),
('en', 'document_exists', 'The document with the chosen code already exists, please try another.'),
('en', 'email_template_exists', 'The email template with the chosen code already exists, please try another.'),
('en', 'need_snippet_name', 'You have to specify valid snippet name'),
('en', 'snippets_have_been_deleted', 'Snippets have been deleted successfully.'),
('en', 'add_email_snippet', 'Add snippet'),
('en', 'add_snippet', 'Add snippet'),
('en', 'editing_document', 'Editing [name]'),
('en', 'product_info', 'Product info'),
('en', 'add_table_column', 'Add column'),
('en', 'editing_table_column', 'Editing column'),
('en', 'table_column_has_been_deleted', 'Product column has been deleted successfully.'),
('en', 'restore_default_value', 'Restore default value'),
('en', 'send_test_email', 'Send test email'),
('en', 'text_test_email_sent', 'Test email was sent to <b>[email]</b> address.'),
('en', 'editing_global_vars', 'Editing global variables'),
('en', 'global_vars', 'Global variables'),
('en', 'change_order_status_p_subj', 'Order #[order] has been processed'),
('en', 'change_order_status_p_text', 'Your order has been processed successfully.'),
('en', 'change_order_status_c_subj', 'Order #[order] has been completed'),
('en', 'change_order_status_c_text', 'Your order has been completed. Thank you for choosing us.'),
('en', 'change_order_status_o_subj', 'Order #[order] has been placed successfully'),
('en', 'change_order_status_o_text', 'Thank you for the order. You are welcome to come back!'),
('en', 'change_order_status_f_subj', 'Order #[order] failed'),
('en', 'change_order_status_f_text', 'Your order has been unsuccessful. Please contact shop administration.'),
('en', 'change_order_status_d_subj', 'Order #[order] has been declined'),
('en', 'change_order_status_d_text', 'Your order has been declined. Please contact shop administration.'),
('en', 'change_order_status_b_subj', 'Order #[order] has been backordered'),
('en', 'change_order_status_b_text', 'Your order has been backordered.'),
('en', 'change_order_status_i_subj', 'Order #[order] has been canceled'),
('en', 'change_order_status_i_text', 'Your order has been canceled. Please contact shop administration.'),
('en', 'change_order_status_default_subj', 'The status of order #[order] has been changed to [status]'),
('en', 'change_order_status_default_text', 'The status of your order has been changed to [status].'),
('en', 'email_template.activate_profile', 'User profile requires activation'),
('en', 'email_template.back_in_stock_notification', 'Back in stock notification'),
('en', 'email_template.create_profile', 'User profile creation'),
('en', 'email_template.edp_access', 'Orders: access to downloadable products'),
('en', 'email_template.give_coupon', 'Promotions: coupon'),
('en', 'email_template.low_stock', 'Product low stock notification'),
('en', 'email_template.order_notification', 'Order notification: [name]'),
('en', 'email_template.order_notification_default', 'Order notification: Default template for a new order status'),
('en', 'email_template.profile_activated', 'User account activation'),
('en', 'email_template.recover_password', 'Password recovery'),
('en', 'email_template.reminder', 'Admin password expiration'),
('en', 'email_template.shipment_products', 'Orders: products shipped'),
('en', 'email_template.track', 'Orders: tracking'),
('en', 'email_template.update_profile', 'User profile update'),
('en', 'email_template.usergroup_activation', 'User group activation'),
('en', 'email_template.usergroup_disactivation', 'User group disactivation'),
('en', 'email_template.usergroup_request', 'User group request'),
('en', 'email_template.upgrade_backup_info', 'Upgrade: restore link'),
('en', 'email_template.params.attach_order_document', 'Attach a PDF document'),
('en', 'edit_customer_notification', 'Edit the email sent to customers'),
('en', 'edit_admin_notification', 'Edit the email sent to administrators'),
('en', 'copy', 'Copy'),
('en', 'copied', 'Copied'),
('en', 'addon_uninstall_sql_error', 'An error in an SQL query occurred during the add-on uninstallation.'),
('en', 'payments.qbms.quickbooks_connection', 'QuickBooks Connection'),
('en', 'payments.qbms.configuration_required', '<p>Fill in the fields below and save the changes:<br>- App Token<br>- OAuth Consumer Key<br> - OAuth Consumer Secret</p><p>Click "Connect to QuickBooks" button that will appear instead of this message to finish payment configuration.</p>'),
('en', 'payments.qbms.app_token', 'App Token'),
('en', 'payments.qbms.oauth_consumer_key', 'OAuth Consumer Key'),
('en', 'payments.qbms.oauth_consumer_secret', 'OAuth Consumer Secret'),
('en', 'payments.qbms.oauth_client_id', 'OAuth Client Id'),
('en', 'payments.qbms.oauth_client_secret', 'OAuth Client Secret'),
('en', 'payments.qbms.token_expires', 'The token expires on <b>[date]</b> at <b>[time]</b>.'),
('en', 'payments.qbms.token_expired', 'The token has expired.'),
('en', 'payments.qbms.renew_token', 'Press "Connect to QuickBooks" to renew the token.'),
('en', 'payments.qbms.tip_fill_redirect', '<p>- In the QuickBooks application, copy the following value into the Redirect URI field:</p><p>[url]</p><p>- Click the "Connect to QuickBooks" button.</p>'),
('en', 'payments.qbms.configure_payment_method', '<p>How to configure the payment method:</p><p>1. <a target="_blank" href="https://developer.intuit.com/app/developer/qbo/docs/develop/authentication-and-authorization/oauth-2.0#obtain-oauth2-credentials-for-your-app">Obtain OAuth 2.0</a> credentials from <b>QuickBooks Online</b> application (QuickBooks Desktop won''t work).</p><p>2. Copy them to the payment method settings in [product].</p><p>3. Click "Create", then open the settings of this payment method again to finish its configuration.</p>'),
('en', 'text_money_back_guarantee', 'We offer 30-day money-back guarantee. If you don''t like our product, we''ll return you the money, no needless questions asked.'),
('en', 'admin_panel_will_be_blocked', 'Installation integrity check failed. The access to the Administration panel will be blocked within 2 days. Please contact our <a href="[href]">support team</a>'),
('en', 'text_license_is_disabled', 'The license is disabled. Please check your license status.'),
('en', 'text_license_is_invalid', 'Invalid license number. Please enter a valid license number.'),
('en', 'text_license_is_disabled_full', 'The license is disabled. Please check your license status or select a different store mode.'),
('en', 'text_license_is_invalid_full', 'Invalid license number. Please enter a valid license number or select a different store mode.'),
('en', 'shipping_tips', ''),
('en', 'error_directory_not_writable', 'Directory "[dir]" is not writable. Please check permissions for this directory of your installation.'),
('en', 'error_cannot_delete_files', 'Cannot delete files: <b>[files]</b>. Please check the permissions.'),
('en', 'feature_groups', 'Feature groups'),
('en', 'shippings.can.business_account_information', 'Business account information'),
('en', 'shippings.can.customer_number', 'Customer number'),
('en', 'ttc_shippings.can.customer_number', 'Customer number is required for commercial customers and Solutions for Small Business members to get discounted rates if parcel is mailed on behalf of customer'),
('en', 'shippings.can.contract_id', 'Contract ID'),
('en', 'ttc_shippings.can.contract_id', 'Contract ID is required to obtain discounted rates for commercial customers when the Customer number is specified. Contract ID must be omitted for Solutions for Small Business members or general business users'),
('en', 'shippings.can.api_keys', 'API keys'),
('en', 'shippings.can.username', 'Username'),
('en', 'shippings.can.password', 'Password'),
('en', 'shippings.can.options', 'Delivery options'),
('en', 'shippings.can.option_so', 'Signature'),
('en', 'shippings.can.option_cov', 'Coverage'),
('en', 'ttc_shippings.can.option_cov', 'Requires amount'),
('en', 'shippings.can.option_cov_amount', 'Coverage amount'),
('en', 'shippings.can.option_cod', 'Collect on Delivery'),
('en', 'shippings.can.option_pa18', 'Proof of Age Required - 18'),
('en', 'shippings.can.option_pa19', 'Proof of Age Required - 19'),
('en', 'shippings.can.option_hfp', 'Card for pickup'),
('en', 'shippings.can.option_dns', 'Do not safe drop'),
('en', 'shippings.can.option_lad', 'Leave at door - do not card'),
('en', 'shippings.aup.pac_api_key', 'PAC API key'),
('en', 'shippings.aup.currency_not_configured', 'To activate the Australia Post shipping processor, you must have the Australian Dollar currency enabled.'),
('en', 'licensing_and_upgrades', 'Licensing and upgrades'),
('en', 'addon_license_key_tooltip', 'Enter license key you''ve received by e-mail in order to receive the add-on upgrades.'),
('en', 'api_shipments_update_not_allowed', 'Only tracking_number, status, comments and timestamp can be updated'),
('en', 'api_shipments_status_not_correct', 'Value of status field is not correct. Allowed values: ''A'', ''P'', ''S'''),
('en', 'cannot_remove_theme_has_dependent_themes', 'The theme can''t be removed as the following themes depend on it: [dependent_themes]'),
('en', 'text_installing_theme_dependencies', 'Installing the theme dependencies: [dependencies]'),
('en', 'text_unable_to_install_theme_dependencies', 'Unable to install the theme dependencies: [dependencies]'),
('en', 'exim_cannot_create_variant_for_shareable_feature', 'You cannot create a variant for a shareable feature.'),
('en', 'warning_default_language_sharing_removed', 'The default language defined in settings has been removed for the <b>[company]</b> storefront. Please update the Frontend default language value on the following page: <a href="[link]">Settings :: Appearance</a>'),
('en', 'warning_default_currency_absent', 'Could not assign default currency for the <b>[storefront]</b> storefront. Please update the default currency value on the following page: <a href="[link]">Administration :: Currencies</a>'),
('en', 'page_url', 'Page URL'),
('en', 'tt_views_pages_components_pages_link_page_url', 'The page inner URL'),
('en', 'page_target_url', 'Target URL'),
('en', 'tt_views_pages_components_pages_link_page_target_url', 'The URL to redirect customers to'),
('en', 'shippings.fedex.freight_account_number', 'Freight account number'),
('en', 'ship_fedex_package_type_fedex_extra_large_box', 'FedEx Extra Large Box'),
('en', 'ship_fedex_package_type_fedex_large_box', 'FedEx Large Box'),
('en', 'ship_fedex_package_type_fedex_medium_box', 'FedEx Medium Box'),
('en', 'ship_fedex_package_type_fedex_small_box', 'FedEx Small Box'),
('en', 'ship_fedex_drop_off_type_business_service_center', 'Business service center'),
('en', 'ship_fedex_drop_off_type_drop_box', 'Drop box'),
('en', 'shippings.fedex.options', 'Delivery options'),
('en', 'shippings.fedex.option_broker_select_option', 'Broker select option'),
('en', 'shippings.fedex.option_call_before_delivery', 'Call before delivery'),
('en', 'shippings.fedex.option_cod', 'COD'),
('en', 'shippings.fedex.option_cod_amount', 'COD amount'),
('en', 'shippings.fedex.option_cod_collection_type', 'COD collection type'),
('en', 'shippings.fedex.option_cod_collection_type_any', 'Any'),
('en', 'shippings.fedex.option_cod_collection_type_cash', 'Cash'),
('en', 'shippings.fedex.option_cod_collection_type_guaranteed_funds', 'Guaranteed funds'),
('en', 'shippings.fedex.option_custom_delivery_window', 'Custom delivery window'),
('en', 'shippings.fedex.option_dangerous_goods', 'Dangerous goods'),
('en', 'shippings.fedex.option_dangerous_goods_options', 'Hazardous content options'),
('en', 'shippings.fedex.option_dangerous_goods_options_battery', 'Battery'),
('en', 'shippings.fedex.option_dangerous_goods_options_hazardous_materials', 'Hazardous materials'),
('en', 'shippings.fedex.option_dangerous_goods_options_orm_d', 'ORM-D'),
('en', 'shippings.fedex.option_dangerous_goods_options_limited_quantities_commodities', 'Limited quantities commodities'),
('en', 'shippings.fedex.option_dangerous_goods_options_reportable_quantities', 'Reportable quantities'),
('en', 'shippings.fedex.option_dangerous_goods_options_small_quantity_exception', 'Small quantity exception'),
('en', 'shippings.fedex.option_dangerous_goods_accessibility', 'Dangerous goods accessibility'),
('en', 'shippings.fedex.option_dangerous_goods_accessibility_accessible', 'Accessible'),
('en', 'shippings.fedex.option_dangerous_goods_accessibility_inaccessible', 'Inaccessible'),
('en', 'shippings.fedex.option_do_not_break_down_pallets', 'Do not break down pallets'),
('en', 'shippings.fedex.option_do_not_stack_pallets', 'Do not stack pallets'),
('en', 'shippings.fedex.option_dry_ice', 'Dry ice'),
('en', 'shippings.fedex.option_east_coast_special', 'East Coast special'),
('en', 'shippings.fedex.option_electronic_trade_documents', 'Electronic trade documents'),
('en', 'shippings.fedex.option_extreme_length', 'Extreme length'),
('en', 'shippings.fedex.option_food', 'Food'),
('en', 'shippings.fedex.option_fedex_one_rate', 'FedEx One Rate'),
('en', 'shippings.fedex.option_freight_guarantee', 'Freight guarantee'),
('en', 'shippings.fedex.option_freight_to_collect', 'Freight to collect'),
('en', 'shippings.fedex.option_future_day_shipment', 'Future day shipment'),
('en', 'shippings.fedex.option_hold_at_location', 'Hold at location'),
('en', 'shippings.fedex.option_home_delivery_premium', 'Home delivery Premium'),
('en', 'shippings.fedex.option_inside_delivery', 'Inside delivery'),
('en', 'shippings.fedex.option_inside_pickup', 'Inside pickup'),
('en', 'shippings.fedex.option_international_controlled_export_service', 'International controlled export service'),
('en', 'shippings.fedex.option_international_traffic_in_arms_regulations', 'International traffic in arms regulations'),
('en', 'shippings.fedex.option_liftgate_delivery', 'Liftgate delivery'),
('en', 'shippings.fedex.option_liftgate_pickup', 'Liftgate pickup'),
('en', 'shippings.fedex.option_limited_access_delivery', 'Limited access delivery'),
('en', 'shippings.fedex.option_limited_access_pickup', 'Limited access pickup'),
('en', 'shippings.fedex.option_pharmacy_delivery', 'Pharmacy delivery'),
('en', 'shippings.fedex.option_poison', 'Poison'),
('en', 'shippings.fedex.option_protection_from_freezing', 'Protection from freezing'),
('en', 'shippings.fedex.option_returns_clearance', 'Returns clearance'),
('en', 'shippings.fedex.option_saturday_delivery', 'Saturday delivery'),
('en', 'shippings.fedex.option_saturday_pickup', 'Saturday pickup'),
('en', 'shippings.fedex.option_top_load', 'Top load'),
('en', 'template_document_order_invoice', 'Invoice'),
('en', 'template_document_order_summary', 'Order summary'),
('en', 'template_document_packing_slip_default', 'Packing slip'),
('en', 'documents', 'Documents'),
('en', 'document_preview_order_not_found', 'Couldn''t find an order. Preview only works with existing data. Please create an order and use Preview again.'),
('en', 'editing_order_invoice', 'Editing invoice for order #[order_id]'),
('en', 'email_order_invoice_subject', '[company_name]: Invoice for order #[order_id]'),
('en', 'edit_and_send_invoice', 'Tweak and send invoice'),
('en', 'error_profile_field_name_exists', 'A profile field with this name already exists. Please choose another name.'),
('en', 'profile_field_name', 'Field name'),
('en', 'profile_field_name_tooltip', 'A character sequence that serves as an identifier. You can use figures from 0 to 9, symbols of the English alphabet and "_" sign.'),
('en', 'text_character_identifier_tooltip', 'A character sequence that serves as an identifier. You can use figures from 0 to 9, symbols of the English alphabet and the following signs: "-", "_", ".".'),
('en', 'core_files_have_been_modified', 'Some of your <a href="[changes_url]">core files</a>  were changed manually. That can lead to various problems, especially when upgrading to a new version of [product]. To learn more about why we advise against changing the core files, please read this <a href="[docs_url]" target="_blank" >article</a>.<br><br>[product] automatically checks for changes in core files every time you log in. To disable this check, go to <a href="[settings_url]">Settings → General</a>  and untick the Monitor changes in core files checkbox.'),
('en', 'scan_for_modified_core_files', 'Scan for changed core files'),
('en', 'last_scan_time', 'Last scan time'),
('en', 'no_modified_core_files_found', 'No changed core files found'),
('en', 'modified_core_files_found', 'Some of your core files have been changed. This may become a problem when upgrading [product] as changes in these files may be lost.'),
('en', 'file_changes_detector', 'File changes detector'),
('en', 'privileges.view_file_changes', 'Can view'),
('en', 'error_shipment_not_created', 'Couldn''t create a shipment. Please choose a carrier or enter a tracking number.'),
('en', 'my_cart', 'My cart'),
('en', 'exclusive_promotions', 'Exclusive discounts'),
('en', 'exclusive_promotions_content', 'Subscribe to our news and get a 10% discount coupon!'),
('en', 'tmpl_subscription_advanced', 'Subscription advanced form'),
('en', 'tmpl_newsletters_subscription_advanced', 'Newsletters: subscription advanced form'),
('en', 'tmpl_payment_icons_rus', 'Payment systems russian icons'),
('en', 'my_account_links_advanced', 'My account advanced'),
('en', 'api_access_has_been_enabled', 'You are free to use the API now'),
('en', 'api_access_has_been_disabled', 'From now on, you cannot use the API'),
('en', 'report_a_bug', 'Report a bug'),
('en', 'import_results', 'Import results'),
('en', 'import_errors', 'Import errors'),
('en', 'email_template_import_success_msg', 'All the email templates have been imported without errors.'),
('en', 'document_import_success_msg', 'All the documents have been imported without errors.'),
('en', 'count_document_successfully_imported', 'Documents successfully imported:'),
('en', 'count_email_template_successfully_imported', 'Email templates successfully imported:'),
('en', 'count_snippet_successfully_imported', 'Snippets successfully imported:'),
('en', 'count_document_fail_imported', 'Documents import failed:'),
('en', 'count_email_template_fail_imported', 'Email templates import failed:'),
('en', 'count_snippet_fail_imported', 'Snippets import failed:'),
('en', 'storefronts_limit_exceeded', 'The number of storefronts in your CS-Cart License has exceeded the number of purchased storefront licenses.'),
('en', 'licensed_product', 'Licensed product'),
('en', 'store_mode.free', 'Free'),
('en', 'store_mode.ultimate', 'Ultimate'),
('en', 'store_mode.enterprise', 'Enterprise'),
('en', 'product_state_description.ult.new', '<p>You can use one of these licenses: <a href="[standard_license_url]" target="_blank">[product]</a> or <a href="[ultimate_license_url]" target="_blank">[product] Ultimate</a>. Both licenses allow you to use [product] without time restrictions.</p><br>'),
('en', 'product_state_description.ult', '<p>You can use the software without time restrictions now. Please note that some advanced features are available only in <a href="[ultimate_license_url]" target="_blank">[product] Ultimate.</a></p><br>'),
('en', 'product_state_description.ult.ultimate', '<p>You can use the software without time restrictions now.</p><br>'),
('en', 'product_state_description.ult.enterprise', '<p>You can use the software without time restrictions now.</p><br>'),
('en', 'product_state_description.ult.ru.new', '<p>You can use one of these licenses: <a href="[standard_license_url]" target="_blank">[product]</a> or <a href="[ultimate_license_url]" target="_blank">[product] Ultimate</a>. Both licenses allow you to use [product] without time restrictions.</p><br>'),
('en', 'product_state_description.ult.ru', '<p>You can use the software without time restrictions now. Please note that some advanced features are available only in <a href="[ultimate_license_url]" target="_blank">[product] Ultimate.</a></p><br>'),
('en', 'product_state_description.ult.ru.ultimate', '<p>You can use the software without time restrictions now.</p><br>'),
('en', 'product_state_description.ult.ru.enterprise', '<p>You can use the software without time restrictions now.</p><br>'),
('en', 'product_state_description.ult.b2b.new', '<p>You can use one of these licenses: <a href="[standard_license_url]" target="_blank">[product]</a> or <a href="[ultimate_license_url]" target="_blank">[product] Ultimate</a>. Both licenses allow you to use [product] without time restrictions.</p><br>'),
('en', 'product_state_description.ult.b2b', '<p>You can use the software without time restrictions now. Please note that some advanced features are available only in <a href="[ultimate_license_url]" target="_blank">[product] Ultimate.</a></p><br>'),
('en', 'product_state_description.ult.b2b.ultimate', '<p>You can use the software without time restrictions now.</p><br>'),
('en', 'product_state_description.ult.b2b.enterprise', '<p>You can use the software without time restrictions now.</p><br>'),
('en', 'text_store_mode_changed_to_ult.free', 'Your store now uses an active license of [product].'),
('en', 'text_store_mode_changed_to_ult.free_ru', 'Your store now uses an active license of [product].'),
('en', 'text_store_mode_changed_to_ult', 'Your store now uses an active license of [product].'),
('en', 'text_store_mode_changed_to_ult.ultimate', 'Your store now uses an active license of [product].'),
('en', 'text_store_mode_changed_to_ult.enterprise', 'Your store now uses an active license of [product].'),
('en', 'text_store_mode_changed_to_ult.ru', 'Your store now uses an active license of [product].'),
('en', 'text_store_mode_changed_to_ult.ru.ultimate', 'Your store now uses an active license of [product].'),
('en', 'text_store_mode_changed_to_ult.ru.enterprise', 'Your store now uses an active license of [product].'),
('en', 'text_store_mode_changed_to_ult.b2b', 'Your store now uses an active license of [product].'),
('en', 'text_store_mode_changed_to_ult.b2b.ultimate', 'Your store now uses an active license of [product].'),
('en', 'text_store_mode_changed_to_ult.b2b.enterprise', 'Your store now uses an active license of [product].'),
('en', 'ultimate_license', '[product] Ultimate'),
('en', 'ultimate_license_required', '[product] Ultimate is required for this'),
('en', 'ultimate_or_storefront_license_required', 'This action requires [product] Ultimate'),
('en', 'ultimate_or_storefront_license_required.ult.new', 'This action requires [product] Ultimate'),
('en', 'ultimate_or_storefront_license_required.ult', 'This action requires [product] Ultimate'),
('en', 'ultimate_or_storefront_license_required.ult.ultimate', 'This action requires [product] Ultimate'),
('en', 'ultimate_or_storefront_license_required.ult.b2b.new', 'This action requires [product] Ultimate'),
('en', 'ultimate_or_storefront_license_required.ult.b2b', 'This action requires [product] Ultimate'),
('en', 'ultimate_or_storefront_license_required.ult.b2b.ultimate', 'This action requires [product] Ultimate'),
('en', 'ultimate_or_storefront_license_required.ult.ru.new', 'This action requires [product] Ultimate'),
('en', 'ultimate_or_storefront_license_required.ult.ru', 'This action requires [product] Ultimate'),
('en', 'ultimate_or_storefront_license_required.ult.ru.ultimate', 'This action requires [product] Ultimate'),
('en', 'max_storefronts_reached', '<p>You have reached the limit of storefronts available for your license. To add another storefront, please upgrade to <a href="[ultimate_license_url]" target="_blank">[product] Ultimate</a>.</p>'),
('en', 'max_storefronts_reached.ult.new', '<p>You have reached the limit of storefronts available for your license. To add another storefront, please upgrade to <a href="[ultimate_license_url]" target="_blank">[product] Ultimate</a>.</p>'),
('en', 'max_storefronts_reached.ult', '<p>You have reached the limit of storefronts available for your license. To add another storefront, please upgrade to <a href="[ultimate_license_url]" target="_blank">[product] Ultimate</a>.</p>'),
('en', 'max_storefronts_reached.ult.ultimate', '<p>You have reached the limit of storefronts available for your license. To add another storefront, please upgrade to <a href="[ultimate_license_url]" target="_blank">[product] Ultimate</a>.</p>'),
('en', 'max_storefronts_reached.ult.b2b.new', '<p>You have reached the limit of storefronts available for your license. To add another storefront, please upgrade to <a href="[ultimate_license_url]" target="_blank">[product] Ultimate</a>.</p>'),
('en', 'max_storefronts_reached.ult.b2b', '<p>You have reached the limit of storefronts available for your license. To add another storefront, please upgrade to <a href="[ultimate_license_url]" target="_blank">[product] Ultimate</a>.</p>'),
('en', 'max_storefronts_reached.ult.b2b.ultimate', '<p>You have reached the limit of storefronts available for your license. To add another storefront, please upgrade to <a href="[ultimate_license_url]" target="_blank">[product] Ultimate</a>.</p>'),
('en', 'max_storefronts_reached.ult.ru.new', '<p>You have reached the limit of storefronts available for your license. To add another storefront, please upgrade to <a href="[ultimate_license_url]" target="_blank">[product] Ultimate</a>.</p>'),
('en', 'max_storefronts_reached.ult.ru', '<p>You have reached the limit of storefronts available for your license. To add another storefront, please upgrade to <a href="[ultimate_license_url]" target="_blank">[product] Ultimate</a>.</p>'),
('en', 'max_storefronts_reached.ult.ru.ultimate', '<p>You have reached the limit of storefronts available for your license. To add another storefront, please upgrade to <a href="[ultimate_license_url]" target="_blank">[product] Ultimate</a>.</p>'),
('en', 'new_text_ultimate_license_required', 'A special edition of [product] that offers an unlimited number of storefronts. If you switch to <a href="[ultimate_license_url]" target="_blank">[product] Ultimate</a>, you''ll never see the message about the storefront limit again.'),
('en', 'text_only_ultimate_license_required', 'A special edition called [product] Ultimate is required to perform this action. If you switch to <a href="[ultimate_license_url]" target="_blank">[product] Ultimate</a>, you''ll never see this message again, and you''ll also be able to create an unlimited number of storefronts.'),
('en', 'text_storefront_license_required', 'An additional storefront for your standard [product] license. Good for those who don''t intend to add a few more storefronts in the future.'),
('en', 'available_upgrades', 'Available upgrades'),
('en', 'additional_storefront_license_required', 'Additional [product] Storefront License Required'),
('en', 'text_additional_storefront_license_required', '<p>You can''t add a new storefront. The maximum number of storefronts allowed by your current license <code>[license_number]</code> is [allowed_storefronts], and you currently have [existing_storefronts].</p><p>To be able to add another storefront, please buy additional [product] Storefront License. If you want to add multiple new storefronts, buy the corresponding number of licenses.</p>'),
('en', 'storefront_license', 'Storefront License'),
('en', 'buy_new_storefront_license', 'Buy [product] Storefront License'),
('en', 'import_new_vendor', '[n] new vendor was created during the import. This vendor only has a name so far. Please edit the new vendor to add other information.|[n] new vendors were created during the import. These vendors only have names so far. Please edit the new vendors to add other information.'),
('en', 'file_changes_detector.snapshot_not_found', 'Snapshot of the clear installation was not found. Please restore <b>[dist_filename]</b>.'),
('en', 'file_changes_detector.added', 'Added'),
('en', 'file_changes_detector.changed', 'Changed'),
('en', 'file_changes_detector.deleted', 'Deleted'),
('en', 'licensing.license_error_license_is_disabled', 'The license is disabled. Please check your license status.'),
('en', 'licensing.license_error_license_is_disabled.title', 'Your [product] license has been disabled'),
('en', 'licensing.license_error_license_is_disabled.text', 'Please contact us <a href="[helpdesk_url]" target="_blank">via Customer Help Desk</a> to find out why it happened and what can be done about it. To access the admin panel right now, you can enter another valid license number, as long as it isn''t used in another store:'),
('en', 'licensing.license_error_license_is_invalid', 'Invalid license number. Please enter a valid license number.'),
('en', 'licensing.license_error_wrong_edition', 'The license does not match your store edition. Please enter a valid license number.'),
('en', 'licensing.license_error_wrong_licensing_mode', 'The license does not match your store licensing mode. Please enter a valid license number.'),
('en', 'upgrade_center.upgrade_process_failed', 'Upgrade process of your store has failed'),
('en', 'upgrade_center.apply_migration_failed', '<p>Please restore the pre-upgrade backup manually or via a link sent to your email address, then contact our technical support.</p><br><p>Tech details: Couldn''t complete migration [migration]. Reason: [error].</p><p>Completed migrations: [processed_count] out of [total_count].</p>'),
('en', 'profile_deactivated', 'Account deactivated'),
('en', 'text_profile_deactivated', 'Your account has been deactivated. Please contact us for more details.'),
('en', 'email_template.profile_deactivated', 'User account deactivation'),
('en', 'text_addon_disable_dependencies', 'The add-on cannot be disabled because the following add-ons depend on it: [addons]'),
('en', 'text_addon_enable_dependencies', 'The add-on cannot be enabled because it depends on the following add-ons: [addons]'),
('en', 'current_setting_value', 'Current value'),
('en', 'new_setting_value', 'New value'),
('en', 'overwrite_selected_settings', 'Overwrite selected settings'),
('en', 'payment_method_not_found', 'Payment method not found. It could''ve been disabled, or a technical problem occurred. Please choose a payment method and try again.'),
('en', 'shippings.ups.package_type.00', 'UNKNOWN'),
('en', 'shippings.ups.package_type.01', 'UPS Letter'),
('en', 'shippings.ups.package_type.02', 'Package'),
('en', 'shippings.ups.package_type.03', 'Tube'),
('en', 'shippings.ups.package_type.04', 'Pak'),
('en', 'shippings.ups.package_type.21', 'Express Box'),
('en', 'shippings.ups.package_type.24', '25KG Box'),
('en', 'shippings.ups.package_type.25', '10KG Box'),
('en', 'shippings.ups.package_type.30', 'Pallet'),
('en', 'shippings.ups.package_type.2a', 'Small Express Box'),
('en', 'shippings.ups.package_type.2b', 'Medium Express Box'),
('en', 'shippings.ups.package_type.2c', 'Large Express Box'),
('en', 'wrong_number_initial_order_id', 'The value you entered for the "Initial order ID value" setting is not supported. Only integers from 1 to [max_initial_order_id] are supported'),
('en', 'tt_views_shippings_components_services_ups_ship_ups_pickup_type', '<p>Select "Daily Pickup" to calculate the delivery cost according to Daily Rates.</p><p>Select "One Time Pickup", "Letter Center", or "Air Service Center" to calculate the delivery cost according to Retail Rates.</p>'),
('en', 'php_extension_missing', 'The [extension] PHP extension is not installed on your server'),
('en', 'customization', 'Customization'),
('en', 'assign_to_me', 'Assign to me'),
('en', 'customer_phone', 'Customer phone'),
('en', 'could_not_connect_to_database', 'Could not connect to database'),
('en', 'information_file_roobots', 'A robots.txt file was detected. The changes you make here won''t take effect until you delete the existing <b>robots.txt</b> file from the root directory of your store.'),
('en', 'advanced_products_search', 'Advanced products search'),
('en', 'advanced_companies_search', 'Advanced companies search'),
('en', 'advanced_storefronts_search', 'Advanced storefronts search'),
('en', 'api_wrong_user_company_relation', 'The user doesn''t exist for this store, and sharing users among stores is disabled.'),
('en', 'product_details_tabs', 'Tabs'),
('en', 'shippings.fedex.currency_is_missing', 'The rates calculated by FedEx are in [currency], and that currency doesn''t exist in your store. Please create that currency; otherwise customers won''t be able to select this shipping method.'),
('en', 'text_redactor2', 'Redactor II'),
('en', 'image_url', 'Image URL'),
('en', 'insert_image', 'Insert image'),
('en', 'view_avail_files_for_order', 'View the list of available files from order #[order_id].'),
('en', 'advanced_customer_search', 'Advanced customer search'),
('en', 'change_customer', 'Change customer'),
('en', 'on_backorder', 'On backorder'),
('en', 'invoice_heading', 'Invoice'),
('en', 'min_quantity', 'Minimum order quantity'),
('en', 'ship_downloadable', 'Enable shipping for downloadable products'),
('en', 'inventory_tracking', 'Inventory'),
('en', 'detailed_image', 'Detailed image'),
('en', 'secondary_categories', 'Secondary category'),
('en', 'override_points', 'Override points'),
('en', 'override_exchange_rate', 'Override exchange rate'),
('en', 'max_quantity', 'Maximum order quantity'),
('en', 'list_qty_count', 'List quantity count'),
('en', 'product_url', 'Product URL'),
('en', 'detailed_image_url', 'Detailed image URL'),
('en', 'box_size', 'Box size'),
('en', 'usergroup_ids', 'Usergroup ids'),
('en', 'combination_code', 'Combination code'),
('en', 'pair_type', 'Pair type'),
('en', 'lower_limit', 'Lower limit'),
('en', 'user_group', 'User group'),
('en', 'percentage_discount', 'Percentage discount'),
('en', 'feature_name', 'Feature name'),
('en', 'feature_id', 'Feature ID'),
('en', 'show_on_the_features_tab', 'Show on the features tab'),
('en', 'show_in_product_list', 'Show in product list'),
('en', 'show_in_product_header', 'Show in product header'),
('en', 'comparsion', 'Comparison'),
('en', 'variant_id', 'Variant ID'),
('en', 'feature_group', 'Feature group'),
('en', 'payment_id', 'Payment ID'),
('en', 'billing_first_name', 'Billing: first name'),
('en', 'billing_last_name', 'Billing: last name'),
('en', 'billing_address_line_2', 'Billing: address (line 2)'),
('en', 'billing_city', 'Billing: city'),
('en', 'billing_state', 'Billing: state'),
('en', 'billing_country', 'Billing: country'),
('en', 'billing_zipcode', 'Billing: zipcode'),
('en', 'shipping_first_name', 'Shipping: first name'),
('en', 'shipping_last_name', 'Shipping: last name'),
('en', 'shipping_address_line_2', 'Shipping: address (line 2)'),
('en', 'shipping_city', 'Shipping: city'),
('en', 'shipping_state', 'Shipping: state'),
('en', 'shipping_country', 'Shipping: country'),
('en', 'shipping_zipcode', 'Shipping: zipcode'),
('en', 'item_id', 'Item ID'),
('en', 'issuer_id', 'Issuer ID'),
('en', 'billing_phone', 'Billing: phone'),
('en', 'shipping_phone', 'Shipping: phone'),
('en', 'extra_fields', 'Extra fields'),
('en', 'country_code', 'Country code'),
('en', 'salt', 'Salt'),
('en', 'user_group_ids', 'User group IDs'),
('en', 'skip_creating_new_products', 'Skip creating new products'),
('en', 'text_skip_creating_new_products', 'If you enable this setting, then only the products that already exist in your database will be updated.'),
('en', 'update_existing_products_only', 'Update existing products only'),
('en', 'update_existing_products_only_tooltip', 'If you enable this setting, products that don''t exist in the database of your store will be skipped during import.'),
('en', 'updated_last', 'Updated in the last'),
('en', 'hour_or_hours', 'hour(s)'),
('en', 'api_required_fields', 'The following fields are required: [fields]'),
('en', 'api_one_of_fields_required', 'One of the following fields is required: [fields]'),
('en', 'api_invalid_value', 'Invalid value `[value]` specified for [field]'),
('en', 'api_invalid_value_w_valid_list', 'Invalid value `[value]` specified for [field]. Valid values are: [valid_list]'),
('en', 'api_empty_value', 'Empty value specified for the required [field] field.'),
('en', 'recover', 'Recover'),
('en', 'image_has_been_deleted', 'This image has been deleted'),
('en', 'delete_all_images', 'Delete all images'),
('en', 'cannot_upload_file', 'Cannot upload file'),
('en', 'ogone.sha_in', 'SHA-IN pass phrase'),
('en', 'ttc_ogone.sha_in', 'The SHA-IN pass phrase is set on the Ingenico administration panel on the <b>Data and origin verification</b> tab.'),
('en', 'ogone_web.sha_out', 'SHA-OUT pass phrase'),
('en', 'ttc_ogone_web.sha_out', 'The SHA-OUT pass phrase is set on the Ingenico administration panel on the <b>Transaction feedback</b> tab.'),
('en', 'ogone_direct.config_info', 'Enter SHA-IN pass phrase both here and on the Ingenico administation panel.<br><br>For new Ingenico accounts created since May 11th, 2010, the new SHA policy is automatically active.<br/>Please do not forget to select the "Use new SHA signature policy" checkbox.'),
('en', 'ogone_web.config_info', 'Please set the following URL in the Technical Information section on the Ingenico administation panel as the <b>URL of the merchant''s post-payment page</b> for all cases ("accepted", "on hold", "uncertain", "canceled by the client", "too many rejections by the acquirer"): <code>[r_url]</code><br>Select "Always deferred (not immediately after the payment)" for the <b>Timing of the request</b>.<br>Enter SHA-IN and SHA-OUT pass phrases both here and on the Ingenico administation panel.'),
('en', 'sort_by_null_desc', 'No sorting'),
('en', 'storefront_name', 'Storefront name'),
('en', 'storefront_name_short', 'Storefront name'),
('en', 'internal_option_name', 'Internal name'),
('en', 'internal_option_name_tooltip', 'This name is shown only in the Administration panel to help you distinguish between multiple options that have the same displayed name.'),
('en', 'internal_feature_name_tooltip', 'This name is shown only in the Administration panel to help you distinguish between multiple features that have the same displayed name.'),
('en', 'internal_feature_group_name_tooltip', 'This name is shown only in the Administration panel to help you distinguish between multiple feature groups that have the same displayed name.'),
('en', 'edit_corresponding_profile_field', 'To change the field type or variants, <a href="[URL]">edit the corresponding field in the Shipping Address section</a>.'),
('en', 'error_product_codes_length', 'The following product codes are too long and were cut off at [product_code_length] symbols:'),
('en', 'log_action_shipping', 'Shipping request'),
('en', 'email_template.shipping_error', 'Shipping: request error'),
('en', 'request_error_information_title', 'Shipping error'),
('en', 'request_error_information', 'Customers have experienced issues with receiving rates from <b>the [shipping]</b> shipping method. Please make sure that is configured properly and that the shipping rate calculation is correct'),
('en', 'press_continue_to_recover_password', 'Click <b>Continue</b> to proceed with password change.'),
('en', 'file_uploader.default_message', 'Drop files here to upload'),
('en', 'file_uploader.fallback_message', 'Your browser does not support drag''n''drop file uploads.'),
('en', 'file_uploader.fallback_text', 'Please use the fallback form below to upload your files like in the olden days.'),
('en', 'file_uploader.file_too_big', 'File is too big ({{filesize}}MB). Max filesize: {{maxFilesize}}MB.'),
('en', 'file_uploader.invalid_file_type', 'You can''t upload files of this type.'),
('en', 'file_uploader.response_error', 'Server responded with {{statusCode}} code.'),
('en', 'file_uploader.cancel_upload', 'Cancel upload'),
('en', 'file_uploader.upload_canceled', 'Upload canceled.'),
('en', 'file_uploader.cancel_upload_confirmation', 'Are you sure you want to cancel this upload?'),
('en', 'file_uploader.remove_file', 'Remove file'),
('en', 'file_uploader.remove_file_confirmation', 'Do you want to remove this image?'),
('en', 'file_uploader.max_files_exceeded', 'You can not upload any more files.'),
('en', 'file_uploader.file_size_units_tb', 'TB'),
('en', 'file_uploader.file_size_units_gb', 'GB'),
('en', 'file_uploader.file_size_units_mb', 'MB'),
('en', 'file_uploader.file_size_units_kb', 'KB'),
('en', 'file_uploader.file_size_units_b', 'b'),
('en', 'drop_images_to_upload', 'Drop images here'),
('en', 'drop_images_select_short', 'Select'),
('en', 'drop_images_select', 'Select images'),
('en', 'currency_code_afn', 'Afghan Afghani'),
('en', 'currency_code_dzd', 'Algerian Dinar'),
('en', 'currency_code_aoa', 'Angolan Kwanza'),
('en', 'currency_code_aon', 'Angolan New Kwanza'),
('en', 'currency_code_ats', 'Antillian Guilder'),
('en', 'currency_code_azn', 'Azerbaijanian Manat'),
('en', 'currency_code_bsd', 'Bahamian Dollar'),
('en', 'currency_code_bhd', 'Bahraini Dinar'),
('en', 'currency_code_bdt', 'Bangladesh Taka'),
('en', 'currency_code_bbd', 'Barbados Dollar'),
('en', 'currency_code_byn', 'Belarussian Ruble'),
('en', 'currency_code_bef', 'Belgian Franc'),
('en', 'currency_code_bzd', 'Belize Dollar'),
('en', 'currency_code_bmd', 'Bermudian Dollar'),
('en', 'currency_code_btn', 'Bhutan Ngultrum'),
('en', 'currency_code_bob', 'Bolivian Boliviano'),
('en', 'currency_code_bam', 'Bosnia and Herzegovina Convertible Marks'),
('en', 'currency_code_bwp', 'Botswana Pula'),
('en', 'currency_code_bnd', 'Brunei Dollar'),
('en', 'currency_code_bgl', 'Bulgaria Lev'),
('en', 'currency_code_bif', 'Burundi Franc'),
('en', 'currency_code_khr', 'Cambodian Riel'),
('en', 'currency_code_cve', 'Cape Verde Escudo'),
('en', 'currency_code_kyd', 'Cayman Islands Dollar'),
('en', 'currency_code_clp', 'Chilean Peso'),
('en', 'currency_code_cop', 'Colombian Peso'),
('en', 'currency_code_kmf', 'Congolese Franc'),
('en', 'currency_code_crc', 'Costa Rican Colon'),
('en', 'currency_code_cyp', 'Cyprus Pound'),
('en', 'currency_code_dem', 'Deutsche Mark'),
('en', 'currency_code_djf', 'Djibouti Franc'),
('en', 'currency_code_std', 'Dobra'),
('en', 'currency_code_dop', 'Dominican Peso'),
('en', 'currency_code_nlg', 'Dutch Guilder'),
('en', 'currency_code_xcd', 'East Caribbean Dollar'),
('en', 'currency_code_ecs', 'Ecuador Sucre'),
('en', 'currency_code_cdf', 'Congolese Franc'),
('en', 'currency_code_svc', 'El Salvador Colon'),
('en', 'currency_code_ern', 'Eritrean Nafka'),
('en', 'currency_code_etb', 'Ethiopian Birr'),
('en', 'currency_code_fkp', 'Falkland Islands Pound'),
('en', 'currency_code_fim', 'Finnish Markka'),
('en', 'currency_code_gmd', 'Gambian Dalasi'),
('en', 'currency_code_ghs', 'Ghana Cedi'),
('en', 'currency_code_gip', 'Gibraltar Pound'),
('en', 'currency_code_grd', 'Greek Drachma'),
('en', 'currency_code_gtq', 'Guatemalan Quetzal'),
('en', 'currency_code_gnf', 'Guinea Franc'),
('en', 'currency_code_gyd', 'Guyana Dollar'),
('en', 'currency_code_htg', 'Haiti Gourde'),
('en', 'currency_code_hnl', 'Honduran Lempira'),
('en', 'currency_code_idr', 'Indonesian Rupiah'),
('en', 'currency_code_irr', 'Iranian Rial'),
('en', 'currency_code_iqd', 'Iraqi Dinar'),
('en', 'currency_code_iep', 'Irish Pound'),
('en', 'currency_code_itl', 'Italian Lira'),
('en', 'currency_code_jmd', 'Jamaican Dollar'),
('en', 'currency_code_jod', 'Jordanian Dinar'),
('en', 'currency_code_kes', 'Kenyan Shilling'),
('en', 'currency_code_lak', 'Laos Kip'),
('en', 'currency_code_lbp', 'Lebanese Pound'),
('en', 'currency_code_lsl', 'Lesotho Loti (Maloti)'),
('en', 'currency_code_lrd', 'Liberian Dollar'),
('en', 'currency_code_lyd', 'Libyan Dinar'),
('en', 'currency_code_luf', 'Luxembourg Franc'),
('en', 'currency_code_mop', 'Macau Pataca'),
('en', 'currency_code_mkd', 'Macedonian (FYR) Denar'),
('en', 'currency_code_mga', 'Malagasy Ariary'),
('en', 'currency_code_mgf', 'Malagasy Franc'),
('en', 'currency_code_mwk', 'Malawi Kwacha');
INSERT INTO `[[dbprefix]]language_values` VALUES
('en', 'currency_code_mvr', 'Maldives Rufiyaa'),
('en', 'currency_code_mtl', 'Maltese Lira'),
('en', 'currency_code_mro', 'Mauritania Ouguiya'),
('en', 'currency_code_mur', 'Mauritius Rupee'),
('en', 'currency_code_mdl', 'Moldovan Leu'),
('en', 'currency_code_mnt', 'Mongolian Tugrik'),
('en', 'currency_code_mzn', 'Mozambique Metical'),
('en', 'currency_code_mmk', 'Myanmar Kyat'),
('en', 'currency_code_nad', 'Namibian Dollar'),
('en', 'currency_code_npr', 'Nepalese Rupee'),
('en', 'currency_code_rsd', 'New Serbian Dinar'),
('en', 'currency_code_nio', 'Nicaraguan Cordoba Oro'),
('en', 'currency_code_ngn', 'Nigerian Naira'),
('en', 'currency_code_pkr', 'Pakistan Rupee'),
('en', 'currency_code_pab', 'Panamanian Balboa'),
('en', 'currency_code_pgk', 'Papua New Guinea Kina'),
('en', 'currency_code_pyg', 'Paraguayan Guarani'),
('en', 'currency_code_pen', 'Peruvian Nuevo Sol'),
('en', 'currency_code_uyu', 'Peso Uruguayo'),
('en', 'currency_code_pte', 'Portugese Escudo'),
('en', 'currency_code_qar', 'Qatari Rial'),
('en', 'currency_code_omr', 'Rial Omani'),
('en', 'currency_code_rol', 'Romanian Lei'),
('en', 'currency_code_rwf', 'Rwanda Franc'),
('en', 'currency_code_csd', 'Serbian Dinar'),
('en', 'currency_code_scr', 'Seychelles Rupee'),
('en', 'currency_code_sll', 'Sierra Leone Leone'),
('en', 'currency_code_sos', 'Somalia Shilling'),
('en', 'currency_code_esp', 'Spanish Peseta'),
('en', 'currency_code_lkr', 'Sri Lanka Rupee'),
('en', 'currency_code_shp', 'St Helena Pound'),
('en', 'currency_code_sdp', 'Sudanese Pound'),
('en', 'currency_code_srd', 'Suriname Dollar'),
('en', 'currency_code_srg', 'Suriname Guilder'),
('en', 'currency_code_szl', 'Swaziland Lilangeni'),
('en', 'currency_code_syp', 'Syrian Pound'),
('en', 'currency_code_tjs', 'Tajikistan Somoni'),
('en', 'currency_code_tzs', 'Tanzanian Shilling'),
('en', 'currency_code_ttd', 'Trinidad and Tobago Dollar'),
('en', 'currency_code_tnd', 'Tunisian Dinar'),
('en', 'currency_code_trl', 'Turkish Lira'),
('en', 'currency_code_tmt', 'Turkmenistan Manat'),
('en', 'currency_code_ugx', 'Uganda Shilling'),
('en', 'currency_code_uzs', 'Uzbekistan Sum'),
('en', 'currency_code_veb', 'Venezuela Bolivar'),
('en', 'currency_code_vef', 'Venezuela Bolivar Fuerte'),
('en', 'currency_code_vnd', 'Vietnamese New Dong'),
('en', 'currency_code_yer', 'Yemeni Rial'),
('en', 'currency_code_yum', 'Yugoslavian New Dinar'),
('en', 'currency_code_zmw', 'Zambian Kwacha'),
('en', 'currency_code_zwd', 'Zimbabwe Dollar'),
('en', 'editing_order_invoice_responsive', 'Editing invoice for order'),
('en', 'responsive_admin.email_order_invoice_subject', '[company_name]: Invoice for order'),
('en', 'file_uploading_in_progress_please_wait', 'File uploading in progress. Please wait.'),
('en', 'profile_types_section_user', 'Customers and admins'),
('en', 'profile_types_section_seller', 'Vendor information'),
('en', 'profile_type', 'Profile type'),
('en', 'bulk_edit.example_of_modified_value', 'Example of the modified value'),
('en', 'bulk_edit.decrease_hint', 'To decrease the value use the "-". Example: -5'),
('en', 'bulk_edit.make_active', 'Make products active'),
('en', 'bulk_edit.make_disabled', 'Make products disabled'),
('en', 'bulk_edit.make_hidden', 'Make products hidden'),
('en', 'bulk_edit.price_and_stock', 'Price & Stock'),
('en', 'bulk_edit.what_do_these_checkboxes_mean', 'What do these checkboxes mean?'),
('en', 'bulk_edit.what_do_these_checkboxes_mean_checked', 'all the selected products belong to this category or will be assigned to it.'),
('en', 'bulk_edit.what_do_these_checkboxes_mean_unchecked', 'none of the selected products belong to this category, or they will be removed from it.'),
('en', 'bulk_edit.what_do_these_checkboxes_mean_indeterminate', 'some of the selected products belong to this category; no changes will be made.'),
('en', 'bulk_edit.unable_to_delete_all_categories', 'At least one category must be selected'),
('en', 'bulk_edit.some_products_were_omitted', 'Some products were skipped because the last remaining category can''t be removed or added for a product.'),
('en', 'bulk_edit.some_products_were_omitted_other_storefront', 'Couldn''t edit selected products. Some of the selected products belong to other storefronts; please deselect those products to be able to edit remaining ones.'),
('en', 'custom_search', 'Custom search'),
('en', 'system_environment', 'System environment'),
('en', 'product_feature.purpose', 'Purpose'),
('en', 'ttc_product_feature.purpose', 'Determines how you and your customers will be able to use this feature.'),
('en', 'product_feature.purpose.organize_catalog', 'Brand, author, etc.'),
('en', 'product_feature.purpose.organize_catalog.description', 'For features like "Brand" or "Manufacturer" (for most products), "Performer" or "Label" (for music), "Author" or "Publisher" (for books), and so on. Every variant of this feature gets its own page with an image, description, and the list of products.'),
('en', 'product_feature.purpose.find_products', 'Product search via filters'),
('en', 'product_feature.purpose.find_products.description', 'For a feature that just allows you to specify an additional property of a product (for example, "Fabric" for T-shirts). If you create a filter by that feature, customers will see that such a property exists, and will be able to search products by it.'),
('en', 'product_feature.purpose.describe_product', 'Additional information'),
('en', 'product_feature.purpose.describe_product.description', 'For cases when you just need to show some information on a product page. There are no filters for this kind of features.'),
('en', 'product_feature.feature_style', 'Feature style'),
('en', 'ttc_product_feature.feature_style', 'Determines the look of this feature on the product page.'),
('en', 'product_feature.feature_style.checkbox', 'Checkbox'),
('en', 'product_feature.feature_style.color', 'Color'),
('en', 'product_feature.filter_style.color', 'Color'),
('en', 'product_feature.feature_style.multiple_checkbox', 'Multiple checkboxes'),
('en', 'product_feature.feature_style.text', 'Text or number'),
('en', 'product_feature.feature_style.number', 'Number'),
('en', 'product_feature.feature_style.brand', 'Brand'),
('en', 'product_feature.filter_style', 'Filter type'),
('en', 'ttc_product_feature.filter_style', 'Determines the look of a filter by this feature on the product list. Filters make it easier for customers to find a product with the desired feature value. You''ll be able to create a filter after you create a feature.'),
('en', 'product_feature.filter_style.checkbox', 'Checkbox'),
('en', 'product_feature.filter_style.slider', 'Number slider'),
('en', 'product_feature.filter_style.date', 'Date selector'),
('en', 'privilege_groups.blog_and_pages', 'Blog & Pages'),
('en', 'privilege_groups.orders', 'Orders'),
('en', 'privilege_groups.order_statuses', 'Order statuses'),
('en', 'privilege_groups.other', 'Other'),
('en', 'privilege_groups.backup_restore', 'Backup/Restore'),
('en', 'privilege_groups.blocks', 'Blocks'),
('en', 'privilege_groups.currencies', 'Currencies'),
('en', 'privilege_groups.design', 'Design'),
('en', 'privilege_groups.documents', 'Documents'),
('en', 'privilege_groups.file_changes', 'File changes detector'),
('en', 'privilege_groups.files', 'Files'),
('en', 'privilege_groups.edit_on_site', 'Edit content on-site'),
('en', 'privilege_groups.email_templates', 'Email templates'),
('en', 'privilege_groups.exim', 'Import and export data'),
('en', 'privilege_groups.languages', 'Languages'),
('en', 'privilege_groups.locations', 'Rate areas'),
('en', 'privilege_groups.logs', 'Logs'),
('en', 'privilege_groups.sales_reports', 'Sales reports'),
('en', 'privilege_groups.sitemap', 'Sitemap'),
('en', 'privilege_groups.shipping', 'Shipping methods'),
('en', 'privilege_groups.payments', 'Payment methods'),
('en', 'privilege_groups.products', 'Categories, Products, Features, Filters, Options'),
('en', 'privilege_groups.promotions', 'Promotions'),
('en', 'privilege_groups.static_data', 'Static data'),
('en', 'privilege_groups.stores', 'Storefronts'),
('en', 'privilege_groups.storage', 'Storage'),
('en', 'privilege_groups.settings', 'Settings'),
('en', 'privilege_groups.taxes', 'Taxes'),
('en', 'privilege_groups.themes', 'Themes'),
('en', 'privilege_groups.users', 'Users'),
('en', 'privilege_groups.user_groups', 'User groups'),
('en', 'privilege_groups.upgrade_center', 'Upgrade center'),
('en', 'privilege.full_access', 'Full access'),
('en', 'privilege.view_access', 'Can view only'),
('en', 'privilege.no_access', 'No access'),
('en', 'privilege.custom_access', 'Custom access'),
('en', 'privilege.apply_to_all', 'Apply value to all'),
('en', 'open_hours', 'Open hours'),
('en', 'affected_email_templates', 'Email templates using this document'),
('en', 'pickup_point_not_selected', 'Sorry, we couldn''t determine your pickup point. Please choose a pickup point, so that we know where to deliver your order.'),
('en', 'no_manager_assigned', 'No manager assigned'),
('en', 'block_manager.view_layout.reset_filter', 'Edit layouts'),
('en', 'block_manager.view_layout.phone', 'Phone preview'),
('en', 'block_manager.view_layout.tablet', 'Tablet preview'),
('en', 'block_manager.view_layout.desktop', 'Desktop preview'),
('en', 'block_manager.availability.show_on', 'Show on'),
('en', 'block_manager.availability.phone', 'Phone'),
('en', 'block_manager.availability.tablet', 'Tablet'),
('en', 'block_manager.availability.desktop', 'Desktop'),
('en', 'add_as_order', 'Add as order'),
('en', 'is_address_required', 'Customer must specify his/her address'),
('en', 'go_to_admin_panel', 'Admin panel'),
('en', 'checkout.min_cart_subtotal_required', 'To continue checkout process your order subtotal must exceed [amount]'),
('en', 'lite_checkout.customer_information', 'Customer'),
('en', 'lite_checkout.personal_name', 'Full name'),
('en', 'lite_checkout.city_and_state', 'City, state'),
('en', 'lite_checkout.place_an_order_for', 'Place order ([amount])'),
('en', 'lite_checkout.delivery_note', 'Customer''s notes'),
('en', 'lite_checkout.shippings.show_all_on_map', 'Show all on map'),
('en', 'lite_checkout.nearest_station', 'Nearest station'),
('en', 'lite_checkout.select_pickup_item', 'Select a pickup point'),
('en', 'lite_checkout.choose_from_list', 'Choose from list'),
('en', 'lite_checkout.use_two_fingers_for_move_map', 'Use two fingers to move the map'),
('en', 'lite_checkout.select_your_city', 'Specify your city'),
('en', 'lite_checkout.deliver_to', 'Deliver to:'),
('en', 'lite_checkout.click_here_to_update_shipping', 'Enter city and state and click here to update shipping rates'),
('en', 'lite_checkout.shipping_method_for', 'Shipping method for [group_name]'),
('en', 'deprecated', 'Deprecated'),
('en', 'collapse_section', 'Collapse section'),
('en', 'expand_section', 'Expand section'),
('en', 'companies', 'Stores'),
('en', 'storefronts', 'Storefronts'),
('en', 'editing_storefront', 'Editing storefront'),
('en', 'creating_storefront', 'Creating storefront'),
('en', 'all_languages', 'All languages'),
('en', 'all_currencies', 'All currencies'),
('en', 'all_companies', 'All stores'),
('en', 'storefront_status', 'Status'),
('en', 'storefront_status.tooltip', 'Even if the storefront is closed (the status set to OFF), you''ll be able to view it if you have an access key. Specify the <i>Access key to temporarily closed storefront</i> below.<br/>Use http://www.example.com/index.php?store_access_key=key_value to access a closed storefront.'),
('en', 'storefront_access_key', 'Access key to temporarily closed storefront'),
('en', 'storefront_access_key.setting_notice', 'You can set the access key on the storefront editing page'),
('en', 'close_storefront', 'Close storefront'),
('en', 'close_storefront.setting_notice', 'You can open or close a storefront on the storefront editing page'),
('en', 'open_selected_storefronts', 'Open selected'),
('en', 'close_selected_storefronts', 'Close selected'),
('en', 'add_storefront', 'Add storefront'),
('en', 'storefront_status_changed.Y', 'The storefront was <b>closed</b>|The storefronts were <b>closed</b>'),
('en', 'storefront_status_changed.N', 'The storefront was <b>opened</b>|The storefronts were <b>opened</b>'),
('en', 'default_storefront', 'Default'),
('en', 'add_profile_fields', 'Add profile fields'),
('en', 'add_profile_fields_and_close', 'Add profile fields and close'),
('en', 'checkout_block_with_heading', 'Checkout block (H2 heading)'),
('en', 'notifications_center.no_notifications', 'No notifications'),
('en', 'notifications_center.notifications', 'Notifications'),
('en', 'notifications_center.section.all', 'All'),
('en', 'notifications_center.section.administration', 'Administration'),
('en', 'notifications_center.section.products', 'Products'),
('en', 'notifications_center.section.other', 'Other'),
('en', 'notifications_center.tag.administration.update', 'Update'),
('en', 'notifications_center.tag.administration.license', 'License'),
('en', 'notifications_center.tag.other', 'Other'),
('en', 'notifications_center.mark_all_as_read', 'Mark all as read'),
('en', 'notification.upgrade_available.title', 'New CS-Cart version is available'),
('en', 'notification.upgrade_available.message', 'To see what the new version brings, <a href="[link]">visit the Upgrade Center</a>.'),
('en', 'notification.addons_upgrade_available.title', 'New versions are available for your add-ons'),
('en', 'notification.addons_upgrade_available.message', 'To install these updates, <a href="[link]">visit the Upgrade Center</a>.'),
('en', 'authorize_before_order', 'Only registered customers can place an order. Please sign in to your account or register a new one.'),
('en', 'storefront_with_same_url_exists', 'A storefront with the specified URL already exists'),
('en', 'edit_layout_on_site', 'Edit layout on-site'),
('en', 'on_site_layout_editing', 'Editing layout page: [page]'),
('en', 'bottom_panel.go_to_home_page', 'Go to home page'),
('en', 'bottom_panel.go_to_dashboard', 'Go to Dashboard'),
('en', 'bottom_panel.show_bottom_admin_panel', 'Show admin toolbar'),
('en', 'bottom_panel.hide_bottom_admin_panel', 'Hide admin toolbar'),
('en', 'bottom_panel.storefront', 'Storefront'),
('en', 'bottom_panel.admin_panel', 'Admin panel'),
('en', 'bottom_panel.vendor_panel', 'Vendor panel'),
('en', 'bottom_panel.preview_mode', 'Preview'),
('en', 'bottom_panel.build_mode', 'Edit structure'),
('en', 'bottom_panel.build_mode.not_available', 'Available at the following page types: homepage, product, category, checkout.'),
('en', 'bottom_panel.theme_mode.not_available', 'Available only in your microstore or on the pages of your products and blog articles.'),
('en', 'bottom_panel.text_mode', 'Edit texts'),
('en', 'bottom_panel.theme_mode', 'Edit style'),
('en', 'bottom_panel.settings', 'Settings'),
('en', 'bottom_panel.change_theme', 'Change theme'),
('en', 'bottom_panel.edit_layout', 'Edit layout'),
('en', 'bottom_panel.edit_template', 'Edit template'),
('en', 'bottom_panel.edit_translations', 'Edit translations'),
('en', 'bottom_panel.edit_menus', 'Edit menus'),
('en', 'bottom_panel.edit_product_tabs', 'Edit product tabs'),
('en', 'bottom_panel.restore_demo', 'Restore demo'),
('en', 'bottom_panel.documentation', 'Documentation'),
('en', 'bottom_panel.help', 'Help'),
('en', 'bottom_panel.community_forums', 'Community forums'),
('en', 'bottom_panel.video_tutorials', 'Video tutorials'),
('en', 'bottom_panel.faq', 'FAQ'),
('en', 'bottom_panel.customer_help_desk', 'Contact support'),
('en', 'bottom_panel.hire_a_developers', 'Hire a developer'),
('en', 'bottom_panel.download', 'Download'),
('en', 'bottom_panel.buy_license', 'Buy license'),
('en', 'bottom_panel.trial_left', 'Remaining trial period'),
('en', 'demo_panel.theme_editor.enable', 'Edit style<br/><br/>Change the style of your store (logos, colors, fonts, and so on) and see the changes as you make them.<br/><br/>To use this functionality in your [product] store, go to Design → Themes and click "Theme editor"'),
('en', 'demo_panel.block_manager.enable', 'Edit structure<br/><br/>Change various blocks with information: show them, hide them, or move them as you see fit.<br/>This currently works at the following page types: homepage, product, category, checkout.<br/><br/>To use this functionality in your [product] store, go to Design → Themes and click "Edit layout on-site"'),
('en', 'individual', 'Individual'),
('en', 'link_an_existing_option', 'Link an existing option'),
('en', 'create_or_link_an_existing_option', 'Create or link an existing option'),
('en', 'tip.quick_select_and_close_category_selector', 'Tip: Hold ''Ctrl'' (or "⌘" on Mac) while clicking on a category name. This will add one category and close the window.'),
('en', 'checkout_select_profile_before_order', 'Please select a profile before you place the order.'),
('en', 'editing_profile_name', 'Editing profile: [name]'),
('en', 'bm.customer_information_block.warning.email_or_phome_must_be_required', 'Contact information must always have either email, or phone as a required field.'),
('en', 'bm.customer_information_block.warning.field_automaticly_added', '"[field_name]" has been added as a required field automatically.'),
('en', 'bm.customer_information_block.warning.field_marked_as_required', 'The "[field_name]" field has been marked as required.'),
('en', 'required_profile_field_description', 'The "[field_name]" profile field is required as it is used to calculate shipping rates.'),
('en', 'upgrade_notification_welcome_title', 'Welcome to [product] [version]!'),
('en', 'upgrade_notification_welcome_text', '<p class="lead">To help you get started, we’ve compiled the list of what you should check after the upgrade. The full list of changes is in the changelog.</p><p class="lead">If you ever need to check this message later, we’ve also sent a copy to [email].</p>'),
('en', 'view_changelog', 'View changelog'),
('en', 'upgrade_notification_what_check_first', 'What to check first?'),
('en', 'upgrade_notification_what_else_to_check', 'What else is there to check?'),
('en', 'cant_remove_addon_files', 'Add-on files couldn''t be removed'),
('en', 'addon_reinstall.intro', 'Looks like you are trying to install an add-on that is already installed. We can do it for you in two ways; we recommend the safe way.'),
('en', 'addon_reinstall.safe_way', '<strong>The safe way:</strong> we''ll uninstall the old add-on first, and then install the new one. The drawback is that any data and settings related to the add-on will be lost.'),
('en', 'addon_reinstall.dangerous_way', '<strong>The dangerous way:</strong> we''ll replace all the files of the add-on with new ones, but keep all the add-on''s data in the database intact. This can break the add-on, or might even break your store. Please don''t use the dangerous way, unless you absolutely know what you''re doing.'),
('en', 'addon_reinstall.dangerous_way.confirm', 'I know the risks and want to use the dangerous way.'),
('en', 'addon_reinstall.dangerous_way.action', 'Use the dangerous way'),
('en', 'addon_reinstall.safe_way.action', 'Use the safe way'),
('en', 'all_storefronts', 'All storefronts'),
('en', 'add_storefronts', 'Add storefronts'),
('en', 'add_storefronts_and_close', 'Add storefronts and close'),
('en', 'event.receiver.c', 'Customer'),
('en', 'event.receiver.a', 'Administrator'),
('en', 'event.receiver.v', 'Vendor'),
('en', 'event.transport.mail', 'E-mail'),
('en', 'event.transport.internal', 'Notifications center'),
('en', 'event.order.edp.name', 'Access to downloadable products granted'),
('en', 'event.notification_type', 'Notification type'),
('en', 'notifications', 'Notifications'),
('en', 'event.order.updated.name', 'Order was updated'),
('en', 'event.order.shipment_updated.name', 'Products were shipped'),
('en', 'purpose', 'Purpose'),
('en', 'feature_style', 'Feature style'),
('en', 'filter_style', 'Filter type'),
('en', 'all_block_types', 'All block types'),
('en', 'all_layouts', 'All layouts'),
('en', 'all_locations', 'All locations'),
('en', 'n_categories', '[n] category|[n] categories'),
('en', 'n_pages', '[n] page|[n] pages'),
('en', 'n_filters', '[n] filter|[n] filters'),
('en', 'n_profile_fields', '[n] profile field|[n] profile fields'),
('en', 'event.profile.activated.name', 'Profile was activated'),
('en', 'event.profile.deactivated.name', 'Profile was deactivated'),
('en', 'event.profile.password_reminder.name', 'Reminder about necessary password change'),
('en', 'event.profile.usergroup_request.name', 'Membership in user group was requested'),
('en', 'event.profile.updated.name', 'Profile was updated'),
('en', 'event.profile.added.name', 'Profile requires activation'),
('en', 'event.profile.created.name', 'Profile was created'),
('en', 'event.profile.usergroup_activation.name', 'User group activation'),
('en', 'event.profile.usergroup_disactivation.name', 'User group disactivation'),
('en', 'event.profile.usergroup_updated.name', 'Membership in user group was changed'),
('en', 'event.profile.password_recovery.name', 'Password recovery'),
('en', 'export_found_products', 'Export found products'),
('en', 'hello_name', 'Hello [name],'),
('en', 'checkout.email_exists.popup.title', 'You may have bought from us before'),
('en', 'checkout.email_exists.popup.message', 'An account with your email already exists. We can sign you in (password won''t be needed), or you can use another email if you''d like.'),
('en', 'checkout.email_exists.popup.cancel_btn', 'Use another email'),
('en', 'checkout.email_exists.popup.sign_in_btn', 'Sign me in'),
('en', 'auth.one_time_password.popup.title', 'Password-free sign-in'),
('en', 'auth.one_time_password.popup.message', 'We''ve sent a one-time code to <strong>[email]</strong>. Please enter it below, and we''ll sign you in without a password.'),
('en', 'auth.one_time_password.popup.input_placeholder', 'Enter the code here'),
('en', 'auth.one_time_password.popup.resend_btn', 'Resend the code'),
('en', 'auth.one_time_password.popup.sign_in_btn', 'Sign me in'),
('en', 'auth.one_time_password.notification.info_password_sent', 'We''ve sent a one-time code to [email].'),
('en', 'auth.one_time_password.notification.error_password_invalid', 'Sorry, it seems that the code you''ve entered is incorrect. It may have expired or been used already. Please check the code you''re entering or request a new code.'),
('en', 'auth.one_time_password.notification.error_password_required', 'Please enter the code to sign in.'),
('en', 'email.one_time_password.title', 'Sign in without password'),
('en', 'email.one_time_password.message', '<p>You''ve requested a one-time code to sign in to <a href="[storefront_url]">[storefront_url]</a>. Here it is:</p><p><strong><code>[password]</code></strong></p><p>Please don''t tell this code to anyone else. If you haven''t requested the code, then you can safely ignore this message. Nobody will be able to sign in to your account, unless they know your password or can view your inbox.</p>'),
('en', 'email_template.one_time_password_request', 'One-time code for password-free sign-in'),
('en', 'other_notification', 'Other'),
('en', 'see_full_templates_list', 'Can''t find a notification you''re looking for?<br/><a href="[email_template_manage]">See the full list of email templates</a><br/><a href="[internal_template_manage]">See the full list of on-site notification templates</a>'),
('en', 'other_notifications.title', 'Can''t find a notification you''re looking for?'),
('en', 'other_notifications.email_templates', 'See the full list of email templates'),
('en', 'other_notifications.internal_templates', 'See the full list of on-site notification templates'),
('en', 'internal_templates', 'On-site notification templates'),
('en', 'editing_internal_template', 'Editing on-site notification template'),
('en', 'send_test_notification', 'Send test notification'),
('en', 'count_internal_template_successfully_imported', 'On-site notification templates successfully imported:'),
('en', 'count_internal_template_fail_imported', 'On-site notification templates import failed:'),
('en', 'internal_template_import_success_msg', 'All the on-site notification templates have been imported without errors.'),
('en', 'internal_template_exists', 'The on-site notification template with the chosen code already exists, please try another.'),
('en', 'notification_template.tab.email', 'Email'),
('en', 'notification_template.tab.internal', 'On-site'),
('en', 'lite_checkout.chosen_shipping_not_avaliable', 'Sorry, we can''t get the rates for your selected shipping method. Please check your address and make sure that it is correct. If this doesn''t help, please select another shipping method or contact us.'),
('en', 'lite_checkout.not_available', 'Not available'),
('en', 'last_login', 'Last login'),
('en', 'total_orders', 'Created orders'),
('en', 'total_paid_orders', 'Paid orders'),
('en', 'total_spent_money', 'Total spend'),
('en', 'notifications_center.section.communication', 'Communication'),
('en', 'notifications_center.tag.messages', 'Messages'),
('en', 'settled_order_status', 'Consider order paid'),
('en', 'edit_on_site', 'Edit on site'),
('en', 'order_manager', 'Order manager'),
('en', 'privilege_groups.internal_templates', 'On-site notification templates'),
('en', 'privilege_groups.notification_settings', 'Notifications'),
('en', 'logo_section.theme', 'Site logo'),
('en', 'logo_section.favicon', 'Favicon'),
('en', 'logo_section.mail', 'E-mail logo'),
('en', 'show_extra_logos', 'Show extra logos'),
('en', 'hide_extra_logos', 'Hide extra logos'),
('en', 'test_rate_calculation', 'Test rate calculation'),
('en', 'calculated_rate', 'Calculated rate'),
('en', 'calculated_automatically', 'Calculated automatically'),
('en', 'additional_settings', 'Additional settings'),
('en', 'rates_calculated_info', 'Rates are calculated for [n] product that costs [price].|Rates are calculated for [n] products that cost [price].'),
('en', 'base_rate', 'Base rate'),
('en', 'price_rate_not_set', 'Price rate was not set.'),
('en', 'receivers', 'Receivers'),
('en', 'notification', 'Notification'),
('en', 'owner_company', 'Storefront'),
('en', 'block_manager.brands_per_screen', 'Brands per screen'),
('en', 'block_manager.total_displayed_brands', 'Total amount of brands displayed'),
('en', 'add_all_destinations', 'Add all'),
('en', 'block_manager.manage_layout_in_tab_not_exist_location', '<p>This [entity] currently doesn''t have an associated layout page. That''s why it uses blocks from the default layout page.<br> If you''d like to edit blocks specifically for this [entity], then:</p><p><ol><li>Go to <b><a href="[link]">Design → Layouts</a></b></li><li>Add a layout page with <b>Dispatch:</b> <code>[dispatch_value]</code>.</li><li>Switch to the <b>[entity_tab]</b> tab and make sure that the layout page is enabled for this [entity].</li><li>Save your changes and return here.</li></ol></p>'),
('en', 'block_manager.manage_layout_in_tab_unavailable_by_object_id', '<p>This [entity] currently doesn''t have an associated layout page. That''s why it uses blocks from the default layout page.<br> If you''d like to edit blocks specifically for this [entity], then:</p><p><ol><li>Edit the <b><a href="[link]">[location_name]</a></b> layout page.</li><li>Switch to the [entity_tab] tab and make sure that the layout page is enabled for this [entity].</li><li>Save your changes and return here.</li></ol></p>'),
('en', 'block_manager.manage_layout_in_tab_unavailable', 'Sorry, you can''t edit blocks for this [entity]. If you''d like to do this, please contact the main administrator. Ask him or her to check the <b>Layouts</b> tab of this [entity] in their admin panel. That will give the main admin all the necessary information.'),
('en', 'block_manager.dynamic_entity_products', 'product'),
('en', 'block_manager.dynamic_entity_categories', 'category'),
('en', 'block_manager.dynamic_entity_pages', 'page'),
('en', 'payment_processors.category.checkout', 'Checkout'),
('en', 'payment_processors.category.gateway', 'Gateways'),
('en', 'payment_processors.category.russian', 'Russian payment methods'),
('en', 'add_in_all_realtime_shippings', 'Add in all realtime shipping methods'),
('en', 'event.system.realtime_shipping_error.name', 'Realtime shipping errors'),
('en', 'profile_field_contains_information', 'Сouldn''t change the field type: someone has already submitted data in this field.'),
('en', 'text_cannot_create_file_check_file', 'Сouldn''t create the file. Please try again or choose another file.'),
('en', 'error_profile_field_code_exists', 'A profile field with this code already exists. Please choose another code.'),
('en', 'can_not_add_file_type_profile_field', 'Sorry, this page doesn''t support fields with the "File" type, and they weren''t added.'),
('en', 'day_or_days', 'day(s)'),
('en', 'feature_already_in_use', 'Couldn''t delete the feature. It is already used by your or someone else''s products.'),
('en', 'feature_variants_already_in_use', 'Couldn''t delete some feature variants. They are already used by your or someone else''s products.'),
('en', 'stop_following_rules', 'Stop following rules'),
('en', 'exim_features', 'Features (Deprecated)'),
('en', 'exim_storefront_feature_name', 'Storefront feature name'),
('en', 'exim_reset_inventory_tooltip', 'This won''t affect the products that have the quantity specified in the imported file.'),
('en', 'thank_you', 'Thank you!'),
('en', 'text_review_and_reach_out_request', 'We''ll review your application and reach out to you via email soon.'),
('en', 'system_of_measurement', 'System of measurement'),
('en', 'imperial_units', 'Imperial (in, lb)'),
('en', 'metric_units', 'Metric (cm, kg)'),
('en', 'ship_dhl_account_country', 'Account country'),
('en', 'print_documents', 'Print documents'),
('en', 'change_to_status', 'Change to [status]'),
('en', 'invoice_pdf', 'Invoice (PDF)'),
('en', 'exim_import_detailed_image', 'Detailed image (Deprecated)'),
('en', 'settings.smtp_error', 'SMTP Error'),
('en', 'sync_data', 'Sync data'),
('en', 'never', 'Never'),
('en', 'nothing_sign', '&mdash;'),
('en', 'last_sync', 'Last sync'),
('en', 'log_file', 'Log file'),
('en', 'select_developer', 'Select developer'),
('en', 'popular_developer', 'Popular developer'),
('en', 'developers', 'Developers'),
('en', 'storefronts.manage_language_availability', 'Configure the languages available on this storefront'),
('en', 'storefronts.manage_currency_availability', 'Configure the currencies available on this storefront'),
('en', 'variant_with_name_already_exist', 'Couldn''t rename feature variant "[variant]". Reason: a variant with the new name already exists.'),
('en', 'delete_default_destination_notice', 'Couldn''t delete the default rate area. It must always exist.'),
('en', 'display', 'Display'),
('en', 'create_filters', 'Create filters'),
('en', 'text_n_filters_created', 'Filters created: [n].'),
('en', 'error_n_filters_already_exists', 'Some filters ([n]) already exist.'),
('en', 'bulk_product_features_warning', 'This change won''t affect some of the selected features, because they belong to a feature group. You can assign categories to an entire feature group.'),
('en', 'view_feature_groups', 'View feature groups'),
('en', 'show_on_storefront', 'Show on Storefront'),
('en', 'parent', 'Parent'),
('en', 'attempt_to_set_itself_or_a_own_child_as_its_parent_warning', 'The parent page wasn''t changed. Reason: can''t assign child page as a parent for its own parent.'),
('en', 'bulk_attempt_to_set_itself_or_a_own_child_as_its_parent_warning', 'The parent page of some of the selected pages wasn''t changed. Reason: can''t assign child page as a parent for its own parent.'),
('en', 'visit_marketplace', 'Visit the Add-on Market'),
('en', 'view_more_addons', 'View more add-ons'),
('en', 'manual_installation', 'Manual installation'),
('en', 'downloaded_addons', 'Downloaded add-ons ([n])'),
('en', 'upgrades', 'Upgrades ([n])'),
('en', 'addon_subscriptions', 'Subscriptions ([n])'),
('en', 'addon_type', 'Add-on type'),
('en', 'third_party_addons', 'Third-party add-ons'),
('en', 'unidentified', 'Unidentified'),
('en', 'without_rating', 'Without rating'),
('en', 'has_additional_pages', 'Has additional pages'),
('en', 'favorites', 'Favorites'),
('en', 'add_addon_to_favorites', 'Add add-on to favorites'),
('en', 'remove_addon_from_favorites', 'Remove add-on from favorites'),
('en', 'new_addon', 'New add-on'),
('en', 'install_date', 'Install date'),
('en', 'compatibility', 'Compatibility'),
('en', 'installed_date', 'Installed date'),
('en', 'what_is_new', 'What''s new'),
('en', 'where_access_addon', 'Where to access this add-on'),
('en', 'addon_is_compatible', 'This add-on version is compatible with your current [product] version.'),
('en', 'addon_required_version', 'The add-on requires [version] version'),
('en', 'version_information', 'Version information'),
('en', 'show_all_developer_addons', 'Show all developer add-ons'),
('en', 'developer_page', 'Developer page'),
('en', 'show_all_category_addons', 'Show all [category] add-ons'),
('en', 'addons.other_category', 'Other'),
('en', 'updates', 'Updates'),
('en', 'actual_version', 'Actual version'),
('en', 'installed_version', 'Installed version'),
('en', 'subscription', 'Subscription'),
('en', 'license', 'License'),
('en', 'addon_reviews', 'Reviews'),
('en', 'addon_has_admin_review', 'You have left a review of the add-on'),
('en', 'addon_status', 'Add-on status'),
('en', 'verified', 'Verified'),
('en', 'verified_developer', 'Verified developer'),
('en', 'unverified', 'Unverified'),
('en', 'addons.is_enjoying_addon', 'Enjoying add-on?'),
('en', 'addons.is_enjoying_addon_name', 'Enjoying [addon]?'),
('en', 'rating', 'Rating'),
('en', 'view_in_marketplace', 'View in CS-Cart Marketplace'),
('en', 'addon_id', 'Add-on ID'),
('en', 'latest_available_version', 'Latest available version'),
('en', 'license_expires', 'License expires'),
('en', 'unsupported_browser_notice', '<p>We have detected that the browser you are using is not fully supported by our Admin Panel. You can view this site using your current browser but it may not display properly, and you may not be able to fully use all features.</p><br><p>Admin Panel is best viewed using the following browsers:</p><br><ul><li>&ndash; <a href="http://www.mozilla.org/en-US/" target="_blank">Mozilla Firefox (latest version)</a></li><li>&ndash; <a href="https://www.google.com/intl/en/chrome/browser/" target="_blank">Google Chrome (latest version)</a></li><li>&ndash; <a href="https://www.microsoft.com/en-us/edge" target="_blank">Microsoft Edge (latest version)</a></li><li>&ndash; <a href="https://www.apple.com/safari/" target="_blank">Safari (latest version)</a></li></ul><br><p>Click on one of the links to download the browser of your choice. Once the download has completed, install the browser by running the setup program.</p><br><p>If you cannot upgrade your browser now, you can still access Admin Panel, but you may not be able to fully use all features.<br><br><a href="[url]">Continue</a></p>'),
('en', 'usergroup_must_have_privileges', 'Usergroup must have at least one privilege.'),
('en', 'saved_search.set_as_default', 'Set as default'),
('en', 'saved_search.set_as_non_default', 'Set as non-default'),
('en', 'saved_search.more_short', 'More'),
('en', 'saved_search.set_as_default_confirm', 'Saved search "[name]" will open by default instead of the full list of objects. Is that what you''d like?'),
('en', 'saved_search.set_as_non_default_confirm', 'The full list of objects will open by default instead of saved search "[name]". Is that what you''d like?'),
('en', 'exim_subtotal_discount', 'Subtotal discount'),
('en', 'storefront_languages_assigned', 'The "<a href="[url]">[name]</a>" storefront had no available languages configured. All languages has been made available for it.'),
('en', 'storefront_currencies_assigned', 'The "<a href="[url]">[name]</a>" storefront had no available currencies configured. Default currency has been made available for it.'),
('en', 'storefront_all_currencies_assigned', 'The "<a href="[url]">[name]</a>" storefront had no available currencies configured. All currencies has been made available for it.'),
('en', 'storefronts_for_language_absent', 'The <b>[name]</b> language had no storefronts selected. All storefronts has been made available for it.'),
('en', 'storefronts_for_currency_absent', 'The <b>[name]</b> currency had no storefronts selected. All storefronts has been made available for it.'),
('en', 'event.product.back_in_stock.name', 'Product is back in stock'),
('en', 'core_addon', 'CS-Cart'),
('en', 'text_menus_have_been_deleted', 'Menus have been deleted successfully.'),
('en', 'addon_added_to_favorites', 'Add-on added to your favorites'),
('en', 'addon_removed_from_favorites', 'Add-on removed from your favorites'),
('en', 'contact_the_developer', 'Contact the developer'),
('en', 'message_successfully_sent_to_developer', 'Message was successfully sent to [developer]'),
('en', 'delete_subscribers', 'Delete subscribers'),
('en', 'addons.error_while_sending_review', 'Your add-on review was not posted to marketplace. Please make sure that you acquire this add-on from CS-Cart Marketplace and try again later.'),
('en', 'addons.upgrade_to_product_version', 'Upgrade to [product] [version]'),
('en', 'addons.latest_version', 'Latest released version'),
('en', 'addons.latest_available_for_installation_version', 'Latest version available for installation'),
('en', 'product_availability', 'Product availability'),
('en', 'addons.text_thank_you_for_post', 'Thank you for your post'),
('en', 'addons.text_post_pended', 'Your post will be checked before it gets published.'),
('en', 'addons.your_account_doesnt_have_this_addon', 'You can not create a add-on review because you do not have this add-on purchased in your Marketplace account.'),
('en', 'addons.you_already_posted_review', 'You can not create a add review because you already have a review that requires premoderation'),
('en', 'addons.something_went_wrong', 'Something went wrong with your request. Please try again later.'),
('en', 'addons.your_message', 'Your message'),
('en', 'addons.not_installed', 'Not installed'),
('en', 'addons.install', 'Install'),
('en', 'addons.disabled', 'Disabled'),
('en', 'addons.activate', 'Activate'),
('en', 'addons.mve_ult_or_plus_required', '[product] Plus or Ultimate required'),
('en', 'addons.ult_required', '[product] Ultimate required'),
('en', 'addons.upgrade_available', 'Upgrade available'),
('en', 'addons.upgrades', 'Upgrades'),
('en', 'addons.error_at_sending_addon_review', 'Something went wrong at sending add-on review. Please try again later.'),
('en', 'unable_delete_storefront_orders_exists', 'Unable to delete this storefront because there are orders containing the products of this storefront in the store database. To delete the storefront, please delete all such orders first.'),
('en', 'state_field_required_only_for_countries_with_regions', 'The "State" field is required for all countries with states or provinces. If you don''t have states for the customer''s country, then the field will be required at checkout only if it is required in the customer''s profile.'),
('en', 'need_storefront_id', 'Storefront ID is required (the storefront_id param)'),
('en', 'addons.multiple_dependencies_required', 'The add-on cannot be installed because it depends on the following add-ons:<ul>[addon_list]</ul> Please install these add-ons first.'),
('en', 'products_are_not_selectable_for_context_menu', 'You can not select products that belong to another storefront.'),
('en', 'product_filters_are_not_selectable_for_context_menu', 'You can not select product filters that belong to another storefront.'),
('en', 'product_options_are_not_selectable_for_context_menu', 'You can not select product options that belong to another storefront'),
('en', 'product_features_are_not_selectable_for_context_menu', 'You can not select product features that belong to another storefront.'),
('en', 'product_feature_groups_are_not_selectable_for_context_menu', 'You can not select product feature groups that belong to another storefront.'),
('en', 'removing_default_language_from_storefront', 'Sorry, we couldn''t remove the [language_name] language from storefront [storefront_name]. To remove it, please go to <b>Settings → Appearance</b> and change the <b>Frontend default language</b> for storefront [storefront_name] first.|Sorry, we couldn''t remove the [language_name] language from storefronts: [storefront_name]. To remove it, please go to <b>Settings → Appearance</b> and change the <b>Frontend default language</b> for storefronts: [storefront_name] first.'),
('en', 'sw.vendor_panel', 'Vendor panel'),
('en', 'sw.easy_admin_panel_for_vendors', 'Easy admin panel for vendors'),
('en', 'sw.product_tabs_and_properties', 'Product tabs and properties'),
('en', 'sw.branding_and_colors', 'Branding and colors'),
('en', 'create_new_product', 'Create new product'),
('en', 'import_products', 'Import products'),
('en', 'thank_you_for_registration', 'Thank you for registration!'),
('en', 'helpdesk_account.helpdesk_account', 'Help Desk account'),
('en', 'helpdesk_account.sign_in', 'Sign in'),
('en', 'helpdesk_account.sign_out', 'Sign out'),
('en', 'helpdesk_account.sign_up', 'Sign up'),
('en', 'helpdesk_account.signed_in_message', 'Signed in'),
('en', 'helpdesk_account.signed_out_message', 'Sign in with your Help Desk account to access all CS-Cart services using single account.'),
('en', 'helpdesk_account.signed_out_message.marketplace', 'Sign in with your Help Desk account to get information about newest add-on versions from Marketplace, rate and review add-ons you''ve bought, and prolong your license subscriptions.'),
('en', 'helpdesk_account.signed_out_message.marketplace_single_addon', 'Sign in with your Help Desk account to get information about newest add-on versions from Marketplace, rate and review this add-on, and prolong your license subscription.'),
('en', 'helpdesk_account.request_permissions_from_store_owner_to_manage_addons', 'You need to have the according permission from the store owner to manage add-ons.'),
('en', 'helpdesk_account.request_permissions', 'Request permissions'),
('en', 'helpdesk_account.sign_in_to_manage_addons', 'Sign in with your Help Desk account to manage add-ons.'),
('en', 'link_from_layout', 'Link blocks from layout'),
('en', 'use_for_all_new_vendors', 'Use for all new vendors'),
('en', 'show_vendor_info_if_shipping_no_required', 'Show information about vendors whose products do not require shipping'),
('en', 'sw.money_split_automaticaly_descr.ru', 'This is achieved via YooMoney for marketplaces, so each vendor must have a YooMoney account. We''ll create a payment method for you. You''ll just need to configure it, and vendors will need to provide their account information.'),
('en', 'delete_my_account', 'Delete my account'),
('en', 'delete_my_account_description', '<p>We’ll deactivate your account and remove all your personal data from it. After that you won’t be able to sign in. However, you’ll be able to register a new account with the same email address in the future. Please note that we’ll need some time to process this request, so your account won’t be deactivated immediately. If you have any comments regarding your request, please leave them in the field below.</p>'),
('en', 'email_body_anonymization_request', '<p><a href="[user_profile_url]" target="_blank">[user]</a> with the email address [customer_email] has requested the removal of personal data with the following comment:</p> <p>[comment]</p> <p>Make sure that all business with the customer (orders, return requests, etc.) is concluded. Then <a href="[user_profile_url]" target="_blank">go to the customer page in the admin panel</a> and choose the "Anonymize" action. This will remove the customer''s personal data (including email, name, etc.) everywhere in the system, while retaining the data relevant to your business (ordered products, etc). The customer will be able to register a new account with the same email.</p>'),
('en', 'email_subject_anonymization_request', 'Personal Data Removal Request: [customer_email]'),
('en', 'user_action_request_fail', 'An error has occurred during the attempt to send your request. Please try again or send a message to the following email address: <a href="mailto:[email]">[email]</a>'),
('en', 'user_action_request_success', 'Your request has been sent successfully.'),
('en', 'anonymize', 'Anonymize'),
('en', 'text_anonymize_question', 'Once you anonymize someone, all their personal information will be replaced with randomly-generated data. This action can not be undone, unless you restore the database from a backup. Are you sure you want to proceed?'),
('en', 'check_other_sources_for_personal_data', '<p>Please note that anonymization doesn''t affect any backups and logs that you might have. If necessary, please do the following:</p><ol><li>Clear the logs under <b>Administration → Logs</b>.</li><li>Secure and delete the backups you might have under <b>Administration → Backup/Restore</b>.</li></ol>'),
('en', 'user_anonymized', 'User has been anonymized.'),
('en', 'license_error_wrong_edition_build', 'The license number your site is using doesn''t match the installed software. This may get the license suspended. Please <a href="[helpdesk_url]" target="_blank">contact us via Help Desk</a>, and we''ll be able to look into it.'),
('en', 'license_error_wrong_edition_build_entered', 'The license number you''ve entered is incorrect or doesn''t suit the product. If you''re sure that the license number is correct, please <a href="[helpdesk_url]" target="_blank">contact us via Help Desk</a>, and we''ll look into it.'),
('en', 'privileges.manage_admin_usergroups', 'Can manage admin user groups (only if managing customer user groups is allowed)'),
('en', 'privilege_groups.disable_sanitize_html', 'Use advanced HTML code in content'),
('en', 'event.system.helpdesk_process_message.name', 'Notifications from CS-Cart team'),
('en', 'category_template', 'Category template'),
('en', 'exim_error_incorrect_concrete_feature_type', 'Incorrect feature type ''[feature_type]'' of the ''[feature_name]'' product feature. The product feature was skipped.'),
('en', 'product_state_description.ult.free.free', '<p>You''re using CS-Cart Free. It has all the functionality to launch your own independent online store, free of charge. If you ever need the extended functionality of CS-Cart Standard or Ultimate — such as user groups, advanced product settings, multiple storefronts, and more — please contact us.</p>'),
('en', 'product_state_description.ult.free_ru.free', '<p>You''re using CS-Cart Free. It has all the functionality to launch your own independent online store, free of charge. If you ever need the extended functionality of CS-Cart Standard or Ultimate — such as user groups, advanced product settings, multiple storefronts, and more — please contact us.</p>'),
('en', 'contact_us', 'Contact us'),
('en', 'ultimate_or_storefront_license_required.ult.free', 'This action requires [product] Ultimate'),
('en', 'ultimate_or_storefront_license_required.ult.free_ru', 'This action requires [product] Ultimate'),
('en', 'max_storefronts_reached.ult.free', '<p>You have reached the limit of storefronts available for your license. To add another storefront, please upgrade to <a href="[ultimate_license_url]" target="_blank">[product] Ultimate</a>.</p>'),
('en', 'max_storefronts_reached.ult.free_ru', '<p>You have reached the limit of storefronts available for your license. To add another storefront, please upgrade to <a href="[ultimate_license_url]" target="_blank">[product] Ultimate</a>.</p>'),
('en', 'helpdesk_account.activate_free_license_message', 'Create an account in our Help Desk system. It will allow you to upgrade your store, contact our Customer Care team, and get add-ons (both paid and free) from the CS-Cart Marketplace for add-ons and themes.'),
('en', 'helpdesk_account.activate_free_license_short_message', 'Create an account in our Help Desk to upgrade your store, receive support, and get free or paid add-ons from our Add-on Market.'),
('en', 'helpdesk_account.activate_free_license_message_send', 'An activation link for your free CS-Cart license was sent to the email: [email]'),
('en', 'no_items_for_marketplace_administrator', 'No items to show for marketplace administrator. Try to check the section as a vendor.'),
('en', 'sync_data_update_template_not_found', 'No template found for this sync provider. Please make sure the "update_template" field is filled in the "sync_data" schema.'),
('en', 'disabling_primary_currency_disallowed', 'Currency cannot be disabled as it is primary. Make a different currency primary first.'),
('en', 'product_env.released_n_years_ago', 'released <u title="[month] [year]">[n] year ago</u>|released <u title="[month] [year]">[n] years ago</u>'),
('en', 'product_env.released_n_months_ago', 'released <u title="[month] [year]">[n] month ago</u>|released <u title="[month] [year]">[n] months ago</u>'),
('en', 'product_env.released_this_month', 'released this month'),
('en', 'product_env.current_version', 'Current version'),
('en', 'product_env.available_upgrade', 'Available upgrade'),
('en', 'product_env.latest_version', 'Latest version'),
('en', 'product_env.now_running', 'You are using [release_info]'),
('en', 'product_env.can_upgrade_store', 'You can upgrade your store to [release_info]'),
('en', 'product_env.latest_product_version', 'The latest version is [release_info]'),
('en', 'product_env.dont_miss_features', 'Don''t miss all the new features!'),
('en', 'product_env.upgrade_to_latest_version', 'Upgrade to the latest version'),
('en', 'product_env.up_to_date', 'You are up to date'),
('en', 'notification_settings.profile.receivers', 'Users whose profile was changed'),
('en', 'dashboard.analytics_section_title', 'Analytics'),
('en', 'dashboard.view_reports', 'View reports'),
('en', 'dashboard.view_report', 'View report'),
('en', 'dashboard.view_all', 'View all'),
('en', 'dashboard.view', 'View'),
('en', 'dashboard.analytics_card.sales', 'Sales'),
('en', 'dashboard.analytics_card.unlimited', 'Unlimited'),
('en', 'dashboard.analytics_card.top_products', 'Top products'),
('en', 'dashboard.analytics_card.active_products', 'Active products'),
('en', 'dashboard.analytics_card.view_products', 'View products'),
('en', 'dashboard.analytics_card.products_details', 'Products details'),
('en', 'dashboard.analytics_card.out_of_stock', 'Out of stock'),
('en', 'dashboard.analytics_card.recent_orders', 'Recent orders'),
('en', 'dashboard.analytics_card.view_orders', 'View orders'),
('en', 'dashboard.analytics_card.average_order_value', 'Average order value'),
('en', 'dashboard.analytics_card.orders', 'Orders'),
('en', 'dashboard.analytics_card.activity', 'Activity'),
('en', 'dashboard.analytics_card.vendors_with_sales', 'Vendors with sales'),
('en', 'dashboard.analytics_card.view_stores', 'View storefronts'),
('en', 'dashboard.analytics_card.vendor_activity', 'Vendor activity');
INSERT INTO `[[dbprefix]]language_values` VALUES
('en', 'dashboard.analytics_card.new_vendors', 'New vendors'),
('en', 'dashboard.analytics_card.vendors_with_new_products', 'Vendors with new products'),
('en', 'dashboard.analytics_card.vendors_not_logged', 'Vendors who haven''t signed in'),
('en', 'dashboard.analytics_card.new_products', 'New products'),
('en', 'dashboard.analytics_card.stores', 'Storefronts'),
('en', 'dashboard.analytics_card.registered_customers', 'Registered customers'),
('en', 'dashboard.analytics_card.view_customers', 'View customers'),
('en', 'custom_blocks.sections.onboarding_title', 'Onboarding Guide'),
('en', 'custom_blocks.create_block', 'Create block'),
('en', 'custom_blocks.edit_block', 'Edit block'),
('en', 'custom_blocks.name', 'Name'),
('en', 'custom_blocks.url', 'URL'),
('en', 'custom_blocks.url.hint', 'A link can lead to an external site (like https://example.com) or somewhere in the vendor admin panel (use the part after "?dispatch=" from the address bar of your browser).'),
('en', 'custom_blocks.first_menu_level_url.hint', 'If you enter a link, then the menu item will lead to the specified page, and won''t open the menu section. A link can lead to an external site (like https://example.com) or somewhere in the vendor admin panel (use the part after "?dispatch=" from the address bar of your browser).'),
('en', 'custom_blocks.content', 'Content'),
('en', 'custom_blocks.use_this_space', 'Use this space for announcements that all your vendors will see. You can write a plain text or use HTML and CSS for customization.'),
('en', 'custom_blocks.dismissed_by_vendor', 'This block was dismissed by this vendor. Other vendors may still see it.'),
('en', 'custom_menu.section_has_one_visible_item', 'This section has only one visible menu item. That item will appear instead of the section.'),
('en', 'custom_menu.item_hidden_due_to_privileges', 'This vendor can''t see this menu item due to privileges. Other vendors may still see it.'),
('en', 'dashboard.todo.has_products_without_category', '<strong>[n] product</strong> doesn''t have a category. Please assign it a category, or customers might not see it.|<strong>[n] products</strong> don''t have a category. Please assign them a category, or customers might not see them.'),
('en', 'dashboard.todo.upgrade_center_core_upgrade_available', 'A new version of CS-Cart is available.'),
('en', 'dashboard.todo.upgrade_center_addons_upgrade_available', 'New versions are available for some of your add-ons.'),
('en', 'addon_market', 'Add-on Market'),
('en', 'addon_market_n', 'Add-on Market ([n])'),
('en', 'downloaded_add_ons', 'Downloaded add-ons'),
('en', 'addons_developers', 'Developers'),
('en', 'safe_smarty_block', 'HTML block with Smarty support'),
('en', 'block_safe_smarty_block', 'HTML block with Smarty support'),
('en', 'block_safe_smarty_block_description', 'Any HTML/Smarty content'),
('en', 'block_smarty_block_deprecated_notice', 'This block type is deprecated for security reasons. The block still works, but its content can''t be edited. To edit the content, create a new "HTML block with Smarty support" and copy the content from this block to the new one. After that, check if the new block works properly on the storefront—the code that is potentially dangerous might not work.'),
('en', 'themes.google_fonts_was_replaced', 'The google fonts of your styles has been replaced successfully'),
('en', 'themes.google_fonts_replace_error', 'Couldn''t replace google fonts of your styles'),
('en', 'disabled_product_not_added_to_cart', 'This product is disabled and cannot be added to the cart'),
('en', 'ship_ups_access_token', 'UPS App access token'),
('en', 'ship_ups_access_token_expiration', 'UPS App access token expiration'),
('en', 'ship_ups_client_id', 'UPS App client ID'),
('en', 'ship_ups_client_secret', 'UPS App client secret'),
('en', 'authorize', 'Authorize'),
('en', 'text_hidpi_support_enabled', 'HiDPI support is enabled'),
('en', 'hidpi.upload_high_res_image', 'I’m uploading a HiDPI image.'),
('en', 'hidpi.upload_high_res_image.tooltip', 'If this checkbox is ticked, the source image will be displayed two times downscaled. This setting only affects the displaying of the source image and not its thumbnail. If you want an image to be displayed in the original size, untick this checkbox.'),
('en', 'hidpi.restore_images', 'Image restoration'),
('en', 'hidpi.text_restore_images', 'The previous version of the HiDPI display support add-on shrank the uploaded images. There’s no need for that now. But to make your images look nice and sharp you need to click Restore.'),
('en', 'hidpi.restore_btn', 'Restore'),
('en', 'hidpi.warning_restore_images', '<strong>Attention!</strong> This procedure is non-reversible: when you revert the upgrade, the image restoration manipulations will not be reverted. So, please make sure to perform a backup. The procedure can take some time—it depends on the number of images in your store.'),
('en', 'hidpi.notice.images_were_not_restored', 'Some of the old images in your store are still low-quality. To use the highest quality possible, please <a href="[convert_url]">restore high-quality images</a>. The process is automatic.'),
('en', 'facebook', 'Facebook'),
('en', 'facebook_obj_type', 'Facebook object type'),
('en', 'fb_activities', 'Activities'),
('en', 'fb_businesses', 'Businesses'),
('en', 'fb_groups', 'Groups'),
('en', 'fb_organizations', 'Organizations'),
('en', 'fb_people', 'People'),
('en', 'fb_places', 'Places'),
('en', 'fb_products_entertainment', 'Products and Entertainment'),
('en', 'fb_websites', 'Websites'),
('en', 'text_recommendation_notes', 'Your friend has recommended this page to you. Please follow the link:'),
('en', 'sb_share', 'Share'),
('en', 'social_buttons.facebook_cookie_title', 'Facebook'),
('en', 'social_buttons.facebook_cookie_description', 'Facebook cookies enable Facebook-related functionality, such as Facebook button on the product page. Here is <a href="https://www.facebook.com/about/privacy/previous" target="_blank">Facebook privacy policy</a>.'),
('en', 'social_buttons.pinterest_cookie_title', 'Pinterest'),
('en', 'social_buttons.pinterest_cookie_description', 'Pinterest cookies enable Pinterest-related functionality, such as Pinterest button on the product page. Here is <a href="https://policy.pinterest.com/en/privacy-policy" target="_blank">Pinterest privacy policy</a>.'),
('en', 'social_buttons.twitter_cookie_title', 'Twitter'),
('en', 'social_buttons.twitter_cookie_description', 'Twitter cookies enable Twitter-related functionality, such as the Twitter button on the product page. Here is <a href="https://twitter.com/en/privacy" target="_blank">Twitter privacy policy</a>.'),
('en', 'social_buttons.vkontakte_cookie_title', 'VK'),
('en', 'social_buttons.vkontakte_cookie_description', 'VK cookies enable VK-related functionality, such as VK button on the product page. Here is <a href="https://m.vk.com/privacy" target="_blank">VK privacy policy</a>.'),
('en', 'social_buttons.yandex_cookie_title', 'Yandex'),
('en', 'social_buttons.yandex_cookie_description', 'Yandex helps us display the buttons of multiple social networks (for example, on product pages). Here is <a href="https://yandex.com/legal/confidential/" target="_blank">Yandex privacy policy</a>.'),
('en', 'paypal_checkout.paypal_checkout', 'PayPal Complete Payments'),
('en', 'paypal_checkout.paypal', 'PayPal'),
('en', 'paypal_checkout.client_id', 'App Client ID'),
('en', 'paypal_checkout.secret', 'App Secret'),
('en', 'paypal_checkout.order_id', 'Order ID in PayPal'),
('en', 'paypal_checkout.capture_id', 'Capture ID in PayPal'),
('en', 'paypal_checkout.webhook_help_message', 'Specify the following URL when configuring a webhook for your REST application:'),
('en', 'paypal_checkout.webhook', 'PayPal Complete Payments webhook: [payload]'),
('en', 'paypal_checkout.settings.account', 'Account settings'),
('en', 'paypal_checkout.settings.enable_funding', 'Funding sources to show on checkout'),
('en', 'paypal_checkout.funding.card', 'Credit or debit cards'),
('en', 'paypal_checkout.funding.credit', 'PayPal Credit'),
('en', 'paypal_checkout.funding.venmo', 'Venmo'),
('en', 'paypal_checkout.funding.sepa', 'SEPA-Lastschrift'),
('en', 'paypal_checkout.funding.bancontact', 'Bancontact'),
('en', 'paypal_checkout.funding.eps', 'eps'),
('en', 'paypal_checkout.funding.giropay', 'giropay'),
('en', 'paypal_checkout.funding.ideal', 'iDEAL'),
('en', 'paypal_checkout.funding.mybank', 'MyBank'),
('en', 'paypal_checkout.funding.p24', 'Przelewy24'),
('en', 'paypal_checkout.funding.sofort', 'Sofort'),
('en', 'paypal_checkout.settings.enable_cards', 'Cards to show on checkout'),
('en', 'paypal_checkout.card.visa', 'Visa'),
('en', 'paypal_checkout.card.mastercard', 'Mastercard'),
('en', 'paypal_checkout.card.amex', 'American Express'),
('en', 'paypal_checkout.card.discover', 'Discover'),
('en', 'paypal_checkout.card.jcb', 'JCB'),
('en', 'paypal_checkout.card.elo', 'Elo'),
('en', 'paypal_checkout.card.hiper', 'Hiper'),
('en', 'paypal_checkout.debug_id', 'PayPal Debug ID'),
('en', 'paypal_checkout.paypal_cookie_title', 'PayPal'),
('en', 'paypal_checkout.paypal_cookie_description', 'PayPal is a payment provider. It allows us to accept payments, if you choose a payment method powered by PayPal. Here is <a href="https://www.paypal.com/us/webapps/mpp/ua/privacy-full" target="_blank">PayPal privacy statement</a>.'),
('en', 'paypal_checkout.funding.paylater', 'PayPal Pay Later'),
('en', 'paypal_checkout.funding.mercadopago', 'Mercado Pago'),
('en', 'paypal_checkout.funding.blik', 'BLIK'),
('en', 'paypal_checkout.settings.style', 'Button appearance'),
('en', 'paypal_checkout.style.shape', 'Shape'),
('en', 'paypal_checkout.shape.pill', 'Pill'),
('en', 'paypal_checkout.shape.rect', 'Rectangular'),
('en', 'paypal_checkout.style.color', 'Color'),
('en', 'paypal_checkout.color.gold', 'Gold'),
('en', 'paypal_checkout.color.blue', 'Blue'),
('en', 'paypal_checkout.color.silver', 'Silver'),
('en', 'paypal_checkout.color.black', 'Black'),
('en', 'paypal_checkout.style.height', 'Height'),
('en', 'onboarding_guide.guide_title', 'Welcome to your marketplace!<br>Get ready to receive your first order'),
('en', 'onboarding_guide.sb_guide_title', 'Welcome to your online store!<br>Get ready to receive your first order'),
('en', 'onboarding_guide.completed_steps_progress', '[completed] out of [total] complete'),
('en', 'onboarding_guide.dismiss', 'Dismiss'),
('en', 'onboarding_guide.step_close', 'Close'),
('en', 'onboarding_guide.step_complete', 'Complete'),
('en', 'onboarding_guide.explore_interface_title', 'Explore the Multi-Vendor No-Code interface'),
('en', 'onboarding_guide.explore_interface_description', 'Discover how to effortlessly launch your marketplace in just 5 minutes. Learn the ins and outs of the intuitive interface and get ready to dive into the world of hassle-free marketplace creation.'),
('en', 'onboarding_guide.personalize_your_marketplace_title', 'Personalize your marketplace'),
('en', 'onboarding_guide.sb_personalize_your_marketplace_title', 'Personalize your online store'),
('en', 'onboarding_guide.personalize_your_marketplace_description', 'Choose the style of your marketplace. Provide your contact information for customers and sellers.'),
('en', 'onboarding_guide.sb_personalize_your_marketplace_description', 'Choose the style of your online store. Provide your contact information for customers.'),
('en', 'onboarding_guide.make_changes_on_the_fly_title', 'Make changes on the fly'),
('en', 'onboarding_guide.make_changes_on_the_fly_description', 'Use the no-code tools to tailor the marketplace to your needs. Edit any texts; rearrange the blocks; change the colors, fonts, and style. When you see the storefront as an admin, you can use these tools any time.'),
('en', 'onboarding_guide.sb_make_changes_on_the_fly_description', 'Use the no-code tools to tailor the online store to your needs. Edit any texts; rearrange the blocks; change the colors, fonts, and style. When you see the storefront as an admin, you can use these tools any time.'),
('en', 'onboarding_guide.theme_and_logo', 'Theme & logo'),
('en', 'onboarding_guide.business_details', 'Business details'),
('en', 'onboarding_guide.languages_and_currency', 'Languages & Currency'),
('en', 'onboarding_guide.select_theme', 'Select theme'),
('en', 'onboarding_guide.current_theme', 'Current theme'),
('en', 'onboarding_guide.custom_theme', 'Custom theme'),
('en', 'onboarding_guide.upload_logo', 'Upload logo'),
('en', 'onboarding_guide.activate', 'Activate'),
('en', 'onboarding_guide.next', 'Next'),
('en', 'onboarding_guide.back', 'Back'),
('en', 'onboarding_guide.save', 'Save'),
('en', 'onboarding_guide.edit_colors', 'Edit colors'),
('en', 'onboarding_guide.modify_colors_fonts_backgrounds', 'Modify colors, fonts, and backgrounds'),
('en', 'onboarding_guide.edit_texts', 'Edit or translate any texts'),
('en', 'onboarding_guide.edit_blocks', 'Fine-tune page layouts'),
('en', 'onboarding_guide.configure_payment_options', 'Set up payments'),
('en', 'onboarding_guide.select_payment_options', 'Choose how you plan to accept payments. Select one of the following scenarios:'),
('en', 'onboarding_guide.single_payment_with_automatic_split', 'Multi-party payment (automatic disbursements)'),
('en', 'onboarding_guide.single_payment_with_automatic_split_description', 'There are special payment methods for marketplaces: PayPal Complete Payments (Multiparty) and Stripe Connect. A customer still makes one payment for all the products; the payment method splits the money between you and sellers automatically. Note that sellers will need accounts with PayPal or Stripe as well.'),
('en', 'onboarding_guide.single_rus_payment_with_automatic_split_description', 'There are special payment methods for marketplaces: YooKassa For Marketplaces and Tinkoff Multiparty. A customer still makes one payment for all the products; the payment method splits the money between you and sellers automatically. Note that sellers will need accounts with YooKassa or Tinkoff as well.'),
('en', 'onboarding_guide.single_payment_to_you', 'Single payment to the marketplace'),
('en', 'onboarding_guide.single_payment_to_you_description', 'A customer makes one payment for all the products in the cart. The money ends up on your account, with the record of what you own to each seller. You periodically distribute the money between sellers.'),
('en', 'onboarding_guide.separate_payments_to_sellers', 'Separate payments to sellers'),
('en', 'onboarding_guide.separate_payments_to_sellers_description', 'A customer pays to each seller separately. It becomes the seller’s responsibility to pay the commission to you (we have ways for that). Sellers will be able to set up their own shipping methods and promotions.'),
('en', 'onboarding_guide.configure_payment_methods', 'Configure payment methods'),
('en', 'onboarding_guide.configure_payment_methods_description', 'CS-Cart allows you to set up various payment methods; most of them automatically process the full up-front payment. But for now, let’s set up "Cash on Delivery" just to see how it works.'),
('en', 'onboarding_guide.view_checkout_page', 'View checkout page'),
('en', 'onboarding_guide.view_checkout_page_description', 'Once configured, your payment method will appear at the checkout page:'),
('en', 'onboarding_guide.missing_products', 'Missing products'),
('en', 'onboarding_guide.create_at_least_one_product_to_proceed_to_checkout', 'Create at least one product to proceed to checkout'),
('en', 'onboarding_guide.manage_sellers', 'Manage sellers'),
('en', 'onboarding_guide.create_one_vendor', 'Add a seller'),
('en', 'onboarding_guide.create_vendor_description', 'Sellers—referred to as "vendors" in the admin panel—are essential for a marketplace. They provide products and services to customers. A seller can create an account themselves, or you can do it for them in the admin panel. Let’s add one seller via the admin panel.'),
('en', 'onboarding_guide.view_storefront', 'See sellers on the storefront'),
('en', 'onboarding_guide.view_invoice', 'View invoice'),
('en', 'onboarding_guide.logos_updated', 'Theme and email logos updated'),
('en', 'onboarding_guide.set_default_currency', 'Set default currency'),
('en', 'onboarding_guide.manage_currencies', 'Manage currencies'),
('en', 'onboarding_guide.set_default_languages', 'Set default languages'),
('en', 'onboarding_guide.manage_languages', 'Manage languages'),
('en', 'onboarding_guide.preview_an_email', 'Preview an email'),
('en', 'onboarding_guide.preview_an_email_description', 'Once you’re done, see how your data appears in an email to the new sellers who register at your marketplace.'),
('en', 'onboarding_guide.sb_preview_an_email_description', 'Once you’re done, see how your data appears in an email to the newly-registered customers.'),
('en', 'onboarding_guide.customize_vendor_panel_design', 'Customize seller panel'),
('en', 'onboarding_guide.edit_vendor_panel_style', 'Sellers work with their own dedicated control panel. You can make it look the way you need. Set its colors, edit the menu, add blocks with info to the seller''s dashboard.'),
('en', 'onboarding_guide.edit_structure', 'Edit menus and onboarding'),
('en', 'onboarding_guide.manage_products', 'Manage products'),
('en', 'onboarding_guide.manage_products_description', 'You as the marketplace owner can control all products sold on your platform. But sellers manage products through their own dashboard. See how they can add products one by one or in bulk.'),
('en', 'onboarding_guide.sb_manage_products_description', 'Products are how your online store makes money; they include commodities, services, or anything else offered for a price. You can add products one by one or in bulk.'),
('en', 'onboarding_guide.add_one_product', 'Add one product'),
('en', 'onboarding_guide.import_csv_or_xml', 'Import CSV or XML'),
('en', 'onboarding_guide.view_product_page', 'View the latest added product'),
('en', 'onboarding_guide.premoderation', 'If you do not see the created product on the storefront, you may have the <b>Vendor data premoderation</b> module enabled'),
('en', 'onboarding_guide.view_product_page_description', 'See your new products on the storefront.'),
('en', 'onboarding_guide.preview_seller_onboarding', 'Preview seller onboarding'),
('en', 'onboarding_guide.walk_the_seller_path', 'Walk the seller path'),
('en', 'onboarding_guide.customize_onboarding_process', 'Prospective sellers can request to join your marketplace on their own. See for yourself how that process works: the information they provide, the emails they receive, etc. You can adjust all of it, or even make your marketplace invite-only.'),
('en', 'onboarding_guide.set_up_commissions_and_fees', 'Configure commissions and fees'),
('en', 'onboarding_guide.set_up_seller_plans', 'Set up seller plans'),
('en', 'onboarding_guide.set_up_seller_plans_description', 'A marketplace usually earns you money from monthly fees and/or commissions from sales. Seller plans let you set the size and frequency of those payments.'),
('en', 'onboarding_guide.view_seller_plans', 'Preview seller plans'),
('en', 'onboarding_guide.view_seller_plans_description', 'See how your configured seller plans appear to your prospective sellers on the storefront.'),
('en', 'onboarding_guide.reset_onboarding', 'Reset onboarding'),
('en', 'onboarding_guide.reset', 'Reset'),
('en', 'onboarding_guide.configure_shippings_title', 'Set up shipping'),
('en', 'onboarding_guide.configure_shippings_description', 'CS-Cart provides your customers with shipping rates depending on the customer''s address and order. You can set the rules for these rates yourself, or receive rates in real time from shipping companies like UPS or DHL. You can also make shipping methods available in some locations and unavailable in others.'),
('en', 'onboarding_guide.configure_shippings_label', 'Let''s set up a shipping method called "Pickup from store" to see how it works.'),
('en', 'onboarding_guide.configure_shippings', 'Configure shipping methods'),
('en', 'help_center.help', 'Help'),
('en', 'help_center.help_center', 'Help Center'),
('en', 'help_center.growth_center', 'Growth center'),
('en', 'help_center.loading', 'Loading...'),
('en', 'help_center.no_data_relevant', 'Relevant information is not available for this section.'),
('en', 'help_center.no_data', 'Information is not available for this section.'),
('en', 'help_center.see_all_n_results', 'See all [n] results...'),
('en', 'help_center.customer_care', 'Customer Care'),
('en', 'help_center.ask', 'Ask us a question'),
('en', 'help_center.customer_care.view_all_tickets', 'View all tickets'),
('en', 'help_center.customer_care.all_tickets', 'All tickets'),
('en', 'help_center.customer_care.no_support_tickets', 'No support tickets found.'),
('en', 'help_center.customer_care.submit_ticket', 'Submit a ticket'),
('en', 'help_center.customer_care.service_unavailable', 'Your Customer Care subscription is not active'),
('en', 'help_center.customer_care.service_unavailable_description', 'Prolong the subscription to keep receiving support.'),
('en', 'help_center.customer_care.prolong_subscription', 'Prolong subscription'),
('en', 'help_center.customer_care.sign_in_text', 'Sign in with your Help Desk account <br>to contact Customer Care and see your latest tickets.'),
('en', 'help_center.customer_care.status.resolved', 'Resolved'),
('en', 'help_center.customer_care.status.open', 'Open'),
('en', 'help_center.customer_care.few_tickets_require_your_attention', 'A few tickets from Customer Care team require your attention. <a href="[url]" target="[target]">Click here to view tickets</a>'),
('en', 'sign_in_to_enter_tags', 'Sign in to enter tags'),
('en', 'tag_cloud', 'Tag cloud'),
('en', 'tags', 'Tags'),
('en', 'block_tags', 'Tags'),
('en', 'block_tags_description', 'Product tags'),
('en', 'addons.tags.add_a_tag', 'add a tag'),
('en', 'items_marked_by_tag', 'Items marked by the "[tag]" tag:'),
('en', 'tag', 'Tag'),
('en', 'add_tag', 'Add tag'),
('en', 'n_tags', '[n] tag|[n] tags'),
('en', 'rss_feed', 'RSS feed'),
('en', 'feed_title', 'Feed title'),
('en', 'feed_description', 'Feed description'),
('en', 'rss_sort_by', 'Sort items by'),
('en', 'rss_display_sku', 'Display SKU'),
('en', 'rss_display_image', 'Display image'),
('en', 'rss_display_price', 'Display gross price'),
('en', 'rss_display_original_price', 'Display net price'),
('en', 'rss_display_add_to_cart', 'Display add to cart button'),
('en', 'rss_created', 'Created'),
('en', 'rss_updated', 'Updated'),
('en', 'block_rss_feed', 'RSS feed'),
('en', 'block_rss_feed_description', 'RSS feed subscription icon'),
('en', 'addons.rss_feed.icon', 'RSS feed subscription icon'),
('en', 'news_plain', 'Plain'),
('en', 'text_signup_for_subscriptions', 'Sign up for our newsletters!'),
('en', 'tmpl_subscription', 'Newsletters: subscription form'),
('en', 'unsubscribe_link', 'Unsubscribe link'),
('en', 'ne_add_subscribers_from_users', 'Add subscribers from the list of users'),
('en', 'ne_warning_subscr_email_exists', '<b>[email]</b> is already in the subscribers list'),
('en', 'warning_subscribers_import', 'Some mailing lists from the input file could not be found in the database. Certain imported subscribers will be left unassigned.'),
('en', 'subscribers_menu_item_text', 'Subscribers'),
('en', 'block_mailing_lists', 'Newsletter subscription'),
('en', 'block_mailing_lists_description', 'Email field for newsletter subscription'),
('en', 'block_lite_checkout_newsletters', 'Checkout: Newsletters'),
('en', 'block_lite_checkout_newsletters_description', 'Ability to sign up for newsletters'),
('en', 'privileges.view_newsletters', 'Can view'),
('en', 'privileges.manage_newsletters', 'Can edit'),
('en', 'privilege_groups.newsletters', 'Newsletters'),
('en', 'warning_newsletter_no_recipients', 'Newsletter hasn''t been sent because no recipients were found matching the selected criteria.'),
('en', 'text_newsletter_sent', 'The newsletter(s) have been sent successfully.'),
('en', 'email_cannot_be_empty', 'E-mail cannot be empty'),
('en', 'sending_email_to', 'Sending email to [email]...'),
('en', 'text_subscriber_added', 'Your e-mail has been successfully added to our free e-mail updates list'),
('en', 'error_email_already_subscribed', 'Your e-mail is already subscribed.'),
('en', 'text_subscriber_removed', 'Your e-mail has been successfully removed from our free e-mail updates list'),
('en', 'text_subscriber_activated', 'Your email has been successfully activated'),
('en', 'link_message_for_test_letter', 'The link will be displayed in a live newsletter'),
('en', 'newsletters', 'Newsletters'),
('en', 'autoresponders', 'Autoresponders'),
('en', 'campaigns', 'Campaigns'),
('en', 'sent', 'Sent'),
('en', 'subscribers_num', 'Number of subscribers'),
('en', 'editing_mailing_list', 'Editing mailing list'),
('en', 'from_name', 'From name'),
('en', 'from_email', 'From email'),
('en', 'reply_to', 'Reply to'),
('en', 'register_autoresponder', 'Confirmation email'),
('en', 'no_autoresponder', 'No autoresponder'),
('en', 'newsletters.autoresponder_used_in_mailing_list', 'You are trying to change status of the autoresponder which is used in one of the mailing lists as a confirmation email. Please check and update the lists on <a target="_blank" href="[link]">this page</a>.'),
('en', 'show_on_checkout', 'Show at checkout'),
('en', 'hide_on_checkout', 'Hide at checkout'),
('en', 'addons.newsletters.show_on_registration_and_profile', 'Show on the Registration and Profile Details pages'),
('en', 'addons.newsletters.hide_on_registration_and_profile', 'Hide on the Registration and Profile Details pages'),
('en', 'show_on_separate_page', 'Show on separate page'),
('en', 'campaign_stats', 'Campaign statistics'),
('en', 'add_campaign', 'Add campaign'),
('en', 'new_campaign', 'New campaign'),
('en', 'newsletter_templates', 'Newsletter templates'),
('en', 'newsletter_autoresponders', 'Newsletter autoresponders'),
('en', 'add_newsletter', 'Add newsletter'),
('en', 'add_template', 'Add template'),
('en', 'add_autoresponder', 'Add autoresponder'),
('en', 'more_subjects', 'Random subjects (one per line)'),
('en', 'body_html', 'HTML body'),
('en', 'no_template', 'No template'),
('en', 'load', 'Load'),
('en', 'campaign', 'Campaign'),
('en', 'send_to', 'Send to'),
('en', 'add_recipients_from_users', 'Add recipients from users'),
('en', 'customers_with_abandoned', 'Customers with abandoned'),
('en', 'cart_or_wishlist', 'Cart or Wishlist'),
('en', 'which_is', 'which is'),
('en', 'days_old', 'days old'),
('en', 'send_to_test_email', 'Send to test email'),
('en', 'save_and_send', 'Save and send'),
('en', 'newsletter', 'Newsletter'),
('en', 'newsletter_template', 'Newsletter template'),
('en', 'newsletter_autoresponder', 'Newsletter autoresponder'),
('en', 'mailing_list', 'Mailing list'),
('en', 'confirmed', 'Confirmed'),
('en', 'subscribed_to', 'Subscribed to [num] lists'),
('en', 'subscribed', 'Subscribed'),
('en', 'text_success_subscription', 'You have been successfully subscribed to our free e-mail updates and promotions!'),
('en', 'text_unsubscribe_instructions', 'We respect your privacy and do not send unsolicited e-mail to users who have not requested correspondence. You have received this e-mail because you requested to receive our free updates and promotions.<br /><br /> If you wish to unsubscribe, please follow the link below:'),
('en', 'updates_subscription', 'updates and promotions subscription'),
('en', 'ult_shared_with', 'Shared with:'),
('en', 'tt_addons_newsletters_views_mailing_lists_update_from_email', 'Email of a sender.'),
('en', 'tt_addons_newsletters_views_mailing_lists_update_from_name', 'Name of a sender (e.g. company name).'),
('en', 'tt_addons_newsletters_views_mailing_lists_update_reply_to', 'Email to send replies to.'),
('en', 'tt_addons_newsletters_views_newsletters_update_more_subjects', 'If several subjects are specified, email subject is randomly picked from this list.'),
('en', 'tt_addons_newsletters_views_newsletters_update_users', 'If the message text contains the unsubscribe link, it will be empty for these users.'),
('en', 'add_mailing_lists', 'Add mailing list'),
('en', 'manage_subscribers', 'Manage subscribers'),
('en', 'new_mailing_lists', 'New mailing list'),
('en', 'newsletters.new_subscribers', 'New subscribers'),
('en', 'subscribers_promo_subject', 'Thank you for subscribing! Use the coupon code [coupon] in our special offer "[promotion]".'),
('en', 'subscribers_no_promo', 'No promotion'),
('en', 'promotion_cond_subscribed', 'Customer is subscribed'),
('en', 'addons.newsletters.email_exists_in_list', '<b>[email]</b> is already in the mailing list'),
('en', 'email_template.newsletters_newsletter', 'Newsletter'),
('en', 'email_template.newsletters_promotion', 'Newsletters: promotion'),
('en', 'activation_key', 'Activation key'),
('en', 'unsubscribe_key', 'Unsubscribe key'),
('en', 'subscribers_date', 'Subscribers date'),
('en', 'mailing_list_date', 'Mailing list date'),
('en', 'gdpr_newsletters', 'Personal data from newsletters'),
('en', 'newsletters.subscribe_to_newsletters', 'Newsletters: Subscribe to newsletters'),
('en', 'newsletters.agreement_text_short_subscribe_to_newsletters', 'I agree to have my personal data <u>processed as follows</u> and I want to subscribe for the following newsletters:'),
('en', 'newsletters.agreement_text_full_subscribe_to_newsletters', '<p>When you sign up for a specific newsletter, we ([company]) add your email address to a corresponding mailing list. While it is there, we know that we can contact you by email regarding that topic.</p> <p>You can always have your email address removed from our mailing lists. There are multiple ways to do it:</p><ul> <li>Once your account is registered, just sign in and unsubscribe from newsletters in profile settings.</li> <li>Use the “Unsubscribe” link in our newsletters that you receive.</li> <li>Send an email to [email].</li> </ul> <p>We may use a third-party email service (MailChimp and/or Mad Mimi) to send newsletters. Some members of our staff can view mailing lists with email addresses. That way they’ll be able to remove your email address from the mailing list, should you request us to do so.</p> <p>Please note that mailing lists are independent from each other. If you decide not to receive newsletters at all, you’ll have to unsubscribe from all the mailing lists. Even if you do that, you’ll still receive account-related emails (such as order status notifications, password reset emails, and more). It is essential for operating an online store.</p> <p>If you decide that you no longer want to use our store and would like to have your personal data removed from our database (or if you’d like to get all the personal data associated with your account that we have), please send an email to [email].</p> <p>If you believe that your personal data has been misused, you have the right to lodge a complaint with a supervisory authority. We’re obliged by EU General Data Protection Regulation to let you know about this right; we don’t actually intend to misuse your data.</p>'),
('en', 'newsletters.use_for_subscribe_form', 'Subscribe form'),
('en', 'newsletters.default_mailing_list', 'Default mailing list'),
('en', 'email_marketing.subscription_confirmed', 'Thank you for subscribing to our newsletter'),
('en', 'email_marketing.text_subscription_confirmed', 'Your subscription has been confirmed. No extra actions is required.'),
('en', 'email_marketing.subscription_pending', 'Email confirmation is required!'),
('en', 'email_marketing.text_subscription_pending', 'Thank you for subscribing to our newsletter.<p>A confirmation email has been sent to you. Please use the link in the email to confirm your subscription</p>'),
('en', 'email_marketing.confirm_subscription', 'Please confirm subscription'),
('en', 'email_marketing.text_confirm_subscription', 'We received a subscription request from you. Please confirm it:<p><a href="[href]">Click here to confirm your subscription to our newsletter</a></p>If you received this email by mistake, simply delete it. You won''t be subscribed if you don''t click the confirmation link above.'),
('en', 'email_marketing.subscription_confirmed_2', 'Subscription confirmed'),
('en', 'email_marketing.text_subscription_confirmed_2', 'Your subscription to our newsletter has been confirmed. Thank you for subscribing!'),
('en', 'email_marketing.email_subscribed', 'You were subscribed to our newsletter'),
('en', 'email_marketing.text_email_subscribed', 'Thank you for subscribing to our newsletter. <p>If at any time you wish to stop receiving our emails, <a href="[href]">click on this link to unsubscribe</a>.</p>'),
('en', 'email_marketing.email_subscribed_2optin', 'Subscription confirmed'),
('en', 'email_marketing.text_email_subscribed_2optin', 'Your subscription to our newsletter has been confirmed.<p>If at any time you wish to stop receiving our emails, <a href="[href]">click on this link to unsubscribe</a>.</p>'),
('en', 'email_marketing.unsubscribe_successful', 'Unsubscribe successful'),
('en', 'email_marketing.text_unsubscribe_successful', 'Your email has been removed from our list.'),
('en', 'email_marketing.export_all', 'Export all'),
('en', 'email_marketing.enter_api_key_and_save', 'Enter API key and save first'),
('en', 'email_marketing.warning_email_exists', '[email] is already subscribed'),
('en', 'email_marketing.new_subscriber', 'New subscriber'),
('en', 'email_marketing.sync', 'Sync'),
('en', 'email_marketing.text_subscribe', 'Subscribe to our newsletter'),
('en', 'email_marketing.tmpl_subscription', 'Email marketing: Newsletter subscription form'),
('en', 'privileges.manage_email_marketing', 'Can edit'),
('en', 'privileges.view_email_marketing', 'Can view'),
('en', 'privilege_groups.email_marketing', 'Email marketing'),
('en', 'email_marketing.error_no_list', 'Please select mailing list in add-on settings to start import'),
('en', 'email_template.email_marketing_confirmation', 'Email marketing: subscription confirmation'),
('en', 'email_template.email_marketing_welcome', 'Email marketing: welcome letter'),
('en', 'email_template.email_marketing_welcome_2optin', 'Email marketing: welcome letter (2optin)'),
('en', 'email_marketing.use_for_subscribe_form', 'Email marketing subscribe form'),
('en', 'attachments', 'Attachments'),
('en', 'new_attachment', 'New attachment'),
('en', 'add_attachment', 'Add attachment'),
('en', 'editing_attachment', 'Editing attachment'),
('en', 'attachments.attachments_need_located_root_dir', 'Please specify the attachments directory within the store root directory. Put the attachments to import in this directory.'),
('en', 'attachments.error_exim_get_attachments_for_products', 'Could not import attachments for some of the products. Either those attachments don''t exist (or can''t be accessed), or the paths to those attachments in the imported file are incorrect.'),
('en', 'advanced_import_attachments', 'Product attachments'),
('en', 'attachments.attachments_delimiter', 'Attachments delimiter'),
('en', 'attachments.attachments_delimiter.description', 'Delimiter between attachments of a product.'),
('en', 'attachments.delete_attachments', 'Delete existing attachments'),
('en', 'attachments.delete_attachments_tooltip', 'If you enable this setting, then the existing attachments of the imported products will be replaced with the attachments specified in the imported file (if no attachments are specified, the old attachments will remain). If the setting is disabled, the new attachments will simply be added to the existing attachments.'),
('en', 'attachments.attachments_directory', 'Attachments directory'),
('en', 'attachments.cant_upload_file', 'Couldn''t load file [url] for product [product]'),
('en', 'vendor_communication.messages', 'Messages'),
('en', 'vendor_communication.message_center', 'Message center'),
('en', 'vendor_communication.message_center_name', 'Message center'),
('en', 'vendor_communication.author', 'Author'),
('en', 'vendor_communication.date', 'Date'),
('en', 'vendor_communication.message', 'Message'),
('en', 'vendor_communication.contact_vendor', 'Contact vendor'),
('en', 'vendor_communication.ask_a_question', 'Ask a question'),
('en', 'vendor_communication.contact_vendor_name', 'Contact [vendor_name]'),
('en', 'vendor_communication.created_at', 'Created on'),
('en', 'vendor_communication.new_thread_created', 'Your message has been sent to <b>[vendor_name]</b>.<br/><br/>The vendor''s reply will be sent to the email address of your account. To view your message history, please <a href="[thread_url]">go to the Message Center</a> located in the "Messages" section of the "My account" menu.'),
('en', 'vendor_communication.message_sent', 'Your message has been sent to <b>[vendor_name]</b>.<br/><br/>We''ll notify you about a reply. To view your message history, please <a href="[thread_url]" target="_blank">go to the Message Center</a> located in the "Messages" section of the "My account" menu.'),
('en', 'vendor_communication.cannot_update_thread', 'Cannot update thread'),
('en', 'vendor_communication.cannot_create_thread', 'Cannot create thread'),
('en', 'email_template.vendor_communication.notify_admin', 'Ask seller a question: Admin Notification'),
('en', 'email_template.vendor_communication.notify_customer', 'Ask seller a question: Customer Notification'),
('en', 'vendor_communication.you_have_new_message', 'You have a new <a href="[thread_url]">message</a> from [message_from].'),
('en', 'vendor_communication.subject_email', 'You have a new message from [message_from]'),
('en', 'vendor_communication.thread', 'Thread #[thread_id]'),
('en', 'vendor_communication.contact_with', '#[thread_id]. Communication with [thread_company]'),
('en', 'vendor_communication.ticket', 'Thread'),
('en', 'vendor_communication.no_messages_found', 'No messages found'),
('en', 'vendor_communication.customer_name', 'Customer name'),
('en', 'vendor_communication.error_message', 'Please enter your message'),
('en', 'vendor_communication.type_message', 'Type a message...'),
('en', 'vendor_communication.you', 'You'),
('en', 'vendor_communication.order_details', 'Order details'),
('en', 'vendor_communication.import_details', 'Import details'),
('en', 'vendor_communication.thread_deleted', 'Thread has been deleted'),
('en', 'vendor_communication.threads_deleted', 'Threads have been deleted'),
('en', 'vendor_communication.cannot_delete_thread', 'Cannot delete thread'),
('en', 'vendor_communication.cannot_delete_threads', 'Cannot delete threads'),
('en', 'vendor_communication.cannot_post_message', 'Cannot post message'),
('en', 'vendor_communication.no_threads_found', 'No threads found'),
('en', 'vendor_communication.required_field_is_missing', 'The [field_name] field is required'),
('en', 'vendor_communication.invalid_thread_object_type', 'Provided thread object type is invalid'),
('en', 'vendor_communication.please_log_in_to_contact_vendor', 'Please sign in to contact the vendor'),
('en', 'privileges.manage_vendor_communication', 'Can edit'),
('en', 'privileges.view_vendor_communication', 'Can view'),
('en', 'privilege_groups.vendor_communication', 'Message center: customer-to-vendor communication'),
('en', 'vendor_communication.your_message_to_vendor_name', 'Your message to [vendor_name]'),
('en', 'vendor_communication.please_log_in_to_be_notified', 'Please sign in so that we can notify you about a reply'),
('en', 'vendor_communication', 'Message center'),
('en', 'vendor_communication.event.message_received.name', 'Customer-to-vendor: New message received'),
('en', 'vendor_communication.event.vendor_to_admin_message_received.name', 'Vendor-to-admin: New message received'),
('en', 'internal_template.vendor_communication_message_received', 'New message received'),
('en', 'vendor_communication.new_message.title', '[company_name] has a new message from [customer]'),
('en', 'vendor_communication.new_message.message', 'Click this notification to see the message'),
('en', 'vendor_communication.contact_admin', 'Contact administrator'),
('en', 'vendor_communication.communication', 'Communication'),
('en', 'vendor_communication.message_center_vendor_name', 'Message center'),
('en', 'vendor_communication.tab_vendor_to_admin', 'Vendor communication'),
('en', 'vendor_communication.tab_vendor_to_customer', 'Customer communication'),
('en', 'vendor_communication.tab_vendor_to_admin_for_vendor_panel', 'Admin communication'),
('en', 'vendor_communication.menu_item_vendor_to_admin', 'Vendor messages'),
('en', 'vendor_communication.menu_item_vendor_to_customer', 'Customer messages'),
('en', 'vendor_communication.menu_item_vendor_to_admin_for_vendor_panel', 'Admin messages'),
('en', 'vendor_communication.your_message_to_admin', 'Your message to administrator'),
('en', 'vendor_communication.some_threads_have_not_been_created', 'Some threads have not been created: [count]'),
('en', 'vendor_communication.vendor_to_admin.message_sent', 'Your message has been sent to <b>[name]</b>.<br/><br/>To view your message history, please <a href="[thread_url]">go to the Message Center</a> located in the "Vendors" menu.'),
('en', 'vendor_communication.vendor_to_customer.message_sent', 'Your message has been sent to <b>[name]</b>.<br/><br/>To view your message history, please <a href="[thread_url]">go to the Message Center</a> located in the "Customers" menu.'),
('en', 'vendor_communication.vendor_to_admin.message_list_sent', 'Your messages have been sent.<br/><br/>To view your message history, please <a href="[thread_url]">go to the Message Center</a> located in the "Vendors" menu.'),
('en', 'privilege_groups.admin_communication', 'Message center: vendor-to-admin communication'),
('en', 'customer_to_admin_communication.event.message_received.name', 'Customer-to-Admin: New message received'),
('en', 'vendor_communication.start_communication', 'Start communication'),
('en', 'privilege_groups.order_communication', 'Message center: communication with customer'),
('en', 'vendor_communication.communication_vendor_to_admin', 'Communication with vendor'),
('en', 'vendor_communication.communication_vendor_to_customer', 'Communication with customer'),
('en', 'vendor_communication.communication_vendor_to_admin_with_admin', 'Communication with administrator'),
('en', 'vendor_communication.contact_customer', 'Contact customer'),
('en', 'vendor_communication.subject', 'Subject'),
('en', 'vendor_communication.admin', 'Admin'),
('en', 'vendor_communication.your_message_to_customer', 'Your message to customer'),
('en', 'vendor_communication.event.order_message_received.name', 'Order communication: New message received'),
('en', 'vendor_communication.scroll_to_top', 'Scroll to top'),
('en', 'vendor_communication.send_message', 'Send message'),
('en', 'vendor_communication.dashboard.todo.messages_from_customers', '<strong>[n] message</strong> from customer.|<strong>[n] messages</strong> from customers.'),
('en', 'vendor_communication.dashboard.todo.messages_from_administrator', '<strong>[n] message</strong> from marketplace administration.|<strong>[n] messages</strong> from marketplace administration.'),
('en', 'vendor_communication.dashboard.todo.messages_from_vendors', '<strong>[n] message</strong> from vendor.|<strong>[n] messages</strong> from vendors.'),
('en', 'advanced_import.never', 'Never'),
('en', 'advanced_import.last_status.X', '&mdash;'),
('en', 'advanced_import.last_status.S', 'Success'),
('en', 'advanced_import.last_status.P', 'In progress'),
('en', 'advanced_import.last_status.F', 'Failure'),
('en', 'advanced_import.user_upload', 'User upload'),
('en', 'advanced_import.last_launch', 'Last import'),
('en', 'advanced_import.last_status', 'Status'),
('en', 'advanced_import.file', 'File'),
('en', 'advanced_import.has_modifiers', 'Has modifiers'),
('en', 'advanced_import.import_products', 'Import products'),
('en', 'advanced_import.import_products_w_preset', 'Import products: [preset]'),
('en', 'advanced_import.import_file', 'Import file'),
('en', 'advanced_import.fields_mapping', 'Fields mapping'),
('en', 'advanced_import.fields_mapping.description', 'This table contains the list of columns from the imported file. For each column you''d like to import, select a corresponding product property in [product]. Then check what sort of data will be imported from that column, and use modifiers to change that data, if necessary. Remember to save your changes.'),
('en', 'advanced_import.column_header', 'Column name in the imported file'),
('en', 'advanced_import.product_property', 'Product property in [product]'),
('en', 'advanced_import.first_line_import_value', 'Example of the imported value'),
('en', 'advanced_import.editing_preset', 'Editing preset: [preset]'),
('en', 'advanced_import.add_preset', 'Add preset'),
('en', 'advanced_import.new_preset', 'New import'),
('en', 'advanced_import.properties', 'Properties'),
('en', 'advanced_import.modifier', 'Modifier'),
('en', 'advanced_import.modifier_title', 'A modifier is a rule that alters values in a column'),
('en', 'advanced_import.example_imported_title', 'For example, here''s a value in the first line of your file:'),
('en', 'advanced_import.example_modified_title', 'And here is how this value will be imported:'),
('en', 'advanced_import.options', 'Options'),
('en', 'advanced_import.images_delimiter', 'Images delimiter'),
('en', 'advanced_import.images_delimiter.description', 'Delimiter between images of a product.'),
('en', 'advanced_import_images', 'Product images'),
('en', 'advanced_import.remove_images', 'Remove additional images'),
('en', 'advanced_import.import_fields', 'Import fields'),
('en', 'advanced_import.advanced_products_import', 'Products'),
('en', 'advanced_import.coming_soon', '... coming soon'),
('en', 'advanced_import.cant_load_file_for_company', 'File can''t be loaded for the specified company'),
('en', 'advanced_import.cant_load_file', 'File can''t be loaded'),
('en', 'advanced_import.uploading_file', 'Uploading file for the preset: [preset]'),
('en', 'advanced_import.previewing_fields_mapping', 'Previewing fields mapping for the preset: [preset]'),
('en', 'advanced_import.preset_not_found', 'Preset not found'),
('en', 'advanced_import.modifiers_list', 'Modifiers list'),
('en', 'advanced_import.invalid_number_of_parameters_provided', 'Invalid number of parameters provided for modifier: <b>[modifier]</b>: expected [expected_count], got [actual_count].'),
('en', 'advanced_import.invalid_function_firs_character', 'The modifier name cannot start with character <b>[character]</b>.'),
('en', 'advanced_import.unrecognized_modifier', 'The modifier <b>[modifier]</b> does not exist.'),
('en', 'advanced_import.unexpected_parameter_passed', 'Expected <b>[delimiter]</b> or <b>[closer]</b> got <b>[char]</b>.'),
('en', 'advanced_import.invalid_modifier_message', 'The modifier <b>[modifier]</b> is invalid. [message]'),
('en', 'advanced_import.modifier_number_of_parameters', 'Number of parameters'),
('en', 'advanced_import.modifiers_description', 'Use these functions in the <b>Modifier</b> column to alter the values in the fields from the imported file. Enter the functions as follows: <b>function(parameter, parameter)</b>. Please note that nesting of functions isn''t supported.'),
('en', 'advanced_import.modifiers_self_referencing_info', 'Most functions allow you to use the non-modified value of the imported field by using <b>$value</b> as a parameter. If there are any exceptions, they will be mentioned in function descriptions.'),
('en', 'advanced_import.modifier_description.sum', '<b>sum</b>&mdash;sums up two numbers provided as parameters. <ul><li>Examples:</li><ul><li><b>sum(1, 3)</b> equals <i>4</i></li> <li><b>sum(7, $value)</b> equals <i>7 + the value of the imported field</i></li></ul></ul>'),
('en', 'advanced_import.modifier_description.sub', '<b>sub</b>&mdash;subtracts the second parameter from the first. <ul><li>Examples:</li><ul><li><b>sub(3, 1)</b> equals <i>2</i></li> <li><b>sub($value, 7)</b> equals <i>the value of the imported field - 7</i></li></ul></ul>'),
('en', 'advanced_import.modifier_description.mul', '<b>mul</b>&mdash;multiplies the numbers provided as parameters. <ul><li>Examples:</li><ul><li><b>mul(3, 1)</b> equals <i>3</i></li> <li><b>mul($value, 7)</b> equals <i>the value of the imported field × 7</i></li></ul></ul>'),
('en', 'advanced_import.modifier_description.div', '<b>div</b>&mdash;divides the first parameter by the second. <ul><li>Examples:</li><ul><li><b>div(9, 3)</b> equals <i>3</i></li> <li><b>div($value, 7)</b> equals <i>the value of the imported field ÷ 7</i></li></ul></ul>'),
('en', 'advanced_import.modifier_description.concat', '<b>concat</b>&mdash;concatenates all the provided parameters. <ul><li>Examples:</li><ul><li><b>concat(''abc'', def)</b> will result in <i>abcdef</i></li> <li><b>concat(''PRODUCT_'', $value, ''_CODE'')</b> will result in <i>PRODUCT_$value_CODE</i>, but <b>$value</b> will be replaced with the the value of the imported field</li></ul></ul>'),
('en', 'advanced_import.modifier_description.replace', '<b>replace</b>&mdash;replaces all occurrences of the search string with the replacement string. <br>The order of parameters is important: <b>replace(''search'', ''replace'', ''subject'')</b>. <ul><li>Examples:</li><ul><li><b>replace(''a'', !, "banana")</b> will result in <i>b!n!n!</i></li> <li><b>replace("t-shirt", ''T-Shirt'', $value)</b> will replace every occurrence of <i>t-shirt</i> with <i>T-Shirt</i> in every entry in the column.</li></ul></ul>'),
('en', 'advanced_import.modifier_description.w_replace', '<b>w_replace</b>&mdash;replaces all occurrences of the search string with the replacement string using wildcards. <br>The order of parameters is important: <b>w_replace(''search'', ''replace'', ''subject'')</b>. <br>Supported wildcards: <b>?</b>&mdash;any single character; <b>*</b>&mdash;any number of characters to the end of the word. <ul><li>Examples</li><ul><li><b>w_replace(''banan?'', bananas, banana banans bananz)</b> will result in <i>bananas bananas bananas</i></li> <li><b>w_replace("ban*", ''bananas'', banana banans bananz)</b> will also result in <i>bananas bananas bananas</i></li></ul></ul>'),
('en', 'advanced_import.modifier_description.rand', '<b>rand</b>&mdash;generates a random number from 1 to the maximum value provided as the parameter. <ul><li>Examples:</li><ul><li><b>rand(999)</b> may result in any number from 1 to 999.</li></ul></ul>');
INSERT INTO `[[dbprefix]]language_values` VALUES
('en', 'advanced_import.modifier_description.if', '<b>if</b>&mdash;checks the expression in the first parameter. If the first parameter is <i>true</i>, the function returns the second parameter. Otherwise the function returns the third parameter.<ul><li>Examples:</li><ul><li><b>if($value>"0", "In Stock", "Out of stock")</b> will result in <i>In Stock</i> if <i>$value > 0</i> is <i>true</i>; otherwise the result will be <i>Out of stock</i></li></ul><li>Available operations for the expression are:<ul><li><b>=</b>&mdash;checks for equality: <i>if($value=100, ...)</i></li><li><b>!=</b>&mdash;checks for inequality: <i>if($value!=100, ...)</i></li><li><b>&gt;</b>&mdash;checks if the first value is greater than the second: <i>if($value&gt;100, ...)</i></li><li><b>&lt;</b>&mdash;checks if the first value is less than the second: <i>if($value&lt;100, ...)</i></li><li><b>&gt;=</b>&mdash;checks if the first value is greater than or equal to the second: <i>if($value&gt;=100, ...)</i></li><li><b>&lt;=</b>&mdash;checks if the first value is less than or equal to the second: <i>if($value&lt;=100, ...)</i></li></ul></li><li>Notes:<ul><li>If you use single ('') or double (") quotes in the first parameter, make sure that the first parameter is either wrapped in quotes entirely, or that there is no end quote in the middle of the parameter. For example, <i>if("My value"=$value, ...)</i> will not work, but <i>if("My value=$value", ...)</i> will.</ul></li></ul>'),
('en', 'advanced_import.modifier_description.case', '<b>case</b>&mdash;odd parameters are expressions, and the following even parameters are corresponding values. The function checks the expressions and returns the value corresponding to the first expression that ends up being <i>true</i>.<ul><li>Examples:</li><ul><li><b>case($value>100, "More than 100", $value>70, "More than 70", $value>20, "More than 20", $value>0, "In stock", $value=0, "Out of stock")</b> will result in <i>More than 70</i> if the <i>$value</i> in the imported file is a number between 71 and 100</li></ul><li>Notes:<ul><li>This function shares expression rules and available operations with the <b>if</b> function.</li><li>Only even numbers of parameters are supported: <b>2, 4, 6, 8</b>, etc.</li></ul></li></ul>'),
('en', 'advanced_import.modifier_self_reference_is_unsupported', 'This function doesn''t support the use of a non-modified value from the imported file.'),
('en', 'advanced_import.preset_last_view', 'Preset'),
('en', 'advanced_import.show_more', 'Show more'),
('en', 'advanced_import.show_less', 'Show less'),
('en', 'advanced_import.target_node', 'XML target node'),
('en', 'advanced_import.target_node.description', 'The full path to the XML node with the information about an imported entity. The nodes nested in the specified node will be used as columns of the imported file. Here is an example of the path: yml_catalog/shop/offers/offer'),
('en', 'advanced_import.fetching_schema_failed_check_target_node', 'Please make sure that the <b>XML target node</b> field is filled in properly.'),
('en', 'advanced_import.general_settings', 'General settings'),
('en', 'advanced_import.additional_settings', 'Additional settings'),
('en', 'advanced_import.delete_additional_images', 'Delete existing additional images'),
('en', 'advanced_import.delete_additional_images_tooltip', 'If you enable this setting, then the existing additional images of the imported products will be replaced with the images specified in the imported file (if no images are specified, the old images will remain). If the setting is disabled, the new additional images will simply be added to the existing images.'),
('en', 'advanced_import.fetching_schema_failed_check_file', 'Before you can run the import, please make sure that:<ul><li>You have created the import preset by using the Create button. If you see Save instead of Create, then you''ve already done that.</li><li>You have specified the correct XML target node on the File tab and saved the preset.</li><li>You have matched the imported information with the product properties in CS-Cart on the Fields mapping tab and saved the preset.</li></ul>If you see this message, you haven''t completed point 1 or 2.'),
('en', 'advanced_import.test_import', 'Perform test import'),
('en', 'advanced_import.test_import_tooltip', 'If you enable this setting, only the first [n] product will be processed.|If you enable this setting, only the first [n] products will be processed.'),
('en', 'advanced_import.import_strategy', 'Import strategy'),
('en', 'advanced_import.import_strategy_tooltip', 'If you select "Update existing products only", products that don''t exist in the database of your store will be skipped during import.<br>If you select "Create new products only", products that exist in the database of your store will be skipped during import.'),
('en', 'advanced_import.import_all', 'Import all products from the file'),
('en', 'advanced_import.create_new_products_only', 'Create new products only'),
('en', 'advanced_import.cant_save_preset_invalid_modifiers', 'The preset can''t be saved because it contains invalid modifiers'),
('en', 'advanced_import.some_product_properties_not_found', 'Some previously mapped product properties are no longer available. For example, this can happen when you disable a product feature.'),
('en', 'advanced_import.missing_parameters_list_closer', 'The expected <b>[closer]</b> after the parameters list is missing.'),
('en', 'advanced_import.run_import_via_cron_message', 'You can run the import automatically at certain time intervals. To do it, add the following command to CRON:'),
('en', 'advanced_import.cannot_detect_csv_delimiter', 'Cannot detect delimiter automatically. Please specify the correct delimiter manually in the additional settings on the "File" tab.'),
('en', 'advanced_import.incorrect_delimiter', 'Specified (or auto detected) delimiter seems to be incorrect. Please specify the correct delimiter manually in the additional settings on the "File" tab.'),
('en', 'advanced_import.file_will_be_deleted_are_you_sure_to_proceed', 'Deleting this import preset will also delete the file attached to it. Are you sure you want to proceed?'),
('en', 'advanced_import.common_preset', 'All vendors'),
('en', 'advanced_import.your_presets', 'Vendor''s presets'),
('en', 'advanced_import.common_presets', 'Marketplace presets'),
('en', 'advanced_import.file_not_loaded', 'File was not loaded. Please reload the page and try again.'),
('en', 'advanced_import.local_file_selected', 'Local file selected'),
('en', 'advanced_import.text_popup_file_editor_notice_full_link', 'You can upload and download files via <a class="advanced-import-file-editor-opener" data-target-input-id="[target]">[link_text]</a>'),
('en', 'advanced_import.text_popup_file_editor_notice_with_image_size_info', 'You can upload and download files via <a class="advanced-import-file-editor-opener" data-target-input-id="[target]">[link_text]</a>. The maximum size of image files is [file_size] MB.'),
('en', 'advanced_import.text_allowed_to_upload_file_extension_with_image_size_info', 'The following file extensions are supported: <b>[ext]</b>. The maximum size of image files is [file_size] MB.'),
('en', 'advanced_import.file_extension_was_not_supported_by_owner', 'Couldn''t use your file [name]. This import preset only allows the following extensions: [ext].'),
('en', 'advanced_import.save_selected_file', 'Save selected file'),
('en', 'advanced_import.fields_delimiter', 'XML node delimiter'),
('en', 'advanced_import.fields_delimiter.description', 'Delimiter between similar nodes.'),
('en', 'advanced_import.link_to_file', 'Link to file'),
('en', 'advanced_import.export_example', 'Export example'),
('en', 'advanced_import.cant_export_example', 'The example file can not be exported. Fill the fields mapping of current preset.'),
('en', 'advanced_import.archive_with_images', 'Archive with images'),
('en', 'advanced_import.step_map_fields', 'Next step: map fields'),
('en', 'geo_maps.select_your_city', 'Select your city'),
('en', 'geo_maps.your_city', 'Your city'),
('en', 'geo_maps.location_detection_disabled', 'Your location could not be determined. Try enabling the location services on your device or disabling the tracking protection.'),
('en', 'block_geo_maps_customer_location', 'Customer location'),
('en', 'block_geo_maps_customer_location_description', 'Current city and city selection form'),
('en', 'geo_maps.shipping_address_on_map', 'Shipping address on map'),
('en', 'geo_maps.cannot_select_location', 'This location couldn''t be selected due to technical reasons. If you encounter any difficulties when placing an order, please contact us.'),
('en', 'geo_maps.shipping_time_and_rates', 'Shipping time and rates'),
('en', 'geo_maps.shipping_group_pickup', 'Pick-up'),
('en', 'geo_maps.shipping_group_delivery', 'Shipping'),
('en', 'geo_maps.from_pickup_points', '[shipping], [n] pickup point|[shipping], [n] pickup points'),
('en', 'geo_maps.shipping_about', 'about'),
('en', 'geo_maps.shipping_from', 'from'),
('en', 'geo_maps.shipping_time', 'Shipping time'),
('en', 'geo_maps.no_shippings', 'Sorry, we couldn''t find any shipping options for your location. Please contact us, and we''ll see what we can do about it.'),
('en', 'geo_maps.no_shippings_short', 'Shipping to your location isn''t available.'),
('en', 'geo_maps.text_settings_google_api_notice', 'Learn more about setting up API key <a target="_blank" href="https://docs.cs-cart.com/4.10.x/user_guide/addons/maps_and_geolocation/#configuration">in the documentation</a>.'),
('en', 'geo_maps.settings_is_configured_correctly_notice', 'If you see the map here, everything is configured correctly, and the maps are working on the map provider end.'),
('en', 'geo_maps.google_maps_cookie_title', 'Google Maps'),
('en', 'geo_maps.google_maps_cookie_description', 'Google Maps is a service that allows us to show the maps and various locations on those maps, or automatically determine your location. Here is <a href="https://policies.google.com/privacy" target="_blank">Google privacy policy;</a> we also recommend Google''s concise and comprehensive <a href="https://support.google.com/maps/answer/10400210" target="_blank">note on privacy</a>.'),
('en', 'geo_maps.yandex_maps_cookie_title', 'Yandex Maps'),
('en', 'geo_maps.yandex_maps_cookie_description', 'Yandex Maps is a service that allows us to show the maps and various locations on those maps, or automatically determine your location. Here is <a href="https://yandex.com/legal/confidential/" target="_blank">Yandex privacy policy</a>.'),
('en', 'gift_certificates.actions.gift_certificate_statuses', 'Gift certificate statuses'),
('en', 'gift_certificate', 'Gift certificate'),
('en', 'gift_certificates', 'Gift certificates'),
('en', 'gift_certificate_info', 'Gift certificate info'),
('en', 'gift_certificate_verification', 'Gift certificate verification'),
('en', 'gift_cert_code', 'Gift certificate code'),
('en', 'gift_cert_debit', 'Debit balance'),
('en', 'gift_cert_from', 'From'),
('en', 'gift_cert_to', 'To'),
('en', 'promotion_bonus_gift_certificate', 'Gift certificate'),
('en', 'purchase_gift_certificate', 'Purchase Gift Certificate'),
('en', 'text_gift_certificate_logo', 'Logo for <b>gift certificates</b>'),
('en', 'text_gift_cert_amount_alert', 'Amount should be between [min] and [max]'),
('en', 'text_gift_cert_has_been_deleted', 'Gift certificate has been deleted successfully.'),
('en', 'error_gift_cert_code', 'The gift certificate code you entered is invalid. Please try again.'),
('en', 'gift_add_products', 'Add products for a gift'),
('en', 'gift_comment', 'Message'),
('en', 'certificate_verification', 'Validate/Redeem gift certificate'),
('en', 'detailed_info', 'Detailed information'),
('en', 'history', 'History'),
('en', 'gift_certificate_statuses', 'Gift certificate statuses'),
('en', 'gift_certificates.recipient_email', 'Recipient email'),
('en', 'text_gift_cert_applied', 'Gift certificate has been applied'),
('en', 'certificate_already_used', 'This gift certificate is already in use'),
('en', 'certificate_code_not_available', 'Gift certificate cannot be applied. Please contact the store administration.'),
('en', 'certificate_code_not_valid', 'Gift certificate code is not valid'),
('en', 'warning_gift_cert_deny', 'The following gift certificates have been deleted or cancelled by administrator and have been removed from your cart: [codes]. Please contact the store administrator or try another one.'),
('en', 'text_gift_cert_cannot_delete', 'Gift certificate [code] cannot be deleted because it is used in order(s) [ids].'),
('en', 'gift_cert_amount_changed', 'Gift certificate amount has been changed.'),
('en', 'purchased', 'Purchased'),
('en', 'used', 'Used'),
('en', 'create_gift_certificate_for_customer', 'Create Gift Certificate for this customer'),
('en', 'gift_certificate_created', 'Gift Certificate has been created'),
('en', 'related_gift_cert', 'Related gift certificates'),
('en', 'add_gift_certificate', 'Add gift certificate'),
('en', 'gift_certificate_status', 'Gift certificate status'),
('en', 'current_amount', 'Current amount'),
('en', 'mail', 'Mail'),
('en', 'statuses', 'statuses'),
('en', 'new_certificate', 'New certificate'),
('en', 'editing_certificate', 'Editing certificate'),
('en', 'shop_now', 'Shop now'),
('en', 'theme_editor.gift_cert', 'Gift Certificate'),
('en', 'theme_editor_logo.gift_cert', 'Gift Certificate'),
('en', 'promo_code_or_certificate', 'Gift certificate or promo code'),
('en', 'gift_certificate_added_to_cart', 'Gift certificate was added to your cart'),
('en', 'gift_certificates_verify', 'Gift certificate verification'),
('en', 'block_gift_certificates_verify', 'Gift certificate verification'),
('en', 'block_gift_certificates_verify_description', 'Gift certificate input and validation'),
('en', 'gift_cert_error_amount', 'Amount should not be higher than [max] and less than [min]'),
('en', 'privileges.manage_gift_certificates', 'Can edit'),
('en', 'privilege_groups.gift_certificates', 'Gift certificates'),
('en', 'change_gift_certificate_status', 'Change gift certificate status to'),
('en', 'gift_cert_with_products', 'Purchasing products and gift certificates together is impossible. Please, place the current order and repeat your attempt.'),
('en', 'gc_redeem_and_add_free_products', 'Redeem & add free products to cart'),
('en', 'email_template.gift_certificates_notification', 'Gift certificate'),
('en', 'template_document_gift_certificate_default', 'Gift certificates: default'),
('en', 'document_preview_gift_certificate_not_found', 'Couldn''t find a gift certificate. Preview only works with existing data. Please create a gift certificate and use Preview again.'),
('en', 'gift_certificates.certificate_purchase_form', 'Gift certificate purchase form'),
('en', 'gift_certificates.event.gift_certificate.status_changed.name', 'Gift certificate status changed to [status]'),
('en', 'gift_certificates.event.gift_certificate.updated.name', 'Gift certificate updated'),
('en', 'logo_section.gift_cert', 'Gift certificate logo'),
('en', 'store_locator_menu_description', 'Set up locations for pick up and manage inventory by location.'),
('en', 'store_locator.actions.store_locator', 'Stores'),
('en', 'view_on_map', 'View on map'),
('en', 'get_api_key', 'Obtaining an API Key'),
('en', 'block_store_locator', 'Store locator'),
('en', 'store_locator', 'Stores & pickup points'),
('en', 'block_store_locator_description', 'Store locator block'),
('en', 'text_address_not_found', 'Address not found'),
('en', 'select_coordinates', 'Select coordinates'),
('en', 'set', 'Set'),
('en', 'editing_store_location', 'Editing store location'),
('en', 'new_store_location', 'New store location'),
('en', 'add_store_location', 'Add store location'),
('en', 'coordinates', 'Coordinates'),
('en', 'latitude_short', 'lat'),
('en', 'longitude_short', 'long'),
('en', 'all_stores', 'All stores'),
('en', 'privileges.manage_store_locator', 'Can edit'),
('en', 'privilege_groups.store_locator', 'Store locator'),
('en', 'privileges.view_store_locator', 'Can view'),
('en', 'store_locator.text_pickup_instruction', 'The "Customer pick-up" shipping method offers a customer to choose a store to pick up a product from. The stores can be created in the "Store location" add-on<br /><b>Store creation:</b> <a href="[store_locator]">Store location</a>'),
('en', 'store_locator.select_stores', 'Select stores'),
('en', 'store_locator.pick_up_points', 'Pick-up points'),
('en', 'store_locator.stores_position', 'The "Position" field in the store settings'),
('en', 'store_locator.shipping_position', 'Order selected in the shipping method settings'),
('en', 'store_locator.selected_fields', 'Selected stores'),
('en', 'store_locator.available_fields', 'Available stores'),
('en', 'store_locator.display_ml', 'Map and list'),
('en', 'store_locator.display_l', 'List'),
('en', 'store_locator.display_m', 'Map'),
('en', 'store_locator.display', 'Locations list view on the checkout page'),
('en', 'store_locator.pickup', 'Pickup'),
('en', 'store_locator.pickup_avail', 'Available for pick-up'),
('en', 'store_locator.work_time', 'Working hours'),
('en', 'carrier_store_locator', 'Pickup'),
('en', 'destination_nothing_found', 'No suitable destination has been found'),
('en', 'stores_nothing_found', 'No stores have been found'),
('en', 'pickup', 'Pickup'),
('en', 'pickup_id', 'Pickup ID'),
('en', 'pickup_avail', 'Pickup avail'),
('en', 'pickup_surcharge', 'Pickup surcharge'),
('en', 'pickup_address', 'Pickup address'),
('en', 'pickup_phone', 'Pickup phone'),
('en', 'pickup_time', 'Pickup time'),
('en', 'pickup_destinations_ids', 'Pickup destinations ids'),
('en', 'store_locator.show_pickup_points_only', 'Hide places where I can''t pick up my order'),
('en', 'store_locator.stores_and_pickup_points', 'Stores and pickup points'),
('en', 'store_locator.surcharge_changes_hint', 'In previous versions, the surcharge was added to the standard rates that were specified for a shipping method. Now this surcharge isn''t taken into account during shipping rate calculation. We left it here for your convenience, so that you could see it and adjust the rates on the shipping method editing page accordingly.'),
('en', 'store_locator.main_destination', 'Located in rate area'),
('en', 'tt_addons_store_locator_views_store_locator_update_store_locator.main_destination', 'Determines the shipping rates for this pickup point. The rates are specified on the shipping method editing page. If you don''t select a rate area for a pickup point, then the pickup point won''t appear at checkout.'),
('en', 'store_locator.show_to', 'Show to'),
('en', 'show_to', 'Show to'),
('en', 'tt_addons_store_locator_views_store_locator_update_store_locator.show_to', 'Allows you to offer this pickup point to the residents of other rate areas at checkout.'),
('en', 'store_locator.shipping_price_from', 'from [price]'),
('en', 'store_locator.use_two_fingers_for_move_map', 'Use two fingers to move the map'),
('en', 'store_locator.scroll_to_top', 'Scroll to top'),
('en', 'store_locator.no_rate_area', 'No rate area'),
('en', 'store_locator.name', 'Name'),
('en', 'store_locator.pickup_locations', 'Pickup Locations'),
('en', 'store_locator.any_rate_area', 'Any rate area'),
('en', 'store_locator.pickup_from_store', 'Pickup from store'),
('en', 'store_locator.any_vendor', 'Any vendor'),
('en', 'store_locator.any', 'Any'),
('en', 'store_locator.shipping_price_from_to', 'from [from_price] to [to_price]'),
('en', 'product_variations.product_type', 'Product type'),
('en', 'product_variations.product_type.catalog_item', 'Catalog item'),
('en', 'product_variations.product_type.variation_of_catalog_item', 'Variation of a catalog item'),
('en', 'product_variations.belongs_to_catalog_item', 'Belongs to catalog item:'),
('en', 'product_variations.variations', 'Variations'),
('en', 'product_variations.variation_of_product', 'Variation of catalog item <a href="[url]">[product]</a>'),
('en', 'product_variations.group_code', 'Variation group'),
('en', 'product_variations.group_code.placeholder', 'Set custom group code here'),
('en', 'product_variations.group_code.description', 'Use the group code on a product editing page or during import to add the product to this group as a variation. A group code can contain only digits, Latin characters, and the following signs: "-" and "_".'),
('en', 'product_variations.group_code.link', 'Add to variation group'),
('en', 'product_variations.add_variations', 'Add variations'),
('en', 'product_variations.link_existing', 'Use existing products'),
('en', 'product_variations.create_new', 'Create new products'),
('en', 'product_variations.add_variations_description', 'Add variations to generate a group of similar products that differ in color, size, etc. Or add this product to an existing group by entering the group code.'),
('en', 'product_variations.manage', 'Manage variations'),
('en', 'product_variations.edit_features', 'Edit features'),
('en', 'product_variations.delete', 'Disband group'),
('en', 'product_variations.remove_variation', 'Remove variation from group'),
('en', 'product_variations.delete_product', 'Delete product'),
('en', 'product_variations.mark_main_product', 'Set as default variation'),
('en', 'product_variations.no_available_features', 'This product doesn''t have features that allow grouping products. Please make sure that:<ol><li>You have created at least one feature with <b>Purpose:</b> <i>Variations as separate products</i> or <i>Variations as one product</i>.</li><li>You have specified the value of that feature for the product.</li></ol><a href=[manage_features_href]>Manage features</a>'),
('en', 'product_feature.purpose.group_catalog_item', 'Variations as separate products'),
('en', 'product_feature.purpose.group_catalog_item.description', 'For cases when a few similar products differ visibly by a feature, and have different names (for example, multiple "Color" variants of a T-shirt). These products will appear as separate positions in the catalog. Customers will also be able to select the desired feature value on the product page. To achieve this, <b>set up variations for products with this feature</b>.'),
('en', 'product_feature.feature_style.dropdown', 'Drop-down list'),
('en', 'product_feature.feature_style.dropdown_images', 'Images'),
('en', 'product_feature.feature_style.dropdown_labels', 'Text labels'),
('en', 'product_feature.purpose.group_variation_catalog_item', 'Variations as one product'),
('en', 'product_feature.purpose.group_variation_catalog_item.description', 'For cases when a few similar products differ by a feature, but have the same name and similar appearance (for example, multiple "Size" variants of a T-shirt). These products will occupy a single position in the catalog. Customers will be able to select the desired feature value on the product page. To achieve this, <b>set up variations for products with this feature</b>.'),
('en', 'product_variations.warning.before_edit_variations_save_product', 'Before you can edit variations, please save the product.'),
('en', 'product_variations.error.group_not_found', 'Variation group #[id] not found'),
('en', 'product_variations.error.product_not_found_in_group', 'Product #[product_id] not found in variation group "[group_code]"'),
('en', 'product_variations.error.cannot_mark_main_product_child_product', 'Product #[product_id] in group "[group_code]" isn''t a variation, so it can''t become default for a catalog item'),
('en', 'product_variations.error.generate_combinations_is_empty', 'Couldn''t generate variations. Please specify the values of features to generate variations.'),
('en', 'product_variations.error.generate_products_is_empty', 'No new products were created'),
('en', 'product_variations.error.product_not_found', 'Product #[product_id] not found'),
('en', 'product_variations.error.group_not_found_by_product', 'Couldn''t find variation group for #[product_id] "[product]"'),
('en', 'product_variations.error.feature_combination_is_invalid_for_product', 'Wrong combination of features for product #[product_id] "[product]"'),
('en', 'product_variations.error.product_ids_empty', 'Products couldn''t be found'),
('en', 'product_variations.select_variation', 'Select a Variation'),
('en', 'product_variations.error.group_code_is_required', 'Variation group code must be specified'),
('en', 'product_variations.error.group_code_is_invalid', 'Couldn''t set this code for variation group. A group code can contain only digits, Latin characters, and the following signs: "-" and "_"'),
('en', 'product_variations.error.group_code_is_duplicate', 'The specified variation group code is already in use'),
('en', 'product_variations.error.features_is_empty', 'Features couldn''t be found'),
('en', 'product_variations.error.no_available_products', 'No suitable products were found'),
('en', 'product_variations.error.product_has_not_required_features', 'Product #[product_id] "[product]" doesn''t have the required features to become a variation. Please set feature values for that product.'),
('en', 'product_variations.error.product_with_features_combination_exits', 'Product #[product_id] "[product]" has the exact same combination of feature values as a variation that already exists in the group.'),
('en', 'product_variations.error.product_company_does_not_match_to_group_company.ult', 'Product #[product_id] "[product]" can''t be added to the variation group because all products in a variation group must belong to the same storefront.'),
('en', 'product_variations.error.product_company_does_not_match_to_group_company.mve', 'Product #[product_id] "[product]" can''t be added to the variation group because all products in a variation group must belong to the same vendor.'),
('en', 'product_variations.variations_filling', 'Variations'),
('en', 'product_variations.variations_list', 'Variations'),
('en', 'variations_in_stock', 'Only "in stock" products'),
('en', 'product_variations.hide_add_to_wishlist_button', 'Hide add to wish list button'),
('en', 'product_variations.variations_list_block_name', 'Variations list'),
('en', 'product_variations.variations_list_tab_name', 'View all variations as list'),
('en', 'product_variations.show_variation_thumbnails', 'Show variation thumbnails'),
('en', 'product_variations.show_product_code', 'Show product code'),
('en', 'product_variations.exim.result_notice', 'Data is imported successfully.<br />New products - <b>[new]</b>;<br />Updated products - <b>[exist]</b>;<br />Skipped products - <b>[skipped]</b>;<br />Total - <b>[total]</b>;<br />Created variations - <b>[variation_created]</b>;<br />Updated variations - <b>[variation_updated]</b>;<br />Disbanded variations - <b>[variation_removed]</b>.'),
('en', 'variation_group_id', 'Variation group ID'),
('en', 'variation_group_code', 'Variation group code'),
('en', 'variation_parent_product_id', 'Variation parent product ID'),
('en', 'variation_sub_group_id', 'Variation sub group ID'),
('en', 'product_variations.feature_used_by_variation_group.tooltip', 'This feature is used by variation group [code]. To choose a different value of this feature for a product, switch to the "Variations" tab of the product editing page. New values can be added on the feature editing page.'),
('en', 'product_variations.variations_naming_strategy.key_value', 'Color: Red, Size: Small'),
('en', 'product_variations.variations_naming_strategy.value', 'Red, Small'),
('en', 'product_variations.feature_can_be_deleted', 'Couldn''t delete a feature or its variant because at least one variation group is based on it. Please delete <a href="[href]">these products</a> or disband their product groups, and try again.'),
('en', 'product_variations.notice.old_product_variations_exists', 'Your store still has old product variations. They currently appear as separate products, without the ability to switch between them. To make them work as before the upgrade, <a href="[convert_url]">convert old variations to new variations</a>. It''s easy and automatic.'),
('en', 'product_variations.notice.is_old_product_variation', 'This product is an old variation that hasn''t been converted yet. To make it work as before the upgrade, <a href="[convert_url]">convert old variations to new variations</a>.'),
('en', 'variation_set_as_default', 'Variation set as default'),
('en', 'product_variations.cant_edit_feature_categories', 'Couldn''t restrict the feature''s availability in categories. <a href="[href]">Some product variations with that feature</a> are still available in the categories where you tried to restrict the feature. Please remove the variation groups from those categories and try again.'),
('en', 'product_variations.too_many_combinations', 'Sorry, there are too many possible variations that can be generated. To prevent heavy load, we won''t display them here. Please create the products with the right feature values manually or via import, and add them to the group.'),
('en', 'product_variations.generator.features.placeholder', 'Search for features that can generate variations'),
('en', 'product_variations.generator.warning.new_features_add', 'You can add a new feature if you disband the group in the actions menu and create variations again.'),
('en', 'product_variations.generator.feature_variants.placeholder', 'Type to search'),
('en', 'product_variations.generator.feature_variants.add_all_variants', 'Add all variants'),
('en', 'product_variations.generator.table.title', 'Modify the variations to be created:'),
('en', 'product_variations.generator.create_btn', 'Create [n] variation|Create [n] variations'),
('en', 'product_variations.allow_own_features_setting_changing', 'You''ve disabled the <b>Allow own feature values for child variations</b> setting. Please export <a href="[url]">all your default variations</a> (use "Export found products" in the gear button) and reimport them. This will apply their feature values to existing child variations.'),
('en', 'product_variations.allow_own_images_setting_changing', 'You''ve disabled the <b>Allow own images for child variations</b> setting. Please export <a href="[url]">all your default variations</a> (use "Export found products" in the gear button) and reimport them. This will apply their images to existing child variations.'),
('en', 'product_variations.add_all_variants', 'Add all variants'),
('en', 'product_variations.error.not_available_feature_purpose', 'Couldn''t create variation group based on these features; please use the features with the purpose that is eligible for creating variations (group_catalog_item or group_variation_catalog_item).'),
('en', 'product_variations.error.cannot_set_as_default_out_of_stock', 'Couldn''t set variation #[product_id] as default, because it is out of stock. A variation that is in stock was used as default instead.'),
('en', 'product_variations.error.variations_as_separate_products_exceeds_the_limit', 'You’re trying to add more products than allowed by your plan limits. <b>[available_count]</b> products could be added.'),
('en', 'product_variations.error.limit_creating_new_products_exhausted_with_url', 'You can’t add more products at this time. You may need to <a href="[url_upgrade_plan]" target="_blank">upgrade the plan</a> before adding new products.'),
('en', 'product_variations.error.limit_creating_new_products_exhausted', 'You can’t add more products at this time. You may need to upgrade the plan before adding new products.'),
('en', 'product_variations.too_many_combinations_display', 'There are too many possible variations to preview them here. But you can still create them, if they don''t exist already.'),
('en', 'error_validator_recaptcha', 'Please confirm you are not a robot.'),
('en', 'recaptcha_settings_notice', '<p>The instructions on how to get the <b>site key</b> and <b>secret</b> are available <b><a target="_blank" href="https://developers.google.com/recaptcha/docs/start">here</a></b>.</p>'),
('en', 'recaptcha.text_settings_notice', '<p>The instructions on how to get the <b>site key</b> and <b>secret</b> are available <b><a target="_blank" href="https://developers.google.com/recaptcha/intro">here</a></b>.<br>Please note that the add-on currently supports only <b>Google reCAPTCHA v2: Checkbox</b> and <b>Google reCAPTCHA v3</b></p>'),
('en', 'recaptcha.text_forbidden_countries_notice', '<p>Google reCAPTACHA will be disabled for the selected countries. Instead, visitors from those countries will be asked to type a few symbols they see on the screen.</p>'),
('en', 'recaptcha.error_recaptcha_v3_failed', 'Sorry, the anti-bot validation has failed. If you''re seeing this message, please contact us and let us know about it.'),
('en', 'recaptcha.recaptcha_v2', 'reCAPTCHA v2'),
('en', 'recaptcha.recaptcha_v3', 'reCAPTCHA v3'),
('en', 'recaptcha.none', 'none'),
('en', 'recaptcha.recaptcha_cookie_title', 'Google reCAPTCHA'),
('en', 'recaptcha.recaptcha_cookie_description', 'Google reCAPTCHA is a service that provides anti-bot protection and verifies that site visitors are humans. Here is <a href="https://policies.google.com/privacy" target="_blank">Google privacy policy</a>; we also recommend Google''s concise and comprehensive <a href="https://support.google.com/maps/answer/10400210" target="_blank">note on privacy</a>.'),
('en', 'product_bundles.tab_title', 'Bundles with this product'),
('en', 'product_bundles.product_bundles', 'Product bundles'),
('en', 'product_bundles.promo_image', 'Promo image'),
('en', 'product_bundles.display_in_promotions', 'Display in promotions'),
('en', 'product_bundles.bundle_products', 'Bundle products'),
('en', 'product_bundles.price_for_all', 'Price for all'),
('en', 'product_bundles.share_discount', 'Share discount'),
('en', 'product_bundles.product_bundle_name', 'Bundle name'),
('en', 'product_bundles.products_in_bundle', 'Products in bundle'),
('en', 'product_bundles.total_cost', 'Total cost'),
('en', 'product_bundles.add_new_bundle', 'Add new bundle'),
('en', 'product_bundles.delete_product_in_bundle', 'The <b>[bundle_name]</b> bundle was disabled, because of the products from this bundle was deleted.|The <b>[bundle_name]</b> bundle were disabled, because one of the products from these bundles was deleted.'),
('en', 'product_bundles.new_bundle', 'New bundle'),
('en', 'product_bundles.active_bundles', 'Active bundles'),
('en', 'product_bundles.specify_features', 'Specify features'),
('en', 'product_bundles.any_variation', 'Any variation'),
('en', 'product_bundles.specify_options', 'Specify options'),
('en', 'product_bundles.total_list_price', 'Total list price'),
('en', 'product_bundles.order_discount', 'Order discount'),
('en', 'product_bundles.add_all_to_cart', 'Add all to cart'),
('en', 'product_bundles.sign_in_to_view_price', 'Sign in to view price'),
('en', 'product_bundles.bundle_details', 'Bundle details'),
('en', 'product_bundles.search_in_products', 'Bundles with product'),
('en', 'product_bundles.internal_feature_name_tooltip', 'This name is shown only in the Administration panel to help you distinguish between multiple product bundles that have the same displayed name.'),
('en', 'product_bundles.show_on_product_page', 'Show on products page'),
('en', 'product_bundles.confirm_text_on_empty_bundle', 'Are you sure you want to create a bundle without products?'),
('en', 'product_bundles.confirm_text_with_one_product_bundle', 'Are you sure you want to create a bundle with 1 product?'),
('en', 'product_bundles.specify_options_first', 'Product options should be specified'),
('en', 'privileges.view_product_bundles', 'Can view'),
('en', 'privileges.manage_product_bundles', 'Can edit'),
('en', 'privilege_groups.product_bundles', 'Product bundles'),
('en', 'block_product_bundles', 'Product bundles'),
('en', 'block_product_bundles_description', 'Product bundles form'),
('en', 'product_bundles.template_product_bundles', 'Product bundles'),
('en', 'rma.actions.request_statuses', 'RMA request statuses'),
('en', 'returned_products', 'Returned products'),
('en', 'rma_return', 'Return'),
('en', 'no_return_requests_found', 'No return requests found'),
('en', 'returned_product', 'Returned product'),
('en', 'returns', 'Returns'),
('en', 'returns_info', 'Returns info'),
('en', 'return_info', 'Return information'),
('en', 'order_returns', 'Order returns'),
('en', 'return_registration', 'Request a replacement or a refund'),
('en', 'return_requests', 'Return requests'),
('en', 'return_status', 'Return status'),
('en', 'return_period', 'Return period'),
('en', 'what_you_would_like_to_do', 'What would you like to do'),
('en', 'rma_notify_supplier', 'Notify supplier'),
('en', 'add_reason', 'Add reason'),
('en', 'new_reason', 'New reason'),
('en', 'type_comment', 'Type comments here'),
('en', 'return_requests_note', 'Go to the list of your return requests'),
('en', 'privileges.manage_rma', 'Can edit'),
('en', 'privilege_groups.rma', 'Return merchandise authorization (RMA)'),
('en', 'rma.text_return_change_warning', 'The status of return request will change from [old_status] to [new_status].'),
('en', 'returnable', 'Returnable'),
('en', 'returnable_product', 'Returnable product'),
('en', 'rma_request_statuses', 'RMA request statuses'),
('en', 'return_products_information', 'Return products information'),
('en', 'declined_products_information', 'Declined products information'),
('en', 'rma_reasons', 'RMA reasons'),
('en', 'rma_actions', 'RMA actions'),
('en', 'rma', 'RMA'),
('en', 'return_period_days', 'Return period (days)'),
('en', 'all_actions', 'All actions'),
('en', 'decline_products', 'Decline products'),
('en', 'create_gift_certificate', 'Create gift certificate'),
('en', 'accept_products', 'Accept products'),
('en', 'rma.recalculate_order', 'Recalculate order'),
('en', 'rma.manually_recalculate_order', 'Set the new order total manually'),
('en', 'rma.dont_recalculate_order', 'Don''t recalculate order'),
('en', 'delete_this_return', 'Delete this return'),
('en', 'update_totals_and_inventory', 'Update totals and inventory'),
('en', 'request_statuses', 'request statuses'),
('en', 'email_template.rma_slip_notification', 'RMA slip'),
('en', 'template_document_rma_packing_slip_default', 'Return request: packing slip'),
('en', 'document_preview_return_request_not_found', 'Couldn''t find a return request. Preview only works with existing data. Please create a return request and use Preview again.'),
('en', 'event.rma.status_changed.name', 'Return request status changed to [status]'),
('en', 'rma.choose_change_return_status', 'What to do with the order'),
('en', 'rma.please_confirm_decision', 'Please confirm your decision.'),
('en', 'rma.order_total_will_changed', 'The order total will be set to'),
('en', 'rma.shipping_costs_will_changed', 'Shipping costs will be set to'),
('en', 'rma.return_action', 'Return'),
('en', 'blog.new_post', 'New blog post'),
('en', 'blog.editing_post', 'Editing blog post'),
('en', 'blog', 'Blog'),
('en', 'blog.add_post', 'Add blog post'),
('en', 'blog.recent_posts', 'Blog: recent posts'),
('en', 'blog.recent_posts_scroller', 'Blog: recent posts scroller'),
('en', 'blog.view_post', 'View post'),
('en', 'recent_blog_posts', 'Recent blog posts'),
('en', 'blog.posts', 'Posts'),
('en', 'blog.post', 'Post'),
('en', 'block_blog', 'Recent posts'),
('en', 'block_vendor_blog', 'Vendor recent posts'),
('en', 'blog.text_links', 'Blog: text links'),
('en', 'blog.read_more', 'Read more'),
('en', 'post_description', 'Post description'),
('en', 'ttc_post_description', 'Use the &lt;!--CUT--&gt; tag (switch to source code to insert it) to hide part of the post. Only the part above the tag is shown in the list of all posts.<br /><br />Make sure to <strong>close all HTML tags</strong> above the &lt;!--CUT--&gt; tag!'),
('en', 'blog_functionality_notes', '<p>Use this page to manage your blog. This is how you should organize your blog posts:</p><ul><li>Blog is a usual post that has the <b>Root level page</b> as the Parent page.</li><li>Choose <b>Blog</b> as the Parent page for your blog posts.</li></ul>'),
('en', 'n_posts', '[n] post|[n] posts'),
('en', 'sort_by_bestsellers_asc', 'Sort by Bestselling: Low to High'),
('en', 'sort_by_bestsellers_desc', 'Sort by Bestselling'),
('en', 'sort_by_on_sale_asc', 'Sort by discount: Low to High'),
('en', 'sort_by_on_sale_desc', 'Sort by discount: High to Low'),
('en', 'sales_amount', 'Sales amount'),
('en', 'bestselling', 'Bestselling'),
('en', 'on_sale', 'On sale'),
('en', 'similar', 'Similar'),
('en', 'percent_range', 'Price range (in % of the main product''s price)'),
('en', 'similar_category', 'Of the same category'),
('en', 'similar_subcats', 'Consider subcategories'),
('en', 'similar_in_stock', 'Only “in stock” products'),
('en', 'final_sale', 'Final sale'),
('en', 'seo.actions.redirects_manager', '301 redirects'),
('en', 'controller_description', 'If you want to specify a SEO-name for the URL, e.g. http://example.com/index.php?dispatch=<b>categories.catalog</b>, you need to enter the "<b>categories.catalog</b>" value into the "<b>The value of the "dispatch" parameter from the URL</b>" field and specify the SEO name in the "<b>SEO name</b>" field.'),
('en', 'seo_name', 'SEO name'),
('en', 'warning_seo_urls_disabled', 'SEO-friendly URLs are disabled. Check your web server and URL manipulation engine settings.'),
('en', 'dispatch_value', 'Dispatch value'),
('en', 'url_dispatch_part', 'The value of the "dispatch" parameter from the URL'),
('en', 'new_rule', 'New rule'),
('en', 'seo_add_rule', 'Add rule'),
('en', 'seo_rules', 'SEO rules'),
('en', 'seo_page_title', 'page [n]'),
('en', 'privileges.manage_seo_rules', 'Can edit'),
('en', 'privilege_groups.seo', 'SEO'),
('en', 'privileges.view_seo_rules', 'Can view'),
('en', 'seo.redirects_manager', '301 redirects'),
('en', 'seo.old_url', 'Old URL'),
('en', 'seo.new_url', 'New URL'),
('en', 'seo.new_redirect', 'New Redirect'),
('en', 'seo.add_redirect', 'Add redirect'),
('en', 'seo.error_old_url_exists', 'The URL you''re redirecting from is already exist'),
('en', 'seo.rich_snippets', 'Google rich snippets preview'),
('en', 'seo.rich_snippets_rating', 'Rating'),
('en', 'seo.rich_snippets_reviews', '[n] review|[n] reviews'),
('en', 'seo.create_redirect', 'Create redirect from old URL'),
('en', 'seo.error_incorrect_url', 'Incorrect format for <b>[url]</b> URL. For example, if your URL is <b>http://example.com/path/to/object</b>, you need to enter <b>/path/to/object</b>'),
('en', 'tt_addons_seo_views_seo_redirects_manage_seo.old_url', 'For example, if your URL is <b>http://example.com/path/to/object</b>, you need to enter <b>/path/to/object</b>'),
('en', 'seo.important_language_text', '<b>Warning!</b> The <b>SEO</b> add-on is currently configured to use a single URL for all languages. If you hide, disable, or delete a default language of one of the storefronts, the SEO URLs will be changed.'),
('en', 'seo.product_feature.feature_code.notice', 'A suitable code can help this feature appear with the product in search engines. Supported codes:'),
('en', 'seo.brand', 'Brand'),
('en', 'seo.feature_code.brand.description', 'Name used by an organization or business person for labeling a product'),
('en', 'seo.isbn', 'ISBN'),
('en', 'seo.feature_code.isbn.description', 'International Standard Book Number'),
('en', 'seo.gtin', 'GTIN'),
('en', 'seo.feature_code.gtin.description', 'Global Trade Item Number'),
('en', 'seo.MPN', 'MPN'),
('en', 'seo.feature_code.mpn.description', 'Manufacturer Part Number'),
('en', 'seo.storefront_frontend_default_language_warning', 'The <a href="[link]">SEO</a> add-on is currently configured to use a single URL for all languages. If you change a default language of this storefront, the SEO URLs will be changed.'),
('en', 'seo.secondary_storefront_frontend_default_language_warning', 'The <a href="[link]">SEO</a> add-on is currently configured to use a single URL for all languages using the default language of the default storefront. If you change the default language of the selected storefront, the SEO URLs will not be changed.'),
('en', 'seo.default_storefront_frontend_default_language_warning', 'The <a href="[link]">SEO</a> add-on is currently configured to use a single URL for all languages. If you change a default language of the default storefront, the SEO URLs will be changed for all storefronts.'),
('en', 'seo.error_at_creation_seo_name', 'The following SEO name already exists in your store: <b>[names]</b>. <p> The following SEO name was used instead: <b>[new_names]</b>.|The following SEO names already exist in your store: <b>[names]</b>. The following SEO names were used instead: <b>[new_names]</b>.'),
('en', 'seo.error_incorrect_seo_name', 'The following SEO name had incorrect format: <b>[names]</b>. <p> The following SEO name was used instead: <b>[new_names]</b>.|The following SEO names had incorrect format: <b>[names]</b>. The following SEO names were used instead: <b>[new_names]</b>.'),
('en', 'reward_points', 'Reward points'),
('en', 'reward_points_log', 'Reward points log'),
('en', 'promotion_cond_reward_points', 'Points on user account'),
('en', 'points', 'Points'),
('en', 'points_in_use', 'Points in use'),
('en', 'points_in_use_lower', 'points in use'),
('en', 'points_lower', 'points'),
('en', 'points_in_use_lowercase', '[n] point in use|[n] points in use'),
('en', 'points_lowercase', '[n] point|[n] points'),
('en', 'points_to_use', 'Points to use'),
('en', 'point_payment', 'Point payment'),
('en', 'point_price', 'Price in points'),
('en', 'text_increase_points_in_use', 'The points used in the order were added to user account.'),
('en', 'text_points_used_in_order', 'Points were used in order'),
('en', 'text_point_in_account', 'You have'),
('en', 'pay_by_points', 'Allow payment by points'),
('en', 'override_per', 'Override global PER'),
('en', 'override_gc_points_brief', 'Override global/category points'),
('en', 'text_points_exceed_points_on_account', 'The number of the points entered by you exceeds the number of points at your account.'),
('en', 'text_points_exceed_points_that_can_be_applied', 'The number of points entered by you exceeds the number of points that can be applied to this order.'),
('en', 'text_points_cannot_applied_because_subtotal_redeemed', 'Points cannot be applied because the subtotal is completely redeemed.'),
('en', 'text_cannot_apply_points_to_this_order_because_total', 'Unfortunately, you cannot apply points to this order, because the total cost is zero.'),
('en', 'text_cannot_apply_points_to_this_order_because_user', 'Unfortunately, you cannot apply points to this order, because you do not have enough points at the account.'),
('en', 'text_order_status_has_not_been_changed', 'The order status has not been changed, because the user did not have enough points.'),
('en', 'price_in_points_increased', 'Price in points has been increased by'),
('en', 'price_in_points_decreased', 'Price in points has been decreased by'),
('en', 'earned_points', 'Points earned per product'),
('en', 'override_g_points', 'Override global point value for all products in this category'),
('en', 'amount_type', 'Amount type'),
('en', 'maximum', 'Maximum'),
('en', 'earned_point_modifier', 'Earned point modifier'),
('en', 'override_gc_points', 'Override global/category point value for this product'),
('en', 'view_user_points', 'View user points'),
('en', 'log', 'Log'),
('en', 'subtract', 'Subtract'),
('en', 'change_points', 'Change points'),
('en', 'add_subtract_points', 'Add & subtract points'),
('en', 'cleanup_log', 'Cleanup log'),
('en', 'we_would_like_to_inform', 'We would like to inform you that'),
('en', 'reward_points_subj_added_to', '[n] point have been added to your account.|[n] points have been added to your account.'),
('en', 'reward_points_subj_subtracted_from', '[n] point have been subtracted from your account.|[n] points have been subtracted from your account.'),
('en', 'privileges.manage_reward_points', 'Can edit'),
('en', 'privilege_groups.reward_points', 'Reward points'),
('en', 'email_template.reward_points_notification', 'Reward points'),
('en', 'grant_point', 'Grant reward points'),
('en', 'google_analytics.google_analytics_cookies_title', 'Google Analytics'),
('en', 'google_analytics.google_analytics_cookies_description', 'Google Analytics is a service that provides us with website analytics: the number of unique visitors, the most and least popular pages, etc. Here is <a href="https://support.google.com/analytics/answer/6004245" target="_blank">Google Analytics statement on privacy</a>.'),
('en', 'google_analytics.google_ads_cookies_title', 'Google Ads'),
('en', 'google_analytics.google_ads_cookies_description', 'Google Ads is a service that allows us to make personalized offers for you. This permission allows us to set cookies and send some of your data related to advertising to Google. Here is <a href="https://safety.google/privacy/ads-and-data/" target="_blank">how Google handles ad-related data</a>.'),
('en', 'facebook_pixel.facebook_pixel_cookies_title', 'Facebook Pixel'),
('en', 'facebook_pixel.facebook_pixel_cookies_description', 'Facebook Pixel is a tool that allows us to measure ad efficiency by tracking that the browser or device that received the ad also visited a product page, added product to cart, or placed an order. Here is <a href="https://www.facebook.com/about/privacy/previous" target="_blank">Facebook privacy policy</a>.'),
('en', 'privileges.manage_call_requests', 'Can edit'),
('en', 'privileges.view_call_requests', 'Can view'),
('en', 'privilege_groups.call_requests', 'Call requests'),
('en', 'call_requests', 'Call requests'),
('en', 'call_requests.request_call', 'Request call'),
('en', 'call_requests.buy_now_with_one_click', 'Buy now with 1-click'),
('en', 'call_requests.error_validate_call_form', 'Please enter your email or phone number'),
('en', 'call_requests.request_recieved', 'We have received your request! Our manager will contact you soon.'),
('en', 'call_requests.order_placed', 'We have received your request! The order #[order_id] has been successfully created. Our manager will contact you soon.'),
('en', 'call_requests.phone_from_settings', 'Phone from settings'),
('en', 'call_requests.enter_phone_or_email_text', 'Please enter your phone number or email (for our manager to contact you)'),
('en', 'call_requests.status.new', 'New'),
('en', 'call_requests.status.in_progress', 'In progress'),
('en', 'call_requests.status.completed', 'Completed'),
('en', 'call_requests.status.no_answer', 'No answer'),
('en', 'call_requests.responsible', 'Responsible'),
('en', 'call_requests.notes', 'Notes'),
('en', 'call_requests.requested_product', 'Requested product'),
('en', 'call_requests.convenient_time', 'Convenient time'),
('en', 'call_requests.awaiting_call', 'Awaiting call'),
('en', 'call_requests.order_exists', 'Order exists'),
('en', 'call_requests.person_name_and_phone', 'Name and phone'),
('en', 'call_requests.no_name_specified', 'No name specified');
INSERT INTO `[[dbprefix]]language_values` VALUES
('en', 'call_requests.use_for_call_requests', 'Call request and buy now with one click form'),
('en', 'block_call_request', 'Call request'),
('en', 'block_call_request_description', 'Store phone number and form for requesting a call'),
('en', 'tmpl_call_request', 'Call request form'),
('en', 'call_requests.text_call_request', 'Customer [customer] is <a href="[href]">awaiting your call</a> on [phone_number].'),
('en', 'call_requests.text_call_request_call_time', 'The convenient call time is between [time_from] and [time_to].'),
('en', 'call_requests.text_buy_with_one_click_request', 'Сustomer [customer] is <a href="[href]">awaiting your call</a> on [phone_number], regarding the purchase of the product <a href="[product_href]">[product_name]</a>.'),
('en', 'call_requests.error_validator_phone', 'The phone number in the <b>[field]</b> field is invalid.'),
('en', 'email_template.call_requests_buy_with_one_click', 'Call requests: buy with one click notification'),
('en', 'email_template.call_requests_call_request', 'Call requests: call request notification'),
('en', 'call_request.work_time', 'Mon-Fr 9a.m.-6p.m.'),
('en', 'call_requests.request_call_request_form', 'Call requests: request form'),
('en', 'call_requests.agreement_text_full_request_call_request_form', '<p>We ([company]) will use the data you provide here to contact you regarding your call request or order. That data will remain in our system, visible to our staff (or the relevant vendor), until you withdraw your consent. If you’d like to have your personal data removed, send an email to [email].</p> <p>If you believe that your personal data has been misused, you have the right to lodge a complaint with a supervisory authority. We’re obliged by EU General Data Protection Regulation to let you know about this right; we don’t actually intend to misuse your data.</p>'),
('en', 'call_requests.agreement_text_short_request_call_request_form', 'I agree to have my personal data <u>processed as follows.</u>'),
('en', 'gdpr_call_requests', 'Personal data from call requests'),
('en', 'call_requests.event.request_created.name', 'Call requests: request created'),
('en', 'call_requests.event.request_about_product_created.name', 'Call requests: request about product created'),
('en', 'call_requests.dashboard.analytics_card.recent_call_requests', 'Recent call requests'),
('en', 'call_requests.dashboard.analytics_card.view_call_requests', 'View call requests'),
('en', 'use_for_form_builder', 'Custom forms'),
('en', 'new_form', 'New form'),
('en', 'editing_form', 'Editing form'),
('en', 'form_builder', 'Form builder'),
('en', 'form_submit_text', 'Form submit text'),
('en', 'email_to', 'E-mail to'),
('en', 'add_form', 'Add form'),
('en', 'base', 'Base'),
('en', 'multiple_checkboxes', 'Multiple checkboxes'),
('en', 'multiple_selectbox', 'Multiple selectbox'),
('en', 'separator', 'Separator'),
('en', 'special', 'Special'),
('en', 'countries_list', 'Countries list'),
('en', 'states_list', 'States list'),
('en', 'referer', 'Referer'),
('en', 'email_template.form_builder_form', 'Contact form'),
('en', 'addons.form_builder.form_fields', 'Form fields'),
('en', 'addons.form_builder.form_name', 'Form name'),
('en', 'addons.form_builder.other_subject', 'Other subject (specify below)'),
('en', 'addons.form_builder.email_subject_field', 'E-mail subject field'),
('en', 'ttc_addons.form_builder.email_subject_field', 'Fields of type "Select box" or "Input field" can be used'),
('en', 'please_enable_the_add_on_to_see_barcode', 'Please enable the add-on to see a code example.'),
('en', 'use_for_polls', 'Polls'),
('en', 'tmpl_polls_central', 'Central'),
('en', 'tmpl_polls_side', 'Side box'),
('en', 'polls_answers_with_comments', 'Answers with comments'),
('en', 'polls_have_completed', 'You have already completed this poll.'),
('en', 'polls_total_votes', 'Total votes'),
('en', 'polls', 'Polls'),
('en', 'new_poll', 'New poll'),
('en', 'editing_poll', 'Editing poll'),
('en', 'text_you_have_already_filled_this_poll', 'You have already completed this poll'),
('en', 'block_polls', 'Polls'),
('en', 'poll', 'Poll'),
('en', 'questions', 'Questions'),
('en', 'poll_statistics', 'Poll statistics'),
('en', 'add_polls_and_close', 'Add polls and close'),
('en', 'add_polls', 'Add polls'),
('en', 'required_not_answered', 'You should answer all the mandatory questions'),
('en', 'thanks_for_voting', 'Thank you for taking time to complete this poll.'),
('en', 'poll_show_results', 'Poll results visible to'),
('en', 'poll_results_nobody', 'nobody'),
('en', 'poll_results_voted', 'voted users'),
('en', 'poll_results_everybody', 'everybody (in a pop-up)'),
('en', 'poll_header', 'Poll header'),
('en', 'poll_footer', 'Poll footer'),
('en', 'poll_results', 'Poll message'),
('en', 'new_question', 'New question'),
('en', 'add_question', 'Add question'),
('en', 'editing_question', 'Editing question'),
('en', 'add_poll', 'Add poll'),
('en', 'polls_total_submited', 'Total number of submitted poll forms'),
('en', 'polls_total_completed', 'Number of poll forms completed in full'),
('en', 'polls_first_submited', 'First poll form submitted'),
('en', 'polls_last_submited', 'Last poll form submitted'),
('en', 'statistics_by_questions', 'Statistics by questions'),
('en', 'view_answers', 'View answers'),
('en', 'polls_votes', 'Votes'),
('en', 'answers', 'Answers'),
('en', 'question_text', 'Question text'),
('en', 'select_single_type', 'Select single option'),
('en', 'select_one_or_more_type', 'Select one or more options'),
('en', 'text_answer_type', 'Provide a textual answer'),
('en', 'answer_text', 'Answer text'),
('en', 'text_box', 'Text box'),
('en', 'tt_addons_polls_hooks_pages_tabs_content_post_poll_results', 'Message that is displayed in the storefront after the poll is completed.'),
('en', 'n_polls', '[n] poll|[n] polls'),
('en', 'access_restrictions', 'Access restrictions'),
('en', 'add_ips', 'Add IPs'),
('en', 'new_ips', 'New IPs'),
('en', 'add_domains', 'Add domains'),
('en', 'new_domains', 'New domains'),
('en', 'add_emails', 'Add e-mail addresses'),
('en', 'new_emails', 'New e-mail addresses'),
('en', 'new_credit_card', 'New credit card'),
('en', 'add_credit_card', 'Add credit card'),
('en', 'privileges.manage_access_restrictions', 'Can edit'),
('en', 'privilege_groups.access_restrictions', 'Access restrictions'),
('en', 'domain', 'Domain'),
('en', 'warning_of_ip_adding', 'The entered IP address <b>[entered_ip]</b> forbids access to the administration panel from your computer (your IP is <b>[your_ip]</b>).'),
('en', 'text_cc_number_is_blocked', 'The credit card number <b>[cc_number]</b> is blocked by the administrator. Please contact the store administrator or try another one.'),
('en', 'text_not_valid_ip', '<b>[ip]</b> is not a valid ip address.'),
('en', 'text_not_valid_domain', '<b>[domain]</b> is not a valid domain name.'),
('en', 'text_not_valid_cc_number', '<b>[cc_number]</b> is not a valid credit card number.'),
('en', 'text_email_is_blocked', 'The e-mail address <b>[email]</b> is blocked by the administrator. Please contact the store administrator or try another one.'),
('en', 'text_ips_denied', 'You are not allowed to access this area'),
('en', 'text_ip_blocked_failed_login', 'The IP was blocked after [number] unsuccessful logins'),
('en', 'text_ip_is_blocked', 'Your IP address is blocked.'),
('en', 'store_admin', 'Store administrator'),
('en', 'your_ip_added', 'Your IP address <b>[ip]</b> has been added to the access restrictions table.'),
('en', 'your_ip_enabled', 'Your IP address <b>[ip]</b> has been enabled in the access restrictions table.'),
('en', 'your_ip_removed', 'Your IP address <b>[ip]</b> has been removed from the access restrictions table.'),
('en', 'ip_from', 'IP from'),
('en', 'ip_to', 'IP to'),
('en', 'text_access_notice', 'You can use the wildcards for the "Domain", "E-mail" and "Credit Card" tabs: <br /><b>*</b> - can represent any number of characters, including zero<br /><b>?</b> - can represent any single character.'),
('en', 'ips', 'IPs'),
('en', 'make_permanent', 'Make permanent'),
('en', 'credit_card_number', 'Credit card number'),
('en', 'banners.new_banner', 'New banner'),
('en', 'banners.editing_banner', 'Editing banner'),
('en', 'add_banner', 'Add banner'),
('en', 'banner', 'Banner'),
('en', 'banners', 'Banners'),
('en', 'banner_code', 'Banner code'),
('en', 'banner_code_for_some_products', 'Banner code for some products'),
('en', 'manage_banners', 'Manage banners'),
('en', 'block_banners', 'Banners'),
('en', 'block_banners_description', 'Visual and text banners'),
('en', 'privileges.view_banners', 'Can view'),
('en', 'privileges.manage_banners', 'Can edit'),
('en', 'privilege_groups.banners', 'Banners'),
('en', 'add_banners', 'Add banners'),
('en', 'add_banners_and_close', 'Add banners and close'),
('en', 'graphic_banner', 'Graphic banner'),
('en', 'text_banner', 'Text banner'),
('en', 'conversion', 'Conversion'),
('en', 'banner_details_notes', 'After you create a banner here, you should use the <strong>Layout editor</strong> to add it to the storefront.<br /><br />Go to <a href="[layouts_href]" target="_blank">Design → Layouts</a>, switch to the location where you want the banner to appear, and add a new block with type <strong>Banners</strong>.<br /><br />In this block settings, go to the <strong>Content</strong> tab, pick the <strong>Manual</strong> filling, and click on the <strong>Add banners</strong> button.<br /><br />You will see the list of all the banners in your store. Pick the one(s) you need and click on the <strong>Add banners and close</strong> button.<br /><br />Finally, click on the <strong>Create</strong> button to save your changes.'),
('en', 'n_banners', '[n] banner|[n] banners'),
('en', 'use_for_discussion', 'Comments and reviews forms'),
('en', 'discussion_title_category', 'Reviews'),
('en', 'discussion_title_giftreg', 'Guestbook'),
('en', 'discussion_title_order', 'Communication'),
('en', 'discussion_title_page', 'Comments'),
('en', 'discussion_title_product', 'Reviews'),
('en', 'discussion_title_return', 'Communication'),
('en', 'no_posts_found', 'No posts found'),
('en', 'your_rating', 'Your rating'),
('en', 'comments_and_reviews', 'Comments and reviews'),
('en', 'discussion.comments_and_reviews_menu', 'Comments'),
('en', 'discussion_title_home_page', 'Testimonials'),
('en', 'text_enabled_testimonials_notice', 'Testimonials are disabled. To enable, please go to <a href="[link]">Comments and reviews: options</a> and select the "Communication", "Rating" or "Communication and Rating" value in "Testimonials" field.'),
('en', 'discussion_title_company', 'Reviews'),
('en', 'communication_and_rating', 'Communication and Rating'),
('en', 'communication', 'Communication'),
('en', 'cant_find_thread', 'Thread can not be found.'),
('en', 'error_already_posted', 'You have posted in this discussion already'),
('en', 'text_thank_you_for_post', 'Thank you for your post'),
('en', 'text_post_pended', 'Your post will be checked before it gets published.'),
('en', 'discussion', 'Comments and reviews'),
('en', 'text_new_post_notification', 'This is a notification of a new post to'),
('en', 'text_approval_notice', 'This post needs approving'),
('en', 'latest_reviews', 'Latest comments & reviews'),
('en', 'comment_by', 'Comment by'),
('en', 'and', 'and'),
('en', 'add_post', 'Add post'),
('en', 'not_approved', 'Not approved'),
('en', 'discussion_manager', 'Comments and reviews'),
('en', 'testimonials', 'Testimonials'),
('en', 'privileges.view_discussions', 'Can view'),
('en', 'privileges.manage_discussions', 'Can edit'),
('en', 'privilege_groups.discussions', 'Comments and reviews'),
('en', 'block_testimonials', 'Testimonials'),
('en', 'block_testimonials_description', 'User testimonials'),
('en', 'sort_by_rating_asc', 'Sort by rating: Low to High'),
('en', 'sort_by_rating_desc', 'Sort by rating'),
('en', 'reviews', 'review|reviews'),
('en', 'write_review', 'Write a review'),
('en', 'discussion_tab_products', 'Product Reviews'),
('en', 'discussion_tab_categories', 'Category Reviews'),
('en', 'discussion_tab_pages', 'Page Comments'),
('en', 'discussion_tab_orders', 'Order Communication'),
('en', 'discussion_tab_home_page', 'Testimonials'),
('en', 'discussion_tab_companies', 'Company Reviews'),
('en', 'email_template.discussion_notification', 'Comments and reviews notification'),
('en', 'show_rating', 'Show review rating'),
('en', 'gdpr_discussions_data', 'Personal data from discussion'),
('en', 'discussion.add_new_review', 'Discussion: new review'),
('en', 'discussion.agreement_text_full_add_new_review', '<p>Your name will appear next to your review or comment, visible to everyone. We ([company]) also save your IP address as a security precaution, but in can only be viewed by our staff. It will remain in our system until you withdraw your consent. If you’d like to have your personal data removed, send an email to [email].</p> <p>If you believe that your personal data has been misused, you have the right to lodge a complaint with a supervisory authority. We’re obliged by EU General Data Protection Regulation to let you know about this right; we don’t actually intend to misuse your data.</p>'),
('en', 'discussion.agreement_text_short_add_new_review', 'I agree to have my personal data <u>processed as follows.</u>'),
('en', 'discussion.please_log_in_to_write_a_review', 'Please sign in to write a review'),
('en', 'discussion.you_have_to_buy_product_before_writing_review', 'You can''t write a review for this product. Customers can write reviews only for the products they bought. If you actually bought this product from us, but are still seeing this message, please contact us.'),
('en', 'discussion.you_have_to_buy_from_vendor_before_writing_review', 'You can''t write a review for this vendor. Customers can write reviews for a vendor only after they buy something from that vendor. If you actually placed an order with this vendor, but are still seeing this message, please contact us.'),
('en', 'discussion.event.products.new_post', 'Products: new review posted'),
('en', 'discussion.event.testimonials.new_post', 'Testimonials: new review posted'),
('en', 'discussion.event.orders.new_post', 'Order communication: new message added'),
('en', 'discussion.event.categories.new_post', 'Categories: new review posted'),
('en', 'discussion.event.pages.new_post', 'Pages: new comment posted'),
('en', 'discussion.event.vendors.new_post', 'Vendors: new review posted'),
('en', 'wt_watermarks', 'Watermarks'),
('en', 'wt_graphic_watermark', 'Graphic watermark'),
('en', 'wt_text_watermark', 'Text watermark'),
('en', 'wt_watermark_vertical_position', 'Watermark vertical position'),
('en', 'wt_watermark_horizontal_position', 'Watermark horizontal position'),
('en', 'wt_watermark_position', 'Watermark position'),
('en', 'wt_watermark_image', 'Watermark image'),
('en', 'wt_watermark_text', 'Watermark text'),
('en', 'wt_font', 'Font'),
('en', 'wt_font_color', 'Font color'),
('en', 'wt_font_size_icon', 'Font size (thumbnail)'),
('en', 'wt_font_size_detailed', 'Font size (larger image)'),
('en', 'wt_watermark_icon', 'Thumbnail watermark'),
('en', 'wt_watermark_detailed', 'Popup larger image watermark'),
('en', 'wt_fail_apply_graphic_watermark', 'Failed to apply the watermark to [image_type]. The watermark image is not added.'),
('en', 'wt_icons', 'thumbnails'),
('en', 'wt_detailed', 'popup larger images'),
('en', 'wt_images_access_description', 'To deny access to your original images, please add the following instructions to the ''.htaccess'' file in the ''images'' directory of your installation. It will protect your original images. Even if an original image is opened, the corresponding watermarked image will be show instead.'),
('en', 'wt_watermarks_access_description', 'To generate watermarked images automatically even if they are requested not from your store pages, please add the ''.htaccess'' file with the following instructions to the ''images/watermarked'' directory of your installation.'),
('en', 'wt_access_note', 'Please note, if you disable or uninstall the ''Watermarks'' add-on, you should remove these instructions from ''.htaccess'' files manually. Otherwise category and product images will be unavailable.'),
('en', 'wt_access_warning', 'Watermark creating is disabled. If there are any "Rewrite watermarks rules" instructions in the "images/.htaccess" file, you should remove them manually. Otherwise category and product images will be unavailable.'),
('en', 'wt_images_access_info', 'Images access'),
('en', 'product_reviews.use_for_reviews', 'Comments and reviews forms'),
('en', 'product_reviews.title_giftreg', 'Guestbook'),
('en', 'product_reviews.title', 'Reviews'),
('en', 'product_reviews.no_reviews_found', 'No reviews found'),
('en', 'product_reviews.your_rating', 'Your rating'),
('en', 'product_reviews.comments_and_reviews', 'Comments and reviews'),
('en', 'product_reviews.rating', 'Rating'),
('en', 'product_reviews.date', 'Date'),
('en', 'product_reviews.error_already_posted', 'You have posted in this review already'),
('en', 'product_reviews.text_thank_you_for_post', 'Thank you for your post'),
('en', 'product_reviews.text_review_pended', 'Your review will be checked before it gets published.'),
('en', 'product_reviews.reviews', 'Reviews: [n]'),
('en', 'product_reviews.n_reviews', 'review|reviews'),
('en', 'product_reviews.text_new_post_notification', 'This is a notification of a new post to product'),
('en', 'product_reviews.text_new_reply_notification', 'This is a notification of a new reply to your product review'),
('en', 'product_reviews.text_approval_notice', 'This review needs approving'),
('en', 'product_reviews.latest_reviews', 'Latest reviews'),
('en', 'product_reviews.comment_by', 'Comment by'),
('en', 'product_reviews.and', 'and'),
('en', 'product_reviews.approve', 'Approve'),
('en', 'product_reviews.disapprove', 'Disapprove'),
('en', 'product_reviews.approved', 'Approved'),
('en', 'product_reviews.not_approved', 'Not approved'),
('en', 'product_reviews.manager', 'Comments and reviews'),
('en', 'privileges.view_product_reviews', 'Can view'),
('en', 'privileges.manage_product_reviews', 'Can edit'),
('en', 'privilege_groups.product_reviews', 'Product reviews'),
('en', 'product_reviews.product_reviews', 'Product reviews'),
('en', 'product_reviews.menu_title', 'Reviews'),
('en', 'product_reviews.write_review', 'Write a review'),
('en', 'email_template.product_reviews_notification', 'Product reviews: New review notification'),
('en', 'email_template.product_reviews_reply_notification', 'Product reviews: Reply notification'),
('en', 'product_reviews.show_rating', 'Show review rating'),
('en', 'product_reviews.show_reviews', 'Show reviews'),
('en', 'product_reviews.show_review', 'Show review'),
('en', 'product_reviews.show_n_reviews', 'Show [n] review|Show [n] reviews'),
('en', 'product_reviews.scroll_to_reviews', 'Scroll to reviews'),
('en', 'product_reviews.show_review_images', 'Show review images'),
('en', 'product_reviews.scroll_to_review_images', 'Scroll to review images'),
('en', 'gdpr_product_reviews', 'Personal data from reviews'),
('en', 'product_reviews.add_new_review', 'reviews: new review'),
('en', 'product_reviews.agreement_text_full_add_new_review', '<p>Your name will appear next to your review or comment, visible to everyone. We ([company]) also save your IP address as a security precaution, but in can only be viewed by our staff. It will remain in our system until you withdraw your consent. If you’d like to have your personal data removed, send an email to [email].</p> <p>If you believe that your personal data has been misused, you have the right to lodge a complaint with a supervisory authority. We’re obliged by EU General Data Protection Regulation to let you know about this right; we don’t actually intend to misuse your data.</p>'),
('en', 'product_reviews.terms_n_conditions', 'Select this check box to accept the [terms_href]'),
('en', 'product_reviews.terms_n_conditions_name', 'Terms and Conditions'),
('en', 'product_reviews.terms_and_conditions_content', '<p>Please read these Terms and Conditions ("Terms", "Terms and Conditions") carefully before using the <a href="http://www.mywebsite.com">http://www.mywebsite.com</a> website and the My Mobile App mobile application (the "Service") operated by My Company ("us", "we", or "our").</p><p><strong>By accessing or using the Service you agree to be bound by these Terms. If you disagree with any part of the Terms then you may not access the Service.</strong></p><p><strong>Purchases</strong></p><p>If you wish to purchase any product or service made available through the Service ("Purchase"), you may be asked to supply certain information relevant to your Purchase including, without limitation, your ...</p><p><strong>Content</strong></p><p>Our Service allows you to post, link, store, share and otherwise make available certain information, text, graphics, videos, or other material ("Content"). You are responsible for the ...</p><p><strong>Changes</strong></p><p>We reserve the right, at our sole discretion, to modify or replace these Terms at any time. If a revision is material we will try to provide at least 30 days'' notice prior to any new terms taking effect. What constitutes a material change will be determined at our sole discretion.</p><p><strong>Contact Us</strong></p><p>If you have any questions about these Terms, please contact us.</p>'),
('en', 'product_reviews.moderation_rules', 'Before submitting a review, make sure that it does not violate the moderation rules: it does not contain links to third-party resources and insults.'),
('en', 'product_reviews.agreement_text_short_add_new_review', 'I agree to have my personal data <u>processed as follows.</u>'),
('en', 'product_reviews.please_log_in_to_write_a_review', 'Please sign in to write a review'),
('en', 'product_reviews.you_have_to_buy_product_before_writing_review', 'You can''t write a review for this product. Customers can write reviews only for the products they bought. If you actually bought this product from us, but are still seeing this message, please contact us.'),
('en', 'product_reviews.event.new_post', 'New review posted'),
('en', 'product_reviews.event.new_reply', 'New reply was added to review'),
('en', 'product_reviews.helpfulness', 'Helpfulness'),
('en', 'product_reviews.vote_up', 'Vote up'),
('en', 'product_reviews.vote_down', 'Vote down'),
('en', 'sort_by_product_review_timestamp_desc', 'Sort by date: Newest to Oldest'),
('en', 'sort_by_product_review_timestamp_asc', 'Sort by date: Oldest to Newest'),
('en', 'sort_by_helpfulness_asc', 'Helpful last'),
('en', 'sort_by_helpfulness_desc', 'Helpful first'),
('en', 'sort_by_rating_value_desc', 'Sort by rating: High to Low'),
('en', 'sort_by_rating_value_asc', 'Sort by rating: Low to High'),
('en', 'product_reviews.advantages', 'Advantages'),
('en', 'product_reviews.disadvantages', 'Disadvantages'),
('en', 'product_reviews.comments', 'Comments'),
('en', 'product_reviews.comment', 'Comment'),
('en', 'product_reviews.disabled', 'Disabled'),
('en', 'product_reviews.vendor', 'Vendor'),
('en', 'product_reviews.vendor_reply', 'Vendor reply'),
('en', 'product_reviews.type_message', 'Type a message...'),
('en', 'product_reviews.verified_purchase', 'Verified purchase'),
('en', 'product_reviews.reviews_lower', 'reviews'),
('en', 'product_reviews.review', 'Review'),
('en', 'product_reviews.write_your_review', 'Write your review'),
('en', 'product_reviews.add_images', 'Add a photo'),
('en', 'product_reviews.write_review_anonymously', 'Write your review anonymously'),
('en', 'product_reviews.submit_review', 'Submit review'),
('en', 'product_reviews.with_photo', 'With photo'),
('en', 'product_reviews.without_photo', 'Without photo'),
('en', 'product_reviews.customer_photos', 'Customer photos'),
('en', 'product_reviews.review_status', 'Review status'),
('en', 'product_reviews.star', 'star'),
('en', 'product_reviews.stars', 'stars'),
('en', 'product_reviews.n_stars', '[n] star|[n] stars'),
('en', 'product_reviews.out_of_five', 'out of 5'),
('en', 'product_reviews.review_this_product', 'Review this product'),
('en', 'product_reviews.review_this_product_description', 'Share your thoughts with other customers'),
('en', 'product_reviews.reply', 'Reply'),
('en', 'product_reviews.first_and_last_name', 'First and last name'),
('en', 'product_reviews.text_thank_you_for_review', 'Thank you for your review'),
('en', 'product_reviews.excellent', 'Excellent!'),
('en', 'product_reviews.very_good', 'Very Good'),
('en', 'product_reviews.average', 'Average'),
('en', 'product_reviews.fair', 'Fair'),
('en', 'product_reviews.poor', 'Poor'),
('en', 'product_reviews.five_star_icon', '★★★★★'),
('en', 'product_reviews.four_star_icon', '★★★★'),
('en', 'product_reviews.three_star_icon', '★★★'),
('en', 'product_reviews.two_star_icon', '★★'),
('en', 'product_reviews.one_star_icon', '★'),
('en', 'product_reviews.product_details', 'Product details'),
('en', 'product_reviews.rating_4_and_up', 'Rating 4+'),
('en', 'product_reviews.event.new_post.title', 'New review posted for a product'),
('en', 'product_reviews.event.new_post.message', 'A new review has been posted for product [product]. Click this notification to see the review.'),
('en', 'product_reviews.copy_old_reviews_warning', 'You have product reviews in the old "Comments and reviews" add-on. While that add-on is installed, you''ll be able copy those reviews to the new "Product reviews" add-on <a class="cm-post" href="[url]">in its settings</a>.'),
('en', 'product_reviews.copy_old_reviews_notice', '<h4 class="subheader hand" data-toggle="collapse" data-target="#collapsable_addon_product_reviews_notice">Copy reviews from the "Comments and reviews" add-on<span class="icon-caret-down"></span></h4><div id="collapsable_addon_product_reviews_notice" class="in collapse" style="height: auto;"><ol><li>Only reviews that have both a score and a user''s comment will be copied. Go to your products and check the “Reviews" setting on the "Add-ons" tab. You might have to allow communication and rating first.</li><li>A review without a score or without a comment will not be copied. To transfer it, you must first manually add the missing score or comment by editing the review.</li><li>While the old "Comments and reviews" add-on is installed, the reviews won''t be removed from there. That way, you can choose to move to "Product reviews" whenever all your reviews are ready.</li><li>If you ever need to copy the reviews from the old add-on again in the future, just uninstall and reinstall the "Product reviews" add-on. This will remove all its reviews from the database, and you''ll be able to import the reviews from the "Comments and reviews" add-on again.</li></ol><a class="cm-post btn btn-primary" href="[url]">Copy product reviews</a></div>'),
('en', 'product_reviews.update_reply', 'Update reply'),
('en', 'product_reviews.add_reply', 'Add reply'),
('en', 'product_reviews.max_number_image_message', 'A review can have up to [max_image_number] images.'),
('en', 'product_reviews.uploader_drop_zone_description', 'Drop images here'),
('en', 'product_reviews.uploader_drop_zone_info', 'Photo up to [max_size]'),
('en', 'product_reviews.admin_reply', 'Administrator reply'),
('en', 'product_reviews.company_reply', '[company_name] reply'),
('en', 'product_reviews.hide_name', 'Hide my name in the review'),
('en', 'product_reviews.product_is_rated_n_out_of_five_stars', 'The product is rated [n] out of 5 stars'),
('en', 'product_reviews.click_to_see_reviews', 'Click to see the reviews'),
('en', 'product_reviews.split_reviews_for_variations_as_separate_products', 'Split reviews for variations as separate products'),
('en', 'privileges.create_product_reviews', 'Can create'),
('en', 'product_reviews.upgrade_notification.title_administators_add_ability_create_product_reviews', 'Administrators can now create product reviews'),
('en', 'product_reviews.upgrade_notification.message_administators_add_ability_create_product_reviews', 'Previously, administrators could edit existing product reviews in the admin panel, but couldn''t post new ones. We''ve changed that: now the administrators who could edit reviews can add new reviews on the "Reviews" tab of the product editing page. Note that this change doesn''t affect vendors'' administrators in CS-Cart Multi-Vendor in any way. The most that they can do is leave a reply to a product review.<br><br>You can keep the old behavior if you''d like. Through user groups, you can now allow administrators to create or edit reviews (or do both of those things).<br><br><a target="_blank" href="[usergroups_url]" class="btn">Set administrator privileges</a>'),
('en', 'product_reviews.exim_error_incorrect_field_value', 'Specified [field] ''[value]'' was not found. The product review with comment ''[comment]'' was skipped.'),
('en', 'product_reviews.exim_error_empty_field', 'The value of the <b>[field]</b> field can not be empty. The product review with comment ''[comment]'' was skipped.'),
('en', 'product_reviews', 'Product reviews'),
('en', 'images_delimiter', 'Images delimiter'),
('en', 'text_images_delimiter', 'Images path delimiter for product review images (e.g. "Image1.png///Image2.png")'),
('en', 'add_to_wishlist', 'Add to wish list'),
('en', 'clear_wishlist', 'Clear wish list'),
('en', 'view_wishlist', 'View wish list'),
('en', 'wishlist_content', 'Wish list content'),
('en', 'wishlist', 'Wish list'),
('en', 'wishlist_short', 'Wish list'),
('en', 'wishlist_note', 'Go to your wishlist'),
('en', 'text_failed_gift_certificate_addition', 'Failed to add the certificate. Make sure the summary amount is not zero.'),
('en', 'text_gift_cert_added_to_wishlist', 'The gift certificate has been added to the wish list'),
('en', 'product_added_to_wl', 'The product was added to your Wish list'),
('en', 'product_in_wishlist', 'This product is already in the wish list'),
('en', 'wishlist_products', 'Wish list products'),
('en', 'google_sitemap.text_regenerate', 'If products, categories, etc. were added or changed, please <a class="cm-ajax cm-comet btn btn-primary" href="[regenerate_url]">Regenerate a sitemap</a><br /><br /> [sitemap_available_in_customer]'),
('en', 'google_sitemap.text_auto_regenerate', 'You can run the regeneration of the site map automatically at certain time intervals. To do it, add the following command to CRON:'),
('en', 'google_sitemap.text_select_storefront', 'To generate a sitemap, please select storefront first.'),
('en', 'sitemap_available_in_customer', 'Sitemap is available by this link: <a href="[sitemap_url]">[sitemap_url]</a><br /><br />Sitemap can be reached by the URL <a href="[http_location]/sitemap.xml">[http_location]/sitemap.xml</a>'),
('en', 'always', 'Always'),
('en', 'hourly', 'Hourly'),
('en', 'daily', 'Daily'),
('en', 'weekly', 'Weekly'),
('en', 'monthly', 'Monthly'),
('en', 'yearly', 'Yearly'),
('en', 'google_sitemap.generate_map', 'The sitemap is not generated yet. Please go to add-on settings and press "Regenerate a sitemap" button'),
('en', 'google_sitemap.map_generated', 'The sitemap was generated successfully'),
('en', 'google_sitemap.export_progress_entry', '[storefront]: [object]'),
('en', 'required_products', 'Required products'),
('en', 'required_products_added', 'The following required product(s) were added to your cart'),
('en', 'required_products_out_of_stock', 'This product cannot be added to your cart, because following required product(s) are out of stock:'),
('en', 'data_feeds', 'Data feeds'),
('en', 'data_feed', 'Data feed'),
('en', 'export_by_cron', 'Export by cron'),
('en', 'export_by_cron_to', 'Export by cron to'),
('en', 'add_new_datafeed', 'New data feed'),
('en', 'add_datafeed', 'Add data feed'),
('en', 'datafeed_name', 'Data feed name'),
('en', 'save_directory', 'Server directory'),
('en', 'ftp_url', 'FTP server'),
('en', 'ftp_url_hint', 'The format is: FTPHOST[:PORT][/DIRECTORY]. Example: ftp.yourhost.com:21/home/username/folder'),
('en', 'ftp_user', 'FTP username'),
('en', 'ftp_pass', 'FTP password'),
('en', 'fields', 'Fields'),
('en', 'field_name', 'Field name'),
('en', 'field_type', 'Field type'),
('en', 'map_fields', 'Fields mapping'),
('en', 'update_datafeed', 'Editing data feed'),
('en', 'datafeed.description', 'Only the products that meet <strong>all</strong> of the conditions below will be exported:'),
('en', 'export_cron_hint', 'Use the following line to run the script according to schedule'),
('en', 'exported_items', 'Exported items'),
('en', 'ftp_connection_problem', 'Unable connect to FTP server. Please, check FTP connection information'),
('en', 'categories_in', 'Categories in'),
('en', 'products_in', 'Products in'),
('en', 'local_export', 'Download'),
('en', 'upload_to_ftp', 'Upload to FTP server'),
('en', 'cron_export', 'Cron export settings'),
('en', 'export_to_server', 'Export to server'),
('en', 'export_to_ftp', 'FTP server options'),
('en', 'ftp', 'FTP'),
('en', 'check_server_export_settings', 'Check server export settings'),
('en', 'exclude_disabled_products', 'Exclude disabled products'),
('en', 'data_feeds.exclude_shared_products', 'Exclude shared products'),
('en', 'general_settings', 'General settings'),
('en', 'enclosure', 'Enclosure'),
('en', 'data_feed.error_exim_no_data_exported', 'No data exported'),
('en', 'data_feeds.text_tooltip_field_name', 'The name of the column in the data feed file.'),
('en', 'data_feeds.text_tooltip_field_type', 'The type of data from your store which will be exported to this column of the data feed file.'),
('en', 'price_list', 'Price list'),
('en', 'generating_pdf', 'Generating PDF. Please, be patient...'),
('en', 'generating_xls', 'Generating XLS. Please, be patient...'),
('en', 'price_list_ziparchive_not_installed', 'Impossible to create XML price list. Please add zip support in PHP on your server. Follow <a href="http://www.php.net/manual/en/zip.installation.php">http://www.php.net/manual/en/zip.installation.php</a>.'),
('en', 'price_list.text_select_storefront', 'To generate a price list, please select storefront first.'),
('en', 'price_list.text_regenerate', '<p>If products, categories or selected fields were added or changed, please regenerate a price list:<br />[buttons]</p><p>Generated price lists are available by these links<br/>[links]</p>'),
('en', 'janrain_general_info', '<p>Get these values and configure social login at <a href="http://janrain.com" target="_blank">janrain.com</a></p>'),
('en', 'janrain_social_login', 'Social login'),
('en', 'janrain_need_update_profile', 'The "Password" field and some other mandatory fields are empty at the moment. Please update your profile.'),
('en', 'janrain_cant_create_profile', 'Unfortunately, we failed to create a customer and log in to the store due to one of the following reasons:<br />- You logged in to our store earlier using some other OpenID provider in which the same email is used.<br />- You have already registered in our store using your email.<br />Please contact the store owner to resolve the problems.'),
('en', 'janrain.janrain_cookies_title', 'Janrain'),
('en', 'janrain.janrain_cookies_description', 'Janrain is a service that allows you to sign into the website with your accounts from various social networks. It was acquired by Akamai in 2019; here is <a href="https://www.akamai.com/site/en/documents/akamai/akamai-privacy-statement.pdf" target="_blank">Akamai privacy statement</a>.'),
('en', 'catalog_mode', 'Catalog Mode'),
('en', 'text_catalog_mode_zero_price_action_notice', 'In order that the "Buy now" button could be displayed on the product details page, please set "Zero price action" as "Allow customers to add the product to cart".'),
('en', 'buy_now_url', 'Buy Now URL'),
('en', 'hybrid_auth_menu_description', 'Connect users via Facebook, Twitter, Google, etc.'),
('en', 'hybrid_auth', 'Social login'),
('en', 'hybrid_auth.linked_provider', 'Linked'),
('en', 'hybrid_auth.not_linked_provider', 'Not linked'),
('en', 'hybrid_auth.providers', 'Providers'),
('en', 'hybrid_auth.add_provider', 'Add provider'),
('en', 'hybrid_auth.new_provider', 'New provider'),
('en', 'hybrid_auth.editing_provider', 'Editing provider'),
('en', 'hybrid_auth.callback_url', 'Callback URL'),
('en', 'hybrid_auth.social_login', 'Or sign-in with another identity provider'),
('en', 'hybrid_auth.unspecified_error', 'Unspecified error'),
('en', 'hybrid_auth.configuration_error', 'Hybriauth configuration error'),
('en', 'hybrid_auth.provider_error_configuration', 'Provider not properly configured'),
('en', 'hybrid_auth.wrong_provider', 'Unknown or disabled provider'),
('en', 'hybrid_auth.missing_credentials', 'Missing provider application credentials'),
('en', 'hybrid_auth.failed_auth', 'Authentication failed. The user has canceled the authentication or the provider refused the connection'),
('en', 'hybrid_auth.connecting_provider', 'Contacting <b>[provider]</b>. Please wait...'),
('en', 'hybrid_auth.cant_create_profile', 'Unfortunately, we failed to create a customer and log in to the store due to one of the following reasons:<br />- You logged in to our store earlier using some other OpenID provider in which the same email is used.<br />- You have already registered in our store using your email.<br />Please contact the store owner to resolve the problems.'),
('en', 'hybrid_auth.password_generated', 'We are glad to inform you that you have been successfully registered in the store. A password was generated for you'),
('en', 'hybrid_auth.change_password', 'You can change your password here'),
('en', 'hybrid_auth.link_provider', 'Social network accounts'),
('en', 'hybrid_auth.text_link_provider', 'Assign your social network account to this one and use it to log in'),
('en', 'hybrid_auth.text_user_is_already_link', 'This social network account is already being used'),
('en', 'hybrid_auth.connect_social', 'Connect social account'),
('en', 'hybrid_auth.connect_social_title', 'Such user already exists'),
('en', 'hybrid_auth.text_connect_social', '<p>The user with the e-mail specified during social login already exists.</p><p>If you want to assign a social network account to the registered user, please log in.</p>'),
('en', 'hybrid_auth.specify_email', 'Specify email'),
('en', 'hybrid_auth.specify_email_title', 'The e-mail was not specified.'),
('en', 'hybrid_auth.text_specify_email', '<p>When logging through the social network the e-mail was not specified.</p><p>Please enter your e-mail and click Continue.</p>'),
('en', 'public_key', 'Public key'),
('en', 'paypal_seamless', 'Use seamless checkout'),
('en', 'paypal_sandbox', 'Test mode'),
('en', 'privileges.manage_providers', 'Can edit'),
('en', 'privileges.view_providers', 'Can view'),
('en', 'privilege_groups.social_login', 'Social login'),
('en', 'hybrid_auth.instruction_facebook', 'Use the application ID and Secret key that you''ve received after creating an application on <a href=''https://developers.facebook.com/apps'' target=''_blank''>Facebook Developers</a>.'),
('en', 'hybrid_auth.instruction_facebook_login', 'Use the application ID and Secret key that you''ve received after creating an application on <a href="https://developers.facebook.com/apps" target="_blank">Facebook Developers</a>. After that copy the value of the <b>Valid OAuth redirect URIs</b> field to the corresponding setting of the <b>Facebook Login</b> product in your Facebook application.'),
('en', 'hybrid_auth.instruction_google', 'Use ID and Secret key that you''ve received after creating a project on <a href=''https://code.google.com/apis/console/?pli=1'' target=''_blank''>Google</a>.'),
('en', 'hybrid_auth.instruction_paypal', 'Use the application ID and Secret key that you''ve received after creating an application on <a href=''https://developer.paypal.com/developer/applications'' target=''_blank''>PayPal Developers</a>.'),
('en', 'hybrid_auth.instruction_twitter', 'Use ID (Consumer key) and Secret key that you''ve received after creating an application on <a href=''https://apps.twitter.com/'' target=''_blank''>Twitter</a>.'),
('en', 'hybrid_auth.instruction_yahoo', 'Use ID (Identificator) and Secret key that you''ve received after creating an application on <a href=''https://developer.yahoo.com/apps/create/'' target=''_blank''>Yahoo</a>.'),
('en', 'hybrid_auth.instruction_live', 'Use the application ID and Secret key that you''ve received after adding an application on <a href=''https://account.live.com/developers/applications/create'' target=''_blank''>Live</a>.'),
('en', 'hybrid_auth.instruction_linkedin', 'Use ID (Consumer key) and Secret key that you''ve received after creating an application on <a href=''https://www.linkedin.com/developer/apps'' target=''_blank''>LinkedIn Developers</a>.'),
('en', 'hybrid_auth.instruction_foursquare', 'Use the application ID and Secret key that you''ve received after creating an application on <a href=''https://foursquare.com/developers/apps'' target=''_blank''>Fousquare</a>.'),
('en', 'email_template.hybrid_auth_create_profile', 'Create user profile via social login'),
('en', 'hybrid_auth.provider_not_found', 'Provider [provider] not found'),
('en', 'hybrid_auth.facebook_oauth_redirect_uris', 'Valid OAuth redirect URIs'),
('en', 'hybrid_auth.live_redirect_urls', 'Redirect URLs'),
('en', 'hybrid_auth.linkedin_api_version', 'API version'),
('en', 'ttc_hybrid_auth.linkedin_api_version', 'LinkedIn <a target="_blank" href="https://docs.microsoft.com/en-us/linkedin/consumer/integrations/self-serve/migration-faq?context=linkedin/consumer/context">deprecated API v1</a>, but old apps still use it. If you''re configuring LinkedIn app for the first time now, use API v2. Old LinkedIn apps configured some time ago may still be using v1.'),
('en', 'hybrid_auth.linkedin_api_v1', 'v1'),
('en', 'hybrid_auth.linkedin_api_v2', 'v2'),
('en', 'hybrid_auth.instruction_paypal_application', 'Use the application ID and Secret key that you''ve received after creating an application on <a href=''https://developer.paypal.com/developer/applications'' target=''_blank''>PayPal Developers</a>. Please enable all Personal Profile scope attributes and at least one scope attribute in Address and in Account Information in your PayPal application settings.'),
('en', 'privileges.manage_zapier_hooks', 'Can edit'),
('en', 'privileges.view_zapier_hooks', 'Can view'),
('en', 'privilege_groups.zapier_hooks', 'Zapier hooks'),
('en', 'zapier.text_settings_general', 'Learn more about setting up integration <a target="_blank" href="[docs_url]user_guide/addons/zapier/index.html">in the documentation</a>.'),
('en', 'price_per_unit', 'Price per unit'),
('en', 'unit_name', 'Unit name'),
('en', 'unit_name_field_description', 'For example, ''ml'' or ''g'' without quotes.'),
('en', 'units_in_product', 'Units in product'),
('en', 'units_in_product_field_description', 'Required for automatic calculation of price per unit.'),
('en', 'show_price_per_x_units', 'Show price per X units'),
('en', 'show_price_per_x_units_field_description', 'For cases when you want to show price ''per 250 ml'' instead of ''per ml''.'),
('en', 'gdpr.gdpr_user_data', 'GDPR user data'),
('en', 'gdpr_user_data', 'User personal data'),
('en', 'gdpr_user_profiles', 'Personal data from user profiles'),
('en', 'gdpr_product_subscriptions', 'Personal data from product subscriptions'),
('en', 'gdpr_agreements', 'Personal data from GDPR agreements'),
('en', 'gdpr.anonymize', 'Anonymize'),
('en', 'gdpr.text_anonymize_question', 'Once you anonymize someone, all their personal information will be replaced with randomly-generated data. This action can not be undone, unless you restore the database from a backup. Are you sure you want to proceed?'),
('en', 'gdpr.view_and_edit', 'View and edit'),
('en', 'gdpr_orders_data', 'Personal data from orders'),
('en', 'gdpr.full_agreement', 'Full agreement text'),
('en', 'gdpr.short_agreement', 'Short agreement text'),
('en', 'gdpr.checkout.place_order.personal_data_processing', 'Checkout: Place order: Personal data processing'),
('en', 'gdpr.checkout.place_order.agreement_text_full_personal_data_processing', '<p>We ([company]) send account-related emails (such as order status notifications, password reset emails, and more) to the provided email address. For that reason we need to store your email address while you remain our customer.</p> <p>We use the information in the billing/shipping address section and may send it to a shipping or payment method provider to:</p> <ul> <li>Determine what shipping and payment methods are available for your location. </li> <li>Complete the payment or shipping process via the provider that you choose at checkout when you submit the order.</li> </ul> <p>Some members of our staff and/or vendors who sell products in our store and use its administration panel may be able to access your data. We value your privacy, so the access to data is provided on a need-to-know basis in order to operate the store. For example, a vendor only receives your data if you ordered something from them, so that the vendor can fulfil that order.</p> <p>If you decide that you no longer want to use our store and would like to have your personal data removed from our database (or if you’d like to get all the personal data associated with your account that we have), please send an email to [email].</p> <p>If you believe that your personal data has been misused, you have the right to lodge a complaint with a supervisory authority. We’re obliged by EU General Data Protection Regulation to let you know about this right; we don’t actually intend to misuse your data.</p>'),
('en', 'gdpr.checkout.place_order.agreement_text_short_personal_data_processing', 'I agree to have my personal data <u>processed as follows.</u>'),
('en', 'gdpr.user.registration.personal_data_processing', 'Customer: registration'),
('en', 'gdpr.user.registration.agreement_text_full_personal_data_processing', '<p>Email addresses distinguish customers from each other. You sign in to the store by entering the email address and the password you provide here.</p> <p>We ([company]) also send account-related emails (such as order status notifications, password reset emails, and more) to the provided email address. For that reason we need to store your email address while you remain our customer.</p> <p>Other profile fields that may or not be present on this page are stored alongside your email address. We may use this information to contact you, if the necessity arises.</p> <p>Some members of our staff and/or vendors who sell products in our store and use its administration panel may be able to access your data. We value your privacy, so the access to data is provided on a need-to-know basis in order to operate the store. For example, a vendor only receives your data if you ordered something from them, so that the vendor can fulfil that order.</p> <p>If you decide that you no longer want to use our store and would like to have your personal data removed from our database (or if you’d like to get all the personal data associated with your account that we have), please send an email to [email].</p> <p>If you believe that your personal data has been misused, you have the right to lodge a complaint with a supervisory authority. We’re obliged by EU General Data Protection Regulation to let you know about this right; we don’t actually intend to misuse your data.</p>'),
('en', 'gdpr.user.registration.agreement_text_short_personal_data_processing', 'I agree to have my personal data <u>processed as follows.</u>'),
('en', 'gdpr.profiles.update.personal_data_processing', 'Profiles: update'),
('en', 'gdpr.profiles.update.agreement_text_full_personal_data_processing', '<p>Email addresses distinguish customers from each other. You sign in to the store by entering the email address and the password you provide here.</p> <p>We ([company]) also send account-related emails (such as order status notifications, password reset emails, and more) to the provided email address. For that reason we need to store your email address while you remain our customer.</p> <p>Other profile fields that may or not be present on this page are stored alongside your email address. We may use this information to contact you, if the necessity arises.</p> <p>We use the information in the billing/shipping address section and may send it to a shipping or payment method provider to:</p> <ul> <li>Determine what shipping and payment methods are available for your location.</li> <li>Complete the payment or shipping process via the provider that you choose at checkout when you submit the order.</li> </ul> <p>Some members of our staff and/or vendors who sell products in our store and use its administration panel may be able to access your data. We value your privacy, so the access to data is provided on a need-to-know basis in order to operate the store. For example, a vendor only receives your data if you ordered something from them, so that the vendor can fulfil that order.</p> <p>If you decide that you no longer want to use our store and would like to have your personal data removed from our database (or if you’d like to get all the personal data associated with your account that we have), please send an email to [email].</p> <p>If you believe that your personal data has been misused, you have the right to lodge a complaint with a supervisory authority. We’re obliged by EU General Data Protection Regulation to let you know about this right; we don’t actually intend to misuse your data.</p> '),
('en', 'gdpr.profiles.update.agreement_text_short_personal_data_processing', 'I agree to have my personal data <u>processed as follows.</u>'),
('en', 'gdpr.vendor.apply.personal_data_processing', 'Vendor: apply for vendor');
INSERT INTO `[[dbprefix]]language_values` VALUES
('en', 'gdpr.vendor.apply.agreement_text_full_personal_data_processing', '<p>Because vendors sell products in our marketplace, we ([company]) have to request certain information about them. For example, the company name and description of a vendor are shown to customers and serve to distinguish vendors from each other; the address is used for shipping rate calculation.</p> <p>However, we also request some personal data, such as first name/last name and emails address. Those are necessary for creating a vendor’s administrator account in our system. Vendors work with the marketplace through such accounts. Email addresses are necessary because they distinguish administrators from each other. You sign in to the store by entering the email address you provide here. Names are necessary because a single vendor can have multiple administrators—it is easier to handle accountability that way.</p> <p>We also send account-related emails (such as order status notifications, password reset emails, and more) to the provided email address. For that reason we need to store your email address while you remain our customer. If you decide that you no longer want to work with our marketplace and would like to have personal data removed from our database (or if you’d like to get all the personal data associated with your account that we have), please send an email to [email].</p> <p>If you believe that your personal data has been misused, you have the right to lodge a complaint with a supervisory authority. We’re obliged by EU General Data Protection Regulation to let you know about this right; we don’t actually intend to misuse your data.</p>'),
('en', 'gdpr.vendor.apply.agreement_text_short_personal_data_processing', 'I agree to have my personal data <u>processed as follows.</u>'),
('en', 'gdpr.products.subscribe.personal_data_processing', 'Products: subscribe'),
('en', 'gdpr.products.subscribe.agreement_text_full_personal_data_processing', '<p>We ([company]) will add your email address to a special mailing list for this product. Once the product is in stock, you’ll get an email about it automatically, and your email address will be removed from the product’s mailing list.</p> <p>The data will be visible to some members of our staff. If you’d like to have your personal data removed, send an email to [email].</p> <p>If you believe that your personal data has been misused, you have the right to lodge a complaint with a supervisory authority. We’re obliged by EU General Data Protection Regulation to let you know about this right; we don’t actually intend to misuse your data.</p>'),
('en', 'gdpr.products.subscribe.agreement_text_short_personal_data_processing', 'I agree to have my personal data <u>processed as follows.</u>'),
('en', 'gdpr.checkout.profiles_update.personal_data_processing', 'Checkout: profiles update'),
('en', 'gdpr.checkout.profiles_update.agreement_text_full_personal_data_processing', '<p>We ([company]) send account-related emails (such as order status notifications, password reset emails, and more) to the provided email address. For that reason we need to store your email address while you remain our customer.</p> <p>We use the information in the billing/shipping address section and may send it to a shipping or payment method provider to:</p> <ul> <li>Determine what shipping and payment methods are available for your location. </li> <li>Complete the payment or shipping process via the provider that you choose at checkout when you submit the order.</li> </ul> <p>Some members of our staff and/or vendors who sell products in our store and use its administration panel may be able to access your data. We value your privacy, so the access to data is provided on a need-to-know basis in order to operate the store. For example, a vendor only receives your data if you ordered something from them, so that the vendor can fulfil that order.</p> <p>If you decide that you no longer want to use our store and would like to have your personal data removed from our database (or if you’d like to get all the personal data associated with your account that we have), please send an email to [email].</p> <p>If you believe that your personal data has been misused, you have the right to lodge a complaint with a supervisory authority. We’re obliged by EU General Data Protection Regulation to let you know about this right; we don’t actually intend to misuse your data.</p>'),
('en', 'gdpr.checkout.profiles_update.agreement_text_short_personal_data_processing', 'I agree to have my personal data <u>processed as follows</u>.'),
('en', 'gdpr.export_to_xml', 'Export to XML'),
('en', 'gdpr.agreement_required_error', 'Your agreement is required to proceed.'),
('en', 'gdpr.user_anonymized', 'User has been anonymized.'),
('en', 'gdpr.check_other_sources_for_personal_data', '<p>Please note that anonymization doesn''t affect any backups and logs that you might have. If necessary, please do the following:</p><ol><li>Clear the logs under <b>Administration → Logs</b>.</li><li>Secure and delete the backups you might have under <b>Administration → Backup/Restore</b>.</li></ol>'),
('en', 'gdpr.cookie_consent', 'Cookie consent'),
('en', 'gdpr.cookie_consent_message', '<p>This website uses cookies (small pieces of data saved on your computer). Some cookies are added by the website itself: they help to show you the content of your cart, keep you signed in once you enter your email and password, preserve your preferences, and do a lot of other useful things. We use these cookies only to make the site work properly for you. Even your agreement to our use of cookies is stored as a cookie.</p><p>Other cookies may be used by third-party services (such as PayPal, YouTube, Google Maps, Facebook, etc.) to store the data about how you use those third-party services on the website. We have no control over how third parties use cookies, but those cookies are also important for proper functioning of the website. For example, some of the PayPal functionality may not work without PayPal cookies.</p><p>Without cookies, many things can go wrong. That''s why we ask that you agree to cookies being used before you proceed. If you don''t want any cookies but would like to continue using the website, please configure your browser to block cookies, and then you''ll be able to "agree" to their use, while we won''t treat that as your consent.</p>'),
('en', 'gdpr.cookie_consent_accept', 'I agree'),
('en', 'gdpr.cookie_consent_decline', 'No, take me out of here'),
('en', 'gdpr.uk_cookies_law', 'Cookies are used on this site to provide the best user experience. If you continue, we assume that you agree to receive cookies from this site.'),
('en', 'block_gdpr', 'GDPR'),
('en', 'gdpr', 'GDPR'),
('en', 'block_gdpr_description', 'Allows registered users to request their personal data or anonymization'),
('en', 'gdpr.user_profile_actions_description', '<p>As customers interact with the store, they provide personal data for various purposes. When you place an order, we need to know where to ship it; when you subscribe for an email newsletter, we need to know where to send it, and so on. We keep this data organized, so that you always could:</p> <ol> <li>Request that we send you all your personal data. In that case we’ll send you an XML file by email. That file will contain all your personal data we have.</li> <li>Request to be forgotten. In that case your account will be deactivated, and all your personal data will be removed. If necessary, you’ll be able to register a new account with the same email address in the future.</li> </ol> <p>Please note that we’ll need some time to process either of those requests. We may contact you regarding your request by email or through other means.</p>'),
('en', 'gdpr.send_my_data', 'Send me my data'),
('en', 'gdpr.send_my_data_description', '<p>We’ll send you an XML file with all your personal data we have. Please note that we’ll need some time to process this request, so the email with your XML file won’t be sent immediately. If you have any comments regarding your request, please leave them in the field below.</p>'),
('en', 'gdpr.email_subject_personal_data_request', 'Personal Data Copy Request: [customer_email]'),
('en', 'gdpr.email_body_personal_data_request', '<p><a href="[user_profile_url]" target="_blank">[user]</a> with the email address [customer_email] has requested a copy of personal data with the following comment:</p> <p>[comment]</p> <p>Click the link at the beginning of this message and use the corresponding button on the customer profile page in the Administration panel to get the data in the XML format. After that, send the XML file to the customer.</p>'),
('en', 'gdpr.remove_my_data', 'Remove my data'),
('en', 'gdpr.remove_my_data_description', '<p>We’ll deactivate your account and remove all your personal data from it. After that you won’t be able to sign in. However, you’ll be able to register a new account with the same email address in the future. Please note that we’ll need some time to process this request, so your account won’t be deactivated immediately. If you have any comments regarding your request, please leave them in the field below.</p>'),
('en', 'gdpr.email_subject_anonymization_request', 'Personal Data Removal Request: [customer_email]'),
('en', 'gdpr.email_body_anonymization_request', '<p><a href="[user_profile_url]" target="_blank">[user]</a> with the email address [customer_email] has requested the removal of personal data with the following comment:</p> <p>[comment]</p> <p>Click the link at the beginning of this message and use the corresponding button on the customer profile page in the Administration panel to anonymize the customer.</p> <p>Please note that <b>this action will replace all the personal data of the customer</b> with randomly generated data. It’s best to make sure that all business with the customer (such as orders and return requests) is concluded before you do that.</p>'),
('en', 'gdpr.user_action_request_success', 'Your request has been sent successfully.'),
('en', 'gdpr.user_action_request_fail', 'An error has occurred during the attempt to send your request. Please try again or send a message to the following email address: <a href="mailto:[email]">[email]</a>'),
('en', 'gdpr.agreement_variables_hint', '<p>The texts of the agreements listed below may have <b>[email]</b> or <b>[company]</b> in them. Those are placeholders that will be automatically replaced with actual data when customers see the agreements. If you only have one storefront, the data for the placeholders will be taken from <a href="[company_settings_url]" target="_blank">Settings → Company</a>. If you have multiple storefronts, the data will be taken from the settings of the storefront that a customer visits:</p><ul><li><b>[company]</b> will be taken from <i>Company name</i>.</li><li><b>[email]</b> will be taken from <i>User department e-mail address</i>.</li></ul>'),
('en', 'gdpr.agreement_variables_hint_mve', '<p>The texts of the agreements listed below may have <b>[email]</b> or <b>[company]</b> in them. Those are placeholders that will be automatically replaced with actual data when customers see the agreements. The data for placeholders will be taken from <a href="[company_settings_url]" target="_blank">Settings → Company</a>:</p><ul><li><b>[company]</b> will be taken from <i>Company name</i>.</li><li><b>[email]</b> will be taken from <i>User department e-mail address</i>.</li></ul>'),
('en', 'gdpr.strictly_necessary_cookies_title', 'Strictly necessary cookies'),
('en', 'gdpr.strictly_necessary_cookies_description', 'These cookies are essential for the website to work properly. For example, they let you place an order, or help the site remember that you''ve signed into your account. That''s why they can''t be disabled through the site. You can configure your browser to disable even these cookies, but important parts of the site won''t work without them.'),
('en', 'gdpr.performance_cookies_title', 'Performance cookies'),
('en', 'gdpr.performance_cookies_description', 'These cookies allow us to see how the website works. The information that these cookies help to collect is anonymous; it is typically presented in numbers. For example, these cookies help us see how often errors occur, how many unique visitors we have, or how long each page is viewed on average. Thanks to these cookies, we can improve the site for you.'),
('en', 'gdpr.functional_cookies_title', 'Functional cookies'),
('en', 'gdpr.functional_cookies_description', 'These cookies enable additional functionality at the website. They may be set by third-party providers whose services we''ve added to the website. Those services may include many things, like maps, geolocation for preliminary shipping rate calculation, or the ability to sign in with your social network account. Without functional cookies, the parts of the site associated with these services may not work properly.'),
('en', 'gdpr.marketing_cookies_title', 'Marketing cookies'),
('en', 'gdpr.marketing_cookies_description', 'These cookies are used by our advertising partners. They help them to measure promotion efficiency and serve you ads that are more relevant and less repetitive. This is usually achieved by remembering the browser and device that saw the ad. Turning these cookies off won''t reduce the number of ads you see on the internet, but will make them less personalized.'),
('en', 'gdpr.eway_cookies_title', 'eWAY'),
('en', 'gdpr.eway_cookies_description', 'eWAY is a payment provider. It allows us to accept payments, if you choose a payment method powered by eWAY. Here is <a href="https://www.eway.com.au/privacy-policy/" target="_blank">eWAY privacy policy</a>.'),
('en', 'gdpr.klaro_privacy_policy_title', 'You can find out more in this document: {privacyPolicy}.'),
('en', 'gdpr.klaro_privacy_policy_name', 'Privacy policy'),
('en', 'gdpr.klaro_service', 'service'),
('en', 'gdpr.klaro_services', 'services'),
('en', 'gdpr.klaro_accept_all', 'Accept all'),
('en', 'gdpr.klaro_accept_selected', 'Accept selected'),
('en', 'gdpr.klaro_close', 'Close'),
('en', 'gdpr.klaro_consent_modal_description', 'Here you can assess and customize the services (and their respective cookies) that we''d like to use on this website. You''re in charge! Enable or disable services as you see fit.'),
('en', 'gdpr.klaro_consent_modal_title', 'Cookies we would like to use'),
('en', 'gdpr.klaro_consent_notice_change_description', 'There were changes since your last visit, please renew your consent.'),
('en', 'gdpr.klaro_consent_notice_title', 'Cookie Consent'),
('en', 'gdpr.klaro_consent_notice_description', 'Hi! Could we please enable some additional services that require cookies? You can always change or withdraw your consent later.'),
('en', 'gdpr.klaro_consent_notice_learn_more', 'Let me choose'),
('en', 'gdpr.klaro_consent_notice_testing', 'Testing mode!'),
('en', 'gdpr.klaro_contextual_consent_accept_always', 'Always'),
('en', 'gdpr.klaro_contextual_consent_accept_once', '''Yes'''),
('en', 'gdpr.klaro_contextual_consent_description', 'Do you want to load external content supplied by {title}?'),
('en', 'gdpr.klaro_decline', 'I decline'),
('en', 'gdpr.klaro_ok', 'That''s ok'),
('en', 'gdpr.klaro_powered_by', 'Realized with Klaro!'),
('en', 'gdpr.klaro_service_purpose', 'purpose'),
('en', 'gdpr.klaro_service_purposes', 'purposes'),
('en', 'gdpr.klaro_service_required_description', 'This service is always required'),
('en', 'gdpr.disable_all_description', 'Use this switch to enable or disable all services.'),
('en', 'gdpr.disable_all_title', 'Enable or disable all services'),
('en', 'gdpr.opt_out_description', 'This service is enabled by default (but you can opt out)'),
('en', 'gdpr.opt_out_title', '(opt-out)'),
('en', 'gdpr.klaro_service_required_title', '(always required)'),
('en', 'gdpr.cookie_consent_texts', 'Cookie consent texts'),
('en', 'gdpr.site_functionality_cookies_title', 'Site functionality'),
('en', 'gdpr.site_functionality_cookies_description', 'These cookies serve the essential functions of the site. For example, they help the site remember that you put something in the cart or signed into your account.'),
('en', 'shopify_import.shopify_products_import', 'Shopify products'),
('en', 'shopify_import.sync_data_name', 'Import products from Shopify'),
('en', 'shopify_import.choose_import_mode', 'Choose import mode'),
('en', 'shopify_import.import_for_all_vendors', 'I''m launching my marketplace and setting up products for all vendors to use'),
('en', 'shopify_import.import_for_specific_vendor', 'I''m importing these products for a specific vendor'),
('en', 'shopify_import.depends_on_common_products_addon', 'This option needs <a href="[link]">Common products for vendors</a> add-on to be installed'),
('en', 'shopify_import.invalid_csv_file_format', 'Uploaded CSV-file has invalid format or empty. Only files exported from Shopify supported.'),
('en', 'shopify_import.products_without_sku', 'The SKU value is missing for some products. These products are always imported as new objects.'),
('en', 'shopify_import.last_status.S', 'Success'),
('en', 'shopify_import.last_status.F', 'Failure');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]localizations`
--

CREATE TABLE `[[dbprefix]]localizations` (
  `localization_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `custom_weight_settings` char(1) NOT NULL DEFAULT 'Y',
  `weight_symbol` varchar(255) NOT NULL DEFAULT '',
  `weight_unit` decimal(12,2) NOT NULL DEFAULT '0.00',
  `is_default` char(1) NOT NULL DEFAULT 'N',
  `status` char(1) NOT NULL DEFAULT 'A',
  PRIMARY KEY (`localization_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]localization_descriptions`
--

CREATE TABLE `[[dbprefix]]localization_descriptions` (
  `localization_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `localization` varchar(255) NOT NULL DEFAULT '',
  `lang_code` char(2) NOT NULL DEFAULT '',
  KEY `localisation_id` (`localization_id`,`lang_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]localization_elements`
--

CREATE TABLE `[[dbprefix]]localization_elements` (
  `element_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `localization_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `element` varchar(36) NOT NULL DEFAULT '',
  `element_type` char(1) NOT NULL DEFAULT 'S',
  `position` smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`element_id`),
  KEY `c_avail` (`localization_id`),
  KEY `element` (`element`,`element_type`),
  KEY `position` (`position`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lock_keys`
--

CREATE TABLE `[[dbprefix]]lock_keys` (
  `key_id` varchar(64) NOT NULL,
  `token` varchar(64) NOT NULL,
  `expiry_at` int(11) unsigned NOT NULL,
  PRIMARY KEY (`key_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]logos`
--

CREATE TABLE `[[dbprefix]]logos` (
  `logo_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `layout_id` int(11) NOT NULL DEFAULT '0',
  `style_id` varchar(50) NOT NULL DEFAULT '',
  `company_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(32) NOT NULL DEFAULT '',
  `storefront_id` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`logo_id`),
  KEY `type` (`type`,`company_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]logos`
--

INSERT INTO `[[dbprefix]]logos` VALUES
(1, 1, 'Bright_theme', 1, 'theme', 1),
(2, 1, 'Bright_theme', 1, 'favicon', 1),
(3, 1, 'Bright_theme', 1, 'mail', 1),
(4, 0, '', 0, 'gift_cert', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]logs`
--

CREATE TABLE `[[dbprefix]]logs` (
  `log_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `timestamp` int(11) unsigned NOT NULL DEFAULT '0',
  `type` varchar(16) NOT NULL DEFAULT '',
  `event_type` char(1) NOT NULL DEFAULT 'N',
  `action` varchar(16) NOT NULL DEFAULT '',
  `object` char(1) NOT NULL DEFAULT '',
  `content` text,
  `backtrace` text,
  `company_id` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`log_id`),
  KEY `object` (`object`),
  KEY `type` (`type`,`action`),
  KEY `idx_timestamp` (`timestamp`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]logs`
--
-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mailing_lists`
--

CREATE TABLE `[[dbprefix]]mailing_lists` (
  `list_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` int(11) unsigned NOT NULL DEFAULT '0',
  `from_email` varchar(64) NOT NULL DEFAULT '',
  `from_name` varchar(128) NOT NULL DEFAULT '',
  `reply_to` varchar(64) NOT NULL DEFAULT '',
  `show_on_checkout` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `show_on_registration` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `status` char(1) NOT NULL DEFAULT 'D',
  `register_autoresponder` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`list_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]mailing_lists`
--

INSERT INTO `[[dbprefix]]mailing_lists` VALUES
(1, 0, 'no-reply@example.com', 'Acme', 'no-reply@example.com', 1, 1, 'A', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menus`
--

CREATE TABLE `[[dbprefix]]menus` (
  `menu_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `status` char(1) NOT NULL DEFAULT 'A',
  `company_id` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`menu_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]menus`
--

INSERT INTO `[[dbprefix]]menus` VALUES
(1, 'A', 1),
(2, 'A', 1),
(3, 'A', 1),
(4, 'A', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menus_descriptions`
--

CREATE TABLE `[[dbprefix]]menus_descriptions` (
  `menu_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `lang_code` char(2) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`menu_id`,`lang_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]menus_descriptions`
--

INSERT INTO `[[dbprefix]]menus_descriptions` VALUES
(1, 'en', 'Quick links'),
(2, 'en', 'Main menu'),
(3, 'en', 'Shop (footer)'),
(4, 'en', 'Create orders (footer)');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]newsletters`
--

CREATE TABLE `[[dbprefix]]newsletters` (
  `newsletter_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `campaign_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `sent_date` int(11) unsigned NOT NULL DEFAULT '0',
  `status` char(1) NOT NULL DEFAULT 'A',
  `type` char(1) NOT NULL DEFAULT 'N',
  `mailing_lists` varchar(255) NOT NULL DEFAULT '',
  `users` text,
  `abandoned_type` varchar(10) NOT NULL DEFAULT 'both',
  `abandoned_days` int(11) NOT NULL DEFAULT '0',
  `abandoned_company_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`newsletter_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]newsletters`
--

INSERT INTO `[[dbprefix]]newsletters` VALUES
(1, 0, 0, 'A', 'N', '', NULL, 'both', 0, 0),
(2, 0, 0, 'A', 'T', '', NULL, 'both', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]newsletter_batch_recipients`
--

CREATE TABLE `[[dbprefix]]newsletter_batch_recipients` (
  `send_list_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `list_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `subscriber_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `email` varchar(128) NOT NULL DEFAULT '',
  `send_key` varchar(128) NOT NULL DEFAULT '',
  `lang_code` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`send_list_id`),
  KEY `send_key` (`send_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]newsletter_campaigns`
--

CREATE TABLE `[[dbprefix]]newsletter_campaigns` (
  `campaign_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` int(11) unsigned NOT NULL DEFAULT '0',
  `status` char(1) NOT NULL DEFAULT 'D',
  PRIMARY KEY (`campaign_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]newsletter_descriptions`
--

CREATE TABLE `[[dbprefix]]newsletter_descriptions` (
  `newsletter_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `newsletter` varchar(255) NOT NULL DEFAULT '',
  `newsletter_multiple` text,
  `body_html` mediumtext,
  `lang_code` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`newsletter_id`,`lang_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]newsletter_descriptions`
--

INSERT INTO `[[dbprefix]]newsletter_descriptions` VALUES
(1, 'Xbox One is coming!', '', 'The groundbreaking nextgen gaming console is already coming to the stores. Be the first to order this extraordinary gadget!', 'en'),
(2, 'Sample layout', '', '<h2>Hello,</h2>\r\n\r\n[your text]\r\n\r\nThank you!\r\nYou can unsubscribe from the newsletter by using this link:\r\n%UNSUBSCRIBE_LINK\r\n\r\n%COMPANY_NAME.', 'en');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]newsletter_links`
--

CREATE TABLE `[[dbprefix]]newsletter_links` (
  `link_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `campaign_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `newsletter_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `url` varchar(255) NOT NULL DEFAULT '',
  `clicks` mediumint(8) unsigned DEFAULT NULL,
  PRIMARY KEY (`link_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notifications`
--

CREATE TABLE `[[dbprefix]]notifications` (
  `notification_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT 'Notification receiver',
  `title` varchar(256) NOT NULL DEFAULT '' COMMENT 'Notification title',
  `message` text NOT NULL COMMENT 'Notification text',
  `severity` char(1) NOT NULL DEFAULT 'N' COMMENT 'Notification severity: E(rror), W(arning), N(otice), I(nfo)',
  `section` varchar(128) NOT NULL DEFAULT 'other' COMMENT 'Section of the Notifications center to display the notification in',
  `tag` varchar(32) NOT NULL DEFAULT 'other' COMMENT 'Tag of the notifications',
  `area` char(1) NOT NULL DEFAULT 'A' COMMENT 'Area to display the notification in',
  `action_url` varchar(256) NOT NULL DEFAULT '' COMMENT 'Dispatch to open when clicking on the notification',
  `is_read` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Whether the notification has been read',
  `pinned` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Whether the notification has been pinned',
  `remind` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Determines if a remind notification is needed',
  `timestamp` int(11) unsigned NOT NULL DEFAULT '0' COMMENT 'Time when the notification was created',
  PRIMARY KEY (`notification_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_user_id_area` (`user_id`,`area`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Stores notifications of the Notifications center' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notification_event_receivers`
--

CREATE TABLE `[[dbprefix]]notification_event_receivers` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `event_id` varchar(128) NOT NULL COMMENT 'The notification group ID',
  `method` varchar(64) NOT NULL DEFAULT 'user_id' COMMENT 'Receiver search method: user_id — User ID, usergroup_id — Usergroup ID, email — e-mail',
  `criterion` varchar(128) NOT NULL COMMENT 'Criterion to use with the specified method to search a receiver',
  `receiver` varchar(15) NOT NULL DEFAULT 'A' COMMENT 'Receiver of notification message: C - Customer, A - Administrator, V - Vendor',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notification_group_receivers`
--

CREATE TABLE `[[dbprefix]]notification_group_receivers` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `group_id` varchar(128) NOT NULL COMMENT 'Notification group ID',
  `method` varchar(64) NOT NULL DEFAULT 'user_id' COMMENT 'Receiver search method: user_id — User ID, usergroup_id — Usergroup ID, email — e-mail',
  `criterion` varchar(128) NOT NULL COMMENT 'Criterion to use with the specified method to search a receiver',
  `receiver` varchar(15) NOT NULL DEFAULT 'A' COMMENT 'Receiver of notification message: C - Customer, A - Administrator, V - Vendor',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]notification_group_receivers`
--

INSERT INTO `[[dbprefix]]notification_group_receivers` VALUES
(1, 'orders', 'order_manager', 'order_manager', 'A'),
(2, 'orders', 'user_id', '1', 'A'),
(3, 'users', 'user_id', '1', 'A'),
(4, 'system', 'user_id', '1', 'A'),
(5, 'vendor_communication', 'user_id', '1', 'A'),
(6, 'rma', 'user_id', '1', 'A'),
(7, 'call_requests', 'user_id', '1', 'A'),
(8, 'discussion', 'user_id', '1', 'A'),
(9, 'product_reviews.product_reviews', 'user_id', '1', 'A');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notification_settings`
--

CREATE TABLE `[[dbprefix]]notification_settings` (
  `event_id` varchar(100) NOT NULL,
  `transport_id` varchar(50) NOT NULL,
  `receiver` varchar(15) NOT NULL COMMENT 'Receiver of notification message: C - Customer, A - Administrator, V - Vendor',
  `is_allowed` tinyint(3) DEFAULT '0' COMMENT '0 - will NOT be sent, 1 - will BE sent',
  PRIMARY KEY (`event_id`,`transport_id`,`receiver`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]orders`
--

CREATE TABLE `[[dbprefix]]orders` (
  `order_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `is_parent_order` char(1) NOT NULL DEFAULT 'N',
  `parent_order_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `company_id` int(11) unsigned NOT NULL DEFAULT '0',
  `issuer_id` mediumint(8) unsigned DEFAULT NULL,
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `total` decimal(12,2) NOT NULL DEFAULT '0.00',
  `subtotal` decimal(12,2) NOT NULL DEFAULT '0.00',
  `discount` decimal(12,2) NOT NULL DEFAULT '0.00',
  `subtotal_discount` decimal(12,2) NOT NULL DEFAULT '0.00',
  `payment_surcharge` decimal(12,2) NOT NULL DEFAULT '0.00',
  `shipping_ids` varchar(255) NOT NULL DEFAULT '',
  `shipping_cost` decimal(12,2) NOT NULL DEFAULT '0.00',
  `timestamp` int(11) unsigned NOT NULL DEFAULT '0',
  `status` char(1) NOT NULL DEFAULT 'O',
  `notes` text,
  `details` text,
  `promotions` text,
  `promotion_ids` varchar(255) NOT NULL DEFAULT '',
  `firstname` varchar(32) NOT NULL DEFAULT '',
  `lastname` varchar(32) NOT NULL DEFAULT '',
  `company` varchar(255) NOT NULL DEFAULT '',
  `b_firstname` varchar(128) NOT NULL DEFAULT '',
  `b_lastname` varchar(128) NOT NULL DEFAULT '',
  `b_address` varchar(255) NOT NULL DEFAULT '',
  `b_address_2` varchar(255) NOT NULL DEFAULT '',
  `b_city` varchar(64) NOT NULL DEFAULT '',
  `b_county` varchar(32) NOT NULL DEFAULT '',
  `b_state` varchar(32) NOT NULL DEFAULT '',
  `b_country` char(2) NOT NULL DEFAULT '',
  `b_zipcode` varchar(32) NOT NULL DEFAULT '',
  `b_phone` varchar(128) NOT NULL DEFAULT '',
  `s_firstname` varchar(128) NOT NULL DEFAULT '',
  `s_lastname` varchar(128) NOT NULL DEFAULT '',
  `s_address` varchar(255) NOT NULL DEFAULT '',
  `s_address_2` varchar(255) NOT NULL DEFAULT '',
  `s_city` varchar(64) NOT NULL DEFAULT '',
  `s_county` varchar(32) NOT NULL DEFAULT '',
  `s_state` varchar(32) NOT NULL DEFAULT '',
  `s_country` char(2) NOT NULL DEFAULT '',
  `s_zipcode` varchar(32) NOT NULL DEFAULT '',
  `s_phone` varchar(128) NOT NULL DEFAULT '',
  `s_address_type` varchar(32) NOT NULL DEFAULT '',
  `phone` varchar(128) NOT NULL DEFAULT '',
  `fax` varchar(128) NOT NULL DEFAULT '',
  `url` varchar(32) NOT NULL DEFAULT '',
  `email` varchar(128) NOT NULL DEFAULT '',
  `payment_id` mediumint(8) NOT NULL DEFAULT '0',
  `tax_exempt` char(1) NOT NULL DEFAULT 'N',
  `lang_code` char(2) NOT NULL DEFAULT '',
  `ip_address` varbinary(40) NOT NULL DEFAULT '',
  `repaid` int(11) NOT NULL DEFAULT '0',
  `validation_code` varchar(20) NOT NULL DEFAULT '',
  `localization_id` mediumint(8) NOT NULL,
  `profile_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `storefront_id` int(11) unsigned NOT NULL DEFAULT '0',
  `updated_at` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`),
  KEY `timestamp` (`timestamp`),
  KEY `user_id` (`user_id`),
  KEY `promotion_ids` (`promotion_ids`),
  KEY `status` (`status`),
  KEY `shipping_ids` (`shipping_ids`),
  KEY `company_id` (`company_id`),
  KEY `idx_updated_at` (`updated_at`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=98 ;

--
-- Dumping data for table `[[dbprefix]]orders`
--

INSERT INTO `[[dbprefix]]orders` VALUES
(28, 'N', 0, 1, NULL, 3, '917.99', '917.99', '0.00', '0.00', '0.00', '1', '0.00', 1380175269, 'C', '', '', 'a:0:{}', '', 'David', 'Tenant', '', 'David', 'Tenant', 'Glasgow, Lanarkshire G2 1DS', '', 'Glasgow', '', 'GLAS', 'GB', '141 332', '+16175555555', 'David', 'Tenant', 'Glasgow, Lanarkshire G2 1DS', '', 'Glasgow', '', 'GLAS', 'GB', '141 332', '+16175555555', '', '+16175555555', '', '', 'davdavid@example.com', 1, 'N', 'en', '95.104.192.183', 0, '', 0, 2, 1, 0),
(29, 'N', 0, 1, NULL, 3, '529.99', '529.99', '0.00', '0.00', '0.00', '', '0.00', 1380223340, 'C', '', '', 'a:0:{}', '', 'David', 'Tenant', '', 'David', 'Tenant', 'Glasgow, Lanarkshire G2 1DS', '', 'Glasgow', '', 'GLAS', 'GB', '141 332', '', 'David', 'Tenant', 'Glasgow, Lanarkshire G2 1DS', '', 'Glasgow', '', 'GLAS', 'GB', '141 332', '', '', '', '', '', 'davdavid@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(35, 'N', 0, 1, NULL, 3, '25.00', '25.00', '0.00', '0.00', '0.00', '', '0.00', 1380299995, 'C', '', '', 'a:0:{}', '', 'David', 'Tenant', '', 'David', 'Tenant', 'Glasgow, Lanarkshire G2 1DS', '', 'Glasgow', '', 'GLAS', 'GB', '141 332', '', 'David', 'Tenant', 'Glasgow, Lanarkshire G2 1DS', '', 'Glasgow', '', 'GLAS', 'GB', '141 332', '', '', '', '', '', 'davdavid@example.com', 3, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(36, 'N', 0, 1, NULL, 3, '12.99', '12.99', '0.00', '0.00', '0.00', '', '0.00', 1380442732, 'C', '', '', 'a:0:{}', '', 'David', 'Tenant', '', 'David', 'Tenant', 'Glasgow, Lanarkshire G2 1DS', '', 'Glasgow', '', 'GLAS', 'GB', '141 332', '', 'David', 'Tenant', 'Glasgow, Lanarkshire G2 1DS', '', 'Glasgow', '', 'GLAS', 'GB', '141 332', '', '', '', '', '', 'davdavid@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(37, 'N', 0, 1, NULL, 3, '39.99', '39.99', '0.00', '0.00', '0.00', '', '0.00', 1380523085, 'C', '', '', 'a:0:{}', '', 'David', 'Tenant', '', 'David', 'Tenant', 'Glasgow, Lanarkshire G2 1DS', '', 'Glasgow', '', 'GLAS', 'GB', '141 332', '', 'David', 'Tenant', 'Glasgow, Lanarkshire G2 1DS', '', 'Glasgow', '', 'GLAS', 'GB', '141 332', '', '', '', '', '', 'davdavid@example.com', 1, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(38, 'N', 0, 1, NULL, 3, '200.00', '200.00', '0.00', '0.00', '0.00', '', '0.00', 1380608061, 'B', '', '', 'a:0:{}', '', 'David', 'Tenant', '', 'David', 'Tenant', 'Glasgow, Lanarkshire G2 1DS', '', 'Glasgow', '', 'GLAS', 'GB', '141 332', '', 'David', 'Tenant', 'Glasgow, Lanarkshire G2 1DS', '', 'Glasgow', '', 'GLAS', 'GB', '141 332', '', '', '', '', '', 'davdavid@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(39, 'N', 0, 1, NULL, 3, '249.00', '249.00', '0.00', '0.00', '0.00', '', '0.00', 1380701115, 'C', '', '', 'a:0:{}', '', 'David', 'Tenant', '', 'David', 'Tenant', 'Glasgow, Lanarkshire G2 1DS', '', 'Glasgow', '', 'GLAS', 'GB', '141 332', '', 'David', 'Tenant', 'Glasgow, Lanarkshire G2 1DS', '', 'Glasgow', '', 'GLAS', 'GB', '141 332', '', '', '', '', '', 'davdavid@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(40, 'N', 0, 1, NULL, 3, '299.99', '299.99', '0.00', '0.00', '0.00', '', '0.00', 1380748356, 'C', '', '', 'a:0:{}', '', 'Sergey', 'Maxeev', '', 'Sergey', 'Maxeev', 'Moskovskaya street, 65-12', '', 'Moscow', '', 'MOS', 'RU', '657849', '+79235456683', 'Sergey', 'Maxeev', 'Moskovskaya street, 65-12', '', 'Moscow', '', 'MOS', 'RU', '657849', '+79235456683', '', '+79235456683', '', '', 'sebastian@example.com', 1, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(41, 'N', 0, 1, NULL, 3, '100.00', '100.00', '0.00', '0.00', '0.00', '', '0.00', 1380832402, 'C', '', '', 'a:0:{}', '', 'Sergey', 'Maxeev', '', 'Sergey', 'Maxeev', 'Moskovskaya street, 65-12', '', 'Moscow', '', 'MOS', 'RU', '657849', '+79235456683', 'Sergey', 'Maxeev', 'Moskovskaya street, 65-12', '', 'Moscow', '', 'MOS', 'RU', '657849', '+79235456683', '', '+79235456683', '', '', 'sebastian@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(42, 'N', 0, 1, NULL, 3, '59.99', '59.99', '0.00', '0.00', '0.00', '', '0.00', 1380962932, 'C', '', '', 'a:0:{}', '', 'Sergey', 'Maxeev', '', 'Sergey', 'Maxeev', 'Moskovskaya street, 65-12', '', 'Moscow', '', 'MOS', 'RU', '657849', '+79235456683', 'Sergey', 'Maxeev', 'Moskovskaya street, 65-12', '', 'Moscow', '', 'MOS', 'RU', '657849', '+79235456683', '', '+79235456683', '', '', 'sebastian@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(43, 'N', 0, 1, NULL, 3, '499.99', '499.99', '0.00', '0.00', '0.00', '', '0.00', 1381045614, 'C', '', '', 'a:0:{}', '', 'Sergey', 'Maxeev', '', 'Sergey', 'Maxeev', 'Moskovskaya street, 65-12', '', 'Moscow', '', 'MOS', 'RU', '657849', '+79235456683', 'Sergey', 'Maxeev', 'Moskovskaya street, 65-12', '', 'Moscow', '', 'MOS', 'RU', '657849', '+79235456683', '', '+79235456683', '', '', 'sebastian@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(44, 'N', 0, 1, NULL, 3, '220.00', '220.00', '0.00', '0.00', '0.00', '', '0.00', 1381126041, 'B', '', '', 'a:0:{}', '', 'Sergey', 'Maxeev', '', 'Sergey', 'Maxeev', 'Moskovskaya street, 65-12', '', 'Moscow', '', 'MOS', 'RU', '657849', '+79235456683', 'Sergey', 'Maxeev', 'Moskovskaya street, 65-12', '', 'Moscow', '', 'MOS', 'RU', '657849', '+79235456683', '', '+79235456683', '', '', 'sebastian@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(45, 'N', 0, 1, NULL, 3, '749.95', '749.95', '0.00', '0.00', '0.00', '', '0.00', 1381195430, 'C', '', '', 'a:0:{}', '', 'Sergey', 'Maxeev', '', 'Sergey', 'Maxeev', 'Moskovskaya street, 65-12', '', 'Moscow', '', 'MOS', 'RU', '657849', '+79235456683', 'Sergey', 'Maxeev', 'Moskovskaya street, 65-12', '', 'Moscow', '', 'MOS', 'RU', '657849', '+79235456683', '', '+79235456683', '', '', 'sebastian@example.com', 3, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(46, 'N', 0, 1, NULL, 3, '1199.99', '1199.99', '0.00', '0.00', '0.00', '', '0.00', 1381305105, 'I', '', '', 'a:0:{}', '', 'Sergey', 'Maxeev', '', 'Sergey', 'Maxeev', 'Moskovskaya street, 65-12', '', 'Moscow', '', 'MOS', 'RU', '657849', '+79235456683', 'Sergey', 'Maxeev', 'Moskovskaya street, 65-12', '', 'Moscow', '', 'MOS', 'RU', '657849', '+79235456683', '', '+79235456683', '', '', 'sebastian@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(47, 'N', 0, 1, NULL, 3, '299.99', '299.99', '0.00', '0.00', '0.00', '', '0.00', 1381351227, 'C', '', '', 'a:0:{}', '', 'Sergey', 'Maxeev', '', 'Sergey', 'Maxeev', 'Moskovskaya street, 65-12', '', 'Moscow', '', 'MOS', 'RU', '657849', '+79235456683', 'Sergey', 'Maxeev', 'Moskovskaya street, 65-12', '', 'Moscow', '', 'MOS', 'RU', '657849', '+79235456683', '', '+79235456683', '', '', 'sebastian@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(48, 'N', 0, 1, NULL, 3, '1059.98', '1059.98', '0.00', '0.00', '0.00', '', '0.00', 1381453574, 'F', '', '', 'a:0:{}', '', 'Sergey', 'Maxeev', '', 'Sergey', 'Maxeev', 'Moskovskaya street, 65-12', '', 'Moscow', '', 'MOS', 'RU', '657849', '+79235456683', 'Sergey', 'Maxeev', 'Moskovskaya street, 65-12', '', 'Moscow', '', 'MOS', 'RU', '657849', '+79235456683', '', '+79235456683', '', '', 'sebastian@example.com', 1, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(49, 'N', 0, 1, NULL, 3, '262.93', '262.93', '0.00', '0.00', '0.00', '', '0.00', 1381519339, 'C', '', '', 'a:0:{}', '', 'Sergey', 'Maxeev', '', 'Sergey', 'Maxeev', 'Moskovskaya street, 65-12', '', 'Moscow', '', 'MOS', 'RU', '657849', '+79235456683', 'Sergey', 'Maxeev', 'Moskovskaya street, 65-12', '', 'Moscow', '', 'MOS', 'RU', '657849', '+79235456683', '', '+79235456683', '', '', 'sebastian@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(50, 'N', 0, 1, NULL, 3, '1524.45', '1499.00', '0.00', '0.00', '0.00', '1', '25.45', 1381588344, 'D', 'Please, deliver it in the first part of day', '', 'a:0:{}', '', 'Sergey', 'Maxeev', '', 'Sergey', 'Maxeev', 'Moskovskaya street, 65-12', '', 'Moscow', '', 'MOS', 'RU', '657849', '+79235456683', 'Sergey', 'Maxeev', 'Moskovskaya street, 65-12', '', 'Moscow', '', 'MOS', 'RU', '657849', '+79235456683', '', '+79235456683', '', '', 'sebastian@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(51, 'N', 0, 1, NULL, 3, '157.95', '129.95', '0.00', '0.00', '0.00', '1', '28.00', 1381719156, 'C', '', '', 'a:0:{}', '', 'George', 'Nills', '', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', '', '+16463863600', '', '', 'dsds@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(52, 'N', 0, 1, NULL, 3, '198.00', '170.00', '0.00', '0.00', '0.00', '1', '28.00', 1381756224, 'C', '', '', 'a:0:{}', '', 'George', 'Nills', '', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', '', '+16463863600', '', '', 'dsds@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(53, 'N', 0, 1, NULL, 3, '80.99', '47.99', '0.00', '0.00', '0.00', '1', '33.00', 1381851877, 'C', '', '', 'a:0:{}', '', 'George', 'Nills', '', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', '', '+16463863600', '', '', 'dsds@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(54, 'N', 0, 1, NULL, 3, '323.00', '295.00', '0.00', '0.00', '0.00', '1', '28.00', 1381982790, 'D', '', '', 'a:0:{}', '', 'George', 'Nills', '', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', '', '+16463863600', '', '', 'dsds@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(55, 'N', 0, 1, NULL, 3, '1098.00', '1070.00', '0.00', '0.00', '0.00', '1', '28.00', 1382051938, 'C', '', '', 'a:0:{}', '', 'George', 'Nills', '', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', '', '+16463863600', '', '', 'dsds@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(56, 'N', 0, 1, NULL, 3, '297.00', '269.00', '0.00', '0.00', '0.00', '1', '28.00', 1382136365, 'C', '', '', 'a:0:{}', '', 'George', 'Nills', '', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', '', '+16463863600', '', '', 'dsds@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(57, 'N', 0, 1, NULL, 3, '92.99', '29.99', '0.00', '0.00', '0.00', '1', '63.00', 1382206809, 'C', '', '', 'a:0:{}', '', 'George', 'Nills', '', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', '', '+16463863600', '', '', 'dsds@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(58, 'N', 0, 1, NULL, 3, '5723.00', '5695.00', '0.00', '0.00', '0.00', '1', '28.00', 1382294314, 'C', '', '', 'a:0:{}', '', 'George', 'Nills', '', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', '', '+16463863600', '', '', 'dsds@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(59, 'N', 0, 1, NULL, 3, '3523.00', '3495.00', '0.00', '0.00', '0.00', '1', '28.00', 1382427272, 'F', '', '', 'a:0:{}', '', 'George', 'Nills', '', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', '', '+16463863600', '', '', 'dsds@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(60, 'N', 0, 1, NULL, 3, '677.95', '649.95', '0.00', '0.00', '0.00', '1', '28.00', 1382464846, 'C', '', '', 'a:0:{}', '', 'George', 'Nills', '', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', '', '+16463863600', '', '', 'dsds@example.com', 1, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(61, 'N', 0, 1, NULL, 3, '479.99', '479.99', '0.00', '0.00', '0.00', '', '0.00', 1382546287, 'C', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(62, 'N', 0, 1, NULL, 3, '504.98', '504.98', '0.00', '0.00', '0.00', '', '0.00', 1382680410, 'P', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 1, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(63, 'N', 0, 1, NULL, 3, '99.97', '99.97', '0.00', '0.00', '0.00', '', '0.00', 1382720383, 'C', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(64, 'N', 0, 1, NULL, 3, '2509.95', '2509.95', '0.00', '0.00', '0.00', '', '0.00', 1382794973, 'C', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 1, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(65, 'N', 0, 1, NULL, 3, '630.00', '630.00', '0.00', '0.00', '0.00', '', '0.00', 1382890766, 'F', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(66, 'N', 0, 1, NULL, 3, '5695.00', '5695.00', '0.00', '0.00', '0.00', '', '0.00', 1382992994, 'C', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 3, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(67, 'N', 0, 1, NULL, 3, '4595.00', '4595.00', '0.00', '0.00', '0.00', '', '0.00', 1383051922, 'C', '', '', 'a:0:{}', '', 'Oliver', 'Kahn', '', 'Oliver', 'Kahn', 'Bodestraße 1-3', '', 'Berlin', '', 'BER', 'DE', '10178', '+4930266424242', 'Oliver', 'Kahn', 'Bodestraße 1-3', '', 'Berlin', '', 'BER', 'DE', '10178', '+4930266424242', '', '+4930266424242', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(68, 'N', 0, 1, NULL, 3, '509.99', '509.99', '0.00', '0.00', '0.00', '', '0.00', 1383141667, 'B', '', '', 'a:0:{}', '', 'Oliver', 'Kahn', '', 'Oliver', 'Kahn', 'Bodestraße 1-3', '', 'Berlin', '', 'BER', 'DE', '10178', '+4930266424242', 'Oliver', 'Kahn', 'Bodestraße 1-3', '', 'Berlin', '', 'BER', 'DE', '10178', '+4930266424242', '', '+4930266424242', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(69, 'N', 0, 1, NULL, 3, '2349.97', '2349.97', '0.00', '0.00', '0.00', '', '0.00', 1383242472, 'C', '', '', 'a:0:{}', '', 'Oliver', 'Kahn', '', 'Oliver', 'Kahn', 'Bodestraße 1-3', '', 'Berlin', '', 'BER', 'DE', '10178', '+4930266424242', 'Oliver', 'Kahn', 'Bodestraße 1-3', '', 'Berlin', '', 'BER', 'DE', '10178', '+4930266424242', '', '+4930266424242', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(70, 'N', 0, 1, NULL, 3, '599.98', '599.98', '0.00', '0.00', '0.00', '', '0.00', 1383380053, 'C', '', '', 'a:0:{}', '', 'Oliver', 'Kahn', '', 'Oliver', 'Kahn', 'Bodestraße 1-3', '', 'Berlin', '', 'BER', 'DE', '10178', '+4930266424242', 'Oliver', 'Kahn', 'Bodestraße 1-3', '', 'Berlin', '', 'BER', 'DE', '10178', '+4930266424242', '', '+4930266424242', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(71, 'N', 0, 1, NULL, 3, '265.00', '265.00', '0.00', '0.00', '0.00', '', '0.00', 1383430639, 'P', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(72, 'N', 0, 1, NULL, 3, '115.00', '115.00', '0.00', '0.00', '0.00', '', '0.00', 1383529091, 'C', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(73, 'N', 0, 1, NULL, 3, '150.00', '150.00', '0.00', '0.00', '0.00', '', '0.00', 1383638802, 'C', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(74, 'N', 0, 1, NULL, 3, '286.44', '286.44', '0.00', '0.00', '0.00', '', '0.00', 1383685670, 'C', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 1, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(75, 'N', 0, 1, NULL, 3, '1599.80', '1599.80', '0.00', '0.00', '0.00', '', '0.00', 1383778149, 'I', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(76, 'N', 0, 1, NULL, 3, '3299.97', '3299.97', '0.00', '0.00', '0.00', '', '0.00', 1383870848, 'C', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(77, 'N', 0, 1, NULL, 3, '897.86', '897.86', '0.00', '0.00', '0.00', '', '0.00', 1383940992, 'C', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(78, 'N', 0, 1, NULL, 3, '1799.94', '1799.94', '0.00', '0.00', '0.00', '', '0.00', 1384065192, 'P', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 3, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(79, 'N', 0, 1, NULL, 3, '972.00', '972.00', '0.00', '0.00', '0.00', '', '0.00', 1384101839, 'C', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(80, 'N', 0, 1, NULL, 3, '998.00', '998.00', '0.00', '0.00', '0.00', '', '0.00', 1384223348, 'C', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(81, 'N', 0, 1, NULL, 3, '2994.86', '2994.86', '0.00', '0.00', '0.00', '', '0.00', 1384330152, 'C', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(82, 'N', 0, 1, NULL, 3, '749.95', '749.95', '0.00', '0.00', '0.00', '', '0.00', 1384411211, 'C', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(83, 'N', 0, 1, NULL, 3, '1048.99', '1048.99', '0.00', '0.00', '0.00', '', '0.00', 1384483388, 'C', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(84, 'N', 0, 1, NULL, 3, '3299.97', '3299.97', '0.00', '0.00', '0.00', '', '0.00', 1384527446, 'P', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(85, 'N', 0, 1, NULL, 3, '897.86', '897.86', '0.00', '0.00', '0.00', '', '0.00', 1384653017, 'C', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(86, 'N', 0, 1, NULL, 3, '1799.94', '1799.94', '0.00', '0.00', '0.00', '', '0.00', 1384707943, 'C', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 3, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(87, 'N', 0, 1, NULL, 3, '972.00', '972.00', '0.00', '0.00', '0.00', '', '0.00', 1384822028, 'D', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(89, 'N', 0, 1, NULL, 3, '2994.86', '2994.86', '0.00', '0.00', '0.00', '', '0.00', 1384931643, 'O', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(90, 'N', 0, 1, NULL, 3, '749.95', '749.95', '0.00', '0.00', '0.00', '', '0.00', 1384987673, 'I', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(91, 'N', 0, 1, NULL, 3, '1048.99', '1048.99', '0.00', '0.00', '0.00', '', '0.00', 1385076316, 'C', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(92, 'N', 0, 1, NULL, 3, '677.95', '649.95', '0.00', '0.00', '0.00', '1', '28.00', 1719988502, 'C', '', '', 'a:0:{}', '', 'George', 'Nills', '', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', '', '+16463863600', '', '', 'dsds@example.com', 1, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(93, 'N', 0, 1, NULL, 3, '150.00', '150.00', '0.00', '0.00', '0.00', '', '0.00', 1719988902, 'O', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(94, 'N', 0, 1, NULL, 3, '297.00', '269.00', '0.00', '0.00', '0.00', '1', '28.00', 1719989902, 'C', '', '', 'a:0:{}', '', 'George', 'Nills', '', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', '', '+16463863600', '', '', 'dsds@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(95, 'N', 0, 1, NULL, 3, '1799.94', '1799.94', '0.00', '0.00', '0.00', '', '0.00', 1720074902, 'C', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 3, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(96, 'N', 0, 1, NULL, 3, '972.00', '972.00', '0.00', '0.00', '0.00', '', '0.00', 1720074902, 'P', '', '', 'a:0:{}', '', 'Customer', 'Customer', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', 'Customer', 'Customer', '44 Main street', '', 'Boston', '', 'MA', 'US', '02134', '', '', '', '', '', 'customer@example.com', 2, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0),
(97, 'N', 0, 1, NULL, 3, '677.95', '649.95', '0.00', '0.00', '0.00', '1', '28.00', 1720074902, 'O', '', '', 'a:0:{}', '', 'George', 'Nills', '', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', 'George', 'Nills', '60 Centre Street #5', '', 'New York', '', 'NY', 'US', '01342', '+16463863600', '', '+16463863600', '', '', 'dsds@example.com', 1, 'N', 'en', '127.0.0.1', 0, '', 0, 2, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_data`
--

CREATE TABLE `[[dbprefix]]order_data` (
  `order_data_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `type` char(1) NOT NULL DEFAULT '',
  `data` longblob NOT NULL,
  PRIMARY KEY (`order_data_id`),
  UNIQUE KEY `idx_order_id_type` (`order_id`,`type`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=242 ;

--
-- Dumping data for table `[[dbprefix]]order_data`
--

INSERT INTO `[[dbprefix]]order_data` VALUES
(1, 28, 'R', 's:3:"USD";'),
(2, 28, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(3, 29, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(4, 29, 'R', 's:3:"USD";'),
(5, 35, 'R', 's:3:"USD";'),
(6, 35, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(7, 36, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(8, 36, 'R', 's:3:"USD";'),
(9, 37, 'R', 's:3:"USD";'),
(10, 37, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(11, 38, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(12, 38, 'R', 's:3:"USD";'),
(13, 39, 'R', 's:3:"USD";'),
(14, 39, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(15, 40, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(16, 40, 'R', 's:3:"USD";'),
(17, 41, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(18, 41, 'R', 's:3:"USD";'),
(19, 42, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(20, 42, 'R', 's:3:"USD";'),
(21, 43, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(22, 43, 'R', 's:3:"USD";'),
(23, 44, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(24, 44, 'R', 's:3:"USD";'),
(25, 45, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(26, 45, 'R', 's:3:"USD";'),
(27, 46, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(28, 46, 'R', 's:3:"USD";'),
(29, 47, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(30, 47, 'R', 's:3:"USD";'),
(31, 48, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(32, 48, 'R', 's:3:"USD";'),
(33, 49, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(34, 49, 'R', 's:3:"USD";'),
(35, 50, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"54";s:10:"rate_value";a:1:{s:1:"C";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:0;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:100;a:4:{s:6:"amount";s:3:"100";s:5:"value";d:25.449999999999999;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:25.449999999999999;s:10:"group_name";s:7:"CS-Cart";}}'),
(36, 50, 'R', 's:3:"USD";'),
(37, 51, 'R', 's:3:"USD";'),
(38, 51, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:14.359999999999999;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:11.81;s:1:"S";d:2.5499999999999998;s:5:"items";a:2:{s:1:"S";a:1:{i:0;a:1:{i:1;b:1;}}s:1:"P";a:1:{s:10:"3592732382";b:1;}}}}}'),
(39, 51, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(40, 52, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(41, 52, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:15.280000000000001;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:12.73;s:1:"S";d:2.5499999999999998;s:5:"items";a:2:{s:1:"S";a:1:{i:0;a:1:{i:1;b:1;}}s:1:"P";a:2:{s:9:"677409494";b:1;s:10:"4283906614";b:1;}}}}}'),
(42, 52, 'R', 's:3:"USD";'),
(43, 53, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:33;s:10:"group_name";s:7:"CS-Cart";}}'),
(44, 53, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:7.3600000000000003;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:4.3600000000000003;s:1:"S";d:3;s:5:"items";a:2:{s:1:"S";a:1:{i:0;a:1:{i:1;b:1;}}s:1:"P";a:1:{s:10:"2467687626";b:1;}}}}}'),
(45, 53, 'R', 's:3:"USD";'),
(46, 54, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:29.370000000000001;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:26.82;s:1:"S";d:2.5499999999999998;s:5:"items";a:2:{s:1:"S";a:1:{i:0;a:1:{i:1;b:1;}}s:1:"P";a:1:{s:10:"2703461960";b:1;}}}}}'),
(47, 54, 'R', 's:3:"USD";'),
(48, 54, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(49, 55, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(50, 55, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:99.819999999999993;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:97.269999999999996;s:1:"S";d:2.5499999999999998;s:5:"items";a:2:{s:1:"S";a:1:{i:0;a:1:{i:1;b:1;}}s:1:"P";a:2:{s:10:"3172189513";b:1;s:10:"1521215566";b:1;}}}}}'),
(51, 55, 'R', 's:3:"USD";'),
(52, 56, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(53, 56, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:27;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:24.449999999999999;s:1:"S";d:2.5499999999999998;s:5:"items";a:2:{s:1:"S";a:1:{i:0;a:1:{i:1;b:1;}}s:1:"P";a:1:{s:10:"3260818684";b:1;}}}}}'),
(54, 56, 'R', 's:3:"USD";'),
(55, 57, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:8.4600000000000009;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:2.73;s:1:"S";d:5.7300000000000004;s:5:"items";a:2:{s:1:"S";a:1:{i:0;a:1:{i:1;b:1;}}s:1:"P";a:1:{s:10:"2195660588";b:1;}}}}}'),
(56, 57, 'R', 's:3:"USD";'),
(57, 57, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:63;s:10:"group_name";s:7:"CS-Cart";}}'),
(58, 58, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(59, 58, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:520.27999999999997;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:517.73000000000002;s:1:"S";d:2.5499999999999998;s:5:"items";a:2:{s:1:"S";a:1:{i:0;a:1:{i:1;b:1;}}s:1:"P";a:1:{s:10:"4283388740";b:1;}}}}}'),
(60, 58, 'R', 's:3:"USD";'),
(61, 59, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:320.28000000000003;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:317.73000000000002;s:1:"S";d:2.5499999999999998;s:5:"items";a:2:{s:1:"S";a:1:{i:0;a:1:{i:1;b:1;}}s:1:"P";a:6:{s:10:"1159954462";b:1;s:10:"3308380389";b:1;s:10:"3260818684";b:1;s:10:"3042645098";b:1;s:10:"3421137111";b:1;s:10:"3994858278";b:1;}}}}}'),
(62, 59, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(63, 59, 'R', 's:3:"USD";'),
(64, 60, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(65, 60, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:61.640000000000001;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:59.090000000000003;s:1:"S";d:2.5499999999999998;s:5:"items";a:2:{s:1:"S";a:1:{i:0;a:1:{i:1;b:1;}}s:1:"P";a:1:{s:10:"4163016541";b:1;}}}}}'),
(66, 60, 'R', 's:3:"USD";'),
(67, 61, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(68, 61, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:43.640000000000001;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:43.640000000000001;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:1:{s:9:"342509608";b:1;}}}}}'),
(69, 61, 'R', 's:3:"USD";'),
(70, 62, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(71, 62, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:45.909999999999997;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:45.909999999999997;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:3:{s:10:"3816757317";b:1;s:9:"169655664";b:1;s:10:"2054572543";b:1;}}}}}'),
(72, 62, 'R', 's:3:"USD";'),
(73, 63, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(74, 63, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:9.0899999999999999;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:9.0899999999999999;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:3:{s:10:"2660368260";b:1;s:10:"1770303465";b:1;s:10:"1860791280";b:1;}}}}}'),
(75, 63, 'R', 's:3:"USD";'),
(76, 64, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(77, 64, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:228.18000000000001;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:228.18000000000001;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:4:{s:10:"2628381300";b:1;s:10:"4065481614";b:1;s:10:"3849671376";b:1;i:47022039;b:1;}}}}}'),
(78, 64, 'R', 's:3:"USD";'),
(79, 65, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(80, 65, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:57.270000000000003;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:57.270000000000003;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:1:{s:10:"3210050320";b:1;}}}}}'),
(81, 65, 'R', 's:3:"USD";'),
(82, 66, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(83, 66, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:517.73000000000002;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:517.73000000000002;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:1:{s:10:"4283388740";b:1;}}}}}'),
(84, 66, 'R', 's:3:"USD";'),
(85, 67, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(86, 67, 'R', 's:3:"USD";'),
(87, 68, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(88, 68, 'R', 's:3:"USD";'),
(89, 69, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(90, 69, 'R', 's:3:"USD";'),
(91, 70, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(92, 70, 'R', 's:3:"USD";'),
(93, 71, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(94, 71, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:24.09;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:24.09;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:3:{s:10:"4283906614";b:1;s:9:"822274303";b:1;s:9:"677409494";b:1;}}}}}'),
(95, 71, 'R', 's:3:"USD";'),
(96, 72, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(97, 72, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:10.449999999999999;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:10.449999999999999;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:3:{s:10:"4283906614";b:1;s:9:"822274303";b:1;s:9:"677409494";b:1;}}}}}'),
(98, 72, 'R', 's:3:"USD";'),
(99, 73, 'R', 's:3:"USD";'),
(100, 73, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(101, 73, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:13.640000000000001;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:13.640000000000001;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:1:{s:10:"3636250333";b:1;}}}}}'),
(102, 74, 'R', 's:3:"USD";'),
(103, 74, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(104, 74, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:26.039999999999999;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:26.039999999999999;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:13:{s:10:"2338935559";b:1;s:10:"4235092881";b:1;s:10:"1825668608";b:1;s:10:"1446436389";b:1;s:9:"556920499";b:1;s:10:"3477049247";b:1;s:10:"3090726665";b:1;s:10:"2243091253";b:1;s:9:"482052751";b:1;s:9:"467029654";b:1;s:10:"2195660588";b:1;s:9:"643574442";b:1;s:10:"4124585914";b:1;}}}}}');
INSERT INTO `[[dbprefix]]order_data` VALUES
(105, 75, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(106, 75, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:145.44;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:145.44;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:1:{s:10:"2836788418";b:1;}}}}}'),
(107, 75, 'R', 's:3:"USD";'),
(108, 76, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(109, 76, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:300;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:300;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:1:{s:9:"319261745";b:1;}}}}}'),
(110, 76, 'R', 's:3:"USD";'),
(111, 77, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(112, 77, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:81.620000000000005;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:81.620000000000005;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:4:{s:10:"2583444381";b:1;s:10:"3390371295";b:1;s:10:"1394451557";b:1;s:10:"1416650876";b:1;}}}}}'),
(113, 77, 'R', 's:3:"USD";'),
(114, 78, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(115, 78, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:163.63;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:163.63;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:2:{s:10:"4072008611";b:1;s:10:"3961824982";b:1;}}}}}'),
(116, 78, 'R', 's:3:"USD";'),
(117, 79, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(118, 79, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:88.359999999999999;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:88.359999999999999;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:1:{s:10:"1061624811";b:1;}}}}}'),
(119, 79, 'R', 's:3:"USD";'),
(120, 80, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(121, 80, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:90.730000000000004;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:90.730000000000004;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:1:{s:10:"3125424156";b:1;}}}}}'),
(122, 80, 'R', 's:3:"USD";'),
(123, 81, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(124, 81, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:272.25999999999999;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:272.25999999999999;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:6:{s:10:"1792750741";b:1;s:10:"2473281379";b:1;s:10:"2366072709";b:1;s:10:"4033496702";b:1;s:10:"3864289797";b:1;s:10:"3947455183";b:1;}}}}}'),
(125, 81, 'R', 's:3:"USD";'),
(126, 82, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:68.180000000000007;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:68.180000000000007;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:1:{s:10:"1364924988";b:1;}}}}}'),
(127, 82, 'R', 's:3:"USD";'),
(128, 82, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(129, 83, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(130, 83, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:95.359999999999999;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:95.359999999999999;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:2:{s:9:"500958211";b:1;s:10:"2372082066";b:1;}}}}}'),
(131, 83, 'R', 's:3:"USD";'),
(132, 84, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(133, 84, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:300;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:300;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:1:{s:9:"319261745";b:1;}}}}}'),
(134, 84, 'R', 's:3:"USD";'),
(135, 85, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(136, 85, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:81.620000000000005;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:81.620000000000005;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:4:{s:10:"2583444381";b:1;s:10:"3390371295";b:1;s:10:"1394451557";b:1;s:10:"1416650876";b:1;}}}}}'),
(137, 85, 'R', 's:3:"USD";'),
(138, 86, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(139, 86, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:163.63;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:163.63;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:2:{s:10:"4072008611";b:1;s:10:"3961824982";b:1;}}}}}'),
(140, 86, 'R', 's:3:"USD";'),
(141, 87, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(142, 87, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:88.359999999999999;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:88.359999999999999;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:1:{s:10:"1061624811";b:1;}}}}}'),
(143, 87, 'R', 's:3:"USD";'),
(144, 89, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(145, 89, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:272.25999999999999;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:272.25999999999999;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:6:{s:10:"1792750741";b:1;s:10:"2473281379";b:1;s:10:"2366072709";b:1;s:10:"4033496702";b:1;s:10:"3864289797";b:1;s:10:"3947455183";b:1;}}}}}'),
(146, 89, 'R', 's:3:"USD";'),
(147, 90, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:68.180000000000007;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:68.180000000000007;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:1:{s:10:"1364924988";b:1;}}}}}'),
(148, 90, 'R', 's:3:"USD";'),
(149, 90, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(150, 91, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(151, 91, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:95.359999999999999;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:95.359999999999999;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:2:{s:9:"500958211";b:1;s:10:"2372082066";b:1;}}}}}'),
(152, 91, 'R', 's:3:"USD";'),
(153, 92, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(154, 92, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:61.640000000000001;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:59.090000000000003;s:1:"S";d:2.5499999999999998;s:5:"items";a:2:{s:1:"S";a:1:{i:0;a:1:{i:1;b:1;}}s:1:"P";a:1:{s:10:"4163016541";b:1;}}}}}'),
(155, 92, 'R', 's:3:"USD";'),
(156, 93, 'R', 's:3:"USD";'),
(157, 93, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(158, 93, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:13.640000000000001;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:13.640000000000001;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:1:{s:10:"3636250333";b:1;}}}}}'),
(159, 94, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(160, 94, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:27;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:24.449999999999999;s:1:"S";d:2.5499999999999998;s:5:"items";a:2:{s:1:"S";a:1:{i:0;a:1:{i:1;b:1;}}s:1:"P";a:1:{s:10:"3260818684";b:1;}}}}}'),
(161, 94, 'R', 's:3:"USD";'),
(162, 95, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(163, 95, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:163.63;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:163.63;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:2:{s:10:"4072008611";b:1;s:10:"3961824982";b:1;}}}}}'),
(164, 95, 'R', 's:3:"USD";'),
(165, 96, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(166, 96, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:88.359999999999999;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:88.359999999999999;s:1:"S";i:0;s:5:"items";a:2:{s:1:"S";a:0:{}s:1:"P";a:1:{s:10:"1061624811";b:1;}}}}}'),
(167, 96, 'R', 's:3:"USD";'),
(168, 97, 'L', 'a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"55";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:40;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:30;a:4:{s:6:"amount";s:2:"30";s:5:"value";d:10;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:50;a:4:{s:6:"amount";s:2:"50";s:5:"value";d:5;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}s:1:"I";a:2:{i:0;a:4:{s:6:"amount";s:1:"0";s:5:"value";d:23;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}i:10;a:4:{s:6:"amount";s:2:"10";s:5:"value";d:15;s:4:"type";s:1:"F";s:8:"per_unit";s:1:"N";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}'),
(169, 97, 'T', 'a:1:{i:6;a:8:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:6:"10.000";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:61.640000000000001;s:11:"description";s:3:"VAT";s:7:"applies";a:3:{s:1:"P";d:59.090000000000003;s:1:"S";d:2.5499999999999998;s:5:"items";a:2:{s:1:"S";a:1:{i:0;a:1:{i:1;b:1;}}s:1:"P";a:1:{s:10:"4163016541";b:1;}}}}}'),
(170, 97, 'R', 's:3:"USD";'),
(171, 50, 'G', 'a:1:{i:0;a:10:{s:4:"name";s:7:"CS-Cart";s:10:"company_id";i:1;s:8:"products";a:1:{s:10:"3994858278";a:23:{s:10:"product_id";i:60;s:12:"product_code";s:10:"O0060X7Y9Y";s:7:"product";s:11:"AVIC-Z130BT";s:6:"amount";i:1;s:15:"product_options";a:0:{}s:5:"price";d:1499;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"328";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"384";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:63:"http://localhost/git/work/images/detailed/0/AVIC-Z130BT_reg.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"500";s:7:"image_y";s:3:"500";s:15:"http_image_path";s:63:"http://localhost/git/work/images/detailed/0/AVIC-Z130BT_reg.jpg";s:13:"absolute_path";s:66:"/Users/alexions/www/git/work/images/detailed/0/AVIC-Z130BT_reg.jpg";s:13:"relative_path";s:30:"detailed/0/AVIC-Z130BT_reg.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"3994858278";s:6:"amount";s:1:"1";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:11:"AVIC-Z130BT";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:1499;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:1499;s:13:"display_price";d:1499;}}s:12:"package_info";a:7:{s:1:"C";d:1499;s:1:"W";s:4:"0.01";s:1:"I";i:1;s:16:"shipping_freight";d:0;s:8:"packages";a:1:{i:0;a:4:{s:8:"products";a:1:{s:10:"3994858278";i:1;}s:6:"amount";i:1;s:6:"weight";d:0.100;s:4:"cost";i:1499;}}s:11:"origination";a:8:{s:4:"name";s:7:"CS-Cart";s:7:"address";s:14:"44 Main street";s:4:"city";s:6:"Boston";s:7:"country";s:2:"US";s:5:"state";s:2:"MA";s:7:"zipcode";s:5:"02116";s:5:"phone";s:12:"+16175556985";s:3:"fax";s:0:"";}s:8:"location";a:13:{s:9:"firstname";s:6:"Sergey";s:8:"lastname";s:6:"Maxeev";s:7:"address";s:25:"Moskovskaya street, 65-12";s:9:"address_2";N;s:4:"city";s:6:"Moscow";s:6:"county";N;s:5:"state";s:3:"MOS";s:7:"country";s:2:"RU";s:7:"zipcode";s:6:"657849";s:5:"phone";s:12:"+79235456683";s:12:"address_type";s:11:"residential";s:13:"country_descr";s:18:"Russian Federation";s:11:"state_descr";s:19:"Moskovskaja oblast''";}}s:21:"all_edp_free_shipping";b:0;s:17:"all_free_shipping";b:0;s:13:"free_shipping";b:0;s:20:"shipping_no_required";b:0;s:9:"shippings";a:1:{i:1;a:16:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"45";s:10:"rate_value";a:1:{s:1:"C";a:2:{i:0;a:2:{s:5:"value";s:4:"0.00";s:4:"type";s:1:"F";}i:100;a:2:{s:5:"value";s:5:"25.45";s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:25.449;s:11:"taxed_price";i:0;s:5:"taxes";a:1:{i:6;a:7:{s:9:"rate_type";s:1:"F";s:10:"rate_value";s:2:"12";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:12;s:11:"description";s:3:"VAT";}}}}s:16:"chosen_shippings";a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"45";s:10:"rate_value";a:1:{s:1:"C";a:2:{i:0;a:2:{s:5:"value";s:4:"0.00";s:4:"type";s:1:"F";}i:100;a:2:{s:5:"value";s:5:"25.45";s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:25.449;s:10:"group_name";s:7:"CS-Cart";}}}}'),
(172, 51, 'G', 'a:1:{i:0;a:10:{s:4:"name";s:7:"CS-Cart";s:10:"company_id";i:1;s:8:"products";a:1:{s:10:"3592732382";a:23:{s:10:"product_id";i:212;s:12:"product_code";s:10:"P0212CTOEA";s:7:"product";s:53:"Panasonic KX-MB2000 24PPM 3-in-1 Monochrome Laser MFP";s:6:"amount";i:1;s:15:"product_options";a:0:{}s:5:"price";d:129.949;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"705";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"761";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:84:"http://localhost/git/work/images/detailed/0/0120b3d3-82ef-4d27-8d43-9d75b4db19a1.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"700";s:7:"image_y";s:3:"525";s:15:"http_image_path";s:84:"http://localhost/git/work/images/detailed/0/0120b3d3-82ef-4d27-8d43-9d75b4db19a1.jpg";s:13:"absolute_path";s:87:"/Users/alexions/www/git/work/images/detailed/0/0120b3d3-82ef-4d27-8d43-9d75b4db19a1.jpg";s:13:"relative_path";s:51:"detailed/0/0120b3d3-82ef-4d27-8d43-9d75b4db19a1.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"3592732382";s:6:"amount";s:1:"1";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:53:"Panasonic KX-MB2000 24PPM 3-in-1 Monochrome Laser MFP";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:129.949;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:129.949;s:13:"display_price";d:129.949;}}s:12:"package_info";a:7:{s:1:"C";d:129.949;s:1:"W";s:4:"0.01";s:1:"I";i:1;s:16:"shipping_freight";d:0;s:8:"packages";a:1:{i:0;a:4:{s:8:"products";a:1:{s:10:"3592732382";i:1;}s:6:"amount";i:1;s:6:"weight";d:0.100;s:4:"cost";d:129.949;}}s:11:"origination";a:8:{s:4:"name";s:7:"CS-Cart";s:7:"address";s:14:"44 Main street";s:4:"city";s:6:"Boston";s:7:"country";s:2:"US";s:5:"state";s:2:"MA";s:7:"zipcode";s:5:"02116";s:5:"phone";s:12:"+16175556985";s:3:"fax";s:0:"";}s:8:"location";a:13:{s:9:"firstname";s:6:"George";s:8:"lastname";s:5:"Nills";s:7:"address";s:19:"60 Centre Street #5";s:9:"address_2";N;s:4:"city";s:8:"New York";s:6:"county";N;s:5:"state";s:2:"NY";s:7:"country";s:2:"US";s:7:"zipcode";s:5:"01342";s:5:"phone";s:12:"+16463863600";s:12:"address_type";s:11:"residential";s:13:"country_descr";s:13:"United States";s:11:"state_descr";s:8:"New York";}}s:21:"all_edp_free_shipping";b:0;s:17:"all_free_shipping";b:0;s:13:"free_shipping";b:0;s:20:"shipping_no_required";b:0;s:9:"shippings";a:1:{i:1;a:16:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:11:"taxed_price";i:0;s:5:"taxes";a:1:{i:6;a:7:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:2:"10";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:2.549;s:11:"description";s:3:"VAT";}}}}s:16:"chosen_shippings";a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}}}'),
(173, 52, 'G', 'a:1:{i:0;a:10:{s:4:"name";s:7:"CS-Cart";s:10:"company_id";i:1;s:8:"products";a:3:{s:9:"822274303";a:23:{s:10:"product_id";i:12;s:12:"product_code";s:10:"U0012O5AF0";s:7:"product";s:10:"100g Pants";s:6:"amount";i:1;s:15:"product_options";a:2:{i:9;s:2:"17";i:2;s:1:"6";}s:5:"price";d:30;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"808";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"864";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:57:"http://localhost/git/work/images/detailed/0/173283_01.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"500";s:7:"image_y";s:3:"500";s:15:"http_image_path";s:57:"http://localhost/git/work/images/detailed/0/173283_01.jpg";s:13:"absolute_path";s:60:"/Users/alexions/www/git/work/images/detailed/0/173283_01.jpg";s:13:"relative_path";s:24:"detailed/0/173283_01.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:9:"822274303";s:6:"amount";s:1:"1";}s:5:"extra";a:10:{s:15:"product_options";a:2:{i:9;s:2:"17";i:2;s:1:"6";}s:18:"unlimited_download";s:1:"N";s:7:"product";s:10:"100g Pants";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:30;s:12:"stored_price";s:1:"N";s:21:"product_options_value";a:2:{i:0;a:22:{s:9:"option_id";s:1:"9";s:10:"product_id";s:2:"12";s:10:"company_id";s:1:"1";s:11:"option_type";s:1:"S";s:9:"inventory";s:1:"Y";s:6:"regexp";s:0:"";s:8:"required";s:1:"N";s:11:"multiupload";s:1:"N";s:18:"allowed_extensions";s:0:"";s:13:"max_file_size";s:1:"0";s:25:"missing_variants_handling";s:1:"M";s:6:"status";s:1:"A";s:8:"position";s:1:"0";s:5:"value";s:2:"17";s:11:"option_name";s:5:"Color";s:11:"option_text";s:0:"";s:11:"description";s:0:"";s:10:"inner_hint";s:0:"";s:17:"incorrect_message";s:0:"";s:8:"modifier";s:5:"0.000";s:13:"modifier_type";s:1:"A";s:12:"variant_name";s:17:"Black/White/White";}i:1;a:22:{s:9:"option_id";s:1:"2";s:10:"product_id";s:2:"12";s:10:"company_id";s:1:"1";s:11:"option_type";s:1:"S";s:9:"inventory";s:1:"Y";s:6:"regexp";s:0:"";s:8:"required";s:1:"N";s:11:"multiupload";s:1:"N";s:18:"allowed_extensions";s:0:"";s:13:"max_file_size";s:1:"0";s:25:"missing_variants_handling";s:1:"M";s:6:"status";s:1:"A";s:8:"position";s:2:"10";s:5:"value";s:1:"6";s:11:"option_name";s:4:"Size";s:11:"option_text";s:4:"Size";s:11:"description";s:0:"";s:10:"inner_hint";s:0:"";s:17:"incorrect_message";s:0:"";s:8:"modifier";s:5:"0.000";s:13:"modifier_type";s:1:"A";s:12:"variant_name";s:5:"Small";}}}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:30;s:13:"display_price";d:30;}s:9:"677409494";a:23:{s:10:"product_id";i:11;s:12:"product_code";s:10:"Z0011CZSNI";s:7:"product";s:17:"Collegiate 72 Tee";s:6:"amount";i:1;s:15:"product_options";a:2:{i:1;s:1:"1";i:2;s:1:"6";}s:5:"price";d:30;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"210";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"266";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:57:"http://localhost/git/work/images/detailed/0/X32444_01.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:4:"2000";s:7:"image_y";s:4:"2000";s:15:"http_image_path";s:57:"http://localhost/git/work/images/detailed/0/X32444_01.jpg";s:13:"absolute_path";s:60:"/Users/alexions/www/git/work/images/detailed/0/X32444_01.jpg";s:13:"relative_path";s:24:"detailed/0/X32444_01.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:9:"677409494";s:6:"amount";s:1:"1";}s:5:"extra";a:10:{s:15:"product_options";a:2:{i:1;s:1:"1";i:2;s:1:"6";}s:18:"unlimited_download";s:1:"N";s:7:"product";s:17:"Collegiate 72 Tee";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:30;s:12:"stored_price";s:1:"N";s:21:"product_options_value";a:2:{i:0;a:22:{s:9:"option_id";s:1:"1";s:10:"product_id";s:2:"11";s:10:"company_id";s:1:"1";s:11:"option_type";s:1:"S";s:9:"inventory";s:1:"N";s:6:"regexp";s:0:"";s:8:"required";s:1:"N";s:11:"multiupload";s:1:"N";s:18:"allowed_extensions";s:0:"";s:13:"max_file_size";s:1:"0";s:25:"missing_variants_handling";s:1:"M";s:6:"status";s:1:"A";s:8:"position";s:1:"0";s:5:"value";s:1:"1";s:11:"option_name";s:5:"Color";s:11:"option_text";s:0:"";s:11:"description";s:0:"";s:10:"inner_hint";s:0:"";s:17:"incorrect_message";s:0:"";s:8:"modifier";s:5:"0.000";s:13:"modifier_type";s:1:"A";s:12:"variant_name";s:5:"White";}i:1;a:22:{s:9:"option_id";s:1:"2";s:10:"product_id";s:2:"11";s:10:"company_id";s:1:"1";s:11:"option_type";s:1:"S";s:9:"inventory";s:1:"Y";s:6:"regexp";s:0:"";s:8:"required";s:1:"N";s:11:"multiupload";s:1:"N";s:18:"allowed_extensions";s:0:"";s:13:"max_file_size";s:1:"0";s:25:"missing_variants_handling";s:1:"M";s:6:"status";s:1:"A";s:8:"position";s:2:"10";s:5:"value";s:1:"6";s:11:"option_name";s:4:"Size";s:11:"option_text";s:4:"Size";s:11:"description";s:0:"";s:10:"inner_hint";s:0:"";s:17:"incorrect_message";s:0:"";s:8:"modifier";s:5:"0.000";s:13:"modifier_type";s:1:"A";s:12:"variant_name";s:5:"Small";}}}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:30;s:13:"display_price";d:30;}s:10:"4283906614";a:23:{s:10:"product_id";i:7;s:12:"product_code";s:10:"A0007DQ1TL";s:7:"product";s:14:"Trefoil Hoodie";s:6:"amount";i:2;s:15:"product_options";a:2:{i:10;s:2:"36";i:2;s:1:"6";}s:5:"price";d:55;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"827";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"883";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:57:"http://localhost/git/work/images/detailed/0/X41181_01.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:4:"2400";s:7:"image_y";s:4:"2400";s:15:"http_image_path";s:57:"http://localhost/git/work/images/detailed/0/X41181_01.jpg";s:13:"absolute_path";s:60:"/Users/alexions/www/git/work/images/detailed/0/X41181_01.jpg";s:13:"relative_path";s:24:"detailed/0/X41181_01.jpg";}}s:15:"original_amount";s:1:"2";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"4283906614";s:6:"amount";s:1:"2";}s:5:"extra";a:10:{s:15:"product_options";a:2:{i:10;s:2:"36";i:2;s:1:"6";}s:18:"unlimited_download";s:1:"N";s:7:"product";s:14:"Trefoil Hoodie";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:55;s:12:"stored_price";s:1:"N";s:21:"product_options_value";a:2:{i:0;a:22:{s:9:"option_id";s:2:"10";s:10:"product_id";s:1:"7";s:10:"company_id";s:1:"1";s:11:"option_type";s:1:"S";s:9:"inventory";s:1:"Y";s:6:"regexp";s:0:"";s:8:"required";s:1:"N";s:11:"multiupload";s:1:"N";s:18:"allowed_extensions";s:0:"";s:13:"max_file_size";s:1:"0";s:25:"missing_variants_handling";s:1:"M";s:6:"status";s:1:"A";s:8:"position";s:1:"0";s:5:"value";s:2:"36";s:11:"option_name";s:5:"Color";s:11:"option_text";s:0:"";s:11:"description";s:0:"";s:10:"inner_hint";s:0:"";s:17:"incorrect_message";s:0:"";s:8:"modifier";s:5:"0.000";s:13:"modifier_type";s:1:"A";s:12:"variant_name";s:23:"GreyHeather/Core Energy";}i:1;a:22:{s:9:"option_id";s:1:"2";s:10:"product_id";s:1:"7";s:10:"company_id";s:1:"1";s:11:"option_type";s:1:"S";s:9:"inventory";s:1:"Y";s:6:"regexp";s:0:"";s:8:"required";s:1:"N";s:11:"multiupload";s:1:"N";s:18:"allowed_extensions";s:0:"";s:13:"max_file_size";s:1:"0";s:25:"missing_variants_handling";s:1:"M";s:6:"status";s:1:"A";s:8:"position";s:2:"10";s:5:"value";s:1:"6";s:11:"option_name";s:4:"Size";s:11:"option_text";s:4:"Size";s:11:"description";s:0:"";s:10:"inner_hint";s:0:"";s:17:"incorrect_message";s:0:"";s:8:"modifier";s:5:"0.000";s:13:"modifier_type";s:1:"A";s:12:"variant_name";s:5:"Small";}}}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:2;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:55;s:13:"display_price";d:55;}}s:12:"package_info";a:7:{s:1:"C";d:170;s:1:"W";s:4:"0.01";s:1:"I";i:4;s:16:"shipping_freight";d:0;s:8:"packages";a:1:{i:0;a:4:{s:8:"products";a:3:{s:9:"822274303";i:1;s:9:"677409494";i:1;s:10:"4283906614";i:2;}s:6:"amount";i:4;s:6:"weight";d:0.100;s:4:"cost";i:170;}}s:11:"origination";a:8:{s:4:"name";s:7:"CS-Cart";s:7:"address";s:14:"44 Main street";s:4:"city";s:6:"Boston";s:7:"country";s:2:"US";s:5:"state";s:2:"MA";s:7:"zipcode";s:5:"02116";s:5:"phone";s:12:"+16175556985";s:3:"fax";s:0:"";}s:8:"location";a:13:{s:9:"firstname";s:6:"George";s:8:"lastname";s:5:"Nills";s:7:"address";s:19:"60 Centre Street #5";s:9:"address_2";N;s:4:"city";s:8:"New York";s:6:"county";N;s:5:"state";s:2:"NY";s:7:"country";s:2:"US";s:7:"zipcode";s:5:"01342";s:5:"phone";s:12:"+16463863600";s:12:"address_type";s:11:"residential";s:13:"country_descr";s:13:"United States";s:11:"state_descr";s:8:"New York";}}s:21:"all_edp_free_shipping";b:0;s:17:"all_free_shipping";b:0;s:13:"free_shipping";b:0;s:20:"shipping_no_required";b:0;s:9:"shippings";a:1:{i:1;a:16:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:11:"taxed_price";i:0;s:5:"taxes";a:1:{i:6;a:7:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:2:"10";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:2.549;s:11:"description";s:3:"VAT";}}}}s:16:"chosen_shippings";a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}}}');
INSERT INTO `[[dbprefix]]order_data` VALUES
(174, 53, 'G', 'a:1:{i:0;a:10:{s:4:"name";s:7:"CS-Cart";s:10:"company_id";i:1;s:8:"products";a:1:{s:10:"2467687626";a:23:{s:10:"product_id";i:233;s:12:"product_code";s:10:"H023315I7E";s:7:"product";s:38:"Crystal Lake Warm Weather Sleeping Bag";s:6:"amount";i:1;s:15:"product_options";a:0:{}s:5:"price";d:47.990;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"791";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"847";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:62:"http://localhost/git/work/images/detailed/0/2000004455_500.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"500";s:7:"image_y";s:3:"500";s:15:"http_image_path";s:62:"http://localhost/git/work/images/detailed/0/2000004455_500.jpg";s:13:"absolute_path";s:65:"/Users/alexions/www/git/work/images/detailed/0/2000004455_500.jpg";s:13:"relative_path";s:29:"detailed/0/2000004455_500.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"2467687626";s:6:"amount";s:1:"1";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:38:"Crystal Lake Warm Weather Sleeping Bag";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:47.990;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:47.990;s:13:"display_price";d:47.990;}}s:12:"package_info";a:7:{s:1:"C";d:47.990;s:1:"W";s:4:"0.01";s:1:"I";i:1;s:16:"shipping_freight";d:0;s:8:"packages";a:1:{i:0;a:4:{s:8:"products";a:1:{s:10:"2467687626";i:1;}s:6:"amount";i:1;s:6:"weight";d:0.100;s:4:"cost";d:47.990;}}s:11:"origination";a:8:{s:4:"name";s:7:"CS-Cart";s:7:"address";s:14:"44 Main street";s:4:"city";s:6:"Boston";s:7:"country";s:2:"US";s:5:"state";s:2:"MA";s:7:"zipcode";s:5:"02116";s:5:"phone";s:12:"+16175556985";s:3:"fax";s:0:"";}s:8:"location";a:13:{s:9:"firstname";s:6:"George";s:8:"lastname";s:5:"Nills";s:7:"address";s:19:"60 Centre Street #5";s:9:"address_2";N;s:4:"city";s:8:"New York";s:6:"county";N;s:5:"state";s:2:"NY";s:7:"country";s:2:"US";s:7:"zipcode";s:5:"01342";s:5:"phone";s:12:"+16463863600";s:12:"address_type";s:11:"residential";s:13:"country_descr";s:13:"United States";s:11:"state_descr";s:8:"New York";}}s:21:"all_edp_free_shipping";b:0;s:17:"all_free_shipping";b:0;s:13:"free_shipping";b:0;s:20:"shipping_no_required";b:0;s:9:"shippings";a:1:{i:1;a:16:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:33;s:11:"taxed_price";i:0;s:5:"taxes";a:1:{i:6;a:7:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:2:"10";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:3;s:11:"description";s:3:"VAT";}}}}s:16:"chosen_shippings";a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:33;s:10:"group_name";s:7:"CS-Cart";}}}}'),
(175, 54, 'G', 'a:1:{i:0;a:10:{s:4:"name";s:7:"CS-Cart";s:10:"company_id";i:1;s:8:"products";a:1:{s:10:"2703461960";a:23:{s:10:"product_id";i:213;s:12:"product_code";s:10:"R0213E2U6B";s:7:"product";s:37:"Intel® Boxed Intel® Core™ i7-2600";s:6:"amount";i:1;s:15:"product_options";a:0:{}s:5:"price";d:295;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"708";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"764";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:60:"http://localhost/git/work/images/detailed/0/imageservice.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:4:"1732";s:7:"image_y";s:4:"2182";s:15:"http_image_path";s:60:"http://localhost/git/work/images/detailed/0/imageservice.jpg";s:13:"absolute_path";s:63:"/Users/alexions/www/git/work/images/detailed/0/imageservice.jpg";s:13:"relative_path";s:27:"detailed/0/imageservice.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"2703461960";s:6:"amount";s:1:"1";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:37:"Intel® Boxed Intel® Core™ i7-2600";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:295;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:295;s:13:"display_price";d:295;}}s:12:"package_info";a:7:{s:1:"C";d:295;s:1:"W";s:4:"0.01";s:1:"I";i:1;s:16:"shipping_freight";d:0;s:8:"packages";a:1:{i:0;a:4:{s:8:"products";a:1:{s:10:"2703461960";i:1;}s:6:"amount";i:1;s:6:"weight";d:0.100;s:4:"cost";i:295;}}s:11:"origination";a:8:{s:4:"name";s:7:"CS-Cart";s:7:"address";s:14:"44 Main street";s:4:"city";s:6:"Boston";s:7:"country";s:2:"US";s:5:"state";s:2:"MA";s:7:"zipcode";s:5:"02116";s:5:"phone";s:12:"+16175556985";s:3:"fax";s:0:"";}s:8:"location";a:13:{s:9:"firstname";s:6:"George";s:8:"lastname";s:5:"Nills";s:7:"address";s:19:"60 Centre Street #5";s:9:"address_2";N;s:4:"city";s:8:"New York";s:6:"county";N;s:5:"state";s:2:"NY";s:7:"country";s:2:"US";s:7:"zipcode";s:5:"01342";s:5:"phone";s:12:"+16463863600";s:12:"address_type";s:11:"residential";s:13:"country_descr";s:13:"United States";s:11:"state_descr";s:8:"New York";}}s:21:"all_edp_free_shipping";b:0;s:17:"all_free_shipping";b:0;s:13:"free_shipping";b:0;s:20:"shipping_no_required";b:0;s:9:"shippings";a:1:{i:1;a:16:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:11:"taxed_price";i:0;s:5:"taxes";a:1:{i:6;a:7:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:2:"10";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:2.549;s:11:"description";s:3:"VAT";}}}}s:16:"chosen_shippings";a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}}}'),
(176, 55, 'G', 'a:1:{i:0;a:10:{s:4:"name";s:7:"CS-Cart";s:10:"company_id";i:1;s:8:"products";a:2:{s:10:"3172189513";a:23:{s:10:"product_id";i:107;s:12:"product_code";s:10:"F01072HXUI";s:7:"product";s:39:"Montblanc Classic Collection Money Clip";s:6:"amount";i:2;s:15:"product_options";a:0:{}s:5:"price";d:465;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"451";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"507";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:60:"http://localhost/git/work/images/detailed/0/03804_l.ashx.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"500";s:7:"image_y";s:3:"500";s:15:"http_image_path";s:60:"http://localhost/git/work/images/detailed/0/03804_l.ashx.jpg";s:13:"absolute_path";s:63:"/Users/alexions/www/git/work/images/detailed/0/03804_l.ashx.jpg";s:13:"relative_path";s:27:"detailed/0/03804_l.ashx.jpg";}}s:15:"original_amount";s:1:"2";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"3172189513";s:6:"amount";s:1:"2";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:39:"Montblanc Classic Collection Money Clip";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:465;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:2;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:465;s:13:"display_price";d:465;}s:10:"1521215566";a:23:{s:10:"product_id";i:109;s:12:"product_code";s:10:"C01099FRFC";s:7:"product";s:64:"Montblanc Contemporary Collection Key Ring with Montblanc emblem";s:6:"amount";i:1;s:15:"product_options";a:0:{}s:5:"price";d:140;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"453";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"509";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:61:"http://localhost/git/work/images/detailed/0/101796_l.ashx.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"500";s:7:"image_y";s:3:"500";s:15:"http_image_path";s:61:"http://localhost/git/work/images/detailed/0/101796_l.ashx.jpg";s:13:"absolute_path";s:64:"/Users/alexions/www/git/work/images/detailed/0/101796_l.ashx.jpg";s:13:"relative_path";s:28:"detailed/0/101796_l.ashx.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"1521215566";s:6:"amount";s:1:"1";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:64:"Montblanc Contemporary Collection Key Ring with Montblanc emblem";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:140;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:140;s:13:"display_price";d:140;}}s:12:"package_info";a:7:{s:1:"C";d:1070;s:1:"W";s:4:"0.01";s:1:"I";i:3;s:16:"shipping_freight";d:0;s:8:"packages";a:1:{i:0;a:4:{s:8:"products";a:2:{s:10:"3172189513";i:2;s:10:"1521215566";i:1;}s:6:"amount";i:3;s:6:"weight";d:0.100;s:4:"cost";i:1070;}}s:11:"origination";a:8:{s:4:"name";s:7:"CS-Cart";s:7:"address";s:14:"44 Main street";s:4:"city";s:6:"Boston";s:7:"country";s:2:"US";s:5:"state";s:2:"MA";s:7:"zipcode";s:5:"02116";s:5:"phone";s:12:"+16175556985";s:3:"fax";s:0:"";}s:8:"location";a:13:{s:9:"firstname";s:6:"George";s:8:"lastname";s:5:"Nills";s:7:"address";s:19:"60 Centre Street #5";s:9:"address_2";N;s:4:"city";s:8:"New York";s:6:"county";N;s:5:"state";s:2:"NY";s:7:"country";s:2:"US";s:7:"zipcode";s:5:"01342";s:5:"phone";s:12:"+16463863600";s:12:"address_type";s:11:"residential";s:13:"country_descr";s:13:"United States";s:11:"state_descr";s:8:"New York";}}s:21:"all_edp_free_shipping";b:0;s:17:"all_free_shipping";b:0;s:13:"free_shipping";b:0;s:20:"shipping_no_required";b:0;s:9:"shippings";a:1:{i:1;a:16:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:11:"taxed_price";i:0;s:5:"taxes";a:1:{i:6;a:7:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:2:"10";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:2.549;s:11:"description";s:3:"VAT";}}}}s:16:"chosen_shippings";a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}}}'),
(177, 56, 'G', 'a:1:{i:0;a:10:{s:4:"name";s:7:"CS-Cart";s:10:"company_id";i:1;s:8:"products";a:1:{s:10:"3260818684";a:23:{s:10:"product_id";i:54;s:12:"product_code";s:10:"I0054QMMPO";s:7:"product";s:13:"TS-W3002D2|D4";s:6:"amount";i:1;s:15:"product_options";a:0:{}s:5:"price";d:269;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"307";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"363";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:66:"http://localhost/git/work/images/detailed/0/TS-W3002D2D4_large.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:4:"1024";s:7:"image_y";s:4:"1024";s:15:"http_image_path";s:66:"http://localhost/git/work/images/detailed/0/TS-W3002D2D4_large.jpg";s:13:"absolute_path";s:69:"/Users/alexions/www/git/work/images/detailed/0/TS-W3002D2D4_large.jpg";s:13:"relative_path";s:33:"detailed/0/TS-W3002D2D4_large.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"3260818684";s:6:"amount";s:1:"1";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:13:"TS-W3002D2|D4";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:269;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:269;s:13:"display_price";d:269;}}s:12:"package_info";a:7:{s:1:"C";d:269;s:1:"W";s:4:"0.01";s:1:"I";i:1;s:16:"shipping_freight";d:0;s:8:"packages";a:1:{i:0;a:4:{s:8:"products";a:1:{s:10:"3260818684";i:1;}s:6:"amount";i:1;s:6:"weight";d:0.100;s:4:"cost";i:269;}}s:11:"origination";a:8:{s:4:"name";s:7:"CS-Cart";s:7:"address";s:14:"44 Main street";s:4:"city";s:6:"Boston";s:7:"country";s:2:"US";s:5:"state";s:2:"MA";s:7:"zipcode";s:5:"02116";s:5:"phone";s:12:"+16175556985";s:3:"fax";s:0:"";}s:8:"location";a:13:{s:9:"firstname";s:6:"George";s:8:"lastname";s:5:"Nills";s:7:"address";s:19:"60 Centre Street #5";s:9:"address_2";N;s:4:"city";s:8:"New York";s:6:"county";N;s:5:"state";s:2:"NY";s:7:"country";s:2:"US";s:7:"zipcode";s:5:"01342";s:5:"phone";s:12:"+16463863600";s:12:"address_type";s:11:"residential";s:13:"country_descr";s:13:"United States";s:11:"state_descr";s:8:"New York";}}s:21:"all_edp_free_shipping";b:0;s:17:"all_free_shipping";b:0;s:13:"free_shipping";b:0;s:20:"shipping_no_required";b:0;s:9:"shippings";a:1:{i:1;a:16:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:11:"taxed_price";i:0;s:5:"taxes";a:1:{i:6;a:7:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:2:"10";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:2.549;s:11:"description";s:3:"VAT";}}}}s:16:"chosen_shippings";a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}}}'),
(178, 57, 'G', 'a:1:{i:0;a:10:{s:4:"name";s:7:"CS-Cart";s:10:"company_id";i:1;s:8:"products";a:1:{s:10:"2195660588";a:23:{s:10:"product_id";i:195;s:12:"product_code";s:10:"I0195ZFDB8";s:7:"product";s:38:"Crossroads Guitar Festival 2010 (2DVD)";s:6:"amount";i:1;s:15:"product_options";a:0:{}s:5:"price";d:29.989;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"672";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"728";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:66:"http://localhost/git/work/images/detailed/0/603497948727.sml_0.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"500";s:7:"image_y";s:3:"500";s:15:"http_image_path";s:66:"http://localhost/git/work/images/detailed/0/603497948727.sml_0.jpg";s:13:"absolute_path";s:69:"/Users/alexions/www/git/work/images/detailed/0/603497948727.sml_0.jpg";s:13:"relative_path";s:33:"detailed/0/603497948727.sml_0.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"2195660588";s:6:"amount";s:1:"1";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:38:"Crossroads Guitar Festival 2010 (2DVD)";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:29.989;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:29.989;s:13:"display_price";d:29.989;}}s:12:"package_info";a:7:{s:1:"C";d:29.989;s:1:"W";s:4:"0.01";s:1:"I";i:1;s:16:"shipping_freight";d:0;s:8:"packages";a:1:{i:0;a:4:{s:8:"products";a:1:{s:10:"2195660588";i:1;}s:6:"amount";i:1;s:6:"weight";d:0.100;s:4:"cost";d:29.989;}}s:11:"origination";a:8:{s:4:"name";s:7:"CS-Cart";s:7:"address";s:14:"44 Main street";s:4:"city";s:6:"Boston";s:7:"country";s:2:"US";s:5:"state";s:2:"MA";s:7:"zipcode";s:5:"02116";s:5:"phone";s:12:"+16175556985";s:3:"fax";s:0:"";}s:8:"location";a:13:{s:9:"firstname";s:6:"George";s:8:"lastname";s:5:"Nills";s:7:"address";s:19:"60 Centre Street #5";s:9:"address_2";N;s:4:"city";s:8:"New York";s:6:"county";N;s:5:"state";s:2:"NY";s:7:"country";s:2:"US";s:7:"zipcode";s:5:"01342";s:5:"phone";s:12:"+16463863600";s:12:"address_type";s:11:"residential";s:13:"country_descr";s:13:"United States";s:11:"state_descr";s:8:"New York";}}s:21:"all_edp_free_shipping";b:0;s:17:"all_free_shipping";b:0;s:13:"free_shipping";b:0;s:20:"shipping_no_required";b:0;s:9:"shippings";a:1:{i:1;a:16:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:63;s:11:"taxed_price";i:0;s:5:"taxes";a:1:{i:6;a:7:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:2:"10";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:5.730;s:11:"description";s:3:"VAT";}}}}s:16:"chosen_shippings";a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:63;s:10:"group_name";s:7:"CS-Cart";}}}}'),
(179, 58, 'G', 'a:1:{i:0;a:10:{s:4:"name";s:7:"CS-Cart";s:10:"company_id";i:1;s:8:"products";a:1:{s:10:"4283388740";a:23:{s:10:"product_id";i:122;s:12:"product_code";s:10:"J01223DYAH";s:7:"product";s:40:"Evolution SST.2 XO Complete Bike 10SPD12";s:6:"amount";i:1;s:15:"product_options";a:0:{}s:5:"price";d:5695;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"477";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"533";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:60:"http://localhost/git/work/images/detailed/0/CB-evolution.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"936";s:7:"image_y";s:3:"612";s:15:"http_image_path";s:60:"http://localhost/git/work/images/detailed/0/CB-evolution.jpg";s:13:"absolute_path";s:63:"/Users/alexions/www/git/work/images/detailed/0/CB-evolution.jpg";s:13:"relative_path";s:27:"detailed/0/CB-evolution.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"4283388740";s:6:"amount";s:1:"1";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:40:"Evolution SST.2 XO Complete Bike 10SPD12";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:5695;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:5695;s:13:"display_price";d:5695;}}s:12:"package_info";a:7:{s:1:"C";d:5695;s:1:"W";s:4:"0.01";s:1:"I";i:1;s:16:"shipping_freight";d:0;s:8:"packages";a:1:{i:0;a:4:{s:8:"products";a:1:{s:10:"4283388740";i:1;}s:6:"amount";i:1;s:6:"weight";d:0.100;s:4:"cost";i:5695;}}s:11:"origination";a:8:{s:4:"name";s:7:"CS-Cart";s:7:"address";s:14:"44 Main street";s:4:"city";s:6:"Boston";s:7:"country";s:2:"US";s:5:"state";s:2:"MA";s:7:"zipcode";s:5:"02116";s:5:"phone";s:12:"+16175556985";s:3:"fax";s:0:"";}s:8:"location";a:13:{s:9:"firstname";s:6:"George";s:8:"lastname";s:5:"Nills";s:7:"address";s:19:"60 Centre Street #5";s:9:"address_2";N;s:4:"city";s:8:"New York";s:6:"county";N;s:5:"state";s:2:"NY";s:7:"country";s:2:"US";s:7:"zipcode";s:5:"01342";s:5:"phone";s:12:"+16463863600";s:12:"address_type";s:11:"residential";s:13:"country_descr";s:13:"United States";s:11:"state_descr";s:8:"New York";}}s:21:"all_edp_free_shipping";b:0;s:17:"all_free_shipping";b:0;s:13:"free_shipping";b:0;s:20:"shipping_no_required";b:0;s:9:"shippings";a:1:{i:1;a:16:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:11:"taxed_price";i:0;s:5:"taxes";a:1:{i:6;a:7:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:2:"10";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:2.549;s:11:"description";s:3:"VAT";}}}}s:16:"chosen_shippings";a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}}}'),
(180, 60, 'G', 'a:1:{i:0;a:10:{s:4:"name";s:7:"CS-Cart";s:10:"company_id";i:1;s:8:"products";a:1:{s:10:"4163016541";a:23:{s:10:"product_id";i:126;s:12:"product_code";s:10:"F01262AH0T";s:7:"product";s:19:"Casio PRIZM fx-CG10";s:6:"amount";i:5;s:15:"product_options";a:0:{}s:5:"price";d:129.990;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"486";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"542";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:62:"http://localhost/git/work/images/detailed/0/fx-cg10_xlarge.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"500";s:7:"image_y";s:3:"529";s:15:"http_image_path";s:62:"http://localhost/git/work/images/detailed/0/fx-cg10_xlarge.jpg";s:13:"absolute_path";s:65:"/Users/alexions/www/git/work/images/detailed/0/fx-cg10_xlarge.jpg";s:13:"relative_path";s:29:"detailed/0/fx-cg10_xlarge.jpg";}}s:15:"original_amount";s:1:"5";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"4163016541";s:6:"amount";s:1:"5";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:19:"Casio PRIZM fx-CG10";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:129.990;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:5;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:129.990;s:13:"display_price";d:129.990;}}s:12:"package_info";a:7:{s:1:"C";d:649.950;s:1:"W";s:4:"0.01";s:1:"I";i:5;s:16:"shipping_freight";d:0;s:8:"packages";a:1:{i:0;a:4:{s:8:"products";a:1:{s:10:"4163016541";i:5;}s:6:"amount";i:5;s:6:"weight";d:0.100;s:4:"cost";d:649.950;}}s:11:"origination";a:8:{s:4:"name";s:7:"CS-Cart";s:7:"address";s:14:"44 Main street";s:4:"city";s:6:"Boston";s:7:"country";s:2:"US";s:5:"state";s:2:"MA";s:7:"zipcode";s:5:"02116";s:5:"phone";s:12:"+16175556985";s:3:"fax";s:0:"";}s:8:"location";a:13:{s:9:"firstname";s:6:"George";s:8:"lastname";s:5:"Nills";s:7:"address";s:19:"60 Centre Street #5";s:9:"address_2";N;s:4:"city";s:8:"New York";s:6:"county";N;s:5:"state";s:2:"NY";s:7:"country";s:2:"US";s:7:"zipcode";s:5:"01342";s:5:"phone";s:12:"+16463863600";s:12:"address_type";s:11:"residential";s:13:"country_descr";s:13:"United States";s:11:"state_descr";s:8:"New York";}}s:21:"all_edp_free_shipping";b:0;s:17:"all_free_shipping";b:0;s:13:"free_shipping";b:0;s:20:"shipping_no_required";b:0;s:9:"shippings";a:1:{i:1;a:16:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:11:"taxed_price";i:0;s:5:"taxes";a:1:{i:6;a:7:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:2:"10";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:2.549;s:11:"description";s:3:"VAT";}}}}s:16:"chosen_shippings";a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}}}'),
(181, 62, 'G', 'a:1:{i:0;a:10:{s:4:"name";s:7:"CS-Cart";s:10:"company_id";i:1;s:8:"products";a:3:{s:9:"169655664";a:23:{s:10:"product_id";i:230;s:12:"product_code";s:10:"B0230S7Q0V";s:7:"product";s:13:"2011 Pit Boss";s:6:"amount";i:1;s:15:"product_options";a:0:{}s:5:"price";d:125;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"783";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"839";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:89:"http://localhost/git/work/images/detailed/0/url_uploaded_file_13287871234f33aeb3d0793.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:4:"1000";s:7:"image_y";s:4:"1000";s:15:"http_image_path";s:89:"http://localhost/git/work/images/detailed/0/url_uploaded_file_13287871234f33aeb3d0793.jpg";s:13:"absolute_path";s:92:"/Users/alexions/www/git/work/images/detailed/0/url_uploaded_file_13287871234f33aeb3d0793.jpg";s:13:"relative_path";s:56:"detailed/0/url_uploaded_file_13287871234f33aeb3d0793.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:9:"169655664";s:6:"amount";s:1:"1";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:13:"2011 Pit Boss";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:125;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:125;s:13:"display_price";d:125;}s:10:"2054572543";a:23:{s:10:"product_id";i:235;s:12:"product_code";s:10:"N02351Q6BY";s:7:"product";s:36:"Everglades Cold Weather Sleeping Bag";s:6:"amount";i:1;s:15:"product_options";a:0:{}s:5:"price";d:79.989;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"793";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"849";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:62:"http://localhost/git/work/images/detailed/0/2000004467_500.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"500";s:7:"image_y";s:3:"500";s:15:"http_image_path";s:62:"http://localhost/git/work/images/detailed/0/2000004467_500.jpg";s:13:"absolute_path";s:65:"/Users/alexions/www/git/work/images/detailed/0/2000004467_500.jpg";s:13:"relative_path";s:29:"detailed/0/2000004467_500.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"2054572543";s:6:"amount";s:1:"1";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:36:"Everglades Cold Weather Sleeping Bag";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:79.989;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:79.989;s:13:"display_price";d:79.989;}s:10:"3816757317";a:23:{s:10:"product_id";i:236;s:12:"product_code";s:10:"A0236BQ31M";s:7:"product";s:46:"WeatherMaster Screened 6 Tent With Hinged Door";s:6:"amount";i:1;s:15:"product_options";a:0:{}s:5:"price";d:299.990;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"794";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"850";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:62:"http://localhost/git/work/images/detailed/0/2000001597_500.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"500";s:7:"image_y";s:3:"500";s:15:"http_image_path";s:62:"http://localhost/git/work/images/detailed/0/2000001597_500.jpg";s:13:"absolute_path";s:65:"/Users/alexions/www/git/work/images/detailed/0/2000001597_500.jpg";s:13:"relative_path";s:29:"detailed/0/2000001597_500.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"3816757317";s:6:"amount";s:1:"1";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:46:"WeatherMaster Screened 6 Tent With Hinged Door";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:299.990;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:299.990;s:13:"display_price";d:299.990;}}s:12:"package_info";a:7:{s:1:"C";d:504.980;s:1:"W";s:4:"0.01";s:1:"I";i:3;s:16:"shipping_freight";d:0;s:8:"packages";a:1:{i:0;a:4:{s:8:"products";a:3:{s:9:"169655664";i:1;s:10:"2054572543";i:1;s:10:"3816757317";i:1;}s:6:"amount";i:3;s:6:"weight";d:0.100;s:4:"cost";d:504.980;}}s:11:"origination";a:8:{s:4:"name";s:7:"CS-Cart";s:7:"address";s:14:"44 Main street";s:4:"city";s:6:"Boston";s:7:"country";s:2:"US";s:5:"state";s:2:"MA";s:7:"zipcode";s:5:"02116";s:5:"phone";s:12:"+16175556985";s:3:"fax";s:0:"";}s:8:"location";a:13:{s:9:"firstname";s:8:"Customer";s:8:"lastname";s:8:"Customer";s:7:"address";s:14:"44 Main street";s:9:"address_2";N;s:4:"city";s:6:"Boston";s:6:"county";N;s:5:"state";s:2:"MA";s:7:"country";s:2:"US";s:7:"zipcode";s:5:"02134";s:5:"phone";s:12:"+16175556985";s:12:"address_type";s:11:"residential";s:13:"country_descr";s:13:"United States";s:11:"state_descr";s:13:"Massachusetts";}}s:21:"all_edp_free_shipping";b:0;s:17:"all_free_shipping";b:0;s:13:"free_shipping";b:0;s:20:"shipping_no_required";b:0;s:9:"shippings";a:2:{i:1;a:16:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:11:"taxed_price";i:0;s:5:"taxes";a:1:{i:6;a:7:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:2:"10";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:2.549;s:11:"description";s:3:"VAT";}}}i:3;a:16:{s:11:"shipping_id";s:1:"3";s:8:"shipping";s:19:"FedEx Home Delivery";s:13:"delivery_time";s:6:"2 days";s:16:"rate_calculation";s:1:"R";s:14:"service_params";a:11:{s:8:"user_key";s:16:"JAHR7R8oMgMFRH55";s:17:"user_key_password";s:25:"YxIJQaZt7Qx3Qt904ibYPhuDa";s:14:"account_number";s:9:"510087089";s:12:"meter_number";s:9:"118530569";s:9:"test_mode";s:1:"Y";s:12:"package_type";s:14:"YOUR_PACKAGING";s:13:"drop_off_type";s:14:"REGULAR_PICKUP";s:17:"max_weight_of_box";s:2:"70";s:6:"height";s:2:"10";s:5:"width";s:2:"10";s:6:"length";s:2:"10";}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:3:"216";s:6:"module";s:5:"fedex";s:12:"service_code";s:20:"GROUND_HOME_DELIVERY";s:9:"rate_info";a:0:{}s:9:"group_key";i:0;s:4:"rate";d:9.740;s:11:"taxed_price";i:0;s:5:"taxes";a:1:{i:6;a:7:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:2:"10";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:0.890;s:11:"description";s:3:"VAT";}}}}s:16:"chosen_shippings";a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}}}'),
(182, 64, 'G', 'a:1:{i:0;a:10:{s:4:"name";s:7:"CS-Cart";s:10:"company_id";i:1;s:8:"products";a:4:{s:10:"4065481614";a:23:{s:10:"product_id";i:177;s:12:"product_code";s:10:"J0177S9SI3";s:7:"product";s:15:"CG BLACK DRIVER";s:6:"amount";i:1;s:15:"product_options";a:0:{}s:5:"price";d:400;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"641";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"697";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:59:"http://localhost/git/work/images/detailed/0/blkdrv_hero.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"800";s:7:"image_y";s:3:"800";s:15:"http_image_path";s:59:"http://localhost/git/work/images/detailed/0/blkdrv_hero.jpg";s:13:"absolute_path";s:62:"/Users/alexions/www/git/work/images/detailed/0/blkdrv_hero.jpg";s:13:"relative_path";s:26:"detailed/0/blkdrv_hero.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"4065481614";s:6:"amount";s:1:"1";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:15:"CG BLACK DRIVER";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:400;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:400;s:13:"display_price";d:400;}i:47022039;a:23:{s:10:"product_id";i:186;s:12:"product_code";s:10:"N01868E9SB";s:7:"product";s:18:"CG Black Staff Bag";s:6:"amount";i:4;s:15:"product_options";a:0:{}s:5:"price";d:299.990;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"661";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"717";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:80:"http://localhost/git/work/images/detailed/0/8ad650de56e5e2272b240d3a6c171545.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"800";s:7:"image_y";s:3:"800";s:15:"http_image_path";s:80:"http://localhost/git/work/images/detailed/0/8ad650de56e5e2272b240d3a6c171545.jpg";s:13:"absolute_path";s:83:"/Users/alexions/www/git/work/images/detailed/0/8ad650de56e5e2272b240d3a6c171545.jpg";s:13:"relative_path";s:47:"detailed/0/8ad650de56e5e2272b240d3a6c171545.jpg";}}s:15:"original_amount";s:1:"4";s:21:"original_product_data";a:2:{s:7:"cart_id";i:47022039;s:6:"amount";s:1:"4";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:18:"CG Black Staff Bag";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:299.990;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:4;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:299.990;s:13:"display_price";d:299.990;}s:10:"3849671376";a:23:{s:10:"product_id";i:188;s:12:"product_code";s:10:"M0188MVCYL";s:7:"product";s:45:"NEW Wilson Staff Fifty Elite Yellow Golf Ball";s:6:"amount";i:1;s:15:"product_options";a:0:{}s:5:"price";d:10;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"663";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"719";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:76:"http://localhost/git/work/images/detailed/0/50Elite_Yellow_12ball_Render.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"500";s:7:"image_y";s:3:"500";s:15:"http_image_path";s:76:"http://localhost/git/work/images/detailed/0/50Elite_Yellow_12ball_Render.jpg";s:13:"absolute_path";s:79:"/Users/alexions/www/git/work/images/detailed/0/50Elite_Yellow_12ball_Render.jpg";s:13:"relative_path";s:43:"detailed/0/50Elite_Yellow_12ball_Render.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"3849671376";s:6:"amount";s:1:"1";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:45:"NEW Wilson Staff Fifty Elite Yellow Golf Ball";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:10;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:10;s:13:"display_price";d:10;}s:10:"2628381300";a:23:{s:10:"product_id";i:181;s:12:"product_code";s:10:"A0181ZSJSS";s:7:"product";s:26:"Women''s Bloom Complete Set";s:6:"amount";i:1;s:15:"product_options";a:0:{}s:5:"price";d:899.990;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"651";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"707";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:64:"http://localhost/git/work/images/detailed/0/bloom_berry_set1.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"800";s:7:"image_y";s:3:"800";s:15:"http_image_path";s:64:"http://localhost/git/work/images/detailed/0/bloom_berry_set1.jpg";s:13:"absolute_path";s:67:"/Users/alexions/www/git/work/images/detailed/0/bloom_berry_set1.jpg";s:13:"relative_path";s:31:"detailed/0/bloom_berry_set1.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"2628381300";s:6:"amount";s:1:"1";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:26:"Women''s Bloom Complete Set";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:899.990;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:899.990;s:13:"display_price";d:899.990;}}s:12:"package_info";a:7:{s:1:"C";d:2509.949;s:1:"W";s:4:"0.01";s:1:"I";i:7;s:16:"shipping_freight";d:0;s:8:"packages";a:1:{i:0;a:4:{s:8:"products";a:4:{s:10:"4065481614";i:1;i:47022039;i:4;s:10:"3849671376";i:1;s:10:"2628381300";i:1;}s:6:"amount";i:7;s:6:"weight";d:0.100;s:4:"cost";d:2509.949;}}s:11:"origination";a:8:{s:4:"name";s:7:"CS-Cart";s:7:"address";s:14:"44 Main street";s:4:"city";s:6:"Boston";s:7:"country";s:2:"US";s:5:"state";s:2:"MA";s:7:"zipcode";s:5:"02116";s:5:"phone";s:12:"+16175556985";s:3:"fax";s:0:"";}s:8:"location";a:13:{s:9:"firstname";s:8:"Customer";s:8:"lastname";s:8:"Customer";s:7:"address";s:14:"44 Main street";s:9:"address_2";N;s:4:"city";s:6:"Boston";s:6:"county";N;s:5:"state";s:2:"MA";s:7:"country";s:2:"US";s:7:"zipcode";s:5:"02134";s:5:"phone";s:12:"+16175556985";s:12:"address_type";s:11:"residential";s:13:"country_descr";s:13:"United States";s:11:"state_descr";s:13:"Massachusetts";}}s:21:"all_edp_free_shipping";b:0;s:17:"all_free_shipping";b:0;s:13:"free_shipping";b:0;s:20:"shipping_no_required";b:0;s:9:"shippings";a:2:{i:1;a:16:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:11:"taxed_price";i:0;s:5:"taxes";a:1:{i:6;a:7:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:2:"10";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:2.549;s:11:"description";s:3:"VAT";}}}i:3;a:16:{s:11:"shipping_id";s:1:"3";s:8:"shipping";s:19:"FedEx Home Delivery";s:13:"delivery_time";s:6:"2 days";s:16:"rate_calculation";s:1:"R";s:14:"service_params";a:11:{s:8:"user_key";s:16:"JAHR7R8oMgMFRH55";s:17:"user_key_password";s:25:"YxIJQaZt7Qx3Qt904ibYPhuDa";s:14:"account_number";s:9:"510087089";s:12:"meter_number";s:9:"118530569";s:9:"test_mode";s:1:"Y";s:12:"package_type";s:14:"YOUR_PACKAGING";s:13:"drop_off_type";s:14:"REGULAR_PICKUP";s:17:"max_weight_of_box";s:2:"70";s:6:"height";s:2:"10";s:5:"width";s:2:"10";s:6:"length";s:2:"10";}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:3:"216";s:6:"module";s:5:"fedex";s:12:"service_code";s:20:"GROUND_HOME_DELIVERY";s:9:"rate_info";a:0:{}s:9:"group_key";i:0;s:4:"rate";d:9.740;s:11:"taxed_price";i:0;s:5:"taxes";a:1:{i:6;a:7:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:2:"10";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:0.890;s:11:"description";s:3:"VAT";}}}}s:16:"chosen_shippings";a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}}}');
INSERT INTO `[[dbprefix]]order_data` VALUES
(183, 70, 'G', 'a:1:{i:0;a:10:{s:4:"name";s:7:"CS-Cart";s:10:"company_id";i:1;s:8:"products";a:1:{s:10:"2490902739";a:23:{s:10:"product_id";i:237;s:12:"product_code";s:10:"B0237HI9M0";s:7:"product";s:21:"Elite Evanston 8 Tent";s:6:"amount";i:2;s:15:"product_options";a:0:{}s:5:"price";d:299.990;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"795";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"851";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:62:"http://localhost/git/work/images/detailed/0/2000004674_500.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"500";s:7:"image_y";s:3:"500";s:15:"http_image_path";s:62:"http://localhost/git/work/images/detailed/0/2000004674_500.jpg";s:13:"absolute_path";s:65:"/Users/alexions/www/git/work/images/detailed/0/2000004674_500.jpg";s:13:"relative_path";s:29:"detailed/0/2000004674_500.jpg";}}s:15:"original_amount";s:1:"2";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"2490902739";s:6:"amount";s:1:"2";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:21:"Elite Evanston 8 Tent";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:299.990;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:2;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:299.990;s:13:"display_price";d:299.990;}}s:12:"package_info";a:7:{s:1:"C";d:599.980;s:1:"W";s:4:"0.01";s:1:"I";i:2;s:16:"shipping_freight";d:0;s:8:"packages";a:1:{i:0;a:4:{s:8:"products";a:1:{s:10:"2490902739";i:2;}s:6:"amount";i:2;s:6:"weight";d:0.100;s:4:"cost";d:599.980;}}s:11:"origination";a:8:{s:4:"name";s:7:"CS-Cart";s:7:"address";s:14:"44 Main street";s:4:"city";s:6:"Boston";s:7:"country";s:2:"US";s:5:"state";s:2:"MA";s:7:"zipcode";s:5:"02116";s:5:"phone";s:12:"+16175556985";s:3:"fax";s:0:"";}s:8:"location";a:13:{s:9:"firstname";s:6:"Oliver";s:8:"lastname";s:4:"Kahn";s:7:"address";s:15:"Bodestraße 1-3";s:9:"address_2";N;s:4:"city";s:6:"Berlin";s:6:"county";N;s:5:"state";s:3:"BER";s:7:"country";s:2:"DE";s:7:"zipcode";s:5:"10178";s:5:"phone";s:14:"+4930266424242";s:12:"address_type";s:11:"residential";s:13:"country_descr";s:7:"Germany";s:11:"state_descr";s:6:"Berlin";}}s:21:"all_edp_free_shipping";b:0;s:17:"all_free_shipping";b:0;s:13:"free_shipping";b:0;s:20:"shipping_no_required";b:0;s:9:"shippings";a:1:{i:1;a:16:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"45";s:10:"rate_value";a:1:{s:1:"C";a:2:{i:0;a:2:{s:5:"value";s:4:"0.00";s:4:"type";s:1:"F";}i:100;a:2:{s:5:"value";s:5:"25.45";s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:25.449;s:11:"taxed_price";i:0;s:5:"taxes";a:1:{i:6;a:7:{s:9:"rate_type";s:1:"F";s:10:"rate_value";s:2:"12";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:12;s:11:"description";s:3:"VAT";}}}}s:16:"chosen_shippings";a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:2:"45";s:10:"rate_value";a:1:{s:1:"C";a:2:{i:0;a:2:{s:5:"value";s:4:"0.00";s:4:"type";s:1:"F";}i:100;a:2:{s:5:"value";s:5:"25.45";s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:25.449;s:10:"group_name";s:7:"CS-Cart";}}}}'),
(184, 71, 'G', 'a:1:{i:0;a:10:{s:4:"name";s:7:"CS-Cart";s:10:"company_id";i:1;s:8:"products";a:4:{s:9:"822274303";a:23:{s:10:"product_id";i:12;s:12:"product_code";s:10:"U0012O5AF0";s:7:"product";s:10:"100g Pants";s:6:"amount";i:1;s:15:"product_options";a:2:{i:9;s:2:"17";i:2;s:1:"6";}s:5:"price";d:30;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"808";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"864";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:57:"http://localhost/git/work/images/detailed/0/173283_01.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"500";s:7:"image_y";s:3:"500";s:15:"http_image_path";s:57:"http://localhost/git/work/images/detailed/0/173283_01.jpg";s:13:"absolute_path";s:60:"/Users/alexions/www/git/work/images/detailed/0/173283_01.jpg";s:13:"relative_path";s:24:"detailed/0/173283_01.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:9:"822274303";s:6:"amount";s:1:"1";}s:5:"extra";a:10:{s:15:"product_options";a:2:{i:9;s:2:"17";i:2;s:1:"6";}s:18:"unlimited_download";s:1:"N";s:7:"product";s:10:"100g Pants";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:30;s:12:"stored_price";s:1:"N";s:21:"product_options_value";a:2:{i:0;a:22:{s:9:"option_id";s:1:"9";s:10:"product_id";s:2:"12";s:10:"company_id";s:1:"1";s:11:"option_type";s:1:"S";s:9:"inventory";s:1:"Y";s:6:"regexp";s:0:"";s:8:"required";s:1:"N";s:11:"multiupload";s:1:"N";s:18:"allowed_extensions";s:0:"";s:13:"max_file_size";s:1:"0";s:25:"missing_variants_handling";s:1:"M";s:6:"status";s:1:"A";s:8:"position";s:1:"0";s:5:"value";s:2:"17";s:11:"option_name";s:5:"Color";s:11:"option_text";s:0:"";s:11:"description";s:0:"";s:10:"inner_hint";s:0:"";s:17:"incorrect_message";s:0:"";s:8:"modifier";s:5:"0.000";s:13:"modifier_type";s:1:"A";s:12:"variant_name";s:17:"Black/White/White";}i:1;a:22:{s:9:"option_id";s:1:"2";s:10:"product_id";s:2:"12";s:10:"company_id";s:1:"1";s:11:"option_type";s:1:"S";s:9:"inventory";s:1:"Y";s:6:"regexp";s:0:"";s:8:"required";s:1:"N";s:11:"multiupload";s:1:"N";s:18:"allowed_extensions";s:0:"";s:13:"max_file_size";s:1:"0";s:25:"missing_variants_handling";s:1:"M";s:6:"status";s:1:"A";s:8:"position";s:2:"10";s:5:"value";s:1:"6";s:11:"option_name";s:4:"Size";s:11:"option_text";s:4:"Size";s:11:"description";s:0:"";s:10:"inner_hint";s:0:"";s:17:"incorrect_message";s:0:"";s:8:"modifier";s:5:"0.000";s:13:"modifier_type";s:1:"A";s:12:"variant_name";s:5:"Small";}}}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:30;s:13:"display_price";d:30;}s:9:"677409494";a:23:{s:10:"product_id";i:11;s:12:"product_code";s:10:"Z0011CZSNI";s:7:"product";s:17:"Collegiate 72 Tee";s:6:"amount";i:1;s:15:"product_options";a:2:{i:1;s:1:"1";i:2;s:1:"6";}s:5:"price";d:30;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"210";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"266";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:57:"http://localhost/git/work/images/detailed/0/X32444_01.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:4:"2000";s:7:"image_y";s:4:"2000";s:15:"http_image_path";s:57:"http://localhost/git/work/images/detailed/0/X32444_01.jpg";s:13:"absolute_path";s:60:"/Users/alexions/www/git/work/images/detailed/0/X32444_01.jpg";s:13:"relative_path";s:24:"detailed/0/X32444_01.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:9:"677409494";s:6:"amount";s:1:"1";}s:5:"extra";a:10:{s:15:"product_options";a:2:{i:1;s:1:"1";i:2;s:1:"6";}s:18:"unlimited_download";s:1:"N";s:7:"product";s:17:"Collegiate 72 Tee";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:30;s:12:"stored_price";s:1:"N";s:21:"product_options_value";a:2:{i:0;a:22:{s:9:"option_id";s:1:"1";s:10:"product_id";s:2:"11";s:10:"company_id";s:1:"1";s:11:"option_type";s:1:"S";s:9:"inventory";s:1:"N";s:6:"regexp";s:0:"";s:8:"required";s:1:"N";s:11:"multiupload";s:1:"N";s:18:"allowed_extensions";s:0:"";s:13:"max_file_size";s:1:"0";s:25:"missing_variants_handling";s:1:"M";s:6:"status";s:1:"A";s:8:"position";s:1:"0";s:5:"value";s:1:"1";s:11:"option_name";s:5:"Color";s:11:"option_text";s:0:"";s:11:"description";s:0:"";s:10:"inner_hint";s:0:"";s:17:"incorrect_message";s:0:"";s:8:"modifier";s:5:"0.000";s:13:"modifier_type";s:1:"A";s:12:"variant_name";s:5:"White";}i:1;a:22:{s:9:"option_id";s:1:"2";s:10:"product_id";s:2:"11";s:10:"company_id";s:1:"1";s:11:"option_type";s:1:"S";s:9:"inventory";s:1:"Y";s:6:"regexp";s:0:"";s:8:"required";s:1:"N";s:11:"multiupload";s:1:"N";s:18:"allowed_extensions";s:0:"";s:13:"max_file_size";s:1:"0";s:25:"missing_variants_handling";s:1:"M";s:6:"status";s:1:"A";s:8:"position";s:2:"10";s:5:"value";s:1:"6";s:11:"option_name";s:4:"Size";s:11:"option_text";s:4:"Size";s:11:"description";s:0:"";s:10:"inner_hint";s:0:"";s:17:"incorrect_message";s:0:"";s:8:"modifier";s:5:"0.000";s:13:"modifier_type";s:1:"A";s:12:"variant_name";s:5:"Small";}}}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:30;s:13:"display_price";d:30;}s:10:"3636250333";a:23:{s:10:"product_id";i:15;s:12:"product_code";s:10:"H0015EXYM6";s:7:"product";s:39:"Nike Chambray Super Runner Men''s Jacket";s:6:"amount";i:1;s:15:"product_options";a:1:{i:2;s:1:"6";}s:5:"price";d:150;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"224";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"280";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:60:"http://localhost/git/work/images/detailed/0/452499_010_A.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"900";s:7:"image_y";s:3:"600";s:15:"http_image_path";s:60:"http://localhost/git/work/images/detailed/0/452499_010_A.jpg";s:13:"absolute_path";s:63:"/Users/alexions/www/git/work/images/detailed/0/452499_010_A.jpg";s:13:"relative_path";s:27:"detailed/0/452499_010_A.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"3636250333";s:6:"amount";s:1:"1";}s:5:"extra";a:10:{s:15:"product_options";a:1:{i:2;s:1:"6";}s:18:"unlimited_download";s:1:"N";s:7:"product";s:39:"Nike Chambray Super Runner Men''s Jacket";s:10:"company_id";s:1:"2";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:150;s:12:"stored_price";s:1:"N";s:21:"product_options_value";a:1:{i:0;a:22:{s:9:"option_id";s:1:"2";s:10:"product_id";s:2:"15";s:10:"company_id";s:1:"1";s:11:"option_type";s:1:"S";s:9:"inventory";s:1:"Y";s:6:"regexp";s:0:"";s:8:"required";s:1:"N";s:11:"multiupload";s:1:"N";s:18:"allowed_extensions";s:0:"";s:13:"max_file_size";s:1:"0";s:25:"missing_variants_handling";s:1:"M";s:6:"status";s:1:"A";s:8:"position";s:2:"10";s:5:"value";s:1:"6";s:11:"option_name";s:4:"Size";s:11:"option_text";s:4:"Size";s:11:"description";s:0:"";s:10:"inner_hint";s:0:"";s:17:"incorrect_message";s:0:"";s:8:"modifier";s:5:"0.000";s:13:"modifier_type";s:1:"A";s:12:"variant_name";s:5:"Small";}}}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:150;s:13:"display_price";d:150;}s:10:"4283906614";a:23:{s:10:"product_id";i:7;s:12:"product_code";s:10:"A0007DQ1TL";s:7:"product";s:14:"Trefoil Hoodie";s:6:"amount";i:1;s:15:"product_options";a:2:{i:10;s:2:"36";i:2;s:1:"6";}s:5:"price";d:55;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"827";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"883";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:57:"http://localhost/git/work/images/detailed/0/X41181_01.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:4:"2400";s:7:"image_y";s:4:"2400";s:15:"http_image_path";s:57:"http://localhost/git/work/images/detailed/0/X41181_01.jpg";s:13:"absolute_path";s:60:"/Users/alexions/www/git/work/images/detailed/0/X41181_01.jpg";s:13:"relative_path";s:24:"detailed/0/X41181_01.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"4283906614";s:6:"amount";s:1:"1";}s:5:"extra";a:10:{s:15:"product_options";a:2:{i:10;s:2:"36";i:2;s:1:"6";}s:18:"unlimited_download";s:1:"N";s:7:"product";s:14:"Trefoil Hoodie";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:55;s:12:"stored_price";s:1:"N";s:21:"product_options_value";a:2:{i:0;a:22:{s:9:"option_id";s:2:"10";s:10:"product_id";s:1:"7";s:10:"company_id";s:1:"1";s:11:"option_type";s:1:"S";s:9:"inventory";s:1:"Y";s:6:"regexp";s:0:"";s:8:"required";s:1:"N";s:11:"multiupload";s:1:"N";s:18:"allowed_extensions";s:0:"";s:13:"max_file_size";s:1:"0";s:25:"missing_variants_handling";s:1:"M";s:6:"status";s:1:"A";s:8:"position";s:1:"0";s:5:"value";s:2:"36";s:11:"option_name";s:5:"Color";s:11:"option_text";s:0:"";s:11:"description";s:0:"";s:10:"inner_hint";s:0:"";s:17:"incorrect_message";s:0:"";s:8:"modifier";s:5:"0.000";s:13:"modifier_type";s:1:"A";s:12:"variant_name";s:23:"GreyHeather/Core Energy";}i:1;a:22:{s:9:"option_id";s:1:"2";s:10:"product_id";s:1:"7";s:10:"company_id";s:1:"1";s:11:"option_type";s:1:"S";s:9:"inventory";s:1:"Y";s:6:"regexp";s:0:"";s:8:"required";s:1:"N";s:11:"multiupload";s:1:"N";s:18:"allowed_extensions";s:0:"";s:13:"max_file_size";s:1:"0";s:25:"missing_variants_handling";s:1:"M";s:6:"status";s:1:"A";s:8:"position";s:2:"10";s:5:"value";s:1:"6";s:11:"option_name";s:4:"Size";s:11:"option_text";s:4:"Size";s:11:"description";s:0:"";s:10:"inner_hint";s:0:"";s:17:"incorrect_message";s:0:"";s:8:"modifier";s:5:"0.000";s:13:"modifier_type";s:1:"A";s:12:"variant_name";s:5:"Small";}}}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:55;s:13:"display_price";d:55;}}s:12:"package_info";a:7:{s:1:"C";d:265;s:1:"W";s:4:"0.01";s:1:"I";i:4;s:16:"shipping_freight";d:0;s:8:"packages";a:1:{i:0;a:4:{s:8:"products";a:4:{s:9:"822274303";i:1;s:9:"677409494";i:1;s:10:"3636250333";i:1;s:10:"4283906614";i:1;}s:6:"amount";i:4;s:6:"weight";d:0.100;s:4:"cost";i:265;}}s:11:"origination";a:8:{s:4:"name";s:7:"CS-Cart";s:7:"address";s:14:"44 Main street";s:4:"city";s:6:"Boston";s:7:"country";s:2:"US";s:5:"state";s:2:"MA";s:7:"zipcode";s:5:"02116";s:5:"phone";s:12:"+16175556985";s:3:"fax";s:0:"";}s:8:"location";a:13:{s:9:"firstname";s:8:"Customer";s:8:"lastname";s:8:"Customer";s:7:"address";s:14:"44 Main street";s:9:"address_2";N;s:4:"city";s:6:"Boston";s:6:"county";N;s:5:"state";s:2:"MA";s:7:"country";s:2:"US";s:7:"zipcode";s:5:"02134";s:5:"phone";s:12:"+16175556985";s:12:"address_type";s:11:"residential";s:13:"country_descr";s:13:"United States";s:11:"state_descr";s:13:"Massachusetts";}}s:21:"all_edp_free_shipping";b:0;s:17:"all_free_shipping";b:0;s:13:"free_shipping";b:0;s:20:"shipping_no_required";b:0;s:9:"shippings";a:2:{i:1;a:16:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:11:"taxed_price";i:0;s:5:"taxes";a:1:{i:6;a:7:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:2:"10";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:2.549;s:11:"description";s:3:"VAT";}}}i:3;a:16:{s:11:"shipping_id";s:1:"3";s:8:"shipping";s:19:"FedEx Home Delivery";s:13:"delivery_time";s:6:"2 days";s:16:"rate_calculation";s:1:"R";s:14:"service_params";a:11:{s:8:"user_key";s:16:"JAHR7R8oMgMFRH55";s:17:"user_key_password";s:25:"YxIJQaZt7Qx3Qt904ibYPhuDa";s:14:"account_number";s:9:"510087089";s:12:"meter_number";s:9:"118530569";s:9:"test_mode";s:1:"Y";s:12:"package_type";s:14:"YOUR_PACKAGING";s:13:"drop_off_type";s:14:"REGULAR_PICKUP";s:17:"max_weight_of_box";s:2:"70";s:6:"height";s:2:"10";s:5:"width";s:2:"10";s:6:"length";s:2:"10";}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:3:"216";s:6:"module";s:5:"fedex";s:12:"service_code";s:20:"GROUND_HOME_DELIVERY";s:9:"rate_info";a:0:{}s:9:"group_key";i:0;s:4:"rate";d:9.740;s:11:"taxed_price";i:0;s:5:"taxes";a:1:{i:6;a:7:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:2:"10";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:0.890;s:11:"description";s:3:"VAT";}}}}s:16:"chosen_shippings";a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}}}'),
(185, 72, 'G', 'a:1:{i:0;a:10:{s:4:"name";s:7:"CS-Cart";s:10:"company_id";i:1;s:8:"products";a:3:{s:9:"822274303";a:23:{s:10:"product_id";i:12;s:12:"product_code";s:10:"U0012O5AF0";s:7:"product";s:10:"100g Pants";s:6:"amount";i:1;s:15:"product_options";a:2:{i:9;s:2:"17";i:2;s:1:"6";}s:5:"price";d:30;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"808";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"864";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:57:"http://localhost/git/work/images/detailed/0/173283_01.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"500";s:7:"image_y";s:3:"500";s:15:"http_image_path";s:57:"http://localhost/git/work/images/detailed/0/173283_01.jpg";s:13:"absolute_path";s:60:"/Users/alexions/www/git/work/images/detailed/0/173283_01.jpg";s:13:"relative_path";s:24:"detailed/0/173283_01.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:9:"822274303";s:6:"amount";s:1:"1";}s:5:"extra";a:10:{s:15:"product_options";a:2:{i:9;s:2:"17";i:2;s:1:"6";}s:18:"unlimited_download";s:1:"N";s:7:"product";s:10:"100g Pants";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:30;s:12:"stored_price";s:1:"N";s:21:"product_options_value";a:2:{i:0;a:22:{s:9:"option_id";s:1:"9";s:10:"product_id";s:2:"12";s:10:"company_id";s:1:"1";s:11:"option_type";s:1:"S";s:9:"inventory";s:1:"Y";s:6:"regexp";s:0:"";s:8:"required";s:1:"N";s:11:"multiupload";s:1:"N";s:18:"allowed_extensions";s:0:"";s:13:"max_file_size";s:1:"0";s:25:"missing_variants_handling";s:1:"M";s:6:"status";s:1:"A";s:8:"position";s:1:"0";s:5:"value";s:2:"17";s:11:"option_name";s:5:"Color";s:11:"option_text";s:0:"";s:11:"description";s:0:"";s:10:"inner_hint";s:0:"";s:17:"incorrect_message";s:0:"";s:8:"modifier";s:5:"0.000";s:13:"modifier_type";s:1:"A";s:12:"variant_name";s:17:"Black/White/White";}i:1;a:22:{s:9:"option_id";s:1:"2";s:10:"product_id";s:2:"12";s:10:"company_id";s:1:"1";s:11:"option_type";s:1:"S";s:9:"inventory";s:1:"Y";s:6:"regexp";s:0:"";s:8:"required";s:1:"N";s:11:"multiupload";s:1:"N";s:18:"allowed_extensions";s:0:"";s:13:"max_file_size";s:1:"0";s:25:"missing_variants_handling";s:1:"M";s:6:"status";s:1:"A";s:8:"position";s:2:"10";s:5:"value";s:1:"6";s:11:"option_name";s:4:"Size";s:11:"option_text";s:4:"Size";s:11:"description";s:0:"";s:10:"inner_hint";s:0:"";s:17:"incorrect_message";s:0:"";s:8:"modifier";s:5:"0.000";s:13:"modifier_type";s:1:"A";s:12:"variant_name";s:5:"Small";}}}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:30;s:13:"display_price";d:30;}s:9:"677409494";a:23:{s:10:"product_id";i:11;s:12:"product_code";s:10:"Z0011CZSNI";s:7:"product";s:17:"Collegiate 72 Tee";s:6:"amount";i:1;s:15:"product_options";a:2:{i:1;s:1:"1";i:2;s:1:"6";}s:5:"price";d:30;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"210";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"266";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:57:"http://localhost/git/work/images/detailed/0/X32444_01.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:4:"2000";s:7:"image_y";s:4:"2000";s:15:"http_image_path";s:57:"http://localhost/git/work/images/detailed/0/X32444_01.jpg";s:13:"absolute_path";s:60:"/Users/alexions/www/git/work/images/detailed/0/X32444_01.jpg";s:13:"relative_path";s:24:"detailed/0/X32444_01.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:9:"677409494";s:6:"amount";s:1:"1";}s:5:"extra";a:10:{s:15:"product_options";a:2:{i:1;s:1:"1";i:2;s:1:"6";}s:18:"unlimited_download";s:1:"N";s:7:"product";s:17:"Collegiate 72 Tee";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:30;s:12:"stored_price";s:1:"N";s:21:"product_options_value";a:2:{i:0;a:22:{s:9:"option_id";s:1:"1";s:10:"product_id";s:2:"11";s:10:"company_id";s:1:"1";s:11:"option_type";s:1:"S";s:9:"inventory";s:1:"N";s:6:"regexp";s:0:"";s:8:"required";s:1:"N";s:11:"multiupload";s:1:"N";s:18:"allowed_extensions";s:0:"";s:13:"max_file_size";s:1:"0";s:25:"missing_variants_handling";s:1:"M";s:6:"status";s:1:"A";s:8:"position";s:1:"0";s:5:"value";s:1:"1";s:11:"option_name";s:5:"Color";s:11:"option_text";s:0:"";s:11:"description";s:0:"";s:10:"inner_hint";s:0:"";s:17:"incorrect_message";s:0:"";s:8:"modifier";s:5:"0.000";s:13:"modifier_type";s:1:"A";s:12:"variant_name";s:5:"White";}i:1;a:22:{s:9:"option_id";s:1:"2";s:10:"product_id";s:2:"11";s:10:"company_id";s:1:"1";s:11:"option_type";s:1:"S";s:9:"inventory";s:1:"Y";s:6:"regexp";s:0:"";s:8:"required";s:1:"N";s:11:"multiupload";s:1:"N";s:18:"allowed_extensions";s:0:"";s:13:"max_file_size";s:1:"0";s:25:"missing_variants_handling";s:1:"M";s:6:"status";s:1:"A";s:8:"position";s:2:"10";s:5:"value";s:1:"6";s:11:"option_name";s:4:"Size";s:11:"option_text";s:4:"Size";s:11:"description";s:0:"";s:10:"inner_hint";s:0:"";s:17:"incorrect_message";s:0:"";s:8:"modifier";s:5:"0.000";s:13:"modifier_type";s:1:"A";s:12:"variant_name";s:5:"Small";}}}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:30;s:13:"display_price";d:30;}s:10:"4283906614";a:23:{s:10:"product_id";i:7;s:12:"product_code";s:10:"A0007DQ1TL";s:7:"product";s:14:"Trefoil Hoodie";s:6:"amount";i:1;s:15:"product_options";a:2:{i:10;s:2:"36";i:2;s:1:"6";}s:5:"price";d:55;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"827";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"883";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:57:"http://localhost/git/work/images/detailed/0/X41181_01.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:4:"2400";s:7:"image_y";s:4:"2400";s:15:"http_image_path";s:57:"http://localhost/git/work/images/detailed/0/X41181_01.jpg";s:13:"absolute_path";s:60:"/Users/alexions/www/git/work/images/detailed/0/X41181_01.jpg";s:13:"relative_path";s:24:"detailed/0/X41181_01.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"4283906614";s:6:"amount";s:1:"1";}s:5:"extra";a:10:{s:15:"product_options";a:2:{i:10;s:2:"36";i:2;s:1:"6";}s:18:"unlimited_download";s:1:"N";s:7:"product";s:14:"Trefoil Hoodie";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:55;s:12:"stored_price";s:1:"N";s:21:"product_options_value";a:2:{i:0;a:22:{s:9:"option_id";s:2:"10";s:10:"product_id";s:1:"7";s:10:"company_id";s:1:"1";s:11:"option_type";s:1:"S";s:9:"inventory";s:1:"Y";s:6:"regexp";s:0:"";s:8:"required";s:1:"N";s:11:"multiupload";s:1:"N";s:18:"allowed_extensions";s:0:"";s:13:"max_file_size";s:1:"0";s:25:"missing_variants_handling";s:1:"M";s:6:"status";s:1:"A";s:8:"position";s:1:"0";s:5:"value";s:2:"36";s:11:"option_name";s:5:"Color";s:11:"option_text";s:0:"";s:11:"description";s:0:"";s:10:"inner_hint";s:0:"";s:17:"incorrect_message";s:0:"";s:8:"modifier";s:5:"0.000";s:13:"modifier_type";s:1:"A";s:12:"variant_name";s:23:"GreyHeather/Core Energy";}i:1;a:22:{s:9:"option_id";s:1:"2";s:10:"product_id";s:1:"7";s:10:"company_id";s:1:"1";s:11:"option_type";s:1:"S";s:9:"inventory";s:1:"Y";s:6:"regexp";s:0:"";s:8:"required";s:1:"N";s:11:"multiupload";s:1:"N";s:18:"allowed_extensions";s:0:"";s:13:"max_file_size";s:1:"0";s:25:"missing_variants_handling";s:1:"M";s:6:"status";s:1:"A";s:8:"position";s:2:"10";s:5:"value";s:1:"6";s:11:"option_name";s:4:"Size";s:11:"option_text";s:4:"Size";s:11:"description";s:0:"";s:10:"inner_hint";s:0:"";s:17:"incorrect_message";s:0:"";s:8:"modifier";s:5:"0.000";s:13:"modifier_type";s:1:"A";s:12:"variant_name";s:5:"Small";}}}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:55;s:13:"display_price";d:55;}}s:12:"package_info";a:7:{s:1:"C";d:115;s:1:"W";s:4:"0.01";s:1:"I";i:3;s:16:"shipping_freight";d:0;s:8:"packages";a:1:{i:0;a:4:{s:8:"products";a:3:{s:9:"822274303";i:1;s:9:"677409494";i:1;s:10:"4283906614";i:1;}s:6:"amount";i:3;s:6:"weight";d:0.100;s:4:"cost";i:115;}}s:11:"origination";a:8:{s:4:"name";s:7:"CS-Cart";s:7:"address";s:14:"44 Main street";s:4:"city";s:6:"Boston";s:7:"country";s:2:"US";s:5:"state";s:2:"MA";s:7:"zipcode";s:5:"02116";s:5:"phone";s:12:"+16175556985";s:3:"fax";s:0:"";}s:8:"location";a:13:{s:9:"firstname";s:8:"Customer";s:8:"lastname";s:8:"Customer";s:7:"address";s:14:"44 Main street";s:9:"address_2";N;s:4:"city";s:6:"Boston";s:6:"county";N;s:5:"state";s:2:"MA";s:7:"country";s:2:"US";s:7:"zipcode";s:5:"02134";s:5:"phone";s:12:"+16175556985";s:12:"address_type";s:11:"residential";s:13:"country_descr";s:13:"United States";s:11:"state_descr";s:13:"Massachusetts";}}s:21:"all_edp_free_shipping";b:0;s:17:"all_free_shipping";b:0;s:13:"free_shipping";b:0;s:20:"shipping_no_required";b:0;s:9:"shippings";a:2:{i:1;a:16:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:11:"taxed_price";i:0;s:5:"taxes";a:1:{i:6;a:7:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:2:"10";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:2.549;s:11:"description";s:3:"VAT";}}}i:3;a:16:{s:11:"shipping_id";s:1:"3";s:8:"shipping";s:19:"FedEx Home Delivery";s:13:"delivery_time";s:6:"2 days";s:16:"rate_calculation";s:1:"R";s:14:"service_params";a:11:{s:8:"user_key";s:16:"JAHR7R8oMgMFRH55";s:17:"user_key_password";s:25:"YxIJQaZt7Qx3Qt904ibYPhuDa";s:14:"account_number";s:9:"510087089";s:12:"meter_number";s:9:"118530569";s:9:"test_mode";s:1:"Y";s:12:"package_type";s:14:"YOUR_PACKAGING";s:13:"drop_off_type";s:14:"REGULAR_PICKUP";s:17:"max_weight_of_box";s:2:"70";s:6:"height";s:2:"10";s:5:"width";s:2:"10";s:6:"length";s:2:"10";}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:3:"216";s:6:"module";s:5:"fedex";s:12:"service_code";s:20:"GROUND_HOME_DELIVERY";s:9:"rate_info";a:0:{}s:9:"group_key";i:0;s:4:"rate";d:9.740;s:11:"taxed_price";i:0;s:5:"taxes";a:1:{i:6;a:7:{s:9:"rate_type";s:1:"P";s:10:"rate_value";s:2:"10";s:18:"price_includes_tax";s:1:"Y";s:9:"regnumber";s:7:"1234242";s:8:"priority";i:0;s:12:"tax_subtotal";d:0.890;s:11:"description";s:3:"VAT";}}}}s:16:"chosen_shippings";a:1:{i:0;a:15:{s:11:"shipping_id";s:1:"1";s:8:"shipping";s:22:"Custom shipping method";s:13:"delivery_time";s:8:"3-5 days";s:16:"rate_calculation";s:1:"M";s:14:"service_params";a:0:{}s:11:"destination";s:1:"I";s:10:"min_weight";s:4:"0.00";s:10:"max_weight";s:4:"0.00";s:10:"service_id";s:1:"0";s:6:"module";N;s:12:"service_code";N;s:9:"rate_info";a:2:{s:7:"rate_id";s:1:"1";s:10:"rate_value";a:2:{s:1:"C";a:3:{i:0;a:2:{s:5:"value";i:40;s:4:"type";s:1:"F";}i:30;a:2:{s:5:"value";i:10;s:4:"type";s:1:"F";}i:50;a:2:{s:5:"value";i:5;s:4:"type";s:1:"F";}}s:1:"I";a:2:{i:0;a:2:{s:5:"value";i:23;s:4:"type";s:1:"F";}i:10;a:2:{s:5:"value";i:15;s:4:"type";s:1:"F";}}}}s:9:"group_key";i:0;s:4:"rate";d:28;s:10:"group_name";s:7:"CS-Cart";}}}}');
INSERT INTO `[[dbprefix]]order_data` VALUES
(186, 74, 'G', 'a:1:{i:0;a:10:{s:4:"name";s:7:"CS-Cart";s:10:"company_id";i:1;s:8:"products";a:13:{s:10:"2338935559";a:23:{s:10:"product_id";i:199;s:12:"product_code";s:10:"Y0199F6AC6";s:7:"product";s:37:"B.B. King - Original Greatest Hits CD";s:6:"amount";i:1;s:15:"product_options";a:0:{}s:5:"price";d:29.98;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"677";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"733";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:66:"http://localhost/git/work/images/detailed/0/bbk_originalhitscd.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"500";s:7:"image_y";s:3:"500";s:15:"http_image_path";s:66:"http://localhost/git/work/images/detailed/0/bbk_originalhitscd.jpg";s:13:"absolute_path";s:69:"/Users/alexions/www/git/work/images/detailed/0/bbk_originalhitscd.jpg";s:13:"relative_path";s:33:"detailed/0/bbk_originalhitscd.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"2338935559";s:6:"amount";s:1:"1";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:37:"B.B. King - Original Greatest Hits CD";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:29.98;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:29.98;s:13:"display_price";d:29.98;}s:10:"4235092881";a:23:{s:10:"product_id";i:198;s:12:"product_code";s:10:"K01984N7PI";s:7:"product";s:124:"B.B. King One Kind Favor CD Grammy Award Winning CD Manufacturer: Geffen Records Sku: BBK-11ONEKINDFAVORCD  Reviewed 2 times";s:6:"amount";i:1;s:15:"product_options";a:0:{}s:5:"price";d:17.989;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"676";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"732";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:74:"http://localhost/git/work/images/detailed/0/bbk_onekindfavorcdcover_sm.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"500";s:7:"image_y";s:3:"500";s:15:"http_image_path";s:74:"http://localhost/git/work/images/detailed/0/bbk_onekindfavorcdcover_sm.jpg";s:13:"absolute_path";s:77:"/Users/alexions/www/git/work/images/detailed/0/bbk_onekindfavorcdcover_sm.jpg";s:13:"relative_path";s:41:"detailed/0/bbk_onekindfavorcdcover_sm.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"4235092881";s:6:"amount";s:1:"1";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:124:"B.B. King One Kind Favor CD Grammy Award Winning CD Manufacturer: Geffen Records Sku: BBK-11ONEKINDFAVORCD  Reviewed 2 times";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:17.989;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:17.989;s:13:"display_price";d:17.989;}s:10:"1446436389";a:23:{s:10:"product_id";i:201;s:12:"product_code";s:10:"V02011EWI8";s:7:"product";s:36:"Beethoven Piano Concertos Nos. 1 & 2";s:6:"amount";i:1;s:15:"product_options";a:0:{}s:5:"price";d:12.67;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"679";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"735";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:89:"http://localhost/git/work/images/detailed/0/url_uploaded_file_13287720374f3373c6eef1f.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"600";s:7:"image_y";s:3:"600";s:15:"http_image_path";s:89:"http://localhost/git/work/images/detailed/0/url_uploaded_file_13287720374f3373c6eef1f.jpg";s:13:"absolute_path";s:92:"/Users/alexions/www/git/work/images/detailed/0/url_uploaded_file_13287720374f3373c6eef1f.jpg";s:13:"relative_path";s:56:"detailed/0/url_uploaded_file_13287720374f3373c6eef1f.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"1446436389";s:6:"amount";s:1:"1";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:36:"Beethoven Piano Concertos Nos. 1 & 2";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:12.67;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:12.67;s:13:"display_price";d:12.67;}s:9:"482052751";a:23:{s:10:"product_id";i:192;s:12:"product_code";s:10:"E01923M6DA";s:7:"product";s:33:"Black and White America (CD Pack)";s:6:"amount";i:1;s:15:"product_options";a:0:{}s:5:"price";d:15;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"669";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"725";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:59:"http://localhost/git/work/images/detailed/0/lenny_cover.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:4:"1000";s:7:"image_y";s:4:"1000";s:15:"http_image_path";s:59:"http://localhost/git/work/images/detailed/0/lenny_cover.jpg";s:13:"absolute_path";s:62:"/Users/alexions/www/git/work/images/detailed/0/lenny_cover.jpg";s:13:"relative_path";s:26:"detailed/0/lenny_cover.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:9:"482052751";s:6:"amount";s:1:"1";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:33:"Black and White America (CD Pack)";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:15;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:15;s:13:"display_price";d:15;}s:10:"2195660588";a:23:{s:10:"product_id";i:195;s:12:"product_code";s:10:"I0195ZFDB8";s:7:"product";s:38:"Crossroads Guitar Festival 2010 (2DVD)";s:6:"amount";i:1;s:15:"product_options";a:0:{}s:5:"price";d:29.989;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"672";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"728";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:66:"http://localhost/git/work/images/detailed/0/603497948727.sml_0.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"500";s:7:"image_y";s:3:"500";s:15:"http_image_path";s:66:"http://localhost/git/work/images/detailed/0/603497948727.sml_0.jpg";s:13:"absolute_path";s:69:"/Users/alexions/www/git/work/images/detailed/0/603497948727.sml_0.jpg";s:13:"relative_path";s:33:"detailed/0/603497948727.sml_0.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"2195660588";s:6:"amount";s:1:"1";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:38:"Crossroads Guitar Festival 2010 (2DVD)";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:29.989;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:29.989;s:13:"display_price";d:29.989;}s:10:"2243091253";a:23:{s:10:"product_id";i:191;s:12:"product_code";s:10:"Q0191PBM44";s:7:"product";s:40:"Esperanza Spalding - Radio Music Society";s:6:"amount";i:1;s:15:"product_options";a:0:{}s:5:"price";d:11.98;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"668";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"724";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:57:"http://localhost/git/work/images/detailed/0/02xrms-cd.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"300";s:7:"image_y";s:3:"300";s:15:"http_image_path";s:57:"http://localhost/git/work/images/detailed/0/02xrms-cd.jpg";s:13:"absolute_path";s:60:"/Users/alexions/www/git/work/images/detailed/0/02xrms-cd.jpg";s:13:"relative_path";s:24:"detailed/0/02xrms-cd.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"2243091253";s:6:"amount";s:1:"1";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:40:"Esperanza Spalding - Radio Music Society";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:11.98;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:11.98;s:13:"display_price";d:11.98;}s:9:"467029654";a:23:{s:10:"product_id";i:196;s:12:"product_code";s:10:"I0196BBF6I";s:7:"product";s:40:"Feeding the Monkies At Ma Maison (Zappa)";s:6:"amount";i:1;s:15:"product_options";a:0:{}s:5:"price";d:17;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"673";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"729";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:73:"http://localhost/git/work/images/detailed/0/feedingthemonkies_frntLRG.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"600";s:7:"image_y";s:3:"600";s:15:"http_image_path";s:73:"http://localhost/git/work/images/detailed/0/feedingthemonkies_frntLRG.jpg";s:13:"absolute_path";s:76:"/Users/alexions/www/git/work/images/detailed/0/feedingthemonkies_frntLRG.jpg";s:13:"relative_path";s:40:"detailed/0/feedingthemonkies_frntLRG.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:9:"467029654";s:6:"amount";s:1:"1";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:40:"Feeding the Monkies At Ma Maison (Zappa)";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:17;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:17;s:13:"display_price";d:17;}s:10:"1825668608";a:23:{s:10:"product_id";i:197;s:12:"product_code";s:10:"A019737E4S";s:7:"product";s:24:"Guitar Man Album Artwork";s:6:"amount";i:2;s:15:"product_options";a:0:{}s:5:"price";d:14.98;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"674";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"730";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:89:"http://localhost/git/work/images/detailed/0/url_uploaded_file_13287662164f335d096a3ce.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:3:"650";s:7:"image_y";s:3:"650";s:15:"http_image_path";s:89:"http://localhost/git/work/images/detailed/0/url_uploaded_file_13287662164f335d096a3ce.jpg";s:13:"absolute_path";s:92:"/Users/alexions/www/git/work/images/detailed/0/url_uploaded_file_13287662164f335d096a3ce.jpg";s:13:"relative_path";s:56:"detailed/0/url_uploaded_file_13287662164f335d096a3ce.jpg";}}s:15:"original_amount";s:1:"2";s:21:"original_product_data";a:2:{s:7:"cart_id";s:10:"1825668608";s:6:"amount";s:1:"2";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:24:"Guitar Man Album Artwork";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:14.98;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:2;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:14.98;s:13:"display_price";d:14.98;}s:9:"556920499";a:23:{s:10:"product_id";i:200;s:12:"product_code";s:10:"X02002U30A";s:7:"product";s:38:"John Rutter - The Colours of Christmas";s:6:"amount";i:1;s:15:"product_options";a:0:{}s:5:"price";d:26.920;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"678";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"734";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:89:"http://localhost/git/work/images/detailed/0/url_uploaded_file_13287719184f33734f6b3e9.jpg";s:3:"alt";s:0:"";s:7:"image_x";s:4:"1426";s:7:"image_y";s:4:"1413";s:15:"http_image_path";s:89:"http://localhost/git/work/images/detailed/0/url_uploaded_file_13287719184f33734f6b3e9.jpg";s:13:"absolute_path";s:92:"/Users/alexions/www/git/work/images/detailed/0/url_uploaded_file_13287719184f33734f6b3e9.jpg";s:13:"relative_path";s:56:"detailed/0/url_uploaded_file_13287719184f33734f6b3e9.jpg";}}s:15:"original_amount";s:1:"1";s:21:"original_product_data";a:2:{s:7:"cart_id";s:9:"556920499";s:6:"amount";s:1:"1";}s:5:"extra";a:9:{s:15:"product_options";a:0:{}s:18:"unlimited_download";s:1:"N";s:7:"product";s:38:"John Rutter - The Colours of Christmas";s:10:"company_id";s:1:"1";s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:8:"discount";i:0;s:10:"base_price";d:26.920;s:12:"stored_price";s:1:"N";}s:15:"stored_discount";s:1:"N";s:8:"discount";i:0;s:10:"company_id";s:1:"1";s:12:"amount_total";i:1;s:12:"options_type";s:1:"P";s:15:"exceptions_type";s:1:"F";s:15:"modifiers_price";i:0;s:6:"is_edp";s:1:"N";s:12:"edp_shipping";s:1:"N";s:10:"promotions";a:0:{}s:10:"base_price";d:26.920;s:13:"display_price";d:26.920;}s:10:"3477049247";a:23:{s:10:"product_id";i:202;s:12:"product_code";s:10:"T0202OTGXT";s:7:"product";s:76:"New Year''s Concert 2011 Diverse Klassik Welser-moest / Wiener Philharmoniker";s:6:"amount";i:1;s:15:"product_options";a:0:{}s:5:"price";d:34.68;s:12:"stored_price";s:1:"Y";s:9:"main_pair";a:5:{s:7:"pair_id";s:3:"680";s:8:"image_id";s:1:"0";s:11:"detailed_id";s:3:"736";s:8:"position";s:1:"0";s:8:"detailed";a:7:{s:10:"image_path";s:54:"http://localhost/git/work/images/detailed/0/cover1.jpg";s:3:"alt";s:0:""