import { IGridConfig, ICol, IRow, IFooter, IHeader, IGroupOrderItem, IExtendedGrid, IExtendedGridConfig, ISubViewCell } from "./types";
import { IDataCollection, IDataItem } from "../../ts-data";
import { ScrollView } from "../../ts-common/ScrollView";
import { Id } from "../../ts-common/types";
import { Grid } from "./Grid";
export declare class ExtendedGrid extends Grid implements IExtendedGrid {
    scrollView: ScrollView;
    config: IExtendedGridConfig;
    constructor(container: HTMLElement | string | null, config?: IExtendedGridConfig);
    expand(rowId: Id): void;
    collapse(rowId: Id): void;
    expandAll(): void;
    collapseAll(): void;
    getSubRow(id: Id): ISubViewCell | null;
    protected _createView(): any;
    protected _setHTMLEventHandlers(): void;
    protected _setEventHandlers(): void;
    protected _setSort(): void;
    protected getNormalizeContentHeight(row: IFooter | IHeader, col: ICol, config: IGridConfig): number;
    protected _prepareData(data: IDataItem[] | IDataCollection): IDataItem[] | IRow[];
    protected _prepareDataFromTo(data: IDataCollection, from: number, to: number): IDataItem[];
    protected _dragStart(event: any): void;
    protected _group(order: IGroupOrderItem[]): void;
    protected _expand(row: IRow): boolean;
    protected _collapse(row: IRow): boolean;
    private _lazyLoad;
    private _getGhostItem;
    private _dragStartColumn;
    private _dragStartGroupItem;
    private _changeGroupItemAfterSort;
    private _isGroupableColumn;
    private _isGroupClosable;
}
