import { ScrollView } from "../../ts-common/ScrollView";
import { TreeGridCollection } from "../../ts-treegrid";
import { EditorType, GridEvents, IAdjustBy, ICellRect, ICol, IContentList, ICoords, IEventHandlersMap, IHeaderFilter, IProGrid, IProGridConfig, ISpan, ISubViewCell, ISummaryList } from "./types";
import { IKeyManager } from "../../ts-common/KeyManager";
import { IEventSystem } from "../../ts-common/events";
import { Id } from "../../ts-common/types";
import { DataEvents, DragEvents, IDataEventsHandlersMap, IDragEventsHandlersMap, IDataCollection, IDataItem, TSortDir } from "../../ts-data";
import { ISelection } from "./modules/Selection";
import { IRange } from "./modules/Range";
import { IBlockSelection } from "./modules/BlockSelection";
import { IClipboard } from "./modules/Clipboard";
import { IHistory } from "./modules/History";
export declare class ProGrid implements IProGrid {
    config: IProGridConfig;
    scrollView: ScrollView;
    events: IEventSystem<GridEvents | DataEvents | DragEvents, IEventHandlersMap & IDataEventsHandlersMap & IDragEventsHandlersMap>;
    name: string;
    data: IDataCollection<IDataItem> & TreeGridCollection;
    selection: ISelection;
    content: IContentList;
    keyManager: IKeyManager;
    export: any;
    range: IRange;
    block: IBlockSelection;
    clipboard: IClipboard;
    history: IHistory;
    constructor(container: HTMLElement | string | null, config?: IProGridConfig);
    paint(): void;
    destructor(): void;
    expand(rowId: Id): void;
    collapse(rowId: Id): void;
    expandAll(): void;
    collapseAll(): void;
    showColumn(colId: Id): void;
    hideColumn(colId: Id): void;
    isColumnHidden(colId: Id): boolean;
    showRow(rowId: Id): void;
    hideRow(rowId: Id): void;
    isRowHidden(rowId: Id): boolean;
    scrollTo(rowId: Id, colId: Id): void;
    scroll(x?: number, y?: number): void;
    getScrollState(): ICoords;
    setColumns(col: ICol[]): void;
    addRowCss(rowId: Id, css: string): void;
    removeRowCss(rowId: Id, css: string): void;
    addCellCss(rowId: Id, colId: Id, css: string): void;
    removeCellCss(rowId: Id, colId: Id, css: string): void;
    adjustColumnWidth(colId: Id, adjust?: IAdjustBy): void;
    getCellRect(rowId: Id, colId: Id): ICellRect;
    getColumn(colId: Id): ICol;
    addSpan(spanObj: ISpan): void;
    getSpan(rowId: Id, colId: Id): ISpan;
    removeSpan(rowId: Id, colId: Id): void;
    editCell(rowId: Id, colId: Id, editorType?: EditorType): void;
    editEnd(withoutSave?: boolean): void;
    getHeaderFilter(colId: Id): IHeaderFilter;
    getSummary(colId?: Id): ISummaryList;
    getSubRow(id: Id): ISubViewCell | null;
    getRootNode(): HTMLElement;
    getRootView(): void;
    /** @deprecated See a documentation: https://docs.dhtmlx.com/suite/migration/ */
    getSortingState(): {
        dir?: TSortDir;
        by?: Id;
    };
}
