-- Copyright (C) 2001-2004 Rodolphe Quiedeville <rodolphe@quiedeville.org>
-- Copyright (C) 2003      Jean-Louis Bergamo   <jlb@j1b.org>
-- Copyright (C) 2004-2009 Laurent Destailleur  <eldy@users.sourceforge.net>
-- Copyright (C) 2004      Benoit Mortier       <benoit.mortier@opensides.be>
-- Copyright (C) 2004      Guillaume Delecourt  <guillaume.delecourt@opensides.be>
-- Copyright (C) 2005-2009 Regis Houssin        <regis.houssin@inodbox.com>
-- Copyright (C) 2007 	   Patrick Raguin       <patrick.raguin@gmail.com>
-- Copyright (C) 2011-2017 Alexandre Spangaro   <aspangaro@open-dsi.fr>
-- Copyright (C) 2025      Ferran Marcet        <fmarcet@2byte.es>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program. If not, see <https://www.gnu.org/licenses/>.
--
--

--
-- Ne pas placer de commentaire en fin de ligne, ce fichier est parsé lors
-- de l'install et tous les sigles '--' sont supprimés.
--

--
-- Vertical aligning by commas with Emacs:
-- replace-regexp -> ,' -> , '
-- replace-regexp -> ' *, -> ',
-- C-u align-regexp -> \(\s-*'[^']+',\) -> -1 -> 1 -> y ; Align all string fields to right
-- C-u align-regexp -> \([0-9]+',\)\(\s-*\)\('[^']+', [0-9]\) -> 2 -> 1 -> y ; Align label field to left
-- C-u align-regexp -> \('[^']+'\)\(\s-*\)\(, [0-9]);\) -> 2 -> 1 -> y ; Align active field
--

-- ID 34000 -  34393 AD PCG15-PYME
-- ADD 3400000 to rowid # Do no remove this comment --

--
-- Descriptif des plans comptables AD PCG15-PYME
-- Source https://www.bopa.ad/Documents/Detall?doc=750DA with some differences.
--

INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34001, 'PCG15-PYME-AD', 'CAPITAL', '1', 0, 'FINANÇAMENT BÀSIC', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34002, 'PCG15-PYME-AD', 'ACTIU', '2', 0, 'ACTIU NO CORRENT', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34003, 'PCG15-PYME-AD', 'EXISTENCIES', 3, 0, 'EXISTÈNCIES', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34004, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 4, 0, 'CREDITORS I DEUTORS PER OPERACIONS COMERCIALS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34005, 'PCG15-PYME-AD', 'FINANCER', 5, 0, 'COMPTES FINANCERS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34006, 'PCG15-PYME-AD', 'DESPESA', 6, 0, 'COMPRES I DESPESES', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34007, 'PCG15-PYME-AD', 'INGRES', 7, 0, 'VENDES I INGRESSOS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34008, 'PCG15-PYME-AD', 'CAPITAL', 10, 34001, 'CAPITAL', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34009, 'PCG15-PYME-AD', 'CAPITAL', 100, 34008, 'Capital social', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34010, 'PCG15-PYME-AD', 'CAPITAL', 101, 34008, 'Fons social', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34011, 'PCG15-PYME-AD', 'CAPITAL', 102, 34008, 'Capital', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34012, 'PCG15-PYME-AD', 'CAPITAL', 108, 34008, 'Accions o participacions pròpies en situacions especials', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34013, 'PCG15-PYME-AD', 'CAPITAL', 109, 34008, 'Accions o participacions pròpies per reducció de capital', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34014, 'PCG15-PYME-AD', 'CAPITAL', 11, 34001, 'RESERVES', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34015, 'PCG15-PYME-AD', 'CAPITAL', 110, 34014, 'Prima d’emissió', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34016, 'PCG15-PYME-AD', 'CAPITAL', 112, 34014, 'Reserva legal', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34017, 'PCG15-PYME-AD', 'CAPITAL', 113, 34014, 'Reserves estatutàries', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34018, 'PCG15-PYME-AD', 'CAPITAL', 114, 34014, 'Reserves voluntàries', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34019, 'PCG15-PYME-AD', 'CAPITAL', 115, 34014, 'Reserva per accions pròpies', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34020, 'PCG15-PYME-AD', 'CAPITAL', 116, 34014, 'Reserva de revaloració', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34021, 'PCG15-PYME-AD', 'CAPITAL', 118, 34014, 'Aportacions de socis o propietaris', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34022, 'PCG15-PYME-AD', 'CAPITAL', 119, 34014, 'Altres reserves', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34023, 'PCG15-PYME-AD', 'CAPITAL', 12, 34001, 'RESULTATS PENDENTS D’APLICACIÓ', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34024, 'PCG15-PYME-AD', 'CAPITAL', 120, 34023, 'Romanent', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34025, 'PCG15-PYME-AD', 'CAPITAL', 121, 34023, 'Resultats negatius d’exercicis anteriors', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34026, 'PCG15-PYME-AD', 'CAPITAL', 129, 34023, 'Resultat de l’exercici', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34027, 'PCG15-PYME-AD', 'CAPITAL', 13, 34001, 'SUBVENCIONS I DONACIONS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34028, 'PCG15-PYME-AD', 'CAPITAL', 130, 34027, 'Subvencions oficials de capital', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34029, 'PCG15-PYME-AD', 'CAPITAL', 131, 34027, 'Donacions i llegats de capital', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34030, 'PCG15-PYME-AD', 'CAPITAL', 132, 34027, 'Altres subvencions, donacions i llegats', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34031, 'PCG15-PYME-AD', 'CAPITAL', 14, 34001, 'PROVISIONS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34032, 'PCG15-PYME-AD', 'CAPITAL', 141, 34031, 'Provisió per tributs', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34033, 'PCG15-PYME-AD', 'CAPITAL', 143, 34031, 'Provisió per desmantellament, retirament o rehabilitació de l’immobilitzat', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34034, 'PCG15-PYME-AD', 'CAPITAL', 145, 34031, 'Provisió per actuacions mediambientals', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34035, 'PCG15-PYME-AD', 'CAPITAL', 146, 34031, 'Provisió per altres responsabilitats', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34036, 'PCG15-PYME-AD', 'CAPITAL', 16, 34001, 'DEUTES A LLARG TERMINI AMB PARTS VINCULADES', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34037, 'PCG15-PYME-AD', 'CAPITAL', 160, 34036, 'Deutes a llarg termini amb entitats de crèdit vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34038, 'PCG15-PYME-AD', 'CAPITAL', 161, 34036, 'Proveïdors d’immobilitzat a llarg termini, parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34039, 'PCG15-PYME-AD', 'CAPITAL', 162, 34036, 'Creditors per arrendament financer a llarg termini, parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34040, 'PCG15-PYME-AD', 'CAPITAL', 163, 34036, 'Altres deutes a llarg termini amb parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34041, 'PCG15-PYME-AD', 'CAPITAL', 17, 34001, 'DEUTES A LLARG TERMINI PER PRÉSTECS REBUTS, EMPRÈSTITS I ALTRES CONCEPTES', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34042, 'PCG15-PYME-AD', 'CAPITAL', 170, 34041, 'Deutes a llarg termini amb entitats de crèdit', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34043, 'PCG15-PYME-AD', 'CAPITAL', 171, 34041, 'Deutes a llarg termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34044, 'PCG15-PYME-AD', 'CAPITAL', 173, 34041, 'Proveïdors d’immobilitzat a llarg termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34045, 'PCG15-PYME-AD', 'CAPITAL', 174, 34041, 'Creditors per arrendament financer a llarg termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34046, 'PCG15-PYME-AD', 'CAPITAL', 175, 34041, 'Efectes a pagar a llarg termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34047, 'PCG15-PYME-AD', 'CAPITAL', 177, 34041, 'Obligacions i bons', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34048, 'PCG15-PYME-AD', 'CAPITAL', 179, 34041, 'Deutes representats en altres valors negociables', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34049, 'PCG15-PYME-AD', 'CAPITAL', 18, 34001, 'PASSIUS PER FIANCES, GARANTIES I ALTRES CONCEPTES A LLARG TERMINI', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34050, 'PCG15-PYME-AD', 'CAPITAL', 180, 34049, 'Fiances rebudes a llarg termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34051, 'PCG15-PYME-AD', 'CAPITAL', 181, 34049, 'Bestretes rebudes per vendes o prestacions de serveis a llarg termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34052, 'PCG15-PYME-AD', 'CAPITAL', 185, 34049, 'Dipòsits rebuts a llarg termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34053, 'PCG15-PYME-AD', 'CAPITAL', 189, 34049, 'Garanties financeres a llarg termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34054, 'PCG15-PYME-AD', 'CAPITAL', 19, 34001, 'SITUACIONS TRANSITÒRIES DE FINANÇAMENT', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34055, 'PCG15-PYME-AD', 'CAPITAL', 194, 34054, 'Capital emès pendent d’inscripció al Registre de Societats', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34056, 'PCG15-PYME-AD', 'ACTIU', 20, 34002, 'IMMOBILITZAT INTANGIBLE', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34057, 'PCG15-PYME-AD', 'ACTIU', 200, 34056, 'Despeses d’establiment', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34058, 'PCG15-PYME-AD', 'ACTIU', 201, 34056, 'Investigació', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34059, 'PCG15-PYME-AD', 'ACTIU', 202, 34056, 'Desenvolupament', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34060, 'PCG15-PYME-AD', 'ACTIU', 203, 34056, 'Concessions administratives', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34061, 'PCG15-PYME-AD', 'ACTIU', 204, 34056, 'Propietat industrial', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34062, 'PCG15-PYME-AD', 'ACTIU', 205, 34056, 'Fons de comerç', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34063, 'PCG15-PYME-AD', 'ACTIU', 206, 34056, 'Drets de traspàs', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34064, 'PCG15-PYME-AD', 'ACTIU', 207, 34056, 'Aplicacions informàtiques', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34065, 'PCG15-PYME-AD', 'ACTIU', 208, 34056, 'Altre immobilitzat intangible', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34066, 'PCG15-PYME-AD', 'ACTIU', 209, 34056, 'Bestretes per immobilitzat intangible', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34067, 'PCG15-PYME-AD', 'ACTIU', 21, 34002, 'IMMOBILITZAT TANGIBLE', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34068, 'PCG15-PYME-AD', 'ACTIU', 210, 34067, 'Terrenys i béns naturals', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34069, 'PCG15-PYME-AD', 'ACTIU', 211, 34067, 'Construccions', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34070, 'PCG15-PYME-AD', 'ACTIU', 212, 34067, 'Instal·lacions tècniques', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34071, 'PCG15-PYME-AD', 'ACTIU', 213, 34067, 'Maquinària', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34072, 'PCG15-PYME-AD', 'ACTIU', 214, 34067, 'Utillatge', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34073, 'PCG15-PYME-AD', 'ACTIU', 215, 34067, 'Altres instal·lacions', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34074, 'PCG15-PYME-AD', 'ACTIU', 216, 34067, 'Mobiliari', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34075, 'PCG15-PYME-AD', 'ACTIU', 217, 34067, 'Equips per a processos d’informació', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34076, 'PCG15-PYME-AD', 'ACTIU', 218, 34067, 'Elements de transport', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34077, 'PCG15-PYME-AD', 'ACTIU', 219, 34067, 'Altre immobilitzat tangible', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34078, 'PCG15-PYME-AD', 'ACTIU', 22, 34002, 'INVERSIONS IMMOBILIÀRIES', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34079, 'PCG15-PYME-AD', 'ACTIU', 220, 34078, 'Inversions en terrenys i béns naturals', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34080, 'PCG15-PYME-AD', 'ACTIU', 221, 34078, 'Inversions en construccions', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34081, 'PCG15-PYME-AD', 'ACTIU', 23, 34002, 'IMMOBILITZAT TANGIBLE EN CURS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34082, 'PCG15-PYME-AD', 'ACTIU', 230, 34081, 'Adaptació de terrenys i béns naturals', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34083, 'PCG15-PYME-AD', 'ACTIU', 231, 34081, 'Construccions en curs', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34084, 'PCG15-PYME-AD', 'ACTIU', 232, 34081, 'Instal·lacions tècniques en muntatge', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34085, 'PCG15-PYME-AD', 'ACTIU', 233, 34081, 'Maquinària en muntatge', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34086, 'PCG15-PYME-AD', 'ACTIU', 237, 34081, 'Equips per processos d’informació en muntatge', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34087, 'PCG15-PYME-AD', 'ACTIU', 238, 34081, 'Altre immobilitzat tangible en curs', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34088, 'PCG15-PYME-AD', 'ACTIU', 239, 34081, 'Bestretes per immobilitzat tangible', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34089, 'PCG15-PYME-AD', 'ACTIU', 24, 34002, 'INVERSIONS FINANCERES A LLARG TERMINI EN PARTS VINCULADES', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34090, 'PCG15-PYME-AD', 'ACTIU', 240, 34089, 'Participacions a llarg termini en parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34091, 'PCG15-PYME-AD', 'ACTIU', 241, 34089, 'Valors representatius de deute a llarg termini de parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34092, 'PCG15-PYME-AD', 'ACTIU', 242, 34089, 'Crèdits a llarg termini a parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34093, 'PCG15-PYME-AD', 'ACTIU', 25, 34002, 'ALTRES INVERSIONS FINANCERES A LLARG TERMINI', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34094, 'PCG15-PYME-AD', 'ACTIU', 250, 34093, 'Inversions financeres a llarg termini en instruments de patrimoni', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34095, 'PCG15-PYME-AD', 'ACTIU', 251, 34093, 'Valors representatius de deute a llarg termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34096, 'PCG15-PYME-AD', 'ACTIU', 252, 34093, 'Crèdits a llarg termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34097, 'PCG15-PYME-AD', 'ACTIU', 253, 34093, 'Crèdits a llarg termini per alienació d’immobilitzat', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34098, 'PCG15-PYME-AD', 'ACTIU', 254, 34093, 'Crèdits a llarg termini al personal', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34099, 'PCG15-PYME-AD', 'ACTIU', 258, 34093, 'Imposicions a llarg termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34100, 'PCG15-PYME-AD', 'ACTIU', 26, 34002, 'FIANCES I DIPÒSITS CONSTITUÏTS A LLARG TERMINI', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34101, 'PCG15-PYME-AD', 'ACTIU', 260, 34100, 'Fiances constituïdes a llarg termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34102, 'PCG15-PYME-AD', 'ACTIU', 265, 34100, 'Dipòsits constituïts a llarg termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34103, 'PCG15-PYME-AD', 'ACTIU', 28, 34002, 'AMORTITZACIÓ ACUMULADA DE L’IMMOBILITZAT', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34104, 'PCG15-PYME-AD', 'ACTIU', 280, 34103, 'Amortització acumulada de l’immobilitzat intangible', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34105, 'PCG15-PYME-AD', 'ACTIU', 281, 34103, 'Amortització acumulada de l’immobilitzat tangible', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34106, 'PCG15-PYME-AD', 'ACTIU', 282, 34103, 'Amortització acumulada de les inversions immobiliàries', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34107, 'PCG15-PYME-AD', 'ACTIU', 29, 34002, 'DETERIORAMENT DE VALOR D’ACTIUS NO CORRENTS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34108, 'PCG15-PYME-AD', 'ACTIU', 290, 34107, 'Deteriorament de valor de l’immobilitzat intangible', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34109, 'PCG15-PYME-AD', 'ACTIU', 291, 34107, 'Deteriorament de valor de l’immobilitzat tangible', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34110, 'PCG15-PYME-AD', 'ACTIU', 292, 34107, 'Deteriorament de valor de les inversions immobiliàries', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34111, 'PCG15-PYME-AD', 'ACTIU', 293, 34107, 'Deteriorament de valor de participacions a llarg termini en parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34112, 'PCG15-PYME-AD', 'ACTIU', 294, 34107, 'Deteriorament de valor de valors representatius de deute a llarg termini de parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34113, 'PCG15-PYME-AD', 'ACTIU', 295, 34107, 'Deteriorament de valor de crèdits a llarg termini a parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34114, 'PCG15-PYME-AD', 'ACTIU', 296, 34107, 'Deteriorament de valor de participacions en el patrimoni net a llarg termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34115, 'PCG15-PYME-AD', 'ACTIU', 297, 34107, 'Deteriorament de valor de valors representatius de deute a llarg termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34116, 'PCG15-PYME-AD', 'ACTIU', 298, 34107, 'Deteriorament de valor de crèdits a llarg termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34117, 'PCG15-PYME-AD', 'EXISTENCIES', 30, 34003, 'COMERCIALS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34118, 'PCG15-PYME-AD', 'EXISTENCIES', 300, 34117, 'Mercaderies A', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34119, 'PCG15-PYME-AD', 'EXISTENCIES', 301, 34117, 'Mercaderies B', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34120, 'PCG15-PYME-AD', 'EXISTENCIES', 31, 34003, 'MATÈRIES PRIMERES', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34121, 'PCG15-PYME-AD', 'EXISTENCIES', 310, 34120, 'Matèries primeres A', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34122, 'PCG15-PYME-AD', 'EXISTENCIES', 311, 34120, 'Matèries primeres B', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34123, 'PCG15-PYME-AD', 'EXISTENCIES', 32, 34003, 'ALTRES APROVISIONAMENTS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34124, 'PCG15-PYME-AD', 'EXISTENCIES', 320, 34124, 'Elements i conjunts incorporables', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34125, 'PCG15-PYME-AD', 'EXISTENCIES', 321, 34124, 'Combustibles', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34126, 'PCG15-PYME-AD', 'EXISTENCIES', 322, 34124, 'Recanvis', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34127, 'PCG15-PYME-AD', 'EXISTENCIES', 325, 34124, 'Materials diversos', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34128, 'PCG15-PYME-AD', 'EXISTENCIES', 326, 34124, 'Embalatges', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34129, 'PCG15-PYME-AD', 'EXISTENCIES', 327, 34124, 'Envasos', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34130, 'PCG15-PYME-AD', 'EXISTENCIES', 328, 34124, 'Material d’oficina', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34131, 'PCG15-PYME-AD', 'EXISTENCIES', 33, 34003, 'PRODUCTES EN CURS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34132, 'PCG15-PYME-AD', 'EXISTENCIES', 330, 34132, 'Productes en curs A', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34133, 'PCG15-PYME-AD', 'EXISTENCIES', 331, 34132, 'Productes en curs B', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34134, 'PCG15-PYME-AD', 'EXISTENCIES', 34, 34003, 'PRODUCTES SEMIACABATS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34135, 'PCG15-PYME-AD', 'EXISTENCIES', 340, 34134, 'Productes semiacabats A', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34136, 'PCG15-PYME-AD', 'EXISTENCIES', 341, 34134, 'Productes semiacabats B', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34137, 'PCG15-PYME-AD', 'EXISTENCIES', 35, 34003, 'PRODUCTES ACABATS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34138, 'PCG15-PYME-AD', 'EXISTENCIES', 350, 34137, 'Productes acabats A', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34139, 'PCG15-PYME-AD', 'EXISTENCIES', 351, 34137, 'Productes acabats B', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34140, 'PCG15-PYME-AD', 'EXISTENCIES', 36, 34003, 'SUBPRODUCTES, RESIDUS I MATERIALS RECUPERATS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34141, 'PCG15-PYME-AD', 'EXISTENCIES', 360, 34140, 'Subproductes A', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34142, 'PCG15-PYME-AD', 'EXISTENCIES', 361, 34140, 'Subproductes B', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34143, 'PCG15-PYME-AD', 'EXISTENCIES', 365, 34140, 'Residus A', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34144, 'PCG15-PYME-AD', 'EXISTENCIES', 366, 34140, 'Residus B', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34145, 'PCG15-PYME-AD', 'EXISTENCIES', 368, 34140, 'Materials recuperats A', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34146, 'PCG15-PYME-AD', 'EXISTENCIES', 369, 34140, 'Materials recuperats B', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34147, 'PCG15-PYME-AD', 'EXISTENCIES', 39, 34003, 'DETERIORAMENT DE VALOR DE LES EXISTÈNCIES', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34148, 'PCG15-PYME-AD', 'EXISTENCIES', 390, 34147, 'Deteriorament de valor de les mercaderies', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34149, 'PCG15-PYME-AD', 'EXISTENCIES', 391, 34147, 'Deteriorament de valor de les matèries primeres', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34150, 'PCG15-PYME-AD', 'EXISTENCIES', 392, 34147, 'Deteriorament de valor d’altres aprovisionaments', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34151, 'PCG15-PYME-AD', 'EXISTENCIES', 393, 34147, 'Deteriorament de valor dels productes en curs', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34152, 'PCG15-PYME-AD', 'EXISTENCIES', 394, 34147, 'Deteriorament de valor dels productes semiacabats', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34153, 'PCG15-PYME-AD', 'EXISTENCIES', 395, 34147, 'Deteriorament de valor dels productes acabats', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34154, 'PCG15-PYME-AD', 'EXISTENCIES', 396, 34147, 'Deteriorament de valor dels subproductes, residus i materials recuperats', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34155, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 40, 34004, 'PROVEÏDORS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34156, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 400, 34155, 'Proveïdors', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34157, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 401, 34155, 'Proveïdors, efectes comercials a pagar', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34158, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 403, 34155, 'Proveïdors, empreses del grup', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34159, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 404, 34155, 'Proveïdors, empreses associades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34160, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 405, 34155, 'Proveïdors, altres parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34161, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 406, 34155, 'Envasos i embalatges a retornar a proveïdors', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34162, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 407, 34155, 'Bestretes a proveïdors', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34163, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 41, 34004, 'CREDITORS DIVERSOS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34164, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 410, 34163, 'Creditors per prestacions de serveis', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34165, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 411, 34163, 'Creditors, efectes comercials a pagar', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34166, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 43, 34004, 'CLIENTS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34167, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 430, 34166, 'Clients', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34168, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 431, 34166, 'Clients, efectes comercials a cobrar', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34169, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 432, 34166, 'Clients, operacions de “factoring”', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34170, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 433, 34166, 'Clients, empreses del grup', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34171, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 434, 34166, 'Clients, empreses associades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34172, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 435, 34166, 'Clients, altres empreses vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34173, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 436, 34166, 'Clients de cobrament dubtós', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34174, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 437, 34166, 'Envasos i embalatges a retornar per clients', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34175, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 438, 34166, 'Bestretes de clients', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34176, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 44, 34004, 'DEUTORS DIVERSOS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34177, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 440, 34176, 'Deutors', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34178, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 441, 34176, 'Deutors, efectes comercials a cobrar', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34179, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 446, 34176, 'Deutors de cobrament dubtós', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34180, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 46, 34004, 'PERSONAL', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34181, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 460, 34180, 'Bestretes de remuneracions', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34182, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 465, 34180, 'Remuneracions pendents de pagament', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34183, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 466, 34180, 'Remuneracions mitjançant sistemes d’aportació definida pendents de pagament', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34184, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 47, 34004, 'ADMINISTRACIONS PÚBLIQUES', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34185, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 470, 34184, 'Administracions públiques, deutor', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34186, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 472, 34184, 'Administracions públiques, impost indirecte suportat', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34187, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 473, 34184, 'Administracions públiques, retencions i pagaments a compte per ISI', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34188, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 475, 34184, 'Administracions públiques, creditor', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34189, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 476, 34184, 'Caixa Andorrana de Seguretat Social, creditors', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34190, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 477, 34184, 'Administracions públiques, impost indirecte repercutit', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34191, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 48, 34004, 'AJUSTAMENTS PER PERIODIFICACIÓ', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34192, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 480, 34191, 'Despeses anticipades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34193, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 485, 34191, 'Ingressos anticipats', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34194, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 49, 34004, 'DETERIORAMENT DE VALOR DE CRÈDITS COMERCIALS I PROVISIONS A CURT TERMINI', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34195, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 490, 34194, 'Deteriorament de valor de crèdits per operacions comercials', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34196, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 493, 34194, 'Deteriorament de valor de crèdits per operacions comercials amb parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34197, 'PCG15-PYME-AD', 'CREDITORS_DEUTORS', 499, 34194, 'Provisions per operacions comercials', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34198, 'PCG15-PYME-AD', 'FINANCER', 50, 34005, 'EMPRÈSTITS, DEUTES AMB CARACTERÍSTIQUES ESPECIALS I ALTRES EMISSIONS ANÀLOGUES A CURT TERMINI', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34199, 'PCG15-PYME-AD', 'FINANCER', 500, 34198, 'Obligacions i bons a curt termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34200, 'PCG15-PYME-AD', 'FINANCER', 505, 34198, 'Deutes representats en altres valors negociables a curt termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34201, 'PCG15-PYME-AD', 'FINANCER', 506, 34198, 'Interessos a curt termini d’emprèstits i altres emissions anàlogues', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34202, 'PCG15-PYME-AD', 'FINANCER', 51, 34005, 'DEUTES A CURT TERMINI AMB PARTS VINCULADES', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34203, 'PCG15-PYME-AD', 'FINANCER', 510, 34202, 'Deutes a curt termini amb entitats de crèdit vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34204, 'PCG15-PYME-AD', 'FINANCER', 511, 34202, 'Proveïdors d’immobilitzat a curt termini, parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34205, 'PCG15-PYME-AD', 'FINANCER', 512, 34202, 'Creditors per arrendament financer a curt termini, parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34206, 'PCG15-PYME-AD', 'FINANCER', 513, 34202, 'Altres deutes a curt termini amb parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34207, 'PCG15-PYME-AD', 'FINANCER', 514, 34202, 'Interessos a curt termini de deutes amb parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34208, 'PCG15-PYME-AD', 'FINANCER', 52, 34005, 'DEUTES A CURT TERMINI PER PRÉSTECS REBUTS I ALTRES CONCEPTES', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34209, 'PCG15-PYME-AD', 'FINANCER', 520, 34208, 'Deutes a curt termini amb entitats de crèdit', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34210, 'PCG15-PYME-AD', 'FINANCER', 523, 34208, 'Proveïdors d’immobilitzat a curt termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34211, 'PCG15-PYME-AD', 'FINANCER', 524, 34208, 'Creditors per arrendament financer a curt termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34212, 'PCG15-PYME-AD', 'FINANCER', 526, 34208, 'Dividend actiu a pagar', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34213, 'PCG15-PYME-AD', 'FINANCER', 527, 34208, 'Interessos a curt termini de deutes amb entitats de crèdit', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34214, 'PCG15-PYME-AD', 'FINANCER', 528, 34208, 'Altres deutes a curt termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34215, 'PCG15-PYME-AD', 'FINANCER', 529, 34208, 'Provisions a curt termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34216, 'PCG15-PYME-AD', 'FINANCER', 53, 34005, 'INVERSIONS FINANCERES A CURT TERMINI EN PARTS VINCULADES', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34217, 'PCG15-PYME-AD', 'FINANCER', 530, 34216, 'Participacions a curt termini en parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34218, 'PCG15-PYME-AD', 'FINANCER', 531, 34216, 'Crèdits i valors representatius de deute a curt termini de parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34219, 'PCG15-PYME-AD', 'FINANCER', 533, 34216, 'Interessos a curt termini de crèdits i valors representatius de deute de parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34220, 'PCG15-PYME-AD', 'FINANCER', 535, 34216, 'Dividend a cobrar d’inversions financeres en parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34221, 'PCG15-PYME-AD', 'FINANCER', 54, 34005, 'ALTRES INVERSIONS FINANCERES A CURT TERMINI', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34222, 'PCG15-PYME-AD', 'FINANCER', 540, 34221, 'Inversions financeres a curt termini en instruments de patrimoni', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34223, 'PCG15-PYME-AD', 'FINANCER', 541, 34221, 'Crèdits i valors representatius de deute a curt termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34224, 'PCG15-PYME-AD', 'FINANCER', 543, 34221, 'Crèdits a curt termini per alienació d’immobilitzat', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34225, 'PCG15-PYME-AD', 'FINANCER', 544, 34221, 'Crèdits a curt termini al personal', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34226, 'PCG15-PYME-AD', 'FINANCER', 545, 34221, 'Dividend a cobrar', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34227, 'PCG15-PYME-AD', 'FINANCER', 546, 34221, 'Interessos a curt termini de crèdits i valors representatius de deutes', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34228, 'PCG15-PYME-AD', 'FINANCER', 548, 34221, 'Imposicions a curt termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34229, 'PCG15-PYME-AD', 'FINANCER', 55, 34005, 'ALTRES COMPTES NO BANCARIS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34230, 'PCG15-PYME-AD', 'FINANCER', 550, 34229, 'Titular de l’explotació', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34231, 'PCG15-PYME-AD', 'FINANCER', 551, 34229, 'Compte corrent amb socis i administradors', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34232, 'PCG15-PYME-AD', 'FINANCER', 552, 34229, 'Compte corrent amb altres persones i entitats vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34233, 'PCG15-PYME-AD', 'FINANCER', 554, 34229, 'Compte corrent amb unions temporals d’empreses i comunitats de béns', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34234, 'PCG15-PYME-AD', 'FINANCER', 555, 34229, 'Partides pendents d’aplicació', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34235, 'PCG15-PYME-AD', 'FINANCER', 556, 34229, 'Desemborsaments exigits sobre participacions en el patrimoni net', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34236, 'PCG15-PYME-AD', 'FINANCER', 557, 34229, 'Dividend actiu a compte', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34237, 'PCG15-PYME-AD', 'FINANCER', 56, 34005, 'FIANCES I DIPÒSITS REBUTS I CONSTITUÏTS A CURT TERMINI I AJUSTOS PER PERIODIFICACIÓ', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34238, 'PCG15-PYME-AD', 'FINANCER', 560, 34237, 'Fiances rebudes a curt termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34239, 'PCG15-PYME-AD', 'FINANCER', 561, 34237, 'Dipòsits rebuts a curt termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34240, 'PCG15-PYME-AD', 'FINANCER', 565, 34237, 'Fiances constituïdes a curt termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34241, 'PCG15-PYME-AD', 'FINANCER', 566, 34237, 'Dipòsits constituïts a curt termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34242, 'PCG15-PYME-AD', 'FINANCER', 567, 34237, 'Interessos pagats per anticipat', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34243, 'PCG15-PYME-AD', 'FINANCER', 568, 34237, 'Interessos cobrats per anticipat', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34244, 'PCG15-PYME-AD', 'FINANCER', 569, 34237, 'Garanties financeres a curt termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34245, 'PCG15-PYME-AD', 'FINANCER', 57, 34005, 'TRESORERIA', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34246, 'PCG15-PYME-AD', 'FINANCER', 570, 34245, 'Caixa, euros', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34247, 'PCG15-PYME-AD', 'FINANCER', 571, 34245, 'Caixa, moneda estrangera', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34248, 'PCG15-PYME-AD', 'FINANCER', 572, 34245, 'Bancs i institucions de crèdit c/c vista, euros', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34249, 'PCG15-PYME-AD', 'FINANCER', 573, 34245, 'Bancs i institucions de crèdit c/c vista, moneda estrangera', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34250, 'PCG15-PYME-AD', 'FINANCER', 574, 34245, 'Bancs i institucions de crèdit, comptes d’estalvi, euros', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34251, 'PCG15-PYME-AD', 'FINANCER', 575, 34245, 'Bancs i institucions de crèdit, comptes d’estalvi, moneda estrangera', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34252, 'PCG15-PYME-AD', 'FINANCER', 576, 34245, 'Inversions a curt termini de gran liquiditat', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34253, 'PCG15-PYME-AD', 'FINANCER', 58, 34005, 'ACTIUS NO CORRENTS MANTINGUTS PER A LA VENDA I ACTIUS I PASSIUS ASSOCIATS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34254, 'PCG15-PYME-AD', 'FINANCER', 580, 34253, 'Immobilitzat', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34255, 'PCG15-PYME-AD', 'FINANCER', 581, 34253, 'Inversions amb persones i entitats vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34256, 'PCG15-PYME-AD', 'FINANCER', 582, 34253, 'Inversions financeres', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34257, 'PCG15-PYME-AD', 'FINANCER', 583, 34253, 'Existències, deutors comercials i altres comptes a cobrar', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34258, 'PCG15-PYME-AD', 'FINANCER', 584, 34253, 'Altres actius', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34259, 'PCG15-PYME-AD', 'FINANCER', 585, 34253, 'Provisions', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34260, 'PCG15-PYME-AD', 'FINANCER', 586, 34253, 'Deutes amb característiques especials', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34261, 'PCG15-PYME-AD', 'FINANCER', 587, 34253, 'Deutes amb persones i entitats vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34262, 'PCG15-PYME-AD', 'FINANCER', 588, 34253, 'Creditors comercials i altres comptes a pagar', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34263, 'PCG15-PYME-AD', 'FINANCER', 589, 34253, 'Altres passius', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34264, 'PCG15-PYME-AD', 'FINANCER', 59, 34005, 'DETERIORAMENT DEL VALOR D’INVERSIONS FINANCERES A CURT TERMINI I D’ACTIUS NO CORRENTS MANTINGUTS PER A LA VENDA', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34265, 'PCG15-PYME-AD', 'FINANCER', 593, 34264, 'Deteriorament de valor de participacions a curt termini en parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34266, 'PCG15-PYME-AD', 'FINANCER', 594, 34264, 'Deteriorament de valor de valors representatius de deute a curt termini de parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34267, 'PCG15-PYME-AD', 'FINANCER', 595, 34264, 'Deteriorament de valor de crèdits a curt termini en parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34268, 'PCG15-PYME-AD', 'FINANCER', 597, 34264, 'Deteriorament de valor de valors representatius de deute a curt termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34269, 'PCG15-PYME-AD', 'FINANCER', 598, 34264, 'Deteriorament de valor de crèdits a curt termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34270, 'PCG15-PYME-AD', 'FINANCER', 599, 34264, 'Deteriorament de valor d’actius no corrents mantinguts per a la venda', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34271, 'PCG15-PYME-AD', 'DESPESA', 60, 34006, 'COMPRES', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34272, 'PCG15-PYME-AD', 'DESPESA', 600, 34271, 'Compres de mercaderies', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34273, 'PCG15-PYME-AD', 'DESPESA', 601, 34271, 'Compres de matèries primeres', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34274, 'PCG15-PYME-AD', 'DESPESA', 602, 34271, 'Compres d’altres aprovisionaments', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34275, 'PCG15-PYME-AD', 'DESPESA', 606, 34271, 'Descomptes sobre compres per pagament immediat', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34276, 'PCG15-PYME-AD', 'DESPESA', 607, 34271, 'Treballs realitzats per altres empreses', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34277, 'PCG15-PYME-AD', 'DESPESA', 608, 34271, 'Devolucions de compres i operacions similars', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34278, 'PCG15-PYME-AD', 'DESPESA', 609, 34271, 'Ràpels per compres', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34279, 'PCG15-PYME-AD', 'DESPESA', 61, 34006, 'VARIACIÓ D’EXISTÈNCIES', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34280, 'PCG15-PYME-AD', 'DESPESA', 610, 34279, 'Variació d’existències de mercaderies', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34281, 'PCG15-PYME-AD', 'DESPESA', 611, 34279, 'Variació d’existències de matèries primeres', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34282, 'PCG15-PYME-AD', 'DESPESA', 612, 34279, 'Variació d’existències d’altres aprovisionaments', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34283, 'PCG15-PYME-AD', 'DESPESA', 62, 34006, 'SERVEIS EXTERNS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34284, 'PCG15-PYME-AD', 'DESPESA', 620, 34283, 'Despeses en investigació i desenvolupament de l’exercici', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34285, 'PCG15-PYME-AD', 'DESPESA', 621, 34283, 'Arrendaments i cànons', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34286, 'PCG15-PYME-AD', 'DESPESA', 622, 34283, 'Reparacions i conservació', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34287, 'PCG15-PYME-AD', 'DESPESA', 623, 34283, 'Serveis de professionals independents', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34288, 'PCG15-PYME-AD', 'DESPESA', 624, 34283, 'Transports', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34289, 'PCG15-PYME-AD', 'DESPESA', 625, 34283, 'Primes d’assegurances', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34290, 'PCG15-PYME-AD', 'DESPESA', 626, 34283, 'Serveis bancaris i similars', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34291, 'PCG15-PYME-AD', 'DESPESA', 627, 34283, 'Publicitat, propaganda i relacions públiques', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34292, 'PCG15-PYME-AD', 'DESPESA', 628, 34283, 'Subministraments', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34293, 'PCG15-PYME-AD', 'DESPESA', 629, 34283, 'Altres serveis', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34294, 'PCG15-PYME-AD', 'DESPESA', 63, 34006, 'TRIBUTS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34295, 'PCG15-PYME-AD', 'DESPESA', 631, 34294, 'Altres tributs', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34296, 'PCG15-PYME-AD', 'DESPESA', 64, 34006, 'DESPESES DE PERSONAL', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34297, 'PCG15-PYME-AD', 'DESPESA', 640, 34296, 'Sous i salaris', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34298, 'PCG15-PYME-AD', 'DESPESA', 641, 34296, 'Indemnitzacions', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34299, 'PCG15-PYME-AD', 'DESPESA', 642, 34296, 'Caixa Andorrana de Seguretat Social a càrrec de l’empresari', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34300, 'PCG15-PYME-AD', 'DESPESA', 643, 34296, 'Retribucions a llarg termini mitjançant sistemes d’aportació definida', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34301, 'PCG15-PYME-AD', 'DESPESA', 649, 34296, 'Altres despeses socials', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34302, 'PCG15-PYME-AD', 'DESPESA', 65, 34006, 'ALTRES DESPESES DE GESTIÓ', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34303, 'PCG15-PYME-AD', 'DESPESA', 650, 34302, 'Pèrdues de crèdits comercials incobrables', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34304, 'PCG15-PYME-AD', 'DESPESA', 659, 34302, 'Altres pèrdues de gestió corrent', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34305, 'PCG15-PYME-AD', 'DESPESA', 66, 34006, 'DESPESES FINANCERES', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34306, 'PCG15-PYME-AD', 'DESPESA', 660, 34305, 'Despeses financeres per actualització de provisions', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34307, 'PCG15-PYME-AD', 'DESPESA', 661, 34305, 'Interessos d’obligacions i bons', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34308, 'PCG15-PYME-AD', 'DESPESA', 662, 34305, 'Interessos de deutes', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34309, 'PCG15-PYME-AD', 'DESPESA', 663, 34305, 'Pèrdues per venda, venciment o valoració d’instruments financers pel seu valor raonable', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34310, 'PCG15-PYME-AD', 'DESPESA', 664, 34305, 'Despeses per dividends d’accions o participacions considerades passius financers', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34311, 'PCG15-PYME-AD', 'DESPESA', 665, 34305, 'Interessos per descompte d’efectes i operacions de “factoring”', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34312, 'PCG15-PYME-AD', 'DESPESA', 666, 34305, 'Pèrdues en participacions i valors representatius de deute', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34313, 'PCG15-PYME-AD', 'DESPESA', 667, 34305, 'Pèrdues de crèdits no comercials', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34314, 'PCG15-PYME-AD', 'DESPESA', 668, 34305, 'Diferències negatives de canvi', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34315, 'PCG15-PYME-AD', 'DESPESA', 669, 34305, 'Altres despeses financeres', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34316, 'PCG15-PYME-AD', 'DESPESA', 67, 34006, 'PÈRDUES PROCEDENTS D’ACTIUS NO CORRENTS I DESPESES EXCEPCIONALS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34317, 'PCG15-PYME-AD', 'DESPESA', 670, 34316, 'Pèrdues procedents de l’immobilitzat intangible', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34318, 'PCG15-PYME-AD', 'DESPESA', 671, 34316, 'Pèrdues procedents de l’immobilitzat tangible', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34319, 'PCG15-PYME-AD', 'DESPESA', 672, 34316, 'Pèrdues procedents de les inversions immobiliàries', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34320, 'PCG15-PYME-AD', 'DESPESA', 673, 34316, 'Pèrdues procedents de participacions a llarg termini en parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34321, 'PCG15-PYME-AD', 'DESPESA', 675, 34316, 'Pèrdues per operacions amb obligacions pròpies', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34322, 'PCG15-PYME-AD', 'DESPESA', 678, 34316, 'Despeses excepcionals', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34323, 'PCG15-PYME-AD', 'DESPESA', 68, 34006, 'DOTACIONS PER AMORTITZACIONS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34324, 'PCG15-PYME-AD', 'DESPESA', 680, 34323, 'Amortització de l’immobilitzat intangible', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34325, 'PCG15-PYME-AD', 'DESPESA', 681, 34323, 'Amortització de l’immobilitzat tangible', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34326, 'PCG15-PYME-AD', 'DESPESA', 682, 34323, 'Amortització de les inversions immobiliàries', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34327, 'PCG15-PYME-AD', 'DESPESA', 69, 34006, 'PÈRDUES PER DETERIORAMENT I ALTRES DOTACIONS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34328, 'PCG15-PYME-AD', 'DESPESA', 690, 34327, 'Pèrdues per deteriorament de l’immobilitzat intangible', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34329, 'PCG15-PYME-AD', 'DESPESA', 691, 34327, 'Pèrdues per deteriorament de l’immobilitzat tangible', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34330, 'PCG15-PYME-AD', 'DESPESA', 692, 34327, 'Pèrdues per deteriorament de les inversions immobiliàries', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34331, 'PCG15-PYME-AD', 'DESPESA', 693, 34327, 'Pèrdues per deteriorament d’existències', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34332, 'PCG15-PYME-AD', 'DESPESA', 694, 34327, 'Pèrdues per deteriorament de crèdits per operacions comercials', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34333, 'PCG15-PYME-AD', 'DESPESA', 695, 34327, 'Dotació a la provisió per operacions comercials', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34334, 'PCG15-PYME-AD', 'DESPESA', 696, 34327, 'Pèrdues per deteriorament de participacions i valors representatius de deute a llarg termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34335, 'PCG15-PYME-AD', 'DESPESA', 697, 34327, 'Pèrdues per deteriorament de crèdits a llarg termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34336, 'PCG15-PYME-AD', 'DESPESA', 698, 34327, 'Pèrdues per deteriorament de participacions i valors representatius de deute a curt termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34337, 'PCG15-PYME-AD', 'DESPESA', 699, 34327, 'Pèrdues per deteriorament de crèdits a curt termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34338, 'PCG15-PYME-AD', 'INGRES', 70, 34007, 'VENDES DE MERCADERIES, DE PRODUCCIÓ PRÒPIA, DE SERVEIS, ETC.', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34339, 'PCG15-PYME-AD', 'INGRES', 700, 34338, 'Vendes de mercaderies', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34340, 'PCG15-PYME-AD', 'INGRES', 701, 34338, 'Vendes de productes acabats', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34341, 'PCG15-PYME-AD', 'INGRES', 702, 34338, 'Vendes de productes semiacabats', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34342, 'PCG15-PYME-AD', 'INGRES', 703, 34338, 'Vendes de subproductes i residus', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34343, 'PCG15-PYME-AD', 'INGRES', 704, 34338, 'Vendes d’envasos i embalatges', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34344, 'PCG15-PYME-AD', 'INGRES', 705, 34338, 'Prestació de serveis', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34345, 'PCG15-PYME-AD', 'INGRES', 706, 34338, 'Descompte sobre vendes per pagament immediat', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34346, 'PCG15-PYME-AD', 'INGRES', 708, 34338, 'Devolucions de vendes i operacions similars', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34347, 'PCG15-PYME-AD', 'INGRES', 709, 34338, 'Ràpels sobre vendes', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34348, 'PCG15-PYME-AD', 'INGRES', 71, 34007, 'VARIACIÓ D’EXISTÈNCIES', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34349, 'PCG15-PYME-AD', 'INGRES', 710, 34348, 'Variació d’existències de productes en curs', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34350, 'PCG15-PYME-AD', 'INGRES', 711, 34348, 'Variació d’existències de productes semiacabats', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34351, 'PCG15-PYME-AD', 'INGRES', 712, 34348, 'Variació d’existències de productes acabats', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34352, 'PCG15-PYME-AD', 'INGRES', 713, 34348, 'Variació d’existències de subproductes, residus i materials recuperats', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34353, 'PCG15-PYME-AD', 'INGRES', 73, 34007, 'TREBALLS REALITZATS PER L’EMPRESARI', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34354, 'PCG15-PYME-AD', 'INGRES', 730, 34353, 'Treballs realitzats per a l’immobilitzat intangible', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34355, 'PCG15-PYME-AD', 'INGRES', 731, 34353, 'Treballs realitzats per a l’immobilitzat tangible', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34356, 'PCG15-PYME-AD', 'INGRES', 732, 34353, 'Treballs realitzats en inversions immobiliàries', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34357, 'PCG15-PYME-AD', 'INGRES', 733, 34353, 'Treballs realitzats per a l’immobilitzat tangible en curs', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34358, 'PCG15-PYME-AD', 'INGRES', 74, 34007, 'SUBVENCIONS, DONACIONS I LLEGATS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34359, 'PCG15-PYME-AD', 'INGRES', 740, 34358, 'Subvencions, donacions i llegats a l’explotació', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34360, 'PCG15-PYME-AD', 'INGRES', 746, 34358, 'Subvencions, donacions i llegats de capital transferits al resultat de l’exercici', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34361, 'PCG15-PYME-AD', 'INGRES', 747, 34358, 'Altres subvencions, donacions i llegats transferits al resultat de l’exercici', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34362, 'PCG15-PYME-AD', 'INGRES', 75, 34007, 'ALTRES INGRESSOS DE GESTIÓ', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34363, 'PCG15-PYME-AD', 'INGRES', 752, 34362, 'Ingressos per arrendaments', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34364, 'PCG15-PYME-AD', 'INGRES', 753, 34362, 'Ingressos de propietat industrial cedida en explotació', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34365, 'PCG15-PYME-AD', 'INGRES', 754, 34362, 'Ingressos per comissions', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34366, 'PCG15-PYME-AD', 'INGRES', 755, 34362, 'Ingressos per serveis al personal', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34367, 'PCG15-PYME-AD', 'INGRES', 759, 34362, 'Ingressos per serveis diversos', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34368, 'PCG15-PYME-AD', 'INGRES', 76, 34007, 'INGRESSOS FINANCERS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34369, 'PCG15-PYME-AD', 'INGRES', 760, 34368, 'Ingressos de participacions en instruments de patrimoni', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34370, 'PCG15-PYME-AD', 'INGRES', 761, 34368, 'Interessos de valors representatius de deute', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34371, 'PCG15-PYME-AD', 'INGRES', 762, 34368, 'Interessos de crèdits', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34372, 'PCG15-PYME-AD', 'INGRES', 763, 34368, 'Beneficis per venda, venciment o valoració d’instruments financers pel seu valor raonable', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34373, 'PCG15-PYME-AD', 'INGRES', 766, 34368, 'Beneficis en participacions i valors representatius de deute', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34374, 'PCG15-PYME-AD', 'INGRES', 768, 34368, 'Diferències positives de canvi', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34375, 'PCG15-PYME-AD', 'INGRES', 769, 34368, 'Altres ingressos financers', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34376, 'PCG15-PYME-AD', 'INGRES', 77, 34007, 'BENEFICIS PROCEDENTS D’ACTIUS NO CORRENTS I INGRESSOS EXCEPCIONALS', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34377, 'PCG15-PYME-AD', 'INGRES', 770, 34376, 'Beneficis procedents de l’immobilitzat intangible', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34378, 'PCG15-PYME-AD', 'INGRES', 771, 34376, 'Beneficis procedents de l’immobilitzat tangible', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34379, 'PCG15-PYME-AD', 'INGRES', 772, 34376, 'Beneficis procedents de les inversions immobiliàries', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34380, 'PCG15-PYME-AD', 'INGRES', 773, 34376, 'Beneficis procedents de participacions a llarg termini en parts vinculades', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34381, 'PCG15-PYME-AD', 'INGRES', 775, 34376, 'Beneficis per operacions amb obligacions pròpies', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34382, 'PCG15-PYME-AD', 'INGRES', 778, 34376, 'Ingressos excepcionals', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34383, 'PCG15-PYME-AD', 'INGRES', 79, 34007, 'EXCÉS I APLICACIONS DE PROVISIONS I DE PÈRDUES PER DETERIORAMENT', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34384, 'PCG15-PYME-AD', 'INGRES', 790, 34383, 'Reversió del deteriorament de l’immobilitzat intangible', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34385, 'PCG15-PYME-AD', 'INGRES', 791, 34383, 'Reversió del deteriorament de l’immobilitzat tangible', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34386, 'PCG15-PYME-AD', 'INGRES', 792, 34383, 'Reversió del deteriorament de les inversions immobiliàries', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34387, 'PCG15-PYME-AD', 'INGRES', 793, 34383, 'Reversió del deteriorament d’existències', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34388, 'PCG15-PYME-AD', 'INGRES', 794, 34383, 'Reversió del deteriorament de crèdits per operacions comercials', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34389, 'PCG15-PYME-AD', 'INGRES', 795, 34383, 'Excés de provisions', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34390, 'PCG15-PYME-AD', 'INGRES', 796, 34383, 'Reversió del deteriorament de participacions i valors representatius de deute a llarg termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34391, 'PCG15-PYME-AD', 'INGRES', 797, 34383, 'Reversió del deteriorament de crèdits a llarg termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34392, 'PCG15-PYME-AD', 'INGRES', 798, 34383, 'Reversió del deteriorament de participacions i valors representatius de deute a curt termini', 1);
INSERT INTO llx_accounting_account (entity, rowid, fk_pcg_version, pcg_type, account_number, account_parent, label, active) VALUES (__ENTITY__, 34393, 'PCG15-PYME-AD', 'INGRES', 799, 34383, 'Reversió del deteriorament de crèdits a curt termini', 1);
