'use strict';dotclear.data=dotclear.getData('dotclear_init');if(typeof dotclear.data.htmlFontSize!=='undefined'){document.documentElement.style.setProperty('--html-font-size',dotclear.data.htmlFontSize);}
if(typeof dotclear.data.systemFont!=='undefined'){document.documentElement.style.setProperty('--dc-font','dotclear');}
dotclear.data.theme='light';if(['light','dark'].includes(document.documentElement.getAttribute('data-theme'))){dotclear.data.theme=document.documentElement.getAttribute('data-theme');}else if(window?.matchMedia('(prefers-color-scheme: dark)').matches){dotclear.data.theme='dark';}
dotclear.data.lowdata=false;if(window?.matchMedia('(prefers-reduced-data: reduce)').matches){dotclear.data.lowdata=true;}
document.documentElement.style.setProperty('--dark-mode',dotclear.data.theme==='dark'?'1':'0');dotclear.jQueryNodes=(elt)=>{if(elt instanceof jQuery)return elt;if(elt instanceof NodeList)return jQuery(Array.from(elt));if(typeof elt==='string'||elt instanceof Element)return jQuery(elt);return jQuery();};dotclear.nodes=(elt)=>{if(elt instanceof NodeList)return elt;if(Array.isArray(elt))return elt;if(typeof elt==='string')return document.querySelectorAll(elt);if(elt instanceof Element)return[elt];if(elt instanceof jQuery)return elt.get();return[];};dotclear.node=(elt)=>{const list=dotclear.nodes(elt);return list.length?list[0]:null;};dotclear.htmlToNodes=(html)=>{const template=document.createElement('template');template.innerHTML=html;return template.content.childNodes;};dotclear.htmlToNode=(html)=>{const list=dotclear.htmlToNodes(html);return list.length?list[0]:null;};dotclear.acceptsKeyboardInput=(element)=>{const nonTypingInputTypes=new Set(['checkbox','radio','button','reset','submit','file']);return((element.tagName==='INPUT'&&!nonTypingInputTypes.has(element.type))||element.tagName==='TEXTAREA'||element.tagName==='SELECT'||element.tagName==='BUTTON'||element.isContentEditable);};dotclear.confirm=(message,event=null)=>{if(window.confirm(message))return true;event?.preventDefault();event?.stopPropagation();return false;};dotclear.expandContent=(opts)=>{const toggleArrow=(button,actionRequested='')=>{const actionDone=actionRequested||(button.getAttribute('aria-label')===dotclear.img_plus_alt?'open':'close');if(actionDone==='open'&&button.getAttribute('aria-expanded')==='false'){button.firstChild.data=dotclear.img_minus_txt;button.setAttribute('value',dotclear.img_minus_txt);button.setAttribute('aria-label',dotclear.img_minus_alt);button.setAttribute('aria-expanded',true);}else if(actionDone==='close'&&button.getAttribute('aria-expanded')==='true'){button.firstChild.data=dotclear.img_plus_txt;button.setAttribute('value',dotclear.img_plus_txt);button.setAttribute('aria-label',dotclear.img_plus_alt);button.setAttribute('aria-expanded',false);}else{return'';}
return actionDone;};const singleExpander=(line,callback)=>{const elt=dotclear.node(line);if(!elt){return;}
const button=dotclear.htmlToNode(`<button type="button" class="details-cmd" aria-expanded="false" aria-label="${dotclear.img_plus_alt}">${dotclear.img_plus_txt}</button>`,);button.addEventListener('click',(event)=>{if(toggleArrow(button)!=='')callback(elt,'',event);event.preventDefault();});const td=line.firstChild;if(td)td.prepend(button);};const multipleExpander=(line,lines,callback)=>{const elt=dotclear.node(line);if(elt){const list=dotclear.nodes(lines);if(list.length){const button=dotclear.htmlToNode(`<button type="button" class="details-cmd" aria-expanded="false" aria-label="${dotclear.img_plus_alt}">${dotclear.img_plus_txt}</button>`,);button.addEventListener('click',(event)=>{const action=toggleArrow(button);for(const item of list){if(toggleArrow(item.firstChild.firstChild,action)!=='')callback(item,action,event);}
event.preventDefault();});const td=line.firstChild;if(td)td.prepend(button);}}};if(opts===undefined||opts.callback===undefined||typeof opts.callback!=='function'){return;}
if(opts.line!==undefined){multipleExpander(opts.line,opts.lines,opts.callback);}
for(const line of opts.lines){singleExpander(line,opts.callback);}};dotclear.toggleWithLegend=(target,childs,options)=>{const defaults={img_on_txt:dotclear.img_plus_txt,img_on_alt:dotclear.img_plus_alt,img_off_txt:dotclear.img_minus_txt,img_off_alt:dotclear.img_minus_alt,unfolded_sections:dotclear.unfolded_sections,hide:true,legend_click:false,fn:false,user_pref:false,reverse_user_pref:false,};const parameters=Object.assign(defaults,options);if(!childs?.length){return;}
const set_user_pref=parameters.hide^parameters.reverse_user_pref;if(parameters.user_pref&&parameters.unfolded_sections!==undefined&&parameters.user_pref in parameters.unfolded_sections){parameters.hide=parameters.reverse_user_pref;}
const toggle=(elt)=>{if(parameters.hide){elt.firstChild.data=parameters.img_on_txt;elt.setAttribute('value',parameters.img_on_txt);elt.setAttribute('aria-label',parameters.img_on_alt);elt.setAttribute('aria-expanded',false);for(const child of childs)child.classList.add('hide');}else{elt.firstChild.data=parameters.img_off_txt;elt.setAttribute('value',parameters.img_off_txt);elt.setAttribute('aria-label',parameters.img_off_alt);elt.setAttribute('aria-expanded',true);for(const child of childs)child.classList.remove('hide');if(parameters.fn){for(const child of childs)parameters.fn.apply(child);parameters.fn=false;}}
parameters.hide=!parameters.hide;};const button=dotclear.htmlToNode(`<button type="button" class="details-cmd" value="${parameters.img_on_txt}" aria-label="${parameters.img_on_alt}">${parameters.img_on_txt}</button>`,);const ctarget=parameters.legend_click?target:button;target.style.cursor='pointer';if(parameters.legend_click){const label=ctarget.querySelector('label');if(label)label.style.cursor='pointer';}
target.addEventListener('click',(e)=>{if(e.target!==target&&e.target!==button)return;if(parameters.user_pref&&set_user_pref){dotclear.jsonServicesPost('setSectionFold',()=>{},{section:parameters.user_pref,value:parameters.hide^parameters.reverse_user_pref?1:0,});}
toggle(button);e.preventDefault();return false;});toggle(button);target.prepend(button);};dotclear.toggleWithDetails=(target,options)=>{const defaults={unfolded_sections:dotclear.unfolded_sections,hide:true,fn:false,user_pref:false,reverse_user_pref:false,};const parameters=Object.assign(defaults,options);if(parameters.user_pref&&parameters.unfolded_sections!==undefined&&parameters.user_pref in parameters.unfolded_sections){parameters.hide=parameters.reverse_user_pref;}
const toggle=()=>{if(!parameters.hide&&parameters.fn){parameters.fn.apply(target);parameters.fn=false;}
parameters.hide=!parameters.hide;if(parameters.hide&&target.getAttribute('open')){target.removeAttribute('open');}else if(!parameters.hide&&!target.getAttribute('open')){target.setAttribute('open','open');}};target.addEventListener('click',(e)=>{const summary=target.querySelector('summary');if(e.target!==summary)return;if(parameters.user_pref){dotclear.jsonServicesPost('setSectionFold',()=>{},{section:parameters.user_pref,value:parameters.hide^parameters.reverse_user_pref?1:0,});}
toggle();e.preventDefault();return false;});toggle();};dotclear.helpViewer=(selector)=>{const helpBox=document.querySelector(selector);if(!helpBox)return;const p={img_on_txt:dotclear.img_plus_txt,img_on_alt:dotclear.img_plus_alt,img_off_txt:dotclear.img_minus_txt,img_off_alt:dotclear.img_minus_alt,};const helpButtonTemplate=dotclear.htmlToNode(`<p id="help-button"><span><a href="">${dotclear.msg.help}</a></span></p>`);const chapterButtonTemplate=dotclear.htmlToNode(`<button type="button" class="details-cmd" aria-label="${p.img_on_alt}">${p.img_on_txt}</button>`,);const toggle=()=>{const content=document.getElementById('content');if(content){content.classList.toggle('with-help');document.querySelector('p#help-button span a').innerText=content.classList.contains('with-help')?dotclear.msg.help_hide:dotclear.msg.help;positionButton();}
sizeBox();return false;};const sizeBox=()=>{const wrapper=document.getElementById('wrapper');helpBox.style.height='auto';if(wrapper&&wrapper.getBoundingClientRect().height>helpBox.getBoundingClientRect().height)
helpBox.style.height=`${wrapper.getBoundingClientRect().height}px`;};const chapterToggler=(chapterTitle)=>{const button=chapterButtonTemplate.cloneNode(true);let hide=true;chapterTitle.style.cursor='pointer';chapterTitle.prepend(button);chapterTitle.addEventListener('click',function(){const nextSiblings=[];let nextSibling=this.nextElementSibling;while(nextSibling){nextSiblings.push(nextSibling);nextSibling=nextSibling.nextElementSibling;}
for(const sibling of nextSiblings){if(sibling.tagName.toLowerCase()==='h4'){break;}
sibling.style.display=sibling.style.display==='none'?'':'none';sizeBox();}
hide=!hide;const chapterButton=chapterTitle.querySelector('button.details-cmd');if(hide){chapterButton.innerHTML=p.img_on_txt;chapterButton.setAttribute('value',p.img_on_txt);chapterButton.setAttribute('aria-label',p.img_on_alt);return;}
chapterButton.innerHTML=p.img_off_txt;chapterButton.setAttribute('value',p.img_off_txt);chapterButton.setAttribute('aria-label',p.img_off_alt);});};helpBox.classList.add('help-box');for(const element of helpBox.querySelectorAll(':scope >hr')){element.remove();}
for(const chapter of helpBox.querySelectorAll(':scope h4')){chapterToggler(chapter);}
const firstH4=helpBox.querySelector('h4');if(firstH4){let nextSibling=firstH4.nextElementSibling;while(nextSibling){if(nextSibling.tagName.toLowerCase()!=='h4'){nextSibling.style.display='none';}
nextSibling=nextSibling.nextElementSibling;}}
sizeBox();const helpButton=helpButtonTemplate.cloneNode(true);helpButton.addEventListener('click',(event)=>{event.preventDefault();return toggle();});document.getElementById('content')?.append(helpButton);const helpButtonElement=document.getElementById('help-button');if(!helpButtonElement){return;}
const positionButton=()=>{if(helpButtonElement.classList.contains('floatable')){helpButtonElement.style.top='0';return;}
const bodyRect=document.body.getBoundingClientRect();const elemRect=helpBox.getBoundingClientRect();const offset=elemRect.top-bodyRect.top;helpButtonElement.style.top=`${offset}px`;};const headerTarget=document.querySelector('#header');if(headerTarget){const headerObserver=new IntersectionObserver((changes)=>{for(const change of changes){if(change.isIntersecting){helpButtonElement.classList.remove('floatable');}else{helpButtonElement.classList.add('floatable');}
positionButton();}},{threshold:[1.0],trackVisibility:true,delay:100,},);headerObserver.observe(headerTarget);}};dotclear.enableShiftClick=(selector)=>{const checkboxes=document.querySelectorAll(selector);let lastChecked;const handleCheck=(event)=>{let inBetween=false;if(event.shiftKey){for(const checkbox of checkboxes){if(checkbox===event.currentTarget||checkbox===lastChecked){inBetween=!inBetween;}
if(inBetween){checkbox.checked=event.currentTarget.checked;}}}else if(event.altKey){for(const checkbox of checkboxes){checkbox.checked=!checkbox.checked;}
event.currentTarget.checked=!event.currentTarget.checked;}
lastChecked=event.currentTarget;};for(const checkbox of checkboxes)checkbox.addEventListener('click',handleCheck);};dotclear.enterKeyInForm=(frm_id,ok_id,cancel_id)=>{const submitElement=document.querySelector(ok_id);if(submitElement){document.querySelector(`${frm_id} :not(${cancel_id})`)?.addEventListener('keyup',(event)=>{if(event.key!=='Enter'||submitElement.disabled)return;event.preventDefault();event.stopPropagation();submitElement.click();});}};dotclear.condSubmit=(chkboxes,target,reset=false)=>{const checkboxes=Array.from(document.querySelectorAll(chkboxes));const submitButt=document.querySelector(target);if(checkboxes.length===0||submitButt===null){return;}
const setButtonState=()=>{submitButt.disabled=!checkboxes.some((checkbox)=>checkbox.checked);if(submitButt.disabled){submitButt.classList.add('disabled');}else{submitButt.classList.remove('disabled');}};setButtonState();for(const checkbox of checkboxes){if(reset){checkbox.removeEventListener('change',setButtonState);}
checkbox.addEventListener('change',setButtonState);}};dotclear.hideLockable=()=>{const lockableDivs=document.querySelectorAll('div.lockable');for(const lockableDiv of lockableDivs){const formNotes=lockableDiv.querySelectorAll('p.form-note');for(const formNote of formNotes)formNote.style.display='none';const inputs=lockableDiv.querySelectorAll('input, textarea');for(const input of inputs){const position=input.tagName==='TEXTAREA'?'right: 4px':`left: ${input.offsetWidth - 24}px`;const button=dotclear.htmlToNode(`<button type="button" style="position: absolute; ${position}; top: ${input.tagName === 'TEXTAREA' ? '4px' : '1.6em'}; border: none; background: transparent; padding: 0; margin: 0;"><img src="images/locker.svg" alt="${dotclear.msg.click_to_unlock}" style="width: 1.4em" class="mark mark-locked"></button>`,);button.addEventListener('click',()=>{button.style.display='none';input.readOnly=false;for(const formNote of formNotes)formNote.style.display='block';});input.readOnly=true;input.parentElement.style.position='relative';input.before(button);}}};dotclear.toggleCheck=(target)=>{for(const item of dotclear.nodes(target)){if(item?.checked!==undefined){item.checked=!item.checked;}}};dotclear.setChecked=(target,status)=>{for(const item of dotclear.nodes(target)){if(item?.checked!==undefined){item.checked=status;}}};dotclear.unCheck=(target)=>dotclear.setChecked(target,false);dotclear.check=(target)=>dotclear.setChecked(target,true);dotclear.checkboxesHelpers=(area,target,checkboxes,submit)=>{const form=area.closest('form');if(!form)return;const btn_all=dotclear.htmlToNode(`<button type="button" class="checkbox-helper select-all">${dotclear.msg.select_all}</button>`,);btn_all.addEventListener('click',(event)=>{dotclear.check(target!==undefined?target:form.querySelectorAll('input[type="checkbox"]:not(:disabled)'));if(checkboxes!==undefined&&submit!==undefined){dotclear.condSubmit(checkboxes,submit);}
event.preventDefault();return false;});const btn_none=dotclear.htmlToNode(`<button type="button" class="checkbox-helper select-none">${dotclear.msg.no_selection}</button>`,);btn_none.addEventListener('click',(event)=>{dotclear.unCheck(target!==undefined?target:form.querySelectorAll('input[type="checkbox"]:not(:disabled)'));if(checkboxes!==undefined&&submit!==undefined){dotclear.condSubmit(checkboxes,submit);}
event.preventDefault();return false;});const btn_invert=dotclear.htmlToNode(`<button type="button" class="checkbox-helper select-reverse">${dotclear.msg.invert_sel}</button>`,);btn_invert.addEventListener('click',(event)=>{dotclear.toggleCheck(target!==undefined?target:form.querySelectorAll('input[type="checkbox"]:not(:disabled)'));if(checkboxes!==undefined&&submit!==undefined){dotclear.condSubmit(checkboxes,submit);}
event.preventDefault();return false;});area.classList.add('form-buttons');area.append(document.createTextNode(dotclear.msg.to_select));area.append(btn_all);area.append(btn_none);area.append(btn_invert);};dotclear.postsActionsHelper=()=>{document.getElementById('form-entries')?.addEventListener('submit',function(event){if(this.querySelector('select[name="action"]')?.value==='delete'){const nb=this.querySelectorAll('input[name="entries[]"]:checked')?.length;if(nb){if(window.confirm(dotclear.msg.confirm_delete_posts.replace('%s',nb)))return true;event.preventDefault();return false;}}});};dotclear.commentsActionsHelper=()=>{document.getElementById('form-comments')?.addEventListener('submit',function(event){if(this.querySelector('select[name="action"]')?.value==='delete'){const nb=this.querySelectorAll('input[name="comments[]"]:checked')?.length;if(nb){if(window.confirm(dotclear.msg.confirm_delete_comments.replace('%s',nb)))return true;event.preventDefault();return false;}}});};dotclear.outgoingLinks=(target)=>{const elements=document.querySelectorAll(target);for(const element of elements){if(!((element.hostname&&element.hostname!==location.hostname&&!element.classList.contains('modal')&&!element.classList.contains('modal-image'))||element.classList.contains('outgoing'))){continue;}
element.title=`${element.title} (${dotclear.msg.new_window})`;if(!element.classList.contains('outgoing')){element.innerHTML+='&nbsp;<img class="outgoing-js" src="images/outgoing-link.svg" alt="">';element.classList.add('outgoing');}
element.addEventListener('click',(e)=>{e.preventDefault();window.open(element.href);});}};dotclear.responsiveCellHeaders=(table,selector,offset=0,thead=false)=>{if(table){try{const THarray=[];const ths=table.getElementsByTagName('th');for(const th of ths){for(let colspan=th.colSpan;colspan>0;colspan--){THarray.push(th.innerText.replace('▶',''));}}
const styleElm=document.createElement('style');let styleSheet;document.head.appendChild(styleElm);styleSheet=styleElm.sheet;for(let i=offset;i<THarray.length;i++){if(THarray[i].trim().length)
styleSheet.insertRule(`${selector} td:nth-child(${i + 1})::before {content:"${THarray[i]} ";}`,styleSheet.cssRules.length,);}
table.className+=`${table.className === '' ? '' : ' '}rch${thead ? ' rch-thead' : ''}`;}catch(e){if(dotclear.debug)console.log(`responsiveCellHeaders(): ${e}`);}}};dotclear.badge=(elt,options=null)=>{const target=dotclear.nodes(elt);if(!target.length)return;const opt={sibling:false,id:'default',remove:false,value:null,inline:false,icon:false,type:'',left:false,noborder:false,small:false,classes:'',...options,};const classid=`span.badge.badge-${opt.id}`;for(const item of target){const parent=options.sibling?item.parentNode:item;if(!opt.inline&&!opt.remove&&!parent.classList.contains('badgeable'))parent.classList.add('badgeable');const badge=opt.sibling?parent.querySelector(classid):item.querySelector(classid);if(badge)badge.remove();}
if(!(!opt.remove&&opt.value!==null))return;const classes=['badge'];classes.push(`badge-${opt.id}`);classes.push(opt.inline?'badge-inline':'badge-block');if(opt.icon)classes.push('badge-icon');if(opt.type)classes.push(`badge-${opt.type}`);if(opt.left)classes.push('badge-left');if(opt.noborder)classes.push('badge-noborder');if(opt.small)classes.push('badge-small');if(opt.classes)classes.push(opt.classes);const template=dotclear.htmlToNode(`<span class="${classes.join(' ')}" aria-hidden="true">${opt.value}</span>`);for(const item of target){const element=template.cloneNode(true);if(opt.sibling)item.after(element);else item.append(element);}};dotclear.passwordHelpers=()=>{const togglePasswordHelper=(e)=>{e.preventDefault();const button=e.currentTarget;const isPasswordShown=button.classList.contains('pw-hide');const buttonContent=isPasswordShown?dotclear.msg.show_password:dotclear.msg.hide_password;button.classList.toggle('pw-hide',!isPasswordShown);button.classList.toggle('pw-show',isPasswordShown);button.previousElementSibling.setAttribute('type',isPasswordShown?'password':'text');button.setAttribute('title',buttonContent);button.setAttribute('aria-label',buttonContent);button.querySelector('span').textContent=buttonContent;};const buttonTemplate=dotclear.htmlToNode(`<button type="button" class="pw-show" title="${dotclear.msg.show_password}" aria-label="${dotclear.msg.show_password}"><span class="sr-only">${dotclear.msg.show_password}</span></button>`,);const passwordFields=document.querySelectorAll('input[type=password]');for(const passwordField of passwordFields){const button=buttonTemplate.cloneNode(true);passwordField.after(button);passwordField.classList.add('pwd_helper');button.addEventListener('click',togglePasswordHelper);}};dotclear.closeNoticeHelper=()=>{for(const btn of document.querySelectorAll('.close-notice:not(.close-notice-listen)')){btn.classList.add('close-notice-listen');btn.addEventListener('click',(e)=>{const parent=e.target.parentNode;if(parent)parent.remove();e.preventDefault();});}};dotclear.servicesOff=dotclear.data.servicesOff||false;dotclear.servicesUri=dotclear.data.servicesUri||'index.php?process=Rest';dotclear.services=(fn,onSuccess=(_data)=>{},onError=(_error)=>{if(dotclear.debug)console.log(_error);},get=true,params={},)=>{if(dotclear.servicesOff)return;const service=new URL(dotclear.servicesUri,window.location.origin+window.location.pathname);dotclear.mergeDeep(params,{f:fn,xd_check:dotclear.nonce});const init={method:get?'GET':'POST'};if(get){const data=new URLSearchParams(service.search);for(const key of Object.keys(params))data.append(key,params[key]);service.search=data.toString();}else{const data=new FormData();for(const key of Object.keys(params))data.append(key,params[key]);init.body=data;}
fetch(service,init).then((promise)=>{if(!promise.ok){throw Error(promise.statusText);}
return promise.text();}).then((response)=>onSuccess(response)).then(()=>dotclear.closeNoticeHelper()).catch((error)=>onError(error));};dotclear.servicesGet=(fn,onSuccess=(_payload)=>{},params={},onError=(_error)=>{if(dotclear.debug)console.log(_error);},)=>{dotclear.services(fn,onSuccess,onError,true,params);};dotclear.servicesPost=(fn,onSuccess=(_payload)=>{},params={},onError=(_error)=>{if(dotclear.debug)console.log(_error);},)=>{dotclear.services(fn,onSuccess,onError,false,params);};dotclear.jsonServices=(fn,onSuccess=(_payload)=>{},onError=(_error)=>{if(dotclear.debug)console.log(_error);},get=true,params={},)=>{params.json=1;dotclear.services(fn,(data)=>{try{const response=JSON.parse(data);if(response?.success){onSuccess(response.payload);}else{const msg=dotclear.debug&&response?.message?response.message:'Dotclear REST server error';if(dotclear.debug)console.log(`jsonServices(): ${msg}`);onError(msg);return;}}catch(error){if(dotclear.debug)console.log(`jsonServices(): ${error}`,fn,data);onError(error);}},(error)=>onError(error),get,params,);};dotclear.jsonServicesGet=(fn,onSuccess=(_payload)=>{},params={},onError=(_error)=>{if(dotclear.debug)console.log(_error);},)=>{dotclear.jsonServices(fn,onSuccess,onError,true,params);};dotclear.jsonServicesPost=(fn,onSuccess=(_payload)=>{},params={},onError=(_error)=>{if(dotclear.debug)console.log(_error);},)=>{dotclear.jsonServices(fn,onSuccess,onError,false,params);};dotclear.debug=dotclear.data.debug||false;Object.assign(dotclear,dotclear.getData('dotclear'));Object.assign(dotclear.msg,dotclear.getData('dotclear_msg'));dotclear.ready(()=>{const body=document.querySelector('body');const header=document.querySelector('#header')?document.querySelector('#header'):document.querySelector('h1');body.classList.add(`${dotclear.data.theme}-mode`);dotclear.data.darkMode=dotclear.data.theme==='dark'?1:0;if(document.documentElement.getAttribute('data-theme')===''){dotclear.theme_OS=window.matchMedia('(prefers-color-scheme: dark)');const switchScheme=(e)=>{const theme=e.matches?'dark':'light';if(theme===dotclear.data.theme){return;}
body.classList.remove(`${dotclear.data.theme}-mode`);dotclear.data.theme=theme;body.classList.add(`${dotclear.data.theme}-mode`);document.documentElement.style.setProperty('--dark-mode',dotclear.data.theme==='dark'?1:0);};try{dotclear.theme_OS.addEventListener('change',(e)=>switchScheme(e));}catch(e){if(dotclear.debug)console.log(`matchMedia/prefers-color-scheme: ${e}`);try{dotclear.theme_OS.addListener((e)=>switchScheme(e));}catch(e){if(dotclear.debug)console.log(`matchMedia/prefers-color-scheme: ${e}`);try{dotclear.theme_OS.onchange((e)=>switchScheme(e));}catch(e){if(dotclear.debug)console.log(`matchMedia/prefers-color-scheme: ${e}`);}}}}
const mediaQuery=window.matchMedia('(prefers-reduced-motion: reduce)');if(mediaQuery){dotclear.animationisReduced=mediaQuery.matches===true;mediaQuery.onchange=(event)=>{dotclear.animationisReduced=event.matches;};}
const observer=new MutationObserver((mutations)=>{for(const mutation of mutations){let theme;if(mutation.target.getAttribute('data-theme')===''){theme=window.matchMedia('(prefers-color-scheme: dark)')?'dark':'light';}else{theme=mutation.target.getAttribute('data-theme');}
body.classList.remove(`${dotclear.data.theme}-mode`);dotclear.data.theme=theme;body.classList.add(`${dotclear.data.theme}-mode`);document.documentElement.style.setProperty('--dark-mode',dotclear.data.theme==='dark'?1:0);}});observer.observe(document.documentElement,{attributeFilter:['data-theme'],});if(dotclear.debug){header.addEventListener('dblclick',(_e)=>{let{theme}=document.documentElement.dataset;if(theme==null||theme===''){theme=window.matchMedia('(prefers-color-scheme: dark)')?'dark':'light';}
document.documentElement.dataset.theme=theme==='dark'?'light':'dark';});}else{}
body.classList.remove('no-js');body.classList.add('with-js');for(const child of body.childNodes){if(child.nodeType!==Node.COMMENT_NODE){continue;}
const data=child.data.replace(/ /g,'&nbsp;').replace(/\n/g,'<br>').replace(/\n/g,'<br>');const dcnet=document.querySelector('#footer a');if(!dcnet){continue;}
const tooltip=dotclear.htmlToNode(`<span class="tooltip" aria-hidden="true">${dcnet.getAttribute('title') || ''}${data}</span>`,);dcnet.append(tooltip);}
dotclear.outgoingLinks('a');document.querySelector('#dotclear-admin.popup')?.addEventListener('keyup',(event)=>{if(event.key!=='Escape'){return;}
event.preventDefault();window.close();return false;});document.getElementById('switchblog')?.addEventListener('change',function(){this.form.submit();});for(const menu of['blog','system','plugins','favorites']){const fav=menu==='favorites';dotclear.toggleWithLegend(document.querySelector(`#${menu}-menu h3`),document.querySelectorAll(`#${menu}-menu ul`),{legend_click:true,user_pref:`dc_${menu}_menu`,hide:!fav,reverse_user_pref:fav,});}
dotclear.helpViewer('#help');dotclear.passwordHelpers();for(const element of document.querySelectorAll('table .maximal')){if(element.offsetWidth<element.scrollWidth&&element.title===''){element.title=element.innerText;element.classList.add('ellipsis');}}
for(const element of document.querySelectorAll('table .maximal.ellipsis a')){if(element.title==='')element.title=element.innerText;}
if(dotclear.data.hideMoreInfo){for(const element of document.querySelectorAll('.more-info,.form-note:not(.warn,.warning)'))
element.classList.add('no-more-info');}
const wrapper=document.getElementById('wrapper');const hideMainMenu='hide_main_menu';if(wrapper){document.getElementById('collapser')?.addEventListener('click',(event)=>{event.preventDefault();if(wrapper.classList.contains('hide-mm')){wrapper.classList.remove('hide-mm');dotclear.dropLocalData(hideMainMenu);return;}
wrapper.classList.add('hide-mm');dotclear.storeLocalData(hideMainMenu,true);});if(dotclear.readLocalData(hideMainMenu)===true){wrapper.classList.add('hide-mm');}else{wrapper.classList.remove('hide-mm');}}
const headerTarget=document.querySelector('#header');if(headerTarget){const gototopButton=document.getElementById('gototop');const headerObserver=new IntersectionObserver((changes)=>{for(const change of changes){gototopButton.style.display=change.isIntersecting?'none':'block';}},{threshold:[1.0],trackVisibility:true,delay:100,},);headerObserver.observe(headerTarget);}
document.getElementById('gototop')?.addEventListener('click',(event)=>{if(dotclear.animationisReduced){document.querySelector('html').scrollTop=0;}else{const scrollToTop=(duration)=>{if(document.scrollingElement.scrollTop===0)return;if(duration===0){document.scrollingElement.scrollTop=0;return;}
const cosParameter=document.scrollingElement.scrollTop / 2;let scrollCount=0;let oldTimestamp=null;const step=(newTimestamp)=>{if(oldTimestamp!==null){scrollCount+=(Math.PI*(newTimestamp-oldTimestamp))/ duration;if(scrollCount>=Math.PI){document.scrollingElement.scrollTop=0;return;}
document.scrollingElement.scrollTop=cosParameter+cosParameter*Math.cos(scrollCount);}
oldTimestamp=newTimestamp;window.requestAnimationFrame(step);};window.requestAnimationFrame(step);};scrollToTop(800);}
event.preventDefault();});const searchinput=document.getElementById('qx');if(searchinput){const quickMenuPrefix=dotclear.data.quickMenuPrefix||':';window.addEventListener('keyup',(event)=>{if(!document.activeElement.nodeName||dotclear.acceptsKeyboardInput(document.activeElement)){return;}
if(event.key!==quickMenuPrefix)return;if(event.altKey||event.ctrlKey||event.metaKey||event.shiftKey||event.isComposing)return;event.preventDefault();searchinput.setAttribute('value',quickMenuPrefix);searchinput.setSelectionRange(1,1);searchinput.focus();});const menuList=document.querySelectorAll('#menulist option');if(menuList){searchinput.addEventListener('change',(event)=>{const found=[...menuList].find((opt)=>opt.value===searchinput.value);if(found){event.preventDefault();searchinput.form?.submit();}});}}
for(const back of document.querySelectorAll('.go-back'))
back.addEventListener('click',()=>{history.back();});const goprev=document.querySelector('.nav_prevnext > .prev');if(goprev){window.addEventListener('keyup',(e)=>{if(!document.activeElement.nodeName||dotclear.acceptsKeyboardInput(document.activeElement)){return;}
if(e.key!=='ArrowLeft')return;if(e.altKey||e.ctrlKey||e.metaKey||e.shiftKey||e.isComposing)return;e.preventDefault();goprev.click();});}
const gonext=document.querySelector('.nav_prevnext > .next');if(gonext){window.addEventListener('keyup',(e)=>{if(!document.activeElement.nodeName||dotclear.acceptsKeyboardInput(document.activeElement)){return;}
if(e.key!=='ArrowRight')return;if(e.altKey||e.ctrlKey||e.metaKey||e.shiftKey||e.isComposing)return;e.preventDefault();gonext.click();});}
dotclear.closeNoticeHelper();});