<?php

/**
 * @file
 * A database agnostic dump for testing purposes.
 *
 * This file was generated by the Drupal 9.2.6 db-tools.php script.
 */

use Drupal\Core\Database\Database;

$connection = Database::getConnection();

$connection->schema()->createTable('scheduler', [
  'fields' => [
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'publish_on' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'unpublish_on' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'nid',
  ],
  'indexes' => [
    'scheduler_publish_on' => [
      'publish_on',
    ],
    'scheduler_unpublish_on' => [
      'unpublish_on',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('scheduler')
  ->fields([
    'nid',
    'publish_on',
    'unpublish_on',
  ])
  ->values([
    'nid' => '1',
    'publish_on' => '1647751855',
    'unpublish_on' => '1647838255',
  ])
  ->values([
    'nid' => '2',
    'publish_on' => '1647579055',
    'unpublish_on' => '0',
  ])
  ->execute();
