<?php

declare(strict_types=1);

namespace Drupal\RecipeKit\Installer;

use Drupal\Core\File\FileSystemInterface;
use Drupal\Core\StringTranslation\Translator\FileTranslation as CoreFileTranslation;

/**
 * Decorates the file-based string translation service to use dynamic prefixing.
 *
 * @internal
 *    Everything in this class is internal, which means it could be changed in
 *    any way, or removed outright, at any time without warning. It is only meant
 *    to be used by profiles that were generated by this kit. You should not use
 *    it in your own code in any way.
 */
final class FileTranslation extends CoreFileTranslation {

  public static function createFromInstance(parent $instance): self {
    return new self(
      $instance->directory,
      \Drupal::service(FileSystemInterface::class),
    );
  }

  /**
   * {@inheritdoc}
   */
  protected function getTranslationFilesPattern($langcode = NULL): string {
    $pattern = parent::getTranslationFilesPattern($langcode);

    if (str_starts_with($pattern, '!drupal-')) {
      $pattern = '![a-zA-Z0-9_]+-' . substr($pattern, 8);
    }
    return $pattern;
  }

}
