
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `easyapmt152`
--

-- --------------------------------------------------------

--
-- Table structure for table `ea_appointments`
--

CREATE TABLE `ea_appointments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_datetime` datetime DEFAULT NULL,
  `update_datetime` datetime DEFAULT NULL,
  `book_datetime` datetime DEFAULT NULL,
  `start_datetime` datetime DEFAULT NULL,
  `end_datetime` datetime DEFAULT NULL,
  `location` text COLLATE utf8mb4_unicode_ci,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `hash` text COLLATE utf8mb4_unicode_ci,
  `color` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT '#7cbae8',
  `status` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `is_unavailability` tinyint(4) NOT NULL DEFAULT '0',
  `id_users_provider` int(11) DEFAULT NULL,
  `id_users_customer` int(11) DEFAULT NULL,
  `id_services` int(11) DEFAULT NULL,
  `id_google_calendar` text COLLATE utf8mb4_unicode_ci,
  `id_caldav_calendar` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `id_users_provider` (`id_users_provider`),
  KEY `id_users_customer` (`id_users_customer`),
  KEY `id_services` (`id_services`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ea_blocked_periods`
--

CREATE TABLE `ea_blocked_periods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_datetime` datetime DEFAULT NULL,
  `update_datetime` datetime DEFAULT NULL,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_datetime` datetime DEFAULT NULL,
  `end_datetime` datetime DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ea_consents`
--

CREATE TABLE `ea_consents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_datetime` datetime DEFAULT NULL,
  `update_datetime` datetime DEFAULT NULL,
  `created` timestamp NULL DEFAULT NULL,
  `modified` timestamp NULL DEFAULT NULL,
  `first_name` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ea_migrations`
--

CREATE TABLE `ea_migrations` (
  `version` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `ea_migrations`
--

INSERT INTO `ea_migrations` VALUES
(60);

-- --------------------------------------------------------

--
-- Table structure for table `ea_roles`
--

CREATE TABLE `ea_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_datetime` datetime DEFAULT NULL,
  `update_datetime` datetime DEFAULT NULL,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_admin` tinyint(4) DEFAULT NULL,
  `appointments` int(11) DEFAULT NULL,
  `customers` int(11) DEFAULT NULL,
  `services` int(11) DEFAULT NULL,
  `users` int(11) DEFAULT NULL,
  `system_settings` int(11) DEFAULT NULL,
  `user_settings` int(11) DEFAULT NULL,
  `webhooks` int(11) DEFAULT NULL,
  `blocked_periods` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `ea_roles`
--

INSERT INTO `ea_roles` VALUES
(1, NULL, NULL, 'Administrator', 'admin', 1, 15, 15, 15, 15, 15, 15, 15, 15),
(2, NULL, NULL, 'Provider', 'provider', 0, 15, 15, 0, 0, 0, 15, 0, 0),
(3, NULL, NULL, 'Customer', 'customer', 0, 0, 0, 0, 0, 0, 0, 0, 0),
(4, NULL, NULL, 'Secretary', 'secretary', 0, 15, 15, 0, 0, 0, 15, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `ea_secretaries_providers`
--

CREATE TABLE `ea_secretaries_providers` (
  `id_users_secretary` int(11) NOT NULL,
  `id_users_provider` int(11) NOT NULL,
  PRIMARY KEY (`id_users_secretary`,`id_users_provider`),
  KEY `secretaries_users_provider` (`id_users_provider`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `ea_services`
--

CREATE TABLE `ea_services` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_datetime` datetime DEFAULT NULL,
  `update_datetime` datetime DEFAULT NULL,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `price` decimal(10,2) DEFAULT NULL,
  `currency` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `color` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT '#7cbae8',
  `location` text COLLATE utf8mb4_unicode_ci,
  `availabilities_type` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT 'flexible',
  `attendants_number` int(11) DEFAULT '1',
  `is_private` tinyint(4) DEFAULT '0',
  `id_service_categories` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_service_categories` (`id_service_categories`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `ea_services`
--

INSERT INTO `ea_services` VALUES
(1, '[[regtime]]', '[[regtime]]', 'Service', 30, '0.00', '', NULL, '#7cbae8', NULL, 'flexible', 1, 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ea_services_providers`
--

CREATE TABLE `ea_services_providers` (
  `id_users` int(11) NOT NULL,
  `id_services` int(11) NOT NULL,
  PRIMARY KEY (`id_users`,`id_services`),
  KEY `services_providers_services` (`id_services`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `ea_services_providers`
--

INSERT INTO `ea_services_providers` VALUES
(2, 1);

-- --------------------------------------------------------

--
-- Table structure for table `ea_service_categories`
--

CREATE TABLE `ea_service_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_datetime` datetime DEFAULT NULL,
  `update_datetime` datetime DEFAULT NULL,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ea_settings`
--

CREATE TABLE `ea_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_datetime` datetime DEFAULT NULL,
  `update_datetime` datetime DEFAULT NULL,
  `name` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=74 ;

--
-- Dumping data for table `ea_settings`
--

INSERT INTO `ea_settings` VALUES
(1, NULL, NULL, 'company_working_plan', '{"monday":{"start":"09:00","end":"18:00","breaks":[{"start":"14:30","end":"15:00"}]},"tuesday":{"start":"09:00","end":"18:00","breaks":[{"start":"14:30","end":"15:00"}]},"wednesday":{"start":"09:00","end":"18:00","breaks":[{"start":"14:30","end":"15:00"}]},"thursday":{"start":"09:00","end":"18:00","breaks":[{"start":"14:30","end":"15:00"}]},"friday":{"start":"09:00","end":"18:00","breaks":[{"start":"14:30","end":"15:00"}]},"saturday":{"start":"09:00","end":"18:00","breaks":[{"start":"14:30","end":"15:00"}]},"sunday":{"start":"09:00","end":"18:00","breaks":[{"start":"14:30","end":"15:00"}]}}'),
(2, NULL, NULL, 'book_advance_timeout', '30'),
(3, NULL, NULL, 'google_analytics_code', ''),
(4, NULL, NULL, 'customer_notifications', '1'),
(5, NULL, NULL, 'date_format', 'DMY'),
(6, NULL, NULL, 'require_captcha', '0'),
(7, NULL, NULL, 'time_format', 'regular'),
(8, NULL, NULL, 'display_cookie_notice', '0'),
(9, NULL, NULL, 'cookie_notice_content', 'Cookie notice content.'),
(10, NULL, NULL, 'display_terms_and_conditions', '0'),
(11, NULL, NULL, 'terms_and_conditions_content', 'Terms and conditions content.'),
(12, NULL, NULL, 'display_privacy_policy', '0'),
(13, NULL, NULL, 'privacy_policy_content', 'Privacy policy content.'),
(14, NULL, NULL, 'first_weekday', 'sunday'),
(16, NULL, NULL, 'api_token', ''),
(17, NULL, NULL, 'display_any_provider', '1'),
(18, NULL, NULL, 'display_first_name', '1'),
(19, NULL, NULL, 'require_first_name', '1'),
(20, NULL, NULL, 'display_last_name', '1'),
(21, NULL, NULL, 'require_last_name', '1'),
(22, NULL, NULL, 'display_email', '1'),
(23, NULL, NULL, 'require_email', '1'),
(24, NULL, NULL, 'display_phone_number', '1'),
(25, NULL, NULL, 'require_phone_number', '1'),
(26, NULL, NULL, 'display_address', '1'),
(27, NULL, NULL, 'require_address', '0'),
(28, NULL, NULL, 'display_city', '1'),
(29, NULL, NULL, 'require_city', '0'),
(30, NULL, NULL, 'display_zip_code', '1'),
(31, NULL, NULL, 'require_zip_code', '0'),
(32, NULL, NULL, 'display_notes', '1'),
(33, NULL, NULL, 'require_notes', '0'),
(34, NULL, NULL, 'matomo_analytics_url', ''),
(35, NULL, NULL, 'display_delete_personal_information', '0'),
(36, NULL, NULL, 'disable_booking', '0'),
(37, NULL, NULL, 'disable_booking_message', '<p style="text-align: center;">Thanks for stopping by!</p><p style="text-align: center;">We are not accepting new appointments at the moment, please check back again later.</p>'),
(38, NULL, NULL, 'company_logo', ''),
(39, NULL, NULL, 'company_color', '#ffffff'),
(40, NULL, NULL, 'display_login_button', '1'),
(41, NULL, NULL, 'theme', 'default'),
(42, '[[regtime]]', '[[regtime]]', 'limit_customer_access', '0'),
(43, NULL, NULL, 'future_booking_limit', '90'),
(44, NULL, NULL, 'appointment_status_options', '["Booked", "Confirmed", "Rescheduled", "Cancelled", "Draft"]'),
(45, NULL, NULL, 'display_custom_field_1', '0'),
(46, NULL, NULL, 'require_custom_field_1', '0'),
(47, NULL, NULL, 'label_custom_field_1', ''),
(48, NULL, NULL, 'display_custom_field_2', '0'),
(49, NULL, NULL, 'require_custom_field_2', '0'),
(50, NULL, NULL, 'label_custom_field_2', ''),
(51, NULL, NULL, 'display_custom_field_3', '0'),
(52, NULL, NULL, 'require_custom_field_3', '0'),
(53, NULL, NULL, 'label_custom_field_3', ''),
(54, NULL, NULL, 'display_custom_field_4', '0'),
(55, NULL, NULL, 'require_custom_field_4', '0'),
(56, NULL, NULL, 'label_custom_field_4', ''),
(57, NULL, NULL, 'display_custom_field_5', '0'),
(58, NULL, NULL, 'require_custom_field_5', '0'),
(59, NULL, NULL, 'label_custom_field_5', ''),
(60, NULL, NULL, 'matomo_analytics_site_id', '1'),
(61, NULL, NULL, 'default_language', 'english'),
(62, NULL, NULL, 'default_timezone', 'America/New_York'),
(63, '[[regtime]]', '[[regtime]]', 'ldap_is_active', '0'),
(64, '[[regtime]]', '[[regtime]]', 'ldap_host', ''),
(65, '[[regtime]]', '[[regtime]]', 'ldap_port', ''),
(66, '[[regtime]]', '[[regtime]]', 'ldap_user_dn', ''),
(67, '[[regtime]]', '[[regtime]]', 'ldap_password', ''),
(68, '[[regtime]]', '[[regtime]]', 'ldap_base_dn', ''),
(69, '[[regtime]]', '[[regtime]]', 'ldap_filter', '(&(objectClass=*)(|(cn={{KEYWORD}})(sn={{KEYWORD}})(mail={{KEYWORD}})(givenName={{KEYWORD}})(uid={{KEYWORD}})))'),
(70, '[[regtime]]', '[[regtime]]', 'ldap_field_mapping', '{\n    "first_name": "givenname",\n    "last_name": "sn",\n    "email": "mail",\n    "phone_number": "telephonenumber",\n    "username": "cn"\n}'),
(71, '[[regtime]]', '[[regtime]]', 'company_name', '[[site_name]]'),
(72, '[[regtime]]', '[[regtime]]', 'company_email', '[[admin_email]]'),
(73, '[[regtime]]', '[[regtime]]', 'company_link', '[[softurl]]');

-- --------------------------------------------------------

--
-- Table structure for table `ea_users`
--

CREATE TABLE `ea_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_datetime` datetime DEFAULT NULL,
  `update_datetime` datetime DEFAULT NULL,
  `first_name` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_number` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_number` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `timezone` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT 'UTC',
  `language` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT 'english',
  `custom_field_1` text COLLATE utf8mb4_unicode_ci,
  `custom_field_2` text COLLATE utf8mb4_unicode_ci,
  `custom_field_3` text COLLATE utf8mb4_unicode_ci,
  `custom_field_4` text COLLATE utf8mb4_unicode_ci,
  `custom_field_5` text COLLATE utf8mb4_unicode_ci,
  `is_private` tinyint(4) DEFAULT '0',
  `ldap_dn` text COLLATE utf8mb4_unicode_ci,
  `id_roles` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_roles` (`id_roles`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `ea_users`
--

INSERT INTO `ea_users` VALUES
(1, '[[regtime]]', '[[regtime]]', '[[admin_fname]]', '[[admin_lname]]', '[[admin_email]]', NULL, '[[store_phone]]', NULL, NULL, NULL, NULL, NULL, 'America/New_York', 'english', NULL, NULL, NULL, NULL, NULL, 0, NULL, 1),
(2, '[[regtime]]', '[[regtime]]', 'Jane', 'Doe', 'jane@example.org', NULL, '+1 (000) 000-0000', NULL, NULL, NULL, NULL, NULL, 'America/New_York', 'english', NULL, NULL, NULL, NULL, NULL, 0, NULL, 2),
(3, '[[regtime]]', '[[regtime]]', 'James', 'Doe', 'james@example.org', NULL, '+1 (000) 000-0000', NULL, NULL, NULL, NULL, NULL, 'UTC', 'english', NULL, NULL, NULL, NULL, NULL, 0, NULL, 3);

-- --------------------------------------------------------

--
-- Table structure for table `ea_user_settings`
--

CREATE TABLE `ea_user_settings` (
  `id_users` int(11) NOT NULL,
  `username` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `salt` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `working_plan` text COLLATE utf8mb4_unicode_ci,
  `working_plan_exceptions` text COLLATE utf8mb4_unicode_ci,
  `notifications` tinyint(4) DEFAULT NULL,
  `google_sync` tinyint(4) DEFAULT NULL,
  `google_token` text COLLATE utf8mb4_unicode_ci,
  `google_calendar` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `caldav_sync` tinyint(4) DEFAULT '0',
  `caldav_url` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `caldav_username` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `caldav_password` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sync_past_days` int(11) DEFAULT '30',
  `sync_future_days` int(11) DEFAULT '90',
  `calendar_view` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT 'default',
  PRIMARY KEY (`id_users`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `ea_user_settings`
--

INSERT INTO `ea_user_settings` VALUES
(1, '[[admin_username]]', '[[admin_pass]]', '[[salt]]', NULL, NULL, 1, NULL, NULL, NULL, 0, NULL, NULL, NULL, 30, 90, 'default'),
(2, 'janedoe', '638c801162e282dcff4bc9e3c888731532bfebb03bcc8cb2a659a64a0448c8a4', '68610d9d3744fd1377df02f619b4e5747208a035c92906e0746a8cc3d64a6597', '{"monday":{"start":"09:00","end":"18:00","breaks":[{"start":"14:30","end":"15:00"}]},"tuesday":{"start":"09:00","end":"18:00","breaks":[{"start":"14:30","end":"15:00"}]},"wednesday":{"start":"09:00","end":"18:00","breaks":[{"start":"14:30","end":"15:00"}]},"thursday":{"start":"09:00","end":"18:00","breaks":[{"start":"14:30","end":"15:00"}]},"friday":{"start":"09:00","end":"18:00","breaks":[{"start":"14:30","end":"15:00"}]},"saturday":{"start":"09:00","end":"18:00","breaks":[{"start":"14:30","end":"15:00"}]},"sunday":{"start":"09:00","end":"18:00","breaks":[{"start":"14:30","end":"15:00"}]}}', NULL, 1, 0, NULL, NULL, 0, NULL, NULL, NULL, 30, 90, 'default');

-- --------------------------------------------------------

--
-- Table structure for table `ea_webhooks`
--

CREATE TABLE `ea_webhooks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_datetime` datetime DEFAULT NULL,
  `update_datetime` datetime DEFAULT NULL,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` text COLLATE utf8mb4_unicode_ci,
  `actions` text COLLATE utf8mb4_unicode_ci,
  `secret_header` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT 'X-Ea-Token',
  `secret_token` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_ssl_verified` tinyint(4) NOT NULL DEFAULT '1',
  `notes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `ea_appointments`
--
ALTER TABLE `ea_appointments`
  ADD CONSTRAINT `appointments_services` FOREIGN KEY (`id_services`) REFERENCES `ea_services` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `appointments_users_customer` FOREIGN KEY (`id_users_customer`) REFERENCES `ea_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `appointments_users_provider` FOREIGN KEY (`id_users_provider`) REFERENCES `ea_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `ea_secretaries_providers`
--
ALTER TABLE `ea_secretaries_providers`
  ADD CONSTRAINT `secretaries_users_provider` FOREIGN KEY (`id_users_provider`) REFERENCES `ea_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `secretaries_users_secretary` FOREIGN KEY (`id_users_secretary`) REFERENCES `ea_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `ea_services`
--
ALTER TABLE `ea_services`
  ADD CONSTRAINT `services_service_categories` FOREIGN KEY (`id_service_categories`) REFERENCES `ea_service_categories` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `ea_services_providers`
--
ALTER TABLE `ea_services_providers`
  ADD CONSTRAINT `services_providers_services` FOREIGN KEY (`id_services`) REFERENCES `ea_services` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `services_providers_users_provider` FOREIGN KEY (`id_users`) REFERENCES `ea_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `ea_users`
--
ALTER TABLE `ea_users`
  ADD CONSTRAINT `users_roles` FOREIGN KEY (`id_roles`) REFERENCES `ea_roles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `ea_user_settings`
--
ALTER TABLE `ea_user_settings`
  ADD CONSTRAINT `user_settings_users` FOREIGN KEY (`id_users`) REFERENCES `ea_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
