<?php

if (! defined('BASEPATH')) {
    exit('No direct script access allowed.');
}

/**
 * This source file is part of the open source project
 * ExpressionEngine (https://expressionengine.com)
 *
 * @link      https://expressionengine.com/
 * @copyright Copyright (c) 2003-2023, Packet Tide, LLC (https://www.packettide.com)
 * @license   https://expressionengine.com/license Licensed under Apache License, Version 2.0
 */

/**
 * Cookie Helpers
 */

/**
 * Set cookie
 *
 * Accepts six parameter, or you can submit an associative
 * array in the first parameter containing all the values.
 *
 * @access	public
 * @param	mixed
 * @param	string	the value of the cookie
 * @param	string	the number of seconds until expiration
 * @param	string	the cookie domain.  Usually:  .yourdomain.com
 * @param	string	the cookie path
 * @param	string	the cookie prefix
 * @return	void
 */
if (! function_exists('set_cookie')) {
    function set_cookie($name = '', $value = '', $expire = '', $domain = '', $path = '/', $prefix = '')
    {
        // Set the config file options
        ee()->input->set_cookie($name, $value, $expire, $domain, $path, $prefix);
    }
}

/**
 * Fetch an item from the COOKIE array
 *
 * @access	public
 * @param	string
 * @param	bool
 * @return	mixed
 */
if (! function_exists('get_cookie')) {
    function get_cookie($index = '', $xss_clean = false)
    {
        $prefix = '';

        if (! isset($_COOKIE[$index]) && config_item('cookie_prefix') != '') {
            $prefix = config_item('cookie_prefix');
        }

        return ee()->input->cookie($prefix . $index, $xss_clean);
    }
}

/**
 * Delete a COOKIE
 *
 * @param	mixed
 * @param	string	the cookie domain.  Usually:  .yourdomain.com
 * @param	string	the cookie path
 * @param	string	the cookie prefix
 * @return	void
 */
if (! function_exists('delete_cookie')) {
    function delete_cookie($name = '', $domain = '', $path = '/', $prefix = '')
    {
        set_cookie($name, '', '', $domain, $path, $prefix);
    }
}

// EOF
