<?php

declare (strict_types=1);
namespace ExpressionEngine\Dependency;

use ExpressionEngine\Dependency\Rector\Renaming\Rector\FuncCall\RenameFunctionRector;
use ExpressionEngine\Dependency\Symfony\Component\DependencyInjection\Loader\Configurator\ContainerConfigurator;
# This file configures rector/rector:~0.7.0 to replace all PHP functions with their equivalent "safe" functions
return static function (ContainerConfigurator $containerConfigurator) : void {
    $services = $containerConfigurator->services();
    $services->set(RenameFunctionRector::class)->call('configure', [[RenameFunctionRector::OLD_FUNCTION_TO_NEW_FUNCTION => ['apache_getenv' => 'ExpressionEngine\\Dependency\\Safe\\apache_getenv', 'apache_get_version' => 'ExpressionEngine\\Dependency\\Safe\\apache_get_version', 'apache_request_headers' => 'ExpressionEngine\\Dependency\\Safe\\apache_request_headers', 'apache_reset_timeout' => 'ExpressionEngine\\Dependency\\Safe\\apache_reset_timeout', 'apache_response_headers' => 'ExpressionEngine\\Dependency\\Safe\\apache_response_headers', 'apache_setenv' => 'ExpressionEngine\\Dependency\\Safe\\apache_setenv', 'apcu_cache_info' => 'ExpressionEngine\\Dependency\\Safe\\apcu_cache_info', 'apcu_cas' => 'ExpressionEngine\\Dependency\\Safe\\apcu_cas', 'apcu_dec' => 'ExpressionEngine\\Dependency\\Safe\\apcu_dec', 'apcu_fetch' => 'ExpressionEngine\\Dependency\\Safe\\apcu_fetch', 'apcu_inc' => 'ExpressionEngine\\Dependency\\Safe\\apcu_inc', 'apcu_sma_info' => 'ExpressionEngine\\Dependency\\Safe\\apcu_sma_info', 'apc_fetch' => 'ExpressionEngine\\Dependency\\Safe\\apc_fetch', 'array_combine' => 'ExpressionEngine\\Dependency\\Safe\\array_combine', 'array_flip' => 'ExpressionEngine\\Dependency\\Safe\\array_flip', 'array_replace' => 'ExpressionEngine\\Dependency\\Safe\\array_replace', 'array_replace_recursive' => 'ExpressionEngine\\Dependency\\Safe\\array_replace_recursive', 'array_walk_recursive' => 'ExpressionEngine\\Dependency\\Safe\\array_walk_recursive', 'arsort' => 'ExpressionEngine\\Dependency\\Safe\\arsort', 'asort' => 'ExpressionEngine\\Dependency\\Safe\\asort', 'base64_decode' => 'ExpressionEngine\\Dependency\\Safe\\base64_decode', 'bzclose' => 'ExpressionEngine\\Dependency\\Safe\\bzclose', 'bzflush' => 'ExpressionEngine\\Dependency\\Safe\\bzflush', 'bzread' => 'ExpressionEngine\\Dependency\\Safe\\bzread', 'bzwrite' => 'ExpressionEngine\\Dependency\\Safe\\bzwrite', 'chdir' => 'ExpressionEngine\\Dependency\\Safe\\chdir', 'chgrp' => 'ExpressionEngine\\Dependency\\Safe\\chgrp', 'chmod' => 'ExpressionEngine\\Dependency\\Safe\\chmod', 'chown' => 'ExpressionEngine\\Dependency\\Safe\\chown', 'chroot' => 'ExpressionEngine\\Dependency\\Safe\\chroot', 'class_alias' => 'ExpressionEngine\\Dependency\\Safe\\class_alias', 'class_implements' => 'ExpressionEngine\\Dependency\\Safe\\class_implements', 'class_parents' => 'ExpressionEngine\\Dependency\\Safe\\class_parents', 'class_uses' => 'ExpressionEngine\\Dependency\\Safe\\class_uses', 'cli_set_process_title' => 'ExpressionEngine\\Dependency\\Safe\\cli_set_process_title', 'closelog' => 'ExpressionEngine\\Dependency\\Safe\\closelog', 'com_event_sink' => 'ExpressionEngine\\Dependency\\Safe\\com_event_sink', 'com_load_typelib' => 'ExpressionEngine\\Dependency\\Safe\\com_load_typelib', 'com_print_typeinfo' => 'ExpressionEngine\\Dependency\\Safe\\com_print_typeinfo', 'convert_uudecode' => 'ExpressionEngine\\Dependency\\Safe\\convert_uudecode', 'convert_uuencode' => 'ExpressionEngine\\Dependency\\Safe\\convert_uuencode', 'copy' => 'ExpressionEngine\\Dependency\\Safe\\copy', 'create_function' => 'ExpressionEngine\\Dependency\\Safe\\create_function', 'cubrid_free_result' => 'ExpressionEngine\\Dependency\\Safe\\cubrid_free_result', 'cubrid_get_charset' => 'ExpressionEngine\\Dependency\\Safe\\cubrid_get_charset', 'cubrid_get_client_info' => 'ExpressionEngine\\Dependency\\Safe\\cubrid_get_client_info', 'cubrid_get_db_parameter' => 'ExpressionEngine\\Dependency\\Safe\\cubrid_get_db_parameter', 'cubrid_get_server_info' => 'ExpressionEngine\\Dependency\\Safe\\cubrid_get_server_info', 'cubrid_insert_id' => 'ExpressionEngine\\Dependency\\Safe\\cubrid_insert_id', 'cubrid_lob2_new' => 'ExpressionEngine\\Dependency\\Safe\\cubrid_lob2_new', 'cubrid_lob2_size' => 'ExpressionEngine\\Dependency\\Safe\\cubrid_lob2_size', 'cubrid_lob2_size64' => 'ExpressionEngine\\Dependency\\Safe\\cubrid_lob2_size64', 'cubrid_lob2_tell' => 'ExpressionEngine\\Dependency\\Safe\\cubrid_lob2_tell', 'cubrid_lob2_tell64' => 'ExpressionEngine\\Dependency\\Safe\\cubrid_lob2_tell64', 'cubrid_set_db_parameter' => 'ExpressionEngine\\Dependency\\Safe\\cubrid_set_db_parameter', 'curl_escape' => 'ExpressionEngine\\Dependency\\Safe\\curl_escape', 'curl_exec' => 'ExpressionEngine\\Dependency\\Safe\\curl_exec', 'curl_getinfo' => 'ExpressionEngine\\Dependency\\Safe\\curl_getinfo', 'curl_init' => 'ExpressionEngine\\Dependency\\Safe\\curl_init', 'curl_multi_errno' => 'ExpressionEngine\\Dependency\\Safe\\curl_multi_errno', 'curl_multi_info_read' => 'ExpressionEngine\\Dependency\\Safe\\curl_multi_info_read', 'curl_multi_init' => 'ExpressionEngine\\Dependency\\Safe\\curl_multi_init', 'curl_setopt' => 'ExpressionEngine\\Dependency\\Safe\\curl_setopt', 'curl_share_errno' => 'ExpressionEngine\\Dependency\\Safe\\curl_share_errno', 'curl_share_setopt' => 'ExpressionEngine\\Dependency\\Safe\\curl_share_setopt', 'curl_unescape' => 'ExpressionEngine\\Dependency\\Safe\\curl_unescape', 'date' => 'ExpressionEngine\\Dependency\\Safe\\date', 'date_parse' => 'ExpressionEngine\\Dependency\\Safe\\date_parse', 'date_parse_from_format' => 'ExpressionEngine\\Dependency\\Safe\\date_parse_from_format', 'date_sunrise' => 'ExpressionEngine\\Dependency\\Safe\\date_sunrise', 'date_sunset' => 'ExpressionEngine\\Dependency\\Safe\\date_sunset', 'date_sun_info' => 'ExpressionEngine\\Dependency\\Safe\\date_sun_info', 'db2_autocommit' => 'ExpressionEngine\\Dependency\\Safe\\db2_autocommit', 'db2_bind_param' => 'ExpressionEngine\\Dependency\\Safe\\db2_bind_param', 'db2_client_info' => 'ExpressionEngine\\Dependency\\Safe\\db2_client_info', 'db2_close' => 'ExpressionEngine\\Dependency\\Safe\\db2_close', 'db2_commit' => 'ExpressionEngine\\Dependency\\Safe\\db2_commit', 'db2_execute' => 'ExpressionEngine\\Dependency\\Safe\\db2_execute', 'db2_free_result' => 'ExpressionEngine\\Dependency\\Safe\\db2_free_result', 'db2_free_stmt' => 'ExpressionEngine\\Dependency\\Safe\\db2_free_stmt', 'db2_get_option' => 'ExpressionEngine\\Dependency\\Safe\\db2_get_option', 'db2_pclose' => 'ExpressionEngine\\Dependency\\Safe\\db2_pclose', 'db2_rollback' => 'ExpressionEngine\\Dependency\\Safe\\db2_rollback', 'db2_server_info' => 'ExpressionEngine\\Dependency\\Safe\\db2_server_info', 'db2_set_option' => 'ExpressionEngine\\Dependency\\Safe\\db2_set_option', 'define' => 'ExpressionEngine\\Dependency\\Safe\\define', 'deflate_add' => 'ExpressionEngine\\Dependency\\Safe\\deflate_add', 'deflate_init' => 'ExpressionEngine\\Dependency\\Safe\\deflate_init', 'disk_free_space' => 'ExpressionEngine\\Dependency\\Safe\\disk_free_space', 'disk_total_space' => 'ExpressionEngine\\Dependency\\Safe\\disk_total_space', 'dl' => 'ExpressionEngine\\Dependency\\Safe\\dl', 'dns_get_record' => 'ExpressionEngine\\Dependency\\Safe\\dns_get_record', 'eio_busy' => 'ExpressionEngine\\Dependency\\Safe\\eio_busy', 'eio_chmod' => 'ExpressionEngine\\Dependency\\Safe\\eio_chmod', 'eio_chown' => 'ExpressionEngine\\Dependency\\Safe\\eio_chown', 'eio_close' => 'ExpressionEngine\\Dependency\\Safe\\eio_close', 'eio_custom' => 'ExpressionEngine\\Dependency\\Safe\\eio_custom', 'eio_dup2' => 'ExpressionEngine\\Dependency\\Safe\\eio_dup2', 'eio_event_loop' => 'ExpressionEngine\\Dependency\\Safe\\eio_event_loop', 'eio_fallocate' => 'ExpressionEngine\\Dependency\\Safe\\eio_fallocate', 'eio_fchmod' => 'ExpressionEngine\\Dependency\\Safe\\eio_fchmod', 'eio_fdatasync' => 'ExpressionEngine\\Dependency\\Safe\\eio_fdatasync', 'eio_fstat' => 'ExpressionEngine\\Dependency\\Safe\\eio_fstat', 'eio_fstatvfs' => 'ExpressionEngine\\Dependency\\Safe\\eio_fstatvfs', 'eio_fsync' => 'ExpressionEngine\\Dependency\\Safe\\eio_fsync', 'eio_ftruncate' => 'ExpressionEngine\\Dependency\\Safe\\eio_ftruncate', 'eio_futime' => 'ExpressionEngine\\Dependency\\Safe\\eio_futime', 'eio_grp' => 'ExpressionEngine\\Dependency\\Safe\\eio_grp', 'eio_lstat' => 'ExpressionEngine\\Dependency\\Safe\\eio_lstat', 'eio_mkdir' => 'ExpressionEngine\\Dependency\\Safe\\eio_mkdir', 'eio_mknod' => 'ExpressionEngine\\Dependency\\Safe\\eio_mknod', 'eio_nop' => 'ExpressionEngine\\Dependency\\Safe\\eio_nop', 'eio_readahead' => 'ExpressionEngine\\Dependency\\Safe\\eio_readahead', 'eio_readdir' => 'ExpressionEngine\\Dependency\\Safe\\eio_readdir', 'eio_readlink' => 'ExpressionEngine\\Dependency\\Safe\\eio_readlink', 'eio_rename' => 'ExpressionEngine\\Dependency\\Safe\\eio_rename', 'eio_rmdir' => 'ExpressionEngine\\Dependency\\Safe\\eio_rmdir', 'eio_seek' => 'ExpressionEngine\\Dependency\\Safe\\eio_seek', 'eio_sendfile' => 'ExpressionEngine\\Dependency\\Safe\\eio_sendfile', 'eio_stat' => 'ExpressionEngine\\Dependency\\Safe\\eio_stat', 'eio_statvfs' => 'ExpressionEngine\\Dependency\\Safe\\eio_statvfs', 'eio_symlink' => 'ExpressionEngine\\Dependency\\Safe\\eio_symlink', 'eio_sync' => 'ExpressionEngine\\Dependency\\Safe\\eio_sync', 'eio_syncfs' => 'ExpressionEngine\\Dependency\\Safe\\eio_syncfs', 'eio_sync_file_range' => 'ExpressionEngine\\Dependency\\Safe\\eio_sync_file_range', 'eio_truncate' => 'ExpressionEngine\\Dependency\\Safe\\eio_truncate', 'eio_unlink' => 'ExpressionEngine\\Dependency\\Safe\\eio_unlink', 'eio_utime' => 'ExpressionEngine\\Dependency\\Safe\\eio_utime', 'eio_write' => 'ExpressionEngine\\Dependency\\Safe\\eio_write', 'error_log' => 'ExpressionEngine\\Dependency\\Safe\\error_log', 'fastcgi_finish_request' => 'ExpressionEngine\\Dependency\\Safe\\fastcgi_finish_request', 'fbird_blob_cancel' => 'ExpressionEngine\\Dependency\\Safe\\fbird_blob_cancel', 'fclose' => 'ExpressionEngine\\Dependency\\Safe\\fclose', 'fflush' => 'ExpressionEngine\\Dependency\\Safe\\fflush', 'file' => 'ExpressionEngine\\Dependency\\Safe\\file', 'fileatime' => 'ExpressionEngine\\Dependency\\Safe\\fileatime', 'filectime' => 'ExpressionEngine\\Dependency\\Safe\\filectime', 'fileinode' => 'ExpressionEngine\\Dependency\\Safe\\fileinode', 'filemtime' => 'ExpressionEngine\\Dependency\\Safe\\filemtime', 'fileowner' => 'ExpressionEngine\\Dependency\\Safe\\fileowner', 'filesize' => 'ExpressionEngine\\Dependency\\Safe\\filesize', 'file_get_contents' => 'ExpressionEngine\\Dependency\\Safe\\file_get_contents', 'file_put_contents' => 'ExpressionEngine\\Dependency\\Safe\\file_put_contents', 'filter_input_array' => 'ExpressionEngine\\Dependency\\Safe\\filter_input_array', 'filter_var_array' => 'ExpressionEngine\\Dependency\\Safe\\filter_var_array', 'finfo_close' => 'ExpressionEngine\\Dependency\\Safe\\finfo_close', 'finfo_open' => 'ExpressionEngine\\Dependency\\Safe\\finfo_open', 'flock' => 'ExpressionEngine\\Dependency\\Safe\\flock', 'fopen' => 'ExpressionEngine\\Dependency\\Safe\\fopen', 'fputcsv' => 'ExpressionEngine\\Dependency\\Safe\\fputcsv', 'fread' => 'ExpressionEngine\\Dependency\\Safe\\fread', 'fsockopen' => 'ExpressionEngine\\Dependency\\Safe\\fsockopen', 'ftp_alloc' => 'ExpressionEngine\\Dependency\\Safe\\ftp_alloc', 'ftp_append' => 'ExpressionEngine\\Dependency\\Safe\\ftp_append', 'ftp_cdup' => 'ExpressionEngine\\Dependency\\Safe\\ftp_cdup', 'ftp_chdir' => 'ExpressionEngine\\Dependency\\Safe\\ftp_chdir', 'ftp_chmod' => 'ExpressionEngine\\Dependency\\Safe\\ftp_chmod', 'ftp_close' => 'ExpressionEngine\\Dependency\\Safe\\ftp_close', 'ftp_connect' => 'ExpressionEngine\\Dependency\\Safe\\ftp_connect', 'ftp_delete' => 'ExpressionEngine\\Dependency\\Safe\\ftp_delete', 'ftp_fget' => 'ExpressionEngine\\Dependency\\Safe\\ftp_fget', 'ftp_fput' => 'ExpressionEngine\\Dependency\\Safe\\ftp_fput', 'ftp_get' => 'ExpressionEngine\\Dependency\\Safe\\ftp_get', 'ftp_login' => 'ExpressionEngine\\Dependency\\Safe\\ftp_login', 'ftp_mkdir' => 'ExpressionEngine\\Dependency\\Safe\\ftp_mkdir', 'ftp_mlsd' => 'ExpressionEngine\\Dependency\\Safe\\ftp_mlsd', 'ftp_nlist' => 'ExpressionEngine\\Dependency\\Safe\\ftp_nlist', 'ftp_pasv' => 'ExpressionEngine\\Dependency\\Safe\\ftp_pasv', 'ftp_put' => 'ExpressionEngine\\Dependency\\Safe\\ftp_put', 'ftp_pwd' => 'ExpressionEngine\\Dependency\\Safe\\ftp_pwd', 'ftp_rename' => 'ExpressionEngine\\Dependency\\Safe\\ftp_rename', 'ftp_rmdir' => 'ExpressionEngine\\Dependency\\Safe\\ftp_rmdir', 'ftp_site' => 'ExpressionEngine\\Dependency\\Safe\\ftp_site', 'ftp_ssl_connect' => 'ExpressionEngine\\Dependency\\Safe\\ftp_ssl_connect', 'ftp_systype' => 'ExpressionEngine\\Dependency\\Safe\\ftp_systype', 'ftruncate' => 'ExpressionEngine\\Dependency\\Safe\\ftruncate', 'fwrite' => 'ExpressionEngine\\Dependency\\Safe\\fwrite', 'getallheaders' => 'ExpressionEngine\\Dependency\\Safe\\getallheaders', 'getcwd' => 'ExpressionEngine\\Dependency\\Safe\\getcwd', 'gethostname' => 'ExpressionEngine\\Dependency\\Safe\\gethostname', 'getimagesize' => 'ExpressionEngine\\Dependency\\Safe\\getimagesize', 'getlastmod' => 'ExpressionEngine\\Dependency\\Safe\\getlastmod', 'getmygid' => 'ExpressionEngine\\Dependency\\Safe\\getmygid', 'getmyinode' => 'ExpressionEngine\\Dependency\\Safe\\getmyinode', 'getmypid' => 'ExpressionEngine\\Dependency\\Safe\\getmypid', 'getmyuid' => 'ExpressionEngine\\Dependency\\Safe\\getmyuid', 'getopt' => 'ExpressionEngine\\Dependency\\Safe\\getopt', 'getprotobyname' => 'ExpressionEngine\\Dependency\\Safe\\getprotobyname', 'getprotobynumber' => 'ExpressionEngine\\Dependency\\Safe\\getprotobynumber', 'get_headers' => 'ExpressionEngine\\Dependency\\Safe\\get_headers', 'glob' => 'ExpressionEngine\\Dependency\\Safe\\glob', 'gmdate' => 'ExpressionEngine\\Dependency\\Safe\\gmdate', 'gmp_binomial' => 'ExpressionEngine\\Dependency\\Safe\\gmp_binomial', 'gmp_export' => 'ExpressionEngine\\Dependency\\Safe\\gmp_export', 'gmp_import' => 'ExpressionEngine\\Dependency\\Safe\\gmp_import', 'gmp_random_seed' => 'ExpressionEngine\\Dependency\\Safe\\gmp_random_seed', 'gnupg_adddecryptkey' => 'ExpressionEngine\\Dependency\\Safe\\gnupg_adddecryptkey', 'gnupg_addencryptkey' => 'ExpressionEngine\\Dependency\\Safe\\gnupg_addencryptkey', 'gnupg_addsignkey' => 'ExpressionEngine\\Dependency\\Safe\\gnupg_addsignkey', 'gnupg_cleardecryptkeys' => 'ExpressionEngine\\Dependency\\Safe\\gnupg_cleardecryptkeys', 'gnupg_clearencryptkeys' => 'ExpressionEngine\\Dependency\\Safe\\gnupg_clearencryptkeys', 'gnupg_clearsignkeys' => 'ExpressionEngine\\Dependency\\Safe\\gnupg_clearsignkeys', 'gnupg_setarmor' => 'ExpressionEngine\\Dependency\\Safe\\gnupg_setarmor', 'gnupg_setsignmode' => 'ExpressionEngine\\Dependency\\Safe\\gnupg_setsignmode', 'gzclose' => 'ExpressionEngine\\Dependency\\Safe\\gzclose', 'gzcompress' => 'ExpressionEngine\\Dependency\\Safe\\gzcompress', 'gzdecode' => 'ExpressionEngine\\Dependency\\Safe\\gzdecode', 'gzdeflate' => 'ExpressionEngine\\Dependency\\Safe\\gzdeflate', 'gzencode' => 'ExpressionEngine\\Dependency\\Safe\\gzencode', 'gzgets' => 'ExpressionEngine\\Dependency\\Safe\\gzgets', 'gzgetss' => 'ExpressionEngine\\Dependency\\Safe\\gzgetss', 'gzinflate' => 'ExpressionEngine\\Dependency\\Safe\\gzinflate', 'gzpassthru' => 'ExpressionEngine\\Dependency\\Safe\\gzpassthru', 'gzrewind' => 'ExpressionEngine\\Dependency\\Safe\\gzrewind', 'gzuncompress' => 'ExpressionEngine\\Dependency\\Safe\\gzuncompress', 'hash_hkdf' => 'ExpressionEngine\\Dependency\\Safe\\hash_hkdf', 'hash_update_file' => 'ExpressionEngine\\Dependency\\Safe\\hash_update_file', 'header_register_callback' => 'ExpressionEngine\\Dependency\\Safe\\header_register_callback', 'hex2bin' => 'ExpressionEngine\\Dependency\\Safe\\hex2bin', 'highlight_file' => 'ExpressionEngine\\Dependency\\Safe\\highlight_file', 'highlight_string' => 'ExpressionEngine\\Dependency\\Safe\\highlight_string', 'ibase_add_user' => 'ExpressionEngine\\Dependency\\Safe\\ibase_add_user', 'ibase_backup' => 'ExpressionEngine\\Dependency\\Safe\\ibase_backup', 'ibase_blob_cancel' => 'ExpressionEngine\\Dependency\\Safe\\ibase_blob_cancel', 'ibase_blob_create' => 'ExpressionEngine\\Dependency\\Safe\\ibase_blob_create', 'ibase_blob_get' => 'ExpressionEngine\\Dependency\\Safe\\ibase_blob_get', 'ibase_close' => 'ExpressionEngine\\Dependency\\Safe\\ibase_close', 'ibase_commit' => 'ExpressionEngine\\Dependency\\Safe\\ibase_commit', 'ibase_commit_ret' => 'ExpressionEngine\\Dependency\\Safe\\ibase_commit_ret', 'ibase_connect' => 'ExpressionEngine\\Dependency\\Safe\\ibase_connect', 'ibase_delete_user' => 'ExpressionEngine\\Dependency\\Safe\\ibase_delete_user', 'ibase_drop_db' => 'ExpressionEngine\\Dependency\\Safe\\ibase_drop_db', 'ibase_free_event_handler' => 'ExpressionEngine\\Dependency\\Safe\\ibase_free_event_handler', 'ibase_free_query' => 'ExpressionEngine\\Dependency\\Safe\\ibase_free_query', 'ibase_free_result' => 'ExpressionEngine\\Dependency\\Safe\\ibase_free_result', 'ibase_maintain_db' => 'ExpressionEngine\\Dependency\\Safe\\ibase_maintain_db', 'ibase_modify_user' => 'ExpressionEngine\\Dependency\\Safe\\ibase_modify_user', 'ibase_name_result' => 'ExpressionEngine\\Dependency\\Safe\\ibase_name_result', 'ibase_pconnect' => 'ExpressionEngine\\Dependency\\Safe\\ibase_pconnect', 'ibase_restore' => 'ExpressionEngine\\Dependency\\Safe\\ibase_restore', 'ibase_rollback' => 'ExpressionEngine\\Dependency\\Safe\\ibase_rollback', 'ibase_rollback_ret' => 'ExpressionEngine\\Dependency\\Safe\\ibase_rollback_ret', 'ibase_service_attach' => 'ExpressionEngine\\Dependency\\Safe\\ibase_service_attach', 'ibase_service_detach' => 'ExpressionEngine\\Dependency\\Safe\\ibase_service_detach', 'iconv' => 'ExpressionEngine\\Dependency\\Safe\\iconv', 'iconv_get_encoding' => 'ExpressionEngine\\Dependency\\Safe\\iconv_get_encoding', 'iconv_set_encoding' => 'ExpressionEngine\\Dependency\\Safe\\iconv_set_encoding', 'image2wbmp' => 'ExpressionEngine\\Dependency\\Safe\\image2wbmp', 'imageaffine' => 'ExpressionEngine\\Dependency\\Safe\\imageaffine', 'imageaffinematrixconcat' => 'ExpressionEngine\\Dependency\\Safe\\imageaffinematrixconcat', 'imageaffinematrixget' => 'ExpressionEngine\\Dependency\\Safe\\imageaffinematrixget', 'imagealphablending' => 'ExpressionEngine\\Dependency\\Safe\\imagealphablending', 'imageantialias' => 'ExpressionEngine\\Dependency\\Safe\\imageantialias', 'imagearc' => 'ExpressionEngine\\Dependency\\Safe\\imagearc', 'imagebmp' => 'ExpressionEngine\\Dependency\\Safe\\imagebmp', 'imagechar' => 'ExpressionEngine\\Dependency\\Safe\\imagechar', 'imagecharup' => 'ExpressionEngine\\Dependency\\Safe\\imagecharup', 'imagecolorat' => 'ExpressionEngine\\Dependency\\Safe\\imagecolorat', 'imagecolordeallocate' => 'ExpressionEngine\\Dependency\\Safe\\imagecolordeallocate', 'imagecolormatch' => 'ExpressionEngine\\Dependency\\Safe\\imagecolormatch', 'imageconvolution' => 'ExpressionEngine\\Dependency\\Safe\\imageconvolution', 'imagecopy' => 'ExpressionEngine\\Dependency\\Safe\\imagecopy', 'imagecopymerge' => 'ExpressionEngine\\Dependency\\Safe\\imagecopymerge', 'imagecopymergegray' => 'ExpressionEngine\\Dependency\\Safe\\imagecopymergegray', 'imagecopyresampled' => 'ExpressionEngine\\Dependency\\Safe\\imagecopyresampled', 'imagecopyresized' => 'ExpressionEngine\\Dependency\\Safe\\imagecopyresized', 'imagecreate' => 'ExpressionEngine\\Dependency\\Safe\\imagecreate', 'imagecreatefrombmp' => 'ExpressionEngine\\Dependency\\Safe\\imagecreatefrombmp', 'imagecreatefromgd' => 'ExpressionEngine\\Dependency\\Safe\\imagecreatefromgd', 'imagecreatefromgd2' => 'ExpressionEngine\\Dependency\\Safe\\imagecreatefromgd2', 'imagecreatefromgd2part' => 'ExpressionEngine\\Dependency\\Safe\\imagecreatefromgd2part', 'imagecreatefromgif' => 'ExpressionEngine\\Dependency\\Safe\\imagecreatefromgif', 'imagecreatefromjpeg' => 'ExpressionEngine\\Dependency\\Safe\\imagecreatefromjpeg', 'imagecreatefrompng' => 'ExpressionEngine\\Dependency\\Safe\\imagecreatefrompng', 'imagecreatefromwbmp' => 'ExpressionEngine\\Dependency\\Safe\\imagecreatefromwbmp', 'imagecreatefromwebp' => 'ExpressionEngine\\Dependency\\Safe\\imagecreatefromwebp', 'imagecreatefromxbm' => 'ExpressionEngine\\Dependency\\Safe\\imagecreatefromxbm', 'imagecreatefromxpm' => 'ExpressionEngine\\Dependency\\Safe\\imagecreatefromxpm', 'imagecreatetruecolor' => 'ExpressionEngine\\Dependency\\Safe\\imagecreatetruecolor', 'imagecrop' => 'ExpressionEngine\\Dependency\\Safe\\imagecrop', 'imagecropauto' => 'ExpressionEngine\\Dependency\\Safe\\imagecropauto', 'imagedashedline' => 'ExpressionEngine\\Dependency\\Safe\\imagedashedline', 'imagedestroy' => 'ExpressionEngine\\Dependency\\Safe\\imagedestroy', 'imageellipse' => 'ExpressionEngine\\Dependency\\Safe\\imageellipse', 'imagefill' => 'ExpressionEngine\\Dependency\\Safe\\imagefill', 'imagefilledarc' => 'ExpressionEngine\\Dependency\\Safe\\imagefilledarc', 'imagefilledellipse' => 'ExpressionEngine\\Dependency\\Safe\\imagefilledellipse', 'imagefilledpolygon' => 'ExpressionEngine\\Dependency\\Safe\\imagefilledpolygon', 'imagefilledrectangle' => 'ExpressionEngine\\Dependency\\Safe\\imagefilledrectangle', 'imagefilltoborder' => 'ExpressionEngine\\Dependency\\Safe\\imagefilltoborder', 'imagefilter' => 'ExpressionEngine\\Dependency\\Safe\\imagefilter', 'imageflip' => 'ExpressionEngine\\Dependency\\Safe\\imageflip', 'imagegammacorrect' => 'ExpressionEngine\\Dependency\\Safe\\imagegammacorrect', 'imagegd' => 'ExpressionEngine\\Dependency\\Safe\\imagegd', 'imagegd2' => 'ExpressionEngine\\Dependency\\Safe\\imagegd2', 'imagegif' => 'ExpressionEngine\\Dependency\\Safe\\imagegif', 'imagegrabscreen' => 'ExpressionEngine\\Dependency\\Safe\\imagegrabscreen', 'imagegrabwindow' => 'ExpressionEngine\\Dependency\\Safe\\imagegrabwindow', 'imagejpeg' => 'ExpressionEngine\\Dependency\\Safe\\imagejpeg', 'imagelayereffect' => 'ExpressionEngine\\Dependency\\Safe\\imagelayereffect', 'imageline' => 'ExpressionEngine\\Dependency\\Safe\\imageline', 'imageloadfont' => 'ExpressionEngine\\Dependency\\Safe\\imageloadfont', 'imageopenpolygon' => 'ExpressionEngine\\Dependency\\Safe\\imageopenpolygon', 'imagepng' => 'ExpressionEngine\\Dependency\\Safe\\imagepng', 'imagepolygon' => 'ExpressionEngine\\Dependency\\Safe\\imagepolygon', 'imagerectangle' => 'ExpressionEngine\\Dependency\\Safe\\imagerectangle', 'imagerotate' => 'ExpressionEngine\\Dependency\\Safe\\imagerotate', 'imagesavealpha' => 'ExpressionEngine\\Dependency\\Safe\\imagesavealpha', 'imagescale' => 'ExpressionEngine\\Dependency\\Safe\\imagescale', 'imagesetbrush' => 'ExpressionEngine\\Dependency\\Safe\\imagesetbrush', 'imagesetclip' => 'ExpressionEngine\\Dependency\\Safe\\imagesetclip', 'imagesetinterpolation' => 'ExpressionEngine\\Dependency\\Safe\\imagesetinterpolation', 'imagesetpixel' => 'ExpressionEngine\\Dependency\\Safe\\imagesetpixel', 'imagesetstyle' => 'ExpressionEngine\\Dependency\\Safe\\imagesetstyle', 'imagesetthickness' => 'ExpressionEngine\\Dependency\\Safe\\imagesetthickness', 'imagesettile' => 'ExpressionEngine\\Dependency\\Safe\\imagesettile', 'imagestring' => 'ExpressionEngine\\Dependency\\Safe\\imagestring', 'imagestringup' => 'ExpressionEngine\\Dependency\\Safe\\imagestringup', 'imagesx' => 'ExpressionEngine\\Dependency\\Safe\\imagesx', 'imagesy' => 'ExpressionEngine\\Dependency\\Safe\\imagesy', 'imagetruecolortopalette' => 'ExpressionEngine\\Dependency\\Safe\\imagetruecolortopalette', 'imagettfbbox' => 'ExpressionEngine\\Dependency\\Safe\\imagettfbbox', 'imagettftext' => 'ExpressionEngine\\Dependency\\Safe\\imagettftext', 'imagewbmp' => 'ExpressionEngine\\Dependency\\Safe\\imagewbmp', 'imagewebp' => 'ExpressionEngine\\Dependency\\Safe\\imagewebp', 'imagexbm' => 'ExpressionEngine\\Dependency\\Safe\\imagexbm', 'imap_append' => 'ExpressionEngine\\Dependency\\Safe\\imap_append', 'imap_check' => 'ExpressionEngine\\Dependency\\Safe\\imap_check', 'imap_clearflag_full' => 'ExpressionEngine\\Dependency\\Safe\\imap_clearflag_full', 'imap_close' => 'ExpressionEngine\\Dependency\\Safe\\imap_close', 'imap_createmailbox' => 'ExpressionEngine\\Dependency\\Safe\\imap_createmailbox', 'imap_deletemailbox' => 'ExpressionEngine\\Dependency\\Safe\\imap_deletemailbox', 'imap_fetchstructure' => 'ExpressionEngine\\Dependency\\Safe\\imap_fetchstructure', 'imap_gc' => 'ExpressionEngine\\Dependency\\Safe\\imap_gc', 'imap_headerinfo' => 'ExpressionEngine\\Dependency\\Safe\\imap_headerinfo', 'imap_mail' => 'ExpressionEngine\\Dependency\\Safe\\imap_mail', 'imap_mailboxmsginfo' => 'ExpressionEngine\\Dependency\\Safe\\imap_mailboxmsginfo', 'imap_mail_compose' => 'ExpressionEngine\\Dependency\\Safe\\imap_mail_compose', 'imap_mail_copy' => 'ExpressionEngine\\Dependency\\Safe\\imap_mail_copy', 'imap_mail_move' => 'ExpressionEngine\\Dependency\\Safe\\imap_mail_move', 'imap_mutf7_to_utf8' => 'ExpressionEngine\\Dependency\\Safe\\imap_mutf7_to_utf8', 'imap_num_msg' => 'ExpressionEngine\\Dependency\\Safe\\imap_num_msg', 'imap_open' => 'ExpressionEngine\\Dependency\\Safe\\imap_open', 'imap_renamemailbox' => 'ExpressionEngine\\Dependency\\Safe\\imap_renamemailbox', 'imap_savebody' => 'ExpressionEngine\\Dependency\\Safe\\imap_savebody', 'imap_setacl' => 'ExpressionEngine\\Dependency\\Safe\\imap_setacl', 'imap_setflag_full' => 'ExpressionEngine\\Dependency\\Safe\\imap_setflag_full', 'imap_set_quota' => 'ExpressionEngine\\Dependency\\Safe\\imap_set_quota', 'imap_sort' => 'ExpressionEngine\\Dependency\\Safe\\imap_sort', 'imap_subscribe' => 'ExpressionEngine\\Dependency\\Safe\\imap_subscribe', 'imap_thread' => 'ExpressionEngine\\Dependency\\Safe\\imap_thread', 'imap_timeout' => 'ExpressionEngine\\Dependency\\Safe\\imap_timeout', 'imap_undelete' => 'ExpressionEngine\\Dependency\\Safe\\imap_undelete', 'imap_unsubscribe' => 'ExpressionEngine\\Dependency\\Safe\\imap_unsubscribe', 'imap_utf8_to_mutf7' => 'ExpressionEngine\\Dependency\\Safe\\imap_utf8_to_mutf7', 'inet_ntop' => 'ExpressionEngine\\Dependency\\Safe\\inet_ntop', 'inflate_add' => 'ExpressionEngine\\Dependency\\Safe\\inflate_add', 'inflate_get_read_len' => 'ExpressionEngine\\Dependency\\Safe\\inflate_get_read_len', 'inflate_get_status' => 'ExpressionEngine\\Dependency\\Safe\\inflate_get_status', 'inflate_init' => 'ExpressionEngine\\Dependency\\Safe\\inflate_init', 'ingres_autocommit' => 'ExpressionEngine\\Dependency\\Safe\\ingres_autocommit', 'ingres_close' => 'ExpressionEngine\\Dependency\\Safe\\ingres_close', 'ingres_commit' => 'ExpressionEngine\\Dependency\\Safe\\ingres_commit', 'ingres_connect' => 'ExpressionEngine\\Dependency\\Safe\\ingres_connect', 'ingres_execute' => 'ExpressionEngine\\Dependency\\Safe\\ingres_execute', 'ingres_field_name' => 'ExpressionEngine\\Dependency\\Safe\\ingres_field_name', 'ingres_field_type' => 'ExpressionEngine\\Dependency\\Safe\\ingres_field_type', 'ingres_free_result' => 'ExpressionEngine\\Dependency\\Safe\\ingres_free_result', 'ingres_pconnect' => 'ExpressionEngine\\Dependency\\Safe\\ingres_pconnect', 'ingres_result_seek' => 'ExpressionEngine\\Dependency\\Safe\\ingres_result_seek', 'ingres_rollback' => 'ExpressionEngine\\Dependency\\Safe\\ingres_rollback', 'ingres_set_environment' => 'ExpressionEngine\\Dependency\\Safe\\ingres_set_environment', 'ini_get' => 'ExpressionEngine\\Dependency\\Safe\\ini_get', 'ini_set' => 'ExpressionEngine\\Dependency\\Safe\\ini_set', 'inotify_init' => 'ExpressionEngine\\Dependency\\Safe\\inotify_init', 'inotify_rm_watch' => 'ExpressionEngine\\Dependency\\Safe\\inotify_rm_watch', 'iptcembed' => 'ExpressionEngine\\Dependency\\Safe\\iptcembed', 'iptcparse' => 'ExpressionEngine\\Dependency\\Safe\\iptcparse', 'jdtounix' => 'ExpressionEngine\\Dependency\\Safe\\jdtounix', 'jpeg2wbmp' => 'ExpressionEngine\\Dependency\\Safe\\jpeg2wbmp', 'json_decode' => 'ExpressionEngine\\Dependency\\Safe\\json_decode', 'json_encode' => 'ExpressionEngine\\Dependency\\Safe\\json_encode', 'json_last_error_msg' => 'ExpressionEngine\\Dependency\\Safe\\json_last_error_msg', 'krsort' => 'ExpressionEngine\\Dependency\\Safe\\krsort', 'ksort' => 'ExpressionEngine\\Dependency\\Safe\\ksort', 'lchgrp' => 'ExpressionEngine\\Dependency\\Safe\\lchgrp', 'lchown' => 'ExpressionEngine\\Dependency\\Safe\\lchown', 'ldap_add' => 'ExpressionEngine\\Dependency\\Safe\\ldap_add', 'ldap_add_ext' => 'ExpressionEngine\\Dependency\\Safe\\ldap_add_ext', 'ldap_bind' => 'ExpressionEngine\\Dependency\\Safe\\ldap_bind', 'ldap_bind_ext' => 'ExpressionEngine\\Dependency\\Safe\\ldap_bind_ext', 'ldap_control_paged_result' => 'ExpressionEngine\\Dependency\\Safe\\ldap_control_paged_result', 'ldap_control_paged_result_response' => 'ExpressionEngine\\Dependency\\Safe\\ldap_control_paged_result_response', 'ldap_count_entries' => 'ExpressionEngine\\Dependency\\Safe\\ldap_count_entries', 'ldap_delete' => 'ExpressionEngine\\Dependency\\Safe\\ldap_delete', 'ldap_delete_ext' => 'ExpressionEngine\\Dependency\\Safe\\ldap_delete_ext', 'ldap_exop' => 'ExpressionEngine\\Dependency\\Safe\\ldap_exop', 'ldap_exop_passwd' => 'ExpressionEngine\\Dependency\\Safe\\ldap_exop_passwd', 'ldap_exop_whoami' => 'ExpressionEngine\\Dependency\\Safe\\ldap_exop_whoami', 'ldap_explode_dn' => 'ExpressionEngine\\Dependency\\Safe\\ldap_explode_dn', 'ldap_first_attribute' => 'ExpressionEngine\\Dependency\\Safe\\ldap_first_attribute', 'ldap_first_entry' => 'ExpressionEngine\\Dependency\\Safe\\ldap_first_entry', 'ldap_free_result' => 'ExpressionEngine\\Dependency\\Safe\\ldap_free_result', 'ldap_get_attributes' => 'ExpressionEngine\\Dependency\\Safe\\ldap_get_attributes', 'ldap_get_dn' => 'ExpressionEngine\\Dependency\\Safe\\ldap_get_dn', 'ldap_get_entries' => 'ExpressionEngine\\Dependency\\Safe\\ldap_get_entries', 'ldap_get_option' => 'ExpressionEngine\\Dependency\\Safe\\ldap_get_option', 'ldap_get_values' => 'ExpressionEngine\\Dependency\\Safe\\ldap_get_values', 'ldap_get_values_len' => 'ExpressionEngine\\Dependency\\Safe\\ldap_get_values_len', 'ldap_list' => 'ExpressionEngine\\Dependency\\Safe\\ldap_list', 'ldap_modify_batch' => 'ExpressionEngine\\Dependency\\Safe\\ldap_modify_batch', 'ldap_mod_add' => 'ExpressionEngine\\Dependency\\Safe\\ldap_mod_add', 'ldap_mod_add_ext' => 'ExpressionEngine\\Dependency\\Safe\\ldap_mod_add_ext', 'ldap_mod_del' => 'ExpressionEngine\\Dependency\\Safe\\ldap_mod_del', 'ldap_mod_del_ext' => 'ExpressionEngine\\Dependency\\Safe\\ldap_mod_del_ext', 'ldap_mod_replace' => 'ExpressionEngine\\Dependency\\Safe\\ldap_mod_replace', 'ldap_mod_replace_ext' => 'ExpressionEngine\\Dependency\\Safe\\ldap_mod_replace_ext', 'ldap_next_attribute' => 'ExpressionEngine\\Dependency\\Safe\\ldap_next_attribute', 'ldap_parse_exop' => 'ExpressionEngine\\Dependency\\Safe\\ldap_parse_exop', 'ldap_parse_result' => 'ExpressionEngine\\Dependency\\Safe\\ldap_parse_result', 'ldap_read' => 'ExpressionEngine\\Dependency\\Safe\\ldap_read', 'ldap_rename' => 'ExpressionEngine\\Dependency\\Safe\\ldap_rename', 'ldap_rename_ext' => 'ExpressionEngine\\Dependency\\Safe\\ldap_rename_ext', 'ldap_sasl_bind' => 'ExpressionEngine\\Dependency\\Safe\\ldap_sasl_bind', 'ldap_search' => 'ExpressionEngine\\Dependency\\Safe\\ldap_search', 'ldap_set_option' => 'ExpressionEngine\\Dependency\\Safe\\ldap_set_option', 'ldap_unbind' => 'ExpressionEngine\\Dependency\\Safe\\ldap_unbind', 'libxml_get_last_error' => 'ExpressionEngine\\Dependency\\Safe\\libxml_get_last_error', 'libxml_set_external_entity_loader' => 'ExpressionEngine\\Dependency\\Safe\\libxml_set_external_entity_loader', 'link' => 'ExpressionEngine\\Dependency\\Safe\\link', 'lzf_compress' => 'ExpressionEngine\\Dependency\\Safe\\lzf_compress', 'lzf_decompress' => 'ExpressionEngine\\Dependency\\Safe\\lzf_decompress', 'mailparse_msg_extract_part_file' => 'ExpressionEngine\\Dependency\\Safe\\mailparse_msg_extract_part_file', 'mailparse_msg_free' => 'ExpressionEngine\\Dependency\\Safe\\mailparse_msg_free', 'mailparse_msg_parse' => 'ExpressionEngine\\Dependency\\Safe\\mailparse_msg_parse', 'mailparse_msg_parse_file' => 'ExpressionEngine\\Dependency\\Safe\\mailparse_msg_parse_file', 'mailparse_stream_encode' => 'ExpressionEngine\\Dependency\\Safe\\mailparse_stream_encode', 'mb_chr' => 'ExpressionEngine\\Dependency\\Safe\\mb_chr', 'mb_detect_order' => 'ExpressionEngine\\Dependency\\Safe\\mb_detect_order', 'mb_encoding_aliases' => 'ExpressionEngine\\Dependency\\Safe\\mb_encoding_aliases', 'mb_eregi_replace' => 'ExpressionEngine\\Dependency\\Safe\\mb_eregi_replace', 'mb_ereg_replace' => 'ExpressionEngine\\Dependency\\Safe\\mb_ereg_replace', 'mb_ereg_replace_callback' => 'ExpressionEngine\\Dependency\\Safe\\mb_ereg_replace_callback', 'mb_ereg_search_getregs' => 'ExpressionEngine\\Dependency\\Safe\\mb_ereg_search_getregs', 'mb_ereg_search_init' => 'ExpressionEngine\\Dependency\\Safe\\mb_ereg_search_init', 'mb_ereg_search_regs' => 'ExpressionEngine\\Dependency\\Safe\\mb_ereg_search_regs', 'mb_ereg_search_setpos' => 'ExpressionEngine\\Dependency\\Safe\\mb_ereg_search_setpos', 'mb_http_output' => 'ExpressionEngine\\Dependency\\Safe\\mb_http_output', 'mb_internal_encoding' => 'ExpressionEngine\\Dependency\\Safe\\mb_internal_encoding', 'mb_ord' => 'ExpressionEngine\\Dependency\\Safe\\mb_ord', 'mb_parse_str' => 'ExpressionEngine\\Dependency\\Safe\\mb_parse_str', 'mb_regex_encoding' => 'ExpressionEngine\\Dependency\\Safe\\mb_regex_encoding', 'mb_send_mail' => 'ExpressionEngine\\Dependency\\Safe\\mb_send_mail', 'mb_split' => 'ExpressionEngine\\Dependency\\Safe\\mb_split', 'mb_str_split' => 'ExpressionEngine\\Dependency\\Safe\\mb_str_split', 'md5_file' => 'ExpressionEngine\\Dependency\\Safe\\md5_file', 'metaphone' => 'ExpressionEngine\\Dependency\\Safe\\metaphone', 'mime_content_type' => 'ExpressionEngine\\Dependency\\Safe\\mime_content_type', 'mkdir' => 'ExpressionEngine\\Dependency\\Safe\\mkdir', 'mktime' => 'ExpressionEngine\\Dependency\\Safe\\mktime', 'msg_queue_exists' => 'ExpressionEngine\\Dependency\\Safe\\msg_queue_exists', 'msg_receive' => 'ExpressionEngine\\Dependency\\Safe\\msg_receive', 'msg_remove_queue' => 'ExpressionEngine\\Dependency\\Safe\\msg_remove_queue', 'msg_send' => 'ExpressionEngine\\Dependency\\Safe\\msg_send', 'msg_set_queue' => 'ExpressionEngine\\Dependency\\Safe\\msg_set_queue', 'msql_affected_rows' => 'ExpressionEngine\\Dependency\\Safe\\msql_affected_rows', 'msql_close' => 'ExpressionEngine\\Dependency\\Safe\\msql_close', 'msql_connect' => 'ExpressionEngine\\Dependency\\Safe\\msql_connect', 'msql_create_db' => 'ExpressionEngine\\Dependency\\Safe\\msql_create_db', 'msql_data_seek' => 'ExpressionEngine\\Dependency\\Safe\\msql_data_seek', 'msql_db_query' => 'ExpressionEngine\\Dependency\\Safe\\msql_db_query', 'msql_drop_db' => 'ExpressionEngine\\Dependency\\Safe\\msql_drop_db', 'msql_field_len' => 'ExpressionEngine\\Dependency\\Safe\\msql_field_len', 'msql_field_name' => 'ExpressionEngine\\Dependency\\Safe\\msql_field_name', 'msql_field_seek' => 'ExpressionEngine\\Dependency\\Safe\\msql_field_seek', 'msql_field_table' => 'ExpressionEngine\\Dependency\\Safe\\msql_field_table', 'msql_field_type' => 'ExpressionEngine\\Dependency\\Safe\\msql_field_type', 'msql_free_result' => 'ExpressionEngine\\Dependency\\Safe\\msql_free_result', 'msql_pconnect' => 'ExpressionEngine\\Dependency\\Safe\\msql_pconnect', 'msql_query' => 'ExpressionEngine\\Dependency\\Safe\\msql_query', 'msql_select_db' => 'ExpressionEngine\\Dependency\\Safe\\msql_select_db', 'mysqli_get_cache_stats' => 'ExpressionEngine\\Dependency\\Safe\\mysqli_get_cache_stats', 'mysqli_get_client_stats' => 'ExpressionEngine\\Dependency\\Safe\\mysqli_get_client_stats', 'mysqlnd_ms_dump_servers' => 'ExpressionEngine\\Dependency\\Safe\\mysqlnd_ms_dump_servers', 'mysqlnd_ms_fabric_select_global' => 'ExpressionEngine\\Dependency\\Safe\\mysqlnd_ms_fabric_select_global', 'mysqlnd_ms_fabric_select_shard' => 'ExpressionEngine\\Dependency\\Safe\\mysqlnd_ms_fabric_select_shard', 'mysqlnd_ms_get_last_used_connection' => 'ExpressionEngine\\Dependency\\Safe\\mysqlnd_ms_get_last_used_connection', 'mysqlnd_qc_clear_cache' => 'ExpressionEngine\\Dependency\\Safe\\mysqlnd_qc_clear_cache', 'mysqlnd_qc_set_is_select' => 'ExpressionEngine\\Dependency\\Safe\\mysqlnd_qc_set_is_select', 'mysqlnd_qc_set_storage_handler' => 'ExpressionEngine\\Dependency\\Safe\\mysqlnd_qc_set_storage_handler', 'mysql_close' => 'ExpressionEngine\\Dependency\\Safe\\mysql_close', 'mysql_connect' => 'ExpressionEngine\\Dependency\\Safe\\mysql_connect', 'mysql_create_db' => 'ExpressionEngine\\Dependency\\Safe\\mysql_create_db', 'mysql_data_seek' => 'ExpressionEngine\\Dependency\\Safe\\mysql_data_seek', 'mysql_db_name' => 'ExpressionEngine\\Dependency\\Safe\\mysql_db_name', 'mysql_db_query' => 'ExpressionEngine\\Dependency\\Safe\\mysql_db_query', 'mysql_drop_db' => 'ExpressionEngine\\Dependency\\Safe\\mysql_drop_db', 'mysql_fetch_lengths' => 'ExpressionEngine\\Dependency\\Safe\\mysql_fetch_lengths', 'mysql_field_flags' => 'ExpressionEngine\\Dependency\\Safe\\mysql_field_flags', 'mysql_field_len' => 'ExpressionEngine\\Dependency\\Safe\\mysql_field_len', 'mysql_field_name' => 'ExpressionEngine\\Dependency\\Safe\\mysql_field_name', 'mysql_field_seek' => 'ExpressionEngine\\Dependency\\Safe\\mysql_field_seek', 'mysql_free_result' => 'ExpressionEngine\\Dependency\\Safe\\mysql_free_result', 'mysql_get_host_info' => 'ExpressionEngine\\Dependency\\Safe\\mysql_get_host_info', 'mysql_get_proto_info' => 'ExpressionEngine\\Dependency\\Safe\\mysql_get_proto_info', 'mysql_get_server_info' => 'ExpressionEngine\\Dependency\\Safe\\mysql_get_server_info', 'mysql_info' => 'ExpressionEngine\\Dependency\\Safe\\mysql_info', 'mysql_list_dbs' => 'ExpressionEngine\\Dependency\\Safe\\mysql_list_dbs', 'mysql_list_fields' => 'ExpressionEngine\\Dependency\\Safe\\mysql_list_fields', 'mysql_list_processes' => 'ExpressionEngine\\Dependency\\Safe\\mysql_list_processes', 'mysql_list_tables' => 'ExpressionEngine\\Dependency\\Safe\\mysql_list_tables', 'mysql_num_fields' => 'ExpressionEngine\\Dependency\\Safe\\mysql_num_fields', 'mysql_num_rows' => 'ExpressionEngine\\Dependency\\Safe\\mysql_num_rows', 'mysql_query' => 'ExpressionEngine\\Dependency\\Safe\\mysql_query', 'mysql_real_escape_string' => 'ExpressionEngine\\Dependency\\Safe\\mysql_real_escape_string', 'mysql_result' => 'ExpressionEngine\\Dependency\\Safe\\mysql_result', 'mysql_select_db' => 'ExpressionEngine\\Dependency\\Safe\\mysql_select_db', 'mysql_set_charset' => 'ExpressionEngine\\Dependency\\Safe\\mysql_set_charset', 'mysql_tablename' => 'ExpressionEngine\\Dependency\\Safe\\mysql_tablename', 'mysql_thread_id' => 'ExpressionEngine\\Dependency\\Safe\\mysql_thread_id', 'mysql_unbuffered_query' => 'ExpressionEngine\\Dependency\\Safe\\mysql_unbuffered_query', 'natcasesort' => 'ExpressionEngine\\Dependency\\Safe\\natcasesort', 'natsort' => 'ExpressionEngine\\Dependency\\Safe\\natsort', 'ob_end_clean' => 'ExpressionEngine\\Dependency\\Safe\\ob_end_clean', 'ob_end_flush' => 'ExpressionEngine\\Dependency\\Safe\\ob_end_flush', 'oci_bind_array_by_name' => 'ExpressionEngine\\Dependency\\Safe\\oci_bind_array_by_name', 'oci_bind_by_name' => 'ExpressionEngine\\Dependency\\Safe\\oci_bind_by_name', 'oci_cancel' => 'ExpressionEngine\\Dependency\\Safe\\oci_cancel', 'oci_close' => 'ExpressionEngine\\Dependency\\Safe\\oci_close', 'oci_commit' => 'ExpressionEngine\\Dependency\\Safe\\oci_commit', 'oci_connect' => 'ExpressionEngine\\Dependency\\Safe\\oci_connect', 'oci_define_by_name' => 'ExpressionEngine\\Dependency\\Safe\\oci_define_by_name', 'oci_execute' => 'ExpressionEngine\\Dependency\\Safe\\oci_execute', 'oci_fetch_all' => 'ExpressionEngine\\Dependency\\Safe\\oci_fetch_all', 'oci_field_name' => 'ExpressionEngine\\Dependency\\Safe\\oci_field_name', 'oci_field_precision' => 'ExpressionEngine\\Dependency\\Safe\\oci_field_precision', 'oci_field_scale' => 'ExpressionEngine\\Dependency\\Safe\\oci_field_scale', 'oci_field_size' => 'ExpressionEngine\\Dependency\\Safe\\oci_field_size', 'oci_field_type' => 'ExpressionEngine\\Dependency\\Safe\\oci_field_type', 'oci_field_type_raw' => 'ExpressionEngine\\Dependency\\Safe\\oci_field_type_raw', 'oci_free_descriptor' => 'ExpressionEngine\\Dependency\\Safe\\oci_free_descriptor', 'oci_free_statement' => 'ExpressionEngine\\Dependency\\Safe\\oci_free_statement', 'oci_new_collection' => 'ExpressionEngine\\Dependency\\Safe\\oci_new_collection', 'oci_new_connect' => 'ExpressionEngine\\Dependency\\Safe\\oci_new_connect', 'oci_new_cursor' => 'ExpressionEngine\\Dependency\\Safe\\oci_new_cursor', 'oci_new_descriptor' => 'ExpressionEngine\\Dependency\\Safe\\oci_new_descriptor', 'oci_num_fields' => 'ExpressionEngine\\Dependency\\Safe\\oci_num_fields', 'oci_num_rows' => 'ExpressionEngine\\Dependency\\Safe\\oci_num_rows', 'oci_parse' => 'ExpressionEngine\\Dependency\\Safe\\oci_parse', 'oci_pconnect' => 'ExpressionEngine\\Dependency\\Safe\\oci_pconnect', 'oci_result' => 'ExpressionEngine\\Dependency\\Safe\\oci_result', 'oci_rollback' => 'ExpressionEngine\\Dependency\\Safe\\oci_rollback', 'oci_server_version' => 'ExpressionEngine\\Dependency\\Safe\\oci_server_version', 'oci_set_action' => 'ExpressionEngine\\Dependency\\Safe\\oci_set_action', 'oci_set_call_timeout' => 'ExpressionEngine\\Dependency\\Safe\\oci_set_call_timeout', 'oci_set_client_identifier' => 'ExpressionEngine\\Dependency\\Safe\\oci_set_client_identifier', 'oci_set_client_info' => 'ExpressionEngine\\Dependency\\Safe\\oci_set_client_info', 'oci_set_db_operation' => 'ExpressionEngine\\Dependency\\Safe\\oci_set_db_operation', 'oci_set_edition' => 'ExpressionEngine\\Dependency\\Safe\\oci_set_edition', 'oci_set_module_name' => 'ExpressionEngine\\Dependency\\Safe\\oci_set_module_name', 'oci_set_prefetch' => 'ExpressionEngine\\Dependency\\Safe\\oci_set_prefetch', 'oci_statement_type' => 'ExpressionEngine\\Dependency\\Safe\\oci_statement_type', 'oci_unregister_taf_callback' => 'ExpressionEngine\\Dependency\\Safe\\oci_unregister_taf_callback', 'odbc_autocommit' => 'ExpressionEngine\\Dependency\\Safe\\odbc_autocommit', 'odbc_binmode' => 'ExpressionEngine\\Dependency\\Safe\\odbc_binmode', 'odbc_columnprivileges' => 'ExpressionEngine\\Dependency\\Safe\\odbc_columnprivileges', 'odbc_columns' => 'ExpressionEngine\\Dependency\\Safe\\odbc_columns', 'odbc_commit' => 'ExpressionEngine\\Dependency\\Safe\\odbc_commit', 'odbc_data_source' => 'ExpressionEngine\\Dependency\\Safe\\odbc_data_source', 'odbc_exec' => 'ExpressionEngine\\Dependency\\Safe\\odbc_exec', 'odbc_execute' => 'ExpressionEngine\\Dependency\\Safe\\odbc_execute', 'odbc_fetch_into' => 'ExpressionEngine\\Dependency\\Safe\\odbc_fetch_into', 'odbc_field_len' => 'ExpressionEngine\\Dependency\\Safe\\odbc_field_len', 'odbc_field_name' => 'ExpressionEngine\\Dependency\\Safe\\odbc_field_name', 'odbc_field_num' => 'ExpressionEngine\\Dependency\\Safe\\odbc_field_num', 'odbc_field_scale' => 'ExpressionEngine\\Dependency\\Safe\\odbc_field_scale', 'odbc_field_type' => 'ExpressionEngine\\Dependency\\Safe\\odbc_field_type', 'odbc_foreignkeys' => 'ExpressionEngine\\Dependency\\Safe\\odbc_foreignkeys', 'odbc_gettypeinfo' => 'ExpressionEngine\\Dependency\\Safe\\odbc_gettypeinfo', 'odbc_longreadlen' => 'ExpressionEngine\\Dependency\\Safe\\odbc_longreadlen', 'odbc_prepare' => 'ExpressionEngine\\Dependency\\Safe\\odbc_prepare', 'odbc_primarykeys' => 'ExpressionEngine\\Dependency\\Safe\\odbc_primarykeys', 'odbc_result' => 'ExpressionEngine\\Dependency\\Safe\\odbc_result', 'odbc_result_all' => 'ExpressionEngine\\Dependency\\Safe\\odbc_result_all', 'odbc_rollback' => 'ExpressionEngine\\Dependency\\Safe\\odbc_rollback', 'odbc_setoption' => 'ExpressionEngine\\Dependency\\Safe\\odbc_setoption', 'odbc_specialcolumns' => 'ExpressionEngine\\Dependency\\Safe\\odbc_specialcolumns', 'odbc_statistics' => 'ExpressionEngine\\Dependency\\Safe\\odbc_statistics', 'odbc_tableprivileges' => 'ExpressionEngine\\Dependency\\Safe\\odbc_tableprivileges', 'odbc_tables' => 'ExpressionEngine\\Dependency\\Safe\\odbc_tables', 'opcache_compile_file' => 'ExpressionEngine\\Dependency\\Safe\\opcache_compile_file', 'opcache_get_status' => 'ExpressionEngine\\Dependency\\Safe\\opcache_get_status', 'opendir' => 'ExpressionEngine\\Dependency\\Safe\\opendir', 'openlog' => 'ExpressionEngine\\Dependency\\Safe\\openlog', 'openssl_cipher_iv_length' => 'ExpressionEngine\\Dependency\\Safe\\openssl_cipher_iv_length', 'openssl_csr_export' => 'ExpressionEngine\\Dependency\\Safe\\openssl_csr_export', 'openssl_csr_export_to_file' => 'ExpressionEngine\\Dependency\\Safe\\openssl_csr_export_to_file', 'openssl_csr_get_subject' => 'ExpressionEngine\\Dependency\\Safe\\openssl_csr_get_subject', 'openssl_csr_new' => 'ExpressionEngine\\Dependency\\Safe\\openssl_csr_new', 'openssl_csr_sign' => 'ExpressionEngine\\Dependency\\Safe\\openssl_csr_sign', 'openssl_decrypt' => 'ExpressionEngine\\Dependency\\Safe\\openssl_decrypt', 'openssl_dh_compute_key' => 'ExpressionEngine\\Dependency\\Safe\\openssl_dh_compute_key', 'openssl_digest' => 'ExpressionEngine\\Dependency\\Safe\\openssl_digest', 'openssl_encrypt' => 'ExpressionEngine\\Dependency\\Safe\\openssl_encrypt', 'openssl_open' => 'ExpressionEngine\\Dependency\\Safe\\openssl_open', 'openssl_pbkdf2' => 'ExpressionEngine\\Dependency\\Safe\\openssl_pbkdf2', 'openssl_pkcs7_decrypt' => 'ExpressionEngine\\Dependency\\Safe\\openssl_pkcs7_decrypt', 'openssl_pkcs7_encrypt' => 'ExpressionEngine\\Dependency\\Safe\\openssl_pkcs7_encrypt', 'openssl_pkcs7_read' => 'ExpressionEngine\\Dependency\\Safe\\openssl_pkcs7_read', 'openssl_pkcs7_sign' => 'ExpressionEngine\\Dependency\\Safe\\openssl_pkcs7_sign', 'openssl_pkcs12_export' => 'ExpressionEngine\\Dependency\\Safe\\openssl_pkcs12_export', 'openssl_pkcs12_export_to_file' => 'ExpressionEngine\\Dependency\\Safe\\openssl_pkcs12_export_to_file', 'openssl_pkcs12_read' => 'ExpressionEngine\\Dependency\\Safe\\openssl_pkcs12_read', 'openssl_pkey_export' => 'ExpressionEngine\\Dependency\\Safe\\openssl_pkey_export', 'openssl_pkey_export_to_file' => 'ExpressionEngine\\Dependency\\Safe\\openssl_pkey_export_to_file', 'openssl_pkey_get_private' => 'ExpressionEngine\\Dependency\\Safe\\openssl_pkey_get_private', 'openssl_pkey_get_public' => 'ExpressionEngine\\Dependency\\Safe\\openssl_pkey_get_public', 'openssl_pkey_new' => 'ExpressionEngine\\Dependency\\Safe\\openssl_pkey_new', 'openssl_private_decrypt' => 'ExpressionEngine\\Dependency\\Safe\\openssl_private_decrypt', 'openssl_private_encrypt' => 'ExpressionEngine\\Dependency\\Safe\\openssl_private_encrypt', 'openssl_public_decrypt' => 'ExpressionEngine\\Dependency\\Safe\\openssl_public_decrypt', 'openssl_public_encrypt' => 'ExpressionEngine\\Dependency\\Safe\\openssl_public_encrypt', 'openssl_random_pseudo_bytes' => 'ExpressionEngine\\Dependency\\Safe\\openssl_random_pseudo_bytes', 'openssl_seal' => 'ExpressionEngine\\Dependency\\Safe\\openssl_seal', 'openssl_sign' => 'ExpressionEngine\\Dependency\\Safe\\openssl_sign', 'openssl_x509_export' => 'ExpressionEngine\\Dependency\\Safe\\openssl_x509_export', 'openssl_x509_export_to_file' => 'ExpressionEngine\\Dependency\\Safe\\openssl_x509_export_to_file', 'openssl_x509_fingerprint' => 'ExpressionEngine\\Dependency\\Safe\\openssl_x509_fingerprint', 'openssl_x509_read' => 'ExpressionEngine\\Dependency\\Safe\\openssl_x509_read', 'output_add_rewrite_var' => 'ExpressionEngine\\Dependency\\Safe\\output_add_rewrite_var', 'output_reset_rewrite_vars' => 'ExpressionEngine\\Dependency\\Safe\\output_reset_rewrite_vars', 'pack' => 'ExpressionEngine\\Dependency\\Safe\\pack', 'parse_ini_file' => 'ExpressionEngine\\Dependency\\Safe\\parse_ini_file', 'parse_ini_string' => 'ExpressionEngine\\Dependency\\Safe\\parse_ini_string', 'parse_url' => 'ExpressionEngine\\Dependency\\Safe\\parse_url', 'password_hash' => 'ExpressionEngine\\Dependency\\Safe\\password_hash', 'pcntl_exec' => 'ExpressionEngine\\Dependency\\Safe\\pcntl_exec', 'pcntl_getpriority' => 'ExpressionEngine\\Dependency\\Safe\\pcntl_getpriority', 'pcntl_setpriority' => 'ExpressionEngine\\Dependency\\Safe\\pcntl_setpriority', 'pcntl_signal_dispatch' => 'ExpressionEngine\\Dependency\\Safe\\pcntl_signal_dispatch', 'pcntl_sigprocmask' => 'ExpressionEngine\\Dependency\\Safe\\pcntl_sigprocmask', 'pcntl_strerror' => 'ExpressionEngine\\Dependency\\Safe\\pcntl_strerror', 'PDF_activate_item' => 'ExpressionEngine\\Dependency\\Safe\\PDF_activate_item', 'PDF_add_locallink' => 'ExpressionEngine\\Dependency\\Safe\\PDF_add_locallink', 'PDF_add_nameddest' => 'ExpressionEngine\\Dependency\\Safe\\PDF_add_nameddest', 'PDF_add_note' => 'ExpressionEngine\\Dependency\\Safe\\PDF_add_note', 'PDF_add_pdflink' => 'ExpressionEngine\\Dependency\\Safe\\PDF_add_pdflink', 'PDF_add_thumbnail' => 'ExpressionEngine\\Dependency\\Safe\\PDF_add_thumbnail', 'PDF_add_weblink' => 'ExpressionEngine\\Dependency\\Safe\\PDF_add_weblink', 'PDF_attach_file' => 'ExpressionEngine\\Dependency\\Safe\\PDF_attach_file', 'PDF_begin_layer' => 'ExpressionEngine\\Dependency\\Safe\\PDF_begin_layer', 'PDF_begin_page' => 'ExpressionEngine\\Dependency\\Safe\\PDF_begin_page', 'PDF_begin_page_ext' => 'ExpressionEngine\\Dependency\\Safe\\PDF_begin_page_ext', 'PDF_circle' => 'ExpressionEngine\\Dependency\\Safe\\PDF_circle', 'PDF_clip' => 'ExpressionEngine\\Dependency\\Safe\\PDF_clip', 'PDF_close' => 'ExpressionEngine\\Dependency\\Safe\\PDF_close', 'PDF_closepath' => 'ExpressionEngine\\Dependency\\Safe\\PDF_closepath', 'PDF_closepath_fill_stroke' => 'ExpressionEngine\\Dependency\\Safe\\PDF_closepath_fill_stroke', 'PDF_closepath_stroke' => 'ExpressionEngine\\Dependency\\Safe\\PDF_closepath_stroke', 'PDF_close_pdi' => 'ExpressionEngine\\Dependency\\Safe\\PDF_close_pdi', 'PDF_close_pdi_page' => 'ExpressionEngine\\Dependency\\Safe\\PDF_close_pdi_page', 'PDF_concat' => 'ExpressionEngine\\Dependency\\Safe\\PDF_concat', 'PDF_continue_text' => 'ExpressionEngine\\Dependency\\Safe\\PDF_continue_text', 'PDF_curveto' => 'ExpressionEngine\\Dependency\\Safe\\PDF_curveto', 'PDF_delete' => 'ExpressionEngine\\Dependency\\Safe\\PDF_delete', 'PDF_end_layer' => 'ExpressionEngine\\Dependency\\Safe\\PDF_end_layer', 'PDF_end_page' => 'ExpressionEngine\\Dependency\\Safe\\PDF_end_page', 'PDF_end_page_ext' => 'ExpressionEngine\\Dependency\\Safe\\PDF_end_page_ext', 'PDF_end_pattern' => 'ExpressionEngine\\Dependency\\Safe\\PDF_end_pattern', 'PDF_end_template' => 'ExpressionEngine\\Dependency\\Safe\\PDF_end_template', 'PDF_fill' => 'ExpressionEngine\\Dependency\\Safe\\PDF_fill', 'PDF_fill_stroke' => 'ExpressionEngine\\Dependency\\Safe\\PDF_fill_stroke', 'PDF_fit_image' => 'ExpressionEngine\\Dependency\\Safe\\PDF_fit_image', 'PDF_fit_pdi_page' => 'ExpressionEngine\\Dependency\\Safe\\PDF_fit_pdi_page', 'PDF_fit_textline' => 'ExpressionEngine\\Dependency\\Safe\\PDF_fit_textline', 'PDF_initgraphics' => 'ExpressionEngine\\Dependency\\Safe\\PDF_initgraphics', 'PDF_lineto' => 'ExpressionEngine\\Dependency\\Safe\\PDF_lineto', 'PDF_makespotcolor' => 'ExpressionEngine\\Dependency\\Safe\\PDF_makespotcolor', 'PDF_moveto' => 'ExpressionEngine\\Dependency\\Safe\\PDF_moveto', 'PDF_open_file' => 'ExpressionEngine\\Dependency\\Safe\\PDF_open_file', 'PDF_place_image' => 'ExpressionEngine\\Dependency\\Safe\\PDF_place_image', 'PDF_place_pdi_page' => 'ExpressionEngine\\Dependency\\Safe\\PDF_place_pdi_page', 'PDF_rect' => 'ExpressionEngine\\Dependency\\Safe\\PDF_rect', 'PDF_restore' => 'ExpressionEngine\\Dependency\\Safe\\PDF_restore', 'PDF_rotate' => 'ExpressionEngine\\Dependency\\Safe\\PDF_rotate', 'PDF_save' => 'ExpressionEngine\\Dependency\\Safe\\PDF_save', 'PDF_scale' => 'ExpressionEngine\\Dependency\\Safe\\PDF_scale', 'PDF_setcolor' => 'ExpressionEngine\\Dependency\\Safe\\PDF_setcolor', 'PDF_setdash' => 'ExpressionEngine\\Dependency\\Safe\\PDF_setdash', 'PDF_setdashpattern' => 'ExpressionEngine\\Dependency\\Safe\\PDF_setdashpattern', 'PDF_setflat' => 'ExpressionEngine\\Dependency\\Safe\\PDF_setflat', 'PDF_setfont' => 'ExpressionEngine\\Dependency\\Safe\\PDF_setfont', 'PDF_setgray' => 'ExpressionEngine\\Dependency\\Safe\\PDF_setgray', 'PDF_setgray_fill' => 'ExpressionEngine\\Dependency\\Safe\\PDF_setgray_fill', 'PDF_setgray_stroke' => 'ExpressionEngine\\Dependency\\Safe\\PDF_setgray_stroke', 'PDF_setlinejoin' => 'ExpressionEngine\\Dependency\\Safe\\PDF_setlinejoin', 'PDF_setlinewidth' => 'ExpressionEngine\\Dependency\\Safe\\PDF_setlinewidth', 'PDF_setmatrix' => 'ExpressionEngine\\Dependency\\Safe\\PDF_setmatrix', 'PDF_setmiterlimit' => 'ExpressionEngine\\Dependency\\Safe\\PDF_setmiterlimit', 'PDF_setrgbcolor' => 'ExpressionEngine\\Dependency\\Safe\\PDF_setrgbcolor', 'PDF_setrgbcolor_fill' => 'ExpressionEngine\\Dependency\\Safe\\PDF_setrgbcolor_fill', 'PDF_setrgbcolor_stroke' => 'ExpressionEngine\\Dependency\\Safe\\PDF_setrgbcolor_stroke', 'PDF_set_border_color' => 'ExpressionEngine\\Dependency\\Safe\\PDF_set_border_color', 'PDF_set_border_dash' => 'ExpressionEngine\\Dependency\\Safe\\PDF_set_border_dash', 'PDF_set_border_style' => 'ExpressionEngine\\Dependency\\Safe\\PDF_set_border_style', 'PDF_set_info' => 'ExpressionEngine\\Dependency\\Safe\\PDF_set_info', 'PDF_set_layer_dependency' => 'ExpressionEngine\\Dependency\\Safe\\PDF_set_layer_dependency', 'PDF_set_parameter' => 'ExpressionEngine\\Dependency\\Safe\\PDF_set_parameter', 'PDF_set_text_pos' => 'ExpressionEngine\\Dependency\\Safe\\PDF_set_text_pos', 'PDF_set_value' => 'ExpressionEngine\\Dependency\\Safe\\PDF_set_value', 'PDF_show' => 'ExpressionEngine\\Dependency\\Safe\\PDF_show', 'PDF_show_xy' => 'ExpressionEngine\\Dependency\\Safe\\PDF_show_xy', 'PDF_skew' => 'ExpressionEngine\\Dependency\\Safe\\PDF_skew', 'PDF_stroke' => 'ExpressionEngine\\Dependency\\Safe\\PDF_stroke', 'pg_cancel_query' => 'ExpressionEngine\\Dependency\\Safe\\pg_cancel_query', 'pg_client_encoding' => 'ExpressionEngine\\Dependency\\Safe\\pg_client_encoding', 'pg_close' => 'ExpressionEngine\\Dependency\\Safe\\pg_close', 'pg_connect' => 'ExpressionEngine\\Dependency\\Safe\\pg_connect', 'pg_connection_reset' => 'ExpressionEngine\\Dependency\\Safe\\pg_connection_reset', 'pg_convert' => 'ExpressionEngine\\Dependency\\Safe\\pg_convert', 'pg_copy_from' => 'ExpressionEngine\\Dependency\\Safe\\pg_copy_from', 'pg_copy_to' => 'ExpressionEngine\\Dependency\\Safe\\pg_copy_to', 'pg_dbname' => 'ExpressionEngine\\Dependency\\Safe\\pg_dbname', 'pg_delete' => 'ExpressionEngine\\Dependency\\Safe\\pg_delete', 'pg_end_copy' => 'ExpressionEngine\\Dependency\\Safe\\pg_end_copy', 'pg_execute' => 'ExpressionEngine\\Dependency\\Safe\\pg_execute', 'pg_field_name' => 'ExpressionEngine\\Dependency\\Safe\\pg_field_name', 'pg_field_table' => 'ExpressionEngine\\Dependency\\Safe\\pg_field_table', 'pg_field_type' => 'ExpressionEngine\\Dependency\\Safe\\pg_field_type', 'pg_flush' => 'ExpressionEngine\\Dependency\\Safe\\pg_flush', 'pg_free_result' => 'ExpressionEngine\\Dependency\\Safe\\pg_free_result', 'pg_host' => 'ExpressionEngine\\Dependency\\Safe\\pg_host', 'pg_insert' => 'ExpressionEngine\\Dependency\\Safe\\pg_insert', 'pg_last_error' => 'ExpressionEngine\\Dependency\\Safe\\pg_last_error', 'pg_last_notice' => 'ExpressionEngine\\Dependency\\Safe\\pg_last_notice', 'pg_last_oid' => 'ExpressionEngine\\Dependency\\Safe\\pg_last_oid', 'pg_lo_close' => 'ExpressionEngine\\Dependency\\Safe\\pg_lo_close', 'pg_lo_export' => 'ExpressionEngine\\Dependency\\Safe\\pg_lo_export', 'pg_lo_import' => 'ExpressionEngine\\Dependency\\Safe\\pg_lo_import', 'pg_lo_open' => 'ExpressionEngine\\Dependency\\Safe\\pg_lo_open', 'pg_lo_read' => 'ExpressionEngine\\Dependency\\Safe\\pg_lo_read', 'pg_lo_read_all' => 'ExpressionEngine\\Dependency\\Safe\\pg_lo_read_all', 'pg_lo_seek' => 'ExpressionEngine\\Dependency\\Safe\\pg_lo_seek', 'pg_lo_truncate' => 'ExpressionEngine\\Dependency\\Safe\\pg_lo_truncate', 'pg_lo_unlink' => 'ExpressionEngine\\Dependency\\Safe\\pg_lo_unlink', 'pg_lo_write' => 'ExpressionEngine\\Dependency\\Safe\\pg_lo_write', 'pg_meta_data' => 'ExpressionEngine\\Dependency\\Safe\\pg_meta_data', 'pg_options' => 'ExpressionEngine\\Dependency\\Safe\\pg_options', 'pg_parameter_status' => 'ExpressionEngine\\Dependency\\Safe\\pg_parameter_status', 'pg_pconnect' => 'ExpressionEngine\\Dependency\\Safe\\pg_pconnect', 'pg_ping' => 'ExpressionEngine\\Dependency\\Safe\\pg_ping', 'pg_port' => 'ExpressionEngine\\Dependency\\Safe\\pg_port', 'pg_prepare' => 'ExpressionEngine\\Dependency\\Safe\\pg_prepare', 'pg_put_line' => 'ExpressionEngine\\Dependency\\Safe\\pg_put_line', 'pg_query' => 'ExpressionEngine\\Dependency\\Safe\\pg_query', 'pg_query_params' => 'ExpressionEngine\\Dependency\\Safe\\pg_query_params', 'pg_result_error_field' => 'ExpressionEngine\\Dependency\\Safe\\pg_result_error_field', 'pg_result_seek' => 'ExpressionEngine\\Dependency\\Safe\\pg_result_seek', 'pg_select' => 'ExpressionEngine\\Dependency\\Safe\\pg_select', 'pg_send_execute' => 'ExpressionEngine\\Dependency\\Safe\\pg_send_execute', 'pg_send_prepare' => 'ExpressionEngine\\Dependency\\Safe\\pg_send_prepare', 'pg_send_query' => 'ExpressionEngine\\Dependency\\Safe\\pg_send_query', 'pg_send_query_params' => 'ExpressionEngine\\Dependency\\Safe\\pg_send_query_params', 'pg_socket' => 'ExpressionEngine\\Dependency\\Safe\\pg_socket', 'pg_trace' => 'ExpressionEngine\\Dependency\\Safe\\pg_trace', 'pg_tty' => 'ExpressionEngine\\Dependency\\Safe\\pg_tty', 'pg_update' => 'ExpressionEngine\\Dependency\\Safe\\pg_update', 'pg_version' => 'ExpressionEngine\\Dependency\\Safe\\pg_version', 'phpcredits' => 'ExpressionEngine\\Dependency\\Safe\\phpcredits', 'phpinfo' => 'ExpressionEngine\\Dependency\\Safe\\phpinfo', 'png2wbmp' => 'ExpressionEngine\\Dependency\\Safe\\png2wbmp', 'posix_access' => 'ExpressionEngine\\Dependency\\Safe\\posix_access', 'posix_getgrnam' => 'ExpressionEngine\\Dependency\\Safe\\posix_getgrnam', 'posix_getpgid' => 'ExpressionEngine\\Dependency\\Safe\\posix_getpgid', 'posix_initgroups' => 'ExpressionEngine\\Dependency\\Safe\\posix_initgroups', 'posix_kill' => 'ExpressionEngine\\Dependency\\Safe\\posix_kill', 'posix_mkfifo' => 'ExpressionEngine\\Dependency\\Safe\\posix_mkfifo', 'posix_mknod' => 'ExpressionEngine\\Dependency\\Safe\\posix_mknod', 'posix_setegid' => 'ExpressionEngine\\Dependency\\Safe\\posix_setegid', 'posix_seteuid' => 'ExpressionEngine\\Dependency\\Safe\\posix_seteuid', 'posix_setgid' => 'ExpressionEngine\\Dependency\\Safe\\posix_setgid', 'posix_setpgid' => 'ExpressionEngine\\Dependency\\Safe\\posix_setpgid', 'posix_setrlimit' => 'ExpressionEngine\\Dependency\\Safe\\posix_setrlimit', 'posix_setuid' => 'ExpressionEngine\\Dependency\\Safe\\posix_setuid', 'preg_match' => 'ExpressionEngine\\Dependency\\Safe\\preg_match', 'preg_match_all' => 'ExpressionEngine\\Dependency\\Safe\\preg_match_all', 'preg_replace' => 'ExpressionEngine\\Dependency\\Safe\\preg_replace', 'preg_split' => 'ExpressionEngine\\Dependency\\Safe\\preg_split', 'proc_get_status' => 'ExpressionEngine\\Dependency\\Safe\\proc_get_status', 'proc_nice' => 'ExpressionEngine\\Dependency\\Safe\\proc_nice', 'pspell_add_to_personal' => 'ExpressionEngine\\Dependency\\Safe\\pspell_add_to_personal', 'pspell_add_to_session' => 'ExpressionEngine\\Dependency\\Safe\\pspell_add_to_session', 'pspell_clear_session' => 'ExpressionEngine\\Dependency\\Safe\\pspell_clear_session', 'pspell_config_create' => 'ExpressionEngine\\Dependency\\Safe\\pspell_config_create', 'pspell_config_data_dir' => 'ExpressionEngine\\Dependency\\Safe\\pspell_config_data_dir', 'pspell_config_dict_dir' => 'ExpressionEngine\\Dependency\\Safe\\pspell_config_dict_dir', 'pspell_config_ignore' => 'ExpressionEngine\\Dependency\\Safe\\pspell_config_ignore', 'pspell_config_mode' => 'ExpressionEngine\\Dependency\\Safe\\pspell_config_mode', 'pspell_config_personal' => 'ExpressionEngine\\Dependency\\Safe\\pspell_config_personal', 'pspell_config_repl' => 'ExpressionEngine\\Dependency\\Safe\\pspell_config_repl', 'pspell_config_runtogether' => 'ExpressionEngine\\Dependency\\Safe\\pspell_config_runtogether', 'pspell_config_save_repl' => 'ExpressionEngine\\Dependency\\Safe\\pspell_config_save_repl', 'pspell_new' => 'ExpressionEngine\\Dependency\\Safe\\pspell_new', 'pspell_new_config' => 'ExpressionEngine\\Dependency\\Safe\\pspell_new_config', 'pspell_save_wordlist' => 'ExpressionEngine\\Dependency\\Safe\\pspell_save_wordlist', 'pspell_store_replacement' => 'ExpressionEngine\\Dependency\\Safe\\pspell_store_replacement', 'ps_add_launchlink' => 'ExpressionEngine\\Dependency\\Safe\\ps_add_launchlink', 'ps_add_locallink' => 'ExpressionEngine\\Dependency\\Safe\\ps_add_locallink', 'ps_add_note' => 'ExpressionEngine\\Dependency\\Safe\\ps_add_note', 'ps_add_pdflink' => 'ExpressionEngine\\Dependency\\Safe\\ps_add_pdflink', 'ps_add_weblink' => 'ExpressionEngine\\Dependency\\Safe\\ps_add_weblink', 'ps_arc' => 'ExpressionEngine\\Dependency\\Safe\\ps_arc', 'ps_arcn' => 'ExpressionEngine\\Dependency\\Safe\\ps_arcn', 'ps_begin_page' => 'ExpressionEngine\\Dependency\\Safe\\ps_begin_page', 'ps_begin_pattern' => 'ExpressionEngine\\Dependency\\Safe\\ps_begin_pattern', 'ps_begin_template' => 'ExpressionEngine\\Dependency\\Safe\\ps_begin_template', 'ps_circle' => 'ExpressionEngine\\Dependency\\Safe\\ps_circle', 'ps_clip' => 'ExpressionEngine\\Dependency\\Safe\\ps_clip', 'ps_close' => 'ExpressionEngine\\Dependency\\Safe\\ps_close', 'ps_closepath' => 'ExpressionEngine\\Dependency\\Safe\\ps_closepath', 'ps_closepath_stroke' => 'ExpressionEngine\\Dependency\\Safe\\ps_closepath_stroke', 'ps_close_image' => 'ExpressionEngine\\Dependency\\Safe\\ps_close_image', 'ps_continue_text' => 'ExpressionEngine\\Dependency\\Safe\\ps_continue_text', 'ps_curveto' => 'ExpressionEngine\\Dependency\\Safe\\ps_curveto', 'ps_delete' => 'ExpressionEngine\\Dependency\\Safe\\ps_delete', 'ps_end_page' => 'ExpressionEngine\\Dependency\\Safe\\ps_end_page', 'ps_end_pattern' => 'ExpressionEngine\\Dependency\\Safe\\ps_end_pattern', 'ps_end_template' => 'ExpressionEngine\\Dependency\\Safe\\ps_end_template', 'ps_fill' => 'ExpressionEngine\\Dependency\\Safe\\ps_fill', 'ps_fill_stroke' => 'ExpressionEngine\\Dependency\\Safe\\ps_fill_stroke', 'ps_get_parameter' => 'ExpressionEngine\\Dependency\\Safe\\ps_get_parameter', 'ps_hyphenate' => 'ExpressionEngine\\Dependency\\Safe\\ps_hyphenate', 'ps_include_file' => 'ExpressionEngine\\Dependency\\Safe\\ps_include_file', 'ps_lineto' => 'ExpressionEngine\\Dependency\\Safe\\ps_lineto', 'ps_moveto' => 'ExpressionEngine\\Dependency\\Safe\\ps_moveto', 'ps_new' => 'ExpressionEngine\\Dependency\\Safe\\ps_new', 'ps_open_file' => 'ExpressionEngine\\Dependency\\Safe\\ps_open_file', 'ps_place_image' => 'ExpressionEngine\\Dependency\\Safe\\ps_place_image', 'ps_rect' => 'ExpressionEngine\\Dependency\\Safe\\ps_rect', 'ps_restore' => 'ExpressionEngine\\Dependency\\Safe\\ps_restore', 'ps_rotate' => 'ExpressionEngine\\Dependency\\Safe\\ps_rotate', 'ps_save' => 'ExpressionEngine\\Dependency\\Safe\\ps_save', 'ps_scale' => 'ExpressionEngine\\Dependency\\Safe\\ps_scale', 'ps_setcolor' => 'ExpressionEngine\\Dependency\\Safe\\ps_setcolor', 'ps_setdash' => 'ExpressionEngine\\Dependency\\Safe\\ps_setdash', 'ps_setflat' => 'ExpressionEngine\\Dependency\\Safe\\ps_setflat', 'ps_setfont' => 'ExpressionEngine\\Dependency\\Safe\\ps_setfont', 'ps_setgray' => 'ExpressionEngine\\Dependency\\Safe\\ps_setgray', 'ps_setlinecap' => 'ExpressionEngine\\Dependency\\Safe\\ps_setlinecap', 'ps_setlinejoin' => 'ExpressionEngine\\Dependency\\Safe\\ps_setlinejoin', 'ps_setlinewidth' => 'ExpressionEngine\\Dependency\\Safe\\ps_setlinewidth', 'ps_setmiterlimit' => 'ExpressionEngine\\Dependency\\Safe\\ps_setmiterlimit', 'ps_setoverprintmode' => 'ExpressionEngine\\Dependency\\Safe\\ps_setoverprintmode', 'ps_setpolydash' => 'ExpressionEngine\\Dependency\\Safe\\ps_setpolydash', 'ps_set_border_color' => 'ExpressionEngine\\Dependency\\Safe\\ps_set_border_color', 'ps_set_border_dash' => 'ExpressionEngine\\Dependency\\Safe\\ps_set_border_dash', 'ps_set_border_style' => 'ExpressionEngine\\Dependency\\Safe\\ps_set_border_style', 'ps_set_info' => 'ExpressionEngine\\Dependency\\Safe\\ps_set_info', 'ps_set_parameter' => 'ExpressionEngine\\Dependency\\Safe\\ps_set_parameter', 'ps_set_text_pos' => 'ExpressionEngine\\Dependency\\Safe\\ps_set_text_pos', 'ps_set_value' => 'ExpressionEngine\\Dependency\\Safe\\ps_set_value', 'ps_shading' => 'ExpressionEngine\\Dependency\\Safe\\ps_shading', 'ps_shading_pattern' => 'ExpressionEngine\\Dependency\\Safe\\ps_shading_pattern', 'ps_shfill' => 'ExpressionEngine\\Dependency\\Safe\\ps_shfill', 'ps_show' => 'ExpressionEngine\\Dependency\\Safe\\ps_show', 'ps_show2' => 'ExpressionEngine\\Dependency\\Safe\\ps_show2', 'ps_show_xy' => 'ExpressionEngine\\Dependency\\Safe\\ps_show_xy', 'ps_show_xy2' => 'ExpressionEngine\\Dependency\\Safe\\ps_show_xy2', 'ps_stroke' => 'ExpressionEngine\\Dependency\\Safe\\ps_stroke', 'ps_symbol' => 'ExpressionEngine\\Dependency\\Safe\\ps_symbol', 'ps_translate' => 'ExpressionEngine\\Dependency\\Safe\\ps_translate', 'putenv' => 'ExpressionEngine\\Dependency\\Safe\\putenv', 'readfile' => 'ExpressionEngine\\Dependency\\Safe\\readfile', 'readgzfile' => 'ExpressionEngine\\Dependency\\Safe\\readgzfile', 'readline_add_history' => 'ExpressionEngine\\Dependency\\Safe\\readline_add_history', 'readline_callback_handler_install' => 'ExpressionEngine\\Dependency\\Safe\\readline_callback_handler_install', 'readline_clear_history' => 'ExpressionEngine\\Dependency\\Safe\\readline_clear_history', 'readline_completion_function' => 'ExpressionEngine\\Dependency\\Safe\\readline_completion_function', 'readline_read_history' => 'ExpressionEngine\\Dependency\\Safe\\readline_read_history', 'readline_write_history' => 'ExpressionEngine\\Dependency\\Safe\\readline_write_history', 'readlink' => 'ExpressionEngine\\Dependency\\Safe\\readlink', 'realpath' => 'ExpressionEngine\\Dependency\\Safe\\realpath', 'register_tick_function' => 'ExpressionEngine\\Dependency\\Safe\\register_tick_function', 'rename' => 'ExpressionEngine\\Dependency\\Safe\\rename', 'rewind' => 'ExpressionEngine\\Dependency\\Safe\\rewind', 'rewinddir' => 'ExpressionEngine\\Dependency\\Safe\\rewinddir', 'rmdir' => 'ExpressionEngine\\Dependency\\Safe\\rmdir', 'rpmaddtag' => 'ExpressionEngine\\Dependency\\Safe\\rpmaddtag', 'rrd_create' => 'ExpressionEngine\\Dependency\\Safe\\rrd_create', 'rsort' => 'ExpressionEngine\\Dependency\\Safe\\rsort', 'sapi_windows_cp_conv' => 'ExpressionEngine\\Dependency\\Safe\\sapi_windows_cp_conv', 'sapi_windows_cp_set' => 'ExpressionEngine\\Dependency\\Safe\\sapi_windows_cp_set', 'sapi_windows_generate_ctrl_event' => 'ExpressionEngine\\Dependency\\Safe\\sapi_windows_generate_ctrl_event', 'sapi_windows_vt100_support' => 'ExpressionEngine\\Dependency\\Safe\\sapi_windows_vt100_support', 'scandir' => 'ExpressionEngine\\Dependency\\Safe\\scandir', 'sem_acquire' => 'ExpressionEngine\\Dependency\\Safe\\sem_acquire', 'sem_get' => 'ExpressionEngine\\Dependency\\Safe\\sem_get', 'sem_release' => 'ExpressionEngine\\Dependency\\Safe\\sem_release', 'sem_remove' => 'ExpressionEngine\\Dependency\\Safe\\sem_remove', 'session_abort' => 'ExpressionEngine\\Dependency\\Safe\\session_abort', 'session_decode' => 'ExpressionEngine\\Dependency\\Safe\\session_decode', 'session_destroy' => 'ExpressionEngine\\Dependency\\Safe\\session_destroy', 'session_regenerate_id' => 'ExpressionEngine\\Dependency\\Safe\\session_regenerate_id', 'session_reset' => 'ExpressionEngine\\Dependency\\Safe\\session_reset', 'session_unset' => 'ExpressionEngine\\Dependency\\Safe\\session_unset', 'session_write_close' => 'ExpressionEngine\\Dependency\\Safe\\session_write_close', 'settype' => 'ExpressionEngine\\Dependency\\Safe\\settype', 'set_include_path' => 'ExpressionEngine\\Dependency\\Safe\\set_include_path', 'set_time_limit' => 'ExpressionEngine\\Dependency\\Safe\\set_time_limit', 'sha1_file' => 'ExpressionEngine\\Dependency\\Safe\\sha1_file', 'shmop_delete' => 'ExpressionEngine\\Dependency\\Safe\\shmop_delete', 'shmop_read' => 'ExpressionEngine\\Dependency\\Safe\\shmop_read', 'shmop_write' => 'ExpressionEngine\\Dependency\\Safe\\shmop_write', 'shm_put_var' => 'ExpressionEngine\\Dependency\\Safe\\shm_put_var', 'shm_remove' => 'ExpressionEngine\\Dependency\\Safe\\shm_remove', 'shm_remove_var' => 'ExpressionEngine\\Dependency\\Safe\\shm_remove_var', 'shuffle' => 'ExpressionEngine\\Dependency\\Safe\\shuffle', 'simplexml_import_dom' => 'ExpressionEngine\\Dependency\\Safe\\simplexml_import_dom', 'simplexml_load_file' => 'ExpressionEngine\\Dependency\\Safe\\simplexml_load_file', 'simplexml_load_string' => 'ExpressionEngine\\Dependency\\Safe\\simplexml_load_string', 'sleep' => 'ExpressionEngine\\Dependency\\Safe\\sleep', 'socket_accept' => 'ExpressionEngine\\Dependency\\Safe\\socket_accept', 'socket_addrinfo_bind' => 'ExpressionEngine\\Dependency\\Safe\\socket_addrinfo_bind', 'socket_addrinfo_connect' => 'ExpressionEngine\\Dependency\\Safe\\socket_addrinfo_connect', 'socket_bind' => 'ExpressionEngine\\Dependency\\Safe\\socket_bind', 'socket_connect' => 'ExpressionEngine\\Dependency\\Safe\\socket_connect', 'socket_create' => 'ExpressionEngine\\Dependency\\Safe\\socket_create', 'socket_create_listen' => 'ExpressionEngine\\Dependency\\Safe\\socket_create_listen', 'socket_create_pair' => 'ExpressionEngine\\Dependency\\Safe\\socket_create_pair', 'socket_export_stream' => 'ExpressionEngine\\Dependency\\Safe\\socket_export_stream', 'socket_getpeername' => 'ExpressionEngine\\Dependency\\Safe\\socket_getpeername', 'socket_getsockname' => 'ExpressionEngine\\Dependency\\Safe\\socket_getsockname', 'socket_get_option' => 'ExpressionEngine\\Dependency\\Safe\\socket_get_option', 'socket_import_stream' => 'ExpressionEngine\\Dependency\\Safe\\socket_import_stream', 'socket_listen' => 'ExpressionEngine\\Dependency\\Safe\\socket_listen', 'socket_read' => 'ExpressionEngine\\Dependency\\Safe\\socket_read', 'socket_send' => 'ExpressionEngine\\Dependency\\Safe\\socket_send', 'socket_sendmsg' => 'ExpressionEngine\\Dependency\\Safe\\socket_sendmsg', 'socket_sendto' => 'ExpressionEngine\\Dependency\\Safe\\socket_sendto', 'socket_set_block' => 'ExpressionEngine\\Dependency\\Safe\\socket_set_block', 'socket_set_nonblock' => 'ExpressionEngine\\Dependency\\Safe\\socket_set_nonblock', 'socket_set_option' => 'ExpressionEngine\\Dependency\\Safe\\socket_set_option', 'socket_shutdown' => 'ExpressionEngine\\Dependency\\Safe\\socket_shutdown', 'socket_write' => 'ExpressionEngine\\Dependency\\Safe\\socket_write', 'socket_wsaprotocol_info_export' => 'ExpressionEngine\\Dependency\\Safe\\socket_wsaprotocol_info_export', 'socket_wsaprotocol_info_import' => 'ExpressionEngine\\Dependency\\Safe\\socket_wsaprotocol_info_import', 'socket_wsaprotocol_info_release' => 'ExpressionEngine\\Dependency\\Safe\\socket_wsaprotocol_info_release', 'sodium_crypto_pwhash' => 'ExpressionEngine\\Dependency\\Safe\\sodium_crypto_pwhash', 'sodium_crypto_pwhash_str' => 'ExpressionEngine\\Dependency\\Safe\\sodium_crypto_pwhash_str', 'solr_get_version' => 'ExpressionEngine\\Dependency\\Safe\\solr_get_version', 'sort' => 'ExpressionEngine\\Dependency\\Safe\\sort', 'soundex' => 'ExpressionEngine\\Dependency\\Safe\\soundex', 'spl_autoload_register' => 'ExpressionEngine\\Dependency\\Safe\\spl_autoload_register', 'spl_autoload_unregister' => 'ExpressionEngine\\Dependency\\Safe\\spl_autoload_unregister', 'sprintf' => 'ExpressionEngine\\Dependency\\Safe\\sprintf', 'sqlsrv_begin_transaction' => 'ExpressionEngine\\Dependency\\Safe\\sqlsrv_begin_transaction', 'sqlsrv_cancel' => 'ExpressionEngine\\Dependency\\Safe\\sqlsrv_cancel', 'sqlsrv_client_info' => 'ExpressionEngine\\Dependency\\Safe\\sqlsrv_client_info', 'sqlsrv_close' => 'ExpressionEngine\\Dependency\\Safe\\sqlsrv_close', 'sqlsrv_commit' => 'ExpressionEngine\\Dependency\\Safe\\sqlsrv_commit', 'sqlsrv_configure' => 'ExpressionEngine\\Dependency\\Safe\\sqlsrv_configure', 'sqlsrv_execute' => 'ExpressionEngine\\Dependency\\Safe\\sqlsrv_execute', 'sqlsrv_free_stmt' => 'ExpressionEngine\\Dependency\\Safe\\sqlsrv_free_stmt', 'sqlsrv_get_field' => 'ExpressionEngine\\Dependency\\Safe\\sqlsrv_get_field', 'sqlsrv_next_result' => 'ExpressionEngine\\Dependency\\Safe\\sqlsrv_next_result', 'sqlsrv_num_fields' => 'ExpressionEngine\\Dependency\\Safe\\sqlsrv_num_fields', 'sqlsrv_num_rows' => 'ExpressionEngine\\Dependency\\Safe\\sqlsrv_num_rows', 'sqlsrv_prepare' => 'ExpressionEngine\\Dependency\\Safe\\sqlsrv_prepare', 'sqlsrv_query' => 'ExpressionEngine\\Dependency\\Safe\\sqlsrv_query', 'sqlsrv_rollback' => 'ExpressionEngine\\Dependency\\Safe\\sqlsrv_rollback', 'ssdeep_fuzzy_compare' => 'ExpressionEngine\\Dependency\\Safe\\ssdeep_fuzzy_compare', 'ssdeep_fuzzy_hash' => 'ExpressionEngine\\Dependency\\Safe\\ssdeep_fuzzy_hash', 'ssdeep_fuzzy_hash_filename' => 'ExpressionEngine\\Dependency\\Safe\\ssdeep_fuzzy_hash_filename', 'ssh2_auth_agent' => 'ExpressionEngine\\Dependency\\Safe\\ssh2_auth_agent', 'ssh2_auth_hostbased_file' => 'ExpressionEngine\\Dependency\\Safe\\ssh2_auth_hostbased_file', 'ssh2_auth_password' => 'ExpressionEngine\\Dependency\\Safe\\ssh2_auth_password', 'ssh2_auth_pubkey_file' => 'ExpressionEngine\\Dependency\\Safe\\ssh2_auth_pubkey_file', 'ssh2_connect' => 'ExpressionEngine\\Dependency\\Safe\\ssh2_connect', 'ssh2_disconnect' => 'ExpressionEngine\\Dependency\\Safe\\ssh2_disconnect', 'ssh2_exec' => 'ExpressionEngine\\Dependency\\Safe\\ssh2_exec', 'ssh2_publickey_add' => 'ExpressionEngine\\Dependency\\Safe\\ssh2_publickey_add', 'ssh2_publickey_init' => 'ExpressionEngine\\Dependency\\Safe\\ssh2_publickey_init', 'ssh2_publickey_remove' => 'ExpressionEngine\\Dependency\\Safe\\ssh2_publickey_remove', 'ssh2_scp_recv' => 'ExpressionEngine\\Dependency\\Safe\\ssh2_scp_recv', 'ssh2_scp_send' => 'ExpressionEngine\\Dependency\\Safe\\ssh2_scp_send', 'ssh2_sftp' => 'ExpressionEngine\\Dependency\\Safe\\ssh2_sftp', 'ssh2_sftp_chmod' => 'ExpressionEngine\\Dependency\\Safe\\ssh2_sftp_chmod', 'ssh2_sftp_mkdir' => 'ExpressionEngine\\Dependency\\Safe\\ssh2_sftp_mkdir', 'ssh2_sftp_rename' => 'ExpressionEngine\\Dependency\\Safe\\ssh2_sftp_rename', 'ssh2_sftp_rmdir' => 'ExpressionEngine\\Dependency\\Safe\\ssh2_sftp_rmdir', 'ssh2_sftp_symlink' => 'ExpressionEngine\\Dependency\\Safe\\ssh2_sftp_symlink', 'ssh2_sftp_unlink' => 'ExpressionEngine\\Dependency\\Safe\\ssh2_sftp_unlink', 'stream_context_set_params' => 'ExpressionEngine\\Dependency\\Safe\\stream_context_set_params', 'stream_copy_to_stream' => 'ExpressionEngine\\Dependency\\Safe\\stream_copy_to_stream', 'stream_filter_append' => 'ExpressionEngine\\Dependency\\Safe\\stream_filter_append', 'stream_filter_prepend' => 'ExpressionEngine\\Dependency\\Safe\\stream_filter_prepend', 'stream_filter_register' => 'ExpressionEngine\\Dependency\\Safe\\stream_filter_register', 'stream_filter_remove' => 'ExpressionEngine\\Dependency\\Safe\\stream_filter_remove', 'stream_get_contents' => 'ExpressionEngine\\Dependency\\Safe\\stream_get_contents', 'stream_isatty' => 'ExpressionEngine\\Dependency\\Safe\\stream_isatty', 'stream_resolve_include_path' => 'ExpressionEngine\\Dependency\\Safe\\stream_resolve_include_path', 'stream_set_blocking' => 'ExpressionEngine\\Dependency\\Safe\\stream_set_blocking', 'stream_set_timeout' => 'ExpressionEngine\\Dependency\\Safe\\stream_set_timeout', 'stream_socket_accept' => 'ExpressionEngine\\Dependency\\Safe\\stream_socket_accept', 'stream_socket_client' => 'ExpressionEngine\\Dependency\\Safe\\stream_socket_client', 'stream_socket_pair' => 'ExpressionEngine\\Dependency\\Safe\\stream_socket_pair', 'stream_socket_server' => 'ExpressionEngine\\Dependency\\Safe\\stream_socket_server', 'stream_socket_shutdown' => 'ExpressionEngine\\Dependency\\Safe\\stream_socket_shutdown', 'stream_supports_lock' => 'ExpressionEngine\\Dependency\\Safe\\stream_supports_lock', 'stream_wrapper_register' => 'ExpressionEngine\\Dependency\\Safe\\stream_wrapper_register', 'stream_wrapper_restore' => 'ExpressionEngine\\Dependency\\Safe\\stream_wrapper_restore', 'stream_wrapper_unregister' => 'ExpressionEngine\\Dependency\\Safe\\stream_wrapper_unregister', 'strptime' => 'ExpressionEngine\\Dependency\\Safe\\strptime', 'strtotime' => 'ExpressionEngine\\Dependency\\Safe\\strtotime', 'substr' => 'ExpressionEngine\\Dependency\\Safe\\substr', 'swoole_async_write' => 'ExpressionEngine\\Dependency\\Safe\\swoole_async_write', 'swoole_async_writefile' => 'ExpressionEngine\\Dependency\\Safe\\swoole_async_writefile', 'swoole_event_defer' => 'ExpressionEngine\\Dependency\\Safe\\swoole_event_defer', 'swoole_event_del' => 'ExpressionEngine\\Dependency\\Safe\\swoole_event_del', 'swoole_event_write' => 'ExpressionEngine\\Dependency\\Safe\\swoole_event_write', 'symlink' => 'ExpressionEngine\\Dependency\\Safe\\symlink', 'syslog' => 'ExpressionEngine\\Dependency\\Safe\\syslog', 'system' => 'ExpressionEngine\\Dependency\\Safe\\system', 'tempnam' => 'ExpressionEngine\\Dependency\\Safe\\tempnam', 'timezone_name_from_abbr' => 'ExpressionEngine\\Dependency\\Safe\\timezone_name_from_abbr', 'time_nanosleep' => 'ExpressionEngine\\Dependency\\Safe\\time_nanosleep', 'time_sleep_until' => 'ExpressionEngine\\Dependency\\Safe\\time_sleep_until', 'tmpfile' => 'ExpressionEngine\\Dependency\\Safe\\tmpfile', 'touch' => 'ExpressionEngine\\Dependency\\Safe\\touch', 'uasort' => 'ExpressionEngine\\Dependency\\Safe\\uasort', 'uksort' => 'ExpressionEngine\\Dependency\\Safe\\uksort', 'unlink' => 'ExpressionEngine\\Dependency\\Safe\\unlink', 'unpack' => 'ExpressionEngine\\Dependency\\Safe\\unpack', 'uopz_extend' => 'ExpressionEngine\\Dependency\\Safe\\uopz_extend', 'uopz_implement' => 'ExpressionEngine\\Dependency\\Safe\\uopz_implement', 'usort' => 'ExpressionEngine\\Dependency\\Safe\\usort', 'virtual' => 'ExpressionEngine\\Dependency\\Safe\\virtual', 'vsprintf' => 'ExpressionEngine\\Dependency\\Safe\\vsprintf', 'xdiff_file_bdiff' => 'ExpressionEngine\\Dependency\\Safe\\xdiff_file_bdiff', 'xdiff_file_bpatch' => 'ExpressionEngine\\Dependency\\Safe\\xdiff_file_bpatch', 'xdiff_file_diff' => 'ExpressionEngine\\Dependency\\Safe\\xdiff_file_diff', 'xdiff_file_diff_binary' => 'ExpressionEngine\\Dependency\\Safe\\xdiff_file_diff_binary', 'xdiff_file_patch_binary' => 'ExpressionEngine\\Dependency\\Safe\\xdiff_file_patch_binary', 'xdiff_file_rabdiff' => 'ExpressionEngine\\Dependency\\Safe\\xdiff_file_rabdiff', 'xdiff_string_bpatch' => 'ExpressionEngine\\Dependency\\Safe\\xdiff_string_bpatch', 'xdiff_string_patch' => 'ExpressionEngine\\Dependency\\Safe\\xdiff_string_patch', 'xdiff_string_patch_binary' => 'ExpressionEngine\\Dependency\\Safe\\xdiff_string_patch_binary', 'xmlrpc_set_type' => 'ExpressionEngine\\Dependency\\Safe\\xmlrpc_set_type', 'xml_parser_create' => 'ExpressionEngine\\Dependency\\Safe\\xml_parser_create', 'xml_parser_create_ns' => 'ExpressionEngine\\Dependency\\Safe\\xml_parser_create_ns', 'xml_set_object' => 'ExpressionEngine\\Dependency\\Safe\\xml_set_object', 'yaml_parse' => 'ExpressionEngine\\Dependency\\Safe\\yaml_parse', 'yaml_parse_file' => 'ExpressionEngine\\Dependency\\Safe\\yaml_parse_file', 'yaml_parse_url' => 'ExpressionEngine\\Dependency\\Safe\\yaml_parse_url', 'yaz_ccl_parse' => 'ExpressionEngine\\Dependency\\Safe\\yaz_ccl_parse', 'yaz_close' => 'ExpressionEngine\\Dependency\\Safe\\yaz_close', 'yaz_connect' => 'ExpressionEngine\\Dependency\\Safe\\yaz_connect', 'yaz_database' => 'ExpressionEngine\\Dependency\\Safe\\yaz_database', 'yaz_element' => 'ExpressionEngine\\Dependency\\Safe\\yaz_element', 'yaz_present' => 'ExpressionEngine\\Dependency\\Safe\\yaz_present', 'yaz_search' => 'ExpressionEngine\\Dependency\\Safe\\yaz_search', 'yaz_wait' => 'ExpressionEngine\\Dependency\\Safe\\yaz_wait', 'zip_entry_close' => 'ExpressionEngine\\Dependency\\Safe\\zip_entry_close', 'zip_entry_open' => 'ExpressionEngine\\Dependency\\Safe\\zip_entry_open', 'zip_entry_read' => 'ExpressionEngine\\Dependency\\Safe\\zip_entry_read', 'zlib_decode' => 'ExpressionEngine\\Dependency\\Safe\\zlib_decode']]]);
};
