import { aD as EGW_AI_DRAG_OUT, aC as EGW_AI_DRAG_ENTER, aG as sprintf, aF as egwIsMobile$1, ag as EGW_AO_FLAG_IS_CONTAINER, _ as _export, au as EGW_KEY_PAGE_UP, ar as EGW_KEY_PAGE_DOWN } from '../../chunks/egw_json-39123901.js';
import { j as date$1, a as egw$1, k as et2_valueWidget, C as ClassWithAttributes, l as formatDate, g as et2_createWidget, m as egw_getObjectManager, o as et2_action_object_impl, p as egwActionObject, q as et2_register_widget, r as StaticOptions, s as rt, u as formatTime, v as formatDateTime, w as et2_insertLinkText, x as et2_activateLinks, y as et2_container, z as egw_getAppObjectManager, c as Et2Dialog, A as et2_no_init, B as flatpickr, i as interact, D as parseTime, F as et2_dataview_grid, G as et2_IResizeable, H as et2_compileLegacyJS, I as stringPad, J as stringPadWebkitBug, K as Et2Date, L as i, M as D, N as parseDate, O as app$1, P as x, Q as Et2StaticSelectMixin, R as Et2Select, T as o, U as A, V as IsEmail, E as EgwApp, W as egw_unregisterGlobalShortcut, X as egw_getFramework, b as etemplate2, S as Sortable, Y as et2_widget, t as tapAndSwipe, Z as egw_registerGlobalShortcut, n as nm_action, _ as et2_IInput } from '../../chunks/etemplate2-5d80300c.js';
import '../../vendor/bower-asset/jquery/dist/jquery.min.js';
import '../../vendor/bower-asset/cropper/dist/cropper.min.js';
import '../../vendor/tinymce/tinymce/tinymce.min.js';

function _defineProperty$8(e, r, t) { return (r = _toPropertyKey$8(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$8(t) { var i = _toPrimitive$8(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$8(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class View {
  /**
   * Translated label for header
   * @param {Object} state
   * @returns {string}
   */
  static header(state) {
    var formatDate = new Date(state.date);
    formatDate = new Date(formatDate.valueOf() + formatDate.getTimezoneOffset() * 60 * 1000);
    return View._owner(state) + date$1(egw$1.preference('dateformat'), formatDate);
  }

  /**
   * If one owner, get the owner text
   *
   * @param {object} state
   */
  static _owner(state) {
    var owner = '';
    if (state.owner.length && state.owner.length == 1 && app.calendar.sidebox_et2) {
      var own = app.calendar.sidebox_et2.getWidgetById('owner').getDOMNode();
      if (own.selectedIndex >= 0) {
        owner = own.options[own.selectedIndex].innerHTML + ": ";
      }
    }
    return owner;
  }

  /**
   * Get the start date for this view
   * @param {Object} state
   * @returns {Date}
   */
  static start_date(state) {
    var d = state.date ? new Date(state.date) : new Date();
    d.setUTCHours(0);
    d.setUTCMinutes(0);
    d.setUTCSeconds(0);
    d.setUTCMilliseconds(0);
    return d;
  }

  /**
   * Get the end date for this view
   * @param {Object} state
   * @returns {Date}
   */
  static end_date(state) {
    var d = state.date ? new Date(state.date) : new Date();
    d.setUTCHours(23);
    d.setUTCMinutes(59);
    d.setUTCSeconds(59);
    d.setUTCMilliseconds(0);
    return d;
  }

  /**
   * Get the owner for this view
   *
   * This is always the owner from the given state, we use a function
   * to trigger setting the widget value.
   *
   * @param {number[]|String} state state.owner List of owner IDs, or a comma seperated list
   * @returns {number[]|String}
   */
  static owner(state) {
    return state.owner || 0;
  }

  /**
   * Should the view show the weekends
   *
   * @param {object} state
   * @returns {boolean} Current preference to show 5 or 7 days in weekview
   */
  static show_weekend(state) {
    return state.weekend;
  }

  /**
   * How big or small are the displayed time chunks?
   *
   * @param {object} state
   */
  static granularity(state) {
    var list = egw$1.preference('use_time_grid', 'calendar');
    if (list == '0' || typeof list === 'undefined') {
      return parseInt('' + egw$1.preference('interval', 'calendar')) || 30;
    }
    if (typeof list == 'string') {
      list = list.split(',');
    }
    if (!list.indexOf && jQuery.isPlainObject(list)) {
      list = jQuery.map(list, function (el) {
        return el;
      });
    }
    return list.indexOf(state.view) >= 0 ? 0 : parseInt(egw$1.preference('interval', 'calendar')) || 30;
  }

  /**
   * You can't iterate through a class's methods normally and get parent methods as well.
   * This lets us get the methods from class + parent
   *
   * @param view
   * @returns {string[]}
   */
  static getAllFuncs(view) {
    var props = [];
    var obj = view;
    do {
      props.push(...Object.getOwnPropertyNames(obj));
    } while ((obj = Object.getPrototypeOf(obj)) && obj !== View);
    props.push(...Object.getOwnPropertyNames(View));
    return props.sort().filter((e, i, arr) => {
      if (e[0] === "_" || ["getAllFuncs"].indexOf(e) !== -1) {
        return false;
      }
      if (e != arr[i + 1] && typeof view[e] == 'function') {
        return true;
      }
    });
  }

  /**
   * Determines the new date after scrolling.  The default is 1 week.
   *
   * @param {number} delta Integer for how many 'ticks' to move, positive for
   *	forward, negative for backward
   * @returns {Date}
   */
  static scroll(delta) {
    var d = new Date(app.calendar.state.date);
    d.setUTCDate(d.getUTCDate() + 7 * delta);
    return d;
  }
}

/**
 * Etemplates and settings for the different views.  Some (day view)
 * use more than one template, some use the same template as others,
 * most need different handling for their various attributes.
 */
// List of etemplates to show for this view
_defineProperty$8(View, "etemplates", ['calendar.view']);
class day extends View {
  static header(state) {
    var formatDate = new Date(state.date);
    formatDate = new Date(formatDate.valueOf() + formatDate.getTimezoneOffset() * 60 * 1000);
    return date$1('l, ', formatDate) + super.header(state);
  }
  static start_date(state) {
    var d = super.start_date(state);
    state.date = app.calendar.date.toString(d);
    return d;
  }
  static show_weekend(state) {
    state.days = '1';
    return true;
  }
  static scroll(delta) {
    var d = new Date(app.calendar.state.date);
    d.setUTCDate(d.getUTCDate() + delta);
    return d;
  }
}
_defineProperty$8(day, "etemplates", ['calendar.view', 'calendar.todo']);
class day4 extends View {
  static end_date(state) {
    var d = super.end_date(state);
    state.days = '4';
    d.setUTCHours(24 * 4 - 1);
    d.setUTCMinutes(59);
    d.setUTCSeconds(59);
    d.setUTCMilliseconds(0);
    return d;
  }
  static show_weekend(state) {
    state.weekend = 'true';
    return true;
  }
  static scroll(delta) {
    var d = new Date(app.calendar.state.date);
    d.setUTCDate(d.getUTCDate() + 4 * delta);
    return d;
  }
}
class week extends View {
  static header(state) {
    var start_date = state.first;
    var end_date = state.last;
    if (!week.show_weekend(state)) {
      start_date = new Date(state.first);
      while ([0, 6].indexOf(start_date.getUTCDay()) != -1) {
        start_date.setUTCDate(start_date.getUTCDate() + 1);
      }
      end_date = new Date(state.last);
      while ([0, 6].indexOf(end_date.getUTCDay()) != -1) {
        end_date.setUTCDate(end_date.getUTCDate() - 1);
      }
    }
    return super._owner(state) + app.calendar.egw.lang('Week') + ' ' + app.calendar.date.week_number(start_date) + ': ' + app.calendar.date.long_date(start_date, end_date);
  }
  static start_date(state) {
    return app.calendar.date.start_of_week(super.start_date(state));
  }
  static end_date(state) {
    var d = app.calendar.date.start_of_week(state.date || new Date());
    // Always 7 days, we just turn weekends on or off
    d.setUTCHours(24 * 7 - 1);
    d.setUTCMinutes(59);
    d.setUTCSeconds(59);
    d.setUTCMilliseconds(0);
    return d;
  }
}
class weekN extends View {
  static header(state) {
    return super._owner(state) + app.calendar.egw.lang('Week') + ' ' + app.calendar.date.week_number(state.first) + ' - ' + app.calendar.date.week_number(state.last) + ': ' + app.calendar.date.long_date(state.first, state.last);
  }
  static start_date(state) {
    return app.calendar.date.start_of_week(super.start_date(state));
  }
  static end_date(state) {
    state.days = '' + (state.days >= 5 ? state.days : egw$1.preference('days_in_weekview', 'calendar') || 7);
    var d = app.calendar.date.start_of_week(super.start_date(state));
    // Always 7 days, we just turn weekends on or off
    d.setUTCHours(24 * 7 * (parseInt(app.calendar.egw.preference('multiple_weeks', 'calendar')) || 3) - 1);
    return d;
  }
}
class month extends View {
  static header(state) {
    var formatDate = new Date(state.date);
    formatDate = new Date(formatDate.valueOf() + formatDate.getTimezoneOffset() * 60 * 1000);
    return super._owner(state) + app.calendar.egw.lang(date$1('F', formatDate)) + ' ' + date$1('Y', formatDate);
  }
  static start_date(state) {
    var d = super.start_date(state);
    d.setUTCDate(1);
    return app.calendar.date.start_of_week(d);
  }
  static end_date(state) {
    var d = super.end_date(state);
    d = new Date(d.getFullYear(), d.getUTCMonth() + 1, 1, 0, -d.getTimezoneOffset(), 0);
    d.setUTCSeconds(d.getUTCSeconds() - 1);
    return app.calendar.date.end_of_week(d);
  }
  static scroll(delta) {
    var d = new Date(app.calendar.state.date);
    // Set day to 15 so we don't get overflow on short months
    // eg. Aug 31 + 1 month = Sept 31 -> Oct 1
    d.setUTCDate(15);
    d.setUTCMonth(d.getUTCMonth() + delta);
    return d;
  }
}
class planner extends View {
  static header(state) {
    var startDate = new Date(state.first);
    startDate = new Date(startDate.valueOf() + startDate.getTimezoneOffset() * 60 * 1000);
    var endDate = new Date(state.last);
    endDate = new Date(endDate.valueOf() + endDate.getTimezoneOffset() * 60 * 1000);
    return super._owner(state) + date$1(egw$1.preference('dateformat'), startDate) + (startDate == endDate ? '' : ' - ' + date$1(egw$1.preference('dateformat'), endDate));
  }
  static group_by(state) {
    return state.sortby ? state.sortby : 0;
  }

  // Note: Planner uses the additional value of planner_view to determine
  // the start & end dates using other view's functions
  static start_date(state) {
    // Start here, in case we can't find anything better
    var d = super.start_date(state);
    if (state.sortby && state.sortby === 'month') {
      d.setUTCDate(1);
    } else if (state.planner_view && app.classes.calendar.views[state.planner_view]) {
      d = app.classes.calendar.views[state.planner_view].start_date.call(this, state);
    } else {
      d = app.calendar.date.start_of_week(d);
      d.setUTCHours(0);
      d.setUTCMinutes(0);
      d.setUTCSeconds(0);
      d.setUTCMilliseconds(0);
      return d;
    }
    return d;
  }
  static end_date(state) {
    var d = super.end_date(state);
    if (state.sortby && state.sortby === 'month') {
      d.setUTCDate(0);
      d.setUTCFullYear(d.getUTCFullYear() + 1);
    } else if (state.planner_view && app.classes.calendar.views[state.planner_view]) {
      d = app.classes.calendar.views[state.planner_view].end_date(state);
    } else if (state.days) {
      // This one comes from a grid view, but we'll use it
      d.setUTCDate(d.getUTCDate() + parseInt(state.days) - 1);
      delete state.days;
    } else {
      d = app.calendar.date.end_of_week(d);
    }
    return d;
  }
  static hide_empty(state) {
    var check = state.sortby == 'user' ? ['user', 'both'] : ['cat', 'both'];
    return check.indexOf(egw$1.preference('planner_show_empty_rows', 'calendar') + '') === -1;
  }
  static scroll(delta) {
    if (app.calendar.state.planner_view && !isNaN(delta) && app.calendar.state.sortby !== "month") {
      return app.classes.calendar.views[app.calendar.state.planner_view].scroll(delta);
    }
    var d = new Date(app.calendar.state.date);
    var days = 1;
    delta = parseInt(delta) || 0;

    // Yearly view, grouped by month - scroll 1 month
    if (app.calendar.state.sortby === 'month') {
      d.setUTCMonth(d.getUTCMonth() + delta);
      d.setUTCDate(1);
      d.setUTCHours(0);
      d.setUTCMinutes(0);
      return d;
    }
    // Need to set the day count, or auto date ranging takes over and
    // makes things buggy
    if (app.calendar.state.first && app.calendar.state.last) {
      //@ts-ignore
      var diff = new Date(app.calendar.state.last) - new Date(app.calendar.state.first);
      days = Math.round(diff / (1000 * 3600 * 24));
    }
    d.setUTCDate(d.getUTCDate() + days * delta);
    if (days > 8) {
      d = app.calendar.date.start_of_week(d);
    }
    return d;
  }
}
_defineProperty$8(planner, "etemplates", ['calendar.planner']);
class listview extends View {
  static header(state) {
    var startDate = new Date(state.first || state.date);
    startDate = new Date(startDate.valueOf() + startDate.getTimezoneOffset() * 60 * 1000);
    var start_check = '' + startDate.getFullYear() + startDate.getMonth() + startDate.getDate();
    var endDate = new Date(state.last || state.date);
    endDate = new Date(endDate.valueOf() + endDate.getTimezoneOffset() * 60 * 1000);
    var end_check = '' + endDate.getFullYear() + endDate.getMonth() + endDate.getDate();
    return super._owner(state) + date$1(egw$1.preference('dateformat'), startDate) + (start_check == end_check ? '' : ' - ' + date$1(egw$1.preference('dateformat'), endDate));
  }
}
_defineProperty$8(listview, "etemplates", ['calendar.list']);

function ownKeys$3(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$3(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$3(Object(t), !0).forEach(function (r) { _defineProperty$7(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$3(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty$7(e, r, t) { return (r = _toPropertyKey$7(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$7(t) { var i = _toPrimitive$7(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$7(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * Parent class for the various calendar views to reduce copied code
 *
 *
 * et2_calendar_view is responsible for its own loader div, which is displayed while
 * the times & days are redrawn.
 *
 * @augments et2_valueWidget
 */
class et2_calendar_view extends et2_valueWidget {
  /**
   * Constructor
   *
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_calendar_view._attributes, _child || {}));
    _defineProperty$7(this, "dataStorePrefix", 'calendar');
    _defineProperty$7(this, "loader", void 0);
    _defineProperty$7(this, "div", void 0);
    _defineProperty$7(this, "now_div", void 0);
    _defineProperty$7(this, "update_timer", null);
    _defineProperty$7(this, "now_timer", null);
    _defineProperty$7(this, "drag_create", void 0);
    _defineProperty$7(this, "value", void 0);
    _defineProperty$7(this, "_actionObject", void 0);
    this.loader = jQuery('<div class="egw-loading-prompt-container ui-front loading"></div>');
    this.now_div = jQuery('<div class="calendar_now"/>');
    this.update_timer = null;
    this.now_timer = null;

    // Used to support dragging on empty space to create an event
    this.drag_create = {
      start: null,
      end: null,
      parent: null,
      event: null
    };
  }
  destroy() {
    super.destroy();

    // Stop the invalidate timer
    if (this.update_timer) {
      window.clearTimeout(this.update_timer);
    }

    // Stop the 'now' line
    if (this.now_timer) {
      window.clearInterval(this.now_timer);
    }
  }
  doLoadingFinished() {
    super.doLoadingFinished();
    this.loader.hide(0).prependTo(this.div);
    this.div.append(this.now_div);
    if (this.options.owner) this.set_owner(this.options.owner);

    // Start moving 'now' line
    this.now_timer = window.setInterval(this._updateNow.bind(this), 60000);
    return true;
  }

  /**
   * Something changed, and the view need to be re-drawn.  We wait a bit to
   * avoid re-drawing twice if start and end date both changed, then recreate
   * as needed.
   *
   * @param {boolean} [trigger_event=false] Trigger an event once things are done.
   *	Waiting until invalidate completes prevents 2 updates when changing the date range.
   * @returns {undefined}
   *
   * @memberOf et2_calendar_view
   */
  invalidate(trigger_event) {
    // If this wasn't a stub, we'd set this.update_timer
  }

  /**
   * Returns the current start date
   *
   * @returns {Date}
   *
   * @memberOf et2_calendar_view
   */
  get_start_date() {
    return new Date(this.options.start_date);
  }

  /**
   * Returns the current start date
   *
   * @returns {Date}
   *
   * @memberOf et2_calendar_view
   */
  get_end_date() {
    return new Date(this.options.end_date);
  }

  /**
   * Change the start date
   *
   * Changing the start date will invalidate the display, and it will be redrawn
   * after a timeout.
   *
   * @param {string|number|Date} new_date New starting date.  Strings can be in
   *	any format understood by et2_widget_date, or Ymd (eg: 20160101).
   * @returns {undefined}
   *
   * @memberOf et2_calendar_view
   */
  set_start_date(new_date) {
    if (!new_date || new_date === null) {
      new_date = new Date();
    }
    var old_date = this.options.start_date;
    this.options.start_date = this.date_helper(new_date);
    if (old_date !== this.options.start_date && this.isAttached()) {
      this.invalidate(true);
    }
  }

  /**
   * Change the end date
   *
   * Changing the end date will invalidate the display, and it will be redrawn
   * after a timeout.
   *
   * @param {string|number|Date} new_date - New end date.  Strings can be in
   *	any format understood by et2_widget_date, or Ymd (eg: 20160101).
   * @returns {undefined}
   *
   * @memberOf et2_calendar_view
   */
  set_end_date(new_date) {
    if (!new_date || new_date === null) {
      new_date = new Date();
    }
    var old_date = this.options.end_date;
    this.options.end_date = this.date_helper(new_date);
    if (old_date !== this.options.end_date && this.isAttached()) {
      this.invalidate(true);
    }
  }

  /**
   * Set which users to display
   *
   * Changing the owner will invalidate the display, and it will be redrawn
   * after a timeout.
   *
   * @param {number|number[]|string|string[]} _owner - Owner ID, which can
   *	be an account ID, a resource ID (as defined in calendar_bo, not
   *	necessarily an entry from the resource app), or a list containing a
   *	combination of both.
   *
   * @memberOf et2_calendar_view
   */
  set_owner(_owner) {
    var old = this.options.owner;

    // 0 means current user, but that causes problems for comparison,
    // so we'll just switch to the actual ID
    if (_owner == '0') {
      _owner = [egw.user('account_id')];
    }
    if (!jQuery.isArray(_owner)) {
      if (typeof _owner === "string") {
        _owner = _owner.split(',');
      } else {
        _owner = [_owner];
      }
    } else {
      _owner = jQuery.extend([], _owner);
    }
    this.options.owner = _owner;
    if (this.isAttached() && (typeof old === "number" && typeof _owner === "number" && old !== this.options.owner ||
    // Array of ids will not compare as equal
    (typeof old === 'object' || typeof _owner === 'object') && old.toString() !== _owner.toString() ||
    // Strings
    typeof old === 'string' && '' + old !== '' + this.options.owner)) {
      this.invalidate(true);
    }
  }

  /**
   * Provide specific data to be displayed.
   * This is a way to set start and end dates, owner and event data in one call.
   *
   * If events are not provided in the array,
   * @param {Object[]} events Array of events, indexed by date in Ymd format:
   *	{
   *		20150501: [...],
   *		20150502: [...]
   *	}
   *	Days should be in order.
   *  {string|number|Date} events.start_date - New start date
   *  {string|number|Date} events.end_date - New end date
   *  {number|number[]|string|string[]} event.owner - Owner ID, which can
   *	be an account ID, a resource ID (as defined in calendar_bo, not
   *	necessarily an entry from the resource app), or a list containing a
   *	combination of both.
   */
  set_value(events) {
    if (typeof events !== 'object') return false;
    if (events.length && events.length > 0 || !jQuery.isEmptyObject(events)) {
      this.set_disabled(false);
    }
    if (events.id) {
      this.set_id(events.id);
      delete events.id;
    }
    if (events.start_date) {
      this.set_start_date(events.start_date);
      delete events.start_date;
    }
    if (events.end_date) {
      this.set_end_date(events.end_date);
      delete events.end_date;
    }
    // set_owner() wants start_date set to get the correct week number
    // for the corner label
    if (events.owner) {
      this.set_owner(events.owner);
      delete events.owner;
    }
    this.value = events || {};

    // None of the above changed anything, hide the loader
    if (!this.update_timer) {
      window.setTimeout(jQuery.proxy(function () {
        this.loader.hide();
      }, this), 200);
    }
  }

  /**
   * Parse something that we think is a date into an actual date.
   *
   * The passed value could be a Date, or a string in an unknown format, or a timestamp
   *
   * @param {Date | string | number} _value
   */
  date_helper(_value) {
    if (_value === null || _value === "" || _value === undefined || _value === 0) {
      return undefined;
    }
    if (_value instanceof Date) {
      // Return a copy, because often modifications are made after
      return new Date(_value.getTime());
    }
    var date = new Date();
    if (typeof _value === "string" && _value.length == 8) {
      // Ymd format: 20000101
      date.setFullYear(parseInt(_value.substring(0, 4)));
      // Avoid overflow into next month since it already has a value
      date.setUTCDate(1);
      date.setUTCMonth(parseInt(_value.substring(4, 6)) - 1);
      date.setUTCDate(parseInt(_value.substring(6, 8)));
      date.setUTCHours(0);
      date.setUTCMinutes(0);
      date.setUTCSeconds(0);
      date.setUTCMilliseconds(0);
    }
    // Check for full timestamp
    else if (typeof _value == 'string' && _value.match(/^(\d{4})-(\d{2})-(\d{2})T(\d{2})\:(\d{2})\:(\d{2})(?:\.\d{3})?(?:Z|[+-](\d{2})\:(\d{2})|)$/)) {
      date = new Date(_value);
    }
    // timestamp in usertime
    else if (typeof _value == 'number' || typeof _value == 'string' && !isNaN(_value) && _value[0] != '+' && _value[0] != '-') {
      date = new Date((typeof _value == "number" ? _value : parseInt(_value)) * 1000);
    }
    // @ts-ignore
    else if (typeof _value == 'object' && typeof _value.date !== "undefined") {
      // @ts-ignore
      return this.date_helper(_value.date);
    }
    // @ts-ignore
    else if (typeof _value == 'object' && typeof _value.valueOf !== "undefined") {
      date = _value;
    } else {
      // string starting with + or - --> add/substract number of seconds from current value
      date.setTime(date.getTime() + 1000 * parseInt("" + _value));
    }
    return date;
  }
  _createNamespace() {
    return true;
  }

  /**
   * Update the 'now' line
   *
   * Here we just do some limit checks and return the current date/time.
   * Extending widgets should handle position.
   *
   * @private
   */
  _updateNow() {
    var tempDate = new Date();
    var now = new Date(tempDate.getFullYear(), tempDate.getMonth(), tempDate.getDate(), tempDate.getHours(), tempDate.getMinutes() - tempDate.getTimezoneOffset(), 0);
    now = this.date_helper(now.toJSON());
    if (this.get_start_date() <= now && this.get_end_date() >= now) {
      return now;
    }
    this.now_div.hide();
    return false;
  }

  /**
   * Calendar supports many different owner types, including users & resources.
   * This translates an ID to a user-friendly name.
   *
   * @param {string} user
   * @returns {string}
   *
   * @memberOf et2_calendar_view
   */
  _get_owner_name(user) {
    var label = undefined;
    if (parseInt(user) === 0) {
      // 0 means current user
      user = egw.user('account_id');
    }
    if (et2_calendar_view.owner_name_cache[user]) {
      return et2_calendar_view.owner_name_cache[user];
    }
    if (!isNaN(user)) {
      user = parseInt(user);
      var accounts = egw.accounts('both');
      for (var j = 0; j < accounts.length; j++) {
        if (accounts[j].value === user) {
          label = accounts[j].label;
          break;
        }
      }
    }
    if (typeof label === 'undefined') {
      // Not found?  Ask the sidebox owner widget (it gets updated) or the original arrayMgr
      var options = false;
      if (app.calendar && app.calendar.sidebox_et2 && app.calendar.sidebox_et2.getWidgetById('owner')) {
        options = app.calendar.sidebox_et2.getWidgetById('owner').select_options;
      } else {
        options = this.getArrayMgr("sel_options").getRoot().getEntry('owner');
      }
      if (options && options.find) {
        var found = options.find(function (element) {
          return element.value == user;
        }) || {};
        if (found && found.label && found.label !== user) {
          label = found.label;
        }
      }
      if (!label) {
        // No sidebox?  Must be in home or sitemgr (no caching) - ask directly
        label = '?';
        egw.jsonq('calendar_owner_etemplate_widget::ajax_owner', user, function (data) {
          et2_calendar_view.owner_name_cache[user] = data;
          this.invalidate(true);

          // Set owner to make sure labels get set
          if (this.owner && typeof this.owner.set_value === 'function') {
            this.owner.set_value(data);
          }
        }.bind(this), this);
      }
    }
    if (label) {
      et2_calendar_view.owner_name_cache[user] = label;
    }
    return label;
  }

  /**
   * Find the event information linked to a given DOM node
   *
   * @param {HTMLElement} dom_node - It should have something to do with an event
   * @returns {Object}
   */
  _get_event_info(dom_node) {
    // Determine as much relevant info as can be found
    var event_node = jQuery(dom_node).closest('[data-id]', this.div)[0];
    var day_node = jQuery(event_node).closest('[data-date]', this.div)[0];
    var result = jQuery.extend({
      event_node: event_node,
      day_node: day_node
    }, event_node ? event_node.dataset : {}, day_node ? day_node.dataset : {});

    // Widget ID should be the DOM node ID without the event_ prefix
    if (event_node && event_node.id) {
      var widget_id = event_node.id || '';
      widget_id = widget_id.split('event_');
      widget_id.shift();
      result.widget_id = 'event_' + widget_id.join('');
      var widget = this.getWidgetById(result.widget_id);
      if (widget) {
        result.title = widget.options.value.title;
      }
    }
    return result;
  }

  /**
   * Starting (mousedown) handler to support drag to create
   *
   * Extending classes need to set this.drag_create.parent, which is the
   * parent container (child of extending class) that will directly hold the
   * event.
   *
   * @param {String} start Date string (JSON format)
   */
  _drag_create_start(start) {
    var _this$egw$preference;
    this.drag_create.start = jQuery.extend({}, start);
    if (!this.drag_create.start.date) {
      this.drag_create.start = null;
    }
    this.drag_create.end = _objectSpread$3(_objectSpread$3({}, start), {}, {
      date: new Date(start.date.valueOf())
    });
    // Begin at default duration
    this.drag_create.end.date.setUTCMinutes(this.drag_create.end.date.getUTCMinutes() + ((_this$egw$preference = this.egw().preference("defaultlength", "calendar")) !== null && _this$egw$preference !== void 0 ? _this$egw$preference : 60));

    // Clear some stuff, if last time did not complete
    if (this.drag_create.event) {
      if (this.drag_create.event.destroy) {
        this.drag_create.event.destroy();
      }
      this.drag_create.event = null;
    }
    // Wait a bit before adding an "event", it may be just a click
    window.setTimeout(() => {
      // Create event
      this._drag_create_event();
    }, 100);
  }

  /**
   * Create or update an event used for feedback while dragging on empty space,
   * so user can see something is happening
   */
  _drag_create_event() {
    if (!this.drag_create.parent || !this.drag_create.start) {
      return;
    }
    if (!this.drag_create.event) {
      var value = jQuery.extend({}, this.drag_create.start, this.drag_create.end, {
        start: this.drag_create.start.date,
        end: this.drag_create.end && this.drag_create.end.date || this.drag_create.start.date,
        date: "" + formatDate(this.date_helper(this.drag_create.start.date), {
          dateFormat: "Ymd"
        }),
        title: '',
        description: '',
        owner: this.options.owner,
        participants: this.options.owner,
        app: 'calendar',
        whole_day_on_top: this.drag_create.start.whole_day
      });
      this.drag_create.event = et2_createWidget('calendar-event', {
        id: 'event_drag',
        value: value
      }, this.drag_create.parent);
      this.drag_create.event._values_check(value);
      this.drag_create.event.doLoadingFinished();
      if (this.drag_create.parent && typeof this.drag_create.parent.position_event == "function") {
        this.drag_create.parent.position_event(this.drag_create.event);
      }
    }
  }
  _drag_update_event() {
    if (!this.drag_create.event || !this.drag_create.start || !this.drag_create.end || !this.drag_create.parent || !this.drag_create.event._type) {
      return;
    } else if (this.drag_create.end) {
      this.drag_create.event.options.value.end = this.drag_create.end.date;
      this.drag_create.event._values_check(this.drag_create.event.options.value);
    }
    this.drag_create.event._update();
    this.drag_create.parent.position_event(this.drag_create.event);
  }

  /**
   * Ending (mouseup) handler to support drag to create
   *
   * @param {String} end Date string (JSON format)
   */
  _drag_create_end(end) {
    this.div.css('cursor', '');
    if (typeof end === 'undefined') {
      end = {};
    }
    if (this.drag_create.start && end.date) {
      // Drag from start to end, open dialog
      var options = {
        start: this.drag_create.start.date < end.date ? this.drag_create.start.date : end.date,
        end: this.drag_create.start.date < end.date ? end.date : this.drag_create.start.date
      };

      // Whole day needs to go from 00:00 to 23:59
      if (end.whole_day || this.drag_create.start.whole_day) {
        var start = new Date(options.start);
        start.setUTCHours(0);
        start.setUTCMinutes(0);
        options.start = start.toJSON();
        var end = new Date(options.end);
        end.setUTCHours(23);
        end.setUTCMinutes(59);
        options.end = end.toJSON();
      }

      // Add anything else that was set, but not date
      jQuery.extend(options, this.drag_create.start, end);
      delete options.date;

      // Make sure parent is set, if needed
      var app_calendar = this.getInstanceManager().app_obj.calendar || app.calendar;
      if (this.drag_create.parent && this.drag_create.parent.options.owner !== app_calendar.state.owner && !options.owner) {
        options.owner = this.drag_create.parent.options.owner;
      }

      // Remove empties
      for (var key in options) {
        if (!options[key]) {
          delete options[key];
        }
        if (options[key] instanceof Date) {
          options[key] = options[key].toJSON();
        }
      }
      app.calendar.add(options, this.drag_create.event);

      // Wait a bit, having these stops the click
      window.setTimeout(jQuery.proxy(function () {
        this.drag_create.start = null;
        this.drag_create.end = null;
        this.drag_create.parent = null;
        if (this.drag_create.event) {
          try {
            if (this.drag_create.event.destroy) {
              this.drag_create.event.destroy();
            }
          } catch (e) {}
          this.drag_create.event = null;
        }
      }, this), 100);
      return false;
    }
    this.drag_create.start = null;
    this.drag_create.end = null;
    this.drag_create.parent = null;
    if (this.drag_create.event) {
      try {
        if (this.drag_create.event.destroy) {
          this.drag_create.event.destroy();
        }
      } catch (e) {}
      this.drag_create.event = null;
    }
    return true;
  }

  /**
   * Check if the view should be consolidated into one, or listed seperately
   * based on the user's preferences
   *
   * @param {string[]} owners List of owners
   * @param {string} view Name of current view (day, week)
   * @returns {boolean} True of only one is needed, false if each owner needs
   *	to be listed seperately.
   */
  static is_consolidated(owners, view) {
    // Seperate owners, or consolidated?
    return !(owners.length > 1 && (view === 'day' && owners.length < parseInt('' + egw.preference('day_consolidate', 'calendar')) || view === 'week' && owners.length < parseInt('' + egw.preference('week_consolidate', 'calendar'))));
  }

  /**
   * Cache to map owner & resource IDs to names, helps cut down on server requests
   */
}
_defineProperty$7(et2_calendar_view, "_attributes", {
  owner: {
    name: "Owner",
    type: "any",
    // Integer, or array of integers, or string like r13 (resources, addressbook)
    default: [egw.user('account_id')],
    description: "Account ID number of the calendar owner, if not the current user"
  },
  start_date: {
    name: "Start date",
    type: "any"
  },
  end_date: {
    name: "End date",
    type: "any"
  }
});
_defineProperty$7(et2_calendar_view, "owner_name_cache", {});

function _defineProperty$6(e, r, t) { return (r = _toPropertyKey$6(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$6(t) { var i = _toPrimitive$6(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$6(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * Class for one row of a planner
 *
 * This widget is responsible for the label on the side
 *
 */
class et2_calendar_planner_row extends et2_valueWidget {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_calendar_planner_row._attributes, _child || {}));

    // Main container
    _defineProperty$6(this, "div", void 0);
    _defineProperty$6(this, "title", void 0);
    _defineProperty$6(this, "rows", void 0);
    _defineProperty$6(this, "_cached_rows", void 0);
    _defineProperty$6(this, "_row_height", 20);
    _defineProperty$6(this, "_actionObject", void 0);
    this.div = jQuery(document.createElement("div")).addClass("calendar_plannerRowWidget").css('width', this.options.width);
    this.title = jQuery(document.createElement('div')).addClass("calendar_plannerRowHeader").appendTo(this.div);
    this.rows = jQuery(document.createElement('div')).addClass("calendar_eventRows").appendTo(this.div);
    this.setDOMNode(this.div[0]);
    this.set_start_date(this.options.start_date);
    this.set_end_date(this.options.end_date);
    this._cached_rows = [];
  }
  doLoadingFinished() {
    super.doLoadingFinished();
    this.set_label(this.options.label);
    this._draw();

    // Actions are set on the parent, so we need to explicitly get in here
    // and get ours
    this._link_actions(this.getParent().options.actions || []);
    return true;
  }
  destroy() {
    super.destroy();
  }
  getDOMNode(_sender) {
    if (_sender === this || !_sender) {
      return this.div[0];
    }
    if (_sender._parent === this) {
      return this.rows[0];
    }
  }

  /**
   * Link the actions to the DOM nodes / widget bits.
   *
   * @param {object} actions {ID: {attributes..}+} map of egw action information
   */
  _link_actions(actions) {
    // Get the parent?  Might be a grid row, might not.  Either way, it is
    // just a container with no valid actions
    var objectManager = egw_getObjectManager(this.getInstanceManager().app, true, 1);
    objectManager = objectManager.getObjectById(this.getInstanceManager().uniqueId, 2) || objectManager;
    var parent = objectManager.getObjectById(this.id, 1) || objectManager.getObjectById(this.getParent().id, 1) || objectManager;
    if (!parent) {
      egw$1.debug('error', 'No parent objectManager found');
      return;
    }

    // This binds into the egw action system.  Most user interactions (drag to move, resize)
    // are handled internally using jQuery directly.
    var widget_object = this._actionObject || parent.getObjectById(this.id);
    var aoi = new et2_action_object_impl(this, this.getDOMNode(this)).getAOI();
    var planner = this.getParent();
    for (var i = 0; i < parent.children.length; i++) {
      var parent_finder = jQuery(parent.children[i].iface.doGetDOMNode()).find(this.div);
      if (parent_finder.length > 0) {
        parent = parent.children[i];
        break;
      }
    }

    // Determine if we allow a dropped event to use the invite/change actions
    var _invite_enabled = function _invite_enabled(action, event, target) {
      var event = event.iface.getWidget();
      var row = target.iface.getWidget() || false;
      if (event === row || !event || !row || !row.node || !event.options || !event.options.value.participants) {
        return false;
      }
      var owner_match = false;
      var own_row = event.getParent() === row;
      for (var id in event.options.value.participants) {
        var _row$node$dataset$par, _row$node$dataset;
        owner_match = owner_match || ((_row$node$dataset$par = (_row$node$dataset = row.node.dataset) === null || _row$node$dataset === void 0 ? void 0 : _row$node$dataset.participants) !== null && _row$node$dataset$par !== void 0 ? _row$node$dataset$par : false) === '' + id;
      }
      var enabled = !owner_match &&
      // Not inside its own timegrid
      !own_row;
      widget_object.getActionLink('invite').enabled = enabled;
      widget_object.getActionLink('change_participant').enabled = enabled;

      // If invite or change participant are enabled, drag is not
      widget_object.getActionLink('egw_link_drop').enabled = !enabled;
    };
    aoi.doTriggerEvent = function (_event, _data) {
      // Determine target node
      var event = _data.event || false;
      if (!event) {
        return;
      }
      if (_data.ui.draggable.classList.contains('rowNoEdit')) {
        return;
      }
      /*
      We have to handle the drop in the normal event stream instead of waiting
      for the egwAction system so we can get the helper, and destination
      */
      if (event.type === 'drop' && widget_object.getActionLink('egw_link_drop').enabled) {
        var helper = document.body.querySelector(".calendar_d-n-d_helper");
        var _planner = this.getWidget().getParent();
        _planner._event_drop.call(helper, _planner, event, _data.ui, this.getWidget());
        _planner._drop_data = false;
      }
      var drag_listener = function drag_listener(_event) {
        _event.preventDefault();
        var position = {};
        if (planner.options.group_by === 'month') {
          position = {
            left: _event.clientX,
            top: _event.clientY
          };
        } else {
          var style = getComputedStyle(_data.ui.helper);
          position = {
            top: parseInt(style.top || "0"),
            left: _event.clientX - jQuery(this).parent().offset().left
          };
        }
        var event = _data.ui.selected[0];
        if (!event || event.id && event.id.indexOf('calendar') !== 0) {
          event = false;
        }
        if (event) {
          _invite_enabled(widget_object.getActionLink('invite').actionObj, event, widget_object);
        }
      };
      var time = jQuery('.calendar_d-n-d_timeCounter', _data.ui.helper);
      switch (_event) {
        // Triggered once, when something is dragged into the timegrid's div
        case EGW_AI_DRAG_ENTER:
          // Listen to the drag and update the helper with the time
          // This part lets us drag between different timegrids
          planner.div.on('dragover.et2_timegrid_row' + widget_object.id, drag_listener);
          planner.div.on('dragend.et2_timegrid_row' + widget_object.id, function () {
            jQuery(_data.ui.draggable).off('drag.et2_timegrid_row' + widget_object.id);
            planner.div.removeClass(["drop-hover", "et2-dropzone"]);

            // Remove helper
            document.body.querySelectorAll(".calendar_d-n-d_helper").forEach(n => n.remove());
          });
          widget_object.iface.getWidget().div.addClass('drop-hover');

          // Disable invite / change actions for same calendar or already participant
          var _event2 = _data.ui.selected[0];
          if (!_event2 || _event2.id && _event2.id.indexOf('calendar') !== 0) {
            _event2 = false;
          }
          if (_event2) {
            _invite_enabled(widget_object.getActionLink('invite').actionObj, _event2, widget_object);
          }
          if (time.length) {
            // The out will trigger after the over, so we count
            time.data('count', time.data('count') + 1);
          }
          break;

        // Triggered once, when something is dragged out of the timegrid
        case EGW_AI_DRAG_OUT:
          // Stop listening
          jQuery(_data.ui.draggable).off('drag.et2_timegrid_row' + widget_object.id);
          // Remove highlight
          widget_object.iface.getWidget().div.removeClass('drop-hover');

          // Out triggers after the over, count to not accidentally remove
          time.data('count', time.data('count') - 1);
          if (time.length && time.data('count') <= 0) {
            time.remove();
          }
          break;
      }
    };
    if (widget_object == null) {
      // Add a new container to the object manager which will hold the widget
      // objects
      widget_object = parent.insertObject(false, new egwActionObject(this.id, parent, aoi, this._actionManager || parent.manager.getActionById(this.id) || parent.manager));
    } else {
      widget_object.setAOI(aoi);
    }
    this._actionObject = widget_object;

    // Delete all old objects
    widget_object.clear();
    widget_object.unregisterActions();

    // Go over the widget & add links - this is where we decide which actions are
    // 'allowed' for this widget at this time
    var action_links = this._get_action_links(actions);
    this.getParent()._init_links_dnd(widget_object.manager, action_links);
    widget_object.updateActionLinks(action_links);
  }

  /**
   * Get all action-links / id's of 1.-level actions from a given action object
   *
   * Here we are only interested in drop events.
   *
   * @param actions
   * @returns {Array}
   */
  _get_action_links(actions) {
    var action_links = [];

    // Only these actions are allowed without a selection (empty actions)
    var empty_actions = ['add'];
    for (var i in actions) {
      var action = actions[i];
      if (empty_actions.indexOf(action.id) !== -1 || action.type == 'drop') {
        action_links.push(typeof action.id != 'undefined' ? action.id : i);
      }
    }
    return action_links;
  }

  /**
   * Draw the individual divs for weekends and events
   */
  _draw() {
    // Remove any existing
    this.rows.remove('.calendar_eventRowsMarkedDay,.calendar_eventRowsFiller').nextAll().remove();
    var days = 31;
    var width = '100';
    if (this.getParent().options.group_by === 'month') {
      days = this.options.end_date.getUTCDate();
      if (days < 31) {
        var diff = 31 - days;
        width = 'calc(' + diff * 3.23 + '% - ' + diff * 7 + 'px)';
      }
    }

    // mark weekends and other special days in yearly planner
    if (this.getParent().options.group_by == 'month') {
      this.rows.append(this._yearlyPlannerMarkDays(this.options.start_date, days));
    }
    if (this.getParent().options.group_by === 'month' && days < 31) {
      // add a filler for non existing days in that month
      this.rows.after('<div class="calendar_eventRowsFiller"' + ' style="width:' + width + ';" ></div>');
    }
  }
  set_label(label) {
    this.options.label = label;
    this.title.text(label);
    if (this.getParent().options.group_by === 'month') {
      this.title.attr('data-date', this.options.start_date.toJSON());
      this.title.attr('data-sortby', 'user');
      this.title.addClass('et2_clickable et2_link');
    } else {
      this.title.attr('data-date', '');
      this.title.removeClass('et2_clickable');
    }
  }

  /**
   * Change the start date
   *
   * @param {Date} new_date New end date
   * @returns {undefined}
   */
  set_start_date(new_date) {
    if (!new_date || new_date === null) {
      throw new TypeError('Invalid end date. ' + new_date.toString());
    }
    this.options.start_date = new Date(typeof new_date == 'string' ? new_date : new_date.toJSON());
    this.options.start_date.setUTCHours(0);
    this.options.start_date.setUTCMinutes(0);
    this.options.start_date.setUTCSeconds(0);
  }
  /**
   * Change the end date
   *
   * @param {string|number|Date} new_date New end date
   * @returns {undefined}
   */
  set_end_date(new_date) {
    if (!new_date || new_date === null) {
      throw new TypeError('Invalid end date. ' + new_date.toString());
    }
    this.options.end_date = new Date(typeof new_date == 'string' ? new_date : new_date.toJSON());
    this.options.end_date.setUTCHours(23);
    this.options.end_date.setUTCMinutes(59);
    this.options.end_date.setUTCSeconds(59);
  }

  /**
   * Mark special days (birthdays, holidays) on the planner
   *
   * @param {Date} start Start of the month
   * @param {number} days How many days in the month
   */
  _yearlyPlannerMarkDays(start, days) {
    var day_width = 3.23;
    var t = new Date(start);
    var content = '';
    for (var i = 0; i < days; i++) {
      var holidays = [];
      // TODO: implement this, pull / copy data from et2_widget_timegrid
      var day_class = this.getParent().day_class_holiday(t, holidays);
      if (day_class)
        // no regular weekday
        {
          content += '<div class="calendar_eventRowsMarkedDay ' + day_class + '" style="left: ' + i * day_width + '%; width:' + day_width + '%;"' + (holidays ? ' title="' + holidays.join(',') + '"' : '') + ' ></div>';
        }
      t.setUTCDate(t.getUTCDate() + 1);
    }
    return content;
  }

  /**
   * Callback used when the daywise data changes
   *
   * Events should update themselves when their data changes, here we are
   * dealing with a change in which events are displayed on this row.
   *
   * @param {String[]} event_ids
   * @returns {undefined}
   */
  _data_callback(event_ids) {
    var events = [];
    if (event_ids == null || typeof event_ids.length == 'undefined') event_ids = [];
    for (var i = 0; i < event_ids.length; i++) {
      var event = egw$1.dataGetUIDdata('calendar::' + event_ids[i]);
      event = event && event.data || false;
      if (event && event.date) {
        events.push(event);
      } else if (event) {
        // Got an ID that doesn't belong
        event_ids.splice(i--, 1);
      }
    }
    if (!this.getParent().disabled && event_ids.length > 0) {
      this.resize();
      this._update_events(events);
    }
  }
  date_helper(value) {
    return this.getParent().date_helper(value);
  }

  /**
   * Load the event data for this day and create event widgets for each.
   *
   * If event information is not provided, it will be pulled from the content array.
   *
   * @param {Object[]} [events] Array of event information, one per event.
   */
  _update_events(events) {
    // Remove all events
    while (this._children.length > 0) {
      var node = this._children[this._children.length - 1];
      this.removeChild(node);
      node.destroy();
    }
    this._cached_rows = [];
    for (var c = 0; c < events.length; c++) {
      // Create event
      var event = et2_createWidget('calendar-event', {
        id: 'event_' + events[c].row_id,
        value: events[c]
      }, this);
    }

    // Seperate loop so column sorting finds all children in the right place
    for (var c = 0; c < events.length; c++) {
      var _event3 = this.getWidgetById('event_' + events[c].row_id);
      if (!_event3) continue;
      if (this.isInTree()) {
        _event3.doLoadingFinished();
      }
    }
  }

  /**
   * Position the event according to it's time and how this widget is laid
   * out.
   *
   * @param {undefined|Object|et2_calendar_event} event
   */
  position_event(event) {
    var rows = this._spread_events();
    var height = rows.length * this._row_height;
    var row_width = this.rows.width();
    if (row_width == 0) {
      // Not rendered yet or something
      row_width = this.getParent().gridHeader.width() - this.title.width();
    }
    row_width -= 15;
    for (var c = 0; c < rows.length; c++) {
      // Calculate vertical positioning
      var top = c * (100.0 / rows.length);
      for (var i = 0; (rows[c].indexOf(event) >= 0 || !event) && i < rows[c].length; i++) {
        // Calculate horizontal positioning
        var left = this._time_to_position(rows[c][i].options.value.start);
        var width = this._time_to_position(rows[c][i].options.value.end) - left;

        // Position the event
        rows[c][i].div.css('top', top + '%');
        rows[c][i].div.css('height', 100 / rows.length + '%');
        rows[c][i].div.css('left', left.toFixed(1) + '%');
        rows[c][i].div.outerWidth(width / 100 * row_width + 'px');
      }
    }
    if (height) {
      this.div.height(height + 'px');
    }
  }

  /**
   * Sort a day's events into non-overlapping rows
   *
   * @returns {Array[]} Events sorted into rows
   */
  _spread_events() {
    // Keep it so we don't have to re-do it when the next event asks
    var cached_length = 0;
    this._cached_rows.map(function (row) {
      cached_length += row.length;
    });
    if (cached_length === this._children.length) {
      return this._cached_rows;
    }

    // sorting the events in non-overlapping rows
    var rows = [];
    var row_end = [0];

    // Sort in chronological order, so earliest ones are at the top
    this._children.sort(function (a, b) {
      var start = new Date(a.options.value.start) - new Date(b.options.value.start);
      var end = new Date(a.options.value.end) - new Date(b.options.value.end);
      // Whole day events sorted by ID, normal events by start / end time
      if (a.options.value.whole_day && b.options.value.whole_day) {
        // Longer duration comes first so we have nicer bars across the top
        var duration = new Date(b.options.value.end) - new Date(b.options.value.start) - (new Date(a.options.value.end) - new Date(a.options.value.start));
        return duration ? duration : a.options.value.app_id - b.options.value.app_id;
      } else if (a.options.value.whole_day || b.options.value.whole_day) {
        return a.options.value.whole_day ? -1 : 1;
      }
      return start ? start : end;
    });
    for (var n = 0; n < this._children.length; n++) {
      var event = this._children[n].options.value || false;
      if (typeof event.start !== 'object') {
        event.start = this.date_helper(event.start);
      }
      if (typeof event.end !== 'object') {
        event.end = this.date_helper(event.end);
      }
      if (typeof event['start_m'] === 'undefined') {
        var day_start = event.start.valueOf() / 1000;
        var dst_check = new Date(event.start);
        dst_check.setUTCHours(12);

        // if daylight saving is switched on or off, correct $day_start
        // gives correct times after 2am, times between 0am and 2am are wrong
        var daylight_diff = day_start + 12 * 60 * 60 - dst_check.valueOf() / 1000;
        if (daylight_diff) {
          day_start -= daylight_diff;
        }
        event['start_m'] = event.start.getUTCHours() * 60 + event.start.getUTCMinutes();
        if (event['start_m'] < 0) {
          event['start_m'] = 0;
          event['multiday'] = true;
        }
        event['end_m'] = event.end.getUTCHours() * 60 + event.end.getUTCMinutes();
        if (event['end_m'] >= 24 * 60) {
          event['end_m'] = 24 * 60 - 1;
          event['multiday'] = true;
        }
        if (!event.start.getUTCHours() && !event.start.getUTCMinutes() && event.end.getUTCHours() == 23 && event.end.getUTCMinutes() == 59) {
          event.whole_day_on_top = event.non_blocking && event.non_blocking != '0';
        }
      }

      // Skip events entirely on hidden weekends
      if (this._hidden_weekend_event(event)) {
        var node = this._children[n];
        this.removeChild(n--);
        node.destroy();
        continue;
      }
      var event_start = new Date(event.start).valueOf();
      for (var row = 0; row_end[row] > event_start; ++row); // find a "free" row (no other event)
      if (typeof rows[row] === 'undefined') rows[row] = [];
      rows[row].push(this._children[n]);
      row_end[row] = new Date(event['end']).valueOf();
    }
    this._cached_rows = rows;
    return rows;
  }

  /**
   * Check to see if the event is entirely on a hidden weekend
   *
   * @param values Array of event values, not an et2_widget_event
   */
  _hidden_weekend_event(values) {
    if (!this.getParent() || this.getParent().options.group_by == 'month' || this.getParent().options.show_weekend) {
      return false;
    }
    // Starts on Saturday or Sunday, ends Sat or Sun, less than 2 days long
    else if ([0, 6].indexOf(values.start.getUTCDay()) !== -1 && [0, 6].indexOf(values.end.getUTCDay()) !== -1 && values.end - values.start < 2 * 24 * 3600 * 1000) {
      return true;
    }
    return false;
  }

  /**
   * Calculates the horizontal position based on the time given, as a percentage
   * between the start and end times
   *
   * @param {int|Date|string} time in minutes from midnight, or a Date in string or object form
   * @param {int|Date|string} start Earliest possible time (0%)
   * @param {int|Date|string} end Latest possible time (100%)
   * @return {float} position in percent
   */
  _time_to_position(time, start, end) {
    var pos = 0.0;

    // Handle the different value types
    start = this.options.start_date;
    end = this.options.end_date;
    if (typeof start === 'string') {
      start = new Date(start);
      end = new Date(end);
    }
    var wd_start = 60 * (parseInt('' + egw$1.preference('workdaystarts', 'calendar')) || 9);
    var wd_end = 60 * (parseInt('' + egw$1.preference('workdayends', 'calendar')) || 17);
    var t = time;
    if (typeof time === 'number' && time < 3600) {
      t = new Date(start.valueOf() + wd_start * 3600 * 1000);
    } else {
      t = new Date(time);
    }

    // Limits
    if (t <= start) return 0; // We are left of our scale
    if (t >= end) return 100; // We are right of our scale

    // Remove space for weekends, if hidden
    var weekend_count = 0;
    var weekend_before = 0;
    var partial_weekend = 0;
    if (this.getParent().options.group_by !== 'month' && this.getParent() && !this.getParent().options.show_weekend) {
      var counter_date = new Date(start);
      do {
        if ([0, 6].indexOf(counter_date.getUTCDay()) !== -1) {
          if (counter_date.getUTCDate() === t.getUTCDate() && counter_date.getUTCMonth() === t.getUTCMonth()) {
            // Event is partially on a weekend
            partial_weekend += (t.getUTCHours() * 60 + t.getUTCMinutes()) * 60 * 1000;
          } else if (counter_date < t) {
            weekend_before++;
          }
          weekend_count++;
        }
        counter_date.setUTCDate(counter_date.getUTCDate() + 1);
      } while (counter_date < end);
      // Put it in ms
      weekend_before *= 24 * 3600 * 1000;
      weekend_count *= 24 * 3600 * 1000;
    }

    // Basic scaling, doesn't consider working times
    pos = (t - start - weekend_before - partial_weekend) / (end - start - weekend_count);

    // Month view
    if (this.getParent().options.group_by !== 'month') {
      // Daywise scaling
      /* Needs hourly scales that consider working hours
      var start_date = new Date(start.getUTCFullYear(), start.getUTCMonth(),start.getUTCDate());
      var end_date = new Date(end.getUTCFullYear(), end.getUTCMonth(),end.getUTCDate());
      var t_date = new Date(t.getUTCFullYear(), t.getUTCMonth(),t.getUTCDate());
      	var days = Math.round((end_date - start_date) / (24 * 3600 * 1000))+1;
      pos = 1 / days * Math.round((t_date - start_date) / (24*3600 * 1000));
      	var time_of_day = typeof t === 'object' ? 60 * t.getUTCHours() + t.getUTCMinutes() : t;
      	if (time_of_day >= wd_start)
      {
      	var day_percentage = 0.1;
      	if (time_of_day > wd_end)
      	{
      		day_percentage = 1;
      	}
      	else
      	{
      		var wd_length = wd_end - wd_start;
      		if (wd_length <= 0) wd_length = 24*60;
      		day_percentage = (time_of_day-wd_start) / wd_length;		// between 0 and 1
      	}
      	pos += day_percentage / days;
      }
      */
    } else {
      // 2678400 is the number of seconds in 31 days
      pos = (t - start) / 2678400000;
    }
    pos = 100 * pos;
    return pos;
  }

  // Resizable interface
  /**
   * Resize
   *
   * Parent takes care of setting proper width & height for the containing div
   * here we just need to adjust the events to fit the new size.
   */
  resize() {
    if (this.disabled || !this.div.is(':visible') || this.getParent().disabled) {
      return;
    }
    var row = jQuery('<div class="calendar_plannerEventRowWidget"></div>').appendTo(this.rows);
    this._row_height = parseInt(window.getComputedStyle(row[0]).getPropertyValue("height")) || 20;
    row.remove();

    // Resize & position all events
    this.position_event();
  }
}
_defineProperty$6(et2_calendar_planner_row, "_attributes", {
  start_date: {
    name: "Start date",
    type: "any"
  },
  end_date: {
    name: "End date",
    type: "any"
  },
  value: {
    type: "any"
  }
});
et2_register_widget(et2_calendar_planner_row, ["calendar-planner_row"]);

function _defineProperty$5(e, r, t) { return (r = _toPropertyKey$5(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$5(t) { var i = _toPrimitive$5(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$5(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * Class for a single event, displayed in either the timegrid or planner view
 *
 * It is possible to directly provide all information directly, but calendar
 * uses egw.data for caching, so ID is all that is needed.
 *
 * Note that there are several pieces of information that have 'ID' in them:
 * - row_id - used by both et2_calendar_event and the nextmatch to uniquely
 *	identify a particular entry or entry ocurrence
 * - id - Recurring events may have their recurrence as a timestamp after their ID,
 *	such as '194:1453318200', or not.  It's usually (always?) the same as row ID.
 * - app_id - the ID according to the source application.  For calendar, this
 *	is the same as ID (but always with the recurrence), for other apps this is
 *	usually just an integer.  With app_id and app, you should be able to call
 *	egw.open() and get the specific entry.
 * - Events from other apps will have their app name prepended to their ID, such
 *	as 'infolog123', so app_id and id will be different for these events
 * - Cache ID is the same as other apps, and looks like 'calendar::<row_id>'
 * - The DOM ID for the containing div is event_<row_id>
 *
 * Events are expected to be added to either et2_calendar_daycol or
 * et2_calendar_planner_row rather than either et2_calendar_timegrid or
 * et2_calendar_planner directly.
 *
 */
class et2_calendar_event extends et2_valueWidget {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_calendar_event._attributes, _child || {}));
    _defineProperty$5(this, "div", void 0);
    _defineProperty$5(this, "title", void 0);
    _defineProperty$5(this, "body", void 0);
    _defineProperty$5(this, "icons", void 0);
    _defineProperty$5(this, "_need_actions_linked", false);
    _defineProperty$5(this, "_actionObject", void 0);
    var event = this;

    // Main container
    this.div = jQuery(document.createElement("div")).addClass("calendar_calEvent").addClass(this.options.class).css('width', this.options.width).on('mouseenter', function () {
      // Bind actions on first mouseover for faster creation
      if (event._need_actions_linked) {
        event._copy_parent_actions();
      }
      // Tooltip
      if (!event._tooltipElem) {
        event.options.statustext_html = true;
        event.set_statustext(event._tooltip());
        // Rebind with options
        event.egw().tooltipUnbind(event._tooltipElem);
        event.egw().tooltipBind(event.getTooltipElement(), event.statustext, event.options.statustext_html, {
          hideonhover: false
        });
        if (event.statustext) {
          return jQuery(event.getTooltipElement()).trigger('mouseenter');
        }
      }
      // Hacky to remove egw's tooltip border and let the mouse in
      window.setTimeout(function () {
        jQuery('body .egw_tooltip').css('border', 'none').on('mouseenter', function () {
          if (event.div) {
            event.div.off('mouseleave.tooltip');
          }
          jQuery(this).stop(true).fadeTo(400, 1).on('mouseleave', function () {
            jQuery(this).fadeOut('400', function () {
              event.egw().tooltipCancel();
            });
          });
        });
      }, 105);
    });
    this.title = jQuery(document.createElement('div')).addClass("calendar_calEventHeader").appendTo(this.div);
    this.body = jQuery(document.createElement('div')).addClass("calendar_calEventBody").appendTo(this.div);
    this.icons = jQuery(document.createElement('div')).addClass("calendar_calEventIcons").appendTo(this.title);
    this.setDOMNode(this.div[0]);
  }
  doLoadingFinished() {
    super.doLoadingFinished();

    // Already know what is needed to hook to cache
    if (this.options.value && this.options.value.row_id) {
      egw$1.dataRegisterUID('calendar::' + this.options.value.row_id, this._UID_callback, this, this.getInstanceManager().execId, this.id);
    }
    return true;
  }
  destroy() {
    var _this$div, _this$title, _this$body, _this$div2;
    super.destroy();
    if (this._actionObject) {
      this._actionObject.remove();
      this._actionObject = null;
    }
    (_this$div = this.div) === null || _this$div === void 0 || _this$div.off();
    (_this$title = this.title) === null || _this$title === void 0 || _this$title.remove();
    this.title = null;
    (_this$body = this.body) === null || _this$body === void 0 || _this$body.remove();
    this.body = null;
    this.icons = null;
    (_this$div2 = this.div) === null || _this$div2 === void 0 || _this$div2.remove();
    this.div = null;
    jQuery('body.egw_tooltip').remove();

    // Unregister, or we'll continue to be notified...
    if (this.options.value) {
      var old_app_id = this.options.value.row_id;
      egw$1.dataUnregisterUID('calendar::' + old_app_id, null, this);
    }
  }
  set_value(_value) {
    // Un-register for updates
    if (this.options.value) {
      var old_id = this.options.value.row_id;
      if (!_value || !_value.row_id || old_id !== _value.row_id) {
        egw$1.dataUnregisterUID('calendar::' + old_id, null, this);
      }
    }
    this.options.value = _value;

    // Register for updates
    var id = this.options.value.row_id;
    if (!old_id || old_id !== id) {
      egw$1.dataRegisterUID('calendar::' + id, this._UID_callback, this, this.getInstanceManager().execId, this.id);
    }
    if (_value && !egw$1.dataHasUID('calendar::' + id)) {
      egw$1.dataStoreUID('calendar::' + id, _value);
    }
  }

  /**
   * Callback for changes in cached data
   */
  _UID_callback(event) {
    // Copy to avoid changes, which may cause nm problems
    var value = event === null ? null : jQuery.extend({}, event);
    var parent = this.getParent();
    var parent_owner = parent.getDOMNode(parent).dataset['owner'] || parent.getParent().options.owner;
    if (parent_owner.indexOf(',') >= 0) {
      parent_owner = parent_owner.split(',');
    }

    // Make sure id is a string, check values
    if (value) {
      this._values_check(value);
    }

    // Check for changing days in the grid view
    var state = this.getInstanceManager().app_obj.calendar.getState() || app.calendar.getState();
    if (!this._sameday_check(value) || !this._status_check(value, state.status_filter, parent_owner)) {
      // May need to update parent to remove out-of-view events
      parent.removeChild(this);
      if (event === null && parent && parent.instanceOf(et2_calendar_daycol)) {
        parent._out_of_view();
      }

      // This should now cease to exist, as new events have been created
      this.destroy();
      return;
    }

    // Copy to avoid changes, which may cause nm problems
    this.options.value = jQuery.extend({}, value);
    if (this.getParent().options.date) {
      this.options.value.date = this.getParent().options.date;
    }

    // Let parent position - could also be et2_calendar_planner_row
    this.getParent().position_event(this);

    // Parent may remove this if the date isn't the same
    if (this.getParent()) {
      this._update();
    }
  }

  /**
   * Draw the event
   */
  _update() {
    // Update to reflect new information
    var event = this.options.value;
    var id = event.row_id ? event.row_id : event.id + (event.recur_type ? ':' + event.recur_date : '');
    var formatted_start = event.start.toJSON();
    this.set_id('event_' + id);
    if (this._actionObject) {
      this._actionObject.id = 'calendar::' + id;
    }
    this._need_actions_linked = !this.options.readonly;

    // Make sure category stuff is there by faking a call to cache
    StaticOptions.cached_server_side({
      nodeName: "ET2-SELECT-CAT_RO",
      egw: () => this.egw()
    }, "select-cat", ",,,calendar", true);

    // Need cleaning? (DnD helper removes content)
    // @ts-ignore
    if (!this.div.has(this.title).length) {
      this.div.empty().append(this.title).append(this.body);
    }
    var tooltip = jQuery(this._tooltip()).text();
    // DOM nodes
    this.div
    // Set full day flag
    .attr('data-full_day', event.whole_day)

    // Put everything we need for basic interaction here, so it's available immediately
    .attr('data-id', event.id).attr('data-app', event.app || 'calendar').attr('data-app_id', event.app_id).attr('data-start', formatted_start).attr('data-owner', event.owner).attr('data-recur_type', event.recur_type).attr('data-resize', event.whole_day ? 'WD' : '' + (event.recur_type ? 'S' : '')).attr('data-priority', event.priority)
    // Accessibility
    .attr("tabindex", 0).attr("aria-label", tooltip)
    // Remove any category classes
    .removeClass(function (index, css) {
      return (css.match(/(^|\s)cat_\S+/g) || []).join(' ');
    })
    // Remove any status classes
    .removeClass(function (index, css) {
      return (css.match(/calendar_calEvent\S+/g) || []).join(' ');
    }).removeClass('calendar_calEventSmall').addClass(event.class).toggleClass('calendar_calEventPrivate', typeof event.private !== 'undefined' && event.private);
    this.options.class = event.class;
    var status_class = this._status_class();

    // Add category classes, if real categories are set
    if (event.category && event.category != '0') {
      var cats = event.category.split(',');
      for (var i = 0; i < cats.length; i++) {
        this.div.addClass('cat_' + cats[i]);
      }
    }
    this.div.toggleClass('calendar_calEventUnknown', event.participants[egw$1.user('account_id')] ? event.participants[egw$1.user('account_id')][0] === 'U' : false);
    this.div.addClass(status_class);
    this.body.toggleClass('calendar_calEventBodySmall', event.whole_day_on_top || false);

    // Header
    var title = egw$1.htmlspecialchars(event['title']);
    this.title.html('<span class="calendar_calTimespan">' + this._get_timespan(event) + '<br /></span>').append('<span class="calendar_calEventTitle">' + title + '</span>');

    // Colors - don't make them transparent if there is no color
    var bg_color = new rt(this.div.css('background-color'));
    if (bg_color.RGBA != 'rgb(0,0,0,0)') {
      // Most statuses use colored borders
      this.div.css('border-color', bg_color.RGBA);
    }
    this.icons.appendTo(this.title).html(this._icons().join(''));

    // Body
    if (event.whole_day_on_top) {
      this.body.html(title);
    } else {
      // @ts-ignore
      var start_time = formatTime(event.start).trim();
      this.body.html('<span class="calendar_calEventTitle">' + title + '</span>').append('<span class="calendar_calTimespan">' + start_time + '</span>');
      if (this.options.value.description.trim()) {
        this.body.append('<p>' + egw$1.htmlspecialchars(this.options.value.description) + '</p>');
      }
    }

    // Clear tooltip for regeneration
    this.set_statustext('');

    // Height specific section
    // This can take an unreasonable amount of time if parent is hidden
    if (jQuery(this.getParent().getDOMNode(this)).is(':visible')) {
      this._small_size();
    }
  }

  /**
   * Calculate display variants for when event is too short for full display
   *
   * Display is based on the number of visible lines, calculated off the header
   * height:
   * 1 - show just the event title, with ellipsis
   * 2 - Show timespan and title, with ellipsis
   * > 4 - Show description as well, truncated to fit
   */
  _small_size() {
    if (this.options.value.whole_day_on_top) return;

    // Skip for planner view, it's always small
    if (this.getParent() && this.getParent().instanceOf(et2_calendar_planner_row)) return;

    // Pre-calculation reset
    this.div.removeClass('calendar_calEventSmall');
    this.body.css('height', 'auto');
    var line_height = parseFloat(this.div.css('line-height'));
    var visible_lines = Math.floor(this.div.innerHeight() / line_height);
    if (!this.title[0].clientHeight) {
      // Handle sizing while hidden, such as when calendar is not the active tab
      visible_lines = 1;
    }
    visible_lines = Math.max(1, visible_lines);
    if (this.getParent() && this.getParent().instanceOf(et2_calendar_daycol)) {
      this.div.toggleClass('calendar_calEventSmall', visible_lines < 4);
      this.div.attr('data-visible_lines', visible_lines);
    } else if (this.getParent() && this.getParent().instanceOf(et2_calendar_planner_row)) {
      // Less than 8 hours is small
      this.div.toggleClass('calendar_calEventSmall', this.options.value.end.valueOf() - this.options.value.start.valueOf() < 28800000);
    }
    if (this.body.height() > this.div.height() - this.title.height() && visible_lines >= 4) {
      this.body.css('height', Math.floor((visible_lines - 1) * line_height - this.title.height()) + 'px');
    } else {
      this.body.css('height', '');
    }
  }

  /**
   * Examines the participants & returns CSS classname for status
   *
   * @returns {String}
   */
  _status_class() {
    var status_class = 'calendar_calEventAllAccepted';
    for (var id in this.options.value.participants) {
      var status = this.options.value.participants[id];
      status = et2_calendar_event.split_status(status);
      switch (status) {
        case 'A':
        case '':
          // app without status
          break;
        case 'U':
          status_class = 'calendar_calEventSomeUnknown';
          return status_class;
        // break for
        default:
          status_class = 'calendar_calEventAllAnswered';
          break;
      }
    }
    return status_class;
  }

  /**
   * Create tooltip shown on hover
   *
   * @return {String}
   */
  _tooltip() {
    if (!this.div || !this.options.value || !this.options.value.app_id) {
      return '';
    }
    var border = this.div.css('borderTopColor');
    var bg_color = this.div.css('background-color');
    var header_color = this.title.css('color');
    var timespan = this._get_timespan(this.options.value);
    var parent = this.getParent() instanceof et2_calendar_daycol ? this.getParent() : this.getParent();
    var start = parent.date_helper(this.options.value.start);
    var end = parent.date_helper(this.options.value.end);
    var times = !this.options.value.multiday ? '<span class="calendar_calEventLabel">' + this.egw().lang('Time') + '</span>: ' + timespan : '<span class="calendar_calEventLabel">' + this.egw().lang('Start') + '</span>:&nbsp;' + formatDateTime(start).replace(' ', '&nbsp;') + ' ' + '<span class="calendar_calEventLabel">' + this.egw().lang('End') + '</span>:&nbsp;' + formatDateTime(end).replace(' ', '&nbsp;');
    var cat_label = '';
    if (this.options.value.category) {
      var _options$find;
      var options = StaticOptions.cached_server_side({
        nodeName: "ET2-SELECT-CAT_RO",
        egw: () => this.egw()
      }, "select-cat", ",,calendar", false) || [];
      cat_label = ((_options$find = options.find(o => o.value == this.options.value.category)) === null || _options$find === void 0 ? void 0 : _options$find.label) || "";
    }

    // Activate links in description
    var description_node = document.createElement("p");
    description_node.className = "calendar_calEvent_description";
    et2_insertLinkText(et2_activateLinks(this.options.value.description), description_node, '_blank');

    // Location + Videoconference
    var location = '';
    if (this.options.value.location || this.options.value['##videoconference']) {
      location = '<p>';
      var location_node = document.createElement("span");
      location_node.className = "calendar_calEventLabel";
      et2_insertLinkText(et2_activateLinks(this.egw().lang('Location') + ': ' + this.options.value.location), location_node, '_blank');
      location += location_node.outerHTML;
      if (this.options.value['##videoconference']) {
        // Click handler is set in _bind_videoconference()
        location += (this.options.value.location.trim() ? '<br />' : '') + '<span data-videoconference="' + this.options.value['##videoconference'] + '" data-id="' + this.options.value['id'] + '" data-app_id="' + this.options.value['app_id'] + '" data-title="' + this.options.value['title'] + '" data-start="' + this.options.value['start'].toJSON() + '" data-end="' + this.options.value['end'].toJSON() + '">' + this.egw().lang('Video conference') + '<img src="' + this.egw().image('videoconference', 'calendar') + '"/></span>';
        this._bind_videoconference();
      }
      location += '</p>';
    }

    // Participants
    var participants = '';
    if (this.options.value.participant_types['']) {
      participants += this.options.value.participant_types[''].join("<br />");
    }
    for (var type_name in this.options.value.participant_types) {
      if (type_name) {
        participants += '</p><p><span class="calendar_calEventLabel">' + type_name + ':</span><br />';
        participants += this.options.value.participant_types[type_name].join("<br />");
      }
    }
    return '<div class="calendar_calEventTooltip ' + this._status_class() + ' ' + this.options.class + '" style="border-color: ' + border + '; background-color: ' + bg_color + ';">' + '<div class="calendar_calEventHeaderSmall">' + '<span style="color:' + header_color + '">' + timespan + '</span>' + this.icons[0].outerHTML + '</div>' + '<div class="calendar_calEventBody">' + '<h1 class="calendar_calEventTitle">' + egw$1.htmlspecialchars(this.options.value.title) + '</h1><br>' + description_node.outerHTML + '<p style="margin: 2px 0px;">' + times + '</p>' + location + (cat_label ? '<p><h2 class="calendar_calEventLabel">' + this.egw().lang('Category') + ': </h2>' + cat_label + '</p>' : '') + '<p><h2 class="calendar_calEventLabel">' + this.egw().lang('Participants') + ': </h2><br />' + participants + '</p>' + this._participant_summary(this.options.value.participants) + '</div>' + '</div>';
  }

  /**
   * Generate participant summary line
   *
   * @returns {String}
   */
  _participant_summary(participants) {
    if (Object.keys(this.options.value.participants).length < 2) {
      return '';
    }
    var participant_status = {
      A: 0,
      R: 0,
      T: 0,
      U: 0,
      D: 0
    };
    var status_label = {
      A: 'accepted',
      R: 'rejected',
      T: 'tentative',
      U: 'unknown',
      D: 'delegated'
    };
    var participant_summary = Object.keys(this.options.value.participants).length + ' ' + this.egw().lang('Participants') + ': ';
    var status_totals = [];
    for (var id in this.options.value.participants) {
      var status = this.options.value.participants[id].substr(0, 1);
      participant_status[status]++;
    }
    for (var _status in participant_status) {
      if (participant_status[_status] > 0) {
        status_totals.push(participant_status[_status] + ' ' + this.egw().lang(status_label[_status]));
      }
    }
    return participant_summary + status_totals.join(', ');
  }

  /**
   * Get actual icons from list
   */
  _icons() {
    var icons = [];
    if (this.options.value.is_private) {
      // Hide everything
      icons.push('<img src="' + this.egw().image('private', 'calendar') + '" title="' + this.egw().lang('private event') + '"/>');
    } else {
      if (this.options.value.icons) {
        jQuery.extend(icons, this.options.value.icons);
      } else if (this.options.value.app !== 'calendar') {
        var app_icon = "" + (egw$1.link_get_registry(this.options.value.app, 'icon') || this.options.value.app + '/navbar');
        icons.push('<img src="' + this.egw().image(app_icon) + '" title="' + this.egw().lang(this.options.value.app) + '"/>');
      }
      if (this.options.value.priority == 3) {
        icons.push('<img src="' + this.egw().image('high', 'calendar') + '" title="' + this.egw().lang('high priority') + '"/>');
      }
      if (this.options.value.public == '0') {
        // Show private flag
        icons.push('<img src="' + this.egw().image('private', 'calendar') + '" title="' + this.egw().lang('private event') + '"/>');
      }
      if (this.options.value['recur_type']) {
        icons.push('<img src="' + this.egw().image('recur', 'calendar') + '" title="' + this.egw().lang('recurring event') + '"/>');
      }
      // icons for single user, multiple users or group(s) and resources
      var single = '<img src="' + this.egw().image('single', 'calendar') + '" title="' + this.egw().lang("single participant") + '"/>';
      var multiple = '<img src="' + this.egw().image('users', 'calendar') + '" title="' + this.egw().lang("multiple participants") + '"/>';
      for (var uid in this.options.value['participants']) {
        // @ts-ignore
        if (Object.keys(this.options.value.participants).length == 1 && !isNaN(uid)) {
          icons.push(single);
          break;
        }
        // @ts-ignore
        if (!isNaN(uid) && icons.indexOf(multiple) === -1) {
          icons.push(multiple);
        }
        /*
         * TODO: resource icons
        elseif(!isset($icons[$uid[0]]) && isset($this->bo->resources[$uid[0]]) && isset($this->bo->resources[$uid[0]]['icon']))
        {
        	 $icons[$uid[0]] = html::image($this->bo->resources[$uid[0]]['app'],
        		 ($this->bo->resources[$uid[0]]['icon'] ? $this->bo->resources[$uid[0]]['icon'] : 'navbar'),
        		 lang($this->bo->resources[$uid[0]]['app']),
        		 'width="16px" height="16px"');
        }
        */
      }

      if (this.options.value.alarm && !jQuery.isEmptyObject(this.options.value.alarm) && !this.options.value.is_private) {
        icons.push('<img src="' + this.egw().image('notification_message') + '" title="' + this.egw().lang('alarm') + '"/>');
      }
      if (this.options.value.participants[egw$1.user('account_id')] && this.options.value.participants[egw$1.user('account_id')][0] == 'U') {
        icons.push('<img src="' + this.egw().image('needs-action', 'calendar') + '" title="' + this.egw().lang('Needs action') + '"/>');
      }
      if (this.options.value["##videoconference"]) {
        icons.push('<img src="' + this.egw().image('videoconference', 'calendar') + '" title="' + this.egw().lang('video conference') + '"/>');
      }
    }

    // Always include non-blocking, regardless of privacy
    if (this.options.value.non_blocking) {
      icons.push('<img src="' + this.egw().image('nonblocking', 'calendar') + '" title="' + this.egw().lang('non blocking') + '"/>');
    }
    return icons;
  }

  /**
   * Bind the click handler for opening the video conference
   *
   * Tooltips are placed in the DOM directly in the body, managed by egw.
   */
  _bind_videoconference() {
    var vc_event = 'click.calendar_videoconference';
    jQuery('body').off(vc_event).on(vc_event, '[data-videoconference]', function (event) {
      var data = egw$1.dataGetUIDdata("calendar::" + this.dataset.app_id);
      app.calendar.joinVideoConference(this.dataset.videoconference, (data === null || data === void 0 ? void 0 : data.data) || this.dataset);
    });
  }

  /**
   * Get a text representation of the timespan of the event.  Either start
   * - end, or 'all day'
   *
   * @param {Object} event Event to get the timespan for
   * @param {number} event.start_m Event start, in minutes from midnight
   * @param {number} event.end_m Event end, in minutes from midnight
   *
   * @return {string} Timespan
   */
  _get_timespan(event) {
    var timespan = '';
    if (event['start_m'] === 0 && event['end_m'] >= 24 * 60 - 1) {
      if (event['end_m'] > 24 * 60) {
        // @ts-ignore
        timespan = formatTime(event.start)
        // @ts-ignore
        .trim() + ' - ' + formatTime(event.end).trim();
      } else {
        timespan = this.egw().lang('Whole day');
      }
    } else {
      var duration = event.multiday ? (event.end - event.start) / 60000 : event.end_m - event.start_m;
      duration = Math.floor(duration / 60) + this.egw().lang('h') + (duration % 60 ? duration % 60 : '');

      // @ts-ignore
      timespan = formatTime(event.start).trim();

      // @ts-ignore
      timespan += ' - ' + formatTime(event.end);
      timespan += ': ' + duration;
    }
    return timespan;
  }

  /**
   * Make sure event data has all proper values, and format them as expected
   * @param {Object} event
   */
  _values_check(event) {
    // Make sure ID is a string
    if (event.id) {
      event.id = '' + event.id;
    }

    // Parent might be a daycol or a planner_row
    var parent = this.getParent();

    // Use dates as objects
    if (typeof event.start !== 'object') {
      event.start = parent.date_helper(event.start);
    }
    if (typeof event.end !== 'object') {
      event.end = parent.date_helper(event.end);
    }

    // We need minutes for durations
    if (typeof event.start_m === 'undefined') {
      event.start_m = event.start.getUTCHours() * 60 + event.start.getUTCMinutes();
      event.end_m = event.end.getUTCHours() * 60 + event.end.getUTCMinutes();
    }
    if (typeof event.multiday === 'undefined') {
      event.multiday = event.start.getUTCFullYear() !== event.end.getUTCFullYear() || event.start.getUTCMonth() !== event.end.getUTCMonth() || event.start.getUTCDate() != event.end.getUTCDate();
    }
    if (!event.start.getUTCHours() && !event.start.getUTCMinutes() && event.end.getUTCHours() == 23 && event.end.getUTCMinutes() == 59) {
      event.whole_day_on_top = event.non_blocking && event.non_blocking != '0';
    }
  }

  /**
   * Check to see if the provided event information is for the same date as
   * what we're currently expecting, and that it has not been changed.
   *
   * If the date has changed, we adjust the associated daywise caches to move
   * the event's ID to where it should be.  This check allows us to be more
   * directly reliant on the data cache, and less on any other control logic
   * elsewhere first.
   *
   * @param {Object} event Map of event data from cache
   * @param {string} event.date For non-recurring, single day events, this is
   *	the date the event is on.
   * @param {string} event.start Start of the event (used for multi-day events)
   * @param {string} event.end End of the event (used for multi-day events)
   *
   * @return {Boolean} Provided event data is for the same date
   */
  _sameday_check(event) {
    // Event somehow got orphaned, or deleted
    if (!this.getParent() || event === null) {
      return false;
    }

    // Also check participants against owner
    var owner_match = et2_calendar_event.owner_check(event, this.getParent());

    // Simple, same day
    if (owner_match && this.options.value.date && event.date == this.options.value.date) {
      return true;
    }

    // Multi-day non-recurring event spans days - date does not match
    var event_start = new Date(event.start);
    var event_end = new Date(event.end);
    var parent = this.getParent();
    if (owner_match && parent instanceof et2_calendar_daycol && parent.getDate() >= event_start && parent.getDate() <= event_end) {
      return true;
    }

    // Delete all old actions
    if (this._actionObject) {
      this._actionObject.clear();
      this._actionObject.unregisterActions();
      this._actionObject = null;
    }

    // Update daywise caches
    var new_cache_id = CalendarApp._daywise_cache_id(event.date, this.getParent().options.owner);
    var new_daywise = egw$1.dataGetUIDdata(new_cache_id);
    new_daywise = new_daywise && new_daywise.data ? new_daywise.data : [];
    var old_cache_id = '';
    if (this.options.value && this.options.value.date) {
      old_cache_id = CalendarApp._daywise_cache_id(this.options.value.date, parent.options.owner);
    }
    if (new_cache_id != old_cache_id) {
      var old_daywise = egw$1.dataGetUIDdata(old_cache_id);
      old_daywise = old_daywise && old_daywise.data ? old_daywise.data : [];
      old_daywise.splice(old_daywise.indexOf(this.options.value.row_id), 1);
      egw$1.dataStoreUID(old_cache_id, old_daywise);
      if (new_daywise.indexOf(event.row_id) < 0) {
        new_daywise.push(event.row_id);
      }
      if (egw$1.dataHasUID(new_cache_id)) {
        egw$1.dataStoreUID(new_cache_id, new_daywise);
      }
    }
    return false;
  }

  /**
   * Check that the event passes the given status filter.
   * Status filter is set in the sidebox and used when fetching several events, but if user changes their status
   * for an event, it may no longer match and have to be removed.
   *
   * @param event
   * @param filter
   * @param owner The owner of the target / parent, not the event owner
   * @private
   */
  _status_check(event, filter, owner) {
    if (!owner || !event) {
      return false;
    }

    // If we're doing a bunch, just one passing is enough
    if (typeof owner !== "string") {
      var pass = false;
      for (var j = 0; j < owner.length && pass == false; j++) {
        pass = pass || this._status_check(event, filter, owner[j]);
      }
      return pass;
    }

    // Show also events just owned by selected user
    // Group members can be owner too, those get handled when we check group memberships below
    if (filter == 'owner' && owner == event.owner) {
      return true;
    }

    // Get the relevant participant
    var participant = event.participants[owner];

    // If filter says don't look in groups, skip it all
    if (!participant && filter === 'no-enum-groups') {
      return false;
    }

    // Couldn't find the current owner in the participant list, check groups & resources
    if (!participant) {
      var options = null;
      if (app.calendar && app.calendar.sidebox_et2 && app.calendar.sidebox_et2.getWidgetById('owner')) {
        options = app.calendar.sidebox_et2.getWidgetById('owner').select_options;
      }
      if ((isNaN(parseInt(owner)) || parseInt(owner) < 0) && options && typeof options.find == "function") {
        var resource = options.find(function (element) {
          return element.value == owner;
        }) || {};
        var matching_participant = typeof resource.resources == "undefined" ? resource : resource === null || resource === void 0 ? void 0 : resource.resources.filter(id => typeof event.participants[id] != "undefined");
        if (matching_participant.length > 0) {
          return this._status_check(event, filter, matching_participant);
        } else if (filter == 'owner' && resource && resource.resources && resource.resources.indexOf(event.owner)) {
          // owner param was a group but event is owned by someone in that group
          return true;
        }
      }
    }
    var status = et2_calendar_event.split_status(participant);
    switch (filter) {
      default:
      case 'all':
        return true;
      case 'default':
        // Show all status, but rejected
        return status !== 'R';
      case 'accepted':
        //Show only accepted events
        return status === 'A';
      case 'unknown':
        // Show only invitations, not yet accepted or rejected
        return status === 'U';
      case 'tentative':
        // Show only tentative accepted events
        return status === 'T';
      case 'delegated':
        // Show only delegated events
        return status === 'D';
      case 'rejected':
        // Show only rejected events
        return status === 'R';
      // Handled above
      //case 'owner': // Show also events just owned by selected user
      case 'hideprivate':
        // Show all events, as if they were private
        // handled server-side
        return true;
      case 'showonlypublic':
        // Show only events flagged as public, -not checked as private
        return event.public == '1';
      // Handled above
      // case 'no-enum-groups': // Do not include events of group members
      case 'not-unknown':
        // Show all status, but unknown
        return status !== 'U';
      case 'deleted':
        // Show events that have been deleted
        return event.deleted;
    }
  }
  attachToDOM() {
    var result = super.attachToDOM();

    // Remove the binding for the click handler, unless there's something
    // custom here.
    if (!this.onclick) {
      jQuery(this.node).off("click");
    }
    return result;
  }

  /**
   * Click handler calling custom handler set via onclick attribute to this.onclick.
   * All other handling is done by the timegrid widget.
   *
   * @param {Event} _ev
   * @returns {boolean}
   */
  click(_ev) {
    var result = true;
    if (typeof this.onclick == 'function') {
      // Make sure function gets a reference to the widget, splice it in as 2. argument if not
      var args = Array.prototype.slice.call(arguments);
      if (args.indexOf(this) == -1) args.splice(1, 0, this);
      result = this.onclick.apply(this, args);
    }
    _ev.stopImmediatePropagation();
    return result;
  }

  /**
   * Show the recur prompt for this event
   *
   * Calls et2_calendar_event.recur_prompt with this event's value.
   *
   * @param {et2_calendar_event~prompt_callback} callback
   * @param {Object} [extra_data]
   */
  recur_prompt(callback, extra_data) {
    et2_calendar_event.recur_prompt(this.options.value, callback, extra_data);
  }

  /**
   * Show the series split prompt for this event
   *
   * Calls et2_calendar_event.series_split_prompt with this event's value.
   *
   * @param {et2_calendar_event~prompt_callback} callback
   */
  series_split_prompt(callback) {
    et2_calendar_event.series_split_prompt(this.options.value, this.options.value.recur_date, callback);
  }

  /**
   * Copy the actions set on the parent, apply them to self
   *
   * This can take a while to do, so we try to do it only when needed - on mouseover
   */
  _copy_parent_actions() {
    // Copy actions set in parent
    if (!this.options.readonly && this.getParent() && !this.getParent().options.readonly) {
      var action_parent = this;
      while (action_parent != null && !action_parent.options.actions && !(action_parent instanceof et2_container)) {
        action_parent = action_parent.getParent();
      }
      try {
        this._link_actions(action_parent.options.actions || {});
        this._need_actions_linked = false;
      } catch (e) {
        // something went wrong, but keep quiet about it
      }
    }
  }

  /**
   * Link the actions to the DOM nodes / widget bits.
   *
   * @param {object} actions {ID: {attributes..}+} map of egw action information
   */
  _link_actions(actions) {
    if (!this._actionObject) {
      // Get the top level element - timegrid or so
      var objectManager = this.getParent()._actionObject || this.getParent().getParent()._actionObject || egw_getAppObjectManager(true).getObjectById(this.getParent().getParent().getParent().id) || egw_getAppObjectManager(true);
      this._actionObject = objectManager.getObjectById('calendar::' + this.options.value.row_id);
    }
    if (this._actionObject == null) {
      // Add a new container to the object manager which will hold the widget
      // objects
      this._actionObject = objectManager.insertObject(false, new egwActionObject('calendar::' + this.options.value.row_id, objectManager, et2_calendar_event.et2_event_action_object_impl(this, this.getDOMNode()), this._actionManager || objectManager.manager.getActionById('calendar::' + this.options.value.row_id) || objectManager.manager));
    } else {
      this._actionObject.setAOI(et2_calendar_event.et2_event_action_object_impl(this, this.getDOMNode(this)));
    }

    // Delete all old objects
    this._actionObject.clear();
    this._actionObject.unregisterActions();

    // Go over the widget & add links - this is where we decide which actions are
    // 'allowed' for this widget at this time
    var action_links = this._get_action_links(actions);
    action_links.push('egw_link_drag');
    action_links.push('egw_link_drop');
    if (this._actionObject.parent.getActionLink('invite')) {
      action_links.push('invite');
    }
    this._actionObject.updateActionLinks(action_links);
  }

  /**
   * Code for implementing et2_IDetachedDOM
   *
   * @param {array} _attrs array to add further attributes to
   */
  getDetachedAttributes(_attrs) {}
  getDetachedNodes() {
    return [this.getDOMNode()];
  }
  setDetachedAttributes(_nodes, _values) {}

  // Static class stuff
  /**
   * Check event owner against a parent object
   *
   * As an event is edited, its participants may change.  Also, as the state
   * changes we may change which events are displayed and show the same event
   * in several places for different users.  Here we check the event participants
   * against an owner value (which may be an array) to see if the event should be
   * displayed or included.
   *
   * @param {Object} event - Event information
   * @param {et2_widget_daycol|et2_widget_planner_row} parent - potential parent object
   *	that has an owner option
   * @param {boolean} [owner_too] - Include the event owner in consideration, or only
   *	event participants
   *
   * @return {boolean} Should the event be displayed
   */
  static owner_check(event, parent, owner_too) {
    var _app$calendar,
      _this = this;
    var owner_match = true;
    var state = (parent.getInstanceManager ? parent.getInstanceManager().app_obj.calendar.state : false) || ((_app$calendar = app.calendar) === null || _app$calendar === void 0 ? void 0 : _app$calendar.state) || {};
    if (typeof owner_too === 'undefined' && state.status_filter) {
      owner_too = state.status_filter === 'owner';
    }
    var options = null;
    if (app.calendar && app.calendar.sidebox_et2 && app.calendar.sidebox_et2.getWidgetById('owner')) {
      options = app.calendar.sidebox_et2.getWidgetById('owner').select_options;
    } else {
      options = parent.getArrayMgr("sel_options").getRoot().getEntry('owner');
    }
    if (event.participants && typeof parent.options.owner != 'undefined' && parent.options.owner.length > 0) {
      var parent_owner = jQuery.extend([], typeof parent.options.owner !== 'object' ? [parent.options.owner] : parent.options.owner);
      owner_match = false;
      if (!options) {
        // Could not find the owner options.  Probably on home, just let it go.
        owner_match = true;
      }
      var length = parent_owner.length;
      for (var i = 0; i < length; i++) {
        // Handle groups & grouped resources like mailing lists, they won't match so
        // we need the list - pull it from sidebox owner
        if ((isNaN(parent_owner[i]) || parent_owner[i] < 0) && options && typeof options.find == "function") {
          var resource = options.find(function (element) {
            return element.value == parent_owner[i];
          }) || {};
          if (resource && resource.resources) {
            parent_owner.splice(i, 1);
            i--;
            parent_owner = parent_owner.concat(resource.resources);
          }
        }
      }
      var participants = jQuery.extend([], Object.keys(event.participants));
      var _loop = function _loop() {
          var id = participants[i];
          // Expand group invitations
          if (parseInt(id) < 0) {
            // Add in groups, if we can get them from options, great

            if (options && options.find && (resource = options.find(function (element) {
              return element.value === id;
            })) && resource.resources) {
              participants = participants.concat(resource.resources);
            } else {
              // Add in groups, if we can get them (this is asynchronous)
              egw$1.accountData(id, 'account_id', true, function (members) {
                participants = participants.concat(Object.keys(members));
              }, _this);
            }
          }
          if (parent.options.owner == id || parent_owner.indexOf && parent_owner.indexOf(id) >= 0) {
            owner_match = true;
            return 1; // break
          }
        },
        resource;
      for (var i = 0; i < participants.length; i++) {
        if (_loop()) break;
      }
    }
    if (owner_too && !owner_match) {
      owner_match = parent.options.owner == event.owner || parent_owner.indexOf && parent_owner.indexOf(event.owner) >= 0;
    }
    return owner_match;
  }

  /**
   * @callback et2_calendar_event~prompt_callback
   * @param {string} button_id - One of ok, exception, series, single or cancel
   *	depending on which buttons are on the prompt
   * @param {Object} event_data - Event information - whatever you passed in to
   *	the prompt.
   */
  /**
   * Recur prompt
   * If the event is recurring, asks the user if they want to edit the event as
   * an exception, or change the whole series.  Then the callback is called.
   *
   * If callback is not provided, egw.open() will be used to open an edit dialog.
   *
   * If you call this on a single (non-recurring) event, the callback will be
   * executed immediately, with the passed button_id as 'single'.
   *
   * @param {Object} event_data - Event information
   * @param {string} event_data.id - Unique ID for the event, possibly with a
   *	timestamp
   * @param {string|Date} event_data.start - Start date/time for the event
   * @param {number} event_data.recur_type - Recur type, or 0 for a non-recurring event
   * @param {et2_calendar_event~prompt_callback} [callback] - Callback is
   *	called with the button (exception, series, single or cancel) and the event
   *	data.
   * @param {Object} [extra_data] - Additional data passed to the callback, used
   *	as extra parameters for default callback
   *
   * @augments {et2_calendar_event}
   */
  static recur_prompt(event_data, callback, extra_data) {
    var egw;
    var edit_id = event_data.app_id;
    var edit_date = event_data.start;

    // seems window.opener somehow in certain conditions could be from different origin
    // we try to catch the exception and in this case retrieve the egw object from current window.
    try {
      egw = this.egw ? typeof this.egw == 'function' ? this.egw() : this.egw : window.opener && typeof window.opener.egw != 'undefined' ? window.opener.egw('calendar') : window.egw('calendar');
    } catch (e) {
      egw = window.egw('calendar');
    }
    var that = this;
    var extra_params = extra_data && typeof extra_data == 'object' ? extra_data : {};
    extra_params.date = edit_date.toJSON ? edit_date.toJSON() : edit_date;
    if (typeof callback != 'function') {
      callback = function callback(_button_id) {
        switch (_button_id) {
          case 'exception':
            extra_params.exception = '1';
            egw.open(edit_id, event_data.app || 'calendar', 'edit', extra_params);
            break;
          case 'series':
          case 'single':
            egw.open(edit_id, event_data.app || 'calendar', 'edit', extra_params);
            break;
          case 'cancel':
          default:
            break;
        }
      };
    }
    if (parseInt(event_data.recur_type)) {
      var buttons = [{
        label: egw.lang("Edit exception"),
        id: "exception",
        class: "ui-priority-primary",
        default: true,
        image: 'edit'
      }, {
        label: egw.lang("Edit series"),
        id: "series",
        image: 'recur'
      }, {
        label: egw.lang("Cancel"),
        id: "cancel",
        image: 'cancel'
      }];
      Et2Dialog.show_dialog(function (button_id) {
        callback.call(that, button_id, event_data);
      }, (!event_data.is_private ? event_data['title'] : egw.lang('private')) + "\n" + egw.lang("Do you want to edit this event as an exception or the whole series?"), "This event is part of a series", {}, buttons, Et2Dialog.QUESTION_MESSAGE, "", egw);
    } else {
      callback.call(this, 'single', event_data);
    }
  }

  /**
   * Split series prompt
   *
   * If the event is recurring and the user adjusts the time or duration, we may need
   * to split the series, ending the current one and creating a new one with the changes.
   * This prompts the user if they really want to do that.
   *
   * There is no default callback, and nothing happens if you call this on a
   * single (non-recurring) event
   *
   * @param {Object} event_data - Event information
   * @param {string} event_data.id - Unique ID for the event, possibly with a timestamp
   * @param {string|Date} instance_date - The date of the edited instance of the event
   * @param {et2_calendar_event~prompt_callback} callback - Callback is
   *	called with the button (ok or cancel) and the event data.
   * @augments {et2_calendar_event}
   */
  static series_split_prompt(event_data, instance_date, callback) {
    var egw;
    // seems window.opener somehow in certian conditions could be from different origin
    // we try to catch the exception and in this case retrieve the egw object from current window.
    try {
      egw = this.egw ? typeof this.egw == 'function' ? this.egw() : this.egw : window.opener && typeof window.opener.egw != 'undefined' ? window.opener.egw('calendar') : window.egw('calendar');
    } catch (e) {
      egw = window.egw('calendar');
    }
    var that = this;
    if (typeof instance_date == 'string') {
      instance_date = new Date(instance_date);
    }

    // Check for modifying a series that started before today
    var tempDate = new Date();
    var today = new Date(tempDate.getFullYear(), tempDate.getMonth(), tempDate.getDate(), tempDate.getHours(), -tempDate.getTimezoneOffset(), tempDate.getSeconds());
    var termination_date = instance_date < today ? egw.lang('today') : formatDate(instance_date);
    if (parseInt(event_data.recur_type)) {
      Et2Dialog.show_dialog(function (button_id) {
        callback.call(that, button_id, event_data);
      }, (!event_data.is_private ? event_data['title'] : egw.lang('private')) + "\n" + egw.lang("Do you really want to change the start of this series? If you do, the original series will be terminated as of %1 and a new series for the future reflecting your changes will be created.", termination_date), "This event is part of a series", {}, Et2Dialog.BUTTONS_OK_CANCEL, Et2Dialog.WARNING_MESSAGE);
    }
  }
  static drag_helper(event, ui) {
    ui.helper.width(ui.width());
  }

  /**
   * splits the combined status, quantity and role
   *
   * @param {string} status - combined value, O: status letter: U, T, A, R
   * @param {int} [quantity] - quantity
   * @param {string} [role]
   * @return string status U, T, A or R, same as $status parameter on return
   */
  static split_status(status, quantity, role) {
    quantity = 1;
    role = 'REQ-PARTICIPANT';
    //error_log(__METHOD__.__LINE__.array2string($status));
    var matches = null;
    if (typeof status === 'string' && status.length > 1) {
      matches = status.match(/^.([0-9]*)(.*)$/gi);
    }
    if (matches) {
      if (parseInt(matches[1]) > 0) quantity = parseInt(matches[1]);
      if (matches[2]) role = matches[2];
      status = status[0];
    } else if (status === true) {
      status = 'U';
    }
    return status;
  }

  /**
   * The egw_action system requires an egwActionObjectInterface Interface implementation
   * to tie actions to DOM nodes.  I'm not sure if we need this.
   *
   * The class extension is different than the widgets
   *
   * @param {et2_DOMWidget} widget
   * @param {Object} node
   *
   */
  static et2_event_action_object_impl(widget, node) {
    var aoi = new et2_action_object_impl(widget, node).getAOI();

    // _outerCall may be used to determine, whether the state change has been
    // evoked from the outside and the stateChangeCallback has to be called
    // or not.
    aoi.doSetState = function (_state, _outerCall) {};
    return aoi;
  }
}
_defineProperty$5(et2_calendar_event, "_attributes", {
  "value": {
    type: "any",
    default: et2_no_init
  },
  "onclick": {
    "description": "JS code which is executed when the element is clicked. " + "If no handler is provided, or the handler returns true and the event is not read-only, the " + "event will be opened according to calendar settings."
  }
});
et2_register_widget(et2_calendar_event, ["calendar-event"]);

function asyncGeneratorStep$3(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator$3(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep$3(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep$3(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function _defineProperty$4(e, r, t) { return (r = _toPropertyKey$4(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$4(t) { var i = _toPrimitive$4(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$4(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * Class which implements the "calendar-timegrid" XET-Tag for displaying a single days
 *
 * This widget is responsible mostly for positioning its events
 *
 */
class et2_calendar_daycol extends et2_valueWidget {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_calendar_daycol._attributes, _child || {}));

    // Main container
    _defineProperty$4(this, "div", void 0);
    _defineProperty$4(this, "header", void 0);
    _defineProperty$4(this, "title", void 0);
    _defineProperty$4(this, "event_wrapper", void 0);
    _defineProperty$4(this, "user_spacer", void 0);
    _defineProperty$4(this, "all_day", void 0);
    _defineProperty$4(this, "registeredUID", null);
    // Init to defaults, just in case - they will be updated from parent
    _defineProperty$4(this, "display_settings", {
      wd_start: 60 * 9,
      wd_end: 60 * 17,
      granularity: 30,
      rowsToDisplay: 10,
      rowHeight: 20,
      // Percentage; not yet available
      titleHeight: 2.0
    });
    _defineProperty$4(this, "date", void 0);
    _defineProperty$4(this, "class", void 0);
    this.div = jQuery(document.createElement("div")).addClass("calendar_calDayCol").css('width', this.options.width).css('left', this.options.left);
    this.header = jQuery(document.createElement('div')).addClass("calendar_calDayColHeader").css('width', this.options.width).css('left', this.options.left);
    this.title = jQuery(document.createElement('div')).addClass('et2_clickable et2_link').appendTo(this.header);
    this.user_spacer = jQuery(document.createElement('div')).addClass("calendar_calDayColHeader_spacer").appendTo(this.header);
    this.all_day = jQuery(document.createElement('div')).addClass("calendar_calDayColAllDay").css('max-height', (egw$1.preference('limit_all_day_lines', 'calendar') || 3) * 1.4 + 'em').appendTo(this.header);
    this.event_wrapper = jQuery(document.createElement('div')).addClass("event_wrapper").appendTo(this.div);
    this.click = this.click.bind(this);
    this.setDOMNode(this.div[0]);
  }
  doLoadingFinished() {
    var result = super.doLoadingFinished();

    // Parent will have everything we need, just load it from there

    if (this.getParent() && this.getParent().options.owner) {
      this.set_owner(this.getParent().options.owner);
    }
    if (this.title.text() === '' && this.options.date && this.getParent() && this.getParent().instanceOf(et2_calendar_timegrid)) {
      // Forces an update
      var date = this.options.date;
      this.options.date = '';
      this.set_date(date);
    }
    return result;
  }
  destroy() {
    super.destroy();
    this.div.off();
    this.header.off().remove();
    this.title.off();
    this.div = null;
    this.header = null;
    this.title = null;
    this.user_spacer = null;
    egw$1.dataUnregisterUID(this.registeredUID, null, this);
  }
  getDOMNode(sender) {
    if (!sender || sender === this) return this.div[0];
    if (sender.instanceOf && sender.instanceOf(et2_calendar_event)) {
      if (this.display_settings.granularity === 0) {
        return this.event_wrapper[0];
      }
      if (sender.options.value.whole_day_on_top || sender.options.value.whole_day && sender.options.value.non_blocking === true) {
        return this.all_day[0];
      }
      return this.div[0];
    }
  }

  /**
   * Draw the individual divs for clicking to add an event
   */
  _draw() {
    // Remove any existing
    jQuery('.calendar_calAddEvent', this.div).remove();

    // Grab real values from parent
    if (this.getParent() && this.getParent().instanceOf(et2_calendar_timegrid)) {
      this.display_settings.wd_start = 60 * this.getParent().options.day_start;
      this.display_settings.wd_end = 60 * this.getParent().options.day_end;
      this.display_settings.granularity = this.getParent().options.granularity;
      var header = this.getParent().dayHeader.children();

      // Figure out insert index
      var idx = 0;
      var siblings = this.getParent().getDOMNode(this).childNodes;
      while (idx < siblings.length && siblings[idx] != this.getDOMNode()) {
        idx++;
      }
      // Stick header in the right place
      if (idx == 0) {
        this.getParent().dayHeader.prepend(this.header);
      } else if (header.length) {
        header.eq(Math.min(header.length, idx) - 1).after(this.header);
      }
    }
    this.div.attr('data-date', this.options.date);
  }
  getDate() {
    return this.date;
  }
  date_helper(value) {
    return this.getParent().date_helper(value);
  }

  /**
   * Set the date
   *
   * @param {string|Date} _date New date
   * @param {Object[]} events =false List of event data to be displayed, or false to
   *	automatically fetch data from content array
   * @param {boolean} force_redraw =false Redraw even if the date is the same.
   *	Used for when new data is available.
   */
  set_date(_date, events, force_redraw) {
    if (typeof events === 'undefined' || !events) {
      events = false;
    }
    if (typeof force_redraw === 'undefined' || !force_redraw) {
      force_redraw = false;
    }
    if (!this.getParent()) {
      egw$1.debug('warn', 'Day col widget "' + this.id + '" is missing its parent.');
      return false;
    }
    this.date = this.getParent().date_helper(_date);

    // Keep internal option in Ymd format, it gets passed around in this format
    var new_date = formatDate(this.date, {
      dateFormat: "Ymd"
    });

    // Set label
    if (!this.options.label) {
      // Add timezone offset back in, or formatDate will lose those hours
      var _formatDate = new Date(this.date.valueOf() + this.date.getTimezoneOffset() * 60 * 1000);
      this.title.html('<span class="long_date">' + egw$1.lang(flatpickr.formatDate(_formatDate, 'l')) + '</span><span class="short_date">' + egw$1.lang(flatpickr.formatDate(_formatDate, 'D')) + '</span>' + flatpickr.formatDate(_formatDate, 'd'));
    }
    this.title.attr("data-date", new_date).toggleClass('et2_label', !!this.options.label);
    this.header.attr('data-date', new_date).attr('data-whole_day', true);

    // Avoid redrawing if date is the same
    if (new_date === this.options.date && this.display_settings.granularity === this.getParent().options.granularity && !force_redraw) {
      return;
    }
    var cache_id = CalendarApp._daywise_cache_id(new_date, this.options.owner);
    if (this.options.date && this.registeredUID && cache_id !== this.registeredUID) {
      egw$1.dataUnregisterUID(this.registeredUID, null, this);

      // Remove existing events
      while (this._children.length > 0) {
        var node = this._children[this._children.length - 1];
        this.removeChild(node);
        node.destroy();
      }
    }
    this.options.date = new_date;

    // Set holiday and today classes
    this.day_class_holiday();

    // Update all the little boxes
    this._draw();

    // Register for updates on events for this day
    if (this.registeredUID !== cache_id) {
      this.registeredUID = cache_id;
      egw$1.dataRegisterUID(this.registeredUID, this._data_callback, this, this.getInstanceManager().execId, this.id);
    }
  }

  /**
   * Set the owner of this day
   *
   * @param {number|number[]|string|string[]} _owner - Owner ID, which can
   *	be an account ID, a resource ID (as defined in calendar_bo, not
   *	necessarily an entry from the resource app), or a list containing a
   *	combination of both.
   */
  set_owner(_owner) {
    this.title.attr("data-owner", _owner);
    this.header.attr('data-owner', _owner);
    this.div.attr('data-owner', _owner);

    // Simple comparison, both numbers
    if (_owner === this.options.owner) return;

    // More complicated comparison, one or the other is an array
    if ((typeof _owner == 'object' || typeof this.options.owner == 'object') && _owner.toString() == this.options.owner.toString()) {
      return;
    }
    this.options.owner = typeof _owner !== 'object' ? [_owner] : _owner;
    var cache_id = CalendarApp._daywise_cache_id(this.options.date, _owner);
    if (this.options.date && this.registeredUID && cache_id !== this.registeredUID) {
      egw$1.dataUnregisterUID(this.registeredUID, null, this);
    }
    if (this.registeredUID !== cache_id) {
      this.registeredUID = cache_id;
      egw$1.dataRegisterUID(this.registeredUID, this._data_callback, this, this.getInstanceManager().execId, this.id);
    }
  }
  set_class(classnames) {
    this.header.removeClass(this.class);
    super.set_class(classnames);
    this.header.addClass(classnames);
  }

  /**
   * Callback used when the daywise data changes
   *
   * Events should update themselves when their data changes, here we are
   * dealing with a change in which events are displayed on this day.
   *
   * @param {String[]} event_ids
   * @returns {undefined}
   */
  _data_callback(event_ids) {
    var _this = this;
    var events = [];
    var waitForGroups = [];
    if (event_ids == null || typeof event_ids.length == 'undefined') {
      event_ids = [];
    }
    var _loop = function _loop(_i) {
        var event = egw$1.dataGetUIDdata('calendar::' + event_ids[_i]);
        event = event && event.data || false;
        if (!event) {
          i = _i;
          return 0; // continue
        }
        var wait = _this.getInstanceManager().app_obj.calendar._fetch_group_members(event);
        if (wait === null) {
          i = _i;
          return 0; // continue
        }
        waitForGroups.push(wait.then(() => {
          if (event && event.date && et2_calendar_event.owner_check(event, _this) && (event.date === _this.options.date ||
          // Accept multi-day events
          new Date(event.start) <= _this.date //&& new Date(event.end) >= this.date
          )) {
            events.push(event);
          } else if (event) {
            // Got an ID that doesn't belong
            event_ids.splice(_i--, 1);
          }
        }));
        i = _i;
      },
      _ret;
    for (var i = 0; i < event_ids.length; i++) {
      _ret = _loop(i);
      if (_ret === 0) continue;
    }
    Promise.all(waitForGroups).then(() => {
      if (!this.div.is(":visible")) {
        // Not visible, defer the layout or it all winds up at the top
        // Cancel any existing listener & bind
        jQuery(this.getInstanceManager().DOMContainer.parentNode).off('show.' + CalendarApp._daywise_cache_id(this.options.date, this.options.owner)).one('show.' + CalendarApp._daywise_cache_id(this.options.date, this.options.owner), function () {
          this._update_events(events);
        }.bind(this));
        return;
      }
      if (!this.getParent().disabled) {
        this._update_events(events);
      }
    });
  }
  set_label(label) {
    this.options.label = label;
    this.title.text(label);
    this.title.toggleClass('et2_clickable et2_link', label === '');
  }
  set_left(left) {
    if (this.div) {
      this.div.css('left', left);
    }
  }
  set_width(width) {
    this.options.width = width;
    if (this.div) {
      this.div.outerWidth(this.options.width);
      this.header.outerWidth(this.options.width);
    }
  }

  /**
   * Applies class for today, and any holidays for current day
   */
  day_class_holiday() {
    var _this2 = this;
    return _asyncToGenerator$3(function* () {
      _this2.title
      // Remove all special day classes
      .removeClass('calendar_calToday calendar_calBirthday calendar_calHoliday')
      // Except this one...
      .addClass("et2_clickable et2_link");
      _this2.title.attr('data-holiday', '');

      // Set today class - note +1 when dealing with today, as months in JS are 0-11
      var today = new Date();
      today.setUTCMinutes(today.getUTCMinutes() - today.getTimezoneOffset());
      _this2.title.toggleClass("calendar_calToday", _this2.options.date === '' + today.getUTCFullYear() + sprintf("%02d", today.getUTCMonth() + 1) + sprintf("%02d", today.getUTCDate()));

      // Holidays and birthdays
      var fetched_holidays = yield _this2.egw().holidays(_this2.options.date.substring(0, 4));
      var holiday_list = [];
      var holiday_pref = egw$1.preference('birthdays_as_events', 'calendar') || [];
      if (typeof holiday_pref === 'string') {
        holiday_pref = holiday_pref.split(',');
      } else {
        holiday_pref = jQuery.extend([], holiday_pref);
      }

      // Show holidays as events on mobile or by preference
      var holidays_as_events = egwIsMobile$1() || egw$1.preference('birthdays_as_events', 'calendar') === true || holiday_pref.indexOf('holiday') >= 0;
      var birthdays_as_events = egwIsMobile$1() || holiday_pref.indexOf('birthday') >= 0;
      if (fetched_holidays && fetched_holidays[_this2.options.date]) {
        fetched_holidays = fetched_holidays[_this2.options.date];
        for (var i = 0; i < fetched_holidays.length; i++) {
          if (typeof fetched_holidays[i]['birthyear'] !== 'undefined') {
            // Show birthdays as events on mobile or by preference
            if (birthdays_as_events && _this2.getWidgetById("event_" + escape(fetched_holidays[i].name)) == null) {
              // Create event
              var event = et2_createWidget('calendar-event', {
                id: 'event_' + fetched_holidays[i].name,
                value: {
                  row_id: escape(fetched_holidays[i].name),
                  title: fetched_holidays[i].name,
                  whole_day: true,
                  whole_day_on_top: true,
                  start: _this2.getParent().date_helper(_this2.options.date),
                  end: _this2.options.date,
                  owner: _this2.options.owner,
                  participants: _this2.options.owner,
                  app: 'calendar',
                  class: 'calendar_calBirthday'
                },
                readonly: true,
                class: 'calendar_calBirthday'
              }, _this2);
              event.doLoadingFinished();
              event._update();
            }
            if (!egwIsMobile$1()) {
              //If the birthdays are already displayed as event, don't
              //show them in the caption
              _this2.title.addClass('calendar_calBirthday');
              holiday_list.push(fetched_holidays[i]['name']);
            }
          } else {
            // Show holidays as events on mobile
            if (holidays_as_events && _this2.getWidgetById("event_" + escape(fetched_holidays[i].name)) == null) {
              // Create event
              var event = et2_createWidget('calendar-event', {
                id: 'event_' + fetched_holidays[i].name,
                value: {
                  row_id: escape(fetched_holidays[i].name),
                  title: fetched_holidays[i].name,
                  whole_day: true,
                  whole_day_on_top: true,
                  start: _this2.getParent().date_helper(_this2.options.date),
                  end: _this2.options.date,
                  owner: _this2.options.owner,
                  participants: _this2.options.owner,
                  app: 'calendar',
                  class: 'calendar_calHoliday'
                },
                readonly: true,
                class: 'calendar_calHoliday'
              }, _this2);
              event.doLoadingFinished();
              event._update();
            } else {
              _this2.title.addClass('calendar_calHoliday');
              _this2.title.attr('data-holiday', fetched_holidays[i]['name']);

              //If the birthdays are already displayed as event, don't
              //show them in the caption
              if (!_this2.options.display_holiday_as_event) {
                holiday_list.push(fetched_holidays[i]['name']);
              }
            }
          }
        }
      }
      _this2.title.attr('title', holiday_list.join(', '));
    })();
  }

  /**
   * Load the event data for this day and create event widgets for each.
   *
   * If event information is not provided, it will be pulled from the content array.
   *
   * @param {Object[]} [_events] Array of event information, one per event.
   */
  _update_events(_events) {
    var c;
    var events = _events || this.getArrayMgr('content').getEntry(this.options.date) || [];

    // Remove extra events
    while (this._children.length > 0) {
      var node = this._children[this._children.length - 1];
      this.removeChild(node);
      node.destroy();
    }

    // Make sure children are in cronological order, or columns are backwards
    events.sort(function (a, b) {
      var start = new Date(a.start) - new Date(b.start);
      var end = new Date(a.end) - new Date(b.end);
      // Whole day events sorted by ID, normal events by start / end time
      if (a.whole_day && b.whole_day) {
        return a.app_id - b.app_id;
      } else if (a.whole_day || b.whole_day) {
        return a.whole_day ? -1 : 1;
      }
      return start ? start : end;
    });
    for (c = 0; c < events.length; c++) {
      // Create event
      var event = et2_createWidget('calendar-event', {
        id: 'event_' + events[c].id,
        value: events[c]
      }, this);
    }

    // Seperate loop so column sorting finds all children in the right place
    var child_length = this._children.length;
    for (c = 0; c < events.length && c < child_length; c++) {
      var _event = this.getWidgetById('event_' + events[c].id);
      if (!_event) continue;
      if (this.isInTree()) {
        _event.doLoadingFinished();
      }
    }

    // Show holidays as events on mobile or by preference
    if (egwIsMobile$1() || egw$1.preference('birthdays_as_events', 'calendar')) {
      this.day_class_holiday();
    }

    // Apply styles to hidden events
    this._out_of_view();
  }

  /**
   * Apply styles for out-of-view and partially hidden events
   *
   * There are 3 different states or modes of display:
   *
   * - 'Normal' - When showing events positioned by time, the indicator is just
   *	a bar colored by the last category color.  On hover it shows either the
   *	title of a single event or "x event(s)" if more than one are hidden.
   *	Clicking adjusts the current view to show the earliest / latest hidden
   *	event
   *
   * - Fixed - When showing events positioned by time but in a fixed-height
   *  week (not auto-sized to fit screen) the indicator is the same as sized.
   *  On hover it shows the titles of the hidden events, clicking changes
   *  the view to the selected day.
   *
   * - GridList - When showing just a list, the indicator shows "x event(s)",
   *	and on hover shows the category color, title & time.  Clicking changes
   *	the view to the selected day, and opens the event for editing.
   */
  _out_of_view() {
    // Reset
    this.header.children('.hiddenEventBefore').remove();
    this.div.children('.hiddenEventAfter').remove();
    this.event_wrapper.css('overflow', 'visible');
    this.all_day.removeClass('overflown');
    jQuery('.calendar_calEventBody', this.div).css({
      'padding-top': '',
      'margin-top': ''
    });
    var timegrid = this.getParent();

    // elem is jquery div of event
    function isHidden(elem) {
      // Add an extra 5px top and bottom to include events just on the
      // edge of visibility
      var docViewTop = timegrid.scrolling.scrollTop() + 5,
        docViewBottom = docViewTop + (this.display_settings.granularity === 0 ? this.event_wrapper.height() : timegrid.scrolling.height() - 10),
        elemTop = elem.position().top,
        elemBottom = elemTop + elem.outerHeight(true);
      if (elemBottom <= docViewBottom && elemTop >= docViewTop) {
        // Entirely visible
        return false;
      }
      var visible = {
        hidden: elemTop > docViewTop ? 'bottom' : 'top',
        completely: false
      };
      visible.completely = visible.hidden == 'top' ? elemBottom < docViewTop : elemTop > docViewBottom;
      return visible;
    }

    // In gridlist view, we can quickly check if we need it at all
    if (this.display_settings.granularity === 0 && this._children.length) {
      jQuery('div.calendar_calEvent', this.div).show(0);
      if (Math.ceil(this.div.height() / this._children[0].div.height()) > this._children.length) {
        return;
      }
    }
    // Check all day overflow
    this.all_day.toggleClass('overflown', this.all_day[0].scrollHeight - this.all_day.innerHeight() > 5);

    // Check each event
    this.iterateOver(function (event) {
      // Skip whole day events and events missing value
      if (this.display_settings.granularity && (!event.options || !event.options.value || event.options.value.whole_day_on_top)) {
        return;
      }
      // Reset
      event.title.css({
        'top': '',
        'background-color': ''
      });
      event.body.css({
        'padding-top': '',
        'margin-top': ''
      });
      var hidden = isHidden.call(this, event.div);
      var day = this;
      if (!hidden) {
        return;
      }
      // Only top is hidden, move label
      // Bottom hidden is fine
      if (hidden.hidden === 'top' && !hidden.completely && !event.div.hasClass('calendar_calEventSmall')) {
        var title_height = event.title.outerHeight();
        event.title.css({
          'top': timegrid.scrolling.scrollTop() - event.div.position().top,
          'background-color': 'transparent'
        });
        event.body.css({
          'padding-top': timegrid.scrolling.scrollTop() - event.div.position().top + title_height,
          'margin-top': -title_height
        });
      }
      // Too many in gridlist view, show indicator
      else if (this.display_settings.granularity === 0 && hidden) {
        if (jQuery('.hiddenEventAfter', this.div).length == 0) {
          this.event_wrapper.css('overflow', 'hidden');
        }
        this._hidden_indicator(event, false, function () {
          app.calendar.update_state({
            view: 'day',
            date: day.date
          });
        });
      }
      // Completely out of view, show indicator
      else if (hidden.completely) {
        this._hidden_indicator(event, hidden.hidden == 'top', false);
      }
    }, this, et2_calendar_event);
  }

  /**
   * Show an indicator that there are hidden events
   *
   * The indicator works 3 different ways, depending on if the day can be
   * scrolled, is fixed, or if in gridview.
   *
   * @see _out_of_view()
   *
   * @param {et2_calendar_event} event Event we're creating the indicator for
   * @param {boolean} top Events hidden at the top (true) or bottom (false)
   * @param {function} [onclick] Callback for when user clicks on the indicator
   */
  _hidden_indicator(event, top, onclick) {
    var indicator = null;
    var day = this;
    var timegrid = this.getParent();
    var fixed_height = timegrid.div.hasClass('calendar_calTimeGridFixed');

    // Event is before the displayed times
    if (top) {
      // Create if not already there
      if (jQuery('.hiddenEventBefore', this.header).length === 0) {
        indicator = jQuery('<div class="hiddenEventBefore"></div>').appendTo(this.header).attr('data-hidden_count', 1);
        if (!fixed_height) {
          indicator.text(event.options.value.title).on('click', typeof onclick === 'function' ? onclick : function () {
            jQuery('.calendar_calEvent', day.div).first()[0].scrollIntoView();
            return false;
          });
        }
      } else {
        indicator = jQuery('.hiddenEventBefore', this.header);
        indicator.attr('data-hidden_count', parseInt(indicator.attr('data-hidden_count')) + 1);
        if (!fixed_height) {
          indicator.text(day.egw().lang('%1 event(s) %2', indicator.attr('data-hidden_count'), ''));
        }
      }
    }
    // Event is after displayed times
    else {
      indicator = jQuery('.hiddenEventAfter', this.div);
      // Create if not already there
      if (indicator.length === 0) {
        indicator = jQuery('<div class="hiddenEventAfter"></div>').attr('data-hidden_count', 0).appendTo(this.div);
        if (!fixed_height) {
          indicator.on('click', typeof onclick === 'function' ? onclick : function () {
            jQuery('.calendar_calEvent', day.div).last()[0].scrollIntoView(false);
            // Better re-run this to clean up
            day._out_of_view();
            return false;
          });
        } else {
          indicator.on('mouseover', function () {
            indicator.css({
              'height': indicator.attr('data-hidden_count') * 1.2 + 'em',
              'margin-top': -(indicator.attr('data-hidden_count') * 1.2) + 'em'
            });
          }).on('mouseout', function () {
            indicator.css({
              'height': '',
              'margin-top': ''
            });
          });
        }
      }
      var count = parseInt(indicator.attr('data-hidden_count')) + 1;
      indicator.attr('data-hidden_count', count);
      if (this.display_settings.granularity === 0) {
        indicator.append(event.div);
        indicator.attr('data-hidden_label', day.egw().lang('%1 event(s) %2', indicator.attr('data-hidden_count'), ''));
      } else if (!fixed_height) {
        indicator.text(day.egw().lang('%1 event(s) %2', indicator.attr('data-hidden_count'), ''));
      }
      indicator.css('top', timegrid.scrolling.height() + timegrid.scrolling.scrollTop() - indicator.innerHeight());
    }
    // Show different stuff for fixed height
    if (fixed_height) {
      indicator.append("<div id='" + event.dom_id + "' data-id='" + event.options.value.id + "'>" + event.options.value.title + "</div>");
    }
    // Match color to the event
    if (indicator !== null) {
      // Avoid white, which is hard to see
      // Use border-bottom-color, Firefox doesn't give a value with border-color
      var color = new rt(event.div.css('background-color') || '#FFFFFF').RGB !== 'rgb(255,255,255)' ? event.div.css('background-color') : event.div.css('border-bottom-color');
      if (color !== 'rgba(0, 0, 0, 0)') {
        indicator.css('border-color', color);
      }
    }
  }

  /**
   * Sort a day's events into minimally overlapping columns
   *
   * @returns {Array[]} Events sorted into columns
   */
  _spread_events() {
    if (!this.date) return [];
    var day_start = this.date.valueOf() / 1000;
    var dst_check = new Date(this.date);
    dst_check.setUTCHours(12);

    // if daylight saving is switched on or off, correct $day_start
    // gives correct times after 2am, times between 0am and 2am are wrong
    var daylight_diff = day_start + 12 * 60 * 60 - dst_check.valueOf() / 1000;
    if (daylight_diff) {
      day_start -= daylight_diff;
    }
    var eventCols = [],
      col_ends = [];

    // Make sure children are in cronological order, or columns are backwards
    this._children.sort(function (a, b) {
      var start = new Date(a.options.value.start) - new Date(b.options.value.start);
      var end = new Date(a.options.value.end) - new Date(b.options.value.end);
      // Whole day events sorted by ID, normal events by start / end time
      if (a.options.value.whole_day && b.options.value.whole_day) {
        // Longer duration comes first so we have nicer bars across the top
        var duration = new Date(b.options.value.end) - new Date(b.options.value.start) - (new Date(a.options.value.end) - new Date(a.options.value.start));
        return Math.abs(duration) > 360000 ? duration : a.options.value.title.localeCompare(b.options.value.title);
      } else if (a.options.value.whole_day || b.options.value.whole_day) {
        return a.options.value.whole_day ? -1 : 1;
      }
      return start ? start : end;
    });
    for (var i = 0; i < this._children.length; i++) {
      var event = this._children[i].options.value || false;
      if (!event) continue;
      if (event.date && event.date != this.options.date && (
      // Multi-day events date may be different
      new Date(event.start) >= this.date || new Date(event.end) < this.date)) {
        // Still have a child event that has changed date (DnD)
        this._children[i].destroy();
        this.removeChild(this._children[i]);
        continue;
      }
      var c = 0;
      event['multiday'] = false;
      if (typeof event.start !== 'object') {
        event.start = new Date(event.start);
      }
      if (typeof event.end !== 'object') {
        event.end = new Date(event.end);
      }
      event['start_m'] = parseInt(String((event.start.valueOf() / 1000 - day_start) / 60), 10);
      if (event['start_m'] < 0) {
        event['start_m'] = 0;
        event['multiday'] = true;
      }
      event['end_m'] = parseInt(String((event.end.valueOf() / 1000 - day_start) / 60), 10);
      if (event['end_m'] >= 24 * 60) {
        event['end_m'] = 24 * 60 - 1;
        event['multiday'] = true;
      }
      if (!event.start.getUTCHours() && !event.start.getUTCMinutes() && event.end.getUTCHours() == 23 && event.end.getUTCMinutes() == 59) {
        event.whole_day_on_top = event.non_blocking && event.non_blocking != '0';
      }
      if (!event['whole_day_on_top']) {
        for (c = 0; event['start_m'] < col_ends[c]; ++c);
        col_ends[c] = event['end_m'];
      }
      if (typeof eventCols[c] === 'undefined') {
        eventCols[c] = [];
      }
      eventCols[c].push(this._children[i]);
    }
    return eventCols;
  }

  /**
   * Position the event according to its time and how this widget is laid
   * out.
   *
   * @param {et2_calendar_event} [event] - Event to be updated
   *	If a single event is not provided, all events are repositioned.
   */
  position_event(event) {
    // If hidden, skip it - it takes too long
    if (!this.div.is(':visible')) return;

    // Sort events into minimally-overlapping columns
    var columns = this._spread_events();
    for (var c = 0; c < columns.length; c++) {
      // Calculate horizontal positioning
      var left = Math.ceil(5 + 1.5 * 100 / (parseFloat(this.options.width) || 100));
      var right = 2;
      if (columns.length !== 1) {
        right = !c ? 30 : 2;
        left += c * (100.0 - left) / columns.length;
      }
      for (var i = 0; (columns[c].indexOf(event) >= 0 || !event) && i < columns[c].length; i++) {
        // Calculate vertical positioning
        var top = 0;
        var height = 0;
        // Position the event
        if (this.display_settings.granularity === 0) {
          if (this.all_day.has(columns[c][i].div).length) {
            columns[c][i].div.prependTo(this.event_wrapper);
          } else if (this.event_wrapper.has(columns[c][i].div).length == 0) {
            columns[c][i].div.appendTo(this.event_wrapper);
          }
          columns[c][i].div.css('top', '');
          columns[c][i].div.css('height', '');
          columns[c][i].div.css('left', '');
          columns[c][i].div.css('right', '');
          // Strip out of view padding
          columns[c][i].body.css('padding-top', '');
          continue;
        }
        if (columns[c][i].options.value.whole_day_on_top) {
          if (!this.all_day.has(columns[c][i].div).length) {
            columns[c][i].div.css('top', '');
            columns[c][i].div.css('height', '');
            columns[c][i].div.css('left', '');
            columns[c][i].div.css('right', '');
            columns[c][i].body.css('padding-top', '');
            columns[c][i].div.appendTo(this.all_day);
            this.getParent().resizeTimes();
          }
          continue;
        } else {
          if (this.all_day.has(columns[c][i].div).length) {
            columns[c][i].div.appendTo(this.event_wrapper);
            this.getParent().resizeTimes();
          }
          top = this._time_to_position(columns[c][i].options.value.start_m);
          height = this._time_to_position(columns[c][i].options.value.end_m) - top;
        }

        // Position the event
        if (event && columns[c].indexOf(event) >= 0 || !event) {
          columns[c][i].div.css('top', top + '%');
          columns[c][i].div.css('height', height + '%');
          // Remove spacing from border, but only if visible or the height will be wrong
          if (columns[c][i].div.is(':visible')) {
            var border_diff = columns[c][i].div.outerHeight() - columns[c][i].div.height();
            columns[c][i].div.css('height', 'calc(' + height + '% - ' + border_diff + ')');
          }
          // This gives the wrong height
          //columns[c][i].div.outerHeight(height+'%');
          columns[c][i].div.css('left', left.toFixed(1) + '%');
          columns[c][i].div.css('right', right.toFixed(1) + '%');
          columns[c][i].div.css('z-index', parseInt(20) + c);
          columns[c][i]._small_size();
        }
      }
      // Only wanted to position this event, leave the other columns alone
      if (event && columns[c].indexOf(event) >= 0) {
        return;
      }
    }
  }

  /**
   * Calculates the vertical position based on the time
   *
   * This calculation is a percentage from 00:00 to 23:59
   *
   * @param {int} time in minutes from midnight
   * @return {float} position in percent
   */
  _time_to_position(time) {
    var pos = 0.0;

    // 24h
    pos = time / 60 / 24 * 100;
    return pos.toFixed(1);
  }
  attachToDOM() {
    var result = super.attachToDOM();

    // Remove the binding for the click handler, unless there's something
    // custom here.
    if (!this.onclick) {
      jQuery(this.node).off("click");
    }
    // But we do want to listen to certain clicks, and handle them internally
    this.node.addEventListener("click", this.click);
    return result;
  }
  removeFromDOM() {
    this.node.removeEventListener("click", this.click);
  }

  /**
   * Click handler calling custom handler set via onclick attribute to this.onclick,
   * or the default which is to open a new event at that time.
   *
   * Normally, you don't bind to this one, but the attribute is supported if you
   * can get a reference to the widget.
   *
   * @param {Event} _ev
   * @returns {boolean}
   */
  click(_ev) {
    if (this.getParent().options.readonly) return;

    // Drag to create in progress
    if (this.getParent().drag_create.start !== null) return;

    // Click on the title
    if (jQuery(_ev.target).hasClass('calendar_calAddEvent')) {
      if (this.header.has(_ev.target).length == 0 && !_ev.target.dataset.whole_day) {
        // Default handler to open a new event at the selected time
        var options = {
          date: _ev.target.dataset.date || this.options.date,
          hour: _ev.target.dataset.hour || this.getParent().options.day_start,
          minute: _ev.target.dataset.minute || 0,
          owner: this.options.owner
        };
        this.getInstanceManager().app_obj.calendar.add(options);
        _ev.stopImmediatePropagation();
        _ev.preventDefault();
        return false;
      }
      // Header, all day non-blocking
      else if (this.header.has(_ev.target).length && !jQuery('.hiddenEventBefore', this.header).has(_ev.target).length || this.header.is(_ev.target)) {
        // Click on the header, but not the title.  That's an all-day non-blocking
        var end = this.date.getFullYear() + '-' + (this.date.getUTCMonth() + 1) + '-' + this.date.getUTCDate() + 'T23:59';
        var _options = {
          start: this.date.toJSON(),
          end: end,
          non_blocking: true,
          owner: this.options.owner
        };
        this.getInstanceManager().app_obj.calendar.add(_options);
        _ev.preventDefault();
        _ev.stopImmediatePropagation();
        return false;
      }
    }
    // Day label
    else if (this.title.is(_ev.target) || this.title.has(_ev.target).length) {
      this.getInstanceManager().app_obj.calendar.update_state({
        view: 'day',
        date: this.date.toJSON()
      });
      _ev.preventDefault();
      _ev.stopImmediatePropagation();
      return false;
    }
  }

  /**
   * Code for implementing et2_IDetachedDOM
   *
   * @param {array} _attrs array to add further attributes to
   */
  getDetachedAttributes(_attrs) {}
  getDetachedNodes() {
    return [this.getDOMNode(this)];
  }
  setDetachedAttributes(_nodes, _values) {}

  // Resizable interface
  /**
   * Resize
   *
   * Parent takes care of setting proper width & height for the containing div
   * here we just need to adjust the events to fit the new size.
   */
  resize() {
    if (this.disabled || !this.div.is(':visible') || this.getParent().disabled) {
      return;
    }
    if (this.display_settings.granularity !== this.getParent().options.granularity) {
      // Layout has changed
      this._draw();

      // Resize & position all events
      this.position_event();
    } else {
      // Don't need to resize & reposition, just clear some stuff
      // to reset for _out_of_view()
      this.iterateOver(function (widget) {
        widget._small_size();
      }, this, et2_calendar_event);
    }
    this._out_of_view();
  }
}
_defineProperty$4(et2_calendar_daycol, "_attributes", {
  date: {
    name: "Date",
    type: "any",
    description: "What date is this daycol for.  YYYYMMDD or Date",
    default: et2_no_init
  },
  owner: {
    name: "Owner",
    type: "any",
    // Integer, string, or array of either
    default: et2_no_init,
    description: "Account ID number of the calendar owner, if not the current user"
  },
  display_birthday_as_event: {
    name: "Birthdays",
    type: "boolean",
    default: false,
    description: "Display birthdays as events"
  },
  display_holiday_as_event: {
    name: "Holidays",
    type: "boolean",
    default: false,
    description: "Display holidays as events"
  }
});
et2_register_widget(et2_calendar_daycol, ["calendar-daycol"]);

function ownKeys$2(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$2(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$2(Object(t), !0).forEach(function (r) { _defineProperty$3(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$2(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty$3(e, r, t) { return (r = _toPropertyKey$3(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$3(t) { var i = _toPrimitive$3(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$3(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * Class which implements the "calendar-timegrid" XET-Tag for displaying a span of days
 *
 * This widget is responsible for the times on the side, and it is also the
 * controller for both positioning and setting the day columns.  Day columns are
 * recycled rather than removed and re-created to reduce reloading.  Similarly,
 * the horizontal time grid (when used - see granularity attribute) is only
 * redrawn or resized when needed.  Unfortunately resizing is needed every time
 * the all day section has an event added or removed so the full work day from
 * start time to end time is properly displayed.
 *
 *
 * @augments et2_calendar_view
 */
class et2_calendar_timegrid extends et2_calendar_view {
  /**
   * Constructor
   *
   * @memberOf et2_calendar_timegrid
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_calendar_timegrid._attributes, _child || {}));

    // Main container
    _defineProperty$3(this, "gridHeader", void 0);
    _defineProperty$3(this, "dayHeader", void 0);
    _defineProperty$3(this, "scrolling", void 0);
    _defineProperty$3(this, "days", void 0);
    _defineProperty$3(this, "owner", void 0);
    _defineProperty$3(this, "gridHover", void 0);
    _defineProperty$3(this, "day_list", void 0);
    _defineProperty$3(this, "day_widgets", void 0);
    _defineProperty$3(this, "resize_timer", void 0);
    _defineProperty$3(this, "_top_time", void 0);
    _defineProperty$3(this, "rowHeight", void 0);
    _defineProperty$3(this, "daily_owner", false);
    _defineProperty$3(this, "_drop_data", void 0);
    _defineProperty$3(this, "day_start", void 0);
    _defineProperty$3(this, "day_end", void 0);
    this.div = jQuery(document.createElement("div")).addClass("calendar_calTimeGrid").addClass("calendar_TimeGridNoLabel");

    // Headers
    this.gridHeader = jQuery(document.createElement("div")).addClass("calendar_calGridHeader").appendTo(this.div);
    this.dayHeader = jQuery(document.createElement("div")).appendTo(this.gridHeader);

    // Contains times / rows
    this.scrolling = jQuery(document.createElement('div')).addClass("calendar_calTimeGridScroll").appendTo(this.div).append('<div class="calendar_calTimeLabels"></div>');

    // Contains days / columns
    this.days = jQuery(document.createElement("div")).addClass("calendar_calDayCols").appendTo(this.scrolling);

    // Used for owners
    this.owner = et2_createWidget('description', {}, this);
    this._labelContainer = jQuery(document.createElement("label")).addClass("et2_label et2_link").appendTo(this.gridHeader);
    this.gridHover = jQuery('<div style="height:5px;" class="calendar_calAddEvent drop-hover">');

    // List of dates in Ymd
    // The first one should be start_date, last should be end_date
    this.day_list = [];
    this.day_widgets = [];

    // Timer to re-scale time to fit
    this.resize_timer = null;
    this.setDOMNode(this.div[0]);
  }
  destroy() {
    var _this$_actionObject, _this$_actionObject2, _this$_actionObject3;
    // Stop listening to tab changes
    if (typeof framework !== 'undefined' && framework.getApplicationByName('calendar').tab) {
      jQuery(framework.getApplicationByName('calendar').tab.contentDiv).off('show.' + this.id);
    }
    super.destroy();

    // Delete all old objects
    ((_this$_actionObject = this._actionObject) === null || _this$_actionObject === void 0 ? void 0 : _this$_actionObject.clear) && this._actionObject.clear();
    ((_this$_actionObject2 = this._actionObject) === null || _this$_actionObject2 === void 0 ? void 0 : _this$_actionObject2.unregisterActions) && this._actionObject.unregisterActions();
    ((_this$_actionObject3 = this._actionObject) === null || _this$_actionObject3 === void 0 ? void 0 : _this$_actionObject3.remove) && this._actionObject.remove();
    this._actionObject = null;
    this.div.off();
    this.div = null;
    this.gridHeader = null;
    this.dayHeader = null;
    this.days = null;
    this.scrolling = null;
    this._labelContainer = null;

    // Stop the resize timer
    if (this.resize_timer) {
      window.clearTimeout(this.resize_timer);
    }
  }
  doLoadingFinished() {
    super.doLoadingFinished();

    // Listen to tab show to make sure we scroll to the day start, not top
    if (typeof framework !== 'undefined' && framework.getApplicationByName('calendar').tab) {
      jQuery(framework.getApplicationByName('calendar').tab.contentDiv).on('show.' + this.id, jQuery.proxy(function () {
        if (this.scrolling) {
          this.scrolling.scrollTop(this._top_time);
        }
      }, this));
    }

    // Need to get the correct internal sizing
    this.resize();
    this._drawGrid();

    // Actions may be set on a parent, so we need to explicitly get in here
    // and get ours
    this._link_actions(this.options.actions || this.getParent().options.actions || []);

    // Automatically bind drag and resize for every event using jQuery directly
    // - no action system -
    var timegrid = this;

    /**
     * If user puts the mouse over an event, then we'll set up resizing so
     * they can adjust the length.  Should be a little better on resources
     * than binding it for every calendar event, and we won't need exceptions
     * for planner view to resize horizontally.
     */
    this.div.on('mouseover', '.calendar_calEvent:not(.ui-resizable):not(.rowNoEdit)', function () {
      // Only resize in timegrid
      if (timegrid.options.granularity === 0) {
        return;
      }

      // Load the event
      var event_info = timegrid._get_event_info(this);
      if (this.classList.contains("resizing") || event_info.whole_day === "true") {
        // Currently already resizing
        return;
      }

      //Resizable event handler
      interact(this).resizable({
        distance: 10,
        invert: "reposition",
        edges: {
          bottom: true
        },
        startAxis: "y",
        lockAxis: "y",
        containment: 'parent',
        modifiers: [interact.modifiers.snapSize({
          targets: [interact.createSnapGrid({
            width: 10,
            height: timegrid.rowHeight
          })]
        })],
        /**
         *  Triggered when the resizable is created.
         *
         * @param {event} event
         * @param {Object} ui
         */
        create: function create(event, ui) {
          var resizeHelper = event.target.getAttribute('data-resize');
          if (resizeHelper == 'WD' || resizeHelper == 'WDS') {
            jQuery(this).resizable('destroy');
          }
        },
        /**
         * If dragging to resize an event, abort drag to create
         *
         * @param {InteractEvent} event
         */
        onstart: function onstart(event) {
          if (event.type == "resizestart") {
            event.target.removeAttribute("draggable");
          }
          if (timegrid.drag_create.start) {
            // Abort drag to create, we're dragging to resize
            timegrid._drag_create_end({});
          }
          event.target.classList.add("resizing");
        },
        /**
         * Triggered at the end of resizing the calEvent.
         *
         * @param {InteractEvent} event
         */
        onend: function (event) {
          // Remove for re-creation...
          interact(this).unset();
          event.target.classList.remove("resizing");
          var e = new jQuery.Event('change');
          e.originalEvent = event;
          e.data = {
            duration: 0
          };
          var event_data = timegrid._get_event_info(this);
          var event_widget = timegrid.getWidgetById(event_data.widget_id);
          var sT = event_widget.options.value.start_m;
          if (typeof this.dropEnd != 'undefined' && this.dropEnd.length == 1) {
            var eT = parseInt(timegrid._drop_data.hour) * 60 + parseInt(timegrid._drop_data.minute);
            e.data.duration = (eT - sT) / 60 * 3600;
            if (event_widget) {
              event_widget.options.value.end_m = eT;
              event_widget.options.value.duration = e.data.duration;
            }
            jQuery(this).trigger(e);
            event_widget._update(event_widget.options.value);
          }
          // Clear the helper, re-draw
          if (event_widget && event_widget._parent) {
            event_widget._parent.position_event(event_widget);
          }
          timegrid.div.children('.drop-hover').removeClass('.drop-hover');
        }.bind(this),
        /**
         * Triggered during the resize, on the drag of the resize handler
         *
         * @param {InteractEvent} event
         */
        onmove: function (event) {
          event.preventDefault();
          event.stopPropagation();
          event.target.style.height = event.rect.height + "px";
          // Add a bit for better understanding - it will show _to_ the start,
          // covering the 'actual' target
          timegrid._get_time_from_position(event.target.getBoundingClientRect().left, event.target.getBoundingClientRect().bottom + 5);
          var drop = timegrid._drag_helper(this, event.target);
          if (drop && !jQuery(drop).is(':visible')) {
            drop.get(0).scrollIntoView(false);
          }
        }.bind(this)
      });
    });

    // Customize and override some draggable settings
    this.div.on("dragend", () => {
      timegrid.div.off("drag.timegrid");

      // Remove helper
      document.body.querySelectorAll(".calendar_d-n-d_helper").forEach(n => n.remove());
    }).on('dragover', function (event) {
      egw$1.tooltipDestroy();
      // Allow drop to work
      event.preventDefault();
      timegrid._get_time_from_position(event.clientX, event.clientY);

      // Need to hide the hover marker or it will interfere with drop
      timegrid.gridHover.addClass("hideme");
      var helper = document.body.querySelector(".calendar_d-n-d_helper");
      if (helper) {
        timegrid._drag_helper(helper, helper, null);
        helper.style.top = event.clientY + "px";
        helper.style.left = event.clientX + 20 + "px";
      }
    }).on('mousemove', function (event) {
      timegrid._get_time_from_position(event.clientX, event.clientY);
    }).on('mouseout', function (event) {
      if (timegrid.div.has(event.relatedTarget).length === 0) {
        timegrid.gridHover.addClass("hideme");
      }
    });
    this.div.get(0).addEventListener("mousedown", this._mouse_down.bind(this));
    this.div.get(0).addEventListener("mouseup", this._mouse_up.bind(this));
    this.div.get(0).addEventListener("click", this.click.bind(this), true);
    return true;
  }
  _createNamespace() {
    return true;
  }

  /**
   * Show the current time while dragging
   * Used for resizing as well as drag & drop
   *
   * @param {type} element
   * @param {type} helper
   * @param {type} height
   */
  _drag_helper(element, helper, height) {
    if (!element) return;
    element.dropEnd = this.gridHover;
    element.style.zIndex = '';
    if (element.dropEnd.length) {
      this._drop_data = _objectSpread$2({}, element.dropEnd[0].dataset);
    }
    if (typeof element.dropEnd != 'undefined' && element.dropEnd.length) {
      // Make sure the target is visible in the scrollable day
      if (this.gridHover.is(':visible')) {
        if (this.scrolling.scrollTop() > 0 && this.scrolling.scrollTop() >= this.gridHover.position().top - this.rowHeight) {
          this.scrolling.scrollTop(this.gridHover.position().top - this.rowHeight);
        } else if (this.scrolling.scrollTop() + this.scrolling.height() <= this.gridHover.position().top + 2 * this.rowHeight) {
          this.scrolling.scrollTop(this.scrolling.scrollTop() + this.rowHeight);
        }
      }
      var time = '';
      if (this._drop_data.whole_day) {
        time = this.egw().lang('Whole day');
      } else if (this.options.granularity === 0) {
        // No times, keep what's in the event
        // Add class to helper to keep formatting
        jQuery(helper).addClass('calendar_calTimeGridList');
      } else {
        // @ts-ignore
        time = formatTime(parseTime(element.dropEnd.attr('data-hour') + ":" + element.dropEnd.attr('data-minute')));
      }
      element.innerHTML = '<div class="calendar_d-n-d_timeCounter"><span class="calendar_timeDemo" >' + time + '</span></div>';
    } else {
      element.innerHTML = '<div class="calendar_d-n-d_forbiden" style="height:100%"></div>';
    }
    jQuery(element).width(jQuery(helper).width());
    return element.dropEnd;
  }

  /**
   * Handler for dropping an event on the timegrid
   *
   * @param {type} timegrid
   * @param {type} event
   * @param {type} ui
   * @param {type} dropEnd
   */
  _event_drop(timegrid, event, ui, dropEnd) {
    var e = new jQuery.Event('change');
    e.originalEvent = event;
    e.data = {
      start: 0
    };
    if (typeof dropEnd != 'undefined' && dropEnd) {
      var drop_date = dropEnd.date || false;
      var target_date;
      var event_data = timegrid._get_event_info(ui.draggable);
      var event_widget = timegrid.getWidgetById(event_data.widget_id);
      if (!event_widget) {
        // Widget was moved across weeks / owners
        event_widget = timegrid.getParent().getWidgetById(event_data.widget_id);
      }
      if (event_widget) {
        // Send full string to avoid rollover between months using set_month()
        target_date = event_widget._parent.date_helper(drop_date.substring(0, 4) + '-' + drop_date.substring(4, 6) + '-' + drop_date.substring(6, 8) + 'T00:00:00Z');

        // Make sure whole day events stay as whole day events by ignoring drop time
        if (event_data.app == 'calendar' && event_widget.options.value.whole_day) {
          target_date.setUTCHours(0);
          target_date.setUTCMinutes(0);
        } else if (timegrid.options.granularity === 0) {
          // List, not time grid - keep time
          target_date.setUTCHours(event_widget.options.value.start.getUTCHours());
          target_date.setUTCMinutes(event_widget.options.value.start.getUTCMinutes());
        } else {
          // Non-whole day events, and integrated apps, can change
          target_date.setUTCHours(dropEnd.whole_day ? 0 : dropEnd.hour || 0);
          target_date.setUTCMinutes(dropEnd.whole_day ? 0 : dropEnd.minute || 0);
        }

        // Leave the helper there until the update is done
        var loading = event_data.event_node;
        // and add a loading icon so user knows something is happening
        jQuery('.calendar_calEventHeader', event_widget.div).addClass('loading');
        event_widget.recur_prompt(function (button_id) {
          if (button_id === 'cancel' || !button_id) {
            // Need to refresh the event with original info to clean up
            var app_id = event_widget.options.value.app_id ? event_widget.options.value.app_id : event_widget.options.value.id + (event_widget.options.value.recur_type ? ':' + event_widget.options.value.recur_date : '');
            egw$1().dataStoreUID('calendar::' + app_id, egw$1.dataGetUIDdata('calendar::' + app_id).data);
            loading.remove();
            return;
          }
          var duration;
          //Get infologID if in case if it's an integrated infolog event
          if (event_data.app === 'infolog') {
            // Duration - infologs are always non-blocking
            duration = dropEnd.whole_day ? 86400 - 1 : event_widget.options.value.whole_day ? egw$1().preference('defaultlength', 'calendar') * 60 : false;

            // If it is an integrated infolog event we need to edit infolog entry
            egw$1().json('stylite_infolog_calendar_integration::ajax_moveInfologEvent', [event_data.app_id, target_date || false, duration], function () {
              loading.remove();
            }).sendRequest(true);
          } else {
            //Edit calendar event

            // Duration - check for whole day dropped on a time, change it to full days
            duration = event_widget.options.value.whole_day && dropEnd.hour ?
            // Make duration whole days, less 1 second
            Math.round((event_widget.options.value.end - event_widget.options.value.start) / (1000 * 86400)) * 86400 - 1 : false;
            // Event (whole day or not) dropped on whole day section, change to whole day non blocking
            if (dropEnd.whole_day) duration = 'whole_day';

            // Send the update
            var _send = function _send(series_instance) {
              var start = new Date(target_date);
              egw$1().json('calendar.calendar_uiforms.ajax_moveEvent', [button_id === 'series' ? event_data.id : event_data.app_id, event_data.owner, start, timegrid.options.owner || egw$1.user('account_id'), duration, series_instance], function () {
                loading.remove();
              }).sendRequest(true);
            };

            // Check for modifying a series that started before today
            if (event_widget.options.value.recur_type && button_id === 'series') {
              event_widget.series_split_prompt(function (_button_id) {
                if (_button_id === Et2Dialog.OK_BUTTON) {
                  _send(event_widget.options.value.recur_date);
                } else {
                  loading.remove();
                }
              });
            } else {
              _send(event_widget.options.value.recur_date);
            }
          }
        });
      }
    }
  }

  /**
   * Something changed, and the days need to be re-drawn.  We wait a bit to
   * avoid re-drawing twice if start and end date both changed, then recreate
   * the days.
   * The whole grid is not regenerated because times aren't expected to change,
   * just the days.
   *
   * @param {boolean} [trigger=false] Trigger an event once things are done.
   *	Waiting until invalidate completes prevents 2 updates when changing the date range.
   * @returns {undefined}
   */
  invalidate(trigger) {
    // Reset the list of days
    this.day_list = [];

    // Wait a bit to see if anything else changes, then re-draw the days
    if (this.update_timer) {
      window.clearTimeout(this.update_timer);
    }
    this.update_timer = window.setTimeout(jQuery.proxy(function () {
      this.widget.update_timer = null;
      window.clearTimeout(this.resize_timer);
      this.widget.loader.hide().show();

      // Update actions
      if (this.widget._actionManager) {
        this.widget._link_actions(this.widget._actionManager.children);
      }
      this.widget._drawDays();
      // We have to completely re-do times, as they may have changed in
      // scale to the point where more labels are needed / need to be removed
      this.widget._drawTimes();
      if (this.trigger) {
        this.widget.change();
      }
      this.widget._updateNow();

      // Hide loader
      window.setTimeout(jQuery.proxy(function () {
        this.loader.hide();
      }, this.widget), 200);
    }, {
      widget: this,
      "trigger": trigger
    }), et2_dataview_grid.ET2_GRID_INVALIDATE_TIMEOUT);
  }
  detachFromDOM() {
    // Remove the binding to the change handler
    jQuery(this.div).off(".et2_calendar_timegrid");
    return super.detachFromDOM();
  }
  attachToDOM() {
    var result = super.attachToDOM();

    // Add the binding for the event change handler
    jQuery(this.div).on("change.et2_calendar_timegrid", '.calendar_calEvent', this, function (e) {
      // Make sure function gets a reference to the widget
      var args = Array.prototype.slice.call(arguments);
      if (args.indexOf(this) == -1) args.push(this);
      return e.data.event_change.apply(e.data, args);
    });

    // Add the binding for the change handler
    jQuery(this.div).on("change.et2_calendar_timegrid", '*:not(.calendar_calEvent)', this, function (e) {
      return e.data.change.call(e.data, e, this);
    });

    // Catch resize and prevent it from bubbling further, triggering
    // etemplate's resize
    this.div.on('resize', this, function (e) {
      e.stopPropagation();
    });
    return result;
  }
  getDOMNode(_sender) {
    if (_sender === this || !_sender) {
      return this.div ? this.div[0] : null;
    } else if (_sender.instanceOf(et2_calendar_daycol)) {
      return this.days ? this.days[0] : null;
    } else if (_sender) {
      return this.gridHeader ? this.gridHeader[0] : null;
    }
  }
  set_disabled(disabled) {
    var old_value = this.options.disabled;
    this.disabled = disabled;
    this.div.get(0).classList.toggle("hideme", disabled);
    if (disabled) {
      this.loader.show();
    } else if (old_value !== disabled) {
      // Scroll to start of day - stops jumping in FF
      // For some reason on Chrome & FF this doesn't quite get the day start
      // to the top, so add 2px;
      this.scrolling.scrollTop(this._top_time + 2);
    }
  }

  /**
   * Update the 'now' line
   * @private
   */
  // @ts-ignore
  _updateNow() {
    var now = super._updateNow();
    if (now === false || this.options.granularity == 0 || !this.div.is(':visible')) {
      this.now_div.hide();
      return false;
    }

    // Position & show line
    var set_line = function set_line(line, now, day) {
      line.appendTo(day.getDOMNode()).show();
      var pos = day._time_to_position(now.getUTCHours() * 60 + now.getUTCMinutes());
      //this.now_div.position({my: 'left', at: 'left', of: day.getDOMNode()});
      line.css('top', pos + '%');
    };

    // Showing just 1 day, multiple owners - span all
    if (this.daily_owner && this.day_list.length == 1) {
      var day = this.day_widgets[0];
      set_line(this.now_div, now, day);
      this.now_div.css('width', this.day_widgets.length * 100 + '%');
      return true;
    }

    // Find the day of the week
    for (var i = 0; i < this.day_widgets.length; i++) {
      var _day = this.day_widgets[i];
      if (_day.getDate() >= now) {
        _day = this.day_widgets[i - 1];
        set_line(this.now_div, now, _day);
        this.now_div.css('width', '100%');
        break;
      }
    }
    return true;
  }

  /**
   * Clear everything, and redraw the whole grid
   */
  _drawGrid() {
    this.div.css('height', this.options.height).empty();
    this.loader.prependTo(this.div).show();

    // Draw in the horizontal - the times
    this._drawTimes();

    // Draw in the vertical - the days
    this.invalidate();
  }

  /**
   * Creates the DOM nodes for the times in the left column, and the horizontal
   * lines (mostly via CSS) that span the whole date range.
   */
  _drawTimes() {
    jQuery('.calendar_calTimeRow', this.div).remove();
    this.div.toggleClass('calendar_calTimeGridList', this.options.granularity === 0);
    this.gridHeader.attr('data-date', this.options.start_date).attr('data-owner', this.options.owner).append(this._labelContainer).append(this.owner.getDOMNode()).append(this.dayHeader).appendTo(this.div);

    // Max with 18 avoids problems when it's not shown
    var header_height = Math.max(this.gridHeader.outerHeight(true), 18);
    this.scrolling.appendTo(this.div).off();

    // No time grid - list
    if (this.options.granularity === 0) {
      this.scrolling.css('height', '100%');
      this.days.css('height', '100%');
      this.iterateOver(function (day) {
        day.resize();
      }, this, et2_calendar_daycol);
      return;
    }
    var wd_start = 60 * this.options.day_start;
    var wd_end = 60 * this.options.day_end;
    var granularity = this.options.granularity;
    var totalDisplayMinutes = wd_end - wd_start;
    var rowsToDisplay = Math.ceil((totalDisplayMinutes + 60) / granularity);
    var row_count = 1440 / this.options.granularity;
    this.scrolling.on('scroll', jQuery.proxy(this._scroll, this));

    // Percent
    var rowHeight = (100 / rowsToDisplay).toFixed(1);
    // Pixels
    this.rowHeight = this.scrolling.height() / rowsToDisplay;

    // We need a reasonable bottom limit here, but resize will handle it
    // if we get too small
    if (this.rowHeight < 5 && this.div.is(':visible')) {
      if (this.rowHeight === 0) {
        // Something is not right...
        this.rowHeight = 5;
      }
    }

    // the hour rows
    var show = {
      5: [0, 15, 30, 45],
      10: [0, 30],
      15: [0, 30],
      45: [0, 15, 30, 45]
    };
    var html = '';
    var line_height = parseInt(this.div.css('line-height'));
    this._top_time = 0;
    for (var t = 0, i = 0; t < 1440; t += granularity, ++i) {
      if (t <= wd_start && t + granularity > wd_start) {
        this._top_time = this.rowHeight * (i + 1 + (wd_start - (t + granularity)) / granularity);
      }
      var working_hours = t >= wd_start && t < wd_end ? ' calendar_calWorkHours' : '';
      html += '<div class="calendar_calTimeRow' + working_hours + '" style="height: ' + 100 / row_count + '%;">';
      // show time for full hours, always for 45min interval and at least on every 3 row
      // @ts-ignore
      var time = formatTime(parseTime(t / 60 + ":" + t % 60));
      var time_label = (typeof show[granularity] === 'undefined' ? t % 60 === 0 : show[granularity].indexOf(t % 60) !== -1) ? time : '';
      if (time_label && egw$1.preference("timeformat") == "12" && time_label.split(':')[0] < 10) {
        time_label = '&nbsp;&nbsp;' + time_label;
      }
      html += '<div class="calendar_calTimeRowTime et2_clickable" data-time="' + time.trim() + '" data-hour="' + Math.floor(t / 60) + '" data-minute="' + t % 60 + '">' + time_label + "</div></div>\n";
    }

    // Set heights in pixels for scrolling
    jQuery('.calendar_calTimeLabels', this.scrolling).empty().height(this.rowHeight * i).append(html);
    this.days.css('height', this.rowHeight * i + 'px');
    this.gridHover.css('height', this.rowHeight);

    // Scroll to start of day
    this.scrolling.scrollTop(this._top_time);
  }

  /**
   * As window size and number of all day non-blocking events change, we need
   * to re-scale the time grid to make sure the full working day is shown.
   *
   * We use a timeout to avoid doing it multiple times if redrawing or resizing.
   */
  resizeTimes() {
    // Hide resizing from user
    this.loader.show();

    // Wait a bit to see if anything else changes, then re-draw the times
    if (this.resize_timer) {
      window.clearTimeout(this.resize_timer);
    }
    // No point if it is just going to be redone completely
    if (this.update_timer) return;
    this.resize_timer = window.setTimeout(jQuery.proxy(function () {
      if (this._resizeTimes) {
        this.resize_timer = null;
        this._resizeTimes();
      }
    }, this), 1);
  }

  /**
   * Re-scale the time grid to make sure the full working day is shown.
   * This is the timeout callback that does the actual re-size immediately.
   */
  _resizeTimes() {
    if (!this.div.is(':visible')) {
      return;
    }
    var wd_start = 60 * this.options.day_start;
    var wd_end = 60 * this.options.day_end;
    var totalDisplayMinutes = wd_end - wd_start;
    var rowsToDisplay = Math.ceil((totalDisplayMinutes + 60) / this.options.granularity);
    var row_count = 1440 / this.options.granularity;
    var new_height = this.scrolling.height() / rowsToDisplay;
    var old_height = this.rowHeight;
    this.rowHeight = new_height;
    jQuery('.calendar_calTimeLabels', this.scrolling).height(this.rowHeight * row_count);
    this.days.css('height', this.options.granularity === 0 ? '100%' : this.rowHeight * row_count + 'px');

    // Scroll to start of day
    this._top_time = wd_start * this.rowHeight / this.options.granularity;
    // For some reason on Chrome & FF this doesn't quite get the day start
    // to the top, so add 2px;
    this.scrolling.scrollTop(this._top_time + 2);
    if (this.rowHeight != old_height) {
      this.iterateOver(function (child) {
        if (child !== this && typeof child.resize === 'function') {
          child.resize();
        }
      }, this, et2_IResizeable);
    }
    this.loader.hide();
  }

  /**
   * Set up the needed day widgets to correctly display the selected date
   * range.  First we calculate the needed dates, then we create any needed
   * widgets.  Existing widgets are recycled rather than discarded.
   */
  _drawDays() {
    this.scrolling.append(this.days);

    // If day list is still empty, recalculate it from start & end date
    if (this.day_list.length === 0 && this.options.start_date && this.options.end_date) {
      this.day_list = this._calculate_day_list(this.options.start_date, this.options.end_date, this.options.show_weekend);
    }
    // For a single day, we show each owner in their own daycol
    this.daily_owner = this.day_list.length === 1 && this.options.owner.length > 1 && this.options.owner.length < (parseInt('' + egw$1.preference('day_consolidate', 'calendar')) || 6);
    var daycols_needed = this.daily_owner ? this.options.owner.length : this.day_list.length;
    var day_width = Math.min(jQuery(this.getInstanceManager().DOMContainer).width(), this.days.width()) / daycols_needed;
    if (!day_width || !this.day_list) {
      // Hidden on another tab, or no days for some reason
      var dim = egw$1.getHiddenDimensions(this.days, false);
      day_width = dim.w / Math.max(daycols_needed, 1);
      this.div.get(0).style.display = "";
    }

    // Create any needed widgets - otherwise, we'll just recycle
    // Add any needed day widgets (now showing more days)
    var add_index = 0;
    var before = true;
    while (daycols_needed > this.day_widgets.length) {
      var existing_index = this.day_widgets[add_index] && !this.daily_owner ? this.day_list.indexOf(this.day_widgets[add_index].options.date) : -1;
      before = existing_index > add_index;
      var day = et2_createWidget('calendar-daycol', {
        owner: this.options.owner,
        width: (before ? 0 : day_width) + "px"
      }, this);
      if (this.isInTree()) {
        day.doLoadingFinished();
      }
      if (existing_index != -1 && parseInt(this.day_list[add_index]) < parseInt(this.day_list[existing_index])) {
        this.day_widgets.unshift(day);
        jQuery(this.getDOMNode(day)).prepend(day.getDOMNode(day));
      } else {
        this.day_widgets.push(day);
      }
      add_index++;
    }
    // Remove any extra day widgets (now showing less)
    var delete_index = this.day_widgets.length - 1;
    before = false;
    while (this.day_widgets.length > daycols_needed) {
      // If we're going down to an existing one, just keep it for cool CSS animation
      while (delete_index > 1 && this.day_list.indexOf(this.day_widgets[delete_index].options.date) > -1) {
        delete_index--;
        before = true;
      }
      if (delete_index < 0) delete_index = 0;

      // Widgets that are before our date shrink, after just get pushed out
      if (before) {
        this.day_widgets[delete_index].set_width('0px');
      }
      this.day_widgets[delete_index].div.hide();
      this.day_widgets[delete_index].header.hide();
      this.day_widgets[delete_index].destroy();
      this.day_widgets.splice(delete_index--, 1);
    }
    this.set_header_classes();

    // Create / update day widgets with dates and data
    for (var i = 0; i < this.day_widgets.length; i++) {
      day = this.day_widgets[i];

      // Position
      day.set_left(day_width * i + 'px');
      day.title.removeClass('blue_title');
      if (this.daily_owner) {
        // Each 'day' is the same date, different user
        day.set_id(this.day_list[0] + '-' + this.options.owner[i]);
        day.set_date(this.day_list[0], false);
        day.set_owner(this.options.owner[i]);
        day.set_label(this._get_owner_name(this.options.owner[i]));
        day.title.addClass('blue_title');
      } else {
        // Show user name in day header even if only one
        if (this.day_list.length === 1) {
          day.set_label(this._get_owner_name(this.options.owner));
          day.title.addClass('blue_title');
        } else {
          // Go back to self-calculated date by clearing the label
          day.set_label('');
        }
        day.set_id(this.day_list[i]);
        day.set_date(this.day_list[i], this.value[this.day_list[i]] || false);
        day.set_owner(this.options.owner);
      }
      day.set_width(day_width + 'px');
    }

    // Adjust and scroll to start of day
    this.resizeTimes();

    // Don't hold on to value any longer, use the data cache for best info
    this.value = {};
    if (this.daily_owner) {
      this.set_label('');
    }

    // Handle not fully visible elements
    this._scroll();

    // Set 'now' line
    this._updateNow();

    // TODO: Figure out how to do this with detached nodes
    /*
    var nodes = this.day_col.getDetachedNodes();
    var supportedAttrs = [];
    this.day_col.getDetachedAttributes(supportedAttrs);
    supportedAttrs.push("id");
    	for(var i = 0; i < day_count; i++)
    {
    	this.day_col.setDetachedAttributes(nodes.clone(),)
    }
    */
  }

  /**
   * Set header classes
   *
   */
  set_header_classes() {
    var day;
    var app_calendar = this.getInstanceManager().app_obj.calendar || app.calendar;
    for (var i = 0; i < this.day_widgets.length; i++) {
      day = this.day_widgets[i];

      // Classes
      if (app_calendar && app_calendar.state && this.day_list[i] && parseInt(this.day_list[i].substr(4, 2)) !== new Date(app_calendar.state.date).getUTCMonth() + 1) {
        day.set_class('calendar_differentMonth');
      } else {
        day.set_class('');
      }
    }
  }

  /**
   * Update UI while scrolling within the selected time
   *
   * Toggles out of view indicators and adjusts not visible headers
   * @param {Event} event Scroll event
   */
  _scroll(event) {
    if (!this.day_widgets) return;

    // Loop through days, let them deal with it
    for (var day = 0; day < this.day_widgets.length; day++) {
      this.day_widgets[day]._out_of_view();
    }
  }

  /**
   * Calculate a list of days between start and end date, skipping weekends if
   * desired.
   *
   * @param {Date|string} start_date Date that et2_date widget can understand
   * @param {Date|string} end_date Date that et2_date widget can understand
   * @param {boolean} show_weekend If not showing weekend, Saturday and Sunday
   *	will not be in the returned list.
   *
   * @returns {string[]} List of days in Ymd format
   */
  _calculate_day_list(start_date, end_date, show_weekend) {
    var day_list = [];
    if (!start_date || !end_date) {
      return day_list;
    }
    var end = this.date_helper(end_date);
    var i = 1;
    var start = this.date_helper(start_date);
    do {
      if (show_weekend || !show_weekend && [0, 6].indexOf(start.getUTCDay()) === -1 || end_date === start_date) {
        day_list.push(formatDate(start, {
          dateFormat: "Ymd"
        }));
      }
      start.setUTCDate(start.getUTCDate() + 1);
    }
    // Limit it to 14 days to avoid infinite loops in case something is mis-set,
    // though the limit is more based on how wide the screen is
    while (end >= start && i++ <= 14);
    return day_list;
  }

  /**
   * Link the actions to the DOM nodes / widget bits.
   *
   * @param {object} actions {ID: {attributes..}+} map of egw action information
   */
  _link_actions(actions) {
    // Get the parent?  Might be a grid row, might not.  Either way, it is
    // just a container with no valid actions
    var objectManager = egw_getObjectManager(this.getInstanceManager().app, true, 1);
    objectManager = objectManager.getObjectById(this.getInstanceManager().uniqueId, 2) || objectManager;
    var parent = objectManager.getObjectById(this.id, 1) || objectManager.getObjectById(this.getParent().id, 1) || objectManager;
    if (!parent) {
      debugger;
      egw$1.debug('error', 'No parent objectManager found');
      return;
    }

    // This binds into the egw action system.  Most user interactions (drag to move, resize)
    // are handled internally using jQuery directly.
    var widget_object = this._actionObject || parent.getObjectById(this.id);
    var aoi = new et2_action_object_impl(this, this.getDOMNode(this)).getAOI();
    for (var i = 0; i < parent.children.length; i++) {
      var parent_finder = jQuery(parent.children[i].iface.doGetDOMNode()).find(this.div);
      if (parent_finder.length > 0) {
        parent = parent.children[i];
        break;
      }
    }
    // Determine if we allow a dropped event to use the invite/change actions
    var _invite_enabled = function _invite_enabled(action, event, target) {
      var event = event.iface.getWidget();
      var timegrid = target.iface.getWidget() || false;
      if (timegrid) {
        var enabled = timegrid._get_invite_action_enabled(event);
        widget_object.getActionLink('invite').enabled = enabled;
        widget_object.getActionLink('change_participant').enabled = enabled;

        // If invite or change participant are enabled, drag is not
        widget_object.getActionLink('egw_link_drop').enabled = !enabled;
      }
    };
    aoi.doTriggerEvent = function (_event, _data) {
      // Determine target node
      var event = _data.event || false;
      if (!event) {
        return;
      }
      if (_data.ui.draggable.classList.contains('rowNoEdit')) {
        return;
      }

      // Hide tooltip or it might throw events too
      egw$1.tooltipDestroy();

      /*
      We have to handle the drop in the normal event stream instead of waiting
      for the egwAction system so we can get the helper, and destination
      */
      if (event.type === 'drop') {
        var dropEnd = false;
        var helper = jQuery('.calendar_d-n-d_timeCounter', _data.ui.helper)[0];
        if (helper && helper.dropEnd && helper.dropEnd.length >= 1) {
          dropEnd = helper.dropEnd[0].dataset || this.dropEnd;
        }
      }
      var drag_listener = function drag_listener(_event) {
        aoi.getWidget()._drag_helper(jQuery('.calendar_d-n-d_timeCounter', _data.ui.helper)[0], _data.ui.helper[0], 0);
        _invite_enabled(widget_object.getActionLink('invite').actionObj, _data.ui.selected[0], widget_object);
      };
      var time = jQuery('.calendar_d-n-d_timeCounter', _data.ui.helper);
      switch (_event) {
        // Triggered once, when something is dragged into the timegrid's div
        case EGW_AI_DRAG_ENTER:
          // Remove formatting for out-of-view events (full day non-blocking)
          jQuery('.calendar_calEventHeader', _data.ui.helper).css('top', '');
          jQuery('.calendar_calEventBody', _data.ui.helper).css('padding-top', '');

          // Disable invite / change actions for same calendar or already participant
          var event = _data.ui.selected[0];
          if (!event || event.id && event.id.indexOf('calendar') !== 0) {
            event = false;
          }
          if (event) {
            _invite_enabled(widget_object.getActionLink('invite').actionObj, event, widget_object);
          }
          if (time.length) {
            // The out will trigger after the over, so we count
            time.data('count', time.data('count') + 1);
          } else {
            drag_listener(event);
          }
          break;

        // Triggered once, when something is dragged out of the timegrid
        case EGW_AI_DRAG_OUT:
          var timegrid = aoi.getWidget();
          if (!event.composedPath().includes(timegrid.getDOMNode())) {
            // Remove our custom helper
            document.body.querySelectorAll(".calendar_d-n-d_helper").forEach(n => n.remove());

            // Stop listening
            //jQuery(_data.ui.draggable).off('drag.et2_timegrid' + widget_object.id);
            // Remove highlighted time square
            timegrid.gridHover.addClass("hideme");
            timegrid.scrolling.scrollTop(timegrid._top_time);

            // Out triggers after the over, count to not accidentally remove
            time.data('count', time.data('count') - 1);
            if (time.length && time.data('count') <= 0) {
              time.remove();
            }
          }
          break;
        default:
          // Event starts in its own parent
          if (!time.length) {
            jQuery(_data.ui.helper).prepend('<div class="calendar_d-n-d_timeCounter" data-count="1"><span></span></div>');
          }
          drag_listener(_data.ui.selected[0]);
      }
    };
    if (widget_object == null) {
      // Add a new container to the object manager which will hold the widget
      // objects
      widget_object = parent.insertObject(false, new egwActionObject(this.id, parent, aoi, this._actionManager || parent.manager.getActionById(this.id) || parent.manager));
    } else {
      widget_object.setAOI(aoi);
    }
    this._actionObject = widget_object;

    // Delete all old objects
    widget_object.clear();
    widget_object.unregisterActions();

    // Go over the widget & add links - this is where we decide which actions are
    // 'allowed' for this widget at this time
    var action_links = this._get_action_links(actions);
    this._init_links_dnd(widget_object.manager, action_links);
    widget_object.updateActionLinks(action_links);
  }

  /**
   * Automatically add dnd support for linking
   *
   * @param {type} mgr
   * @param {type} actionLinks
   */
  _init_links_dnd(mgr, actionLinks) {
    if (this.options.readonly) return;
    var self = this;
    var drop_link = mgr.getActionById('egw_link_drop');
    var drop_change_participant = mgr.getActionById('change_participant');
    var drop_invite = mgr.getActionById('invite');
    var drag_action = mgr.getActionById('egw_link_drag');

    // Check if this app supports linking
    if (!egw$1.link_get_registry(this.dataStorePrefix, 'query') || egw$1.link_get_registry(this.dataStorePrefix, 'title')) {
      if (drop_link) {
        drop_link.remove();
        if (actionLinks.indexOf(drop_link.id) >= 0) {
          actionLinks.splice(actionLinks.indexOf(drop_link.id), 1);
        }
      }
      if (drag_action) {
        drag_action.remove();
        if (actionLinks.indexOf(drag_action.id) >= 0) {
          actionLinks.splice(actionLinks.indexOf(drag_action.id), 1);
        }
      }
      return;
    }
    // Don't re-add
    if (drop_link == null) {
      // Create the drop action that links entries
      drop_link = mgr.addAction('drop', 'egw_link_drop', egw$1.lang('Create link'), egw$1.image('link'), function (action, source, target) {
        // Extract link IDs
        var links = [];
        var id = '';
        for (var i = 0; i < source.length; i++) {
          // Check for no ID (invalid) or same manager (dragging an event)
          if (!source[i].id) continue;
          if (source[i].manager === target.manager) {
            // Find the timegrid, could have dropped on an event
            var timegrid = target.iface.getWidget();
            while (target.parent && timegrid.instanceOf && !timegrid.instanceOf(et2_calendar_timegrid)) {
              target = target.parent;
              timegrid = target.iface.getWidget();
            }
            if (timegrid && timegrid._drop_data) {
              timegrid._event_drop.call(source[i].iface.getDOMNode(), timegrid, null, action.ui, timegrid._drop_data);
            }
            timegrid._drop_data = false;
            // Ok, stop.
            return false;
          }
          id = source[i].id.split('::');
          links.push({
            app: id[0] == 'filemanager' ? 'link' : id[0],
            id: id[1]
          });
        }
        if (links.length && target && target.iface.getWidget() && target.iface.getWidget().instanceOf(et2_calendar_event)) {
          // Link the entries
          egw$1.json(self.egw().getAppName() + ".etemplate_widget_link.ajax_link.etemplate", target.id.split('::').concat([links]), function (result) {
            if (result) {
              this.egw().message('Linked');
            }
          }, self, true, self).sendRequest();
        } else if (links.length) {
          // Get date and time
          var params = jQuery.extend({}, jQuery('.drop-hover[data-date]', target.iface.getDOMNode())[0].dataset || {});

          // Add link IDs
          var app_registry = egw$1.link_get_registry('calendar');
          params[app_registry.add_app] = [];
          params[app_registry.add_id] = [];
          for (var n in links) {
            params[app_registry.add_app].push(links[n].app);
            params[app_registry.add_id].push(links[n].id);
          }
          app.calendar.add(params);
        }
      }, true);
      drop_link.acceptedTypes = ['default', 'link'];
      drop_link.hideOnDisabled = true;

      // Create the drop action for moving events between calendars
      var invite_action = function invite_action(action, source, target) {
        // Extract link IDs
        var links = [];
        var id = '';
        for (var i = 0; i < source.length; i++) {
          // Check for no ID (invalid) or same manager (dragging an event)
          if (!source[i].id) continue;
          if (source[i].manager === target.manager) {
            // Find the timegrid, could have dropped on an event
            var timegrid = target.iface.getWidget();
            while (target.parent && timegrid.instanceOf && !timegrid.instanceOf(et2_calendar_timegrid)) {
              target = target.parent;
              timegrid = target.iface.getWidget();
            }

            // Leave the helper there until the update is done
            var loading = action.ui.draggable;

            // and add a loading icon so user knows something is happening
            if (jQuery('.calendar_timeDemo', loading).length == 0) {
              jQuery('.calendar_calEventHeader', loading).addClass('loading');
            } else {
              jQuery('.calendar_timeDemo', loading).after('<div class="loading"></div>');
            }
            var event_data = egw$1.dataGetUIDdata(source[i].id).data;
            et2_calendar_event.recur_prompt(event_data, function (button_id) {
              if (button_id === 'cancel' || !button_id) {
                return;
              }
              var add_owner = jQuery.extend([], timegrid.options.owner);
              if (timegrid.daily_owner) {
                timegrid.iterateOver(function (col) {
                  if (col.div.has(timegrid.gridHover).length || col.header.has(timegrid.gridHover).length) {
                    add_owner = col.options.owner;
                  }
                }, this, et2_calendar_daycol);
              }
              egw$1().json('calendar.calendar_uiforms.ajax_invite', [button_id === 'series' ? event_data.id : event_data.app_id, add_owner, action.id === 'change_participant' ? jQuery.extend([], source[i].iface.getWidget().getParent().options.owner) : []], function (data) {
                var _source$0$iface$getWi;
                if (data.type) {
                  // Make sure to only run once
                  return;
                }
                // Need to remove the action from the original timegrid
                (_source$0$iface$getWi = source[0].iface.getWidget()) === null || _source$0$iface$getWi === void 0 || _source$0$iface$getWi.destroy();
                if (loading) {
                  loading.remove();
                }
              }).sendRequest(true);
            });
            // Ok, stop.
            return false;
          }
        }
      };
      drop_change_participant = mgr.addAction('drop', 'change_participant', egw$1.lang('Move to'), egw$1.image('participant'), invite_action, true);
      drop_change_participant.acceptedTypes = ['calendar'];
      drop_change_participant.hideOnDisabled = true;
      drop_invite = mgr.addAction('drop', 'invite', egw$1.lang('Invite'), egw$1.image('participant'), invite_action, true);
      drop_invite.acceptedTypes = ['calendar'];
      drop_invite.hideOnDisabled = true;
    }
    if (actionLinks.indexOf(drop_link.id) < 0) {
      actionLinks.push(drop_link.id);
    }
    actionLinks.push(drop_invite.id);
    actionLinks.push(drop_change_participant.id);

    // Don't re-add
    if (drag_action == null) {
      // Create drag action that allows linking
      drag_action = mgr.addAction('drag', 'egw_link_drag', egw$1.lang('link'), 'link', function (action, selected) {
        // Calendar drag helper - we update with time
        var helper = selected[0].iface.getWidget().getDOMNode().cloneNode();
        helper.classList.add("calendar_d-n-d_helper");
        self._drag_helper(helper, selected[0].iface.getDOMNode(), null);
        document.body.append(helper);

        // Safari doesn't update our drag helper, and anything ese breaks DnD
        if (/^((?!chrome|android).)*safari/i.test(navigator.userAgent)) {
          return false;
        }
        // System drag helper - empty span so we can use our own and update with the target time
        return document.createElement("span");
      }, true);
    }
    // The timegrid itself is not draggable, so don't add a link.
    // The action is there for the children (events) to use
    if (false && actionLinks.indexOf(drag_action.id) < 0) {
      actionLinks.push(drag_action.id);
    }
    drag_action.set_dragType(['link', 'calendar']);
  }

  /**
   * Get all action-links / id's of 1.-level actions from a given action object
   *
   * Here we are only interested in drop events.
   *
   * @param actions
   * @returns {Array}
   */
  _get_action_links(actions) {
    var action_links = [];
    // TODO: determine which actions are allowed without an action (empty actions)
    for (var i in actions) {
      var action = actions[i];
      if (action.type == 'drop') {
        action_links.push(typeof action.id != 'undefined' ? action.id : i);
      }
    }
    return action_links;
  }
  _get_invite_action_enabled(event) {
    var _event$getParent;
    if (!event || !event.options || !event.options.value.participants || !this.options.owner) {
      return false;
    }
    var owner_match = false;
    var own_timegrid = ((_event$getParent = event.getParent()) === null || _event$getParent === void 0 ? void 0 : _event$getParent.getParent()) === this && !this.daily_owner;
    for (var id in event.options.value.participants) {
      if (!this.daily_owner) {
        if (this.options.owner === id || this.options.owner.indexOf && this.options.owner.indexOf(id) >= 0) {
          owner_match = true;
        }
      } else {
        this.iterateOver(function (col) {
          // Check scroll section or header section
          if (col.div.has(this.gridHover).length || col.header.has(this.gridHover).length) {
            owner_match = owner_match || col.options.owner.indexOf(id) !== -1;
            own_timegrid = col === event.getParent();
          }
        }, this, et2_calendar_daycol);
      }
    }
    return !owner_match &&
    // Not inside its own timegrid
    !own_timegrid;
  }

  /**
   * Provide specific data to be displayed.
   * This is a way to set start and end dates, owner and event data in one call.
   *
   * Events will be retrieved automatically from the egw.data cache, so there
   * is no great need to provide them.
   *
   * @param {Object[]} events Array of events, indexed by date in Ymd format:
   *	{
   *		20150501: [...],
   *		20150502: [...]
   *	}
   *	Days should be in order.
   *  {string|number|Date} events.start_date - New start date
   *  {string|number|Date} events.end_date - New end date
   *  {number|number[]|string|string[]} event.owner - Owner ID, which can
   *	be an account ID, a resource ID (as defined in calendar_bo, not
   *	necessarily an entry from the resource app), or a list containing a
   *	combination of both.
   */
  set_value(events) {
    if (typeof events !== 'object') return false;
    var use_days_sent = true;
    if (events.start_date) {
      use_days_sent = false;
    }
    if (events.end_date) {
      use_days_sent = false;
    }
    super.set_value(events);
    if (use_days_sent) {
      var day_list = Object.keys(events);
      if (day_list.length) {
        this.set_start_date(day_list[0]);
        this.set_end_date(day_list[day_list.length - 1]);
      }

      // Sub widgets actually get their own data from egw.data, so we'll
      // stick it there
      var consolidated = et2_calendar_view.is_consolidated(this.options.owner, this.day_list.length == 1 ? 'day' : 'week');
      for (var day in events) {
        var _day_list = [];
        for (var i = 0; i < events[day].length; i++) {
          _day_list.push(events[day][i].row_id);
          egw$1.dataStoreUID('calendar::' + events[day][i].row_id, events[day][i]);
        }
        // Might be split by user, so we have to check that too
        for (var i = 0; i < this.options.owner.length; i++) {
          var owner = consolidated ? this.options.owner : this.options.owner[i];
          var day_id = CalendarApp._daywise_cache_id(day, owner);
          egw$1.dataStoreUID(day_id, _day_list);
          if (consolidated) break;
        }
      }
    }

    // Reset and calculate instead of just use the keys so we can get the weekend preference
    this.day_list = [];

    // None of the above changed anything, hide the loader
    if (!this.update_timer) {
      window.setTimeout(jQuery.proxy(function () {
        this.loader.hide();
      }, this), 200);
    }
  }

  /**
   * Set which user owns this.  Owner is passed along to the individual
   * days.
   *
   * @param {number|number[]} _owner Account ID
   * @returns {undefined}
   */
  set_owner(_owner) {
    var old = this.options.owner || 0;
    super.set_owner(_owner);
    this.owner.set_label('');
    this.div.removeClass('calendar_TimeGridNoLabel');

    // Check to see if it's our own calendar, with just us showing
    if (typeof _owner == 'object' && _owner.length == 1) {
      var rowCount = 0;
      this.getParent().iterateOver(function (widget) {
        if (!widget.disabled) rowCount++;
      }, this, et2_calendar_timegrid);
      // Just us, show week number
      if (rowCount == 1 && _owner.length == 1 && _owner[0] == egw$1.user('account_id') || rowCount != 1) _owner = false;
    }
    var day_count = this.day_list.length ? this.day_list.length : this._calculate_day_list(this.options.start_date, this.options.end_date, this.options.show_weekend).length;
    // @ts-ignore
    if (typeof _owner == 'string' && isNaN(_owner)) {
      this.set_label('');
      this.owner.set_value(this._get_owner_name(_owner));

      // Label is empty, but give extra space for the owner name
      this.div.removeClass('calendar_TimeGridNoLabel');
    } else if (!_owner || typeof _owner == 'object' && _owner.length > 1 ||
    // Single owner, single day
    _owner.length === 1 && day_count === 1) {
      // Don't show owners if more than one, show week number
      this.owner.set_value('');
      if (this.options.start_date) {
        this.set_label(egw$1.lang('wk') + ' ' + (app.calendar ? app.calendar.date.week_number(this.options.start_date) : ''));
      }
    } else {
      this.owner.options.application = 'api-accounts';
      this.owner.set_value(this._get_owner_name(_owner));
      this.set_label('');
      jQuery(this.getDOMNode(this.owner)).prepend(this.owner.getDOMNode());
    }
    if (this.isAttached() && (typeof old === "number" && typeof _owner === "number" && old !== this.options.owner ||
    // Array of ids will not compare as equal
    (typeof old === 'object' || typeof _owner === 'object') && old.toString() !== _owner.toString() ||
    // Strings
    typeof old === 'string' && '' + old !== '' + this.options.owner)) {
      this.invalidate(true);
    }
  }

  /**
   * Set a label for this week
   *
   * May conflict with owner, which is displayed when there's only one owner.
   *
   * @param {string} label
   */
  set_label(label) {
    this.options.label = label;
    this._labelContainer.html(label);
    this.gridHeader.prepend(this._labelContainer);

    // If it's a short label (eg week number), don't give it an extra line
    // but is empty, but give extra space for a single owner name
    this.div.toggleClass('calendar_TimeGridNoLabel', label.trim().length > 0 && label.trim().length <= 6 || this.options.owner.length > 1);
  }

  /**
   * Set how big the time divisions are
   *
   * Setting granularity to 0 will remove the time divisions and display
   * each days events in a list style.  This 'gridlist' is not to be confused
   * with the list view, which uses a nextmatch.
   *
   * @param {number} minutes
   */
  set_granularity(minutes) {
    // Avoid  < 0
    minutes = Math.max(0, minutes);
    if (this.options.granularity !== minutes) {
      if (this.options.granularity === 0 || minutes === 0) {
        this.options.granularity = minutes;
        // Need to re-do a bunch to make sure this is propagated
        this.invalidate();
      } else {
        this.options.granularity = minutes;
        this._drawTimes();
      }
    } else if (!this.update_timer) {
      this.resizeTimes();
    }
  }

  /**
   * Turn on or off the visibility of weekends
   *
   * @param {boolean} weekends
   */
  set_show_weekend(weekends) {
    weekends = weekends ? true : false;
    if (this.options.show_weekend !== weekends) {
      this.options.show_weekend = weekends;
      if (this.isAttached()) {
        this.invalidate();
      }
    }
  }

  /**
   * Call change handler, if set
   */
  change() {
    if (this.onchange) {
      if (typeof this.onchange == 'function') {
        // Make sure function gets a reference to the widget
        var args = Array.prototype.slice.call(arguments);
        if (args.indexOf(this) == -1) args.push(this);
        return this.onchange.apply(this, args);
      } else {
        return et2_compileLegacyJS(this.options.onchange, this, _node)();
      }
    }
  }

  /**
   * Call event change handler, if set
   *
   * @param {type} event
   * @param {type} dom_node
   */
  event_change(event, dom_node) {
    if (this.onevent_change) {
      var event_data = this._get_event_info(dom_node);
      var event_widget = this.getWidgetById(event_data.widget_id);
      et2_calendar_event.recur_prompt(event_data, jQuery.proxy(function (button_id, event_data) {
        // No need to continue
        if (button_id === 'cancel') return false;
        if (typeof this.onevent_change == 'function') {
          // Make sure function gets a reference to the widget
          var args = Array.prototype.slice.call(arguments);
          if (args.indexOf(event_widget) == -1) args.push(event_widget);

          // Put button ID in event
          event.button_id = button_id;
          return this.onevent_change.apply(this, [event, event_widget, button_id]);
        } else {
          return et2_compileLegacyJS(this.options.onevent_change, event_widget, dom_node)();
        }
      }, this));
    }
    return false;
  }
  get_granularity() {
    // get option, or user's preference
    if (typeof this.options.granularity === 'undefined') {
      this.options.granularity = egw$1.preference('interval', 'calendar') || 30;
    }
    return parseInt(this.options.granularity);
  }

  /**
   * Click handler calling custom handler set via onclick attribute to this.onclick
   *
   * This also handles all its own actions, including navigation.  If there is
   * an event associated with the click, it will be found and passed to the
   * onclick function.
   *
   * @param {Event} _ev
   * @returns {boolean} Continue processing event (true) or stop (false)
   */
  click(_ev) {
    var result = true;
    if (this.options.readonly) return;

    // Drag to create in progress
    if (this.drag_create.start !== null) return;

    // Is this click in the event stuff, or in the header?
    if (_ev.target.dataset.id || jQuery(_ev.target).parents('.calendar_calEvent').length) {
      // Event came from inside, maybe a calendar event
      var event = this._get_event_info(_ev.target.closest(".calendar_calEvent"));
      if (typeof this.onclick == 'function') {
        // Make sure function gets a reference to the widget, splice it in as 2. argument if not
        var args = Array.prototype.slice.call(arguments);
        if (args.indexOf(this) == -1) args.splice(1, 0, this);
        result = this.onclick.apply(this, args);
      }
      _ev.stopImmediatePropagation();
      var event_node = jQuery(event.event_node);
      if (event.id && result && !this.disabled && !this.options.readonly &&
      // Permissions - opening will fail if we try
      event_node && !event_node.hasClass('rowNoView')) {
        if (event.widget_id && this.getWidgetById(event.widget_id)) {
          this.getWidgetById(event.widget_id).recur_prompt();
        } else {
          et2_calendar_event.recur_prompt(event);
        }
        return false;
      }
      return result;
    } else if (this.gridHeader.is(_ev.target) && _ev.target.dataset || this._labelContainer.is(_ev.target) && this.gridHeader[0].dataset) {
      app.calendar.update_state(jQuery.extend({
        view: 'week'
      }, this._labelContainer.is(_ev.target) ? this.gridHeader[0].dataset : _ev.target.dataset));
      _ev.preventDefault();
      _ev.stopImmediatePropagation();
    } else if (this.options.owner.length === 1 && jQuery(this.owner.getDOMNode()).is(_ev.target)) {
      // Click on the owner in header, show just that owner
      app.calendar.update_state({
        owner: this.options.owner
      });
      _ev.stopImmediatePropagation();
    } else if (this.dayHeader.has(_ev.target).length) {
      // Click on a day header - let day deal with it
      // First child is a selectAccount
      for (var i = 1; i < this._children.length; i++) {
        if (this._children[i].header && (this._children[i].header.has(_ev.target).length || this._children[i].header.is(_ev.target))) {
          return this._children[i].click(_ev);
        }
      }
    }
    // No time grid, click on a day
    else if (this.options.granularity === 0 && (jQuery(_ev.target).hasClass('event_wrapper') || jQuery(_ev.target).hasClass('.calendar_calDayCol')) || _ev.target.classList.contains("calendar_calAddEvent")) {
      // Default handler to open a new event at the selected time
      var target = jQuery(_ev.target).hasClass('event_wrapper') ? _ev.target.parentNode : _ev.target;
      var options = {
        date: target.dataset.date || this.options.date,
        hour: target.dataset.hour || this._parent.options.day_start,
        minute: target.dataset.minute || 0,
        owner: this.daily_owner ? _ev.target.closest(".calendar_calDayCol").dataset.owner : this.options.owner
      };
      app.calendar.add(options);
      _ev.preventDefault();
      _ev.stopImmediatePropagation();
      return false;
    }
  }

  /**
   * Mousedown handler to support drag to create
   *
   * @param {jQuery.Event} event
   */
  _mouse_down(event) {
    if (event.which !== 1) {
      return;
    }
    if (this.options.readonly) {
      return;
    }

    // Skip for events
    if (event.target.closest(".calendar_calEvent")) {
      return;
    }
    // Skip for headers
    if (this.dayHeader.has(event.target).length > 0) {
      return;
    }
    var start = _objectSpread$2({}, this.gridHover[0].dataset);
    if (start.date) {
      // Set parent for event
      if (this.daily_owner) {
        // Each 'day' is the same date, different user
        // Find the correct row so we know the parent
        var col = event.target.closest('.calendar_calDayCol');
        for (var i = 0; i < this._children.length && col; i++) {
          if (this._children[i].node === col) {
            this.drag_create.parent = this._children[i];
            break;
          }
        }
      } else {
        this.drag_create.parent = this.getWidgetById(start.date);
      }

      // Format date
      var date = this.date_helper(start.date);
      if (start.hour) {
        date.setUTCHours(start.hour);
      }
      if (start.minute) {
        date.setUTCMinutes(start.minute);
      }
      start.date = date;
      this.gridHover.css('cursor', 'ns-resize');

      // Start update
      var timegrid = this;
      this.div.on('mousemove.dragcreate', function () {
        var end = jQuery.extend({}, timegrid.gridHover[0].dataset);
        var date = timegrid.date_helper(end.date);
        if (end.hour) {
          date.setUTCHours(end.hour);
        }
        if (end.minute) {
          date.setUTCMinutes(end.minute);
        }
        if (!timegrid.drag_create.event && date.toJSON() != start.date.toJSON()) {
          timegrid._drag_create_start(start);
          // Create the event immediately
          timegrid._drag_create_event();
        }
        if (timegrid.drag_create.event && timegrid.drag_create.parent && timegrid.drag_create.end) {
          timegrid.drag_create.end.date = date;
          if (timegrid.drag_create.start.date.toJSON() == timegrid.drag_create.end.date.toJSON()) {
            // Minimum drag size is time granularity or default
            timegrid.drag_create.end.date.setUTCMinutes(timegrid.drag_create.end.date.getUTCMinutes() + (timegrid.options.granularity || timegrid.egw().preference("defaultlength", "calendar")));
          }
          try {
            timegrid._drag_update_event();
          } catch (e) {
            timegrid._drag_create_end();
          }
        }
      });
    }
  }

  /**
   * Mouseup handler to support drag to create
   *
   * @param {jQuery.Event} event
   */
  _mouse_up(event) {
    if (this.options.readonly) {
      return;
    }
    var end = _objectSpread$2({}, this.gridHover[0].dataset);
    if (end.date) {
      var date = this.date_helper(end.date);
      if (end.hour) {
        date.setUTCHours(end.hour);
      }
      if (end.minute) {
        date.setUTCMinutes(end.minute);
      }
      end.date = date;
    }
    this.div.off('mousemove.dragcreate');
    this.gridHover.css('cursor', '');
    if (this.drag_create.end) {
      this._drag_create_end(this.drag_create.end);
    } else if (this.drag_create.start) {
      // Not dragged enough to count, fake a click
      event.stopImmediatePropagation();
      this.gridHover[0].dispatchEvent(new Event("click"));
    }
  }

  /**
   * Get time from position for drag and drop
   *
   * This does not return an actual time on a clock, but finds the closest
   * time node (.calendar_calAddEvent or day column) to the given position.
   *
   * @param {number} x
   * @param {number} y
   * @returns {DOMNode[]} time node(s) for the given position
   */
  _get_time_from_position(x, y) {
    x = Math.round(x);
    y = Math.round(y);
    var path = [];
    var day = null;
    var time = null;
    var nodes = document.elementsFromPoint(x, y);
    for (var id in this.gridHover[0].dataset) {
      delete this.gridHover[0].dataset[id];
    }
    if (this.options.granularity == 0) {
      this.gridHover.css('height', '');
    }
    for (var i = 0; i < nodes.length && nodes[i].tagName != 'FORM'; i++) {
      var node = nodes[i];
      var $node = jQuery(node);
      // Ignore high level & non-time (grid itself, header parent & week label)
      if ([this.node, this.gridHeader[0], this._labelContainer[0]].indexOf(node) !== -1 ||
      // Day labels
      this.gridHeader.has(node).length && !$node.hasClass("calendar_calDayColAllDay") && !$node.hasClass('calendar_calDayColHeader')) {
        continue;
      }
      if (node.classList.contains('calendar_calDayColHeader')) {
        var _node$querySelector;
        for (var id in node.dataset) {
          this.gridHover[0].dataset[id] = node.dataset[id];
        }
        this.gridHover.css({
          top: '',
          bottom: '0px',
          // Use 100% height if we're hiding the day labels to avoid
          // any remaining space from the hidden labels
          height: $node.height() > parseInt($node.css('line-height')) ? $node.css('padding-bottom') : '100%'
        });
        day = (_node$querySelector = node.querySelector(".calendar_calDayColHeader_spacer")) !== null && _node$querySelector !== void 0 ? _node$querySelector : node;
        this.gridHover.attr('data-non_blocking', 'true');
        break;
      }
      if (node.classList.contains('calendar_calDayCol')) {
        day = node;
        this.gridHover.attr('data-date', day.dataset.date);
      }
      if (node.classList.contains('calendar_calTimeRowTime')) {
        time = node;
        this.gridHover.attr('data-hour', time.dataset.hour).attr('data-minute', time.dataset.minute);
        break;
      }
    }
    if (time) {
      this.gridHover.height(this.rowHeight).css("top", time.offsetTop + "px");
    }
    if (day) {
      this.gridHover.css("position", "absolute").appendTo(day);
      this.gridHover.removeClass("hideme");
    }
    this.gridHover.css('left', '');
    return this.gridHover;
  }

  /**
   * Code for implementing et2_IDetachedDOM
   *
   * @param {array} _attrs array to add further attributes to
   */
  getDetachedAttributes(_attrs) {
    _attrs.push('start_date', 'end_date');
  }
  getDetachedNodes() {
    return [this.getDOMNode(this)];
  }
  setDetachedAttributes(_nodes, _values) {
    this.div = jQuery(_nodes[0]);
    if (_values.start_date) {
      this.set_start_date(_values.start_date);
    }
    if (_values.end_date) {
      this.set_end_date(_values.end_date);
    }
  }

  // Resizable interface
  /**
   * @param {boolean} [_too_small=null] Force the widget to act as if it was too small
   */
  resize(_too_small) {
    if (this.disabled || !this.div.is(':visible')) {
      return;
    }

    /*
    We expect the timegrid to be in a table with 0 or more other timegrids,
    1 per row.  We want each timegrid to be as large as possible, but space
    shared equally.  Height can't be set to a percentage on the rows, because
    that doesn't work.  However, if any timegrid is too small (1/2 hour < 1 line
    height), we change to showing only the working hours with no vertical
    scrollbar.  Each week gets as much space as it needs, and all scroll together.
    */
    // How many rows?
    var rowCount = 0;
    this.getParent().iterateOver(function (widget) {
      if (!widget.disabled) rowCount++;
    }, this, et2_calendar_timegrid);

    // Take the whole tab height, or home portlet
    if (this.getInstanceManager().app === 'home') {
      var height = jQuery(this.getParent().getDOMNode(this)).parentsUntil('et2-portlet-calendar').last().innerHeight();
    } else {
      var height = jQuery(this.getInstanceManager().DOMContainer).parent().innerHeight();

      // Allow for toolbar
      height -= jQuery('#calendar-toolbar', this.div.parents('.egw_fw_ui_tab_content')).outerHeight(true);
    }
    this.options.height = Math.floor(height / rowCount);

    // Allow for borders & padding
    this.options.height -= 2 * (this.div.outerWidth(true) - this.div.innerWidth() + parseInt(this.div.parent().css('padding-top')));

    // Calculate how much space is needed, and
    // if too small be bigger
    var needed = (this.day_end - this.day_start) / (this.options.granularity / 60) * parseInt(this.div.css('line-height')) + this.gridHeader.outerHeight();
    var too_small = needed > this.options.height && this.options.granularity != 0;
    if (this.getInstanceManager().app === 'home') {
      var modify_node = jQuery(this.getParent().getDOMNode(this)).parentsUntil('et2-portlet-calendar').last();
    } else {
      var modify_node = jQuery(this.getInstanceManager().DOMContainer);
    }
    modify_node.css({
      'overflow-y': too_small || _too_small ? 'auto' : 'hidden',
      'overflow-x': 'hidden',
      'height': too_small || _too_small ? height : '100%'
    });
    if (too_small || _too_small) {
      this.options.height = Math.max(this.options.height, needed);
      // Set all others to match
      if (!_too_small && rowCount > 1 && this.getParent()) {
        window.setTimeout(jQuery.proxy(function () {
          if (!this._parent) return;
          this._parent.iterateOver(function (widget) {
            if (!widget.disabled) widget.resize(true);
          }, this, et2_calendar_timegrid);
        }, this), 1);
        return;
      }
      this.div.addClass('calendar_calTimeGridFixed');
    } else {
      this.div.removeClass('calendar_calTimeGridFixed');
    }
    this.div.css('height', this.options.height);

    // Re-do time grid
    if (!this.update_timer) {
      this.resizeTimes();
    }

    // Try to resize width, though animations cause problems
    var total_width = modify_node.parent().innerWidth() - this.days.position().left;
    // Space for todos, if there
    total_width -= jQuery(this.getInstanceManager().DOMContainer).siblings().has(':visible').not('#calendar-toolbar').outerWidth();
    var day_width = (total_width > 0 ? total_width : modify_node.width()) / this.day_widgets.length;
    // update day widgets
    for (var i = 0; i < this.day_widgets.length; i++) {
      var day = this.day_widgets[i];

      // Position
      day.set_left(day_width * i + 'px');
      day.set_width(day_width + 'px');
    }
  }

  /**
   * Set up for printing
   *
   * @return {undefined|Deferred} Return a jQuery Deferred object if not done setting up
   *  (waiting for data)
   */
  beforePrint() {
    if (this.disabled || !this.div.is(':visible')) {
      return;
    }
    var height_check = this.div.height();
    this.div.css('max-height', '17cm');
    if (this.div.height() != height_check) {
      this.div.height('17cm');
      this._resizeTimes();
    }

    // update day widgets, if not on single day view
    //
    // TODO: Find out why don't we update single day view
    // Let the single day view participate in print calculation. 
    if (this.day_widgets.length > 0) {
      var day_width = 100 / this.day_widgets.length;
      for (var i = 0; i < this.day_widgets.length; i++) {
        var day = this.day_widgets[i];

        // Position
        day.set_left(i * day_width + '%');
        day.set_width(day_width + '%');
        // For some reason the column's method does not set it correctly in Chrome
        day.header[0].style.width = day_width + '%';
      }
    }

    // Stop Firefox from scrolling the day to the top - this would break printing in Chrome
    if (navigator.userAgent.match(/(firefox|safari|iceweasel)/i) && !navigator.userAgent.match(/chrome/i)) {
      var height = this.scrolling.scrollTop() + this.scrolling.height();
      this.scrolling
      // Disable scroll event, or it will recalculate out of view events
      .off('scroll')
      // Explicitly transform to the correct place
      .css({
        'transform': 'translateY(-' + this.scrolling.scrollTop() + 'px)',
        'margin-bottom': '-' + this.scrolling.scrollTop() + 'px',
        'height': height + 'px'
      });
      this.div.css({
        'height': '',
        'max-height': ''
      });
    }
  }

  /**
   * Reset after printing
   */
  afterPrint() {
    this.div.css('maxHeight', '');
    this.scrolling.children().css({
      'transform': '',
      'overflow': ''
    });
    this.div.height(this.options.height);
    if (navigator.userAgent.match(/(firefox|safari|iceweasel)/i) && !navigator.userAgent.match(/chrome/i)) {
      this._resizeTimes();
      this.scrolling
      // Re-enable out-of-view formatting on scroll
      .on('scroll', jQuery.proxy(this._scroll, this))
      // Remove translation
      .css({
        'transform': '',
        'margin-bottom': ''
      });
    }
  }
}
_defineProperty$3(et2_calendar_timegrid, "_attributes", {
  value: {
    type: "any",
    description: "An array of events, indexed by date (Ymd format)."
  },
  day_start: {
    name: "Day start time",
    type: "string",
    default: parseInt('' + egw$1.preference('workdaystarts', 'calendar')) || 9,
    description: "Work day start time.  If unset, this will default to the current user's preference"
  },
  day_end: {
    name: "Day end time",
    type: "string",
    default: parseInt('' + egw$1.preference('workdayends', 'calendar')) || 17,
    description: "Work day end time.  If unset, this will default to the current user's preference"
  },
  show_weekend: {
    name: "Weekends",
    type: "boolean",
    // @ts-ignore
    default: egw$1.preference('days_in_weekview', 'calendar') != 5,
    description: "Display weekends.  The date range should still include them for proper scrolling, but they just won't be shown."
  },
  granularity: {
    name: "Granularity",
    type: "integer",
    default: parseInt('' + egw$1.preference('interval', 'calendar')) || 30,
    description: "How many minutes per row, or 0 to display events as a list"
  },
  "onchange": {
    "name": "onchange",
    "type": "js",
    "default": et2_no_init,
    "description": "JS code which is executed when the date range changes."
  },
  "onevent_change": {
    "name": "onevent_change",
    "type": "js",
    "default": et2_no_init,
    "description": "JS code which is executed when an event changes."
  },
  height: {
    "default": '100%'
  }
});
et2_register_widget(et2_calendar_timegrid, ["calendar-timegrid"]);

function ownKeys$1(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$1(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1(Object(t), !0).forEach(function (r) { _defineProperty$2(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function asyncGeneratorStep$2(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator$2(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep$2(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep$2(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function _defineProperty$2(e, r, t) { return (r = _toPropertyKey$2(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2(t) { var i = _toPrimitive$2(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * Class which implements the "calendar-planner" XET-Tag for displaying a longer
 * ( > 10 days) span of time.  Events can be grouped into rows by either user,
 * category, or month.  Their horizontal position and size in the row is determined
 * by their start date and duration relative to the displayed date range.
 *
 * @augments et2_calendar_view
 */
class et2_calendar_planner extends et2_calendar_view {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_calendar_planner._attributes, _child || {}));

    // Main container
    _defineProperty$2(this, "gridHeader", void 0);
    _defineProperty$2(this, "headerTitle", void 0);
    _defineProperty$2(this, "headers", void 0);
    _defineProperty$2(this, "rows", void 0);
    _defineProperty$2(this, "grid", void 0);
    _defineProperty$2(this, "vertical_bar", void 0);
    _defineProperty$2(this, "doInvalidate", void 0);
    _defineProperty$2(this, "registeredCallbacks", void 0);
    _defineProperty$2(this, "cache", void 0);
    _defineProperty$2(this, "_deferred_row_updates", void 0);
    _defineProperty$2(this, "grouper", void 0);
    _defineProperty$2(this, "waitForGroups", []);
    _defineProperty$2(this, "waitForIds", []);
    _defineProperty$2(this, "groupWaitTimeout", 0);
    /**
     * These handle the differences between the different group types.
     * They provide the different titles, labels and grouping
     */
    _defineProperty$2(this, "groupers", {
      // Group by user has one row for each user
      user: {
        // Title in top left corner
        title: function title() {
          return this.egw().lang('User');
        },
        // Column headers
        headers: function () {
          var _headers = _asyncToGenerator$2(function* () {
            var start = new Date(this.options.start_date);
            var end = new Date(this.options.end_date);
            var start_date = new Date(start.getUTCFullYear(), start.getUTCMonth(), start.getUTCDate());
            var end_date = new Date(end.getUTCFullYear(), end.getUTCMonth(), end.getUTCDate());
            var day_count = Math.round((end_date - start_date) / (1000 * 3600 * 24)) + 1;
            if (day_count >= 6) {
              this.headers.append(this._header_months(start, day_count));
            }
            if (day_count < 120) {
              var weeks = this._header_weeks(start, day_count);
              this.headers.append(weeks);
              this.grid.append(weeks);
            }
            if (day_count < 60) {
              var days = yield this._header_days(start, day_count);
              this.headers.append(days);
              this.grid.append(days);
            }
            if (day_count <= 7) {
              var hours = this._header_hours(start, day_count);
              this.headers.append(hours);
              this.grid.append(hours);
            }
          });
          function headers() {
            return _headers.apply(this, arguments);
          }
          return headers;
        }(),
        // Labels for the rows
        row_labels: function row_labels() {
          var labels = [];
          var already_added = [];
          var options = [];
          var resource = null;
          var owner = null;
          if (app.calendar && app.calendar.sidebox_et2 && app.calendar.sidebox_et2.getWidgetById('owner')) {
            owner = app.calendar.sidebox_et2.getWidgetById('owner');
          } else {
            owner = this.getArrayMgr("sel_options").getRoot().getEntry('owner');
          }
          options = owner.select_options;
          for (var i = 0; i < this.options.owner.length; i++) {
            var user = this.options.owner[i];
            // Handle grouped resources like mailing lists - pull it from sidebox owner
            // and expand to their contents
            if (options && options.find && ((resource = options.find(function (element) {
              return element.value == user;
            }) || {}) || isNaN(user))) {
              if (resource && resource.resources) {
                for (var j = 0; j < resource.resources.length; j++) {
                  var id = resource.resources[j];
                  if (already_added.indexOf('' + id) < 0) {
                    labels.push({
                      id: id,
                      label: this._get_owner_name(id) || '',
                      data: {
                        participants: id,
                        owner: id
                      }
                    });
                    already_added.push('' + id);
                  }
                }
              } else if (user < 0) {
                // Group, but no users found.  Need those.
                egw$1.accountData(parseInt(user), 'account_fullname', true, result => {
                  if (result && resource) {
                    // Add users into group
                    resource.resources = Object.keys(result);
                  }
                  this.invalidate();
                }, this);
              } else if (already_added.indexOf('' + user) < 0 && (isNaN(user) || parseInt(user) >= 0)) {
                labels.push({
                  id: user,
                  label: this._get_owner_name(user),
                  data: {
                    participants: user,
                    owner: user
                  }
                });
                already_added.push('' + user);
              }
            } else if (user < 0)
              // groups
              {
                egw$1.accountData(parseInt(user), 'account_fullname', true, function (result) {
                  for (var id in result) {
                    if (already_added.indexOf('' + id) < 0) {
                      this.push({
                        id: id,
                        label: result[id] || '',
                        data: {
                          participants: id,
                          owner: id
                        }
                      });
                      already_added.push('' + id);
                    }
                  }
                }, labels);
              } else
              // users
              {
                if (already_added.indexOf(user) < 0) {
                  var label = this._get_owner_name(user) || '';
                  labels.push({
                    id: user,
                    label: label,
                    data: {
                      participants: user,
                      owner: ''
                    }
                  });
                  already_added.push('' + user);
                }
              }
          }
          return labels.sort(function (a, b) {
            return a.label.localeCompare(b.label);
          });
        },
        // Group the events into the rows
        group: function group(labels, rows, event) {
          var _this = this;
          // convert filter to allowed status
          var status_to_show = ['U', 'A', 'T', 'D', 'G'];
          switch (this.options.filter) {
            case 'unknown':
              status_to_show = ['U', 'G'];
              break;
            case 'accepted':
              status_to_show = ['A'];
              break;
            case 'tentative':
              status_to_show = ['T'];
              break;
            case 'rejected':
              status_to_show = ['R'];
              break;
            case 'delegated':
              status_to_show = ['D'];
              break;
            case 'all':
              status_to_show = ['U', 'A', 'T', 'D', 'G', 'R'];
              break;
            default:
              status_to_show = ['U', 'A', 'T', 'D', 'G'];
              break;
          }
          var participants = event.participants;
          var add_row = function add_row(user, participant) {
            var label_index = false;
            for (var i = 0; i < labels.length; i++) {
              if (labels[i].id == user) {
                label_index = i;
                break;
              }
            }
            if (participant && label_index !== false && status_to_show.indexOf(participant.substr(0, 1)) >= 0 || !participant && label_index !== false || this.options.filter === 'owner' && event.owner === user) {
              if (typeof rows[label_index] === 'undefined') {
                rows[label_index] = [];
              }
              rows[label_index].push(event);
            }
          };
          var _loop = function _loop(user) {
              participant = participants[user];
              if (parseInt(user) < 0)
                // groups
                {
                  var owner = null;
                  var options = [];
                  if (app.calendar && app.calendar.sidebox_et2 && app.calendar.sidebox_et2.getWidgetById('owner')) {
                    owner = app.calendar.sidebox_et2.getWidgetById('owner');
                  } else {
                    owner = _this.getArrayMgr("sel_options").getRoot().getEntry('owner');
                  }
                  options = owner.select_options.find(o => o.value == user).resources || [];
                  for (var i = 0; i < options.length; i++) {
                    if (!participants[options[i]]) {
                      add_row.call(_this, options[i], participant);
                    }
                  }
                  return 1; // continue
                }
              add_row.call(_this, user, participant);
            },
            participant;
          for (var user in participants) {
            if (_loop(user)) continue;
          }
        },
        // Draw a single row
        draw_row: function draw_row(sort_key, label, events) {
          var row = this._drawRow(sort_key, label, events, this.options.start_date, this.options.end_date);
          if (this.options.hide_empty && !events.length) {
            row.set_disabled(true);
          }
          // Highlight current user, sort_key is account_id
          if (sort_key === egw$1.user('account_id')) {
            row.set_class('current_user');
          }
          // Set account_id so event.owner_check can use it
          row.options.owner = sort_key;

          // Since the daywise cache is by user, we can tap in here
          var t = new Date(this.options.start_date);
          var end = new Date(this.options.end_date);
          do {
            var cache_id = CalendarApp._daywise_cache_id(t, sort_key);
            egw$1.dataRegisterUID(cache_id, row._data_callback, row);
            t.setUTCDate(t.getUTCDate() + 1);
          } while (t < end);
          return row;
        }
      },
      // Group by month has one row for each month
      month: {
        title: function title() {
          return this.egw().lang('Month');
        },
        headers: function headers() {
          this.headers.append(this._header_day_of_month());
        },
        row_labels: function row_labels() {
          var labels = [];
          var d = new Date(this.options.start_date);
          d = new Date(d.valueOf() + d.getTimezoneOffset() * 60 * 1000);
          for (var i = 0; i < 12; i++) {
            // Not using UTC because we corrected for timezone offset
            labels.push({
              id: sprintf('%04d-%02d', d.getFullYear(), d.getMonth()),
              label: this.egw().lang(date('F', d)) + ' ' + d.getFullYear()
            });
            d.setMonth(d.getMonth() + 1);
          }
          return labels;
        },
        group: function group(labels, rows, event) {
          // Yearly planner does not show infologs
          if (event && event.app && event.app == 'infolog') return;
          var start = new Date(event.start);
          start = new Date(start.valueOf() + start.getTimezoneOffset() * 60 * 1000);
          var key = sprintf('%04d-%02d', start.getFullYear(), start.getMonth());
          var label_index = false;
          for (var i = 0; i < labels.length; i++) {
            if (labels[i].id == key) {
              label_index = i;
              break;
            }
          }
          if (label_index) {
            if (typeof rows[label_index] === 'undefined') {
              rows[label_index] = [];
            }
            rows[label_index].push(event);
          }

          // end in a different month?
          var end = new Date(event.end);
          end = new Date(end.valueOf() + end.getTimezoneOffset() * 60 * 1000);
          var end_key = sprintf('%04d-%02d', end.getFullYear(), end.getMonth());
          var year = start.getFullYear();
          var month = start.getMonth();
          key = sprintf('%04d-%02d', year, month);
          do {
            var end_label_index = typeof label_index == "boolean" ? 0 : label_index;
            for (var _i = end_label_index; _i < labels.length; _i++) {
              if (labels[_i].id == key) {
                end_label_index = _i;
                if (typeof rows[end_label_index] === 'undefined') {
                  rows[end_label_index] = [];
                }
                break;
              }
            }
            if (end_label_index != label_index) {
              rows[end_label_index].push(event);
            }
            if (++month > 11) {
              ++year;
              month = 0;
            }
            key = sprintf('%04d-%02d', year, month);
          } while (key <= end_key);
        },
        // Draw a single row, but split up the dates
        draw_row: function draw_row(sort_key, label, events) {
          var key = sort_key.split('-');
          var start = new Date(key[0] + "-" + sprintf("%02d", parseInt(key[1]) + 1) + "-01T00:00:00Z");
          // Use some care to avoid issues with timezones and daylight savings
          var end = new Date(start);
          end.setUTCMonth(start.getUTCMonth() + 1);
          end.setUTCDate(1);
          end.setUTCHours(0);
          end.setUTCMinutes(0);
          end = new Date(end.valueOf() - 1000);
          end.setUTCMonth(start.getUTCMonth());
          this._drawRow(sort_key, label, events, start, end);
        }
      },
      // Group by category has one row for each [sub]category
      category: {
        title: function title() {
          return this.egw().lang('Category');
        },
        headers: function () {
          var _headers2 = _asyncToGenerator$2(function* () {
            var start = new Date(this.options.start_date);
            var end = new Date(this.options.end_date);
            var start_date = new Date(start.getUTCFullYear(), start.getUTCMonth(), start.getUTCDate());
            var end_date = new Date(end.getUTCFullYear(), end.getUTCMonth(), end.getUTCDate());
            var day_count = Math.round((end_date - start_date) / (1000 * 3600 * 24)) + 1;
            if (day_count >= 6) {
              this.headers.append(this._header_months(start, day_count));
            }
            if (day_count < 120) {
              var weeks = this._header_weeks(start, day_count);
              this.headers.append(weeks);
              this.grid.append(weeks);
            }
            if (day_count < 60) {
              var days = yield this._header_days(start, day_count);
              this.headers.append(days);
              this.grid.append(days);
            }
            if (day_count <= 7) {
              var hours = this._header_hours(start, day_count);
              this.headers.append(hours);
              this.grid.append(hours);
            }
          });
          function headers() {
            return _headers2.apply(this, arguments);
          }
          return headers;
        }(),
        row_labels: function row_labels() {
          var im = this.getInstanceManager();
          var labels = [];
          var categories = StaticOptions.cached_server_side(this, "cat", ',,,calendar', false);
          if (!categories || categories.length == 0) {
            // No categories at all?  Probably loading before sidebox is done.  Ask directly and wait for them, rather than firing
            // 50 different requests.
            egw$1.json('EGroupware\\Api\\Etemplate\\Widget\\Select::ajax_get_options', ['select-cat', ',,,calendar'], function (data) {
              categories = data;
            }).sendRequest(false);
          }
          var app_calendar = this.getInstanceManager().app_obj.calendar || app.calendar;
          if (!app_calendar.state.cat_id || app_calendar.state.cat_id.toString() === '' || app_calendar.state.cat_id.toString() == '0') {
            app_calendar.state.cat_id = '';
            labels.push({
              id: '',
              value: '',
              label: egw$1.lang('none'),
              main: '',
              data: {}
            });
            labels = labels.concat(categories);
          } else {
            var cat_id = app_calendar.state.cat_id;
            if (typeof cat_id == 'string') {
              cat_id = cat_id.split(',');
            }
            var _loop2 = function _loop2() {
              // Find label for that category
              var cat = null;
              for (var j = 0; j < categories.length; j++) {
                if (categories[j].value == cat_id[i]) {
                  cat = categories[j];
                  categories[j].id = categories[j].value;
                  labels.push(categories[j]);
                  break;
                }
              }

              // Get its children immediately
              if (cat && cat.children === "") {
                return 1; // continue
              } else if (!cat || !cat.children || categories.filter(o => cat.children.find(c => o.value == c)).length != cat.children.length) {
                egw$1.json('EGroupware\\Api\\Etemplate\\Widget\\Select::ajax_get_options', ['select-cat', ',,,calendar,' + cat_id[i]], function (data) {
                  labels = labels.concat(data);
                }).sendRequest(false);
              }
            };
            for (var i = 0; i < cat_id.length; i++) {
              if (_loop2()) continue;
            }
          }
          for (var i = labels.length - 1; i >= 0; i--) {
            labels[i].id = labels[i].value;
            labels[i].data = {
              cat_id: labels[i].id,
              main: labels[i].value == labels[i].main
            };
            if (labels[i].children && labels[i].children.length) {
              labels[i].data.has_children = true;
            }
          }
          return labels;
        },
        group: function group(labels, rows, event) {
          var cats = event.category;
          var app_calendar = this.getInstanceManager().app_obj.calendar || app.calendar;
          if (typeof event.category === 'string') {
            cats = cats.split(',');
          }
          var _loop3 = function _loop3() {
              label_index = false;
              category = cats[cat] ? parseInt(cats[cat], 10) : false;
              if (category == 0 || !category) category = '';
              var indexCheck = l => l.value == category || l.id == category || typeof l.children != "undefined" && l.children.findIndex(indexCheck) != -1;
              label_index = labels.findIndex(indexCheck);
              if (label_index !== -1 && typeof rows[label_index] === 'undefined') {
                rows[label_index] = [];
              }
              if (label_index !== -1 && rows[label_index].indexOf(event) === -1) {
                rows[label_index].push(event);
              }
            },
            label_index,
            category;
          for (var cat = 0; cat < cats.length; cat++) {
            _loop3();
          }
        },
        draw_row: function draw_row(sort_key, label, events) {
          var row = this._drawRow(sort_key, label, events, this.options.start_date, this.options.end_date);
          if (this.options.hide_empty && !events.length) {
            row.set_disabled(true);
          }
          return row;
        }
      }
    });
    this.div = jQuery(document.createElement("div")).addClass("calendar_plannerWidget");

    // Header
    this.gridHeader = jQuery(document.createElement("div")).addClass("calendar_plannerHeader").appendTo(this.div);
    this.headerTitle = jQuery(document.createElement("div")).addClass("calendar_plannerHeaderTitle").appendTo(this.gridHeader);
    this.headers = jQuery(document.createElement("div")).addClass("calendar_plannerHeaderRows").appendTo(this.gridHeader);
    this.rows = jQuery(document.createElement("div")).addClass("calendar_plannerRows").appendTo(this.div);
    this.grid = jQuery(document.createElement("div")).addClass("calendar_plannerGrid").appendTo(this.div);
    this.vertical_bar = jQuery(document.createElement("div")).addClass('verticalBar').appendTo(this.div);
    this.click = this.click.bind(this);
    this.value = [];

    // Update timer, to avoid redrawing twice when changing start & end date
    this.update_timer = null;
    this.doInvalidate = true;
    this.setDOMNode(this.div[0]);
    this.registeredCallbacks = [];
    this.cache = {};
    this._deferred_row_updates = {};
  }
  destroy() {
    super.destroy();
    this.div.off();
    for (var i = 0; i < this.registeredCallbacks.length; i++) {
      egw$1.dataUnregisterUID(this.registeredCallbacks[i], null, this);
    }
  }
  doLoadingFinished() {
    super.doLoadingFinished();

    // Don't bother to draw anything if there's no date yet
    if (this.options.start_date) {
      this._drawGrid();
    }

    // Automatically bind drag and resize for every event using jQuery directly
    // - no action system -
    var planner = this;
    this.cache = {};
    this._deferred_row_updates = {};

    /**
     * If user puts the mouse over an event, then we'll set up resizing so
     * they can adjust the length.  Should be a little better on resources
     * than binding it for every calendar event.
     */
    this.div.on('mouseover', '.calendar_calEvent:not(.ui-resizable):not(.rowNoEdit)', function () {
      // Load the event
      planner._get_event_info(this);
      var that = this;

      //Resizable event handler
      interact(this).resizable({
        invert: "reposition",
        edges: {
          right: true
        },
        startAxis: "x",
        lockAxis: "x",
        containment: 'parent',
        /**
         * If dragging to resize an event, abort drag to create
         *
         * @param {InteractEvent} event
         */
        onstart: function onstart(event) {
          if (event.type == "resizestart") {
            event.target.removeAttribute("draggable");
          }
          egw$1.tooltipDestroy();
          if (planner.drag_create.start) {
            // Abort drag to create, we're dragging to resize
            planner._drag_create_end({});
          }
          event.target.classList.add("resizing");
        },
        /**
         * Triggered at the end of resizing the calEvent.
         *
         * @param {InteractEvent} event
         */
        onend: function (event) {
          interact(this).unset();
          var e = new jQuery.Event('change');
          e.originalEvent = event;
          e.data = {
            duration: 0
          };
          var event_data = planner._get_event_info(this);
          var event_widget = planner.getWidgetById(event_data.widget_id);
          var sT = event_widget.options.value.start_m;
          if (typeof this.dropEnd != 'undefined') {
            var eT = parseInt(this.dropEnd.getUTCHours() * 60) + parseInt(this.dropEnd.getUTCMinutes());
            e.data.duration = (eT - sT) / 60 * 3600;
            if (event_widget) {
              event_widget.options.value.end_m = eT;
              event_widget.options.value.duration = e.data.duration;
            }

            // Leave the helper there until the update is done
            var loading = event_data.event_node;

            // and add a loading icon so user knows something is happening
            jQuery('.calendar_timeDemo', loading).after('<div class="loading"></div>');
            jQuery(this).trigger(e);

            // Remove loading, done or not
            loading.remove();
          }
          // Clear the helper, re-draw
          if (event_widget) {
            event_widget.getParent().position_event(event_widget);
          }
        }.bind(this),
        /**
         * Triggered during the resize, on the drag of the resize handler
         *
         * @param {InteractEvent} event
         */
        onmove: function (event) {
          event.target.style.width = event.rect.width + "px";
          var position;
          if (planner.options.group_by == 'month') {
            position = {
              left: event.clientX,
              top: event.clientY
            };
          } else {
            var offset = parseInt(getComputedStyle(event.target).left) - event.rect.left;
            position = {
              top: event.rect.top,
              left: event.rect.right + offset
            };
          }
          planner._drag_helper(this, position, event.rect.height);
        }.bind(this)
      });
    });
    this.div.on('mousemove', function (event) {
      // Ignore headers
      if (planner.headers.has(event.target).length !== 0) {
        planner.vertical_bar.hide();
        return;
      }
      // Position bar by mouse
      planner.vertical_bar.css("left", event.clientX - planner.grid.offset().left + 120 + "px");
      planner.vertical_bar.css('top', '0px');

      // Get time at mouse
      if (jQuery(event.target).closest('.calendar_eventRows').length == 0) {
        // "Invalid" times, from space after the last planner row, or header
        var time = planner._get_time_from_position(event.pageX - planner.grid.offset().left, 10);
      } else if (planner.options.group_by == 'month') {
        var time = planner._get_time_from_position(event.clientX, event.clientY);
      } else {
        var time = planner._get_time_from_position(event.offsetX, event.offsetY);
      }
      // Passing to formatter, cancel out timezone
      if (time) {
        var _formatDate = new Date(time.valueOf() + time.getTimezoneOffset() * 60 * 1000);
        planner.vertical_bar.html('<span>' + date(egw$1.preference('timeformat', 'calendar') == 12 ? 'h:ia' : 'H:i', _formatDate) + '</span>').show();
        if (!planner.drag_create.event && planner.drag_create.start && time.toJSON() != planner.drag_create.start.date.toJSON()) {
          planner._drag_create_start(planner.drag_create.start);
          // Create the event immediately
          planner._drag_create_event();
        }
        if (planner.drag_create.event && planner.drag_create.parent && planner.drag_create.end) {
          var _planner$drag_create$;
          if (((_planner$drag_create$ = planner.drag_create.start) === null || _planner$drag_create$ === void 0 || (_planner$drag_create$ = _planner$drag_create$.date) === null || _planner$drag_create$ === void 0 ? void 0 : _planner$drag_create$.toJSON()) == time.toJSON()) {
            // Minimum drag size is time granularity or default
            time.setUTCMinutes(time.getUTCMinutes() + parseInt(planner.egw().preference("defaultlength", "calendar")));
          }
          planner.drag_create.end.date = time;
          planner._drag_update_event();
        }
      } else {
        // No (valid) time, just hide
        planner.vertical_bar.hide();
      }
    }).on('mousedown', jQuery.proxy(this._mouse_down, this)).on('mouseup', jQuery.proxy(this._mouse_up, this));

    // Actions may be set on a parent, so we need to explicitly get in here
    // and get ours
    this._link_actions(this.options.actions || this.getParent().options.actions || []);

    // Customize and override some draggable settings
    this.div.on('dragstart', '.calendar_calEvent', function (event) {
      // Cancel drag to create, we're dragging an existing event
      planner._drag_create_end();
    }).on("dragend", () => {
      this.div.removeClass(["drop-hover", "et2-dropzone"]);

      // Remove helper
      document.body.querySelectorAll(".calendar_d-n-d_helper").forEach(n => n.remove());
    });
    this.div.get(0).addEventListener("click", this.click, true);
    return true;
  }
  _createNamespace() {
    return true;
  }
  /**
   * Something changed, and the planner needs to be re-drawn.  We wait a bit to
   * avoid re-drawing twice if start and end date both changed, then recreate.
   *
   * @param {boolean} trigger =false Trigger an event once things are done.
   *	Waiting until invalidate completes prevents 2 updates when changing the date range.
   * @returns {undefined}
   */
  invalidate(trigger) {
    // Busy
    if (!this.doInvalidate) return;

    // Not yet ready
    if (!this.options.start_date || !this.options.end_date) return;

    // Wait a bit to see if anything else changes, then re-draw the days
    if (this.update_timer !== null) {
      window.clearTimeout(this.update_timer);
    }
    this.update_timer = window.setTimeout(jQuery.proxy(function () {
      this.widget.doInvalidate = false;

      // Show AJAX loader
      this.widget.loader.show();
      this.widget.cache = {};
      this._deferred_row_updates = {};
      this.widget._fetch_data();
      this.widget._drawGrid();
      if (this.trigger) {
        this.widget.change();
      }
      this.widget.update_timer = null;
      this.widget.doInvalidate = true;
      this.widget._updateNow();
      window.setTimeout(jQuery.proxy(function () {
        if (this.loader) this.loader.hide();
      }, this.widget), 500);
    }, {
      widget: this,
      "trigger": trigger
    }), et2_dataview_grid.ET2_GRID_INVALIDATE_TIMEOUT);
  }
  detachFromDOM() {
    // Remove the binding to the change handler
    jQuery(this.div).off("change.et2_calendar_timegrid");
    return super.detachFromDOM();
  }
  attachToDOM() {
    var result = super.attachToDOM();

    // Add the binding for the event change handler
    jQuery(this.div).on("change.et2_calendar_timegrid", '.calendar_calEvent', this, function (e) {
      // Make sure function gets a reference to the widget
      var args = Array.prototype.slice.call(arguments);
      if (args.indexOf(this) == -1) args.push(this);
      return e.data.event_change.apply(e.data, args);
    });

    // Add the binding for the change handler
    jQuery(this.div).on("change.et2_calendar_timegrid", '*:not(.calendar_calEvent)', this, function (e) {
      return e.data.change.call(e.data, e, this);
    });
    return result;
  }
  getDOMNode(_sender) {
    if (_sender === this || !_sender) {
      return this.div[0];
    }
    if (_sender._parent === this) {
      return this.rows[0];
    }
  }

  /**
   * Creates all the DOM nodes for the planner grid
   *
   * Any existing nodes (& children) are removed, the headers & labels are
   * determined according to the current group_by value, and then the rows
   * are created.
   *
   * @method
   * @private
   *
   */
  _drawGrid() {
    var _this2 = this;
    return _asyncToGenerator$2(function* () {
      _this2.div.css('height', _this2.options.height);

      // Clear old events
      var delete_index = _this2._children.length - 1;
      while (_this2._children.length > 0 && delete_index >= 0) {
        _this2._children[delete_index].destroy();
        _this2.removeChild(_this2._children[delete_index--]);
      }

      // Clear old rows
      _this2.rows.empty().append(_this2.grid);
      _this2.grid.empty();
      var grouper = _this2.grouper;
      if (!grouper) return;

      // Headers
      _this2.headers.empty();
      _this2.headerTitle.text(grouper.title.apply(_this2));
      yield grouper.headers.apply(_this2);
      _this2.grid.find('*').contents().filter(function () {
        return this.nodeType === 3;
      }).remove();

      // Get the rows / labels
      var labels = grouper.row_labels.call(_this2);

      // Group the events
      var events = {};
      for (var i = 0; i < _this2.value.length; i++) {
        grouper.group.call(_this2, labels, events, _this2.value[i]);
      }

      // Set height for rows
      _this2.rows.height(_this2.div.height() - _this2.headers.outerHeight());

      // Draw the rows
      var app_calendar = _this2.getInstanceManager().app_obj.calendar || app.calendar;
      for (var key in labels) {
        if (!labels.hasOwnProperty(key)) continue;

        // Skip sub-categories (events are merged into top level)
        if (_this2.options.group_by == 'category' && (!app_calendar.state.cat_id || app_calendar.state.cat_id == '') && labels[key].id != labels[key].main) {
          continue;
        }
        var row = grouper.draw_row.call(_this2, labels[key].id, labels[key].label, events[key] || []);

        // Add extra data for clicking on row
        if (row) {
          for (var extra in labels[key].data) {
            row.getDOMNode().dataset[extra] = labels[key].data[extra];
          }
        }
      }

      // Adjust header if there's a scrollbar
      if (_this2.rows.children().last().length) {
        _this2.gridHeader.css('margin-right', _this2.rows.width() - _this2.rows.children().first().width() + 'px');
      }
      // Add actual events
      for (var key in _this2._deferred_row_updates) {
        window.clearTimeout(key);
      }
      window.setTimeout(jQuery.proxy(function () {
        this._deferred_row_update();
      }, _this2), et2_calendar_planner.DEFERRED_ROW_TIME);
      _this2.value = [];
    })();
  }

  /**
   * Draw a single row of the planner
   *
   * @param {string} key Index into the grouped labels & events
   * @param {string} label
   * @param {Array} events
   * @param {Date} start
   * @param {Date} end
   */
  _drawRow(key, label, events, start, end) {
    var row = et2_createWidget('calendar-planner_row', {
      id: 'planner_row_' + key,
      label: label,
      start_date: start,
      end_date: end,
      value: events,
      readonly: this.options.readonly
    }, this);
    if (this.isInTree()) {
      row.doLoadingFinished();
    }
    return row;
  }
  _header_day_of_month() {
    var day_width = 3.23; // 100.0 / 31;

    // month scale with navigation
    var content = '<div class="calendar_plannerScale">';
    var start = new Date(this.options.start_date);
    start = new Date(start.valueOf() + start.getTimezoneOffset() * 60 * 1000);
    var end = new Date(this.options.end_date);
    end = new Date(end.valueOf() + end.getTimezoneOffset() * 60 * 1000);
    var title = this.egw().lang(date('F', start)) + ' ' + date('Y', start) + ' - ' + this.egw().lang(date('F', end)) + ' ' + date('Y', end);
    content += '<div class="calendar_plannerMonthScale th et2_link" style="left: 0; width: 100%;">' + title + "</div>";
    content += "</div>"; // end of plannerScale

    // day of month scale
    content += '<div class="calendar_plannerScale">';
    for (var left = 0, i = 0; i < 31; left += day_width, ++i) {
      content += '<div class="calendar_plannerDayOfMonthScale " style="left: ' + left + '%; width: ' + day_width + '%;">' + (1 + i) + "</div>\n";
    }
    content += "</div>\n";
    return content;
  }
  /**
   * Update the 'now' line
   * @private
   */
  _updateNow() {
    var now = super._updateNow();
    if (now === false || this.grouper == this.groupers.month) {
      this.now_div.hide();
      return false;
    }
    var row = null;
    for (var i = 0; i < this._children.length && row == null; i++) {
      if (this._children[i].instanceOf(et2_calendar_planner_row)) {
        row = this._children[i];
      }
    }
    if (!row) {
      this.now_div.hide();
      return false;
    }
    this.now_div.appendTo(this.grid).show().css('left', row._time_to_position(now) + '%');
  }

  /**
   * Make a header showing the months
   * @param {Date} start
   * @param {number} days
   * @returns {string} HTML snippet
   */
  _header_months(start, days) {
    var content = '<div class="calendar_plannerScale">';
    var days_in_month = 0;
    var day_width = 100 / days;
    var end = new Date(start);
    end.setUTCDate(end.getUTCDate() + days);
    var t = new Date(start.valueOf());
    for (var left = 0, i = 0; i < days; t.setUTCDate(1), t.setUTCMonth(t.getUTCMonth() + 1), left += days_in_month * day_width, i += days_in_month) {
      var u = new Date(t.getUTCFullYear(), t.getUTCMonth() + 1, 0, -t.getTimezoneOffset() / 60);
      days_in_month = 1 + (u - t) / (24 * 3600 * 1000);
      var first = new Date(t.getUTCFullYear(), t.getUTCMonth(), 1, -t.getTimezoneOffset() / 60);
      if (days_in_month <= 0) break;
      if (i + days_in_month > days) {
        days_in_month = days - i;
      }
      var title = this.egw().lang(date('F', new Date(t.valueOf() + t.getTimezoneOffset() * 60 * 1000)));
      if (days_in_month > 10) {
        title += '</span> <span class="et2_clickable et2_link" data-sortby="month">' + t.getUTCFullYear();
      } else if (days_in_month < 5) {
        title = '&nbsp;';
      }
      content += '<div class="calendar_plannerMonthScale" data-date="' + first.toJSON() + '" style="left: ' + left + '%; width: ' + day_width * days_in_month + '%;"><span' + ' data-planner_view="month" class="et2_clickable et2_link">' + title + "</span></div>";
    }
    content += "</div>"; // end of plannerScale

    return content;
  }

  /**
   * Make a header showing the week numbers
   *
   * @param {Date} start
   * @param {number} days
   * @returns {string} HTML snippet
   */
  _header_weeks(start, days) {
    var content = '<div class="calendar_plannerScale" data-planner_view="week">';
    var state = '';

    // we're not using UTC so date() formatting function works
    var t = new Date(start.valueOf());

    // Make sure we're lining up on the week
    var app_calendar = this.getInstanceManager().app_obj.calendar || app.calendar;
    var week_end = app_calendar.date.end_of_week(start);
    var days_in_week = Math.floor((week_end - start) / (24 * 3600 * 1000) + 1);
    var week_width = 100 / days * (days <= 7 ? days : days_in_week);
    for (var left = 0, i = 0; i < days; t.setUTCDate(t.getUTCDate() + 7), left += week_width) {
      // Avoid overflow at the end
      if (days - i < 7) {
        days_in_week = days - i;
      }
      var usertime = new Date(t.valueOf());
      if (start.getTimezoneOffset() < 0) {
        // Gets the right week # east of GMT.  West does not need it(?)
        usertime.setUTCMinutes(usertime.getUTCMinutes() - start.getTimezoneOffset());
      }
      week_width = 100 / days * Math.min(days, days_in_week);
      var title = this.egw().lang('Week') + ' ' + app_calendar.date.week_number(usertime);
      if (start.getTimezoneOffset() > 0) {
        // Gets the right week start west of GMT
        usertime.setUTCMinutes(usertime.getUTCMinutes() + start.getTimezoneOffset());
      }
      state = app_calendar.date.start_of_week(usertime);
      state.setUTCHours(0);
      state.setUTCMinutes(0);
      state = state.toJSON();
      if (days_in_week > 1 || days == 1) {
        content += '<div class="calendar_plannerWeekScale et2_clickable et2_link" data-date=\'' + state + '\' style="left: ' + left + '%; width: ' + week_width + '%;">' + title + "</div>";
      }
      i += days_in_week;
      if (days_in_week != 7) {
        t.setUTCDate(t.getUTCDate() - (7 - days_in_week));
        days_in_week = 7;
      }
    }
    content += "</div>"; // end of plannerScale

    return content;
  }

  /**
   * Make a header for some days
   *
   * @param {Date} start
   * @param {number} days
   * @returns {string} HTML snippet
   */
  _header_days(start, days) {
    var _this3 = this;
    return _asyncToGenerator$2(function* () {
      var day_width = 100 / days;
      var content = '<div class="calendar_plannerScale' + (days > 3 ? 'Day' : '') + '" data-planner_view="day" >';

      // we're not using UTC so date() formatting function works
      var t = new Date(start.valueOf() + start.getTimezoneOffset() * 60 * 1000);
      for (var left = 0, i = 0; i < days; t.setDate(t.getDate() + 1), left += day_width, ++i) {
        if (!_this3.options.show_weekend && [0, 6].indexOf(t.getDay()) !== -1) continue;
        var holidays = [];
        var tempDate = new Date(t);
        tempDate.setMinutes(tempDate.getMinutes() - tempDate.getTimezoneOffset());
        var title = '';
        var state = new Date(t.valueOf() - t.getTimezoneOffset() * 60 * 1000);
        var day_class = yield _this3.day_class_holiday(state, holidays, days);
        if (days <= 3) {
          title = _this3.egw().lang(date('l', t)) + ', ' + date('j', t) + '. ' + _this3.egw().lang(date('F', t));
        } else if (days <= 7) {
          title = _this3.egw().lang(date('l', t)) + ' ' + date('j', t);
        } else {
          title = _this3.egw().lang(date('D', t)).substr(0, 2) + '<br />' + date('j', t);
        }
        content += '<div class="calendar_plannerDayScale et2_clickable et2_link ' + day_class + '" data-date=\'' + state.toJSON() + '\'' + (holidays ? ' title="' + holidays.join(',') + '"' : '') + '>' + title + "</div>\n";
      }
      content += "</div>"; // end of plannerScale

      return content;
    })();
  }

  /**
   * Create a header with hours
   *
   * @param {Date} start
   * @param {number} days
   * @returns {string} HTML snippet for the header
   */
  _header_hours(start, days) {
    var divisors = [1, 2, 3, 4, 6, 8, 12];
    var decr = 1;
    for (var i = 0; i < divisors.length; i++)
    // numbers dividing 24 without rest
    {
      if (divisors[i] > days) break;
      decr = divisors[i];
    }
    var hours = days * 24;
    if (days === 1)
      // for a single day we calculate the hours of a days, to take into account daylight saving changes (23 or 25 hours)
      {
        var t = new Date(start.getUTCFullYear(), start.getUTCMonth(), start.getUTCDate(), -start.getTimezoneOffset() / 60);
        var s = new Date(start);
        s.setUTCHours(23);
        s.setUTCMinutes(59);
        s.setUTCSeconds(59);
        hours = Math.ceil((s.getTime() - t.getTime()) / 3600000);
      }
    var cell_width = 100 / hours * decr;
    var content = '<div class="calendar_plannerScale" data-planner_view="day">';

    // we're not using UTC so date() formatting function works
    var t = new Date(start.valueOf() + start.getTimezoneOffset() * 60 * 1000);
    for (var left = 0, i = 0; i < hours; left += cell_width, i += decr) {
      if (!this.options.show_weekend && [0, 6].indexOf(t.getDay()) !== -1) continue;
      var title = date(egw$1.preference('timeformat', 'calendar') == 12 ? 'ha' : 'H', t);
      content += '<div class="calendar_plannerHourScale et2_link" data-date="' + t.toJSON() + '" style="left: ' + left + '%; width: ' + cell_width + '%;">' + title + "</div>";
      t.setHours(t.getHours() + decr);
    }
    content += "</div>"; // end of plannerScale

    return content;
  }

  /**
   * Applies class for today, and any holidays for current day
   *
   * @param {Date} date
   * @param {string[]} holiday_list Filled with a list of holidays for that day
   * @param {integer} days Number of days shown in the day header
   *
   * @return {string} CSS Classes for the day.  calendar_calBirthday, calendar_calHoliday, calendar_calToday and calendar_weekend as appropriate
   */
  day_class_holiday(date, holiday_list, days) {
    var _this4 = this;
    return _asyncToGenerator$2(function* () {
      if (!date) {
        return '';
      }

      // Holidays and birthdays
      var fetched = yield _this4.egw().holidays(date.getUTCFullYear());
      var day_class = '';

      // Pass a string rather than the date object, to make sure it doesn't get changed
      var date_key = formatDate(_this4.date_helper(date.toJSON()), {
        dateFormat: "Ymd"
      });
      if (fetched && fetched[date_key]) {
        var dates = fetched[date_key];
        for (var i = 0; i < dates.length; i++) {
          if (typeof dates[i]['birthyear'] !== 'undefined') {
            day_class += ' calendar_calBirthday ';
            if (typeof days == 'undefined' || days <= 21) {
              day_class += ' calendar_calBirthdayIcon ';
            }
            holiday_list.push(dates[i]['name']);
          } else {
            day_class += 'calendar_calHoliday ';
            holiday_list.push(dates[i]['name']);
          }
        }
      }
      var today = new Date();
      if (date_key === '' + today.getFullYear() + sprintf("%02d", today.getMonth() + 1) + sprintf("%02d", today.getDate())) {
        day_class += "calendar_calToday ";
      }
      if (date.getUTCDay() == 0 || date.getUTCDay() == 6) {
        day_class += "calendar_weekend ";
      }
      return day_class;
    })();
  }

  /**
   * Link the actions to the DOM nodes / widget bits.
   *
   * @todo This currently does nothing
   * @param {object} actions {ID: {attributes..}+} map of egw action information
   */
  _link_actions(actions) {
    if (!this._actionObject) {
      // Get the parent?  Might be a grid row, might not.  Either way, it is
      // just a container with no valid actions
      var objectManager = egw_getObjectManager(this.getInstanceManager().app, true, 1);
      objectManager = objectManager.getObjectById(this.getInstanceManager().uniqueId, 2) || objectManager;
      var parent = objectManager.getObjectById(this.id, 3) || objectManager.getObjectById(this._parent.id, 3) || objectManager;
      if (!parent) {
        debugger;
        egw$1.debug('error', 'No parent objectManager found');
        return;
      }
      for (var i = 0; i < parent.children.length; i++) {
        var parent_finder = jQuery('#' + this.div.id, parent.children[i].iface.doGetDOMNode());
        if (parent_finder.length > 0) {
          parent = parent.children[i];
          break;
        }
      }
    }

    // This binds into the egw action system.  Most user interactions (drag to move, resize)
    // are handled internally using jQuery directly.
    var widget_object = this._actionObject || parent.getObjectById(this.id);
    var aoi = new et2_action_object_impl(this, this.getDOMNode(this)).getAOI();

    /**
     * Determine if we allow a dropped event to use the invite/change actions,
     * and enable or disable them appropriately
     *
     * @param {egwAction} action
     * @param {et2_calendar_event} event The event widget being dragged
     * @param {egwActionObject} target Planner action object
     */
    var _invite_enabled = function _invite_enabled(action, event, target) {
      var event = event.iface.getWidget();
      var planner = target.iface.getWidget() || false;
      //debugger;
      if (event === planner || !event || !planner || !event.options || !event.options.value.participants || !planner.options.owner) {
        return false;
      }
      var owner_match = false;
      var own_row = false;
      for (var id in event.options.value.participants) {
        planner.iterateOver(function (row) {
          // Check scroll section or header section
          if (row.div.hasClass('drop-hover') || row.div.has(':hover')) {
            owner_match = owner_match || row.node.dataset[planner.options.group_by] === '' + id;
            own_row = row === event.getParent();
          }
        }, this, et2_calendar_planner_row);
      }
      var enabled = !owner_match &&
      // Not inside its own row
      !own_row;
      widget_object.getActionLink('invite').enabled = enabled;
      widget_object.getActionLink('change_participant').enabled = enabled;

      // If invite or change participant are enabled, drag is not
      widget_object.getActionLink('egw_link_drop').enabled = !enabled;
    };
    aoi.doTriggerEvent = function (_event, _data) {
      egw$1.tooltipDestroy();

      // Determine target node
      var event = _data.event || false;
      if (!event) {
        return;
      }
      if (_data.ui.draggable.classList.contains('rowNoEdit')) {
        return;
      }

      /*
      We have to handle the drop in the normal event stream instead of waiting
      for the egwAction system so we can get the helper, and destination
      */
      if (event.type === 'drop') {
        this.getWidget()._event_drop.call(_data.ui.draggable, this.getWidget(), event, _data.ui);
      }
      var drag_listener = function drag_listener(event) {
        event.preventDefault();
        var helper = document.body.querySelector(".calendar_d-n-d_helper");
        if (helper) {
          helper.style.top = event.clientY + 20 + "px";
          helper.style.left = event.clientX - helper.clientWidth / 2 + "px";
        }
        var style = getComputedStyle(_data.ui.helper);
        aoi.getWidget()._drag_helper(helper, {
          top: Number.isNaN(style.top) ? event.clientY : parseInt(style.top),
          left: event.clientX - jQuery(this).parent().offset().left
        }, 0);
      };
      var time = jQuery('.calendar_d-n-d_timeCounter', _data.ui.helper);
      switch (_event) {
        // Triggered once, when something is dragged into the timegrid's div
        case EGW_AI_DRAG_ENTER:
          // Listen to the drag and update the helper with the time
          // This part lets us drag between different timegrids
          jQuery(_data.ui.draggable).on('drag.et2_timegrid' + widget_object.id, drag_listener);
          jQuery(_data.ui.draggable).on('dragend.et2_timegrid' + widget_object.id, function () {
            jQuery(_data.ui.draggable).off('drag.et2_timegrid' + widget_object.id);
            aoi.getWidget().div.removeClass(["drop-hover", "et2-dropzone"]);

            // Remove helper
            document.body.querySelectorAll(".calendar_d-n-d_helper").forEach(n => n.remove());
          });
          if (time.length) {
            // The out will trigger after the over, so we count
            time.data('count', time.data('count') + 1);
          } else {
            jQuery(_data.ui.helper).prepend('<div class="calendar_d-n-d_timeCounter" data-count="1"><span></span></div>');
          }
          break;

        // Triggered once, when something is dragged out of the timegrid
        case EGW_AI_DRAG_OUT:
          // Stop listening
          jQuery(_data.ui.draggable).off('drag.et2_timegrid' + widget_object.id);
          // Remove any highlighted time squares
          jQuery('[data-date]', this.doGetDOMNode()).removeClass("ui-state-active");

          // Out triggers after the over, count to not accidentally remove
          time.data('count', time.data('count') - 1);
          if (time.length && time.data('count') <= 0) {
            time.remove();
          }
          break;
      }
    };
    if (widget_object == null) {
      // Add a new container to the object manager which will hold the widget
      // objects
      widget_object = parent.insertObject(false, new egwActionObject(this.id, parent, aoi, this._actionManager || parent.manager.getActionById(this.id) || parent.manager), EGW_AO_FLAG_IS_CONTAINER);
    } else {
      widget_object.setAOI(aoi);
    }
    // Go over the widget & add links - this is where we decide which actions are
    // 'allowed' for this widget at this time
    var action_links = this._get_action_links(actions);
    this._init_links_dnd(widget_object.manager, action_links);
    widget_object.updateActionLinks(action_links);
    this._actionObject = widget_object;
  }

  /**
   * Automatically add dnd support for linking
   *
   * @param {type} mgr
   * @param {type} actionLinks
   */
  _init_links_dnd(mgr, actionLinks) {
    if (this.options.readonly) return;
    var self = this;
    var drop_action = mgr.getActionById('egw_link_drop');
    var drop_change_participant = mgr.getActionById('change_participant');
    var drop_invite = mgr.getActionById('invite');
    var drag_action = mgr.getActionById('egw_link_drag');
    var paste_action = mgr.getActionById('egw_paste');

    // Disable paste action
    if (paste_action == null) {
      paste_action = mgr.addAction('popup', 'egw_paste', egw$1.lang('Paste'), egw$1.image('editpaste'), function () {}, true);
    }
    paste_action.set_enabled(false);

    // Check if this app supports linking
    if (!egw$1.link_get_registry(this.dataStorePrefix || 'calendar', 'query') || egw$1.link_get_registry(this.dataStorePrefix || 'calendar', 'title')) {
      if (drop_action) {
        drop_action.remove();
        if (actionLinks.indexOf(drop_action.id) >= 0) {
          actionLinks.splice(actionLinks.indexOf(drop_action.id), 1);
        }
      }
      if (drag_action) {
        drag_action.remove();
        if (actionLinks.indexOf(drag_action.id) >= 0) {
          actionLinks.splice(actionLinks.indexOf(drag_action.id), 1);
        }
      }
      return;
    }

    // Don't re-add
    if (drop_action == null) {
      // Create the drop action that links entries
      drop_action = mgr.addAction('drop', 'egw_link_drop', egw$1.lang('Create link'), egw$1.image('link'), function (action, source, dropped) {
        // Extract link IDs
        var links = [];
        var id = '';
        for (var i = 0; i < source.length; i++) {
          if (!source[i].id) continue;
          if (source[i].manager === dropped.manager) {
            // Find the planner, could have dropped on an event
            var planner = dropped.iface.getWidget();
            while (planner.getParent() && planner.instanceOf && !planner.instanceOf(et2_calendar_planner)) {
              planner = planner.getParent();
            }
            if (planner && planner._drop_data) {
              planner._event_drop.call(source[i].iface.getDOMNode(), planner, null, action.ui);
            }
            planner._drop_data = false;
            // Ok, stop.
            return false;
          }
          id = source[i].id.split('::');
          links.push({
            app: id[0] == 'filemanager' ? 'link' : id[0],
            id: id[1]
          });
        }
        if (!links.length) {
          return;
        }
        if (links.length && dropped && dropped.iface.getWidget() && dropped.iface.getWidget().instanceOf(et2_calendar_event)) {
          // Link the entries
          egw$1.json(self.egw().getAppName() + ".etemplate_widget_link.ajax_link.etemplate", dropped.id.split('::').concat([links]), function (result) {
            if (result) {
              this.egw().message('Linked');
            }
          }, self, true, self).sendRequest();
        }
      }, true);
      drop_action.acceptedTypes = ['default', 'link'];
      drop_action.hideOnDisabled = true;

      // Create the drop action for moving events between planner rows
      var invite_action = function invite_action(action, source, target) {
        // Extract link IDs
        var links = [];
        var id = '';
        for (var i = 0; i < source.length; i++) {
          // Check for no ID (invalid) or same manager (dragging an event)
          if (!source[i].id) continue;
          if (source[i].manager === target.manager) {
            // Find the row, could have dropped on an event
            var row = target.iface.getWidget();
            while (target.parent && row.instanceOf && !row.instanceOf(et2_calendar_planner_row)) {
              target = target.parent;
              row = target.iface.getWidget();
            }

            // Leave the helper there until the update is done
            var loading = action.ui.draggable;

            // and add a loading icon so user knows something is happening
            if (jQuery('.calendar_timeDemo', loading).length == 0) {
              jQuery('.calendar_calEventHeader', loading).addClass('loading');
            } else {
              jQuery('.calendar_timeDemo', loading).after('<div class="loading"></div>');
            }
            var event_data = egw$1.dataGetUIDdata(source[i].id).data;
            et2_calendar_event.recur_prompt(event_data, function (button_id) {
              if (button_id === 'cancel' || !button_id) {
                return;
              }
              var add_owner = [row.node.dataset.participants];
              egw$1().json('calendar.calendar_uiforms.ajax_invite', [button_id === 'series' ? event_data.id : event_data.app_id, add_owner, action.id === 'change_participant' ? [source[i].iface.getWidget().getParent().node.dataset.participants] : []], function () {
                loading.remove();
              }).sendRequest(true);
            });
            // Ok, stop.
            return false;
          }
        }
      };
      drop_change_participant = mgr.addAction('drop', 'change_participant', egw$1.lang('Move to'), egw$1.image('participant'), invite_action, true);
      drop_change_participant.acceptedTypes = ['calendar'];
      drop_change_participant.hideOnDisabled = true;
      drop_invite = mgr.addAction('drop', 'invite', egw$1.lang('Invite'), egw$1.image('participant'), invite_action, true);
      drop_invite.acceptedTypes = ['calendar'];
      drop_invite.hideOnDisabled = true;
    }
    if (actionLinks.indexOf(drop_action.id) < 0) {
      actionLinks.push(drop_action.id);
    }
    actionLinks.push(drop_invite.id);
    actionLinks.push(drop_change_participant.id);

    // Accept other links, and files dragged from the filemanager
    // This does not handle files dragged from the desktop.  They are
    // handled by et2_nextmatch, since it needs DOM stuff
    if (drop_action.acceptedTypes.indexOf('link') == -1) {
      drop_action.acceptedTypes.push('link');
    }

    // Don't re-add
    if (drag_action == null) {
      // Create drag action that allows linking
      drag_action = mgr.addAction('drag', 'egw_link_drag', egw$1.lang('link'), 'link', function (action, selected) {
        var helper = selected[0].iface.getWidget().getDOMNode().cloneNode();
        helper.classList.add("calendar_d-n-d_helper");
        var position = selected[0].iface.getDOMNode().getBoundingClientRect();
        self._drag_helper(helper, position, position.height);
        document.body.append(helper);

        // System drag helper - empty span so we can update with the target time
        return document.createElement("span");
      }, true);
    }
    // The planner itself is not draggable, the action is there for the children
    if (false && actionLinks.indexOf(drag_action.id) < 0) {
      actionLinks.push(drag_action.id);
    }
    drag_action.set_dragType(['link', 'calendar']);
  }

  /**
   * Get all action-links / id's of 1.-level actions from a given action object
   *
   * Here we are only interested in drop events.
   *
   * @param actions
   * @returns {Array}
   */
  _get_action_links(actions) {
    var action_links = [];

    // Only these actions are allowed without a selection (empty actions)
    var empty_actions = ['add'];
    for (var i in actions) {
      var action = actions[i];
      if (empty_actions.indexOf(action.id) !== -1 || action.type === 'drop') {
        action_links.push(typeof action.id !== 'undefined' ? action.id : i);
      }
    }
    // Disable automatic paste action, it doesn't have what is needed to work
    action_links.push({
      "actionObj": 'egw_paste',
      "enabled": false,
      "visible": false
    });
    return action_links;
  }

  /**
   * Show the current time while dragging
   * Used for resizing as well as drag & drop
   *
   * @param {type} element
   * @param {type} position
   * @param {type} height
   */
  _drag_helper(element, position, height) {
    if (!element) {
      return;
    }
    if (position.height) {
      element.style.height = position.height + "px";
    }
    var time = this._get_time_from_position(position.left, position.top);
    element.dropEnd = time;
    if (time) {
      this._drop_data = _objectSpread$1({}, element.dataset);
    }
    var formatted_time = formatTime(time);
    element.innerHTML = '<div class="calendar_d-n-d_timeCounter"><span class="calendar_timeDemo" >' + formatted_time + '</span></div>';
    element.querySelector('.calendar_d-n-d_timeCounter').dropEnd = time;

    //jQuery(element).width(jQuery(helper).width());
  }

  /**
   * Handler for dropping an event on the timegrid
   *
   * @param {type} planner
   * @param {type} event
   * @param {type} ui
   */
  _event_drop(planner, event, ui) {
    var e = new jQuery.Event('change');
    e.originalEvent = event;
    e.data = {
      start: 0
    };
    if (typeof this.dropEnd != 'undefined' && this.dropEnd) {
      var drop_date = this.dropEnd.toJSON() || false;
      this.dropEnd = undefined;
      var event_data = planner._get_event_info(ui.draggable);
      var event_widget = planner.getWidgetById(event_data.widget_id);
      if (event_widget) {
        event_widget.options.value.start = event_widget._parent.date_helper(drop_date);

        // Leave the helper there until the update is done
        var loading = event_data.event_node;
        // and add a loading icon so user knows something is happening
        jQuery('.calendar_calEventHeader', event_widget.div).addClass('loading');
        event_widget.recur_prompt(function (button_id) {
          if (button_id === 'cancel' || !button_id) return;
          //Get infologID if in case if it's an integrated infolog event
          if (event_data.app === 'infolog') {
            // If it is an integrated infolog event we need to edit infolog entry
            egw$1().json('stylite_infolog_calendar_integration::ajax_moveInfologEvent', [event_data.id, event_widget.options.value.start || false], function () {
              loading.remove();
            }).sendRequest(true);
          } else {
            //Edit calendar event
            egw$1().json('calendar.calendar_uiforms.ajax_moveEvent', [button_id === 'series' ? event_data.id : event_data.app_id, event_data.owner, event_widget.options.value.start, planner.options.owner || egw$1.user('account_id')], function () {
              loading.remove();
            }).sendRequest(true);
          }
        });
      }
    }
  }

  /**
   * Use the egw.data system to get data from the calendar list for the
   * selected time span.
   *
   */
  _fetch_data() {
    var value = [];
    var fetch = false;
    this.doInvalidate = false;
    for (var i = 0; i < this.registeredCallbacks.length; i++) {
      egw$1.dataUnregisterUID(this.registeredCallbacks[i], false, this);
    }
    this.registeredCallbacks.splice(0, this.registeredCallbacks.length);

    // Remember previous day to avoid multi-days duplicating
    var last_data = [];
    var t = new Date(this.options.start_date);
    var end = new Date(this.options.end_date);
    do {
      value = value.concat(this._cache_register(t, this.options.owner, last_data));
      t.setUTCDate(t.getUTCDate() + 1);
    } while (t < end);
    this.doInvalidate = true;
    return value;
  }

  /**
   * Deal with registering for data cache
   *
   * @param Date t
   * @param String owner Calendar owner
   */
  _cache_register(t, owner, last_data) {
    // Cache is by date (and owner, if seperate)
    var date = t.getUTCFullYear() + sprintf('%02d', t.getUTCMonth() + 1) + sprintf('%02d', t.getUTCDate());
    var cache_id = CalendarApp._daywise_cache_id(date, owner);
    var value = [];
    if (egw$1.dataHasUID(cache_id)) {
      var c = egw$1.dataGetUIDdata(cache_id);
      if (c.data && c.data !== null) {
        // There is data, pass it along now
        for (var j = 0; j < c.data.length; j++) {
          if (last_data.indexOf(c.data[j]) === -1 && egw$1.dataHasUID('calendar::' + c.data[j])) {
            value.push(egw$1.dataGetUIDdata('calendar::' + c.data[j]).data);
          }
        }
        last_data = c.data;
      }
    } else {
      // Assume it's empty, if there is data it will be filled later
      egw$1.dataStoreUID(cache_id, []);
    }
    this.registeredCallbacks.push(cache_id);
    egw$1.dataRegisterUID(cache_id, function (data) {
      if (data && data.length) {
        for (var i = 0; i < data.length; i++) {
          var event = egw$1.dataGetUIDdata('calendar::' + data[i]);
          if (!event || !event.data) {
            continue;
          }
          var wait = app.calendar._fetch_group_members(event.data);
          this.waitForGroups.push(wait);
          this.waitForIds.splice(this.waitForIds.length, 0, ...data);
        }
      }
      if (!data || data.length == 0) {
        return;
      }
      if (this.groupWaitTimeout) {
        clearTimeout(this.groupWaitTimeout);
      } else {
        this.loader.show();
        this.doInvalidate = false;
      }
      this.groupWaitTimeout = setTimeout(() => {
        Promise.all(this.waitForGroups).then(() => {
          this.groupWaitTimeout = 0;
          this.loader.hide();
          var invalidate = true;

          // Try to determine rows interested
          var labels = [];
          var events = {};
          if (this.grouper) {
            labels = this.grouper.row_labels.call(this);
            invalidate = false;
          }
          var im = this.getInstanceManager();
          var waitData = this.waitForIds.filter((value, index, array) => array.indexOf(value) === index);
          this.waitForIds.splice(0, this.waitForIds.length);
          for (var _i2 = 0; _i2 < waitData.length; _i2++) {
            var event = egw$1.dataGetUIDdata('calendar::' + waitData[_i2]);
            if (!event) {
              continue;
            }
            events = {};

            // Try to determine rows interested
            if (event.data && this.grouper) {
              this.grouper.group.call(this, labels, events, event.data);
            }
            if (Object.keys(events).length > 0) {
              for (var label_id in events) {
                var id = "" + labels[label_id].id;
                if (typeof this.cache[id] === 'undefined') {
                  this.cache[id] = [];
                }
                if (this.cache[id].indexOf(event.data.row_id) === -1) {
                  this.cache[id].push(event.data.row_id);
                }
                if (this._deferred_row_updates[id]) {
                  window.clearTimeout(this._deferred_row_updates[id]);
                }
                this._deferred_row_updates[id] = window.setTimeout(jQuery.proxy(this._deferred_row_update, this, id), et2_calendar_planner.DEFERRED_ROW_TIME);
              }
            } else if (event.data) {
              // Could be an event no row is interested in, could be a problem.
              // Just ignore it
              console.log("Event could not be grouped", event.data.app_id + ": " + event.data.title);
              continue;
            }

            // If displaying by category, we need the infolog (or other app) categories too
            if (event && event.data && event.data.app && this.options.group_by == 'category') {
              // Fake it to use the cache / call
              this.nodeName = "ET2-SELECT-CAT_RO";
              var categories = StaticOptions.cached_server_side(this, "cat", ",,," + (event.data.app || 'calendar'), false);
            }
          }
          this.doInvalidate = true;
          if (invalidate) {
            this.invalidate(false);
          }
        }).then(() => {
          // Update the "now" line _after_ rows are done
          this._updateNow();
        });
      }, 100);
    }, this, this.getInstanceManager().execId, this.id);
    return value;
  }

  /**
   * Because users may be participants in various events and the time it takes
   * to create many events, we don't want to update a row too soon - we may have
   * to re-draw it if we find the user / category in another event.  Pagination
   * makes this worse.  We wait a bit before updating the row to avoid
   * having to re-draw it multiple times.
   *
   * @param {type} id
   * @returns {undefined}
   */
  _deferred_row_update(id) {
    // Something's in progress, skip
    if (!this.doInvalidate) return;
    this.grid.height(0);
    var id_list = typeof id === 'undefined' ? Object.keys(this.cache) : [id];
    for (var i = 0; i < id_list.length; i++) {
      var cache_id = id_list[i];
      var row = this.getWidgetById('planner_row_' + cache_id);
      window.clearTimeout(this._deferred_row_updates[cache_id]);
      delete this._deferred_row_updates[cache_id];
      if (row) {
        var _this$cache$cache_id;
        row._data_callback(this.cache[cache_id]);
        row.set_disabled(this.options.hide_empty && ((_this$cache$cache_id = this.cache[cache_id]) === null || _this$cache$cache_id === void 0 ? void 0 : _this$cache$cache_id.length) === 0);
      } else {
        break;
      }
    }

    // Updating the row may push things longer, update length
    // Add 1 to keep the scrollbar, otherwise we need to recalculate the
    // header widths too.
    this.grid.height(this.rows[0].scrollHeight + 1);

    // Adjust header if there's a scrollbar - Firefox needs this re-calculated,
    // otherwise the header will be missing the margin space for the scrollbar
    // in some cases
    if (this.rows.children().last().length) {
      this.gridHeader.css('margin-right', this.rows.width() - this.rows.children().first().width() + 'px');
    }
  }

  /**
   * Provide specific data to be displayed.
   * This is a way to set start and end dates, owner and event data in once call.
   *
   * @param {Object[]} events Array of events, indexed by date in Ymd format:
   *	{
   *		20150501: [...],
   *		20150502: [...]
   *	}
   *	Days should be in order.
   *
   */
  set_value(events) {
    if (typeof events !== 'object') return false;
    super.set_value(events);

    // Planner uses an array, not map
    var val = this.value;
    var array = [];
    Object.keys(this.value).forEach(function (key) {
      array.push(val[key]);
    });
    this.value = array;
  }

  /**
   * Change the start date
   * Planner view uses a date object internally
   *
   * @param {string|number|Date} new_date New starting date
   * @returns {undefined}
   */
  set_start_date(new_date) {
    super.set_start_date(new_date);
    this.options.start_date = new Date(this.options.start_date);
  }

  /**
   * Change the end date
   * Planner view uses a date object internally
   *
   * @param {string|number|Date} new_date New end date
   * @returns {undefined}
   */
  set_end_date(new_date) {
    super.set_end_date(new_date);
    this.options.end_date = new Date(this.options.end_date);
  }

  /**
   * Change how the planner is grouped
   *
   * @param {string|number} group_by 'user', 'month', or an integer category ID
   * @returns {undefined}
   */
  set_group_by(group_by) {
    if (isNaN(group_by) && typeof this.groupers[group_by] === 'undefined') {
      throw new Error('Invalid group_by "' + group_by + '"');
    }
    var old = this.options.group_by;
    this.options.group_by = '' + group_by;
    this.grouper = this.groupers[isNaN(this.options.group_by) ? this.options.group_by : 'category'];
    if (old !== this.options.group_by && this.isAttached()) {
      this.invalidate(true);
    }
  }

  /**
   * Set which users to display
   *
   * Changing the owner will invalidate the display, and it will be redrawn
   * after a timeout.  Overwriting here to check for groups without members.
   *
   * @param {number|number[]|string|string[]} _owner - Owner ID, which can
   *	be an account ID, a resource ID (as defined in calendar_bo, not
   *	necessarily an entry from the resource app), or a list containing a
   *	combination of both.
   *
   * @memberOf et2_calendar_view
   */
  set_owner(_owner) {
    super.set_owner(_owner);

    // If we're grouping by user, we need group members
    if (this.update_timer !== null && this.options.group_by == 'user') {
      var options = [];
      var resource = {};
      var missing_resources = [];
      if (app.calendar && app.calendar.sidebox_et2 && app.calendar.sidebox_et2.getWidgetById('owner')) {
        options = app.calendar.sidebox_et2.getWidgetById('owner').select_options;
      } else {
        options = this.getArrayMgr("sel_options").getRoot().getEntry('owner');
      }
      for (var i = 0; i < this.options.owner.length; i++) {
        var user = this.options.owner[i];
        if (isNaN(user) || user >= 0 || !options) continue;

        // Owner is a group, see if we have its members
        if (options.find && (resource = options.find(function (element) {
          return element.value == user;
        }))) {
          // Members found
          continue;
        }
        // Group, but no users found.  Need those.
        missing_resources.push(user);

        // Maybe api already has them?
        egw$1.accountData(parseInt(user), 'account_fullname', true, function (result) {
          missing_resources.splice(missing_resources.indexOf(this), 1);
        }.bind(user), user);
      }
      if (missing_resources.length > 0) {
        // Ask server, and WAIT or we have to redraw
        egw$1.json('calendar_owner_etemplate_widget::ajax_owner', [missing_resources], function (data) {
          for (var owner in data) {
            if (!owner || typeof owner == "undefined") continue;
            options.push(data[owner]);
          }
        }, this, false, this).sendRequest(false);
      }
    }
  }

  /**
   * Turn on or off the visibility of weekends
   *
   * @param {boolean} weekends
   */
  set_show_weekend(weekends) {
    weekends = weekends ? true : false;
    if (this.options.show_weekend !== weekends) {
      this.options.show_weekend = weekends;
      if (this.isAttached()) {
        this.invalidate();
      }
    }
  }

  /**
   * Turn on or off the visibility of hidden (empty) rows
   *
   * @param {boolean} hidden
   */
  set_hide_empty(hidden) {
    this.options.hide_empty = hidden;
  }

  /**
   * Call change handler, if set
   *
   * @param {type} event
   */
  change(event) {
    if (this.onchange) {
      if (typeof this.onchange == 'function') {
        // Make sure function gets a reference to the widget
        var args = Array.prototype.slice.call(arguments);
        if (args.indexOf(this) == -1) args.push(this);
        return this.onchange.apply(this, args);
      } else {
        return et2_compileLegacyJS(this.options.onchange, this, _node)();
      }
    }
  }

  /**
   * Call event change handler, if set
   *
   * @param {type} event
   * @param {type} dom_node
   */
  event_change(event, dom_node) {
    if (this.onevent_change) {
      var event_data = this._get_event_info(dom_node);
      var event_widget = this.getWidgetById(event_data.widget_id);
      et2_calendar_event.recur_prompt(event_data, jQuery.proxy(function (button_id, event_data) {
        // No need to continue
        if (button_id === 'cancel') return false;
        if (typeof this.onevent_change == 'function') {
          // Make sure function gets a reference to the widget
          var args = Array.prototype.slice.call(arguments);
          if (args.indexOf(event_widget) == -1) args.push(event_widget);

          // Put button ID in event
          event.button_id = button_id;
          return this.onevent_change.apply(this, [event, event_widget, button_id]);
        } else {
          return et2_compileLegacyJS(this.options.onevent_change, event_widget, dom_node)();
        }
      }, this));
    }
    return false;
  }

  /**
   * Click handler calling custom handler set via onclick attribute to this.onclick
   *
   * This also handles all its own actions, including navigation.  If there is
   * an event associated with the click, it will be found and passed to the
   * onclick function.
   *
   * @param {Event} _ev
   * @returns {boolean} Continue processing event (true) or stop (false)
   */
  click(_ev) {
    var result = true;

    // Drag to create in progress
    if (this.drag_create.start !== null) return;

    // Is this click in the event stuff, or in the header?
    if (!this.options.readonly && this.gridHeader.has(_ev.target).length === 0 && !jQuery(_ev.target).hasClass('calendar_plannerRowHeader')) {
      // Event came from inside, maybe a calendar event
      var event = this._get_event_info(_ev.target);
      if (typeof this.onclick == 'function') {
        // Make sure function gets a reference to the widget, splice it in as 2. argument if not
        var args = Array.prototype.slice.call(arguments);
        if (args.indexOf(this) == -1) args.splice(1, 0, this);
        result = this.onclick.apply(this, args);
      }
      if (event.id && result && !this.options.disabled && !this.options.readonly) {
        et2_calendar_event.recur_prompt(event);
        return false;
      } else if (!event.id) {
        // Clicked in row, but not on an event
        // Default handler to open a new event at the selected time
        if (jQuery(event.target).closest('.calendar_eventRows').length == 0) {
          // "Invalid" times, from space after the last planner row, or header
          var date = this._get_time_from_position(_ev.pageX - this.grid.offset().left, _ev.pageY - this.grid.offset().top);
        } else if (this.options.group_by == 'month') {
          var date = this._get_time_from_position(_ev.clientX, _ev.clientY);
        } else {
          var date = this._get_time_from_position(_ev.offsetX, _ev.offsetY);
        }
        var row = jQuery(_ev.target).closest('.calendar_plannerRowWidget');
        var data = row.length ? row[0].dataset : {};
        if (date) {
          app.calendar.add(jQuery.extend({
            start: date.toJSON(),
            hour: date.getUTCHours(),
            minute: date.getUTCMinutes()
          }, data));
          _ev.preventDefault();
          _ev.stopImmediatePropagation();
          return false;
        }
      }
      return result;
    } else if (this.gridHeader.has(_ev.target).length > 0 && !jQuery.isEmptyObject(_ev.target.dataset) || jQuery(_ev.target).hasClass('calendar_plannerRowHeader') && !jQuery.isEmptyObject(_ev.target.dataset)) {
      // Click on a header, we can go there
      _ev.data = jQuery.extend({}, _ev.target.parentNode.dataset, _ev.target.dataset);
      for (var key in _ev.data) {
        if (!_ev.data[key]) {
          delete _ev.data[key];
        }
      }
      app.calendar.update_state(_ev.data);
    } else if (!this.options.readonly) {
      // Default handler to open a new event at the selected time
      // TODO: Determine date / time more accurately from position
      app.calendar.add({
        date: _ev.target.dataset.date || this.options.start_date.toJSON(),
        hour: _ev.target.dataset.hour || this.options.day_start,
        minute: _ev.target.dataset.minute || 0
      });
      return false;
    }
  }

  /**
   * Get time from position
   *
   * @param {number} x
   * @param {number} y
   * @returns {Date|Boolean} A time for the given position, or false if one
   *	could not be determined.
   */
  _get_time_from_position(x, y) {
    if (!this.options.start_date || !this.options.end_date) {
      return false;
    }
    x = Math.round(x);
    y = Math.round(y);

    // Round to user's preferred event interval
    var interval = egw$1.preference('interval', 'calendar') || 30;

    // Relative horizontal position, as a percentage
    var width = 0;
    jQuery('.calendar_eventRows', this.div).each(function () {
      width = Math.max(width, jQuery(this).width());
    });
    var rel_x = Math.min(x / width, 1);

    // Relative time, in minutes from start
    var rel_time = 0;
    var day_header = jQuery('.calendar_plannerScaleDay', this.headers);
    var date;

    // Simple math, the x is offset from start date
    if (this.options.group_by !== 'month' && (
    // Either all days are visible, or only 1 day (no day header)
    this.options.show_weekend || day_header.length === 0)) {
      rel_time = (new Date(this.options.end_date) - new Date(this.options.start_date)) * rel_x / 1000;
      date = this.date_helper(this.options.start_date.toJSON());
    }
    // Not so simple math, need to account for missing days
    else if (this.options.group_by !== 'month' && !this.options.show_weekend) {
      // Find which day
      if (day_header.length === 0) return false;
      var day = document.elementFromPoint(day_header.offset().left + rel_x * this.headers.innerWidth(), day_header.offset().top);

      // Use day, and find time in that day
      if (day && day.dataset && day.dataset.date) {
        date = this.date_helper(day.dataset.date);
        rel_time = (x - jQuery(day).position().left) / jQuery(day).outerWidth(true) * 24 * 60;
        date.setUTCMinutes(Math.round(rel_time / interval) * interval);
        return date;
      }
      return false;
    } else {
      // Find the correct row so we know which month, then get the offset
      var hidden_nodes = [];
      var row = null;
      // Hide any drag or tooltips that may interfere
      do {
        row = document.elementFromPoint(x, y);
        if (row && this.div.has(row).length == 0) {
          hidden_nodes.push({
            element: row,
            display: row.style.display
          });
          row.style.display = "none";
        } else {
          break;
        }
      } while (row && row.nodeName !== 'BODY');
      if (!row) return false;

      // Restore hidden nodes
      for (var i = 0; i < hidden_nodes.length; i++) {
        hidden_nodes[i].element.style.display = hidden_nodes[i].display;
      }
      row = jQuery(row).closest('.calendar_plannerRowWidget');
      var row_widget = null;
      for (var i = 0; i < this._children.length && row.length > 0; i++) {
        if (this._children[i].div[0] == row[0]) {
          row_widget = this._children[i];
          break;
        }
      }
      if (row_widget) {
        // Not sure where the extra -1 and +2 are coming from, but it makes it work out
        // in FF & Chrome
        rel_x = Math.min((x - row_widget.rows.offset().left - 1) / (row_widget.rows.width() + 2), 1);

        // 2678400 is the number of seconds in 31 days
        rel_time = 2678400 * rel_x;
        date = this.date_helper(row_widget.options.start_date.toJSON());
      } else {
        return false;
      }
    }
    if (rel_time < 0) return false;
    date.setUTCMinutes(Math.round(rel_time / (60 * interval)) * interval);
    return date;
  }

  /**
   * Mousedown handler to support drag to create
   *
   * @param {jQuery.Event} event
   */
  _mouse_down(event) {
    // Only left mouse button
    if (event.which !== 1) {
      return;
    }

    // Skip for events
    if (event.target.closest(".calendar_calEvent")) {
      return;
    }

    // Ignore headers
    if (this.headers.has(event.target).length !== 0) {
      return false;
    }

    // Get time at mouse
    if (this.options.group_by === 'month') {
      var time = this._get_time_from_position(event.clientX, event.clientY);
    } else {
      var time = this._get_time_from_position(event.offsetX, event.offsetY);
    }
    if (!time) return false;

    // Find the correct row so we know the parent
    var row = event.target.closest('.calendar_plannerRowWidget');
    for (var i = 0; i < this._children.length && row; i++) {
      if (this._children[i].div[0] === row) {
        this.drag_create.parent = this._children[i];
        // Clear cached events for re-layout
        this._children[i]._cached_rows = [];
        break;
      }
    }
    if (!this.drag_create.parent) return false;
    this.drag_create.start = {
      date: time
    };
    this.div.css('cursor', 'ew-resize');
  }

  /**
   * Mouseup handler to support drag to create
   *
   * @param {jQuery.Event} event
   */
  _mouse_up(event) {
    // Get time at mouse
    if (this.options.group_by === 'month') {
      var time = this._get_time_from_position(event.clientX, event.clientY);
    } else {
      var time = this._get_time_from_position(event.offsetX, event.offsetY);
    }
    if (this.drag_create.end) {
      return this._drag_create_end(this.drag_create.end);
    } else if (this.drag_create.start) {
      // Not dragged enough to count, fake a click
      event.stopImmediatePropagation();
    }
    this._drag_create_end();
  }

  /**
   * Code for implementing et2_IDetachedDOM
   *
   * @param {array} _attrs array to add further attributes to
   */
  getDetachedAttributes(_attrs) {
    _attrs.push('start_date', 'end_date');
  }
  getDetachedNodes() {
    return [this.getDOMNode()];
  }
  setDetachedAttributes(_nodes, _values) {
    this.div = jQuery(_nodes[0]);
    if (_values.start_date) {
      this.set_start_date(_values.start_date);
    }
    if (_values.end_date) {
      this.set_end_date(_values.end_date);
    }
  }

  // Resizable interface
  resize() {
    // Take the whole tab height
    var height = Math.min(jQuery(this.getInstanceManager().DOMContainer).height(), jQuery(this.getInstanceManager().DOMContainer).parent().innerHeight());

    // Allow for toolbar
    height -= jQuery('#calendar-toolbar', this.div.parents('.egw_fw_ui_tab_content')).outerHeight(true);
    this.options.height = height;
    this.div.css('height', this.options.height);
    // Set height for rows
    this.rows.height(this.div.height() - this.headers.outerHeight());
    this.grid.height(this.rows[0].scrollHeight);
  }

  /**
   * Set up for printing
   *
   * @return {undefined|Deferred} Return a jQuery Deferred object if not done setting up
   *  (waiting for data)
   */
  beforePrint() {
    if (this.disabled || !this.div.is(':visible')) {
      return;
    }
    this.rows.css('overflow-y', 'visible');
    var rows = jQuery('.calendar_eventRows');
    var width = rows.width();
    var events = jQuery('.calendar_calEvent', rows).each(function () {
      var event = jQuery(this);
      event.width(event.width() / width * 100 + '%');
    });
  }

  /**
   * Reset after printing
   */
  afterPrint() {
    this.rows.css('overflow-y', 'auto');
  }
}
_defineProperty$2(et2_calendar_planner, "_attributes", {
  group_by: {
    name: "Group by",
    type: "string",
    // or category ID
    default: "0",
    description: "Display planner by 'user', 'month', or the given category"
  },
  filter: {
    name: "Filter",
    type: "string",
    default: '',
    description: 'A filter that is used to select events.  It is passed along when events are queried.'
  },
  show_weekend: {
    name: "Weekends",
    type: "boolean",
    default: egw$1.preference('days_in_weekview', 'calendar') != 5,
    description: "Display weekends.  The date range should still include them for proper scrolling, but they just won't be shown."
  },
  hide_empty: {
    name: "Hide empty rows",
    type: "boolean",
    default: false,
    description: "Hide rows with no events."
  },
  value: {
    type: "any",
    description: "A list of events, optionally you can set start_date, end_date and group_by as keys and events will be fetched"
  },
  "onchange": {
    "name": "onchange",
    "type": "js",
    "default": et2_no_init,
    "description": "JS code which is executed when the date range changes."
  },
  "onevent_change": {
    "name": "onevent_change",
    "type": "js",
    "default": et2_no_init,
    "description": "JS code which is executed when an event changes."
  }
});
_defineProperty$2(et2_calendar_planner, "DEFERRED_ROW_TIME", 100);
et2_register_widget(et2_calendar_planner, ["calendar-planner"]);

var es_string_padStart = {};

'use strict';
var $ = _export;
var $padStart = stringPad.start;
var WEBKIT_BUG = stringPadWebkitBug;

// `String.prototype.padStart` method
// https://tc39.es/ecma262/#sec-string.prototype.padstart
$({ target: 'String', proto: true, forced: WEBKIT_BUG }, {
  padStart: function padStart(maxLength /* , fillString = ' ' */) {
    return $padStart(this, maxLength, arguments.length > 1 ? arguments[1] : undefined);
  }
});

var _templateObject$1, _templateObject2$1;
function asyncGeneratorStep$1(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator$1(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep$1(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep$1(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function _taggedTemplateLiteral$1(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
class SidemenuDate extends Et2Date {
  static get styles() {
    return [...super.styles, i(_templateObject$1 || (_templateObject$1 = _taggedTemplateLiteral$1(["\n\t\t\t/** Hide input **/\n\t\t\t::slotted(input) {\n\t\t\t\tdisplay: none;\n\t\t\t}\n\t\t\t/** Special sizing for headers **/\n\t\t\t.flatpickr-months > * {\n\t\t\t\tpadding: 3px;\n\t\t\t\theight: 20px;\n\t\t\t}\n\t\t\t.flatpickr-current-month {\n\t\t\t\theight: 20px;\n\t\t\t\tfont-size: 110%\n\t\t\t}\n\t\t\tdiv.flatpickr-calendar.inline .flatpickr-current-month .flatpickr-monthDropdown-months {\n\t\t\t\twidth: 70%;\n\t\t\t}\n\t\t\t\n\t\t\tdiv.flatpickr-calendar.inline {\n\t\t\t\twidth: 100% !important;\n\t\t\t}\n\t\t\t\n\t\t\t/** Responsive resize is in etemplate2.css since we can't reach that far inside **/\n\t\t\t"])))];
  }
  constructor() {
    super();
    this._onDayCreate = this._onDayCreate.bind(this);
    this._handleChange = this._handleChange.bind(this);
    this._handleDayHover = this._handleDayHover.bind(this);
    this._clearHover = this._clearHover.bind(this);
    this._handleHeaderChange = this._handleHeaderChange.bind(this);
  }
  connectedCallback() {
    var _superprop_getConnectedCallback = () => super.connectedCallback,
      _this = this;
    return _asyncToGenerator$1(function* () {
      D(_this._inputTemplate(), _this);
      _superprop_getConnectedCallback().call(_this);
      _this.removeEventListener("change", _this._oldChange);
      _this.addEventListener("change", _this._handleChange);
    })();
  }
  disconnectedCallback() {
    super.disconnectedCallback();
    this.removeEventListener("change", this._handleChange);
    if (this._instance && this._instance.daysContainer !== undefined) {
      this._instance.weekNumbers.removeEventListener("mouseover", this._handleDayHover);
      this._instance.weekNumbers.removeEventListener("mouseout", this._clearHover);
    }
  }

  /**
   * Initialze flatpickr, and bind to any internal elements we're interested in
   *
   * Normal pre-creation config goes in this.getOptions()
   *
   * @returns {Promise<void>}
   */
  init() {
    var _superprop_getInit = () => super.init,
      _this2 = this;
    return _asyncToGenerator$1(function* () {
      var _this2$_instance;
      yield _superprop_getInit().call(_this2);

      // This needs to wait until after everything is created
      if (((_this2$_instance = _this2._instance) === null || _this2$_instance === void 0 ? void 0 : _this2$_instance.daysContainer) !== undefined) {
        _this2._instance.weekNumbers.addEventListener("mouseover", _this2._handleDayHover);
        _this2._instance.weekNumbers.addEventListener("mouseout", _this2._clearHover);
      }
    })();
  }

  /**
   * Override some flatpickr defaults to get things how we like it
   *
   * @see https://flatpickr.js.org/options/
   * @returns {any}
   */
  getOptions() {
    var options = super.getOptions();

    // No scroll - remove scroll plugin
    options.plugins = [];

    // Add "Ok" and "today" buttons back in, if desired
    var buttons = this._buttonPlugin();
    if (buttons) {
      options.plugins.push(buttons);
    }
    options.allowInput = false;
    options.inline = true;
    options.dateFormat = options.altFormat = "Y-m-dT00:00:00\\Z";
    options.onMonthChange = this._handleHeaderChange;
    options.onYearChange = this._handleHeaderChange;
    options.wrap = false;
    return options;
  }
  _buttonPlugin() {
    // No buttons
    return null;
  }

  /**
   * Override from parent - This is the node we tell flatpickr to use
   * It must be an <input>, flatpickr doesn't understand anything else
   * @returns {any}
   */
  findInputField() {
    return this._inputNode;
  }
  set_value(value) {
    if (typeof value === "string" && value.length == 8) {
      super.set_value(parseDate(value, "Ymd"));
    } else {
      super.set_value(value);
    }
  }

  /**
   * Handler for change events.  Re-bound to be able to cancel month changes, since it's an input and emits them
   *
   * @param dates
   * @param {string} dateString
   * @param instance
   * @protected
   */
  _handleChange(_ev) {
    if (_ev.target == this._instance.monthsDropdownContainer) {
      _ev.preventDefault();
      _ev.stopPropagation();
      return false;
    }
    var view_change = app$1.calendar.sidebox_changes_views.indexOf(app$1.calendar.state.view);
    var update = {
      date: this.getValue()
    };
    if (view_change >= 0) {
      update.view = app$1.calendar.sidebox_changes_views[view_change ? view_change - 1 : view_change];
    } else if (app$1.calendar.state.view == 'listview') {
      update.filter = 'after';
    } else if (app$1.calendar.state.view == 'planner') {
      update.planner_view = 'day';
    }
    app$1.calendar.update_state(update);
  }

  /**
   * Handle click on shortcut button(s) like "Today"
   *
   * @param button_index
   * @param fp Flatpickr instance
   */
  _handleShortcutButtonClick(button_index, fp) {
    // This just changes the calendar to today
    super._handleShortcutButtonClick(button_index, fp);
    var temp_date = new Date("" + this._instance.currentYear + "-" + (this._instance.currentMonth + 1) + "-" + (this._instance.selectedDates[0].getDate() || "01"));

    // Go directly
    var update = {
      date: temp_date
    };
    app$1.calendar.update_state(update);
  }
  _handleClick(_ev) {
    //@ts-ignore
    if (this._instance.weekNumbers.contains(_ev.target)) {
      return this._handleWeekClick(_ev);
    }
    return super._handleClick(_ev);
  }

  /**
   * Handle clicking on the week number
   *
   * @param {MouseEvent} _ev
   * @returns {boolean}
   */
  _handleWeekClick(_ev) {
    var view = app$1.calendar.state.view;
    var days = app$1.calendar.state.days;
    var fp = this._instance;

    // Avoid a full state update, we just want the calendar to update
    // Directly update to avoid change event from the sidebox calendar

    var week_index = Array.prototype.indexOf.call(fp.weekNumbers.children, _ev.target);
    if (week_index == -1) {
      return false;
    }
    var weekStartDay = fp.days.childNodes[7 * week_index].dateObj;
    fp.setDate(weekStartDay);
    var date = new Date(weekStartDay);
    date.setUTCMinutes(date.getUTCMinutes() - date.getTimezoneOffset());
    date = app$1.calendar.date.toString(date);

    // Set to week view, if in one of the views where we change view
    if (app$1.calendar.sidebox_changes_views.indexOf(view) >= 0) {
      app$1.calendar.update_state({
        view: 'week',
        date: date,
        days: days
      });
    } else if (view == 'planner') {
      // Clicked a week, show just a week
      app$1.calendar.update_state({
        date: date,
        planner_view: 'week'
      });
    } else if (view == 'listview') {
      app$1.calendar.update_state({
        date: date,
        end_date: app$1.calendar.date.toString(CalendarApp.views.week.end_date({
          date: date
        })),
        filter: 'week'
      });
    } else {
      app$1.calendar.update_state({
        date: date
      });
    }
    return true;
  }

  /**
   * Handle a hover over a day
   * @param {MouseEvent} _ev
   * @returns {boolean}
   */
  _handleDayHover(_ev) {
    if (this._instance.weekNumbers.contains(_ev.target)) {
      return this._highlightWeek(_ev.target);
    }
  }

  /**
   * Highlight a week based on the given week number HTMLElement
   */
  _highlightWeek(weekElement) {
    var fp = this._instance;
    var week_index = Array.prototype.indexOf.call(fp.weekNumbers.children, weekElement);
    if (week_index == -1) {
      return false;
    }
    fp.weekStartDay = fp.days.childNodes[7 * week_index].dateObj;
    fp.weekEndDay = fp.days.childNodes[7 * (week_index + 1) - 1].dateObj;
    var days = fp.days.childNodes;
    for (var i = days.length; i--;) {
      var date = days[i].dateObj;
      if (date >= fp.weekStartDay && date <= fp.weekEndDay) {
        days[i].classList.add("inRange");
      } else {
        days[i].classList.remove("inRange");
      }
    }
  }
  _clearHover() {
    var days = this._instance.days.childNodes;
    for (var i = days.length; i--;) days[i].classList.remove("inRange");
  }
  get _headerNode() {
    var _this$_instance;
    return (_this$_instance = this._instance) === null || _this$_instance === void 0 ? void 0 : _this$_instance.monthNav;
  }

  /**
   * Year or month changed
   *
   * @protected
   */
  _handleHeaderChange(selectedDates, value) {
    var update = {};
    if (this.formatDate(selectedDates[0], this._instance.config.dateFormat) == value) {
      // Header changed, selected date did not - get a date in the new month

      var maxDays = new Date(this._instance.currentYear, this._instance.currentMonth + 1, 0).getDate();
      var temp_date = new Date("" + this._instance.currentYear + "-" + (this._instance.currentMonth + 1) + "-" + ("" + Math.min(maxDays, new Date(this.value).getUTCDate())).padStart(2, "0"));
      temp_date.setUTCMinutes(temp_date.getUTCMinutes() + temp_date.getTimezoneOffset());
      update['date'] = temp_date;
    } else {
      // User selected a date in a different month, header hasn't changed
      update['date'] = value;
    }
    // Go directly
    app$1.calendar.update_state(update);
  }

  /**
   * The interactive (form) element.
   * @protected
   */
  get _inputNode() {
    return this.querySelector('input');
  }
  _inputTemplate() {
    // Plain input
    return x(_templateObject2$1 || (_templateObject2$1 = _taggedTemplateLiteral$1(["\n            <input type=\"text\" style=\"display: none\"></input>"])));
  }
}
customElements.define("calendar-date", SidemenuDate);

var _templateObject, _templateObject2, _templateObject3, _templateObject4, _templateObject5;
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty$1(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty$1(e, r, t) { return (r = _toPropertyKey$1(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$1(t) { var i = _toPrimitive$1(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$1(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _taggedTemplateLiteral(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }

/**
 * Select widget customised for calendar owner, which can be a user
 * account or group, or an entry from almost any app, or an email address
 *
 */
class CalendarOwner extends Et2StaticSelectMixin(Et2Select) {
  static get styles() {
    return [...super.styles, i(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n\t\t\t\t/* Larger maximum height before scroll*/\n\n\t\t\t\t.select__tags {\n\t\t\t\t\tmax-height: 10em;\n\t\t\t\t}\n\n\t\t\t\t.title {\n\t\t\t\t\tfloat: right;\n\t\t\t\t}\n\n\t\t\t\t/* Hide unwanted vertical scrollbars with 1 row of tags */\n\n\t\t\t\t::part(tag) {\n\t\t\t\t\toverflow: hidden;\n\t\t\t\t}\n\t\t\t"])))];
  }
  constructor() {
    super(...arguments);
    this.searchUrl = "calendar_owner_etemplate_widget::ajax_search";
    this.multiple = true;

    // Take grants into account for search
    this.searchOptions['checkgrants'] = true;
  }

  /**
   * Some [part of a] value is missing from the available options, but should be there, so find and add it.
   *
   * This is used when not all options are sent to the client (search, link list).  Ideally we want to send
   * the options for the current value, but sometimes this is not the best option so here we search or create
   * the option as needed.  These are not free entries, but need to match some list somewhere.
   *
   * @param {string} newValueElement
   * @protected
   */
  _missingOption(newValueElement) {
    // Call ajax_owner
    return this.egw().request(this.egw().link(this.egw().ajaxUrl(this.egw().decodePath("calendar_owner_etemplate_widget::ajax_owner"))), [newValueElement]).then(results => {
      return this._processResultCount([{
        value: newValueElement,
        label: results
      }]);
    });
  }
  /**
   * Override parent to show email address in options
   *
   * We use this in edit dialog, but the same widget is used in sidemenu where the email is hidden via CSS.
   * Anything set in "title" will be shown
   *
   * @param {SelectOption} option
   * @returns {TemplateResult}
   */
  _optionTemplate(option) {
    // Exclude non-matches when searching
    // unless they're already selected, in which case removing them removes them from value
    if (typeof option.isMatch == "boolean" && !option.isMatch && !this.getValueAsArray().includes(option.value)) {
      return x(_templateObject2 || (_templateObject2 = _taggedTemplateLiteral([""])));
    }
    var value = option.value.replaceAll(" ", "___");
    var classes = option.class ? Object.fromEntries(option.class.split(" ").map(k => [k, true])) : {};
    return x(_templateObject3 || (_templateObject3 = _taggedTemplateLiteral(["\n            <sl-option\n                    part=\"option\"\n                    exportparts=\"prefix:tag__prefix, suffix:tag__suffix, image\"\n                    value=\"", "\"\n                    title=\"", "\"\n                    class=", "\n                    .option=", "\n                    .selected=", "\n                    ?disabled=", "\n                    .getTextLabel=", "\n            >\n                ", "\n                ", "\n                <span class=\"title\">", "</span>\n            </sl-option>"])), value, !option.title || this.noLang ? option.title : this.egw().lang(option.title), o(_objectSpread({
      "match": option.isMatch,
      "no-match": !option.isMatch
    }, classes)), option, this.getValueAsArray().some(v => v == value), option.disabled, () => {
      var _option$label;
      return (_option$label = option.label) !== null && _option$label !== void 0 ? _option$label : option.value;
    }, this._iconTemplate(option), this.noLang ? option.label : this.egw().lang(option.label), option.title);
  }

  /**
   * Override parent to handle our special additional data types (c#,r#,etc.) when they
   * are not available client side.
   *
   * @param {string|string[]} _value array of selected owners, which can be a number,
   *	or a number prefixed with one character indicating the resource type.
   */
  set_value(_value) {
    super.set_value(_value);

    // If parent didn't find a label, label will be the same as ID so we
    // can find them that way
    var missing_labels = [];
    this.updateComplete.then(() => {
      // find that can handle option groups
      var i;
      var find = option => {
        if (Array.isArray(option.value)) {
          return option.value.find(find);
        }
        return option.value == this.getValueAsArray()[i];
      };
      for (i = 0; i < this.getValueAsArray().length; i++) {
        if (!this.select_options.find(find)) {
          missing_labels.push(this.getValueAsArray()[i]);
        }
      }
      if (Object.keys(missing_labels).length > 0) {
        // Proper label was not found by parent - ask directly
        this.egw().json('calendar_owner_etemplate_widget::ajax_owner', [missing_labels], function (data) {
          var _this = this;
          var _loop = function _loop(owner) {
            if (!owner || typeof owner == "undefined") {
              return 1; // continue
            }
            // Put it in the list of options
            var index = _this.select_options.findIndex(o => o.value == owner);
            var remote_index = _this._selected_remote.findIndex(o => o.value == owner);
            if (remote_index !== -1) {
              _this._selected_remote[remote_index] = data[owner];
            } else if (index == -1) {
              _this._selected_remote.push(data[owner]);
            } else if (index !== -1 && typeof data[owner].resources !== "undefined" && !_this.select_options[index].resources) {
              _this.select_options[index].resources = data[owner].resources;
            }
          };
          for (var owner in data) {
            if (_loop(owner)) continue;
          }
          this.requestUpdate("select_options");
        }, this, true, this).sendRequest();
      }
    });
  }

  /**
   * Check a value for missing options and remove them.
   *
   * Override to allow any value, since we won't have all options
   *
   * @param {string[]} value
   * @returns {string[]}
   */
  filterOutMissingOptions(value) {
    return value;
  }

  /**
   * Override icon for the select option to use lavatar
   *
   * @param option
   * @protected
   */
  _iconTemplate(option) {
    // Not a user / contact, no icon - use app image
    if (!option.fname && !option.lname && !option.icon && option.app) {
      return x(_templateObject4 || (_templateObject4 = _taggedTemplateLiteral(["\n                <et2-image src=\"", "/navbar\" style=\"width: var(--icon-width); display: inline-block\"></et2-image>"])), option.app);
    }
    // lavatar uses a size property, not a CSS variable
    var style = getComputedStyle(this);
    return x(_templateObject5 || (_templateObject5 = _taggedTemplateLiteral(["\n            <et2-lavatar slot=\"prefix\" part=\"icon\" exportparts=\"image\" .size=", "\n                         lname=", "\n                         fname=", "\n                         image=", "\n            >\n            </et2-lavatar>"])), style.getPropertyValue("--icon-width"), option.lname || A, option.fname || A, option.icon || A);
  }

  /**
   * Check if a free entry value is acceptable.
   * We only check the free entry, since value can be mixed.
   *
   * @param text
   * @returns {boolean}
   */
  validateFreeEntry(text) {
    var validators = [...this.validators, new IsEmail()];
    var result = validators.filter(v => v.execute(text, v.param, {
      node: this
    }));
    return result.length == 0;
  }
}
if (!customElements.get("et2-calendar-owner")) {
  customElements.define("et2-calendar-owner", CalendarOwner);
}

function asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * UI for calendar
 *
 * Calendar has multiple different views of the same data.  All the templates
 * for the different view are loaded at the start, then the view objects
 * in CalendarApp.views are used to manage the different views.
 * update_state() is used to change the state between the different views, as
 * well as adjust only a single part of the state while keeping the rest unchanged.
 *
 * The event widgets (and the nextmatch) get the data from egw.data, and they
 * register update callbacks to automatically update when the data changes.  This
 * means that when we update something on the server, to update the UI we just need
 * to send back the new data and if the event widget still exists it will update
 * itself.  See calendar_uiforms->ajax_status().
 *
 * To reduce server calls, we also keep a map of day => event IDs.  This allows
 * us to quickly change views (week to day, for example) without requesting additional
 * data from the server.  We keep that map as long as only the date (and a few
 * others - see update_state()) changes.  If user or any of the other filters are
 * changed, we discard the daywise cache and ask the server for the filtered events.
 *
 */
class CalendarApp extends EgwApp {
  /**
   * Constructor
   *
   */
  constructor() {
    /*
    // categories have nothing to do with calendar, but eT2 objects loads calendars app.js
    if (window.framework && framework.applications.calendar.browser &&
    	framework.applications.calendar.browser.currentLocation.match('menuaction=preferences\.preferences_categories_ui\.index'))
    {
    	this._super.apply(this, arguments);
    	return;
    }
    else// make calendar object available, even if not running in top window, as sidebox does
    if (window.top !== window && !egw(window).is_popup() && window.top.app.calendar)
    {
    	window.app.calendar = window.top.app.calendar;
    	return;
    }
    else if (window.top == window && !egw(window).is_popup())
    {
    	// Show loading div
    	egw.loading_prompt(
    		this.appname,true,egw.lang('please wait...'),
    		typeof framework !== 'undefined' ? framework.applications.calendar.tab.contentDiv : false,
    		egwIsMobile()?'horizental':'spinner'
    	);
    }
    */
    // call parent
    super('calendar');

    // Scroll
    /**
     * Needed for JSON callback
     */
    _defineProperty(this, "prefix", 'calendar');
    /**
     * etemplate for the sidebox filters
     */
    _defineProperty(this, "sidebox_et2", null);
    /**
     * Current internal state
     *
     * If you need to change state, you can pass just the fields to change to
     * update_state().
     */
    _defineProperty(this, "state", {
      date: new Date(),
      view: egw$1.preference('saved_states', 'calendar') ?
      // @ts-ignore
      egw$1.preference('saved_states', 'calendar').view : egw$1.preference('defaultcalendar', 'calendar') || 'day',
      owner: egw$1.user('account_id'),
      keywords: '',
      last: undefined,
      first: undefined,
      include_videocalls: false
    });
    // If you are in one of these views and select a date in the sidebox, the view
    // will change as needed to show the date.  Other views will only change the
    // date in the current view.
    _defineProperty(this, "sidebox_changes_views", ['day', 'week', 'month']);
    // Calendar allows other apps to hook into the sidebox.  We keep these etemplates
    // up to date as state is changed.
    _defineProperty(this, "sidebox_hooked_templates", []);
    // List of queries in progress, to prevent home from requesting the same thing
    _defineProperty(this, "_queries_in_progress", []);
    // Calendar-wide autorefresh
    _defineProperty(this, "_autorefresh_timer", null);
    // Flag if the state is being updated
    _defineProperty(this, "state_update_in_progress", false);
    // Data for quick add dialog
    _defineProperty(this, "quick_add", void 0);
    //
    _defineProperty(this, "_grants", void 0);
    _defineProperty(this, "_group_query_cache", {});
    /**
     * Some handy date calculations
     * All take either a Date object or full date with timestamp (Z)
     */
    _defineProperty(this, "date", {
      toString: function toString(date) {
        // Ensure consistent formatting using UTC, avoids problems with comparison
        // and timezones
        if (typeof date === 'string') date = new Date(date);
        return date.getUTCFullYear() + '-' + sprintf("%02d", date.getUTCMonth() + 1) + '-' + sprintf("%02d", date.getUTCDate()) + 'T' + sprintf("%02d", date.getUTCHours()) + ':' + sprintf("%02d", date.getUTCMinutes()) + ':' + sprintf("%02d", date.getUTCSeconds()) + 'Z';
      },
      /**
      * Formats one or two dates (range) as long date (full monthname), optionaly with a time
      *
      * Take care of any timezone issues before you pass the dates in.
      *
      * @param {Date} first first date
      * @param {Date} last =0 last date for range, or false for a single date
      * @param {boolean} display_time =false should a time be displayed too
      * @param {boolean} display_day =false should a day-name prefix the date, eg. monday June 20, 2006
      * @return string with formatted date
      */
      long_date: function long_date(first, last, display_time, display_day) {
        if (!first) return '';
        if (typeof first === 'string') {
          first = new Date(first);
        }
        var first_format = new Date(first.valueOf() + first.getTimezoneOffset() * 60 * 1000);
        if (typeof last == 'string' && last) {
          last = new Date(last);
        }
        if (!last || typeof last !== 'object') {
          last = false;
        }
        if (last) {
          var last_format = new Date(last.valueOf() + last.getTimezoneOffset() * 60 * 1000);
        }
        if (!display_time) {
          display_time = false;
        }
        if (!display_day) {
          display_day = false;
        }
        var range = '';
        var datefmt = egw$1.preference('dateformat');
        var timefmt = egw$1.preference('timeformat') === '12' ? 'h:i a' : 'H:i';
        var month_before_day = datefmt[0].toLowerCase() == 'm' || datefmt[2].toLowerCase() == 'm' && datefmt[4] == 'd';
        if (display_day) {
          range = flatpickr.formatDate(first_format, 'l') + (datefmt[0] != 'd' ? ' ' : ', ');
        }
        for (var i = 0; i < 5; i += 2) {
          switch (datefmt[i]) {
            case 'd':
              range += first.getUTCDate() + (datefmt[1] == '.' ? '.' : '');
              if (last && (first.getUTCMonth() != last.getUTCMonth() || first.getUTCFullYear() != last.getUTCFullYear())) {
                if (!month_before_day) {
                  range += " " + egw$1.lang(flatpickr.formatDate(first_format, "F"));
                }
                if (first.getFullYear() != last.getFullYear() && datefmt[0] != 'Y') {
                  range += (datefmt[0] != 'd' ? ', ' : ' ') + first.getFullYear();
                }
                if (display_time) {
                  range += ' ' + formatTime(first_format);
                }
                if (!last) {
                  return range;
                }
                range += ' - ';
                if (first.getFullYear() != last.getFullYear() && datefmt[0] == 'Y') {
                  range += last.getUTCFullYear() + ', ';
                }
                if (month_before_day) {
                  range += egw$1.lang(flatpickr.formatDate(last_format, 'l'));
                }
              } else if (last) {
                if (display_time) {
                  range += ' ' + formatTime(last_format);
                }
                if (last) {
                  range += ' - ';
                }
              }
              if (last) {
                range += ' ' + last.getUTCDate() + (datefmt[1] == '.' ? '.' : '');
              }
              break;
            case 'm':
            case 'M':
              range += ' ' + egw$1.lang(flatpickr.formatDate(month_before_day || !last ? first_format : last_format, "F")) + ' ';
              break;
            case 'Y':
              if (datefmt[0] != 'm') {
                range += ' ' + (datefmt[0] == 'Y' ? first.getUTCFullYear() + (datefmt[2] == 'd' ? ', ' : ' ') : last.getUTCFullYear() + ' ');
              }
              break;
          }
        }
        if (display_time && last) {
          range += ' ' + formatTime(last_format);
        }
        if (datefmt[4] == 'Y' && datefmt[0] == 'm') {
          range += ', ' + last.getUTCFullYear();
        }
        return range;
      },
      /**
      * Calculate iso8601 week-number, which is defined for Monday as first day of week only
      *
      * We adjust the day, if user prefs want a different week-start-day
      *
      * @param {string|Date} _date
      * @return string
      */
      week_number: function week_number(_date) {
        var d = new Date(_date);
        var day = d.getUTCDay();

        // if week does not start Monday and date is Sunday --> add one day
        if (egw$1.preference('weekdaystarts', 'calendar') != 'Monday' && !day) {
          d.setUTCDate(d.getUTCDate() + 1);
        }
        // if week does start Saturday and $time is Saturday --> add two days
        else if (egw$1.preference('weekdaystarts', 'calendar') == 'Saturday' && day == 6) {
          d.setUTCDate(d.getUTCDate() + 2);
        }
        return flatpickr.formatDate(new Date(d.valueOf() + d.getTimezoneOffset() * 60 * 1000), "W");
      },
      start_of_week: function start_of_week(date) {
        var d = new Date(date);
        var day = d.getUTCDay();
        var diff = 0;
        switch (egw$1.preference('weekdaystarts', 'calendar')) {
          case 'Saturday':
            diff = day === 6 ? 0 : day === 0 ? -1 : -(day + 1);
            break;
          case 'Monday':
            diff = day === 0 ? -6 : 1 - day;
            break;
          case 'Sunday':
          default:
            diff = -day;
        }
        d.setUTCDate(d.getUTCDate() + diff);
        return d;
      },
      end_of_week: function end_of_week(date) {
        var d = this.start_of_week(date);
        d.setUTCDate(d.getUTCDate() + 6);
        return d;
      }
    });
    jQuery(jQuery.proxy(this._scroll, this));
    jQuery.extend(this.state, this.egw.preference('saved_states', 'calendar'));

    // Set custom color for events without category
    if (this.egw.preference('no_category_custom_color', 'calendar')) {
      this.egw.css('.calendar_calEvent:not([class*="cat_"])', 'background-color: ' + this.egw.preference('no_category_custom_color', 'calendar') + ' !important');
    }
  }

  /**
   * Destructor
   */
  destroy() {
    // call parent
    super.destroy(this.appname);

    // remove top window reference
    // @ts-ignore
    if (window.top !== window && window.top.app.calendar === this) {
      // @ts-ignore
      delete window.top.app.calendar;
    }
    jQuery('body').off('.calendar');
    if (this.sidebox_et2) {
      var date = this.sidebox_et2.getWidgetById('date');
      jQuery(window).off('resize.calendar' + date.dom_id);
    }
    this.sidebox_hooked_templates = [];
    egw_unregisterGlobalShortcut(EGW_KEY_PAGE_UP, false, false, false);
    egw_unregisterGlobalShortcut(EGW_KEY_PAGE_DOWN, false, false, false);

    // Stop autorefresh
    if (this._autorefresh_timer) {
      window.clearInterval(this._autorefresh_timer);
      this._autorefresh_timer = null;
    }
  }

  /**
   * This function is called when the etemplate2 object is loaded
   * and ready.  If you must store a reference to the et2 object,
   * make sure to clean it up in destroy().
   *
   * @param {etemplate2} _et2 newly ready et2 object
   * @param {string} _name name of template
   */
  et2_ready(_et2, _name) {
    // call parent
    super.et2_ready(_et2, _name);

    // Avoid many problems with home
    if (_et2.app !== 'calendar' || _name == 'admin.categories.index') {
      egw$1.loading_prompt(this.appname, false);
      return;
    }

    // Re-init sidebox, since it was probably initialized too soon
    var sidebox = jQuery('#favorite_sidebox_' + this.appname);
    if (sidebox.length == 0 && egw_getFramework() != null) {
      // Force rollup to load owner widget, it leaves it out otherwise
      new CalendarOwner();
      // Force rollup to load planner widget, it leaves it out otherwise
      new et2_calendar_planner(_et2.widgetContainer, {});
      var egw_fw = egw_getFramework();
      sidebox = jQuery('#favorite_sidebox_' + this.appname, egw_fw.sidemenuDiv);
    }
    var content = this.et2.getArrayMgr('content');
    switch (_name) {
      case 'calendar.sidebox':
        this.sidebox_et2 = _et2.widgetContainer;
        this.sidebox_hooked_templates.push(this.sidebox_et2);
        if (!_et2.DOMContainer.slot) {
          jQuery(_et2.DOMContainer).hide();
        }
        this._setup_sidebox_filters();
        this.state = content.data;
        if (typeof this.state.date == "string" && this.state.date.length == 8) {
          this.state.date = parseDate(this.state.date, "Ymd");
        }
        break;
      case 'calendar.add':
        this.et2.getWidgetById('title').focus();
      // Fall through to get all the edit stuff too
      case 'calendar.edit':
        if (typeof content.data['conflicts'] == 'undefined') {
          //Check if it's fallback from conflict window or it's from edit window
          if (content.data['button_was'] != 'freetime') {
            this.set_enddate_visibility();
            this.check_recur_type();
            this.edit_start_change(null, this.et2.getWidgetById('start'));
            if (this.et2.getWidgetById('recur_exception')) {
              this.et2.getWidgetById('recur_exception').set_disabled(!content.data.recur_exception || typeof content.data.recur_exception[0] == 'undefined');
            }
          } else {
            this.freetime_search();
          }
          //send synchronous ajax request to the server to unlock the on close entry
          //set onbeforeunload with json request to send request when the window gets close by X button
          if (content.data.lock_token) {
            window.addEventListener("beforeunload", this._unlock.bind(this));
          }
        }
        this.alarm_custom_date();

        // If title is pre-filled for a new (no ID) event, highlight it
        if (content.data && !content.data.id && content.data.title) {
          this.et2.getWidgetById('title').focus();
        }

        // Disable loading prompt (if loaded nopopup)
        egw$1.loading_prompt(this.appname, false);
        break;
      case 'calendar.freetimesearch':
        this.set_enddate_visibility();
        break;
      case 'calendar.list':
        // Wait until _et2_view_init is done
        window.setTimeout(jQuery.proxy(function () {
          this.filter_change();
        }, this), 0);
        break;
      case 'calendar.category_report':
        this.category_report_init();
        break;
    }

    // Record the templates for the views so we can switch between them
    this._et2_view_init(_et2, _name);
  }

  /**
   * Observer method receives update notifications from all applications
   *
   * App is responsible for only reacting to "messages" it is interested in!
   *
   * Calendar binds listeners to the data cache, so if the data is updated, the widget
   * will automatically update itself.
   *
   * @param {string} _msg message (already translated) to show, eg. 'Entry deleted'
   * @param {string} _app application name
   * @param {(string|number)} _id id of entry to refresh or null
   * @param {string} _type either 'update', 'edit', 'delete', 'add' or null
   * - update: request just modified data from given rows.  Sorting is not considered,
   *		so if the sort field is changed, the row will not be moved.
   * - edit: rows changed, but sorting may be affected.  Requires full reload.
   * - delete: just delete the given rows clientside (no server interaction neccessary)
   * - add: requires full reload for proper sorting
   * @param {string} _msg_type 'error', 'warning' or 'success' (default)
   * @param {object|null} _links app => array of ids of linked entries
   * or null, if not triggered on server-side, which adds that info
   * @return {false|*} false to stop regular refresh, thought all observers are run
   */
  observer(_msg, _app, _id, _type, _msg_type, _links) {
    var do_refresh = false;
    if (this.state.view === 'listview') {
      // @ts-ignore
      CalendarApp.views.listview.etemplates[0].widgetContainer.getWidgetById('nm').refresh(_id, _type);
    }
    switch (_app) {
      case 'infolog':
        jQuery('.calendar_calDayTodos').find('a').each(function (i, a) {
          var match = a.href.split(/&info_id=/);
          if (match && typeof match[1] != "undefined") {
            if (match[1] == _id) do_refresh = true;
          }
        });

        // Unfortunately we do not know what type this infolog is here,
        // but we can tell if it's turned off entirely
        if (egw$1.preference('calendar_integration', 'infolog') !== '0') {
          if (jQuery('div [data-app="infolog"][data-app_id="' + _id + '"]').length > 0) do_refresh = true;
          switch (_type) {
            case 'add':
              do_refresh = true;
              break;
          }
        }
        if (do_refresh) {
          // Discard cache
          this._clear_cache();

          // Calendar is the current application, refresh now
          if (framework.activeApp.appName === this.appname) {
            this.setState({
              state: this.state
            });
          }
          // Bind once to trigger a refresh when tab is activated again
          else if (framework.applications.calendar && framework.applications.calendar.tab && framework.applications.calendar.tab.contentDiv) {
            jQuery(framework.applications.calendar.tab.contentDiv).off('show.calendar').one('show.calendar', jQuery.proxy(function () {
              this.setState({
                state: this.state
              });
            }, this));
          }
        }
        break;
      case 'calendar':
        // Regular refresh
        var event = null;
        if (_id) {
          event = egw$1.dataGetUIDdata('calendar::' + _id);
        }
        if (event && event.data && event.data.date || _type === 'delete') {
          // Intelligent refresh without reloading everything
          var recurrences = Object.keys(egw$1.dataSearchUIDs(new RegExp('^calendar::' + _id + ':')));
          var ids = event && event.data && event.data.recur_type && typeof _id === 'string' && _id.indexOf(':') < 0 || recurrences.length ? recurrences : ['calendar::' + _id];
          if (_type === 'delete') {
            for (var i in ids) {
              egw$1.dataStoreUID(ids[i], null);
            }
          }
          // Updates are handled by events themselves through egw.data
          else if (_type !== 'update') {
            this._update_events(this.state, ids);
          }
          return false;
        } else {
          this._clear_cache();

          // Force redraw to current state
          this.setState({
            state: this.state
          });
          return false;
        }
        break;
      default:
        return undefined;
    }
  }
  /**
   * Handle a push notification about entry changes from the websocket
   *
   * @param  pushData
   * @param {string} pushData.app application name
   * @param {(string|number)} pushData.id id of entry to refresh or null
   * @param {string} pushData.type either 'update', 'edit', 'delete', 'add' or null
   * - update: request just modified data from given rows.  Sorting is not considered,
   *		so if the sort field is changed, the row will not be moved.
   * - edit: rows changed, but sorting may be affected.  Requires full reload.
   * - delete: just delete the given rows clientside (no server interaction neccessary)
   * - add: ask server for data, add in intelligently
   * @param {object|null} pushData.acl Extra data for determining relevance.  eg: owner or responsible to decide if update is necessary
   * @param {number} pushData.account_id User that caused the notification
   */
  push(pushData) {
    switch (pushData.app) {
      case "calendar":
        if (pushData.type === 'delete') {
          return super.push(pushData);
        }
        return this.push_calendar(pushData);
      default:
        if (jQuery.extend([], egw$1.preference("integration_toggle", "calendar")).indexOf(pushData.app) >= 0) {
          if (pushData.app == "infolog") {
            return this.push_infolog(pushData);
          } else {
            // Modify the pushData so it looks like one of ours
            var integrated_pushData = jQuery.extend(pushData, {
              id: pushData.app + pushData.id,
              app: this.appname
            });
            if (integrated_pushData.type == "delete" || egw$1.dataHasUID(this.uid(integrated_pushData))) {
              // Super always looks at this.et2, make sure it finds listview
              var old_et2 = this.et2;
              this.et2 = CalendarApp.views.listview.etemplates[0].widgetContainer;
              super.push(integrated_pushData);
              this.et2 = old_et2;
            }
            // Ask for the real data, we don't have it.  This also updates views that don't use nextmatch.
            this._fetch_data(this.state, undefined, 0, [integrated_pushData.id]);
          }
        }
    }
  }

  /**
   * Handle a push about infolog
   *
   * @param pushData
   */
  push_infolog(pushData) {
    // Check if we have access
    if (!this._push_grant_check(pushData, ["info_owner", "info_responsible"], "infolog")) {
      return;
    }

    // check visibility - grants is ID => permission of people we're allowed to see
    var infolog_grants = egw$1.grants(pushData.app);

    // Filter what's allowed down to those we care about
    var filtered = Object.keys(infolog_grants).filter(account => this.state.owner.indexOf(account) >= 0);
    var owner_check = filtered.filter(function (value) {
      return pushData.acl.info_owner == value || pushData.acl.info_responsible.indexOf(value) >= 0;
    });
    if (!owner_check || owner_check.length == 0) {
      // The owner is not in the list of what we care about
      return;
    }

    // Only need to update the list if we're on that view
    var update_list = this.state.view == "day";

    // Delete, just pull it out of the list
    if (update_list && pushData.type == "delete") {
      jQuery('.calendar_calDayTodos').find('a').each(function (i, a) {
        var match = a.href.split(/&info_id=/);
        if (match && typeof match[1] != "undefined" && match[1] == pushData.id) {
          jQuery(a).parentsUntil("tbody").remove();
        }
      });
    }

    // Refresh todos if we're there - add, update or edit doesn't matter
    if (update_list) {
      this.egw.jsonq('calendar_uiviews::ajax_get_todos', [this.state.date, this.state.owner[0]], function (data) {
        this.getWidgetById('label').set_value(data.label || '');
        this.getWidgetById('todos').set_value({
          content: data.todos || ''
        });
      }, CalendarApp.views.day.etemplates[1].widgetContainer);
    } else {
      var _egw$preference;
      // Only care about certain infolog types, or already loaded (type may have changed)
      var types = ((_egw$preference = egw$1.preference('calendar_integration', 'infolog')) === null || _egw$preference === void 0 ? void 0 : _egw$preference.split(",")) || [];
      var info_uid = this.appname + "::" + pushData.app + pushData.id;
      if (types.indexOf(pushData.acl.info_type) >= 0 || this.egw.dataHasUID(info_uid)) {
        if (pushData.type === 'delete') {
          return this.egw.dataStoreUID(info_uid, null);
        }

        // Calendar is the current application, refresh now
        if (framework.activeApp.appName === this.appname) {
          this._fetch_data(this.state, undefined, 0, [pushData.app + pushData.id]);
        }
        // Bind once to trigger a refresh when tab is activated again
        else if (framework.applications.calendar && framework.applications.calendar.tab && framework.applications.calendar.tab.contentDiv) {
          jQuery(framework.applications.calendar.tab.contentDiv).off('show.calendar').one('show.calendar', function () {
            this.setState({
              state: this.state
            });
          }.bind(this));
        }
      }
    }
  }

  /**
   * Handle a push from calendar
   *
   * @param pushData
   */
  push_calendar(pushData) {
    // pushData does not contain everything, just the minimum.  See calendar_hooks::search_link().
    var cal_event = pushData.acl || {};

    // check visibility - grants is ID => permission of people we're allowed to see
    var owners = [];
    if (typeof this._grants === 'undefined') {
      this._grants = egw$1.grants(this.appname);
    }
    // Filter what's allowed down to those we care about
    var filtered = Object.keys(this._grants).filter(account => this.state.owner.indexOf(account) >= 0);

    // Check if we're interested in displaying by owner / participant
    var owner_check = et2_calendar_event.owner_check(cal_event,
    // Fake the required widget since we don't actually have it right now
    jQuery.extend({}, {
      options: {
        owner: filtered
      }
    }, this.et2));
    if (!owner_check) {
      // The owner is not in the list of what we're allowed / care about
      return;
    }

    // Check if we're interested by date?
    if (cal_event.end <= new Date(this.state.first).valueOf() / 1000 || cal_event.start > new Date(this.state.last).valueOf() / 1000) {
      // The event is outside our current view, but check if it's just one of a recurring event
      if (!cal_event.range_end && !cal_event.range_start || cal_event.range_end <= new Date(this.state.first).valueOf() / 1000 || cal_event.range_start > new Date(this.state.last).valueOf() / 1000) {
        return;
      }
    }

    // Do we already have "fresh" data?  Most user actions give fresh data in response
    var existing = egw$1.dataGetUIDdata('calendar::' + pushData.id);
    if (existing && Math.abs(existing.timestamp - new Date().valueOf()) < 1000) {
      // Update directly
      this._update_events(this.state, ['calendar::' + pushData.id]);
      return;
    }

    // Ask for the real data, we don't have it
    var process_data = data => {
      // Store it, which will call all registered listeners
      egw$1.dataStoreUID(data.uid, data.data);

      // Any existing events were updated.  Run this to catch new events or events moved into view
      this._update_events(this.state, [data.uid]);
    };
    egw$1.jsonq("calendar.calendar_ui.ajax_get", [[pushData.id]]).then(data => {
      if (typeof data.uid !== "undefined") {
        return process_data(data);
      }
      for (var e of data) {
        process_data(e);
      }
    });
  }

  /**
   * Link hander for jDots template to just reload our iframe, instead of reloading whole admin app
   *
   * @param {String} _url
   * @return {boolean|string} true, if linkHandler took care of link, false for default processing or url to navigate to
   */
  linkHandler(_url) {
    if (_url == 'about:blank' || _url.match('menuaction=preferences\.preferences_categories_ui\.index')) {
      return false;
    }
    if (_url.match('menuaction=calendar\.calendar_uiviews\.')) {
      var view = _url.match(/calendar_uiviews\.([^&?]+)/);
      view = view && view.length > 1 ? view[1] : null;

      // Get query
      var q = {};
      _url.split('?')[1].split('&').forEach(function (i) {
        q[i.split('=')[0]] = unescape(i.split('=')[1]);
      });
      delete q.ajax;
      delete q.menuaction;
      if (!view && q.view || q.view != view && view == 'index') view = q.view;

      // No specific view requested, looks like a reload from framework
      if (this.sidebox_et2 && typeof view === 'undefined') {
        this._clear_cache();
        this.setState({
          state: this.state
        });
        return false;
      }
      if (this.sidebox_et2 && typeof CalendarApp.views[view] == 'undefined' && view != 'index') {
        if (q.owner) {
          q.owner = q.owner.split(',');
          q.owner = q.owner.reduce(function (p, c) {
            if (p.indexOf(c) < 0) p.push(c);
            return p;
          }, []);
          q.owner = q.owner.join(',');
        }
        q.menuaction = 'calendar.calendar_uiviews.index';
        this.sidebox_et2.getWidgetById('iframe').set_src(egw$1.link('/index.php', q));
        jQuery(this.sidebox_et2.parentNode).show();
        return true;
      }
      // Known AJAX view
      else if (CalendarApp.views[view]) {
        // Reload of known view?
        if (view == 'index') {
          var pref = this.egw.preference('saved_states', 'calendar');
          view = pref.view || 'day';
        }
        // View etemplate not loaded
        if (typeof CalendarApp.views[view].etemplates[0] == 'string') {
          return _url + '&ajax=true';
        }
        // Already loaded, we'll just apply any variables to our current state
        var set = jQuery.extend({
          view: view
        }, q);
        this.update_state(set);
        return true;
      }
    } else if (this.sidebox_et2) {
      var iframe = this.sidebox_et2.getWidgetById('iframe');
      if (!iframe) {
        return false;
      }
      iframe.set_src(_url);
      jQuery(this.sidebox_et2.parentNode).show();
      // Hide other views
      for (var _view in CalendarApp.views) {
        for (var i = 0; i < CalendarApp.views[_view].etemplates.length; i++) {
          jQuery(CalendarApp.views[_view].etemplates[i].DOMContainer).hide();
        }
      }
      this.state.view = '';
      return true;
    }
    // can not load our own index page, has to be done by framework
    return false;
  }

  /**
   * Handle actions from the toolbar
   *
   * @param {egwAction} action Action from the toolbar
   */
  toolbar_action(action) {
    // Most can just provide state change data
    if (action.data && action.data.state) {
      var state = jQuery.extend({}, action.data.state);
      if (state.view == 'planner' && app.calendar.state.view != 'planner') {
        state.planner_view = app.calendar.state.view;
      }
      this.update_state(state);
    }
    // Special handling
    switch (action.id) {
      case 'add':
        // Default date/time to start of next hour
        var tempDate = new Date();
        if (tempDate.getMinutes() !== 0) {
          tempDate.setHours(tempDate.getHours() + 1);
          tempDate.setMinutes(0);
        }
        var today = new Date(tempDate.getFullYear(), tempDate.getMonth(), tempDate.getDate(), tempDate.getHours(), -tempDate.getTimezoneOffset(), 0);
        return egw$1.open(null, "calendar", "add", {
          start: today
        });
      case 'weekend':
        this.update_state({
          weekend: action.checked
        });
        break;
      case 'today':
        var tempDate = new Date();
        var today = new Date(tempDate.getFullYear(), tempDate.getMonth(), tempDate.getDate(), 0, -tempDate.getTimezoneOffset(), 0);
        var change = {
          date: today.toJSON()
        };
        app.calendar.update_state(change);
        break;
      case 'next':
      case 'previous':
        var delta = action.id == 'previous' ? -1 : 1;
        var view = CalendarApp.views[this.state.view] || false;
        var start = new Date(this.state.date);
        if (view) {
          start = view.scroll(delta);
          app.calendar.update_state({
            date: this.date.toString(start)
          });
        }
        break;
    }
  }

  /**
   * Handle the video call toggle from the toolbar
   *
   * @param action
   */
  toolbar_videocall_toggle_action(action) {
    var videocall_category = egw$1.config("status_cat_videocall", "status");
    var callback = function () {
      this.update_state({
        include_videocalls: action.checked
      });
    }.bind(this);
    this.toolbar_integration_action(action, [], null, callback);
  }

  /**
   * Handle the subscriptions toggle from the toolbar
   *
   * @param action
   */
  toolbar_subscriptions_toggle_action(action) {
    var callback = function () {
      this.update_state({
        include_subscriptions: action.checked
      });
    }.bind(this);
    this.toolbar_integration_action(action, [], null, callback);
  }

  /**
   * Handle integration actions from the toolbar
   *
   * @param action {egwAction} Integration action from the toolbar
   */
  toolbar_integration_action(action, selected, target, callback) {
    var app = action.id.replace("integration_", "");
    var integration_preference = egw$1.preference("integration_toggle", "calendar");
    if (typeof integration_preference === "undefined") {
      integration_preference = [];
    }
    if (typeof integration_preference == "string") {
      integration_preference = integration_preference.split(",");
    }
    // Make sure it's an array, not an object
    integration_preference = jQuery.extend([], integration_preference);
    if (action.checked) {
      if (integration_preference.indexOf(app) === -1) {
        integration_preference.push(app);
      }

      // After the preference change is done, get new info which should now include the app
      callback = callback ? callback : function () {
        this._fetch_data(this.state);
      }.bind(this);
    } else {
      var index = integration_preference.indexOf(app);
      if (index > -1) {
        integration_preference.splice(index, 1);
      }

      // Clear any events from that app
      this._clear_cache(app);
    }
    if (action.id == "integration_projectmanager" && this.egw.preference("calendar_integration", "projectmanager").indexOf("#") == 0) {
      if (!action.checked) {
        // Still need to re-fetch in this case, clearing won't bring the others back
        callback = function () {
          this._fetch_data(this.state);
        }.bind(this);
      } else {
        // Clear all events, we're filtering real events now
        callback = function () {
          this._clear_cache();

          // Force redraw to current state
          this.setState({
            state: this.state
          });
        }.bind(this);
      }
    }
    if (typeof callback === "undefined") {
      callback = function callback() {};
    }
    egw$1.set_preference("calendar", "integration_toggle", integration_preference, callback);
  }

  /**
   * Set the app header
   *
   * Because the toolbar takes some vertical space and has some horizontal space,
   * we don't use the system app header, but our own that is in the toolbar
   *
   * @param {string} header Text to display
   */
  set_app_header(header) {
    var template = etemplate2.getById('calendar-toolbar');
    var widget = template ? template.widgetContainer.getWidgetById('app_header') : false;
    if (widget) {
      widget.set_value(header);
      egw_app_header('', 'calendar');
    } else {
      egw_app_header(header, 'calendar');
    }
  }

  /**
   * Setup and handle sortable calendars.
   *
   * You can only sort calendars if there is more than one owner, and the calendars
   * are not combined (many owners, multi-week or month views)
   * @returns {undefined}
   */
  _sortable() {
    // Calender current state
    var state = this.getState();
    // Day / month sortables
    var daily = document.querySelector('#calendar-view_view .calendar_calGridHeader > div');
    var weekly = document.querySelector('#calendar-view_view tbody');
    var sortable = state.view == 'day' ? daily : weekly;
    var sortablejs = Sortable.create(sortable, {
      ghostClass: 'srotable_cal_wk_ph',
      draggable: state.view == 'day' ? '.calendar_calDayColHeader' : '.view_row',
      handle: state.view == 'day' ? '.blue_title' : '.calendar_calGridHeader',
      animation: 100,
      filter: state.view == 'day' ? '.calendar_calTimeGridScroll' : '.calendar_calDayColHeader',
      preventOnFilter: false,
      // Required for dnd fullday nonblocking
      dataIdAttr: 'data-owner',
      direction: state.view == 'day' ? 'horizontal' : 'vertical',
      sort: state.owner.length > 1 && (state.view == 'day' && state.owner.length < parseInt('' + egw$1.preference('day_consolidate', 'calendar')) || (state.view == 'week' || state.view == 'day4') && state.owner.length < parseInt('' + egw$1.preference('week_consolidate', 'calendar'))),
      // enable/disable sort
      onStart: function onStart(event) {
        // Put owners into row IDs
        CalendarApp.views[app.calendar.state.view].etemplates[0].widgetContainer.iterateOver(function (widget) {
          if (widget.options.owner && !widget.disabled) {
            widget.div.parents('tr').attr('data-owner', widget.options.owner);
          } else {
            widget.div.parents('tr').removeAttr('data-owner');
          }
        }, this, et2_calendar_timegrid);
      },
      onSort: function onSort(event) {
        var state = app.calendar.getState();
        if (state && typeof state.owner !== 'undefined') {
          var sortedArr = sortablejs.toArray();
          // No duplicates, no empties
          sortedArr = sortedArr.filter(function (value, index, self) {
            return value !== '' && self.indexOf(value) === index && !isNaN(value);
          });
          var parent = null;
          var children = [];
          if (state.view == 'day') {
            // If in day view, the days need to be re-ordered, avoiding
            // the current sort order
            CalendarApp.views.day.etemplates[0].widgetContainer.iterateOver(function (widget) {
              var idx = sortedArr.indexOf(widget.options.owner.toString());
              // Move the event holding div
              widget.set_left(parseInt(widget.options.width) * idx + 'px');
              // Re-order the children, or it won't stay
              parent = widget._parent;
              children.splice(idx, 0, widget);
            }, this, et2_calendar_daycol);
            parent.day_widgets.sort(function (a, b) {
              return children.indexOf(a) - children.indexOf(b);
            });
          } else {
            // Re-order the children, or it won't stay
            CalendarApp.views.day.etemplates[0].widgetContainer.iterateOver(function (widget) {
              parent = widget._parent;
              var idx = sortedArr.indexOf(widget.options.owner);
              children.splice(idx, 0, widget);
              widget.resize();
            }, this, et2_calendar_timegrid);
          }
          parent._children.sort(function (a, b) {
            return children.indexOf(a) - children.indexOf(b);
          });
          // Directly update, since there is no other changes needed,
          // and we don't want the current sort order applied
          app.calendar.state.owner = sortedArr;
          parent.options.owner = sortedArr;
        }
      }
    });
  }

  /**
   * Unlock the event before closing the popup
   *
   * @private
   */
  _unlock() {
    var content = this.et2.getArrayMgr('content');
    this.egw.json('calendar.calendar_uiforms.ajax_unlock', [content.data.id, content.data.lock_token], null, this, "keepalive", null).sendRequest();
  }

  /**
   * Bind scroll event
   * When the user scrolls, we'll move enddate - startdate days
   */
  _scroll() {
    var _framework$applicatio;
    /**
     * Function we can pass all this off to
     *
     * @param {String} direction up, down, left or right
     * @param {number} delta Integer for how many we're moving, should be +/- 1
     */
    var scroll_animate = function scroll_animate(direction, delta) {
      // Scrolling too fast?
      if (app.calendar._scroll_disabled) return;

      // Find the template
      var id = jQuery(this).closest('.et2_container').attr('id');
      if (id) {
        var template = etemplate2.getById(id);
      } else {
        template = CalendarApp.views[app.calendar.state.view].etemplates[0];
      }
      if (!template) return;

      // Prevent scrolling too fast
      app.calendar._scroll_disabled = true;

      // Animate the transition, if possible
      var widget = null;
      template.widgetContainer.iterateOver(function (w) {
        if (w.getDOMNode() == this) widget = w;
      }, this, et2_widget);
      if (widget == null) {
        template.widgetContainer.iterateOver(function (w) {
          widget = w;
        }, this, et2_calendar_timegrid);
        if (widget == null) return;
      }
      /* Disabled
       *
      // We clone the nodes so we can animate the transition
      var original = jQuery(widget.getDOMNode()).closest('.et2_grid');
      var cloned = original.clone(true).attr("id","CLONE");
      	// Moving this stuff around scrolls things around too
      // We need this later
      var scrollTop = jQuery('.calendar_calTimeGridScroll',original).scrollTop();
      	// This is to hide the scrollbar
      var wrapper = original.parent();
      if(direction == "right" || direction == "left")
      {
      	original.css({"display":"inline-block","width":original.width()+"px"});
      	cloned.css({"display":"inline-block","width":original.width()+"px"});
      }
      else
      {
      	original.css("height",original.height() + "px");
      	cloned.css("height",original.height() + "px");
      }
      var original_size = {height: wrapper.parent().css('height'), width: wrapper.parent().css('width')};
      wrapper.parent().css({overflow:'hidden', height:original.outerHeight()+"px", width:original.outerWidth() + "px"});
      wrapper.height(direction == "up" || direction == "down" ? 2 * original.outerHeight()  : original.outerHeight());
      wrapper.width(direction == "left" || direction == "right" ? 2 * original.outerWidth() : original.outerWidth());
      	// Re-scroll to previous to avoid "jumping"
      jQuery('.calendar_calTimeGridScroll',original).scrollTop(scrollTop);
      switch(direction)
      {
      	case "up":
      	case "left":
      		// Scrolling up
      		// Apply the reverse quickly, then let it animate as the changes are
      		// removed, leaving things where they should be.
      			original.parent().append(cloned);
      		// Makes it jump to destination
      		wrapper.css({
      			"transition-duration": "0s",
      			"transition-delay": "0s",
      			"transform": direction == "up" ? "translateY(-50%)" : "translateX(-50%)"
      		});
      		// Stop browser from caching style by forcing reflow
      		if(wrapper[0]) wrapper[0].offsetHeight;
      			wrapper.css({
      			"transition-duration": "",
      			"transition-delay": ""
      		});
      		break;
      	case "down":
      	case "right":
      		// Scrolling down
      		original.parent().prepend(cloned);
      		break;
      }
      // Scroll clone to match to avoid "jumping"
      jQuery('.calendar_calTimeGridScroll',cloned).scrollTop(scrollTop);
      	// Remove
      var remove = function() {
      	// Starting animation
      	wrapper.addClass("calendar_slide");
      	var translate = direction == "down" ? "translateY(-50%)" : (direction == "right" ? "translateX(-50%)" : "");
      	wrapper.css({"transform": translate});
      	window.setTimeout(function() {
      			cloned.remove();
      			// Makes it jump to destination
      		wrapper.css({
      			"transition-duration": "0s",
      			"transition-delay": "0s"
      		});
      			// Clean up from animation
      		wrapper
      			.removeClass("calendar_slide")
      			.css({"transform": '',height: '', width:'',overflow:''});
      		wrapper.parent().css({overflow: '', width: original_size.width, height: original_size.height});
      		original.css("display","");
      		if(wrapper.length)
      		{
      			wrapper[0].offsetHeight;
      		}
      		wrapper.css({
      			"transition-duration": "",
      			"transition-delay": ""
      		});
      			// Re-scroll to start of day
      		template.widgetContainer.iterateOver(function(w) {
      			w.resizeTimes();
      		},this, et2_calendar_timegrid);
      			window.setTimeout(function() {
      			if(app.calendar)
      			{
      				app.calendar._scroll_disabled = false;
      			}
      		}, 100);
      	},2000);
      }
      // If detecting the transition end worked, we wouldn't need to use a timeout.
      window.setTimeout(remove,100);
      */
      window.setTimeout(function () {
        if (app.calendar) {
          app.calendar._scroll_disabled = false;
        }
      }, 2000);
      // Get the view to calculate - this actually loads the new data
      // Using a timeout make it a little faster (in Chrome)
      window.setTimeout(function () {
        var view = CalendarApp.views[app.calendar.state.view] || false;
        var start = new Date(app.calendar.state.date);
        if (view && view.etemplates.indexOf(template) !== -1) {
          start = view.scroll(delta);
          app.calendar.update_state({
            date: app.calendar.date.toString(start)
          });
        } else {
          // Home - always 1 week
          // TODO
          return false;
        }
      }, 0);
    };

    // Bind only once, to the whole thing
    /* Disabled
    jQuery('body').off('.calendar')
    	//.on('wheel','.et2_container:#calendar-list,#calendar-sidebox)',
    	.on('wheel.calendar','.et2_container .calendar_calTimeGrid, .et2_container .calendar_plannerWidget',
    		function(e)
    		{
    			// Consume scroll if in the middle of something
    			if(app.calendar._scroll_disabled) return false;
    				// Ignore if they're going the other way
    			var direction = e.originalEvent.deltaY > 0 ? 1 : -1;
    			var at_bottom = direction !== -1;
    			var at_top = direction !== 1;
    				jQuery(this).children(":not(.calendar_calGridHeader)").each(function() {
    				// Check for less than 2px from edge, as sometimes we can't scroll anymore, but still have
    				// 2px left to go
    				at_bottom = at_bottom && Math.abs(this.scrollTop - (this.scrollHeight - this.offsetHeight)) <= 2;
    			}).each(function() {
    				at_top = at_top && this.scrollTop === 0;
    			});
    			if(!at_bottom && !at_top) return;
    				e.preventDefault();
    				scroll_animate.call(this, direction > 0 ? "down" : "up", direction);
    				return false;
    		}
    	);
    */
    if (typeof framework !== 'undefined' && (_framework$applicatio = framework.applications) !== null && _framework$applicatio !== void 0 && _framework$applicatio.calendar && framework.applications.calendar.tab) {
      var swipe = new tapAndSwipe(framework.applications.calendar.tab.contentDiv, {
        //Generic swipe handler for all directions
        swipe: function swipe(event, direction, distance, fingerCount) {
          if (direction == "up" || direction == "down") {
            if (fingerCount <= 1) return;
            var at_bottom = direction !== -1;
            var at_top = direction !== 1;
            jQuery(this.element).children(":not(.calendar_calGridHeader)").each(function () {
              // Check for less than 2px from edge, as sometimes we can't scroll anymore, but still have
              // 2px left to go
              at_bottom = at_bottom && Math.abs(this.scrollTop - (this.scrollHeight - this.offsetHeight)) <= 2;
            }).each(function () {
              at_top = at_top && this.scrollTop === 0;
            });
          }
          var delta = direction == "down" || direction == "right" ? -1 : 1;
          // But we animate in the opposite direction to the swipe
          var opposite = {
            "down": "up",
            "up": "down",
            "left": "right",
            "right": "left"
          };
          direction = opposite[direction];
          scroll_animate.call(jQuery(event.target).closest('.calendar_calTimeGrid, .calendar_plannerWidget')[0], direction, delta);
          return false;
        },
        minSwipeThreshold: 100,
        allowScrolling: 'vertical'
      });

      // Page up & page down
      egw_registerGlobalShortcut(EGW_KEY_PAGE_UP, false, false, false, function () {
        if (app.calendar.state.view == 'listview') {
          return false;
        }
        scroll_animate.call(this, "up", -1);
        return true;
      }, this);
      egw_registerGlobalShortcut(EGW_KEY_PAGE_DOWN, false, false, false, function () {
        if (app.calendar.state.view == 'listview') {
          return false;
        }
        scroll_animate.call(this, "down", 1);
        return true;
      }, this);
    }
  }

  /**
   * Handler for changes generated by internal user interactions, like
   * drag & drop inside calendar and resize.
   *
   * @param {Event} event
   * @param {et2_calendar_event} widget Widget for the event
   * @param {string} dialog_button - 'single', 'series', or 'exception', based on the user's answer
   *	in the popup
   * @returns {undefined}
   */
  event_change(event, widget, dialog_button) {
    // Add loading spinner - not visible if the body / gradient is there though
    widget.div.addClass('loading');

    // Integrated infolog event
    //Get infologID if in case if it's an integrated infolog event
    if (widget.options.value.app == 'infolog') {
      // If it is an integrated infolog event we need to edit infolog entry
      egw$1().json('stylite_infolog_calendar_integration::ajax_moveInfologEvent', [widget.options.value.app_id, widget.options.value.start, widget.options.value.duration],
      // Remove loading spinner
      function () {
        if (widget.div) widget.div.removeClass('loading');
      }).sendRequest();
    } else {
      var _send = function _send() {
        egw$1().json('calendar.calendar_uiforms.ajax_moveEvent', [dialog_button == 'exception' ? widget.options.value.app_id : widget.options.value.id, widget.options.value.owner, widget.options.value.start, widget.options.value.owner, widget.options.value.duration, dialog_button == 'series' ? widget.options.value.start : null],
        // Remove loading spinner
        function () {
          if (widget && widget.div) widget.div.removeClass('loading');
        }).sendRequest(true);
      };
      if (dialog_button == 'series' && widget.options.value.recur_type) {
        widget.series_split_prompt(function (_button_id) {
          if (_button_id == Et2Dialog.OK_BUTTON) {
            _send();
          }
        });
      } else {
        _send();
      }
    }
  }

  /**
   * open the freetime search popup
   *
   * @param {string} _link
   */
  freetime_search_popup(_link) {
    this.egw.open_link(_link, 'ft_search', '700x500');
  }

  /**
   * send an ajax request to server to set the freetimesearch window content
   *
   */
  freetime_search() {
    var content = this.et2.getArrayMgr('content').data;
    content['start'] = this.et2.getValueById('start');
    content['end'] = this.et2.getValueById('end');
    content['duration'] = this.et2.getValueById('duration');
    var request = this.egw.json('calendar.calendar_uiforms.ajax_freetimesearch', [content], null, null, null, null);
    request.sendRequest();
  }

  /**
   * Function for disabling the recur_data multiselect box and add_rdate hbox
   *
   */
  check_recur_type() {
    var recurType = this.et2.getWidgetById('recur_type');
    var recurData = this.et2.getWidgetById('recur_data');
    var addRdate = this.et2.getWidgetById('button[add_rdate]');
    var recurRdate = this.et2.getWidgetById('recur_rdate');
    if (recurType && recurData) {
      recurData.set_disabled(recurType.value != 2 && recurType.value != 4);
    }
    if (recurType && addRdate && recurRdate) {
      var _this$et2$getWidgetBy, _this$et2$getWidgetBy2;
      addRdate.set_disabled(recurType.value != 9);
      recurRdate.set_disabled(recurType.value != 9);
      (_this$et2$getWidgetBy = this.et2.getWidgetById('recur_enddate')) === null || _this$et2$getWidgetBy === void 0 || _this$et2$getWidgetBy.set_disabled(recurType.value == 9);
      (_this$et2$getWidgetBy2 = this.et2.getWidgetById('recur_interval')) === null || _this$et2$getWidgetBy2 === void 0 || _this$et2$getWidgetBy2.set_disabled(recurType.value == 9);
    }
  }

  /**
   * Actions for when the user changes the event start date in edit dialog
   *
   * @returns {undefined}
   */
  edit_start_change(input, widget) {
    if (!widget) {
      widget = etemplate2.getById('calendar-edit').widgetContainer.getWidgetById('start');
    }

    // Update settings for querying participants
    this.edit_update_participant(widget);

    // Update recurring date limit, if not set it can't be before start
    if (widget) {
      var recur_end = widget.getRoot().getWidgetById('recur_enddate');
      if (recur_end && recur_end.getValue && !recur_end.value) {
        recur_end.set_min(widget.value);
      }
      // update recur_rdate with start (specially time) and set start as minimum
      var recur_rdate = widget.getRoot().getWidgetById('recur_rdate');
      if (recur_rdate) {
        recur_rdate.set_min(widget.value);
        recur_rdate.value = widget.value;
      }

      // Update end date, min duration is 1 minute
      var end = widget.getRoot().getWidgetById('end');
      var start_time = new Date(widget.value);
      var end_time = new Date(end.value);
      if (end.value && end_time <= start_time) {
        start_time.setMinutes(start_time.getMinutes() + 1);
        end.set_value(start_time);
      }
    }
    // Update currently selected alarm time
    this.alarm_custom_date();
  }

  /**
   * Show/Hide end date, for both edit and freetimesearch popups,
   * based on if "use end date" selected or not.
   *
   */
  set_enddate_visibility() {
    var duration = this.et2.getWidgetById('duration');
    var start = this.et2.getWidgetById('start');
    var end = this.et2.getWidgetById('end');
    var content = this.et2.getArrayMgr('content').data;
    if (duration != null && end != null) {
      end.set_disabled(duration.get_value() !== '');
      end.classList.toggle("hideme", end.disabled);

      // Only set end date if not provided, adding seconds fails with DST
      // @ts-ignore
      if (!end.disabled && !content.end) {
        end.set_value(start.get_value());
        // @ts-ignore
        if (typeof content.duration != 'undefined') end.set_value("+" + content.duration);
      }
    }
    this.edit_update_participant(start);
  }

  /**
   * Update query parameters for participants
   *
   * This allows for resource conflict checking
   *
   * @param {DOMNode|et2_widget} input Either the input node, or the widget
   * @param {et2_widget} [widget] If input is an input node, widget will have
   *	the widget, otherwise it will be undefined.
   */
  edit_update_participant(input, widget) {
    if (typeof widget === 'undefined') {
      widget = input;
    }
    var content = widget.getInstanceManager().getValues(widget.getRoot());
    var participant = widget.getRoot().getWidgetById('participant');
    if (!participant) {
      return;
    }
    participant.searchOptions = {
      exec: {
        start: content.start,
        end: content.end,
        duration: content.duration,
        whole_day: content.whole_day
      }
    };
  }

  /**
   * handles actions selectbox in calendar edit popup
   *
   * @param {mixed} _event
   * @param {et2_base_widget} widget "actions selectBox" in edit popup window
   */
  actions_change(_event, widget) {
    var event = this.et2.getArrayMgr('content').data;
    if (widget) {
      var id = this.et2.getArrayMgr('content').data['id'];
      switch (widget.get_value()) {
        case 'print':
          this.egw.open_link('calendar.calendar_uiforms.edit&cal_id=' + id + '&print=1', '_blank', '700x700');
          break;
        case 'mail':
          this.egw.json('calendar.calendar_uiforms.ajax_custom_mail', [event, !event['id'], false], null, null, null, null).sendRequest();
          this.et2._inst.submit();
          break;
        case 'sendrequest':
          this.egw.json('calendar.calendar_uiforms.ajax_custom_mail', [event, !event['id'], true], null, null, null, null).sendRequest();
          this.et2._inst.submit();
          break;
        case 'infolog':
          this.egw.open_link('infolog.infolog_ui.edit&action=calendar&action_id=' + (jQuery.isPlainObject(event) ? event['id'] : event), '_blank', '700x600', 'infolog');
          this.et2._inst.submit();
          break;
        case 'ical':
          this.et2._inst.postSubmit();
          break;
        default:
          this.et2._inst.submit();
      }
    }
  }

  /**
   * open mail compose popup window
   *
   * @param {Array} vars
   * @todo need to provide right mail compose from server to custom_mail function
   */
  custom_mail(vars) {
    this.egw.open_link(this.egw.link("/index.php", vars), '_blank', '700x700');
  }

  /**
   * control delete_series popup visibility
   *
   * @param {et2_widget} widget
   * @param {Array} exceptions an array contains number of exception entries
   *
   */
  delete_btn(widget, exceptions) {
    var content = this.et2.getArrayMgr('content').data;
    if (exceptions) {
      var buttons = [{
        button_id: 'keep',
        title: this.egw.lang('All exceptions are converted into single events.'),
        label: this.egw.lang('Keep exceptions'),
        id: 'button[delete_keep_exceptions]',
        image: 'keep',
        "default": true
      }, {
        button_id: 'delete',
        title: this.egw.lang('The exceptions are deleted together with the series.'),
        label: this.egw.lang('Delete exceptions'),
        id: 'button[delete_exceptions]',
        image: 'delete'
      }, {
        button_id: 'cancel',
        label: this.egw.lang('Cancel'),
        id: 'dialog[cancel]',
        image: 'cancel'
      }];
      var self = this;
      Et2Dialog.show_dialog(function (_button_id) {
        if (_button_id != 'dialog[cancel]') {
          widget.getRoot().getWidgetById('delete_exceptions').set_value(_button_id == 'button[delete_exceptions]');
          widget.getInstanceManager().submit('button[delete]');
          return true;
        } else {
          return false;
        }
      }, "Do you want to keep the series exceptions in your calendar?", "This event is part of a series", {}, buttons, Et2Dialog.WARNING_MESSAGE);
    } else if (content['recur_type'] !== 0) {
      Et2Dialog.confirm(widget, 'Delete this series of recurring events', 'Delete Series');
    } else {
      Et2Dialog.confirm(widget, 'Delete this event', 'Delete');
    }
  }

  /**
   * On change participant event, try to set add button status based on
   * participant field value. Additionally, disable/enable quantity field
   * if there's none resource value or there are more than one resource selected.
   *
   */
  participantOnChange() {
    var add = this.et2.getWidgetById('add');
    var quantity = this.et2.getWidgetById('quantity');
    var participant = this.et2.getWidgetById('participant');

    // array of participants
    var value = participant.value;
    add.disabled = value.length <= 0;
    quantity.set_readonly(false);

    // number of resources
    var nRes = 0;
    for (var i = 0; i < value.length; i++) {
      if (!value[i].match(/\D/ig) || nRes) {
        quantity.set_readonly(true);
        quantity.set_value(1);
      }
      nRes++;
    }
  }

  /**
   * print_participants_status(egw,widget)
   * Handle to apply changes from status in print popup
   *
   * @param {mixed} _event
   * @param {et2_base_widget} widget widget "status" in print popup window
   *
   */
  print_participants_status(_event, widget) {
    if (widget && window.opener) {
      //Parent popup window
      var editPopWindow = window.opener;
      if (editPopWindow) {
        //Update paretn popup window
        editPopWindow.etemplate2.getByApplication('calendar')[0].widgetContainer.getWidgetById(widget.id).set_value(widget.get_value());
      }
      this.et2._inst.submit();
      editPopWindow.opener.egw_refresh('status changed', 'calendar');
    } else if (widget) {
      window.egw_refresh(this.egw.lang('The original popup edit window is closed! You need to close the print window and reopen the entry again.'), 'calendar');
    }
  }

  /**
   * Handles to select freetime, and replace the selected one on Start,
   * and End date&time in edit calendar entry popup.
   *
   * @param {mixed} _event
   * @param {et2_base_widget} _widget widget "select button" in freetime search popup window
   *
   */
  freetime_select(_event, _widget) {
    if (_widget) {
      var content = this.et2._inst.widgetContainer.getArrayMgr('content').data;
      // Make the Id from selected button by checking the index
      var selectedId = _widget.id.match(/^select\[([0-9])\]$/i)[1];
      var sTime = this.et2.getWidgetById(selectedId + 'start');

      //check the parent window is still open before to try to access it
      if (window.opener && sTime) {
        var editWindowObj = window.opener.etemplate2.getByApplication('calendar')[0];
        if (typeof editWindowObj != "undefined") {
          var startTime = editWindowObj.widgetContainer.getWidgetById('start');
          var endTime = editWindowObj.widgetContainer.getWidgetById('end');
          if (startTime && endTime) {
            startTime.set_value(sTime.get_value());
            endTime.set_value(sTime.get_value());
            endTime.set_value('+' + content['duration']);
          }
        }
      } else {
        alert(this.egw.lang('The original calendar edit popup is closed!'));
      }
    }
    egw$1(window).close();
  }

  /**
   * show/hide the filter of nm list in calendar listview
   *
   */
  filter_change() {
    var view = CalendarApp.views['listview'].etemplates[0].widgetContainer || null;
    var nm = view ? view.getWidgetById('nm') : null;
    var filter = view && nm ? nm.getWidgetById('filter') : null;
    var dates = view ? view.getWidgetById('calendar.list.dates') : null;

    // Update state when user changes it
    if (view && filter) {
      app.calendar.state.filter = filter.getValue();
      // Change sort order for before - this is just the UI, server does the query
      if (app.calendar.state.filter == 'before') {
        nm.sortBy('cal_start', false, false);
      } else {
        nm.sortBy('cal_start', true, false);
      }
    } else {
      delete app.calendar.state.filter;
    }
    if (filter && dates) {
      dates.set_disabled(filter.getValue() !== "custom");
      if (filter.getValue() == "custom" && !this.state_update_in_progress) {
        // Copy state dates over, without causing [another] state update
        var actual = this.state_update_in_progress;
        this.state_update_in_progress = true;
        view.getWidgetById('startdate').set_value(app.calendar.state.first);
        view.getWidgetById('enddate').set_value(app.calendar.state.last);
        this.state_update_in_progress = actual;
        jQuery(view.getWidgetById('startdate').getDOMNode()).find('input').focus();
      }
    }
  }

  /**
   * Application links from non-list events
   *
   * The ID looks like calendar::<id> or calendar::<id>:<recurrence_date>
   * For processing the links:
   *	'$app' gets replaced with 'calendar'
   *	'$id' gets replaced with <id>
   *	'$app_id gets replaced with <id>:<recurrence_date>
   *
   * Use either $id or $app_id depending on if you want the series [beginning]
   * or a particular date.
   *
   * @param {egwAction} _action
   * @param {egwActionObject[]} _events
   */
  action_open(_action, _events) {
    var app, id, app_id;
    // Try to get better by going straight for the data
    var data = egw$1.dataGetUIDdata(_events[0].id);
    if (data && data.data) {
      app = data.data.app;
      app_id = data.data.app_id;
      id = data.data.id;
    } else {
      // Try to set some reasonable values from the ID
      id = _events[0].id.split('::');
      app = id[0];
      app_id = id[1];
      if (app_id && app_id.indexOf(':')) {
        var split = id[1].split(':');
        id = split[0];
      } else {
        id = app_id;
      }
    }
    if (_action.data.open) {
      var open = JSON.parse(_action.data.open) || {};
      var extra = open.extra || '';
      extra = extra.replace(/(\$|%24)app/, app).replace(/(\$|%24)app_id/, app_id).replace(/(\$|%24)id/, id);

      // Get a little smarter with the context
      if (!extra) {
        var context = {};
        if (egw$1.dataGetUIDdata(_events[0].id) && egw$1.dataGetUIDdata(_events[0].id).data) {
          // Found data in global cache
          context = egw$1.dataGetUIDdata(_events[0].id).data;
          extra = {};
        } else if (_events[0].iface.getWidget() && _events[0].iface.getWidget()._get_time_from_position && _action.menu_context && _action.menu_context.event) {
          // Non-row space in planner
          // Context menu has position information, but target is not what we expact
          var target = jQuery('.calendar_plannerGrid', _action.menu_context.event.currentTarget);
          var y = _action.menu_context.event.pageY - target.offset().top;
          var x = _action.menu_context.event.pageX - target.offset().left;
          var date = _events[0].iface.getWidget()._get_time_from_position(x, y);
          if (date) {
            context.start = date.toJSON();
          }
        } else if (_events[0].iface.getWidget() && _events[0].iface.getWidget().instanceOf(et2_calendar_planner_row)) {
          // Empty space on a planner row
          var widget = _events[0].iface.getWidget();
          var parent = widget.getParent();
          if (parent.options.group_by == 'month') {
            var date = parent._get_time_from_position(_action.menu_context.event.clientX, _action.menu_context.event.clientY);
          } else {
            var date = parent._get_time_from_position(_action.menu_context.event.offsetX, _action.menu_context.event.offsetY);
          }
          if (date) {
            context.start = date.toJSON();
          }
          jQuery.extend(context, widget.getDOMNode().dataset);
        } else if (_events[0].iface.getWidget() && _events[0].iface.getWidget().instanceOf(et2_valueWidget)) {
          // Able to extract something from the widget
          context = _events[0].iface.getWidget().getValue ? _events[0].iface.getWidget().getValue() : _events[0].iface.getWidget().options.value || {};
          extra = {};
        }
        // Try to pull whatever we can from the event
        else if (jQuery.isEmptyObject(context) && _action.menu_context && _action.menu_context.event.target) {
          var _target = _action.menu_context.event.target;
          while (_target != null && _target.parentNode && jQuery.isEmptyObject(_target.dataset)) {
            _target = _target.parentNode;
          }
          context = extra = jQuery.extend({}, _target.dataset);
          var owner = jQuery(_target).closest('[data-owner]').get(0);
          if (owner && owner.dataset.owner && owner.dataset.owner != this.state.owner) {
            extra.owner = owner.dataset.owner.split(',');
          }
        }
        if (context.date) extra.date = context.date;
        if (context.app) extra.app = context.app;
        if (context.app_id) extra.app_id = context.app_id;
      }
      this.egw.open(open.id_data || '', open.app, open.type, extra ? extra : context);
    } else if (_action.data.url) {
      var url = _action.data.url;
      url = url.replace(/(\$|%24)app_id/, app_id).replace(/(\$|%24)app/, app).replace(/(\$|%24)id/, id);
      this.egw.open_link(url, _action.data.target, _action.data.popup);
    }
  }

  /**
   * Check to see if we know how to convert this entry to the given app
   *
   * The current entry may not be an actual calendar event, it may be some other app
   * that is participating via integration hook.  This is determined by checking the
   * hooks defined for <appname>_set, indicating that the app knows how to provide
   * information for that application
   *
   * @param {egwAction} _action
   * @param {egwActionObject[]} _events
   */
  action_convert_enabled_check(_action, _events) {
    var supported_apps = _action.data.convert_apps || [];
    var entry = egw$1.dataGetUIDdata(_events[0].id);
    if (supported_apps && entry && entry.data) {
      return supported_apps.length > 0 && supported_apps.indexOf(entry.data.app) >= 0;
    }
    return true;
  }

  /**
   * Context menu action (on a single event) in non-listview to generate ical
   *
   * Since nextmatch is all ready to handle that, we pass it through
   *
   * @param {egwAction} _action
   * @param {egwActionObject[]} _events
   */
  ical(_action, _events) {
    // Send it through nextmatch
    _action.data.nextmatch = etemplate2.getById('calendar-list').widgetContainer.getWidgetById('nm');
    var ids = {
      ids: []
    };
    for (var i = 0; i < _events.length; i++) {
      ids.ids.push(_events[i].id);
    }
    nm_action(_action, _events, null, ids);
  }

  /**
   * Change status (via AJAX)
   *
   * @param {egwAction} _action
   * @param {egwActionObject} _events
   */
  status(_action, _events) {
    // Should be a single event, but we'll do it for all
    for (var i = 0; i < _events.length; i++) {
      var event_widget = _events[i].iface.getWidget() || false;
      if (!event_widget) continue;
      event_widget.recur_prompt(jQuery.proxy(function (button_id, event_data) {
        switch (button_id) {
          case 'exception':
            egw$1().json('calendar.calendar_uiforms.ajax_status', [event_data.app_id, egw$1.user('account_id'), _action.data.id]).sendRequest(true);
            break;
          case 'series':
          case 'single':
            egw$1().json('calendar.calendar_uiforms.ajax_status', [event_data.id, egw$1.user('account_id'), _action.data.id]).sendRequest(true);
            break;
          case 'cancel':
          default:
            break;
        }
      }, this));
    }
  }

  /**
   * this function try to fix ids which are from integrated apps
   *
   * @param {egwAction} _action
   * @param {egwActionObject[]} _senders
   */
  cal_fix_app_id(_action, _senders) {
    var app = 'calendar';
    var id = _senders[0].id;
    var matches = id.match(/^(?:calendar::)?([0-9]+)(:([0-9]+))?$/);
    if (matches) {
      id = matches[1];
    } else {
      matches = id.match(/^([a-z_-]+)([0-9]+)/i);
      if (matches) {
        app = matches[1];
        id = matches[2];
      }
    }
    var backup_url = _action.data.url;
    _action.data.url = _action.data.url.replace(/(\$|%24)id/, id);
    _action.data.url = _action.data.url.replace(/(\$|%24)app/, app);
    nm_action(_action, _senders, false, {
      ids: [id]
    });
    _action.data.url = backup_url; // restore url
  }

  /**
   * Open a smaller dialog/popup to add a new entry
   *
   * This is opened inside a dialog widget, not a popup.  This causes issues
   * with the submission, handling of the response, and cleanup.  We're doing this because the server sets a lot
   * of default values, but this could probably also be done more cleanly by getting the values via AJAX and passing
   * them into the dialog
   *
   * @param {Object} options Array of values for new
   * @param {et2_calendar_event} event Placeholder showing where new event goes
   */
  add(options, event) {
    if (this.egw.preference('new_event_dialog', 'calendar') === 'edit') {
      // We lose control after this, so remove the placeholder now
      if (event && event.destroy) {
        event.destroy();
      }
      // Set this to open the add template in a popup
      //options.template = 'calendar.add';
      return this.egw.open(null, 'calendar', 'edit', options, '_blank', 'calendar');
    }
    var menuaction = 'calendar.calendar_uiforms.edit&template=calendar.add';
    for (var name in options) {
      menuaction += '&' + name + '=' + encodeURIComponent(options[name]);
    }
    return this.egw.openDialog(menuaction).then(dialog => {
      // When the dialog is closed, clean up the placeholder
      dialog.getComplete().then(() => {
        if (event) {
          event.destroy();
        }
      });
    });
  }

  /**
   * Open calendar entry, taking into account the calendar integration of other apps
   *
   * calendar_uilist::get_rows sets var js_calendar_integration object
   *
   * @param _action
   * @param _senders
   *
   */
  cal_open(_action, _senders) {
    // Try for easy way - find a widget
    if (_senders[0].iface.getWidget) {
      var widget = _senders[0].iface.getWidget();
      return widget.recur_prompt();
    }

    // Nextmatch in list view does not have a widget, but we can pull
    // the data by ID
    // Check for series
    var id = _senders[0].id;
    var data = egw$1.dataGetUIDdata(id);
    if (data && data.data) {
      et2_calendar_event.recur_prompt(data.data);
      return;
    }
    var matches = id.match(/^(?:calendar::)?([0-9]+):([0-9]+)$/);

    // Check for other app integration data sent from server
    var backup = _action.data;
    if (_action.parent.data && _action.parent.data.nextmatch) {
      var js_integration_data = _action.parent.data.nextmatch.options.settings.js_integration_data || this.et2.getArrayMgr('content').data.nm.js_integration_data;
      if (typeof js_integration_data == 'string') {
        js_integration_data = JSON.parse(js_integration_data);
      }
    }
    matches = id.match(/^calendar::([a-z_-]+)([0-9]+)/i);
    if (matches && js_integration_data && js_integration_data[matches[1]]) {
      var app = matches[1];
      _action.data.url = window.egw_webserverUrl + '/index.php?';
      var get_params = js_integration_data[app].edit;
      get_params[js_integration_data[app].edit_id] = matches[2];
      for (var name in get_params) _action.data.url += name + "=" + encodeURIComponent(get_params[name]) + "&";
      if (js_integration_data[app].edit_popup) {
        egw$1.open_link(_action.data.url, '_blank', js_integration_data[app].edit_popup, app);
        _action.data = backup; // restore url, width, height, nm_action
        return;
      }
    } else {
      // Other app integration using link registry
      var data = egw$1.dataGetUIDdata(_senders[0].id);
      if (data && data.data) {
        return egw$1.open(data.data.app_id, data.data.app, 'edit');
      }
    }
    // Regular, single event
    egw$1.open(id.replace(/^calendar::/g, ''), 'calendar', 'edit');
  }

  /**
   * Delete (a single) calendar entry over ajax.
   *
   * Used for the non-list views
   *
   * @param {egwAction} _action
   * @param {egwActionObject} _events
   */
  delete(_action, _events) {
    // Should be a single event, but we'll do it for all
    for (var i = 0; i < _events.length; i++) {
      var event_widget = _events[i].iface.getWidget() || false;
      if (!event_widget) continue;
      event_widget.recur_prompt(jQuery.proxy(function (button_id, event_data) {
        switch (button_id) {
          case 'exception':
            egw$1().json('calendar.calendar_uiforms.ajax_delete', [event_data.app_id]).sendRequest(true);
            break;
          case 'series':
          case 'single':
            egw$1().json('calendar.calendar_uiforms.ajax_delete', [event_data.id]).sendRequest(true);
            break;
          case 'cancel':
          default:
            break;
        }
      }, this));
    }
  }

  /**
   * Delete calendar entry, asking if you want to delete series or exception
   *
   * Used for nextmatch
   *
   * @param _action
   * @param _senders
   */
  cal_delete(_action, _senders) {
    var _action$parent$data$n, _action$parent$getAct;
    var all = (_action$parent$data$n = _action.parent.data.nextmatch) === null || _action$parent$data$n === void 0 ? void 0 : _action$parent$data$n.getSelection().all;
    var no_notifications = (_action$parent$getAct = _action.parent.getActionById("no_notifications")) === null || _action$parent$getAct === void 0 ? void 0 : _action$parent$getAct.checked;
    var matches = false;
    var ids = [];
    var cal_event = this.egw.dataGetUIDdata(_senders[0].id);

    // Loop so we ask if any of the selected entries is part of a series
    for (var i = 0; i < _senders.length; i++) {
      var id = _senders[i].id;
      if (!matches) {
        matches = id.match(/^(?:calendar::)?([0-9]+):([0-9]+)$/);
      }
      ids.push(id.split("::").pop());
    }
    if (matches) {
      // At least one event is a series, use its data to trigger the prompt
      var _cal_event = this.egw.dataGetUIDdata(matches[0]);
    }
    et2_calendar_event.recur_prompt(cal_event.data, function (button_id, event_data) {
      switch (button_id) {
        case 'single':
        case 'exception':
          // Just this one, handle in the normal way but over AJAX
          egw$1.json("calendar.calendar_uilist.ajax_action", [_action.id, ids, all, no_notifications]).sendRequest(true);
          break;
        case 'series':
          // No recurrences, handle in the normal way but over AJAX
          egw$1.json("calendar.calendar_uilist.ajax_action", ["delete_series", ids, all, no_notifications]).sendRequest(true);
          break;
        case 'cancel':
        default:
          break;
      }
    }.bind(this));
  }

  /**
   * Confirmation dialog for moving a series entry
   *
   * @param {object} _DOM
   * @param {et2_widget} _button button Save | Apply
   */
  move_edit_series(_DOM, _button) {
    var content = this.et2.getArrayMgr('content').data;
    var start_date = this.et2.getValueById('start');
    var end_date = this.et2.getValueById('end');
    var whole_day = this.et2.getWidgetById('whole_day');
    var duration = '' + this.et2.getValueById('duration');
    var is_whole_day = whole_day && whole_day.value == whole_day.selectedValue;
    var button = _button;
    var that = this;
    var instance_date_regex = window.location.search.match(/date=(\d{4}-\d{2}-\d{2}(?:.+Z)?)/);
    var instance_date;
    if (instance_date_regex && instance_date_regex.length && instance_date_regex[1]) {
      instance_date = new Date(unescape(instance_date_regex[1]));
      instance_date.setUTCMinutes(instance_date.getUTCMinutes() + instance_date.getTimezoneOffset());
    }
    if (typeof content != 'undefined' && content.id != null && typeof content.recur_type != 'undefined' && content.recur_type != null && content.recur_type != 0) {
      if (content.start != start_date || content.whole_day != is_whole_day || duration && '' + content.duration != duration ||
      // End date might ignore seconds, and be 59 seconds off for all day events
      !duration && Math.abs(new Date(end_date) - new Date(content.end)) > 60000) {
        et2_calendar_event.series_split_prompt(content, instance_date, function (_button_id) {
          if (_button_id == Et2Dialog.OK_BUTTON) {
            that.et2.getInstanceManager().submit(button);
          }
        });
        return false;
      }
      // check if we have future exceptions and changes with might be applied to them too
      if (content.future_exceptions) {
        Et2Dialog.show_dialog(_button => {
          this.et2.setValueById('apply_changes_to_exceptions', _button == Et2Dialog.YES_BUTTON);
          this.et2.getInstanceManager().submit(button);
        }, 'Otherwise, changes to the title, description, ... or new participants will not be transferred to exceptions that have already been created.', 'Apply changes to (future) exceptions too?', undefined, Et2Dialog.BUTTONS_YES_NO, Et2Dialog.QUESTION_MESSAGE);
        return false;
      }
    }
    return true;
  }

  /**
   * Send a mail  or meeting request to event participants
   *
   * @param {egwAction} _action
   * @param {egwActionObject[]} _selected
   */
  action_mail(_action, _selected) {
    var data = egw$1.dataGetUIDdata(_selected[0].id) || {
      data: {}
    };
    var event = data.data;
    this.egw.json('calendar.calendar_uiforms.ajax_custom_mail', [event, false, _action.id === 'sendrequest'], null, null, null, null).sendRequest();
  }

  /**
   * Sidebox merge
   *
   * Manage the state and pass the request to the correct place.  Since the nextmatch
   * and the sidebox have different ideas of the 'current' timespan (sidebox
   * always has a start and end date) we need to call merge on the nextmatch
   * if the current view is listview, so the user gets the results they expect.
   *
   * @param {Event} event UI event
   * @param {et2_widget} widget Should be the merge selectbox
   */
  sidebox_merge(event, widget) {
    if (!widget || !widget.getValue()) return false;
    if (this.state.view == 'listview') {
      // If user is looking at the list, pretend they used the context
      // menu and process it through the nextmatch
      var nm = etemplate2.getById('calendar-list').widgetContainer.getWidgetById('nm') || false;
      var selected = nm ? nm.controller._objectManager.getSelectedLinks() : [];
      var action = nm.controller._actionManager.getActionById('document_' + widget.getValue());
      if (nm && (!selected || !selected.length)) {
        nm.controller._selectionMgr.selectAll(true);
      }
      if (action && selected) {
        super.merge(action, selected);
      }
    } else {
      // Set the hidden inputs to the current time span & submit
      widget.getRoot().getWidgetById('first').set_value(app.calendar.state.first);
      widget.getRoot().getWidgetById('last').set_value(app.calendar.state.last);
      var vars = {
        menuaction: 'calendar.calendar_merge.merge_entries',
        document: widget.getValue(),
        merge: 'calendar_merge',
        options: {
          pdf: false
        },
        select_all: false,
        id: JSON.stringify({
          first: app.calendar.state.first,
          last: app.calendar.state.last,
          date: app.calendar.state.first,
          view: app.calendar.state.view
        })
      };
      egw$1.open_link(egw$1.link('/index.php', vars), '_blank');
    }
    widget.set_value('');
    return false;
  }

  /**
   * Method to set state for JSON requests (jdots ajax_exec or et2 submits can NOT use egw.js script tag)
   *
   * @param {object} _state
   */
  set_state(_state) {
    if (typeof _state == 'object') {
      // If everything is loaded, handle the changes
      if (this.sidebox_et2 !== null) {
        this.update_state(_state);
      } else {
        // Things aren't loaded yet, just set it
        this.state = _state;
      }
    }
  }

  /**
   * Change only part of the current state.
   *
   * The passed state options (filters) are merged with the current state, so
   * this is the one that should be used for most calls, as setState() requires
   * the complete state.
   *
   * @param {Object} _set New settings
   */
  update_state(_set) {
    // Make sure we're running in top window
    // @ts-ignore
    if (window !== window.top && window.top.app.calendar) {
      // @ts-ignore
      return window.top.app.calendar.update_state(_set);
    }
    if (this.state_update_in_progress) return;
    var changed = [];
    var new_state = jQuery.extend({}, this.state);
    if (typeof _set === 'object') {
      for (var s in _set) {
        if (new_state[s] !== _set[s] && (typeof new_state[s] == 'string' || typeof new_state[s] !== 'string' && new_state[s] + '' !== _set[s] + '')) {
          changed.push(s + ': ' + new_state[s] + ' -> ' + _set[s]);
          new_state[s] = _set[s];
        }
      }
    }
    if (changed.length && !this.state_update_in_progress) {
      var _framework$applicatio2;
      // This activates calendar app if you call setState from a different app
      // such as home.  If we change state while not active, sizing is wrong.
      if (typeof framework !== 'undefined' && (_framework$applicatio2 = framework.applications) !== null && _framework$applicatio2 !== void 0 && _framework$applicatio2.calendar && framework.applications.calendar.hasSideboxMenuContent) {
        framework.setActiveApp(framework.applications.calendar);
      }
      console.log('Calendar state changed', changed.join("\n"));
      // Log
      this.egw.debug('navigation', 'Calendar state changed', changed.join("\n"));
      this.setState({
        state: new_state
      });
    }
  }

  /**
   * Return state object defining current view
   *
   * Called by favorites to query current state.
   *
   * @return {object} description
   */
  getState() {
    var state = jQuery.extend({}, this.state);
    if (!state) {
      var egw_script_tag = document.getElementById('egw_script_id');
      var tag_state = egw_script_tag.getAttribute('data-calendar-state');
      state = tag_state ? JSON.parse(tag_state) : {};
    }

    // Don't store current user in state to allow admins to create favourites for all
    // Should make no difference for normal users.
    if (state.owner == egw$1.user('account_id')) {
      // 0 is always the current user, so if an admin creates a default favorite,
      // it will work for other users too.
      state.owner = 0;
    }

    // Keywords are only for list view
    if (state.view == 'listview') {
      var listview = typeof CalendarApp.views.listview.etemplates[0] !== 'string' && CalendarApp.views.listview.etemplates[0].widgetContainer && CalendarApp.views.listview.etemplates[0].widgetContainer.getWidgetById('nm');
      if (listview && listview.activeFilters && listview.activeFilters.search) {
        state.keywords = listview.activeFilters.search;
      }
    }

    // Don't store date or first and last
    delete state.date;
    delete state.first;
    delete state.last;
    delete state.startdate;
    delete state.enddate;
    delete state.start_date;
    delete state.end_date;
    return state;
  }

  /**
   * Set a state previously returned by getState
   *
   * Called by favorites to set a state saved as favorite.
   *
   * @param {object} state containing "name" attribute to be used as "favorite" GET parameter to a nextmatch
   */
  setState(state) {
    var _this = this;
    // State should be an object, not a string, but we'll parse
    if (typeof state == "string") {
      if (state.indexOf('{') != -1 || state == 'null') {
        state = JSON.parse(state);
      }
    }
    if (typeof state.state !== 'object' || !state.state.view) {
      state.state = {
        view: 'week'
      };
    }
    // States with no name (favorites other than No filters) default to
    // today.  Applying a favorite should keep the current date.
    if (!state.state.date) {
      state.state.date = state.name ? this.state.date : new Date();
    }
    if (typeof state.state.weekend == 'undefined') {
      state.state.weekend = true;
    }

    // Hide other views
    var view = CalendarApp.views[state.state.view];
    for (var _view in CalendarApp.views) {
      if (state.state.view != _view && CalendarApp.views[_view]) {
        for (var i = 0; i < CalendarApp.views[_view].etemplates.length; i++) {
          if (typeof CalendarApp.views[_view].etemplates[i] !== 'string' && view.etemplates.indexOf(CalendarApp.views[_view].etemplates[i]) == -1) {
            jQuery(CalendarApp.views[_view].etemplates[i].DOMContainer).hide();
          }
        }
      }
    }
    if (this.sidebox_et2) {
      jQuery(this.sidebox_et2.getInstanceManager().DOMContainer).hide();
    }

    // Check for valid cache
    var cachable_changes = ['date', 'weekend', 'view', 'days', 'planner_view', 'sortby'];
    // @ts-ignore
    var keys = Object.keys(this.state).concat(Object.keys(state.state)).filter(function (value, index, self) {
      return self.indexOf(value) === index;
    });
    for (var i = 0; i < keys.length; i++) {
      var s = keys[i];
      if (this.state[s] !== state.state[s]) {
        if (cachable_changes.indexOf(s) === -1) {
          // Expire daywise cache
          var daywise = egw$1.dataKnownUIDs(CalendarApp.DAYWISE_CACHE_ID);

          // Can't delete from here, as that would disconnect the existing widgets listening
          for (var i = 0; i < daywise.length; i++) {
            egw$1.dataStoreUID(CalendarApp.DAYWISE_CACHE_ID + '::' + daywise[i], null);
          }
          break;
        }
      }
    }

    // Check for a supported client-side view
    if (CalendarApp.views[state.state.view] &&
    // Check that the view is instanciated
    typeof CalendarApp.views[state.state.view].etemplates[0] !== 'string' && CalendarApp.views[state.state.view].etemplates[0].widgetContainer) {
      // Doing an update - this includes the selected view, and the sidebox
      // We set a flag to ignore changes from the sidebox which would
      // cause infinite loops.
      this.state_update_in_progress = true;

      // Sanitize owner so it's always an array
      if (state.state.owner === null || !state.state.owner || typeof state.state.owner.length != 'undefined' && state.state.owner.length == 0) {
        state.state.owner = undefined;
      }
      switch (typeof state.state.owner) {
        case 'undefined':
          state.state.owner = [this.egw.user('account_id')];
          break;
        case 'string':
          state.state.owner = state.state.owner.split(',');
          break;
        case 'number':
          state.state.owner = [state.state.owner];
          break;
        case 'object':
          // An array-like Object or an Array?
          if (!state.state.owner.filter) {
            state.state.owner = jQuery.map(state.state.owner, function (owner) {
              return owner;
            });
          }
      }
      if (state.state.owner.indexOf('0') >= 0) {
        state.state.owner[state.state.owner.indexOf('0')] = this.egw.user('account_id');
      }
      // Remove duplicates
      state.state.owner = state.state.owner.filter(function (value, index, self) {
        return self.indexOf(value) === index;
      });
      // Make sure they're all strings
      state.state.owner = state.state.owner.map(function (owner) {
        return '' + owner;
      });

      // Show the correct number of grids
      var grid_count = 0;
      switch (state.state.view) {
        case 'day':
          grid_count = 1;
          break;
        case 'day4':
        case 'week':
          grid_count = state.state.owner.length >= parseInt('' + this.egw.preference('week_consolidate', 'calendar')) ? 1 : state.state.owner.length;
          break;
        case 'weekN':
          grid_count = parseInt('' + this.egw.preference('multiple_weeks', 'calendar')) || 3;
          break;
        // Month is calculated individually for the month
      }

      var grid = view.etemplates[0].widgetContainer.getWidgetById('view');

      // Show the templates for the current view
      // Needs to be visible while updating so sizing works
      for (var i = 0; i < view.etemplates.length; i++) {
        jQuery(view.etemplates[i].DOMContainer).show();
      }

      /*
      If the count is different, we need to have the correct number
      If the count is > 1, it's either because there are multiple date spans (weekN, month) and we need the correct span
      per row, or there are multiple owners and we need the correct owner per row.
      */
      if (grid) {
        var _framework$applicatio3;
        // Show loading div to hide redrawing
        egw$1.loading_prompt(this.appname, true, egw$1.lang('please wait...'), typeof framework !== 'undefined' ? (_framework$applicatio3 = framework.applications) === null || _framework$applicatio3 === void 0 || (_framework$applicatio3 = _framework$applicatio3.calendar) === null || _framework$applicatio3 === void 0 || (_framework$applicatio3 = _framework$applicatio3.tab) === null || _framework$applicatio3 === void 0 ? void 0 : _framework$applicatio3.contentDiv : false, egwIsMobile() ? 'horizontal' : 'spinner');
        var loading = false;
        var value = [];
        state.state.first = view.start_date(state.state).toJSON();
        // We'll modify this one, so it needs to be a new object
        var date = new Date(state.state.first);

        // Hide all but the first day header
        jQuery(grid.getDOMNode()).toggleClass('hideDayColHeader', state.state.view == 'week' || state.state.view == 'day4');

        // Determine the different end date & varying values
        switch (state.state.view) {
          case 'month':
            var end = state.state.last = view.end_date(state.state);
            grid_count = Math.ceil((end - date.valueOf()) / (1000 * 60 * 60 * 24) / 7);
          // fall through
          case 'weekN':
            for (var week = 0; week < grid_count; week++) {
              var val = {
                id: CalendarApp._daywise_cache_id(date, state.state.owner),
                start_date: date.toJSON(),
                end_date: new Date(date.toJSON()),
                owner: state.state.owner
              };
              val.end_date.setUTCHours(24 * 7 - 1);
              val.end_date.setUTCMinutes(59);
              val.end_date.setUTCSeconds(59);
              val.end_date = val.end_date.toJSON();
              value.push(val);
              date.setUTCHours(24 * 7);
            }
            state.state.last = val.end_date;
            break;
          case 'day':
            var end = state.state.last = view.end_date(state.state).toJSON();
            value.push({
              id: CalendarApp._daywise_cache_id(date, state.state.owner),
              start_date: state.state.first,
              end_date: state.state.last,
              owner: view.owner(state.state)
            });
            break;
          default:
            var end = state.state.last = view.end_date(state.state).toJSON();
            for (var owner = 0; owner < grid_count && owner < state.state.owner.length; owner++) {
              var _owner = grid_count > 1 ? state.state.owner[owner] || 0 : state.state.owner;
              value.push({
                id: CalendarApp._daywise_cache_id(date, _owner),
                start_date: date,
                end_date: end,
                owner: _owner
              });
            }
            break;
        }
        // If we have cached data for the timespan, pass it along
        // Single day with multiple owners still needs owners split to satisfy
        // caching keys, otherwise they'll fetch & cache consolidated
        if (state.state.view == 'day' && state.state.owner.length < parseInt('' + this.egw.preference('day_consolidate', 'calendar'))) {
          var day_value = [];
          for (var i = 0; i < state.state.owner.length; i++) {
            day_value.push({
              start_date: state.state.first,
              end_date: state.state.last,
              owner: state.state.owner[i]
            });
          }
          loading = this._need_data(day_value, state.state);
        } else {
          loading = this._need_data(value, state.state);
        }
        var row_index = 0;

        // Find any matching, existing rows - they can be kept
        grid.iterateOver(function (widget) {
          for (var i = 0; i < value.length; i++) {
            if (widget.id == value[i].id) {
              // Keep it, but move it
              if (i > row_index) {
                for (var j = i - row_index; j > 0; j--) {
                  // Move from the end to the start
                  grid._children.unshift(grid._children.pop());

                  // Swap DOM nodes
                  var a = grid._children[0].getDOMNode().parentNode.parentNode;
                  var a_scroll = jQuery('.calendar_calTimeGridScroll', a).scrollTop();
                  var b = grid._children[1].getDOMNode().parentNode.parentNode;
                  a.parentNode.insertBefore(a, b);

                  // Moving nodes changes scrolling, so set it back
                  jQuery('.calendar_calTimeGridScroll', a).scrollTop(a_scroll);
                }
              } else if (row_index > i) {
                // Swap DOM nodes
                var a = grid._children[row_index].getDOMNode().parentNode.parentNode;
                var _a_scroll = jQuery('.calendar_calTimeGridScroll', a).scrollTop();
                var b = grid._children[i].getDOMNode().parentNode.parentNode;

                // Simple scroll forward, put top on the bottom
                // This makes it faster if they scroll back next
                if (i == 0 && row_index == 1) {
                  jQuery(b).appendTo(b.parentNode);
                  grid._children.push(grid._children.shift());
                } else {
                  grid._children.splice(i, 0, widget);
                  grid._children.splice(row_index + 1, 1);
                  a.parentNode.insertBefore(a, b);
                }

                // Moving nodes changes scrolling, so set it back
                jQuery('.calendar_calTimeGridScroll', a).scrollTop(_a_scroll);
              }
              break;
            }
          }
          row_index++;
        }, this, et2_calendar_view);
        row_index = 0;

        // Set rows that need it
        var was_disabled = [];
        grid.iterateOver(function (widget) {
          was_disabled[row_index] = false;
          if (row_index < value.length) {
            was_disabled[row_index] = widget.options.disabled;
            widget.set_disabled(false);
          } else {
            widget.set_disabled(true);
          }
          row_index++;
        }, this, et2_calendar_view);
        row_index = 0;
        grid.iterateOver(function (widget) {
          if (row_index >= value.length) return;

          // Clear height to make sure there's correct calculations
          widget.div.css("height", "");
          if (widget.set_show_weekend) {
            widget.set_show_weekend(view.show_weekend(state.state));
          }
          if (widget.set_granularity) {
            if (widget.loader) widget.loader.show();
            widget.set_granularity(view.granularity(state.state));
          }
          if (widget.id == value[row_index].id && widget.get_end_date().getUTCFullYear() == value[row_index].end_date.substring(0, 4) && widget.get_end_date().getUTCMonth() + 1 == value[row_index].end_date.substring(5, 7) && widget.get_end_date().getUTCDate() == value[row_index].end_date.substring(8, 10)) {
            // Do not need to re-set this row, but we do need to re-do
            // the times, as they may have changed
            widget.resizeTimes();
            window.setTimeout(jQuery.proxy(widget.set_header_classes, widget), 0);

            // If disabled while the daycols were loaded, they won't load their events
            for (var day = 0; was_disabled[row_index] && day < widget.day_widgets.length; day++) {
              egw$1.dataStoreUID(widget.day_widgets[day].registeredUID, egw$1.dataGetUIDdata(widget.day_widgets[day].registeredUID).data);
            }
            widget.set_owner(value[row_index].owner);

            // Hide loader
            widget.loader.hide();
            row_index++;
            return;
          }
          if (widget.set_value) {
            widget.set_value(value[row_index++]);
          }
        }, this, et2_calendar_view);
      } else if (state.state.view !== 'listview') {
        var _loop = function _loop(updater) {
            if (typeof view[updater] === 'function') {
              var _value3 = view[updater].call(_this, state.state);
              if (updater === 'start_date') {
                state.state.first = _this.date.toString(_value3);
              }
              if (updater === 'end_date') {
                state.state.last = _this.date.toString(_value3);
              }

              // Set value
              for (i = 0; i < view.etemplates.length; i++) {
                view.etemplates[i].widgetContainer.iterateOver(function (widget) {
                  if (typeof widget['set_' + updater] === 'function') {
                    widget['set_' + updater](_value3);
                  }
                }, _this, et2_calendar_view);
              }
            }
          },
          i;
        // Simple, easy case - just one widget for the selected time span. (planner)
        // Update existing view's special attribute filters, defined in the view list
        for (var updater of view.getAllFuncs(view)) {
          _loop(updater);
        }
        var _value2 = [{
          start_date: state.state.first,
          end_date: state.state.last
        }];
        loading = this._need_data(_value2, state.state);
      }
      // Include first & last dates in state, mostly for server side processing
      if (state.state.first && state.state.first.toJSON) state.state.first = state.state.first.toJSON();
      if (state.state.last && state.state.last.toJSON) state.state.last = state.state.last.toJSON();

      // Toggle todos
      var frameworkApp = framework.getApplicationByName("calendar");
      if ((state.state.view == 'day' || this.state.view == 'day') && jQuery(view.etemplates[0].DOMContainer).is(':visible')) {
        if (state.state.view == 'day' && state.state.owner.length === 1 && !isNaN(state.state.owner) && state.state.owner[0] >= 0 && !egwIsMobile()
        // Check preferences and permissions
        && egw$1.user('apps')['infolog'] && egw$1.preference('cal_show', 'infolog') !== '0') {
          if (typeof frameworkApp.showRight == "function") {
            frameworkApp.updateComplete.then( /*#__PURE__*/_asyncToGenerator(function* () {
              var _view$etemplates$;
              yield frameworkApp.showRight();
              view.etemplates[0].resize();
              (_view$etemplates$ = view.etemplates[1]) === null || _view$etemplates$ === void 0 || _view$etemplates$.resize();
            }));
          } else {
            // Set width to 70%, otherwise if a scrollbar is needed for the view, it will conflict with the todo list
            jQuery(CalendarApp.views.day.etemplates[0].DOMContainer).css("width", "70%");
            jQuery(view.etemplates[1].DOMContainer).css({
              "left": "70%"
            });
          }

          // TODO: Maybe some caching here
          this.egw.jsonq('calendar_uiviews::ajax_get_todos', [state.state.date, state.state.owner[0]], function (data) {
            this.getWidgetById('label').set_value(data.label || '');
            this.getWidgetById('todos').set_value({
              content: data.todos || ''
            });
          }, view.etemplates[1].widgetContainer);
          view.etemplates[0].resize();
        } else {
          if (typeof frameworkApp.hideRight == "function") {
            frameworkApp.hideRight();
          } else {
            jQuery(CalendarApp.views.day.etemplates[1].DOMContainer).css("left", "100%");
            jQuery(CalendarApp.views.day.etemplates[1].DOMContainer).hide();
            jQuery(CalendarApp.views.day.etemplates[0].DOMContainer).css("width", "100%");
          }
          view.etemplates[0].widgetContainer.iterateOver(function (w) {
            w.set_width('100%');
          }, this, et2_calendar_timegrid);
        }
      } else if (jQuery(view.etemplates[0].DOMContainer).is(':visible')) {
        if (typeof frameworkApp.hideRight == "function") {
          frameworkApp.updateComplete.then( /*#__PURE__*/_asyncToGenerator(function* () {
            yield frameworkApp.hideRight();
            view.etemplates[0].resize();
          }));
        }
        view.etemplates[0].DOMContainer.style.width = "";
        view.etemplates[0].widgetContainer.iterateOver(function (w) {
          w.set_width('100%');
        }, this, et2_calendar_timegrid);
      }

      // List view (nextmatch) has slightly different fields
      if (state.state.view === 'listview') {
        state.state.startdate = state.state.date;
        if (state.state.startdate.toJSON) {
          state.state.startdate = state.state.startdate.toJSON();
        }
        if (state.state.end_date) {
          state.state.enddate = state.state.end_date;
        }
        if (state.state.enddate && state.state.enddate.toJSON) {
          state.state.enddate = state.state.enddate.toJSON();
        }
        state.state.col_filter = {
          participant: state.state.owner
        };
        state.state.search = state.state.keywords ? state.state.keywords : state.state.search;
        delete state.state.keywords;
        var nm = view.etemplates[0].widgetContainer.getWidgetById('nm');

        // 'Custom' filter needs an end date
        if (nm.activeFilters.filter === 'custom' && !state.state.end_date) {
          state.state.enddate = state.state.last;
        }
        if (state.state.enddate && state.state.startdate && state.state.startdate > state.state.enddate) {
          state.state.enddate = state.state.startdate;
        }
        nm.applyFilters(state.state);

        // Try to keep last value up to date with what's in nextmatch
        if (nm.activeFilters.enddate) {
          this.state.last = nm.activeFilters.enddate;
        }
        // Updates the display of start & end date
        this.filter_change();
      } else {
        // Turn off nextmatch's automatic stuff - it won't work while it
        // is hidden, and can cause an infinite loop as it tries to layout.
        // (It will automatically re-start when shown)
        try {
          var nm = CalendarApp.views.listview.etemplates[0].widgetContainer.getWidgetById('nm');
          nm.controller._grid.doInvalidate = false;
        } catch (e) {}
        // Other views do not search
        delete state.state.keywords;
      }
      this.state = jQuery.extend({}, state.state);

      /* Update re-orderable calendars */
      this._sortable();

      /* Update sidebox widgets to show current value*/
      if (this.sidebox_hooked_templates.length) {
        for (var j = 0; j < this.sidebox_hooked_templates.length; j++) {
          var sidebox = this.sidebox_hooked_templates[j];
          // Remove any destroyed or not valid templates
          if (!sidebox.getInstanceManager || !sidebox.getInstanceManager()) {
            this.sidebox_hooked_templates.splice(j, 1, 0);
            continue;
          }
          sidebox.iterateOver(function (widget) {
            if (widget.id == 'view') {
              // View widget has a list of state settings, which require special handling
              for (var i = 0; i < widget.options.select_options.length; i++) {
                var option_state = JSON.parse(widget.options.select_options[i].value) || [];
                var match = true;
                for (var os_key in option_state) {
                  // Sometimes an optional state variable is not yet defined (sortby, days, etc)
                  match = match && (option_state[os_key] == this.state[os_key] || typeof this.state[os_key] == 'undefined');
                }
                if (match) {
                  widget.set_value(widget.options.select_options[i].value);
                  return;
                }
              }
            } else if (widget.id == 'keywords') {
              widget.set_value('');
            } else if (typeof state.state[widget.id] !== 'undefined' && state.state[widget.id] != widget.getValue()) {
              // Update widget.  This may trigger an infinite loop of
              // updates, so we do it after changing this.state and set a flag
              try {
                widget.set_value(state.state[widget.id]);
              } catch (e) {
                widget.set_value('');
              }
            } else if (typeof widget.set_value == "function" && typeof state.state[widget.id] == 'undefined') {
              // No value, clear it
              widget.set_value('');
            }
          }, this, et2_IInput);
        }
      }

      // If current state matches a favorite, highlight it
      this.highlight_favorite();

      // Update app header
      this.set_app_header(view.header(state.state));

      // Reset auto-refresh timer
      this._set_autorefresh();

      // Sidebox is updated, we can clear the flag
      this.state_update_in_progress = false;

      // Update saved state in preferences
      var save = {};
      for (var i = 0; i < CalendarApp.states_to_save.length; i++) {
        save[CalendarApp.states_to_save[i]] = this.state[CalendarApp.states_to_save[i]];
      }
      egw$1.set_preference('calendar', 'saved_states', save);

      // Trigger resize to get correct sizes, as they may have sized while
      // hidden
      for (var i = 0; i < view.etemplates.length; i++) {
        view.etemplates[i].resize();
      }

      // If we need to fetch data from the server, it will hide the loader
      // when done but if everything is in the cache, hide from here.
      if (!loading) {
        window.setTimeout(jQuery.proxy(function () {
          egw$1.loading_prompt(this.appname, false);
        }, this), 500);
      }
      return;
    }
    // old calendar state handling on server-side (incl. switching to and from listview)
    var menuaction = 'calendar.calendar_uiviews.index';
    if (typeof state.state != 'undefined' && (typeof state.state.view == 'undefined' || state.state.view == 'listview')) {
      if (state.name) {
        // 'blank' is the special name for no filters, send that instead of the nice translated name
        state.state.favorite = jQuery.isEmptyObject(state) || jQuery.isEmptyObject(state.state || state.filter) ? 'blank' : state.name.replace(/[^A-Za-z0-9-_]/g, '_');
        // set date for "No Filter" (blank) favorite to todays date
        if (state.state.favorite == 'blank') {
          state.state.date = formatDate(new Date(), {
            dateFormat: 'yymmdd'
          });
        }
      }
      menuaction = 'calendar.calendar_uilist.listview';
      state.state.ajax = 'true';
      // check if we already use et2 / are in listview
      if (this.et2 || etemplate2 && etemplate2.getByApplication('calendar')) {
        // current calendar-code can set regular calendar states only via a server-request :(
        // --> check if we only need to set something which can be handeled by nm internally
        // or we need a redirect
        // ToDo: pass them via nm's get_rows call to server (eg. by passing state), so we dont need a redirect
        var current_state = this.getState();
        var need_redirect = false;
        for (var attr in current_state) {
          switch (attr) {
            case 'cat_id':
            case 'owner':
            case 'filter':
              if (state.state[attr] != current_state[attr]) {
                need_redirect = true;
                // reset of attributes managed on server-side
                if (state.state.favorite === 'blank') {
                  switch (attr) {
                    case 'cat_id':
                      state.state.cat_id = 0;
                      break;
                    case 'owner':
                      state.state.owner = egw$1.user('account_id');
                      break;
                    case 'filter':
                      state.state.filter = 'default';
                      break;
                  }
                }
                break;
              }
              break;
            case 'view':
              // "No filter" (blank) favorite: if not in listview --> stay in that view
              if (state.state.favorite === 'blank' && current_state.view != 'listview') {
                menuaction = 'calendar.calendar_uiviews.index';
                delete state.state.ajax;
                need_redirect = true;
              }
          }
        }
        if (!need_redirect) {
          return super.setState([state]);
        }
      }
    }
    // setting internal state now, that linkHandler does not intercept switching from listview to any old view
    this.state = jQuery.extend({}, state.state);
    if (this.sidebox_et2) {
      jQuery(this.sidebox_et2.getInstanceManager().DOMContainer).show();
    }
    var query = jQuery.extend({
      menuaction: menuaction
    }, state.state || {});

    // prepend an owner 0, to reset all owners and not just set given resource type
    if (typeof query.owner != 'undefined') {
      query.owner = '0,' + (typeof query.owner == 'object' ? query.owner.join(',') : ('' + query.owner).replace('0,', ''));
    }
    this.egw.open_link(this.egw.link('/index.php', query), 'calendar');

    // Stop the normal bubbling if this is called on click
    return false;
  }

  /**
   * Check to see if any of the selected is an event widget
   * Used to separate grid actions from event actions
   *
   * @param {egwAction} _action
   * @param {egwActioObject[]} _selected
   * @returns {boolean} Is any of the selected an event widget
   */
  is_event(_action, _selected) {
    var is_widget = false;
    for (var i = 0; i < _selected.length; i++) {
      if (_selected[i].iface.getWidget() && _selected[i].iface.getWidget().instanceOf(et2_calendar_event)) {
        is_widget = true;
      }

      // Also check classes, usually indicating permission
      if (_action.data && _action.data.enableClass) {
        is_widget = is_widget && jQuery(_selected[i].iface.getDOMNode()).hasClass(_action.data.enableClass);
      }
      if (_action.data && _action.data.disableClass) {
        is_widget = is_widget && !jQuery(_selected[i].iface.getDOMNode()).hasClass(_action.data.disableClass);
      }
    }
    return is_widget;
  }

  /**
   * Enable/Disable custom Date-time for set Alarm
   *
   * @param {widget object} _widget new_alarm[options] selectbox
   */
  alarm_custom_date(selectbox, _widget) {
    var alarm_date = this.et2.getWidgetById('new_alarm[date]');
    var alarm_options = _widget || this.et2.getWidgetById('new_alarm[options]');
    var start = this.et2.getWidgetById('start');
    if (alarm_date && alarm_options && start) {
      if (alarm_options.getValue() != '0') {
        alarm_date.set_class('calendar_alarm_date_display');
      } else {
        alarm_date.set_class('');
      }
      var startDate = typeof start.getValue != 'undefined' ? start.getValue() : start.value;
      if (startDate) {
        var date = new Date(startDate);
        date.setTime(date.getTime() - 1000 * parseInt(alarm_options.getValue()));
        alarm_date.set_value(date);
      }
    }
  }

  /**
   * Set alarm options based on WD/Regular event user preferences
   * Gets fired by wholeday checkbox.  This is mainly for display purposes,
   * the default alarm is calculated on the server as well.
   *
   * @param {egw object} _egw
   * @param {widget object} _widget whole_day checkbox
   */
  set_alarmOptions_WD(_egw, _widget) {
    var alarm = this.et2.getWidgetById('alarm');
    if (!alarm) return; // no default alarm
    var content = this.et2.getArrayMgr('content').data;
    var start = this.et2.getWidgetById('start');
    var self = this;
    var time = alarm.cells[1][0].widget;
    var event = alarm.cells[1][1].widget;
    // Convert a seconds of time to a translated label
    var _secs_to_label = function _secs_to_label(_secs) {
      var label = '';
      if (_secs < 3600) {
        label = self.egw.lang('%1 minutes', _secs / 60);
      } else if (_secs < 86400) {
        label = self.egw.lang('%1 hours', _secs / 3600);
      } else {
        label = self.egw.lang('%1 days', _secs / (3600 * 24));
      }
      return label;
    };
    if (content['alarm'] && typeof content['alarm'] && typeof content['alarm'][1]['default'] == 'undefined') {
      // user deleted alarm --> nothing to do
    } else {
      var def_alarm = this.egw.preference(_widget.get_value() === "true" ? 'default-alarm-wholeday' : 'default-alarm', 'calendar');
      if (!def_alarm && def_alarm !== 0)
        // no alarm
        {
          jQuery('#calendar-edit_alarm > tbody :nth-child(1)').hide();
        } else {
        jQuery('#calendar-edit_alarm > tbody :nth-child(1)').show();
        start.set_hours(0);
        start.set_minutes(0);
        time.set_value(start.get_value());
        time.set_value(new Date(new Date(start.get_value()).valueOf() - 60 * def_alarm * 1000).toJSON());
        event.set_value(_secs_to_label(60 * def_alarm));
      }
    }
  }

  /**
   * Clear all calendar data from egw.data cache
   */
  _clear_cache(integration_app) {
    // Full refresh, clear the caches
    var events = egw$1.dataKnownUIDs('calendar');
    for (var i = 0; i < events.length; i++) {
      var event_data = egw$1.dataGetUIDdata("calendar::" + events[i]).data || {
        app: "calendar"
      };
      if (!integration_app || integration_app && event_data && event_data.app === integration_app) {
        // Remove entry
        egw$1.dataStoreUID("calendar::" + events[i], null);
        // Delete from cache
        egw$1.dataDeleteUID('calendar::' + events[i]);
      }
    }
    // If just removing one app, leave the columns alone
    if (integration_app) return;
    var daywise = egw$1.dataKnownUIDs(CalendarApp.DAYWISE_CACHE_ID);
    for (var i = 0; i < daywise.length; i++) {
      // Empty to clear existing widgets
      egw$1.dataStoreUID(CalendarApp.DAYWISE_CACHE_ID + '::' + daywise[i], null);
    }
  }

  /**
   * Take the date range(s) in the value and decide if we need to fetch data
   * for the date ranges, or if they're already cached fill them in.
   *
   * @param {Object} value
   * @param {Object} state
   *
   * @return {boolean} Data was requested
   */
  _need_data(value, state) {
    var need_data = false;

    // Determine if we're showing multiple owners seperate or consolidated
    var seperate_owners = false;
    var last_owner = value.length ? value[0].owner || 0 : 0;
    for (var i = 0; i < value.length && !seperate_owners; i++) {
      seperate_owners = seperate_owners || last_owner !== value[i].owner;
    }
    for (var i = 0; i < value.length; i++) {
      var t = new Date(value[i].start_date);
      var end = new Date(value[i].end_date);
      do {
        // Cache is by date (and owner, if seperate)
        var date = t.getUTCFullYear() + sprintf('%02d', t.getUTCMonth() + 1) + sprintf('%02d', t.getUTCDate());
        var cache_id = CalendarApp._daywise_cache_id(date, seperate_owners && value[i].owner ? value[i].owner : state.owner || false);
        if (egw$1.dataHasUID(cache_id)) {
          var c = egw$1.dataGetUIDdata(cache_id);
          if (c.data && c.data !== null) {
            // There is data, pass it along now
            value[i][date] = [];
            for (var j = 0; j < c.data.length; j++) {
              if (egw$1.dataHasUID('calendar::' + c.data[j])) {
                value[i][date].push(egw$1.dataGetUIDdata('calendar::' + c.data[j]).data);
              } else {
                need_data = true;
              }
            }
          } else {
            need_data = true;
            // Assume it's empty, if there is data it will be filled later
            egw$1.dataStoreUID(cache_id, []);
          }
        } else {
          need_data = true;
          // Assume it's empty, if there is data it will be filled later
          egw$1.dataStoreUID(cache_id, []);
        }
        t.setUTCDate(t.getUTCDate() + 1);
      } while (t < end);

      // Some data is missing for the current owner, go get it
      if (need_data && seperate_owners) {
        this._fetch_data(jQuery.extend({}, state, {
          owner: value[i].owner,
          selected_owners: state.owner
        }), this.sidebox_et2 ? null : this.et2.getInstanceManager());
        need_data = false;
      }
    }

    // Some data was missing, go get it
    if (need_data && !seperate_owners) {
      this._fetch_data(state, this.sidebox_et2 ? null : this.et2.getInstanceManager());
    }
    return need_data;
  }

  /**
   * Use the egw.data system to get data from the calendar list for the
   * selected time span.
   *
   * As long as the other filters are the same (category, owner, status) we
   * cache the data.
   *
   * @param {Object} state
   * @param {etemplate2} [instance] If the full calendar app isn't loaded
   *	(home app), pass a different instance to use it to get the data
   * @param {number} [start] Result offset.  Internal use only
   * @param {string[]} [specific_ids] Only request the given IDs
   */
  _fetch_data(state, instance, start, specific_ids) {
    if (!this.sidebox_et2 && !instance) {
      return;
    }
    if (typeof start === 'undefined') {
      start = 0;
    }

    // Category needs to be false if empty, not an empty array or string
    var cat_id = state.cat_id ? state.cat_id : false;
    if (cat_id && typeof cat_id.join != 'undefined') {
      if (cat_id.join('') == '') cat_id = false;
    }
    // Make sure cat_id reaches to server in array format
    if (cat_id && typeof cat_id == 'string' && cat_id != "0") cat_id = cat_id.split(',');
    var query = jQuery.extend({}, {
      get_rows: 'calendar.calendar_uilist.get_rows',
      row_id: 'row_id',
      startdate: state.first || state.date,
      enddate: state.last,
      col_filter: {
        // Participant must be an array or it won't work
        participant: typeof state.owner == 'string' || typeof state.owner == 'number' ? [state.owner] : state.owner,
        include_videocalls: state.include_videocalls
      },
      filter: 'custom',
      // Must be custom to get start & end dates
      status_filter: state.status_filter,
      cat_id: cat_id,
      csv_export: false,
      selected_owners: state.selected_owners
    });
    // Show ajax loader
    if (typeof framework !== 'undefined') {
      var _framework$applicatio4;
      (_framework$applicatio4 = framework.applications) === null || _framework$applicatio4 === void 0 || (_framework$applicatio4 = _framework$applicatio4.calendar) === null || _framework$applicatio4 === void 0 || (_framework$applicatio4 = _framework$applicatio4.sidemenuEntry) === null || _framework$applicatio4 === void 0 || _framework$applicatio4.showAjaxLoader();
    }
    if (state.view === 'planner' && state.sortby === 'user') {
      query.order = 'participants';
    } else if (state.view === 'planner' && state.sortby === 'category') {
      query.order = 'categories';
    }

    // Already in progress?
    var query_string = JSON.stringify(query);
    if (this._queries_in_progress.indexOf(query_string) != -1) {
      return;
    }
    this._queries_in_progress.push(query_string);
    this.egw.dataFetch(instance ? instance.etemplate_exec_id : this.sidebox_et2.getInstanceManager().etemplate_exec_id, specific_ids ? {
      refresh: specific_ids
    } : {
      start: start,
      num_rows: 400
    }, query, this.appname, function calendar_handleResponse(data) {
      var idx = this._queries_in_progress.indexOf(query_string);
      if (idx >= 0) {
        this._queries_in_progress.splice(idx, 1);
      }
      //console.log(data);

      // Look for any updated select options
      if (data.rows && data.rows.sel_options && this.sidebox_et2) {
        for (var field in data.rows.sel_options) {
          var widget = this.sidebox_et2.getWidgetById(field);
          if (widget && widget.set_select_options) {
            // Merge in new, update label of existing
            for (var i in data.rows.sel_options[field]) {
              var found = false;
              var option = data.rows.sel_options[field][i];
              for (var j in widget.select_options) {
                if (option.value == widget.select_options[j].value) {
                  widget.select_options[j].label = option.label;

                  // Do not let remote options stay remote or they'll disappear
                  if (typeof widget.select_options[j].class == "string") {
                    widget.select_options[j].class = widget.select_options[j].class.replace("remote", "");
                  }
                  found = true;
                  break;
                }
              }
              if (!found) {
                if (!widget.select_options.push) {
                  widget.select_options = [];
                }
                widget.select_options.push(option);
              }
            }
            var in_progress = app.calendar.state_update_in_progress;
            app.calendar.state_update_in_progress = true;
            widget.set_select_options(widget.select_options);
            widget.set_value(widget.getValue());
            app.calendar.state_update_in_progress = in_progress;
          }
        }
      }
      if (data.order && data.total) {
        this._update_events(state, data.order);
      }

      // More rows?
      if (data.order.length + start < data.total) {
        // Wait a bit, let UI do something.
        window.setTimeout(function () {
          app.calendar._fetch_data(state, instance, start + data.order.length);
        }, 100);
      }
      // Hide AJAX loader
      else if (typeof framework !== 'undefined') {
        var _framework$applicatio5;
        (_framework$applicatio5 = framework.applications) === null || _framework$applicatio5 === void 0 || (_framework$applicatio5 = _framework$applicatio5.calendar) === null || _framework$applicatio5 === void 0 || _framework$applicatio5.sidemenuEntry.hideAjaxLoader();
        egw$1.loading_prompt('calendar', false);
      }
    }, this, null);
  }
  /**
   * Pre-fetch the members of any group participants
   *
   * This is done to avoid rewriting since group fetching is async.  We fetch missing group members in advance,
   * then hold the data in the sidebox select options for immediate access when checking if an event should be displayed
   * in a particular calendar.
   *
   * @param event
   * @return Promise| null
   */
  _fetch_group_members(event) {
    var _this2 = this;
    return _asyncToGenerator(function* () {
      var groups = [];
      var option_owner = null;
      var options;
      if (_this2.sidebox_et2 && _this2.sidebox_et2.getWidgetById('owner')) {
        option_owner = _this2.sidebox_et2.getWidgetById('owner');
      } else {
        option_owner = _this2.et2.getArrayMgr("sel_options").getRoot().getEntry('owner') || {
          select_options: []
        };
      }
      options = option_owner.select_options;
      var _loop2 = function* _loop2(id) {
        if (parseInt(id) >= 0 || isNaN(parseInt(id))) {
          return 1; // continue
        }
        var resource = options.find(o => o.value === id);
        if (!resource || resource && !resource.resources) {
          groups.push(parseInt(id));
        }
      };
      for (var id of Object.keys(event.participants)) {
        if (yield* _loop2(id)) continue;
      }

      // Find missing groups
      var cache_key = groups.join("_");
      if (groups.length && typeof _this2._group_query_cache[cache_key] === "undefined") {
        _this2._group_query_cache[cache_key] = _this2.egw.request("calendar.calendar_owner_etemplate_widget.ajax_owner", [groups]).then(data => {
          options = option_owner.select_options.concat(Object.values(data));
          option_owner.select_options = options;
        }).finally(() => {
          delete _this2._group_query_cache[cache_key];
        });
      }
      if (typeof _this2._group_query_cache[cache_key] !== "undefined") {
        return _this2._group_query_cache[cache_key];
      } else {
        return null;
      }
    })();
  }

  /**
   * We have a list of calendar UIDs of events that need updating.
   * Public wrapper for _update_events so we can call it from server
   */
  update_events(uids) {
    return this._update_events(this.state, uids);
  }

  /**
   * We have a list of calendar UIDs of events that need updating.
   *
   * The event data should already be in the egw.data cache, we just need to
   * figure out where they need to go, and update the needed parent objects.
   *
   * Already existing events will have already been updated by egw.data
   * callbacks.
   *
   * @param {Object} state Current state for update, used to determine what to update
   * @param data
   */
  _update_events(state, data) {
    var updated_days = {};

    // Events can span for longer than we are showing
    var first = new Date(state.first);
    var last = new Date(state.last);
    var bounds = {
      first: '' + first.getUTCFullYear() + sprintf('%02d', first.getUTCMonth() + 1) + sprintf('%02d', first.getUTCDate()),
      last: '' + last.getUTCFullYear() + sprintf('%02d', last.getUTCMonth() + 1) + sprintf('%02d', last.getUTCDate())
    };
    // Seperate owners, or consolidated?
    var multiple_owner = typeof state.owner != 'string' && state.owner.length > 1 && (state.view == 'day' && state.owner.length < parseInt('' + this.egw.preference('day_consolidate', 'calendar')) || ['week', 'day4'].indexOf(state.view) !== -1 && state.owner.length < parseInt('' + this.egw.preference('week_consolidate', 'calendar')));
    for (var i = 0; i < data.length; i++) {
      var record = this.egw.dataGetUIDdata(data[i]);
      if (record && record.data) {
        if (typeof updated_days[record.data.date] === 'undefined') {
          // Check to make sure it's in range first, record.data.date is start date
          // and could be before our start
          if (record.data.date >= bounds.first && record.data.date <= bounds.last ||
          // Or it's for a day we already have
          typeof this.egw.dataGetUIDdata('calendar_daywise::' + record.data.date) !== 'undefined') {
            updated_days[record.data.date] = [];
          }
        }
        if (typeof updated_days[record.data.date] != 'undefined') {
          // Copy, to avoid unwanted changes by reference
          updated_days[record.data.date].push(record.data.row_id);
        }

        // Check for multi-day events listed once
        // Date must stay a string or we might cause problems with nextmatch
        var dates = {
          start: typeof record.data.start === 'string' ? record.data.start : record.data.start.toJSON(),
          end: typeof record.data.end === 'string' ? record.data.end : record.data.end.toJSON()
        };
        if (dates.start.substr(0, 10) !== dates.end.substr(0, 10)) {
          var end = new Date(Math.min(new Date(record.data.end).valueOf(), new Date(state.last).valueOf()));
          end.setUTCHours(23);
          end.setUTCMinutes(59);
          end.setUTCSeconds(59);
          var t = new Date(Math.max(new Date(record.data.start).valueOf(), new Date(state.first).valueOf()));
          do {
            var expanded_date = '' + t.getUTCFullYear() + sprintf('%02d', t.getUTCMonth() + 1) + sprintf('%02d', t.getUTCDate());

            // Avoid events ending at midnight having a 0 length event the next day
            if (t.toJSON().substr(0, 10) === dates.end.substr(0, 10) && dates.end.substr(11, 8) === '00:00:00') break;
            if (typeof updated_days[expanded_date] === 'undefined') {
              // Check to make sure it's in range first, expanded_date could be after our end
              if (expanded_date >= bounds.first && expanded_date <= bounds.last) {
                updated_days[expanded_date] = [];
              }
            }
            if (record.data.date !== expanded_date && typeof updated_days[expanded_date] !== 'undefined') {
              // Copy, to avoid unwanted changes by reference
              updated_days[expanded_date].push(record.data.row_id);
            }
            t.setUTCDate(t.getUTCDate() + 1);
          } while (end >= t);
        }
      }
    }

    // Now we know which days changed, so we pass it on
    for (var day in updated_days) {
      // Might be split by user, so we have to check that too
      for (var i = 0; i < (typeof state.owner == 'object' ? state.owner.length : 1); i++) {
        var owner = multiple_owner ? state.owner[i] : state.owner;
        var cache_id = CalendarApp._daywise_cache_id(day, owner);
        if (egw$1.dataHasUID(cache_id)) {
          // Don't lose any existing data, just append
          var c = egw$1.dataGetUIDdata(cache_id);
          if (c.data && c.data !== null) {
            // Avoid duplicates
            var data = c.data.concat(updated_days[day]).filter(function (value, index, self) {
              return self.indexOf(value) === index;
            });
            this.egw.dataStoreUID(cache_id, data);
          }
        } else {
          this.egw.dataStoreUID(cache_id, updated_days[day]);
        }
        if (!multiple_owner) {
          break;
        }
      }
    }
    egw$1.loading_prompt(this.appname, false);
  }
  /**
   * The sidebox filters use some non-standard and not-exposed options.  They
   * are set up here.
   *
   */
  _setup_sidebox_filters() {}

  /**
   * Record view templates so we can quickly switch between them.
   *
   * @param {etemplate2} _et2 etemplate2 template that was just loaded
   * @param {String} _name Name of the template
   */
  _et2_view_init(_et2, _name) {
    var hidden = typeof this.state.view !== 'undefined';
    var all_loaded = this.sidebox_et2 !== null;

    // Avoid home portlets using our templates, and get them right
    if (_et2.uniqueId.indexOf('portlet') === 0) {
      return;
    }

    // Skip templates not involved in main view
    if (['calendar.conflicts', 'calendar.add'].includes(_name)) {
      return;
    }

    // Flag to make sure we don't hide non-view templates
    var view_et2 = false;
    for (var view in CalendarApp.views) {
      var index = CalendarApp.views[view].etemplates.indexOf(_name);
      if (index > -1) {
        view_et2 = true;
        CalendarApp.views[view].etemplates[index] = _et2;
        // If a template disappears, we want to release it
        jQuery(_et2.DOMContainer).one('clear', jQuery.proxy(function () {
          this.view.etemplates[this.index] = _name;
        }, jQuery.extend({}, {
          view: CalendarApp.views[view],
          index: "" + index,
          name: _name
        })));
        if (this.state.view === view) {
          hidden = false;
        }
      }
      CalendarApp.views[view].etemplates.forEach(function (et) {
        all_loaded = all_loaded && typeof et !== 'string';
      });
    }

    // Add some extras to the nextmatch so it can keep the dates in sync with
    // those in the sidebox calendar.  Care must be taken to not trigger any
    // sort of refresh or update, as that may resulte in infinite loops so these
    // are only used for the 'week' and 'month' filters, and we just update the
    // date range
    if (_name == 'calendar.list') {
      var nm = _et2.widgetContainer.getWidgetById('nm');
      if (nm) {
        // Avoid unwanted refresh immediately after load
        nm.controller._grid.doInvalidate = false;

        // Preserve pre-set search
        if (nm.activeFilters.search) {
          this.state.keywords = nm.activeFilters.search;
        }
        // Bind to keep search up to date
        jQuery(nm.getWidgetById('search').getDOMNode()).on('change', function () {
          app.calendar.state.search = jQuery('input', this).val();
        });
        nm.set_startdate = jQuery.proxy(function (date) {
          this.state.first = this.date.toString(new Date(date));
        }, this);
        nm.set_enddate = jQuery.proxy(function (date) {
          this.state.last = this.date.toString(new Date(date));
        }, this);
      }
    }

    // Start hidden, except for current view
    if (view_et2) {
      if (hidden) {
        jQuery(_et2.DOMContainer).hide();
      }
    } else {
      var app_name = _name.split('.')[0];
      if (app_name && app_name != 'calendar' && egw$1.app(app_name)) {
        // A template from another application?  Keep it up to date as state changes
        this.sidebox_hooked_templates.push(_et2.widgetContainer);
        // If it leaves (or reloads) remove it
        jQuery(_et2.DOMContainer).one('clear', jQuery.proxy(function () {
          if (app.calendar) {
            app.calendar.sidebox_hooked_templates.splice(this, 1, 0);
          }
        }, this.sidebox_hooked_templates.length - 1));
      }
    }
    if (all_loaded) {
      jQuery(window).trigger('resize');
      this.setState({
        state: this.state
      });

      // Hide loader after 1 second as a fallback, it will also be hidden
      // after loading is complete.
      window.setTimeout(jQuery.proxy(function () {
        egw$1.loading_prompt(this.appname, false);
      }, this), 1000);

      // Start calendar-wide autorefresh timer to include more than just nm
      this._set_autorefresh();
    }
  }

  /**
   * Set a refresh timer that works for the current view.
   * The nextmatch goes into an infinite loop if we let it autorefresh while
   * hidden.
   */
  _set_autorefresh() {
    // Listview not loaded
    if (typeof CalendarApp.views.listview.etemplates[0] == 'string') return;
    var nm = CalendarApp.views.listview.etemplates[0].widgetContainer.getWidgetById('nm');
    // nextmatch missing
    if (!nm) return;
    var refresh_preference = "nextmatch-" + nm.options.settings.columnselection_pref + "-autorefresh";
    var time = this.egw.preference(refresh_preference, 'calendar');
    if (this.state.view == 'listview' && time) {
      nm._set_autorefresh(time);
      return;
    } else {
      nm._set_autorefresh(0);
    }
    var self = this;
    var refresh = function refresh() {
      // Deleted events are not coming properly, so clear it all
      self._clear_cache();
      // Force redraw to current state
      self.setState({
        state: self.state
      });

      // This is a fast update, but misses deleted events
      //app.calendar._fetch_data(app.calendar.state);
    };

    // Start / update timer
    if (this._autorefresh_timer) {
      window.clearInterval(this._autorefresh_timer);
      this._autorefresh_timer = null;
    }
    if (time > 0) {
      this._autorefresh_timer = setInterval(jQuery.proxy(refresh, this), time * 1000);
    }

    // Bind to tab show/hide events, so that we don't bother refreshing in the background
    jQuery(nm.getInstanceManager().DOMContainer.parentNode).on('hide.calendar', jQuery.proxy(function (e) {
      // Stop
      window.clearInterval(this._autorefresh_timer);
      jQuery(e.target).off(e);
      if (!time) return;

      // If the autorefresh time is up, bind once to trigger a refresh
      // (if needed) when tab is activated again
      this._autorefresh_timer = setTimeout(jQuery.proxy(function () {
        // Check in case it was stopped / destroyed since
        if (!this._autorefresh_timer) return;
        jQuery(nm.getInstanceManager().DOMContainer.parentNode).one('show.calendar',
        // Important to use anonymous function instead of just 'this.refresh' because
        // of the parameters passed
        jQuery.proxy(function () {
          refresh();
        }, this));
      }, this), time * 1000);
    }, this));
    jQuery(nm.getInstanceManager().DOMContainer.parentNode).on('show.calendar', jQuery.proxy(function (e) {
      // Start normal autorefresh timer again
      this._set_autorefresh(this.egw.preference(refresh_preference, 'calendar'));
      jQuery(e.target).off(e);
    }, this));
  }

  /**
   * Initialization function in order to set/unset
   * categories status.
   *
   */
  category_report_init() {
    var content = this.et2.getArrayMgr('content').data;
    for (var i = 1; i < content.grid.length; i++) {
      if (content.grid[i] != null) this.category_report_enable({
        id: i + '',
        checked: content.grid[i]['enable']
      });
    }
  }

  /**
   * Set/unset selected category's row
   *
   * @param {type} _widget
   * @returns {undefined}
   */
  category_report_enable(_widget) {
    var widgets = ['[user]', '[weekend]', '[holidays]', '[min_days]'];
    var row_id = _widget.id.match(/\d+/);
    var w = {};
    for (var i = 0; i < widgets.length; i++) {
      w = this.et2.getWidgetById(row_id + widgets[i]);
      if (w) w.set_readonly(!_widget.checked);
    }
  }

  /**
   * submit function for report button
   */
  category_report_submit() {
    this.et2._inst.postSubmit();
  }

  /**
   * Function to enable/disable categories
   *
   * @param {object} _widget select all checkbox
   */
  category_report_selectAll(_widget) {
    var content = this.et2.getArrayMgr('content').data;
    var checkbox = null;
    var grid_index = typeof content.grid.length != 'undefined' ? content.grid : Object.keys(content.grid);
    for (var i = 1; i < grid_index.length; i++) {
      if (content.grid[i] != null) {
        checkbox = this.et2.getWidgetById(i + '[enable]');
        if (checkbox) {
          checkbox.set_value(_widget.checked);
          this.category_report_enable({
            id: checkbox.id,
            checked: checkbox.get_value()
          });
        }
      }
    }
  }

  /**
   * Create a cache ID for the daywise cache
   *
   * @param {String|Date} date If a string, date should be in Ymd format
   * @param {String|integer|String[]} owner
   * @returns {String} Cache ID
   */
  static _daywise_cache_id(date, owner) {
    if (typeof date === 'object') {
      date = date.getUTCFullYear() + sprintf('%02d', date.getUTCMonth() + 1) + sprintf('%02d', date.getUTCDate());
    }

    // If the owner is not set, 0, or the current user, don't bother adding it
    var _owner = owner && owner.toString() != '0' ? owner.toString() : '';
    if (_owner == egw$1.user('account_id')) {
      _owner = '';
    }
    return CalendarApp.DAYWISE_CACHE_ID + '::' + date + (_owner ? '-' + _owner : '');
  }

  /**
   * Videoconference checkbox checked
   */
  videoconferenceOnChange(event) {
    var widget = this.et2.getWidgetById('videoconference');
    if (widget && widget.get_value()) {
      // notify all participants
      this.et2.getWidgetById('participants[notify_externals]').set_value('yes');

      // add alarm for all participants 5min before videoconference
      var start = new Date(widget.getRoot().getValueById('start'));
      var alarms = this.et2.getArrayMgr('content').getEntry('alarm') || {};
      for (var alarm of alarms) {
        // Check for already existing alarm
        if (!alarm || typeof alarm != "object" || !alarm.all) continue;
        var alarm_time = new Date(alarm.time);
        if (start.getTime() - alarm_time.getTime() == 5 * 60 * 1000) {
          // Alarm exists
          return;
        }
      }
      this.et2.getWidgetById('new_alarm[options]').set_value('300');
      this.et2.getWidgetById('new_alarm[owner]').set_value('0'); // all participants
      this.et2.getWidgetById('button[add_alarm]').click(event);
    }
  }
  isVideoConference(_action, _selected) {
    var data = egw$1.dataGetUIDdata(_selected[0].id);
    return data && data.data ? data.data['##videoconference'] : false;
  }

  /**
   * Action handler for join videoconference context menu
   *
   * @param _action
   * @param _sender
   */
  videoConferenceAction(_action, _sender) {
    var data = egw$1.dataGetUIDdata(_sender[0].id)['data'];
    switch (_action.id) {
      case 'recordings':
        app.status.videoconference_getRecordings(data['##videoconference'], {
          cal_id: data['id'],
          title: data['title']
        });
        break;
      case 'join':
        return this.joinVideoConference(data['##videoconference'], data);
    }
  }

  /**
   * Join a videoconference
   *
   * Using the videoconference tag/ID, generate the URL and open it via JSON
   *
   * @param {string} videoconference
   */
  joinVideoConference(videoconference, _data) {
    var _data$participants;
    return egw$1.json("EGroupware\\Status\\Videoconference\\Call::ajax_genMeetingUrl", [videoconference, {
      name: egw$1.user('account_fullname'),
      account_id: egw$1.user('account_id'),
      email: egw$1.user('account_email'),
      cal_id: _data.id,
      title: _data.title
    },
    // Dates are user time, but we told javascript it was UTC.
    // Send just the timestamp (as a string) with no timezone
    (typeof _data.start != "string" ? _data.start.toJSON() : _data.start).slice(0, -1), (typeof _data.end != "string" ? _data.end.toJSON() : _data.end).slice(0, -1), {
      participants: Object.keys((_data$participants = _data.participants) !== null && _data$participants !== void 0 ? _data$participants : []).filter(v => {
        return v.match(/^[0-9|e|c]/);
      })
    }], function (_value) {
      if (_value) {
        if (_value.err) egw$1.message(_value.err, 'error');
        if (_value.url) egw$1.callFunc('app.status.openCall', _value.url);
      }
    }).sendRequest();
  }
}
/**
 * These are the keys we keep to set & remember the status, others are discarded
 */
_defineProperty(CalendarApp, "states_to_save", ['owner', 'status_filter', 'filter', 'cat_id', 'view', 'sortby', 'planner_view', 'weekend']);
_defineProperty(CalendarApp, "views", {
  day: day,
  day4: day4,
  week: week,
  weekN: weekN,
  month: month,
  planner: planner,
  listview: listview
});
/**
 * This is the data cache prefix for the daywise event index cache
 * Daywise cache IDs look like: calendar_daywise::20150101 and
 * contain a list of event IDs for that day (or empty array)
 */
_defineProperty(CalendarApp, "DAYWISE_CACHE_ID", 'calendar_daywise');
if (typeof app.classes.calendar == "undefined") {
  app.classes.calendar = CalendarApp;
}

export { CalendarApp };
//# sourceMappingURL=app.min.js.map
