import { f as functionBindNative, a as functionUncurryThis, t as toObject$6, b as functionCall, c as fixRegexpWellKnownSymbolLogic, d as fails$e, e as anObject$b, i as isCallable$e, g as isNullOrUndefined$6, h as toIntegerOrInfinity$1, j as toLength$5, k as toString$b, r as requireObjectCoercible$7, l as advanceStringIndex$2, m as getMethod$6, n as regexpExecAbstract, w as wellKnownSymbol$f, o as hasOwnProperty_1, s as sharedKey$1, p as isObject$6, q as objectCreate, u as defineBuiltIn$9, v as isPure, x as objectDefineProperty, y as createPropertyDescriptor$3, z as aCallable$a, _ as _export, A as functionName, B as createNonEnumerableProperty$3, C as toIndexedObject$1, D as addToUnscopables$1, E as internalState, F as descriptors, G as documentCreateElement$1, H as global$c, I as classof$5, J as getBuiltIn$5, K as inspectSource$2, L as tryToString$4, M as toPropertyKey$1, N as toAbsoluteIndex$1, O as lengthOfArrayLike$5, P as isRegexp, Q as regexpExec$1, R as regexpStickyHelpers, S as classofRaw, T as defineBuiltInAccessor$4, U as objectIsPrototypeOf, V as functionUncurryThisClause, W as engineUserAgent, X as html$2, Y as objectGetOwnPropertyDescriptor, Z as isForced_1, $ as engineV8Version, a0 as whitespaces$1, a1 as stringTrim, a2 as objectGetOwnPropertyNames, a3 as regexpGetFlags, a4 as regexpUnsupportedDotAll, a5 as regexpUnsupportedNcg, a6 as objectKeys$1, a7 as objectGetOwnPropertySymbols, a8 as objectPropertyIsEnumerable, a9 as indexedObject, aa as notARegexp, ab as correctIsRegexpLogic, ac as EgwFnct, ad as egwActionStoreJSON, ae as regexpFlags, af as egwBitIsSet, ag as EGW_AO_FLAG_IS_CONTAINER, ah as EGW_AO_SHIFT_STATE_NONE, ai as EGW_AO_STATE_SELECTED, aj as EGW_AO_STATE_VISIBLE, ak as EGW_AO_STATE_NORMAL, al as EGW_AO_SHIFT_STATE_MULTI, am as EGW_AO_SHIFT_STATE_BLOCK, an as egwSetBit, ao as EGW_AO_STATE_FOCUSED, ap as EGW_KEY_A, aq as EGW_KEY_SPACE, ar as EGW_KEY_PAGE_DOWN, as as EGW_KEY_ARROW_UP, at as EGW_KEY_ARROW_DOWN, au as EGW_KEY_PAGE_UP, av as egwQueueCallback, aw as EGW_AO_EXEC_SELECTED, ax as EGW_AO_EXEC_THIS, ay as egwObjectLength, az as EGW_AO_STATE_DRAGGING, aA as EGW_KEY_ENTER, aB as EGW_KEY_MENU, aC as EGW_AI_DRAG_ENTER, aD as EGW_AI_DRAG_OUT, aE as EGW_AI_DRAG_OVER, aF as egwIsMobile$1, aG as sprintf, aH as egwUnfocus, aI as egwGetShiftState, aJ as EGW_VALID_KEYS, aK as EGW_KEY_F1, aL as EGW_KEY_F12, aM as EGW_AO_FLAG_DEFAULT_FOCUS, aN as commonjsGlobal$1, aO as getDefaultExportFromCjs, aP as stringMultibyte, aQ as stringRepeat, aR as EGW_AI_DRAG } from './egw_json-39123901.js';
import '../vendor/bower-asset/jquery/dist/jquery.min.js';
import '../vendor/bower-asset/cropper/dist/cropper.min.js';
import '../vendor/tinymce/tinymce/tinymce.min.js';

/**
 * EGroupware eTemplate2 - File which contains all interfaces
 *
 * @license http://opensource.org/licenses/gpl-license.php GPL - GNU General Public License
 * @package etemplate
 * @subpackage api
 * @link https://www.egroupware.org
 * @author Andreas Stöckel
 */

// fixing circular dependencies

var et2_implements_registry = {};

/**
 * Checks if an object / et2_widget implements given methods
 *
 * @param obj
 * @param methods
 */
function implements_methods(obj, methods) {
  for (var i = 0; i < methods.length; ++i) {
    if (typeof obj[methods[i]] !== 'function') {
      return false;
    }
  }
  return true;
}

/**
 * Interface for all widget classes, which are based on a DOM node.
 */

var et2_IDOMNode = "et2_IDOMNode";
et2_implements_registry.et2_IDOMNode = function (obj) {
  return implements_methods(obj, ["getDOMNode"]);
};

/**
 * Interface for all et2_inputWidgets
 */

var et2_IInputNode = "et2_IInputNode";
et2_implements_registry.et2_IInputNode = function (obj) {
  return implements_methods(obj, ["getInputNode"]);
};

/**
 * Interface for all widgets which support returning a value
 */

var et2_IInput = "et2_IInput";
et2_implements_registry.et2_IInput = function (obj) {
  return implements_methods(obj, ["getValue", "isDirty", "resetDirty", "isValid"]);
};

/**
 * Interface for widgets which should be automatically resized
 */

var et2_IResizeable = "et2_IResizeable";
et2_implements_registry.et2_IResizeable = function (obj) {
  return implements_methods(obj, ["resize"]);
};

/**
 * Interface for widgets which have the align attribute
 */

var et2_IAligned = "et2_IAligned";
et2_implements_registry.et2_IAligned = function (obj) {
  return implements_methods(obj, ["get_align"]);
};

/**
 * Interface for widgets which want to e.g. perform clientside validation before
 * the form is submitted.
 */

var et2_ISubmitListener = "et2_ISubmitListener";
et2_implements_registry.et2_ISubmitListener = function (obj) {
  return implements_methods(obj, ["submit"]);
};

/**
 * Interface all widgets must support which can operate on given DOM-Nodes. This
 * is used in grid lists, when only a single row gets really stored in the widget
 * tree and this instance has to work on multiple copies of the DOM-Tree elements.
 */

var et2_IDetachedDOM = "et2_IDetachedDOM";
et2_implements_registry.et2_IDetachedDOM = function (obj) {
  return implements_methods(obj, ["getDetachedAttributes", "getDetachedNodes", "setDetachedAttributes"]);
};

/**
 * Interface for widgets that need to do something special before printing
 */

var et2_IPrint = "et2_IPrint";
et2_implements_registry.et2_IPrint = function (obj) {
  return implements_methods(obj, ["beforePrint", "afterPrint"]);
};

/**
 * Interface all exposed widget must support in order to getMedia for the blueimp Gallery.
 */

var et2_IExposable = "et2_IExposable";
et2_implements_registry.et2_IExposable = function (obj) {
  return implements_methods(obj, ["getMedia"]);
};

var es_string_replace = {};

var NATIVE_BIND$1 = functionBindNative;

var FunctionPrototype = Function.prototype;
var apply$3 = FunctionPrototype.apply;
var call$h = FunctionPrototype.call;

// eslint-disable-next-line es/no-reflect -- safe
var functionApply = typeof Reflect == 'object' && Reflect.apply || (NATIVE_BIND$1 ? call$h.bind(apply$3) : function () {
  return call$h.apply(apply$3, arguments);
});

var uncurryThis$h = functionUncurryThis;
var toObject$5 = toObject$6;

var floor$4 = Math.floor;
var charAt$4 = uncurryThis$h(''.charAt);
var replace$5 = uncurryThis$h(''.replace);
var stringSlice$8 = uncurryThis$h(''.slice);
// eslint-disable-next-line redos/no-vulnerable -- safe
var SUBSTITUTION_SYMBOLS = /\$([$&'`]|\d{1,2}|<[^>]*>)/g;
var SUBSTITUTION_SYMBOLS_NO_NAMED = /\$([$&'`]|\d{1,2})/g;

// `GetSubstitution` abstract operation
// https://tc39.es/ecma262/#sec-getsubstitution
var getSubstitution$2 = function (matched, str, position, captures, namedCaptures, replacement) {
  var tailPos = position + matched.length;
  var m = captures.length;
  var symbols = SUBSTITUTION_SYMBOLS_NO_NAMED;
  if (namedCaptures !== undefined) {
    namedCaptures = toObject$5(namedCaptures);
    symbols = SUBSTITUTION_SYMBOLS;
  }
  return replace$5(replacement, symbols, function (match, ch) {
    var capture;
    switch (charAt$4(ch, 0)) {
      case '$': return '$';
      case '&': return matched;
      case '`': return stringSlice$8(str, 0, position);
      case "'": return stringSlice$8(str, tailPos);
      case '<':
        capture = namedCaptures[stringSlice$8(ch, 1, -1)];
        break;
      default: // \d\d?
        var n = +ch;
        if (n === 0) return match;
        if (n > m) {
          var f = floor$4(n / 10);
          if (f === 0) return match;
          if (f <= m) return captures[f - 1] === undefined ? charAt$4(ch, 1) : captures[f - 1] + charAt$4(ch, 1);
          return match;
        }
        capture = captures[n - 1];
    }
    return capture === undefined ? '' : capture;
  });
};

'use strict';
var apply$2 = functionApply;
var call$g = functionCall;
var uncurryThis$g = functionUncurryThis;
var fixRegExpWellKnownSymbolLogic$2 = fixRegexpWellKnownSymbolLogic;
var fails$d = fails$e;
var anObject$a = anObject$b;
var isCallable$d = isCallable$e;
var isNullOrUndefined$5 = isNullOrUndefined$6;
var toIntegerOrInfinity = toIntegerOrInfinity$1;
var toLength$4 = toLength$5;
var toString$a = toString$b;
var requireObjectCoercible$6 = requireObjectCoercible$7;
var advanceStringIndex$1 = advanceStringIndex$2;
var getMethod$5 = getMethod$6;
var getSubstitution$1 = getSubstitution$2;
var regExpExec$1 = regexpExecAbstract;
var wellKnownSymbol$e = wellKnownSymbol$f;

var REPLACE$1 = wellKnownSymbol$e('replace');
var max$3 = Math.max;
var min$4 = Math.min;
var concat$1 = uncurryThis$g([].concat);
var push$5 = uncurryThis$g([].push);
var stringIndexOf$2 = uncurryThis$g(''.indexOf);
var stringSlice$7 = uncurryThis$g(''.slice);

var maybeToString = function (it) {
  return it === undefined ? it : String(it);
};

// IE <= 11 replaces $0 with the whole match, as if it was $&
// https://stackoverflow.com/questions/6024666/getting-ie-to-replace-a-regex-with-the-literal-string-0
var REPLACE_KEEPS_$0 = (function () {
  // eslint-disable-next-line regexp/prefer-escape-replacement-dollar-char -- required for testing
  return 'a'.replace(/./, '$0') === '$0';
})();

// Safari <= 13.0.3(?) substitutes nth capture where n>m with an empty string
var REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE = (function () {
  if (/./[REPLACE$1]) {
    return /./[REPLACE$1]('a', '$0') === '';
  }
  return false;
})();

var REPLACE_SUPPORTS_NAMED_GROUPS = !fails$d(function () {
  var re = /./;
  re.exec = function () {
    var result = [];
    result.groups = { a: '7' };
    return result;
  };
  // eslint-disable-next-line regexp/no-useless-dollar-replacements -- false positive
  return ''.replace(re, '$<a>') !== '7';
});

// @@replace logic
fixRegExpWellKnownSymbolLogic$2('replace', function (_, nativeReplace, maybeCallNative) {
  var UNSAFE_SUBSTITUTE = REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE ? '$' : '$0';

  return [
    // `String.prototype.replace` method
    // https://tc39.es/ecma262/#sec-string.prototype.replace
    function replace(searchValue, replaceValue) {
      var O = requireObjectCoercible$6(this);
      var replacer = isNullOrUndefined$5(searchValue) ? undefined : getMethod$5(searchValue, REPLACE$1);
      return replacer
        ? call$g(replacer, searchValue, O, replaceValue)
        : call$g(nativeReplace, toString$a(O), searchValue, replaceValue);
    },
    // `RegExp.prototype[@@replace]` method
    // https://tc39.es/ecma262/#sec-regexp.prototype-@@replace
    function (string, replaceValue) {
      var rx = anObject$a(this);
      var S = toString$a(string);

      if (
        typeof replaceValue == 'string' &&
        stringIndexOf$2(replaceValue, UNSAFE_SUBSTITUTE) === -1 &&
        stringIndexOf$2(replaceValue, '$<') === -1
      ) {
        var res = maybeCallNative(nativeReplace, rx, S, replaceValue);
        if (res.done) return res.value;
      }

      var functionalReplace = isCallable$d(replaceValue);
      if (!functionalReplace) replaceValue = toString$a(replaceValue);

      var global = rx.global;
      if (global) {
        var fullUnicode = rx.unicode;
        rx.lastIndex = 0;
      }
      var results = [];
      while (true) {
        var result = regExpExec$1(rx, S);
        if (result === null) break;

        push$5(results, result);
        if (!global) break;

        var matchStr = toString$a(result[0]);
        if (matchStr === '') rx.lastIndex = advanceStringIndex$1(S, toLength$4(rx.lastIndex), fullUnicode);
      }

      var accumulatedResult = '';
      var nextSourcePosition = 0;
      for (var i = 0; i < results.length; i++) {
        result = results[i];

        var matched = toString$a(result[0]);
        var position = max$3(min$4(toIntegerOrInfinity(result.index), S.length), 0);
        var captures = [];
        // NOTE: This is equivalent to
        //   captures = result.slice(1).map(maybeToString)
        // but for some reason `nativeSlice.call(result, 1, result.length)` (called in
        // the slice polyfill when slicing native arrays) "doesn't work" in safari 9 and
        // causes a crash (https://pastebin.com/N21QzeQA) when trying to debug it.
        for (var j = 1; j < result.length; j++) push$5(captures, maybeToString(result[j]));
        var namedCaptures = result.groups;
        if (functionalReplace) {
          var replacerArgs = concat$1([matched], captures, position, S);
          if (namedCaptures !== undefined) push$5(replacerArgs, namedCaptures);
          var replacement = toString$a(apply$2(replaceValue, undefined, replacerArgs));
        } else {
          replacement = getSubstitution$1(matched, S, position, captures, namedCaptures, replaceValue);
        }
        if (position >= nextSourcePosition) {
          accumulatedResult += stringSlice$7(S, nextSourcePosition, position) + replacement;
          nextSourcePosition = position + matched.length;
        }
      }
      return accumulatedResult + stringSlice$7(S, nextSourcePosition);
    }
  ];
}, !REPLACE_SUPPORTS_NAMED_GROUPS || !REPLACE_KEEPS_$0 || REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE);

var iterators = {};

var fails$c = fails$e;

var correctPrototypeGetter = !fails$c(function () {
  function F() { /* empty */ }
  F.prototype.constructor = null;
  // eslint-disable-next-line es/no-object-getprototypeof -- required for testing
  return Object.getPrototypeOf(new F()) !== F.prototype;
});

var hasOwn$5 = hasOwnProperty_1;
var isCallable$c = isCallable$e;
var toObject$4 = toObject$6;
var sharedKey = sharedKey$1;
var CORRECT_PROTOTYPE_GETTER = correctPrototypeGetter;

var IE_PROTO = sharedKey('IE_PROTO');
var $Object = Object;
var ObjectPrototype = $Object.prototype;

// `Object.getPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.getprototypeof
// eslint-disable-next-line es/no-object-getprototypeof -- safe
var objectGetPrototypeOf = CORRECT_PROTOTYPE_GETTER ? $Object.getPrototypeOf : function (O) {
  var object = toObject$4(O);
  if (hasOwn$5(object, IE_PROTO)) return object[IE_PROTO];
  var constructor = object.constructor;
  if (isCallable$c(constructor) && object instanceof constructor) {
    return constructor.prototype;
  } return object instanceof $Object ? ObjectPrototype : null;
};

'use strict';
var fails$b = fails$e;
var isCallable$b = isCallable$e;
var isObject$5 = isObject$6;
var create$2 = objectCreate;
var getPrototypeOf$1 = objectGetPrototypeOf;
var defineBuiltIn$8 = defineBuiltIn$9;
var wellKnownSymbol$d = wellKnownSymbol$f;
var IS_PURE$b = isPure;

var ITERATOR$7 = wellKnownSymbol$d('iterator');
var BUGGY_SAFARI_ITERATORS$1 = false;

// `%IteratorPrototype%` object
// https://tc39.es/ecma262/#sec-%iteratorprototype%-object
var IteratorPrototype$2, PrototypeOfArrayIteratorPrototype, arrayIterator;

/* eslint-disable es/no-array-prototype-keys -- safe */
if ([].keys) {
  arrayIterator = [].keys();
  // Safari 8 has buggy iterators w/o `next`
  if (!('next' in arrayIterator)) BUGGY_SAFARI_ITERATORS$1 = true;
  else {
    PrototypeOfArrayIteratorPrototype = getPrototypeOf$1(getPrototypeOf$1(arrayIterator));
    if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype$2 = PrototypeOfArrayIteratorPrototype;
  }
}

var NEW_ITERATOR_PROTOTYPE = !isObject$5(IteratorPrototype$2) || fails$b(function () {
  var test = {};
  // FF44- legacy iterators case
  return IteratorPrototype$2[ITERATOR$7].call(test) !== test;
});

if (NEW_ITERATOR_PROTOTYPE) IteratorPrototype$2 = {};
else if (IS_PURE$b) IteratorPrototype$2 = create$2(IteratorPrototype$2);

// `%IteratorPrototype%[@@iterator]()` method
// https://tc39.es/ecma262/#sec-%iteratorprototype%-@@iterator
if (!isCallable$b(IteratorPrototype$2[ITERATOR$7])) {
  defineBuiltIn$8(IteratorPrototype$2, ITERATOR$7, function () {
    return this;
  });
}

var iteratorsCore = {
  IteratorPrototype: IteratorPrototype$2,
  BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS$1
};

var defineProperty$3 = objectDefineProperty.f;
var hasOwn$4 = hasOwnProperty_1;
var wellKnownSymbol$c = wellKnownSymbol$f;

var TO_STRING_TAG$1 = wellKnownSymbol$c('toStringTag');

var setToStringTag$5 = function (target, TAG, STATIC) {
  if (target && !STATIC) target = target.prototype;
  if (target && !hasOwn$4(target, TO_STRING_TAG$1)) {
    defineProperty$3(target, TO_STRING_TAG$1, { configurable: true, value: TAG });
  }
};

'use strict';
var IteratorPrototype$1 = iteratorsCore.IteratorPrototype;
var create$1 = objectCreate;
var createPropertyDescriptor$2 = createPropertyDescriptor$3;
var setToStringTag$4 = setToStringTag$5;
var Iterators$4 = iterators;

var returnThis$1 = function () { return this; };

var iteratorCreateConstructor = function (IteratorConstructor, NAME, next, ENUMERABLE_NEXT) {
  var TO_STRING_TAG = NAME + ' Iterator';
  IteratorConstructor.prototype = create$1(IteratorPrototype$1, { next: createPropertyDescriptor$2(+!ENUMERABLE_NEXT, next) });
  setToStringTag$4(IteratorConstructor, TO_STRING_TAG, false, true);
  Iterators$4[TO_STRING_TAG] = returnThis$1;
  return IteratorConstructor;
};

var uncurryThis$f = functionUncurryThis;
var aCallable$9 = aCallable$a;

var functionUncurryThisAccessor = function (object, key, method) {
  try {
    // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
    return uncurryThis$f(aCallable$9(Object.getOwnPropertyDescriptor(object, key)[method]));
  } catch (error) { /* empty */ }
};

var isCallable$a = isCallable$e;

var $String = String;
var $TypeError$9 = TypeError;

var aPossiblePrototype$1 = function (argument) {
  if (typeof argument == 'object' || isCallable$a(argument)) return argument;
  throw $TypeError$9("Can't set " + $String(argument) + ' as a prototype');
};

/* eslint-disable no-proto -- safe */

var uncurryThisAccessor = functionUncurryThisAccessor;
var anObject$9 = anObject$b;
var aPossiblePrototype = aPossiblePrototype$1;

// `Object.setPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.setprototypeof
// Works with __proto__ only. Old v8 can't work with null proto objects.
// eslint-disable-next-line es/no-object-setprototypeof -- safe
var objectSetPrototypeOf = Object.setPrototypeOf || ('__proto__' in {} ? function () {
  var CORRECT_SETTER = false;
  var test = {};
  var setter;
  try {
    setter = uncurryThisAccessor(Object.prototype, '__proto__', 'set');
    setter(test, []);
    CORRECT_SETTER = test instanceof Array;
  } catch (error) { /* empty */ }
  return function setPrototypeOf(O, proto) {
    anObject$9(O);
    aPossiblePrototype(proto);
    if (CORRECT_SETTER) setter(O, proto);
    else O.__proto__ = proto;
    return O;
  };
}() : undefined);

'use strict';
var $$q = _export;
var call$f = functionCall;
var IS_PURE$a = isPure;
var FunctionName = functionName;
var isCallable$9 = isCallable$e;
var createIteratorConstructor$1 = iteratorCreateConstructor;
var getPrototypeOf = objectGetPrototypeOf;
var setPrototypeOf$2 = objectSetPrototypeOf;
var setToStringTag$3 = setToStringTag$5;
var createNonEnumerableProperty$2 = createNonEnumerableProperty$3;
var defineBuiltIn$7 = defineBuiltIn$9;
var wellKnownSymbol$b = wellKnownSymbol$f;
var Iterators$3 = iterators;
var IteratorsCore = iteratorsCore;

var PROPER_FUNCTION_NAME$1 = FunctionName.PROPER;
var CONFIGURABLE_FUNCTION_NAME = FunctionName.CONFIGURABLE;
var IteratorPrototype = IteratorsCore.IteratorPrototype;
var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
var ITERATOR$6 = wellKnownSymbol$b('iterator');
var KEYS = 'keys';
var VALUES = 'values';
var ENTRIES = 'entries';

var returnThis = function () { return this; };

var iteratorDefine = function (Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
  createIteratorConstructor$1(IteratorConstructor, NAME, next);

  var getIterationMethod = function (KIND) {
    if (KIND === DEFAULT && defaultIterator) return defaultIterator;
    if (!BUGGY_SAFARI_ITERATORS && KIND in IterablePrototype) return IterablePrototype[KIND];
    switch (KIND) {
      case KEYS: return function keys() { return new IteratorConstructor(this, KIND); };
      case VALUES: return function values() { return new IteratorConstructor(this, KIND); };
      case ENTRIES: return function entries() { return new IteratorConstructor(this, KIND); };
    } return function () { return new IteratorConstructor(this); };
  };

  var TO_STRING_TAG = NAME + ' Iterator';
  var INCORRECT_VALUES_NAME = false;
  var IterablePrototype = Iterable.prototype;
  var nativeIterator = IterablePrototype[ITERATOR$6]
    || IterablePrototype['@@iterator']
    || DEFAULT && IterablePrototype[DEFAULT];
  var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
  var anyNativeIterator = NAME == 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
  var CurrentIteratorPrototype, methods, KEY;

  // fix native
  if (anyNativeIterator) {
    CurrentIteratorPrototype = getPrototypeOf(anyNativeIterator.call(new Iterable()));
    if (CurrentIteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {
      if (!IS_PURE$a && getPrototypeOf(CurrentIteratorPrototype) !== IteratorPrototype) {
        if (setPrototypeOf$2) {
          setPrototypeOf$2(CurrentIteratorPrototype, IteratorPrototype);
        } else if (!isCallable$9(CurrentIteratorPrototype[ITERATOR$6])) {
          defineBuiltIn$7(CurrentIteratorPrototype, ITERATOR$6, returnThis);
        }
      }
      // Set @@toStringTag to native iterators
      setToStringTag$3(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
      if (IS_PURE$a) Iterators$3[TO_STRING_TAG] = returnThis;
    }
  }

  // fix Array.prototype.{ values, @@iterator }.name in V8 / FF
  if (PROPER_FUNCTION_NAME$1 && DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
    if (!IS_PURE$a && CONFIGURABLE_FUNCTION_NAME) {
      createNonEnumerableProperty$2(IterablePrototype, 'name', VALUES);
    } else {
      INCORRECT_VALUES_NAME = true;
      defaultIterator = function values() { return call$f(nativeIterator, this); };
    }
  }

  // export additional methods
  if (DEFAULT) {
    methods = {
      values: getIterationMethod(VALUES),
      keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
      entries: getIterationMethod(ENTRIES)
    };
    if (FORCED) for (KEY in methods) {
      if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
        defineBuiltIn$7(IterablePrototype, KEY, methods[KEY]);
      }
    } else $$q({ target: NAME, proto: true, forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME }, methods);
  }

  // define iterator
  if ((!IS_PURE$a || FORCED) && IterablePrototype[ITERATOR$6] !== defaultIterator) {
    defineBuiltIn$7(IterablePrototype, ITERATOR$6, defaultIterator, { name: DEFAULT });
  }
  Iterators$3[NAME] = defaultIterator;

  return methods;
};

// `CreateIterResultObject` abstract operation
// https://tc39.es/ecma262/#sec-createiterresultobject
var createIterResultObject$2 = function (value, done) {
  return { value: value, done: done };
};

'use strict';
var toIndexedObject = toIndexedObject$1;
var addToUnscopables = addToUnscopables$1;
var Iterators$2 = iterators;
var InternalStateModule$4 = internalState;
var defineProperty$2 = objectDefineProperty.f;
var defineIterator$1 = iteratorDefine;
var createIterResultObject$1 = createIterResultObject$2;
var IS_PURE$9 = isPure;
var DESCRIPTORS$7 = descriptors;

var ARRAY_ITERATOR = 'Array Iterator';
var setInternalState$4 = InternalStateModule$4.set;
var getInternalState$1 = InternalStateModule$4.getterFor(ARRAY_ITERATOR);

// `Array.prototype.entries` method
// https://tc39.es/ecma262/#sec-array.prototype.entries
// `Array.prototype.keys` method
// https://tc39.es/ecma262/#sec-array.prototype.keys
// `Array.prototype.values` method
// https://tc39.es/ecma262/#sec-array.prototype.values
// `Array.prototype[@@iterator]` method
// https://tc39.es/ecma262/#sec-array.prototype-@@iterator
// `CreateArrayIterator` internal method
// https://tc39.es/ecma262/#sec-createarrayiterator
var es_array_iterator = defineIterator$1(Array, 'Array', function (iterated, kind) {
  setInternalState$4(this, {
    type: ARRAY_ITERATOR,
    target: toIndexedObject(iterated), // target
    index: 0,                          // next index
    kind: kind                         // kind
  });
// `%ArrayIteratorPrototype%.next` method
// https://tc39.es/ecma262/#sec-%arrayiteratorprototype%.next
}, function () {
  var state = getInternalState$1(this);
  var target = state.target;
  var kind = state.kind;
  var index = state.index++;
  if (!target || index >= target.length) {
    state.target = undefined;
    return createIterResultObject$1(undefined, true);
  }
  if (kind == 'keys') return createIterResultObject$1(index, false);
  if (kind == 'values') return createIterResultObject$1(target[index], false);
  return createIterResultObject$1([index, target[index]], false);
}, 'values');

// argumentsList[@@iterator] is %ArrayProto_values%
// https://tc39.es/ecma262/#sec-createunmappedargumentsobject
// https://tc39.es/ecma262/#sec-createmappedargumentsobject
var values = Iterators$2.Arguments = Iterators$2.Array;

// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
addToUnscopables('keys');
addToUnscopables('values');
addToUnscopables('entries');

// V8 ~ Chrome 45- bug
if (!IS_PURE$9 && DESCRIPTORS$7 && values.name !== 'values') try {
  defineProperty$2(values, 'name', { value: 'values' });
} catch (error) { /* empty */ }

var web_domCollections_iterator = {};

// iterable DOM collections
// flag - `iterable` interface - 'entries', 'keys', 'values', 'forEach' methods
var domIterables = {
  CSSRuleList: 0,
  CSSStyleDeclaration: 0,
  CSSValueList: 0,
  ClientRectList: 0,
  DOMRectList: 0,
  DOMStringList: 0,
  DOMTokenList: 1,
  DataTransferItemList: 0,
  FileList: 0,
  HTMLAllCollection: 0,
  HTMLCollection: 0,
  HTMLFormElement: 0,
  HTMLSelectElement: 0,
  MediaList: 0,
  MimeTypeArray: 0,
  NamedNodeMap: 0,
  NodeList: 1,
  PaintRequestList: 0,
  Plugin: 0,
  PluginArray: 0,
  SVGLengthList: 0,
  SVGNumberList: 0,
  SVGPathSegList: 0,
  SVGPointList: 0,
  SVGStringList: 0,
  SVGTransformList: 0,
  SourceBufferList: 0,
  StyleSheetList: 0,
  TextTrackCueList: 0,
  TextTrackList: 0,
  TouchList: 0
};

// in old WebKit versions, `element.classList` is not an instance of global `DOMTokenList`
var documentCreateElement = documentCreateElement$1;

var classList = documentCreateElement('span').classList;
var DOMTokenListPrototype$1 = classList && classList.constructor && classList.constructor.prototype;

var domTokenListPrototype = DOMTokenListPrototype$1 === Object.prototype ? undefined : DOMTokenListPrototype$1;

var global$b = global$c;
var DOMIterables = domIterables;
var DOMTokenListPrototype = domTokenListPrototype;
var ArrayIteratorMethods = es_array_iterator;
var createNonEnumerableProperty$1 = createNonEnumerableProperty$3;
var wellKnownSymbol$a = wellKnownSymbol$f;

var ITERATOR$5 = wellKnownSymbol$a('iterator');
var TO_STRING_TAG = wellKnownSymbol$a('toStringTag');
var ArrayValues = ArrayIteratorMethods.values;

var handlePrototype = function (CollectionPrototype, COLLECTION_NAME) {
  if (CollectionPrototype) {
    // some Chrome versions have non-configurable methods on DOMTokenList
    if (CollectionPrototype[ITERATOR$5] !== ArrayValues) try {
      createNonEnumerableProperty$1(CollectionPrototype, ITERATOR$5, ArrayValues);
    } catch (error) {
      CollectionPrototype[ITERATOR$5] = ArrayValues;
    }
    if (!CollectionPrototype[TO_STRING_TAG]) {
      createNonEnumerableProperty$1(CollectionPrototype, TO_STRING_TAG, COLLECTION_NAME);
    }
    if (DOMIterables[COLLECTION_NAME]) for (var METHOD_NAME in ArrayIteratorMethods) {
      // some Chrome versions have non-configurable methods on DOMTokenList
      if (CollectionPrototype[METHOD_NAME] !== ArrayIteratorMethods[METHOD_NAME]) try {
        createNonEnumerableProperty$1(CollectionPrototype, METHOD_NAME, ArrayIteratorMethods[METHOD_NAME]);
      } catch (error) {
        CollectionPrototype[METHOD_NAME] = ArrayIteratorMethods[METHOD_NAME];
      }
    }
  }
};

for (var COLLECTION_NAME in DOMIterables) {
  handlePrototype(global$b[COLLECTION_NAME] && global$b[COLLECTION_NAME].prototype, COLLECTION_NAME);
}

handlePrototype(DOMTokenListPrototype, 'DOMTokenList');

var es_string_split = {};

var uncurryThis$e = functionUncurryThis;
var fails$a = fails$e;
var isCallable$8 = isCallable$e;
var classof$4 = classof$5;
var getBuiltIn$4 = getBuiltIn$5;
var inspectSource$1 = inspectSource$2;

var noop$2 = function () { /* empty */ };
var empty = [];
var construct = getBuiltIn$4('Reflect', 'construct');
var constructorRegExp = /^\s*(?:class|function)\b/;
var exec$4 = uncurryThis$e(constructorRegExp.exec);
var INCORRECT_TO_STRING = !constructorRegExp.exec(noop$2);

var isConstructorModern = function isConstructor(argument) {
  if (!isCallable$8(argument)) return false;
  try {
    construct(noop$2, empty, argument);
    return true;
  } catch (error) {
    return false;
  }
};

var isConstructorLegacy = function isConstructor(argument) {
  if (!isCallable$8(argument)) return false;
  switch (classof$4(argument)) {
    case 'AsyncFunction':
    case 'GeneratorFunction':
    case 'AsyncGeneratorFunction': return false;
  }
  try {
    // we can't check .prototype since constructors produced by .bind haven't it
    // `Function#toString` throws on some built-it function in some legacy engines
    // (for example, `DOMQuad` and similar in FF41-)
    return INCORRECT_TO_STRING || !!exec$4(constructorRegExp, inspectSource$1(argument));
  } catch (error) {
    return true;
  }
};

isConstructorLegacy.sham = true;

// `IsConstructor` abstract operation
// https://tc39.es/ecma262/#sec-isconstructor
var isConstructor$2 = !construct || fails$a(function () {
  var called;
  return isConstructorModern(isConstructorModern.call)
    || !isConstructorModern(Object)
    || !isConstructorModern(function () { called = true; })
    || called;
}) ? isConstructorLegacy : isConstructorModern;

var isConstructor$1 = isConstructor$2;
var tryToString$3 = tryToString$4;

var $TypeError$8 = TypeError;

// `Assert: IsConstructor(argument) is true`
var aConstructor$1 = function (argument) {
  if (isConstructor$1(argument)) return argument;
  throw $TypeError$8(tryToString$3(argument) + ' is not a constructor');
};

var anObject$8 = anObject$b;
var aConstructor = aConstructor$1;
var isNullOrUndefined$4 = isNullOrUndefined$6;
var wellKnownSymbol$9 = wellKnownSymbol$f;

var SPECIES$2 = wellKnownSymbol$9('species');

// `SpeciesConstructor` abstract operation
// https://tc39.es/ecma262/#sec-speciesconstructor
var speciesConstructor$3 = function (O, defaultConstructor) {
  var C = anObject$8(O).constructor;
  var S;
  return C === undefined || isNullOrUndefined$4(S = anObject$8(C)[SPECIES$2]) ? defaultConstructor : aConstructor(S);
};

'use strict';
var toPropertyKey = toPropertyKey$1;
var definePropertyModule = objectDefineProperty;
var createPropertyDescriptor$1 = createPropertyDescriptor$3;

var createProperty$3 = function (object, key, value) {
  var propertyKey = toPropertyKey(key);
  if (propertyKey in object) definePropertyModule.f(object, propertyKey, createPropertyDescriptor$1(0, value));
  else object[propertyKey] = value;
};

var toAbsoluteIndex = toAbsoluteIndex$1;
var lengthOfArrayLike$4 = lengthOfArrayLike$5;
var createProperty$2 = createProperty$3;

var $Array$1 = Array;
var max$2 = Math.max;

var arraySliceSimple = function (O, start, end) {
  var length = lengthOfArrayLike$4(O);
  var k = toAbsoluteIndex(start, length);
  var fin = toAbsoluteIndex(end === undefined ? length : end, length);
  var result = $Array$1(max$2(fin - k, 0));
  for (var n = 0; k < fin; k++, n++) createProperty$2(result, n, O[k]);
  result.length = n;
  return result;
};

'use strict';
var apply$1 = functionApply;
var call$e = functionCall;
var uncurryThis$d = functionUncurryThis;
var fixRegExpWellKnownSymbolLogic$1 = fixRegexpWellKnownSymbolLogic;
var anObject$7 = anObject$b;
var isNullOrUndefined$3 = isNullOrUndefined$6;
var isRegExp$2 = isRegexp;
var requireObjectCoercible$5 = requireObjectCoercible$7;
var speciesConstructor$2 = speciesConstructor$3;
var advanceStringIndex = advanceStringIndex$2;
var toLength$3 = toLength$5;
var toString$9 = toString$b;
var getMethod$4 = getMethod$6;
var arraySlice$4 = arraySliceSimple;
var callRegExpExec = regexpExecAbstract;
var regexpExec = regexpExec$1;
var stickyHelpers$1 = regexpStickyHelpers;
var fails$9 = fails$e;

var UNSUPPORTED_Y$1 = stickyHelpers$1.UNSUPPORTED_Y;
var MAX_UINT32 = 0xFFFFFFFF;
var min$3 = Math.min;
var $push = [].push;
var exec$3 = uncurryThis$d(/./.exec);
var push$4 = uncurryThis$d($push);
var stringSlice$6 = uncurryThis$d(''.slice);

// Chrome 51 has a buggy "split" implementation when RegExp#exec !== nativeExec
// Weex JS has frozen built-in prototypes, so use try / catch wrapper
var SPLIT_WORKS_WITH_OVERWRITTEN_EXEC = !fails$9(function () {
  // eslint-disable-next-line regexp/no-empty-group -- required for testing
  var re = /(?:)/;
  var originalExec = re.exec;
  re.exec = function () { return originalExec.apply(this, arguments); };
  var result = 'ab'.split(re);
  return result.length !== 2 || result[0] !== 'a' || result[1] !== 'b';
});

// @@split logic
fixRegExpWellKnownSymbolLogic$1('split', function (SPLIT, nativeSplit, maybeCallNative) {
  var internalSplit;
  if (
    'abbc'.split(/(b)*/)[1] == 'c' ||
    // eslint-disable-next-line regexp/no-empty-group -- required for testing
    'test'.split(/(?:)/, -1).length != 4 ||
    'ab'.split(/(?:ab)*/).length != 2 ||
    '.'.split(/(.?)(.?)/).length != 4 ||
    // eslint-disable-next-line regexp/no-empty-capturing-group, regexp/no-empty-group -- required for testing
    '.'.split(/()()/).length > 1 ||
    ''.split(/.?/).length
  ) {
    // based on es5-shim implementation, need to rework it
    internalSplit = function (separator, limit) {
      var string = toString$9(requireObjectCoercible$5(this));
      var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;
      if (lim === 0) return [];
      if (separator === undefined) return [string];
      // If `separator` is not a regex, use native split
      if (!isRegExp$2(separator)) {
        return call$e(nativeSplit, string, separator, lim);
      }
      var output = [];
      var flags = (separator.ignoreCase ? 'i' : '') +
                  (separator.multiline ? 'm' : '') +
                  (separator.unicode ? 'u' : '') +
                  (separator.sticky ? 'y' : '');
      var lastLastIndex = 0;
      // Make `global` and avoid `lastIndex` issues by working with a copy
      var separatorCopy = new RegExp(separator.source, flags + 'g');
      var match, lastIndex, lastLength;
      while (match = call$e(regexpExec, separatorCopy, string)) {
        lastIndex = separatorCopy.lastIndex;
        if (lastIndex > lastLastIndex) {
          push$4(output, stringSlice$6(string, lastLastIndex, match.index));
          if (match.length > 1 && match.index < string.length) apply$1($push, output, arraySlice$4(match, 1));
          lastLength = match[0].length;
          lastLastIndex = lastIndex;
          if (output.length >= lim) break;
        }
        if (separatorCopy.lastIndex === match.index) separatorCopy.lastIndex++; // Avoid an infinite loop
      }
      if (lastLastIndex === string.length) {
        if (lastLength || !exec$3(separatorCopy, '')) push$4(output, '');
      } else push$4(output, stringSlice$6(string, lastLastIndex));
      return output.length > lim ? arraySlice$4(output, 0, lim) : output;
    };
  // Chakra, V8
  } else if ('0'.split(undefined, 0).length) {
    internalSplit = function (separator, limit) {
      return separator === undefined && limit === 0 ? [] : call$e(nativeSplit, this, separator, limit);
    };
  } else internalSplit = nativeSplit;

  return [
    // `String.prototype.split` method
    // https://tc39.es/ecma262/#sec-string.prototype.split
    function split(separator, limit) {
      var O = requireObjectCoercible$5(this);
      var splitter = isNullOrUndefined$3(separator) ? undefined : getMethod$4(separator, SPLIT);
      return splitter
        ? call$e(splitter, separator, O, limit)
        : call$e(internalSplit, toString$9(O), separator, limit);
    },
    // `RegExp.prototype[@@split]` method
    // https://tc39.es/ecma262/#sec-regexp.prototype-@@split
    //
    // NOTE: This cannot be properly polyfilled in engines that don't support
    // the 'y' flag.
    function (string, limit) {
      var rx = anObject$7(this);
      var S = toString$9(string);
      var res = maybeCallNative(internalSplit, rx, S, limit, internalSplit !== nativeSplit);

      if (res.done) return res.value;

      var C = speciesConstructor$2(rx, RegExp);

      var unicodeMatching = rx.unicode;
      var flags = (rx.ignoreCase ? 'i' : '') +
                  (rx.multiline ? 'm' : '') +
                  (rx.unicode ? 'u' : '') +
                  (UNSUPPORTED_Y$1 ? 'g' : 'y');

      // ^(? + rx + ) is needed, in combination with some S slicing, to
      // simulate the 'y' flag.
      var splitter = new C(UNSUPPORTED_Y$1 ? '^(?:' + rx.source + ')' : rx, flags);
      var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;
      if (lim === 0) return [];
      if (S.length === 0) return callRegExpExec(splitter, S) === null ? [S] : [];
      var p = 0;
      var q = 0;
      var A = [];
      while (q < S.length) {
        splitter.lastIndex = UNSUPPORTED_Y$1 ? 0 : q;
        var z = callRegExpExec(splitter, UNSUPPORTED_Y$1 ? stringSlice$6(S, q) : S);
        var e;
        if (
          z === null ||
          (e = min$3(toLength$3(splitter.lastIndex + (UNSUPPORTED_Y$1 ? q : 0)), S.length)) === p
        ) {
          q = advanceStringIndex(S, q, unicodeMatching);
        } else {
          push$4(A, stringSlice$6(S, p, q));
          if (A.length === lim) return A;
          for (var i = 1; i <= z.length - 1; i++) {
            push$4(A, z[i]);
            if (A.length === lim) return A;
          }
          q = p = e;
        }
      }
      push$4(A, stringSlice$6(S, p));
      return A;
    }
  ];
}, !SPLIT_WORKS_WITH_OVERWRITTEN_EXEC, UNSUPPORTED_Y$1);

var es_promise = {};

var es_promise_constructor = {};

var classof$3 = classofRaw;

var engineIsNode = typeof process != 'undefined' && classof$3(process) == 'process';

'use strict';
var getBuiltIn$3 = getBuiltIn$5;
var defineBuiltInAccessor$3 = defineBuiltInAccessor$4;
var wellKnownSymbol$8 = wellKnownSymbol$f;
var DESCRIPTORS$6 = descriptors;

var SPECIES$1 = wellKnownSymbol$8('species');

var setSpecies$2 = function (CONSTRUCTOR_NAME) {
  var Constructor = getBuiltIn$3(CONSTRUCTOR_NAME);

  if (DESCRIPTORS$6 && Constructor && !Constructor[SPECIES$1]) {
    defineBuiltInAccessor$3(Constructor, SPECIES$1, {
      configurable: true,
      get: function () { return this; }
    });
  }
};

var isPrototypeOf$2 = objectIsPrototypeOf;

var $TypeError$7 = TypeError;

var anInstance$3 = function (it, Prototype) {
  if (isPrototypeOf$2(Prototype, it)) return it;
  throw $TypeError$7('Incorrect invocation');
};

var uncurryThis$c = functionUncurryThisClause;
var aCallable$8 = aCallable$a;
var NATIVE_BIND = functionBindNative;

var bind$7 = uncurryThis$c(uncurryThis$c.bind);

// optional / simple context binding
var functionBindContext = function (fn, that) {
  aCallable$8(fn);
  return that === undefined ? fn : NATIVE_BIND ? bind$7(fn, that) : function (/* ...args */) {
    return fn.apply(that, arguments);
  };
};

var uncurryThis$b = functionUncurryThis;

var arraySlice$3 = uncurryThis$b([].slice);

var $TypeError$6 = TypeError;

var validateArgumentsLength$3 = function (passed, required) {
  if (passed < required) throw $TypeError$6('Not enough arguments');
  return passed;
};

var userAgent$6 = engineUserAgent;

// eslint-disable-next-line redos/no-vulnerable -- safe
var engineIsIos = /(?:ipad|iphone|ipod).*applewebkit/i.test(userAgent$6);

var global$a = global$c;
var apply = functionApply;
var bind$6 = functionBindContext;
var isCallable$7 = isCallable$e;
var hasOwn$3 = hasOwnProperty_1;
var fails$8 = fails$e;
var html$1 = html$2;
var arraySlice$2 = arraySlice$3;
var createElement$1 = documentCreateElement$1;
var validateArgumentsLength$2 = validateArgumentsLength$3;
var IS_IOS$1 = engineIsIos;
var IS_NODE$4 = engineIsNode;

var set$5 = global$a.setImmediate;
var clear = global$a.clearImmediate;
var process$4 = global$a.process;
var Dispatch = global$a.Dispatch;
var Function$1 = global$a.Function;
var MessageChannel = global$a.MessageChannel;
var String$1 = global$a.String;
var counter = 0;
var queue$3 = {};
var ONREADYSTATECHANGE = 'onreadystatechange';
var $location, defer, channel, port;

fails$8(function () {
  // Deno throws a ReferenceError on `location` access without `--location` flag
  $location = global$a.location;
});

var run = function (id) {
  if (hasOwn$3(queue$3, id)) {
    var fn = queue$3[id];
    delete queue$3[id];
    fn();
  }
};

var runner = function (id) {
  return function () {
    run(id);
  };
};

var eventListener = function (event) {
  run(event.data);
};

var globalPostMessageDefer = function (id) {
  // old engines have not location.origin
  global$a.postMessage(String$1(id), $location.protocol + '//' + $location.host);
};

// Node.js 0.9+ & IE10+ has setImmediate, otherwise:
if (!set$5 || !clear) {
  set$5 = function setImmediate(handler) {
    validateArgumentsLength$2(arguments.length, 1);
    var fn = isCallable$7(handler) ? handler : Function$1(handler);
    var args = arraySlice$2(arguments, 1);
    queue$3[++counter] = function () {
      apply(fn, undefined, args);
    };
    defer(counter);
    return counter;
  };
  clear = function clearImmediate(id) {
    delete queue$3[id];
  };
  // Node.js 0.8-
  if (IS_NODE$4) {
    defer = function (id) {
      process$4.nextTick(runner(id));
    };
  // Sphere (JS game engine) Dispatch API
  } else if (Dispatch && Dispatch.now) {
    defer = function (id) {
      Dispatch.now(runner(id));
    };
  // Browsers with MessageChannel, includes WebWorkers
  // except iOS - https://github.com/zloirock/core-js/issues/624
  } else if (MessageChannel && !IS_IOS$1) {
    channel = new MessageChannel();
    port = channel.port2;
    channel.port1.onmessage = eventListener;
    defer = bind$6(port.postMessage, port);
  // Browsers with postMessage, skip WebWorkers
  // IE8 has postMessage, but it's sync & typeof its postMessage is 'object'
  } else if (
    global$a.addEventListener &&
    isCallable$7(global$a.postMessage) &&
    !global$a.importScripts &&
    $location && $location.protocol !== 'file:' &&
    !fails$8(globalPostMessageDefer)
  ) {
    defer = globalPostMessageDefer;
    global$a.addEventListener('message', eventListener, false);
  // IE8-
  } else if (ONREADYSTATECHANGE in createElement$1('script')) {
    defer = function (id) {
      html$1.appendChild(createElement$1('script'))[ONREADYSTATECHANGE] = function () {
        html$1.removeChild(this);
        run(id);
      };
    };
  // Rest old browsers
  } else {
    defer = function (id) {
      setTimeout(runner(id), 0);
    };
  }
}

var task$1 = {
  set: set$5,
  clear: clear
};

var Queue$2 = function () {
  this.head = null;
  this.tail = null;
};

Queue$2.prototype = {
  add: function (item) {
    var entry = { item: item, next: null };
    var tail = this.tail;
    if (tail) tail.next = entry;
    else this.head = entry;
    this.tail = entry;
  },
  get: function () {
    var entry = this.head;
    if (entry) {
      var next = this.head = entry.next;
      if (next === null) this.tail = null;
      return entry.item;
    }
  }
};

var queue$2 = Queue$2;

var userAgent$5 = engineUserAgent;

var engineIsIosPebble = /ipad|iphone|ipod/i.test(userAgent$5) && typeof Pebble != 'undefined';

var userAgent$4 = engineUserAgent;

var engineIsWebosWebkit = /web0s(?!.*chrome)/i.test(userAgent$4);

var global$9 = global$c;
var bind$5 = functionBindContext;
var getOwnPropertyDescriptor$3 = objectGetOwnPropertyDescriptor.f;
var macrotask = task$1.set;
var Queue$1 = queue$2;
var IS_IOS = engineIsIos;
var IS_IOS_PEBBLE = engineIsIosPebble;
var IS_WEBOS_WEBKIT = engineIsWebosWebkit;
var IS_NODE$3 = engineIsNode;

var MutationObserver$1 = global$9.MutationObserver || global$9.WebKitMutationObserver;
var document$2 = global$9.document;
var process$3 = global$9.process;
var Promise$1 = global$9.Promise;
// Node.js 11 shows ExperimentalWarning on getting `queueMicrotask`
var queueMicrotaskDescriptor = getOwnPropertyDescriptor$3(global$9, 'queueMicrotask');
var microtask$1 = queueMicrotaskDescriptor && queueMicrotaskDescriptor.value;
var notify$1, toggle, node, promise, then;

// modern engines have queueMicrotask method
if (!microtask$1) {
  var queue$1 = new Queue$1();

  var flush = function () {
    var parent, fn;
    if (IS_NODE$3 && (parent = process$3.domain)) parent.exit();
    while (fn = queue$1.get()) try {
      fn();
    } catch (error) {
      if (queue$1.head) notify$1();
      throw error;
    }
    if (parent) parent.enter();
  };

  // browsers with MutationObserver, except iOS - https://github.com/zloirock/core-js/issues/339
  // also except WebOS Webkit https://github.com/zloirock/core-js/issues/898
  if (!IS_IOS && !IS_NODE$3 && !IS_WEBOS_WEBKIT && MutationObserver$1 && document$2) {
    toggle = true;
    node = document$2.createTextNode('');
    new MutationObserver$1(flush).observe(node, { characterData: true });
    notify$1 = function () {
      node.data = toggle = !toggle;
    };
  // environments with maybe non-completely correct, but existent Promise
  } else if (!IS_IOS_PEBBLE && Promise$1 && Promise$1.resolve) {
    // Promise.resolve without an argument throws an error in LG WebOS 2
    promise = Promise$1.resolve(undefined);
    // workaround of WebKit ~ iOS Safari 10.1 bug
    promise.constructor = Promise$1;
    then = bind$5(promise.then, promise);
    notify$1 = function () {
      then(flush);
    };
  // Node.js without promises
  } else if (IS_NODE$3) {
    notify$1 = function () {
      process$3.nextTick(flush);
    };
  // for other environments - macrotask based on:
  // - setImmediate
  // - MessageChannel
  // - window.postMessage
  // - onreadystatechange
  // - setTimeout
  } else {
    // `webpack` dev server bug on IE global methods - use bind(fn, global)
    macrotask = bind$5(macrotask, global$9);
    notify$1 = function () {
      macrotask(flush);
    };
  }

  microtask$1 = function (fn) {
    if (!queue$1.head) notify$1();
    queue$1.add(fn);
  };
}

var microtask_1 = microtask$1;

var hostReportErrors$1 = function (a, b) {
  try {
    // eslint-disable-next-line no-console -- safe
    arguments.length == 1 ? console.error(a) : console.error(a, b);
  } catch (error) { /* empty */ }
};

var perform$4 = function (exec) {
  try {
    return { error: false, value: exec() };
  } catch (error) {
    return { error: true, value: error };
  }
};

var global$8 = global$c;

var promiseNativeConstructor = global$8.Promise;

/* global Deno -- Deno case */

var engineIsDeno = typeof Deno == 'object' && Deno && typeof Deno.version == 'object';

var IS_DENO$1 = engineIsDeno;
var IS_NODE$2 = engineIsNode;

var engineIsBrowser = !IS_DENO$1 && !IS_NODE$2
  && typeof window == 'object'
  && typeof document == 'object';

var global$7 = global$c;
var NativePromiseConstructor$5 = promiseNativeConstructor;
var isCallable$6 = isCallable$e;
var isForced$1 = isForced_1;
var inspectSource = inspectSource$2;
var wellKnownSymbol$7 = wellKnownSymbol$f;
var IS_BROWSER = engineIsBrowser;
var IS_DENO = engineIsDeno;
var IS_PURE$8 = isPure;
var V8_VERSION = engineV8Version;

var NativePromisePrototype$3 = NativePromiseConstructor$5 && NativePromiseConstructor$5.prototype;
var SPECIES = wellKnownSymbol$7('species');
var SUBCLASSING = false;
var NATIVE_PROMISE_REJECTION_EVENT$1 = isCallable$6(global$7.PromiseRejectionEvent);

var FORCED_PROMISE_CONSTRUCTOR$5 = isForced$1('Promise', function () {
  var PROMISE_CONSTRUCTOR_SOURCE = inspectSource(NativePromiseConstructor$5);
  var GLOBAL_CORE_JS_PROMISE = PROMISE_CONSTRUCTOR_SOURCE !== String(NativePromiseConstructor$5);
  // V8 6.6 (Node 10 and Chrome 66) have a bug with resolving custom thenables
  // https://bugs.chromium.org/p/chromium/issues/detail?id=830565
  // We can't detect it synchronously, so just check versions
  if (!GLOBAL_CORE_JS_PROMISE && V8_VERSION === 66) return true;
  // We need Promise#{ catch, finally } in the pure version for preventing prototype pollution
  if (IS_PURE$8 && !(NativePromisePrototype$3['catch'] && NativePromisePrototype$3['finally'])) return true;
  // We can't use @@species feature detection in V8 since it causes
  // deoptimization and performance degradation
  // https://github.com/zloirock/core-js/issues/679
  if (!V8_VERSION || V8_VERSION < 51 || !/native code/.test(PROMISE_CONSTRUCTOR_SOURCE)) {
    // Detect correctness of subclassing with @@species support
    var promise = new NativePromiseConstructor$5(function (resolve) { resolve(1); });
    var FakePromise = function (exec) {
      exec(function () { /* empty */ }, function () { /* empty */ });
    };
    var constructor = promise.constructor = {};
    constructor[SPECIES] = FakePromise;
    SUBCLASSING = promise.then(function () { /* empty */ }) instanceof FakePromise;
    if (!SUBCLASSING) return true;
  // Unhandled rejections tracking support, NodeJS Promise without it fails @@species test
  } return !GLOBAL_CORE_JS_PROMISE && (IS_BROWSER || IS_DENO) && !NATIVE_PROMISE_REJECTION_EVENT$1;
});

var promiseConstructorDetection = {
  CONSTRUCTOR: FORCED_PROMISE_CONSTRUCTOR$5,
  REJECTION_EVENT: NATIVE_PROMISE_REJECTION_EVENT$1,
  SUBCLASSING: SUBCLASSING
};

var newPromiseCapability$2 = {};

'use strict';
var aCallable$7 = aCallable$a;

var $TypeError$5 = TypeError;

var PromiseCapability = function (C) {
  var resolve, reject;
  this.promise = new C(function ($$resolve, $$reject) {
    if (resolve !== undefined || reject !== undefined) throw $TypeError$5('Bad Promise constructor');
    resolve = $$resolve;
    reject = $$reject;
  });
  this.resolve = aCallable$7(resolve);
  this.reject = aCallable$7(reject);
};

// `NewPromiseCapability` abstract operation
// https://tc39.es/ecma262/#sec-newpromisecapability
var f$8 = newPromiseCapability$2.f = function (C) {
  return new PromiseCapability(C);
};

'use strict';
var $$p = _export;
var IS_PURE$7 = isPure;
var IS_NODE$1 = engineIsNode;
var global$6 = global$c;
var call$d = functionCall;
var defineBuiltIn$6 = defineBuiltIn$9;
var setPrototypeOf$1 = objectSetPrototypeOf;
var setToStringTag$2 = setToStringTag$5;
var setSpecies$1 = setSpecies$2;
var aCallable$6 = aCallable$a;
var isCallable$5 = isCallable$e;
var isObject$4 = isObject$6;
var anInstance$2 = anInstance$3;
var speciesConstructor$1 = speciesConstructor$3;
var task = task$1.set;
var microtask = microtask_1;
var hostReportErrors = hostReportErrors$1;
var perform$3 = perform$4;
var Queue = queue$2;
var InternalStateModule$3 = internalState;
var NativePromiseConstructor$4 = promiseNativeConstructor;
var PromiseConstructorDetection = promiseConstructorDetection;
var newPromiseCapabilityModule$4 = newPromiseCapability$2;

var PROMISE = 'Promise';
var FORCED_PROMISE_CONSTRUCTOR$4 = PromiseConstructorDetection.CONSTRUCTOR;
var NATIVE_PROMISE_REJECTION_EVENT = PromiseConstructorDetection.REJECTION_EVENT;
var NATIVE_PROMISE_SUBCLASSING = PromiseConstructorDetection.SUBCLASSING;
var getInternalPromiseState = InternalStateModule$3.getterFor(PROMISE);
var setInternalState$3 = InternalStateModule$3.set;
var NativePromisePrototype$2 = NativePromiseConstructor$4 && NativePromiseConstructor$4.prototype;
var PromiseConstructor = NativePromiseConstructor$4;
var PromisePrototype = NativePromisePrototype$2;
var TypeError$3 = global$6.TypeError;
var document$1 = global$6.document;
var process$2 = global$6.process;
var newPromiseCapability$1 = newPromiseCapabilityModule$4.f;
var newGenericPromiseCapability = newPromiseCapability$1;

var DISPATCH_EVENT = !!(document$1 && document$1.createEvent && global$6.dispatchEvent);
var UNHANDLED_REJECTION = 'unhandledrejection';
var REJECTION_HANDLED = 'rejectionhandled';
var PENDING = 0;
var FULFILLED = 1;
var REJECTED = 2;
var HANDLED = 1;
var UNHANDLED = 2;

var Internal, OwnPromiseCapability, PromiseWrapper, nativeThen;

// helpers
var isThenable = function (it) {
  var then;
  return isObject$4(it) && isCallable$5(then = it.then) ? then : false;
};

var callReaction = function (reaction, state) {
  var value = state.value;
  var ok = state.state == FULFILLED;
  var handler = ok ? reaction.ok : reaction.fail;
  var resolve = reaction.resolve;
  var reject = reaction.reject;
  var domain = reaction.domain;
  var result, then, exited;
  try {
    if (handler) {
      if (!ok) {
        if (state.rejection === UNHANDLED) onHandleUnhandled(state);
        state.rejection = HANDLED;
      }
      if (handler === true) result = value;
      else {
        if (domain) domain.enter();
        result = handler(value); // can throw
        if (domain) {
          domain.exit();
          exited = true;
        }
      }
      if (result === reaction.promise) {
        reject(TypeError$3('Promise-chain cycle'));
      } else if (then = isThenable(result)) {
        call$d(then, result, resolve, reject);
      } else resolve(result);
    } else reject(value);
  } catch (error) {
    if (domain && !exited) domain.exit();
    reject(error);
  }
};

var notify = function (state, isReject) {
  if (state.notified) return;
  state.notified = true;
  microtask(function () {
    var reactions = state.reactions;
    var reaction;
    while (reaction = reactions.get()) {
      callReaction(reaction, state);
    }
    state.notified = false;
    if (isReject && !state.rejection) onUnhandled(state);
  });
};

var dispatchEvent$1 = function (name, promise, reason) {
  var event, handler;
  if (DISPATCH_EVENT) {
    event = document$1.createEvent('Event');
    event.promise = promise;
    event.reason = reason;
    event.initEvent(name, false, true);
    global$6.dispatchEvent(event);
  } else event = { promise: promise, reason: reason };
  if (!NATIVE_PROMISE_REJECTION_EVENT && (handler = global$6['on' + name])) handler(event);
  else if (name === UNHANDLED_REJECTION) hostReportErrors('Unhandled promise rejection', reason);
};

var onUnhandled = function (state) {
  call$d(task, global$6, function () {
    var promise = state.facade;
    var value = state.value;
    var IS_UNHANDLED = isUnhandled(state);
    var result;
    if (IS_UNHANDLED) {
      result = perform$3(function () {
        if (IS_NODE$1) {
          process$2.emit('unhandledRejection', value, promise);
        } else dispatchEvent$1(UNHANDLED_REJECTION, promise, value);
      });
      // Browsers should not trigger `rejectionHandled` event if it was handled here, NodeJS - should
      state.rejection = IS_NODE$1 || isUnhandled(state) ? UNHANDLED : HANDLED;
      if (result.error) throw result.value;
    }
  });
};

var isUnhandled = function (state) {
  return state.rejection !== HANDLED && !state.parent;
};

var onHandleUnhandled = function (state) {
  call$d(task, global$6, function () {
    var promise = state.facade;
    if (IS_NODE$1) {
      process$2.emit('rejectionHandled', promise);
    } else dispatchEvent$1(REJECTION_HANDLED, promise, state.value);
  });
};

var bind$4 = function (fn, state, unwrap) {
  return function (value) {
    fn(state, value, unwrap);
  };
};

var internalReject = function (state, value, unwrap) {
  if (state.done) return;
  state.done = true;
  if (unwrap) state = unwrap;
  state.value = value;
  state.state = REJECTED;
  notify(state, true);
};

var internalResolve = function (state, value, unwrap) {
  if (state.done) return;
  state.done = true;
  if (unwrap) state = unwrap;
  try {
    if (state.facade === value) throw TypeError$3("Promise can't be resolved itself");
    var then = isThenable(value);
    if (then) {
      microtask(function () {
        var wrapper = { done: false };
        try {
          call$d(then, value,
            bind$4(internalResolve, wrapper, state),
            bind$4(internalReject, wrapper, state)
          );
        } catch (error) {
          internalReject(wrapper, error, state);
        }
      });
    } else {
      state.value = value;
      state.state = FULFILLED;
      notify(state, false);
    }
  } catch (error) {
    internalReject({ done: false }, error, state);
  }
};

// constructor polyfill
if (FORCED_PROMISE_CONSTRUCTOR$4) {
  // 25.4.3.1 Promise(executor)
  PromiseConstructor = function Promise(executor) {
    anInstance$2(this, PromisePrototype);
    aCallable$6(executor);
    call$d(Internal, this);
    var state = getInternalPromiseState(this);
    try {
      executor(bind$4(internalResolve, state), bind$4(internalReject, state));
    } catch (error) {
      internalReject(state, error);
    }
  };

  PromisePrototype = PromiseConstructor.prototype;

  // eslint-disable-next-line no-unused-vars -- required for `.length`
  Internal = function Promise(executor) {
    setInternalState$3(this, {
      type: PROMISE,
      done: false,
      notified: false,
      parent: false,
      reactions: new Queue(),
      rejection: false,
      state: PENDING,
      value: undefined
    });
  };

  // `Promise.prototype.then` method
  // https://tc39.es/ecma262/#sec-promise.prototype.then
  Internal.prototype = defineBuiltIn$6(PromisePrototype, 'then', function then(onFulfilled, onRejected) {
    var state = getInternalPromiseState(this);
    var reaction = newPromiseCapability$1(speciesConstructor$1(this, PromiseConstructor));
    state.parent = true;
    reaction.ok = isCallable$5(onFulfilled) ? onFulfilled : true;
    reaction.fail = isCallable$5(onRejected) && onRejected;
    reaction.domain = IS_NODE$1 ? process$2.domain : undefined;
    if (state.state == PENDING) state.reactions.add(reaction);
    else microtask(function () {
      callReaction(reaction, state);
    });
    return reaction.promise;
  });

  OwnPromiseCapability = function () {
    var promise = new Internal();
    var state = getInternalPromiseState(promise);
    this.promise = promise;
    this.resolve = bind$4(internalResolve, state);
    this.reject = bind$4(internalReject, state);
  };

  newPromiseCapabilityModule$4.f = newPromiseCapability$1 = function (C) {
    return C === PromiseConstructor || C === PromiseWrapper
      ? new OwnPromiseCapability(C)
      : newGenericPromiseCapability(C);
  };

  if (!IS_PURE$7 && isCallable$5(NativePromiseConstructor$4) && NativePromisePrototype$2 !== Object.prototype) {
    nativeThen = NativePromisePrototype$2.then;

    if (!NATIVE_PROMISE_SUBCLASSING) {
      // make `Promise#then` return a polyfilled `Promise` for native promise-based APIs
      defineBuiltIn$6(NativePromisePrototype$2, 'then', function then(onFulfilled, onRejected) {
        var that = this;
        return new PromiseConstructor(function (resolve, reject) {
          call$d(nativeThen, that, resolve, reject);
        }).then(onFulfilled, onRejected);
      // https://github.com/zloirock/core-js/issues/640
      }, { unsafe: true });
    }

    // make `.constructor === Promise` work for native promise-based APIs
    try {
      delete NativePromisePrototype$2.constructor;
    } catch (error) { /* empty */ }

    // make `instanceof Promise` work for native promise-based APIs
    if (setPrototypeOf$1) {
      setPrototypeOf$1(NativePromisePrototype$2, PromisePrototype);
    }
  }
}

$$p({ global: true, constructor: true, wrap: true, forced: FORCED_PROMISE_CONSTRUCTOR$4 }, {
  Promise: PromiseConstructor
});

setToStringTag$2(PromiseConstructor, PROMISE, false, true);
setSpecies$1(PROMISE);

var es_promise_all = {};

var wellKnownSymbol$6 = wellKnownSymbol$f;
var Iterators$1 = iterators;

var ITERATOR$4 = wellKnownSymbol$6('iterator');
var ArrayPrototype = Array.prototype;

// check on default Array iterator
var isArrayIteratorMethod$2 = function (it) {
  return it !== undefined && (Iterators$1.Array === it || ArrayPrototype[ITERATOR$4] === it);
};

var classof$2 = classof$5;
var getMethod$3 = getMethod$6;
var isNullOrUndefined$2 = isNullOrUndefined$6;
var Iterators = iterators;
var wellKnownSymbol$5 = wellKnownSymbol$f;

var ITERATOR$3 = wellKnownSymbol$5('iterator');

var getIteratorMethod$4 = function (it) {
  if (!isNullOrUndefined$2(it)) return getMethod$3(it, ITERATOR$3)
    || getMethod$3(it, '@@iterator')
    || Iterators[classof$2(it)];
};

var call$c = functionCall;
var aCallable$5 = aCallable$a;
var anObject$6 = anObject$b;
var tryToString$2 = tryToString$4;
var getIteratorMethod$3 = getIteratorMethod$4;

var $TypeError$4 = TypeError;

var getIterator$3 = function (argument, usingIterator) {
  var iteratorMethod = arguments.length < 2 ? getIteratorMethod$3(argument) : usingIterator;
  if (aCallable$5(iteratorMethod)) return anObject$6(call$c(iteratorMethod, argument));
  throw $TypeError$4(tryToString$2(argument) + ' is not iterable');
};

var call$b = functionCall;
var anObject$5 = anObject$b;
var getMethod$2 = getMethod$6;

var iteratorClose$2 = function (iterator, kind, value) {
  var innerResult, innerError;
  anObject$5(iterator);
  try {
    innerResult = getMethod$2(iterator, 'return');
    if (!innerResult) {
      if (kind === 'throw') throw value;
      return value;
    }
    innerResult = call$b(innerResult, iterator);
  } catch (error) {
    innerError = true;
    innerResult = error;
  }
  if (kind === 'throw') throw value;
  if (innerError) throw innerResult;
  anObject$5(innerResult);
  return value;
};

var bind$3 = functionBindContext;
var call$a = functionCall;
var anObject$4 = anObject$b;
var tryToString$1 = tryToString$4;
var isArrayIteratorMethod$1 = isArrayIteratorMethod$2;
var lengthOfArrayLike$3 = lengthOfArrayLike$5;
var isPrototypeOf$1 = objectIsPrototypeOf;
var getIterator$2 = getIterator$3;
var getIteratorMethod$2 = getIteratorMethod$4;
var iteratorClose$1 = iteratorClose$2;

var $TypeError$3 = TypeError;

var Result = function (stopped, result) {
  this.stopped = stopped;
  this.result = result;
};

var ResultPrototype = Result.prototype;

var iterate$4 = function (iterable, unboundFunction, options) {
  var that = options && options.that;
  var AS_ENTRIES = !!(options && options.AS_ENTRIES);
  var IS_RECORD = !!(options && options.IS_RECORD);
  var IS_ITERATOR = !!(options && options.IS_ITERATOR);
  var INTERRUPTED = !!(options && options.INTERRUPTED);
  var fn = bind$3(unboundFunction, that);
  var iterator, iterFn, index, length, result, next, step;

  var stop = function (condition) {
    if (iterator) iteratorClose$1(iterator, 'normal', condition);
    return new Result(true, condition);
  };

  var callFn = function (value) {
    if (AS_ENTRIES) {
      anObject$4(value);
      return INTERRUPTED ? fn(value[0], value[1], stop) : fn(value[0], value[1]);
    } return INTERRUPTED ? fn(value, stop) : fn(value);
  };

  if (IS_RECORD) {
    iterator = iterable.iterator;
  } else if (IS_ITERATOR) {
    iterator = iterable;
  } else {
    iterFn = getIteratorMethod$2(iterable);
    if (!iterFn) throw $TypeError$3(tryToString$1(iterable) + ' is not iterable');
    // optimisation for array iterators
    if (isArrayIteratorMethod$1(iterFn)) {
      for (index = 0, length = lengthOfArrayLike$3(iterable); length > index; index++) {
        result = callFn(iterable[index]);
        if (result && isPrototypeOf$1(ResultPrototype, result)) return result;
      } return new Result(false);
    }
    iterator = getIterator$2(iterable, iterFn);
  }

  next = IS_RECORD ? iterable.next : iterator.next;
  while (!(step = call$a(next, iterator)).done) {
    try {
      result = callFn(step.value);
    } catch (error) {
      iteratorClose$1(iterator, 'throw', error);
    }
    if (typeof result == 'object' && result && isPrototypeOf$1(ResultPrototype, result)) return result;
  } return new Result(false);
};

var wellKnownSymbol$4 = wellKnownSymbol$f;

var ITERATOR$2 = wellKnownSymbol$4('iterator');
var SAFE_CLOSING = false;

try {
  var called = 0;
  var iteratorWithReturn = {
    next: function () {
      return { done: !!called++ };
    },
    'return': function () {
      SAFE_CLOSING = true;
    }
  };
  iteratorWithReturn[ITERATOR$2] = function () {
    return this;
  };
  // eslint-disable-next-line es/no-array-from, no-throw-literal -- required for testing
  Array.from(iteratorWithReturn, function () { throw 2; });
} catch (error) { /* empty */ }

var checkCorrectnessOfIteration$1 = function (exec, SKIP_CLOSING) {
  if (!SKIP_CLOSING && !SAFE_CLOSING) return false;
  var ITERATION_SUPPORT = false;
  try {
    var object = {};
    object[ITERATOR$2] = function () {
      return {
        next: function () {
          return { done: ITERATION_SUPPORT = true };
        }
      };
    };
    exec(object);
  } catch (error) { /* empty */ }
  return ITERATION_SUPPORT;
};

var NativePromiseConstructor$3 = promiseNativeConstructor;
var checkCorrectnessOfIteration = checkCorrectnessOfIteration$1;
var FORCED_PROMISE_CONSTRUCTOR$3 = promiseConstructorDetection.CONSTRUCTOR;

var promiseStaticsIncorrectIteration = FORCED_PROMISE_CONSTRUCTOR$3 || !checkCorrectnessOfIteration(function (iterable) {
  NativePromiseConstructor$3.all(iterable).then(undefined, function () { /* empty */ });
});

'use strict';
var $$o = _export;
var call$9 = functionCall;
var aCallable$4 = aCallable$a;
var newPromiseCapabilityModule$3 = newPromiseCapability$2;
var perform$2 = perform$4;
var iterate$3 = iterate$4;
var PROMISE_STATICS_INCORRECT_ITERATION$2 = promiseStaticsIncorrectIteration;

// `Promise.all` method
// https://tc39.es/ecma262/#sec-promise.all
$$o({ target: 'Promise', stat: true, forced: PROMISE_STATICS_INCORRECT_ITERATION$2 }, {
  all: function all(iterable) {
    var C = this;
    var capability = newPromiseCapabilityModule$3.f(C);
    var resolve = capability.resolve;
    var reject = capability.reject;
    var result = perform$2(function () {
      var $promiseResolve = aCallable$4(C.resolve);
      var values = [];
      var counter = 0;
      var remaining = 1;
      iterate$3(iterable, function (promise) {
        var index = counter++;
        var alreadyCalled = false;
        remaining++;
        call$9($promiseResolve, C, promise).then(function (value) {
          if (alreadyCalled) return;
          alreadyCalled = true;
          values[index] = value;
          --remaining || resolve(values);
        }, reject);
      });
      --remaining || resolve(values);
    });
    if (result.error) reject(result.value);
    return capability.promise;
  }
});

var es_promise_catch = {};

'use strict';
var $$n = _export;
var IS_PURE$6 = isPure;
var FORCED_PROMISE_CONSTRUCTOR$2 = promiseConstructorDetection.CONSTRUCTOR;
var NativePromiseConstructor$2 = promiseNativeConstructor;
var getBuiltIn$2 = getBuiltIn$5;
var isCallable$4 = isCallable$e;
var defineBuiltIn$5 = defineBuiltIn$9;

var NativePromisePrototype$1 = NativePromiseConstructor$2 && NativePromiseConstructor$2.prototype;

// `Promise.prototype.catch` method
// https://tc39.es/ecma262/#sec-promise.prototype.catch
$$n({ target: 'Promise', proto: true, forced: FORCED_PROMISE_CONSTRUCTOR$2, real: true }, {
  'catch': function (onRejected) {
    return this.then(undefined, onRejected);
  }
});

// makes sure that native promise-based APIs `Promise#catch` properly works with patched `Promise#then`
if (!IS_PURE$6 && isCallable$4(NativePromiseConstructor$2)) {
  var method$1 = getBuiltIn$2('Promise').prototype['catch'];
  if (NativePromisePrototype$1['catch'] !== method$1) {
    defineBuiltIn$5(NativePromisePrototype$1, 'catch', method$1, { unsafe: true });
  }
}

var es_promise_race = {};

'use strict';
var $$m = _export;
var call$8 = functionCall;
var aCallable$3 = aCallable$a;
var newPromiseCapabilityModule$2 = newPromiseCapability$2;
var perform$1 = perform$4;
var iterate$2 = iterate$4;
var PROMISE_STATICS_INCORRECT_ITERATION$1 = promiseStaticsIncorrectIteration;

// `Promise.race` method
// https://tc39.es/ecma262/#sec-promise.race
$$m({ target: 'Promise', stat: true, forced: PROMISE_STATICS_INCORRECT_ITERATION$1 }, {
  race: function race(iterable) {
    var C = this;
    var capability = newPromiseCapabilityModule$2.f(C);
    var reject = capability.reject;
    var result = perform$1(function () {
      var $promiseResolve = aCallable$3(C.resolve);
      iterate$2(iterable, function (promise) {
        call$8($promiseResolve, C, promise).then(capability.resolve, reject);
      });
    });
    if (result.error) reject(result.value);
    return capability.promise;
  }
});

var es_promise_reject = {};

'use strict';
var $$l = _export;
var call$7 = functionCall;
var newPromiseCapabilityModule$1 = newPromiseCapability$2;
var FORCED_PROMISE_CONSTRUCTOR$1 = promiseConstructorDetection.CONSTRUCTOR;

// `Promise.reject` method
// https://tc39.es/ecma262/#sec-promise.reject
$$l({ target: 'Promise', stat: true, forced: FORCED_PROMISE_CONSTRUCTOR$1 }, {
  reject: function reject(r) {
    var capability = newPromiseCapabilityModule$1.f(this);
    call$7(capability.reject, undefined, r);
    return capability.promise;
  }
});

var es_promise_resolve = {};

var anObject$3 = anObject$b;
var isObject$3 = isObject$6;
var newPromiseCapability = newPromiseCapability$2;

var promiseResolve$2 = function (C, x) {
  anObject$3(C);
  if (isObject$3(x) && x.constructor === C) return x;
  var promiseCapability = newPromiseCapability.f(C);
  var resolve = promiseCapability.resolve;
  resolve(x);
  return promiseCapability.promise;
};

'use strict';
var $$k = _export;
var getBuiltIn$1 = getBuiltIn$5;
var IS_PURE$5 = isPure;
var NativePromiseConstructor$1 = promiseNativeConstructor;
var FORCED_PROMISE_CONSTRUCTOR = promiseConstructorDetection.CONSTRUCTOR;
var promiseResolve$1 = promiseResolve$2;

var PromiseConstructorWrapper = getBuiltIn$1('Promise');
var CHECK_WRAPPER = IS_PURE$5 && !FORCED_PROMISE_CONSTRUCTOR;

// `Promise.resolve` method
// https://tc39.es/ecma262/#sec-promise.resolve
$$k({ target: 'Promise', stat: true, forced: IS_PURE$5 || FORCED_PROMISE_CONSTRUCTOR }, {
  resolve: function resolve(x) {
    return promiseResolve$1(CHECK_WRAPPER && this === PromiseConstructorWrapper ? NativePromiseConstructor$1 : this, x);
  }
});

var es_string_trim = {};

var PROPER_FUNCTION_NAME = functionName.PROPER;
var fails$7 = fails$e;
var whitespaces = whitespaces$1;

var non = '\u200B\u0085\u180E';

// check that a method works with the correct list
// of whitespaces and has a correct name
var stringTrimForced = function (METHOD_NAME) {
  return fails$7(function () {
    return !!whitespaces[METHOD_NAME]()
      || non[METHOD_NAME]() !== non
      || (PROPER_FUNCTION_NAME && whitespaces[METHOD_NAME].name !== METHOD_NAME);
  });
};

'use strict';
var $$j = _export;
var $trim = stringTrim.trim;
var forcedStringTrimMethod$1 = stringTrimForced;

// `String.prototype.trim` method
// https://tc39.es/ecma262/#sec-string.prototype.trim
$$j({ target: 'String', proto: true, forced: forcedStringTrimMethod$1('trim') }, {
  trim: function trim() {
    return $trim(this);
  }
});

//export var app = window.app;
var egw$1 = window.egw;
var framework$1 = window.framework;
var app$1 = window.app;
var egw_getFramework$1 = window.egw_getFramework;
var jQuery$1 = window.jQuery;

var es_regexp_constructor = {};

var isCallable$3 = isCallable$e;
var isObject$2 = isObject$6;
var setPrototypeOf = objectSetPrototypeOf;

// makes subclassing work correct for wrapped built-ins
var inheritIfRequired$1 = function ($this, dummy, Wrapper) {
  var NewTarget, NewTargetPrototype;
  if (
    // it can work only with native `setPrototypeOf`
    setPrototypeOf &&
    // we haven't completely correct pre-ES6 way for getting `new.target`, so use this
    isCallable$3(NewTarget = dummy.constructor) &&
    NewTarget !== Wrapper &&
    isObject$2(NewTargetPrototype = NewTarget.prototype) &&
    NewTargetPrototype !== Wrapper.prototype
  ) setPrototypeOf($this, NewTargetPrototype);
  return $this;
};

var defineProperty$1 = objectDefineProperty.f;

var proxyAccessor$1 = function (Target, Source, key) {
  key in Target || defineProperty$1(Target, key, {
    configurable: true,
    get: function () { return Source[key]; },
    set: function (it) { Source[key] = it; }
  });
};

var DESCRIPTORS$5 = descriptors;
var global$5 = global$c;
var uncurryThis$a = functionUncurryThis;
var isForced = isForced_1;
var inheritIfRequired = inheritIfRequired$1;
var createNonEnumerableProperty = createNonEnumerableProperty$3;
var getOwnPropertyNames = objectGetOwnPropertyNames.f;
var isPrototypeOf = objectIsPrototypeOf;
var isRegExp$1 = isRegexp;
var toString$8 = toString$b;
var getRegExpFlags$1 = regexpGetFlags;
var stickyHelpers = regexpStickyHelpers;
var proxyAccessor = proxyAccessor$1;
var defineBuiltIn$4 = defineBuiltIn$9;
var fails$6 = fails$e;
var hasOwn$2 = hasOwnProperty_1;
var enforceInternalState = internalState.enforce;
var setSpecies = setSpecies$2;
var wellKnownSymbol$3 = wellKnownSymbol$f;
var UNSUPPORTED_DOT_ALL = regexpUnsupportedDotAll;
var UNSUPPORTED_NCG = regexpUnsupportedNcg;

var MATCH = wellKnownSymbol$3('match');
var NativeRegExp = global$5.RegExp;
var RegExpPrototype$1 = NativeRegExp.prototype;
var SyntaxError = global$5.SyntaxError;
var exec$2 = uncurryThis$a(RegExpPrototype$1.exec);
var charAt$3 = uncurryThis$a(''.charAt);
var replace$4 = uncurryThis$a(''.replace);
var stringIndexOf$1 = uncurryThis$a(''.indexOf);
var stringSlice$5 = uncurryThis$a(''.slice);
// TODO: Use only proper RegExpIdentifierName
var IS_NCG = /^\?<[^\s\d!#%&*+<=>@^][^\s!#%&*+<=>@^]*>/;
var re1 = /a/g;
var re2 = /a/g;

// "new" should create a new object, old webkit bug
var CORRECT_NEW = new NativeRegExp(re1) !== re1;

var MISSED_STICKY = stickyHelpers.MISSED_STICKY;
var UNSUPPORTED_Y = stickyHelpers.UNSUPPORTED_Y;

var BASE_FORCED = DESCRIPTORS$5 &&
  (!CORRECT_NEW || MISSED_STICKY || UNSUPPORTED_DOT_ALL || UNSUPPORTED_NCG || fails$6(function () {
    re2[MATCH] = false;
    // RegExp constructor can alter flags and IsRegExp works correct with @@match
    return NativeRegExp(re1) != re1 || NativeRegExp(re2) == re2 || NativeRegExp(re1, 'i') != '/a/i';
  }));

var handleDotAll = function (string) {
  var length = string.length;
  var index = 0;
  var result = '';
  var brackets = false;
  var chr;
  for (; index <= length; index++) {
    chr = charAt$3(string, index);
    if (chr === '\\') {
      result += chr + charAt$3(string, ++index);
      continue;
    }
    if (!brackets && chr === '.') {
      result += '[\\s\\S]';
    } else {
      if (chr === '[') {
        brackets = true;
      } else if (chr === ']') {
        brackets = false;
      } result += chr;
    }
  } return result;
};

var handleNCG = function (string) {
  var length = string.length;
  var index = 0;
  var result = '';
  var named = [];
  var names = {};
  var brackets = false;
  var ncg = false;
  var groupid = 0;
  var groupname = '';
  var chr;
  for (; index <= length; index++) {
    chr = charAt$3(string, index);
    if (chr === '\\') {
      chr = chr + charAt$3(string, ++index);
    } else if (chr === ']') {
      brackets = false;
    } else if (!brackets) switch (true) {
      case chr === '[':
        brackets = true;
        break;
      case chr === '(':
        if (exec$2(IS_NCG, stringSlice$5(string, index + 1))) {
          index += 2;
          ncg = true;
        }
        result += chr;
        groupid++;
        continue;
      case chr === '>' && ncg:
        if (groupname === '' || hasOwn$2(names, groupname)) {
          throw new SyntaxError('Invalid capture group name');
        }
        names[groupname] = true;
        named[named.length] = [groupname, groupid];
        ncg = false;
        groupname = '';
        continue;
    }
    if (ncg) groupname += chr;
    else result += chr;
  } return [result, named];
};

// `RegExp` constructor
// https://tc39.es/ecma262/#sec-regexp-constructor
if (isForced('RegExp', BASE_FORCED)) {
  var RegExpWrapper = function RegExp(pattern, flags) {
    var thisIsRegExp = isPrototypeOf(RegExpPrototype$1, this);
    var patternIsRegExp = isRegExp$1(pattern);
    var flagsAreUndefined = flags === undefined;
    var groups = [];
    var rawPattern = pattern;
    var rawFlags, dotAll, sticky, handled, result, state;

    if (!thisIsRegExp && patternIsRegExp && flagsAreUndefined && pattern.constructor === RegExpWrapper) {
      return pattern;
    }

    if (patternIsRegExp || isPrototypeOf(RegExpPrototype$1, pattern)) {
      pattern = pattern.source;
      if (flagsAreUndefined) flags = getRegExpFlags$1(rawPattern);
    }

    pattern = pattern === undefined ? '' : toString$8(pattern);
    flags = flags === undefined ? '' : toString$8(flags);
    rawPattern = pattern;

    if (UNSUPPORTED_DOT_ALL && 'dotAll' in re1) {
      dotAll = !!flags && stringIndexOf$1(flags, 's') > -1;
      if (dotAll) flags = replace$4(flags, /s/g, '');
    }

    rawFlags = flags;

    if (MISSED_STICKY && 'sticky' in re1) {
      sticky = !!flags && stringIndexOf$1(flags, 'y') > -1;
      if (sticky && UNSUPPORTED_Y) flags = replace$4(flags, /y/g, '');
    }

    if (UNSUPPORTED_NCG) {
      handled = handleNCG(pattern);
      pattern = handled[0];
      groups = handled[1];
    }

    result = inheritIfRequired(NativeRegExp(pattern, flags), thisIsRegExp ? this : RegExpPrototype$1, RegExpWrapper);

    if (dotAll || sticky || groups.length) {
      state = enforceInternalState(result);
      if (dotAll) {
        state.dotAll = true;
        state.raw = RegExpWrapper(handleDotAll(pattern), rawFlags);
      }
      if (sticky) state.sticky = true;
      if (groups.length) state.groups = groups;
    }

    if (pattern !== rawPattern) try {
      // fails in old engines, but we have no alternatives for unsupported regex syntax
      createNonEnumerableProperty(result, 'source', rawPattern === '' ? '(?:)' : rawPattern);
    } catch (error) { /* empty */ }

    return result;
  };

  for (var keys = getOwnPropertyNames(NativeRegExp), index$1 = 0; keys.length > index$1;) {
    proxyAccessor(RegExpWrapper, NativeRegExp, keys[index$1++]);
  }

  RegExpPrototype$1.constructor = RegExpWrapper;
  RegExpWrapper.prototype = RegExpPrototype$1;
  defineBuiltIn$4(global$5, 'RegExp', RegExpWrapper, { constructor: true });
}

// https://tc39.es/ecma262/#sec-get-regexp-@@species
setSpecies('RegExp');

/**
 * IE Fix for array.indexOf
 */
if (typeof Array.prototype.indexOf == "undefined") {
  Array.prototype.indexOf = function (_elem) {
    for (var i = 0; i < this.length; i++) {
      if (this[i] === _elem) return i;
    }
    return -1;
  };
}

/**
 * Array with all types supported by the et2_checkType function.
 */
var et2_validTypes = ["boolean", "string", "rawstring", "html", "float", "integer", "any", "js", "dimension"];

/**
 * Object whith default values for the above types. Do not specify array or
 * objects inside the et2_typeDefaults object, as this instance will be shared
 * between all users of it.
 */
var et2_typeDefaults = {
  "boolean": false,
  "string": "",
  "rawstring": "",
  // no html-entity decoding
  "html": "",
  "js": null,
  "float": 0.0,
  "integer": 0,
  "any": null,
  "dimension": "auto"
};
function et2_evalBool(_val) {
  if (typeof _val == "string") {
    if (_val == "false" || _val == "0") {
      return false;
    }
  }
  return _val ? true : false;
}

/**
 * Concat et2 name together, eg. et2_concat("namespace","test[something]") == "namespace[test][something]"
 * @param variable number of arguments to contact
 * @returns string
 */
function et2_form_name(_cname, _name) {
  var parts = [];
  for (var i = 0; i < arguments.length; ++i) {
    var name = arguments[i];
    if (typeof name == 'string' && name.length > 0)
      // et2_namespace("","test") === "test" === et2_namespace(null,"test")
      {
        parts = parts.concat(name.replace(/]/g, '').split('['));
      }
  }
  var name = parts.shift();
  return parts.length ? name + '[' + parts.join('][') + ']' : name;
}

/**
 * Checks whether the given value is of the given type. Strings are converted
 * into the corresponding type. The (converted) value is returned. All supported
 * types are listed in the et2_validTypes array.
 *
 * @param mixed _val value
 * @param string _type a valid type eg. "string" or "js"
 * @param string _attr attribute name
 * @param object _widget
 */
function et2_checkType(_val, _type, _attr, _widget) {
  if (typeof _attr == "undefined") {
    _attr = null;
  }
  function _err() {
    var res = et2_typeDefaults[_type];
    if (typeof _val != "undefined" && _val) {
      egw$1.debug("warn", "Widget %o: '" + _val + "' was not of specified _type '" + _type + (_attr != null ? "' for attribute '" + _attr + "' " : "") + "and is now '" + res + "'", _widget);
    }
    return res;
  }

  // If the type is "any" simply return the value again
  if (_type == "any") {
    return _val;
  }

  // we dont check default-value any further, that also fixes type="js" does NOT accept null,
  // which happens on expanded values
  if (_val === et2_typeDefaults[_type]) {
    return _val;
  }

  // If the type is boolean, check whether the given value is exactly true or
  // false. Otherwise check whether the value is the string "true" or "false".
  if (_type == "boolean") {
    if (_val === true || _val === false) {
      return _val;
    }
    if (typeof _val == "string") {
      var lcv = _val.toLowerCase();
      if (lcv === "true" || lcv === "false" || lcv === "") {
        return _val === "true";
      }
      if (lcv === "0" || lcv === "1") {
        return _val === "1";
      }
    } else if (typeof _val == "number") {
      return _val != 0;
    }
    return _err();
  }

  // Check whether the given value is of the type "string"
  if (_type == "string" || _type == "html" || _type == "rawstring") {
    if (typeof _val == "number")
      // as php is a bit vague here, silently convert to a string
      {
        return _val.toString();
      }
    if (typeof _val == "string") {
      return _type == "string" ? html_entity_decode(_val) : _val;
    }

    // Handle some less common possibilities
    // Maybe a split on an empty string
    if (typeof _val == "object" && jQuery.isEmptyObject(_val)) return "";
    return _err();
  }

  // Check whether the value is already a number, otherwise try to convert it
  // to one.
  if (_type == "float") {
    if (typeof _val == "number") {
      return _val;
    }
    if (!isNaN(_val)) {
      return parseFloat(_val);
    }
    return _err();
  }

  // Check whether the value is an integer by comparing the result of
  // parseInt(_val) to the value itself.
  if (_type == "integer") {
    var unit_reg_exp = /^(\d+)(b|k|kb|m|mb|g|gb)$/i;
    // allow to use b, k, kb, m, mb, g or gb postfix
    if (typeof _val === "string" && _val.match(unit_reg_exp)) {
      var matches = _val.match(unit_reg_exp);
      switch (matches[2].toLowerCase()[0]) {
        case 'b':
          _val = parseInt(matches[1]);
          break;
        case 'k':
          _val = parseInt(matches[1]) * 1024;
          break;
        case 'm':
          _val = parseInt(matches[1]) * 1024 * 1024;
          break;
        case 'g':
          _val = parseInt(matches[1]) * 1024 * 1024 * 1024;
          break;
      }
    }
    if (parseInt(_val) == _val) {
      return parseInt(_val);
    }
    return _err();
  }

  // Parse the given dimension value
  if (_type == "dimension") {
    // Case 1: The value is "auto"
    if (_val == "auto") {
      return _val;
    }

    // Case 2: The value is simply a number, attach "px"
    if (!isNaN(_val)) {
      return parseFloat(_val) + "px";
    }

    // Case 3: The value is already a valid css pixel value or a percentage
    if (typeof _val == "string" && (_val.indexOf("px") == _val.length - 2 && !isNaN(_val.split("px")[0]) || _val.indexOf("%") == _val.length - 1 && !isNaN(_val.split("%")[0]))) {
      return _val;
    }
    return _err();
  }

  // Javascript
  if (_type == "js") {
    if (typeof _val == "function" || typeof _val == "undefined") {
      return _val;
    }
    if (_val) _val = _val.replace(/window\.close\(\)/g, 'egw(window).close()');

    // Check to see if it's a string in app.appname.function format, and wrap it in
    // a closure to make sure context is preserved
    if (typeof _val == "string" && _val.substr(0, 4) == "app." && app) {
      var parts = _val.split('.');
      var func = parts.pop();
      var parent = window;
      for (var i = 0; i < parts.length && typeof parent[parts[i]] != 'undefined'; ++i) {
        parent = parent[parts[i]];
      }
      if (typeof parent[func] == 'function') {
        try {
          return jQuery.proxy(parent[func], parent);
        } catch (e) {
          egw$1.debug('error', 'Function', _val);
          return _err();
        }
      }
    }
    if (!_val || typeof _val == "string") {
      return _val; // get compiled later in widgets own initAttributes, as widget is not yet initialised
    }
  }

  // We should never come here
  throw "Invalid type identifier '" + _attr + "': '" + _type + "'";
}

/**
 * If et2_no_init is set as default value, the initAttributes function will not
 * try to initialize the attribute with the default value.
 */
var et2_no_init = new Object();

/**
 * Validates the given attribute with the given id. The validation checks for
 * the existance of a human name, a description, a type and a default value.
 * If the human name defaults to the given id, the description defaults to an
 * empty string, the type defaults to any and the default to the corresponding
 * type default.
 */
function et2_validateAttrib(_id, _attrib) {
  // Default ignore to false.
  if (typeof _attrib["ignore"] == "undefined") {
    _attrib["ignore"] = false;
  }

  // Break if "ignore" is set to true.
  if (_attrib.ignore) {
    return;
  }
  if (typeof _attrib["name"] == "undefined") {
    _attrib["name"] = _id;
    egw$1.debug("log", "Human name ('name'-Field) for attribute '" + _id + "' has not been supplied, set to '" + _id + "'");
  }
  if (typeof _attrib["description"] == "undefined") {
    _attrib["description"] = "";
    egw$1.debug("log", "Description for attribute '" + _id + "' has not been supplied");
  }
  if (typeof _attrib["type"] == "undefined") {
    _attrib["type"] = "any";
  } else {
    if (et2_validTypes.indexOf(_attrib["type"]) < 0) {
      egw$1.debug("error", "Invalid type '" + _attrib["type"] + "' for attribute '" + _id + "' supplied.  Valid types are ", et2_validTypes);
    }
  }

  // Set the defaults
  if (typeof _attrib["default"] == "undefined") {
    _attrib["default"] = et2_typeDefaults[_attrib["type"]];
  }
}

/**
 * Equivalent to the PHP array_values function
 */
function et2_arrayValues(_arr) {
  var result = [];
  for (var key in _arr) {
    // @ts-ignore we check key is an integer
    if (parseInt(key) == key) {
      result.push(_arr[key]);
    }
  }
  return result;
}

/**
 * Equivalent to the PHP array_keys function
 */
function et2_arrayKeys(_arr) {
  var result = [];
  for (var key in _arr) {
    result.push(key);
  }
  return result;
}
function et2_arrayIntKeys(_arr) {
  var result = [];
  for (var key in _arr) {
    result.push(parseInt(key));
  }
  return result;
}

/**
 * Equivalent to the PHP substr function, partly take from phpjs, licensed under
 * the GPL.
 */
function et2_substr(str, start, len) {
  var end = str.length;
  if (start < 0) {
    start += end;
  }
  end = typeof len === 'undefined' ? end : len < 0 ? len + end : len + start;
  return start >= str.length || start < 0 || start > end ? "" : str.slice(start, end);
}

/**
 * Split a $delimiter-separated options string, which can contain parts with
 * delimiters enclosed in $enclosure. Ported from class.boetemplate.inc.php
 *
 * Examples:
 * - et2_csvSplit('"1,2,3",2,3') === array('1,2,3','2','3')
 * - et2_csvSplit('1,2,3',2) === array('1','2,3')
 * - et2_csvSplit('"1,2,3",2,3',2) === array('1,2,3','2,3')
 * - et2_csvSplit('"a""b,c",d') === array('a"b,c','d')	// to escape enclosures double them!
 *
 * @param string _str
 * @param int _num=null in how many parts to split maximal, parts over this
 * 	number end up (unseparated) in the last part
 * @param string _delimiter=','
 * @param string _enclosure='"'
 * @return array
 */
function et2_csvSplit(_str, _num, _delimiter, _enclosure) {
  // Default the parameters
  if (typeof _str == "undefined" || _str == null) {
    _str = "";
  }
  if (typeof _num == "undefined") {
    _num = null;
  }
  if (typeof _delimiter == "undefined") {
    _delimiter = ",";
  }
  if (typeof _enclosure == "undefined") {
    _enclosure = '"';
  }

  // If the _enclosure string does not occur in the string, simply use the
  // split function
  if (_str.indexOf(_enclosure) == -1) {
    return _num === null ? _str.split(_delimiter) : _str.split(_delimiter, _num);
  }

  // Split the string at the delimiter and join it again, when a enclosure is
  // found at the beginning/end of a part
  var parts = _str.split(_delimiter);
  for (var n = 0; typeof parts[n] != "undefined"; n++) {
    var part = parts[n];
    if (part.charAt(0) === _enclosure) {
      var m = n;
      while (typeof parts[m + 1] != "undefined" && parts[n].substr(-1) !== _enclosure) {
        parts[n] += _delimiter + parts[++m];
        delete parts[m];
      }
      parts[n] = et2_substr(parts[n].replace(new RegExp(_enclosure + _enclosure, 'g'), _enclosure), 1, -1);
      n = m;
    }
  }

  // Rebuild the array index
  parts = et2_arrayValues(parts);

  // Limit the parts to the given number
  if (_num !== null && _num > 0 && _num < parts.length && parts.length > 0) {
    parts[_num - 1] = parts.slice(_num - 1, parts.length).join(_delimiter);
    parts = parts.slice(0, _num);
  }
  return parts;
}

/**
 * Parses the given string and returns an array marking parts which are URLs
 */
function et2_activateLinks(_content) {
  var _match = false;
  var arr = [];
  function _splitPush(_matches, _proc) {
    if (_matches) {
      // We had a match
      _match = true;

      // Replace "undefined" with ""
      for (var i = 1; i < _matches.length; i++) {
        if (typeof _matches[i] == "undefined") {
          _matches[i] = "";
        }
      }

      // Split the content string at the given position(s)
      // but we only handle the first occurence
      var splitted = _content.split(_matches[0]);

      // Push the not-matched part
      var left = splitted.shift();
      if (left) {
        // activate the links of the left string
        arr = arr.concat(et2_activateLinks(left));
      }

      // Call the callback function which converts the matches into an object
      // and appends it to the string
      _proc(_matches);

      // Set the new working string to the right part
      _content = splitted.join(_matches[0]);
    }
  }
  var mail_regExp = /(mailto:)?([a-z0-9._-]+)@([a-z0-9_-]+)\.([a-z0-9._-]+)/i;

  //  First match things beginning with http:// (or other protocols)
  var protocol = '(http:\\/\\/|(ftp:\\/\\/|https:\\/\\/))'; // only http:// gets removed, other protocolls are shown
  var domain = '([\\w-]+\\.[\\w-.]+)';
  var subdir = '([\\w\\-\\.,@?^=%&;:\\/~\\+#]*[\\w\\-\\@?^=%&\\/~\\+#])?';
  var http_regExp = new RegExp(protocol + domain + subdir, 'i');

  //  Now match things beginning with www.
  var domain = 'www(\\.[\\w-.]+)';
  var subdir = '([\\w\\-\\.,@?^=%&:\\/~\\+#]*[\\w\\-\\@?^=%&\\/~\\+#])?';
  var www_regExp = new RegExp(domain + subdir, 'i');
  do {
    _match = false;

    // Abort if the remaining length of _content is smaller than 20 for
    // performance reasons
    if (!_content) {
      break;
    }

    // No need make emailaddress spam-save, as it gets dynamically created
    _splitPush(_content.match(mail_regExp), function (_matches) {
      arr.push({
        "href": (_matches[1] ? '' : 'mailto:') + _matches[0],
        "text": _matches[2] + "@" + _matches[3] + "." + _matches[4]
      });
    });

    // Create hrefs for links starting with "http://"
    _splitPush(_content.match(http_regExp), function (_matches) {
      arr.push({
        "href": _matches[0],
        "text": _matches[2] + _matches[3] + _matches[4]
      });
    });

    // Create hrefs for links starting with "www."
    _splitPush(_content.match(www_regExp), function (_matches) {
      arr.push({
        "href": "http://" + _matches[0],
        "text": _matches[0]
      });
    });
  } while (_match);
  arr.push(_content);
  return arr;
}

/**
 * Inserts the structure generated by et2_activateLinks into the given DOM-Node
 */
function et2_insertLinkText(_text, _node, _target) {
  if (!_node) {
    egw$1.debug("warn", "et2_insertLinkText called without node", _text, _node, _target);
    return;
  }

  // Clear the node
  for (var i = _node.childNodes.length - 1; i >= 0; i--) {
    _node.removeChild(_node.childNodes[i]);
  }
  for (var i = 0; i < _text.length; i++) {
    var _s;
    var s = _text[i];
    if (typeof s == "string" || typeof s == "number") {
      // Include line breaks
      var lines = typeof s !== "number" && s.split ? s.split('\n') : [s + ""];

      // Insert the lines
      for (var j = 0; j < lines.length; j++) {
        _node.appendChild(document.createTextNode(lines[j]));
        if (j < lines.length - 1) {
          _node.appendChild(document.createElement("br"));
        }
      }
    } else if ((_s = s) !== null && _s !== void 0 && _s.text)
      // no need to generate a link, if there is no content in it
      {
        if (!s.href) {
          egw$1.debug("warn", "et2_activateLinks gave bad data", s, _node, _target);
          s.href = "";
        }
        var a = jQuery(document.createElement("a")).attr("href", s.href).text(s.text);
        if (typeof _target != "undefined" && _target && _target != "_self" && s.href.substr(0, 7) != "mailto:") {
          a.attr("target", _target);
        }
        // open mailto links depending on preferences in mail app
        if (s.href.substr(0, 7) == "mailto:" && (egw$1.user('apps').mail || egw$1.user('apps').felamimail) && egw$1.preference('force_mailto', 'addressbook') != '1') {
          a.click(function (event) {
            egw$1.open_link(this.href);
            return false;
          });
        }
        a.appendTo(_node);
      }
  }
}

/**
 * Creates a copy of the given object (non recursive)
 */
function et2_cloneObject(_obj) {
  var result = {};
  for (var key in _obj) {
    result[key] = _obj[key];
  }
  return result;
}

/**
 * Returns true if the given array of nodes or their children contains the given
 * child node.
 */
function et2_hasChild(_nodes, _child) {
  for (var i = 0; i < _nodes.length; i++) {
    if (_nodes[i] == _child) {
      return true;
    } else if (_nodes[i].childNodes) {
      var res = et2_hasChild(_nodes[i].childNodes, _child);
      if (res) {
        return true;
      }
    }
  }
  return false;
}

/**
 * Functions to work with ranges and range intersection (used in the dataview)
 */

/**
 * Common functions used in most view classes
 */

/**
 * Returns an "range" object with the given top position and height
 */
function et2_range(_top, _height) {
  return {
    "top": _top,
    "bottom": _top + _height
  };
}

/**
 * Returns an "area" object with the given top- and bottom position
 */
function et2_bounds(_top, _bottom) {
  return {
    "top": _top,
    "bottom": _bottom
  };
}

/**
 * Returns whether two range objects intersect each other
 */
function et2_rangeIntersect(_ar1, _ar2) {
  return !(_ar1.bottom < _ar2.top || _ar1.top > _ar2.bottom);
}

/**
 * Returns whether two ranges intersect (result = 0) or their relative position
 * to each other (used to do a binary search inside a list of sorted range objects).
 */
function et2_rangeIntersectDir(_ar1, _ar2) {
  if (_ar1.bottom < _ar2.top) {
    return -1;
  }
  if (_ar1.top > _ar2.bottom) {
    return 1;
  }
  return 0;
}

/**
 * Returns whether two ranges are equal.
 */
function et2_rangeEqual(_ar1, _ar2) {
  return _ar1.top === _ar2.top && _ar1.bottom === _ar2.bottom;
}

/**
 * Substracts _ar2 from _ar1, returns an array of new ranges.
 */
function et2_rangeSubstract(_ar1, _ar2) {
  // Per default return the complete _ar1 range
  var res = [_ar1];

  // Check whether there is an intersection between the given ranges
  if (et2_rangeIntersect(_ar1, _ar2)) {
    res = [et2_bounds(_ar1.top, _ar2.top), et2_bounds(_ar2.bottom, _ar1.bottom)];
  }

  // Remove all zero-length ranges from the result
  for (var i = res.length - 1; i >= 0; i--) {
    if (res[i].bottom - res[i].top <= 0) {
      res.splice(i, 1);
    }
  }
  return res;
}

/**
 * Decode html entities so they can be added via .text(_str), eg. html_entity_decode('&amp;') === '&'
 *
 * @param {string} _str
 * @returns {string}
 */
function html_entity_decode(_str) {
  return _str && _str.indexOf('&') != -1 ? jQuery('<span>' + _str + '</span>').text() : _str;
}

var es_object_assign = {};

'use strict';
var DESCRIPTORS$4 = descriptors;
var uncurryThis$9 = functionUncurryThis;
var call$6 = functionCall;
var fails$5 = fails$e;
var objectKeys = objectKeys$1;
var getOwnPropertySymbolsModule = objectGetOwnPropertySymbols;
var propertyIsEnumerableModule = objectPropertyIsEnumerable;
var toObject$3 = toObject$6;
var IndexedObject$1 = indexedObject;

// eslint-disable-next-line es/no-object-assign -- safe
var $assign = Object.assign;
// eslint-disable-next-line es/no-object-defineproperty -- required for testing
var defineProperty = Object.defineProperty;
var concat = uncurryThis$9([].concat);

// `Object.assign` method
// https://tc39.es/ecma262/#sec-object.assign
var objectAssign = !$assign || fails$5(function () {
  // should have correct order of operations (Edge bug)
  if (DESCRIPTORS$4 && $assign({ b: 1 }, $assign(defineProperty({}, 'a', {
    enumerable: true,
    get: function () {
      defineProperty(this, 'b', {
        value: 3,
        enumerable: false
      });
    }
  }), { b: 2 })).b !== 1) return true;
  // should work with symbols and should have deterministic property order (V8 bug)
  var A = {};
  var B = {};
  // eslint-disable-next-line es/no-symbol -- safe
  var symbol = Symbol();
  var alphabet = 'abcdefghijklmnopqrst';
  A[symbol] = 7;
  alphabet.split('').forEach(function (chr) { B[chr] = chr; });
  return $assign({}, A)[symbol] != 7 || objectKeys($assign({}, B)).join('') != alphabet;
}) ? function assign(target, source) { // eslint-disable-line no-unused-vars -- required for `.length`
  var T = toObject$3(target);
  var argumentsLength = arguments.length;
  var index = 1;
  var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
  var propertyIsEnumerable = propertyIsEnumerableModule.f;
  while (argumentsLength > index) {
    var S = IndexedObject$1(arguments[index++]);
    var keys = getOwnPropertySymbols ? concat(objectKeys(S), getOwnPropertySymbols(S)) : objectKeys(S);
    var length = keys.length;
    var j = 0;
    var key;
    while (length > j) {
      key = keys[j++];
      if (!DESCRIPTORS$4 || call$6(propertyIsEnumerable, S, key)) T[key] = S[key];
    }
  } return T;
} : $assign;

var $$i = _export;
var assign$1 = objectAssign;

// `Object.assign` method
// https://tc39.es/ecma262/#sec-object.assign
// eslint-disable-next-line es/no-object-assign -- required for testing
$$i({ target: 'Object', stat: true, arity: 2, forced: Object.assign !== assign$1 }, {
  assign: assign$1
});

var es_string_startsWith = {};

'use strict';
var $$h = _export;
var uncurryThis$8 = functionUncurryThisClause;
var getOwnPropertyDescriptor$2 = objectGetOwnPropertyDescriptor.f;
var toLength$2 = toLength$5;
var toString$7 = toString$b;
var notARegExp$1 = notARegexp;
var requireObjectCoercible$4 = requireObjectCoercible$7;
var correctIsRegExpLogic$1 = correctIsRegexpLogic;
var IS_PURE$4 = isPure;

// eslint-disable-next-line es/no-string-prototype-startswith -- safe
var nativeStartsWith = uncurryThis$8(''.startsWith);
var stringSlice$4 = uncurryThis$8(''.slice);
var min$2 = Math.min;

var CORRECT_IS_REGEXP_LOGIC$1 = correctIsRegExpLogic$1('startsWith');
// https://github.com/zloirock/core-js/pull/702
var MDN_POLYFILL_BUG$1 = !IS_PURE$4 && !CORRECT_IS_REGEXP_LOGIC$1 && !!function () {
  var descriptor = getOwnPropertyDescriptor$2(String.prototype, 'startsWith');
  return descriptor && !descriptor.writable;
}();

// `String.prototype.startsWith` method
// https://tc39.es/ecma262/#sec-string.prototype.startswith
$$h({ target: 'String', proto: true, forced: !MDN_POLYFILL_BUG$1 && !CORRECT_IS_REGEXP_LOGIC$1 }, {
  startsWith: function startsWith(searchString /* , position = 0 */) {
    var that = toString$7(requireObjectCoercible$4(this));
    notARegExp$1(searchString);
    var index = toLength$2(min$2(arguments.length > 1 ? arguments[1] : undefined, that.length));
    var search = toString$7(searchString);
    return nativeStartsWith
      ? nativeStartsWith(that, search, index)
      : stringSlice$4(that, index, index + search.length) === search;
  }
});

var es_array_reduce = {};

var aCallable$2 = aCallable$a;
var toObject$2 = toObject$6;
var IndexedObject = indexedObject;
var lengthOfArrayLike$2 = lengthOfArrayLike$5;

var $TypeError$2 = TypeError;

// `Array.prototype.{ reduce, reduceRight }` methods implementation
var createMethod$1 = function (IS_RIGHT) {
  return function (that, callbackfn, argumentsLength, memo) {
    aCallable$2(callbackfn);
    var O = toObject$2(that);
    var self = IndexedObject(O);
    var length = lengthOfArrayLike$2(O);
    var index = IS_RIGHT ? length - 1 : 0;
    var i = IS_RIGHT ? -1 : 1;
    if (argumentsLength < 2) while (true) {
      if (index in self) {
        memo = self[index];
        index += i;
        break;
      }
      index += i;
      if (IS_RIGHT ? index < 0 : length <= index) {
        throw $TypeError$2('Reduce of empty array with no initial value');
      }
    }
    for (;IS_RIGHT ? index >= 0 : length > index; index += i) if (index in self) {
      memo = callbackfn(memo, self[index], index, O);
    }
    return memo;
  };
};

var arrayReduce = {
  // `Array.prototype.reduce` method
  // https://tc39.es/ecma262/#sec-array.prototype.reduce
  left: createMethod$1(false),
  // `Array.prototype.reduceRight` method
  // https://tc39.es/ecma262/#sec-array.prototype.reduceright
  right: createMethod$1(true)
};

'use strict';
var fails$4 = fails$e;

var arrayMethodIsStrict$2 = function (METHOD_NAME, argument) {
  var method = [][METHOD_NAME];
  return !!method && fails$4(function () {
    // eslint-disable-next-line no-useless-call -- required for testing
    method.call(null, argument || function () { return 1; }, 1);
  });
};

'use strict';
var $$g = _export;
var $reduce = arrayReduce.left;
var arrayMethodIsStrict$1 = arrayMethodIsStrict$2;
var CHROME_VERSION = engineV8Version;
var IS_NODE = engineIsNode;

// Chrome 80-82 has a critical bug
// https://bugs.chromium.org/p/chromium/issues/detail?id=1049982
var CHROME_BUG = !IS_NODE && CHROME_VERSION > 79 && CHROME_VERSION < 83;
var FORCED$2 = CHROME_BUG || !arrayMethodIsStrict$1('reduce');

// `Array.prototype.reduce` method
// https://tc39.es/ecma262/#sec-array.prototype.reduce
$$g({ target: 'Array', proto: true, forced: FORCED$2 }, {
  reduce: function reduce(callbackfn /* , initialValue */) {
    var length = arguments.length;
    return $reduce(this, callbackfn, length, length > 1 ? arguments[1] : undefined);
  }
});

var es_array_reverse = {};

var classof$1 = classofRaw;

// `IsArray` abstract operation
// https://tc39.es/ecma262/#sec-isarray
// eslint-disable-next-line es/no-array-isarray -- safe
var isArray$2 = Array.isArray || function isArray(argument) {
  return classof$1(argument) == 'Array';
};

'use strict';
var $$f = _export;
var uncurryThis$7 = functionUncurryThis;
var isArray$1 = isArray$2;

var nativeReverse = uncurryThis$7([].reverse);
var test$1 = [1, 2];

// `Array.prototype.reverse` method
// https://tc39.es/ecma262/#sec-array.prototype.reverse
// fix for Safari 12.0 bug
// https://bugs.webkit.org/show_bug.cgi?id=188794
$$f({ target: 'Array', proto: true, forced: String(test$1) === String(test$1.reverse()) }, {
  reverse: function reverse() {
    // eslint-disable-next-line no-self-assign -- dirty hack
    if (isArray$1(this)) this.length = this.length;
    return nativeReverse(this);
  }
});

/**
 * Function which compiles the given PHP string to a JS function which can be
 * easily executed.
 *
 * @param _expr is the PHP string expression
 * @param _vars is an array with variable names (without the PHP $).
 * 	The parameters have to be passed to the resulting JS function in the same
 * 	order.
 */
function et2_compilePHPExpression(_expr, _vars) {
  if (typeof _vars == "undefined") {
    _vars = [];
  }
  try {
    // Initialize the parser object and create the syntax tree for the given
    // expression
    var parser = _php_parser(_expr);
    var syntaxTree = [];

    // Parse the given expression as if it was a double quoted string
    _php_parseDoubleQuoteString(parser, syntaxTree);

    // Transform the generated syntaxTree into a JS string
    var js = _php_compileJSCode(_vars, syntaxTree);

    // Log the successfull compiling
    egw$1.debug("log", "Compiled PHP " + _expr + " --> " + js);
  } catch (e) {
    // if expression does NOT compile use it literally and log a warning, but not stop execution
    egw$1.debug("warn", "Error compiling PHP " + _expr + " --> using it literally (" + (typeof e == 'string' ? e : e.message) + ")!");
    return function () {
      return _expr;
    };
  }
  // Prepate the attributes for the function constuctor
  var attrs = [];
  for (var i = 0; i < _vars.length; i++) {
    attrs.push("_" + _vars[i]);
  }
  attrs.push(js);

  // Create the function and return it
  return Function.apply(Function, attrs);
}
var STATE_DEFAULT = 0;
var STATE_ESCAPED = 1;
var STATE_CURLY_BRACE_OPEN = 2;
var STATE_EXPECT_CURLY_BRACE_CLOSE = 3;
var STATE_EXPECT_RECT_BRACE_CLOSE = 4;
var STATE_EXPR_BEGIN = 5;
var STATE_EXPR_END = 6;
function _throwParserErr(_p, _err) {
  throw "Syntax error while parsing '" + _p.expr + "' at " + _p.pos + ", " + _err;
}
function _php_parseDoubleQuoteString(_p, _tree) {
  // Extract all PHP variables from the string
  var state = STATE_DEFAULT;
  var str = "";
  while (_p.pos < _p.expr.length) {
    // Read the current char and then increment the parser position by
    // one
    var c = _p.expr.charAt(_p.pos++);
    switch (state) {
      case STATE_DEFAULT:
      case STATE_CURLY_BRACE_OPEN:
        switch (c) {
          case '\\':
            state = STATE_ESCAPED;
            break;
          case '$':
            // check for '$$' as used in placeholder syntax, it is NOT expanded and returned as is
            if (_p.expr.charAt(_p.pos) == "$" && state == STATE_DEFAULT) {
              _p.pos++;
              str += '$$';
              break;
            }
            // check for '$' as last char, as in PHP "test$" === 'test$', $ as last char is NOT expanded
            if (_p.pos == _p.expr.length) {
              str += '$';
              break;
            }
            // check for regular expression "/  $/"
            if (_p.expr.charAt(_p.pos) == '/' && _p.expr.charAt(0) == '/') {
              str += '$';
              break;
            }
            if (str) {
              _tree.push(str);
              str = "";
            }

            // Support for the ${[expr] sytax
            if (_p.expr.charAt(_p.pos) == "{" && state != STATE_CURLY_BRACE_OPEN) {
              state = STATE_CURLY_BRACE_OPEN;
              _p.pos++;
            }
            if (state == STATE_CURLY_BRACE_OPEN) {
              _tree.push(_php_parseVariable(_p));
              state = STATE_EXPECT_CURLY_BRACE_CLOSE;
            } else {
              _tree.push(_php_parseVariable(_p));
            }
            break;
          case '{':
            state = STATE_CURLY_BRACE_OPEN;
            break;
          default:
            if (state == STATE_CURLY_BRACE_OPEN) {
              str += '{';
              state = STATE_DEFAULT;
            }
            str += c;
        }
        break;
      case STATE_ESCAPED:
        str += c;
        break;
      case STATE_EXPECT_CURLY_BRACE_CLOSE:
        // When returning from the variableEx parser,
        // the current char must be a "}"
        if (c != "}") {
          _throwParserErr(_p, "expected '}', but got " + c);
        }
        state = STATE_DEFAULT;
        break;
    }
  }

  // Throw an error when reaching the end of the string but expecting
  // "}"
  if (state == STATE_EXPECT_CURLY_BRACE_CLOSE) {
    _throwParserErr(_p, "unexpected end of string, expected '}'");
  }

  // Push the last part of the string onto the syntax tree
  if (state == STATE_CURLY_BRACE_OPEN) {
    str += "{";
  }
  if (str) {
    _tree.push(str);
  }
}

// Regular expression which matches on PHP variable identifiers (without the $)
var PHP_VAR_PREG = /^([A-Za-z0-9_]+)/;
function _php_parseVariableName(_p) {
  // Extract the variable name form the expression
  var vname = PHP_VAR_PREG.exec(_p.expr.substr(_p.pos));
  if (vname) {
    // Increment the parser position by the length of vname
    _p.pos += vname[0].length;
    return {
      "variable": vname[0],
      "accessExpressions": []
    };
  }
  _throwParserErr(_p, "expected variable identifier.");
}
function _php_parseVariable(_p) {
  // Parse the first variable
  var variable = _php_parseVariableName(_p);

  // Parse all following variable access identifiers
  var state = STATE_DEFAULT;
  while (_p.pos < _p.expr.length) {
    var c = _p.expr.charAt(_p.pos++);
    switch (state) {
      case STATE_DEFAULT:
        switch (c) {
          case "[":
            // Parse the expression inside the rect brace
            variable.accessExpressions.push(_php_parseExpression(_p));
            state = STATE_EXPECT_RECT_BRACE_CLOSE;
            break;
          default:
            _p.pos--;
            return variable;
        }
        break;
      case STATE_EXPECT_RECT_BRACE_CLOSE:
        if (c != "]") {
          _throwParserErr(_p, " expected ']', but got " + c);
        }
        state = STATE_DEFAULT;
        break;
    }
  }
  return variable;
}

/**
 * Reads a string delimited by the char _delim or the regExp _delim from the
 * current parser context and returns it.
 *
 * @param {object} _p parser contect
 * @param {string} _delim delimiter
 * @return {string} string read (or throws an exception)
 */
function _php_readString(_p, _delim) {
  var state = STATE_DEFAULT;
  var str = "";
  while (_p.pos < _p.expr.length) {
    var c = _p.expr.charAt(_p.pos++);
    switch (state) {
      case STATE_DEFAULT:
        if (c == "\\") {
          state = STATE_ESCAPED;
        } else if (c === _delim || typeof _delim != "string" && _delim.test(c)) {
          return str;
        } else {
          str += c;
        }
        break;
      case STATE_ESCAPED:
        str += c;
        state = STATE_DEFAULT;
        break;
    }
  }
  _throwParserErr(_p, "unexpected end of string while parsing string!");
}
function _php_parseExpression(_p) {
  var state = STATE_EXPR_BEGIN;
  var result = null;
  while (_p.pos < _p.expr.length) {
    var c = _p.expr.charAt(_p.pos++);
    switch (state) {
      case STATE_EXPR_BEGIN:
        switch (c) {
          // Skip whitespace
          case " ":
          case "\n":
          case "\r":
          case "\t":
            break;
          case "\"":
            result = [];
            var p = _php_parser(_php_readString(_p, "\""));
            _php_parseDoubleQuoteString(p, result);
            state = STATE_EXPR_END;
            break;
          case "\'":
            result = _php_readString(_p, "'");
            state = STATE_EXPR_END;
            break;
          case "$":
            result = _php_parseVariable(_p);
            state = STATE_EXPR_END;
            break;
          default:
            _p.pos--;
            result = _php_readString(_p, /[^A-Za-z0-9_#]/);
            if (!result) {
              _throwParserErr(_p, "unexpected char " + c);
            }
            _p.pos--;
            state = STATE_EXPR_END;
            break;
        }
        break;
      case STATE_EXPR_END:
        switch (c) {
          // Skip whitespace
          case " ":
          case "\n":
          case "\r":
          case "\t":
            break;
          default:
            _p.pos--;
            return result;
        }
    }
  }
  _throwParserErr(_p, "unexpected end of string while parsing access expressions!");
}
function _php_parser(_expr) {
  return {
    expr: _expr,
    pos: 0
  };
}
function _throwCompilerErr(_err) {
  throw "PHP to JS compiler error, " + _err;
}
function _php_compileVariable(_vars, _variable) {
  if (_vars.indexOf(_variable.variable) >= 0) {
    // Attach a "_" to the variable name as PHP variable names may start
    // with numeric values
    var result = "_" + _variable.variable;

    // Create the access functions
    for (var i = 0; i < _variable.accessExpressions.length; i++) {
      result += "[" + _php_compileString(_vars, _variable.accessExpressions[i]) + "]";
    }
    return '(typeof _' + _variable.variable + ' != "undefined" && typeof ' + result + '!="undefined" && ' + result + ' != null ? ' + result + ':"")';
  }
  _throwCompilerErr("Variable $" + _variable.variable + " is not defined.");
}
function _php_compileString(_vars, _string) {
  if (!(_string instanceof Array)) {
    _string = [_string];
  }
  var parts = [];
  var hasString = false;
  for (var i = 0; i < _string.length; i++) {
    var part = _string[i];
    if (typeof part == "string") {
      hasString = true;
      // Escape all "'" and "\" chars and add the string to the parts array
      parts.push("'" + part.replace(/\\/g, "\\\\").replace(/'/g, "\\'") + "'");
    } else {
      parts.push(_php_compileVariable(_vars, part));
    }
  }
  if (!hasString)
    // Force the result to be of the type string
    {
      parts.push('""');
    }
  return parts.join(" + ");
}
function _php_compileJSCode(_vars, _tree) {
  // Each tree starts with a "string"
  return "return " + _php_compileString(_vars, _tree) + ";";
}

// Include this code in in order to test the above code
/*(function () {
	var row = 10;
	var row_cont = {"title": "Hello World!"};
	var cont = {10: row_cont};

	function test(_php, _res)
	{
		console.log(
			et2_compilePHPExpression(_php, ["row", "row_cont", "cont"])
				(row, row_cont, cont) === _res);
	}

	test("${row}[title]", "10[title]");
	test("{$row_cont[title]}", "Hello World!");
	test('{$cont["$row"][\'title\']}', "Hello World!");
	test("$row_cont[${row}[title]]");
	test("\\\\", "\\");
	test("", "");
})();*/

function _defineProperty$2v(e, r, t) { return (r = _toPropertyKey$2u(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2u(t) { var i = _toPrimitive$2u(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2u(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * Manage access to various template customisation arrays passed to etemplate->exec().
 *
 * This manages access to content, modifications and readonlys arrays
 */
class et2_arrayMgr {
  /**
   * Constructor
   *
   * @memberOf et2_arrayMgr
   * @param _data
   * @param _parentMgr
   */
  constructor() {
    var _data = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var _parentMgr = arguments.length > 1 ? arguments[1] : undefined;
    _defineProperty$2v(this, "splitIds", true);
    _defineProperty$2v(this, "data", void 0);
    // Holds information about the current perspective
    _defineProperty$2v(this, "perspectiveData", {
      "owner": null,
      "key": null,
      "row": null
    });
    _defineProperty$2v(this, "_parentMgr", void 0);
    _defineProperty$2v(this, "readOnly", false);
    if (typeof _parentMgr == "undefined") {
      _parentMgr = null;
    }

    // Copy the parent manager which is needed to access relative data when
    // being in a relative perspective of the manager
    this._parentMgr = _parentMgr;

    // Hold a reference to the data
    if (typeof _data == "undefined" || !_data) {
      egw$1.debug("log", "No data passed to content array manager.  Probably a mismatch between template namespaces and data.");
      _data = {};
    }

    // Expand sub-arrays that have been shmushed together, so further perspectives work
    // Shmushed keys look like: ${row}[info_cat]
    // Expanded: ${row}: Object{info_cat: ..value}
    if (this.splitIds) {
      // For each index, we need a key: {..} sub array
      for (var key in _data) {
        // Split up indexes
        var indexes = key.replace(/&#x5B;/g, "[").split('[');

        // Put data in the proper place
        if (indexes.length > 1) {
          var value = _data[key];
          var target = _data;
          for (var i = 0; i < indexes.length; i++) {
            indexes[i] = indexes[i].replace(/&#x5D;/g, '').replace(']', '');
            if (typeof target[indexes[i]] == "undefined" || target[indexes[i]] === null) {
              target[indexes[i]] = i == indexes.length - 1 ? value : {};
            }
            target = target[indexes[i]];
          }
          delete _data[key];
        }
      }
    }
    this.data = _data;
  }

  /**
   * Returns the root content array manager object
   */
  getRoot() {
    if (this._parentMgr != null) {
      return this._parentMgr.getRoot();
    }
    return this;
  }
  getParentMgr() {
    return this._parentMgr;
  }
  getPerspectiveData() {
    return this.perspectiveData;
  }
  setPerspectiveData(new_perspective) {
    this.perspectiveData = new_perspective;
  }
  setRow(new_row) {
    this.perspectiveData.row = new_row;
  }

  /**
   * Explodes compound keys (eg IDs) into a list of namespaces
   * This uses no internal values, just expands
   *
   * eg:
   * a[b][c] => [a,b,c]
   * col_filter[tr_tracker] => [col_filter, tr_tracker]
   *
   * @param {string} _key
   *
   * @return {string[]}
   */
  explodeKey(_key) {
    if (!_key || typeof _key == 'string' && _key.trim() === "") {
      return [];
    }

    // Parse the given key by removing the "]"-chars and splitting at "["
    var indexes = [_key];
    if (typeof _key === "string") {
      _key = _key.replace(/&#x5B;/g, "[").replace(/&#x5D;/g, "]");
      indexes = _key.split('[');
    }
    if (indexes.length > 1) {
      indexes = [indexes.shift(), indexes.join('[')];
      indexes[1] = indexes[1].substring(0, indexes[1].length - 1);
      var children = indexes[1].split('][');
      if (children.length) {
        indexes = jQuery.merge([indexes[0]], children);
      }
    }
    return indexes;
  }

  /**
   * Returns the path to this content array manager perspective as an array
   * containing the key values
   *
   * @param _path is used internally, do not supply it manually.
   */
  getPath(_path) {
    if (typeof _path == "undefined") {
      _path = [];
    }
    if (this.perspectiveData.key != null) {
      // prepend components of this.perspectiveData.key to path, can be more then one eg. "nm[rows]"
      _path = this.perspectiveData.key.replace(/]/g, '').split('[').concat(_path);
    }
    if (this._parentMgr != null) {
      _path = this._parentMgr.getPath(_path);
    }
    return _path;
  }

  /**
   * Get array entry is the equivalent to the boetemplate get_array function.
   * It returns a reference to the (sub) array with the given key. This also works
   * for keys using the ETemplate referencing scheme like a[b][c]
   *
   * @param _key is the string index, may contain sub-indices like a[b]
   * @param _referenceInto if true none-existing sub-arrays/-indices get created
   *    to be returned as reference, else false is returned. Defaults to false
   * @param _skipEmpty returns null if _key is not present in this content array.
   *    Defaults to false.
   */
  getEntry(_key, _referenceInto, _skipEmpty) {
    if (typeof _referenceInto == "undefined") {
      _referenceInto = false;
    }
    if (typeof _skipEmpty == "undefined") {
      _skipEmpty = false;
    }

    // Parse the given key by removing the "]"-chars and splitting at "["
    var indexes = this.explodeKey(_key);
    if (indexes.length == 0 && _skipEmpty) {
      return null;
    }
    var entry = this.data;
    for (var i = 0; i < indexes.length; i++) {
      // Abort if the current entry is not an object (associative array) and
      // we should descend further into it.
      var isObject = typeof entry === 'object';
      if (!isObject && !_referenceInto || entry == null || jQuery.isEmptyObject(entry)) {
        return null;
      }

      // Check whether the entry actually exists
      var idx = indexes[i];
      if (_skipEmpty && (!isObject || typeof entry[idx] == "undefined")) {
        return null;
      }
      entry = entry[idx];
    }
    return entry;
  }

  /**
   * Equivalent to the boetemplate::expand_name function.
   *
   * Expands variables inside the given identifier to their values inside the
   * content array.
   *
   * @param {string} _ident Key used to reference into managed array
   * @return {*}
   */
  expandName(_ident) {
    // Check whether the identifier refers to an index in the content array
    var is_index_in_content = _ident.charAt(0) == '@';

    // Check whether "$" occurs in the given identifier
    var pos_var = _ident.indexOf('$');
    if (pos_var >= 0 && (this.perspectiveData.row != null || !_ident.match(/\$\{?row\}?/))
    // Avoid messing with regex in validators
    && pos_var !== _ident.indexOf("$/")) {
      // Get the content array for the current row
      var row = typeof this.perspectiveData.row == 'number' ? this.perspectiveData.row : '';
      var row_cont = this.data[row] || {};
      // $cont is NOT root but current name-space in old eTemplate
      var cont = this.data; //getRoot().data;
      var _cont = this.data; // according to a grep only used in ImportExport just twice

      // Check whether the expression has already been compiled - if not,
      // try to compile it first. If an error occurs, the identifier
      // function is set to null
      if (typeof et2_arrayMgr.compiledExpressions[_ident] == "undefined") {
        try {
          if (this.perspectiveData.row == null) {
            // No row, compile for only top level content
            // @ts-ignore
            et2_arrayMgr.compiledExpressions[_ident] = et2_compilePHPExpression(_ident, ["cont", "_cont"]);
          } else {
            // @ts-ignore
            et2_arrayMgr.compiledExpressions[_ident] = et2_compilePHPExpression(_ident, ["row", "cont", "row_cont", "_cont"]);
          }
        } catch (e) {
          et2_arrayMgr.compiledExpressions[_ident] = null;
          egw$1.debug("error", "Error while compiling PHP->JS ", e);
        }
      }

      // Execute the previously compiled expression, if it is not "null"
      // because compilation failed. The parameters have to be in the same
      // order as defined during compilation.
      if (et2_arrayMgr.compiledExpressions[_ident]) {
        try {
          if (this.perspectiveData.row == null) {
            // No row, exec with only top level content
            _ident = et2_arrayMgr.compiledExpressions[_ident](cont, _cont);
          } else {
            _ident = et2_arrayMgr.compiledExpressions[_ident](row, cont, row_cont, _cont);
          }
        } catch (e) {
          // only log error, as they are no real errors but missing data
          egw$1.debug("log", typeof e == 'object' ? e.message : e);
          _ident = null;
        }
      }
    }
    if (is_index_in_content && _ident) {
      // If an additional "@" is specified, this means that we have to return
      // the entry from the root element
      if (_ident.charAt(1) == '@') {
        return this.getRoot().getEntry(_ident.substr(2));
      } else {
        return this.getEntry(_ident.substr(1));
      }
    }
    return _ident;
  }
  parseBoolExpression(_expression) {
    if (typeof _expression === "boolean") {
      return _expression;
    }
    if (typeof _expression === "undefined" || _expression === null) {
      return false;
    }
    if (typeof _expression === "number") {
      return !!_expression;
    }

    // Check whether "$" occurs in the given identifier, don't parse rows if we're not in a row
    // This saves booleans in repeating rows from being parsed too early - we'll parse again when repeating
    if (_expression.indexOf('$') >= 0 && this.perspectiveData.row == null && _expression.match(/\$\{?row\}?/)) {
      return _expression;
    }

    // If the first char of the expression is a '!' this means, that the value
    // is to be negated.
    if (_expression.charAt(0) == '!') {
      return !this.parseBoolExpression(_expression.substr(1));
    }

    // Split the expression at a possible "="
    var parts = _expression.split('=');

    // Expand the first value
    var val = this.expandName(parts[0]);
    val = typeof val == "undefined" || val === null ? '' : '' + val;

    // If a second expression existed, test that one
    if (typeof parts[1] != "undefined") {
      // Expand the second value
      var checkVal = '' + this.expandName(parts[1]);

      // Values starting with / are treated as regular expression. It is
      // checked whether the first value matches the regular expression
      if (checkVal.charAt(0) == '/') {
        return new RegExp(checkVal.substr(1, checkVal.length - 2)).test(val);
      }

      // Otherwise check for simple equality
      return val == checkVal;
    }
    return et2_evalBool(val);
  }

  /**
   * ?
   *
   * @param {object} _owner owner object
   * @param {(string|null|object)} _root string with key, null for whole data or object with data
   * @param {number?} _row key for into the _root for the desired row
   */
  openPerspective(_owner, _root, _row) {
    // Get the root node
    var root = typeof _root == "string" ? this.data[_root] : _root == null ? this.data : _root;
    if (typeof root == "undefined" && typeof _root == "string") {
      root = this.getEntry(_root);
    }

    // Create a new content array manager with the given root
    var constructor = this.readOnly ? et2_readonlysArrayMgr : et2_arrayMgr;
    var mgr = new constructor(root, this);

    // Set the owner
    mgr.perspectiveData.owner = _owner;

    // Set the root key
    if (typeof _root == "string") {
      mgr.perspectiveData.key = _root;
    }

    // Set _row parameter
    if (typeof _row != "undefined") {
      mgr.perspectiveData.row = _row;
    }
    return mgr;
  }
}

/**
 * @augments et2_arrayMgr
 */
_defineProperty$2v(et2_arrayMgr, "compiledExpressions", {});
class et2_readonlysArrayMgr extends et2_arrayMgr {
  constructor() {
    super(...arguments);
    _defineProperty$2v(this, "readOnly", true);
  }
  /**
   * Find out if the given ID is readonly, according to the array data
   *
   * @memberOf et2_readonlysArrayMgr
   * @param _id
   * @param _attr
   * @param _parent
   * @returns
   */
  isReadOnly(_id, _attr, _parent) {
    var entry = null;
    if (_id != null) {
      if (_id.indexOf('$') >= 0 || _id.indexOf('@') >= 0) {
        _id = this.expandName(_id);
      }
      // readonlys was not namespaced in old eTemplate, therefore if we dont find data
      // under current namespace, we look into parent
      // (if there is anything namespaced, we will NOT look for parent!)
      var mgr = this;
      while (mgr.getParentMgr() && jQuery.isEmptyObject(mgr.data)) {
        mgr = mgr.getParentMgr();
      }
      entry = mgr.getEntry(_id);
    }

    // Let the array entry override the read only attribute entry
    if (typeof entry != "undefined" && !(typeof entry === 'object')) {
      return entry;
    }

    // If the attribute is set, return that
    if (typeof _attr != "undefined" && _attr !== null) {
      // Accept 'editable', but otherwise boolean
      return typeof _attr === 'string' && this.expandName(_attr) === 'editable' ? 'editable' : et2_evalBool(_attr);
    }

    // Otherwise take into accounf whether the parent is readonly
    if (typeof _parent != "undefined" && _parent) {
      return true;
    }

    // Otherwise return the default value
    entry = this.getEntry("__ALL__");
    return entry !== null && typeof entry != "undefined";
  }

  /**
   * Override parent to handle cont and row_cont.
   *
   * Normally these should refer to the readonlys data, but that's not
   * useful, so we use the owner inside perspective data to expand using content.
   *
   * @param {string} ident Key for searching into the array.
   * @returns {*}
   */
  expandName(ident) {
    return this.perspectiveData.owner.getArrayMgr('content').expandName(ident);
  }
}

/**
 * Creates a new set of array managers
 *
 * @param _owner is the owner object of the array managers - this object (a widget)
 *    will free the array manager
 * @param _mgrs is the original set of array managers, the array managers are
 *    inside an associative array as recived from et2_widget::getArrayMgrs()
 * @param _data is an associative array of new data which will be merged into the
 *    existing array managers.
 * @param _row is the row for which the array managers will be opened.
 */
function et2_arrayMgrs_expand(_owner, _mgrs, _data, _row) {
  // Create a copy of the given _mgrs associative array
  var result = {};

  // Merge the given data associative array into the existing array managers
  for (var key in _mgrs) {
    result[key] = _mgrs[key];
    if (typeof _data[key] != "undefined") {
      // Open a perspective for the given data row
      var rowData = {};
      rowData[_row] = _data[key];
      result[key] = _mgrs[key].openPerspective(_owner, rowData, _row);
    }
  }

  // Return the resulting managers object
  return result;
}

function et2_compileLegacyJS(_code, _widget, _context) {
  // Replace the javascript pseudo-functions
  _code = js_pseudo_funcs(_code, _widget);

  // Check whether _code is simply "1" -- if yes replace it accordingly
  if (_code === '1') {
    _code = 'widget.getInstanceManager().submit(); return false;';
  }

  // Check whether some pseudo-variables still reside inside of the code,
  // if yes, replace them.
  if (_code.indexOf("$") >= 0 || _code.indexOf("@") >= 0) {
    // Get the content array manager for the widget
    var mgr = _widget.getArrayMgr("content");
    if (mgr) {
      _code = mgr.expandName(_code);
    }
    // If replacement cleared the code, skip the rest
    if (!_code) {
      return false;
    }
  }

  // Context is the context in which the function will run. Set context to
  // null as a default, so that it's possible to find bugs where "this" is
  // accessed in the code, but not properly set.
  var context = _context ? _context : null;

  // Check whether the given widget implements the "et2_IDOMNode"
  // interface
  if (!context && _widget.implements(et2_IDOMNode)) {
    context = _widget.getDOMNode();
  }

  // Check to see if it's referring to an existing function with no arguments specified.
  // If so, bind context & use it directly
  if (_code.indexOf("(") === -1) {
    var parts = _code.split(".");
    var existing_func = parts.pop();
    var parent = _widget.egw().window;
    for (var i = 0; i < parts.length; ++i) {
      if (typeof parent[parts[i]] !== "undefined") {
        parent = parent[parts[i]];
      }
      // Nope
      else {
        break;
      }
    }
    if (typeof parent[existing_func] === "function") {
      // Bind the object so no matter what happens, context is correct
      return parent[existing_func].bind(parent);
    }
  }

  // Generate the function itself, if it fails, log the error message and
  // return a function which always returns false
  try {
    // Code is app.appname.function, add the arguments so it can be executed
    if (typeof _code == 'string' && _code.indexOf('app') == 0 && _code.split('.').length >= 3 && _code.indexOf('(') == -1) {
      var _parts = _code.split('.');
      var app = _widget.getInstanceManager().app_obj;
      // check if we need to load the object
      if (_parts.length === 3 && typeof app[_parts[1]] === 'undefined') {
        return function (ev, widget) {
          return egw$1.applyFunc(_code, [ev, widget]);
        };
      }
      // Code is app.appname.function, add the arguments so it can be executed
      _code += '(ev,widget)';
      // Return what the function returns
      if (_code.indexOf("return") == -1) {
        _code = "return " + _code;
      }
    }
    // use app object from etemplate2, which might be private and not just window.app
    _code = _code.replace(/(window\.)?app\./, 'widget.getInstanceManager().app_obj.');
    var func = new Function('ev', 'widget', _code);
  } catch (e) {
    _widget.egw().debug('error', 'Error while compiling JS code ', _code);
    return function () {
      return false;
    };
  }

  // Execute the code and return its results, pass the egw instance and
  // the widget
  return function (ev, widget) {
    // Dump the executed code for debugging
    egw$1.debug('log', 'Executing legacy JS code: ', _code);
    if (arguments && arguments.length > 2) {
      egw$1.debug('warn', 'Legacy JS code only supports 2 arguments (event and widget)', _code, arguments);
    }
    // Return the result of the called function
    return func.call(context, ev, widget || _widget);
  };
}

/**
 * Resolve javascript pseudo functions in onclick or onchange:
 * - egw::link('$l','$p') calls egw.link($l,$p)
 * - form::name('name') returns expanded name/id taking into account the name at that point of the template hierarchy
 * - egw::lang('Message ...') translate the message, calls egw.lang()
 * - confirm('message') translates 'message' and adds a '?' if not present
 * - window.open() replaces it with egw_openWindowCentered2()
 * - xajax_doXMLHTTP('etemplate. replace ajax calls in widgets with special handler not requiring etemplate run rights
 *
 * @param {string} _val onclick, onchange, ... action
 * @param {et2_widget} widget
 * @ToDo replace xajax_doXMLHTTP with egw.json()
 * @ToDo replace (common) cases of confirm with new dialog, idea: calling function supplys function to call after confirm
 * @ToDo template::styles(name) inserts the styles of a named template
 * @return string
 */
function js_pseudo_funcs(_val, widget) {
  if (_val.indexOf('egw::link(') != -1) {
    _val = _val.replace(/egw::link\(/g, 'egw.link(');
  }
  if (_val.indexOf('form::name(') != -1) {
    // et2_form_name doesn't care about ][, just [
    var _cname = widget.getPath() ? widget.getPath().join("[") : false;
    document.et2_form_name = et2_form_name;
    _val = _val.replace(/form::name\(/g, "'" + widget.getRoot()._inst.uniqueId + "_'+" + (_cname ? "document.et2_form_name('" + _cname + "'," : '('));
  }
  if (_val.indexOf('egw::lang(') != -1) {
    _val = _val.replace(/egw::lang\(/g, 'egw.lang(');
  }

  // ToDo: inserts the styles of a named template
  /*if (preg_match('/template::styles\(["\']{1}(.*)["\']{1}\)/U',$on,$matches))
  {
  	$tpl = $matches[1] == $this->name ? $this : new etemplate($matches[1]);
  	$on = str_replace($matches[0],"'<style>".str_replace(array("\n","\r"),'',$tpl->style)."</style>'",$on);
  }*/

  // translate messages in confirm()
  if (_val.indexOf('confirm(') != -1) {
    _val = _val.replace(/confirm\((['"])(.*?)(\?)?['"]\)/, "confirm(egw.lang($1$2$1)+'$3')"); // add ? if not there, saves extra phrase
  }

  // replace window.open() with EGw's egw_openWindowCentered2()
  if (_val.indexOf('window.open(') != -1) {
    _val = _val.replace(/window.open\('(.*)','(.*)','dependent=yes,width=([^,]*),height=([^,]*),scrollbars=yes,status=(.*)'\)/, "egw_openWindowCentered2('$1', '$2', $3, $4, '$5')");
  }

  // replace xajax calls to code in widgets, with the "etemplate" handler,
  // this allows to call widgets with the current app, otherwise everyone would need etemplate run rights
  if (_val.indexOf("xajax_doXMLHTTP('etemplate.") != -1) {
    _val = _val.replace(/^xajax_doXMLHTTP\('etemplate\.([a-z]+_widget\.[a-zA-Z0-9_]+)\'/, "xajax_doXMLHTTP('" + egw$1.getAppName() + ".$1.etemplate'");
  }
  if (_val.indexOf('this.form.submit()') != -1) {
    _val = _val.replace('this.form.submit()', 'widget.getInstanceManager().submit()');
  }
  return _val;
}

/**
 * @license
 * Copyright 2019 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const t$e=window,e$s=t$e.ShadowRoot&&(void 0===t$e.ShadyCSS||t$e.ShadyCSS.nativeShadow)&&"adoptedStyleSheets"in Document.prototype&&"replace"in CSSStyleSheet.prototype,s$e=Symbol(),n$n=new WeakMap;class o$u{constructor(t,e,n){if(this._$cssResult$=!0,n!==s$e)throw Error("CSSResult is not constructable. Use `unsafeCSS` or `css` instead.");this.cssText=t,this.t=e;}get styleSheet(){let t=this.o;const s=this.t;if(e$s&&void 0===t){const e=void 0!==s&&1===s.length;e&&(t=n$n.get(s)),void 0===t&&((this.o=t=new CSSStyleSheet).replaceSync(this.cssText),e&&n$n.set(s,t));}return t}toString(){return this.cssText}}const r$h=t=>new o$u("string"==typeof t?t:t+"",void 0,s$e),i$h=(t,...e)=>{const n=1===t.length?t[0]:e.reduce(((e,s,n)=>e+(t=>{if(!0===t._$cssResult$)return t.cssText;if("number"==typeof t)return t;throw Error("Value passed to 'css' function must be a 'css' function result: "+t+". Use 'unsafeCSS' to pass non-literal values, but take care to ensure page security.")})(s)+t[n+1]),t[0]);return new o$u(n,t,s$e)},S$4=(s,n)=>{e$s?s.adoptedStyleSheets=n.map((t=>t instanceof CSSStyleSheet?t:t.styleSheet)):n.forEach((e=>{const n=document.createElement("style"),o=t$e.litNonce;void 0!==o&&n.setAttribute("nonce",o),n.textContent=e.cssText,s.appendChild(n);}));},c$b=e$s?t=>t:t=>t instanceof CSSStyleSheet?(t=>{let e="";for(const s of t.cssRules)e+=s.cssText;return r$h(e)})(t):t;

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */var s$d;const e$r=window,r$g=e$r.trustedTypes,h$c=r$g?r$g.emptyScript:"",o$t=e$r.reactiveElementPolyfillSupport,n$m={toAttribute(t,i){switch(i){case Boolean:t=t?h$c:null;break;case Object:case Array:t=null==t?t:JSON.stringify(t);}return t},fromAttribute(t,i){let s=t;switch(i){case Boolean:s=null!==t;break;case Number:s=null===t?null:Number(t);break;case Object:case Array:try{s=JSON.parse(t);}catch(t){s=null;}}return s}},a$7=(t,i)=>i!==t&&(i==i||t==t),l$e={attribute:!0,type:String,converter:n$m,reflect:!1,hasChanged:a$7};class d$6 extends HTMLElement{constructor(){super(),this._$Ei=new Map,this.isUpdatePending=!1,this.hasUpdated=!1,this._$El=null,this.u();}static addInitializer(t){var i;this.finalize(),(null!==(i=this.h)&&void 0!==i?i:this.h=[]).push(t);}static get observedAttributes(){this.finalize();const t=[];return this.elementProperties.forEach(((i,s)=>{const e=this._$Ep(s,i);void 0!==e&&(this._$Ev.set(e,s),t.push(e));})),t}static createProperty(t,i=l$e){if(i.state&&(i.attribute=!1),this.finalize(),this.elementProperties.set(t,i),!i.noAccessor&&!this.prototype.hasOwnProperty(t)){const s="symbol"==typeof t?Symbol():"__"+t,e=this.getPropertyDescriptor(t,s,i);void 0!==e&&Object.defineProperty(this.prototype,t,e);}}static getPropertyDescriptor(t,i,s){return {get(){return this[i]},set(e){const r=this[t];this[i]=e,this.requestUpdate(t,r,s);},configurable:!0,enumerable:!0}}static getPropertyOptions(t){return this.elementProperties.get(t)||l$e}static finalize(){if(this.hasOwnProperty("finalized"))return !1;this.finalized=!0;const t=Object.getPrototypeOf(this);if(t.finalize(),void 0!==t.h&&(this.h=[...t.h]),this.elementProperties=new Map(t.elementProperties),this._$Ev=new Map,this.hasOwnProperty("properties")){const t=this.properties,i=[...Object.getOwnPropertyNames(t),...Object.getOwnPropertySymbols(t)];for(const s of i)this.createProperty(s,t[s]);}return this.elementStyles=this.finalizeStyles(this.styles),!0}static finalizeStyles(i){const s=[];if(Array.isArray(i)){const e=new Set(i.flat(1/0).reverse());for(const i of e)s.unshift(c$b(i));}else void 0!==i&&s.push(c$b(i));return s}static _$Ep(t,i){const s=i.attribute;return !1===s?void 0:"string"==typeof s?s:"string"==typeof t?t.toLowerCase():void 0}u(){var t;this._$E_=new Promise((t=>this.enableUpdating=t)),this._$AL=new Map,this._$Eg(),this.requestUpdate(),null===(t=this.constructor.h)||void 0===t||t.forEach((t=>t(this)));}addController(t){var i,s;(null!==(i=this._$ES)&&void 0!==i?i:this._$ES=[]).push(t),void 0!==this.renderRoot&&this.isConnected&&(null===(s=t.hostConnected)||void 0===s||s.call(t));}removeController(t){var i;null===(i=this._$ES)||void 0===i||i.splice(this._$ES.indexOf(t)>>>0,1);}_$Eg(){this.constructor.elementProperties.forEach(((t,i)=>{this.hasOwnProperty(i)&&(this._$Ei.set(i,this[i]),delete this[i]);}));}createRenderRoot(){var t;const s=null!==(t=this.shadowRoot)&&void 0!==t?t:this.attachShadow(this.constructor.shadowRootOptions);return S$4(s,this.constructor.elementStyles),s}connectedCallback(){var t;void 0===this.renderRoot&&(this.renderRoot=this.createRenderRoot()),this.enableUpdating(!0),null===(t=this._$ES)||void 0===t||t.forEach((t=>{var i;return null===(i=t.hostConnected)||void 0===i?void 0:i.call(t)}));}enableUpdating(t){}disconnectedCallback(){var t;null===(t=this._$ES)||void 0===t||t.forEach((t=>{var i;return null===(i=t.hostDisconnected)||void 0===i?void 0:i.call(t)}));}attributeChangedCallback(t,i,s){this._$AK(t,s);}_$EO(t,i,s=l$e){var e;const r=this.constructor._$Ep(t,s);if(void 0!==r&&!0===s.reflect){const h=(void 0!==(null===(e=s.converter)||void 0===e?void 0:e.toAttribute)?s.converter:n$m).toAttribute(i,s.type);this._$El=t,null==h?this.removeAttribute(r):this.setAttribute(r,h),this._$El=null;}}_$AK(t,i){var s;const e=this.constructor,r=e._$Ev.get(t);if(void 0!==r&&this._$El!==r){const t=e.getPropertyOptions(r),h="function"==typeof t.converter?{fromAttribute:t.converter}:void 0!==(null===(s=t.converter)||void 0===s?void 0:s.fromAttribute)?t.converter:n$m;this._$El=r,this[r]=h.fromAttribute(i,t.type),this._$El=null;}}requestUpdate(t,i,s){let e=!0;void 0!==t&&(((s=s||this.constructor.getPropertyOptions(t)).hasChanged||a$7)(this[t],i)?(this._$AL.has(t)||this._$AL.set(t,i),!0===s.reflect&&this._$El!==t&&(void 0===this._$EC&&(this._$EC=new Map),this._$EC.set(t,s))):e=!1),!this.isUpdatePending&&e&&(this._$E_=this._$Ej());}async _$Ej(){this.isUpdatePending=!0;try{await this._$E_;}catch(t){Promise.reject(t);}const t=this.scheduleUpdate();return null!=t&&await t,!this.isUpdatePending}scheduleUpdate(){return this.performUpdate()}performUpdate(){var t;if(!this.isUpdatePending)return;this.hasUpdated,this._$Ei&&(this._$Ei.forEach(((t,i)=>this[i]=t)),this._$Ei=void 0);let i=!1;const s=this._$AL;try{i=this.shouldUpdate(s),i?(this.willUpdate(s),null===(t=this._$ES)||void 0===t||t.forEach((t=>{var i;return null===(i=t.hostUpdate)||void 0===i?void 0:i.call(t)})),this.update(s)):this._$Ek();}catch(t){throw i=!1,this._$Ek(),t}i&&this._$AE(s);}willUpdate(t){}_$AE(t){var i;null===(i=this._$ES)||void 0===i||i.forEach((t=>{var i;return null===(i=t.hostUpdated)||void 0===i?void 0:i.call(t)})),this.hasUpdated||(this.hasUpdated=!0,this.firstUpdated(t)),this.updated(t);}_$Ek(){this._$AL=new Map,this.isUpdatePending=!1;}get updateComplete(){return this.getUpdateComplete()}getUpdateComplete(){return this._$E_}shouldUpdate(t){return !0}update(t){void 0!==this._$EC&&(this._$EC.forEach(((t,i)=>this._$EO(i,this[i],t))),this._$EC=void 0),this._$Ek();}updated(t){}firstUpdated(t){}}d$6.finalized=!0,d$6.elementProperties=new Map,d$6.elementStyles=[],d$6.shadowRootOptions={mode:"open"},null==o$t||o$t({ReactiveElement:d$6}),(null!==(s$d=e$r.reactiveElementVersions)&&void 0!==s$d?s$d:e$r.reactiveElementVersions=[]).push("1.6.1");

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
var t$d;const i$g=window,s$c=i$g.trustedTypes,e$q=s$c?s$c.createPolicy("lit-html",{createHTML:t=>t}):void 0,o$s="$lit$",n$l=`lit$${(Math.random()+"").slice(9)}$`,l$d="?"+n$l,h$b=`<${l$d}>`,r$f=document,u$8=()=>r$f.createComment(""),d$5=t=>null===t||"object"!=typeof t&&"function"!=typeof t,c$a=Array.isArray,v$4=t=>c$a(t)||"function"==typeof(null==t?void 0:t[Symbol.iterator]),a$6="[ \t\n\f\r]",f$7=/<(?:(!--|\/[^a-zA-Z])|(\/?[a-zA-Z][^>\s]*)|(\/?$))/g,_$2=/-->/g,m$5=/>/g,p$5=RegExp(`>|${a$6}(?:([^\\s"'>=/]+)(${a$6}*=${a$6}*(?:[^ \t\n\f\r"'\`<>=]|("|')|))|$)`,"g"),g$2=/'/g,$$e=/"/g,y$3=/^(?:script|style|textarea|title)$/i,w$2=t=>(i,...s)=>({_$litType$:t,strings:i,values:s}),x$2=w$2(1),b$3=w$2(2),T$2=Symbol.for("lit-noChange"),A$2=Symbol.for("lit-nothing"),E$2=new WeakMap,C$2=r$f.createTreeWalker(r$f,129,null,!1);function P$2(t,i){if(!Array.isArray(t)||!t.hasOwnProperty("raw"))throw Error("invalid template strings array");return void 0!==e$q?e$q.createHTML(i):i}const V$2=(t,i)=>{const s=t.length-1,e=[];let l,r=2===i?"<svg>":"",u=f$7;for(let i=0;i<s;i++){const s=t[i];let d,c,v=-1,a=0;for(;a<s.length&&(u.lastIndex=a,c=u.exec(s),null!==c);)a=u.lastIndex,u===f$7?"!--"===c[1]?u=_$2:void 0!==c[1]?u=m$5:void 0!==c[2]?(y$3.test(c[2])&&(l=RegExp("</"+c[2],"g")),u=p$5):void 0!==c[3]&&(u=p$5):u===p$5?">"===c[0]?(u=null!=l?l:f$7,v=-1):void 0===c[1]?v=-2:(v=u.lastIndex-c[2].length,d=c[1],u=void 0===c[3]?p$5:'"'===c[3]?$$e:g$2):u===$$e||u===g$2?u=p$5:u===_$2||u===m$5?u=f$7:(u=p$5,l=void 0);const w=u===p$5&&t[i+1].startsWith("/>")?" ":"";r+=u===f$7?s+h$b:v>=0?(e.push(d),s.slice(0,v)+o$s+s.slice(v)+n$l+w):s+n$l+(-2===v?(e.push(void 0),i):w);}return [P$2(t,r+(t[s]||"<?>")+(2===i?"</svg>":"")),e]};class N$2{constructor({strings:t,_$litType$:i},e){let h;this.parts=[];let r=0,d=0;const c=t.length-1,v=this.parts,[a,f]=V$2(t,i);if(this.el=N$2.createElement(a,e),C$2.currentNode=this.el.content,2===i){const t=this.el.content,i=t.firstChild;i.remove(),t.append(...i.childNodes);}for(;null!==(h=C$2.nextNode())&&v.length<c;){if(1===h.nodeType){if(h.hasAttributes()){const t=[];for(const i of h.getAttributeNames())if(i.endsWith(o$s)||i.startsWith(n$l)){const s=f[d++];if(t.push(i),void 0!==s){const t=h.getAttribute(s.toLowerCase()+o$s).split(n$l),i=/([.?@])?(.*)/.exec(s);v.push({type:1,index:r,name:i[2],strings:t,ctor:"."===i[1]?H$3:"?"===i[1]?L$2:"@"===i[1]?z$2:k$2});}else v.push({type:6,index:r});}for(const i of t)h.removeAttribute(i);}if(y$3.test(h.tagName)){const t=h.textContent.split(n$l),i=t.length-1;if(i>0){h.textContent=s$c?s$c.emptyScript:"";for(let s=0;s<i;s++)h.append(t[s],u$8()),C$2.nextNode(),v.push({type:2,index:++r});h.append(t[i],u$8());}}}else if(8===h.nodeType)if(h.data===l$d)v.push({type:2,index:r});else {let t=-1;for(;-1!==(t=h.data.indexOf(n$l,t+1));)v.push({type:7,index:r}),t+=n$l.length-1;}r++;}}static createElement(t,i){const s=r$f.createElement("template");return s.innerHTML=t,s}}function S$3(t,i,s=t,e){var o,n,l,h;if(i===T$2)return i;let r=void 0!==e?null===(o=s._$Co)||void 0===o?void 0:o[e]:s._$Cl;const u=d$5(i)?void 0:i._$litDirective$;return (null==r?void 0:r.constructor)!==u&&(null===(n=null==r?void 0:r._$AO)||void 0===n||n.call(r,!1),void 0===u?r=void 0:(r=new u(t),r._$AT(t,s,e)),void 0!==e?(null!==(l=(h=s)._$Co)&&void 0!==l?l:h._$Co=[])[e]=r:s._$Cl=r),void 0!==r&&(i=S$3(t,r._$AS(t,i.values),r,e)),i}class M$2{constructor(t,i){this._$AV=[],this._$AN=void 0,this._$AD=t,this._$AM=i;}get parentNode(){return this._$AM.parentNode}get _$AU(){return this._$AM._$AU}u(t){var i;const{el:{content:s},parts:e}=this._$AD,o=(null!==(i=null==t?void 0:t.creationScope)&&void 0!==i?i:r$f).importNode(s,!0);C$2.currentNode=o;let n=C$2.nextNode(),l=0,h=0,u=e[0];for(;void 0!==u;){if(l===u.index){let i;2===u.type?i=new R$2(n,n.nextSibling,this,t):1===u.type?i=new u.ctor(n,u.name,u.strings,this,t):6===u.type&&(i=new Z$2(n,this,t)),this._$AV.push(i),u=e[++h];}l!==(null==u?void 0:u.index)&&(n=C$2.nextNode(),l++);}return C$2.currentNode=r$f,o}v(t){let i=0;for(const s of this._$AV)void 0!==s&&(void 0!==s.strings?(s._$AI(t,s,i),i+=s.strings.length-2):s._$AI(t[i])),i++;}}class R$2{constructor(t,i,s,e){var o;this.type=2,this._$AH=A$2,this._$AN=void 0,this._$AA=t,this._$AB=i,this._$AM=s,this.options=e,this._$Cp=null===(o=null==e?void 0:e.isConnected)||void 0===o||o;}get _$AU(){var t,i;return null!==(i=null===(t=this._$AM)||void 0===t?void 0:t._$AU)&&void 0!==i?i:this._$Cp}get parentNode(){let t=this._$AA.parentNode;const i=this._$AM;return void 0!==i&&11===(null==t?void 0:t.nodeType)&&(t=i.parentNode),t}get startNode(){return this._$AA}get endNode(){return this._$AB}_$AI(t,i=this){t=S$3(this,t,i),d$5(t)?t===A$2||null==t||""===t?(this._$AH!==A$2&&this._$AR(),this._$AH=A$2):t!==this._$AH&&t!==T$2&&this._(t):void 0!==t._$litType$?this.g(t):void 0!==t.nodeType?this.$(t):v$4(t)?this.T(t):this._(t);}k(t){return this._$AA.parentNode.insertBefore(t,this._$AB)}$(t){this._$AH!==t&&(this._$AR(),this._$AH=this.k(t));}_(t){this._$AH!==A$2&&d$5(this._$AH)?this._$AA.nextSibling.data=t:this.$(r$f.createTextNode(t)),this._$AH=t;}g(t){var i;const{values:s,_$litType$:e}=t,o="number"==typeof e?this._$AC(t):(void 0===e.el&&(e.el=N$2.createElement(P$2(e.h,e.h[0]),this.options)),e);if((null===(i=this._$AH)||void 0===i?void 0:i._$AD)===o)this._$AH.v(s);else {const t=new M$2(o,this),i=t.u(this.options);t.v(s),this.$(i),this._$AH=t;}}_$AC(t){let i=E$2.get(t.strings);return void 0===i&&E$2.set(t.strings,i=new N$2(t)),i}T(t){c$a(this._$AH)||(this._$AH=[],this._$AR());const i=this._$AH;let s,e=0;for(const o of t)e===i.length?i.push(s=new R$2(this.k(u$8()),this.k(u$8()),this,this.options)):s=i[e],s._$AI(o),e++;e<i.length&&(this._$AR(s&&s._$AB.nextSibling,e),i.length=e);}_$AR(t=this._$AA.nextSibling,i){var s;for(null===(s=this._$AP)||void 0===s||s.call(this,!1,!0,i);t&&t!==this._$AB;){const i=t.nextSibling;t.remove(),t=i;}}setConnected(t){var i;void 0===this._$AM&&(this._$Cp=t,null===(i=this._$AP)||void 0===i||i.call(this,t));}}class k$2{constructor(t,i,s,e,o){this.type=1,this._$AH=A$2,this._$AN=void 0,this.element=t,this.name=i,this._$AM=e,this.options=o,s.length>2||""!==s[0]||""!==s[1]?(this._$AH=Array(s.length-1).fill(new String),this.strings=s):this._$AH=A$2;}get tagName(){return this.element.tagName}get _$AU(){return this._$AM._$AU}_$AI(t,i=this,s,e){const o=this.strings;let n=!1;if(void 0===o)t=S$3(this,t,i,0),n=!d$5(t)||t!==this._$AH&&t!==T$2,n&&(this._$AH=t);else {const e=t;let l,h;for(t=o[0],l=0;l<o.length-1;l++)h=S$3(this,e[s+l],i,l),h===T$2&&(h=this._$AH[l]),n||(n=!d$5(h)||h!==this._$AH[l]),h===A$2?t=A$2:t!==A$2&&(t+=(null!=h?h:"")+o[l+1]),this._$AH[l]=h;}n&&!e&&this.j(t);}j(t){t===A$2?this.element.removeAttribute(this.name):this.element.setAttribute(this.name,null!=t?t:"");}}class H$3 extends k$2{constructor(){super(...arguments),this.type=3;}j(t){this.element[this.name]=t===A$2?void 0:t;}}const I$2=s$c?s$c.emptyScript:"";class L$2 extends k$2{constructor(){super(...arguments),this.type=4;}j(t){t&&t!==A$2?this.element.setAttribute(this.name,I$2):this.element.removeAttribute(this.name);}}class z$2 extends k$2{constructor(t,i,s,e,o){super(t,i,s,e,o),this.type=5;}_$AI(t,i=this){var s;if((t=null!==(s=S$3(this,t,i,0))&&void 0!==s?s:A$2)===T$2)return;const e=this._$AH,o=t===A$2&&e!==A$2||t.capture!==e.capture||t.once!==e.once||t.passive!==e.passive,n=t!==A$2&&(e===A$2||o);o&&this.element.removeEventListener(this.name,this,e),n&&this.element.addEventListener(this.name,this,t),this._$AH=t;}handleEvent(t){var i,s;"function"==typeof this._$AH?this._$AH.call(null!==(s=null===(i=this.options)||void 0===i?void 0:i.host)&&void 0!==s?s:this.element,t):this._$AH.handleEvent(t);}}class Z$2{constructor(t,i,s){this.element=t,this.type=6,this._$AN=void 0,this._$AM=i,this.options=s;}get _$AU(){return this._$AM._$AU}_$AI(t){S$3(this,t);}}const j$3={O:o$s,P:n$l,A:l$d,C:1,M:V$2,L:M$2,R:v$4,D:S$3,I:R$2,V:k$2,H:L$2,N:z$2,U:H$3,F:Z$2},B$1=i$g.litHtmlPolyfillSupport;null==B$1||B$1(N$2,R$2),(null!==(t$d=i$g.litHtmlVersions)&&void 0!==t$d?t$d:i$g.litHtmlVersions=[]).push("2.8.0");const D$1=(t,i,s)=>{var e,o;const n=null!==(e=null==s?void 0:s.renderBefore)&&void 0!==e?e:i;let l=n._$litPart$;if(void 0===l){const t=null!==(o=null==s?void 0:s.renderBefore)&&void 0!==o?o:null;n._$litPart$=l=new R$2(i.insertBefore(u$8(),t),t,void 0,null!=s?s:{});}return l._$AI(t),l};

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */var l$c,o$r;const r$e=d$6;class s$b extends d$6{constructor(){super(...arguments),this.renderOptions={host:this},this._$Do=void 0;}createRenderRoot(){var t,e;const i=super.createRenderRoot();return null!==(t=(e=this.renderOptions).renderBefore)&&void 0!==t||(e.renderBefore=i.firstChild),i}update(t){const i=this.render();this.hasUpdated||(this.renderOptions.isConnected=this.isConnected),super.update(t),this._$Do=D$1(i,this.renderRoot,this.renderOptions);}connectedCallback(){var t;super.connectedCallback(),null===(t=this._$Do)||void 0===t||t.setConnected(!0);}disconnectedCallback(){var t;super.disconnectedCallback(),null===(t=this._$Do)||void 0===t||t.setConnected(!1);}render(){return T$2}}s$b.finalized=!0,s$b._$litElement$=!0,null===(l$c=globalThis.litElementHydrateSupport)||void 0===l$c||l$c.call(globalThis,{LitElement:s$b});const n$k=globalThis.litElementPolyfillSupport;null==n$k||n$k({LitElement:s$b});const h$a={_$AK:(t,e,i)=>{t._$AK(e,i);},_$AL:t=>t._$AL};(null!==(o$r=globalThis.litElementVersions)&&void 0!==o$r?o$r:globalThis.litElementVersions=[]).push("3.3.3");

/**
 * @license
 * Copyright 2022 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const o$q=!1;

const appliedClassMixins = new WeakMap();

/** Vefify if the Mixin was previously applyed
 * @private
 * @param {function} mixin      Mixin being applyed
 * @param {object} superClass   Class receiving the new mixin
 * @returns {boolean}
 */
function wasMixinPreviouslyApplied(mixin, superClass) {
  let klass = superClass;
  while (klass) {
    if (appliedClassMixins.get(klass) === mixin) {
      return true;
    }
    klass = Object.getPrototypeOf(klass);
  }
  return false;
}

/** Apply each mixin in the chain to make sure they are not applied more than once to the final class.
 * @export
 * @param {function} mixin      Mixin to be applyed
 * @returns {object}            Mixed class with mixin applied
 */
function dedupeMixin(mixin) {
  return superClass => {
    if (wasMixinPreviouslyApplied(mixin, superClass)) {
      return superClass;
    }
    const mixedClass = mixin(superClass);
    appliedClassMixins.set(mixedClass, mixin);
    return mixedClass;
  };
}

var _templateObject$1E;
function _taggedTemplateLiteral$1E(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
var bootstrapIcons = i$h(_templateObject$1E || (_templateObject$1E = _taggedTemplateLiteral$1E(["\n    .bi::before,\n    [class^=\"bi-\"]::before,\n    [class*=\" bi-\"]::before {\n        display: inline-block;\n        font-family: bootstrap-icons !important;\n        font-style: normal;\n        font-weight: normal !important;\n        font-variant: normal;\n        text-transform: none;\n        line-height: 1;\n\t\tvertical-align: middle;\n        -webkit-font-smoothing: antialiased;\n        -moz-osx-font-smoothing: grayscale;\n    }\n\n    .bi-123::before {\n        content: \"\\f67f\";\n    }\n\n    .bi-alarm-fill::before {\n        content: \"\\f101\";\n    }\n\n    .bi-alarm::before {\n        content: \"\\f102\";\n    }\n\n    .bi-align-bottom::before {\n        content: \"\\f103\";\n    }\n\n    .bi-align-center::before {\n        content: \"\\f104\";\n    }\n\n    .bi-align-end::before {\n        content: \"\\f105\";\n    }\n\n    .bi-align-middle::before {\n        content: \"\\f106\";\n    }\n\n    .bi-align-start::before {\n        content: \"\\f107\";\n    }\n\n    .bi-align-top::before {\n        content: \"\\f108\";\n    }\n\n    .bi-alt::before {\n        content: \"\\f109\";\n    }\n\n    .bi-app-indicator::before {\n        content: \"\\f10a\";\n    }\n\n    .bi-app::before {\n        content: \"\\f10b\";\n    }\n\n    .bi-archive-fill::before {\n        content: \"\\f10c\";\n    }\n\n    .bi-archive::before {\n        content: \"\\f10d\";\n    }\n\n    .bi-arrow-90deg-down::before {\n        content: \"\\f10e\";\n    }\n\n    .bi-arrow-90deg-left::before {\n        content: \"\\f10f\";\n    }\n\n    .bi-arrow-90deg-right::before {\n        content: \"\\f110\";\n    }\n\n    .bi-arrow-90deg-up::before {\n        content: \"\\f111\";\n    }\n\n    .bi-arrow-bar-down::before {\n        content: \"\\f112\";\n    }\n\n    .bi-arrow-bar-left::before {\n        content: \"\\f113\";\n    }\n\n    .bi-arrow-bar-right::before {\n        content: \"\\f114\";\n    }\n\n    .bi-arrow-bar-up::before {\n        content: \"\\f115\";\n    }\n\n    .bi-arrow-clockwise::before {\n        content: \"\\f116\";\n    }\n\n    .bi-arrow-counterclockwise::before {\n        content: \"\\f117\";\n    }\n\n    .bi-arrow-down-circle-fill::before {\n        content: \"\\f118\";\n    }\n\n    .bi-arrow-down-circle::before {\n        content: \"\\f119\";\n    }\n\n    .bi-arrow-down-left-circle-fill::before {\n        content: \"\\f11a\";\n    }\n\n    .bi-arrow-down-left-circle::before {\n        content: \"\\f11b\";\n    }\n\n    .bi-arrow-down-left-square-fill::before {\n        content: \"\\f11c\";\n    }\n\n    .bi-arrow-down-left-square::before {\n        content: \"\\f11d\";\n    }\n\n    .bi-arrow-down-left::before {\n        content: \"\\f11e\";\n    }\n\n    .bi-arrow-down-right-circle-fill::before {\n        content: \"\\f11f\";\n    }\n\n    .bi-arrow-down-right-circle::before {\n        content: \"\\f120\";\n    }\n\n    .bi-arrow-down-right-square-fill::before {\n        content: \"\\f121\";\n    }\n\n    .bi-arrow-down-right-square::before {\n        content: \"\\f122\";\n    }\n\n    .bi-arrow-down-right::before {\n        content: \"\\f123\";\n    }\n\n    .bi-arrow-down-short::before {\n        content: \"\\f124\";\n    }\n\n    .bi-arrow-down-square-fill::before {\n        content: \"\\f125\";\n    }\n\n    .bi-arrow-down-square::before {\n        content: \"\\f126\";\n    }\n\n    .bi-arrow-down-up::before {\n        content: \"\\f127\";\n    }\n\n    .bi-arrow-down::before {\n        content: \"\\f128\";\n    }\n\n    .bi-arrow-left-circle-fill::before {\n        content: \"\\f129\";\n    }\n\n    .bi-arrow-left-circle::before {\n        content: \"\\f12a\";\n    }\n\n    .bi-arrow-left-right::before {\n        content: \"\\f12b\";\n    }\n\n    .bi-arrow-left-short::before {\n        content: \"\\f12c\";\n    }\n\n    .bi-arrow-left-square-fill::before {\n        content: \"\\f12d\";\n    }\n\n    .bi-arrow-left-square::before {\n        content: \"\\f12e\";\n    }\n\n    .bi-arrow-left::before {\n        content: \"\\f12f\";\n    }\n\n    .bi-arrow-repeat::before {\n        content: \"\\f130\";\n    }\n\n    .bi-arrow-return-left::before {\n        content: \"\\f131\";\n    }\n\n    .bi-arrow-return-right::before {\n        content: \"\\f132\";\n    }\n\n    .bi-arrow-right-circle-fill::before {\n        content: \"\\f133\";\n    }\n\n    .bi-arrow-right-circle::before {\n        content: \"\\f134\";\n    }\n\n    .bi-arrow-right-short::before {\n        content: \"\\f135\";\n    }\n\n    .bi-arrow-right-square-fill::before {\n        content: \"\\f136\";\n    }\n\n    .bi-arrow-right-square::before {\n        content: \"\\f137\";\n    }\n\n    .bi-arrow-right::before {\n        content: \"\\f138\";\n    }\n\n    .bi-arrow-up-circle-fill::before {\n        content: \"\\f139\";\n    }\n\n    .bi-arrow-up-circle::before {\n        content: \"\\f13a\";\n    }\n\n    .bi-arrow-up-left-circle-fill::before {\n        content: \"\\f13b\";\n    }\n\n    .bi-arrow-up-left-circle::before {\n        content: \"\\f13c\";\n    }\n\n    .bi-arrow-up-left-square-fill::before {\n        content: \"\\f13d\";\n    }\n\n    .bi-arrow-up-left-square::before {\n        content: \"\\f13e\";\n    }\n\n    .bi-arrow-up-left::before {\n        content: \"\\f13f\";\n    }\n\n    .bi-arrow-up-right-circle-fill::before {\n        content: \"\\f140\";\n    }\n\n    .bi-arrow-up-right-circle::before {\n        content: \"\\f141\";\n    }\n\n    .bi-arrow-up-right-square-fill::before {\n        content: \"\\f142\";\n    }\n\n    .bi-arrow-up-right-square::before {\n        content: \"\\f143\";\n    }\n\n    .bi-arrow-up-right::before {\n        content: \"\\f144\";\n    }\n\n    .bi-arrow-up-short::before {\n        content: \"\\f145\";\n    }\n\n    .bi-arrow-up-square-fill::before {\n        content: \"\\f146\";\n    }\n\n    .bi-arrow-up-square::before {\n        content: \"\\f147\";\n    }\n\n    .bi-arrow-up::before {\n        content: \"\\f148\";\n    }\n\n    .bi-arrows-angle-contract::before {\n        content: \"\\f149\";\n    }\n\n    .bi-arrows-angle-expand::before {\n        content: \"\\f14a\";\n    }\n\n    .bi-arrows-collapse::before {\n        content: \"\\f14b\";\n    }\n\n    .bi-arrows-expand::before {\n        content: \"\\f14c\";\n    }\n\n    .bi-arrows-fullscreen::before {\n        content: \"\\f14d\";\n    }\n\n    .bi-arrows-move::before {\n        content: \"\\f14e\";\n    }\n\n    .bi-aspect-ratio-fill::before {\n        content: \"\\f14f\";\n    }\n\n    .bi-aspect-ratio::before {\n        content: \"\\f150\";\n    }\n\n    .bi-asterisk::before {\n        content: \"\\f151\";\n    }\n\n    .bi-at::before {\n        content: \"\\f152\";\n    }\n\n    .bi-award-fill::before {\n        content: \"\\f153\";\n    }\n\n    .bi-award::before {\n        content: \"\\f154\";\n    }\n\n    .bi-back::before {\n        content: \"\\f155\";\n    }\n\n    .bi-backspace-fill::before {\n        content: \"\\f156\";\n    }\n\n    .bi-backspace-reverse-fill::before {\n        content: \"\\f157\";\n    }\n\n    .bi-backspace-reverse::before {\n        content: \"\\f158\";\n    }\n\n    .bi-backspace::before {\n        content: \"\\f159\";\n    }\n\n    .bi-badge-3d-fill::before {\n        content: \"\\f15a\";\n    }\n\n    .bi-badge-3d::before {\n        content: \"\\f15b\";\n    }\n\n    .bi-badge-4k-fill::before {\n        content: \"\\f15c\";\n    }\n\n    .bi-badge-4k::before {\n        content: \"\\f15d\";\n    }\n\n    .bi-badge-8k-fill::before {\n        content: \"\\f15e\";\n    }\n\n    .bi-badge-8k::before {\n        content: \"\\f15f\";\n    }\n\n    .bi-badge-ad-fill::before {\n        content: \"\\f160\";\n    }\n\n    .bi-badge-ad::before {\n        content: \"\\f161\";\n    }\n\n    .bi-badge-ar-fill::before {\n        content: \"\\f162\";\n    }\n\n    .bi-badge-ar::before {\n        content: \"\\f163\";\n    }\n\n    .bi-badge-cc-fill::before {\n        content: \"\\f164\";\n    }\n\n    .bi-badge-cc::before {\n        content: \"\\f165\";\n    }\n\n    .bi-badge-hd-fill::before {\n        content: \"\\f166\";\n    }\n\n    .bi-badge-hd::before {\n        content: \"\\f167\";\n    }\n\n    .bi-badge-tm-fill::before {\n        content: \"\\f168\";\n    }\n\n    .bi-badge-tm::before {\n        content: \"\\f169\";\n    }\n\n    .bi-badge-vo-fill::before {\n        content: \"\\f16a\";\n    }\n\n    .bi-badge-vo::before {\n        content: \"\\f16b\";\n    }\n\n    .bi-badge-vr-fill::before {\n        content: \"\\f16c\";\n    }\n\n    .bi-badge-vr::before {\n        content: \"\\f16d\";\n    }\n\n    .bi-badge-wc-fill::before {\n        content: \"\\f16e\";\n    }\n\n    .bi-badge-wc::before {\n        content: \"\\f16f\";\n    }\n\n    .bi-bag-check-fill::before {\n        content: \"\\f170\";\n    }\n\n    .bi-bag-check::before {\n        content: \"\\f171\";\n    }\n\n    .bi-bag-dash-fill::before {\n        content: \"\\f172\";\n    }\n\n    .bi-bag-dash::before {\n        content: \"\\f173\";\n    }\n\n    .bi-bag-fill::before {\n        content: \"\\f174\";\n    }\n\n    .bi-bag-plus-fill::before {\n        content: \"\\f175\";\n    }\n\n    .bi-bag-plus::before {\n        content: \"\\f176\";\n    }\n\n    .bi-bag-x-fill::before {\n        content: \"\\f177\";\n    }\n\n    .bi-bag-x::before {\n        content: \"\\f178\";\n    }\n\n    .bi-bag::before {\n        content: \"\\f179\";\n    }\n\n    .bi-bar-chart-fill::before {\n        content: \"\\f17a\";\n    }\n\n    .bi-bar-chart-line-fill::before {\n        content: \"\\f17b\";\n    }\n\n    .bi-bar-chart-line::before {\n        content: \"\\f17c\";\n    }\n\n    .bi-bar-chart-steps::before {\n        content: \"\\f17d\";\n    }\n\n    .bi-bar-chart::before {\n        content: \"\\f17e\";\n    }\n\n    .bi-basket-fill::before {\n        content: \"\\f17f\";\n    }\n\n    .bi-basket::before {\n        content: \"\\f180\";\n    }\n\n    .bi-basket2-fill::before {\n        content: \"\\f181\";\n    }\n\n    .bi-basket2::before {\n        content: \"\\f182\";\n    }\n\n    .bi-basket3-fill::before {\n        content: \"\\f183\";\n    }\n\n    .bi-basket3::before {\n        content: \"\\f184\";\n    }\n\n    .bi-battery-charging::before {\n        content: \"\\f185\";\n    }\n\n    .bi-battery-full::before {\n        content: \"\\f186\";\n    }\n\n    .bi-battery-half::before {\n        content: \"\\f187\";\n    }\n\n    .bi-battery::before {\n        content: \"\\f188\";\n    }\n\n    .bi-bell-fill::before {\n        content: \"\\f189\";\n    }\n\n    .bi-bell::before {\n        content: \"\\f18a\";\n    }\n\n    .bi-bezier::before {\n        content: \"\\f18b\";\n    }\n\n    .bi-bezier2::before {\n        content: \"\\f18c\";\n    }\n\n    .bi-bicycle::before {\n        content: \"\\f18d\";\n    }\n\n    .bi-binoculars-fill::before {\n        content: \"\\f18e\";\n    }\n\n    .bi-binoculars::before {\n        content: \"\\f18f\";\n    }\n\n    .bi-blockquote-left::before {\n        content: \"\\f190\";\n    }\n\n    .bi-blockquote-right::before {\n        content: \"\\f191\";\n    }\n\n    .bi-book-fill::before {\n        content: \"\\f192\";\n    }\n\n    .bi-book-half::before {\n        content: \"\\f193\";\n    }\n\n    .bi-book::before {\n        content: \"\\f194\";\n    }\n\n    .bi-bookmark-check-fill::before {\n        content: \"\\f195\";\n    }\n\n    .bi-bookmark-check::before {\n        content: \"\\f196\";\n    }\n\n    .bi-bookmark-dash-fill::before {\n        content: \"\\f197\";\n    }\n\n    .bi-bookmark-dash::before {\n        content: \"\\f198\";\n    }\n\n    .bi-bookmark-fill::before {\n        content: \"\\f199\";\n    }\n\n    .bi-bookmark-heart-fill::before {\n        content: \"\\f19a\";\n    }\n\n    .bi-bookmark-heart::before {\n        content: \"\\f19b\";\n    }\n\n    .bi-bookmark-plus-fill::before {\n        content: \"\\f19c\";\n    }\n\n    .bi-bookmark-plus::before {\n        content: \"\\f19d\";\n    }\n\n    .bi-bookmark-star-fill::before {\n        content: \"\\f19e\";\n    }\n\n    .bi-bookmark-star::before {\n        content: \"\\f19f\";\n    }\n\n    .bi-bookmark-x-fill::before {\n        content: \"\\f1a0\";\n    }\n\n    .bi-bookmark-x::before {\n        content: \"\\f1a1\";\n    }\n\n    .bi-bookmark::before {\n        content: \"\\f1a2\";\n    }\n\n    .bi-bookmarks-fill::before {\n        content: \"\\f1a3\";\n    }\n\n    .bi-bookmarks::before {\n        content: \"\\f1a4\";\n    }\n\n    .bi-bookshelf::before {\n        content: \"\\f1a5\";\n    }\n\n    .bi-bootstrap-fill::before {\n        content: \"\\f1a6\";\n    }\n\n    .bi-bootstrap-reboot::before {\n        content: \"\\f1a7\";\n    }\n\n    .bi-bootstrap::before {\n        content: \"\\f1a8\";\n    }\n\n    .bi-border-all::before {\n        content: \"\\f1a9\";\n    }\n\n    .bi-border-bottom::before {\n        content: \"\\f1aa\";\n    }\n\n    .bi-border-center::before {\n        content: \"\\f1ab\";\n    }\n\n    .bi-border-inner::before {\n        content: \"\\f1ac\";\n    }\n\n    .bi-border-left::before {\n        content: \"\\f1ad\";\n    }\n\n    .bi-border-middle::before {\n        content: \"\\f1ae\";\n    }\n\n    .bi-border-outer::before {\n        content: \"\\f1af\";\n    }\n\n    .bi-border-right::before {\n        content: \"\\f1b0\";\n    }\n\n    .bi-border-style::before {\n        content: \"\\f1b1\";\n    }\n\n    .bi-border-top::before {\n        content: \"\\f1b2\";\n    }\n\n    .bi-border-width::before {\n        content: \"\\f1b3\";\n    }\n\n    .bi-border::before {\n        content: \"\\f1b4\";\n    }\n\n    .bi-bounding-box-circles::before {\n        content: \"\\f1b5\";\n    }\n\n    .bi-bounding-box::before {\n        content: \"\\f1b6\";\n    }\n\n    .bi-box-arrow-down-left::before {\n        content: \"\\f1b7\";\n    }\n\n    .bi-box-arrow-down-right::before {\n        content: \"\\f1b8\";\n    }\n\n    .bi-box-arrow-down::before {\n        content: \"\\f1b9\";\n    }\n\n    .bi-box-arrow-in-down-left::before {\n        content: \"\\f1ba\";\n    }\n\n    .bi-box-arrow-in-down-right::before {\n        content: \"\\f1bb\";\n    }\n\n    .bi-box-arrow-in-down::before {\n        content: \"\\f1bc\";\n    }\n\n    .bi-box-arrow-in-left::before {\n        content: \"\\f1bd\";\n    }\n\n    .bi-box-arrow-in-right::before {\n        content: \"\\f1be\";\n    }\n\n    .bi-box-arrow-in-up-left::before {\n        content: \"\\f1bf\";\n    }\n\n    .bi-box-arrow-in-up-right::before {\n        content: \"\\f1c0\";\n    }\n\n    .bi-box-arrow-in-up::before {\n        content: \"\\f1c1\";\n    }\n\n    .bi-box-arrow-left::before {\n        content: \"\\f1c2\";\n    }\n\n    .bi-box-arrow-right::before {\n        content: \"\\f1c3\";\n    }\n\n    .bi-box-arrow-up-left::before {\n        content: \"\\f1c4\";\n    }\n\n    .bi-box-arrow-up-right::before {\n        content: \"\\f1c5\";\n    }\n\n    .bi-box-arrow-up::before {\n        content: \"\\f1c6\";\n    }\n\n    .bi-box-seam::before {\n        content: \"\\f1c7\";\n    }\n\n    .bi-box::before {\n        content: \"\\f1c8\";\n    }\n\n    .bi-braces::before {\n        content: \"\\f1c9\";\n    }\n\n    .bi-bricks::before {\n        content: \"\\f1ca\";\n    }\n\n    .bi-briefcase-fill::before {\n        content: \"\\f1cb\";\n    }\n\n    .bi-briefcase::before {\n        content: \"\\f1cc\";\n    }\n\n    .bi-brightness-alt-high-fill::before {\n        content: \"\\f1cd\";\n    }\n\n    .bi-brightness-alt-high::before {\n        content: \"\\f1ce\";\n    }\n\n    .bi-brightness-alt-low-fill::before {\n        content: \"\\f1cf\";\n    }\n\n    .bi-brightness-alt-low::before {\n        content: \"\\f1d0\";\n    }\n\n    .bi-brightness-high-fill::before {\n        content: \"\\f1d1\";\n    }\n\n    .bi-brightness-high::before {\n        content: \"\\f1d2\";\n    }\n\n    .bi-brightness-low-fill::before {\n        content: \"\\f1d3\";\n    }\n\n    .bi-brightness-low::before {\n        content: \"\\f1d4\";\n    }\n\n    .bi-broadcast-pin::before {\n        content: \"\\f1d5\";\n    }\n\n    .bi-broadcast::before {\n        content: \"\\f1d6\";\n    }\n\n    .bi-brush-fill::before {\n        content: \"\\f1d7\";\n    }\n\n    .bi-brush::before {\n        content: \"\\f1d8\";\n    }\n\n    .bi-bucket-fill::before {\n        content: \"\\f1d9\";\n    }\n\n    .bi-bucket::before {\n        content: \"\\f1da\";\n    }\n\n    .bi-bug-fill::before {\n        content: \"\\f1db\";\n    }\n\n    .bi-bug::before {\n        content: \"\\f1dc\";\n    }\n\n    .bi-building::before {\n        content: \"\\f1dd\";\n    }\n\n    .bi-bullseye::before {\n        content: \"\\f1de\";\n    }\n\n    .bi-calculator-fill::before {\n        content: \"\\f1df\";\n    }\n\n    .bi-calculator::before {\n        content: \"\\f1e0\";\n    }\n\n    .bi-calendar-check-fill::before {\n        content: \"\\f1e1\";\n    }\n\n    .bi-calendar-check::before {\n        content: \"\\f1e2\";\n    }\n\n    .bi-calendar-date-fill::before {\n        content: \"\\f1e3\";\n    }\n\n    .bi-calendar-date::before {\n        content: \"\\f1e4\";\n    }\n\n    .bi-calendar-day-fill::before {\n        content: \"\\f1e5\";\n    }\n\n    .bi-calendar-day::before {\n        content: \"\\f1e6\";\n    }\n\n    .bi-calendar-event-fill::before {\n        content: \"\\f1e7\";\n    }\n\n    .bi-calendar-event::before {\n        content: \"\\f1e8\";\n    }\n\n    .bi-calendar-fill::before {\n        content: \"\\f1e9\";\n    }\n\n    .bi-calendar-minus-fill::before {\n        content: \"\\f1ea\";\n    }\n\n    .bi-calendar-minus::before {\n        content: \"\\f1eb\";\n    }\n\n    .bi-calendar-month-fill::before {\n        content: \"\\f1ec\";\n    }\n\n    .bi-calendar-month::before {\n        content: \"\\f1ed\";\n    }\n\n    .bi-calendar-plus-fill::before {\n        content: \"\\f1ee\";\n    }\n\n    .bi-calendar-plus::before {\n        content: \"\\f1ef\";\n    }\n\n    .bi-calendar-range-fill::before {\n        content: \"\\f1f0\";\n    }\n\n    .bi-calendar-range::before {\n        content: \"\\f1f1\";\n    }\n\n    .bi-calendar-week-fill::before {\n        content: \"\\f1f2\";\n    }\n\n    .bi-calendar-week::before {\n        content: \"\\f1f3\";\n    }\n\n    .bi-calendar-x-fill::before {\n        content: \"\\f1f4\";\n    }\n\n    .bi-calendar-x::before {\n        content: \"\\f1f5\";\n    }\n\n    .bi-calendar::before {\n        content: \"\\f1f6\";\n    }\n\n    .bi-calendar2-check-fill::before {\n        content: \"\\f1f7\";\n    }\n\n    .bi-calendar2-check::before {\n        content: \"\\f1f8\";\n    }\n\n    .bi-calendar2-date-fill::before {\n        content: \"\\f1f9\";\n    }\n\n    .bi-calendar2-date::before {\n        content: \"\\f1fa\";\n    }\n\n    .bi-calendar2-day-fill::before {\n        content: \"\\f1fb\";\n    }\n\n    .bi-calendar2-day::before {\n        content: \"\\f1fc\";\n    }\n\n    .bi-calendar2-event-fill::before {\n        content: \"\\f1fd\";\n    }\n\n    .bi-calendar2-event::before {\n        content: \"\\f1fe\";\n    }\n\n    .bi-calendar2-fill::before {\n        content: \"\\f1ff\";\n    }\n\n    .bi-calendar2-minus-fill::before {\n        content: \"\\f200\";\n    }\n\n    .bi-calendar2-minus::before {\n        content: \"\\f201\";\n    }\n\n    .bi-calendar2-month-fill::before {\n        content: \"\\f202\";\n    }\n\n    .bi-calendar2-month::before {\n        content: \"\\f203\";\n    }\n\n    .bi-calendar2-plus-fill::before {\n        content: \"\\f204\";\n    }\n\n    .bi-calendar2-plus::before {\n        content: \"\\f205\";\n    }\n\n    .bi-calendar2-range-fill::before {\n        content: \"\\f206\";\n    }\n\n    .bi-calendar2-range::before {\n        content: \"\\f207\";\n    }\n\n    .bi-calendar2-week-fill::before {\n        content: \"\\f208\";\n    }\n\n    .bi-calendar2-week::before {\n        content: \"\\f209\";\n    }\n\n    .bi-calendar2-x-fill::before {\n        content: \"\\f20a\";\n    }\n\n    .bi-calendar2-x::before {\n        content: \"\\f20b\";\n    }\n\n    .bi-calendar2::before {\n        content: \"\\f20c\";\n    }\n\n    .bi-calendar3-event-fill::before {\n        content: \"\\f20d\";\n    }\n\n    .bi-calendar3-event::before {\n        content: \"\\f20e\";\n    }\n\n    .bi-calendar3-fill::before {\n        content: \"\\f20f\";\n    }\n\n    .bi-calendar3-range-fill::before {\n        content: \"\\f210\";\n    }\n\n    .bi-calendar3-range::before {\n        content: \"\\f211\";\n    }\n\n    .bi-calendar3-week-fill::before {\n        content: \"\\f212\";\n    }\n\n    .bi-calendar3-week::before {\n        content: \"\\f213\";\n    }\n\n    .bi-calendar3::before {\n        content: \"\\f214\";\n    }\n\n    .bi-calendar4-event::before {\n        content: \"\\f215\";\n    }\n\n    .bi-calendar4-range::before {\n        content: \"\\f216\";\n    }\n\n    .bi-calendar4-week::before {\n        content: \"\\f217\";\n    }\n\n    .bi-calendar4::before {\n        content: \"\\f218\";\n    }\n\n    .bi-camera-fill::before {\n        content: \"\\f219\";\n    }\n\n    .bi-camera-reels-fill::before {\n        content: \"\\f21a\";\n    }\n\n    .bi-camera-reels::before {\n        content: \"\\f21b\";\n    }\n\n    .bi-camera-video-fill::before {\n        content: \"\\f21c\";\n    }\n\n    .bi-camera-video-off-fill::before {\n        content: \"\\f21d\";\n    }\n\n    .bi-camera-video-off::before {\n        content: \"\\f21e\";\n    }\n\n    .bi-camera-video::before {\n        content: \"\\f21f\";\n    }\n\n    .bi-camera::before {\n        content: \"\\f220\";\n    }\n\n    .bi-camera2::before {\n        content: \"\\f221\";\n    }\n\n    .bi-capslock-fill::before {\n        content: \"\\f222\";\n    }\n\n    .bi-capslock::before {\n        content: \"\\f223\";\n    }\n\n    .bi-card-checklist::before {\n        content: \"\\f224\";\n    }\n\n    .bi-card-heading::before {\n        content: \"\\f225\";\n    }\n\n    .bi-card-image::before {\n        content: \"\\f226\";\n    }\n\n    .bi-card-list::before {\n        content: \"\\f227\";\n    }\n\n    .bi-card-text::before {\n        content: \"\\f228\";\n    }\n\n    .bi-caret-down-fill::before {\n        content: \"\\f229\";\n    }\n\n    .bi-caret-down-square-fill::before {\n        content: \"\\f22a\";\n    }\n\n    .bi-caret-down-square::before {\n        content: \"\\f22b\";\n    }\n\n    .bi-caret-down::before {\n        content: \"\\f22c\";\n    }\n\n    .bi-caret-left-fill::before {\n        content: \"\\f22d\";\n    }\n\n    .bi-caret-left-square-fill::before {\n        content: \"\\f22e\";\n    }\n\n    .bi-caret-left-square::before {\n        content: \"\\f22f\";\n    }\n\n    .bi-caret-left::before {\n        content: \"\\f230\";\n    }\n\n    .bi-caret-right-fill::before {\n        content: \"\\f231\";\n    }\n\n    .bi-caret-right-square-fill::before {\n        content: \"\\f232\";\n    }\n\n    .bi-caret-right-square::before {\n        content: \"\\f233\";\n    }\n\n    .bi-caret-right::before {\n        content: \"\\f234\";\n    }\n\n    .bi-caret-up-fill::before {\n        content: \"\\f235\";\n    }\n\n    .bi-caret-up-square-fill::before {\n        content: \"\\f236\";\n    }\n\n    .bi-caret-up-square::before {\n        content: \"\\f237\";\n    }\n\n    .bi-caret-up::before {\n        content: \"\\f238\";\n    }\n\n    .bi-cart-check-fill::before {\n        content: \"\\f239\";\n    }\n\n    .bi-cart-check::before {\n        content: \"\\f23a\";\n    }\n\n    .bi-cart-dash-fill::before {\n        content: \"\\f23b\";\n    }\n\n    .bi-cart-dash::before {\n        content: \"\\f23c\";\n    }\n\n    .bi-cart-fill::before {\n        content: \"\\f23d\";\n    }\n\n    .bi-cart-plus-fill::before {\n        content: \"\\f23e\";\n    }\n\n    .bi-cart-plus::before {\n        content: \"\\f23f\";\n    }\n\n    .bi-cart-x-fill::before {\n        content: \"\\f240\";\n    }\n\n    .bi-cart-x::before {\n        content: \"\\f241\";\n    }\n\n    .bi-cart::before {\n        content: \"\\f242\";\n    }\n\n    .bi-cart2::before {\n        content: \"\\f243\";\n    }\n\n    .bi-cart3::before {\n        content: \"\\f244\";\n    }\n\n    .bi-cart4::before {\n        content: \"\\f245\";\n    }\n\n    .bi-cash-stack::before {\n        content: \"\\f246\";\n    }\n\n    .bi-cash::before {\n        content: \"\\f247\";\n    }\n\n    .bi-cast::before {\n        content: \"\\f248\";\n    }\n\n    .bi-chat-dots-fill::before {\n        content: \"\\f249\";\n    }\n\n    .bi-chat-dots::before {\n        content: \"\\f24a\";\n    }\n\n    .bi-chat-fill::before {\n        content: \"\\f24b\";\n    }\n\n    .bi-chat-left-dots-fill::before {\n        content: \"\\f24c\";\n    }\n\n    .bi-chat-left-dots::before {\n        content: \"\\f24d\";\n    }\n\n    .bi-chat-left-fill::before {\n        content: \"\\f24e\";\n    }\n\n    .bi-chat-left-quote-fill::before {\n        content: \"\\f24f\";\n    }\n\n    .bi-chat-left-quote::before {\n        content: \"\\f250\";\n    }\n\n    .bi-chat-left-text-fill::before {\n        content: \"\\f251\";\n    }\n\n    .bi-chat-left-text::before {\n        content: \"\\f252\";\n    }\n\n    .bi-chat-left::before {\n        content: \"\\f253\";\n    }\n\n    .bi-chat-quote-fill::before {\n        content: \"\\f254\";\n    }\n\n    .bi-chat-quote::before {\n        content: \"\\f255\";\n    }\n\n    .bi-chat-right-dots-fill::before {\n        content: \"\\f256\";\n    }\n\n    .bi-chat-right-dots::before {\n        content: \"\\f257\";\n    }\n\n    .bi-chat-right-fill::before {\n        content: \"\\f258\";\n    }\n\n    .bi-chat-right-quote-fill::before {\n        content: \"\\f259\";\n    }\n\n    .bi-chat-right-quote::before {\n        content: \"\\f25a\";\n    }\n\n    .bi-chat-right-text-fill::before {\n        content: \"\\f25b\";\n    }\n\n    .bi-chat-right-text::before {\n        content: \"\\f25c\";\n    }\n\n    .bi-chat-right::before {\n        content: \"\\f25d\";\n    }\n\n    .bi-chat-square-dots-fill::before {\n        content: \"\\f25e\";\n    }\n\n    .bi-chat-square-dots::before {\n        content: \"\\f25f\";\n    }\n\n    .bi-chat-square-fill::before {\n        content: \"\\f260\";\n    }\n\n    .bi-chat-square-quote-fill::before {\n        content: \"\\f261\";\n    }\n\n    .bi-chat-square-quote::before {\n        content: \"\\f262\";\n    }\n\n    .bi-chat-square-text-fill::before {\n        content: \"\\f263\";\n    }\n\n    .bi-chat-square-text::before {\n        content: \"\\f264\";\n    }\n\n    .bi-chat-square::before {\n        content: \"\\f265\";\n    }\n\n    .bi-chat-text-fill::before {\n        content: \"\\f266\";\n    }\n\n    .bi-chat-text::before {\n        content: \"\\f267\";\n    }\n\n    .bi-chat::before {\n        content: \"\\f268\";\n    }\n\n    .bi-check-all::before {\n        content: \"\\f269\";\n    }\n\n    .bi-check-circle-fill::before {\n        content: \"\\f26a\";\n    }\n\n    .bi-check-circle::before {\n        content: \"\\f26b\";\n    }\n\n    .bi-check-square-fill::before {\n        content: \"\\f26c\";\n    }\n\n    .bi-check-square::before {\n        content: \"\\f26d\";\n    }\n\n    .bi-check::before {\n        content: \"\\f26e\";\n    }\n\n    .bi-check2-all::before {\n        content: \"\\f26f\";\n    }\n\n    .bi-check2-circle::before {\n        content: \"\\f270\";\n    }\n\n    .bi-check2-square::before {\n        content: \"\\f271\";\n    }\n\n    .bi-check2::before {\n        content: \"\\f272\";\n    }\n\n    .bi-chevron-bar-contract::before {\n        content: \"\\f273\";\n    }\n\n    .bi-chevron-bar-down::before {\n        content: \"\\f274\";\n    }\n\n    .bi-chevron-bar-expand::before {\n        content: \"\\f275\";\n    }\n\n    .bi-chevron-bar-left::before {\n        content: \"\\f276\";\n    }\n\n    .bi-chevron-bar-right::before {\n        content: \"\\f277\";\n    }\n\n    .bi-chevron-bar-up::before {\n        content: \"\\f278\";\n    }\n\n    .bi-chevron-compact-down::before {\n        content: \"\\f279\";\n    }\n\n    .bi-chevron-compact-left::before {\n        content: \"\\f27a\";\n    }\n\n    .bi-chevron-compact-right::before {\n        content: \"\\f27b\";\n    }\n\n    .bi-chevron-compact-up::before {\n        content: \"\\f27c\";\n    }\n\n    .bi-chevron-contract::before {\n        content: \"\\f27d\";\n    }\n\n    .bi-chevron-double-down::before {\n        content: \"\\f27e\";\n    }\n\n    .bi-chevron-double-left::before {\n        content: \"\\f27f\";\n    }\n\n    .bi-chevron-double-right::before {\n        content: \"\\f280\";\n    }\n\n    .bi-chevron-double-up::before {\n        content: \"\\f281\";\n    }\n\n    .bi-chevron-down::before {\n        content: \"\\f282\";\n    }\n\n    .bi-chevron-expand::before {\n        content: \"\\f283\";\n    }\n\n    .bi-chevron-left::before {\n        content: \"\\f284\";\n    }\n\n    .bi-chevron-right::before {\n        content: \"\\f285\";\n    }\n\n    .bi-chevron-up::before {\n        content: \"\\f286\";\n    }\n\n    .bi-circle-fill::before {\n        content: \"\\f287\";\n    }\n\n    .bi-circle-half::before {\n        content: \"\\f288\";\n    }\n\n    .bi-circle-square::before {\n        content: \"\\f289\";\n    }\n\n    .bi-circle::before {\n        content: \"\\f28a\";\n    }\n\n    .bi-clipboard-check::before {\n        content: \"\\f28b\";\n    }\n\n    .bi-clipboard-data::before {\n        content: \"\\f28c\";\n    }\n\n    .bi-clipboard-minus::before {\n        content: \"\\f28d\";\n    }\n\n    .bi-clipboard-plus::before {\n        content: \"\\f28e\";\n    }\n\n    .bi-clipboard-x::before {\n        content: \"\\f28f\";\n    }\n\n    .bi-clipboard::before {\n        content: \"\\f290\";\n    }\n\n    .bi-clock-fill::before {\n        content: \"\\f291\";\n    }\n\n    .bi-clock-history::before {\n        content: \"\\f292\";\n    }\n\n    .bi-clock::before {\n        content: \"\\f293\";\n    }\n\n    .bi-cloud-arrow-down-fill::before {\n        content: \"\\f294\";\n    }\n\n    .bi-cloud-arrow-down::before {\n        content: \"\\f295\";\n    }\n\n    .bi-cloud-arrow-up-fill::before {\n        content: \"\\f296\";\n    }\n\n    .bi-cloud-arrow-up::before {\n        content: \"\\f297\";\n    }\n\n    .bi-cloud-check-fill::before {\n        content: \"\\f298\";\n    }\n\n    .bi-cloud-check::before {\n        content: \"\\f299\";\n    }\n\n    .bi-cloud-download-fill::before {\n        content: \"\\f29a\";\n    }\n\n    .bi-cloud-download::before {\n        content: \"\\f29b\";\n    }\n\n    .bi-cloud-drizzle-fill::before {\n        content: \"\\f29c\";\n    }\n\n    .bi-cloud-drizzle::before {\n        content: \"\\f29d\";\n    }\n\n    .bi-cloud-fill::before {\n        content: \"\\f29e\";\n    }\n\n    .bi-cloud-fog-fill::before {\n        content: \"\\f29f\";\n    }\n\n    .bi-cloud-fog::before {\n        content: \"\\f2a0\";\n    }\n\n    .bi-cloud-fog2-fill::before {\n        content: \"\\f2a1\";\n    }\n\n    .bi-cloud-fog2::before {\n        content: \"\\f2a2\";\n    }\n\n    .bi-cloud-hail-fill::before {\n        content: \"\\f2a3\";\n    }\n\n    .bi-cloud-hail::before {\n        content: \"\\f2a4\";\n    }\n\n    .bi-cloud-haze-fill::before {\n        content: \"\\f2a6\";\n    }\n\n    .bi-cloud-haze::before {\n        content: \"\\f2a7\";\n    }\n\n    .bi-cloud-haze2-fill::before {\n        content: \"\\f2a8\";\n    }\n\n    .bi-cloud-lightning-fill::before {\n        content: \"\\f2a9\";\n    }\n\n    .bi-cloud-lightning-rain-fill::before {\n        content: \"\\f2aa\";\n    }\n\n    .bi-cloud-lightning-rain::before {\n        content: \"\\f2ab\";\n    }\n\n    .bi-cloud-lightning::before {\n        content: \"\\f2ac\";\n    }\n\n    .bi-cloud-minus-fill::before {\n        content: \"\\f2ad\";\n    }\n\n    .bi-cloud-minus::before {\n        content: \"\\f2ae\";\n    }\n\n    .bi-cloud-moon-fill::before {\n        content: \"\\f2af\";\n    }\n\n    .bi-cloud-moon::before {\n        content: \"\\f2b0\";\n    }\n\n    .bi-cloud-plus-fill::before {\n        content: \"\\f2b1\";\n    }\n\n    .bi-cloud-plus::before {\n        content: \"\\f2b2\";\n    }\n\n    .bi-cloud-rain-fill::before {\n        content: \"\\f2b3\";\n    }\n\n    .bi-cloud-rain-heavy-fill::before {\n        content: \"\\f2b4\";\n    }\n\n    .bi-cloud-rain-heavy::before {\n        content: \"\\f2b5\";\n    }\n\n    .bi-cloud-rain::before {\n        content: \"\\f2b6\";\n    }\n\n    .bi-cloud-slash-fill::before {\n        content: \"\\f2b7\";\n    }\n\n    .bi-cloud-slash::before {\n        content: \"\\f2b8\";\n    }\n\n    .bi-cloud-sleet-fill::before {\n        content: \"\\f2b9\";\n    }\n\n    .bi-cloud-sleet::before {\n        content: \"\\f2ba\";\n    }\n\n    .bi-cloud-snow-fill::before {\n        content: \"\\f2bb\";\n    }\n\n    .bi-cloud-snow::before {\n        content: \"\\f2bc\";\n    }\n\n    .bi-cloud-sun-fill::before {\n        content: \"\\f2bd\";\n    }\n\n    .bi-cloud-sun::before {\n        content: \"\\f2be\";\n    }\n\n    .bi-cloud-upload-fill::before {\n        content: \"\\f2bf\";\n    }\n\n    .bi-cloud-upload::before {\n        content: \"\\f2c0\";\n    }\n\n    .bi-cloud::before {\n        content: \"\\f2c1\";\n    }\n\n    .bi-clouds-fill::before {\n        content: \"\\f2c2\";\n    }\n\n    .bi-clouds::before {\n        content: \"\\f2c3\";\n    }\n\n    .bi-cloudy-fill::before {\n        content: \"\\f2c4\";\n    }\n\n    .bi-cloudy::before {\n        content: \"\\f2c5\";\n    }\n\n    .bi-code-slash::before {\n        content: \"\\f2c6\";\n    }\n\n    .bi-code-square::before {\n        content: \"\\f2c7\";\n    }\n\n    .bi-code::before {\n        content: \"\\f2c8\";\n    }\n\n    .bi-collection-fill::before {\n        content: \"\\f2c9\";\n    }\n\n    .bi-collection-play-fill::before {\n        content: \"\\f2ca\";\n    }\n\n    .bi-collection-play::before {\n        content: \"\\f2cb\";\n    }\n\n    .bi-collection::before {\n        content: \"\\f2cc\";\n    }\n\n    .bi-columns-gap::before {\n        content: \"\\f2cd\";\n    }\n\n    .bi-columns::before {\n        content: \"\\f2ce\";\n    }\n\n    .bi-command::before {\n        content: \"\\f2cf\";\n    }\n\n    .bi-compass-fill::before {\n        content: \"\\f2d0\";\n    }\n\n    .bi-compass::before {\n        content: \"\\f2d1\";\n    }\n\n    .bi-cone-striped::before {\n        content: \"\\f2d2\";\n    }\n\n    .bi-cone::before {\n        content: \"\\f2d3\";\n    }\n\n    .bi-controller::before {\n        content: \"\\f2d4\";\n    }\n\n    .bi-cpu-fill::before {\n        content: \"\\f2d5\";\n    }\n\n    .bi-cpu::before {\n        content: \"\\f2d6\";\n    }\n\n    .bi-credit-card-2-back-fill::before {\n        content: \"\\f2d7\";\n    }\n\n    .bi-credit-card-2-back::before {\n        content: \"\\f2d8\";\n    }\n\n    .bi-credit-card-2-front-fill::before {\n        content: \"\\f2d9\";\n    }\n\n    .bi-credit-card-2-front::before {\n        content: \"\\f2da\";\n    }\n\n    .bi-credit-card-fill::before {\n        content: \"\\f2db\";\n    }\n\n    .bi-credit-card::before {\n        content: \"\\f2dc\";\n    }\n\n    .bi-crop::before {\n        content: \"\\f2dd\";\n    }\n\n    .bi-cup-fill::before {\n        content: \"\\f2de\";\n    }\n\n    .bi-cup-straw::before {\n        content: \"\\f2df\";\n    }\n\n    .bi-cup::before {\n        content: \"\\f2e0\";\n    }\n\n    .bi-cursor-fill::before {\n        content: \"\\f2e1\";\n    }\n\n    .bi-cursor-text::before {\n        content: \"\\f2e2\";\n    }\n\n    .bi-cursor::before {\n        content: \"\\f2e3\";\n    }\n\n    .bi-dash-circle-dotted::before {\n        content: \"\\f2e4\";\n    }\n\n    .bi-dash-circle-fill::before {\n        content: \"\\f2e5\";\n    }\n\n    .bi-dash-circle::before {\n        content: \"\\f2e6\";\n    }\n\n    .bi-dash-square-dotted::before {\n        content: \"\\f2e7\";\n    }\n\n    .bi-dash-square-fill::before {\n        content: \"\\f2e8\";\n    }\n\n    .bi-dash-square::before {\n        content: \"\\f2e9\";\n    }\n\n    .bi-dash::before {\n        content: \"\\f2ea\";\n    }\n\n    .bi-diagram-2-fill::before {\n        content: \"\\f2eb\";\n    }\n\n    .bi-diagram-2::before {\n        content: \"\\f2ec\";\n    }\n\n    .bi-diagram-3-fill::before {\n        content: \"\\f2ed\";\n    }\n\n    .bi-diagram-3::before {\n        content: \"\\f2ee\";\n    }\n\n    .bi-diamond-fill::before {\n        content: \"\\f2ef\";\n    }\n\n    .bi-diamond-half::before {\n        content: \"\\f2f0\";\n    }\n\n    .bi-diamond::before {\n        content: \"\\f2f1\";\n    }\n\n    .bi-dice-1-fill::before {\n        content: \"\\f2f2\";\n    }\n\n    .bi-dice-1::before {\n        content: \"\\f2f3\";\n    }\n\n    .bi-dice-2-fill::before {\n        content: \"\\f2f4\";\n    }\n\n    .bi-dice-2::before {\n        content: \"\\f2f5\";\n    }\n\n    .bi-dice-3-fill::before {\n        content: \"\\f2f6\";\n    }\n\n    .bi-dice-3::before {\n        content: \"\\f2f7\";\n    }\n\n    .bi-dice-4-fill::before {\n        content: \"\\f2f8\";\n    }\n\n    .bi-dice-4::before {\n        content: \"\\f2f9\";\n    }\n\n    .bi-dice-5-fill::before {\n        content: \"\\f2fa\";\n    }\n\n    .bi-dice-5::before {\n        content: \"\\f2fb\";\n    }\n\n    .bi-dice-6-fill::before {\n        content: \"\\f2fc\";\n    }\n\n    .bi-dice-6::before {\n        content: \"\\f2fd\";\n    }\n\n    .bi-disc-fill::before {\n        content: \"\\f2fe\";\n    }\n\n    .bi-disc::before {\n        content: \"\\f2ff\";\n    }\n\n    .bi-discord::before {\n        content: \"\\f300\";\n    }\n\n    .bi-display-fill::before {\n        content: \"\\f301\";\n    }\n\n    .bi-display::before {\n        content: \"\\f302\";\n    }\n\n    .bi-distribute-horizontal::before {\n        content: \"\\f303\";\n    }\n\n    .bi-distribute-vertical::before {\n        content: \"\\f304\";\n    }\n\n    .bi-door-closed-fill::before {\n        content: \"\\f305\";\n    }\n\n    .bi-door-closed::before {\n        content: \"\\f306\";\n    }\n\n    .bi-door-open-fill::before {\n        content: \"\\f307\";\n    }\n\n    .bi-door-open::before {\n        content: \"\\f308\";\n    }\n\n    .bi-dot::before {\n        content: \"\\f309\";\n    }\n\n    .bi-download::before {\n        content: \"\\f30a\";\n    }\n\n    .bi-droplet-fill::before {\n        content: \"\\f30b\";\n    }\n\n    .bi-droplet-half::before {\n        content: \"\\f30c\";\n    }\n\n    .bi-droplet::before {\n        content: \"\\f30d\";\n    }\n\n    .bi-earbuds::before {\n        content: \"\\f30e\";\n    }\n\n    .bi-easel-fill::before {\n        content: \"\\f30f\";\n    }\n\n    .bi-easel::before {\n        content: \"\\f310\";\n    }\n\n    .bi-egg-fill::before {\n        content: \"\\f311\";\n    }\n\n    .bi-egg-fried::before {\n        content: \"\\f312\";\n    }\n\n    .bi-egg::before {\n        content: \"\\f313\";\n    }\n\n    .bi-eject-fill::before {\n        content: \"\\f314\";\n    }\n\n    .bi-eject::before {\n        content: \"\\f315\";\n    }\n\n    .bi-emoji-angry-fill::before {\n        content: \"\\f316\";\n    }\n\n    .bi-emoji-angry::before {\n        content: \"\\f317\";\n    }\n\n    .bi-emoji-dizzy-fill::before {\n        content: \"\\f318\";\n    }\n\n    .bi-emoji-dizzy::before {\n        content: \"\\f319\";\n    }\n\n    .bi-emoji-expressionless-fill::before {\n        content: \"\\f31a\";\n    }\n\n    .bi-emoji-expressionless::before {\n        content: \"\\f31b\";\n    }\n\n    .bi-emoji-frown-fill::before {\n        content: \"\\f31c\";\n    }\n\n    .bi-emoji-frown::before {\n        content: \"\\f31d\";\n    }\n\n    .bi-emoji-heart-eyes-fill::before {\n        content: \"\\f31e\";\n    }\n\n    .bi-emoji-heart-eyes::before {\n        content: \"\\f31f\";\n    }\n\n    .bi-emoji-laughing-fill::before {\n        content: \"\\f320\";\n    }\n\n    .bi-emoji-laughing::before {\n        content: \"\\f321\";\n    }\n\n    .bi-emoji-neutral-fill::before {\n        content: \"\\f322\";\n    }\n\n    .bi-emoji-neutral::before {\n        content: \"\\f323\";\n    }\n\n    .bi-emoji-smile-fill::before {\n        content: \"\\f324\";\n    }\n\n    .bi-emoji-smile-upside-down-fill::before {\n        content: \"\\f325\";\n    }\n\n    .bi-emoji-smile-upside-down::before {\n        content: \"\\f326\";\n    }\n\n    .bi-emoji-smile::before {\n        content: \"\\f327\";\n    }\n\n    .bi-emoji-sunglasses-fill::before {\n        content: \"\\f328\";\n    }\n\n    .bi-emoji-sunglasses::before {\n        content: \"\\f329\";\n    }\n\n    .bi-emoji-wink-fill::before {\n        content: \"\\f32a\";\n    }\n\n    .bi-emoji-wink::before {\n        content: \"\\f32b\";\n    }\n\n    .bi-envelope-fill::before {\n        content: \"\\f32c\";\n    }\n\n    .bi-envelope-open-fill::before {\n        content: \"\\f32d\";\n    }\n\n    .bi-envelope-open::before {\n        content: \"\\f32e\";\n    }\n\n    .bi-envelope::before {\n        content: \"\\f32f\";\n    }\n\n    .bi-eraser-fill::before {\n        content: \"\\f330\";\n    }\n\n    .bi-eraser::before {\n        content: \"\\f331\";\n    }\n\n    .bi-exclamation-circle-fill::before {\n        content: \"\\f332\";\n    }\n\n    .bi-exclamation-circle::before {\n        content: \"\\f333\";\n    }\n\n    .bi-exclamation-diamond-fill::before {\n        content: \"\\f334\";\n    }\n\n    .bi-exclamation-diamond::before {\n        content: \"\\f335\";\n    }\n\n    .bi-exclamation-octagon-fill::before {\n        content: \"\\f336\";\n    }\n\n    .bi-exclamation-octagon::before {\n        content: \"\\f337\";\n    }\n\n    .bi-exclamation-square-fill::before {\n        content: \"\\f338\";\n    }\n\n    .bi-exclamation-square::before {\n        content: \"\\f339\";\n    }\n\n    .bi-exclamation-triangle-fill::before {\n        content: \"\\f33a\";\n    }\n\n    .bi-exclamation-triangle::before {\n        content: \"\\f33b\";\n    }\n\n    .bi-exclamation::before {\n        content: \"\\f33c\";\n    }\n\n    .bi-exclude::before {\n        content: \"\\f33d\";\n    }\n\n    .bi-eye-fill::before {\n        content: \"\\f33e\";\n    }\n\n    .bi-eye-slash-fill::before {\n        content: \"\\f33f\";\n    }\n\n    .bi-eye-slash::before {\n        content: \"\\f340\";\n    }\n\n    .bi-eye::before {\n        content: \"\\f341\";\n    }\n\n    .bi-eyedropper::before {\n        content: \"\\f342\";\n    }\n\n    .bi-eyeglasses::before {\n        content: \"\\f343\";\n    }\n\n    .bi-facebook::before {\n        content: \"\\f344\";\n    }\n\n    .bi-file-arrow-down-fill::before {\n        content: \"\\f345\";\n    }\n\n    .bi-file-arrow-down::before {\n        content: \"\\f346\";\n    }\n\n    .bi-file-arrow-up-fill::before {\n        content: \"\\f347\";\n    }\n\n    .bi-file-arrow-up::before {\n        content: \"\\f348\";\n    }\n\n    .bi-file-bar-graph-fill::before {\n        content: \"\\f349\";\n    }\n\n    .bi-file-bar-graph::before {\n        content: \"\\f34a\";\n    }\n\n    .bi-file-binary-fill::before {\n        content: \"\\f34b\";\n    }\n\n    .bi-file-binary::before {\n        content: \"\\f34c\";\n    }\n\n    .bi-file-break-fill::before {\n        content: \"\\f34d\";\n    }\n\n    .bi-file-break::before {\n        content: \"\\f34e\";\n    }\n\n    .bi-file-check-fill::before {\n        content: \"\\f34f\";\n    }\n\n    .bi-file-check::before {\n        content: \"\\f350\";\n    }\n\n    .bi-file-code-fill::before {\n        content: \"\\f351\";\n    }\n\n    .bi-file-code::before {\n        content: \"\\f352\";\n    }\n\n    .bi-file-diff-fill::before {\n        content: \"\\f353\";\n    }\n\n    .bi-file-diff::before {\n        content: \"\\f354\";\n    }\n\n    .bi-file-earmark-arrow-down-fill::before {\n        content: \"\\f355\";\n    }\n\n    .bi-file-earmark-arrow-down::before {\n        content: \"\\f356\";\n    }\n\n    .bi-file-earmark-arrow-up-fill::before {\n        content: \"\\f357\";\n    }\n\n    .bi-file-earmark-arrow-up::before {\n        content: \"\\f358\";\n    }\n\n    .bi-file-earmark-bar-graph-fill::before {\n        content: \"\\f359\";\n    }\n\n    .bi-file-earmark-bar-graph::before {\n        content: \"\\f35a\";\n    }\n\n    .bi-file-earmark-binary-fill::before {\n        content: \"\\f35b\";\n    }\n\n    .bi-file-earmark-binary::before {\n        content: \"\\f35c\";\n    }\n\n    .bi-file-earmark-break-fill::before {\n        content: \"\\f35d\";\n    }\n\n    .bi-file-earmark-break::before {\n        content: \"\\f35e\";\n    }\n\n    .bi-file-earmark-check-fill::before {\n        content: \"\\f35f\";\n    }\n\n    .bi-file-earmark-check::before {\n        content: \"\\f360\";\n    }\n\n    .bi-file-earmark-code-fill::before {\n        content: \"\\f361\";\n    }\n\n    .bi-file-earmark-code::before {\n        content: \"\\f362\";\n    }\n\n    .bi-file-earmark-diff-fill::before {\n        content: \"\\f363\";\n    }\n\n    .bi-file-earmark-diff::before {\n        content: \"\\f364\";\n    }\n\n    .bi-file-earmark-easel-fill::before {\n        content: \"\\f365\";\n    }\n\n    .bi-file-earmark-easel::before {\n        content: \"\\f366\";\n    }\n\n    .bi-file-earmark-excel-fill::before {\n        content: \"\\f367\";\n    }\n\n    .bi-file-earmark-excel::before {\n        content: \"\\f368\";\n    }\n\n    .bi-file-earmark-fill::before {\n        content: \"\\f369\";\n    }\n\n    .bi-file-earmark-font-fill::before {\n        content: \"\\f36a\";\n    }\n\n    .bi-file-earmark-font::before {\n        content: \"\\f36b\";\n    }\n\n    .bi-file-earmark-image-fill::before {\n        content: \"\\f36c\";\n    }\n\n    .bi-file-earmark-image::before {\n        content: \"\\f36d\";\n    }\n\n    .bi-file-earmark-lock-fill::before {\n        content: \"\\f36e\";\n    }\n\n    .bi-file-earmark-lock::before {\n        content: \"\\f36f\";\n    }\n\n    .bi-file-earmark-lock2-fill::before {\n        content: \"\\f370\";\n    }\n\n    .bi-file-earmark-lock2::before {\n        content: \"\\f371\";\n    }\n\n    .bi-file-earmark-medical-fill::before {\n        content: \"\\f372\";\n    }\n\n    .bi-file-earmark-medical::before {\n        content: \"\\f373\";\n    }\n\n    .bi-file-earmark-minus-fill::before {\n        content: \"\\f374\";\n    }\n\n    .bi-file-earmark-minus::before {\n        content: \"\\f375\";\n    }\n\n    .bi-file-earmark-music-fill::before {\n        content: \"\\f376\";\n    }\n\n    .bi-file-earmark-music::before {\n        content: \"\\f377\";\n    }\n\n    .bi-file-earmark-person-fill::before {\n        content: \"\\f378\";\n    }\n\n    .bi-file-earmark-person::before {\n        content: \"\\f379\";\n    }\n\n    .bi-file-earmark-play-fill::before {\n        content: \"\\f37a\";\n    }\n\n    .bi-file-earmark-play::before {\n        content: \"\\f37b\";\n    }\n\n    .bi-file-earmark-plus-fill::before {\n        content: \"\\f37c\";\n    }\n\n    .bi-file-earmark-plus::before {\n        content: \"\\f37d\";\n    }\n\n    .bi-file-earmark-post-fill::before {\n        content: \"\\f37e\";\n    }\n\n    .bi-file-earmark-post::before {\n        content: \"\\f37f\";\n    }\n\n    .bi-file-earmark-ppt-fill::before {\n        content: \"\\f380\";\n    }\n\n    .bi-file-earmark-ppt::before {\n        content: \"\\f381\";\n    }\n\n    .bi-file-earmark-richtext-fill::before {\n        content: \"\\f382\";\n    }\n\n    .bi-file-earmark-richtext::before {\n        content: \"\\f383\";\n    }\n\n    .bi-file-earmark-ruled-fill::before {\n        content: \"\\f384\";\n    }\n\n    .bi-file-earmark-ruled::before {\n        content: \"\\f385\";\n    }\n\n    .bi-file-earmark-slides-fill::before {\n        content: \"\\f386\";\n    }\n\n    .bi-file-earmark-slides::before {\n        content: \"\\f387\";\n    }\n\n    .bi-file-earmark-spreadsheet-fill::before {\n        content: \"\\f388\";\n    }\n\n    .bi-file-earmark-spreadsheet::before {\n        content: \"\\f389\";\n    }\n\n    .bi-file-earmark-text-fill::before {\n        content: \"\\f38a\";\n    }\n\n    .bi-file-earmark-text::before {\n        content: \"\\f38b\";\n    }\n\n    .bi-file-earmark-word-fill::before {\n        content: \"\\f38c\";\n    }\n\n    .bi-file-earmark-word::before {\n        content: \"\\f38d\";\n    }\n\n    .bi-file-earmark-x-fill::before {\n        content: \"\\f38e\";\n    }\n\n    .bi-file-earmark-x::before {\n        content: \"\\f38f\";\n    }\n\n    .bi-file-earmark-zip-fill::before {\n        content: \"\\f390\";\n    }\n\n    .bi-file-earmark-zip::before {\n        content: \"\\f391\";\n    }\n\n    .bi-file-earmark::before {\n        content: \"\\f392\";\n    }\n\n    .bi-file-easel-fill::before {\n        content: \"\\f393\";\n    }\n\n    .bi-file-easel::before {\n        content: \"\\f394\";\n    }\n\n    .bi-file-excel-fill::before {\n        content: \"\\f395\";\n    }\n\n    .bi-file-excel::before {\n        content: \"\\f396\";\n    }\n\n    .bi-file-fill::before {\n        content: \"\\f397\";\n    }\n\n    .bi-file-font-fill::before {\n        content: \"\\f398\";\n    }\n\n    .bi-file-font::before {\n        content: \"\\f399\";\n    }\n\n    .bi-file-image-fill::before {\n        content: \"\\f39a\";\n    }\n\n    .bi-file-image::before {\n        content: \"\\f39b\";\n    }\n\n    .bi-file-lock-fill::before {\n        content: \"\\f39c\";\n    }\n\n    .bi-file-lock::before {\n        content: \"\\f39d\";\n    }\n\n    .bi-file-lock2-fill::before {\n        content: \"\\f39e\";\n    }\n\n    .bi-file-lock2::before {\n        content: \"\\f39f\";\n    }\n\n    .bi-file-medical-fill::before {\n        content: \"\\f3a0\";\n    }\n\n    .bi-file-medical::before {\n        content: \"\\f3a1\";\n    }\n\n    .bi-file-minus-fill::before {\n        content: \"\\f3a2\";\n    }\n\n    .bi-file-minus::before {\n        content: \"\\f3a3\";\n    }\n\n    .bi-file-music-fill::before {\n        content: \"\\f3a4\";\n    }\n\n    .bi-file-music::before {\n        content: \"\\f3a5\";\n    }\n\n    .bi-file-person-fill::before {\n        content: \"\\f3a6\";\n    }\n\n    .bi-file-person::before {\n        content: \"\\f3a7\";\n    }\n\n    .bi-file-play-fill::before {\n        content: \"\\f3a8\";\n    }\n\n    .bi-file-play::before {\n        content: \"\\f3a9\";\n    }\n\n    .bi-file-plus-fill::before {\n        content: \"\\f3aa\";\n    }\n\n    .bi-file-plus::before {\n        content: \"\\f3ab\";\n    }\n\n    .bi-file-post-fill::before {\n        content: \"\\f3ac\";\n    }\n\n    .bi-file-post::before {\n        content: \"\\f3ad\";\n    }\n\n    .bi-file-ppt-fill::before {\n        content: \"\\f3ae\";\n    }\n\n    .bi-file-ppt::before {\n        content: \"\\f3af\";\n    }\n\n    .bi-file-richtext-fill::before {\n        content: \"\\f3b0\";\n    }\n\n    .bi-file-richtext::before {\n        content: \"\\f3b1\";\n    }\n\n    .bi-file-ruled-fill::before {\n        content: \"\\f3b2\";\n    }\n\n    .bi-file-ruled::before {\n        content: \"\\f3b3\";\n    }\n\n    .bi-file-slides-fill::before {\n        content: \"\\f3b4\";\n    }\n\n    .bi-file-slides::before {\n        content: \"\\f3b5\";\n    }\n\n    .bi-file-spreadsheet-fill::before {\n        content: \"\\f3b6\";\n    }\n\n    .bi-file-spreadsheet::before {\n        content: \"\\f3b7\";\n    }\n\n    .bi-file-text-fill::before {\n        content: \"\\f3b8\";\n    }\n\n    .bi-file-text::before {\n        content: \"\\f3b9\";\n    }\n\n    .bi-file-word-fill::before {\n        content: \"\\f3ba\";\n    }\n\n    .bi-file-word::before {\n        content: \"\\f3bb\";\n    }\n\n    .bi-file-x-fill::before {\n        content: \"\\f3bc\";\n    }\n\n    .bi-file-x::before {\n        content: \"\\f3bd\";\n    }\n\n    .bi-file-zip-fill::before {\n        content: \"\\f3be\";\n    }\n\n    .bi-file-zip::before {\n        content: \"\\f3bf\";\n    }\n\n    .bi-file::before {\n        content: \"\\f3c0\";\n    }\n\n    .bi-files-alt::before {\n        content: \"\\f3c1\";\n    }\n\n    .bi-files::before {\n        content: \"\\f3c2\";\n    }\n\n    .bi-film::before {\n        content: \"\\f3c3\";\n    }\n\n    .bi-filter-circle-fill::before {\n        content: \"\\f3c4\";\n    }\n\n    .bi-filter-circle::before {\n        content: \"\\f3c5\";\n    }\n\n    .bi-filter-left::before {\n        content: \"\\f3c6\";\n    }\n\n    .bi-filter-right::before {\n        content: \"\\f3c7\";\n    }\n\n    .bi-filter-square-fill::before {\n        content: \"\\f3c8\";\n    }\n\n    .bi-filter-square::before {\n        content: \"\\f3c9\";\n    }\n\n    .bi-filter::before {\n        content: \"\\f3ca\";\n    }\n\n    .bi-flag-fill::before {\n        content: \"\\f3cb\";\n    }\n\n    .bi-flag::before {\n        content: \"\\f3cc\";\n    }\n\n    .bi-flower1::before {\n        content: \"\\f3cd\";\n    }\n\n    .bi-flower2::before {\n        content: \"\\f3ce\";\n    }\n\n    .bi-flower3::before {\n        content: \"\\f3cf\";\n    }\n\n    .bi-folder-check::before {\n        content: \"\\f3d0\";\n    }\n\n    .bi-folder-fill::before {\n        content: \"\\f3d1\";\n    }\n\n    .bi-folder-minus::before {\n        content: \"\\f3d2\";\n    }\n\n    .bi-folder-plus::before {\n        content: \"\\f3d3\";\n    }\n\n    .bi-folder-symlink-fill::before {\n        content: \"\\f3d4\";\n    }\n\n    .bi-folder-symlink::before {\n        content: \"\\f3d5\";\n    }\n\n    .bi-folder-x::before {\n        content: \"\\f3d6\";\n    }\n\n    .bi-folder::before {\n        content: \"\\f3d7\";\n    }\n\n    .bi-folder2-open::before {\n        content: \"\\f3d8\";\n    }\n\n    .bi-folder2::before {\n        content: \"\\f3d9\";\n    }\n\n    .bi-fonts::before {\n        content: \"\\f3da\";\n    }\n\n    .bi-forward-fill::before {\n        content: \"\\f3db\";\n    }\n\n    .bi-forward::before {\n        content: \"\\f3dc\";\n    }\n\n    .bi-front::before {\n        content: \"\\f3dd\";\n    }\n\n    .bi-fullscreen-exit::before {\n        content: \"\\f3de\";\n    }\n\n    .bi-fullscreen::before {\n        content: \"\\f3df\";\n    }\n\n    .bi-funnel-fill::before {\n        content: \"\\f3e0\";\n    }\n\n    .bi-funnel::before {\n        content: \"\\f3e1\";\n    }\n\n    .bi-gear-fill::before {\n        content: \"\\f3e2\";\n    }\n\n    .bi-gear-wide-connected::before {\n        content: \"\\f3e3\";\n    }\n\n    .bi-gear-wide::before {\n        content: \"\\f3e4\";\n    }\n\n    .bi-gear::before {\n        content: \"\\f3e5\";\n    }\n\n    .bi-gem::before {\n        content: \"\\f3e6\";\n    }\n\n    .bi-geo-alt-fill::before {\n        content: \"\\f3e7\";\n    }\n\n    .bi-geo-alt::before {\n        content: \"\\f3e8\";\n    }\n\n    .bi-geo-fill::before {\n        content: \"\\f3e9\";\n    }\n\n    .bi-geo::before {\n        content: \"\\f3ea\";\n    }\n\n    .bi-gift-fill::before {\n        content: \"\\f3eb\";\n    }\n\n    .bi-gift::before {\n        content: \"\\f3ec\";\n    }\n\n    .bi-github::before {\n        content: \"\\f3ed\";\n    }\n\n    .bi-globe::before {\n        content: \"\\f3ee\";\n    }\n\n    .bi-globe2::before {\n        content: \"\\f3ef\";\n    }\n\n    .bi-google::before {\n        content: \"\\f3f0\";\n    }\n\n    .bi-graph-down::before {\n        content: \"\\f3f1\";\n    }\n\n    .bi-graph-up::before {\n        content: \"\\f3f2\";\n    }\n\n    .bi-grid-1x2-fill::before {\n        content: \"\\f3f3\";\n    }\n\n    .bi-grid-1x2::before {\n        content: \"\\f3f4\";\n    }\n\n    .bi-grid-3x2-gap-fill::before {\n        content: \"\\f3f5\";\n    }\n\n    .bi-grid-3x2-gap::before {\n        content: \"\\f3f6\";\n    }\n\n    .bi-grid-3x2::before {\n        content: \"\\f3f7\";\n    }\n\n    .bi-grid-3x3-gap-fill::before {\n        content: \"\\f3f8\";\n    }\n\n    .bi-grid-3x3-gap::before {\n        content: \"\\f3f9\";\n    }\n\n    .bi-grid-3x3::before {\n        content: \"\\f3fa\";\n    }\n\n    .bi-grid-fill::before {\n        content: \"\\f3fb\";\n    }\n\n    .bi-grid::before {\n        content: \"\\f3fc\";\n    }\n\n    .bi-grip-horizontal::before {\n        content: \"\\f3fd\";\n    }\n\n    .bi-grip-vertical::before {\n        content: \"\\f3fe\";\n    }\n\n    .bi-hammer::before {\n        content: \"\\f3ff\";\n    }\n\n    .bi-hand-index-fill::before {\n        content: \"\\f400\";\n    }\n\n    .bi-hand-index-thumb-fill::before {\n        content: \"\\f401\";\n    }\n\n    .bi-hand-index-thumb::before {\n        content: \"\\f402\";\n    }\n\n    .bi-hand-index::before {\n        content: \"\\f403\";\n    }\n\n    .bi-hand-thumbs-down-fill::before {\n        content: \"\\f404\";\n    }\n\n    .bi-hand-thumbs-down::before {\n        content: \"\\f405\";\n    }\n\n    .bi-hand-thumbs-up-fill::before {\n        content: \"\\f406\";\n    }\n\n    .bi-hand-thumbs-up::before {\n        content: \"\\f407\";\n    }\n\n    .bi-handbag-fill::before {\n        content: \"\\f408\";\n    }\n\n    .bi-handbag::before {\n        content: \"\\f409\";\n    }\n\n    .bi-hash::before {\n        content: \"\\f40a\";\n    }\n\n    .bi-hdd-fill::before {\n        content: \"\\f40b\";\n    }\n\n    .bi-hdd-network-fill::before {\n        content: \"\\f40c\";\n    }\n\n    .bi-hdd-network::before {\n        content: \"\\f40d\";\n    }\n\n    .bi-hdd-rack-fill::before {\n        content: \"\\f40e\";\n    }\n\n    .bi-hdd-rack::before {\n        content: \"\\f40f\";\n    }\n\n    .bi-hdd-stack-fill::before {\n        content: \"\\f410\";\n    }\n\n    .bi-hdd-stack::before {\n        content: \"\\f411\";\n    }\n\n    .bi-hdd::before {\n        content: \"\\f412\";\n    }\n\n    .bi-headphones::before {\n        content: \"\\f413\";\n    }\n\n    .bi-headset::before {\n        content: \"\\f414\";\n    }\n\n    .bi-heart-fill::before {\n        content: \"\\f415\";\n    }\n\n    .bi-heart-half::before {\n        content: \"\\f416\";\n    }\n\n    .bi-heart::before {\n        content: \"\\f417\";\n    }\n\n    .bi-heptagon-fill::before {\n        content: \"\\f418\";\n    }\n\n    .bi-heptagon-half::before {\n        content: \"\\f419\";\n    }\n\n    .bi-heptagon::before {\n        content: \"\\f41a\";\n    }\n\n    .bi-hexagon-fill::before {\n        content: \"\\f41b\";\n    }\n\n    .bi-hexagon-half::before {\n        content: \"\\f41c\";\n    }\n\n    .bi-hexagon::before {\n        content: \"\\f41d\";\n    }\n\n    .bi-hourglass-bottom::before {\n        content: \"\\f41e\";\n    }\n\n    .bi-hourglass-split::before {\n        content: \"\\f41f\";\n    }\n\n    .bi-hourglass-top::before {\n        content: \"\\f420\";\n    }\n\n    .bi-hourglass::before {\n        content: \"\\f421\";\n    }\n\n    .bi-house-door-fill::before {\n        content: \"\\f422\";\n    }\n\n    .bi-house-door::before {\n        content: \"\\f423\";\n    }\n\n    .bi-house-fill::before {\n        content: \"\\f424\";\n    }\n\n    .bi-house::before {\n        content: \"\\f425\";\n    }\n\n    .bi-hr::before {\n        content: \"\\f426\";\n    }\n\n    .bi-hurricane::before {\n        content: \"\\f427\";\n    }\n\n    .bi-image-alt::before {\n        content: \"\\f428\";\n    }\n\n    .bi-image-fill::before {\n        content: \"\\f429\";\n    }\n\n    .bi-image::before {\n        content: \"\\f42a\";\n    }\n\n    .bi-images::before {\n        content: \"\\f42b\";\n    }\n\n    .bi-inbox-fill::before {\n        content: \"\\f42c\";\n    }\n\n    .bi-inbox::before {\n        content: \"\\f42d\";\n    }\n\n    .bi-inboxes-fill::before {\n        content: \"\\f42e\";\n    }\n\n    .bi-inboxes::before {\n        content: \"\\f42f\";\n    }\n\n    .bi-info-circle-fill::before {\n        content: \"\\f430\";\n    }\n\n    .bi-info-circle::before {\n        content: \"\\f431\";\n    }\n\n    .bi-info-square-fill::before {\n        content: \"\\f432\";\n    }\n\n    .bi-info-square::before {\n        content: \"\\f433\";\n    }\n\n    .bi-info::before {\n        content: \"\\f434\";\n    }\n\n    .bi-input-cursor-text::before {\n        content: \"\\f435\";\n    }\n\n    .bi-input-cursor::before {\n        content: \"\\f436\";\n    }\n\n    .bi-instagram::before {\n        content: \"\\f437\";\n    }\n\n    .bi-intersect::before {\n        content: \"\\f438\";\n    }\n\n    .bi-journal-album::before {\n        content: \"\\f439\";\n    }\n\n    .bi-journal-arrow-down::before {\n        content: \"\\f43a\";\n    }\n\n    .bi-journal-arrow-up::before {\n        content: \"\\f43b\";\n    }\n\n    .bi-journal-bookmark-fill::before {\n        content: \"\\f43c\";\n    }\n\n    .bi-journal-bookmark::before {\n        content: \"\\f43d\";\n    }\n\n    .bi-journal-check::before {\n        content: \"\\f43e\";\n    }\n\n    .bi-journal-code::before {\n        content: \"\\f43f\";\n    }\n\n    .bi-journal-medical::before {\n        content: \"\\f440\";\n    }\n\n    .bi-journal-minus::before {\n        content: \"\\f441\";\n    }\n\n    .bi-journal-plus::before {\n        content: \"\\f442\";\n    }\n\n    .bi-journal-richtext::before {\n        content: \"\\f443\";\n    }\n\n    .bi-journal-text::before {\n        content: \"\\f444\";\n    }\n\n    .bi-journal-x::before {\n        content: \"\\f445\";\n    }\n\n    .bi-journal::before {\n        content: \"\\f446\";\n    }\n\n    .bi-journals::before {\n        content: \"\\f447\";\n    }\n\n    .bi-joystick::before {\n        content: \"\\f448\";\n    }\n\n    .bi-justify-left::before {\n        content: \"\\f449\";\n    }\n\n    .bi-justify-right::before {\n        content: \"\\f44a\";\n    }\n\n    .bi-justify::before {\n        content: \"\\f44b\";\n    }\n\n    .bi-kanban-fill::before {\n        content: \"\\f44c\";\n    }\n\n    .bi-kanban::before {\n        content: \"\\f44d\";\n    }\n\n    .bi-key-fill::before {\n        content: \"\\f44e\";\n    }\n\n    .bi-key::before {\n        content: \"\\f44f\";\n    }\n\n    .bi-keyboard-fill::before {\n        content: \"\\f450\";\n    }\n\n    .bi-keyboard::before {\n        content: \"\\f451\";\n    }\n\n    .bi-ladder::before {\n        content: \"\\f452\";\n    }\n\n    .bi-lamp-fill::before {\n        content: \"\\f453\";\n    }\n\n    .bi-lamp::before {\n        content: \"\\f454\";\n    }\n\n    .bi-laptop-fill::before {\n        content: \"\\f455\";\n    }\n\n    .bi-laptop::before {\n        content: \"\\f456\";\n    }\n\n    .bi-layer-backward::before {\n        content: \"\\f457\";\n    }\n\n    .bi-layer-forward::before {\n        content: \"\\f458\";\n    }\n\n    .bi-layers-fill::before {\n        content: \"\\f459\";\n    }\n\n    .bi-layers-half::before {\n        content: \"\\f45a\";\n    }\n\n    .bi-layers::before {\n        content: \"\\f45b\";\n    }\n\n    .bi-layout-sidebar-inset-reverse::before {\n        content: \"\\f45c\";\n    }\n\n    .bi-layout-sidebar-inset::before {\n        content: \"\\f45d\";\n    }\n\n    .bi-layout-sidebar-reverse::before {\n        content: \"\\f45e\";\n    }\n\n    .bi-layout-sidebar::before {\n        content: \"\\f45f\";\n    }\n\n    .bi-layout-split::before {\n        content: \"\\f460\";\n    }\n\n    .bi-layout-text-sidebar-reverse::before {\n        content: \"\\f461\";\n    }\n\n    .bi-layout-text-sidebar::before {\n        content: \"\\f462\";\n    }\n\n    .bi-layout-text-window-reverse::before {\n        content: \"\\f463\";\n    }\n\n    .bi-layout-text-window::before {\n        content: \"\\f464\";\n    }\n\n    .bi-layout-three-columns::before {\n        content: \"\\f465\";\n    }\n\n    .bi-layout-wtf::before {\n        content: \"\\f466\";\n    }\n\n    .bi-life-preserver::before {\n        content: \"\\f467\";\n    }\n\n    .bi-lightbulb-fill::before {\n        content: \"\\f468\";\n    }\n\n    .bi-lightbulb-off-fill::before {\n        content: \"\\f469\";\n    }\n\n    .bi-lightbulb-off::before {\n        content: \"\\f46a\";\n    }\n\n    .bi-lightbulb::before {\n        content: \"\\f46b\";\n    }\n\n    .bi-lightning-charge-fill::before {\n        content: \"\\f46c\";\n    }\n\n    .bi-lightning-charge::before {\n        content: \"\\f46d\";\n    }\n\n    .bi-lightning-fill::before {\n        content: \"\\f46e\";\n    }\n\n    .bi-lightning::before {\n        content: \"\\f46f\";\n    }\n\n    .bi-link-45deg::before {\n        content: \"\\f470\";\n    }\n\n    .bi-link::before {\n        content: \"\\f471\";\n    }\n\n    .bi-linkedin::before {\n        content: \"\\f472\";\n    }\n\n    .bi-list-check::before {\n        content: \"\\f473\";\n    }\n\n    .bi-list-nested::before {\n        content: \"\\f474\";\n    }\n\n    .bi-list-ol::before {\n        content: \"\\f475\";\n    }\n\n    .bi-list-stars::before {\n        content: \"\\f476\";\n    }\n\n    .bi-list-task::before {\n        content: \"\\f477\";\n    }\n\n    .bi-list-ul::before {\n        content: \"\\f478\";\n    }\n\n    .bi-list::before {\n        content: \"\\f479\";\n    }\n\n    .bi-lock-fill::before {\n        content: \"\\f47a\";\n    }\n\n    .bi-lock::before {\n        content: \"\\f47b\";\n    }\n\n    .bi-mailbox::before {\n        content: \"\\f47c\";\n    }\n\n    .bi-mailbox2::before {\n        content: \"\\f47d\";\n    }\n\n    .bi-map-fill::before {\n        content: \"\\f47e\";\n    }\n\n    .bi-map::before {\n        content: \"\\f47f\";\n    }\n\n    .bi-markdown-fill::before {\n        content: \"\\f480\";\n    }\n\n    .bi-markdown::before {\n        content: \"\\f481\";\n    }\n\n    .bi-mask::before {\n        content: \"\\f482\";\n    }\n\n    .bi-megaphone-fill::before {\n        content: \"\\f483\";\n    }\n\n    .bi-megaphone::before {\n        content: \"\\f484\";\n    }\n\n    .bi-menu-app-fill::before {\n        content: \"\\f485\";\n    }\n\n    .bi-menu-app::before {\n        content: \"\\f486\";\n    }\n\n    .bi-menu-button-fill::before {\n        content: \"\\f487\";\n    }\n\n    .bi-menu-button-wide-fill::before {\n        content: \"\\f488\";\n    }\n\n    .bi-menu-button-wide::before {\n        content: \"\\f489\";\n    }\n\n    .bi-menu-button::before {\n        content: \"\\f48a\";\n    }\n\n    .bi-menu-down::before {\n        content: \"\\f48b\";\n    }\n\n    .bi-menu-up::before {\n        content: \"\\f48c\";\n    }\n\n    .bi-mic-fill::before {\n        content: \"\\f48d\";\n    }\n\n    .bi-mic-mute-fill::before {\n        content: \"\\f48e\";\n    }\n\n    .bi-mic-mute::before {\n        content: \"\\f48f\";\n    }\n\n    .bi-mic::before {\n        content: \"\\f490\";\n    }\n\n    .bi-minecart-loaded::before {\n        content: \"\\f491\";\n    }\n\n    .bi-minecart::before {\n        content: \"\\f492\";\n    }\n\n    .bi-moisture::before {\n        content: \"\\f493\";\n    }\n\n    .bi-moon-fill::before {\n        content: \"\\f494\";\n    }\n\n    .bi-moon-stars-fill::before {\n        content: \"\\f495\";\n    }\n\n    .bi-moon-stars::before {\n        content: \"\\f496\";\n    }\n\n    .bi-moon::before {\n        content: \"\\f497\";\n    }\n\n    .bi-mouse-fill::before {\n        content: \"\\f498\";\n    }\n\n    .bi-mouse::before {\n        content: \"\\f499\";\n    }\n\n    .bi-mouse2-fill::before {\n        content: \"\\f49a\";\n    }\n\n    .bi-mouse2::before {\n        content: \"\\f49b\";\n    }\n\n    .bi-mouse3-fill::before {\n        content: \"\\f49c\";\n    }\n\n    .bi-mouse3::before {\n        content: \"\\f49d\";\n    }\n\n    .bi-music-note-beamed::before {\n        content: \"\\f49e\";\n    }\n\n    .bi-music-note-list::before {\n        content: \"\\f49f\";\n    }\n\n    .bi-music-note::before {\n        content: \"\\f4a0\";\n    }\n\n    .bi-music-player-fill::before {\n        content: \"\\f4a1\";\n    }\n\n    .bi-music-player::before {\n        content: \"\\f4a2\";\n    }\n\n    .bi-newspaper::before {\n        content: \"\\f4a3\";\n    }\n\n    .bi-node-minus-fill::before {\n        content: \"\\f4a4\";\n    }\n\n    .bi-node-minus::before {\n        content: \"\\f4a5\";\n    }\n\n    .bi-node-plus-fill::before {\n        content: \"\\f4a6\";\n    }\n\n    .bi-node-plus::before {\n        content: \"\\f4a7\";\n    }\n\n    .bi-nut-fill::before {\n        content: \"\\f4a8\";\n    }\n\n    .bi-nut::before {\n        content: \"\\f4a9\";\n    }\n\n    .bi-octagon-fill::before {\n        content: \"\\f4aa\";\n    }\n\n    .bi-octagon-half::before {\n        content: \"\\f4ab\";\n    }\n\n    .bi-octagon::before {\n        content: \"\\f4ac\";\n    }\n\n    .bi-option::before {\n        content: \"\\f4ad\";\n    }\n\n    .bi-outlet::before {\n        content: \"\\f4ae\";\n    }\n\n    .bi-paint-bucket::before {\n        content: \"\\f4af\";\n    }\n\n    .bi-palette-fill::before {\n        content: \"\\f4b0\";\n    }\n\n    .bi-palette::before {\n        content: \"\\f4b1\";\n    }\n\n    .bi-palette2::before {\n        content: \"\\f4b2\";\n    }\n\n    .bi-paperclip::before {\n        content: \"\\f4b3\";\n    }\n\n    .bi-paragraph::before {\n        content: \"\\f4b4\";\n    }\n\n    .bi-patch-check-fill::before {\n        content: \"\\f4b5\";\n    }\n\n    .bi-patch-check::before {\n        content: \"\\f4b6\";\n    }\n\n    .bi-patch-exclamation-fill::before {\n        content: \"\\f4b7\";\n    }\n\n    .bi-patch-exclamation::before {\n        content: \"\\f4b8\";\n    }\n\n    .bi-patch-minus-fill::before {\n        content: \"\\f4b9\";\n    }\n\n    .bi-patch-minus::before {\n        content: \"\\f4ba\";\n    }\n\n    .bi-patch-plus-fill::before {\n        content: \"\\f4bb\";\n    }\n\n    .bi-patch-plus::before {\n        content: \"\\f4bc\";\n    }\n\n    .bi-patch-question-fill::before {\n        content: \"\\f4bd\";\n    }\n\n    .bi-patch-question::before {\n        content: \"\\f4be\";\n    }\n\n    .bi-pause-btn-fill::before {\n        content: \"\\f4bf\";\n    }\n\n    .bi-pause-btn::before {\n        content: \"\\f4c0\";\n    }\n\n    .bi-pause-circle-fill::before {\n        content: \"\\f4c1\";\n    }\n\n    .bi-pause-circle::before {\n        content: \"\\f4c2\";\n    }\n\n    .bi-pause-fill::before {\n        content: \"\\f4c3\";\n    }\n\n    .bi-pause::before {\n        content: \"\\f4c4\";\n    }\n\n    .bi-peace-fill::before {\n        content: \"\\f4c5\";\n    }\n\n    .bi-peace::before {\n        content: \"\\f4c6\";\n    }\n\n    .bi-pen-fill::before {\n        content: \"\\f4c7\";\n    }\n\n    .bi-pen::before {\n        content: \"\\f4c8\";\n    }\n\n    .bi-pencil-fill::before {\n        content: \"\\f4c9\";\n    }\n\n    .bi-pencil-square::before {\n        content: \"\\f4ca\";\n    }\n\n    .bi-pencil::before {\n        content: \"\\f4cb\";\n    }\n\n    .bi-pentagon-fill::before {\n        content: \"\\f4cc\";\n    }\n\n    .bi-pentagon-half::before {\n        content: \"\\f4cd\";\n    }\n\n    .bi-pentagon::before {\n        content: \"\\f4ce\";\n    }\n\n    .bi-people-fill::before {\n        content: \"\\f4cf\";\n    }\n\n    .bi-people::before {\n        content: \"\\f4d0\";\n    }\n\n    .bi-percent::before {\n        content: \"\\f4d1\";\n    }\n\n    .bi-person-badge-fill::before {\n        content: \"\\f4d2\";\n    }\n\n    .bi-person-badge::before {\n        content: \"\\f4d3\";\n    }\n\n    .bi-person-bounding-box::before {\n        content: \"\\f4d4\";\n    }\n\n    .bi-person-check-fill::before {\n        content: \"\\f4d5\";\n    }\n\n    .bi-person-check::before {\n        content: \"\\f4d6\";\n    }\n\n    .bi-person-circle::before {\n        content: \"\\f4d7\";\n    }\n\n    .bi-person-dash-fill::before {\n        content: \"\\f4d8\";\n    }\n\n    .bi-person-dash::before {\n        content: \"\\f4d9\";\n    }\n\n    .bi-person-fill::before {\n        content: \"\\f4da\";\n    }\n\n    .bi-person-lines-fill::before {\n        content: \"\\f4db\";\n    }\n\n    .bi-person-plus-fill::before {\n        content: \"\\f4dc\";\n    }\n\n    .bi-person-plus::before {\n        content: \"\\f4dd\";\n    }\n\n    .bi-person-square::before {\n        content: \"\\f4de\";\n    }\n\n    .bi-person-x-fill::before {\n        content: \"\\f4df\";\n    }\n\n    .bi-person-x::before {\n        content: \"\\f4e0\";\n    }\n\n    .bi-person::before {\n        content: \"\\f4e1\";\n    }\n\n    .bi-phone-fill::before {\n        content: \"\\f4e2\";\n    }\n\n    .bi-phone-landscape-fill::before {\n        content: \"\\f4e3\";\n    }\n\n    .bi-phone-landscape::before {\n        content: \"\\f4e4\";\n    }\n\n    .bi-phone-vibrate-fill::before {\n        content: \"\\f4e5\";\n    }\n\n    .bi-phone-vibrate::before {\n        content: \"\\f4e6\";\n    }\n\n    .bi-phone::before {\n        content: \"\\f4e7\";\n    }\n\n    .bi-pie-chart-fill::before {\n        content: \"\\f4e8\";\n    }\n\n    .bi-pie-chart::before {\n        content: \"\\f4e9\";\n    }\n\n    .bi-pin-angle-fill::before {\n        content: \"\\f4ea\";\n    }\n\n    .bi-pin-angle::before {\n        content: \"\\f4eb\";\n    }\n\n    .bi-pin-fill::before {\n        content: \"\\f4ec\";\n    }\n\n    .bi-pin::before {\n        content: \"\\f4ed\";\n    }\n\n    .bi-pip-fill::before {\n        content: \"\\f4ee\";\n    }\n\n    .bi-pip::before {\n        content: \"\\f4ef\";\n    }\n\n    .bi-play-btn-fill::before {\n        content: \"\\f4f0\";\n    }\n\n    .bi-play-btn::before {\n        content: \"\\f4f1\";\n    }\n\n    .bi-play-circle-fill::before {\n        content: \"\\f4f2\";\n    }\n\n    .bi-play-circle::before {\n        content: \"\\f4f3\";\n    }\n\n    .bi-play-fill::before {\n        content: \"\\f4f4\";\n    }\n\n    .bi-play::before {\n        content: \"\\f4f5\";\n    }\n\n    .bi-plug-fill::before {\n        content: \"\\f4f6\";\n    }\n\n    .bi-plug::before {\n        content: \"\\f4f7\";\n    }\n\n    .bi-plus-circle-dotted::before {\n        content: \"\\f4f8\";\n    }\n\n    .bi-plus-circle-fill::before {\n        content: \"\\f4f9\";\n    }\n\n    .bi-plus-circle::before {\n        content: \"\\f4fa\";\n    }\n\n    .bi-plus-square-dotted::before {\n        content: \"\\f4fb\";\n    }\n\n    .bi-plus-square-fill::before {\n        content: \"\\f4fc\";\n    }\n\n    .bi-plus-square::before {\n        content: \"\\f4fd\";\n    }\n\n    .bi-plus::before {\n        content: \"\\f4fe\";\n    }\n\n    .bi-power::before {\n        content: \"\\f4ff\";\n    }\n\n    .bi-printer-fill::before {\n        content: \"\\f500\";\n    }\n\n    .bi-printer::before {\n        content: \"\\f501\";\n    }\n\n    .bi-puzzle-fill::before {\n        content: \"\\f502\";\n    }\n\n    .bi-puzzle::before {\n        content: \"\\f503\";\n    }\n\n    .bi-question-circle-fill::before {\n        content: \"\\f504\";\n    }\n\n    .bi-question-circle::before {\n        content: \"\\f505\";\n    }\n\n    .bi-question-diamond-fill::before {\n        content: \"\\f506\";\n    }\n\n    .bi-question-diamond::before {\n        content: \"\\f507\";\n    }\n\n    .bi-question-octagon-fill::before {\n        content: \"\\f508\";\n    }\n\n    .bi-question-octagon::before {\n        content: \"\\f509\";\n    }\n\n    .bi-question-square-fill::before {\n        content: \"\\f50a\";\n    }\n\n    .bi-question-square::before {\n        content: \"\\f50b\";\n    }\n\n    .bi-question::before {\n        content: \"\\f50c\";\n    }\n\n    .bi-rainbow::before {\n        content: \"\\f50d\";\n    }\n\n    .bi-receipt-cutoff::before {\n        content: \"\\f50e\";\n    }\n\n    .bi-receipt::before {\n        content: \"\\f50f\";\n    }\n\n    .bi-reception-0::before {\n        content: \"\\f510\";\n    }\n\n    .bi-reception-1::before {\n        content: \"\\f511\";\n    }\n\n    .bi-reception-2::before {\n        content: \"\\f512\";\n    }\n\n    .bi-reception-3::before {\n        content: \"\\f513\";\n    }\n\n    .bi-reception-4::before {\n        content: \"\\f514\";\n    }\n\n    .bi-record-btn-fill::before {\n        content: \"\\f515\";\n    }\n\n    .bi-record-btn::before {\n        content: \"\\f516\";\n    }\n\n    .bi-record-circle-fill::before {\n        content: \"\\f517\";\n    }\n\n    .bi-record-circle::before {\n        content: \"\\f518\";\n    }\n\n    .bi-record-fill::before {\n        content: \"\\f519\";\n    }\n\n    .bi-record::before {\n        content: \"\\f51a\";\n    }\n\n    .bi-record2-fill::before {\n        content: \"\\f51b\";\n    }\n\n    .bi-record2::before {\n        content: \"\\f51c\";\n    }\n\n    .bi-reply-all-fill::before {\n        content: \"\\f51d\";\n    }\n\n    .bi-reply-all::before {\n        content: \"\\f51e\";\n    }\n\n    .bi-reply-fill::before {\n        content: \"\\f51f\";\n    }\n\n    .bi-reply::before {\n        content: \"\\f520\";\n    }\n\n    .bi-rss-fill::before {\n        content: \"\\f521\";\n    }\n\n    .bi-rss::before {\n        content: \"\\f522\";\n    }\n\n    .bi-rulers::before {\n        content: \"\\f523\";\n    }\n\n    .bi-save-fill::before {\n        content: \"\\f524\";\n    }\n\n    .bi-save::before {\n        content: \"\\f525\";\n    }\n\n    .bi-save2-fill::before {\n        content: \"\\f526\";\n    }\n\n    .bi-save2::before {\n        content: \"\\f527\";\n    }\n\n    .bi-scissors::before {\n        content: \"\\f528\";\n    }\n\n    .bi-screwdriver::before {\n        content: \"\\f529\";\n    }\n\n    .bi-search::before {\n        content: \"\\f52a\";\n    }\n\n    .bi-segmented-nav::before {\n        content: \"\\f52b\";\n    }\n\n    .bi-server::before {\n        content: \"\\f52c\";\n    }\n\n    .bi-share-fill::before {\n        content: \"\\f52d\";\n    }\n\n    .bi-share::before {\n        content: \"\\f52e\";\n    }\n\n    .bi-shield-check::before {\n        content: \"\\f52f\";\n    }\n\n    .bi-shield-exclamation::before {\n        content: \"\\f530\";\n    }\n\n    .bi-shield-fill-check::before {\n        content: \"\\f531\";\n    }\n\n    .bi-shield-fill-exclamation::before {\n        content: \"\\f532\";\n    }\n\n    .bi-shield-fill-minus::before {\n        content: \"\\f533\";\n    }\n\n    .bi-shield-fill-plus::before {\n        content: \"\\f534\";\n    }\n\n    .bi-shield-fill-x::before {\n        content: \"\\f535\";\n    }\n\n    .bi-shield-fill::before {\n        content: \"\\f536\";\n    }\n\n    .bi-shield-lock-fill::before {\n        content: \"\\f537\";\n    }\n\n    .bi-shield-lock::before {\n        content: \"\\f538\";\n    }\n\n    .bi-shield-minus::before {\n        content: \"\\f539\";\n    }\n\n    .bi-shield-plus::before {\n        content: \"\\f53a\";\n    }\n\n    .bi-shield-shaded::before {\n        content: \"\\f53b\";\n    }\n\n    .bi-shield-slash-fill::before {\n        content: \"\\f53c\";\n    }\n\n    .bi-shield-slash::before {\n        content: \"\\f53d\";\n    }\n\n    .bi-shield-x::before {\n        content: \"\\f53e\";\n    }\n\n    .bi-shield::before {\n        content: \"\\f53f\";\n    }\n\n    .bi-shift-fill::before {\n        content: \"\\f540\";\n    }\n\n    .bi-shift::before {\n        content: \"\\f541\";\n    }\n\n    .bi-shop-window::before {\n        content: \"\\f542\";\n    }\n\n    .bi-shop::before {\n        content: \"\\f543\";\n    }\n\n    .bi-shuffle::before {\n        content: \"\\f544\";\n    }\n\n    .bi-signpost-2-fill::before {\n        content: \"\\f545\";\n    }\n\n    .bi-signpost-2::before {\n        content: \"\\f546\";\n    }\n\n    .bi-signpost-fill::before {\n        content: \"\\f547\";\n    }\n\n    .bi-signpost-split-fill::before {\n        content: \"\\f548\";\n    }\n\n    .bi-signpost-split::before {\n        content: \"\\f549\";\n    }\n\n    .bi-signpost::before {\n        content: \"\\f54a\";\n    }\n\n    .bi-sim-fill::before {\n        content: \"\\f54b\";\n    }\n\n    .bi-sim::before {\n        content: \"\\f54c\";\n    }\n\n    .bi-skip-backward-btn-fill::before {\n        content: \"\\f54d\";\n    }\n\n    .bi-skip-backward-btn::before {\n        content: \"\\f54e\";\n    }\n\n    .bi-skip-backward-circle-fill::before {\n        content: \"\\f54f\";\n    }\n\n    .bi-skip-backward-circle::before {\n        content: \"\\f550\";\n    }\n\n    .bi-skip-backward-fill::before {\n        content: \"\\f551\";\n    }\n\n    .bi-skip-backward::before {\n        content: \"\\f552\";\n    }\n\n    .bi-skip-end-btn-fill::before {\n        content: \"\\f553\";\n    }\n\n    .bi-skip-end-btn::before {\n        content: \"\\f554\";\n    }\n\n    .bi-skip-end-circle-fill::before {\n        content: \"\\f555\";\n    }\n\n    .bi-skip-end-circle::before {\n        content: \"\\f556\";\n    }\n\n    .bi-skip-end-fill::before {\n        content: \"\\f557\";\n    }\n\n    .bi-skip-end::before {\n        content: \"\\f558\";\n    }\n\n    .bi-skip-forward-btn-fill::before {\n        content: \"\\f559\";\n    }\n\n    .bi-skip-forward-btn::before {\n        content: \"\\f55a\";\n    }\n\n    .bi-skip-forward-circle-fill::before {\n        content: \"\\f55b\";\n    }\n\n    .bi-skip-forward-circle::before {\n        content: \"\\f55c\";\n    }\n\n    .bi-skip-forward-fill::before {\n        content: \"\\f55d\";\n    }\n\n    .bi-skip-forward::before {\n        content: \"\\f55e\";\n    }\n\n    .bi-skip-start-btn-fill::before {\n        content: \"\\f55f\";\n    }\n\n    .bi-skip-start-btn::before {\n        content: \"\\f560\";\n    }\n\n    .bi-skip-start-circle-fill::before {\n        content: \"\\f561\";\n    }\n\n    .bi-skip-start-circle::before {\n        content: \"\\f562\";\n    }\n\n    .bi-skip-start-fill::before {\n        content: \"\\f563\";\n    }\n\n    .bi-skip-start::before {\n        content: \"\\f564\";\n    }\n\n    .bi-slack::before {\n        content: \"\\f565\";\n    }\n\n    .bi-slash-circle-fill::before {\n        content: \"\\f566\";\n    }\n\n    .bi-slash-circle::before {\n        content: \"\\f567\";\n    }\n\n    .bi-slash-square-fill::before {\n        content: \"\\f568\";\n    }\n\n    .bi-slash-square::before {\n        content: \"\\f569\";\n    }\n\n    .bi-slash::before {\n        content: \"\\f56a\";\n    }\n\n    .bi-sliders::before {\n        content: \"\\f56b\";\n    }\n\n    .bi-smartwatch::before {\n        content: \"\\f56c\";\n    }\n\n    .bi-snow::before {\n        content: \"\\f56d\";\n    }\n\n    .bi-snow2::before {\n        content: \"\\f56e\";\n    }\n\n    .bi-snow3::before {\n        content: \"\\f56f\";\n    }\n\n    .bi-sort-alpha-down-alt::before {\n        content: \"\\f570\";\n    }\n\n    .bi-sort-alpha-down::before {\n        content: \"\\f571\";\n    }\n\n    .bi-sort-alpha-up-alt::before {\n        content: \"\\f572\";\n    }\n\n    .bi-sort-alpha-up::before {\n        content: \"\\f573\";\n    }\n\n    .bi-sort-down-alt::before {\n        content: \"\\f574\";\n    }\n\n    .bi-sort-down::before {\n        content: \"\\f575\";\n    }\n\n    .bi-sort-numeric-down-alt::before {\n        content: \"\\f576\";\n    }\n\n    .bi-sort-numeric-down::before {\n        content: \"\\f577\";\n    }\n\n    .bi-sort-numeric-up-alt::before {\n        content: \"\\f578\";\n    }\n\n    .bi-sort-numeric-up::before {\n        content: \"\\f579\";\n    }\n\n    .bi-sort-up-alt::before {\n        content: \"\\f57a\";\n    }\n\n    .bi-sort-up::before {\n        content: \"\\f57b\";\n    }\n\n    .bi-soundwave::before {\n        content: \"\\f57c\";\n    }\n\n    .bi-speaker-fill::before {\n        content: \"\\f57d\";\n    }\n\n    .bi-speaker::before {\n        content: \"\\f57e\";\n    }\n\n    .bi-speedometer::before {\n        content: \"\\f57f\";\n    }\n\n    .bi-speedometer2::before {\n        content: \"\\f580\";\n    }\n\n    .bi-spellcheck::before {\n        content: \"\\f581\";\n    }\n\n    .bi-square-fill::before {\n        content: \"\\f582\";\n    }\n\n    .bi-square-half::before {\n        content: \"\\f583\";\n    }\n\n    .bi-square::before {\n        content: \"\\f584\";\n    }\n\n    .bi-stack::before {\n        content: \"\\f585\";\n    }\n\n    .bi-star-fill::before {\n        content: \"\\f586\";\n    }\n\n    .bi-star-half::before {\n        content: \"\\f587\";\n    }\n\n    .bi-star::before {\n        content: \"\\f588\";\n    }\n\n    .bi-stars::before {\n        content: \"\\f589\";\n    }\n\n    .bi-stickies-fill::before {\n        content: \"\\f58a\";\n    }\n\n    .bi-stickies::before {\n        content: \"\\f58b\";\n    }\n\n    .bi-sticky-fill::before {\n        content: \"\\f58c\";\n    }\n\n    .bi-sticky::before {\n        content: \"\\f58d\";\n    }\n\n    .bi-stop-btn-fill::before {\n        content: \"\\f58e\";\n    }\n\n    .bi-stop-btn::before {\n        content: \"\\f58f\";\n    }\n\n    .bi-stop-circle-fill::before {\n        content: \"\\f590\";\n    }\n\n    .bi-stop-circle::before {\n        content: \"\\f591\";\n    }\n\n    .bi-stop-fill::before {\n        content: \"\\f592\";\n    }\n\n    .bi-stop::before {\n        content: \"\\f593\";\n    }\n\n    .bi-stoplights-fill::before {\n        content: \"\\f594\";\n    }\n\n    .bi-stoplights::before {\n        content: \"\\f595\";\n    }\n\n    .bi-stopwatch-fill::before {\n        content: \"\\f596\";\n    }\n\n    .bi-stopwatch::before {\n        content: \"\\f597\";\n    }\n\n    .bi-subtract::before {\n        content: \"\\f598\";\n    }\n\n    .bi-suit-club-fill::before {\n        content: \"\\f599\";\n    }\n\n    .bi-suit-club::before {\n        content: \"\\f59a\";\n    }\n\n    .bi-suit-diamond-fill::before {\n        content: \"\\f59b\";\n    }\n\n    .bi-suit-diamond::before {\n        content: \"\\f59c\";\n    }\n\n    .bi-suit-heart-fill::before {\n        content: \"\\f59d\";\n    }\n\n    .bi-suit-heart::before {\n        content: \"\\f59e\";\n    }\n\n    .bi-suit-spade-fill::before {\n        content: \"\\f59f\";\n    }\n\n    .bi-suit-spade::before {\n        content: \"\\f5a0\";\n    }\n\n    .bi-sun-fill::before {\n        content: \"\\f5a1\";\n    }\n\n    .bi-sun::before {\n        content: \"\\f5a2\";\n    }\n\n    .bi-sunglasses::before {\n        content: \"\\f5a3\";\n    }\n\n    .bi-sunrise-fill::before {\n        content: \"\\f5a4\";\n    }\n\n    .bi-sunrise::before {\n        content: \"\\f5a5\";\n    }\n\n    .bi-sunset-fill::before {\n        content: \"\\f5a6\";\n    }\n\n    .bi-sunset::before {\n        content: \"\\f5a7\";\n    }\n\n    .bi-symmetry-horizontal::before {\n        content: \"\\f5a8\";\n    }\n\n    .bi-symmetry-vertical::before {\n        content: \"\\f5a9\";\n    }\n\n    .bi-table::before {\n        content: \"\\f5aa\";\n    }\n\n    .bi-tablet-fill::before {\n        content: \"\\f5ab\";\n    }\n\n    .bi-tablet-landscape-fill::before {\n        content: \"\\f5ac\";\n    }\n\n    .bi-tablet-landscape::before {\n        content: \"\\f5ad\";\n    }\n\n    .bi-tablet::before {\n        content: \"\\f5ae\";\n    }\n\n    .bi-tag-fill::before {\n        content: \"\\f5af\";\n    }\n\n    .bi-tag::before {\n        content: \"\\f5b0\";\n    }\n\n    .bi-tags-fill::before {\n        content: \"\\f5b1\";\n    }\n\n    .bi-tags::before {\n        content: \"\\f5b2\";\n    }\n\n    .bi-telegram::before {\n        content: \"\\f5b3\";\n    }\n\n    .bi-telephone-fill::before {\n        content: \"\\f5b4\";\n    }\n\n    .bi-telephone-forward-fill::before {\n        content: \"\\f5b5\";\n    }\n\n    .bi-telephone-forward::before {\n        content: \"\\f5b6\";\n    }\n\n    .bi-telephone-inbound-fill::before {\n        content: \"\\f5b7\";\n    }\n\n    .bi-telephone-inbound::before {\n        content: \"\\f5b8\";\n    }\n\n    .bi-telephone-minus-fill::before {\n        content: \"\\f5b9\";\n    }\n\n    .bi-telephone-minus::before {\n        content: \"\\f5ba\";\n    }\n\n    .bi-telephone-outbound-fill::before {\n        content: \"\\f5bb\";\n    }\n\n    .bi-telephone-outbound::before {\n        content: \"\\f5bc\";\n    }\n\n    .bi-telephone-plus-fill::before {\n        content: \"\\f5bd\";\n    }\n\n    .bi-telephone-plus::before {\n        content: \"\\f5be\";\n    }\n\n    .bi-telephone-x-fill::before {\n        content: \"\\f5bf\";\n    }\n\n    .bi-telephone-x::before {\n        content: \"\\f5c0\";\n    }\n\n    .bi-telephone::before {\n        content: \"\\f5c1\";\n    }\n\n    .bi-terminal-fill::before {\n        content: \"\\f5c2\";\n    }\n\n    .bi-terminal::before {\n        content: \"\\f5c3\";\n    }\n\n    .bi-text-center::before {\n        content: \"\\f5c4\";\n    }\n\n    .bi-text-indent-left::before {\n        content: \"\\f5c5\";\n    }\n\n    .bi-text-indent-right::before {\n        content: \"\\f5c6\";\n    }\n\n    .bi-text-left::before {\n        content: \"\\f5c7\";\n    }\n\n    .bi-text-paragraph::before {\n        content: \"\\f5c8\";\n    }\n\n    .bi-text-right::before {\n        content: \"\\f5c9\";\n    }\n\n    .bi-textarea-resize::before {\n        content: \"\\f5ca\";\n    }\n\n    .bi-textarea-t::before {\n        content: \"\\f5cb\";\n    }\n\n    .bi-textarea::before {\n        content: \"\\f5cc\";\n    }\n\n    .bi-thermometer-half::before {\n        content: \"\\f5cd\";\n    }\n\n    .bi-thermometer-high::before {\n        content: \"\\f5ce\";\n    }\n\n    .bi-thermometer-low::before {\n        content: \"\\f5cf\";\n    }\n\n    .bi-thermometer-snow::before {\n        content: \"\\f5d0\";\n    }\n\n    .bi-thermometer-sun::before {\n        content: \"\\f5d1\";\n    }\n\n    .bi-thermometer::before {\n        content: \"\\f5d2\";\n    }\n\n    .bi-three-dots-vertical::before {\n        content: \"\\f5d3\";\n    }\n\n    .bi-three-dots::before {\n        content: \"\\f5d4\";\n    }\n\n    .bi-toggle-off::before {\n        content: \"\\f5d5\";\n    }\n\n    .bi-toggle-on::before {\n        content: \"\\f5d6\";\n    }\n\n    .bi-toggle2-off::before {\n        content: \"\\f5d7\";\n    }\n\n    .bi-toggle2-on::before {\n        content: \"\\f5d8\";\n    }\n\n    .bi-toggles::before {\n        content: \"\\f5d9\";\n    }\n\n    .bi-toggles2::before {\n        content: \"\\f5da\";\n    }\n\n    .bi-tools::before {\n        content: \"\\f5db\";\n    }\n\n    .bi-tornado::before {\n        content: \"\\f5dc\";\n    }\n\n    .bi-trash-fill::before {\n        content: \"\\f5dd\";\n    }\n\n    .bi-trash::before {\n        content: \"\\f5de\";\n    }\n\n    .bi-trash2-fill::before {\n        content: \"\\f5df\";\n    }\n\n    .bi-trash2::before {\n        content: \"\\f5e0\";\n    }\n\n    .bi-tree-fill::before {\n        content: \"\\f5e1\";\n    }\n\n    .bi-tree::before {\n        content: \"\\f5e2\";\n    }\n\n    .bi-triangle-fill::before {\n        content: \"\\f5e3\";\n    }\n\n    .bi-triangle-half::before {\n        content: \"\\f5e4\";\n    }\n\n    .bi-triangle::before {\n        content: \"\\f5e5\";\n    }\n\n    .bi-trophy-fill::before {\n        content: \"\\f5e6\";\n    }\n\n    .bi-trophy::before {\n        content: \"\\f5e7\";\n    }\n\n    .bi-tropical-storm::before {\n        content: \"\\f5e8\";\n    }\n\n    .bi-truck-flatbed::before {\n        content: \"\\f5e9\";\n    }\n\n    .bi-truck::before {\n        content: \"\\f5ea\";\n    }\n\n    .bi-tsunami::before {\n        content: \"\\f5eb\";\n    }\n\n    .bi-tv-fill::before {\n        content: \"\\f5ec\";\n    }\n\n    .bi-tv::before {\n        content: \"\\f5ed\";\n    }\n\n    .bi-twitch::before {\n        content: \"\\f5ee\";\n    }\n\n    .bi-twitter::before {\n        content: \"\\f5ef\";\n    }\n\n    .bi-type-bold::before {\n        content: \"\\f5f0\";\n    }\n\n    .bi-type-h1::before {\n        content: \"\\f5f1\";\n    }\n\n    .bi-type-h2::before {\n        content: \"\\f5f2\";\n    }\n\n    .bi-type-h3::before {\n        content: \"\\f5f3\";\n    }\n\n    .bi-type-italic::before {\n        content: \"\\f5f4\";\n    }\n\n    .bi-type-strikethrough::before {\n        content: \"\\f5f5\";\n    }\n\n    .bi-type-underline::before {\n        content: \"\\f5f6\";\n    }\n\n    .bi-type::before {\n        content: \"\\f5f7\";\n    }\n\n    .bi-ui-checks-grid::before {\n        content: \"\\f5f8\";\n    }\n\n    .bi-ui-checks::before {\n        content: \"\\f5f9\";\n    }\n\n    .bi-ui-radios-grid::before {\n        content: \"\\f5fa\";\n    }\n\n    .bi-ui-radios::before {\n        content: \"\\f5fb\";\n    }\n\n    .bi-umbrella-fill::before {\n        content: \"\\f5fc\";\n    }\n\n    .bi-umbrella::before {\n        content: \"\\f5fd\";\n    }\n\n    .bi-union::before {\n        content: \"\\f5fe\";\n    }\n\n    .bi-unlock-fill::before {\n        content: \"\\f5ff\";\n    }\n\n    .bi-unlock::before {\n        content: \"\\f600\";\n    }\n\n    .bi-upc-scan::before {\n        content: \"\\f601\";\n    }\n\n    .bi-upc::before {\n        content: \"\\f602\";\n    }\n\n    .bi-upload::before {\n        content: \"\\f603\";\n    }\n\n    .bi-vector-pen::before {\n        content: \"\\f604\";\n    }\n\n    .bi-view-list::before {\n        content: \"\\f605\";\n    }\n\n    .bi-view-stacked::before {\n        content: \"\\f606\";\n    }\n\n    .bi-vinyl-fill::before {\n        content: \"\\f607\";\n    }\n\n    .bi-vinyl::before {\n        content: \"\\f608\";\n    }\n\n    .bi-voicemail::before {\n        content: \"\\f609\";\n    }\n\n    .bi-volume-down-fill::before {\n        content: \"\\f60a\";\n    }\n\n    .bi-volume-down::before {\n        content: \"\\f60b\";\n    }\n\n    .bi-volume-mute-fill::before {\n        content: \"\\f60c\";\n    }\n\n    .bi-volume-mute::before {\n        content: \"\\f60d\";\n    }\n\n    .bi-volume-off-fill::before {\n        content: \"\\f60e\";\n    }\n\n    .bi-volume-off::before {\n        content: \"\\f60f\";\n    }\n\n    .bi-volume-up-fill::before {\n        content: \"\\f610\";\n    }\n\n    .bi-volume-up::before {\n        content: \"\\f611\";\n    }\n\n    .bi-vr::before {\n        content: \"\\f612\";\n    }\n\n    .bi-wallet-fill::before {\n        content: \"\\f613\";\n    }\n\n    .bi-wallet::before {\n        content: \"\\f614\";\n    }\n\n    .bi-wallet2::before {\n        content: \"\\f615\";\n    }\n\n    .bi-watch::before {\n        content: \"\\f616\";\n    }\n\n    .bi-water::before {\n        content: \"\\f617\";\n    }\n\n    .bi-whatsapp::before {\n        content: \"\\f618\";\n    }\n\n    .bi-wifi-1::before {\n        content: \"\\f619\";\n    }\n\n    .bi-wifi-2::before {\n        content: \"\\f61a\";\n    }\n\n    .bi-wifi-off::before {\n        content: \"\\f61b\";\n    }\n\n    .bi-wifi::before {\n        content: \"\\f61c\";\n    }\n\n    .bi-wind::before {\n        content: \"\\f61d\";\n    }\n\n    .bi-window-dock::before {\n        content: \"\\f61e\";\n    }\n\n    .bi-window-sidebar::before {\n        content: \"\\f61f\";\n    }\n\n    .bi-window::before {\n        content: \"\\f620\";\n    }\n\n    .bi-wrench::before {\n        content: \"\\f621\";\n    }\n\n    .bi-x-circle-fill::before {\n        content: \"\\f622\";\n    }\n\n    .bi-x-circle::before {\n        content: \"\\f623\";\n    }\n\n    .bi-x-diamond-fill::before {\n        content: \"\\f624\";\n    }\n\n    .bi-x-diamond::before {\n        content: \"\\f625\";\n    }\n\n    .bi-x-octagon-fill::before {\n        content: \"\\f626\";\n    }\n\n    .bi-x-octagon::before {\n        content: \"\\f627\";\n    }\n\n    .bi-x-square-fill::before {\n        content: \"\\f628\";\n    }\n\n    .bi-x-square::before {\n        content: \"\\f629\";\n    }\n\n    .bi-x::before {\n        content: \"\\f62a\";\n    }\n\n    .bi-youtube::before {\n        content: \"\\f62b\";\n    }\n\n    .bi-zoom-in::before {\n        content: \"\\f62c\";\n    }\n\n    .bi-zoom-out::before {\n        content: \"\\f62d\";\n    }\n\n    .bi-bank::before {\n        content: \"\\f62e\";\n    }\n\n    .bi-bank2::before {\n        content: \"\\f62f\";\n    }\n\n    .bi-bell-slash-fill::before {\n        content: \"\\f630\";\n    }\n\n    .bi-bell-slash::before {\n        content: \"\\f631\";\n    }\n\n    .bi-cash-coin::before {\n        content: \"\\f632\";\n    }\n\n    .bi-check-lg::before {\n        content: \"\\f633\";\n    }\n\n    .bi-coin::before {\n        content: \"\\f634\";\n    }\n\n    .bi-currency-bitcoin::before {\n        content: \"\\f635\";\n    }\n\n    .bi-currency-dollar::before {\n        content: \"\\f636\";\n    }\n\n    .bi-currency-euro::before {\n        content: \"\\f637\";\n    }\n\n    .bi-currency-exchange::before {\n        content: \"\\f638\";\n    }\n\n    .bi-currency-pound::before {\n        content: \"\\f639\";\n    }\n\n    .bi-currency-yen::before {\n        content: \"\\f63a\";\n    }\n\n    .bi-dash-lg::before {\n        content: \"\\f63b\";\n    }\n\n    .bi-exclamation-lg::before {\n        content: \"\\f63c\";\n    }\n\n    .bi-file-earmark-pdf-fill::before {\n        content: \"\\f63d\";\n    }\n\n    .bi-file-earmark-pdf::before {\n        content: \"\\f63e\";\n    }\n\n    .bi-file-pdf-fill::before {\n        content: \"\\f63f\";\n    }\n\n    .bi-file-pdf::before {\n        content: \"\\f640\";\n    }\n\n    .bi-gender-ambiguous::before {\n        content: \"\\f641\";\n    }\n\n    .bi-gender-female::before {\n        content: \"\\f642\";\n    }\n\n    .bi-gender-male::before {\n        content: \"\\f643\";\n    }\n\n    .bi-gender-trans::before {\n        content: \"\\f644\";\n    }\n\n    .bi-headset-vr::before {\n        content: \"\\f645\";\n    }\n\n    .bi-info-lg::before {\n        content: \"\\f646\";\n    }\n\n    .bi-mastodon::before {\n        content: \"\\f647\";\n    }\n\n    .bi-messenger::before {\n        content: \"\\f648\";\n    }\n\n    .bi-piggy-bank-fill::before {\n        content: \"\\f649\";\n    }\n\n    .bi-piggy-bank::before {\n        content: \"\\f64a\";\n    }\n\n    .bi-pin-map-fill::before {\n        content: \"\\f64b\";\n    }\n\n    .bi-pin-map::before {\n        content: \"\\f64c\";\n    }\n\n    .bi-plus-lg::before {\n        content: \"\\f64d\";\n    }\n\n    .bi-question-lg::before {\n        content: \"\\f64e\";\n    }\n\n    .bi-recycle::before {\n        content: \"\\f64f\";\n    }\n\n    .bi-reddit::before {\n        content: \"\\f650\";\n    }\n\n    .bi-safe-fill::before {\n        content: \"\\f651\";\n    }\n\n    .bi-safe2-fill::before {\n        content: \"\\f652\";\n    }\n\n    .bi-safe2::before {\n        content: \"\\f653\";\n    }\n\n    .bi-sd-card-fill::before {\n        content: \"\\f654\";\n    }\n\n    .bi-sd-card::before {\n        content: \"\\f655\";\n    }\n\n    .bi-skype::before {\n        content: \"\\f656\";\n    }\n\n    .bi-slash-lg::before {\n        content: \"\\f657\";\n    }\n\n    .bi-translate::before {\n        content: \"\\f658\";\n    }\n\n    .bi-x-lg::before {\n        content: \"\\f659\";\n    }\n\n    .bi-safe::before {\n        content: \"\\f65a\";\n    }\n\n    .bi-apple::before {\n        content: \"\\f65b\";\n    }\n\n    .bi-microsoft::before {\n        content: \"\\f65d\";\n    }\n\n    .bi-windows::before {\n        content: \"\\f65e\";\n    }\n\n    .bi-behance::before {\n        content: \"\\f65c\";\n    }\n\n    .bi-dribbble::before {\n        content: \"\\f65f\";\n    }\n\n    .bi-line::before {\n        content: \"\\f660\";\n    }\n\n    .bi-medium::before {\n        content: \"\\f661\";\n    }\n\n    .bi-paypal::before {\n        content: \"\\f662\";\n    }\n\n    .bi-pinterest::before {\n        content: \"\\f663\";\n    }\n\n    .bi-signal::before {\n        content: \"\\f664\";\n    }\n\n    .bi-snapchat::before {\n        content: \"\\f665\";\n    }\n\n    .bi-spotify::before {\n        content: \"\\f666\";\n    }\n\n    .bi-stack-overflow::before {\n        content: \"\\f667\";\n    }\n\n    .bi-strava::before {\n        content: \"\\f668\";\n    }\n\n    .bi-wordpress::before {\n        content: \"\\f669\";\n    }\n\n    .bi-vimeo::before {\n        content: \"\\f66a\";\n    }\n\n    .bi-activity::before {\n        content: \"\\f66b\";\n    }\n\n    .bi-easel2-fill::before {\n        content: \"\\f66c\";\n    }\n\n    .bi-easel2::before {\n        content: \"\\f66d\";\n    }\n\n    .bi-easel3-fill::before {\n        content: \"\\f66e\";\n    }\n\n    .bi-easel3::before {\n        content: \"\\f66f\";\n    }\n\n    .bi-fan::before {\n        content: \"\\f670\";\n    }\n\n    .bi-fingerprint::before {\n        content: \"\\f671\";\n    }\n\n    .bi-graph-down-arrow::before {\n        content: \"\\f672\";\n    }\n\n    .bi-graph-up-arrow::before {\n        content: \"\\f673\";\n    }\n\n    .bi-hypnotize::before {\n        content: \"\\f674\";\n    }\n\n    .bi-magic::before {\n        content: \"\\f675\";\n    }\n\n    .bi-person-rolodex::before {\n        content: \"\\f676\";\n    }\n\n    .bi-person-video::before {\n        content: \"\\f677\";\n    }\n\n    .bi-person-video2::before {\n        content: \"\\f678\";\n    }\n\n    .bi-person-video3::before {\n        content: \"\\f679\";\n    }\n\n    .bi-person-workspace::before {\n        content: \"\\f67a\";\n    }\n\n    .bi-radioactive::before {\n        content: \"\\f67b\";\n    }\n\n    .bi-webcam-fill::before {\n        content: \"\\f67c\";\n    }\n\n    .bi-webcam::before {\n        content: \"\\f67d\";\n    }\n\n    .bi-yin-yang::before {\n        content: \"\\f67e\";\n    }\n\n    .bi-bandaid-fill::before {\n        content: \"\\f680\";\n    }\n\n    .bi-bandaid::before {\n        content: \"\\f681\";\n    }\n\n    .bi-bluetooth::before {\n        content: \"\\f682\";\n    }\n\n    .bi-body-text::before {\n        content: \"\\f683\";\n    }\n\n    .bi-boombox::before {\n        content: \"\\f684\";\n    }\n\n    .bi-boxes::before {\n        content: \"\\f685\";\n    }\n\n    .bi-dpad-fill::before {\n        content: \"\\f686\";\n    }\n\n    .bi-dpad::before {\n        content: \"\\f687\";\n    }\n\n    .bi-ear-fill::before {\n        content: \"\\f688\";\n    }\n\n    .bi-ear::before {\n        content: \"\\f689\";\n    }\n\n    .bi-envelope-check-fill::before {\n        content: \"\\f68b\";\n    }\n\n    .bi-envelope-check::before {\n        content: \"\\f68c\";\n    }\n\n    .bi-envelope-dash-fill::before {\n        content: \"\\f68e\";\n    }\n\n    .bi-envelope-dash::before {\n        content: \"\\f68f\";\n    }\n\n    .bi-envelope-exclamation-fill::before {\n        content: \"\\f691\";\n    }\n\n    .bi-envelope-exclamation::before {\n        content: \"\\f692\";\n    }\n\n    .bi-envelope-plus-fill::before {\n        content: \"\\f693\";\n    }\n\n    .bi-envelope-plus::before {\n        content: \"\\f694\";\n    }\n\n    .bi-envelope-slash-fill::before {\n        content: \"\\f696\";\n    }\n\n    .bi-envelope-slash::before {\n        content: \"\\f697\";\n    }\n\n    .bi-envelope-x-fill::before {\n        content: \"\\f699\";\n    }\n\n    .bi-envelope-x::before {\n        content: \"\\f69a\";\n    }\n\n    .bi-explicit-fill::before {\n        content: \"\\f69b\";\n    }\n\n    .bi-explicit::before {\n        content: \"\\f69c\";\n    }\n\n    .bi-git::before {\n        content: \"\\f69d\";\n    }\n\n    .bi-infinity::before {\n        content: \"\\f69e\";\n    }\n\n    .bi-list-columns-reverse::before {\n        content: \"\\f69f\";\n    }\n\n    .bi-list-columns::before {\n        content: \"\\f6a0\";\n    }\n\n    .bi-meta::before {\n        content: \"\\f6a1\";\n    }\n\n    .bi-nintendo-switch::before {\n        content: \"\\f6a4\";\n    }\n\n    .bi-pc-display-horizontal::before {\n        content: \"\\f6a5\";\n    }\n\n    .bi-pc-display::before {\n        content: \"\\f6a6\";\n    }\n\n    .bi-pc-horizontal::before {\n        content: \"\\f6a7\";\n    }\n\n    .bi-pc::before {\n        content: \"\\f6a8\";\n    }\n\n    .bi-playstation::before {\n        content: \"\\f6a9\";\n    }\n\n    .bi-plus-slash-minus::before {\n        content: \"\\f6aa\";\n    }\n\n    .bi-projector-fill::before {\n        content: \"\\f6ab\";\n    }\n\n    .bi-projector::before {\n        content: \"\\f6ac\";\n    }\n\n    .bi-qr-code-scan::before {\n        content: \"\\f6ad\";\n    }\n\n    .bi-qr-code::before {\n        content: \"\\f6ae\";\n    }\n\n    .bi-quora::before {\n        content: \"\\f6af\";\n    }\n\n    .bi-quote::before {\n        content: \"\\f6b0\";\n    }\n\n    .bi-robot::before {\n        content: \"\\f6b1\";\n    }\n\n    .bi-send-check-fill::before {\n        content: \"\\f6b2\";\n    }\n\n    .bi-send-check::before {\n        content: \"\\f6b3\";\n    }\n\n    .bi-send-dash-fill::before {\n        content: \"\\f6b4\";\n    }\n\n    .bi-send-dash::before {\n        content: \"\\f6b5\";\n    }\n\n    .bi-send-exclamation-fill::before {\n        content: \"\\f6b7\";\n    }\n\n    .bi-send-exclamation::before {\n        content: \"\\f6b8\";\n    }\n\n    .bi-send-fill::before {\n        content: \"\\f6b9\";\n    }\n\n    .bi-send-plus-fill::before {\n        content: \"\\f6ba\";\n    }\n\n    .bi-send-plus::before {\n        content: \"\\f6bb\";\n    }\n\n    .bi-send-slash-fill::before {\n        content: \"\\f6bc\";\n    }\n\n    .bi-send-slash::before {\n        content: \"\\f6bd\";\n    }\n\n    .bi-send-x-fill::before {\n        content: \"\\f6be\";\n    }\n\n    .bi-send-x::before {\n        content: \"\\f6bf\";\n    }\n\n    .bi-send::before {\n        content: \"\\f6c0\";\n    }\n\n    .bi-steam::before {\n        content: \"\\f6c1\";\n    }\n\n    .bi-terminal-dash::before {\n        content: \"\\f6c3\";\n    }\n\n    .bi-terminal-plus::before {\n        content: \"\\f6c4\";\n    }\n\n    .bi-terminal-split::before {\n        content: \"\\f6c5\";\n    }\n\n    .bi-ticket-detailed-fill::before {\n        content: \"\\f6c6\";\n    }\n\n    .bi-ticket-detailed::before {\n        content: \"\\f6c7\";\n    }\n\n    .bi-ticket-fill::before {\n        content: \"\\f6c8\";\n    }\n\n    .bi-ticket-perforated-fill::before {\n        content: \"\\f6c9\";\n    }\n\n    .bi-ticket-perforated::before {\n        content: \"\\f6ca\";\n    }\n\n    .bi-ticket::before {\n        content: \"\\f6cb\";\n    }\n\n    .bi-tiktok::before {\n        content: \"\\f6cc\";\n    }\n\n    .bi-window-dash::before {\n        content: \"\\f6cd\";\n    }\n\n    .bi-window-desktop::before {\n        content: \"\\f6ce\";\n    }\n\n    .bi-window-fullscreen::before {\n        content: \"\\f6cf\";\n    }\n\n    .bi-window-plus::before {\n        content: \"\\f6d0\";\n    }\n\n    .bi-window-split::before {\n        content: \"\\f6d1\";\n    }\n\n    .bi-window-stack::before {\n        content: \"\\f6d2\";\n    }\n\n    .bi-window-x::before {\n        content: \"\\f6d3\";\n    }\n\n    .bi-xbox::before {\n        content: \"\\f6d4\";\n    }\n\n    .bi-ethernet::before {\n        content: \"\\f6d5\";\n    }\n\n    .bi-hdmi-fill::before {\n        content: \"\\f6d6\";\n    }\n\n    .bi-hdmi::before {\n        content: \"\\f6d7\";\n    }\n\n    .bi-usb-c-fill::before {\n        content: \"\\f6d8\";\n    }\n\n    .bi-usb-c::before {\n        content: \"\\f6d9\";\n    }\n\n    .bi-usb-fill::before {\n        content: \"\\f6da\";\n    }\n\n    .bi-usb-plug-fill::before {\n        content: \"\\f6db\";\n    }\n\n    .bi-usb-plug::before {\n        content: \"\\f6dc\";\n    }\n\n    .bi-usb-symbol::before {\n        content: \"\\f6dd\";\n    }\n\n    .bi-usb::before {\n        content: \"\\f6de\";\n    }\n\n    .bi-boombox-fill::before {\n        content: \"\\f6df\";\n    }\n\n    .bi-displayport::before {\n        content: \"\\f6e1\";\n    }\n\n    .bi-gpu-card::before {\n        content: \"\\f6e2\";\n    }\n\n    .bi-memory::before {\n        content: \"\\f6e3\";\n    }\n\n    .bi-modem-fill::before {\n        content: \"\\f6e4\";\n    }\n\n    .bi-modem::before {\n        content: \"\\f6e5\";\n    }\n\n    .bi-motherboard-fill::before {\n        content: \"\\f6e6\";\n    }\n\n    .bi-motherboard::before {\n        content: \"\\f6e7\";\n    }\n\n    .bi-optical-audio-fill::before {\n        content: \"\\f6e8\";\n    }\n\n    .bi-optical-audio::before {\n        content: \"\\f6e9\";\n    }\n\n    .bi-pci-card::before {\n        content: \"\\f6ea\";\n    }\n\n    .bi-router-fill::before {\n        content: \"\\f6eb\";\n    }\n\n    .bi-router::before {\n        content: \"\\f6ec\";\n    }\n\n    .bi-thunderbolt-fill::before {\n        content: \"\\f6ef\";\n    }\n\n    .bi-thunderbolt::before {\n        content: \"\\f6f0\";\n    }\n\n    .bi-usb-drive-fill::before {\n        content: \"\\f6f1\";\n    }\n\n    .bi-usb-drive::before {\n        content: \"\\f6f2\";\n    }\n\n    .bi-usb-micro-fill::before {\n        content: \"\\f6f3\";\n    }\n\n    .bi-usb-micro::before {\n        content: \"\\f6f4\";\n    }\n\n    .bi-usb-mini-fill::before {\n        content: \"\\f6f5\";\n    }\n\n    .bi-usb-mini::before {\n        content: \"\\f6f6\";\n    }\n\n    .bi-cloud-haze2::before {\n        content: \"\\f6f7\";\n    }\n\n    .bi-device-hdd-fill::before {\n        content: \"\\f6f8\";\n    }\n\n    .bi-device-hdd::before {\n        content: \"\\f6f9\";\n    }\n\n    .bi-device-ssd-fill::before {\n        content: \"\\f6fa\";\n    }\n\n    .bi-device-ssd::before {\n        content: \"\\f6fb\";\n    }\n\n    .bi-displayport-fill::before {\n        content: \"\\f6fc\";\n    }\n\n    .bi-mortarboard-fill::before {\n        content: \"\\f6fd\";\n    }\n\n    .bi-mortarboard::before {\n        content: \"\\f6fe\";\n    }\n\n    .bi-terminal-x::before {\n        content: \"\\f6ff\";\n    }\n\n    .bi-arrow-through-heart-fill::before {\n        content: \"\\f700\";\n    }\n\n    .bi-arrow-through-heart::before {\n        content: \"\\f701\";\n    }\n\n    .bi-badge-sd-fill::before {\n        content: \"\\f702\";\n    }\n\n    .bi-badge-sd::before {\n        content: \"\\f703\";\n    }\n\n    .bi-bag-heart-fill::before {\n        content: \"\\f704\";\n    }\n\n    .bi-bag-heart::before {\n        content: \"\\f705\";\n    }\n\n    .bi-balloon-fill::before {\n        content: \"\\f706\";\n    }\n\n    .bi-balloon-heart-fill::before {\n        content: \"\\f707\";\n    }\n\n    .bi-balloon-heart::before {\n        content: \"\\f708\";\n    }\n\n    .bi-balloon::before {\n        content: \"\\f709\";\n    }\n\n    .bi-box2-fill::before {\n        content: \"\\f70a\";\n    }\n\n    .bi-box2-heart-fill::before {\n        content: \"\\f70b\";\n    }\n\n    .bi-box2-heart::before {\n        content: \"\\f70c\";\n    }\n\n    .bi-box2::before {\n        content: \"\\f70d\";\n    }\n\n    .bi-braces-asterisk::before {\n        content: \"\\f70e\";\n    }\n\n    .bi-calendar-heart-fill::before {\n        content: \"\\f70f\";\n    }\n\n    .bi-calendar-heart::before {\n        content: \"\\f710\";\n    }\n\n    .bi-calendar2-heart-fill::before {\n        content: \"\\f711\";\n    }\n\n    .bi-calendar2-heart::before {\n        content: \"\\f712\";\n    }\n\n    .bi-chat-heart-fill::before {\n        content: \"\\f713\";\n    }\n\n    .bi-chat-heart::before {\n        content: \"\\f714\";\n    }\n\n    .bi-chat-left-heart-fill::before {\n        content: \"\\f715\";\n    }\n\n    .bi-chat-left-heart::before {\n        content: \"\\f716\";\n    }\n\n    .bi-chat-right-heart-fill::before {\n        content: \"\\f717\";\n    }\n\n    .bi-chat-right-heart::before {\n        content: \"\\f718\";\n    }\n\n    .bi-chat-square-heart-fill::before {\n        content: \"\\f719\";\n    }\n\n    .bi-chat-square-heart::before {\n        content: \"\\f71a\";\n    }\n\n    .bi-clipboard-check-fill::before {\n        content: \"\\f71b\";\n    }\n\n    .bi-clipboard-data-fill::before {\n        content: \"\\f71c\";\n    }\n\n    .bi-clipboard-fill::before {\n        content: \"\\f71d\";\n    }\n\n    .bi-clipboard-heart-fill::before {\n        content: \"\\f71e\";\n    }\n\n    .bi-clipboard-heart::before {\n        content: \"\\f71f\";\n    }\n\n    .bi-clipboard-minus-fill::before {\n        content: \"\\f720\";\n    }\n\n    .bi-clipboard-plus-fill::before {\n        content: \"\\f721\";\n    }\n\n    .bi-clipboard-pulse::before {\n        content: \"\\f722\";\n    }\n\n    .bi-clipboard-x-fill::before {\n        content: \"\\f723\";\n    }\n\n    .bi-clipboard2-check-fill::before {\n        content: \"\\f724\";\n    }\n\n    .bi-clipboard2-check::before {\n        content: \"\\f725\";\n    }\n\n    .bi-clipboard2-data-fill::before {\n        content: \"\\f726\";\n    }\n\n    .bi-clipboard2-data::before {\n        content: \"\\f727\";\n    }\n\n    .bi-clipboard2-fill::before {\n        content: \"\\f728\";\n    }\n\n    .bi-clipboard2-heart-fill::before {\n        content: \"\\f729\";\n    }\n\n    .bi-clipboard2-heart::before {\n        content: \"\\f72a\";\n    }\n\n    .bi-clipboard2-minus-fill::before {\n        content: \"\\f72b\";\n    }\n\n    .bi-clipboard2-minus::before {\n        content: \"\\f72c\";\n    }\n\n    .bi-clipboard2-plus-fill::before {\n        content: \"\\f72d\";\n    }\n\n    .bi-clipboard2-plus::before {\n        content: \"\\f72e\";\n    }\n\n    .bi-clipboard2-pulse-fill::before {\n        content: \"\\f72f\";\n    }\n\n    .bi-clipboard2-pulse::before {\n        content: \"\\f730\";\n    }\n\n    .bi-clipboard2-x-fill::before {\n        content: \"\\f731\";\n    }\n\n    .bi-clipboard2-x::before {\n        content: \"\\f732\";\n    }\n\n    .bi-clipboard2::before {\n        content: \"\\f733\";\n    }\n\n    .bi-emoji-kiss-fill::before {\n        content: \"\\f734\";\n    }\n\n    .bi-emoji-kiss::before {\n        content: \"\\f735\";\n    }\n\n    .bi-envelope-heart-fill::before {\n        content: \"\\f736\";\n    }\n\n    .bi-envelope-heart::before {\n        content: \"\\f737\";\n    }\n\n    .bi-envelope-open-heart-fill::before {\n        content: \"\\f738\";\n    }\n\n    .bi-envelope-open-heart::before {\n        content: \"\\f739\";\n    }\n\n    .bi-envelope-paper-fill::before {\n        content: \"\\f73a\";\n    }\n\n    .bi-envelope-paper-heart-fill::before {\n        content: \"\\f73b\";\n    }\n\n    .bi-envelope-paper-heart::before {\n        content: \"\\f73c\";\n    }\n\n    .bi-envelope-paper::before {\n        content: \"\\f73d\";\n    }\n\n    .bi-filetype-aac::before {\n        content: \"\\f73e\";\n    }\n\n    .bi-filetype-ai::before {\n        content: \"\\f73f\";\n    }\n\n    .bi-filetype-bmp::before {\n        content: \"\\f740\";\n    }\n\n    .bi-filetype-cs::before {\n        content: \"\\f741\";\n    }\n\n    .bi-filetype-css::before {\n        content: \"\\f742\";\n    }\n\n    .bi-filetype-csv::before {\n        content: \"\\f743\";\n    }\n\n    .bi-filetype-doc::before {\n        content: \"\\f744\";\n    }\n\n    .bi-filetype-docx::before {\n        content: \"\\f745\";\n    }\n\n    .bi-filetype-exe::before {\n        content: \"\\f746\";\n    }\n\n    .bi-filetype-gif::before {\n        content: \"\\f747\";\n    }\n\n    .bi-filetype-heic::before {\n        content: \"\\f748\";\n    }\n\n    .bi-filetype-html::before {\n        content: \"\\f749\";\n    }\n\n    .bi-filetype-java::before {\n        content: \"\\f74a\";\n    }\n\n    .bi-filetype-jpg::before {\n        content: \"\\f74b\";\n    }\n\n    .bi-filetype-js::before {\n        content: \"\\f74c\";\n    }\n\n    .bi-filetype-jsx::before {\n        content: \"\\f74d\";\n    }\n\n    .bi-filetype-key::before {\n        content: \"\\f74e\";\n    }\n\n    .bi-filetype-m4p::before {\n        content: \"\\f74f\";\n    }\n\n    .bi-filetype-md::before {\n        content: \"\\f750\";\n    }\n\n    .bi-filetype-mdx::before {\n        content: \"\\f751\";\n    }\n\n    .bi-filetype-mov::before {\n        content: \"\\f752\";\n    }\n\n    .bi-filetype-mp3::before {\n        content: \"\\f753\";\n    }\n\n    .bi-filetype-mp4::before {\n        content: \"\\f754\";\n    }\n\n    .bi-filetype-otf::before {\n        content: \"\\f755\";\n    }\n\n    .bi-filetype-pdf::before {\n        content: \"\\f756\";\n    }\n\n    .bi-filetype-php::before {\n        content: \"\\f757\";\n    }\n\n    .bi-filetype-png::before {\n        content: \"\\f758\";\n    }\n\n    .bi-filetype-ppt::before {\n        content: \"\\f75a\";\n    }\n\n    .bi-filetype-psd::before {\n        content: \"\\f75b\";\n    }\n\n    .bi-filetype-py::before {\n        content: \"\\f75c\";\n    }\n\n    .bi-filetype-raw::before {\n        content: \"\\f75d\";\n    }\n\n    .bi-filetype-rb::before {\n        content: \"\\f75e\";\n    }\n\n    .bi-filetype-sass::before {\n        content: \"\\f75f\";\n    }\n\n    .bi-filetype-scss::before {\n        content: \"\\f760\";\n    }\n\n    .bi-filetype-sh::before {\n        content: \"\\f761\";\n    }\n\n    .bi-filetype-svg::before {\n        content: \"\\f762\";\n    }\n\n    .bi-filetype-tiff::before {\n        content: \"\\f763\";\n    }\n\n    .bi-filetype-tsx::before {\n        content: \"\\f764\";\n    }\n\n    .bi-filetype-ttf::before {\n        content: \"\\f765\";\n    }\n\n    .bi-filetype-txt::before {\n        content: \"\\f766\";\n    }\n\n    .bi-filetype-wav::before {\n        content: \"\\f767\";\n    }\n\n    .bi-filetype-woff::before {\n        content: \"\\f768\";\n    }\n\n    .bi-filetype-xls::before {\n        content: \"\\f76a\";\n    }\n\n    .bi-filetype-xml::before {\n        content: \"\\f76b\";\n    }\n\n    .bi-filetype-yml::before {\n        content: \"\\f76c\";\n    }\n\n    .bi-heart-arrow::before {\n        content: \"\\f76d\";\n    }\n\n    .bi-heart-pulse-fill::before {\n        content: \"\\f76e\";\n    }\n\n    .bi-heart-pulse::before {\n        content: \"\\f76f\";\n    }\n\n    .bi-heartbreak-fill::before {\n        content: \"\\f770\";\n    }\n\n    .bi-heartbreak::before {\n        content: \"\\f771\";\n    }\n\n    .bi-hearts::before {\n        content: \"\\f772\";\n    }\n\n    .bi-hospital-fill::before {\n        content: \"\\f773\";\n    }\n\n    .bi-hospital::before {\n        content: \"\\f774\";\n    }\n\n    .bi-house-heart-fill::before {\n        content: \"\\f775\";\n    }\n\n    .bi-house-heart::before {\n        content: \"\\f776\";\n    }\n\n    .bi-incognito::before {\n        content: \"\\f777\";\n    }\n\n    .bi-magnet-fill::before {\n        content: \"\\f778\";\n    }\n\n    .bi-magnet::before {\n        content: \"\\f779\";\n    }\n\n    .bi-person-heart::before {\n        content: \"\\f77a\";\n    }\n\n    .bi-person-hearts::before {\n        content: \"\\f77b\";\n    }\n\n    .bi-phone-flip::before {\n        content: \"\\f77c\";\n    }\n\n    .bi-plugin::before {\n        content: \"\\f77d\";\n    }\n\n    .bi-postage-fill::before {\n        content: \"\\f77e\";\n    }\n\n    .bi-postage-heart-fill::before {\n        content: \"\\f77f\";\n    }\n\n    .bi-postage-heart::before {\n        content: \"\\f780\";\n    }\n\n    .bi-postage::before {\n        content: \"\\f781\";\n    }\n\n    .bi-postcard-fill::before {\n        content: \"\\f782\";\n    }\n\n    .bi-postcard-heart-fill::before {\n        content: \"\\f783\";\n    }\n\n    .bi-postcard-heart::before {\n        content: \"\\f784\";\n    }\n\n    .bi-postcard::before {\n        content: \"\\f785\";\n    }\n\n    .bi-search-heart-fill::before {\n        content: \"\\f786\";\n    }\n\n    .bi-search-heart::before {\n        content: \"\\f787\";\n    }\n\n    .bi-sliders2-vertical::before {\n        content: \"\\f788\";\n    }\n\n    .bi-sliders2::before {\n        content: \"\\f789\";\n    }\n\n    .bi-trash3-fill::before {\n        content: \"\\f78a\";\n    }\n\n    .bi-trash3::before {\n        content: \"\\f78b\";\n    }\n\n    .bi-valentine::before {\n        content: \"\\f78c\";\n    }\n\n    .bi-valentine2::before {\n        content: \"\\f78d\";\n    }\n\n    .bi-wrench-adjustable-circle-fill::before {\n        content: \"\\f78e\";\n    }\n\n    .bi-wrench-adjustable-circle::before {\n        content: \"\\f78f\";\n    }\n\n    .bi-wrench-adjustable::before {\n        content: \"\\f790\";\n    }\n\n    .bi-filetype-json::before {\n        content: \"\\f791\";\n    }\n\n    .bi-filetype-pptx::before {\n        content: \"\\f792\";\n    }\n\n    .bi-filetype-xlsx::before {\n        content: \"\\f793\";\n    }\n\n    .bi-1-circle-fill::before {\n        content: \"\\f796\";\n    }\n\n    .bi-1-circle::before {\n        content: \"\\f797\";\n    }\n\n    .bi-1-square-fill::before {\n        content: \"\\f798\";\n    }\n\n    .bi-1-square::before {\n        content: \"\\f799\";\n    }\n\n    .bi-2-circle-fill::before {\n        content: \"\\f79c\";\n    }\n\n    .bi-2-circle::before {\n        content: \"\\f79d\";\n    }\n\n    .bi-2-square-fill::before {\n        content: \"\\f79e\";\n    }\n\n    .bi-2-square::before {\n        content: \"\\f79f\";\n    }\n\n    .bi-3-circle-fill::before {\n        content: \"\\f7a2\";\n    }\n\n    .bi-3-circle::before {\n        content: \"\\f7a3\";\n    }\n\n    .bi-3-square-fill::before {\n        content: \"\\f7a4\";\n    }\n\n    .bi-3-square::before {\n        content: \"\\f7a5\";\n    }\n\n    .bi-4-circle-fill::before {\n        content: \"\\f7a8\";\n    }\n\n    .bi-4-circle::before {\n        content: \"\\f7a9\";\n    }\n\n    .bi-4-square-fill::before {\n        content: \"\\f7aa\";\n    }\n\n    .bi-4-square::before {\n        content: \"\\f7ab\";\n    }\n\n    .bi-5-circle-fill::before {\n        content: \"\\f7ae\";\n    }\n\n    .bi-5-circle::before {\n        content: \"\\f7af\";\n    }\n\n    .bi-5-square-fill::before {\n        content: \"\\f7b0\";\n    }\n\n    .bi-5-square::before {\n        content: \"\\f7b1\";\n    }\n\n    .bi-6-circle-fill::before {\n        content: \"\\f7b4\";\n    }\n\n    .bi-6-circle::before {\n        content: \"\\f7b5\";\n    }\n\n    .bi-6-square-fill::before {\n        content: \"\\f7b6\";\n    }\n\n    .bi-6-square::before {\n        content: \"\\f7b7\";\n    }\n\n    .bi-7-circle-fill::before {\n        content: \"\\f7ba\";\n    }\n\n    .bi-7-circle::before {\n        content: \"\\f7bb\";\n    }\n\n    .bi-7-square-fill::before {\n        content: \"\\f7bc\";\n    }\n\n    .bi-7-square::before {\n        content: \"\\f7bd\";\n    }\n\n    .bi-8-circle-fill::before {\n        content: \"\\f7c0\";\n    }\n\n    .bi-8-circle::before {\n        content: \"\\f7c1\";\n    }\n\n    .bi-8-square-fill::before {\n        content: \"\\f7c2\";\n    }\n\n    .bi-8-square::before {\n        content: \"\\f7c3\";\n    }\n\n    .bi-9-circle-fill::before {\n        content: \"\\f7c6\";\n    }\n\n    .bi-9-circle::before {\n        content: \"\\f7c7\";\n    }\n\n    .bi-9-square-fill::before {\n        content: \"\\f7c8\";\n    }\n\n    .bi-9-square::before {\n        content: \"\\f7c9\";\n    }\n\n    .bi-airplane-engines-fill::before {\n        content: \"\\f7ca\";\n    }\n\n    .bi-airplane-engines::before {\n        content: \"\\f7cb\";\n    }\n\n    .bi-airplane-fill::before {\n        content: \"\\f7cc\";\n    }\n\n    .bi-airplane::before {\n        content: \"\\f7cd\";\n    }\n\n    .bi-alexa::before {\n        content: \"\\f7ce\";\n    }\n\n    .bi-alipay::before {\n        content: \"\\f7cf\";\n    }\n\n    .bi-android::before {\n        content: \"\\f7d0\";\n    }\n\n    .bi-android2::before {\n        content: \"\\f7d1\";\n    }\n\n    .bi-box-fill::before {\n        content: \"\\f7d2\";\n    }\n\n    .bi-box-seam-fill::before {\n        content: \"\\f7d3\";\n    }\n\n    .bi-browser-chrome::before {\n        content: \"\\f7d4\";\n    }\n\n    .bi-browser-edge::before {\n        content: \"\\f7d5\";\n    }\n\n    .bi-browser-firefox::before {\n        content: \"\\f7d6\";\n    }\n\n    .bi-browser-safari::before {\n        content: \"\\f7d7\";\n    }\n\n    .bi-c-circle-fill::before {\n        content: \"\\f7da\";\n    }\n\n    .bi-c-circle::before {\n        content: \"\\f7db\";\n    }\n\n    .bi-c-square-fill::before {\n        content: \"\\f7dc\";\n    }\n\n    .bi-c-square::before {\n        content: \"\\f7dd\";\n    }\n\n    .bi-capsule-pill::before {\n        content: \"\\f7de\";\n    }\n\n    .bi-capsule::before {\n        content: \"\\f7df\";\n    }\n\n    .bi-car-front-fill::before {\n        content: \"\\f7e0\";\n    }\n\n    .bi-car-front::before {\n        content: \"\\f7e1\";\n    }\n\n    .bi-cassette-fill::before {\n        content: \"\\f7e2\";\n    }\n\n    .bi-cassette::before {\n        content: \"\\f7e3\";\n    }\n\n    .bi-cc-circle-fill::before {\n        content: \"\\f7e6\";\n    }\n\n    .bi-cc-circle::before {\n        content: \"\\f7e7\";\n    }\n\n    .bi-cc-square-fill::before {\n        content: \"\\f7e8\";\n    }\n\n    .bi-cc-square::before {\n        content: \"\\f7e9\";\n    }\n\n    .bi-cup-hot-fill::before {\n        content: \"\\f7ea\";\n    }\n\n    .bi-cup-hot::before {\n        content: \"\\f7eb\";\n    }\n\n    .bi-currency-rupee::before {\n        content: \"\\f7ec\";\n    }\n\n    .bi-dropbox::before {\n        content: \"\\f7ed\";\n    }\n\n    .bi-escape::before {\n        content: \"\\f7ee\";\n    }\n\n    .bi-fast-forward-btn-fill::before {\n        content: \"\\f7ef\";\n    }\n\n    .bi-fast-forward-btn::before {\n        content: \"\\f7f0\";\n    }\n\n    .bi-fast-forward-circle-fill::before {\n        content: \"\\f7f1\";\n    }\n\n    .bi-fast-forward-circle::before {\n        content: \"\\f7f2\";\n    }\n\n    .bi-fast-forward-fill::before {\n        content: \"\\f7f3\";\n    }\n\n    .bi-fast-forward::before {\n        content: \"\\f7f4\";\n    }\n\n    .bi-filetype-sql::before {\n        content: \"\\f7f5\";\n    }\n\n    .bi-fire::before {\n        content: \"\\f7f6\";\n    }\n\n    .bi-google-play::before {\n        content: \"\\f7f7\";\n    }\n\n    .bi-h-circle-fill::before {\n        content: \"\\f7fa\";\n    }\n\n    .bi-h-circle::before {\n        content: \"\\f7fb\";\n    }\n\n    .bi-h-square-fill::before {\n        content: \"\\f7fc\";\n    }\n\n    .bi-h-square::before {\n        content: \"\\f7fd\";\n    }\n\n    .bi-indent::before {\n        content: \"\\f7fe\";\n    }\n\n    .bi-lungs-fill::before {\n        content: \"\\f7ff\";\n    }\n\n    .bi-lungs::before {\n        content: \"\\f800\";\n    }\n\n    .bi-microsoft-teams::before {\n        content: \"\\f801\";\n    }\n\n    .bi-p-circle-fill::before {\n        content: \"\\f804\";\n    }\n\n    .bi-p-circle::before {\n        content: \"\\f805\";\n    }\n\n    .bi-p-square-fill::before {\n        content: \"\\f806\";\n    }\n\n    .bi-p-square::before {\n        content: \"\\f807\";\n    }\n\n    .bi-pass-fill::before {\n        content: \"\\f808\";\n    }\n\n    .bi-pass::before {\n        content: \"\\f809\";\n    }\n\n    .bi-prescription::before {\n        content: \"\\f80a\";\n    }\n\n    .bi-prescription2::before {\n        content: \"\\f80b\";\n    }\n\n    .bi-r-circle-fill::before {\n        content: \"\\f80e\";\n    }\n\n    .bi-r-circle::before {\n        content: \"\\f80f\";\n    }\n\n    .bi-r-square-fill::before {\n        content: \"\\f810\";\n    }\n\n    .bi-r-square::before {\n        content: \"\\f811\";\n    }\n\n    .bi-repeat-1::before {\n        content: \"\\f812\";\n    }\n\n    .bi-repeat::before {\n        content: \"\\f813\";\n    }\n\n    .bi-rewind-btn-fill::before {\n        content: \"\\f814\";\n    }\n\n    .bi-rewind-btn::before {\n        content: \"\\f815\";\n    }\n\n    .bi-rewind-circle-fill::before {\n        content: \"\\f816\";\n    }\n\n    .bi-rewind-circle::before {\n        content: \"\\f817\";\n    }\n\n    .bi-rewind-fill::before {\n        content: \"\\f818\";\n    }\n\n    .bi-rewind::before {\n        content: \"\\f819\";\n    }\n\n    .bi-train-freight-front-fill::before {\n        content: \"\\f81a\";\n    }\n\n    .bi-train-freight-front::before {\n        content: \"\\f81b\";\n    }\n\n    .bi-train-front-fill::before {\n        content: \"\\f81c\";\n    }\n\n    .bi-train-front::before {\n        content: \"\\f81d\";\n    }\n\n    .bi-train-lightrail-front-fill::before {\n        content: \"\\f81e\";\n    }\n\n    .bi-train-lightrail-front::before {\n        content: \"\\f81f\";\n    }\n\n    .bi-truck-front-fill::before {\n        content: \"\\f820\";\n    }\n\n    .bi-truck-front::before {\n        content: \"\\f821\";\n    }\n\n    .bi-ubuntu::before {\n        content: \"\\f822\";\n    }\n\n    .bi-unindent::before {\n        content: \"\\f823\";\n    }\n\n    .bi-unity::before {\n        content: \"\\f824\";\n    }\n\n    .bi-universal-access-circle::before {\n        content: \"\\f825\";\n    }\n\n    .bi-universal-access::before {\n        content: \"\\f826\";\n    }\n\n    .bi-virus::before {\n        content: \"\\f827\";\n    }\n\n    .bi-virus2::before {\n        content: \"\\f828\";\n    }\n\n    .bi-wechat::before {\n        content: \"\\f829\";\n    }\n\n    .bi-yelp::before {\n        content: \"\\f82a\";\n    }\n\n    .bi-sign-stop-fill::before {\n        content: \"\\f82b\";\n    }\n\n    .bi-sign-stop-lights-fill::before {\n        content: \"\\f82c\";\n    }\n\n    .bi-sign-stop-lights::before {\n        content: \"\\f82d\";\n    }\n\n    .bi-sign-stop::before {\n        content: \"\\f82e\";\n    }\n\n    .bi-sign-turn-left-fill::before {\n        content: \"\\f82f\";\n    }\n\n    .bi-sign-turn-left::before {\n        content: \"\\f830\";\n    }\n\n    .bi-sign-turn-right-fill::before {\n        content: \"\\f831\";\n    }\n\n    .bi-sign-turn-right::before {\n        content: \"\\f832\";\n    }\n\n    .bi-sign-turn-slight-left-fill::before {\n        content: \"\\f833\";\n    }\n\n    .bi-sign-turn-slight-left::before {\n        content: \"\\f834\";\n    }\n\n    .bi-sign-turn-slight-right-fill::before {\n        content: \"\\f835\";\n    }\n\n    .bi-sign-turn-slight-right::before {\n        content: \"\\f836\";\n    }\n\n    .bi-sign-yield-fill::before {\n        content: \"\\f837\";\n    }\n\n    .bi-sign-yield::before {\n        content: \"\\f838\";\n    }\n\n    .bi-ev-station-fill::before {\n        content: \"\\f839\";\n    }\n\n    .bi-ev-station::before {\n        content: \"\\f83a\";\n    }\n\n    .bi-fuel-pump-diesel-fill::before {\n        content: \"\\f83b\";\n    }\n\n    .bi-fuel-pump-diesel::before {\n        content: \"\\f83c\";\n    }\n\n    .bi-fuel-pump-fill::before {\n        content: \"\\f83d\";\n    }\n\n    .bi-fuel-pump::before {\n        content: \"\\f83e\";\n    }\n\n    .bi-0-circle-fill::before {\n        content: \"\\f83f\";\n    }\n\n    .bi-0-circle::before {\n        content: \"\\f840\";\n    }\n\n    .bi-0-square-fill::before {\n        content: \"\\f841\";\n    }\n\n    .bi-0-square::before {\n        content: \"\\f842\";\n    }\n\n    .bi-rocket-fill::before {\n        content: \"\\f843\";\n    }\n\n    .bi-rocket-takeoff-fill::before {\n        content: \"\\f844\";\n    }\n\n    .bi-rocket-takeoff::before {\n        content: \"\\f845\";\n    }\n\n    .bi-rocket::before {\n        content: \"\\f846\";\n    }\n\n    .bi-stripe::before {\n        content: \"\\f847\";\n    }\n\n    .bi-subscript::before {\n        content: \"\\f848\";\n    }\n\n    .bi-superscript::before {\n        content: \"\\f849\";\n    }\n\n    .bi-trello::before {\n        content: \"\\f84a\";\n    }\n\n    .bi-envelope-at-fill::before {\n        content: \"\\f84b\";\n    }\n\n    .bi-envelope-at::before {\n        content: \"\\f84c\";\n    }\n\n    .bi-regex::before {\n        content: \"\\f84d\";\n    }\n\n    .bi-text-wrap::before {\n        content: \"\\f84e\";\n    }\n\n    .bi-sign-dead-end-fill::before {\n        content: \"\\f84f\";\n    }\n\n    .bi-sign-dead-end::before {\n        content: \"\\f850\";\n    }\n\n    .bi-sign-do-not-enter-fill::before {\n        content: \"\\f851\";\n    }\n\n    .bi-sign-do-not-enter::before {\n        content: \"\\f852\";\n    }\n\n    .bi-sign-intersection-fill::before {\n        content: \"\\f853\";\n    }\n\n    .bi-sign-intersection-side-fill::before {\n        content: \"\\f854\";\n    }\n\n    .bi-sign-intersection-side::before {\n        content: \"\\f855\";\n    }\n\n    .bi-sign-intersection-t-fill::before {\n        content: \"\\f856\";\n    }\n\n    .bi-sign-intersection-t::before {\n        content: \"\\f857\";\n    }\n\n    .bi-sign-intersection-y-fill::before {\n        content: \"\\f858\";\n    }\n\n    .bi-sign-intersection-y::before {\n        content: \"\\f859\";\n    }\n\n    .bi-sign-intersection::before {\n        content: \"\\f85a\";\n    }\n\n    .bi-sign-merge-left-fill::before {\n        content: \"\\f85b\";\n    }\n\n    .bi-sign-merge-left::before {\n        content: \"\\f85c\";\n    }\n\n    .bi-sign-merge-right-fill::before {\n        content: \"\\f85d\";\n    }\n\n    .bi-sign-merge-right::before {\n        content: \"\\f85e\";\n    }\n\n    .bi-sign-no-left-turn-fill::before {\n        content: \"\\f85f\";\n    }\n\n    .bi-sign-no-left-turn::before {\n        content: \"\\f860\";\n    }\n\n    .bi-sign-no-parking-fill::before {\n        content: \"\\f861\";\n    }\n\n    .bi-sign-no-parking::before {\n        content: \"\\f862\";\n    }\n\n    .bi-sign-no-right-turn-fill::before {\n        content: \"\\f863\";\n    }\n\n    .bi-sign-no-right-turn::before {\n        content: \"\\f864\";\n    }\n\n    .bi-sign-railroad-fill::before {\n        content: \"\\f865\";\n    }\n\n    .bi-sign-railroad::before {\n        content: \"\\f866\";\n    }\n\n    .bi-building-add::before {\n        content: \"\\f867\";\n    }\n\n    .bi-building-check::before {\n        content: \"\\f868\";\n    }\n\n    .bi-building-dash::before {\n        content: \"\\f869\";\n    }\n\n    .bi-building-down::before {\n        content: \"\\f86a\";\n    }\n\n    .bi-building-exclamation::before {\n        content: \"\\f86b\";\n    }\n\n    .bi-building-fill-add::before {\n        content: \"\\f86c\";\n    }\n\n    .bi-building-fill-check::before {\n        content: \"\\f86d\";\n    }\n\n    .bi-building-fill-dash::before {\n        content: \"\\f86e\";\n    }\n\n    .bi-building-fill-down::before {\n        content: \"\\f86f\";\n    }\n\n    .bi-building-fill-exclamation::before {\n        content: \"\\f870\";\n    }\n\n    .bi-building-fill-gear::before {\n        content: \"\\f871\";\n    }\n\n    .bi-building-fill-lock::before {\n        content: \"\\f872\";\n    }\n\n    .bi-building-fill-slash::before {\n        content: \"\\f873\";\n    }\n\n    .bi-building-fill-up::before {\n        content: \"\\f874\";\n    }\n\n    .bi-building-fill-x::before {\n        content: \"\\f875\";\n    }\n\n    .bi-building-fill::before {\n        content: \"\\f876\";\n    }\n\n    .bi-building-gear::before {\n        content: \"\\f877\";\n    }\n\n    .bi-building-lock::before {\n        content: \"\\f878\";\n    }\n\n    .bi-building-slash::before {\n        content: \"\\f879\";\n    }\n\n    .bi-building-up::before {\n        content: \"\\f87a\";\n    }\n\n    .bi-building-x::before {\n        content: \"\\f87b\";\n    }\n\n    .bi-buildings-fill::before {\n        content: \"\\f87c\";\n    }\n\n    .bi-buildings::before {\n        content: \"\\f87d\";\n    }\n\n    .bi-bus-front-fill::before {\n        content: \"\\f87e\";\n    }\n\n    .bi-bus-front::before {\n        content: \"\\f87f\";\n    }\n\n    .bi-ev-front-fill::before {\n        content: \"\\f880\";\n    }\n\n    .bi-ev-front::before {\n        content: \"\\f881\";\n    }\n\n    .bi-globe-americas::before {\n        content: \"\\f882\";\n    }\n\n    .bi-globe-asia-australia::before {\n        content: \"\\f883\";\n    }\n\n    .bi-globe-central-south-asia::before {\n        content: \"\\f884\";\n    }\n\n    .bi-globe-europe-africa::before {\n        content: \"\\f885\";\n    }\n\n    .bi-house-add-fill::before {\n        content: \"\\f886\";\n    }\n\n    .bi-house-add::before {\n        content: \"\\f887\";\n    }\n\n    .bi-house-check-fill::before {\n        content: \"\\f888\";\n    }\n\n    .bi-house-check::before {\n        content: \"\\f889\";\n    }\n\n    .bi-house-dash-fill::before {\n        content: \"\\f88a\";\n    }\n\n    .bi-house-dash::before {\n        content: \"\\f88b\";\n    }\n\n    .bi-house-down-fill::before {\n        content: \"\\f88c\";\n    }\n\n    .bi-house-down::before {\n        content: \"\\f88d\";\n    }\n\n    .bi-house-exclamation-fill::before {\n        content: \"\\f88e\";\n    }\n\n    .bi-house-exclamation::before {\n        content: \"\\f88f\";\n    }\n\n    .bi-house-gear-fill::before {\n        content: \"\\f890\";\n    }\n\n    .bi-house-gear::before {\n        content: \"\\f891\";\n    }\n\n    .bi-house-lock-fill::before {\n        content: \"\\f892\";\n    }\n\n    .bi-house-lock::before {\n        content: \"\\f893\";\n    }\n\n    .bi-house-slash-fill::before {\n        content: \"\\f894\";\n    }\n\n    .bi-house-slash::before {\n        content: \"\\f895\";\n    }\n\n    .bi-house-up-fill::before {\n        content: \"\\f896\";\n    }\n\n    .bi-house-up::before {\n        content: \"\\f897\";\n    }\n\n    .bi-house-x-fill::before {\n        content: \"\\f898\";\n    }\n\n    .bi-house-x::before {\n        content: \"\\f899\";\n    }\n\n    .bi-person-add::before {\n        content: \"\\f89a\";\n    }\n\n    .bi-person-down::before {\n        content: \"\\f89b\";\n    }\n\n    .bi-person-exclamation::before {\n        content: \"\\f89c\";\n    }\n\n    .bi-person-fill-add::before {\n        content: \"\\f89d\";\n    }\n\n    .bi-person-fill-check::before {\n        content: \"\\f89e\";\n    }\n\n    .bi-person-fill-dash::before {\n        content: \"\\f89f\";\n    }\n\n    .bi-person-fill-down::before {\n        content: \"\\f8a0\";\n    }\n\n    .bi-person-fill-exclamation::before {\n        content: \"\\f8a1\";\n    }\n\n    .bi-person-fill-gear::before {\n        content: \"\\f8a2\";\n    }\n\n    .bi-person-fill-lock::before {\n        content: \"\\f8a3\";\n    }\n\n    .bi-person-fill-slash::before {\n        content: \"\\f8a4\";\n    }\n\n    .bi-person-fill-up::before {\n        content: \"\\f8a5\";\n    }\n\n    .bi-person-fill-x::before {\n        content: \"\\f8a6\";\n    }\n\n    .bi-person-gear::before {\n        content: \"\\f8a7\";\n    }\n\n    .bi-person-lock::before {\n        content: \"\\f8a8\";\n    }\n\n    .bi-person-slash::before {\n        content: \"\\f8a9\";\n    }\n\n    .bi-person-up::before {\n        content: \"\\f8aa\";\n    }\n\n    .bi-scooter::before {\n        content: \"\\f8ab\";\n    }\n\n    .bi-taxi-front-fill::before {\n        content: \"\\f8ac\";\n    }\n\n    .bi-taxi-front::before {\n        content: \"\\f8ad\";\n    }\n\n    .bi-amd::before {\n        content: \"\\f8ae\";\n    }\n\n    .bi-database-add::before {\n        content: \"\\f8af\";\n    }\n\n    .bi-database-check::before {\n        content: \"\\f8b0\";\n    }\n\n    .bi-database-dash::before {\n        content: \"\\f8b1\";\n    }\n\n    .bi-database-down::before {\n        content: \"\\f8b2\";\n    }\n\n    .bi-database-exclamation::before {\n        content: \"\\f8b3\";\n    }\n\n    .bi-database-fill-add::before {\n        content: \"\\f8b4\";\n    }\n\n    .bi-database-fill-check::before {\n        content: \"\\f8b5\";\n    }\n\n    .bi-database-fill-dash::before {\n        content: \"\\f8b6\";\n    }\n\n    .bi-database-fill-down::before {\n        content: \"\\f8b7\";\n    }\n\n    .bi-database-fill-exclamation::before {\n        content: \"\\f8b8\";\n    }\n\n    .bi-database-fill-gear::before {\n        content: \"\\f8b9\";\n    }\n\n    .bi-database-fill-lock::before {\n        content: \"\\f8ba\";\n    }\n\n    .bi-database-fill-slash::before {\n        content: \"\\f8bb\";\n    }\n\n    .bi-database-fill-up::before {\n        content: \"\\f8bc\";\n    }\n\n    .bi-database-fill-x::before {\n        content: \"\\f8bd\";\n    }\n\n    .bi-database-fill::before {\n        content: \"\\f8be\";\n    }\n\n    .bi-database-gear::before {\n        content: \"\\f8bf\";\n    }\n\n    .bi-database-lock::before {\n        content: \"\\f8c0\";\n    }\n\n    .bi-database-slash::before {\n        content: \"\\f8c1\";\n    }\n\n    .bi-database-up::before {\n        content: \"\\f8c2\";\n    }\n\n    .bi-database-x::before {\n        content: \"\\f8c3\";\n    }\n\n    .bi-database::before {\n        content: \"\\f8c4\";\n    }\n\n    .bi-houses-fill::before {\n        content: \"\\f8c5\";\n    }\n\n    .bi-houses::before {\n        content: \"\\f8c6\";\n    }\n\n    .bi-nvidia::before {\n        content: \"\\f8c7\";\n    }\n\n    .bi-person-vcard-fill::before {\n        content: \"\\f8c8\";\n    }\n\n    .bi-person-vcard::before {\n        content: \"\\f8c9\";\n    }\n\n    .bi-sina-weibo::before {\n        content: \"\\f8ca\";\n    }\n\n    .bi-tencent-qq::before {\n        content: \"\\f8cb\";\n    }\n\n    .bi-wikipedia::before {\n        content: \"\\f8cc\";\n    }\n\n    .bi-alphabet-uppercase::before {\n        content: \"\\f2a5\";\n    }\n\n    .bi-alphabet::before {\n        content: \"\\f68a\";\n    }\n\n    .bi-amazon::before {\n        content: \"\\f68d\";\n    }\n\n    .bi-arrows-collapse-vertical::before {\n        content: \"\\f690\";\n    }\n\n    .bi-arrows-expand-vertical::before {\n        content: \"\\f695\";\n    }\n\n    .bi-arrows-vertical::before {\n        content: \"\\f698\";\n    }\n\n    .bi-arrows::before {\n        content: \"\\f6a2\";\n    }\n\n    .bi-ban-fill::before {\n        content: \"\\f6a3\";\n    }\n\n    .bi-ban::before {\n        content: \"\\f6b6\";\n    }\n\n    .bi-bing::before {\n        content: \"\\f6c2\";\n    }\n\n    .bi-cake::before {\n        content: \"\\f6e0\";\n    }\n\n    .bi-cake2::before {\n        content: \"\\f6ed\";\n    }\n\n    .bi-cookie::before {\n        content: \"\\f6ee\";\n    }\n\n    .bi-copy::before {\n        content: \"\\f759\";\n    }\n\n    .bi-crosshair::before {\n        content: \"\\f769\";\n    }\n\n    .bi-crosshair2::before {\n        content: \"\\f794\";\n    }\n\n    .bi-emoji-astonished-fill::before {\n        content: \"\\f795\";\n    }\n\n    .bi-emoji-astonished::before {\n        content: \"\\f79a\";\n    }\n\n    .bi-emoji-grimace-fill::before {\n        content: \"\\f79b\";\n    }\n\n    .bi-emoji-grimace::before {\n        content: \"\\f7a0\";\n    }\n\n    .bi-emoji-grin-fill::before {\n        content: \"\\f7a1\";\n    }\n\n    .bi-emoji-grin::before {\n        content: \"\\f7a6\";\n    }\n\n    .bi-emoji-surprise-fill::before {\n        content: \"\\f7a7\";\n    }\n\n    .bi-emoji-surprise::before {\n        content: \"\\f7ac\";\n    }\n\n    .bi-emoji-tear-fill::before {\n        content: \"\\f7ad\";\n    }\n\n    .bi-emoji-tear::before {\n        content: \"\\f7b2\";\n    }\n\n    .bi-envelope-arrow-down-fill::before {\n        content: \"\\f7b3\";\n    }\n\n    .bi-envelope-arrow-down::before {\n        content: \"\\f7b8\";\n    }\n\n    .bi-envelope-arrow-up-fill::before {\n        content: \"\\f7b9\";\n    }\n\n    .bi-envelope-arrow-up::before {\n        content: \"\\f7be\";\n    }\n\n    .bi-feather::before {\n        content: \"\\f7bf\";\n    }\n\n    .bi-feather2::before {\n        content: \"\\f7c4\";\n    }\n\n    .bi-floppy-fill::before {\n        content: \"\\f7c5\";\n    }\n\n    .bi-floppy::before {\n        content: \"\\f7d8\";\n    }\n\n    .bi-floppy2-fill::before {\n        content: \"\\f7d9\";\n    }\n\n    .bi-floppy2::before {\n        content: \"\\f7e4\";\n    }\n\n    .bi-gitlab::before {\n        content: \"\\f7e5\";\n    }\n\n    .bi-highlighter::before {\n        content: \"\\f7f8\";\n    }\n\n    .bi-marker-tip::before {\n        content: \"\\f802\";\n    }\n\n    .bi-nvme-fill::before {\n        content: \"\\f803\";\n    }\n\n    .bi-nvme::before {\n        content: \"\\f80c\";\n    }\n\n    .bi-opencollective::before {\n        content: \"\\f80d\";\n    }\n\n    .bi-pci-card-network::before {\n        content: \"\\f8cd\";\n    }\n\n    .bi-pci-card-sound::before {\n        content: \"\\f8ce\";\n    }\n\n    .bi-radar::before {\n        content: \"\\f8cf\";\n    }\n\n    .bi-send-arrow-down-fill::before {\n        content: \"\\f8d0\";\n    }\n\n    .bi-send-arrow-down::before {\n        content: \"\\f8d1\";\n    }\n\n    .bi-send-arrow-up-fill::before {\n        content: \"\\f8d2\";\n    }\n\n    .bi-send-arrow-up::before {\n        content: \"\\f8d3\";\n    }\n\n    .bi-sim-slash-fill::before {\n        content: \"\\f8d4\";\n    }\n\n    .bi-sim-slash::before {\n        content: \"\\f8d5\";\n    }\n\n    .bi-sourceforge::before {\n        content: \"\\f8d6\";\n    }\n\n    .bi-substack::before {\n        content: \"\\f8d7\";\n    }\n\n    .bi-threads-fill::before {\n        content: \"\\f8d8\";\n    }\n\n    .bi-threads::before {\n        content: \"\\f8d9\";\n    }\n\n    .bi-transparency::before {\n        content: \"\\f8da\";\n    }\n\n    .bi-twitter-x::before {\n        content: \"\\f8db\";\n    }\n\n    .bi-type-h4::before {\n        content: \"\\f8dc\";\n    }\n\n    .bi-type-h5::before {\n        content: \"\\f8dd\";\n    }\n\n    .bi-type-h6::before {\n        content: \"\\f8de\";\n    }\n\n    .bi-backpack-fill::before {\n        content: \"\\f8df\";\n    }\n\n    .bi-backpack::before {\n        content: \"\\f8e0\";\n    }\n\n    .bi-backpack2-fill::before {\n        content: \"\\f8e1\";\n    }\n\n    .bi-backpack2::before {\n        content: \"\\f8e2\";\n    }\n\n    .bi-backpack3-fill::before {\n        content: \"\\f8e3\";\n    }\n\n    .bi-backpack3::before {\n        content: \"\\f8e4\";\n    }\n\n    .bi-backpack4-fill::before {\n        content: \"\\f8e5\";\n    }\n\n    .bi-backpack4::before {\n        content: \"\\f8e6\";\n    }\n\n    .bi-brilliance::before {\n        content: \"\\f8e7\";\n    }\n\n    .bi-cake-fill::before {\n        content: \"\\f8e8\";\n    }\n\n    .bi-cake2-fill::before {\n        content: \"\\f8e9\";\n    }\n\n    .bi-duffle-fill::before {\n        content: \"\\f8ea\";\n    }\n\n    .bi-duffle::before {\n        content: \"\\f8eb\";\n    }\n\n    .bi-exposure::before {\n        content: \"\\f8ec\";\n    }\n\n    .bi-gender-neuter::before {\n        content: \"\\f8ed\";\n    }\n\n    .bi-highlights::before {\n        content: \"\\f8ee\";\n    }\n\n    .bi-luggage-fill::before {\n        content: \"\\f8ef\";\n    }\n\n    .bi-luggage::before {\n        content: \"\\f8f0\";\n    }\n\n    .bi-mailbox-flag::before {\n        content: \"\\f8f1\";\n    }\n\n    .bi-mailbox2-flag::before {\n        content: \"\\f8f2\";\n    }\n\n    .bi-noise-reduction::before {\n        content: \"\\f8f3\";\n    }\n\n    .bi-passport-fill::before {\n        content: \"\\f8f4\";\n    }\n\n    .bi-passport::before {\n        content: \"\\f8f5\";\n    }\n\n    .bi-person-arms-up::before {\n        content: \"\\f8f6\";\n    }\n\n    .bi-person-raised-hand::before {\n        content: \"\\f8f7\";\n    }\n\n    .bi-person-standing-dress::before {\n        content: \"\\f8f8\";\n    }\n\n    .bi-person-standing::before {\n        content: \"\\f8f9\";\n    }\n\n    .bi-person-walking::before {\n        content: \"\\f8fa\";\n    }\n\n    .bi-person-wheelchair::before {\n        content: \"\\f8fb\";\n    }\n\n    .bi-shadows::before {\n        content: \"\\f8fc\";\n    }\n\n    .bi-suitcase-fill::before {\n        content: \"\\f8fd\";\n    }\n\n    .bi-suitcase-lg-fill::before {\n        content: \"\\f8fe\";\n    }\n\n    .bi-suitcase-lg::before {\n        content: \"\\f8ff\";\n    }\n\n    .bi-suitcase::before {\n        content: \"\\f900\";\n    }\n\n    .bi-suitcase2-fill::before {\n        content: \"\\f901\";\n    }\n\n    .bi-suitcase2::before {\n        content: \"\\f902\";\n    }\n\n    .bi-vignette::before {\n        content: \"\\f903\";\n    }\n"], ["\n    .bi::before,\n    [class^=\"bi-\"]::before,\n    [class*=\" bi-\"]::before {\n        display: inline-block;\n        font-family: bootstrap-icons !important;\n        font-style: normal;\n        font-weight: normal !important;\n        font-variant: normal;\n        text-transform: none;\n        line-height: 1;\n\t\tvertical-align: middle;\n        -webkit-font-smoothing: antialiased;\n        -moz-osx-font-smoothing: grayscale;\n    }\n\n    .bi-123::before {\n        content: \"\\\\f67f\";\n    }\n\n    .bi-alarm-fill::before {\n        content: \"\\\\f101\";\n    }\n\n    .bi-alarm::before {\n        content: \"\\\\f102\";\n    }\n\n    .bi-align-bottom::before {\n        content: \"\\\\f103\";\n    }\n\n    .bi-align-center::before {\n        content: \"\\\\f104\";\n    }\n\n    .bi-align-end::before {\n        content: \"\\\\f105\";\n    }\n\n    .bi-align-middle::before {\n        content: \"\\\\f106\";\n    }\n\n    .bi-align-start::before {\n        content: \"\\\\f107\";\n    }\n\n    .bi-align-top::before {\n        content: \"\\\\f108\";\n    }\n\n    .bi-alt::before {\n        content: \"\\\\f109\";\n    }\n\n    .bi-app-indicator::before {\n        content: \"\\\\f10a\";\n    }\n\n    .bi-app::before {\n        content: \"\\\\f10b\";\n    }\n\n    .bi-archive-fill::before {\n        content: \"\\\\f10c\";\n    }\n\n    .bi-archive::before {\n        content: \"\\\\f10d\";\n    }\n\n    .bi-arrow-90deg-down::before {\n        content: \"\\\\f10e\";\n    }\n\n    .bi-arrow-90deg-left::before {\n        content: \"\\\\f10f\";\n    }\n\n    .bi-arrow-90deg-right::before {\n        content: \"\\\\f110\";\n    }\n\n    .bi-arrow-90deg-up::before {\n        content: \"\\\\f111\";\n    }\n\n    .bi-arrow-bar-down::before {\n        content: \"\\\\f112\";\n    }\n\n    .bi-arrow-bar-left::before {\n        content: \"\\\\f113\";\n    }\n\n    .bi-arrow-bar-right::before {\n        content: \"\\\\f114\";\n    }\n\n    .bi-arrow-bar-up::before {\n        content: \"\\\\f115\";\n    }\n\n    .bi-arrow-clockwise::before {\n        content: \"\\\\f116\";\n    }\n\n    .bi-arrow-counterclockwise::before {\n        content: \"\\\\f117\";\n    }\n\n    .bi-arrow-down-circle-fill::before {\n        content: \"\\\\f118\";\n    }\n\n    .bi-arrow-down-circle::before {\n        content: \"\\\\f119\";\n    }\n\n    .bi-arrow-down-left-circle-fill::before {\n        content: \"\\\\f11a\";\n    }\n\n    .bi-arrow-down-left-circle::before {\n        content: \"\\\\f11b\";\n    }\n\n    .bi-arrow-down-left-square-fill::before {\n        content: \"\\\\f11c\";\n    }\n\n    .bi-arrow-down-left-square::before {\n        content: \"\\\\f11d\";\n    }\n\n    .bi-arrow-down-left::before {\n        content: \"\\\\f11e\";\n    }\n\n    .bi-arrow-down-right-circle-fill::before {\n        content: \"\\\\f11f\";\n    }\n\n    .bi-arrow-down-right-circle::before {\n        content: \"\\\\f120\";\n    }\n\n    .bi-arrow-down-right-square-fill::before {\n        content: \"\\\\f121\";\n    }\n\n    .bi-arrow-down-right-square::before {\n        content: \"\\\\f122\";\n    }\n\n    .bi-arrow-down-right::before {\n        content: \"\\\\f123\";\n    }\n\n    .bi-arrow-down-short::before {\n        content: \"\\\\f124\";\n    }\n\n    .bi-arrow-down-square-fill::before {\n        content: \"\\\\f125\";\n    }\n\n    .bi-arrow-down-square::before {\n        content: \"\\\\f126\";\n    }\n\n    .bi-arrow-down-up::before {\n        content: \"\\\\f127\";\n    }\n\n    .bi-arrow-down::before {\n        content: \"\\\\f128\";\n    }\n\n    .bi-arrow-left-circle-fill::before {\n        content: \"\\\\f129\";\n    }\n\n    .bi-arrow-left-circle::before {\n        content: \"\\\\f12a\";\n    }\n\n    .bi-arrow-left-right::before {\n        content: \"\\\\f12b\";\n    }\n\n    .bi-arrow-left-short::before {\n        content: \"\\\\f12c\";\n    }\n\n    .bi-arrow-left-square-fill::before {\n        content: \"\\\\f12d\";\n    }\n\n    .bi-arrow-left-square::before {\n        content: \"\\\\f12e\";\n    }\n\n    .bi-arrow-left::before {\n        content: \"\\\\f12f\";\n    }\n\n    .bi-arrow-repeat::before {\n        content: \"\\\\f130\";\n    }\n\n    .bi-arrow-return-left::before {\n        content: \"\\\\f131\";\n    }\n\n    .bi-arrow-return-right::before {\n        content: \"\\\\f132\";\n    }\n\n    .bi-arrow-right-circle-fill::before {\n        content: \"\\\\f133\";\n    }\n\n    .bi-arrow-right-circle::before {\n        content: \"\\\\f134\";\n    }\n\n    .bi-arrow-right-short::before {\n        content: \"\\\\f135\";\n    }\n\n    .bi-arrow-right-square-fill::before {\n        content: \"\\\\f136\";\n    }\n\n    .bi-arrow-right-square::before {\n        content: \"\\\\f137\";\n    }\n\n    .bi-arrow-right::before {\n        content: \"\\\\f138\";\n    }\n\n    .bi-arrow-up-circle-fill::before {\n        content: \"\\\\f139\";\n    }\n\n    .bi-arrow-up-circle::before {\n        content: \"\\\\f13a\";\n    }\n\n    .bi-arrow-up-left-circle-fill::before {\n        content: \"\\\\f13b\";\n    }\n\n    .bi-arrow-up-left-circle::before {\n        content: \"\\\\f13c\";\n    }\n\n    .bi-arrow-up-left-square-fill::before {\n        content: \"\\\\f13d\";\n    }\n\n    .bi-arrow-up-left-square::before {\n        content: \"\\\\f13e\";\n    }\n\n    .bi-arrow-up-left::before {\n        content: \"\\\\f13f\";\n    }\n\n    .bi-arrow-up-right-circle-fill::before {\n        content: \"\\\\f140\";\n    }\n\n    .bi-arrow-up-right-circle::before {\n        content: \"\\\\f141\";\n    }\n\n    .bi-arrow-up-right-square-fill::before {\n        content: \"\\\\f142\";\n    }\n\n    .bi-arrow-up-right-square::before {\n        content: \"\\\\f143\";\n    }\n\n    .bi-arrow-up-right::before {\n        content: \"\\\\f144\";\n    }\n\n    .bi-arrow-up-short::before {\n        content: \"\\\\f145\";\n    }\n\n    .bi-arrow-up-square-fill::before {\n        content: \"\\\\f146\";\n    }\n\n    .bi-arrow-up-square::before {\n        content: \"\\\\f147\";\n    }\n\n    .bi-arrow-up::before {\n        content: \"\\\\f148\";\n    }\n\n    .bi-arrows-angle-contract::before {\n        content: \"\\\\f149\";\n    }\n\n    .bi-arrows-angle-expand::before {\n        content: \"\\\\f14a\";\n    }\n\n    .bi-arrows-collapse::before {\n        content: \"\\\\f14b\";\n    }\n\n    .bi-arrows-expand::before {\n        content: \"\\\\f14c\";\n    }\n\n    .bi-arrows-fullscreen::before {\n        content: \"\\\\f14d\";\n    }\n\n    .bi-arrows-move::before {\n        content: \"\\\\f14e\";\n    }\n\n    .bi-aspect-ratio-fill::before {\n        content: \"\\\\f14f\";\n    }\n\n    .bi-aspect-ratio::before {\n        content: \"\\\\f150\";\n    }\n\n    .bi-asterisk::before {\n        content: \"\\\\f151\";\n    }\n\n    .bi-at::before {\n        content: \"\\\\f152\";\n    }\n\n    .bi-award-fill::before {\n        content: \"\\\\f153\";\n    }\n\n    .bi-award::before {\n        content: \"\\\\f154\";\n    }\n\n    .bi-back::before {\n        content: \"\\\\f155\";\n    }\n\n    .bi-backspace-fill::before {\n        content: \"\\\\f156\";\n    }\n\n    .bi-backspace-reverse-fill::before {\n        content: \"\\\\f157\";\n    }\n\n    .bi-backspace-reverse::before {\n        content: \"\\\\f158\";\n    }\n\n    .bi-backspace::before {\n        content: \"\\\\f159\";\n    }\n\n    .bi-badge-3d-fill::before {\n        content: \"\\\\f15a\";\n    }\n\n    .bi-badge-3d::before {\n        content: \"\\\\f15b\";\n    }\n\n    .bi-badge-4k-fill::before {\n        content: \"\\\\f15c\";\n    }\n\n    .bi-badge-4k::before {\n        content: \"\\\\f15d\";\n    }\n\n    .bi-badge-8k-fill::before {\n        content: \"\\\\f15e\";\n    }\n\n    .bi-badge-8k::before {\n        content: \"\\\\f15f\";\n    }\n\n    .bi-badge-ad-fill::before {\n        content: \"\\\\f160\";\n    }\n\n    .bi-badge-ad::before {\n        content: \"\\\\f161\";\n    }\n\n    .bi-badge-ar-fill::before {\n        content: \"\\\\f162\";\n    }\n\n    .bi-badge-ar::before {\n        content: \"\\\\f163\";\n    }\n\n    .bi-badge-cc-fill::before {\n        content: \"\\\\f164\";\n    }\n\n    .bi-badge-cc::before {\n        content: \"\\\\f165\";\n    }\n\n    .bi-badge-hd-fill::before {\n        content: \"\\\\f166\";\n    }\n\n    .bi-badge-hd::before {\n        content: \"\\\\f167\";\n    }\n\n    .bi-badge-tm-fill::before {\n        content: \"\\\\f168\";\n    }\n\n    .bi-badge-tm::before {\n        content: \"\\\\f169\";\n    }\n\n    .bi-badge-vo-fill::before {\n        content: \"\\\\f16a\";\n    }\n\n    .bi-badge-vo::before {\n        content: \"\\\\f16b\";\n    }\n\n    .bi-badge-vr-fill::before {\n        content: \"\\\\f16c\";\n    }\n\n    .bi-badge-vr::before {\n        content: \"\\\\f16d\";\n    }\n\n    .bi-badge-wc-fill::before {\n        content: \"\\\\f16e\";\n    }\n\n    .bi-badge-wc::before {\n        content: \"\\\\f16f\";\n    }\n\n    .bi-bag-check-fill::before {\n        content: \"\\\\f170\";\n    }\n\n    .bi-bag-check::before {\n        content: \"\\\\f171\";\n    }\n\n    .bi-bag-dash-fill::before {\n        content: \"\\\\f172\";\n    }\n\n    .bi-bag-dash::before {\n        content: \"\\\\f173\";\n    }\n\n    .bi-bag-fill::before {\n        content: \"\\\\f174\";\n    }\n\n    .bi-bag-plus-fill::before {\n        content: \"\\\\f175\";\n    }\n\n    .bi-bag-plus::before {\n        content: \"\\\\f176\";\n    }\n\n    .bi-bag-x-fill::before {\n        content: \"\\\\f177\";\n    }\n\n    .bi-bag-x::before {\n        content: \"\\\\f178\";\n    }\n\n    .bi-bag::before {\n        content: \"\\\\f179\";\n    }\n\n    .bi-bar-chart-fill::before {\n        content: \"\\\\f17a\";\n    }\n\n    .bi-bar-chart-line-fill::before {\n        content: \"\\\\f17b\";\n    }\n\n    .bi-bar-chart-line::before {\n        content: \"\\\\f17c\";\n    }\n\n    .bi-bar-chart-steps::before {\n        content: \"\\\\f17d\";\n    }\n\n    .bi-bar-chart::before {\n        content: \"\\\\f17e\";\n    }\n\n    .bi-basket-fill::before {\n        content: \"\\\\f17f\";\n    }\n\n    .bi-basket::before {\n        content: \"\\\\f180\";\n    }\n\n    .bi-basket2-fill::before {\n        content: \"\\\\f181\";\n    }\n\n    .bi-basket2::before {\n        content: \"\\\\f182\";\n    }\n\n    .bi-basket3-fill::before {\n        content: \"\\\\f183\";\n    }\n\n    .bi-basket3::before {\n        content: \"\\\\f184\";\n    }\n\n    .bi-battery-charging::before {\n        content: \"\\\\f185\";\n    }\n\n    .bi-battery-full::before {\n        content: \"\\\\f186\";\n    }\n\n    .bi-battery-half::before {\n        content: \"\\\\f187\";\n    }\n\n    .bi-battery::before {\n        content: \"\\\\f188\";\n    }\n\n    .bi-bell-fill::before {\n        content: \"\\\\f189\";\n    }\n\n    .bi-bell::before {\n        content: \"\\\\f18a\";\n    }\n\n    .bi-bezier::before {\n        content: \"\\\\f18b\";\n    }\n\n    .bi-bezier2::before {\n        content: \"\\\\f18c\";\n    }\n\n    .bi-bicycle::before {\n        content: \"\\\\f18d\";\n    }\n\n    .bi-binoculars-fill::before {\n        content: \"\\\\f18e\";\n    }\n\n    .bi-binoculars::before {\n        content: \"\\\\f18f\";\n    }\n\n    .bi-blockquote-left::before {\n        content: \"\\\\f190\";\n    }\n\n    .bi-blockquote-right::before {\n        content: \"\\\\f191\";\n    }\n\n    .bi-book-fill::before {\n        content: \"\\\\f192\";\n    }\n\n    .bi-book-half::before {\n        content: \"\\\\f193\";\n    }\n\n    .bi-book::before {\n        content: \"\\\\f194\";\n    }\n\n    .bi-bookmark-check-fill::before {\n        content: \"\\\\f195\";\n    }\n\n    .bi-bookmark-check::before {\n        content: \"\\\\f196\";\n    }\n\n    .bi-bookmark-dash-fill::before {\n        content: \"\\\\f197\";\n    }\n\n    .bi-bookmark-dash::before {\n        content: \"\\\\f198\";\n    }\n\n    .bi-bookmark-fill::before {\n        content: \"\\\\f199\";\n    }\n\n    .bi-bookmark-heart-fill::before {\n        content: \"\\\\f19a\";\n    }\n\n    .bi-bookmark-heart::before {\n        content: \"\\\\f19b\";\n    }\n\n    .bi-bookmark-plus-fill::before {\n        content: \"\\\\f19c\";\n    }\n\n    .bi-bookmark-plus::before {\n        content: \"\\\\f19d\";\n    }\n\n    .bi-bookmark-star-fill::before {\n        content: \"\\\\f19e\";\n    }\n\n    .bi-bookmark-star::before {\n        content: \"\\\\f19f\";\n    }\n\n    .bi-bookmark-x-fill::before {\n        content: \"\\\\f1a0\";\n    }\n\n    .bi-bookmark-x::before {\n        content: \"\\\\f1a1\";\n    }\n\n    .bi-bookmark::before {\n        content: \"\\\\f1a2\";\n    }\n\n    .bi-bookmarks-fill::before {\n        content: \"\\\\f1a3\";\n    }\n\n    .bi-bookmarks::before {\n        content: \"\\\\f1a4\";\n    }\n\n    .bi-bookshelf::before {\n        content: \"\\\\f1a5\";\n    }\n\n    .bi-bootstrap-fill::before {\n        content: \"\\\\f1a6\";\n    }\n\n    .bi-bootstrap-reboot::before {\n        content: \"\\\\f1a7\";\n    }\n\n    .bi-bootstrap::before {\n        content: \"\\\\f1a8\";\n    }\n\n    .bi-border-all::before {\n        content: \"\\\\f1a9\";\n    }\n\n    .bi-border-bottom::before {\n        content: \"\\\\f1aa\";\n    }\n\n    .bi-border-center::before {\n        content: \"\\\\f1ab\";\n    }\n\n    .bi-border-inner::before {\n        content: \"\\\\f1ac\";\n    }\n\n    .bi-border-left::before {\n        content: \"\\\\f1ad\";\n    }\n\n    .bi-border-middle::before {\n        content: \"\\\\f1ae\";\n    }\n\n    .bi-border-outer::before {\n        content: \"\\\\f1af\";\n    }\n\n    .bi-border-right::before {\n        content: \"\\\\f1b0\";\n    }\n\n    .bi-border-style::before {\n        content: \"\\\\f1b1\";\n    }\n\n    .bi-border-top::before {\n        content: \"\\\\f1b2\";\n    }\n\n    .bi-border-width::before {\n        content: \"\\\\f1b3\";\n    }\n\n    .bi-border::before {\n        content: \"\\\\f1b4\";\n    }\n\n    .bi-bounding-box-circles::before {\n        content: \"\\\\f1b5\";\n    }\n\n    .bi-bounding-box::before {\n        content: \"\\\\f1b6\";\n    }\n\n    .bi-box-arrow-down-left::before {\n        content: \"\\\\f1b7\";\n    }\n\n    .bi-box-arrow-down-right::before {\n        content: \"\\\\f1b8\";\n    }\n\n    .bi-box-arrow-down::before {\n        content: \"\\\\f1b9\";\n    }\n\n    .bi-box-arrow-in-down-left::before {\n        content: \"\\\\f1ba\";\n    }\n\n    .bi-box-arrow-in-down-right::before {\n        content: \"\\\\f1bb\";\n    }\n\n    .bi-box-arrow-in-down::before {\n        content: \"\\\\f1bc\";\n    }\n\n    .bi-box-arrow-in-left::before {\n        content: \"\\\\f1bd\";\n    }\n\n    .bi-box-arrow-in-right::before {\n        content: \"\\\\f1be\";\n    }\n\n    .bi-box-arrow-in-up-left::before {\n        content: \"\\\\f1bf\";\n    }\n\n    .bi-box-arrow-in-up-right::before {\n        content: \"\\\\f1c0\";\n    }\n\n    .bi-box-arrow-in-up::before {\n        content: \"\\\\f1c1\";\n    }\n\n    .bi-box-arrow-left::before {\n        content: \"\\\\f1c2\";\n    }\n\n    .bi-box-arrow-right::before {\n        content: \"\\\\f1c3\";\n    }\n\n    .bi-box-arrow-up-left::before {\n        content: \"\\\\f1c4\";\n    }\n\n    .bi-box-arrow-up-right::before {\n        content: \"\\\\f1c5\";\n    }\n\n    .bi-box-arrow-up::before {\n        content: \"\\\\f1c6\";\n    }\n\n    .bi-box-seam::before {\n        content: \"\\\\f1c7\";\n    }\n\n    .bi-box::before {\n        content: \"\\\\f1c8\";\n    }\n\n    .bi-braces::before {\n        content: \"\\\\f1c9\";\n    }\n\n    .bi-bricks::before {\n        content: \"\\\\f1ca\";\n    }\n\n    .bi-briefcase-fill::before {\n        content: \"\\\\f1cb\";\n    }\n\n    .bi-briefcase::before {\n        content: \"\\\\f1cc\";\n    }\n\n    .bi-brightness-alt-high-fill::before {\n        content: \"\\\\f1cd\";\n    }\n\n    .bi-brightness-alt-high::before {\n        content: \"\\\\f1ce\";\n    }\n\n    .bi-brightness-alt-low-fill::before {\n        content: \"\\\\f1cf\";\n    }\n\n    .bi-brightness-alt-low::before {\n        content: \"\\\\f1d0\";\n    }\n\n    .bi-brightness-high-fill::before {\n        content: \"\\\\f1d1\";\n    }\n\n    .bi-brightness-high::before {\n        content: \"\\\\f1d2\";\n    }\n\n    .bi-brightness-low-fill::before {\n        content: \"\\\\f1d3\";\n    }\n\n    .bi-brightness-low::before {\n        content: \"\\\\f1d4\";\n    }\n\n    .bi-broadcast-pin::before {\n        content: \"\\\\f1d5\";\n    }\n\n    .bi-broadcast::before {\n        content: \"\\\\f1d6\";\n    }\n\n    .bi-brush-fill::before {\n        content: \"\\\\f1d7\";\n    }\n\n    .bi-brush::before {\n        content: \"\\\\f1d8\";\n    }\n\n    .bi-bucket-fill::before {\n        content: \"\\\\f1d9\";\n    }\n\n    .bi-bucket::before {\n        content: \"\\\\f1da\";\n    }\n\n    .bi-bug-fill::before {\n        content: \"\\\\f1db\";\n    }\n\n    .bi-bug::before {\n        content: \"\\\\f1dc\";\n    }\n\n    .bi-building::before {\n        content: \"\\\\f1dd\";\n    }\n\n    .bi-bullseye::before {\n        content: \"\\\\f1de\";\n    }\n\n    .bi-calculator-fill::before {\n        content: \"\\\\f1df\";\n    }\n\n    .bi-calculator::before {\n        content: \"\\\\f1e0\";\n    }\n\n    .bi-calendar-check-fill::before {\n        content: \"\\\\f1e1\";\n    }\n\n    .bi-calendar-check::before {\n        content: \"\\\\f1e2\";\n    }\n\n    .bi-calendar-date-fill::before {\n        content: \"\\\\f1e3\";\n    }\n\n    .bi-calendar-date::before {\n        content: \"\\\\f1e4\";\n    }\n\n    .bi-calendar-day-fill::before {\n        content: \"\\\\f1e5\";\n    }\n\n    .bi-calendar-day::before {\n        content: \"\\\\f1e6\";\n    }\n\n    .bi-calendar-event-fill::before {\n        content: \"\\\\f1e7\";\n    }\n\n    .bi-calendar-event::before {\n        content: \"\\\\f1e8\";\n    }\n\n    .bi-calendar-fill::before {\n        content: \"\\\\f1e9\";\n    }\n\n    .bi-calendar-minus-fill::before {\n        content: \"\\\\f1ea\";\n    }\n\n    .bi-calendar-minus::before {\n        content: \"\\\\f1eb\";\n    }\n\n    .bi-calendar-month-fill::before {\n        content: \"\\\\f1ec\";\n    }\n\n    .bi-calendar-month::before {\n        content: \"\\\\f1ed\";\n    }\n\n    .bi-calendar-plus-fill::before {\n        content: \"\\\\f1ee\";\n    }\n\n    .bi-calendar-plus::before {\n        content: \"\\\\f1ef\";\n    }\n\n    .bi-calendar-range-fill::before {\n        content: \"\\\\f1f0\";\n    }\n\n    .bi-calendar-range::before {\n        content: \"\\\\f1f1\";\n    }\n\n    .bi-calendar-week-fill::before {\n        content: \"\\\\f1f2\";\n    }\n\n    .bi-calendar-week::before {\n        content: \"\\\\f1f3\";\n    }\n\n    .bi-calendar-x-fill::before {\n        content: \"\\\\f1f4\";\n    }\n\n    .bi-calendar-x::before {\n        content: \"\\\\f1f5\";\n    }\n\n    .bi-calendar::before {\n        content: \"\\\\f1f6\";\n    }\n\n    .bi-calendar2-check-fill::before {\n        content: \"\\\\f1f7\";\n    }\n\n    .bi-calendar2-check::before {\n        content: \"\\\\f1f8\";\n    }\n\n    .bi-calendar2-date-fill::before {\n        content: \"\\\\f1f9\";\n    }\n\n    .bi-calendar2-date::before {\n        content: \"\\\\f1fa\";\n    }\n\n    .bi-calendar2-day-fill::before {\n        content: \"\\\\f1fb\";\n    }\n\n    .bi-calendar2-day::before {\n        content: \"\\\\f1fc\";\n    }\n\n    .bi-calendar2-event-fill::before {\n        content: \"\\\\f1fd\";\n    }\n\n    .bi-calendar2-event::before {\n        content: \"\\\\f1fe\";\n    }\n\n    .bi-calendar2-fill::before {\n        content: \"\\\\f1ff\";\n    }\n\n    .bi-calendar2-minus-fill::before {\n        content: \"\\\\f200\";\n    }\n\n    .bi-calendar2-minus::before {\n        content: \"\\\\f201\";\n    }\n\n    .bi-calendar2-month-fill::before {\n        content: \"\\\\f202\";\n    }\n\n    .bi-calendar2-month::before {\n        content: \"\\\\f203\";\n    }\n\n    .bi-calendar2-plus-fill::before {\n        content: \"\\\\f204\";\n    }\n\n    .bi-calendar2-plus::before {\n        content: \"\\\\f205\";\n    }\n\n    .bi-calendar2-range-fill::before {\n        content: \"\\\\f206\";\n    }\n\n    .bi-calendar2-range::before {\n        content: \"\\\\f207\";\n    }\n\n    .bi-calendar2-week-fill::before {\n        content: \"\\\\f208\";\n    }\n\n    .bi-calendar2-week::before {\n        content: \"\\\\f209\";\n    }\n\n    .bi-calendar2-x-fill::before {\n        content: \"\\\\f20a\";\n    }\n\n    .bi-calendar2-x::before {\n        content: \"\\\\f20b\";\n    }\n\n    .bi-calendar2::before {\n        content: \"\\\\f20c\";\n    }\n\n    .bi-calendar3-event-fill::before {\n        content: \"\\\\f20d\";\n    }\n\n    .bi-calendar3-event::before {\n        content: \"\\\\f20e\";\n    }\n\n    .bi-calendar3-fill::before {\n        content: \"\\\\f20f\";\n    }\n\n    .bi-calendar3-range-fill::before {\n        content: \"\\\\f210\";\n    }\n\n    .bi-calendar3-range::before {\n        content: \"\\\\f211\";\n    }\n\n    .bi-calendar3-week-fill::before {\n        content: \"\\\\f212\";\n    }\n\n    .bi-calendar3-week::before {\n        content: \"\\\\f213\";\n    }\n\n    .bi-calendar3::before {\n        content: \"\\\\f214\";\n    }\n\n    .bi-calendar4-event::before {\n        content: \"\\\\f215\";\n    }\n\n    .bi-calendar4-range::before {\n        content: \"\\\\f216\";\n    }\n\n    .bi-calendar4-week::before {\n        content: \"\\\\f217\";\n    }\n\n    .bi-calendar4::before {\n        content: \"\\\\f218\";\n    }\n\n    .bi-camera-fill::before {\n        content: \"\\\\f219\";\n    }\n\n    .bi-camera-reels-fill::before {\n        content: \"\\\\f21a\";\n    }\n\n    .bi-camera-reels::before {\n        content: \"\\\\f21b\";\n    }\n\n    .bi-camera-video-fill::before {\n        content: \"\\\\f21c\";\n    }\n\n    .bi-camera-video-off-fill::before {\n        content: \"\\\\f21d\";\n    }\n\n    .bi-camera-video-off::before {\n        content: \"\\\\f21e\";\n    }\n\n    .bi-camera-video::before {\n        content: \"\\\\f21f\";\n    }\n\n    .bi-camera::before {\n        content: \"\\\\f220\";\n    }\n\n    .bi-camera2::before {\n        content: \"\\\\f221\";\n    }\n\n    .bi-capslock-fill::before {\n        content: \"\\\\f222\";\n    }\n\n    .bi-capslock::before {\n        content: \"\\\\f223\";\n    }\n\n    .bi-card-checklist::before {\n        content: \"\\\\f224\";\n    }\n\n    .bi-card-heading::before {\n        content: \"\\\\f225\";\n    }\n\n    .bi-card-image::before {\n        content: \"\\\\f226\";\n    }\n\n    .bi-card-list::before {\n        content: \"\\\\f227\";\n    }\n\n    .bi-card-text::before {\n        content: \"\\\\f228\";\n    }\n\n    .bi-caret-down-fill::before {\n        content: \"\\\\f229\";\n    }\n\n    .bi-caret-down-square-fill::before {\n        content: \"\\\\f22a\";\n    }\n\n    .bi-caret-down-square::before {\n        content: \"\\\\f22b\";\n    }\n\n    .bi-caret-down::before {\n        content: \"\\\\f22c\";\n    }\n\n    .bi-caret-left-fill::before {\n        content: \"\\\\f22d\";\n    }\n\n    .bi-caret-left-square-fill::before {\n        content: \"\\\\f22e\";\n    }\n\n    .bi-caret-left-square::before {\n        content: \"\\\\f22f\";\n    }\n\n    .bi-caret-left::before {\n        content: \"\\\\f230\";\n    }\n\n    .bi-caret-right-fill::before {\n        content: \"\\\\f231\";\n    }\n\n    .bi-caret-right-square-fill::before {\n        content: \"\\\\f232\";\n    }\n\n    .bi-caret-right-square::before {\n        content: \"\\\\f233\";\n    }\n\n    .bi-caret-right::before {\n        content: \"\\\\f234\";\n    }\n\n    .bi-caret-up-fill::before {\n        content: \"\\\\f235\";\n    }\n\n    .bi-caret-up-square-fill::before {\n        content: \"\\\\f236\";\n    }\n\n    .bi-caret-up-square::before {\n        content: \"\\\\f237\";\n    }\n\n    .bi-caret-up::before {\n        content: \"\\\\f238\";\n    }\n\n    .bi-cart-check-fill::before {\n        content: \"\\\\f239\";\n    }\n\n    .bi-cart-check::before {\n        content: \"\\\\f23a\";\n    }\n\n    .bi-cart-dash-fill::before {\n        content: \"\\\\f23b\";\n    }\n\n    .bi-cart-dash::before {\n        content: \"\\\\f23c\";\n    }\n\n    .bi-cart-fill::before {\n        content: \"\\\\f23d\";\n    }\n\n    .bi-cart-plus-fill::before {\n        content: \"\\\\f23e\";\n    }\n\n    .bi-cart-plus::before {\n        content: \"\\\\f23f\";\n    }\n\n    .bi-cart-x-fill::before {\n        content: \"\\\\f240\";\n    }\n\n    .bi-cart-x::before {\n        content: \"\\\\f241\";\n    }\n\n    .bi-cart::before {\n        content: \"\\\\f242\";\n    }\n\n    .bi-cart2::before {\n        content: \"\\\\f243\";\n    }\n\n    .bi-cart3::before {\n        content: \"\\\\f244\";\n    }\n\n    .bi-cart4::before {\n        content: \"\\\\f245\";\n    }\n\n    .bi-cash-stack::before {\n        content: \"\\\\f246\";\n    }\n\n    .bi-cash::before {\n        content: \"\\\\f247\";\n    }\n\n    .bi-cast::before {\n        content: \"\\\\f248\";\n    }\n\n    .bi-chat-dots-fill::before {\n        content: \"\\\\f249\";\n    }\n\n    .bi-chat-dots::before {\n        content: \"\\\\f24a\";\n    }\n\n    .bi-chat-fill::before {\n        content: \"\\\\f24b\";\n    }\n\n    .bi-chat-left-dots-fill::before {\n        content: \"\\\\f24c\";\n    }\n\n    .bi-chat-left-dots::before {\n        content: \"\\\\f24d\";\n    }\n\n    .bi-chat-left-fill::before {\n        content: \"\\\\f24e\";\n    }\n\n    .bi-chat-left-quote-fill::before {\n        content: \"\\\\f24f\";\n    }\n\n    .bi-chat-left-quote::before {\n        content: \"\\\\f250\";\n    }\n\n    .bi-chat-left-text-fill::before {\n        content: \"\\\\f251\";\n    }\n\n    .bi-chat-left-text::before {\n        content: \"\\\\f252\";\n    }\n\n    .bi-chat-left::before {\n        content: \"\\\\f253\";\n    }\n\n    .bi-chat-quote-fill::before {\n        content: \"\\\\f254\";\n    }\n\n    .bi-chat-quote::before {\n        content: \"\\\\f255\";\n    }\n\n    .bi-chat-right-dots-fill::before {\n        content: \"\\\\f256\";\n    }\n\n    .bi-chat-right-dots::before {\n        content: \"\\\\f257\";\n    }\n\n    .bi-chat-right-fill::before {\n        content: \"\\\\f258\";\n    }\n\n    .bi-chat-right-quote-fill::before {\n        content: \"\\\\f259\";\n    }\n\n    .bi-chat-right-quote::before {\n        content: \"\\\\f25a\";\n    }\n\n    .bi-chat-right-text-fill::before {\n        content: \"\\\\f25b\";\n    }\n\n    .bi-chat-right-text::before {\n        content: \"\\\\f25c\";\n    }\n\n    .bi-chat-right::before {\n        content: \"\\\\f25d\";\n    }\n\n    .bi-chat-square-dots-fill::before {\n        content: \"\\\\f25e\";\n    }\n\n    .bi-chat-square-dots::before {\n        content: \"\\\\f25f\";\n    }\n\n    .bi-chat-square-fill::before {\n        content: \"\\\\f260\";\n    }\n\n    .bi-chat-square-quote-fill::before {\n        content: \"\\\\f261\";\n    }\n\n    .bi-chat-square-quote::before {\n        content: \"\\\\f262\";\n    }\n\n    .bi-chat-square-text-fill::before {\n        content: \"\\\\f263\";\n    }\n\n    .bi-chat-square-text::before {\n        content: \"\\\\f264\";\n    }\n\n    .bi-chat-square::before {\n        content: \"\\\\f265\";\n    }\n\n    .bi-chat-text-fill::before {\n        content: \"\\\\f266\";\n    }\n\n    .bi-chat-text::before {\n        content: \"\\\\f267\";\n    }\n\n    .bi-chat::before {\n        content: \"\\\\f268\";\n    }\n\n    .bi-check-all::before {\n        content: \"\\\\f269\";\n    }\n\n    .bi-check-circle-fill::before {\n        content: \"\\\\f26a\";\n    }\n\n    .bi-check-circle::before {\n        content: \"\\\\f26b\";\n    }\n\n    .bi-check-square-fill::before {\n        content: \"\\\\f26c\";\n    }\n\n    .bi-check-square::before {\n        content: \"\\\\f26d\";\n    }\n\n    .bi-check::before {\n        content: \"\\\\f26e\";\n    }\n\n    .bi-check2-all::before {\n        content: \"\\\\f26f\";\n    }\n\n    .bi-check2-circle::before {\n        content: \"\\\\f270\";\n    }\n\n    .bi-check2-square::before {\n        content: \"\\\\f271\";\n    }\n\n    .bi-check2::before {\n        content: \"\\\\f272\";\n    }\n\n    .bi-chevron-bar-contract::before {\n        content: \"\\\\f273\";\n    }\n\n    .bi-chevron-bar-down::before {\n        content: \"\\\\f274\";\n    }\n\n    .bi-chevron-bar-expand::before {\n        content: \"\\\\f275\";\n    }\n\n    .bi-chevron-bar-left::before {\n        content: \"\\\\f276\";\n    }\n\n    .bi-chevron-bar-right::before {\n        content: \"\\\\f277\";\n    }\n\n    .bi-chevron-bar-up::before {\n        content: \"\\\\f278\";\n    }\n\n    .bi-chevron-compact-down::before {\n        content: \"\\\\f279\";\n    }\n\n    .bi-chevron-compact-left::before {\n        content: \"\\\\f27a\";\n    }\n\n    .bi-chevron-compact-right::before {\n        content: \"\\\\f27b\";\n    }\n\n    .bi-chevron-compact-up::before {\n        content: \"\\\\f27c\";\n    }\n\n    .bi-chevron-contract::before {\n        content: \"\\\\f27d\";\n    }\n\n    .bi-chevron-double-down::before {\n        content: \"\\\\f27e\";\n    }\n\n    .bi-chevron-double-left::before {\n        content: \"\\\\f27f\";\n    }\n\n    .bi-chevron-double-right::before {\n        content: \"\\\\f280\";\n    }\n\n    .bi-chevron-double-up::before {\n        content: \"\\\\f281\";\n    }\n\n    .bi-chevron-down::before {\n        content: \"\\\\f282\";\n    }\n\n    .bi-chevron-expand::before {\n        content: \"\\\\f283\";\n    }\n\n    .bi-chevron-left::before {\n        content: \"\\\\f284\";\n    }\n\n    .bi-chevron-right::before {\n        content: \"\\\\f285\";\n    }\n\n    .bi-chevron-up::before {\n        content: \"\\\\f286\";\n    }\n\n    .bi-circle-fill::before {\n        content: \"\\\\f287\";\n    }\n\n    .bi-circle-half::before {\n        content: \"\\\\f288\";\n    }\n\n    .bi-circle-square::before {\n        content: \"\\\\f289\";\n    }\n\n    .bi-circle::before {\n        content: \"\\\\f28a\";\n    }\n\n    .bi-clipboard-check::before {\n        content: \"\\\\f28b\";\n    }\n\n    .bi-clipboard-data::before {\n        content: \"\\\\f28c\";\n    }\n\n    .bi-clipboard-minus::before {\n        content: \"\\\\f28d\";\n    }\n\n    .bi-clipboard-plus::before {\n        content: \"\\\\f28e\";\n    }\n\n    .bi-clipboard-x::before {\n        content: \"\\\\f28f\";\n    }\n\n    .bi-clipboard::before {\n        content: \"\\\\f290\";\n    }\n\n    .bi-clock-fill::before {\n        content: \"\\\\f291\";\n    }\n\n    .bi-clock-history::before {\n        content: \"\\\\f292\";\n    }\n\n    .bi-clock::before {\n        content: \"\\\\f293\";\n    }\n\n    .bi-cloud-arrow-down-fill::before {\n        content: \"\\\\f294\";\n    }\n\n    .bi-cloud-arrow-down::before {\n        content: \"\\\\f295\";\n    }\n\n    .bi-cloud-arrow-up-fill::before {\n        content: \"\\\\f296\";\n    }\n\n    .bi-cloud-arrow-up::before {\n        content: \"\\\\f297\";\n    }\n\n    .bi-cloud-check-fill::before {\n        content: \"\\\\f298\";\n    }\n\n    .bi-cloud-check::before {\n        content: \"\\\\f299\";\n    }\n\n    .bi-cloud-download-fill::before {\n        content: \"\\\\f29a\";\n    }\n\n    .bi-cloud-download::before {\n        content: \"\\\\f29b\";\n    }\n\n    .bi-cloud-drizzle-fill::before {\n        content: \"\\\\f29c\";\n    }\n\n    .bi-cloud-drizzle::before {\n        content: \"\\\\f29d\";\n    }\n\n    .bi-cloud-fill::before {\n        content: \"\\\\f29e\";\n    }\n\n    .bi-cloud-fog-fill::before {\n        content: \"\\\\f29f\";\n    }\n\n    .bi-cloud-fog::before {\n        content: \"\\\\f2a0\";\n    }\n\n    .bi-cloud-fog2-fill::before {\n        content: \"\\\\f2a1\";\n    }\n\n    .bi-cloud-fog2::before {\n        content: \"\\\\f2a2\";\n    }\n\n    .bi-cloud-hail-fill::before {\n        content: \"\\\\f2a3\";\n    }\n\n    .bi-cloud-hail::before {\n        content: \"\\\\f2a4\";\n    }\n\n    .bi-cloud-haze-fill::before {\n        content: \"\\\\f2a6\";\n    }\n\n    .bi-cloud-haze::before {\n        content: \"\\\\f2a7\";\n    }\n\n    .bi-cloud-haze2-fill::before {\n        content: \"\\\\f2a8\";\n    }\n\n    .bi-cloud-lightning-fill::before {\n        content: \"\\\\f2a9\";\n    }\n\n    .bi-cloud-lightning-rain-fill::before {\n        content: \"\\\\f2aa\";\n    }\n\n    .bi-cloud-lightning-rain::before {\n        content: \"\\\\f2ab\";\n    }\n\n    .bi-cloud-lightning::before {\n        content: \"\\\\f2ac\";\n    }\n\n    .bi-cloud-minus-fill::before {\n        content: \"\\\\f2ad\";\n    }\n\n    .bi-cloud-minus::before {\n        content: \"\\\\f2ae\";\n    }\n\n    .bi-cloud-moon-fill::before {\n        content: \"\\\\f2af\";\n    }\n\n    .bi-cloud-moon::before {\n        content: \"\\\\f2b0\";\n    }\n\n    .bi-cloud-plus-fill::before {\n        content: \"\\\\f2b1\";\n    }\n\n    .bi-cloud-plus::before {\n        content: \"\\\\f2b2\";\n    }\n\n    .bi-cloud-rain-fill::before {\n        content: \"\\\\f2b3\";\n    }\n\n    .bi-cloud-rain-heavy-fill::before {\n        content: \"\\\\f2b4\";\n    }\n\n    .bi-cloud-rain-heavy::before {\n        content: \"\\\\f2b5\";\n    }\n\n    .bi-cloud-rain::before {\n        content: \"\\\\f2b6\";\n    }\n\n    .bi-cloud-slash-fill::before {\n        content: \"\\\\f2b7\";\n    }\n\n    .bi-cloud-slash::before {\n        content: \"\\\\f2b8\";\n    }\n\n    .bi-cloud-sleet-fill::before {\n        content: \"\\\\f2b9\";\n    }\n\n    .bi-cloud-sleet::before {\n        content: \"\\\\f2ba\";\n    }\n\n    .bi-cloud-snow-fill::before {\n        content: \"\\\\f2bb\";\n    }\n\n    .bi-cloud-snow::before {\n        content: \"\\\\f2bc\";\n    }\n\n    .bi-cloud-sun-fill::before {\n        content: \"\\\\f2bd\";\n    }\n\n    .bi-cloud-sun::before {\n        content: \"\\\\f2be\";\n    }\n\n    .bi-cloud-upload-fill::before {\n        content: \"\\\\f2bf\";\n    }\n\n    .bi-cloud-upload::before {\n        content: \"\\\\f2c0\";\n    }\n\n    .bi-cloud::before {\n        content: \"\\\\f2c1\";\n    }\n\n    .bi-clouds-fill::before {\n        content: \"\\\\f2c2\";\n    }\n\n    .bi-clouds::before {\n        content: \"\\\\f2c3\";\n    }\n\n    .bi-cloudy-fill::before {\n        content: \"\\\\f2c4\";\n    }\n\n    .bi-cloudy::before {\n        content: \"\\\\f2c5\";\n    }\n\n    .bi-code-slash::before {\n        content: \"\\\\f2c6\";\n    }\n\n    .bi-code-square::before {\n        content: \"\\\\f2c7\";\n    }\n\n    .bi-code::before {\n        content: \"\\\\f2c8\";\n    }\n\n    .bi-collection-fill::before {\n        content: \"\\\\f2c9\";\n    }\n\n    .bi-collection-play-fill::before {\n        content: \"\\\\f2ca\";\n    }\n\n    .bi-collection-play::before {\n        content: \"\\\\f2cb\";\n    }\n\n    .bi-collection::before {\n        content: \"\\\\f2cc\";\n    }\n\n    .bi-columns-gap::before {\n        content: \"\\\\f2cd\";\n    }\n\n    .bi-columns::before {\n        content: \"\\\\f2ce\";\n    }\n\n    .bi-command::before {\n        content: \"\\\\f2cf\";\n    }\n\n    .bi-compass-fill::before {\n        content: \"\\\\f2d0\";\n    }\n\n    .bi-compass::before {\n        content: \"\\\\f2d1\";\n    }\n\n    .bi-cone-striped::before {\n        content: \"\\\\f2d2\";\n    }\n\n    .bi-cone::before {\n        content: \"\\\\f2d3\";\n    }\n\n    .bi-controller::before {\n        content: \"\\\\f2d4\";\n    }\n\n    .bi-cpu-fill::before {\n        content: \"\\\\f2d5\";\n    }\n\n    .bi-cpu::before {\n        content: \"\\\\f2d6\";\n    }\n\n    .bi-credit-card-2-back-fill::before {\n        content: \"\\\\f2d7\";\n    }\n\n    .bi-credit-card-2-back::before {\n        content: \"\\\\f2d8\";\n    }\n\n    .bi-credit-card-2-front-fill::before {\n        content: \"\\\\f2d9\";\n    }\n\n    .bi-credit-card-2-front::before {\n        content: \"\\\\f2da\";\n    }\n\n    .bi-credit-card-fill::before {\n        content: \"\\\\f2db\";\n    }\n\n    .bi-credit-card::before {\n        content: \"\\\\f2dc\";\n    }\n\n    .bi-crop::before {\n        content: \"\\\\f2dd\";\n    }\n\n    .bi-cup-fill::before {\n        content: \"\\\\f2de\";\n    }\n\n    .bi-cup-straw::before {\n        content: \"\\\\f2df\";\n    }\n\n    .bi-cup::before {\n        content: \"\\\\f2e0\";\n    }\n\n    .bi-cursor-fill::before {\n        content: \"\\\\f2e1\";\n    }\n\n    .bi-cursor-text::before {\n        content: \"\\\\f2e2\";\n    }\n\n    .bi-cursor::before {\n        content: \"\\\\f2e3\";\n    }\n\n    .bi-dash-circle-dotted::before {\n        content: \"\\\\f2e4\";\n    }\n\n    .bi-dash-circle-fill::before {\n        content: \"\\\\f2e5\";\n    }\n\n    .bi-dash-circle::before {\n        content: \"\\\\f2e6\";\n    }\n\n    .bi-dash-square-dotted::before {\n        content: \"\\\\f2e7\";\n    }\n\n    .bi-dash-square-fill::before {\n        content: \"\\\\f2e8\";\n    }\n\n    .bi-dash-square::before {\n        content: \"\\\\f2e9\";\n    }\n\n    .bi-dash::before {\n        content: \"\\\\f2ea\";\n    }\n\n    .bi-diagram-2-fill::before {\n        content: \"\\\\f2eb\";\n    }\n\n    .bi-diagram-2::before {\n        content: \"\\\\f2ec\";\n    }\n\n    .bi-diagram-3-fill::before {\n        content: \"\\\\f2ed\";\n    }\n\n    .bi-diagram-3::before {\n        content: \"\\\\f2ee\";\n    }\n\n    .bi-diamond-fill::before {\n        content: \"\\\\f2ef\";\n    }\n\n    .bi-diamond-half::before {\n        content: \"\\\\f2f0\";\n    }\n\n    .bi-diamond::before {\n        content: \"\\\\f2f1\";\n    }\n\n    .bi-dice-1-fill::before {\n        content: \"\\\\f2f2\";\n    }\n\n    .bi-dice-1::before {\n        content: \"\\\\f2f3\";\n    }\n\n    .bi-dice-2-fill::before {\n        content: \"\\\\f2f4\";\n    }\n\n    .bi-dice-2::before {\n        content: \"\\\\f2f5\";\n    }\n\n    .bi-dice-3-fill::before {\n        content: \"\\\\f2f6\";\n    }\n\n    .bi-dice-3::before {\n        content: \"\\\\f2f7\";\n    }\n\n    .bi-dice-4-fill::before {\n        content: \"\\\\f2f8\";\n    }\n\n    .bi-dice-4::before {\n        content: \"\\\\f2f9\";\n    }\n\n    .bi-dice-5-fill::before {\n        content: \"\\\\f2fa\";\n    }\n\n    .bi-dice-5::before {\n        content: \"\\\\f2fb\";\n    }\n\n    .bi-dice-6-fill::before {\n        content: \"\\\\f2fc\";\n    }\n\n    .bi-dice-6::before {\n        content: \"\\\\f2fd\";\n    }\n\n    .bi-disc-fill::before {\n        content: \"\\\\f2fe\";\n    }\n\n    .bi-disc::before {\n        content: \"\\\\f2ff\";\n    }\n\n    .bi-discord::before {\n        content: \"\\\\f300\";\n    }\n\n    .bi-display-fill::before {\n        content: \"\\\\f301\";\n    }\n\n    .bi-display::before {\n        content: \"\\\\f302\";\n    }\n\n    .bi-distribute-horizontal::before {\n        content: \"\\\\f303\";\n    }\n\n    .bi-distribute-vertical::before {\n        content: \"\\\\f304\";\n    }\n\n    .bi-door-closed-fill::before {\n        content: \"\\\\f305\";\n    }\n\n    .bi-door-closed::before {\n        content: \"\\\\f306\";\n    }\n\n    .bi-door-open-fill::before {\n        content: \"\\\\f307\";\n    }\n\n    .bi-door-open::before {\n        content: \"\\\\f308\";\n    }\n\n    .bi-dot::before {\n        content: \"\\\\f309\";\n    }\n\n    .bi-download::before {\n        content: \"\\\\f30a\";\n    }\n\n    .bi-droplet-fill::before {\n        content: \"\\\\f30b\";\n    }\n\n    .bi-droplet-half::before {\n        content: \"\\\\f30c\";\n    }\n\n    .bi-droplet::before {\n        content: \"\\\\f30d\";\n    }\n\n    .bi-earbuds::before {\n        content: \"\\\\f30e\";\n    }\n\n    .bi-easel-fill::before {\n        content: \"\\\\f30f\";\n    }\n\n    .bi-easel::before {\n        content: \"\\\\f310\";\n    }\n\n    .bi-egg-fill::before {\n        content: \"\\\\f311\";\n    }\n\n    .bi-egg-fried::before {\n        content: \"\\\\f312\";\n    }\n\n    .bi-egg::before {\n        content: \"\\\\f313\";\n    }\n\n    .bi-eject-fill::before {\n        content: \"\\\\f314\";\n    }\n\n    .bi-eject::before {\n        content: \"\\\\f315\";\n    }\n\n    .bi-emoji-angry-fill::before {\n        content: \"\\\\f316\";\n    }\n\n    .bi-emoji-angry::before {\n        content: \"\\\\f317\";\n    }\n\n    .bi-emoji-dizzy-fill::before {\n        content: \"\\\\f318\";\n    }\n\n    .bi-emoji-dizzy::before {\n        content: \"\\\\f319\";\n    }\n\n    .bi-emoji-expressionless-fill::before {\n        content: \"\\\\f31a\";\n    }\n\n    .bi-emoji-expressionless::before {\n        content: \"\\\\f31b\";\n    }\n\n    .bi-emoji-frown-fill::before {\n        content: \"\\\\f31c\";\n    }\n\n    .bi-emoji-frown::before {\n        content: \"\\\\f31d\";\n    }\n\n    .bi-emoji-heart-eyes-fill::before {\n        content: \"\\\\f31e\";\n    }\n\n    .bi-emoji-heart-eyes::before {\n        content: \"\\\\f31f\";\n    }\n\n    .bi-emoji-laughing-fill::before {\n        content: \"\\\\f320\";\n    }\n\n    .bi-emoji-laughing::before {\n        content: \"\\\\f321\";\n    }\n\n    .bi-emoji-neutral-fill::before {\n        content: \"\\\\f322\";\n    }\n\n    .bi-emoji-neutral::before {\n        content: \"\\\\f323\";\n    }\n\n    .bi-emoji-smile-fill::before {\n        content: \"\\\\f324\";\n    }\n\n    .bi-emoji-smile-upside-down-fill::before {\n        content: \"\\\\f325\";\n    }\n\n    .bi-emoji-smile-upside-down::before {\n        content: \"\\\\f326\";\n    }\n\n    .bi-emoji-smile::before {\n        content: \"\\\\f327\";\n    }\n\n    .bi-emoji-sunglasses-fill::before {\n        content: \"\\\\f328\";\n    }\n\n    .bi-emoji-sunglasses::before {\n        content: \"\\\\f329\";\n    }\n\n    .bi-emoji-wink-fill::before {\n        content: \"\\\\f32a\";\n    }\n\n    .bi-emoji-wink::before {\n        content: \"\\\\f32b\";\n    }\n\n    .bi-envelope-fill::before {\n        content: \"\\\\f32c\";\n    }\n\n    .bi-envelope-open-fill::before {\n        content: \"\\\\f32d\";\n    }\n\n    .bi-envelope-open::before {\n        content: \"\\\\f32e\";\n    }\n\n    .bi-envelope::before {\n        content: \"\\\\f32f\";\n    }\n\n    .bi-eraser-fill::before {\n        content: \"\\\\f330\";\n    }\n\n    .bi-eraser::before {\n        content: \"\\\\f331\";\n    }\n\n    .bi-exclamation-circle-fill::before {\n        content: \"\\\\f332\";\n    }\n\n    .bi-exclamation-circle::before {\n        content: \"\\\\f333\";\n    }\n\n    .bi-exclamation-diamond-fill::before {\n        content: \"\\\\f334\";\n    }\n\n    .bi-exclamation-diamond::before {\n        content: \"\\\\f335\";\n    }\n\n    .bi-exclamation-octagon-fill::before {\n        content: \"\\\\f336\";\n    }\n\n    .bi-exclamation-octagon::before {\n        content: \"\\\\f337\";\n    }\n\n    .bi-exclamation-square-fill::before {\n        content: \"\\\\f338\";\n    }\n\n    .bi-exclamation-square::before {\n        content: \"\\\\f339\";\n    }\n\n    .bi-exclamation-triangle-fill::before {\n        content: \"\\\\f33a\";\n    }\n\n    .bi-exclamation-triangle::before {\n        content: \"\\\\f33b\";\n    }\n\n    .bi-exclamation::before {\n        content: \"\\\\f33c\";\n    }\n\n    .bi-exclude::before {\n        content: \"\\\\f33d\";\n    }\n\n    .bi-eye-fill::before {\n        content: \"\\\\f33e\";\n    }\n\n    .bi-eye-slash-fill::before {\n        content: \"\\\\f33f\";\n    }\n\n    .bi-eye-slash::before {\n        content: \"\\\\f340\";\n    }\n\n    .bi-eye::before {\n        content: \"\\\\f341\";\n    }\n\n    .bi-eyedropper::before {\n        content: \"\\\\f342\";\n    }\n\n    .bi-eyeglasses::before {\n        content: \"\\\\f343\";\n    }\n\n    .bi-facebook::before {\n        content: \"\\\\f344\";\n    }\n\n    .bi-file-arrow-down-fill::before {\n        content: \"\\\\f345\";\n    }\n\n    .bi-file-arrow-down::before {\n        content: \"\\\\f346\";\n    }\n\n    .bi-file-arrow-up-fill::before {\n        content: \"\\\\f347\";\n    }\n\n    .bi-file-arrow-up::before {\n        content: \"\\\\f348\";\n    }\n\n    .bi-file-bar-graph-fill::before {\n        content: \"\\\\f349\";\n    }\n\n    .bi-file-bar-graph::before {\n        content: \"\\\\f34a\";\n    }\n\n    .bi-file-binary-fill::before {\n        content: \"\\\\f34b\";\n    }\n\n    .bi-file-binary::before {\n        content: \"\\\\f34c\";\n    }\n\n    .bi-file-break-fill::before {\n        content: \"\\\\f34d\";\n    }\n\n    .bi-file-break::before {\n        content: \"\\\\f34e\";\n    }\n\n    .bi-file-check-fill::before {\n        content: \"\\\\f34f\";\n    }\n\n    .bi-file-check::before {\n        content: \"\\\\f350\";\n    }\n\n    .bi-file-code-fill::before {\n        content: \"\\\\f351\";\n    }\n\n    .bi-file-code::before {\n        content: \"\\\\f352\";\n    }\n\n    .bi-file-diff-fill::before {\n        content: \"\\\\f353\";\n    }\n\n    .bi-file-diff::before {\n        content: \"\\\\f354\";\n    }\n\n    .bi-file-earmark-arrow-down-fill::before {\n        content: \"\\\\f355\";\n    }\n\n    .bi-file-earmark-arrow-down::before {\n        content: \"\\\\f356\";\n    }\n\n    .bi-file-earmark-arrow-up-fill::before {\n        content: \"\\\\f357\";\n    }\n\n    .bi-file-earmark-arrow-up::before {\n        content: \"\\\\f358\";\n    }\n\n    .bi-file-earmark-bar-graph-fill::before {\n        content: \"\\\\f359\";\n    }\n\n    .bi-file-earmark-bar-graph::before {\n        content: \"\\\\f35a\";\n    }\n\n    .bi-file-earmark-binary-fill::before {\n        content: \"\\\\f35b\";\n    }\n\n    .bi-file-earmark-binary::before {\n        content: \"\\\\f35c\";\n    }\n\n    .bi-file-earmark-break-fill::before {\n        content: \"\\\\f35d\";\n    }\n\n    .bi-file-earmark-break::before {\n        content: \"\\\\f35e\";\n    }\n\n    .bi-file-earmark-check-fill::before {\n        content: \"\\\\f35f\";\n    }\n\n    .bi-file-earmark-check::before {\n        content: \"\\\\f360\";\n    }\n\n    .bi-file-earmark-code-fill::before {\n        content: \"\\\\f361\";\n    }\n\n    .bi-file-earmark-code::before {\n        content: \"\\\\f362\";\n    }\n\n    .bi-file-earmark-diff-fill::before {\n        content: \"\\\\f363\";\n    }\n\n    .bi-file-earmark-diff::before {\n        content: \"\\\\f364\";\n    }\n\n    .bi-file-earmark-easel-fill::before {\n        content: \"\\\\f365\";\n    }\n\n    .bi-file-earmark-easel::before {\n        content: \"\\\\f366\";\n    }\n\n    .bi-file-earmark-excel-fill::before {\n        content: \"\\\\f367\";\n    }\n\n    .bi-file-earmark-excel::before {\n        content: \"\\\\f368\";\n    }\n\n    .bi-file-earmark-fill::before {\n        content: \"\\\\f369\";\n    }\n\n    .bi-file-earmark-font-fill::before {\n        content: \"\\\\f36a\";\n    }\n\n    .bi-file-earmark-font::before {\n        content: \"\\\\f36b\";\n    }\n\n    .bi-file-earmark-image-fill::before {\n        content: \"\\\\f36c\";\n    }\n\n    .bi-file-earmark-image::before {\n        content: \"\\\\f36d\";\n    }\n\n    .bi-file-earmark-lock-fill::before {\n        content: \"\\\\f36e\";\n    }\n\n    .bi-file-earmark-lock::before {\n        content: \"\\\\f36f\";\n    }\n\n    .bi-file-earmark-lock2-fill::before {\n        content: \"\\\\f370\";\n    }\n\n    .bi-file-earmark-lock2::before {\n        content: \"\\\\f371\";\n    }\n\n    .bi-file-earmark-medical-fill::before {\n        content: \"\\\\f372\";\n    }\n\n    .bi-file-earmark-medical::before {\n        content: \"\\\\f373\";\n    }\n\n    .bi-file-earmark-minus-fill::before {\n        content: \"\\\\f374\";\n    }\n\n    .bi-file-earmark-minus::before {\n        content: \"\\\\f375\";\n    }\n\n    .bi-file-earmark-music-fill::before {\n        content: \"\\\\f376\";\n    }\n\n    .bi-file-earmark-music::before {\n        content: \"\\\\f377\";\n    }\n\n    .bi-file-earmark-person-fill::before {\n        content: \"\\\\f378\";\n    }\n\n    .bi-file-earmark-person::before {\n        content: \"\\\\f379\";\n    }\n\n    .bi-file-earmark-play-fill::before {\n        content: \"\\\\f37a\";\n    }\n\n    .bi-file-earmark-play::before {\n        content: \"\\\\f37b\";\n    }\n\n    .bi-file-earmark-plus-fill::before {\n        content: \"\\\\f37c\";\n    }\n\n    .bi-file-earmark-plus::before {\n        content: \"\\\\f37d\";\n    }\n\n    .bi-file-earmark-post-fill::before {\n        content: \"\\\\f37e\";\n    }\n\n    .bi-file-earmark-post::before {\n        content: \"\\\\f37f\";\n    }\n\n    .bi-file-earmark-ppt-fill::before {\n        content: \"\\\\f380\";\n    }\n\n    .bi-file-earmark-ppt::before {\n        content: \"\\\\f381\";\n    }\n\n    .bi-file-earmark-richtext-fill::before {\n        content: \"\\\\f382\";\n    }\n\n    .bi-file-earmark-richtext::before {\n        content: \"\\\\f383\";\n    }\n\n    .bi-file-earmark-ruled-fill::before {\n        content: \"\\\\f384\";\n    }\n\n    .bi-file-earmark-ruled::before {\n        content: \"\\\\f385\";\n    }\n\n    .bi-file-earmark-slides-fill::before {\n        content: \"\\\\f386\";\n    }\n\n    .bi-file-earmark-slides::before {\n        content: \"\\\\f387\";\n    }\n\n    .bi-file-earmark-spreadsheet-fill::before {\n        content: \"\\\\f388\";\n    }\n\n    .bi-file-earmark-spreadsheet::before {\n        content: \"\\\\f389\";\n    }\n\n    .bi-file-earmark-text-fill::before {\n        content: \"\\\\f38a\";\n    }\n\n    .bi-file-earmark-text::before {\n        content: \"\\\\f38b\";\n    }\n\n    .bi-file-earmark-word-fill::before {\n        content: \"\\\\f38c\";\n    }\n\n    .bi-file-earmark-word::before {\n        content: \"\\\\f38d\";\n    }\n\n    .bi-file-earmark-x-fill::before {\n        content: \"\\\\f38e\";\n    }\n\n    .bi-file-earmark-x::before {\n        content: \"\\\\f38f\";\n    }\n\n    .bi-file-earmark-zip-fill::before {\n        content: \"\\\\f390\";\n    }\n\n    .bi-file-earmark-zip::before {\n        content: \"\\\\f391\";\n    }\n\n    .bi-file-earmark::before {\n        content: \"\\\\f392\";\n    }\n\n    .bi-file-easel-fill::before {\n        content: \"\\\\f393\";\n    }\n\n    .bi-file-easel::before {\n        content: \"\\\\f394\";\n    }\n\n    .bi-file-excel-fill::before {\n        content: \"\\\\f395\";\n    }\n\n    .bi-file-excel::before {\n        content: \"\\\\f396\";\n    }\n\n    .bi-file-fill::before {\n        content: \"\\\\f397\";\n    }\n\n    .bi-file-font-fill::before {\n        content: \"\\\\f398\";\n    }\n\n    .bi-file-font::before {\n        content: \"\\\\f399\";\n    }\n\n    .bi-file-image-fill::before {\n        content: \"\\\\f39a\";\n    }\n\n    .bi-file-image::before {\n        content: \"\\\\f39b\";\n    }\n\n    .bi-file-lock-fill::before {\n        content: \"\\\\f39c\";\n    }\n\n    .bi-file-lock::before {\n        content: \"\\\\f39d\";\n    }\n\n    .bi-file-lock2-fill::before {\n        content: \"\\\\f39e\";\n    }\n\n    .bi-file-lock2::before {\n        content: \"\\\\f39f\";\n    }\n\n    .bi-file-medical-fill::before {\n        content: \"\\\\f3a0\";\n    }\n\n    .bi-file-medical::before {\n        content: \"\\\\f3a1\";\n    }\n\n    .bi-file-minus-fill::before {\n        content: \"\\\\f3a2\";\n    }\n\n    .bi-file-minus::before {\n        content: \"\\\\f3a3\";\n    }\n\n    .bi-file-music-fill::before {\n        content: \"\\\\f3a4\";\n    }\n\n    .bi-file-music::before {\n        content: \"\\\\f3a5\";\n    }\n\n    .bi-file-person-fill::before {\n        content: \"\\\\f3a6\";\n    }\n\n    .bi-file-person::before {\n        content: \"\\\\f3a7\";\n    }\n\n    .bi-file-play-fill::before {\n        content: \"\\\\f3a8\";\n    }\n\n    .bi-file-play::before {\n        content: \"\\\\f3a9\";\n    }\n\n    .bi-file-plus-fill::before {\n        content: \"\\\\f3aa\";\n    }\n\n    .bi-file-plus::before {\n        content: \"\\\\f3ab\";\n    }\n\n    .bi-file-post-fill::before {\n        content: \"\\\\f3ac\";\n    }\n\n    .bi-file-post::before {\n        content: \"\\\\f3ad\";\n    }\n\n    .bi-file-ppt-fill::before {\n        content: \"\\\\f3ae\";\n    }\n\n    .bi-file-ppt::before {\n        content: \"\\\\f3af\";\n    }\n\n    .bi-file-richtext-fill::before {\n        content: \"\\\\f3b0\";\n    }\n\n    .bi-file-richtext::before {\n        content: \"\\\\f3b1\";\n    }\n\n    .bi-file-ruled-fill::before {\n        content: \"\\\\f3b2\";\n    }\n\n    .bi-file-ruled::before {\n        content: \"\\\\f3b3\";\n    }\n\n    .bi-file-slides-fill::before {\n        content: \"\\\\f3b4\";\n    }\n\n    .bi-file-slides::before {\n        content: \"\\\\f3b5\";\n    }\n\n    .bi-file-spreadsheet-fill::before {\n        content: \"\\\\f3b6\";\n    }\n\n    .bi-file-spreadsheet::before {\n        content: \"\\\\f3b7\";\n    }\n\n    .bi-file-text-fill::before {\n        content: \"\\\\f3b8\";\n    }\n\n    .bi-file-text::before {\n        content: \"\\\\f3b9\";\n    }\n\n    .bi-file-word-fill::before {\n        content: \"\\\\f3ba\";\n    }\n\n    .bi-file-word::before {\n        content: \"\\\\f3bb\";\n    }\n\n    .bi-file-x-fill::before {\n        content: \"\\\\f3bc\";\n    }\n\n    .bi-file-x::before {\n        content: \"\\\\f3bd\";\n    }\n\n    .bi-file-zip-fill::before {\n        content: \"\\\\f3be\";\n    }\n\n    .bi-file-zip::before {\n        content: \"\\\\f3bf\";\n    }\n\n    .bi-file::before {\n        content: \"\\\\f3c0\";\n    }\n\n    .bi-files-alt::before {\n        content: \"\\\\f3c1\";\n    }\n\n    .bi-files::before {\n        content: \"\\\\f3c2\";\n    }\n\n    .bi-film::before {\n        content: \"\\\\f3c3\";\n    }\n\n    .bi-filter-circle-fill::before {\n        content: \"\\\\f3c4\";\n    }\n\n    .bi-filter-circle::before {\n        content: \"\\\\f3c5\";\n    }\n\n    .bi-filter-left::before {\n        content: \"\\\\f3c6\";\n    }\n\n    .bi-filter-right::before {\n        content: \"\\\\f3c7\";\n    }\n\n    .bi-filter-square-fill::before {\n        content: \"\\\\f3c8\";\n    }\n\n    .bi-filter-square::before {\n        content: \"\\\\f3c9\";\n    }\n\n    .bi-filter::before {\n        content: \"\\\\f3ca\";\n    }\n\n    .bi-flag-fill::before {\n        content: \"\\\\f3cb\";\n    }\n\n    .bi-flag::before {\n        content: \"\\\\f3cc\";\n    }\n\n    .bi-flower1::before {\n        content: \"\\\\f3cd\";\n    }\n\n    .bi-flower2::before {\n        content: \"\\\\f3ce\";\n    }\n\n    .bi-flower3::before {\n        content: \"\\\\f3cf\";\n    }\n\n    .bi-folder-check::before {\n        content: \"\\\\f3d0\";\n    }\n\n    .bi-folder-fill::before {\n        content: \"\\\\f3d1\";\n    }\n\n    .bi-folder-minus::before {\n        content: \"\\\\f3d2\";\n    }\n\n    .bi-folder-plus::before {\n        content: \"\\\\f3d3\";\n    }\n\n    .bi-folder-symlink-fill::before {\n        content: \"\\\\f3d4\";\n    }\n\n    .bi-folder-symlink::before {\n        content: \"\\\\f3d5\";\n    }\n\n    .bi-folder-x::before {\n        content: \"\\\\f3d6\";\n    }\n\n    .bi-folder::before {\n        content: \"\\\\f3d7\";\n    }\n\n    .bi-folder2-open::before {\n        content: \"\\\\f3d8\";\n    }\n\n    .bi-folder2::before {\n        content: \"\\\\f3d9\";\n    }\n\n    .bi-fonts::before {\n        content: \"\\\\f3da\";\n    }\n\n    .bi-forward-fill::before {\n        content: \"\\\\f3db\";\n    }\n\n    .bi-forward::before {\n        content: \"\\\\f3dc\";\n    }\n\n    .bi-front::before {\n        content: \"\\\\f3dd\";\n    }\n\n    .bi-fullscreen-exit::before {\n        content: \"\\\\f3de\";\n    }\n\n    .bi-fullscreen::before {\n        content: \"\\\\f3df\";\n    }\n\n    .bi-funnel-fill::before {\n        content: \"\\\\f3e0\";\n    }\n\n    .bi-funnel::before {\n        content: \"\\\\f3e1\";\n    }\n\n    .bi-gear-fill::before {\n        content: \"\\\\f3e2\";\n    }\n\n    .bi-gear-wide-connected::before {\n        content: \"\\\\f3e3\";\n    }\n\n    .bi-gear-wide::before {\n        content: \"\\\\f3e4\";\n    }\n\n    .bi-gear::before {\n        content: \"\\\\f3e5\";\n    }\n\n    .bi-gem::before {\n        content: \"\\\\f3e6\";\n    }\n\n    .bi-geo-alt-fill::before {\n        content: \"\\\\f3e7\";\n    }\n\n    .bi-geo-alt::before {\n        content: \"\\\\f3e8\";\n    }\n\n    .bi-geo-fill::before {\n        content: \"\\\\f3e9\";\n    }\n\n    .bi-geo::before {\n        content: \"\\\\f3ea\";\n    }\n\n    .bi-gift-fill::before {\n        content: \"\\\\f3eb\";\n    }\n\n    .bi-gift::before {\n        content: \"\\\\f3ec\";\n    }\n\n    .bi-github::before {\n        content: \"\\\\f3ed\";\n    }\n\n    .bi-globe::before {\n        content: \"\\\\f3ee\";\n    }\n\n    .bi-globe2::before {\n        content: \"\\\\f3ef\";\n    }\n\n    .bi-google::before {\n        content: \"\\\\f3f0\";\n    }\n\n    .bi-graph-down::before {\n        content: \"\\\\f3f1\";\n    }\n\n    .bi-graph-up::before {\n        content: \"\\\\f3f2\";\n    }\n\n    .bi-grid-1x2-fill::before {\n        content: \"\\\\f3f3\";\n    }\n\n    .bi-grid-1x2::before {\n        content: \"\\\\f3f4\";\n    }\n\n    .bi-grid-3x2-gap-fill::before {\n        content: \"\\\\f3f5\";\n    }\n\n    .bi-grid-3x2-gap::before {\n        content: \"\\\\f3f6\";\n    }\n\n    .bi-grid-3x2::before {\n        content: \"\\\\f3f7\";\n    }\n\n    .bi-grid-3x3-gap-fill::before {\n        content: \"\\\\f3f8\";\n    }\n\n    .bi-grid-3x3-gap::before {\n        content: \"\\\\f3f9\";\n    }\n\n    .bi-grid-3x3::before {\n        content: \"\\\\f3fa\";\n    }\n\n    .bi-grid-fill::before {\n        content: \"\\\\f3fb\";\n    }\n\n    .bi-grid::before {\n        content: \"\\\\f3fc\";\n    }\n\n    .bi-grip-horizontal::before {\n        content: \"\\\\f3fd\";\n    }\n\n    .bi-grip-vertical::before {\n        content: \"\\\\f3fe\";\n    }\n\n    .bi-hammer::before {\n        content: \"\\\\f3ff\";\n    }\n\n    .bi-hand-index-fill::before {\n        content: \"\\\\f400\";\n    }\n\n    .bi-hand-index-thumb-fill::before {\n        content: \"\\\\f401\";\n    }\n\n    .bi-hand-index-thumb::before {\n        content: \"\\\\f402\";\n    }\n\n    .bi-hand-index::before {\n        content: \"\\\\f403\";\n    }\n\n    .bi-hand-thumbs-down-fill::before {\n        content: \"\\\\f404\";\n    }\n\n    .bi-hand-thumbs-down::before {\n        content: \"\\\\f405\";\n    }\n\n    .bi-hand-thumbs-up-fill::before {\n        content: \"\\\\f406\";\n    }\n\n    .bi-hand-thumbs-up::before {\n        content: \"\\\\f407\";\n    }\n\n    .bi-handbag-fill::before {\n        content: \"\\\\f408\";\n    }\n\n    .bi-handbag::before {\n        content: \"\\\\f409\";\n    }\n\n    .bi-hash::before {\n        content: \"\\\\f40a\";\n    }\n\n    .bi-hdd-fill::before {\n        content: \"\\\\f40b\";\n    }\n\n    .bi-hdd-network-fill::before {\n        content: \"\\\\f40c\";\n    }\n\n    .bi-hdd-network::before {\n        content: \"\\\\f40d\";\n    }\n\n    .bi-hdd-rack-fill::before {\n        content: \"\\\\f40e\";\n    }\n\n    .bi-hdd-rack::before {\n        content: \"\\\\f40f\";\n    }\n\n    .bi-hdd-stack-fill::before {\n        content: \"\\\\f410\";\n    }\n\n    .bi-hdd-stack::before {\n        content: \"\\\\f411\";\n    }\n\n    .bi-hdd::before {\n        content: \"\\\\f412\";\n    }\n\n    .bi-headphones::before {\n        content: \"\\\\f413\";\n    }\n\n    .bi-headset::before {\n        content: \"\\\\f414\";\n    }\n\n    .bi-heart-fill::before {\n        content: \"\\\\f415\";\n    }\n\n    .bi-heart-half::before {\n        content: \"\\\\f416\";\n    }\n\n    .bi-heart::before {\n        content: \"\\\\f417\";\n    }\n\n    .bi-heptagon-fill::before {\n        content: \"\\\\f418\";\n    }\n\n    .bi-heptagon-half::before {\n        content: \"\\\\f419\";\n    }\n\n    .bi-heptagon::before {\n        content: \"\\\\f41a\";\n    }\n\n    .bi-hexagon-fill::before {\n        content: \"\\\\f41b\";\n    }\n\n    .bi-hexagon-half::before {\n        content: \"\\\\f41c\";\n    }\n\n    .bi-hexagon::before {\n        content: \"\\\\f41d\";\n    }\n\n    .bi-hourglass-bottom::before {\n        content: \"\\\\f41e\";\n    }\n\n    .bi-hourglass-split::before {\n        content: \"\\\\f41f\";\n    }\n\n    .bi-hourglass-top::before {\n        content: \"\\\\f420\";\n    }\n\n    .bi-hourglass::before {\n        content: \"\\\\f421\";\n    }\n\n    .bi-house-door-fill::before {\n        content: \"\\\\f422\";\n    }\n\n    .bi-house-door::before {\n        content: \"\\\\f423\";\n    }\n\n    .bi-house-fill::before {\n        content: \"\\\\f424\";\n    }\n\n    .bi-house::before {\n        content: \"\\\\f425\";\n    }\n\n    .bi-hr::before {\n        content: \"\\\\f426\";\n    }\n\n    .bi-hurricane::before {\n        content: \"\\\\f427\";\n    }\n\n    .bi-image-alt::before {\n        content: \"\\\\f428\";\n    }\n\n    .bi-image-fill::before {\n        content: \"\\\\f429\";\n    }\n\n    .bi-image::before {\n        content: \"\\\\f42a\";\n    }\n\n    .bi-images::before {\n        content: \"\\\\f42b\";\n    }\n\n    .bi-inbox-fill::before {\n        content: \"\\\\f42c\";\n    }\n\n    .bi-inbox::before {\n        content: \"\\\\f42d\";\n    }\n\n    .bi-inboxes-fill::before {\n        content: \"\\\\f42e\";\n    }\n\n    .bi-inboxes::before {\n        content: \"\\\\f42f\";\n    }\n\n    .bi-info-circle-fill::before {\n        content: \"\\\\f430\";\n    }\n\n    .bi-info-circle::before {\n        content: \"\\\\f431\";\n    }\n\n    .bi-info-square-fill::before {\n        content: \"\\\\f432\";\n    }\n\n    .bi-info-square::before {\n        content: \"\\\\f433\";\n    }\n\n    .bi-info::before {\n        content: \"\\\\f434\";\n    }\n\n    .bi-input-cursor-text::before {\n        content: \"\\\\f435\";\n    }\n\n    .bi-input-cursor::before {\n        content: \"\\\\f436\";\n    }\n\n    .bi-instagram::before {\n        content: \"\\\\f437\";\n    }\n\n    .bi-intersect::before {\n        content: \"\\\\f438\";\n    }\n\n    .bi-journal-album::before {\n        content: \"\\\\f439\";\n    }\n\n    .bi-journal-arrow-down::before {\n        content: \"\\\\f43a\";\n    }\n\n    .bi-journal-arrow-up::before {\n        content: \"\\\\f43b\";\n    }\n\n    .bi-journal-bookmark-fill::before {\n        content: \"\\\\f43c\";\n    }\n\n    .bi-journal-bookmark::before {\n        content: \"\\\\f43d\";\n    }\n\n    .bi-journal-check::before {\n        content: \"\\\\f43e\";\n    }\n\n    .bi-journal-code::before {\n        content: \"\\\\f43f\";\n    }\n\n    .bi-journal-medical::before {\n        content: \"\\\\f440\";\n    }\n\n    .bi-journal-minus::before {\n        content: \"\\\\f441\";\n    }\n\n    .bi-journal-plus::before {\n        content: \"\\\\f442\";\n    }\n\n    .bi-journal-richtext::before {\n        content: \"\\\\f443\";\n    }\n\n    .bi-journal-text::before {\n        content: \"\\\\f444\";\n    }\n\n    .bi-journal-x::before {\n        content: \"\\\\f445\";\n    }\n\n    .bi-journal::before {\n        content: \"\\\\f446\";\n    }\n\n    .bi-journals::before {\n        content: \"\\\\f447\";\n    }\n\n    .bi-joystick::before {\n        content: \"\\\\f448\";\n    }\n\n    .bi-justify-left::before {\n        content: \"\\\\f449\";\n    }\n\n    .bi-justify-right::before {\n        content: \"\\\\f44a\";\n    }\n\n    .bi-justify::before {\n        content: \"\\\\f44b\";\n    }\n\n    .bi-kanban-fill::before {\n        content: \"\\\\f44c\";\n    }\n\n    .bi-kanban::before {\n        content: \"\\\\f44d\";\n    }\n\n    .bi-key-fill::before {\n        content: \"\\\\f44e\";\n    }\n\n    .bi-key::before {\n        content: \"\\\\f44f\";\n    }\n\n    .bi-keyboard-fill::before {\n        content: \"\\\\f450\";\n    }\n\n    .bi-keyboard::before {\n        content: \"\\\\f451\";\n    }\n\n    .bi-ladder::before {\n        content: \"\\\\f452\";\n    }\n\n    .bi-lamp-fill::before {\n        content: \"\\\\f453\";\n    }\n\n    .bi-lamp::before {\n        content: \"\\\\f454\";\n    }\n\n    .bi-laptop-fill::before {\n        content: \"\\\\f455\";\n    }\n\n    .bi-laptop::before {\n        content: \"\\\\f456\";\n    }\n\n    .bi-layer-backward::before {\n        content: \"\\\\f457\";\n    }\n\n    .bi-layer-forward::before {\n        content: \"\\\\f458\";\n    }\n\n    .bi-layers-fill::before {\n        content: \"\\\\f459\";\n    }\n\n    .bi-layers-half::before {\n        content: \"\\\\f45a\";\n    }\n\n    .bi-layers::before {\n        content: \"\\\\f45b\";\n    }\n\n    .bi-layout-sidebar-inset-reverse::before {\n        content: \"\\\\f45c\";\n    }\n\n    .bi-layout-sidebar-inset::before {\n        content: \"\\\\f45d\";\n    }\n\n    .bi-layout-sidebar-reverse::before {\n        content: \"\\\\f45e\";\n    }\n\n    .bi-layout-sidebar::before {\n        content: \"\\\\f45f\";\n    }\n\n    .bi-layout-split::before {\n        content: \"\\\\f460\";\n    }\n\n    .bi-layout-text-sidebar-reverse::before {\n        content: \"\\\\f461\";\n    }\n\n    .bi-layout-text-sidebar::before {\n        content: \"\\\\f462\";\n    }\n\n    .bi-layout-text-window-reverse::before {\n        content: \"\\\\f463\";\n    }\n\n    .bi-layout-text-window::before {\n        content: \"\\\\f464\";\n    }\n\n    .bi-layout-three-columns::before {\n        content: \"\\\\f465\";\n    }\n\n    .bi-layout-wtf::before {\n        content: \"\\\\f466\";\n    }\n\n    .bi-life-preserver::before {\n        content: \"\\\\f467\";\n    }\n\n    .bi-lightbulb-fill::before {\n        content: \"\\\\f468\";\n    }\n\n    .bi-lightbulb-off-fill::before {\n        content: \"\\\\f469\";\n    }\n\n    .bi-lightbulb-off::before {\n        content: \"\\\\f46a\";\n    }\n\n    .bi-lightbulb::before {\n        content: \"\\\\f46b\";\n    }\n\n    .bi-lightning-charge-fill::before {\n        content: \"\\\\f46c\";\n    }\n\n    .bi-lightning-charge::before {\n        content: \"\\\\f46d\";\n    }\n\n    .bi-lightning-fill::before {\n        content: \"\\\\f46e\";\n    }\n\n    .bi-lightning::before {\n        content: \"\\\\f46f\";\n    }\n\n    .bi-link-45deg::before {\n        content: \"\\\\f470\";\n    }\n\n    .bi-link::before {\n        content: \"\\\\f471\";\n    }\n\n    .bi-linkedin::before {\n        content: \"\\\\f472\";\n    }\n\n    .bi-list-check::before {\n        content: \"\\\\f473\";\n    }\n\n    .bi-list-nested::before {\n        content: \"\\\\f474\";\n    }\n\n    .bi-list-ol::before {\n        content: \"\\\\f475\";\n    }\n\n    .bi-list-stars::before {\n        content: \"\\\\f476\";\n    }\n\n    .bi-list-task::before {\n        content: \"\\\\f477\";\n    }\n\n    .bi-list-ul::before {\n        content: \"\\\\f478\";\n    }\n\n    .bi-list::before {\n        content: \"\\\\f479\";\n    }\n\n    .bi-lock-fill::before {\n        content: \"\\\\f47a\";\n    }\n\n    .bi-lock::before {\n        content: \"\\\\f47b\";\n    }\n\n    .bi-mailbox::before {\n        content: \"\\\\f47c\";\n    }\n\n    .bi-mailbox2::before {\n        content: \"\\\\f47d\";\n    }\n\n    .bi-map-fill::before {\n        content: \"\\\\f47e\";\n    }\n\n    .bi-map::before {\n        content: \"\\\\f47f\";\n    }\n\n    .bi-markdown-fill::before {\n        content: \"\\\\f480\";\n    }\n\n    .bi-markdown::before {\n        content: \"\\\\f481\";\n    }\n\n    .bi-mask::before {\n        content: \"\\\\f482\";\n    }\n\n    .bi-megaphone-fill::before {\n        content: \"\\\\f483\";\n    }\n\n    .bi-megaphone::before {\n        content: \"\\\\f484\";\n    }\n\n    .bi-menu-app-fill::before {\n        content: \"\\\\f485\";\n    }\n\n    .bi-menu-app::before {\n        content: \"\\\\f486\";\n    }\n\n    .bi-menu-button-fill::before {\n        content: \"\\\\f487\";\n    }\n\n    .bi-menu-button-wide-fill::before {\n        content: \"\\\\f488\";\n    }\n\n    .bi-menu-button-wide::before {\n        content: \"\\\\f489\";\n    }\n\n    .bi-menu-button::before {\n        content: \"\\\\f48a\";\n    }\n\n    .bi-menu-down::before {\n        content: \"\\\\f48b\";\n    }\n\n    .bi-menu-up::before {\n        content: \"\\\\f48c\";\n    }\n\n    .bi-mic-fill::before {\n        content: \"\\\\f48d\";\n    }\n\n    .bi-mic-mute-fill::before {\n        content: \"\\\\f48e\";\n    }\n\n    .bi-mic-mute::before {\n        content: \"\\\\f48f\";\n    }\n\n    .bi-mic::before {\n        content: \"\\\\f490\";\n    }\n\n    .bi-minecart-loaded::before {\n        content: \"\\\\f491\";\n    }\n\n    .bi-minecart::before {\n        content: \"\\\\f492\";\n    }\n\n    .bi-moisture::before {\n        content: \"\\\\f493\";\n    }\n\n    .bi-moon-fill::before {\n        content: \"\\\\f494\";\n    }\n\n    .bi-moon-stars-fill::before {\n        content: \"\\\\f495\";\n    }\n\n    .bi-moon-stars::before {\n        content: \"\\\\f496\";\n    }\n\n    .bi-moon::before {\n        content: \"\\\\f497\";\n    }\n\n    .bi-mouse-fill::before {\n        content: \"\\\\f498\";\n    }\n\n    .bi-mouse::before {\n        content: \"\\\\f499\";\n    }\n\n    .bi-mouse2-fill::before {\n        content: \"\\\\f49a\";\n    }\n\n    .bi-mouse2::before {\n        content: \"\\\\f49b\";\n    }\n\n    .bi-mouse3-fill::before {\n        content: \"\\\\f49c\";\n    }\n\n    .bi-mouse3::before {\n        content: \"\\\\f49d\";\n    }\n\n    .bi-music-note-beamed::before {\n        content: \"\\\\f49e\";\n    }\n\n    .bi-music-note-list::before {\n        content: \"\\\\f49f\";\n    }\n\n    .bi-music-note::before {\n        content: \"\\\\f4a0\";\n    }\n\n    .bi-music-player-fill::before {\n        content: \"\\\\f4a1\";\n    }\n\n    .bi-music-player::before {\n        content: \"\\\\f4a2\";\n    }\n\n    .bi-newspaper::before {\n        content: \"\\\\f4a3\";\n    }\n\n    .bi-node-minus-fill::before {\n        content: \"\\\\f4a4\";\n    }\n\n    .bi-node-minus::before {\n        content: \"\\\\f4a5\";\n    }\n\n    .bi-node-plus-fill::before {\n        content: \"\\\\f4a6\";\n    }\n\n    .bi-node-plus::before {\n        content: \"\\\\f4a7\";\n    }\n\n    .bi-nut-fill::before {\n        content: \"\\\\f4a8\";\n    }\n\n    .bi-nut::before {\n        content: \"\\\\f4a9\";\n    }\n\n    .bi-octagon-fill::before {\n        content: \"\\\\f4aa\";\n    }\n\n    .bi-octagon-half::before {\n        content: \"\\\\f4ab\";\n    }\n\n    .bi-octagon::before {\n        content: \"\\\\f4ac\";\n    }\n\n    .bi-option::before {\n        content: \"\\\\f4ad\";\n    }\n\n    .bi-outlet::before {\n        content: \"\\\\f4ae\";\n    }\n\n    .bi-paint-bucket::before {\n        content: \"\\\\f4af\";\n    }\n\n    .bi-palette-fill::before {\n        content: \"\\\\f4b0\";\n    }\n\n    .bi-palette::before {\n        content: \"\\\\f4b1\";\n    }\n\n    .bi-palette2::before {\n        content: \"\\\\f4b2\";\n    }\n\n    .bi-paperclip::before {\n        content: \"\\\\f4b3\";\n    }\n\n    .bi-paragraph::before {\n        content: \"\\\\f4b4\";\n    }\n\n    .bi-patch-check-fill::before {\n        content: \"\\\\f4b5\";\n    }\n\n    .bi-patch-check::before {\n        content: \"\\\\f4b6\";\n    }\n\n    .bi-patch-exclamation-fill::before {\n        content: \"\\\\f4b7\";\n    }\n\n    .bi-patch-exclamation::before {\n        content: \"\\\\f4b8\";\n    }\n\n    .bi-patch-minus-fill::before {\n        content: \"\\\\f4b9\";\n    }\n\n    .bi-patch-minus::before {\n        content: \"\\\\f4ba\";\n    }\n\n    .bi-patch-plus-fill::before {\n        content: \"\\\\f4bb\";\n    }\n\n    .bi-patch-plus::before {\n        content: \"\\\\f4bc\";\n    }\n\n    .bi-patch-question-fill::before {\n        content: \"\\\\f4bd\";\n    }\n\n    .bi-patch-question::before {\n        content: \"\\\\f4be\";\n    }\n\n    .bi-pause-btn-fill::before {\n        content: \"\\\\f4bf\";\n    }\n\n    .bi-pause-btn::before {\n        content: \"\\\\f4c0\";\n    }\n\n    .bi-pause-circle-fill::before {\n        content: \"\\\\f4c1\";\n    }\n\n    .bi-pause-circle::before {\n        content: \"\\\\f4c2\";\n    }\n\n    .bi-pause-fill::before {\n        content: \"\\\\f4c3\";\n    }\n\n    .bi-pause::before {\n        content: \"\\\\f4c4\";\n    }\n\n    .bi-peace-fill::before {\n        content: \"\\\\f4c5\";\n    }\n\n    .bi-peace::before {\n        content: \"\\\\f4c6\";\n    }\n\n    .bi-pen-fill::before {\n        content: \"\\\\f4c7\";\n    }\n\n    .bi-pen::before {\n        content: \"\\\\f4c8\";\n    }\n\n    .bi-pencil-fill::before {\n        content: \"\\\\f4c9\";\n    }\n\n    .bi-pencil-square::before {\n        content: \"\\\\f4ca\";\n    }\n\n    .bi-pencil::before {\n        content: \"\\\\f4cb\";\n    }\n\n    .bi-pentagon-fill::before {\n        content: \"\\\\f4cc\";\n    }\n\n    .bi-pentagon-half::before {\n        content: \"\\\\f4cd\";\n    }\n\n    .bi-pentagon::before {\n        content: \"\\\\f4ce\";\n    }\n\n    .bi-people-fill::before {\n        content: \"\\\\f4cf\";\n    }\n\n    .bi-people::before {\n        content: \"\\\\f4d0\";\n    }\n\n    .bi-percent::before {\n        content: \"\\\\f4d1\";\n    }\n\n    .bi-person-badge-fill::before {\n        content: \"\\\\f4d2\";\n    }\n\n    .bi-person-badge::before {\n        content: \"\\\\f4d3\";\n    }\n\n    .bi-person-bounding-box::before {\n        content: \"\\\\f4d4\";\n    }\n\n    .bi-person-check-fill::before {\n        content: \"\\\\f4d5\";\n    }\n\n    .bi-person-check::before {\n        content: \"\\\\f4d6\";\n    }\n\n    .bi-person-circle::before {\n        content: \"\\\\f4d7\";\n    }\n\n    .bi-person-dash-fill::before {\n        content: \"\\\\f4d8\";\n    }\n\n    .bi-person-dash::before {\n        content: \"\\\\f4d9\";\n    }\n\n    .bi-person-fill::before {\n        content: \"\\\\f4da\";\n    }\n\n    .bi-person-lines-fill::before {\n        content: \"\\\\f4db\";\n    }\n\n    .bi-person-plus-fill::before {\n        content: \"\\\\f4dc\";\n    }\n\n    .bi-person-plus::before {\n        content: \"\\\\f4dd\";\n    }\n\n    .bi-person-square::before {\n        content: \"\\\\f4de\";\n    }\n\n    .bi-person-x-fill::before {\n        content: \"\\\\f4df\";\n    }\n\n    .bi-person-x::before {\n        content: \"\\\\f4e0\";\n    }\n\n    .bi-person::before {\n        content: \"\\\\f4e1\";\n    }\n\n    .bi-phone-fill::before {\n        content: \"\\\\f4e2\";\n    }\n\n    .bi-phone-landscape-fill::before {\n        content: \"\\\\f4e3\";\n    }\n\n    .bi-phone-landscape::before {\n        content: \"\\\\f4e4\";\n    }\n\n    .bi-phone-vibrate-fill::before {\n        content: \"\\\\f4e5\";\n    }\n\n    .bi-phone-vibrate::before {\n        content: \"\\\\f4e6\";\n    }\n\n    .bi-phone::before {\n        content: \"\\\\f4e7\";\n    }\n\n    .bi-pie-chart-fill::before {\n        content: \"\\\\f4e8\";\n    }\n\n    .bi-pie-chart::before {\n        content: \"\\\\f4e9\";\n    }\n\n    .bi-pin-angle-fill::before {\n        content: \"\\\\f4ea\";\n    }\n\n    .bi-pin-angle::before {\n        content: \"\\\\f4eb\";\n    }\n\n    .bi-pin-fill::before {\n        content: \"\\\\f4ec\";\n    }\n\n    .bi-pin::before {\n        content: \"\\\\f4ed\";\n    }\n\n    .bi-pip-fill::before {\n        content: \"\\\\f4ee\";\n    }\n\n    .bi-pip::before {\n        content: \"\\\\f4ef\";\n    }\n\n    .bi-play-btn-fill::before {\n        content: \"\\\\f4f0\";\n    }\n\n    .bi-play-btn::before {\n        content: \"\\\\f4f1\";\n    }\n\n    .bi-play-circle-fill::before {\n        content: \"\\\\f4f2\";\n    }\n\n    .bi-play-circle::before {\n        content: \"\\\\f4f3\";\n    }\n\n    .bi-play-fill::before {\n        content: \"\\\\f4f4\";\n    }\n\n    .bi-play::before {\n        content: \"\\\\f4f5\";\n    }\n\n    .bi-plug-fill::before {\n        content: \"\\\\f4f6\";\n    }\n\n    .bi-plug::before {\n        content: \"\\\\f4f7\";\n    }\n\n    .bi-plus-circle-dotted::before {\n        content: \"\\\\f4f8\";\n    }\n\n    .bi-plus-circle-fill::before {\n        content: \"\\\\f4f9\";\n    }\n\n    .bi-plus-circle::before {\n        content: \"\\\\f4fa\";\n    }\n\n    .bi-plus-square-dotted::before {\n        content: \"\\\\f4fb\";\n    }\n\n    .bi-plus-square-fill::before {\n        content: \"\\\\f4fc\";\n    }\n\n    .bi-plus-square::before {\n        content: \"\\\\f4fd\";\n    }\n\n    .bi-plus::before {\n        content: \"\\\\f4fe\";\n    }\n\n    .bi-power::before {\n        content: \"\\\\f4ff\";\n    }\n\n    .bi-printer-fill::before {\n        content: \"\\\\f500\";\n    }\n\n    .bi-printer::before {\n        content: \"\\\\f501\";\n    }\n\n    .bi-puzzle-fill::before {\n        content: \"\\\\f502\";\n    }\n\n    .bi-puzzle::before {\n        content: \"\\\\f503\";\n    }\n\n    .bi-question-circle-fill::before {\n        content: \"\\\\f504\";\n    }\n\n    .bi-question-circle::before {\n        content: \"\\\\f505\";\n    }\n\n    .bi-question-diamond-fill::before {\n        content: \"\\\\f506\";\n    }\n\n    .bi-question-diamond::before {\n        content: \"\\\\f507\";\n    }\n\n    .bi-question-octagon-fill::before {\n        content: \"\\\\f508\";\n    }\n\n    .bi-question-octagon::before {\n        content: \"\\\\f509\";\n    }\n\n    .bi-question-square-fill::before {\n        content: \"\\\\f50a\";\n    }\n\n    .bi-question-square::before {\n        content: \"\\\\f50b\";\n    }\n\n    .bi-question::before {\n        content: \"\\\\f50c\";\n    }\n\n    .bi-rainbow::before {\n        content: \"\\\\f50d\";\n    }\n\n    .bi-receipt-cutoff::before {\n        content: \"\\\\f50e\";\n    }\n\n    .bi-receipt::before {\n        content: \"\\\\f50f\";\n    }\n\n    .bi-reception-0::before {\n        content: \"\\\\f510\";\n    }\n\n    .bi-reception-1::before {\n        content: \"\\\\f511\";\n    }\n\n    .bi-reception-2::before {\n        content: \"\\\\f512\";\n    }\n\n    .bi-reception-3::before {\n        content: \"\\\\f513\";\n    }\n\n    .bi-reception-4::before {\n        content: \"\\\\f514\";\n    }\n\n    .bi-record-btn-fill::before {\n        content: \"\\\\f515\";\n    }\n\n    .bi-record-btn::before {\n        content: \"\\\\f516\";\n    }\n\n    .bi-record-circle-fill::before {\n        content: \"\\\\f517\";\n    }\n\n    .bi-record-circle::before {\n        content: \"\\\\f518\";\n    }\n\n    .bi-record-fill::before {\n        content: \"\\\\f519\";\n    }\n\n    .bi-record::before {\n        content: \"\\\\f51a\";\n    }\n\n    .bi-record2-fill::before {\n        content: \"\\\\f51b\";\n    }\n\n    .bi-record2::before {\n        content: \"\\\\f51c\";\n    }\n\n    .bi-reply-all-fill::before {\n        content: \"\\\\f51d\";\n    }\n\n    .bi-reply-all::before {\n        content: \"\\\\f51e\";\n    }\n\n    .bi-reply-fill::before {\n        content: \"\\\\f51f\";\n    }\n\n    .bi-reply::before {\n        content: \"\\\\f520\";\n    }\n\n    .bi-rss-fill::before {\n        content: \"\\\\f521\";\n    }\n\n    .bi-rss::before {\n        content: \"\\\\f522\";\n    }\n\n    .bi-rulers::before {\n        content: \"\\\\f523\";\n    }\n\n    .bi-save-fill::before {\n        content: \"\\\\f524\";\n    }\n\n    .bi-save::before {\n        content: \"\\\\f525\";\n    }\n\n    .bi-save2-fill::before {\n        content: \"\\\\f526\";\n    }\n\n    .bi-save2::before {\n        content: \"\\\\f527\";\n    }\n\n    .bi-scissors::before {\n        content: \"\\\\f528\";\n    }\n\n    .bi-screwdriver::before {\n        content: \"\\\\f529\";\n    }\n\n    .bi-search::before {\n        content: \"\\\\f52a\";\n    }\n\n    .bi-segmented-nav::before {\n        content: \"\\\\f52b\";\n    }\n\n    .bi-server::before {\n        content: \"\\\\f52c\";\n    }\n\n    .bi-share-fill::before {\n        content: \"\\\\f52d\";\n    }\n\n    .bi-share::before {\n        content: \"\\\\f52e\";\n    }\n\n    .bi-shield-check::before {\n        content: \"\\\\f52f\";\n    }\n\n    .bi-shield-exclamation::before {\n        content: \"\\\\f530\";\n    }\n\n    .bi-shield-fill-check::before {\n        content: \"\\\\f531\";\n    }\n\n    .bi-shield-fill-exclamation::before {\n        content: \"\\\\f532\";\n    }\n\n    .bi-shield-fill-minus::before {\n        content: \"\\\\f533\";\n    }\n\n    .bi-shield-fill-plus::before {\n        content: \"\\\\f534\";\n    }\n\n    .bi-shield-fill-x::before {\n        content: \"\\\\f535\";\n    }\n\n    .bi-shield-fill::before {\n        content: \"\\\\f536\";\n    }\n\n    .bi-shield-lock-fill::before {\n        content: \"\\\\f537\";\n    }\n\n    .bi-shield-lock::before {\n        content: \"\\\\f538\";\n    }\n\n    .bi-shield-minus::before {\n        content: \"\\\\f539\";\n    }\n\n    .bi-shield-plus::before {\n        content: \"\\\\f53a\";\n    }\n\n    .bi-shield-shaded::before {\n        content: \"\\\\f53b\";\n    }\n\n    .bi-shield-slash-fill::before {\n        content: \"\\\\f53c\";\n    }\n\n    .bi-shield-slash::before {\n        content: \"\\\\f53d\";\n    }\n\n    .bi-shield-x::before {\n        content: \"\\\\f53e\";\n    }\n\n    .bi-shield::before {\n        content: \"\\\\f53f\";\n    }\n\n    .bi-shift-fill::before {\n        content: \"\\\\f540\";\n    }\n\n    .bi-shift::before {\n        content: \"\\\\f541\";\n    }\n\n    .bi-shop-window::before {\n        content: \"\\\\f542\";\n    }\n\n    .bi-shop::before {\n        content: \"\\\\f543\";\n    }\n\n    .bi-shuffle::before {\n        content: \"\\\\f544\";\n    }\n\n    .bi-signpost-2-fill::before {\n        content: \"\\\\f545\";\n    }\n\n    .bi-signpost-2::before {\n        content: \"\\\\f546\";\n    }\n\n    .bi-signpost-fill::before {\n        content: \"\\\\f547\";\n    }\n\n    .bi-signpost-split-fill::before {\n        content: \"\\\\f548\";\n    }\n\n    .bi-signpost-split::before {\n        content: \"\\\\f549\";\n    }\n\n    .bi-signpost::before {\n        content: \"\\\\f54a\";\n    }\n\n    .bi-sim-fill::before {\n        content: \"\\\\f54b\";\n    }\n\n    .bi-sim::before {\n        content: \"\\\\f54c\";\n    }\n\n    .bi-skip-backward-btn-fill::before {\n        content: \"\\\\f54d\";\n    }\n\n    .bi-skip-backward-btn::before {\n        content: \"\\\\f54e\";\n    }\n\n    .bi-skip-backward-circle-fill::before {\n        content: \"\\\\f54f\";\n    }\n\n    .bi-skip-backward-circle::before {\n        content: \"\\\\f550\";\n    }\n\n    .bi-skip-backward-fill::before {\n        content: \"\\\\f551\";\n    }\n\n    .bi-skip-backward::before {\n        content: \"\\\\f552\";\n    }\n\n    .bi-skip-end-btn-fill::before {\n        content: \"\\\\f553\";\n    }\n\n    .bi-skip-end-btn::before {\n        content: \"\\\\f554\";\n    }\n\n    .bi-skip-end-circle-fill::before {\n        content: \"\\\\f555\";\n    }\n\n    .bi-skip-end-circle::before {\n        content: \"\\\\f556\";\n    }\n\n    .bi-skip-end-fill::before {\n        content: \"\\\\f557\";\n    }\n\n    .bi-skip-end::before {\n        content: \"\\\\f558\";\n    }\n\n    .bi-skip-forward-btn-fill::before {\n        content: \"\\\\f559\";\n    }\n\n    .bi-skip-forward-btn::before {\n        content: \"\\\\f55a\";\n    }\n\n    .bi-skip-forward-circle-fill::before {\n        content: \"\\\\f55b\";\n    }\n\n    .bi-skip-forward-circle::before {\n        content: \"\\\\f55c\";\n    }\n\n    .bi-skip-forward-fill::before {\n        content: \"\\\\f55d\";\n    }\n\n    .bi-skip-forward::before {\n        content: \"\\\\f55e\";\n    }\n\n    .bi-skip-start-btn-fill::before {\n        content: \"\\\\f55f\";\n    }\n\n    .bi-skip-start-btn::before {\n        content: \"\\\\f560\";\n    }\n\n    .bi-skip-start-circle-fill::before {\n        content: \"\\\\f561\";\n    }\n\n    .bi-skip-start-circle::before {\n        content: \"\\\\f562\";\n    }\n\n    .bi-skip-start-fill::before {\n        content: \"\\\\f563\";\n    }\n\n    .bi-skip-start::before {\n        content: \"\\\\f564\";\n    }\n\n    .bi-slack::before {\n        content: \"\\\\f565\";\n    }\n\n    .bi-slash-circle-fill::before {\n        content: \"\\\\f566\";\n    }\n\n    .bi-slash-circle::before {\n        content: \"\\\\f567\";\n    }\n\n    .bi-slash-square-fill::before {\n        content: \"\\\\f568\";\n    }\n\n    .bi-slash-square::before {\n        content: \"\\\\f569\";\n    }\n\n    .bi-slash::before {\n        content: \"\\\\f56a\";\n    }\n\n    .bi-sliders::before {\n        content: \"\\\\f56b\";\n    }\n\n    .bi-smartwatch::before {\n        content: \"\\\\f56c\";\n    }\n\n    .bi-snow::before {\n        content: \"\\\\f56d\";\n    }\n\n    .bi-snow2::before {\n        content: \"\\\\f56e\";\n    }\n\n    .bi-snow3::before {\n        content: \"\\\\f56f\";\n    }\n\n    .bi-sort-alpha-down-alt::before {\n        content: \"\\\\f570\";\n    }\n\n    .bi-sort-alpha-down::before {\n        content: \"\\\\f571\";\n    }\n\n    .bi-sort-alpha-up-alt::before {\n        content: \"\\\\f572\";\n    }\n\n    .bi-sort-alpha-up::before {\n        content: \"\\\\f573\";\n    }\n\n    .bi-sort-down-alt::before {\n        content: \"\\\\f574\";\n    }\n\n    .bi-sort-down::before {\n        content: \"\\\\f575\";\n    }\n\n    .bi-sort-numeric-down-alt::before {\n        content: \"\\\\f576\";\n    }\n\n    .bi-sort-numeric-down::before {\n        content: \"\\\\f577\";\n    }\n\n    .bi-sort-numeric-up-alt::before {\n        content: \"\\\\f578\";\n    }\n\n    .bi-sort-numeric-up::before {\n        content: \"\\\\f579\";\n    }\n\n    .bi-sort-up-alt::before {\n        content: \"\\\\f57a\";\n    }\n\n    .bi-sort-up::before {\n        content: \"\\\\f57b\";\n    }\n\n    .bi-soundwave::before {\n        content: \"\\\\f57c\";\n    }\n\n    .bi-speaker-fill::before {\n        content: \"\\\\f57d\";\n    }\n\n    .bi-speaker::before {\n        content: \"\\\\f57e\";\n    }\n\n    .bi-speedometer::before {\n        content: \"\\\\f57f\";\n    }\n\n    .bi-speedometer2::before {\n        content: \"\\\\f580\";\n    }\n\n    .bi-spellcheck::before {\n        content: \"\\\\f581\";\n    }\n\n    .bi-square-fill::before {\n        content: \"\\\\f582\";\n    }\n\n    .bi-square-half::before {\n        content: \"\\\\f583\";\n    }\n\n    .bi-square::before {\n        content: \"\\\\f584\";\n    }\n\n    .bi-stack::before {\n        content: \"\\\\f585\";\n    }\n\n    .bi-star-fill::before {\n        content: \"\\\\f586\";\n    }\n\n    .bi-star-half::before {\n        content: \"\\\\f587\";\n    }\n\n    .bi-star::before {\n        content: \"\\\\f588\";\n    }\n\n    .bi-stars::before {\n        content: \"\\\\f589\";\n    }\n\n    .bi-stickies-fill::before {\n        content: \"\\\\f58a\";\n    }\n\n    .bi-stickies::before {\n        content: \"\\\\f58b\";\n    }\n\n    .bi-sticky-fill::before {\n        content: \"\\\\f58c\";\n    }\n\n    .bi-sticky::before {\n        content: \"\\\\f58d\";\n    }\n\n    .bi-stop-btn-fill::before {\n        content: \"\\\\f58e\";\n    }\n\n    .bi-stop-btn::before {\n        content: \"\\\\f58f\";\n    }\n\n    .bi-stop-circle-fill::before {\n        content: \"\\\\f590\";\n    }\n\n    .bi-stop-circle::before {\n        content: \"\\\\f591\";\n    }\n\n    .bi-stop-fill::before {\n        content: \"\\\\f592\";\n    }\n\n    .bi-stop::before {\n        content: \"\\\\f593\";\n    }\n\n    .bi-stoplights-fill::before {\n        content: \"\\\\f594\";\n    }\n\n    .bi-stoplights::before {\n        content: \"\\\\f595\";\n    }\n\n    .bi-stopwatch-fill::before {\n        content: \"\\\\f596\";\n    }\n\n    .bi-stopwatch::before {\n        content: \"\\\\f597\";\n    }\n\n    .bi-subtract::before {\n        content: \"\\\\f598\";\n    }\n\n    .bi-suit-club-fill::before {\n        content: \"\\\\f599\";\n    }\n\n    .bi-suit-club::before {\n        content: \"\\\\f59a\";\n    }\n\n    .bi-suit-diamond-fill::before {\n        content: \"\\\\f59b\";\n    }\n\n    .bi-suit-diamond::before {\n        content: \"\\\\f59c\";\n    }\n\n    .bi-suit-heart-fill::before {\n        content: \"\\\\f59d\";\n    }\n\n    .bi-suit-heart::before {\n        content: \"\\\\f59e\";\n    }\n\n    .bi-suit-spade-fill::before {\n        content: \"\\\\f59f\";\n    }\n\n    .bi-suit-spade::before {\n        content: \"\\\\f5a0\";\n    }\n\n    .bi-sun-fill::before {\n        content: \"\\\\f5a1\";\n    }\n\n    .bi-sun::before {\n        content: \"\\\\f5a2\";\n    }\n\n    .bi-sunglasses::before {\n        content: \"\\\\f5a3\";\n    }\n\n    .bi-sunrise-fill::before {\n        content: \"\\\\f5a4\";\n    }\n\n    .bi-sunrise::before {\n        content: \"\\\\f5a5\";\n    }\n\n    .bi-sunset-fill::before {\n        content: \"\\\\f5a6\";\n    }\n\n    .bi-sunset::before {\n        content: \"\\\\f5a7\";\n    }\n\n    .bi-symmetry-horizontal::before {\n        content: \"\\\\f5a8\";\n    }\n\n    .bi-symmetry-vertical::before {\n        content: \"\\\\f5a9\";\n    }\n\n    .bi-table::before {\n        content: \"\\\\f5aa\";\n    }\n\n    .bi-tablet-fill::before {\n        content: \"\\\\f5ab\";\n    }\n\n    .bi-tablet-landscape-fill::before {\n        content: \"\\\\f5ac\";\n    }\n\n    .bi-tablet-landscape::before {\n        content: \"\\\\f5ad\";\n    }\n\n    .bi-tablet::before {\n        content: \"\\\\f5ae\";\n    }\n\n    .bi-tag-fill::before {\n        content: \"\\\\f5af\";\n    }\n\n    .bi-tag::before {\n        content: \"\\\\f5b0\";\n    }\n\n    .bi-tags-fill::before {\n        content: \"\\\\f5b1\";\n    }\n\n    .bi-tags::before {\n        content: \"\\\\f5b2\";\n    }\n\n    .bi-telegram::before {\n        content: \"\\\\f5b3\";\n    }\n\n    .bi-telephone-fill::before {\n        content: \"\\\\f5b4\";\n    }\n\n    .bi-telephone-forward-fill::before {\n        content: \"\\\\f5b5\";\n    }\n\n    .bi-telephone-forward::before {\n        content: \"\\\\f5b6\";\n    }\n\n    .bi-telephone-inbound-fill::before {\n        content: \"\\\\f5b7\";\n    }\n\n    .bi-telephone-inbound::before {\n        content: \"\\\\f5b8\";\n    }\n\n    .bi-telephone-minus-fill::before {\n        content: \"\\\\f5b9\";\n    }\n\n    .bi-telephone-minus::before {\n        content: \"\\\\f5ba\";\n    }\n\n    .bi-telephone-outbound-fill::before {\n        content: \"\\\\f5bb\";\n    }\n\n    .bi-telephone-outbound::before {\n        content: \"\\\\f5bc\";\n    }\n\n    .bi-telephone-plus-fill::before {\n        content: \"\\\\f5bd\";\n    }\n\n    .bi-telephone-plus::before {\n        content: \"\\\\f5be\";\n    }\n\n    .bi-telephone-x-fill::before {\n        content: \"\\\\f5bf\";\n    }\n\n    .bi-telephone-x::before {\n        content: \"\\\\f5c0\";\n    }\n\n    .bi-telephone::before {\n        content: \"\\\\f5c1\";\n    }\n\n    .bi-terminal-fill::before {\n        content: \"\\\\f5c2\";\n    }\n\n    .bi-terminal::before {\n        content: \"\\\\f5c3\";\n    }\n\n    .bi-text-center::before {\n        content: \"\\\\f5c4\";\n    }\n\n    .bi-text-indent-left::before {\n        content: \"\\\\f5c5\";\n    }\n\n    .bi-text-indent-right::before {\n        content: \"\\\\f5c6\";\n    }\n\n    .bi-text-left::before {\n        content: \"\\\\f5c7\";\n    }\n\n    .bi-text-paragraph::before {\n        content: \"\\\\f5c8\";\n    }\n\n    .bi-text-right::before {\n        content: \"\\\\f5c9\";\n    }\n\n    .bi-textarea-resize::before {\n        content: \"\\\\f5ca\";\n    }\n\n    .bi-textarea-t::before {\n        content: \"\\\\f5cb\";\n    }\n\n    .bi-textarea::before {\n        content: \"\\\\f5cc\";\n    }\n\n    .bi-thermometer-half::before {\n        content: \"\\\\f5cd\";\n    }\n\n    .bi-thermometer-high::before {\n        content: \"\\\\f5ce\";\n    }\n\n    .bi-thermometer-low::before {\n        content: \"\\\\f5cf\";\n    }\n\n    .bi-thermometer-snow::before {\n        content: \"\\\\f5d0\";\n    }\n\n    .bi-thermometer-sun::before {\n        content: \"\\\\f5d1\";\n    }\n\n    .bi-thermometer::before {\n        content: \"\\\\f5d2\";\n    }\n\n    .bi-three-dots-vertical::before {\n        content: \"\\\\f5d3\";\n    }\n\n    .bi-three-dots::before {\n        content: \"\\\\f5d4\";\n    }\n\n    .bi-toggle-off::before {\n        content: \"\\\\f5d5\";\n    }\n\n    .bi-toggle-on::before {\n        content: \"\\\\f5d6\";\n    }\n\n    .bi-toggle2-off::before {\n        content: \"\\\\f5d7\";\n    }\n\n    .bi-toggle2-on::before {\n        content: \"\\\\f5d8\";\n    }\n\n    .bi-toggles::before {\n        content: \"\\\\f5d9\";\n    }\n\n    .bi-toggles2::before {\n        content: \"\\\\f5da\";\n    }\n\n    .bi-tools::before {\n        content: \"\\\\f5db\";\n    }\n\n    .bi-tornado::before {\n        content: \"\\\\f5dc\";\n    }\n\n    .bi-trash-fill::before {\n        content: \"\\\\f5dd\";\n    }\n\n    .bi-trash::before {\n        content: \"\\\\f5de\";\n    }\n\n    .bi-trash2-fill::before {\n        content: \"\\\\f5df\";\n    }\n\n    .bi-trash2::before {\n        content: \"\\\\f5e0\";\n    }\n\n    .bi-tree-fill::before {\n        content: \"\\\\f5e1\";\n    }\n\n    .bi-tree::before {\n        content: \"\\\\f5e2\";\n    }\n\n    .bi-triangle-fill::before {\n        content: \"\\\\f5e3\";\n    }\n\n    .bi-triangle-half::before {\n        content: \"\\\\f5e4\";\n    }\n\n    .bi-triangle::before {\n        content: \"\\\\f5e5\";\n    }\n\n    .bi-trophy-fill::before {\n        content: \"\\\\f5e6\";\n    }\n\n    .bi-trophy::before {\n        content: \"\\\\f5e7\";\n    }\n\n    .bi-tropical-storm::before {\n        content: \"\\\\f5e8\";\n    }\n\n    .bi-truck-flatbed::before {\n        content: \"\\\\f5e9\";\n    }\n\n    .bi-truck::before {\n        content: \"\\\\f5ea\";\n    }\n\n    .bi-tsunami::before {\n        content: \"\\\\f5eb\";\n    }\n\n    .bi-tv-fill::before {\n        content: \"\\\\f5ec\";\n    }\n\n    .bi-tv::before {\n        content: \"\\\\f5ed\";\n    }\n\n    .bi-twitch::before {\n        content: \"\\\\f5ee\";\n    }\n\n    .bi-twitter::before {\n        content: \"\\\\f5ef\";\n    }\n\n    .bi-type-bold::before {\n        content: \"\\\\f5f0\";\n    }\n\n    .bi-type-h1::before {\n        content: \"\\\\f5f1\";\n    }\n\n    .bi-type-h2::before {\n        content: \"\\\\f5f2\";\n    }\n\n    .bi-type-h3::before {\n        content: \"\\\\f5f3\";\n    }\n\n    .bi-type-italic::before {\n        content: \"\\\\f5f4\";\n    }\n\n    .bi-type-strikethrough::before {\n        content: \"\\\\f5f5\";\n    }\n\n    .bi-type-underline::before {\n        content: \"\\\\f5f6\";\n    }\n\n    .bi-type::before {\n        content: \"\\\\f5f7\";\n    }\n\n    .bi-ui-checks-grid::before {\n        content: \"\\\\f5f8\";\n    }\n\n    .bi-ui-checks::before {\n        content: \"\\\\f5f9\";\n    }\n\n    .bi-ui-radios-grid::before {\n        content: \"\\\\f5fa\";\n    }\n\n    .bi-ui-radios::before {\n        content: \"\\\\f5fb\";\n    }\n\n    .bi-umbrella-fill::before {\n        content: \"\\\\f5fc\";\n    }\n\n    .bi-umbrella::before {\n        content: \"\\\\f5fd\";\n    }\n\n    .bi-union::before {\n        content: \"\\\\f5fe\";\n    }\n\n    .bi-unlock-fill::before {\n        content: \"\\\\f5ff\";\n    }\n\n    .bi-unlock::before {\n        content: \"\\\\f600\";\n    }\n\n    .bi-upc-scan::before {\n        content: \"\\\\f601\";\n    }\n\n    .bi-upc::before {\n        content: \"\\\\f602\";\n    }\n\n    .bi-upload::before {\n        content: \"\\\\f603\";\n    }\n\n    .bi-vector-pen::before {\n        content: \"\\\\f604\";\n    }\n\n    .bi-view-list::before {\n        content: \"\\\\f605\";\n    }\n\n    .bi-view-stacked::before {\n        content: \"\\\\f606\";\n    }\n\n    .bi-vinyl-fill::before {\n        content: \"\\\\f607\";\n    }\n\n    .bi-vinyl::before {\n        content: \"\\\\f608\";\n    }\n\n    .bi-voicemail::before {\n        content: \"\\\\f609\";\n    }\n\n    .bi-volume-down-fill::before {\n        content: \"\\\\f60a\";\n    }\n\n    .bi-volume-down::before {\n        content: \"\\\\f60b\";\n    }\n\n    .bi-volume-mute-fill::before {\n        content: \"\\\\f60c\";\n    }\n\n    .bi-volume-mute::before {\n        content: \"\\\\f60d\";\n    }\n\n    .bi-volume-off-fill::before {\n        content: \"\\\\f60e\";\n    }\n\n    .bi-volume-off::before {\n        content: \"\\\\f60f\";\n    }\n\n    .bi-volume-up-fill::before {\n        content: \"\\\\f610\";\n    }\n\n    .bi-volume-up::before {\n        content: \"\\\\f611\";\n    }\n\n    .bi-vr::before {\n        content: \"\\\\f612\";\n    }\n\n    .bi-wallet-fill::before {\n        content: \"\\\\f613\";\n    }\n\n    .bi-wallet::before {\n        content: \"\\\\f614\";\n    }\n\n    .bi-wallet2::before {\n        content: \"\\\\f615\";\n    }\n\n    .bi-watch::before {\n        content: \"\\\\f616\";\n    }\n\n    .bi-water::before {\n        content: \"\\\\f617\";\n    }\n\n    .bi-whatsapp::before {\n        content: \"\\\\f618\";\n    }\n\n    .bi-wifi-1::before {\n        content: \"\\\\f619\";\n    }\n\n    .bi-wifi-2::before {\n        content: \"\\\\f61a\";\n    }\n\n    .bi-wifi-off::before {\n        content: \"\\\\f61b\";\n    }\n\n    .bi-wifi::before {\n        content: \"\\\\f61c\";\n    }\n\n    .bi-wind::before {\n        content: \"\\\\f61d\";\n    }\n\n    .bi-window-dock::before {\n        content: \"\\\\f61e\";\n    }\n\n    .bi-window-sidebar::before {\n        content: \"\\\\f61f\";\n    }\n\n    .bi-window::before {\n        content: \"\\\\f620\";\n    }\n\n    .bi-wrench::before {\n        content: \"\\\\f621\";\n    }\n\n    .bi-x-circle-fill::before {\n        content: \"\\\\f622\";\n    }\n\n    .bi-x-circle::before {\n        content: \"\\\\f623\";\n    }\n\n    .bi-x-diamond-fill::before {\n        content: \"\\\\f624\";\n    }\n\n    .bi-x-diamond::before {\n        content: \"\\\\f625\";\n    }\n\n    .bi-x-octagon-fill::before {\n        content: \"\\\\f626\";\n    }\n\n    .bi-x-octagon::before {\n        content: \"\\\\f627\";\n    }\n\n    .bi-x-square-fill::before {\n        content: \"\\\\f628\";\n    }\n\n    .bi-x-square::before {\n        content: \"\\\\f629\";\n    }\n\n    .bi-x::before {\n        content: \"\\\\f62a\";\n    }\n\n    .bi-youtube::before {\n        content: \"\\\\f62b\";\n    }\n\n    .bi-zoom-in::before {\n        content: \"\\\\f62c\";\n    }\n\n    .bi-zoom-out::before {\n        content: \"\\\\f62d\";\n    }\n\n    .bi-bank::before {\n        content: \"\\\\f62e\";\n    }\n\n    .bi-bank2::before {\n        content: \"\\\\f62f\";\n    }\n\n    .bi-bell-slash-fill::before {\n        content: \"\\\\f630\";\n    }\n\n    .bi-bell-slash::before {\n        content: \"\\\\f631\";\n    }\n\n    .bi-cash-coin::before {\n        content: \"\\\\f632\";\n    }\n\n    .bi-check-lg::before {\n        content: \"\\\\f633\";\n    }\n\n    .bi-coin::before {\n        content: \"\\\\f634\";\n    }\n\n    .bi-currency-bitcoin::before {\n        content: \"\\\\f635\";\n    }\n\n    .bi-currency-dollar::before {\n        content: \"\\\\f636\";\n    }\n\n    .bi-currency-euro::before {\n        content: \"\\\\f637\";\n    }\n\n    .bi-currency-exchange::before {\n        content: \"\\\\f638\";\n    }\n\n    .bi-currency-pound::before {\n        content: \"\\\\f639\";\n    }\n\n    .bi-currency-yen::before {\n        content: \"\\\\f63a\";\n    }\n\n    .bi-dash-lg::before {\n        content: \"\\\\f63b\";\n    }\n\n    .bi-exclamation-lg::before {\n        content: \"\\\\f63c\";\n    }\n\n    .bi-file-earmark-pdf-fill::before {\n        content: \"\\\\f63d\";\n    }\n\n    .bi-file-earmark-pdf::before {\n        content: \"\\\\f63e\";\n    }\n\n    .bi-file-pdf-fill::before {\n        content: \"\\\\f63f\";\n    }\n\n    .bi-file-pdf::before {\n        content: \"\\\\f640\";\n    }\n\n    .bi-gender-ambiguous::before {\n        content: \"\\\\f641\";\n    }\n\n    .bi-gender-female::before {\n        content: \"\\\\f642\";\n    }\n\n    .bi-gender-male::before {\n        content: \"\\\\f643\";\n    }\n\n    .bi-gender-trans::before {\n        content: \"\\\\f644\";\n    }\n\n    .bi-headset-vr::before {\n        content: \"\\\\f645\";\n    }\n\n    .bi-info-lg::before {\n        content: \"\\\\f646\";\n    }\n\n    .bi-mastodon::before {\n        content: \"\\\\f647\";\n    }\n\n    .bi-messenger::before {\n        content: \"\\\\f648\";\n    }\n\n    .bi-piggy-bank-fill::before {\n        content: \"\\\\f649\";\n    }\n\n    .bi-piggy-bank::before {\n        content: \"\\\\f64a\";\n    }\n\n    .bi-pin-map-fill::before {\n        content: \"\\\\f64b\";\n    }\n\n    .bi-pin-map::before {\n        content: \"\\\\f64c\";\n    }\n\n    .bi-plus-lg::before {\n        content: \"\\\\f64d\";\n    }\n\n    .bi-question-lg::before {\n        content: \"\\\\f64e\";\n    }\n\n    .bi-recycle::before {\n        content: \"\\\\f64f\";\n    }\n\n    .bi-reddit::before {\n        content: \"\\\\f650\";\n    }\n\n    .bi-safe-fill::before {\n        content: \"\\\\f651\";\n    }\n\n    .bi-safe2-fill::before {\n        content: \"\\\\f652\";\n    }\n\n    .bi-safe2::before {\n        content: \"\\\\f653\";\n    }\n\n    .bi-sd-card-fill::before {\n        content: \"\\\\f654\";\n    }\n\n    .bi-sd-card::before {\n        content: \"\\\\f655\";\n    }\n\n    .bi-skype::before {\n        content: \"\\\\f656\";\n    }\n\n    .bi-slash-lg::before {\n        content: \"\\\\f657\";\n    }\n\n    .bi-translate::before {\n        content: \"\\\\f658\";\n    }\n\n    .bi-x-lg::before {\n        content: \"\\\\f659\";\n    }\n\n    .bi-safe::before {\n        content: \"\\\\f65a\";\n    }\n\n    .bi-apple::before {\n        content: \"\\\\f65b\";\n    }\n\n    .bi-microsoft::before {\n        content: \"\\\\f65d\";\n    }\n\n    .bi-windows::before {\n        content: \"\\\\f65e\";\n    }\n\n    .bi-behance::before {\n        content: \"\\\\f65c\";\n    }\n\n    .bi-dribbble::before {\n        content: \"\\\\f65f\";\n    }\n\n    .bi-line::before {\n        content: \"\\\\f660\";\n    }\n\n    .bi-medium::before {\n        content: \"\\\\f661\";\n    }\n\n    .bi-paypal::before {\n        content: \"\\\\f662\";\n    }\n\n    .bi-pinterest::before {\n        content: \"\\\\f663\";\n    }\n\n    .bi-signal::before {\n        content: \"\\\\f664\";\n    }\n\n    .bi-snapchat::before {\n        content: \"\\\\f665\";\n    }\n\n    .bi-spotify::before {\n        content: \"\\\\f666\";\n    }\n\n    .bi-stack-overflow::before {\n        content: \"\\\\f667\";\n    }\n\n    .bi-strava::before {\n        content: \"\\\\f668\";\n    }\n\n    .bi-wordpress::before {\n        content: \"\\\\f669\";\n    }\n\n    .bi-vimeo::before {\n        content: \"\\\\f66a\";\n    }\n\n    .bi-activity::before {\n        content: \"\\\\f66b\";\n    }\n\n    .bi-easel2-fill::before {\n        content: \"\\\\f66c\";\n    }\n\n    .bi-easel2::before {\n        content: \"\\\\f66d\";\n    }\n\n    .bi-easel3-fill::before {\n        content: \"\\\\f66e\";\n    }\n\n    .bi-easel3::before {\n        content: \"\\\\f66f\";\n    }\n\n    .bi-fan::before {\n        content: \"\\\\f670\";\n    }\n\n    .bi-fingerprint::before {\n        content: \"\\\\f671\";\n    }\n\n    .bi-graph-down-arrow::before {\n        content: \"\\\\f672\";\n    }\n\n    .bi-graph-up-arrow::before {\n        content: \"\\\\f673\";\n    }\n\n    .bi-hypnotize::before {\n        content: \"\\\\f674\";\n    }\n\n    .bi-magic::before {\n        content: \"\\\\f675\";\n    }\n\n    .bi-person-rolodex::before {\n        content: \"\\\\f676\";\n    }\n\n    .bi-person-video::before {\n        content: \"\\\\f677\";\n    }\n\n    .bi-person-video2::before {\n        content: \"\\\\f678\";\n    }\n\n    .bi-person-video3::before {\n        content: \"\\\\f679\";\n    }\n\n    .bi-person-workspace::before {\n        content: \"\\\\f67a\";\n    }\n\n    .bi-radioactive::before {\n        content: \"\\\\f67b\";\n    }\n\n    .bi-webcam-fill::before {\n        content: \"\\\\f67c\";\n    }\n\n    .bi-webcam::before {\n        content: \"\\\\f67d\";\n    }\n\n    .bi-yin-yang::before {\n        content: \"\\\\f67e\";\n    }\n\n    .bi-bandaid-fill::before {\n        content: \"\\\\f680\";\n    }\n\n    .bi-bandaid::before {\n        content: \"\\\\f681\";\n    }\n\n    .bi-bluetooth::before {\n        content: \"\\\\f682\";\n    }\n\n    .bi-body-text::before {\n        content: \"\\\\f683\";\n    }\n\n    .bi-boombox::before {\n        content: \"\\\\f684\";\n    }\n\n    .bi-boxes::before {\n        content: \"\\\\f685\";\n    }\n\n    .bi-dpad-fill::before {\n        content: \"\\\\f686\";\n    }\n\n    .bi-dpad::before {\n        content: \"\\\\f687\";\n    }\n\n    .bi-ear-fill::before {\n        content: \"\\\\f688\";\n    }\n\n    .bi-ear::before {\n        content: \"\\\\f689\";\n    }\n\n    .bi-envelope-check-fill::before {\n        content: \"\\\\f68b\";\n    }\n\n    .bi-envelope-check::before {\n        content: \"\\\\f68c\";\n    }\n\n    .bi-envelope-dash-fill::before {\n        content: \"\\\\f68e\";\n    }\n\n    .bi-envelope-dash::before {\n        content: \"\\\\f68f\";\n    }\n\n    .bi-envelope-exclamation-fill::before {\n        content: \"\\\\f691\";\n    }\n\n    .bi-envelope-exclamation::before {\n        content: \"\\\\f692\";\n    }\n\n    .bi-envelope-plus-fill::before {\n        content: \"\\\\f693\";\n    }\n\n    .bi-envelope-plus::before {\n        content: \"\\\\f694\";\n    }\n\n    .bi-envelope-slash-fill::before {\n        content: \"\\\\f696\";\n    }\n\n    .bi-envelope-slash::before {\n        content: \"\\\\f697\";\n    }\n\n    .bi-envelope-x-fill::before {\n        content: \"\\\\f699\";\n    }\n\n    .bi-envelope-x::before {\n        content: \"\\\\f69a\";\n    }\n\n    .bi-explicit-fill::before {\n        content: \"\\\\f69b\";\n    }\n\n    .bi-explicit::before {\n        content: \"\\\\f69c\";\n    }\n\n    .bi-git::before {\n        content: \"\\\\f69d\";\n    }\n\n    .bi-infinity::before {\n        content: \"\\\\f69e\";\n    }\n\n    .bi-list-columns-reverse::before {\n        content: \"\\\\f69f\";\n    }\n\n    .bi-list-columns::before {\n        content: \"\\\\f6a0\";\n    }\n\n    .bi-meta::before {\n        content: \"\\\\f6a1\";\n    }\n\n    .bi-nintendo-switch::before {\n        content: \"\\\\f6a4\";\n    }\n\n    .bi-pc-display-horizontal::before {\n        content: \"\\\\f6a5\";\n    }\n\n    .bi-pc-display::before {\n        content: \"\\\\f6a6\";\n    }\n\n    .bi-pc-horizontal::before {\n        content: \"\\\\f6a7\";\n    }\n\n    .bi-pc::before {\n        content: \"\\\\f6a8\";\n    }\n\n    .bi-playstation::before {\n        content: \"\\\\f6a9\";\n    }\n\n    .bi-plus-slash-minus::before {\n        content: \"\\\\f6aa\";\n    }\n\n    .bi-projector-fill::before {\n        content: \"\\\\f6ab\";\n    }\n\n    .bi-projector::before {\n        content: \"\\\\f6ac\";\n    }\n\n    .bi-qr-code-scan::before {\n        content: \"\\\\f6ad\";\n    }\n\n    .bi-qr-code::before {\n        content: \"\\\\f6ae\";\n    }\n\n    .bi-quora::before {\n        content: \"\\\\f6af\";\n    }\n\n    .bi-quote::before {\n        content: \"\\\\f6b0\";\n    }\n\n    .bi-robot::before {\n        content: \"\\\\f6b1\";\n    }\n\n    .bi-send-check-fill::before {\n        content: \"\\\\f6b2\";\n    }\n\n    .bi-send-check::before {\n        content: \"\\\\f6b3\";\n    }\n\n    .bi-send-dash-fill::before {\n        content: \"\\\\f6b4\";\n    }\n\n    .bi-send-dash::before {\n        content: \"\\\\f6b5\";\n    }\n\n    .bi-send-exclamation-fill::before {\n        content: \"\\\\f6b7\";\n    }\n\n    .bi-send-exclamation::before {\n        content: \"\\\\f6b8\";\n    }\n\n    .bi-send-fill::before {\n        content: \"\\\\f6b9\";\n    }\n\n    .bi-send-plus-fill::before {\n        content: \"\\\\f6ba\";\n    }\n\n    .bi-send-plus::before {\n        content: \"\\\\f6bb\";\n    }\n\n    .bi-send-slash-fill::before {\n        content: \"\\\\f6bc\";\n    }\n\n    .bi-send-slash::before {\n        content: \"\\\\f6bd\";\n    }\n\n    .bi-send-x-fill::before {\n        content: \"\\\\f6be\";\n    }\n\n    .bi-send-x::before {\n        content: \"\\\\f6bf\";\n    }\n\n    .bi-send::before {\n        content: \"\\\\f6c0\";\n    }\n\n    .bi-steam::before {\n        content: \"\\\\f6c1\";\n    }\n\n    .bi-terminal-dash::before {\n        content: \"\\\\f6c3\";\n    }\n\n    .bi-terminal-plus::before {\n        content: \"\\\\f6c4\";\n    }\n\n    .bi-terminal-split::before {\n        content: \"\\\\f6c5\";\n    }\n\n    .bi-ticket-detailed-fill::before {\n        content: \"\\\\f6c6\";\n    }\n\n    .bi-ticket-detailed::before {\n        content: \"\\\\f6c7\";\n    }\n\n    .bi-ticket-fill::before {\n        content: \"\\\\f6c8\";\n    }\n\n    .bi-ticket-perforated-fill::before {\n        content: \"\\\\f6c9\";\n    }\n\n    .bi-ticket-perforated::before {\n        content: \"\\\\f6ca\";\n    }\n\n    .bi-ticket::before {\n        content: \"\\\\f6cb\";\n    }\n\n    .bi-tiktok::before {\n        content: \"\\\\f6cc\";\n    }\n\n    .bi-window-dash::before {\n        content: \"\\\\f6cd\";\n    }\n\n    .bi-window-desktop::before {\n        content: \"\\\\f6ce\";\n    }\n\n    .bi-window-fullscreen::before {\n        content: \"\\\\f6cf\";\n    }\n\n    .bi-window-plus::before {\n        content: \"\\\\f6d0\";\n    }\n\n    .bi-window-split::before {\n        content: \"\\\\f6d1\";\n    }\n\n    .bi-window-stack::before {\n        content: \"\\\\f6d2\";\n    }\n\n    .bi-window-x::before {\n        content: \"\\\\f6d3\";\n    }\n\n    .bi-xbox::before {\n        content: \"\\\\f6d4\";\n    }\n\n    .bi-ethernet::before {\n        content: \"\\\\f6d5\";\n    }\n\n    .bi-hdmi-fill::before {\n        content: \"\\\\f6d6\";\n    }\n\n    .bi-hdmi::before {\n        content: \"\\\\f6d7\";\n    }\n\n    .bi-usb-c-fill::before {\n        content: \"\\\\f6d8\";\n    }\n\n    .bi-usb-c::before {\n        content: \"\\\\f6d9\";\n    }\n\n    .bi-usb-fill::before {\n        content: \"\\\\f6da\";\n    }\n\n    .bi-usb-plug-fill::before {\n        content: \"\\\\f6db\";\n    }\n\n    .bi-usb-plug::before {\n        content: \"\\\\f6dc\";\n    }\n\n    .bi-usb-symbol::before {\n        content: \"\\\\f6dd\";\n    }\n\n    .bi-usb::before {\n        content: \"\\\\f6de\";\n    }\n\n    .bi-boombox-fill::before {\n        content: \"\\\\f6df\";\n    }\n\n    .bi-displayport::before {\n        content: \"\\\\f6e1\";\n    }\n\n    .bi-gpu-card::before {\n        content: \"\\\\f6e2\";\n    }\n\n    .bi-memory::before {\n        content: \"\\\\f6e3\";\n    }\n\n    .bi-modem-fill::before {\n        content: \"\\\\f6e4\";\n    }\n\n    .bi-modem::before {\n        content: \"\\\\f6e5\";\n    }\n\n    .bi-motherboard-fill::before {\n        content: \"\\\\f6e6\";\n    }\n\n    .bi-motherboard::before {\n        content: \"\\\\f6e7\";\n    }\n\n    .bi-optical-audio-fill::before {\n        content: \"\\\\f6e8\";\n    }\n\n    .bi-optical-audio::before {\n        content: \"\\\\f6e9\";\n    }\n\n    .bi-pci-card::before {\n        content: \"\\\\f6ea\";\n    }\n\n    .bi-router-fill::before {\n        content: \"\\\\f6eb\";\n    }\n\n    .bi-router::before {\n        content: \"\\\\f6ec\";\n    }\n\n    .bi-thunderbolt-fill::before {\n        content: \"\\\\f6ef\";\n    }\n\n    .bi-thunderbolt::before {\n        content: \"\\\\f6f0\";\n    }\n\n    .bi-usb-drive-fill::before {\n        content: \"\\\\f6f1\";\n    }\n\n    .bi-usb-drive::before {\n        content: \"\\\\f6f2\";\n    }\n\n    .bi-usb-micro-fill::before {\n        content: \"\\\\f6f3\";\n    }\n\n    .bi-usb-micro::before {\n        content: \"\\\\f6f4\";\n    }\n\n    .bi-usb-mini-fill::before {\n        content: \"\\\\f6f5\";\n    }\n\n    .bi-usb-mini::before {\n        content: \"\\\\f6f6\";\n    }\n\n    .bi-cloud-haze2::before {\n        content: \"\\\\f6f7\";\n    }\n\n    .bi-device-hdd-fill::before {\n        content: \"\\\\f6f8\";\n    }\n\n    .bi-device-hdd::before {\n        content: \"\\\\f6f9\";\n    }\n\n    .bi-device-ssd-fill::before {\n        content: \"\\\\f6fa\";\n    }\n\n    .bi-device-ssd::before {\n        content: \"\\\\f6fb\";\n    }\n\n    .bi-displayport-fill::before {\n        content: \"\\\\f6fc\";\n    }\n\n    .bi-mortarboard-fill::before {\n        content: \"\\\\f6fd\";\n    }\n\n    .bi-mortarboard::before {\n        content: \"\\\\f6fe\";\n    }\n\n    .bi-terminal-x::before {\n        content: \"\\\\f6ff\";\n    }\n\n    .bi-arrow-through-heart-fill::before {\n        content: \"\\\\f700\";\n    }\n\n    .bi-arrow-through-heart::before {\n        content: \"\\\\f701\";\n    }\n\n    .bi-badge-sd-fill::before {\n        content: \"\\\\f702\";\n    }\n\n    .bi-badge-sd::before {\n        content: \"\\\\f703\";\n    }\n\n    .bi-bag-heart-fill::before {\n        content: \"\\\\f704\";\n    }\n\n    .bi-bag-heart::before {\n        content: \"\\\\f705\";\n    }\n\n    .bi-balloon-fill::before {\n        content: \"\\\\f706\";\n    }\n\n    .bi-balloon-heart-fill::before {\n        content: \"\\\\f707\";\n    }\n\n    .bi-balloon-heart::before {\n        content: \"\\\\f708\";\n    }\n\n    .bi-balloon::before {\n        content: \"\\\\f709\";\n    }\n\n    .bi-box2-fill::before {\n        content: \"\\\\f70a\";\n    }\n\n    .bi-box2-heart-fill::before {\n        content: \"\\\\f70b\";\n    }\n\n    .bi-box2-heart::before {\n        content: \"\\\\f70c\";\n    }\n\n    .bi-box2::before {\n        content: \"\\\\f70d\";\n    }\n\n    .bi-braces-asterisk::before {\n        content: \"\\\\f70e\";\n    }\n\n    .bi-calendar-heart-fill::before {\n        content: \"\\\\f70f\";\n    }\n\n    .bi-calendar-heart::before {\n        content: \"\\\\f710\";\n    }\n\n    .bi-calendar2-heart-fill::before {\n        content: \"\\\\f711\";\n    }\n\n    .bi-calendar2-heart::before {\n        content: \"\\\\f712\";\n    }\n\n    .bi-chat-heart-fill::before {\n        content: \"\\\\f713\";\n    }\n\n    .bi-chat-heart::before {\n        content: \"\\\\f714\";\n    }\n\n    .bi-chat-left-heart-fill::before {\n        content: \"\\\\f715\";\n    }\n\n    .bi-chat-left-heart::before {\n        content: \"\\\\f716\";\n    }\n\n    .bi-chat-right-heart-fill::before {\n        content: \"\\\\f717\";\n    }\n\n    .bi-chat-right-heart::before {\n        content: \"\\\\f718\";\n    }\n\n    .bi-chat-square-heart-fill::before {\n        content: \"\\\\f719\";\n    }\n\n    .bi-chat-square-heart::before {\n        content: \"\\\\f71a\";\n    }\n\n    .bi-clipboard-check-fill::before {\n        content: \"\\\\f71b\";\n    }\n\n    .bi-clipboard-data-fill::before {\n        content: \"\\\\f71c\";\n    }\n\n    .bi-clipboard-fill::before {\n        content: \"\\\\f71d\";\n    }\n\n    .bi-clipboard-heart-fill::before {\n        content: \"\\\\f71e\";\n    }\n\n    .bi-clipboard-heart::before {\n        content: \"\\\\f71f\";\n    }\n\n    .bi-clipboard-minus-fill::before {\n        content: \"\\\\f720\";\n    }\n\n    .bi-clipboard-plus-fill::before {\n        content: \"\\\\f721\";\n    }\n\n    .bi-clipboard-pulse::before {\n        content: \"\\\\f722\";\n    }\n\n    .bi-clipboard-x-fill::before {\n        content: \"\\\\f723\";\n    }\n\n    .bi-clipboard2-check-fill::before {\n        content: \"\\\\f724\";\n    }\n\n    .bi-clipboard2-check::before {\n        content: \"\\\\f725\";\n    }\n\n    .bi-clipboard2-data-fill::before {\n        content: \"\\\\f726\";\n    }\n\n    .bi-clipboard2-data::before {\n        content: \"\\\\f727\";\n    }\n\n    .bi-clipboard2-fill::before {\n        content: \"\\\\f728\";\n    }\n\n    .bi-clipboard2-heart-fill::before {\n        content: \"\\\\f729\";\n    }\n\n    .bi-clipboard2-heart::before {\n        content: \"\\\\f72a\";\n    }\n\n    .bi-clipboard2-minus-fill::before {\n        content: \"\\\\f72b\";\n    }\n\n    .bi-clipboard2-minus::before {\n        content: \"\\\\f72c\";\n    }\n\n    .bi-clipboard2-plus-fill::before {\n        content: \"\\\\f72d\";\n    }\n\n    .bi-clipboard2-plus::before {\n        content: \"\\\\f72e\";\n    }\n\n    .bi-clipboard2-pulse-fill::before {\n        content: \"\\\\f72f\";\n    }\n\n    .bi-clipboard2-pulse::before {\n        content: \"\\\\f730\";\n    }\n\n    .bi-clipboard2-x-fill::before {\n        content: \"\\\\f731\";\n    }\n\n    .bi-clipboard2-x::before {\n        content: \"\\\\f732\";\n    }\n\n    .bi-clipboard2::before {\n        content: \"\\\\f733\";\n    }\n\n    .bi-emoji-kiss-fill::before {\n        content: \"\\\\f734\";\n    }\n\n    .bi-emoji-kiss::before {\n        content: \"\\\\f735\";\n    }\n\n    .bi-envelope-heart-fill::before {\n        content: \"\\\\f736\";\n    }\n\n    .bi-envelope-heart::before {\n        content: \"\\\\f737\";\n    }\n\n    .bi-envelope-open-heart-fill::before {\n        content: \"\\\\f738\";\n    }\n\n    .bi-envelope-open-heart::before {\n        content: \"\\\\f739\";\n    }\n\n    .bi-envelope-paper-fill::before {\n        content: \"\\\\f73a\";\n    }\n\n    .bi-envelope-paper-heart-fill::before {\n        content: \"\\\\f73b\";\n    }\n\n    .bi-envelope-paper-heart::before {\n        content: \"\\\\f73c\";\n    }\n\n    .bi-envelope-paper::before {\n        content: \"\\\\f73d\";\n    }\n\n    .bi-filetype-aac::before {\n        content: \"\\\\f73e\";\n    }\n\n    .bi-filetype-ai::before {\n        content: \"\\\\f73f\";\n    }\n\n    .bi-filetype-bmp::before {\n        content: \"\\\\f740\";\n    }\n\n    .bi-filetype-cs::before {\n        content: \"\\\\f741\";\n    }\n\n    .bi-filetype-css::before {\n        content: \"\\\\f742\";\n    }\n\n    .bi-filetype-csv::before {\n        content: \"\\\\f743\";\n    }\n\n    .bi-filetype-doc::before {\n        content: \"\\\\f744\";\n    }\n\n    .bi-filetype-docx::before {\n        content: \"\\\\f745\";\n    }\n\n    .bi-filetype-exe::before {\n        content: \"\\\\f746\";\n    }\n\n    .bi-filetype-gif::before {\n        content: \"\\\\f747\";\n    }\n\n    .bi-filetype-heic::before {\n        content: \"\\\\f748\";\n    }\n\n    .bi-filetype-html::before {\n        content: \"\\\\f749\";\n    }\n\n    .bi-filetype-java::before {\n        content: \"\\\\f74a\";\n    }\n\n    .bi-filetype-jpg::before {\n        content: \"\\\\f74b\";\n    }\n\n    .bi-filetype-js::before {\n        content: \"\\\\f74c\";\n    }\n\n    .bi-filetype-jsx::before {\n        content: \"\\\\f74d\";\n    }\n\n    .bi-filetype-key::before {\n        content: \"\\\\f74e\";\n    }\n\n    .bi-filetype-m4p::before {\n        content: \"\\\\f74f\";\n    }\n\n    .bi-filetype-md::before {\n        content: \"\\\\f750\";\n    }\n\n    .bi-filetype-mdx::before {\n        content: \"\\\\f751\";\n    }\n\n    .bi-filetype-mov::before {\n        content: \"\\\\f752\";\n    }\n\n    .bi-filetype-mp3::before {\n        content: \"\\\\f753\";\n    }\n\n    .bi-filetype-mp4::before {\n        content: \"\\\\f754\";\n    }\n\n    .bi-filetype-otf::before {\n        content: \"\\\\f755\";\n    }\n\n    .bi-filetype-pdf::before {\n        content: \"\\\\f756\";\n    }\n\n    .bi-filetype-php::before {\n        content: \"\\\\f757\";\n    }\n\n    .bi-filetype-png::before {\n        content: \"\\\\f758\";\n    }\n\n    .bi-filetype-ppt::before {\n        content: \"\\\\f75a\";\n    }\n\n    .bi-filetype-psd::before {\n        content: \"\\\\f75b\";\n    }\n\n    .bi-filetype-py::before {\n        content: \"\\\\f75c\";\n    }\n\n    .bi-filetype-raw::before {\n        content: \"\\\\f75d\";\n    }\n\n    .bi-filetype-rb::before {\n        content: \"\\\\f75e\";\n    }\n\n    .bi-filetype-sass::before {\n        content: \"\\\\f75f\";\n    }\n\n    .bi-filetype-scss::before {\n        content: \"\\\\f760\";\n    }\n\n    .bi-filetype-sh::before {\n        content: \"\\\\f761\";\n    }\n\n    .bi-filetype-svg::before {\n        content: \"\\\\f762\";\n    }\n\n    .bi-filetype-tiff::before {\n        content: \"\\\\f763\";\n    }\n\n    .bi-filetype-tsx::before {\n        content: \"\\\\f764\";\n    }\n\n    .bi-filetype-ttf::before {\n        content: \"\\\\f765\";\n    }\n\n    .bi-filetype-txt::before {\n        content: \"\\\\f766\";\n    }\n\n    .bi-filetype-wav::before {\n        content: \"\\\\f767\";\n    }\n\n    .bi-filetype-woff::before {\n        content: \"\\\\f768\";\n    }\n\n    .bi-filetype-xls::before {\n        content: \"\\\\f76a\";\n    }\n\n    .bi-filetype-xml::before {\n        content: \"\\\\f76b\";\n    }\n\n    .bi-filetype-yml::before {\n        content: \"\\\\f76c\";\n    }\n\n    .bi-heart-arrow::before {\n        content: \"\\\\f76d\";\n    }\n\n    .bi-heart-pulse-fill::before {\n        content: \"\\\\f76e\";\n    }\n\n    .bi-heart-pulse::before {\n        content: \"\\\\f76f\";\n    }\n\n    .bi-heartbreak-fill::before {\n        content: \"\\\\f770\";\n    }\n\n    .bi-heartbreak::before {\n        content: \"\\\\f771\";\n    }\n\n    .bi-hearts::before {\n        content: \"\\\\f772\";\n    }\n\n    .bi-hospital-fill::before {\n        content: \"\\\\f773\";\n    }\n\n    .bi-hospital::before {\n        content: \"\\\\f774\";\n    }\n\n    .bi-house-heart-fill::before {\n        content: \"\\\\f775\";\n    }\n\n    .bi-house-heart::before {\n        content: \"\\\\f776\";\n    }\n\n    .bi-incognito::before {\n        content: \"\\\\f777\";\n    }\n\n    .bi-magnet-fill::before {\n        content: \"\\\\f778\";\n    }\n\n    .bi-magnet::before {\n        content: \"\\\\f779\";\n    }\n\n    .bi-person-heart::before {\n        content: \"\\\\f77a\";\n    }\n\n    .bi-person-hearts::before {\n        content: \"\\\\f77b\";\n    }\n\n    .bi-phone-flip::before {\n        content: \"\\\\f77c\";\n    }\n\n    .bi-plugin::before {\n        content: \"\\\\f77d\";\n    }\n\n    .bi-postage-fill::before {\n        content: \"\\\\f77e\";\n    }\n\n    .bi-postage-heart-fill::before {\n        content: \"\\\\f77f\";\n    }\n\n    .bi-postage-heart::before {\n        content: \"\\\\f780\";\n    }\n\n    .bi-postage::before {\n        content: \"\\\\f781\";\n    }\n\n    .bi-postcard-fill::before {\n        content: \"\\\\f782\";\n    }\n\n    .bi-postcard-heart-fill::before {\n        content: \"\\\\f783\";\n    }\n\n    .bi-postcard-heart::before {\n        content: \"\\\\f784\";\n    }\n\n    .bi-postcard::before {\n        content: \"\\\\f785\";\n    }\n\n    .bi-search-heart-fill::before {\n        content: \"\\\\f786\";\n    }\n\n    .bi-search-heart::before {\n        content: \"\\\\f787\";\n    }\n\n    .bi-sliders2-vertical::before {\n        content: \"\\\\f788\";\n    }\n\n    .bi-sliders2::before {\n        content: \"\\\\f789\";\n    }\n\n    .bi-trash3-fill::before {\n        content: \"\\\\f78a\";\n    }\n\n    .bi-trash3::before {\n        content: \"\\\\f78b\";\n    }\n\n    .bi-valentine::before {\n        content: \"\\\\f78c\";\n    }\n\n    .bi-valentine2::before {\n        content: \"\\\\f78d\";\n    }\n\n    .bi-wrench-adjustable-circle-fill::before {\n        content: \"\\\\f78e\";\n    }\n\n    .bi-wrench-adjustable-circle::before {\n        content: \"\\\\f78f\";\n    }\n\n    .bi-wrench-adjustable::before {\n        content: \"\\\\f790\";\n    }\n\n    .bi-filetype-json::before {\n        content: \"\\\\f791\";\n    }\n\n    .bi-filetype-pptx::before {\n        content: \"\\\\f792\";\n    }\n\n    .bi-filetype-xlsx::before {\n        content: \"\\\\f793\";\n    }\n\n    .bi-1-circle-fill::before {\n        content: \"\\\\f796\";\n    }\n\n    .bi-1-circle::before {\n        content: \"\\\\f797\";\n    }\n\n    .bi-1-square-fill::before {\n        content: \"\\\\f798\";\n    }\n\n    .bi-1-square::before {\n        content: \"\\\\f799\";\n    }\n\n    .bi-2-circle-fill::before {\n        content: \"\\\\f79c\";\n    }\n\n    .bi-2-circle::before {\n        content: \"\\\\f79d\";\n    }\n\n    .bi-2-square-fill::before {\n        content: \"\\\\f79e\";\n    }\n\n    .bi-2-square::before {\n        content: \"\\\\f79f\";\n    }\n\n    .bi-3-circle-fill::before {\n        content: \"\\\\f7a2\";\n    }\n\n    .bi-3-circle::before {\n        content: \"\\\\f7a3\";\n    }\n\n    .bi-3-square-fill::before {\n        content: \"\\\\f7a4\";\n    }\n\n    .bi-3-square::before {\n        content: \"\\\\f7a5\";\n    }\n\n    .bi-4-circle-fill::before {\n        content: \"\\\\f7a8\";\n    }\n\n    .bi-4-circle::before {\n        content: \"\\\\f7a9\";\n    }\n\n    .bi-4-square-fill::before {\n        content: \"\\\\f7aa\";\n    }\n\n    .bi-4-square::before {\n        content: \"\\\\f7ab\";\n    }\n\n    .bi-5-circle-fill::before {\n        content: \"\\\\f7ae\";\n    }\n\n    .bi-5-circle::before {\n        content: \"\\\\f7af\";\n    }\n\n    .bi-5-square-fill::before {\n        content: \"\\\\f7b0\";\n    }\n\n    .bi-5-square::before {\n        content: \"\\\\f7b1\";\n    }\n\n    .bi-6-circle-fill::before {\n        content: \"\\\\f7b4\";\n    }\n\n    .bi-6-circle::before {\n        content: \"\\\\f7b5\";\n    }\n\n    .bi-6-square-fill::before {\n        content: \"\\\\f7b6\";\n    }\n\n    .bi-6-square::before {\n        content: \"\\\\f7b7\";\n    }\n\n    .bi-7-circle-fill::before {\n        content: \"\\\\f7ba\";\n    }\n\n    .bi-7-circle::before {\n        content: \"\\\\f7bb\";\n    }\n\n    .bi-7-square-fill::before {\n        content: \"\\\\f7bc\";\n    }\n\n    .bi-7-square::before {\n        content: \"\\\\f7bd\";\n    }\n\n    .bi-8-circle-fill::before {\n        content: \"\\\\f7c0\";\n    }\n\n    .bi-8-circle::before {\n        content: \"\\\\f7c1\";\n    }\n\n    .bi-8-square-fill::before {\n        content: \"\\\\f7c2\";\n    }\n\n    .bi-8-square::before {\n        content: \"\\\\f7c3\";\n    }\n\n    .bi-9-circle-fill::before {\n        content: \"\\\\f7c6\";\n    }\n\n    .bi-9-circle::before {\n        content: \"\\\\f7c7\";\n    }\n\n    .bi-9-square-fill::before {\n        content: \"\\\\f7c8\";\n    }\n\n    .bi-9-square::before {\n        content: \"\\\\f7c9\";\n    }\n\n    .bi-airplane-engines-fill::before {\n        content: \"\\\\f7ca\";\n    }\n\n    .bi-airplane-engines::before {\n        content: \"\\\\f7cb\";\n    }\n\n    .bi-airplane-fill::before {\n        content: \"\\\\f7cc\";\n    }\n\n    .bi-airplane::before {\n        content: \"\\\\f7cd\";\n    }\n\n    .bi-alexa::before {\n        content: \"\\\\f7ce\";\n    }\n\n    .bi-alipay::before {\n        content: \"\\\\f7cf\";\n    }\n\n    .bi-android::before {\n        content: \"\\\\f7d0\";\n    }\n\n    .bi-android2::before {\n        content: \"\\\\f7d1\";\n    }\n\n    .bi-box-fill::before {\n        content: \"\\\\f7d2\";\n    }\n\n    .bi-box-seam-fill::before {\n        content: \"\\\\f7d3\";\n    }\n\n    .bi-browser-chrome::before {\n        content: \"\\\\f7d4\";\n    }\n\n    .bi-browser-edge::before {\n        content: \"\\\\f7d5\";\n    }\n\n    .bi-browser-firefox::before {\n        content: \"\\\\f7d6\";\n    }\n\n    .bi-browser-safari::before {\n        content: \"\\\\f7d7\";\n    }\n\n    .bi-c-circle-fill::before {\n        content: \"\\\\f7da\";\n    }\n\n    .bi-c-circle::before {\n        content: \"\\\\f7db\";\n    }\n\n    .bi-c-square-fill::before {\n        content: \"\\\\f7dc\";\n    }\n\n    .bi-c-square::before {\n        content: \"\\\\f7dd\";\n    }\n\n    .bi-capsule-pill::before {\n        content: \"\\\\f7de\";\n    }\n\n    .bi-capsule::before {\n        content: \"\\\\f7df\";\n    }\n\n    .bi-car-front-fill::before {\n        content: \"\\\\f7e0\";\n    }\n\n    .bi-car-front::before {\n        content: \"\\\\f7e1\";\n    }\n\n    .bi-cassette-fill::before {\n        content: \"\\\\f7e2\";\n    }\n\n    .bi-cassette::before {\n        content: \"\\\\f7e3\";\n    }\n\n    .bi-cc-circle-fill::before {\n        content: \"\\\\f7e6\";\n    }\n\n    .bi-cc-circle::before {\n        content: \"\\\\f7e7\";\n    }\n\n    .bi-cc-square-fill::before {\n        content: \"\\\\f7e8\";\n    }\n\n    .bi-cc-square::before {\n        content: \"\\\\f7e9\";\n    }\n\n    .bi-cup-hot-fill::before {\n        content: \"\\\\f7ea\";\n    }\n\n    .bi-cup-hot::before {\n        content: \"\\\\f7eb\";\n    }\n\n    .bi-currency-rupee::before {\n        content: \"\\\\f7ec\";\n    }\n\n    .bi-dropbox::before {\n        content: \"\\\\f7ed\";\n    }\n\n    .bi-escape::before {\n        content: \"\\\\f7ee\";\n    }\n\n    .bi-fast-forward-btn-fill::before {\n        content: \"\\\\f7ef\";\n    }\n\n    .bi-fast-forward-btn::before {\n        content: \"\\\\f7f0\";\n    }\n\n    .bi-fast-forward-circle-fill::before {\n        content: \"\\\\f7f1\";\n    }\n\n    .bi-fast-forward-circle::before {\n        content: \"\\\\f7f2\";\n    }\n\n    .bi-fast-forward-fill::before {\n        content: \"\\\\f7f3\";\n    }\n\n    .bi-fast-forward::before {\n        content: \"\\\\f7f4\";\n    }\n\n    .bi-filetype-sql::before {\n        content: \"\\\\f7f5\";\n    }\n\n    .bi-fire::before {\n        content: \"\\\\f7f6\";\n    }\n\n    .bi-google-play::before {\n        content: \"\\\\f7f7\";\n    }\n\n    .bi-h-circle-fill::before {\n        content: \"\\\\f7fa\";\n    }\n\n    .bi-h-circle::before {\n        content: \"\\\\f7fb\";\n    }\n\n    .bi-h-square-fill::before {\n        content: \"\\\\f7fc\";\n    }\n\n    .bi-h-square::before {\n        content: \"\\\\f7fd\";\n    }\n\n    .bi-indent::before {\n        content: \"\\\\f7fe\";\n    }\n\n    .bi-lungs-fill::before {\n        content: \"\\\\f7ff\";\n    }\n\n    .bi-lungs::before {\n        content: \"\\\\f800\";\n    }\n\n    .bi-microsoft-teams::before {\n        content: \"\\\\f801\";\n    }\n\n    .bi-p-circle-fill::before {\n        content: \"\\\\f804\";\n    }\n\n    .bi-p-circle::before {\n        content: \"\\\\f805\";\n    }\n\n    .bi-p-square-fill::before {\n        content: \"\\\\f806\";\n    }\n\n    .bi-p-square::before {\n        content: \"\\\\f807\";\n    }\n\n    .bi-pass-fill::before {\n        content: \"\\\\f808\";\n    }\n\n    .bi-pass::before {\n        content: \"\\\\f809\";\n    }\n\n    .bi-prescription::before {\n        content: \"\\\\f80a\";\n    }\n\n    .bi-prescription2::before {\n        content: \"\\\\f80b\";\n    }\n\n    .bi-r-circle-fill::before {\n        content: \"\\\\f80e\";\n    }\n\n    .bi-r-circle::before {\n        content: \"\\\\f80f\";\n    }\n\n    .bi-r-square-fill::before {\n        content: \"\\\\f810\";\n    }\n\n    .bi-r-square::before {\n        content: \"\\\\f811\";\n    }\n\n    .bi-repeat-1::before {\n        content: \"\\\\f812\";\n    }\n\n    .bi-repeat::before {\n        content: \"\\\\f813\";\n    }\n\n    .bi-rewind-btn-fill::before {\n        content: \"\\\\f814\";\n    }\n\n    .bi-rewind-btn::before {\n        content: \"\\\\f815\";\n    }\n\n    .bi-rewind-circle-fill::before {\n        content: \"\\\\f816\";\n    }\n\n    .bi-rewind-circle::before {\n        content: \"\\\\f817\";\n    }\n\n    .bi-rewind-fill::before {\n        content: \"\\\\f818\";\n    }\n\n    .bi-rewind::before {\n        content: \"\\\\f819\";\n    }\n\n    .bi-train-freight-front-fill::before {\n        content: \"\\\\f81a\";\n    }\n\n    .bi-train-freight-front::before {\n        content: \"\\\\f81b\";\n    }\n\n    .bi-train-front-fill::before {\n        content: \"\\\\f81c\";\n    }\n\n    .bi-train-front::before {\n        content: \"\\\\f81d\";\n    }\n\n    .bi-train-lightrail-front-fill::before {\n        content: \"\\\\f81e\";\n    }\n\n    .bi-train-lightrail-front::before {\n        content: \"\\\\f81f\";\n    }\n\n    .bi-truck-front-fill::before {\n        content: \"\\\\f820\";\n    }\n\n    .bi-truck-front::before {\n        content: \"\\\\f821\";\n    }\n\n    .bi-ubuntu::before {\n        content: \"\\\\f822\";\n    }\n\n    .bi-unindent::before {\n        content: \"\\\\f823\";\n    }\n\n    .bi-unity::before {\n        content: \"\\\\f824\";\n    }\n\n    .bi-universal-access-circle::before {\n        content: \"\\\\f825\";\n    }\n\n    .bi-universal-access::before {\n        content: \"\\\\f826\";\n    }\n\n    .bi-virus::before {\n        content: \"\\\\f827\";\n    }\n\n    .bi-virus2::before {\n        content: \"\\\\f828\";\n    }\n\n    .bi-wechat::before {\n        content: \"\\\\f829\";\n    }\n\n    .bi-yelp::before {\n        content: \"\\\\f82a\";\n    }\n\n    .bi-sign-stop-fill::before {\n        content: \"\\\\f82b\";\n    }\n\n    .bi-sign-stop-lights-fill::before {\n        content: \"\\\\f82c\";\n    }\n\n    .bi-sign-stop-lights::before {\n        content: \"\\\\f82d\";\n    }\n\n    .bi-sign-stop::before {\n        content: \"\\\\f82e\";\n    }\n\n    .bi-sign-turn-left-fill::before {\n        content: \"\\\\f82f\";\n    }\n\n    .bi-sign-turn-left::before {\n        content: \"\\\\f830\";\n    }\n\n    .bi-sign-turn-right-fill::before {\n        content: \"\\\\f831\";\n    }\n\n    .bi-sign-turn-right::before {\n        content: \"\\\\f832\";\n    }\n\n    .bi-sign-turn-slight-left-fill::before {\n        content: \"\\\\f833\";\n    }\n\n    .bi-sign-turn-slight-left::before {\n        content: \"\\\\f834\";\n    }\n\n    .bi-sign-turn-slight-right-fill::before {\n        content: \"\\\\f835\";\n    }\n\n    .bi-sign-turn-slight-right::before {\n        content: \"\\\\f836\";\n    }\n\n    .bi-sign-yield-fill::before {\n        content: \"\\\\f837\";\n    }\n\n    .bi-sign-yield::before {\n        content: \"\\\\f838\";\n    }\n\n    .bi-ev-station-fill::before {\n        content: \"\\\\f839\";\n    }\n\n    .bi-ev-station::before {\n        content: \"\\\\f83a\";\n    }\n\n    .bi-fuel-pump-diesel-fill::before {\n        content: \"\\\\f83b\";\n    }\n\n    .bi-fuel-pump-diesel::before {\n        content: \"\\\\f83c\";\n    }\n\n    .bi-fuel-pump-fill::before {\n        content: \"\\\\f83d\";\n    }\n\n    .bi-fuel-pump::before {\n        content: \"\\\\f83e\";\n    }\n\n    .bi-0-circle-fill::before {\n        content: \"\\\\f83f\";\n    }\n\n    .bi-0-circle::before {\n        content: \"\\\\f840\";\n    }\n\n    .bi-0-square-fill::before {\n        content: \"\\\\f841\";\n    }\n\n    .bi-0-square::before {\n        content: \"\\\\f842\";\n    }\n\n    .bi-rocket-fill::before {\n        content: \"\\\\f843\";\n    }\n\n    .bi-rocket-takeoff-fill::before {\n        content: \"\\\\f844\";\n    }\n\n    .bi-rocket-takeoff::before {\n        content: \"\\\\f845\";\n    }\n\n    .bi-rocket::before {\n        content: \"\\\\f846\";\n    }\n\n    .bi-stripe::before {\n        content: \"\\\\f847\";\n    }\n\n    .bi-subscript::before {\n        content: \"\\\\f848\";\n    }\n\n    .bi-superscript::before {\n        content: \"\\\\f849\";\n    }\n\n    .bi-trello::before {\n        content: \"\\\\f84a\";\n    }\n\n    .bi-envelope-at-fill::before {\n        content: \"\\\\f84b\";\n    }\n\n    .bi-envelope-at::before {\n        content: \"\\\\f84c\";\n    }\n\n    .bi-regex::before {\n        content: \"\\\\f84d\";\n    }\n\n    .bi-text-wrap::before {\n        content: \"\\\\f84e\";\n    }\n\n    .bi-sign-dead-end-fill::before {\n        content: \"\\\\f84f\";\n    }\n\n    .bi-sign-dead-end::before {\n        content: \"\\\\f850\";\n    }\n\n    .bi-sign-do-not-enter-fill::before {\n        content: \"\\\\f851\";\n    }\n\n    .bi-sign-do-not-enter::before {\n        content: \"\\\\f852\";\n    }\n\n    .bi-sign-intersection-fill::before {\n        content: \"\\\\f853\";\n    }\n\n    .bi-sign-intersection-side-fill::before {\n        content: \"\\\\f854\";\n    }\n\n    .bi-sign-intersection-side::before {\n        content: \"\\\\f855\";\n    }\n\n    .bi-sign-intersection-t-fill::before {\n        content: \"\\\\f856\";\n    }\n\n    .bi-sign-intersection-t::before {\n        content: \"\\\\f857\";\n    }\n\n    .bi-sign-intersection-y-fill::before {\n        content: \"\\\\f858\";\n    }\n\n    .bi-sign-intersection-y::before {\n        content: \"\\\\f859\";\n    }\n\n    .bi-sign-intersection::before {\n        content: \"\\\\f85a\";\n    }\n\n    .bi-sign-merge-left-fill::before {\n        content: \"\\\\f85b\";\n    }\n\n    .bi-sign-merge-left::before {\n        content: \"\\\\f85c\";\n    }\n\n    .bi-sign-merge-right-fill::before {\n        content: \"\\\\f85d\";\n    }\n\n    .bi-sign-merge-right::before {\n        content: \"\\\\f85e\";\n    }\n\n    .bi-sign-no-left-turn-fill::before {\n        content: \"\\\\f85f\";\n    }\n\n    .bi-sign-no-left-turn::before {\n        content: \"\\\\f860\";\n    }\n\n    .bi-sign-no-parking-fill::before {\n        content: \"\\\\f861\";\n    }\n\n    .bi-sign-no-parking::before {\n        content: \"\\\\f862\";\n    }\n\n    .bi-sign-no-right-turn-fill::before {\n        content: \"\\\\f863\";\n    }\n\n    .bi-sign-no-right-turn::before {\n        content: \"\\\\f864\";\n    }\n\n    .bi-sign-railroad-fill::before {\n        content: \"\\\\f865\";\n    }\n\n    .bi-sign-railroad::before {\n        content: \"\\\\f866\";\n    }\n\n    .bi-building-add::before {\n        content: \"\\\\f867\";\n    }\n\n    .bi-building-check::before {\n        content: \"\\\\f868\";\n    }\n\n    .bi-building-dash::before {\n        content: \"\\\\f869\";\n    }\n\n    .bi-building-down::before {\n        content: \"\\\\f86a\";\n    }\n\n    .bi-building-exclamation::before {\n        content: \"\\\\f86b\";\n    }\n\n    .bi-building-fill-add::before {\n        content: \"\\\\f86c\";\n    }\n\n    .bi-building-fill-check::before {\n        content: \"\\\\f86d\";\n    }\n\n    .bi-building-fill-dash::before {\n        content: \"\\\\f86e\";\n    }\n\n    .bi-building-fill-down::before {\n        content: \"\\\\f86f\";\n    }\n\n    .bi-building-fill-exclamation::before {\n        content: \"\\\\f870\";\n    }\n\n    .bi-building-fill-gear::before {\n        content: \"\\\\f871\";\n    }\n\n    .bi-building-fill-lock::before {\n        content: \"\\\\f872\";\n    }\n\n    .bi-building-fill-slash::before {\n        content: \"\\\\f873\";\n    }\n\n    .bi-building-fill-up::before {\n        content: \"\\\\f874\";\n    }\n\n    .bi-building-fill-x::before {\n        content: \"\\\\f875\";\n    }\n\n    .bi-building-fill::before {\n        content: \"\\\\f876\";\n    }\n\n    .bi-building-gear::before {\n        content: \"\\\\f877\";\n    }\n\n    .bi-building-lock::before {\n        content: \"\\\\f878\";\n    }\n\n    .bi-building-slash::before {\n        content: \"\\\\f879\";\n    }\n\n    .bi-building-up::before {\n        content: \"\\\\f87a\";\n    }\n\n    .bi-building-x::before {\n        content: \"\\\\f87b\";\n    }\n\n    .bi-buildings-fill::before {\n        content: \"\\\\f87c\";\n    }\n\n    .bi-buildings::before {\n        content: \"\\\\f87d\";\n    }\n\n    .bi-bus-front-fill::before {\n        content: \"\\\\f87e\";\n    }\n\n    .bi-bus-front::before {\n        content: \"\\\\f87f\";\n    }\n\n    .bi-ev-front-fill::before {\n        content: \"\\\\f880\";\n    }\n\n    .bi-ev-front::before {\n        content: \"\\\\f881\";\n    }\n\n    .bi-globe-americas::before {\n        content: \"\\\\f882\";\n    }\n\n    .bi-globe-asia-australia::before {\n        content: \"\\\\f883\";\n    }\n\n    .bi-globe-central-south-asia::before {\n        content: \"\\\\f884\";\n    }\n\n    .bi-globe-europe-africa::before {\n        content: \"\\\\f885\";\n    }\n\n    .bi-house-add-fill::before {\n        content: \"\\\\f886\";\n    }\n\n    .bi-house-add::before {\n        content: \"\\\\f887\";\n    }\n\n    .bi-house-check-fill::before {\n        content: \"\\\\f888\";\n    }\n\n    .bi-house-check::before {\n        content: \"\\\\f889\";\n    }\n\n    .bi-house-dash-fill::before {\n        content: \"\\\\f88a\";\n    }\n\n    .bi-house-dash::before {\n        content: \"\\\\f88b\";\n    }\n\n    .bi-house-down-fill::before {\n        content: \"\\\\f88c\";\n    }\n\n    .bi-house-down::before {\n        content: \"\\\\f88d\";\n    }\n\n    .bi-house-exclamation-fill::before {\n        content: \"\\\\f88e\";\n    }\n\n    .bi-house-exclamation::before {\n        content: \"\\\\f88f\";\n    }\n\n    .bi-house-gear-fill::before {\n        content: \"\\\\f890\";\n    }\n\n    .bi-house-gear::before {\n        content: \"\\\\f891\";\n    }\n\n    .bi-house-lock-fill::before {\n        content: \"\\\\f892\";\n    }\n\n    .bi-house-lock::before {\n        content: \"\\\\f893\";\n    }\n\n    .bi-house-slash-fill::before {\n        content: \"\\\\f894\";\n    }\n\n    .bi-house-slash::before {\n        content: \"\\\\f895\";\n    }\n\n    .bi-house-up-fill::before {\n        content: \"\\\\f896\";\n    }\n\n    .bi-house-up::before {\n        content: \"\\\\f897\";\n    }\n\n    .bi-house-x-fill::before {\n        content: \"\\\\f898\";\n    }\n\n    .bi-house-x::before {\n        content: \"\\\\f899\";\n    }\n\n    .bi-person-add::before {\n        content: \"\\\\f89a\";\n    }\n\n    .bi-person-down::before {\n        content: \"\\\\f89b\";\n    }\n\n    .bi-person-exclamation::before {\n        content: \"\\\\f89c\";\n    }\n\n    .bi-person-fill-add::before {\n        content: \"\\\\f89d\";\n    }\n\n    .bi-person-fill-check::before {\n        content: \"\\\\f89e\";\n    }\n\n    .bi-person-fill-dash::before {\n        content: \"\\\\f89f\";\n    }\n\n    .bi-person-fill-down::before {\n        content: \"\\\\f8a0\";\n    }\n\n    .bi-person-fill-exclamation::before {\n        content: \"\\\\f8a1\";\n    }\n\n    .bi-person-fill-gear::before {\n        content: \"\\\\f8a2\";\n    }\n\n    .bi-person-fill-lock::before {\n        content: \"\\\\f8a3\";\n    }\n\n    .bi-person-fill-slash::before {\n        content: \"\\\\f8a4\";\n    }\n\n    .bi-person-fill-up::before {\n        content: \"\\\\f8a5\";\n    }\n\n    .bi-person-fill-x::before {\n        content: \"\\\\f8a6\";\n    }\n\n    .bi-person-gear::before {\n        content: \"\\\\f8a7\";\n    }\n\n    .bi-person-lock::before {\n        content: \"\\\\f8a8\";\n    }\n\n    .bi-person-slash::before {\n        content: \"\\\\f8a9\";\n    }\n\n    .bi-person-up::before {\n        content: \"\\\\f8aa\";\n    }\n\n    .bi-scooter::before {\n        content: \"\\\\f8ab\";\n    }\n\n    .bi-taxi-front-fill::before {\n        content: \"\\\\f8ac\";\n    }\n\n    .bi-taxi-front::before {\n        content: \"\\\\f8ad\";\n    }\n\n    .bi-amd::before {\n        content: \"\\\\f8ae\";\n    }\n\n    .bi-database-add::before {\n        content: \"\\\\f8af\";\n    }\n\n    .bi-database-check::before {\n        content: \"\\\\f8b0\";\n    }\n\n    .bi-database-dash::before {\n        content: \"\\\\f8b1\";\n    }\n\n    .bi-database-down::before {\n        content: \"\\\\f8b2\";\n    }\n\n    .bi-database-exclamation::before {\n        content: \"\\\\f8b3\";\n    }\n\n    .bi-database-fill-add::before {\n        content: \"\\\\f8b4\";\n    }\n\n    .bi-database-fill-check::before {\n        content: \"\\\\f8b5\";\n    }\n\n    .bi-database-fill-dash::before {\n        content: \"\\\\f8b6\";\n    }\n\n    .bi-database-fill-down::before {\n        content: \"\\\\f8b7\";\n    }\n\n    .bi-database-fill-exclamation::before {\n        content: \"\\\\f8b8\";\n    }\n\n    .bi-database-fill-gear::before {\n        content: \"\\\\f8b9\";\n    }\n\n    .bi-database-fill-lock::before {\n        content: \"\\\\f8ba\";\n    }\n\n    .bi-database-fill-slash::before {\n        content: \"\\\\f8bb\";\n    }\n\n    .bi-database-fill-up::before {\n        content: \"\\\\f8bc\";\n    }\n\n    .bi-database-fill-x::before {\n        content: \"\\\\f8bd\";\n    }\n\n    .bi-database-fill::before {\n        content: \"\\\\f8be\";\n    }\n\n    .bi-database-gear::before {\n        content: \"\\\\f8bf\";\n    }\n\n    .bi-database-lock::before {\n        content: \"\\\\f8c0\";\n    }\n\n    .bi-database-slash::before {\n        content: \"\\\\f8c1\";\n    }\n\n    .bi-database-up::before {\n        content: \"\\\\f8c2\";\n    }\n\n    .bi-database-x::before {\n        content: \"\\\\f8c3\";\n    }\n\n    .bi-database::before {\n        content: \"\\\\f8c4\";\n    }\n\n    .bi-houses-fill::before {\n        content: \"\\\\f8c5\";\n    }\n\n    .bi-houses::before {\n        content: \"\\\\f8c6\";\n    }\n\n    .bi-nvidia::before {\n        content: \"\\\\f8c7\";\n    }\n\n    .bi-person-vcard-fill::before {\n        content: \"\\\\f8c8\";\n    }\n\n    .bi-person-vcard::before {\n        content: \"\\\\f8c9\";\n    }\n\n    .bi-sina-weibo::before {\n        content: \"\\\\f8ca\";\n    }\n\n    .bi-tencent-qq::before {\n        content: \"\\\\f8cb\";\n    }\n\n    .bi-wikipedia::before {\n        content: \"\\\\f8cc\";\n    }\n\n    .bi-alphabet-uppercase::before {\n        content: \"\\\\f2a5\";\n    }\n\n    .bi-alphabet::before {\n        content: \"\\\\f68a\";\n    }\n\n    .bi-amazon::before {\n        content: \"\\\\f68d\";\n    }\n\n    .bi-arrows-collapse-vertical::before {\n        content: \"\\\\f690\";\n    }\n\n    .bi-arrows-expand-vertical::before {\n        content: \"\\\\f695\";\n    }\n\n    .bi-arrows-vertical::before {\n        content: \"\\\\f698\";\n    }\n\n    .bi-arrows::before {\n        content: \"\\\\f6a2\";\n    }\n\n    .bi-ban-fill::before {\n        content: \"\\\\f6a3\";\n    }\n\n    .bi-ban::before {\n        content: \"\\\\f6b6\";\n    }\n\n    .bi-bing::before {\n        content: \"\\\\f6c2\";\n    }\n\n    .bi-cake::before {\n        content: \"\\\\f6e0\";\n    }\n\n    .bi-cake2::before {\n        content: \"\\\\f6ed\";\n    }\n\n    .bi-cookie::before {\n        content: \"\\\\f6ee\";\n    }\n\n    .bi-copy::before {\n        content: \"\\\\f759\";\n    }\n\n    .bi-crosshair::before {\n        content: \"\\\\f769\";\n    }\n\n    .bi-crosshair2::before {\n        content: \"\\\\f794\";\n    }\n\n    .bi-emoji-astonished-fill::before {\n        content: \"\\\\f795\";\n    }\n\n    .bi-emoji-astonished::before {\n        content: \"\\\\f79a\";\n    }\n\n    .bi-emoji-grimace-fill::before {\n        content: \"\\\\f79b\";\n    }\n\n    .bi-emoji-grimace::before {\n        content: \"\\\\f7a0\";\n    }\n\n    .bi-emoji-grin-fill::before {\n        content: \"\\\\f7a1\";\n    }\n\n    .bi-emoji-grin::before {\n        content: \"\\\\f7a6\";\n    }\n\n    .bi-emoji-surprise-fill::before {\n        content: \"\\\\f7a7\";\n    }\n\n    .bi-emoji-surprise::before {\n        content: \"\\\\f7ac\";\n    }\n\n    .bi-emoji-tear-fill::before {\n        content: \"\\\\f7ad\";\n    }\n\n    .bi-emoji-tear::before {\n        content: \"\\\\f7b2\";\n    }\n\n    .bi-envelope-arrow-down-fill::before {\n        content: \"\\\\f7b3\";\n    }\n\n    .bi-envelope-arrow-down::before {\n        content: \"\\\\f7b8\";\n    }\n\n    .bi-envelope-arrow-up-fill::before {\n        content: \"\\\\f7b9\";\n    }\n\n    .bi-envelope-arrow-up::before {\n        content: \"\\\\f7be\";\n    }\n\n    .bi-feather::before {\n        content: \"\\\\f7bf\";\n    }\n\n    .bi-feather2::before {\n        content: \"\\\\f7c4\";\n    }\n\n    .bi-floppy-fill::before {\n        content: \"\\\\f7c5\";\n    }\n\n    .bi-floppy::before {\n        content: \"\\\\f7d8\";\n    }\n\n    .bi-floppy2-fill::before {\n        content: \"\\\\f7d9\";\n    }\n\n    .bi-floppy2::before {\n        content: \"\\\\f7e4\";\n    }\n\n    .bi-gitlab::before {\n        content: \"\\\\f7e5\";\n    }\n\n    .bi-highlighter::before {\n        content: \"\\\\f7f8\";\n    }\n\n    .bi-marker-tip::before {\n        content: \"\\\\f802\";\n    }\n\n    .bi-nvme-fill::before {\n        content: \"\\\\f803\";\n    }\n\n    .bi-nvme::before {\n        content: \"\\\\f80c\";\n    }\n\n    .bi-opencollective::before {\n        content: \"\\\\f80d\";\n    }\n\n    .bi-pci-card-network::before {\n        content: \"\\\\f8cd\";\n    }\n\n    .bi-pci-card-sound::before {\n        content: \"\\\\f8ce\";\n    }\n\n    .bi-radar::before {\n        content: \"\\\\f8cf\";\n    }\n\n    .bi-send-arrow-down-fill::before {\n        content: \"\\\\f8d0\";\n    }\n\n    .bi-send-arrow-down::before {\n        content: \"\\\\f8d1\";\n    }\n\n    .bi-send-arrow-up-fill::before {\n        content: \"\\\\f8d2\";\n    }\n\n    .bi-send-arrow-up::before {\n        content: \"\\\\f8d3\";\n    }\n\n    .bi-sim-slash-fill::before {\n        content: \"\\\\f8d4\";\n    }\n\n    .bi-sim-slash::before {\n        content: \"\\\\f8d5\";\n    }\n\n    .bi-sourceforge::before {\n        content: \"\\\\f8d6\";\n    }\n\n    .bi-substack::before {\n        content: \"\\\\f8d7\";\n    }\n\n    .bi-threads-fill::before {\n        content: \"\\\\f8d8\";\n    }\n\n    .bi-threads::before {\n        content: \"\\\\f8d9\";\n    }\n\n    .bi-transparency::before {\n        content: \"\\\\f8da\";\n    }\n\n    .bi-twitter-x::before {\n        content: \"\\\\f8db\";\n    }\n\n    .bi-type-h4::before {\n        content: \"\\\\f8dc\";\n    }\n\n    .bi-type-h5::before {\n        content: \"\\\\f8dd\";\n    }\n\n    .bi-type-h6::before {\n        content: \"\\\\f8de\";\n    }\n\n    .bi-backpack-fill::before {\n        content: \"\\\\f8df\";\n    }\n\n    .bi-backpack::before {\n        content: \"\\\\f8e0\";\n    }\n\n    .bi-backpack2-fill::before {\n        content: \"\\\\f8e1\";\n    }\n\n    .bi-backpack2::before {\n        content: \"\\\\f8e2\";\n    }\n\n    .bi-backpack3-fill::before {\n        content: \"\\\\f8e3\";\n    }\n\n    .bi-backpack3::before {\n        content: \"\\\\f8e4\";\n    }\n\n    .bi-backpack4-fill::before {\n        content: \"\\\\f8e5\";\n    }\n\n    .bi-backpack4::before {\n        content: \"\\\\f8e6\";\n    }\n\n    .bi-brilliance::before {\n        content: \"\\\\f8e7\";\n    }\n\n    .bi-cake-fill::before {\n        content: \"\\\\f8e8\";\n    }\n\n    .bi-cake2-fill::before {\n        content: \"\\\\f8e9\";\n    }\n\n    .bi-duffle-fill::before {\n        content: \"\\\\f8ea\";\n    }\n\n    .bi-duffle::before {\n        content: \"\\\\f8eb\";\n    }\n\n    .bi-exposure::before {\n        content: \"\\\\f8ec\";\n    }\n\n    .bi-gender-neuter::before {\n        content: \"\\\\f8ed\";\n    }\n\n    .bi-highlights::before {\n        content: \"\\\\f8ee\";\n    }\n\n    .bi-luggage-fill::before {\n        content: \"\\\\f8ef\";\n    }\n\n    .bi-luggage::before {\n        content: \"\\\\f8f0\";\n    }\n\n    .bi-mailbox-flag::before {\n        content: \"\\\\f8f1\";\n    }\n\n    .bi-mailbox2-flag::before {\n        content: \"\\\\f8f2\";\n    }\n\n    .bi-noise-reduction::before {\n        content: \"\\\\f8f3\";\n    }\n\n    .bi-passport-fill::before {\n        content: \"\\\\f8f4\";\n    }\n\n    .bi-passport::before {\n        content: \"\\\\f8f5\";\n    }\n\n    .bi-person-arms-up::before {\n        content: \"\\\\f8f6\";\n    }\n\n    .bi-person-raised-hand::before {\n        content: \"\\\\f8f7\";\n    }\n\n    .bi-person-standing-dress::before {\n        content: \"\\\\f8f8\";\n    }\n\n    .bi-person-standing::before {\n        content: \"\\\\f8f9\";\n    }\n\n    .bi-person-walking::before {\n        content: \"\\\\f8fa\";\n    }\n\n    .bi-person-wheelchair::before {\n        content: \"\\\\f8fb\";\n    }\n\n    .bi-shadows::before {\n        content: \"\\\\f8fc\";\n    }\n\n    .bi-suitcase-fill::before {\n        content: \"\\\\f8fd\";\n    }\n\n    .bi-suitcase-lg-fill::before {\n        content: \"\\\\f8fe\";\n    }\n\n    .bi-suitcase-lg::before {\n        content: \"\\\\f8ff\";\n    }\n\n    .bi-suitcase::before {\n        content: \"\\\\f900\";\n    }\n\n    .bi-suitcase2-fill::before {\n        content: \"\\\\f901\";\n    }\n\n    .bi-suitcase2::before {\n        content: \"\\\\f902\";\n    }\n\n    .bi-vignette::before {\n        content: \"\\\\f903\";\n    }\n"])));

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const i$f=(i,e)=>"method"===e.kind&&e.descriptor&&!("value"in e.descriptor)?{...e,finisher(n){n.createProperty(e.key,i);}}:{kind:"field",key:Symbol(),placement:"own",descriptor:{},originalKey:e.key,initializer(){"function"==typeof e.initializer&&(this[e.key]=e.initializer.call(this));},finisher(n){n.createProperty(e.key,i);}};function e$p(e){return (n,t)=>void 0!==t?((i,e,n)=>{e.constructor.createProperty(n,i);})(e,n,t):i$f(e,n)}

function ownKeys$V(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$U(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$V(Object(t), !0).forEach(function (r) { _defineProperty$2u(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$V(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty$2u(e, r, t) { return (r = _toPropertyKey$2t(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2t(t) { var i = _toPrimitive$2t(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2t(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class EgwAction {
  set_caption(_value) {
    this.caption = _value;
  }
  set_iconUrl(_value) {
    this.iconUrl = _value;
  }
  /**
   * The allowOnMultiple property may be true, false, "only" (> 1) or number of select, e.g. 2
   *
   * @param {(boolean|string|number)} _value
   */
  set_allowOnMultiple(_value) {
    this.allowOnMultiple = _value;
  }
  set_enabled(_value) {
    this.enabled.setValue(_value);
  }
  // Data which can be freely assigned to the action
  /**
   * @deprecated just set the data parameter with '=' sign to use its setter
   * @param _value
   */
  set_data(_value) {
    this.data = _value;
  }
  /**
   * The set_onExecute function is the setter function for the onExecute event of
   * the EgwAction object. There are three possible types the passed "_value" may
   * take:
   *    1. _value may be a string with the word "javaScript:" prefixed. The function
   *       which is specified behind the colon and which has to be in the global scope
   *       will be executed.
   *    2. _value may be a boolean, which specifies whether the external onExecute handler
   *       (passed as "_handler" in the constructor) will be used.
   *    3. _value may be a JS function which will then be called.
   * In all possible situation, the called function will get the following parameters:
   *    1. A reference to this action
   *    2. The senders, an array of all objects (JS)/object ids (PHP) which evoked the event
   *
   * @param {(string|function|boolean)} _value
   */
  set_onExecute(_value) {
    this.onExecute.setValue(_value);
  }
  /**
   * Constructor for EgwAction object
   *
   * @param {EgwAction} _parent
   * @param {string} _id
   * @param {string} _caption
   * @param {string} _iconUrl
   * @param {(string|function)} _onExecute
   * @param {boolean} _allowOnMultiple
   * @returns EgwAction
   **/
  constructor(_parent, _id) {
    var _caption = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "";
    var _iconUrl = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "";
    var _onExecute = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
    var _allowOnMultiple = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : true;
    _defineProperty$2u(this, "id", void 0);
    _defineProperty$2u(this, "caption", void 0);
    _defineProperty$2u(this, "group", void 0);
    _defineProperty$2u(this, "order", void 0);
    _defineProperty$2u(this, "iconUrl", void 0);
    _defineProperty$2u(this, "allowOnMultiple", void 0);
    _defineProperty$2u(this, "enabled", void 0);
    _defineProperty$2u(this, "hideOnDisabled", false);
    _defineProperty$2u(this, "data", {});
    _defineProperty$2u(this, "type", "default");
    //All derived classes have to override this!
    _defineProperty$2u(this, "canHaveChildren", false);
    //Has to be overwritten by inheriting action classes
    // this is not bool all the time. Can be ['popup'] e.g. List of egwActionClasses that are allowed to have children?
    _defineProperty$2u(this, "parent", void 0);
    _defineProperty$2u(this, "children", []);
    //i guess
    _defineProperty$2u(this, "onExecute", new EgwFnct(this, null, []));
    /**
     * Set to either a confirmation prompt, or TRUE to indicate that this action
     * cares about large selections and to ask the confirmation prompt(s)
     *
     * --set in egw_action_popup--
     * @param {String|Boolean} _value
     */
    _defineProperty$2u(this, "confirm_mass_selection", undefined);
    _defineProperty$2u(this, "hideOnMobile", false);
    _defineProperty$2u(this, "disableIfNoEPL", false);
    /**
     * Default icons for given id
     */
    _defineProperty$2u(this, "defaultIcons", {
      view: 'view',
      edit: 'edit',
      open: 'edit',
      // does edit if possible, otherwise view
      add: 'new',
      new: 'new',
      delete: 'delete',
      cat: 'attach',
      // add as category icon to api
      document: 'etemplate/merge',
      print: 'print',
      copy: 'copy',
      move: 'move',
      cut: 'cut',
      paste: 'editpaste',
      save: 'save',
      apply: 'apply',
      cancel: 'cancel',
      continue: 'continue',
      next: 'continue',
      finish: 'finish',
      back: 'back',
      previous: 'back',
      close: 'close'
    });
    if (_parent && (typeof _id != "string" || !_id) && _parent.type !== "actionManager") {
      throw "EgwAction _id must be a non-empty string!";
    }
    this.parent = _parent;
    this.id = _id;
    this.caption = _caption;
    this.iconUrl = _iconUrl;
    if (_onExecute !== null) {
      this.set_onExecute(_onExecute);
    }
    this.allowOnMultiple = _allowOnMultiple;
    this.enabled = new EgwFnct(this, true);
  }

  /**
   * Clears the element and removes it from the parent container
   */
  remove() {
    var _this$data;
    // Remove all references to the child elements
    this.children = [];
    // Remove this element from the parent list
    if (this.parent) {
      var idx = this.parent.children.indexOf(this);
      if (idx >= 0) {
        this.parent.children.splice(idx, 1);
      }
    }
    // Clear context menu.  This probably isn't the right place for it.
    ((_this$data = this.data) === null || _this$data === void 0 ? void 0 : _this$data.menu) && this.data.menu.remove && this.data.menu.remove();
    this.data = {};
  }

  /**
   * Searches for a specific action with the given id
   *
   * @param {(string|number)} _id ID of the action to find
   * @param {number} [_search_depth=Infinite] How deep into existing action children
   *    to search.
   *
   * @return {(EgwAction|null)}
   */
  getActionById(_id) {
    var _search_depth = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : Number.MAX_VALUE;
    // If the current action object has the given id, return this object
    if (this.id == _id) {
      return this;
    }
    // If this element is capable of having children, search those for the given
    // action id
    if (this.canHaveChildren) {
      for (var i = 0; i < this.children.length && _search_depth > 0; i++) {
        var elem = this.children[i].getActionById(_id, _search_depth - 1);
        if (elem) {
          return elem;
        }
      }
    }
    return null;
  }
  /**
   * Searches for actions having an attribute with a certain value
   *
   * Example: actionManager.getActionsByAttr("checkbox", true) returns all checkbox actions
   *
   * @param {string} _attr attribute name
   * @param _val attribute value
   * @return array
   */
  getActionsByAttr(_attr) {
    var _val = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;
    var _actions = [];

    // If the current action object has the given attr AND value, or no value was provided, return it
    if (typeof this[_attr] != "undefined" && (this[_attr] === _val || typeof _val === "undefined" && this[_attr] !== null)) {
      _actions.push(this);
    }

    // If this element is capable of having children, search those too
    if (this.canHaveChildren) {
      for (var i = 0; i < this.children.length; i++) {
        _actions = _actions.concat(this.children[i].getActionsByAttr(_attr, _val));
      }
    }
    return _actions;
  }
  /**
   * Adds a new action to the child elements.
   *
   * @param {string} _type
   * @param {string} _id
   * @param {string} _caption
   * @param {string} _iconUrl
   * @param {(string|function)} _onExecute
   * @param {boolean} _allowOnMultiple
   */

  addAction(_type, _id) {
    var _caption = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "";
    var _iconUrl = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "";
    var _onExecute = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
    var _allowOnMultiple = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : true;
    //Get the constructor for the given action type
    if (!(_type in window._egwActionClasses)) {
      _type = "popup";
    }

    // Only allow adding new actions, if this action class allows it.
    if (this.canHaveChildren) {
      var _window$_egwActionCla;
      var _constructor = (_window$_egwActionCla = window._egwActionClasses[_type]) === null || _window$_egwActionCla === void 0 ? void 0 : _window$_egwActionCla.actionConstructor;
      if (typeof _constructor == "function") {
        var action = new _constructor(this, _id, _caption, _iconUrl, _onExecute, _allowOnMultiple);
        this.children.push(action);
        return action;
      } else {
        throw "Given action type not registered.";
      }
    } else {
      throw "This action does not allow child elements!";
    }
  }
  /**
   * Updates the children of this element
   *
   * @param {object} _actions { id: action, ...}
   * @param {string} _app defaults to egw_getAppname()
   */
  updateActions(_actions, _app) {
    if (this.canHaveChildren) {
      if (typeof _app == "undefined") _app = window.egw(window).app_name();
      /*
      this is an egw Object as defined in egw_core.js
      probably not because it changes on runtime
       */
      var localEgw = window.egw(_app, window);
      //replaced jQuery calls
      if (Array.isArray(_actions)) {
        //_actions is now an object for sure
        //happens in test website
        _actions = _objectSpread$U({}, _actions);
      }
      for (var i in _actions) {
        var elem = _actions[i];
        if (typeof elem == "string") {
          //changes type of elem to Object {caption:string}
          _actions[i] = elem = {
            caption: elem
          };
        }
        if (typeof elem == "object")
          // isn't this always true because of step above? Yes if elem was a string before
          {
            // use attr name as id, if none given
            if (typeof elem.id != "string") elem.id = i;

            // if no iconUrl given, check icon and default icons
            if (typeof elem.iconUrl == "undefined") {
              if (typeof elem.icon == "undefined") elem.icon = this.defaultIcons[elem.id]; // only works if default Icon is available
              if (typeof elem.icon != "undefined") {
                elem.iconUrl = localEgw.image(elem.icon);
              } else
                //elem.icon and elem.iconUrl is still undefined
                {
                  //if there is no icon and none can be found remove icon tag from the object
                  delete elem.icon;
                }
            }

            // always add shortcut for delete
            if (elem.id == "delete" && typeof elem.shortcut == "undefined") {
              elem.shortcut = {
                keyCode: 46,
                shift: false,
                ctrl: false,
                alt: false,
                caption: localEgw.lang('Del')
              };
            }

            // translate caption
            if (elem.caption && (typeof elem.no_lang == "undefined" || !elem.no_lang)) {
              elem.caption = localEgw.lang(elem.caption);
              if (typeof elem.hint == "string") elem.hint = localEgw.lang(elem.hint);
            }
            delete elem.no_lang;

            // translate confirm messages and place '?' at the end iff not there yet
            for (var attr in {
              confirm: '',
              confirm_multiple: ''
            }) {
              if (typeof elem[attr] == "string") {
                elem[attr] = localEgw.lang(elem[attr]) + (elem[attr].substr(-1) != '?' ? '?' : '');
              }
            }

            // set certain enabled functions iff elem.enabled is not set so false
            if (typeof elem.enabled == 'undefined' || elem.enabled === true) {
              if (typeof elem.enableClass != "undefined") {
                elem.enabled = this.enableClass;
              } else if (typeof elem.disableClass != "undefined") {
                elem.enabled = this.not_disableClass;
              } else if (typeof elem.enableId != "undefined") {
                elem.enabled = this.enableId;
              }
            }

            //Check whether the action already exists, and if no, add it to the
            //actions list
            var action = this.getActionById(elem.id);
            if (!action) {
              //elem will be popup on default
              if (typeof elem.type == "undefined") {
                elem.type = "popup";
              }
              var _constructor2 = null;

              // Check whether the given type is inside the "canHaveChildren"
              // array // here can have children is used as array where possible types of children are stored
              if (this.canHaveChildren !== true && this.canHaveChildren.indexOf(elem.type) == -1) {
                throw "This child type '" + elem.type + "' is not allowed!";
              }
              if (typeof window._egwActionClasses[elem.type] != "undefined") {
                _constructor2 = window._egwActionClasses[elem.type].actionConstructor;
              } else {
                throw "Given action type \"" + elem.type + "\" not registered, because type does not exist";
              }
              if (typeof _constructor2 == "function" && _constructor2) action = new _constructor2(this, elem.id);else throw "Given action type \"" + elem.type + "\" not registered.";
              this.children.push(action);
            }
            action.updateAction(elem);

            // Add sub-actions to the action
            if (elem.children) {
              action.updateActions(elem.children, _app);
            }
          }
      }
    } else {
      throw "This action element cannot have children!";
    }
  }
  /**
   * Callback to check if none of _senders rows has disableClass set
   *
   * @param _action EgwAction object, we use _action.data.disableClass to check
   * @param _senders array of egwActionObject objects
   * @param _target egwActionObject object, gets called for every object in _senders
   * @returns boolean true if none has disableClass, false otherwise
   */
  not_disableClass(_action, _senders, _target) {
    if (!Array.isArray(_action.data.disableClass)) {
      _action.data.disableClass = [_action.data.disableClass];
    }
    if (_target.iface.getDOMNode()) {
      return !Array.from(_target.iface.getDOMNode().classList).filter(name => _action.data.disableClass.includes(name)).length;
    } else if (_target.id) {
      // Checking on a something that doesn't have a DOM node, like a nm row
      // that's not currently rendered
      var data = window.egw.dataGetUIDdata(_target.id);
      if (data && data.data && data.data.class) {
        return !data.data.class.split(' ').filter(name => _action.data.disableClass.includes(name)).length;
      }
    }
  }
  /**
   * Callback to check if all of _senders rows have enableClass set
   *
   * @param _action EgwAction object, we use _action.data.enableClass to check
   * @param _senders array of egwActionObject objects
   * @param _target egwActionObject object, gets called for every object in _senders
   * @returns boolean true if none has disableClass, false otherwise
   */
  enableClass(_action, _senders, _target) {
    if (typeof _target == 'undefined') {
      return false;
    }
    if (!Array.isArray(_action.data.enableClass)) {
      _action.data.enableClass = [_action.data.enableClass];
    }
    if (_target.iface.getDOMNode()) {
      return Array.from(_target.iface.getDOMNode().classList).filter(name => _action.data.enableClass.includes(name)).length > 0;
    } else if (_target.id) {
      // Checking on a something that doesn't have a DOM node, like a nm row
      // that's not currently rendered.  Not as good as an actual DOM node check
      // since things can get missed, but better than nothing.
      var data = window.egw.dataGetUIDdata(_target.id);
      if (data && data.data && data.data.class) {
        return data.data.class.split(' ').filter(name => _action.data.enableClass.includes(name)).length > 0;
      }
    }
  }
  /**
   * Enable an _action, if it matches a given regular expression in _action.data.enableId
   *
   * @param _action EgwAction object, we use _action.data.enableId to check
   * @param _senders array of egwActionObject objects
   * @param _target egwActionObject object, gets called for every object in _senders
   * @returns boolean true if _target.id matches _action.data.enableId
   */
  enableId(_action, _senders, _target) {
    if (typeof _action.data.enableId == 'string') {
      _action.data.enableId = new RegExp(_action.data.enableId);
    }
    return _target.id.match(_action.data.enableId);
  }
  /**
   * Applies the same onExecute handler to all actions which don't have an execute
   * handler set.
   *
   * @param {(string|function)} _value
   */
  setDefaultExecute(_value) {
    // Check whether the onExecute handler of this action should be set
    if (this.type != "actionManager" && !this.onExecute.hasHandler()) {
      this.onExecute.isDefault = true;
      this.onExecute.setValue(_value);
    }

    // Apply the value to all children
    if (this.canHaveChildren) {
      for (var elem of this.children) {
        elem.setDefaultExecute(_value);
      }
    }
  }
  /**
   * Executes this action by using the method specified in the onExecute setter.
   *
   * @param {array} _senders array with references to the objects which caused the action
   * @param {object} _target is an optional parameter which may represent e.g. a drag drop target
   */
  execute(_senders) {
    var _target = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    if (!this._check_confirm_mass_selections(_senders, _target)) {
      return this._check_confirm(_senders, _target);
    }
  }
  /**
   * If this action needs to confirm mass selections (attribute confirm_mass_selection = true),
   * check for any checkboxes that have a confirmation prompt (confirm_mass_selection is a string)
   * and are unchecked.  We then show the prompt, and set the checkbox to their answer.
   *
   * * This is only considered if there are more than 20 entries selected.
   *
   * * Only the first confirmation prompt / checkbox action will be used, others
   *        will be ignored.
   *
   * @param {type} _senders
   * @param {type} _target
   * @returns {Boolean}
   */
  _check_confirm_mass_selections(_senders, _target) {
    var _this = this;
    var obj_manager = egw_getObjectManager(this.getManager().parent.id, false);
    if (!obj_manager) {
      return false;
    }

    // Action needs to care about mass selection - check for parent that cares too
    var confirm_mass_needed = false;
    var action = this;
    while (action && action !== obj_manager.manager && !confirm_mass_needed) {
      confirm_mass_needed = !!action.confirm_mass_selection;
      action = action.parent;
    }
    if (!confirm_mass_needed) return false;

    // Check for confirm mass selection checkboxes
    var confirm_mass_selections = obj_manager.manager.getActionsByAttr("confirm_mass_selection");
    confirm_mass_needed = _senders.length > 20;
    //no longer needed because of '=>' notation
    //const self = this;

    // Find & show prompt
    var _loop = function _loop() {
        var check = confirm_mass_selections[i];
        if (check.checkbox === false || check.checked === true) {
          return 0; // continue
        }

        // Show the mass selection prompt
        var msg = window.egw.lang(check.confirm_mass_selection, obj_manager.getAllSelected() ? window.egw.lang('all') : _senders.length);
        var callback = _button => {
          // YES = unchecked, NO = checked
          check.set_checked(_button === window.Et2Dialog.NO_BUTTON);
          if (_button !== window.Et2Dialog.CANCEL_BUTTON) {
            _this._check_confirm(_senders, _target);
          }
        };
        window.Et2Dialog.show_dialog(callback, msg, _this.data.hint, {}, window.Et2Dialog.BUTTONS_YES_NO_CANCEL, window.Et2Dialog.QUESTION_MESSAGE);
        return {
          v: true
        };
      },
      _ret;
    for (var i = 0; confirm_mass_needed && i < confirm_mass_selections.length; i++) {
      _ret = _loop();
      if (_ret === 0) continue;
      if (_ret) return _ret.v;
    }
    return false;
  }
  /**
   * Check to see if action needs to be confirmed by user before we do it
   */
  _check_confirm(_senders, _target) {
    // check if actions needs to be confirmed first
    if (this.data && (this.data.confirm || this.data.confirm_multiple) && this.onExecute.functionToPerform != window.nm_action && typeof window.Et2Dialog != 'undefined')
      // let old eTemplate run its own confirmation from nextmatch_action.js
      {
        var msg = this.data.confirm || '';
        if (_senders.length > 1) {
          if (this.data.confirm_multiple) {
            msg = this.data.confirm_multiple;
          }
          // check if we have all rows selected
          var obj_manager = egw_getObjectManager(this.getManager().parent.id, false);
          if (obj_manager && obj_manager.getAllSelected()) {
            msg += "\n\n" + window.egw.lang('Attention: action will be applied to all rows, not only visible ones!');
          }
        }
        //no longer needed because of '=>' notation
        //var self = this;
        if (msg.trim().length > 0) {
          if (this.data.policy_confirmation && window.egw.app('policy')) {
            import(window.egw.link('/policy/js/app.min.js')).then(() => {
              if (typeof window.app.policy === 'undefined' || typeof window.app.policy.confirm === 'undefined') {
                window.app.policy = new window.app.classes.policy();
              }
              window.app.policy.confirm(this, _senders, _target);
            });
            return;
          }
          window.Et2Dialog.show_dialog(_button => {
            if (_button == window.Et2Dialog.YES_BUTTON) {
              // @ts-ignore
              return this.onExecute.exec(this, _senders, _target);
            }
          }, msg, this.data.hint, {}, window.Et2Dialog.BUTTONS_YES_NO, window.Et2Dialog.QUESTION_MESSAGE);
          return;
        }
      }
    // @ts-ignore
    return this.onExecute.exec(this, _senders, _target);
  }
  updateAction(_data) {
    egwActionStoreJSON(_data, this, "data");
  }

  /**
   * Returns the parent action manager
   */
  getManager() {
    if (this.type == "actionManager") {
      return this;
    } else if (this.parent) {
      return this.parent.getManager();
    } else {
      return null;
    }
  }

  /**
   * The appendToGraph function generates an action tree which automatically contains
   * all parent elements. If the appendToGraph function is called for a
   *
   * @param {not an array} _tree contains the tree structure - pass an object containing {root:Tree}
   *    the empty array "root" to this function {"root": []}. The result will be stored in
   *    this array.
   * @param {boolean} _addChildren is used internally to prevent parent elements from
   *    adding their children automatically to the tree.
   */
  appendToTree(_tree) {
    var _addChildren = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    if (typeof _addChildren == "undefined") {
      _addChildren = true;
    }

    // Preset some variables
    var root = _tree.root;
    var parentNode = null;
    var node = {
      "action": this,
      "children": []
    };
    if (this.parent && this.type != "actionManager") {
      // Check whether the parent container has already been added to the tree
      parentNode = _egwActionTreeFind(root, this.parent);
      if (!parentNode) {
        parentNode = this.parent.appendToTree(_tree, false);
      }

      // Check whether this element has already been added to the parent container
      var added = false;
      for (var child of parentNode.children) {
        if (child.action == this) {
          node = child;
          added = true;
          break;
        }
      }
      if (!added) {
        parentNode.children.push(node);
      }
    } else {
      var _added = false;
      for (var treeElem of root) {
        if (treeElem.action == this) {
          node = treeElem;
          _added = true;
          break;
        }
      }
      if (!_added) {
        // Add this element to the root if it has no parent
        root.push(node);
      }
    }
    if (_addChildren) {
      for (var _child of this.children) {
        _child.appendToTree(_tree, true);
      }
    }
    return node;
  }
  /**
   * @deprecated directly set value instead
   * @param _value
   */
  set_hideOnDisabled(_value) {
    this.hideOnDisabled = _value;
  }
  /**
   * @deprecated directly set value instead
   * @param _value
   */
  set_hideOnMobile(_value) {
    this.hideOnMobile = _value;
  }
  /**
   * @deprecated directly set value instead
   * @param _value
   */
  set_disableIfNoEPL(_value) {
    this.disableIfNoEPL = _value;
  }
  set_hint(hint) {}
  clone() {
    var clone = Object.assign(Object.create(Object.getPrototypeOf(this)), this);
    clone.onExecute = this.onExecute.clone();
    if (this.enabled) {
      clone.enabled = this.enabled.clone();
    }
    return clone;
  }
}
/**
 * finds an egwAction in the given tree
 * @param {Tree}_tree where to search
 * @param {EgwAction}_elem elem to search
 * @returns {TreeElem} the treeElement for corresponding _elem if found, null else
 */
function _egwActionTreeFind(_tree, _elem) {
  for (var current of _tree) {
    if (current.action == _elem) {
      return current;
    }
    if (typeof current.children != "undefined") {
      var elem = _egwActionTreeFind(current.children, _elem);
      if (elem) {
        return elem;
      }
    }
  }
  return null;
}

/**
 * EGroupware egw_action framework - egw action framework
 *
 * @link https://www.egroupware.org
 * @author Andreas Stöckel <as@stylite.de>
 * @copyright 2011 by Andreas Stöckel
 * @license http://opensource.org/licenses/gpl-license.php GPL - GNU General Public License
 * @package egw_action
 */

/**
 * egwActionManager manages a list of actions - it overwrites the egwAction class
 * and allows child actions to be added to it.
 *
 * @param {EgwAction} _parent
 * @param {string} _id
 * @return {EgwActionManager}
 */
class EgwActionManager extends EgwAction {
  constructor() {
    var _parent = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
    var _id = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "";
    super(_parent, _id);
    this.type = "actionManager";
    this.canHaveChildren = true;
  }
}

function _defineProperty$2t(e, r, t) { return (r = _toPropertyKey$2s(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2s(t) { var i = _toPrimitive$2s(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2s(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * The egwActionLink is used to interconnect egwActionObjects and egwActions.
 * This gives each action object the possibility to decide, whether the action
 * should be active in this context or not.
 *
 * @param _manager is a reference to the egwActionManager which contains the action
 *    the object wants to link to.
 */
class EgwActionLink {
  constructor(_manager) {
    _defineProperty$2t(this, "enabled", true);
    _defineProperty$2t(this, "visible", true);
    _defineProperty$2t(this, "actionId", "");
    _defineProperty$2t(this, "actionObj", null);
    _defineProperty$2t(this, "manager", void 0);
    this.manager = _manager;
  }
  updateLink(_data) {
    egwActionStoreJSON(_data, this, true);
  }
  set_enabled(_value) {
    this.enabled = _value;
  }
  set_visible(_value) {
    this.visible = _value;
  }
  set_actionId(_value) {
    this.actionId = _value;
    this.actionObj = this.manager.getActionById(_value);
    if (!this.actionObj) throw "Action object with id '" + _value + "' does not exist!";
  }
}

var es_regexp_flags = {};

var global$4 = global$c;
var DESCRIPTORS$3 = descriptors;
var defineBuiltInAccessor$2 = defineBuiltInAccessor$4;
var regExpFlags = regexpFlags;
var fails$3 = fails$e;

// babel-minify and Closure Compiler transpiles RegExp('.', 'd') -> /./d and it causes SyntaxError
var RegExp$2 = global$4.RegExp;
var RegExpPrototype = RegExp$2.prototype;

var FORCED$1 = DESCRIPTORS$3 && fails$3(function () {
  var INDICES_SUPPORT = true;
  try {
    RegExp$2('.', 'd');
  } catch (error) {
    INDICES_SUPPORT = false;
  }

  var O = {};
  // modern V8 bug
  var calls = '';
  var expected = INDICES_SUPPORT ? 'dgimsy' : 'gimsy';

  var addGetter = function (key, chr) {
    // eslint-disable-next-line es/no-object-defineproperty -- safe
    Object.defineProperty(O, key, { get: function () {
      calls += chr;
      return true;
    } });
  };

  var pairs = {
    dotAll: 's',
    global: 'g',
    ignoreCase: 'i',
    multiline: 'm',
    sticky: 'y'
  };

  if (INDICES_SUPPORT) pairs.hasIndices = 'd';

  for (var key in pairs) addGetter(key, pairs[key]);

  // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
  var result = Object.getOwnPropertyDescriptor(RegExpPrototype, 'flags').get.call(O);

  return result !== expected || calls !== expected;
});

// `RegExp.prototype.flags` getter
// https://tc39.es/ecma262/#sec-get-regexp.prototype.flags
if (FORCED$1) defineBuiltInAccessor$2(RegExpPrototype, 'flags', {
  configurable: true,
  get: regExpFlags
});

function _defineProperty$2s(e, r, t) { return (r = _toPropertyKey$2r(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2r(t) { var i = _toPrimitive$2r(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2r(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * The egwActionObject represents an abstract object to which actions may be
 * applied. Communication with the DOM tree is established by using the
 * egwActionObjectInterface (AOI), which is passed in the constructor.
 * egwActionObjects are organized in a tree structure.
 *
 * @param {string} _id is the identifier of the object which
 * @param {EgwActionObject} _parent is the parent object in the hierarchy. This may be set to NULL
 * @param {egwActionObjectInterface} _iface is the egwActionObjectInterface which connects the object
 *    to the outer world.
 * @param {EgwActionManager} _manager is the action manager this object is connected to
 *    this object to the DOM tree. If the _manager isn't supplied, the parent manager
 *    is taken.
 * @param {number} _flags a set of additional flags being applied to the object,
 *    defaults to 0
 */
class EgwActionObject {
  constructor(_id, _parent, _interface, _manager) {
    var _flags = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
    _defineProperty$2s(this, "id", void 0);
    _defineProperty$2s(this, "parent", void 0);
    _defineProperty$2s(this, "children", []);
    _defineProperty$2s(this, "actionLinks", []);
    _defineProperty$2s(this, "iface", void 0);
    _defineProperty$2s(this, "manager", void 0);
    _defineProperty$2s(this, "flags", void 0);
    _defineProperty$2s(this, "data", null);
    _defineProperty$2s(this, "setSelectedCallback", null);
    _defineProperty$2s(this, "registeredImpls", []);
    // Two variables which help fast travelling through the object tree, when
    // searching for the selected/focused object.
    _defineProperty$2s(this, "selectedChildren", []);
    _defineProperty$2s(this, "focusedChild", null);
    _defineProperty$2s(this, "onBeforeTrigger", undefined);
    _defineProperty$2s(this, "_context", undefined);
    /**
     * Some widgets handle DOM events for child objects, so we only bind one DOM event listener.
     * Set this in the child action object, pointing to the parent that will listen for the DOM events.
     * findActionTargetHandler must have an implementation of ActionTargetHandler
     */
    _defineProperty$2s(this, "findActionTargetHandler", void 0);
    if (typeof _manager == "undefined" && typeof _parent == "object" && _parent) _manager = _parent.manager;
    if (typeof _flags == "undefined") _flags = 0;
    this.id = _id;
    this.parent = _parent;
    this.iface = _interface;
    this.manager = _manager;
    this.flags = _flags;
    this.setAOI(_interface);
  }

  /**
   * Sets the action object interface - if "NULL" is given, the iface is set
   * to a dummy interface which is used to store the temporary data.
   *
   * @param {egwActionObjectInterface} _aoi
   */
  setAOI(_aoi) {
    if (_aoi == null) {
      //TODo replace DummyInterface
      _aoi = new egwActionObjectInterface();
    }

    // Copy the state from the old interface
    if (this.iface) {
      _aoi.setState(this.iface.getState());
    }

    // Replace the interface object
    this.iface = _aoi;
    this.iface.setStateChangeCallback(this._ifaceCallback, this);
    this.iface.setReconnectActionsCallback(this._reconnectCallback, this);
  }
  /**
   //     * Returns the object from the tree with the given ID
   //     *
   //     * @param {string} _id
   //     * @param {number} _search_depth
   //     * @return {egwActionObject} description
   //     * @todo Add search function to egw_action_commons.js
   //     */
  getObjectById(_id) {
    var _search_depth = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : Number.MAX_VALUE;
    if (this.id == _id) {
      return this;
    }
    for (var i = 0; i < this.children.length && _search_depth > 0; i++) {
      var obj = this.children[i].getObjectById(_id, _search_depth - 1);
      if (obj) {
        return obj;
      }
    }
    return null;
  }
  /**
   * Adds an object as child to the actionObject and returns it - if the supplied
   * parameter is an object, the object will be added directly, otherwise an object
   * with the given id will be created.
   *
   * @param {(string|object)} _id Id of the object which will be created or the object
   *    that will be added.
   * @param {object} _interface if _id was a string, _interface defines the interface which
   *    will be connected to the newly generated object.
   * @param {number} _flags are the flags will which be supplied to the newly generated
   *    object. May be omitted.
   * @returns object the generated object
   */
  addObject(_id) {
    var _interface = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    var _flags = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
    return this.insertObject(false, _id, _interface, _flags);
  }
  /**
   * Inserts an object as child to the actionObject and returns it - if the supplied
   * parameter is an object, the object will be added directly, otherwise an object
   * with the given id will be created.
   *
   * @param {number} _index Position where the object will be inserted, "false" will add it
   *    to the end of the list.
   * @param {string|object} _id Id of the object which will be created or the object
   *    that will be added.
   * @param {object} _iface if _id was a string, _iface defines the interface which
   *    will be connected to the newly generated object.
   * @param {number} _flags are the flags will which be supplied to the newly generated
   *    object. May be omitted.
   * @returns object the generated object
   */

  insertObject(_index, _id, _iface, _flags) {
    if (_index === false) _index = this.children.length;
    var obj = null;
    if (typeof _id == "object") {
      obj = _id;

      // Set the parent to null and reset the focus of the object
      obj.parent = null;
      obj.setFocused(false);

      // Set the parent to this object
      obj.parent = this;
    } else if (typeof _id == "string") {
      obj = new EgwActionObject(_id, this, _iface, this.manager, _flags);
    }
    if (obj) {
      // Add the element to the children
      this.children.splice(_index, 0, obj);
    } else {
      throw "Error while adding new element to the ActionObjects!";
    }
    return obj;
  }
  /**
   * Deletes all children of the egwActionObject
   */

  clear() {
    // Remove all children
    while (this.children.length > 0) {
      this.children[0].remove();
    }

    // Delete all other references
    this.selectedChildren = [];
    this.focusedChild = null;

    // Remove links
    this.actionLinks = [];
  }
  /**
   * Deletes this object from the parent container
   */
  remove() {
    // Remove focus and selection from this element
    this.setFocused(false);
    this.setSelected(false);
    this.setAllSelected(false);

    // Unregister all registered action implementations
    this.unregisterActions();

    // Clear the child-list
    this.clear();

    // Remove this element from the parent list
    if (this.parent != null) {
      var idx = this.parent.children.indexOf(this);
      if (idx >= 0) {
        this.parent.children.splice(idx, 1);
      }
    }
  }
  /**
   * Searches for the root object in the action object tree and returns it.
   */
  getRootObject() {
    if (this.parent === null) {
      return this;
    } else {
      return this.parent.getRootObject();
    }
  }
  /**
   * Returns a list with all parents of this object.
   */
  getParentList() {
    if (this.parent === null) {
      return [];
    } else {
      var list = this.parent.getParentList();
      list.unshift(this.parent);
      return list;
    }
  }
  /**
   * Returns the first parent which has the container flag
   */
  getContainerRoot() {
    if (egwBitIsSet(this.flags, EGW_AO_FLAG_IS_CONTAINER) || this.parent === null) {
      return this;
    } else {
      return this.parent.getContainerRoot();
    }
  }
  /**
   * Returns all selected objects which are in the current subtree.
   *
   * @param {function} _test is a function, which gets an object and checks whether
   *    it will be added to the list.
   * @param {array} _list is internally used to fetch all selected elements, please
   *    omit this parameter when calling the function.
   */
  getSelectedObjects(_test, _list) {
    if (typeof _test == "undefined") _test = null;
    if (typeof _list == "undefined") {
      _list = {
        "elements": []
      };
    }
    if ((!_test || _test(this)) && this.getSelected()) _list.elements.push(this);
    if (this.selectedChildren) {
      for (var i = 0; i < this.selectedChildren.length; i++) {
        this.selectedChildren[i].getSelectedObjects(_test, _list);
      }
    }
    return _list.elements;
  }
  /**
   * Returns whether all objects in this tree are selected
   */
  getAllSelected() {
    if (this.children.length == this.selectedChildren.length) {
      for (var i = 0; i < this.children.length; i++) {
        if (!this.children[i].getAllSelected()) return false;
      }
      // If this element is a container *and* does not have any children, we
      // should return false. If this element is not a container we have to
      // return true has this is the recursion base case
      return !egwBitIsSet(this.flags, EGW_AO_FLAG_IS_CONTAINER) || this.children.length > 0;
    }
    return false;
  }
  /**
   * Toggles the selection of all objects.
   *
   * @param _select boolean specifies whether the objects should get selected or not.
   *    If this parameter is not supplied, the selection will be toggled.
   */
  toggleAllSelected(_select) {
    if (typeof _select == "undefined") {
      _select = !this.getAllSelected();
    }

    // Check for a select_all action
    if (_select && this.manager && this.manager.getActionById('select_all')) {
      return this.manager.getActionById('select_all').execute(this);
    }
    this.setAllSelected(_select);
  }
  /**
   * Creates a list which contains all items of the element tree.
   *
   * @param {boolean} _visibleOnly
   * @param {object} _obj is used internally to pass references to the array inside
   *    the object.
   * @return {array}
   */
  flatList(_visibleOnly, _obj) {
    if (typeof _obj == "undefined") {
      _obj = {
        "elements": []
      };
    }
    if (typeof _visibleOnly == "undefined") {
      _visibleOnly = false;
    }
    if (!_visibleOnly || this.getVisible()) {
      _obj.elements.push(this);
    }
    for (var child of this.children) {
      child.flatList(_visibleOnly, _obj);
    }
    return _obj.elements;
  }
  /**
   * Returns a traversal list with all objects which are in between the given object
   * and this one. The operation returns an empty list, if a container object is
   * found on the way.
   *
   * @param {object} _to
   * @return {array}
   * @todo Remove flatList here!
   */
  traversePath(_to) {
    var contRoot = this.getContainerRoot();
    if (contRoot) {
      // Get a flat list of all the hncp elements and search for this object
      // and the object supplied in the _to parameter.
      var flatList = contRoot.flatList();
      var thisId = flatList.indexOf(this);
      var toId = flatList.indexOf(_to);

      // Check whether both elements have been found in this part of the tree,
      // return the slice of that list.
      if (thisId !== -1 && toId !== -1) {
        var from = Math.min(thisId, toId);
        var to = Math.max(thisId, toId);
        return flatList.slice(from, to + 1);
      }
    }
    return [];
  }
  /**
   * Returns the index of this object in the children list of the parent object.
   */
  getIndex() {
    if (this.parent === null) {
      //TODO check: should be -1 for invalid
      return 0;
    } else {
      return this.parent.children.indexOf(this);
    }
  }
  /**
   * Returns the deepest object which is currently focused. Objects with the
   * "container"-flag will not be returned.
   */
  getFocusedObject() {
    return this.focusedChild || null;
  }
  /**
   * Internal function which is connected to the ActionObjectInterface associated
   * with this object in the constructor. It gets called, whenever the object
   * gets (de)selected.
   *
   * @param {number} _newState is the new state of the object
   * @param {number} _changedBit
   * @param {number} _shiftState is the status of extra keys being pressed during the
   *    selection process.
   */
  _ifaceCallback(_newState, _changedBit, _shiftState) {
    if (typeof _shiftState == "undefined") _shiftState = EGW_AO_SHIFT_STATE_NONE;
    var selected = egwBitIsSet(_newState, EGW_AO_STATE_SELECTED);
    var visible = egwBitIsSet(_newState, EGW_AO_STATE_VISIBLE);

    // Check whether the visibility of the object changed
    if (_changedBit == EGW_AO_STATE_VISIBLE && visible != this.getVisible()) {
      // Deselect the object
      if (!visible) {
        this.setSelected(false);
        this.setFocused(false);
        return EGW_AO_STATE_NORMAL;
      } else {
        // Auto-register the actions attached to this object
        this.registerActions();
      }
    }

    // Remove the focus from all children on the same level
    if (this.parent && visible && _changedBit == EGW_AO_STATE_SELECTED) {
      selected = egwBitIsSet(_newState, EGW_AO_STATE_SELECTED);
      var objs = [];
      if (selected) {
        // Deselect all other objects inside this container, if the "MULTI" shift-state is not set
        if (!egwBitIsSet(_shiftState, EGW_AO_SHIFT_STATE_MULTI)) {
          this.getContainerRoot().setAllSelected(false);
        }

        // If the LIST state is active, get all objects in between this one and the focused one
        // and set their select state.
        if (egwBitIsSet(_shiftState, EGW_AO_SHIFT_STATE_BLOCK)) {
          var focused = this.getFocusedObject();
          if (focused) {
            objs = this.traversePath(focused);
            for (var i = 0; i < objs.length; i++) {
              objs[i].setSelected(true);
            }
          }
        }
      }

      // If the focused element didn't belong to this container, or the "list"
      // shift-state isn't active, set the focus to this element.
      if (objs.length == 0 || !egwBitIsSet(_shiftState, EGW_AO_SHIFT_STATE_BLOCK)) {
        this.setFocused(true);
        _newState = egwSetBit(EGW_AO_STATE_FOCUSED, _newState, true);
      }
      this.setSelected(selected);
    }
    return _newState;
  }
  /**
   * Handler for key presses
   *
   * @param {number} _keyCode
   * @param {boolean} _shift
   * @param {boolean} _ctrl
   * @param {boolean} _alt
   * @returns {boolean}
   */
  handleKeyPress(_keyCode, _shift, _ctrl, _alt) {
    switch (_keyCode) {
      case EGW_KEY_ARROW_UP:
      case EGW_KEY_ARROW_DOWN:
      case EGW_KEY_PAGE_UP:
      case EGW_KEY_PAGE_DOWN:
        if (!_alt) {
          var intval = _keyCode == EGW_KEY_ARROW_UP || _keyCode == EGW_KEY_ARROW_DOWN ? 1 : 10;
          if (this.children.length > 0) {
            // Get the focused object
            var _focused2 = this.getFocusedObject();

            // Determine the object which should get selected
            var selObj = null;
            if (!_focused2) {
              selObj = this.children[0];
            } else {
              selObj = _keyCode == EGW_KEY_ARROW_UP || _keyCode == EGW_KEY_PAGE_UP ? _focused2.getPrevious(intval) : _focused2.getNext(intval);
            }
            if (selObj != null) {
              if (!_shift && !(this.parent && this.parent.data && this.parent.data.keyboard_select)) {
                this.setAllSelected(false);
              } else if (!(this.parent && this.parent.data && this.parent.data.keyboard_select)) {
                var objs = _focused2.traversePath(selObj);
                for (var i = 0; i < objs.length; i++) {
                  objs[i].setSelected(true);
                }
              }
              if (!(this.parent.data && this.parent.data.keyboard_select)) {
                selObj.setSelected(true);
              }
              selObj.setFocused(true);

              // Tell the aoi of the object to make it visible
              selObj.makeVisible();
            }
            return true;
          }
        }
        break;

      // Space bar toggles selected for current row
      case EGW_KEY_SPACE:
        if (this.children.length <= 0) {
          break;
        }
        // Mark that we're selecting by keyboard, or arrows will reset selection
        if (!this.parent.data) {
          this.parent.data = {};
        }
        this.parent.data.keyboard_select = true;

        // Get the focused object
        var focused = this.getFocusedObject();
        focused.setSelected(!focused.getSelected());

        // Tell the aoi of the object to make it visible
        focused.makeVisible();
        return true;

      // Handle CTRL-A to select all elements in the current container
      case EGW_KEY_A:
        if (_ctrl && !_shift && !_alt) {
          this.toggleAllSelected();
          return true;
        }
        break;
    }
    return false;
  }
  getPrevious(_intval) {
    if (this.parent != null) {
      if (this.getFocused() && !this.getSelected()) {
        return this;
      }
      var flatTree = this.getContainerRoot().flatList();
      var idx = flatTree.indexOf(this);
      if (idx > 0) {
        idx = Math.max(1, idx - _intval);
        return flatTree[idx];
      }
    }
    return this;
  }
  getNext(_intval) {
    if (this.parent != null) {
      if (this.getFocused() && !this.getSelected()) {
        return this;
      }
      var flatTree = this.getContainerRoot().flatList(true);
      var idx = flatTree.indexOf(this);
      if (idx < flatTree.length - 1) {
        idx = Math.min(flatTree.length - 1, idx + _intval);
        return flatTree[idx];
      }
    }
    return this;
  }
  /**
   * Returns whether the object is currently selected.
   */

  getSelected() {
    return egwBitIsSet(this.getState(), EGW_AO_STATE_SELECTED);
  }
  /**
   * Returns whether the object is currently focused.
   */

  getFocused() {
    return egwBitIsSet(this.getState(), EGW_AO_STATE_FOCUSED);
  }
  /**
   * Returns whether the object currently is visible - visible means, that the
   * AOI has a dom node and is visible.
   */

  getVisible() {
    return egwBitIsSet(this.getState(), EGW_AO_STATE_VISIBLE);
  }
  /**
   * Returns the complete state of the object.
   */

  getState() {
    return this.iface.getState();
  }
  /**
   * Sets the focus of the element. The formerly focused element in the tree will
   * be de-focused.
   *
   * @param {boolean} _focused - whether to remove or set the focus. Defaults to true
   */

  setFocused(_focused) {
    if (typeof _focused == "undefined") _focused = true;
    var state = this.iface.getState();
    if (egwBitIsSet(state, EGW_AO_STATE_FOCUSED) != _focused) {
      // Un-focus the currently focused object
      var currentlyFocused = this.getFocusedObject();
      if (currentlyFocused && currentlyFocused != this) {
        currentlyFocused.setFocused(false);
      }
      this.iface.setState(egwSetBit(state, EGW_AO_STATE_FOCUSED, _focused));
      if (this.parent) {
        this.parent.updateFocusedChild(this, _focused);
      }
    }
    if (this.focusedChild != null && _focused == false) {
      this.focusedChild.setFocused(false);
    }
  }
  /**
   * Sets the selected state of the element.
   *
   * @param {boolean} _selected
   * @TODO Callback
   */

  setSelected(_selected) {
    var state = this.iface.getState();
    if (egwBitIsSet(state, EGW_AO_STATE_SELECTED) != _selected && egwBitIsSet(state, EGW_AO_STATE_VISIBLE)) {
      this.iface.setState(egwSetBit(state, EGW_AO_STATE_SELECTED, _selected));
      if (this.parent) {
        this.parent.updateSelectedChildren(this, _selected || this.selectedChildren.length > 0);
      }
    }
  }
  /**
   * Sets the selected state of all elements, including children
   *
   * @param {boolean} _selected
   * @param {boolean} _informParent
   */

  setAllSelected(_selected) {
    var _informParent = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    var state = this.iface.getState();

    // Update this element
    if (egwBitIsSet(state, EGW_AO_STATE_SELECTED) != _selected) {
      var _this$parent, _this$parent2;
      this.iface.setState(egwSetBit(state, EGW_AO_STATE_SELECTED, _selected));
      if (_informParent && this.parent) {
        this.parent.updateSelectedChildren(this, _selected);
      }
      if ((_this$parent = this.parent) !== null && _this$parent !== void 0 && _this$parent.data && (_this$parent2 = this.parent) !== null && _this$parent2 !== void 0 && (_this$parent2 = _this$parent2.data) !== null && _this$parent2 !== void 0 && _this$parent2.keyboard_select) {
        this.parent.data.keyboard_select = false;
      }
    }

    // Update the children if they should be selected or if they should be
    // deselected and there are selected children.
    if (_selected || this.selectedChildren.length > 0) {
      for (var i = 0; i < this.children.length; i++) {
        this.children[i].setAllSelected(_selected, false);
      }
    }

    // Copy the selected children list
    this.selectedChildren = [];
    if (_selected) {
      for (var _i = 0; _i < this.children.length; _i++) {
        this.selectedChildren.push(this.children[_i]);
      }
    }

    // Call the setSelectedCallback
    egwQueueCallback(this.setSelectedCallback, [], this, "setSelectedCallback");
  }
  /**
   * Updates the selectedChildren array each actionObject has in order to determine
   * all selected children in a very fast manner.
   *
   * @param {(string|egwActionObject} _child
   * @param {boolean} _selected
   * @todo Has also to be updated, if an child is added/removed!
   */

  updateSelectedChildren(_child, _selected) {
    var id = this.selectedChildren.indexOf(_child); // TODO Replace by binary search, insert children sorted by index!
    var wasEmpty = this.selectedChildren.length == 0;

    // Add or remove the given child from the selectedChildren list
    if (_selected && id == -1) {
      this.selectedChildren.push(_child);
    } else if (!_selected && id != -1) {
      this.selectedChildren.splice(id, 1);
    }

    // If the emptiness of the selectedChildren array has changed, update the
    // parent selected children array.
    if (wasEmpty != (this.selectedChildren.length == 0) && this.parent) {
      this.parent.updateSelectedChildren(this, wasEmpty);
    }

    // Call the setSelectedCallback
    egwQueueCallback(this.setSelectedCallback, this.getContainerRoot().getSelectedObjects(), this, "setSelectedCallback");
  }
  /**
   * Updates the focusedChild up to the container boundary.
   *
   * @param {(string|egwActionObject} _child
   * @param {boolean} _focused
   */

  updateFocusedChild(_child, _focused) {
    if (_focused) {
      this.focusedChild = _child;
    } else {
      if (this.focusedChild == _child) {
        this.focusedChild = null;
      }
    }
    if (this.parent /*&& !egwBitIsSet(this.flags, EGW_AO_FLAG_IS_CONTAINER)*/) {
      this.parent.updateFocusedChild(_child, _focused);
    }
  }
  /**
   * Updates the actionLinks of the given ActionObject.
   *
   * @param {array} _actionLinks contains the information about the actionLinks which
   *    should be updated as an array of objects. Example
   *    [
   *        {
   * 			"actionId": "file_delete",
   * 			"enabled": true
   * 		}
   *    ]
   *    string[] or {actionID:string,enabled:boolean}[]
   *    If an supplied link doesn't exist yet, it will be created (if _doCreate is true)
   *    and added to the list. Otherwise, the information will just be updated.
   * @param {boolean} _recursive If true, the settings will be applied to all child
   *    object (default false)
   * @param {boolean} _doCreate If true, not yet existing links will be created (default true)
   */

  updateActionLinks(_actionLinks) {
    var _recursive = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    var _doCreate = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
    for (var elem of _actionLinks) {
      // Allow single strings for simple action links.
      if (typeof elem == "string") {
        elem = {
          actionId: elem,
          enabled: true
        };
      }
      if (typeof elem.actionId != "undefined" && elem.actionId) {
        //Get the action link object, if it doesn't exist yet, create it
        var actionLink = this.getActionLink(elem.actionId);
        if (!actionLink && _doCreate) {
          actionLink = new EgwActionLink(this.manager);
          this.actionLinks.push(actionLink);
        }

        //Set the supplied data
        if (actionLink) {
          actionLink.updateLink(elem);
        }
      }
    }
    if (_recursive) {
      for (var i = 0; i < this.children.length; i++) {
        this.children[i].updateActionLinks(_actionLinks, true, _doCreate);
      }
    }
    if (this.getVisible() && this.iface != null) {
      this.registerActions();
    }
  }
  /**
   * Reconnects the actions.
   */

  _reconnectCallback() {
    this.registeredImpls = [];
    this.registerActions();
  }
  /**
   * Registers the action implementations inside the DOM-Tree.
   */
  registerActions() {
    var groups = this.getActionImplementationGroups();
    for (var group in groups) {
      // Get the action implementation for each group
      if (typeof window._egwActionClasses[group] != "undefined" && window._egwActionClasses[group].implementation && this.iface) {
        var impl = window._egwActionClasses[group].implementation();
        if (this.registeredImpls.indexOf(impl) == -1) {
          // Register a handler for that action with the iface of that object,
          // the callback and this object as context for the callback
          if (impl.registerAction(this.iface, this.executeActionImplementation, this)) {
            this.registeredImpls.push(impl);
          }
        }
      }
    }
  }
  /**
   * Unregisters all action implementations registered to this element
   */
  unregisterActions() {
    while (this.registeredImpls.length > 0) {
      var impl = this.registeredImpls.pop();
      if (this.iface) {
        impl.unregisterAction(this.iface);
      }
    }
  }
  triggerCallback() {
    if (this.onBeforeTrigger) {
      return this.onBeforeTrigger();
    }
    return true;
  }
  makeVisible() {
    this.iface.makeVisible();
  }
  /**
   * Executes the action implementation which is associated to the given action type.
   *
   * @param {object} _implContext is data which should be delivered to the action implementation.
   *    E.g. in case of the popup action implementation, the x and y coordinates where the
   *    menu should open, and contextmenu event are transmitted.
   * @param {string} _implType is the action type for which the implementation should be
   *    executed.
   * @param {number} _execType specifies in which context the execution should take place.
   *    defaults to EGW_AO_EXEC_SELECTED
   */

  executeActionImplementation(_implContext, _implType, _execType) {
    if (typeof _execType == "undefined") {
      _execType = EGW_AO_EXEC_SELECTED;
    }
    if (typeof _implType == "string") {
      _implType = window._egwActionClasses[_implType].implementation();
    }
    if (typeof _implType == "object" && _implType) {
      var selectedActions;
      if (_execType == EGW_AO_EXEC_SELECTED) {
        if (!egwBitIsSet(EGW_AO_FLAG_IS_CONTAINER, this.flags)) {
          this.forceSelection();
        }
        selectedActions = this.getSelectedLinks(_implType.type);
      } else if (_execType == EGW_AO_EXEC_THIS) {
        selectedActions = this._getLinks([this], _implType.type);
      }
      if (selectedActions.selected.length > 0 && egwObjectLength(selectedActions.links) > 0) {
        return _implType.executeImplementation(_implContext, selectedActions.selected, selectedActions.links);
      }
    }
    return false;
  }
  /**
   * Forces the object to be inside the currently selected objects. If this is
   * not the case, the object will select itself and deselect all other objects.
   */

  forceSelection() {
    var selected = this.getContainerRoot().getSelectedObjects();

    // Check whether this object is in the list
    var thisInList = selected.indexOf(this) != -1;

    // If not, select it
    if (!thisInList) {
      this.getContainerRoot().setAllSelected(false);
      this.setSelected(true);
    }
    this.setFocused(true);
  }
  /**
   * Returns all selected objects, and all action links of those objects, which are
   * of the given implementation type, actionLink properties such as
   * "enabled" and "visible" are accumulated.
   *
   * Objects have the chance to change their action links or to deselect themselves
   * in the onBeforeTrigger event, which is evaluated by the triggerCallback function.
   *
   * @param _actionType is the action type for which the actionLinks should be collected.
   * @returns object An object which contains a "links" and a "selected" section with
   *    an array of links/selected objects-
   */

  getSelectedLinks(_actionType) {
    var useSelf = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    // Get all objects in this container which are currently selected
    var selected = useSelf ? [this] : this.getContainerRoot().getSelectedObjects();
    return this._getLinks(selected, _actionType);
  }
  /**
   *
   * @param {array} _objs
   * @param {string} _actionType
   * @return {object} with attributes "selected" and "links"
   */

  _getLinks(_objs, _actionType) {
    var actionLinks = {};
    var testedSelected = [];
    var test = function test(olink, obj) {
      // Test whether the action type is of the given implementation type
      if (olink.actionObj.type == _actionType) {
        if (typeof actionLinks[olink.actionId] == "undefined") {
          actionLinks[olink.actionId] = {
            "actionObj": olink.actionObj,
            "enabled": testedSelected.length == 1,
            "visible": false,
            "cnt": 0
          };
        }

        // Accumulate the action link properties
        var llink = actionLinks[olink.actionId];
        llink.enabled = llink.enabled && olink.actionObj.enabled.exec(olink.actionObj, _objs, obj) && olink.enabled && olink.visible;
        llink.visible = llink.visible || olink.visible;
        llink.cnt++;

        // Add in children, so they can get checked for visible / enabled
        if (olink.actionObj && olink.actionObj.children.length > 0) {
          for (var j = 0; j < olink.actionObj.children.length; j++) {
            var child = olink.actionObj.children[j];
            test({
              actionObj: child,
              actionId: child.id,
              enabled: olink.enabled,
              visible: olink.visible
            }, obj);
          }
        }
      }
    };
    var _loop = function _loop(obj) {
      if (!egwBitIsSet(obj.flags, EGW_AO_FLAG_IS_CONTAINER) && obj.triggerCallback()) {
        testedSelected.push(obj);
        obj.actionLinks.forEach(item => {
          test(item, obj); //object link
        });
      }
    };
    for (var obj of _objs) {
      _loop(obj);
    }

    // Check whether all objects supported the action
    for (var k in actionLinks) {
      actionLinks[k].enabled = actionLinks[k].enabled && actionLinks[k].cnt >= testedSelected.length && (actionLinks[k].actionObj.allowOnMultiple === true || actionLinks[k].actionObj.allowOnMultiple == "only" && _objs.length > 1 || actionLinks[k].actionObj.allowOnMultiple == false && _objs.length === 1 || typeof actionLinks[k].actionObj.allowOnMultiple === 'number' && _objs.length == actionLinks[k].actionObj.allowOnMultiple);
      if (!window.egwIsMobile()) actionLinks[k].actionObj.hideOnMobile = false;
      actionLinks[k].visible = actionLinks[k].visible && !actionLinks[k].actionObj.hideOnMobile && (actionLinks[k].enabled || !actionLinks[k].actionObj.hideOnDisabled);
    }

    // Return an object which contains the accumulated actionLinks and all selected
    // objects.
    return {
      "selected": testedSelected,
      "links": actionLinks
    };
  }
  /**
   * Returns the action link, which contains the association to the action with
   * the given actionId.
   *
   * @param {string} _actionId name of the action associated to the link
   */

  getActionLink(_actionId) {
    for (var i = 0; i < this.actionLinks.length; i++) {
      var _this$actionLinks$i$a;
      if (((_this$actionLinks$i$a = this.actionLinks[i].actionObj) === null || _this$actionLinks$i$a === void 0 ? void 0 : _this$actionLinks$i$a.id) == _actionId) {
        return this.actionLinks[i];
      }
    }
    return null;
  }
  /**
   * Returns all actions associated to the object tree, grouped by type.
   *
   * @param {function} _test gets an egwActionObject and should return, whether the
   *    actions of this object are added to the result. Defaults to an "always true"
   *    function.
   * @param {object} _groups is an internally used parameter, may be omitted.
   */

  getActionImplementationGroups(_test, _groups) {
    // If the _groups parameter hasn't been given preset it to an empty object
    // (associative array).
    if (typeof _groups == "undefined") _groups = {};
    if (typeof _test == "undefined") _test = function _test(_obj) {
      return true;
    };
    this.actionLinks.forEach(item => {
      var action = item.actionObj;
      if (typeof action != "undefined" && _test(this)) {
        if (typeof _groups[action.type] == "undefined") {
          _groups[action.type] = [];
        }
        _groups[action.type].push({
          "object": this,
          "link": item
        });
      }
    });

    // Recursively add the actions of the children to the result (as _groups is
    // an object, only the reference is passed).
    this.children.forEach(item => {
      item.getActionImplementationGroups(_test, _groups);
    });
    return _groups;
  }
  /**
   * Check if user tries to get dragOut action
   *
   * keys for dragOut:
   *    -Mac: Command + Shift
   *    -Others: Alt + Shift
   *
   * @param {event} _event
   * @return {boolean} return true if Alt+Shift keys and left mouse click are pressed, otherwise false
   */

  isDragOut(_event) {
    return (_event.altKey || _event.metaKey) && _event.shiftKey && _event.which == 1;
  }
  /**
   * Check if user tries to get selection action
   *
   * Keys for selection:
   *    -Mac: Command key
   *    -Others: Ctrl key
   *
   * @param {type} _event
   * @returns {Boolean} return true if left mouse click and Ctrl/Alt key are pressed, otherwise false
   */

  isSelection(_event) {
    return !_event.shiftKey && _event.which == 1 && (_event.metaKey || _event.ctrlKey || _event.altKey);
  }
}

/**
 * EGroupware egw_action framework - egw action framework
 *
 * @link https://www.egroupware.org
 * @author Andreas Stöckel <as@stylite.de>
 * @copyright 2011 by Andreas Stöckel
 * @license http://opensource.org/licenses/gpl-license.php GPL - GNU General Public License
 * @package egw_action
 */

/**
 * The egwActionObjectManager is a dummy class which only contains a dummy
 * AOI. It may be used as root object or as object containers.
 *
 * @param {string} _id
 * @param {string} _manager
 * @return {EgwActionObjectManager}
 */
class EgwActionObjectManager extends EgwActionObject {
  constructor(_id, _manager) {
    var aoi = new egwActionObjectInterface();
    //const ao = new egwActionObject(_id, null, aoi, _manager, EGW_AO_FLAG_IS_CONTAINER)
    super(_id, null, aoi, _manager, EGW_AO_FLAG_IS_CONTAINER);
    this.triggerCallback = function () {
      return false;
    };
  }
}

function _defineProperty$2r(e, r, t) { return (r = _toPropertyKey$2q(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2q(t) { var i = _toPrimitive$2q(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2q(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * The egwDragAction class overwrites the egwAction class and adds the new
 * "dragType" property. The "onExecute" event of the drag action will be called
 * whenever dragging starts. The onExecute JS handler should return the
 * drag-drop helper object - otherwise a default helper will be generated.
 */
class EgwDragAction extends EgwAction {
  set_dragType(_value) {
    this.dragType = _value;
  }

  /**
   * @param {EgwAction} parent
   * @param {string} _id
   * @param {string} _caption
   * @param {string} _iconUrl
   * @param {(string|function)} _onExecute
   * @param {bool} _allowOnMultiple
   */
  constructor(parent, _id, _caption, _iconUrl, _onExecute, _allowOnMultiple) {
    super(parent, _id, _caption, _iconUrl, _onExecute, _allowOnMultiple);
    _defineProperty$2r(this, "dragType", "default");
    this.type = "drag";
    this.hideOnDisabled = true;
  }
}

function _defineProperty$2q(e, r, t) { return (r = _toPropertyKey$2p(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2p(t) { var i = _toPrimitive$2p(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2p(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class EgwDragActionImplementation {
  constructor() {
    _defineProperty$2q(this, "type", "drag");
    _defineProperty$2q(this, "helper", null);
    _defineProperty$2q(this, "ddTypes", []);
    _defineProperty$2q(this, "selected", []);
    _defineProperty$2q(this, "defaultDDHelper", _selected => {
      var _selected$, _selected$0$_context;
      // Table containing clone of rows
      var table = document.createElement("table");
      table.classList.add('egwGridView_grid', 'et2_egw_action_ddHelper_row');
      // tr element to use as last row to show 'more ...' label
      var moreRow = document.createElement('tr');
      moreRow.classList.add('et2_egw_action_ddHelper_moreRow');
      // Main div helper container
      var div = document.createElement("div");
      div.append(table);
      var rows = [];
      // Maximum number of rows to show
      var maxRows = 3;
      // item label
      var itemLabel = egw$1.lang(egw$1.link_get_registry(egw$1.app_name(), _selected.length > 1 ? 'entries' : 'entry') || egw$1.app_name());
      var index = 0;

      // Take select all into account when counting number of rows, because they may not be
      // in _selected object
      var pseudoNumRows = (_selected$ = _selected[0]) !== null && _selected$ !== void 0 && (_selected$ = _selected$._context) !== null && _selected$ !== void 0 && (_selected$ = _selected$._selectionMgr) !== null && _selected$ !== void 0 && _selected$._selectAll ? (_selected$0$_context = _selected[0]._context) === null || _selected$0$_context === void 0 || (_selected$0$_context = _selected$0$_context._selectionMgr) === null || _selected$0$_context === void 0 ? void 0 : _selected$0$_context._total : _selected.length;

      // Clone nodes but use copy webComponent properties
      var carefulClone = function carefulClone(node) {
        var skip_text = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
        // Don't clone text nodes, it causes duplication in et2-description
        if (skip_text && node.nodeType == node.TEXT_NODE) {
          return;
        }
        var clone = node.cloneNode();
        var widget_class = window.customElements.get(clone.localName);
        var properties = widget_class ? widget_class.properties : [];
        for (var key in properties) {
          clone[key] = node[key];
        }
        // Children
        node.childNodes.forEach(c => {
          // Don't clone text in et2-description, it causes duplication
          var child = carefulClone(c, skip_text || ["ET2-DESCRIPTION"].indexOf(c.tagName) != -1);
          if (child) {
            clone.appendChild(child);
          }
        });
        if (widget_class) {
          clone.requestUpdate();
        }
        return clone;
      };
      for (var egwActionObject of _selected) {
        var rowNode = egwActionObject.iface.getDOMNode();
        if (egwActionObject._context && egwActionObject._context instanceof HTMLElement) {
          rowNode = egwActionObject._context;
        }
        var row = carefulClone(rowNode);
        if (row) {
          rows.push(row);
          table.append(row);
        }
        index++;
        if (index == maxRows) {
          // Label to show number of items
          var spanCnt = document.createElement('span');
          spanCnt.classList.add('et2_egw_action_ddHelper_itemsCnt');
          div.append(spanCnt);
          spanCnt.textContent = pseudoNumRows + ' ' + itemLabel;
          // Number of not shown rows
          var restRows = pseudoNumRows - maxRows;
          if (restRows > 0) {
            moreRow.textContent = egw$1.lang("".concat(pseudoNumRows - maxRows, " more ").concat(itemLabel, " selected ..."));
          }
          table.append(moreRow);
          break;
        }
      }
      var text = document.createElement('div');
      text.classList.add('et2_egw_action_ddHelper_tip');
      div.append(text);

      // Add notice of Ctrl key, if supported
      if ('draggable' in document.createElement('span') && navigator && navigator.userAgent.indexOf('Chrome') >= 0 && egw$1.app_name() == 'filemanager')
        // currently only filemanager supports drag out
        {
          if (rows.length == 1) {
            text.textContent = egw$1.lang('You may drag file out to your desktop', itemLabel);
          } else {
            text.textContent = egw$1.lang('Note: If you drag out these selected rows to desktop only the first selected row will be downloaded.', itemLabel);
          }
        }
      // Final html DOM return as helper structure
      return div;
    });
    _defineProperty$2q(this, "registerAction", (_aoi, _callback, _context) => {
      var node = _aoi.getDOMNode() && _aoi.getDOMNode()[0] ? _aoi.getDOMNode()[0] : _aoi.getDOMNode();
      if (node) {
        if (typeof _aoi.handlers == "undefined") {
          _aoi.handlers = {};
        }
        if (typeof _aoi.handlers[this.type] == "undefined") {
          _aoi.handlers[this.type] = [];
        }

        // Prevent selection
        node.onselectstart = function () {
          return false;
        };
        if (!(window.FileReader && 'draggable' in document.createElement('span'))) {
          // No DnD support
          return;
        }

        // It shouldn't be so hard to get the action...
        var action = null;
        var groups = _context.getActionImplementationGroups();
        if (!groups.drag) {
          return;
        }
        if (_aoi.handlers[this.type].length !== 0) {
          // Already bound
          return;
        }

        // Bind mouse handlers
        //et2_dataview_view_aoi binds mousedown event in et2_dataview_rowAOI to "egwPreventSelect" function from egw_action_common via jQuery.mousedown
        //jQuery(node).off("mousedown",egwPreventSelect)
        //et2_dataview_view_aoi binds mousedown event in et2_dataview_rowAOI to "egwPreventSelect" function from egw_action_common via addEventListener
        //node.removeEventListener("mousedown",egwPreventSelect)
        var mousedown = event => {
          if (_context.isSelection(event)) {
            node.setAttribute("draggable", false);
          } else if (event.which != 3) {
            document.getSelection().removeAllRanges();
          }
        };
        node.addEventListener("mousedown", mousedown);
        _aoi.handlers[this.type].push({
          type: 'mousedown',
          listener: mousedown
        });
        var mouseup = event => {
          node.setAttribute("draggable", true);

          // Set cursor back to auto. Seems FF can't handle cursor reversion
          document.body.style.cursor = 'auto';
        };
        node.addEventListener("mouseup", mouseup);
        _aoi.handlers[this.type].push({
          type: 'mousedown',
          listener: mousedown
        });
        node.setAttribute('draggable', true);
        var ai = this;
        var dragstart = function dragstart(event) {
          var dragActionObject = _context;
          if (this.findActionTarget) {
            var _this$findActionTarge;
            dragActionObject = (_this$findActionTarge = this.findActionTarget(event).action) !== null && _this$findActionTarge !== void 0 ? _this$findActionTarge : _context;
          }

          // The helper function is called before the start function
          // is evoked. Call the given callback function. The callback
          // function will gather the selected elements and action links
          // and call the doExecuteImplementation function. This
          // will call the onExecute function of the first action
          // in order to obtain the helper object (stored in ai.helper)
          // and the multiple dragDropTypes (ai.ddTypes)
          _callback.call(dragActionObject, false, ai);

          // Stop parent elements from also starting to drag if we're nested
          if (ai.selected.length) {
            event.stopPropagation();
          }
          if (action && egw$1.app_name() == 'filemanager') {
            if (dragActionObject.isSelection(event)) {
              return;
            }

            // Get all selected
            var selected = ai.selected;

            // Set file data
            for (var i = 0; i < 1; i++) {
              var d = selected[i].data || egw$1.dataGetUIDdata(selected[i].id).data || {};
              if (d && d.mime && d.download_url) {
                var url = d.download_url;

                // NEED an absolute URL
                if (url[0] == '/') url = egw$1.link(url);
                // egw.link adds the webserver, but that might not be an absolute URL - try again
                if (url[0] == '/') url = window.location.origin + url;
                event.dataTransfer.setData("DownloadURL", d.mime + ':' + d.name + ':' + url);
              }
            }
            event.dataTransfer.effectAllowed = 'copy';
            if (event.dataTransfer.types.length == 0) {
              // No file data? Abort: drag does nothing
              event.preventDefault();
              return;
            }
          } else {
            event.dataTransfer.effectAllowed = 'linkMove';
          }
          var data = {
            ddTypes: ai.ddTypes,
            selected: ai.selected.map(item => {
              return {
                id: item.id
              };
            })
          };
          if (!ai.helper) {
            ai.helper = ai.defaultDDHelper(ai.selected);
          }
          // Add a basic class to the helper in order to standardize the background layout
          ai.helper.classList.add('et2_egw_action_ddHelper', 'ui-draggable-dragging');
          document.body.append(ai.helper);

          // Set a dragging state
          ai.selected.forEach(item => {
            var _item$iface;
            (_item$iface = item.iface) === null || _item$iface === void 0 || _item$iface.setState(ai.selected[0].iface.getState() | EGW_AO_STATE_DRAGGING);
          });
          this.classList.add('drag--moving');
          event.dataTransfer.setData('application/json', JSON.stringify(data));

          // Wait for any webComponents to finish
          var wait = [];
          var webComponents = [];
          var check = element => {
            if (typeof element.updateComplete !== "undefined") {
              webComponents.push(element);
              element.requestUpdate();
              wait.push(element.updateComplete);
            }
            element.childNodes.forEach(child => check(child));
          };
          check(ai.helper);
          // Clumsily force widget update, since we can't do it async
          Promise.all(wait).then(() => {
            wait = [];
            webComponents.forEach(e => wait.push(e.updateComplete));
            Promise.all(wait).then(() => {
              event.dataTransfer.setDragImage(ai.helper, 12, 12);
            });
          });
          this.setAttribute('data-egwActionObjID', JSON.stringify(data.selected));
        };
        var dragend = _ => {
          var helper = document.querySelector('.et2_egw_action_ddHelper');
          if (helper) helper.remove();
          var draggable = document.querySelector('.drag--moving');
          if (draggable) draggable.classList.remove('drag--moving');
          // cleanup drop hover class from all other DOMs if there's still anything left
          Array.from(document.getElementsByClassName('et2dropzone drop-hover')).forEach(_i => {
            _i.classList.remove('drop-hover');
          });
          // Clean up selected
          ai.selected = [];
        };

        // Drag Event listeners
        node.addEventListener('dragstart', dragstart, false);
        _aoi.handlers[this.type].push({
          type: 'dragstart',
          listener: dragstart
        });
        node.addEventListener('dragend', dragend, false);
        _aoi.handlers[this.type].push({
          type: 'dragend',
          listener: dragend
        });
        return true;
      }
      return false;
    });
    _defineProperty$2q(this, "unregisterAction", _aoi => {
      var node = _aoi.getDOMNode();
      if (node) {
        node.setAttribute('draggable', "false");
      }
      // Unregister handlers
      if (_aoi.handlers) {
        var _aoi$handlers$this$ty;
        (_aoi$handlers$this$ty = _aoi.handlers[this.type]) === null || _aoi$handlers$this$ty === void 0 || _aoi$handlers$this$ty.forEach(h => node.removeEventListener(h.type, h.listener));
        delete _aoi.handlers[this.type];
      }
      return true;
    });
    /**
     * Builds the context menu and shows it at the given position/DOM-Node.
     *
     * @param {string} _context
     * @param {array} _selected
     * @param {object} _links
     */
    _defineProperty$2q(this, "executeImplementation", (_context, _selected, _links) => {
      // Reset the helper object of the action implementation
      this.helper = null;
      var hasLink = false;

      // Store the drag-drop types
      this.ddTypes = [];
      this.selected = _selected;

      // Call the onExecute event of the first actionObject
      for (var k in _links) {
        if (_links[k].visible) {
          hasLink = true;

          // Only execute the following code if a JS function is registered
          // for the action and this is the first action link
          if (!this.helper && _links[k].actionObj.onExecute.hasHandler()) {
            this.helper = _links[k].actionObj.execute(_selected);
          }

          // Push the dragType of the associated action object onto the
          // drag type list - this allows an element to support multiple
          // drag/drop types.
          var type = Array.isArray(_links[k].actionObj.dragType) ? _links[k].actionObj.dragType : [_links[k].actionObj.dragType];
          for (var i of type) {
            if (this.ddTypes.indexOf(i) === -1) {
              this.ddTypes.push(i);
            }
          }
        }
      }
      // If no helper has been defined, create a default one
      if (!this.helper && hasLink) {
        this.helper = this.defaultDDHelper(_selected);
      }
      return true;
    });
  }
}

/**
 * @deprecated use upper case class
 */
class egwDragActionImplementation extends EgwDragActionImplementation {}
var _dragActionImpl = null;
function getDragImplementation$1() {
  if (!_dragActionImpl) {
    _dragActionImpl = new EgwDragActionImplementation();
  }
  return _dragActionImpl;
}

function _defineProperty$2p(e, r, t) { return (r = _toPropertyKey$2o(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2o(t) { var i = _toPrimitive$2o(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2o(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * The egwDropAction class overwrites the egwAction class and adds the "acceptedTypes"
 * property. This array should contain all "dragTypes" the drop action is allowed to
 *
 * @param {EgwAction} _id
 * @param {string} _handler
 * @param {string} _caption
 * @param {string} _icon
 * @param {(string|function)} _onExecute
 * @param {bool} _allowOnMultiple
 * @returns {egwDropAction}
 */
class EgwDropAction extends EgwAction {
  constructor(_id, _handler, _caption, _icon, _onExecute, _allowOnMultiple) {
    super(_id, _handler, _caption, _icon, _onExecute, _allowOnMultiple);
    _defineProperty$2p(this, "acceptedTypes", void 0);
    _defineProperty$2p(this, "order", void 0);
    _defineProperty$2p(this, "group", void 0);
    this.type = "drop";
    this.acceptedTypes = ["default"];
    this.canHaveChildren = ["drag", "popup"];
    this["default"] = false;
    this.order = 0;
    this.group = 0;
  }
  set_default(_value) {
    this["default"] = _value;
  }
  set_order(_value) {
    this.order = _value;
  }
  set_group(_value) {
    this.group = _value;
  }
  /**
   * The acceptType property allows strings as well as arrays - strings are
   * automatically included in an array.
   *
   * @param {(string|array)} _value
   */
  set_acceptedTypes(_value) {
    if (_value instanceof Array) {
      this.acceptedTypes = _value;
    } else {
      this.acceptedTypes = [_value];
    }
  }
}

var es_array_sort = {};

'use strict';
var tryToString = tryToString$4;

var $TypeError$1 = TypeError;

var deletePropertyOrThrow$1 = function (O, P) {
  if (!delete O[P]) throw $TypeError$1('Cannot delete property ' + tryToString(P) + ' of ' + tryToString(O));
};

var arraySlice$1 = arraySliceSimple;

var floor$3 = Math.floor;

var mergeSort = function (array, comparefn) {
  var length = array.length;
  var middle = floor$3(length / 2);
  return length < 8 ? insertionSort(array, comparefn) : merge$2(
    array,
    mergeSort(arraySlice$1(array, 0, middle), comparefn),
    mergeSort(arraySlice$1(array, middle), comparefn),
    comparefn
  );
};

var insertionSort = function (array, comparefn) {
  var length = array.length;
  var i = 1;
  var element, j;

  while (i < length) {
    j = i;
    element = array[i];
    while (j && comparefn(array[j - 1], element) > 0) {
      array[j] = array[--j];
    }
    if (j !== i++) array[j] = element;
  } return array;
};

var merge$2 = function (array, left, right, comparefn) {
  var llength = left.length;
  var rlength = right.length;
  var lindex = 0;
  var rindex = 0;

  while (lindex < llength || rindex < rlength) {
    array[lindex + rindex] = (lindex < llength && rindex < rlength)
      ? comparefn(left[lindex], right[rindex]) <= 0 ? left[lindex++] : right[rindex++]
      : lindex < llength ? left[lindex++] : right[rindex++];
  } return array;
};

var arraySort$1 = mergeSort;

var userAgent$3 = engineUserAgent;

var firefox = userAgent$3.match(/firefox\/(\d+)/i);

var engineFfVersion = !!firefox && +firefox[1];

var UA = engineUserAgent;

var engineIsIeOrEdge = /MSIE|Trident/.test(UA);

var userAgent$2 = engineUserAgent;

var webkit = userAgent$2.match(/AppleWebKit\/(\d+)\./);

var engineWebkitVersion = !!webkit && +webkit[1];

'use strict';
var $$d = _export;
var uncurryThis$6 = functionUncurryThis;
var aCallable$1 = aCallable$a;
var toObject$1 = toObject$6;
var lengthOfArrayLike$1 = lengthOfArrayLike$5;
var deletePropertyOrThrow = deletePropertyOrThrow$1;
var toString$6 = toString$b;
var fails$2 = fails$e;
var internalSort = arraySort$1;
var arrayMethodIsStrict = arrayMethodIsStrict$2;
var FF = engineFfVersion;
var IE_OR_EDGE = engineIsIeOrEdge;
var V8 = engineV8Version;
var WEBKIT = engineWebkitVersion;

var test = [];
var nativeSort = uncurryThis$6(test.sort);
var push$3 = uncurryThis$6(test.push);

// IE8-
var FAILS_ON_UNDEFINED = fails$2(function () {
  test.sort(undefined);
});
// V8 bug
var FAILS_ON_NULL = fails$2(function () {
  test.sort(null);
});
// Old WebKit
var STRICT_METHOD = arrayMethodIsStrict('sort');

var STABLE_SORT = !fails$2(function () {
  // feature detection can be too slow, so check engines versions
  if (V8) return V8 < 70;
  if (FF && FF > 3) return;
  if (IE_OR_EDGE) return true;
  if (WEBKIT) return WEBKIT < 603;

  var result = '';
  var code, chr, value, index;

  // generate an array with more 512 elements (Chakra and old V8 fails only in this case)
  for (code = 65; code < 76; code++) {
    chr = String.fromCharCode(code);

    switch (code) {
      case 66: case 69: case 70: case 72: value = 3; break;
      case 68: case 71: value = 4; break;
      default: value = 2;
    }

    for (index = 0; index < 47; index++) {
      test.push({ k: chr + index, v: value });
    }
  }

  test.sort(function (a, b) { return b.v - a.v; });

  for (index = 0; index < test.length; index++) {
    chr = test[index].k.charAt(0);
    if (result.charAt(result.length - 1) !== chr) result += chr;
  }

  return result !== 'DGBEFHACIJK';
});

var FORCED = FAILS_ON_UNDEFINED || !FAILS_ON_NULL || !STRICT_METHOD || !STABLE_SORT;

var getSortCompare = function (comparefn) {
  return function (x, y) {
    if (y === undefined) return -1;
    if (x === undefined) return 1;
    if (comparefn !== undefined) return +comparefn(x, y) || 0;
    return toString$6(x) > toString$6(y) ? 1 : -1;
  };
};

// `Array.prototype.sort` method
// https://tc39.es/ecma262/#sec-array.prototype.sort
$$d({ target: 'Array', proto: true, forced: FORCED }, {
  sort: function sort(comparefn) {
    if (comparefn !== undefined) aCallable$1(comparefn);

    var array = toObject$1(this);

    if (STABLE_SORT) return comparefn === undefined ? nativeSort(array) : nativeSort(array, comparefn);

    var items = [];
    var arrayLength = lengthOfArrayLike$1(array);
    var itemsLength, index;

    for (index = 0; index < arrayLength; index++) {
      if (index in array) push$3(items, array[index]);
    }

    internalSort(items, getSortCompare(comparefn));

    itemsLength = lengthOfArrayLike$1(items);
    index = 0;

    while (index < itemsLength) array[index] = items[index++];
    while (index < arrayLength) deletePropertyOrThrow(array, index++);

    return array;
  }
});

var esnext_string_replaceAll = {};

var es_string_replaceAll = {};

'use strict';
var $$c = _export;
var call$5 = functionCall;
var uncurryThis$5 = functionUncurryThis;
var requireObjectCoercible$3 = requireObjectCoercible$7;
var isCallable$2 = isCallable$e;
var isNullOrUndefined$1 = isNullOrUndefined$6;
var isRegExp = isRegexp;
var toString$5 = toString$b;
var getMethod$1 = getMethod$6;
var getRegExpFlags = regexpGetFlags;
var getSubstitution = getSubstitution$2;
var wellKnownSymbol$2 = wellKnownSymbol$f;
var IS_PURE$3 = isPure;

var REPLACE = wellKnownSymbol$2('replace');
var $TypeError = TypeError;
var indexOf = uncurryThis$5(''.indexOf);
var replace$3 = uncurryThis$5(''.replace);
var stringSlice$3 = uncurryThis$5(''.slice);
var max$1 = Math.max;

var stringIndexOf = function (string, searchValue, fromIndex) {
  if (fromIndex > string.length) return -1;
  if (searchValue === '') return fromIndex;
  return indexOf(string, searchValue, fromIndex);
};

// `String.prototype.replaceAll` method
// https://tc39.es/ecma262/#sec-string.prototype.replaceall
$$c({ target: 'String', proto: true }, {
  replaceAll: function replaceAll(searchValue, replaceValue) {
    var O = requireObjectCoercible$3(this);
    var IS_REG_EXP, flags, replacer, string, searchString, functionalReplace, searchLength, advanceBy, replacement;
    var position = 0;
    var endOfLastMatch = 0;
    var result = '';
    if (!isNullOrUndefined$1(searchValue)) {
      IS_REG_EXP = isRegExp(searchValue);
      if (IS_REG_EXP) {
        flags = toString$5(requireObjectCoercible$3(getRegExpFlags(searchValue)));
        if (!~indexOf(flags, 'g')) throw $TypeError('`.replaceAll` does not allow non-global regexes');
      }
      replacer = getMethod$1(searchValue, REPLACE);
      if (replacer) {
        return call$5(replacer, searchValue, O, replaceValue);
      } else if (IS_PURE$3 && IS_REG_EXP) {
        return replace$3(toString$5(O), searchValue, replaceValue);
      }
    }
    string = toString$5(O);
    searchString = toString$5(searchValue);
    functionalReplace = isCallable$2(replaceValue);
    if (!functionalReplace) replaceValue = toString$5(replaceValue);
    searchLength = searchString.length;
    advanceBy = max$1(1, searchLength);
    position = stringIndexOf(string, searchString, 0);
    while (position !== -1) {
      replacement = functionalReplace
        ? toString$5(replaceValue(searchString, position, string))
        : getSubstitution(searchString, string, position, [], undefined, replaceValue);
      result += stringSlice$3(string, endOfLastMatch, position) + replacement;
      endOfLastMatch = position + searchLength;
      position = stringIndexOf(string, searchString, position + advanceBy);
    }
    if (endOfLastMatch < string.length) {
      result += stringSlice$3(string, endOfLastMatch);
    }
    return result;
  }
});

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const e$o=e=>n=>"function"==typeof n?((e,n)=>(customElements.define(e,n),n))(e,n):((e,n)=>{const{kind:t,elements:s}=n;return {kind:t,elements:s,finisher(n){customElements.define(e,n);}}})(e,n);

/**
 * @license
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */const{I:l$b}=j$3,i$e=o=>null===o||"object"!=typeof o&&"function"!=typeof o,n$j={HTML:1,SVG:2},t$c=(o,l)=>void 0===l?void 0!==(null==o?void 0:o._$litType$):(null==o?void 0:o._$litType$)===l,v$3=o=>{var l;return null!=(null===(l=null==o?void 0:o._$litType$)||void 0===l?void 0:l.h)},d$4=o=>void 0!==(null==o?void 0:o._$litDirective$),u$7=o=>null==o?void 0:o._$litDirective$,e$n=o=>void 0===o.strings,r$d=()=>document.createComment(""),c$9=(o,i,n)=>{var t;const v=o._$AA.parentNode,d=void 0===i?o._$AB:i._$AA;if(void 0===n){const i=v.insertBefore(r$d(),d),t=v.insertBefore(r$d(),d);n=new l$b(i,t,o,o.options);}else {const l=n._$AB.nextSibling,i=n._$AM,u=i!==o;if(u){let l;null===(t=n._$AQ)||void 0===t||t.call(n,o),n._$AM=o,void 0!==n._$AP&&(l=o._$AU)!==i._$AU&&n._$AP(l);}if(l!==d||u){let o=n._$AA;for(;o!==l;){const l=o.nextSibling;v.insertBefore(o,d),o=l;}}}return n},f$6=(o,l,i=o)=>(o._$AI(l,i),o),s$a={},a$5=(o,l=s$a)=>o._$AH=l,m$4=o=>o._$AH,p$4=o=>{var l;null===(l=o._$AP)||void 0===l||l.call(o,!1,!0);let i=o._$AA;const n=o._$AB.nextSibling;for(;i!==n;){const o=i.nextSibling;i.remove(),i=o;}},h$9=o=>{o._$AR();};

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const t$b={ATTRIBUTE:1,CHILD:2,PROPERTY:3,BOOLEAN_ATTRIBUTE:4,EVENT:5,ELEMENT:6},e$m=t=>(...e)=>({_$litDirective$:t,values:e});class i$d{constructor(t){}get _$AU(){return this._$AM._$AU}_$AT(t,e,i){this._$Ct=t,this._$AM=e,this._$Ci=i;}_$AS(t,e){return this.update(t,e)}update(t,e){return this.render(...e)}}

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */const s$9=(i,t)=>{var e,o;const r=i._$AN;if(void 0===r)return !1;for(const i of r)null===(o=(e=i)._$AO)||void 0===o||o.call(e,t,!1),s$9(i,t);return !0},o$p=i=>{let t,e;do{if(void 0===(t=i._$AM))break;e=t._$AN,e.delete(i),i=t;}while(0===(null==e?void 0:e.size))},r$c=i=>{for(let t;t=i._$AM;i=t){let e=t._$AN;if(void 0===e)t._$AN=e=new Set;else if(e.has(i))break;e.add(i),l$a(t);}};function n$i(i){void 0!==this._$AN?(o$p(this),this._$AM=i,r$c(this)):this._$AM=i;}function h$8(i,t=!1,e=0){const r=this._$AH,n=this._$AN;if(void 0!==n&&0!==n.size)if(t)if(Array.isArray(r))for(let i=e;i<r.length;i++)s$9(r[i],!1),o$p(r[i]);else null!=r&&(s$9(r,!1),o$p(r));else s$9(this,i);}const l$a=i=>{var t,s,o,r;i.type==t$b.CHILD&&(null!==(t=(o=i)._$AP)&&void 0!==t||(o._$AP=h$8),null!==(s=(r=i)._$AQ)&&void 0!==s||(r._$AQ=n$i));};class c$8 extends i$d{constructor(){super(...arguments),this._$AN=void 0;}_$AT(i,t,e){super._$AT(i,t,e),r$c(this),this.isConnected=i._$AU;}_$AO(i,t=!0){var e,r;i!==this.isConnected&&(this.isConnected=i,i?null===(e=this.reconnected)||void 0===e||e.call(this):null===(r=this.disconnected)||void 0===r||r.call(this)),t&&(s$9(this,i),o$p(this));}setValue(t){if(e$n(this._$Ct))this._$Ct._$AI(t,this);else {const i=[...this._$Ct._$AH];i[this._$Ci]=t,this._$Ct._$AI(i,this,0);}}disconnected(){}reconnected(){}}

/**
 * @license
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */const e$l=()=>new o$o;class o$o{}const h$7=new WeakMap,n$h=e$m(class extends c$8{render(t){return A$2}update(t,[s]){var e;const o=s!==this.G;return o&&void 0!==this.G&&this.ot(void 0),(o||this.rt!==this.lt)&&(this.G=s,this.dt=null===(e=t.options)||void 0===e?void 0:e.host,this.ot(this.lt=t.element)),A$2}ot(i){var t;if("function"==typeof this.G){const s=null!==(t=this.dt)&&void 0!==t?t:globalThis;let e=h$7.get(s);void 0===e&&(e=new WeakMap,h$7.set(s,e)),void 0!==e.get(this.G)&&this.G.call(this.dt,void 0),e.set(this.G,i),void 0!==i&&this.G.call(this.dt,i);}else this.G.value=i;}get rt(){var i,t,s;return "function"==typeof this.G?null===(t=h$7.get(null!==(i=this.dt)&&void 0!==i?i:globalThis))||void 0===t?void 0:t.get(this.G):null===(s=this.G)||void 0===s?void 0:s.value}disconnected(){this.rt===this.lt&&this.ot(void 0);}reconnected(){this.ot(this.lt);}});

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const u$6=(e,s,t)=>{const r=new Map;for(let l=s;l<=t;l++)r.set(e[l],l);return r},c$7=e$m(class extends i$d{constructor(e){if(super(e),e.type!==t$b.CHILD)throw Error("repeat() can only be used in text expressions")}ct(e,s,t){let r;void 0===t?t=s:void 0!==s&&(r=s);const l=[],o=[];let i=0;for(const s of e)l[i]=r?r(s,i):i,o[i]=t(s,i),i++;return {values:o,keys:l}}render(e,s,t){return this.ct(e,s,t).values}update(s,[t,r,c]){var d;const a=m$4(s),{values:p,keys:v}=this.ct(t,r,c);if(!Array.isArray(a))return this.ut=v,p;const h=null!==(d=this.ut)&&void 0!==d?d:this.ut=[],m=[];let y,x,j=0,k=a.length-1,w=0,A=p.length-1;for(;j<=k&&w<=A;)if(null===a[j])j++;else if(null===a[k])k--;else if(h[j]===v[w])m[w]=f$6(a[j],p[w]),j++,w++;else if(h[k]===v[A])m[A]=f$6(a[k],p[A]),k--,A--;else if(h[j]===v[A])m[A]=f$6(a[j],p[A]),c$9(s,m[A+1],a[j]),j++,A--;else if(h[k]===v[w])m[w]=f$6(a[k],p[w]),c$9(s,a[j],a[k]),k--,w++;else if(void 0===y&&(y=u$6(v,w,A),x=u$6(h,j,k)),y.has(h[j]))if(y.has(h[k])){const e=x.get(v[w]),t=void 0!==e?a[e]:null;if(null===t){const e=c$9(s,a[j]);f$6(e,p[w]),m[w]=e;}else m[w]=f$6(t,p[w]),c$9(s,a[j],t),a[e]=null;w++;}else p$4(a[k]),k--;else p$4(a[j]),j++;for(;w<=A;){const e=c$9(s,m[A+1]);f$6(e,p[w]),m[w++]=e;}for(;j<=k;){const e=a[j++];null!==e&&p$4(e);}return this.ut=v,a$5(s,m),T$2}});

/**
 * @license
 * Copyright 2018 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */const o$n=e$m(class extends i$d{constructor(t){var i;if(super(t),t.type!==t$b.ATTRIBUTE||"class"!==t.name||(null===(i=t.strings)||void 0===i?void 0:i.length)>2)throw Error("`classMap()` can only be used in the `class` attribute and must be the only part in the attribute.")}render(t){return " "+Object.keys(t).filter((i=>t[i])).join(" ")+" "}update(i,[s]){var r,o;if(void 0===this.it){this.it=new Set,void 0!==i.strings&&(this.nt=new Set(i.strings.join(" ").split(/\s/).filter((t=>""!==t))));for(const t in s)s[t]&&!(null===(r=this.nt)||void 0===r?void 0:r.has(t))&&this.it.add(t);return this.render(s)}const e=i.element.classList;this.it.forEach((t=>{t in s||(e.remove(t),this.it.delete(t));}));for(const t in s){const i=!!s[t];i===this.it.has(t)||(null===(o=this.nt)||void 0===o?void 0:o.has(t))||(i?(e.add(t),this.it.add(t)):(e.remove(t),this.it.delete(t)));}return T$2}});

/**
 * @license
 * Copyright 2021 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const t$a=async(t,s)=>{for await(const i of t)if(!1===await s(i))return};class s$8{constructor(t){this.G=t;}disconnect(){this.G=void 0;}reconnect(t){this.G=t;}deref(){return this.G}}class i$c{constructor(){this.Y=void 0,this.Z=void 0;}get(){return this.Y}pause(){var t;null!==(t=this.Y)&&void 0!==t||(this.Y=new Promise((t=>this.Z=t)));}resume(){var t;null===(t=this.Z)||void 0===t||t.call(this),this.Y=this.Z=void 0;}}

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */const n$g=t=>!i$e(t)&&"function"==typeof t.then,h$6=1073741823;class c$6 extends c$8{constructor(){super(...arguments),this._$C_t=h$6,this._$Cwt=[],this._$Cq=new s$8(this),this._$CK=new i$c;}render(...s){var i;return null!==(i=s.find((t=>!n$g(t))))&&void 0!==i?i:T$2}update(s,i){const r=this._$Cwt;let e=r.length;this._$Cwt=i;const o=this._$Cq,c=this._$CK;this.isConnected||this.disconnected();for(let t=0;t<i.length&&!(t>this._$C_t);t++){const s=i[t];if(!n$g(s))return this._$C_t=t,s;t<e&&s===r[t]||(this._$C_t=h$6,e=0,Promise.resolve(s).then((async t=>{for(;c.get();)await c.get();const i=o.deref();if(void 0!==i){const r=i._$Cwt.indexOf(s);r>-1&&r<i._$C_t&&(i._$C_t=r,i.setValue(t));}})));}return T$2}disconnected(){this._$Cq.disconnect(),this._$CK.pause();}reconnected(){this._$Cq.reconnect(this),this._$CK.resume();}}const m$3=e$m(c$6);

var _dec$K, _class$O, _templateObject$1D, _templateObject2$$, _templateObject3$J, _templateObject4$z, _templateObject5$r, _templateObject6$l, _templateObject7$h, _templateObject8$b, _templateObject9$8;
function asyncGeneratorStep$E(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator$E(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep$E(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep$E(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function _taggedTemplateLiteral$1D(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
function _defineProperty$2o(e, r, t) { return (r = _toPropertyKey$2n(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2n(t) { var i = _toPrimitive$2n(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2n(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var EgwMenuShoelace = (_dec$K = e$o("egw-menu-shoelace"), _dec$K(_class$O = class EgwMenuShoelace extends s$b {
  static get styles() {
    return [bootstrapIcons, i$h(_templateObject$1D || (_templateObject$1D = _taggedTemplateLiteral$1D(["\n\t\t\t\t:host {\n\t\t\t\t\tdisplay: block;\n\t\t\t\t}\n\n\t\t\t\t.default-item::part(label) {\n\t\t\t\t\tfont-weight: var(--sl-font-weight-bold, bold);\n\t\t\t\t}\n\n\t\t\t\tsl-menu {\n\t\t\t\t\tbox-shadow: var(--sl-shadow-x-large);\n\t\t\t\t}\n\n\t\t\t\t/* sl-menu-item:host overrides display */\n\n\t\t\t\tsl-menu-item[hidden], sl-divider[hidden] {\n\t\t\t\t\tdisplay: none !important;\n\t\t\t\t}\n\n\t\t\t\tsl-menu-item::part(base) {\n\t\t\t\t\theight: 1.7em;\n\t\t\t\t\tline-height: var(--sl-line-height-dense);\n\t\t\t\t\talign-items: center;\n\t\t\t\t\tpadding: 0;\n\t\t\t\t}\n\n\t\t\t\tsl-menu-item::part(prefix) {\n\t\t\t\t\tmin-width: var(--sl-spacing-2x-large);\n\t\t\t\t}\n\n\t\t\t\t/* Customise checkbox menuitem */\n\n\t\t\t\tsl-menu-item[type=\"checkbox\"]::part(checked-icon) {\n\t\t\t\t\tvisibility: hidden;\n\t\t\t\t}\n\n\t\t\t\tsl-menu-item[type=\"checkbox\"]:not([checked])::part(checked-icon) {\n\t\t\t\t\tcolor: var(--sl-color-neutral-300);\n\t\t\t\t}\n\n\t\t\t\tet2-image {\n\t\t\t\t\tline-height: normal;\n\t\t\t\t\twidth: 1.3em;\n\t\t\t\t}\n\t\t\t\tet2-image::before {\n\t\t\t\t\tfont-size: 1.3em; /*make bi icons same size as et2-image img*/\n\t\t\t\t}\n\t\t\t"])))];
  }
  get menu() {
    var _this$shadowRoot;
    return (_this$shadowRoot = this.shadowRoot) === null || _this$shadowRoot === void 0 ? void 0 : _this$shadowRoot.querySelector("sl-menu");
  }
  constructor(_structure) {
    super();
    _defineProperty$2o(this, "structure", []);
    _defineProperty$2o(this, "popup", null);
    _defineProperty$2o(this, "hideCallback", null);
    this.structure = _structure;
    this.handleDocumentClick = this.handleDocumentClick.bind(this);
    this.handleKeypress = this.handleKeypress.bind(this);
  }
  connectedCallback() {
    super.connectedCallback();
    document.addEventListener("click", this.handleDocumentClick);
    document.addEventListener("keydown", this.handleKeypress);
  }
  disconnectedCallback() {
    super.disconnectedCallback();
    document.removeEventListener("click", this.handleDocumentClick);
    document.removeEventListener("keydown", this.handleKeypress);
    if (this.popup) {
      this.popup.remove();
      this.popup = null;
    }
    if (this.hideCallback) {
      this.hideCallback.call();
    }
  }
  showAt(_x, _y, _onHide) {
    this.hideCallback = _onHide;
    if (this.popup == null) {
      this.popup = Object.assign(document.createElement("sl-popup"), {
        placement: "right-start",
        autoSize: "vertical",
        flip: true,
        shift: true
      });
      this.popup.append(this);
      this.popup.classList.add("egw_menu");
      document.body.append(this.popup);
    }

    // Open where instructed
    var menu = this;
    this.popup.anchor = {
      getBoundingClientRect() {
        return {
          x: _x,
          y: _y,
          width: 0,
          // placement="right-start" only works well with 0, not menu.clientWidth,
          height: menu.clientHeight,
          top: _y,
          left: _x,
          right: _x,
          bottom: _y
        };
      }
    };
    this.popup.active = true;
    Promise.all([this.updateComplete, this.popup.updateComplete]).then(() => {
      var _this$menu$querySelec;
      // Causes scroll issues if we don't position
      this.popup.popup.style = "top: 0px";
      (_this$menu$querySelec = this.menu.querySelector('sl-menu-item')) === null || _this$menu$querySelec === void 0 || _this$menu$querySelec.focus();
    });
  }

  /**
   * Update the menu items with current disabled / visible settings
   *
   * @param _links
   */
  applyContext(_links, _selected, _target) {
    // Reset & hide all, in case some actions were not included in links
    this.menu.querySelectorAll("sl-menu-item").forEach(i => i.disabled = i.hidden = true);
    this.menu.querySelectorAll("sl-divider").forEach(i => i.hidden = false);
    Object.keys(_links).forEach(actionId => {
      // Take the last one if there's more than one with the same ID as a work-around to automatic drag actions getting added twice
      // in different places in some cases (nextmatch_controller vs EgwPopupActionImplementation)
      var menuItem = Array.from(this.shadowRoot.querySelectorAll("[data-action-id='" + actionId + "']")).pop();
      if (!menuItem) {
        return;
      }
      menuItem.disabled = !_links[actionId].enabled;
      menuItem.hidden = !_links[actionId].visible;
      if (menuItem.type == "checkbox") {
        var _links$actionId$actio;
        menuItem.checked = (_links$actionId$actio = _links[actionId].actionObj.checked) !== null && _links$actionId$actio !== void 0 ? _links$actionId$actio : false;
      }
    });

    // Hide dividers before empty sections
    try {
      this.menu.querySelectorAll("sl-divider:not(:has( + sl-menu-item:not([hidden])))").forEach(i => i.hidden = true);
    } catch (e) {
      console.log("It appears you are using an older browser version, please consider updating");
    }
    // Copy caption changes
    var osClipboard;
    if (_links.egw_os_clipboard && (osClipboard = this.shadowRoot.querySelector("[data-action-id='egw_os_clipboard']"))) {
      osClipboard.innerText = _links.egw_os_clipboard.actionObj.caption;
    }
  }
  hide() {
    if (this.popup) {
      this.popup.active = false;
    }
    if (this.hideCallback) {
      this.hideCallback.call();
    }
  }
  handleSelect(event) {
    // If not open, skip
    if (!this.popup) {
      return;
    }
    if (event.detail.item.value) {
      var item = event.detail.item.value;
      if (item.checkbox) {
        // Update our internal data
        item.data.checked = item.checked = event.detail.item.checked;

        // Update image of a checkbox item to be toggle on or off
        // this happens by requesting an update because item.checked has changed
        event.detail.item.querySelector('et2-image').src = item.checked ? "toggle-on" : "toggle-off";
        return;
      }
      if (typeof item.onClick == "function") {
        this.hide();
        item.onClick.call(event.detail.item, item, event);
      }
    }
  }
  handleCheckboxClick(event) {
    var check = event.target.closest("sl-menu-item");
    if (!check || check.parentElement == this) {
      return;
    }

    // Make sure sub-menu does not close
    event.stopPropagation();

    // Normal select event
    check.checked = !check.checked;
    check.dispatchEvent(new CustomEvent("sl-select", {
      bubbles: true,
      cancelable: false,
      composed: true,
      detail: {
        item: check
      }
    }));
  }
  handleDocumentClick(event) {
    if (!event.composedPath().includes(this)) {
      this.hide();
    }
  }
  handleKeypress(event) {
    if (event.key == "Escape") {
      event.preventDefault();
      event.stopPropagation();
      this.hide();
    }
  }
  itemTemplate(item) {
    if (item.caption == "-") {
      return x$2(_templateObject2$$ || (_templateObject2$$ = _taggedTemplateLiteral$1D(["\n                <sl-divider></sl-divider>"])));
    }

    //if we have a checkbox, change the icon to be a toggle slider. Either on or off
    if (item.checkbox) {
      item.iconUrl = item.checked ? "toggle-on" : "toggle-off";
    }
    var id = CSS.escape(item.id);

    // Defer loading of sub-menus because the forced repaint takes too long with lots of children
    var childPromise = Promise.resolve(x$2(_templateObject3$J || (_templateObject3$J = _taggedTemplateLiteral$1D([""]))));
    if (item.children.length > 0) {
      childPromise = new Promise(resolve => {
        setTimeout(() => {
          resolve(x$2(_templateObject4$z || (_templateObject4$z = _taggedTemplateLiteral$1D(["\n                        <sl-menu slot=\"submenu\">\n                        ", "\n                        </sl-menu>\n\t\t\t\t\t"])), c$7(item.children, i => this.itemTemplate(i))));
        }, item.children.length);
      });
    }
    // Remove the loading attribute when sub-menu is done
    var updateLoading = /*#__PURE__*/function () {
      var _ref = _asyncToGenerator$E(function* (element) {
        if (item.children.length == 0 || !element) {
          return;
        }
        // Menu item was rendered, but give children a chance to render
        setTimeout( /*#__PURE__*/_asyncToGenerator$E(function* () {
          // Wait for child creation
          yield childPromise;
          // Wait for child render
          yield Promise.all(Array.from(element.querySelectorAll('sl-menu-item')).map(e => e.updateComplete));
          // No longer loading
          setTimeout(() => {
            element.loading = false;
          }, 100);
        }));
      });
      return function updateLoading(_x2) {
        return _ref.apply(this, arguments);
      };
    }();
    return x$2(_templateObject5$r || (_templateObject5$r = _taggedTemplateLiteral$1D(["\n            <sl-menu-item\n                    class=", "\n                    id=", "\n                    type=\"", "\"\n                    data-action-id=\"", "\"\n                    ?checked=", "\n                    ?disabled=", "\n                    ?loading=", "\n                    .value=", "\n                    @click=", "\n                    ", "\n            >\n                ", "\n\t\t\t\t<span style=\"color: ", "\">", "</span>\n                ", "\n                ", "\n            </sl-menu-item>\n\t\t"])), o$n({
      "default-item": item.default
    }), id, item.checkbox ? "checkbox" : "normal", item.id, item.checkbox && item.checked, !item.enabled, item.children.length > 0, item, item.checkbox ? this.handleCheckboxClick : A$2, n$h(updateLoading), item.iconUrl ? x$2(_templateObject6$l || (_templateObject6$l = _taggedTemplateLiteral$1D(["\n                    <et2-image slot=\"prefix\" src=\"", "\"></et2-image>"])), item.iconUrl) : A$2, item.color || A$2, item.caption, item.shortcutCaption ? x$2(_templateObject7$h || (_templateObject7$h = _taggedTemplateLiteral$1D(["<span slot=\"suffix\" class=\"keyboard_shortcut\">\n\t\t\t\t\t", "\n\t\t\t\t</span>"])), item.shortcutCaption) : A$2, item.children.length == 0 ? A$2 : x$2(_templateObject8$b || (_templateObject8$b = _taggedTemplateLiteral$1D(["\n                        ", "\n                "])), m$3(childPromise)));
  }
  render() {
    return x$2(_templateObject9$8 || (_templateObject9$8 = _taggedTemplateLiteral$1D(["\n            <sl-menu\n                    @sl-select=", "\n                    @contextmenu=", "\n            >\n                ", "\n            </sl-menu>"])), this.handleSelect, e => {
      if (!e.ctrlKey) {
        e.preventDefault();
      }
    }, c$7(this.structure, i => this.itemTemplate(i)));
  }
}) || _class$O);

function _defineProperty$2n(e, r, t) { return (r = _toPropertyKey$2m(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2m(t) { var i = _toPrimitive$2m(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2m(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

//Global variable which is used to store the currently active menu so that it
//may be closed when another menu opens
var _egw_active_menu = null;

/**
 * Internal function which parses the given menu tree in _elements and adds the
 * elements to the given parent.
 */
function _egwGenMenuStructure(_elements, _parent) {
  var items = [];

  //Go through each object in the elements array
  for (var obj of _elements) {
    //Go through each key of the current object
    var item = new egwMenuItem(_parent, null);
    for (var key in obj) {
      if (key == "children" && obj[key].constructor === Array) {
        //Recursively load the children.
        item.children = _egwGenMenuStructure(obj[key], item);
      } else {
        //Directly set the other keys
        //TODO Sanity necessary checks here?
        //TODO Implement menu item getters?
        if (key == "id" || key == "caption" || key == "iconUrl" || key == "checkbox" || key == "checked" || key == "groupIndex" || key == "enabled" || key == "default" || key == "onClick" || key == "hint" || key == "shortcutCaption") {
          item['set_' + key](obj[key]);
        }
      }
    }
    items.push(item);
  }
  return items;
}

/**
 * Internal function which searches for the given ID inside an element tree.
 */
function _egwSearchMenuItem(_elements, _id) {
  for (var item1 of _elements) {
    if (item1.id === _id) return item1;
    var item = _egwSearchMenuItem(item1.children, _id);
    if (item) return item;
  }
  return null;
}

/**
 * Internal function which allows to set the onClick handler of multiple menu items
 */
function _egwSetMenuOnClick(_elements, _onClick) {
  for (var item of _elements) {
    if (item.onClick === null) {
      item.onClick = _onClick;
    }
    _egwSetMenuOnClick(item.children, _onClick);
  }
}

/**
 * replacement function for jquery trigger
 * @param selector
 * @param eventType
 */
function trigger(selector, eventType) {
  if (typeof eventType === 'string' && typeof selector[eventType] === 'function') {
    selector[eventType]();
  } else {
    var event = typeof eventType === 'string' ? new Event(eventType, {
      bubbles: true
    }) : eventType;
    selector.dispatchEvent(event);
  }
}

/**
 * Constructor for the egwMenu object. The egwMenu object is an abstract representation
 * of a context/popup menu. The actual generation of the menu can be done by
 * so-called menu implementations. Those are activated by simply including the JS file
 * of such an implementation.
 *
 * The current use implementation is "EgwShoelaceMenu.js" which is based on Shoelace.
 */
class egwMenu {
  // This is equivalent to iface in other classes and holds an egwMenuImpl
  constructor() {
    //The "items" variable contains all menu items of the menu
    _defineProperty$2n(this, "children", []);
    //The "instance" variable contains the currently opened instance. There may
    //only be one instance opened at a time.
    _defineProperty$2n(this, "instance", null);
  }
  remove() {
    var _this$instance;
    (_this$instance = this.instance) === null || _this$instance === void 0 || _this$instance.remove();
  }

  /**
   * The private _checkImpl function checks whether a menu implementation is available.
   *
   * @returns bool whether a menu implementation is available.
   */
  _checkImpl() {
    return typeof egwMenuImpl == 'function';
  }

  /**
   * Hides the menu if it is currently opened. Otherwise, nothing happens.
   */
  hide() {
    //Reset the currently active menu variable
    if (_egw_active_menu == this) _egw_active_menu = null;

    //Check whether a currently opened instance exists. If it does, close it.
    if (this.instance != null) {
      this.instance.hide();
    }
  }

  /**
   * The showAtElement function shows the menu at the given screen position in a
   * (hopefully) optimal orientation. There can only be one instance of the menu opened at
   * one time and the menu implementation should care that there is only one menu
   * opened globally at all.
   *
   * @param {number} _x is the x position at which the menu will be opened
   * @param {number} _y is the y position at which the menu will be opened
   * @param {boolean} _force if true, the menu will be reopened at the given position,
   * 	even if it already had been opened. Defaults to false.
   * @returns {boolean} whether the menu had been opened
   */
  showAt(_x, _y) {
    var _force = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    //Hide any other currently active menu
    if (_egw_active_menu != null) {
      if (_egw_active_menu == this && !_force) {
        this.hide();
        return false;
      } else {
        _egw_active_menu.hide();
      }
    }
    if (this.instance == null && this._checkImpl) {
      //Obtain a new egwMenuImpl object and pass this instance to it
      this.instance = new EgwMenuShoelace(this.children);
    }
    _egw_active_menu = this;
    this.instance.showAt(_x, _y, () => {
      _egw_active_menu = null;
    });
    return true;
  }

  /**
   * Enable / disable menu items for the given selection & target
   *
   * @param _context
   * @param _links
   * @param _selected
   * @param _target
   * @private
   */
  applyContext(_links, _selected, _target) {
    if (!this.instance) {
      this.instance = new EgwMenuShoelace(this.children);
    }
    this.instance.applyContext(_links, _selected, _target);
    var setOnClick = menuItem => {
      menuItem.set_onClick(elem => {
        // Copy the "checked" state
        if (typeof elem.data.checked != "undefined") {
          elem.data.checked = elem.checked;
        }
        elem.data.execute(_selected, _target);
      });
      menuItem.children.forEach(c => setOnClick(c));
    };
    this.children.forEach(menuItem => {
      setOnClick(menuItem);
    });
  }

  /**
   * Adds a new menu item to the list and returns a reference to that object.
   *
   * @param {string} _id is a unique identifier of the menu item. You can use
   * 	the getItem function to search a specific menu item inside the menu tree. The
   * 	id may also be false, null or "", which makes sense for items like separators,
   * 	which you don't want to access anymore after adding them to the menu tree.
   * @param {string} _caption is the caption of the newly generated menu item. Set the caption
   * 	to "-" in order to create a separator.
   * @param {string} _iconUrl is the URL of the icon which should be prepended to the
   * 	menu item. It may be false, null or "" if you don't want an icon to be displayed.
   * @param {function} _onClick is the JS function which is being executed when the
   * 	menu item is clicked.
   * @param {string|null} _color color
   * @returns {egwMenuItem} the newly generated menu item, which had been appended to the
   * 	menu item list.
   */
  addItem(_id, _caption, _iconUrl, _onClick, _color) {
    //Append the item to the list
    var item = new egwMenuItem(this, _id, _caption, _iconUrl, _onClick, _color);
    this.children.push(item);
    return item;
  }

  /**
   * Removes all elements from the menu structure.
   */
  clear() {
    this.children = [];
  }

  /**
   * Loads the menu structure from the given object tree. The object tree is an array
   * of objects which may contain a subset of the menu item properties. The "children"
   * property of such an object is interpreted as a new sub-menu tree and appended
   * to that child.
   *
   * @param {array} _elements is an array of elements which should be added to the menu
   */
  loadStructure(_elements) {
    this.children = _egwGenMenuStructure(_elements, this);
  }

  /**
   * Searches for the given item id within the element tree.
   */
  getItem(_id) {
    return _egwSearchMenuItem(this.children, _id);
  }

  /**
   * Applies the given onClick handler to all menu items which don't have a clicked
   * handler assigned yet.
   */
  setGlobalOnClick(_onClick) {
    _egwSetMenuOnClick(this.children, _onClick);
  }
}

/**
 * Constructor for the egwMenuItem. Each entry in a menu (including separators)
 * is represented by a menu item.
 */
class egwMenuItem {
  set_id(_value) {
    this.id = _value;
  }
  set_caption(_value) {
    //A value of "-" means that this element is a separator.
    this.caption = _value;
  }
  set_checkbox(_value) {
    this.checkbox = _value;
  }
  set_checked(_value) {
    if (_value && this.groupIndex > 0) {
      //Uncheck all other elements in this radio group
      for (var menuItem of this.parent.children) {
        if (menuItem.groupIndex == this.groupIndex) menuItem.checked = false;
      }
    }
    this.checked = _value;
  }
  constructor(_parent, _id) {
    var _caption = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "";
    var _iconUrl = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "";
    var onClick = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
    var _color = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : null;
    _defineProperty$2n(this, "id", void 0);
    _defineProperty$2n(this, "color", void 0);
    _defineProperty$2n(this, "caption", "");
    _defineProperty$2n(this, "checkbox", false);
    _defineProperty$2n(this, "checked", false);
    _defineProperty$2n(this, "groupIndex", 0);
    _defineProperty$2n(this, "enabled", true);
    _defineProperty$2n(this, "iconUrl", "");
    _defineProperty$2n(this, "onClick", null);
    _defineProperty$2n(this, "default", false);
    _defineProperty$2n(this, "data", null);
    _defineProperty$2n(this, "shortcutCaption", null);
    _defineProperty$2n(this, "children", []);
    _defineProperty$2n(this, "parent", void 0);
    //is set for radio Buttons
    _defineProperty$2n(this, "_dhtmlx_grpid", "");
    //hint might get set somewhere
    _defineProperty$2n(this, "hint", "");
    this.parent = _parent;
    this.id = _id;
    this.caption = _caption;
    this.iconUrl = _iconUrl;
    this.onClick = onClick;
    this.color = _color;
  }

  /**
   * Searches for the given item id within the element tree.
   */
  getItem(_id) {
    if (this.id === _id) return this;
    return _egwSearchMenuItem(this.children, _id);
  }

  /**
   * Applies the given onClick handler to all menu items which don't have a clicked
   * handler assigned yet.
   */
  setGlobalOnClick(_onClick) {
    this.onClick = _onClick;
    _egwSetMenuOnClick(this.children, _onClick);
  }

  /**
   * Adds a new menu item to the list and returns a reference to that object.
   *
   * @param {string} _id is a unique identifier of the menu item. You can use
   * 	the getItem function to search a specific menu item inside the menu tree. The
   * 	id may also be false, null or "", which makes sense for items like separators,
   * 	which you don't want to access anymore after adding them to the menu tree.
   * @param {string} _caption is the caption of the newly generated menu item. Set the caption
   * 	to "-" in order to create a separator.
   * @param {string} _iconUrl is the URL of the icon which should be prepended to the
   * 	menu item. It may be false, null or "" if you don't want an icon to be displayed.
   * @param {function} _onClick is the JS function which is being executed when the
   * 	menu item is clicked.
   * @returns {egwMenuItem} the newly generated menu item, which had been appended to the
   * 	menu item list.
   */
  addItem(_id, _caption, _iconUrl, _onClick, _color) {
    //Append the item to the list
    var item = new egwMenuItem(this, _id, _caption, _iconUrl, _onClick, _color);
    this.children.push(item);
    return item;
  }
  set_groupIndex(_value) {
    //If groupIndex is greater than 0 and the element is a checkbox, it is
    //treated like a radio box
    this.groupIndex = _value;
  }
  set_enabled(_value) {
    this.enabled = _value;
  }
  set_onClick(_value) {
    this.onClick = _value;
  }
  set_iconUrl(_value) {
    this.iconUrl = _value;
  }
  set_default(_value) {
    this["default"] = _value;
  }
  set_data(_value) {
    this.data = _value;
  }
  set_hint(_value) {
    this.hint = _value;
  }
  set_shortcutCaption(_value) {
    this.shortcutCaption = _value;
  }
}

function ownKeys$U(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$T(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$U(Object(t), !0).forEach(function (r) { _defineProperty$2m(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$U(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty$2m(e, r, t) { return (r = _toPropertyKey$2l(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2l(t) { var i = _toPrimitive$2l(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2l(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * EGroupware TapAndSwipe helper library
 *
 * @license http://opensource.org/licenses/gpl-license.php GPL - GNU General Public License
 * @package Api
 * @subpackage ui
 * @link https://www.egroupware.org
 * @author Hadi Nategh <hn@egroupware.org>
 */

class tapAndSwipe {
  /**
   * Constructor
   * @param _element
   * @param _options
   */
  constructor(_element, _options) {
    /**
     * Keeps the touch X start point
     * @private
     */
    _defineProperty$2m(this, "_startX", null);
    /**
     * Keeps the touch Y start point
     * @private
     */
    _defineProperty$2m(this, "_startY", null);
    /**
     * Keeps the touch X end point
     * @private
     */
    _defineProperty$2m(this, "_endX", null);
    /**
     * Keeps the touch Y end point
     * @private
     */
    _defineProperty$2m(this, "_endY", null);
    /**
     * keeps the distance travelled between startX point and endX point
     * @private
     */
    _defineProperty$2m(this, "_distanceX", null);
    /**
     * keeps the distance travelled between startY point and endY point
     * @private
     */
    _defineProperty$2m(this, "_distanceY", null);
    /**
     * flag to keep the status of type of tap
     * @private
     */
    _defineProperty$2m(this, "_isTapAndHold", false);
    /**
     * keeps the timeout id for taphold
     */
    _defineProperty$2m(this, "_tapHoldTimeout", null);
    /**
     * keeps the timeout id for tap
     */
    _defineProperty$2m(this, "_tapTimeout", null);
    /**
     * keeps the contact point on touch start
     * @private
     */
    _defineProperty$2m(this, "_fingercount", null);
    _defineProperty$2m(this, "_scrolledElementObj", null);
    _defineProperty$2m(this, "_hasBeenScrolled", false);
    _defineProperty$2m(this, "_scrollEventTriggered", false);
    _defineProperty$2m(this, "_stillMoving", false);
    /**
     * Options
     * @protected
     */
    _defineProperty$2m(this, "options", null);
    /**
     * Keeps the html node
     */
    _defineProperty$2m(this, "element", null);
    this.options = _objectSpread$T(_objectSpread$T({}, tapAndSwipe._default), _options);
    var element = _element || _options.element;
    // Dont construct if the element is not there
    if (!element || !(typeof element != 'string' && element instanceof EventTarget)) return;
    this.element = element instanceof EventTarget ? element : document.querySelector(element);
    this.element.addEventListener('touchstart', this._onTouchStart.bind(this), false);
    this.element.addEventListener('touchend', this._ontouchEnd.bind(this), false);
    this.element.addEventListener('touchmove', this._onTouchMove.bind(this), false);
    this.element.addEventListener('touchcancel', this._onTouchCancel.bind(this), false);
  }
  _onScrolled(event) {
    this._scrollEventTriggered = true;
  }
  _onTouchCancel(event) {
    //cleanup tapHoldTimeout
    window.clearTimeout(this._tapHoldTimeout);
    //cleanup tapHoldTimeout
    window.clearTimeout(this._tapTimeout);
  }
  _onTouchMove(event) {
    this._stillMoving = true;
  }
  /**
   * on touch start event handler
   * @param event
   * @private
   */
  _onTouchStart(event) {
    this._startX = event.changedTouches[0].pageX;
    this._startY = event.changedTouches[0].pageY;
    this._isTapAndHold = false;
    this._fingercount = event.touches.length;
    if (event.composedPath()) {
      var scrolledItem = event.composedPath().filter(_item => {
        if (_item instanceof HTMLElement) _item.addEventListener('scroll', this._onScrolled.bind(this), false);
        return _item instanceof HTMLElement && this.element.contains(_item) && (_item.scrollTop != 0 || _item.scrollLeft != 0);
      });
      if (scrolledItem.length > 0) {
        this._scrolledElementObj = {
          el: scrolledItem[0],
          scrollTop: scrolledItem[0].scrollTop,
          scrollLeft: scrolledItem[0].scrollLeft
        };
      } else {
        this._scrolledElementObj = null;
      }
    }
    this._tapHoldTimeout = window.setTimeout(_ => {
      this._isTapAndHold = true;
      //check scrolling
      if (this.options.allowScrolling && this._stillMoving) {
        return;
      }
      this.options.tapAndHold.call(this, event, this._fingercount);
    }, this.options.tapHoldThreshold);
  }

  /**
   * On touch end event handler
   * @param event
   * @private
   */
  _ontouchEnd(event) {
    this._endX = event.changedTouches[0].pageX;
    this._endY = event.changedTouches[0].pageY;
    this._stillMoving = false;
    if (this._scrolledElementObj) {
      switch (this.options.allowScrolling) {
        case "vertical":
          this._hasBeenScrolled = this._scrolledElementObj.el.scrollTop != this._scrolledElementObj.scrollTop;
          break;
        case "horizental":
          this._hasBeenScrolled = this._scrolledElementObj.el.scrollLeft != this._scrolledElementObj.scrollLeft;
          break;
        case "both":
          this._hasBeenScrolled = this._scrolledElementObj.el.scrollTop != this._scrolledElementObj.scrollTop || this._scrolledElementObj.el.scrollLeft != this._scrolledElementObj.scrollLeft;
          break;
        default:
          this._hasBeenScrolled = false;
      }
    } else {
      this._hasBeenScrolled = false;
    }
    this._handler(event);
  }

  /**
   * Handles the type of gesture and calls the right callback for it
   * @param event
   * @private
   */
  _handler(event) {
    var _this$_hasBeenScrolle;
    //cleanup tapHoldTimeout
    window.clearTimeout(this._tapHoldTimeout);
    this._distanceX = Math.abs(this._endX - this._startX);
    this._distanceY = Math.abs(this._endY - this._startY);
    var isTabOrHold = this._endX == this._startX && this._endY == this._startY || Math.sqrt(this._distanceX * this._distanceX + this._distanceY * 2) < this.options.threshold;
    this._hasBeenScrolled = (_this$_hasBeenScrolle = this._hasBeenScrolled) !== null && _this$_hasBeenScrolle !== void 0 ? _this$_hasBeenScrolle : !isTabOrHold && this._scrollEventTriggered;
    //check scrolling
    if (this.options.allowScrolling && this._hasBeenScrolled) {
      // let the scrolling happens
      return;
    }

    // Tap & TapAndHold handler
    if (isTabOrHold) {
      if (!this._isTapAndHold) {
        this._tapTimeout = window.setTimeout(_ => {
          this.options.tap.call(this, event, this._fingercount);
        }, 100);
      }
      return;
    }

    // left swipe handler
    if (this._endX + this.options.threshold < this._startX && this._distanceX > this._distanceY) {
      if (this._distanceX < this.options.minSwipeThreshold) return;
      this.options.swipe.call(this, event, 'left', this._distanceX, this._fingercount);
      return;
    }

    // right swipe handler
    if (this._endX - this.options.threshold > this._startX && this._distanceX > this._distanceY) {
      if (this._distanceX < this.options.minSwipeThreshold) return;
      this.options.swipe.call(this, event, 'right', this._distanceX, this._fingercount);
      return;
    }

    // up swipe handler
    if (this._endY + this.options.threshold < this._startY && this._distanceY > this._distanceX) {
      if (this._distanceY < this.options.minSwipeThreshold) return;
      this.options.swipe.call(this, event, 'up', this._distanceY, this._fingercount);
      return;
    }

    // down swipe handler
    if (this._endY - this.options.threshold > this._startY && this._distanceY > this._distanceX) {
      if (this._distanceY < this.options.minSwipeThreshold) return;
      this.options.swipe.call(this, event, 'down', this._distanceY, this._fingercount);
      return;
    }
  }

  /**
   * destroy the event listeners
   */
  destroy() {
    this.element.removeEventListener('touchstart', this._onTouchStart);
    this.element.removeEventListener('touchend', this._ontouchEnd);
    this.element.removeEventListener('touchcancel', this._onTouchCancel);
  }
}
_defineProperty$2m(tapAndSwipe, "_default", {
  threshold: 5,
  tapHoldThreshold: 3000,
  minSwipeThreshold: 150,
  allowScrolling: 'both',
  swipe: function swipe() {},
  tap: function tap() {},
  tapAndHold: function tapAndHold() {}
});

function ownKeys$T(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$S(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$T(Object(t), !0).forEach(function (r) { _defineProperty$2l(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$T(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty$2l(e, r, t) { return (r = _toPropertyKey$2k(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2k(t) { var i = _toPrimitive$2k(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2k(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class EgwPopupActionImplementation {
  constructor() {
    _defineProperty$2l(this, "type", "popup");
    _defineProperty$2l(this, "auto_paste", true);
    _defineProperty$2l(this, "parent", void 0);
    //currently only implemented by Et2Tree
    _defineProperty$2l(this, "registerAction", (_aoi, _callback, _context) => {
      var _context$findActionTa;
      var node = _aoi.getDOMNode();
      var parentNode = null;
      var parentAO = null;
      var isNew = false;

      // Is there a parent that handles action targets?
      if (typeof _context.findActionTargetHandler !== "undefined" && typeof ((_context$findActionTa = _context.findActionTargetHandler) === null || _context$findActionTa === void 0 || (_context$findActionTa = _context$findActionTa.iface) === null || _context$findActionTa === void 0 ? void 0 : _context$findActionTa.getWidget) == "function") {
        parentAO = _context.findActionTargetHandler;
        parentNode = parentAO.iface.getWidget();
      }
      if (!_aoi.findActionTargetHandler && parentNode && typeof parentNode.findActionTarget == "function") {
        _aoi.findActionTargetHandler = parentNode;
        isNew = true;
      }
      if (typeof _aoi.handlers == "undefined") {
        _aoi.handlers = {};
      }
      if (typeof _aoi.handlers[this.type] == "undefined") {
        _aoi.handlers[this.type] = [];
      }
      if (_aoi.handlers[this.type].length == 0) {
        _aoi.handlers[this.type].push({
          type: 'contextmenu',
          listener: _callback
        });
        if (isNew) {
          //if a parent is available the context menu Event-listener will only be bound once on the parent
          this._registerDefault(parentNode, _callback, parentAO);
          this._registerContext(parentNode, _callback, parentAO);
          return true;
        } else if (node && !parentNode) {
          this._registerDefault(node, _callback, _context);
          this._registerContext(node, _callback, _context);
          return true;
        }
      }
      return false;
    });
    _defineProperty$2l(this, "unregisterAction", function (_aoi) {
      var node = _aoi.getDOMNode();
      //TODO jQuery replacement
      jQuery(node).off();

      // Unregister handlers
      if (_aoi.handlers) {
        var _aoi$handlers$this$ty;
        (_aoi$handlers$this$ty = _aoi.handlers[this.type]) === null || _aoi$handlers$this$ty === void 0 || _aoi$handlers$this$ty.forEach(h => node.removeEventListener(h.type, h.listener));
        delete _aoi.handlers[this.type];
      }
      return true;
    });
    /**
     * Builds the context menu and shows it at the given position/DOM-Node.
     *
     * @param {object} _context
     * @param {type} _selected
     * @param {type} _links
     * @param {type} _target
     * @returns {Boolean}
     */
    _defineProperty$2l(this, "executeImplementation", (_context, _selected, _links, _target) => {
      if (typeof _target == "undefined") {
        _target = null;
      }
      this._context = _context;
      if (typeof _context == "object" && typeof _context.keyEvent == "object") {
        return this._handleKeyPress(_context.keyEvent, _selected, _links, _target);
      } else if (_context != "default") {
        var _this$_context, _this$_context2, _this$_context$event;
        //Check whether the context has the posx and posy parameters
        if ((typeof _context.posx != "number" || typeof _context.posy != "number") && typeof _context.id != "undefined") {
          // Calculate context menu position from the given DOM-Node
          var node = _context;
          var x = jQuery(node).offset().left;
          var y = jQuery(node).offset().top;
          _context = {
            "posx": x,
            "posy": y
          };
        }
        var menu = null;
        // Special handling for nextmatch context menu - reuse the same menu
        if (!_target && !_context.menu && _selected[0].parent.manager.data.menu) {
          menu = _selected[0].parent.manager.data.menu;
        }
        if (this.auto_paste && !window.egwIsMobile() && (!((_this$_context = this._context) !== null && _this$_context !== void 0 && _this$_context.event) || (_this$_context2 = this._context) !== null && _this$_context2 !== void 0 && _this$_context2.event && !((_this$_context$event = this._context.event) !== null && _this$_context$event !== void 0 && _this$_context$event.type.match(/touch/)))) {
          this._addCopyPaste(_links, _selected);
        }
        if (!menu) {
          menu = this._buildMenu(_links, _selected, _target);
        } else {
          menu.applyContext(_links, _selected, _target);
        }
        menu.showAt(_context.posx, _context.posy);
        return true;
      } else {
        var defaultAction = this._getDefaultLink(_links);
        if (defaultAction) {
          defaultAction.execute(_selected);
        }
      }
      return false;
    });
    /**
     * Registers the handler for the default action
     *
     * @param {any} _node
     * @param {function} _callback
     * @param {object} _context
     * @returns {boolean}
     */
    _defineProperty$2l(this, "_registerDefault", (_node, _callback, _context) => {
      var defaultHandler = e => {
        var x = _node;
        //use different node and context for callback if event happens on parent
        var nodeToUse;
        var contextToUse;
        if (x.findActionTarget) {
          var y = x.findActionTarget(e);
          nodeToUse = y === null || y === void 0 ? void 0 : y.target;
          contextToUse = y === null || y === void 0 ? void 0 : y.action;
          e.originalEvent = e;
        }
        //allow bubbling of the expand folder event
        //do not stop bubbling of events if the event is supposed to be handled by the et2-tree
        if (window.egwIsMobile() && (nodeToUse || e.currentTarget).tagName == "SL-TREE-ITEM") return true;
        // a tag should be handled by default event
        // Prevent bubbling bound event on <a> tag, on touch devices
        if (window.egwIsMobile() && (nodeToUse || e.target).tagName == "A") return true;
        if (typeof document["selection"] != "undefined" && typeof document["selection"].empty != "undefined") {
          document["selection"].empty();
        } else if (typeof window.getSelection != "undefined") {
          var sel = window.getSelection();
          sel.removeAllRanges();
        }
        if (!((contextToUse || _context).manager.getActionsByAttr('singleClick', true).length > 0 && (nodeToUse || e.target).classList.contains('et2_clickable'))) {
          _callback.call(contextToUse || _context, "default", this);
        }

        // Stop action from bubbling up to parents
        e.stopPropagation();
        e.cancelBubble = true;

        // remove context menu if we are in mobile theme
        // and intended to open the entry
        if (_egw_active_menu && e.which == 1) _egw_active_menu.hide();
        return false;
      };
      if (window.egwIsMobile() || _context.manager.getActionsByAttr('singleClick', true).length > 0) {
        _node.addEventListener('click', defaultHandler); //jQuery(_node).on('click', defaultHandler);
      } else {
        _node.ondblclick = defaultHandler;
      }
    });
    _defineProperty$2l(this, "_getDefaultLink", function (_links) {
      var defaultAction = null;
      for (var k in _links) {
        if (_links[k].actionObj["default"] && _links[k].enabled) {
          defaultAction = _links[k].actionObj;
          break;
        }
      }
      return defaultAction;
    });
    _defineProperty$2l(this, "_searchShortcut", (_key, _objs, _links) => {
      for (var item of _objs) {
        var shortcut = item.shortcut;
        if (shortcut && shortcut.keyCode == _key.keyCode && shortcut.shift == _key.shift && shortcut.ctrl == _key.ctrl && shortcut.alt == _key.alt && item.type == "popup" && (typeof _links[item.id] == "undefined" || _links[item.id].enabled)) {
          return item;
        }
        var obj = this._searchShortcut(_key, item.children, _links);
        if (obj) {
          return obj;
        }
      }
    });
    _defineProperty$2l(this, "_searchShortcutInLinks", (_key, _links) => {
      var objs = [];
      for (var k in _links) {
        if (_links[k].enabled) {
          objs.push(_links[k].actionObj);
        }
      }
      return this._searchShortcut(_key, objs, _links);
    });
    /**
     * Handles a key press
     *
     * @param {object} _key
     * @param {type} _selected
     * @param {type} _links
     * @param {type} _target
     * @returns {Boolean}
     */
    _defineProperty$2l(this, "_handleKeyPress", (_key, _selected, _links, _target) => {
      // Handle the default
      if (_key.keyCode == EGW_KEY_ENTER && !_key.ctrl && !_key.shift && !_key.alt) {
        var defaultAction = this._getDefaultLink(_links);
        if (defaultAction) {
          defaultAction.execute(_selected);
          return true;
        }
      }

      // Menu button
      if (_key.keyCode == EGW_KEY_MENU && !_key.ctrl) {
        return this.executeImplementation({
          posx: 0,
          posy: 0
        }, _selected, _links, _target);
      }

      // Check whether the given shortcut exists
      var obj = this._searchShortcutInLinks(_key, _links);
      if (obj) {
        obj.execute(_selected);
        return true;
      }
      return false;
    });
    _defineProperty$2l(this, "_handleTapHold", function (_node, _callback) {
      //TODO (todo-jquery): ATM we need to convert the possible given jquery dom node object into DOM Element, this
      // should be no longer necessary after removing jQuery nodes.
      if (_node instanceof jQuery) {
        _node = _node[0];
      }
      var tap = new tapAndSwipe(_node, {
        // this threshold must be the same as the one set in et2_dataview_view_aoi
        tapHoldThreshold: 1000,
        allowScrolling: "both",
        tapAndHold: function tapAndHold(event, fingercount) {
          if (fingercount >= 2) return;
          // don't trigger contextmenu if sorting is happening
          if (document.querySelector('.sortable-drag')) return;
          _callback(event);
        }
      });
      // bind a custom event tapandhold to be able to call it from nm action button
      _node.addEventListener('tapandhold', _event => {
        _callback(_event);
      });
    });
    /**
     * Registers the handler for the context menu
     *
     * @param {any} _node
     * @param {function} _callback
     * @param {object} _context
     * @returns {boolean}
     */
    _defineProperty$2l(this, "_registerContext", (_node, _callback, _context) => {
      var _context$parent;
      // Special handling for nextmatch: only build the menu once and just re-use it.
      if (!_context.menu && _context.actionLinks && (_context$parent = _context.parent) !== null && _context$parent !== void 0 && (_context$parent = _context$parent.manager) !== null && _context$parent !== void 0 && (_context$parent = _context$parent.data) !== null && _context$parent !== void 0 && _context$parent.nextmatch && !_context.parent.manager.data.menu) {
        // Don't block load
        _context.parent.manager.data.menu = {}; // Set it to something or it will do this for every row
        window.setTimeout(() => {
          _context.parent.manager.data.menu = this._buildMenu(_context.actionLinks, [_context], null);
          _context.parent.manager.data.menu.showAt(0, 0);
          _context.parent.manager.data.menu.hide();
        }, 0);
      }
      var contextHandler = e => {
        var x = _node;
        //use different node and context for callback if event happens on parent
        var nodeToUse;
        var contextToUse;
        if (x.findActionTarget) {
          var y = x.findActionTarget(e);
          nodeToUse = y === null || y === void 0 ? void 0 : y.target;
          contextToUse = y === null || y === void 0 ? void 0 : y.action;
          e.originalEvent = e;
        }
        //Obtain the event object, this should not happen at any point
        if (!e) {
          e = window.event;
        }

        // Close any open tooltip so they don't get in the way
        egw$1(window).tooltipCancel();
        if (_egw_active_menu) {
          _egw_active_menu.hide();
        } else if (!e.ctrlKey && e.which == 3 || e.which === 0 || e.type === 'tapandhold')
          // tap event indicates by 0
          {
            var _nodeToUse;
            var _xy = this._getPageXY(e);
            var _implContext = {
              event: e,
              posx: _xy.posx,
              posy: _xy.posy,
              innerText: ((_nodeToUse = nodeToUse) === null || _nodeToUse === void 0 ? void 0 : _nodeToUse.title) || _node.innerText,
              //nodeToUse only exists on widgets that define findActionTarget
              target: nodeToUse || _node
            };
            _callback.call(contextToUse || _context, _implContext, this);
          }
        e.cancelBubble = !e.ctrlKey || e.which == 1;
        if (e.stopPropagation && e.cancelBubble) {
          e.stopPropagation();
          e.preventDefault();
        }
        return !e.cancelBubble;
      };
      // Safari still needs the taphold to trigger contextmenu
      // Chrome has default event on touch and hold which acts like right click
      this._handleTapHold(_node, contextHandler);
      if (!window.egwIsMobile()) {
        var _context$iface;
        _node.addEventListener('contextmenu', contextHandler);
        (_context$iface = _context.iface) === null || _context$iface === void 0 || _context$iface.handlers['popup'].push({
          type: 'contextmenu',
          listener: contextHandler
        });
      }
    });
    /**
     * Groups and sorts the given action tree layer
     *
     * @param {type} _layer
     * @param {type} _links
     * @param {type} _parentGroup
     */
    _defineProperty$2l(this, "_groupLayers", (_layer, _links, _parentGroup) => {
      // Separate the multiple groups out of the layer
      var link_groups = {};
      for (var i = 0; i < _layer.children.length; i++) {
        var _popupAction$group;
        var popupAction = _layer.children[i].action;

        // Check whether the link group of the current element already exists,
        // if not, create the group
        var grp = (_popupAction$group = popupAction.group) !== null && _popupAction$group !== void 0 ? _popupAction$group : 999;
        if (typeof link_groups[grp] == "undefined") {
          link_groups[grp] = [];
        }

        // Search the link data for this action object if none is found,
        // visible and enabled = true is assumed
        var visible = true;
        var enabled = true;
        if (typeof _links[popupAction.id] != "undefined") {
          visible = _links[popupAction.id].visible;
          enabled = _links[popupAction.id].enabled;
        }

        // Insert the element in order
        var inserted = false;
        var groupObj = {
          "actionObj": popupAction,
          "visible": visible,
          "enabled": enabled,
          "groups": []
        };
        for (var j = 0; j < link_groups[grp].length; j++) {
          var elem = link_groups[grp][j].actionObj;
          if (elem.order > popupAction.order) {
            inserted = true;
            link_groups[grp].splice(j, 0, groupObj);
            break;
          }
        }

        // If the object hasn't been inserted, add it to the end of the list
        if (!inserted) {
          link_groups[grp].push(groupObj);
        }

        // If this child itself has children, group those elements too
        if (_layer.children[i].children.length > 0) {
          this._groupLayers(_layer.children[i], _links, groupObj);
        }
      }

      // Transform the link_groups object into a sorted array
      var groups = [];
      for (var k in link_groups) {
        groups.push({
          "grp": k,
          "links": link_groups[k]
        });
      }
      groups.sort(function (a, b) {
        var ia = parseFloat(a.grp);
        var ib = parseFloat(b.grp);
        return ia > ib ? 1 : ia < ib ? -1 : 0;
      });

      // Append the groups to the groups2 array
      var groups2 = [];
      for (var item of groups) {
        groups2.push(item.links);
      }
      _parentGroup.groups = groups2;
    });
    /**
     * Build the menu layers
     *
     * @param {type} _menu
     * @param {type} _groups
     * @param {type} _selected
     * @param {type} _enabled
     * @param {type} _target
     */
    _defineProperty$2l(this, "_buildMenuLayer", (_menu, _groups, _selected, _enabled, _target) => {
      var firstGroup = true;
      for (var item1 of _groups) {
        var firstElem = true;

        // Go through the elements of each group
        for (var link of item1) {
          if (link.visible) {
            // Add a separator after each group
            if (!firstGroup && firstElem) {
              _menu.addItem("", "-");
            }
            firstElem = false;
            var item = _menu.addItem(link.actionObj.id, link.actionObj.caption, link.actionObj.iconUrl, undefined, link.actionObj.color);
            item.default = link.actionObj["default"];

            // As this code is also used when a drag-drop popup menu is built,
            // we have to perform this check
            if (link.actionObj.type == "popup") {
              item.set_hint(link.actionObj.hint);
              item.set_checkbox(link.actionObj.checkbox);
              item.set_checked(link.actionObj.checked);
              if (link.actionObj.checkbox && link.actionObj.isChecked) {
                item.set_checked(link.actionObj.isChecked.exec(link.actionObj, _selected));
              }
              item.set_groupIndex(link.actionObj.radioGroup);
              if (link.actionObj.shortcut && !window.egwIsMobile()) {
                var shortcut = link.actionObj.shortcut;
                item.set_shortcutCaption(shortcut.caption);
              }
            }
            item.set_data(link.actionObj);
            if (link.enabled && _enabled) {
              item.set_onClick(elem => {
                // Pass the context
                elem.data.menu_context = this._context;

                // Copy the "checked" state
                if (typeof elem.data.checked != "undefined") {
                  elem.data.checked = elem.checked;
                }
                elem.data.execute(_selected, _target);
                if (typeof elem.data.checkbox != "undefined" && elem.data.checkbox) {
                  return elem.data.checked;
                }
              });
            } else {
              item.set_enabled(false);
            }

            // Append the parent groups
            if (link.groups) {
              this._buildMenuLayer(item, link.groups, _selected, link.enabled, _target);
            }
          }
        }
        firstGroup = firstGroup && firstElem;
      }
    });
    /**
     * Builds the context menu from the given action links
     *
     * @param {type} _links
     * @param {type} _selected
     * @param {type} _target
     * @returns {egwMenu|EgwActionImplementation._buildMenu.menu}
     */
    _defineProperty$2l(this, "_buildMenu", (_links, _selected, _target) => {
      var _this$_context3, _this$_context4, _this$_context$event2;
      // Build a tree containing all actions
      var tree = {
        "root": []
      };

      // Automatically add in Drag & Drop actions
      if (this.auto_paste && !window.egwIsMobile() && (!((_this$_context3 = this._context) !== null && _this$_context3 !== void 0 && _this$_context3.event) || (_this$_context4 = this._context) !== null && _this$_context4 !== void 0 && _this$_context4.event && !((_this$_context$event2 = this._context.event) !== null && _this$_context$event2 !== void 0 && _this$_context$event2.type.match(/touch/)))) {
        this._addCopyPaste(_links, _selected);
      }
      for (var k in _links) {
        _links[k].actionObj.appendToTree(tree);
      }

      // We need the dummy object container in order to pass the array by
      // reference
      var groups = {
        "groups": []
      };
      if (tree.root.length > 0) {
        // Sort every action object layer by the given sort position and grouping
        this._groupLayers(tree.root[0], _links, groups);
      }
      var menu = new egwMenu();

      // Build the menu layers
      this._buildMenuLayer(menu, groups.groups, _selected, true, _target);
      return menu;
    });
    _defineProperty$2l(this, "_getPageXY", function getPageXY(event) {
      // document.body.scrollTop does not work in IE
      var scrollTop = document.body.scrollTop ? document.body.scrollTop : document.documentElement.scrollTop;
      var scrollLeft = document.body.scrollLeft ? document.body.scrollLeft : document.documentElement.scrollLeft;
      return {
        'posx': event.clientX + scrollLeft,
        'posy': event.clientY + scrollTop
      };
    });
    /**
     * Automagically add in context menu items for copy and paste from
     * drag and drop actions, based on current clipboard and the accepted types
     *
     * @param {object[]} _links Actions for inclusion in the menu
     * @param {EgwActionObject[]} _selected Currently selected entries
     */
    _defineProperty$2l(this, "_addCopyPaste", (_links, _selected) => {
      var _this$_context5;
      // Get a list of drag & drop actions
      var drag = _selected[0].getSelectedLinks('drag', true).links;
      var drop = _selected[0].getSelectedLinks('drop', true).links;

      // No drags & no drops means early exit (only by default added egw_cancel_drop does NOT count!)
      if ((!drag || jQuery.isEmptyObject(drag)) && (!drop || jQuery.isEmptyObject(drop) || Object.keys(drop).length === 1 && typeof drop.egw_cancel_drop !== 'undefined')) {
        return;
      }

      // Find existing actions so we don't get copies
      var mgr = _selected[0].manager;
      var copy_action = mgr.getActionById('egw_copy');
      var add_action = mgr.getActionById('egw_copy_add');
      var clipboard_action = mgr.getActionById('egw_os_clipboard');
      var paste_action = mgr.getActionById('egw_paste');

      // Fake UI so we can simulate the position of the drop
      var ui = {
        position: {
          top: 0,
          left: 0
        },
        offset: {
          top: 0,
          left: 0
        }
      };
      if ((_this$_context5 = this._context) !== null && _this$_context5 !== void 0 && _this$_context5.event) {
        var event = this._context.event.originalEvent || this._context.event;
        ui.position = {
          top: event.pageY,
          left: event.pageX
        };
        ui.offset = {
          top: event.offsetY,
          left: event.offsetX
        };
      }
      // Create default copy menu action
      if (drag && !jQuery.isEmptyObject(drag)) {
        var _this$_context6;
        // Don't re-add if it's there
        if (copy_action == null) {
          // Create a drag action that allows linking
          copy_action = mgr.addAction('popup', 'egw_copy', window.egw.lang('Copy to clipboard'), window.egw.image('copy'), function (action, selected) {
            // Copied, now add to clipboard
            var clipboard = {
              type: [],
              selected: []
            };

            // When pasting we need to know the type of drag
            for (var k in drag) {
              if (drag[k].enabled && drag[k].actionObj.dragType.length > 0) {
                clipboard.type = clipboard.type.concat(drag[k].actionObj.dragType);
              }
            }
            clipboard.type = jQuery.uniqueSort(clipboard.type);
            // egwAction is a circular structure and can't be stringified so just take what we want
            // Hopefully that's enough for the action handlers
            for (var _k in selected) {
              if (selected[_k].id) {
                var _window$egw$dataGetUI, _window$egw$dataGetUI2;
                clipboard.selected.push({
                  id: selected[_k].id,
                  data: _objectSpread$S(_objectSpread$S({}, (_window$egw$dataGetUI = (_window$egw$dataGetUI2 = window.egw.dataGetUIDdata(selected[_k].id)) === null || _window$egw$dataGetUI2 === void 0 ? void 0 : _window$egw$dataGetUI2.data) !== null && _window$egw$dataGetUI !== void 0 ? _window$egw$dataGetUI : {}), selected[_k].data)
                });
              }
            }

            // Save it in session
            window.egw.setSessionItem('phpgwapi', 'egw_clipboard', JSON.stringify(clipboard));
          }, true);
          copy_action.group = 2.5;
        }
        if (add_action == null) {
          // Create an action to add selected to clipboard
          add_action = mgr.addAction('popup', 'egw_copy_add', window.egw.lang('Add to clipboard'), window.egw.image('copy'), function (action, selected) {
            // Copied, now add to clipboard
            var clipboard = JSON.parse(window.egw.getSessionItem('phpgwapi', 'egw_clipboard')) || {
              type: [],
              selected: []
            };

            // When pasting we need to know the type of drag
            for (var k in drag) {
              if (drag[k].enabled && drag[k].actionObj.dragType.length > 0) {
                clipboard.type = clipboard.type.concat(drag[k].actionObj.dragType);
              }
            }
            clipboard.type = [...new Set(clipboard.type)].sort();
            // egwAction is a circular structure and can't be stringified so just take what we want
            // Hopefully that's enough for the action handlers
            for (var _k2 in selected) {
              if (selected[_k2].id) {
                var _window$egw$dataGetUI3, _window$egw$dataGetUI4;
                clipboard.selected.push({
                  id: selected[_k2].id,
                  data: _objectSpread$S(_objectSpread$S({}, (_window$egw$dataGetUI3 = (_window$egw$dataGetUI4 = window.egw.dataGetUIDdata(selected[_k2].id)) === null || _window$egw$dataGetUI4 === void 0 ? void 0 : _window$egw$dataGetUI4.data) !== null && _window$egw$dataGetUI3 !== void 0 ? _window$egw$dataGetUI3 : {}), selected[_k2].data)
                });
              }
            }

            // Save it in session
            window.egw.setSessionItem('phpgwapi', 'egw_clipboard', JSON.stringify(clipboard));
          }, true);
          add_action.group = 2.5;
        }
        if (clipboard_action == null) {
          // Create an action to add selected to clipboard
          clipboard_action = mgr.addAction('popup', 'egw_os_clipboard', window.egw.lang('Copy to OS clipboard'), window.egw.image('copy'), function (action) {
            if (document.queryCommandSupported('copy')) {
              jQuery(action.data.target).trigger('copy');
            }
          }, true);
          clipboard_action.group = 2.5;
        }
        var os_clipboard_caption = "";
        if ((_this$_context6 = this._context) !== null && _this$_context6 !== void 0 && _this$_context6.event) {
          os_clipboard_caption = this._context.event.target.innerText.trim().replaceAll("\n", " ");
          clipboard_action.set_caption(window.egw.lang('Copy "%1"', os_clipboard_caption.length > 20 ? os_clipboard_caption.substring(0, 20) + '...' : os_clipboard_caption));
          clipboard_action.data.target = this._context.target;
        }
        jQuery(clipboard_action.data.target).off('copy').on('copy', function (event) {
          try {
            window.egw.copyTextToClipboard(os_clipboard_caption, clipboard_action.data.target, event).then(successful => {
              // Fallback
              if (typeof successful == "undefined") {
                // Clear message
                window.egw.message(window.egw.lang("'%1' copied to clipboard", os_clipboard_caption.length > 20 ? os_clipboard_caption.substring(0, 20) + '...' : os_clipboard_caption));
                window.getSelection().removeAllRanges();
                return false;
              } else {
                // Show fail message
                window.egw.message(window.egw.lang('Use Ctrl-C/Cmd-C to copy'));
              }
            });
          } catch (err) {}
        });
        if (typeof _links[copy_action.id] == 'undefined') {
          _links[copy_action.id] = {
            "actionObj": copy_action,
            "enabled": true,
            "visible": true,
            "cnt": 0
          };
        }
        if (typeof _links[add_action.id] == 'undefined') {
          _links[add_action.id] = {
            "actionObj": add_action,
            "enabled": true,
            "visible": true,
            "cnt": 0
          };
        }
        if (typeof _links[clipboard_action.id] == 'undefined') {
          _links[clipboard_action.id] = {
            "actionObj": clipboard_action,
            "enabled": os_clipboard_caption.length > 0,
            "visible": this._context ? os_clipboard_caption.length > 0 : true,
            "cnt": 0
          };
        }
      }

      // Create default paste menu item
      if (drop && !jQuery.isEmptyObject(drop)) {
        // Create paste action
        // This injects the clipboard data and calls the original handler
        var paste_exec = function paste_exec(action, selected) {
          // Add in clipboard as a sender
          var clipboard = JSON.parse(window.egw.getSessionItem('phpgwapi', 'egw_clipboard'));
          // Fake drop position
          drop[action.id].actionObj.ui = ui;
          // Set a flag so apps can tell the difference, if they need to
          drop[action.id].actionObj.paste = true;
          drop[action.id].actionObj.execute(clipboard.selected, selected[0]);
          drop[action.id].actionObj.paste = false;
        };
        var clipboard = JSON.parse(window.egw.getSessionItem('phpgwapi', 'egw_clipboard')) || {
          type: [],
          selected: []
        };

        // Don't re-add if action already exists
        if (paste_action == null) {
          paste_action = mgr.addAction('popup', 'egw_paste', window.egw.lang('Paste'), window.egw.image('editpaste'), paste_exec, true);
          paste_action.group = 2.5;
          paste_action.order = 9;
          if (typeof paste_action.canHaveChildren !== "boolean") {
            paste_action.canHaveChildren.push('drop');
          }
        }

        // Set hint to something resembling current clipboard
        var hint = window.egw.lang('Clipboard') + ":\n";
        paste_action.set_hint(hint);
        // Add titles of entries
        for (var i = 0; i < clipboard.selected.length; i++) {
          var id = clipboard.selected[i].id.split('::');
          window.egw.link_title(id[0], id[1], title => {
            if (title) {
              hint += title + "\n";
            }
          }, paste_action);
        }

        // Add into links, so it's included in menu
        // @ts-ignore exec uses arguments:IArguments and therefor can consume them even if ts does not know it
        if (paste_action && paste_action.enabled.exec(paste_action, clipboard.selected, _selected[0])) {
          if (typeof _links[paste_action.id] == 'undefined') {
            _links[paste_action.id] = {
              "actionObj": paste_action,
              "enabled": false,
              "visible": clipboard != null,
              "cnt": 0
            };
          }
          while (paste_action.children.length > 0) {
            paste_action.children[0].remove();
          }

          // If nothing [valid] in the clipboard, don't bother with children
          if (clipboard == null || typeof clipboard.type != 'object') {
            return;
          }

          // Add in actual actions as children
          for (var k in drop) {
            if (k == "egw_cancel_drop") {
              continue;
            }
            // Add some choices - need to be a copy, or they interfere with
            // the original
            //replace jQuery with spread operator
            // set the Prototype of the copy set_onExecute is not available otherwise
            var drop_clone = drop[k].actionObj.clone(); //Object.assign(Object.create(Object.getPrototypeOf(drop[k].actionObj)), drop[k].actionObj) //{...drop[k].actionObj};
            //warning This method is really slow
            //Object.setPrototypeOf(drop_clone, EgwAction.prototype)
            var parent = paste_action.parent === drop_clone.parent ? paste_action : paste_action.getActionById(drop_clone.parent.id) || paste_action;
            drop_clone.parent = parent;
            drop_clone.onExecute = new EgwFnct(this, null, []);
            drop_clone.children = [];
            drop_clone.set_onExecute(paste_exec);
            parent.children.push(drop_clone);
            parent.allowOnMultiple = paste_action.allowOnMultiple && drop_clone.allowOnMultiple;
            _links[k] = Object.assign({}, drop[k]);
            _links[k].actionObj = drop_clone;

            // Drop is allowed if clipboard types intersect drop types
            _links[k].enabled = false;
            _links[k].visible = false;
            for (var _i = 0; _i < drop_clone.acceptedTypes.length; _i++) {
              if (clipboard.type.indexOf(drop_clone.acceptedTypes[_i]) != -1) {
                _links[paste_action.id].enabled = true;
                _links[k].enabled = true;
                _links[k].visible = true;
                break;
              }
            }
          }
        }
      }
    });
    _defineProperty$2l(this, "_context", void 0);
    _defineProperty$2l(this, "menu", void 0);
  }
}

/**
 * @deprecated use uppercase class
 */
class egwPopupActionImplementation extends EgwPopupActionImplementation {}
var _popupActionImpl = null;
function getPopupImplementation() {
  if (!_popupActionImpl) {
    _popupActionImpl = new EgwPopupActionImplementation();
  }
  return _popupActionImpl;
}

function _defineProperty$2k(e, r, t) { return (r = _toPropertyKey$2j(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2j(t) { var i = _toPrimitive$2j(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2j(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class EgwDropActionImplementation {
  constructor() {
    _defineProperty$2k(this, "type", "drop");
    //keeps track of current drop element where dragged item's entered.
    // it's necessary for dragenter/dragleave issue correction.
    _defineProperty$2k(this, "currentDropEl", null);
    _defineProperty$2k(this, "registerAction", (_aoi, _callback, _context) => {
      var _context$findActionTa;
      var parentNode = null;
      var parentAO = null;
      var isNew = false;
      var node = _aoi.getDOMNode() && _aoi.getDOMNode()[0] ? _aoi.getDOMNode()[0] : _aoi.getDOMNode();
      var self = this;

      // Is there a parent that handles action targets?
      if (typeof _context.findActionTargetHandler !== "undefined" && typeof ((_context$findActionTa = _context.findActionTargetHandler) === null || _context$findActionTa === void 0 || (_context$findActionTa = _context$findActionTa.iface) === null || _context$findActionTa === void 0 ? void 0 : _context$findActionTa.getWidget) == "function") {
        parentAO = _context.findActionTargetHandler;
        parentNode = parentAO.iface.getWidget();
      }
      if (!_aoi.findActionTargetHandler && parentNode && typeof parentNode.findActionTarget == "function") {
        _aoi.findActionTargetHandler = parentNode;
      }
      if (node) {
        if (typeof _aoi.handlers == "undefined") {
          _aoi.handlers = {};
        }
        if (typeof _aoi.handlers[this.type] == "undefined") {
          _aoi.handlers[this.type] = [];
        }
        node.classList.add('et2dropzone');
        var dragover = event => {
          if (event.preventDefault) {
            event.preventDefault();
          }
          return true;
        };
        var dragenter = function dragenter(event) {
          // don't trigger dragenter if we are entering the drag element
          // don't go further if the dragged element is no there (happens when a none et2 dragged element is being dragged)
          if (!self.getTheDraggedDOM() || self.isTheDraggedDOM(this) || this == self.currentDropEl) return;

          // stop the event from being fired for its children
          event.stopPropagation();
          event.preventDefault();
          if (_aoi.findActionTargetHandler && typeof _aoi.findActionTargetHandler.findActionTarget === "function") {
            var _parentData$target, _parentData$action$if;
            // Bubbling up to parent
            var parentData = _aoi.findActionTargetHandler.findActionTarget(event);
            self.currentDropEl = (_parentData$target = parentData.target) !== null && _parentData$target !== void 0 ? _parentData$target : event.currentTarget;
            _aoi = (_parentData$action$if = parentData.action.iface) !== null && _parentData$action$if !== void 0 ? _parentData$action$if : _aoi;
          } else {
            self.currentDropEl = event.currentTarget;
          }
          event.dataTransfer.dropEffect = 'link';
          var data = {
            event: event,
            ui: self.getTheDraggedData()
          };
          _aoi.triggerEvent(EGW_AI_DRAG_ENTER, data);

          // cleanup drop hover class from all other DOMs if there's still anything left
          Array.from(document.getElementsByClassName('et2dropzone drop-hover')).forEach(_i => {
            _i.classList.remove('drop-hover');
          });
          this.classList.add('drop-hover');
          return false;
        };
        var drop = function drop(event) {
          event.preventDefault();
          // don't go further if the dragged element is no there (happens when a none et2 dragged element is being dragged)
          if (!self.getTheDraggedDOM()) return;
          var dropActionObject = _context;
          var helper = self.getHelperDOM();

          // remove the hover class
          this.classList.remove('drop-hover');
          if (this.findActionTarget) {
            var _this$findActionTarge;
            dropActionObject = (_this$findActionTarge = this.findActionTarget(event).action) !== null && _this$findActionTarge !== void 0 ? _this$findActionTarge : _context;
          } else if (self.isTheDraggedDOM(this)) {
            // clean up the helper dom
            if (helper) {
              helper.remove();
            }
            return;
          }
          var ui = self.getTheDraggedData();
          ui.position = {
            top: event.clientY,
            left: event.clientX
          };
          ui.offset = {
            top: event.offsetY,
            left: event.offsetX
          };
          var data = JSON.parse(event.dataTransfer.getData('application/json'));
          if (!self.isAccepted(data, dropActionObject, _callback, undefined)) {
            // clean up the helper dom
            if (helper) helper.remove();
            return;
          }
          var selected = data.selected.map(item => {
            return egw_getObjectManager(item.id, false);
          });

          //links is an Object of DropActions bound to their names
          var links = _callback.call(dropActionObject, "links", self, EGW_AO_EXEC_THIS);

          // Disable all links which only accept types which are not
          // inside ddTypes
          for (var k in links) {
            var accepted = links[k].actionObj.acceptedTypes;
            var enabled = false;
            for (var i = 0; i < data.ddTypes.length; i++) {
              if (accepted.indexOf(data.ddTypes[i]) != -1) {
                enabled = true;
                break;
              }
            }
            // Check for allowing multiple selected
            if (!links[k].actionObj.allowOnMultiple && selected.length > 1) {
              enabled = false;
            }
            if (!enabled) {
              links[k].enabled = false;
              links[k].visible = !links[k].actionObj.hideOnDisabled;
            }
          }

          // Check whether there is only one link
          var cnt = 0;
          var lnk = null;
          for (var _k in links) {
            if (links[_k].enabled && links[_k].visible) {
              lnk = links[_k];
              cnt += 1 + links[_k].actionObj.children.length;

              // Add ui, so you know what happened where
              lnk.actionObj.ui = ui;
            }
          }
          if (cnt == 1) {
            window.setTimeout(function () {
              lnk.actionObj.execute(selected, dropActionObject);
            }, 0);
          }
          if (cnt > 1) {
            // More than one drop action link is associated
            // to the drop event - show those as a popup menu
            // and let the user decide which one to use.
            // This is possible as the popup and the popup action
            // object and the drop action object share same
            // set of properties.
            var popup = getPopupImplementation();
            var pos = popup._getPageXY(event);

            // Don't add paste actions, this is a drop
            popup.auto_paste = false;
            window.setTimeout(function () {
              popup.executeImplementation(pos, selected, links, dropActionObject);
              // Reset, popup is reused
              popup.auto_paste = true;
            }, 0); // Timeout is needed to have it working in IE
          }
          // Set cursor back to auto. Seems FF can't handle cursor reversion
          jQuery('body').css({
            cursor: 'auto'
          });
          _aoi.triggerEvent(EGW_AI_DRAG_OUT, {
            event: event,
            ui: self.getTheDraggedData()
          });

          // clean up the helper dom
          if (helper) helper.remove();
          self.getTheDraggedDOM().classList.remove('drag--moving');
        };
        var dragleave = function dragleave(event) {
          event.stopImmediatePropagation();

          // don't trigger dragleave if we are leaving the drag element
          // don't go further if the dragged element is no there (happens when a none et2 dragged element is being dragged)
          if (!self.getTheDraggedDOM() || self.isTheDraggedDOM(this)) return;
          if (_aoi.findActionTargetHandler && typeof _aoi.findActionTargetHandler.findActionTarget === "function") {
            var _parentData$action$if2, _parentData$action;
            // Bubbling up to parent
            var parentData = _aoi.getWidget().findActionTarget(event);
            _aoi = (_parentData$action$if2 = parentData === null || parentData === void 0 || (_parentData$action = parentData.action) === null || _parentData$action === void 0 ? void 0 : _parentData$action.iface) !== null && _parentData$action$if2 !== void 0 ? _parentData$action$if2 : _aoi;
          }
          var data = {
            event: event,
            ui: self.getTheDraggedData()
          };
          _aoi.triggerEvent(EGW_AI_DRAG_OUT, data);
          this.classList.remove('drop-hover');
          event.preventDefault();
          return false;
        };
        if (_aoi.handlers[this.type].length == 0) {
          // DND Event listeners
          node.addEventListener('dragenter', dragenter, false);
          _aoi.handlers[this.type].push({
            type: 'dragenter',
            listener: dragenter
          });
          node.addEventListener('dragleave', dragleave, false);
          _aoi.handlers[this.type].push({
            type: 'dragleave',
            listener: dragleave
          });
          node.addEventListener('dragover', dragover, false);
          _aoi.handlers[this.type].push({
            type: 'dragover',
            listener: dragover
          });
          node.addEventListener('drop', drop, false);
          _aoi.handlers[this.type].push({
            type: 'drop',
            listener: drop
          });
        }
        return true;
      }
      return false;
    });
    _defineProperty$2k(this, "unregisterAction", function (_aoi) {
      var node = _aoi.getDOMNode();
      if (node) {
        node.classList.remove('et2dropzone');
      }
      // Unregister handlers
      if (_aoi.handlers) {
        var _aoi$handlers$this$ty;
        (_aoi$handlers$this$ty = _aoi.handlers[this.type]) === null || _aoi$handlers$this$ty === void 0 || _aoi$handlers$this$ty.forEach(h => node.removeEventListener(h.type, h.listener));
        delete _aoi.handlers[this.type];
      }
      return true;
    });
    /**
     * Builds the context menu and shows it at the given position/DOM-Node.
     *
     * @param {string} _context
     * @param {array} _selected
     * @param {object} _links
     */
    _defineProperty$2k(this, "executeImplementation", function (_context, _selected, _links) {
      if (_context == "links") {
        return _links;
      }
    });
    _defineProperty$2k(this, "isTheDraggedDOM", function (_dom) {
      return _dom.classList.contains('drag--moving');
    });
    _defineProperty$2k(this, "getTheDraggedDOM", function () {
      return document.querySelector('.drag--moving');
    });
    _defineProperty$2k(this, "getHelperDOM", function () {
      return document.querySelector('.et2_egw_action_ddHelper');
    });
    _defineProperty$2k(this, "getTheDraggedData", () => {
      // @ts-ignore // in our case dataset will be present
      var data = this.getTheDraggedDOM().dataset.egwactionobjid;
      var selected = [];
      if (data) {
        data = JSON.parse(data);
        selected = data.map(item => {
          return egw_getObjectManager(item.id, false);
        });
      }
      return {
        draggable: this.getTheDraggedDOM(),
        helper: this.getHelperDOM(),
        selected: selected,
        position: undefined,
        offset: undefined
      };
    });
    // check if given draggable is accepted for drop
    _defineProperty$2k(this, "isAccepted", (_data, _context, _callback, _node) => {
      if (_node && !_node.classList.contains('et2dropzone')) return false;
      if (typeof _data.ddTypes != "undefined") {
        var accepted = this._fetchAccepted(_callback.call(_context, "links", this, EGW_AO_EXEC_THIS));

        // Check whether all drag types of the selected objects
        // are accepted
        var ddTypes = _data.ddTypes;
        for (var i = 0; i < ddTypes.length; i++) {
          if (accepted.indexOf(ddTypes[i]) != -1) {
            return true;
          }
        }
      }
      return false;
    });
    _defineProperty$2k(this, "_fetchAccepted", _links => {
      // Accumulate the accepted types
      var accepted = [];
      for (var k in _links) {
        for (var i = 0; i < _links[k].actionObj.acceptedTypes.length; i++) {
          var type = _links[k].actionObj.acceptedTypes[i];
          if (accepted.indexOf(type) == -1) {
            accepted.push(type);
          }
        }
      }
      return accepted;
    });
  }
}
class egwDropActionImplementation extends EgwDropActionImplementation {}

function _defineProperty$2j(e, r, t) { return (r = _toPropertyKey$2i(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2i(t) { var i = _toPrimitive$2i(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2i(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class EgwPopupAction extends EgwAction {
  constructor(_id, _handler, _caption, _icon, _onExecute, _allowOnMultiple) {
    super(_id, _handler, _caption, _icon, _onExecute, _allowOnMultiple);
    //var action = new EgwAction(_id, _handler, _caption, _icon, _onExecute, _allowOnMultiple);
    _defineProperty$2j(this, "default", false);
    _defineProperty$2j(this, "order", 0);
    _defineProperty$2j(this, "group", 0);
    _defineProperty$2j(this, "hint", false);
    _defineProperty$2j(this, "checkbox", false);
    _defineProperty$2j(this, "radioGroup", 0);
    _defineProperty$2j(this, "checked", false);
    _defineProperty$2j(this, "confirm_mass_selection", null);
    _defineProperty$2j(this, "shortcut", null);
    _defineProperty$2j(this, "singleClick", false);
    _defineProperty$2j(this, "isChecked", void 0);
    _defineProperty$2j(this, "color", null);
    this.type = "popup";
    this.canHaveChildren = ["popup"];
  }
  set_singleClick(_value) {
    this.singleClick = _value;
  }
  set_default(_value) {
    this.default = _value;
  }
  set_order(_value) {
    this.order = _value;
  }
  set_group(_value) {
    this.group = _value;
  }
  set_hint(_value) {
    this.hint = _value;
  }
  // If true, the action will be rendered as checkbox
  set_checkbox(_value) {
    this.checkbox = _value;
  }
  set_checked(_value) {
    this.checked = _value;
  }
  /**
   * Set either a confirmation prompt, or TRUE to indicate that this action
   * cares about large selections and to ask the confirmation prompt(s)
   *
   * @param {String|Boolean} _value
   */
  set_confirm_mass_selection(_value) {
    this.confirm_mass_selection = _value;
  }
  // Allow checkbox to be set from context using the given function
  set_isChecked(_value) {
    this.isChecked = new EgwFnct(this, null, []);
    if (_value !== null) {
      this.isChecked.setValue(_value);
    }
  }
  // If radioGroup is >0 and the element is a checkbox, radioGroup specifies
  // the group of radio buttons this one belongs to
  set_radioGroup(_value) {
    this.radioGroup = _value;
  }
  set_shortcut(_value) {
    if (_value) {
      var sc = {
        "keyCode": -1,
        "shift": false,
        "ctrl": false,
        "alt": false,
        "caption": ""
      };
      if (typeof _value == "object" && typeof _value.keyCode != "undefined" && typeof _value.caption != "undefined") {
        sc.keyCode = _value.keyCode;
        sc.caption = _value.caption;
        sc.shift = typeof _value.shift == "undefined" ? false : _value.shift;
        sc.ctrl = typeof _value.ctrl == "undefined" ? false : _value.ctrl;
        sc.alt = typeof _value.alt == "undefined" ? false : _value.alt;
      }
      this.shortcut = sc;
    } else {
      this.shortcut = false;
    }
  }
  set_color(_value) {
    this.color = _value;
  }
}

/**
 * @deprecated
 * use uppercase class
 */
class egwPopupAction extends EgwPopupAction {}

function _defineProperty$2i(e, r, t) { return (r = _toPropertyKey$2h(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2h(t) { var i = _toPrimitive$2h(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2h(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * Getter functions for the global egwActionManager and egwObjectManager objects
 */

var egw_globalActionManager = null;
var egw_globalObjectManager = null;

/**
 * Returns the action manager for the given application - each application has its
 * own sub-ActionManager in the global action manager object to prevent collisions
 * from happening
 *
 * @param _id is the name of the sub-actionManager which should be returned.
 *    If the action manager does not exist right now, it is created. If the
 *    parameter is omitted or null, the global action manager is returned.
 * @param {boolean} [_create=true] If an objectManager with the given id is not
 *    found, it will be created at the top level.
 * @param {number} [_search_depth=Infinite] How deep into existing action children
 *    to search.
 */
function egw_getActionManager(_id) {
  var _create = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
  var _search_depth = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : Number.MAX_VALUE;
  // Check whether the global action manager had been created, if not do so
  var res = egw_globalActionManager;
  if (egw_globalActionManager == null) {
    res = egw_globalActionManager = new EgwActionManager();
  }

  // Check whether the sub-action manager exists, if not, create it
  if (typeof _id != 'undefined' && _id != null) {
    res = egw_globalActionManager.getActionById(_id, _search_depth);
    if (res == null && _create) {
      res = egw_globalActionManager.addAction("actionManager", _id);
    }
  }
  return res;
}

/**
 * Returns the object manager for the given application - each application may
 * have its own object manager where it can place action objects or containers.
 *
 * @param _id is the name of the sub-object manager should be returned. If the
 *    object manager does not exist right now, it is created. If the parameter
 *    is ommited or null, the global object manager is returned.
 * @param {boolean} [_create=true] If an objectManager with the given id is not
 *    found, it will be created at the top level.
 * @param {number} [_search_depth=Infinite] How deep into existing action children
 *    to search.
 */
function egw_getObjectManager(_id) {
  var _create = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
  var _search_depth = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : Number.MAX_VALUE;
  // Check whether the global object manager exists
  var res = egw_globalObjectManager;
  if (res == null) {
    res = egw_globalObjectManager = new EgwActionObjectManager("_egwGlobalObjectManager", egw_getActionManager());
  }

  // Check whether the sub-object manager exists, if not, create it
  if (typeof _id != 'undefined' && _id != null) {
    res = egw_globalObjectManager.getObjectById(_id, _search_depth);
    if (res == null && _create) {
      res = new EgwActionObjectManager(_id, egw_getActionManager(_id, true, _search_depth));
      egw_globalObjectManager.addObject(res);
    }
  }
  return res;
}

/**
 * Returns the object manager for the current application
 *
 * @param {boolean} _create
 * @param {string} _appName //appName might not always be the current app, e.g. running app content under admin tab
 * @return {EgwActionObjectManager}
 */
function egw_getAppObjectManager() {
  var _create = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
  var _appName = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "";
  return egw_getObjectManager(_appName ? _appName : window.egw(window).app_name(), _create, 1);
}

/**
 * Returns the action manager for the current application
 *
 * @param {boolean} _create
 * @return {EgwActionManager}
 */
// this function is never used
function egw_getAppActionManager(_create) {
  return egw_getActionManager(window.egw_getAppName(), _create, 1);
}

/** egwActionHandler Interface **/

/**
 * Constructor for the egwActionHandler interface which (at least) should have the
 * execute function implemented.
 *
 * @param {function} _executeEvent
 * @return {egwActionHandler}
 * TODO no usage?
 */
function egwActionHandler(_executeEvent) {
  //Copy the executeEvent parameter
  this.execute = _executeEvent;
}

/** egwAction Object
 * @deprecated use EgwAction
 * **/
class egwAction extends EgwAction {}

/** egwActionManager Object **/

/**
 * @deprecated
 */
class egwActionManager extends EgwActionManager {}

/**
 * Associative array where action classes may register themselves
 *
 */
if (typeof window._egwActionClasses == "undefined") {
  window._egwActionClasses = {
    actionManager: undefined,
    default: undefined,
    drag: undefined,
    drop: undefined,
    popup: undefined
  };
}
if (typeof window._egwActionClasses.actionManager == "undefined") {
  window._egwActionClasses.actionManager = {
    actionConstructor: EgwActionManager,
    implementation: null
  };
}
if (typeof window._egwActionClasses.default == "undefined") {
  window._egwActionClasses.default = {
    actionConstructor: EgwAction,
    implementation: null
  };
}
if (typeof window._egwActionClasses.drag == "undefined") {
  window._egwActionClasses.drag = {
    actionConstructor: EgwDragAction,
    implementation: getDragImplementation()
  };
}
if (typeof window._egwActionClasses.drop == "undefined") {
  window._egwActionClasses.drop = {
    actionConstructor: EgwDropAction,
    implementation: getDropImplementation()
  };
}
if (typeof window._egwActionClasses.popup == "undefined") {
  window._egwActionClasses.popup = {
    "actionConstructor": EgwPopupAction,
    "implementation": getPopupImplementation
  };
}

/** EgwActionImplementation Interface **/

/**
 * @deprecated implement upperCase interface EgwActionImplementation instead
 */
class egwActionImplementation {
  constructor() {
    _defineProperty$2i(this, "type", void 0);
    _defineProperty$2i(this, "doRegisterAction", function () {
      throw "Abstract function call: registerAction";
    });
    _defineProperty$2i(this, "doUnregisterAction", function () {
      throw "Abstract function call: unregisterAction";
    });
    _defineProperty$2i(this, "doExecuteImplementation", function () {
      throw "Abstract function call: executeImplementation";
    });
  }
  executeImplementation(_context, _selected, _links) {
    return this.doExecuteImplementation(_context, _selected, _links);
  }
  registerAction(_actionObjectInterface, _triggerCallback) {
    var _context = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
    return this.doRegisterAction(_actionObjectInterface, _triggerCallback, _context);
  }
  unregisterAction(_actionObjectInterface) {
    return this.doUnregisterAction(_actionObjectInterface);
  }
}

/** egwActionLink Object **/

/**
 * @deprecated implement upperCase class instead
 */
class egwActionLink extends EgwActionLink {}

/**
 * @deprecated implement upperCase interface EgwActionImplementation instead
 */
class egwActionObject extends EgwActionObject {}

/** egwActionObjectInterface Interface **/

/**
 * @deprecated This is just a default wrapper class for the EgwActionObjectInterface interface.
 * Please directly implement it instead!
 * ... implements EgwActionObjectInterface{
 *     getDomNode(){...}
 * }
 * instead of className{
 *     var aoi = new egwActionObjectInterface()
 *     aoi.doGetDomNode = function ...
 * }
 *
 * @return {egwActionObjectInterface}
 */
class egwActionObjectInterface {
  constructor() {
    //Preset the iface functions
    _defineProperty$2i(this, "_state", EGW_AO_STATE_NORMAL || EGW_AO_STATE_VISIBLE);
    // _outerCall may be used to determine, whether the state change has been
    // evoked from the outside and the stateChangeCallback has to be called
    _defineProperty$2i(this, "stateChangeCallback", null);
    // The doTriggerEvent function may be overwritten by the aoi if it wants to
    // support certain action implementation specific events like EGW_AI_DRAG_OVER
    _defineProperty$2i(this, "stateChangeContext", null);
    _defineProperty$2i(this, "reconnectActionsCallback", null);
    _defineProperty$2i(this, "reconnectActionsContext", null);
    _defineProperty$2i(this, "handlers", {});
  }
  doGetDOMNode() {
    return null;
  }
  // or not.

  doSetState(_state) {}
  // or EGW_AI_DRAG_OUT

  doTriggerEvent(_event, _data) {
    return false;
  }
  doMakeVisible() {}
  getDOMNode() {
    return this.doGetDOMNode();
  }
  getState() {
    return this._state;
  }
  makeVisible() {
    return this.doMakeVisible();
  }
  reconnectActions() {
    if (this.reconnectActionsCallback) {
      this.reconnectActionsCallback.call(this.reconnectActionsContext);
    }
  }
  setReconnectActionsCallback(_callback, _context) {
    this.reconnectActionsCallback = _callback;
    this.reconnectActionsContext = _context;
  }
  setState(_state) {
    //Call the doSetState function with the new state (if it has changed at all)
    if (_state != this._state) {
      this._state = _state;
      this.doSetState(_state);
    }
  }
  setStateChangeCallback(_callback, _context) {
    this.stateChangeCallback = _callback;
    this.stateChangeContext = _context;
  }
  triggerEvent(_event) {
    var _data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    return this.doTriggerEvent(_event, _data);
  }
  updateState(_stateBit, _set, _shiftState) {
    // Calculate the new state
    //this does not guarantee a valid state at runtime
    var newState = egwSetBit(this._state, _stateBit, _set);

    // Call the stateChangeCallback if the state really changed
    if (this.stateChangeCallback) {
      this._state = this.stateChangeCallback.call(this.stateChangeContext, newState, _stateBit, _shiftState);
    } else {
      this._state = newState;
    }
  }
}

/** egwActionObjectManager Object **/

/**
 * @deprecated implement upperCase class instead
 */
class egwActionObjectManager extends EgwActionObjectManager {}

/**
 * dragdrop
 */

/**
 * Register the drag and drop handlers
 */
if (typeof window._egwActionClasses == "undefined") window._egwActionClasses = {
  actionManager: undefined,
  default: undefined,
  drag: undefined,
  drop: undefined,
  popup: undefined
};

/**
 * @deprecated
 */
class egwDropAction extends EgwDropAction {}
window._egwActionClasses["drop"] = {
  "actionConstructor": EgwDropAction,
  "implementation": getDropImplementation
};

/**
 * @deprecated
 */
class egwDragAction extends EgwDragAction {}
(() => {
  window._egwActionClasses.drag = {
    "actionConstructor": EgwDragAction,
    "implementation": getDragImplementation
  };
})();
function getDragImplementation() {
  if (typeof window["_egwActionImpls"] != "object") {
    window["_egwActionImpls"] = {};
  }
  if (!window["_egwActionImpls"]._dragActionImpl) {
    window["_egwActionImpls"]._dragActionImpl = new EgwDragActionImplementation();
  }
  return window["_egwActionImpls"]._dragActionImpl;
}
function getDropImplementation() {
  if (typeof window["_egwActionImpls"] != "object") {
    window["_egwActionImpls"] = {};
  }
  if (!window["_egwActionImpls"]._dropActionImpl) {
    window["_egwActionImpls"]._dropActionImpl = new egwDropActionImplementation();
  }
  return window["_egwActionImpls"]._dropActionImpl;
}

function _defineProperty$2h(e, r, t) { return (r = _toPropertyKey$2g(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2g(t) { var i = _toPrimitive$2g(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2g(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * Generic interface object so any webComponent can participate in action system.
 * This interface can be extended if special handling is needed, but it should work
 * for any widget.
 */
class EgwEt2WidgetObject {
  constructor(node) {
    _defineProperty$2h(this, "node", null);
    _defineProperty$2h(this, "_state", EGW_AO_STATE_NORMAL || EGW_AO_STATE_VISIBLE);
    _defineProperty$2h(this, "handlers", void 0);
    _defineProperty$2h(this, "reconnectActionsContext", void 0);
    _defineProperty$2h(this, "stateChangeContext", void 0);
    this.node = node;
  }
  reconnectActionsCallback(p0) {}
  stateChangeCallback(p0) {}
  // @ts-ignore
  getDOMNode() {
    return this.node;
  }
  getWidget() {
    return this.node;
  }
  getState() {
    return this._state;
  }
  makeVisible() {}
  reconnectActions() {}
  setReconnectActionsCallback(_callback, _context) {}
  setState(_state) {
    this._state = _state;
  }
  setStateChangeCallback(_callback, _context) {}
  triggerEvent(_event, _data) {
    return false;
  }
  updateState(_stateBit, _set, _shiftState) {}
}

var _templateObject$1C, _templateObject2$_, _templateObject3$I;
function ownKeys$S(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$R(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$S(Object(t), !0).forEach(function (r) { _defineProperty$2g(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$S(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _taggedTemplateLiteral$1C(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
function _defineProperty$2g(e, r, t) { return (r = _toPropertyKey$2f(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2f(t) { var i = _toPrimitive$2f(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2f(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _applyDecoratedDescriptor$K(i, e, r, n, l) { var a = {}; return Object.keys(n).forEach(function (i) { a[i] = n[i]; }), a.enumerable = !!a.enumerable, a.configurable = !!a.configurable, ("value" in a || a.initializer) && (a.writable = !0), a = r.slice().reverse().reduce(function (r, n) { return n(i, e, r) || r; }, a), l && void 0 !== a.initializer && (a.value = a.initializer ? a.initializer.call(l) : void 0, a.initializer = void 0), void 0 === a.initializer ? (Object.defineProperty(i, e, a), null) : a; }
/**
 * This mixin will allow any LitElement to become an Et2Widget
 *
 * Usage:
 * @example
 * export class Et2Loading extends Et2Widget(BXLoading) { ... }
 * @example
 * export class Et2Button extends Et2InputWidget(Et2Widget(BXButton)) { ... }
 *
 * @see Mixin explanation https://lit.dev/docs/composition/mixins/
 */
function applyMixins(derivedCtor, baseCtors) {
  baseCtors.forEach(baseCtor => {
    Object.getOwnPropertyNames(baseCtor.prototype).forEach(name => {
      if (name !== 'constructor') {
        derivedCtor.prototype[name] = baseCtor.prototype[name];
      }
    });
  });
}
var Et2WidgetMixin = superClass => {
  var _dec, _class;
  var Et2WidgetClass = (_dec = e$p({
    type: Object
  }), (_class = class Et2WidgetClass extends superClass {
    /** WebComponent **/
    static get styles() {
      return [...(super.styles ? Array.isArray(super.styles) ? super.styles : [super.styles] : []), bootstrapIcons, i$h(_templateObject$1C || (_templateObject$1C = _taggedTemplateLiteral$1C(["\n\t\t\t\t\t:host([disabled]) {\n\t\t\t\t\t\tdisplay: none;\n\t\t\t\t\t}\n\n\t\t\t\t\t/* CSS to align internal inputs according to box alignment */\n\n\t\t\t\t\t:host([align=\"center\"]) .input-group__input {\n\t\t\t\t\t\tjustify-content: center;\n\t\t\t\t\t}\n\n\t\t\t\t\t:host([align=\"right\"]) .input-group__input {\n\t\t\t\t\t\tjustify-content: flex-end;\n\t\t\t\t\t}\n\n\t\t\t\t\t/* Put widget label to the left of the widget */\n\n\t\t\t\t\t::part(form-control), .form-control {\n\t\t\t\t\t\tdisplay: flex;\n\t\t\t\t\t\talign-items: center;\n\t\t\t\t\t\tflex-wrap: wrap;\n\t\t\t\t\t}\n\n\t\t\t\t\t::part(form-control-label), .form-control-label {\n\t\t\t\t\t\tflex: 0 0 auto;\n\t\t\t\t\t\twhite-space: normal;\n\t\t\t\t\t}\n\n\t\t\t\t\t.form-control--has-label .form-control-label {\n\t\t\t\t\t\tmargin-right: var(--sl-spacing-medium);\n\t\t\t\t\t}\n\n\t\t\t\t\t::part(form-control-input), .form-control-input {\n\t\t\t\t\t\tflex: 1 1 auto;\n\t\t\t\t\t\tposition: relative;\n\t\t\t\t\t\tmax-width: 100%;\n\t\t\t\t\t}\n\n\t\t\t\t\t::part(form-control-help-text), .form-control-help-text {\n\t\t\t\t\t\tflex-basis: 100%;\n\t\t\t\t\t\tposition: relative;\n\t\t\t\t\t}\n\n\t\t\t\t\t/* Use .et2-label-fixed class to give fixed label size */\n\n\t\t\t\t\t:host(.et2-label-fixed)::part(form-control-label), :host(.et2-label-fixed) .form-control-label {\n\t\t\t\t\t\twidth: initial;\n\t\t\t\t\t\twidth: var(--label-width, 8em);\n\t\t\t\t\t}\n\n\t\t\t\t\t:host(.et2-label-fixed)::part(form-control-help-text), :host(.et2-label-fixed) .form-control-help-text {\n\t\t\t\t\t\tleft: calc(var(--sl-spacing-medium) + var(--label-width, 8em));\n\t\t\t\t\t}\n            "])))];
    }
    static get properties() {
      return _objectSpread$R(_objectSpread$R({}, super.properties), {}, {
        /**
         * Widget ID.  Optional, and not always the same as the DOM ID if the widget is inside something
         * else that also has an ID.
         * Putting this in the properties() list causes the parent portion of the DOM ID to be duplicated
         * due to how LitElement processes the change
         */
        //id: {type: String, reflect: false},

        /**
         * CSS Class.  This class is applied to the _outside_, on the web component itself.
         * Due to how WebComponents work, this might not change anything inside the component.
         */
        class: {
          type: String,
          reflect: true
        },
        /**
         * Defines whether this widget is visibly disabled.
         *
         * The widget is still visible, but clearly cannot be interacted with.  Widgets disabled in the template
         * will not return a value to the application code, even if re-enabled via javascript before submitting.
         * To allow a disabled widget to be re-enabled and return a value, disable via javascript in the app's
         * et2_ready() instead of an attribute in the template file.
         */
        disabled: {
          type: Boolean,
          reflect: true
        },
        /**
         * The widget is not visible.
         *
         * As far as the user is concerned, the widget does not exist.  Widgets hidden with an attribute in the
         * template may not be created in the DOM, and will not return a value.  Widgets can be hidden after creation,
         * and they may return a value if hidden this way.
         */
        hidden: {
          type: Boolean,
          reflect: true
        },
        /**
         * Accesskey provides a hint for generating a keyboard shortcut for the current element.
         * The attribute value must consist of a single printable character.
         * @see https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/accesskey
         */
        accesskey: {
          type: String,
          reflect: true
        },
        /**
         * Widget ID of another node to insert this node into instead of the normal location
         * This isn't a normal property...
         */
        parentId: {
          type: String,
          noAccessor: true
        },
        /**
         * Tooltip which is shown for this element on hover
         */
        statustext: {
          type: String,
          reflect: true
        },
        /**
         * The label of the widget
         * This is usually displayed in some way.  It's also important for accessability.
         * This is defined in the parent somewhere, and re-defining it causes labels to disappear
         */
        label: {
          type: String
        },
        onclick: {
          type: Function
        },
        /*** Style type attributes ***/
        /**
         * Disable any translations for the widget
         */
        noLang: {
          type: Boolean,
          reflect: false
        },
        /**
         * Used by Et2Box to determine alignment.
         * Allowed values are left, right
         */
        align: {
          type: String,
          reflect: true
        },
        /**
         * comma-separated name:value pairs set as data attributes on DOM node
         * data="mime:${row}[mime]" would generate data-mime="..." in DOM, eg. to use it in CSS on a parent
         */
        data: {
          type: String,
          reflect: false
        },
        actions: {
          type: Object
        }
      });
    }

    /**
     * List of properties that get translated
     *
     * Done separately to not interfere with properties - if we re-define label property,
     * labels go missing.
     * @internal
     * @returns {{statustext : boolean, label : boolean}}
     */
    static get translate() {
      return {
        label: true,
        statustext: true
      };
    }

    /**
     * Widget Mixin constructor
     *
     * Note the ...args parameter and super() call
     *
     * @param args
     */
    constructor() {
      super(...arguments);
      _defineProperty$2g(this, "_mgrs", []);
      _defineProperty$2g(this, "_parent", null);
      _defineProperty$2g(this, "_inst", null);
      /**
       * et2_widget compatability
       * @deprecated Legacy compatability.  Some legacy widgets check their parent to see whats allowed
       **/
      _defineProperty$2g(this, "supportedWidgetClasses", []);
      /**
       * If we put the widget somewhere other than as a child of its parent, we need to record that so
       * we don't move it back to the parent.
       * @type {Element}
       * @internal
       */
      _defineProperty$2g(this, "_parent_node", void 0);
      /**
       * Not actually required by et2_widget, but needed to keep track of non-webComponent children
       */
      _defineProperty$2g(this, "_legacy_children", []);
      /**
       * Keep track of child widgets
       * This can differ from this.children, as it only includes the widgets where this.children will be child DOM nodes,
       * not guaranteed to be widgets
       */
      _defineProperty$2g(this, "_children", []);
      /**
       * Internal Properties - default values, and actually creating them as fields
       * Do not include public property defined in properties()
       */
      /**
       * Internal widget ID
       * @type {string}
       * @internal
       */
      _defineProperty$2g(this, "_widget_id", "");
      /**
       * Actual DOM ID, which is different from the widget ID
       * @type {string}
       * @internal
       */
      _defineProperty$2g(this, "_dom_id", "");
      /**
       * TypeScript & LitElement ensure type correctness, so we can't have a string value like "$row_cont[disable_me]"
       * as a boolean property so we store them here, and parse them when expanding.  Strings do not have this problem,
       * since $row_cont[disable_me] is still a valid string.
       * @internal
       */
      _defineProperty$2g(this, "_deferred_properties", {});
      _defineProperty$2g(this, "_actionManager", null);
      this.disabled = false;
      this._handleClick = this._handleClick.bind(this);

      // make all sizable widgets large by default on mobile template
      if (typeof egwIsMobile == "function" && egwIsMobile()) {
        this.size = "large";
      }
    }
    connectedCallback() {
      super.connectedCallback();
      this.addEventListener("click", this._handleClick);
      if (this.statustext && !egwIsMobile()) {
        this.bindTooltip();
      }
    }
    bindTooltip() {
      this.egw().tooltipBind(this, this.egw().lang(this.statustext));
    }
    disconnectedCallback() {
      var _this$egw;
      super.disconnectedCallback();
      (_this$egw = this.egw()) === null || _this$egw === void 0 || _this$egw.tooltipUnbind(this);
      this.removeEventListener("click", this._handleClick);

      // Delete all actions
      if (this.getInstanceManager() && this.getInstanceManager().app) {
        try {
          var objectManager = egw_getAppObjectManager(false, this.getInstanceManager().app);
          var widget_object = objectManager === null || objectManager === void 0 ? void 0 : objectManager.getObjectById(this.id);
          if (widget_object) {
            widget_object.unregisterActions();
            widget_object.clear();
            widget_object.remove();
          }
        } catch (e) {}
      }
    }

    /**
     * NOT the setter, since we cannot add to the DOM before connectedCallback()
     *
     * TODO: This is not best practice.  Should just set property, DOM modification should be done in render
     * https://lit-element.polymer-project.org/guide/templates#design-a-performant-template
     *
     * @param value
     */
    set_label(value) {
      var oldValue = this.label;

      // Remove old
      var oldLabels = this.getElementsByClassName("et2_label");
      while (oldLabels[0]) {
        this.removeChild(oldLabels[0]);
      }
      this.__label = value;
      if (value) {
        if (this._labelNode) {
          this._labelNode.textContent = this.__label;
        } else {
          var label = document.createElement("span");
          label.classList.add("et2_label");
          label.textContent = this.__label;
          // We should have a slot in the template for the label
          label.slot = "label";
          this.appendChild(label);
          this.requestUpdate('label', oldValue);
        }
      }
    }

    /**
     * supports legacy set_statustext
     * @deprecated use this.statustext
     * @param value
     */
    set_statustext(value) {
      this.statustext = value;
    }
    set statustext(value) {
      var oldValue = this.__statustext;
      this.__statustext = value;
      this.requestUpdate("statustext", oldValue);
    }
    get statustext() {
      return this.__statustext;
    }

    /**
     * Wrapper on this.disabled because legacy had it.
     *
     * @deprecated Use widget.disabled for visually disabled, widget.hidden for visually hidden.
     * <a href="/getting-started/widgets/#disabled-vs-readonly-vs-hidden">Disabled vs Readonly vs Hidden</a>
     *
     * @param {boolean} value
     */
    set_disabled(value) {
      var oldValue = this.disabled;
      this.disabled = value;
      this.hidden = value;
      this.requestUpdate("disabled", oldValue);
    }

    /**
     * Get the actual DOM ID, which has been prefixed to make sure it's unique.
     *
     * @returns {string}
     */
    get dom_id() {
      return this.getAttribute("id");
    }

    /**
     * Set the ID of the widget
     *
     * This is the "widget" ID, which is used as an index into the managed arrays (content, etc) and when
     * trying to find widgets by ID.
     *
     * This is not the DOM ID.
     *
     * @param {string} value
     */
    set id(value) {
      this._widget_id = value;
      var dom_id = "";
      if (this._widget_id) {
        // Create a namespace for this object with new ID
        if (this._createNamespace()) {
          this.checkCreateNamespace();
        }
        var path = this.getPath();
        if (this.getInstanceManager()) {
          path.unshift(this.getInstanceManager().uniqueId);
        }
        path.push(value.replace(/\./g, '-'));
        dom_id = path.join("_");
      }
      this.setAttribute("id", dom_id);
      this.requestUpdate("id");
    }

    /**
     * Get the ID of the widget
     *
     * @returns {string}
     */
    get id() {
      return this._widget_id;
    }

    /**
     * Set the dataset from a CSV
     * @param {string} value
     */
    set data(value) {
      // Clear existing
      Object.keys(this.dataset).forEach(dataKey => {
        delete this.dataset[dataKey];
      });
      var data = value.split(",");
      data.forEach(field => {
        var f = field.split(":");
        if (f[0] && typeof f[1] !== "undefined") {
          this.dataset[f[0]] = f[1];
        }
      });
    }
    get data() {
      var data = [];
      Object.keys(this.dataset).forEach(k => {
        data.push(k + ":" + this.dataset[k]);
      });
      return data.join(",");
    }

    /**
     * Set Actions on the widget
     *
     * Each action is defined as an object:
     *
     * move: {
     *      type: "drop",
     *      acceptedTypes: "mail",
     *      icon:   "move",
     *      caption:	"Move to"
     *      onExecute:      javascript:mail_move"
     * }
     *
     * This will turn the widget into a drop target for "mail" drag types.  When "mail" drag types are dropped,
     * the global function mail_move(egwAction action, egwActionObject sender) will be called.  The ID of the
     * dragged "mail" will be in sender.id, some information about the sender will be in sender.context.  The
     * etemplate2 widget involved can typically be found in action.parent.data.widget, so your handler
     * can operate in the widget context easily.  The location varies depending on your action though.  It
     * might be action.parent.parent.data.widget
     *
     * To customise how the actions are handled for a particular widget, override _link_actions().  It handles
     * the more widget-specific parts.
     *
     * @param {object} actions {ID: {attributes..}+} map of egw action information
     * @see api/src/Etemplate/Widget/Nextmatch.php egw_actions() method
     */
    set actions(actions) {
      if (!(Array.isArray(actions) && actions.length > 0 || Object.entries(actions).length > 0)) {
        // Not trying to clear actions, just called automatic
        if (!this._actionManager) {
          return;
        }
      }
      if (this.id == "" || typeof this.id == "undefined") {
        this.egw().debug("warn", "Widget should have an ID if you want actions", this);
        return;
      }

      // Initialize the action manager and add some actions to it
      if (this._actionManager == null) {
        var _this$getInstanceMana, _this$getInstanceMana2;
        // Find the apropriate parent action manager
        var parent_am = null;
        var widget = this;
        while (widget.getParent() && !parent_am) {
          // @ts-ignore
          if (widget._actionManager) {
            // @ts-ignore
            parent_am = widget._actionManager;
          }
          widget = widget.getParent();
        }
        if (!parent_am) {
          // Only look 1 level deep
          parent_am = egw_getActionManager(this.egw().appName, true, 1);
        }
        if (parent_am.getActionById((_this$getInstanceMana = (_this$getInstanceMana2 = this.getInstanceManager()) === null || _this$getInstanceMana2 === void 0 ? void 0 : _this$getInstanceMana2.uniqueId) !== null && _this$getInstanceMana !== void 0 ? _this$getInstanceMana : "", 1) !== null) {
          var _this$getInstanceMana3, _this$getInstanceMana4;
          parent_am = parent_am.getActionById((_this$getInstanceMana3 = (_this$getInstanceMana4 = this.getInstanceManager()) === null || _this$getInstanceMana4 === void 0 ? void 0 : _this$getInstanceMana4.uniqueId) !== null && _this$getInstanceMana3 !== void 0 ? _this$getInstanceMana3 : "", 1);
        }
        if (parent_am.getActionById(this.id, 1) != null) {
          this._actionManager = parent_am.getActionById(this.id, 1);
        } else {
          this._actionManager = parent_am.addAction("actionManager", this.id);
        }
      }
      this._actionManager.updateActions(actions, this.egw().appName);

      // Put a reference to the widget into the action stuff, so we can
      // easily get back to widget context from the action handler
      this._actionManager.data = {
        widget: this
      };

      // Link the actions to the DOM
      this._link_actions(actions);
    }
    get actions() {
      var _this$_actionManager;
      return ((_this$_actionManager = this._actionManager) === null || _this$_actionManager === void 0 ? void 0 : _this$_actionManager.children) || {};
    }

    /**
     * Get all action-links / id's of 1.-level actions from a given action object
     *
     * This can be overwritten to not allow all actions, by not returning them here.
     *
     * @param actions
     * @returns {Array}
     */
    _get_action_links(actions) {
      var action_links = [];
      for (var i in actions) {
        var action = actions[i];
        action_links.push(typeof action.id != 'undefined' ? action.id : i);
      }
      return action_links;
    }

    /**
     * Link the actions to the DOM nodes / widget bits.
     *
     * @param {object} actions {ID: {attributes..}+} map of egw action information
     */
    _link_actions(actions) {
      var _this$getInstanceMana5;
      // Get the top level element for the tree
      var objectManager = egw_getAppObjectManager(true, (_this$getInstanceMana5 = this.getInstanceManager()) === null || _this$getInstanceMana5 === void 0 ? void 0 : _this$getInstanceMana5.app);
      var widget_object = objectManager.getObjectById(this.id);
      if (widget_object == null || widget_object.manager !== this._actionManager) {
        // Add a new container to the object manager which will hold the widget
        // objects
        widget_object = objectManager.insertObject(false, new EgwActionObject(this.id, objectManager, this.createWidgetObjectInterface(), this._actionManager || objectManager.manager.getActionById(this.id) || objectManager.manager));
      } else {
        widget_object.setAOI(this.createWidgetObjectInterface());
      }

      // Delete all old objects
      widget_object.clear();
      widget_object.unregisterActions();

      // Go over the widget & add links - this is where we decide which actions are
      // 'allowed' for this widget at this time
      widget_object.updateActionLinks(this._get_action_links(actions));
    }
    createWidgetObjectInterface() {
      return new EgwEt2WidgetObject(this);
    }

    /**
     * A property has changed, and we want to make adjustments to other things
     * based on that
     *
     * @param  changedProperties
     */
    updated(changedProperties) {
      super.updated(changedProperties);

      // required changed, add / remove validator
      if (changedProperties.has('label')) {
        this._set_label(this.label);
      }
      if (changedProperties.has("statustext")) {
        this.egw().tooltipUnbind(this);
        if (this.statustext) {
          this.bindTooltip();
        }
      }
      if (changedProperties.has("onclick")) {
        this.classList.toggle("et2_clickable", this.onclick != null && typeof this.onclick != "undefined");
      }
    }

    /**
     * Any attribute that refers to row content cannot be resolved immediately, but some like booleans cannot stay a
     * string because it's a boolean attribute.  We store them for later, and parse when they're fully in their row.
     *
     * If you are creating a widget that can go in a nextmatch row, and it has boolean attributes that can change
     * for each row, add those attributes into deferredProperties
     */
    get deferredProperties() {
      return this._deferred_properties;
    }
    set deferredProperties(value) {
      this._deferred_properties = value;
    }

    /**
     * Do some fancy stuff on the label, splitting it up if there's a %s in it
     *
     * Normally called from updated(), the "normal" setter stuff has already been run before
     * this is called.  We only override our special cases (%s) because the normal label has
     * been set by the parent
     *
     * @param value
     * @protected
     */
    _set_label(value) {
      if (!this._labelNode) {
        return;
      }
      // Remove any existing post label
      var existing = Array.from(this.children).find(el => el.slot === "after" && el.tagName === "LABEL");
      if (existing) {
        this.removeChild(existing);
      }

      // Split the label at the "%s"
      var parts = et2_csvSplit(value, 2, "%s");
      if (parts.length > 1) {
        var after = document.createElement("label");
        after.slot = "after";
        after.textContent = parts[1];
        this.appendChild(after);
        this._labelNode.textContent = parts[0];
      }
    }
    set class(value) {
      var oldValue = this.classList.value;
      this.classList.value = value;
      this.requestUpdate('class', oldValue);
    }
    get class() {
      return this.classList.value;
    }

    /**
     * Set the widget class
     *
     * @deprecated Use this.class or this.classList instead
     * @param {string} new_class
     */
    set_class(new_class) {
      this.class = new_class;
    }

    /**
     * Event handlers
     */

    /**
     * Click handler calling custom handler set via onclick attribute to this.onclick
     *
     * @param _ev
     * @returns
     */
    _handleClick(_ev) {
      if (typeof this.onclick == 'function') {
        // Make sure function gets a reference to the widget, splice it in as 2. argument if not
        var args = Array.prototype.slice.call(arguments);
        if (args.indexOf(this) == -1) {
          args.splice(1, 0, this);
        }
        return this.onclick(...args);
      }
      return true;
    }

    /** et2_widget compatability
     * @deprecated
     **/
    destroy() {
      // Clear any deferred properties, functions may live in here
      this._deferred_properties = {};
      this.onclick = null;

      // Call the destructor of all children so any legacy widgets get destroyed
      for (var i = this.getChildren().length - 1; i >= 0; i--) {
        this.getChildren()[i].destroy();
        this.getChildren()[i] instanceof Et2WidgetClass && this.getChildren()[i].remove();
      }
      this._children.splice(0, this._children.length);
      this._legacy_children.splice(0, this._legacy_children.length);

      // Free the array managers if they belong to this widget
      for (var _key in this._mgrs) {
        if (this._mgrs[_key] && this._mgrs[_key].owner == this) {
          delete this._mgrs[_key];
        }
      }
      this._parent = null;
      this._inst = null;
      // if widget exists DOM-wise outside the parent, we need to explicitly remove it
      if (this._parent_node) this.remove();
    }
    isInTree() {
      // TODO: Probably should watch the state or something
      return true;
    }

    /**
     * Get property-values as object
     *
     * @deprecated use widget methods
     */
    get options() {
      var options = {};
      // @ts-ignore not sure how to tell TS this is a ReactiveElement and properties is a static getter
      for (var name in this.constructor.properties) {
        options[name] = this[name];
      }
      // adding attributes too
      this.getAttributeNames().forEach(name => {
        options[name] = this.getAttribute(name);
      });
      // add some (not declared) known properties
      if (typeof this.get_value === 'function') {
        options.value = this.get_value();
      }
      console.groupCollapsed("Deprecated widget.options use");
      console.trace("Something called widget.options on ", this);
      console.groupEnd();
      return options;
    }

    /**
     * Loads the widget tree from an XML node
     *
     * @param _node xml node
     */
    loadFromXML(_node) {
      // Load the child nodes.
      for (var i = 0; i < _node.childNodes.length; i++) {
        var node = _node.childNodes[i];
        var widgetType = node.nodeName.toLowerCase();
        if (widgetType == "#comment") {
          continue;
        }
        if (widgetType == "#text") {
          if (node.data.replace(/^\s+|\s+$/g, '')) {
            this.appendChild(node.cloneNode());
          }
          continue;
        }

        // Create the new element
        this.createElementFromNode(node);
      }
    }

    /**
     * Create a et2_widget from an XML node.
     *
     * First the type and attributes are read from the node.  Then the readonly & modifications
     * arrays are checked for changes specific to the loaded data.  Then the appropriate
     * constructor is called.  After the constructor returns, the widget has a chance to
     * further initialize itself from the XML node when the widget's loadFromXML() method
     * is called with the node.
     *
     * @param _node XML node to read
     * @param _name XML node name
     *
     * @return et2_widget
     */
    createElementFromNode(_node, _name) {
      var attributes = {};

      // Parse the "readonly" and "type" flag for this element here, as they
      // determine which constructor is used
      var _nodeName = attributes["type"] = _node.getAttribute("type") ? _node.getAttribute("type") : _node.nodeName.toLowerCase();
      var readonly = attributes["readonly"] = this.getArrayMgr("readonlys") ? this.getArrayMgr("readonlys").isReadOnly(_node.getAttribute("id"), _node.getAttribute("readonly"), typeof this.readonly !== "undefined" ? this.readonly : false) : false;

      // Check to see if modifications change type
      var modifications = this.getArrayMgr("modifications");
      if (modifications && _node.getAttribute("id")) {
        var entry = modifications.getEntry(_node.getAttribute("id"));
        if (entry == null) {
          // Try again, but skip the fancy stuff
          // TODO: Figure out why the getEntry() call doesn't always work
          entry = modifications.data[_node.getAttribute("id")];
          if (entry) {
            this.egw().debug("warn", "getEntry(" + _node.getAttribute("id") + ") failed, but the data is there.", modifications, entry);
          } else {
            // Try the root, in case a namespace got missed
            entry = modifications.getRoot().getEntry(_node.getAttribute("id"));
          }
        }
        if (entry && entry.type && typeof entry.type === 'string') {
          _nodeName = attributes["type"] = entry.type;
        }
        entry = null;
      }

      // if _nodeName / type-attribute contains something to expand (eg. type="@${row}[type]"),
      // we need to expand it now as it defines the constructor and by that attributes parsed via parseXMLAttrs!
      if (_nodeName.charAt(0) == '@' || _nodeName.indexOf('$') >= 0) {
        _nodeName = attributes["type"] = this.getArrayMgr('content').expandName(_nodeName);
      }

      // If using type attribute instead of nodeName makes things invalid, don't
      // Some widgets use their type attribute
      if (_node.hasAttribute("type") && !window.customElements.get(_nodeName) && typeof et2_registry[_nodeName] === "undefined" && window.customElements.get(_node.nodeName.toLowerCase())) {
        _nodeName = _node.nodeName.toLowerCase();
      }
      var widget;
      if (undefined == window.customElements.get(_nodeName)) {
        // Get the constructor - if the widget is readonly, use the special "_ro"
        // constructor if it is available
        if (typeof et2_registry[_nodeName] === "undefined") {
          _nodeName = 'placeholder';
        }
        var _constructor = et2_registry[_nodeName];
        if (readonly === true && typeof et2_registry[_nodeName + "_ro"] != "undefined") {
          _constructor = et2_registry[_nodeName + "_ro"];
        }

        // Parse the attributes from the given XML attributes object
        this.parseXMLAttrs(_node.attributes, attributes, _constructor.prototype);

        // Do an sanity check for the attributes
        ClassWithAttributes.generateAttributeSet(et2_attribute_registry[_constructor.name], attributes);

        // Creates the new widget, passes this widget as an instance and
        // passes the widgetType. Then it goes on loading the XML for it.
        widget = new _constructor(this, attributes);

        // Load the widget itself from XML
        widget.loadFromXML(_node);
      } else {
        widget = loadWebComponent(_nodeName, _node, this);
        if (this.addChild && widget) {
          // webcomponent going into old et2_widget
          this.addChild(widget);
        }
      }
      return widget;
    }

    /**
     * The parseXMLAttrs function takes an XML DOM attributes object
     * and adds the given attributes to the _target associative array. This
     * function also parses the legacyOptions.
     *
     * N.B. This is only used for legacy widgets.  WebComponents use transformAttributes() and
     * do their own handling of attributes.
     *
     * @param _attrsObj is the XML DOM attributes object
     * @param {object} _target is the object to which the attributes should be written.
     * @param {et2_widget} _proto prototype with attributes and legacyOptions attribute
     */
    parseXMLAttrs(_attrsObj, _target, _proto) {
      // Check whether the attributes object is really existing, if not abort
      if (typeof _attrsObj == "undefined") {
        return;
      }

      // Iterate over the given attributes and parse them
      var mgr = this.getArrayMgr("content");
      for (var i = 0; i < _attrsObj.length; i++) {
        var attrName = _attrsObj[i].name;
        var attrValue = _attrsObj[i].value;

        // Special handling for the legacy options
        if (attrName == "options" && _proto.constructor.legacyOptions && _proto.constructor.legacyOptions.length > 0) {
          var legacy = _proto.constructor.legacyOptions || [];
          // Check for modifications on legacy options here.  Normal modifications
          // are handled in widget constructor, but it's too late for legacy options then
          if (_target.id && this.getArrayMgr("modifications").getEntry(_target.id)) {
            var mod = this.getArrayMgr("modifications").getEntry(_target.id);
            if (typeof mod.options != "undefined") {
              attrValue = _attrsObj[i].value = mod.options;
            }
          }
          // expand legacyOptions with content
          if (attrValue.charAt(0) == '@' || attrValue.indexOf('$') != -1) {
            attrValue = mgr.expandName(attrValue);
          }

          // Parse the legacy options (as a string, other types not allowed)
          var splitted = et2_csvSplit(attrValue + "");
          for (var j = 0; j < splitted.length && j < legacy.length; j++) {
            // Blank = not set, unless there's more legacy options provided after
            if (splitted[j].trim().length === 0 && legacy.length >= splitted.length) {
              continue;
            }

            // Check to make sure we don't overwrite a current option with a legacy option
            if (typeof _target[legacy[j]] === "undefined") {
              attrValue = splitted[j];

              /**
              If more legacy options than expected, stuff them all in the last legacy option
              Some legacy options take a comma separated list.
               */
              if (j == legacy.length - 1 && splitted.length > legacy.length) {
                attrValue = splitted.slice(j);
              }
              var attr = et2_attribute_registry[_proto.constructor.name][legacy[j]] || {};

              // If the attribute is marked as boolean, parse the
              // expression as bool expression.
              if (attr.type == "boolean") {
                attrValue = mgr.parseBoolExpression(attrValue);
              } else if (typeof attrValue != "object") {
                attrValue = mgr.expandName(attrValue);
              }
              _target[legacy[j]] = attrValue;
            }
          }
        } else if (attrName == "readonly" && typeof _target[attrName] != "undefined") {
          // do NOT overwrite already evaluated readonly attribute
        } else {
          var attrs = et2_attribute_registry[_proto.constructor.name] || {};
          if (mgr != null && typeof attrs[attrName] != "undefined") {
            var _attr = attrs[attrName];

            // If the attribute is marked as boolean, parse the
            // expression as bool expression.
            if (_attr.type == "boolean") {
              attrValue = mgr.parseBoolExpression(attrValue);
            } else {
              attrValue = mgr.expandName(attrValue);
            }
          }

          // Set the attribute
          _target[attrName] = attrValue;
        }
      }
    }
    transformAttributes(attrs) {
      var _this$getArrayMgr;
      transformAttributes(this, this.getArrayMgr("content"), attrs);

      // Add in additional modifications
      if (this.id && (_this$getArrayMgr = this.getArrayMgr("modifications")) !== null && _this$getArrayMgr !== void 0 && _this$getArrayMgr.getEntry(this.id)) {
        transformAttributes(this, this.getArrayMgr("content"), this.getArrayMgr("modifications").getEntry(this.id));
      }
    }
    iterateOver(_callback, _context, _type) {
      if (this.disabled) {
        // Don't if we're disabled
        return;
      }
      if (typeof _type === "undefined" || _type === et2_widget || _type === Et2Widget || typeof _type === 'function' && this instanceof _type || et2_implements_registry[_type] && et2_implements_registry[_type](this)) {
        _callback.call(_context, this);
      }

      // Ask children
      for (var i = 0; i < this._children.length; i++) {
        this._children[i].iterateOver(_callback, _context, _type);
      }
    }

    /**
     * Needed for legacy compatability.
     *
     * @param {Promise[]} promises List of promises from widgets that are not done.  Pass an empty array, it will be filled if needed.
     */
    loadingFinished(promises) {
      if (typeof promises === "undefined") {
        promises = [];
      }
      // Note that WebComponents don't do anything here, their lifecycle is different
      // This is just to support legacy widgets
      var doLoadingFinished = () => {
        var _this$childNodes$;
        /**
         * This is needed mostly as a bridge between non-WebComponent widgets and
         * connectedCallback().  It's not really needed if the whole tree is WebComponent.
         * WebComponents can be added as children immediately after creation, and they handle the
         * rest themselves with their normal lifecycle (especially connectedCallback(), which is kind
         * of the equivalent of doLoadingFinished()
         */
        // @ts-ignore this is not an et2_widget, so getDOMNode(this) is bad
        if (!this._parent_node && this.getParent() instanceof et2_widget && this.getParent().getDOMNode(this) != this.parentNode) {
          var _getDOMNode;
          // @ts-ignore this is not an et2_widget, and Et2Widget is not a Node
          (_getDOMNode = this.getParent().getDOMNode(this)) === null || _getDOMNode === void 0 || _getDOMNode.append(this);
        }

        // An empty text node causes problems with legacy widget children
        // It throws off their insertion indexing, making them get added in the wrong place
        if (((_this$childNodes$ = this.childNodes[0]) === null || _this$childNodes$ === void 0 ? void 0 : _this$childNodes$.nodeType) == this.TEXT_NODE && this.childNodes[0].textContent == "") {
          this.removeChild(this.childNodes[0]);
        }
        for (var i = 0; i < this.getChildren().length; i++) {
          var child = this.getChildren()[i];
          child.loadingFinished(promises);
        }
      };
      doLoadingFinished();
      var updateComplete = this.updateComplete;
      // Record widget for debug
      updateComplete["widget"] = this;
      promises.push(updateComplete);
    }
    getWidgetById(_id) {
      if (this.id == _id) {
        return this;
      }
      if (this.getChildren().length == 0) {
        return null;
      }
      var check_children = children => {
        for (var i = 0; i < children.length; i++) {
          var elem = children[i].getWidgetById(_id);
          if (elem != null) {
            return elem;
          }
        }
        if (this.id && _id.indexOf('[') > -1 && children.length) {
          var ids = new et2_arrayMgr().explodeKey(_id);
          var widget = this;
          while (widget && ids.length) {
            var joined = ids.join("[") + "]";
            var previous = widget;
            widget = widget.getWidgetById(ids.shift());
            if (!widget && previous !== this) {
              return previous.getWidgetById(joined);
            }
          }
          return widget;
        }
      };
      return check_children(this.getChildren()) || null;
    }

    /**
     * Parent is different than what is specified in the template / hierarchy.
     * Widget ID of another node to insert this node into instead of the normal location
     *
     * @param {string} parent
     */
    set parentId(parent) {
      this.__parentId = parent;
      this.updateComplete.then(() => {
        if (!this.__parentId) {
          return;
        }
        var parent = document.querySelector("#" + this.__parentId) || this.__parentId;
        if (parent && parent instanceof Element && parent !== this.parentNode) {
          this.remove();
          parent.append(this);
          this._parent_node = parent;
        }
      });
    }
    get parentId() {
      return this.__parentId;
    }
    setParent(new_parent) {
      this._parent = new_parent;
      if (this.id) {
        // Create a namespace for this object
        if (this._createNamespace()) {
          this.checkCreateNamespace();
        }
      }
      // @ts-ignore
      this._parent.addChild(this);
    }
    getParent() {
      if (this._parent) {
        return this._parent;
      }
      return null;
    }
    getParentDOMNode() {
      return this._parent_node;
    }
    addChild(child) {
      if (this._children.indexOf(child) >= 0) {
        return;
      }
      if (child instanceof et2_widget) {
        // Type of et2_widget._parent is et2_widget, not Et2Widget.  This might cause problems, but they
        // should be fixed by getting rid of the legacy widget with problems
        // @ts-ignore
        child._parent = this;

        // During legacy widget creation, the child's DOM node won't be available yet.
        this._legacy_children.push(child);
        var child_node = null;
        try {
          //@ts-ignore Technically getDOMNode() is from et2_DOMWidget
          child_node = typeof child.getDOMNode !== "undefined" ? child.getDOMNode(child) : null;
        } catch (e) {
          // Child did not give up its DOM node nicely but errored instead
        }
        if (child_node && child_node !== this) {
          this.append(child_node);
        }
      } else {
        this.append(child);
      }
      this._children.push(child);
    }

    /**
     * Get child widgets
     * Use <obj>.children to get web component children
     * @returns {et2_widget[]}
     */
    getChildren() {
      return this._children;
    }
    getType() {
      return this.nodeName;
    }
    getDOMNode() {
      return this;
    }

    /**
     * Creates a copy of this widget.
     *
     * @param {et2_widget} _parent parent to set for clone, default null
     */
    clone(_parent) {
      // Default _parent to null
      if (typeof _parent == "undefined") {
        _parent = null;
      }

      // Create the copy
      var copy = this.cloneNode();
      copy.id = this._widget_id;
      if (_parent) {
        copy.setParent(_parent);
      } else {
        // Copy a reference to the content array manager
        copy.setArrayMgrs(this.getArrayMgrs());

        // Pass on instance too
        copy.setInstanceManager(this.getInstanceManager());
      }
      var widget_class = window.customElements.get(this.localName);
      var properties = widget_class ? widget_class.elementProperties : [];
      properties.forEach((v, key) => {
        copy[key] = this[key];
      });

      // Keep the deferred properties
      copy._deferred_properties = this._deferred_properties;

      // Create a clone of all child widgets of the given object
      for (var i = 0; i < this.getChildren().length; i++) {
        this.getChildren()[i].clone(copy);
      }
      return copy;
    }

    /**
     * Sets the array manager for the given part
     *
     * @param {string} _part which array mgr to set
     * @param {object} _mgr
     */
    setArrayMgr(_part, _mgr) {
      this._mgrs[_part] = _mgr;
    }

    /**
     * Returns the array manager object for the given part
     *
     * @param {string} managed_array_type name of array mgr to return
     */
    getArrayMgr(managed_array_type) {
      if (this._mgrs && typeof this._mgrs[managed_array_type] != "undefined") {
        return this._mgrs[managed_array_type];
      } else if (this.getParent()) {
        return this.getParent().getArrayMgr(managed_array_type);
      }
      return null;
    }

    /**
     * Sets all array manager objects - this function can be used to set the
     * root array managers of the container object.
     *
     * @param {object} _mgrs
     */
    setArrayMgrs(_mgrs) {
      this._mgrs = et2_cloneObject(_mgrs);
    }

    /**
     * Returns an associative array containing the top-most array managers.
     *
     * @param _mgrs is used internally and should not be supplied.
     */
    getArrayMgrs(_mgrs) {
      if (typeof _mgrs == "undefined") {
        _mgrs = {};
      }

      // Add all managers of this object to the result, if they have not already
      // been set in the result
      for (var _key2 in this._mgrs) {
        if (typeof _mgrs[_key2] == "undefined") {
          _mgrs[_key2] = this._mgrs[_key2];
        }
      }

      // Recursively applies this function to the parent widget
      if (this._parent) {
        this._parent.getArrayMgrs(_mgrs);
      }
      return _mgrs;
    }

    /**
     * Checks whether a namespace exists for this element in the content array.
     * If yes, an own perspective of the content array is created. If not, the
     * parent content manager is used.
     *
     * Constructor attributes are passed in case a child needs to make decisions
     */
    checkCreateNamespace() {
      // Get the content manager
      var mgrs = this.getArrayMgrs();
      for (var _key3 in mgrs) {
        var mgr = mgrs[_key3];

        // Get the original content manager if we have already created a
        // perspective for this node
        if (typeof this._mgrs[_key3] != "undefined" && mgr.perspectiveData.owner == this) {
          mgr = mgr.getParentMgr();
        }

        // Check whether the manager has a namespace for the id of this object
        var entry = mgr.getEntry(this.id);
        if (typeof entry === 'object' && entry !== null || this.id) {
          // The content manager has an own node for this object, so
          // create an own perspective.
          this._mgrs[_key3] = mgr.openPerspective(this, this.id);
        } else {
          // The current content manager does not have an own namespace for
          // this element, so use the content manager of the parent.
          delete this._mgrs[_key3];
        }
      }
    }

    /**
     * Set the instance manager
     * Normally this is not needed as it's set on the top-level container, and we just return that reference
     *
     */
    setInstanceManager(manager) {
      this._inst = manager;
    }

    /**
     * Returns the instance manager
     *
     * @return {etemplate2}
     */
    getInstanceManager() {
      var _this$getRootNode;
      if (this._inst != null) {
        return this._inst;
      } else if (this.getParent()) {
        return this.getParent().getInstanceManager ? this.getParent().getInstanceManager() : null;
      }
      // Widget might be inside another widget, in which case getParent() is null
      // @ts-ignore host does not always exist on getRootNode()
      else if (this.getRootNode() && typeof ((_this$getRootNode = this.getRootNode()) === null || _this$getRootNode === void 0 || (_this$getRootNode = _this$getRootNode.host) === null || _this$getRootNode === void 0 ? void 0 : _this$getRootNode.getParent) == "function") {
        var _this$getRootNode$hos;
        // @ts-ignore host does not always exist on getRootNode()
        return (_this$getRootNode$hos = this.getRootNode().host.getParent()) === null || _this$getRootNode$hos === void 0 ? void 0 : _this$getRootNode$hos.getInstanceManager();
      }
      return null;
    }

    /**
     * Returns the base widget
     * Usually this is the same as getInstanceManager().widgetContainer
     */
    getRoot() {
      var _this$getRootNode2;
      if (this.getParent() != null) {
        return this.getParent().getRoot();
      }
      // Widget might be inside another widget, in which case getParent() is null
      // @ts-ignore host does not always exist on getRootNode()
      else if (this.getRootNode() && typeof ((_this$getRootNode2 = this.getRootNode()) === null || _this$getRootNode2 === void 0 || (_this$getRootNode2 = _this$getRootNode2.host) === null || _this$getRootNode2 === void 0 ? void 0 : _this$getRootNode2.getParent) == "function" && this.getRootNode().host.getParent()) {
        // @ts-ignore host does not always exist on getRootNode()
        return this.getRootNode().host.getParent();
      } else {
        return this;
      }
    }

    /**
     * Returns the path into the data array.  By default, array manager takes care of
     * this, but some extensions need to override this
     */
    getPath() {
      var _this$getArrayMgr$get, _this$getArrayMgr2;
      var path = (_this$getArrayMgr$get = (_this$getArrayMgr2 = this.getArrayMgr("content")) === null || _this$getArrayMgr2 === void 0 ? void 0 : _this$getArrayMgr2.getPath()) !== null && _this$getArrayMgr$get !== void 0 ? _this$getArrayMgr$get : [];

      // Prevent namespaced widgets with value from going an extra layer deep
      if (this.id && this._createNamespace() && path[path.length - 1] == this.id) {
        path.pop();
      }
      return path;
    }
    _createNamespace() {
      return false;
    }
    egw() {
      if (this.getParent() != null && typeof this.getParent().egw === "function") {
        return this.getParent().egw();
      }
      // Get the window this object belongs to
      var wnd = null;
      // @ts-ignore Technically this doesn't have implements(), but it's mixed in
      if (this.implements(et2_IDOMNode)) {
        var node = this.getDOMNode();
        if (node && node.ownerDocument) {
          wnd = node.ownerDocument.parentNode || node.ownerDocument.defaultView;
        }
      }

      // If we're the root object, return the phpgwapi API instance
      var egwInstance = typeof egw$1 === "function" ? egw$1('phpgwapi', wnd) : window['egw'] ? window['egw'] : null;

      // Make sure required methods are there
      // These methods are used inside widgets, but may not always be available depending on egw() loading (tests, docs)
      var required = {
        debug: () => {
          console.log(arguments);
        },
        image: () => "",
        lang: l => {
          return l;
        },
        preference: () => {
          return false;
        }
      };
      for (var functionName in required) {
        if (egwInstance && typeof egwInstance[functionName] !== "function") {
          egwInstance[functionName] = required[functionName];
        }
      }
      return egwInstance;
    }
  }, (_applyDecoratedDescriptor$K(_class.prototype, "actions", [_dec], Object.getOwnPropertyDescriptor(_class.prototype, "actions"), _class.prototype)), _class)); // Add some more stuff in
  applyMixins(Et2WidgetClass, [ClassWithInterfaces]);
  return Et2WidgetClass;
};
var Et2Widget = dedupeMixin(Et2WidgetMixin);

/**
 * Load a Web Component
 * @param _nodeName
 * @param _template_node
 * @param parent Parent widget
 */
// @ts-ignore Et2Widget is I guess not the right type
function loadWebComponent(_nodeName, _template_node, parent) {
  var _parent$options;
  var attrs = {};
  var load_children = true;

  // support attributes object instead of an Element
  if (typeof _template_node.getAttribute === 'undefined') {
    attrs = _template_node;
    load_children = false;
  } else {
    _template_node.getAttributeNames().forEach(attribute => {
      attrs[attribute] = _template_node.getAttribute(attribute);
    });
  }

  // Try to find the class for the given node
  var mobile = typeof egwIsMobile != "undefined" && egwIsMobile();
  if (mobile && typeof window.customElements.get(_nodeName + "_mobile") != "undefined") {
    _nodeName += "_mobile";
  }
  var widget_class = window.customElements.get(_nodeName);
  if (!widget_class) {
    // Given node has no registered class.  Try some of our special things (remove type, fallback to actual node)
    var tries = [_nodeName.split('-')[0]];
    if (_template_node.nodeName) {
      tries = tries.concat(_template_node.nodeName.toLowerCase());
    }
    for (var i = 0; i < tries.length && !window.customElements.get(_nodeName); i++) {
      _nodeName = tries[i];
    }
    widget_class = window.customElements.get(_nodeName);
    if (!widget_class) {
      debugger;
      throw Error("Unknown or unregistered WebComponent '" + _nodeName + "', could not find class.  Also checked for " + tries.join(','));
    }
  }

  // Don't need to create hidden elements
  if (parent !== null && parent !== void 0 && parent.hidden || attrs["hidden"] && parent !== null && parent !== void 0 && parent.getArrayMgr("content") && parent.getArrayMgr("content").parseBoolExpression(attrs["hidden"])) {
    //return null;
  }
  var readonly = parent !== null && parent !== void 0 && parent.getArrayMgr("readonlys") ? parent.getArrayMgr("readonlys").isReadOnly(attrs["id"], attrs["readonly"], typeof (parent === null || parent === void 0 ? void 0 : parent.readonly) !== "undefined" ? parent.readonly : ((_parent$options = parent.options) === null || _parent$options === void 0 ? void 0 : _parent$options.readonly) || false) : false;
  if (readonly === true && typeof window.customElements.get(_nodeName + "_ro") != "undefined") {
    _nodeName += "_ro";
  }

  // @ts-ignore
  var widget = document.createElement(_nodeName);
  if (parent && typeof widget.setParent === 'function') widget.setParent(parent);

  // Set read-only.  Doesn't really matter if it's a ro widget, but otherwise it needs set
  widget.readonly = readonly;
  delete attrs.readonly;
  widget.transformAttributes(attrs);

  // Children need to be loaded
  if (load_children) {
    widget.loadFromXML(_template_node);
  }
  return widget;
}

/**
 * Take attributes from a node in a .xet file and apply those to a WebComponent widget
 *
 * Any attributes provided that match a property (or attribute) on the widget will be adjusted according to
 * the passed arrayManager, coerced into the proper type, and set.
 * It is here that we find values or set attributes that should come from content.
 *
 * @param widget
 * @param {et2_arrayMgr} mgr
 * @param attributes
 */
function transformAttributes(widget, mgr, attributes) {
  var widget_class = window.customElements.get(widget.localName);

  // Special case attributes
  if (attributes.attributes) {
    // Attributes in content? "attributes" is read-only in webComponent
    var mgr_attributes = mgr.getEntry(attributes.attributes);
    delete attributes.attributes;
    if (mgr_attributes) {
      Object.assign(attributes, ...mgr_attributes);
    }
  }
  if (attributes.width) {
    widget.style.setProperty("width", attributes.width);
    widget.style.setProperty("flex", "0 0 auto");
    delete attributes.width;
  }
  if (attributes.height) {
    widget.style.setProperty("height", attributes.height);
    delete attributes.height;
  }

  // Apply any set attributes - widget will do its own coercion
  for (var attribute in attributes) {
    var attrValue = attributes[attribute];

    // If there is no attribute set, ignore it.  Widget sets its own default.
    if (typeof attrValue === "undefined") {
      continue;
    }

    // preprocessor and transformer can't know if application widget is a web-component or a legacy one
    // translate attribute names to camelCase (only do it for used underscore, to not require a regexp)
    if (attribute !== 'select_options' && attribute.indexOf('_') !== -1) {
      var parts = attribute.split('_');
      if (attribute === 'parent_node') parts[1] = 'Id';
      attribute = parts.shift() + parts.map(part => part[0].toUpperCase() + part.substring(1)).join("");
    }
    var _property = widget_class.getPropertyOptions(attribute);
    switch (typeof _property === "object" ? _property.type : _property) {
      case Boolean:
        if (typeof attrValue == "boolean") {
          // Already boolean, nothing needed
          break;
        }
        // If the attribute is marked as boolean, parse the
        // expression as bool expression.
        attrValue = mgr ? mgr.parseBoolExpression(attrValue) : attrValue;
        if (typeof attrValue === "string") {
          // Parse decided we still needed a string ($row most likely) so we'll defer it until later
          // Repeating rows & nextmatch will parse it again when doing the row
          widget.deferredProperties[attribute] = attrValue;
          // Leave the current value at whatever the default is
          continue;
        }
        break;
      case Function:
        if (typeof attrValue == "string" && mgr && mgr.getPerspectiveData().row == null && (attrValue.indexOf("$row") > -1 || attrValue.indexOf("$row_cont") > -1)) {
          // Need row context, defer it until later
          // Repeating rows & nextmatch will parse it again when doing the row
          widget.deferredProperties[attribute] = attrValue;
          console.log("Had to defer %s parsing for %o\nCan it be rewritten to avoid $row & $row_cont?", attribute, widget);
          break;
        }
        // We parse it into a function here so we can pass in the widget as context.
        // Leaving it to the LitElement conversion loses the widget as context
        if (typeof attrValue !== "function") {
          attrValue = et2_compileLegacyJS(attrValue, widget, widget);
        }
        break;
      case Object:
      case Array:
        // Leave it alone if it's not a string
        if (typeof attrValue !== "string") {
          break;
        }
      // fall through to look in content
      default:
        attrValue = mgr ? mgr.expandName("" + attrValue) : attrValue;
        if (attrValue && typeof attrValue == "string" && widget_class.translate[attribute]) {
          // allow attribute to contain multiple translated sub-strings eg: {Firstname}.{Lastname}
          if (attrValue.indexOf('{') !== -1) {
            attrValue = attrValue.replace(/{([^}]+)}/g, (str, p1) => {
              return widget.egw().lang(p1);
            });
          } else {
            attrValue = widget.egw().lang(attrValue);
          }
        } else if (attrValue && [Object, Array, Number].indexOf(typeof _property === "object" ? _property.type : _property) != -1) {
          // Value was not supposed to be a string, but was run through here for expandName
          try {
            attrValue = JSON.parse(attrValue);
          } catch (e) {
            console.info(widget_class.name + "#" + widget.id + " attribute '" + attribute + "' has type " + (typeof _property === "object" ? _property.type.name : _property.name) + " but value %o could not be parsed", attrValue);
          }
        }
        break;
    }

    // Bind handlers directly, since we can do that now.  Event handlers still need to be defined
    // in properties() as {type: Function}, but this will take care of the binding.  This is
    // separate from internal events.
    // (handlers can only be bound _after_ the widget is added to the DOM
    if (attribute.startsWith("on") && typeof attrValue == "function") {
      //widget.updateComplete.then(() => addEventListener(attribute, attrValue));
    }

    // Set as attribute or property, as appropriate.  Don't set missing attributes.
    if (widget.getAttributeNames().indexOf(attribute) >= 0 || _property.reflect && attrValue) {
      // Set as attribute (reflected in DOM)
      widget.setAttribute(attribute, attrValue === true ? "" : attrValue);
    } else if (attribute === 'options') {
      console.trace('Ignored setting depricated "options" attribute for widget #' + widget.id, widget);
      continue;
    }
    // Set as property
    var old_value = widget[attribute];
    widget[attribute] = attrValue;
    // Due to reactive properties not updating properly, make sure to trigger an update
    widget.requestUpdate(attribute, old_value);
  }
  if (widget_class.getPropertyOptions("value") && widget.set_value) {
    if (mgr != null) {
      var val = mgr.getEntry(widget.id, false, true);
      if (val !== null) {
        widget.set_value(val);
      }
    }
  }
}

/**
 * Take the name of one of our images, find the full URL (including theme), and wrap it up so you can use it in a
 * widget's css block.
 *
 * @example
 * import {cssImage} from Et2Widget;
 * ...
 * static get styles()
 * {
 * 		return [
 * 			...super.styles,
 * 			css`
 * 			:host {
 * 				background-image: ${cssImage("save")};
 *			}
 *		`];
 *	}
 * @param image_name Name of the image
 * @param app_name Optional, image is from an app instead of api
 * @returns {CSSResult}
 */
function cssImage(image_name, app_name) {
  var url = (egw$1 === null || egw$1 === void 0 ? void 0 : egw$1.image) && (egw$1 === null || egw$1 === void 0 ? void 0 : egw$1.image(image_name, app_name));
  if (url) {
    return i$h(_templateObject2$_ || (_templateObject2$_ = _taggedTemplateLiteral$1C(["url(", ")"])), r$h(url));
  } else {
    return i$h(_templateObject3$I || (_templateObject3$I = _taggedTemplateLiteral$1C([""])));
  }
}

function _defineProperty$2f(e, r, t) { return (r = _toPropertyKey$2e(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2e(t) { var i = _toPrimitive$2e(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2e(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class ClassWithInterfaces {
  /**
   * The implements function can be used to check whether the object
   * implements the given interface.
   *
   * As TypeScript can not (yet) check if an objects implements an interface on runtime,
   * we currently implements with each interface a function called 'implements_'+interfacename
   * to be able to check here.
   *
   * @param _iface name of interface to check
   */
  implements(_iface_name) {
    if (typeof et2_implements_registry[_iface_name] === 'function' && et2_implements_registry[_iface_name](this)) {
      return true;
    }
    return false;
  }

  /**
   * Check if object is an instance of a class or implements an interface (specified by the interfaces name)
   *
   * @param _class_or_interfacename class(-name) or string with name of interface
   */
  instanceOf(_class_or_interfacename) {
    if (typeof _class_or_interfacename === 'string') {
      return this.implements(_class_or_interfacename);
    }
    if (_class_or_interfacename === Et2Widget) {
      return true;
    }
    return this instanceof _class_or_interfacename;
  }
}
class ClassWithAttributes extends ClassWithInterfaces {
  constructor() {
    super(...arguments);
    /**
     * Object to collect the attributes we operate on
     */
    _defineProperty$2f(this, "attributes", void 0);
  }
  /**
   * Returns the value of the given attribute. If the property does not
   * exist, an error message is issued.
   *
   * @param {string} _name
   * @return {*}
   */
  getAttribute(_name) {
    if (typeof this.attributes[_name] != "undefined" && !this.attributes[_name].ignore) {
      if (typeof this["get_" + _name] == "function") {
        return this["get_" + _name]();
      } else {
        return this[_name];
      }
    } else {
      egw$1.debug("error", this, "Attribute '" + _name + "' does not exist!");
    }
  }

  /**
   * The setAttribute function sets the attribute with the given name to
   * the given value. _override defines, whether this[_name] will be set,
   * if this key already exists. _override defaults to true. A warning
   * is issued if the attribute does not exist.
   *
   * @param {string} _name
   * @param {*} _value
   * @param {boolean} _override
   */
  setAttribute(_name, _value, _override) {
    if (typeof this.attributes[_name] != "undefined") {
      if (!this.attributes[_name].ignore) {
        if (typeof _override == "undefined") {
          _override = true;
        }
        var val = et2_checkType(_value, this.attributes[_name].type, _name, this);
        if (typeof this["set_" + _name] == "function") {
          this["set_" + _name](val);
        } else if (_override || typeof this[_name] == "undefined") {
          this[_name] = val;
        }
      }
    } else {
      egw$1.debug("warn", this, "Attribute '" + _name + "' does not exist!");
    }
  }

  /**
   * generateAttributeSet sanitizes the given associative array of attributes
   * (by passing each entry to "et2_checkType" and checking for existance of
   * the attribute) and adds the default values to the associative array.
   *
   * @param {object} _attrs is the associative array containing the attributes.
   */
  static generateAttributeSet(widget, _attrs) {
    // Sanity check and validation
    for (var key in _attrs) {
      if (typeof widget[key] != "undefined") {
        if (!widget[key].ignore) {
          _attrs[key] = et2_checkType(_attrs[key], widget[key].type, key, this);
        }
      } else {
        // Key does not exist - delete it and issue a warning
        delete _attrs[key];
        egw$1.debug("warn", this, "Attribute '" + key + "' does not exist in " + _attrs.type + "!");
      }
    }

    // Include default values or already set values for this attribute
    for (var key in widget) {
      if (typeof _attrs[key] == "undefined") {
        var _default = widget[key]["default"];
        if (_default == et2_no_init) {
          _default = undefined;
        }
        _attrs[key] = _default;
      }
    }
    return _attrs;
  }

  /**
   * The initAttributes function sets the attributes to their default
   * values. The attributes are not overwritten, which means, that the
   * default is only set, if either a setter exists or this[propName] does
   * not exist yet.
   *
   * @param {object} _attrs is the associative array containing the attributes.
   */
  initAttributes(_attrs) {
    for (var key in _attrs) {
      if (typeof this.attributes[key] != "undefined" && !this.attributes[key].ignore && !(_attrs[key] == undefined)) {
        this.setAttribute(key, _attrs[key], false);
      }
    }
  }
  static buildAttributes(class_prototype) {
    var class_tree = [];
    var attributes = {};
    var n = 0;
    do {
      n++;
      class_tree.push(class_prototype);
      class_prototype = Object.getPrototypeOf(class_prototype);
    } while (class_prototype && class_prototype !== ClassWithAttributes && n < 50);
    for (var i = class_tree.length - 1; i >= 0; i--) {
      attributes = ClassWithAttributes.extendAttributes(attributes, class_tree[i]._attributes);
    }
    return attributes;
  }

  /**
   * Extend current _attributes with the one from the parent class
   *
   * This gives inheritance from the parent plus the ability to override in the current class.
   *
   * @param _attributes
   * @param _parent
   */
  static extendAttributes(_parent, _attributes) {
    function _copyMerge(_new, _old) {
      var result = {};

      // Copy the new object
      if (typeof _new != "undefined") {
        for (var key in _new) {
          result[key] = _new[key];
        }
      }

      // Merge the old object
      for (var key in _old) {
        if (typeof result[key] == "undefined") {
          result[key] = _old[key];
        }
      }
      return result;
    }
    var attributes = {};

    // Copy the old attributes
    for (var key in _attributes) {
      attributes[key] = _copyMerge({}, _attributes[key]);
    }

    // Add the old attributes to the new ones. If the attributes already
    // exist, they are merged.
    for (var key in _parent) {
      var _old = _parent[key];
      attributes[key] = _copyMerge(attributes[key], _old);
    }

    // Validate the attributes
    for (var key in attributes) {
      et2_validateAttrib(key, attributes[key]);
    }
    return attributes;
  }
}

function _defineProperty$2e(e, r, t) { return (r = _toPropertyKey$2d(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2d(t) { var i = _toPrimitive$2d(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2d(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
// fixing circular dependencies by only importing type

/**
 * The registry contains all XML tag names and the corresponding widget
 * constructor.
 */
var et2_registry = {};
var et2_attribute_registry = {};

/**
 * Registers the widget class defined by the given constructor, registers all its class attributes, and associates it
 * with the types in the _types array.
 *
 * @param {function} _constructor constructor
 * @param {array} _types widget types _constructor wants to register for
 */
function et2_register_widget(_constructor, _types) {
  "use strict";

  et2_attribute_registry[_constructor.name] = ClassWithAttributes.buildAttributes(_constructor);
  // Iterate over all given types and register those
  for (var i = 0; i < _types.length; i++) {
    var type = _types[i].toLowerCase();

    // Check whether a widget has already been registered for one of the
    // types.
    if (et2_registry[type]) {
      egw$1.debug("warn", "Widget class registered for " + type + " will be overwritten.");
    }
    et2_registry[type] = _constructor;
  }
}

/**
 * Creates a widget registered for the given tag-name. If "readonly" is listed
 * inside the attributes, et2_createWidget will try to use the "_ro" type of the
 * widget.
 *
 * @param _name is the name of the widget with which it is registered. If the
 * 	widget is not found, an et2_placeholder will be created.
 * @param _attrs is an associative array with attributes. If not passed, it will
 * 	default to an empty object.
 * @param _parent is the parent to which the element will be attached. If _parent
 * 	is not passed, it will default to null. Then you have to attach the element
 * 	to a parent using the addChild or insertChild method.
 */
function et2_createWidget$1(_name, _attrs, _parent) {
  "use strict";

  if (typeof _attrs == "undefined") {
    _attrs = {};
  }
  if (typeof _attrs != "object") {
    _attrs = {};
  }
  if (typeof _parent == "undefined") {
    _parent = null;
  }

  // check and return web-components in case widget is no longer available as legacy widget
  if (typeof et2_registry[_name] === "undefined") {
    if (window.customElements.get('et2-' + _name)) {
      return loadWebComponent('et2-' + _name, _attrs, _parent);
    } else if (window.customElements.get(_name)) {
      return loadWebComponent(_name, _attrs, _parent);
    }
  }

  // Parse the "readonly" and "type" flag for this element here, as they
  // determine which constructor is used
  var nodeName = _attrs["type"] = _name;
  var readonly = _attrs["readonly"] = typeof _attrs["readonly"] === "undefined" ? false : _attrs["readonly"];

  // Get the constructor - if the widget is readonly, use the special "_ro"
  // constructor if it is available
  if (typeof et2_registry[nodeName] === "undefined") {
    nodeName = 'placeholder';
  }
  var constructor = et2_registry[nodeName];
  if (readonly && typeof et2_registry[nodeName + "_ro"] !== "undefined") {
    constructor = et2_registry[nodeName + "_ro"];
  }

  // Do a sanity check for the attributes
  ClassWithAttributes.generateAttributeSet(et2_attribute_registry[constructor.name], _attrs);
  // Create the new widget and return it
  return new constructor(_parent, _attrs);
}

// make et2_createWidget publicly available as we need to call it from stylite/js/gantt.js (maybe others)
if (typeof window.et2_createWidget === 'undefined') window['et2_createWidget'] = et2_createWidget$1;
/**
 * The et2 widget base class.
 *
 * @augments ClassWithAttributes
 */
class et2_widget extends ClassWithAttributes {
  /**
   * Widget constructor
   *
   * To implement the attributes inheritance and overriding each extending class/widget needs to call:
   *
   * 	super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_DOMWidget._attributes, _child || {}));
   *
   * @param _parent is the parent object from the XML tree which contains this
   * 	object. The default constructor always adds the new instance to the
   * 	children list of the given parent object. _parent may be NULL.
   * @param _attrs is an associative array of attributes.
   * @param _child attributes object from the child
   */
  constructor(_parent, _attrs, _child) {
    super(); // because we in the top of the widget hierarchy
    _defineProperty$2e(this, "_type", void 0);
    _defineProperty$2e(this, "id", void 0);
    _defineProperty$2e(this, "supportedWidgetClasses", void 0);
    _defineProperty$2e(this, "options", void 0);
    _defineProperty$2e(this, "readonly", void 0);
    _defineProperty$2e(this, "_parent", void 0);
    _defineProperty$2e(this, "_children", []);
    _defineProperty$2e(this, "_egw", void 0);
    _defineProperty$2e(this, "_mgrs", {});
    /**
     * This is used and therefore it we can not (yet) make it private
     *
     * @deprecated use this.getInstanceMgr()
     */
    _defineProperty$2e(this, "_inst", null);
    this.attributes = ClassWithAttributes.extendAttributes(et2_widget._attributes, _child || {});

    // Check whether all attributes are available
    if (typeof _parent == "undefined") {
      _parent = null;
    }
    if (typeof _attrs == "undefined") {
      _attrs = {};
    }
    if (_attrs.attributes) {
      jQuery.extend(_attrs, _attrs.attributes);
    }
    // Initialize all important parameters
    this._mgrs = {};
    this._inst = null;
    this._children = [];
    this._type = _attrs["type"];
    this.id = _attrs["id"];

    // Add this widget to the given parent widget
    if (_parent != null) {
      _parent.addChild(this);
    }

    // The supported widget classes array defines a whitelist for all widget
    // classes or interfaces child widgets have to support.
    this.supportedWidgetClasses = [et2_widget, HTMLElement];
    if (_attrs["id"]) {
      // Create a namespace for this object
      if (this._createNamespace()) {
        this.checkCreateNamespace(_attrs);
      }
    }
    if (this.id) {
      //this.id = this.id.replace(/\[/g,'&#x5B;').replace(/]/g,'&#x5D;');
    }

    // Add all attributes hidden in the content arrays to the attributes
    // parameter
    this.transformAttributes(_attrs);

    // Create a local copy of the options object
    this.options = et2_cloneObject(_attrs);
  }

  /**
   * The destroy function destroys all children of the widget, removes itself
   * from the parents children list.
   * In all classes derrived from et2_widget ALWAYS override the destroy
   * function and remove ALL references to other objects. Also remember to
   * unbind ANY event this widget created and to remove all DOM-Nodes it
   * created.
   */
  destroy() {
    // Call the destructor of all children
    for (var i = this._children.length - 1; i >= 0; i--) {
      this._children[i].destroy();
    }
    this._children.splice(0, this._children.length);

    // Remove this element from the parent, if it exists
    if (typeof this._parent != "undefined" && this._parent !== null && this._parent instanceof et2_widget) {
      this._parent.removeChild(this);
    }
    this._parent = null;

    // Free the array managers if they belong to this widget
    for (var key in this._mgrs) {
      var _this$_mgrs$key$getPe;
      if (this._mgrs[key] && ((_this$_mgrs$key$getPe = this._mgrs[key].getPerspectiveData()) === null || _this$_mgrs$key$getPe === void 0 ? void 0 : _this$_mgrs$key$getPe.owner) == this) {
        this._mgrs[key].setPerspectiveData(null);
      }
      delete this._mgrs[key];
    }
  }
  getType() {
    return this._type;
  }
  setType(_type) {
    this._type = _type;
  }

  /**
   * Creates a copy of this widget. The parameters given are passed to the
   * constructor of the copied object. If the parameters are omitted, _parent
   * is defaulted to null
   *
   * @param {et2_widget} _parent parent to set for clone, default null
   */
  clone(_parent) {
    // Default _parent to null
    if (typeof _parent == "undefined") {
      _parent = null;
    }

    // Create the copy
    var copy = new this.constructor(_parent, this.options);

    // Assign this element to the copy
    copy.assign(this);
    return copy;
  }
  assign(_obj) {
    if (typeof _obj._children == "undefined") {
      this.egw().debug("log", "Foo!");
    }

    // Create a clone of all child elements of the given object
    for (var i = 0; i < _obj._children.length; i++) {
      _obj._children[i].clone(this);
    }

    // Copy a reference to the content array manager
    this.setArrayMgrs(_obj.mgrs);
  }
  /**
   * Returns the parent widget of this widget
   */
  getParent() {
    return this._parent;
  }
  /**
   * Returns the list of children of this widget.
   */
  getChildren() {
    return this._children;
  }

  /**
   * Returns the base widget
   */
  getRoot() {
    if (this._parent != null) {
      return this._parent.getRoot();
    } else {
      return this;
    }
  }

  /**
   * Inserts an child at the end of the list.
   *
   * @param _node is the node which should be added. It has to be an instance
   * 	of et2_widget
   */
  addChild(_node) {
    this.insertChild(_node, this._children.length);
  }

  /**
   * Inserts a child at the given index.
   *
   * @param _node is the node which should be added. It has to be an instance
   * 	of et2_widget
   * @param _idx is the position at which the element should be added.
   */
  insertChild(_node, _idx) {
    // Check whether the node is one of the supported widget classes.
    if (this.isOfSupportedWidgetClass(_node)) {
      // Remove the node from its original parent
      if (_node._parent) {
        _node._parent.removeChild(_node);
      }
      _node._parent = this;
      this._children.splice(_idx, 0, _node);
    } else {
      this.egw().debug("error", "Widget " + _node._type + " is not supported by this widget class", this);
      //			throw("Widget is not supported by this widget class!");
    }
  }

  /**
   * Removes the child but does not destroy it.
   *
   * @param {et2_widget} _node child to remove
   */
  removeChild(_node) {
    // Retrieve the child from the child list
    var idx = this._children.indexOf(_node);
    if (idx >= 0) {
      // This element is no longer parent of the child
      _node._parent = null;
      this._children.splice(idx, 1);
    }
  }

  /**
   * Searches an element by id in the tree, descending into the child levels.
   *
   * @param _id is the id you're searching for
   */
  getWidgetById(_id) {
    if (this.id == _id) {
      return this;
    }
    if (!this._children) return null;
    for (var i = 0; i < this._children.length; i++) {
      var elem = this._children[i].getWidgetById(_id);
      if (elem != null) {
        return elem;
      }
    }
    if (this.id && _id.indexOf('[') > -1 && this._children.length) {
      var ids = new et2_arrayMgr().explodeKey(_id);
      var widget = this;
      for (var i = 0; i < ids.length && widget !== null; i++) {
        widget = widget.getWidgetById(ids[i]);
      }
      return widget;
    }
    return null;
  }

  /**
   * Function which allows iterating over the complete widget tree.
   *
   * @param _callback is the function which should be called for each widget
   * @param _context is the context in which the function should be executed
   * @param _type is an optional parameter which specifies a class/interface
   * 	the elements have to be instanceOf.
   */
  iterateOver(_callback, _context, _type) {
    if (typeof _type == "undefined") {
      _type = et2_widget;
    }
    if (this.isInTree() && this.instanceOf(_type)) {
      _callback.call(_context, this);
    }
    for (var i = 0; i < this._children.length; i++) {
      this._children[i].iterateOver(_callback, _context, _type);
    }
  }

  /**
   * Returns true if the widget currently resides in the visible part of the
   * widget tree. E.g. Templates which have been cloned are not in the visible
   * part of the widget tree.
   *
   * @param _sender
   * @param {boolean} _vis can be used by widgets overwriting this function - simply
   * 	write
   * 		return this._super(inTree);
   *	when calling this function the _vis parameter does not have to be supplied.
   */
  isInTree(_sender, _vis) {
    if (typeof _vis == "undefined") {
      _vis = true;
    }
    if (this._parent) {
      return _vis && this._parent.isInTree(this);
    }
    return _vis;
  }
  isOfSupportedWidgetClass(_obj) {
    for (var i = 0; i < this.supportedWidgetClasses.length; i++) {
      if (_obj instanceof this.supportedWidgetClasses[i]) {
        return true;
      }
    }
    return false;
  }

  /**
   * The parseXMLAttrs function takes an XML DOM attributes object
   * and adds the given attributes to the _target associative array. This
   * function also parses the legacyOptions.
   *
   * @param _attrsObj is the XML DOM attributes object
   * @param {object} _target is the object to which the attributes should be written.
   * @param {et2_widget} _proto prototype with attributes and legacyOptions attribute
   */
  parseXMLAttrs(_attrsObj, _target, _proto) {
    // Check whether the attributes object is really existing, if not abort
    if (typeof _attrsObj == "undefined") {
      return;
    }

    // Iterate over the given attributes and parse them
    var mgr = this.getArrayMgr("content");
    for (var i = 0; i < _attrsObj.length; i++) {
      var attrName = _attrsObj[i].name;
      var attrValue = _attrsObj[i].value;

      // Special handling for the legacy options
      if (attrName == "options" && _proto.constructor.legacyOptions && _proto.constructor.legacyOptions.length > 0) {
        var legacy = _proto.constructor.legacyOptions || [];
        var attrs = et2_attribute_registry[Object.getPrototypeOf(_proto).constructor.name] || {};
        // Check for modifications on legacy options here.  Normal modifications
        // are handled in widget constructor, but it's too late for legacy options then
        if (_target.id && this.getArrayMgr("modifications").getEntry(_target.id)) {
          var mod = this.getArrayMgr("modifications").getEntry(_target.id);
          if (typeof mod.options != "undefined") attrValue = _attrsObj[i].value = mod.options;
        }
        // expand legacyOptions with content
        if (attrValue.charAt(0) == '@' || attrValue.indexOf('$') != -1) {
          attrValue = mgr.expandName(attrValue);
        }

        // Parse the legacy options (as a string, other types not allowed)
        var splitted = et2_csvSplit(attrValue + "");
        for (var j = 0; j < splitted.length && j < legacy.length; j++) {
          // Blank = not set, unless there's more legacy options provided after
          if (splitted[j].trim().length === 0 && legacy.length >= splitted.length) continue;

          // Check to make sure we don't overwrite a current option with a legacy option
          if (typeof _target[legacy[j]] === "undefined") {
            attrValue = splitted[j];

            /**
            If more legacy options than expected, stuff them all in the last legacy option
            Some legacy options take a comma separated list.
             */
            if (j == legacy.length - 1 && splitted.length > legacy.length) {
              attrValue = splitted.slice(j);
            }
            var attr = et2_attribute_registry[_proto.constructor.name][legacy[j]] || {};

            // If the attribute is marked as boolean, parse the
            // expression as bool expression.
            if (attr.type == "boolean") {
              attrValue = mgr.parseBoolExpression(attrValue);
            } else if (typeof attrValue != "object") {
              attrValue = mgr.expandName(attrValue);
            }
            _target[legacy[j]] = attrValue;
          }
        }
      } else if (attrName == "readonly" && typeof _target[attrName] != "undefined") {
        // do NOT overwrite already evaluated readonly attribute
      } else {
        var _attrs2 = et2_attribute_registry[_proto.constructor.name] || {};
        if (mgr != null && typeof _attrs2[attrName] != "undefined") {
          var attr = _attrs2[attrName];

          // If the attribute is marked as boolean, parse the
          // expression as bool expression.
          if (attr.type == "boolean") {
            attrValue = mgr.parseBoolExpression(attrValue);
          } else {
            attrValue = mgr.expandName(attrValue);
          }
        }

        // Set the attribute
        _target[attrName] = attrValue;
      }
    }
  }

  /**
   * Apply the "modifications" to the element and translate attributes marked
   * with "translate: true"
   *
   * @param {object} _attrs
   */
  transformAttributes(_attrs) {
    var _this = this;
    // Apply the content of the modifications array
    if (this.id) {
      if (typeof this.id != "string") {
        console.log(this.id);
      }
      if (this.getArrayMgr("modifications")) {
        var data = this.getArrayMgr("modifications").getEntry(this.id);

        // Check for already inside namespace
        if (this._createNamespace() && this.getArrayMgr("modifications").perspectiveData.owner == this) {
          data = this.getArrayMgr("modifications").data;
        }
        if (typeof data === 'object') {
          for (var key in data) {
            _attrs[key] = data[key];
          }
        }
      }
    }

    // Translate the attributes
    var _loop = function _loop() {
      if (_attrs[key] && typeof _this.attributes[key] != "undefined") {
        if (_this.attributes[key].translate === true || _this.attributes[key].translate === "!no_lang" && !_attrs["no_lang"]) {
          var value = _attrs[key];
          // allow statustext to contain multiple translated sub-strings eg: {Firstname}.{Lastname}
          if (value.indexOf('{') !== -1) {
            var _egw2 = _this.egw();
            _attrs[key] = value.replace(/{([^}]+)}/g, function (str, p1) {
              return _egw2.lang(p1);
            });
          } else {
            _attrs[key] = _this.egw().lang(value);
          }
        }
      }
    };
    for (var key in _attrs) {
      _loop();
    }
  }

  /**
   * Create a et2_widget from an XML node.
   *
   * First the type and attributes are read from the node.  Then the readonly & modifications
   * arrays are checked for changes specific to the loaded data.  Then the appropriate
   * constructor is called.  After the constructor returns, the widget has a chance to
   * further initialize itself from the XML node when the widget's loadFromXML() method
   * is called with the node.
   *
   * @param _node XML node to read
   * @param _name XML node name
   *
   * @return et2_widget
   */
  createElementFromNode(_node, _name) {
    var attributes = {};

    // Parse the "readonly" and "type" flag for this element here, as they
    // determine which constructor is used
    var _nodeName = attributes["type"] = _node.getAttribute("type") ? _node.getAttribute("type") : _node.nodeName.toLowerCase();
    var readonly = attributes["readonly"] = this.getArrayMgr("readonlys") ? this.getArrayMgr("readonlys").isReadOnly(_node.getAttribute("id"), _node.getAttribute("readonly"), typeof this.readonly !== 'undefined' ? this.readonly : this.options.readonly) : false;

    // Check to see if modifications change type
    var modifications = this.getArrayMgr("modifications");
    if (modifications && _node.getAttribute("id")) {
      var entry = modifications.getEntry(_node.getAttribute("id"));
      if (entry == null) {
        // Try again, but skip the fancy stuff
        // TODO: Figure out why the getEntry() call doesn't always work
        var entry = modifications.data[_node.getAttribute("id")];
        if (entry) {
          this.egw().debug("warn", "getEntry(" + _node.getAttribute("id") + ") failed, but the data is there.", modifications, entry);
        } else {
          // Try the root, in case a namespace got missed
          entry = modifications.getRoot().getEntry(_node.getAttribute("id"));
        }
      }
      if (entry && entry.type && typeof entry.type === 'string') {
        _nodeName = attributes["type"] = entry.type;
      }
      entry = null;
    }

    // if _nodeName / type-attribute contains something to expand (eg. type="@${row}[type]"),
    // we need to expand it now as it defines the constructor and by that attributes parsed via parseXMLAttrs!
    if (_nodeName.charAt(0) == '@' || _nodeName.indexOf('$') >= 0) {
      _nodeName = attributes["type"] = this.getArrayMgr('content').expandName(_nodeName);
    }

    // check and return web-components in case widget is no longer available as legacy widget
    if (typeof et2_registry[_nodeName] === "undefined" && window.customElements.get('et2-' + _nodeName)) {
      return loadWebComponent('et2-' + _nodeName, _node, this);
    }

    // Get the constructor - if the widget is readonly, use the special "_ro"
    // constructor if it is available
    if (typeof et2_registry[_nodeName] === "undefined" && typeof window.customElements.get(_nodeName) == "undefined") {
      _nodeName = 'placeholder';
    }
    var constructor = et2_registry[_nodeName];
    if (readonly === true && typeof et2_registry[_nodeName + "_ro"] != "undefined") {
      constructor = et2_registry[_nodeName + "_ro"];
    }
    if (typeof window.customElements.get(_nodeName) !== "undefined") {
      widget = loadWebComponent(_nodeName, _node, this);
    } else {
      // Parse the attributes from the given XML attributes object
      this.parseXMLAttrs(_node.attributes, attributes, constructor.prototype);

      // Do an sanity check for the attributes
      ClassWithAttributes.generateAttributeSet(et2_attribute_registry[constructor.name], attributes);

      // Creates the new widget, passes this widget as an instance and
      // passes the widgetType. Then it goes on loading the XML for it.
      var widget = new constructor(this, attributes);

      // Load the widget itself from XML
      widget.loadFromXML(_node);
    }
    return widget;
  }

  /**
   * Loads the widget tree from an XML node
   *
   * @param _node xml node
   */
  loadFromXML(_node) {
    // Load the child nodes.
    for (var i = 0; i < _node.childNodes.length; i++) {
      var node = _node.childNodes[i];
      var widgetType = node.nodeName.toLowerCase();
      if (widgetType == "#comment") {
        continue;
      }
      if (widgetType == "#text") {
        if (node.data.replace(/^\s+|\s+$/g, '')) {
          this.loadContent(node.data);
        }
        continue;
      }

      // Create the new element
      this.createElementFromNode(node);
    }
  }

  /**
   * Called whenever textNodes are loaded from the XML tree
   *
   * @param _content
   */
  loadContent(_content) {}

  /**
   * Called when loading the widget (sub-tree) is finished. First when this
   * function is called, the DOM-Tree is created. loadingFinished is
   * recursively called for all child elements. Do not directly override this
   * function but the doLoadingFinished function which is executed before
   * descending deeper into the DOM-Tree.
   *
   * Some widgets (template) do not load immediately because they request
   * additional resources via AJAX.  They will return a Deferred Promise object.
   * If you call loadingFinished(promises) after creating such a widget
   * programmatically, you might need to wait for it to fully complete its
   * loading before proceeding.  In that case use:
   * <code>
   * var promises = [];
   * widget.loadingFinished(promises);
   * jQuery.when.apply(null, promises).done( doneCallback );
   * </code>
   * @see {@link http://api.jquery.com/category/deferred-object/|jQuery Deferred}
   *
   * @param {Promise[]} promises List of promises from widgets that are not done.  Pass an empty array, it will be filled if needed.
   */
  loadingFinished(promises) {
    // Call all availble setters
    this.initAttributes(this.options);

    // Make sure promises is defined to avoid errors.
    // We'll warn (below) if programmer should have passed it.
    if (typeof promises == "undefined") {
      promises = [];
      var warn_if_deferred = true;
    }
    var loadChildren = function loadChildren() {
      // Descend recursively into the tree
      for (var i = 0; i < this._children.length; i++) {
        try {
          this._children[i].loadingFinished(promises);
        } catch (e) {
          egw$1.debug("error", "There was an error with a widget:\nError:%o\nProblem widget:%o", e.valueOf(), this._children[i], e.stack);
        }
      }
    };
    var result = this.doLoadingFinished();
    if (typeof result == "boolean" && result) {
      // Simple widget finishes nicely
      loadChildren.apply(this, arguments);
    } else if (typeof result == "object" && result.then) {
      // Record widget for debug
      result["widget"] = this;

      // Warn if list was not provided
      if (warn_if_deferred) {
        // Might not be a problem, but if you need the widget to be really loaded, it could be
        egw$1.debug("warn", "Loading was deferred for widget %o, but creator is not checking.  Pass a list to loadingFinished().", this);
      }
      // Widget is waiting.  Add to the list
      promises.push(result);
      // Fihish loading when it's finished
      result.then(loadChildren.bind(this));
    }
  }

  /**
   * The initAttributes function sets the attributes to their default
   * values. The attributes are not overwritten, which means, that the
   * default is only set, if either a setter exists or this[propName] does
   * not exist yet.
   *
   * Overwritten here to compile legacy JS code in attributes of type "js"
   *
   * @param {object} _attrs
   */
  initAttributes(_attrs) {
    for (var key in _attrs) {
      if (typeof this.attributes[key] != "undefined" && !this.attributes[key].ignore && !(_attrs[key] == undefined)) {
        var val = _attrs[key];
        // compile string values of attribute type "js" to functions
        if (this.attributes[key].type == 'js' && typeof _attrs[key] == 'string') {
          val = et2_compileLegacyJS(val, this, this.implements(et2_IInputNode) ? this.getInputNode() : this.implements(et2_IDOMNode) ? this.getDOMNode() : null);
        }
        this.setAttribute(key, val, false);
      }
    }
  }

  /**
   * Does specific post-processing after the widget is loaded.  Most widgets should not
   * need to do anything here, it should all be done before.
   *
   * @return {boolean|Promise} True if the widget is fully loaded, false to avoid procesing children,
   * or a Promise if loading is not actually finished (eg. waiting for AJAX)
   *
   * @see {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise Promise}
   */
  doLoadingFinished() {
    return true;
  }
  /**
   * The egw function returns the instance of the client side api belonging
   * to this widget tree. The api instance can be set in the "container"
   * widget using the setApiInstance function.
   */
  egw() {
    // The _egw property is not set
    if (typeof this._egw === 'undefined') {
      if (this._parent != null) {
        return this._parent.egw();
      }

      // Get the window this object belongs to
      var wnd = null;
      if (this.implements(et2_IDOMNode)) {
        var node = this.getDOMNode();
        if (node && node.ownerDocument) {
          wnd = node.ownerDocument.parentNode || node.ownerDocument.defaultView;
        }
      }

      // If we're the root object, return the phpgwapi API instance
      return egw$1('phpgwapi', wnd);
    }
    return this._egw;
  }

  /**
   * Sets the client side api instance. It can be retrieved by the widget tree
   * by using the "egw()" function.
   *
   * @param {IegwAppLocal} _egw egw object to set
   */
  setApiInstance(_egw) {
    this._egw = _egw;
  }
  /**
   * Sets all array manager objects - this function can be used to set the
   * root array managers of the container object.
   *
   * @param {object} _mgrs
   */
  setArrayMgrs(_mgrs) {
    this._mgrs = et2_cloneObject(_mgrs);
  }

  /**
   * Returns an associative array containing the top-most array managers.
   *
   * @param _mgrs is used internally and should not be supplied.
   */
  getArrayMgrs(_mgrs) {
    if (typeof _mgrs == "undefined") {
      _mgrs = {};
    }

    // Add all managers of this object to the result, if they have not already
    // been set in the result
    for (var key in this._mgrs) {
      if (typeof _mgrs[key] == "undefined") {
        _mgrs[key] = this._mgrs[key];
      }
    }

    // Recursively applies this function to the parent widget
    if (this._parent) {
      this._parent.getArrayMgrs(_mgrs);
    }
    return _mgrs;
  }

  /**
   * Sets the array manager for the given part
   *
   * @param {string} _part which array mgr to set
   * @param {object} _mgr
   */
  setArrayMgr(_part, _mgr) {
    this._mgrs[_part] = _mgr;
  }

  /**
   * Returns the array manager object for the given part
   *
   * @param {string} managed_array_type name of array mgr to return
   */
  getArrayMgr(managed_array_type) {
    if (this._mgrs && typeof this._mgrs[managed_array_type] != "undefined") {
      return this._mgrs[managed_array_type];
    } else if (this._parent) {
      return this._parent.getArrayMgr(managed_array_type);
    }
    return null;
  }

  /**
   * Checks whether a namespace exists for this element in the content array.
   * If yes, an own perspective of the content array is created. If not, the
   * parent content manager is used.
   *
   * Constructor attributes are passed in case a child needs to make decisions
   */
  checkCreateNamespace(_attrs) {
    // Get the content manager
    var mgrs = this.getArrayMgrs();
    for (var key in mgrs) {
      var mgr = mgrs[key];

      // Get the original content manager if we have already created a
      // perspective for this node
      if (typeof this._mgrs[key] != "undefined" && mgr.perspectiveData.owner == this) {
        mgr = mgr.parentMgr;
      }

      // Check whether the manager has a namespace for the id of this object
      var entry = mgr.getEntry(this.id);
      if (typeof entry === 'object' && entry !== null || this.id) {
        // The content manager has an own node for this object, so
        // create an own perspective.
        this._mgrs[key] = mgr.openPerspective(this, this.id);
      } else {
        // The current content manager does not have an own namespace for
        // this element, so use the content manager of the parent.
        delete this._mgrs[key];
      }
    }
  }

  /**
   * Widgets that do support a namespace should override and return true.
   *
   * Since a private attribute doesn't get instanciated properly before it's needed,
   * we use a method so we can get what we need while still in the constructor.
   *
   * @private
   */
  _createNamespace() {
    return false;
  }
  /**
   * Sets the instance manager object (of type etemplate2, see etemplate2.js)
   *
   * @param {etemplate2} _inst
   */
  setInstanceManager(_inst) {
    this._inst = _inst;
  }

  /**
   * Returns the instance manager
   *
   * @return {etemplate2}
   */
  getInstanceManager() {
    if (this._inst != null) {
      return this._inst;
    } else if (this._parent) {
      return this._parent.getInstanceManager();
    }
    return null;
  }

  /**
   * Returns the path into the data array.  By default, array manager takes care of
   * this, but some extensions need to override this
   */
  getPath() {
    var path = this.getArrayMgr("content").getPath();

    // Prevent namespaced widgets with value from going an extra layer deep
    if (this.id && this._createNamespace() && path[path.length - 1] == this.id) path.pop();
    return path;
  }
}
_defineProperty$2e(et2_widget, "_attributes", {
  "id": {
    "name": "ID",
    "type": "string",
    "description": "Unique identifier of the widget"
  },
  "no_lang": {
    "name": "No translation",
    "type": "boolean",
    "default": false,
    "description": "If true, no translations are made for this widget"
  },
  /**
   * Ignore the "span" property by default - it is read by the grid and
   * other widgets.
   */
  "span": {
    "ignore": true
  },
  /**
   * Ignore the "type" tag - it is read by the "createElementFromNode"
   * function and passed as second parameter of the widget constructor
   */
  "type": {
    "name": "Widget type",
    "type": "string",
    "ignore": true,
    "description": "What kind of widget this is"
  },
  /**
   * Ignore the readonly tag by default - its also read by the
   * "createElementFromNode" function.
   */
  "readonly": {
    "ignore": true
  },
  /**
   * Widget's attributes
   */
  attributes: {
    "name": "Widget attributes",
    "type": "any",
    "ignore": true,
    "description": "Object of widget attributes"
  }
});
// Set the legacyOptions array to the names of the properties the "options"
// attribute defines.
_defineProperty$2e(et2_widget, "legacyOptions", []);

function _defineProperty$2d(e, r, t) { return (r = _toPropertyKey$2c(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2c(t) { var i = _toPrimitive$2c(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2c(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * Abstract widget class which can be inserted into the DOM. All widget classes
 * deriving from this class have to care about implementing the "getDOMNode"
 * function which has to return the DOM-Node.
 *
 * @augments et2_widget
 */
class et2_DOMWidget extends et2_widget {
  /**
   * When the DOMWidget is initialized, it grabs the DOM-Node of the parent
   * object (if available) and passes it to its own "createDOMNode" function
   *
   * @memberOf et2_DOMWidget
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_DOMWidget._attributes, _child || {}));
    _defineProperty$2d(this, "parentNode", null);
    _defineProperty$2d(this, "disabled", false);
    _defineProperty$2d(this, "_attachSet", {
      "node": null,
      "parent": null
    });
    _defineProperty$2d(this, "_actionManager", void 0);
    _defineProperty$2d(this, "width", void 0);
    _defineProperty$2d(this, "height", void 0);
    _defineProperty$2d(this, "dom_id", void 0);
    _defineProperty$2d(this, "overflow", void 0);
    _defineProperty$2d(this, "_surroundingsMgr", void 0);
    this._surroundingsMgr = null;
  }
  /**
   * Detatches the node from the DOM and clears all references to the parent
   * node or the dom node of this widget.
   */
  destroy() {
    this.detachFromDOM();
    this.parentNode = null;
    this._attachSet = {};
    if (this._actionManager) {
      var app_om = egw_getObjectManager(this.egw().getAppName(), false, 1);
      if (app_om) {
        var om = app_om.getObjectById(this.id);
        if (om) om.remove();
      }
      this._actionManager.remove();
      this._actionManager = null;
    }
    if (this._surroundingsMgr) {
      this._surroundingsMgr.destroy();
      this._surroundingsMgr = null;
    }
    super.destroy();
  }

  /**
   * Attaches the container node of this widget to the DOM-Tree
   */
  doLoadingFinished() {
    // Check whether the parent implements the et2_IDOMNode interface. If
    // yes, grab the DOM node and create our own.
    if (this.getParent() && this.getParent().implements(et2_IDOMNode)) {
      if (this.options.parent_node) {
        this.set_parent_node(this.options.parent_node);
      } else {
        this.setParentDOMNode(this.getParent().getDOMNode(this));
      }
    }
    return true;
  }

  /**
   * Detaches the widget from the DOM tree, if it had been attached to the
   * DOM-Tree using the attachToDOM method.
   */
  detachFromDOM() {
    if (this._attachSet && this._attachSet.node && this._attachSet.parent) {
      // Remove the current node from the parent node
      try {
        this._attachSet.parent.removeChild(this._attachSet.node);
      } catch (e) {
        // Don't throw a DOM error if the node wasn't in the parent
      }

      // Reset the "attachSet"
      this._attachSet = {
        "node": null,
        "parent": null
      };
      return true;
    }
    return false;
  }

  /**
   * Attaches the widget to the DOM tree. Fails if the widget is already
   * attached to the tree or no parent node or no node for this widget is
   * defined.
   */
  attachToDOM() {
    // Attach the DOM node of this widget (if existing) to the new parent
    var node = this.getDOMNode(this);
    if (node && this.parentNode && (!this._attachSet || this._attachSet && node != this._attachSet.node || this.parentNode != this._attachSet.parent)) {
      // If the surroundings manager exists, surround the DOM-Node of this
      // widget with the DOM-Nodes inside the surroundings manager.
      if (this._surroundingsMgr) {
        node = this._surroundingsMgr.getDOMNode(node);
      }

      // Append this node at its index
      var idx = this.getDOMIndex();
      if (idx < 0 || idx > this.parentNode.childNodes.length - 1) {
        this.parentNode.appendChild(node);
      } else {
        this.parentNode.insertBefore(node, this.parentNode.childNodes[idx]);
      }

      // Store the currently attached nodes
      this._attachSet = {
        "node": node,
        "parent": this.parentNode
      };
      return true;
    }
    return false;
  }

  /**
   * Inserts a child at the given index.
   *
   * @param _node is the node which should be added. It has to be an instance
   * 	of et2_widget
   * @param _idx is the position at which the element should be added.
   */
  insertChild(_node, _idx) {
    super.insertChild(_node, _idx);
    if (_node.instanceOf && _node.instanceOf(et2_DOMWidget) && typeof _node.hasOwnProperty('parentNode') && this.getDOMNode(this)) {
      try {
        _node.setParentDOMNode(this.getDOMNode(_node));
      } catch (_unused) {
        // Not ready to be added, usually due to construction order,
        // will probably try again in doLoadingFinished()
      }
    }
    // _node is actually a Web Component
    else if (_node instanceof Element) {
      if (this.getDOMNode(_node)) {
        this.getDOMNode(_node).append(_node);
      } else {
        // Warn about it.  This slows down loading, as it requires a second pass (loadingFinished) to get the child
        // properly added.
        console.warn("Legacy widget " + this.getType() + "[#" + this.options.id + "] could not handle adding a child (" + _node.getType() + (_node.id ? "#" + _node.id : "") + ")");
      }
    }
  }
  isAttached() {
    return this.parentNode != null;
  }
  getSurroundings() {
    if (!this._surroundingsMgr) {
      this._surroundingsMgr = new et2_surroundingsMgr(this);
    }
    return this._surroundingsMgr;
  }

  /**
   * Get data for the tab this widget is on.
   *
   * Will return null if the widget is not on a tab or tab data containing
   * - id
   * - label
   * - widget (top level widget)
   * - contentDiv (jQuery object for the div the tab content is in)
   *
   * @returns {Object|null} Data for tab the widget is on
   */
  get_tab_info() {
    var parent = this;
    do {
      parent = parent.getParent();
    } while (parent !== this.getRoot() && ['tabbox', 'ET2-TABBOX'].indexOf(parent.getType()) == -1);

    // No tab
    if (parent === this.getRoot()) {
      return null;
    }
    var tabbox = parent;

    // Find the tab index
    for (var i = 0; i < tabbox.tabData.length; i++) {
      var _tabbox$tabData$i$con;
      // Find the tab by DOM heritage
      // @ts-ignore
      if ((_tabbox$tabData$i$con = tabbox.tabData[i].contentDiv) !== null && _tabbox$tabData$i$con !== void 0 && _tabbox$tabData$i$con.contains(this.getDOMNode(this) || this)) {
        return tabbox.tabData[i];
      }
    }
    // On a tab, but we couldn't find it by DOM nodes  Maybe tab template is
    // not loaded yet.  Try checking IDs.
    var template = this;
    do {
      template = template.getParent();
      // @ts-ignore
    } while (template !== tabbox && ['template', 'ET2-TEMPLATE'].indexOf(template.getType()) == -1);
    for (var i = tabbox.tabData.length - 1; i >= 0; i--) {
      var _tabbox$tabData$i$con2;
      if (template && template.id && (template.id === tabbox.tabData[i].id || ((_tabbox$tabData$i$con2 = tabbox.tabData[i].contentDiv) === null || _tabbox$tabData$i$con2 === void 0 ? void 0 : _tabbox$tabData$i$con2.getWidgetById(template.id)) !== null)) {
        return tabbox.tabData[i];
      }
    }
    // Fallback
    var fallback = this.getParent();
    if (typeof fallback.get_tab_info === 'function') {
      return fallback.get_tab_info();
    }
    return null;
  }

  /**
   * Set the parent DOM node of this element.  Takes a wider variety of types
   * than setParentDOMNode(), and matches the set_<attribute> naming convention.
   *
   * @param _node String|DOMNode DOM node to contain the widget, or the ID of the DOM node.
   */
  set_parent_node(_node) {
    if (typeof _node == "string" && _node !== "") {
      var parent = jQuery('#' + _node);
      if (parent.length === 0 && window.parent) {
        // Could not find it, try again with wider context
        // (in case there's an iframe in admin, for example)
        parent = jQuery('#' + _node, window.parent.document);
      }
      if (parent.length === 0) {
        this.egw().debug('warn', 'Unable to find DOM parent node with ID "%s" for widget %o.', _node, this);
      } else {
        this.setParentDOMNode(parent.get(0));
      }
    } else {
      this.setParentDOMNode(_node);
    }
  }

  /**
   * Set the parent DOM node of this element. If another parent node is already
   * set, this widget removes itself from the DOM tree
   *
   * @param _node
   */
  setParentDOMNode(_node) {
    if (_node != this.parentNode) {
      // Detatch this element from the DOM tree
      this.detachFromDOM();
      this.parentNode = _node;

      // And attatch the element to the DOM tree
      this.attachToDOM();
    }
  }

  /**
   * Returns the parent node.
   */
  getParentDOMNode() {
    return this.parentNode;
  }

  /**
   * Returns the index of this element in the DOM tree
   */
  getDOMIndex() {
    if (this.getParent()) {
      var idx = 0;
      var children = this.getParent().getChildren();
      if (children && children.indexOf) return children.indexOf(this);
      egw$1.debug('warn', 'No Array.indexOf(), falling back to looping. ');
      for (var i = 0; i < children.length; i++) {
        if (children[i] == this) {
          return idx;
        } else if (children[i].isInTree()) {
          idx++;
        }
      }
    }
    return -1;
  }

  /**
   * Sets the id of the DOM-Node.
   *
   * DOM id's have dots "." replaced with dashes "-"
   *
   * @param {string} _value id to set
   */
  set_id(_value) {
    this.id = _value;
    this.dom_id = _value ? this.getInstanceManager().uniqueId + '_' + _value.replace(/\./g, '-') : _value;
    var node = this.getDOMNode(this);
    if (node) {
      if (_value != "") {
        node.setAttribute("id", this.dom_id);
      } else {
        node.removeAttribute("id");
      }
    }
  }
  set_disabled(_value) {
    var node = this._surroundingsMgr != null ? this._surroundingsMgr.getDOMNode(this.getDOMNode(this)) : this.getDOMNode(this);
    if (node && this.disabled != _value) {
      this.disabled = _value;
      if (_value) {
        jQuery(node).hide();
      } else {
        jQuery(node).show();
      }
    }
  }
  set_width(_value) {
    this.width = _value;
    var node = this.getDOMNode(this);
    if (node) {
      jQuery(node).css("width", _value);
    }
  }
  set_height(_value) {
    this.height = _value;
    var node = this.getDOMNode(this);
    if (node) {
      jQuery(node).css("height", _value);
    }
  }
  set_class(_value) {
    var node = this.getDOMNode(this);
    if (node) {
      if (this["class"]) {
        jQuery(node).removeClass(this["class"]);
      }
      jQuery(node).addClass(_value);
    }
    this["class"] = _value;
  }
  set_overflow(_value) {
    this.overflow = _value;
    var node = this.getDOMNode(this);
    if (node) {
      jQuery(node).css("overflow", _value);
    }
  }
  set_data(_value) {
    var node = this.getDOMNode(this);
    if (node && _value) {
      var pairs = _value.split(/,/g);
      for (var i = 0; i < pairs.length; ++i) {
        var name_value = pairs[i].split(':');
        jQuery(node).attr('data-' + name_value[0], name_value[1]);
      }
    }
  }
  set_background(_value) {
    var node = this.getDOMNode(this);
    var values = '';
    if (_value && node) {
      values = _value.split(',');
      jQuery(node).css({
        "background-image": 'url("' + values[0] + '")',
        "background-position-x": values[1],
        "background-position-y": values[2],
        "background-scale": values[3]
      });
    }
  }

  /**
   * Set Actions on the widget
   *
   * Each action is defined as an object:
   *
   * move: {
   *      type: "drop",
   *      acceptedTypes: "mail",
   *      icon:   "move",
   *      caption:	"Move to"
   *      onExecute:      javascript:mail_move"
   * }
   *
   * This will turn the widget into a drop target for "mail" drag types.  When "mail" drag types are dropped,
   * the global function mail_move(egwAction action, egwActionObject sender) will be called.  The ID of the
   * dragged "mail" will be in sender.id, some information about the sender will be in sender.context.  The
   * etemplate2 widget involved can typically be found in action.parent.data.widget, so your handler
   * can operate in the widget context easily.  The location varies depending on your action though.  It
   * might be action.parent.parent.data.widget
   *
   * To customise how the actions are handled for a particular widget, override _link_actions().  It handles
   * the more widget-specific parts.
   *
   * @param {object} actions {ID: {attributes..}+} map of egw action information
   * @see api/src/Etemplate/Widget/Nextmatch.php egw_actions() method
   */
  set_actions(actions) {
    if (this.id == "" || typeof this.id == "undefined") {
      this.egw().debug("warn", "Widget should have an ID if you want actions", this);
      return;
    }

    // Initialize the action manager and add some actions to it
    // Only look 1 level deep
    var gam = egw_getActionManager(this.egw().appName, true, 1);
    if (typeof this._actionManager != "object") {
      if (gam.getActionById(this.getInstanceManager().uniqueId, 1) !== null) {
        gam = gam.getActionById(this.getInstanceManager().uniqueId, 1);
      }
      if (gam.getActionById(this.id, 1) != null) {
        this._actionManager = gam.getActionById(this.id, 1);
      } else {
        this._actionManager = gam.addAction("actionManager", this.id);
      }
    }
    this._actionManager.updateActions(actions, this.egw().appName);
    if (this.options.default_execute) this._actionManager.setDefaultExecute(this.options.default_execute);

    // Put a reference to the widget into the action stuff, so we can
    // easily get back to widget context from the action handler
    this._actionManager.data = {
      widget: this
    };

    // Link the actions to the DOM
    this._link_actions(actions);
  }
  set_default_execute(_default_execute) {
    this.options.default_execute = _default_execute;
    if (this._actionManager) this._actionManager.setDefaultExecute(null, _default_execute);
  }

  /**
   * Get all action-links / id's of 1.-level actions from a given action object
   *
   * This can be overwritten to not allow all actions, by not returning them here.
   *
   * @param actions
   * @returns {Array}
   */
  _get_action_links(actions) {
    var action_links = [];
    for (var i in actions) {
      var action = actions[i];
      action_links.push(typeof action.id != 'undefined' ? action.id : i);
    }
    return action_links;
  }

  /**
   * Link the actions to the DOM nodes / widget bits.
   *
   * @param {object} actions {ID: {attributes..}+} map of egw action information
   */
  _link_actions(actions) {
    // Get the top level element for the tree
    var objectManager = egw_getAppObjectManager(true);
    var widget_object = objectManager.getObjectById(this.id);
    if (widget_object == null) {
      // Add a new container to the object manager which will hold the widget
      // objects
      widget_object = objectManager.insertObject(false, new egwActionObject(this.id, objectManager, new et2_action_object_impl(this).getAOI(), this._actionManager || objectManager.manager.getActionById(this.id) || objectManager.manager));
    } else {
      widget_object.setAOI(new et2_action_object_impl(this, this.getDOMNode()).getAOI());
    }

    // Delete all old objects
    widget_object.clear();
    widget_object.unregisterActions();

    // Go over the widget & add links - this is where we decide which actions are
    // 'allowed' for this widget at this time
    var action_links = this._get_action_links(actions);
    widget_object.updateActionLinks(action_links);
  }
}

/**
 * The surroundings manager class allows to append or prepend elements around
 * an widget node.
 */
_defineProperty$2d(et2_DOMWidget, "_attributes", {
  "disabled": {
    "name": "Disabled",
    "type": "boolean",
    "description": "Defines whether this widget is visible.  Not to be confused with an input widget's HTML attribute 'disabled'.",
    "default": false
  },
  "width": {
    "name": "Width",
    "type": "dimension",
    "default": et2_no_init,
    "description": "Width of the element in pixels, percentage or 'auto'"
  },
  "height": {
    "name": "Height",
    "type": "dimension",
    "default": et2_no_init,
    "description": "Height of the element in pixels, percentage or 'auto'"
  },
  "class": {
    "name": "CSS Class",
    "type": "string",
    "default": et2_no_init,
    "description": "CSS Class which is applied to the dom element of this node"
  },
  "overflow": {
    "name": "Overflow",
    "type": "string",
    "default": et2_no_init,
    "description": "If set, the css-overflow attribute is set to that value"
  },
  "parent_node": {
    "name": "DOM parent",
    "type": "string",
    "default": et2_no_init,
    "description": "Insert into the target DOM node instead of the normal location"
  },
  "actions": {
    "name": "Actions list",
    "type": "any",
    "default": et2_no_init,
    "description": "List of egw actions that can be done on the widget.  This includes context menu, drag and drop.  TODO: Link to action documentation"
  },
  default_execute: {
    name: "Default onExecute for actions",
    type: "js",
    default: et2_no_init,
    description: "Set default onExecute javascript method for action not specifying their own"
  },
  resize_ratio: {
    name: "Resize height of the widget on callback resize",
    type: "string",
    default: '',
    description: "Allow Resize height of the widget based on exess height and given ratio"
  },
  data: {
    name: "comma-separated name:value pairs set as data attributes on DOM node",
    type: "string",
    default: '',
    description: 'data="mime:${row}[mime]" would generate data-mime="..." in DOM, eg. to use it in CSS on a parent'
  },
  background: {
    name: "Add background image",
    type: "string",
    default: '',
    description: "Sets background image, left, right and scale on DOM"
  }
});
class et2_surroundingsMgr extends ClassWithAttributes {
  /**
   * Constructor
   *
   * @memberOf et2_surroundingsMgr
   * @param _widget
   */
  constructor(_widget) {
    super();
    _defineProperty$2d(this, "widget", void 0);
    _defineProperty$2d(this, "_widgetContainer", null);
    _defineProperty$2d(this, "_widgetSurroundings", []);
    _defineProperty$2d(this, "_widgetPlaceholder", null);
    _defineProperty$2d(this, "_widgetNode", null);
    _defineProperty$2d(this, "_ownPlaceholder", true);
    _defineProperty$2d(this, "_surroundingsUpdated", false);
    this.widget = _widget;
  }
  destroy() {
    this._widgetContainer = null;
    this._widgetSurroundings = null;
    this._widgetPlaceholder = null;
    this._widgetNode = null;
  }
  prependDOMNode(_node) {
    this._widgetSurroundings.unshift(_node);
    this._surroundingsUpdated = true;
  }
  appendDOMNode(_node) {
    // Append an placeholder first if none is existing yet
    if (this._ownPlaceholder && this._widgetPlaceholder == null) {
      this._widgetPlaceholder = document.createElement("span");
      this._widgetSurroundings.push(this._widgetPlaceholder);
    }

    // Append the given node
    this._widgetSurroundings.push(_node);
    this._surroundingsUpdated = true;
  }
  insertDOMNode(_node) {
    if (!this._ownPlaceholder || this._widgetPlaceholder == null) {
      this.appendDOMNode(_node);
      return;
    }

    // Get the index of the widget placeholder and delete it, insert the
    // given node instead
    var idx = this._widgetSurroundings.indexOf(this._widgetPlaceholder);
    this._widgetSurroundings.splice(idx, 1, _node);

    // Delete the reference to the own placeholder
    this._widgetPlaceholder = null;
    this._ownPlaceholder = false;
  }
  removeDOMNode(_node) {
    for (var i = 0; this._widgetSurroundings && i < this._widgetSurroundings.length; i++) {
      if (this._widgetSurroundings[i] == _node) {
        this._widgetSurroundings.splice(i, 1);
        this._surroundingsUpdated = true;
        break;
      }
    }
  }
  setWidgetPlaceholder(_node) {
    if (_node != this._widgetPlaceholder) {
      if (_node != null && this._ownPlaceholder && this._widgetPlaceholder != null) {
        // Delete the current placeholder which was created by the
        // widget itself
        var idx = this._widgetSurroundings.indexOf(this._widgetPlaceholder);
        this._widgetSurroundings.splice(idx, 1);

        // Delete any reference to the own placeholder and set the
        // _ownPlaceholder flag to false
        this._widgetPlaceholder = null;
        this._ownPlaceholder = false;
      }
      this._ownPlaceholder = _node == null;
      this._widgetPlaceholder = _node;
      this._surroundingsUpdated = true;
    }
  }
  _rebuildContainer() {
    // Return if there has been no change in the "surroundings-data"
    if (!this._surroundingsUpdated) {
      return false;
    }

    // Build the widget container
    if (this._widgetSurroundings.length > 0) {
      // Check whether the widgetPlaceholder is really inside the DOM-Tree
      var hasPlaceholder = et2_hasChild(this._widgetSurroundings, this._widgetPlaceholder);

      // If not, append another widget placeholder
      if (!hasPlaceholder) {
        this._widgetPlaceholder = document.createElement("span");
        this._widgetSurroundings.push(this._widgetPlaceholder);
        this._ownPlaceholder = true;
      }

      // If the surroundings array only contains one element, set this one
      // as the widget container
      if (this._widgetSurroundings.length == 1) {
        if (this._widgetSurroundings[0] == this._widgetPlaceholder) {
          this._widgetContainer = null;
        } else {
          this._widgetContainer = this._widgetSurroundings[0];
        }
      } else {
        // Create an outer "span" as widgetContainer
        this._widgetContainer = document.createElement("span");

        // Append the children inside the widgetSurroundings array to
        // the widget container
        for (var i = 0; i < this._widgetSurroundings.length; i++) {
          this._widgetContainer.appendChild(this._widgetSurroundings[i]);
        }
      }
    } else {
      this._widgetContainer = null;
      this._widgetPlaceholder = null;
    }
    this._surroundingsUpdated = false;
    return true;
  }
  update() {
    if (this._surroundingsUpdated) {
      var attached = this.widget ? this.widget.isAttached() : false;

      // Reattach the widget - this will call the "getDOMNode" function
      // and trigger the _rebuildContainer function.
      if (attached && this.widget) {
        this.widget.detachFromDOM();
        this.widget.attachToDOM();
      }
    }
  }
  getDOMNode(_widgetNode) {
    // Update the whole widgetContainer if this is not the first time this
    // function has been called but the widget node has changed.
    if (this._widgetNode != null && this._widgetNode != _widgetNode) {
      this._surroundingsUpdated = true;
    }

    // Copy a reference to the given node
    this._widgetNode = _widgetNode;

    // Build the container if it didn't exist yet.
    var updated = this._rebuildContainer();

    // Return the widget node itself if there are no surroundings arround
    // it
    if (this._widgetContainer == null) {
      return _widgetNode;
    }

    // Replace the widgetPlaceholder with the given widget node if the
    // widgetContainer has been updated
    if (updated) {
      this._widgetPlaceholder.parentNode.replaceChild(_widgetNode, this._widgetPlaceholder);
      if (!this._ownPlaceholder) {
        this._widgetPlaceholder = _widgetNode;
      }
    }

    // Return the widget container
    return this._widgetContainer;
  }
  getWidgetSurroundings() {
    return this._widgetSurroundings;
  }
}

/**
 * The egw_action system requires an egwActionObjectInterface Interface implementation
 * to tie actions to DOM nodes.  This one can be used by any widget.
 *
 * The class extension is different than the widgets
 *
 * @param {et2_DOMWidget} widget
 * @param {Object} node
 *
 */
class et2_action_object_impl {
  constructor(_widget, _node) {
    _defineProperty$2d(this, "aoi", void 0);
    var widget = _widget;
    var objectNode = _node;
    this.aoi = new egwActionObjectInterface();
    this.aoi.getWidget = function () {
      return widget;
    };
    this.aoi.doGetDOMNode = function () {
      return objectNode ? objectNode : widget.getDOMNode();
    };

    // _outerCall may be used to determine, whether the state change has been
    // evoked from the outside and the stateChangeCallback has to be called
    // or not.
    this.aoi.doSetState = function (_state, _outerCall) {};

    // The doTiggerEvent function may be overritten by the aoi if it wants to
    // support certain action implementation specific events like EGW_AI_DRAG_OVER
    // or EGW_AI_DRAG_OUT
    this.aoi.doTriggerEvent = function (_event, _data) {
      switch (_event) {
        case EGW_AI_DRAG_OVER:
          jQuery(this.node).addClass("ui-state-active");
          break;
        case EGW_AI_DRAG_OUT:
          jQuery(this.node).removeClass("ui-state-active");
          break;
      }
    };
  }
  getAOI() {
    return this.aoi;
  }
}

function _defineProperty$2c(e, r, t) { return (r = _toPropertyKey$2b(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2b(t) { var i = _toPrimitive$2b(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2b(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * Class which manages the DOM node itself. The simpleWidget class is derrived
 * from et2_DOMWidget and implements the getDOMNode function. A setDOMNode
 * function is provided, which attatches the given node to the DOM if possible.
 *
 * @augments et2_DOMWidget
 */
class et2_baseWidget extends et2_DOMWidget {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_baseWidget._attributes, _child || {}));
    _defineProperty$2c(this, "align", 'left');
    _defineProperty$2c(this, "node", null);
    _defineProperty$2c(this, "statustext", '');
    _defineProperty$2c(this, "_messageDiv", null);
    _defineProperty$2c(this, "_tooltipElem", null);
    _defineProperty$2c(this, "onclick", void 0);
  }
  destroy() {
    super.destroy();
    this.node = null;
    this._messageDiv = null;
  }

  /**
   * The setMessage function can be used to attach a small message box to the
   * widget. This is e.g. used to display validation errors or success messages
   *
   * @param _text is the text which should be displayed as a message
   * @param _type is an css class which is attached to the message box.
   * 	Currently available are "hint", "success" and "validation_error", defaults
   * 	to "hint"
   * @param _floating if true, the object will be in one row with the element,
   * 	defaults to true
   * @param _prepend if set, the message is displayed behind the widget node
   * 	instead of before. Defaults to false.
   */
  showMessage(_text, _type, _floating, _prepend) {
    // Preset the parameters
    if (typeof _type == "undefined") {
      _type = "hint";
    }
    if (typeof _floating == "undefined") {
      _floating = true;
    }
    if (typeof _prepend == "undefined") {
      _prepend = false;
    }
    var surr = this.getSurroundings();

    // Remove the message div from the surroundings before creating a new
    // one
    this.hideMessage(false, true);

    // Create the message div and add it to the "surroundings" manager
    this._messageDiv = jQuery(document.createElement("div")).addClass("message").addClass(_type).addClass(_floating ? "floating" : "").text(_text.valueOf() + "");

    // Decide whether to prepend or append the div
    if (_prepend) {
      surr.prependDOMNode(this._messageDiv[0]);
    } else {
      surr.appendDOMNode(this._messageDiv[0]);
    }
    surr.update();
  }

  /**
   * The hideMessage function can be used to hide a previously shown message.
   *
   * @param _fade if true, the message div will fade out, otherwise the message
   * 	div is removed immediately. Defaults to true.
   * @param _noUpdate is used internally to prevent an update of the surroundings
   * 	manager.
   */
  hideMessage(_fade, _noUpdate) {
    if (typeof _fade == "undefined") {
      _fade = true;
    }
    if (typeof _noUpdate == "undefined") {
      _noUpdate = false;
    }

    // Remove the message from the surroundings manager and remove the
    // reference to it
    if (this._messageDiv != null) {
      var surr = this.getSurroundings();
      var self = this;
      var messageDiv = this._messageDiv;
      self._messageDiv = null;
      var _done = function _done() {
        surr.removeDOMNode(messageDiv[0]);

        // Update the surroundings manager
        if (!_noUpdate) {
          surr.update();
        }
      };

      // Either fade out or directly call the function which removes the div
      if (_fade) {
        messageDiv.fadeOut("fast", _done);
      } else {
        _done();
      }
    }
  }
  detachFromDOM() {
    // Detach this node from the tooltip node
    if (this._tooltipElem) {
      this.egw().tooltipUnbind(this._tooltipElem);
      this._tooltipElem = null;
    }

    // Remove the binding to the click handler
    if (this.node && typeof this.node.removeEventListener == "function") {
      this.node.removeEventListener("click", this.click);
    }
    return super.detachFromDOM();
  }
  attachToDOM() {
    var ret = super.attachToDOM();

    // Add the binding for the click handler
    if (this.node) {
      this.node.addEventListener("click", this.click);
      if (typeof this.onclick == 'function') jQuery(this.node).addClass('et2_clickable');
    }

    // Update the statustext
    this.set_statustext(this.statustext);
    return ret;
  }
  setDOMNode(_node) {
    if (_node != this.node) {
      // Deatch the old node from the DOM
      this.detachFromDOM();

      // Set the new DOM-Node
      this.node = _node;

      // Attatch the DOM-Node to the tree
      return this.attachToDOM();
    }
    return false;
  }
  getDOMNode(_sender) {
    return this.node;
  }
  getTooltipElement() {
    return this.getDOMNode(this);
  }

  /**
   * Click handler calling custom handler set via onclick attribute to this.onclick
   *
   * @param _ev
   * @returns
   */
  click(_ev) {
    if (typeof this.onclick == 'function') {
      // Make sure function gets a reference to the widget, splice it in as 2. argument if not
      var args = Array.prototype.slice.call(arguments);
      if (args.indexOf(this) == -1) args.splice(1, 0, this);
      return this.onclick.apply(this, args);
    }
    return true;
  }
  set_statustext(_value) {
    // Tooltip should not be shown in mobile view
    if (egwIsMobile$1()) return;
    // Don't execute the code below, if no tooltip will be attached/detached
    if (_value == "" && !this._tooltipElem) {
      return;
    }
    this.statustext = _value;

    //Get the domnode the tooltip should be attached to
    var elem = jQuery(this.getTooltipElement());
    if (elem) {
      // Make readable by screenreader
      elem.attr("aria-description", this.statustext);

      //If a tooltip is already attached to the element, remove it first
      if (this._tooltipElem) {
        this.egw().tooltipUnbind(this._tooltipElem);
        this._tooltipElem = null;
      }
      if (_value && _value != '') {
        this.egw().tooltipBind(elem, _value, this.options.statustext_html);
        this._tooltipElem = elem;
      }
    }
  }
  set_align(_value) {
    this.align = _value;
  }
  get_align() {
    return this.align;
  }
}

/**
 * Simple container object
 *
 * There is no tag to put this in a template.  By convention we only make one of these per etemplate,
 * and it's the top level object.
 */
_defineProperty$2c(et2_baseWidget, "_attributes", {
  "statustext": {
    "name": "Tooltip",
    "type": "string",
    "description": "Tooltip which is shown for this element",
    "translate": true
  },
  "statustext_html": {
    "name": "Tooltip is html",
    "type": "boolean",
    "description": "Flag to allow html content in tooltip",
    "default": false
  },
  "align": {
    "name": "Align",
    "type": "string",
    "default": "left",
    "description": "Position of this element in the parent hbox"
  },
  "onclick": {
    "name": "onclick",
    "type": "js",
    "default": et2_no_init,
    "description": "JS code which is executed when the element is clicked."
  }
});
class et2_container extends et2_baseWidget {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_container._attributes, _child || {}));
    this.setDOMNode(document.createElement("div"));
  }

  /**
   * The destroy function destroys all children of the widget, removes itself
   * from the parents children list.
   * Overriden to not try to remove self from parent, as that's not possible.
   */
  destroy() {
    // Call the destructor of all children
    for (var i = this._children.length - 1; i >= 0; i--) {
      this._children[i].destroy();
    }

    // Free the array managers if they belong to this widget
    for (var key in this._mgrs) {
      if (this._mgrs[key] && this._mgrs[key].owner == this) {
        this._mgrs[key].destroy();
      }
    }
  }

  /**
   * Searches for a DOM widget by id in the tree, descending into the child levels.
   *
   * @param _id is the id you're searching for
   */
  getDOMWidgetById(_id) {
    var widget = this.getWidgetById(_id);
    if (widget && (widget instanceof HTMLElement || widget.instanceOf(et2_DOMWidget))) {
      return widget;
    }
    return null;
  }

  /**
   * Searches for a Value widget by id in the tree, descending into the child levels.
   *
   * @param _id is the id you're searching for
   */
  getInputWidgetById(_id) {
    var widget = this.getWidgetById(_id);
    // instead of checking widget to be instance of valueWidget (which would create a circular dependency)
    // we check for the interface/methods of valueWidget
    if (widget && typeof widget.get_value === 'function' && typeof widget.set_value === 'function') {
      return widget;
    }
    return null;
  }

  /**
   * Set the value for a child widget, specified by the given ID
   *
   * @param id  string The ID you're searching for
   * @param value Value for the widget
   *
   * @return Returns the result of widget's set_value(), though this is usually undefined
   *
   * @throws Error If the widget cannot be found or it does not have a set_value() function
   */
  setValueById(id, value) {
    var widget = this.getWidgetById(id);
    if (!widget) throw 'Could not find widget ' + id;

    // Don't care about what class it is, just that it has the function
    // @ts-ignore
    if (typeof widget.set_value !== 'function') {
      throw 'Widget ' + id + ' does not have a set_value() function';
    }

    // @ts-ignore
    return widget.set_value(value);
  }

  /**
   * Get the current value of a child widget, specified by the given ID
   *
   * This is the current value of the widget, which may be different from the original value given in content
   *
   * @param id  string The ID you're searching for
   * @throws Error If the widget cannot be found or it does not have a set_value() function
   */
  getValueById(id) {
    var widget = this.getWidgetById(id);
    if (!widget) throw 'Could not find widget ' + id;

    // Don't care about what class it is, just that it has the function
    // @ts-ignore
    if (typeof widget.get_value !== 'function' && typeof widget.value == "undefined") {
      throw 'Widget ' + id + ' does not have a get_value() function';
    }

    // @ts-ignore
    return typeof widget.get_value == "function" ? widget.get_value() : widget.value;
  }

  /**
   * Set the value for a child widget, specified by the given ID
   *
   * @param id  string The ID you're searching for
   * @throws Error If the widget cannot be found or it does not have a set_value() function
   */
  setDisabledById(id, value) {
    var widget = this.getWidgetById(id);
    if (!widget) throw 'Could not find widget ' + id;

    // Don't care about what class it is, just that it has the function
    // @ts-ignore
    if (typeof widget.set_disabled !== 'function') {
      throw 'Widget ' + id + ' does not have a set_disabled() function';
    }

    // @ts-ignore
    return widget.set_disabled(value);
  }
}
// Register widget for attributes, but not for any xml tags
et2_register_widget(et2_container, []);

/**
 * Container object for not-yet supported widgets
 *
 * @augments et2_baseWidget
 */
class et2_placeholder extends et2_baseWidget {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_placeholder._attributes, _child || {}));
    /**
     *  he attrNodes object will hold the DOM nodes which represent the
     * values of this object
     */
    _defineProperty$2c(this, "attrNodes", void 0);
    _defineProperty$2c(this, "visible", false);
    _defineProperty$2c(this, "placeDiv", void 0);
    this.attrNodes = {};

    // Create the placeholder div
    this.placeDiv = jQuery(document.createElement("span")).addClass("et2_placeholder");
    var headerNode = jQuery(document.createElement("span")).text(this.getType() || "").addClass("et2_caption").appendTo(this.placeDiv);
    var attrsCntr = jQuery(document.createElement("span")).appendTo(this.placeDiv).hide();
    headerNode.click(this, function (e) {
      e.data.visible = !e.data.visible;
      if (e.data.visible) {
        attrsCntr.show();
      } else {
        attrsCntr.hide();
      }
    });
    for (var key in this.options) {
      if (typeof this.options[key] != "undefined") {
        if (typeof this.attrNodes[key] == "undefined") {
          this.attrNodes[key] = jQuery(document.createElement("span")).addClass("et2_attr");
          attrsCntr.append(this.attrNodes[key]);
        }
        this.attrNodes[key].text(key + "=" + this.options[key]);
      }
    }
    this.setDOMNode(this.placeDiv[0]);
  }
  getDetachedAttributes(_attrs) {
    _attrs.push("value");
  }
  getDetachedNodes() {
    return [this.placeDiv[0]];
  }
  setDetachedAttributes(_nodes, _values) {
    this.placeDiv = jQuery(_nodes[0]);
  }
}
// Register widget, but no tags
et2_register_widget(et2_placeholder, ['placeholder', 'placeholder_ro']);

var es_string_search = {};

// `SameValue` abstract operation
// https://tc39.es/ecma262/#sec-samevalue
// eslint-disable-next-line es/no-object-is -- safe
var sameValue$1 = Object.is || function is(x, y) {
  // eslint-disable-next-line no-self-compare -- NaN check
  return x === y ? x !== 0 || 1 / x === 1 / y : x != x && y != y;
};

'use strict';
var call$4 = functionCall;
var fixRegExpWellKnownSymbolLogic = fixRegexpWellKnownSymbolLogic;
var anObject$2 = anObject$b;
var isNullOrUndefined = isNullOrUndefined$6;
var requireObjectCoercible$2 = requireObjectCoercible$7;
var sameValue = sameValue$1;
var toString$4 = toString$b;
var getMethod = getMethod$6;
var regExpExec = regexpExecAbstract;

// @@search logic
fixRegExpWellKnownSymbolLogic('search', function (SEARCH, nativeSearch, maybeCallNative) {
  return [
    // `String.prototype.search` method
    // https://tc39.es/ecma262/#sec-string.prototype.search
    function search(regexp) {
      var O = requireObjectCoercible$2(this);
      var searcher = isNullOrUndefined(regexp) ? undefined : getMethod(regexp, SEARCH);
      return searcher ? call$4(searcher, regexp, O) : new RegExp(regexp)[SEARCH](toString$4(O));
    },
    // `RegExp.prototype[@@search]` method
    // https://tc39.es/ecma262/#sec-regexp.prototype-@@search
    function (string) {
      var rx = anObject$2(this);
      var S = toString$4(string);
      var res = maybeCallNative(nativeSearch, rx, S);

      if (res.done) return res.value;

      var previousLastIndex = rx.lastIndex;
      if (!sameValue(previousLastIndex, 0)) rx.lastIndex = 0;
      var result = regExpExec(rx, S);
      if (!sameValue(rx.lastIndex, previousLastIndex)) rx.lastIndex = previousLastIndex;
      return result === null ? -1 : result.index;
    }
  ];
});

var esnext_promise_allSettled = {};

var es_promise_allSettled = {};

'use strict';
var $$b = _export;
var call$3 = functionCall;
var aCallable = aCallable$a;
var newPromiseCapabilityModule = newPromiseCapability$2;
var perform = perform$4;
var iterate$1 = iterate$4;
var PROMISE_STATICS_INCORRECT_ITERATION = promiseStaticsIncorrectIteration;

// `Promise.allSettled` method
// https://tc39.es/ecma262/#sec-promise.allsettled
$$b({ target: 'Promise', stat: true, forced: PROMISE_STATICS_INCORRECT_ITERATION }, {
  allSettled: function allSettled(iterable) {
    var C = this;
    var capability = newPromiseCapabilityModule.f(C);
    var resolve = capability.resolve;
    var reject = capability.reject;
    var result = perform(function () {
      var promiseResolve = aCallable(C.resolve);
      var values = [];
      var counter = 0;
      var remaining = 1;
      iterate$1(iterable, function (promise) {
        var index = counter++;
        var alreadyCalled = false;
        remaining++;
        call$3(promiseResolve, C, promise).then(function (value) {
          if (alreadyCalled) return;
          alreadyCalled = true;
          values[index] = { status: 'fulfilled', value: value };
          --remaining || resolve(values);
        }, function (error) {
          if (alreadyCalled) return;
          alreadyCalled = true;
          values[index] = { status: 'rejected', reason: error };
          --remaining || resolve(values);
        });
      });
      --remaining || resolve(values);
    });
    if (result.error) reject(result.value);
    return capability.promise;
  }
});

var es_promise_finally = {};

'use strict';
var $$a = _export;
var IS_PURE$2 = isPure;
var NativePromiseConstructor = promiseNativeConstructor;
var fails$1 = fails$e;
var getBuiltIn = getBuiltIn$5;
var isCallable$1 = isCallable$e;
var speciesConstructor = speciesConstructor$3;
var promiseResolve = promiseResolve$2;
var defineBuiltIn$3 = defineBuiltIn$9;

var NativePromisePrototype = NativePromiseConstructor && NativePromiseConstructor.prototype;

// Safari bug https://bugs.webkit.org/show_bug.cgi?id=200829
var NON_GENERIC = !!NativePromiseConstructor && fails$1(function () {
  // eslint-disable-next-line unicorn/no-thenable -- required for testing
  NativePromisePrototype['finally'].call({ then: function () { /* empty */ } }, function () { /* empty */ });
});

// `Promise.prototype.finally` method
// https://tc39.es/ecma262/#sec-promise.prototype.finally
$$a({ target: 'Promise', proto: true, real: true, forced: NON_GENERIC }, {
  'finally': function (onFinally) {
    var C = speciesConstructor(this, getBuiltIn('Promise'));
    var isFunction = isCallable$1(onFinally);
    return this.then(
      isFunction ? function (x) {
        return promiseResolve(C, onFinally()).then(function () { return x; });
      } : onFinally,
      isFunction ? function (e) {
        return promiseResolve(C, onFinally()).then(function () { throw e; });
      } : onFinally
    );
  }
});

// makes sure that native promise-based APIs `Promise#finally` properly works with patched `Promise#then`
if (!IS_PURE$2 && isCallable$1(NativePromiseConstructor)) {
  var method = getBuiltIn('Promise').prototype['finally'];
  if (NativePromisePrototype['finally'] !== method) {
    defineBuiltIn$3(NativePromisePrototype, 'finally', method, { unsafe: true });
  }
}

function _defineProperty$2b(e, r, t) { return (r = _toPropertyKey$2a(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2a(t) { var i = _toPrimitive$2a(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2a(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * et2_valueWidget is the base class for et2_inputWidget - valueWidget introduces
 * the "value" attribute and automatically loads it from the "content" array
 * after loading from XML.
 */
class et2_valueWidget extends et2_baseWidget {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_valueWidget._attributes, _child || {}));
    _defineProperty$2b(this, "label", '');
    _defineProperty$2b(this, "value", void 0);
    _defineProperty$2b(this, "_labelContainer", null);
  }

  /**
   *
   * @param _attrs
   */
  transformAttributes(_attrs) {
    super.transformAttributes(_attrs);
    if (this.id) {
      // Set the value for this element
      var contentMgr = this.getArrayMgr("content");
      if (contentMgr != null) {
        var val = contentMgr.getEntry(this.id, false, true);
        if (val !== null) {
          _attrs["value"] = val;
        }
      }
      // Check for already inside namespace
      if (this._createNamespace() && this.getArrayMgr("content").perspectiveData.owner == this) {
        _attrs["value"] = this.getArrayMgr("content").data;
      }
    }
  }
  set_label(_value) {
    // Abort if there was no change in the label
    if (_value == this.label) {
      return;
    }
    if (_value) {
      // Create the label container if it didn't exist yet
      if (this._labelContainer == null) {
        this._labelContainer = jQuery(document.createElement("label")).addClass("et2_label");
        this.getSurroundings().insertDOMNode(this._labelContainer[0]);
      }

      // Clear the label container.
      this._labelContainer.empty();

      // Create the placeholder element and set it
      var ph = document.createElement("span");
      this.getSurroundings().setWidgetPlaceholder(ph);

      // Split the label at the "%s"
      var parts = et2_csvSplit(_value, 2, "%s");

      // Update the content of the label container
      for (var i = 0; i < parts.length; i++) {
        if (parts[i]) {
          this._labelContainer.append(document.createTextNode(parts[i]));
        }
        if (i == 0) {
          this._labelContainer.append(ph);
        }
      }

      // add class if label is empty
      this._labelContainer.toggleClass('et2_label_empty', !_value || !parts[0]);
    } else {
      // Delete the labelContainer from the surroundings object
      if (this._labelContainer) {
        this.getSurroundings().removeDOMNode(this._labelContainer[0]);
      }
      this._labelContainer = null;
    }

    // Update the surroundings in order to reflect the change in the label
    this.getSurroundings().update();

    // Copy the given value
    this.label = _value;
  }
  get_value() {
    return this.value;
  }

  /**
   * Set value of widget
   *
   * @param {string} _value value to set
   */
  set_value(_value) {
    this.value = _value;
  }
}
_defineProperty$2b(et2_valueWidget, "_attributes", {
  "label": {
    "name": "Label",
    "default": "",
    "type": "string",
    "description": "The label is displayed by default in front (for radiobuttons behind) each widget (if not empty). If you want to specify a different position, use a '%s' in the label, which gets replaced by the widget itself. Eg. '%s Name' to have the label Name behind a checkbox. The label can contain variables, as descript for name. If the label starts with a '@' it is replaced by the value of the content-array at this index (with the '@'-removed and after expanding the variables).",
    "translate": true
  },
  "value": {
    "name": "Value",
    "description": "The value of the widget",
    "type": "rawstring",
    // no html-entity decoding
    "default": et2_no_init
  }
});

function _defineProperty$2a(e, r, t) { return (r = _toPropertyKey$29(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$29(t) { var i = _toPrimitive$29(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$29(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
// fixing circular dependencies by only importing the type (not in compiled .js)

/**
 * et2_inputWidget derrives from et2_simpleWidget and implements the IInput
 * interface. When derriving from this class, call setDOMNode with an input
 * DOMNode.
 */
class et2_inputWidget extends et2_valueWidget {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_inputWidget._attributes, _child || {}));

    // mark value as not initialised, so set_value can determine if it is necessary to trigger change event
    _defineProperty$2a(this, "_oldValue", void 0);
    _defineProperty$2a(this, "onchange", void 0);
    this._oldValue = et2_no_init;
    this._labelContainer = null;
  }
  destroy() {
    var node = this.getInputNode();
    if (node) {
      jQuery(node).unbind("change.et2_inputWidget");
      jQuery(node).unbind("focus");
    }
    super.destroy();
    this._labelContainer = null;
  }

  /**
   * Make sure dirty flag is properly set
   */
  doLoadingFinished() {
    var result = super.doLoadingFinished();
    this.resetDirty();
    return result;
  }

  /**
   * Load the validation errors from the server
   *
   * @param {object} _attrs
   */
  transformAttributes(_attrs) {
    super.transformAttributes(_attrs);

    // Check whether an validation error entry exists
    if (this.id && this.getArrayMgr("validation_errors")) {
      var val = this.getArrayMgr("validation_errors").getEntry(this.id);
      if (val) {
        _attrs["validation_error"] = val;
      }
    }
  }
  attachToDOM() {
    var node = this.getInputNode();
    if (node) {
      jQuery(node).off('.et2_inputWidget').bind("change.et2_inputWidget", this, function (e) {
        e.data.change.call(e.data, this);
      }).bind("focus.et2_inputWidget", this, function (e) {
        e.data.focus.call(e.data, this);
      });
    }
    return super.attachToDOM();

    //		jQuery(this.getInputNode()).attr("novalidate","novalidate"); // Stop browser from getting involved
    //		jQuery(this.getInputNode()).validator();
  }

  detatchFromDOM() {
    //		if(this.getInputNode()) {
    //			jQuery(this.getInputNode()).data("validator").destroy();
    //		}
    super.detachFromDOM();
  }
  change(_node, _widget, _value) {
    var messages = [];
    var valid = this.isValid(messages);

    // Passing false will clear any set messages
    this.set_validation_error(valid ? false : messages);
    if (valid && this.onchange) {
      if (typeof this.onchange == 'function') {
        // Make sure function gets a reference to the widget
        var args = Array.prototype.slice.call(arguments);
        if (args.indexOf(this) == -1) args.push(this);
        return this.onchange.apply(this, args);
      } else {
        return et2_compileLegacyJS(this.options.onchange, this, _node)();
      }
    }
    return valid;
  }
  focus(_node) {
    if (typeof this.options.onfocus == 'function') {
      // Make sure function gets a reference to the widget
      var args = Array.prototype.slice.call(arguments);
      if (args.indexOf(this) == -1) args.push(this);
      return this.options.onfocus.apply(this, args);
    }
  }

  /**
   * Set value of widget and trigger for real changes a change event
   *
   * First initialisation (_oldValue === et2_no_init) is NOT considered a change!
   *
   * @param {string} _value value to set
   */
  set_value(_value) {
    var node = this.getInputNode();
    if (node) {
      jQuery(node).val(_value);
      if (this.isAttached() && this._oldValue !== et2_no_init && this._oldValue !== _value) {
        jQuery(node).change();
      }
    }
    this._oldValue = _value;
  }
  set_id(_value) {
    this.id = _value;
    this.dom_id = _value && this.getInstanceManager() ? this.getInstanceManager().uniqueId + '_' + this.id : _value;

    // Set the id of the _input_ node (in contrast to the default
    // implementation, which sets the base node)
    var node = this.getInputNode();
    if (node) {
      // Unique ID to prevent DOM collisions across multiple templates
      if (_value != "") {
        node.setAttribute("id", this.dom_id);
        node.setAttribute("name", _value);
      } else {
        node.removeAttribute("id");
        node.removeAttribute("name");
      }
    }
  }
  set_needed(_value) {
    var node = this.getInputNode();
    if (node) {
      if (_value && !this.options.readonly) {
        jQuery(node).attr("required", "required");
      } else {
        node.removeAttribute("required");
      }
    }
  }
  set_validation_error(_value) {
    var node = this.getInputNode();
    if (node) {
      if (_value === false) {
        this.hideMessage();
        jQuery(node).removeClass("invalid");
      } else {
        this.showMessage(_value, "validation_error");
        jQuery(node).addClass("invalid");

        // If on a tab, switch to that tab so user can see it
        var widget = this;
        while (widget.getParent() && widget.getType() !== 'et2-tabbox') {
          widget = widget.getParent();
        }
        if (widget.getType() == 'et2-tabbox') widget.activateTab(this);
      }
    }
  }

  /**
   * Set tab index
   *
   * @param {number} index
   */
  set_tabindex(index) {
    jQuery(this.getInputNode()).attr("tabindex", index);
  }
  getInputNode() {
    return this.node;
  }
  get_value() {
    return this.getValue();
  }

  /**
   * @param boolean submit_value true: call by etemplate2.(getValues|submit|postSubmit)()
   */
  getValue(submit_value) {
    var node = this.getInputNode();
    if (node) {
      var val = jQuery(node).val();
      return val;
    }
    return this._oldValue;
  }
  isDirty() {
    var value = this.getValue();
    if (typeof value !== typeof this._oldValue) {
      return true;
    }
    if (this._oldValue === value) {
      return false;
    }
    switch (typeof this._oldValue) {
      case "object":
        if (typeof this._oldValue.length !== "undefined" && this._oldValue.length !== value.length) {
          return true;
        }
        for (var key in this._oldValue) {
          if (this._oldValue[key] !== value[key]) return true;
        }
        return false;
      default:
        return this._oldValue != value;
    }
  }
  resetDirty() {
    this._oldValue = this.getValue();
  }
  isValid(messages) {
    var ok = true;

    // Check for required
    if (this.options && this.options.needed && !this.options.readonly && !this.disabled && (this.getValue() == null || this.getValue().valueOf() == '')) {
      messages.push(this.egw().lang('Field must not be empty !!!'));
      ok = false;
    }
    return ok;
  }

  /**
   * Called whenever the template gets submitted. We return false if the widget
   * is not valid, which cancels the submission.
   *
   * @param _values contains the values which will be sent to the server.
   * 	Listeners may change these values before they get submitted.
   */
  submit(_values) {
    var messages = [];
    var valid = this.isValid(messages);

    // Passing false will clear any set messages
    this.set_validation_error(valid ? false : messages);
    return valid;
  }
}
_defineProperty$2a(et2_inputWidget, "_attributes", {
  "needed": {
    "name": "Required",
    "default": false,
    "type": "boolean",
    "description": "If required, the user must enter a value before the form can be submitted"
  },
  "onchange": {
    "name": "onchange",
    "type": "js",
    "default": et2_no_init,
    "description": "JS code which is executed when the value changes."
  },
  "onfocus": {
    "name": "onfocus",
    "type": "js",
    "default": et2_no_init,
    "description": "JS code which get executed when wiget receives focus."
  },
  "validation_error": {
    "name": "Validation Error",
    "type": "string",
    "default": et2_no_init,
    "description": "Used internally to store the validation error that came from the server."
  },
  "tabindex": {
    "name": "Tab index",
    "type": "integer",
    "default": et2_no_init,
    "description": "Specifies the tab order of a widget when the 'tab' button is used for navigating."
  },
  readonly: {
    name: "readonly",
    type: "boolean",
    "default": false,
    description: "Does NOT allow user to enter data, just displays existing data"
  }
});

var es_object_fromEntries = {};

var $$9 = _export;
var iterate = iterate$4;
var createProperty$1 = createProperty$3;

// `Object.fromEntries` method
// https://github.com/tc39/proposal-object-from-entries
$$9({ target: 'Object', stat: true }, {
  fromEntries: function fromEntries(iterable) {
    var obj = {};
    iterate(iterable, function (k, v) {
      createProperty$1(obj, k, v);
    }, { AS_ENTRIES: true });
    return obj;
  }
});

/**
 * @license
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */const e$k=Symbol.for(""),l$9=t=>{if((null==t?void 0:t.r)===e$k)return null==t?void 0:t._$litStatic$},o$m=t=>({_$litStatic$:t,r:e$k}),i$b=(t,...r)=>({_$litStatic$:r.reduce(((r,e,l)=>r+(t=>{if(void 0!==t._$litStatic$)return t._$litStatic$;throw Error(`Value passed to 'literal' function must be a 'literal' result: ${t}. Use 'unsafeStatic' to pass non-literal values, but\n            take care to ensure page security.`)})(e)+t[l+1]),t[0]),r:e$k}),s$7=new Map,a$4=t=>(r,...e)=>{const o=e.length;let i,a;const n=[],u=[];let c,$=0,f=!1;for(;$<o;){for(c=r[$];$<o&&void 0!==(a=e[$],i=l$9(a));)c+=i+r[++$],f=!0;$!==o&&u.push(a),n.push(c),$++;}if($===o&&n.push(r[o]),f){const t=n.join("$$lit$$");void 0===(r=s$7.get(t))&&(n.raw=n,s$7.set(t,r=n)),e=u;}return t(r,...e)},n$f=a$4(x$2),u$5=a$4(b$3);

function _defineProperty$29(e, r, t) { return (r = _toPropertyKey$28(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$28(t) { var i = _toPrimitive$28(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$28(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * A reactive controller that determines when slots exist.
 *
 * Copied from Shoelace
 * /src/internal/slot.ts
 */
class HasSlotController$1 {
  constructor(host) {
    _defineProperty$29(this, "host", void 0);
    _defineProperty$29(this, "slotNames", []);
    _defineProperty$29(this, "handleSlotChange", event => {
      var slot = event.target;
      if (this.slotNames.includes('[default]') && !slot.name || slot.name && this.slotNames.includes(slot.name)) {
        this.host.requestUpdate();
      }
    });
    (this.host = host).addController(this);
    for (var _len = arguments.length, slotNames = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      slotNames[_key - 1] = arguments[_key];
    }
    this.slotNames = slotNames;
  }
  hasDefaultSlot() {
    return [...this.host.childNodes].some(node => {
      if (node.nodeType === node.TEXT_NODE && node.textContent.trim() !== '') {
        return true;
      }
      if (node.nodeType === node.ELEMENT_NODE) {
        var el = node;
        var tagName = el.tagName.toLowerCase();

        // Ignore visually hidden elements since they aren't rendered
        if (tagName === 'sl-visually-hidden') {
          return false;
        }

        // If it doesn't have a slot attribute, it's part of the default slot
        if (!el.hasAttribute('slot')) {
          return true;
        }
      }
      return false;
    });
  }
  hasNamedSlot(name) {
    return this.host.querySelector(":scope > [slot=\"".concat(name, "\"]")) !== null;
  }
  test(slotName) {
    return slotName === '[default]' ? this.hasDefaultSlot() : this.hasNamedSlot(slotName);
  }
  hostConnected() {
    this.host.shadowRoot.addEventListener('slotchange', this.handleSlotChange);
  }
  hostDisconnected() {
    this.host.shadowRoot.removeEventListener('slotchange', this.handleSlotChange);
  }
}

/**
 * Given a slot, this function iterates over all of its assigned element and text nodes and returns the concatenated
 * HTML as a string. This is useful because we can't use slot.innerHTML as an alternative.
 */
function getInnerHTML(slot) {
  var nodes = slot.assignedNodes({
    flatten: true
  });
  var html = '';
  [...nodes].forEach(node => {
    if (node.nodeType === Node.ELEMENT_NODE) {
      html += node.outerHTML;
    }
    if (node.nodeType === Node.TEXT_NODE) {
      html += node.textContent;
    }
  });
  return html;
}

/**
 * Given a slot, this function iterates over all of its assigned text nodes and returns the concatenated text as a
 * string. This is useful because we can't use slot.textContent as an alternative.
 */
function getTextContent$1(slot) {
  if (!slot) {
    return '';
  }
  var nodes = slot.assignedNodes({
    flatten: true
  });
  var text = '';
  [...nodes].forEach(node => {
    if (node.nodeType === Node.TEXT_NODE) {
      text += node.textContent;
    }
  });
  return text;
}

function ownKeys$R(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$Q(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$R(Object(t), !0).forEach(function (r) { _defineProperty$28(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$R(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty$28(e, r, t) { return (r = _toPropertyKey$27(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$27(t) { var i = _toPrimitive$27(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$27(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function asyncGeneratorStep$D(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator$D(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep$D(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep$D(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
class Validator {
  /**
   *
   * @param {?} [param]
   * @param {Object.<string,?>} [config]
   */
  constructor(param, config) {
    /** @type {?} */
    this.__param = param;

    /** @type {Object.<string,?>} */
    this.__config = config || {};
    this.type = config && config.type || 'error'; // Default type supported by ValidateMixin
  }

  static get validatorName() {
    return '';
  }

  /**
   * @desc The function that returns a Boolean
   * @param {?} [modelValue]
   * @param {?} [param]
   * @param {{}} [config]
   * @returns {Boolean|Promise<Boolean>}
   */
  // eslint-disable-next-line no-unused-vars, class-methods-use-this
  execute(modelValue, param, config) {
    var ctor = /** @type {typeof Validator} */this.constructor;
    if (!ctor.validatorName) {
      throw new Error('A validator needs to have a name! Please set it via "static get validatorName() { return \'IsCat\'; }"');
    }
    return true;
  }
  set param(p) {
    this.__param = p;
    if (this.dispatchEvent) {
      this.dispatchEvent(new Event('param-changed'));
    }
  }
  get param() {
    return this.__param;
  }
  set config(c) {
    this.__config = c;
    if (this.dispatchEvent) {
      this.dispatchEvent(new Event('config-changed'));
    }
  }
  get config() {
    return this.__config;
  }

  /**
   * @overridable
   * @param {MessageData} [data]
   * @returns {Promise<string|Node>}
   * @protected
   */
  _getMessage(data) {
    var _this = this;
    return _asyncToGenerator$D(function* () {
      var ctor = /** @type {typeof Validator} */_this.constructor;
      var composedData = _objectSpread$Q({
        name: ctor.validatorName,
        type: _this.type,
        params: _this.param,
        config: _this.config
      }, data);
      if (_this.config.getMessage) {
        if (typeof _this.config.getMessage === 'function') {
          return _this.config.getMessage(composedData);
        }
        throw new Error("You must provide a value for getMessage of type 'function', you provided a value of type: ".concat(typeof _this.config.getMessage));
      }
      return ctor.getMessage(composedData);
    })();
  }
}

function asyncGeneratorStep$C(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator$C(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep$C(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep$C(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }

/**
 * Manual validator for server-side validation messages passed
 * from Etemplate.  It just gives whatever message is passed in when created.
 *
 */
class ManualMessage extends Validator {
  static get validatorName() {
    return "ManualMessage";
  }
  static getMessage(_ref) {
    return _asyncToGenerator$C(function* () {
      var {
        fieldName,
        modelValue,
        formControl,
        params
      } = _ref;
      return params;
    })();
  }
}

function asyncGeneratorStep$B(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator$B(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep$B(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep$B(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
class Required extends Validator {
  /**
   * Returns a Boolean.  True if the test fails
   * @param {?} [modelValue]
   * @param {?} [param]
   * @param {{}} [config]
   * @returns {Boolean|Promise<Boolean>}
   */
  execute(modelValue, param, config) {
    return modelValue == "" || modelValue == undefined || modelValue == null;
  }

  /**
   * Give a message about this field being required.  Could be customised according to MessageData.
   * @param {MessageData | undefined} data
   * @returns {Promise<string>}
   */
  static getMessage(data) {
    return _asyncToGenerator$B(function* () {
      return data.formControl.egw().lang("Field must not be empty !!!");
    })();
  }
}

var _templateObject$1B, _templateObject2$Z, _templateObject3$H;
function ownKeys$Q(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$P(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$Q(Object(t), !0).forEach(function (r) { _defineProperty$27(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$Q(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _taggedTemplateLiteral$1B(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
function _defineProperty$27(e, r, t) { return (r = _toPropertyKey$26(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$26(t) { var i = _toPrimitive$26(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$26(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _applyDecoratedDescriptor$J(i, e, r, n, l) { var a = {}; return Object.keys(n).forEach(function (i) { a[i] = n[i]; }), a.enumerable = !!a.enumerable, a.configurable = !!a.configurable, ("value" in a || a.initializer) && (a.writable = !0), a = r.slice().reverse().reduce(function (r, n) { return n(i, e, r) || r; }, a), l && void 0 !== a.initializer && (a.value = a.initializer ? a.initializer.call(l) : void 0, a.initializer = void 0), void 0 === a.initializer ? (Object.defineProperty(i, e, a), null) : a; }
function asyncGeneratorStep$A(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator$A(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep$A(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep$A(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }

/**
 * This mixin will allow any LitElement to become an Et2InputWidget
 *
 * Usage:
 * export class Et2Button extends Et2InputWidget(LitWidget)) {...}
 */
/**
 * Need to define the interface first, to get around TypeScript issues with protected/public
 * This must match the public API for Et2InputWidgetClass
 * @see https://lit.dev/docs/composition/mixins/#typing-the-subclass
 */
/**
 * Massively simplified validate, as compared to what ValidatorMixin gives us, since ValidatorMixin extends
 * FormControlMixin which breaks SlSelect's render()
 *
 * We take all validators for the widget, and if there's a value (or field is required) we check the value
 * with each validator.  For array values we check each element with each validator.  If the value does not
 * pass the validator, we collect the message and display feedback to the user.
 *
 * We handle validation errors from the server with ManualMessages, which always "fail".
 * If the value is empty, we only validate if the field is required.
 *
 * @param skipManual Do not run any manual validators, used during submit check.  We don't want manual validators to block submit.
 */
function validate(_x) {
  return _validate.apply(this, arguments);
}
function _validate() {
  _validate = _asyncToGenerator$A(function* (widget) {
    var _widget$querySelector;
    var skipManual = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    if (widget.readonly || widget.disabled) {
      // Don't validate if the widget is read-only, there's nothing the user can do about it
      return Promise.resolve();
    }
    var validators = [...(widget.validators || []), ...(widget.defaultValidators || [])];
    var fieldName = widget.id;
    var feedbackData = [];
    var resultPromises = [];
    (_widget$querySelector = widget.querySelector("egw-validation-feedback")) === null || _widget$querySelector === void 0 || _widget$querySelector.remove();

    // Collect message of a (failing) validator
    var doValidate = /*#__PURE__*/function () {
      var _ref = _asyncToGenerator$A(function* (validator, value) {
        if (validator.config.fieldName) {
          fieldName = yield validator.config.fieldName;
        }
        // @ts-ignore [allow-protected]
        return validator._getMessage({
          modelValue: value,
          formControl: widget,
          fieldName
        }).then(message => {
          feedbackData.push({
            message,
            type: validator.type,
            validator
          });
        });
      });
      return function (_x2, _x3) {
        return _ref.apply(this, arguments);
      };
    }().bind(widget);

    // Check if a validator fails
    var doCheck = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator$A(function* (value, validator) {
        var result = validator.execute(value, validator.param, {
          node: widget
        });
        if (result === true) {
          resultPromises.push(doValidate(validator, value));
        } else if (result !== false && typeof result.then === 'function') {
          result.then(doValidate(validator, value));
          resultPromises.push(result);
        }
      });
      return function doCheck(_x4, _x5) {
        return _ref2.apply(this, arguments);
      };
    }();
    validators.map( /*#__PURE__*/function () {
      var _ref3 = _asyncToGenerator$A(function* (validator) {
        var values = widget.getValue();
        if (!Array.isArray(values)) {
          values = [values];
        }
        if (!values.length) {
          values = [''];
        } // so required validation works

        // Run manual validation messages just once, doesn't usually matter what the value is
        if (validator instanceof ManualMessage) {
          if (!skipManual) {
            doCheck(values, validator);
          }
        }
        // Only validate if field is required, or not required and has a value
        // Don't bother to validate empty fields
        else if (widget.required || !widget.required && widget.getValue() != '' && widget.getValue() !== null) {
          // Validate each individual item
          values.forEach(value => doCheck(value, validator));
        }
      });
      return function (_x6) {
        return _ref3.apply(this, arguments);
      };
    }());
    widget.validateComplete = Promise.all(resultPromises);

    // Wait until all validation is finished, then update UI
    widget.validateComplete.then(() => {
      // Show feedback from all failing validators
      if (feedbackData.length > 0) {
        var feedback = document.createElement("egw-validation-feedback");
        feedback.feedbackData = feedbackData;
        feedback.slot = "help-text";
        widget.append(feedback);
        if (widget.shadowRoot.querySelector("slot[name='feedback']")) {
          feedback.slot = "feedback";
        } else if (widget.shadowRoot.querySelector("#help-text")) {
          // Not always visible?
          widget.shadowRoot.querySelector("#help-text").style.display = "initial";
        } else {
          // No place to show the validation error.  That's a widget problem, but we'll show it as message
          widget.egw().message(feedback.textContent, "error");
        }
      }
    });
    return widget.validateComplete;
  });
  return _validate.apply(this, arguments);
}
var Et2InputWidgetMixin = superclass => {
  var _dec, _class;
  var Et2InputWidgetClass = (_dec = e$p(), (_class = class Et2InputWidgetClass extends Et2Widget(superclass) {
    /** WebComponent **/
    static get styles() {
      return [...super.styles, i$h(_templateObject$1B || (_templateObject$1B = _taggedTemplateLiteral$1B(["\n\t\t\t\t  /* Allow actually disabled inputs */\n\n\t\t\t\t  :host([disabled]) {\n\t\t\t\t\tdisplay: initial;\n\t\t\t\t  }\n\n\t\t\t\t  /* Needed so required can show through */\n\n\t\t\t\t  ::slotted(input), input {\n\t\t\t\t\tbackground-color: transparent;\n\t\t\t\t  }\n\n\t\t\t\t  /* Used to allow auto-sizing on slotted inputs */\n\n\t\t\t\t  .input-group__container > .input-group__input ::slotted(.form-control) {\n\t\t\t\t\twidth: 100%;\n\t\t\t\t  }\n\n\t\t\t\t  .form-control__help-text {\n\t\t\t\t\tposition: relative;\n\t\t\t\t\t  width: 100%;\n\t\t\t\t  }\n\t\t\t\t"])))];
    }
    static get properties() {
      return _objectSpread$P(_objectSpread$P({}, super.properties), {}, {
        /**
         * The label of the widget
         * Overridden from parent to use our accessors
         */
        label: {
          type: String,
          noAccessor: true
        },
        // readonly is what is in the templates
        // I put this in here so loadWebComponent finds it when it tries to set it from the template
        readonly: {
          type: Boolean,
          reflect: true
        },
        required: {
          type: Boolean,
          reflect: true
        },
        onchange: {
          type: Function
        },
        /**
         * Have browser focus this input on load.
         * Overrides etemplate2.focusOnFirstInput(), use only once per page
         * https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attributes
         */
        autofocus: {
          type: Boolean,
          reflect: true
        },
        autocomplete: {
          type: String
        },
        ariaLabel: String,
        ariaDescription: String,
        helpText: String
      });
    }

    /**
     * List of properties that get translated
     * Done separately to not interfere with properties - if we re-define label property,
     * labels go missing.
     * @returns object
     */
    static get translate() {
      return _objectSpread$P(_objectSpread$P({}, super.translate), {}, {
        placeholder: true,
        ariaLabel: true,
        ariaDescription: true,
        helpText: true
      });
    }

    /**
     * Compatibility for deprecated name "needed"
     *
     * @deprecated use required instead
     * @param val
     */
    set needed(val) {
      this.required = val;
    }
    /**
     * Compatibility for deprecated name "needed"
     *
     * @deprecated use required instead
     */
    get needed() {
      return this.required;
    }
    constructor() {
      super(...arguments);
      _defineProperty$27(this, "__readonly", void 0);
      _defineProperty$27(this, "__label", "");
      _defineProperty$27(this, "_oldValue", void 0);
      _defineProperty$27(this, "node", void 0);
      // Validators assigned to one specific instance of a widget
      _defineProperty$27(this, "validators", void 0);
      // Validators for every instance of a type of widget
      _defineProperty$27(this, "defaultValidators", void 0);
      // Promise used during validation
      _defineProperty$27(this, "validateComplete", void 0);
      // Hold on to any server messages while the user edits
      _defineProperty$27(this, "_messagesHeldWhileFocused", void 0);
      _defineProperty$27(this, "isSlComponent", false);
      // Allows us to check to see if label or help-text is set.  Override to check additional slots.
      _defineProperty$27(this, "hasSlotController", new HasSlotController$1(this, 'help-text', 'label'));
      this.validators = [];
      this.defaultValidators = [];
      this._messagesHeldWhileFocused = [];
      this.readonly = false;
      this.required = false;
      this._oldValue = this.getValue();
      this.isSlComponent = typeof this.handleChange === 'function';
      this.et2HandleFocus = this.et2HandleFocus.bind(this);
      this.et2HandleBlur = this.et2HandleBlur.bind(this);
      this.autocomplete = 'on';
    }
    connectedCallback() {
      super.connectedCallback();
      this._oldChange = this._oldChange.bind(this);
      this.node = this.getInputNode();
      this.updateComplete.then(() => {
        this.addEventListener(this.isSlComponent ? 'sl-change' : 'change', this._oldChange);
      });
      this.addEventListener("focus", this.et2HandleFocus);
      this.addEventListener("blur", this.et2HandleBlur);

      // set aria-label and -description fallbacks (done here and not in updated to ensure reliable fallback order)
      if (!this.ariaLabel) this.ariaLabel = this.label || this.placeholder || this.statustext;
      if (!this.ariaDescription) this.ariaDescription = this.helpText || (this.statustext !== this.ariaLabel ? this.statustext : '');
      this._setAriaAttributes();
    }

    /**
     * Set aria-attributes on our input node
     *
     * @protected
     */
    _setAriaAttributes() {
      // pass them on to input-node,  if we have one / this.getInputNode() returns one
      var input = this.getInputNode();
      if (input) {
        input.ariaLabel = this.ariaLabel;
        input.ariaDescription = this.ariaDescription;
      }
    }
    disconnectedCallback() {
      super.disconnectedCallback();
      this.removeEventListener(this.isSlComponent ? 'sl-change' : 'change', this._oldChange);
      this.removeEventListener("focus", this.et2HandleFocus);
      this.removeEventListener("blur", this.et2HandleBlur);

      // Hacky hack to clean up Shoelace form controller
      // https://github.com/shoelace-style/shoelace/issues/2376
      if (this.formControlController && this.formControlController.form) {
        this.formControlController.form.removeEventListener('formdata', this.formControlController.handleFormData);
        this.formControlController.form.removeEventListener('submit', this.formControlController.handleFormSubmit);
        this.formControlController.form.removeEventListener('reset', this.formControlController.handleFormReset);
      }
    }
    destroy() {
      super.destroy();
      this.onchange = null;
      this.change = null;
    }

    /**
     * A property has changed, and we want to make adjustments to other things
     * based on that
     *
     * @param changedProperties
     */
    updated(changedProperties) {
      super.updated(changedProperties);

      // required changed, add / remove validator
      if (changedProperties.has('required')) {
        // Remove all existing Required validators (avoids duplicates)
        this.validators = (this.validators || []).filter(validator => !(validator instanceof Required));
        if (this.required) {
          this.validators.push(new Required());
        }
      }
      if (changedProperties.has("value")) {
        // Base off this.value, not this.getValue(), to ignore readonly
        this.classList.toggle("hasValue", !(this.value == null || this.value == ""));
      }

      // pass aria-attributes to our input node
      if (changedProperties.has('ariaLabel') || changedProperties.has('ariaDescription')) {
        this._setAriaAttributes();
      }
    }

    /**
     * Change handler calling custom handler set via onchange attribute
     *
     * @param _ev
     * @returns
     */
    _oldChange(_ev) {
      if (typeof this.onchange == 'function' && (
      // If we have an instanceManager, make sure it's ready.  Otherwise, we ignore the event
      !this.getInstanceManager() || this.getInstanceManager().isReady)) {
        // Make sure function gets a reference to the widget, splice it in as 2. argument if not
        var args = Array.prototype.slice.call(arguments);
        if (args.indexOf(this) == -1) {
          args.splice(1, 0, this);
        }
        return this.onchange(...args);
      }
      return true;
    }

    /**
     * When input receives focus, clear any validation errors.
     *
     * If the value is the same on blur, we'll put them back
     * The ones from the server (ManualMessage) can interfere with submitting.
     *
     * Named et2HandleFocus to avoid overwriting handleFocus() in Shoelace components
     *
     * @param {FocusEvent} _ev
     */
    et2HandleFocus(_ev) {
      if (this._messagesHeldWhileFocused.length > 0) {
        return;
      }

      // Collect any ManualMessages
      this._messagesHeldWhileFocused = (this.validators || []).filter(validator => validator instanceof ManualMessage);
      // Remove ManualMessages from validators list
      for (var i = 0; i < this.validators.length; i++) {
        if (this._messagesHeldWhileFocused.indexOf(this.validators[i]) != -1) {
          this.validators.splice(i, 1);
        }
      }
      this.updateComplete.then(() => {
        // Remove all messages.  Manual will be explicitly replaced, other validators will be re-run on blur.
        this.querySelectorAll("egw-validation-feedback").forEach(e => e.remove());
      });
    }

    /**
     * If the value is unchanged, put any held validation messages back
     *
     * Named et2HandleBlur to avoid overwriting handleBlur() in Shoelace components
     *
     * @param {FocusEvent} _ev
     */
    et2HandleBlur(_ev) {
      if (this._messagesHeldWhileFocused.length > 0 && this.getValue() == this._oldValue) {
        this.validators = this.validators.concat(this._messagesHeldWhileFocused);
        this._messagesHeldWhileFocused = [];
      }
      this.updateComplete.then(() => {
        this.validate();
      });
    }
    set_value(new_value) {
      this.value = new_value;

      // Save this so we can compare against any user changes
      this._oldValue = this.getValue();
      if (typeof this._callParser == "function") {
        this.modelValue = this._callParser(new_value);
      }
    }
    get_value() {
      return this.getValue();
    }
    set_readonly(new_value) {
      this.readonly = new_value;
    }

    // Deal with Lion readOnly vs etemplate readonly
    set readonly(new_value) {
      this.__readonly = super.__readOnly = new_value;
      this.requestUpdate("readonly");
    }
    get readonly() {
      return this.__readonly;
    }

    /**
     * Was from early days (Lion)
     * @deprecated
     * @param {boolean} new_value
     */
    set readOnly(new_value) {
      this.readonly = new_value;
    }

    /**
     *  Lion mapping
     * @deprecated
     */
    get readOnly() {
      return this.readonly;
    }

    /**
     * @param boolean submit_value true: call by etemplate2.(getValues|submit|postSubmit)()
     */
    getValue(submit_value) {
      return this.readonly || this.disabled ? null :
      // Give a clone of objects or receiver might use the reference
      this.value && typeof this.value == "object" ? typeof this.value.length == "undefined" ? _objectSpread$P({}, this.value) : [...this.value] : this.value;
    }

    /**
     * The label of the widget
     * Legacy support for labels with %s that get wrapped around the widget
     *
     * Not the best way go with webComponents - shouldn't modify their DOM like this
     *
     * @param new_label
     */
    set label(new_label) {
      if (!new_label || !new_label.includes("%s")) {
        super.set_label(new_label);
        return;
      }
      this.__label = new_label;
      var [pre, post] = et2_csvSplit(new_label, 2, "%s");
      this.label = pre;
      if ((post === null || post === void 0 ? void 0 : post.trim().length) > 0) {
        this.__label = pre;
        this.updateComplete.then(() => {
          var _this$shadowRoot;
          var label = document.createElement("et2-description");
          label.innerText = post;
          // Add into shadowDOM (may go missing, in which case we need a different strategy)
          (_this$shadowRoot = this.shadowRoot) === null || _this$shadowRoot === void 0 || _this$shadowRoot.querySelector(".form-control-input").after(label);
        });
      }
    }
    get label() {
      return this.__label;
    }
    isDirty() {
      // Readonly can't be dirty, it can't change
      if (this.readonly) {
        return false;
      }
      var value = this.getValue();
      if (typeof value !== typeof this._oldValue) {
        return true;
      }
      if (this._oldValue === value) {
        return false;
      }
      switch (typeof this._oldValue) {
        case "object":
          if (Array.isArray(this._oldValue) && this._oldValue.length !== value.length) {
            return true;
          }
          for (var key in this._oldValue) {
            if (this._oldValue[key] !== value[key]) {
              return true;
            }
          }
          return false;
        default:
          return this._oldValue != value;
      }
    }
    resetDirty() {
      this._oldValue = this.getValue();
    }

    /**
     * Used by etemplate2 to determine if we can submit or not
     *
     * @param messages
     * @returns {boolean}
     */
    isValid(messages) {
      var ok = true;

      // Check for required
      if (this.required && !this.readonly && !this.disabled && (this.getValue() == null || this.getValue().valueOf() == '')) {
        messages.push(this.egw().lang('Field must not be empty !!!'));
        ok = false;
      }
      return ok;
    }

    /**
     * Get input to e.g. set aria-attributes
     */
    getInputNode() {
      var _this$shadowRoot2;
      return (_this$shadowRoot2 = this.shadowRoot) === null || _this$shadowRoot2 === void 0 ? void 0 : _this$shadowRoot2.querySelector('input');
    }
    focus() {
      var _superprop_getFocus = () => super.focus,
        _this = this;
      return _asyncToGenerator$A(function* () {
        var _this$getInputNode;
        var tab = _this.closest('et2-tab-panel');
        if (tab && tab.name) {
          tab.parentElement.show(tab.name);
          yield tab.parentElement.updateComplete;
        }
        _this.scrollIntoViewIfNeeded && _this.scrollIntoViewIfNeeded();
        _superprop_getFocus() && _superprop_getFocus().call(_this);
        (_this$getInputNode = _this.getInputNode()) === null || _this$getInputNode === void 0 || _this$getInputNode.focus();
      })();
    }
    transformAttributes(attrs) {
      super.transformAttributes(attrs);

      // Set attributes for the form / autofill.  It's the individual widget's
      // responsibility to do something appropriate with these properties.
      if (this.autocomplete == "on" && window.customElements.get(this.localName).getPropertyOptions("name") != "undefined" && this.getArrayMgr("content") !== null) {
        this.name = this.getArrayMgr("content").explodeKey(this.id).pop();
      }

      // Check whether an validation error entry exists
      if (this.id && this.getArrayMgr("validation_errors")) {
        var val = this.getArrayMgr("validation_errors").getEntry(this.id);
        if (val) {
          this.set_validation_error(val);
        }
      }
    }

    /**
     * Massively simplified validate, as compared to what ValidatorMixin gives us, since ValidatorMixin extends
     * FormControlMixin which breaks SlSelect's render()
     *
     * We take all validators for the widget, and if there's a value (or field is required) we check the value
     * with each validator.  For array values we check each element with each validator.  If the value does not
     * pass the validator, we collect the message and display feedback to the user.
     *
     * We handle validation errors from the server with ManualMessages, which always "fail".
     * If the value is empty, we only validate if the field is required.
     *
     * @param skipManual Do not run any manual validators, used during submit check.  We don't want manual validators to block submit.
     */
    validate() {
      var _arguments = arguments,
        _this2 = this;
      return _asyncToGenerator$A(function* () {
        var skipManual = _arguments.length > 0 && _arguments[0] !== undefined ? _arguments[0] : false;
        return validate(_this2, skipManual).then(() => _this2.requestUpdate());
      })();
    }
    set_validation_error(err) {
      /* Shoelace uses constraint validation API
      https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#the-constraint-validation-api
      	if(err === false && this.setCustomValidity)
      {
      	// Remove custom validity
      	this.setCustomValidity('');
      	return;
      }
      this.setCustomValidity(err);
      	// must call reportValidity() or nothing will happen
      this.reportValidity();
      	 */

      if (err === false) {
        // Remove all Manual validators
        this.validators = (this.validators || []).filter(validator => !(validator instanceof ManualMessage));
        return;
      }
      // Need to change interaction state so messages show up
      // submitted is a little heavy-handed, especially on first load, but it works
      this.submitted = true;

      // Add validator
      this.validators.push(new ManualMessage(err));
      // Force a validate - not needed normally, but if you call set_validation_error() manually,
      // it won't show up without validate()
      this.validate();
    }

    /**
     * Get a list of feedback types
     *
     * @returns {string[]}
     */
    get hasFeedbackFor() {
      var _this$querySelector;
      var feedback = ((_this$querySelector = this.querySelector("egw-validation-feedback")) === null || _this$querySelector === void 0 ? void 0 : _this$querySelector.feedbackData) || [];
      return feedback.map(f => f.type);
    }

    /**
     * Called whenever the template gets submitted. We return false if the widget
     * is not valid, which cancels the submission.
     *
     * @param _values contains the values which will be sent to the server.
     * 	Listeners may change these values before they get submitted.
     */
    submit(_values) {
      var _this3 = this;
      return _asyncToGenerator$A(function* () {
        _this3.submitted = true;

        // If using validators, run them now
        if (_this3.validate) {
          // Force update now
          _this3.validate(true);
          yield _this3.validateComplete;
          return (_this3.hasFeedbackFor || []).indexOf("error") == -1;
        }
        return true;
      })();
    }

    /**
     * Common sub-template to add a label.
     * This goes inside the form control wrapper div, before and at the same depth as the input controls.
     *
     *
     * @returns {TemplateResult} Either a TemplateResult or nothing (the object).  Check for nothing to set
     *    'form-control--has-label' class on the wrapper div.
     * @protected
     */
    _labelTemplate() {
      var _this$hasSlotControll;
      var hasLabelSlot = (_this$hasSlotControll = this.hasSlotController) === null || _this$hasSlotControll === void 0 ? void 0 : _this$hasSlotControll.test('label');
      var hasLabel = this.label ? true : !!hasLabelSlot;
      return hasLabel ? x$2(_templateObject2$Z || (_templateObject2$Z = _taggedTemplateLiteral$1B(["\n                <label\n                        id=\"label\"\n                        part=\"form-control-label\"\n                        class=\"form-control__label\"\n                        aria-hidden=", "\n                        @click=", "\n                >\n                    <slot name=\"label\">", "</slot>\n                </label>\n\t\t\t"])), hasLabel ? 'false' : 'true', typeof this.handleLabelClick == "function" ? this.handleLabelClick : A$2, this.label) : A$2;
    }
    _helpTextTemplate() {
      var _this$hasSlotControll2;
      var hasHelpTextSlot = (_this$hasSlotControll2 = this.hasSlotController) === null || _this$hasSlotControll2 === void 0 ? void 0 : _this$hasSlotControll2.test('help-text');
      var hasHelpText = this.helpText ? true : !!hasHelpTextSlot || this.hasFeedbackFor.length > 0;
      return hasHelpText ? x$2(_templateObject3$H || (_templateObject3$H = _taggedTemplateLiteral$1B(["\n                <div\n                        part=\"form-control-help-text\"\n                        id=\"help-text\"\n                        class=\"form-control__help-text\"\n                        aria-hidden=", "\n                >\n                    <slot name=\"help-text\">", "</slot>\n                </div>"])), hasHelpText ? 'false' : 'true', this.helpText) : A$2;
    }
  }, (_applyDecoratedDescriptor$J(_class.prototype, "label", [_dec], Object.getOwnPropertyDescriptor(_class.prototype, "label"), _class.prototype)), _class));
  return Et2InputWidgetClass;
};
var Et2InputWidget = dedupeMixin(Et2InputWidgetMixin);

/**
 * Loads the given URL asynchronously from the server
 *
 * We make the Ajax call through main-windows jQuery object, to ensure cached copy
 * in main-windows etemplate2 prototype works in IE too!
 *
 * @param {string} _url
 * @param {function} _callback function(_xml)
 * @param {object} _context for _callback
 * @param {function} _fail_callback function(_xml)
 * @return Promise
 */
function et2_loadXMLFromURL(_url, _callback, _context, _fail_callback) {
  if (typeof _context == "undefined") {
    _context = null;
  }

  // use window object from main window with same algorithm as for the template cache
  var win;
  try {
    if (opener && opener.etemplate2) {
      win = opener;
    }
  } catch (e) {
    // catch security exception if opener is from a different domain
  }
  if (typeof win == "undefined") {
    win = egw$1.top;
  }

  // if preprocessor is missing --> add it
  if (_url.indexOf('/etemplate.php/') === -1) {
    var parts = _url.match(/^(.*)(\/[^/]+\/templates\/.*)$/);
    if (parts) {
      _url = parts[1] + '/api/etemplate.php' + parts[2];
    }
  }

  // we add the full url (protocol and domain) as sometimes just the path
  // gives a CSP error interpreting it as file:///path
  // (if there are a enough 404 errors in html content ...)
  return win.fetch((_url[0] === '/' ? location.protocol + '//' + location.host : '') + _url, {
    method: 'GET'
  }).then(response => {
    if (!response.ok) {
      throw response;
    }
    return response.text();
  }).then(xml => {
    var parser = new window.DOMParser();
    return parser.parseFromString(xml, "text/xml");
  }).then(xmldoc => {
    if (typeof _callback === 'function') {
      _callback.call(_context, xmldoc.children[0]);
    }
    return xmldoc.children[0];
  }).catch(_err => {
    egw$1().message('Loading eTemplate from ' + _url + ' failed!' + "\n\n" + (typeof _err.stack !== 'undefined' ? _err.stack : _err.status + ' ' + _err.statusText), 'error');
    if (typeof _fail_callback === 'function') {
      _fail_callback.call(_context, _err);
    }
  });
}
function et2_directChildrenByTagName(_node, _tagName) {
  // Normalize the tag name
  _tagName = _tagName.toLowerCase();
  var result = [];
  for (var i = 0; i < _node.childNodes.length; i++) {
    if (_tagName == _node.childNodes[i].nodeName.toLowerCase()) {
      result.push(_node.childNodes[i]);
    }
  }
  return result;
}
function et2_filteredNodeIterator(_node, _callback, _context) {
  for (var i = 0; i < _node.childNodes.length; i++) {
    var node = _node.childNodes[i];
    var nodeName = node.nodeName.toLowerCase();
    if (nodeName.charAt(0) != "#") {
      _callback.call(_context, node, nodeName);
    }
  }
}
function et2_readAttrWithDefault(_node, _name, _default) {
  var val = _node.getAttribute(_name);
  return val === null ? _default : val;
}

/**
 * Interface for select options
 *
 * While we can (mostly) handle key => value maps, this is the preferred way to specify selectable options.
 * For option groups, value is the list of sub-options.
 *
 */

/**
 * Find the select options for a widget, out of the many places they could be.
 *
 * This will give valid, correct array of SelectOptions.  It will check:
 * - sel_options ArrayMgr, taking into account namespaces and checking the root
 * - content ArrayMgr, looking for "options-<id>"
 * - passed options, used by specific select types
 *
 * @param {Et2Widget} widget to check for.  Should be some sort of select widget.
 * @param {object} attr_options Select options in attributes array
 * @param {SelectOption[]} options Known options, passed in if you've already got some.  Cached type options, for example.
 * @return {SelectOption[]} Select options, or empty array
 */
function find_select_options(widget, attr_options) {
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
  var name_parts = widget.id.replace(/&#x5B;/g, '[').replace(/]|&#x5D;/g, '').split('[');
  var content_options = [];

  // Try to find the options inside the "sel-options"
  if (widget.getArrayMgr("sel_options")) {
    // Try first according to ID
    var _options = widget.getArrayMgr("sel_options").getEntry(widget.id);
    // ID can get set to an array with 0 => ' ' - not useful
    if (_options && (_options.length == 1 && typeof _options[0] == 'string' && _options[0].trim() == '' ||
    // eg. autorepeated id "cat[3]" would pick array element 3 from cat
    typeof _options.value != 'undefined' && typeof _options.label != 'undefined' && widget.id.match(/\[\d+]$/))) {
      content_options = null;
    } else {
      content_options = _options;
    }
    // We could wind up too far inside options if label,title are defined
    if (_options && !isNaN(name_parts[name_parts.length - 1]) && _options.label && _options.title) {
      name_parts.pop();
      content_options = widget.getArrayMgr("sel_options").getEntry(name_parts.join('['));
      delete content_options["$row"];
    }

    // Select options tend to be defined once, at the top level, so try that
    if (!content_options || content_options.length == 0) {
      content_options = widget.getArrayMgr("sel_options").getRoot().getEntry(name_parts[name_parts.length - 1]);
    }

    // Try in correct namespace (inside a grid or something)
    if (!content_options || content_options.length == 0) {
      content_options = widget.getArrayMgr("sel_options").getEntry(name_parts[name_parts.length - 1]);
    }

    // Try name like widget[$row]
    if (name_parts.length > 1 && (!content_options || content_options.length == 0)) {
      var pop_that = JSON.parse(JSON.stringify(name_parts));
      while (pop_that.length > 1 && (!content_options || content_options.length == 0)) {
        var last = pop_that.pop();
        content_options = widget.getArrayMgr('sel_options').getEntry(pop_that.join('['));

        // Double check, might have found a normal parent namespace ( eg subgrid in subgrid[selectbox] )
        // with an empty entry for the selectbox.  If there were valid options here,
        // we would have found them already, and keeping this would result in the ID as an option
        if (content_options && !Array.isArray(content_options) && typeof content_options[last] != 'undefined' && content_options[last]) {
          content_options = content_options[last];
        } else if (content_options) {
          // Check for real values
          for (var key in content_options) {
            if (!(isNaN(key) && typeof content_options[key] === 'string' || !isNaN(key) && typeof content_options[key] === 'object' && typeof content_options[key]['value'] !== 'undefined')) {
              // Found a parent of some other namespace
              content_options = undefined;
              break;
            }
          }
        }
      }
    }

    // Maybe in a row, and options got stuck in ${row} instead of top level
    // not sure this code is still needed, as server-side no longer creates ${row} or {$row} for select-options
    var row_stuck = ['${row}', '{$row}'];
    for (var i = 0; i < row_stuck.length && (!content_options || content_options.length == 0); i++) {
      // perspectiveData.row in nm, data["${row}"] in an auto-repeat grid
      if (widget.getArrayMgr("sel_options").perspectiveData.row || widget.getArrayMgr("sel_options").data[row_stuck[i]]) {
        var row_id = widget.id.replace(/[0-9]+/, row_stuck[i]);
        content_options = widget.getArrayMgr("sel_options").getEntry(row_id);
        if (!content_options || content_options.length == 0) {
          content_options = widget.getArrayMgr("sel_options").getEntry(row_stuck[i] + '[' + widget.id + ']');
        }
      }
    }
    if (attr_options && Object.keys(attr_options).length > 0 && content_options) {
      // Clean, merge and filter out duplicates
      content_options = [...new Map([...cleanSelectOptions(_options), ...cleanSelectOptions(content_options || [])].map(item => [item.value, item])).values()];
    }
    if (content_options) {
      content_options = cleanSelectOptions(content_options);
    }
  }

  // Check whether the options entry was found, if not read it from the
  // content array.
  if (content_options && content_options.length > 0 && widget.getArrayMgr('content') != null) {
    if (content_options) {
      attr_options = content_options;
    }
    var content_mgr = widget.getArrayMgr('content');
    if (content_mgr) {
      // If that didn't work, check according to ID
      if (!content_options) {
        content_options = content_mgr.getEntry("options-" + widget.id);
      }
      // Again, try last name part at top level
      if (!content_options) {
        content_options = content_mgr.getRoot().getEntry("options-" + name_parts[name_parts.length - 1]);
      }
    }
  }

  // Default to an empty object
  if (content_options == null) {
    content_options = [];
  }

  // Include passed options, preferring any content options
  if (options.length || Object.keys(options).length > 0) {
    content_options = cleanSelectOptions(content_options);
    for (var _i in content_options) {
      var value = typeof content_options[_i] == 'object' && typeof content_options[_i].value !== 'undefined' ? content_options[_i].value : _i;
      var added = false;

      // Override any existing
      for (var j in options) {
        if ('' + options[j].value === '' + value) {
          added = true;
          options[j] = content_options[_i];
          break;
        }
      }
      if (!added) {
        var insert = typeof content_options[_i] == "object" && content_options[_i].value === value && content_options[_i].label ? content_options[_i] : {
          value: value,
          label: content_options[_i]
        };
        options.splice(parseInt(_i), 0, insert);
      }
    }
    content_options = options;
  }

  // Clean up
  if (!Array.isArray(content_options) && typeof content_options === "object" && Object.values(content_options).length > 0) {
    var fixed_options = [];
    for (var _key in content_options) {
      var option = {
        value: _key,
        label: content_options[_key]
      };
      // This could be an option group - not sure we have any
      if (typeof option.label !== "string" && option.label) {
        // @ts-ignore Yes, option.label.label is not supposed to exist but that's what we're checking
        if (typeof option.label.label !== "undefined") {
          option = Object.assign(option, option.label);
        }
      }
      fixed_options.push(option);
    }
    content_options = fixed_options;
  }
  return content_options;
}

/**
 * Clean up things that might be select options and get them to what we need to make
 * them consistent for widget use.
 *
 * Options might be just a list of labels, or an object of value => label pairs, etc.
 *
 * @param {SelectOption[] | string[] | object} options
 */
function cleanSelectOptions(options) {
  var fixed_options = [];
  if (!Array.isArray(options)) {
    for (var key in options) {
      var _option$value;
      var option = options[key];
      if (typeof option === 'number') {
        option = "" + option;
      }
      if (typeof option === 'string') {
        option = {
          label: option
        };
      } else if (option === null) {
        option = {
          label: key + ""
        };
      }
      option.value = "" + ((_option$value = option.value) !== null && _option$value !== void 0 ? _option$value : key.trim()); // link_search prefixes keys with one space
      fixed_options.push(option);
    }
  } else {
    // make sure value is a string, and label not an object with sub-options
    options.forEach(option => {
      // old taglist used id, instead of value
      if (typeof option.value === 'undefined' && typeof option.id !== 'undefined') {
        option.value = option.id;
        delete option.id;
      }
      if (typeof option.value === 'number') {
        option.value = option.value.toString();
      }
      if (option.label && typeof option.label !== 'string') {
        fixed_options.push(...cleanSelectOptions(option.label));
      } else if (fixed_options.findIndex(o => o.value == option.value) == -1) {
        fixed_options.push(option);
      }
    });
  }
  return fixed_options;
}

var _templateObject$1A, _templateObject2$Y, _templateObject3$G;
function _taggedTemplateLiteral$1A(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
function asyncGeneratorStep$z(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator$z(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep$z(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep$z(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function _initializerDefineProperty$H(e, i, r, l) { r && Object.defineProperty(e, i, { enumerable: r.enumerable, configurable: r.configurable, writable: r.writable, value: r.initializer ? r.initializer.call(l) : void 0 }); }
function ownKeys$P(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$O(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$P(Object(t), !0).forEach(function (r) { _defineProperty$26(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$P(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty$26(e, r, t) { return (r = _toPropertyKey$25(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$25(t) { var i = _toPrimitive$25(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$25(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _applyDecoratedDescriptor$I(i, e, r, n, l) { var a = {}; return Object.keys(n).forEach(function (i) { a[i] = n[i]; }), a.enumerable = !!a.enumerable, a.configurable = !!a.configurable, ("value" in a || a.initializer) && (a.writable = !0), a = r.slice().reverse().reduce(function (r, n) { return n(i, e, r) || r; }, a), l && void 0 !== a.initializer && (a.value = a.initializer ? a.initializer.call(l) : void 0, a.initializer = void 0), void 0 === a.initializer ? (Object.defineProperty(i, e, a), null) : a; }
function _initializerWarningHelper$H(r, e) { throw Error("Decorating class property failed. Please ensure that transform-class-properties is enabled and runs after the decorators transform."); }

/**
 * @summary Base class for things that do selectbox type behaviour, to avoid putting too much or copying into read-only
 * selectboxes, also for common handling of properties for more special selectboxes.
 *
 * As with most other widgets that extend Shoelace components, do not override render() without good reason.
 * To extend this mixin, override:
 * - _optionTargetNode(): Return the HTMLElement where the "options" go.
 * - _optionTemplate(option:SelectOption): Renders the option.  To use a special widget, use its tag in render.
 * Select option:
 * ```js
 * 		return html`
 *             <option value="${option.value}" title="${option.title}" ?selected=${option.value == this.modelValue}>
 *                 ${option.label}
 *             </option>`;
 * ```
 *
 *
 * or pass it off to a different WebComponent:
 *
 * ```js
 * _optionTemplate(option:SelectOption) : TemplateResult
 * {
 *     return html`
 *           <special-option-tag .value=${option}></special-option-tag>`;
 * }
 * ```
 *
 * Optionally, you can override:
 * - _emptyLabelTemplate(): How to render the empty label
 * You can specify something else, or return {} to do your own thing.  This is a little more complicated.  You should
 * also override _inputGroupInputTemplate() to do what you normally would in render().
 *
 */
// Export the Interface for TypeScript
var Et2WidgetWithSelectMixin = superclass => {
  var _dec, _dec2, _dec3, _class, _descriptor, _descriptor2;
  /**
   * @summary Mixin for widgets where you can select from a pre-defined list of options
   *
   * Sample text
   *
   */
  var Et2WidgetWithSelect = (_dec = e$p({
    type: String
  }), _dec2 = e$p({
    type: Number,
    noAccessor: true,
    reflect: true
  }), _dec3 = e$p({
    type: Object
  }), (_class = class Et2WidgetWithSelect extends Et2InputWidget(superclass) {
    /**
     * List of properties that get translated
     * @returns object
     */
    static get translate() {
      return _objectSpread$O(_objectSpread$O({}, super.translate), {}, {
        emptyLabel: true
      });
    }
    constructor() {
      super(...arguments);
      /**
       * The current value of the select, submitted as a name/value pair with form data. When `multiple` is enabled, the
       * value attribute will be a space-delimited list of values based on the options selected, and the value property will
       * be an array.
       *
      @property({
      	noAccessor: true,
      	converter: {
      		fromAttribute: (value : string) => value.split(',')
      	}
      })
      value : string | string[] = "";
       */
      /**
       * Textual label for first row, eg: 'All' or 'None'.  It's value will be ''
       */
      _initializerDefineProperty$H(this, "emptyLabel", _descriptor, this);
      /**
       * Limit size
       */
      _initializerDefineProperty$H(this, "__select_options", _descriptor2, this);
      /**
       * When we create the select option elements, it takes a while.
       * If we don't wait for them, it causes issues in SlSelect
       */
      _defineProperty$26(this, "_optionRenderPromise", Promise.resolve());
      /**
       * Options found in the XML when reading the template
       * @type {SelectOption[]}
       * @private
       */
      _defineProperty$26(this, "_xmlOptions", []);
      _defineProperty$26(this, "_close_on_select", false);
      this.__select_options = [];
    }
    destroy() {
      super.destroy && super.destroy();
      this.__select_options = [];
      this._xmlOptions = [];
    }
    getUpdateComplete() {
      var _superprop_getGetUpdateComplete = () => super.getUpdateComplete,
        _this = this;
      return _asyncToGenerator$z(function* () {
        var result = yield _superprop_getGetUpdateComplete().call(_this);
        yield _this._optionRenderPromise;
        return result;
      })();
    }
    updated(changedProperties) {
      super.updated(changedProperties);

      // If the ID changed (or was just set) and select_options wasn't, find the new select options
      if (changedProperties.has("id") && !changedProperties.has("select_options")) {
        var options = find_select_options(this, {}, this._xmlOptions);
        if (options.length) {
          this.select_options = options;
        }
      }
    }
    getValueAsArray() {
      if (Array.isArray(this.value)) {
        return this.value;
      }
      if (this.value == "null" || this.value == null || typeof this.value == "undefined" || !this.emptyLabel && this.value == "") {
        return [];
      }
      return [this.value];
    }

    /**
     * Search options for a given value, returning the first matching option
     *
     * @return SelectOption | null
     */
    optionSearch(value) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      var searchKey = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "value";
      var childKey = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "value";
      var result = null;
      var search = function search(options, value) {
        return options.find(option => {
          if (!Array.isArray(option[searchKey]) && option[searchKey] == value) {
            result = option;
          }
          if (Array.isArray(option[childKey])) {
            return search(option[childKey], value);
          }
          return option[searchKey] == value;
        });
      };
      search(options !== null && options !== void 0 ? options : this.select_options, value);
      return result;
    }

    /**
     * Set the select options
     *
     * @param new_options
     */
    set select_options(new_options) {
      var old_options = this.__select_options;
      this.__select_options = cleanSelectOptions(new_options);
      this.requestUpdate("select_options", old_options);
    }

    /**
     * Set select options
     *
     * @deprecated assign to select_options
     * @param new_options
     */
    set_select_options(new_options) {
      this.select_options = new_options;
    }

    /**
     * Select box options
     *
     * Will be found automatically based on ID and type, or can be set explicitly in the template using
     * <option/> children, or using widget.select_options = SelectOption[]
     */
    get select_options() {
      return this.__select_options;
    }

    /**
     * Get the node where we're putting the options
     *
     * If this were a normal selectbox, this would be just the <select> tag (this._inputNode) but in a more
     * complicated widget, this could be anything.
     *
     * @overridable
     * @returns {HTMLElement}
     */
    get _optionTargetNode() {
      return this;
    }

    /**
     * Render the "empty label", used when the selectbox does not currently have a value
     *
     * @overridable
     * @returns {TemplateResult}
     */
    _emptyLabelTemplate() {
      return x$2(_templateObject$1A || (_templateObject$1A = _taggedTemplateLiteral$1A(["", ""])), this.emptyLabel);
    }

    /**
     * Render a single option
     *
     * Override this method to specify how to render each option.
     * In a normal selectbox, this would be something like:
     *```
     * <option value="${option.value}" title="${option.title}" ?selected=${option.value == this.modelValue}>
     *     ${option.label}
     * </option>`;
     * ```
     * but you can do whatever you need.  To use a different WebComponent, just use its tag instead of "option".
     * We should even be able to pass the whole SelectOption across
     * ```
     * <special-option .value=${option}></special-option>
     * ```
     *
     * @overridable
     * @param {SelectOption} option
     * @returns {TemplateResult}
     */
    _optionTemplate(option) {
      return x$2(_templateObject2$Y || (_templateObject2$Y = _taggedTemplateLiteral$1A(["\n                <span>Override _optionTemplate(). ", " => ", "</span>"])), option.value, option.label);
    }
    _groupTemplate(option) {
      if (!Array.isArray(option.value) && !Array.isArray(option.children) && !option.hasChildren) {
        return this._optionTemplate(option);
      }
      // option.value is deprecated, option.children is defined in SelectOption
      var options = Array.isArray(option.value) ? option.value : option.children;
      return x$2(_templateObject3$G || (_templateObject3$G = _taggedTemplateLiteral$1A(["\n                <small>", "</small>\n                ", "\n                <sl-divider></sl-divider>\n\t\t\t"])), this.noLang ? option.label : this.egw().lang(option.label), c$7(options, o => o.value, this._optionTemplate.bind(this)));
    }

    /**
     * Load extra stuff from the template node.  In particular, we're looking for any <option/> tags added.
     *
     * @param {Element} _node
     */
    loadFromXML(_node) {
      this._close_on_select = this.egw().preference("select_multiple_close") == "close";
      var new_options = [];

      // Read the option-tags, but if not rendered there won't be any yet so check existing options
      var options = _node.querySelectorAll("option");
      for (var i = 0; i < options.length; i++) {
        new_options.push({
          value: et2_readAttrWithDefault(options[i], "value", options[i].textContent),
          // allow options to contain multiple translated sub-strings eg: {Firstname}.{Lastname}
          label: options[i].textContent.replace(/{([^}]+)}/g, (str, p1) => {
            return this.egw().lang(p1);
          }),
          title: et2_readAttrWithDefault(options[i], "title", "")
        });
      }
      this._xmlOptions = new_options;
      if (options.length == 0 && this.__select_options.length) {
        // Start with any existing options, (static options from type)
        // Use a copy since we'll probably be modifying it, and we don't want to change for any other
        // widget of the same static type
        new_options = [...this.__select_options];
      }
      if (this.id) {
        new_options = find_select_options(this, {}, new_options);
      }
      if (new_options.length) {
        this.select_options = new_options;
      }
      var others = _node.querySelectorAll(":scope > :not(option)");
      // Load the child nodes.
      others.forEach(node => {
        var widgetType = node.nodeName.toLowerCase();
        if (widgetType == "#comment" || widgetType == "#text") {
          return;
        }

        // Create the new element
        this.createElementFromNode(node);
      });
    }
  }, (_descriptor = _applyDecoratedDescriptor$I(_class.prototype, "emptyLabel", [_dec], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: function initializer() {
      return "";
    }
  }), _descriptor2 = _applyDecoratedDescriptor$I(_class.prototype, "__select_options", [_dec2], {
    configurable: true,
    enumerable: true,
    writable: true,
    initializer: function initializer() {
      return [];
    }
  }), _applyDecoratedDescriptor$I(_class.prototype, "select_options", [_dec3], Object.getOwnPropertyDescriptor(_class.prototype, "select_options"), _class.prototype)), _class));
  return Et2WidgetWithSelect;
};

// src/utilities/base-path.ts
var basePath = "";
function setBasePath(path) {
  basePath = path;
}
function getBasePath(subpath = "") {
  if (!basePath) {
    const scripts = [...document.getElementsByTagName("script")];
    const configScript = scripts.find((script) => script.hasAttribute("data-shoelace"));
    if (configScript) {
      setBasePath(configScript.getAttribute("data-shoelace"));
    } else {
      const fallbackScript = scripts.find((s) => {
        return /shoelace(\.min)?\.js($|\?)/.test(s.src) || /shoelace-autoloader(\.min)?\.js($|\?)/.test(s.src);
      });
      let path = "";
      if (fallbackScript) {
        path = fallbackScript.getAttribute("src");
      }
      setBasePath(path.split("/").slice(0, -1).join("/"));
    }
  }
  return basePath.replace(/\/$/, "") + (subpath ? `/${subpath.replace(/^\//, "")}` : ``);
}

// src/components/icon/library.default.ts
var library = {
  name: "default",
  resolver: (name) => getBasePath(`assets/icons/${name}.svg`)
};
var library_default_default = library;

// src/components/icon/library.system.ts
var icons = {
  caret: `
    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
      <polyline points="6 9 12 15 18 9"></polyline>
    </svg>
  `,
  check: `
    <svg part="checked-icon" class="checkbox__icon" viewBox="0 0 16 16">
      <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" stroke-linecap="round">
        <g stroke="currentColor">
          <g transform="translate(3.428571, 3.428571)">
            <path d="M0,5.71428571 L3.42857143,9.14285714"></path>
            <path d="M9.14285714,0 L3.42857143,9.14285714"></path>
          </g>
        </g>
      </g>
    </svg>
  `,
  "chevron-down": `
    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chevron-down" viewBox="0 0 16 16">
      <path fill-rule="evenodd" d="M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z"/>
    </svg>
  `,
  "chevron-left": `
    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chevron-left" viewBox="0 0 16 16">
      <path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0z"/>
    </svg>
  `,
  "chevron-right": `
    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chevron-right" viewBox="0 0 16 16">
      <path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z"/>
    </svg>
  `,
  copy: `
    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-copy" viewBox="0 0 16 16">
      <path fill-rule="evenodd" d="M4 2a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V2Zm2-1a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H6ZM2 5a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1v-1h1v1a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h1v1H2Z"/>
    </svg>
  `,
  eye: `
    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-eye" viewBox="0 0 16 16">
      <path d="M16 8s-3-5.5-8-5.5S0 8 0 8s3 5.5 8 5.5S16 8 16 8zM1.173 8a13.133 13.133 0 0 1 1.66-2.043C4.12 4.668 5.88 3.5 8 3.5c2.12 0 3.879 1.168 5.168 2.457A13.133 13.133 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755C11.879 11.332 10.119 12.5 8 12.5c-2.12 0-3.879-1.168-5.168-2.457A13.134 13.134 0 0 1 1.172 8z"/>
      <path d="M8 5.5a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5zM4.5 8a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0z"/>
    </svg>
  `,
  "eye-slash": `
    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-eye-slash" viewBox="0 0 16 16">
      <path d="M13.359 11.238C15.06 9.72 16 8 16 8s-3-5.5-8-5.5a7.028 7.028 0 0 0-2.79.588l.77.771A5.944 5.944 0 0 1 8 3.5c2.12 0 3.879 1.168 5.168 2.457A13.134 13.134 0 0 1 14.828 8c-.058.087-.122.183-.195.288-.335.48-.83 1.12-1.465 1.755-.165.165-.337.328-.517.486l.708.709z"/>
      <path d="M11.297 9.176a3.5 3.5 0 0 0-4.474-4.474l.823.823a2.5 2.5 0 0 1 2.829 2.829l.822.822zm-2.943 1.299.822.822a3.5 3.5 0 0 1-4.474-4.474l.823.823a2.5 2.5 0 0 0 2.829 2.829z"/>
      <path d="M3.35 5.47c-.18.16-.353.322-.518.487A13.134 13.134 0 0 0 1.172 8l.195.288c.335.48.83 1.12 1.465 1.755C4.121 11.332 5.881 12.5 8 12.5c.716 0 1.39-.133 2.02-.36l.77.772A7.029 7.029 0 0 1 8 13.5C3 13.5 0 8 0 8s.939-1.721 2.641-3.238l.708.709zm10.296 8.884-12-12 .708-.708 12 12-.708.708z"/>
    </svg>
  `,
  eyedropper: `
    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-eyedropper" viewBox="0 0 16 16">
      <path d="M13.354.646a1.207 1.207 0 0 0-1.708 0L8.5 3.793l-.646-.647a.5.5 0 1 0-.708.708L8.293 5l-7.147 7.146A.5.5 0 0 0 1 12.5v1.793l-.854.853a.5.5 0 1 0 .708.707L1.707 15H3.5a.5.5 0 0 0 .354-.146L11 7.707l1.146 1.147a.5.5 0 0 0 .708-.708l-.647-.646 3.147-3.146a1.207 1.207 0 0 0 0-1.708l-2-2zM2 12.707l7-7L10.293 7l-7 7H2v-1.293z"></path>
    </svg>
  `,
  "grip-vertical": `
    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-grip-vertical" viewBox="0 0 16 16">
      <path d="M7 2a1 1 0 1 1-2 0 1 1 0 0 1 2 0zm3 0a1 1 0 1 1-2 0 1 1 0 0 1 2 0zM7 5a1 1 0 1 1-2 0 1 1 0 0 1 2 0zm3 0a1 1 0 1 1-2 0 1 1 0 0 1 2 0zM7 8a1 1 0 1 1-2 0 1 1 0 0 1 2 0zm3 0a1 1 0 1 1-2 0 1 1 0 0 1 2 0zm-3 3a1 1 0 1 1-2 0 1 1 0 0 1 2 0zm3 0a1 1 0 1 1-2 0 1 1 0 0 1 2 0zm-3 3a1 1 0 1 1-2 0 1 1 0 0 1 2 0zm3 0a1 1 0 1 1-2 0 1 1 0 0 1 2 0z"></path>
    </svg>
  `,
  indeterminate: `
    <svg part="indeterminate-icon" class="checkbox__icon" viewBox="0 0 16 16">
      <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" stroke-linecap="round">
        <g stroke="currentColor" stroke-width="2">
          <g transform="translate(2.285714, 6.857143)">
            <path d="M10.2857143,1.14285714 L1.14285714,1.14285714"></path>
          </g>
        </g>
      </g>
    </svg>
  `,
  "person-fill": `
    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-person-fill" viewBox="0 0 16 16">
      <path d="M3 14s-1 0-1-1 1-4 6-4 6 3 6 4-1 1-1 1H3zm5-6a3 3 0 1 0 0-6 3 3 0 0 0 0 6z"/>
    </svg>
  `,
  "play-fill": `
    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-play-fill" viewBox="0 0 16 16">
      <path d="m11.596 8.697-6.363 3.692c-.54.313-1.233-.066-1.233-.697V4.308c0-.63.692-1.01 1.233-.696l6.363 3.692a.802.802 0 0 1 0 1.393z"></path>
    </svg>
  `,
  "pause-fill": `
    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pause-fill" viewBox="0 0 16 16">
      <path d="M5.5 3.5A1.5 1.5 0 0 1 7 5v6a1.5 1.5 0 0 1-3 0V5a1.5 1.5 0 0 1 1.5-1.5zm5 0A1.5 1.5 0 0 1 12 5v6a1.5 1.5 0 0 1-3 0V5a1.5 1.5 0 0 1 1.5-1.5z"></path>
    </svg>
  `,
  radio: `
    <svg part="checked-icon" class="radio__icon" viewBox="0 0 16 16">
      <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g fill="currentColor">
          <circle cx="8" cy="8" r="3.42857143"></circle>
        </g>
      </g>
    </svg>
  `,
  "star-fill": `
    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-star-fill" viewBox="0 0 16 16">
      <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.282.95l-3.522 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"/>
    </svg>
  `,
  "x-lg": `
    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-x-lg" viewBox="0 0 16 16">
      <path d="M2.146 2.854a.5.5 0 1 1 .708-.708L8 7.293l5.146-5.147a.5.5 0 0 1 .708.708L8.707 8l5.147 5.146a.5.5 0 0 1-.708.708L8 8.707l-5.146 5.147a.5.5 0 0 1-.708-.708L7.293 8 2.146 2.854Z"/>
    </svg>
  `,
  "x-circle-fill": `
    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-x-circle-fill" viewBox="0 0 16 16">
      <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.354 4.646a.5.5 0 1 0-.708.708L7.293 8l-2.647 2.646a.5.5 0 0 0 .708.708L8 8.707l2.646 2.647a.5.5 0 0 0 .708-.708L8.707 8l2.647-2.646a.5.5 0 0 0-.708-.708L8 7.293 5.354 4.646z"></path>
    </svg>
  `
};
var systemLibrary = {
  name: "system",
  resolver: (name) => {
    if (name in icons) {
      return `data:image/svg+xml,${encodeURIComponent(icons[name])}`;
    }
    return "";
  }
};
var library_system_default = systemLibrary;

// src/components/icon/library.ts
var registry = [library_default_default, library_system_default];
var watchedIcons = [];
function watchIcon(icon) {
  watchedIcons.push(icon);
}
function unwatchIcon(icon) {
  watchedIcons = watchedIcons.filter((el) => el !== icon);
}
function getIconLibrary(name) {
  return registry.find((lib) => lib.name === name);
}
function registerIconLibrary(name, options) {
  unregisterIconLibrary(name);
  registry.push({
    name,
    resolver: options.resolver,
    mutator: options.mutator,
    spriteSheet: options.spriteSheet
  });
  watchedIcons.forEach((icon) => {
    if (icon.library === name) {
      icon.setIcon();
    }
  });
}
function unregisterIconLibrary(name) {
  registry = registry.filter((lib) => lib.name !== name);
}

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __knownSymbol = (name, symbol) => {
  return (symbol = Symbol[name]) ? symbol : Symbol.for("Symbol." + name);
};
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __decorateClass = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result)
    __defProp(target, key, result);
  return result;
};
var __accessCheck = (obj, member, msg) => {
  if (!member.has(obj))
    throw TypeError("Cannot " + msg);
};
var __privateGet = (obj, member, getter) => {
  __accessCheck(obj, member, "read from private field");
  return getter ? getter.call(obj) : member.get(obj);
};
var __privateAdd = (obj, member, value) => {
  if (member.has(obj))
    throw TypeError("Cannot add the same private member more than once");
  member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
};
var __privateSet = (obj, member, value, setter) => {
  __accessCheck(obj, member, "write to private field");
  setter ? setter.call(obj, value) : member.set(obj, value);
  return value;
};
var __await$1 = function(promise, isYieldStar) {
  this[0] = promise;
  this[1] = isYieldStar;
};
var __yieldStar = (value) => {
  var obj = value[__knownSymbol("asyncIterator")];
  var isAwait = false;
  var method;
  var it = {};
  if (obj == null) {
    obj = value[__knownSymbol("iterator")]();
    method = (k) => it[k] = (x) => obj[k](x);
  } else {
    obj = obj.call(value);
    method = (k) => it[k] = (v) => {
      if (isAwait) {
        isAwait = false;
        if (k === "throw")
          throw v;
        return v;
      }
      isAwait = true;
      return {
        done: false,
        value: new __await$1(new Promise((resolve) => {
          var x = obj[k](v);
          if (!(x instanceof Object))
            throw TypeError("Object expected");
          resolve(x);
        }), 1)
      };
    };
  }
  return it[__knownSymbol("iterator")] = () => it, method("next"), "throw" in obj ? method("throw") : it.throw = (x) => {
    throw x;
  }, "return" in obj && method("return"), it;
};

var _templateObject$1z;
function _taggedTemplateLiteral$1z(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }

/**
 * Here is the common overrides and customisations for Shoelace
 */

/**
 * Make shoelace icons available
 */
registerIconLibrary('default', {
  resolver: name => {
    var _egw$image;
    return typeof egw$1 !== "undefined" && typeof egw$1.image == "function" ? (_egw$image = egw$1.image(name)) !== null && _egw$image !== void 0 ? _egw$image : "".concat(egw$1.webserverUrl || "", "/node_modules/@shoelace-style/shoelace/dist/assets/icons/").concat(name, ".svg") : '';
  }
});

/**
 * Register egw images as an icon library
 * @example <sl-icon library="egw" name="infolog/navbar"/>
 * @example <sl-icon library="egw" name="5_day_view"/>
 */
if (typeof egw$1 !== "undefined" && typeof egw$1.image == "function") {
  registerIconLibrary('egw', {
    resolver: name => {
      return egw$1.image(name) || '';
    }
  });
}

/**
 * Customise shoelace styles to match our stuff
 * External CSS & widget styles will override this
 */
var shoelace = [i$h(_templateObject$1z || (_templateObject$1z = _taggedTemplateLiteral$1z(["\n\t.form-control--has-label .form-control__label {\n\t\tdisplay: inline-block;\n\t\tcolor: var(--sl-input-label-color);\n\t\tmargin-right: var(--sl-spacing-medium);\n\t}\n\n\t/* Hide placeholder in disabled inputs */\n\n\t.input--disabled input::placeholder, input[disabled]::placeholder, [disabled]::part(display-input)::placeholder {\n\t\topacity: 0;\n\t}\n"])))];

function ownKeys$O(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$N(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$O(Object(t), !0).forEach(function (r) { _defineProperty$25(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$O(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty$25(e, r, t) { return (r = _toPropertyKey$24(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$24(t) { var i = _toPrimitive$24(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$24(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
// Export the Interface for TypeScript

/**
 * Mixin to support widgets that have a set number of rows.
 * Whether that's a maximum or a fixed size, implementation is up to the widget.
 * Set rows=0 to clear.
 *
 * To implement in a webcomponent set height or max-height based on the --rows CSS variable:
 *  max-height: calc(var(--rows, 5) * 1.3rem);
 * @param {T} superclass
 * @constructor
 */
var RowLimitedMixin = superclass => {
  class RowLimit extends superclass {
    static get properties() {
      return _objectSpread$N({}, super.properties);
    }
    set rows(row_count) {
      if (isNaN(Number(row_count)) || !row_count) {
        this.style.removeProperty("--rows");
        this.removeAttribute("rows");
      } else {
        this.style.setProperty("--rows", row_count);
        this.setAttribute("rows", row_count);
      }
    }
    get rows() {
      return this.style.getPropertyValue("--rows");
    }
  }
  return RowLimit; // as unknown as superclass & T;
};

// src/internal/form.ts
var formCollections = /* @__PURE__ */ new WeakMap();
var reportValidityOverloads = /* @__PURE__ */ new WeakMap();
var checkValidityOverloads = /* @__PURE__ */ new WeakMap();
var userInteractedControls = /* @__PURE__ */ new WeakSet();
var interactions$1 = /* @__PURE__ */ new WeakMap();
var FormControlController = class {
  constructor(host, options) {
    this.handleFormData = (event) => {
      const disabled = this.options.disabled(this.host);
      const name = this.options.name(this.host);
      const value = this.options.value(this.host);
      const isButton = this.host.tagName.toLowerCase() === "sl-button";
      if (this.host.isConnected && !disabled && !isButton && typeof name === "string" && name.length > 0 && typeof value !== "undefined") {
        if (Array.isArray(value)) {
          value.forEach((val) => {
            event.formData.append(name, val.toString());
          });
        } else {
          event.formData.append(name, value.toString());
        }
      }
    };
    this.handleFormSubmit = (event) => {
      var _a;
      const disabled = this.options.disabled(this.host);
      const reportValidity = this.options.reportValidity;
      if (this.form && !this.form.noValidate) {
        (_a = formCollections.get(this.form)) == null ? void 0 : _a.forEach((control) => {
          this.setUserInteracted(control, true);
        });
      }
      if (this.form && !this.form.noValidate && !disabled && !reportValidity(this.host)) {
        event.preventDefault();
        event.stopImmediatePropagation();
      }
    };
    this.handleFormReset = () => {
      this.options.setValue(this.host, this.options.defaultValue(this.host));
      this.setUserInteracted(this.host, false);
      interactions$1.set(this.host, []);
    };
    this.handleInteraction = (event) => {
      const emittedEvents = interactions$1.get(this.host);
      if (!emittedEvents.includes(event.type)) {
        emittedEvents.push(event.type);
      }
      if (emittedEvents.length === this.options.assumeInteractionOn.length) {
        this.setUserInteracted(this.host, true);
      }
    };
    this.checkFormValidity = () => {
      if (this.form && !this.form.noValidate) {
        const elements = this.form.querySelectorAll("*");
        for (const element of elements) {
          if (typeof element.checkValidity === "function") {
            if (!element.checkValidity()) {
              return false;
            }
          }
        }
      }
      return true;
    };
    this.reportFormValidity = () => {
      if (this.form && !this.form.noValidate) {
        const elements = this.form.querySelectorAll("*");
        for (const element of elements) {
          if (typeof element.reportValidity === "function") {
            if (!element.reportValidity()) {
              return false;
            }
          }
        }
      }
      return true;
    };
    (this.host = host).addController(this);
    this.options = __spreadValues({
      form: (input) => {
        const formId = input.form;
        if (formId) {
          const root = input.getRootNode();
          const form = root.querySelector(`#${formId}`);
          if (form) {
            return form;
          }
        }
        return input.closest("form");
      },
      name: (input) => input.name,
      value: (input) => input.value,
      defaultValue: (input) => input.defaultValue,
      disabled: (input) => {
        var _a;
        return (_a = input.disabled) != null ? _a : false;
      },
      reportValidity: (input) => typeof input.reportValidity === "function" ? input.reportValidity() : true,
      checkValidity: (input) => typeof input.checkValidity === "function" ? input.checkValidity() : true,
      setValue: (input, value) => input.value = value,
      assumeInteractionOn: ["sl-input"]
    }, options);
  }
  hostConnected() {
    const form = this.options.form(this.host);
    if (form) {
      this.attachForm(form);
    }
    interactions$1.set(this.host, []);
    this.options.assumeInteractionOn.forEach((event) => {
      this.host.addEventListener(event, this.handleInteraction);
    });
  }
  hostDisconnected() {
    this.detachForm();
    interactions$1.delete(this.host);
    this.options.assumeInteractionOn.forEach((event) => {
      this.host.removeEventListener(event, this.handleInteraction);
    });
  }
  hostUpdated() {
    const form = this.options.form(this.host);
    if (!form) {
      this.detachForm();
    }
    if (form && this.form !== form) {
      this.detachForm();
      this.attachForm(form);
    }
    if (this.host.hasUpdated) {
      this.setValidity(this.host.validity.valid);
    }
  }
  attachForm(form) {
    if (form) {
      this.form = form;
      if (formCollections.has(this.form)) {
        formCollections.get(this.form).add(this.host);
      } else {
        formCollections.set(this.form, /* @__PURE__ */ new Set([this.host]));
      }
      this.form.addEventListener("formdata", this.handleFormData);
      this.form.addEventListener("submit", this.handleFormSubmit);
      this.form.addEventListener("reset", this.handleFormReset);
      if (!reportValidityOverloads.has(this.form)) {
        reportValidityOverloads.set(this.form, this.form.reportValidity);
        this.form.reportValidity = () => this.reportFormValidity();
      }
      if (!checkValidityOverloads.has(this.form)) {
        checkValidityOverloads.set(this.form, this.form.checkValidity);
        this.form.checkValidity = () => this.checkFormValidity();
      }
    } else {
      this.form = void 0;
    }
  }
  detachForm() {
    if (!this.form)
      return;
    const formCollection = formCollections.get(this.form);
    if (!formCollection) {
      return;
    }
    formCollection.delete(this.host);
    if (formCollection.size <= 0) {
      this.form.removeEventListener("formdata", this.handleFormData);
      this.form.removeEventListener("submit", this.handleFormSubmit);
      this.form.removeEventListener("reset", this.handleFormReset);
      if (reportValidityOverloads.has(this.form)) {
        this.form.reportValidity = reportValidityOverloads.get(this.form);
        reportValidityOverloads.delete(this.form);
      }
      if (checkValidityOverloads.has(this.form)) {
        this.form.checkValidity = checkValidityOverloads.get(this.form);
        checkValidityOverloads.delete(this.form);
      }
      this.form = void 0;
    }
  }
  setUserInteracted(el, hasInteracted) {
    if (hasInteracted) {
      userInteractedControls.add(el);
    } else {
      userInteractedControls.delete(el);
    }
    el.requestUpdate();
  }
  doAction(type, submitter) {
    if (this.form) {
      const button = document.createElement("button");
      button.type = type;
      button.style.position = "absolute";
      button.style.width = "0";
      button.style.height = "0";
      button.style.clipPath = "inset(50%)";
      button.style.overflow = "hidden";
      button.style.whiteSpace = "nowrap";
      if (submitter) {
        button.name = submitter.name;
        button.value = submitter.value;
        ["formaction", "formenctype", "formmethod", "formnovalidate", "formtarget"].forEach((attr) => {
          if (submitter.hasAttribute(attr)) {
            button.setAttribute(attr, submitter.getAttribute(attr));
          }
        });
      }
      this.form.append(button);
      button.click();
      button.remove();
    }
  }
  /** Returns the associated `<form>` element, if one exists. */
  getForm() {
    var _a;
    return (_a = this.form) != null ? _a : null;
  }
  /** Resets the form, restoring all the control to their default value */
  reset(submitter) {
    this.doAction("reset", submitter);
  }
  /** Submits the form, triggering validation and form data injection. */
  submit(submitter) {
    this.doAction("submit", submitter);
  }
  /**
   * Synchronously sets the form control's validity. Call this when you know the future validity but need to update
   * the host element immediately, i.e. before Lit updates the component in the next update.
   */
  setValidity(isValid) {
    const host = this.host;
    const hasInteracted = Boolean(userInteractedControls.has(host));
    const required = Boolean(host.required);
    host.toggleAttribute("data-required", required);
    host.toggleAttribute("data-optional", !required);
    host.toggleAttribute("data-invalid", !isValid);
    host.toggleAttribute("data-valid", isValid);
    host.toggleAttribute("data-user-invalid", !isValid && hasInteracted);
    host.toggleAttribute("data-user-valid", isValid && hasInteracted);
  }
  /**
   * Updates the form control's validity based on the current value of `host.validity.valid`. Call this when anything
   * that affects constraint validation changes so the component receives the correct validity states.
   */
  updateValidity() {
    const host = this.host;
    this.setValidity(host.validity.valid);
  }
  /**
   * Dispatches a non-bubbling, cancelable custom event of type `sl-invalid`.
   * If the `sl-invalid` event will be cancelled then the original `invalid`
   * event (which may have been passed as argument) will also be cancelled.
   * If no original `invalid` event has been passed then the `sl-invalid`
   * event will be cancelled before being dispatched.
   */
  emitInvalidEvent(originalInvalidEvent) {
    const slInvalidEvent = new CustomEvent("sl-invalid", {
      bubbles: false,
      composed: false,
      cancelable: true,
      detail: {}
    });
    if (!originalInvalidEvent) {
      slInvalidEvent.preventDefault();
    }
    if (!this.host.dispatchEvent(slInvalidEvent)) {
      originalInvalidEvent == null ? void 0 : originalInvalidEvent.preventDefault();
    }
  }
};
var validValidityState = Object.freeze({
  badInput: false,
  customError: false,
  patternMismatch: false,
  rangeOverflow: false,
  rangeUnderflow: false,
  stepMismatch: false,
  tooLong: false,
  tooShort: false,
  typeMismatch: false,
  valid: true,
  valueMissing: false
});
var valueMissingValidityState = Object.freeze(__spreadProps(__spreadValues({}, validValidityState), {
  valid: false,
  valueMissing: true
}));
var customErrorValidityState = Object.freeze(__spreadProps(__spreadValues({}, validValidityState), {
  valid: false,
  customError: true
}));

// src/utilities/form.ts
function serialize$1(form) {
  const formData = new FormData(form);
  const object = {};
  formData.forEach((value, key) => {
    if (Reflect.has(object, key)) {
      const entry = object[key];
      if (Array.isArray(entry)) {
        entry.push(value);
      } else {
        object[key] = [object[key], value];
      }
    } else {
      object[key] = value;
    }
  });
  return object;
}
function getFormControls(form) {
  const rootNode = form.getRootNode();
  const allNodes = [...rootNode.querySelectorAll("*")];
  const formControls = [...form.elements];
  const collection = formCollections.get(form);
  const shoelaceFormControls = collection ? Array.from(collection) : [];
  return [...formControls, ...shoelaceFormControls].sort((a, b) => {
    if (allNodes.indexOf(a) < allNodes.indexOf(b))
      return -1;
    if (allNodes.indexOf(a) > allNodes.indexOf(b))
      return 1;
    return 0;
  });
}

/**
 * @license
 * Copyright 2019 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const t$9=globalThis,e$j=t$9.ShadowRoot&&(void 0===t$9.ShadyCSS||t$9.ShadyCSS.nativeShadow)&&"adoptedStyleSheets"in Document.prototype&&"replace"in CSSStyleSheet.prototype,s$6=Symbol(),o$l=new WeakMap;class n$e{constructor(t,e,o){if(this._$cssResult$=!0,o!==s$6)throw Error("CSSResult is not constructable. Use `unsafeCSS` or `css` instead.");this.cssText=t,this.t=e;}get styleSheet(){let t=this.o;const s=this.t;if(e$j&&void 0===t){const e=void 0!==s&&1===s.length;e&&(t=o$l.get(s)),void 0===t&&((this.o=t=new CSSStyleSheet).replaceSync(this.cssText),e&&o$l.set(s,t));}return t}toString(){return this.cssText}}const r$b=t=>new n$e("string"==typeof t?t:t+"",void 0,s$6),i$a=(t,...e)=>{const o=1===t.length?t[0]:e.reduce(((e,s,o)=>e+(t=>{if(!0===t._$cssResult$)return t.cssText;if("number"==typeof t)return t;throw Error("Value passed to 'css' function must be a 'css' function result: "+t+". Use 'unsafeCSS' to pass non-literal values, but take care to ensure page security.")})(s)+t[o+1]),t[0]);return new n$e(o,t,s$6)},S$2=(s,o)=>{if(e$j)s.adoptedStyleSheets=o.map((t=>t instanceof CSSStyleSheet?t:t.styleSheet));else for(const e of o){const o=document.createElement("style"),n=t$9.litNonce;void 0!==n&&o.setAttribute("nonce",n),o.textContent=e.cssText,s.appendChild(o);}},c$5=e$j?t=>t:t=>t instanceof CSSStyleSheet?(t=>{let e="";for(const s of t.cssRules)e+=s.cssText;return r$b(e)})(t):t;

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */const{is:i$9,defineProperty:e$i,getOwnPropertyDescriptor:r$a,getOwnPropertyNames:h$5,getOwnPropertySymbols:o$k,getPrototypeOf:n$d}=Object,a$3=globalThis,c$4=a$3.trustedTypes,l$8=c$4?c$4.emptyScript:"",p$3=a$3.reactiveElementPolyfillSupport,d$3=(t,s)=>t,u$4={toAttribute(t,s){switch(s){case Boolean:t=t?l$8:null;break;case Object:case Array:t=null==t?t:JSON.stringify(t);}return t},fromAttribute(t,s){let i=t;switch(s){case Boolean:i=null!==t;break;case Number:i=null===t?null:Number(t);break;case Object:case Array:try{i=JSON.parse(t);}catch(t){i=null;}}return i}},f$5=(t,s)=>!i$9(t,s),y$2={attribute:!0,type:String,converter:u$4,reflect:!1,hasChanged:f$5};Symbol.metadata??=Symbol("metadata"),a$3.litPropertyMetadata??=new WeakMap;class b$2 extends HTMLElement{static addInitializer(t){this._$Ei(),(this.l??=[]).push(t);}static get observedAttributes(){return this.finalize(),this._$Eh&&[...this._$Eh.keys()]}static createProperty(t,s=y$2){if(s.state&&(s.attribute=!1),this._$Ei(),this.elementProperties.set(t,s),!s.noAccessor){const i=Symbol(),r=this.getPropertyDescriptor(t,i,s);void 0!==r&&e$i(this.prototype,t,r);}}static getPropertyDescriptor(t,s,i){const{get:e,set:h}=r$a(this.prototype,t)??{get(){return this[s]},set(t){this[s]=t;}};return {get(){return e?.call(this)},set(s){const r=e?.call(this);h.call(this,s),this.requestUpdate(t,r,i);},configurable:!0,enumerable:!0}}static getPropertyOptions(t){return this.elementProperties.get(t)??y$2}static _$Ei(){if(this.hasOwnProperty(d$3("elementProperties")))return;const t=n$d(this);t.finalize(),void 0!==t.l&&(this.l=[...t.l]),this.elementProperties=new Map(t.elementProperties);}static finalize(){if(this.hasOwnProperty(d$3("finalized")))return;if(this.finalized=!0,this._$Ei(),this.hasOwnProperty(d$3("properties"))){const t=this.properties,s=[...h$5(t),...o$k(t)];for(const i of s)this.createProperty(i,t[i]);}const t=this[Symbol.metadata];if(null!==t){const s=litPropertyMetadata.get(t);if(void 0!==s)for(const[t,i]of s)this.elementProperties.set(t,i);}this._$Eh=new Map;for(const[t,s]of this.elementProperties){const i=this._$Eu(t,s);void 0!==i&&this._$Eh.set(i,t);}this.elementStyles=this.finalizeStyles(this.styles);}static finalizeStyles(s){const i=[];if(Array.isArray(s)){const e=new Set(s.flat(1/0).reverse());for(const s of e)i.unshift(c$5(s));}else void 0!==s&&i.push(c$5(s));return i}static _$Eu(t,s){const i=s.attribute;return !1===i?void 0:"string"==typeof i?i:"string"==typeof t?t.toLowerCase():void 0}constructor(){super(),this._$Ep=void 0,this.isUpdatePending=!1,this.hasUpdated=!1,this._$Em=null,this._$Ev();}_$Ev(){this._$ES=new Promise((t=>this.enableUpdating=t)),this._$AL=new Map,this._$E_(),this.requestUpdate(),this.constructor.l?.forEach((t=>t(this)));}addController(t){(this._$EO??=new Set).add(t),void 0!==this.renderRoot&&this.isConnected&&t.hostConnected?.();}removeController(t){this._$EO?.delete(t);}_$E_(){const t=new Map,s=this.constructor.elementProperties;for(const i of s.keys())this.hasOwnProperty(i)&&(t.set(i,this[i]),delete this[i]);t.size>0&&(this._$Ep=t);}createRenderRoot(){const t=this.shadowRoot??this.attachShadow(this.constructor.shadowRootOptions);return S$2(t,this.constructor.elementStyles),t}connectedCallback(){this.renderRoot??=this.createRenderRoot(),this.enableUpdating(!0),this._$EO?.forEach((t=>t.hostConnected?.()));}enableUpdating(t){}disconnectedCallback(){this._$EO?.forEach((t=>t.hostDisconnected?.()));}attributeChangedCallback(t,s,i){this._$AK(t,i);}_$EC(t,s){const i=this.constructor.elementProperties.get(t),e=this.constructor._$Eu(t,i);if(void 0!==e&&!0===i.reflect){const r=(void 0!==i.converter?.toAttribute?i.converter:u$4).toAttribute(s,i.type);this._$Em=t,null==r?this.removeAttribute(e):this.setAttribute(e,r),this._$Em=null;}}_$AK(t,s){const i=this.constructor,e=i._$Eh.get(t);if(void 0!==e&&this._$Em!==e){const t=i.getPropertyOptions(e),r="function"==typeof t.converter?{fromAttribute:t.converter}:void 0!==t.converter?.fromAttribute?t.converter:u$4;this._$Em=e,this[e]=r.fromAttribute(s,t.type),this._$Em=null;}}requestUpdate(t,s,i){if(void 0!==t){if(i??=this.constructor.getPropertyOptions(t),!(i.hasChanged??f$5)(this[t],s))return;this.P(t,s,i);}!1===this.isUpdatePending&&(this._$ES=this._$ET());}P(t,s,i){this._$AL.has(t)||this._$AL.set(t,s),!0===i.reflect&&this._$Em!==t&&(this._$Ej??=new Set).add(t);}async _$ET(){this.isUpdatePending=!0;try{await this._$ES;}catch(t){Promise.reject(t);}const t=this.scheduleUpdate();return null!=t&&await t,!this.isUpdatePending}scheduleUpdate(){return this.performUpdate()}performUpdate(){if(!this.isUpdatePending)return;if(!this.hasUpdated){if(this.renderRoot??=this.createRenderRoot(),this._$Ep){for(const[t,s]of this._$Ep)this[t]=s;this._$Ep=void 0;}const t=this.constructor.elementProperties;if(t.size>0)for(const[s,i]of t)!0!==i.wrapped||this._$AL.has(s)||void 0===this[s]||this.P(s,this[s],i);}let t=!1;const s=this._$AL;try{t=this.shouldUpdate(s),t?(this.willUpdate(s),this._$EO?.forEach((t=>t.hostUpdate?.())),this.update(s)):this._$EU();}catch(s){throw t=!1,this._$EU(),s}t&&this._$AE(s);}willUpdate(t){}_$AE(t){this._$EO?.forEach((t=>t.hostUpdated?.())),this.hasUpdated||(this.hasUpdated=!0,this.firstUpdated(t)),this.updated(t);}_$EU(){this._$AL=new Map,this.isUpdatePending=!1;}get updateComplete(){return this.getUpdateComplete()}getUpdateComplete(){return this._$ES}shouldUpdate(t){return !0}update(t){this._$Ej&&=this._$Ej.forEach((t=>this._$EC(t,this[t]))),this._$EU();}updated(t){}firstUpdated(t){}}b$2.elementStyles=[],b$2.shadowRootOptions={mode:"open"},b$2[d$3("elementProperties")]=new Map,b$2[d$3("finalized")]=new Map,p$3?.({ReactiveElement:b$2}),(a$3.reactiveElementVersions??=[]).push("2.0.4");

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const t$8=globalThis,i$8=t$8.trustedTypes,s$5=i$8?i$8.createPolicy("lit-html",{createHTML:t=>t}):void 0,e$h="$lit$",h$4=`lit$${(Math.random()+"").slice(9)}$`,o$j="?"+h$4,n$c=`<${o$j}>`,r$9=document,l$7=()=>r$9.createComment(""),c$3=t=>null===t||"object"!=typeof t&&"function"!=typeof t,a$2=Array.isArray,u$3=t=>a$2(t)||"function"==typeof t?.[Symbol.iterator],d$2="[ \t\n\f\r]",f$4=/<(?:(!--|\/[^a-zA-Z])|(\/?[a-zA-Z][^>\s]*)|(\/?$))/g,v$2=/-->/g,_$1=/>/g,m$2=RegExp(`>|${d$2}(?:([^\\s"'>=/]+)(${d$2}*=${d$2}*(?:[^ \t\n\f\r"'\`<>=]|("|')|))|$)`,"g"),p$2=/'/g,g$1=/"/g,$$8=/^(?:script|style|textarea|title)$/i,y$1=t=>(i,...s)=>({_$litType$:t,strings:i,values:s}),x$1=y$1(1),b$1=y$1(2),w$1=Symbol.for("lit-noChange"),T$1=Symbol.for("lit-nothing"),A$1=new WeakMap,E$1=r$9.createTreeWalker(r$9,129);function C$1(t,i){if(!Array.isArray(t)||!t.hasOwnProperty("raw"))throw Error("invalid template strings array");return void 0!==s$5?s$5.createHTML(i):i}const P$1=(t,i)=>{const s=t.length-1,o=[];let r,l=2===i?"<svg>":"",c=f$4;for(let i=0;i<s;i++){const s=t[i];let a,u,d=-1,y=0;for(;y<s.length&&(c.lastIndex=y,u=c.exec(s),null!==u);)y=c.lastIndex,c===f$4?"!--"===u[1]?c=v$2:void 0!==u[1]?c=_$1:void 0!==u[2]?($$8.test(u[2])&&(r=RegExp("</"+u[2],"g")),c=m$2):void 0!==u[3]&&(c=m$2):c===m$2?">"===u[0]?(c=r??f$4,d=-1):void 0===u[1]?d=-2:(d=c.lastIndex-u[2].length,a=u[1],c=void 0===u[3]?m$2:'"'===u[3]?g$1:p$2):c===g$1||c===p$2?c=m$2:c===v$2||c===_$1?c=f$4:(c=m$2,r=void 0);const x=c===m$2&&t[i+1].startsWith("/>")?" ":"";l+=c===f$4?s+n$c:d>=0?(o.push(a),s.slice(0,d)+e$h+s.slice(d)+h$4+x):s+h$4+(-2===d?i:x);}return [C$1(t,l+(t[s]||"<?>")+(2===i?"</svg>":"")),o]};class V$1{constructor({strings:t,_$litType$:s},n){let r;this.parts=[];let c=0,a=0;const u=t.length-1,d=this.parts,[f,v]=P$1(t,s);if(this.el=V$1.createElement(f,n),E$1.currentNode=this.el.content,2===s){const t=this.el.content.firstChild;t.replaceWith(...t.childNodes);}for(;null!==(r=E$1.nextNode())&&d.length<u;){if(1===r.nodeType){if(r.hasAttributes())for(const t of r.getAttributeNames())if(t.endsWith(e$h)){const i=v[a++],s=r.getAttribute(t).split(h$4),e=/([.?@])?(.*)/.exec(i);d.push({type:1,index:c,name:e[2],strings:s,ctor:"."===e[1]?k$1:"?"===e[1]?H$2:"@"===e[1]?I$1:R$1}),r.removeAttribute(t);}else t.startsWith(h$4)&&(d.push({type:6,index:c}),r.removeAttribute(t));if($$8.test(r.tagName)){const t=r.textContent.split(h$4),s=t.length-1;if(s>0){r.textContent=i$8?i$8.emptyScript:"";for(let i=0;i<s;i++)r.append(t[i],l$7()),E$1.nextNode(),d.push({type:2,index:++c});r.append(t[s],l$7());}}}else if(8===r.nodeType)if(r.data===o$j)d.push({type:2,index:c});else {let t=-1;for(;-1!==(t=r.data.indexOf(h$4,t+1));)d.push({type:7,index:c}),t+=h$4.length-1;}c++;}}static createElement(t,i){const s=r$9.createElement("template");return s.innerHTML=t,s}}function N$1(t,i,s=t,e){if(i===w$1)return i;let h=void 0!==e?s._$Co?.[e]:s._$Cl;const o=c$3(i)?void 0:i._$litDirective$;return h?.constructor!==o&&(h?._$AO?.(!1),void 0===o?h=void 0:(h=new o(t),h._$AT(t,s,e)),void 0!==e?(s._$Co??=[])[e]=h:s._$Cl=h),void 0!==h&&(i=N$1(t,h._$AS(t,i.values),h,e)),i}class S$1{constructor(t,i){this._$AV=[],this._$AN=void 0,this._$AD=t,this._$AM=i;}get parentNode(){return this._$AM.parentNode}get _$AU(){return this._$AM._$AU}u(t){const{el:{content:i},parts:s}=this._$AD,e=(t?.creationScope??r$9).importNode(i,!0);E$1.currentNode=e;let h=E$1.nextNode(),o=0,n=0,l=s[0];for(;void 0!==l;){if(o===l.index){let i;2===l.type?i=new M$1(h,h.nextSibling,this,t):1===l.type?i=new l.ctor(h,l.name,l.strings,this,t):6===l.type&&(i=new L$1(h,this,t)),this._$AV.push(i),l=s[++n];}o!==l?.index&&(h=E$1.nextNode(),o++);}return E$1.currentNode=r$9,e}p(t){let i=0;for(const s of this._$AV)void 0!==s&&(void 0!==s.strings?(s._$AI(t,s,i),i+=s.strings.length-2):s._$AI(t[i])),i++;}}class M$1{get _$AU(){return this._$AM?._$AU??this._$Cv}constructor(t,i,s,e){this.type=2,this._$AH=T$1,this._$AN=void 0,this._$AA=t,this._$AB=i,this._$AM=s,this.options=e,this._$Cv=e?.isConnected??!0;}get parentNode(){let t=this._$AA.parentNode;const i=this._$AM;return void 0!==i&&11===t?.nodeType&&(t=i.parentNode),t}get startNode(){return this._$AA}get endNode(){return this._$AB}_$AI(t,i=this){t=N$1(this,t,i),c$3(t)?t===T$1||null==t||""===t?(this._$AH!==T$1&&this._$AR(),this._$AH=T$1):t!==this._$AH&&t!==w$1&&this._(t):void 0!==t._$litType$?this.$(t):void 0!==t.nodeType?this.T(t):u$3(t)?this.k(t):this._(t);}S(t){return this._$AA.parentNode.insertBefore(t,this._$AB)}T(t){this._$AH!==t&&(this._$AR(),this._$AH=this.S(t));}_(t){this._$AH!==T$1&&c$3(this._$AH)?this._$AA.nextSibling.data=t:this.T(r$9.createTextNode(t)),this._$AH=t;}$(t){const{values:i,_$litType$:s}=t,e="number"==typeof s?this._$AC(t):(void 0===s.el&&(s.el=V$1.createElement(C$1(s.h,s.h[0]),this.options)),s);if(this._$AH?._$AD===e)this._$AH.p(i);else {const t=new S$1(e,this),s=t.u(this.options);t.p(i),this.T(s),this._$AH=t;}}_$AC(t){let i=A$1.get(t.strings);return void 0===i&&A$1.set(t.strings,i=new V$1(t)),i}k(t){a$2(this._$AH)||(this._$AH=[],this._$AR());const i=this._$AH;let s,e=0;for(const h of t)e===i.length?i.push(s=new M$1(this.S(l$7()),this.S(l$7()),this,this.options)):s=i[e],s._$AI(h),e++;e<i.length&&(this._$AR(s&&s._$AB.nextSibling,e),i.length=e);}_$AR(t=this._$AA.nextSibling,i){for(this._$AP?.(!1,!0,i);t&&t!==this._$AB;){const i=t.nextSibling;t.remove(),t=i;}}setConnected(t){void 0===this._$AM&&(this._$Cv=t,this._$AP?.(t));}}class R$1{get tagName(){return this.element.tagName}get _$AU(){return this._$AM._$AU}constructor(t,i,s,e,h){this.type=1,this._$AH=T$1,this._$AN=void 0,this.element=t,this.name=i,this._$AM=e,this.options=h,s.length>2||""!==s[0]||""!==s[1]?(this._$AH=Array(s.length-1).fill(new String),this.strings=s):this._$AH=T$1;}_$AI(t,i=this,s,e){const h=this.strings;let o=!1;if(void 0===h)t=N$1(this,t,i,0),o=!c$3(t)||t!==this._$AH&&t!==w$1,o&&(this._$AH=t);else {const e=t;let n,r;for(t=h[0],n=0;n<h.length-1;n++)r=N$1(this,e[s+n],i,n),r===w$1&&(r=this._$AH[n]),o||=!c$3(r)||r!==this._$AH[n],r===T$1?t=T$1:t!==T$1&&(t+=(r??"")+h[n+1]),this._$AH[n]=r;}o&&!e&&this.j(t);}j(t){t===T$1?this.element.removeAttribute(this.name):this.element.setAttribute(this.name,t??"");}}class k$1 extends R$1{constructor(){super(...arguments),this.type=3;}j(t){this.element[this.name]=t===T$1?void 0:t;}}class H$2 extends R$1{constructor(){super(...arguments),this.type=4;}j(t){this.element.toggleAttribute(this.name,!!t&&t!==T$1);}}class I$1 extends R$1{constructor(t,i,s,e,h){super(t,i,s,e,h),this.type=5;}_$AI(t,i=this){if((t=N$1(this,t,i,0)??T$1)===w$1)return;const s=this._$AH,e=t===T$1&&s!==T$1||t.capture!==s.capture||t.once!==s.once||t.passive!==s.passive,h=t!==T$1&&(s===T$1||e);e&&this.element.removeEventListener(this.name,this,s),h&&this.element.addEventListener(this.name,this,t),this._$AH=t;}handleEvent(t){"function"==typeof this._$AH?this._$AH.call(this.options?.host??this.element,t):this._$AH.handleEvent(t);}}class L$1{constructor(t,i,s){this.element=t,this.type=6,this._$AN=void 0,this._$AM=i,this.options=s;}get _$AU(){return this._$AM._$AU}_$AI(t){N$1(this,t);}}const z$1={P:e$h,A:h$4,C:o$j,M:1,L:P$1,R:S$1,D:u$3,V:N$1,I:M$1,H:R$1,N:H$2,U:I$1,B:k$1,F:L$1},Z$1=t$8.litHtmlPolyfillSupport;Z$1?.(V$1,M$1),(t$8.litHtmlVersions??=[]).push("3.1.2");const j$2=(t,i,s)=>{const e=s?.renderBefore??i;let h=e._$litPart$;if(void 0===h){const t=s?.renderBefore??null;e._$litPart$=h=new M$1(i.insertBefore(l$7(),t),t,void 0,s??{});}return h._$AI(t),h};

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */class s$4 extends b$2{constructor(){super(...arguments),this.renderOptions={host:this},this._$Do=void 0;}createRenderRoot(){const t=super.createRenderRoot();return this.renderOptions.renderBefore??=t.firstChild,t}update(t){const i=this.render();this.hasUpdated||(this.renderOptions.isConnected=this.isConnected),super.update(t),this._$Do=j$2(i,this.renderRoot,this.renderOptions);}connectedCallback(){super.connectedCallback(),this._$Do?.setConnected(!0);}disconnectedCallback(){super.disconnectedCallback(),this._$Do?.setConnected(!1);}render(){return w$1}}s$4._$litElement$=!0,s$4[("finalized","finalized")]=!0,globalThis.litElementHydrateSupport?.({LitElement:s$4});const r$8=globalThis.litElementPolyfillSupport;r$8?.({LitElement:s$4});const o$i={_$AK:(t,e,i)=>{t._$AK(e,i);},_$AL:t=>t._$AL};(globalThis.litElementVersions??=[]).push("4.0.4");

/**
 * @license
 * Copyright 2022 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const o$h=!1;

// src/components/visually-hidden/visually-hidden.styles.ts
var visually_hidden_styles_default = i$a`
  :host(:not(:focus-within)) {
    position: absolute !important;
    width: 1px !important;
    height: 1px !important;
    clip: rect(0 0 0 0) !important;
    clip-path: inset(50%) !important;
    border: none !important;
    overflow: hidden !important;
    white-space: nowrap !important;
    padding: 0 !important;
  }
`;

// src/styles/component.styles.ts
var component_styles_default = i$a`
  :host {
    box-sizing: border-box;
  }

  :host *,
  :host *::before,
  :host *::after {
    box-sizing: inherit;
  }

  [hidden] {
    display: none !important;
  }
`;

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const t$7=t=>(e,o)=>{void 0!==o?o.addInitializer((()=>{customElements.define(t,e);})):customElements.define(t,e);};

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */const o$g={attribute:!0,type:String,converter:u$4,reflect:!1,hasChanged:f$5},r$7=(t=o$g,e,r)=>{const{kind:n,metadata:i}=r;let s=globalThis.litPropertyMetadata.get(i);if(void 0===s&&globalThis.litPropertyMetadata.set(i,s=new Map),s.set(r.name,t),"accessor"===n){const{name:o}=r;return {set(r){const n=e.get.call(this);e.set.call(this,r),this.requestUpdate(o,n,t);},init(e){return void 0!==e&&this.P(o,void 0,t),e}}}if("setter"===n){const{name:o}=r;return function(r){const n=this[o];e.call(this,r),this.requestUpdate(o,n,t);}}throw Error("Unsupported decorator location: "+n)};function n$b(t){return (e,o)=>"object"==typeof o?r$7(t,e,o):((t,e,o)=>{const r=e.hasOwnProperty(o);return e.constructor.createProperty(o,r?{...t,wrapped:!0}:t),r?Object.getOwnPropertyDescriptor(e,o):void 0})(t,e,o)}

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */function r$6(r){return n$b({...r,state:!0,attribute:!1})}

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
function t$6(t){return (n,o)=>{const c="function"==typeof n?n:n[o];Object.assign(c,t);}}

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const e$g=(e,t,c)=>(c.configurable=!0,c.enumerable=!0,Reflect.decorate&&"object"!=typeof t&&Object.defineProperty(e,t,c),c);

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */function e$f(e,r){return (n,s,i)=>{const o=t=>t.renderRoot?.querySelector(e)??null;if(r){const{get:e,set:r}="object"==typeof s?n:i??(()=>{const t=Symbol();return {get(){return this[t]},set(e){this[t]=e;}}})();return e$g(n,s,{get(){let t=e.call(this);return void 0===t&&(t=o(this),(null!==t||this.hasUpdated)&&r.call(this,t)),t}})}return e$g(n,s,{get(){return o(this)}})}}

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
let e$e;function r$5(r){return (n,o)=>e$g(n,o,{get(){return (this.renderRoot??(e$e??=document.createDocumentFragment())).querySelectorAll(r)}})}

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
function r$4(r){return (n,e)=>e$g(n,e,{async get(){return await this.updateComplete,this.renderRoot?.querySelector(r)??null}})}

/**
 * @license
 * Copyright 2021 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */function o$f(o){return (e,n)=>{const{slot:r,selector:s}=o??{},c="slot"+(r?`[name=${r}]`:":not([name])");return e$g(e,n,{get(){const t=this.renderRoot?.querySelector(c),e=t?.assignedElements(o)??[];return void 0===s?e:e.filter((t=>t.matches(s)))}})}}

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */function n$a(n){return (o,r)=>{const{slot:e}=n??{},s="slot"+(e?`[name=${e}]`:":not([name])");return e$g(o,r,{get(){const t=this.renderRoot?.querySelector(s);return t?.assignedNodes(n)??[]}})}}

var _hasRecordedInitialProperties;
var ShoelaceElement = class extends s$4 {
  constructor() {
    super();
    __privateAdd(this, _hasRecordedInitialProperties, false);
    // Store the constructor value of all `static properties = {}`
    this.initialReflectedProperties = /* @__PURE__ */ new Map();
    Object.entries(this.constructor.dependencies).forEach(([name, component]) => {
      this.constructor.define(name, component);
    });
  }
  emit(name, options) {
    const event = new CustomEvent(name, __spreadValues({
      bubbles: true,
      cancelable: false,
      composed: true,
      detail: {}
    }, options));
    this.dispatchEvent(event);
    return event;
  }
  /* eslint-enable */
  static define(name, elementConstructor = this, options = {}) {
    const currentlyRegisteredConstructor = customElements.get(name);
    if (!currentlyRegisteredConstructor) {
      try {
        customElements.define(name, elementConstructor, options);
      } catch (_err) {
        customElements.define(name, class extends elementConstructor {
        }, options);
      }
      return;
    }
    let newVersion = " (unknown version)";
    let existingVersion = newVersion;
    if ("version" in elementConstructor && elementConstructor.version) {
      newVersion = " v" + elementConstructor.version;
    }
    if ("version" in currentlyRegisteredConstructor && currentlyRegisteredConstructor.version) {
      existingVersion = " v" + currentlyRegisteredConstructor.version;
    }
    if (newVersion && existingVersion && newVersion === existingVersion) {
      return;
    }
    console.warn(
      `Attempted to register <${name}>${newVersion}, but <${name}>${existingVersion} has already been registered.`
    );
  }
  attributeChangedCallback(name, oldValue, newValue) {
    if (!__privateGet(this, _hasRecordedInitialProperties)) {
      this.constructor.elementProperties.forEach(
        (obj, prop) => {
          if (obj.reflect && this[prop] != null) {
            this.initialReflectedProperties.set(prop, this[prop]);
          }
        }
      );
      __privateSet(this, _hasRecordedInitialProperties, true);
    }
    super.attributeChangedCallback(name, oldValue, newValue);
  }
  willUpdate(changedProperties) {
    super.willUpdate(changedProperties);
    this.initialReflectedProperties.forEach((value, prop) => {
      if (changedProperties.has(prop) && this[prop] == null) {
        this[prop] = value;
      }
    });
  }
};
_hasRecordedInitialProperties = new WeakMap();
/* eslint-disable */
// @ts-expect-error This is auto-injected at build time.
ShoelaceElement.version = "2.18.0";
ShoelaceElement.dependencies = {};
__decorateClass([
  n$b()
], ShoelaceElement.prototype, "dir", 2);
__decorateClass([
  n$b()
], ShoelaceElement.prototype, "lang", 2);

var SlVisuallyHidden = class extends ShoelaceElement {
  render() {
    return x$1` <slot></slot> `;
  }
};
SlVisuallyHidden.styles = [component_styles_default, visually_hidden_styles_default];

// src/components/visually-hidden/visually-hidden.ts
var visually_hidden_default = SlVisuallyHidden;
SlVisuallyHidden.define("sl-visually-hidden");

// src/components/tooltip/tooltip.styles.ts
var tooltip_styles_default = i$a`
  :host {
    --max-width: 20rem;
    --hide-delay: 0ms;
    --show-delay: 150ms;

    display: contents;
  }

  .tooltip {
    --arrow-size: var(--sl-tooltip-arrow-size);
    --arrow-color: var(--sl-tooltip-background-color);
  }

  .tooltip::part(popup) {
    z-index: var(--sl-z-index-tooltip);
  }

  .tooltip[placement^='top']::part(popup) {
    transform-origin: bottom;
  }

  .tooltip[placement^='bottom']::part(popup) {
    transform-origin: top;
  }

  .tooltip[placement^='left']::part(popup) {
    transform-origin: right;
  }

  .tooltip[placement^='right']::part(popup) {
    transform-origin: left;
  }

  .tooltip__body {
    display: block;
    width: max-content;
    max-width: var(--max-width);
    border-radius: var(--sl-tooltip-border-radius);
    background-color: var(--sl-tooltip-background-color);
    font-family: var(--sl-tooltip-font-family);
    font-size: var(--sl-tooltip-font-size);
    font-weight: var(--sl-tooltip-font-weight);
    line-height: var(--sl-tooltip-line-height);
    text-align: start;
    white-space: normal;
    color: var(--sl-tooltip-color);
    padding: var(--sl-tooltip-padding);
    pointer-events: none;
    user-select: none;
    -webkit-user-select: none;
  }
`;

// src/components/popup/popup.styles.ts
var popup_styles_default = i$a`
  :host {
    --arrow-color: var(--sl-color-neutral-1000);
    --arrow-size: 6px;

    /*
     * These properties are computed to account for the arrow's dimensions after being rotated 45º. The constant
     * 0.7071 is derived from sin(45), which is the diagonal size of the arrow's container after rotating.
     */
    --arrow-size-diagonal: calc(var(--arrow-size) * 0.7071);
    --arrow-padding-offset: calc(var(--arrow-size-diagonal) - var(--arrow-size));

    display: contents;
  }

  .popup {
    position: absolute;
    isolation: isolate;
    max-width: var(--auto-size-available-width, none);
    max-height: var(--auto-size-available-height, none);
  }

  .popup--fixed {
    position: fixed;
  }

  .popup:not(.popup--active) {
    display: none;
  }

  .popup__arrow {
    position: absolute;
    width: calc(var(--arrow-size-diagonal) * 2);
    height: calc(var(--arrow-size-diagonal) * 2);
    rotate: 45deg;
    background: var(--arrow-color);
    z-index: -1;
  }

  /* Hover bridge */
  .popup-hover-bridge:not(.popup-hover-bridge--visible) {
    display: none;
  }

  .popup-hover-bridge {
    position: fixed;
    z-index: calc(var(--sl-z-index-dropdown) - 1);
    top: 0;
    right: 0;
    bottom: 0;
    left: 0;
    clip-path: polygon(
      var(--hover-bridge-top-left-x, 0) var(--hover-bridge-top-left-y, 0),
      var(--hover-bridge-top-right-x, 0) var(--hover-bridge-top-right-y, 0),
      var(--hover-bridge-bottom-right-x, 0) var(--hover-bridge-bottom-right-y, 0),
      var(--hover-bridge-bottom-left-x, 0) var(--hover-bridge-bottom-left-y, 0)
    );
  }
`;

const connectedElements = new Set();
const documentElementObserver = new MutationObserver(update);
const translations = new Map();
let documentDirection = document.documentElement.dir || 'ltr';
let documentLanguage = document.documentElement.lang || navigator.language;
let fallback;
documentElementObserver.observe(document.documentElement, {
    attributes: true,
    attributeFilter: ['dir', 'lang']
});
function registerTranslation(...translation) {
    translation.map(t => {
        const code = t.$code.toLowerCase();
        if (translations.has(code)) {
            translations.set(code, Object.assign(Object.assign({}, translations.get(code)), t));
        }
        else {
            translations.set(code, t);
        }
        if (!fallback) {
            fallback = t;
        }
    });
    update();
}
function update() {
    documentDirection = document.documentElement.dir || 'ltr';
    documentLanguage = document.documentElement.lang || navigator.language;
    [...connectedElements.keys()].map((el) => {
        if (typeof el.requestUpdate === 'function') {
            el.requestUpdate();
        }
    });
}
class LocalizeController$1 {
    constructor(host) {
        this.host = host;
        this.host.addController(this);
    }
    hostConnected() {
        connectedElements.add(this.host);
    }
    hostDisconnected() {
        connectedElements.delete(this.host);
    }
    dir() {
        return `${this.host.dir || documentDirection}`.toLowerCase();
    }
    lang() {
        return `${this.host.lang || documentLanguage}`.toLowerCase();
    }
    getTranslationData(lang) {
        var _a, _b;
        const locale = new Intl.Locale(lang.replace(/_/g, '-'));
        const language = locale === null || locale === void 0 ? void 0 : locale.language.toLowerCase();
        const region = (_b = (_a = locale === null || locale === void 0 ? void 0 : locale.region) === null || _a === void 0 ? void 0 : _a.toLowerCase()) !== null && _b !== void 0 ? _b : '';
        const primary = translations.get(`${language}-${region}`);
        const secondary = translations.get(language);
        return { locale, language, region, primary, secondary };
    }
    exists(key, options) {
        var _a;
        const { primary, secondary } = this.getTranslationData((_a = options.lang) !== null && _a !== void 0 ? _a : this.lang());
        options = Object.assign({ includeFallback: false }, options);
        if ((primary && primary[key]) ||
            (secondary && secondary[key]) ||
            (options.includeFallback && fallback && fallback[key])) {
            return true;
        }
        return false;
    }
    term(key, ...args) {
        const { primary, secondary } = this.getTranslationData(this.lang());
        let term;
        if (primary && primary[key]) {
            term = primary[key];
        }
        else if (secondary && secondary[key]) {
            term = secondary[key];
        }
        else if (fallback && fallback[key]) {
            term = fallback[key];
        }
        else {
            console.error(`No translation found for: ${String(key)}`);
            return String(key);
        }
        if (typeof term === 'function') {
            return term(...args);
        }
        return term;
    }
    date(dateToFormat, options) {
        dateToFormat = new Date(dateToFormat);
        return new Intl.DateTimeFormat(this.lang(), options).format(dateToFormat);
    }
    number(numberToFormat, options) {
        numberToFormat = Number(numberToFormat);
        return isNaN(numberToFormat) ? '' : new Intl.NumberFormat(this.lang(), options).format(numberToFormat);
    }
    relativeTime(value, unit, options) {
        return new Intl.RelativeTimeFormat(this.lang(), options).format(value, unit);
    }
}

// src/translations/en.ts
var translation = {
  $code: "en",
  $name: "English",
  $dir: "ltr",
  carousel: "Carousel",
  clearEntry: "Clear entry",
  close: "Close",
  copied: "Copied",
  copy: "Copy",
  currentValue: "Current value",
  error: "Error",
  goToSlide: (slide, count) => `Go to slide ${slide} of ${count}`,
  hidePassword: "Hide password",
  loading: "Loading",
  nextSlide: "Next slide",
  numOptionsSelected: (num) => {
    if (num === 0)
      return "No options selected";
    if (num === 1)
      return "1 option selected";
    return `${num} options selected`;
  },
  previousSlide: "Previous slide",
  progress: "Progress",
  remove: "Remove",
  resize: "Resize",
  scrollToEnd: "Scroll to end",
  scrollToStart: "Scroll to start",
  selectAColorFromTheScreen: "Select a color from the screen",
  showPassword: "Show password",
  slideNum: (slide) => `Slide ${slide}`,
  toggleColorFormat: "Toggle color format"
};
registerTranslation(translation);
var en_default = translation;

var LocalizeController = class extends LocalizeController$1 {
};
registerTranslation(en_default);

/**
 * Custom positioning reference element.
 * @see https://floating-ui.com/docs/virtual-elements
 */

const sides = ['top', 'right', 'bottom', 'left'];
const alignments = ['start', 'end'];
const placements = /*#__PURE__*/sides.reduce((acc, side) => acc.concat(side, side + "-" + alignments[0], side + "-" + alignments[1]), []);
const min$1 = Math.min;
const max = Math.max;
const round = Math.round;
const floor$2 = Math.floor;
const createCoords = v => ({
  x: v,
  y: v
});
const oppositeSideMap = {
  left: 'right',
  right: 'left',
  bottom: 'top',
  top: 'bottom'
};
const oppositeAlignmentMap = {
  start: 'end',
  end: 'start'
};
function clamp$1(start, value, end) {
  return max(start, min$1(value, end));
}
function evaluate(value, param) {
  return typeof value === 'function' ? value(param) : value;
}
function getSide(placement) {
  return placement.split('-')[0];
}
function getAlignment(placement) {
  return placement.split('-')[1];
}
function getOppositeAxis(axis) {
  return axis === 'x' ? 'y' : 'x';
}
function getAxisLength(axis) {
  return axis === 'y' ? 'height' : 'width';
}
function getSideAxis(placement) {
  return ['top', 'bottom'].includes(getSide(placement)) ? 'y' : 'x';
}
function getAlignmentAxis(placement) {
  return getOppositeAxis(getSideAxis(placement));
}
function getAlignmentSides(placement, rects, rtl) {
  if (rtl === void 0) {
    rtl = false;
  }
  const alignment = getAlignment(placement);
  const alignmentAxis = getAlignmentAxis(placement);
  const length = getAxisLength(alignmentAxis);
  let mainAlignmentSide = alignmentAxis === 'x' ? alignment === (rtl ? 'end' : 'start') ? 'right' : 'left' : alignment === 'start' ? 'bottom' : 'top';
  if (rects.reference[length] > rects.floating[length]) {
    mainAlignmentSide = getOppositePlacement(mainAlignmentSide);
  }
  return [mainAlignmentSide, getOppositePlacement(mainAlignmentSide)];
}
function getExpandedPlacements(placement) {
  const oppositePlacement = getOppositePlacement(placement);
  return [getOppositeAlignmentPlacement(placement), oppositePlacement, getOppositeAlignmentPlacement(oppositePlacement)];
}
function getOppositeAlignmentPlacement(placement) {
  return placement.replace(/start|end/g, alignment => oppositeAlignmentMap[alignment]);
}
function getSideList(side, isStart, rtl) {
  const lr = ['left', 'right'];
  const rl = ['right', 'left'];
  const tb = ['top', 'bottom'];
  const bt = ['bottom', 'top'];
  switch (side) {
    case 'top':
    case 'bottom':
      if (rtl) return isStart ? rl : lr;
      return isStart ? lr : rl;
    case 'left':
    case 'right':
      return isStart ? tb : bt;
    default:
      return [];
  }
}
function getOppositeAxisPlacements(placement, flipAlignment, direction, rtl) {
  const alignment = getAlignment(placement);
  let list = getSideList(getSide(placement), direction === 'start', rtl);
  if (alignment) {
    list = list.map(side => side + "-" + alignment);
    if (flipAlignment) {
      list = list.concat(list.map(getOppositeAlignmentPlacement));
    }
  }
  return list;
}
function getOppositePlacement(placement) {
  return placement.replace(/left|right|bottom|top/g, side => oppositeSideMap[side]);
}
function expandPaddingObject(padding) {
  return {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0,
    ...padding
  };
}
function getPaddingObject(padding) {
  return typeof padding !== 'number' ? expandPaddingObject(padding) : {
    top: padding,
    right: padding,
    bottom: padding,
    left: padding
  };
}
function rectToClientRect(rect) {
  return {
    ...rect,
    top: rect.y,
    left: rect.x,
    right: rect.x + rect.width,
    bottom: rect.y + rect.height
  };
}

function computeCoordsFromPlacement(_ref, placement, rtl) {
  let {
    reference,
    floating
  } = _ref;
  const sideAxis = getSideAxis(placement);
  const alignmentAxis = getAlignmentAxis(placement);
  const alignLength = getAxisLength(alignmentAxis);
  const side = getSide(placement);
  const isVertical = sideAxis === 'y';
  const commonX = reference.x + reference.width / 2 - floating.width / 2;
  const commonY = reference.y + reference.height / 2 - floating.height / 2;
  const commonAlign = reference[alignLength] / 2 - floating[alignLength] / 2;
  let coords;
  switch (side) {
    case 'top':
      coords = {
        x: commonX,
        y: reference.y - floating.height
      };
      break;
    case 'bottom':
      coords = {
        x: commonX,
        y: reference.y + reference.height
      };
      break;
    case 'right':
      coords = {
        x: reference.x + reference.width,
        y: commonY
      };
      break;
    case 'left':
      coords = {
        x: reference.x - floating.width,
        y: commonY
      };
      break;
    default:
      coords = {
        x: reference.x,
        y: reference.y
      };
  }
  switch (getAlignment(placement)) {
    case 'start':
      coords[alignmentAxis] -= commonAlign * (rtl && isVertical ? -1 : 1);
      break;
    case 'end':
      coords[alignmentAxis] += commonAlign * (rtl && isVertical ? -1 : 1);
      break;
  }
  return coords;
}

/**
 * Computes the `x` and `y` coordinates that will place the floating element
 * next to a given reference element.
 *
 * This export does not have any `platform` interface logic. You will need to
 * write one for the platform you are using Floating UI with.
 */
const computePosition$1 = async (reference, floating, config) => {
  const {
    placement = 'bottom',
    strategy = 'absolute',
    middleware = [],
    platform
  } = config;
  const validMiddleware = middleware.filter(Boolean);
  const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(floating));
  let rects = await platform.getElementRects({
    reference,
    floating,
    strategy
  });
  let {
    x,
    y
  } = computeCoordsFromPlacement(rects, placement, rtl);
  let statefulPlacement = placement;
  let middlewareData = {};
  let resetCount = 0;
  for (let i = 0; i < validMiddleware.length; i++) {
    const {
      name,
      fn
    } = validMiddleware[i];
    const {
      x: nextX,
      y: nextY,
      data,
      reset
    } = await fn({
      x,
      y,
      initialPlacement: placement,
      placement: statefulPlacement,
      strategy,
      middlewareData,
      rects,
      platform,
      elements: {
        reference,
        floating
      }
    });
    x = nextX != null ? nextX : x;
    y = nextY != null ? nextY : y;
    middlewareData = {
      ...middlewareData,
      [name]: {
        ...middlewareData[name],
        ...data
      }
    };
    if (reset && resetCount <= 50) {
      resetCount++;
      if (typeof reset === 'object') {
        if (reset.placement) {
          statefulPlacement = reset.placement;
        }
        if (reset.rects) {
          rects = reset.rects === true ? await platform.getElementRects({
            reference,
            floating,
            strategy
          }) : reset.rects;
        }
        ({
          x,
          y
        } = computeCoordsFromPlacement(rects, statefulPlacement, rtl));
      }
      i = -1;
    }
  }
  return {
    x,
    y,
    placement: statefulPlacement,
    strategy,
    middlewareData
  };
};

/**
 * Resolves with an object of overflow side offsets that determine how much the
 * element is overflowing a given clipping boundary on each side.
 * - positive = overflowing the boundary by that number of pixels
 * - negative = how many pixels left before it will overflow
 * - 0 = lies flush with the boundary
 * @see https://floating-ui.com/docs/detectOverflow
 */
async function detectOverflow(state, options) {
  var _await$platform$isEle;
  if (options === void 0) {
    options = {};
  }
  const {
    x,
    y,
    platform,
    rects,
    elements,
    strategy
  } = state;
  const {
    boundary = 'clippingAncestors',
    rootBoundary = 'viewport',
    elementContext = 'floating',
    altBoundary = false,
    padding = 0
  } = evaluate(options, state);
  const paddingObject = getPaddingObject(padding);
  const altContext = elementContext === 'floating' ? 'reference' : 'floating';
  const element = elements[altBoundary ? altContext : elementContext];
  const clippingClientRect = rectToClientRect(await platform.getClippingRect({
    element: ((_await$platform$isEle = await (platform.isElement == null ? void 0 : platform.isElement(element))) != null ? _await$platform$isEle : true) ? element : element.contextElement || (await (platform.getDocumentElement == null ? void 0 : platform.getDocumentElement(elements.floating))),
    boundary,
    rootBoundary,
    strategy
  }));
  const rect = elementContext === 'floating' ? {
    ...rects.floating,
    x,
    y
  } : rects.reference;
  const offsetParent = await (platform.getOffsetParent == null ? void 0 : platform.getOffsetParent(elements.floating));
  const offsetScale = (await (platform.isElement == null ? void 0 : platform.isElement(offsetParent))) ? (await (platform.getScale == null ? void 0 : platform.getScale(offsetParent))) || {
    x: 1,
    y: 1
  } : {
    x: 1,
    y: 1
  };
  const elementClientRect = rectToClientRect(platform.convertOffsetParentRelativeRectToViewportRelativeRect ? await platform.convertOffsetParentRelativeRectToViewportRelativeRect({
    elements,
    rect,
    offsetParent,
    strategy
  }) : rect);
  return {
    top: (clippingClientRect.top - elementClientRect.top + paddingObject.top) / offsetScale.y,
    bottom: (elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom) / offsetScale.y,
    left: (clippingClientRect.left - elementClientRect.left + paddingObject.left) / offsetScale.x,
    right: (elementClientRect.right - clippingClientRect.right + paddingObject.right) / offsetScale.x
  };
}

/**
 * Provides data to position an inner element of the floating element so that it
 * appears centered to the reference element.
 * @see https://floating-ui.com/docs/arrow
 */
const arrow$1 = options => ({
  name: 'arrow',
  options,
  async fn(state) {
    const {
      x,
      y,
      placement,
      rects,
      platform,
      elements,
      middlewareData
    } = state;
    // Since `element` is required, we don't Partial<> the type.
    const {
      element,
      padding = 0
    } = evaluate(options, state) || {};
    if (element == null) {
      return {};
    }
    const paddingObject = getPaddingObject(padding);
    const coords = {
      x,
      y
    };
    const axis = getAlignmentAxis(placement);
    const length = getAxisLength(axis);
    const arrowDimensions = await platform.getDimensions(element);
    const isYAxis = axis === 'y';
    const minProp = isYAxis ? 'top' : 'left';
    const maxProp = isYAxis ? 'bottom' : 'right';
    const clientProp = isYAxis ? 'clientHeight' : 'clientWidth';
    const endDiff = rects.reference[length] + rects.reference[axis] - coords[axis] - rects.floating[length];
    const startDiff = coords[axis] - rects.reference[axis];
    const arrowOffsetParent = await (platform.getOffsetParent == null ? void 0 : platform.getOffsetParent(element));
    let clientSize = arrowOffsetParent ? arrowOffsetParent[clientProp] : 0;

    // DOM platform can return `window` as the `offsetParent`.
    if (!clientSize || !(await (platform.isElement == null ? void 0 : platform.isElement(arrowOffsetParent)))) {
      clientSize = elements.floating[clientProp] || rects.floating[length];
    }
    const centerToReference = endDiff / 2 - startDiff / 2;

    // If the padding is large enough that it causes the arrow to no longer be
    // centered, modify the padding so that it is centered.
    const largestPossiblePadding = clientSize / 2 - arrowDimensions[length] / 2 - 1;
    const minPadding = min$1(paddingObject[minProp], largestPossiblePadding);
    const maxPadding = min$1(paddingObject[maxProp], largestPossiblePadding);

    // Make sure the arrow doesn't overflow the floating element if the center
    // point is outside the floating element's bounds.
    const min$1$1 = minPadding;
    const max = clientSize - arrowDimensions[length] - maxPadding;
    const center = clientSize / 2 - arrowDimensions[length] / 2 + centerToReference;
    const offset = clamp$1(min$1$1, center, max);

    // If the reference is small enough that the arrow's padding causes it to
    // to point to nothing for an aligned placement, adjust the offset of the
    // floating element itself. To ensure `shift()` continues to take action,
    // a single reset is performed when this is true.
    const shouldAddOffset = !middlewareData.arrow && getAlignment(placement) != null && center !== offset && rects.reference[length] / 2 - (center < min$1$1 ? minPadding : maxPadding) - arrowDimensions[length] / 2 < 0;
    const alignmentOffset = shouldAddOffset ? center < min$1$1 ? center - min$1$1 : center - max : 0;
    return {
      [axis]: coords[axis] + alignmentOffset,
      data: {
        [axis]: offset,
        centerOffset: center - offset - alignmentOffset,
        ...(shouldAddOffset && {
          alignmentOffset
        })
      },
      reset: shouldAddOffset
    };
  }
});

function getPlacementList(alignment, autoAlignment, allowedPlacements) {
  const allowedPlacementsSortedByAlignment = alignment ? [...allowedPlacements.filter(placement => getAlignment(placement) === alignment), ...allowedPlacements.filter(placement => getAlignment(placement) !== alignment)] : allowedPlacements.filter(placement => getSide(placement) === placement);
  return allowedPlacementsSortedByAlignment.filter(placement => {
    if (alignment) {
      return getAlignment(placement) === alignment || (autoAlignment ? getOppositeAlignmentPlacement(placement) !== placement : false);
    }
    return true;
  });
}
/**
 * Optimizes the visibility of the floating element by choosing the placement
 * that has the most space available automatically, without needing to specify a
 * preferred placement. Alternative to `flip`.
 * @see https://floating-ui.com/docs/autoPlacement
 */
const autoPlacement$1 = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'autoPlacement',
    options,
    async fn(state) {
      var _middlewareData$autoP, _middlewareData$autoP2, _placementsThatFitOnE;
      const {
        rects,
        middlewareData,
        placement,
        platform,
        elements
      } = state;
      const {
        crossAxis = false,
        alignment,
        allowedPlacements = placements,
        autoAlignment = true,
        ...detectOverflowOptions
      } = evaluate(options, state);
      const placements$1 = alignment !== undefined || allowedPlacements === placements ? getPlacementList(alignment || null, autoAlignment, allowedPlacements) : allowedPlacements;
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const currentIndex = ((_middlewareData$autoP = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP.index) || 0;
      const currentPlacement = placements$1[currentIndex];
      if (currentPlacement == null) {
        return {};
      }
      const alignmentSides = getAlignmentSides(currentPlacement, rects, await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating)));

      // Make `computeCoords` start from the right place.
      if (placement !== currentPlacement) {
        return {
          reset: {
            placement: placements$1[0]
          }
        };
      }
      const currentOverflows = [overflow[getSide(currentPlacement)], overflow[alignmentSides[0]], overflow[alignmentSides[1]]];
      const allOverflows = [...(((_middlewareData$autoP2 = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP2.overflows) || []), {
        placement: currentPlacement,
        overflows: currentOverflows
      }];
      const nextPlacement = placements$1[currentIndex + 1];

      // There are more placements to check.
      if (nextPlacement) {
        return {
          data: {
            index: currentIndex + 1,
            overflows: allOverflows
          },
          reset: {
            placement: nextPlacement
          }
        };
      }
      const placementsSortedByMostSpace = allOverflows.map(d => {
        const alignment = getAlignment(d.placement);
        return [d.placement, alignment && crossAxis ?
        // Check along the mainAxis and main crossAxis side.
        d.overflows.slice(0, 2).reduce((acc, v) => acc + v, 0) :
        // Check only the mainAxis.
        d.overflows[0], d.overflows];
      }).sort((a, b) => a[1] - b[1]);
      const placementsThatFitOnEachSide = placementsSortedByMostSpace.filter(d => d[2].slice(0,
      // Aligned placements should not check their opposite crossAxis
      // side.
      getAlignment(d[0]) ? 2 : 3).every(v => v <= 0));
      const resetPlacement = ((_placementsThatFitOnE = placementsThatFitOnEachSide[0]) == null ? void 0 : _placementsThatFitOnE[0]) || placementsSortedByMostSpace[0][0];
      if (resetPlacement !== placement) {
        return {
          data: {
            index: currentIndex + 1,
            overflows: allOverflows
          },
          reset: {
            placement: resetPlacement
          }
        };
      }
      return {};
    }
  };
};

/**
 * Optimizes the visibility of the floating element by flipping the `placement`
 * in order to keep it in view when the preferred placement(s) will overflow the
 * clipping boundary. Alternative to `autoPlacement`.
 * @see https://floating-ui.com/docs/flip
 */
const flip$2 = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'flip',
    options,
    async fn(state) {
      var _middlewareData$arrow, _middlewareData$flip;
      const {
        placement,
        middlewareData,
        rects,
        initialPlacement,
        platform,
        elements
      } = state;
      const {
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = true,
        fallbackPlacements: specifiedFallbackPlacements,
        fallbackStrategy = 'bestFit',
        fallbackAxisSideDirection = 'none',
        flipAlignment = true,
        ...detectOverflowOptions
      } = evaluate(options, state);

      // If a reset by the arrow was caused due to an alignment offset being
      // added, we should skip any logic now since `flip()` has already done its
      // work.
      // https://github.com/floating-ui/floating-ui/issues/2549#issuecomment-1719601643
      if ((_middlewareData$arrow = middlewareData.arrow) != null && _middlewareData$arrow.alignmentOffset) {
        return {};
      }
      const side = getSide(placement);
      const isBasePlacement = getSide(initialPlacement) === initialPlacement;
      const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating));
      const fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipAlignment ? [getOppositePlacement(initialPlacement)] : getExpandedPlacements(initialPlacement));
      if (!specifiedFallbackPlacements && fallbackAxisSideDirection !== 'none') {
        fallbackPlacements.push(...getOppositeAxisPlacements(initialPlacement, flipAlignment, fallbackAxisSideDirection, rtl));
      }
      const placements = [initialPlacement, ...fallbackPlacements];
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const overflows = [];
      let overflowsData = ((_middlewareData$flip = middlewareData.flip) == null ? void 0 : _middlewareData$flip.overflows) || [];
      if (checkMainAxis) {
        overflows.push(overflow[side]);
      }
      if (checkCrossAxis) {
        const sides = getAlignmentSides(placement, rects, rtl);
        overflows.push(overflow[sides[0]], overflow[sides[1]]);
      }
      overflowsData = [...overflowsData, {
        placement,
        overflows
      }];

      // One or more sides is overflowing.
      if (!overflows.every(side => side <= 0)) {
        var _middlewareData$flip2, _overflowsData$filter;
        const nextIndex = (((_middlewareData$flip2 = middlewareData.flip) == null ? void 0 : _middlewareData$flip2.index) || 0) + 1;
        const nextPlacement = placements[nextIndex];
        if (nextPlacement) {
          // Try next placement and re-run the lifecycle.
          return {
            data: {
              index: nextIndex,
              overflows: overflowsData
            },
            reset: {
              placement: nextPlacement
            }
          };
        }

        // First, find the candidates that fit on the mainAxis side of overflow,
        // then find the placement that fits the best on the main crossAxis side.
        let resetPlacement = (_overflowsData$filter = overflowsData.filter(d => d.overflows[0] <= 0).sort((a, b) => a.overflows[1] - b.overflows[1])[0]) == null ? void 0 : _overflowsData$filter.placement;

        // Otherwise fallback.
        if (!resetPlacement) {
          switch (fallbackStrategy) {
            case 'bestFit':
              {
                var _overflowsData$map$so;
                const placement = (_overflowsData$map$so = overflowsData.map(d => [d.placement, d.overflows.filter(overflow => overflow > 0).reduce((acc, overflow) => acc + overflow, 0)]).sort((a, b) => a[1] - b[1])[0]) == null ? void 0 : _overflowsData$map$so[0];
                if (placement) {
                  resetPlacement = placement;
                }
                break;
              }
            case 'initialPlacement':
              resetPlacement = initialPlacement;
              break;
          }
        }
        if (placement !== resetPlacement) {
          return {
            reset: {
              placement: resetPlacement
            }
          };
        }
      }
      return {};
    }
  };
};

function getSideOffsets(overflow, rect) {
  return {
    top: overflow.top - rect.height,
    right: overflow.right - rect.width,
    bottom: overflow.bottom - rect.height,
    left: overflow.left - rect.width
  };
}
function isAnySideFullyClipped(overflow) {
  return sides.some(side => overflow[side] >= 0);
}
/**
 * Provides data to hide the floating element in applicable situations, such as
 * when it is not in the same clipping context as the reference element.
 * @see https://floating-ui.com/docs/hide
 */
const hide$1 = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'hide',
    options,
    async fn(state) {
      const {
        rects
      } = state;
      const {
        strategy = 'referenceHidden',
        ...detectOverflowOptions
      } = evaluate(options, state);
      switch (strategy) {
        case 'referenceHidden':
          {
            const overflow = await detectOverflow(state, {
              ...detectOverflowOptions,
              elementContext: 'reference'
            });
            const offsets = getSideOffsets(overflow, rects.reference);
            return {
              data: {
                referenceHiddenOffsets: offsets,
                referenceHidden: isAnySideFullyClipped(offsets)
              }
            };
          }
        case 'escaped':
          {
            const overflow = await detectOverflow(state, {
              ...detectOverflowOptions,
              altBoundary: true
            });
            const offsets = getSideOffsets(overflow, rects.floating);
            return {
              data: {
                escapedOffsets: offsets,
                escaped: isAnySideFullyClipped(offsets)
              }
            };
          }
        default:
          {
            return {};
          }
      }
    }
  };
};

function getBoundingRect(rects) {
  const minX = min$1(...rects.map(rect => rect.left));
  const minY = min$1(...rects.map(rect => rect.top));
  const maxX = max(...rects.map(rect => rect.right));
  const maxY = max(...rects.map(rect => rect.bottom));
  return {
    x: minX,
    y: minY,
    width: maxX - minX,
    height: maxY - minY
  };
}
function getRectsByLine(rects) {
  const sortedRects = rects.slice().sort((a, b) => a.y - b.y);
  const groups = [];
  let prevRect = null;
  for (let i = 0; i < sortedRects.length; i++) {
    const rect = sortedRects[i];
    if (!prevRect || rect.y - prevRect.y > prevRect.height / 2) {
      groups.push([rect]);
    } else {
      groups[groups.length - 1].push(rect);
    }
    prevRect = rect;
  }
  return groups.map(rect => rectToClientRect(getBoundingRect(rect)));
}
/**
 * Provides improved positioning for inline reference elements that can span
 * over multiple lines, such as hyperlinks or range selections.
 * @see https://floating-ui.com/docs/inline
 */
const inline$1 = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'inline',
    options,
    async fn(state) {
      const {
        placement,
        elements,
        rects,
        platform,
        strategy
      } = state;
      // A MouseEvent's client{X,Y} coords can be up to 2 pixels off a
      // ClientRect's bounds, despite the event listener being triggered. A
      // padding of 2 seems to handle this issue.
      const {
        padding = 2,
        x,
        y
      } = evaluate(options, state);
      const nativeClientRects = Array.from((await (platform.getClientRects == null ? void 0 : platform.getClientRects(elements.reference))) || []);
      const clientRects = getRectsByLine(nativeClientRects);
      const fallback = rectToClientRect(getBoundingRect(nativeClientRects));
      const paddingObject = getPaddingObject(padding);
      function getBoundingClientRect() {
        // There are two rects and they are disjoined.
        if (clientRects.length === 2 && clientRects[0].left > clientRects[1].right && x != null && y != null) {
          // Find the first rect in which the point is fully inside.
          return clientRects.find(rect => x > rect.left - paddingObject.left && x < rect.right + paddingObject.right && y > rect.top - paddingObject.top && y < rect.bottom + paddingObject.bottom) || fallback;
        }

        // There are 2 or more connected rects.
        if (clientRects.length >= 2) {
          if (getSideAxis(placement) === 'y') {
            const firstRect = clientRects[0];
            const lastRect = clientRects[clientRects.length - 1];
            const isTop = getSide(placement) === 'top';
            const top = firstRect.top;
            const bottom = lastRect.bottom;
            const left = isTop ? firstRect.left : lastRect.left;
            const right = isTop ? firstRect.right : lastRect.right;
            const width = right - left;
            const height = bottom - top;
            return {
              top,
              bottom,
              left,
              right,
              width,
              height,
              x: left,
              y: top
            };
          }
          const isLeftSide = getSide(placement) === 'left';
          const maxRight = max(...clientRects.map(rect => rect.right));
          const minLeft = min$1(...clientRects.map(rect => rect.left));
          const measureRects = clientRects.filter(rect => isLeftSide ? rect.left === minLeft : rect.right === maxRight);
          const top = measureRects[0].top;
          const bottom = measureRects[measureRects.length - 1].bottom;
          const left = minLeft;
          const right = maxRight;
          const width = right - left;
          const height = bottom - top;
          return {
            top,
            bottom,
            left,
            right,
            width,
            height,
            x: left,
            y: top
          };
        }
        return fallback;
      }
      const resetRects = await platform.getElementRects({
        reference: {
          getBoundingClientRect
        },
        floating: elements.floating,
        strategy
      });
      if (rects.reference.x !== resetRects.reference.x || rects.reference.y !== resetRects.reference.y || rects.reference.width !== resetRects.reference.width || rects.reference.height !== resetRects.reference.height) {
        return {
          reset: {
            rects: resetRects
          }
        };
      }
      return {};
    }
  };
};

// For type backwards-compatibility, the `OffsetOptions` type was also
// Derivable.

async function convertValueToCoords(state, options) {
  const {
    placement,
    platform,
    elements
  } = state;
  const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating));
  const side = getSide(placement);
  const alignment = getAlignment(placement);
  const isVertical = getSideAxis(placement) === 'y';
  const mainAxisMulti = ['left', 'top'].includes(side) ? -1 : 1;
  const crossAxisMulti = rtl && isVertical ? -1 : 1;
  const rawValue = evaluate(options, state);
  let {
    mainAxis,
    crossAxis,
    alignmentAxis
  } = typeof rawValue === 'number' ? {
    mainAxis: rawValue,
    crossAxis: 0,
    alignmentAxis: null
  } : {
    mainAxis: 0,
    crossAxis: 0,
    alignmentAxis: null,
    ...rawValue
  };
  if (alignment && typeof alignmentAxis === 'number') {
    crossAxis = alignment === 'end' ? alignmentAxis * -1 : alignmentAxis;
  }
  return isVertical ? {
    x: crossAxis * crossAxisMulti,
    y: mainAxis * mainAxisMulti
  } : {
    x: mainAxis * mainAxisMulti,
    y: crossAxis * crossAxisMulti
  };
}

/**
 * Modifies the placement by translating the floating element along the
 * specified axes.
 * A number (shorthand for `mainAxis` or distance), or an axes configuration
 * object may be passed.
 * @see https://floating-ui.com/docs/offset
 */
const offset$1 = function (options) {
  if (options === void 0) {
    options = 0;
  }
  return {
    name: 'offset',
    options,
    async fn(state) {
      var _middlewareData$offse, _middlewareData$arrow;
      const {
        x,
        y,
        placement,
        middlewareData
      } = state;
      const diffCoords = await convertValueToCoords(state, options);

      // If the placement is the same and the arrow caused an alignment offset
      // then we don't need to change the positioning coordinates.
      if (placement === ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse.placement) && (_middlewareData$arrow = middlewareData.arrow) != null && _middlewareData$arrow.alignmentOffset) {
        return {};
      }
      return {
        x: x + diffCoords.x,
        y: y + diffCoords.y,
        data: {
          ...diffCoords,
          placement
        }
      };
    }
  };
};

/**
 * Optimizes the visibility of the floating element by shifting it in order to
 * keep it in view when it will overflow the clipping boundary.
 * @see https://floating-ui.com/docs/shift
 */
const shift$3 = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'shift',
    options,
    async fn(state) {
      const {
        x,
        y,
        placement
      } = state;
      const {
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = false,
        limiter = {
          fn: _ref => {
            let {
              x,
              y
            } = _ref;
            return {
              x,
              y
            };
          }
        },
        ...detectOverflowOptions
      } = evaluate(options, state);
      const coords = {
        x,
        y
      };
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const crossAxis = getSideAxis(getSide(placement));
      const mainAxis = getOppositeAxis(crossAxis);
      let mainAxisCoord = coords[mainAxis];
      let crossAxisCoord = coords[crossAxis];
      if (checkMainAxis) {
        const minSide = mainAxis === 'y' ? 'top' : 'left';
        const maxSide = mainAxis === 'y' ? 'bottom' : 'right';
        const min = mainAxisCoord + overflow[minSide];
        const max = mainAxisCoord - overflow[maxSide];
        mainAxisCoord = clamp$1(min, mainAxisCoord, max);
      }
      if (checkCrossAxis) {
        const minSide = crossAxis === 'y' ? 'top' : 'left';
        const maxSide = crossAxis === 'y' ? 'bottom' : 'right';
        const min = crossAxisCoord + overflow[minSide];
        const max = crossAxisCoord - overflow[maxSide];
        crossAxisCoord = clamp$1(min, crossAxisCoord, max);
      }
      const limitedCoords = limiter.fn({
        ...state,
        [mainAxis]: mainAxisCoord,
        [crossAxis]: crossAxisCoord
      });
      return {
        ...limitedCoords,
        data: {
          x: limitedCoords.x - x,
          y: limitedCoords.y - y
        }
      };
    }
  };
};
/**
 * Built-in `limiter` that will stop `shift()` at a certain point.
 */
const limitShift$1 = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    options,
    fn(state) {
      const {
        x,
        y,
        placement,
        rects,
        middlewareData
      } = state;
      const {
        offset = 0,
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = true
      } = evaluate(options, state);
      const coords = {
        x,
        y
      };
      const crossAxis = getSideAxis(placement);
      const mainAxis = getOppositeAxis(crossAxis);
      let mainAxisCoord = coords[mainAxis];
      let crossAxisCoord = coords[crossAxis];
      const rawOffset = evaluate(offset, state);
      const computedOffset = typeof rawOffset === 'number' ? {
        mainAxis: rawOffset,
        crossAxis: 0
      } : {
        mainAxis: 0,
        crossAxis: 0,
        ...rawOffset
      };
      if (checkMainAxis) {
        const len = mainAxis === 'y' ? 'height' : 'width';
        const limitMin = rects.reference[mainAxis] - rects.floating[len] + computedOffset.mainAxis;
        const limitMax = rects.reference[mainAxis] + rects.reference[len] - computedOffset.mainAxis;
        if (mainAxisCoord < limitMin) {
          mainAxisCoord = limitMin;
        } else if (mainAxisCoord > limitMax) {
          mainAxisCoord = limitMax;
        }
      }
      if (checkCrossAxis) {
        var _middlewareData$offse, _middlewareData$offse2;
        const len = mainAxis === 'y' ? 'width' : 'height';
        const isOriginSide = ['top', 'left'].includes(getSide(placement));
        const limitMin = rects.reference[crossAxis] - rects.floating[len] + (isOriginSide ? ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse[crossAxis]) || 0 : 0) + (isOriginSide ? 0 : computedOffset.crossAxis);
        const limitMax = rects.reference[crossAxis] + rects.reference[len] + (isOriginSide ? 0 : ((_middlewareData$offse2 = middlewareData.offset) == null ? void 0 : _middlewareData$offse2[crossAxis]) || 0) - (isOriginSide ? computedOffset.crossAxis : 0);
        if (crossAxisCoord < limitMin) {
          crossAxisCoord = limitMin;
        } else if (crossAxisCoord > limitMax) {
          crossAxisCoord = limitMax;
        }
      }
      return {
        [mainAxis]: mainAxisCoord,
        [crossAxis]: crossAxisCoord
      };
    }
  };
};

/**
 * Provides data that allows you to change the size of the floating element —
 * for instance, prevent it from overflowing the clipping boundary or match the
 * width of the reference element.
 * @see https://floating-ui.com/docs/size
 */
const size$1 = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'size',
    options,
    async fn(state) {
      const {
        placement,
        rects,
        platform,
        elements
      } = state;
      const {
        apply = () => {},
        ...detectOverflowOptions
      } = evaluate(options, state);
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const side = getSide(placement);
      const alignment = getAlignment(placement);
      const isYAxis = getSideAxis(placement) === 'y';
      const {
        width,
        height
      } = rects.floating;
      let heightSide;
      let widthSide;
      if (side === 'top' || side === 'bottom') {
        heightSide = side;
        widthSide = alignment === ((await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating))) ? 'start' : 'end') ? 'left' : 'right';
      } else {
        widthSide = side;
        heightSide = alignment === 'end' ? 'top' : 'bottom';
      }
      const overflowAvailableHeight = height - overflow[heightSide];
      const overflowAvailableWidth = width - overflow[widthSide];
      const noShift = !state.middlewareData.shift;
      let availableHeight = overflowAvailableHeight;
      let availableWidth = overflowAvailableWidth;
      if (isYAxis) {
        const maximumClippingWidth = width - overflow.left - overflow.right;
        availableWidth = alignment || noShift ? min$1(overflowAvailableWidth, maximumClippingWidth) : maximumClippingWidth;
      } else {
        const maximumClippingHeight = height - overflow.top - overflow.bottom;
        availableHeight = alignment || noShift ? min$1(overflowAvailableHeight, maximumClippingHeight) : maximumClippingHeight;
      }
      if (noShift && !alignment) {
        const xMin = max(overflow.left, 0);
        const xMax = max(overflow.right, 0);
        const yMin = max(overflow.top, 0);
        const yMax = max(overflow.bottom, 0);
        if (isYAxis) {
          availableWidth = width - 2 * (xMin !== 0 || xMax !== 0 ? xMin + xMax : max(overflow.left, overflow.right));
        } else {
          availableHeight = height - 2 * (yMin !== 0 || yMax !== 0 ? yMin + yMax : max(overflow.top, overflow.bottom));
        }
      }
      await apply({
        ...state,
        availableWidth,
        availableHeight
      });
      const nextDimensions = await platform.getDimensions(elements.floating);
      if (width !== nextDimensions.width || height !== nextDimensions.height) {
        return {
          reset: {
            rects: true
          }
        };
      }
      return {};
    }
  };
};

function getNodeName(node) {
  if (isNode(node)) {
    return (node.nodeName || '').toLowerCase();
  }
  // Mocked nodes in testing environments may not be instances of Node. By
  // returning `#document` an infinite loop won't occur.
  // https://github.com/floating-ui/floating-ui/issues/2317
  return '#document';
}
function getWindow$1(node) {
  var _node$ownerDocument;
  return (node == null || (_node$ownerDocument = node.ownerDocument) == null ? void 0 : _node$ownerDocument.defaultView) || window;
}
function getDocumentElement(node) {
  var _ref;
  return (_ref = (isNode(node) ? node.ownerDocument : node.document) || window.document) == null ? void 0 : _ref.documentElement;
}
function isNode(value) {
  return value instanceof Node || value instanceof getWindow$1(value).Node;
}
function isElement(value) {
  return value instanceof Element || value instanceof getWindow$1(value).Element;
}
function isHTMLElement(value) {
  return value instanceof HTMLElement || value instanceof getWindow$1(value).HTMLElement;
}
function isShadowRoot(value) {
  // Browsers without `ShadowRoot` support.
  if (typeof ShadowRoot === 'undefined') {
    return false;
  }
  return value instanceof ShadowRoot || value instanceof getWindow$1(value).ShadowRoot;
}
function isOverflowElement(element) {
  const {
    overflow,
    overflowX,
    overflowY,
    display
  } = getComputedStyle$1(element);
  return /auto|scroll|overlay|hidden|clip/.test(overflow + overflowY + overflowX) && !['inline', 'contents'].includes(display);
}
function isTableElement(element) {
  return ['table', 'td', 'th'].includes(getNodeName(element));
}
function isContainingBlock(element) {
  const webkit = isWebKit();
  const css = getComputedStyle$1(element);

  // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block
  return css.transform !== 'none' || css.perspective !== 'none' || (css.containerType ? css.containerType !== 'normal' : false) || !webkit && (css.backdropFilter ? css.backdropFilter !== 'none' : false) || !webkit && (css.filter ? css.filter !== 'none' : false) || ['transform', 'perspective', 'filter'].some(value => (css.willChange || '').includes(value)) || ['paint', 'layout', 'strict', 'content'].some(value => (css.contain || '').includes(value));
}
function getContainingBlock(element) {
  let currentNode = getParentNode(element);
  while (isHTMLElement(currentNode) && !isLastTraversableNode(currentNode)) {
    if (isContainingBlock(currentNode)) {
      return currentNode;
    } else {
      currentNode = getParentNode(currentNode);
    }
  }
  return null;
}
function isWebKit() {
  if (typeof CSS === 'undefined' || !CSS.supports) return false;
  return CSS.supports('-webkit-backdrop-filter', 'none');
}
function isLastTraversableNode(node) {
  return ['html', 'body', '#document'].includes(getNodeName(node));
}
function getComputedStyle$1(element) {
  return getWindow$1(element).getComputedStyle(element);
}
function getNodeScroll(element) {
  if (isElement(element)) {
    return {
      scrollLeft: element.scrollLeft,
      scrollTop: element.scrollTop
    };
  }
  return {
    scrollLeft: element.pageXOffset,
    scrollTop: element.pageYOffset
  };
}
function getParentNode(node) {
  if (getNodeName(node) === 'html') {
    return node;
  }
  const result =
  // Step into the shadow DOM of the parent of a slotted node.
  node.assignedSlot ||
  // DOM Element detected.
  node.parentNode ||
  // ShadowRoot detected.
  isShadowRoot(node) && node.host ||
  // Fallback.
  getDocumentElement(node);
  return isShadowRoot(result) ? result.host : result;
}
function getNearestOverflowAncestor(node) {
  const parentNode = getParentNode(node);
  if (isLastTraversableNode(parentNode)) {
    return node.ownerDocument ? node.ownerDocument.body : node.body;
  }
  if (isHTMLElement(parentNode) && isOverflowElement(parentNode)) {
    return parentNode;
  }
  return getNearestOverflowAncestor(parentNode);
}
function getOverflowAncestors(node, list, traverseIframes) {
  var _node$ownerDocument2;
  if (list === void 0) {
    list = [];
  }
  if (traverseIframes === void 0) {
    traverseIframes = true;
  }
  const scrollableAncestor = getNearestOverflowAncestor(node);
  const isBody = scrollableAncestor === ((_node$ownerDocument2 = node.ownerDocument) == null ? void 0 : _node$ownerDocument2.body);
  const win = getWindow$1(scrollableAncestor);
  if (isBody) {
    return list.concat(win, win.visualViewport || [], isOverflowElement(scrollableAncestor) ? scrollableAncestor : [], win.frameElement && traverseIframes ? getOverflowAncestors(win.frameElement) : []);
  }
  return list.concat(scrollableAncestor, getOverflowAncestors(scrollableAncestor, [], traverseIframes));
}

function getCssDimensions(element) {
  const css = getComputedStyle$1(element);
  // In testing environments, the `width` and `height` properties are empty
  // strings for SVG elements, returning NaN. Fallback to `0` in this case.
  let width = parseFloat(css.width) || 0;
  let height = parseFloat(css.height) || 0;
  const hasOffset = isHTMLElement(element);
  const offsetWidth = hasOffset ? element.offsetWidth : width;
  const offsetHeight = hasOffset ? element.offsetHeight : height;
  const shouldFallback = round(width) !== offsetWidth || round(height) !== offsetHeight;
  if (shouldFallback) {
    width = offsetWidth;
    height = offsetHeight;
  }
  return {
    width,
    height,
    $: shouldFallback
  };
}

function unwrapElement(element) {
  return !isElement(element) ? element.contextElement : element;
}

function getScale(element) {
  const domElement = unwrapElement(element);
  if (!isHTMLElement(domElement)) {
    return createCoords(1);
  }
  const rect = domElement.getBoundingClientRect();
  const {
    width,
    height,
    $
  } = getCssDimensions(domElement);
  let x = ($ ? round(rect.width) : rect.width) / width;
  let y = ($ ? round(rect.height) : rect.height) / height;

  // 0, NaN, or Infinity should always fallback to 1.

  if (!x || !Number.isFinite(x)) {
    x = 1;
  }
  if (!y || !Number.isFinite(y)) {
    y = 1;
  }
  return {
    x,
    y
  };
}

const noOffsets = /*#__PURE__*/createCoords(0);
function getVisualOffsets(element) {
  const win = getWindow$1(element);
  if (!isWebKit() || !win.visualViewport) {
    return noOffsets;
  }
  return {
    x: win.visualViewport.offsetLeft,
    y: win.visualViewport.offsetTop
  };
}
function shouldAddVisualOffsets(element, isFixed, floatingOffsetParent) {
  if (isFixed === void 0) {
    isFixed = false;
  }
  if (!floatingOffsetParent || isFixed && floatingOffsetParent !== getWindow$1(element)) {
    return false;
  }
  return isFixed;
}

function getBoundingClientRect(element, includeScale, isFixedStrategy, offsetParent) {
  if (includeScale === void 0) {
    includeScale = false;
  }
  if (isFixedStrategy === void 0) {
    isFixedStrategy = false;
  }
  const clientRect = element.getBoundingClientRect();
  const domElement = unwrapElement(element);
  let scale = createCoords(1);
  if (includeScale) {
    if (offsetParent) {
      if (isElement(offsetParent)) {
        scale = getScale(offsetParent);
      }
    } else {
      scale = getScale(element);
    }
  }
  const visualOffsets = shouldAddVisualOffsets(domElement, isFixedStrategy, offsetParent) ? getVisualOffsets(domElement) : createCoords(0);
  let x = (clientRect.left + visualOffsets.x) / scale.x;
  let y = (clientRect.top + visualOffsets.y) / scale.y;
  let width = clientRect.width / scale.x;
  let height = clientRect.height / scale.y;
  if (domElement) {
    const win = getWindow$1(domElement);
    const offsetWin = offsetParent && isElement(offsetParent) ? getWindow$1(offsetParent) : offsetParent;
    let currentWin = win;
    let currentIFrame = currentWin.frameElement;
    while (currentIFrame && offsetParent && offsetWin !== currentWin) {
      const iframeScale = getScale(currentIFrame);
      const iframeRect = currentIFrame.getBoundingClientRect();
      const css = getComputedStyle$1(currentIFrame);
      const left = iframeRect.left + (currentIFrame.clientLeft + parseFloat(css.paddingLeft)) * iframeScale.x;
      const top = iframeRect.top + (currentIFrame.clientTop + parseFloat(css.paddingTop)) * iframeScale.y;
      x *= iframeScale.x;
      y *= iframeScale.y;
      width *= iframeScale.x;
      height *= iframeScale.y;
      x += left;
      y += top;
      currentWin = getWindow$1(currentIFrame);
      currentIFrame = currentWin.frameElement;
    }
  }
  return rectToClientRect({
    width,
    height,
    x,
    y
  });
}

const topLayerSelectors = [':popover-open', ':modal'];
function isTopLayer(floating) {
  return topLayerSelectors.some(selector => {
    try {
      return floating.matches(selector);
    } catch (e) {
      return false;
    }
  });
}

function convertOffsetParentRelativeRectToViewportRelativeRect(_ref) {
  let {
    elements,
    rect,
    offsetParent,
    strategy
  } = _ref;
  const isFixed = strategy === 'fixed';
  const documentElement = getDocumentElement(offsetParent);
  const topLayer = elements ? isTopLayer(elements.floating) : false;
  if (offsetParent === documentElement || topLayer && isFixed) {
    return rect;
  }
  let scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  let scale = createCoords(1);
  const offsets = createCoords(0);
  const isOffsetParentAnElement = isHTMLElement(offsetParent);
  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
    if (getNodeName(offsetParent) !== 'body' || isOverflowElement(documentElement)) {
      scroll = getNodeScroll(offsetParent);
    }
    if (isHTMLElement(offsetParent)) {
      const offsetRect = getBoundingClientRect(offsetParent);
      scale = getScale(offsetParent);
      offsets.x = offsetRect.x + offsetParent.clientLeft;
      offsets.y = offsetRect.y + offsetParent.clientTop;
    }
  }
  return {
    width: rect.width * scale.x,
    height: rect.height * scale.y,
    x: rect.x * scale.x - scroll.scrollLeft * scale.x + offsets.x,
    y: rect.y * scale.y - scroll.scrollTop * scale.y + offsets.y
  };
}

function getClientRects(element) {
  return Array.from(element.getClientRects());
}

function getWindowScrollBarX(element) {
  // If <html> has a CSS width greater than the viewport, then this will be
  // incorrect for RTL.
  return getBoundingClientRect(getDocumentElement(element)).left + getNodeScroll(element).scrollLeft;
}

// Gets the entire size of the scrollable document area, even extending outside
// of the `<html>` and `<body>` rect bounds if horizontally scrollable.
function getDocumentRect(element) {
  const html = getDocumentElement(element);
  const scroll = getNodeScroll(element);
  const body = element.ownerDocument.body;
  const width = max(html.scrollWidth, html.clientWidth, body.scrollWidth, body.clientWidth);
  const height = max(html.scrollHeight, html.clientHeight, body.scrollHeight, body.clientHeight);
  let x = -scroll.scrollLeft + getWindowScrollBarX(element);
  const y = -scroll.scrollTop;
  if (getComputedStyle$1(body).direction === 'rtl') {
    x += max(html.clientWidth, body.clientWidth) - width;
  }
  return {
    width,
    height,
    x,
    y
  };
}

function getViewportRect(element, strategy) {
  const win = getWindow$1(element);
  const html = getDocumentElement(element);
  const visualViewport = win.visualViewport;
  let width = html.clientWidth;
  let height = html.clientHeight;
  let x = 0;
  let y = 0;
  if (visualViewport) {
    width = visualViewport.width;
    height = visualViewport.height;
    const visualViewportBased = isWebKit();
    if (!visualViewportBased || visualViewportBased && strategy === 'fixed') {
      x = visualViewport.offsetLeft;
      y = visualViewport.offsetTop;
    }
  }
  return {
    width,
    height,
    x,
    y
  };
}

// Returns the inner client rect, subtracting scrollbars if present.
function getInnerBoundingClientRect(element, strategy) {
  const clientRect = getBoundingClientRect(element, true, strategy === 'fixed');
  const top = clientRect.top + element.clientTop;
  const left = clientRect.left + element.clientLeft;
  const scale = isHTMLElement(element) ? getScale(element) : createCoords(1);
  const width = element.clientWidth * scale.x;
  const height = element.clientHeight * scale.y;
  const x = left * scale.x;
  const y = top * scale.y;
  return {
    width,
    height,
    x,
    y
  };
}
function getClientRectFromClippingAncestor(element, clippingAncestor, strategy) {
  let rect;
  if (clippingAncestor === 'viewport') {
    rect = getViewportRect(element, strategy);
  } else if (clippingAncestor === 'document') {
    rect = getDocumentRect(getDocumentElement(element));
  } else if (isElement(clippingAncestor)) {
    rect = getInnerBoundingClientRect(clippingAncestor, strategy);
  } else {
    const visualOffsets = getVisualOffsets(element);
    rect = {
      ...clippingAncestor,
      x: clippingAncestor.x - visualOffsets.x,
      y: clippingAncestor.y - visualOffsets.y
    };
  }
  return rectToClientRect(rect);
}
function hasFixedPositionAncestor(element, stopNode) {
  const parentNode = getParentNode(element);
  if (parentNode === stopNode || !isElement(parentNode) || isLastTraversableNode(parentNode)) {
    return false;
  }
  return getComputedStyle$1(parentNode).position === 'fixed' || hasFixedPositionAncestor(parentNode, stopNode);
}

// A "clipping ancestor" is an `overflow` element with the characteristic of
// clipping (or hiding) child elements. This returns all clipping ancestors
// of the given element up the tree.
function getClippingElementAncestors(element, cache) {
  const cachedResult = cache.get(element);
  if (cachedResult) {
    return cachedResult;
  }
  let result = getOverflowAncestors(element, [], false).filter(el => isElement(el) && getNodeName(el) !== 'body');
  let currentContainingBlockComputedStyle = null;
  const elementIsFixed = getComputedStyle$1(element).position === 'fixed';
  let currentNode = elementIsFixed ? getParentNode(element) : element;

  // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block
  while (isElement(currentNode) && !isLastTraversableNode(currentNode)) {
    const computedStyle = getComputedStyle$1(currentNode);
    const currentNodeIsContaining = isContainingBlock(currentNode);
    if (!currentNodeIsContaining && computedStyle.position === 'fixed') {
      currentContainingBlockComputedStyle = null;
    }
    const shouldDropCurrentNode = elementIsFixed ? !currentNodeIsContaining && !currentContainingBlockComputedStyle : !currentNodeIsContaining && computedStyle.position === 'static' && !!currentContainingBlockComputedStyle && ['absolute', 'fixed'].includes(currentContainingBlockComputedStyle.position) || isOverflowElement(currentNode) && !currentNodeIsContaining && hasFixedPositionAncestor(element, currentNode);
    if (shouldDropCurrentNode) {
      // Drop non-containing blocks.
      result = result.filter(ancestor => ancestor !== currentNode);
    } else {
      // Record last containing block for next iteration.
      currentContainingBlockComputedStyle = computedStyle;
    }
    currentNode = getParentNode(currentNode);
  }
  cache.set(element, result);
  return result;
}

// Gets the maximum area that the element is visible in due to any number of
// clipping ancestors.
function getClippingRect(_ref) {
  let {
    element,
    boundary,
    rootBoundary,
    strategy
  } = _ref;
  const elementClippingAncestors = boundary === 'clippingAncestors' ? getClippingElementAncestors(element, this._c) : [].concat(boundary);
  const clippingAncestors = [...elementClippingAncestors, rootBoundary];
  const firstClippingAncestor = clippingAncestors[0];
  const clippingRect = clippingAncestors.reduce((accRect, clippingAncestor) => {
    const rect = getClientRectFromClippingAncestor(element, clippingAncestor, strategy);
    accRect.top = max(rect.top, accRect.top);
    accRect.right = min$1(rect.right, accRect.right);
    accRect.bottom = min$1(rect.bottom, accRect.bottom);
    accRect.left = max(rect.left, accRect.left);
    return accRect;
  }, getClientRectFromClippingAncestor(element, firstClippingAncestor, strategy));
  return {
    width: clippingRect.right - clippingRect.left,
    height: clippingRect.bottom - clippingRect.top,
    x: clippingRect.left,
    y: clippingRect.top
  };
}

function getDimensions(element) {
  const {
    width,
    height
  } = getCssDimensions(element);
  return {
    width,
    height
  };
}

function getRectRelativeToOffsetParent(element, offsetParent, strategy) {
  const isOffsetParentAnElement = isHTMLElement(offsetParent);
  const documentElement = getDocumentElement(offsetParent);
  const isFixed = strategy === 'fixed';
  const rect = getBoundingClientRect(element, true, isFixed, offsetParent);
  let scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  const offsets = createCoords(0);
  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
    if (getNodeName(offsetParent) !== 'body' || isOverflowElement(documentElement)) {
      scroll = getNodeScroll(offsetParent);
    }
    if (isOffsetParentAnElement) {
      const offsetRect = getBoundingClientRect(offsetParent, true, isFixed, offsetParent);
      offsets.x = offsetRect.x + offsetParent.clientLeft;
      offsets.y = offsetRect.y + offsetParent.clientTop;
    } else if (documentElement) {
      offsets.x = getWindowScrollBarX(documentElement);
    }
  }
  const x = rect.left + scroll.scrollLeft - offsets.x;
  const y = rect.top + scroll.scrollTop - offsets.y;
  return {
    x,
    y,
    width: rect.width,
    height: rect.height
  };
}

function getTrueOffsetParent(element, polyfill) {
  if (!isHTMLElement(element) || getComputedStyle$1(element).position === 'fixed') {
    return null;
  }
  if (polyfill) {
    return polyfill(element);
  }
  return element.offsetParent;
}

// Gets the closest ancestor positioned element. Handles some edge cases,
// such as table ancestors and cross browser bugs.
function getOffsetParent(element, polyfill) {
  const window = getWindow$1(element);
  if (!isHTMLElement(element) || isTopLayer(element)) {
    return window;
  }
  let offsetParent = getTrueOffsetParent(element, polyfill);
  while (offsetParent && isTableElement(offsetParent) && getComputedStyle$1(offsetParent).position === 'static') {
    offsetParent = getTrueOffsetParent(offsetParent, polyfill);
  }
  if (offsetParent && (getNodeName(offsetParent) === 'html' || getNodeName(offsetParent) === 'body' && getComputedStyle$1(offsetParent).position === 'static' && !isContainingBlock(offsetParent))) {
    return window;
  }
  return offsetParent || getContainingBlock(element) || window;
}

const getElementRects = async function (data) {
  const getOffsetParentFn = this.getOffsetParent || getOffsetParent;
  const getDimensionsFn = this.getDimensions;
  return {
    reference: getRectRelativeToOffsetParent(data.reference, await getOffsetParentFn(data.floating), data.strategy),
    floating: {
      x: 0,
      y: 0,
      ...(await getDimensionsFn(data.floating))
    }
  };
};

function isRTL(element) {
  return getComputedStyle$1(element).direction === 'rtl';
}

const platform$1 = {
  convertOffsetParentRelativeRectToViewportRelativeRect,
  getDocumentElement,
  getClippingRect,
  getOffsetParent,
  getElementRects,
  getClientRects,
  getDimensions,
  getScale,
  isElement,
  isRTL
};

// https://samthor.au/2021/observing-dom/
function observeMove(element, onMove) {
  let io = null;
  let timeoutId;
  const root = getDocumentElement(element);
  function cleanup() {
    var _io;
    clearTimeout(timeoutId);
    (_io = io) == null || _io.disconnect();
    io = null;
  }
  function refresh(skip, threshold) {
    if (skip === void 0) {
      skip = false;
    }
    if (threshold === void 0) {
      threshold = 1;
    }
    cleanup();
    const {
      left,
      top,
      width,
      height
    } = element.getBoundingClientRect();
    if (!skip) {
      onMove();
    }
    if (!width || !height) {
      return;
    }
    const insetTop = floor$2(top);
    const insetRight = floor$2(root.clientWidth - (left + width));
    const insetBottom = floor$2(root.clientHeight - (top + height));
    const insetLeft = floor$2(left);
    const rootMargin = -insetTop + "px " + -insetRight + "px " + -insetBottom + "px " + -insetLeft + "px";
    const options = {
      rootMargin,
      threshold: max(0, min$1(1, threshold)) || 1
    };
    let isFirstUpdate = true;
    function handleObserve(entries) {
      const ratio = entries[0].intersectionRatio;
      if (ratio !== threshold) {
        if (!isFirstUpdate) {
          return refresh();
        }
        if (!ratio) {
          timeoutId = setTimeout(() => {
            refresh(false, 1e-7);
          }, 100);
        } else {
          refresh(false, ratio);
        }
      }
      isFirstUpdate = false;
    }

    // Older browsers don't support a `document` as the root and will throw an
    // error.
    try {
      io = new IntersectionObserver(handleObserve, {
        ...options,
        // Handle <iframe>s
        root: root.ownerDocument
      });
    } catch (e) {
      io = new IntersectionObserver(handleObserve, options);
    }
    io.observe(element);
  }
  refresh(true);
  return cleanup;
}

/**
 * Automatically updates the position of the floating element when necessary.
 * Should only be called when the floating element is mounted on the DOM or
 * visible on the screen.
 * @returns cleanup function that should be invoked when the floating element is
 * removed from the DOM or hidden from the screen.
 * @see https://floating-ui.com/docs/autoUpdate
 */
function autoUpdate(reference, floating, update, options) {
  if (opt