export declare function bind(controller: HTMLElement): void;
export declare function bindShadow(root: ShadowRoot): void;
/**
 * Set up observer that will make sure any actions that are dynamically
 * injected into `el` will be bound to it's controller.
 *
 * This returns a Subscription object which you can call `unsubscribe()` on to
 * stop further live updates.
 */
export declare function listenForBind(el?: Node): Subscription;
interface Subscription {
    closed: boolean;
    unsubscribe(): void;
}
export {};
//# sourceMappingURL=bind.d.ts.map