# Installation
> `npm install --save @types/co-body`

# Summary
This package contains type definitions for co-body (https://github.com/cojs/co-body).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/co-body.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/co-body/index.d.ts)
````ts
/// <reference types="node"/>

import * as http from "http";
import * as qs from "qs";

declare namespace CoBody {
    type Context = http.IncomingMessage | { req: http.IncomingMessage };

    interface Parse {
        /**
         * @async
         */
        (context: Context, options?: Options): Promise<any>;
        /**
         * @async
         */
        text: (context: Context, options?: Options) => Promise<any>;
        /**
         * @async
         */
        form: (context: Context, options?: Options) => Promise<any>;
        /**
         * @async
         */
        json: (context: Context, options?: Options) => Promise<any>;
    }

    interface Options {
        limit?: number | string | undefined;
        strict?: boolean | undefined;
        queryString?: qs.IParseOptions | undefined;
        jsonTypes?: string[] | undefined;
        returnRawBody?: boolean | undefined;
        formTypes?: string[] | undefined;
        textTypes?: string[] | undefined;
        encoding?: string | undefined;
        length?: number | undefined;
    }
}

declare var CoBody: CoBody.Parse;
export = CoBody;

````

### Additional Details
 * Last updated: Mon, 06 Nov 2023 22:41:05 GMT
 * Dependencies: [@types/node](https://npmjs.com/package/@types/node), [@types/qs](https://npmjs.com/package/@types/qs)

# Credits
These definitions were written by [Joshua DeVinney](https://github.com/geoffreak).
