"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.summaryReporter = void 0;
const reportTestsErrors_js_1 = require("./reportTestsErrors.js");
const reportTestFileErrors_js_1 = require("./reportTestFileErrors.js");
const reportBrowserLogs_js_1 = require("./reportBrowserLogs.js");
const color = ([x, y]) => (z) => `\x1b[${x}m${z}\x1b[${y}m${reset}`;
const reset = `\x1b[0m\x1b[0m`;
const green = color([32, 89]);
const red = color([31, 89]);
const dim = color([2, 0]);
/** Test reporter that summarizes all test for a given run */
function summaryReporter(opts) {
    const { flatten = false } = opts !== null && opts !== void 0 ? opts : {};
    let args;
    let favoriteBrowser;
    function log(logger, name, passed, skipped, prefix = '  ', postfix = '') {
        const sign = skipped ? dim('-') : passed ? green('✓') : red('𐄂');
        if (flatten)
            logger.log(`${sign} ${name}${postfix}`);
        else
            logger.log(`${prefix}  ${sign} ${name}`);
    }
    function logResults(logger, results, prefix, browser) {
        var _a, _b;
        const browserName = (browser === null || browser === void 0 ? void 0 : browser.name) ? ` ${dim(`[${browser.name}]`)}` : '';
        for (const result of (_a = results === null || results === void 0 ? void 0 : results.tests) !== null && _a !== void 0 ? _a : []) {
            log(logger, result.name, result.passed, result.skipped, prefix, browserName);
        }
        for (const suite of (_b = results === null || results === void 0 ? void 0 : results.suites) !== null && _b !== void 0 ? _b : []) {
            logSuite(logger, suite, prefix, browser);
        }
    }
    function logSuite(logger, suite, parent, browser) {
        const browserName = (browser === null || browser === void 0 ? void 0 : browser.name) ? ` ${dim(`[${browser.name}]`)}` : '';
        let pref = parent ? `${parent} ` : ' ';
        if (flatten)
            pref += `${suite.name}`;
        else
            logger.log(`${pref}${suite.name}${browserName}`);
        logResults(logger, suite, pref, browser);
    }
    let cachedLogger;
    return {
        start(_args) {
            var _a;
            args = _args;
            favoriteBrowser =
                (_a = args.browserNames.find(name => {
                    const n = name.toLowerCase();
                    return n.includes('chrome') || n.includes('chromium') || n.includes('firefox');
                })) !== null && _a !== void 0 ? _a : args.browserNames[0];
        },
        reportTestFileResults({ logger, sessionsForTestFile }) {
            cachedLogger = logger;
            for (const session of sessionsForTestFile) {
                logResults(logger, session.testResults, '', session.browser);
                logger.log('');
            }
            (0, reportBrowserLogs_js_1.reportBrowserLogs)(logger, sessionsForTestFile);
        },
        onTestRunFinished({ sessions }) {
            const failedSessions = sessions.filter(s => !s.passed);
            if (failedSessions.length > 0) {
                cachedLogger.log('\n\nErrors Reported in Tests:\n\n');
                (0, reportTestsErrors_js_1.reportTestsErrors)(cachedLogger, args.browserNames, favoriteBrowser, failedSessions);
                (0, reportTestFileErrors_js_1.reportTestFileErrors)(cachedLogger, args.browserNames, favoriteBrowser, failedSessions, true);
            }
        },
    };
}
exports.summaryReporter = summaryReporter;
//# sourceMappingURL=summaryReporter.js.map