import path from 'path'
import {build as buildLib} from './build/webpack.js'
import {startServer} from './build/webpackServer.js'

var options = {init:false,build:false}

const getOptions = function(option){
    return options
}

const init = function(option){
    if (option) options = option
    options.init = true
    return true
}

const start = async function(compiler){
    if(!options.build){
        console.error("Need first build!");
        return false;
    }

    if(!options.path){
        console.error("Need first init path in options!");
        return false;
    }

    let serverConfig = {
        
        static: {
            //directory: path.join(options.path.public,'assets'),
            //publicPath: '/assets',
            directory: options.path.public,
            watch: false
          },
        compress: true,
        port: options.port,
        allowedHosts: ['cryptoemergency.com','crypto-emergency.com','127.0.0.1','localhost'],
        historyApiFallback: true,
        host: '0.0.0.0',
        hot: false,
        open: false,
        client: {
            logging: 'none',
            overlay: {
                errors: false,
                warnings: false,
            },
            progress: false,
        },
        mode:(options.mode || "production" || "development"),
      };

    const server = await startServer(compiler,serverConfig)
    if (!server){
        return false;
    }

    console.log("Server start successfully!");
    return server
}

const build = async function(){
    if(!options.init){
        console.error("Need first init options!");
        return false;
    }

    if(!options.path){
        console.error("Need first init path in options!");
        return false;
    }
    
    let webConfig = {
    entry: options.path.src,
    output: {
    path: options.path.public,
   filename: options.path.fileName,
   
    },
    mode:(options.mode || "production" || "development"),
    stats: 'none',
    infrastructureLogging: {
        level: 'error',
      },
      devServer: {
        noInfo: true,
        clientLogLevel: "none",
        overlay: false,
        client: "none",
      },
      module: {
        rules: [
          {
            test: /\.js$/,
            exclude: /node_modules/,
            use: {
              loader: "babel-loader"
            },
          }
        ]
      }
  };

  const compiler = await buildLib(webConfig)
  if (!compiler){
    return false;
  }
  console.log("Build successfully");
  options.build=true
  return compiler;
}



const forExport = {}
forExport.init = init
forExport.getOptions = getOptions
forExport.build = build
forExport.start = start

export default forExport