import { ColorInput, HSLObjectGeneric, HEXObject, RGBObject, HSLObject, CMYKObject } from './@types';
import { Harmony, Mix } from './constants';
export declare class ColorTranslator {
    constructor(color: ColorInput);
    private rgb;
    private hsl;
    private cmyk;
    private updateRGB;
    private updateRGBFromCMYK;
    private updateHSL;
    private updateCMYK;
    private updateRGBAndCMYK;
    private updateHSLAndCMYK;
    private updateRGBAndHSL;
    setH(h: number): ColorTranslator;
    setS(s: number): ColorTranslator;
    setL(l: number): ColorTranslator;
    setR(r: number): ColorTranslator;
    setG(g: number): ColorTranslator;
    setB(b: number): ColorTranslator;
    setA(a: number): ColorTranslator;
    setC(c: number): ColorTranslator;
    setM(m: number): ColorTranslator;
    setY(y: number): ColorTranslator;
    setK(k: number): ColorTranslator;
    get H(): number;
    get S(): number;
    get L(): number;
    get R(): number;
    get G(): number;
    get B(): number;
    get A(): number;
    get C(): number;
    get M(): number;
    get Y(): number;
    get K(): number;
    get HEXObject(): HEXObject;
    get HEXAObject(): HEXObject;
    get RGBObject(): RGBObject;
    get RGBAObject(): RGBObject;
    get HSLObject(): HSLObject;
    get HSLAObject(): HSLObject;
    get CMYKObject(): CMYKObject;
    get HEX(): string;
    get HEXA(): string;
    get RGB(): string;
    get RGBA(): string;
    get HSL(): string;
    get HSLA(): string;
    get CMYK(): string;
    static toHEX(color: ColorInput): string;
    static toHEX(color: ColorInput, css: true): string;
    static toHEX(color: ColorInput, css: false): HEXObject;
    static toHEXA(color: ColorInput): string;
    static toHEXA(color: ColorInput, css: true): string;
    static toHEXA(color: ColorInput, css: false): HEXObject;
    static toRGB(color: ColorInput): string;
    static toRGB(color: ColorInput, css: true): string;
    static toRGB(color: ColorInput, css: false): RGBObject;
    static toRGBA(color: ColorInput): string;
    static toRGBA(color: ColorInput, css: true): string;
    static toRGBA(color: ColorInput, css: false): RGBObject;
    static toHSL(color: ColorInput): string;
    static toHSL(color: ColorInput, css: true): string;
    static toHSL(color: ColorInput, css: false): HSLObject;
    static toHSLA(color: ColorInput): string;
    static toHSLA(color: ColorInput, css: true): string;
    static toHSLA(color: ColorInput, css: false): HSLObject;
    static toCMYK(color: ColorInput): string;
    static toCMYK(color: ColorInput, css: true): string;
    static toCMYK(color: ColorInput, css: false): CMYKObject;
    static getBlendHEX(from: ColorInput, to: ColorInput, steps?: number): string[];
    static getBlendHEX(from: ColorInput, to: ColorInput, steps: number, css: true): string[];
    static getBlendHEX(from: ColorInput, to: ColorInput, steps: number, css: false): HEXObject[];
    static getBlendHEXA(from: ColorInput, to: ColorInput, steps?: number): string[];
    static getBlendHEXA(from: ColorInput, to: ColorInput, steps: number, css: true): string[];
    static getBlendHEXA(from: ColorInput, to: ColorInput, steps: number, css: false): HEXObject[];
    static getBlendRGB(from: ColorInput, to: ColorInput, steps?: number): string[];
    static getBlendRGB(from: ColorInput, to: ColorInput, steps: number, css: true): string[];
    static getBlendRGB(from: ColorInput, to: ColorInput, steps: number, css: false): RGBObject[];
    static getBlendRGBA(from: ColorInput, to: ColorInput, steps: number): string[];
    static getBlendRGBA(from: ColorInput, to: ColorInput, steps: number, css: true): string[];
    static getBlendRGBA(from: ColorInput, to: ColorInput, steps: number, css: false): RGBObject[];
    static getBlendHSL(from: ColorInput, to: ColorInput, steps?: number): string[];
    static getBlendHSL(from: ColorInput, to: ColorInput, steps: number, css: true): string[];
    static getBlendHSL(from: ColorInput, to: ColorInput, steps: number, css: false): HSLObject[];
    static getBlendHSLA(from: ColorInput, to: ColorInput, steps?: number): string[];
    static getBlendHSLA(from: ColorInput, to: ColorInput, steps: number, css: true): string[];
    static getBlendHSLA(from: ColorInput, to: ColorInput, steps: number, css: false): HSLObject[];
    static getMixHEX(colors: ColorInput[]): string;
    static getMixHEX(colors: ColorInput[], mode: Mix): string;
    static getMixHEX(colors: ColorInput[], mode: Mix, css: true): string;
    static getMixHEX(colors: ColorInput[], mode: Mix, css: false): HEXObject;
    static getMixHEXA(colors: ColorInput[]): string;
    static getMixHEXA(colors: ColorInput[], mode: Mix): string;
    static getMixHEXA(colors: ColorInput[], mode: Mix, css: true): string;
    static getMixHEXA(colors: ColorInput[], mode: Mix, css: false): HEXObject;
    static getMixRGB(colors: ColorInput[]): string;
    static getMixRGB(colors: ColorInput[], mode: Mix): string;
    static getMixRGB(colors: ColorInput[], mode: Mix, css: true): string;
    static getMixRGB(colors: ColorInput[], mode: Mix, css: false): RGBObject;
    static getMixRGBA(colors: ColorInput[]): string;
    static getMixRGBA(colors: ColorInput[], mode: Mix): string;
    static getMixRGBA(colors: ColorInput[], mode: Mix, css: true): string;
    static getMixRGBA(colors: ColorInput[], mode: Mix, css: false): RGBObject;
    static getMixHSL(colors: ColorInput[]): string;
    static getMixHSL(colors: ColorInput[], mode: Mix): string;
    static getMixHSL(colors: ColorInput[], mode: Mix, css: true): string;
    static getMixHSL(colors: ColorInput[], mode: Mix, css: false): HSLObject;
    static getMixHSLA(colors: ColorInput[]): string;
    static getMixHSLA(colors: ColorInput[], mode: Mix): string;
    static getMixHSLA(colors: ColorInput[], mode: Mix, css: true): string;
    static getMixHSLA(colors: ColorInput[], mode: Mix, css: false): HSLObject;
    static getShades(color: string, shades: number): string[];
    static getShades(color: HEXObject, shades: number): HEXObject[];
    static getShades(color: RGBObject, shades: number): RGBObject[];
    static getShades(color: HSLObjectGeneric, shades: number): HSLObject[];
    static getTints(color: string, tints: number): string[];
    static getTints(color: HEXObject, tints: number): HEXObject[];
    static getTints(color: RGBObject, tints: number): RGBObject[];
    static getTints(color: HSLObjectGeneric, tints: number): HSLObject[];
    static getHarmony(color: string, armony?: Harmony, mode?: Mix): string[];
    static getHarmony(color: HEXObject, armony?: Harmony, mode?: Mix): HEXObject[];
    static getHarmony(color: RGBObject, armony?: Harmony, mode?: Mix): RGBObject[];
    static getHarmony(color: HSLObjectGeneric, armony?: Harmony, mode?: Mix): HSLObject[];
}
export { Harmony, Mix, HEXObject, RGBObject, HSLObject, CMYKObject };
