import { ag as EGW_AO_FLAG_IS_CONTAINER, af as egwBitIsSet, ai as EGW_AO_STATE_SELECTED } from '../../chunks/egw_json-39123901.js';
import { ah as et2_inputWidget, C as ClassWithAttributes, a as egw, ai as et2_dynheight, g as et2_createWidget, c as Et2Dialog, _ as et2_IInput, z as egw_getAppObjectManager, m as egw_getObjectManager, aj as egwActionObjectInterface, q as et2_register_widget, E as EgwApp, X as egw_getFramework, b as etemplate2, h as et2_nextmatch } from '../../chunks/etemplate2-5d80300c.js';
import '../../vendor/npm-asset/dhtmlx-gantt/codebase/dhtmlxgantt.js';
import '../../vendor/npm-asset/dhtmlx-gantt/codebase/ext/dhtmlxgantt_marker.js';
import '../../vendor/bower-asset/jquery/dist/jquery.min.js';
import '../../vendor/bower-asset/cropper/dist/cropper.min.js';
import '../../vendor/tinymce/tinymce/tinymce.min.js';

function _defineProperty$1(e, r, t) { return (r = _toPropertyKey$1(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$1(t) { var i = _toPrimitive$1(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$1(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/* import dhtml-gantt, need to use commented out import statement, as egw:uses is not considered, if we have import(s)
import "../../vendor/npm-asset/dhtmlx-gantt/codebase/dhtmlxgantt.js";
import "../../vendor/npm-asset/dhtmlx-gantt/codebase/ext/dhtmlxgantt_marker.js";
 */
/**
 * Gantt chart
 *
 * The gantt widget allows children, which are displayed as a header.  Any child input
 * widgets are bound as live filters on existing data.  The filter is done based on
 * widget ID, such that the value of the widget must match that attribute in the task
 * or the task will not be displayed.  There is special handling for
 * date widgets with IDs 'start_date' and 'end_date' to filter as an inclusive range
 * instead of simple equality.
 *
 * @see http://docs.dhtmlx.com/gantt/index.html
 * @augments et2_valueWidget
 */
class et2_gantt extends et2_inputWidget {
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_gantt._attributes, _child || {}));

    // DOM Nodes
    // Common configuration for Egroupware/eTemplate
    _defineProperty$1(this, "gantt_config", {
      // Gantt takes a different format of date format, all the placeholders are prefixed with '%'
      api_date: '%Y-%n-%d %H:%i:%s',
      date_format: '%Y-%n-%d %H:%i:%s',
      time_picker: '%Y-%n-%d %H:%i:%s',
      // Duration is a unitless field.  This is the unit.
      duration_unit: 'minute',
      duration_step: 1,
      show_progress: true,
      order_branch: false,
      min_column_width: 30,
      min_grid_column_width: 30,
      grid_width: 300,
      task_height: 25,
      //		fit_tasks: true,
      //		autosize: '',
      // Date rounding happens either way, but this way it rounds to the displayed grid resolution
      // Also avoids a potential infinite loop thanks to how the dates are rounded with false
      round_dnd_dates: false,
      // Round resolution
      time_step: parseInt('' + this.egw().preference('interval', 'calendar')) || 15,
      min_duration: 1 * 60 * 1000,
      // 1 minute in ms

      columns: [{
        name: "text",
        label: egw.lang('Title'),
        tree: true,
        width: '*'
      }],
      autofit: true,
      autosize: "y"
    });
    // Gantt will handle most zooming, here we configure the zoom levels & headings
    _defineProperty$1(this, "zoomConfig", {
      levels: [{
        name: "minutes",
        min_column_width: 50,
        scales: [{
          unit: "day",
          step: 1,
          format: "%F %d"
        }, {
          unit: "minute",
          step: parseInt("" + this.egw().preference('interval', 'calendar')) || 15,
          format: this.egw().preference('timeformat') == '24' ? "%G:%i" : "%g:%i"
        }]
      }, {
        name: "day",
        min_column_width: 50,
        scales: [{
          unit: "day",
          step: 1,
          format: "%F %d"
        }, {
          unit: "hour",
          format: this.egw().preference('timeformat') == '24' ? "%G:%i" : "%g:%i"
        }]
      }, {
        name: "week",
        min_column_width: 80,
        scales: [{
          unit: "month",
          format: "%M"
        }, {
          unit: "day",
          step: 1,
          format: "%d"
        }]
      }, {
        name: "month",
        scale_height: 50,
        min_column_width: 120,
        scales: [{
          unit: "month",
          format: "%F, %Y"
        }, {
          unit: "week",
          format: "#%W"
        }]
      }, {
        name: "quarter",
        height: 50,
        min_column_width: 60,
        scales: [{
          unit: "year",
          step: 1,
          format: "%Y"
        }, {
          unit: "month",
          step: 1,
          format: "%M"
        }]
      }, {
        name: "year",
        scale_height: 50,
        min_column_width: 30,
        scales: [{
          unit: "year",
          step: 1,
          format: "%Y"
        }, {
          unit: "quarter",
          step: 1,
          format: function format(date) {
            var dateToStr = gantt.date.date_to_str("%M");
            var endDate = gantt.date.add(gantt.date.add(date, 3, "month"), -1, "day");
            return dateToStr(date) + " - " + dateToStr(endDate);
          }
        }]
      }]
    });
    // Gantt instance, except they changed it to static
    _defineProperty$1(this, "gantt", null);
    _defineProperty$1(this, "filters", void 0);
    _defineProperty$1(this, "gantt_node", void 0);
    _defineProperty$1(this, "htmlNode", void 0);
    _defineProperty$1(this, "dynheight", void 0);
    _defineProperty$1(this, "selectPopup", void 0);
    _defineProperty$1(this, "value", void 0);
    _defineProperty$1(this, "gantt_loading", false);
    _defineProperty$1(this, "stored_state", void 0);
    this.filters = jQuery(document.createElement("div")).addClass('et2_gantt_header');
    this.gantt_node = jQuery('<div style="width:100%;height:100%" id="gantt_here"></div>');
    this.htmlNode = jQuery(document.createElement("div")).css('height', this.options.height).addClass('et2_gantt');
    this.htmlNode.prepend(this.filters);
    this.htmlNode.append(this.gantt_node);

    // Create the dynheight component which dynamically scales the inner
    // container.
    this.dynheight = new et2_dynheight(this.getParent().getDOMNode(this.getParent()) || this.getInstanceManager().DOMContainer, this.gantt_node, 300);
    this.setDOMNode(this.htmlNode[0]);
  }
  destroy() {
    if (this.gantt !== null) {
      // Unselect task before removing it, or we get errors later if it is accessed
      this.gantt.unselectTask();
      this.gantt.detachAllEvents();
      this.gantt._onLinkIdChange = null;
      this.gantt._onTaskIdChange = null;
      this.gantt.clearAll();
      this.gantt.$container = null;
      this.gantt = null;
    }

    // Destroy dynamic full-height
    if (this.dynheight) this.dynheight.destroy();
    this.dynheight = null;
    super.destroy();
    this.htmlNode.remove();
    this.htmlNode = null;
    this.gantt_node = null;
  }
  doLoadingFinished() {
    super.doLoadingFinished();
    if (this.gantt != null) {
      return false;
    }
    var config = jQuery.extend({}, gantt.config, this.gantt_config);

    // Set initial values for start and end, if those filters exist
    var start_date = this.getWidgetById('start_date');
    var end_date = this.getWidgetById('end_date');
    if (start_date) {
      config.start_date = start_date.getValue() ? new Date(start_date.getValue()) : null;
    }
    if (end_date) {
      config.end_date = end_date.getValue() ? new Date(end_date.getValue()) : null;
    }
    if (this.options.duration_unit) {
      config.duration_unit = this.options.duration_unit;
    }

    // Initialize chart
    this.gantt = gantt;
    this.gantt.config = config;
    this.gantt.ext.zoom.init(this.zoomConfig);
    this.gantt.init("gantt_here");

    // Update start & end dates with chart values for consistency
    if (start_date && this.options.value.data && this.options.value.data.length) {
      start_date.set_value(this.gantt.getState().min_date);
    }
    if (end_date && this.options.value.data && this.options.value.data.length) {
      end_date.set_value(this.gantt.getState().max_date);
    }

    // Bind some events to make things nice and et2
    this._bindGanttEvents();

    // Bind filters
    this._bindChildren();
    return true;
  }
  _createNamespace() {
    return true;
  }
  getDOMNode(_sender) {
    // Return filter container for children
    if (_sender != this && this._children.indexOf(_sender) != -1) {
      return this.filters[0];
    }

    // Normally simply return the main div
    return super.getDOMNode(_sender);
  }

  /**
   * Implement the et2_IResizable interface to resize
   */
  resize() {
    if (this.dynheight) {
      this.dynheight.update(function (w, h) {
        if (this.gantt) {
          //				this.gantt.setSizes();
        }
      }, this);
    } else if (this.gantt) {
      this.gantt.setSizes();
    }
  }

  /**
   * Changes the units for duration
   * @param {string} duration_unit One of minute, hour, week, year
   */
  set_duration_unit(duration_unit) {
    this.options.duration_unit = duration_unit;
    if (this.gantt && this.gantt.config.duration_unit != duration_unit) {
      this.gantt.config.duration_unit = duration_unit;
      // Clear the end date, or previous end date may break time scale
      this.gantt.config.end_date = null;
      this.gantt.refreshData();
    }
  }

  /**
   * Set the columns for the grid (left) portion
   *
   * @param {Object[]} columns - A list of columns
   *	columns[].name The column's ID
   *	columns[].label The title for the column header
   *	columns[].width Width of the column
   *
   * @see http://docs.dhtmlx.com/gantt/api__gantt_columns_config.html for full options
   */
  set_columns(columns) {
    this.options.columns = columns;
    var displayed_columns = [];
    var gantt_widget = this;

    // Make sure there's enough room for them all
    var width = 0;
    for (var col in columns) {
      // Preserve original width, gantt will resize column to fit
      if (!columns[col]._width) {
        columns[col]._width = columns[col].width;
      }
      columns[col].width = columns[col]._width;
      if (!columns[col].template) {
        // Use an et2 widget to render the column value, if one was provided
        // otherwise, just display the value
        columns[col].template = function (task) {
          var value = typeof task[this.name] == 'undefined' || task[this.name] == null ? '' : task[this.name];

          // No value, but there's a project title.  Try reading the project value.
          if (!value && this.name.indexOf('pe_') == 0 && task.pm_title) {
            var pm_col = this.name.replace('pe_', 'pm_');
            value = typeof task[pm_col] == 'undefined' || task[pm_col] == null ? '' : task[pm_col];
          }
          if (this.widget && typeof this.widget == 'string') {
            var attrs = jQuery.extend({
              readonly: true
            }, this.widget_attributes || {});
            this.widget = et2_createWidget(this.widget, attrs, gantt_widget);
          }
          if (this.widget) {
            value = typeof value.toJSON == "function" ? value.toJSON() : value.toString();
            value = "<" + this.widget.localName + ' value="' + value + '"></' + this.widget.localName + ">";
          }
          return '<div class="gantt_column_' + this.name + '">' + value + '</div>';
        };
      }

      // Actual hiding is available in the pro version of gantt chart
      if (!columns[col].hide) {
        displayed_columns.push(columns[col]);
        width += parseInt(columns[col]._width) || 300;
      }
    }
    // Add in add column
    displayed_columns.push({
      name: 'add',
      width: 26,
      min_width: 26,
      max_width: 26,
      _width: 26
    });
    width += 26;
    this._set_grid_width(width);
    this.gantt_config.columns = displayed_columns;
    if (this.gantt == null) return;
    this.gantt.config.columns = displayed_columns;
    this.gantt.render();
  }

  /**
   * Sets the data to be displayed in the gantt chart.
   *
   * Data is a JSON object with 'data' and 'links', both of which are arrays.
   * {
   *		data:[
   *			{id:1, text:"Project #1", start_date:"01-04-2013", duration:18},
   *			{id:2, text:"Task #1", start_date:"02-04-2013", duration:8, parent:1},
   *			{id:3, text:"Task #2", start_date:"11-04-2013", duration:8, parent:1}
   *		],
   *		links:[
   *			{id:1, source:1, target:2, type:"1"},
   *			{id:2, source:2, target:3, type:"0"}
   *		]
   *		// Optional:
   *		zoom: 1-4,
   *
   * };
   * Any additional data can be included and used, but the above is the minimum
   * required data.
   *
   * @see http://docs.dhtmlx.com/gantt/desktop__loading.html
   *
   * @param {type} value
   */
  set_value(value) {
    if (this.gantt == null) return false;

    // Unselect task before removing it, or we get errors later if it is accessed
    this.gantt.unselectTask();

    // Clear previous value
    this.gantt.clearAll();

    // Clear the end date, or previous end date may break time scale
    this.gantt.config.end_date = null;
    if (value.duration_unit) {
      this.set_duration_unit(value.duration_unit);
    }
    this.gantt.showCover();

    // Wait until zoom is done before continuing so timescales are done
    var gantt_widget = this;
    var zoom_wait = this.gantt.ext.zoom.attachEvent('onAfterZoom', function () {
      this.detachEvent(zoom_wait);

      // Ensure proper format, no extras
      var safe_value = {
        data: value.data || [],
        links: value.links || []
      };
      gantt.config.start_date = value.start_date || null;
      gantt.config.end_date = value.end_date || null;
      gantt.parse(safe_value);
      gantt_widget._apply_sort();
      gantt_widget.gantt_loading = false;

      // Once we force the start / end date (below), gantt won't recalculate
      // them if the user clears the date, so we store them and use them
      // if the user clears the date.
      gantt_widget.stored_state = jQuery.extend({}, gantt.getState());

      // Doing this again here forces the gantt chart to trim the tasks
      // to fit the date range, rather than drawing all the dates out
      // to the start date.
      // No speed improvement, but it makes a lot more sense in the UI

      var range = gantt.attachEvent('onGanttRender', function () {
        this.detachEvent(range);

        // Auto-zoom
        gantt_widget.set_zoom();
        gantt.hideCover();
      });
    });

    // Set zoom to max, in case data spans a large time
    this.set_zoom(value.zoom || 5);
    var markerId = this.gantt.addMarker({
      start_date: new Date(),
      //a Date object that sets the marker's date
      css: "today",
      //a CSS class applied to the marker
      text: this.egw().lang("Today") //the marker title
    });

    // This render re-sizes gantt to work at highest zoom
    this.gantt.render();
  }
  /**
   * getValue has to return the value of the input widget
   */
  getValue() {
    return jQuery.extend({}, this.value, {
      zoom: this.options.zoom,
      duration_unit: this.gantt.config.duration_unit
    });
  }

  /**
   * Refresh given tasks for specified change
   *
   * Change type parameters allows for quicker refresh then complete server side reload:
   * - update: request just modified data for given tasks
   * - edit:  same as edit
   * - delete: just delete the given tasks clientside (no server interaction neccessary)
   * - add: requires full reload
   *
   * @param {string[]|string} _task_ids tasks to refresh
   * @param {?string} _type "update", "edit", "delete" or "add"
   *
   * @return Promise
   *
   * @see jsapi.egw_refresh()
   * @fires refresh from the widget itself
   */
  refresh(_task_ids, _type) {
    // Framework trying to refresh, but gantt not fully initialized
    if (!this.gantt || !this.gantt_node || !this.options.autoload) return;

    // Sanitize arguments
    if (typeof _type == 'undefined') _type = 'edit';
    if (typeof _task_ids == 'string' || typeof _task_ids == 'number') _task_ids = [_task_ids];
    if (typeof _task_ids == "undefined" || _task_ids === null) {
      // Use the root
      _task_ids = this.gantt.$data.tasksStore._branches[0];
    }
    var promises = [];
    id_loop: for (var i = 0; i < _task_ids.length; i++) {
      var update_id = _task_ids[i];
      var task = this.gantt.getTask(update_id);
      if (!task && update_id) {
        task = this.gantt.getTaskBy(function (task) {
          var app_id = update_id.split('::');
          return task.pe_app === app_id[0] && task.pe_app_id === app_id[1];
        });
        if (task.length) {
          // Get the parent project, not the actual element since we can
          // only update projects with autoload
          task = task[0];
          update_id = task.parent;
        }
      }
      if (!task) {
        _type = null;
      }
      switch (_type) {
        case "edit":
        case "update":
          var value = this.getInstanceManager().getValues(this.getInstanceManager().widgetContainer);
          this.gantt.showCover();
          promises.push(this.egw().json(this.options.autoload, [update_id, value, task.parent || false], function (data) {
            this.gantt.parse(data);
            this._apply_sort();
          }, this, true, this).sendRequest());
          break;
        case "delete":
          this.gantt.deleteTask(update_id);
          break;
        case "add":
          var data = this.egw().dataGetUIDdata(update_id) && data.data;
          if (data) {
            this.gantt.parse(data.data);
            this._apply_sort();
          } else {
            // Refresh the whole thing
            this.refresh();
            break id_loop;
          }
          break;
        default:
          // Refresh the whole thing
          this.refresh();
      }
    }

    // Trigger an event so app code can act on it
    jQuery(this).triggerHandler("refresh", [this, _task_ids, _type]);
    return Promise.all(promises).then(() => {
      setTimeout(() => {
        this.gantt.hideCover();
      }, 500);
    });
  }

  /**
   * Is dirty returns true if the value of the widget has changed since it
   * was loaded.
   */
  isDirty() {
    return this.value != null;
  }

  /**
   * Causes the dirty flag to be reseted.
   */
  resetDirty() {
    this.value = null;
  }

  /**
   * Checks the data to see if it is valid, as far as the client side can tell.
   * Return true if it's not possible to tell on the client side, because the server
   * will have the chance to validate also.
   *
   * The messages array is to be populated with everything wrong with the data,
   * so don't stop checking after the first problem unless it really makes sense
   * to ignore other problems.
   *
   * @param {String[]} messages List of messages explaining the failure(s).
   *	messages should be fairly short, and already translated.
   *
   * @return {boolean} True if the value is valid (enough), false to fail
   */
  isValid(messages) {
    return true;
  }

  /**
   * Set a URL to fetch the data from the server.
   * Data must be in the specified format.
   * @see http://docs.dhtmlx.com/gantt/desktop__loading.html
   *
   * @param {string} url
   */
  set_autoload(url) {
    if (this.gantt == null) return false;
    this.options.autoloading = url;
    throw new Exception('Not implemented yet - apparently loading segments is not supported automatically');
  }

  /**
   * Sets the level of detail for the chart, which adjusts the scale(s) across the
   * top and the granularity of the drag grid.
   *
   * Gantt chart needs a render() after changing.
   *
   * @param {int} level Higher levels show more grid, at larger granularity.
   * @return {int} Current level
   */
  set_zoom(level) {
    // No level?  Auto calculate.
    if (!level || level < 1) {
      // Make sure we have the most up to date info for the calculations
      // There may be a more efficient way to trigger this though
      try {
        this.gantt.refreshData();
      } catch (e) {}
      var max_date = 0;
      var min_date = Infinity;
      var tasks = this.gantt.getTaskByTime();
      for (var i = 0; i < tasks.length; i++) {
        if (tasks[i].start_date && tasks[i].start_date > max_date) max_date = tasks[i].start_date;
        if (tasks[i].start_date && tasks[i].start_date < min_date) min_date = tasks[i].start_date;
        if (tasks[i].end_date && tasks[i].end_date > max_date) max_date = tasks[i].end_date;
        if (tasks[i].end_date && tasks[i].end_date < min_date) min_date = tasks[i].end_date;
      }
      var difference = (max_date - min_date) / 1000; // seconds
      // Spans more than 2 years
      if (difference > 63113904) {
        level = 5;
      }
      // Spans more than 3 months
      else if (difference > 7776000) {
        level = 4;
      }
      // More than 3 days
      else if (difference > 86400 * 3) {
        level = 3;
      }
      // More than 1 day
      else {
        level = 2;
      }
    }

    // Adjust Gantt settings for specified level
    gantt.ext.zoom.setLevel(level);
    this.gantt.refreshData();
    return level;
  }

  /**
   * Apply user's sort preference
   */
  _apply_sort() {
    switch (egw.preference('gantt_pm_elementbars_order', 'projectmanager')) {
      case "pe_start":
      case "pe_start,pe_end":
        this.gantt.sort('start_date', false);
        break;
      case "pe_end":
        this.gantt.sort('end_date', false);
        break;
      case 'pe_title':
        this.gantt.sort('pe_title', false);
        break;
    }
  }

  /**
   * Bind all the internal gantt events for nice widget actions
   */
  _bindGanttEvents() {
    var gantt_widget = this;

    // Click on scale to zoom - top zooms out, bottom zooms in
    this.gantt_node.on('click', '.gantt_scale_line', function (e) {
      var current_position = e.target.offsetLeft / jQuery(e.target.parentNode).width();
      var date = new Date(gantt_widget.gantt.getState().min_date.getTime() + (gantt_widget.gantt.getState().max_date.getTime() - gantt_widget.gantt.getState().min_date.getTime()) * current_position);

      // Make it more consistently go to where you click, instead of the middle
      // of the range
      var id = gantt_widget.gantt.ext.zoom.attachEvent("onAfterZoom", function () {
        if (gantt_widget && gantt_widget.gantt) {
          gantt_widget.gantt.detachEvent(id);
          gantt_widget.gantt.showDate(date);
        }
      });
      if (this.parentNode && this.parentNode.firstChild === this && this.parentNode.childElementCount > 1) {
        // Zoom out
        gantt.ext.zoom.zoomOut();
      } else
        // if (gantt_widget.options.zoom > 1)
        {
          // Zoom in
          gantt.ext.zoom.zoomIn();
        }
    });
    this.gantt.attachEvent("onGridHeaderClick", function (column_name, e) {
      if (column_name === "add") {
        gantt_widget._column_selection(e);
      }
    });
    this.gantt.attachEvent("onContextMenu", function (taskId, linkId, e) {
      if (gantt_widget.options.readonly) return false;
      if (taskId) {
        gantt_widget._link_task(taskId);
      } else if (linkId) {
        gantt_widget.delete_link_handler(linkId, e);
        e.stopPropagation();
      }
      return false;
    });
    // Double click
    this.gantt.attachEvent("onBeforeLightbox", function (id) {
      gantt_widget._link_task(id);
      // Don't do gantt default actions, actions handle it
      return false;
    });

    // Update server after dragging a task
    this.gantt.attachEvent("onAfterTaskDrag", function (id, mode, e) {
      if (gantt_widget.options.readonly) return false;

      // Round to nearest 10%
      var task = this.getTask(id);
      if (mode === "progress") {
        task.progress = Math.round(task.progress * 10) / 10;
        this.updateTask(task.id);
      }
      var task = jQuery.extend({}, this.getTask(id));

      // Gantt chart deals with dates as Date objects, format as server likes
      var date_parser = this.date.date_to_str(this.config.api_date);
      if (task.start_date) task.start_date = date_parser(task.start_date);
      if (task.end_date) task.end_date = date_parser(task.end_date);
      var value = gantt_widget.getInstanceManager().getValues(gantt_widget.getInstanceManager().widgetContainer);
      var set = true;
      if (gantt_widget.options.onchange) {
        e.data = {
          task: task,
          mode: mode,
          value: value
        };
        set = gantt_widget.change(e, gantt_widget);
      }
      if (gantt_widget.options.ajax_update && set) {
        var request = gantt_widget.egw().json(gantt_widget.options.ajax_update, [task, mode, value]).sendRequest(true);
      }
    });

    // Update server for links
    var link_update = function link_update(id, link) {
      if (gantt_widget.options.readonly) return false;
      if (gantt_widget.options.ajax_update) {
        var send_values = jQuery.extend({}, link);
        send_values.parent = this.getTask(link.source).parent;

        // Make sure we send the element ID, sub-projects don't have that in their ID
        var source = this.getTask(link.source);
        if (source.pe_app === "projectmanager") {
          send_values.source = source.pe_app + ":" + source.pe_app_id + ':' + source.pe_id;
        }
        var target = this.getTask(link.target);
        if (target.pe_app === "projectmanager") {
          send_values.target = target.pe_app + ":" + target.pe_app_id + ':' + target.pe_id;
        }
        var value = gantt_widget.getInstanceManager().getValues(gantt_widget.getInstanceManager().widgetContainer);
        var request = gantt_widget.egw().json(gantt_widget.options.ajax_update, [send_values, 'link', value], function (new_id) {
          if (new_id) {
            gantt_widget.gantt.changeLinkId(link.id, new_id);
          }
        }).sendRequest(true);
      }
    };
    this.gantt.attachEvent("onAfterLinkAdd", link_update);
    this.gantt.attachEvent("onAfterLinkDelete", link_update);

    // Bind AJAX for dynamic expansion
    // TODO: This could be improved
    this.gantt.attachEvent("onTaskOpened", function (id, item) {
      var button = this.$grid_data.querySelector("[task_id='" + id + "']").querySelector(".gantt_close,.gantt_open");
      if (button) {
        var width = getComputedStyle(button).width;
        button.classList.add("loading");
        button.classList.remove("gantt_open", "gantt_close");
        button.style.width = width;
      }
      var request = gantt_widget.refresh(id);
      request.then(() => {
        if (button) {
          button.classList.remove("loading");
        }
      });
    });
    // Wait a bit to slow down users, otherwise they might try to close it before refresh is done
    this.gantt.attachEvent("onTaskClosed", function (id, item) {
      this.showCover();
      setTimeout(() => {
        this.hideCover();
      }, 500);
    });

    // Filters
    this.gantt.attachEvent("onBeforeTaskDisplay", function (id, task) {
      var display = true;
      gantt_widget.iterateOver(function (_widget) {
        switch (_widget.id) {
          // Start and end date are an interval.  Also update the chart to
          // display those dates.  Special handling because date widgets give
          // value in timestamp (seconds), gantt wants Date object (ms)
          case 'end_date':
            if (_widget.getValue()) {
              display = display && task['start_date'].valueOf() / 1000 < new Date(_widget.getValue()).valueOf() / 1000 + 86400;
            }
            return;
          case 'start_date':
            // End date is not actually a required field, so accept undefined too
            if (_widget.getValue()) {
              display = display && (typeof task['end_date'] == 'undefined' || !task['end_date'] || task['end_date'].valueOf() / 1000 >= new Date(_widget.getValue()).valueOf() / 1000);
            }
            return;
        }

        // Regular equality comparison
        if (_widget.getValue() && typeof task[_widget.id] != 'undefined') {
          if (task[_widget.id] != _widget.getValue()) {
            display = false;
          }
          // Special comparison for objects, any intersection is a match
          if (!display && typeof task[_widget.id] == 'object' || typeof _widget.getValue() == 'object') {
            var a = typeof task[_widget.id] == 'object' ? task[_widget.id] : _widget.getValue();
            var b = a == task[_widget.id] ? _widget.getValue() : task[_widget.id];
            if (typeof b == 'object') {
              display = jQuery.map(a, function (x) {
                return jQuery.inArray(x, b) >= 0;
              });
            } else {
              display = jQuery.inArray(b, a) >= 0;
            }
          }
        }
      }, gantt_widget, et2_inputWidget);
      return display;
    });
  }

  /**
   * Confirm & delete link
   */
  delete_link_handler(link_id, event) {
    var gantt_widget = this;
    var dialog = Et2Dialog.show_dialog(function (button) {
      if (button == Et2Dialog.YES_BUTTON) {
        gantt_widget.gantt.deleteLink(link_id);
      }
    }, 'delete link?', 'delete');
  }

  /**
   * Bind onchange for any child input widgets
   */
  _bindChildren() {
    var gantt_widget = this;
    this.iterateOver(function (_widget) {
      if (_widget.instanceOf(et2_gantt)) {
        return;
      }
      // Existing change function
      var widget_change = _widget.onchange;
      var change = function change(_node) {
        // Call previously set change function
        var result = true;
        if (widget_change) {
          result = widget_change.call(_widget, _node);
        }

        // Update filters
        if (result) {
          // Update dirty
          _widget._oldValue = _widget.getValue();
          gantt_widget.gantt.refreshData();
          // Start date & end date change the display
          if (_widget.id == 'start_date' || _widget.id == 'end_date') {
            var start = gantt_widget.getWidgetById('start_date');
            var end = gantt_widget.getWidgetById('end_date');
            gantt_widget.gantt.config.start_date = start && start.getValue() ? new Date(start.getValue()) : null;
            // End date is inclusive
            gantt_widget.gantt.config.end_date = end && end.getValue() ? new Date(new Date(end.getValue()).valueOf() + 86400000) : null;
            if (gantt_widget.gantt.config.end_date && gantt_widget.gantt.config.end_date <= gantt_widget.gantt.config.start_date) {
              gantt_widget.gantt.config.end_date = null;
              if (end) {
                end.set_value(null);
              }
            }
            gantt_widget.set_zoom();
            gantt_widget.gantt.render();
          }
        }
        // In case this gets bound twice, it's important to return
        return true;
      };
      if (_widget.onchange != change) {
        _widget.onchange = change;
      }
    }, this, et2_IInput);
  }

  /**
   * Start UI for selecting among defined columns
   *
   * @param {type} e
   */
  _column_selection(e) {
    var self = this;
    var columns = [];
    var columns_selected = [];
    for (var i = 0; i < this.options.columns.length; i++) {
      var col = this.options.columns[i];
      columns.push({
        value: col.name,
        label: col.label
      });
      if (!col.hide) {
        columns_selected.push(col.name);
      }
    }

    // Build the popup
    if (!this.selectPopup) {
      var updateColumns = function updateColumns(button, values) {
        if (button == Et2Dialog.OK_BUTTON) {
          for (var i = 0; i < columns.length; i++) {
            self.options.columns[i].hide = values.columns.indexOf(columns[i].value) < 0;
          }
          self.set_columns(self.options.columns);

          // Update Implicit preference
          this.egw().set_preference(self.getInstanceManager().app, 'gantt_columns_' + self.id, values.columns);
        }
        jQuery('body').off('click.gantt');
      };
      this.selectPopup = new Et2Dialog(this.egw());
      this.selectPopup.transformAttributes({
        destroyOnClose: false,
        title: this.egw().lang("Select columns"),
        buttons: Et2Dialog.BUTTONS_OK_CANCEL,
        template: this.egw().link(this.egw().webserverUrl + "/projectmanager/templates/default/gantt_column_selection.xet"),
        callback: updateColumns,
        value: {
          content: {
            columns: columns_selected
          },
          sel_options: {
            columns: columns
          }
        }
      });
      document.body.appendChild(this.selectPopup);
    } else {
      this.selectPopup.show();
    }
  }

  /**
   * Link the actions to the DOM nodes / widget bits.
   * Overridden to make the gantt chart a container, so it can't be selected.
   * Because the chart handles its own AJAX fetching and parsing, for this widget
   * we're trying dynamic binding as needed, rather than binding every single task
   *
   * @param {object} actions {ID: {attributes..}+} map of egw action information
   */
  _link_actions(actions) {
    super._link_actions(actions);

    // Submit with most actions
    this._actionManager.setDefaultExecute(jQuery.proxy(function (action, selected) {
      var ids = [];
      for (var i = 0; i < selected.length; i++) {
        ids.push(selected[i].id);
      }
      this.value = {
        action: action.id,
        selected: ids
      };

      // downloads need a regular submit via POST (no Ajax)
      if (action.data.postSubmit) {
        this.getInstanceManager().postSubmit();
      } else {
        this.getInstanceManager().submit();
      }
    }, this));

    // Get the top level element for the tree
    var objectManager = egw_getAppObjectManager(true);
    var widget_object = objectManager.getObjectById(this.id);
    widget_object.flags = EGW_AO_FLAG_IS_CONTAINER;
  }

  /**
   * Bind a single task as needed to the action system.  This is instead of binding
   * every single task at the start.
   *
   * @param {string} taskId
   */
  _link_task(taskId) {
    if (!taskId) return;
    var objectManager = egw_getObjectManager(this.id, false);
    var obj = null;
    if (!(obj = objectManager.getObjectById(taskId))) {
      obj = objectManager.addObject(taskId, this.dhtmlxGanttItemAOI(this.gantt, taskId));
      obj.data = this.gantt.getTask(taskId);
      obj.updateActionLinks(objectManager.actionLinks);
    }
    objectManager.setAllSelected(false);
    obj.setSelected(true);
    objectManager.updateSelectedChildren(obj, true);
  }

  /**
   * ActionObjectInterface for gantt chart
   *
   * @param {type} gantt
   * @param {type} task_id
   * @returns {egwActionObjectInterface|et2_widget_gantt_L34.et2_widget_ganttAnonym$1.dhtmlxGanttItemAOI.aoi}
   */
  dhtmlxGanttItemAOI(gantt, task_id) {
    var aoi = new egwActionObjectInterface();

    // Retrieve the actual node from the chart
    aoi.node = gantt.getTaskNode(task_id);
    aoi.id = task_id;
    aoi.doGetDOMNode = function () {
      return aoi.node;
    };
    aoi.doTriggerEvent = function (_event) {
      if (_event == EGW_AI_DRAG_OVER) {
        jQuery(this.node).addClass("draggedOver");
      }
      if (_event == EGW_AI_DRAG_OUT) {
        jQuery(this.node).removeClass("draggedOver");
      }
    };
    aoi.doSetState = function (_state) {
      if (!gantt || !gantt.isTaskExists(this.id)) return;
      if (egwBitIsSet(_state, EGW_AO_STATE_SELECTED)) {
        gantt.selectTask(this.id); // false = do not trigger onSelect
      } else {
        gantt.unselectTask(this.id);
      }
    };
    return aoi;
  }
  _set_grid_width(width) {
    if (typeof width === "undefined") {
      width = 0;
      for (var col in this.gantt_config.columns) {
        width += parseInt(this.gantt_config.columns[col]._width) || 300;
      }
    }
    if (width != this.gantt_config.grid_width || typeof this.gantt_config.grid_width == 'undefined') {
      this.gantt_config.grid_width = Math.min(Math.max(200, width), Math.max(300, this.htmlNode.width()));
    }
    if (this.gantt == null) return;
    this.gantt.config.grid_width = this.gantt_config.grid_width;
  }
  resize() {
    // Update column size
    this._set_grid_width();
  }

  // Printing
  /**
   * Prepare for printing
   *
   * Since the gantt chart tends to be large and browsers cannot handle printing
   * pages wider than a piece of paper, we rotate the gantt to fit.
   *
   */
  beforePrint() {
    // Add the class, if needed
    this.htmlNode.addClass('print');
    var max_width = Math.max(jQuery(this.gantt.$grid).width() + jQuery(this.gantt.$task_scale).width(), jQuery(this.gantt.$container).width());
    var max_height = Math.max(jQuery(this.gantt.$grid).height(), jQuery(this.gantt.$container).height());
    var pref = 'gantt_columns_print';
    var app = this.getInstanceManager().app;
    var columns = [];
    var columns_selected = [];

    // Column preference exists?  Set it now
    if (this.egw().preference(pref, app)) {
      var value = jQuery.extend([], this.egw().preference(pref, app));
      for (var i = 0; i < this.options.columns.length; i++) {
        this.options.columns[i].hide = value.indexOf(this.options.columns[i].name) < 0;
      }
      this.set_columns(this.options.columns);
    }

    // Make gantt chart "full size"
    this.gantt_node.width(max_width).height(max_height);
    this.gantt.render();
    this.gantt_node.css({
      width: Math.max(max_width, max_height) + 'px !important',
      height: Math.max(max_width, max_height) + 'px !important'
    });
    // Force layout
    this.egw().getHiddenDimensions(this.gantt_node);

    // Defer the printing to ask about columns and orientation
    var defer = jQuery.Deferred();
    for (var i = 0; i < this.options.columns.length; i++) {
      var col = this.options.columns[i];
      columns.push({
        value: col.name,
        label: col.label
      });
      if (!col.hide) {
        columns_selected.push(col.name);
      }
    }
    var callback = function (button, value) {
      if (button === Et2Dialog.CANCEL_BUTTON) {
        // Give dialog a chance to close, or it will be in the print
        window.setTimeout(function () {
          defer.reject();
        }, 0);
        return;
      }
      // Columns
      for (var i = 0; i < columns.length; i++) {
        this.options.columns[i].hide = value.columns.indexOf(columns[i].value) < 0;
      }
      this.set_columns(this.options.columns);
      this.egw().set_preference(app, pref, value.columns);
      if (value.orientation === 'vertical') {
        this.gantt_node.height(max_width);
        jQuery(this.gantt.$container).css({
          transform: 'rotate(-90deg) translateX(-' + max_width + 'px)',
          'transform-origin': 'top left'
        });
      }
      // Give dialog a chance to close, or it will be in the print
      window.setTimeout(function () {
        defer.resolve();
      }, 0);
    }.bind(this);
    var base_url = this.getInstanceManager().template_base_url;
    if (base_url.substr(base_url.length - 1) === '/') {
      base_url = base_url.slice(0, -1); // otherwise we generate a url //api/templates, which is wrong
    }

    var dialog = new Et2Dialog(this.egw());
    dialog.transformAttributes({
      // If you use a template, the second parameter will be the value of the template, as if it were submitted.
      callback: callback,
      // return false to prevent dialog closing
      buttons: Et2Dialog.BUTTONS_OK_CANCEL,
      title: 'Print',
      template: this.egw().link(base_url + '/projectmanager/templates/default/gantt_print_dialog.xet'),
      value: {
        content: {
          columns: this.egw().preference(pref, app) || columns_selected
        },
        sel_options: {
          columns: columns
        }
      }
    });
    document.body.appendChild(dialog);
    return defer;
  }

  /**
   * Try to clean up the mess we made getting ready for printing
   * in beforePrint()
   */
  afterPrint() {
    jQuery(this.gantt.$container).css({
      transform: '',
      'transform-origin': '',
      'margin-left': ''
    });
    // Column preference exists?  Set it now
    var value = jQuery.extend([], this.egw().preference('gantt_columns_gantt', this.getInstanceManager().app));
    if (value) {
      for (var i = 0; i < this.options.columns.length; i++) {
        this.options.columns[i].hide = value.indexOf(this.options.columns[i].name) < 0;
      }
      this.set_columns(this.options.columns);
    }
    this.resize();
  }
}
_defineProperty$1(et2_gantt, "_attributes", {
  "autoload": {
    "name": "Autoload",
    "type": "string",
    "default": "",
    "description": "JSON URL or menuaction to be called for projects with no, GET parameter selected contains id"
  },
  "ajax_update": {
    "name": "AJAX update method",
    "type": "string",
    "default": "",
    "description": "AJAX menuaction to be called when the user changes a task.  The function should take two parameters: the updated element, and all template values."
  },
  "duration_unit": {
    "name": "Duration unit",
    "type": "string",
    "default": "minute",
    "description": "The unit for task duration values.  One of minute, hour, week, year."
  },
  columns: {
    name: "Columns",
    type: "any",
    default: [{
      name: "text",
      label: egw.lang('Title'),
      tree: true,
      width: '*'
    }],
    description: "Columns for the grid portion of the gantt chart.  An array of objects with keys name, label, etc.  See http://docs.dhtmlx.com/gantt/api__gantt_columns_config.html"
  },
  value: {
    type: 'any'
  },
  needed: {
    ignore: true
  },
  onfocus: {
    ignore: true
  },
  tabindex: {
    ignore: true
  }
});
et2_register_widget(et2_gantt, ["gantt", "projectmanager-gantt"]);

/**
 * Common look, feel & settings for all Gantt charts
 */
// Make sure the locale js file exists before including it otherwise it breaks the loading
jQuery.get(egw.webserverUrl + "/vendor/npm-asset/dhtmlx-gantt/codebase/locale/locale" + (egw.preference('lang') != "en" ? "_" + egw.preference('lang') : "") + ".js", '', function () {
  // Localize to user's language
  import(this.url);
}).fail(function (e) {
  console.log(e);
});
jQuery(function () {
  "use strict";

  gantt.templates.api_date = gantt.date.date_to_str(gantt.config.api_date || '%Y-%n-%d %H:%i:%s');

  // Set icon to match application
  gantt.templates.grid_file = function (item) {
    if (!item.pe_icon || !egw.image(item.pe_icon)) return "<div class='gantt_tree_icon gantt_file'></div>";
    return "<div class='gantt_tree_icon' style='background-image: url(\"" + egw.image(item.pe_icon) + "\");'/></div>";
  };

  // CSS for scale row, turns on clickable
  gantt.templates.scale_row_class = function (scale) {
    if (scale.unit != 'minute' && scale.unit != 'month') {
      return scale.class || 'et2_clickable';
    }
    return scale.class;
  };

  // Label for task bar
  gantt.templates.task_text = function (start, end, task) {
    switch (task.type) {
      case 'milestone':
        return '';
      default:
        return task.text;
    }
  };

  // Include progress text in the bar
  gantt.templates.progress_text = function (start, end, task) {
    return "<span>" + Math.round(task.progress * 100) + "% </span>";
  };

  // Highlight weekends
  gantt.templates.scale_cell_class = function (date) {
    if (date.getDay() == 0 || date.getDay() == 6) {
      return "weekend";
    }
  };
  gantt.templates.timeline_cell_class = function (item, date) {
    if (date.getDay() == 0 || date.getDay() == 6) {
      return "weekend";
    }
  };
  gantt.templates.leftside_text = function (start, end, task) {
    var text = '';
    if (task.planned_start) {
      if (typeof task.planned_start == 'string') task.planned_start = gantt.date.parseDate(task.planned_start, "xml_date");
      var p_start = gantt.posFromDate(task.planned_start) - gantt.posFromDate(start);
      text = "<div class='gantt_task_line gantt_task_planned' style='width:" + Math.abs(p_start) + "px; right:" + (p_start > 0 ? -p_start : 0) + "px;'><span>" + gantt.date.date_to_str(gantt.config.api_date)(task.planned_start) + "</span></div>";
    }
    return text;
  };
  gantt.templates.rightside_text = function (start, end, task) {
    var text = '';
    if (task.planned_end) {
      if (typeof task.planned_end == 'string') task.planned_end = gantt.date.parseDate(task.planned_end, "xml_date");
      var p_end = gantt.posFromDate(task.planned_end) - gantt.posFromDate(end);
      text = "<div class='gantt_task_line gantt_task_planned' style='left:" + (p_end > 0 ? 0 : p_end) + "px; width:" + Math.abs(p_end) + "px'><span>" + gantt.date.date_to_str(gantt.config.api_date)(task.planned_end) + "</span></div>";
    }
    return text;
  };

  // Task styling
  gantt.templates.task_class = function (start, end, task) {
    var classes = [];
    if (task.type) {
      classes.push(task.type);
    }
    return classes.join(" ");
  };
  // Link styling
  gantt.templates.link_class = function (link) {
    var link_class = '';
    var source = gantt.getTask(link.source);
    var target = gantt.getTask(link.target);
    var valid = true;
    var types = gantt.config.links;
    switch (link.type) {
      case types.finish_to_start:
        valid = source.end_date <= target.start_date;
        break;
      case types.start_to_start:
        valid = source.start_date <= target.start_date;
        break;
      case types.finish_to_finish:
        valid = source.end_date >= target.end_date;
        break;
      case types.start_to_finish:
        valid = source.start_date >= target.end_date;
        break;
    }
    link_class += valid ? '' : 'invalid_constraint';
    return link_class;
  };
});

function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * JS for projectmanager
 */
class ProjectmanagerApp extends EgwApp {
  /**
   * Constructor
   *
   */
  constructor() {
    // call parent
    super('projectmanager');
    // Variables for having all templates loaded & switching
    _defineProperty(this, "view", 'list');
    _defineProperty(this, "views", {
      // Name = key, etemplate is filled in when loaded, sidemenu is untranslated text from hooks
      list: {
        name: 'list',
        etemplate: null,
        sidemenu: 'Projectlist'
      },
      elements: {
        name: 'elements',
        etemplate: null,
        sidemenu: 'Elementlist'
      },
      gantt: {
        name: 'gantt',
        etemplate: null,
        sidemenu: 'Ganttchart'
      },
      prices: {
        name: 'prices',
        etemplate: null,
        sidemenu: 'Pricelist'
      }
    });
    // Reference of all sub-templates
    _defineProperty(this, "etemplates", {
      "projectmanager.list": "list",
      "projectmanager.elements.list": "elements",
      "projectmanager.gantt": "gantt",
      "projectmanager.pricelist.list": "prices"
    });
    register_app_refresh(this.appname, jQuery.proxy(this.linkHandler, this));
  }

  /**
   * Destructor
   */
  destroy(_app) {
    // Release sidebox from views
    if (this.sidebox) {
      this.sidebox.parent().parent().find('a').off('.projectmanager');
    }

    // Remove reference to etemplates
    for (var view in this.views) {
      this.views[view].etemplate = null;
    }

    // call parent
    super.destroy(_app);
  }

  /**
   * This function is called when the etemplate2 object is loaded
   * and ready.  If you must store a reference to the et2 object,
   * make sure to clean it up in destroy().
   *
   * @param {etemplate2} et2 Newly ready etemplate2 object
   * @param {string} name template name
   */
  et2_ready(et2, name) {
    // call parent
    super.et2_ready(et2, name);

    // Add to list, but only ones we care about (no edit popups)
    if (typeof this.views[this.etemplates[et2.name]] != 'undefined') {
      var view = this.views[this.etemplates[et2.name]];
      view.etemplate = et2;

      // Take over sidebox menu
      this._bind_sidebox(view.sidemenu, function () {
        app.projectmanager.show(view.name);
        return false;
      });

      // If one template disappears, we want to release it
      jQuery(et2.DOMContainer).one('clear', function () {
        if (app.projectmanager && app.projectmanager.sidebox) {
          app.projectmanager.sidebox.off('.projectmanager');
        }
        view.etemplate = null;
      });

      // Start hidden, except for project list
      if (jQuery(et2.DOMContainer).siblings('.et2_container').length && !et2.widgetContainer.getArrayMgr('content').getEntry('project_tree')) {
        jQuery(et2.DOMContainer).hide();
      }
      if (view.name == 'list') {
        var _fw$getApplicationByN, _fw$getApplicationByN2;
        // First load, bind filemanager too
        this._bind_sidebox('filemanager', function () {
          app.projectmanager.show_filemanager(null, [{
            id: window.app.projectmanager.views.list.etemplate.widgetContainer.getWidgetById('project_tree').getValue() || 'projectmanager::'
          }]);
          return false;
        });
        // First load, framework could not use our link handler since it wasn't loaded
        var fw = egw_getFramework();
        if (fw && !app.projectmanager.linkHandler((_fw$getApplicationByN = (_fw$getApplicationByN2 = fw.getApplicationByName('projectmanager')) === null || _fw$getApplicationByN2 === void 0 || (_fw$getApplicationByN2 = _fw$getApplicationByN2.browser) === null || _fw$getApplicationByN2 === void 0 ? void 0 : _fw$getApplicationByN2.currentLocation) !== null && _fw$getApplicationByN !== void 0 ? _fw$getApplicationByN : fw.getApplicationByName('projectmanager').url)) {
          this.show('list');
        }
      } else if (this.view) {
        this.show(this.view);
      }
    }
  }

  /**
   * Switch the view
   *
   * ProjectManager is comprised of several views, Project list, element list,
   * gantt chart and price list.  We load them all at once, then switch between
   * them as needed.
   *
   * @param {string} what one of 'list', 'elements', 'gantt' or 'prices'
   * @param {string|number} project_id Project ID to show.  If not provided,
   *	it will be pulled from the project tree
   * @returns {undefined}
   */
  show(what, project_id) {
    var _this$views$what$etem;
    var current_project = project_id && isNaN(project_id) ? project_id[0] ? project_id[0] : null : project_id;
    if (!current_project) {
      if (this.views.list.etemplate) {
        var node_id = this.views.list.etemplate.widgetContainer.getWidgetById('project_tree').getValue() || '';
        var split = node_id.split('::');
        if (split.length > 1 && split[1]) current_project = split[1];
      }
      if (!current_project) {
        current_project = egw.preference('current_project', 'projectmanager');
      }
    }
    current_project = parseInt(current_project) || '';

    // Store preference
    if (this.egw.preference('current_project', 'projectmanager') != current_project) {
      this.egw.set_preference('projectmanager', 'current_project', current_project);
    }

    // Update with current project
    var et2 = (_this$views$what$etem = this.views[what].etemplate) === null || _this$views$what$etem === void 0 ? void 0 : _this$views$what$etem.widgetContainer;
    if (current_project && et2) {
      switch (what) {
        case 'elements':
          var elements = et2.getWidgetById('nm');
          if (elements.getDOMNode().classList.contains("hide")) {
            elements.getDOMNode().classList.remove("hide");
          }
          var filter = {
            col_filter: {
              'pm_id': current_project
            }
          };
          if (et2.getWidgetById('link_add')) {
            filter['link_add'] = _objectSpread(_objectSpread({}, et2.getWidgetById('link_add').value), {
              to_id: current_project
            });
          }
          et2.getWidgetById('nm').applyFilters(filter);
          break;
        case 'gantt':
          var gantt = et2.getWidgetById('gantt');
          gantt.gantt.showCover();
          // Re-set dates for different project
          var values = gantt.getInstanceManager().getValues(gantt)[gantt.id];
          delete values.start_date;
          delete values.end_date;
          delete values.duration_unit;

          // Support multiple projects
          if (!project_id || !project_id.map) {
            project_id = [current_project];
          }
          project_id = project_id.map(function (id) {
            return typeof id == 'string' && id.indexOf('projectmanager::') == 0 ? id : 'projectmanager::' + id;
          });
          if (console.profile) console.profile('Gantt');
          if (console.group) console.group("Gantt loading PM_ID " + project_id);
          if (console.time) console.time("Gantt fetch");
          this.egw.json('projectmanager_gantt::ajax_gantt_project', [project_id, values], function (data) {
            if (console.time) console.timeEnd("Gantt fetch");
            gantt.set_value(data);
          }).sendRequest(true);
          break;
        case 'prices':
          // Pricelist is not valid for all projects.  If we have the data, adjust accordingly
          var data = this.egw.dataGetUIDdata('projectmanager::' + current_project);
          var pricelist_project = '0';
          if (data && data.data && data.data.pm_accounting_type) {
            pricelist_project = data.data.pm_accounting_type == 'pricelist' ? current_project : '0';
          } else if (et2.getWidgetById('pm_id')) {
            // Unknown project, try the filter options
            var options = et2.getWidgetById('pm_id').options.select_options || [];
            for (var i = 0; i < options.length; i++) {
              if (parseInt(options[i].value) == parseInt(current_project)) {
                pricelist_project = current_project;
                break;
              }
            }
          }
          et2.getWidgetById('nm').applyFilters({
            col_filter: {
              'pm_id': pricelist_project
            }
          });
      }
    } else if (what == 'prices' && et2) {
      // Price list doesn't need a project
      et2.getWidgetById('nm').applyFilters({
        col_filter: {
          'pm_id': '0'
        }
      });
    } else if (what != 'list') {
      this.egw.message(this.egw.lang('You need to select a project first'));
      what = 'list';
    }

    // Update internal variable for current view
    this.view = what;

    // Update tree
    if (this.views.list.etemplate) {
      this.views.list.etemplate.widgetContainer.getWidgetById('project_tree').set_value(current_project ? 'projectmanager::' + current_project : '');
    }

    // Show selected sub-template
    if (this.views[what].etemplate) {
      jQuery(this.views[what].etemplate.DOMContainer).show();
      this.views[what].etemplate.resize();
    }

    // Set header
    this.egw.app_header(this.egw.lang(this.views[what].sidemenu), 'projectmanager');

    // Hide other views
    for (var view in this.views) {
      if (what != view && this.views[view].etemplate) {
        jQuery(this.views[view].etemplate.DOMContainer).hide();
      }
    }
  }

  /**
   * Set the application's state to the given state.
   *
   * The default implementation works with the favorites to apply filters to a nextmatch.
   * Re-implemented to support view
   *
   * @param {{name: string, state: object}|string} state Object (or JSON string) for a state.
   *	Only state is required, and its contents are application specific.
   *
   * @return {boolean} false - Returns false to stop event propagation
   */
  setState(state) {
    // State should be an object, not a string, but we'll parse
    if (typeof state == "string") {
      if (state.indexOf('{') != -1 || state == 'null') {
        state = JSON.parse(state);
      }
    }
    if (typeof state != "object") {
      egw.debug('error', 'Unable to set state to %o, needs to be an object', state);
      return;
    }
    if (state == null) {
      state = {};
    }

    // Check for egw.open() parameters
    if (state.state && state.state.id && state.state.app) {
      return egw.open(state.state, undefined, undefined, {}, '_self');
    }
    if (state.state && state.state.view) {
      this.show(state.state.view, state.state.pm_id || false);
      // Avoid any potential conflicts when setting others, below
      delete state.state.view;
    } else {
      var _state;
      // Set / clear tree or its value will be used
      var tree = this.views.list.etemplate.widgetContainer.getWidgetById('project_tree');
      tree.value = ((_state = state) === null || _state === void 0 || (_state = _state.state) === null || _state === void 0 ? void 0 : _state.pm_id) || '';
      if (!tree.value) {
        this.egw.set_preference("projectmanager", "current_project", null);
      }
      this.show(this.view || 'list');
    }
    // Try and find a nextmatch widget, and set its filters
    var nextmatched = false;
    var et2 = this.views[this.view].etemplate;
    switch (this.view) {
      case 'gantt':
        for (var id in state.state) {
          var filter = et2.widgetContainer.getWidgetById(id);
          if (filter && filter.set_value) {
            filter.set_value(state.state[id]);
          }
        }
        return false;
      default:
        // Blank filters reset any/all nextmatches
        if (jQuery.isEmptyObject(state.state)) {
          et2 = etemplate2.getByApplication(this.appname);
        } else {
          et2 = [et2];
        }
        for (var i = 0; i < et2.length; i++) {
          et2[i].widgetContainer.iterateOver(function (_widget) {
            // Firefox has trouble with spaces in search
            if (state.state && state.state.search) state.state.search = unescape(state.state.search);

            // Apply
            _widget.applyFilters(state.state || state.filter || {});
            nextmatched = true;
          }, this, et2_nextmatch);
        }
        if (nextmatched) return false;
    }

    // call parent
    state = super.setState(state);
  }

  /**
   * Retrieve the current state of the application for future restoration
   *
   * Overwritten from the parent to support view
   *
   * @return {object} Application specific map representing the current state
   */
  getState() {
    var state = {};

    // Try and find a nextmatch widget, and set its filters
    var et2 = this.views[this.view].etemplate;
    if (et2) {
      if (this.view == 'gantt') {
        et2.widgetContainer.iterateOver(function (gantt) {
          state = gantt.getInstanceManager().getValues(gantt)[gantt.id];
        }, this, et2_gantt);
      } else {
        et2.widgetContainer.iterateOver(function (_widget) {
          state = _widget.getValue();

          // These aren't considered for state
          delete state.link_add;
          delete state.link_addapp;
        }, this, et2_nextmatch);
      }
      // Gantt & tree also need the current PM ID stored
      var current_project = 0;
      if (this.views.list.etemplate) {
        var node_id = this.views.list.etemplate.widgetContainer.getWidgetById('project_tree').getValue() || '';
        var split = node_id.split('::');
        if (split.length > 1 && split[1]) {
          current_project = split[1];
        }
      }
      if (!current_project) {
        current_project = parseInt('' + egw.preference('current_project', 'projectmanager'));
      }
      state.pm_id = current_project ? current_project : false;
    }
    state.view = this.view || null;
    return state;
  }

  /**
   * Handle links for projectmanager using JS instead of reloading
   *
   * @param {string} url
   * @returns {boolean} True if PM could handle the link internally, false to let framework handle it
   */
  linkHandler(url) {
    var match = url.match(/projectmanager(?:_elements)?_ui\.index.*&(pm_id)=(\d+)/);
    if (match && match.length > 2 && match[1] == 'pm_id') {
      if (this.views.elements.etemplate) {
        this.show('elements', match[2]);
      } else {
        // Still loading
        window.setTimeout(function () {
          app.projectmanager.linkHandler(url);
        }, 100);
      }
      return true;
    }
    return false;
  }

  /**
   * Observer method receives update notifications from all applications
   *
   * @param {string} _msg message (already translated) to show, eg. 'Entry deleted'
   * @param {string} _app application name
   * @param {(string|number)} _id id of entry to refresh or null
   * @param {string} _type either 'update', 'edit', 'delete', 'add' or null
   * - update: request just modified data from given rows.  Sorting is not considered,
   *		so if the sort field is changed, the row will not be moved.
   * - edit: rows changed, but sorting may be affected.  Requires full reload.
   * - delete: just delete the given rows clientside (no server interaction neccessary)
   * - add: requires full reload for proper sorting
   * @param {string} _msg_type 'error', 'warning' or 'success' (default)
   * @param {object|null} _links app => array of ids of linked entries
   * or null, if not triggered on server-side, which adds that info
   */
  observer(_msg, _app, _id, _type, _msg_type, _links) {
    switch (_app) {
      case 'projectmanager':
        var tree = this.views.list.etemplate.widgetContainer.getWidgetById('project_tree');
        var itemId = _id != 'undefined' ? _app + "::" + _id : 0;
        if (tree && itemId) {
          var node = tree.getNode(itemId);
          // Not in tree.  Either parent node not expanded, or a new project
          if (_type != 'delete' && node == null && typeof _links.projectmanager != 'undefined' && _links.projectmanager.length > 0) {
            // First one should be parent
            for (var i = 0; i < _links.projectmanager.length && node == null; i++) {
              node = tree.getNode(_app + "::" + _links.projectmanager[i]);
            }
            if (node !== null) {
              itemId = node.id;
            }
          }
          switch (_type) {
            case 'add':
            case 'update':
            case 'edit':
              tree.refreshItem(itemId);
              break;
            case 'delete':
              if (node) {
                tree.deleteItem(itemId);
              }
              // Currently viewing that project - go back to list
              if (this.view === 'elements' && this.getState().col_filter.pm_id == _id) {
                this.show('list');
              }
          }
        }
      // Fall through to try the element list too
      default:
        var appList = egw.link_app_list('query');
        var nm = this.views.elements.etemplate ? this.views.elements.etemplate.widgetContainer.getWidgetById('nm') : null;
        if (typeof appList[_app] != 'undefined') {
          if (typeof _links != 'undefined') {
            if (typeof _links.projectmanager != 'undefined') {
              if (nm) nm.refresh();
            } else if (nm) {
              var rex = RegExp("projectmanager_elements::" + _app + ":" + _id + ".*");
              egw.dataRefreshUIDs(rex, 'delete');
            }
          }
        }
    }

    // Update current view with new info
    switch (this.view) {
      case 'list':
        var nm = this.views.list.etemplate ? this.views.list.etemplate.widgetContainer.getWidgetById('nm') : null;
        if (nm) {
          nm.refresh(_id, _type);
        }
        return false;
      case 'elements':
        var nm = this.views.elements.etemplate ? this.views.elements.etemplate.widgetContainer.getWidgetById('nm') : null;
        if (nm) {
          // Element list has totals that probably need refreshed, so do a
          // full refresh, not just intelligent by type refresh.
          nm.refresh(_id);
        }
        return false;
      case 'gantt':
        var ids = [];
        var gantt = this.views.gantt.etemplate.widgetContainer.getWidgetById('gantt');
        if (_type == 'add' && _links.projectmanager) {
          // Refresh the parent(s)
          for (var i = 0; i < _links.projectmanager.length; i++) {
            ids.push('projectmanager::' + _links.projectmanager[i]);
          }
          _type == 'update';
        } else if (_id) {
          ids.push(_app + "::" + _id);
        }
        gantt.refresh(ids, _type);
        return false;
    }
  }

  /**
   * Change handler for link_add selection
   *
   * Keeps the app, but does not trigger an actual change
   *
   * @param event
   * @param widget
   */
  element_add_app_change_handler(event, widget) {
    if (widget.id !== 'link_addapp') return false;
    var nm = widget.getParent();
    while (!nm.instanceOf(et2_nextmatch)) {
      nm = nm.getParent();
    }
    if (nm.activeFilters) {
      nm.activeFilters[widget.id] = widget.get_value();
    }
    return false;
  }

  /**
   * Change the selected project
   *
   * This is a callback for the tree, either on click (node_id is a string) or
   * context menu
   *
   * Crazy parameters thanks to action system.
   * @param {string|egwAction} node_id Either the selected leaf, or a context-menu action
   * @param {et2_tree|egwActionObject[]} tree_widget Either the tree widget, or the selected leaf.
   * @param {string|egwAction} old_node_id Either the selected leaf, or a context-menu action
   */
  set_project(node_id, tree_widget, old_node_id) {
    var same_view = this.view != 'list';
    if (typeof node_id == 'object' && tree_widget[0]) {
      same_view = false;
      node_id = tree_widget[0].id;
    }
    if (node_id) {
      var split = node_id.split('::');
      if (split.length > 1 && split[1]) node_id = split[1];
      if (!split || split.length <= 1 || Number.isNaN(node_id)) {
        // Active / Non-active / Archive / Template
        return this.setState({
          state: {
            view: "list",
            filter2: node_id
          }
        });
      } else if (this.views['elements'].etemplate != null) {
        // Change the current view to the new project, or element list
        // if current view is project list
        this.show(same_view ? this.view : 'elements', node_id);
      } else {
        // Somehow we don't have the element list
        this.egw.open(node_id, 'projectmanager', 'view', {}, 'projectmanager', 'projectmanager');
      }
    } else {
      this.egw.open('', 'projectmanager', 'list', {}, 'projectmanager', 'projectmanager');
    }
  }

  /**
   * Handles delete button in edit popup
   *
   */
  p_element_delete() {
    var template = this.et2._inst;
    if (template) {
      var content = template.widgetContainer.getArrayMgr('content');
      var id = content.data['pe_id'];
    }
    console.log('I am element delete');
    opener.location.href = egw.link('/index.php', {
      menuaction: content.data['caller'] ? content.data['caller'] : 'projectmanager.projectmanager_elements_ui.index',
      delete: id
    });
    egw(window).close();
  }

  /**
   * Limits constraint target link-entry widget to current project
   *
   * @param {object} request
   * @param {et2_widget_entry} widget
   * @returns {boolean} true to do the search
   */
  element_constraint_pre_query(request, widget) {
    if (!request.options) request.options = {};
    request.options.pm_id = this.et2.getInstanceManager().widgetContainer.getArrayMgr('content').getEntry('pm_id');

    // Return true to proceed with the search
    return true;
  }

  /**
   * Refresh the multi select box of eroles list
   *
   * @param {string} action name of action
   */
  erole_refresh(action) {
    switch (action) {
      case 'delete':
        return confirm("Delete this role?");
      case 'edit':
        break;
      default:
        this.et2._inst.submit();
    }

    // Refresh element edit so it knows about the new role
    var elemEditWind = window.opener;
    if (elemEditWind) {
      elemEditWind.location.reload();

      // Refresh list so it knows about the new role
      egw(elemEditWind).refresh('', 'projectmanager');
    }
  }

  /**
   * Toggles display of a div
   *
   *  Used in erole list in element list, maybe others?
   *  @param {egw_event object} event
   *  @param {wiget object} widget
   *  @param {string} target jQuery selector
   */
  toggleDiv(event, widget, target) {
    var element = jQuery(target).closest('div').parent('div').find('table.egwLinkMoreOptions');
    if (jQuery(element).css('display') == 'none') {
      jQuery(element).fadeIn('medium');
    } else {
      jQuery(element).fadeOut('medium');
    }
  }

  /**
   * Action callback to show gantt chart for a selected project
   *
   * @param {egwAction object} action
   * @param {object} selected
   */
  show_gantt(action, selected) {
    var id = [];
    for (var i = 0; i < selected.length; i++) {
      // IDs look like projectmanager::#, or projectmanager_elements::projectmanager:#:#
      // gantt wants just #
      var split = selected[i].id.split('::');
      if (split.length > 1) {
        var matches = split[1].match(':([0-9]+):?');
        id.push(matches ? matches[1] : split[1]);
      }
    }
    if (this.views['gantt'].etemplate != null) {
      // Just update the existing gantt
      this.show('gantt', id);
    } else {
      // Somehow we don't have the gantt template loaded
      egw.open_link(egw.link('/index.php', {
        menuaction: 'projectmanager.projectmanager_ui.index',
        pm_id: id.join(','),
        // Server expects CSV, not array
        ajax: 'true'
      }), 'projectmanager', '', 'projectmanager');
    }
  }

  /**
   * Handler for open action (double click) on the gantt chart
   *
   * @param {egwAction} action
   * @param {egwActionObject[]} selected
   */
  gantt_open_action(action, selected) {
    var task = {};
    if (selected[0].data) {
      task = selected[0].data;
    }
    // Project element
    if (task.pe_app) {
      this.egw.open(task.pe_app_id, task.pe_app);
    } else if (task.type && task.type == 'milestone') {
      egw.open_link(egw.link('/index.php', {
        menuaction: 'projectmanager.projectmanager_milestones_ui.edit',
        pm_id: task.pm_id,
        ms_id: task.ms_id
      }), '', '680x450', 'projectmanager');
    }
    // Project
    else {
      this.egw.open(task.pm_id, 'projectmanager');
    }
  }
  gantt_edit_element(action, selected) {
    var task = {};
    if (selected[0].data) {
      task = selected[0].data;
    }
    // Project element
    if (task.pe_id) {
      this.egw.open(task.pe_id, 'projectelement', 'edit', {
        pm_id: task.pe_app == 'projectmanager' ? task.parent : task.pm_id
      });
    }
  }

  /**
   * Action callback to show the pricelist for a selected project
   *
   * @param {egwAction} action
   * @param {egwActionObject[]} selected
   */
  show_pricelist(action, selected) {
    var id = [];
    for (var i = 0; i < selected.length; i++) {
      // IDs look like projectmanager::#, or projectmanager_elements::projectmanager:#:#
      // pricelist wants just #
      var split = selected[i].id.split('::');
      if (split.length > 1) {
        var matches = split[1].match(':([0-9]+):?');
        id.push(matches ? matches[1] : split[1]);
      }
    }
    if (this.views['prices'].etemplate != null) {
      // Just update the existing template
      this.show('prices', id[0]);
    } else {
      egw.open_link(egw.link('/index.php', {
        menuaction: 'projectmanager.projectmanager_ui.index',
        pm_id: id.join(','),
        // Server expects CSV, not array
        ajax: 'true'
      }), 'projectmanager', '', 'projectmanager');
    }
  }

  /**
   * Action callback to edit a price on the price list
   *
   * @param {egwAction} action
   * @param {egwActionObject[]} selected
   */
  edit_price(action, selected) {
    var extra = {
      menuaction: 'projectmanager.projectmanager_pricelist_ui.edit',
      pm_id: this.getState().col_filter.pm_id
    };
    if (selected[0] && selected[0].id) {
      var data = this.egw.dataGetUIDdata(selected[0].id);
      if (data && data.data) {
        extra.pl_id = data.data.pl_id;
      }
    }
    egw.openPopup(egw.link('/index.php', extra), 600, 450, '', 'filemanager');
  }

  /**
   * Add a new price to a pricelist
   *
   * Used by the add button on the pricelist index
   *
   * @param {et2_widget} widget
   */
  add_price(widget) {
    var extras = {
      menuaction: 'projectmanager.projectmanager_pricelist_ui.edit',
      pm_id: 0
    };
    var pm_filter = widget.getRoot().getWidgetById('pm_id');
    if (pm_filter) {
      extras.pm_id = pm_filter.get_value();
    }
    window.open(this.egw.link('/index.php', extras), '_blank', 'dependent=yes,width=600,height=450,scrollbars=yes,status=yes');
    return false;
  }

  /**
   * Action callback to show the filemanager for a selected project
   *
   * @param {egwAction} action
   * @param {egwActionObject[]} selected
   */
  show_filemanager(action, selected) {
    var app = '';
    var id = '';
    for (var i = 0; i < selected.length && id == ''; i++) {
      // Data was provided, just read from there
      if (selected[i].data && selected[i].data.pe_app) {
        app = selected[i].data.pe_app;
        id = selected[i].data.pe_app_id;
      } else {
        // IDs look like projectmanager::#, or projectelement::app:app_id:element_id
        var split = selected[i].id.split('::');
        if (split.length > 1) {
          var matches = split[1].match('([_a-z]+):([0-9]+):?');
          if (matches != null) {
            app = matches[1];
            id = matches[2];
          } else {
            app = split[0];
            id = split[1];
          }
        }
      }
    }
    egw.open_link(egw.link('/index.php', {
      menuaction: 'filemanager.filemanager_ui.index',
      path: '/apps/' + app + '/' + id,
      ajax: 'true'
    }), 'filemanager', '', 'filemanager');
  }

  /**
   * Enabled check for erole action, used by context menu
   *
   * @param {egwAction} action
   * @param {egwActionObject[]} selected
   */
  is_erole_allowed(action, selected) {
    var allowed = true;

    // Some eroles can only be assigned to a single element.  If already assigned,
    // they won't be an action, but we'll prevent setting multiple elements
    if (action.data && !action.data.role_multi && selected.length > 1) {
      allowed = false;
    }

    // Erole is limited to only these apps, from projectmanager_elements_bo
    var erole_apps = ['addressbook', 'calendar', 'infolog'];
    for (var i = 0; i < selected.length && allowed; i++) {
      var data = selected[i].data || egw.dataGetUIDdata(selected[i].id);
      if (data && data.data) data = data.data;
      if (!data) {
        allowed = false;
        continue;
      }
      if (erole_apps.indexOf(data.pe_app) < 0) {
        allowed = false;
      }
    }
    return allowed;
  }

  /**
   * Is the selected entry ignored?
   *
   * @param {egwAction} action
   * @param {egwActionObject[]} selected
   * @returns {Boolean}
   */
  is_ignored(action, selected) {
    var ignored = false;
    for (var i = 0; i < selected.length; i++) {
      var data = egw.dataGetUIDdata(selected[i].id);
      ignored = ignored || !!(data && data.data && data.data.ignored);
    }
    return ignored;
  }

  /**
   * Toggle the ignore flag on the selected entries
   *
   * @param {egwAction} action
   * @param {egwActionObject[]} selected
   */
  ignore_action(action, selected) {
    var ids = [];
    for (var i = 0; i < selected.length; i++) {
      ids.push(selected[i].id);
    }
    egw.json('projectmanager_elements_ui::ajax_action', [action.id, ids, action.checked], null, this, true, this).sendRequest(true);
  }

  /**
   * Enabled check for project element action, used by context menu
   *
   * @param {egwAction} action
   * @param {egwActionObject[]} selected
   */
  gantt_edit_enabled(action, selected) {
    var allowed = true;
    for (var i = 0; i < selected.length && allowed; i++) {
      var data = selected[i].data || egw.dataGetUIDdata(selected[i].id);
      if (data && data.data) data = data.data;
      if (!data) {
        allowed = false;
        continue;
      }
      // No milestones, no top-level tasks
      if (selected[i].id.indexOf('pm_milestone') == 0 || !data.parent) {
        allowed = false;
      }
    }
    return allowed;
  }

  /**
   * Add new record's apps to a project
   *
   * @param {egwAction} action
   * @param {egwActionObject[]} selected
   */
  add_new(action, selected) {
    var tree = this.views.list.etemplate.widgetContainer.getWidgetById('project_tree');
    var pm_id = '';
    if (tree) {
      pm_id = tree.getValue();

      // Gantt chart can have multiple selected
      if (jQuery.isArray(pm_id)) pm_id = pm_id[0];
      pm_id = pm_id.replace('::', ':');
    }
    // No tree, or could not find project there
    if (!pm_id && selected[0] && egw.dataGetUIDdata(selected[0].id)) {
      var data = egw.dataGetUIDdata(selected[0].id);
      if (data && data.data && data.data.pm_id) {
        pm_id = 'projectmanager:' + data.data.pm_id;
      }
    }
    if (typeof action !== 'undefined') {
      return this.egw.open(pm_id, action.id.replace('act-', ''), 'add');
    }
  }

  /**
   * Bind the provided click handler to the sidebox menu item that matches
   * the label for fast switching between views
   *
   * @param {string} label
   * @param {function} click
   */
  _bind_sidebox(label, click) {
    if (!app.projectmanager.sidebox) return false;
    var sidebox = jQuery('a:contains("' + app.projectmanager.egw.lang(label) + '")', app.projectmanager.sidebox.parentsUntil('#egw_fw_sidemenu,#tdSidebox').last());
    sidebox.off('click.projectmanager');
    sidebox.on('click.projectmanager', click);
  }

  /**
   * Get title in order to set it as document title
   * @returns {string}
   */
  getWindowTitle() {
    return this.et2.getValueById('pm_title');
  }
}
app.classes.projectmanager = ProjectmanagerApp;

export { ProjectmanagerApp };
//# sourceMappingURL=app.min.js.map
