import type { CustomElementClass } from './custom-element.js';
declare type attrValue = string | number | boolean;
/**
 * Attr is a decorator which tags a property as one to be initialized via
 * `initializeAttrs`.
 *
 * The signature is typed such that the property must be one of a String,
 * Number or Boolean. This matches the behavior of `initializeAttrs`.
 */
export declare function attr<K extends string>(proto: Record<K, attrValue>, key: K): void;
export declare function initializeAttrs(instance: HTMLElement, names?: Iterable<string>): void;
export declare function defineObservedAttributes(classObject: CustomElementClass): void;
export {};
//# sourceMappingURL=attr.d.ts.map