"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseTestResults = exports.parseSessionErrors = exports.replaceErrorStack = void 0;
const browser_logs_1 = require("@web/browser-logs");
const async_js_1 = require("../../../utils/async.js");
async function replaceErrorStack(error, mapBrowserUrl, mapStackLocation, rootDir) {
    try {
        error.stack = await (0, browser_logs_1.parseStackTrace)(error.message, error.stack, {
            mapBrowserUrl,
            mapStackLocation,
            browserRootDir: rootDir,
        });
    }
    catch (error) {
        console.error('Error while parsing browser error');
        console.error(error);
    }
}
exports.replaceErrorStack = replaceErrorStack;
async function parseSessionErrors(config, mapBrowserUrl, mapStackLocation, result) {
    if (!result.errors) {
        return;
    }
    await (0, async_js_1.forEachAsync)(result.errors, err => {
        if (err.stack) {
            return replaceErrorStack(err, mapBrowserUrl, mapStackLocation, config.rootDir);
        }
    });
}
exports.parseSessionErrors = parseSessionErrors;
async function parseTestResults(config, mapBrowserUrl, mapStackLocation, result) {
    if (!result.testResults) {
        return;
    }
    async function iterateTests(tests) {
        await (0, async_js_1.forEachAsync)(tests, async (test) => {
            var _a;
            if ((_a = test.error) === null || _a === void 0 ? void 0 : _a.stack) {
                await replaceErrorStack(test.error, mapBrowserUrl, mapStackLocation, config.rootDir);
            }
        });
    }
    async function iterateSuite(suite) {
        await Promise.all([iterateSuites(suite.suites), iterateTests(suite.tests)]);
    }
    async function iterateSuites(suites) {
        await (0, async_js_1.forEachAsync)(suites, s => iterateSuite(s));
    }
    await iterateSuite(result.testResults);
}
exports.parseTestResults = parseTestResults;
//# sourceMappingURL=parseBrowserErrors.js.map