"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isTestFilePath = void 0;
const constants_js_1 = require("./constants.js");
/**
 * Returns where a given path points to a test file. This should be
 * a browser path, such as an import path or network request.
 * @param path
 */
function isTestFilePath(path) {
    // create a URL with a dummy domain
    const url = new URL(path, 'http://localhost:123');
    return url.searchParams.has(constants_js_1.PARAM_SESSION_ID) || url.searchParams.has(constants_js_1.PARAM_MANUAL_SESSION);
}
exports.isTestFilePath = isTestFilePath;
//# sourceMappingURL=isTestFilePath.js.map