"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.startTestRunner = void 0;
/* eslint-disable no-inner-declarations */
const test_runner_core_1 = require("@web/test-runner-core");
const nanocolors_1 = require("nanocolors");
const mergeConfigs_js_1 = require("./config/mergeConfigs.js");
const parseConfig_js_1 = require("./config/parseConfig.js");
const readCliArgs_js_1 = require("./config/readCliArgs.js");
const readFileConfig_js_1 = require("./config/readFileConfig.js");
const TestRunnerStartError_js_1 = require("./TestRunnerStartError.js");
/**
 * Starts the test runner.
 */
async function startTestRunner(options = {}) {
    const { config: extraConfig, readCliArgs: readCliArgsFlag = true, readFileConfig: readFileConfigFlag = true, configName, autoExitProcess = true, argv = process.argv, } = options;
    try {
        const cliArgs = readCliArgsFlag ? (0, readCliArgs_js_1.readCliArgs)({ argv }) : {};
        const rawConfig = readFileConfigFlag
            ? await (0, readFileConfig_js_1.readFileConfig)({ configName, configPath: cliArgs.config })
            : {};
        const mergedConfig = (0, mergeConfigs_js_1.mergeConfigs)(extraConfig, rawConfig);
        const { config, groupConfigs } = await (0, parseConfig_js_1.parseConfig)(mergedConfig, cliArgs);
        const runner = new test_runner_core_1.TestRunner(config, groupConfigs);
        const cli = new test_runner_core_1.TestRunnerCli(config, runner);
        function stop() {
            runner.stop();
        }
        if (autoExitProcess) {
            ['exit', 'SIGINT'].forEach(event => {
                process.on(event, stop);
            });
        }
        if (autoExitProcess) {
            process.on('uncaughtException', error => {
                /* eslint-disable-next-line no-console */
                console.error(error);
                stop();
            });
        }
        runner.on('stopped', passed => {
            if (autoExitProcess) {
                process.exit(passed ? 0 : 1);
            }
        });
        await runner.start();
        cli.start();
        return runner;
    }
    catch (error) {
        if (error instanceof TestRunnerStartError_js_1.TestRunnerStartError) {
            console.error(`\n${(0, nanocolors_1.red)('Error:')} ${error.message}\n`);
        }
        else {
            console.error(error);
        }
        setTimeout(() => {
            // exit after a timeout to allow CLI to flush console output
            process.exit(1);
        }, 0);
    }
}
exports.startTestRunner = startTestRunner;
//# sourceMappingURL=startTestRunner.js.map