import { getAttributeValueOptions, getCssPropsTemplate, getDescription, getEventsTemplate, getMethods, getMethodsTemplate, getPartsTemplate, getSlotsTemplate, } from "cem-utils";
import { toKebabCase } from "utilities";
export function getCssPropertyList(components, cssSets) {
    return ((components === null || components === void 0 ? void 0 : components.map((component) => {
        var _a;
        return (((_a = component.cssProperties) === null || _a === void 0 ? void 0 : _a.map((prop) => {
            var _a;
            return {
                name: prop.name,
                description: prop.description,
                values: getCssPropertyValues((_a = prop === null || prop === void 0 ? void 0 : prop.type) === null || _a === void 0 ? void 0 : _a.text, cssSets),
            };
        })) || []);
    })) || []).flat();
}
export function getCssPartList(components) {
    return ((components === null || components === void 0 ? void 0 : components.map((component) => {
        var _a;
        return (((_a = component.cssParts) === null || _a === void 0 ? void 0 : _a.map((prop) => {
            return {
                name: `::part(${prop.name})`,
                description: prop.description,
            };
        })) || []);
    })) || []).flat();
}
export function getCssPropertyValues(value, cssSets) {
    if (!value) {
        return [];
    }
    if (value.trim().startsWith("set")) {
        return getValueSet(value, cssSets);
    }
    return getCssValues(value);
}
export function getValueSet(value, cssSets) {
    var _a;
    const setName = value.split(":")[1];
    const valueSet = ((_a = cssSets === null || cssSets === void 0 ? void 0 : cssSets.find((x) => x.name.trim() === setName)) === null || _a === void 0 ? void 0 : _a.values) || [];
    return valueSet.map((x) => {
        if (typeof x === "string") {
            return {
                name: getCssNameValue(x),
            };
        }
        else {
            x.name = getCssNameValue(x.name);
            return x;
        }
    });
}
export function getCssValues(value) {
    return value
        ? (value.includes("|") ? value.split("|") : value.split(",")).map((x) => {
            const propName = x.trim();
            return {
                name: getCssNameValue(propName),
            };
        })
        : [];
}
function getCssNameValue(value) {
    return !value ? "" : value.startsWith("--") ? `var(${value})` : value;
}
export function getTagList(components, referenceTemplate) {
    return (components === null || components === void 0 ? void 0 : components.map((comp) => {
        const component = comp;
        const slots = getSlotsTemplate(component === null || component === void 0 ? void 0 : component.slots);
        const events = getEventsTemplate(component === null || component === void 0 ? void 0 : component.events);
        const cssProps = getCssPropsTemplate(component === null || component === void 0 ? void 0 : component.cssProperties);
        const parts = getPartsTemplate(component === null || component === void 0 ? void 0 : component.cssParts);
        const methods = getMethodsTemplate(getMethods(component));
        return {
            name: component.tagName || toKebabCase(component.name),
            description: getDescription(component) +
                "\n\n\n---\n\n\n" +
                events +
                methods +
                slots +
                cssProps +
                parts,
            attributes: getComponentAttributes(component),
            references: referenceTemplate
                ? referenceTemplate(component.name, component.tagName)
                : [],
        };
    })) || [];
}
export function getComponentAttributes(component) {
    var _a;
    const attributes = [];
    (_a = component === null || component === void 0 ? void 0 : component.attributes) === null || _a === void 0 ? void 0 : _a.forEach((attr) => {
        const existingAttr = attributes.find((x) => x.name === attr.name || x.name === attr.fieldName);
        if (existingAttr) {
            return;
        }
        attributes.push({
            name: attr.name || attr.fieldName,
            description: attr.description,
            values: getAttributeValues(attr),
        });
    });
    return attributes;
}
export function getAttributeValues(attr) {
    const options = getAttributeValueOptions(attr);
    return ((options === null || options === void 0 ? void 0 : options.map((option) => {
        return {
            name: option,
        };
    })) || []);
}
