/* eslint-disable @typescript-eslint/no-non-null-assertion */
import { createOutDir, logRed, saveFile } from "integrations";
import { getCssPartList, getCssPropertyList, getTagList, } from "./cem-utilities.js";
import { getComponents } from "cem-utils";
import { updateConfig } from "configurations";
export function generateVsCodeCustomElementData(customElementsManifest, options) {
    options = updateConfig(options);
    const components = getComponents(customElementsManifest, options.exclude);
    if (!components.length) {
        logRed("[custom-element-vs-code-integration] - No components found.");
        return;
    }
    const htmlTags = options.htmlFileName ? getTagList(components, options.referencesTemplate) : [];
    const cssProperties = options.cssFileName
        ? getCssPropertyList(components, options.cssSets)
        : [];
    const cssParts = options.cssFileName ? getCssPartList(components) : [];
    saveCustomDataFiles(options, htmlTags, cssProperties, cssParts);
}
function saveCustomDataFiles(options, tags, cssProperties, cssParts) {
    createOutDir(options.outdir);
    if (options.htmlFileName) {
        saveFile(options.outdir, options.htmlFileName, getCustomHtmlDataFileContents(tags));
    }
    if (options.cssFileName) {
        saveFile(options.outdir, options.cssFileName, getCustomCssDataFileContents(cssProperties, cssParts));
    }
}
function getCustomHtmlDataFileContents(tags) {
    return `{
      "$schema": "https://raw.githubusercontent.com/microsoft/vscode/master/extensions/html-language-features/server/src/htmlTags.schema.json",
      "version": 1.1,
      "tags": ${JSON.stringify(tags)}
    }`;
}
function getCustomCssDataFileContents(properties, parts) {
    return `{
      "$schema": "https://raw.githubusercontent.com/microsoft/vscode/master/extensions/css-language-features/server/src/data/browsers.schema.json",
      "version": 1.1,
      "properties": ${JSON.stringify(properties)},
      "pseudoElements": ${JSON.stringify(parts)}
    }`;
}
