import * as schema from 'custom-elements-manifest';

interface BaseOptions {
    /** Path to output directory */
    outdir?: string;
    /** Class names of any components you would like to exclude from the custom data */
    exclude?: string[];
    /** The property name from the component object that you would like to use for the description of your component */
    descriptionSrc?: "description" | "summary";
    /** Displays the slot section of the element description */
    hideSlotDocs?: boolean;
    /** Displays the event section of the element description */
    hideEventDocs?: boolean;
    /** Displays the CSS custom properties section of the element description */
    hideCssPropertiesDocs?: boolean;
    /** Displays the CSS parts section of the element description */
    hideCssPartsDocs?: boolean;
    /** Displays the methods section of the element description */
    hideMethodDocs?: boolean;
    /** Overrides the default section labels in the component description */
    labels?: DescriptionLabels;
    /** The property form your CEM component object to display your types */
    typesSrc?: string;
}
interface DescriptionLabels {
    slots?: string;
    events?: string;
    cssProperties?: string;
    cssParts?: string;
    methods?: string;
}

/**
 * CEM TYPES
 */

interface CssProperty extends schema.CssCustomProperty {
  type?: {
    text?: string;
  }
}

interface Component extends schema.CustomElementDeclaration {
  cssProperties?: CssProperty[];
  members?: Array<schema.ClassMember>;
}

interface CustomModule extends schema.JavaScriptModule {
    /**
   * The declarations of a module.
   *
   * For documentation purposes, all declarations that are reachable from
   * exports should be described here. Ie, functions and objects that may be
   * properties of exported objects, or passed as arguments to functions.
   */
    declarations?: Array<Component>;
}

interface CEM extends schema.Package {
  /**
   * An array of the modules this package contains.
   */
  modules: Array<CustomModule>;
}

interface Options extends BaseOptions {
  /** Name of the file with you component's custom HTML data */
  htmlFileName?: string | null;
  /** Name of the file with you component's custom CSS data */
  cssFileName?: string | null;
  /** Creates reusable CSS values for consistency in components */
  cssSets?: CssSet[];
  /** Used to create an array of links within the component info bubble */
  referencesTemplate?: (name: string, tag?: string) => Reference[];
  /** Adds a prefix to tag references */
  prefix?: string;
  /** Adds a suffix to tag references */
  suffix?: string;
}

interface CssSet {
  name: string;
  values: CssValue[] | string[];
}

interface CssValue {
  name: string;
  description?: string;
}

interface Reference {
  name: string;
  url: string;
}

interface CemAnalyzerParams {
  customElementsManifest: CEM;
}

declare function generateVsCodeCustomElementData(customElementsManifest: CEM, options: Options): void;

declare function customElementVsCodePlugin(params?: Options): {
    name: string;
    packageLinkPhase({ customElementsManifest }: CemAnalyzerParams): void;
};

export { Options, customElementVsCodePlugin, generateVsCodeCustomElementData };
