# posthtml-urls [![NPM Version][npm-image]][npm-url] [![Build Status][travis-image]][travis-url] [![Dependency Status][david-image]][david-url]
> PostHTML plugin for transforming URLs.


## Installation

[Node.js](http://nodejs.org/) `>= 4` is required. To install, type this at the command line:

```shell
npm install posthtml-urls
```


## Usage

```js
const posthtml = require('posthtml');
const urls = require('posthtml-urls');

const options = {
  eachURL: function(url, attr, element) {
    return `http://domain.com/${url}`;
  }	
};

posthtml()
.use( urls(options) )
.process('<a href="link.html">link</a>')
.then(result => console.log(result.html));

//-> <a href="http://domain.com/link.html">link</a>
```


## Options

### `options.eachURL`
Type: `Function`  
Default value: `undefined`  
A callback function ran for each URL value found. You can return either a synchronous value or a `Promise`.

### `options.filter`
Type: `Object`  
Default value: […](https://github.com/posthtml/posthtml-urls/blob/master/lib/defaultOptions.js#L5-L29)  
The elements and attributes for which to search. An attribute value can optionally be a function, for deeper filtering.


## FAQ
1. **How can I filter `<style>` elements and `style` attributes?**  
Use [posthtml-postcss](https://npmjs.com/posthtml-postcss) and [postcss-url](https://npmjs.com/postcss-url).


[npm-image]: https://img.shields.io/npm/v/posthtml-urls.svg
[npm-url]: https://npmjs.org/package/posthtml-urls
[travis-image]: https://img.shields.io/travis/posthtml/posthtml-urls.svg
[travis-url]: https://travis-ci.org/posthtml/posthtml-urls
[david-image]: https://img.shields.io/david/posthtml/posthtml-urls.svg
[david-url]: https://david-dm.org/posthtml/posthtml-urls