import { E as EgwApp } from '../../chunks/etemplate2-6fea04a8.js';
import '../../chunks/egw_json-39123901.js';
import '../../vendor/bower-asset/jquery/dist/jquery.min.js';
import '../../vendor/bower-asset/cropper/dist/cropper.min.js';
import '../../vendor/tinymce/tinymce/tinymce.min.js';

/**
 * EGroupware Preferences
 *
 * @link https://www.egroupware.org
 * @author Ralf Becker <rb-At-egroupware.org>
 * @package preferences
 */
/**
 * JavaScript for Preferences
 *
 * @augments AppJS
 */
class PreferencesApp extends EgwApp {
  /**
   * Constructor
   *
   */
  constructor() {
    // call parent
    super("preferences");
  }

  /**
   * This function is called when the etemplate2 object is loaded
   * and ready.  If you must store a reference to the et2 object,
   * make sure to clean it up in destroy().
   *
   * @param et2 etemplate2 Newly ready object
   * @param name
   */
  et2_ready(et2, name) {
    // call parent
    super.et2_ready(et2, name);
  }
  addToken(_ev, _button) {
    this.openDialog('preferences.EGroupware\\Preferences\\Token.edit');
  }
  editToken(_action, _selection) {
    this.openDialog('preferences.EGroupware\\Preferences\\Token.edit&token_id=' + _selection[0].id.split('::')[1]);
  }
  refreshToken(_msg, _type) {
    this.et2.getWidgetById('token').refresh(); // refresh token NM
    this.egw.refresh(_msg, _type);
  }
}

// @ts-ignore
app.classes.preferences = PreferencesApp;

export { PreferencesApp };
//# sourceMappingURL=app.min.js.map
