# VIDOTEACH
**Video-based Interactive Didactics & Observation for Teaching and Coaching**

VIDOTEACH is an innovative open-source tool for video-based analysis, commenting, and reflection on teaching and learning processes. It is designed to support teacher education, instructional coaching, and higher education didactics through time-coded annotations and structured peer feedback.

---

## Note on Name Change

**VIDOTEACH** is the continued and consolidated development of two previous tools:  
**smallPART** (Small-scale Process Analysis & Reflection Tool) and **Live Feedback**.  
Both tools were developed in academic contexts and have now been unified under the new name **VIDOTEACH** to reflect their expanded functionality and broader educational applications.

---

## Features

- **Interactive video analysis** with timestamped markers and comments
- **Time-coded peer feedback** for teaching videos and presentations
- **Synchronous and asynchronous usage** (e.g., in internships, seminars, professional training)
- **Easy LMS integration** via LTI 1.1 & 1.3
- **Full LTI 1.3 compliance** including Deep Linking & Names/Roles Provisioning
- **Automatic course and user registration** via LTI or OpenID Connect
- **GDPR-compliant data storage** via EGroupware hosting
- **Integration with external user directories** (e.g., LDAP, Active Directory, UCS, Shibboleth, OpenID Connect)
- **Shibboleth / SAML authentication integration**
- **Server-side ACL enforcement** for all user actions
- **Hardened Content Security Policy** (no inline JavaScript)
- **Flexible video source management** using WebDAV/EGroupware VFS or external URLs
- **Partial integration with external video repositories** (e.g., Opencast, YouTube)
- **REST API interface** (for integration with external systems and services)

---

## Project Partners (Didactic and Conceptual Development)

- **Rhineland-Palatinate Technical University (RPTU), Kaiserslautern-Landau**
    - Prof. Dr. Leo van Waveren
- **University of Education Freiburg**
    - Prof. Dr. Christoph Thyssen (formerly RPTU)
- **EGroupware GmbH**
    - Arash Tolou, M.A. (formerly RPTU)
- **Eberhard Karls University of Tübingen**
    - until 31 December 2020, under the name "Live Feedback Plus"

---

## Technical Roadmap – ✅ Implemented and Planned Features

- [x] Interactive video player with time-coded markers and comments
- [x] Comment categories and tag-based filtering
- [x] Anonymous or user-linked feedback options
- [x] Marker types for focused feedback (e.g., "question", "highlight", "critique")
- [x] Flexible video source management: upload, link, or stream via WebDAV
- [x] Integration with EGroupware user management (ACL, sessions)
- [x] Role management (admin, reviewer, participant)
- [x] Storage of video files in the EGroupware Virtual File System (VFS)
- [x] Basic LTI 1.1 support for LMS integration (e.g., Moodle, OpenOLAT)
- [x] Export of feedback data (e.g., CSV, PDF report formats)
- [x] Full LTI 1.3 compliance including Deep Linking & Names/Roles Provisioning
- [x] Automatic course and user registration via LTI or OpenID Connect
- [x] Shibboleth / SAML authentication integration
- [x] Hardened Content Security Policy (no inline JavaScript)
- [x] Server-side ACL enforcement for all user actions
- [x] Integration with external video repositories (e.g., Opencast, YouTube API)
- [ ] Bi-directional LTI integration: return of feedback to LMS
- [ ] Comment evaluation and rating features (e.g., helpfulness scores)
- [ ] Comment threads and reply options
- [ ] Improved UX/UI with responsive design and accessibility (WCAG 2.1)
- [ ] Real-time collaboration features (e.g., live marking during video playback)

---

## Security

- Server-side permission checks (ACL)
- Protection against browser console manipulation (no client-side editing)
- Compliant with modern web security standards (e.g., CSP)

---

## Resources

- [VIDOTEACH website](https://www.vidoteach.de)
- [EGroupware Wiki – Integration & Configuration](https://github.com/EGroupware)
- [LTI Specification v1.3](https://www.imsglobal.org/spec/lti/v1p3)
- [EduAppCenter – LTI Tools Directory](https://www.eduappcenter.com)
- [Example Moodle Integration](https://moodle.org)

---

## Example Configuration (For smallPART Compatibility)

```nginx
# smallPART / VIDOTEACH video storage path
location /egroupware/smallpart/Resources/Videos {
    alias /var/lib/egroupware/default/files/smallpart;
}
```
