import '../../chunks/egw_json-39123901.js';
import { E as EgwApp, c as Et2Dialog, g as et2_createWidget } from '../../chunks/etemplate2-6fea04a8.js';
import '../../vendor/bower-asset/jquery/dist/jquery.min.js';
import '../../vendor/bower-asset/cropper/dist/cropper.min.js';
import '../../vendor/tinymce/tinymce/tinymce.min.js';

function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class statusApp extends EgwApp {
  /**
   * Constructor
   *
   * @memberOf app.status
   */
  constructor() {
    // call parent
    super('status');
    _defineProperty(this, "_ring", null);
  }

  /**
   * Destructor
   */
  destroy(_app) {
    // call parent
    super.destroy(_app);
  }

  /**
   * This function is called when the etemplate2 object is loaded
   * and ready.  If you must store a reference to the et2 object,
   * make sure to clean it up in destroy().
   *
   * @param {etemplate2} _et2 newly ready object
   * @param {string} _name template name
   */
  et2_ready(_et2, _name) {
    var _url$match;
    // call parent
    super.et2_ready(_et2, _name);
    switch (_name) {
      case 'status.index':
        if (egw.preference('ringtone', 'status')) {
          this._ring = new Audio('status/assets/ring.mp3');
          var self = this;
          jQuery('body').one('click', function () {
            self._controllRingTone().initiate();
          });
        }
        break;
      case 'status.room':
        var room = this.et2.getArrayMgr('content').getEntry('room');
        var url = this.et2.getArrayMgr('content').getEntry('frame');
        var end = this.et2.getDOMWidgetById('end');
        var isModerator = (_url$match = url.match(/isModerator\=(1|true)/i)) !== null && _url$match !== void 0 ? _url$match : false;
        if (isModerator) {
          end.set_disabled(false);
        }
        if (url.match(/\&error\=/i) || !isModerator && this.et2.getArrayMgr('content').getEntry('restrict')) {
          this.et2.getDOMWidgetById('add').set_disabled(true);
          break;
        }
        egw(window.opener).setSessionItem('status', 'videoconference-session', room);
        window.addEventListener("beforeunload", function () {
          window.opener.sessionStorage.removeItem('status-videoconference-session');
        }, false);
        break;
    }
  }

  /**
   * Handle a push notification about entry changes from the websocket
   *
   * @param  pushData
   * @param {string} pushData.app application name
   * @param {(string|number)} pushData.id id of entry to refresh or null
   * @param {string} pushData.type either 'update', 'edit', 'delete', 'add' or null
   * - update: request just modified data from given rows.  Sorting is not considered,
   *		so if the sort field is changed, the row will not be moved.
   * - edit: rows changed, but sorting may be affected.  Requires full reload.
   * - delete: just delete the given rows clientside (no server interaction neccessary)
   * - add: requires full reload for proper sorting
   * @param {object|null} pushData.acl Extra data for determining relevance.  eg: owner or responsible to decide if update is necessary
   * @param {number} pushData.account_id User that caused the notification
   */
  push(pushData) {
    // EPL/calls does NOT care about other apps data
    if (pushData.app !== 'stylite' || pushData.type === 'delete' || typeof pushData.acl === 'undefined') return;
    var self = this;
    egw.accountData([pushData.acl.account_id, pushData.acl.account_id2], 'account_lid', null, function (account) {
      var content = [{
        id: account[pushData.acl.account_id],
        class3: pushData.acl.account_id && pushData.acl.busy ? 'on-phone' : '',
        title3: pushData.acl.account_id && pushData.acl.busy ? account[pushData.acl.account_id] + ' ' + egw.lang('is busy on the phone') : ''
      }];
      if (pushData.acl.account_id2) {
        content.push({
          id: account[pushData.acl.account_id2],
          class3: pushData.acl.account_id2 && pushData.acl.busy ? 'on-phone' : ''
        });
      }
      self.mergeContent(content);
    }, egw);
  }

  /**
   * Handle executed action on selected row and refresh the list
   *
   * @param {type} _action
   * @param {type} _selected
   */
  handle_actions(_action, _selected) {
    var data = _selected[0]['data'];
    var fav = egw.preference('fav', 'status') || {};
    var favorites = Object.keys(fav).map(key => fav[key]);
    switch (_action.id) {
      case 'fav':
        favorites.push(data.account_id);
        egw.set_preference('status', 'fav', favorites);
        break;
      case 'unfavorite':
        for (var i in favorites) {
          if (favorites[i] == data.account_id) favorites.splice(i, 1);
        }
        egw.set_preference('status', 'fav', favorites);
        break;
      case 'mail':
        if (typeof data.account_id == "string" && data.account_id.match(/:/) && data.link_to) {
          egw.json("EGroupware\\Status\\Ui::ajax_getContactofLink", ["rocketchat", data.account_id], function (contact) {
            if (contact) {
              egw.open('', 'mail', 'add', {
                'preset[mailto]': +contact[0]['email']
              });
            }
          }).sendRequest();
        } else {
          egw.accountData(data.account_id, 'account_email', null, function (_data) {
            egw.open('', 'mail', 'add', {
              'preset[mailto]': _data[data.account_id]
            });
          }, this);
        }
        break;
      case 'audiocall':
      case 'call':
        this.makeCall([{
          id: data.account_id,
          name: data.hint,
          avatar: "account:" + data.account_id,
          audioonly: _action.id == 'audiocall',
          data: data
        }]);
        break;
      case 'invite':
        this.inviteToCall([{
          id: data.account_id,
          name: data.hint,
          avatar: "account:" + data.account_id,
          audioonly: _action.id == 'audiocall',
          data: data
        }], egw.getSessionItem('status', 'videoconference-session'));
    }
    this.refresh();
  }

  /**
   * Dialog for selecting users and add them to the favorites
   */
  add_to_fav() {
    var list = this.et2.getArrayMgr('content').getEntry('list');
    var self = this;
    var dialog = new Et2Dialog(this.egw);
    dialog.transformAttributes({
      callback: function callback(_button_id, _value) {
        if (_button_id == 'add' && _value) {
          for (var i in _value.accounts) {
            var added = false;
            for (var j in list) {
              if (list[j] && list[j]['account_id'] == _value.accounts[i]) {
                added = true;
                self.handle_actions({
                  id: 'fav'
                }, [{
                  data: list[j]
                }]);
              }
            }
            if (!added) {
              self.handle_actions({
                id: 'fav'
              }, [{
                data: {
                  account_id: _value.accounts[i]
                }
              }]);
            }
          }
        }
      },
      title: this.egw.lang('Add to favorites'),
      buttons: [{
        label: this.egw.lang("Add"),
        id: "add",
        class: "ui-priority-primary",
        default: true,
        image: "add"
      }, {
        label: this.egw.lang("Cancel"),
        id: "cancel",
        image: "cancel"
      }],
      value: {
        content: {
          value: ''
        }
      },
      template: egw.webserverUrl + '/status/templates/default/search_list.xet',
      resizable: false,
      width: 400
    });
    document.body.appendChild(dialog);
  }

  /**
   * Refresh the list
   */
  refresh() {
    var self = this;
    // give it a delay to make sure the preferences data is updated before refreshing
    window.setTimeout(function () {
      egw.json('EGroupware\\Status\\Ui::ajax_refresh', [], function (_data) {
        if (self.et2) self.updateContent(_data.fav, _data.list);
      }).sendRequest();
    }, 200);
  }

  /**
   * Update content of fav and list girds
   * @param {array} _fav
   * @param {array} _list
   */
  updateContent(_fav, _list) {
    var fav = this.et2.getWidgetById('fav');
    var content = this.et2.getArrayMgr('content');
    var list = this.et2.getWidgetById('list');
    var isEqual = function isEqual(_a, _b) {
      if (_a.length != _b.length) return false;
      for (var i in _a) {
        if (JSON.stringify(_a[i]) != JSON.stringify(_b[i])) return false;
      }
      return true;
    };
    if (_fav && typeof _fav != 'undefined' && !isEqual(fav.getArrayMgr('content').data, _fav)) {
      fav.set_value({
        content: _fav
      });
      content.data['fav'] = _fav;
    }
    if (_list && typeof _list != 'undefined' && !isEqual(list.getArrayMgr('content').data, _list)) {
      list.set_value({
        content: _list
      });
      content.data['list'] = _list;
    }
    this.et2.setArrayMgr('content', content);
  }

  /**
   * Merge given content with existing ones and updates the lists
   *
   * @param {array} _content
   * @param {boolean} _topList if true it pushes the content to top of the list
   */
  mergeContent(_content, _topList) {
    var fav = JSON.parse(JSON.stringify(this.et2.getArrayMgr('content').getEntry('fav')));
    var list = JSON.parse(JSON.stringify(this.et2.getArrayMgr('content').getEntry('list')));
    for (var i in _content) {
      for (var f in fav) {
        if (fav[f] && fav[f]['id'] && _content[i]['id'] == fav[f]['id']) {
          jQuery.extend(true, fav[f], _content[i]);
        }
      }
      for (var l in list) {
        if (list[l] && list[l]['id'] && _content[i]['id'] == list[l]['id']) {
          jQuery.extend(true, list[l], _content[i]);
          if (_topList || _content[i]['stat1'] > 0) list.splice(1, 0, list.splice(l, 1)[0]);
        }
      }
    }
    this.updateContent(fav, list);
  }
  getEntireList() {
    var fav = this.et2.getArrayMgr('content').getEntry('fav');
    var list = this.et2.getArrayMgr('content').getEntry('list');
    var result = [];
    for (var f in fav) {
      if (fav[f] && fav[f]['id']) result.push(fav[f]);
    }
    for (var l in list) {
      if (list[l] && list[l]['id']) result.push(list[l]);
    }
    return result;
  }
  isOnline(_action, _selected) {
    var _selected$0$data$data, _selected$0$data$data2, _app$rocketchat;
    return !(((_selected$0$data$data = _selected[0].data.data) === null || _selected$0$data$data === void 0 || (_selected$0$data$data = _selected$0$data$data.rocketchat) === null || _selected$0$data$data === void 0 ? void 0 : _selected$0$data$data.type) == 'c') && (((_selected$0$data$data2 = _selected[0].data.data) === null || _selected$0$data$data2 === void 0 || (_selected$0$data$data2 = _selected$0$data$data2.status) === null || _selected$0$data$data2 === void 0 ? void 0 : _selected$0$data$data2.active) || ((_app$rocketchat = app.rocketchat) === null || _app$rocketchat === void 0 ? void 0 : _app$rocketchat.isRCActive(_action, _selected)));
  }

  /**
   * Initiate call via action
   * @param data
   */
  makeCall(data) {
    var callCancelled = false;
    var self = this;
    var button = [{
      "button_id": 0,
      "label": egw.lang('Cancel'),
      id: '0',
      image: 'cancel'
    }];
    var dialog = new Et2Dialog(this.egw);
    dialog.transformAttributes({
      callback: function callback(_btn) {
        if (_btn == Et2Dialog.CANCEL_BUTTON) {
          callCancelled = true;
        }
      },
      title: 'Initiating call to',
      buttons: button,
      resizable: false,
      value: {
        content: {
          list: data
        }
      },
      template: egw.webserverUrl + '/status/templates/default/call.xet'
    });
    document.body.appendChild(dialog);
    setTimeout(function () {
      if (!callCancelled) {
        dialog.destroy();
        egw.json("EGroupware\\Status\\Videoconference\\Call::ajax_video_call", [data, data[0]['room']], function (_url) {
          var _app$rocketchat2;
          if (_url && _url.msg) {
            egw.message(_url.msg.message, _url.msg.type);
          }
          if (_url.caller) {
            self.openCall(_url.caller);
          }
          if ((_app$rocketchat2 = app.rocketchat) !== null && _app$rocketchat2 !== void 0 && _app$rocketchat2.isRCActive(null, [{
            data: data[0].data
          }])) {
            app.rocketchat.restapi_call('chat_PostMessage', {
              roomId: data[0].data.data.rocketchat._id,
              attachments: [{
                "collapsed": false,
                "color": "#009966",
                "title": egw.lang("Click to Join!"),
                "title_link": _url.callee,
                "thumb_url": "https://raw.githubusercontent.com/EGroupware/status/master/templates/default/images/videoconference_call.svg"
              }]
            });
          }
        }).sendRequest();
      }
    }, 3000);
  }

  /**
   * Open call url with respecting opencallin preference
   * @param _url call url
   */
  openCall(_url) {
    var link = egw.link('/index.php', {
      menuaction: 'status.\\EGroupware\\Status\\Ui.room',
      frame: _url
    });
    if (egw.preference('opencallin', statusApp.appname) == '1') {
      egw.open_link(link, '_blank');
    } else {
      egw.openPopup(link, 800, 600, '', 'status');
    }
  }
  scheduled_receivedCall(_content, _notify) {
    var buttons = [{
      "button_id": 1,
      "label": egw.lang('Join'),
      id: '1',
      image: 'accept_call',
      default: true
    }, {
      "button_id": 0,
      "label": egw.lang('Close'),
      id: '0',
      image: 'close'
    }];
    var notify = _notify || true;
    var content = _content || {};
    var self = this;
    this._controllRingTone().start();
    var dialog = new Et2Dialog(this.egw);
    dialog.transformAttributes({
      callback: function callback(_btn, value) {
        if (_btn == Et2Dialog.OK_BUTTON) {
          self.openCall(value.url);
        }
      },
      title: '',
      buttons: buttons,
      isModal: false,
      position: "right bottom,right-100 bottom-10",
      value: {
        content: content
      },
      resizable: false,
      template: egw.webserverUrl + '/status/templates/default/scheduled_call.xet'
    });
    document.body.appendChild(dialog);
    if (notify) {
      egw.notification(this.egw.lang('Status'), {
        body: this.egw.lang('You have a video conference meeting in %1 minutes, initiated by %2', content['alarm-offset'] / 60, content.owner),
        icon: egw.webserverUrl + '/api/avatar.php?account_id=' + content.account_id,
        onclick: function onclick() {
          window.focus();
        },
        requireInteraction: true
      });
    }
  }

  /**
   * gets called after receiving pushed call
   * @param _data
   * @param _notify
   * @param _buttons
   * @param _message_top
   * @param _message_bottom
   */
  receivedCall(_data, _notify, _buttons, _message_top, _message_bottom) {
    var buttons = _buttons || [{
      "button_id": 1,
      "text": egw.lang('Accept'),
      id: '1',
      image: 'accept_call',
      default: true
    }, {
      "button_id": 0,
      "text": egw.lang('Reject'),
      id: '0',
      image: 'hangup'
    }];
    var notify = _notify !== null && _notify !== void 0 ? _notify : true;
    var message_bottom = _message_bottom || '';
    var message_top = _message_top || '';
    var self = this;
    var isCallAnswered = false;
    window.setTimeout(function () {
      if (!isCallAnswered) {
        egw.json("EGroupware\\Status\\Videoconference\\Call::ajax_setMissedCallNotification", [_data], function () {}).sendRequest();
        egw.accountData(_data.caller.account_id, 'account_lid', null, function (account) {
          self.mergeContent([{
            id: account[_data.caller.account_id],
            class1: 'missed-call'
          }]);
        }, egw);
        dialog.destroy();
      }
    }, statusApp.MISSED_CALL_TIMEOUT);
    this._controllRingTone().start(true);
    var dialog = new Et2Dialog(this.egw);
    dialog.transformAttributes({
      callback: function callback(_btn) {
        if (_btn == Et2Dialog.OK_BUTTON) {
          self.openCall(_data.call);
          isCallAnswered = true;
        }
      },
      title: 'Call from',
      buttons: buttons,
      isModal: false,
      position: "right bottom, right bottom",
      value: {
        content: {
          list: [{
            "name": _data.caller.name,
            "avatar": "account:" + _data.caller.account_id
          }],
          "message_buttom": egw.lang(message_bottom),
          "message_top": egw.lang(message_top),
          "url": _data.call
        }
      },
      resizable: false,
      template: egw.webserverUrl + '/status/templates/default/call.xet',
      dialogClass: "recievedCall"
    });
    dialog.addEventListener('close', _ => self._controllRingTone().stop());
    document.body.appendChild(dialog);
    if (notify) {
      egw.notification(this.egw.lang('Status'), {
        body: this.egw.lang('You have a call from %1', _data.caller.name),
        icon: egw.webserverUrl + '/api/avatar.php?account_id=' + _data.caller.account_id,
        onclick: function onclick() {
          window.focus();
        },
        requireInteraction: true
      });
    }
  }
  _controllRingTone() {
    var self = this;
    return {
      start: function start(_loop) {
        if (!self._ring) return;
        self._ring.loop = _loop || false;
        self._ring.muted = false;
        self._ring.play().then(function () {
          window.setTimeout(function () {
            self._controllRingTone().stop();
          }, statusApp.MISSED_CALL_TIMEOUT); // stop ringing automatically
        }, function (_error) {
          console.log('Error happened: ' + _error);
        });
      },
      stop: function stop() {
        if (!self._ring) return;
        self._ring.pause();
      },
      initiate: function initiate() {
        self._ring.muted = true;
        self._ring.play().then(function () {}, function (_error) {
          console.log('Error happened: ' + _error);
        });
        this.stop();
      }
    };
  }
  didNotPickUp(_data) {
    var self = this;
    Et2Dialog.show_dialog(function (_btn) {
      if (Et2Dialog.YES_BUTTON == _btn) {
        self.makeCall([_data]);
      }
    }, this.egw.lang('%1 did not pickup your call, would you like to try again?', _data.name), '');
  }

  /**
   * Missed callback dialog
   * @param _from
   * @param _url
   */
  _phoneMissedCallback(_from, _url) {
    var self = this;
    return Et2Dialog.show_dialog(function (_btn) {
      if (_btn == Et2Dialog.YES_BUTTON) {
        egw.message(egw.lang("Calling back %1 ...", _from));
        var url = et2_createWidget('url-phone', {
          id: 'temp_url_phone',
          readonly: true
        }, self.et2);
        url.set_value(_url);
        url.click();
        url.destroy();
      }
      self.mergeContent([{
        id: _from,
        class2: '',
        action2: ''
      }]);
    }, "Would you like to callback?", "Missed call", null, Et2Dialog.BUTTONS_YES_NO);
  }
  phoneCall(_action, _selected) {
    var _data$data$status, _data$data$status2, _data$data$status3, _data$data$status4;
    var data = _selected[0]['data'];
    var target = '';
    switch (_action.id) {
      case 'addressbook_tel_work':
        target = (_data$data$status = data.data.status) === null || _data$data$status === void 0 ? void 0 : _data$data$status.tel_work;
        break;
      case 'addressbook_tel_cell':
        target = (_data$data$status2 = data.data.status) === null || _data$data$status2 === void 0 ? void 0 : _data$data$status2.tel_cell;
        break;
      case 'addressbook_tel_prefer':
        target = (_data$data$status3 = data.data.status) === null || _data$data$status3 === void 0 ? void 0 : _data$data$status3.tel_prefer;
        break;
      case 'addressbook_tel_home':
        target = (_data$data$status4 = data.data.status) === null || _data$data$status4 === void 0 ? void 0 : _data$data$status4.tel_home;
        break;
    }
    if (target) {
      var url = et2_createWidget('url-phone', {
        id: 'temp_url_phone',
        readonly: true
      }, this.et2);
      url.set_value(target);
      url.click();
      url.destroy();
    }
  }
  phoneIsAvailable(_action, _selected) {
    var _data$data, _data$data$status5, _data$data$status6, _data$data$status7, _data$data$status8;
    var data = _selected[0]['data'];
    if (!((_data$data = data.data) !== null && _data$data !== void 0 && _data$data.status)) return false;
    switch (_action.id) {
      case 'addressbook_tel_work':
        if ((_data$data$status5 = data.data.status) !== null && _data$data$status5 !== void 0 && _data$data$status5.tel_work) return true;
        break;
      case 'addressbook_tel_cell':
        if ((_data$data$status6 = data.data.status) !== null && _data$data$status6 !== void 0 && _data$data$status6.tel_cell) return true;
        break;
      case 'addressbook_tel_prefer':
        if ((_data$data$status7 = data.data.status) !== null && _data$data$status7 !== void 0 && _data$data$status7.tel_prefer) return true;
        break;
      case 'addressbook_tel_home':
        if ((_data$data$status8 = data.data.status) !== null && _data$data$status8 !== void 0 && _data$data$status8.tel_home) return true;
        break;
    }
    return false;
  }
  videoconference_invite() {
    var url = this.et2.getArrayMgr('content').getEntry('frame');
    var dialog = new Et2Dialog(this.egw);
    dialog.transformAttributes({
      callback: function callback(_button_id, _value) {
        if (_button_id == 'add' && _value) {
          var data = [];
          for (var i in _value.accounts) {
            data.push({
              id: _value.accounts[i],
              name: '',
              avatar: "account:" + _value.accounts[i]
            });
          }
          egw.json("EGroupware\\Status\\Videoconference\\Call::ajax_video_call", [data, statusApp.videoconference_fetchRoomFromUrl(url), true, true], function (_data) {
            if (_data && _data.msg) egw(window).message(_data.msg.message, _data.msg.type);
          }).sendRequest();
        }
      },
      title: this.egw.lang('Invite to this meeting'),
      buttons: [{
        label: this.egw.lang("Invite"),
        id: "add",
        class: "ui-priority-primary",
        default: true
      }, {
        label: this.egw.lang("Cancel"),
        id: "cancel"
      }],
      value: {
        content: {
          value: ''
        }
      },
      template: egw.webserverUrl + '/status/templates/default/search_list.xet',
      resizable: false,
      width: 400
    });
    document.body.appendChild(dialog);
  }

  /**
   * end session
   * @private
   */
  videoconference_endMeeting() {
    var _url$match2;
    var room = this.et2.getArrayMgr('content').getEntry('room');
    var url = this.et2.getArrayMgr('content').getEntry('frame');
    var isModerator = (_url$match2 = url.match(/isModerator\=(1|true)/i)) !== null && _url$match2 !== void 0 ? _url$match2 : false;
    if (isModerator) {
      Et2Dialog.show_dialog(function (_b) {
        if (_b == 1) {
          egw(window).loading_prompt(room, true, egw.lang('Ending the session ...'));
          egw.json("EGroupware\\Status\\Videoconference\\Call::ajax_deleteRoom", [room, url], function () {
            egw(window).loading_prompt(room, false);
          }).sendRequest();
          return true;
        }
      }, "This window will end the session for everyone, are you sure want this?", "End Meeting", {}, Et2Dialog.BUTTONS_OK_CANCEL, Et2Dialog.WARNING_MESSAGE);
    }
  }

  /**
   * @param _room
   */
  videoconference_getRecordings(_room, _params) {
    egw.openPopup(egw.link('/index.php', {
      menuaction: 'status.\\EGroupware\\Status\\Ui.vc_recordings',
      room: _room,
      cal_id: _params['cal_id'],
      title: _params['title']
    }), 800, 450, 'recordings', 'status');
  }
  static videoconference_fetchRoomFromUrl(_url) {
    if (_url) {
      return _url.split(/\?jwt/)[0].split('/').pop();
    }
    return null;
  }
  isThereAnyCall(_action, _selected) {
    return this.isOnline(_action, _selected) && egw.getSessionItem('status', 'videoconference-session');
  }
  inviteToCall(_data, _room) {
    egw.json("EGroupware\\Status\\Videoconference\\Call::ajax_video_call", [_data, _room, true, true], function (_data) {
      if (_data && _data.msg) egw(window).message(_data.msg.message, _data.msg.type);
    }).sendRequest();
  }
  videoconference_countdown_finished() {
    var join = this.et2.getWidgetById('join');
    join.set_disabled(false);
  }
  videoconference_countdown_join() {
    var content = this.et2.getArrayMgr('content');
    egw.json("EGroupware\\Status\\Videoconference\\Call::ajax_genMeetingUrl", [content.getEntry('room'), {
      name: egw.user('account_fullname'),
      account_id: egw.user('account_id'),
      email: egw.user('account_email'),
      cal_id: content.getEntry('cal_id')
    }, content.getEntry('start'), content.getEntry('end')], function (_data) {
      if (_data) {
        if (_data.err) egw.message(_data.err, 'error');
        if (_data.url) app.status.openCall(_data.url);
      }
    }).sendRequest();
    window.parent.close();
  }
  vc_deleteRecording(_event, _widget) {
    var recordings = this.et2.getArrayMgr('content').getEntry('recordings');
    var id = _widget.id.replace('delete', '');
    recordings[id]['cal_id'] = this.et2.getArrayMgr('content').getEntry('cal_id');
    egw.json('EGroupware\\Status\\Ui::ajax_vc_deleteRecording', recordings[id], function (_data) {
      if (_data['success']) {
        this.et2.getInstanceManager().submit();
      } else {
        egw.message(_data['error'], 'error');
      }
    }.bind(this)).sendRequest();
  }
}
_defineProperty(statusApp, "appname", 'status');
_defineProperty(statusApp, "MISSED_CALL_TIMEOUT", egw.preference('ringingtimeout', 'status') ? parseInt(egw.preference('ringingtimeout', 'status')) * 1000 : 15000);
app.classes.status = statusApp;
//# sourceMappingURL=app.min.js.map
