import * as puppeteerCore from 'puppeteer-core';
import { Browser, Page, PuppeteerNodeLaunchOptions, BrowserContext } from 'puppeteer-core';
import { BrowserLauncher, TestRunnerCoreConfig } from '@web/test-runner-core';
import { ChromeLauncherPage } from './ChromeLauncherPage.js';
interface CreateArgs {
    browser: Browser;
    config: TestRunnerCoreConfig;
}
export type CreateBrowserContextFn = (args: CreateArgs) => BrowserContext | Promise<BrowserContext>;
export type CreatePageFn = (args: CreateArgs & {
    context: BrowserContext;
}) => Promise<Page>;
export declare class ChromeLauncher implements BrowserLauncher {
    name: string;
    type: string;
    concurrency?: number;
    private launchOptions;
    private customPuppeteer?;
    private createBrowserContextFn;
    private createPageFn;
    private config?;
    private testFiles?;
    private browser?;
    private browserContext?;
    private debugBrowser?;
    private debugBrowserContext?;
    private cachedExecutablePath?;
    private activePages;
    private activeDebugPages;
    private inactivePages;
    private __startBrowserPromise?;
    constructor(launchOptions: PuppeteerNodeLaunchOptions, createBrowserContextFn: CreateBrowserContextFn, createPageFn: CreatePageFn, customPuppeteer?: typeof puppeteerCore, concurrency?: number);
    initialize(config: TestRunnerCoreConfig, testFiles: string[]): Promise<void>;
    launchBrowser(options?: PuppeteerNodeLaunchOptions): Promise<puppeteerCore.Browser>;
    startBrowser(options?: PuppeteerNodeLaunchOptions): Promise<{
        browser: puppeteerCore.Browser;
        context: puppeteerCore.BrowserContext;
    }>;
    stop(): Promise<void>;
    startSession(sessionId: string, url: string): Promise<void>;
    isActive(sessionId: string): boolean;
    getBrowserUrl(sessionId: string): string;
    startDebugSession(sessionId: string, url: string): Promise<void>;
    createNewPage(browser: Browser, context: BrowserContext): Promise<ChromeLauncherPage>;
    stopSession(sessionId: string): Promise<import("@web/test-runner-core").SessionResult>;
    private getOrStartBrowser;
    getPage(sessionId: string): puppeteerCore.Page;
}
export {};
//# sourceMappingURL=ChromeLauncher.d.ts.map