import * as schema from 'custom-elements-manifest';

interface BaseOptions {
    /** Path to output directory */
    outdir?: string;
    /** Class names of any components you would like to exclude from the custom data */
    exclude?: string[];
    /** The property name from the component object that you would like to use for the description of your component */
    descriptionSrc?: "description" | "summary";
    /** Displays the slot section of the element description */
    hideSlotDocs?: boolean;
    /** Displays the event section of the element description */
    hideEventDocs?: boolean;
    /** Displays the CSS custom properties section of the element description */
    hideCssPropertiesDocs?: boolean;
    /** Displays the CSS parts section of the element description */
    hideCssPartsDocs?: boolean;
    /** Displays the methods section of the element description */
    hideMethodDocs?: boolean;
    /** Overrides the default section labels in the component description */
    labels?: DescriptionLabels;
    /** The property form your CEM component object to display your types */
    typesSrc?: string;
}
interface DescriptionLabels {
    slots?: string;
    events?: string;
    cssProperties?: string;
    cssParts?: string;
    methods?: string;
}

/**
 * CEM TYPES
 */

interface CssProperty extends schema.CssCustomProperty {
  type?: {
    text?: string;
  }
}

interface Component extends schema.CustomElementDeclaration {
  cssProperties?: CssProperty[];
  members?: Array<schema.ClassMember>;
}

interface CustomModule extends schema.JavaScriptModule {
    /**
   * The declarations of a module.
   *
   * For documentation purposes, all declarations that are reachable from
   * exports should be described here. Ie, functions and objects that may be
   * properties of exported objects, or passed as arguments to functions.
   */
    declarations?: Array<Component>;
}

interface CEM extends schema.Package {
  /**
   * An array of the modules this package contains.
   */
  modules: Array<CustomModule>;
}

/**
 * WEB-TYPE
 */

interface Options extends BaseOptions {
  /** Name of the file for your custom data */
  webTypesFileName?: string | null;
  /** Excludes any custom element documentation */
  excludeHtml?: boolean;
  /** Excludes any custom CSS documentation */
  excludeCss?: boolean;
  /** Adds a prefix to tag references */
  prefix?: string;
  /** Adds a suffix to tag references */
  suffix?: string;
  /** Used to create a link within the component info bubble */
  referenceTemplate?: (name: string, tag?: string) => Reference;
}

interface Params {
  customElementsManifest: CEM;
}

interface Reference {
  name: string;
  url: string;
}

declare function generateJetBrainsWebTypes(customElementsManifest: CEM, options: Options): void;

declare function customElementJetBrainsPlugin(options?: Options): {
    name: string;
    packageLinkPhase({ customElementsManifest }: Params): void;
};

export { Options, customElementJetBrainsPlugin, generateJetBrainsWebTypes };
