/* eslint-disable @typescript-eslint/no-explicit-any */
const componentReferences = {};
export function setComponentReferences(ts, node, moduleDoc) {
    if (node.kind !== ts.SyntaxKind.ClassDeclaration) {
        return;
    }
    const references = getReferences(node);
    updateReferences(references, node, moduleDoc);
}
export function getReferencesByComponent(componentName) {
    var _a;
    return (_a = componentReferences[componentName]) !== null && _a !== void 0 ? _a : [];
}
function getReferences(node) {
    const docs = getDocsByTagName(node, "reference");
    return docs === null || docs === void 0 ? void 0 : docs.map((tags) => tags === null || tags === void 0 ? void 0 : tags.map((doc) => {
        const values = doc === null || doc === void 0 ? void 0 : doc.comment.split(/ - (.*)/s);
        if (values && values.length > 1) {
            return {
                name: values[0].trim(),
                url: values[1].trim(),
            };
        }
    })).flat();
}
function updateReferences(references, node, moduleDoc) {
    var _a;
    if (!(references === null || references === void 0 ? void 0 : references.length)) {
        return;
    }
    const className = node.name.getText();
    const component = (_a = moduleDoc === null || moduleDoc === void 0 ? void 0 : moduleDoc.declarations) === null || _a === void 0 ? void 0 : _a.find((dec) => dec.name === className);
    componentReferences[component.name] = references;
}
function getDocsByTagName(node, tagName) {
    var _a;
    return (_a = node === null || node === void 0 ? void 0 : node.jsDoc) === null || _a === void 0 ? void 0 : _a.map((doc) => { var _a; return (_a = doc === null || doc === void 0 ? void 0 : doc.tags) === null || _a === void 0 ? void 0 : _a.filter((tag) => { var _a; return ((_a = tag === null || tag === void 0 ? void 0 : tag.tagName) === null || _a === void 0 ? void 0 : _a.getText()) === tagName; }); });
}
