"use strict";
const defaultOptions = 
{
	filter:
	{
		a:          { href:true, ping:true },
		applet:     { archive:true, code:true, codebase:true, object:true, src:true },
		area:       { href:true, ping:true },
		audio:      { src:true },
		base:       { href:true },
		blockquote: { cite:true },
		body:       { background:true },
		button:     { formaction:true },
		del:        { cite:true },
		embed:      { src:true },
		frame:      { longdesc:true, src:true },
		form:       { action:true },
		head:       { profile:true },
		html:       { manifest:true },
		iframe:     { longdesc:true, src:true },
		img:        { longdesc:true, src:true, srcset:true },
		input:      { formaction:true, src:true },
		ins:        { cite:true },
		link:       { href:true },
		menuitem:   { icon:true },
		meta:       { content:isHttpEquiv },
		object:     { codebase:true, data:true },
		q:          { cite:true },
		script:     { src:true },
		source:     { src:true, srcset:true },
		table:      { background:true },
		tbody:      { background:true },
		td:         { background:true },
		tfoot:      { background:true },
		th:         { background:true },
		thead:      { background:true },
		tr:         { background:true },
		track:      { src:true },
		video:      { poster:true, src:true }
	}
};



function isHttpEquiv(node, attrName)
{
	const httpEquiv = node.attrs["http-equiv"];

	return httpEquiv!=null && httpEquiv.toLowerCase()==="refresh";
}



module.exports = defaultOptions;
